<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns="urn:hl7-org:v3" xmlns:sdtc="urn:hl7-org:sdtc" xmlns:voc="urn:hl7-org:v3/voc" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:hl7-org:v3 http://xreg2.nist.gov:8080/hitspValidation/schema/cdar2c32/infrastructure/cda/C32_CDA.xsd" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"   xmlns:ms="urn:schemas-microsoft-com:xslt"  xmlns:dt="urn:schemas-microsoft-com:datatypes">
	<xsl:output method="xml" omit-xml-declaration="no" indent="yes"/>
	<xsl:template match="CCD">
		<ClinicalDocument xmlns="urn:hl7-org:v3" xmlns:voc="urn:hl7-org:v3/voc" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:hl7-org:v3 http://healthinfo.med.dal.ca/hl7intro/CDA_R2_NormativeWebEdition/infrastructure/cda/CDA.xsd">
			<!-- QRDA Header -->
			<realmCode code="US"/>
			<typeId root="2.16.840.1.113883.1.3" extension="POCD_HD000040"/>
			<!-- US Realm Header Template Id -->
			<templateId root="2.16.840.1.113883.10.20.22.1.1"/>
			<!-- QRDA templateId -->
			<templateId root="2.16.840.1.113883.10.20.24.1.1"/>
			<!-- QDM-based QRDA templateId -->
			<templateId root="2.16.840.1.113883.10.20.24.1.2"/>
			<!-- This is the globally unique identifier for this QRDA document -->
			<id root="5b010313-eff2-432c-9909-6193d8416fac"/>
			<!-- QRDA document type code -->
			<xsl:apply-templates select="//Header"/>
			<xsl:apply-templates select="//Documentationof"/>
			<component>
				<structuredBody>
					<component>
						<section>
							<!-- 
								*****************************************************************
								Measure Section
								*****************************************************************
							-->
							<!-- This is the templateId for Measure Section -->
							<templateId root="2.16.840.1.113883.10.20.24.2.2"/>
							<!-- This is the templateId for Measure Section QDM -->
							<templateId root="2.16.840.1.113883.10.20.24.2.3"/>
							<!-- This is the LOINC code for "Measure document". This stays the same for all measure section required by QRDA standard -->
							<code code="55186-1" codeSystem="2.16.840.1.113883.6.1"/>
							<title>Measure Section</title>
							<!-- EHR QRDA measure-specific template ID for each measure in this Section -->
							<xsl:apply-templates select="//MeasureHeader"/>
						</section>
					</component>
					<component>
						<section>
							<!-- This is the templateId for Reporting Parameters section -->
							<templateId root="2.16.840.1.113883.10.20.17.2.1"/>
							<code code="55187-9" codeSystem="2.16.840.1.113883.6.1"/>
							<title>Reporting Parameters</title>
							<text>
								<list>
									<item>
										Reporting period: <xsl:value-of select="messageStartDate" />  To <xsl:value-of select="messageEndDate" />
									</item>
								</list>
							</text>
							<entry typeCode="DRIV">
								<act classCode="ACT" moodCode="EVN">
									<!-- This is the templateId for Reporting Parameteres Act -->
									<templateId root="2.16.840.1.113883.10.20.17.3.8"/>
									<code code="252116004" codeSystem="2.16.840.1.113883.6.96" displayName="Observation Parameters"/>
									<effectiveTime>
										<low>
											<xsl:attribute name="value">
												<xsl:value-of select="messageStartDate" />
											</xsl:attribute>
										</low>
										<!-- The first day of the period reported. -->
										<high >
											<xsl:attribute name="value">
												<xsl:value-of select="messageEndDate" />
											</xsl:attribute>
										</high>
										<!-- The last day of the period reported. -->
									</effectiveTime>
								</act>
							</entry>
						</section>
					</component>
					<component>
						<section>
							<!-- This is the templateId for Patient Data section -->
							<templateId root="2.16.840.1.113883.10.20.17.2.4"/>
							<!-- This is the templateId for Patient Data QDM section -->
							<templateId root="2.16.840.1.113883.10.20.24.2.1"/>
							<code code="55188-7" codeSystem="2.16.840.1.113883.6.1"/>
							<title>Patient Data</title>
							<text></text>
							<xsl:apply-templates select="//Encounters"/>
							<xsl:apply-templates select="//Problems"/>
							<xsl:apply-templates select="//Procedure"/>
							<xsl:apply-templates select="//Intervention"/>
							<xsl:apply-templates select="//Medication"/>
							<xsl:apply-templates select="//Immunizations"/>
							<xsl:apply-templates select="//Result"/>
							<xsl:apply-templates select="//PhysicalExams"/>
							<xsl:apply-templates select="//Communications"/>
							<xsl:apply-templates select="//DiagnosticStudys"/>
							<xsl:apply-templates select="//FunctionalStatus"/>
							<xsl:apply-templates select="//AdvanceDirective"/>
							<!--<xsl:apply-templates select="//Equipment"/>-->
							<xsl:apply-templates select="//Plan"/>
							<!--<xsl:apply-templates select="//Social"/>-->
							<!--<xsl:apply-templates select="//FamilyHistory"/>-->
							<!--<xsl:apply-templates select="//Payer"/>-->
							<!-- <xsl:apply-templates select="//Alerts"/>-->
							<!--<xsl:apply-templates select="//Vital"/>-->
							<!--<xsl:apply-templates select="//Structural"/>-->

						</section>
					</component>
				</structuredBody>
			</component>
		</ClinicalDocument>
	</xsl:template>
	<xsl:template name="Header"  match="//Header">
		<code code="55182-0" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" displayName="Quality Measure Report"/>
		<title>QRDA Incidence Report</title>
		<!-- This is the document creation time -->
		<effectiveTime>
			<xsl:attribute name="value">
				<xsl:value-of select="DocumentDateTime" />
			</xsl:attribute>
		</effectiveTime>
		<confidentialityCode code="N" codeSystem="2.16.840.1.113883.5.25"/>
		<languageCode code="en-US"/>
		<!-- reported patient -->
		<recordTarget>
			<patientRole>
				<!-- patient SSN -->
				<xsl:if test="//patient/ssn != ''">
					<id root="2.16.840.1.113883.4.1">
						<xsl:attribute name="extension">
							<xsl:value-of select="patient/ssn" />
						</xsl:attribute>
					</id>
				</xsl:if >
				<xsl:if test="//patient/ssn = ''">
					<id root="2.16.840.1.113883.4.1" extension="111111111">
					</id>
				</xsl:if >
				<xsl:if test="//patient/address/streetAddress1 != ''">
					<addr use="HP">
						<streetAddressLine>
							<xsl:value-of select="//patient/address/streetAddress1"/>
						</streetAddressLine>
						<xsl:if test="//patient/address/city != ''">
							<city>
								<xsl:value-of select="//patient/address/city"/>
							</city>
						</xsl:if >
						<xsl:if test="//patient/address/state != ''">
							<state>
								<xsl:value-of select="//patient/address/state"/>
							</state>
						</xsl:if >
						<xsl:if test="//patient/address/postalCode != ''">
							<postalCode>
								<xsl:value-of select="//patient/address/postalCode"/>
							</postalCode>
						</xsl:if >
						<xsl:if test="//patient/address/country != ''">
							<country>
								<xsl:value-of select="//patient/address/country"/>
							</country>
						</xsl:if >
					</addr>
				</xsl:if >
				<xsl:if test="//patient/phonenumber != ''">
					<telecom use="WP">
						<xsl:attribute name="value">
							<xsl:value-of select="//patient/phonenumber" />
						</xsl:attribute>
					</telecom>
				</xsl:if >
				<patient>
					<name use="L">
						<given>
							<xsl:value-of select="//patient/name/given"/>
						</given>
						<family>
							<xsl:value-of select="//patient/name/family"/>
						</family>
					</name>
					<administrativeGenderCode codeSystem="2.16.840.1.113883.5.1">
						<xsl:attribute name="code">
							<xsl:value-of select="//patient/genderCode" />
						</xsl:attribute>
					</administrativeGenderCode>
					<birthTime>
						<xsl:attribute name="value">
							<xsl:value-of select="//patient/birthTime" />
						</xsl:attribute>
					</birthTime>
					<xsl:if test="//patient/raceCode != ''">
						<raceCode codeSystem="2.16.840.1.113883.6.238" code="2131-1">
							<xsl:attribute name="code">
								<xsl:value-of select="//patient/raceCode" />
							</xsl:attribute>
						</raceCode>
					</xsl:if>
					<xsl:if test="//patient/raceCode = ''">
						<raceCode codeSystem="2.16.840.1.113883.6.238" code="2131-1">
						</raceCode>
					</xsl:if>
					<xsl:if test="//patient/ethnicGroupCode != ''">
						<ethnicGroupCode codeSystem="2.16.840.1.113883.6.238">
							<xsl:attribute name="code">
								<xsl:value-of select="//patient/ethnicGroupCode" />
							</xsl:attribute>
						</ethnicGroupCode>
					</xsl:if>
					<xsl:if test="//patient/ethnicGroupCode = ''">
						<ethnicGroupCode codeSystem="2.16.840.1.113883.6.238" code="2186-5">
						</ethnicGroupCode>
					</xsl:if>
					<languageCommunication>
						<templateId root="2.16.840.1.113883.3.88.11.83.2" assigningAuthorityName="HITSP/C83"/>
						<templateId root="1.3.6.1.4.1.19376.1.5.3.1.2.1" assigningAuthorityName="IHE/PCC"/>
						<languageCode code="en-US"/>
					</languageCommunication>
				</patient>
			</patientRole>
		</recordTarget>
		<!-- Example of an author who is a device -->
		<author>
			<time value="20080401"/>
			<assignedAuthor>
				<id extension="110001" root="2.16.840.1.113883.19.5"/>
				<!--APRIMA INFO-->
				<addr>
					<streetAddressLine>3330 Keller Springs Rd., Suite 201</streetAddressLine>
					<city>Carrollton</city>
					<state>TX </state>
					<postalCode>75006</postalCode>
					<country>US</country>
				</addr>
				<telecom use="WP" value="tel:(214)-466-8107"/>
				<assignedAuthoringDevice>
					<manufacturerModelName>PRM</manufacturerModelName >
					<softwareName>Aprima</softwareName >
				</assignedAuthoringDevice >
			</assignedAuthor>
			<!--APRIMA INFO-->
		</author>
		<!--<informant>
			<assignedEntity>
				<id nullFlavor="NA"/>
				<representedOrganization>
					<id root="2.16.840.1.113883.19.5"/>
					<name>
						<xsl:value-of select="//organization/name"/>
					</name>
				</representedOrganization>
			</assignedEntity>
		</informant>-->
		<custodian>
			<assignedCustodian>
				<representedCustodianOrganization>
					<id root="2.16.840.1.113883.19.5"/>
					<name>
						<xsl:value-of select="//organization/name"/>
					</name>
					<telecom use="WP">
						<xsl:attribute name="value">
							<xsl:value-of select="//organization/phonenumber" />
						</xsl:attribute>
					</telecom>
					<addr use="HP">
						<streetAddressLine>
							<xsl:value-of select="//organization/address/streetAddress1"/>
						</streetAddressLine>
						<xsl:if test="//organization/address/city != ''">
							<city>
								<xsl:value-of select="//organization/address/city"/>
							</city>
						</xsl:if >
						<xsl:if test="//organization/address/state != ''">
							<state>
								<xsl:value-of select="//organization/address/city"/>
							</state>
						</xsl:if >
						<xsl:if test="//organization/address/postalCode != ''">
							<postalCode>
								<xsl:value-of select="//organization/address/postalCode"/>
							</postalCode>
						</xsl:if >
						<xsl:if test="//organization/address/country != ''">
							<country>
								<xsl:value-of select="//organization/address/country"/>
							</country>
						</xsl:if >
					</addr>
				</representedCustodianOrganization>
			</assignedCustodian>
		</custodian>
		<legalAuthenticator>
			<time value="20100121185118" />
			<signatureCode code="S" />
			<assignedEntity>
				<id nullFlavor="NI" />
				<!--Adress of provider-->
				<addr use="HP">
					<streetAddressLine>
						<xsl:value-of select="//patient/provider/address/streetAddress1"/>
					</streetAddressLine>
					<xsl:if test="//patient/provider/address/city != ''">
						<city>
							<xsl:value-of select="//patient/provider/address/city"/>
						</city>
					</xsl:if >
					<xsl:if test="//patient/provider/address/state != ''">
						<state>
							<xsl:value-of select="//patient/provider/address/city"/>
						</state>
					</xsl:if >
					<xsl:if test="//patient/provider/address/postalCode != ''">
						<postalCode>
							<xsl:value-of select="//patient/provider/address/postalCode"/>
						</postalCode>
					</xsl:if >
					<xsl:if test="//patient/provider/address/country != ''">
							<country>
								<xsl:value-of select="//patient/provider/address/country"/>
							</country>
					</xsl:if >
				</addr>
				<telecom use="WP">
					<xsl:attribute name="value">
						<xsl:value-of select="//patient/provider/phonenumber" />
					</xsl:attribute>
				</telecom>
				<assignedPerson>
					<name>
						<given>
							<xsl:value-of select="//patient/provider/name/given"/>
						</given>
						<family>
							<xsl:value-of select="//patient/provider/name/family"/>
						</family>
					</name>
				</assignedPerson>
				<!--Adress of provider-->
				<representedOrganization>
					<id root="2.16.840.1.113883.19.5" />
					<name>
						<xsl:value-of select="//organization/name"/>
					</name>

				</representedOrganization>
			</assignedEntity>
		</legalAuthenticator>

	</xsl:template>
	<!--TODO: This is where the provider information will go. CCN is currently hard coded, but should be replaced with the providers-->
	<xsl:template name="Documentationof"  match="//Documentationof">
		<xsl:if test ="//Documentationof-CPTS/questionCode != '' or //Documentationof-SNOMED/questionCode != '' or //Documentationof-ICD9/questionCode != '' or //Documentationof-ICD10/questionCode != ''">
			<documentationOf typeCode="DOC">
				<serviceEvent classCode="PCPR">
					<!-- care provision -->
					<effectiveTime>
						<low value="20100425">
							<xsl:attribute name="value">
								<xsl:value-of select="//messageStartDate" />
							</xsl:attribute>
						</low>
						<high value="20100425">
							<xsl:attribute name="value">
								<xsl:value-of select="//messageEndDate"/>
							</xsl:attribute>
						</high>
					</effectiveTime>

					<!-- We can include multiple performers, each with an NPI, TIN, CCN. -->
					<!--Here we have only one Provider so getting from header part-->
					<performer typeCode="PRF">
						<time>
							<low>
								<xsl:attribute name="value">
									<xsl:value-of select="//messageStartDate" />
								</xsl:attribute>
							</low>
							<high>
								<xsl:attribute name="value">
									<xsl:value-of select="//messageEndDate" />
								</xsl:attribute>
							</high>
						</time>
						<assignedEntity>
							<!-- This is the provider NPI -->
							<id root="2.16.840.1.113883.4.6">
								<xsl:attribute name="extension">
									<xsl:value-of select="//patient/provider/providerNPI/value" />
								</xsl:attribute>
							</id>
							<representedOrganization>
								<!-- This is the organization TIN -->
								<!--provider TIN -->
								<id root="2.16.840.1.113883.4.2" >
									<xsl:attribute name="extension">
										<xsl:value-of select="//patient/provider/providerTPIN/value" />
									</xsl:attribute>
								</id>
								<!-- This is the organization CCN - DUMMY-->
								<id root="2.16.840.1.113883.4.336" extension="54321" />
							</representedOrganization>
						</assignedEntity>
					</performer>
				</serviceEvent>
			</documentationOf>
		</xsl:if>
	</xsl:template>
	<!--Measure header-->
	<xsl:template name="MeasureHeader"  match="//MeasureHeader">
		<text>
			<table border="1" width="100%">
				<thead>
					<tr>
						<th>eMeasure Title</th>
						<th>Version neutral identifier</th>
						<th>eMeasure Version Number</th>
						<th>NQF eMeasure Number</th>
						<th>Version specific identifier</th>
					</tr>
				</thead>
				<tbody>
					<xsl:for-each select="//Measures">

						<xsl:if test="MeasureID= '1'">
							<tr>
								<td>Preventive Care and Screening: Screening for Clinical Depression and Follow-Up Plan</td>
								<td>9A031E24-3D9B-11E1-8634-00237D5BF174</td>
								<td>2</td>
								<td>5162fb1ebae2781495e5c62d</td>
								<td>8A4D92B2-3AE8-F461-013A-F4E544D7003E</td>
								<td></td>
							</tr>
						</xsl:if >
						<xsl:if test="MeasureID= '2'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '3'">
							<tr>
								<td>Closing the referral loop: receipt of specialist report</td>
								<td>F58FC0D6-EDF5-416A-8D29-79AFBFD24DEA</td>
								<td>1</td>
								<td>5162fb1ebae2781495e5c640</td>
								<td>8A4D92B2-356D-A09E-0135-C5FFA8972292</td>
								<td></td>
							</tr>
						</xsl:if >
						<xsl:if test="MeasureID= '4'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '5'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '6'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '7'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '8'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '9'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '10'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '11'">
							<tr>
								<td>Documentation of Current Medications in the Medical Record</td>
								<td>9A032D9C-3D9B-11E1-8634-00237D5BF174</td>
								<td>2</td>
								<td>5162fb1ebae2781495e5c62e</td>
								<td>8A4D92B2-3B79-4CE2-013B-906DFFF52068</td>
								<td></td>
							</tr>
						</xsl:if >
						<xsl:if test="MeasureID= '12'">
							<tr>
								<td>Preventive Care and Screening: Body Mass Index (BMI) Screening and Follow-Up</td>
								<td>9A031BB8-3D9B-11E1-8634-00237D5BF174</td>
								<td>1</td>
								<td>5162fb1ebae2781495e5c62f</td>
								<td>8A4D92B2-3A00-2A25-013A-4B927224747D</td>
								<td></td>
							</tr>
						</xsl:if >
						<xsl:if test="MeasureID= '13'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '14'">
							<tr>
								<td>Children Who Have Dental Decay or Cavities</td>
								<td>61947125-4376-4A7B-AB7A-AC2BE9BD9138</td>
								<td>1</td>
								<td>5162fb1ebae2781495e5c63c</td>
								<td>8A4D92B2-370B-19FA-0137-282DDBCF35DC</td>
								<td></td>
							</tr>
						</xsl:if >
						<xsl:if test="MeasureID= '15'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '16'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '17'">
							<tr>
								<td>Functional Status Assessment for Complex Chronic Conditions</td>
								<td>BB9B8EF7-0354-40E0-BEC7-D6891B7DF519</td>
								<td>2</td>
								<td>5162fb1ebae2781495e5c645</td>
								<td>8A4D92B2-3B79-4CE2-013B-904950F61CB7</td>
								<td></td>
							</tr>
						</xsl:if >
						<xsl:if test="MeasureID= '18'">
							<tr>
								<td>Childhood Immunization Status</td>
								<td>B2802B7A-3580-4BE8-9458-921AEA62B78C</td>
								<td>1</td>
								<td>5162fb1dbae2781495e5c609</td>
								<td>8A4D92B2-39CA-AF4B-0139-CAE9ED8A01BD</td>
								<td></td>
							</tr>
						</xsl:if >
						<xsl:if test="MeasureID= '19'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '20'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '21'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '22'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '23'">
							<tr>
								<td>Use of Appropriate Medications for Asthma</td>
								<td>59E84144-6332-4369-AEBD-03A7899CA3DA</td>
								<td>1</td>
								<td>5162fb1cbae2781495e5c604</td>
								<td>8A4D92B2-397A-48D2-0139-C648B33D5582</td>
								<td></td>
							</tr>
						</xsl:if >
						<xsl:if test="MeasureID= '24'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '25'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '26'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '27'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '28'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '29'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '30'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '31'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '32'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '33'">
							<tr>
								<td>ADHD: Follow-Up Care for Children Prescribed Attention-Deficit/Hyperactivity Disorder (ADHD) Medication</td>
								<td>703CC49B-B653-4885-80E8-245A057F5AE9</td>
								<td>2</td>
								<td>5162fb1dbae2781495e5c622</td>
								<td>8A4D92B2-397A-48D2-0139-9BB3331F4C02</td>
								<td></td>
							</tr>
						</xsl:if >
						<xsl:if test="MeasureID= '34'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '35'">
							<tr>
								<td>Preventive Care and Screening: Tobacco Use: Screening and Cessation Intervention</td>
								<td>E35791DF-5B25-41BB-B260-673337BC44A8</td>
								<td>1</td>
								<td>5162fb1cbae2781495e5c5fd</td>
								<td>8A4D92B2-3946-CDAE-0139-77DE6F785ED7</td>
								<td></td>
							</tr>
						</xsl:if >
						<xsl:if test="MeasureID= '36'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '37'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '38'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '39'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '40'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '41'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '42'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '43'">
							<tr>
								<td>Appropriate Testing for Children with Pharyngitis</td>
								<td>BEB1C33C-2549-4E7F-9567-05ED38448464</td>
								<td>1</td>
								<td>5162fb1cbae2781495e5c5ea</td>
								<td>8A4D92B2-3946-CDAE-0139-77F580AE6690</td>
								<td></td>
							</tr>
						</xsl:if >
						<xsl:if test="MeasureID= '44'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '45'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '46'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '47'">
							<tr>
								<td>Chlamydia Screening for Women</td>
								<td>C9930664-BE3D-4FFE-AE4A-5CF4933ECB89</td>
								<td>1</td>
								<td>5162fb1cbae2781495e5c600</td>
								<td>8A4D92B2-397A-48D2-0139-B0CC617E335D</td>
								<td></td>
							</tr>
						</xsl:if >
						<xsl:if test="MeasureID= '48'">
							<tr>
								<td>Appropriate Treatment for Children with Upper Respiratory Infection (URI)</td>
								<td>E455FAC0-F2CB-4074-A351-1E68A90FB7CF</td>
								<td>1</td>
								<td>5162fb1dbae2781495e5c614</td>
								<td>8A4D92B2-3946-CDAE-0139-77FE9FDC6853</td>
								<td></td>
							</tr>
						</xsl:if >
						<xsl:if test="MeasureID= '49'">
							<tr>
								<td>Weight Assessment and Counseling for Nutrition and Physical Activity for Children and Adolescents</td>
								<td>0B63F730-25D6-4248-B11F-8C09C66A04EB</td>
								<td>1</td>
								<td>5162fb1cbae2781495e5c5f4</td>
								<td>8A4D92B2-397A-48D2-0139-7CC6B5B8011E</td>
								<td></td>
							</tr>
						</xsl:if >
						<xsl:if test="MeasureID= '50'">
							<tr>
								<td>Use of High-Risk Medications in the Elderly</td>
								<td>A3837FF8-1ABC-4BA9-800E-FD4E7953ADBD</td>
								<td>1</td>
								<td>5162fb1cbae2781495e5c5f2</td>
								<td>8A4D92B2-3946-CDAE-0139-77E59FA3632E</td>
								<td></td>
							</tr>
						</xsl:if >
						<xsl:if test="MeasureID= '51'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '52'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '53'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '54'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '55'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '56'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '57'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '58'">
							<xsl:if test="MeasureID= '58'">
								<tr>
									<td>Controlling High Blood Pressure</td>
									<td>ABDC37CC-BAC6-4156-9B91-D1BE2C8B7268</td>
									<td>1</td>
									<td>5162fb1cbae2781495e5c5f1</td>
									<td>8A4D92B2-397A-48D2-0139-C6208B875109</td>
									<td></td>
								</tr>
							</xsl:if >
						</xsl:if >
						<xsl:if test="MeasureID= '59'">
							<tr>
								<td>Use of Imaging Studies for Low Back Pain</td>
								<td>B6016B47-B65D-4BE0-866F-1D397886CA89</td>
								<td>2</td>
								<td>5162fb1dbae2781495e5c60c</td>
								<td>8A4D92B2-39CA-AF4B-0139-D49A6C2A1DD7</td>
								<td></td>
							</tr>
						</xsl:if >
						<xsl:if test="MeasureID= '60'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '61'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '62'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '63'">
							<templateId root=""/>
						</xsl:if >
						<xsl:if test="MeasureID= '64'">
							<templateId root=""/>
						</xsl:if >
					</xsl:for-each>
				</tbody>
			</table>
		</text>
		<!-- 1..* Organizers, each containing a reference to an eMeasure -->
		<xsl:for-each select="//Measures">

			<xsl:if test="MeasureID= '1'">
				<entry>
					<organizer classCode="CLUSTER" moodCode="EVN">
						<!-- This is the templateId for Measure Reference -->
						<templateId root="2.16.840.1.113883.10.20.24.3.98"/>
						<!-- This is the templateId for eMeasure Reference QDM -->
						<templateId root="2.16.840.1.113883.10.20.24.3.97"/>
						<statusCode code="completed"/>
						<!-- Containing isBranch external references -->
						<reference typeCode="REFR">
							<externalDocument classCode="DOC" moodCode="EVN">
								<!-- SHALL: This is the version specific identifier for eMeasure: QualityMeasureDocument/id it is a GUID-->
								<id root="8A4D92B2-3AE8-F461-013A-F4E544D7003E"/>
								<!-- SHOULD This is the title of the eMeasure -->
								<text>Preventive Care and Screening: Screening for Clinical Depression and Follow-Up Plan</text>
								<!-- SHOULD: setId is the eMeasure version neutral id  -->
								<setId root="9A031E24-3D9B-11E1-8634-00237D5BF174"/>
								<!-- This is the sequential eMeasure Version number -->
								<versionNumber value="2"/>
							</externalDocument>
						</reference>
					</organizer>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '2'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '3'">
				<entry>
					<organizer classCode="CLUSTER" moodCode="EVN">
						<!-- This is the templateId for Measure Reference -->
						<templateId root="2.16.840.1.113883.10.20.24.3.98"/>
						<!-- This is the templateId for eMeasure Reference QDM -->
						<templateId root="2.16.840.1.113883.10.20.24.3.97"/>
						<statusCode code="completed"/>
						<!-- Containing isBranch external references -->
						<reference typeCode="REFR">
							<externalDocument classCode="DOC" moodCode="EVN">
								<!-- SHALL: This is the version specific identifier for eMeasure: QualityMeasureDocument/id it is a GUID-->
								<id root="8A4D92B2-356D-A09E-0135-C5FFA8972292"/>
								<!-- SHOULD This is the title of the eMeasure -->
								<text>Closing the referral loop: receipt of specialist report</text>
								<!-- SHOULD: setId is the eMeasure version neutral id  -->
								<setId root="F58FC0D6-EDF5-416A-8D29-79AFBFD24DEA"/>
								<!-- This is the sequential eMeasure Version number -->
								<versionNumber value="1"/>
							</externalDocument>
						</reference>
					</organizer>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '4'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '5'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '6'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '7'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '8'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '9'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '10'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '11'">
				<entry>
					<organizer classCode="CLUSTER" moodCode="EVN">
						<!-- This is the templateId for Measure Reference -->
						<templateId root="2.16.840.1.113883.10.20.24.3.98"/>
						<!-- This is the templateId for eMeasure Reference QDM -->
						<templateId root="2.16.840.1.113883.10.20.24.3.97"/>
						<statusCode code="completed"/>
						<!-- Containing isBranch external references -->
						<reference typeCode="REFR">
							<externalDocument classCode="DOC" moodCode="EVN">
								<!-- SHALL: This is the version specific identifier for eMeasure: QualityMeasureDocument/id it is a GUID-->
								<id root="8A4D92B2-3B79-4CE2-013B-906DFFF52068"/>
								<!-- SHOULD This is the title of the eMeasure -->
								<text>Documentation of Current Medications in the Medical Record</text>
								<!-- SHOULD: setId is the eMeasure version neutral id  -->
								<setId root="9A032D9C-3D9B-11E1-8634-00237D5BF174"/>
								<!-- This is the sequential eMeasure Version number -->
								<versionNumber value="2"/>
							</externalDocument>
						</reference>
					</organizer>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '12'">
				<entry>
					<organizer classCode="CLUSTER" moodCode="EVN">
						<!-- This is the templateId for Measure Reference -->
						<templateId root="2.16.840.1.113883.10.20.24.3.98"/>
						<!-- This is the templateId for eMeasure Reference QDM -->
						<templateId root="2.16.840.1.113883.10.20.24.3.97"/>
						<statusCode code="completed"/>
						<!-- Containing isBranch external references -->
						<reference typeCode="REFR">
							<externalDocument classCode="DOC" moodCode="EVN">
								<!-- SHALL: This is the version specific identifier for eMeasure: QualityMeasureDocument/id it is a GUID-->
								<id root="8A4D92B2-3A00-2A25-013A-4B927224747D"/>
								<!-- SHOULD This is the title of the eMeasure -->
								<text>Preventive Care and Screening: Body Mass Index (BMI) Screening and Follow-Up</text>
								<!-- SHOULD: setId is the eMeasure version neutral id  -->
								<setId root="9A031BB8-3D9B-11E1-8634-00237D5BF174"/>
								<!-- This is the sequential eMeasure Version number -->
								<versionNumber value="1"/>
							</externalDocument>
						</reference>
					</organizer>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '13'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '14'">
				<entry>
					<organizer classCode="CLUSTER" moodCode="EVN">
						<!-- This is the templateId for Measure Reference -->
						<templateId root="2.16.840.1.113883.10.20.24.3.98"/>
						<!-- This is the templateId for eMeasure Reference QDM -->
						<templateId root="2.16.840.1.113883.10.20.24.3.97"/>
						<statusCode code="completed"/>
						<!-- Containing isBranch external references -->
						<reference typeCode="REFR">
							<externalDocument classCode="DOC" moodCode="EVN">
								<!-- SHALL: This is the version specific identifier for eMeasure: QualityMeasureDocument/id it is a GUID-->
								<id root="8A4D92B2-370B-19FA-0137-282DDBCF35DC"/>
								<!-- SHOULD This is the title of the eMeasure -->
								<text>Children Who Have Dental Decay or Cavities</text>
								<!-- SHOULD: setId is the eMeasure version neutral id  -->
								<setId root="61947125-4376-4A7B-AB7A-AC2BE9BD9138"/>
								<!-- This is the sequential eMeasure Version number -->
								<versionNumber value="1"/>
							</externalDocument>
						</reference>
					</organizer>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '15'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '16'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '17'">
				<entry>
					<organizer classCode="CLUSTER" moodCode="EVN">
						<!-- This is the templateId for Measure Reference -->
						<templateId root="2.16.840.1.113883.10.20.24.3.98"/>
						<!-- This is the templateId for eMeasure Reference QDM -->
						<templateId root="2.16.840.1.113883.10.20.24.3.97"/>
						<statusCode code="completed"/>
						<!-- Containing isBranch external references -->
						<reference typeCode="REFR">
							<externalDocument classCode="DOC" moodCode="EVN">
								<!-- SHALL: This is the version specific identifier for eMeasure: QualityMeasureDocument/id it is a GUID-->
								<id root="8A4D92B2-3B79-4CE2-013B-904950F61CB7"/>
								<!-- SHOULD This is the title of the eMeasure -->
								<text>Functional Status Assessment for Complex Chronic Conditions</text>
								<!-- SHOULD: setId is the eMeasure version neutral id  -->
								<setId root="BB9B8EF7-0354-40E0-BEC7-D6891B7DF519"/>
								<!-- This is the sequential eMeasure Version number -->
								<versionNumber value="2"/>
							</externalDocument>
						</reference>
					</organizer>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '18'">
				<entry>
					<organizer classCode="CLUSTER" moodCode="EVN">
						<!-- This is the templateId for Measure Reference -->
						<templateId root="2.16.840.1.113883.10.20.24.3.98"/>
						<!-- This is the templateId for eMeasure Reference QDM -->
						<templateId root="2.16.840.1.113883.10.20.24.3.97"/>
						<statusCode code="completed"/>
						<!-- Containing isBranch external references -->
						<reference typeCode="REFR">
							<externalDocument classCode="DOC" moodCode="EVN">
								<!-- SHALL: This is the version specific identifier for eMeasure: QualityMeasureDocument/id it is a GUID-->
								<id root="8A4D92B2-39CA-AF4B-0139-CAE9ED8A01BD"/>
								<!-- SHOULD This is the title of the eMeasure -->
								<text>Childhood Immunization Status</text>
								<!-- SHOULD: setId is the eMeasure version neutral id  -->
								<setId root="B2802B7A-3580-4BE8-9458-921AEA62B78C"/>
								<!-- This is the sequential eMeasure Version number -->
								<versionNumber value="1"/>
							</externalDocument>
						</reference>
					</organizer>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '19'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '20'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '21'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '22'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '23'">
				<entry>
					<organizer classCode="CLUSTER" moodCode="EVN">
						<!-- This is the templateId for Measure Reference -->
						<templateId root="2.16.840.1.113883.10.20.24.3.98"/>
						<!-- This is the templateId for eMeasure Reference QDM -->
						<templateId root="2.16.840.1.113883.10.20.24.3.97"/>
						<statusCode code="completed"/>
						<!-- Containing isBranch external references -->
						<reference typeCode="REFR">
							<externalDocument classCode="DOC" moodCode="EVN">
								<!-- SHALL: This is the version specific identifier for eMeasure: QualityMeasureDocument/id it is a GUID-->
								<id root="8A4D92B2-397A-48D2-0139-C648B33D5582"/>
								<!-- SHOULD This is the title of the eMeasure -->
								<text>Use of Appropriate Medications for Asthma</text>
								<!-- SHOULD: setId is the eMeasure version neutral id  -->
								<setId root="59E84144-6332-4369-AEBD-03A7899CA3DA"/>
								<!-- This is the sequential eMeasure Version number -->
								<versionNumber value="1"/>
							</externalDocument>
						</reference>
					</organizer>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '24'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '25'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '26'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '27'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '28'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '29'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '30'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '31'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '32'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '33'">
				<entry>
					<organizer classCode="CLUSTER" moodCode="EVN">
						<!-- This is the templateId for Measure Reference -->
						<templateId root="2.16.840.1.113883.10.20.24.3.98"/>
						<!-- This is the templateId for eMeasure Reference QDM -->
						<templateId root="2.16.840.1.113883.10.20.24.3.97"/>
						<statusCode code="completed"/>
						<!-- Containing isBranch external references -->
						<reference typeCode="REFR">
							<externalDocument classCode="DOC" moodCode="EVN">
								<!-- SHALL: This is the version specific identifier for eMeasure: QualityMeasureDocument/id it is a GUID-->
								<id root="8A4D92B2-397A-48D2-0139-9BB3331F4C02"/>
								<!-- SHOULD This is the title of the eMeasure -->
								<text>ADHD: Follow-Up Care for Children Prescribed Attention-Deficit/Hyperactivity Disorder (ADHD) Medication</text>
								<!-- SHOULD: setId is the eMeasure version neutral id  -->
								<setId root="703CC49B-B653-4885-80E8-245A057F5AE9"/>
								<!-- This is the sequential eMeasure Version number -->
								<versionNumber value="2"/>
							</externalDocument>
						</reference>
					</organizer>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '34'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '35'">
				<entry>
					<organizer classCode="CLUSTER" moodCode="EVN">
						<!-- This is the templateId for Measure Reference -->
						<templateId root="2.16.840.1.113883.10.20.24.3.98"/>
						<!-- This is the templateId for eMeasure Reference QDM -->
						<templateId root="2.16.840.1.113883.10.20.24.3.97"/>
						<statusCode code="completed"/>
						<!-- Containing isBranch external references -->
						<reference typeCode="REFR">
							<externalDocument classCode="DOC" moodCode="EVN">
								<!-- SHALL: This is the version specific identifier for eMeasure: QualityMeasureDocument/id it is a GUID-->
								<id root="8A4D92B2-3946-CDAE-0139-77DE6F785ED7"/>
								<!-- SHOULD This is the title of the eMeasure -->
								<text>Preventive Care and Screening: Tobacco Use: Screening and Cessation Intervention</text>
								<!-- SHOULD: setId is the eMeasure version neutral id  -->
								<setId root="E35791DF-5B25-41BB-B260-673337BC44A8"/>
								<!-- This is the sequential eMeasure Version number -->
								<versionNumber value="1"/>
							</externalDocument>
						</reference>
					</organizer>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '36'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '37'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '38'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '39'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '40'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '41'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '42'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '43'">
				<entry>
					<organizer classCode="CLUSTER" moodCode="EVN">
						<!-- This is the templateId for Measure Reference -->
						<templateId root="2.16.840.1.113883.10.20.24.3.98"/>
						<!-- This is the templateId for eMeasure Reference QDM -->
						<templateId root="2.16.840.1.113883.10.20.24.3.97"/>
						<statusCode code="completed"/>
						<!-- Containing isBranch external references -->
						<reference typeCode="REFR">
							<externalDocument classCode="DOC" moodCode="EVN">
								<!-- SHALL: This is the version specific identifier for eMeasure: QualityMeasureDocument/id it is a GUID-->
								<id root="8A4D92B2-3946-CDAE-0139-77F580AE6690"/>
								<!-- SHOULD This is the title of the eMeasure -->
								<text>Appropriate Testing for Children with Pharyngitis</text>
								<!-- SHOULD: setId is the eMeasure version neutral id  -->
								<setId root="BEB1C33C-2549-4E7F-9567-05ED38448464"/>
								<!-- This is the sequential eMeasure Version number -->
								<versionNumber value="1"/>
							</externalDocument>
						</reference>
					</organizer>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '44'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '45'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '46'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '47'">
				<entry>
					<organizer classCode="CLUSTER" moodCode="EVN">
						<!-- This is the templateId for Measure Reference -->
						<templateId root="2.16.840.1.113883.10.20.24.3.98"/>
						<!-- This is the templateId for eMeasure Reference QDM -->
						<templateId root="2.16.840.1.113883.10.20.24.3.97"/>
						<statusCode code="completed"/>
						<!-- Containing isBranch external references -->
						<reference typeCode="REFR">
							<externalDocument classCode="DOC" moodCode="EVN">
								<!-- SHALL: This is the version specific identifier for eMeasure: QualityMeasureDocument/id it is a GUID-->
								<id root="8A4D92B2-397A-48D2-0139-B0CC617E335D"/>
								<!-- SHOULD This is the title of the eMeasure -->
								<text>Chlamydia Screening for Women</text>
								<!-- SHOULD: setId is the eMeasure version neutral id  -->
								<setId root="C9930664-BE3D-4FFE-AE4A-5CF4933ECB89"/>
								<!-- This is the sequential eMeasure Version number -->
								<versionNumber value="1"/>
							</externalDocument>
						</reference>
					</organizer>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '48'">
				<entry>
					<organizer classCode="CLUSTER" moodCode="EVN">
						<!-- This is the templateId for Measure Reference -->
						<templateId root="2.16.840.1.113883.10.20.24.3.98"/>
						<!-- This is the templateId for eMeasure Reference QDM -->
						<templateId root="2.16.840.1.113883.10.20.24.3.97"/>
						<statusCode code="completed"/>
						<!-- Containing isBranch external references -->
						<reference typeCode="REFR">
							<externalDocument classCode="DOC" moodCode="EVN">
								<!-- SHALL: This is the version specific identifier for eMeasure: QualityMeasureDocument/id it is a GUID-->
								<id root="8A4D92B2-3946-CDAE-0139-77FE9FDC6853"/>
								<!-- SHOULD This is the title of the eMeasure -->
								<text>Appropriate Treatment for Children with Upper Respiratory Infection (URI)</text>
								<!-- SHOULD: setId is the eMeasure version neutral id  -->
								<setId root="E455FAC0-F2CB-4074-A351-1E68A90FB7CF"/>
								<!-- This is the sequential eMeasure Version number -->
								<versionNumber value="1"/>
							</externalDocument>
						</reference>
					</organizer>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '49'">
				<entry>
					<organizer classCode="CLUSTER" moodCode="EVN">
						<!-- This is the templateId for Measure Reference -->
						<templateId root="2.16.840.1.113883.10.20.24.3.98"/>
						<!-- This is the templateId for eMeasure Reference QDM -->
						<templateId root="2.16.840.1.113883.10.20.24.3.97"/>
						<statusCode code="completed"/>
						<!-- Containing isBranch external references -->
						<reference typeCode="REFR">
							<externalDocument classCode="DOC" moodCode="EVN">
								<!-- SHALL: This is the version specific identifier for eMeasure: QualityMeasureDocument/id it is a GUID-->
								<id root="8A4D92B2-397A-48D2-0139-7CC6B5B8011E"/>
								<!-- SHOULD This is the title of the eMeasure -->
								<text>Weight Assessment and Counseling for Nutrition and Physical Activity for Children and Adolescents</text>
								<!-- SHOULD: setId is the eMeasure version neutral id  -->
								<setId root="0B63F730-25D6-4248-B11F-8C09C66A04EB"/>
								<!-- This is the sequential eMeasure Version number -->
								<versionNumber value="1"/>
							</externalDocument>
						</reference>
					</organizer>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '50'">
				<entry>
					<organizer classCode="CLUSTER" moodCode="EVN">
						<!-- This is the templateId for Measure Reference -->
						<templateId root="2.16.840.1.113883.10.20.24.3.98"/>
						<!-- This is the templateId for eMeasure Reference QDM -->
						<templateId root="2.16.840.1.113883.10.20.24.3.97"/>
						<statusCode code="completed"/>
						<!-- Containing isBranch external references -->
						<reference typeCode="REFR">
							<externalDocument classCode="DOC" moodCode="EVN">
								<!-- SHALL: This is the version specific identifier for eMeasure: QualityMeasureDocument/id it is a GUID-->
								<id root="8A4D92B2-3946-CDAE-0139-77E59FA3632E"/>
								<!-- SHOULD This is the title of the eMeasure -->
								<text>Use of High-Risk Medications in the Elderly</text>
								<!-- SHOULD: setId is the eMeasure version neutral id  -->
								<setId root="A3837FF8-1ABC-4BA9-800E-FD4E7953ADBD"/>
								<!-- This is the sequential eMeasure Version number -->
								<versionNumber value="1"/>
							</externalDocument>
						</reference>
					</organizer>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '51'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '52'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '53'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '54'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '55'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '56'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '57'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '58'">
				<entry>
					<organizer classCode="CLUSTER" moodCode="EVN">
						<!-- This is the templateId for Measure Reference -->
						<templateId root="2.16.840.1.113883.10.20.24.3.98"/>
						<!-- This is the templateId for eMeasure Reference QDM -->
						<templateId root="2.16.840.1.113883.10.20.24.3.97"/>
						<statusCode code="completed"/>
						<!-- Containing isBranch external references -->
						<reference typeCode="REFR">
							<externalDocument classCode="DOC" moodCode="EVN">
								<!-- SHALL: This is the version specific identifier for eMeasure: QualityMeasureDocument/id it is a GUID-->
								<id root="8A4D92B2-397A-48D2-0139-C6208B875109"/>
								<!-- SHOULD This is the title of the eMeasure -->
								<text>Controlling High Blood Pressure</text>
								<!-- SHOULD: setId is the eMeasure version neutral id  -->
								<setId root="ABDC37CC-BAC6-4156-9B91-D1BE2C8B7268"/>
								<!-- This is the sequential eMeasure Version number -->
								<versionNumber value="1"/>
							</externalDocument>
						</reference>
					</organizer>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '59'">
				<entry>
					<organizer classCode="CLUSTER" moodCode="EVN">
						<!-- This is the templateId for Measure Reference -->
						<templateId root="2.16.840.1.113883.10.20.24.3.98"/>
						<!-- This is the templateId for eMeasure Reference QDM -->
						<templateId root="2.16.840.1.113883.10.20.24.3.97"/>
						<statusCode code="completed"/>
						<!-- Containing isBranch external references -->
						<reference typeCode="REFR">
							<externalDocument classCode="DOC" moodCode="EVN">
								<!-- SHALL: This is the version specific identifier for eMeasure: QualityMeasureDocument/id it is a GUID-->
								<id root="8A4D92B2-39CA-AF4B-0139-D49A6C2A1DD7"/>
								<!-- SHOULD This is the title of the eMeasure -->
								<text>Use of Imaging Studies for Low Back Pain</text>
								<!-- SHOULD: setId is the eMeasure version neutral id  -->
								<setId root="B6016B47-B65D-4BE0-866F-1D397886CA89"/>
								<!-- This is the sequential eMeasure Version number -->
								<versionNumber value="2"/>
							</externalDocument>
						</reference>
					</organizer>
				</entry>
			</xsl:if >
			<xsl:if test="MeasureID= '60'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '61'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '62'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '63'">
				<templateId root=""/>
			</xsl:if >
			<xsl:if test="MeasureID= '64'">
				<templateId root=""/>
			</xsl:if >
		</xsl:for-each>
	</xsl:template>
	<!--We are not showing Diagnosis Active,Inactive  and Resolved separately-->
	<xsl:template name="Problems"  match="//Problems">
		<xsl:if test ="//Problem-ICD9/problemCode != '' or //Problem-ICD10/problemCode != '' or //Problem-SNOMED/problemCode != ''">
			<xsl:for-each select="//Problem-ICD9">
				<entry>
					<observation classCode="OBS" moodCode="EVN">
						<!--  Problem observation template -->
						<templateId root="2.16.840.1.113883.10.20.22.4.4"/>
						<!--  Diagnosis active template -->
						<templateId root="2.16.840.1.113883.10.20.24.3.11"/>
						<id root="1.3.6.1.4.1.115" extension="519139181d41c8a944000002"/>
						<code code="282291009" displayName="diagnosis" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED-CT"/>
						<text>
							Diagnosis, Active: <xsl:value-of select="problemName" />
						</text>
						<statusCode code="completed"/>
						<effectiveTime>
							<low value="20100425">
								<xsl:attribute name="value">
									<xsl:value-of select="effectiveTime" />
								</xsl:attribute>
							</low>
							<high value="20100425">
								<xsl:attribute name="value">
									<xsl:value-of select="effectiveTime" />
								</xsl:attribute>
							</high>
						</effectiveTime>
						<value code="1532007" codeSystem="2.16.840.1.113883.6.103"  xsi:type="CD">
							<xsl:attribute name="code">
								<xsl:value-of select="problemCode" />
							</xsl:attribute>
							<originalText>
								Diagnosis, Active: <xsl:value-of select="problemName" />
							</originalText>
						</value>

						<entryRelationship typeCode="REFR">
							<observation classCode="OBS" moodCode="EVN">
								<!-- Problem Status (consolidation) template -->
								<templateId root="2.16.840.1.113883.10.20.22.4.6"/>
								<!-- Problem Status, Active template -->
								<templateId root="2.16.840.1.113883.10.20.24.3.94"/>
								<id root="5577fb00-9e30-0130-2d0f-0800278bfb86"/>
								<code code="33999-4"
								  codeSystem="2.16.840.1.113883.6.1"
								  codeSystemName="LOINC"
								  displayName="status"/>
								<statusCode code="completed"/>
								<value xsi:type="CD" code="55561003"
								   displayName="active"
								   codeSystem="2.16.840.1.113883.6.96"
								   codeSystemName="SNOMED CT"/>
							</observation>
						</entryRelationship>
					</observation>
				</entry>
			</xsl:for-each>
			<xsl:for-each select="//Problem-ICD10">
				<entry>
					<observation classCode="OBS" moodCode="EVN">
						<!--  Problem observation template -->
						<templateId root="2.16.840.1.113883.10.20.22.4.4"/>
						<!--  Diagnosis active template -->
						<templateId root="2.16.840.1.113883.10.20.24.3.11"/>
						<id root="1.3.6.1.4.1.115" extension="519139181d41c8a944000002"/>
						<code code="282291009" displayName="diagnosis" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED-CT"/>
						<text>
							Diagnosis, Active: <xsl:value-of select="problemName" />
						</text>
						<statusCode code="completed"/>
						<effectiveTime>
							<low value="20100425">
								<xsl:attribute name="value">
									<xsl:value-of select="effectiveTime" />
								</xsl:attribute>
							</low>
							<high value="20100425">
								<xsl:attribute name="value">
									<xsl:value-of select="effectiveTime" />
								</xsl:attribute>
							</high>
						</effectiveTime>

						<value code="1532007" codeSystem="2.16.840.1.113883.6.90"  xsi:type="CD">
							<xsl:attribute name="code">
								<xsl:value-of select="problemCode" />
							</xsl:attribute>
							<originalText>
								Diagnosis, Active: <xsl:value-of select="problemName" />
							</originalText>
						</value>

						<entryRelationship typeCode="REFR">
							<observation classCode="OBS" moodCode="EVN">
								<!-- Problem Status (consolidation) template -->
								<templateId root="2.16.840.1.113883.10.20.22.4.6"/>
								<!-- Problem Status, Active template -->
								<templateId root="2.16.840.1.113883.10.20.24.3.94"/>
								<id root="5577fb00-9e30-0130-2d0f-0800278bfb86"/>
								<code code="33999-4"
								  codeSystem="2.16.840.1.113883.6.1"
								  codeSystemName="LOINC"
								  displayName="status"/>
								<statusCode code="completed"/>
								<value xsi:type="CD" code="55561003"
								   displayName="active"
								   codeSystem="2.16.840.1.113883.6.96"
								   codeSystemName="SNOMED CT"/>
							</observation>
						</entryRelationship>
					</observation>
				</entry>
			</xsl:for-each>
			<xsl:for-each select="//Problem-SNOMED">
				<entry>
					<observation classCode="OBS" moodCode="EVN">
						<!--  Problem observation template -->
						<templateId root="2.16.840.1.113883.10.20.22.4.4"/>
						<!--  Diagnosis active template -->
						<templateId root="2.16.840.1.113883.10.20.24.3.11"/>
						<id root="1.3.6.1.4.1.115" extension="519139181d41c8a944000002"/>
						<code code="282291009" displayName="diagnosis" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED-CT"/>
						<text>
							Diagnosis, Active: <xsl:value-of select="problemName" />
						</text>
						<statusCode code="completed"/>
						<effectiveTime>
							<low value="20100425">
								<xsl:attribute name="value">
									<xsl:value-of select="effectiveTime" />
								</xsl:attribute>
							</low>
							<high value="20100425">
								<xsl:attribute name="value">
									<xsl:value-of select="effectiveTime" />
								</xsl:attribute>
							</high>
						</effectiveTime>

						<value code="1532007" codeSystem="2.16.840.1.113883.6.96"  xsi:type="CD">
							<xsl:attribute name="code">
								<xsl:value-of select="problemCode" />
							</xsl:attribute>
							<originalText>
								Diagnosis, Active: <xsl:value-of select="problemName" />
							</originalText>
						</value>

						<entryRelationship typeCode="REFR">
							<observation classCode="OBS" moodCode="EVN">
								<!-- Problem Status (consolidation) template -->
								<templateId root="2.16.840.1.113883.10.20.22.4.6"/>
								<!-- Problem Status, Active template -->
								<templateId root="2.16.840.1.113883.10.20.24.3.94"/>
								<id root="5577fb00-9e30-0130-2d0f-0800278bfb86"/>
								<code code="33999-4"
								  codeSystem="2.16.840.1.113883.6.1"
								  codeSystemName="LOINC"
								  displayName="status"/>
								<statusCode code="completed"/>
								<value xsi:type="CD" code="55561003"
								   displayName="active"
								   codeSystem="2.16.840.1.113883.6.96"
								   codeSystemName="SNOMED CT"/>
							</observation>
						</entryRelationship>
					</observation>
				</entry>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<xsl:template name="Intervention"  match="//Intervention">
		<xsl:if test ="//Intervention/questionCode != '' or //Intervention-SNOMED/questionCode != '' or //Intervention-ResultSNOMED/questionCode != ''  or //Intervention-PlanSNOMED/questionCode != '' or //Intervention-ICD9/questionCode != '' or //Intervention-ICD10/questionCode != ''">
			<!--Removed for-each //Instervention section-->	
			<xsl:for-each select="//Intervention-SNOMED">
				<entry>
					<act classCode="ACT" moodCode="EVN">
						<!-- Consolidation CDA: Procedure Activity Act template -->
						<templateId root="2.16.840.1.113883.10.20.22.4.12"/>
						<templateId root="2.16.840.1.113883.10.20.24.3.32"/>
						<id root="1.3.6.1.4.1.115" extension="519139181d41c8a944000093"/>
						<code code="11366-2" codeSystem="2.16.840.1.113883.6.96">
							<xsl:attribute name="code">
								<xsl:value-of select="questionCode" />
							</xsl:attribute>
						</code>
						<statusCode code="completed"/>
						<effectiveTime>
							<low>
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</low>
							<high>
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</high>
						</effectiveTime>

						<xsl:if test ="negationReason != ''">
							<entryRelationship typeCode="RSON">
								<observation classCode="OBS" moodCode="EVN">
									<templateId root="2.16.840.1.113883.10.20.24.3.88"/>
									<code code="410666004"
										  codeSystem="2.16.840.1.113883.6.96"
										  displayName="reason"
										  codeSystemName="SNOMED CT"/>
									<statusCode code="completed"/>
									<effectiveTime value="20111111">
										<xsl:attribute name="value">
											<xsl:value-of select="dateTime" />
										</xsl:attribute>
									</effectiveTime>
									<value xsi:type="CD" code="161590003" codeSystem="2.16.840.1.113883.6.96">
										<xsl:attribute name="code">
											<xsl:value-of select="negationReason" />
										</xsl:attribute>
									</value>
								</observation>
							</entryRelationship>
						</xsl:if>
					</act>
				</entry>
			</xsl:for-each>
			<xsl:for-each select="//Intervention-ResultSNOMED">
				<entry>
					<act classCode="ACT" moodCode="EVN">
						<!-- Consolidation CDA: Procedure Activity Act template -->
						<templateId root="2.16.840.1.113883.10.20.22.4.12"/>
						<templateId root="2.16.840.1.113883.10.20.24.3.34"/>
						<id root="1.3.6.1.4.1.115" extension="519139181d41c8a944000093"/>
						<code code="11366-2" codeSystem="2.16.840.1.113883.6.96">
							<xsl:attribute name="code">
								<xsl:value-of select="questionCode" />
							</xsl:attribute>
						</code>
						<statusCode code="completed"/>
						<effectiveTime>
							<low>
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</low>
							<high>
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</high>
						</effectiveTime>

						<entryRelationship typeCode="REFR">
							<observation classCode="OBS" moodCode="EVN">
								<!-- Result Observation template (consolidation) -->
								<templateId root="2.16.840.1.113883.10.20.22.4.2"/>
								<!-- Result template -->
								<templateId root="2.16.840.1.113883.10.20.24.3.87"/>
								<id root="57ac61f0-9e30-0130-2d0f-0800278bfb86"/>
								<code code="428181000124104" codeSystem="2.16.840.1.113883.6.96">
									<xsl:attribute name="code">
										<xsl:value-of select="questionCode" />
									</xsl:attribute>

									<originalText>
										Intervention, Result: <xsl:value-of select="questionName" />
									</originalText>
								</code>
								<statusCode code="completed"/>
								<effectiveTime value='19930726012028'>
									<xsl:attribute name="value">
										<xsl:value-of select="dateTime" />
									</xsl:attribute>
								</effectiveTime>
								<value xsi:type="PQ" nullFlavor="UNK"/>

								<!-- Attribute: Status -->
								<entryRelationship typeCode="REFR">
									<observation classCode="OBS" moodCode="EVN">
										<templateId root="2.16.840.1.113883.10.20.24.3.93"/>
										<id root="57ac6d30-9e30-0130-2d0f-0800278bfb86"/>
										<code code="33999-4"
											  codeSystem="2.16.840.1.113883.6.1"
											  codeSystemName="LOINC"
											  displayName="Status"/>
										<value xsi:type="CD"
											  code="33999-4"
											  codeSystem="2.16.840.1.113883.6.1"
											  displayName="Final Report"/>
									</observation>
								</entryRelationship>
							</observation>
						</entryRelationship>
					</act>
				</entry>
			</xsl:for-each>
			<xsl:for-each select="//Intervention-PlanSNOMED">
				<entry>
					<act classCode="ACT" moodCode="RQO" negationInd="true">
						<xsl:if test ="negationReason = ''">
							<xsl:attribute name="negationInd">
								<xsl:value-of select="false" />
							</xsl:attribute>
						</xsl:if>
						<!-- Plan of Care Activity Act template -->
						<templateId root="2.16.840.1.113883.10.20.22.4.39"/>
						<!-- Intervention Order template -->
						<templateId root="2.16.840.1.113883.10.20.24.3.31"/>
						<id root="1.3.6.1.4.1.115" extension="519139191d41c8a9440000b0"/>
						<code code="11366-2" codeSystem="2.16.840.1.113883.6.96">
							<xsl:attribute name="code">
								<xsl:value-of select="questionCode" />
							</xsl:attribute>
							<originalText>
								Intervention, Performed: <xsl:value-of select="questionName" />
							</originalText>
						</code>
						<statusCode code="completed"/>
						<author>
							<time value="2011111">
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</time>
							<assignedAuthor>
								<id root="57ad99f0-9e30-0130-2d0f-0800278bfb86"/>
							</assignedAuthor>
						</author>
						<effectiveTime>
							<low>
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</low>
						</effectiveTime>

						<xsl:if test ="negationReason != ''">
							<entryRelationship typeCode="RSON">
								<observation classCode="OBS" moodCode="EVN">
									<templateId root="2.16.840.1.113883.10.20.24.3.88"/>
									<code code="410666004"
										  codeSystem="2.16.840.1.113883.6.96"
										  displayName="reason"
										  codeSystemName="SNOMED CT"/>
									<statusCode code="completed"/>
									<effectiveTime value="20111111">
										<xsl:attribute name="value">
											<xsl:value-of select="dateTime" />
										</xsl:attribute>
									</effectiveTime>
									<value xsi:type="CD" code="161590003" codeSystem="2.16.840.1.113883.6.96">
										<xsl:attribute name="code">
											<xsl:value-of select="negationReason" />
										</xsl:attribute>
									</value>
								</observation>
							</entryRelationship>
						</xsl:if>
					</act>
				</entry>
			</xsl:for-each>
			<xsl:for-each select="//Intervention-ICD9">
				<entry>
					<act classCode="ACT" moodCode="EVN">
						<!-- Consolidation CDA: Procedure Activity Act template -->
						<templateId root="2.16.840.1.113883.10.20.22.4.12"/>
						<templateId root="2.16.840.1.113883.10.20.24.3.32"/>
						<id root="1.3.6.1.4.1.115" extension="519139181d41c8a944000093"/>
						<code code="11366-2" codeSystem="2.16.840.1.113883.6.103">
							<xsl:attribute name="code">
								<xsl:value-of select="questionCode" />
							</xsl:attribute>
						</code>
						<statusCode code="completed"/>
						<effectiveTime>
							<low>
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</low>
							<high>
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</high>
						</effectiveTime>

						<xsl:if test ="negationReason != ''">
							<entryRelationship typeCode="RSON">
								<observation classCode="OBS" moodCode="EVN">
									<templateId root="2.16.840.1.113883.10.20.24.3.88"/>
									<code code="410666004"
										  codeSystem="2.16.840.1.113883.6.96"
										  displayName="reason"
										  codeSystemName="SNOMED CT"/>
									<statusCode code="completed"/>
									<effectiveTime value="20111111">
										<xsl:attribute name="value">
											<xsl:value-of select="dateTime" />
										</xsl:attribute>
									</effectiveTime>
									<value xsi:type="CD" code="161590003" codeSystem="2.16.840.1.113883.6.96">
										<xsl:attribute name="code">
											<xsl:value-of select="negationReason" />
										</xsl:attribute>
									</value>
								</observation>
							</entryRelationship>
						</xsl:if>
					</act>
				</entry>
			</xsl:for-each>
			<xsl:for-each select="//Intervention-ICD10">
				<entry>
					<act classCode="ACT" moodCode="EVN">
						<!-- Consolidation CDA: Procedure Activity Act template -->
						<templateId root="2.16.840.1.113883.10.20.22.4.12"/>
						<templateId root="2.16.840.1.113883.10.20.24.3.32"/>
						<id root="1.3.6.1.4.1.115" extension="519139181d41c8a944000093"/>
						<code code="11366-2" codeSystem="2.16.840.1.113883.6.90">
							<xsl:attribute name="code">
								<xsl:value-of select="questionCode" />
							</xsl:attribute>
						</code>
						<statusCode code="completed"/>
						<effectiveTime>
							<low>
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</low>
							<high>
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</high>
						</effectiveTime>

						<xsl:if test ="negationReason != ''">
							<entryRelationship typeCode="RSON">
								<observation classCode="OBS" moodCode="EVN">
									<templateId root="2.16.840.1.113883.10.20.24.3.88"/>
									<code code="410666004"
										  codeSystem="2.16.840.1.113883.6.96"
										  displayName="reason"
										  codeSystemName="SNOMED CT"/>
									<statusCode code="completed"/>
									<effectiveTime value="20111111">
										<xsl:attribute name="value">
											<xsl:value-of select="dateTime" />
										</xsl:attribute>
									</effectiveTime>
									<value xsi:type="CD" code="161590003" codeSystem="2.16.840.1.113883.6.96">
										<xsl:attribute name="code">
											<xsl:value-of select="negationReason" />
										</xsl:attribute>
									</value>
								</observation>
							</entryRelationship>
						</xsl:if>
					</act>
				</entry>
			</xsl:for-each>
			<xsl:for-each select="//Intervention-LOINC">
				<entry>
					<act classCode="ACT" moodCode="EVN">
						<xsl:if test ="negationReason = ''">
						</xsl:if>
						<!-- Consolidation CDA: Procedure Activity Act template -->
						<templateId root="2.16.840.1.113883.10.20.22.4.12"/>
						<templateId root="2.16.840.1.113883.10.20.24.3.32"/>
						<id root="1.3.6.1.4.1.115" extension="519139181d41c8a944000093"/>
						<code code="11366-2" codeSystem="2.16.840.1.113883.6.1">
							<xsl:attribute name="code">
								<xsl:value-of select="questionCode" />
							</xsl:attribute>
						</code>
						<statusCode code="completed"/>
						<effectiveTime>
							<low>
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</low>
							<high>
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</high>
						</effectiveTime>

						<xsl:if test ="negationReason != ''">
							<entryRelationship typeCode="RSON">
								<observation classCode="OBS" moodCode="EVN">
									<templateId root="2.16.840.1.113883.10.20.24.3.88"/>
									<code code="410666004"
										  codeSystem="2.16.840.1.113883.6.96"
										  displayName="reason"
										  codeSystemName="SNOMED CT"/>
									<statusCode code="completed"/>
									<effectiveTime value="20111111">
										<xsl:attribute name="value">
											<xsl:value-of select="dateTime" />
										</xsl:attribute>
									</effectiveTime>
									<value xsi:type="CD" code="161590003" codeSystem="2.16.840.1.113883.6.96">
										<xsl:attribute name="code">
											<xsl:value-of select="negationReason" />
										</xsl:attribute>
									</value>
								</observation>
							</entryRelationship>
						</xsl:if>
					</act>
				</entry>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
	
	<xsl:template name="Encounters"  match="//Encounters">
		<xsl:if test ="//EncounterEntry/questionCode != '' or //Encounter-SNOMED/questionCode != '' or //Encounter-ICD9/questionCode != '' or //Encounter-ICD10/questionCode != ''">
			<xsl:for-each select="//EncounterEntry">
				<entry>
					<encounter classCode="ENC" moodCode="EVN">
						<!--  Encounter activities template -->
						<templateId root="2.16.840.1.113883.10.20.22.4.49"/>
						<!-- Encounter performed template -->
						<templateId root="2.16.840.1.113883.10.20.24.3.23"/>
						<id root="1.3.6.1.4.1.115" extension="519139181d41c8a944000047"/>
							<xsl:if test ="questionCodeTypeName != 'HCPCS'">
								<code code="12843005" codeSystem="2.16.840.1.113883.6.12">
									<xsl:attribute name="code">
										<xsl:value-of select="questionCode" />
									</xsl:attribute>
									<originalText>
										Encounter1, Performed: <xsl:value-of select="questionName" />
									</originalText>
								</code>	
							</xsl:if>
							<xsl:if test ="questionCodeTypeName = 'HCPCS'">
								<code code="12843005" codeSystem="2.16.840.1.113883.6.14">
									<xsl:attribute name="code">
										<xsl:value-of select="questionCode" />
									</xsl:attribute>
									<originalText>
										Encounter, Performed: <xsl:value-of select="questionName" />
									</originalText>
								</code>
							</xsl:if>
						<text>
							Encounter, Performed: <xsl:value-of select="questionName" />
						</text>
						<statusCode code="completed"/>
						<effectiveTime>
							<!-- We try to look for the admit/discharge times on the encounter if they are there. If not, we fall back to the typical start/end date. -->
							<low>
								<xsl:attribute name="value">
									<xsl:value-of select="visitDate" />
								</xsl:attribute>
							</low>
							<high>
								<xsl:attribute name="value">
									<xsl:value-of select="visitDate" />
								</xsl:attribute>
							</high>
						</effectiveTime>
					</encounter>
				</entry>
			</xsl:for-each>
			<xsl:for-each select="//Encounter-SNOMED">
				<entry>
					<encounter classCode="ENC" moodCode="EVN">
						<!--  Encounter activities template -->
						<templateId root="2.16.840.1.113883.10.20.22.4.49"/>
						<!-- Encounter performed template -->
						<templateId root="2.16.840.1.113883.10.20.24.3.23"/>
						<id root="1.3.6.1.4.1.115" extension="519139181d41c8a944000047"/>
						<code code="12843005" codeSystem="2.16.840.1.113883.6.96">
							<xsl:attribute name="code">
								<xsl:value-of select="questionCode" />
							</xsl:attribute>
							<originalText>
								Encounter2, Performed: <xsl:value-of select="questionName" />
							</originalText>
						</code>
						<text>
							Encounter, Performed: <xsl:value-of select="questionName" />
						</text>
						<statusCode code="completed"/>
						<effectiveTime>
							<!-- We try to look for the admit/discharge times on the encounter if they are there. If not, we fall back to the typical start/end date. -->
							<low>
								<xsl:attribute name="value">
									<xsl:value-of select="visitDate" />
								</xsl:attribute>
							</low>
							<high>
								<xsl:attribute name="value">
									<xsl:value-of select="visitDate" />
								</xsl:attribute>
							</high>
						</effectiveTime>
					</encounter>
				</entry>
			</xsl:for-each>
			<xsl:for-each select="//Encounter-ICD9">
				<entry>
					<encounter classCode="ENC" moodCode="EVN">
						<!--  Encounter activities template -->
						<templateId root="2.16.840.1.113883.10.20.22.4.49"/>
						<!-- Encounter performed template -->
						<templateId root="2.16.840.1.113883.10.20.24.3.23"/>
						<id root="1.3.6.1.4.1.115" extension="519139181d41c8a944000047"/>
						<code code="12843005" codeSystem="2.16.840.1.113883.6.103">
							<xsl:attribute name="code">
								<xsl:value-of select="questionCode" />
							</xsl:attribute>
							<originalText>
								Encounter3, Performed: <xsl:value-of select="questionName" />
							</originalText>
						</code>
						<text>
							Encounter, Performed: <xsl:value-of select="questionName" />
						</text>
						<statusCode code="completed"/>
						<effectiveTime>
							<!-- We try to look for the admit/discharge times on the encounter if they are there. If not, we fall back to the typical start/end date. -->
							<low>
								<xsl:attribute name="value">
									<xsl:value-of select="visitDate" />
								</xsl:attribute>
							</low>
							<high>
								<xsl:attribute name="value">
									<xsl:value-of select="visitDate" />
								</xsl:attribute>
							</high>
						</effectiveTime>
					</encounter>
				</entry>
			</xsl:for-each>
			<xsl:for-each select="//Encounter-ICD10">
				<entry>
					<encounter classCode="ENC" moodCode="EVN">
						<!--  Encounter activities template -->
						<templateId root="2.16.840.1.113883.10.20.22.4.49"/>
						<!-- Encounter performed template -->
						<templateId root="2.16.840.1.113883.10.20.24.3.23"/>
						<id root="1.3.6.1.4.1.115" extension="519139181d41c8a944000047"/>
						<code code="12843005" codeSystem="2.16.840.1.113883.6.90">
							<xsl:attribute name="code">
								<xsl:value-of select="questionCode" />
							</xsl:attribute>
							<originalText>
								Encounter4, Performed: <xsl:value-of select="questionName" />
							</originalText>
						</code>
						<text>
							Encounter, Performed: <xsl:value-of select="questionName" />
						</text>
						<statusCode code="completed"/>
						<effectiveTime>
							<!-- We try to look for the admit/discharge times on the encounter if they are there. If not, we fall back to the typical start/end date. -->
							<low>
								<xsl:attribute name="value">
									<xsl:value-of select="visitDate" />
								</xsl:attribute>
							</low>
							<high>
								<xsl:attribute name="value">
									<xsl:value-of select="visitDate" />
								</xsl:attribute>
							</high>
						</effectiveTime>
					</encounter>
				</entry>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<xsl:template name="Procedure"  match="//Procedure">
		<xsl:if test ="//ProcedureEntry/questionCode != '' or //ProcedureEntry_SNOMED/questionCode != '' or //ProcedureEntry_ICD9/questionCode != '' or //ProcedureEntry_ICD10/questionCode != ''">
			<xsl:for-each select="//ProcedureEntry">
				<entry typeCode="DRIV">
					<procedure classCode="PROC" moodCode="EVN"  negationInd="false">
						<!--  Procedure performed template -->
						<templateId root="2.16.840.1.113883.10.20.24.3.64"/>
						<!-- Procedure Activity Procedure-->
						<templateId root="2.16.840.1.113883.10.20.22.4.14"/>
						<id root="1.3.6.1.4.1.115" extension="519139191d41c8a94400009f"/>
						<xsl:if test ="questionCodeTypeName != 'HCPCS'">
							<code codeSystem="2.16.840.1.113883.6.12" >
								<xsl:attribute name="code">
									<xsl:value-of select="questionCode" />
								</xsl:attribute>
								<xsl:attribute name="displayName">
									<xsl:value-of select="questionName" />
								</xsl:attribute>
							</code>
						</xsl:if>
						<xsl:if test ="questionCodeTypeName = 'HCPCS'">
							<code codeSystem="2.16.840.1.113883.6.14" >
								<xsl:attribute name="code">
									<xsl:value-of select="questionCode" />
								</xsl:attribute>
								<xsl:attribute name="displayName">
									<xsl:value-of select="questionName" />
								</xsl:attribute>
							</code>
						</xsl:if>
						<statusCode code="completed"/>
						<effectiveTime>
							<!-- We try to look for the admit/discharge times on the encounter if they are there. If not, we fall back to the typical start/end date. -->
							<low>
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</low>
							<high>
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</high>
						</effectiveTime>
					</procedure>
				</entry>
			</xsl:for-each>
			<xsl:for-each select="//ProcedureEntry_ICD9">
				<entry typeCode="DRIV">
					<procedure classCode="PROC" moodCode="EVN"  negationInd="false">
						<templateId root="2.16.840.1.113883.10.20.1.29"/>
						<templateId root="2.16.840.1.113883.3.249.11.100.9"/>
						<!-- Procedure activity template -->
						<id root="2.16.840.1.113883.19.5.9" extension="123601"/>
						<code codeSystem="2.16.840.1.113883.6.104" >
							<xsl:attribute name="code">
								<xsl:value-of select="questionCode" />
							</xsl:attribute>
							<xsl:attribute name="displayName">
								<xsl:value-of select="questionName" />
							</xsl:attribute>
						</code>
						<statusCode code="completed"/>
						<effectiveTime>
							<!-- We try to look for the admit/discharge times on the encounter if they are there. If not, we fall back to the typical start/end date. -->
							<low>
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</low>
							<high>
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</high>
						</effectiveTime>
					</procedure>
				</entry>
			</xsl:for-each>
			<xsl:for-each select="//ProcedureEntry_ICD10">
				<entry typeCode="DRIV">
					<procedure classCode="PROC" moodCode="EVN"  negationInd="false">
						<templateId root="2.16.840.1.113883.10.20.1.29"/>
						<templateId root="2.16.840.1.113883.3.249.11.100.9"/>
						<!-- Procedure activity template -->
						<id root="2.16.840.1.113883.19.5.9" extension="123601"/>
						<code codeSystem="2.16.840.1.113883.6.90" >
							<xsl:attribute name="code">
								<xsl:value-of select="questionCode" />
							</xsl:attribute>
							<xsl:attribute name="displayName">
								<xsl:value-of select="questionName" />
							</xsl:attribute>
						</code>
						<statusCode code="completed"/>
						<effectiveTime>
							<!-- We try to look for the admit/discharge times on the encounter if they are there. If not, we fall back to the typical start/end date. -->
							<low>
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</low>
							<high>
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</high>
						</effectiveTime>
					</procedure>
				</entry>
			</xsl:for-each>
			<xsl:for-each select="//ProcedureEntry_SNOMED">
				<entry typeCode="DRIV">
					<procedure classCode="PROC" moodCode="EVN"  negationInd="false">
						<templateId root="2.16.840.1.113883.10.20.1.29"/>
						<templateId root="2.16.840.1.113883.3.249.11.100.9"/>
						<!-- Procedure activity template -->
						<id root="2.16.840.1.113883.19.5.9" extension="123601"/>
						<code codeSystem="2.16.840.1.113883.6.96" >
							<xsl:attribute name="code">
								<xsl:value-of select="questionCode" />
							</xsl:attribute>
							<xsl:attribute name="displayName">
								<xsl:value-of select="questionName" />
							</xsl:attribute>
						</code>
						<statusCode code="completed"/>
						<effectiveTime>
							<!-- We try to look for the admit/discharge times on the encounter if they are there. If not, we fall back to the typical start/end date. -->
							<low>
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</low>
							<high>
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</high>
						</effectiveTime>
					</procedure>
				</entry>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<xsl:template name="Payer"  match="//Payer">
		<component>
			<section>
				<templateId root="2.16.840.1.113883.10.20.1.9" />
				<code code="48768-6" displayName="Payment sources" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC"/>
				<title>Payer Section </title>
				<text>
					patient’s payers, whether “third party” insurance, self-pay, other payer or guarantor, or some combination of payers, and is used to define which entity is the responsible fiduciary for the financial aspects of a patient’s care.
				</text>
				<xsl:for-each select="//payerEntry">
					<entry typeCode="DRIV">
						<act classCode="ACT" moodCode="DEF">
							<templateId root="2.16.840.1.113883.10.20.1.20"/>
							<!-- Coverage activity template -->
							<id root="2.16.840.1.113883.19.5.10" extension="103209"/>
							<code code="48768-6" codeSystem="2.16.840.1.113883.6.1" displayName="Payment sources"/>
							<statusCode code="completed"/>
							<entryRelationship typeCode="COMP">
								<act classCode="ACT" moodCode="EVN">
									<templateId root="2.16.840.1.113883.10.20.1.26"/>
									<templateId root="2.16.840.1.113883.3.249.11.100.7"/>
									<!-- Policy activity template -->
									<xsl:if test="planGroupID != ''">
										<id root="2.16.840.1.113883.19.5.10">
											<xsl:attribute name="extension">
												<xsl:value-of select="planGroupID" />
											</xsl:attribute>
										</id>
									</xsl:if>
									<xsl:if test="planGroupID = '' and planMemberID != '' ">
										<id root="2.16.840.1.113883.19.5.10">
											<xsl:attribute name="extension">
												<xsl:value-of select="planMemberID" />
											</xsl:attribute>
										</id>
									</xsl:if>
									<xsl:if test="planGroupID = '' and planMemberID = '' ">
										<id root="2.16.840.1.113883.19.5.10" extension ="103210">
										</id>
									</xsl:if>
									<code code="PUBLICPOL" codeSystem="2.16.840.1.113883.5.4"
									displayName="Public healthcare"/>
									<statusCode code="completed"/>
									<performer typeCode="PRF">
										<assignedEntity>
											<xsl:if test="PQRIInsuranceCarrier != ''">
												<id root="2.16.840.1.113883.12.86" extension="MB"/>
											</xsl:if>
											<representedOrganization>
												<name>
													<xsl:value-of select="InsurancePlanName" />
												</name>
											</representedOrganization>

										</assignedEntity>
									</performer>
									<participant typeCode="COV">
										<participantRole>
											<!--<xsl:if test="translate(planMemberID,'0123456789','000000000')= '000000000A'">-->
											<id root="2.16.840.1.113883.3.249.13" extension="654329876">
												<xsl:attribute name="extension">
													<xsl:value-of select="planMemberID" />
												</xsl:attribute>
											</id>
											<!--</xsl:if>-->
											<!--<xsl:if test="translate(planMemberID,'0123456789','000000000')!= '000000000A' and subscriber/ssn != ''">
												<id root="2.16.840.1.113883.4.1" extension="654329876">
													<xsl:attribute name="extension">
														<xsl:value-of select="subscriber/ssn" />
													</xsl:attribute>
												</id>
											</xsl:if>

											<xsl:if test="translate(planMemberID,'0123456789','000000000')!= '000000000A' and subscriber/ssn = ''">
												<id root="2.16.840.1.113883.4.1" extension="111111111">
												</id>
											</xsl:if>-->

											<code codeSystem="2.16.840.1.113883.5.111">
												<xsl:attribute name="code">
													<xsl:value-of select="relationshipName" />
												</xsl:attribute>
												<xsl:attribute name="displayName">
													<xsl:value-of select="relationshipName" />
												</xsl:attribute>
											</code>
										</participantRole>
									</participant>
									<entryRelationship typeCode="REFR">
										<act classCode="ACT" moodCode="EVN">
											<templateId root="2.16.840.1.113883.10.20.1.19"/>
											<!-- Authorization activity template -->
											<id root="2.16.840.1.113883.19.5.10" extension="103212"/>
											<code nullFlavor="NA"/>
											<entryRelationship typeCode="SUBJ">
												<procedure classCode="PROC" moodCode="PRMS">
													<!-- <code nullFlavor="NA"/>-->
												</procedure>
											</entryRelationship>
										</act>
									</entryRelationship>
								</act>
							</entryRelationship>
						</act>
					</entry>

				</xsl:for-each>
			</section>
		</component>
	</xsl:template>

	<xsl:template name="Alerts"  match="//Alerts">
		<xsl:if test ="//AlertsEntry/AlertEntryRelationship/questionName != ''">
			<component>
				<section>
					<templateId root="2.16.840.1.113883.10.20.1.2" />
					<code code="448765-2" displayName="Allergies" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC"/>
					<title>Alerts (Allergies, Adverse Reactions) Section </title>
					<text>
						Any allergies, adverse reactions, and alerts that are pertinent to the patient’s current or past medical history.
					</text>
					<xsl:for-each select="//AlertsEntry">
						<entry typeCode="DRIV">
							<act classCode="ACT" moodCode="EVN">
								<templateId root="2.16.840.1.113883.10.20.1.27"/>
								<!-- Problem act template -->
								<id root="2.16.840.1.113883.19.5.10" extension="100015"/>
								<code nullFlavor="NA"/>
								<entryRelationship typeCode="SUBJ">
									<observation classCode="OBS" moodCode="EVN">
										<templateId root="2.16.840.1.113883.10.20.1.18"/>
										<!-- Alert observation template -->
										<id root="2.16.840.1.113883.19.5.10" extension="100016"/>
										<code code="ASSERTION" codeSystem="2.16.840.1.113883.5.4"/>
										<statusCode code="completed"/>
										<effectiveTime>
											<low>
												<xsl:attribute name="value">
													<xsl:value-of select="AlertEntryRelationship/recordDate" />
												</xsl:attribute>
											</low>
										</effectiveTime>
										<value xsi:type="CD" code="281647001" codeSystem="2.16.840.1.113883.6.96" displayName="Adverse reaction to substance"/>
										<participant typeCode="CSM">
											<participantRole classCode="MANU">
												<playingEntity classCode="MMAT">
													<xsl:if test ="AlertEntryRelationship/questionRxNormCode != ''">
														<code codeSystem="2.16.840.1.113883.6.96">
															<xsl:attribute name="code">
																<xsl:value-of select="AlertEntryRelationship/questionRxNormCode" />
															</xsl:attribute>
															<xsl:attribute name="displayName">
																<xsl:value-of select="AlertEntryRelationship/questionName" />
															</xsl:attribute>
														</code>
													</xsl:if>
													<xsl:if test ="AlertEntryRelationship/questionRxNormCode = ''">
														<xsl:if test ="AlertEntryRelationship/questionRxNormCode != ''">
															<code code="NA" codeSystem="2.16.840.1.113883.6.96">
																<xsl:attribute name="displayName">
																	<xsl:value-of select="AlertEntryRelationship/questionName" />
																</xsl:attribute>
															</code>
														</xsl:if>
													</xsl:if>
												</playingEntity>
											</participantRole>
										</participant>
										<entryRelationship typeCode="MFST" inversionInd="true">
											<observation classCode="OBS" moodCode="EVN">
												<templateId root="2.16.840.1.113883.10.20.1.54"/>
												<!-- Reaction observation template -->
												<code code="ASSERTION" codeSystem="2.16.840.1.113883.5.4"/>
												<statusCode code="completed"/>
												<value xsi:type="CD" code="247472004" codeSystem="2.16.840.1.113883.6.96">
													<xsl:attribute name="displayName">
														<xsl:value-of select="AlertEntryRelationship/answerName" />
													</xsl:attribute>
												</value>
											</observation>
										</entryRelationship>
										<entryRelationship typeCode="REFR">
											<observation classCode="OBS" moodCode="EVN">
												<templateId root="2.16.840.1.113883.10.20.1.39"/>
												<!-- Alert status observation template -->
												<code code="33999-4" codeSystem="2.16.840.1.113883.6.1" displayName="Status"/>
												<statusCode code="completed"/>
												<value xsi:type="CE" code="55561003" codeSystem="2.16.840.1.113883.6.96"
												displayName="Active"/>
											</observation>
										</entryRelationship>
									</observation>
								</entryRelationship>
							</act>
						</entry>
					</xsl:for-each>
				</section>
			</component>
		</xsl:if>
	</xsl:template>

	<xsl:template name="Result"  match="//Result">
		<!--<xsl:if test ="(//ObservationLionc/ObservationUnits != '' and //ObservationLionc/ObservationItemCode != '' ) or (//ObservationLionc_no_result/ObservationUnits = '' and //ObservationLionc_no_result/ObservationItemCode != '' ) or //ObservationOrder_CPT/ObservationItemCode != '' or //ObservationOrder_SNOMED/ObservationItemCode != ''">-->
		<xsl:if test ="(//ObservationLionc/ObservationItemCode != '' ) or (//ObservationLionc_no_result/ObservationItemCode != '' ) or //ObservationOrder_CPT/ObservationItemCode != '' or //ObservationOrder_SNOMED/ObservationItemCode != ''">
			<xsl:for-each select="//ObservationLionc[ObservationItemCode!='']">
				<!--<xsl:if test="ObservationUnits != ''">-->
				<entry>
					<!--Laboratory test, result -->
					<observation classCode="OBS" moodCode="EVN">
						<!--  Result Observation (consolidation) template  -->
						<templateId root="2.16.840.1.113883.10.20.22.4.2"/>
						<!-- Laboratory Test, Result template -->
						<templateId root="2.16.840.1.113883.10.20.24.3.40"/>
						<id root="1.3.6.1.4.1.115" extension="519139191d41c8a9440000c5"/>
						<code code="13217-5" codeSystem="2.16.840.1.113883.6.1">
							<xsl:attribute name="code">
								<xsl:value-of select="ObservationItemCode" />
							</xsl:attribute>
							<originalText>
								Laboratory Test, Result: <xsl:value-of select="ObservationItemName" />
							</originalText>
						</code>
						<text>
							Laboratory Test, Result: <xsl:value-of select="ObservationItemName" />
						</text>
						<statusCode code="completed"/>
						<effectiveTime>
							<low value="289126586">
								<xsl:attribute name="value">
									<xsl:value-of select="ResultDateTime" />
								</xsl:attribute>
							</low>
						</effectiveTime>
						<value xsi:type="CD" nullFlavor="UNK"/>

					</observation>
				</entry>
				<!--</xsl:if>-->
			</xsl:for-each>
			<xsl:for-each select="//ObservationLionc_no_result[ObservationItemCode!='']">
				<!--<xsl:if test="ObservationUnits != ''">-->
				<entry>
					<!--Laboratory test, result -->
					<observation classCode="OBS" moodCode="EVN">
						<!--  Result Observation (consolidation) template  -->
						<templateId root="2.16.840.1.113883.10.20.22.4.2"/>
						<!-- Laboratory Test, Result template -->
						<templateId root="2.16.840.1.113883.10.20.24.3.40"/>
						<id root="1.3.6.1.4.1.115" extension="519139191d41c8a9440000c5"/>
						<code code="13217-5" codeSystem="2.16.840.1.113883.6.1">
							<xsl:attribute name="code">
								<xsl:value-of select="ObservationItemCode" />
							</xsl:attribute>
							<originalText>
								Laboratory Test, Result: <xsl:value-of select="ObservationItemName" />
							</originalText>
						</code>
						<text>
							Laboratory Test, Result: <xsl:value-of select="ObservationItemName" />
						</text>
						<statusCode code="completed"/>
						<effectiveTime>
							<low value="289126586">
								<xsl:attribute name="value">
									<xsl:value-of select="ResultDateTime" />
								</xsl:attribute>
							</low>
						</effectiveTime>
						<value xsi:type="CD" nullFlavor="UNK"/>

					</observation>
				</entry>
				<!--</xsl:if>-->
			</xsl:for-each>
			<xsl:for-each select="//ObservationLionc_CPT[ObservationItemCode!='']">
				<!--<xsl:if test="ObservationUnits != ''">-->
				<entry>
					<!--Laboratory test, result -->
					<observation classCode="OBS" moodCode="EVN">
						<!--  Result Observation (consolidation) template  -->
						<templateId root="2.16.840.1.113883.10.20.22.4.2"/>
						<!-- Laboratory Test, Result template -->
						<templateId root="2.16.840.1.113883.10.20.24.3.40"/>
						<id root="1.3.6.1.4.1.115" extension="519139191d41c8a9440000c5"/>
						<code code="13217-5" codeSystem="2.16.840.1.113883.6.1">
							<xsl:attribute name="code">
								<xsl:value-of select="ObservationItemCode" />
							</xsl:attribute>
							<originalText>
								Laboratory Test, Result: <xsl:value-of select="ObservationItemName" />
							</originalText>
						</code>
						<text>
							Laboratory Test, Result: <xsl:value-of select="ObservationItemName" />
						</text>
						<statusCode code="completed"/>
						<effectiveTime>
							<low value="289126586">
								<xsl:attribute name="value">
									<xsl:value-of select="ResultDateTime" />
								</xsl:attribute>
							</low>
						</effectiveTime>
						<value xsi:type="CD" nullFlavor="UNK"/>

					</observation>
				</entry>
				<!--</xsl:if>-->
			</xsl:for-each>
			<xsl:for-each select="//ObservationLionc_SNOMED[ObservationItemCode!='']">
				<!--<xsl:if test="ObservationUnits != ''">-->
				<entry>
					<!--Laboratory test, result -->
					<observation classCode="OBS" moodCode="EVN">
						<!--  Result Observation (consolidation) template  -->
						<templateId root="2.16.840.1.113883.10.20.22.4.2"/>
						<!-- Laboratory Test, Result template -->
						<templateId root="2.16.840.1.113883.10.20.24.3.40"/>
						<id root="1.3.6.1.4.1.115" extension="519139191d41c8a9440000c5"/>
						<code code="13217-5" codeSystem="2.16.840.1.113883.6.1">
							<xsl:attribute name="code">
								<xsl:value-of select="ObservationItemCode" />
							</xsl:attribute>
							<originalText>
								Laboratory Test, Result: <xsl:value-of select="ObservationItemName" />
							</originalText>
						</code>
						<text>
							Laboratory Test, Result: <xsl:value-of select="ObservationItemName" />
						</text>
						<statusCode code="completed"/>
						<effectiveTime>
							<low value="289126586">
								<xsl:attribute name="value">
									<xsl:value-of select="ResultDateTime" />
								</xsl:attribute>
							</low>
						</effectiveTime>
						<value xsi:type="CD" nullFlavor="UNK"/>

					</observation>
				</entry>
				<!--</xsl:if>-->
			</xsl:for-each>

		</xsl:if>
	</xsl:template>

	<xsl:template name="Vital"  match="//Vital">

		<!--<xsl:if test="//VitalEntry/weight/value != '' or //VitalEntry/height/value != '' or //VitalEntry/bp/bpSystolic/value != '' or //VitalEntry/bp/bpDiastolic/value != ''">
			-->
		<xsl:if test="//VitalEntry/bp/bpSystolic/value != '' or //VitalEntry/bp/bpDiastolic/value != '' or //VitalEntry/bmi/value != ''">
			<component>
				<section>
					<templateId root="2.16.840.1.113883.10.20.1.16" />
					<code code="8716-3" displayName="Vital signs" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC"/>
					<title>Vital Sign Section </title>
					<text>
						This section contains current and historically relevant vital signs, such as blood pressure, heart rate, respiratory rate, height, weight, body mass index, head circumference, crown-to-rump length, and pulse oximetry.
					</text>
					<xsl:for-each select="//VitalEntry">
						<xsl:if test="bp/bpSystolic/value != '' or bp/bpDiastolic/value != '' or bmi/value != ''">
							<!--
						<xsl:if test="weight/value != '' or height/value != '' or bp/bpSystolic/value != '' or bp/bpDiastolic/value != ''">-->
							<entry contextConductionInd="true" typeCode="DRIV">
								<organizer classCode="CLUSTER" moodCode="EVN">
									<templateId root="2.16.840.1.113883.10.20.1.35"/>
									<id root="2.16.840.1.113883.19.5.10" extension="116622"/>
									<code code="46680005" codeSystem="2.16.840.1.113883.6.96" displayName="Vital signs"/>
									<statusCode code="completed"/>
									<!--
									<xsl:if test="height/value != ''">
										<component contextConductionInd="true">
											<observation classCode="OBS" moodCode="EVN">
												<templateId root="2.16.840.1.113883.10.20.1.31"/>
												<id root="2.16.840.1.113883.19.5.10" extension="112881"/>
												<code xsi:type="CE" code="50373000" codeSystem="2.16.840.1.113883.6.96"
												displayName="Body height"/>
												<statusCode code="completed"/>
												<effectiveTime >
													<xsl:attribute name="value">
														<xsl:value-of select="effectiveTime" />
													</xsl:attribute>
												</effectiveTime>
												<value xsi:type="PQ" unit="cm" >
													<xsl:attribute name="value">
														<xsl:value-of select="height/value" />
													</xsl:attribute>
												</value>
											</observation>
										</component>
									</xsl:if>
									<xsl:if test="weight/value != ''">
										<component contextConductionInd="true">
											<observation classCode="OBS" moodCode="EVN">
												<templateId root="2.16.840.1.113883.10.20.1.31"/>
												<id root="2.16.840.1.113883.19.5.10" extension="112882"/>
												<code xsi:type="CE" code="27113001" codeSystem="2.16.840.1.113883.6.96"
												displayName="Body weight"/>
												<statusCode code="completed"/>
												<effectiveTime>
													<xsl:attribute name="value">
														<xsl:value-of select="effectiveTime" />
													</xsl:attribute>
												</effectiveTime>
												<value xsi:type="PQ" unit="kg">
													<xsl:attribute name="value">
														<xsl:value-of select="weight/value" />
													</xsl:attribute>
												</value>
											</observation>
										</component>
									</xsl:if>
									-->
									<xsl:if test="bp/bpSystolic/value != ''">
										<component contextConductionInd="true">
											<observation classCode="OBS" moodCode="EVN"  negationInd="false">
												<templateId root="2.16.840.1.113883.10.20.1.31"/>
												<templateId root="2.16.840.1.113883.3.249.11.100.33"/>
												<id root="2.16.840.1.113883.19.5.10" extension="112883"/>
												<code code="271649006" codeSystem="2.16.840.1.113883.6.96"
												displayName="Systolic BP"/>
												<statusCode code="completed"/>
												<effectiveTime>
													<xsl:attribute name="value">
														<xsl:value-of select="effectiveTime" />
													</xsl:attribute>
												</effectiveTime>
												<value xsi:type="PQ" unit="mm[Hg]">
													<xsl:attribute name="value">
														<xsl:value-of select="bp/bpSystolic/value" />
													</xsl:attribute>
												</value>
											</observation>
										</component>
									</xsl:if>
									<xsl:if test="bp/bpDiastolic/value != ''">
										<component contextConductionInd="true">
											<observation classCode="OBS" moodCode="EVN" negationInd="false">
												<templateId root="2.16.840.1.113883.10.20.1.31"/>
												<templateId root="2.16.840.1.113883.3.249.11.100.33"/>
												<id root="2.16.840.1.113883.19.5.10" extension="112884"/>
												<code code="271650006" codeSystem="2.16.840.1.113883.6.96"
												displayName="Diastolic BP"/>
												<statusCode code="completed"/>
												<effectiveTime>
													<xsl:attribute name="value">
														<xsl:value-of select="effectiveTime" />
													</xsl:attribute>
												</effectiveTime>
												<value xsi:type="PQ" unit="mm[Hg]">
													<xsl:attribute name="value">
														<xsl:value-of select="bp/bpDiastolic/value" />
													</xsl:attribute>
												</value>
											</observation>
										</component>
									</xsl:if>
									<xsl:if test="bmi/value != ''">
										<component contextConductionInd="true">
											<observation classCode="OBS" moodCode="EVN" negationInd="false">
												<templateId root="2.16.840.1.113883.10.20.1.31"/>
												<templateId root="2.16.840.1.113883.3.249.11.100.33"/>
												<id root="2.16.840.1.113883.19.5.10" extension="112884"/>
												<code code="60621009" codeSystem="2.16.840.1.113883.6.96"
												displayName="Body mass index"/>
												<statusCode code="completed"/>
												<effectiveTime>
													<xsl:attribute name="value">
														<xsl:value-of select="effectiveTime" />
													</xsl:attribute>
												</effectiveTime>
												<value xsi:type="PQ" unit="kg/m²">
													<xsl:attribute name="value">
														<xsl:value-of select="bmi/value" />
													</xsl:attribute>
												</value>
											</observation>
										</component>
									</xsl:if>
								</organizer>
							</entry>
						</xsl:if>
					</xsl:for-each>
				</section>
			</component>
		</xsl:if>
	</xsl:template>

	<xsl:template name="Social"  match="//Social">
		<xsl:if test="//SocialEntry/SocialEntryRelationship/answerId != ''">
			<component>
				<section>
					<templateId root="2.16.840.1.113883.10.20.1.15" />
					<code code="29762-2" displayName="Social history" codeSystem="2.16.840.1.113883.6.1" />
					<title>social history</title>
					<text>social history</text>
					<xsl:for-each select="//SocialEntry/SocialEntryRelationship">
						<xsl:if test="answerId != ''">
							<entry typeCode="DRIV">
								<observation classCode="OBS" moodCode="EVN">
									<templateId root="2.16.840.1.113883.10.20.1.33"/>
									<templateId root="2.16.840.1.113883.3.249.11.100.5"/>
									<!-- social history observations template -->
									<id root="2.16.840.1.113883.19.5.10" extension="1032134248"/>
									<code codeSystem="2.16.840.1.113883.6.96" >
										<xsl:attribute name="code">
											<xsl:value-of select="answerId" />
										</xsl:attribute>
										<xsl:attribute name="displayName">
											<xsl:value-of select="answerName" />
										</xsl:attribute>
									</code>
									<statusCode code="completed"/>
									<effectiveTime>
										<center >
											<xsl:attribute name="value">
												<xsl:value-of select="recordDate" />
											</xsl:attribute>
										</center>
									</effectiveTime>
									<entryRelationship typeCode="REFR">
										<observation classCode="OBS" moodCode="EVN">
											<!-- social history status observation template -->
											<templateId root="2.16.840.1.113883.10.20.1.56"/>
											<templateId root="2.16.840.1.113883.3.249.11.100.4"/>
											<code code="33999-4" codeSystem="2.16.840.1.113883.6.1"/>
											<statusCode code="completed"/>
											<value xsi:type="CD" code="55561003" codeSystem="2.16.840.1.113883.6.96" displayName="active"/>
										</observation>
									</entryRelationship>
								</observation>
							</entry>
						</xsl:if >
					</xsl:for-each>
				</section>
			</component>
		</xsl:if >
	</xsl:template>

	<xsl:template name="Plan"  match="//Plan">
		<xsl:if test="//PlanProcedureEntry/questionCode != '' or //PlanSocialEntry/PlanSocialEntryRelationship/SmokingCessation != ''">
			<component>
				<section>
					<templateId root="2.16.840.1.113883.10.20.1.10" />
					<code code="18776-5"  displayName="Treatment plan" codeSystem="2.16.840.1.113883.6.1" />
					<title>Treatment plan</title>
					<text>plan</text>
					<xsl:for-each select="//PlanProcedureEntry">
						<entry typeCode="DRIV">
							<observation classCode="OBS" moodCode="RQO">
								<templateId root="2.16.840.1.113883.10.20.1.25"/>
								<templateId root="2.16.840.1.113883.3.249.11.100.2"/>
								<!-- Plan of Activity activity template -->
								<id root="2.16.840.1.113883.19.5.10" extension="10322552"/>
								<xsl:if test ="questionCodeTypeName != 'HCPCS'">
									<code  codeSystem="2.16.840.1.113883.6.12">
										<xsl:attribute name="code">
											<xsl:value-of select="questionCode" />
										</xsl:attribute>
									</code>
								</xsl:if>
								<xsl:if test ="questionCodeTypeName = 'HCPCS'">
									<code  codeSystem="2.16.840.1.113883.6.14">
										<xsl:attribute name="code">
											<xsl:value-of select="questionCode" />
										</xsl:attribute>
									</code>
								</xsl:if>
								<statusCode code="Aborted"/>
								<effectiveTime>
									<center value="20101001">
										<xsl:attribute name="value">
											<xsl:value-of select="dateTime" />
										</xsl:attribute>
									</center>
								</effectiveTime>
							</observation>
						</entry>
					</xsl:for-each>
					<xsl:for-each select="//PlanSocialEntry">
						<xsl:if test="PlanSocialEntryRelationship/SmokingCessation != ''">
							<entry typeCode="DRIV">
								<observation classCode="OBS" moodCode="RQO">
									<templateId root="2.16.840.1.113883.10.20.1.25"/>
									<templateId root="2.16.840.1.113883.3.249.11.100.2"/>
									<!-- Plan of Activity activity template -->
									<id root="2.16.840.1.113883.19.5.10" extension="103217678"/>
									<!--<code  codeSystem="2.16.840.1.113883.6.96" code="225323000">-->
									<code  codeSystem="2.16.840.1.113883.6.96" code="384742004">
										<!--<xsl:attribute name="code">
									<xsl:value-of select="questionCode" />
								</xsl:attribute>-->
									</code>
									<statusCode code="Aborted"/>
									<effectiveTime>
										<center value="20101001">
											<xsl:attribute name="value">
												<xsl:value-of select="PlanSocialEntryRelationship/recordDate" />
											</xsl:attribute>
										</center>
									</effectiveTime>
								</observation>
							</entry>
						</xsl:if >
					</xsl:for-each>
				</section>
			</component>
		</xsl:if >
	</xsl:template>

	<xsl:template name="AdvanceDirective"  match="//AdvanceDirective">
		<xsl:if test="//AdvanceDirectiveEntry/RelAttachmentGroupUid != ''">
			<component>
				<section>
					<templateId root="2.16.840.1.113883.10.20.1.1" />
					<code code="42348-3"  codeSystem="2.16.840.1.113883.6.1" />
					<title>advance directives</title>
					<text>advance directives</text>
					<entry typeCode="DRIV">
						<observation classCode="OBS" moodCode="EVN">
							<templateId root='2.16.840.1.113883.10.20.1.17'/>
							<templateId root="2.16.840.1.113883.3.249.11.100.15"/>
							<!-- Advance directive observation template -->
							<id root="2.16.840.1.113883.19.5.10" extension="1123223"/>
							<code code="304251008" codeSystem="2.16.840.1.113883.6.96" displayName="Resuscitation"/>
							<statusCode code="completed"/>
							<value xsi:type="CD" code="425392003" codeSystem="2.16.840.1.113883.6.96" displayName="Current and Verified">
								<originalText>
									<reference value="#AD1"/>
								</originalText>
							</value>
							<participant typeCode="VRF">
								<templateId root='2.16.840.1.113883.10.20.1.58'/>
								<!-- Verification of an advance directive observation template -->
								<time value="20100907"/>
								<participantRole>
									<id root="2.16.840.1.113883.19.5.10"
									extension="1123424"/>
								</participantRole>
							</participant>
							<entryRelationship typeCode="REFR">
								<observation classCode="OBS" moodCode="EVN">
									<templateId root="2.16.840.1.113883.10.20.1.37"/>
									<!-- Advance directive status observation template -->
									<id root="2.16.840.1.113883.19.5.10"
									extension="11343533"/>
									<code code="33999-4" codeSystem="2.16.840.1.113883.6.1"
									displayName="Status"/>
									<statusCode code="completed"/>
									<effectiveTime xsi:type="IVL_TS"/>
									<value xsi:type="CE" code="425392003"
									codeSystem="2.16.840.1.113883.6.96"
									displayName="Current and verified"/>
								</observation>
							</entryRelationship>
						</observation>
					</entry>
				</section>
			</component>
		</xsl:if >
	</xsl:template>

	<xsl:template name="Equipment"  match="//Equipment">
		<xsl:if test="//EquipmentEntry/problemCode != ''">
			<component>
				<section>
					<templateId root="2.16.840.1.113883.10.20.1.7" />
					<code code="46264-8" codeSystem="2.16.840.1.113883.6.1" />
					<title>equipment</title>
					<text>equipment</text>
					<xsl:for-each select="//EquipmentEntry">
						<xsl:if test="problemCode != ''">
							<entry typeCode="DRIV">
								<supply classCode="SPLY" moodCode="EVN">
									<templateId root="2.16.840.1.113883.10.20.1.34"/>
									<templateId root="2.16.840.1.113883.3.249.11.100.22"/>
									<!-- Supply activity template -->
									<id root="2.16.840.1.113883.19.5.10" extension="32328395"/>
									<statusCode code="completed"/>
									<effectiveTime xsi:type="IVL_TS">
										<center value="20051101">
											<xsl:attribute name="value">
												<xsl:value-of select="effectiveTime" />
											</xsl:attribute>
										</center>
									</effectiveTime>
									<participant typeCode="DEV">
										<participantRole classCode="MANU">
											<templateId root="2.16.840.1.113883.10.20.1.52"/>
											<templateId root="2.16.840.1.113883.3.249.11.100.23"/>
											<!-- Product instance template -->
											<playingDevice>
												<code codeSystem="2.16.840.1.113883.6.103">
													<xsl:attribute name="code">
														<xsl:value-of select="problemCode" />
													</xsl:attribute>
													<xsl:attribute name="displayName">
														<xsl:value-of select="problemName" />
													</xsl:attribute>
												</code>
											</playingDevice>
										</participantRole>
									</participant>
									<entryRelationship typeCode="REFR">
										<observation classCode="OBS" moodCode="EVN">
											<templateId root="2.16.840.1.113883.10.20.1.47"/>
											<!-- Medication status observation template -->
											<code codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC"
											code="33999-4" displayName="Status"/>
											<statusCode code="completed"/>
											<value xsi:type="CE" codeSystem="2.16.840.1.113883.6.96"
											codeSystemName="SNOMED-CD" code="55561003" displayName="Active"/>
										</observation>
									</entryRelationship>
								</supply>
							</entry>
						</xsl:if>
					</xsl:for-each>
				</section>
			</component>
		</xsl:if >
	</xsl:template>

	<xsl:template name="FamilyHistory"  match="//FamilyHistory">
		<xsl:if test="//FamilyHistoryHxEntry/FamilyHistoryEntryRelationship/answerId != ''">
			<component>
				<section>
					<templateId root="2.16.840.1.113883.10.20.1.4" />
					<code code="10157-6" codeSystem="2.16.840.1.113883.6.1" />
					<title>family history</title>
					<text>family history</text>
					<xsl:for-each select="//FamilyHistoryHxEntry/FamilyHistoryEntryRelationship">
						<xsl:if test="problemCode != ''">
							<entry typeCode="DRIV">
								<organizer moodCode="EVN" classCode="CLUSTER">
									<templateId root="2.16.840.1.113883.10.20.1.23"/>
									<templateId root="2.16.840.1.113883.3.249.11.100.20"/>
									<!-- Family history organizer template -->
									<statusCode code="completed"/>
									<subject>
										<relatedSubject classCode="PRS">
											<code code="NMTH" codeSystem="2.16.840.1.113883.5.111"
											displayName="Natural mother"/>
											<subject>
												<administrativeGenderCode code="F" codeSystem="2.16.840.1.113883.5.1"
												displayName="Female"/>
												<birthTime value="1922"/>
											</subject>
										</relatedSubject>
									</subject>
									<component>
										<observation classCode="OBS" moodCode="EVN">
											<templateId root="2.16.840.1.113883.10.20.1.22"/>
											<templateId root="2.16.840.1.113883.3.249.11.100.21"/>
											<!-- Family history observation template -->
											<id root="2.16.840.1.113883.19.5.10" extension="32328383"/>
											<code code="ASSERTION" codeSystem="2.16.840.1.113883.5.4"/>
											<statusCode code="completed"/>
											<effectiveTime>
												<low value="1962"/>
											</effectiveTime>
											<value xsi:type="CD"  codeSystem="2.16.840.1.113883.6.103">
												<xsl:attribute name="code">
													<xsl:value-of select="answerId" />
												</xsl:attribute>
												<xsl:attribute name="displayName">
													<xsl:value-of select="answerName" />
												</xsl:attribute>
											</value>
										</observation>
									</component>
								</organizer>
							</entry>
						</xsl:if>
					</xsl:for-each>
				</section>
			</component>
		</xsl:if >
	</xsl:template>

	<xsl:template name="Medication"  match="//Medication">
		<xsl:if test ="//MedicationEntry/brandName != ''">
			<xsl:for-each select="//MedicationEntry">
				<entry>
					<substanceAdministration classCode="SBADM" moodCode="EVN" >
						<!-- Medication Activity (consolidation) template -->
						<templateId root="2.16.840.1.113883.10.20.22.4.16"/>
						<!-- Medication, Active template -->
						<templateId root="2.16.840.1.113883.10.20.24.3.41"/>

						<id root="1.3.6.1.4.1.115" extension="519139181d41c8a94400006b"/>
						<text>
							Medication, Active: <xsl:value-of select="brandName" />
						</text>
						<statusCode code="active"/>
						<xsl:if test ="itemStartDate != ''">
							<effectiveTime xsi:type="IVL_TS">
								<low>
									<xsl:attribute name="value">
										<xsl:value-of select="itemStartDate" />
									</xsl:attribute>
								</low>
								<high>
									<xsl:attribute name="value">
										<xsl:value-of select="itemStartDate" />
									</xsl:attribute>
								</high>
							</effectiveTime>
						</xsl:if>
						<xsl:if test ="itemStartDate = ''">
							<effectiveTime nullFlavor="UNK"/>
						</xsl:if>
						<!-- Attribute: dose -->
						<consumable>
							<manufacturedProduct classCode="MANU">
								<!-- Medication Information (consolidation) template -->
								<templateId root="2.16.840.1.113883.10.20.22.4.23"/>
								<id root="5576b690-9e30-0130-2d0f-0800278bfb86"/>
								<manufacturedMaterial>
									<code nullFlavor="UNK">
										<originalText>
											Medication, Active: <xsl:value-of select="brandName" />
										</originalText>
										<translation codeSystem="2.16.840.1.113883.6.88">
											<xsl:attribute name="code">
												<xsl:value-of select="productCode" />
											</xsl:attribute>
										</translation>
									</code>
								</manufacturedMaterial>
								<manufacturerOrganization>
									<name>Medication Factory Inc.</name>
								</manufacturerOrganization>
							</manufacturedProduct>
						</consumable>

					</substanceAdministration>
				</entry>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<xsl:template name="Immunizations"  match="//Immunizations">
		<xsl:if test ="//ImmunizationEntry/VaccineCode != ''">
			<xsl:for-each select="//ImmunizationEntry">
				<xsl:if test ="VaccineCode != ''">
					<entry>
						<act classCode="ACT" moodCode="EVN" >
							<!-- Medication, Administered template -->
							<templateId root="2.16.840.1.113883.10.20.24.3.42"/>
							<id root="1.3.6.1.4.1.115" extension="519139181d41c8a944000079"/>
							<code code="416118004" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED CT" displayName="Administration"/>
							<statusCode code="completed"/>
							<xsl:if test ="AdministeredDateTime != ''">
								<effectiveTime xsi:type="IVL_TS">
									<low value="20100425">
										<xsl:attribute name="value">
											<xsl:value-of select="AdministeredDateTime" />
										</xsl:attribute>
									</low>
								</effectiveTime>
							</xsl:if>
							<xsl:if test ="AdministeredDateTime = '' and AdministeredDateTime1 != ''">
								<effectiveTime xsi:type="IVL_TS">
									<low value="20100425">
										<xsl:attribute name="value">
											<xsl:value-of select="AdministeredDateTime1" />
										</xsl:attribute>
									</low>
								</effectiveTime>
							</xsl:if>
							<entryRelationship typeCode="COMP">
								<substanceAdministration classCode="SBADM" moodCode="EVN">
									<!-- Medication Activity (consolidation) template -->
									<templateId root="2.16.840.1.113883.10.20.22.4.16"/>
									<id root="561cbf60-9e30-0130-2d0f-0800278bfb86"/>
									<text>
										Medication, Administered: <xsl:value-of select="VaccineName" />
									</text>
									<statusCode code="completed"/>
									<xsl:if test ="AdministeredDateTime != ''">
										<effectiveTime xsi:type="IVL_TS">
											<low value="20100425">
												<xsl:attribute name="value">
													<xsl:value-of select="AdministeredDateTime" />
												</xsl:attribute>
											</low>
											<high>
												<xsl:attribute name="value">
													<xsl:value-of select="AdministeredDateTime" />
												</xsl:attribute>
											</high>
										</effectiveTime>
									</xsl:if>
									<xsl:if test ="AdministeredDateTime = '' and AdministeredDateTime1 != ''">
										<effectiveTime xsi:type="IVL_TS">
											<low value="20100425">
												<xsl:attribute name="value">
													<xsl:value-of select="AdministeredDateTime1" />
												</xsl:attribute>
											</low>
											<high>
												<xsl:attribute name="value">
													<xsl:value-of select="AdministeredDateTime1" />
												</xsl:attribute>
											</high>
										</effectiveTime>
									</xsl:if>

									<!-- Attribute: dose -->

									<consumable>
										<manufacturedProduct classCode="MANU">
											<!-- Medication Information (consolidation) template -->
											<templateId root="2.16.840.1.113883.10.20.22.4.23"/>
											<id root="561cd230-9e30-0130-2d0f-0800278bfb86"/>
											<manufacturedMaterial>
												<code codeSystem="2.16.840.1.113883.6.59" sdtc:valueSet="2.16.840.1.113883.3.464.1003.196.12.1214">
													<xsl:attribute name="code">
														<xsl:value-of select="VaccineCode" />
													</xsl:attribute>
													<originalText>
														Medication, Administered: <xsl:value-of select="VaccineName" />
													</originalText>
												</code>
											</manufacturedMaterial>
										</manufacturedProduct>
									</consumable>
								</substanceAdministration>
							</entryRelationship>
						</act>
					</entry>
				</xsl:if>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>


	<xsl:template name="PhysicalExams"  match="//PhysicalExams">
		<xsl:if test ="//PE-LOINC/questionCode != '' or //PE-ICD9/questionCode != '' or //PE-ICD10/questionCode != ''  or //PE-SNOMED/questionCode != ''">
			<xsl:for-each select="//PE-LOINC">
				<entry>
					<!-- Physical Exam Finding -->
					<observation classCode="OBS" moodCode="EVN">
						<!--  Result observation template -->
						<templateId root="2.16.840.1.113883.10.20.22.4.2"/>
						<!-- Physical Exam, Finding template -->
						<templateId root="2.16.840.1.113883.10.20.24.3.57"/>
						<id root="1.3.6.1.4.1.115" extension="519139181d41c8a94400008c"/>
						<code code="8462-4" codeSystem="2.16.840.1.113883.6.1">
							<xsl:attribute name="code">
								<xsl:value-of select="questionCode" />
							</xsl:attribute>
							<originalText>
								Physical Exam, Finding: <xsl:value-of select="questionName" />
							</originalText>
						</code>

						<statusCode code="completed"/>

						<effectiveTime>
							<low>
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</low>
							<high>
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</high>
						</effectiveTime>
						<value xsi:type="CD" nullFlavor="UNK"/>

					</observation>
				</entry>
			</xsl:for-each>
			<xsl:for-each select="//PE-ICD9">
				<entry>
					<!-- Physical Exam Finding -->
					<observation classCode="OBS" moodCode="EVN">
						<!--  Result observation template -->
						<templateId root="2.16.840.1.113883.10.20.22.4.2"/>
						<!-- Physical Exam, Finding template -->
						<templateId root="2.16.840.1.113883.10.20.24.3.57"/>
						<id root="1.3.6.1.4.1.115" extension="519139181d41c8a94400008c"/>
						<code code="8462-4" codeSystem="2.16.840.1.113883.6.103">
							<xsl:attribute name="code">
								<xsl:value-of select="questionCode" />
							</xsl:attribute>
							<originalText>
								Physical Exam, Finding: <xsl:value-of select="questionName" />
							</originalText>
						</code>

						<statusCode code="completed"/>

						<effectiveTime>
							<low>
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</low>
							<high>
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</high>
						</effectiveTime>
						<value xsi:type="CD" nullFlavor="UNK"/>

					</observation>
				</entry>
			</xsl:for-each>
			<xsl:for-each select="//PE-ICD10">
				<entry>
					<!-- Physical Exam Finding -->
					<observation classCode="OBS" moodCode="EVN">
						<!--  Result observation template -->
						<templateId root="2.16.840.1.113883.10.20.22.4.2"/>
						<!-- Physical Exam, Finding template -->
						<templateId root="2.16.840.1.113883.10.20.24.3.57"/>
						<id root="1.3.6.1.4.1.115" extension="519139181d41c8a94400008c"/>
						<code code="8462-4" codeSystem="2.16.840.1.113883.6.90">
							<xsl:attribute name="code">
								<xsl:value-of select="questionCode" />
							</xsl:attribute>
							<originalText>
								Physical Exam, Finding: <xsl:value-of select="questionName" />
							</originalText>
						</code>

						<statusCode code="completed"/>

						<effectiveTime>
							<low>
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</low>
							<high>
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</high>
						</effectiveTime>
						<value xsi:type="CD" nullFlavor="UNK"/>

					</observation>
				</entry>
			</xsl:for-each>
			<xsl:for-each select="//PE-SNOMED">
				<entry>
					<!-- Physical Exam Finding -->
					<observation classCode="OBS" moodCode="EVN">
						<!--  Result observation template -->
						<templateId root="2.16.840.1.113883.10.20.22.4.2"/>
						<!-- Physical Exam, Finding template -->
						<templateId root="2.16.840.1.113883.10.20.24.3.57"/>
						<id root="1.3.6.1.4.1.115" extension="519139181d41c8a94400008c"/>
						<code code="8462-4" codeSystem="2.16.840.1.113883.6.96">
							<xsl:attribute name="code">
								<xsl:value-of select="questionCode" />
							</xsl:attribute>
							<originalText>
								Physical Exam, Finding: <xsl:value-of select="questionName" />
							</originalText>
						</code>

						<statusCode code="completed"/>

						<effectiveTime>
							<low>
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</low>
							<high>
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</high>
						</effectiveTime>
						<value xsi:type="CD" nullFlavor="UNK"/>

					</observation>
				</entry>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<xsl:template name="Communications"  match="//Communications">
		<xsl:if test ="//Communication-SNOMED/questionCode != ''">
			<xsl:for-each select="//Communication-SNOMED">
				<entry>
					<act classCode="ACT" moodCode="EVN" >
						<!-- Communication from provider to provider -->
						<templateId root="2.16.840.1.113883.10.20.24.3.4"/>
						<id root="1.3.6.1.4.1.115" extension="519139191d41c8a9440000c1"/>
						<code code="371530004" codeSystem="2.16.840.1.113883.6.96">
							<xsl:attribute name="code">
								<xsl:value-of select="questionCode" />
							</xsl:attribute>
							<originalText>
								Communication: From Provider to Provider: <xsl:value-of select="questionName" />
							</originalText>
						</code>
						<text>
							Communication: From Provider to Provider:  <xsl:value-of select="questionName" />
						</text>
						<statusCode code="completed"/>

						<effectiveTime>
							<low>
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</low>
						</effectiveTime>

						<participant typeCode="AUT">
							<participantRole classCode="ASSIGNED">
								<code code="158965000" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED CT" displayName="Medical Practitioner"/>
							</participantRole>
						</participant>

						<participant typeCode="IRCP">
							<participantRole classCode="ASSIGNED">
								<code code="158965000" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED CT" displayName="Medical Practitioner"/>
							</participantRole>
						</participant>

					</act>
				</entry>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>


	<xsl:template name="DiagnosticStudys"  match="//DiagnosticStudys">
		<xsl:if test ="//Diagnostic-HCPCS/questionCode != '' or //Diagnostic-SNOMED/questionCode != '' or //Diagnostic-LOINC/questionCode != '' or Diagnostic-PR-LOINC/questionCode != '' ">
			<xsl:for-each select="//Diagnostic-HCPCS">
				<entry>
					<observation classCode="OBS" moodCode="RQO">
						<!-- Consolidated Plan of Care Activity Observation templateId (Implied Template) -->
						<templateId root="2.16.840.1.113883.10.20.22.4.44"/>
						<!-- Diagnostic Study, Order template -->
						<templateId root="2.16.840.1.113883.10.20.24.3.17"/>
						<id root="1.3.6.1.4.1.115" extension="519139181d41c8a944000098"/>
						<code code="11707-7" codeSystem="2.16.840.1.113883.6.90">
							<xsl:attribute name="code">
								<xsl:value-of select="questionCode" />
							</xsl:attribute>
							<originalText>
								Diagnostic Study, Order:<xsl:value-of select="questionName" />
							</originalText>
						</code>
						<text>
							Diagnostic Study, Order:<xsl:value-of select="questionName" />
						</text>
						<statusCode code="new"/>
						<!-- Attribute: datetime -->
						<author>
							<time value='19900430063833'>
								<xsl:attribute name="value">
									<xsl:value-of select="datetime" />
								</xsl:attribute>
							</time>
							<assignedAuthor>
								<!--left as null because of coding limit-->
								<id nullFlavor="NA" root="6364cee0-a37a-0130-f6ff-0800278bfb86"/>
							</assignedAuthor>
						</author>

					</observation>
				</entry>
			</xsl:for-each>
			<xsl:for-each select="//Diagnostic-SNOMED">
				<entry>
					<observation classCode="OBS" moodCode="RQO">
						<!-- Consolidated Plan of Care Activity Observation templateId (Implied Template) -->
						<templateId root="2.16.840.1.113883.10.20.22.4.44"/>
						<!-- Diagnostic Study, Order template -->
						<templateId root="2.16.840.1.113883.10.20.24.3.17"/>
						<id root="1.3.6.1.4.1.115" extension="519139181d41c8a944000098"/>
						<code code="11707-7" codeSystem="2.16.840.1.113883.6.96">
							<xsl:attribute name="code">
								<xsl:value-of select="questionCode" />
							</xsl:attribute>
							<originalText>
								Diagnostic Study, Order:<xsl:value-of select="questionName" />
							</originalText>
						</code>
						<text>
							Diagnostic Study, Order:<xsl:value-of select="questionName" />
						</text>
						<statusCode code="new"/>
						<!-- Attribute: datetime -->
						<author>
							<time value='19900430063833'>
								<xsl:attribute name="value">
									<xsl:value-of select="datetime" />
								</xsl:attribute>
							</time>
							<assignedAuthor>
								<!--left as null because of coding limit-->
								<id nullFlavor="NA" root="6364cee0-a37a-0130-f6ff-0800278bfb86"/>
							</assignedAuthor>
						</author>

					</observation>
				</entry>
			</xsl:for-each>
			<xsl:for-each select="//Diagnostic-LOINC">
				<entry>
					<observation classCode="OBS" moodCode="RQO">
						<!-- Consolidated Plan of Care Activity Observation templateId (Implied Template) -->
						<templateId root="2.16.840.1.113883.10.20.22.4.44"/>
						<!-- Diagnostic Study, Order template -->
						<templateId root="2.16.840.1.113883.10.20.24.3.17"/>
						<id root="1.3.6.1.4.1.115" extension="519139181d41c8a944000098"/>
						<code code="11707-7" codeSystem="2.16.840.1.113883.6.1">
							<xsl:attribute name="code">
								<xsl:value-of select="questionCode" />
							</xsl:attribute>
							<originalText>
								Diagnostic Study, Order:<xsl:value-of select="questionName" />
							</originalText>
						</code>
						<text>
							Diagnostic Study, Order:<xsl:value-of select="questionName" />
						</text>
						<statusCode code="new"/>
						<!-- Attribute: datetime -->
						<author>
							<time value='19900430063833'>
								<xsl:attribute name="value">
									<xsl:value-of select="datetime" />
								</xsl:attribute>
							</time>
							<assignedAuthor>
								<!--left as null because of coding limit-->
								<id nullFlavor="NA" root="6364cee0-a37a-0130-f6ff-0800278bfb86"/>
							</assignedAuthor>
						</author>

					</observation>
				</entry>
			</xsl:for-each>
			<xsl:for-each select="//Diagnostic-PR-LOINC">
				<entry>
					<observation classCode="OBS" moodCode="EVN" >
						<!-- Consolidated Procedure Activity Observation templateId 
       (Implied Template) -->
						<templateId root="2.16.840.1.113883.10.20.22.4.13"/>
						<!-- Diagnostic Study, Performed template -->
						<templateId root="2.16.840.1.113883.10.20.24.3.18"/>
						<id root="1.3.6.1.4.1.115" extension="519139191d41c8a9440000a6"/>
						<code nullFlavor="UNK">
							<originalText>Diagnostic Study, Performed: </originalText>
							<translation code="24665-2" codeSystem="2.16.840.1.113883.6.1">
								<xsl:attribute name="code">
									<xsl:value-of select="questionCode" />
								</xsl:attribute>
							</translation>
						</code>
						<text>
							Diagnostic Study, Performed: <xsl:value-of select="questionName" />
						</text>
						<statusCode code="completed"/>
						<effectiveTime>
							<low>
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</low>
							<high>
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</high>
						</effectiveTime>
						<value xsi:type="CD" nullFlavor="UNK"/>


					</observation>
				</entry>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>

	<xsl:template name="FunctionalStatus"  match="//FunctionalStatus">
		<xsl:if test ="//FunctionalStatus-LOINC/questionCode != '' ">
			<xsl:for-each select="//FunctionalStatus-LOINC">
				<entry>
					<observation classCode="OBS" moodCode="EVN">
						<!-- Functional Status Result Observation (consolidation) template -->
						<templateId root="2.16.840.1.113883.10.20.22.4.67"/>
						<!-- Functional Status, Result template -->
						<templateId root="2.16.840.1.113883.10.20.24.3.28"/>
						<id root="1.3.6.1.4.1.115" extension="519139191d41c8a9440000c2"/>
						<code code="71938-5" codeSystem="2.16.840.1.113883.6.1">
							<xsl:attribute name="code">
								<xsl:value-of select="questionCode" />
							</xsl:attribute>		
							<originalText>Functional Status, Result: <xsl:value-of select="questionName" /> </originalText>
						</code>
						<text>Functional Status, Result: <xsl:value-of select="questionName" />	</text>
					<statusCode code="completed"/>

						<effectiveTime>
							<low>
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</low>
							<high>
								<xsl:attribute name="value">
									<xsl:value-of select="dateTime" />
								</xsl:attribute>
							</high>
						</effectiveTime>

						<!-- Result -->
						<value xsi:type="CD" nullFlavor="UNK"/>

					</observation>
				</entry>
			</xsl:for-each>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
