ALTER TABLE Attachment NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[AttachmentContentType] = newdata.[AttachmentContentType]
, olddata.[AttachmentContentSize] = newdata.[AttachmentContentSize]
, olddata.[CompressionUid] = newdata.[CompressionUid]
, olddata.[UncompressedAttachmentContentSize] = newdata.[UncompressedAttachmentContentSize]
, olddata.[FileName] = newdata.[FileName]
, olddata.[FileExtension] = newdata.[FileExtension]
FROM migtemp_Attachment AS newdata
INNER JOIN Attachment AS olddata ON
newdata.AttachmentUid = olddata.AttachmentUid
GO
INSERT Attachment
SELECT newdata.*
FROM migtemp_Attachment AS newdata
LEFT JOIN Attachment AS olddata ON
newdata.AttachmentUid = olddata.AttachmentUid
WHERE
olddata.AttachmentUid IS NULL
GO
DROP TABLE migtemp_Attachment
GO
ALTER TABLE AttachmentGroup NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_AttachmentGroup AS newdata
INNER JOIN AttachmentGroup AS olddata ON
newdata.AttachmentGroupUid = olddata.AttachmentGroupUid
GO
INSERT AttachmentGroup
SELECT newdata.*
FROM migtemp_AttachmentGroup AS newdata
LEFT JOIN AttachmentGroup AS olddata ON
newdata.AttachmentGroupUid = olddata.AttachmentGroupUid
WHERE
olddata.AttachmentGroupUid IS NULL
GO
DROP TABLE migtemp_AttachmentGroup
GO
ALTER TABLE CCSystem NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[LicenseCode] = newdata.[LicenseCode]
FROM migtemp_CCSystem AS newdata
INNER JOIN CCSystem AS olddata ON
newdata.CCSystemUid = olddata.CCSystemUid
GO
INSERT CCSystem
SELECT newdata.*
FROM migtemp_CCSystem AS newdata
LEFT JOIN CCSystem AS olddata ON
newdata.CCSystemUid = olddata.CCSystemUid
WHERE
olddata.CCSystemUid IS NULL
GO
DROP TABLE migtemp_CCSystem
GO
ALTER TABLE ChcListAgriculturalWorkStatus NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ChcListAgriculturalWorkStatus AS newdata
INNER JOIN ChcListAgriculturalWorkStatus AS olddata ON
newdata.AgriculturalWorkStatusUid = olddata.AgriculturalWorkStatusUid
GO
INSERT ChcListAgriculturalWorkStatus
SELECT newdata.*
FROM migtemp_ChcListAgriculturalWorkStatus AS newdata
LEFT JOIN ChcListAgriculturalWorkStatus AS olddata ON
newdata.AgriculturalWorkStatusUid = olddata.AgriculturalWorkStatusUid
WHERE
olddata.AgriculturalWorkStatusUid IS NULL
GO
DROP TABLE migtemp_ChcListAgriculturalWorkStatus
GO
ALTER TABLE ChcListCitizenship NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ChcListCitizenship AS newdata
INNER JOIN ChcListCitizenship AS olddata ON
newdata.CitizenshipUid = olddata.CitizenshipUid
GO
INSERT ChcListCitizenship
SELECT newdata.*
FROM migtemp_ChcListCitizenship AS newdata
LEFT JOIN ChcListCitizenship AS olddata ON
newdata.CitizenshipUid = olddata.CitizenshipUid
WHERE
olddata.CitizenshipUid IS NULL
GO
DROP TABLE migtemp_ChcListCitizenship
GO
ALTER TABLE ChcListContractTypeCode NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ChcListContractTypeCode AS newdata
INNER JOIN ChcListContractTypeCode AS olddata ON
newdata.ContractTypeCodeUid = olddata.ContractTypeCodeUid
GO
INSERT ChcListContractTypeCode
SELECT newdata.*
FROM migtemp_ChcListContractTypeCode AS newdata
LEFT JOIN ChcListContractTypeCode AS olddata ON
newdata.ContractTypeCodeUid = olddata.ContractTypeCodeUid
WHERE
olddata.ContractTypeCodeUid IS NULL
GO
DROP TABLE migtemp_ChcListContractTypeCode
GO
ALTER TABLE ChcListEducation NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ChcListEducation AS newdata
INNER JOIN ChcListEducation AS olddata ON
newdata.EducationUid = olddata.EducationUid
GO
INSERT ChcListEducation
SELECT newdata.*
FROM migtemp_ChcListEducation AS newdata
LEFT JOIN ChcListEducation AS olddata ON
newdata.EducationUid = olddata.EducationUid
WHERE
olddata.EducationUid IS NULL
GO
DROP TABLE migtemp_ChcListEducation
GO
ALTER TABLE ChcListFinancialClass NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ChcListFinancialClass AS newdata
INNER JOIN ChcListFinancialClass AS olddata ON
newdata.FinancialClassUid = olddata.FinancialClassUid
GO
INSERT ChcListFinancialClass
SELECT newdata.*
FROM migtemp_ChcListFinancialClass AS newdata
LEFT JOIN ChcListFinancialClass AS olddata ON
newdata.FinancialClassUid = olddata.FinancialClassUid
WHERE
olddata.FinancialClassUid IS NULL
GO
DROP TABLE migtemp_ChcListFinancialClass
GO
ALTER TABLE ChcListFPLRegion NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ChcListFPLRegion AS newdata
INNER JOIN ChcListFPLRegion AS olddata ON
newdata.FPLRegionUid = olddata.FPLRegionUid
GO
INSERT ChcListFPLRegion
SELECT newdata.*
FROM migtemp_ChcListFPLRegion AS newdata
LEFT JOIN ChcListFPLRegion AS olddata ON
newdata.FPLRegionUid = olddata.FPLRegionUid
WHERE
olddata.FPLRegionUid IS NULL
GO
DROP TABLE migtemp_ChcListFPLRegion
GO
ALTER TABLE ChcListFPLSchedule NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ChcListFPLSchedule AS newdata
INNER JOIN ChcListFPLSchedule AS olddata ON
newdata.FPLScheduleUid = olddata.FPLScheduleUid
GO
INSERT ChcListFPLSchedule
SELECT newdata.*
FROM migtemp_ChcListFPLSchedule AS newdata
LEFT JOIN ChcListFPLSchedule AS olddata ON
newdata.FPLScheduleUid = olddata.FPLScheduleUid
WHERE
olddata.FPLScheduleUid IS NULL
GO
DROP TABLE migtemp_ChcListFPLSchedule
GO
ALTER TABLE ChcListHomelessStatus NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ChcListHomelessStatus AS newdata
INNER JOIN ChcListHomelessStatus AS olddata ON
newdata.HomelessStatusUid = olddata.HomelessStatusUid
GO
INSERT ChcListHomelessStatus
SELECT newdata.*
FROM migtemp_ChcListHomelessStatus AS newdata
LEFT JOIN ChcListHomelessStatus AS olddata ON
newdata.HomelessStatusUid = olddata.HomelessStatusUid
WHERE
olddata.HomelessStatusUid IS NULL
GO
DROP TABLE migtemp_ChcListHomelessStatus
GO
ALTER TABLE ChcListPayorPlanSet NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ChcListPayorPlanSet AS newdata
INNER JOIN ChcListPayorPlanSet AS olddata ON
newdata.PayorPlanSetUid = olddata.PayorPlanSetUid
GO
INSERT ChcListPayorPlanSet
SELECT newdata.*
FROM migtemp_ChcListPayorPlanSet AS newdata
LEFT JOIN ChcListPayorPlanSet AS olddata ON
newdata.PayorPlanSetUid = olddata.PayorPlanSetUid
WHERE
olddata.PayorPlanSetUid IS NULL
GO
DROP TABLE migtemp_ChcListPayorPlanSet
GO
ALTER TABLE ChcListPayorPlanSetRange NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ChcListPayorPlanSetRange AS newdata
INNER JOIN ChcListPayorPlanSetRange AS olddata ON
newdata.PayorPlanSetRangeUid = olddata.PayorPlanSetRangeUid
GO
INSERT ChcListPayorPlanSetRange
SELECT newdata.*
FROM migtemp_ChcListPayorPlanSetRange AS newdata
LEFT JOIN ChcListPayorPlanSetRange AS olddata ON
newdata.PayorPlanSetRangeUid = olddata.PayorPlanSetRangeUid
WHERE
olddata.PayorPlanSetRangeUid IS NULL
GO
DROP TABLE migtemp_ChcListPayorPlanSetRange
GO
ALTER TABLE ChcListPayorPlanType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ChcListPayorPlanType AS newdata
INNER JOIN ChcListPayorPlanType AS olddata ON
newdata.PayorPlanTypeUid = olddata.PayorPlanTypeUid
GO
INSERT ChcListPayorPlanType
SELECT newdata.*
FROM migtemp_ChcListPayorPlanType AS newdata
LEFT JOIN ChcListPayorPlanType AS olddata ON
newdata.PayorPlanTypeUid = olddata.PayorPlanTypeUid
WHERE
olddata.PayorPlanTypeUid IS NULL
GO
DROP TABLE migtemp_ChcListPayorPlanType
GO
ALTER TABLE ChcListPrimaryInsType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ChcListPrimaryInsType AS newdata
INNER JOIN ChcListPrimaryInsType AS olddata ON
newdata.PrimaryInsTypeUid = olddata.PrimaryInsTypeUid
GO
INSERT ChcListPrimaryInsType
SELECT newdata.*
FROM migtemp_ChcListPrimaryInsType AS newdata
LEFT JOIN ChcListPrimaryInsType AS olddata ON
newdata.PrimaryInsTypeUid = olddata.PrimaryInsTypeUid
WHERE
olddata.PrimaryInsTypeUid IS NULL
GO
DROP TABLE migtemp_ChcListPrimaryInsType
GO
ALTER TABLE ChcListPriorMedical NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ChcListPriorMedical AS newdata
INNER JOIN ChcListPriorMedical AS olddata ON
newdata.PriorMedicalUid = olddata.PriorMedicalUid
GO
INSERT ChcListPriorMedical
SELECT newdata.*
FROM migtemp_ChcListPriorMedical AS newdata
LEFT JOIN ChcListPriorMedical AS olddata ON
newdata.PriorMedicalUid = olddata.PriorMedicalUid
WHERE
olddata.PriorMedicalUid IS NULL
GO
DROP TABLE migtemp_ChcListPriorMedical
GO
ALTER TABLE ChcListProcedureModifierType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ChcListProcedureModifierType AS newdata
INNER JOIN ChcListProcedureModifierType AS olddata ON
newdata.ProcedureModifierTypeUid = olddata.ProcedureModifierTypeUid
GO
INSERT ChcListProcedureModifierType
SELECT newdata.*
FROM migtemp_ChcListProcedureModifierType AS newdata
LEFT JOIN ChcListProcedureModifierType AS olddata ON
newdata.ProcedureModifierTypeUid = olddata.ProcedureModifierTypeUid
WHERE
olddata.ProcedureModifierTypeUid IS NULL
GO
DROP TABLE migtemp_ChcListProcedureModifierType
GO
ALTER TABLE ChcListReferralSource NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ChcListReferralSource AS newdata
INNER JOIN ChcListReferralSource AS olddata ON
newdata.ReferralSourceUid = olddata.ReferralSourceUid
GO
INSERT ChcListReferralSource
SELECT newdata.*
FROM migtemp_ChcListReferralSource AS newdata
LEFT JOIN ChcListReferralSource AS olddata ON
newdata.ReferralSourceUid = olddata.ReferralSourceUid
WHERE
olddata.ReferralSourceUid IS NULL
GO
DROP TABLE migtemp_ChcListReferralSource
GO
ALTER TABLE ChcListSFFormOfDeclaration NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ChcListSFFormOfDeclaration AS newdata
INNER JOIN ChcListSFFormOfDeclaration AS olddata ON
newdata.SFFormOfDeclarationUid = olddata.SFFormOfDeclarationUid
GO
INSERT ChcListSFFormOfDeclaration
SELECT newdata.*
FROM migtemp_ChcListSFFormOfDeclaration AS newdata
LEFT JOIN ChcListSFFormOfDeclaration AS olddata ON
newdata.SFFormOfDeclarationUid = olddata.SFFormOfDeclarationUid
WHERE
olddata.SFFormOfDeclarationUid IS NULL
GO
DROP TABLE migtemp_ChcListSFFormOfDeclaration
GO
ALTER TABLE ChcListSFSchedule NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ChcListSFSchedule AS newdata
INNER JOIN ChcListSFSchedule AS olddata ON
newdata.SFScheduleUid = olddata.SFScheduleUid
GO
INSERT ChcListSFSchedule
SELECT newdata.*
FROM migtemp_ChcListSFSchedule AS newdata
LEFT JOIN ChcListSFSchedule AS olddata ON
newdata.SFScheduleUid = olddata.SFScheduleUid
WHERE
olddata.SFScheduleUid IS NULL
GO
DROP TABLE migtemp_ChcListSFSchedule
GO
ALTER TABLE ChcListVeteranStatus NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ChcListVeteranStatus AS newdata
INNER JOIN ChcListVeteranStatus AS olddata ON
newdata.VeteranStatusUid = olddata.VeteranStatusUid
GO
INSERT ChcListVeteranStatus
SELECT newdata.*
FROM migtemp_ChcListVeteranStatus AS newdata
LEFT JOIN ChcListVeteranStatus AS olddata ON
newdata.VeteranStatusUid = olddata.VeteranStatusUid
WHERE
olddata.VeteranStatusUid IS NULL
GO
DROP TABLE migtemp_ChcListVeteranStatus
GO
ALTER TABLE ClaimFormatOption NOCHECK CONSTRAINT ALL
GO
INSERT ClaimFormatOption
SELECT newdata.*
FROM migtemp_ClaimFormatOption AS newdata
LEFT JOIN ClaimFormatOption AS olddata ON
newdata.ClaimFormatOptionUid = olddata.ClaimFormatOptionUid
WHERE
olddata.ClaimFormatOptionUid IS NULL
GO
DROP TABLE migtemp_ClaimFormatOption
GO
ALTER TABLE ClaimFormatValue NOCHECK CONSTRAINT ALL
GO
INSERT ClaimFormatValue
SELECT newdata.*
FROM migtemp_ClaimFormatValue AS newdata
LEFT JOIN ClaimFormatValue AS olddata ON
newdata.ClaimFormatValueUid = olddata.ClaimFormatValueUid
WHERE
olddata.ClaimFormatValueUid IS NULL
GO
DROP TABLE migtemp_ClaimFormatValue
GO
ALTER TABLE ClinicCenterSettings NOCHECK CONSTRAINT ALL
GO
INSERT ClinicCenterSettings
SELECT newdata.*
FROM migtemp_ClinicCenterSettings AS newdata
LEFT JOIN ClinicCenterSettings AS olddata ON
newdata.ClinicCenterSettingsUid = olddata.ClinicCenterSettingsUid
WHERE
olddata.ClinicCenterSettingsUid IS NULL
GO
DROP TABLE migtemp_ClinicCenterSettings
GO
ALTER TABLE CollectionStatusGlobal NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_CollectionStatusGlobal AS newdata
INNER JOIN CollectionStatusGlobal AS olddata ON
newdata.CollectionStatusGlobalUid = olddata.CollectionStatusGlobalUid
GO
INSERT CollectionStatusGlobal
SELECT newdata.*
FROM migtemp_CollectionStatusGlobal AS newdata
LEFT JOIN CollectionStatusGlobal AS olddata ON
newdata.CollectionStatusGlobalUid = olddata.CollectionStatusGlobalUid
WHERE
olddata.CollectionStatusGlobalUid IS NULL
GO
DROP TABLE migtemp_CollectionStatusGlobal
GO
ALTER TABLE CollectionStatusLevel NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_CollectionStatusLevel AS newdata
INNER JOIN CollectionStatusLevel AS olddata ON
newdata.CollectionStatusLevelUid = olddata.CollectionStatusLevelUid
GO
INSERT CollectionStatusLevel
SELECT newdata.*
FROM migtemp_CollectionStatusLevel AS newdata
LEFT JOIN CollectionStatusLevel AS olddata ON
newdata.CollectionStatusLevelUid = olddata.CollectionStatusLevelUid
WHERE
olddata.CollectionStatusLevelUid IS NULL
GO
DROP TABLE migtemp_CollectionStatusLevel
GO
ALTER TABLE Corporation NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_Corporation AS newdata
INNER JOIN Corporation AS olddata ON
newdata.CorporationUid = olddata.CorporationUid
GO
INSERT Corporation
SELECT newdata.*
FROM migtemp_Corporation AS newdata
LEFT JOIN Corporation AS olddata ON
newdata.CorporationUid = olddata.CorporationUid
WHERE
olddata.CorporationUid IS NULL
GO
DROP TABLE migtemp_Corporation
GO
ALTER TABLE CppCC NOCHECK CONSTRAINT ALL
GO
INSERT CppCC
SELECT newdata.*
FROM migtemp_CppCC AS newdata
LEFT JOIN CppCC AS olddata ON
newdata.CppCCUid = olddata.CppCCUid
WHERE
olddata.CppCCUid IS NULL
GO
DROP TABLE migtemp_CppCC
GO
ALTER TABLE CppDiagnosis NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_CppDiagnosis AS newdata
INNER JOIN CppDiagnosis AS olddata ON
newdata.CppDiagnosisUid = olddata.CppDiagnosisUid
GO
INSERT CppDiagnosis
SELECT newdata.*
FROM migtemp_CppDiagnosis AS newdata
LEFT JOIN CppDiagnosis AS olddata ON
newdata.CppDiagnosisUid = olddata.CppDiagnosisUid
WHERE
olddata.CppDiagnosisUid IS NULL
GO
DROP TABLE migtemp_CppDiagnosis
GO
ALTER TABLE CppHpi NOCHECK CONSTRAINT ALL
GO
INSERT CppHpi
SELECT newdata.*
FROM migtemp_CppHpi AS newdata
LEFT JOIN CppHpi AS olddata ON
newdata.CppHpiUid = olddata.CppHpiUid
WHERE
olddata.CppHpiUid IS NULL
GO
DROP TABLE migtemp_CppHpi
GO
ALTER TABLE CppMedication NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_CppMedication AS newdata
INNER JOIN CppMedication AS olddata ON
newdata.CppMedicationUid = olddata.CppMedicationUid
GO
INSERT CppMedication
SELECT newdata.*
FROM migtemp_CppMedication AS newdata
LEFT JOIN CppMedication AS olddata ON
newdata.CppMedicationUid = olddata.CppMedicationUid
WHERE
olddata.CppMedicationUid IS NULL
GO
DROP TABLE migtemp_CppMedication
GO
ALTER TABLE CppSP NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_CppSP AS newdata
INNER JOIN CppSP AS olddata ON
newdata.CppSPUid = olddata.CppSPUid
GO
INSERT CppSP
SELECT newdata.*
FROM migtemp_CppSP AS newdata
LEFT JOIN CppSP AS olddata ON
newdata.CppSPUid = olddata.CppSPUid
WHERE
olddata.CppSPUid IS NULL
GO
DROP TABLE migtemp_CppSP
GO
ALTER TABLE CVXVISMap NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_CVXVISMap AS newdata
INNER JOIN CVXVISMap AS olddata ON
newdata.CVXVISMapUid = olddata.CVXVISMapUid
GO
INSERT CVXVISMap
SELECT newdata.*
FROM migtemp_CVXVISMap AS newdata
LEFT JOIN CVXVISMap AS olddata ON
newdata.CVXVISMapUid = olddata.CVXVISMapUid
WHERE
olddata.CVXVISMapUid IS NULL
GO
DROP TABLE migtemp_CVXVISMap
GO
ALTER TABLE DefaultMedicationUnit NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_DefaultMedicationUnit AS newdata
INNER JOIN DefaultMedicationUnit AS olddata ON
newdata.DefaultMedicationUnitUid = olddata.DefaultMedicationUnitUid
GO
INSERT DefaultMedicationUnit
SELECT newdata.*
FROM migtemp_DefaultMedicationUnit AS newdata
LEFT JOIN DefaultMedicationUnit AS olddata ON
newdata.DefaultMedicationUnitUid = olddata.DefaultMedicationUnitUid
WHERE
olddata.DefaultMedicationUnitUid IS NULL
GO
DROP TABLE migtemp_DefaultMedicationUnit
GO
ALTER TABLE EmailUnsubscribeGroup NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_EmailUnsubscribeGroup AS newdata
INNER JOIN EmailUnsubscribeGroup AS olddata ON
newdata.EmailUnsubscribeGroupUid = olddata.EmailUnsubscribeGroupUid
GO
INSERT EmailUnsubscribeGroup
SELECT newdata.*
FROM migtemp_EmailUnsubscribeGroup AS newdata
LEFT JOIN EmailUnsubscribeGroup AS olddata ON
newdata.EmailUnsubscribeGroupUid = olddata.EmailUnsubscribeGroupUid
WHERE
olddata.EmailUnsubscribeGroupUid IS NULL
GO
DROP TABLE migtemp_EmailUnsubscribeGroup
GO
ALTER TABLE EMMapping NOCHECK CONSTRAINT ALL
GO
INSERT EMMapping
SELECT newdata.*
FROM migtemp_EMMapping AS newdata
LEFT JOIN EMMapping AS olddata ON
newdata.EMMappingUid = olddata.EMMappingUid
WHERE
olddata.EMMappingUid IS NULL
GO
DROP TABLE migtemp_EMMapping
GO
ALTER TABLE eRSDTriggerCodes NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_eRSDTriggerCodes AS newdata
INNER JOIN eRSDTriggerCodes AS olddata ON
newdata.eRSDUid = olddata.eRSDUid
GO
INSERT eRSDTriggerCodes
SELECT newdata.*
FROM migtemp_eRSDTriggerCodes AS newdata
LEFT JOIN eRSDTriggerCodes AS olddata ON
newdata.eRSDUid = olddata.eRSDUid
WHERE
olddata.eRSDUid IS NULL
GO
DROP TABLE migtemp_eRSDTriggerCodes
GO
ALTER TABLE ExternalMaterialSource NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ExternalMaterialSource AS newdata
INNER JOIN ExternalMaterialSource AS olddata ON
newdata.ExternalMaterialSourceUid = olddata.ExternalMaterialSourceUid
GO
INSERT ExternalMaterialSource
SELECT newdata.*
FROM migtemp_ExternalMaterialSource AS newdata
LEFT JOIN ExternalMaterialSource AS olddata ON
newdata.ExternalMaterialSourceUid = olddata.ExternalMaterialSourceUid
WHERE
olddata.ExternalMaterialSourceUid IS NULL
GO
DROP TABLE migtemp_ExternalMaterialSource
GO
ALTER TABLE ExternalMaterialSourceCategory NOCHECK CONSTRAINT ALL
GO
INSERT ExternalMaterialSourceCategory
SELECT newdata.*
FROM migtemp_ExternalMaterialSourceCategory AS newdata
LEFT JOIN ExternalMaterialSourceCategory AS olddata ON
newdata.ExternalMaterialSourceCategoryUid = olddata.ExternalMaterialSourceCategoryUid
WHERE
olddata.ExternalMaterialSourceCategoryUid IS NULL
GO
DROP TABLE migtemp_ExternalMaterialSourceCategory
GO
ALTER TABLE EZPAYBINTEST NOCHECK CONSTRAINT ALL
GO
INSERT EZPAYBINTEST
SELECT newdata.*
FROM migtemp_EZPAYBINTEST AS newdata
LEFT JOIN EZPAYBINTEST AS olddata ON
newdata.BinTestUid = olddata.BinTestUid
WHERE
olddata.BinTestUid IS NULL
GO
DROP TABLE migtemp_EZPAYBINTEST
GO
ALTER TABLE EZPAYCONNECTION_SETTINGS NOCHECK CONSTRAINT ALL
GO
INSERT EZPAYCONNECTION_SETTINGS
SELECT newdata.*
FROM migtemp_EZPAYCONNECTION_SETTINGS AS newdata
LEFT JOIN EZPAYCONNECTION_SETTINGS AS olddata ON
newdata.ConnectionSettingsUid = olddata.ConnectionSettingsUid
WHERE
olddata.ConnectionSettingsUid IS NULL
GO
DROP TABLE migtemp_EZPAYCONNECTION_SETTINGS
GO
ALTER TABLE EZPAYERROR_CODES NOCHECK CONSTRAINT ALL
GO
INSERT EZPAYERROR_CODES
SELECT newdata.*
FROM migtemp_EZPAYERROR_CODES AS newdata
LEFT JOIN EZPAYERROR_CODES AS olddata ON
newdata.ErrorCodesUid = olddata.ErrorCodesUid
WHERE
olddata.ErrorCodesUid IS NULL
GO
DROP TABLE migtemp_EZPAYERROR_CODES
GO
ALTER TABLE EZPAYMERCHANT_SETTINGS NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_EZPAYMERCHANT_SETTINGS AS newdata
INNER JOIN EZPAYMERCHANT_SETTINGS AS olddata ON
newdata.MerchantSettingsUid = olddata.MerchantSettingsUid
GO
INSERT EZPAYMERCHANT_SETTINGS
SELECT newdata.*
FROM migtemp_EZPAYMERCHANT_SETTINGS AS newdata
LEFT JOIN EZPAYMERCHANT_SETTINGS AS olddata ON
newdata.MerchantSettingsUid = olddata.MerchantSettingsUid
WHERE
olddata.MerchantSettingsUid IS NULL
GO
DROP TABLE migtemp_EZPAYMERCHANT_SETTINGS
GO
ALTER TABLE FeeSchedule NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_FeeSchedule AS newdata
INNER JOIN FeeSchedule AS olddata ON
newdata.FeeScheduleUid = olddata.FeeScheduleUid
GO
INSERT FeeSchedule
SELECT newdata.*
FROM migtemp_FeeSchedule AS newdata
LEFT JOIN FeeSchedule AS olddata ON
newdata.FeeScheduleUid = olddata.FeeScheduleUid
WHERE
olddata.FeeScheduleUid IS NULL
GO
DROP TABLE migtemp_FeeSchedule
GO
ALTER TABLE FeeScheduleFee NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_FeeScheduleFee AS newdata
INNER JOIN FeeScheduleFee AS olddata ON
newdata.FeeScheduleFeeUid = olddata.FeeScheduleFeeUid
GO
INSERT FeeScheduleFee
SELECT newdata.*
FROM migtemp_FeeScheduleFee AS newdata
LEFT JOIN FeeScheduleFee AS olddata ON
newdata.FeeScheduleFeeUid = olddata.FeeScheduleFeeUid
WHERE
olddata.FeeScheduleFeeUid IS NULL
GO
DROP TABLE migtemp_FeeScheduleFee
GO
ALTER TABLE FeeSchedulePeriod NOCHECK CONSTRAINT ALL
GO
INSERT FeeSchedulePeriod
SELECT newdata.*
FROM migtemp_FeeSchedulePeriod AS newdata
LEFT JOIN FeeSchedulePeriod AS olddata ON
newdata.FeeSchedulePeriodUid = olddata.FeeSchedulePeriodUid
WHERE
olddata.FeeSchedulePeriodUid IS NULL
GO
DROP TABLE migtemp_FeeSchedulePeriod
GO
ALTER TABLE FinancialCenter NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_FinancialCenter AS newdata
INNER JOIN FinancialCenter AS olddata ON
newdata.FinancialCenterUid = olddata.FinancialCenterUid
GO
INSERT FinancialCenter
SELECT newdata.*
FROM migtemp_FinancialCenter AS newdata
LEFT JOIN FinancialCenter AS olddata ON
newdata.FinancialCenterUid = olddata.FinancialCenterUid
WHERE
olddata.FinancialCenterUid IS NULL
GO
DROP TABLE migtemp_FinancialCenter
GO
ALTER TABLE HL7MappedField NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_HL7MappedField AS newdata
INNER JOIN HL7MappedField AS olddata ON
newdata.HL7MappedFieldUid = olddata.HL7MappedFieldUid
GO
INSERT HL7MappedField
SELECT newdata.*
FROM migtemp_HL7MappedField AS newdata
LEFT JOIN HL7MappedField AS olddata ON
newdata.HL7MappedFieldUid = olddata.HL7MappedFieldUid
WHERE
olddata.HL7MappedFieldUid IS NULL
GO
DROP TABLE migtemp_HL7MappedField
GO
ALTER TABLE HL7MappedSegment NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_HL7MappedSegment AS newdata
INNER JOIN HL7MappedSegment AS olddata ON
newdata.HL7MappedSegmentUid = olddata.HL7MappedSegmentUid
GO
INSERT HL7MappedSegment
SELECT newdata.*
FROM migtemp_HL7MappedSegment AS newdata
LEFT JOIN HL7MappedSegment AS olddata ON
newdata.HL7MappedSegmentUid = olddata.HL7MappedSegmentUid
WHERE
olddata.HL7MappedSegmentUid IS NULL
GO
DROP TABLE migtemp_HL7MappedSegment
GO
ALTER TABLE HL7Partner NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_HL7Partner AS newdata
INNER JOIN HL7Partner AS olddata ON
newdata.HL7PartnerUid = olddata.HL7PartnerUid
GO
INSERT HL7Partner
SELECT newdata.*
FROM migtemp_HL7Partner AS newdata
LEFT JOIN HL7Partner AS olddata ON
newdata.HL7PartnerUid = olddata.HL7PartnerUid
WHERE
olddata.HL7PartnerUid IS NULL
GO
DROP TABLE migtemp_HL7Partner
GO
ALTER TABLE HL7PartnerMessage NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[OrderActionTemplateXml] = newdata.[OrderActionTemplateXml]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_HL7PartnerMessage AS newdata
INNER JOIN HL7PartnerMessage AS olddata ON
newdata.HL7PartnerMessageUid = olddata.HL7PartnerMessageUid
GO
INSERT HL7PartnerMessage
SELECT newdata.*
FROM migtemp_HL7PartnerMessage AS newdata
LEFT JOIN HL7PartnerMessage AS olddata ON
newdata.HL7PartnerMessageUid = olddata.HL7PartnerMessageUid
WHERE
olddata.HL7PartnerMessageUid IS NULL
GO
DROP TABLE migtemp_HL7PartnerMessage
GO
ALTER TABLE HMRuleObservationTest NOCHECK CONSTRAINT ALL
GO
INSERT HMRuleObservationTest
SELECT newdata.*
FROM migtemp_HMRuleObservationTest AS newdata
LEFT JOIN HMRuleObservationTest AS olddata ON
newdata.HMRuleObservationTestUid = olddata.HMRuleObservationTestUid
WHERE
olddata.HMRuleObservationTestUid IS NULL
GO
DROP TABLE migtemp_HMRuleObservationTest
GO
ALTER TABLE InterfaceDataMapping NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Rootid] = newdata.[Rootid]
, olddata.[Name] = newdata.[Name]
, olddata.[CCDCode] = newdata.[CCDCode]
, olddata.[PRMCode] = newdata.[PRMCode]
, olddata.[CCDPrintName] = newdata.[CCDPrintName]
, olddata.[IsDefault] = newdata.[IsDefault]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[UserDefined] = newdata.[UserDefined]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[LastModifiedByUid] = newdata.[LastModifiedByUid]
, olddata.[QRDAMeasure] = newdata.[QRDAMeasure]
, olddata.[TopicIndicator] = newdata.[TopicIndicator]
, olddata.[NQFNumber] = newdata.[NQFNumber]
, olddata.[DataElementName] = newdata.[DataElementName]
, olddata.[Modifier] = newdata.[Modifier]
, olddata.[EndDate] = newdata.[EndDate]
FROM migtemp_InterfaceDataMapping AS newdata
INNER JOIN InterfaceDataMapping AS olddata ON
newdata.InterfaceDataMappingUid = olddata.InterfaceDataMappingUid
GO
INSERT InterfaceDataMapping
SELECT newdata.*
FROM migtemp_InterfaceDataMapping AS newdata
LEFT JOIN InterfaceDataMapping AS olddata ON
newdata.InterfaceDataMappingUid = olddata.InterfaceDataMappingUid
WHERE
olddata.InterfaceDataMappingUid IS NULL
GO
DROP TABLE migtemp_InterfaceDataMapping
GO
ALTER TABLE JobSchedule NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[JobServer] = newdata.[JobServer]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_JobSchedule AS newdata
INNER JOIN JobSchedule AS olddata ON
newdata.JobScheduleUid = olddata.JobScheduleUid
GO
INSERT JobSchedule
SELECT newdata.*
FROM migtemp_JobSchedule AS newdata
LEFT JOIN JobSchedule AS olddata ON
newdata.JobScheduleUid = olddata.JobScheduleUid
WHERE
olddata.JobScheduleUid IS NULL
GO
DROP TABLE migtemp_JobSchedule
GO
ALTER TABLE ListAccountType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListAccountType AS newdata
INNER JOIN ListAccountType AS olddata ON
newdata.AccountTypeUid = olddata.AccountTypeUid
GO
INSERT ListAccountType
SELECT newdata.*
FROM migtemp_ListAccountType AS newdata
LEFT JOIN ListAccountType AS olddata ON
newdata.AccountTypeUid = olddata.AccountTypeUid
WHERE
olddata.AccountTypeUid IS NULL
GO
DROP TABLE migtemp_ListAccountType
GO
ALTER TABLE ListAddIn NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[AcquirerAssemblyQualifiedName] = newdata.[AcquirerAssemblyQualifiedName]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[LicenseCode] = newdata.[LicenseCode]
, olddata.[ViewerAssemblyQualifiedName] = newdata.[ViewerAssemblyQualifiedName]
, olddata.[AttachmentContentType] = newdata.[AttachmentContentType]
FROM migtemp_ListAddIn AS newdata
INNER JOIN ListAddIn AS olddata ON
newdata.AddInUid = olddata.AddInUid
GO
INSERT ListAddIn
SELECT newdata.*
FROM migtemp_ListAddIn AS newdata
LEFT JOIN ListAddIn AS olddata ON
newdata.AddInUid = olddata.AddInUid
WHERE
olddata.AddInUid IS NULL
GO
DROP TABLE migtemp_ListAddIn
GO
ALTER TABLE ListAddInType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListAddInType AS newdata
INNER JOIN ListAddInType AS olddata ON
newdata.AddInTypeUid = olddata.AddInTypeUid
GO
INSERT ListAddInType
SELECT newdata.*
FROM migtemp_ListAddInType AS newdata
LEFT JOIN ListAddInType AS olddata ON
newdata.AddInTypeUid = olddata.AddInTypeUid
WHERE
olddata.AddInTypeUid IS NULL
GO
DROP TABLE migtemp_ListAddInType
GO
ALTER TABLE ListAdmissionSource NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListAdmissionSource AS newdata
INNER JOIN ListAdmissionSource AS olddata ON
newdata.AdmissionSourceUid = olddata.AdmissionSourceUid
GO
INSERT ListAdmissionSource
SELECT newdata.*
FROM migtemp_ListAdmissionSource AS newdata
LEFT JOIN ListAdmissionSource AS olddata ON
newdata.AdmissionSourceUid = olddata.AdmissionSourceUid
WHERE
olddata.AdmissionSourceUid IS NULL
GO
DROP TABLE migtemp_ListAdmissionSource
GO
ALTER TABLE ListAdmissionType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListAdmissionType AS newdata
INNER JOIN ListAdmissionType AS olddata ON
newdata.AdmissionTypeUid = olddata.AdmissionTypeUid
GO
INSERT ListAdmissionType
SELECT newdata.*
FROM migtemp_ListAdmissionType AS newdata
LEFT JOIN ListAdmissionType AS olddata ON
newdata.AdmissionTypeUid = olddata.AdmissionTypeUid
WHERE
olddata.AdmissionTypeUid IS NULL
GO
DROP TABLE migtemp_ListAdmissionType
GO
ALTER TABLE ListAgeGroup NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListAgeGroup AS newdata
INNER JOIN ListAgeGroup AS olddata ON
newdata.AgeGroupUid = olddata.AgeGroupUid
GO
INSERT ListAgeGroup
SELECT newdata.*
FROM migtemp_ListAgeGroup AS newdata
LEFT JOIN ListAgeGroup AS olddata ON
newdata.AgeGroupUid = olddata.AgeGroupUid
WHERE
olddata.AgeGroupUid IS NULL
GO
DROP TABLE migtemp_ListAgeGroup
GO
ALTER TABLE ListAmendmentSource NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListAmendmentSource AS newdata
INNER JOIN ListAmendmentSource AS olddata ON
newdata.AmendmentSourceUid = olddata.AmendmentSourceUid
GO
INSERT ListAmendmentSource
SELECT newdata.*
FROM migtemp_ListAmendmentSource AS newdata
LEFT JOIN ListAmendmentSource AS olddata ON
newdata.AmendmentSourceUid = olddata.AmendmentSourceUid
WHERE
olddata.AmendmentSourceUid IS NULL
GO
DROP TABLE migtemp_ListAmendmentSource
GO
ALTER TABLE ListAnswer NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListAnswer AS newdata
INNER JOIN ListAnswer AS olddata ON
newdata.AnswerUid = olddata.AnswerUid
GO
INSERT ListAnswer
SELECT newdata.*
FROM migtemp_ListAnswer AS newdata
LEFT JOIN ListAnswer AS olddata ON
newdata.AnswerUid = olddata.AnswerUid
WHERE
olddata.AnswerUid IS NULL
GO
DROP TABLE migtemp_ListAnswer
GO
ALTER TABLE ListAnswerGroup NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListAnswerGroup AS newdata
INNER JOIN ListAnswerGroup AS olddata ON
newdata.AnswerGroupUid = olddata.AnswerGroupUid
GO
INSERT ListAnswerGroup
SELECT newdata.*
FROM migtemp_ListAnswerGroup AS newdata
LEFT JOIN ListAnswerGroup AS olddata ON
newdata.AnswerGroupUid = olddata.AnswerGroupUid
WHERE
olddata.AnswerGroupUid IS NULL
GO
DROP TABLE migtemp_ListAnswerGroup
GO
ALTER TABLE ListAppointmentStatus NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListAppointmentStatus AS newdata
INNER JOIN ListAppointmentStatus AS olddata ON
newdata.AppointmentStatusUid = olddata.AppointmentStatusUid
GO
INSERT ListAppointmentStatus
SELECT newdata.*
FROM migtemp_ListAppointmentStatus AS newdata
LEFT JOIN ListAppointmentStatus AS olddata ON
newdata.AppointmentStatusUid = olddata.AppointmentStatusUid
WHERE
olddata.AppointmentStatusUid IS NULL
GO
DROP TABLE migtemp_ListAppointmentStatus
GO
ALTER TABLE ListAppointmentType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListAppointmentType AS newdata
INNER JOIN ListAppointmentType AS olddata ON
newdata.AppointmentTypeUid = olddata.AppointmentTypeUid
GO
INSERT ListAppointmentType
SELECT newdata.*
FROM migtemp_ListAppointmentType AS newdata
LEFT JOIN ListAppointmentType AS olddata ON
newdata.AppointmentTypeUid = olddata.AppointmentTypeUid
WHERE
olddata.AppointmentTypeUid IS NULL
GO
DROP TABLE migtemp_ListAppointmentType
GO
ALTER TABLE ListARRAReports NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListARRAReports AS newdata
INNER JOIN ListARRAReports AS olddata ON
newdata.ARRAReportsUid = olddata.ARRAReportsUid
GO
INSERT ListARRAReports
SELECT newdata.*
FROM migtemp_ListARRAReports AS newdata
LEFT JOIN ListARRAReports AS olddata ON
newdata.ARRAReportsUid = olddata.ARRAReportsUid
WHERE
olddata.ARRAReportsUid IS NULL
GO
DROP TABLE migtemp_ListARRAReports
GO
ALTER TABLE ListAttachmentHandler NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[FileNameWildcard] = newdata.[FileNameWildcard]
, olddata.[CompressionUid] = newdata.[CompressionUid]
, olddata.[ViewerAQN] = (CASE WHEN (olddata.UserDefined = 0) THEN newdata.[ViewerAQN] ELSE olddata.[ViewerAQN] END)
, olddata.[PrinterAQN] = (CASE WHEN (olddata.UserDefined = 0) THEN newdata.[PrinterAQN] ELSE olddata.[PrinterAQN] END)
, olddata.[AutoOpen] = (CASE WHEN (olddata.UserDefined = 0) THEN newdata.[AutoOpen] ELSE olddata.[AutoOpen] END)
, olddata.[ExternalViewerPath] = newdata.[ExternalViewerPath]
, olddata.[Priority] = newdata.[Priority]
FROM migtemp_ListAttachmentHandler AS newdata
INNER JOIN ListAttachmentHandler AS olddata ON
newdata.AttachmentHandlerUid = olddata.AttachmentHandlerUid
GO
INSERT ListAttachmentHandler
SELECT newdata.*
FROM migtemp_ListAttachmentHandler AS newdata
LEFT JOIN ListAttachmentHandler AS olddata ON
newdata.AttachmentHandlerUid = olddata.AttachmentHandlerUid
WHERE
olddata.AttachmentHandlerUid IS NULL
GO
DROP TABLE migtemp_ListAttachmentHandler
GO
ALTER TABLE ListAttachmentType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListAttachmentType AS newdata
INNER JOIN ListAttachmentType AS olddata ON
newdata.AttachmentTypeUid = olddata.AttachmentTypeUid
GO
INSERT ListAttachmentType
SELECT newdata.*
FROM migtemp_ListAttachmentType AS newdata
LEFT JOIN ListAttachmentType AS olddata ON
newdata.AttachmentTypeUid = olddata.AttachmentTypeUid
WHERE
olddata.AttachmentTypeUid IS NULL
GO
DROP TABLE migtemp_ListAttachmentType
GO
ALTER TABLE ListAuditEventConfiguration NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListAuditEventConfiguration AS newdata
INNER JOIN ListAuditEventConfiguration AS olddata ON
newdata.AuditEventConfigurationUid = olddata.AuditEventConfigurationUid
GO
INSERT ListAuditEventConfiguration
SELECT newdata.*
FROM migtemp_ListAuditEventConfiguration AS newdata
LEFT JOIN ListAuditEventConfiguration AS olddata ON
newdata.AuditEventConfigurationUid = olddata.AuditEventConfigurationUid
WHERE
olddata.AuditEventConfigurationUid IS NULL
GO
DROP TABLE migtemp_ListAuditEventConfiguration
GO
ALTER TABLE ListBatchProcessType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[ConfigurationAQN] = newdata.[ConfigurationAQN]
, olddata.[ProcessAQN] = newdata.[ProcessAQN]
, olddata.[SummaryXSLT] = newdata.[SummaryXSLT]
, olddata.[SummaryRouting] = newdata.[SummaryRouting]
, olddata.[DetailXSLT] = newdata.[DetailXSLT]
, olddata.[DetailRouting] = newdata.[DetailRouting]
, olddata.[MaxConcurrency] = newdata.[MaxConcurrency]
, olddata.[LastModifiedByUid] = newdata.[LastModifiedByUid]
FROM migtemp_ListBatchProcessType AS newdata
INNER JOIN ListBatchProcessType AS olddata ON
newdata.BatchProcessTypeUid = olddata.BatchProcessTypeUid
GO
INSERT ListBatchProcessType
SELECT newdata.*
FROM migtemp_ListBatchProcessType AS newdata
LEFT JOIN ListBatchProcessType AS olddata ON
newdata.BatchProcessTypeUid = olddata.BatchProcessTypeUid
WHERE
olddata.BatchProcessTypeUid IS NULL
GO
DROP TABLE migtemp_ListBatchProcessType
GO
ALTER TABLE ListBillTimeRule NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListBillTimeRule AS newdata
INNER JOIN ListBillTimeRule AS olddata ON
newdata.BillTimeRuleUid = olddata.BillTimeRuleUid
GO
INSERT ListBillTimeRule
SELECT newdata.*
FROM migtemp_ListBillTimeRule AS newdata
LEFT JOIN ListBillTimeRule AS olddata ON
newdata.BillTimeRuleUid = olddata.BillTimeRuleUid
WHERE
olddata.BillTimeRuleUid IS NULL
GO
DROP TABLE migtemp_ListBillTimeRule
GO
ALTER TABLE ListBloodPressureMethods NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListBloodPressureMethods AS newdata
INNER JOIN ListBloodPressureMethods AS olddata ON
newdata.BloodPressureMethodsUid = olddata.BloodPressureMethodsUid
GO
INSERT ListBloodPressureMethods
SELECT newdata.*
FROM migtemp_ListBloodPressureMethods AS newdata
LEFT JOIN ListBloodPressureMethods AS olddata ON
newdata.BloodPressureMethodsUid = olddata.BloodPressureMethodsUid
WHERE
olddata.BloodPressureMethodsUid IS NULL
GO
DROP TABLE migtemp_ListBloodPressureMethods
GO
ALTER TABLE ListCaseModule NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListCaseModule AS newdata
INNER JOIN ListCaseModule AS olddata ON
newdata.CaseModuleUid = olddata.CaseModuleUid
GO
INSERT ListCaseModule
SELECT newdata.*
FROM migtemp_ListCaseModule AS newdata
LEFT JOIN ListCaseModule AS olddata ON
newdata.CaseModuleUid = olddata.CaseModuleUid
WHERE
olddata.CaseModuleUid IS NULL
GO
DROP TABLE migtemp_ListCaseModule
GO
ALTER TABLE ListCaseType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListCaseType AS newdata
INNER JOIN ListCaseType AS olddata ON
newdata.CaseTypeUid = olddata.CaseTypeUid
GO
INSERT ListCaseType
SELECT newdata.*
FROM migtemp_ListCaseType AS newdata
LEFT JOIN ListCaseType AS olddata ON
newdata.CaseTypeUid = olddata.CaseTypeUid
WHERE
olddata.CaseTypeUid IS NULL
GO
DROP TABLE migtemp_ListCaseType
GO
ALTER TABLE ListCaseTypeModule NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListCaseTypeModule AS newdata
INNER JOIN ListCaseTypeModule AS olddata ON
newdata.CaseTypeModuleUid = olddata.CaseTypeModuleUid
GO
INSERT ListCaseTypeModule
SELECT newdata.*
FROM migtemp_ListCaseTypeModule AS newdata
LEFT JOIN ListCaseTypeModule AS olddata ON
newdata.CaseTypeModuleUid = olddata.CaseTypeModuleUid
WHERE
olddata.CaseTypeModuleUid IS NULL
GO
DROP TABLE migtemp_ListCaseTypeModule
GO
ALTER TABLE ListCaseTypePhase NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListCaseTypePhase AS newdata
INNER JOIN ListCaseTypePhase AS olddata ON
newdata.CaseTypePhaseUid = olddata.CaseTypePhaseUid
GO
INSERT ListCaseTypePhase
SELECT newdata.*
FROM migtemp_ListCaseTypePhase AS newdata
LEFT JOIN ListCaseTypePhase AS olddata ON
newdata.CaseTypePhaseUid = olddata.CaseTypePhaseUid
WHERE
olddata.CaseTypePhaseUid IS NULL
GO
DROP TABLE migtemp_ListCaseTypePhase
GO
ALTER TABLE ListCategoryCode NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListCategoryCode AS newdata
INNER JOIN ListCategoryCode AS olddata ON
newdata.CategoryCodeUid = olddata.CategoryCodeUid
GO
INSERT ListCategoryCode
SELECT newdata.*
FROM migtemp_ListCategoryCode AS newdata
LEFT JOIN ListCategoryCode AS olddata ON
newdata.CategoryCodeUid = olddata.CategoryCodeUid
WHERE
olddata.CategoryCodeUid IS NULL
GO
DROP TABLE migtemp_ListCategoryCode
GO
ALTER TABLE ListCDASection NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListCDASection AS newdata
INNER JOIN ListCDASection AS olddata ON
newdata.CDASectionUid = olddata.CDASectionUid
GO
INSERT ListCDASection
SELECT newdata.*
FROM migtemp_ListCDASection AS newdata
LEFT JOIN ListCDASection AS olddata ON
newdata.CDASectionUid = olddata.CDASectionUid
WHERE
olddata.CDASectionUid IS NULL
GO
DROP TABLE migtemp_ListCDASection
GO
ALTER TABLE ListChargeTicketDiagnosis NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[LicenseCode] = newdata.[LicenseCode]
FROM migtemp_ListChargeTicketDiagnosis AS newdata
INNER JOIN ListChargeTicketDiagnosis AS olddata ON
newdata.ChargeTicketDiagnosisUid = olddata.ChargeTicketDiagnosisUid
GO
INSERT ListChargeTicketDiagnosis
SELECT newdata.*
FROM migtemp_ListChargeTicketDiagnosis AS newdata
LEFT JOIN ListChargeTicketDiagnosis AS olddata ON
newdata.ChargeTicketDiagnosisUid = olddata.ChargeTicketDiagnosisUid
WHERE
olddata.ChargeTicketDiagnosisUid IS NULL
GO
DROP TABLE migtemp_ListChargeTicketDiagnosis
GO
ALTER TABLE ListChargeTicketSP NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[LicenseCode] = newdata.[LicenseCode]
FROM migtemp_ListChargeTicketSP AS newdata
INNER JOIN ListChargeTicketSP AS olddata ON
newdata.ChargeTicketSPUid = olddata.ChargeTicketSPUid
GO
INSERT ListChargeTicketSP
SELECT newdata.*
FROM migtemp_ListChargeTicketSP AS newdata
LEFT JOIN ListChargeTicketSP AS olddata ON
newdata.ChargeTicketSPUid = olddata.ChargeTicketSPUid
WHERE
olddata.ChargeTicketSPUid IS NULL
GO
DROP TABLE migtemp_ListChargeTicketSP
GO
ALTER TABLE ListClaimBatchStatus NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListClaimBatchStatus AS newdata
INNER JOIN ListClaimBatchStatus AS olddata ON
newdata.BatchStatusUid = olddata.BatchStatusUid
GO
INSERT ListClaimBatchStatus
SELECT newdata.*
FROM migtemp_ListClaimBatchStatus AS newdata
LEFT JOIN ListClaimBatchStatus AS olddata ON
newdata.BatchStatusUid = olddata.BatchStatusUid
WHERE
olddata.BatchStatusUid IS NULL
GO
DROP TABLE migtemp_ListClaimBatchStatus
GO
ALTER TABLE ListClaimClearingHouse NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListClaimClearingHouse AS newdata
INNER JOIN ListClaimClearingHouse AS olddata ON
newdata.ClaimClearingHouseUid = olddata.ClaimClearingHouseUid
GO
INSERT ListClaimClearingHouse
SELECT newdata.*
FROM migtemp_ListClaimClearingHouse AS newdata
LEFT JOIN ListClaimClearingHouse AS olddata ON
newdata.ClaimClearingHouseUid = olddata.ClaimClearingHouseUid
WHERE
olddata.ClaimClearingHouseUid IS NULL
GO
DROP TABLE migtemp_ListClaimClearingHouse
GO
ALTER TABLE ListClaimFormat NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListClaimFormat AS newdata
INNER JOIN ListClaimFormat AS olddata ON
newdata.ClaimFormatUid = olddata.ClaimFormatUid
GO
INSERT ListClaimFormat
SELECT newdata.*
FROM migtemp_ListClaimFormat AS newdata
LEFT JOIN ListClaimFormat AS olddata ON
newdata.ClaimFormatUid = olddata.ClaimFormatUid
WHERE
olddata.ClaimFormatUid IS NULL
GO
DROP TABLE migtemp_ListClaimFormat
GO
ALTER TABLE ListClaimFormatOptionType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[ClaimFormatTypeUid] = newdata.[ClaimFormatTypeUid]
, olddata.[ClaimFormatValueTypeTypeUid] = newdata.[ClaimFormatValueTypeTypeUid]
FROM migtemp_ListClaimFormatOptionType AS newdata
INNER JOIN ListClaimFormatOptionType AS olddata ON
newdata.ClaimFormatOptionTypeUid = olddata.ClaimFormatOptionTypeUid
GO
INSERT ListClaimFormatOptionType
SELECT newdata.*
FROM migtemp_ListClaimFormatOptionType AS newdata
LEFT JOIN ListClaimFormatOptionType AS olddata ON
newdata.ClaimFormatOptionTypeUid = olddata.ClaimFormatOptionTypeUid
WHERE
olddata.ClaimFormatOptionTypeUid IS NULL
GO
DROP TABLE migtemp_ListClaimFormatOptionType
GO
ALTER TABLE ListClaimFormatType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListClaimFormatType AS newdata
INNER JOIN ListClaimFormatType AS olddata ON
newdata.ClaimFormatTypeUid = olddata.ClaimFormatTypeUid
GO
INSERT ListClaimFormatType
SELECT newdata.*
FROM migtemp_ListClaimFormatType AS newdata
LEFT JOIN ListClaimFormatType AS olddata ON
newdata.ClaimFormatTypeUid = olddata.ClaimFormatTypeUid
WHERE
olddata.ClaimFormatTypeUid IS NULL
GO
DROP TABLE migtemp_ListClaimFormatType
GO
ALTER TABLE ListClaimFormatValueType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[ClaimFormatValueTypeTypeUid] = newdata.[ClaimFormatValueTypeTypeUid]
FROM migtemp_ListClaimFormatValueType AS newdata
INNER JOIN ListClaimFormatValueType AS olddata ON
newdata.ClaimFormatValueTypeUid = olddata.ClaimFormatValueTypeUid
GO
INSERT ListClaimFormatValueType
SELECT newdata.*
FROM migtemp_ListClaimFormatValueType AS newdata
LEFT JOIN ListClaimFormatValueType AS olddata ON
newdata.ClaimFormatValueTypeUid = olddata.ClaimFormatValueTypeUid
WHERE
olddata.ClaimFormatValueTypeUid IS NULL
GO
DROP TABLE migtemp_ListClaimFormatValueType
GO
ALTER TABLE ListClaimFormatValueTypeType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[allowuserdataentry] = newdata.[allowuserdataentry]
FROM migtemp_ListClaimFormatValueTypeType AS newdata
INNER JOIN ListClaimFormatValueTypeType AS olddata ON
newdata.ClaimFormatValueTypeTypeUid = olddata.ClaimFormatValueTypeTypeUid
GO
INSERT ListClaimFormatValueTypeType
SELECT newdata.*
FROM migtemp_ListClaimFormatValueTypeType AS newdata
LEFT JOIN ListClaimFormatValueTypeType AS olddata ON
newdata.ClaimFormatValueTypeTypeUid = olddata.ClaimFormatValueTypeTypeUid
WHERE
olddata.ClaimFormatValueTypeTypeUid IS NULL
GO
DROP TABLE migtemp_ListClaimFormatValueTypeType
GO
ALTER TABLE ListClaimFormLayout NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListClaimFormLayout AS newdata
INNER JOIN ListClaimFormLayout AS olddata ON
newdata.ClaimFormLayoutUid = olddata.ClaimFormLayoutUid
GO
INSERT ListClaimFormLayout
SELECT newdata.*
FROM migtemp_ListClaimFormLayout AS newdata
LEFT JOIN ListClaimFormLayout AS olddata ON
newdata.ClaimFormLayoutUid = olddata.ClaimFormLayoutUid
WHERE
olddata.ClaimFormLayoutUid IS NULL
GO
DROP TABLE migtemp_ListClaimFormLayout
GO
ALTER TABLE ListClaimHeaderNoteCode NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListClaimHeaderNoteCode AS newdata
INNER JOIN ListClaimHeaderNoteCode AS olddata ON
newdata.ClaimHeaderNoteCodeUid = olddata.ClaimHeaderNoteCodeUid
GO
INSERT ListClaimHeaderNoteCode
SELECT newdata.*
FROM migtemp_ListClaimHeaderNoteCode AS newdata
LEFT JOIN ListClaimHeaderNoteCode AS olddata ON
newdata.ClaimHeaderNoteCodeUid = olddata.ClaimHeaderNoteCodeUid
WHERE
olddata.ClaimHeaderNoteCodeUid IS NULL
GO
DROP TABLE migtemp_ListClaimHeaderNoteCode
GO
ALTER TABLE ListClaimReportStatus NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListClaimReportStatus AS newdata
INNER JOIN ListClaimReportStatus AS olddata ON
newdata.ClaimReportStatusUid = olddata.ClaimReportStatusUid
GO
INSERT ListClaimReportStatus
SELECT newdata.*
FROM migtemp_ListClaimReportStatus AS newdata
LEFT JOIN ListClaimReportStatus AS olddata ON
newdata.ClaimReportStatusUid = olddata.ClaimReportStatusUid
WHERE
olddata.ClaimReportStatusUid IS NULL
GO
DROP TABLE migtemp_ListClaimReportStatus
GO
ALTER TABLE ListClaimStatusPayer NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListClaimStatusPayer AS newdata
INNER JOIN ListClaimStatusPayer AS olddata ON
newdata.ClaimStatusPayerUid = olddata.ClaimStatusPayerUid
GO
INSERT ListClaimStatusPayer
SELECT newdata.*
FROM migtemp_ListClaimStatusPayer AS newdata
LEFT JOIN ListClaimStatusPayer AS olddata ON
newdata.ClaimStatusPayerUid = olddata.ClaimStatusPayerUid
WHERE
olddata.ClaimStatusPayerUid IS NULL
GO
DROP TABLE migtemp_ListClaimStatusPayer
GO
ALTER TABLE ListClinicalNoteType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[HasAttachments] = newdata.[HasAttachments]
, olddata.[HasDictation] = newdata.[HasDictation]
FROM migtemp_ListClinicalNoteType AS newdata
INNER JOIN ListClinicalNoteType AS olddata ON
newdata.ClinicalNoteTypeUid = olddata.ClinicalNoteTypeUid
GO
INSERT ListClinicalNoteType
SELECT newdata.*
FROM migtemp_ListClinicalNoteType AS newdata
LEFT JOIN ListClinicalNoteType AS olddata ON
newdata.ClinicalNoteTypeUid = olddata.ClinicalNoteTypeUid
WHERE
olddata.ClinicalNoteTypeUid IS NULL
GO
DROP TABLE migtemp_ListClinicalNoteType
GO
ALTER TABLE ListClinicCenter NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListClinicCenter AS newdata
INNER JOIN ListClinicCenter AS olddata ON
newdata.ClinicCenterUid = olddata.ClinicCenterUid
GO
INSERT ListClinicCenter
SELECT newdata.*
FROM migtemp_ListClinicCenter AS newdata
LEFT JOIN ListClinicCenter AS olddata ON
newdata.ClinicCenterUid = olddata.ClinicCenterUid
WHERE
olddata.ClinicCenterUid IS NULL
GO
DROP TABLE migtemp_ListClinicCenter
GO
ALTER TABLE ListCodeValidationCarrierMap NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListCodeValidationCarrierMap AS newdata
INNER JOIN ListCodeValidationCarrierMap AS olddata ON
newdata.CodeValidationCarrierMapUid = olddata.CodeValidationCarrierMapUid
GO
INSERT ListCodeValidationCarrierMap
SELECT newdata.*
FROM migtemp_ListCodeValidationCarrierMap AS newdata
LEFT JOIN ListCodeValidationCarrierMap AS olddata ON
newdata.CodeValidationCarrierMapUid = olddata.CodeValidationCarrierMapUid
WHERE
olddata.CodeValidationCarrierMapUid IS NULL
GO
DROP TABLE migtemp_ListCodeValidationCarrierMap
GO
ALTER TABLE ListCollectionStatus NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListCollectionStatus AS newdata
INNER JOIN ListCollectionStatus AS olddata ON
newdata.CollectionStatusUid = olddata.CollectionStatusUid
GO
INSERT ListCollectionStatus
SELECT newdata.*
FROM migtemp_ListCollectionStatus AS newdata
LEFT JOIN ListCollectionStatus AS olddata ON
newdata.CollectionStatusUid = olddata.CollectionStatusUid
WHERE
olddata.CollectionStatusUid IS NULL
GO
DROP TABLE migtemp_ListCollectionStatus
GO
ALTER TABLE ListCompression NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[AQN] = newdata.[AQN]
FROM migtemp_ListCompression AS newdata
INNER JOIN ListCompression AS olddata ON
newdata.CompressionUid = olddata.CompressionUid
GO
INSERT ListCompression
SELECT newdata.*
FROM migtemp_ListCompression AS newdata
LEFT JOIN ListCompression AS olddata ON
newdata.CompressionUid = olddata.CompressionUid
WHERE
olddata.CompressionUid IS NULL
GO
DROP TABLE migtemp_ListCompression
GO
ALTER TABLE ListConditionalOperator NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListConditionalOperator AS newdata
INNER JOIN ListConditionalOperator AS olddata ON
newdata.ConditionalOperatorUid = olddata.ConditionalOperatorUid
GO
INSERT ListConditionalOperator
SELECT newdata.*
FROM migtemp_ListConditionalOperator AS newdata
LEFT JOIN ListConditionalOperator AS olddata ON
newdata.ConditionalOperatorUid = olddata.ConditionalOperatorUid
WHERE
olddata.ConditionalOperatorUid IS NULL
GO
DROP TABLE migtemp_ListConditionalOperator
GO
ALTER TABLE ListConditionCode NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListConditionCode AS newdata
INNER JOIN ListConditionCode AS olddata ON
newdata.ConditionCodeUid = olddata.ConditionCodeUid
GO
INSERT ListConditionCode
SELECT newdata.*
FROM migtemp_ListConditionCode AS newdata
LEFT JOIN ListConditionCode AS olddata ON
newdata.ConditionCodeUid = olddata.ConditionCodeUid
WHERE
olddata.ConditionCodeUid IS NULL
GO
DROP TABLE migtemp_ListConditionCode
GO
ALTER TABLE ListContextReportType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListContextReportType AS newdata
INNER JOIN ListContextReportType AS olddata ON
newdata.ContextReportTypeUid = olddata.ContextReportTypeUid
GO
INSERT ListContextReportType
SELECT newdata.*
FROM migtemp_ListContextReportType AS newdata
LEFT JOIN ListContextReportType AS olddata ON
newdata.ContextReportTypeUid = olddata.ContextReportTypeUid
WHERE
olddata.ContextReportTypeUid IS NULL
GO
DROP TABLE migtemp_ListContextReportType
GO
ALTER TABLE ListContractTypeCode NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListContractTypeCode AS newdata
INNER JOIN ListContractTypeCode AS olddata ON
newdata.ContractTypeCodeUid = olddata.ContractTypeCodeUid
GO
INSERT ListContractTypeCode
SELECT newdata.*
FROM migtemp_ListContractTypeCode AS newdata
LEFT JOIN ListContractTypeCode AS olddata ON
newdata.ContractTypeCodeUid = olddata.ContractTypeCodeUid
WHERE
olddata.ContractTypeCodeUid IS NULL
GO
DROP TABLE migtemp_ListContractTypeCode
GO
ALTER TABLE ListControlType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListControlType AS newdata
INNER JOIN ListControlType AS olddata ON
newdata.ControlTypeUid = olddata.ControlTypeUid
GO
INSERT ListControlType
SELECT newdata.*
FROM migtemp_ListControlType AS newdata
LEFT JOIN ListControlType AS olddata ON
newdata.ControlTypeUid = olddata.ControlTypeUid
WHERE
olddata.ControlTypeUid IS NULL
GO
DROP TABLE migtemp_ListControlType
GO
ALTER TABLE ListCoverageType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListCoverageType AS newdata
INNER JOIN ListCoverageType AS olddata ON
newdata.CoverageTypeUid = olddata.CoverageTypeUid
GO
INSERT ListCoverageType
SELECT newdata.*
FROM migtemp_ListCoverageType AS newdata
LEFT JOIN ListCoverageType AS olddata ON
newdata.CoverageTypeUid = olddata.CoverageTypeUid
WHERE
olddata.CoverageTypeUid IS NULL
GO
DROP TABLE migtemp_ListCoverageType
GO
ALTER TABLE ListCpp NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListCpp AS newdata
INNER JOIN ListCpp AS olddata ON
newdata.CppUid = olddata.CppUid
GO
INSERT ListCpp
SELECT newdata.*
FROM migtemp_ListCpp AS newdata
LEFT JOIN ListCpp AS olddata ON
newdata.CppUid = olddata.CppUid
WHERE
olddata.CppUid IS NULL
GO
DROP TABLE migtemp_ListCpp
GO
ALTER TABLE ListCppGroup NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListCppGroup AS newdata
INNER JOIN ListCppGroup AS olddata ON
newdata.CppGroupUid = olddata.CppGroupUid
GO
INSERT ListCppGroup
SELECT newdata.*
FROM migtemp_ListCppGroup AS newdata
LEFT JOIN ListCppGroup AS olddata ON
newdata.CppGroupUid = olddata.CppGroupUid
WHERE
olddata.CppGroupUid IS NULL
GO
DROP TABLE migtemp_ListCppGroup
GO
ALTER TABLE ListCQM NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListCQM AS newdata
INNER JOIN ListCQM AS olddata ON
newdata.CQMUid = olddata.CQMUid
GO
INSERT ListCQM
SELECT newdata.*
FROM migtemp_ListCQM AS newdata
LEFT JOIN ListCQM AS olddata ON
newdata.CQMUid = olddata.CQMUid
WHERE
olddata.CQMUid IS NULL
GO
DROP TABLE migtemp_ListCQM
GO
ALTER TABLE ListCreditCard NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListCreditCard AS newdata
INNER JOIN ListCreditCard AS olddata ON
newdata.CreditCardUid = olddata.CreditCardUid
GO
INSERT ListCreditCard
SELECT newdata.*
FROM migtemp_ListCreditCard AS newdata
LEFT JOIN ListCreditCard AS olddata ON
newdata.CreditCardUid = olddata.CreditCardUid
WHERE
olddata.CreditCardUid IS NULL
GO
DROP TABLE migtemp_ListCreditCard
GO
ALTER TABLE ListCreditType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[IsPayment] = newdata.[IsPayment]
, olddata.[IsAdjustment] = newdata.[IsAdjustment]
, olddata.[IsCollectableAdjustment] = newdata.[IsCollectableAdjustment]
, olddata.[TransactionTypeUid] = newdata.[TransactionTypeUid]
FROM migtemp_ListCreditType AS newdata
INNER JOIN ListCreditType AS olddata ON
newdata.CreditTypeUid = olddata.CreditTypeUid
GO
INSERT ListCreditType
SELECT newdata.*
FROM migtemp_ListCreditType AS newdata
LEFT JOIN ListCreditType AS olddata ON
newdata.CreditTypeUid = olddata.CreditTypeUid
WHERE
olddata.CreditTypeUid IS NULL
GO
DROP TABLE migtemp_ListCreditType
GO
ALTER TABLE ListCustomNotePrint NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListCustomNotePrint AS newdata
INNER JOIN ListCustomNotePrint AS olddata ON
newdata.CustomNotePrintUid = olddata.CustomNotePrintUid
GO
INSERT ListCustomNotePrint
SELECT newdata.*
FROM migtemp_ListCustomNotePrint AS newdata
LEFT JOIN ListCustomNotePrint AS olddata ON
newdata.CustomNotePrintUid = olddata.CustomNotePrintUid
WHERE
olddata.CustomNotePrintUid IS NULL
GO
DROP TABLE migtemp_ListCustomNotePrint
GO
ALTER TABLE ListCVXCode NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListCVXCode AS newdata
INNER JOIN ListCVXCode AS olddata ON
newdata.CVXCodeUid = olddata.CVXCodeUid
GO
INSERT ListCVXCode
SELECT newdata.*
FROM migtemp_ListCVXCode AS newdata
LEFT JOIN ListCVXCode AS olddata ON
newdata.CVXCodeUid = olddata.CVXCodeUid
WHERE
olddata.CVXCodeUid IS NULL
GO
DROP TABLE migtemp_ListCVXCode
GO
ALTER TABLE ListDataFormatter NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[EditorAssemblyQualifiedName] = newdata.[EditorAssemblyQualifiedName]
, olddata.[ContentSourceAssemblyQualifiedName] = newdata.[ContentSourceAssemblyQualifiedName]
, olddata.[ParameterEditorAssemblyQualifiedName] = newdata.[ParameterEditorAssemblyQualifiedName]
, olddata.[FieldDefinition] = newdata.[FieldDefinition]
, olddata.[RootObjectType] = newdata.[RootObjectType]
, olddata.[Notes] = newdata.[Notes]
, olddata.[QueryFilterAssemblyQualifiedName] = newdata.[QueryFilterAssemblyQualifiedName]
FROM migtemp_ListDataFormatter AS newdata
INNER JOIN ListDataFormatter AS olddata ON
newdata.DataFormatterUid = olddata.DataFormatterUid
GO
INSERT ListDataFormatter
SELECT newdata.*
FROM migtemp_ListDataFormatter AS newdata
LEFT JOIN ListDataFormatter AS olddata ON
newdata.DataFormatterUid = olddata.DataFormatterUid
WHERE
olddata.DataFormatterUid IS NULL
GO
DROP TABLE migtemp_ListDataFormatter
GO
ALTER TABLE ListDecileCQM NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListDecileCQM AS newdata
INNER JOIN ListDecileCQM AS olddata ON
newdata.DecileCQMUID = olddata.DecileCQMUID
GO
INSERT ListDecileCQM
SELECT newdata.*
FROM migtemp_ListDecileCQM AS newdata
LEFT JOIN ListDecileCQM AS olddata ON
newdata.DecileCQMUID = olddata.DecileCQMUID
WHERE
olddata.DecileCQMUID IS NULL
GO
DROP TABLE migtemp_ListDecileCQM
GO
ALTER TABLE ListDegreeRelated NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListDegreeRelated AS newdata
INNER JOIN ListDegreeRelated AS olddata ON
newdata.DegreeRelatedUid = olddata.DegreeRelatedUid
GO
INSERT ListDegreeRelated
SELECT newdata.*
FROM migtemp_ListDegreeRelated AS newdata
LEFT JOIN ListDegreeRelated AS olddata ON
newdata.DegreeRelatedUid = olddata.DegreeRelatedUid
WHERE
olddata.DegreeRelatedUid IS NULL
GO
DROP TABLE migtemp_ListDegreeRelated
GO
ALTER TABLE ListDelayReason NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListDelayReason AS newdata
INNER JOIN ListDelayReason AS olddata ON
newdata.DelayReasonUid = olddata.DelayReasonUid
GO
INSERT ListDelayReason
SELECT newdata.*
FROM migtemp_ListDelayReason AS newdata
LEFT JOIN ListDelayReason AS olddata ON
newdata.DelayReasonUid = olddata.DelayReasonUid
WHERE
olddata.DelayReasonUid IS NULL
GO
DROP TABLE migtemp_ListDelayReason
GO
ALTER TABLE ListDepositMacro NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListDepositMacro AS newdata
INNER JOIN ListDepositMacro AS olddata ON
newdata.DepositMacroUid = olddata.DepositMacroUid
GO
INSERT ListDepositMacro
SELECT newdata.*
FROM migtemp_ListDepositMacro AS newdata
LEFT JOIN ListDepositMacro AS olddata ON
newdata.DepositMacroUid = olddata.DepositMacroUid
WHERE
olddata.DepositMacroUid IS NULL
GO
DROP TABLE migtemp_ListDepositMacro
GO
ALTER TABLE ListDesktopControl NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListDesktopControl AS newdata
INNER JOIN ListDesktopControl AS olddata ON
newdata.DesktopControlUid = olddata.DesktopControlUid
GO
INSERT ListDesktopControl
SELECT newdata.*
FROM migtemp_ListDesktopControl AS newdata
LEFT JOIN ListDesktopControl AS olddata ON
newdata.DesktopControlUid = olddata.DesktopControlUid
WHERE
olddata.DesktopControlUid IS NULL
GO
DROP TABLE migtemp_ListDesktopControl
GO
ALTER TABLE ListDiagnosisCategory NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListDiagnosisCategory AS newdata
INNER JOIN ListDiagnosisCategory AS olddata ON
newdata.DiagnosisCategoryUid = olddata.DiagnosisCategoryUid
GO
INSERT ListDiagnosisCategory
SELECT newdata.*
FROM migtemp_ListDiagnosisCategory AS newdata
LEFT JOIN ListDiagnosisCategory AS olddata ON
newdata.DiagnosisCategoryUid = olddata.DiagnosisCategoryUid
WHERE
olddata.DiagnosisCategoryUid IS NULL
GO
DROP TABLE migtemp_ListDiagnosisCategory
GO
ALTER TABLE ListDiagnosisSearchDefinition NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListDiagnosisSearchDefinition AS newdata
INNER JOIN ListDiagnosisSearchDefinition AS olddata ON
newdata.DiagnosisSearchDefinitionUid = olddata.DiagnosisSearchDefinitionUid
GO
INSERT ListDiagnosisSearchDefinition
SELECT newdata.*
FROM migtemp_ListDiagnosisSearchDefinition AS newdata
LEFT JOIN ListDiagnosisSearchDefinition AS olddata ON
newdata.DiagnosisSearchDefinitionUid = olddata.DiagnosisSearchDefinitionUid
WHERE
olddata.DiagnosisSearchDefinitionUid IS NULL
GO
DROP TABLE migtemp_ListDiagnosisSearchDefinition
GO
ALTER TABLE ListDiet NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListDiet AS newdata
INNER JOIN ListDiet AS olddata ON
newdata.DietUid = olddata.DietUid
GO
INSERT ListDiet
SELECT newdata.*
FROM migtemp_ListDiet AS newdata
LEFT JOIN ListDiet AS olddata ON
newdata.DietUid = olddata.DietUid
WHERE
olddata.DietUid IS NULL
GO
DROP TABLE migtemp_ListDiet
GO
ALTER TABLE ListDisclosureReason NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListDisclosureReason AS newdata
INNER JOIN ListDisclosureReason AS olddata ON
newdata.DisclosureReasonUid = olddata.DisclosureReasonUid
GO
INSERT ListDisclosureReason
SELECT newdata.*
FROM migtemp_ListDisclosureReason AS newdata
LEFT JOIN ListDisclosureReason AS olddata ON
newdata.DisclosureReasonUid = olddata.DisclosureReasonUid
WHERE
olddata.DisclosureReasonUid IS NULL
GO
DROP TABLE migtemp_ListDisclosureReason
GO
ALTER TABLE ListDiscontinueReason NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListDiscontinueReason AS newdata
INNER JOIN ListDiscontinueReason AS olddata ON
newdata.DiscontinueReasonUid = olddata.DiscontinueReasonUid
GO
INSERT ListDiscontinueReason
SELECT newdata.*
FROM migtemp_ListDiscontinueReason AS newdata
LEFT JOIN ListDiscontinueReason AS olddata ON
newdata.DiscontinueReasonUid = olddata.DiscontinueReasonUid
WHERE
olddata.DiscontinueReasonUid IS NULL
GO
DROP TABLE migtemp_ListDiscontinueReason
GO
ALTER TABLE ListDisease NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListDisease AS newdata
INNER JOIN ListDisease AS olddata ON
newdata.DiseaseUid = olddata.DiseaseUid
GO
INSERT ListDisease
SELECT newdata.*
FROM migtemp_ListDisease AS newdata
LEFT JOIN ListDisease AS olddata ON
newdata.DiseaseUid = olddata.DiseaseUid
WHERE
olddata.DiseaseUid IS NULL
GO
DROP TABLE migtemp_ListDisease
GO
ALTER TABLE ListDiseaseGroup NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListDiseaseGroup AS newdata
INNER JOIN ListDiseaseGroup AS olddata ON
newdata.DiseaseGroupUid = olddata.DiseaseGroupUid
GO
INSERT ListDiseaseGroup
SELECT newdata.*
FROM migtemp_ListDiseaseGroup AS newdata
LEFT JOIN ListDiseaseGroup AS olddata ON
newdata.DiseaseGroupUid = olddata.DiseaseGroupUid
WHERE
olddata.DiseaseGroupUid IS NULL
GO
DROP TABLE migtemp_ListDiseaseGroup
GO
ALTER TABLE ListDocumentLinkingFolderType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListDocumentLinkingFolderType AS newdata
INNER JOIN ListDocumentLinkingFolderType AS olddata ON
newdata.DocumentLinkingFolderTypeUid = olddata.DocumentLinkingFolderTypeUid
GO
INSERT ListDocumentLinkingFolderType
SELECT newdata.*
FROM migtemp_ListDocumentLinkingFolderType AS newdata
LEFT JOIN ListDocumentLinkingFolderType AS olddata ON
newdata.DocumentLinkingFolderTypeUid = olddata.DocumentLinkingFolderTypeUid
WHERE
olddata.DocumentLinkingFolderTypeUid IS NULL
GO
DROP TABLE migtemp_ListDocumentLinkingFolderType
GO
ALTER TABLE ListDominantHand NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListDominantHand AS newdata
INNER JOIN ListDominantHand AS olddata ON
newdata.DominantHandUid = olddata.DominantHandUid
GO
INSERT ListDominantHand
SELECT newdata.*
FROM migtemp_ListDominantHand AS newdata
LEFT JOIN ListDominantHand AS olddata ON
newdata.DominantHandUid = olddata.DominantHandUid
WHERE
olddata.DominantHandUid IS NULL
GO
DROP TABLE migtemp_ListDominantHand
GO
ALTER TABLE ListDpnGroup NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListDpnGroup AS newdata
INNER JOIN ListDpnGroup AS olddata ON
newdata.DpnGroupUid = olddata.DpnGroupUid
GO
INSERT ListDpnGroup
SELECT newdata.*
FROM migtemp_ListDpnGroup AS newdata
LEFT JOIN ListDpnGroup AS olddata ON
newdata.DpnGroupUid = olddata.DpnGroupUid
WHERE
olddata.DpnGroupUid IS NULL
GO
DROP TABLE migtemp_ListDpnGroup
GO
ALTER TABLE ListDpnNode NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[FindTableUid] = newdata.[FindTableUid]
FROM migtemp_ListDpnNode AS newdata
INNER JOIN ListDpnNode AS olddata ON
newdata.DpnNodeUid = olddata.DpnNodeUid
GO
INSERT ListDpnNode
SELECT newdata.*
FROM migtemp_ListDpnNode AS newdata
LEFT JOIN ListDpnNode AS olddata ON
newdata.DpnNodeUid = olddata.DpnNodeUid
WHERE
olddata.DpnNodeUid IS NULL
GO
DROP TABLE migtemp_ListDpnNode
GO
ALTER TABLE ListDxTileConfiguration NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListDxTileConfiguration AS newdata
INNER JOIN ListDxTileConfiguration AS olddata ON
newdata.DxTileConfigurationUid = olddata.DxTileConfigurationUid
GO
INSERT ListDxTileConfiguration
SELECT newdata.*
FROM migtemp_ListDxTileConfiguration AS newdata
LEFT JOIN ListDxTileConfiguration AS olddata ON
newdata.DxTileConfigurationUid = olddata.DxTileConfigurationUid
WHERE
olddata.DxTileConfigurationUid IS NULL
GO
DROP TABLE migtemp_ListDxTileConfiguration
GO
ALTER TABLE ListEditorControlLaunchContext NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListEditorControlLaunchContext AS newdata
INNER JOIN ListEditorControlLaunchContext AS olddata ON
newdata.ListEditorControlLaunchContextUid = olddata.ListEditorControlLaunchContextUid
GO
INSERT ListEditorControlLaunchContext
SELECT newdata.*
FROM migtemp_ListEditorControlLaunchContext AS newdata
LEFT JOIN ListEditorControlLaunchContext AS olddata ON
newdata.ListEditorControlLaunchContextUid = olddata.ListEditorControlLaunchContextUid
WHERE
olddata.ListEditorControlLaunchContextUid IS NULL
GO
DROP TABLE migtemp_ListEditorControlLaunchContext
GO
ALTER TABLE ListEduForm NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[LicenseCode] = newdata.[LicenseCode]
, olddata.[ExternalID] = (CASE WHEN (olddata.UserDefined = 0) THEN newdata.[ExternalID] ELSE olddata.[ExternalID] END)
, olddata.[Notes] = (CASE WHEN (olddata.UserDefined = 0) THEN newdata.[Notes] ELSE olddata.[Notes] END)
, olddata.[VendorID] = newdata.[VendorID]
, olddata.[AttachmentUid] = newdata.[AttachmentUid]
, olddata.[LanguageUid] = newdata.[LanguageUid]
, olddata.[DocumentMetadata] = newdata.[DocumentMetadata]
FROM migtemp_ListEduForm AS newdata
INNER JOIN ListEduForm AS olddata ON
newdata.EduFormUid = olddata.EduFormUid
GO
INSERT ListEduForm
SELECT newdata.*
FROM migtemp_ListEduForm AS newdata
LEFT JOIN ListEduForm AS olddata ON
newdata.EduFormUid = olddata.EduFormUid
WHERE
olddata.EduFormUid IS NULL
GO
DROP TABLE migtemp_ListEduForm
GO
ALTER TABLE ListEduFormAssociation NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListEduFormAssociation AS newdata
INNER JOIN ListEduFormAssociation AS olddata ON
newdata.EduFormAssociationUid = olddata.EduFormAssociationUid
GO
INSERT ListEduFormAssociation
SELECT newdata.*
FROM migtemp_ListEduFormAssociation AS newdata
LEFT JOIN ListEduFormAssociation AS olddata ON
newdata.EduFormAssociationUid = olddata.EduFormAssociationUid
WHERE
olddata.EduFormAssociationUid IS NULL
GO
DROP TABLE migtemp_ListEduFormAssociation
GO
ALTER TABLE ListElectronicPayer NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListElectronicPayer AS newdata
INNER JOIN ListElectronicPayer AS olddata ON
newdata.ElectronicPayerUid = olddata.ElectronicPayerUid
GO
INSERT ListElectronicPayer
SELECT newdata.*
FROM migtemp_ListElectronicPayer AS newdata
LEFT JOIN ListElectronicPayer AS olddata ON
newdata.ElectronicPayerUid = olddata.ElectronicPayerUid
WHERE
olddata.ElectronicPayerUid IS NULL
GO
DROP TABLE migtemp_ListElectronicPayer
GO
ALTER TABLE ListEligibilityAAAErrorCode NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
FROM migtemp_ListEligibilityAAAErrorCode AS newdata
INNER JOIN ListEligibilityAAAErrorCode AS olddata ON
newdata.EligibilityAAAErrorCodeUid = olddata.EligibilityAAAErrorCodeUid
GO
INSERT ListEligibilityAAAErrorCode
SELECT newdata.*
FROM migtemp_ListEligibilityAAAErrorCode AS newdata
LEFT JOIN ListEligibilityAAAErrorCode AS olddata ON
newdata.EligibilityAAAErrorCodeUid = olddata.EligibilityAAAErrorCodeUid
WHERE
olddata.EligibilityAAAErrorCodeUid IS NULL
GO
DROP TABLE migtemp_ListEligibilityAAAErrorCode
GO
ALTER TABLE ListEligibilityCoverageLevel NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListEligibilityCoverageLevel AS newdata
INNER JOIN ListEligibilityCoverageLevel AS olddata ON
newdata.EligibilityCoverageLevelUid = olddata.EligibilityCoverageLevelUid
GO
INSERT ListEligibilityCoverageLevel
SELECT newdata.*
FROM migtemp_ListEligibilityCoverageLevel AS newdata
LEFT JOIN ListEligibilityCoverageLevel AS olddata ON
newdata.EligibilityCoverageLevelUid = olddata.EligibilityCoverageLevelUid
WHERE
olddata.EligibilityCoverageLevelUid IS NULL
GO
DROP TABLE migtemp_ListEligibilityCoverageLevel
GO
ALTER TABLE ListEligibilityFollowUpActionCode NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
FROM migtemp_ListEligibilityFollowUpActionCode AS newdata
INNER JOIN ListEligibilityFollowUpActionCode AS olddata ON
newdata.ListEligibilityFollowupActionCodeUid = olddata.ListEligibilityFollowupActionCodeUid
GO
INSERT ListEligibilityFollowUpActionCode
SELECT newdata.*
FROM migtemp_ListEligibilityFollowUpActionCode AS newdata
LEFT JOIN ListEligibilityFollowUpActionCode AS olddata ON
newdata.ListEligibilityFollowupActionCodeUid = olddata.ListEligibilityFollowupActionCodeUid
WHERE
olddata.ListEligibilityFollowupActionCodeUid IS NULL
GO
DROP TABLE migtemp_ListEligibilityFollowUpActionCode
GO
ALTER TABLE ListEligibilityServiceType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListEligibilityServiceType AS newdata
INNER JOIN ListEligibilityServiceType AS olddata ON
newdata.EligibilityServiceTypeUid = olddata.EligibilityServiceTypeUid
GO
INSERT ListEligibilityServiceType
SELECT newdata.*
FROM migtemp_ListEligibilityServiceType AS newdata
LEFT JOIN ListEligibilityServiceType AS olddata ON
newdata.EligibilityServiceTypeUid = olddata.EligibilityServiceTypeUid
WHERE
olddata.EligibilityServiceTypeUid IS NULL
GO
DROP TABLE migtemp_ListEligibilityServiceType
GO
ALTER TABLE ListEligibilityStatus NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListEligibilityStatus AS newdata
INNER JOIN ListEligibilityStatus AS olddata ON
newdata.EligibilityStatusUid = olddata.EligibilityStatusUid
GO
INSERT ListEligibilityStatus
SELECT newdata.*
FROM migtemp_ListEligibilityStatus AS newdata
LEFT JOIN ListEligibilityStatus AS olddata ON
newdata.EligibilityStatusUid = olddata.EligibilityStatusUid
WHERE
olddata.EligibilityStatusUid IS NULL
GO
DROP TABLE migtemp_ListEligibilityStatus
GO
ALTER TABLE ListEMBullet NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListEMBullet AS newdata
INNER JOIN ListEMBullet AS olddata ON
newdata.EMBulletUid = olddata.EMBulletUid
GO
INSERT ListEMBullet
SELECT newdata.*
FROM migtemp_ListEMBullet AS newdata
LEFT JOIN ListEMBullet AS olddata ON
newdata.EMBulletUid = olddata.EMBulletUid
WHERE
olddata.EMBulletUid IS NULL
GO
DROP TABLE migtemp_ListEMBullet
GO
ALTER TABLE ListEMConfiguration NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListEMConfiguration AS newdata
INNER JOIN ListEMConfiguration AS olddata ON
newdata.EMConfigurationUid = olddata.EMConfigurationUid
GO
INSERT ListEMConfiguration
SELECT newdata.*
FROM migtemp_ListEMConfiguration AS newdata
LEFT JOIN ListEMConfiguration AS olddata ON
newdata.EMConfigurationUid = olddata.EMConfigurationUid
WHERE
olddata.EMConfigurationUid IS NULL
GO
DROP TABLE migtemp_ListEMConfiguration
GO
ALTER TABLE ListEmergencyIndicator NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListEmergencyIndicator AS newdata
INNER JOIN ListEmergencyIndicator AS olddata ON
newdata.EmergencyIndicatorUid = olddata.EmergencyIndicatorUid
GO
INSERT ListEmergencyIndicator
SELECT newdata.*
FROM migtemp_ListEmergencyIndicator AS newdata
LEFT JOIN ListEmergencyIndicator AS olddata ON
newdata.EmergencyIndicatorUid = olddata.EmergencyIndicatorUid
WHERE
olddata.EmergencyIndicatorUid IS NULL
GO
DROP TABLE migtemp_ListEmergencyIndicator
GO
ALTER TABLE ListEMExaminationDescription NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListEMExaminationDescription AS newdata
INNER JOIN ListEMExaminationDescription AS olddata ON
newdata.EMExaminationDescriptionUid = olddata.EMExaminationDescriptionUid
GO
INSERT ListEMExaminationDescription
SELECT newdata.*
FROM migtemp_ListEMExaminationDescription AS newdata
LEFT JOIN ListEMExaminationDescription AS olddata ON
newdata.EMExaminationDescriptionUid = olddata.EMExaminationDescriptionUid
WHERE
olddata.EMExaminationDescriptionUid IS NULL
GO
DROP TABLE migtemp_ListEMExaminationDescription
GO
ALTER TABLE ListEMKeyComponent NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListEMKeyComponent AS newdata
INNER JOIN ListEMKeyComponent AS olddata ON
newdata.EMKeyComponentUid = olddata.EMKeyComponentUid
GO
INSERT ListEMKeyComponent
SELECT newdata.*
FROM migtemp_ListEMKeyComponent AS newdata
LEFT JOIN ListEMKeyComponent AS olddata ON
newdata.EMKeyComponentUid = olddata.EMKeyComponentUid
WHERE
olddata.EMKeyComponentUid IS NULL
GO
DROP TABLE migtemp_ListEMKeyComponent
GO
ALTER TABLE ListEmploymentStatus NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListEmploymentStatus AS newdata
INNER JOIN ListEmploymentStatus AS olddata ON
newdata.EmploymentStatusUid = olddata.EmploymentStatusUid
GO
INSERT ListEmploymentStatus
SELECT newdata.*
FROM migtemp_ListEmploymentStatus AS newdata
LEFT JOIN ListEmploymentStatus AS olddata ON
newdata.EmploymentStatusUid = olddata.EmploymentStatusUid
WHERE
olddata.EmploymentStatusUid IS NULL
GO
DROP TABLE migtemp_ListEmploymentStatus
GO
ALTER TABLE ListEMServiceSite NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListEMServiceSite AS newdata
INNER JOIN ListEMServiceSite AS olddata ON
newdata.EMServiceSiteUid = olddata.EMServiceSiteUid
GO
INSERT ListEMServiceSite
SELECT newdata.*
FROM migtemp_ListEMServiceSite AS newdata
LEFT JOIN ListEMServiceSite AS olddata ON
newdata.EMServiceSiteUid = olddata.EMServiceSiteUid
WHERE
olddata.EMServiceSiteUid IS NULL
GO
DROP TABLE migtemp_ListEMServiceSite
GO
ALTER TABLE ListEMSystemBodyArea NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListEMSystemBodyArea AS newdata
INNER JOIN ListEMSystemBodyArea AS olddata ON
newdata.EMSystemBodyAreaUid = olddata.EMSystemBodyAreaUid
GO
INSERT ListEMSystemBodyArea
SELECT newdata.*
FROM migtemp_ListEMSystemBodyArea AS newdata
LEFT JOIN ListEMSystemBodyArea AS olddata ON
newdata.EMSystemBodyAreaUid = olddata.EMSystemBodyAreaUid
WHERE
olddata.EMSystemBodyAreaUid IS NULL
GO
DROP TABLE migtemp_ListEMSystemBodyArea
GO
ALTER TABLE ListEPSDTReferralCondIndicator NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListEPSDTReferralCondIndicator AS newdata
INNER JOIN ListEPSDTReferralCondIndicator AS olddata ON
newdata.EPSDTReferralCondIndicatorUid = olddata.EPSDTReferralCondIndicatorUid
GO
INSERT ListEPSDTReferralCondIndicator
SELECT newdata.*
FROM migtemp_ListEPSDTReferralCondIndicator AS newdata
LEFT JOIN ListEPSDTReferralCondIndicator AS olddata ON
newdata.EPSDTReferralCondIndicatorUid = olddata.EPSDTReferralCondIndicatorUid
WHERE
olddata.EPSDTReferralCondIndicatorUid IS NULL
GO
DROP TABLE migtemp_ListEPSDTReferralCondIndicator
GO
ALTER TABLE ListERACode NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[Code] = newdata.[Code]
, olddata.[Type] = newdata.[Type]
, olddata.[Description] = newdata.[Description]
, olddata.[Notes] = newdata.[Notes]
FROM migtemp_ListERACode AS newdata
INNER JOIN ListERACode AS olddata ON
newdata.ERACodeUid = olddata.ERACodeUid
GO
INSERT ListERACode
SELECT newdata.*
FROM migtemp_ListERACode AS newdata
LEFT JOIN ListERACode AS olddata ON
newdata.ERACodeUid = olddata.ERACodeUid
WHERE
olddata.ERACodeUid IS NULL
GO
DROP TABLE migtemp_ListERACode
GO
ALTER TABLE ListeRxIdentificationQualifier NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[ExternalID] = newdata.[ExternalID]
, olddata.[Code] = newdata.[Code]
, olddata.[XMLTag] = newdata.[XMLTag]
, olddata.[CodeName] = newdata.[CodeName]
, olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[ePrescribe] = newdata.[ePrescribe]
, olddata.[QualifierType] = newdata.[QualifierType]
, olddata.[UserDefined] = newdata.[UserDefined]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[LastModifiedByUid] = newdata.[LastModifiedByUid]
FROM migtemp_ListeRxIdentificationQualifier AS newdata
INNER JOIN ListeRxIdentificationQualifier AS olddata ON
newdata.eRxIdentificationQualifierUid = olddata.eRxIdentificationQualifierUid
GO
INSERT ListeRxIdentificationQualifier
SELECT newdata.*
FROM migtemp_ListeRxIdentificationQualifier AS newdata
LEFT JOIN ListeRxIdentificationQualifier AS olddata ON
newdata.eRxIdentificationQualifierUid = olddata.eRxIdentificationQualifierUid
WHERE
olddata.eRxIdentificationQualifierUid IS NULL
GO
DROP TABLE migtemp_ListeRxIdentificationQualifier
GO
ALTER TABLE ListeRxMessageDenyReason NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListeRxMessageDenyReason AS newdata
INNER JOIN ListeRxMessageDenyReason AS olddata ON
newdata.eRxMessageDenyReasonUid = olddata.eRxMessageDenyReasonUid
GO
INSERT ListeRxMessageDenyReason
SELECT newdata.*
FROM migtemp_ListeRxMessageDenyReason AS newdata
LEFT JOIN ListeRxMessageDenyReason AS olddata ON
newdata.eRxMessageDenyReasonUid = olddata.eRxMessageDenyReasonUid
WHERE
olddata.eRxMessageDenyReasonUid IS NULL
GO
DROP TABLE migtemp_ListeRxMessageDenyReason
GO
ALTER TABLE ListeRxMessageType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListeRxMessageType AS newdata
INNER JOIN ListeRxMessageType AS olddata ON
newdata.eRxMessageTypeUid = olddata.eRxMessageTypeUid
GO
INSERT ListeRxMessageType
SELECT newdata.*
FROM migtemp_ListeRxMessageType AS newdata
LEFT JOIN ListeRxMessageType AS olddata ON
newdata.eRxMessageTypeUid = olddata.eRxMessageTypeUid
WHERE
olddata.eRxMessageTypeUid IS NULL
GO
DROP TABLE migtemp_ListeRxMessageType
GO
ALTER TABLE ListeRxStatus NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListeRxStatus AS newdata
INNER JOIN ListeRxStatus AS olddata ON
newdata.eRxStatusUid = olddata.eRxStatusUid
GO
INSERT ListeRxStatus
SELECT newdata.*
FROM migtemp_ListeRxStatus AS newdata
LEFT JOIN ListeRxStatus AS olddata ON
newdata.eRxStatusUid = olddata.eRxStatusUid
WHERE
olddata.eRxStatusUid IS NULL
GO
DROP TABLE migtemp_ListeRxStatus
GO
ALTER TABLE ListEthnicity NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListEthnicity AS newdata
INNER JOIN ListEthnicity AS olddata ON
newdata.EthnicityUid = olddata.EthnicityUid
GO
INSERT ListEthnicity
SELECT newdata.*
FROM migtemp_ListEthnicity AS newdata
LEFT JOIN ListEthnicity AS olddata ON
newdata.EthnicityUid = olddata.EthnicityUid
WHERE
olddata.EthnicityUid IS NULL
GO
DROP TABLE migtemp_ListEthnicity
GO
ALTER TABLE ListEventType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListEventType AS newdata
INNER JOIN ListEventType AS olddata ON
newdata.EventTypeUid = olddata.EventTypeUid
GO
INSERT ListEventType
SELECT newdata.*
FROM migtemp_ListEventType AS newdata
LEFT JOIN ListEventType AS olddata ON
newdata.EventTypeUid = olddata.EventTypeUid
WHERE
olddata.EventTypeUid IS NULL
GO
DROP TABLE migtemp_ListEventType
GO
ALTER TABLE ListExercise NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListExercise AS newdata
INNER JOIN ListExercise AS olddata ON
newdata.ExerciseUid = olddata.ExerciseUid
GO
INSERT ListExercise
SELECT newdata.*
FROM migtemp_ListExercise AS newdata
LEFT JOIN ListExercise AS olddata ON
newdata.ExerciseUid = olddata.ExerciseUid
WHERE
olddata.ExerciseUid IS NULL
GO
DROP TABLE migtemp_ListExercise
GO
ALTER TABLE ListFaxCoverSheet NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListFaxCoverSheet AS newdata
INNER JOIN ListFaxCoverSheet AS olddata ON
newdata.FaxCoverSheetUid = olddata.FaxCoverSheetUid
GO
INSERT ListFaxCoverSheet
SELECT newdata.*
FROM migtemp_ListFaxCoverSheet AS newdata
LEFT JOIN ListFaxCoverSheet AS olddata ON
newdata.FaxCoverSheetUid = olddata.FaxCoverSheetUid
WHERE
olddata.FaxCoverSheetUid IS NULL
GO
DROP TABLE migtemp_ListFaxCoverSheet
GO
ALTER TABLE ListFaxServer NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[OrderActionTemplateXml] = newdata.[OrderActionTemplateXml]
FROM migtemp_ListFaxServer AS newdata
INNER JOIN ListFaxServer AS olddata ON
newdata.FaxServerUid = olddata.FaxServerUid
GO
INSERT ListFaxServer
SELECT newdata.*
FROM migtemp_ListFaxServer AS newdata
LEFT JOIN ListFaxServer AS olddata ON
newdata.FaxServerUid = olddata.FaxServerUid
WHERE
olddata.FaxServerUid IS NULL
GO
DROP TABLE migtemp_ListFaxServer
GO
ALTER TABLE ListFhirLaunchParameterField NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListFhirLaunchParameterField AS newdata
INNER JOIN ListFhirLaunchParameterField AS olddata ON
newdata.FhirLaunchParameterFieldUid = olddata.FhirLaunchParameterFieldUid
GO
INSERT ListFhirLaunchParameterField
SELECT newdata.*
FROM migtemp_ListFhirLaunchParameterField AS newdata
LEFT JOIN ListFhirLaunchParameterField AS olddata ON
newdata.FhirLaunchParameterFieldUid = olddata.FhirLaunchParameterFieldUid
WHERE
olddata.FhirLaunchParameterFieldUid IS NULL
GO
DROP TABLE migtemp_ListFhirLaunchParameterField
GO
ALTER TABLE ListFilter NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListFilter AS newdata
INNER JOIN ListFilter AS olddata ON
newdata.FilterUid = olddata.FilterUid
GO
INSERT ListFilter
SELECT newdata.*
FROM migtemp_ListFilter AS newdata
LEFT JOIN ListFilter AS olddata ON
newdata.FilterUid = olddata.FilterUid
WHERE
olddata.FilterUid IS NULL
GO
DROP TABLE migtemp_ListFilter
GO
ALTER TABLE ListFindControlBehavior NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[LicenseCode] = newdata.[LicenseCode]
, olddata.[SearchColumns] = newdata.[SearchColumns]
, olddata.[ColumnsConfig] = newdata.[ColumnsConfig]
, olddata.[AllowDelete] = newdata.[AllowDelete]
, olddata.[AllowExport] = newdata.[AllowExport]
FROM migtemp_ListFindControlBehavior AS newdata
INNER JOIN ListFindControlBehavior AS olddata ON
newdata.FindControlBehaviorUid = olddata.FindControlBehaviorUid
GO
INSERT ListFindControlBehavior
SELECT newdata.*
FROM migtemp_ListFindControlBehavior AS newdata
LEFT JOIN ListFindControlBehavior AS olddata ON
newdata.FindControlBehaviorUid = olddata.FindControlBehaviorUid
WHERE
olddata.FindControlBehaviorUid IS NULL
GO
DROP TABLE migtemp_ListFindControlBehavior
GO
ALTER TABLE ListFindTable NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[LicenseCode] = newdata.[LicenseCode]
, olddata.[SecurityGroupUid] = newdata.[SecurityGroupUid]
, olddata.[Id] = newdata.[Id]
, olddata.[ShowInListEditor] = newdata.[ShowInListEditor]
, olddata.[LoadPriority] = newdata.[LoadPriority]
, olddata.[HasSecurity] = newdata.[HasSecurity]
, olddata.[AllowMaintenance] = newdata.[AllowMaintenance]
, olddata.[AllowNew] = newdata.[AllowNew]
, olddata.[AllowDelete] = newdata.[AllowDelete]
, olddata.[LimitMaintenanceOnNonUserDefined] = newdata.[LimitMaintenanceOnNonUserDefined]
, olddata.[BusinessObjectRequired] = newdata.[BusinessObjectRequired]
, olddata.[LoadStoredProcedure] = newdata.[LoadStoredProcedure]
, olddata.[CustomDBAccessClassName] = newdata.[CustomDBAccessClassName]
, olddata.[FindControlClass] = newdata.[FindControlClass]
, olddata.[EditFormType] = newdata.[EditFormType]
, olddata.[BusinessObject] = newdata.[BusinessObject]
, olddata.[EditBusinessObject] = newdata.[EditBusinessObject]
, olddata.[Columns] = newdata.[Columns]
, olddata.[AuditTableName] = newdata.[AuditTableName]
, olddata.[SaveAsBusinessObject] = newdata.[SaveAsBusinessObject]
, olddata.[MapMerge] = newdata.[MapMerge]
FROM migtemp_ListFindTable AS newdata
INNER JOIN ListFindTable AS olddata ON
newdata.FindTableUid = olddata.FindTableUid
GO
INSERT ListFindTable
SELECT newdata.*
FROM migtemp_ListFindTable AS newdata
LEFT JOIN ListFindTable AS olddata ON
newdata.FindTableUid = olddata.FindTableUid
WHERE
olddata.FindTableUid IS NULL
GO
DROP TABLE migtemp_ListFindTable
GO
ALTER TABLE ListFormattingTemplate NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[RootObjectType] = newdata.[RootObjectType]
, olddata.[Template] = newdata.[Template]
, olddata.[TemplateParameters] = newdata.[TemplateParameters]
, olddata.[FieldParameters] = newdata.[FieldParameters]
, olddata.[Notes] = newdata.[Notes]
, olddata.[QualifiesAsClinicalSummary] = newdata.[QualifiesAsClinicalSummary]
FROM migtemp_ListFormattingTemplate AS newdata
INNER JOIN ListFormattingTemplate AS olddata ON
newdata.FormattingTemplateUid = olddata.FormattingTemplateUid
GO
INSERT ListFormattingTemplate
SELECT newdata.*
FROM migtemp_ListFormattingTemplate AS newdata
LEFT JOIN ListFormattingTemplate AS olddata ON
newdata.FormattingTemplateUid = olddata.FormattingTemplateUid
WHERE
olddata.FormattingTemplateUid IS NULL
GO
DROP TABLE migtemp_ListFormattingTemplate
GO
ALTER TABLE ListFormLayout NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[LicenseCode] = newdata.[LicenseCode]
, olddata.[UIControlUid] = newdata.[UIControlUid]
, olddata.[RequireDataTag] = newdata.[RequireDataTag]
, olddata.[Data] = newdata.[Data]
, olddata.[Notes] = newdata.[Notes]
FROM migtemp_ListFormLayout AS newdata
INNER JOIN ListFormLayout AS olddata ON
newdata.FormLayoutUid = olddata.FormLayoutUid
GO
INSERT ListFormLayout
SELECT newdata.*
FROM migtemp_ListFormLayout AS newdata
LEFT JOIN ListFormLayout AS olddata ON
newdata.FormLayoutUid = olddata.FormLayoutUid
WHERE
olddata.FormLayoutUid IS NULL
GO
DROP TABLE migtemp_ListFormLayout
GO
ALTER TABLE ListFormLayoutControlAction NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListFormLayoutControlAction AS newdata
INNER JOIN ListFormLayoutControlAction AS olddata ON
newdata.FormLayoutControlActionUid = olddata.FormLayoutControlActionUid
GO
INSERT ListFormLayoutControlAction
SELECT newdata.*
FROM migtemp_ListFormLayoutControlAction AS newdata
LEFT JOIN ListFormLayoutControlAction AS olddata ON
newdata.FormLayoutControlActionUid = olddata.FormLayoutControlActionUid
WHERE
olddata.FormLayoutControlActionUid IS NULL
GO
DROP TABLE migtemp_ListFormLayoutControlAction
GO
ALTER TABLE ListFormLayoutControlActionEvent NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListFormLayoutControlActionEvent AS newdata
INNER JOIN ListFormLayoutControlActionEvent AS olddata ON
newdata.FormLayoutControlActionEventUid = olddata.FormLayoutControlActionEventUid
GO
INSERT ListFormLayoutControlActionEvent
SELECT newdata.*
FROM migtemp_ListFormLayoutControlActionEvent AS newdata
LEFT JOIN ListFormLayoutControlActionEvent AS olddata ON
newdata.FormLayoutControlActionEventUid = olddata.FormLayoutControlActionEventUid
WHERE
olddata.FormLayoutControlActionEventUid IS NULL
GO
DROP TABLE migtemp_ListFormLayoutControlActionEvent
GO
ALTER TABLE ListFormTitle NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[Columns] = newdata.[Columns]
FROM migtemp_ListFormTitle AS newdata
INNER JOIN ListFormTitle AS olddata ON
newdata.FormTitleUid = olddata.FormTitleUid
GO
INSERT ListFormTitle
SELECT newdata.*
FROM migtemp_ListFormTitle AS newdata
LEFT JOIN ListFormTitle AS olddata ON
newdata.FormTitleUid = olddata.FormTitleUid
WHERE
olddata.FormTitleUid IS NULL
GO
DROP TABLE migtemp_ListFormTitle
GO
ALTER TABLE ListGender NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListGender AS newdata
INNER JOIN ListGender AS olddata ON
newdata.GenderUid = olddata.GenderUid
GO
INSERT ListGender
SELECT newdata.*
FROM migtemp_ListGender AS newdata
LEFT JOIN ListGender AS olddata ON
newdata.GenderUid = olddata.GenderUid
WHERE
olddata.GenderUid IS NULL
GO
DROP TABLE migtemp_ListGender
GO
ALTER TABLE ListGenderIdentity NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListGenderIdentity AS newdata
INNER JOIN ListGenderIdentity AS olddata ON
newdata.GenderIdentityUid = olddata.GenderIdentityUid
GO
INSERT ListGenderIdentity
SELECT newdata.*
FROM migtemp_ListGenderIdentity AS newdata
LEFT JOIN ListGenderIdentity AS olddata ON
newdata.GenderIdentityUid = olddata.GenderIdentityUid
WHERE
olddata.GenderIdentityUid IS NULL
GO
DROP TABLE migtemp_ListGenderIdentity
GO
ALTER TABLE ListGeneralNote NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListGeneralNote AS newdata
INNER JOIN ListGeneralNote AS olddata ON
newdata.GeneralNoteUid = olddata.GeneralNoteUid
GO
INSERT ListGeneralNote
SELECT newdata.*
FROM migtemp_ListGeneralNote AS newdata
LEFT JOIN ListGeneralNote AS olddata ON
newdata.GeneralNoteUid = olddata.GeneralNoteUid
WHERE
olddata.GeneralNoteUid IS NULL
GO
DROP TABLE migtemp_ListGeneralNote
GO
ALTER TABLE ListGeneralNoteType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[LicenseCode] = newdata.[LicenseCode]
FROM migtemp_ListGeneralNoteType AS newdata
INNER JOIN ListGeneralNoteType AS olddata ON
newdata.GeneralNoteTypeUid = olddata.GeneralNoteTypeUid
GO
INSERT ListGeneralNoteType
SELECT newdata.*
FROM migtemp_ListGeneralNoteType AS newdata
LEFT JOIN ListGeneralNoteType AS olddata ON
newdata.GeneralNoteTypeUid = olddata.GeneralNoteTypeUid
WHERE
olddata.GeneralNoteTypeUid IS NULL
GO
DROP TABLE migtemp_ListGeneralNoteType
GO
ALTER TABLE ListGraphicNote NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListGraphicNote AS newdata
INNER JOIN ListGraphicNote AS olddata ON
newdata.GraphicNoteUid = olddata.GraphicNoteUid
GO
INSERT ListGraphicNote
SELECT newdata.*
FROM migtemp_ListGraphicNote AS newdata
LEFT JOIN ListGraphicNote AS olddata ON
newdata.GraphicNoteUid = olddata.GraphicNoteUid
WHERE
olddata.GraphicNoteUid IS NULL
GO
DROP TABLE migtemp_ListGraphicNote
GO
ALTER TABLE ListGroupUIConfiguration NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListGroupUIConfiguration AS newdata
INNER JOIN ListGroupUIConfiguration AS olddata ON
newdata.GroupUIConfigurationUid = olddata.GroupUIConfigurationUid
GO
INSERT ListGroupUIConfiguration
SELECT newdata.*
FROM migtemp_ListGroupUIConfiguration AS newdata
LEFT JOIN ListGroupUIConfiguration AS olddata ON
newdata.GroupUIConfigurationUid = olddata.GroupUIConfigurationUid
WHERE
olddata.GroupUIConfigurationUid IS NULL
GO
DROP TABLE migtemp_ListGroupUIConfiguration
GO
ALTER TABLE ListGrowthChart NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListGrowthChart AS newdata
INNER JOIN ListGrowthChart AS olddata ON
newdata.GrowthChartUid = olddata.GrowthChartUid
GO
INSERT ListGrowthChart
SELECT newdata.*
FROM migtemp_ListGrowthChart AS newdata
LEFT JOIN ListGrowthChart AS olddata ON
newdata.GrowthChartUid = olddata.GrowthChartUid
WHERE
olddata.GrowthChartUid IS NULL
GO
DROP TABLE migtemp_ListGrowthChart
GO
ALTER TABLE ListHealthCareServiceLocation NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListHealthCareServiceLocation AS newdata
INNER JOIN ListHealthCareServiceLocation AS olddata ON
newdata.HealthCareServiceLocationUid = olddata.HealthCareServiceLocationUid
GO
INSERT ListHealthCareServiceLocation
SELECT newdata.*
FROM migtemp_ListHealthCareServiceLocation AS newdata
LEFT JOIN ListHealthCareServiceLocation AS olddata ON
newdata.HealthCareServiceLocationUid = olddata.HealthCareServiceLocationUid
WHERE
olddata.HealthCareServiceLocationUid IS NULL
GO
DROP TABLE migtemp_ListHealthCareServiceLocation
GO
ALTER TABLE ListHEDIS NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListHEDIS AS newdata
INNER JOIN ListHEDIS AS olddata ON
newdata.HEDISUid = olddata.HEDISUid
GO
INSERT ListHEDIS
SELECT newdata.*
FROM migtemp_ListHEDIS AS newdata
LEFT JOIN ListHEDIS AS olddata ON
newdata.HEDISUid = olddata.HEDISUid
WHERE
olddata.HEDISUid IS NULL
GO
DROP TABLE migtemp_ListHEDIS
GO
ALTER TABLE ListHIPAAReleaseInfo NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListHIPAAReleaseInfo AS newdata
INNER JOIN ListHIPAAReleaseInfo AS olddata ON
newdata.HIPAAReleaseInfoUid = olddata.HIPAAReleaseInfoUid
GO
INSERT ListHIPAAReleaseInfo
SELECT newdata.*
FROM migtemp_ListHIPAAReleaseInfo AS newdata
LEFT JOIN ListHIPAAReleaseInfo AS olddata ON
newdata.HIPAAReleaseInfoUid = olddata.HIPAAReleaseInfoUid
WHERE
olddata.HIPAAReleaseInfoUid IS NULL
GO
DROP TABLE migtemp_ListHIPAAReleaseInfo
GO
ALTER TABLE ListHistorian NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListHistorian AS newdata
INNER JOIN ListHistorian AS olddata ON
newdata.HistorianUid = olddata.HistorianUid
GO
INSERT ListHistorian
SELECT newdata.*
FROM migtemp_ListHistorian AS newdata
LEFT JOIN ListHistorian AS olddata ON
newdata.HistorianUid = olddata.HistorianUid
WHERE
olddata.HistorianUid IS NULL
GO
DROP TABLE migtemp_ListHistorian
GO
ALTER TABLE ListHistoryGroup NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[LicenseCode] = newdata.[LicenseCode]
, olddata.[ResultsAQN] = newdata.[ResultsAQN]
, olddata.[UseTree] = newdata.[UseTree]
, olddata.[AllowDuplicate] = newdata.[AllowDuplicate]
FROM migtemp_ListHistoryGroup AS newdata
INNER JOIN ListHistoryGroup AS olddata ON
newdata.HistoryGroupUid = olddata.HistoryGroupUid
GO
INSERT ListHistoryGroup
SELECT newdata.*
FROM migtemp_ListHistoryGroup AS newdata
LEFT JOIN ListHistoryGroup AS olddata ON
newdata.HistoryGroupUid = olddata.HistoryGroupUid
WHERE
olddata.HistoryGroupUid IS NULL
GO
DROP TABLE migtemp_ListHistoryGroup
GO
ALTER TABLE ListHMRule NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListHMRule AS newdata
INNER JOIN ListHMRule AS olddata ON
newdata.HMRuleUid = olddata.HMRuleUid
GO
INSERT ListHMRule
SELECT newdata.*
FROM migtemp_ListHMRule AS newdata
LEFT JOIN ListHMRule AS olddata ON
newdata.HMRuleUid = olddata.HMRuleUid
WHERE
olddata.HMRuleUid IS NULL
GO
DROP TABLE migtemp_ListHMRule
GO
ALTER TABLE ListHMRuleDeclineReason NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListHMRuleDeclineReason AS newdata
INNER JOIN ListHMRuleDeclineReason AS olddata ON
newdata.MHRuleDeclineReasonUid = olddata.MHRuleDeclineReasonUid
GO
INSERT ListHMRuleDeclineReason
SELECT newdata.*
FROM migtemp_ListHMRuleDeclineReason AS newdata
LEFT JOIN ListHMRuleDeclineReason AS olddata ON
newdata.MHRuleDeclineReasonUid = olddata.MHRuleDeclineReasonUid
WHERE
olddata.MHRuleDeclineReasonUid IS NULL
GO
DROP TABLE migtemp_ListHMRuleDeclineReason
GO
ALTER TABLE ListHpi NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListHpi AS newdata
INNER JOIN ListHpi AS olddata ON
newdata.HpiUid = olddata.HpiUid
GO
INSERT ListHpi
SELECT newdata.*
FROM migtemp_ListHpi AS newdata
LEFT JOIN ListHpi AS olddata ON
newdata.HpiUid = olddata.HpiUid
WHERE
olddata.HpiUid IS NULL
GO
DROP TABLE migtemp_ListHpi
GO
ALTER TABLE ListHpiCategory NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListHpiCategory AS newdata
INNER JOIN ListHpiCategory AS olddata ON
newdata.HpiCategoryUid = olddata.HpiCategoryUid
GO
INSERT ListHpiCategory
SELECT newdata.*
FROM migtemp_ListHpiCategory AS newdata
LEFT JOIN ListHpiCategory AS olddata ON
newdata.HpiCategoryUid = olddata.HpiCategoryUid
WHERE
olddata.HpiCategoryUid IS NULL
GO
DROP TABLE migtemp_ListHpiCategory
GO
ALTER TABLE ListHpiCategoryType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListHpiCategoryType AS newdata
INNER JOIN ListHpiCategoryType AS olddata ON
newdata.HpiCategoryTypeUid = olddata.HpiCategoryTypeUid
GO
INSERT ListHpiCategoryType
SELECT newdata.*
FROM migtemp_ListHpiCategoryType AS newdata
LEFT JOIN ListHpiCategoryType AS olddata ON
newdata.HpiCategoryTypeUid = olddata.HpiCategoryTypeUid
WHERE
olddata.HpiCategoryTypeUid IS NULL
GO
DROP TABLE migtemp_ListHpiCategoryType
GO
ALTER TABLE ListHxRelationship NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListHxRelationship AS newdata
INNER JOIN ListHxRelationship AS olddata ON
newdata.HxRelationshipUid = olddata.HxRelationshipUid
GO
INSERT ListHxRelationship
SELECT newdata.*
FROM migtemp_ListHxRelationship AS newdata
LEFT JOIN ListHxRelationship AS olddata ON
newdata.HxRelationshipUid = olddata.HxRelationshipUid
WHERE
olddata.HxRelationshipUid IS NULL
GO
DROP TABLE migtemp_ListHxRelationship
GO
ALTER TABLE ListIcDeleteProcessor NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListIcDeleteProcessor AS newdata
INNER JOIN ListIcDeleteProcessor AS olddata ON
newdata.IcDeleteProcessorUid = olddata.IcDeleteProcessorUid
GO
INSERT ListIcDeleteProcessor
SELECT newdata.*
FROM migtemp_ListIcDeleteProcessor AS newdata
LEFT JOIN ListIcDeleteProcessor AS olddata ON
newdata.IcDeleteProcessorUid = olddata.IcDeleteProcessorUid
WHERE
olddata.IcDeleteProcessorUid IS NULL
GO
DROP TABLE migtemp_ListIcDeleteProcessor
GO
ALTER TABLE ListIcPollingProcessor NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListIcPollingProcessor AS newdata
INNER JOIN ListIcPollingProcessor AS olddata ON
newdata.IcPollingProcessorUid = olddata.IcPollingProcessorUid
GO
INSERT ListIcPollingProcessor
SELECT newdata.*
FROM migtemp_ListIcPollingProcessor AS newdata
LEFT JOIN ListIcPollingProcessor AS olddata ON
newdata.IcPollingProcessorUid = olddata.IcPollingProcessorUid
WHERE
olddata.IcPollingProcessorUid IS NULL
GO
DROP TABLE migtemp_ListIcPollingProcessor
GO
ALTER TABLE ListIcProcessor NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListIcProcessor AS newdata
INNER JOIN ListIcProcessor AS olddata ON
newdata.IcProcessorUid = olddata.IcProcessorUid
GO
INSERT ListIcProcessor
SELECT newdata.*
FROM migtemp_ListIcProcessor AS newdata
LEFT JOIN ListIcProcessor AS olddata ON
newdata.IcProcessorUid = olddata.IcProcessorUid
WHERE
olddata.IcProcessorUid IS NULL
GO
DROP TABLE migtemp_ListIcProcessor
GO
ALTER TABLE ListIcRequestProcessor NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListIcRequestProcessor AS newdata
INNER JOIN ListIcRequestProcessor AS olddata ON
newdata.IcRequestProcessorUid = olddata.IcRequestProcessorUid
GO
INSERT ListIcRequestProcessor
SELECT newdata.*
FROM migtemp_ListIcRequestProcessor AS newdata
LEFT JOIN ListIcRequestProcessor AS olddata ON
newdata.IcRequestProcessorUid = olddata.IcRequestProcessorUid
WHERE
olddata.IcRequestProcessorUid IS NULL
GO
DROP TABLE migtemp_ListIcRequestProcessor
GO
ALTER TABLE ListImmzCompletion NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListImmzCompletion AS newdata
INNER JOIN ListImmzCompletion AS olddata ON
newdata.ImmzCompletionUid = olddata.ImmzCompletionUid
GO
INSERT ListImmzCompletion
SELECT newdata.*
FROM migtemp_ListImmzCompletion AS newdata
LEFT JOIN ListImmzCompletion AS olddata ON
newdata.ImmzCompletionUid = olddata.ImmzCompletionUid
WHERE
olddata.ImmzCompletionUid IS NULL
GO
DROP TABLE migtemp_ListImmzCompletion
GO
ALTER TABLE ListImmzContraindication NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListImmzContraindication AS newdata
INNER JOIN ListImmzContraindication AS olddata ON
newdata.ImmzContraindicationUid = olddata.ImmzContraindicationUid
GO
INSERT ListImmzContraindication
SELECT newdata.*
FROM migtemp_ListImmzContraindication AS newdata
LEFT JOIN ListImmzContraindication AS olddata ON
newdata.ImmzContraindicationUid = olddata.ImmzContraindicationUid
WHERE
olddata.ImmzContraindicationUid IS NULL
GO
DROP TABLE migtemp_ListImmzContraindication
GO
ALTER TABLE ListImmzEvidenceOfImmunity NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListImmzEvidenceOfImmunity AS newdata
INNER JOIN ListImmzEvidenceOfImmunity AS olddata ON
newdata.ImmzEvidenceOfImmunityUid = olddata.ImmzEvidenceOfImmunityUid
GO
INSERT ListImmzEvidenceOfImmunity
SELECT newdata.*
FROM migtemp_ListImmzEvidenceOfImmunity AS newdata
LEFT JOIN ListImmzEvidenceOfImmunity AS olddata ON
newdata.ImmzEvidenceOfImmunityUid = olddata.ImmzEvidenceOfImmunityUid
WHERE
olddata.ImmzEvidenceOfImmunityUid IS NULL
GO
DROP TABLE migtemp_ListImmzEvidenceOfImmunity
GO
ALTER TABLE ListImmzHistorySource NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListImmzHistorySource AS newdata
INNER JOIN ListImmzHistorySource AS olddata ON
newdata.ImmzHistorySourceUid = olddata.ImmzHistorySourceUid
GO
INSERT ListImmzHistorySource
SELECT newdata.*
FROM migtemp_ListImmzHistorySource AS newdata
LEFT JOIN ListImmzHistorySource AS olddata ON
newdata.ImmzHistorySourceUid = olddata.ImmzHistorySourceUid
WHERE
olddata.ImmzHistorySourceUid IS NULL
GO
DROP TABLE migtemp_ListImmzHistorySource
GO
ALTER TABLE ListImmzReaction NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListImmzReaction AS newdata
INNER JOIN ListImmzReaction AS olddata ON
newdata.ImmzReactionUid = olddata.ImmzReactionUid
GO
INSERT ListImmzReaction
SELECT newdata.*
FROM migtemp_ListImmzReaction AS newdata
LEFT JOIN ListImmzReaction AS olddata ON
newdata.ImmzReactionUid = olddata.ImmzReactionUid
WHERE
olddata.ImmzReactionUid IS NULL
GO
DROP TABLE migtemp_ListImmzReaction
GO
ALTER TABLE ListImmzRefusal NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListImmzRefusal AS newdata
INNER JOIN ListImmzRefusal AS olddata ON
newdata.ImmzRefusalUid = olddata.ImmzRefusalUid
GO
INSERT ListImmzRefusal
SELECT newdata.*
FROM migtemp_ListImmzRefusal AS newdata
LEFT JOIN ListImmzRefusal AS olddata ON
newdata.ImmzRefusalUid = olddata.ImmzRefusalUid
WHERE
olddata.ImmzRefusalUid IS NULL
GO
DROP TABLE migtemp_ListImmzRefusal
GO
ALTER TABLE ListImmzReminderRecall NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListImmzReminderRecall AS newdata
INNER JOIN ListImmzReminderRecall AS olddata ON
newdata.ImmzReminderRecallUid = olddata.ImmzReminderRecallUid
GO
INSERT ListImmzReminderRecall
SELECT newdata.*
FROM migtemp_ListImmzReminderRecall AS newdata
LEFT JOIN ListImmzReminderRecall AS olddata ON
newdata.ImmzReminderRecallUid = olddata.ImmzReminderRecallUid
WHERE
olddata.ImmzReminderRecallUid IS NULL
GO
DROP TABLE migtemp_ListImmzReminderRecall
GO
ALTER TABLE ListImmzSpecialIndications NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListImmzSpecialIndications AS newdata
INNER JOIN ListImmzSpecialIndications AS olddata ON
newdata.ImmzSpecialIndicationsUid = olddata.ImmzSpecialIndicationsUid
GO
INSERT ListImmzSpecialIndications
SELECT newdata.*
FROM migtemp_ListImmzSpecialIndications AS newdata
LEFT JOIN ListImmzSpecialIndications AS olddata ON
newdata.ImmzSpecialIndicationsUid = olddata.ImmzSpecialIndicationsUid
WHERE
olddata.ImmzSpecialIndicationsUid IS NULL
GO
DROP TABLE migtemp_ListImmzSpecialIndications
GO
ALTER TABLE ListIndustry NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListIndustry AS newdata
INNER JOIN ListIndustry AS olddata ON
newdata.IndustryUid = olddata.IndustryUid
GO
INSERT ListIndustry
SELECT newdata.*
FROM migtemp_ListIndustry AS newdata
LEFT JOIN ListIndustry AS olddata ON
newdata.IndustryUid = olddata.IndustryUid
WHERE
olddata.IndustryUid IS NULL
GO
DROP TABLE migtemp_ListIndustry
GO
ALTER TABLE ListInstantMessageStatus NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListInstantMessageStatus AS newdata
INNER JOIN ListInstantMessageStatus AS olddata ON
newdata.InstantMessageStatusUid = olddata.InstantMessageStatusUid
GO
INSERT ListInstantMessageStatus
SELECT newdata.*
FROM migtemp_ListInstantMessageStatus AS newdata
LEFT JOIN ListInstantMessageStatus AS olddata ON
newdata.InstantMessageStatusUid = olddata.InstantMessageStatusUid
WHERE
olddata.InstantMessageStatusUid IS NULL
GO
DROP TABLE migtemp_ListInstantMessageStatus
GO
ALTER TABLE ListInsuranceLevelName NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListInsuranceLevelName AS newdata
INNER JOIN ListInsuranceLevelName AS olddata ON
newdata.InsuranceLevelNameUid = olddata.InsuranceLevelNameUid
GO
INSERT ListInsuranceLevelName
SELECT newdata.*
FROM migtemp_ListInsuranceLevelName AS newdata
LEFT JOIN ListInsuranceLevelName AS olddata ON
newdata.InsuranceLevelNameUid = olddata.InsuranceLevelNameUid
WHERE
olddata.InsuranceLevelNameUid IS NULL
GO
DROP TABLE migtemp_ListInsuranceLevelName
GO
ALTER TABLE ListIntegrationPartner NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListIntegrationPartner AS newdata
INNER JOIN ListIntegrationPartner AS olddata ON
newdata.IntegrationPartnerUid = olddata.IntegrationPartnerUid
GO
INSERT ListIntegrationPartner
SELECT newdata.*
FROM migtemp_ListIntegrationPartner AS newdata
LEFT JOIN ListIntegrationPartner AS olddata ON
newdata.IntegrationPartnerUid = olddata.IntegrationPartnerUid
WHERE
olddata.IntegrationPartnerUid IS NULL
GO
DROP TABLE migtemp_ListIntegrationPartner
GO
ALTER TABLE ListIntegrationPartnerType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListIntegrationPartnerType AS newdata
INNER JOIN ListIntegrationPartnerType AS olddata ON
newdata.IntegrationPartnerUid = olddata.IntegrationPartnerUid
GO
INSERT ListIntegrationPartnerType
SELECT newdata.*
FROM migtemp_ListIntegrationPartnerType AS newdata
LEFT JOIN ListIntegrationPartnerType AS olddata ON
newdata.IntegrationPartnerUid = olddata.IntegrationPartnerUid
WHERE
olddata.IntegrationPartnerUid IS NULL
GO
DROP TABLE migtemp_ListIntegrationPartnerType
GO
ALTER TABLE ListInterfaceBusinessObject NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListInterfaceBusinessObject AS newdata
INNER JOIN ListInterfaceBusinessObject AS olddata ON
newdata.InterfaceBusinessObjectUid = olddata.InterfaceBusinessObjectUid
GO
INSERT ListInterfaceBusinessObject
SELECT newdata.*
FROM migtemp_ListInterfaceBusinessObject AS newdata
LEFT JOIN ListInterfaceBusinessObject AS olddata ON
newdata.InterfaceBusinessObjectUid = olddata.InterfaceBusinessObjectUid
WHERE
olddata.InterfaceBusinessObjectUid IS NULL
GO
DROP TABLE migtemp_ListInterfaceBusinessObject
GO
ALTER TABLE ListJob NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[AssemblyQualifiedName] = newdata.[AssemblyQualifiedName]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[UIAssemblyQualifiedName] = newdata.[UIAssemblyQualifiedName]
FROM migtemp_ListJob AS newdata
INNER JOIN ListJob AS olddata ON
newdata.JobUid = olddata.JobUid
GO
INSERT ListJob
SELECT newdata.*
FROM migtemp_ListJob AS newdata
LEFT JOIN ListJob AS olddata ON
newdata.JobUid = olddata.JobUid
WHERE
olddata.JobUid IS NULL
GO
DROP TABLE migtemp_ListJob
GO
ALTER TABLE ListJobScheduleTimeBase NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListJobScheduleTimeBase AS newdata
INNER JOIN ListJobScheduleTimeBase AS olddata ON
newdata.JobScheduleTimeBaseUid = olddata.JobScheduleTimeBaseUid
GO
INSERT ListJobScheduleTimeBase
SELECT newdata.*
FROM migtemp_ListJobScheduleTimeBase AS newdata
LEFT JOIN ListJobScheduleTimeBase AS olddata ON
newdata.JobScheduleTimeBaseUid = olddata.JobScheduleTimeBaseUid
WHERE
olddata.JobScheduleTimeBaseUid IS NULL
GO
DROP TABLE migtemp_ListJobScheduleTimeBase
GO
ALTER TABLE ListLaboratory NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListLaboratory AS newdata
INNER JOIN ListLaboratory AS olddata ON
newdata.LaboratoryUid = olddata.LaboratoryUid
GO
INSERT ListLaboratory
SELECT newdata.*
FROM migtemp_ListLaboratory AS newdata
LEFT JOIN ListLaboratory AS olddata ON
newdata.LaboratoryUid = olddata.LaboratoryUid
WHERE
olddata.LaboratoryUid IS NULL
GO
DROP TABLE migtemp_ListLaboratory
GO
ALTER TABLE ListLaboratoryOrder NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListLaboratoryOrder AS newdata
INNER JOIN ListLaboratoryOrder AS olddata ON
newdata.LaboratoryOrderUid = olddata.LaboratoryOrderUid
GO
INSERT ListLaboratoryOrder
SELECT newdata.*
FROM migtemp_ListLaboratoryOrder AS newdata
LEFT JOIN ListLaboratoryOrder AS olddata ON
newdata.LaboratoryOrderUid = olddata.LaboratoryOrderUid
WHERE
olddata.LaboratoryOrderUid IS NULL
GO
DROP TABLE migtemp_ListLaboratoryOrder
GO
ALTER TABLE ListLanguage NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[Code] = newdata.[Code]
FROM migtemp_ListLanguage AS newdata
INNER JOIN ListLanguage AS olddata ON
newdata.LanguageUid = olddata.LanguageUid
GO
INSERT ListLanguage
SELECT newdata.*
FROM migtemp_ListLanguage AS newdata
LEFT JOIN ListLanguage AS olddata ON
newdata.LanguageUid = olddata.LanguageUid
WHERE
olddata.LanguageUid IS NULL
GO
DROP TABLE migtemp_ListLanguage
GO
ALTER TABLE ListLetterModel NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListLetterModel AS newdata
INNER JOIN ListLetterModel AS olddata ON
newdata.LetterModelUid = olddata.LetterModelUid
GO
INSERT ListLetterModel
SELECT newdata.*
FROM migtemp_ListLetterModel AS newdata
LEFT JOIN ListLetterModel AS olddata ON
newdata.LetterModelUid = olddata.LetterModelUid
WHERE
olddata.LetterModelUid IS NULL
GO
DROP TABLE migtemp_ListLetterModel
GO
ALTER TABLE ListLockConcept NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListLockConcept AS newdata
INNER JOIN ListLockConcept AS olddata ON
newdata.LockConceptUid = olddata.LockConceptUid
GO
INSERT ListLockConcept
SELECT newdata.*
FROM migtemp_ListLockConcept AS newdata
LEFT JOIN ListLockConcept AS olddata ON
newdata.LockConceptUid = olddata.LockConceptUid
WHERE
olddata.LockConceptUid IS NULL
GO
DROP TABLE migtemp_ListLockConcept
GO
ALTER TABLE ListLockParentType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListLockParentType AS newdata
INNER JOIN ListLockParentType AS olddata ON
newdata.LockParentTypeUid = olddata.LockParentTypeUid
GO
INSERT ListLockParentType
SELECT newdata.*
FROM migtemp_ListLockParentType AS newdata
LEFT JOIN ListLockParentType AS olddata ON
newdata.LockParentTypeUid = olddata.LockParentTypeUid
WHERE
olddata.LockParentTypeUid IS NULL
GO
DROP TABLE migtemp_ListLockParentType
GO
ALTER TABLE ListLOINC NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[COMPONENT] = newdata.[COMPONENT]
, olddata.[SYSTEM] = newdata.[SYSTEM]
, olddata.[CLASS] = newdata.[CLASS]
, olddata.[STATUS] = newdata.[STATUS]
, olddata.[MAP_TO] = newdata.[MAP_TO]
, olddata.[EX_US_UNITS] = newdata.[EX_US_UNITS]
, olddata.[RelatedNames2] = newdata.[RelatedNames2]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[LastModifiedByUid] = newdata.[LastModifiedByUid]
, olddata.[UserDefined] = newdata.[UserDefined]
FROM migtemp_ListLOINC AS newdata
INNER JOIN ListLOINC AS olddata ON
newdata.LOINCUid = olddata.LOINCUid
GO
INSERT ListLOINC
SELECT newdata.*
FROM migtemp_ListLOINC AS newdata
LEFT JOIN ListLOINC AS olddata ON
newdata.LOINCUid = olddata.LOINCUid
WHERE
olddata.LOINCUid IS NULL
GO
DROP TABLE migtemp_ListLOINC
GO
ALTER TABLE ListMacro NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListMacro AS newdata
INNER JOIN ListMacro AS olddata ON
newdata.MacroUid = olddata.MacroUid
GO
INSERT ListMacro
SELECT newdata.*
FROM migtemp_ListMacro AS newdata
LEFT JOIN ListMacro AS olddata ON
newdata.MacroUid = olddata.MacroUid
WHERE
olddata.MacroUid IS NULL
GO
DROP TABLE migtemp_ListMacro
GO
ALTER TABLE ListMacroGroup NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListMacroGroup AS newdata
INNER JOIN ListMacroGroup AS olddata ON
newdata.MacroGroupUid = olddata.MacroGroupUid
GO
INSERT ListMacroGroup
SELECT newdata.*
FROM migtemp_ListMacroGroup AS newdata
LEFT JOIN ListMacroGroup AS olddata ON
newdata.MacroGroupUid = olddata.MacroGroupUid
WHERE
olddata.MacroGroupUid IS NULL
GO
DROP TABLE migtemp_ListMacroGroup
GO
ALTER TABLE ListMaritalStatus NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListMaritalStatus AS newdata
INNER JOIN ListMaritalStatus AS olddata ON
newdata.MaritalStatusUid = olddata.MaritalStatusUid
GO
INSERT ListMaritalStatus
SELECT newdata.*
FROM migtemp_ListMaritalStatus AS newdata
LEFT JOIN ListMaritalStatus AS olddata ON
newdata.MaritalStatusUid = olddata.MaritalStatusUid
WHERE
olddata.MaritalStatusUid IS NULL
GO
DROP TABLE migtemp_ListMaritalStatus
GO
ALTER TABLE ListMeasurementQualifier NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListMeasurementQualifier AS newdata
INNER JOIN ListMeasurementQualifier AS olddata ON
newdata.MeasurementQualifierUid = olddata.MeasurementQualifierUid
GO
INSERT ListMeasurementQualifier
SELECT newdata.*
FROM migtemp_ListMeasurementQualifier AS newdata
LEFT JOIN ListMeasurementQualifier AS olddata ON
newdata.MeasurementQualifierUid = olddata.MeasurementQualifierUid
WHERE
olddata.MeasurementQualifierUid IS NULL
GO
DROP TABLE migtemp_ListMeasurementQualifier
GO
ALTER TABLE ListMedicalDeviceStatus NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListMedicalDeviceStatus AS newdata
INNER JOIN ListMedicalDeviceStatus AS olddata ON
newdata.MedicalDeviceStatusUid = olddata.MedicalDeviceStatusUid
GO
INSERT ListMedicalDeviceStatus
SELECT newdata.*
FROM migtemp_ListMedicalDeviceStatus AS newdata
LEFT JOIN ListMedicalDeviceStatus AS olddata ON
newdata.MedicalDeviceStatusUid = olddata.MedicalDeviceStatusUid
WHERE
olddata.MedicalDeviceStatusUid IS NULL
GO
DROP TABLE migtemp_ListMedicalDeviceStatus
GO
ALTER TABLE ListMedicalServicesType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListMedicalServicesType AS newdata
INNER JOIN ListMedicalServicesType AS olddata ON
newdata.MedicalServicesTypeUid = olddata.MedicalServicesTypeUid
GO
INSERT ListMedicalServicesType
SELECT newdata.*
FROM migtemp_ListMedicalServicesType AS newdata
LEFT JOIN ListMedicalServicesType AS olddata ON
newdata.MedicalServicesTypeUid = olddata.MedicalServicesTypeUid
WHERE
olddata.MedicalServicesTypeUid IS NULL
GO
DROP TABLE migtemp_ListMedicalServicesType
GO
ALTER TABLE ListMedicareSecondaryReasonCode NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListMedicareSecondaryReasonCode AS newdata
INNER JOIN ListMedicareSecondaryReasonCode AS olddata ON
newdata.MedicareSecondaryReasonCodeUid = olddata.MedicareSecondaryReasonCodeUid
GO
INSERT ListMedicareSecondaryReasonCode
SELECT newdata.*
FROM migtemp_ListMedicareSecondaryReasonCode AS newdata
LEFT JOIN ListMedicareSecondaryReasonCode AS olddata ON
newdata.MedicareSecondaryReasonCodeUid = olddata.MedicareSecondaryReasonCodeUid
WHERE
olddata.MedicareSecondaryReasonCodeUid IS NULL
GO
DROP TABLE migtemp_ListMedicareSecondaryReasonCode
GO
ALTER TABLE ListMedicationAction NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListMedicationAction AS newdata
INNER JOIN ListMedicationAction AS olddata ON
newdata.MedicationActionUid = olddata.MedicationActionUid
GO
INSERT ListMedicationAction
SELECT newdata.*
FROM migtemp_ListMedicationAction AS newdata
LEFT JOIN ListMedicationAction AS olddata ON
newdata.MedicationActionUid = olddata.MedicationActionUid
WHERE
olddata.MedicationActionUid IS NULL
GO
DROP TABLE migtemp_ListMedicationAction
GO
ALTER TABLE ListMedicationCategory NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListMedicationCategory AS newdata
INNER JOIN ListMedicationCategory AS olddata ON
newdata.MedicationCategoryUid = olddata.MedicationCategoryUid
GO
INSERT ListMedicationCategory
SELECT newdata.*
FROM migtemp_ListMedicationCategory AS newdata
LEFT JOIN ListMedicationCategory AS olddata ON
newdata.MedicationCategoryUid = olddata.MedicationCategoryUid
WHERE
olddata.MedicationCategoryUid IS NULL
GO
DROP TABLE migtemp_ListMedicationCategory
GO
ALTER TABLE ListMedicationDay NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListMedicationDay AS newdata
INNER JOIN ListMedicationDay AS olddata ON
newdata.MedicationDayUid = olddata.MedicationDayUid
GO
INSERT ListMedicationDay
SELECT newdata.*
FROM migtemp_ListMedicationDay AS newdata
LEFT JOIN ListMedicationDay AS olddata ON
newdata.MedicationDayUid = olddata.MedicationDayUid
WHERE
olddata.MedicationDayUid IS NULL
GO
DROP TABLE migtemp_ListMedicationDay
GO
ALTER TABLE ListMedicationFrequency NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListMedicationFrequency AS newdata
INNER JOIN ListMedicationFrequency AS olddata ON
newdata.MedicationFrequencyUid = olddata.MedicationFrequencyUid
GO
INSERT ListMedicationFrequency
SELECT newdata.*
FROM migtemp_ListMedicationFrequency AS newdata
LEFT JOIN ListMedicationFrequency AS olddata ON
newdata.MedicationFrequencyUid = olddata.MedicationFrequencyUid
WHERE
olddata.MedicationFrequencyUid IS NULL
GO
DROP TABLE migtemp_ListMedicationFrequency
GO
ALTER TABLE ListMedicationFundingSource NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListMedicationFundingSource AS newdata
INNER JOIN ListMedicationFundingSource AS olddata ON
newdata.MedicationFundingSourceUid = olddata.MedicationFundingSourceUid
GO
INSERT ListMedicationFundingSource
SELECT newdata.*
FROM migtemp_ListMedicationFundingSource AS newdata
LEFT JOIN ListMedicationFundingSource AS olddata ON
newdata.MedicationFundingSourceUid = olddata.MedicationFundingSourceUid
WHERE
olddata.MedicationFundingSourceUid IS NULL
GO
DROP TABLE migtemp_ListMedicationFundingSource
GO
ALTER TABLE ListMedicationPRNReason NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListMedicationPRNReason AS newdata
INNER JOIN ListMedicationPRNReason AS olddata ON
newdata.MedicationPRNReasonUid = olddata.MedicationPRNReasonUid
GO
INSERT ListMedicationPRNReason
SELECT newdata.*
FROM migtemp_ListMedicationPRNReason AS newdata
LEFT JOIN ListMedicationPRNReason AS olddata ON
newdata.MedicationPRNReasonUid = olddata.MedicationPRNReasonUid
WHERE
olddata.MedicationPRNReasonUid IS NULL
GO
DROP TABLE migtemp_ListMedicationPRNReason
GO
ALTER TABLE ListMedicationRefill NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListMedicationRefill AS newdata
INNER JOIN ListMedicationRefill AS olddata ON
newdata.MedicationRefillUid = olddata.MedicationRefillUid
GO
INSERT ListMedicationRefill
SELECT newdata.*
FROM migtemp_ListMedicationRefill AS newdata
LEFT JOIN ListMedicationRefill AS olddata ON
newdata.MedicationRefillUid = olddata.MedicationRefillUid
WHERE
olddata.MedicationRefillUid IS NULL
GO
DROP TABLE migtemp_ListMedicationRefill
GO
ALTER TABLE ListMedicationRoute NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListMedicationRoute AS newdata
INNER JOIN ListMedicationRoute AS olddata ON
newdata.MedicationRouteUid = olddata.MedicationRouteUid
GO
INSERT ListMedicationRoute
SELECT newdata.*
FROM migtemp_ListMedicationRoute AS newdata
LEFT JOIN ListMedicationRoute AS olddata ON
newdata.MedicationRouteUid = olddata.MedicationRouteUid
WHERE
olddata.MedicationRouteUid IS NULL
GO
DROP TABLE migtemp_ListMedicationRoute
GO
ALTER TABLE ListMedicationSite NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListMedicationSite AS newdata
INNER JOIN ListMedicationSite AS olddata ON
newdata.MedicationSiteUid = olddata.MedicationSiteUid
GO
INSERT ListMedicationSite
SELECT newdata.*
FROM migtemp_ListMedicationSite AS newdata
LEFT JOIN ListMedicationSite AS olddata ON
newdata.MedicationSiteUid = olddata.MedicationSiteUid
WHERE
olddata.MedicationSiteUid IS NULL
GO
DROP TABLE migtemp_ListMedicationSite
GO
ALTER TABLE ListMedicationUnit NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListMedicationUnit AS newdata
INNER JOIN ListMedicationUnit AS olddata ON
newdata.MedicationUnitUid = olddata.MedicationUnitUid
GO
INSERT ListMedicationUnit
SELECT newdata.*
FROM migtemp_ListMedicationUnit AS newdata
LEFT JOIN ListMedicationUnit AS olddata ON
newdata.MedicationUnitUid = olddata.MedicationUnitUid
WHERE
olddata.MedicationUnitUid IS NULL
GO
DROP TABLE migtemp_ListMedicationUnit
GO
ALTER TABLE ListMessageRouting NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListMessageRouting AS newdata
INNER JOIN ListMessageRouting AS olddata ON
newdata.MessageRoutingUid = olddata.MessageRoutingUid
GO
INSERT ListMessageRouting
SELECT newdata.*
FROM migtemp_ListMessageRouting AS newdata
LEFT JOIN ListMessageRouting AS olddata ON
newdata.MessageRoutingUid = olddata.MessageRoutingUid
WHERE
olddata.MessageRoutingUid IS NULL
GO
DROP TABLE migtemp_ListMessageRouting
GO
ALTER TABLE ListMessageStatus NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListMessageStatus AS newdata
INNER JOIN ListMessageStatus AS olddata ON
newdata.MessageStatusUid = olddata.MessageStatusUid
GO
INSERT ListMessageStatus
SELECT newdata.*
FROM migtemp_ListMessageStatus AS newdata
LEFT JOIN ListMessageStatus AS olddata ON
newdata.MessageStatusUid = olddata.MessageStatusUid
WHERE
olddata.MessageStatusUid IS NULL
GO
DROP TABLE migtemp_ListMessageStatus
GO
ALTER TABLE ListMessageSubType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[MessageTypeUid] = newdata.[MessageTypeUid]
, olddata.[ConfigurationXML] = newdata.[ConfigurationXML]
FROM migtemp_ListMessageSubType AS newdata
INNER JOIN ListMessageSubType AS olddata ON
newdata.MessageSubTypeUid = olddata.MessageSubTypeUid
GO
INSERT ListMessageSubType
SELECT newdata.*
FROM migtemp_ListMessageSubType AS newdata
LEFT JOIN ListMessageSubType AS olddata ON
newdata.MessageSubTypeUid = olddata.MessageSubTypeUid
WHERE
olddata.MessageSubTypeUid IS NULL
GO
DROP TABLE migtemp_ListMessageSubType
GO
ALTER TABLE ListMessageType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[OrderActionTemplateXml] = newdata.[OrderActionTemplateXml]
, olddata.[HeaderAQN] = newdata.[HeaderAQN]
, olddata.[TabPagesAQN] = newdata.[TabPagesAQN]
, olddata.[AQN] = newdata.[AQN]
, olddata.[LoadStoredProcedure] = newdata.[LoadStoredProcedure]
, olddata.[UserCreatable] = newdata.[UserCreatable]
, olddata.[PatientNewMenu] = newdata.[PatientNewMenu]
, olddata.[IconIndex] = newdata.[IconIndex]
, olddata.[DisplayOrder] = newdata.[DisplayOrder]
, olddata.[CompleteInMinutes] = newdata.[CompleteInMinutes]
, olddata.[AssemblyQualifiedName] = newdata.[AssemblyQualifiedName]
, olddata.[Notes] = newdata.[Notes]
, olddata.[Color] = newdata.[Color]
, olddata.[ConfigurationXML] = newdata.[ConfigurationXML]
FROM migtemp_ListMessageType AS newdata
INNER JOIN ListMessageType AS olddata ON
newdata.MessageTypeUid = olddata.MessageTypeUid
GO
INSERT ListMessageType
SELECT newdata.*
FROM migtemp_ListMessageType AS newdata
LEFT JOIN ListMessageType AS olddata ON
newdata.MessageTypeUid = olddata.MessageTypeUid
WHERE
olddata.MessageTypeUid IS NULL
GO
DROP TABLE migtemp_ListMessageType
GO
ALTER TABLE ListMessageUrgency NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListMessageUrgency AS newdata
INNER JOIN ListMessageUrgency AS olddata ON
newdata.MessageUrgencyUid = olddata.MessageUrgencyUid
GO
INSERT ListMessageUrgency
SELECT newdata.*
FROM migtemp_ListMessageUrgency AS newdata
LEFT JOIN ListMessageUrgency AS olddata ON
newdata.MessageUrgencyUid = olddata.MessageUrgencyUid
WHERE
olddata.MessageUrgencyUid IS NULL
GO
DROP TABLE migtemp_ListMessageUrgency
GO
ALTER TABLE ListMisc NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[Val] = newdata.[Val]
, olddata.[DisplayOrder] = newdata.[DisplayOrder]
, olddata.[ListType] = newdata.[ListType]
FROM migtemp_ListMisc AS newdata
INNER JOIN ListMisc AS olddata ON
newdata.MiscUid = olddata.MiscUid
GO
INSERT ListMisc
SELECT newdata.*
FROM migtemp_ListMisc AS newdata
LEFT JOIN ListMisc AS olddata ON
newdata.MiscUid = olddata.MiscUid
WHERE
olddata.MiscUid IS NULL
GO
DROP TABLE migtemp_ListMisc
GO
ALTER TABLE ListNameFormat NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[NameFormat] = newdata.[NameFormat]
, olddata.[TemplateProperties] = newdata.[TemplateProperties]
, olddata.[ValidationType] = newdata.[ValidationType]
FROM migtemp_ListNameFormat AS newdata
INNER JOIN ListNameFormat AS olddata ON
newdata.NameFormatUid = olddata.NameFormatUid
GO
INSERT ListNameFormat
SELECT newdata.*
FROM migtemp_ListNameFormat AS newdata
LEFT JOIN ListNameFormat AS olddata ON
newdata.NameFormatUid = olddata.NameFormatUid
WHERE
olddata.NameFormatUid IS NULL
GO
DROP TABLE migtemp_ListNameFormat
GO
ALTER TABLE ListNameFormatType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[TypeProperties] = newdata.[TypeProperties]
, olddata.[BusinessObject] = newdata.[BusinessObject]
FROM migtemp_ListNameFormatType AS newdata
INNER JOIN ListNameFormatType AS olddata ON
newdata.NameFormatTypeUid = olddata.NameFormatTypeUid
GO
INSERT ListNameFormatType
SELECT newdata.*
FROM migtemp_ListNameFormatType AS newdata
LEFT JOIN ListNameFormatType AS olddata ON
newdata.NameFormatTypeUid = olddata.NameFormatTypeUid
WHERE
olddata.NameFormatTypeUid IS NULL
GO
DROP TABLE migtemp_ListNameFormatType
GO
ALTER TABLE ListNCPDPReasonCode NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListNCPDPReasonCode AS newdata
INNER JOIN ListNCPDPReasonCode AS olddata ON
newdata.NCPDPReasonCodeUid = olddata.NCPDPReasonCodeUid
GO
INSERT ListNCPDPReasonCode
SELECT newdata.*
FROM migtemp_ListNCPDPReasonCode AS newdata
LEFT JOIN ListNCPDPReasonCode AS olddata ON
newdata.NCPDPReasonCodeUid = olddata.NCPDPReasonCodeUid
WHERE
olddata.NCPDPReasonCodeUid IS NULL
GO
DROP TABLE migtemp_ListNCPDPReasonCode
GO
ALTER TABLE ListNDCUnitMeasure NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListNDCUnitMeasure AS newdata
INNER JOIN ListNDCUnitMeasure AS olddata ON
newdata.NDCUnitMeasureUid = olddata.NDCUnitMeasureUid
GO
INSERT ListNDCUnitMeasure
SELECT newdata.*
FROM migtemp_ListNDCUnitMeasure AS newdata
LEFT JOIN ListNDCUnitMeasure AS olddata ON
newdata.NDCUnitMeasureUid = olddata.NDCUnitMeasureUid
WHERE
olddata.NDCUnitMeasureUid IS NULL
GO
DROP TABLE migtemp_ListNDCUnitMeasure
GO
ALTER TABLE ListNegationReason NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListNegationReason AS newdata
INNER JOIN ListNegationReason AS olddata ON
newdata.NegationReasonUid = olddata.NegationReasonUid
GO
INSERT ListNegationReason
SELECT newdata.*
FROM migtemp_ListNegationReason AS newdata
LEFT JOIN ListNegationReason AS olddata ON
newdata.NegationReasonUid = olddata.NegationReasonUid
WHERE
olddata.NegationReasonUid IS NULL
GO
DROP TABLE migtemp_ListNegationReason
GO
ALTER TABLE ListNoteFilter NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListNoteFilter AS newdata
INNER JOIN ListNoteFilter AS olddata ON
newdata.NoteFilterUid = olddata.NoteFilterUid
GO
INSERT ListNoteFilter
SELECT newdata.*
FROM migtemp_ListNoteFilter AS newdata
LEFT JOIN ListNoteFilter AS olddata ON
newdata.NoteFilterUid = olddata.NoteFilterUid
WHERE
olddata.NoteFilterUid IS NULL
GO
DROP TABLE migtemp_ListNoteFilter
GO
ALTER TABLE ListNotificationMethod NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListNotificationMethod AS newdata
INNER JOIN ListNotificationMethod AS olddata ON
newdata.NotificationMethodUid = olddata.NotificationMethodUid
GO
INSERT ListNotificationMethod
SELECT newdata.*
FROM migtemp_ListNotificationMethod AS newdata
LEFT JOIN ListNotificationMethod AS olddata ON
newdata.NotificationMethodUid = olddata.NotificationMethodUid
WHERE
olddata.NotificationMethodUid IS NULL
GO
DROP TABLE migtemp_ListNotificationMethod
GO
ALTER TABLE ListObservation NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[LicenseCode] = newdata.[LicenseCode]
FROM migtemp_ListObservation AS newdata
INNER JOIN ListObservation AS olddata ON
newdata.ObservationUid = olddata.ObservationUid
GO
INSERT ListObservation
SELECT newdata.*
FROM migtemp_ListObservation AS newdata
LEFT JOIN ListObservation AS olddata ON
newdata.ObservationUid = olddata.ObservationUid
WHERE
olddata.ObservationUid IS NULL
GO
DROP TABLE migtemp_ListObservation
GO
ALTER TABLE ListObservationCustomUser NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListObservationCustomUser AS newdata
INNER JOIN ListObservationCustomUser AS olddata ON
newdata.ObservationCustomUserUid = olddata.ObservationCustomUserUid
GO
INSERT ListObservationCustomUser
SELECT newdata.*
FROM migtemp_ListObservationCustomUser AS newdata
LEFT JOIN ListObservationCustomUser AS olddata ON
newdata.ObservationCustomUserUid = olddata.ObservationCustomUserUid
WHERE
olddata.ObservationCustomUserUid IS NULL
GO
DROP TABLE migtemp_ListObservationCustomUser
GO
ALTER TABLE ListObservationGroup NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListObservationGroup AS newdata
INNER JOIN ListObservationGroup AS olddata ON
newdata.ObservationGroupUid = olddata.ObservationGroupUid
GO
INSERT ListObservationGroup
SELECT newdata.*
FROM migtemp_ListObservationGroup AS newdata
LEFT JOIN ListObservationGroup AS olddata ON
newdata.ObservationGroupUid = olddata.ObservationGroupUid
WHERE
olddata.ObservationGroupUid IS NULL
GO
DROP TABLE migtemp_ListObservationGroup
GO
ALTER TABLE ListObservationItem NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListObservationItem AS newdata
INNER JOIN ListObservationItem AS olddata ON
newdata.ObservationItemUid = olddata.ObservationItemUid
GO
INSERT ListObservationItem
SELECT newdata.*
FROM migtemp_ListObservationItem AS newdata
LEFT JOIN ListObservationItem AS olddata ON
newdata.ObservationItemUid = olddata.ObservationItemUid
WHERE
olddata.ObservationItemUid IS NULL
GO
DROP TABLE migtemp_ListObservationItem
GO
ALTER TABLE ListObservationOrderResultStatus NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListObservationOrderResultStatus AS newdata
INNER JOIN ListObservationOrderResultStatus AS olddata ON
newdata.ObservationOrderResultStatusUid = olddata.ObservationOrderResultStatusUid
GO
INSERT ListObservationOrderResultStatus
SELECT newdata.*
FROM migtemp_ListObservationOrderResultStatus AS newdata
LEFT JOIN ListObservationOrderResultStatus AS olddata ON
newdata.ObservationOrderResultStatusUid = olddata.ObservationOrderResultStatusUid
WHERE
olddata.ObservationOrderResultStatusUid IS NULL
GO
DROP TABLE migtemp_ListObservationOrderResultStatus
GO
ALTER TABLE ListOccupation NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListOccupation AS newdata
INNER JOIN ListOccupation AS olddata ON
newdata.OccupationUid = olddata.OccupationUid
GO
INSERT ListOccupation
SELECT newdata.*
FROM migtemp_ListOccupation AS newdata
LEFT JOIN ListOccupation AS olddata ON
newdata.OccupationUid = olddata.OccupationUid
WHERE
olddata.OccupationUid IS NULL
GO
DROP TABLE migtemp_ListOccupation
GO
ALTER TABLE ListOccurrenceCode NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListOccurrenceCode AS newdata
INNER JOIN ListOccurrenceCode AS olddata ON
newdata.OccurrenceCodeUid = olddata.OccurrenceCodeUid
GO
INSERT ListOccurrenceCode
SELECT newdata.*
FROM migtemp_ListOccurrenceCode AS newdata
LEFT JOIN ListOccurrenceCode AS olddata ON
newdata.OccurrenceCodeUid = olddata.OccurrenceCodeUid
WHERE
olddata.OccurrenceCodeUid IS NULL
GO
DROP TABLE migtemp_ListOccurrenceCode
GO
ALTER TABLE ListPaperworkTransmissionCode NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListPaperworkTransmissionCode AS newdata
INNER JOIN ListPaperworkTransmissionCode AS olddata ON
newdata.PaperworkTransmissionCodeUid = olddata.PaperworkTransmissionCodeUid
GO
INSERT ListPaperworkTransmissionCode
SELECT newdata.*
FROM migtemp_ListPaperworkTransmissionCode AS newdata
LEFT JOIN ListPaperworkTransmissionCode AS olddata ON
newdata.PaperworkTransmissionCodeUid = olddata.PaperworkTransmissionCodeUid
WHERE
olddata.PaperworkTransmissionCodeUid IS NULL
GO
DROP TABLE migtemp_ListPaperworkTransmissionCode
GO
ALTER TABLE ListPaperworkType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListPaperworkType AS newdata
INNER JOIN ListPaperworkType AS olddata ON
newdata.PaperworkTypeUid = olddata.PaperworkTypeUid
GO
INSERT ListPaperworkType
SELECT newdata.*
FROM migtemp_ListPaperworkType AS newdata
LEFT JOIN ListPaperworkType AS olddata ON
newdata.PaperworkTypeUid = olddata.PaperworkTypeUid
WHERE
olddata.PaperworkTypeUid IS NULL
GO
DROP TABLE migtemp_ListPaperworkType
GO
ALTER TABLE ListPatientCareManagementStatus NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListPatientCareManagementStatus AS newdata
INNER JOIN ListPatientCareManagementStatus AS olddata ON
newdata.PatientCareManagementStatusUid = olddata.PatientCareManagementStatusUid
GO
INSERT ListPatientCareManagementStatus
SELECT newdata.*
FROM migtemp_ListPatientCareManagementStatus AS newdata
LEFT JOIN ListPatientCareManagementStatus AS olddata ON
newdata.PatientCareManagementStatusUid = olddata.PatientCareManagementStatusUid
WHERE
olddata.PatientCareManagementStatusUid IS NULL
GO
DROP TABLE migtemp_ListPatientCareManagementStatus
GO
ALTER TABLE ListPatientClass NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListPatientClass AS newdata
INNER JOIN ListPatientClass AS olddata ON
newdata.PatientClassUid = olddata.PatientClassUid
GO
INSERT ListPatientClass
SELECT newdata.*
FROM migtemp_ListPatientClass AS newdata
LEFT JOIN ListPatientClass AS olddata ON
newdata.PatientClassUid = olddata.PatientClassUid
WHERE
olddata.PatientClassUid IS NULL
GO
DROP TABLE migtemp_ListPatientClass
GO
ALTER TABLE ListPatientCommunicationType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListPatientCommunicationType AS newdata
INNER JOIN ListPatientCommunicationType AS olddata ON
newdata.PatientCommunicationTypeUid = olddata.PatientCommunicationTypeUid
GO
INSERT ListPatientCommunicationType
SELECT newdata.*
FROM migtemp_ListPatientCommunicationType AS newdata
LEFT JOIN ListPatientCommunicationType AS olddata ON
newdata.PatientCommunicationTypeUid = olddata.PatientCommunicationTypeUid
WHERE
olddata.PatientCommunicationTypeUid IS NULL
GO
DROP TABLE migtemp_ListPatientCommunicationType
GO
ALTER TABLE ListPatientDashboard NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListPatientDashboard AS newdata
INNER JOIN ListPatientDashboard AS olddata ON
newdata.PatientDashboardUid = olddata.PatientDashboardUid
GO
INSERT ListPatientDashboard
SELECT newdata.*
FROM migtemp_ListPatientDashboard AS newdata
LEFT JOIN ListPatientDashboard AS olddata ON
newdata.PatientDashboardUid = olddata.PatientDashboardUid
WHERE
olddata.PatientDashboardUid IS NULL
GO
DROP TABLE migtemp_ListPatientDashboard
GO
ALTER TABLE ListPatientStatus NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListPatientStatus AS newdata
INNER JOIN ListPatientStatus AS olddata ON
newdata.PatientStatusUid = olddata.PatientStatusUid
GO
INSERT ListPatientStatus
SELECT newdata.*
FROM migtemp_ListPatientStatus AS newdata
LEFT JOIN ListPatientStatus AS olddata ON
newdata.PatientStatusUid = olddata.PatientStatusUid
WHERE
olddata.PatientStatusUid IS NULL
GO
DROP TABLE migtemp_ListPatientStatus
GO
ALTER TABLE ListPatientStatusUB NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListPatientStatusUB AS newdata
INNER JOIN ListPatientStatusUB AS olddata ON
newdata.PatientStatusUBUid = olddata.PatientStatusUBUid
GO
INSERT ListPatientStatusUB
SELECT newdata.*
FROM migtemp_ListPatientStatusUB AS newdata
LEFT JOIN ListPatientStatusUB AS olddata ON
newdata.PatientStatusUBUid = olddata.PatientStatusUBUid
WHERE
olddata.PatientStatusUBUid IS NULL
GO
DROP TABLE migtemp_ListPatientStatusUB
GO
ALTER TABLE ListPatientTrackingEventType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListPatientTrackingEventType AS newdata
INNER JOIN ListPatientTrackingEventType AS olddata ON
newdata.PatientTrackingEventTypeUid = olddata.PatientTrackingEventTypeUid
GO
INSERT ListPatientTrackingEventType
SELECT newdata.*
FROM migtemp_ListPatientTrackingEventType AS newdata
LEFT JOIN ListPatientTrackingEventType AS olddata ON
newdata.PatientTrackingEventTypeUid = olddata.PatientTrackingEventTypeUid
WHERE
olddata.PatientTrackingEventTypeUid IS NULL
GO
DROP TABLE migtemp_ListPatientTrackingEventType
GO
ALTER TABLE ListPayerCreditRefundStatus NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListPayerCreditRefundStatus AS newdata
INNER JOIN ListPayerCreditRefundStatus AS olddata ON
newdata.PayerCreditRefundStatusUid = olddata.PayerCreditRefundStatusUid
GO
INSERT ListPayerCreditRefundStatus
SELECT newdata.*
FROM migtemp_ListPayerCreditRefundStatus AS newdata
LEFT JOIN ListPayerCreditRefundStatus AS olddata ON
newdata.PayerCreditRefundStatusUid = olddata.PayerCreditRefundStatusUid
WHERE
olddata.PayerCreditRefundStatusUid IS NULL
GO
DROP TABLE migtemp_ListPayerCreditRefundStatus
GO
ALTER TABLE ListPayerTypologySource NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListPayerTypologySource AS newdata
INNER JOIN ListPayerTypologySource AS olddata ON
newdata.PayerTypologySourceUid = olddata.PayerTypologySourceUid
GO
INSERT ListPayerTypologySource
SELECT newdata.*
FROM migtemp_ListPayerTypologySource AS newdata
LEFT JOIN ListPayerTypologySource AS olddata ON
newdata.PayerTypologySourceUid = olddata.PayerTypologySourceUid
WHERE
olddata.PayerTypologySourceUid IS NULL
GO
DROP TABLE migtemp_ListPayerTypologySource
GO
ALTER TABLE ListPaymentType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListPaymentType AS newdata
INNER JOIN ListPaymentType AS olddata ON
newdata.PaymentTypeUid = olddata.PaymentTypeUid
GO
INSERT ListPaymentType
SELECT newdata.*
FROM migtemp_ListPaymentType AS newdata
LEFT JOIN ListPaymentType AS olddata ON
newdata.PaymentTypeUid = olddata.PaymentTypeUid
WHERE
olddata.PaymentTypeUid IS NULL
GO
DROP TABLE migtemp_ListPaymentType
GO
ALTER TABLE ListPEDescription NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListPEDescription AS newdata
INNER JOIN ListPEDescription AS olddata ON
newdata.PEDescriptionUid = olddata.PEDescriptionUid
GO
INSERT ListPEDescription
SELECT newdata.*
FROM migtemp_ListPEDescription AS newdata
LEFT JOIN ListPEDescription AS olddata ON
newdata.PEDescriptionUid = olddata.PEDescriptionUid
WHERE
olddata.PEDescriptionUid IS NULL
GO
DROP TABLE migtemp_ListPEDescription
GO
ALTER TABLE ListPEParentSystem NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListPEParentSystem AS newdata
INNER JOIN ListPEParentSystem AS olddata ON
newdata.PEParentSystemUid = olddata.PEParentSystemUid
GO
INSERT ListPEParentSystem
SELECT newdata.*
FROM migtemp_ListPEParentSystem AS newdata
LEFT JOIN ListPEParentSystem AS olddata ON
newdata.PEParentSystemUid = olddata.PEParentSystemUid
WHERE
olddata.PEParentSystemUid IS NULL
GO
DROP TABLE migtemp_ListPEParentSystem
GO
ALTER TABLE ListPESymptom NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListPESymptom AS newdata
INNER JOIN ListPESymptom AS olddata ON
newdata.PESymptomUid = olddata.PESymptomUid
GO
INSERT ListPESymptom
SELECT newdata.*
FROM migtemp_ListPESymptom AS newdata
LEFT JOIN ListPESymptom AS olddata ON
newdata.PESymptomUid = olddata.PESymptomUid
WHERE
olddata.PESymptomUid IS NULL
GO
DROP TABLE migtemp_ListPESymptom
GO
ALTER TABLE ListPESystem NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListPESystem AS newdata
INNER JOIN ListPESystem AS olddata ON
newdata.PESystemUid = olddata.PESystemUid
GO
INSERT ListPESystem
SELECT newdata.*
FROM migtemp_ListPESystem AS newdata
LEFT JOIN ListPESystem AS olddata ON
newdata.PESystemUid = olddata.PESystemUid
WHERE
olddata.PESystemUid IS NULL
GO
DROP TABLE migtemp_ListPESystem
GO
ALTER TABLE ListPETemplate NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[LicenseCode] = newdata.[LicenseCode]
, olddata.[EMExaminationDescriptionUid] = newdata.[EMExaminationDescriptionUid]
FROM migtemp_ListPETemplate AS newdata
INNER JOIN ListPETemplate AS olddata ON
newdata.PETemplateUid = olddata.PETemplateUid
GO
INSERT ListPETemplate
SELECT newdata.*
FROM migtemp_ListPETemplate AS newdata
LEFT JOIN ListPETemplate AS olddata ON
newdata.PETemplateUid = olddata.PETemplateUid
WHERE
olddata.PETemplateUid IS NULL
GO
DROP TABLE migtemp_ListPETemplate
GO
ALTER TABLE ListPharmacyClearinghouse NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListPharmacyClearinghouse AS newdata
INNER JOIN ListPharmacyClearinghouse AS olddata ON
newdata.PharmacyClearinghouseUid = olddata.PharmacyClearinghouseUid
GO
INSERT ListPharmacyClearinghouse
SELECT newdata.*
FROM migtemp_ListPharmacyClearinghouse AS newdata
LEFT JOIN ListPharmacyClearinghouse AS olddata ON
newdata.PharmacyClearinghouseUid = olddata.PharmacyClearinghouseUid
WHERE
olddata.PharmacyClearinghouseUid IS NULL
GO
DROP TABLE migtemp_ListPharmacyClearinghouse
GO
ALTER TABLE ListPhoneType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListPhoneType AS newdata
INNER JOIN ListPhoneType AS olddata ON
newdata.PhoneTypeUid = olddata.PhoneTypeUid
GO
INSERT ListPhoneType
SELECT newdata.*
FROM migtemp_ListPhoneType AS newdata
LEFT JOIN ListPhoneType AS olddata ON
newdata.PhoneTypeUid = olddata.PhoneTypeUid
WHERE
olddata.PhoneTypeUid IS NULL
GO
DROP TABLE migtemp_ListPhoneType
GO
ALTER TABLE ListPlanPrnCondition NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListPlanPrnCondition AS newdata
INNER JOIN ListPlanPrnCondition AS olddata ON
newdata.PlanPrnConditionUid = olddata.PlanPrnConditionUid
GO
INSERT ListPlanPrnCondition
SELECT newdata.*
FROM migtemp_ListPlanPrnCondition AS newdata
LEFT JOIN ListPlanPrnCondition AS olddata ON
newdata.PlanPrnConditionUid = olddata.PlanPrnConditionUid
WHERE
olddata.PlanPrnConditionUid IS NULL
GO
DROP TABLE migtemp_ListPlanPrnCondition
GO
ALTER TABLE ListPlanSymptomCondition NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListPlanSymptomCondition AS newdata
INNER JOIN ListPlanSymptomCondition AS olddata ON
newdata.PlanSymptomConditionUid = olddata.PlanSymptomConditionUid
GO
INSERT ListPlanSymptomCondition
SELECT newdata.*
FROM migtemp_ListPlanSymptomCondition AS newdata
LEFT JOIN ListPlanSymptomCondition AS olddata ON
newdata.PlanSymptomConditionUid = olddata.PlanSymptomConditionUid
WHERE
olddata.PlanSymptomConditionUid IS NULL
GO
DROP TABLE migtemp_ListPlanSymptomCondition
GO
ALTER TABLE ListPQRIDiseaseGroup NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListPQRIDiseaseGroup AS newdata
INNER JOIN ListPQRIDiseaseGroup AS olddata ON
newdata.PQRIDiseaseGroupUid = olddata.PQRIDiseaseGroupUid
GO
INSERT ListPQRIDiseaseGroup
SELECT newdata.*
FROM migtemp_ListPQRIDiseaseGroup AS newdata
LEFT JOIN ListPQRIDiseaseGroup AS olddata ON
newdata.PQRIDiseaseGroupUid = olddata.PQRIDiseaseGroupUid
WHERE
olddata.PQRIDiseaseGroupUid IS NULL
GO
DROP TABLE migtemp_ListPQRIDiseaseGroup
GO
ALTER TABLE ListPQRIGroup NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[ExternalID] = newdata.[ExternalID]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[Name] = newdata.[Name]
, olddata.[LastModifiedByUid] = newdata.[LastModifiedByUid]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[UserDefined] = newdata.[UserDefined]
FROM migtemp_ListPQRIGroup AS newdata
INNER JOIN ListPQRIGroup AS olddata ON
newdata.PQRIGroupUid = olddata.PQRIGroupUid
GO
INSERT ListPQRIGroup
SELECT newdata.*
FROM migtemp_ListPQRIGroup AS newdata
LEFT JOIN ListPQRIGroup AS olddata ON
newdata.PQRIGroupUid = olddata.PQRIGroupUid
WHERE
olddata.PQRIGroupUid IS NULL
GO
DROP TABLE migtemp_ListPQRIGroup
GO
ALTER TABLE ListPQRIMeasure NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[AgeFrom] = newdata.[AgeFrom]
, olddata.[AgeFromIsMonth] = newdata.[AgeFromIsMonth]
, olddata.[AgeTo] = newdata.[AgeTo]
, olddata.[AgeToIsMonth] = newdata.[AgeToIsMonth]
, olddata.[RecurrenceInterval] = newdata.[RecurrenceInterval]
, olddata.[PQRIDiseaseGroupUid] = newdata.[PQRIDiseaseGroupUid]
, olddata.[RecurTimeTypeUid] = newdata.[RecurTimeTypeUid]
, olddata.[EffectiveDate] = newdata.[EffectiveDate]
, olddata.[ExpirationDate] = newdata.[ExpirationDate]
FROM migtemp_ListPQRIMeasure AS newdata
INNER JOIN ListPQRIMeasure AS olddata ON
newdata.PQRIMeasureUid = olddata.PQRIMeasureUid
GO
INSERT ListPQRIMeasure
SELECT newdata.*
FROM migtemp_ListPQRIMeasure AS newdata
LEFT JOIN ListPQRIMeasure AS olddata ON
newdata.PQRIMeasureUid = olddata.PQRIMeasureUid
WHERE
olddata.PQRIMeasureUid IS NULL
GO
DROP TABLE migtemp_ListPQRIMeasure
GO
ALTER TABLE ListPrmAction NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListPrmAction AS newdata
INNER JOIN ListPrmAction AS olddata ON
newdata.PrmActionUid = olddata.PrmActionUid
GO
INSERT ListPrmAction
SELECT newdata.*
FROM migtemp_ListPrmAction AS newdata
LEFT JOIN ListPrmAction AS olddata ON
newdata.PrmActionUid = olddata.PrmActionUid
WHERE
olddata.PrmActionUid IS NULL
GO
DROP TABLE migtemp_ListPrmAction
GO
ALTER TABLE ListPrmCondition NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListPrmCondition AS newdata
INNER JOIN ListPrmCondition AS olddata ON
newdata.PrmConditionUid = olddata.PrmConditionUid
GO
INSERT ListPrmCondition
SELECT newdata.*
FROM migtemp_ListPrmCondition AS newdata
LEFT JOIN ListPrmCondition AS olddata ON
newdata.PrmConditionUid = olddata.PrmConditionUid
WHERE
olddata.PrmConditionUid IS NULL
GO
DROP TABLE migtemp_ListPrmCondition
GO
ALTER TABLE ListPrmRule NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListPrmRule AS newdata
INNER JOIN ListPrmRule AS olddata ON
newdata.PrmRuleUid = olddata.PrmRuleUid
GO
INSERT ListPrmRule
SELECT newdata.*
FROM migtemp_ListPrmRule AS newdata
LEFT JOIN ListPrmRule AS olddata ON
newdata.PrmRuleUid = olddata.PrmRuleUid
WHERE
olddata.PrmRuleUid IS NULL
GO
DROP TABLE migtemp_ListPrmRule
GO
ALTER TABLE ListPrmRuleGroup NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListPrmRuleGroup AS newdata
INNER JOIN ListPrmRuleGroup AS olddata ON
newdata.PrmRuleGroupUid = olddata.PrmRuleGroupUid
GO
INSERT ListPrmRuleGroup
SELECT newdata.*
FROM migtemp_ListPrmRuleGroup AS newdata
LEFT JOIN ListPrmRuleGroup AS olddata ON
newdata.PrmRuleGroupUid = olddata.PrmRuleGroupUid
WHERE
olddata.PrmRuleGroupUid IS NULL
GO
DROP TABLE migtemp_ListPrmRuleGroup
GO
ALTER TABLE ListPrmRuleLevel NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListPrmRuleLevel AS newdata
INNER JOIN ListPrmRuleLevel AS olddata ON
newdata.PrmRuleLevelUid = olddata.PrmRuleLevelUid
GO
INSERT ListPrmRuleLevel
SELECT newdata.*
FROM migtemp_ListPrmRuleLevel AS newdata
LEFT JOIN ListPrmRuleLevel AS olddata ON
newdata.PrmRuleLevelUid = olddata.PrmRuleLevelUid
WHERE
olddata.PrmRuleLevelUid IS NULL
GO
DROP TABLE migtemp_ListPrmRuleLevel
GO
ALTER TABLE ListProblemStatus NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListProblemStatus AS newdata
INNER JOIN ListProblemStatus AS olddata ON
newdata.ProblemStatusUid = olddata.ProblemStatusUid
GO
INSERT ListProblemStatus
SELECT newdata.*
FROM migtemp_ListProblemStatus AS newdata
LEFT JOIN ListProblemStatus AS olddata ON
newdata.ProblemStatusUid = olddata.ProblemStatusUid
WHERE
olddata.ProblemStatusUid IS NULL
GO
DROP TABLE migtemp_ListProblemStatus
GO
ALTER TABLE ListProcedure NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListProcedure AS newdata
INNER JOIN ListProcedure AS olddata ON
newdata.ProcedureUid = olddata.ProcedureUid
GO
INSERT ListProcedure
SELECT newdata.*
FROM migtemp_ListProcedure AS newdata
LEFT JOIN ListProcedure AS olddata ON
newdata.ProcedureUid = olddata.ProcedureUid
WHERE
olddata.ProcedureUid IS NULL
GO
DROP TABLE migtemp_ListProcedure
GO
ALTER TABLE ListProcedureCategory NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListProcedureCategory AS newdata
INNER JOIN ListProcedureCategory AS olddata ON
newdata.ProcedureCategoryUid = olddata.ProcedureCategoryUid
GO
INSERT ListProcedureCategory
SELECT newdata.*
FROM migtemp_ListProcedureCategory AS newdata
LEFT JOIN ListProcedureCategory AS olddata ON
newdata.ProcedureCategoryUid = olddata.ProcedureCategoryUid
WHERE
olddata.ProcedureCategoryUid IS NULL
GO
DROP TABLE migtemp_ListProcedureCategory
GO
ALTER TABLE ListProcedureCodeType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListProcedureCodeType AS newdata
INNER JOIN ListProcedureCodeType AS olddata ON
newdata.ProcedureCodeTypeUid = olddata.ProcedureCodeTypeUid
GO
INSERT ListProcedureCodeType
SELECT newdata.*
FROM migtemp_ListProcedureCodeType AS newdata
LEFT JOIN ListProcedureCodeType AS olddata ON
newdata.ProcedureCodeTypeUid = olddata.ProcedureCodeTypeUid
WHERE
olddata.ProcedureCodeTypeUid IS NULL
GO
DROP TABLE migtemp_ListProcedureCodeType
GO
ALTER TABLE ListProcedureHistoryStatus NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListProcedureHistoryStatus AS newdata
INNER JOIN ListProcedureHistoryStatus AS olddata ON
newdata.ProcedureHistoryStatusUid = olddata.ProcedureHistoryStatusUid
GO
INSERT ListProcedureHistoryStatus
SELECT newdata.*
FROM migtemp_ListProcedureHistoryStatus AS newdata
LEFT JOIN ListProcedureHistoryStatus AS olddata ON
newdata.ProcedureHistoryStatusUid = olddata.ProcedureHistoryStatusUid
WHERE
olddata.ProcedureHistoryStatusUid IS NULL
GO
DROP TABLE migtemp_ListProcedureHistoryStatus
GO
ALTER TABLE ListProcedureHistoryTerm NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListProcedureHistoryTerm AS newdata
INNER JOIN ListProcedureHistoryTerm AS olddata ON
newdata.ProcedureHistoryTermUid = olddata.ProcedureHistoryTermUid
GO
INSERT ListProcedureHistoryTerm
SELECT newdata.*
FROM migtemp_ListProcedureHistoryTerm AS newdata
LEFT JOIN ListProcedureHistoryTerm AS olddata ON
newdata.ProcedureHistoryTermUid = olddata.ProcedureHistoryTermUid
WHERE
olddata.ProcedureHistoryTermUid IS NULL
GO
DROP TABLE migtemp_ListProcedureHistoryTerm
GO
ALTER TABLE ListProcedureModifier NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListProcedureModifier AS newdata
INNER JOIN ListProcedureModifier AS olddata ON
newdata.ProcedureModifierUid = olddata.ProcedureModifierUid
GO
INSERT ListProcedureModifier
SELECT newdata.*
FROM migtemp_ListProcedureModifier AS newdata
LEFT JOIN ListProcedureModifier AS olddata ON
newdata.ProcedureModifierUid = olddata.ProcedureModifierUid
WHERE
olddata.ProcedureModifierUid IS NULL
GO
DROP TABLE migtemp_ListProcedureModifier
GO
ALTER TABLE ListProcedurePanel NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListProcedurePanel AS newdata
INNER JOIN ListProcedurePanel AS olddata ON
newdata.ProcedurePanelUid = olddata.ProcedurePanelUid
GO
INSERT ListProcedurePanel
SELECT newdata.*
FROM migtemp_ListProcedurePanel AS newdata
LEFT JOIN ListProcedurePanel AS olddata ON
newdata.ProcedurePanelUid = olddata.ProcedurePanelUid
WHERE
olddata.ProcedurePanelUid IS NULL
GO
DROP TABLE migtemp_ListProcedurePanel
GO
ALTER TABLE ListProcedureServiceType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListProcedureServiceType AS newdata
INNER JOIN ListProcedureServiceType AS olddata ON
newdata.ProcedureServiceTypeUid = olddata.ProcedureServiceTypeUid
GO
INSERT ListProcedureServiceType
SELECT newdata.*
FROM migtemp_ListProcedureServiceType AS newdata
LEFT JOIN ListProcedureServiceType AS olddata ON
newdata.ProcedureServiceTypeUid = olddata.ProcedureServiceTypeUid
WHERE
olddata.ProcedureServiceTypeUid IS NULL
GO
DROP TABLE migtemp_ListProcedureServiceType
GO
ALTER TABLE ListProductParameter NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[ParameterName] = newdata.[ParameterName]
, olddata.[StringValue] = (CASE WHEN (olddata.UserDefined = 0) THEN newdata.[StringValue] ELSE olddata.[StringValue] END)
, olddata.[GuidValue] = (CASE WHEN (olddata.UserDefined = 0) THEN newdata.[GuidValue] ELSE olddata.[GuidValue] END)
, olddata.[BoolValue] = (CASE WHEN (olddata.UserDefined = 0) THEN newdata.[BoolValue] ELSE olddata.[BoolValue] END)
, olddata.[IntegerValue] = (CASE WHEN (olddata.UserDefined = 0) THEN newdata.[IntegerValue] ELSE olddata.[IntegerValue] END)
, olddata.[DateTimeValue] = (CASE WHEN (olddata.UserDefined = 0) THEN newdata.[DateTimeValue] ELSE olddata.[DateTimeValue] END)
, olddata.[DecimalValue] = (CASE WHEN (olddata.UserDefined = 0) THEN newdata.[DecimalValue] ELSE olddata.[DecimalValue] END)
, olddata.[RealValue] = (CASE WHEN (olddata.UserDefined = 0) THEN newdata.[RealValue] ELSE olddata.[RealValue] END)
, olddata.[BinaryValue] = (CASE WHEN (olddata.UserDefined = 0) THEN newdata.[BinaryValue] ELSE olddata.[BinaryValue] END)
, olddata.[XMLValue] = (CASE WHEN (olddata.UserDefined = 0) THEN newdata.[XMLValue] ELSE olddata.[XMLValue] END)
FROM migtemp_ListProductParameter AS newdata
INNER JOIN ListProductParameter AS olddata ON
newdata.ProductParameterUid = olddata.ProductParameterUid
GO
INSERT ListProductParameter
SELECT newdata.*
FROM migtemp_ListProductParameter AS newdata
LEFT JOIN ListProductParameter AS olddata ON
newdata.ProductParameterUid = olddata.ProductParameterUid
WHERE
olddata.ProductParameterUid IS NULL
GO
DROP TABLE migtemp_ListProductParameter
GO
ALTER TABLE ListPronoun NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListPronoun AS newdata
INNER JOIN ListPronoun AS olddata ON
newdata.PronounUid = olddata.PronounUid
GO
INSERT ListPronoun
SELECT newdata.*
FROM migtemp_ListPronoun AS newdata
LEFT JOIN ListPronoun AS olddata ON
newdata.PronounUid = olddata.PronounUid
WHERE
olddata.PronounUid IS NULL
GO
DROP TABLE migtemp_ListPronoun
GO
ALTER TABLE ListProviderCareType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListProviderCareType AS newdata
INNER JOIN ListProviderCareType AS olddata ON
newdata.ProviderCareTypeUid = olddata.ProviderCareTypeUid
GO
INSERT ListProviderCareType
SELECT newdata.*
FROM migtemp_ListProviderCareType AS newdata
LEFT JOIN ListProviderCareType AS olddata ON
newdata.ProviderCareTypeUid = olddata.ProviderCareTypeUid
WHERE
olddata.ProviderCareTypeUid IS NULL
GO
DROP TABLE migtemp_ListProviderCareType
GO
ALTER TABLE ListQuestion NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListQuestion AS newdata
INNER JOIN ListQuestion AS olddata ON
newdata.QuestionUid = olddata.QuestionUid
GO
INSERT ListQuestion
SELECT newdata.*
FROM migtemp_ListQuestion AS newdata
LEFT JOIN ListQuestion AS olddata ON
newdata.QuestionUid = olddata.QuestionUid
WHERE
olddata.QuestionUid IS NULL
GO
DROP TABLE migtemp_ListQuestion
GO
ALTER TABLE ListRace NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListRace AS newdata
INNER JOIN ListRace AS olddata ON
newdata.RaceUid = olddata.RaceUid
GO
INSERT ListRace
SELECT newdata.*
FROM migtemp_ListRace AS newdata
LEFT JOIN ListRace AS olddata ON
newdata.RaceUid = olddata.RaceUid
WHERE
olddata.RaceUid IS NULL
GO
DROP TABLE migtemp_ListRace
GO
ALTER TABLE ListRecallType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListRecallType AS newdata
INNER JOIN ListRecallType AS olddata ON
newdata.RecallTypeUid = olddata.RecallTypeUid
GO
INSERT ListRecallType
SELECT newdata.*
FROM migtemp_ListRecallType AS newdata
LEFT JOIN ListRecallType AS olddata ON
newdata.RecallTypeUid = olddata.RecallTypeUid
WHERE
olddata.RecallTypeUid IS NULL
GO
DROP TABLE migtemp_ListRecallType
GO
ALTER TABLE ListReferralSrc NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListReferralSrc AS newdata
INNER JOIN ListReferralSrc AS olddata ON
newdata.ReferralSrcUid = olddata.ReferralSrcUid
GO
INSERT ListReferralSrc
SELECT newdata.*
FROM migtemp_ListReferralSrc AS newdata
LEFT JOIN ListReferralSrc AS olddata ON
newdata.ReferralSrcUid = olddata.ReferralSrcUid
WHERE
olddata.ReferralSrcUid IS NULL
GO
DROP TABLE migtemp_ListReferralSrc
GO
ALTER TABLE ListReferralTrackingStatus NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListReferralTrackingStatus AS newdata
INNER JOIN ListReferralTrackingStatus AS olddata ON
newdata.ReferralTrackingStatusUid = olddata.ReferralTrackingStatusUid
GO
INSERT ListReferralTrackingStatus
SELECT newdata.*
FROM migtemp_ListReferralTrackingStatus AS newdata
LEFT JOIN ListReferralTrackingStatus AS olddata ON
newdata.ReferralTrackingStatusUid = olddata.ReferralTrackingStatusUid
WHERE
olddata.ReferralTrackingStatusUid IS NULL
GO
DROP TABLE migtemp_ListReferralTrackingStatus
GO
ALTER TABLE ListReimbursementRule NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListReimbursementRule AS newdata
INNER JOIN ListReimbursementRule AS olddata ON
newdata.ReimbursementRuleUid = olddata.ReimbursementRuleUid
GO
INSERT ListReimbursementRule
SELECT newdata.*
FROM migtemp_ListReimbursementRule AS newdata
LEFT JOIN ListReimbursementRule AS olddata ON
newdata.ReimbursementRuleUid = olddata.ReimbursementRuleUid
WHERE
olddata.ReimbursementRuleUid IS NULL
GO
DROP TABLE migtemp_ListReimbursementRule
GO
ALTER TABLE ListRelatedCause NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListRelatedCause AS newdata
INNER JOIN ListRelatedCause AS olddata ON
newdata.RelatedCauseUid = olddata.RelatedCauseUid
GO
INSERT ListRelatedCause
SELECT newdata.*
FROM migtemp_ListRelatedCause AS newdata
LEFT JOIN ListRelatedCause AS olddata ON
newdata.RelatedCauseUid = olddata.RelatedCauseUid
WHERE
olddata.RelatedCauseUid IS NULL
GO
DROP TABLE migtemp_ListRelatedCause
GO
ALTER TABLE ListRelationalOperator NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListRelationalOperator AS newdata
INNER JOIN ListRelationalOperator AS olddata ON
newdata.RelationalOperatorUid = olddata.RelationalOperatorUid
GO
INSERT ListRelationalOperator
SELECT newdata.*
FROM migtemp_ListRelationalOperator AS newdata
LEFT JOIN ListRelationalOperator AS olddata ON
newdata.RelationalOperatorUid = olddata.RelationalOperatorUid
WHERE
olddata.RelationalOperatorUid IS NULL
GO
DROP TABLE migtemp_ListRelationalOperator
GO
ALTER TABLE ListRelationship NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListRelationship AS newdata
INNER JOIN ListRelationship AS olddata ON
newdata.RelationshipUid = olddata.RelationshipUid
GO
INSERT ListRelationship
SELECT newdata.*
FROM migtemp_ListRelationship AS newdata
LEFT JOIN ListRelationship AS olddata ON
newdata.RelationshipUid = olddata.RelationshipUid
WHERE
olddata.RelationshipUid IS NULL
GO
DROP TABLE migtemp_ListRelationship
GO
ALTER TABLE ListReport NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[UserDefinedControlGroupUid] = newdata.[UserDefinedControlGroupUid]
, olddata.[UseBusinessObject] = newdata.[UseBusinessObject]
, olddata.[ReportParameters] = newdata.[ReportParameters]
, olddata.[ReportFolderUid] = newdata.[ReportFolderUid]
, olddata.[ContextReport] = newdata.[ContextReport]
, olddata.[Modifier] = newdata.[Modifier]
, olddata.[LastGenerationDate] = newdata.[LastGenerationDate]
, olddata.[GenerationCount] = newdata.[GenerationCount]
FROM migtemp_ListReport AS newdata
INNER JOIN ListReport AS olddata ON
newdata.ReportUid = olddata.ReportUid
GO
INSERT ListReport
SELECT newdata.*
FROM migtemp_ListReport AS newdata
LEFT JOIN ListReport AS olddata ON
newdata.ReportUid = olddata.ReportUid
WHERE
olddata.ReportUid IS NULL
GO
DROP TABLE migtemp_ListReport
GO
ALTER TABLE ListReportability NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListReportability AS newdata
INNER JOIN ListReportability AS olddata ON
newdata.ReportabilityUid = olddata.ReportabilityUid
GO
INSERT ListReportability
SELECT newdata.*
FROM migtemp_ListReportability AS newdata
LEFT JOIN ListReportability AS olddata ON
newdata.ReportabilityUid = olddata.ReportabilityUid
WHERE
olddata.ReportabilityUid IS NULL
GO
DROP TABLE migtemp_ListReportability
GO
ALTER TABLE ListReportDesignerView NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListReportDesignerView AS newdata
INNER JOIN ListReportDesignerView AS olddata ON
newdata.ReportDesignerViewUid = olddata.ReportDesignerViewUid
GO
INSERT ListReportDesignerView
SELECT newdata.*
FROM migtemp_ListReportDesignerView AS newdata
LEFT JOIN ListReportDesignerView AS olddata ON
newdata.ReportDesignerViewUid = olddata.ReportDesignerViewUid
WHERE
olddata.ReportDesignerViewUid IS NULL
GO
DROP TABLE migtemp_ListReportDesignerView
GO
ALTER TABLE ListReportFolder NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListReportFolder AS newdata
INNER JOIN ListReportFolder AS olddata ON
newdata.ReportFolderUid = olddata.ReportFolderUid
GO
INSERT ListReportFolder
SELECT newdata.*
FROM migtemp_ListReportFolder AS newdata
LEFT JOIN ListReportFolder AS olddata ON
newdata.ReportFolderUid = olddata.ReportFolderUid
WHERE
olddata.ReportFolderUid IS NULL
GO
DROP TABLE migtemp_ListReportFolder
GO
ALTER TABLE ListReportRdl NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[ReportDefinition] = newdata.[ReportDefinition]
, olddata.[ExcelReport] = newdata.[ExcelReport]
, olddata.[IncludePracticeNameParameter] = newdata.[IncludePracticeNameParameter]
, olddata.[ReportFormat] = newdata.[ReportFormat]
, olddata.[ReportUid] = newdata.[ReportUid]
, olddata.[SQLRevision] = newdata.[SQLRevision]
FROM migtemp_ListReportRdl AS newdata
INNER JOIN ListReportRdl AS olddata ON
newdata.ReportRdlUid = olddata.ReportRdlUid
GO
INSERT ListReportRdl
SELECT newdata.*
FROM migtemp_ListReportRdl AS newdata
LEFT JOIN ListReportRdl AS olddata ON
newdata.ReportRdlUid = olddata.ReportRdlUid
WHERE
olddata.ReportRdlUid IS NULL
GO
DROP TABLE migtemp_ListReportRdl
GO
ALTER TABLE ListResponseCode NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListResponseCode AS newdata
INNER JOIN ListResponseCode AS olddata ON
newdata.ResponseCodeUid = olddata.ResponseCodeUid
GO
INSERT ListResponseCode
SELECT newdata.*
FROM migtemp_ListResponseCode AS newdata
LEFT JOIN ListResponseCode AS olddata ON
newdata.ResponseCodeUid = olddata.ResponseCodeUid
WHERE
olddata.ResponseCodeUid IS NULL
GO
DROP TABLE migtemp_ListResponseCode
GO
ALTER TABLE ListRoom NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListRoom AS newdata
INNER JOIN ListRoom AS olddata ON
newdata.RoomUid = olddata.RoomUid
GO
INSERT ListRoom
SELECT newdata.*
FROM migtemp_ListRoom AS newdata
LEFT JOIN ListRoom AS olddata ON
newdata.RoomUid = olddata.RoomUid
WHERE
olddata.RoomUid IS NULL
GO
DROP TABLE migtemp_ListRoom
GO
ALTER TABLE ListRuleMeasure NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[ExternalID] = newdata.[ExternalID]
, olddata.[Name] = newdata.[Name]
, olddata.[EditAQN] = newdata.[EditAQN]
, olddata.[Cat1_FieldMapping] = newdata.[Cat1_FieldMapping]
, olddata.[Cat1_XSLT] = newdata.[Cat1_XSLT]
, olddata.[Cat1_Validation] = newdata.[Cat1_Validation]
, olddata.[Cat1_XSL] = newdata.[Cat1_XSL]
, olddata.[Cat1_Configuration] = newdata.[Cat1_Configuration]
, olddata.[Cat1_ValidatorAQN] = newdata.[Cat1_ValidatorAQN]
, olddata.[Cat1_GeneratorAQN] = newdata.[Cat1_GeneratorAQN]
, olddata.[Cat1_DocumentAQN] = newdata.[Cat1_DocumentAQN]
, olddata.[Cat1_LoadSpanXml] = newdata.[Cat1_LoadSpanXml]
, olddata.[Cat1_HintSectionGeneratorMethods] = newdata.[Cat1_HintSectionGeneratorMethods]
, olddata.[Cat1_CompleteChartFieldMapping] = newdata.[Cat1_CompleteChartFieldMapping]
, olddata.[Cat1_DocumentType] = newdata.[Cat1_DocumentType]
, olddata.[Cat3_FieldMapping] = newdata.[Cat3_FieldMapping]
, olddata.[Cat3_XSLT] = newdata.[Cat3_XSLT]
, olddata.[Cat3_Validation] = newdata.[Cat3_Validation]
, olddata.[Cat3_XSL] = newdata.[Cat3_XSL]
, olddata.[Cat3_Configuration] = newdata.[Cat3_Configuration]
, olddata.[Cat3_PatientDetail_FieldMapping] = newdata.[Cat3_PatientDetail_FieldMapping]
, olddata.[Cat3_PatientDetail_XSLT] = newdata.[Cat3_PatientDetail_XSLT]
, olddata.[Cat3_PatientDetail_XSL] = newdata.[Cat3_PatientDetail_XSL]
, olddata.[Cat3_GeneratorAQN] = newdata.[Cat3_GeneratorAQN]
, olddata.[Cat3_Final_XSLT] = newdata.[Cat3_Final_XSLT]
, olddata.[Version] = newdata.[Version]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[UserDefined] = newdata.[UserDefined]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[LastModifiedByUid] = newdata.[LastModifiedByUid]
, olddata.[CustomMatchingQualifier] = newdata.[CustomMatchingQualifier]
FROM migtemp_ListRuleMeasure AS newdata
INNER JOIN ListRuleMeasure AS olddata ON
newdata.RuleMeasureUid = olddata.RuleMeasureUid
GO
INSERT ListRuleMeasure
SELECT newdata.*
FROM migtemp_ListRuleMeasure AS newdata
LEFT JOIN ListRuleMeasure AS olddata ON
newdata.RuleMeasureUid = olddata.RuleMeasureUid
WHERE
olddata.RuleMeasureUid IS NULL
GO
DROP TABLE migtemp_ListRuleMeasure
GO
ALTER TABLE ListRxWorkflowStatus NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListRxWorkflowStatus AS newdata
INNER JOIN ListRxWorkflowStatus AS olddata ON
newdata.RxWorkflowStatusUid = olddata.RxWorkflowStatusUid
GO
INSERT ListRxWorkflowStatus
SELECT newdata.*
FROM migtemp_ListRxWorkflowStatus AS newdata
LEFT JOIN ListRxWorkflowStatus AS olddata ON
newdata.RxWorkflowStatusUid = olddata.RxWorkflowStatusUid
WHERE
olddata.RxWorkflowStatusUid IS NULL
GO
DROP TABLE migtemp_ListRxWorkflowStatus
GO
ALTER TABLE ListScantronPublishedForm NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListScantronPublishedForm AS newdata
INNER JOIN ListScantronPublishedForm AS olddata ON
newdata.ScantronPublishedFormUid = olddata.ScantronPublishedFormUid
GO
INSERT ListScantronPublishedForm
SELECT newdata.*
FROM migtemp_ListScantronPublishedForm AS newdata
LEFT JOIN ListScantronPublishedForm AS olddata ON
newdata.ScantronPublishedFormUid = olddata.ScantronPublishedFormUid
WHERE
olddata.ScantronPublishedFormUid IS NULL
GO
DROP TABLE migtemp_ListScantronPublishedForm
GO
ALTER TABLE ListScantronSurveyForm NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[SurveyUid] = newdata.[SurveyUid]
, olddata.[SurveySectionUid] = newdata.[SurveySectionUid]
, olddata.[FormID] = newdata.[FormID]
FROM migtemp_ListScantronSurveyForm AS newdata
INNER JOIN ListScantronSurveyForm AS olddata ON
newdata.ScantronSurveyFormUid = olddata.ScantronSurveyFormUid
GO
INSERT ListScantronSurveyForm
SELECT newdata.*
FROM migtemp_ListScantronSurveyForm AS newdata
LEFT JOIN ListScantronSurveyForm AS olddata ON
newdata.ScantronSurveyFormUid = olddata.ScantronSurveyFormUid
WHERE
olddata.ScantronSurveyFormUid IS NULL
GO
DROP TABLE migtemp_ListScantronSurveyForm
GO
ALTER TABLE ListScantronSurveyFormFields NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[ScantronSurveyFormUid] = newdata.[ScantronSurveyFormUid]
, olddata.[SurveyAnswerUid] = newdata.[SurveyAnswerUid]
, olddata.[SurveyQuestionUid] = newdata.[SurveyQuestionUid]
, olddata.[SurveySectionUid] = newdata.[SurveySectionUid]
, olddata.[SurveyUid] = newdata.[SurveyUid]
, olddata.[DisplayOrder] = newdata.[DisplayOrder]
FROM migtemp_ListScantronSurveyFormFields AS newdata
INNER JOIN ListScantronSurveyFormFields AS olddata ON
newdata.ScantronSurveyFormFieldsUid = olddata.ScantronSurveyFormFieldsUid
GO
INSERT ListScantronSurveyFormFields
SELECT newdata.*
FROM migtemp_ListScantronSurveyFormFields AS newdata
LEFT JOIN ListScantronSurveyFormFields AS olddata ON
newdata.ScantronSurveyFormFieldsUid = olddata.ScantronSurveyFormFieldsUid
WHERE
olddata.ScantronSurveyFormFieldsUid IS NULL
GO
DROP TABLE migtemp_ListScantronSurveyFormFields
GO
ALTER TABLE ListScrubItem NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListScrubItem AS newdata
INNER JOIN ListScrubItem AS olddata ON
newdata.ScrubItemUid = olddata.ScrubItemUid
GO
INSERT ListScrubItem
SELECT newdata.*
FROM migtemp_ListScrubItem AS newdata
LEFT JOIN ListScrubItem AS olddata ON
newdata.ScrubItemUid = olddata.ScrubItemUid
WHERE
olddata.ScrubItemUid IS NULL
GO
DROP TABLE migtemp_ListScrubItem
GO
ALTER TABLE ListScrubProfile NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListScrubProfile AS newdata
INNER JOIN ListScrubProfile AS olddata ON
newdata.ScrubProfileUid = olddata.ScrubProfileUid
GO
INSERT ListScrubProfile
SELECT newdata.*
FROM migtemp_ListScrubProfile AS newdata
LEFT JOIN ListScrubProfile AS olddata ON
newdata.ScrubProfileUid = olddata.ScrubProfileUid
WHERE
olddata.ScrubProfileUid IS NULL
GO
DROP TABLE migtemp_ListScrubProfile
GO
ALTER TABLE ListSecurity NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[SecurityGroupUid] = newdata.[SecurityGroupUid]
FROM migtemp_ListSecurity AS newdata
INNER JOIN ListSecurity AS olddata ON
newdata.SecurityUid = olddata.SecurityUid
GO
INSERT ListSecurity
SELECT newdata.*
FROM migtemp_ListSecurity AS newdata
LEFT JOIN ListSecurity AS olddata ON
newdata.SecurityUid = olddata.SecurityUid
WHERE
olddata.SecurityUid IS NULL
GO
DROP TABLE migtemp_ListSecurity
GO
ALTER TABLE ListSecurityGroup NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[Permission] = newdata.[Permission]
, olddata.[ShowInFindList] = newdata.[ShowInFindList]
FROM migtemp_ListSecurityGroup AS newdata
INNER JOIN ListSecurityGroup AS olddata ON
newdata.SecurityGroupUid = olddata.SecurityGroupUid
GO
INSERT ListSecurityGroup
SELECT newdata.*
FROM migtemp_ListSecurityGroup AS newdata
LEFT JOIN ListSecurityGroup AS olddata ON
newdata.SecurityGroupUid = olddata.SecurityGroupUid
WHERE
olddata.SecurityGroupUid IS NULL
GO
DROP TABLE migtemp_ListSecurityGroup
GO
ALTER TABLE ListServiceAuthorizationException NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListServiceAuthorizationException AS newdata
INNER JOIN ListServiceAuthorizationException AS olddata ON
newdata.ServiceAuthorizationExceptionUid = olddata.ServiceAuthorizationExceptionUid
GO
INSERT ListServiceAuthorizationException
SELECT newdata.*
FROM migtemp_ListServiceAuthorizationException AS newdata
LEFT JOIN ListServiceAuthorizationException AS olddata ON
newdata.ServiceAuthorizationExceptionUid = olddata.ServiceAuthorizationExceptionUid
WHERE
olddata.ServiceAuthorizationExceptionUid IS NULL
GO
DROP TABLE migtemp_ListServiceAuthorizationException
GO
ALTER TABLE ListServiceSiteType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListServiceSiteType AS newdata
INNER JOIN ListServiceSiteType AS olddata ON
newdata.ServiceSiteTypeUid = olddata.ServiceSiteTypeUid
GO
INSERT ListServiceSiteType
SELECT newdata.*
FROM migtemp_ListServiceSiteType AS newdata
LEFT JOIN ListServiceSiteType AS olddata ON
newdata.ServiceSiteTypeUid = olddata.ServiceSiteTypeUid
WHERE
olddata.ServiceSiteTypeUid IS NULL
GO
DROP TABLE migtemp_ListServiceSiteType
GO
ALTER TABLE ListSexualOrientation NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListSexualOrientation AS newdata
INNER JOIN ListSexualOrientation AS olddata ON
newdata.SexualOrientationUid = olddata.SexualOrientationUid
GO
INSERT ListSexualOrientation
SELECT newdata.*
FROM migtemp_ListSexualOrientation AS newdata
LEFT JOIN ListSexualOrientation AS olddata ON
newdata.SexualOrientationUid = olddata.SexualOrientationUid
WHERE
olddata.SexualOrientationUid IS NULL
GO
DROP TABLE migtemp_ListSexualOrientation
GO
ALTER TABLE ListSignatureSource NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListSignatureSource AS newdata
INNER JOIN ListSignatureSource AS olddata ON
newdata.SignatureSourceUid = olddata.SignatureSourceUid
GO
INSERT ListSignatureSource
SELECT newdata.*
FROM migtemp_ListSignatureSource AS newdata
LEFT JOIN ListSignatureSource AS olddata ON
newdata.SignatureSourceUid = olddata.SignatureSourceUid
WHERE
olddata.SignatureSourceUid IS NULL
GO
DROP TABLE migtemp_ListSignatureSource
GO
ALTER TABLE ListSIGQuantityUnitOfMeasure NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListSIGQuantityUnitOfMeasure AS newdata
INNER JOIN ListSIGQuantityUnitOfMeasure AS olddata ON
newdata.SIGQuantityUnitOfMeasureUid = olddata.SIGQuantityUnitOfMeasureUid
GO
INSERT ListSIGQuantityUnitOfMeasure
SELECT newdata.*
FROM migtemp_ListSIGQuantityUnitOfMeasure AS newdata
LEFT JOIN ListSIGQuantityUnitOfMeasure AS olddata ON
newdata.SIGQuantityUnitOfMeasureUid = olddata.SIGQuantityUnitOfMeasureUid
WHERE
olddata.SIGQuantityUnitOfMeasureUid IS NULL
GO
DROP TABLE migtemp_ListSIGQuantityUnitOfMeasure
GO
ALTER TABLE ListSmartChartActionType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListSmartChartActionType AS newdata
INNER JOIN ListSmartChartActionType AS olddata ON
newdata.SmartChartActionTypeUid = olddata.SmartChartActionTypeUid
GO
INSERT ListSmartChartActionType
SELECT newdata.*
FROM migtemp_ListSmartChartActionType AS newdata
LEFT JOIN ListSmartChartActionType AS olddata ON
newdata.SmartChartActionTypeUid = olddata.SmartChartActionTypeUid
WHERE
olddata.SmartChartActionTypeUid IS NULL
GO
DROP TABLE migtemp_ListSmartChartActionType
GO
ALTER TABLE ListSnomedCategory NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListSnomedCategory AS newdata
INNER JOIN ListSnomedCategory AS olddata ON
newdata.SnomedCategoryUid = olddata.SnomedCategoryUid
GO
INSERT ListSnomedCategory
SELECT newdata.*
FROM migtemp_ListSnomedCategory AS newdata
LEFT JOIN ListSnomedCategory AS olddata ON
newdata.SnomedCategoryUid = olddata.SnomedCategoryUid
WHERE
olddata.SnomedCategoryUid IS NULL
GO
DROP TABLE migtemp_ListSnomedCategory
GO
ALTER TABLE ListSpecialProgramReason NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListSpecialProgramReason AS newdata
INNER JOIN ListSpecialProgramReason AS olddata ON
newdata.SpecialProgramReasonUid = olddata.SpecialProgramReasonUid
GO
INSERT ListSpecialProgramReason
SELECT newdata.*
FROM migtemp_ListSpecialProgramReason AS newdata
LEFT JOIN ListSpecialProgramReason AS olddata ON
newdata.SpecialProgramReasonUid = olddata.SpecialProgramReasonUid
WHERE
olddata.SpecialProgramReasonUid IS NULL
GO
DROP TABLE migtemp_ListSpecialProgramReason
GO
ALTER TABLE ListSpecialty NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[ANSIcode] = newdata.[ANSIcode]
FROM migtemp_ListSpecialty AS newdata
INNER JOIN ListSpecialty AS olddata ON
newdata.SpecialtyUid = olddata.SpecialtyUid
GO
INSERT ListSpecialty
SELECT newdata.*
FROM migtemp_ListSpecialty AS newdata
LEFT JOIN ListSpecialty AS olddata ON
newdata.SpecialtyUid = olddata.SpecialtyUid
WHERE
olddata.SpecialtyUid IS NULL
GO
DROP TABLE migtemp_ListSpecialty
GO
ALTER TABLE ListState NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
FROM migtemp_ListState AS newdata
INNER JOIN ListState AS olddata ON
newdata.StateUid = olddata.StateUid
GO
INSERT ListState
SELECT newdata.*
FROM migtemp_ListState AS newdata
LEFT JOIN ListState AS olddata ON
newdata.StateUid = olddata.StateUid
WHERE
olddata.StateUid IS NULL
GO
DROP TABLE migtemp_ListState
GO
ALTER TABLE ListSuperbillStatus NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListSuperbillStatus AS newdata
INNER JOIN ListSuperbillStatus AS olddata ON
newdata.SuperbillStatusUid = olddata.SuperbillStatusUid
GO
INSERT ListSuperbillStatus
SELECT newdata.*
FROM migtemp_ListSuperbillStatus AS newdata
LEFT JOIN ListSuperbillStatus AS olddata ON
newdata.SuperbillStatusUid = olddata.SuperbillStatusUid
WHERE
olddata.SuperbillStatusUid IS NULL
GO
DROP TABLE migtemp_ListSuperbillStatus
GO
ALTER TABLE ListSurvey NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[FormType] = newdata.[FormType]
FROM migtemp_ListSurvey AS newdata
INNER JOIN ListSurvey AS olddata ON
newdata.SurveyUid = olddata.SurveyUid
GO
INSERT ListSurvey
SELECT newdata.*
FROM migtemp_ListSurvey AS newdata
LEFT JOIN ListSurvey AS olddata ON
newdata.SurveyUid = olddata.SurveyUid
WHERE
olddata.SurveyUid IS NULL
GO
DROP TABLE migtemp_ListSurvey
GO
ALTER TABLE ListSurveyAnswer NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[AnswerUid] = newdata.[AnswerUid]
, olddata.[MedicationUid] = newdata.[MedicationUid]
, olddata.[DrugName] = newdata.[DrugName]
, olddata.[TargetType] = newdata.[TargetType]
, olddata.[RosDenyFlag] = newdata.[RosDenyFlag]
FROM migtemp_ListSurveyAnswer AS newdata
INNER JOIN ListSurveyAnswer AS olddata ON
newdata.SurveyAnswerUid = olddata.SurveyAnswerUid
GO
INSERT ListSurveyAnswer
SELECT newdata.*
FROM migtemp_ListSurveyAnswer AS newdata
LEFT JOIN ListSurveyAnswer AS olddata ON
newdata.SurveyAnswerUid = olddata.SurveyAnswerUid
WHERE
olddata.SurveyAnswerUid IS NULL
GO
DROP TABLE migtemp_ListSurveyAnswer
GO
ALTER TABLE ListSurveyAnswerGroup NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[AnswerGroupUid] = newdata.[AnswerGroupUid]
, olddata.[TargetType] = newdata.[TargetType]
FROM migtemp_ListSurveyAnswerGroup AS newdata
INNER JOIN ListSurveyAnswerGroup AS olddata ON
newdata.SurveyAnswerGroupUid = olddata.SurveyAnswerGroupUid
GO
INSERT ListSurveyAnswerGroup
SELECT newdata.*
FROM migtemp_ListSurveyAnswerGroup AS newdata
LEFT JOIN ListSurveyAnswerGroup AS olddata ON
newdata.SurveyAnswerGroupUid = olddata.SurveyAnswerGroupUid
WHERE
olddata.SurveyAnswerGroupUid IS NULL
GO
DROP TABLE migtemp_ListSurveyAnswerGroup
GO
ALTER TABLE ListSurveyControlType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[ControlTypeUid] = newdata.[ControlTypeUid]
, olddata.[DesignTimeClass] = newdata.[DesignTimeClass]
, olddata.[RunTimeClass] = newdata.[RunTimeClass]
FROM migtemp_ListSurveyControlType AS newdata
INNER JOIN ListSurveyControlType AS olddata ON
newdata.SurveyControlTypeUid = olddata.SurveyControlTypeUid
GO
INSERT ListSurveyControlType
SELECT newdata.*
FROM migtemp_ListSurveyControlType AS newdata
LEFT JOIN ListSurveyControlType AS olddata ON
newdata.SurveyControlTypeUid = olddata.SurveyControlTypeUid
WHERE
olddata.SurveyControlTypeUid IS NULL
GO
DROP TABLE migtemp_ListSurveyControlType
GO
ALTER TABLE ListSurveyQuestion NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[HistoryGroupUid] = newdata.[HistoryGroupUid]
, olddata.[QuestionUid] = newdata.[QuestionUid]
, olddata.[RelRosSystemSymptomUid] = newdata.[RelRosSystemSymptomUid]
, olddata.[TargetType] = newdata.[TargetType]
, olddata.[RosName] = newdata.[RosName]
FROM migtemp_ListSurveyQuestion AS newdata
INNER JOIN ListSurveyQuestion AS olddata ON
newdata.SurveyQuestionUid = olddata.SurveyQuestionUid
GO
INSERT ListSurveyQuestion
SELECT newdata.*
FROM migtemp_ListSurveyQuestion AS newdata
LEFT JOIN ListSurveyQuestion AS olddata ON
newdata.SurveyQuestionUid = olddata.SurveyQuestionUid
WHERE
olddata.SurveyQuestionUid IS NULL
GO
DROP TABLE migtemp_ListSurveyQuestion
GO
ALTER TABLE ListSurveySection NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListSurveySection AS newdata
INNER JOIN ListSurveySection AS olddata ON
newdata.SurveySectionUid = olddata.SurveySectionUid
GO
INSERT ListSurveySection
SELECT newdata.*
FROM migtemp_ListSurveySection AS newdata
LEFT JOIN ListSurveySection AS olddata ON
newdata.SurveySectionUid = olddata.SurveySectionUid
WHERE
olddata.SurveySectionUid IS NULL
GO
DROP TABLE migtemp_ListSurveySection
GO
ALTER TABLE ListSymptom NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListSymptom AS newdata
INNER JOIN ListSymptom AS olddata ON
newdata.SymptomUid = olddata.SymptomUid
GO
INSERT ListSymptom
SELECT newdata.*
FROM migtemp_ListSymptom AS newdata
LEFT JOIN ListSymptom AS olddata ON
newdata.SymptomUid = olddata.SymptomUid
WHERE
olddata.SymptomUid IS NULL
GO
DROP TABLE migtemp_ListSymptom
GO
ALTER TABLE ListSystem NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListSystem AS newdata
INNER JOIN ListSystem AS olddata ON
newdata.SystemUid = olddata.SystemUid
GO
INSERT ListSystem
SELECT newdata.*
FROM migtemp_ListSystem AS newdata
LEFT JOIN ListSystem AS olddata ON
newdata.SystemUid = olddata.SystemUid
WHERE
olddata.SystemUid IS NULL
GO
DROP TABLE migtemp_ListSystem
GO
ALTER TABLE ListTextEditor NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListTextEditor AS newdata
INNER JOIN ListTextEditor AS olddata ON
newdata.EditorUid = olddata.EditorUid
GO
INSERT ListTextEditor
SELECT newdata.*
FROM migtemp_ListTextEditor AS newdata
LEFT JOIN ListTextEditor AS olddata ON
newdata.EditorUid = olddata.EditorUid
WHERE
olddata.EditorUid IS NULL
GO
DROP TABLE migtemp_ListTextEditor
GO
ALTER TABLE ListTileConfiguration NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListTileConfiguration AS newdata
INNER JOIN ListTileConfiguration AS olddata ON
newdata.TileConfigurationUid = olddata.TileConfigurationUid
GO
INSERT ListTileConfiguration
SELECT newdata.*
FROM migtemp_ListTileConfiguration AS newdata
LEFT JOIN ListTileConfiguration AS olddata ON
newdata.TileConfigurationUid = olddata.TileConfigurationUid
WHERE
olddata.TileConfigurationUid IS NULL
GO
DROP TABLE migtemp_ListTileConfiguration
GO
ALTER TABLE ListTileType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListTileType AS newdata
INNER JOIN ListTileType AS olddata ON
newdata.TileTypeUid = olddata.TileTypeUid
GO
INSERT ListTileType
SELECT newdata.*
FROM migtemp_ListTileType AS newdata
LEFT JOIN ListTileType AS olddata ON
newdata.TileTypeUid = olddata.TileTypeUid
WHERE
olddata.TileTypeUid IS NULL
GO
DROP TABLE migtemp_ListTileType
GO
ALTER TABLE ListTimeFrame NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListTimeFrame AS newdata
INNER JOIN ListTimeFrame AS olddata ON
newdata.TimeFrameUid = olddata.TimeFrameUid
GO
INSERT ListTimeFrame
SELECT newdata.*
FROM migtemp_ListTimeFrame AS newdata
LEFT JOIN ListTimeFrame AS olddata ON
newdata.TimeFrameUid = olddata.TimeFrameUid
WHERE
olddata.TimeFrameUid IS NULL
GO
DROP TABLE migtemp_ListTimeFrame
GO
ALTER TABLE ListTimespan NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[ProcessorAQN] = newdata.[ProcessorAQN]
FROM migtemp_ListTimespan AS newdata
INNER JOIN ListTimespan AS olddata ON
newdata.TimespanUid = olddata.TimespanUid
GO
INSERT ListTimespan
SELECT newdata.*
FROM migtemp_ListTimespan AS newdata
LEFT JOIN ListTimespan AS olddata ON
newdata.TimespanUid = olddata.TimespanUid
WHERE
olddata.TimespanUid IS NULL
GO
DROP TABLE migtemp_ListTimespan
GO
ALTER TABLE ListTimeType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListTimeType AS newdata
INNER JOIN ListTimeType AS olddata ON
newdata.TimeTypeUid = olddata.TimeTypeUid
GO
INSERT ListTimeType
SELECT newdata.*
FROM migtemp_ListTimeType AS newdata
LEFT JOIN ListTimeType AS olddata ON
newdata.TimeTypeUid = olddata.TimeTypeUid
WHERE
olddata.TimeTypeUid IS NULL
GO
DROP TABLE migtemp_ListTimeType
GO
ALTER TABLE ListTranscriptionStatus NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListTranscriptionStatus AS newdata
INNER JOIN ListTranscriptionStatus AS olddata ON
newdata.TranscriptionStatusUid = olddata.TranscriptionStatusUid
GO
INSERT ListTranscriptionStatus
SELECT newdata.*
FROM migtemp_ListTranscriptionStatus AS newdata
LEFT JOIN ListTranscriptionStatus AS olddata ON
newdata.TranscriptionStatusUid = olddata.TranscriptionStatusUid
WHERE
olddata.TranscriptionStatusUid IS NULL
GO
DROP TABLE migtemp_ListTranscriptionStatus
GO
ALTER TABLE ListTranslationTemplate NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[Document] = newdata.[Document]
FROM migtemp_ListTranslationTemplate AS newdata
INNER JOIN ListTranslationTemplate AS olddata ON
newdata.TranslationTemplateUid = olddata.TranslationTemplateUid
GO
INSERT ListTranslationTemplate
SELECT newdata.*
FROM migtemp_ListTranslationTemplate AS newdata
LEFT JOIN ListTranslationTemplate AS olddata ON
newdata.TranslationTemplateUid = olddata.TranslationTemplateUid
WHERE
olddata.TranslationTemplateUid IS NULL
GO
DROP TABLE migtemp_ListTranslationTemplate
GO
ALTER TABLE ListTransmissionHandling NOCHECK CONSTRAINT ALL
GO
INSERT ListTransmissionHandling
SELECT newdata.*
FROM migtemp_ListTransmissionHandling AS newdata
LEFT JOIN ListTransmissionHandling AS olddata ON
newdata.ListTransmissionHandlingUid = olddata.ListTransmissionHandlingUid
WHERE
olddata.ListTransmissionHandlingUid IS NULL
GO
DROP TABLE migtemp_ListTransmissionHandling
GO
ALTER TABLE ListTypeofVaccine NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListTypeofVaccine AS newdata
INNER JOIN ListTypeofVaccine AS olddata ON
newdata.TypeofVaccineUid = olddata.TypeofVaccineUid
GO
INSERT ListTypeofVaccine
SELECT newdata.*
FROM migtemp_ListTypeofVaccine AS newdata
LEFT JOIN ListTypeofVaccine AS olddata ON
newdata.TypeofVaccineUid = olddata.TypeofVaccineUid
WHERE
olddata.TypeofVaccineUid IS NULL
GO
DROP TABLE migtemp_ListTypeofVaccine
GO
ALTER TABLE ListTypeofVaccineElement NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListTypeofVaccineElement AS newdata
INNER JOIN ListTypeofVaccineElement AS olddata ON
newdata.TypeofVaccineElementUid = olddata.TypeofVaccineElementUid
GO
INSERT ListTypeofVaccineElement
SELECT newdata.*
FROM migtemp_ListTypeofVaccineElement AS newdata
LEFT JOIN ListTypeofVaccineElement AS olddata ON
newdata.TypeofVaccineElementUid = olddata.TypeofVaccineElementUid
WHERE
olddata.TypeofVaccineElementUid IS NULL
GO
DROP TABLE migtemp_ListTypeofVaccineElement
GO
ALTER TABLE ListUIConfiguration NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[UIConfigurationDataTypeUid] = newdata.[UIConfigurationDataTypeUid]
, olddata.[ExternalID] = newdata.[ExternalID]
, olddata.[Name] = newdata.[Name]
, olddata.[Data] = newdata.[Data]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[UserDefined] = newdata.[UserDefined]
, olddata.[LastModifiedByUid] = newdata.[LastModifiedByUid]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListUIConfiguration AS newdata
INNER JOIN ListUIConfiguration AS olddata ON
newdata.UIConfigurationUid = olddata.UIConfigurationUid
GO
INSERT ListUIConfiguration
SELECT newdata.*
FROM migtemp_ListUIConfiguration AS newdata
LEFT JOIN ListUIConfiguration AS olddata ON
newdata.UIConfigurationUid = olddata.UIConfigurationUid
WHERE
olddata.UIConfigurationUid IS NULL
GO
DROP TABLE migtemp_ListUIConfiguration
GO
ALTER TABLE ListUIConfigurationDataType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListUIConfigurationDataType AS newdata
INNER JOIN ListUIConfigurationDataType AS olddata ON
newdata.UIConfigurationDataTypeUid = olddata.UIConfigurationDataTypeUid
GO
INSERT ListUIConfigurationDataType
SELECT newdata.*
FROM migtemp_ListUIConfigurationDataType AS newdata
LEFT JOIN ListUIConfigurationDataType AS olddata ON
newdata.UIConfigurationDataTypeUid = olddata.UIConfigurationDataTypeUid
WHERE
olddata.UIConfigurationDataTypeUid IS NULL
GO
DROP TABLE migtemp_ListUIConfigurationDataType
GO
ALTER TABLE ListUIControl NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[LicenseCode] = newdata.[LicenseCode]
, olddata.[UIControlTypeUid] = newdata.[UIControlTypeUid]
, olddata.[AQN] = newdata.[AQN]
, olddata.[ConfigurationAQN] = newdata.[ConfigurationAQN]
, olddata.[ContentSourceFieldsAQN] = newdata.[ContentSourceFieldsAQN]
FROM migtemp_ListUIControl AS newdata
INNER JOIN ListUIControl AS olddata ON
newdata.UIControlUid = olddata.UIControlUid
GO
INSERT ListUIControl
SELECT newdata.*
FROM migtemp_ListUIControl AS newdata
LEFT JOIN ListUIControl AS olddata ON
newdata.UIControlUid = olddata.UIControlUid
WHERE
olddata.UIControlUid IS NULL
GO
DROP TABLE migtemp_ListUIControl
GO
ALTER TABLE ListUIControlType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListUIControlType AS newdata
INNER JOIN ListUIControlType AS olddata ON
newdata.UIControlTypeUid = olddata.UIControlTypeUid
GO
INSERT ListUIControlType
SELECT newdata.*
FROM migtemp_ListUIControlType AS newdata
LEFT JOIN ListUIControlType AS olddata ON
newdata.UIControlTypeUid = olddata.UIControlTypeUid
WHERE
olddata.UIControlTypeUid IS NULL
GO
DROP TABLE migtemp_ListUIControlType
GO
ALTER TABLE ListUIFilterType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListUIFilterType AS newdata
INNER JOIN ListUIFilterType AS olddata ON
newdata.UIFilterTypeUid = olddata.UIFilterTypeUid
GO
INSERT ListUIFilterType
SELECT newdata.*
FROM migtemp_ListUIFilterType AS newdata
LEFT JOIN ListUIFilterType AS olddata ON
newdata.UIFilterTypeUid = olddata.UIFilterTypeUid
WHERE
olddata.UIFilterTypeUid IS NULL
GO
DROP TABLE migtemp_ListUIFilterType
GO
ALTER TABLE ListUserDefinedControl NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[Label] = (CASE WHEN (olddata.UserDefined = 0) THEN newdata.[Label] ELSE olddata.[Label] END)
, olddata.[ControlTypeUid] = (CASE WHEN (olddata.UserDefined = 0) THEN newdata.[ControlTypeUid] ELSE olddata.[ControlTypeUid] END)
, olddata.[ControlProperties] = (CASE WHEN (olddata.UserDefined = 0) THEN newdata.[ControlProperties] ELSE olddata.[ControlProperties] END)
, olddata.[SortOrder] = (CASE WHEN (olddata.UserDefined = 0) THEN newdata.[SortOrder] ELSE olddata.[SortOrder] END)
FROM migtemp_ListUserDefinedControl AS newdata
INNER JOIN ListUserDefinedControl AS olddata ON
newdata.UserDefinedControlUid = olddata.UserDefinedControlUid
GO
INSERT ListUserDefinedControl
SELECT newdata.*
FROM migtemp_ListUserDefinedControl AS newdata
LEFT JOIN ListUserDefinedControl AS olddata ON
newdata.UserDefinedControlUid = olddata.UserDefinedControlUid
WHERE
olddata.UserDefinedControlUid IS NULL
GO
DROP TABLE migtemp_ListUserDefinedControl
GO
ALTER TABLE ListUserDefinedControlGroup NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListUserDefinedControlGroup AS newdata
INNER JOIN ListUserDefinedControlGroup AS olddata ON
newdata.UserDefinedControlGroupUid = olddata.UserDefinedControlGroupUid
GO
INSERT ListUserDefinedControlGroup
SELECT newdata.*
FROM migtemp_ListUserDefinedControlGroup AS newdata
LEFT JOIN ListUserDefinedControlGroup AS olddata ON
newdata.UserDefinedControlGroupUid = olddata.UserDefinedControlGroupUid
WHERE
olddata.UserDefinedControlGroupUid IS NULL
GO
DROP TABLE migtemp_ListUserDefinedControlGroup
GO
ALTER TABLE ListUserDefinedData NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[ExternalID] = newdata.[ExternalID]
, olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[FindTableUid] = newdata.[FindTableUid]
, olddata.[UserDefined] = newdata.[UserDefined]
, olddata.[DisplayOrder] = newdata.[DisplayOrder]
, olddata.[LastModifiedByUid] = newdata.[LastModifiedByUid]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListUserDefinedData AS newdata
INNER JOIN ListUserDefinedData AS olddata ON
newdata.UserDefinedDataUid = olddata.UserDefinedDataUid
GO
INSERT ListUserDefinedData
SELECT newdata.*
FROM migtemp_ListUserDefinedData AS newdata
LEFT JOIN ListUserDefinedData AS olddata ON
newdata.UserDefinedDataUid = olddata.UserDefinedDataUid
WHERE
olddata.UserDefinedDataUid IS NULL
GO
DROP TABLE migtemp_ListUserDefinedData
GO
ALTER TABLE ListUserDefinedFilter NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListUserDefinedFilter AS newdata
INNER JOIN ListUserDefinedFilter AS olddata ON
newdata.UserDefinedFilterUid = olddata.UserDefinedFilterUid
GO
INSERT ListUserDefinedFilter
SELECT newdata.*
FROM migtemp_ListUserDefinedFilter AS newdata
LEFT JOIN ListUserDefinedFilter AS olddata ON
newdata.UserDefinedFilterUid = olddata.UserDefinedFilterUid
WHERE
olddata.UserDefinedFilterUid IS NULL
GO
DROP TABLE migtemp_ListUserDefinedFilter
GO
ALTER TABLE ListUserDefinedTemplate NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[LicenseCode] = newdata.[LicenseCode]
FROM migtemp_ListUserDefinedTemplate AS newdata
INNER JOIN ListUserDefinedTemplate AS olddata ON
newdata.UserDefinedTemplateUid = olddata.UserDefinedTemplateUid
GO
INSERT ListUserDefinedTemplate
SELECT newdata.*
FROM migtemp_ListUserDefinedTemplate AS newdata
LEFT JOIN ListUserDefinedTemplate AS olddata ON
newdata.UserDefinedTemplateUid = olddata.UserDefinedTemplateUid
WHERE
olddata.UserDefinedTemplateUid IS NULL
GO
DROP TABLE migtemp_ListUserDefinedTemplate
GO
ALTER TABLE ListUserGroup NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListUserGroup AS newdata
INNER JOIN ListUserGroup AS olddata ON
newdata.UserGroupUid = olddata.UserGroupUid
GO
INSERT ListUserGroup
SELECT newdata.*
FROM migtemp_ListUserGroup AS newdata
LEFT JOIN ListUserGroup AS olddata ON
newdata.UserGroupUid = olddata.UserGroupUid
WHERE
olddata.UserGroupUid IS NULL
GO
DROP TABLE migtemp_ListUserGroup
GO
ALTER TABLE ListUserGroupType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListUserGroupType AS newdata
INNER JOIN ListUserGroupType AS olddata ON
newdata.UserGroupTypeUid = olddata.UserGroupTypeUid
GO
INSERT ListUserGroupType
SELECT newdata.*
FROM migtemp_ListUserGroupType AS newdata
LEFT JOIN ListUserGroupType AS olddata ON
newdata.UserGroupTypeUid = olddata.UserGroupTypeUid
WHERE
olddata.UserGroupTypeUid IS NULL
GO
DROP TABLE migtemp_ListUserGroupType
GO
ALTER TABLE ListUserSetting NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListUserSetting AS newdata
INNER JOIN ListUserSetting AS olddata ON
newdata.UserSettingUid = olddata.UserSettingUid
GO
INSERT ListUserSetting
SELECT newdata.*
FROM migtemp_ListUserSetting AS newdata
LEFT JOIN ListUserSetting AS olddata ON
newdata.UserSettingUid = olddata.UserSettingUid
WHERE
olddata.UserSettingUid IS NULL
GO
DROP TABLE migtemp_ListUserSetting
GO
ALTER TABLE ListVaccine NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListVaccine AS newdata
INNER JOIN ListVaccine AS olddata ON
newdata.VaccineUid = olddata.VaccineUid
GO
INSERT ListVaccine
SELECT newdata.*
FROM migtemp_ListVaccine AS newdata
LEFT JOIN ListVaccine AS olddata ON
newdata.VaccineUid = olddata.VaccineUid
WHERE
olddata.VaccineUid IS NULL
GO
DROP TABLE migtemp_ListVaccine
GO
ALTER TABLE ListVaccineAdmin NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListVaccineAdmin AS newdata
INNER JOIN ListVaccineAdmin AS olddata ON
newdata.VaccineAdminUid = olddata.VaccineAdminUid
GO
INSERT ListVaccineAdmin
SELECT newdata.*
FROM migtemp_ListVaccineAdmin AS newdata
LEFT JOIN ListVaccineAdmin AS olddata ON
newdata.VaccineAdminUid = olddata.VaccineAdminUid
WHERE
olddata.VaccineAdminUid IS NULL
GO
DROP TABLE migtemp_ListVaccineAdmin
GO
ALTER TABLE ListVaccineFundingSource NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListVaccineFundingSource AS newdata
INNER JOIN ListVaccineFundingSource AS olddata ON
newdata.VaccineFundingSourceUid = olddata.VaccineFundingSourceUid
GO
INSERT ListVaccineFundingSource
SELECT newdata.*
FROM migtemp_ListVaccineFundingSource AS newdata
LEFT JOIN ListVaccineFundingSource AS olddata ON
newdata.VaccineFundingSourceUid = olddata.VaccineFundingSourceUid
WHERE
olddata.VaccineFundingSourceUid IS NULL
GO
DROP TABLE migtemp_ListVaccineFundingSource
GO
ALTER TABLE ListVaccineMfr NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListVaccineMfr AS newdata
INNER JOIN ListVaccineMfr AS olddata ON
newdata.VaccineMfrUid = olddata.VaccineMfrUid
GO
INSERT ListVaccineMfr
SELECT newdata.*
FROM migtemp_ListVaccineMfr AS newdata
LEFT JOIN ListVaccineMfr AS olddata ON
newdata.VaccineMfrUid = olddata.VaccineMfrUid
WHERE
olddata.VaccineMfrUid IS NULL
GO
DROP TABLE migtemp_ListVaccineMfr
GO
ALTER TABLE ListVaccineRoute NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListVaccineRoute AS newdata
INNER JOIN ListVaccineRoute AS olddata ON
newdata.VaccineRouteUid = olddata.VaccineRouteUid
GO
INSERT ListVaccineRoute
SELECT newdata.*
FROM migtemp_ListVaccineRoute AS newdata
LEFT JOIN ListVaccineRoute AS olddata ON
newdata.VaccineRouteUid = olddata.VaccineRouteUid
WHERE
olddata.VaccineRouteUid IS NULL
GO
DROP TABLE migtemp_ListVaccineRoute
GO
ALTER TABLE ListVaccineSite NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListVaccineSite AS newdata
INNER JOIN ListVaccineSite AS olddata ON
newdata.VaccineSiteUid = olddata.VaccineSiteUid
GO
INSERT ListVaccineSite
SELECT newdata.*
FROM migtemp_ListVaccineSite AS newdata
LEFT JOIN ListVaccineSite AS olddata ON
newdata.VaccineSiteUid = olddata.VaccineSiteUid
WHERE
olddata.VaccineSiteUid IS NULL
GO
DROP TABLE migtemp_ListVaccineSite
GO
ALTER TABLE ListValueCode NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListValueCode AS newdata
INNER JOIN ListValueCode AS olddata ON
newdata.ValueCodeUid = olddata.ValueCodeUid
GO
INSERT ListValueCode
SELECT newdata.*
FROM migtemp_ListValueCode AS newdata
LEFT JOIN ListValueCode AS olddata ON
newdata.ValueCodeUid = olddata.ValueCodeUid
WHERE
olddata.ValueCodeUid IS NULL
GO
DROP TABLE migtemp_ListValueCode
GO
ALTER TABLE ListVFCEligibility NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListVFCEligibility AS newdata
INNER JOIN ListVFCEligibility AS olddata ON
newdata.VFCEligibilityUid = olddata.VFCEligibilityUid
GO
INSERT ListVFCEligibility
SELECT newdata.*
FROM migtemp_ListVFCEligibility AS newdata
LEFT JOIN ListVFCEligibility AS olddata ON
newdata.VFCEligibilityUid = olddata.VFCEligibilityUid
WHERE
olddata.VFCEligibilityUid IS NULL
GO
DROP TABLE migtemp_ListVFCEligibility
GO
ALTER TABLE ListVisitType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListVisitType AS newdata
INNER JOIN ListVisitType AS olddata ON
newdata.VisitTypeUid = olddata.VisitTypeUid
GO
INSERT ListVisitType
SELECT newdata.*
FROM migtemp_ListVisitType AS newdata
LEFT JOIN ListVisitType AS olddata ON
newdata.VisitTypeUid = olddata.VisitTypeUid
WHERE
olddata.VisitTypeUid IS NULL
GO
DROP TABLE migtemp_ListVisitType
GO
ALTER TABLE ListVoiceTag NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListVoiceTag AS newdata
INNER JOIN ListVoiceTag AS olddata ON
newdata.VoiceTagUid = olddata.VoiceTagUid
GO
INSERT ListVoiceTag
SELECT newdata.*
FROM migtemp_ListVoiceTag AS newdata
LEFT JOIN ListVoiceTag AS olddata ON
newdata.VoiceTagUid = olddata.VoiceTagUid
WHERE
olddata.VoiceTagUid IS NULL
GO
DROP TABLE migtemp_ListVoiceTag
GO
ALTER TABLE ListWeightConditions NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListWeightConditions AS newdata
INNER JOIN ListWeightConditions AS olddata ON
newdata.WeightConditionsUid = olddata.WeightConditionsUid
GO
INSERT ListWeightConditions
SELECT newdata.*
FROM migtemp_ListWeightConditions AS newdata
LEFT JOIN ListWeightConditions AS olddata ON
newdata.WeightConditionsUid = olddata.WeightConditionsUid
WHERE
olddata.WeightConditionsUid IS NULL
GO
DROP TABLE migtemp_ListWeightConditions
GO
ALTER TABLE ListZip NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListZip AS newdata
INNER JOIN ListZip AS olddata ON
newdata.ZipUid = olddata.ZipUid
GO
INSERT ListZip
SELECT newdata.*
FROM migtemp_ListZip AS newdata
LEFT JOIN ListZip AS olddata ON
newdata.ZipUid = olddata.ZipUid
WHERE
olddata.ZipUid IS NULL
GO
DROP TABLE migtemp_ListZip
GO
ALTER TABLE MapItem NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_MapItem AS newdata
INNER JOIN MapItem AS olddata ON
newdata.MapItemUid = olddata.MapItemUid
GO
INSERT MapItem
SELECT newdata.*
FROM migtemp_MapItem AS newdata
LEFT JOIN MapItem AS olddata ON
newdata.MapItemUid = olddata.MapItemUid
WHERE
olddata.MapItemUid IS NULL
GO
DROP TABLE migtemp_MapItem
GO
ALTER TABLE MapSource NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_MapSource AS newdata
INNER JOIN MapSource AS olddata ON
newdata.MapSourceUid = olddata.MapSourceUid
GO
INSERT MapSource
SELECT newdata.*
FROM migtemp_MapSource AS newdata
LEFT JOIN MapSource AS olddata ON
newdata.MapSourceUid = olddata.MapSourceUid
WHERE
olddata.MapSourceUid IS NULL
GO
DROP TABLE migtemp_MapSource
GO
ALTER TABLE MasterPharmacy NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[ExternalID] = newdata.[ExternalID]
, olddata.[Name] = newdata.[Name]
, olddata.[Address] = newdata.[Address]
, olddata.[Phone1] = newdata.[Phone1]
, olddata.[Phone2] = newdata.[Phone2]
, olddata.[Phone3] = newdata.[Phone3]
, olddata.[PharmacyClearinghouseUid] = newdata.[PharmacyClearinghouseUid]
, olddata.[PharmacyID] = newdata.[PharmacyID]
, olddata.[Email] = newdata.[Email]
, olddata.[CrossStreet] = newdata.[CrossStreet]
, olddata.[ServiceLevelCode] = newdata.[ServiceLevelCode]
, olddata.[PartnerAccount] = newdata.[PartnerAccount]
, olddata.[UserDefined] = newdata.[UserDefined]
, olddata.[NPI] = newdata.[NPI]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[SpecialtyID] = newdata.[SpecialtyID]
, olddata.[FileID] = newdata.[FileID]
, olddata.[StateLicenseNumber] = newdata.[StateLicenseNumber]
, olddata.[MedicareNumber] = newdata.[MedicareNumber]
, olddata.[MedicaidNumber] = newdata.[MedicaidNumber]
, olddata.[PPONumber] = newdata.[PPONumber]
, olddata.[PayerID] = newdata.[PayerID]
, olddata.[BINLocationNumber] = newdata.[BINLocationNumber]
, olddata.[DEANumber] = newdata.[DEANumber]
, olddata.[HIN] = newdata.[HIN]
, olddata.[SecondaryCoverage] = newdata.[SecondaryCoverage]
, olddata.[NAICCode] = newdata.[NAICCode]
, olddata.[PromotionNumber] = newdata.[PromotionNumber]
, olddata.[SocialSecurity] = newdata.[SocialSecurity]
, olddata.[PriorAuthorization] = newdata.[PriorAuthorization]
, olddata.[MutuallyDefined] = newdata.[MutuallyDefined]
, olddata.[ServiceLevelCodeXML] = newdata.[ServiceLevelCodeXML]
, olddata.[SpecialtyTypeXML] = newdata.[SpecialtyTypeXML]
, olddata.[OrganizationID] = newdata.[OrganizationID]
, olddata.[ParentOrganizationID] = newdata.[ParentOrganizationID]
, olddata.[DirectAddress] = newdata.[DirectAddress]
, olddata.[DownloadXML] = newdata.[DownloadXML]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[LastModifiedByUid] = newdata.[LastModifiedByUid]
FROM migtemp_MasterPharmacy AS newdata
INNER JOIN MasterPharmacy AS olddata ON
newdata.MasterPharmacyUid = olddata.MasterPharmacyUid
GO
INSERT MasterPharmacy
SELECT newdata.*
FROM migtemp_MasterPharmacy AS newdata
LEFT JOIN MasterPharmacy AS olddata ON
newdata.MasterPharmacyUid = olddata.MasterPharmacyUid
WHERE
olddata.MasterPharmacyUid IS NULL
GO
DROP TABLE migtemp_MasterPharmacy
GO
ALTER TABLE MasterProcedureToLoinc NOCHECK CONSTRAINT ALL
GO
INSERT MasterProcedureToLoinc
SELECT newdata.*
FROM migtemp_MasterProcedureToLoinc AS newdata
LEFT JOIN MasterProcedureToLoinc AS olddata ON
newdata.MasterProcedureToLoincUid = olddata.MasterProcedureToLoincUid
WHERE
olddata.MasterProcedureToLoincUid IS NULL
GO
DROP TABLE migtemp_MasterProcedureToLoinc
GO
ALTER TABLE MasterSnomedDescription NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[id] = newdata.[id]
, olddata.[effectiveTime] = newdata.[effectiveTime]
, olddata.[moduleId] = newdata.[moduleId]
, olddata.[conceptId] = newdata.[conceptId]
, olddata.[languageCode] = newdata.[languageCode]
, olddata.[typeId] = newdata.[typeId]
, olddata.[term] = newdata.[term]
, olddata.[category] = newdata.[category]
, olddata.[caseSignificanceId] = newdata.[caseSignificanceId]
, olddata.[UserDefined] = newdata.[UserDefined]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedByUid] = newdata.[LastModifiedByUid]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_MasterSnomedDescription AS newdata
INNER JOIN MasterSnomedDescription AS olddata ON
newdata.DescriptionUid = olddata.DescriptionUid
GO
INSERT MasterSnomedDescription
SELECT newdata.*
FROM migtemp_MasterSnomedDescription AS newdata
LEFT JOIN MasterSnomedDescription AS olddata ON
newdata.DescriptionUid = olddata.DescriptionUid
WHERE
olddata.DescriptionUid IS NULL
GO
DROP TABLE migtemp_MasterSnomedDescription
GO
ALTER TABLE MeaningfulUseCategoryDefinition NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[CategoryName] = newdata.[CategoryName]
, olddata.[CategoryNumber] = newdata.[CategoryNumber]
, olddata.[UserDefined] = newdata.[UserDefined]
, olddata.[LastModifiedByUid] = newdata.[LastModifiedByUid]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_MeaningfulUseCategoryDefinition AS newdata
INNER JOIN MeaningfulUseCategoryDefinition AS olddata ON
newdata.CategoryUid = olddata.CategoryUid
GO
INSERT MeaningfulUseCategoryDefinition
SELECT newdata.*
FROM migtemp_MeaningfulUseCategoryDefinition AS newdata
LEFT JOIN MeaningfulUseCategoryDefinition AS olddata ON
newdata.CategoryUid = olddata.CategoryUid
WHERE
olddata.CategoryUid IS NULL
GO
DROP TABLE migtemp_MeaningfulUseCategoryDefinition
GO
ALTER TABLE MeaningfulUseItemDefinition NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[StageUid] = newdata.[StageUid]
, olddata.[CategoryUid] = newdata.[CategoryUid]
, olddata.[MeasureNumber] = newdata.[MeasureNumber]
, olddata.[SubMeasureNumber] = newdata.[SubMeasureNumber]
, olddata.[ObjectiveDesc] = newdata.[ObjectiveDesc]
, olddata.[MeasureDesc] = newdata.[MeasureDesc]
, olddata.[MeasureDetailDesc] = newdata.[MeasureDetailDesc]
, olddata.[ExclusionDesc] = newdata.[ExclusionDesc]
, olddata.[DenominatorDesc] = newdata.[DenominatorDesc]
, olddata.[NumeratorDesc] = newdata.[NumeratorDesc]
, olddata.[YesNo] = newdata.[YesNo]
, olddata.[GoalDesc] = newdata.[GoalDesc]
, olddata.[GoalValue] = newdata.[GoalValue]
, olddata.[WorkflowNumeratorDefinitionUid] = newdata.[WorkflowNumeratorDefinitionUid]
, olddata.[WorkflowDenominatorDefinitionUid] = newdata.[WorkflowDenominatorDefinitionUid]
, olddata.[WorkflowReportDefinitionUid] = newdata.[WorkflowReportDefinitionUid]
, olddata.[UserDefined] = newdata.[UserDefined]
, olddata.[LastModifiedByUid] = newdata.[LastModifiedByUid]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_MeaningfulUseItemDefinition AS newdata
INNER JOIN MeaningfulUseItemDefinition AS olddata ON
newdata.ItemDefinitionUid = olddata.ItemDefinitionUid
GO
INSERT MeaningfulUseItemDefinition
SELECT newdata.*
FROM migtemp_MeaningfulUseItemDefinition AS newdata
LEFT JOIN MeaningfulUseItemDefinition AS olddata ON
newdata.ItemDefinitionUid = olddata.ItemDefinitionUid
WHERE
olddata.ItemDefinitionUid IS NULL
GO
DROP TABLE migtemp_MeaningfulUseItemDefinition
GO
ALTER TABLE MeaningfulUseStageDefinition NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[StageName] = newdata.[StageName]
, olddata.[StageNumber] = newdata.[StageNumber]
, olddata.[UserDefined] = newdata.[UserDefined]
, olddata.[LastModifiedByUid] = newdata.[LastModifiedByUid]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_MeaningfulUseStageDefinition AS newdata
INNER JOIN MeaningfulUseStageDefinition AS olddata ON
newdata.StageUid = olddata.StageUid
GO
INSERT MeaningfulUseStageDefinition
SELECT newdata.*
FROM migtemp_MeaningfulUseStageDefinition AS newdata
LEFT JOIN MeaningfulUseStageDefinition AS olddata ON
newdata.StageUid = olddata.StageUid
WHERE
olddata.StageUid IS NULL
GO
DROP TABLE migtemp_MeaningfulUseStageDefinition
GO
ALTER TABLE MedicationSIG NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_MedicationSIG AS newdata
INNER JOIN MedicationSIG AS olddata ON
newdata.MedicationSIGUid = olddata.MedicationSIGUid
GO
INSERT MedicationSIG
SELECT newdata.*
FROM migtemp_MedicationSIG AS newdata
LEFT JOIN MedicationSIG AS olddata ON
newdata.MedicationSIGUid = olddata.MedicationSIGUid
WHERE
olddata.MedicationSIGUid IS NULL
GO
DROP TABLE migtemp_MedicationSIG
GO
ALTER TABLE Person NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_Person AS newdata
INNER JOIN Person AS olddata ON
newdata.PersonUid = olddata.PersonUid
GO
INSERT Person
SELECT newdata.*
FROM migtemp_Person AS newdata
LEFT JOIN Person AS olddata ON
newdata.PersonUid = olddata.PersonUid
WHERE
olddata.PersonUid IS NULL
GO
DROP TABLE migtemp_Person
GO
ALTER TABLE PlugInSettings NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_PlugInSettings AS newdata
INNER JOIN PlugInSettings AS olddata ON
newdata.PlugInSettingsUid = olddata.PlugInSettingsUid
GO
INSERT PlugInSettings
SELECT newdata.*
FROM migtemp_PlugInSettings AS newdata
LEFT JOIN PlugInSettings AS olddata ON
newdata.PlugInSettingsUid = olddata.PlugInSettingsUid
WHERE
olddata.PlugInSettingsUid IS NULL
GO
DROP TABLE migtemp_PlugInSettings
GO
ALTER TABLE PQRIDenominator NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[PQRIMeasureUid] = newdata.[PQRIMeasureUid]
, olddata.[CodeTypeMiscUid] = newdata.[CodeTypeMiscUid]
, olddata.[OperativeMiscUid] = newdata.[OperativeMiscUid]
, olddata.[Codes] = newdata.[Codes]
, olddata.[DisplayOrder] = newdata.[DisplayOrder]
FROM migtemp_PQRIDenominator AS newdata
INNER JOIN PQRIDenominator AS olddata ON
newdata.PQRIDenominatorUid = olddata.PQRIDenominatorUid
GO
INSERT PQRIDenominator
SELECT newdata.*
FROM migtemp_PQRIDenominator AS newdata
LEFT JOIN PQRIDenominator AS olddata ON
newdata.PQRIDenominatorUid = olddata.PQRIDenominatorUid
WHERE
olddata.PQRIDenominatorUid IS NULL
GO
DROP TABLE migtemp_PQRIDenominator
GO
ALTER TABLE PQRINumerator NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[PQRIMeasureUid] = newdata.[PQRIMeasureUid]
, olddata.[OperativeMiscUid] = newdata.[OperativeMiscUid]
, olddata.[DisplayOrder] = newdata.[DisplayOrder]
, olddata.[AutoSelect] = newdata.[AutoSelect]
FROM migtemp_PQRINumerator AS newdata
INNER JOIN PQRINumerator AS olddata ON
newdata.PQRINumeratorUid = olddata.PQRINumeratorUid
GO
INSERT PQRINumerator
SELECT newdata.*
FROM migtemp_PQRINumerator AS newdata
LEFT JOIN PQRINumerator AS olddata ON
newdata.PQRINumeratorUid = olddata.PQRINumeratorUid
WHERE
olddata.PQRINumeratorUid IS NULL
GO
DROP TABLE migtemp_PQRINumerator
GO
ALTER TABLE PRMModuleUpdate NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[RunDate] = newdata.[RunDate]
, olddata.[CreateScript] = newdata.[CreateScript]
, olddata.[Type] = newdata.[Type]
, olddata.[TypeDesc] = newdata.[TypeDesc]
, olddata.[CreateDate] = newdata.[CreateDate]
, olddata.[ModifyDate] = newdata.[ModifyDate]
, olddata.[UserDefined] = newdata.[UserDefined]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_PRMModuleUpdate AS newdata
INNER JOIN PRMModuleUpdate AS olddata ON
newdata.PRMModuleUpdateUid = olddata.PRMModuleUpdateUid
GO
INSERT PRMModuleUpdate
SELECT newdata.*
FROM migtemp_PRMModuleUpdate AS newdata
LEFT JOIN PRMModuleUpdate AS olddata ON
newdata.PRMModuleUpdateUid = olddata.PRMModuleUpdateUid
WHERE
olddata.PRMModuleUpdateUid IS NULL
GO
DROP TABLE migtemp_PRMModuleUpdate
GO
ALTER TABLE Provider NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_Provider AS newdata
INNER JOIN Provider AS olddata ON
newdata.PersonUid = olddata.PersonUid
GO
INSERT Provider
SELECT newdata.*
FROM migtemp_Provider AS newdata
LEFT JOIN Provider AS olddata ON
newdata.PersonUid = olddata.PersonUid
WHERE
olddata.PersonUid IS NULL
GO
DROP TABLE migtemp_Provider
GO
ALTER TABLE RelAddInType NOCHECK CONSTRAINT ALL
GO
INSERT RelAddInType
SELECT newdata.*
FROM migtemp_RelAddInType AS newdata
LEFT JOIN RelAddInType AS olddata ON
newdata.RelAddInTypeUid = olddata.RelAddInTypeUid
WHERE
olddata.RelAddInTypeUid IS NULL
GO
DROP TABLE migtemp_RelAddInType
GO
ALTER TABLE RelAnswerGroupAnswer NOCHECK CONSTRAINT ALL
GO
INSERT RelAnswerGroupAnswer
SELECT newdata.*
FROM migtemp_RelAnswerGroupAnswer AS newdata
LEFT JOIN RelAnswerGroupAnswer AS olddata ON
newdata.RelAnswerGroupAnswerUid = olddata.RelAnswerGroupAnswerUid
WHERE
olddata.RelAnswerGroupAnswerUid IS NULL
GO
DROP TABLE migtemp_RelAnswerGroupAnswer
GO
ALTER TABLE RelCCSymptomHpi NOCHECK CONSTRAINT ALL
GO
INSERT RelCCSymptomHpi
SELECT newdata.*
FROM migtemp_RelCCSymptomHpi AS newdata
LEFT JOIN RelCCSymptomHpi AS olddata ON
newdata.RelCCSymptomHpiUid = olddata.RelCCSymptomHpiUid
WHERE
olddata.RelCCSymptomHpiUid IS NULL
GO
DROP TABLE migtemp_RelCCSymptomHpi
GO
ALTER TABLE RelCCSymptomHpiCategory NOCHECK CONSTRAINT ALL
GO
INSERT RelCCSymptomHpiCategory
SELECT newdata.*
FROM migtemp_RelCCSymptomHpiCategory AS newdata
LEFT JOIN RelCCSymptomHpiCategory AS olddata ON
newdata.RelCCSymptomHpiCategoryUid = olddata.RelCCSymptomHpiCategoryUid
WHERE
olddata.RelCCSymptomHpiCategoryUid IS NULL
GO
DROP TABLE migtemp_RelCCSymptomHpiCategory
GO
ALTER TABLE RelCCSystemSymptom NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[LicenseCode] = newdata.[LicenseCode]
FROM migtemp_RelCCSystemSymptom AS newdata
INNER JOIN RelCCSystemSymptom AS olddata ON
newdata.RelCCSystemSymptomUid = olddata.RelCCSystemSymptomUid
GO
INSERT RelCCSystemSymptom
SELECT newdata.*
FROM migtemp_RelCCSystemSymptom AS newdata
LEFT JOIN RelCCSystemSymptom AS olddata ON
newdata.RelCCSystemSymptomUid = olddata.RelCCSystemSymptomUid
WHERE
olddata.RelCCSystemSymptomUid IS NULL
GO
DROP TABLE migtemp_RelCCSystemSymptom
GO
ALTER TABLE RelChargeTicketCategoryDiagnosis NOCHECK CONSTRAINT ALL
GO
INSERT RelChargeTicketCategoryDiagnosis
SELECT newdata.*
FROM migtemp_RelChargeTicketCategoryDiagnosis AS newdata
LEFT JOIN RelChargeTicketCategoryDiagnosis AS olddata ON
newdata.RelChargeTicketCategoryDiagnosisUid = olddata.RelChargeTicketCategoryDiagnosisUid
WHERE
olddata.RelChargeTicketCategoryDiagnosisUid IS NULL
GO
DROP TABLE migtemp_RelChargeTicketCategoryDiagnosis
GO
ALTER TABLE RelChargeTicketCategorySP NOCHECK CONSTRAINT ALL
GO
INSERT RelChargeTicketCategorySP
SELECT newdata.*
FROM migtemp_RelChargeTicketCategorySP AS newdata
LEFT JOIN RelChargeTicketCategorySP AS olddata ON
newdata.RelChargeTicketCategorySPUid = olddata.RelChargeTicketCategorySPUid
WHERE
olddata.RelChargeTicketCategorySPUid IS NULL
GO
DROP TABLE migtemp_RelChargeTicketCategorySP
GO
ALTER TABLE RelChargeTicketDiagnosis NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_RelChargeTicketDiagnosis AS newdata
INNER JOIN RelChargeTicketDiagnosis AS olddata ON
newdata.RelChargeTicketDiagnosisUid = olddata.RelChargeTicketDiagnosisUid
GO
INSERT RelChargeTicketDiagnosis
SELECT newdata.*
FROM migtemp_RelChargeTicketDiagnosis AS newdata
LEFT JOIN RelChargeTicketDiagnosis AS olddata ON
newdata.RelChargeTicketDiagnosisUid = olddata.RelChargeTicketDiagnosisUid
WHERE
olddata.RelChargeTicketDiagnosisUid IS NULL
GO
DROP TABLE migtemp_RelChargeTicketDiagnosis
GO
ALTER TABLE RelChargeTicketSP NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_RelChargeTicketSP AS newdata
INNER JOIN RelChargeTicketSP AS olddata ON
newdata.RelChargeTicketSPUid = olddata.RelChargeTicketSPUid
GO
INSERT RelChargeTicketSP
SELECT newdata.*
FROM migtemp_RelChargeTicketSP AS newdata
LEFT JOIN RelChargeTicketSP AS olddata ON
newdata.RelChargeTicketSPUid = olddata.RelChargeTicketSPUid
WHERE
olddata.RelChargeTicketSPUid IS NULL
GO
DROP TABLE migtemp_RelChargeTicketSP
GO
ALTER TABLE RelClaimFormatValueTypeMisc NOCHECK CONSTRAINT ALL
GO
INSERT RelClaimFormatValueTypeMisc
SELECT newdata.*
FROM migtemp_RelClaimFormatValueTypeMisc AS newdata
LEFT JOIN RelClaimFormatValueTypeMisc AS olddata ON
newdata.RelClaimFormatValueTypeMiscUid = olddata.RelClaimFormatValueTypeMiscUid
WHERE
olddata.RelClaimFormatValueTypeMiscUid IS NULL
GO
DROP TABLE migtemp_RelClaimFormatValueTypeMisc
GO
ALTER TABLE RelDiagnosisDisease NOCHECK CONSTRAINT ALL
GO
INSERT RelDiagnosisDisease
SELECT newdata.*
FROM migtemp_RelDiagnosisDisease AS newdata
LEFT JOIN RelDiagnosisDisease AS olddata ON
newdata.RelDiagnosisDiseaseUid = olddata.RelDiagnosisDiseaseUid
WHERE
olddata.RelDiagnosisDiseaseUid IS NULL
GO
DROP TABLE migtemp_RelDiagnosisDisease
GO
ALTER TABLE RelDiagnosisDpn NOCHECK CONSTRAINT ALL
GO
INSERT RelDiagnosisDpn
SELECT newdata.*
FROM migtemp_RelDiagnosisDpn AS newdata
LEFT JOIN RelDiagnosisDpn AS olddata ON
newdata.RelDiagnosisDpnUid = olddata.RelDiagnosisDpnUid
WHERE
olddata.RelDiagnosisDpnUid IS NULL
GO
DROP TABLE migtemp_RelDiagnosisDpn
GO
ALTER TABLE RelDpnGroupDpnNode NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[IsMultiSelect] = newdata.[IsMultiSelect]
, olddata.[RequiredFlag] = newdata.[RequiredFlag]
FROM migtemp_RelDpnGroupDpnNode AS newdata
INNER JOIN RelDpnGroupDpnNode AS olddata ON
newdata.RelDpnGroupDpnNodeUid = olddata.RelDpnGroupDpnNodeUid
GO
INSERT RelDpnGroupDpnNode
SELECT newdata.*
FROM migtemp_RelDpnGroupDpnNode AS newdata
LEFT JOIN RelDpnGroupDpnNode AS olddata ON
newdata.RelDpnGroupDpnNodeUid = olddata.RelDpnGroupDpnNodeUid
WHERE
olddata.RelDpnGroupDpnNodeUid IS NULL
GO
DROP TABLE migtemp_RelDpnGroupDpnNode
GO
ALTER TABLE RelDpnGroupOrderAction NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_RelDpnGroupOrderAction AS newdata
INNER JOIN RelDpnGroupOrderAction AS olddata ON
newdata.RelDpnGroupOrderActionUid = olddata.RelDpnGroupOrderActionUid
GO
INSERT RelDpnGroupOrderAction
SELECT newdata.*
FROM migtemp_RelDpnGroupOrderAction AS newdata
LEFT JOIN RelDpnGroupOrderAction AS olddata ON
newdata.RelDpnGroupOrderActionUid = olddata.RelDpnGroupOrderActionUid
WHERE
olddata.RelDpnGroupOrderActionUid IS NULL
GO
DROP TABLE migtemp_RelDpnGroupOrderAction
GO
ALTER TABLE RelEduFormAssociation NOCHECK CONSTRAINT ALL
GO
INSERT RelEduFormAssociation
SELECT newdata.*
FROM migtemp_RelEduFormAssociation AS newdata
LEFT JOIN RelEduFormAssociation AS olddata ON
newdata.RelEduFormAssociationUid = olddata.RelEduFormAssociationUid
WHERE
olddata.RelEduFormAssociationUid IS NULL
GO
DROP TABLE migtemp_RelEduFormAssociation
GO
ALTER TABLE RelEduFormCCSymptom NOCHECK CONSTRAINT ALL
GO
INSERT RelEduFormCCSymptom
SELECT newdata.*
FROM migtemp_RelEduFormCCSymptom AS newdata
LEFT JOIN RelEduFormCCSymptom AS olddata ON
newdata.RelEduFormCCSymptomUid = olddata.RelEduFormCCSymptomUid
WHERE
olddata.RelEduFormCCSymptomUid IS NULL
GO
DROP TABLE migtemp_RelEduFormCCSymptom
GO
ALTER TABLE RelEMKeyComponentBullet NOCHECK CONSTRAINT ALL
GO
INSERT RelEMKeyComponentBullet
SELECT newdata.*
FROM migtemp_RelEMKeyComponentBullet AS newdata
LEFT JOIN RelEMKeyComponentBullet AS olddata ON
newdata.RelEMKeyComponentBulletUid = olddata.RelEMKeyComponentBulletUid
WHERE
olddata.RelEMKeyComponentBulletUid IS NULL
GO
DROP TABLE migtemp_RelEMKeyComponentBullet
GO
ALTER TABLE RelFilterNotification NOCHECK CONSTRAINT ALL
GO
INSERT RelFilterNotification
SELECT newdata.*
FROM migtemp_RelFilterNotification AS newdata
LEFT JOIN RelFilterNotification AS olddata ON
newdata.FilterNotificationUid = olddata.FilterNotificationUid
WHERE
olddata.FilterNotificationUid IS NULL
GO
DROP TABLE migtemp_RelFilterNotification
GO
ALTER TABLE RelFormLayoutClinicalNoteType NOCHECK CONSTRAINT ALL
GO
INSERT RelFormLayoutClinicalNoteType
SELECT newdata.*
FROM migtemp_RelFormLayoutClinicalNoteType AS newdata
LEFT JOIN RelFormLayoutClinicalNoteType AS olddata ON
newdata.RelFormLayoutClinicalNoteTypeUid = olddata.RelFormLayoutClinicalNoteTypeUid
WHERE
olddata.RelFormLayoutClinicalNoteTypeUid IS NULL
GO
DROP TABLE migtemp_RelFormLayoutClinicalNoteType
GO
ALTER TABLE RelFormLayoutProcedure NOCHECK CONSTRAINT ALL
GO
INSERT RelFormLayoutProcedure
SELECT newdata.*
FROM migtemp_RelFormLayoutProcedure AS newdata
LEFT JOIN RelFormLayoutProcedure AS olddata ON
newdata.RelFormLayoutProcedureUid = olddata.RelFormLayoutProcedureUid
WHERE
olddata.RelFormLayoutProcedureUid IS NULL
GO
DROP TABLE migtemp_RelFormLayoutProcedure
GO
ALTER TABLE RelHMRuleDisease NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_RelHMRuleDisease AS newdata
INNER JOIN RelHMRuleDisease AS olddata ON
newdata.RelHMRuleDiseaseUid = olddata.RelHMRuleDiseaseUid
GO
INSERT RelHMRuleDisease
SELECT newdata.*
FROM migtemp_RelHMRuleDisease AS newdata
LEFT JOIN RelHMRuleDisease AS olddata ON
newdata.RelHMRuleDiseaseUid = olddata.RelHMRuleDiseaseUid
WHERE
olddata.RelHMRuleDiseaseUid IS NULL
GO
DROP TABLE migtemp_RelHMRuleDisease
GO
ALTER TABLE RelHMRuleDrugClass NOCHECK CONSTRAINT ALL
GO
INSERT RelHMRuleDrugClass
SELECT newdata.*
FROM migtemp_RelHMRuleDrugClass AS newdata
LEFT JOIN RelHMRuleDrugClass AS olddata ON
newdata.RelHMRuleDrugClassUid = olddata.RelHMRuleDrugClassUid
WHERE
olddata.RelHMRuleDrugClassUid IS NULL
GO
DROP TABLE migtemp_RelHMRuleDrugClass
GO
ALTER TABLE RelHMRuleGender NOCHECK CONSTRAINT ALL
GO
INSERT RelHMRuleGender
SELECT newdata.*
FROM migtemp_RelHMRuleGender AS newdata
LEFT JOIN RelHMRuleGender AS olddata ON
newdata.RelHMRuleGenderUid = olddata.RelHMRuleGenderUid
WHERE
olddata.RelHMRuleGenderUid IS NULL
GO
DROP TABLE migtemp_RelHMRuleGender
GO
ALTER TABLE RelHMRuleProcedure NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_RelHMRuleProcedure AS newdata
INNER JOIN RelHMRuleProcedure AS olddata ON
newdata.RelHMRuleProcedureUid = olddata.RelHMRuleProcedureUid
GO
INSERT RelHMRuleProcedure
SELECT newdata.*
FROM migtemp_RelHMRuleProcedure AS newdata
LEFT JOIN RelHMRuleProcedure AS olddata ON
newdata.RelHMRuleProcedureUid = olddata.RelHMRuleProcedureUid
WHERE
olddata.RelHMRuleProcedureUid IS NULL
GO
DROP TABLE migtemp_RelHMRuleProcedure
GO
ALTER TABLE RelLockParentTypeLockConcept NOCHECK CONSTRAINT ALL
GO
INSERT RelLockParentTypeLockConcept
SELECT newdata.*
FROM migtemp_RelLockParentTypeLockConcept AS newdata
LEFT JOIN RelLockParentTypeLockConcept AS olddata ON
newdata.RelLockParentTypeLockConceptUid = olddata.RelLockParentTypeLockConceptUid
WHERE
olddata.RelLockParentTypeLockConceptUid IS NULL
GO
DROP TABLE migtemp_RelLockParentTypeLockConcept
GO
ALTER TABLE RelMacroGroupSecurity NOCHECK CONSTRAINT ALL
GO
INSERT RelMacroGroupSecurity
SELECT newdata.*
FROM migtemp_RelMacroGroupSecurity AS newdata
LEFT JOIN RelMacroGroupSecurity AS olddata ON
newdata.MacroGroupSecurityUid = olddata.MacroGroupSecurityUid
WHERE
olddata.MacroGroupSecurityUid IS NULL
GO
DROP TABLE migtemp_RelMacroGroupSecurity
GO
ALTER TABLE RelMacroTextEditor NOCHECK CONSTRAINT ALL
GO
INSERT RelMacroTextEditor
SELECT newdata.*
FROM migtemp_RelMacroTextEditor AS newdata
LEFT JOIN RelMacroTextEditor AS olddata ON
newdata.MacroEditorUid = olddata.MacroEditorUid
WHERE
olddata.MacroEditorUid IS NULL
GO
DROP TABLE migtemp_RelMacroTextEditor
GO
ALTER TABLE RelObservationCustomUser NOCHECK CONSTRAINT ALL
GO
INSERT RelObservationCustomUser
SELECT newdata.*
FROM migtemp_RelObservationCustomUser AS newdata
LEFT JOIN RelObservationCustomUser AS olddata ON
newdata.RelObservationCustomUserUid = olddata.RelObservationCustomUserUid
WHERE
olddata.RelObservationCustomUserUid IS NULL
GO
DROP TABLE migtemp_RelObservationCustomUser
GO
ALTER TABLE RelObservationGroupObservation NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_RelObservationGroupObservation AS newdata
INNER JOIN RelObservationGroupObservation AS olddata ON
newdata.RelObservationGroupObservationUid = olddata.RelObservationGroupObservationUid
GO
INSERT RelObservationGroupObservation
SELECT newdata.*
FROM migtemp_RelObservationGroupObservation AS newdata
LEFT JOIN RelObservationGroupObservation AS olddata ON
newdata.RelObservationGroupObservationUid = olddata.RelObservationGroupObservationUid
WHERE
olddata.RelObservationGroupObservationUid IS NULL
GO
DROP TABLE migtemp_RelObservationGroupObservation
GO
ALTER TABLE RelObservationObservationItem NOCHECK CONSTRAINT ALL
GO
INSERT RelObservationObservationItem
SELECT newdata.*
FROM migtemp_RelObservationObservationItem AS newdata
LEFT JOIN RelObservationObservationItem AS olddata ON
newdata.RelObservationObservationItemUid = olddata.RelObservationObservationItemUid
WHERE
olddata.RelObservationObservationItemUid IS NULL
GO
DROP TABLE migtemp_RelObservationObservationItem
GO
ALTER TABLE RelPETemplateDescription NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[DisplayOrder] = newdata.[DisplayOrder]
FROM migtemp_RelPETemplateDescription AS newdata
INNER JOIN RelPETemplateDescription AS olddata ON
newdata.RelPETemplateDescriptionUid = olddata.RelPETemplateDescriptionUid
GO
INSERT RelPETemplateDescription
SELECT newdata.*
FROM migtemp_RelPETemplateDescription AS newdata
LEFT JOIN RelPETemplateDescription AS olddata ON
newdata.RelPETemplateDescriptionUid = olddata.RelPETemplateDescriptionUid
WHERE
olddata.RelPETemplateDescriptionUid IS NULL
GO
DROP TABLE migtemp_RelPETemplateDescription
GO
ALTER TABLE RelPETemplateParentSystem NOCHECK CONSTRAINT ALL
GO
INSERT RelPETemplateParentSystem
SELECT newdata.*
FROM migtemp_RelPETemplateParentSystem AS newdata
LEFT JOIN RelPETemplateParentSystem AS olddata ON
newdata.RelPETemplateParentSystemUid = olddata.RelPETemplateParentSystemUid
WHERE
olddata.RelPETemplateParentSystemUid IS NULL
GO
DROP TABLE migtemp_RelPETemplateParentSystem
GO
ALTER TABLE RelPETemplateSymptom NOCHECK CONSTRAINT ALL
GO
INSERT RelPETemplateSymptom
SELECT newdata.*
FROM migtemp_RelPETemplateSymptom AS newdata
LEFT JOIN RelPETemplateSymptom AS olddata ON
newdata.RelPETemplateSymptomUid = olddata.RelPETemplateSymptomUid
WHERE
olddata.RelPETemplateSymptomUid IS NULL
GO
DROP TABLE migtemp_RelPETemplateSymptom
GO
ALTER TABLE RelPETemplateSystem NOCHECK CONSTRAINT ALL
GO
INSERT RelPETemplateSystem
SELECT newdata.*
FROM migtemp_RelPETemplateSystem AS newdata
LEFT JOIN RelPETemplateSystem AS olddata ON
newdata.RelPETemplateSystemUid = olddata.RelPETemplateSystemUid
WHERE
olddata.RelPETemplateSystemUid IS NULL
GO
DROP TABLE migtemp_RelPETemplateSystem
GO
ALTER TABLE RelPQRIMeasurePQRIGroup NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[PQRIGroupUid] = newdata.[PQRIGroupUid]
, olddata.[PQRIMeasureUid] = newdata.[PQRIMeasureUid]
FROM migtemp_RelPQRIMeasurePQRIGroup AS newdata
INNER JOIN RelPQRIMeasurePQRIGroup AS olddata ON
newdata.RelPQRIMeasurePQRIGroupUid = olddata.RelPQRIMeasurePQRIGroupUid
GO
INSERT RelPQRIMeasurePQRIGroup
SELECT newdata.*
FROM migtemp_RelPQRIMeasurePQRIGroup AS newdata
LEFT JOIN RelPQRIMeasurePQRIGroup AS olddata ON
newdata.RelPQRIMeasurePQRIGroupUid = olddata.RelPQRIMeasurePQRIGroupUid
WHERE
olddata.RelPQRIMeasurePQRIGroupUid IS NULL
GO
DROP TABLE migtemp_RelPQRIMeasurePQRIGroup
GO
ALTER TABLE RelPrmRulePrmAction NOCHECK CONSTRAINT ALL
GO
INSERT RelPrmRulePrmAction
SELECT newdata.*
FROM migtemp_RelPrmRulePrmAction AS newdata
LEFT JOIN RelPrmRulePrmAction AS olddata ON
newdata.RelPrmRulePrmActionUid = olddata.RelPrmRulePrmActionUid
WHERE
olddata.RelPrmRulePrmActionUid IS NULL
GO
DROP TABLE migtemp_RelPrmRulePrmAction
GO
ALTER TABLE RelPrmRulePrmCondition NOCHECK CONSTRAINT ALL
GO
INSERT RelPrmRulePrmCondition
SELECT newdata.*
FROM migtemp_RelPrmRulePrmCondition AS newdata
LEFT JOIN RelPrmRulePrmCondition AS olddata ON
newdata.RelPrmRulePrmConditionUid = olddata.RelPrmRulePrmConditionUid
WHERE
olddata.RelPrmRulePrmConditionUid IS NULL
GO
DROP TABLE migtemp_RelPrmRulePrmCondition
GO
ALTER TABLE RelProcedureDpn NOCHECK CONSTRAINT ALL
GO
INSERT RelProcedureDpn
SELECT newdata.*
FROM migtemp_RelProcedureDpn AS newdata
LEFT JOIN RelProcedureDpn AS olddata ON
newdata.RelProcedureDpnUid = olddata.RelProcedureDpnUid
WHERE
olddata.RelProcedureDpnUid IS NULL
GO
DROP TABLE migtemp_RelProcedureDpn
GO
ALTER TABLE RelProcedureHistoryTermProcedure NOCHECK CONSTRAINT ALL
GO
INSERT RelProcedureHistoryTermProcedure
SELECT newdata.*
FROM migtemp_RelProcedureHistoryTermProcedure AS newdata
LEFT JOIN RelProcedureHistoryTermProcedure AS olddata ON
newdata.RelProcedureHistoryTermProcedureUid = olddata.RelProcedureHistoryTermProcedureUid
WHERE
olddata.RelProcedureHistoryTermProcedureUid IS NULL
GO
DROP TABLE migtemp_RelProcedureHistoryTermProcedure
GO
ALTER TABLE RelProcedureTypeofVaccine NOCHECK CONSTRAINT ALL
GO
INSERT RelProcedureTypeofVaccine
SELECT newdata.*
FROM migtemp_RelProcedureTypeofVaccine AS newdata
LEFT JOIN RelProcedureTypeofVaccine AS olddata ON
newdata.RelProcedureTypeofVaccineUid = olddata.RelProcedureTypeofVaccineUid
WHERE
olddata.RelProcedureTypeofVaccineUid IS NULL
GO
DROP TABLE migtemp_RelProcedureTypeofVaccine
GO
ALTER TABLE RelQuestionAnswerSnomed NOCHECK CONSTRAINT ALL
GO
INSERT RelQuestionAnswerSnomed
SELECT newdata.*
FROM migtemp_RelQuestionAnswerSnomed AS newdata
LEFT JOIN RelQuestionAnswerSnomed AS olddata ON
newdata.RelQuestionAnswerSnomedUid = olddata.RelQuestionAnswerSnomedUid
WHERE
olddata.RelQuestionAnswerSnomedUid IS NULL
GO
DROP TABLE migtemp_RelQuestionAnswerSnomed
GO
ALTER TABLE RelReportContextReportType NOCHECK CONSTRAINT ALL
GO
INSERT RelReportContextReportType
SELECT newdata.*
FROM migtemp_RelReportContextReportType AS newdata
LEFT JOIN RelReportContextReportType AS olddata ON
newdata.RelReportContextReportTypeUid = olddata.RelReportContextReportTypeUid
WHERE
olddata.RelReportContextReportTypeUid IS NULL
GO
DROP TABLE migtemp_RelReportContextReportType
GO
ALTER TABLE RelRosSystemSymptom NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_RelRosSystemSymptom AS newdata
INNER JOIN RelRosSystemSymptom AS olddata ON
newdata.RelRosSystemSymptomUid = olddata.RelRosSystemSymptomUid
GO
INSERT RelRosSystemSymptom
SELECT newdata.*
FROM migtemp_RelRosSystemSymptom AS newdata
LEFT JOIN RelRosSystemSymptom AS olddata ON
newdata.RelRosSystemSymptomUid = olddata.RelRosSystemSymptomUid
WHERE
olddata.RelRosSystemSymptomUid IS NULL
GO
DROP TABLE migtemp_RelRosSystemSymptom
GO
ALTER TABLE RelScrubItemScrubProfile NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_RelScrubItemScrubProfile AS newdata
INNER JOIN RelScrubItemScrubProfile AS olddata ON
newdata.RelScrubItemScrubProfileUid = olddata.RelScrubItemScrubProfileUid
GO
INSERT RelScrubItemScrubProfile
SELECT newdata.*
FROM migtemp_RelScrubItemScrubProfile AS newdata
LEFT JOIN RelScrubItemScrubProfile AS olddata ON
newdata.RelScrubItemScrubProfileUid = olddata.RelScrubItemScrubProfileUid
WHERE
olddata.RelScrubItemScrubProfileUid IS NULL
GO
DROP TABLE migtemp_RelScrubItemScrubProfile
GO
ALTER TABLE RelSurveyAnswerGroupSurveyAnswer NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[SurveyAnswerGroupUid] = newdata.[SurveyAnswerGroupUid]
, olddata.[SurveyAnswerUid] = newdata.[SurveyAnswerUid]
, olddata.[RequireSurveySectionUid] = newdata.[RequireSurveySectionUid]
, olddata.[NextSurveyQuestionUid] = newdata.[NextSurveyQuestionUid]
FROM migtemp_RelSurveyAnswerGroupSurveyAnswer AS newdata
INNER JOIN RelSurveyAnswerGroupSurveyAnswer AS olddata ON
newdata.RelSurveyAnswerGroupSurveyAnswerUid = olddata.RelSurveyAnswerGroupSurveyAnswerUid
GO
INSERT RelSurveyAnswerGroupSurveyAnswer
SELECT newdata.*
FROM migtemp_RelSurveyAnswerGroupSurveyAnswer AS newdata
LEFT JOIN RelSurveyAnswerGroupSurveyAnswer AS olddata ON
newdata.RelSurveyAnswerGroupSurveyAnswerUid = olddata.RelSurveyAnswerGroupSurveyAnswerUid
WHERE
olddata.RelSurveyAnswerGroupSurveyAnswerUid IS NULL
GO
DROP TABLE migtemp_RelSurveyAnswerGroupSurveyAnswer
GO
ALTER TABLE RelSurveyAnswerGroupSurveyQuestion NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[RelSurveyAnswerGroupSurveyAnswerUid] = newdata.[RelSurveyAnswerGroupSurveyAnswerUid]
, olddata.[SurveyQuestionUid] = newdata.[SurveyQuestionUid]
FROM migtemp_RelSurveyAnswerGroupSurveyQuestion AS newdata
INNER JOIN RelSurveyAnswerGroupSurveyQuestion AS olddata ON
newdata.RelSurveyAnswerGroupSurveyQuestionUid = olddata.RelSurveyAnswerGroupSurveyQuestionUid
GO
INSERT RelSurveyAnswerGroupSurveyQuestion
SELECT newdata.*
FROM migtemp_RelSurveyAnswerGroupSurveyQuestion AS newdata
LEFT JOIN RelSurveyAnswerGroupSurveyQuestion AS olddata ON
newdata.RelSurveyAnswerGroupSurveyQuestionUid = olddata.RelSurveyAnswerGroupSurveyQuestionUid
WHERE
olddata.RelSurveyAnswerGroupSurveyQuestionUid IS NULL
GO
DROP TABLE migtemp_RelSurveyAnswerGroupSurveyQuestion
GO
ALTER TABLE RelSurveySectionSurveyQuestion NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[SurveySectionUid] = newdata.[SurveySectionUid]
, olddata.[SurveyQuestionUid] = newdata.[SurveyQuestionUid]
FROM migtemp_RelSurveySectionSurveyQuestion AS newdata
INNER JOIN RelSurveySectionSurveyQuestion AS olddata ON
newdata.RelSurveySectionSurveyQuestionUid = olddata.RelSurveySectionSurveyQuestionUid
GO
INSERT RelSurveySectionSurveyQuestion
SELECT newdata.*
FROM migtemp_RelSurveySectionSurveyQuestion AS newdata
LEFT JOIN RelSurveySectionSurveyQuestion AS olddata ON
newdata.RelSurveySectionSurveyQuestionUid = olddata.RelSurveySectionSurveyQuestionUid
WHERE
olddata.RelSurveySectionSurveyQuestionUid IS NULL
GO
DROP TABLE migtemp_RelSurveySectionSurveyQuestion
GO
ALTER TABLE RelSurveySurveySection NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[SurveyUid] = newdata.[SurveyUid]
, olddata.[SurveySectionUid] = newdata.[SurveySectionUid]
, olddata.[SectionOptional] = newdata.[SectionOptional]
, olddata.[IsDependentSection] = newdata.[IsDependentSection]
FROM migtemp_RelSurveySurveySection AS newdata
INNER JOIN RelSurveySurveySection AS olddata ON
newdata.RelSurveySurveySectionUid = olddata.RelSurveySurveySectionUid
GO
INSERT RelSurveySurveySection
SELECT newdata.*
FROM migtemp_RelSurveySurveySection AS newdata
LEFT JOIN RelSurveySurveySection AS olddata ON
newdata.RelSurveySurveySectionUid = olddata.RelSurveySurveySectionUid
WHERE
olddata.RelSurveySurveySectionUid IS NULL
GO
DROP TABLE migtemp_RelSurveySurveySection
GO
ALTER TABLE RelTypeofVaccineTypeofVaccineElement NOCHECK CONSTRAINT ALL
GO
INSERT RelTypeofVaccineTypeofVaccineElement
SELECT newdata.*
FROM migtemp_RelTypeofVaccineTypeofVaccineElement AS newdata
LEFT JOIN RelTypeofVaccineTypeofVaccineElement AS olddata ON
newdata.RelTypeofVaccineTypeofVaccineElementUid = olddata.RelTypeofVaccineTypeofVaccineElementUid
WHERE
olddata.RelTypeofVaccineTypeofVaccineElementUid IS NULL
GO
DROP TABLE migtemp_RelTypeofVaccineTypeofVaccineElement
GO
ALTER TABLE RelUIConfigurationGroupUIConfiguration NOCHECK CONSTRAINT ALL
GO
INSERT RelUIConfigurationGroupUIConfiguration
SELECT newdata.*
FROM migtemp_RelUIConfigurationGroupUIConfiguration AS newdata
LEFT JOIN RelUIConfigurationGroupUIConfiguration AS olddata ON
newdata.RelUIConfigurationGroupUIConfigurationUid = olddata.RelUIConfigurationGroupUIConfigurationUid
WHERE
olddata.RelUIConfigurationGroupUIConfigurationUid IS NULL
GO
DROP TABLE migtemp_RelUIConfigurationGroupUIConfiguration
GO
ALTER TABLE RelVaccineDisplayCols NOCHECK CONSTRAINT ALL
GO
INSERT RelVaccineDisplayCols
SELECT newdata.*
FROM migtemp_RelVaccineDisplayCols AS newdata
LEFT JOIN RelVaccineDisplayCols AS olddata ON
newdata.RelVaccineDisplayColsUid = olddata.RelVaccineDisplayColsUid
WHERE
olddata.RelVaccineDisplayColsUid IS NULL
GO
DROP TABLE migtemp_RelVaccineDisplayCols
GO
ALTER TABLE RelVaccinePrintCols NOCHECK CONSTRAINT ALL
GO
INSERT RelVaccinePrintCols
SELECT newdata.*
FROM migtemp_RelVaccinePrintCols AS newdata
LEFT JOIN RelVaccinePrintCols AS olddata ON
newdata.RelVaccinePrintColsUid = olddata.RelVaccinePrintColsUid
WHERE
olddata.RelVaccinePrintColsUid IS NULL
GO
DROP TABLE migtemp_RelVaccinePrintCols
GO
ALTER TABLE RelVaccineTypeofVaccine NOCHECK CONSTRAINT ALL
GO
INSERT RelVaccineTypeofVaccine
SELECT newdata.*
FROM migtemp_RelVaccineTypeofVaccine AS newdata
LEFT JOIN RelVaccineTypeofVaccine AS olddata ON
newdata.RelVaccineTypeofVaccineUid = olddata.RelVaccineTypeofVaccineUid
WHERE
olddata.RelVaccineTypeofVaccineUid IS NULL
GO
DROP TABLE migtemp_RelVaccineTypeofVaccine
GO
ALTER TABLE RemarkCategory NOCHECK CONSTRAINT ALL
GO
INSERT RemarkCategory
SELECT newdata.*
FROM migtemp_RemarkCategory AS newdata
LEFT JOIN RemarkCategory AS olddata ON
newdata.RemarkCategoryUid = olddata.RemarkCategoryUid
WHERE
olddata.RemarkCategoryUid IS NULL
GO
DROP TABLE migtemp_RemarkCategory
GO
ALTER TABLE RemarkType NOCHECK CONSTRAINT ALL
GO
INSERT RemarkType
SELECT newdata.*
FROM migtemp_RemarkType AS newdata
LEFT JOIN RemarkType AS olddata ON
newdata.RemarkTypeUid = olddata.RemarkTypeUid
WHERE
olddata.RemarkTypeUid IS NULL
GO
DROP TABLE migtemp_RemarkType
GO
ALTER TABLE ReplicationSettings NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ReplicationSettings AS newdata
INNER JOIN ReplicationSettings AS olddata ON
newdata.ReplicationSettingsUid = olddata.ReplicationSettingsUid
GO
INSERT ReplicationSettings
SELECT newdata.*
FROM migtemp_ReplicationSettings AS newdata
LEFT JOIN ReplicationSettings AS olddata ON
newdata.ReplicationSettingsUid = olddata.ReplicationSettingsUid
WHERE
olddata.ReplicationSettingsUid IS NULL
GO
DROP TABLE migtemp_ReplicationSettings
GO
ALTER TABLE RosSystem NOCHECK CONSTRAINT ALL
GO
INSERT RosSystem
SELECT newdata.*
FROM migtemp_RosSystem AS newdata
LEFT JOIN RosSystem AS olddata ON
newdata.RosSystemUid = olddata.RosSystemUid
WHERE
olddata.RosSystemUid IS NULL
GO
DROP TABLE migtemp_RosSystem
GO
ALTER TABLE ScantronDemographicsSurvey NOCHECK CONSTRAINT ALL
GO
INSERT ScantronDemographicsSurvey
SELECT newdata.*
FROM migtemp_ScantronDemographicsSurvey AS newdata
LEFT JOIN ScantronDemographicsSurvey AS olddata ON
newdata.ScantronDemographicsSurveyUid = olddata.ScantronDemographicsSurveyUid
WHERE
olddata.ScantronDemographicsSurveyUid IS NULL
GO
DROP TABLE migtemp_ScantronDemographicsSurvey
GO
ALTER TABLE SecurityUserGroup NOCHECK CONSTRAINT ALL
GO
INSERT SecurityUserGroup
SELECT newdata.*
FROM migtemp_SecurityUserGroup AS newdata
LEFT JOIN SecurityUserGroup AS olddata ON
newdata.SecurityUserGroupUid = olddata.SecurityUserGroupUid
WHERE
olddata.SecurityUserGroupUid IS NULL
GO
DROP TABLE migtemp_SecurityUserGroup
GO
ALTER TABLE SIGDetail NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[MedicationSIGUid] = newdata.[MedicationSIGUid]
, olddata.[DispensableUid] = newdata.[DispensableUid]
, olddata.[DosageQuantity] = newdata.[DosageQuantity]
, olddata.[DosageUnit] = newdata.[DosageUnit]
, olddata.[Frequency] = newdata.[Frequency]
, olddata.[Quantity] = newdata.[Quantity]
, olddata.[ItemStartDate] = newdata.[ItemStartDate]
, olddata.[ItemStopDate] = newdata.[ItemStopDate]
, olddata.[Duration] = newdata.[Duration]
, olddata.[Comment] = newdata.[Comment]
, olddata.[DisplayOrder] = newdata.[DisplayOrder]
FROM migtemp_SIGDetail AS newdata
INNER JOIN SIGDetail AS olddata ON
newdata.SIGDetailUid = olddata.SIGDetailUid
GO
INSERT SIGDetail
SELECT newdata.*
FROM migtemp_SIGDetail AS newdata
LEFT JOIN SIGDetail AS olddata ON
newdata.SIGDetailUid = olddata.SIGDetailUid
WHERE
olddata.SIGDetailUid IS NULL
GO
DROP TABLE migtemp_SIGDetail
GO
ALTER TABLE SpecialtyCpp NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_SpecialtyCpp AS newdata
INNER JOIN SpecialtyCpp AS olddata ON
newdata.SpecialtyCppUid = olddata.SpecialtyCppUid
GO
INSERT SpecialtyCpp
SELECT newdata.*
FROM migtemp_SpecialtyCpp AS newdata
LEFT JOIN SpecialtyCpp AS olddata ON
newdata.SpecialtyCppUid = olddata.SpecialtyCppUid
WHERE
olddata.SpecialtyCppUid IS NULL
GO
DROP TABLE migtemp_SpecialtyCpp
GO
ALTER TABLE StatementAction NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_StatementAction AS newdata
INNER JOIN StatementAction AS olddata ON
newdata.StatementActionUid = olddata.StatementActionUid
GO
INSERT StatementAction
SELECT newdata.*
FROM migtemp_StatementAction AS newdata
LEFT JOIN StatementAction AS olddata ON
newdata.StatementActionUid = olddata.StatementActionUid
WHERE
olddata.StatementActionUid IS NULL
GO
DROP TABLE migtemp_StatementAction
GO
ALTER TABLE SubFindTable NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_SubFindTable AS newdata
INNER JOIN SubFindTable AS olddata ON
newdata.SubFindTableUid = olddata.SubFindTableUid
GO
INSERT SubFindTable
SELECT newdata.*
FROM migtemp_SubFindTable AS newdata
LEFT JOIN SubFindTable AS olddata ON
newdata.SubFindTableUid = olddata.SubFindTableUid
WHERE
olddata.SubFindTableUid IS NULL
GO
DROP TABLE migtemp_SubFindTable
GO
ALTER TABLE SubFindTableItem NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_SubFindTableItem AS newdata
INNER JOIN SubFindTableItem AS olddata ON
newdata.SubFindTableItemUid = olddata.SubFindTableItemUid
GO
INSERT SubFindTableItem
SELECT newdata.*
FROM migtemp_SubFindTableItem AS newdata
LEFT JOIN SubFindTableItem AS olddata ON
newdata.SubFindTableItemUid = olddata.SubFindTableItemUid
WHERE
olddata.SubFindTableItemUid IS NULL
GO
DROP TABLE migtemp_SubFindTableItem
GO
ALTER TABLE Translation NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_Translation AS newdata
INNER JOIN Translation AS olddata ON
newdata.TranslationUid = olddata.TranslationUid
GO
INSERT Translation
SELECT newdata.*
FROM migtemp_Translation AS newdata
LEFT JOIN Translation AS olddata ON
newdata.TranslationUid = olddata.TranslationUid
WHERE
olddata.TranslationUid IS NULL
GO
DROP TABLE migtemp_Translation
GO
ALTER TABLE TransmissionConfiguration NOCHECK CONSTRAINT ALL
GO
INSERT TransmissionConfiguration
SELECT newdata.*
FROM migtemp_TransmissionConfiguration AS newdata
LEFT JOIN TransmissionConfiguration AS olddata ON
newdata.TransmissionConfigurationUid = olddata.TransmissionConfigurationUid
WHERE
olddata.TransmissionConfigurationUid IS NULL
GO
DROP TABLE migtemp_TransmissionConfiguration
GO
ALTER TABLE UIConfigurationHistory NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_UIConfigurationHistory AS newdata
INNER JOIN UIConfigurationHistory AS olddata ON
newdata.UIConfigurationHistoryUid = olddata.UIConfigurationHistoryUid
GO
INSERT UIConfigurationHistory
SELECT newdata.*
FROM migtemp_UIConfigurationHistory AS newdata
LEFT JOIN UIConfigurationHistory AS olddata ON
newdata.UIConfigurationHistoryUid = olddata.UIConfigurationHistoryUid
WHERE
olddata.UIConfigurationHistoryUid IS NULL
GO
DROP TABLE migtemp_UIConfigurationHistory
GO
ALTER TABLE UIConfigurationHistoryData NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
, olddata.[Data] = newdata.[Data]
FROM migtemp_UIConfigurationHistoryData AS newdata
INNER JOIN UIConfigurationHistoryData AS olddata ON
newdata.UIConfigurationHistoryDataUid = olddata.UIConfigurationHistoryDataUid
GO
INSERT UIConfigurationHistoryData
SELECT newdata.*
FROM migtemp_UIConfigurationHistoryData AS newdata
LEFT JOIN UIConfigurationHistoryData AS olddata ON
newdata.UIConfigurationHistoryDataUid = olddata.UIConfigurationHistoryDataUid
WHERE
olddata.UIConfigurationHistoryDataUid IS NULL
GO
DROP TABLE migtemp_UIConfigurationHistoryData
GO
ALTER TABLE UserGroupMember NOCHECK CONSTRAINT ALL
GO
INSERT UserGroupMember
SELECT newdata.*
FROM migtemp_UserGroupMember AS newdata
LEFT JOIN UserGroupMember AS olddata ON
newdata.ExtentUserGroupUid = olddata.ExtentUserGroupUid
WHERE
olddata.ExtentUserGroupUid IS NULL
GO
DROP TABLE migtemp_UserGroupMember
GO
ALTER TABLE VaccineAdminItem NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_VaccineAdminItem AS newdata
INNER JOIN VaccineAdminItem AS olddata ON
newdata.VaccineAdminItemUid = olddata.VaccineAdminItemUid
GO
INSERT VaccineAdminItem
SELECT newdata.*
FROM migtemp_VaccineAdminItem AS newdata
LEFT JOIN VaccineAdminItem AS olddata ON
newdata.VaccineAdminItemUid = olddata.VaccineAdminItemUid
WHERE
olddata.VaccineAdminItemUid IS NULL
GO
DROP TABLE migtemp_VaccineAdminItem
GO
ALTER TABLE VaccineUnitUse NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_VaccineUnitUse AS newdata
INNER JOIN VaccineUnitUse AS olddata ON
newdata.VaccineUnitUseUid = olddata.VaccineUnitUseUid
GO
INSERT VaccineUnitUse
SELECT newdata.*
FROM migtemp_VaccineUnitUse AS newdata
LEFT JOIN VaccineUnitUse AS olddata ON
newdata.VaccineUnitUseUid = olddata.VaccineUnitUseUid
WHERE
olddata.VaccineUnitUseUid IS NULL
GO
DROP TABLE migtemp_VaccineUnitUse
GO
ALTER TABLE Attachment WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE AttachmentGroup WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE CCSystem WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ChcListAgriculturalWorkStatus WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ChcListCitizenship WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ChcListContractTypeCode WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ChcListEducation WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ChcListFinancialClass WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ChcListFPLRegion WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ChcListFPLSchedule WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ChcListHomelessStatus WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ChcListPayorPlanSet WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ChcListPayorPlanSetRange WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ChcListPayorPlanType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ChcListPrimaryInsType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ChcListPriorMedical WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ChcListProcedureModifierType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ChcListReferralSource WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ChcListSFFormOfDeclaration WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ChcListSFSchedule WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ChcListVeteranStatus WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ClaimFormatOption WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ClaimFormatValue WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ClinicCenterSettings WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE CollectionStatusGlobal WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE CollectionStatusLevel WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE Corporation WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE CppCC WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE CppDiagnosis WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE CppHpi WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE CppMedication WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE CppSP WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE CVXVISMap WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE DefaultMedicationUnit WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE EmailUnsubscribeGroup WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE EMMapping WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE eRSDTriggerCodes WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ExternalMaterialSource WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ExternalMaterialSourceCategory WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE EZPAYBINTEST WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE EZPAYCONNECTION_SETTINGS WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE EZPAYERROR_CODES WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE EZPAYMERCHANT_SETTINGS WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE FeeSchedule WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE FeeScheduleFee WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE FeeSchedulePeriod WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE FinancialCenter WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE HL7MappedField WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE HL7MappedSegment WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE HL7Partner WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE HL7PartnerMessage WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE HMRuleObservationTest WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE InterfaceDataMapping WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE JobSchedule WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListAccountType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListAddIn WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListAddInType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListAdmissionSource WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListAdmissionType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListAgeGroup WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListAmendmentSource WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListAnswer WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListAnswerGroup WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListAppointmentStatus WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListAppointmentType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListARRAReports WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListAttachmentHandler WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListAttachmentType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListAuditEventConfiguration WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListBatchProcessType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListBillTimeRule WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListBloodPressureMethods WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListCaseModule WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListCaseType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListCaseTypeModule WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListCaseTypePhase WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListCategoryCode WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListCDASection WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListChargeTicketDiagnosis WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListChargeTicketSP WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListClaimBatchStatus WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListClaimClearingHouse WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListClaimFormat WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListClaimFormatOptionType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListClaimFormatType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListClaimFormatValueType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListClaimFormatValueTypeType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListClaimFormLayout WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListClaimHeaderNoteCode WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListClaimReportStatus WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListClaimStatusPayer WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListClinicalNoteType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListClinicCenter WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListCodeValidationCarrierMap WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListCollectionStatus WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListCompression WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListConditionalOperator WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListConditionCode WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListContextReportType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListContractTypeCode WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListControlType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListCoverageType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListCpp WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListCppGroup WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListCQM WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListCreditCard WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListCreditType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListCustomNotePrint WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListCVXCode WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListDataFormatter WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListDecileCQM WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListDegreeRelated WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListDelayReason WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListDepositMacro WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListDesktopControl WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListDiagnosisCategory WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListDiagnosisSearchDefinition WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListDiet WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListDisclosureReason WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListDiscontinueReason WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListDisease WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListDiseaseGroup WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListDocumentLinkingFolderType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListDominantHand WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListDpnGroup WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListDpnNode WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListDxTileConfiguration WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListEditorControlLaunchContext WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListEduForm WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListEduFormAssociation WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListElectronicPayer WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListEligibilityAAAErrorCode WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListEligibilityCoverageLevel WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListEligibilityFollowUpActionCode WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListEligibilityServiceType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListEligibilityStatus WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListEMBullet WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListEMConfiguration WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListEmergencyIndicator WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListEMExaminationDescription WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListEMKeyComponent WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListEmploymentStatus WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListEMServiceSite WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListEMSystemBodyArea WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListEPSDTReferralCondIndicator WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListERACode WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListeRxIdentificationQualifier WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListeRxMessageDenyReason WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListeRxMessageType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListeRxStatus WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListEthnicity WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListEventType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListExercise WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListFaxCoverSheet WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListFaxServer WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListFhirLaunchParameterField WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListFilter WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListFindControlBehavior WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListFindTable WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListFormattingTemplate WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListFormLayout WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListFormLayoutControlAction WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListFormLayoutControlActionEvent WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListFormTitle WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListGender WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListGenderIdentity WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListGeneralNote WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListGeneralNoteType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListGraphicNote WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListGroupUIConfiguration WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListGrowthChart WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListHealthCareServiceLocation WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListHEDIS WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListHIPAAReleaseInfo WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListHistorian WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListHistoryGroup WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListHMRule WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListHMRuleDeclineReason WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListHpi WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListHpiCategory WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListHpiCategoryType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListHxRelationship WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListIcDeleteProcessor WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListIcPollingProcessor WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListIcProcessor WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListIcRequestProcessor WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListImmzCompletion WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListImmzContraindication WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListImmzEvidenceOfImmunity WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListImmzHistorySource WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListImmzReaction WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListImmzRefusal WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListImmzReminderRecall WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListImmzSpecialIndications WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListIndustry WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListInstantMessageStatus WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListInsuranceLevelName WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListIntegrationPartner WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListIntegrationPartnerType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListInterfaceBusinessObject WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListJob WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListJobScheduleTimeBase WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListLaboratory WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListLaboratoryOrder WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListLanguage WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListLetterModel WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListLockConcept WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListLockParentType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListLOINC WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListMacro WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListMacroGroup WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListMaritalStatus WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListMeasurementQualifier WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListMedicalDeviceStatus WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListMedicalServicesType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListMedicareSecondaryReasonCode WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListMedicationAction WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListMedicationCategory WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListMedicationDay WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListMedicationFrequency WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListMedicationFundingSource WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListMedicationPRNReason WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListMedicationRefill WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListMedicationRoute WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListMedicationSite WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListMedicationUnit WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListMessageRouting WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListMessageStatus WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListMessageSubType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListMessageType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListMessageUrgency WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListMisc WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListNameFormat WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListNameFormatType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListNCPDPReasonCode WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListNDCUnitMeasure WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListNegationReason WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListNoteFilter WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListNotificationMethod WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListObservation WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListObservationCustomUser WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListObservationGroup WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListObservationItem WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListObservationOrderResultStatus WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListOccupation WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListOccurrenceCode WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListPaperworkTransmissionCode WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListPaperworkType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListPatientCareManagementStatus WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListPatientClass WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListPatientCommunicationType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListPatientDashboard WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListPatientStatus WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListPatientStatusUB WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListPatientTrackingEventType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListPayerCreditRefundStatus WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListPayerTypologySource WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListPaymentType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListPEDescription WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListPEParentSystem WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListPESymptom WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListPESystem WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListPETemplate WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListPharmacyClearinghouse WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListPhoneType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListPlanPrnCondition WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListPlanSymptomCondition WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListPQRIDiseaseGroup WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListPQRIGroup WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListPQRIMeasure WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListPrmAction WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListPrmCondition WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListPrmRule WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListPrmRuleGroup WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListPrmRuleLevel WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListProblemStatus WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListProcedure WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListProcedureCategory WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListProcedureCodeType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListProcedureHistoryStatus WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListProcedureHistoryTerm WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListProcedureModifier WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListProcedurePanel WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListProcedureServiceType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListProductParameter WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListPronoun WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListProviderCareType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListQuestion WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListRace WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListRecallType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListReferralSrc WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListReferralTrackingStatus WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListReimbursementRule WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListRelatedCause WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListRelationalOperator WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListRelationship WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListReport WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListReportability WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListReportDesignerView WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListReportFolder WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListReportRdl WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListResponseCode WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListRoom WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListRuleMeasure WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListRxWorkflowStatus WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListScantronPublishedForm WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListScantronSurveyForm WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListScantronSurveyFormFields WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListScrubItem WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListScrubProfile WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListSecurity WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListSecurityGroup WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListServiceAuthorizationException WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListServiceSiteType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListSexualOrientation WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListSignatureSource WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListSIGQuantityUnitOfMeasure WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListSmartChartActionType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListSnomedCategory WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListSpecialProgramReason WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListSpecialty WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListState WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListSuperbillStatus WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListSurvey WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListSurveyAnswer WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListSurveyAnswerGroup WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListSurveyControlType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListSurveyQuestion WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListSurveySection WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListSymptom WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListSystem WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListTextEditor WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListTileConfiguration WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListTileType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListTimeFrame WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListTimespan WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListTimeType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListTranscriptionStatus WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListTranslationTemplate WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListTransmissionHandling WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListTypeofVaccine WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListTypeofVaccineElement WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListUIConfiguration WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListUIConfigurationDataType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListUIControl WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListUIControlType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListUIFilterType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListUserDefinedControl WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListUserDefinedControlGroup WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListUserDefinedData WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListUserDefinedFilter WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListUserDefinedTemplate WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListUserGroup WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListUserGroupType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListUserSetting WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListVaccine WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListVaccineAdmin WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListVaccineFundingSource WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListVaccineMfr WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListVaccineRoute WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListVaccineSite WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListValueCode WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListVFCEligibility WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListVisitType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListVoiceTag WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListWeightConditions WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ListZip WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE MapItem WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE MapSource WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE MasterPharmacy WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE MasterProcedureToLoinc WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE MasterSnomedDescription WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE MeaningfulUseCategoryDefinition WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE MeaningfulUseItemDefinition WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE MeaningfulUseStageDefinition WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE MedicationSIG WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE Person WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE PlugInSettings WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE PQRIDenominator WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE PQRINumerator WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE PRMModuleUpdate WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE Provider WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelAddInType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelAnswerGroupAnswer WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelCCSymptomHpi WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelCCSymptomHpiCategory WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelCCSystemSymptom WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelChargeTicketCategoryDiagnosis WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelChargeTicketCategorySP WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelChargeTicketDiagnosis WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelChargeTicketSP WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelClaimFormatValueTypeMisc WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelDiagnosisDisease WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelDiagnosisDpn WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelDpnGroupDpnNode WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelDpnGroupOrderAction WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelEduFormAssociation WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelEduFormCCSymptom WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelEMKeyComponentBullet WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelFilterNotification WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelFormLayoutClinicalNoteType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelFormLayoutProcedure WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelHMRuleDisease WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelHMRuleDrugClass WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelHMRuleGender WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelHMRuleProcedure WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelLockParentTypeLockConcept WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelMacroGroupSecurity WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelMacroTextEditor WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelObservationCustomUser WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelObservationGroupObservation WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelObservationObservationItem WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelPETemplateDescription WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelPETemplateParentSystem WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelPETemplateSymptom WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelPETemplateSystem WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelPQRIMeasurePQRIGroup WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelPrmRulePrmAction WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelPrmRulePrmCondition WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelProcedureDpn WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelProcedureHistoryTermProcedure WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelProcedureTypeofVaccine WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelQuestionAnswerSnomed WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelReportContextReportType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelRosSystemSymptom WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelScrubItemScrubProfile WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelSurveyAnswerGroupSurveyAnswer WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelSurveyAnswerGroupSurveyQuestion WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelSurveySectionSurveyQuestion WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelSurveySurveySection WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelTypeofVaccineTypeofVaccineElement WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelUIConfigurationGroupUIConfiguration WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelVaccineDisplayCols WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelVaccinePrintCols WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RelVaccineTypeofVaccine WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RemarkCategory WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RemarkType WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ReplicationSettings WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE RosSystem WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE ScantronDemographicsSurvey WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE SecurityUserGroup WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE SIGDetail WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE SpecialtyCpp WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE StatementAction WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE SubFindTable WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE SubFindTableItem WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE Translation WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE TransmissionConfiguration WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE UIConfigurationHistory WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE UIConfigurationHistoryData WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE UserGroupMember WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE VaccineAdminItem WITH CHECK CHECK CONSTRAINT ALL
GO
ALTER TABLE VaccineUnitUse WITH CHECK CHECK CONSTRAINT ALL
GO

