SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[Account_ADT_Updates]'))
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:           Kevin Crumpton
-- Create date: 08/14/2014
-- Description:      Update Superbill to cause DFT trigger to fire for procs that are Addendums
-- =============================================
CREATE TRIGGER [dbo].[Account_ADT_Updates] 
   ON  [dbo].[Account] 
   AFTER INSERT,UPDATE
AS 
BEGIN
                if (OBJECT_ID(''tempdb..#SkipAccountTriggers'') IS NULL)
                begin
       -- SET NOCOUNT ON added to prevent extra result sets from
       -- interfering with SELECT statements.
       SET NOCOUNT ON;

       if not exists (
              Select PM.HL7PartnerMessageUid 
                     from HL7partner P WITH (NOLOCK) LEFT JOIN HL7PartnerMessage PM WITH (NOLOCK) ON       PM.HL7partnerUid=P.HL7partnerUid
              where 
                     PM.MessageType = ''ADT'' 
                     and PM.Inactive = 0  
                     and P.Inactive = 0 
                     and PM.Send = 1
                     and PM.SendFunction = ''UpdatePatient''
              )
       begin
              return
       end
       
       IF dbo.IsCacheClient() = 0  
        begin
              -- Insert statements for trigger here
              update p
                     set LastModifiedDate = p.LastModifiedDate --just causing trigger to fire
              from inserted i 
                     join Person p on i.PersonUid = p.PersonUid
       end
                end
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[Account_EKOS_Updates]'))
EXEC dbo.sp_executesql @statement = N'
CREATE TRIGGER [dbo].[Account_EKOS_Updates] 
   ON  [dbo].[Account] 
   AFTER INSERT,UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	if not exists (
		Select *
		from TransmissionConfiguration tc WITH(NOLOCK)
		inner join ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
		where 
			tc.TransmissionType = ''EKOS'' and
			lip.Inactive = 0 
		)
	begin
		return
	end
       
	IF dbo.IsCacheClient() = 0  
	begin
		-- Insert statements for trigger here
		update p
		set LastModifiedDate = p.LastModifiedDate --just causing trigger to fire
		from inserted i 
		join Person p WITH(NOLOCK) on i.PersonUid = p.PersonUid
	end
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[Account_InsteadOf_Insert_IsMain]'))
EXEC dbo.sp_executesql @statement = N'

CREATE TRIGGER [dbo].[Account_InsteadOf_Insert_IsMain] on [dbo].[Account]
INSTEAD OF INSERT
AS
BEGIN
       SET NOCOUNT ON;

	   -- 2016  bmr  removed LastStatemntDate
      
       IF (dbo.IsReplicating()= 1)
       BEGIN
             DECLARE @IsCacheClient BIT;
             SET @IsCacheClient = dbo.IsCacheClient();
             IF (@IsCacheClient = 1)
             BEGIN
                   UPDATE AC -- if client and trying to set IsMain=1, flip IsMain on ALL Accounts within that Person first, the proper IsMain will insert below
                         SET AC.IsMain = 0
                         FROM Account AC
                               INNER JOIN INSERTED I ON AC.PersonUid = I.PersonUid
                         WHERE I.IsMain = 1 AND AC.IsMain = 1; -- no need to touch existing rows that are already IsMain = 0
             END
			 DECLARE @originatorId VARBINARY(128);
			 SELECT @originatorId = dbo.GetChangeTrackingContextFromContextInfo();

			 WITH CHANGE_TRACKING_CONTEXT(@originatorId)
             INSERT INTO Account (AccountUid, ExternalID,Name ,PersonUid, AccountResponsiblePartyUid,ResponsiblePartyRelationshipUid ,
                              FormularyList ,PatienteRxEligibilityUid, EligibilityProviderUid,EligibilityLastCheckedDate ,EligibilityLastResponse,
                              IsMain ,Inactive, CycleTrigger ,ExcludeFromAutomatedCollections,
                              LastModifiedDate ,LastModifiedByUid, CoverageTypeUid)
             SELECT AccountUid,ExternalID, Name,PersonUid ,AccountResponsiblePartyUid, ResponsiblePartyRelationshipUid,
                              FormularyList ,PatienteRxEligibilityUid, EligibilityProviderUid,EligibilityLastCheckedDate ,EligibilityLastResponse,
                               CASE WHEN @IsCacheClient=0 AND EXISTS(SELECT AccountUid FROM Account AC WHERE AC.PersonUid = PersonUid AND AC.IsMain = 1 AND NOT AC.AccountUid = AccountUid )
                                     THEN 0 ELSE IsMain END, -- if MASTER and Already Have IsMain, SET IsMain = 0, else IsMain
                              Inactive , CycleTrigger,ExcludeFromAutomatedCollections ,
                              LastModifiedDate ,LastModifiedByUid, CoverageTypeUid
                   FROM INSERTED;
       END
       ELSE
       BEGIN -- pass insert along
             INSERT INTO Account (AccountUid, ExternalID,Name ,PersonUid, AccountResponsiblePartyUid,ResponsiblePartyRelationshipUid ,
                              FormularyList ,PatienteRxEligibilityUid, EligibilityProviderUid,EligibilityLastCheckedDate ,EligibilityLastResponse,
                              IsMain ,Inactive, CycleTrigger ,ExcludeFromAutomatedCollections,
                              LastModifiedDate ,LastModifiedByUid, CoverageTypeUid)
             SELECT AccountUid,ExternalID, Name,PersonUid ,AccountResponsiblePartyUid, ResponsiblePartyRelationshipUid,
                              FormularyList ,PatienteRxEligibilityUid, EligibilityProviderUid,EligibilityLastCheckedDate ,EligibilityLastResponse,
                              IsMain , 
                              Inactive , CycleTrigger,ExcludeFromAutomatedCollections ,
                              LastModifiedDate ,LastModifiedByUid, CoverageTypeUid
                   FROM INSERTED;
       END

END
/*
See Testing SQL in Account_InsteadOf_Update_IsMain Trigger
*/

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[Account_InsteadOf_Update_IsMain]'))
EXEC dbo.sp_executesql @statement = N'
CREATE TRIGGER [dbo].[Account_InsteadOf_Update_IsMain] on [dbo].[Account]
INSTEAD OF UPDATE
AS
BEGIN
       SET NOCOUNT ON;
                
                   -- 2016  bmr  removed LastStatemntDate
     
       IF ((dbo.IsReplicating()= 1) and (OBJECT_ID(''tempdb..#SkipAccountTriggers'') IS NULL))
       BEGIN
             DECLARE @IsCacheClient BIT;
             SET @IsCacheClient = dbo.IsCacheClient();
             IF (@IsCacheClient = 1)
             BEGIN
                   UPDATE AC -- if client and trying to set IsMain=1, flip IsMain on ALL Accounts within that Person first, the proper IsMain will update below
                         SET AC.IsMain = 0
                         FROM Account AC
                               INNER JOIN INSERTED I ON AC.PersonUid = I.PersonUid
                         WHERE I.IsMain = 1 AND AC.IsMain = 1; -- no need to touch existing rows that are already IsMain = 0
             END
                                                DECLARE @originatorId VARBINARY(128);
                                                SELECT @originatorId = dbo.GetChangeTrackingContextFromContextInfo();

                                                WITH CHANGE_TRACKING_CONTEXT(@originatorId)
             UPDATE AC
                         SET AC. ExternalID = I .ExternalId,
                              AC.Name = I.Name ,
                              AC.PersonUid = I.PersonUid ,
                              AC.AccountResponsiblePartyUid = I.AccountResponsiblePartyUid,
                              AC.ResponsiblePartyRelationshipUid = I.ResponsiblePartyRelationshipUid,
                              AC.FormularyList = I.FormularyList ,
                              AC.PatienteRxEligibilityUid = I.PatienteRxEligibilityUid,
                              AC.EligibilityProviderUid = I.EligibilityProviderUid,
                              AC.EligibilityLastCheckedDate = I.EligibilityLastCheckedDate,
                              AC.EligibilityLastResponse = I.EligibilityLastResponse,
                              AC.IsMain = CASE WHEN @IsCacheClient = 0 AND EXISTS( SELECT AccountUid FROM Account AC -- if MASTER and Already Have IsMain, SET IsMain = 0, else IsMain
                                                             WHERE AC.PersonUid = I.PersonUid AND AC.IsMain = 1 AND NOT AC.AccountUid = I.AccountUid)
                                     THEN 0 ELSE I.IsMain END,
                    AC.Inactive = I.Inactive ,
                    AC.CycleTrigger = I.CycleTrigger ,
                    AC.ExcludeFromAutomatedCollections = I.ExcludeFromAutomatedCollections,
                    AC.LastModifiedDate = I.LastModifiedDate ,
                    AC.LastModifiedByUid = I.LastModifiedByUid ,    
                    AC.CoverageTypeUid = I.CoverageTypeUid      
                         FROM Account AC
                               INNER JOIN INSERTED I ON AC.AccountUid = I.AccountUId;
       END
       ELSE
                   BEGIN
             UPDATE AC
                         SET AC. ExternalID = I .ExternalId,
                              AC.Name = I.Name ,
                              AC.PersonUid = I.PersonUid ,
                              AC.AccountResponsiblePartyUid = I.AccountResponsiblePartyUid,
                              AC.ResponsiblePartyRelationshipUid = I.ResponsiblePartyRelationshipUid,
                              AC.FormularyList = I.FormularyList ,
                              AC.PatienteRxEligibilityUid = I.PatienteRxEligibilityUid,
                              AC.EligibilityProviderUid = I.EligibilityProviderUid,
                              AC.EligibilityLastCheckedDate = I.EligibilityLastCheckedDate,
                              AC.EligibilityLastResponse = I.EligibilityLastResponse,
                              AC.IsMain = I.IsMain,
                    AC.Inactive = I.Inactive ,
                    AC.CycleTrigger = I.CycleTrigger ,
                    AC.ExcludeFromAutomatedCollections = I.ExcludeFromAutomatedCollections,
                    AC.LastModifiedDate = I.LastModifiedDate ,
                    AC.LastModifiedByUid = I.LastModifiedByUid ,    
                    AC.CoverageTypeUid = I.CoverageTypeUid      
                         FROM Account AC
                               INNER JOIN INSERTED I ON AC.AccountUid = I.AccountUId;
                   END

END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[AccountInsurance_InsertUpdate]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[AccountInsurance_InsertUpdate] ON [dbo].[AccountInsurance] FOR INSERT, UPDATE AS
BEGIN
	-- Keep Child Accounts In Sync
	UPDATE AICHILD SET AICHILD.DisplayOrder = AIPARENT.DisplayOrder,
					AICHILD.RelationshipUid = AIPARENT.RelationshipUid,
					AICHILD.PolicyNumberSuffix = AIPARENT.PolicyNumberSuffix,
					AICHILD.LastModifiedDate = AIPARENT.LastModifiedDate,
					AICHILD.LastModifiedByUid = AIPARENT.LastModifiedByUid
				FROM AccountInsurance AIPARENT 
					INNER JOIN AccountInsurance AICHILD ON AIPARENT.AccountInsuranceUid = AICHILD.ParentAccountInsuranceUid
					INNER JOIN Inserted I ON (AIPARENT.AccountInsuranceUid = I.ParentAccountInsuranceUid
																OR AICHILD.ParentAccountInsuranceUid = I.AccountInsuranceUid)
	WHERE I.ParentAccountInsuranceUid IS NOT NULL

	 IF (dbo.IsReplicating() = 1) -- not needed on replication
		RETURN;

	SELECT COBLA.COBClaimDetailUid, COBLA.COBLineAdjustmentsUid,  I.DisplayOrder
		INTO #tempUpdateCobLineAdustments
		FROM COBClaimDetail COBCD 
			INNER JOIN COBLineAdjustments COBLA ON COBCD.COBClaimDetailUid = COBLA.COBClaimDetailUid
			INNER JOIN SuperbillProcedure SBP ON COBLA.SuperbillProcedureUid = SBP.SuperbillProcedureUid
			INNER JOIN Superbill SB ON SBP.SuperbillUid = SB.SuperbillUid
			INNER JOIN Account AC ON SB.AccountUid = AC.AccountUid
			INNER JOIN AccountPeriod AP ON AC.AccountUid = AP.AccountUid
				  AND (AP.EffectiveDate is null OR AP.EffectiveDate <= SB.ServiceDateEnd)
				  AND (AP.ExpirationDate is null OR DateAdd(dd, 1, AP.ExpirationDate) > SB.ServiceDateEnd)
			INNER JOIN AccountInsurance AI ON AP.AccountPeriodUid = AI.AccountPeriodUid
			INNER JOIN INSERTED I ON AI.AccountInsuranceUid = I.AccountInsuranceUid
			INNER JOIN DELETED D ON AI.AccountInsuranceUid = D.AccountInsuranceUid -- this will filter out inserts also
		WHERE I.DisplayOrder <> D.DisplayOrder
			AND COBCD.InsuranceOrder = D.DisplayOrder;

	UPDATE COBLineAdjustments 
		SET COBLineAdjustments.LiabilityOwner = #tempUpdateCobLineAdustments.DisplayOrder
			FROM COBLineAdjustments 
				INNER JOIN #tempUpdateCobLineAdustments ON COBLineAdjustments.COBLineAdjustmentsUid = #tempUpdateCobLineAdustments.COBLineAdjustmentsUid;

	UPDATE COBClaimDetail 
		SET COBClaimDetail.InsuranceOrder = #tempUpdateCobLineAdustments.DisplayOrder
			FROM COBClaimDetail 
				INNER JOIN #tempUpdateCobLineAdustments ON COBClaimDetail.COBClaimDetailUid = #tempUpdateCobLineAdustments.COBClaimDetailUid;

	DROP TABLE #tempUpdateCobLineAdustments;

/*

	BEGIN TRANSACTION

	SELECT COBCD.COBClaimDetailUid, COBCD.InsuranceOrder, COBLA.COBLineAdjustmentsUid, COBLA.LiabilityOwner,   
			AI.*
		FROM COBLineAdjustments COBLA 
			INNER JOIN COBClaimDetail COBCD ON COBLA.COBClaimDetailUid = COBCD.COBClaimDetailUid
			INNER JOIN SuperbillProcedure SBP ON COBLA.SuperbillProcedureUid = SBP.SuperbillProcedureUid
			INNER JOIN Superbill SB ON SBP.SuperbillUid = SB.SuperbillUid
			INNER JOIN Account AC ON SB.AccountUid = AC.AccountUid
			INNER JOIN AccountPeriod AP ON AC.AccountUid = AP.AccountUid
				  AND (AP.EffectiveDate is null OR AP.EffectiveDate <= SB.ServiceDateEnd)
				  AND (AP.ExpirationDate is null OR DateAdd(dd, 1, AP.ExpirationDate) > SB.ServiceDateEnd)
			INNER JOIN AccountInsurance AI ON AP.AccountPeriodUid = AI.AccountPeriodUid -- ORDER BY AP.AccountPeriodUid
			WHERE AP.AccountPeriodUid = ''30554930-3004-4A5D-ADD4-19BD5EE8BB64''

	UPDATE AccountInsurance SET DisplayOrder = CASE WHEN DisplayOrder = 1 THEN 2 ELSE 1 END WHERE AccountPeriodUid = ''30554930-3004-4A5D-ADD4-19BD5EE8BB64''

	SELECT * FROM AccountInsurance WHERE AccountPeriodUid = ''30554930-3004-4A5D-ADD4-19BD5EE8BB64''
*/

END



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[EKOS_accountinsurance_insertupdate]'))
EXEC dbo.sp_executesql @statement = N'
CREATE trigger [dbo].[EKOS_accountinsurance_insertupdate] on [dbo].[AccountInsurance] for insert, update as
begin
      if not exists ( select top 1 * from inserted )
            return
            
       DECLARE @SendAllAccounts BIT
       SET @SendAllAccounts = NULL
			
			
       select @SendAllAccounts = boolvalue
       from ListProductParameter 
       where ParameterName = ''SendAllAccountsNotJustMain'' 

      if dbo.IsReplicating() = 0
      begin

              insert    TransmissionOutbound(TransmissionType, ForeignObjectUid, RawMessage, PatientUid, lastmodifiedbyuid, LastModifiedDate)
              select    distinct ''EKOS'', a.personuid, ''iMedica.Prm.BusinessObject.Patient'', a.personuid, i.lastmodifiedbyuid, GETUTCDATE()
              from      TransmissionConfiguration tc WITH(NOLOCK)
                        inner join ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
                        cross join inserted i 
                        join accountperiod ap WITH(NOLOCK) on i.accountperioduid = ap.accountperioduid
                        join account a WITH(NOLOCK) on ap.accountuid = a.accountuid and (a.ismain = 1 or @SendAllAccounts = 1)
              where     tc.TransmissionType = ''EKOS'' and
                        lip.Inactive = 0 
                         
      end
end

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[interface_accountinsurance_delete]'))
EXEC dbo.sp_executesql @statement = N'
CREATE trigger [dbo].[interface_accountinsurance_delete] on [dbo].[AccountInsurance] for delete as
begin
      if not exists ( select top 1 * from deleted )
            return

      if dbo.IsReplicating() = 0
      begin
      
      DECLARE @SendAllAccounts BIT;
       
       select @SendAllAccounts = boolvalue
       from ListProductParameter 
       where ParameterName = ''SendAllAccountsNotJustMain'' 
       
       print @SendAllAccounts 

              insert    hl7actiontypeobject(hl7partnermessageuid, actiontype, objectuid, objecttype, lastmodifiedbyuid)
              select    distinct pm.hl7partnermessageuid, pm.sendfunction, a.personuid, ''Patient'', d.lastmodifiedbyuid
              from      hl7partnermessage pm 
                        inner join hl7partner p on pm.hl7partneruid = p.hl7partneruid
                        cross join deleted d 
                        join accountperiod ap on d.accountperioduid = ap.accountperioduid
                        join account a on ap.accountuid = a.accountuid and (a.ismain = 1 or @SendAllAccounts = 1)
                        left join hl7actiontypeobject ato
									on ato.objecttype=''patient'' 
                                    and pm.hl7partnermessageuid = ato.hl7partnermessageuid
									and ato.objectuid = a.personuid                                        
              where     pm.sendfunction = ''updatepatient'' and
                          pm.send = 1 and
                          pm.inactive = 0 and
                          p.inactive = 0 and
                          (ato.hl7actiontypeobjectuid is null or ato.processingerror = 1) -- allow creation of a new row 
                                                                        -- if there is an existing row that has errored out

      end
end

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[interface_accountinsurance_insertupdate]'))
EXEC dbo.sp_executesql @statement = N'
CREATE trigger [dbo].[interface_accountinsurance_insertupdate] on [dbo].[AccountInsurance] for insert, update as
begin
      if not exists ( select top 1 * from inserted )
            return
            
       DECLARE @SendAllAccounts BIT
       SET @SendAllAccounts = NULL
			
			
       select @SendAllAccounts = boolvalue
       from ListProductParameter 
       where ParameterName = ''SendAllAccountsNotJustMain'' 

      if dbo.IsReplicating() = 0
      begin

              insert    hl7actiontypeobject(hl7partnermessageuid, actiontype, objectuid, objecttype, lastmodifiedbyuid)
              select    distinct pm.hl7partnermessageuid, pm.sendfunction, a.personuid, ''Patient'', i.lastmodifiedbyuid
              from      hl7partnermessage pm 
                        inner join hl7partner p on pm.hl7partneruid = p.hl7partneruid
                        cross join inserted i 
                        join accountperiod ap on i.accountperioduid = ap.accountperioduid
                        join account a on ap.accountuid = a.accountuid and (a.ismain = 1 or @SendAllAccounts = 1)
                        --and (a.ismain = 1 or @SendAllAccounts = 1)
                        left join hl7actiontypeobject ato
									on ato.objecttype=''patient'' 
                                    and pm.hl7partnermessageuid = ato.hl7partnermessageuid
									and ato.objectuid = a.personuid
              where     pm.sendfunction = ''updatepatient'' and
                          pm.send = 1 and
                          pm.inactive = 0 and
                          p.inactive = 0 and
                          (ato.hl7actiontypeobjectuid is null or ato.processingerror = 1) -- allow creation of a new row 
                                                                      -- if there is an existing row that has errored out
      end
end

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[accountperiod_superbillaggregate_delete]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[accountperiod_superbillaggregate_delete] on [dbo].[AccountPeriod] after delete as
begin
	set nocount on;

	update	sa
	set		accountperioduid = null,
			primaryinsuranceplanuid = null,
			currentinsuranceplanuid = null
	from	deleted del
			inner join superbill s on del.accountuid = s.accountuid
			inner join superbillaggregate sa on s.superbilluid = sa.superbilluid

	update	sa
	set		accountperioduid = ap.accountperioduid,
			primaryinsuranceplanuid = pipp.insuranceplanuid,
			currentinsuranceplanuid = pipc.insuranceplanuid
	from	deleted ins inner join accountperiod ap on ins.accountuid = ap.accountuid
			inner join superbill s on ins.accountuid = s.accountuid
			inner join superbillaggregate sa on s.superbilluid = sa.superbilluid
			left join listsuperbillstatus ss on s.superbillstatusuid = ss.superbillstatusuid
			left join accountinsurance aip on ap.accountperioduid = aip.accountperioduid and aip.displayorder = 1
			left join personinsuranceplan pipp on aip.personinsuranceplanuid = pipp.personinsuranceplanuid
			left join accountinsurance aic on ap.accountperioduid = aic.accountperioduid and (aic.displayorder = ss.insuranceorder and ss.insuranceorder > 0 or aic.displayorder = 1 and ss.insuranceorder = 0)
			left join personinsuranceplan pipc on aic.personinsuranceplanuid = pipc.personinsuranceplanuid
	where	(ap.effectivedate is null or ap.effectivedate <= s.servicedateend) and
			(ap.expirationdate is null or dateadd(dd, 1, ap.expirationdate) > s.servicedateend)
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[accountperiod_superbillaggregate_insert_update]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[accountperiod_superbillaggregate_insert_update] on [dbo].[AccountPeriod] after insert, update as
begin
	set nocount on;

	update	sa
	set		accountperioduid = null,
			primaryinsuranceplanuid = null,
			currentinsuranceplanuid = null
	from	inserted ins
			inner join superbill s on ins.accountuid = s.accountuid
			inner join superbillaggregate sa on s.superbilluid = sa.superbilluid

	update	sa
	set		accountperioduid = ap.accountperioduid,
			primaryinsuranceplanuid = pipp.insuranceplanuid,
			currentinsuranceplanuid = pipc.insuranceplanuid
	from	inserted ins inner join accountperiod ap on ins.accountuid = ap.accountuid
			inner join superbill s on ins.accountuid = s.accountuid
			inner join superbillaggregate sa on s.superbilluid = sa.superbilluid
			left join listsuperbillstatus ss on s.superbillstatusuid = ss.superbillstatusuid
			left join accountinsurance aip on ap.accountperioduid = aip.accountperioduid and aip.displayorder = 1
			left join personinsuranceplan pipp on aip.personinsuranceplanuid = pipp.personinsuranceplanuid
			left join accountinsurance aic on ap.accountperioduid = aic.accountperioduid and (aic.displayorder = ss.insuranceorder and ss.insuranceorder > 0 or aic.displayorder = 1 and ss.insuranceorder = 0)
			left join personinsuranceplan pipc on aic.personinsuranceplanuid = pipc.personinsuranceplanuid
	where	(ap.effectivedate is null or ap.effectivedate <= s.servicedateend) and
			(ap.expirationdate is null or dateadd(dd, 1, ap.expirationdate) > s.servicedateend)
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[collectionstatusmanuallychanged_arpupdate]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[collectionstatusmanuallychanged_arpupdate]
on [dbo].[AccountResponsibleParty] 
for update
as
begin
  if not exists ( select top 1 * from inserted )
    return

  if ( dbo.isreplicating() = 0 )
  begin
	  declare @currentaccountresponsiblepartyuid uniqueidentifier
	  declare @accountresponsiblepartyuid uniqueidentifier
	  declare @collectionstatusuid uniqueidentifier
	  declare @oldcollectionstatusuid uniqueidentifier
	  declare @changedbyuid	uniqueidentifier

	  set rowcount 1
		  select
			  @accountresponsiblepartyuid = inserted.accountresponsiblepartyuid,
				@oldcollectionstatusuid = deleted.collectionstatusuid,
			  @collectionstatusuid = inserted.collectionstatusuid,
			  @changedbyuid = inserted.lastmodifiedbyuid
		  from
			  inserted
		  inner join
			  deleted on
				  inserted.accountresponsiblepartyuid = deleted.accountresponsiblepartyuid
		  where
				(
					(
						inserted.collectionstatusuid <> deleted.collectionstatusuid
					)
				or	
					(
							inserted.collectionstatusuid is null
						and	deleted.collectionstatusuid is not null
					)
				or
					(
							inserted.collectionstatusuid is not null
						and	deleted.collectionstatusuid is null
					)
				)
		  and (
						  inserted.collectionstatusleveluid = deleted.collectionstatusleveluid
				  or	
						  (
								  inserted.collectionstatusleveluid is null
						  and	deleted.collectionstatusleveluid is null
						  )
				  )
		  order by
			  inserted. accountresponsiblepartyuid
  			
	  while @@rowcount <> 0
	  begin
		  set rowcount 0
			  set @currentaccountresponsiblepartyuid = @accountresponsiblepartyuid
			  exec manualcollectionstatuschange @accountresponsiblepartyuid, @oldcollectionstatusuid, @collectionstatusuid, @changedbyuid

	  set rowcount 1
		  select
			  @accountresponsiblepartyuid = inserted.accountresponsiblepartyuid,
				@oldcollectionstatusuid = deleted.collectionstatusuid,
			  @collectionstatusuid = inserted.collectionstatusuid,
			  @changedbyuid = inserted.lastmodifiedbyuid
		  from
			  inserted
		  inner join
			  deleted on
				  inserted.accountresponsiblepartyuid = deleted.accountresponsiblepartyuid
		  where
				(
					(
						inserted.collectionstatusuid <> deleted.collectionstatusuid
					)
				or	
					(
							inserted.collectionstatusuid is null
						and	deleted.collectionstatusuid is not null
					)
				or
					(
							inserted.collectionstatusuid is not null
						and	deleted.collectionstatusuid is null
					)
				)
		  and (
						  inserted.collectionstatusleveluid = deleted.collectionstatusleveluid
				  or	
						  (
								  inserted.collectionstatusleveluid is null
						  and	deleted.collectionstatusleveluid is null
						  )
				  )
		  and	inserted. accountresponsiblepartyuid > @currentaccountresponsiblepartyuid
		  order by
			  inserted. accountresponsiblepartyuid
	  end
  end

  set rowcount 0
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[EKOS_Guarantor_delete]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[EKOS_Guarantor_delete] ON [dbo].[AccountResponsibleParty]   
FOR DELETE  
AS  
BEGIN  
IF @@ROWCOUNT = 0  
RETURN  
 IF dbo.IsCacheClient() = 0  
 BEGIN  
  SET NOCOUNT ON   
    
  if not exists (select * 
				 from TransmissionConfiguration tc
                 inner join ListIntegrationPartner lip on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
			     where tc.TransmissionType = ''EKOS'' and
					   lip.Inactive = 0 )
	RETURN;
	IF NOT  EXISTS (SELECT 1 FROM deleted)
	RETURN;
	BEGIN
		insert    TransmissionOutbound(TransmissionType, Description, ForeignObjectUid,RawMessage, lastmodifiedbyuid, LastModifiedDate)
		select    distinct ''EKOS'', ''GUARANTORDELETE'',i.AccountResponsiblePartyUid, ''iMedica.Prm.BusinessObject.AccountResponsibleParty'', i.lastmodifiedbyuid, GETUTCDATE()
		from      TransmissionConfiguration tc WITH(NOLOCK)
        inner join ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
		cross join inserted i 
	    where     tc.TransmissionType = ''EKOS'' and
        lip.Inactive = 0 
      END  
 END 
  
END' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[EKOS_Guarantor_update]'))
EXEC dbo.sp_executesql @statement = N'
CREATE trigger [dbo].[EKOS_Guarantor_update] on [dbo].[AccountResponsibleParty] for  UPDATE as
BEGIN

IF NOT EXISTS (SELECT * 
				 FROM TransmissionConfiguration tc WITH(NOLOCK)
                 INNER JOIN ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
			     WHERE tc.TransmissionType = ''EKOS'' AND
					   lip.Inactive = 0 )
  RETURN;

  if not exists ( select 1  from inserted )
    return

  if dbo.IsReplicating() = 0
  begin


		insert    TransmissionOutbound(TransmissionType, ForeignObjectUid, RawMessage, lastmodifiedbyuid, LastModifiedDate)
		select    distinct ''EKOS'', i.AccountResponsiblePartyUid, ''iMedica.Prm.BusinessObject.AccountResponsibleParty'', i.lastmodifiedbyuid, GETUTCDATE()
		from      TransmissionConfiguration tc WITH(NOLOCK)
        inner join ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
		cross join inserted i 
	    where     tc.TransmissionType = ''EKOS'' and
        lip.Inactive = 0 

  end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[Apopintment_Cancelled_Then_Cancel_Superbill]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[Apopintment_Cancelled_Then_Cancel_Superbill] ON [dbo].[Appointment] FOR UPDATE AS
DECLARE @AppointmentCancelledSuperbillStatus uniqueidentifier = ''07DB9EAE-6F9A-43E6-917E-BD0DBD8EBFC5''
IF EXISTS(SELECT 1/0 FROM ListSuperbillStatus where SuperbillStatusUid = @AppointmentCancelledSuperbillStatus and Inactive = 0)
BEGIN
  UPDATE Superbill Set SuperbillStatusUid = @AppointmentCancelledSuperbillStatus 
    FROM Inserted i
      JOIN Deleted d    on d.AppointmentUid  = i.AppointmentUid
      JOIN Superbill sb on sb.AppointmentUid = i.AppointmentUid
      JOIN ListAppointmentStatus lasI on lasI.AppointmentStatusUid = I.AppointmentStatusUid and lasi.IsCanceledStatus = 1
      JOIN ListAppointmentStatus lasD on lasD.AppointmentStatusUid = D.AppointmentStatusUid and lasd.IsCanceledStatus = 0
END' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[Appointment_AppointmentConnect_ClearOnUpdate]'))
EXEC dbo.sp_executesql @statement = N'
CREATE   TRIGGER [dbo].[Appointment_AppointmentConnect_ClearOnUpdate] on [dbo].[Appointment] after update
as
IF dbo.IsReplicating() <> 0
RETURN; 

IF (SELECT Inactive FROM ListIntegrationPartner WHERE Name = ''CGM Connection'' OR IntegrationPartnerUid = ''E1D0A4E0-DB48-4105-8E22-4A3577507364'')= 1
	RETURN;

begin
	
	-- resend modified appointments to connect again
	delete from RelAppointmentConnect
		where AppointmentUid IN (select AppointmentUid from deleted);

end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[CCR_Appointment_Update]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[CCR_Appointment_Update] ON [dbo].[Appointment] FOR INSERT, UPDATE AS  
	IF dbo.IsCacheClient() = 0
	BEGIN
		IF NOT EXISTS (
				SELECT TOP 1 * 
				FROM HL7PartnerMessage 
				WHERE (SendFunction = ''CCR Consumption'')
					AND Send = 1 AND Inactive = 0 )
			RETURN

		INSERT	HL7ActionTypeObject(HL7PartnerMessageUid, ActionType, ObjectUid, ObjectType, LastModifiedByUid)  
		SELECT	pm.HL7PartnerMessageUid, pm.SendFunction, i.AppointmentUid, ''Appointment'', i.LastModifiedByUid  
		FROM	HL7PartnerMessage pm 
				INNER JOIN HL7Partner p ON pm.HL7PartnerUid = p.HL7PartnerUid  
				CROSS JOIN inserted i 
				INNER JOIN Appointment apt ON i.AppointmentUid = apt.AppointmentUid 
				LEFT JOIN ViewActionTypeObjectPartnerMessage atopm ON i.AppointmentUid = atopm.ObjectUid AND atopm.ObjectType=''Appointment''
				 AND pm.HL7PartnerUid = atopm.HL7PartnerUid AND atopm.SendFunction = ''CCR Consumption''
				 Left Join ListAppointmentStatus LAS On LAS.AppointmentStatusUid= i.AppointmentStatusUid
				LEFT JOIN DELETED D ON i.AppointmentUid = d.AppointmentUid
		WHERE	pm.SendFunction = ''CCR Consumption'' AND  
				pm.Send = 1 AND  
				pm.Inactive = 0 AND  
				p.Inactive = 0 AND  
				atopm.HL7ActionTypeObjectUid IS NULL AND
				LAS.Name=''Checked In'' AND
				d.AppointmentUid IS NOT NULL -- THIS INSERT IS FOR UPDATED APPOINTMENTS ONLY
	END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[interface_appointment_update]'))
EXEC dbo.sp_executesql @statement = N'CREATE   trigger [dbo].[interface_appointment_update] on [dbo].[Appointment] for insert, update as  
	if dbo.IsReplicating() = 0
	begin
		if not exists (
				select top 1 * 
				from hl7partnermessage 
				where (sendfunction = ''newappointment'' or sendfunction = ''updateappointment''  or sendfunction = ''CancelAppointment'' 
				or SendFunction = ''CheckInAppointment'')
					and send = 1 and inactive = 0 )
			return

		DECLARE @Partners TABLE (HL7PartnerMessageUid UNIQUEIDENTIFIER)
		INSERT INTO @Partners
		SELECT DISTINCT hpm.HL7PartnerMessageUid
		FROM HL7PartnerMessage hpm
		INNER JOIN HL7Partner hp on hpm.HL7PartnerUid = hp.HL7PartnerUid AND hp.Inactive = 0
		WHERE (hpm.MessageType = ''SIU'' or (hpm.MessageType = ''ADT'' and hpm.SendFunction = ''CheckInAppointment''))
		AND SendFunction not like ''%_CUS''
		AND hpm.Send = 1
		AND hpm.Inactive = 0

		DELETE HL7ActionTypeObject WHERE HL7ActionTypeObjectUid in
			(SELECT HL7ActionTypeObjectUid FROM HL7ActionTypeObject ato
			JOIN INSERTED i on ato.ObjectUid= i.AppointmentUid
			INNER JOIN @Partners p on ato.HL7PartnerMessageUid = p.HL7PartnerMessageUid)


-- new Appointment start
DECLARE @SIU12Table TABLE (PartnerMessageUid UNIQUEIDENTIFIER, ObjectUid UNIQUEIDENTIFIER, LastModifiedByUid UNIQUEIDENTIFIER)
DECLARE @S12ObjectType varchar(25) = ''appointment''
DECLARE @S12SendFunction varchar(25) = ''newappointment''
		--Check to ensure there is a valid partner otherwise exits trigger
		IF NOT EXISTS (SELECT TOP 1 * FROM HL7PartnerMessage 
						WHERE (SendFunction = @S12SendFunction)	AND Send = 1 AND Inactive = 0)
		RETURN


	   --Generates Temp SIU12Table
	   INSERT INTO @SIU12Table
       SELECT DISTINCT PartnerMessageUid = pm.HL7PartnerMessageUid
			, objectuid=i.appointmentuid
			, LastModifiedByUid = i.LastModifiedByUid
	   from HL7PartnerMessage pm
	   inner join hl7partner p on pm.hl7partneruid = p.hl7partneruid  
				cross join inserted i 
				inner join appointment apt on i.appointmentuid = apt.appointmentuid 
				left join viewactiontypeobjectpartnermessage atopm on i.appointmentuid = atopm.objectuid and atopm.objecttype=''appointment''
				 and pm.hl7partneruid = atopm.hl7partneruid and atopm.sendfunction in (''newappointment'', ''updateappointment'')
				left join deleted d on i.appointmentuid = d.appointmentuid
		where	pm.sendfunction = ''newappointment'' and  
				pm.send = 1 and  
				pm.inactive = 0 and  
				p.inactive = 0 and 
				i.lastmodifiedbyuid is not null and -- to control not to generate message while receving the walk in patient (a01) message 
				atopm.hl7actiontypeobjectuid is null and
				d.appointmentuid is null and -- this insert is for new appointments only
				apt.PatientUid is not null

		--Checks to ensure SIU12Table has values and then inserts the values into HL7ATO to send SIUs
		IF Exists (Select * from @SIU12Table)
		BEGIN
			INSERT HL7ActionTypeObject(HL7PartnerMessageUid, ActionType, ObjectUid, ObjectType, LastModifiedByUid)  
			SELECT c.PartnerMessageUid
						,@S12SendFunction
						,c.ObjectUid
						,@S12ObjectType
						,c.LastModifiedByUid  
			FROM   @SIU12Table c
						INNER JOIN HL7PartnerMessage pm on c.PartnerMessageUid = pm.HL7PartnerMessageUid
						INNER JOIN HL7Partner p ON pm.HL7PartnerUid = p.HL7PartnerUid  
						LEFT JOIN ViewActionTypeObjectPartnerMessage atopm ON c.ObjectUid = atopm.ObjectUid AND pm.HL7PartnerUid = atopm.HL7PartnerUid AND atopm.HL7ActionTypeObjectUid IS NULL
						LEFT Join RelHL7PartnerPatientConsent rhpc on rhpc.PatientUid = (select PatientUid from Appointment where AppointmentUid = c.ObjectUid) and p.HL7PartnerUid = rhpc.HL7PartnerUid
			WHERE (rhpc.ConsentAgreed = 1 OR (p.ConsentStatus = 1 AND rhpc.ConsentAgreed IS NULL) OR p.ConsentRequired = 0)
						--If not changed ConsentAgreed = NULL, if denied = 0, if consent is given = 1.
		END
-- New Appointment end


-- Update Appointment start
DECLARE @SIU14Table TABLE (PartnerMessageUid UNIQUEIDENTIFIER, ObjectUid UNIQUEIDENTIFIER, LastModifiedByUid UNIQUEIDENTIFIER)
DECLARE @S14ObjectType varchar(25) = ''appointment''
DECLARE @S14SendFunction varchar(25) = ''updateappointment''
		--Check to ensure there is a valid partner otherwise exits trigger
		IF NOT EXISTS (SELECT TOP 1 * FROM HL7PartnerMessage 
						WHERE (SendFunction = @S14SendFunction)	AND Send = 1 AND Inactive = 0)
		RETURN
	
	   --Generates Temp SIU14Table
	   INSERT INTO @SIU14Table
       SELECT DISTINCT PartnerMessageUid = pm.HL7PartnerMessageUid
			, objectuid=i.appointmentuid
			, LastModifiedByUid = i.LastModifiedByUid 
	   from	hl7partnermessage pm 
				inner join hl7partner p on pm.hl7partneruid = p.hl7partneruid  
				cross join inserted i 
				inner join appointment apt on i.appointmentuid = apt.appointmentuid 
				left join viewactiontypeobjectpartnermessage atopm on i.appointmentuid = atopm.objectuid and atopm.objecttype=''appointment''
				 and pm.hl7partneruid = atopm.hl7partneruid and atopm.sendfunction in (''newappointment'', ''updateappointment'')
				left join deleted d on i.appointmentuid = d.appointmentuid
		where	pm.sendfunction = ''updateappointment'' and  
				pm.send = 1 and  
				pm.inactive = 0 and  
				p.inactive = 0 and  
				atopm.hl7actiontypeobjectuid is null and
				d.appointmentuid is not null and-- this insert is for updated appointments only
				apt.PatientUid is not null

		--Checks to ensure SIU14Table has values and then inserts the values into HL7ATO to send SIUs
		IF Exists (Select * from @SIU14Table)
		BEGIN
			INSERT HL7ActionTypeObject(HL7PartnerMessageUid, ActionType, ObjectUid, ObjectType, LastModifiedByUid)  
			SELECT c.PartnerMessageUid
						,@S14SendFunction
						,c.ObjectUid
						,@S14ObjectType
						,c.LastModifiedByUid  
			FROM   @SIU14Table c
						INNER JOIN HL7PartnerMessage pm on c.PartnerMessageUid = pm.HL7PartnerMessageUid
						INNER JOIN HL7Partner p ON pm.HL7PartnerUid = p.HL7PartnerUid  
						LEFT JOIN ViewActionTypeObjectPartnerMessage atopm ON c.ObjectUid = atopm.ObjectUid AND pm.HL7PartnerUid = atopm.HL7PartnerUid AND atopm.HL7ActionTypeObjectUid IS NULL
						LEFT Join RelHL7PartnerPatientConsent rhpc on rhpc.PatientUid = (select PatientUid from Appointment where AppointmentUid = c.ObjectUid) and p.HL7PartnerUid = rhpc.HL7PartnerUid
			WHERE (rhpc.ConsentAgreed = 1 OR (p.ConsentStatus = 1 AND rhpc.ConsentAgreed IS NULL) OR p.ConsentRequired = 0)
						--If not changed ConsentAgreed = NULL, if denied = 0, if consent is given = 1. 
		END
-- update appointment end

-- cancel appointment start
DECLARE @SIU15Table TABLE (PartnerMessageUid UNIQUEIDENTIFIER, ObjectUid UNIQUEIDENTIFIER, LastModifiedByUid UNIQUEIDENTIFIER)
DECLARE @S15ObjectType varchar(25) = ''appointment''
DECLARE @S15SendFunction varchar(25) = ''CancelAppointment''
		--Check to ensure there is a valid partner otherwise exits trigger
		IF NOT EXISTS (SELECT TOP 1 * FROM HL7PartnerMessage 
						WHERE (SendFunction = @S15SendFunction)	AND Send = 1 AND Inactive = 0)
		RETURN

	   --Generates Temp SIU15Table
		INSERT INTO @SIU15Table
		SELECT DISTINCT	PartnermessageUid = pm.HL7PartnerMessageUid
		,ObjectUid = i.AppointmentUid
		,LastModifiedByUid = i.LastModifiedByUid  
		FROM	HL7PartnerMessage pm 
				INNER JOIN HL7Partner p ON pm.HL7PartnerUid = p.HL7PartnerUid  
				CROSS JOIN inserted i 
				INNER JOIN Appointment apt ON i.AppointmentUid = apt.AppointmentUid 
				LEFT JOIN ViewActionTypeObjectPartnerMessage atopm ON i.AppointmentUid = atopm.ObjectUid AND atopm.ObjectType=''Appointment''
				 AND pm.HL7PartnerUid = atopm.HL7PartnerUid AND atopm.SendFunction IN (''CancelAppointment'')
				LEFT JOIN DELETED D ON i.AppointmentUid = d.AppointmentUid
				LEFT JOIN ListAppointmentStatus las ON i.AppointmentStatusUid = las.AppointmentStatusUid
		WHERE	pm.SendFunction = ''CancelAppointment'' AND  
				pm.Send = 1 AND  
				pm.Inactive = 0 AND  
				p.Inactive = 0 AND  
				atopm.HL7ActionTypeObjectUid IS NULL AND
				(las.Name in (''Canceled'',''Cancelled'') OR las.IsCanceledStatus = 1) and
				d.AppointmentUid IS NOT NULL and-- THIS INSERT IS FOR CANCELED APPOINTMENTS ONLY
				apt.PatientUid is not null

		--Checks to ensure SIU15Table has values and then inserts the values into HL7ATO to send SIUs
		IF Exists (Select * from @SIU15Table)
		BEGIN
			INSERT HL7ActionTypeObject(HL7PartnerMessageUid, ActionType, ObjectUid, ObjectType, LastModifiedByUid)  
			SELECT c.PartnerMessageUid
						,@S15SendFunction
						,c.ObjectUid
						,@S15ObjectType
						,c.LastModifiedByUid  
			FROM   @SIU15Table c
						INNER JOIN HL7PartnerMessage pm on c.PartnerMessageUid = pm.HL7PartnerMessageUid
						INNER JOIN HL7Partner p ON pm.HL7PartnerUid = p.HL7PartnerUid  
						LEFT JOIN ViewActionTypeObjectPartnerMessage atopm ON c.ObjectUid = atopm.ObjectUid AND pm.HL7PartnerUid = atopm.HL7PartnerUid AND atopm.HL7ActionTypeObjectUid IS NULL
						LEFT Join RelHL7PartnerPatientConsent rhpc on rhpc.PatientUid = (select PatientUid from Appointment where AppointmentUid = c.ObjectUid) and p.HL7PartnerUid = rhpc.HL7PartnerUid
			WHERE (rhpc.ConsentAgreed = 1 OR (p.ConsentStatus = 1 AND rhpc.ConsentAgreed IS NULL) OR p.ConsentRequired = 0)
						--If not changed ConsentAgreed = NULL, if denied = 0, if consent is given = 1.
		END
-- cancel appointment end

-- check in appointment start
DECLARE @AptCheckInSIUTable TABLE (PartnerMessageUid UNIQUEIDENTIFIER, ObjectUid UNIQUEIDENTIFIER, LastModifiedByUid UNIQUEIDENTIFIER)
DECLARE @AptCheckInObjectType varchar(25) = ''appointment''
DECLARE @AptCheckInSendFunction varchar(25) = ''CheckInAppointment''
		--Check to ensure there is a valid partner otherwise exits trigger
		IF NOT EXISTS (SELECT TOP 1 * FROM HL7PartnerMessage 
						WHERE (SendFunction = @AptCheckInSendFunction)	AND Send = 1 AND Inactive = 0)
		RETURN

	   --Generates Temp SIUTable
		INSERT INTO @AptCheckInSIUTable
		SELECT DISTINCT	PartnermessageUid = pm.HL7PartnerMessageUid
		,ObjectUid = i.AppointmentUid
		,LastModifiedByUid = i.LastModifiedByUid  
		FROM	HL7PartnerMessage pm 
				INNER JOIN HL7Partner p ON pm.HL7PartnerUid = p.HL7PartnerUid  
				CROSS JOIN inserted i 
				INNER JOIN Appointment apt ON i.AppointmentUid = apt.AppointmentUid 
				LEFT JOIN ViewActionTypeObjectPartnerMessage atopm ON i.AppointmentUid = atopm.ObjectUid AND atopm.ObjectType=''Appointment''
				 AND pm.HL7PartnerUid = atopm.HL7PartnerUid AND atopm.SendFunction IN (''CheckInAppointment'')
				LEFT JOIN DELETED D ON i.AppointmentUid = d.AppointmentUid
				LEFT JOIN ListAppointmentStatus las ON i.AppointmentStatusUid = las.AppointmentStatusUid
		WHERE	pm.SendFunction = ''CheckInAppointment'' AND  
				pm.Send = 1 AND  
				pm.Inactive = 0 AND  
				p.Inactive = 0 AND  
				atopm.HL7ActionTypeObjectUid IS NULL AND
				las.Name in (''CheckedIn'', ''Checked In'', ''Checked-In'') and
				d.AppointmentUid IS NOT NULL and-- THIS INSERT IS FOR CHECKEDIN APPOINTMENTS ONLY
				apt.PatientUid is not null

		--Checks to ensure SIUTable has values and then inserts the values into HL7ATO to send SIUs
		IF Exists (Select * from @AptCheckInSIUTable)
		BEGIN
			INSERT HL7ActionTypeObject(HL7PartnerMessageUid, ActionType, ObjectUid, ObjectType, LastModifiedByUid)  
			SELECT c.PartnerMessageUid
						,@AptCheckInSendFunction
						,c.ObjectUid
						,@AptCheckInObjectType
						,c.LastModifiedByUid  
			FROM   @AptCheckInSIUTable c
						INNER JOIN HL7PartnerMessage pm on c.PartnerMessageUid = pm.HL7PartnerMessageUid
						INNER JOIN HL7Partner p ON pm.HL7PartnerUid = p.HL7PartnerUid  
						LEFT JOIN ViewActionTypeObjectPartnerMessage atopm ON c.ObjectUid = atopm.ObjectUid AND pm.HL7PartnerUid = atopm.HL7PartnerUid AND atopm.HL7ActionTypeObjectUid IS NULL
						LEFT Join RelHL7PartnerPatientConsent rhpc on rhpc.PatientUid = (select PatientUid from Appointment where AppointmentUid = c.ObjectUid) and p.HL7PartnerUid = rhpc.HL7PartnerUid
			WHERE (rhpc.ConsentAgreed = 1 OR (p.ConsentStatus = 1 AND rhpc.ConsentAgreed IS NULL) OR p.ConsentRequired = 0)
						--If not changed ConsentAgreed = NULL, if denied = 0, if consent is given = 1.
		END

END

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[interface_marklabsreadytosend]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[interface_marklabsreadytosend] on [dbo].[Appointment] 
for insert, update
as

/*
purpose: used to track the orm message when status changes to checked in
*/
--check this first since there is no use reading data from the database if we don''t have anything to do
--  (nothing in inserted table)
if 0 = (select count(*) from inserted) 
      return 

if dbo.IsReplicating() <> 0
      return


if 0= (select count(*) from listmisc where name=''appointmentstatusmarklabsreadytosend_newoption'' and val=''true'')
      return

--set the generatelaborder flag for observationorder rows where the flag is not already set (generatelaborder = 0), 
--  and the observationorder row refers to a procedure that has a laboratory attached
update oo set generatelaborder = 1, --select appointmentuid
	LastModifiedDate = GETUTCDATE()
from inserted a
inner join deleted d on a.appointmentuid = d.appointmentuid
inner join listappointmentstatus las on a.appointmentstatusuid = las.appointmentstatusuid
inner join visit v on a.appointmentuid = v.appointmentuid --only care about appointments in inserted that are attached to visits
inner join observationorder oo on v.visituid = oo.visituid --only care about visits with observationorder rows
inner join visitprocedure vp on oo.visitprocedureuid = vp.visitprocedureuid
--left join listprocedure lp on vp.procedureuid = lp.procedureuid
cross apply(   -- only care about ones that have possible LaboratoryOrder
   SELECT TOP 1 *
   FROM RelProcedureLaboratoryOrder rel
   WHERE rel.ProcedureUid = vp.ProcedureUid
   ORDER BY rel.DisplayOrder) tab
where oo.generatelaborder = 0 
  --and lp.laboratoryuid is not null 
  and a.appointmentstatusuid <> d.appointmentstatusuid --status on the appointment changed
  and las.name in (''checked in'',''checkedin'',''ready to discharge'',''arrived'') --these are the targets for the new appointment status to cause the update
  and oo.IsDelete = 0 -- don''t update strikeout rows
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[SyndromicSurveillance_Appointment_Discharge]'))
EXEC dbo.sp_executesql @statement = N'
/***** Trigger for Syndromic Surveillance ADT messages****/
CREATE TRIGGER [dbo].[SyndromicSurveillance_Appointment_Discharge] ON [dbo].[Appointment] FOR INSERT, UPDATE AS  
IF dbo.IsCacheClient() = 0
BEGIN

	DECLARE @ObjectType varchar(25)
	DECLARE @SendFunction varchar(25)
	
	Set @ObjectType = ''Visit''
	Set @SendFunction =''SyndromicSurveillance''
	
	IF NOT EXISTS (SELECT TOP 1 * 	FROM HL7PartnerMessage 
	WHERE (SendFunction = @SendFunction)	AND Send = 1 AND Inactive = 0)
		RETURN

	DECLARE @ADT_Table TABLE  
	(
	PartnerMessageUid UNIQUEIDENTIFIER --Array element contents  
	)  

	INSERT INTO @ADT_Table
	SELECT	PM.HL7PartnerMessageUid 
	FROM	HL7partner P 
			LEFT JOIN HL7PartnerMessage PM ON PM.HL7partnerUid=P.HL7partnerUid
	WHERE 
			PM.MessageType = ''ADT'' 
			AND PM.MessageEvent = ''A03''
			AND PM.SendFunction = @SendFunction
			AND PM.Inactive = 0  
			AND P.Inactive = 0 
			AND PM.Send = 1

	DECLARE @VisitUid UNIQUEIDENTIFIER
	DECLARE @PatientUid UNIQUEIDENTIFIER
	DECLARE @AppointmentStatusUid UNIQUEIDENTIFIER

	DECLARE ADT_CUR CURSOR FAST_FORWARD LOCAL FOR 
	SELECT VisitUid, v.PatientUid, i.AppointmentStatusUid 
	FROM INSERTED i JOIN Visit V on i.AppointmentUid=v.AppointmentUid

	OPEN ADT_CUR
	FETCH NEXT FROM ADT_CUR INTO @VisitUid, @PatientUid, @AppointmentStatusUid
	WHILE @@FETCH_STATUS =0
	BEGIN
		--THIS SECTION DECIDES IF A CCD SHOULD BE SENT
		IF (@Visituid is not null AND  @AppointmentStatusUid =''31886389-631F-4D03-BC28-B4DB87E9B172''  
			AND Exists (Select * from Visit where VisitUid = @VisitUid and IsCompleted=1) )  
		BEGIN

			--delete any rows in hl7actiontypeobject that match the ones we are about to create
			DELETE from HL7ActionTypeObject WHERE HL7ActionTypeObjectUid in
			(SELECT HL7ActionTypeObjectUid FROM HL7ActionTypeObject ato
			JOIN @ADT_Table a ON ato.HL7PartnerMessageUid = a.PartnerMessageUid
			WHERE ato.ObjectUid = @VisitUid and ato.ActionType = @SendFunction and ato.ObjectType = @ObjectType)

			DELETE from HL7Message where HL7MessageUid in
			(SELECT HL7MessageUid FROM HL7Message hm
			JOIN @ADT_Table a ON hm.HL7PartnerMessageUid = a.PartnerMessageUid
			WHERE hm.OriginalObjectUid = @VisitUid and hm.OriginalActionType = @SendFunction and hm.OriginalObjectType = @ObjectType)
			
			
			INSERT	HL7ActionTypeObject(HL7ActionTypeObjectUid,HL7PartnerMessageUid, ActionType, ObjectUid, ObjectType, LastModifiedDate)  
			SELECT	NewID(),PartnerMessageUid, @SendFunction, @VisitUid, @ObjectType, getUTCDate()
			FROM	@ADT_Table

		END
		NEXT_LOOP:
		FETCH NEXT FROM ADT_CUR INTO @VisitUid, @PatientUid, @AppointmentStatusUid
	END
	CLOSE ADT_CUR
	DEALLOCATE ADT_CUR
	SET NOCOUNT OFF
END



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[tr_Appointment_IU]'))
EXEC dbo.sp_executesql @statement = N'








CREATE Trigger [dbo].[tr_Appointment_IU] on [dbo].[Appointment] after insert, update
as
IF dbo.IsReplicating() <> 0
RETURN; 
begin
	declare @insertedappointmentuid uniqueidentifier,
		@triggeroverride bit,
		@calendaruid uniqueidentifier,
		@startdatetime datetime,
		@enddatetime datetime

	select @insertedappointmentuid = appointmentuid,
		@triggeroverride = triggeroverride,
		@calendaruid = calendaruid,
		@startdatetime = startdatetime,
		@enddatetime = enddatetime
	from inserted

    -- manage update on checkin and discharge times based upon status changes
	update appointment set checkindatetime = getutcdate(), dischargedatetime = null, RoomOccupancyStatus = 1,
			LastModifiedDate = GETUTCDATE()
		where appointmentuid in 
			(select i.appointmentuid from inserted i inner join deleted d on i.appointmentuid = d.appointmentuid
				where i.appointmentstatusuid = ''cd2a0578-0c89-4151-b4e9-66ed9d5b4995''
				and i.appointmentstatusuid <> d.appointmentstatusuid) -- only when changed to checkin
				
	update appointment set dischargedatetime = getutcdate(), RoomOccupancyStatus = 0,
			LastModifiedDate = GETUTCDATE()
		where appointmentuid in 
			(select i.appointmentuid from inserted i inner join deleted d on i.appointmentuid = d.appointmentuid
				where i.appointmentstatusuid = ''31886389-631f-4d03-bc28-b4db87e9b172''
				and i.appointmentstatusuid <> d.appointmentstatusuid) -- only when changed to discharged

	update appointment set RoomOccupancyStatus = 0, -- set to 0 where iscanceled or scheduled
			LastModifiedDate = GETUTCDATE()
		where appointmentuid in 
			(select i.appointmentuid from inserted i inner join deleted d on i.appointmentuid = d.appointmentuid
				where (i.appointmentstatusuid = ''17982339-1DFE-4D69-AC0E-8F3AF4087255'' -- scheduled
					or i.appointmentstatusuid IN (SELECT appointmentstatusuid FROM ListAppointmentStatus WHERE IsCanceledStatus = 1)) -- any canceled status
				and i.appointmentstatusuid <> d.appointmentstatusuid) 

	insert into relappointmenthistory (AppointmentUid, AppointmentStatusUid, LastModifiedDate) -- populate history
	     select i.AppointmentUid, i.AppointmentStatusUid, i.LastModifiedDate
		      from inserted i 
				left join deleted d on i.AppointmentUid = d.AppointmentUid
				where d.AppointmentUid is null or i.AppointmentStatusUid <> d.AppointmentStatusUid

	update app set dischargedatetime = d.dischargedatetime,
		LastModifiedDate = GETUTCDATE()
	from inserted i
		  join deleted d on i.appointmentuid = d.appointmentuid
		  join appointment app on app.appointmentuid = i.appointmentuid
	where d.dischargedatetime is not null    -- keep the dischargedatetime if already exists
		and (i.DischargeDateTime is null or i.DischargeDateTime <> d.DischargeDateTime) --don''t always do an update

	update app set checkindatetime = d.checkindatetime,
		LastModifiedDate = GETUTCDATE()
	from inserted i
		  join deleted d on i.appointmentuid = d.appointmentuid
		  join appointment app on app.appointmentuid = i.appointmentuid
	where d.checkindatetime is not null    -- keep the checkindatetime if already exists
		and (i.checkindatetime is null or i.checkindatetime <> d.checkindatetime) --don''t always do an update

	delete	r
	from	inserted i inner join ListAppointmentStatus las ON i.AppointmentStatusUid = las.AppointmentStatusUid
			inner join RelCalendarTemplateHeadDaySlotExclude r ON i.AppointmentUid = r.AppointmentUid
	where	las.IsCanceledStatus = 1

	-- execute this trigger only when triggeroverride is true
	if @triggeroverride = 1
	begin
		declare @sqlscript varchar(8000)
			--@canceledappointmentstatusuid uniqueidentifier,
			--@noshowappointmentstatusuid uniqueidentifier

		--select @canceledappointmentstatusuid = appointmentstatusuid from listappointmentstatus where name = ''canceled'' and userdefined <> 1
		--select @noshowappointmentstatusuid = appointmentstatusuid from listappointmentstatus where name = ''no show'' and userdefined <> 1
		
		--and appointmentstatusuid not in ('''''' + cast(@canceledappointmentstatusuid as varchar(40)) + '''''', '''''' + cast(@noshowappointmentstatusuid as varchar(40)) + '''''')
		--and appointmentstatusuid not in (select appointmentstatusuid from listappointmentstatus where showonschedule=0 and userdefined <> 0)

		create table #apt (appointmentuid uniqueidentifier, appointmenttypeuid uniqueidentifier, blocking bit)
		-- check for existing appointments and blocking events
		select @sqlscript = ''insert into #apt select appointmentuid, appointmenttypeuid, blocking
					from viewcalendarappointments with(nolock)
					where calendaruid = '''''' + cast(@calendaruid as varchar(40)) + ''''''
					and appointmentuid <> '''''' + cast(@insertedappointmentuid as varchar(40)) + ''''''
					and (('''''' + substring(convert(varchar(40),@startdatetime, 20), 1, 16) + '''''' >= startdatetime and '''''' + substring(convert(varchar(40),@startdatetime, 20), 1, 16) + '''''' < enddatetime)
					or ('''''' + substring(convert(varchar(40),@enddatetime, 20), 1, 16) + '''''' > startdatetime and '''''' + substring(convert(varchar(40),@enddatetime, 20), 1, 16) + '''''' < enddatetime)
					or ('''''' + substring(convert(varchar(40),@startdatetime, 20), 1, 16) + '''''' <= startdatetime and '''''' + substring(convert(varchar(40),@enddatetime, 20), 1, 16) + '''''' >= enddatetime))''

		execute (@sqlscript)

		if @@rowcount > 0
		begin
			declare	@numappointments int,
				@numblockingappointments int,
				@numblockingappointmentsnotype int,
				@bookinglevel tinyint

			-- for now, we''re using booking level to mean either allow overbooking(2) or not(1)
			-- future enhancement is to use the booking level to determine how many appointments can be booked in one time period
			select @bookinglevel = bookinglevel from listcalendar where calendaruid = @calendaruid
			--if @bookinglevel = 1 -- removed as not allowing overlapping appointments to ''show'' on overbookable calendars
				set @numappointments = coalesce((select count(blocking) from #apt where blocking = 0 group by blocking), 0)
			--else
				--set @numappointments = 0

			set @numblockingappointments = coalesce((select count(blocking) from #apt where blocking = 1 group by blocking), 0)
			-- these are basically event appointments
			set @numblockingappointmentsnotype = coalesce((select count(blocking) from #apt where blocking = 1 and appointmenttypeuid is null group by blocking), 0)

			if @numappointments <> 0 or @numblockingappointments <> 0 or @numblockingappointmentsnotype <> 0
			begin
				declare @strerror varchar(MAX),
					@appointmentuid uniqueidentifier,
					@appointmenttypeuid uniqueidentifier
				select @strerror = ''apptrig'' + cast(@numappointments as varchar(3)) + '';''

				if @numblockingappointmentsnotype <> 0
				begin
					select top 1 @appointmentuid = appointmentuid from #apt where blocking = 1 and appointmenttypeuid is null
					select @strerror = @strerror + cast(@appointmentuid as varchar(40))
				end

				select @strerror = @strerror + '';''
	
				declare apt_cursor cursor fast_forward local for
				select appointmentuid
				from #apt
				where blocking = 1
				and appointmenttypeuid is not null
	
				open apt_cursor
				
				fetch next from apt_cursor
				into @appointmentuid
				while @@fetch_status = 0
				begin
					select @strerror = @strerror + cast(@appointmentuid as varchar(40)) + '',''
	
					fetch next from apt_cursor
					into @appointmentuid
				end
		
				close apt_cursor
				deallocate apt_cursor
	
				drop table #apt
				
				raiserror (@strerror, 16, 1)
				select appointmentuid from deleted
				if (@@rowcount = 0)
					delete from appointment 
					where appointmentuid = @insertedappointmentuid
				return
			end
		end
		drop table #apt
	
		update 
			appointment 
		set 
			triggeroverride = 0,
			lastmodifieddate = getutcdate()
		where 
			appointmentuid = @insertedappointmentuid
	end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[AR_Ledger_InsteadOf_Delete]'))
EXEC dbo.sp_executesql @statement = N'
CREATE trigger [dbo].[AR_Ledger_InsteadOf_Delete] ON [dbo].[AR_Ledger] INSTEAD OF DELETE AS
BEGIN
	SET NOCOUNT ON;
	
	IF (dbo.AllowFinancialBatchOverride()=0) AND EXISTS(SELECT VARB.ArBatchUid 
				FROM AR_ViewBatchClosingsLockedClosed VARB WITH(NOLOCK)
					INNER JOIN deleted D ON VARB.ArBatchUid = D.ArBatchUid
				WHERE VARB.IsLocked = 1 OR VARB.IsClosed = 1)
	BEGIN
		RAISERROR(''AR_Ledger_InsteadOf_Delete: can not delete ledger in a locked or closed batch.'',16,1);
		RETURN ;
	END
	
	DECLARE @originatorId VARBINARY(128);
	SELECT @originatorId = dbo.GetChangeTrackingContextFromContextInfo();

	WITH CHANGE_TRACKING_CONTEXT(@originatorId)
	DELETE FROM AR_LedgerDetail WHERE LedgerUid IN (SELECT LedgerUid FROM deleted);
	
	WITH CHANGE_TRACKING_CONTEXT(@originatorId)
	DELETE FROM AR_Ledger WHERE LedgerUid IN (SELECT LedgerUid FROM deleted);

END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[AR_LedgerDetail_InsteadOf_Insert]'))
EXEC dbo.sp_executesql @statement = N'





CREATE trigger [dbo].[AR_LedgerDetail_InsteadOf_Insert] on [dbo].[AR_LedgerDetail] instead of insert as
begin
      --print ''ar_ledgerdetail_insteadof_insert it is here''
      set nocount on;
      
      declare @var int
      set @var  = cast(substring(context_info(),1,4) as int)
      
      if (dbo.AllowFinancialBatchOverride()=0) -- bug 38902 - Added NOLOCKs
      begin
            if exists(select varb.arbatchuid  -- validate for closed or locked batch
                              from arbatch varb WITH (NOLOCK)
                                    inner join ar_ledger arl WITH (NOLOCK) on varb.arbatchuid = arl.arbatchuid
                                    inner join inserted i on arl.ledgeruid = i.ledgeruid
                              where varb.islocked = 1 or varb.isclosed = 1)
            begin
                  raiserror(''AR_LedgerDetail_InsteadOf_Insert: can not update ledger in a locked or closed batch.'',16,1)
                  return 
            end
            
            if exists(select i.ledgerdetailuid  -- validate for closed financial center
                              from arbatch varb WITH (NOLOCK)
                                    inner join ar_ledger arl WITH (NOLOCK) on varb.arbatchuid = arl.arbatchuid
                                    inner join inserted i on arl.ledgeruid = i.ledgeruid
                                    inner join financialcenter fc WITH (NOLOCK) on i.financialcenteruid = fc.financialcenteruid
                              where not i.financialcenteruid is null
                                    and varb.gldate <= fc.arclosedthroughdate)
            begin
                  raiserror(''AR_LedgerDetail_InsteadOf_Insert: can not update ledger financial center where closed.'',16,1)
                  return 
            end
      end

	DECLARE @originatorId VARBINARY(128);
	SELECT @originatorId = dbo.GetChangeTrackingContextFromContextInfo();

	WITH CHANGE_TRACKING_CONTEXT(@originatorId)
	insert into ar_ledgerdetail
		select * from inserted

end




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[EKOS_AR_Ledger_SuperbillClaim_InsertUpdate]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[EKOS_AR_Ledger_SuperbillClaim_InsertUpdate] ON [dbo].[AR_LedgerDetail]   
FOR INSERT,UPDATE

AS  
BEGIN  

IF @@ROWCOUNT = 0  
RETURN  

	IF dbo.IsCacheClient() = 0  
	BEGIN  
		SET NOCOUNT ON  

			IF NOT EXISTS (select 1
						from TransmissionConfiguration tc WITH(NOLOCK)
						inner join ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
						where tc.TransmissionType = ''EKOS'' and
							lip.Inactive = 0 )
			RETURN;

		--SYSTEM DEFINED GUID FOR READY TO SUBMIT
		DECLARE @ReadyToSubmitSuperbillStatusUid uniqueidentifier = ''55ED3239-89F3-4488-89C9-71BE5A541CC4''
		--SYSTEM DEFINED GUID FOR READY TO REVIEW
		DECLARE @ReadyToReviewSuperbillStatusUid uniqueidentifier =''D2291C14-3F4E-4381-80A7-883C76C9499B''
		--SYSTEM DEFINED GUID FOR PRELIMINARY 
		DECLARE @PreliminarySuperbillStatusUid uniqueidentifier =''DF81BE7C-71CF-47F4-8573-733E81E30EA8''
		--SYSTEM DEFINED GUID FOR REJECTED
		DECLARE @RejectedSuperbillStatusUid uniqueidentifier = ''2C4A6E7D-EB6D-4370-A836-5937363C6B69'' 
		--SYSTEM DEFINED GUID FOR ERAREJECTED
		DECLARE @EraRejectedSuperbillStatusUid uniqueidentifier = ''2352F0FB-708B-437E-9809-F80128195F9E''
		--SYSTEM DEFINED GUID FOR FILED
		DECLARE @FiledSuperbillStatusUid uniqueidentifier =''9FFE6214-7C7F-4516-9899-43D37FABE21D''
	    --SYSTEM DEFINED GUID FOR COMPLETE
		DECLARE @CompleteSuperbillStatusUid uniqueidentifier = ''30F64D66-55CB-4438-BB2F-7A6250399312''  
		--SYSTEM DEFINED GUID FOR REFILED
		DECLARE @RefiledSuperbillStatusUid uniqueidentifier = ''A8258278-7182-45DC-869F-790F46F2C177''
		--SYSTEM DEFINED GUID FOR PENDING PATIENT PAYMENT
		DECLARE @PendingPatientPaymentSuperbillStatusUid uniqueidentifier = ''D2BF0F3C-6E03-478F-BDAE-4DCAC5EB9410''


		DECLARE @superbillstatus table (MapFromSuperbillStatusUid uniqueidentifier,MapToSuperbillStatusUid uniqueidentifier)
		DECLARE @ExcludeFinancialCenter VARCHAR(MAX) = NULL

		SELECT @ExcludeFinancialCenter = CONVERT(XML, AdditionalOutboundXML).value(''(//FinancialCentersOptOut)[1]'',''VARCHAR(MAX)'')
		FROM ListIntegrationPartner WHERE IntegrationPartnerUid = ''20C576DF-A670-4A58-85DE-CAA4BA5151E0''
 
		--ADD EKOS Generic status
		 INSERT INTO @superbillstatus (MapFromSuperbillStatusUid) values (@PreliminarySuperbillStatusUid),(@ReadyToReviewSuperbillStatusUid),(@ReadyToSubmitSuperbillStatusUid),(@EraRejectedSuperbillStatusUid),
		(@RejectedSuperbillStatusUid),(@FiledSuperbillStatusUid) , (@CompleteSuperbillStatusUid), (@RefiledSuperbillStatusUid),(@PendingPatientPaymentSuperbillStatusUid)

     --Add Mapped Superbill Status
		INSERT INTO @superbillstatus (MapFromSuperbillStatusUid, MapToSuperbillStatusUid)
		SELECT DISTINCT  MI.FindTableFromItemUid, mi.FindTableToItemUid
		FROM  MapItem MI WITH(NOLOCK)
		JOIN MapSource MS WITH(NOLOCK) ON MI.MapSourceUid=MS.MapSourceUid AND MS.MapSourceUid=''ACB1C24D-992C-4DDC-ACEE-4BBE84C0FD5A'' AND MS.Inactive=0
		JOIN @superbillstatus LS ON MI.FindTableToItemUid=LS.MapFromSuperbillStatusUid  AND mi.FindTableFromItemUid IS NOT NULL 
  
		DECLARE @Superbills TABLE (SuperbillUid UNIQUEIDENTIFIER, SuperbillStatusUid UNIQUEIDENTIFIER, PatientUid UNIQUEIDENTIFIER, LastModifiedByUid UNIQUEIDENTIFIER)
		INSERT INTO @Superbills
		SELECT DISTINCT s.SuperbillUid, s.SuperbillStatusUid, PatientUid, arl.LastModifiedByUid
		FROM INSERTED i
		INNER JOIN AR_Ledger arl WITH(NOLOCK) on i.LedgerUid = arl.LedgerUid AND i.IsCredit = 1 and arl.EntryType > 1
		INNER JOIN SuperbillProcedure sp WITH(NOLOCK) on i.SuperbillProcedureUid = sp.SuperbillProcedureUid
		INNER JOIN Superbill s WITH(NOLOCK) on sp.SuperbillUid = s.SuperbillUid
		INNER JOIN @superbillstatus ls on s.SuperbillStatusUid=ls.MapFromSuperbillStatusUid
		WHERE (@ExcludeFinancialCenter IS NULL OR (i.FinancialCenterUid IS NULL OR i.FinancialCenterUid NOT IN (SELECT element FROM dbo.Split(@ExcludeFinancialCenter,'',''))))

		IF NOT EXISTS (SELECT 1 FROM @Superbills)
			RETURN;

		--END: Return out

		BEGIN 
			DELETE TransmissionOutbound where TransmissionOutboundUid in  
			(  
				SELECT TransmissionOutboundUid  
				from TransmissionOutbound tod
				INNER JOIN @Superbills s on tod.ForeignObjectUid = s.SuperbillUid
						AND tod.Description IN (''SUPERBILLCLAIM'')
						AND tod.Status <> 100
			)   


			INSERT INTO TransmissionOutbound (TransmissionType,Description ,ForeignObjectUid, RawMessage, PatientUid,  lastmodifiedbyuid, LastModifiedDate)  
			SELECT  tc.TransmissionType, ''SUPERBILLCLAIM'',i.SuperbillUid, ''iMedica.Prm.BusinessObject.Superbill'',i.PatientUid,i.LastModifiedByUid, GETUTCDATE() 
							FROM TransmissionConfiguration tc WITH(NOLOCK)
							INNER JOIN ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
							CROSS JOIN @Superbills i
							WHERE tc.TransmissionType = ''EKOS'' 
								and lip.Inactive = 0 
								--AND i.SuperbillStatusUid <> @CanceledSuperbillStatusUid

		END  
	END
END' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[ARBatch_UPDATE]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[ARBatch_UPDATE]
   on  [dbo].[ARBatch]
   after update
as 
begin

	set nocount on;

    -- replication
	-- replication from site to cache machine should not be a problem as it is an insert into a new table (no trigger needed on insert)
	-- ui does not allow deletes of a batch (no trigger needed on delete), for now keep this open for patient purge. replication must insure consistancy
    -- on update from site to cache, should never be going from close to complete to open so should not block
    -- on update from site to cache, even open to closed with changes should be ok, do not block that move
	-- on update from site to master, will need to block ability of cache machine to do financials
	-- on site to site, must address financials

	-- trigger is now in effect - test for changes 

	declare @datafieldschanged bit -- breaking this out for readability even though requires an extra read and code
	select @datafieldschanged = 0 -- evaluate for all non islocked and non iscompleted field changes
	if exists(select i.arbatchuid
		from inserted i
		inner join deleted d on i.arbatchuid = d.arbatchuid
		where 
			-- field checks (diff on each as neo updates all fields so ''update()'' will not work)
			-- this allows ''exceptions'' for fields that have no impact on financials (like replication sync data)
			(d.inactive <> i.inactive 
				or d.gldate <> i. gldate
				or d.owneruid <> i.owneruid
				or d.name <> i.name -- name and externalid would not impact financial ''numbers''
				or d.externalid <> i.externalid -- however, will result in reports changing ... so should block (will not block notes as a text field and ui allows)
				-- allow edit on lastmodifieddate and lastmodifiedbyuid for notes update (all that the ui will allow also)
			)
		) -- paren closes out the exists
	begin
		select @datafieldschanged = 1
	end

	if (dbo.AllowFinancialBatchOverride()=0) AND exists(select i.arbatchuid
		from inserted i
		inner join deleted d on i.arbatchuid = d.arbatchuid
		where 
			-- evaluate lock/complete status - each line flags a state that will block the update
			(
				(d.islocked = 1 and (@datafieldschanged = 1 and i.islocked=1)) -- on a soft closed batch, only allow changes if new value is ''unlocked''
																							-- even on lock or closed status change , allow non datafieldchanges only
			)  
		) -- paren closes out the exists
	begin
		rollback -- rollback update within trigger
		raiserror(''ARBatch_UPDATE: can not update completed or closed batch.'',16,1) -- throw error
		return
	end

/* testing
	declare @arbatchuid uniqueidentifier
	select top 1 @arbatchuid = arbatchuid from arbatch where isclosed = 0 and islocked = 0
	select * from arbatch where arbatchuid = @arbatchuid
	update arbatch set name = ''oldname'' where arbatchuid = @arbatchuid -- test all good
	update arbatch set name = ''newname'' where arbatchuid = @arbatchuid -- test all good

	update arbatch set name = ''locked'', islocked = 1 where arbatchuid = ''70f30200-b5d1-4636-9977-45e279145e12'' -- test all good
	update arbatch set name = ''trytoupdatelocked'' where arbatchuid = ''70f30200-b5d1-4636-9977-45e279145e12'' -- should fail

	update arbatch set name = ''closed'', isclosed = 1 where arbatchuid = ''70f30200-b5d1-4636-9977-45e279145e12'' -- test all good
	update arbatch set name = ''trytounclose'' where arbatchuid = ''70f30200-b5d1-4636-9977-45e279145e12'' -- should fail

	update arbatch set name = ''lockedandclosed'', islocked = 1, isclosed = 1 where arbatchuid = ''cdcdaeed-389b-423b-8f85-4631ef3ed34c'' -- test all good
	update arbatch set notes = ''new notes'' where arbatchuid = ''cdcdaeed-389b-423b-8f85-4631ef3ed34c'' -- should succeed - let notes go ...

	update arbatch set name = ''locked'', islocked = 1 where arbatchuid = ''10f62b2b-0529-4d7c-96d4-48e4eafc08e9'' -- test all good
	update arbatch set name = ''new notes'', islocked = 0 where arbatchuid = ''10f62b2b-0529-4d7c-96d4-48e4eafc08e9'' -- should succeed - can unlock
	update arbatch set name = ''unlocksuccessfull'' where arbatchuid = ''10f62b2b-0529-4d7c-96d4-48e4eafc08e9'' -- test all good

	update arbatch set name = ''locked'', islocked = 1 where arbatchuid = ''10f62b2b-0529-4d7c-96d4-48e4eafc08e9'' -- test all good
	update arbatch set isclosed = 1 where arbatchuid = ''10f62b2b-0529-4d7c-96d4-48e4eafc08e9'' -- should succeed - can close a locked batch
	update arbatch set notes = ''try edit on closed batch'' where arbatchuid = ''10f62b2b-0529-4d7c-96d4-48e4eafc08e9'' -- notes should be ok
	update arbatch set name = ''try edit on closed batch'' where arbatchuid = ''10f62b2b-0529-4d7c-96d4-48e4eafc08e9'' -- should fail

	update arbatch set name = ''unlocked'' where arbatchuid = ''03cfb8b6-449b-4469-981c-4a86dbfa7071'' -- test all good
	update arbatch set name = ''locked'', islocked = 1 where arbatchuid = ''03cfb8b6-449b-4469-981c-4a86dbfa7071'' -- test all good
	update arbatch set isclosed = 1 where arbatchuid = ''03cfb8b6-449b-4469-981c-4a86dbfa7071'' -- should succeed - can close a locked batch
	update arbatch set isclosed = 0 where arbatchuid = ''03cfb8b6-449b-4469-981c-4a86dbfa7071'' -- shoudl fail on try to unclose

	select * from arbatch where arbatchuid = ''70f30200-b5d1-4636-9977-45e279145e12''

*/

end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[attachment_delete]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[attachment_delete] on [dbo].[Attachment] after delete
as 
begin
	set nocount on;

	update	p
	set		driverlicenseattachmentuid = null,
			LastModifiedDate = getutcdate()
	from	person p inner join deleted d on p.driverlicenseattachmentuid = d.attachmentuid
	
	update	p
	set		driverlicenseattachmentuid = null,
			LastModifiedDate = getutcdate()
	from	person p inner join deleted d on p.photoattachmentuid = d.attachmentuid	
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[attachment_savecontent]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[attachment_savecontent] on [dbo].[Attachment] 
after update

as
set nocount on

declare @idstofix table
(	auid uniqueidentifier  )

-- protect special fields to avoid being overwritten by bug in send lab orders button
if exists (select top 1 * from inserted) and 
	exists (select top 1 * from deleted)
begin
	insert into @idstofix
	select i.attachmentuid
		from inserted i
		join deleted d on i.attachmentuid = d.attachmentuid
		where i.attachmentcontentsize = -1 and
			i.attachmentcontentsize <> d.attachmentcontentsize

	update a
		set attachmentcontentsize = d.attachmentcontentsize,
			LastModifiedDate = GETUTCDATE()
		from attachment a
		join @idstofix i on a.attachmentuid = i.auid
		join deleted d on i.auid = d.attachmentuid
		
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[AuditArchive_Delete]'))
EXEC dbo.sp_executesql @statement = N'
CREATE TRIGGER [dbo].[AuditArchive_Delete] ON [dbo].[AuditArchive] AFTER DELETE AS 
BEGIN
	IF [dbo].[IsReplicating] () <> 0
		RETURN

	ROLLBACK
	RAISERROR (''Audit deletes are not allowed.'', 19, 1) WITH LOG;
END


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[AuditArchive_Update]'))
EXEC dbo.sp_executesql @statement = N'
CREATE TRIGGER [dbo].[AuditArchive_Update] ON [dbo].[AuditArchive] AFTER UPDATE AS 
BEGIN
	IF UPDATE([Type]) OR UPDATE([Changes]) OR UPDATE([TableName]) OR UPDATE(Workstation) OR UPDATE(UserUid) OR UPDATE([Description]) OR UPDATE(ChangeDate) OR UPDATE(LastModifiedDate) OR UPDATE(LastModifiedByUid)
	BEGIN
		IF [dbo].[IsReplicating] () <> 0
			RETURN

		ROLLBACK
		RAISERROR (''Audit updates are not allowed, other columns.'', 19, 1) WITH LOG;		
	END
	IF UPDATE(PatientUid) 
	BEGIN
		IF EXISTS (	SELECT	*
					FROM	inserted i INNER JOIN deleted d ON i.AuditUid = d.AuditUid 
					WHERE	(i.PatientUid IS NULL AND d.PatientUid IS NOT NULL) OR
							(i.PatientUid IS NOT NULL AND d.PatientUid IS NULL)
				  )
		BEGIN
			IF [dbo].[IsReplicating] () <> 0
				RETURN

			ROLLBACK
			RAISERROR (''Audit updates are not allowed to change patient.'', 19, 1) WITH LOG;		
		END
	END
END

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[AuditCurrent_Delete]'))
EXEC dbo.sp_executesql @statement = N'
CREATE TRIGGER [dbo].[AuditCurrent_Delete] ON [dbo].[AuditCurrent] AFTER DELETE AS 
BEGIN
   IF [dbo].[IsReplicating] () <> 0
      RETURN

	ROLLBACK
	RAISERROR (''Audit deletes are not allowed.'', 19, 1) WITH LOG;
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[AuditCurrent_Update]'))
EXEC dbo.sp_executesql @statement = N'
CREATE TRIGGER [dbo].[AuditCurrent_Update] ON [dbo].[AuditCurrent] AFTER UPDATE AS 
BEGIN
	IF UPDATE([Type]) OR UPDATE([Changes]) OR UPDATE([TableName]) OR UPDATE(Workstation) OR UPDATE(UserUid) OR UPDATE([Description]) OR UPDATE(ChangeDate) OR UPDATE(LastModifiedDate) OR UPDATE(LastModifiedByUid)
	BEGIN
		IF [dbo].[IsReplicating] () <> 0
			RETURN

		ROLLBACK
		RAISERROR (''Audit updates are not allowed, other columns.'', 19, 1) WITH LOG;		
	END
	IF UPDATE(PatientUid) 
	BEGIN
		IF EXISTS (	SELECT	*
					FROM	inserted i INNER JOIN deleted d ON i.AuditUid = d.AuditUid 
					WHERE	(i.PatientUid IS NULL AND d.PatientUid IS NOT NULL) OR
							(i.PatientUid IS NOT NULL AND d.PatientUid IS NULL)
				  )
		BEGIN
			IF [dbo].[IsReplicating] () <> 0
				RETURN

			ROLLBACK
			RAISERROR (''Audit updates are not allowed to change patient.'', 19, 1) WITH LOG;		
		END
	END
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[ccsystem_delete]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[ccsystem_delete] on [dbo].[CCSystem] after delete as
begin
	set nocount on;
	delete	s
	from	listsystem s inner join deleted d on s.systemuid = d.ccsystemuid
	where	not s.systemuid in (select rossystemuid from rossystem) 
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[ClaimBatchDetail_SuperbillAggregate_Delete]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[ClaimBatchDetail_SuperbillAggregate_Delete] on [dbo].[ClaimBatchDetail] after delete as
begin
	set nocount on;

    update	sa
	set		firstfileddate = dbo.ConvertToTimeZonePracticeSettings((select min(claimdate) from claimbatch cb inner join claimbatchdetail cbd on cb.claimbatchuid = cbd.claimbatchuid where cbd.superbilluid = ins.superbilluid)),
			lastfileddate = dbo.ConvertToTimeZonePracticeSettings((select max(claimdate) from claimbatch cb inner join claimbatchdetail cbd on cb.claimbatchuid = cbd.claimbatchuid where cbd.superbilluid = ins.superbilluid))
	from	inserted ins inner join superbillaggregate sa on ins.superbilluid = sa.superbilluid
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[ClaimBatchDetail_SuperbillAggregate_Insert_Update]'))
EXEC dbo.sp_executesql @statement = N'




CREATE trigger [dbo].[ClaimBatchDetail_SuperbillAggregate_Insert_Update] on [dbo].[ClaimBatchDetail] after insert, update as
begin
	set nocount on;

    declare @superbilstatus as varchar(50)

    select @superbilstatus =  inserted.status  
    from inserted 
	join superbill on inserted.superbilluid = superbill.superbilluid 
	join listsuperbillstatus on superbill.superbillstatusuid = listsuperbillstatus.superbillstatusuid

    update	sa
	set		firstfileddate = 
			case 
				when @superbilstatus = ''queued rejected''
				then sa.firstfileddate
				when @superbilstatus =  ''queued'' and sa.firstfileddate is null
				then null
				when @superbilstatus =  ''queued'' and sa.firstfileddate is not null
				then sa.firstfileddate
				when @superbilstatus =  ''ready to send'' 
				then sa.firstfileddate 			
				when @superbilstatus =  ''sent'' 
				then sa.firstfileddate 
				when @superbilstatus =  ''filed'' 
				     or @superbilstatus= ''pending patient payment'' 
				     or @superbilstatus= ''complete''		
				      or @superbilstatus= ''Clearinghouse Upload Complete''				
				then  case 
				         when sa.firstfileddate is null 
				         then dbo.ConvertToTimeZonePracticeSettings(cb.claimdate)
                         when dbo.ConvertToTimeZonePracticeSettings(cb.claimdate) < sa.firstfileddate 
                         then dbo.ConvertToTimeZonePracticeSettings(cb.claimdate)
                         else sa.firstfileddate 
                      end
                 else
                    sa.firstfileddate
			end,
			lastfileddate  =  
			case 
				when (@superbilstatus =  ''queued rejected'')
				then sa.lastfileddate
				when (@superbilstatus =  ''queued'') 
				      and sa.lastfileddate is null
				then null
				when (@superbilstatus =  ''queued'') 
				      and sa.lastfileddate is not null
				then sa.lastfileddate				
				when @superbilstatus =  ''ready to send'' 
				then sa.lastfileddate 
				when @superbilstatus =  ''sent'' 
				then sa.lastfileddate 	
				when (@superbilstatus =  ''filed'' 
				      or @superbilstatus= ''pending patient payment'' 
				      or @superbilstatus= ''complete'' or  @superbilstatus= ''Clearinghouse Upload Complete'')
				then case 
					    when sa.lastfileddate is null 
					    then dbo.ConvertToTimeZonePracticeSettings(cb.claimdate)
                        when dbo.ConvertToTimeZonePracticeSettings(cb.claimdate) > sa.lastfileddate then dbo.ConvertToTimeZonePracticeSettings(cb.claimdate) 
                     else 
					    sa.lastfileddate										
					 end
				 else
                    sa.lastfileddate
			end
	from  inserted ins 
	inner join claimbatch cb on ins.claimbatchuid = cb.claimbatchuid
	inner join superbillaggregate sa on ins.superbilluid = sa.superbilluid
	where	sa.firstfileddate is null 
	        or sa.firstfileddate is not null 
	        or sa.lastfileddate is null 
	        or dbo.ConvertToTimeZonePracticeSettings(cb.claimdate) < sa.firstfileddate 
			or dbo.ConvertToTimeZonePracticeSettings(cb.claimdate) > sa.lastfileddate
end


--Previous Version

--	set nocount on;

--    declare @superbilstatus as varchar(50)
--	select @superbilstatus =  inserted.status  from inserted 
--							join superbill on inserted.superbilluid = superbill.superbilluid 
--							join listsuperbillstatus on superbill.superbillstatusuid = listsuperbillstatus.superbillstatusuid
--	--insert into test (stat) select @superbilstatus 						
----    if (@superbilstatus = ''queued rejected primary'' or @superbilstatus = ''queued rejected secondary'' or @superbilstatus = ''queued rejected tertiary'')
----    begin 
----	insert into test (stat) select ''skipping''
----		return
----
----    end
----    insert into test (stat) select ''changing''
--    update	sa
--	set		firstfileddate = 
--			case 
--				when (@superbilstatus = ''queued rejected primary'' or @superbilstatus = ''queued rejected secondary'' or @superbilstatus = ''queued rejected tertiary'')
--				then sa.firstfileddate
--				when (@superbilstatus =  ''queued primary'' or @superbilstatus = ''queued secondary'' or @superbilstatus= ''queued tertiary'') and sa.firstfileddate is null
--				then null
--				when (@superbilstatus =  ''queued primary'' or @superbilstatus = ''queued secondary'' or @superbilstatus= ''queued tertiary'') and sa.firstfileddate is not null
--				then sa.firstfileddate
--				when @superbilstatus =  ''ready to send'' then sa.firstfileddate 
				
--				when @superbilstatus =  ''sent'' then sa.firstfileddate 

--				when (@superbilstatus =  ''filed primary'' or @superbilstatus = ''filed secondary'' or @superbilstatus= ''filed quaternary''
--				or @superbilstatus= ''pending patient payment'' or @superbilstatus= ''complete'')
						
--				then  case when sa.firstfileddate is null then cb.claimdate
--                                  when cb.claimdate < sa.firstfileddate then cb.claimdate 
--                                  else sa.firstfileddate end
--                 else
--                 sa.firstfileddate
--			end,

--			lastfileddate  =  
--			case 
--				when (@superbilstatus =  ''queued rejected primary'' or @superbilstatus = ''queued rejected secondary'' or @superbilstatus= ''queued rejected tertiary'' )
--				then sa.lastfileddate
--				when (@superbilstatus =  ''queued primary'' or @superbilstatus = ''queued secondary'' or @superbilstatus= ''queued tertiary'') and sa.lastfileddate is null
--				then null

--				when (@superbilstatus =  ''queued primary'' or @superbilstatus = ''queued secondary'' or @superbilstatus= ''queued tertiary'') and sa.lastfileddate is not null
--				then sa.lastfileddate
				
--				when @superbilstatus =  ''ready to send'' then sa.lastfileddate 

--				when @superbilstatus =  ''sent'' then sa.lastfileddate 
	
--				when (@superbilstatus =  ''filed primary'' or @superbilstatus = ''filed secondary'' or @superbilstatus= ''filed quaternary''
--				or @superbilstatus= ''pending patient payment'' or @superbilstatus= ''complete'')

--				then case 
--								when sa.lastfileddate is null then cb.claimdate
--                                when cb.claimdate > sa.lastfileddate then cb.claimdate 
--                     else 
--					  sa.lastfileddate
										
--					 end
				
----			else
----
----								  case when sa.lastfileddate is null then cb.claimdate
----                                  when cb.claimdate > sa.lastfileddate then cb.claimdate 
----                                  else 
----										 sa.lastfileddate
----										
----								  end
--                 else
--                 sa.lastfileddate
--			end
--	from	inserted ins inner join claimbatch cb on ins.claimbatchuid = cb.claimbatchuid
--		inner join superbillaggregate sa on ins.superbilluid = sa.superbilluid
--	where	sa.firstfileddate is null or sa.firstfileddate is not null or
--			sa.lastfileddate is null or 
--			/*sa.lastfileddate is not null or*/
--			cb.claimdate < sa.firstfileddate or 
--			cb.claimdate > sa.lastfileddate



--------use [prm2009]
--------go
--------/****** object:  trigger [dbo].[claimbatchdetail_superbillaggregate_insert_update]    script date: 06/24/2009 23:09:14 ******/
--------set ansi_nulls on
--------go
--------set quoted_identifier on
--------go
--------alter trigger [dbo].[claimbatchdetail_superbillaggregate_insert_update] on [dbo].[claimbatchdetail] after insert, update as
--------begin
--------	set nocount on;
----------    declare @superbilstatus as varchar(50)
----------	select @superbilstatus =  inserted.status  from inserted 
----------							join superbill on inserted.superbilluid = superbill.superbilluid 
----------							join listsuperbillstatus on superbill.superbillstatusuid = listsuperbillstatus.superbillstatusuid
--------    update	sa
--------	set		firstfileddate = 
--------			case 
--------				when ins.status like /*@superbilstatus */''%queued rejected%'' then sa.firstfileddate
--------			else
--------								  case when sa.firstfileddate is null then cb.claimdate
--------                                  when cb.claimdate < sa.firstfileddate then cb.claimdate 
--------                                  else sa.firstfileddate end
--------			end,
--------
--------			lastfileddate  =  
--------			case 
--------				when ins.status like /*@superbilstatus */''%queued rejected%'' then sa.lastfileddate
--------			else
--------
--------								 case when sa.lastfileddate is null then cb.claimdate
--------                                  when cb.claimdate > sa.lastfileddate then cb.claimdate 
--------                                  else sa.lastfileddate end
--------			end
--------	from	inserted ins inner join claimbatch cb on ins.claimbatchuid = cb.claimbatchuid
--------			inner join superbillaggregate sa on ins.superbilluid = sa.superbilluid
--------	where	sa.firstfileddate is null or 
--------			sa.lastfileddate is null or 
--------			/*sa.lastfileddate is not null or*/
--------			cb.claimdate < sa.firstfileddate or 
--------			cb.claimdate > sa.lastfileddate
--------
--------
--------
--------end
----igor note 6/16/2009. will keep old trigger in case it needs to be restored
--------use [prm2009]
--------go
--------/****** object:  trigger [dbo].[claimbatchdetail_superbillaggregate_insert_update]    script date: 06/15/2009 16:39:39 ******/
--------set ansi_nulls on
--------go
--------set quoted_identifier on
--------go
--------alter trigger [dbo].[claimbatchdetail_superbillaggregate_insert_update] on [dbo].[claimbatchdetail] after insert, update as
--------begin
--------	set nocount on;
--------    update	sa
--------	set		firstfileddate = case when sa.firstfileddate is null then cb.claimdate
--------                                  when cb.claimdate < sa.firstfileddate then cb.claimdate 
--------                                  else sa.firstfileddate end,
--------			lastfileddate  = case when sa.lastfileddate is null then cb.claimdate
--------                                  when cb.claimdate > sa.lastfileddate then cb.claimdate 
--------                                  else sa.lastfileddate end
--------	from	inserted ins inner join claimbatch cb on ins.claimbatchuid = cb.claimbatchuid
--------			inner join superbillaggregate sa on ins.superbilluid = sa.superbilluid
--------	where	sa.firstfileddate is null or
--------			cb.claimdate < sa.firstfileddate or 
--------			cb.claimdate > sa.lastfileddate
--------end





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[EKOS_ClaimFormatValue_Update]'))
EXEC dbo.sp_executesql @statement = N'
CREATE TRIGGER [dbo].[EKOS_ClaimFormatValue_Update] 
   ON  [dbo].[ClaimFormatValue] 
   AFTER INSERT,UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	if not exists (
		Select *
		from TransmissionConfiguration tc WITH(NOLOCK)
		inner join ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
		where 
			tc.TransmissionType = ''EKOS'' and
			lip.Inactive = 0 
		)
	begin
		return
	end
       
	IF dbo.IsCacheClient() = 0  
	begin
		-- Insert statements for trigger here
		update p
		set LastModifiedDate = p.LastModifiedDate --just causing trigger to fire
		from inserted i 
		join Person p WITH(NOLOCK) on i.ProviderUid = p.PersonUid
	end
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[coblineadjustments_ar_transaction_update]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[coblineadjustments_ar_transaction_update] on [dbo].[COBLineAdjustments] after update as
begin
	set nocount on;

    update coblineadjustments
    set transactionuid = art.transactionuid,
		LastModifiedDate = getutcdate()
    from coblineadjustments cobla
			inner join inserted i on cobla.coblineadjustmentsuid = i.coblineadjustmentsuid 
									  and cobla.transactionuid is null
			inner join deposit d on i.deposituid = d.deposituid
			inner join superbillprocedure sbp on i.superbillprocedureuid = sbp.superbillprocedureuid
			inner join ar_transaction art on d.deposituid = art.deposituid 
												and sbp.superbilluid = art.superbilluid
			                                 

end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[CollectionStatusLevel_InsertUpdate]'))
EXEC dbo.sp_executesql @statement = N'
CREATE TRIGGER [dbo].[CollectionStatusLevel_InsertUpdate] 
   ON  [dbo].[CollectionStatusLevel]
   AFTER INSERT,UPDATE
AS 
BEGIN
	SET NOCOUNT ON;

    UPDATE CollectionStatusLevel
		SET BalanceTo = NULL	
			FROM CollectionStatusLevel CSL
				INNER JOIN inserted I ON CSL.CollectionStatusLevelUid = I.CollectionStatusLevelUid
			WHERE I.GreaterThan = 1 AND NOT I.BalanceTo IS NULL

END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[CommunicationPreference_AppointmentConnect_ClearOnUpdate]'))
EXEC dbo.sp_executesql @statement = N'

CREATE   Trigger [dbo].[CommunicationPreference_AppointmentConnect_ClearOnUpdate] on [dbo].[CommunicationPreference] after update
as
IF dbo.IsReplicating() <> 0
RETURN; 

IF (SELECT Inactive FROM ListIntegrationPartner WHERE Name = ''CGM Connection'' OR IntegrationPartnerUid = ''E1D0A4E0-DB48-4105-8E22-4A3577507364'')= 1
	RETURN;

begin

	-- resend modified appointments to connect again
	DELETE FROM RelAppointmentConnect
		WHERE AppointmentUid IN 
			(SELECT AppointmentUid 
				FROM Appointment
				WHERE PatientUid IN (SELECT PersonUid FROM deleted)
			);

end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[Corporation_Computed_Insert_Update]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[Corporation_Computed_Insert_Update] ON [dbo].[Corporation] FOR INSERT,UPDATE AS 
BEGIN
	SET NOCOUNT ON;

	IF UPDATE(Address) OR UPDATE(Phone1) OR UPDATE(Phone2) OR UPDATE(Phone3) OR UPDATE(Phone4)
		UPDATE	c
		SET		Computed_Address_Address1 = i.[Address].value(''(/Address/Address1)[1]'', ''varchar(100)''),
				Computed_Address_Address2 = i.[Address].value(''(/Address/Address2)[1]'', ''varchar(100)''),
				Computed_Address_City = i.[Address].value(''(/Address/City)[1]'', ''varchar(100)''),
				Computed_Address_State = i.[Address].value(''(/Address/State)[1]'', ''varchar(100)''),
				Computed_Address_Zip = i.[Address].value(''(/Address/Zip)[1]'', ''varchar(100)''),                      
				Computed_Phone1_PhoneNumber = i.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''varchar(50)''),
				Computed_Phone1_PhoneType = i.Phone1.value(''(/Phone/PhoneType)[1]'', ''varchar(100)''),
				Computed_Phone2_PhoneNumber = i.Phone2.value(''(/Phone/PhoneNumber)[1]'', ''varchar(50)''),
				Computed_Phone2_PhoneType = i.Phone2.value(''(/Phone/PhoneType)[1]'', ''varchar(100)''),
				Computed_Phone3_PhoneNumber = i.Phone3.value(''(/Phone/PhoneNumber)[1]'', ''varchar(50)''),
				Computed_Phone3_PhoneType = i.Phone3.value(''(/Phone/PhoneType)[1]'', ''varchar(100)''),
				Computed_Phone4_PhoneNumber = i.Phone4.value(''(/Phone/PhoneNumber)[1]'', ''varchar(50)''),
				Computed_Phone4_PhoneType = i.Phone4.value(''(/Phone/PhoneType)[1]'', ''varchar(100)'')
		FROM	inserted i INNER JOIN Corporation c ON i.CorporationUid = c.CorporationUid
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[EKOS_Guarantor_Corporation_update]'))
EXEC dbo.sp_executesql @statement = N'
CREATE trigger [dbo].[EKOS_Guarantor_Corporation_update] on [dbo].[Corporation] for update as
BEGIN	

SET NOCOUNT ON   
  
    IF NOT EXISTS (SELECT * 
				 FROM TransmissionConfiguration tc WITH(NOLOCK)
                 INNER JOIN ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
			     WHERE tc.TransmissionType = ''EKOS'' AND
					   lip.Inactive = 0 )
  RETURN;

  if not exists ( select  1  from inserted )
    return

  if dbo.IsReplicating() = 0
  begin

		insert    TransmissionOutbound(TransmissionType, ForeignObjectUid, RawMessage,lastmodifiedbyuid, LastModifiedDate)
		select    distinct ''EKOS'', arp.AccountResponsiblePartyUid, ''iMedica.Prm.BusinessObject.AccountResponsibleParty'', i.lastmodifiedbyuid, GETUTCDATE()
		from      TransmissionConfiguration tc WITH(NOLOCK)
        inner join ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
		cross join inserted i 
		inner join AccountResponsibleParty arp WITH(NOLOCK) on i.CorporationUid = arp.CorporationUid
	    where     tc.TransmissionType = ''EKOS'' and
        lip.Inactive = 0 


  end
end

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[UpdateProviderUidOnInsertForMUII]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[UpdateProviderUidOnInsertForMUII] ON [dbo].[DocumentBatch] FOR INSERT 

AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;
  if not exists ( select top 1 * from inserted )
    return

	DECLARE @Providers TABLE (ProviderUid VARCHAR(MAX), ProviderName VARCHAR(MAX))
	DECLARE @ProviderUid VARCHAR(MAX)
			,@ProviderName VARCHAR(MAX)
			,@startDateString VARCHAR(8) = CONVERT(CHAR(8),CONVERT(DATE, (SELECT i.ReportParametersXml.value(''(parameters/StartDate)[1]'',''VARCHAR(MAX)'') FROM INSERTED i)),112)
			,@endDateString VARCHAR(8) = CONVERT(CHAR(8),CONVERT(DATE, (SELECT i.ReportParametersXml.value(''(parameters/EndDate)[1]'',''VARCHAR(MAX)'') FROM INSERTED i)),112)
			,@FinancialCenterETIN VARCHAR(50) = NULL

	IF EXISTS(SELECT * FROM Inserted WHERE BatchType LIKE ''CQM%'')
	BEGIN
		DECLARE @LatestVersion VARCHAR(50)
		SELECT @LatestVersion = MAX(CQMVersion) FROM MASTER_MU2_InterfaceDataMapping

		UPDATE db
		SET db.BatchType = CASE WHEN i.ReportParametersXml.value(''(parameters/CQMVersion)[1]'',''VARCHAR(MAX)'') <> '''' THEN i.ReportParametersXml.value(''(parameters/CQMVersion)[1]'',''VARCHAR(MAX)'') ELSE @LatestVersion END
		FROM Documentbatch db
		INNER JOIN Inserted i on db.DocumentBatchUid = i.DocumentBatchUid-- AND i.ReportParametersXml.value(''(parameters/CQMVersion)[1]'',''VARCHAR(MAX)'') < > '''' AND i.ReportParametersXml.value(''(parameters/CQMVersion)[1]'',''VARCHAR(MAX)'') IS NOT NULL

		IF (SELECT ReportParametersXml.value(''(parameters/CQMVersion)[1]'',''VARCHAR(MAX)'') FROM Inserted) = '''' OR (SELECT ReportParametersXml.value(''(parameters/CQMVersion)[1]'',''VARCHAR(MAX)'') FROM Inserted) IS NULL
		BEGIN
			UPDATE db
			SET ReportParametersXml.modify(''insert<CQMVersion>{sql:variable("@LatestVersion")}</CQMVersion> as last into (parameters)[1]'')
			FROM DocumentBatch db
			INNER JOIN Inserted i on db.DocumentBatchUid = i.DocumentBatchUid

			UPDATE db
			SET ReportParametersXml.modify(''delete (parameters/CQMVersion)[1]'') 
			FROM DocumentBatch db
			INNER JOIN Inserted i on db.DocumentBatchUid = i.DocumentBatchUid		
		END		

		IF EXISTS(SELECT ReportParametersXml FROM Inserted WHERE ReportParametersXml.value(''(parameters/ProviderUid)[1]'',''VARCHAR(MAX)'') = '''')
		BEGIN
				INSERT INTO @Providers
				SELECT pr.PersonUid, (pr.LastName+'', ''+pr.FirstName)
				FROM ViewFindProvider pr
				WHERE IsActiveUser = 1 AND Inactive = 0
		
				SET @ProviderUid = ''''
				SELECT @ProviderUid = @ProviderUid + ProviderUid+'',''
				FROM @Providers
		
				IF LEN(@ProviderUid) > 0
					SELECT @ProviderUid = LEFT(@ProviderUid, LEN(@ProviderUid) - 1)	
				
				SET @ProviderName = ''''
				SELECT @ProviderName = @ProviderName + ProviderName+'';''
				FROM @Providers
		
				IF LEN(@ProviderName) > 0
					SELECT @ProviderName = LEFT(@ProviderName, LEN(@ProviderName) - 1)				

				UPDATE db
				SET ReportParametersXml.modify(''insert<ProviderUid>{sql:variable("@ProviderUid")}</ProviderUid> as last into (parameters)[1]'')
				FROM DocumentBatch db
				INNER JOIN Inserted i on db.DocumentBatchUid = i.DocumentBatchUid

				UPDATE db
				SET ReportParametersXml.modify(''delete (parameters/ProviderUid)[1]'') 
				FROM DocumentBatch db
				INNER JOIN Inserted i on db.DocumentBatchUid = i.DocumentBatchUid
			
				UPDATE db
				SET ReportParametersXml.modify(''insert<Provider>{sql:variable("@ProviderName")}</Provider> as last into (parameters)[1]'')
				FROM DocumentBatch db
				INNER JOIN Inserted i on db.DocumentBatchUid = i.DocumentBatchUid

				UPDATE db
				SET ReportParametersXml.modify(''delete (parameters/Provider)[1]'') 
				FROM DocumentBatch db
				INNER JOIN Inserted i on db.DocumentBatchUid = i.DocumentBatchUid

		END

		UPDATE db
		SET ReportParametersXml.modify(''insert<startDateString>{sql:variable("@startDateString")}</startDateString> as last into (parameters)[1]'')
		FROM DocumentBatch db
		INNER JOIN Inserted i on db.DocumentBatchUid = i.DocumentBatchUid

		UPDATE db
		SET ReportParametersXml.modify(''insert<endDateString>{sql:variable("@endDateString")}</endDateString> as last into (parameters)[1]'')
		FROM DocumentBatch db
		INNER JOIN Inserted i on db.DocumentBatchUid = i.DocumentBatchUid

		DECLARE @DocumentBatchUid UNIQUEIDENTIFIER, @ErrorFromID NVARCHAR(MAX)
		--DECLARE @DocumentBatchUid UNIQUEIDENTIFIER, @ErrorFromID NVARCHAR(MAX),@ETIN NVARCHAR(MAX)
		SELECT @DocumentBatchUid = DocumentBatchUid FROM INSERTED
		IF @ProviderUid IS NULL
			SELECT @ProviderUid = ReportParametersXml.value(''(parameters/ProviderUid)[1]'',''VARCHAR(MAX)'') FROM Inserted
		IF @FinancialCenterETIN IS NULL
			SELECT @FinancialCenterETIN = ReportParametersXml.value(''(parameters/ReportingFinancialCenterETIN)[1]'',''VARCHAR(MAX)'') FROM Inserted
		
		EXEC CQM_IDCheck 
			@DocumentBatchUid
			,@ProviderUid
			,@FinancialCenterETIN
			,@ErrorFromID OUTPUT
			--,@ETIN OUTPUT

		IF @ErrorFromID IS NOT NULL
		BEGIN
			UPDATE db
			SET Aggregate_Error = @ErrorFromID
			FROM DocumentBatch db
			INNER JOIN INSERTED i on db.DocumentBatchUid = i.DocumentBatchUid

			RAISERROR (@ErrorFromID, -- Message text.
						10, -- Severity.
						1 -- State.
						);
			RETURN;
		END

		--BEGIN
			--UPDATE db
			--SET ReportParametersXml.modify(''insert<ETIN>{sql:variable("@ETIN")}</ETIN> as last into (parameters)[1]'')
			--FROM DocumentBatch db
			--INNER JOIN Inserted i on db.DocumentBatchUid = i.DocumentBatchUid
		--END
	END
END' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[ValidatePatientReports]'))
EXEC dbo.sp_executesql @statement = N'
-- =============================================
-- Author:		Kevin Crumpton
-- Create date: 02-03-2014
-- Description:	Validates patient reports when saved to the database
-- 20140828 -- nest update and cursor in IF for speed.
-- 20181101 -- Removed patient check for cert - Donald Havien
-- =============================================
CREATE TRIGGER [dbo].[ValidatePatientReports] ON [dbo].[DocumentBatchPatient]
AFTER INSERT
	,UPDATE
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	IF EXISTS (
			SELECT *
			FROM INSERTED i
			WHERE i.PatientReportExportFilename IS NULL
			)
	BEGIN
		--THIS SECTION AUTOGENERATES THE EXPORT FILENAME FOR LATER TROUBLESHOOTING
		UPDATE dbp
		SET dbp.PatientReportExportFilename = ''PatientReport_'' + convert(VARCHAR(50), dbp.DocumentBatchPatientUid) + ''.xml''
		FROM DocumentBatchPatient dbp
		INNER JOIN inserted I ON DBP.DocumentBatchPatientUid = I.DocumentBatchPatientUid
		WHERE dbp.PatientReportExportFilename IS NULL
	END

	IF EXISTS (
			SELECT *
			FROM INSERTED i
			WHERE i.PatientReportXml IS NOT NULL
			)
	BEGIN
		DECLARE @DocumentBatchPatientUid UNIQUEIDENTIFIER
		DECLARE @PatientReportXml XML
		DECLARE @Error VARCHAR(max)
		DECLARE @FoundError BIT = 0

		-- Insert statements for trigger here
		DECLARE ReportsCursor CURSOR FAST_FORWARD LOCAL
		FOR
		SELECT DocumentBatchPatientUid
			,PatientReportXml
		FROM INSERTED
		WHERE PatientReportXml IS NOT NULL

		OPEN ReportsCursor

		FETCH NEXT
		FROM ReportsCursor
		INTO @DocumentBatchPatientUid
			,@PatientReportXml

		WHILE @@FETCH_STATUS = 0
		BEGIN
			SELECT @Error = NULL

			SELECT @FoundError = 0

			--STEP 1
			--call validation stored procs here
			--EXEC DocumentBatch_PQRS_ValidateHIC @PatientReportXml
			--	,@Error OUTPUT

			--STEP 2
			--if we found an error, append it to the error string of the report
			IF (ISNULL(@Error, '''') <> '''')
			BEGIN
				SELECT @FoundError = 1

				UPDATE DocumentBatchPatient
				SET Error = isnull(Error, '''') + @Error
				WHERE DocumentBatchPatientUid = @DocumentBatchPatientUid
			END

			--STEP 3
			--reset error variable to null
			SELECT @Error = NULL

			--*******
			--INSERT ADDITIONAL VALIDATION PROCS HERE, BE SURE TO PUT STEPS 1-3 IN SEQUENCE FOR EACH NEW VALIDATION
			--*******
			IF (@FoundError = 1)
			BEGIN
				--clear the report so it won''t be included in the zip file
				UPDATE DocumentBatchPatient
				SET PatientReportXml = NULL
				WHERE DocumentBatchPatientUid = @DocumentBatchPatientUid
			END

			FETCH NEXT
			FROM ReportsCursor
			INTO @DocumentBatchPatientUid
				,@PatientReportXml
		END

		CLOSE ReportsCursor

		DEALLOCATE ReportsCursor
	END
	--IF EXISTS(SELECT PatientExternalId FROM INSERTED WHERE ReportDetailXml.value(''(//Encounter//@Uid)[1]'',''VARCHAR(MAX)'') IS NULL AND PatientReportIntermediateXml IS NOT NULL)
	--BEGIN
	--	UPDATE dbp
	--	SET PatientReportIntermediateXml = NULL, PatientReportXml = NULL
	--	FROM inserted i
	--	INNER JOIN DocumentBatchPatient dbp ON i.DocumentBatchPatientUid = dbp.DocumentBatchPatientUid
	--	WHERE i.ReportDetailXml.value(''(//Encounter//@Uid)[1]'',''VARCHAR(MAX)'') IS NULL
	--END	
END' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[EmailStatus_After_Insert]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[EmailStatus_After_Insert]
   ON  [dbo].[EmailStatus]
   AFTER INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    SELECT ES.EmailAddress, ES.Status, ES.StatusExtension, ESB.BlockToken
		INTO #tempInserted
		FROM inserted ES
			LEFT JOIN EmailStatusBlock ESB ON ES.EmailAddress = ESB.EmailAddress
		WHERE ES.Status IN (''Unsubscribe'',''Group_Unsubscribe'', ''Resubscribe'', ''Group_Resubscribe'');

	INSERT INTO EmailStatusBlock
		SELECT NEWID() AS EmailStatusBlockUid, TI.EmailAddress, 
			CASE WHEN TI.Status = ''Unsubscribe'' THEN TI.Status + '' '' 
				WHEN TI.Status = ''Group_Unsubscribe'' THEN TI.StatusExtension + '' ''
				ELSE NULL END AS BlockToken
		FROM #tempInserted TI
		WHERE TI.BlockToken IS NULL
			AND TI.Status IN (''Unsubscribe'',''Group_Unsubscribe'');

	UPDATE ESB
		SET ESB.BlockToken = ESB.BlockToken + TI.Status + '' ''
		FROM EmailStatusBlock ESB
			INNER JOIN #tempInserted TI ON ESB.EmailAddress = TI.EmailAddress
		WHERE NOT ESB.BlockToken LIKE ''%'' + TI.Status + '' %''
			AND TI.Status = ''Unsubscribe'';

	UPDATE ESB
		SET ESB.BlockToken = ESB.BlockToken + + TI.StatusExtension + '' ''
		FROM EmailStatusBlock ESB
			INNER JOIN #tempInserted TI ON ESB.EmailAddress = TI.EmailAddress
		WHERE NOT ESB.BlockToken LIKE ''%'' + TI.StatusExtension + '' %''
			AND TI.Status = ''Group_Unsubscribe'';

	UPDATE ESB
		SET ESB.BlockToken = REPLACE(ESB.BlockToken, ''Unsubscribe '', '''')
		FROM EmailStatusBlock ESB
			INNER JOIN #tempInserted TI ON ESB.EmailAddress = TI.EmailAddress
		WHERE ESB.BlockToken LIKE ''%Unsubscribe %''
			AND TI.Status IN (''Resubscribe'');

	UPDATE ESB
		SET ESB.BlockToken = REPLACE(ESB.BlockToken, TI.StatusExtension + '' '', '''')
		FROM EmailStatusBlock ESB
			INNER JOIN #tempInserted TI ON ESB.EmailAddress = TI.EmailAddress
		WHERE ESB.BlockToken LIKE ''%'' + TI.StatusExtension + '' %''
			AND TI.Status IN (''Group_Resubscribe'');

	DELETE FROM EmailStatusBlock
		WHERE LTRIM(RTRIM(BlockToken)) = '''';

	DROP TABLE #tempInserted;

END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[Employer_Delete]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[Employer_Delete] ON [dbo].[Employer] AFTER DELETE AS
BEGIN
	DELETE	c
	FROM	deleted d INNER JOIN Corporation c ON d.CorporationUid = c.CorporationUid
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[HL7Backfill]'))
EXEC dbo.sp_executesql @statement = N'
CREATE TRIGGER [dbo].[HL7Backfill]
   ON  [dbo].[HL7ActionTypeObject]
   AFTER DELETE
AS 
BEGIN
	SET NOCOUNT ON;
	IF (SELECT COUNT(*) FROM MessageBackfillQueue) > 0
	BEGIN
		DECLARE @BatchCap INT;
		SELECT TOP 1 @BatchCap = IntegerValue from ListProductParameter where ParameterName = ''HL7BatchCapacity''
		
		IF(@BatchCap is null)
		BEGIN
			SET @BatchCap = 50;
		END

		IF (SELECT COUNT(*) FROM HL7ActionTypeObject WHERE ProcessingError = 0) < @BatchCap
		BEGIN
			DECLARE @ATO TABLE (ATOUid UNIQUEIDENTIFIER)
			INSERT INTO @ATO
			SELECT TOP (@BatchCap) HL7ActionTypeObjectUid FROM MessageBackfillQueue ORDER BY LastModifiedDate ASC
			
			Select * from @ATO

			INSERT INTO HL7ActionTypeObject
			SELECT a.HL7ActionTypeObjectUid,a.HL7PartnerMessageUid,a.ActionType,a.ObjectType,a.ObjectUid
      ,a.MessageContextXML,a.LastModifiedDate,a.LastModifiedByUid,a.ProcessingError 
		FROM MessageBackfillQueue a
			INNER JOIN @ATO b on a.HL7ActionTypeObjectUid = b.ATOUid

			DELETE FROM a
			FROM MessageBackfillQueue a
			INNER JOIN @ATO b on a.HL7ActionTypeObjectUid = b.ATOUid

		END
	END
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[DeDupe_QRDAImportPats]'))
EXEC dbo.sp_executesql @statement = N'
CREATE TRIGGER [dbo].[DeDupe_QRDAImportPats]
   ON  [dbo].[HL7Message]
   AFTER UPDATE
AS 
BEGIN
	IF NOT EXISTS (SELECT 1 FROM HL7Message WHERE HL7PartnerMessageUid = ''1C8D75CD-3495-454C-9456-6BA1E5043DC8'')
		RETURN;

	IF EXISTS (SELECT 1 FROM HL7Message WHERE HL7PartnerMessageUid = ''1C8D75CD-3495-454C-9456-6BA1E5043DC8'' AND Status = 0) 
		AND NOT EXISTS (SELECT 1 FROM ListProductParameter WHERE ProductParameterUid = ''EAD13ABD-3F4D-45B0-8EF4-53D19FC1E17C'')
	BEGIN
		INSERT INTO ListProductParameter (ProductParameterUid, ParameterName, BoolValue)
		VALUES
		(''EAD13ABD-3F4D-45B0-8EF4-53D19FC1E17C'',''QRDAImportBegan'',''1'')
	END

	IF EXISTS (SELECT 1 FROM ListProductParameter WHERE ProductParameterUid = ''EAD13ABD-3F4D-45B0-8EF4-53D19FC1E17C'')
		AND NOT EXISTS (SELECT 1 FROM HL7Message WHERE HL7PartnerMessageUid = ''1C8D75CD-3495-454C-9456-6BA1E5043DC8'' AND Status = 0)
	BEGIN
		EXEC DeDupeImportPats

		DELETE ListProductParameter
		WHERE ProductParameterUid = ''EAD13ABD-3F4D-45B0-8EF4-53D19FC1E17C''
	END
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[HL7_ErrorRetry]'))
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- author:		kevin crumpton
-- create date: 01/23/2007
-- description:	update trigger for hl7message table.  updates retry information when a message is placed into error status (500).
-- =============================================
CREATE trigger [dbo].[HL7_ErrorRetry]
   on  [dbo].[HL7Message] 
   after update
as 
begin
	if @@rowcount = 0
		return

-- Bug 61740 Added below to check if CCD and force it to only attempt resend 2 times.
	IF EXISTS(select originalobjecttype from inserted where inserted.OriginalActionType = ''CCD Generation'')
	BEGIN
		update hl7message
			set retryminutes = 16
		from inserted
		where inserted.hl7messageuid = hl7message.hl7messageuid
		AND inserted.RetryMinutes < 16
		AND inserted.OriginalActionType = ''CCD Generation''
	END
 -- End of changes for Bug 61740

 
	update hl7message
		set retrytime = null,  -- a retry of null means don''t retry
		LastModifiedDate = getutcdate()
	from inserted
		left join HL7PartnerMessage hpm on hpm.HL7PartnerMessageUid = inserted.HL7PartnerMessageUid
	where inserted.hl7messageuid = hl7message.hl7messageuid
			and (hl7message.retryminutes > 32 -- only retry 6 times ( 2^5 = 32 )  and then give up 
				or HPM.MessageType = ''StatementBatch'')

	update hl7message
		set retrytime = dateadd(mi, hl7message.retryminutes, getutcdate()),
			retryminutes = hl7message.retryminutes * 2,
			LastModifiedDate = getutcdate()
	from inserted
	where inserted.hl7messageuid = hl7message.hl7messageuid
			and hl7message.retryminutes <= 32 -- keep retrying until failed 5 times

end



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[CreateMessageForInterfaceMessageError]'))
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		Roberts, Brandon & Beltran, Vincent
-- Create date: 08/09/2016
-- =============================================
CREATE TRIGGER [dbo].[CreateMessageForInterfaceMessageError] 
   ON  [dbo].[HL7MessageError]
   AFTER INSERT
AS 
BEGIN
	SET NOCOUNT ON;

	DECLARE @HL7PMUid UNIQUEIDENTIFIER
	DECLARE @HMUid UNIQUEIDENTIFIER
	SELECT @HL7PMUid = HL7PartnerMessageUid
			,@HMUid = hm.HL7MessageUid
	FROM HL7Message hm
	INNER JOIN Inserted i on hm.HL7MessageUid = i.HL7MessageUid

	IF (SELECT SendError FROM HL7Partner hp INNER JOIN HL7PartnerMessage hpm on hp.HL7PartnerUid = hpm.HL7PartnerUid WHERE hpm.HL7PartnerMessageUid = @HL7PMUid) = 1
	BEGIN
		IF (SELECT RetryMinutes FROM HL7Message WHERE HL7MessageUid = @HMUid) > 2
			RETURN


		DECLARE @Error VARCHAR(MAX)
		DECLARE @RawMessage VARCHAR(MAX)
		DECLARE @XmlMessage VARCHAR(MAX)
		DECLARE @XmlMessageXML XML
		DECLARE @Status INT
		DECLARE @ProvFirstname VARCHAR(500)
		DECLARE @ProvLastName VARCHAR(500)
		DECLARE @Provider UNIQUEIDENTIFIER
		DECLARE @ValidXml BIT
		DECLARE @MessageType VARCHAR(50)
		DECLARE @Partner VARCHAR(500)
		DECLARE @PartnerUid UNIQUEIDENTIFIER 
		DECLARE @Providers TABLE (Uid UNIQUEIDENTIFIER)
		DECLARE @Body VARCHAR(MAX)
		DECLARE @ProviderUid UNIQUEIDENTIFIER
		DECLARE @MessageUid UNIQUEIDENTIFIER

		SELECT @Error = hme.Error
				,@RawMessage = hm.RawMessage
				,@XmlMessage = hm.XmlMessage
				,@MessageType = hpm.MessageType
				,@Partner = hp.Name
				,@PartnerUid = hp.HL7PartnerUid
		FROM Inserted i
		INNER JOIN HL7MessageError hme on hme.HL7MessageErrorUid = i.HL7MessageErrorUid
		INNER JOIN HL7Message hm on hme.HL7MessageUid = hm.HL7MessageUid
		INNER JOIN HL7PartnerMessage hpm on hm.HL7PartnerMessageUid = hpm.HL7PartnerMessageUid
		INNER JOIN HL7Partner hp on hpm.HL7PartnerUid = hp.HL7PartnerUid

		BEGIN TRY
			SELECT @XmlMessageXML = CONVERT(XML, @XmlMessage)
			SET @ValidXml = 1
		END TRY
		BEGIN CATCH
			SET @XmlMessageXML= NULL
			SET @ValidXml = 0
		END CATCH
	
		IF @ValidXml = 1 AND @XmlMessageXML IS NOT NULL
		BEGIN
			IF @MessageType IN (''ORM'',''ORU'')
			BEGIN
				SELECT @ProvLastName = @XmlMessageXML.value(''(//OBR.16/OBR.16.2)[1]'',''VARCHAR(200)'')
				SELECT @ProvFirstname = @XmlMessageXML.value(''(//OBR.16/OBR.16.3)[1]'',''VARCHAR(200)'')

				SELECT TOP 1 @Provider = PersonUid FROM ViewFindProvider
				WHERE LastName = @ProvLastName AND FirstName = @ProvFirstname AND IsActiveUser = 1

				SET @ProvLastName = NULL
				SET @ProvFirstname = NULL

				SELECT @ProvLastName = @XmlMessageXML.value(''(//OBR.28/OBR.28.2)[1]'',''VARCHAR(200)'')
				SELECT @ProvFirstname = @XmlMessageXML.value(''(//OBR.28/OBR.28.3)[1]'',''VARCHAR(200)'')

				SELECT TOP 1 @Provider = PersonUid FROM ViewFindProvider
				WHERE LastName = @ProvLastName AND FirstName = @ProvFirstname AND IsActiveUser = 1
			END
			IF @MessageType IN (''DFT'',''SIU'')
			BEGIN
				SELECT @ProvLastName = @XmlMessageXML.value(''(//PV1.7/PV1.7.2)[1]'',''VARCHAR(200)'')
				SELECT @ProvFirstname = @XmlMessageXML.value(''(//PV1.7/PV1.7.3)[1]'',''VARCHAR(200)'')

				SELECT TOP 1 @Provider = PersonUid FROM ViewFindProvider
				WHERE LastName = @ProvLastName AND FirstName = @ProvFirstname AND IsActiveUser = 1
			END
		END

		INSERT INTO @Providers
		SELECT DISTINCT C2.value(''(@Uid)'', ''VARCHAR(100)'') AS [Uid]
		FROM HL7Partner hp
		cross apply (select cast(hp.AlertUserUid as xml)) as X(X)
		cross apply X.X.nodes(''Users/User'')AS T2(C2)
		WHERE hp.HL7PartnerUid = @PartnerUid


		IF @Provider IS NOT NULL
		BEGIN
			INSERT INTO @Providers
			SELECT @Provider WHERE @Provider NOT IN (SELECT Uid FROM @Providers)
		END

		INSERT INTO @Providers
		SELECT DISTINCT v.MemberUserUid
		FROM ViewUserGroupUser v
		INNER JOIN @Providers ps on v.UserGroupUid = ps.Uid

		DELETE FROM @Providers
		WHERE Uid NOT IN (SELECT PersonUid FROM Person)

		SELECT @Body = ''Errored Message in Interface Data Detail for ''+@Partner


		DECLARE db_cursor CURSOR FOR  
		SELECT Uid
		FROM @Providers

		OPEN db_cursor   
		FETCH NEXT FROM db_cursor INTO @ProviderUid

		WHILE @@FETCH_STATUS = 0
		BEGIN
			   IF (@@fetch_status <> - 2)
			   BEGIN

				SET @MessageUid = NULL
				SELECT TOP 1 @MessageUid = NEWID()

				INSERT INTO Message (MessageUid, MessageTypeUid, Header, MessageUrgencyUid, CreatedDate, CreatedDateTime)
				VALUES
				(@MessageUid, ''10101010-0000-0000-0000-000000000005'',''Message Error in Interface Data Detail'', ''C2A64D38-3BE1-4F8A-8947-EF9E9AD861A4'', CONVERT(DATE,GETUTCDATE()), GETUTCDATE())

				INSERT INTO MessageTask (MessageUid, Note)
				VALUES
				(@MessageUid, @Body)

				INSERT INTO MessageUser (MessageUid, UserUid)
				SELECT @MessageUid, @ProviderUid

				INSERT INTO MessageNote (MessageUid, Note)
				VALUES
				(@MessageUid, @Error)

			   END -- of IF   (@@fetch_status <> -2)
			   FETCH NEXT FROM db_cursor INTO @ProviderUid  
		END
		CLOSE db_cursor
		DEALLOCATE db_cursor
	
	END

END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[IcRelTransacted_UpdateSubTables]'))
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		Kevin Crumpton
-- Create date: 
-- Description:	
-- =============================================
CREATE TRIGGER [dbo].[IcRelTransacted_UpdateSubTables] 
   ON  [dbo].[IcRelTransacted] 
   AFTER INSERT,DELETE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    if ((exists (select top 1 * from inserted)) and
		(exists (select top 1 * from deleted)))
	begin
		-- handle updates
		print ''handling update''
		-- updates handled by 
	end
	else if (exists (select top 1 * from deleted))
	begin
		-- handle deletes
		print ''handling delete''
		delete IcTransacted_SaveEncounter
		from DELETED
		where IcTransacted_SaveEncounter.IcTransactedUid = DELETED.IcTransactedUid and IcTransacted_SaveEncounter.ForeignObjectUid = DELETED.ForeignObjectUid
			and IcTransacted_SaveEncounter.InteliChartApiName = ''SaveEncounter''

		delete IcTransacted_SaveLocation
		from DELETED
		where IcTransacted_SaveLocation.IcTransactedUid = DELETED.IcTransactedUid and IcTransacted_SaveLocation.ForeignObjectUid = DELETED.ForeignObjectUid
			and IcTransacted_SaveLocation.InteliChartApiName = ''SaveLocation''

		delete IcTransacted_SavePerson
		from DELETED
		where IcTransacted_SavePerson.IcTransactedUid = DELETED.IcTransactedUid and IcTransacted_SavePerson.ForeignObjectUid = DELETED.ForeignObjectUid
			and IcTransacted_SavePerson.InteliChartApiName = ''SavePerson''

		delete IcTransacted_SaveProvider
		from DELETED
		where IcTransacted_SaveProvider.IcTransactedUid = DELETED.IcTransactedUid and IcTransacted_SaveProvider.ForeignObjectUid = DELETED.ForeignObjectUid
			and IcTransacted_SaveProvider.InteliChartApiName = ''SaveProvider''

		delete IcTransacted_SaveAppointment
		from DELETED
		where IcTransacted_SaveAppointment.IcTransactedUid = DELETED.IcTransactedUid and IcTransacted_SaveAppointment.ForeignObjectUid = DELETED.ForeignObjectUid
			and IcTransacted_SaveAppointment.InteliChartApiName = ''SaveAppointment''

	end
	else if (exists (select top 1 * from inserted))
	begin
		-- handle new inserts
		print ''handling insert''
		insert into IcTransacted_SaveEncounter([IcTransacted_SaveEncounter_Uid],
			[IcTransactedUid],
			[InteliChartApiName],
			[FilterReason],
			[ForeignObjectUid],
			[Reviewed],
			[ForeignObjectName],
			[Transmitted],
			[DeleteSent])
		select newid(),
			ic.IcTransactedUid, 
			[InteliChartApiName],
			[FilterReason],
			[ForeignObjectUid],
			[Reviewed],
			[ForeignObjectName],
			[Transmitted],
			[DeleteSent]
		from IcTransacted ic
		join INSERTED irt on ic.IcTransactedUid = irt.IcTransactedUid
		where ic.InteliChartApiName = ''SaveEncounter'' 

		insert into IcTransacted_SaveLocation([IcTransacted_SaveLocation_Uid],
			[IcTransactedUid],
			[InteliChartApiName],
			[FilterReason],
			[ForeignObjectUid],
			[Reviewed],
			[ForeignObjectName],
			[Transmitted],
			[DeleteSent])
		select newid(),
			ic.IcTransactedUid, 
			[InteliChartApiName],
			[FilterReason],
			[ForeignObjectUid],
			[Reviewed],
			[ForeignObjectName],
			[Transmitted],
			[DeleteSent]
		from IcTransacted ic
		join INSERTED irt on ic.IcTransactedUid = irt.IcTransactedUid
		where ic.InteliChartApiName = ''SaveLocation'' 

		insert into IcTransacted_SavePerson([IcTransacted_SavePerson_Uid],
			[IcTransactedUid],
			[InteliChartApiName],
			[FilterReason],
			[ForeignObjectUid],
			[Reviewed],
			[ForeignObjectName],
			[Transmitted],
			[DeleteSent])
		select newid(),
			ic.IcTransactedUid, 
			[InteliChartApiName],
			[FilterReason],
			[ForeignObjectUid],
			[Reviewed],
			[ForeignObjectName],
			[Transmitted],
			[DeleteSent]
		from IcTransacted ic
		join INSERTED irt on ic.IcTransactedUid = irt.IcTransactedUid
		where ic.InteliChartApiName = ''SavePerson'' 

		insert into IcTransacted_SaveProvider([IcTransacted_SaveProvider_Uid],
			[IcTransactedUid],
			[InteliChartApiName],
			[FilterReason],
			[ForeignObjectUid],
			[Reviewed],
			[ForeignObjectName],
			[Transmitted],
			[DeleteSent])
		select newid(),
			ic.IcTransactedUid, 
			[InteliChartApiName],
			[FilterReason],
			[ForeignObjectUid],
			[Reviewed],
			[ForeignObjectName],
			[Transmitted],
			[DeleteSent]
		from IcTransacted ic
		join INSERTED irt on ic.IcTransactedUid = irt.IcTransactedUid
		where ic.InteliChartApiName = ''SaveProvider'' 

		insert into IcTransacted_SaveAppointment([IcTransacted_SaveAppointment_Uid],
			[IcTransactedUid],
			[InteliChartApiName],
			[FilterReason],
			[ForeignObjectUid],
			[Reviewed],
			[ForeignObjectName],
			[Transmitted],
			[DeleteSent])
		select newid(),
			ic.IcTransactedUid, 
			[InteliChartApiName],
			[FilterReason],
			[ForeignObjectUid],
			[Reviewed],
			[ForeignObjectName],
			[Transmitted],
			[DeleteSent]
		from IcTransacted ic
		join INSERTED irt on ic.IcTransactedUid = irt.IcTransactedUid
		where ic.InteliChartApiName = ''SaveAppointment'' 
	end
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[IcTransacted_UpdateSubTables]'))
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		Kevin Crumpton
-- Create date: 
-- Description:	
-- =============================================
CREATE TRIGGER [dbo].[IcTransacted_UpdateSubTables] 
   ON  [dbo].[IcTransacted] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    if ((exists (select top 1 * from INSERTED)) and
		(exists (select top 1 * from DELETED)))
	begin
		-- handle updates
		print ''handling update''
		update old
			set 
				old.[FilterReason]=new.[FilterReason],
				old.[Reviewed]=new.[Reviewed],
				old.[Transmitted]=new.[Transmitted],
				old.[DeleteSent]=new.[DeleteSent]
		from IcTransacted_SaveEncounter old
		join INSERTED new 
			on old.ictransacteduid = new.ictransacteduid
		where new.InteliChartApiName = ''SaveEncounter''

		update old
			set 
				old.[FilterReason]=new.[FilterReason],
				old.[Reviewed]=new.[Reviewed],
				old.[Transmitted]=new.[Transmitted],
				old.[DeleteSent]=new.[DeleteSent]
		from IcTransacted_SaveLocation old
		join INSERTED new 
			on old.ictransacteduid = new.ictransacteduid
		where new.InteliChartApiName = ''SaveLocation''

		update old
			set 
				old.[FilterReason]=new.[FilterReason],
				old.[Reviewed]=new.[Reviewed],
				old.[Transmitted]=new.[Transmitted],
				old.[DeleteSent]=new.[DeleteSent]
		from IcTransacted_SavePerson old
		join INSERTED new 
			on old.ictransacteduid = new.ictransacteduid
		where new.InteliChartApiName = ''SavePerson''

		update old
			set 
				old.[FilterReason]=new.[FilterReason],
				old.[Reviewed]=new.[Reviewed],
				old.[Transmitted]=new.[Transmitted],
				old.[DeleteSent]=new.[DeleteSent]
		from IcTransacted_SaveProvider old
		join INSERTED new 
			on old.ictransacteduid = new.ictransacteduid
		where new.InteliChartApiName = ''SaveProvider''

		update old
			set 
				old.[FilterReason]=new.[FilterReason],
				old.[Reviewed]=new.[Reviewed],
				old.[Transmitted]=new.[Transmitted],
				old.[DeleteSent]=new.[DeleteSent]
		from IcTransacted_SaveAppointment old
		join INSERTED new on old.ictransacteduid = new.ictransacteduid
		where new.InteliChartApiName = ''SaveAppointment''
	end
	else if (exists (select top 1 * from deleted))
	begin
		-- handle deletes
		print ''handle deletes''
		-- *** DELETES HANDLED BY TRIGGER ON ICTRANSACTED TABLE ***
	end
	else if (exists (select top 1 * from inserted))
	begin
		-- handle new inserts
		print ''handle inserts''
		-- *** INSERTS HANDLED BY TRIGGER ON ICRELTRANSACTED TABLE ***
	end
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[HL7InsertForImmunizationHistoryDeleteAndUpdateVXU]'))
EXEC dbo.sp_executesql @statement = N'
CREATE TRIGGER [dbo].[HL7InsertForImmunizationHistoryDeleteAndUpdateVXU] ON [dbo].[ImmunizationHistory]
FOR UPDATE
/*
Purpose: Used to track inserts made to the Visit table for HL7 Vaccination Message Generation (VXU V04)
Created On: 20081223
Special Comments
*/
AS
IF @@ROWCOUNT = 0
       RETURN

IF dbo.IsReplicating() = 0
BEGIN
       SET NOCOUNT ON

       DECLARE @ObjectUid UNIQUEIDENTIFIER
       DECLARE @VisitUid UNIQUEIDENTIFIER
       DECLARE @ImmunizationHistoryUid UNIQUEIDENTIFIER
       DECLARE @Personuid UNIQUEIDENTIFIER
       DECLARE @ConsentRequired INT
       Declare @ConsentStatus INT
         DECLARE @HL7PartnerUid UNIQUEIDENTIFIER
       -- Declaring a Temp-table 
       DECLARE @VXUTable TABLE (
              PartnerUid VARCHAR(50),
              partnerMessageID VARCHAR(50), --Array element contents
              HL7PartnerConsentRequired Int
			  ,ConsentStatus INT)

       -- Inserting the PartnerMessageuid''s of Message type VXU into a Temp-table 
       INSERT INTO @VXUTable
       SELECT hp.HL7PartnerUid,HL7PartnerMessageUid,ConsentRequired, ConsentStatus
       FROM HL7PartnerMessage hpm
       INNER JOIN HL7Partner hp ON hpm.HL7PartnerUid = hp.HL7PartnerUid
       WHERE 
			  hp.HL7PartnerUid=''4DBE3D3D-C4E1-4265-B535-D4A07CB8FE2B''
              AND hp.Inactive = 0
              AND hpm.Inactive = 0
              AND hpm.SendFunction = ''ImmunizationHistory''
              AND hpm.Send = 1

       --IF Partner Message TYPE VXU V04 not exist then 
       --not insert the record in HL7ATO table.
       IF (
                     SELECT COUNT(*)
                     FROM @VXUTable
                     ) = 0
              RETURN
          
          Select @ConsentRequired=HL7PartnerConsentRequired
				,@HL7PartnerUid=PartnerUid
				,@ConsentStatus = ConsentStatus
          from @VXUTable

       DECLARE @ActionType VARCHAR(50) = ''VXUV04'' --PUT THIS IN A COMMON VARIABLE SO THAT WE DON''T HAVE TO WORRY ABOUT TYPOS OR LATER EDITING ACCIDENTALLY LOOKING AT WRONG STRING
       DECLARE @ObjectType VARCHAR(50)
       DECLARE @NewAccession varchar(25)
       DECLARE @CheckImedicaAccessionNumber varchar(25)
       --Declaring a FORWARD_ONLY Cursor that fetches the VisitUid
       --where the selected Test under SP is mapped with the Immunization.
       DECLARE VXU_CUR CURSOR LOCAL FORWARD_ONLY
       FOR
              SELECT I.VisitUid, I.ImmunizationHistoryUid
              FROM INSERTED I
        left  join deleted d on d.ImmunizationHistoryUid = i.ImmunizationHistoryUid
          where		d.IsDelete != i.IsDelete
                    or isnull(i.AdministeredDateTime,''01/01/1900'') != isnull(d.AdministeredDateTime, ''01/01/1900'') 
                    or isnull(i.VaccineSiteUid,''00000000-0000-0000-0000-000000000000'') != isnull(d.vaccinesiteuid,''00000000-0000-0000-0000-000000000000'')
                    or isnull(i.VaccineRouteUid,''00000000-0000-0000-0000-000000000000'') != isnull(d.VaccineRouteUid,''00000000-0000-0000-0000-000000000000'')
                    or isnull(i.VaccineFundingSourceUid,''00000000-0000-0000-0000-000000000000'') != isnull(d.VaccineFundingSourceUid,''00000000-0000-0000-0000-000000000000'')
                    or isnull(i.VFCEligibilityUid,''00000000-0000-0000-0000-000000000000'') != isnull(d.VFCEligibilityUid,''00000000-0000-0000-0000-000000000000'')
                    or isnull(i.DateOnVIS,''01/01/1900'') != isnull(d.DateOnVIS,''01/01/1900'')
                                or isnull(i.ExpirationDate,''01/01/1900'') != isnull(d.ExpirationDate,''01/01/1900'')
                                or isnull(i.VaccineMfrUid,''00000000-0000-0000-0000-000000000000'') != isnull(d.VaccineMfrUid,''00000000-0000-0000-0000-000000000000'')
                                or isnull(i.VaccineLotNo,'''') != isnull(d.VaccineLotNo,'''')
                                or isnull(i.VaccineDose,'''') != isnull(d.VaccineDose,'''')
                                or isnull(i.DateVISGiven,''01/01/1900'') != isnull(d.DateVISGiven,''01/01/1900'')
  or isnull(i.ImmzHistorySourceUid,''00000000-0000-0000-0000-000000000000'') != isnull(d.ImmzHistorySourceUid,''00000000-0000-0000-0000-000000000000'')
                                or isnull(i.ImmzRefusalUid,''00000000-0000-0000-0000-000000000000'') != isnull(d.ImmzRefusalUid,''00000000-0000-0000-0000-000000000000'')
                                or isnull(i.ImmzCompletionUid,''00000000-0000-0000-0000-000000000000'') != isnull(d.ImmzCompletionUid,''00000000-0000-0000-0000-000000000000'')
								or isnull(i.OriginCreateTime,''01/01/1900'') != isnull(d.OriginCreateTime,''01/01/1900'')
                    or d.ImmunizationHistoryUid is null
					AND d.VXUSentDateTime is not null

       --Opening the Cursor
       OPEN VXU_CUR

       --Fetch the First row of the Cursor
       FETCH NEXT
       FROM VXU_CUR
       INTO @VisitUid, @ImmunizationHistoryUid

       --Loops the Cursor until Fetch status is false
       WHILE @@FETCH_STATUS = 0
       BEGIN
              --IF WE JUST ALWAYS DELETE ANY ROW IN HL7ActionTypeObject FOR THIS KIND OF MESSAGE THEN WE
              --CAN RE-INSERT THE ROWS AND HAVE A NEW ROW WHERE ProcessingError = 0.  THIS ELIMINATES MOST OF THE 
              --IF/ELSE LOGIC FROM THE SCRIPT
              DELETE
              FROM HL7ActionTypeObject
             WHERE ActionType LIKE @ActionType
                     AND (ObjectUid = @VisitUid
                     OR ObjectUid = @ImmunizationHistoryUid)
            
			  IF @VisitUid IS NOT NULL AND EXISTS (SELECT * FROM Visit WHERE VisitUid = @VisitUid AND IsCompleted = 0)
				  GOTO NEXT_LOOP
              ELSE IF @VisitUid IS NOT NULL AND EXISTS (SELECT * FROM ImmunizationHistory WHERE ImmunizationHistoryUid=@ImmunizationHistoryUid AND ImmzCompletionUid is not null AND VisitProcedureUid is not null And AdministeredDateTime > dateadd(month,-1,getutcdate()))
              BEGIN
                     Select @Personuid=rhpc.PatientUid from Visit v /* Only send VXU message if patient gives the clinic/physician consent to send patient''s data to HL7partner (State Immunization Registry)*/
                     INNER JOIN RelHL7PartnerPatientConsent rhpc
                     on v.PatientUid = rhpc.Patientuid
                     where (ConsentAgreed=1 OR (@ConsentStatus = 1 AND ConsentAgreed IS NULL))
                                and rhpc.HL7PartnerUid=@HL7PartnerUid
                                and v.VisitUid=@VisitUid

                     IF (@Personuid is not NULL OR @ConsentRequired=0) --Second condition is for patient consent not required by registry
                     BEGIN
                           SET @ObjectType = ''ImmunizationHistory''
                           SET @ObjectUid = @ImmunizationHistoryUid
                           
                           SELECT  @CheckImedicaAccessionNumber=ImedicaAccessionNumber from ImmunizationHistory where ImmunizationHistoryUid=@ImmunizationHistoryUID

								IF (@CheckImedicaAccessionNumber is null or @CheckImedicaAccessionNumber ='''')
								BEGIN
								          EXEC GetAccessionNumber @NewAccession OUTPUT
              
								          --truncate leading zeroes
								          SET @NewAccession = Convert(bigint, Right(@NewAccession,11)) --Fix
      
								          UPDATE ImmunizationHistory
								              SET iMedicaAccessionNumber = @NewAccession
								          WHERE ImmunizationHistoryUid = @ImmunizationHistoryUid and (ImedicaAccessionNumber is null or ImedicaAccessionNumber ='''')

								END

										                                                    
                           INSERT INTO HL7ActionTypeObject (HL7ActionTypeObjectUid, HL7PartnerMessageUid, ActionType, ObjectType, ObjectUid, LastModifiedDate)
                           SELECT NEWID(), partnerMessageID, @ActionType, @ObjectType, @ObjectUid, GETUTCDATE()
                           FROM @VXUTable
                     END
                     ELSE
                           GOTO NEXT_LOOP

        END
			   ELSE IF @VisitUid IS NOT NULL AND EXISTS (SELECT * FROM ImmunizationHistory WHERE ImmunizationHistoryUid=@ImmunizationHistoryUid AND VisitProcedureUid is null And (HistoryAdministeredDate is not null OR HistoryAdministeredfuzzyDate is not null) and ImmzHistorySourceUid is not null)
              BEGIN
                     Select @Personuid=rhpc.PatientUid from Visit v /* Only send VXU message if patient gives the clinic/physician consent to send patient''s data to HL7partner (State Immunization Registry)*/
                     INNER JOIN RelHL7PartnerPatientConsent rhpc
                     on v.PatientUid = rhpc.Patientuid
                     where (ConsentAgreed=1 OR (@ConsentStatus = 1 AND ConsentAgreed IS NULL))
                                and rhpc.HL7PartnerUid=@HL7PartnerUid
                                and v.VisitUid=@VisitUid

                     IF (@Personuid is not NULL OR @ConsentRequired=0) --Second condition is for patient consent not required by registry
                     BEGIN
                           SET @ObjectType = ''ImmunizationHistory''
                           SET @ObjectUid = @ImmunizationHistoryUid
                           
                           SELECT  @CheckImedicaAccessionNumber=ImedicaAccessionNumber from ImmunizationHistory where ImmunizationHistoryUid=@ImmunizationHistoryUID

								IF (@CheckImedicaAccessionNumber is null or @CheckImedicaAccessionNumber ='''')
								BEGIN
								          EXEC GetAccessionNumber @NewAccession OUTPUT
              
								          --truncate leading zeroes
								          SET @NewAccession = Convert(bigint, Right(@NewAccession,11)) --Fix
      
								          UPDATE ImmunizationHistory
								              SET iMedicaAccessionNumber = @NewAccession
								          WHERE ImmunizationHistoryUid = @ImmunizationHistoryUid and (ImedicaAccessionNumber is null or ImedicaAccessionNumber ='''')

								END

										                                                    
                           INSERT INTO HL7ActionTypeObject (HL7ActionTypeObjectUid, HL7PartnerMessageUid, ActionType, ObjectType, ObjectUid, LastModifiedDate)
                           SELECT NEWID(), partnerMessageID, @ActionType, @ObjectType, @ObjectUid, GETUTCDATE()
                           FROM @VXUTable
                     END
                     ELSE
                           GOTO NEXT_LOOP

              END
              ELSE IF @VisitUid IS NULL AND Exists (SELECT * FROM ImmunizationHistory WHERE ImmunizationHistoryUid=@ImmunizationHistoryUid and ImmzHistorySourceUid is not null) -- Historical Immunization
              BEGIN
                     Select @Personuid=rhpc.PatientUid from ImmunizationHistory I
                     INNER JOIN RelHL7PartnerPatientConsent rhpc
                     on I.PatientUid = rhpc.Patientuid
                     where (ConsentAgreed=1 OR (@ConsentStatus = 1 AND ConsentAgreed IS NULL))
                                and rhpc.HL7PartnerUid=@HL7PartnerUid
                                and i.ImmunizationHistoryUid=@ImmunizationHistoryUid
                     
                     IF (@Personuid is not NULL OR @ConsentRequired=0) --Second condition is for patient consent not required by registry
                     BEGIN
                           SET @ObjectType = ''ImmunizationHistory''
                           SET @ObjectUid = @ImmunizationHistoryUid
							
						   SELECT  @CheckImedicaAccessionNumber=ImedicaAccessionNumber from ImmunizationHistory where ImmunizationHistoryUid=@ImmunizationHistoryUID

						   IF (@CheckImedicaAccessionNumber is null or @CheckImedicaAccessionNumber ='''')
						   BEGIN
								EXEC GetAccessionNumber @NewAccession OUTPUT
              					
								--truncate leading zeroes
								SET @NewAccession = Convert(bigint, Right(@NewAccession,11)) --Fix
								
								UPDATE ImmunizationHistory
								SET iMedicaAccessionNumber = @NewAccession
								WHERE ImmunizationHistoryUid = @ImmunizationHistoryUid and ImedicaAccessionNumber is null
						   END

                           INSERT INTO HL7ActionTypeObject (HL7ActionTypeObjectUid, HL7PartnerMessageUid, ActionType, ObjectType, ObjectUid, LastModifiedDate)
                           SELECT NEWID(), partnerMessageID, @ActionType, @ObjectType, @ObjectUid, GETUTCDATE()
                           FROM @VXUTable

                     END
                     ELSE
                           GOTO NEXT_LOOP
              END

       

        NEXT_LOOP:
        FETCH NEXT
              FROM VXU_CUR
              INTO @VisitUid, @ImmunizationHistoryUid
       END

       CLOSE VXU_CUR

       DEALLOCATE VXU_CUR

       SET NOCOUNT OFF
END' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[HL7InsertForImmunizationHistoryVXU]'))
EXEC dbo.sp_executesql @statement = N'
CREATE TRIGGER [dbo].[HL7InsertForImmunizationHistoryVXU] ON [dbo].[ImmunizationHistory]
FOR INSERT, UPDATE
/*
Purpose: Used to track inserts made to the Visit table for HL7 Vaccination Message Generation (VXU V04)
Created On: 20081223
Special Comments
*/
AS
IF @@ROWCOUNT = 0
       RETURN

IF dbo.IsReplicating() = 0
BEGIN
       SET NOCOUNT ON

       DECLARE @ObjectUid UNIQUEIDENTIFIER
       DECLARE @VisitUid UNIQUEIDENTIFIER
       DECLARE @ImmunizationHistoryUid UNIQUEIDENTIFIER
       DECLARE @Personuid UNIQUEIDENTIFIER
       DECLARE @ConsentRequired INT
       Declare @ConsentStatus INT
         DECLARE @HL7PartnerUid UNIQUEIDENTIFIER
       -- Declaring a Temp-table 
       DECLARE @VXUTable TABLE (
                     PartnerUid VARCHAR(50),
              partnerMessageID VARCHAR(50), --Array element contents
              HL7PartnerConsentRequired Int
			  ,ConsentStatus INT)

       -- Inserting the PartnerMessageuid''s of Message type VXU into a Temp-table 
       INSERT INTO @VXUTable
       SELECT hm.HL7PartnerUid,HL7PartnerMessageUid,ConsentRequired, ConsentStatus
       FROM HL7PartnerMessage hpm
       INNER JOIN HL7Partner hm ON hpm.HL7PartnerUid = hm.HL7PartnerUid
       WHERE MessageType = ''VXU''
              AND MessageEvent = ''V04''
              AND hm.Inactive = 0
              AND hpm.Inactive = 0
              AND hpm.SendFunction = ''ImmunizationHistory''
              AND hpm.Send = 1

       --IF Partner Message TYPE VXU V04 not exist then 
       --not insert the record in HL7ATO table.
       IF (
                     SELECT COUNT(*)
                     FROM @VXUTable
                     ) = 0
              RETURN
          
          Select @ConsentRequired=HL7PartnerConsentRequired
				,@HL7PartnerUid=PartnerUid
				,@ConsentStatus = ConsentStatus
          from @VXUTable

		  SELECT @ConsentRequired 

       DECLARE @ActionType VARCHAR(50) = ''VXUV04'' --PUT THIS IN A COMMON VARIABLE SO THAT WE DON''T HAVE TO WORRY ABOUT TYPOS OR LATER EDITING ACCIDENTALLY LOOKING AT WRONG STRING
       DECLARE @ObjectType VARCHAR(50)
       DECLARE @NewAccession varchar(25)
       DECLARE @CheckImedicaAccessionNumber varchar(25)
       --Declaring a FORWARD_ONLY Cursor that fetches the VisitUid
       --where the selected Test under SP is mapped with the Immunization.

       DECLARE VXU_CUR CURSOR LOCAL FORWARD_ONLY
       FOR
              SELECT I.VisitUid, I.ImmunizationHistoryUid
              FROM INSERTED I
        left  join deleted d on d.ImmunizationHistoryUid = i.ImmunizationHistoryUid
          where 
                    isnull(i.AdministeredDateTime,''01/01/1900'') != isnull(d.AdministeredDateTime, ''01/01/1900'') 
                    or isnull(i.VaccineSiteUid,''00000000-0000-0000-0000-000000000000'') != isnull(d.vaccinesiteuid,''00000000-0000-0000-0000-000000000000'')
                    or isnull(i.VaccineRouteUid,''00000000-0000-0000-0000-000000000000'') != isnull(d.VaccineRouteUid,''00000000-0000-0000-0000-000000000000'')
                    or isnull(i.VaccineFundingSourceUid,''00000000-0000-0000-0000-000000000000'') != isnull(d.VaccineFundingSourceUid,''00000000-0000-0000-0000-000000000000'')
                    or isnull(i.VFCEligibilityUid,''00000000-0000-0000-0000-000000000000'') != isnull(d.VFCEligibilityUid,''00000000-0000-0000-0000-000000000000'')
                    or isnull(i.DateOnVIS,''01/01/1900'') != isnull(d.DateOnVIS,''01/01/1900'')
                                or isnull(i.ExpirationDate,''01/01/1900'') != isnull(d.ExpirationDate,''01/01/1900'')
                                or isnull(i.VaccineMfrUid,''00000000-0000-0000-0000-000000000000'') != isnull(d.VaccineMfrUid,''00000000-0000-0000-0000-000000000000'')
                                or isnull(i.VaccineLotNo,'''') != isnull(d.VaccineLotNo,'''')
                                or isnull(i.VaccineDose,'''') != isnull(d.VaccineDose,'''')
                                or isnull(i.DateVISGiven,''01/01/1900'') != isnull(d.DateVISGiven,''01/01/1900'')
                                or isnull(i.ImmzHistorySourceUid,''00000000-0000-0000-0000-000000000000'') != isnull(d.ImmzHistorySourceUid,''00000000-0000-0000-0000-000000000000'')
                                or isnull(i.ImmzRefusalUid,''00000000-0000-0000-0000-000000000000'') != isnull(d.ImmzRefusalUid,''00000000-0000-0000-0000-000000000000'')
                                or isnull(i.ImmzCompletionUid,''00000000-0000-0000-0000-000000000000'') != isnull(d.ImmzCompletionUid,''00000000-0000-0000-0000-000000000000'')
								or isnull(i.OriginCreateTime,''01/01/1900'') != isnull(d.OriginCreateTime,''01/01/1900'')
                    or d.ImmunizationHistoryUid is null

       --Opening the Cursor
       OPEN VXU_CUR

       --Fetch the First row of the Cursor
       FETCH NEXT
       FROM VXU_CUR
       INTO @VisitUid, @ImmunizationHistoryUid

       --Loops the Cursor until Fetch status is false
       WHILE @@FETCH_STATUS = 0
       BEGIN
              --IF WE JUST ALWAYS DELETE ANY ROW IN HL7ActionTypeObject FOR THIS KIND OF MESSAGE THEN WE
              --CAN RE-INSERT THE ROWS AND HAVE A NEW ROW WHERE ProcessingError = 0.  THIS ELIMINATES MOST OF THE 
              --IF/ELSE LOGIC FROM THE SCRIPT
              DELETE
              FROM HL7ActionTypeObject
             WHERE ActionType LIKE @ActionType
                     AND (ObjectUid = @VisitUid
                     OR ObjectUid = @ImmunizationHistoryUid)
            
			  IF @VisitUid IS NOT NULL AND EXISTS (SELECT * FROM Visit WHERE VisitUid = @VisitUid AND IsCompleted = 0)
				  GOTO NEXT_LOOP
			  ELSE IF EXISTS (SELECT * FROM ImmunizationHistory WHERE ImmunizationHistoryUid=@ImmunizationHistoryUid AND ImmzCompletionUid is not null AND AdministeredDateTime > dateadd(month,-1,getutcdate()) AND VXUSentDateTime is not null)
              BEGIN
                     Select @Personuid=rhpc.PatientUid from ImmunizationHistory im /* Only send VXU message if patient gives the clinic/physician consent to send patient''s data to HL7partner (State Immunization Registry)*/
                     INNER JOIN RelHL7PartnerPatientConsent rhpc
                     on im.PatientUid = rhpc.Patientuid
                     where (ConsentAgreed=1 OR (@ConsentStatus = 1 AND ConsentAgreed IS NULL))
                                and rhpc.HL7PartnerUid=@HL7PartnerUid
                                and im.ImmunizationHistoryUid=@ImmunizationHistoryUid

                     IF (@Personuid is not NULL OR @ConsentRequired=0) --Second condition is for patient consent not required by registry
                     BEGIN
                           SET @ObjectType = ''ImmunizationHistory''
                           SET @ObjectUid = @ImmunizationHistoryUid
                           
                           SELECT  @CheckImedicaAccessionNumber=ImedicaAccessionNumber from ImmunizationHistory where ImmunizationHistoryUid=@ImmunizationHistoryUID

								IF (@CheckImedicaAccessionNumber is null or @CheckImedicaAccessionNumber ='''')
								BEGIN
								          EXEC GetAccessionNumber @NewAccession OUTPUT
              
								          --truncate leading zeroes
								          SET @NewAccession = Convert(bigint, Right(@NewAccession,11)) --Fix
      
								          UPDATE ImmunizationHistory
								              SET iMedicaAccessionNumber = @NewAccession
								          WHERE ImmunizationHistoryUid = @ImmunizationHistoryUid and (ImedicaAccessionNumber is null or ImedicaAccessionNumber ='''')

								END

										                                                    
                           INSERT INTO HL7ActionTypeObject (HL7ActionTypeObjectUid, HL7PartnerMessageUid, ActionType, ObjectType, ObjectUid, LastModifiedDate)
                           SELECT NEWID(), partnerMessageID, @ActionType, @ObjectType, @ObjectUid, GETUTCDATE()
                           FROM @VXUTable
                     END
                     ELSE
                           GOTO NEXT_LOOP

              END
              ELSE IF @VisitUid IS NOT NULL AND EXISTS (SELECT * FROM ImmunizationHistory WHERE ImmunizationHistoryUid=@ImmunizationHistoryUid AND ImmzCompletionUid is not null AND VisitProcedureUid is not null And AdministeredDateTime > dateadd(month,-1,getutcdate()))
              BEGIN
                     Select @Personuid=rhpc.PatientUid from Visit v /* Only send VXU message if patient gives the clinic/physician consent to send patient''s data to HL7partner (State Immunization Registry)*/
                     INNER JOIN RelHL7PartnerPatientConsent rhpc
                     on v.PatientUid = rhpc.Patientuid
                     where (ConsentAgreed=1 OR (@ConsentStatus = 1 AND ConsentAgreed IS NULL))
                                and rhpc.HL7PartnerUid=@HL7PartnerUid
                                and v.VisitUid=@VisitUid

                     IF (@Personuid is not NULL OR @ConsentRequired=0) --Second condition is for patient consent not required by registry
                     BEGIN
                           SET @ObjectType = ''Visit''
                           SET @ObjectUid = @VisitUid
                           
                           SELECT  @CheckImedicaAccessionNumber=ImedicaAccessionNumber from ImmunizationHistory where ImmunizationHistoryUid=@ImmunizationHistoryUID

								IF (@CheckImedicaAccessionNumber is null or @CheckImedicaAccessionNumber ='''')
								BEGIN
								          EXEC GetAccessionNumber @NewAccession OUTPUT
              
								          --truncate leading zeroes
								          SET @NewAccession = Convert(bigint, Right(@NewAccession,11)) --Fix
      
								          UPDATE ImmunizationHistory
								              SET iMedicaAccessionNumber = @NewAccession
								          WHERE ImmunizationHistoryUid = @ImmunizationHistoryUid and (ImedicaAccessionNumber is null or ImedicaAccessionNumber ='''')

								END

										                                                    
                           INSERT INTO HL7ActionTypeObject (HL7ActionTypeObjectUid, HL7PartnerMessageUid, ActionType, ObjectType, ObjectUid, LastModifiedDate)
                           SELECT NEWID(), partnerMessageID, @ActionType, @ObjectType, @ObjectUid, GETUTCDATE()
                           FROM @VXUTable
                     END
                     ELSE
                           GOTO NEXT_LOOP

              END
			   ELSE IF @VisitUid IS NOT NULL AND EXISTS (SELECT * FROM ImmunizationHistory WHERE ImmunizationHistoryUid=@ImmunizationHistoryUid AND VisitProcedureUid is null And (HistoryAdministeredDate is not null OR HistoryAdministeredfuzzyDate is not null) and ImmzHistorySourceUid is not null)
              BEGIN
                     Select @Personuid=rhpc.PatientUid from Visit v /* Only send VXU message if patient gives the clinic/physician consent to send patient''s data to HL7partner (State Immunization Registry)*/
                     INNER JOIN RelHL7PartnerPatientConsent rhpc
                     on v.PatientUid = rhpc.Patientuid
                     where (ConsentAgreed=1 OR (@ConsentStatus = 1 AND ConsentAgreed IS NULL))
                                and rhpc.HL7PartnerUid=@HL7PartnerUid
                                and v.VisitUid=@VisitUid

                     IF (@Personuid is not NULL OR @ConsentRequired=0) --Second condition is for patient consent not required by registry
                     BEGIN
                           SET @ObjectType = ''Visit''
                           SET @ObjectUid = @VisitUid
                           
                           SELECT  @CheckImedicaAccessionNumber=ImedicaAccessionNumber from ImmunizationHistory where ImmunizationHistoryUid=@ImmunizationHistoryUID

								IF (@CheckImedicaAccessionNumber is null or @CheckImedicaAccessionNumber ='''')
								BEGIN
								          EXEC GetAccessionNumber @NewAccession OUTPUT
              
								          --truncate leading zeroes
								          SET @NewAccession = Convert(bigint, Right(@NewAccession,11)) --Fix
      
								          UPDATE ImmunizationHistory
								              SET iMedicaAccessionNumber = @NewAccession
								          WHERE ImmunizationHistoryUid = @ImmunizationHistoryUid and (ImedicaAccessionNumber is null or ImedicaAccessionNumber ='''')

								END

										                                                    
                           INSERT INTO HL7ActionTypeObject (HL7ActionTypeObjectUid, HL7PartnerMessageUid, ActionType, ObjectType, ObjectUid, LastModifiedDate)
                           SELECT NEWID(), partnerMessageID, @ActionType, @ObjectType, @ObjectUid, GETUTCDATE()
                           FROM @VXUTable
                     END
                     ELSE
                           GOTO NEXT_LOOP

              END
              ELSE IF @VisitUid IS NULL AND Exists (SELECT * FROM ImmunizationHistory WHERE ImmunizationHistoryUid=@ImmunizationHistoryUid and ImmzHistorySourceUid is not null) -- Historical Immunization
              BEGIN
                     Select @Personuid=rhpc.PatientUid from ImmunizationHistory I
                     INNER JOIN RelHL7PartnerPatientConsent rhpc
                     on I.PatientUid = rhpc.Patientuid
                     where (ConsentAgreed=1 OR (@ConsentStatus = 1 AND ConsentAgreed IS NULL))
                                and rhpc.HL7PartnerUid=@HL7PartnerUid
                                and i.ImmunizationHistoryUid=@ImmunizationHistoryUid
                     
                     IF (@Personuid is not NULL OR @ConsentRequired=0) --Second condition is for patient consent not required by registry
                     BEGIN
                           SET @ObjectType = ''ImmunizationHistory''
                           SET @ObjectUid = @ImmunizationHistoryUid
							
						   SELECT  @CheckImedicaAccessionNumber=ImedicaAccessionNumber from ImmunizationHistory where ImmunizationHistoryUid=@ImmunizationHistoryUID

						   IF (@CheckImedicaAccessionNumber is null or @CheckImedicaAccessionNumber ='''')
						   BEGIN
								EXEC GetAccessionNumber @NewAccession OUTPUT
              					
								--truncate leading zeroes
								SET @NewAccession = Convert(bigint, Right(@NewAccession,11)) --Fix
								
								UPDATE ImmunizationHistory
								SET iMedicaAccessionNumber = @NewAccession
								WHERE ImmunizationHistoryUid = @ImmunizationHistoryUid and ImedicaAccessionNumber is null
						   END

                           INSERT INTO HL7ActionTypeObject (HL7ActionTypeObjectUid, HL7PartnerMessageUid, ActionType, ObjectType, ObjectUid, LastModifiedDate)
                           SELECT NEWID(), partnerMessageID, @ActionType, @ObjectType, @ObjectUid, GETUTCDATE()
                           FROM @VXUTable

                     END
                     ELSE
                           GOTO NEXT_LOOP
              END

       

        NEXT_LOOP:
        FETCH NEXT
              FROM VXU_CUR
              INTO @VisitUid, @ImmunizationHistoryUid
       END

       CLOSE VXU_CUR

       DEALLOCATE VXU_CUR

       SET NOCOUNT OFF
END' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[insurancecarrier_scheduledpqriupdate_afterupdate]'))
EXEC dbo.sp_executesql @statement = N'-- ==========================================================================
-- author:		cmcfadden
-- create date: 01/28/2009
-- description:	this trigger will insert rows into scheduledpqriupdate table
--				for each patient that has the updated insurance carrier and
--				insurance carrier''s pqri group uid has been changed.
-- ===========================================================================
CREATE trigger [dbo].[insurancecarrier_scheduledpqriupdate_afterupdate] on [dbo].[InsuranceCarrier] 
after update
as
begin
	set nocount on;

	if update(pqrigroupuid)
	begin
		if exists(select * from inserted where pqrigroupuid is not null)
		begin
			insert into scheduledpqriupdate (patientuid, pqrigroupuid, visituid)
			select distinct   a.personuid, ic.pqrigroupuid, v.visituid
			from              account a inner join accountperiod ap on a.accountuid = ap.accountuid
							inner join patient pat on a.personuid = pat.personuid
				            inner join accountinsurance ai on ai.accountperioduid = ap.accountperioduid
					        inner join personinsuranceplan pip on pip.personinsuranceplanuid = ai.personinsuranceplanuid
						    inner join insuranceplan ip on pip.insuranceplanuid = ip.insuranceplanuid
					        inner join inserted ic on ip.insurancecarrieruid = ic.corporationuid
						    inner join relpqrimeasurepqrigroup rel on ic.pqrigroupuid = rel.pqrigroupuid
				            inner join listpqrimeasure m on rel.pqrimeasureuid = m.pqrimeasureuid
	                        inner join visit v on v.accountuid = a.accountuid
							left outer join scheduledpqriupdate s on s.patientuid = a.personuid and
									s.pqrigroupuid = ic.pqrigroupuid
							left outer join pqrihistory his on v.visituid = his.visituid                   
			where			  not ic.pqrigroupuid is null and
	                        m.inactive = 0 and
	                        s.patientuid is null and
	                        his.pqrihistoryuid is null and
	                        (v.visitdate >= m.effectivedate or m.effectivedate is null) and
		                    (v.visitdate <= m.expirationdate or m.expirationdate is null) and
			                (v.visitdate >= ap.effectivedate or ap.effectivedate is null) and
				            (v.visitdate <= ap.expirationdate or ap.expirationdate is null)        
		end
	end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[BlockInactivations]'))
EXEC dbo.sp_executesql @statement = N'
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE TRIGGER [dbo].[BlockInactivations]
   ON  [dbo].[JobSchedule]
AFTER UPDATE
AS 
BEGIN
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	-- always reset the values for these jobs 
	-- ''EPCS%'', ''%eRx Audit%'', ''AprimaValult Downloader%''

	IF (UPDATE(JobScheduleTimeBaseUid))  
	BEGIN
		-- If JobScheduleTimeBasedUid was updated, don''t allow JobRepeatInterval to be updated.
		-- #10145 Getting an app error in job schedule EPCS Report Scheduler when changing Perform this job from monthly to hourly
		update JobSchedule
			set Inactive = case when inserted.Inactive = 0 then 0
									else deleted.Inactive end,  -- this allows the job to become active then keeps it active
				name = deleted.Name,
				MethodParams = deleted.MethodParams,
				JobUid = deleted.JobUid,
				JobScheduleTimeBaseUid = deleted.JobScheduleTimeBaseUid,
				JobRepeatInterval = deleted.JobRepeatInterval,   
				JobRepeatFrom = deleted.JobRepeatFrom
		from jobschedule
			join inserted on inserted.JobScheduleUid = jobschedule.JobScheduleUid 
			join deleted on deleted.JobScheduleUid = jobschedule.JobScheduleUid 
		where ((inserted.Name like ''EPCS%'' or deleted.Name like ''EPCS%'' or inserted.Name like ''%eRx Audit%'' or deleted.Name like ''%eRx Audit%'' or inserted.Name like ''AprimaValult Downloader%'' or deleted.Name like ''AprimaValult Downloader%'')
		and (inserted.UserDefined <> 1 or deleted.UserDefined <> 1)) --Bug 31578 Error when scheduled report eRx Audit Daily Summary runs  User able to manually generate.  Only the scheduled report job errors. 
	END
	ELSE 
	BEGIN
		-- If JobScheduleTimeBasedUid was not updated, allow JobRepeatInterval to be updated. 
		update JobSchedule
			set Inactive = case when inserted.Inactive = 0 then 0
									else deleted.Inactive end,  -- this allows the job to become active then keeps it active
				name = deleted.Name,
				MethodParams = deleted.MethodParams,
				JobUid = deleted.JobUid,
				JobScheduleTimeBaseUid = deleted.JobScheduleTimeBaseUid,
				--JobRepeatInterval = deleted.JobRepeatInterval,   -- #8988 allow time of day/day of month to change
				JobRepeatFrom = deleted.JobRepeatFrom
		from jobschedule
			join inserted on inserted.JobScheduleUid = jobschedule.JobScheduleUid 
			join deleted on deleted.JobScheduleUid = jobschedule.JobScheduleUid 
		where ((inserted.Name like ''EPCS%'' or deleted.Name like ''EPCS%'' or inserted.Name like ''%eRx Audit%'' or deleted.Name like ''%eRx Audit%'' or inserted.Name like ''AprimaValult Downloader%'' or deleted.Name like ''AprimaValult Downloader%'')
		and (inserted.UserDefined <> 1 or deleted.UserDefined <> 1)) --Bug 31578 Error when scheduled report eRx Audit Daily Summary runs  User able to manually generate.  Only the scheduled report job errors. 
	END
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[ListCacheMachine_Delete]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[ListCacheMachine_Delete] ON [dbo].[ListCacheMachine] AFTER DELETE AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DELETE	rs
	FROM	deleted d INNER JOIN ReplicationSettings rs ON d.url = rs.Name
	
	DELETE	rs
	FROM	deleted d INNER JOIN ReplicationSettings rs ON d.CacheMachineUid = rs.GuidValue

END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[ListCacheMachine_Update]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[ListCacheMachine_Update]
   ON  [dbo].[ListCacheMachine]
   AFTER UPDATE
AS 
BEGIN
	SET NOCOUNT ON;
	IF UPDATE (URL)
	BEGIN
		UPDATE rs
			SET Name = i.URL,
				StringValue = null,
				LastModifiedByUid = i.LastModifiedByUid,
				LastModifiedDate = i.LastModifiedDate
		FROM inserted AS i
			INNER JOIN ReplicationSettings AS rs ON i.CacheMachineUid = rs.ReplicationSettingsUid
	END
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[ListClaimFormLayout_INSERT]'))
EXEC dbo.sp_executesql @statement = N'
-- =============================================
-- Author:		David Wallace
-- Create date: 2015-08-10
-- Description:	Create a ListClaimFormatValueType whenever a new & custom ListClaimformLayout is inserted/created
--              Scenario 39252: Ability to set custom paper claim layout on payer
-- =============================================
CREATE TRIGGER [dbo].[ListClaimFormLayout_INSERT] ON [dbo].[ListClaimFormLayout]   
FOR INSERT  
/* Purpose: Create a ListClaimFormatValueType whenever a new & custom ListClaimformLayout is inserted/created */  
AS  
BEGIN  

	IF @@ROWCOUNT = 0  
	RETURN   

	INSERT INTO ListClaimFormatValueType( ClaimFormatValueTypeUid, ExternalID, Name, Notes, IsPerProviderValue, IsPerFinancialCenterValue, Inactive, LastModifiedDate, LastModifiedByUid, ClaimFormatValueTypeTypeUid, UserDefined)
		SELECT cfl_I.ClaimFormLayoutUid as ClaimFormatValueTypeUid, -- ClaimFormatValueTypeUid
				cfl_I.ExternalID, -- ExternalID
				cfl_I.Name, -- Name
				cfl_I.Notes, -- Notes
				0, -- IsPerProviderValue
				0, -- IsPerFinancialCenterValue
				0, -- Inactive
				cfl_I.LastModifiedDate, -- LastModifiedDate
				cfl_I.LastModifiedByUid, -- LastModifiedByUid
				cft.ClaimFormatTypeUid, -- -- ListClaimFormatTypeUid for paper claims purposely set to ListClaimFormatValueType.ClaimFormatValueTypeTypeUid
				0 -- UserDefined
		FROM INSERTED cfl_I
			INNER JOIN ListClaimFormatType cft on cfl_I.ClaimFormatTypeUid = cft.ClaimFormatTypeUid
														AND cft.IsPaper = 1
			LEFT OUTER JOIN ListClaimFormatValueType cfvt on cfl_I.ClaimFormLayoutUid = cfvt.ClaimFormatValueTypeUid
		WHERE cfvt.ClaimFormatValueTypeUid IS NULL

END


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[listcliniccenter_usergroup]'))
EXEC dbo.sp_executesql @statement = N'

CREATE trigger [dbo].[listcliniccenter_usergroup]
on [dbo].[ListClinicCenter] for insert, update as
begin
  if not exists ( select top 1 * from inserted )
    return

	if dbo.isreplicating() = 0
	begin
		update	ug
		set		externalid = i.externalid, 
				inactive = i.inactive,
				[name] = i.[name],
				lastmodifieddate = getutcdate(),
				lastmodifiedbyuid = i.lastmodifiedbyuid
		from	inserted i inner join listusergroup ug on i.cliniccenteruid = ug.usergroupuid
		
		insert	listusergroup(	usergroupuid, externalid, inactive, [name], usergrouptypeuid, 
								lastmodifieddate, lastmodifiedbyuid)
		select	i.cliniccenteruid, i.externalid, i.inactive, i.[name], 
				dbo.systemguid(1) as usergrouptypeuid,			
				getutcdate(), i.lastmodifiedbyuid
		from	inserted i left join listusergroup ug on i.cliniccenteruid = ug.usergroupuid
		where	ug.usergroupuid is null

		update	ug
		set		notes = cc.notes,
				LastModifiedDate = GETUTCDATE()
		from		inserted i inner join listcliniccenter cc on i.cliniccenteruid = cc.cliniccenteruid
				inner join listusergroup ug on i.cliniccenteruid = ug.usergroupuid

	end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[listcliniccenter_usergroup_delete]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[listcliniccenter_usergroup_delete]
on [dbo].[ListClinicCenter] for delete as
begin
  if not exists ( select top 1 * from deleted )
    return

  if dbo.isreplicating() = 0
  begin

	  delete listusergroup 
	  from deleted d
	  inner join listusergroup ug on d.cliniccenteruid = ug.usergroupuid
  end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[ListCreditType_InsteadOf_Delete]'))
EXEC dbo.sp_executesql @statement = N'


CREATE trigger [dbo].[ListCreditType_InsteadOf_Delete] ON [dbo].[ListCreditType] INSTEAD OF DELETE AS
BEGIN
	SET NOCOUNT ON;

	IF (EXISTS(SELECT TOP 1 * 
				FROM deleted d
						INNER JOIN AR_LedgerDetail ld ON d.CreditTypeUid = ld.IncomeAccountUid))
	BEGIN
		RAISERROR(''ListCreditType_InsteadOf_Delete: Can not delete credit type associated with an existing ledger.'',16,1);
		RETURN ;
	END

	DECLARE @originatorId VARBINARY(128);
	SELECT @originatorId = dbo.GetChangeTrackingContextFromContextInfo();

	WITH CHANGE_TRACKING_CONTEXT(@originatorId)
		DELETE FROM ListCreditType WHERE CreditTypeUid IN (SELECT CreditTypeUid FROM deleted);
	
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[Diagnosis_Update]'))
EXEC dbo.sp_executesql @statement = N'
CREATE TRIGGER [dbo].[Diagnosis_Update] ON [dbo].[ListDiagnosis] AFTER UPDATE 
AS 
BEGIN
	UPDATE	ct
	SET		Inactive = 1
	FROM	inserted i INNER JOIN deleted d ON i.DiagnosisUid  = d.DiagnosisUid
			INNER JOIN RelChargeTicketDiagnosis ct ON i.DiagnosisCode9 = ct.Code9
	WHERE	i.Inactive = 1 AND
			d.Inactive = 0
END

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[ListDiagnosis_Insert_Update]'))
EXEC dbo.sp_executesql @statement = N'

CREATE TRIGGER [dbo].[ListDiagnosis_Insert_Update] on [dbo].[ListDiagnosis] AFTER INSERT, UPDATE AS
BEGIN
	SET NOCOUNT ON;

	/*
		Maintain Flag ShortDescriptionChangedFromMaster so can tell where clients decided to depart from master naming 
			and not update from Master Details
		2015-04-27 BMR Created
	*/

	UPDATE ListDiagnosis
		SET ShortDescriptionChangedFromMaster = CASE WHEN (I.ShortDescription != MD.ShortDescription) THEN 1 ELSE 0 END
		FROM ListDiagnosis
			INNER JOIN MasterDiagnosis MD ON ListDiagnosis.MasterDiagnosisUid = MD.MasterDiagnosisUid
			INNER JOIN inserted I ON ListDiagnosis.DiagnosisUid = I.DiagnosisUid
		WHERE ListDiagnosis.ShortDescriptionChangedFromMaster != CASE WHEN (I.ShortDescription != MD.ShortDescription) THEN 1 ELSE 0 END;

END


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[listdisease_answer_insert]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[listdisease_answer_insert]
on [dbo].[ListDisease] for insert as
begin	
  if not exists ( select top 1 * from inserted )
    return

	if dbo.isreplicating() = 0
	begin
		/* insert this record into the listanswer table */
		insert into 	listanswer
				(
				diseaseuid,
				externalid,
				inactive,
				[name],
				userdefined,
				notes,
				lastmodifiedbyuid,
				lastmodifieddate
				)
		select		listdisease.diseaseuid,
				listdisease.externalid,
				listdisease.inactive,
				listdisease.[name],
				listdisease.userdefined,
				listdisease.notes,
				listdisease.lastmodifiedbyuid,
				getutcdate()
		
		from		inserted
		join		listdisease 		on listdisease.diseaseuid = inserted.diseaseuid
							and listdisease.isfamilydisease = 1

		/* insert this record into the relanswergroupanswer table */
		insert into	relanswergroupanswer
				(
				answergroupuid,
				answeruid,
				userdefined,
				lastmodifiedbyuid,
				lastmodifieddate
				)
		select		listanswergroup.answergroupuid,
				listanswer.answeruid,
				listanswer.userdefined,
				listanswer.lastmodifiedbyuid,
				getutcdate()
				
		from		inserted
		join		listanswer on listanswer.diseaseuid = inserted.diseaseuid
		join		listanswergroup on listanswergroup.usediseases = 1

	end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[listdisease_answer_update]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[listdisease_answer_update]
on [dbo].[ListDisease] for update as
begin	
  if not exists ( select top 1 * from inserted )
    return

	if dbo.isreplicating() = 0
	begin

		/* update the listanswer record if it exists */
		update		listanswer
		set		externalid = listdisease.externalid,
				inactive = listdisease.inactive,
				[name] = listdisease.[name],
				userdefined = listdisease.userdefined,
				notes = listdisease.notes,
				lastmodifiedbyuid = listdisease.lastmodifiedbyuid,
				lastmodifieddate = getutcdate()
		from		inserted
		join		listdisease 	on listdisease.diseaseuid = inserted.diseaseuid
		join		listanswer	on listanswer.diseaseuid = listdisease.diseaseuid

		where		listdisease.isfamilydisease = 1

		/* insert this record into the listanswer table if it doesn''t already exist */
		insert into 	listanswer
				(
				diseaseuid,
				externalid,
				inactive,
				[name],
				userdefined,
				notes,
				lastmodifiedbyuid,
				lastmodifieddate
				)
		select		listdisease.diseaseuid,
				listdisease.externalid,
				listdisease.inactive,
				listdisease.[name],
				listdisease.userdefined,
				listdisease.notes,
				listdisease.lastmodifiedbyuid,
				getutcdate()
		
		from		inserted
		join		listdisease 		on listdisease.diseaseuid = inserted.diseaseuid
							and listdisease.isfamilydisease = 1
		left join	listanswer		on listanswer.diseaseuid = inserted.diseaseuid

		where		listanswer.answeruid is null

		/* insert this record into the relanswergroupanswer table if it doesn''t already exist */
		insert into	relanswergroupanswer
				(
				answergroupuid,
				answeruid,
				userdefined,
				lastmodifiedbyuid,
				lastmodifieddate
				)
		select		listanswergroup.answergroupuid,
				listanswer.answeruid,
				listanswer.userdefined,
				listanswer.lastmodifiedbyuid,
				getutcdate()
				
		from		inserted
		join		listanswer 		on listanswer.diseaseuid = inserted.diseaseuid
		join		listanswergroup 	on listanswergroup.usediseases = 1
		left join	relanswergroupanswer 	on relanswergroupanswer.answergroupuid = listanswergroup.answergroupuid
							and relanswergroupanswer.answeruid = listanswer.answeruid

		where		relanswergroupanswer.relanswergroupansweruid is null



		/* if the isfamilydisease is no longer set to true, then deactivate the answer */
		update		listanswer
		set		externalid = listdisease.externalid,
				inactive = 1,
				[name] = listdisease.[name],
				userdefined = listdisease.userdefined,
				notes = listdisease.notes,
				lastmodifiedbyuid = listdisease.lastmodifiedbyuid,
				lastmodifieddate = getutcdate()
		from		inserted
		join		listdisease 	on listdisease.diseaseuid = inserted.diseaseuid
		join		listanswer	on listanswer.diseaseuid = listdisease.diseaseuid
		where		listdisease.isfamilydisease = 0

	end		
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[listdisease_delete]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[listdisease_delete]
on [dbo].[ListDisease] for delete as
begin	
  if not exists ( select top 1 * from deleted )
    return


	
	delete from relanswergroupanswer
	where relanswergroupanswer.answeruid in (select answeruid from listanswer join deleted on listanswer.diseaseuid = deleted.diseaseuid)

	delete from listanswer
	where diseaseuid in (select diseaseuid from deleted)

	delete from listdisease
	where diseaseuid in (select diseaseuid from deleted)
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[listdisease_question_insert]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[listdisease_question_insert]
on [dbo].[ListDisease] for insert as
begin	
  if not exists ( select top 1 * from inserted )
    return

	if dbo.isreplicating() = 0
	begin

		insert into 	listquestion
				(
				historygroupuid,
				answergroupuid,
				diseaseuid,
				externalid,
				inactive,
				[name],
				userdefined,
				notes,
				lastmodifiedbyuid,
				lastmodifieddate
				)
		select		listhistorygroup.historygroupuid,
				listhistorygroup.answergroupuid,
				listdisease.diseaseuid,
				listdisease.externalid,
				listdisease.inactive,
				listdisease.[name],
				listdisease.userdefined,
				listdisease.notes,
				listdisease.lastmodifiedbyuid,
				getutcdate()
		
		from		inserted
		join		listdisease 		on listdisease.diseaseuid = inserted.diseaseuid
		join		listhistorygroup	on listhistorygroup.usediseases = 1
		
	end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[listdisease_question_update]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[listdisease_question_update]
on [dbo].[ListDisease] for update as
begin	
  if not exists ( select top 1 * from inserted )
    return

	if dbo.isreplicating() = 0
	begin

		update		listquestion
		set		externalid = listdisease.externalid,
				inactive = listdisease.inactive,
				[name] = listdisease.[name],
				userdefined = listdisease.userdefined,
				notes = listdisease.notes,
				lastmodifiedbyuid = listdisease.lastmodifiedbyuid,
				lastmodifieddate = getutcdate()
		from		inserted
		join		listdisease 	on listdisease.diseaseuid = inserted.diseaseuid
		join		listquestion	on listquestion.diseaseuid = listdisease.diseaseuid

	end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[listhistorygroup_question_insert]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[listhistorygroup_question_insert]
on [dbo].[ListHistoryGroup] for insert as
begin	
  if not exists ( select top 1 * from inserted )
    return

	if dbo.isreplicating() = 0
	begin
		insert into 	listquestion
				(
				historygroupuid,
				answergroupuid,
				diseaseuid,
				externalid,
				inactive,
				[name],
				userdefined,
				notes,
				lastmodifiedbyuid,
				lastmodifieddate
				)
		select		inserted.historygroupuid,
				inserted.answergroupuid,
				listdisease.diseaseuid,
				listdisease.externalid,
				listdisease.inactive,
				listdisease.[name],
				listdisease.userdefined,
				listdisease.notes,
				listdisease.lastmodifiedbyuid,
				getutcdate()
		
		from 		listdisease
		join 		inserted on inserted.usediseases = 1	

	end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[listhistorygroup_question_update]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[listhistorygroup_question_update]
on [dbo].[ListHistoryGroup] for update as
begin	
  if not exists ( select top 1 * from inserted )
    return

	if dbo.isreplicating() = 0
	begin

		/* if this history group was changed to usediseases then add questions for each disease */
		insert into 	listquestion
				(
				historygroupuid,
				answergroupuid,
				diseaseuid,
				externalid,
				inactive,
				[name],
				userdefined,
				notes,
				lastmodifiedbyuid,
				lastmodifieddate
				)
		select		inserted.historygroupuid,
				inserted.answergroupuid,
				listdisease.diseaseuid,
				listdisease.externalid,
				listdisease.inactive,
				listdisease.[name],
				listdisease.userdefined,
				listdisease.notes,
				listdisease.lastmodifiedbyuid,
				getutcdate()
		
		from 		listdisease
		join 		inserted 	on inserted.usediseases = 1	
		left join	listquestion	on listquestion.diseaseuid = listdisease.diseaseuid
						and listquestion.historygroupuid = inserted.historygroupuid

		where		listquestion.questionuid is null

	end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[IntegrationPartner_Trigger_CommonWell_Active]'))
EXEC dbo.sp_executesql @statement = N'



CREATE TRIGGER [dbo].[IntegrationPartner_Trigger_CommonWell_Active] ON [dbo].[ListIntegrationPartner] FOR INSERT, UPDATE AS  
IF dbo.IsCacheClient() = 0
BEGIN
	--For registering AppServer for sharing CommonWell documents
	DECLARE @CommonWellUid varchar(50)
	DECLARE @TransmissionType varchar(50)
	DECLARE @RawMessage varchar(50)

	Set @CommonWellUid=''01178549-2CEF-462B-89B0-E41EA99EE57A''
	Set @TransmissionType=''CommonWellOidRegistration''
	Set @RawMessage=''CommonWell Registration''

	if(NOT EXISTS(select * from ListIntegrationPartner IP
		where IP.IntegrationPartnerUid=@CommonWellUid AND IP.Inactive=0))
	begin
		return
	end

	DECLARE @IntegrationPartnerUid UNIQUEIDENTIFIER

	DECLARE CCD_CUR CURSOR FAST_FORWARD LOCAL FOR 
	SELECT IntegrationPartnerUid FROM INSERTED 

	OPEN CCD_CUR
	FETCH NEXT FROM CCD_CUR INTO @IntegrationPartnerUid
	WHILE @@FETCH_STATUS =0
	BEGIN
		--THIS SECTION DECIDES IF THE APPSERVER SHOULD BE REGISTERED
		IF (@IntegrationPartnerUid = @CommonWellUid
		AND (select Inactive from Inserted)=0
		AND (select UsesApi from Inserted)=1
		AND (select AllowApiUse from Inserted)=1)
		--Add more logic once new arows are in 
		BEGIN
			if(exists(select * from TransmissionOutbound  
				where Status=0 
				AND TransmissionType=@TransmissionType
				AND RawMessage=@RawMessage))
			begin
				return
			end

			INSERT	TransmissionOutbound(TransmissionType, RawMessage)
			SELECT	@TransmissionType, @RawMessage
		END
		NEXT_LOOP:
		FETCH NEXT FROM CCD_CUR INTO @IntegrationPartnerUid
	END
	CLOSE CCD_CUR
	DEALLOCATE CCD_CUR
	SET NOCOUNT OFF
END




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[BlockJobInactivations]'))
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE TRIGGER [dbo].[BlockJobInactivations]
   ON  [dbo].[ListJob]
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	--always reset the values for these jobs 
    update ListJob
		set Inactive = case when inserted.Inactive = 0 then 0
								else deleted.Inactive end,  -- this allows the job to become active then keeps it active
			name = deleted.Name,
			AssemblyQualifiedName = deleted.AssemblyQualifiedName,
			NotifyOnFailure = deleted.NotifyOnFailure,
			NotifyOnSuccess = deleted.NotifyOnSuccess
	from ListJob
		join inserted on inserted.JobUid = ListJob.JobUid 
		join deleted on deleted.JobUid = ListJob.JobUid 
	where (inserted.Name like ''EPCS%'' or deleted.Name like ''EPCS%'')

END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[ListPharmacy_Computed_InsertUpdate]'))
EXEC dbo.sp_executesql @statement = N'
CREATE TRIGGER [dbo].[ListPharmacy_Computed_InsertUpdate] ON [dbo].[ListPharmacy] FOR INSERT, UPDATE AS
BEGIN
	SET NOCOUNT ON;

	IF UPDATE(Address) OR UPDATE(Phone1) OR UPDATE(Phone2) OR UPDATE(Phone3)
		update lp set lp.Computed_Address1_Address1 = lp.[Address].value(''(/Address/Address1)[1]'', ''VARCHAR(100)''),
			lp.Computed_Address1_Address2 = lp.[Address].value(''(/Address/Address2)[1]'', ''VARCHAR(100)''),
			lp.Computed_Address1_City = lp.[Address].value(''(/Address/City)[1]'', ''VARCHAR(35)''),
			lp.Computed_Address1_State = lp.[Address].value(''(/Address/State)[1]'', ''VARCHAR(3)''),
			lp.Computed_Address1_Zip = lp.[Address].value(''(/Address/Zip)[1]'', ''VARCHAR(10)''),
			lp.Computed_Address1_Country = lp.[Address].value(''(/Address/Country)[1]'', ''VARCHAR(50)''),
			lp.[Computed_Address1_StreetAddress] = COALESCE(lp.[Address].value(''(/Address/Address1)[1]'', ''VARCHAR(100)''),'''') + COALESCE(lp.[Address].value(''(/Address/Address2)[1]'', ''VARCHAR(100)''),''''),
			lp.Computed_Phone1_PhoneNumber = lp.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(80)''),
			lp.Computed_Phone1_PhoneType = lp.Phone1.value(''(/Phone/PhoneType)[1]'', ''VARCHAR(50)''),
			lp.Computed_Phone1_Scrubbed = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(lp.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(80)''), ''-'', ''''), '' '', ''''), ''('', ''''), '')'', ''''), ''ext'', ''''), ''x'', ''''), 
			lp.Computed_Phone2_PhoneNumber = lp.Phone2.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(80)''),
			lp.Computed_Phone2_PhoneType = lp.Phone2.value(''(/Phone/PhoneType)[1]'', ''VARCHAR(50)''),
			lp.Computed_Phone2_Scrubbed = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(lp.Phone2.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(80)''), ''-'', ''''), '' '', ''''), ''('', ''''), '')'', ''''), ''ext'', ''''), ''x'', ''''), 
			lp.Computed_Phone3_PhoneNumber = lp.Phone3.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(80)''),
			lp.Computed_Phone3_PhoneType = lp.Phone3.value(''(/Phone/PhoneType)[1]'', ''VARCHAR(50)''),
			lp.Computed_Phone3_Scrubbed = REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(lp.Phone3.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(80)''), ''-'', ''''), '' '', ''''), ''('', ''''), '')'', ''''), ''ext'', ''''), ''x'', '''')
		from inserted i
		join ListPharmacy lp on i.PharmacyUid = lp.PharmacyUid
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[ListPhoneType_InsteadOf_Delete]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[ListPhoneType_InsteadOf_Delete] ON [dbo].[ListPhoneType] INSTEAD OF DELETE AS
BEGIN
	SET NOCOUNT ON;

	--IF (EXISTS(SELECT TOP 1 * 
	--			FROM deleted d
	--					INNER JOIN AR_LedgerDetail ld ON d.CreditTypeUid = ld.IncomeAccountUid))
	--BEGIN
	--	RAISERROR(''ListCreditType_InsteadOf_Delete: Can not delete credit type associated with an existing ledger.'',16,1);
	--	RETURN ;
	--END

	declare @oldUid uniqueidentifier

	DECLARE itemsToDeleteCur CURSOR FAST_FORWARD LOCAL FOR 
	SELECT PhoneTypeUid FROM DELETED

	OPEN itemsToDeleteCur
	FETCH NEXT FROM itemsToDeleteCur INTO @oldUid
	WHILE @@FETCH_STATUS = 0
	begin
	
		declare @columnsToProcess table
		(
			TableName varchar(500),
			ColumnName varchar(500)
		)

		declare @oldValueLower varchar(50) = lower(convert(varchar(50), @oldUid))
		declare @oldValueUpper varchar(50) = upper(convert(varchar(50), @oldUid))

		insert into @columnsToProcess
		SELECT  obj.name AS [ObjectName]
			   ,col.name AS [ColumnName]
		--       ,xsc.name AS [CollectionName]
		  FROM sys.columns col
			   INNER JOIN sys.objects obj
				  ON col.object_id = obj.object_id
			   INNER JOIN sys.xml_schema_collections xsc
				  ON col.xml_collection_id = xsc.xml_collection_id
			   INNER JOIN sys.xml_schema_namespaces nms
				  ON xsc.xml_collection_id = nms.xml_collection_id
			   INNER JOIN sys.schemas sch
				  ON xsc.schema_id = sch.schema_id
		 WHERE sch.name != N''sys''
		   AND col.xml_collection_id != 0
		   AND obj.type = N''U''
		   and xsc.name = ''Phone''


		declare @currentTable varchar(500) = null
		declare @currentColumn varchar(500) = null
		declare @primaryKeyColumn varchar(500) = null

		select top 1 @currentTable = TableName, @currentColumn = ColumnName from @columnsToProcess

		declare @sql nvarchar(4000) = null
		declare @sql2 nvarchar(4000) = null

		while @currentColumn is not null
		begin
			print @currentTable + ''.'' + @currentColumn

			select @primaryKeyColumn = dbo.PrimaryKeyColumn(@currentTable)

			select @sql = ''if exists (select * from '' + @currentTable + ''
			where '' + @currentColumn + ''.exist(''''//Phone/PhoneTypeUid[contains(., "'' + @oldValueLower +''")]'''') = 1)
			begin
				RAISERROR(''''ListPhoneType_InsteadOf_Delete: Can not delete phone type associated with an existing phone number.'''',16,1);
			end''

			select @sql2 = ''if exists (select * from '' + @currentTable + ''
			where '' + @currentColumn + ''.exist(''''//Phone/PhoneTypeUid[contains(., "'' + @oldValueUpper +''")]'''') = 1)
			begin
				RAISERROR(''''ListPhoneType_InsteadOf_Delete: Can not delete phone type associated with an existing phone number.'''',16,1);
			end''


			begin try
				exec sp_executesql @sql
				exec sp_executesql @sql2
			end try
			begin catch
				declare @severity int; 
				declare @state int;
				declare @errnum int;
				declare @errtext varchar(max);

				select @severity=error_severity(), @state=error_state(), @errnum=ERROR_NUMBER(), @errtext=ERROR_MESSAGE();

				RAISERROR(@errtext,@severity,@state);
				--print ''error found going to end''
				goto THE_END
			end catch
			--print @sql

			delete @columnsToProcess where TableName = @currentTable and ColumnName = @currentColumn
			select @currentTable = null, @currentColumn = null
			select top 1 @currentTable = TableName, @currentColumn = ColumnName from @columnsToProcess
		end

		FETCH NEXT FROM itemsToDeleteCur INTO @oldUid
	end

	DECLARE @originatorId VARBINARY(128);
	SELECT @originatorId = dbo.GetChangeTrackingContextFromContextInfo();

	--print ''deleting phone type''

	;WITH CHANGE_TRACKING_CONTEXT(@originatorId)
		DELETE FROM ListPhoneType WHERE PhoneTypeUid IN (SELECT PhoneTypeUid FROM deleted);

THE_END:
	CLOSE itemsToDeleteCur
	DEALLOCATE itemsToDeleteCur

	
END' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[listpqrimeasure_scheduledpqriupdate_afterupdate]'))
EXEC dbo.sp_executesql @statement = N'-- ==========================================================================
-- author:		cmcfadden
-- create date: 01/28/2009
-- description:	this trigger will insert rows into scheduledpqriupdate table
--				for each patient when the "inactive" flag is set to "0".
-- ===========================================================================
CREATE trigger [dbo].[listpqrimeasure_scheduledpqriupdate_afterupdate] on [dbo].[ListPQRIMeasure] 
after update
as
begin
	set nocount on;

	if update(inactive)
	begin
		if exists(select * from inserted where inactive = 0)
		begin
			insert into scheduledpqriupdate (patientuid, pqrigroupuid, visituid)
			select distinct   a.personuid, ic.pqrigroupuid, v.visituid
			from              account a inner join accountperiod ap on a.accountuid = ap.accountuid
									inner join patient pat on a.personuid = pat.personuid
									inner join accountinsurance ai on ai.accountperioduid = ap.accountperioduid
									inner join personinsuranceplan pip on pip.personinsuranceplanuid = ai.personinsuranceplanuid
									inner join insuranceplan ip on pip.insuranceplanuid = ip.insuranceplanuid
									inner join insurancecarrier ic on ip.insurancecarrieruid = ic.corporationuid
									inner join relpqrimeasurepqrigroup rel on ic.pqrigroupuid = rel.pqrigroupuid
									inner join inserted m on rel.pqrimeasureuid = m.pqrimeasureuid
									inner join visit v on v.accountuid = a.accountuid
									left outer join scheduledpqriupdate s on s.patientuid = a.personuid and
												s.pqrigroupuid = ic.pqrigroupuid
									left outer join pqrihistory his on his.pqrimeasureuid = m.pqrimeasureuid and
												v.visituid = his.visituid
			where             not ic.pqrigroupuid is null and
									m.inactive = 0 and
									s.patientuid is null and
									his.pqrihistoryuid is null and
									(v.visitdate >= m.effectivedate or m.effectivedate is null) and
									(v.visitdate <= m.expirationdate or m.expirationdate is null) and
									(v.visitdate >= ap.effectivedate or ap.effectivedate is null) and
									(v.visitdate <= ap.expirationdate or ap.expirationdate is null)
        end
	end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[ListProcedure_Insert_Update]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[ListProcedure_Insert_Update] on [dbo].[ListProcedure] AFTER INSERT, UPDATE AS
BEGIN
	SET NOCOUNT ON;

	/*
		Maintain Flag ShortDescriptionChangedFromMaster so can tell where clients decided to depart from master naming 
			and not update from Master Details
		2015-04-27 BMR Created
	*/

	UPDATE ListProcedure
		SET ShortDescriptionChangedFromMaster = CASE WHEN (I.ShortDescription != MP.ShortDescription) THEN 1 ELSE 0 END
		FROM ListProcedure
			INNER JOIN MasterProcedure MP ON ListProcedure.MasterProcedureUid = MP.MasterProcedureUid
			INNER JOIN inserted I ON ListProcedure.ProcedureUid = I.ProcedureUid
		WHERE ListProcedure.ShortDescriptionChangedFromMaster != CASE WHEN (I.ShortDescription != MP.ShortDescription) THEN 1 ELSE 0 END;

END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[Procedure_Update]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[Procedure_Update] ON [dbo].[ListProcedure] AFTER UPDATE 
AS 
BEGIN
	UPDATE	ct
	SET		Inactive = 1
	FROM	inserted i INNER JOIN deleted d ON i.ProcedureUid  = d.ProcedureUid
			INNER JOIN RelChargeTicketSP ct ON i.ProcedureUid = ct.ProcedureUid 
	WHERE	i.Inactive = 1 AND
			d.Inactive = 0

	UPDATE	ct
	SET		Inactive = 1
	FROM	inserted i INNER JOIN deleted d ON i.ProcedureUid  = d.ProcedureUid
			INNER JOIN RelChargeTicketSO ct ON i.ProcedureUid = ct.ProcedureUid 
	WHERE	i.Inactive = 1 AND
			d.Inactive = 0
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[CustomerLicense]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[CustomerLicense] ON [dbo].[ListProductParameter] AFTER INSERT,DELETE,UPDATE AS
BEGIN
	SET NOCOUNT ON;
	IF EXISTS(
				SELECT TOP 1 *
				FROM [inserted]
				WHERE [ParameterName] IN (
						''RegistrationCustomerUid'',
						''RegistrationCustomerNumber'',
						''RegistrationCustomerLicense''
				)
	)
	BEGIN
		IF ([dbo].[IsReplicating]() = 1 AND [dbo].[IsCacheClient]() = 0)  -- block only replication changes to this table on the master DB
		BEGIN
			RAISERROR(''Replication cannot modify the Customer License on the main server.'',16,1);
			ROLLBACK TRAN
			RETURN ;
		END
	END
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[BlockReportUpdates]'))
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:		Kellye Culberth
-- Create date: 04/07/2021
-- Description:	Prevent ListReport from being updated by customers
-- =============================================
CREATE TRIGGER [dbo].[BlockReportUpdates]
   ON  [dbo].[ListReport]
AFTER UPDATE
AS 
BEGIN
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	declare @parameters varchar(20)

	-- always reset the values for Name/ReportParameters

	IF (UPDATE(ReportParameters))  
	BEGIN
		-- If ListReport.ReportParameters was updated, don''t allow product reports or custom reports to be updated
		print ''Disable trigger BlockReportUpdates to complete this action!''
		print ''ALTER TABLE [dbo].[ListReport] DISABLE TRIGGER [BlockReportUpdates]''

		update ListReport
			set ListReport.ReportParameters = ''<ReportParameters />''
		from ListReport
			join inserted on inserted.ReportUid = ListReport.ReportUid 
			join deleted on deleted.ReportUid = ListReport.ReportUid 
		where (
			(inserted.UserDefined = 0 or inserted.UserDefined = 2) 
			or (deleted.UserDefined = 0 or deleted.UserDefined = 2)
			) 
	END
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[BlockReportRdlUpdates]'))
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:		Kellye Culberth
-- Create date: 04/07/2021
-- Description:	Prevent ListReportRdl from being updated by customers
-- =============================================
CREATE TRIGGER [dbo].[BlockReportRdlUpdates]
   ON  [dbo].[ListReportRdl]
AFTER UPDATE
AS 
BEGIN
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	-- always reset the values for ReportDefinitions 

	IF (UPDATE(ReportDefinition) OR UPDATE(Name))  
	BEGIN
		-- If ListReportRdl.ReportDefinition or Name are updated, don''t allow product reports or custom reports to be updated
		print ''Disable trigger BlockReportRdlUpdates to complete this action!''
		print ''ALTER TABLE [dbo].[ListReportRdl] DISABLE TRIGGER [BlockReportRdlUpdates]''

		update ListReportRdl
			set ReportDefinition = deleted.ReportDefinition
			,Name = deleted.Name
			,UserDefined = deleted.UserDefined
			,LastModifiedByUid = deleted.LastModifiedByUid
			,LastModifiedDate = deleted.LastModifiedDate
		from ListReportRdl
			join inserted on inserted.ReportRdlUid = ListReportRdl.ReportRdlUid 
			join deleted on deleted.ReportRdlUid = ListReportRdl.ReportRdlUid 
		where (
			(inserted.UserDefined = 0 or inserted.UserDefined = 2 or (inserted.UserDefined = 1 and inserted.SQLRevision is not null)) 
			or (deleted.UserDefined = 0 or deleted.UserDefined = 2 or (deleted.UserDefined = 1 and deleted.SQLRevision is not null))
			) 
	END
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[message_uncomplete_insert]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[message_uncomplete_insert] on [dbo].[Message] after insert as
begin
	insert	messageuncomplete(messageuid)
	select	messageuid
	from	inserted
	where	datecompleted is null
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[message_uncomplete_update]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[message_uncomplete_update] on [dbo].[Message] after update as
begin
	if update(datecompleted)
	begin
		insert	messageuncomplete(messageuid)
		select	i.messageuid
		from	inserted i inner join deleted d on i.messageuid = d.messageuid
		where	i.datecompleted is null and
				not d.datecompleted is null

		delete	mu
		from	inserted i inner join deleted d on i.messageuid = d.messageuid
				inner join messageuncomplete mu on i.messageuid = mu.messageuid
		where	not i.datecompleted is null and
				d.datecompleted is null
	end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[MessageRxRefill_Computed_Update]'))
EXEC dbo.sp_executesql @statement = N'
CREATE TRIGGER [dbo].[MessageRxRefill_Computed_Update] on [dbo].[MessageRxRefill] for INSERT,UPDATE AS 
BEGIN		
	SET NOCOUNT ON;

	IF UPDATE(Phone)
		UPDATE	p
			SET	Computed_Phone_PhoneNumber = i.Phone.value(''(/Phone/PhoneNumber)[1]'', ''varchar(50)''),
				Computed_Phone_PhoneType = i.Phone.value(''(/Phone/PhoneType)[1]'', ''varchar(100)'')
		FROM	inserted i INNER JOIN MessageRxRefill p ON i.MessageUid = p.MessageUid

END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[MessageTC_Computed_Update]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[MessageTC_Computed_Update] on [dbo].[MessageTC] for INSERT,UPDATE AS 
BEGIN		
	SET NOCOUNT ON;

	IF UPDATE(Phone)
		UPDATE	p
			SET	Computed_Phone_PhoneNumber = i.Phone.value(''(/Phone/PhoneNumber)[1]'', ''varchar(50)''),
				Computed_Phone_PhoneType = i.Phone.value(''(/Phone/PhoneType)[1]'', ''varchar(100)'')
		FROM	inserted i INNER JOIN MessageTC p ON i.MessageUid = p.MessageUid

END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[Export_CallPointe]'))
EXEC dbo.sp_executesql @statement = N'
CREATE TRIGGER [dbo].[Export_CallPointe] 
   ON  [dbo].[MessageUser] 
   AFTER INSERT, UPDATE
AS 
BEGIN
 IF dbo.IsCacheClient() = 0
 BEGIN
	SET NOCOUNT ON;
	
	-- CallPointe HL7PartnerUid = ''A42B61BC-096A-4D8C-BD92-CE28159282CD''
	-- CallPointe HL7PartnerMessageUid = ''1B8C2997-08C3-41F0-B077-C391F5B08E8A''
	-- CallPointe UserUid = ''AF8F2184-6591-4DF8-86BE-E91CCF2506E7''

    -- Insert statements for trigger here
    -- Check if there is an active CallPointe HL7Partner
	IF NOT EXISTS (SELECT * FROM HL7Partner hp
						JOIN HL7PartnerMessage hpm on hp.HL7PartnerUid = hpm.HL7PartnerUid
						WHERE hp.HL7PartnerUid = ''A42B61BC-096A-4D8C-BD92-CE28159282CD'' and hp.Inactive = 0 and hpm.Inactive = 0)
	BEGIN
		RETURN
	END
	
	INSERT INTO HL7ActionTypeObject(HL7PartnerMessageUid, ObjectUid, ObjectType, ActionType, LastModifiedDate)
	SELECT ''1B8C2997-08C3-41F0-B077-C391F5B08E8A'', i.MessageUid, ''Message'', ''CallPointe_Export'', GETUTCDATE()
		FROM inserted I 
		JOIN deleted D ON I.MessageUserUid = D.MessageUserUid
		WHERE I.UserUid = ''AF8F2184-6591-4DF8-86BE-E91CCF2506E7''
			AND D.UserUid <> ''AF8F2184-6591-4DF8-86BE-E91CCF2506E7''
			
	INSERT INTO HL7ActionTypeObject(HL7PartnerMessageUid, ObjectUid, ObjectType, ActionType, LastModifiedDate)
	SELECT ''1B8C2997-08C3-41F0-B077-C391F5B08E8A'', i.MessageUid, ''Message'', ''CallPointe_Export'', GETUTCDATE()
		FROM inserted I 
		LEFT JOIN deleted D ON I.MessageUserUid = D.MessageUserUid
		WHERE I.UserUid = ''AF8F2184-6591-4DF8-86BE-E91CCF2506E7''
			AND D.MessageUserUid IS NULL --NEWLY INSERTED ROW ASSIGNED TO CALLPOINTE
 END
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[CCD_OO_Resulted]'))
EXEC dbo.sp_executesql @statement = N'

CREATE   TRIGGER [dbo].[CCD_OO_Resulted] ON [dbo].[ObservationOrder] FOR INSERT, UPDATE AS  
IF dbo.IsCacheClient() = 0
BEGIN

DECLARE @CCDTable TABLE (PartnerMessageUid UNIQUEIDENTIFIER,PatientUid UNIQUEIDENTIFIER, VisitUid UNIQUEIDENTIFIER, CCDAUid UNIQUEIDENTIFIER, LastModifiedByUid UNIQUEIDENTIFIER)
DECLARE @ExcludePartners VARCHAR(MAX) = NULL
DECLARE @ObjectType varchar(25) = ''Patient''
DECLARE @SendFunction varchar(25) = ''CCD Generation''
DECLARE @IsByVisit VARCHAR(MAX)
DECLARE @BoolByVisit SMALLINT

		
		--Check to ensure there is a valid partner otherwise exits trigger
		IF NOT EXISTS (SELECT TOP 1 * FROM HL7PartnerMessage 
						WHERE (SendFunction = @SendFunction)	AND Send = 1 AND Inactive = 0)
		RETURN

	   --Gets String of Partners that should send CCDA by Visit
       SELECT @IsByVisit = StringValue, @BoolByVisit = BoolValue FROM ListProductParameter where ParameterName = ''CCDAByVisit''

	   --Generates Temp CCDATable this expands inserted to include each valid partner and sets as episodic or longitudinal Send
	   INSERT INTO @CCDTable
       SELECT DISTINCT a.HL7PartnerMessageUid 
             ,i.PatientUid
             ,i.Visituid
             ,CASE 	WHEN (@IsByVisit IS NULL AND @BoolByVisit = 1) THEN i.VisitUid 
			 		WHEN (a.HL7PartnerMessageUid IN (SELECT Element FROM dbo.Split(@IsByVisit,'','')) AND @BoolByVisit = 1) THEN i.VisitUid
			 		ELSE i.Patientuid END AS CCDAUid
             ,i.LastModifiedByUid
       FROM INSERTED i
       CROSS JOIN (
             SELECT PM.HL7PartnerMessageUid
             FROM   HL7partner P 
             LEFT JOIN HL7PartnerMessage PM ON PM.HL7partnerUid=P.HL7partnerUid
             WHERE PM.MessageType = ''CCD'' 
                    AND PM.SendFunction = @SendFunction
                    AND PM.Inactive = 0  
                    AND P.Inactive = 0 
                    AND PM.Send = 1
       ) a
	   LEFT JOIN Visit v ON i.VisitUid = v.VisitUid
	   WHERE i.ResultStatusID >= 9
	   AND (v.visittypeuid is null or v.VisitTypeUid <> ''ADA7EB5D-FD9A-4E9F-88E5-84EDDA9EFC42'' )--RefillVisits
	   
	   --Gets String of Paftners that do not want CCDA''s sent on results updates
       SELECT @ExcludePartners = StringValue FROM ListProductParameter where ParameterName = ''CCDAexcludeUpdatedResults''
		
	   --Removes rows from the CCDA table when the partner is set to not send CCDA on results update
       IF @ExcludePartners IS NOT NULL
             DELETE FROM @CCDTable WHERE PartnerMessageUid IN (SELECT Element FROM dbo.Split(@ExcludePartners,'',''))
		
		--Removes messages in HL7ATO that are pending to prevent multiple sends
		DELETE HL7ActionTypeObject WHERE HL7ActionTypeObjectUid in
			(SELECT HL7ActionTypeObjectUid FROM HL7ActionTypeObject ato
			JOIN @CCDTable c ON ato.HL7PartnerMessageUid = c.PartnerMessageUid
			WHERE ato.ObjectUid = c.CCDAUid and ato.ActionType = @SendFunction and ato.ObjectType = @ObjectType) 
		
		--Checks to ensure CCDATable has values and then inserts the values into HL7ATO to send CCDAs
		IF Exists (Select * from @CCDTable)
		BEGIN
			INSERT HL7ActionTypeObject(HL7PartnerMessageUid, ActionType, ObjectUid, ObjectType, LastModifiedByUid)  
			SELECT c.PartnerMessageUid
						,@SendFunction
						,c.CCDAUid
						,@ObjectType
						,c.LastModifiedByUid  
			FROM   @CCDTable c
						INNER JOIN HL7PartnerMessage pm on c.PartnerMessageUid = pm.HL7PartnerMessageUid
						INNER JOIN HL7Partner p ON pm.HL7PartnerUid = p.HL7PartnerUid  
						LEFT JOIN ViewActionTypeObjectPartnerMessage atopm ON c.CCDAUid = atopm.ObjectUid AND pm.HL7PartnerUid = atopm.HL7PartnerUid AND atopm.HL7ActionTypeObjectUid IS NULL
						LEFT Join RelHL7PartnerPatientConsent rhpc on rhpc.PatientUid = c.PatientUid and p.HL7PartnerUid = rhpc.HL7PartnerUid
			WHERE  (rhpc.ConsentAgreed = 1 OR (p.ConsentStatus = 1 AND rhpc.ConsentAgreed IS NULL))
						--Bug 58259 new patients get written to RelHL7PartnerPatientConsent regardless of if consent is marked.  If not changed ConsentAgreed = NULL, if denied = 0, if consent
						--is given = 1.  Update also made to CCD_Visit_Complete
		END


END' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[interface_observationorder]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[interface_observationorder] ON [dbo].[ObservationOrder]
AFTER INSERT, UPDATE

/*
Purpose: Used to track inserts made to the Visit table for HL7
Created On: 20050929
Modified On: 20061115
Modifications Made:  1. Modified as per ORM Work-Flow per Sanket
Special Comments
   ExternalID FROM ListLaboratory Table should match with ExternalID from HL7Partner table.
   INSERTING TRACKING NUM MANUALLY
   CMR: Moved the ResultStatus synchronization code over to here to avoid trigger recursion
   Pancratius:-3/28/2014: Changed the FORWARD_ONLY Cursor to FAST_FORWARD
*/

AS

BEGIN
   -- protect special fields to avoid being overwritten by stale data in UI
   IF EXISTS (SELECT TOP 1 * FROM inserted) AND
      EXISTS (SELECT TOP 1 * FROM deleted)
   BEGIN
      DECLARE @idsToFix TABLE(ObservationOrderUid UNIQUEIDENTIFIER PRIMARY KEY NOT NULL)

      INSERT INTO @idsToFix
      SELECT i.ObservationOrderUid
      FROM inserted i
      JOIN deleted d ON i.observationorderuid = d.observationorderuid
      WHERE ((d.ImedicaAccessionNumber <> i.ImedicaAccessionNumber)                       --if accession changed
          OR (d.iMedicaAccessionNumber IS NOT NULL AND i.iMedicaAccessionNumber IS NULL)  --if accession became null
          OR (d.ResultDateTime IS NOT NULL AND i.ResultDateTime IS NULL)                          --if result date became null
          OR (d.AttachmentTypeUid IS NOT NULL AND i.AttachmentTypeUid IS NULL)            --if attachment type became null
          OR (d.ResultStatusID > 1 AND ISNULL(i.ResultStatusID, 0) IN(0, 1)))             --if result status reverted to 1

      --**notice that some of the isnull() statements have the D table first and some have the OO table first, this is intentional
      UPDATE oo
      SET
         --accession number should never change, keep deleted value unless it is null
         iMedicaAccessionNumber  = ISNULL(d.iMedicaAccessionNumber, oo.iMedicaAccessionNumber),
         --let the result date change to the new OO value if it isn''t null
         ResultDateTime              = ISNULL(oo.ResultDateTime, d.ResultDateTime),
         --let the attachment type change to the new OO value if it isn''t null
         AttachmentTypeUid       = ISNULL(oo.AttachmentTypeUid, d.AttachmentTypeUid),
         --don''t let result status change to 1 if it was >1 before
         ResultStatusID          = CASE WHEN (d.ResultStatusID > 1 AND ISNULL(oo.ResultStatusID, 0) IN(0, 1))
                                      THEN d.ResultStatusID
                                      ELSE oo.ResultStatusID
                                   END
      FROM ObservationOrder oo
      INNER JOIN @idsToFix i ON oo.ObservationOrderUid = i.ObservationOrderUid
      INNER JOIN DELETED d ON i.ObservationOrderUid = d.ObservationOrderUid
   END

   IF dbo.IsReplicating() != 0
      RETURN

   IF 0 = (SELECT COUNT(*) FROM inserted)
      RETURN

   -- Synchronize ObservationOrderResultStatusUid with ResultStatusID
   UPDATE oo
   SET ObservationOrderResultStatusUid = ISNULL(rsSync.ObservationOrderResultStatusUid, ''4AE36BB9-8A98-4EA6-AB4A-85BE6D95BDD4'')
   FROM inserted ins
   INNER JOIN ObservationOrder oo ON oo.ObservationOrderUid = ins.ObservationOrderUid
   INNER JOIN ListObservationOrderResultStatus rsSync ON rsSync.ResultStatusID = ISNULL(oo.ResultStatusID, 0) AND rsSync.UserDefined != 1
   LEFT JOIN ListObservationOrderResultStatus rsCheck ON rsCheck.ObservationOrderResultStatusUid = ins.ObservationOrderResultStatusUid
   WHERE rsCheck.ResultStatusID IS NULL
      OR rsCheck.ResultStatusID != ISNULL(oo.ResultStatusID, 0)

   -- record order status changes to the audit history
   INSERT INTO ObservationOrderResultStatusHistory(
      ObservationOrderUid,
      ObservationOrderResultStatusUid,
      LastModifiedDate,
      LastModifiedByUid)
   SELECT
      ObservationOrderUid              = oo.ObservationOrderUid,
      ObservationOrderResultStatusUid  = CASE WHEN (rsCheck.ResultStatusID IS NULL OR rsCheck.ResultStatusID != ISNULL(oo.ResultStatusID, 0))
                                            THEN ISNULL(rsSync.ObservationOrderResultStatusUid, ''4AE36BB9-8A98-4EA6-AB4A-85BE6D95BDD4'')
                                            ELSE oo.ObservationOrderResultStatusUid
                                         END,
      LastModifiedDate                 = oo.LastModifiedDate,
      LastModifiedByUid                = oo.LastModifiedByUid
   FROM inserted ins
   INNER JOIN ObservationOrder oo ON oo.ObservationOrderUid = ins.ObservationOrderUid
   INNER JOIN ListObservationOrderResultStatus rsSync ON rsSync.ResultStatusID = ISNULL(oo.ResultStatusID, 0) AND rsSync.UserDefined != 1
   LEFT JOIN ListObservationOrderResultStatus rsCheck ON rsCheck.ObservationOrderResultStatusUid = oo.ObservationOrderResultStatusUid
   LEFT JOIN deleted del ON del.ObservationOrderUid = ins.ObservationOrderUid
   WHERE rsCheck.ResultStatusID IS NULL
      OR rsCheck.ResultStatusID != ISNULL(oo.ResultStatusID, 0)
      OR del.ObservationOrderUid IS NULL
      OR ISNULL(del.ResultStatusID, 0) != ISNULL(oo.ResultStatusID, 0)
      OR del.ObservationOrderResultStatusUid != oo.ObservationOrderResultStatusUid


  IF dbo.IsCacheClient() != 0
		RETURN
		
		
   IF NOT EXISTS(SELECT *
                 FROM HL7Partner
                 INNER JOIN HL7PartnerMessage ON HL7Partner.HL7PartnerUid = HL7PartnerMessage.HL7PartnerUid
                 WHERE HL7PartnerMessage.MessageType = ''ORM''
                   AND HL7Partner.Inactive = 0
                   AND HL7PartnerMessage.Inactive = 0)
      RETURN

   SET NOCOUNT ON
   DECLARE @VisitUid             UNIQUEIDENTIFIER
   DECLARE @ObservationOrderUid  UNIQUEIDENTIFIER
   DECLARE @Hl7PartnerMessageUid UNIQUEIDENTIFIER
   DECLARE @SOSP                 VARCHAR(2)

   DECLARE ORM_CUR CURSOR LOCAL FAST_FORWARD FOR
      SELECT I.VisitUid, i.ObservationOrderUid, Hl7PartnerMessageUid
      FROM INSERTED I
      INNER JOIN Visit ON Visit.VisitUid = I.VisitUid
      INNER JOIN ListLaboratory on I.LaboratoryUid  = ListLaboratory.LaboratoryUid
      INNER JOIN HL7Partner on ListLaboratory.ExternalID = HL7Partner.ExternalID
      INNER JOIN HL7PartnerMessage on HL7Partner.Hl7PartnerUid = Hl7PartnerMessage.Hl7PartnerUid
      INNER JOIN ObservationOrder oo on i.observationorderuid = oo.observationorderuid
	  LEFT JOIN VisitProcedure vp on oo.VisitProcedureUid = vp.VisitProcedureUid
      WHERE oo.ResultStatusID = 1
        AND oo.GenerateLabOrder=1
		AND vp.NegationReasonUid IS NULL
        AND HL7PartnerMessage.MessageType = ''ORM''
        AND Hl7Partner.Inactive = 0
        AND ListLaboratory.Inactive = 0
        AND HL7PartnerMessage.Inactive = 0
        AND (ListLaboratory.SendFutureOrders = 1 OR oo.OrderDate IS NULL OR oo.OrderDate <= GETUTCDATE()) 
   OPEN ORM_CUR

   FETCH NEXT FROM ORM_CUR INTO @VisitUid, @ObservationOrderUid, @Hl7PartnerMessageUid

   WHILE @@FETCH_STATUS = 0
   BEGIN
      -- check if UPDATE , if yes, then see if record exists in the ActionObjectType table in Error status then , update.
      IF EXISTS(SELECT VisitUid FROM DELETED WHERE VisitUid = @VisitUid)
         BEGIN
            IF EXISTS(SELECT HL7ActionTypeObjectUid
                      FROM HL7ActionTypeObject
                      WHERE ObjectUid = @VisitUid
                       AND HL7PartnerMessageUid = @Hl7PartnerMessageUid)
                        --ActionType LIKE ''ORM'')
                       
            BEGIN
               UPDATE HL7ActionTypeObject
               SET
                  ProcessingError   = 0,
                  LastModifiedDate  = GETUTCDATE()
               WHERE ObjectUid = @VisitUid
                 AND HL7PartnerMessageUid = @Hl7PartnerMessageUid
            END
            ELSE
            BEGIN
               INSERT INTO HL7ActionTypeObject(
  HL7ActionTypeObjectUid,
                  HL7PartnerMessageUid,
                  ObjectType,
  ActionType,
ObjectUid,
                  LastModifiedDate)
               VALUES(
                  NEWID(),
                  @Hl7PartnerMessageUid,
                  ''Lab Order'',
                  ''ORM'',
                  @VisitUid,
                  GETUTCDATE())
            END
         END
      ELSE IF EXISTS(SELECT VisitUid
                     FROM INSERTED
                     WHERE VisitUid = @VisitUid)
      AND NOT EXISTS(SELECT HL7ActionTypeObjectUid
                     FROM HL7ActionTypeObject
                     WHERE ObjectUid = @VisitUid
                       AND HL7PartnerMessageUid = @Hl7PartnerMessageUid)-- INSERT
         BEGIN
            INSERT INTO HL7ActionTypeObject(
               HL7ActionTypeObjectUid,
               HL7PartnerMessageUid,
               ObjectType,
               ActionType,
               ObjectUid,
               LastModifiedDate)
            VALUES(
               NEWID(),
               @Hl7PartnerMessageUid,
               ''Lab Order'',
               ''ORM'',
               @VisitUid,
               GETUTCDATE())
         END

      FETCH NEXT FROM ORM_CUR INTO @VisitUid, @ObservationOrderUid, @Hl7PartnerMessageUid
   END

   CLOSE ORM_CUR
   DEALLOCATE ORM_CUR
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[observationorder_Cancel]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[observationorder_Cancel] ON [dbo].[ObservationOrder]
AFTER UPDATE
AS
BEGIN
  SET NOCOUNT ON
   DECLARE @VisitUid                UNIQUEIDENTIFIER
   DECLARE @ObservationOrderUid     UNIQUEIDENTIFIER
   DECLARE @Hl7PartnerMessageUid	UNIQUEIDENTIFIER
   DECLARE @ImedicaAccessionNumber	VARCHAR(255)
   
   IF NOT EXISTS(SELECT *
                 FROM HL7Partner hp
                 INNER JOIN HL7PartnerMessage hpm ON hp.HL7PartnerUid = hpm.HL7PartnerUid
                 inner join listlaboratory ll on ll.externalid = hp.externalid
                 inner join inserted as i on i.LaboratoryUid = ll.LaboratoryUid ---NEW LINE ADDED
                 WHERE hpm.MessageType = ''ORM''
                   AND Hp.Inactive = 0
                   AND hpm.Inactive = 0
                   and ll.AllowCancelOrders = 1)
    RETURN;

    IF NOT EXISTS (
					SELECT 1
					FROM DELETED d
					INNER JOIN INSERTED i on d.ObservationOrderUid = i.ObservationOrderUid
					WHERE d.ResultStatusID <> -1
					AND i.ResultStatusID = -1
					)
        RETURN;
   
   DECLARE @Cancels TABLE (VisitUid UNIQUEIDENTIFIER, Hl7PartnerMessageUid    UNIQUEIDENTIFIER, ImedicaAccessionNumber    VARCHAR(255))
   INSERT INTO @Cancels
    SELECT DISTINCT  I.VisitUid, Hl7PartnerMessageUid, i.ImedicaAccessionNumber
    FROM Inserted I
    inner join visitprocedure vp on i.VisitProcedureUid=vp.VisitProcedureUid
    INNER JOIN Visit v ON v.VisitUid = I.VisitUid
    INNER JOIN ListLaboratory on I.LaboratoryUid  = ListLaboratory.LaboratoryUid
    INNER JOIN HL7Partner on ListLaboratory.ExternalID = HL7Partner.ExternalID
    INNER JOIN HL7PartnerMessage on HL7Partner.Hl7PartnerUid = Hl7PartnerMessage.Hl7PartnerUid
    WHERE i.ResultStatusID = -1 
		AND i.GenerateLabOrder=1
		AND HL7PartnerMessage.MessageType = ''ORM''
		AND Hl7Partner.Inactive = 0
		AND ListLaboratory.Inactive = 0
		AND HL7PartnerMessage.Inactive = 0
		and vp.isdelete = 1
		and I.cancel=1

	DELETE c
	FROM @Cancels c
	INNER JOIN HL7ActionTypeObject ato on c.Hl7PartnerMessageUid = ato.HL7PartnerMessageUid 
		AND c.VisitUid = ato.ObjectUid
		AND ato.ObjectType = ''Lab Order - Cancel''
		AND CONVERT(XML, ato.MessageContextXML).value(''(//ImedicaAccessionNumber)[1]'',''VARCHAR(255)'') = ImedicaAccessionNumber

   DECLARE ORM_CUR CURSOR LOCAL FAST_FORWARD FOR
   SELECT * FROM @Cancels
   OPEN ORM_CUR

   FETCH NEXT FROM ORM_CUR INTO @VisitUid, @Hl7PartnerMessageUid, @ImedicaAccessionNumber

   WHILE @@FETCH_STATUS = 0
   BEGIN
        IF EXISTS(    SELECT oo.VisitUid
                        From ObservationOrder oo 
                        inner join visitprocedure vp on oo.VisitProcedureUid=vp.VisitProcedureUid
                        WHERE vp.isdelete = 1 and 
                        oo.VisitUid = @VisitUid and oo.cancel=1)
         BEGIN
            INSERT INTO HL7ActionTypeObject(
               HL7ActionTypeObjectUid,
               HL7PartnerMessageUid,
               ObjectType,
               ActionType,
               ObjectUid,
			   MessageContextXML,
               LastModifiedDate)
            VALUES(
               NEWID(),
               @Hl7PartnerMessageUid,
               ''Lab Order - Cancel'',
               ''ORM'',
               @VisitUid,
			   ''<ImedicaAccessionNumber>''+@ImedicaAccessionNumber+''</ImedicaAccessionNumber>'',
               GETUTCDATE())
         END

      FETCH NEXT FROM ORM_CUR INTO @VisitUid, @Hl7PartnerMessageUid, @ImedicaAccessionNumber
   END

   CLOSE ORM_CUR
   DEALLOCATE ORM_CUR
   
   SET NOCOUNT OFF
END


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[ObsOrder_EmptyResults]'))
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- author:     kevin crumpton
-- create date: 08/27/2009
-- description:   handle final results for orders with no items
-- =============================================
CREATE trigger [dbo].[ObsOrder_EmptyResults]
   on  [dbo].[ObservationOrder]
   after insert,update
as
begin
   -- set nocount on added to prevent extra result sets from
   -- interfering with select statements.
   set nocount on;

   if not exists (select * from listproductparameter where parametername = ''adddummyitemforemptyfinalorders'' and boolvalue = 1)
   begin
      --option not set
      return
   end

   declare @oouids table
   (
      oouid uniqueidentifier,
      vpuid uniqueidentifier
   )


   insert into @oouids
   select oo.observationorderuid, oo.visitprocedureuid
      from observationorder oo
      join inserted i on oo.observationorderuid = i.observationorderuid
      left join deleted d on i.observationorderuid = d.observationorderuid
      left join observationvalue ov on oo.observationorderuid = ov.observationorderuid
      where oo.resultstatuscode = ''f'' and isnull(d.resultstatuscode, '''') <> ''f'' -- when a result is set to final
                  -- or a new final result is inserted
         and ov.observationvalueuid is null
         and oo.observationuid is null
--and oo.observationorderuid = ''6917b62a-2cf4-4990-ac6e-78ffe06b8658'' -- ''6917b62a-2cf4-4990-ac6e-78ffe06b8658''

   declare @oouid uniqueidentifier
   declare @vpuid uniqueidentifier

   select @oouid = null, @vpuid = null
   select top 1 @oouid = oouid, @vpuid = vpuid from @oouids

   if @oouid is not null
   begin
      declare @observationitemuid uniqueidentifier
      select top 1 @observationitemuid = observationitemuid from listobservationitem where name = ''n/a''

      if @observationitemuid is null
      begin
         insert into listobservationitem (name)
         select ''n/a''

         select top 1 @observationitemuid = observationitemuid from listobservationitem where name = ''n/a''
      end

      declare @attachmenttypeuid uniqueidentifier
      select top 1 @attachmenttypeuid = attachmenttypeuid from listattachmenttype where name = ''lab results''
   end

   while @oouid is not null
   begin
      declare @templatename varchar(100)
      select @templatename = ''blank template'' --default if no procedure name is found

      if @vpuid is not null
      begin
         select @templatename = lp.shortdescription
         from visitprocedure vp
            join listprocedure lp on vp.procedureuid = lp.procedureuid
         where vp.visitprocedureuid = @vpuid
      end

      if isnull(@templatename, '''') = ''''
      begin
         select @templatename = ''blank template''
      end

      declare @observationuid uniqueidentifier
      select top 1 @observationuid = lo.observationuid
         from listobservation lo
            left join relobservationobservationitem roo on roo.observationuid = lo.observationuid
         where name = @templatename and roo.relobservationobservationitemuid is null --template with no items

      if @observationuid is null
      begin
         insert into listobservation(name, observationtypeid)
         select @templatename, 2

         select top 1 @observationuid = lo.observationuid
            from listobservation lo
               left join relobservationobservationitem roo on roo.observationuid = lo.observationuid
            where name = @templatename and roo.relobservationobservationitemuid is null --template with no items

         --add n/a item to template
         insert into relobservationobservationitem(observationuid, observationitemuid, displayorder, optional)
         select @observationuid, @observationitemuid, 1, 1
      end


      --insert ''dummy'' observation value row
      insert into observationvalue(name, observationitemuid, observationorderuid, visituid, laboratoryuid, resultstatuscode, resultstatusid,
         observationvalue, displayorder, datetimevalue, referencerange, abnormalflagcode, notes, measurementunits, stringmin, stringmax)
      select ''n/a'', @observationitemuid, @oouid, oo.visituid, oo.laboratoryuid, ''f'', 7, '''', 1, getutcdate(), '''', '''', '''', '''', '''', ''''
      from observationorder oo
      where oo.observationorderuid = @oouid

      --mark order (observationorder) row as resulted
      update observationorder set resultstatusid = 7,
         observationorderresultstatusUid = CAST(''E4861953-D5F3-4D86-BE78-530B394AE39E'' AS UNIQUEIDENTIFIER),
         attachmenttypeuid = @attachmenttypeuid,
         observationuid = @observationuid,
         abnormalflagcode = '''',
         LastModifiedDate = GETUTCDATE()
      where observationorderuid = @oouid

      delete @oouids where oouid = @oouid
      select @oouid = null, @vpuid = null
      select top 1 @oouid = oouid, @vpuid = vpuid from @oouids
   end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[EKOS_Patient_Delete]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[EKOS_Patient_Delete] ON [dbo].[Patient]   
FOR DELETE  

AS  
BEGIN  

IF @@ROWCOUNT = 0  
RETURN  

 IF dbo.IsCacheClient() = 0  
 BEGIN  
  SET NOCOUNT ON   
    
  if not exists (select * 
				 from TransmissionConfiguration tc
                 inner join ListIntegrationPartner lip on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
			     where tc.TransmissionType = ''EKOS'' and
					   lip.Inactive = 0 )
	RETURN;

	IF NOT  EXISTS (SELECT 1 FROM deleted)

	RETURN;

	BEGIN

	  	DELETE TransmissionOutbound where TransmissionOutboundUid in  
			(  
				SELECT TransmissionOutboundUid  
				from TransmissionOutbound tod WITH(NOLOCK)
				INNER JOIN deleted d on tod.ForeignObjectUid = d.PersonUid
						Where 
						 tod.RawMessage =''iMedica.Prm.BusinessObject.Patient'' and
						 tod.TransmissionType=''EKOS''
						AND tod.Status <> 100
			)  
			 
       insert    TransmissionOutbound(TransmissionType, Description, ForeignObjectUid, RawMessage,PatientUid, lastmodifiedbyuid, LastModifiedDate)
		select    distinct ''EKOS'',''PATIENTDELETE'', d.personuid, ''iMedica.Prm.BusinessObject.Patient'', d.personuid, d.lastmodifiedbyuid, GETUTCDATE()
		from      TransmissionConfiguration tc
        inner join ListIntegrationPartner lip on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
				 cross join deleted d
			     where tc.TransmissionType = ''EKOS'' and
					   lip.Inactive = 0 

      END  

 END 
  
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[EKOS_patient_insert]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[EKOS_patient_insert] on [dbo].[Patient] for insert as
begin
  if not exists ( select top 1 * from inserted )
    return

  if dbo.IsReplicating() = 0
  begin

		insert    TransmissionOutbound(TransmissionType, ForeignObjectUid, RawMessage, PatientUid, lastmodifiedbyuid, LastModifiedDate)
		select    distinct ''EKOS'', i.personuid, ''iMedica.Prm.BusinessObject.Patient'', i.personuid, i.lastmodifiedbyuid, GETUTCDATE()
		from      TransmissionConfiguration tc WITH(NOLOCK)
        inner join ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
		cross join inserted i 
	    where     tc.TransmissionType = ''EKOS'' and
        lip.Inactive = 0 
  end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[EKOS_patient_update]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[EKOS_patient_update] on [dbo].[Patient] for update as
begin	
  if not exists ( select top 1 * from inserted )
    return

  if dbo.IsReplicating() = 0
  begin

		insert    TransmissionOutbound(TransmissionType, ForeignObjectUid, RawMessage, PatientUid, lastmodifiedbyuid, LastModifiedDate)
		select    distinct ''EKOS'', i.personuid, ''iMedica.Prm.BusinessObject.Patient'', i.personuid, i.lastmodifiedbyuid, GETUTCDATE()
		from      TransmissionConfiguration tc WITH(NOLOCK)
        inner join ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
		cross join inserted i 
	    where     tc.TransmissionType = ''EKOS'' and
        lip.Inactive = 0 

  end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[interface_patient_delete]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[interface_patient_delete] on [dbo].[Patient] for delete as
begin
  if not exists ( select top 1 * from deleted )
    return

  if dbo.IsReplicating() = 0
  begin

	  insert	hl7actiontypeobject(hl7partnermessageuid, actiontype, objectuid, lastmodifiedbyuid, messagecontextxml)  
	  select	pm.hl7partnermessageuid, pm.sendfunction, d.personuid, d.lastmodifiedbyuid,
			  ''<context>'' + 
			  ''<medicalrecordnumber>'' + d.medicalrecordnumber + ''</medicalrecordnumber>'' +
			  ''<externalid>'' + isnull(d.externalid,'''') + ''</externalid>'' +
			  ''<lastname>'' + isnull(per.lastname, '''') + ''</lastname>'' + 
			  ''<firstname>'' + isnull(per.firstname, '''') + ''</firstname>'' + 
			  ''<middlename>'' + isnull(per.lastname, '''') + ''</middlename>'' + 
			  ''<socialsecuritynumber>'' + isnull(per.socialsecuritynumber, '''') + ''</socialsecuritynumber>'' + 
			  ''<birthdate>'' + isnull(convert(varchar, per.birthdate), '''') + ''</birthdate>'' + 
			  ''</context>''
	  from	hl7partnermessage pm inner join hl7partner p on pm.hl7partneruid = p.hl7partneruid  
			  cross join deleted d 
			  left join person per on d.personuid = per.personuid
	  where	pm.sendfunction = ''deletepatient'' and  
			  pm.send = 1 and  
			  pm.inactive = 0 and  
			  p.inactive = 0
  end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[interface_patient_insert]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[interface_patient_insert] on [dbo].[Patient] for insert as
begin
  if not exists ( select top 1 * from inserted )
    return

  if dbo.IsReplicating() = 0
  begin

	  insert	hl7actiontypeobject(hl7partnermessageuid, actiontype, objectuid, objecttype, lastmodifiedbyuid)
	  select	pm.hl7partnermessageuid, pm.sendfunction, i.personuid, ''Patient'', i.lastmodifiedbyuid
	  from	hl7partnermessage pm inner join hl7partner p on pm.hl7partneruid = p.hl7partneruid
			  cross join inserted i 
			  left join viewactiontypeobjectpartnermessage atopm on i.personuid = atopm.objectuid and atopm.objecttype=''patient'' and pm.hl7partneruid = atopm.hl7partneruid and atopm.sendfunction in (''insertpatient'', ''updatepatient'')
	  where	pm.sendfunction = ''insertpatient'' and
			  pm.send = 1 and
			  pm.inactive = 0 and
			  p.inactive = 0 and
			  atopm.hl7actiontypeobjectuid is null
  end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[interface_patient_update]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[interface_patient_update] on [dbo].[Patient] for update as
begin	
  if not exists ( select top 1 * from inserted )
    return

  if dbo.IsReplicating() = 0
  begin

	  insert	hl7actiontypeobject(hl7partnermessageuid, actiontype, objectuid, objecttype, lastmodifiedbyuid, messagecontextxml)  
	  select	pm.hl7partnermessageuid, pm.sendfunction, i.personuid, ''patient'', i.lastmodifiedbyuid,
				  ''<context>'' + 
				  ''<medicalrecordnumber>'' + d.medicalrecordnumber + ''</medicalrecordnumber>'' +
				  ''<externalid>'' + isnull(d.externalid,'''') + ''</externalid>'' +
				  ''<lastname>'' + isnull(per.lastname, '''') + ''</lastname>'' + 
				  ''<firstname>'' + isnull(per.firstname, '''') + ''</firstname>'' + 
				  ''<middlename>'' + isnull(per.lastname, '''') + ''</middlename>'' + 
				  ''<socialsecuritynumber>'' + isnull(per.socialsecuritynumber, '''') + ''</socialsecuritynumber>'' + 
				  ''<birthdate>'' + isnull(convert(varchar, per.birthdate), '''') + ''</birthdate>'' + 
				  ''</context>''
	  from	hl7partnermessage pm inner join hl7partner p on pm.hl7partneruid = p.hl7partneruid  
			  cross join inserted i 
			  inner join deleted d on i.personuid = d.personuid and (i.medicalrecordnumber <> d.medicalrecordnumber or i.externalid <> d.externalid)
			  inner join person per on d.personuid = per.personuid
			  left join viewactiontypeobjectpartnermessage atopm on i.personuid = atopm.objectuid and atopm.objecttype=''patient'' and pm.hl7partneruid = atopm.hl7partneruid and atopm.sendfunction in (''insertpatient'', ''updatepatient'')
	  where	pm.sendfunction = ''mergepatient'' and  
			  pm.send = 1 and  
			  pm.inactive = 0 and  
			  p.inactive = 0 and  
			  atopm.hl7actiontypeobjectuid is null

	  insert	hl7actiontypeobject(hl7partnermessageuid, actiontype, objectuid, objecttype, lastmodifiedbyuid)
	  select	pm.hl7partnermessageuid, pm.sendfunction, i.personuid, ''Patient'', i.lastmodifiedbyuid
	  from	hl7partnermessage pm inner join hl7partner p on pm.hl7partneruid = p.hl7partneruid
			  cross join inserted i 
			  left join viewactiontypeobjectpartnermessage atopm on i.personuid = atopm.objectuid and atopm.objecttype=''patient'' and pm.hl7partneruid = atopm.hl7partneruid and atopm.sendfunction in (''insertpatient'', ''updatepatient'')
	  where	pm.sendfunction = ''updatepatient'' and
			  pm.send = 1 and
			  pm.inactive = 0 and
			  p.inactive = 0 and
			  atopm.hl7actiontypeobjectuid is null

  end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[MPI_interface_patient_insert]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[MPI_interface_patient_insert] on [dbo].[Patient] for insert as
begin
  if not exists ( select top 1 * from inserted )
    return

  if dbo.IsReplicating() = 0
  begin

	  insert	hl7actiontypeobject(hl7partnermessageuid, actiontype, objectuid, objecttype, lastmodifiedbyuid)
	  select	pm.hl7partnermessageuid, ''InsertPatient'', i.personuid, ''Patient'', i.lastmodifiedbyuid
	  from	hl7partnermessage pm inner join hl7partner p on pm.hl7partneruid = p.hl7partneruid
			  cross join inserted i 
			  left join viewactiontypeobjectpartnermessage atopm on i.personuid = atopm.objectuid 
					and atopm.objecttype=''patient'' 
					and pm.hl7partneruid = atopm.hl7partneruid 
					and atopm.sendfunction in (''MPIInsertPatient'', ''MPIUpdatePatient'')
			  LEFT Join RelHL7PartnerPatientConsent rhpc on rhpc.PatientUid = i.PersonUid 
					and p.HL7PartnerUid = rhpc.HL7PartnerUid
	  where	pm.sendfunction = ''MPIInsertPatient'' and
			  pm.send = 1 and
			  pm.inactive = 0 and
			  p.inactive = 0 and
			  atopm.hl7actiontypeobjectuid is null and
			  ((rhpc.ConsentAgreed = 1 AND rhpc.ProtectionIndicator = ''Y'') OR (p.ConsentStatus = 1 AND (rhpc.ConsentAgreed IS NULL OR rhpc.ProtectionIndicator = ''Y'')))

  end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[MPI_interface_patient_update]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[MPI_interface_patient_update] on [dbo].[Patient] for update as
begin	
  if not exists ( select top 1 * from inserted )
    return

  if dbo.IsReplicating() = 0
  begin

	  insert	hl7actiontypeobject(hl7partnermessageuid, actiontype, objectuid, objecttype, lastmodifiedbyuid)
	  select	pm.hl7partnermessageuid, ''UpdatePatient'', i.personuid, ''Patient'', i.lastmodifiedbyuid
	  from	hl7partnermessage pm inner join hl7partner p on pm.hl7partneruid = p.hl7partneruid
			  cross join inserted i 
			  left join viewactiontypeobjectpartnermessage atopm on i.personuid = atopm.objectuid 
					and atopm.objecttype=''patient'' 
					and pm.hl7partneruid = atopm.hl7partneruid 
					and atopm.sendfunction in (''MPIInsertPatient'', ''MPIUpdatePatient'')
			  LEFT Join RelHL7PartnerPatientConsent rhpc on rhpc.PatientUid = i.PersonUid 
					and p.HL7PartnerUid = rhpc.HL7PartnerUid
	  where	pm.sendfunction = ''MPIUpdatePatient'' and
			  pm.send = 1 and
			  pm.inactive = 0 and
			  p.inactive = 0 and
			  atopm.hl7actiontypeobjectuid is null and
			  ((rhpc.ConsentAgreed = 1 AND rhpc.ProtectionIndicator = ''Y'') OR (p.ConsentStatus = 1 AND (rhpc.ConsentAgreed IS NULL OR rhpc.ProtectionIndicator = ''Y'')))

  end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[Patient_RelCacheMachinePatient_Update]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[Patient_RelCacheMachinePatient_Update] 
   ON  [dbo].[Patient] 
   AFTER UPDATE
AS 
BEGIN
	SET NOCOUNT ON;
	IF UPDATE (Inactive)
	BEGIN
		UPDATE t1
			SET Action = 2
		FROM inserted AS t
			INNER JOIN RelCacheMachinePatient AS t1 ON t.Inactive <> 0
				AND t.PersonUid = t1.PatientUid
	END
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[CCDA_PatientCareManagement_Approved]'))
EXEC dbo.sp_executesql @statement = N'

-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE TRIGGER [dbo].[CCDA_PatientCareManagement_Approved] 
   ON  [dbo].[PatientCareManagement] 
   For INSERT, UPDATE AS  
IF dbo.IsCacheClient() = 0
BEGIN

	DECLARE @PartnerType varchar(25)
	DECLARE @ActionType varchar(25)
	DECLARE @PartnerUid uniqueidentifier
	DECLARE @TransmissionConfigurationUid uniqueidentifier
	DECLARE @TransmissionType varchar(25)

	Set @PartnerType =''CCM''
	Set @ActionType=''CCDA CCM''

	Select top 1 @PartnerUid=IPT.IntegrationPartnerUid 
	from ListIntegrationPartnerType IPT 
	INNER JOIN ListIntegrationPartner IP
	on IPT.IntegrationPartnerUid = IP.IntegrationPartnerUid
	where IPT.Name=@PartnerType AND IP.Inactive=0

	if @PartnerUid is null
		return

	Select top 1 @TransmissionConfigurationUid=TC.TransmissionConfigurationUid from TransmissionConfiguration TC
	where TC.ActionType=@ActionType AND TC.IntegrationPartnerUid=@PartnerUid

	if @TransmissionConfigurationUid is null
		return

	Set @TransmissionType = (select TransmissionType from TransmissionConfiguration where TransmissionConfigurationUid=@TransmissionConfigurationUid)

	DECLARE @PatientCareManagementUid UNIQUEIDENTIFIER

	DECLARE CCD_CUR CURSOR FAST_FORWARD LOCAL FOR 
	SELECT PatientCareManagementUid FROM INSERTED 

	OPEN CCD_CUR
	FETCH NEXT FROM CCD_CUR INTO @PatientCareManagementUid
	WHILE @@FETCH_STATUS =0
	BEGIN
		
		--THIS SECTION DECIDES IF A CCD SHOULD BE SENT
		IF (((SELECT ExpirationDate FROM INSERTED WHERE PatientCareManagementUid = @PatientCareManagementUid) >= GETDATE()
		OR (SELECT ExpirationDate FROM INSERTED WHERE PatientCareManagementUid = @PatientCareManagementUid) IS NULL)
		AND (SELECT EffectiveDate FROM INSERTED WHERE PatientCareManagementUid = @PatientCareManagementUid) <= GETDATE()
		AND (SELECT CareTypeUid FROM INSERTED WHERE PatientCareManagementUid = @PatientCareManagementUid) = ''14E95BCD-A9BC-41E4-9743-ECDBAD35FB6A'' 
																										--CCM Care type in ListMisc
		AND (SELECT StatusUid FROM INSERTED WHERE PatientCareManagementUid = @PatientCareManagementUid) = ''8ADCE475-B9D5-4A2C-B312-DEE14BAEB427'')
																								--uid for Accepted from ListPatientCareManagementStatus
																					
		BEGIN

			INSERT	TransmissionOutbound(TransmissionType, ForeignObjectUid, PatientUid, ProviderUid, LastModifiedByUid)
			SELECT	@TransmissionType, PatientUid, PatientUid, ProviderUid, LastModifiedByUid
			FROM	Inserted
			where	PatientCareManagementUid=@PatientCareManagementUid

		END
		NEXT_LOOP:
		FETCH NEXT FROM CCD_CUR INTO @PatientCareManagementUid
	END
	CLOSE CCD_CUR
	DEALLOCATE CCD_CUR
	SET NOCOUNT OFF

END


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[TimeSpent_PatientCareManagementLog_Approved]'))
EXEC dbo.sp_executesql @statement = N'
-- =============================================
-- Author:		<Author,,Name>
-- Create date: <Create Date,,>
-- Description:	<Description,,>
-- =============================================
CREATE TRIGGER [dbo].[TimeSpent_PatientCareManagementLog_Approved] 
   ON  [dbo].[PatientCareManagementLog] 
   FOR INSERT, UPDATE AS  
IF dbo.IsCacheClient() = 0
BEGIN

	DECLARE @PartnerType varchar(25)
	DECLARE @ActionType varchar(25)
	DECLARE @PartnerUid uniqueidentifier
	DECLARE @TransmissionConfigurationUid uniqueidentifier
	DECLARE @TransmissionType varchar(25)

	Set @PartnerType =''CCM''
	Set @ActionType=''TimeSpent''

	Select top 1 @PartnerUid=IPT.IntegrationPartnerUid 
	from ListIntegrationPartnerType IPT 
	INNER JOIN ListIntegrationPartner IP
	on IPT.IntegrationPartnerUid = IP.IntegrationPartnerUid
	where IPT.Name=@PartnerType AND IP.Inactive=0

	if @PartnerUid is null
		return

	Select top 1 @TransmissionConfigurationUid=TC.TransmissionConfigurationUid from TransmissionConfiguration TC
	where TC.ActionType=@ActionType AND TC.IntegrationPartnerUid=@PartnerUid

	if @TransmissionConfigurationUid is null
		return

	Set @TransmissionType = (select TransmissionType from TransmissionConfiguration where TransmissionConfigurationUid=@TransmissionConfigurationUid)

	DECLARE @PatientCareManagementLogUid UNIQUEIDENTIFIER

	DECLARE TimeSpent_CUR CURSOR FAST_FORWARD LOCAL FOR 
	SELECT PatientCareManagementLogUid FROM INSERTED 

	OPEN TimeSpent_CUR
	FETCH NEXT FROM TimeSpent_CUR INTO @PatientCareManagementLogUid
	WHILE @@FETCH_STATUS =0
	BEGIN
		
		--THIS SECTION DECIDES IF TIME SPENT SHOULD BE SENT
		IF((SELECT Sent FROM INSERTED WHERE PatientCareManagementLogUid = @PatientCareManagementLogUid) = 0
		AND (SELECT Received FROM INSERTED WHERE PatientCareManagementLogUid = @PatientCareManagementLogUid) = 0
		AND (SELECT IsCCM FROM INSERTED WHERE PatientCareManagementLogUid = @PatientCareManagementLogUid) = 1)
		BEGIN
			IF ((SELECT IsApproved FROM INSERTED WHERE PatientCareManagementLogUid = @PatientCareManagementLogUid) = 1)																	
			BEGIN
				DELETE TransmissionOutbound WHERE TransmissionOutboundUid in
				(SELECT TransmissionOutboundUid FROM TransmissionOutbound tmo
				JOIN INSERTED I ON  PatientCareManagementLogUid = @PatientCareManagementLogUid
				WHERE tmo.PatientUid = I.PatientUid 
				and ForeignObjectUid=I.PatientUid 
				and tmo.ProviderUid = I.ProviderUid 
				and tmo.NumberOfTransmissionAttempts=0
				and tmo.TransmissionType=@TransmissionType
				and tmo.RawMessage=@ActionType)
				
				INSERT	TransmissionOutbound(TransmissionType, RawMessage, ForeignObjectUid, PatientUid, ProviderUid, LastModifiedByUid)
				SELECT	@TransmissionType, @ActionType, PatientUid, PatientUid, ProviderUid, LastModifiedByUid
				FROM	Inserted
				where	PatientCareManagementLogUid=@PatientCareManagementLogUid
			END
			IF (SELECT IntegrationPartnerUid FROM INSERTED WHERE PatientCareManagementLogUid = @PatientCareManagementLogUid) IS NULL
			BEGIN
				UPDATE PatientCareManagementLog
				SET IntegrationPartnerUid=@PartnerUid
				WHERE PatientCareManagementLogUid = @PatientCareManagementLogUid
			END
		END
		NEXT_LOOP:
		FETCH NEXT FROM TimeSpent_CUR INTO @PatientCareManagementLogUid
	END
	CLOSE TimeSpent_CUR
	DEALLOCATE TimeSpent_CUR
	SET NOCOUNT OFF

END

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[patientcase_update]'))
EXEC dbo.sp_executesql @statement = N'
CREATE TRIGGER [dbo].[patientcase_update]
   ON  [dbo].[PatientCase] 
   FOR UPDATE
AS 
BEGIN
--This trigger is required to make the ReferredByProviderUid consistent between Cases and their Visits
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    UPDATE Visit
    SET ReferredByProviderUid = i.ReferredByProviderUid
    FROM inserted i
    WHERE IsCompleted = 0 AND Visit.PatientCaseUid = i.PatientCaseUid
    
	
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[ActiveRowDeleted_PGH]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[ActiveRowDeleted_PGH] on [dbo].[PatientCP_GoalHistory] 
    FOR DELETE
as 

set nocount on 

declare @IsCurrentHistoryRow bit = 0
declare @PatientGoalHistoryUid uniqueidentifier
declare @PatientCP_CarePlanUid uniqueidentifier
declare @GroupingUid uniqueidentifier
   
DECLARE a_cursor CURSOR FAST_FORWARD FOR 
			select PatientCP_GoalHistoryUid, IsCurrentHistoryRow, PatientCP_CarePlanUid, GroupingUid
			from deleted 
			order by [Sequence]
				
OPEN a_cursor
FETCH NEXT FROM a_cursor INTO @PatientGoalHistoryUid, @IsCurrentHistoryRow, @PatientCP_CarePlanUid, @GroupingUid

WHILE (@@fetch_status = 0)
BEGIN
	if (@IsCurrentHistoryRow = 1)
	begin
		update pgh set IsCurrentHistoryRow = 1, InactiveDate = null
			from PatientCP_GoalHistory pgh 
			where pgh.PatientCP_GoalHistoryUid = 
			(select top 1 pgh2.PatientCP_GoalHistoryUid 
				from PatientCP_GoalHistory pgh2 
				where pgh2.PatientCP_GoalHistoryUid <> @PatientGoalHistoryUid
				and pgh2.GroupingUid = @GroupingUid
				and pgh2.PatientCP_CarePlanUid = @PatientCP_CarePlanUid
				order by [Sequence] desc)
	end
	FETCH NEXT FROM a_cursor INTO @PatientGoalHistoryUid, @IsCurrentHistoryRow, @PatientCP_CarePlanUid, @GroupingUid

END -- of while...

CLOSE a_cursor
DEALLOCATE a_cursor
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[ActiveRowDeleted_PGRH]'))
EXEC dbo.sp_executesql @statement = N'
CREATE TRIGGER [dbo].[ActiveRowDeleted_PGRH] on [dbo].[PatientCP_GoalReviewHistory] 
    FOR DELETE
as 

set nocount on 

declare @IsCurrentHistoryRow bit = 0
declare @PatientCP_GoalReviewHistoryUid uniqueidentifier
declare @GroupingUid uniqueidentifier
   
DECLARE a_cursor CURSOR FAST_FORWARD FOR 
			select IsCurrentHistoryRow, PatientCP_GoalReviewHistoryUid, GroupingUid
			from deleted 
			order by [Sequence]
				
OPEN a_cursor
FETCH NEXT FROM a_cursor INTO @IsCurrentHistoryRow, @PatientCP_GoalReviewHistoryUid, @GroupingUid

WHILE (@@fetch_status = 0)
BEGIN
	if (@IsCurrentHistoryRow = 1)
	begin
		update pgrh set IsCurrentHistoryRow = 1, InactiveDate = null
			from PatientCP_GoalReviewHistory pgrh 
			where pgrh.PatientCP_GoalReviewHistoryUid = 
			(select top 1 pgrh2.PatientCP_GoalReviewHistoryUid 
				from PatientCP_GoalReviewHistory pgrh2 
				where pgrh2.PatientCP_GoalReviewHistoryUid <> @PatientCP_GoalReviewHistoryUid
				and pgrh2.GroupingUid = @GroupingUid
				order by [Sequence] desc)
	end
	FETCH NEXT FROM a_cursor INTO @IsCurrentHistoryRow, @PatientCP_GoalReviewHistoryUid, @GroupingUid

END -- of while...

CLOSE a_cursor
DEALLOCATE a_cursor

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[ActiveRowDeleted_PHCH]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[ActiveRowDeleted_PHCH] on [dbo].[PatientCP_HealthConcernHistory] 
    FOR DELETE
as 

set nocount on 

declare @IsCurrentHistoryRow bit = 0
declare @PatientHealthConcernHistoryUid uniqueidentifier
declare @PatientCP_CarePlanUid uniqueidentifier
declare @GroupingUid uniqueidentifier
   
DECLARE a_cursor CURSOR FAST_FORWARD FOR 
			select PatientCP_HealthConcernHistoryUid, IsCurrentHistoryRow, PatientCP_CarePlanUid, GroupingUid
			from deleted 
			order by [Sequence]
				
OPEN a_cursor
FETCH NEXT FROM a_cursor INTO @PatientHealthConcernHistoryUid, @IsCurrentHistoryRow, @PatientCP_CarePlanUid, @GroupingUid

WHILE (@@fetch_status = 0)
BEGIN
	if (@IsCurrentHistoryRow = 1)
	begin
		update pgh set IsCurrentHistoryRow = 1, InactiveDate = null
			from PatientCP_GoalHistory pgh 
			where pgh.PatientCP_GoalHistoryUid = 
			(select top 1 pgh2.PatientCP_GoalHistoryUid 
				from PatientCP_GoalHistory pgh2 
				where pgh2.PatientCP_GoalHistoryUid <> @PatientHealthConcernHistoryUid
				and pgh2.GroupingUid = @GroupingUid
				and pgh2.PatientCP_CarePlanUid = @PatientCP_CarePlanUid
				order by [Sequence] desc)
	end
	FETCH NEXT FROM a_cursor INTO @PatientHealthConcernHistoryUid, @IsCurrentHistoryRow, @PatientCP_CarePlanUid, @GroupingUid

END -- of while...

CLOSE a_cursor
DEALLOCATE a_cursor
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[ActiveRowDeleted_PIH]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[ActiveRowDeleted_PIH] on [dbo].[PatientCP_InterventionHistory] 
    FOR DELETE
as 

set nocount on 

declare @IsCurrentHistoryRow bit = 0
declare @PatientInterventionHistoryUid uniqueidentifier
declare @PatientCP_CarePlanUid uniqueidentifier
declare @GroupingUid uniqueidentifier
   
DECLARE a_cursor CURSOR FAST_FORWARD FOR 
			select PatientCP_InterventionHistoryUid, IsCurrentHistoryRow, PatientCP_CarePlanUid, GroupingUid
			from deleted 
			order by [Sequence]
				
OPEN a_cursor
FETCH NEXT FROM a_cursor INTO @PatientInterventionHistoryUid, @IsCurrentHistoryRow, @PatientCP_CarePlanUid, @GroupingUid

WHILE (@@fetch_status = 0)
BEGIN
	if (@IsCurrentHistoryRow = 1)
	begin
		update pih set IsCurrentHistoryRow = 1, InactiveDate = null
			from PatientCP_InterventionHistory pih 
			where pih.PatientCP_InterventionHistoryUid = 
			(select top 1 pih2.PatientCP_InterventionHistoryUid 
				from PatientCP_InterventionHistory pih2 
				where pih2.PatientCP_InterventionHistoryUid <> @PatientInterventionHistoryUid
				and pih2.GroupingUid = @GroupingUid
				and pih2.PatientCP_CarePlanUid = @PatientCP_CarePlanUid
				order by [Sequence] desc)
	end
	FETCH NEXT FROM a_cursor INTO @PatientInterventionHistoryUid, @IsCurrentHistoryRow, @PatientCP_CarePlanUid, @GroupingUid

END -- of while...

CLOSE a_cursor
DEALLOCATE a_cursor
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[patienthmrule_insert]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[patienthmrule_insert] on [dbo].[PatientHMRule] 
for insert
as
begin
if not exists  (
                select 	top 1 *
                from 	inserted 
               )
  return
  
if ( dbo.isreplicating() = 0 )
begin

	declare	@patienthmruleuid uniqueidentifier

	declare	patienthmrule_cursor cursor fast_forward for 
	select 	inserted.patienthmruleuid 
	from 	inserted 

	open 	patienthmrule_cursor

	fetch next from patienthmrule_cursor into @patienthmruleuid

	while @@fetch_status = 0
	begin
		exec createhmruleisduemessage @patienthmruleuid

		fetch next from patienthmrule_cursor into @patienthmruleuid
	end

	close patienthmrule_cursor
	deallocate patienthmrule_cursor
end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[patienthmrule_update]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[patienthmrule_update] on [dbo].[PatientHMRule] 
for update
as
begin
if not exists (	
                select 	top 1 * 
                from 	inserted 
                join 	deleted on deleted.patienthmruleuid = inserted.patienthmruleuid 
                where	inserted.isdue = 1
                and	deleted.isdue = 0
	            )
	  return

if ( dbo.isreplicating() = 0 )
begin
	declare	@patienthmruleuid uniqueidentifier

	declare	patienthmrule_cursor cursor fast_forward for 
	select 	inserted.patienthmruleuid 
	from 	inserted 
	join 	deleted on deleted.patienthmruleuid = inserted.patienthmruleuid 
	where	inserted.isdue = 1
	and	deleted.isdue = 0

	open 	patienthmrule_cursor

	fetch next from patienthmrule_cursor into @patienthmruleuid

	while @@fetch_status = 0
	begin
		exec createhmruleisduemessage @patienthmruleuid

		fetch next from patienthmrule_cursor into @patienthmruleuid
	end

	close patienthmrule_cursor
	deallocate patienthmrule_cursor
end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[ActiveRowDeleted_PPH]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[ActiveRowDeleted_PPH] on [dbo].[PatientProcedureHistory] 
    FOR DELETE
as 

set nocount on 

declare @IsCurrentHistoryRow bit = 0
declare @PatientProcedureHistoryUid uniqueidentifier
declare @PatientUid uniqueidentifier
declare @GroupingUid uniqueidentifier
   
DECLARE a_cursor CURSOR FAST_FORWARD FOR 
			select PatientProcedureHistoryUid, IsCurrentHistoryRow, PatientUid, GroupingUid
			from deleted 
			order by [Sequence]
				
OPEN a_cursor
FETCH NEXT FROM a_cursor INTO @PatientProcedureHistoryUid, @IsCurrentHistoryRow, @PatientUid, @GroupingUid

WHILE (@@fetch_status = 0)
BEGIN
	if (@IsCurrentHistoryRow = 1)
	begin
		update pph set IsCurrentHistoryRow = 1, InactiveDate = null
			from PatientProcedureHistory pph 
			where pph.PatientProcedureHistoryUid = 
			(select top 1 pph2.PatientProcedureHistoryUid 
				from PatientProcedureHistory pph2 
				where pph2.PatientProcedureHistoryUid <> @PatientProcedureHistoryUid
				and pph2.GroupingUid = @GroupingUid
				and pph2.PatientUid = @PatientUid
				order by [Sequence] desc)
	end
	FETCH NEXT FROM a_cursor INTO @PatientProcedureHistoryUid, @IsCurrentHistoryRow, @PatientUid, @GroupingUid

END -- of while...

CLOSE a_cursor
DEALLOCATE a_cursor
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[EKOS_Guarantor_person_update]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[EKOS_Guarantor_person_update] on [dbo].[Person] for INSERT, UPDATE as
begin
IF NOT EXISTS (SELECT * 
				 FROM TransmissionConfiguration tc WITH(NOLOCK)
                 INNER JOIN ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
			     WHERE tc.TransmissionType = ''EKOS'' AND
					   lip.Inactive = 0 )
 RETURN;

  if not exists ( select 1  from inserted )
    return

  if dbo.IsReplicating() = 0
  begin

 
		insert    TransmissionOutbound(TransmissionType, ForeignObjectUid, RawMessage,lastmodifiedbyuid, LastModifiedDate)
		select    distinct ''EKOS'', arp.AccountResponsiblePartyUid, ''iMedica.Prm.BusinessObject.AccountResponsibleParty'', i.lastmodifiedbyuid, GETUTCDATE()
		from      TransmissionConfiguration tc WITH(NOLOCK)
        inner join ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
		cross join inserted i 
		inner join AccountResponsibleParty arp WITH(NOLOCK) on i.personuid = arp.personuid  
	    where     tc.TransmissionType = ''EKOS'' and
        lip.Inactive = 0 
  


 end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[EKOS_person_insert]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[EKOS_person_insert] on [dbo].[Person] for insert as
begin
  if not exists ( select top 1 * from inserted )
    return

  if dbo.IsReplicating() = 0
  begin

		insert    TransmissionOutbound(TransmissionType, ForeignObjectUid, RawMessage, PatientUid, lastmodifiedbyuid, LastModifiedDate)
		select    distinct ''EKOS'', i.personuid, ''iMedica.Prm.BusinessObject.Patient'', i.personuid, i.lastmodifiedbyuid, GETUTCDATE()
		from      TransmissionConfiguration tc WITH(NOLOCK)
        inner join ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
		cross join inserted i 
		inner join patient pat WITH(NOLOCK) on i.personuid = pat.personuid  
	    where     tc.TransmissionType = ''EKOS'' and
        lip.Inactive = 0 

  end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[EKOS_person_update]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[EKOS_person_update] on [dbo].[Person] for update as
begin
  if not exists ( select top 1 * from inserted )
    return

  if dbo.IsReplicating() = 0
  begin

		insert    TransmissionOutbound(TransmissionType, ForeignObjectUid, RawMessage, PatientUid, lastmodifiedbyuid, LastModifiedDate)
		select    distinct ''EKOS'', i.personuid, ''iMedica.Prm.BusinessObject.Patient'', i.personuid, i.lastmodifiedbyuid, GETUTCDATE()
		from      TransmissionConfiguration tc WITH(NOLOCK)
        inner join ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
		cross join inserted i 
		inner join patient pat WITH(NOLOCK) on i.personuid = pat.personuid  
	    where     tc.TransmissionType = ''EKOS'' and
        lip.Inactive = 0 

  end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[EKOS_Provider_person_update]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[EKOS_Provider_person_update] on [dbo].[Person] for UPDATE as
BEGIN

IF NOT EXISTS (SELECT * 
				 FROM TransmissionConfiguration tc WITH(NOLOCK)
                 INNER JOIN ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
			     WHERE tc.TransmissionType = ''EKOS'' AND
					   lip.Inactive = 0 )
  RETURN;

  IF NOT EXISTS ( select 1  from inserted )
    RETURN;

  if dbo.IsReplicating() = 0
  begin

		insert    TransmissionOutbound(TransmissionType, ForeignObjectUid, RawMessage, ProviderUid, lastmodifiedbyuid, LastModifiedDate)
		select    distinct ''EKOS'', i.personuid, ''iMedica.Prm.BusinessObject.Provider'', i.personuid, i.lastmodifiedbyuid, GETUTCDATE()
		from      TransmissionConfiguration tc WITH(NOLOCK)
        inner join ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
		cross join inserted i 
		inner join Provider p WITH(NOLOCK) on i.personuid = p.personuid  
		inner join UserPRM up WITH(NOLOCK) on p.PersonUid = up.PersonUid 
	    where     tc.TransmissionType = ''EKOS'' and
        lip.Inactive = 0 

  end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[interface_person_insert]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[interface_person_insert] on [dbo].[Person] for insert as
begin
  if not exists ( select top 1 * from inserted )
    return

  if dbo.IsReplicating() = 0
  begin

	   insert hl7actiontypeobject(hl7partnermessageuid, actiontype, objectuid, objecttype, lastmodifiedbyuid)  
	   select pm.hl7partnermessageuid, pm.sendfunction, i.personuid, ''Patient'', i.lastmodifiedbyuid  
	   from hl7partnermessage pm inner join hl7partner p on pm.hl7partneruid = p.hl7partneruid  
	     cross join inserted i inner join patient pat on i.personuid = pat.personuid  
		  left join viewactiontypeobjectpartnermessage atopm on i.personuid = atopm.objectuid and atopm.objecttype=''patient'' and pm.hl7partneruid = atopm.hl7partneruid and atopm.sendfunction in (''insertpatient'', ''updatepatient'')
	   where pm.sendfunction = ''insertpatient'' and  
	     pm.send = 1 and  
	     pm.inactive = 0 and  
	     p.inactive = 0 and  
	     atopm.hl7actiontypeobjectuid is null

  end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[interface_person_update]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[interface_person_update] on [dbo].[Person] for update as
begin
  if not exists ( select top 1 * from inserted )
    return

  if dbo.IsReplicating() = 0
  begin

	  insert	hl7actiontypeobject(hl7partnermessageuid, actiontype, objectuid, objecttype, lastmodifiedbyuid)  
	  select	pm.hl7partnermessageuid, pm.sendfunction, i.personuid, ''Patient'', i.lastmodifiedbyuid  
	  from	hl7partnermessage pm inner join hl7partner p on pm.hl7partneruid = p.hl7partneruid  
			  cross join inserted i inner join patient pat on i.personuid = pat.personuid  
			  left join viewactiontypeobjectpartnermessage atopm on i.personuid = atopm.objectuid and atopm.objecttype=''patient'' and pm.hl7partneruid = atopm.hl7partneruid and atopm.sendfunction in (''insertpatient'', ''updatepatient'')
	  where	pm.sendfunction = ''updatepatient'' and  
			  pm.send = 1 and  
			  pm.inactive = 0 and  
			  p.inactive = 0 and  
			  atopm.hl7actiontypeobjectuid is null

  end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[MPI_interface_person_insert]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[MPI_interface_person_insert] on [dbo].[Person] for insert as
begin
  if not exists ( select top 1 * from inserted )
    return

  if dbo.IsReplicating() = 0
  begin

	   insert hl7actiontypeobject(hl7partnermessageuid, actiontype, objectuid, objecttype, lastmodifiedbyuid)  
	   select pm.hl7partnermessageuid, ''InsertPatient'', i.personuid, ''Patient'', i.lastmodifiedbyuid  
	   from hl7partnermessage pm inner join hl7partner p on pm.hl7partneruid = p.hl7partneruid  
	      cross join inserted i inner join patient pat on i.personuid = pat.personuid  
		  left join viewactiontypeobjectpartnermessage atopm on i.personuid = atopm.objectuid 
				and atopm.objecttype=''patient'' 
				and pm.hl7partneruid = atopm.hl7partneruid 
				and atopm.sendfunction in (''MPIInsertPatient'', ''MPIUpdatePatient'')
		  LEFT Join RelHL7PartnerPatientConsent rhpc on rhpc.PatientUid = pat.PersonUid 
				and p.HL7PartnerUid = rhpc.HL7PartnerUid
	   where pm.sendfunction = ''MPIInsertPatient'' and  
	     pm.send = 1 and  
	     pm.inactive = 0 and  
	     p.inactive = 0 and  
	     atopm.hl7actiontypeobjectuid is null and
		 ((rhpc.ConsentAgreed = 1 AND rhpc.ProtectionIndicator = ''Y'') OR (p.ConsentStatus = 1 AND (rhpc.ConsentAgreed IS NULL OR rhpc.ProtectionIndicator = ''Y'')))
  end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[MPI_interface_person_update]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[MPI_interface_person_update] on [dbo].[Person] for update as
begin
  if not exists ( select top 1 * from inserted )
    return

  if dbo.IsReplicating() = 0
  begin

	  insert	hl7actiontypeobject(hl7partnermessageuid, actiontype, objectuid, objecttype, lastmodifiedbyuid)  
	  select	pm.hl7partnermessageuid, ''UpdatePatient'', i.personuid, ''Patient'', i.lastmodifiedbyuid  
	  from	hl7partnermessage pm inner join hl7partner p on pm.hl7partneruid = p.hl7partneruid  
			  cross join inserted i inner join patient pat on i.personuid = pat.personuid  
			  left join viewactiontypeobjectpartnermessage atopm on i.personuid = atopm.objectuid 
					and atopm.objecttype=''patient'' 
					and pm.hl7partneruid = atopm.hl7partneruid 
					and atopm.sendfunction in (''MPIInsertPatient'', ''MPIUpdatePatient'')
			  LEFT Join RelHL7PartnerPatientConsent rhpc on rhpc.PatientUid = pat.PersonUid 
					and p.HL7PartnerUid = rhpc.HL7PartnerUid
	  where	pm.sendfunction = ''MPIUpdatePatient'' and  
			  pm.send = 1 and  
			  pm.inactive = 0 and  
			  p.inactive = 0 and  
			  atopm.hl7actiontypeobjectuid is null and
			  ((rhpc.ConsentAgreed = 1 AND rhpc.ProtectionIndicator = ''Y'') OR (p.ConsentStatus = 1 AND (rhpc.ConsentAgreed IS NULL OR rhpc.ProtectionIndicator = ''Y'')))

  end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[Person_AppointmentConnect_ClearOnUpdate]'))
EXEC dbo.sp_executesql @statement = N'CREATE   Trigger [dbo].[Person_AppointmentConnect_ClearOnUpdate] on [dbo].[Person] after update
as
IF dbo.IsReplicating() <> 0
RETURN; 

IF (SELECT Inactive FROM ListIntegrationPartner WHERE Name = ''CGM Connection'' OR IntegrationPartnerUid = ''E1D0A4E0-DB48-4105-8E22-4A3577507364'')= 1
	RETURN;

begin

	-- resend modified appointments to connect again
	DELETE FROM RelAppointmentConnect
		WHERE AppointmentUid IN 
			(SELECT AppointmentUid 
				FROM Appointment
				WHERE PatientUid IN (SELECT PersonUid FROM deleted)
			);

	-- update communication preferences
	UPDATE CP
		SET CP.EmailAddress = NULL
		FROM CommunicationPreference CP
			INNER JOIN deleted D ON CP.PersonUid = D.PersonUid
		WHERE D.Email1 = CP.EmailAddress OR D.Email2 = CP.EmailAddress;
	UPDATE CP
		SET CP.SmsNumber = NULL
		FROM CommunicationPreference CP
			INNER JOIN deleted D ON CP.PersonUid = D.PersonUid
		WHERE CAST(D.Phone1 AS VARCHAR(MAX)) LIKE CP.SmsNumber OR CAST(D.Phone2 AS VARCHAR(MAX)) LIKE CP.SmsNumber
			OR CAST(D.Phone3 AS VARCHAR(MAX)) LIKE CP.SmsNumber OR CAST(D.Phone4 AS VARCHAR(MAX)) LIKE CP.SmsNumber;
	UPDATE CP
		SET CP.VoiceNumber = NULL
		FROM CommunicationPreference CP
			INNER JOIN deleted D ON CP.PersonUid = D.PersonUid
		WHERE CAST(D.Phone1 AS VARCHAR(MAX)) LIKE CP.VoiceNumber OR CAST(D.Phone2 AS VARCHAR(MAX)) LIKE CP.VoiceNumber
			OR CAST(D.Phone3 AS VARCHAR(MAX)) LIKE CP.VoiceNumber OR CAST(D.Phone4 AS VARCHAR(MAX)) LIKE CP.VoiceNumber;
			
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[Person_Computed_Insert]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[Person_Computed_Insert] ON [dbo].[Person] FOR INSERT AS
BEGIN
	SET NOCOUNT ON;
  IF   UPDATE(Address1)
    OR UPDATE(Phone1)
    OR UPDATE(Phone2)
    OR UPDATE(Phone3)
    OR UPDATE(Phone4)
    OR UPDATE(Computed_Address1_Address1)
    OR UPDATE(Computed_Address1_Address2)
    OR UPDATE(Computed_Address1_City)
    OR UPDATE(Computed_Address1_State)
    OR UPDATE(Computed_Address1_Zip)
    OR UPDATE(Computed_Phone1_PhoneNumber)
    OR UPDATE(Computed_Phone1_PhoneType)
    OR UPDATE(Computed_Phone2_PhoneNumber)
    OR UPDATE(Computed_Phone2_PhoneType)
    OR UPDATE(Computed_Phone3_PhoneNumber)
    OR UPDATE(Computed_Phone3_PhoneType)
    OR UPDATE(Computed_Phone4_PhoneNumber)
    OR UPDATE(Computed_Phone4_PhoneType)
    UPDATE p
    SET	Computed_Address1_Address1= i.Address1.value(''(/Address/Address1)[1]'',  ''varchar(100)''),
		    Computed_Address1_Address2= i.Address1.value(''(/Address/Address2)[1]'',  ''varchar(100)''),
		    Computed_Address1_City    = i.Address1.value(''(/Address/City)[1]'',      ''varchar(100)''),
		    Computed_Address1_State   = i.Address1.value(''(/Address/State)[1]'',     ''varchar(100)''),
		    Computed_Address1_Zip     = i.Address1.value(''(/Address/Zip)[1]'',       ''varchar(100)''),
		    Computed_Phone1_PhoneNumber = i.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''varchar(50)''),
		    Computed_Phone1_PhoneType   = i.Phone1.value(''(/Phone/PhoneType)[1]'',   ''varchar(100)''),
		    Computed_Phone2_PhoneNumber = i.Phone2.value(''(/Phone/PhoneNumber)[1]'', ''varchar(50)''),
		    Computed_Phone2_PhoneType   = i.Phone2.value(''(/Phone/PhoneType)[1]'',   ''varchar(100)''),
		    Computed_Phone3_PhoneNumber = i.Phone3.value(''(/Phone/PhoneNumber)[1]'', ''varchar(50)''),
		    Computed_Phone3_PhoneType   = i.Phone3.value(''(/Phone/PhoneType)[1]'',   ''varchar(100)''),
		    Computed_Phone4_PhoneNumber = i.Phone4.value(''(/Phone/PhoneNumber)[1]'', ''varchar(50)''),
		    Computed_Phone4_PhoneType   = i.Phone4.value(''(/Phone/PhoneType)[1]'',   ''varchar(100)'')
    FROM	inserted i INNER JOIN Person p ON i.PersonUid = p.PersonUid
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[Person_Computed_Update]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[Person_Computed_Update] on [dbo].[Person] for UPDATE AS 
BEGIN		
	SET NOCOUNT ON;
  IF   UPDATE(Address1)
    OR UPDATE(Phone1)
    OR UPDATE(Phone2)
    OR UPDATE(Phone3)
    OR UPDATE(Phone4)
    OR UPDATE(Computed_Address1_Address1)
    OR UPDATE(Computed_Address1_Address2)
    OR UPDATE(Computed_Address1_City)
    OR UPDATE(Computed_Address1_State)
    OR UPDATE(Computed_Address1_Zip)
    OR UPDATE(Computed_Phone1_PhoneNumber)
    OR UPDATE(Computed_Phone1_PhoneType)
    OR UPDATE(Computed_Phone2_PhoneNumber)
    OR UPDATE(Computed_Phone2_PhoneType)
    OR UPDATE(Computed_Phone3_PhoneNumber)
    OR UPDATE(Computed_Phone3_PhoneType)
    OR UPDATE(Computed_Phone4_PhoneNumber)
    OR UPDATE(Computed_Phone4_PhoneType)
	BEGIN
    UPDATE p
    SET	Computed_Address1_Address1= i.Address1.value(''(/Address/Address1)[1]'',  ''varchar(100)''),
		    Computed_Address1_Address2= i.Address1.value(''(/Address/Address2)[1]'',  ''varchar(100)''),
		    Computed_Address1_City    = i.Address1.value(''(/Address/City)[1]'',      ''varchar(100)''),
		    Computed_Address1_State   = i.Address1.value(''(/Address/State)[1]'',     ''varchar(100)''),
		    Computed_Address1_Zip     = i.Address1.value(''(/Address/Zip)[1]'',       ''varchar(100)''),
		    Computed_Phone1_PhoneNumber = i.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''varchar(50)''),
		    Computed_Phone1_PhoneType   = i.Phone1.value(''(/Phone/PhoneType)[1]'',   ''varchar(100)''),
		    Computed_Phone2_PhoneNumber = i.Phone2.value(''(/Phone/PhoneNumber)[1]'', ''varchar(50)''),
		    Computed_Phone2_PhoneType   = i.Phone2.value(''(/Phone/PhoneType)[1]'',   ''varchar(100)''),
		    Computed_Phone3_PhoneNumber = i.Phone3.value(''(/Phone/PhoneNumber)[1]'', ''varchar(50)''),
		    Computed_Phone3_PhoneType   = i.Phone3.value(''(/Phone/PhoneType)[1]'',   ''varchar(100)''),
		    Computed_Phone4_PhoneNumber = i.Phone4.value(''(/Phone/PhoneNumber)[1]'', ''varchar(50)''),
		    Computed_Phone4_PhoneType   = i.Phone4.value(''(/Phone/PhoneType)[1]'',   ''varchar(100)'')
    FROM	inserted i INNER JOIN Person p ON i.PersonUid = p.PersonUid;

	END

  IF UPDATE(Phone1)
    /* Update Future Appointment Phone Numbers */		
    /* #8750 Do not update Appointment.LastModifiedDate */
    UPDATE	a
    SET		Phone = i.Phone1
    FROM	inserted i INNER JOIN deleted d ON i.PersonUid = d.PersonUid AND ISNULL(CAST(i.Phone1 AS VARCHAR(200)), '''') <> ISNULL(CAST(d.Phone1 AS VARCHAR(200)), '''')
	    INNER JOIN Appointment a ON i.PersonUid = a.PatientUid
    WHERE	CAST(a.StartDateTime AS DATE) >= CAST(GETUTCDATE() AS DATE) AND
		  ISNULL(CAST(a.Phone AS VARCHAR(200)), '''') = ISNULL(CAST(d.Phone1 AS VARCHAR(200)), '''')
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[Person_RelCacheMachinePatient_Update]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[Person_RelCacheMachinePatient_Update] 
   ON  [dbo].[Person] 
   AFTER UPDATE
AS 
BEGIN
	SET NOCOUNT ON;
	IF UPDATE (Inactive)
	BEGIN
		UPDATE t1
			SET Action = 2
		FROM inserted AS t
			INNER JOIN RelCacheMachinePatient AS t1 ON t.Inactive <> 0
				AND t.PersonUid = t1.PatientUid
	END
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[EKOS_personinsuranceplan_insertupdate]'))
EXEC dbo.sp_executesql @statement = N'

CREATE trigger [dbo].[EKOS_personinsuranceplan_insertupdate] on [dbo].[PersonInsurancePlan] for insert, update as
begin
      if not exists ( select top 1 * from inserted )
            return

      if dbo.IsReplicating() = 0
      begin
      
         DECLARE @SendAllAccounts BIT
       SET @SendAllAccounts = NULL
			
			
       select @SendAllAccounts = boolvalue
       from ListProductParameter 
       where ParameterName = ''SendAllAccountsNotJustMain'' 

              insert    TransmissionOutbound(TransmissionType, ForeignObjectUid, RawMessage, PatientUid, lastmodifiedbyuid, LastModifiedDate)
              select    distinct ''EKOS'', a.personuid, ''iMedica.Prm.BusinessObject.Patient'', a.personuid, i.lastmodifiedbyuid, GETUTCDATE()
              from      TransmissionConfiguration tc WITH(NOLOCK)
                        inner join ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
                        cross join inserted i 
						join accountinsurance ai WITH(NOLOCK) on i.personinsuranceplanuid = ai.personinsuranceplanuid
                        join accountperiod ap WITH(NOLOCK) on ai.accountperioduid = ap.accountperioduid
                        join account a WITH(NOLOCK) on ap.accountuid = a.accountuid and (a.ismain = 1 or @SendAllAccounts = 1)					
              where     tc.TransmissionType = ''EKOS'' and
                        lip.Inactive = 0 
	end
end

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[interface_personinsuranceplan_delete]'))
EXEC dbo.sp_executesql @statement = N'
CREATE trigger [dbo].[interface_personinsuranceplan_delete] on [dbo].[PersonInsurancePlan] for delete as
begin
      if not exists ( select top 1 * from deleted )
            return

      if dbo.IsReplicating() = 0
      begin	
      
         DECLARE @SendAllAccounts BIT
       SET @SendAllAccounts = NULL
			
			
       select @SendAllAccounts = boolvalue
       from ListProductParameter 
       where ParameterName = ''SendAllAccountsNotJustMain'' 

              insert    hl7actiontypeobject(hl7partnermessageuid, actiontype, objectuid, objecttype, lastmodifiedbyuid)
              select    distinct pm.hl7partnermessageuid, pm.sendfunction, a.personuid, ''Patient'', d.lastmodifiedbyuid
              from      hl7partnermessage pm 
                        inner join hl7partner p on pm.hl7partneruid = p.hl7partneruid
                        cross join deleted d 
						join accountinsurance ai on d.personinsuranceplanuid = ai.personinsuranceplanuid
                        join accountperiod ap on ai.accountperioduid = ap.accountperioduid
                        join account a on ap.accountuid = a.accountuid and (a.ismain = 1 or @SendAllAccounts = 1)				
                        left join hl7actiontypeobject ato
									on ato.objecttype=''patient'' 
                                    and pm.hl7partnermessageuid = ato.hl7partnermessageuid
									and ato.objectuid = a.personuid                                            
              where     pm.sendfunction = ''updatepatient'' and
                          pm.send = 1 and
                          pm.inactive = 0 and
                          p.inactive = 0 and
                          (ato.hl7actiontypeobjectuid is null or ato.processingerror = 1) -- allow creation of a new row 
                                                                        -- if there is an existing row that has errored out

      end
end

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[interface_personinsuranceplan_insertupdate]'))
EXEC dbo.sp_executesql @statement = N'
CREATE trigger [dbo].[interface_personinsuranceplan_insertupdate] on [dbo].[PersonInsurancePlan] for insert, update as
begin
      if not exists ( select top 1 * from inserted )
            return

      if dbo.IsReplicating() = 0
      begin
      
         DECLARE @SendAllAccounts BIT
       SET @SendAllAccounts = NULL
			
			
       select @SendAllAccounts = boolvalue
       from ListProductParameter 
       where ParameterName = ''SendAllAccountsNotJustMain'' 

              insert    hl7actiontypeobject(hl7partnermessageuid, actiontype, objectuid, objecttype, lastmodifiedbyuid)
              select    distinct pm.hl7partnermessageuid, pm.sendfunction, a.personuid, ''Patient'', i.lastmodifiedbyuid
              from      hl7partnermessage pm 
                        inner join hl7partner p on pm.hl7partneruid = p.hl7partneruid
                        cross join inserted i 
						join accountinsurance ai on i.personinsuranceplanuid = ai.personinsuranceplanuid
                        join accountperiod ap on ai.accountperioduid = ap.accountperioduid
                        join account a on ap.accountuid = a.accountuid and (a.ismain = 1 or @SendAllAccounts = 1)					
                        left join hl7actiontypeobject ato
									on ato.objecttype=''patient'' 
                                    and pm.hl7partnermessageuid = ato.hl7partnermessageuid
									and ato.objectuid = a.personuid
              where     pm.sendfunction = ''updatepatient'' and
                          pm.send = 1 and
                          pm.inactive = 0 and
                          p.inactive = 0 and
                          (ato.hl7actiontypeobjectuid is null or ato.processingerror = 1) -- allow creation of a new row 
                                                                    -- if there is an existing row that has errored out
	end
end

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[PersonInsurancePlan_insertupdate]'))
EXEC dbo.sp_executesql @statement = N'
CREATE trigger [dbo].[PersonInsurancePlan_insertupdate] on [dbo].[PersonInsurancePlan] for insert, update as
BEGIN
		UPDATE	PIPCHILD
		SET		PIPCHILD.CopayPrimary = PIPPARENT.CopayPrimary,
				PIPCHILD.CopaySpecialist = PIPPARENT.CopaySpecialist,
				PIPCHILD.CopayOther = PIPPARENT.CopayOther,
				PIPCHILD.AuthorizeAssignment = PIPPARENT.AuthorizeAssignment,
				PIPCHILD.PlanMemberID = PIPPARENT.PlanMemberID,
				PIPCHILD.PlanGroupID = PIPPARENT.PlanGroupID,
				PIPCHILD.EffectiveDate = PIPPARENT.EffectiveDate,
				PIPCHILD.ExpirationDate = PIPPARENT.ExpirationDate,
				PIPCHILD.EligibilityStatusUid = PIPPARENT.EligibilityStatusUid,
				PIPCHILD.EligibilityCoverageLevelUid = PIPPARENT.EligibilityCoverageLevelUid,
				PIPCHILD.InNetworkCoinsurance = PIPPARENT.InNetworkCoinsurance,
				PIPCHILD.InNetworkDeductible = PIPPARENT.InNetworkDeductible,
				PIPCHILD.InNetworkRemaining = PIPPARENT.InNetworkRemaining,
				PIPCHILD.InNetworkMet = PIPPARENT.InNetworkMet,
				PIPCHILD.OutNetworkCoinsurance = PIPPARENT.OutNetworkCoinsurance,
				PIPCHILD.OutNetworkDeductible = PIPPARENT.OutNetworkDeductible,
				PIPCHILD.OutNetworkRemaining = PIPPARENT.OutNetworkRemaining,
				PIPCHILD.OutNetworkMet = PIPPARENT.OutNetworkMet,
				PIPCHILD.EligibilityEffectiveDate = PIPPARENT.EligibilityEffectiveDate,
				PIPCHILD.EligibilityExpirationDate = PIPPARENT.EligibilityExpirationDate,
				PIPCHILD.EligibilityVerificationDateTime = PIPPARENT.EligibilityVerificationDateTime,
				PIPCHILD.EligibilityNotes = PIPPARENT.EligibilityNotes,
				PIPCHILD.LastModifiedDate = PIPPARENT.LastModifiedDate,
				PIPCHILD.LastModifiedByUid = PIPPARENT.LastModifiedByUid
		FROM	AccountInsurance AIPARENT 
				INNER JOIN AccountInsurance AICHILD ON AIPARENT.AccountInsuranceUid = AICHILD.ParentAccountInsuranceUid
				INNER JOIN inserted PIPPARENT ON AIPARENT.PersonInsurancePlanUid = PIPPARENT.PersonInsurancePlanUid
				INNER JOIN PersonInsurancePlan PIPCHILD ON AICHILD.PersonInsurancePlanUid = PIPCHILD.PersonInsurancePlanUid				
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[personinsuranceplan_superbillaggregate_delete]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[personinsuranceplan_superbillaggregate_delete] on [dbo].[PersonInsurancePlan] after delete as
begin
	set nocount on;

	update	sa
	set		primaryinsuranceplanuid = pipp.insuranceplanuid,
			currentinsuranceplanuid = pipc.insuranceplanuid
	from	deleted del inner join accountinsurance ai on del.personinsuranceplanuid = ai.personinsuranceplanuid
			inner join superbillaggregate sa on ai.accountperioduid = sa.accountperioduid
			inner join superbill s on sa.superbilluid = s.superbilluid
			left join accountperiod ap on sa.accountperioduid = ap.accountperioduid
			left join accountinsurance aip on ap.accountperioduid = aip.accountperioduid and aip.displayorder = 1
			left join personinsuranceplan pipp on aip.personinsuranceplanuid = pipp.personinsuranceplanuid
			left join accountinsurance aic on ap.accountperioduid = aic.accountperioduid and (aic.displayorder = sa.liabilityowner and sa.liabilityowner > 0 or aic.displayorder = 1 and sa.liabilityowner = 0)
			left join personinsuranceplan pipc on aic.personinsuranceplanuid = pipc.personinsuranceplanuid
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[PersonInsurancePlan_SuperbillAggregate_Insert_Update]'))
EXEC dbo.sp_executesql @statement = N'
CREATE TRIGGER [dbo].[PersonInsurancePlan_SuperbillAggregate_Insert_Update] ON [dbo].[PersonInsurancePlan] AFTER INSERT, UPDATE AS
BEGIN
	set nocount on;

	IF NOT (UPDATE(insuranceplanuid)) -- only relevent if insuranceplanuid changed
		RETURN;

	UPDATE	sa 
	SET		primaryinsuranceplanuid = pipp.insuranceplanuid,
			currentinsuranceplanuid = pipc.insuranceplanuid
	FROM	inserted ins INNER JOIN accountinsurance ai ON ins.personinsuranceplanuid = ai.personinsuranceplanuid
			INNER JOIN superbillaggregate sa ON ai.accountperioduid = sa.accountperioduid
			INNER JOIN superbill s ON sa.superbilluid = s.superbilluid
			LEFT JOIN accountperiod ap ON sa.accountperioduid = ap.accountperioduid
			LEFT JOIN accountinsurance aip ON ap.accountperioduid = aip.accountperioduid and aip.displayorder = 1
			LEFT JOIN personinsuranceplan pipp ON aip.personinsuranceplanuid = pipp.personinsuranceplanuid
			LEFT JOIN accountinsurance aic ON ap.accountperioduid = aic.accountperioduid and (aic.displayorder = sa.liabilityowner and sa.liabilityowner > 0 or aic.displayorder = 1 and sa.liabilityowner = 0)
			LEFT JOIN personinsuranceplan pipc ON aic.personinsuranceplanuid = pipc.personinsuranceplanuid
END



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[PQRIDenominator_ScheduledPQRIUpdate_AfterUpdate]'))
EXEC dbo.sp_executesql @statement = N'-- ==========================================================================
-- author:		cmcfadden
-- create date: 01/28/2009
-- description:	this trigger will insert rows into scheduledpqriupdate table
--				for each patient when a pqri denominator is changed or inserted.
-- ===========================================================================
CREATE trigger [dbo].[PQRIDenominator_ScheduledPQRIUpdate_AfterUpdate] on [dbo].[PQRIDenominator] 
after update, insert
as
begin
	set nocount on;

	insert into scheduledpqriupdate (patientuid, pqrigroupuid, visituid)
	select distinct   a.personuid, ic.pqrigroupuid, v.visituid
	from              account a inner join accountperiod ap on a.accountuid = ap.accountuid
							inner join patient pat on a.personuid = pat.personuid
							inner join accountinsurance ai on ai.accountperioduid = ap.accountperioduid
							inner join personinsuranceplan pip on pip.personinsuranceplanuid = ai.personinsuranceplanuid
							inner join insuranceplan ip on pip.insuranceplanuid = ip.insuranceplanuid
							inner join insurancecarrier ic on ip.insurancecarrieruid = ic.corporationuid
							inner join relpqrimeasurepqrigroup rel on ic.pqrigroupuid = rel.pqrigroupuid
							inner join listpqrimeasure m on rel.pqrimeasureuid = m.pqrimeasureuid
							inner join inserted denominator on denominator.pqrimeasureuid = m.pqrimeasureuid
							inner join visit v on v.accountuid = a.accountuid
							left outer join scheduledpqriupdate s on s.patientuid = a.personuid and
										s.pqrigroupuid = ic.pqrigroupuid
							left outer join pqrihistory his on his.pqrimeasureuid = m.pqrimeasureuid and
									v.visituid = his.visituid
	where             not ic.pqrigroupuid is null and
							m.inactive = 0 and
							s.patientuid is null and
							his.pqrihistoryuid is null and
							(v.visitdate >= m.effectivedate or m.effectivedate is null) and
							(v.visitdate <= m.expirationdate or m.expirationdate is null) and
							(v.visitdate >= ap.effectivedate or ap.effectivedate is null) and
							(v.visitdate <= ap.expirationdate or ap.expirationdate is null)
       
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[pqrihistory_afterupdate]'))
EXEC dbo.sp_executesql @statement = N'-- ==========================================================================
-- author:     mcfadden
-- create date: 01/07/2009
-- description:   set both fks pqrinumeratoruid and qualificationexpirationdate
--          to null when visitspuid is updated to null
-- ===========================================================================
CREATE trigger [dbo].[pqrihistory_afterupdate] on [dbo].[PQRIHistory]
after update
as
begin
   set nocount on;
   update pqrihistory set qualificationexpirationdate = null, pqrinumeratoruid = null,
		LastModifiedDate = GETUTCDATE()
   where pqrihistory.pqrihistoryuid in
    (select d.pqrihistoryuid
      from inserted d
      left join dbo.visitprocedure vp on vp.visitprocedureuid = d.visitprocedureuid
      where (d.visitprocedureuid is null or vp.isperformed = 0) and (d.pqrinumeratoruid is not null or d.qualificationexpirationdate is not null))
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[EKOS_Provider_Delete]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[EKOS_Provider_Delete] ON [dbo].[Provider]   
FOR DELETE  

AS  
BEGIN  

IF @@ROWCOUNT = 0  
RETURN  

 IF dbo.IsCacheClient() = 0  
 BEGIN  
  SET NOCOUNT ON   
    
  if not exists (select * 
				 from TransmissionConfiguration tc
                 inner join ListIntegrationPartner lip on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
			     where tc.TransmissionType = ''EKOS'' and
					   lip.Inactive = 0 )
	RETURN;

	IF NOT  EXISTS (SELECT 1 FROM deleted)

	RETURN;

	BEGIN

       insert    TransmissionOutbound(TransmissionType, Description, ForeignObjectUid, RawMessage, ProviderUid, lastmodifiedbyuid, LastModifiedDate)
		select    distinct ''EKOS'',''PROVIDERDELETE'', d.personuid, ''iMedica.Prm.BusinessObject.Provider'', d.personuid, d.lastmodifiedbyuid, GETUTCDATE()
		from      TransmissionConfiguration tc
        inner join ListIntegrationPartner lip on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
				 cross join deleted d
			     where tc.TransmissionType = ''EKOS'' and
					   lip.Inactive = 0 

      END  

 END 
  
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[EKOS_provider_insert]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[EKOS_provider_insert] on [dbo].[Provider] for insert as
BEGIN

IF NOT EXISTS (SELECT * 
				 FROM TransmissionConfiguration tc
                 INNER JOIN ListIntegrationPartner lip on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
			     WHERE tc.TransmissionType = ''EKOS'' AND
					   lip.Inactive = 0 )
  RETURN;

 IF NOT EXISTS ( select 1 from inserted )
     RETURN;

  if dbo.IsReplicating() = 0
  begin

		insert    TransmissionOutbound(TransmissionType, ForeignObjectUid, RawMessage, ProviderUid, lastmodifiedbyuid, LastModifiedDate)
		select    distinct ''EKOS'', i.personuid, ''iMedica.Prm.BusinessObject.Provider'', i.personuid, i.lastmodifiedbyuid, GETUTCDATE()
		from      TransmissionConfiguration tc WITH(NOLOCK)
        inner join ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
		cross join inserted i 
		inner join UserPRM up WITH(NOLOCK) on i.PersonUid = up.PersonUid 
	    where     tc.TransmissionType = ''EKOS'' and
        lip.Inactive = 0 
  end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[EKOS_provider_update]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[EKOS_provider_update] on [dbo].[Provider] for UPDATE as
BEGIN

IF NOT EXISTS (SELECT * 
				 FROM TransmissionConfiguration tc
                 INNER JOIN ListIntegrationPartner lip on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
			     WHERE tc.TransmissionType = ''EKOS'' AND
					   lip.Inactive = 0 )
  RETURN;
	
 IF NOT EXISTS ( select 1 from inserted )
    RETURN;

  if dbo.IsReplicating() = 0
  begin

		insert    TransmissionOutbound(TransmissionType, ForeignObjectUid, RawMessage, ProviderUid, lastmodifiedbyuid, LastModifiedDate)
		select    distinct ''EKOS'', i.personuid, ''iMedica.Prm.BusinessObject.Provider'', i.personuid, i.lastmodifiedbyuid, GETUTCDATE()
		from      TransmissionConfiguration tc WITH(NOLOCK)
        inner join ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
		cross join inserted i 
		inner join UserPRM up WITH(NOLOCK) on i.PersonUid = up.PersonUid 
	    where     tc.TransmissionType = ''EKOS'' and
        lip.Inactive = 0 

  end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[provider_cliniccenter]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[provider_cliniccenter]
on [dbo].[Provider] for insert, update as
begin
  if not exists ( select top 1 * from inserted )
    return

	if dbo.isreplicating() = 0
	begin
	  if update (cliniccenteruid)
	  begin
		  update	ugm
		  set	
			  usergroupuid = i.cliniccenteruid, 
			  lastmodifieddate = getutcdate()
		  from	usergroupmember ugm inner join deleted d on ugm.usergroupuid = d.cliniccenteruid and ugm.memberuseruid = d.personuid
			  inner join inserted i on d.personuid = i.personuid
		  where	not i.cliniccenteruid is null
  		
		  insert	usergroupmember(usergroupuid, memberuseruid, lastmodifieddate, lastmodifiedbyuid)
		  select	i.cliniccenteruid, i.personuid, getutcdate(), i.lastmodifiedbyuid
		  from	inserted i left join usergroupmember ugm on ugm.usergroupuid = i.cliniccenteruid and ugm.memberuseruid = i.personuid
		  where	ugm.extentusergroupuid is null and
			  not i.cliniccenteruid is null

		  delete	ugm
		  from	usergroupmember ugm inner join deleted d on ugm.usergroupuid = d.cliniccenteruid and ugm.memberuseruid = d.personuid
			  inner join inserted i on d.personuid = i.personuid
		  where	i.cliniccenteruid is null

	  end
  end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[provider_cliniccenter_delete]'))
EXEC dbo.sp_executesql @statement = N'CREATE trigger [dbo].[provider_cliniccenter_delete]
on [dbo].[Provider] for delete as
begin
  if not exists ( select top 1 * from deleted )
    return

  if dbo.isreplicating() = 0
  begin

	  delete usergroupmember 
	  from usergroupmember ugm 
	  inner join deleted d on ugm.usergroupuid = d.cliniccenteruid and ugm.memberuseruid = d.personuid

  end
end
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[ProviderDirectory_SPE]'))
EXEC dbo.sp_executesql @statement = N'
/****** Object:  Trigger [dbo].[ProviderDirectory_SPE]    Script Date: 10/8/2019 4:33:14 PM ******/


CREATE TRIGGER [dbo].[ProviderDirectory_SPE] ON [dbo].[ProviderDirectory]   
FOR INSERT , UPDATE 

AS  
BEGIN  

IF @@ROWCOUNT = 0  
RETURN  

 IF dbo.IsCacheClient() = 0  
 BEGIN  
  SET NOCOUNT ON  
  
  IF NOT EXISTS (SELECT * FROM ListProductParameter WHERE ProductParameterUid=''19A46484-2F1F-497F-ABDE-47116A1E4D25'') AND NOT EXISTS (select  1  from inserted)
  RETURN;

  BEGIN
		BEGIN TRY

		;WITH CTE_xmlSLL (providerDirectoryUID,xmlSLL)  
		AS  
		-- Define the CTE query.  
		(  
		select providerDirectoryUID, CASE WHEN TRY_CAST(ServiceLevelList AS XML) IS NOT NULL THEN cast(ServiceLevelList as xml) ELSE NULL END as xmlSLL from inserted
		
		),
		CTE_SPE (providerDirectoryUID, Name)  
		as
		( 
			   select CTE_xmlSLL.providerDirectoryUID ,
			   lf2.params.value(''(./@Name[1])'', ''varchar(100)'') as Name 
			   from CTE_xmlSLL
			   CROSS APPLY xmlSLL.nodes(''//ServiceLevel/Service[@Name = "Specialty Patient Enrollment"]'') as lf2(params) 

		)

		UPDATE ListProductParameter  SET BoolValue=''1'', inactive=''0''  WHERE ProductParameterUid=''19A46484-2F1F-497F-ABDE-47116A1E4D25''  AND EXISTS (select * from CTE_SPE) 

		END TRY

		BEGIN CATCH
			
		END CATCH

		
END

END

END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[ProviderSignature_Permanent]'))
EXEC dbo.sp_executesql @statement = N'

CREATE trigger [dbo].[ProviderSignature_Permanent]
on [dbo].[ProviderSignature] for insert, update as
begin
  if not exists ( select top 1 * from inserted )
    return

	if ( dbo.isreplicating() = 0 )
	begin
		if update (ispermanentsignature)
		begin
			update	ps
			set		ispermanentsignature = 0, 
					LastModifiedDate = DATEADD(second, 1, ps.LastModifiedDate)
			from	inserted i inner join providersignature ps on i.provideruid = ps.provideruid
			where	i.providersignatureuid <> ps.providersignatureuid and
					i.ispermanentsignature = 1 and ps.IsPermanentSignature = 1

		end
	end
end


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[CacheMachinePatient_Update]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[CacheMachinePatient_Update]
   ON  [dbo].[RelCacheMachinePatient]
   AFTER UPDATE
AS 
BEGIN
	SET NOCOUNT ON;
	IF [dbo].[Replication_IsReplicatedDB]() = 0 AND UPDATE([Action]) 
	BEGIN
		DECLARE @ProcessDate [datetime] = GETUTCDATE(),
			@Action_Add [smallint] = 1,
			@Action_Purge [smallint] = 2
						
		UPDATE rcmp
			SET [PurgeDate] = @ProcessDate
		FROM [inserted] AS vrcmpi
			INNER JOIN [deleted] AS vrcmpd ON vrcmpi.[CacheMachinePatientUid] = vrcmpd.[CacheMachinePatientUid]
			INNER JOIN [RelCacheMachinePatient] AS rcmp ON vrcmpd.[CacheMachinePatientUid] = rcmp.[CacheMachinePatientUid]
			INNER JOIN [ViewListCacheMachine] AS vcm ON rcmp.[CacheMachineUid] = vcm.[CacheMachineUid]
		WHERE vrcmpi.[Action] IN (@Action_Add, @Action_Purge)
	END
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[RelCCSymptomHpi_Delete]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[RelCCSymptomHpi_Delete] ON [dbo].[RelCCSymptomHpi] AFTER DELETE AS
BEGIN
	SET NOCOUNT ON;
	DELETE	h
	FROM	ListHpi h INNER JOIN deleted d ON h.HpiUid = d.HpiUid
	WHERE	NOT h.HpiUid IN (SELECT HpiUid FROM RelCCSymptomHpi) AND
			NOT h.HpiUid IN (SELECT HpiUid FROM VisitHpi)
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[RelCCSymptomHpiCategory_Delete]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[RelCCSymptomHpiCategory_Delete] ON [dbo].[RelCCSymptomHpiCategory] AFTER DELETE AS
BEGIN
	SET NOCOUNT ON;
	DELETE	hc
	FROM	ListHpiCategory hc INNER JOIN deleted d ON hc.HpiCategoryUid = d.HpiCategoryUid
	WHERE	NOT hc.HpiCategoryUid IN (SELECT HpiCategoryUid FROM RelCCSymptomHpiCategory) AND
			NOT hc.HpiCategoryUid IN (SELECT HpiCategoryUid FROM VisitHpi)
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[RelCCSystemSymptom_Delete]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[RelCCSystemSymptom_Delete] ON [dbo].[RelCCSystemSymptom] AFTER DELETE AS
BEGIN
	SET NOCOUNT ON;
	DELETE	s
	FROM	ListSymptom s INNER JOIN deleted d ON s.SymptomUid = d.CCSymptomUid
	WHERE	NOT s.SymptomUid IN (SELECT RosSymptomUid FROM RelRosSystemSymptom) AND
			NOT s.SymptomUid IN (SELECT CCSymptomUid FROM RelCCSystemSymptom) 
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[RelFindTableHide_Insert]'))
EXEC dbo.sp_executesql @statement = N'
CREATE TRIGGER [dbo].[RelFindTableHide_Insert] ON [dbo].[RelFindTableHide] INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @oldRelUid uniqueidentifier
	DECLARE	@newRelUid uniqueidentifier

	SELECT	@oldRelUid = rel.RelFindTableHideUid,
			@newRelUid = i.RelFindTableHideUid
	FROM	inserted i INNER JOIN RelFindTableHide rel ON i.FindTableUid = rel.FindTableUid AND i.UserUid = rel.UserUid AND i.Uid = rel.Uid

	IF @OldRelUid IS NULL
		INSERT	RelFindTableHide
		SELECT	*
		FROM	inserted
	ELSE
		UPDATE	RelFindTableHide
		SET		LastModifiedDate = GETUTCDATE(),
				RelFindTableHideUid = @newRelUid
		WHERE	RelFindTableHideUid = @oldRelUid
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[RelFindTableMFU_Insert]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[RelFindTableMFU_Insert] ON [dbo].[RelFindTableMFU] INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @oldRelUid uniqueidentifier
	DECLARE	@newRelUid uniqueidentifier

	SELECT	@oldRelUid = rel.RelFindTableMFUUid,
			@newRelUid = i.RelFindTableMFUUid
	FROM	inserted i INNER JOIN RelFindTableMFU rel ON i.FindTableUid = rel.FindTableUid AND i.UserUid = rel.UserUid AND i.Uid = rel.Uid

	IF @OldRelUid IS NULL
		INSERT	RelFindTableMFU
		SELECT	*
		FROM	inserted
	ELSE
		UPDATE	RelFindTableMFU
		SET		LastModifiedDate = GETUTCDATE(),
				[Count] = [Count] + 1,
				RelFindTableMFUUid = @newRelUid
		WHERE	RelFindTableMFUUid = @oldRelUid
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[RelFindTableMRU_Insert]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[RelFindTableMRU_Insert] ON [dbo].[RelFindTableMRU] INSTEAD OF INSERT
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @oldRelUid uniqueidentifier
	DECLARE	@newRelUid uniqueidentifier

	SELECT	@oldRelUid = rel.RelFindTableMRUUid,
			@newRelUid = i.RelFindTableMRUUid
	FROM	inserted i INNER JOIN RelFindTableMRU rel ON i.FindTableUid = rel.FindTableUid AND i.UserUid = rel.UserUid AND i.Uid = rel.Uid

	IF @OldRelUid IS NULL
		INSERT	RelFindTableMRU
		SELECT	*
		FROM	inserted
	ELSE
		UPDATE	RelFindTableMRU
		SET		LastModifiedDate = GETUTCDATE(),
				RelFindTableMRUUid = @newRelUid
		WHERE	RelFindTableMRUUid = @oldRelUid
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[interface_consent_updated]'))
EXEC dbo.sp_executesql @statement = N'
-- =============================================
-- Author:		<Blake, Adams>
-- Create date: <2/23/2022>
-- Description:	<Creates an ADT message when patient consent is updated>
-- =============================================
CREATE TRIGGER [dbo].[interface_consent_updated] ON [dbo].[RelHL7PartnerPatientConsent] AFTER UPDATE AS 
BEGIN
	IF NOT EXISTS (SELECT TOP 1 * FROM INSERTED )
		return

	IF dbo.IsReplicating() = 0
	BEGIN
		INSERT hl7actiontypeobject(hl7partnermessageuid, actiontype, objectuid, objecttype, lastmodifiedbyuid)
		SELECT pm.hl7partnermessageuid, pm.sendfunction, i.PatientUid, ''Patient'', i.lastmodifiedbyuid
		FROM HL7PartnerMessage pm INNER JOIN HL7Partner p ON pm.HL7PartnerUid = p.HL7PartnerUid
			INNER JOIN inserted i ON i.HL7PartnerUid = p.HL7PartnerUid
			LEFT JOIN ViewActionTypeObjectPartnerMessage atopm ON i.PatientUid = atopm.ObjectUid 
				AND atopm.ObjectType = ''patient'' 
				AND pm.HL7PartnerUid = atopm.HL7PartnerUid 
				AND atopm.SendFunction IN (''updatepatient'')
		WHERE pm.SendFunction = ''updatepatient'' AND
			pm.Send = 1 AND
			pm.Inactive = 0 AND
			p.Inactive = 0 AND
			i.ConsentDate IS NOT NULL AND
			atopm.HL7ActionTypeObjectUid IS NULL
	END
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[MPIPatientConsent]'))
EXEC dbo.sp_executesql @statement = N'
CREATE trigger [dbo].[MPIPatientConsent] on [dbo].[RelHL7PartnerPatientConsent] AFTER Insert, Update as
begin	
  if not exists ( select top 1 * from inserted )
    return

  if dbo.IsReplicating() = 0
  begin

	  insert	hl7actiontypeobject(hl7partnermessageuid, actiontype, objectuid, objecttype, lastmodifiedbyuid)
	  select	pm.hl7partnermessageuid, pm.sendfunction, i.PatientUid, ''Patient'', i.lastmodifiedbyuid
	  from	hl7partnermessage pm inner join hl7partner p on pm.hl7partneruid = p.hl7partneruid
			  cross join inserted i 
			  JOIN deleted d on i.RelHL7PartnerPatientConsentUid = d.RelHL7PartnerPatientConsentUid
			  left join viewactiontypeobjectpartnermessage atopm on i.PatientUid = atopm.objectuid 
					and atopm.objecttype=''patient'' 
					and pm.hl7partneruid = atopm.hl7partneruid 
					and atopm.sendfunction = ''MPIConsent''
	  where	pm.sendfunction = ''MPIConsent'' and
			  pm.send = 1 and
			  pm.inactive = 0 and
			  p.inactive = 0 and
			  atopm.hl7actiontypeobjectuid is null and 
			  (d.ProtectionIndicator is null or d.ProtectionIndicator = ''Y'') and
			  i.ProtectionIndicator = ''N''

  end
end' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[RelPETemplateSystem_Delete]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[RelPETemplateSystem_Delete] ON [dbo].[RelPETemplateSystem]  FOR DELETE AS 
	DELETE	sym
	FROM	deleted d INNER JOIN RelPETemplateSymptom sym ON d.RelPETemplateSystemUid = sym.RelPETemplateSystemUid
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[RelSurveySurveySection_Delete]'))
EXEC dbo.sp_executesql @statement = N'
--cleanup items that were merged
CREATE TRIGGER [dbo].[RelSurveySurveySection_Delete] ON [dbo].[RelSurveySurveySection] AFTER DELETE AS
BEGIN
	SET NOCOUNT ON;
	DELETE	s
	FROM	ListSurveySection s INNER JOIN deleted d ON s.SurveySectionUid = d.SurveySectionUid
	WHERE	NOT s.SurveySectionUid IN (SELECT SurveySectionUid FROM ListScantronSurveyForm) AND
			NOT s.SurveySectionUid IN (SELECT SurveySectionUid FROM ListScantronSurveyFormFields)  AND
			NOT s.SurveySectionUid IN (SELECT RequireSurveySectionUid FROM RelSurveyAnswerGroupSurveyAnswer) AND
			NOT s.SurveySectionUid IN (SELECT SurveySectionUid FROM RelSurveySectionSurveyQuestion) AND
			NOT s.SurveySectionUid IN (SELECT SurveySectionUid FROM RelSurveySurveySection) AND
			NOT s.SurveySectionUid IN (SELECT SurveySectionUid FROM SurveyResponse) 
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[RelVisitMedication_AfterUpdate]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[RelVisitMedication_AfterUpdate] ON [dbo].[RelVisitMedication] AFTER UPDATE
			/*
			Purpose: Prevent print from overwriting eprescribe already transmitted status
			Created On: 20131015
			Special Comments
				This is a temporary trigger to fix the problem of TrackRx showing Queued status when ePrescribe has already transmitted the Rx.
			*/

			AS

			BEGIN
				IF dbo.IsReplicating() != 0
					RETURN

				IF UPDATE(eRxStatusUid)
					BEGIN
						DECLARE @eRxStatusQueuedUid      UNIQUEIDENTIFIER = ''0605B6F6-2FE4-49CB-B868-9DF448AB3E01'',
								@eRxStatusTransmittedUid UNIQUEIDENTIFIER = ''B1F7EFAF-D56D-4BAD-AE1F-8205E1D00B58''

						-- The assumption here is that the eRxStatus should never transition from Transmitted status back down to Queued
						IF EXISTS(SELECT TOP 1 *
								FROM deleted d
								INNER JOIN inserted i ON i.RelVisitMedicationUid = d.RelVisitMedicationUid
								WHERE i.eRxStatusUid = @eRxStatusQueuedUid
									AND d.eRxStatusUid = @eRxStatusTransmittedUid)
						BEGIN
							UPDATE rvm
							SET eRxStatusUid = @eRxStatusTransmittedUid
							FROM RelVisitMedication rvm
							INNER JOIN deleted  d ON d.RelVisitMedicationUid = rvm.RelVisitMedicationUid
							INNER JOIN inserted i ON i.RelVisitMedicationUid = rvm.RelVisitMedicationUid
							WHERE rvm.eRxStatusUid = @eRxStatusQueuedUid
								AND i.eRxStatusUid   = @eRxStatusQueuedUid
								AND d.eRxStatusUid   = @eRxStatusTransmittedUid
						END
					END
			END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[EKOS_SuperbillClaim__Delete]'))
EXEC dbo.sp_executesql @statement = N'
CREATE TRIGGER [dbo].[EKOS_SuperbillClaim__Delete] ON [dbo].[Superbill]   
FOR DELETE  

AS  
BEGIN  

IF @@ROWCOUNT = 0  
RETURN  

 IF dbo.IsCacheClient() = 0  
 BEGIN  
  SET NOCOUNT ON   
    
  if not exists (select * 
				 from TransmissionConfiguration tc
                 inner join ListIntegrationPartner lip on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
			     where tc.TransmissionType = ''EKOS'' and
					   lip.Inactive = 0 )
	RETURN;
  

	IF NOT  EXISTS (SELECT 1 FROM deleted)

	RETURN;

	DECLARE @ExcludeFinancialCenter VARCHAR(MAX) = NULL
	DECLARE @ExcludeSuperbills TABLE (SuperbillUid UNIQUEIDENTIFIER)

	SELECT @ExcludeFinancialCenter = CONVERT(XML, AdditionalOutboundXML).value(''(//FinancialCentersOptOut)[1]'',''VARCHAR(MAX)'')
	FROM ListIntegrationPartner WHERE IntegrationPartnerUid = ''20C576DF-A670-4A58-85DE-CAA4BA5151E0''

	INSERT INTO @ExcludeSuperbills
	SELECT s.SuperbillUid
	from DELETED  s
	LEFT JOIN SuperbillProcedure SP WITH(NOLOCK) ON  SP.SuperbillUid = s.SuperbillUid
	INNER JOIN AR_LedgerDetail ARLD WITH(NOLOCK) ON ARLD.SuperbillProcedureUid= SP.SuperbillProcedureUid AND ((ARLD.FinancialCenterUid IN (SELECT element FROM dbo.Split(@ExcludeFinancialCenter,'',''))))
	LEFT JOIN AR_Ledger ARL WITH(NOLOCK) ON ARLD.LedgerUid=ARL.LedgerUid  

	BEGIN

  	DELETE TransmissionOutbound where TransmissionOutboundUid in  
			(  
				SELECT TransmissionOutboundUid  
				from TransmissionOutbound tod WITH(NOLOCK)
				INNER JOIN deleted d on tod.ForeignObjectUid = d.SuperbillUid 
						Where 
						/*tod.Description IN (''SUPERBILLDELETE'',''SUPERBILLCLAIM'') AND */
						 tod.TransmissionType=''EKOS''
						AND tod.Status <> 100
			)   
 
   
   INSERT INTO TransmissionOutbound (TransmissionType,Description ,ForeignObjectUid, RawMessage, PatientUid, lastmodifiedbyuid, LastModifiedDate)  
	Select  tc.TransmissionType, ''SUPERBILLDELETE'',d.SuperbillUid, ''iMedica.Prm.BusinessObject.Superbill'',d.PatientUid,d.LastModifiedByUid, GETUTCDATE() 
				 from TransmissionConfiguration tc WITH(NOLOCK)
                 inner join ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
				 cross join deleted d
				 LEFT JOIN @ExcludeSuperbills ex on d.SuperbillUid = ex.SuperbillUid
			     where tc.TransmissionType = ''EKOS'' and
					   lip.Inactive = 0 
					   AND ex.SuperbillUid IS NULL

      END  

 END 
  
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[EKOS_SuperbillClaim_InsertUpdate]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[EKOS_SuperbillClaim_InsertUpdate] ON [dbo].[Superbill]   
FOR INSERT, UPDATE  

AS  
BEGIN  

IF @@ROWCOUNT = 0  
RETURN  

 IF dbo.IsCacheClient() = 0  
 BEGIN  
  SET NOCOUNT ON   
  
    IF NOT EXISTS (SELECT * 
				 FROM TransmissionConfiguration tc WITH(NOLOCK)
                 INNER JOIN ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
			     WHERE tc.TransmissionType = ''EKOS'' AND
					   lip.Inactive = 0 )
  RETURN;

  DECLARE @ExcludeFinancialCenter VARCHAR(MAX) = NULL
  DECLARE @ExcludeSuperbills TABLE (SuperbillUid UNIQUEIDENTIFIER)

	 SELECT @ExcludeFinancialCenter = CONVERT(XML, AdditionalOutboundXML).value(''(//FinancialCentersOptOut)[1]'',''VARCHAR(MAX)'')
	FROM ListIntegrationPartner WITH(NOLOCK) WHERE IntegrationPartnerUid = ''20C576DF-A670-4A58-85DE-CAA4BA5151E0''

	INSERT INTO @ExcludeSuperbills
	SELECT i.SuperbillUid
	from INSERTED i
	INNER JOIN SuperbillProcedure SP WITH(NOLOCK) ON  SP.SuperbillUid = i.SuperbillUid
	INNER JOIN AR_LedgerDetail ARLD WITH(NOLOCK) ON ARLD.SuperbillProcedureUid= SP.SuperbillProcedureUid AND ((ARLD.FinancialCenterUid IN (SELECT element FROM dbo.Split(@ExcludeFinancialCenter,'',''))))
	INNER JOIN AR_Ledger ARL WITH(NOLOCK) ON ARLD.LedgerUid=ARL.LedgerUid
 

  --SYSTEM DEFINED GUID FOR READY TO SUBMIT
  DECLARE @ReadyToSubmitSuperbillStatusUid uniqueidentifier = ''55ED3239-89F3-4488-89C9-71BE5A541CC4''
  --SYSTEM DEFINED GUID FOR READY TO REVIEW
  DECLARE @ReadyToReviewSuperbillStatusUid uniqueidentifier =''D2291C14-3F4E-4381-80A7-883C76C9499B''
  --SYSTEM DEFINED GUID FOR PRELIMINARY 
  DECLARE @PreliminarySuperbillStatusUid uniqueidentifier =''DF81BE7C-71CF-47F4-8573-733E81E30EA8''
  --SYSTEM DEFINED GUID FOR REJECTED
  DECLARE @RejectedSuperbillStatusUid uniqueidentifier = ''2C4A6E7D-EB6D-4370-A836-5937363C6B69'' 
  --SYSTEM DEFINED GUID FOR ERAREJECTED
  DECLARE @EraRejectedSuperbillStatusUid uniqueidentifier = ''2352F0FB-708B-437E-9809-F80128195F9E''
  --SYSTEM DEFINED GUID FOR FILED
  DECLARE @FiledSuperbillStatusUid uniqueidentifier =''9FFE6214-7C7F-4516-9899-43D37FABE21D''
   -- SYSTEM DEFINED GUID FOR CANCELED
   DECLARE @CanceledSuperbillStatusUid uniqueidentifier=''FC8AD61B-139A-4CFA-9580-CDACFC3ACF90''
    --SYSTEM DEFINED GUID FOR COMPLETE
   DECLARE @CompleteSuperbillStatusUid uniqueidentifier = ''30F64D66-55CB-4438-BB2F-7A6250399312''  
   	--SYSTEM DEFINED GUID FOR REFILED
   DECLARE @RefiledSuperbillStatusUid uniqueidentifier = ''A8258278-7182-45DC-869F-790F46F2C177''
	--SYSTEM DEFINED GUID FOR PENDING PATIENT PAYMENT
   DECLARE @PendingPatientPaymentSuperbillStatusUid uniqueidentifier = ''D2BF0F3C-6E03-478F-BDAE-4DCAC5EB9410''


  
  DECLARE @superbillstatus table (MapFromSuperbillStatusUid uniqueidentifier,MapToSuperbillStatusUid uniqueidentifier)
 
 --ADD EKOS Generic status
  INSERT INTO @superbillstatus (MapFromSuperbillStatusUid,MapToSuperbillStatusUid)
   values 
   (@PreliminarySuperbillStatusUid,@PreliminarySuperbillStatusUid),
   (@ReadyToReviewSuperbillStatusUid,@ReadyToReviewSuperbillStatusUid),
   (@ReadyToSubmitSuperbillStatusUid,@ReadyToSubmitSuperbillStatusUid), 
	(@EraRejectedSuperbillStatusUid, @EraRejectedSuperbillStatusUid),
    (@RejectedSuperbillStatusUid, @RejectedSuperbillStatusUid),
	(@FiledSuperbillStatusUid, @FiledSuperbillStatusUid) , 
	(@CanceledSuperbillStatusUid, @CanceledSuperbillStatusUid),
	(@CompleteSuperbillStatusUid,@CompleteSuperbillStatusUid),
	(@RefiledSuperbillStatusUid,@RefiledSuperbillStatusUid),
	(@PendingPatientPaymentSuperbillStatusUid,@PendingPatientPaymentSuperbillStatusUid)

      --Add Mapped Superbill Status
  INSERT INTO @superbillstatus (MapFromSuperbillStatusUid, MapToSuperbillStatusUid)
  SELECT DISTINCT  MI.FindTableFromItemUid, mi.FindTableToItemUid
  from  MapItem MI WITH(NOLOCK)
  JOIN MapSource MS WITH(NOLOCK) ON MI.MapSourceUid=MS.MapSourceUid AND MS.MapSourceUid=''ACB1C24D-992C-4DDC-ACEE-4BBE84C0FD5A'' AND MS.Inactive=0
  JOIN @superbillstatus LS ON MI.FindTableToItemUid=LS.MapFromSuperbillStatusUid  AND mi.FindTableFromItemUid IS NOT NULL 

  	DECLARE @Superbills TABLE (SuperbillUid UNIQUEIDENTIFIER, SuperbillStatusUid UNIQUEIDENTIFIER, PatientUid UNIQUEIDENTIFIER, LastModifiedByUid UNIQUEIDENTIFIER,MapToSuperbillStatusUid UNIQUEIDENTIFIER)
	INSERT INTO @Superbills
	SELECT DISTINCT  i.SuperbillUid, i.SuperbillStatusUid, PatientUid, i.LastModifiedByUid, ls.MapToSuperbillStatusUid
	FROM INSERTED i
	INNER JOIN  @superbillstatus ls on i.SuperbillStatusUid=ls.MapFromSuperbillStatusUid
	LEFT JOIN @ExcludeSuperbills ex on i.SuperbillUid = ex.SuperbillUid
	WHERE ex.SuperbillUid IS NULL
		


	IF NOT EXISTS (SELECT 1 FROM @Superbills)
	RETURN;

 
  BEGIN    	
	

	DELETE TransmissionOutbound where TransmissionOutboundUid in  
			(  
				SELECT TransmissionOutboundUid  
				FROM TransmissionOutbound tod WITH(NOLOCK)
				INNER JOIN @Superbills s on tod.ForeignObjectUid = s.SuperbillUid
				WHERE tod.Description IN (''SUPERBILLDELETE'',''SUPERBILLCLAIM'') AND
						tod.TransmissionType = ''EKOS'' 
						AND tod.Status <> 100)
      
         
	INSERT INTO TransmissionOutbound (TransmissionType,Description ,ForeignObjectUid, RawMessage, PatientUid, lastmodifiedbyuid, LastModifiedDate)  
	Select  tc.TransmissionType, ''SUPERBILLDELETE'',i.SuperbillUid, ''iMedica.Prm.BusinessObject.Superbill'',i.PatientUid,i.LastModifiedByUid, GETUTCDATE() 
				 FROM TransmissionConfiguration tc WITH(NOLOCK)
                INNER JOIN ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
				 CROSS JOIN @Superbills i
			     WHERE tc.TransmissionType = ''EKOS'' and
					   lip.Inactive = 0 and i.MapToSuperbillStatusUid=@CanceledSuperbillStatusUid
					   
         
	INSERT INTO TransmissionOutbound (TransmissionType,Description ,ForeignObjectUid, RawMessage, PatientUid,  lastmodifiedbyuid, LastModifiedDate)  
	Select  tc.TransmissionType, ''SUPERBILLCLAIM'',i.SuperbillUid, ''iMedica.Prm.BusinessObject.Superbill'',i.PatientUid,i.LastModifiedByUid, GETUTCDATE() 
				 FROM TransmissionConfiguration tc WITH(NOLOCK)
                 INNER JOIN ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
				 CROSS JOIN @Superbills i
			    WHERE tc.TransmissionType = ''EKOS'' and
					   lip.Inactive = 0 and 
					   i.MapToSuperbillStatusUid <> @CanceledSuperbillStatusUid
     
	 END

END

 END' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[EKOS_SuperbillClaimSettled_InsertUpdate]'))
EXEC dbo.sp_executesql @statement = N'
CREATE TRIGGER [dbo].[EKOS_SuperbillClaimSettled_InsertUpdate] ON [dbo].[Superbill]   
FOR INSERT, UPDATE  

AS  
BEGIN  

IF @@ROWCOUNT = 0  
RETURN  

 IF dbo.IsCacheClient() = 0  
 BEGIN  
  SET NOCOUNT ON   
  
  DECLARE @SuperbillUid UNIQUEIDENTIFIER    

  IF NOT EXISTS (SELECT * 
				 FROM TransmissionConfiguration tc WITH(NOLOCK)
                 INNER JOIN ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
			     WHERE tc.TransmissionType = ''EKOS'' AND
					   lip.Inactive = 0 )
 RETURN;

  --SYSTEM DEFINED GUID FOR COMPLETE
  DECLARE @CompleteSuperbillStatusUid uniqueidentifier = ''30F64D66-55CB-4438-BB2F-7A6250399312''  
  
  --Add EKOS Generic Superbill Status
  DECLARE @superbillstatus table (MapFromSuperbillStatusUid uniqueidentifier, MapToSuperbillStatusUid uniqueidentifier )
  INSERT INTO @superbillstatus (MapFromSuperbillStatusUid, MapToSuperbillStatusUid) values (@CompleteSuperbillStatusUid, @CompleteSuperbillStatusUid)
  
  --Add Mapped Superbill Status
  INSERT INTO @superbillstatus (MapFromSuperbillStatusUid, MapToSuperbillStatusUid)
  SELECT DISTINCT  MI.FindTableFromItemUid, mi.FindTableToItemUid
  from  MapItem MI WITH(NOLOCK) JOIN MapSource MS WITH(NOLOCK) ON MI.MapSourceUid=MS.MapSourceUid AND MS.MapSourceUid=''ACB1C24D-992C-4DDC-ACEE-4BBE84C0FD5A'' AND MS.Inactive=0
  where mi.FindTableToItemUid=@CompleteSuperbillStatusUid AND mi.FindTableFromItemUid IS NOT NULL 

  DECLARE @ExcludeFinancialCenter VARCHAR(MAX) = NULL
  DECLARE @ExcludeSuperbills TABLE (SuperbillUid UNIQUEIDENTIFIER)

	SELECT @ExcludeFinancialCenter = CONVERT(XML, AdditionalOutboundXML).value(''(//FinancialCentersOptOut)[1]'',''VARCHAR(MAX)'')
	FROM ListIntegrationPartner WHERE IntegrationPartnerUid = ''20C576DF-A670-4A58-85DE-CAA4BA5151E0''

	INSERT INTO @ExcludeSuperbills
	SELECT s.SuperbillUid
	from INSERTED s
	LEFT JOIN SuperbillProcedure SP WITH(NOLOCK) ON  SP.SuperbillUid = s.SuperbillUid
	INNER JOIN AR_LedgerDetail ARLD WITH(NOLOCK) ON ARLD.SuperbillProcedureUid= SP.SuperbillProcedureUid AND ((ARLD.FinancialCenterUid IN (SELECT element FROM dbo.Split(@ExcludeFinancialCenter,'',''))))
	LEFT JOIN AR_Ledger ARL WITH(NOLOCK) ON ARLD.LedgerUid=ARL.LedgerUid  

 
  DECLARE @Superbills TABLE (SuperbillUid UNIQUEIDENTIFIER, SuperbillStatusUid UNIQUEIDENTIFIER, PatientUid UNIQUEIDENTIFIER, LastModifiedByUid UNIQUEIDENTIFIER)
		INSERT INTO @Superbills
		SELECT i.SuperbillUid, i.SuperbillStatusUid, i.PatientUid, i.LastModifiedByUid
		FROM INSERTED i
		JOIN AR_ViewSuperbillAggregate ar WITH(NOLOCK) on i.SuperbillUid=ar.SuperbillUid
		JOIN @superbillstatus ls  ON i.SuperbillStatusUid=ls.MapFromSuperbillStatusUid
		LEFT JOIN @ExcludeSuperbills ex on i.SuperbillUid = ex.SuperbillUid
	    WHERE ar.LiabilityBalance=0
		AND ex.SuperbillUid IS NULL
	
 
 IF NOT EXISTS (SELECT 1 FROM @Superbills)

 RETURN;
	
  BEGIN    	
   
	DELETE TransmissionOutbound WHERE TransmissionOutboundUid in  
	(  SELECT tod.TransmissionOutboundUid 
	            FROM TransmissionOutbound tod WITH(NOLOCK)
				INNER JOIN @Superbills s ON tod.ForeignObjectUid = s.SuperbillUid 
						WHERE
						/*tod.Description IN (''SUPERBILLDELETE'',''SUPERBILLCLAIM'') AND */
						tod.TransmissionType=''EKOS''
						AND tod.Status <> 100
		
	)   

         -- FOR SUPERBILLCLAIM API CALL PUT
	INSERT INTO TransmissionOutbound (TransmissionType,Description ,ForeignObjectUid, RawMessage, PatientUid, lastmodifiedbyuid, LastModifiedDate)  
	SELECT tc.TransmissionType, ''SUPERBILLCLAIM'',i.SuperbillUid, ''iMedica.Prm.BusinessObject.Superbill'',i.PatientUid,i.LastModifiedByUid, GETUTCDATE()  FROM TransmissionConfiguration tc
                 INNER JOIN ListIntegrationPartner lip WITH(NOLOCK) ON lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
				 CROSS JOIN @Superbills i
			     WHERE tc.TransmissionType = ''EKOS'' and
					   lip.Inactive = 0 

	 -- FOR SUPERBILLCLAIM SETTLE API CALL PUT
	INSERT INTO TransmissionOutbound (TransmissionType,Description ,ForeignObjectUid, RawMessage, PatientUid,lastmodifiedbyuid, LastModifiedDate)  
	SELECT  tc.TransmissionType, ''SUPERBILLCLAIMSETTLED'',i.SuperbillUid, ''iMedica.Prm.BusinessObject.Superbill'',i.PatientUid,i.LastModifiedByUid, GETUTCDATE()  from TransmissionConfiguration tc
                 INNER JOIN ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
				  CROSS JOIN @Superbills i
			      WHERE tc.TransmissionType = ''EKOS'' and
					   lip.Inactive = 0 
     END
     
 END  
END

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[SuperBill_Based_DFT]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[SuperBill_Based_DFT] ON [dbo].[Superbill]   
FOR INSERT, UPDATE  
/* Purpose: Used to track inserts made to the Superbill table for HL7 */  
AS  
BEGIN  

IF @@ROWCOUNT = 0  
RETURN  

 IF dbo.IsCacheClient() = 0  
 BEGIN  
  SET NOCOUNT ON   
  
  DECLARE @SuperbillUid UNIQUEIDENTIFIER    

  --SYSTEM DEFINED GUID FOR READY TO SUBMIT
  DECLARE @ReadyToSubmitSuperbillStatusUid uniqueidentifier = ''55ED3239-89F3-4488-89C9-71BE5A541CC4''

  DECLARE @DFTTable TABLE    
  (    
   partnerMessageID VARCHAR(50) --Array element contents    
  )    
  
  INSERT INTO @DFTTable  
  Select PM.HL7PartnerMessageUid from HL7partner P   
	LEFT JOIN HL7PartnerMessage PM ON PM.HL7partnerUid=P.HL7partnerUid  
	where PM.MessageType = ''DFT''   
	  and PM.Inactive = 0    
	  and P.Inactive = 0   
	  and PM.Send = 1  
	  and PM.SendFunction = ''SuperbillCharges''
  
  DECLARE DFT_CUR CURSOR FAST_FORWARD LOCAL FOR   
    SELECT SuperbillUid FROM INSERTED    
  
  OPEN DFT_CUR  
  
  FETCH NEXT FROM DFT_CUR INTO @SuperbillUid 
    
  WHILE @@FETCH_STATUS = 0  
  BEGIN    	
	--only interested in visits where status was just changed to Ready To Submit
	IF NOT EXISTS (	SELECT *
						FROM inserted i
						JOIN deleted d on i.SuperbillUid = d.SuperbillUid
						where i.SuperbillStatusUid = @ReadyToSubmitSuperbillStatusUid and
							d.SuperbillStatusUid != @ReadyToSubmitSuperbillStatusUid and
							i.SuperbillUid = @SuperbillUid
				)
	BEGIN
		GOTO NEXT_LOOP --interested in this superbill so go on to the next one
    END
   
	delete hl7actiontypeobject where hl7actiontypeobjectuid in  
	(  select hl7actiontypeobjectuid  
		from hl7actiontypeobject ato  
		where ato.objectuid = @SuperbillUid and ato.actiontype = ''SuperbillCharges'' and ato.objecttype = ''Superbill''  
	)   
      
         
	INSERT INTO HL7ActionTypeObject (HL7ActionTypeObjectUid, HL7PartnerMessageUid, ActionType, ObjectType,ObjectUid, LastModifiedDate)  
	Select NEWID(), partnerMessageID, ''SuperbillCharges'',''Superbill'', @SuperbillUid, GETUTCDATE() From @DFTTable  
     
	NEXT_LOOP:  
	
	FETCH NEXT FROM DFT_CUR INTO @SuperbillUid  
  END  
    
  CLOSE DFT_CUR  
  DEALLOCATE DFT_CUR  
  
  SET NOCOUNT OFF      
 END  
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[Superbill_ClaimNote_EKOS_Update]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[Superbill_ClaimNote_EKOS_Update] 
   ON  [dbo].[Superbill] 
   AFTER UPDATE
AS 
BEGIN

IF @@ROWCOUNT = 0  
RETURN

 IF dbo.IsCacheClient() = 0  
 BEGIN  
  SET NOCOUNT ON   

 IF NOT  EXISTS (select * 
				 from TransmissionConfiguration tc WITH(NOLOCK)
                 inner join ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
			     where tc.TransmissionType = ''EKOS'' and
					   lip.Inactive = 0 )
		RETURN;
  
  DECLARE @SuperbillUid UNIQUEIDENTIFIER    

  --SYSTEM DEFINED GUID FOR READY TO SUBMIT
  DECLARE @ReadyToSubmitSuperbillStatusUid uniqueidentifier = ''55ED3239-89F3-4488-89C9-71BE5A541CC4''
  --SYSTEM DEFINED GUID FOR READY TO REVIEW
  DECLARE @ReadyToReviewSuperbillStatusUid uniqueidentifier =''D2291C14-3F4E-4381-80A7-883C76C9499B''
  --SYSTEM DEFINED GUID FOR PRELIMINARY 
  DECLARE @PreliminarySuperbillStatusUid uniqueidentifier =''DF81BE7C-71CF-47F4-8573-733E81E30EA8''
  --SYSTEM DEFINED GUID FOR REJECTED
  DECLARE @RejectedSuperbillStatusUid uniqueidentifier = ''2C4A6E7D-EB6D-4370-A836-5937363C6B69'' 
  --SYSTEM DEFINED GUID FOR ERAREJECTED
  DECLARE @EraRejectedSuperbillStatusUid uniqueidentifier = ''2352F0FB-708B-437E-9809-F80128195F9E''
  --SYSTEM DEFINED GUID FOR FILED
  DECLARE @FiledSuperbillStatusUid uniqueidentifier =''9FFE6214-7C7F-4516-9899-43D37FABE21D''
   --SYSTEM DEFINED GUID FOR COMPLETE
   DECLARE @CompleteSuperbillStatusUid uniqueidentifier = ''30F64D66-55CB-4438-BB2F-7A6250399312''  
   		--SYSTEM DEFINED GUID FOR REFILED
   DECLARE @RefiledSuperbillStatusUid uniqueidentifier = ''A8258278-7182-45DC-869F-790F46F2C177''
		--SYSTEM DEFINED GUID FOR PENDING PATIENT PAYMENT
   DECLARE @PendingPatientPaymentSuperbillStatusUid uniqueidentifier = ''D2BF0F3C-6E03-478F-BDAE-4DCAC5EB9410''

  DECLARE @ExcludeFinancialCenter VARCHAR(MAX) = NULL
  DECLARE @ExcludeSuperbills TABLE (SuperbillUid UNIQUEIDENTIFIER)

	SELECT @ExcludeFinancialCenter = CONVERT(XML, AdditionalOutboundXML).value(''(//FinancialCentersOptOut)[1]'',''VARCHAR(MAX)'')
	FROM ListIntegrationPartner WHERE IntegrationPartnerUid = ''20C576DF-A670-4A58-85DE-CAA4BA5151E0''

	INSERT INTO @ExcludeSuperbills
	SELECT i.SuperbillUid
	from INSERTED i
	INNER JOIN SuperbillProcedure SP WITH(NOLOCK) ON  SP.SuperbillUid = i.SuperbillUid
	INNER JOIN AR_LedgerDetail ARLD WITH(NOLOCK) ON ARLD.SuperbillProcedureUid= SP.SuperbillProcedureUid AND ((ARLD.FinancialCenterUid IN (SELECT element FROM dbo.Split(@ExcludeFinancialCenter,'',''))))
	INNER JOIN AR_Ledger ARL WITH(NOLOCK) ON ARLD.LedgerUid=ARL.LedgerUid

	--only interested in Superbills where status is  Ready To Submit, Preliminary, Ready to Review, Filed, ERA Rejected,Rejected, Complete, Refiled, Pending patient payment

	--ADD EKOS Generic status
  DECLARE @superbillstatus table (MapFromSuperbillStatusUid uniqueidentifier,MapToSuperbillStatusUid uniqueidentifier)
 
  INSERT INTO @superbillstatus (MapFromSuperbillStatusUid) values (@PreliminarySuperbillStatusUid),(@ReadyToReviewSuperbillStatusUid),(@ReadyToSubmitSuperbillStatusUid),(@EraRejectedSuperbillStatusUid),
  (@RejectedSuperbillStatusUid),(@FiledSuperbillStatusUid), (@CompleteSuperbillStatusUid),(@RefiledSuperbillStatusUid),(@PendingPatientPaymentSuperbillStatusUid)

    --Add Mapped Superbill Status
  INSERT INTO @superbillstatus (MapFromSuperbillStatusUid, MapToSuperbillStatusUid)
  SELECT DISTINCT  MI.FindTableFromItemUid, mi.FindTableToItemUid
  from  MapItem MI WITH(NOLOCK)
  JOIN MapSource MS WITH(NOLOCK) ON MI.MapSourceUid=MS.MapSourceUid AND MS.MapSourceUid=''ACB1C24D-992C-4DDC-ACEE-4BBE84C0FD5A'' AND MS.Inactive=0
  JOIN @superbillstatus LS ON MI.FindTableToItemUid=LS.MapFromSuperbillStatusUid  AND mi.FindTableFromItemUid IS NOT NULL 




    DECLARE @Superbills TABLE (SuperbillUid UNIQUEIDENTIFIER, SuperbillStatusUid UNIQUEIDENTIFIER, PatientUid UNIQUEIDENTIFIER, LastModifiedByUid UNIQUEIDENTIFIER)
	INSERT INTO @Superbills
	SELECT DISTINCT i.SuperbillUid, i.SuperbillStatusUid, i.PatientUid, i.LastModifiedByUid
					FROM inserted i
					INNER JOIN deleted d ON i.SuperbillUid=d.SuperbillUid
					INNER JOIN @superbillstatus  ls on i.SuperbillStatusUid=ls.MapFromSuperbillStatusUid
					LEFT JOIN @ExcludeSuperbills ex on i.SuperbillUid = ex.SuperbillUid
					WHERE i.ClaimNote<>d.ClaimNote
					AND ex.SuperbillUid IS NULL


  IF NOT  EXISTS (	SELECT 1 FROM @Superbills)
	RETURN;
	BEGIN
   
	DELETE TransmissionOutbound where TransmissionOutboundUid in  
	(  SELECT TransmissionOutboundUid  
		FROM TransmissionOutbound tod WITH(NOLOCK)
		WHERE tod.ForeignObjectUid =@SuperbillUid and 
		      tod.Description IN (''SUPERBILLCLAIMNOTE'',''SUPERBILLDELETE'') and
			  tod.TransmissionType=''EKOS'' and
			  tod.Status <>100
	)   
      
     -- FOR EKOS SUPERBILLCLAIM NOTE API PUT   
	INSERT INTO TransmissionOutbound (TransmissionType,Description ,ForeignObjectUid, RawMessage, PatientUid, lastmodifiedbyuid, LastModifiedDate)  
	SELECT  tc.TransmissionType, ''SUPERBILLCLAIMNOTE'',i.SuperbillUid, ''iMedica.Prm.BusinessObject.Superbill'',i.PatientUid,i.LastModifiedByUid, GETUTCDATE() 
				FROM TransmissionConfiguration tc WITH(NOLOCK)
                 inner join ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
				 cross join @Superbills i
			     WHERE tc.TransmissionType = ''EKOS'' and
					   lip.Inactive = 0 
     
	     
 END  

END

END' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[SuperBill_DFT]'))
EXEC dbo.sp_executesql @statement = N'

 
  
CREATE TRIGGER [dbo].[SuperBill_DFT] ON [dbo].[Superbill]   
FOR INSERT, UPDATE  
/* Purpose: Used to track inserts made to the Superbill table for HL7 */  
AS  
BEGIN  

IF @@ROWCOUNT = 0  
RETURN   

IF NOT EXISTS (SELECT * FROM listproductparameter WHERE parametername = ''addsuperbillcharges'' AND boolvalue = 1)
   BEGIN
      --option not set
      Return
   END
 
 IF dbo.IsCacheClient() = 0  
 BEGIN  
  SET NOCOUNT ON   
  
  DECLARE @VisitUid UNIQUEIDENTIFIER  
  DECLARE @AppointmentUid UNIQUEIDENTIFIER    
  DECLARE @DFTTable TABLE    
  (    
   partnerMessageID VARCHAR(50) --Array element contents    
  )    
  

  INSERT INTO @DFTTable  
  Select PM.HL7PartnerMessageUid from HL7partner P   
  LEFT JOIN HL7PartnerMessage PM ON PM.HL7partnerUid=P.HL7partnerUid  
  where PM.MessageType = ''DFT''   
  and PM.Inactive = 0    
  and P.Inactive = 0   
  and PM.Send = 1  

  if not exists (select * from @DFTTable)
	return
  
  DECLARE DFT_CUR CURSOR FAST_FORWARD LOCAL FOR   
    SELECT VisitUid, AppointmentUid FROM INSERTED   
  DECLARE @COMPLETEDTIME DATETIME  
  
  DECLARE @sendDFTonReadyToSubmit INT  
  SELECT @sendDFTonReadyToSubmit = 0  
  
  SELECT TOP 1 @sendDFTonReadyToSubmit = isnull(BoolValue,0)  
  FROM ListProductParameter   
  WHERE ParameterName = ''SendDFTonReadyToSubmit''  
   
  OPEN DFT_CUR  
  
  FETCH NEXT FROM DFT_CUR INTO @VisitUid, @AppointmentUid  
    
  WHILE @@FETCH_STATUS =0  
  BEGIN    
   IF (@sendDFTonReadyToSubmit = 1) AND   
   EXISTS (SELECT * FROM INSERTED WHERE VISITUID = @VISITUID AND SuperbillStatusUid in   
   (select SuperbillStatusUid from ListSuperbillStatus where Name NOT LIKE ''%Ready to Submit%''))  
   BEGIN  
    GOTO NEXT_LOOP  
   END  
     
   delete hl7actiontypeobject where hl7actiontypeobjectuid in  
   (  select hl7actiontypeobjectuid  
    from hl7actiontypeobject ato  
    join @dfttable d on ato.hl7partnermessageuid = d.partnermessageid  
    where ato.objectuid = @visituid and ato.actiontype = ''ChargePatient'' and ato.objecttype = ''Visit''  
   )  
   delete hl7actiontypeobject where hl7actiontypeobjectuid in  
   (  select hl7actiontypeobjectuid  
    from hl7actiontypeobject ato  
    where ato.objectuid = @AppointmentUid and ato.actiontype = ''InsertVisitPatient'' and ato.objecttype = ''Appointment''  
   )   
      
   INSERT HL7ActionTypeObject(HL7PartnerMessageUid, ActionType, ObjectUid, ObjectType, LastModifiedByUid)  
   SELECT pm.HL7PartnerMessageUid, ''InsertVisitPatient'', S.AppointmentUid, ''Appointment'', i.LastModifiedByUid  
   FROM HL7PartnerMessage pm INNER JOIN HL7Partner p ON pm.HL7PartnerUid = p.HL7PartnerUid  
     CROSS JOIN inserted i   
     LEFT JOIN ViewActionTypeObjectPartnerMessage atopm ON i.VisitUid = atopm.ObjectUid AND atopm.ObjectType=''Patient'' AND pm.HL7PartnerUid = atopm.HL7PartnerUid AND atopm.SendFunction IN (''InsertVisitPatient'')  
     INNER JOIN Visit S on S.VisitUid = i.VisitUid AND S.SuperbillRequired=1 AND S.IsCompleted=1  
   WHERE pm.SendFunction = ''InsertVisitPatient'' AND  
     pm.Send = 1 AND  
     pm.Inactive = 0 AND  
     p.Inactive = 0 AND  
     atopm.HL7ActionTypeObjectUid IS NULL  
          
   INSERT INTO HL7ActionTypeObject (HL7ActionTypeObjectUid, HL7PartnerMessageUid, ActionType, ObjectType,ObjectUid, LastModifiedDate)  
   Select NEWID(), partnerMessageID, ''ChargePatient'',''Visit'', @VisitUid, GETUTCDATE() From @DFTTable  
     
   -- UPDATE Visit SET SuperbillStatusID = 2 WHERE VisitUid = @VisitUid       
    
   NEXT_LOOP:  
   FETCH NEXT FROM DFT_CUR INTO @VisitUid, @AppointmentUid  
  END  
    
  CLOSE DFT_CUR  
  DEALLOCATE DFT_CUR  
  
  SET NOCOUNT OFF      
 END  
END 

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[Superbill_InsteadOf_Delete]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[Superbill_InsteadOf_Delete] ON [dbo].[Superbill]
INSTEAD OF DELETE
AS
BEGIN
	SET NOCOUNT ON;

	DECLARE @originatorId VARBINARY(128);
	SELECT @originatorId = dbo.GetChangeTrackingContextFromContextInfo();

	WITH CHANGE_TRACKING_CONTEXT(@originatorId)
	DELETE FROM SuperbillProcedure WHERE SuperbillUid IN
		(SELECT SuperbillUid FROM Deleted);
			
	WITH CHANGE_TRACKING_CONTEXT(@originatorId)	
	DELETE FROM Superbill WHERE SuperbillUid IN
		(SELECT SuperbillUid FROM Deleted);
	
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[Superbill_ReadytoSubmit]'))
EXEC dbo.sp_executesql @statement = N'
CREATE TRIGGER [dbo].[Superbill_ReadytoSubmit] ON [dbo].[Superbill]   
FOR INSERT, UPDATE  
/* Purpose: Send charges send superbill status is changed to ready to submit */  
AS  
BEGIN  

IF @@ROWCOUNT = 0  
RETURN 

IF EXISTS (SELECT * FROM inserted AS i WHERE i.ServiceDateStart < ''2014-06-09'') --Bug #29795
RETURN


IF NOT EXISTS (SELECT * FROM listproductparameter WHERE parametername = ''SendDFTonReadyToSubmit'' AND boolvalue = 1)
   BEGIN
      --option not set
      Return
   END


       DECLARE @resetReadyToSubmit INT
       SELECT @resetReadyToSubmit = 0 
              
       SELECT @resetReadyToSubmit =  isnull(BoolValue,0)
       FROM ListProductParameter 
       WHERE ParameterName = ''ResetReadyToSubmitAfterSend''
              

IF dbo.IsCacheClient() = 0  
 BEGIN  
  SET NOCOUNT ON  

  DECLARE @Superbilluid UNIQUEIDENTIFIER
  DECLARE @SuperbillStatusuid UNIQUEIDENTIFIER
  DECLARE @Visituid UNIQUEIDENTIFIER 
  
       DECLARE @DFTTable TABLE  
       (  
        partnerMessageID VARCHAR(50) --Array element contents  
       )  

              INSERT INTO @DFTTable
              Select PM.HL7PartnerMessageUid from HL7partner P LEFT JOIN HL7PartnerMessage PM
              ON
              PM.HL7partnerUid=P.HL7partnerUid
              where 
              PM.MessageType = ''DFT'' 
              and PM.Inactive = 0  
              and P.Inactive = 0 
              and PM.Send = 1
              and PM.SendFunction = ''VisitCharges''

if not exists (select * from @DFTTable)
       Begin
       --not set to send DFT
              return
       End
  

  DECLARE DFT_CUR CURSOR FAST_FORWARD LOCAL FOR   
  SELECT i.Superbilluid, i.SuperbillStatusUid, i.VisitUid  
  FROM INSERTED i   
  left join deleted d on i.superbilluid = d.superbilluid
  join listsuperbillstatus lssN on i.superbillstatusuid = lssN.superbillstatusuid and lssN.actionname = ''Ready to Submit''
  left join listsuperbillstatus lssD on lssd.SuperbillStatusUid = d.superbillstatusuid 
  where i.VisitUid is not null
   --comment this out b/c it was perventing addendums, this could cause mulitple sending of DFT''s -BW
  --and (d.superbilluid is null or (d.superbilluid is not null and lssD.actionname != ''Ready to Submit''))

    
  OPEN DFT_CUR  
  FETCH NEXT FROM DFT_CUR INTO @Superbilluid, @SuperbillStatusuid, @Visituid  
  WHILE @@FETCH_STATUS =0  
       BEGIN   
			IF EXISTS (select * from Superbill where VisitUid = @Visituid and DFTQueuedDateTime  is not null and @resetReadyToSubmit = 1)
				OR EXISTS (SELECT 1 FROM Superbill WHERE VisitUid = @VisitUid AND ServiceDateStart < DATEADD(MONTH, -18, GETUTCDATE()))
			BEGIN
				GOTO NEXT_LOOP
			END
                                  
            --delete any rows in hl7actiontypeobject that match the ones we are about to create
            delete hl7actiontypeobject where hl7actiontypeobjectuid in
                (      select hl7actiontypeobjectuid
                        from hl7actiontypeobject ato
                        join @dfttable d on ato.hl7partnermessageuid = d.partnermessageid
                        where ato.objectuid = @visituid 
                                                and ato.actiontype = ''ChargePatient'' and ato.objecttype = ''Visit''
                )
              
            INSERT INTO HL7ActionTypeObject (HL7ActionTypeObjectUid, HL7PartnerMessageUid, ActionType, ObjectType,ObjectUid, LastModifiedDate)
            -- Removed as this is old method of replication(2009) as advised by Kevin : 02/15/11  OUTPUT NEWID(), ''I'', ''HL7ActionTypeObject'', inserted.HL7ActionTypeObjectUid, GETUTCDATE() INTO ReplicationExternalChangeQueue    
            Select NEWID(), partnerMessageID, ''ChargePatient'',''Visit'', @VisitUid, GETUTCDATE() From @DFTTable   
     
            Update Superbill set DFTQueuedDateTime = GETUTCDATE(), LastModifiedDate = GETUTCDATE()
            where VisitUid = @VisitUid
                     
            NEXT_LOOP:   
			FETCH NEXT FROM DFT_CUR INTO @Superbilluid, @SuperbillStatusuid, @Visituid  
       END  
    
  CLOSE DFT_CUR  
  DEALLOCATE DFT_CUR  
  
  SET NOCOUNT OFF   
  End   
 END ' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[Superbill_Update_TrackSuperbillStatusChange]'))
EXEC dbo.sp_executesql @statement = N'
CREATE TRIGGER [dbo].[Superbill_Update_TrackSuperbillStatusChange] ON [dbo].[Superbill]   
FOR UPDATE  
AS  
BEGIN  

	INSERT INTO Superbill_TrackSuperbillStatusChange(SuperbillUid, FromSuperbillStatusUid,
			ToSuperbillStatusUid, LastModifiedByUid, LastModifiedDate)
	SELECT I.SuperbillUid, D.SuperbillStatusUid AS FromSuperbillStatusUid, 
			I.SuperbillStatusUid AS ToSuperbillStatusUid,
			I.LastModifiedByUid, GETUTCDATE()
		FROM inserted I
			INNER JOIN deleted D ON I.SuperbillUid = D.SuperbillUid
		WHERE I.SuperbillStatusUid <> D.SuperbillStatusUid
	
END

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[EKOS_SuperbillClaim_SBDiag_Delete]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[EKOS_SuperbillClaim_SBDiag_Delete] ON [dbo].[SuperbillDiagnosis] FOR DELETE AS
BEGIN

IF @@ROWCOUNT = 0  
RETURN  

 IF dbo.IsCacheClient() = 0  
 BEGIN  
  SET NOCOUNT ON   
    
   IF NOT EXISTS (SELECT * 
				 FROM TransmissionConfiguration tc WITH(NOLOCK)
                 INNER JOIN ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
			     WHERE tc.TransmissionType = ''EKOS'' AND
					   lip.Inactive = 0 )
  RETURN;
  
  DECLARE @ExcludeFinancialCenter VARCHAR(MAX) = NULL
  DECLARE @ExcludeSuperbills TABLE (SuperbillUid UNIQUEIDENTIFIER)

	 SELECT @ExcludeFinancialCenter = CONVERT(XML, AdditionalOutboundXML).value(''(//FinancialCentersOptOut)[1]'',''VARCHAR(MAX)'')
	FROM ListIntegrationPartner WHERE IntegrationPartnerUid = ''20C576DF-A670-4A58-85DE-CAA4BA5151E0''

	INSERT INTO @ExcludeSuperbills
	SELECT i.SuperbillUid
	from DELETED i
	INNER JOIN SuperbillProcedure SP WITH(NOLOCK) ON  SP.SuperbillUid = i.SuperbillUid
	INNER JOIN AR_LedgerDetail ARLD WITH(NOLOCK) ON ARLD.SuperbillProcedureUid= SP.SuperbillProcedureUid AND ((ARLD.FinancialCenterUid IN (SELECT element FROM dbo.Split(@ExcludeFinancialCenter,'',''))))
	INNER JOIN AR_Ledger ARL WITH(NOLOCK) ON ARLD.LedgerUid=ARL.LedgerUid

  --SYSTEM DEFINED GUID FOR READY TO SUBMIT
  DECLARE @ReadyToSubmitSuperbillStatusUid uniqueidentifier = ''55ED3239-89F3-4488-89C9-71BE5A541CC4''
  --SYSTEM DEFINED GUID FOR READY TO REVIEW
  DECLARE @ReadyToReviewSuperbillStatusUid uniqueidentifier =''D2291C14-3F4E-4381-80A7-883C76C9499B''
  --SYSTEM DEFINED GUID FOR PRELIMINARY 
  DECLARE @PreliminarySuperbillStatusUid uniqueidentifier =''DF81BE7C-71CF-47F4-8573-733E81E30EA8''
  --SYSTEM DEFINED GUID FOR REJECTED
  DECLARE @RejectedSuperbillStatusUid uniqueidentifier = ''2C4A6E7D-EB6D-4370-A836-5937363C6B69'' 
  --SYSTEM DEFINED GUID FOR ERAREJECTED
  DECLARE @EraRejectedSuperbillStatusUid uniqueidentifier = ''2352F0FB-708B-437E-9809-F80128195F9E''
  --SYSTEM DEFINED GUID FOR FILED
  DECLARE @FiledSuperbillStatusUid uniqueidentifier =''9FFE6214-7C7F-4516-9899-43D37FABE21D''
  --SYSTEM DEFINED GUID FOR COMPLETE
  DECLARE @CompleteSuperbillStatusUid uniqueidentifier = ''30F64D66-55CB-4438-BB2F-7A6250399312''  
  --SYSTEM DEFINED GUID FOR REFILED
  DECLARE @RefiledSuperbillStatusUid uniqueidentifier = ''A8258278-7182-45DC-869F-790F46F2C177''
  --SYSTEM DEFINED GUID FOR PENDING PATIENT PAYMENT
  DECLARE @PendingPatientPaymentSuperbillStatusUid uniqueidentifier = ''D2BF0F3C-6E03-478F-BDAE-4DCAC5EB9410''


  

  DECLARE @superbillstatus table (MapFromSuperbillStatusUid uniqueidentifier,MapToSuperbillStatusUid uniqueidentifier)
 
 --ADD EKOS Generic status
  INSERT INTO @superbillstatus (MapFromSuperbillStatusUid) values (@PreliminarySuperbillStatusUid),(@ReadyToReviewSuperbillStatusUid),(@ReadyToSubmitSuperbillStatusUid),(@EraRejectedSuperbillStatusUid),
  (@RejectedSuperbillStatusUid),(@FiledSuperbillStatusUid) , (@CompleteSuperbillStatusUid),(@RefiledSuperbillStatusUid),(@PendingPatientPaymentSuperbillStatusUid)

     --Add Mapped Superbill Status
  INSERT INTO @superbillstatus (MapFromSuperbillStatusUid, MapToSuperbillStatusUid)
  SELECT DISTINCT  MI.FindTableFromItemUid, mi.FindTableToItemUid
  from  MapItem MI WITH(NOLOCK)
  JOIN MapSource MS WITH(NOLOCK) ON MI.MapSourceUid=MS.MapSourceUid AND MS.MapSourceUid=''ACB1C24D-992C-4DDC-ACEE-4BBE84C0FD5A'' AND MS.Inactive=0
  JOIN @superbillstatus LS ON MI.FindTableToItemUid=LS.MapFromSuperbillStatusUid  AND mi.FindTableFromItemUid IS NOT NULL 


    DECLARE @Superbills TABLE (SuperbillUid UNIQUEIDENTIFIER, SuperbillStatusUid UNIQUEIDENTIFIER, PatientUid UNIQUEIDENTIFIER, LastModifiedByUid UNIQUEIDENTIFIER)
	INSERT INTO @Superbills
	SELECT  DISTINCT d.SuperbillUid, s.SuperbillStatusUid, s.PatientUid, d.LastModifiedByUid
	FROM deleted d
		JOIN Superbill s WITH(NOLOCK) on d.SuperbillUid = s.SuperbillUid
		Join @superbillstatus ls on s.SuperbillStatusUid=ls.MapFromSuperbillStatusUid
		LEFT JOIN @ExcludeSuperbills ex on d.SuperbillUid = ex.SuperbillUid
	WHERE ex.SuperbillUid IS NULL
						

	--	--only interested in Superbills where status is  Ready To Submit, Preliminary, Ready to Review, Filed, ERA Rejected,Rejected, completed
	--  EXLUDED SUPERBILL COMPLETE STATUS 

	IF NOT  EXISTS (SELECT 1 FROM @Superbills)
	
	RETURN;


	BEGIN
	
	DELETE TransmissionOutbound where TransmissionOutboundUid in  
			(  
				SELECT TransmissionOutboundUid  
				from TransmissionOutbound tod WITH(NOLOCK)
				INNER JOIN @Superbills s on tod.ForeignObjectUid = s.SuperbillUid 
						WHERE tod.Description IN (''SUPERBILLCLAIM'',''SUPERBILLDELETE'')
						AND tod.TransmissionType=''EKOS''
						AND tod.Status <> 100
			)

      -- FOR SUPERBILL CLAIM PUT API CALL     
	INSERT INTO TransmissionOutbound (TransmissionType,Description ,ForeignObjectUid, RawMessage, PatientUid, lastmodifiedbyuid, LastModifiedDate)  
	SELECT  tc.TransmissionType, ''SUPERBILLCLAIM'',i.SuperbillUid, ''iMedica.Prm.BusinessObject.Superbill'',s.PatientUid,i.LastModifiedByUid, GETUTCDATE()  
				 from TransmissionConfiguration tc WITH(NOLOCK)
                 INNER JOIN ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
				 CROSS JOIN @Superbills i
				 JOIN Superbill s on i.SuperbillUid = s.SuperbillUid
			     WHERE tc.TransmissionType = ''EKOS'' and
					   lip.Inactive = 0 

  
  END  
  
     
 END  
END' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[EKOS_SuperbillClaim_SBDiag_InsertUpdate]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[EKOS_SuperbillClaim_SBDiag_InsertUpdate] ON [dbo].[SuperbillDiagnosis]   
FOR INSERT, UPDATE  

AS  
BEGIN  

IF @@ROWCOUNT = 0  
RETURN  

 IF dbo.IsCacheClient() = 0  
 BEGIN  
  SET NOCOUNT ON   
  
    IF NOT  EXISTS  (select * 
				 from TransmissionConfiguration tc WITH(NOLOCK)
                 inner join ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
			     where tc.TransmissionType = ''EKOS'' and
					   lip.Inactive = 0 )
    RETURN;


  DECLARE @SuperbillProcUid UNIQUEIDENTIFIER    
  DECLARE @SuperbillUid UNIQUEIDENTIFIER 

  --SYSTEM DEFINED GUID FOR READY TO SUBMIT
 DECLARE @ReadyToSubmitSuperbillStatusUid uniqueidentifier = ''55ED3239-89F3-4488-89C9-71BE5A541CC4''
  --SYSTEM DEFINED GUID FOR READY TO REVIEW
  DECLARE @ReadyToReviewSuperbillStatusUid uniqueidentifier =''D2291C14-3F4E-4381-80A7-883C76C9499B''
  --SYSTEM DEFINED GUID FOR PRELIMINARY 
  DECLARE @PreliminarySuperbillStatusUid uniqueidentifier =''DF81BE7C-71CF-47F4-8573-733E81E30EA8''
  --SYSTEM DEFINED GUID FOR REJECTED
  DECLARE @RejectedSuperbillStatusUid uniqueidentifier = ''2C4A6E7D-EB6D-4370-A836-5937363C6B69'' 
  --SYSTEM DEFINED GUID FOR ERAREJECTED
  DECLARE @EraRejectedSuperbillStatusUid uniqueidentifier = ''2352F0FB-708B-437E-9809-F80128195F9E''
  --SYSTEM DEFINED GUID FOR FILED
  DECLARE @FiledSuperbillStatusUid uniqueidentifier =''9FFE6214-7C7F-4516-9899-43D37FABE21D''
  	-- SYSTEM DEFINED GUID FOR CANCELED
 --DECLARE @CanceledSuperbillStatusUid uniqueidentifier=''FC8AD61B-139A-4CFA-9580-CDACFC3ACF90''
         --SYSTEM DEFINED GUID FOR COMPLETE
  DECLARE @CompleteSuperbillStatusUid uniqueidentifier = ''30F64D66-55CB-4438-BB2F-7A6250399312''
  		--SYSTEM DEFINED GUID FOR REFILED
  DECLARE @RefiledSuperbillStatusUid uniqueidentifier = ''A8258278-7182-45DC-869F-790F46F2C177''
		--SYSTEM DEFINED GUID FOR PENDING PATIENT PAYMENT
  DECLARE @PendingPatientPaymentSuperbillStatusUid uniqueidentifier = ''D2BF0F3C-6E03-478F-BDAE-4DCAC5EB9410''

  DECLARE @ExcludeFinancialCenter VARCHAR(MAX) = NULL
  DECLARE @ExcludeSuperbills TABLE (SuperbillUid UNIQUEIDENTIFIER)

	SELECT @ExcludeFinancialCenter = CONVERT(XML, AdditionalOutboundXML).value(''(//FinancialCentersOptOut)[1]'',''VARCHAR(MAX)'')
	FROM ListIntegrationPartner WHERE IntegrationPartnerUid = ''20C576DF-A670-4A58-85DE-CAA4BA5151E0''

	INSERT INTO @ExcludeSuperbills
	SELECT i.SuperbillUid
	from INSERTED i
	INNER JOIN SuperbillProcedure SP WITH(NOLOCK) ON  SP.SuperbillUid = i.SuperbillUid
	INNER JOIN AR_LedgerDetail ARLD WITH(NOLOCK) ON ARLD.SuperbillProcedureUid= SP.SuperbillProcedureUid AND ((ARLD.FinancialCenterUid IN (SELECT element FROM dbo.Split(@ExcludeFinancialCenter,'',''))))
	INNER JOIN AR_Ledger ARL WITH(NOLOCK) ON ARLD.LedgerUid=ARL.LedgerUid 

  --ADD EKOS Generic status
  DECLARE @superbillstatus table (MapFromSuperbillStatusUid uniqueidentifier,MapToSuperbillStatusUid uniqueidentifier)

  INSERT INTO @superbillstatus (MapFromSuperbillStatusUid) values (@PreliminarySuperbillStatusUid),(@ReadyToReviewSuperbillStatusUid),(@ReadyToSubmitSuperbillStatusUid),(@EraRejectedSuperbillStatusUid),
  (@RejectedSuperbillStatusUid),(@FiledSuperbillStatusUid),(@CompleteSuperbillStatusUid),(@RefiledSuperbillStatusUid),(@PendingPatientPaymentSuperbillStatusUid)
  
  
    --Add Mapped Superbill Status
  INSERT INTO @superbillstatus (MapFromSuperbillStatusUid, MapToSuperbillStatusUid)
  SELECT DISTINCT  MI.FindTableFromItemUid, mi.FindTableToItemUid
  from  MapItem MI WITH(NOLOCK)
  JOIN MapSource MS WITH(NOLOCK) ON MI.MapSourceUid=MS.MapSourceUid AND MS.MapSourceUid=''ACB1C24D-992C-4DDC-ACEE-4BBE84C0FD5A'' AND MS.Inactive=0
  JOIN @superbillstatus LS ON MI.FindTableToItemUid=LS.MapFromSuperbillStatusUid  AND mi.FindTableFromItemUid IS NOT NULL 
  

        DECLARE @Superbills TABLE (SuperbillUid UNIQUEIDENTIFIER, SuperbillStatusUid UNIQUEIDENTIFIER, PatientUid UNIQUEIDENTIFIER, LastModifiedByUid UNIQUEIDENTIFIER)
		INSERT INTO @Superbills
		SELECT DISTINCT s.SuperbillUid, s.SuperbillStatusUid, s.PatientUid, i.LastModifiedByUid
		FROM INSERTED i
		INNER JOIN Superbill s WITH(NOLOCK) on i.SuperbillUid = s.SuperbillUid
		INNER JOIN @superbillstatus ls on s.SuperbillStatusUid=ls.MapFromSuperbillStatusUid
		LEFT JOIN @ExcludeSuperbills ex on i.SuperbillUid = ex.SuperbillUid
		WHERE ex.SuperbillUid IS NULL


		--only interested in Superbills where status is  Ready To Submit, Preliminary, Ready to Review, Filed, ERA Rejected,Rejected,Compelete

	IF NOT  EXISTS (SELECT 1 FROM @Superbills)

	RETURN;
	BEGIN

	DELETE TransmissionOutbound where TransmissionOutboundUid in  
			(  
				SELECT TransmissionOutboundUid  
				FROM TransmissionOutbound tod WITH(NOLOCK)
				INNER JOIN @Superbills s on tod.ForeignObjectUid = s.SuperbillUid 
						WHERE tod.Description IN (''SUPERBILLDELETE'',''SUPERBILLCLAIM'')
						AND tod.TransmissionType=''EKOS''
						AND tod.Status <> 100
			)   

    
	--FOR SUPERBILLCLAIM PUT API CALL     
	INSERT INTO TransmissionOutbound (TransmissionType,Description ,ForeignObjectUid, RawMessage, PatientUid, lastmodifiedbyuid, LastModifiedDate)  
	SELECT  tc.TransmissionType, ''SUPERBILLCLAIM'',i.SuperbillUid, ''iMedica.Prm.BusinessObject.Superbill'',s.PatientUid,i.LastModifiedByUid, GETUTCDATE()  
				 FROM TransmissionConfiguration tc WITH(NOLOCK)
                 INNER JOIN ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
				 CROSS JOIN @Superbills i
				 INNER JOIN Superbill s WITH(NOLOCK) on i.SuperbillUid = s.SuperbillUid
			     WHERE tc.TransmissionType = ''EKOS'' and
					   lip.Inactive = 0 
					     -- and I.SuperbillStatusUid <>@CanceledSuperbillStatusUid
     
END     
 END  

 END' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[EKOS_SuperbillClaim_SBProc_Delete]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[EKOS_SuperbillClaim_SBProc_Delete] ON [dbo].[SuperbillProcedure]   
FOR DELETE  

AS  
BEGIN  

IF @@ROWCOUNT = 0  
RETURN

 IF dbo.IsCacheClient() = 0  
 BEGIN  
  SET NOCOUNT ON   
    
   IF NOT EXISTS (SELECT * 
				 FROM TransmissionConfiguration tc WITH(NOLOCK)
                 INNER JOIN ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
			     WHERE tc.TransmissionType = ''EKOS'' AND
					   lip.Inactive = 0 )
  RETURN;
  

  --SYSTEM DEFINED GUID FOR READY TO SUBMIT
  DECLARE @ReadyToSubmitSuperbillStatusUid uniqueidentifier = ''55ED3239-89F3-4488-89C9-71BE5A541CC4''
  --SYSTEM DEFINED GUID FOR READY TO REVIEW
  DECLARE @ReadyToReviewSuperbillStatusUid uniqueidentifier =''D2291C14-3F4E-4381-80A7-883C76C9499B''
  --SYSTEM DEFINED GUID FOR PRELIMINARY 
  DECLARE @PreliminarySuperbillStatusUid uniqueidentifier =''DF81BE7C-71CF-47F4-8573-733E81E30EA8''
  --SYSTEM DEFINED GUID FOR REJECTED
  DECLARE @RejectedSuperbillStatusUid uniqueidentifier = ''2C4A6E7D-EB6D-4370-A836-5937363C6B69'' 
  --SYSTEM DEFINED GUID FOR ERAREJECTED
  DECLARE @EraRejectedSuperbillStatusUid uniqueidentifier = ''2352F0FB-708B-437E-9809-F80128195F9E''
  --SYSTEM DEFINED GUID FOR FILED
  DECLARE @FiledSuperbillStatusUid uniqueidentifier =''9FFE6214-7C7F-4516-9899-43D37FABE21D''
        --SYSTEM DEFINED GUID FOR COMPLETE
  DECLARE @CompleteSuperbillStatusUid uniqueidentifier = ''30F64D66-55CB-4438-BB2F-7A6250399312''  
  --SYSTEM DEFINED GUID FOR REFILED
  DECLARE @RefiledSuperbillStatusUid uniqueidentifier = ''A8258278-7182-45DC-869F-790F46F2C177''
  --SYSTEM DEFINED GUID FOR PENDING PATIENT PAYMENT
  DECLARE @PendingPatientPaymentSuperbillStatusUid uniqueidentifier = ''D2BF0F3C-6E03-478F-BDAE-4DCAC5EB9410''
  
  DECLARE @superbillstatus table (MapFromSuperbillStatusUid uniqueidentifier,MapToSuperbillStatusUid uniqueidentifier)

  DECLARE @ExcludeFinancialCenter VARCHAR(MAX) = NULL
  DECLARE @ExcludeSuperbills TABLE (SuperbillUid UNIQUEIDENTIFIER)

	SELECT @ExcludeFinancialCenter = CONVERT(XML, AdditionalOutboundXML).value(''(//FinancialCentersOptOut)[1]'',''VARCHAR(MAX)'')
	FROM ListIntegrationPartner WITH(NOLOCK) WHERE IntegrationPartnerUid = ''20C576DF-A670-4A58-85DE-CAA4BA5151E0''
	
	IF @ExcludeFinancialCenter IS NULL
		SET @ExcludeFinancialCenter = ''6C392503-ADF7-47B5-8991-E6F073DD1A93,97F221F8-30F6-4F7B-AAA1-6F805ADCDEC1'' --Collection Module and SP- Alliance Pediatrics

	INSERT INTO @ExcludeSuperbills
	SELECT i.SuperbillUid
	from DELETED i
	INNER JOIN SuperbillProcedure SP WITH(NOLOCK) ON  SP.SuperbillUid = i.SuperbillUid
	INNER JOIN AR_LedgerDetail ARLD WITH(NOLOCK) ON ARLD.SuperbillProcedureUid= SP.SuperbillProcedureUid AND ((ARLD.FinancialCenterUid IN (SELECT element FROM dbo.Split(@ExcludeFinancialCenter,'',''))))
	INNER JOIN AR_Ledger ARL WITH(NOLOCK) ON ARLD.LedgerUid=ARL.LedgerUid
 
 --ADD EKOS Generic status
  INSERT INTO @superbillstatus (MapFromSuperbillStatusUid) values (@PreliminarySuperbillStatusUid),(@ReadyToReviewSuperbillStatusUid),(@ReadyToSubmitSuperbillStatusUid),(@EraRejectedSuperbillStatusUid),
  (@RejectedSuperbillStatusUid),(@FiledSuperbillStatusUid) , (@CompleteSuperbillStatusUid),(@RefiledSuperbillStatusUid),(@PendingPatientPaymentSuperbillStatusUid)

     --Add Mapped Superbill Status
  INSERT INTO @superbillstatus (MapFromSuperbillStatusUid, MapToSuperbillStatusUid)
  SELECT DISTINCT  MI.FindTableFromItemUid, mi.FindTableToItemUid
  from  MapItem MI WITH(NOLOCK)
  JOIN MapSource MS WITH(NOLOCK) ON MI.MapSourceUid=MS.MapSourceUid AND MS.MapSourceUid=''ACB1C24D-992C-4DDC-ACEE-4BBE84C0FD5A'' AND MS.Inactive=0
  JOIN @superbillstatus LS ON MI.FindTableToItemUid=LS.MapFromSuperbillStatusUid  AND mi.FindTableFromItemUid IS NOT NULL 


        DECLARE @Superbills TABLE (SuperbillUid UNIQUEIDENTIFIER, SuperbillStatusUid UNIQUEIDENTIFIER, PatientUid UNIQUEIDENTIFIER, LastModifiedByUid UNIQUEIDENTIFIER)
		INSERT INTO @Superbills
		SELECT  DISTINCT d.SuperbillUid, s.SuperbillStatusUid, s.PatientUid, d.LastModifiedByUid
		FROM deleted d
			JOIN Superbill s WITH(NOLOCK) on d.SuperbillUid = s.SuperbillUid
			Join @superbillstatus ls on s.SuperbillStatusUid=ls.MapFromSuperbillStatusUid
			LEFT JOIN @ExcludeSuperbills ex on d.SuperbillUid = ex.SuperbillUid
		WHERE ex.SuperbillUid IS NULL
						

	  --	--only interested in Superbills where status is  Ready To Submit, Preliminary, Ready to Review, Filed, ERA Rejected,Rejected, completed, Refiled, PendingPatientPayment
	--  EXLUDED SUPERBILL COMPLETE STATUS 

	IF NOT  EXISTS (	SELECT 1 FROM @Superbills)
	
	RETURN;


	BEGIN
	
	DELETE TransmissionOutbound where TransmissionOutboundUid in  
			(  
				SELECT TransmissionOutboundUid  
				from TransmissionOutbound tod WITH(NOLOCK)
				INNER JOIN @Superbills s on tod.ForeignObjectUid = s.SuperbillUid 
						WHERE tod.Description IN (''SUPERBILLCLAIM'',''SUPERBILLDELETE'')
						AND tod.TransmissionType=''EKOS''
						AND tod.Status <> 100
			)

      -- FOR SUPERBILL CLAIM PUT API CALL     
	INSERT INTO TransmissionOutbound (TransmissionType,Description ,ForeignObjectUid, RawMessage, PatientUid, lastmodifiedbyuid, LastModifiedDate)  
	SELECT  tc.TransmissionType, ''SUPERBILLCLAIM'',i.SuperbillUid, ''iMedica.Prm.BusinessObject.Superbill'',s.PatientUid,i.LastModifiedByUid, GETUTCDATE()  
				 from TransmissionConfiguration tc WITH(NOLOCK)
                 INNER JOIN ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
				 CROSS JOIN @Superbills i
				 JOIN Superbill s WITH(NOLOCK) on i.SuperbillUid = s.SuperbillUid
			     WHERE tc.TransmissionType = ''EKOS'' and
					   lip.Inactive = 0 

  
  END  
  
     
 END  
END' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[EKOS_SuperbillClaim_SBProc_InsertUpdate]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[EKOS_SuperbillClaim_SBProc_InsertUpdate] ON [dbo].[SuperbillProcedure]   
FOR INSERT, UPDATE  

AS  
BEGIN  

IF @@ROWCOUNT = 0  
RETURN  

 IF dbo.IsCacheClient() = 0  
 BEGIN  
  SET NOCOUNT ON   
  
    IF NOT  EXISTS  (select * 
				 from TransmissionConfiguration tc WITH(NOLOCK)
                 inner join ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
			     where tc.TransmissionType = ''EKOS'' and
					   lip.Inactive = 0 )
    RETURN;


  DECLARE @SuperbillProcUid UNIQUEIDENTIFIER    
  DECLARE @SuperbillUid UNIQUEIDENTIFIER 

  --SYSTEM DEFINED GUID FOR READY TO SUBMIT
 DECLARE @ReadyToSubmitSuperbillStatusUid uniqueidentifier = ''55ED3239-89F3-4488-89C9-71BE5A541CC4''
  --SYSTEM DEFINED GUID FOR READY TO REVIEW
  DECLARE @ReadyToReviewSuperbillStatusUid uniqueidentifier =''D2291C14-3F4E-4381-80A7-883C76C9499B''
  --SYSTEM DEFINED GUID FOR PRELIMINARY 
  DECLARE @PreliminarySuperbillStatusUid uniqueidentifier =''DF81BE7C-71CF-47F4-8573-733E81E30EA8''
  --SYSTEM DEFINED GUID FOR REJECTED
  DECLARE @RejectedSuperbillStatusUid uniqueidentifier = ''2C4A6E7D-EB6D-4370-A836-5937363C6B69'' 
  --SYSTEM DEFINED GUID FOR ERAREJECTED
  DECLARE @EraRejectedSuperbillStatusUid uniqueidentifier = ''2352F0FB-708B-437E-9809-F80128195F9E''
  --SYSTEM DEFINED GUID FOR FILED
  DECLARE @FiledSuperbillStatusUid uniqueidentifier =''9FFE6214-7C7F-4516-9899-43D37FABE21D''
  	-- SYSTEM DEFINED GUID FOR CANCELED
 --DECLARE @CanceledSuperbillStatusUid uniqueidentifier=''FC8AD61B-139A-4CFA-9580-CDACFC3ACF90''
         --SYSTEM DEFINED GUID FOR COMPLETE
  DECLARE @CompleteSuperbillStatusUid uniqueidentifier = ''30F64D66-55CB-4438-BB2F-7A6250399312'' 
  		--SYSTEM DEFINED GUID FOR REFILED
  DECLARE @RefiledSuperbillStatusUid uniqueidentifier = ''A8258278-7182-45DC-869F-790F46F2C177''
		--SYSTEM DEFINED GUID FOR PENDING PATIENT PAYMENT
  DECLARE @PendingPatientPaymentSuperbillStatusUid uniqueidentifier = ''D2BF0F3C-6E03-478F-BDAE-4DCAC5EB9410'' 

  --ADD EKOS Generic status
  DECLARE @superbillstatus table (MapFromSuperbillStatusUid uniqueidentifier,MapToSuperbillStatusUid uniqueidentifier)
  DECLARE @ExcludeFinancialCenter VARCHAR(MAX) = NULL
  DECLARE @ExcludeSuperbills TABLE (SuperbillUid UNIQUEIDENTIFIER)

	SELECT @ExcludeFinancialCenter = CONVERT(XML, AdditionalOutboundXML).value(''(//FinancialCentersOptOut)[1]'',''VARCHAR(MAX)'')
	FROM ListIntegrationPartner WITH(NOLOCK) WHERE IntegrationPartnerUid = ''20C576DF-A670-4A58-85DE-CAA4BA5151E0''

	INSERT INTO @ExcludeSuperbills
	SELECT i.SuperbillUid
	from INSERTED i
	INNER JOIN SuperbillProcedure SP WITH(NOLOCK) ON  SP.SuperbillUid = i.SuperbillUid
	INNER JOIN AR_LedgerDetail ARLD WITH(NOLOCK) ON ARLD.SuperbillProcedureUid= SP.SuperbillProcedureUid AND ((ARLD.FinancialCenterUid IN (SELECT element FROM dbo.Split(@ExcludeFinancialCenter,'',''))))
	INNER JOIN AR_Ledger ARL WITH(NOLOCK) ON ARLD.LedgerUid=ARL.LedgerUid

  INSERT INTO @superbillstatus (MapFromSuperbillStatusUid) values (@PreliminarySuperbillStatusUid),(@ReadyToReviewSuperbillStatusUid),(@ReadyToSubmitSuperbillStatusUid),(@EraRejectedSuperbillStatusUid),
  (@RejectedSuperbillStatusUid),(@FiledSuperbillStatusUid),(@CompleteSuperbillStatusUid), (@RefiledSuperbillStatusUid),(@PendingPatientPaymentSuperbillStatusUid)
  
  
    --Add Mapped Superbill Status
  INSERT INTO @superbillstatus (MapFromSuperbillStatusUid, MapToSuperbillStatusUid)
  SELECT DISTINCT  MI.FindTableFromItemUid, mi.FindTableToItemUid
  from  MapItem MI WITH(NOLOCK)
  JOIN MapSource MS WITH(NOLOCK) ON MI.MapSourceUid=MS.MapSourceUid AND MS.MapSourceUid=''ACB1C24D-992C-4DDC-ACEE-4BBE84C0FD5A'' AND MS.Inactive=0
  JOIN @superbillstatus LS ON MI.FindTableToItemUid=LS.MapFromSuperbillStatusUid  AND mi.FindTableFromItemUid IS NOT NULL 
  

        DECLARE @Superbills TABLE (SuperbillUid UNIQUEIDENTIFIER, SuperbillStatusUid UNIQUEIDENTIFIER, PatientUid UNIQUEIDENTIFIER, LastModifiedByUid UNIQUEIDENTIFIER)
		INSERT INTO @Superbills
		SELECT DISTINCT s.SuperbillUid, s.SuperbillStatusUid, s.PatientUid, i.LastModifiedByUid
		FROM INSERTED i
		INNER JOIN Superbill s WITH(NOLOCK) on i.SuperbillUid = s.SuperbillUid
		INNER JOIN @superbillstatus ls on s.SuperbillStatusUid=ls.MapFromSuperbillStatusUid
		LEFT JOIN @ExcludeSuperbills ex on i.SuperbillUid = ex.SuperbillUid
		WHERE ex.SuperbillUid IS NULL


		--only interested in Superbills where status is  Ready To Submit, Preliminary, Ready to Review, Filed, ERA Rejected,Rejected,Compelete, Refiled, Pending Patient Payment

	IF NOT  EXISTS (SELECT 1 FROM @Superbills)

	RETURN;
	BEGIN

	DELETE TransmissionOutbound where TransmissionOutboundUid in  
			(  
				SELECT TransmissionOutboundUid  
				FROM TransmissionOutbound tod WITH(NOLOCK)
				INNER JOIN @Superbills s on tod.ForeignObjectUid = s.SuperbillUid 
						WHERE tod.Description IN (''SUPERBILLDELETE'',''SUPERBILLCLAIM'')
						AND tod.TransmissionType=''EKOS''
						AND tod.Status <> 100
			)   

    
	--FOR SUPERBILLCLAIM PUT API CALL     
	INSERT INTO TransmissionOutbound (TransmissionType,Description ,ForeignObjectUid, RawMessage, PatientUid, lastmodifiedbyuid, LastModifiedDate)  
	SELECT  tc.TransmissionType, ''SUPERBILLCLAIM'',i.SuperbillUid, ''iMedica.Prm.BusinessObject.Superbill'',s.PatientUid,i.LastModifiedByUid, GETUTCDATE()  
				 FROM TransmissionConfiguration tc WITH(NOLOCK)
                 INNER JOIN ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
				 CROSS JOIN @Superbills i
				 INNER JOIN Superbill s WITH(NOLOCK) on i.SuperbillUid = s.SuperbillUid
			     WHERE tc.TransmissionType = ''EKOS'' and
					   lip.Inactive = 0 
					   -- and I.SuperbillStatusUid <>@CanceledSuperbillStatusUid
     
END     
 END  

 END' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[SuperBill_Based_DFT_SBProc]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[SuperBill_Based_DFT_SBProc] ON [dbo].[SuperbillProcedure]   
FOR INSERT, UPDATE  
/* Purpose: Used to track inserts made to the Superbill table for HL7 */  
AS  
BEGIN  

IF @@ROWCOUNT = 0  
RETURN  

 IF dbo.IsCacheClient() = 0  
 BEGIN  
  SET NOCOUNT ON   
  
  DECLARE @SuperbillProcUid UNIQUEIDENTIFIER    

  --SYSTEM DEFINED GUID FOR READY TO SUBMIT
  DECLARE @ReadyToSubmitSuperbillStatusUid uniqueidentifier = ''55ED3239-89F3-4488-89C9-71BE5A541CC4''

  DECLARE @ReadyToSubmitDisplayOrder INT 

  SELECT @ReadyToSubmitDisplayOrder = DisplayOrder from ListSuperbillStatus where SuperbillStatusUid = @ReadyToSubmitSuperbillStatusUid

  DECLARE @DFTTable TABLE    
  (    
   partnerMessageID VARCHAR(50) --Array element contents    
  )    
  
  INSERT INTO @DFTTable  
  Select PM.HL7PartnerMessageUid from HL7partner P   
	LEFT JOIN HL7PartnerMessage PM ON PM.HL7partnerUid=P.HL7partnerUid  
	where PM.MessageType = ''DFT''   
	  and PM.Inactive = 0    
	  and P.Inactive = 0   
	  and PM.Send = 1  
	  and PM.SendFunction = ''SuperbillCharges''
  
  DECLARE DFT_CUR CURSOR FAST_FORWARD LOCAL FOR   
    SELECT SuperbillProcedureUid FROM INSERTED    
  
  OPEN DFT_CUR  
  
  FETCH NEXT FROM DFT_CUR INTO @SuperbillProcUid 
    
  WHILE @@FETCH_STATUS = 0  
  BEGIN    	
	--only interested in visits where superbill status is Ready To Submit or a later status
	IF NOT EXISTS (	SELECT *
						FROM inserted i
							JOIN Superbill s on i.SuperbillUid = s.SuperbillUid
							JOIN ListSuperbillStatus ss on s.SuperbillStatusUid = ss.SuperbillStatusUid
						where i.DFTGeneratedDateTime is null and ss.DisplayOrder >= @ReadyToSubmitDisplayOrder
							AND I.SuperbillProcedureUid = @SuperbillProcUid
				)
	BEGIN
		GOTO NEXT_LOOP --interested in this superbill so go on to the next one
    END
   
	DECLARE @SBUid uniqueidentifier
	select @SBUid = SuperbillUid from inserted where SuperbillProcedureUid = @SuperbillProcUid

	delete hl7actiontypeobject where hl7actiontypeobjectuid in  
	(  select hl7actiontypeobjectuid  
		from hl7actiontypeobject ato  
		where ato.objectuid = @SBUid and ato.actiontype = ''SuperbillCharges'' and ato.objecttype = ''Superbill''  
	)   
      
         
	INSERT INTO HL7ActionTypeObject (HL7ActionTypeObjectUid, HL7PartnerMessageUid, ActionType, ObjectType,ObjectUid, LastModifiedDate)  
	Select NEWID(), partnerMessageID, ''SuperbillCharges'',''Superbill'', @SBUid, GETUTCDATE() From @DFTTable  
     
	NEXT_LOOP:  
	
	FETCH NEXT FROM DFT_CUR INTO @SuperbillProcUid  
  END  
    
  CLOSE DFT_CUR  
  DEALLOCATE DFT_CUR  
  
  SET NOCOUNT OFF      
 END  
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[SuperbillProcedure_InsteadOf_Delete]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[SuperbillProcedure_InsteadOf_Delete] ON [dbo].[SuperbillProcedure]
INSTEAD OF DELETE
AS
BEGIN
	SET NOCOUNT ON;
	
	DECLARE @originatorId VARBINARY(128);
	SELECT @originatorId = dbo.GetChangeTrackingContextFromContextInfo();
	
	WITH CHANGE_TRACKING_CONTEXT(@originatorId)
	DELETE FROM AR_Ledger WHERE LedgerUid IN -- clear ledger first -- will error if in closed batch
		(SELECT LedgerUid FROM AR_LedgerDetail 
			WHERE SuperbillProcedureUid 
				IN (SELECT SuperbillProcedureUid FROM Deleted WHERE NOT SuperbillProcedureUid IS NULL));
				
	WITH CHANGE_TRACKING_CONTEXT(@originatorId)
	DELETE FROM COBLineAdjustments
		WHERE SuperbillProcedureUid IN (SELECT SuperbillProcedureUid FROM Deleted);
		
	WITH CHANGE_TRACKING_CONTEXT(@originatorId)		
	DELETE FROM SuperbillProcedure WHERE SuperbillProcedureUid IN
		(SELECT SuperbillProcedureUid FROM Deleted);
	
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[IntegrationPartnerBackfill]'))
EXEC dbo.sp_executesql @statement = N'



-- =============================================
-- Author:		<Author,Manusha Bompelli>
-- =============================================
CREATE TRIGGER [dbo].[IntegrationPartnerBackfill]
   ON  [dbo].[TransmissionOutbound]
   AFTER INSERT,UPDATE 
AS 
BEGIN
	SET NOCOUNT ON;
	DECLARE @BatchCap INT;
	DECLARE @TO TABLE (TOUid UNIQUEIDENTIFIER)
	SET @BatchCap = 50;

					 IF (SELECT COUNT(*) FROM IntegrationPartnerBackfillQueue) > 0
					 BEGIN
										IF (SELECT COUNT(*) FROM TransmissionOutbound WHERE Status = 0) < @BatchCap
										BEGIN
												INSERT INTO @TO
												SELECT TOP (@BatchCap) TransmissionOutboundUid FROM IntegrationPartnerBackfillQueue ORDER BY LastModifiedDate ASC
												

												INSERT INTO TransmissionOutbound
												SELECT i.TransmissionOutboundUid
												,i.TransmissionType
												,i.Status
												,i.Description
												,i.RawMessage
												,i.TransmissionControlXML
												,i.ForeignObjectUid
												,i.EnqueuedTimestamp
												,i.NextSendAttempt
												,i.LastTransmissionAttempt
												,i.NumberOfTransmissionAttempts
												,i.SuccessfulTransmissionTimestamp
												,i.LastError
												,i.IntermediateGenerationData
												,i.StatusHistory
												,i.ExternalStatus
												,i.ExternalStatusDescription
												,i.LastModifiedDate
												,i.LastModifiedByUid
												,i.ProviderUid
												,i.PatientUid
												,i.ServiceSiteUid
                        ,ForeignObjectUid_2  = null
                        ,ForeignObjectUid_3  = null
                        ,ForeignObjectName   = null
                        ,ForeignObjectName_2 = null
                        ,ForeignObjectName_3 = null
										FROM	IntegrationPartnerBackfillQueue i
												INNER JOIN @TO b on i.TransmissionOutboundUid = b.TOUid

												DELETE FROM a
												FROM IntegrationPartnerBackfillQueue a
												INNER JOIN @TO b on a.TransmissionOutboundUid = b.TOUid
									  END
					END

END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[MessageBackfill]'))
EXEC dbo.sp_executesql @statement = N'
CREATE TRIGGER [dbo].[MessageBackfill]
   ON  [dbo].[TransmissionOutbound]
   AFTER UPDATE
AS 
BEGIN
	SET NOCOUNT ON;
	IF (SELECT COUNT(*) FROM MessageBackfillQueue) > 0
	BEGIN
		DECLARE @BatchCap INT;
		SELECT TOP 1 @BatchCap = IntegerValue from ListProductParameter where ParameterName = ''HL7BatchCapacity''
		
		IF(@BatchCap is null)
		BEGIN
			SET @BatchCap = 50;
		END

		IF (SELECT COUNT(*) FROM TransmissionOutbound WHERE Status = 0) < @BatchCap
		BEGIN
			DECLARE @ATO TABLE (ATOUid UNIQUEIDENTIFIER)
			INSERT INTO @ATO
			SELECT TOP (@BatchCap) MessageBackfillQueueUid FROM MessageBackfillQueue where TransmissionType is not null ORDER BY LastModifiedDate ASC

			INSERT INTO TransmissionOutbound(TransmissionType,ForeignObjectUid,PatientUid,ProviderUid)
			SELECT a.TransmissionType,a.ObjectUid,a.PatientUid,a.ProviderUid
		FROM MessageBackfillQueue a
			INNER JOIN @ATO b on a.MessageBackfillQueueUid = b.ATOUid

			DELETE FROM a
			FROM MessageBackfillQueue a
			INNER JOIN @ATO b on a.MessageBackfillQueueUid = b.ATOUid

		END
	END
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[OverrideRetryTime]'))
EXEC dbo.sp_executesql @statement = N'--TRIGGER TO OVERRIDE RETRY TIMES
CREATE TRIGGER [dbo].[OverrideRetryTime]
   ON  [dbo].[TransmissionOutbound]
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    -- Insert statements for trigger here
	update t
			set t.NextSendAttempt = dateadd(minute, isnull(lpp.IntegerValue,0), i.LastTransmissionAttempt)
		from TransmissionOutbound t
		join INSERTED i on i.TransmissionOutboundUid = t.TransmissionOutboundUid
		join ListProductParameter lpp on lpp.ParameterName = ''TransmissionRetryOverrideInterval'' and lpp.StringValue = t.TransmissionType
		where I.SuccessfulTransmissionTimestamp is null
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[ActiveRowDeleted_UICH]'))
EXEC dbo.sp_executesql @statement = N'
CREATE TRIGGER [dbo].[ActiveRowDeleted_UICH] on [dbo].[UIConfigurationHistory] 
    FOR DELETE
as 

set nocount on 

declare @IsCurrentHistoryRow bit = 0
declare @UIConfigurationHistoryUid uniqueidentifier
declare @GroupingUid uniqueidentifier
   
DECLARE a_cursor CURSOR FAST_FORWARD FOR 
			select IsCurrentHistoryRow, @UIConfigurationHistoryUid, GroupingUid
			from deleted 
			order by [Sequence]
				
OPEN a_cursor
FETCH NEXT FROM a_cursor INTO @IsCurrentHistoryRow, @UIConfigurationHistoryUid, @GroupingUid

WHILE (@@fetch_status = 0)
BEGIN
	if (@IsCurrentHistoryRow = 1)
	begin
		update uich set IsCurrentHistoryRow = 1, InactiveDate = null
			from UIConfigurationHistory uich 
			where uich.UIConfigurationHistoryUid = 
			(select top 1 uich2.UIConfigurationHistoryUid 
				from UIConfigurationHistory uich2 
				where uich2.UIConfigurationHistoryUid <> @UIConfigurationHistoryUid
				and uich2.GroupingUid = @GroupingUid
				order by [Sequence] desc)
	end
	FETCH NEXT FROM a_cursor INTO @IsCurrentHistoryRow, @UIConfigurationHistoryUid, @GroupingUid

END -- of while...

CLOSE a_cursor
DEALLOCATE a_cursor

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[Provider_EKOS_Update]'))
EXEC dbo.sp_executesql @statement = N'


CREATE TRIGGER [dbo].[Provider_EKOS_Update] 
   ON  [dbo].[UserPRM] 
   AFTER UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	if not exists (
		Select *
		from TransmissionConfiguration tc WITH(NOLOCK)
		inner join ListIntegrationPartner lip WITH(NOLOCK) on lip.IntegrationPartnerUid =tc.IntegrationPartnerUid
		where 
			tc.TransmissionType = ''EKOS'' and
			lip.Inactive = 0 
		)
	begin
		return
	end
       
	IF dbo.IsCacheClient() = 0  
	begin
		-- Insert statements for trigger here
		update p
		set LastModifiedDate = p.LastModifiedDate --just causing trigger to fire
		from inserted i 
		join provider pr WITH(NOLOCK) on i.personuid=pr.PersonUid
		join Person p WITH(NOLOCK) on pr.PersonUid = p.PersonUid
	end
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[CCD_Visit_Complete]'))
EXEC dbo.sp_executesql @statement = N'
CREATE TRIGGER [dbo].[CCD_Visit_Complete] ON [dbo].[Visit] FOR INSERT, UPDATE AS  
IF dbo.IsCacheClient() = 0
BEGIN

DECLARE @CCDTable TABLE (PartnerMessageUid UNIQUEIDENTIFIER, VisitTypeUid UNIQUEIDENTIFIER,PatientUid UNIQUEIDENTIFIER, VisitUid UNIQUEIDENTIFIER, CCDAUid UNIQUEIDENTIFIER, LastModifiedByUid UNIQUEIDENTIFIER)
DECLARE @ExcludePartners VARCHAR(MAX) = NULL
DECLARE @ObjectType varchar(25) = ''Patient''
DECLARE @SendFunction varchar(25) = ''CCD Generation''
DECLARE @IsByVisit VARCHAR(MAX) = NULL
DECLARE @BoolByVisit SMALLINT
DECLARE @LabResultVT UNIQUEIDENTIFIER = ''6A18A657-B912-4C12-828E-A3DF8571D205''

		--Check to ensure there is a valid partner otherwise exits trigger
		IF NOT EXISTS (SELECT TOP 1 * FROM HL7PartnerMessage 
						WHERE (SendFunction = @SendFunction)	AND Send = 1 AND Inactive = 0)
		RETURN

		--Gets String of Partners that should send CCDA by Visit
       SELECT @IsByVisit = StringValue, @BoolByVisit = BoolValue FROM ListProductParameter where ParameterName = ''CCDAByVisit''

	   --Generates Temp CCDATable this expands inserted to include each valid partner and sets as episodic or longitudinal Send
	   INSERT INTO @CCDTable
       SELECT DISTINCT a.HL7PartnerMessageUid 
             ,i.VisitTypeUid
             ,i.PatientUid
             ,i.Visituid
             ,CASE 	WHEN (@IsByVisit IS NULL AND @BoolByVisit = 1) THEN i.VisitUid 
			 		WHEN (a.HL7PartnerMessageUid IN (SELECT Element FROM dbo.Split(@IsByVisit,'','')) AND @BoolByVisit = 1) THEN i.VisitUid
			 		ELSE i.Patientuid END AS CCDAUid
             ,i.LastModifiedByUid
       FROM INSERTED i
       CROSS JOIN (
             SELECT PM.HL7PartnerMessageUid
             FROM   HL7partner P 
             LEFT JOIN HL7PartnerMessage PM ON PM.HL7partnerUid=P.HL7partnerUid
             WHERE PM.MessageType = ''CCD'' 
                    AND PM.SendFunction = @SendFunction
                    AND PM.Inactive = 0  
                    AND P.Inactive = 0 
                    AND PM.Send = 1
       ) a
	   WHERE i.IsCompleted = 1
	   AND (i.visittypeuid is null or i.VisitTypeUid <> ''ADA7EB5D-FD9A-4E9F-88E5-84EDDA9EFC42'' )--RefillVisits

	    --Gets String of Paftners that do not want CCDA''s sent on results updates
       SELECT @ExcludePartners = StringValue FROM ListProductParameter where ParameterName = ''CCDAexcludeUpdatedResults''

	   --Removes rows from the CCDA table when the partner is set to not send CCDA on results update checks also for visittype = lab results
       IF @ExcludePartners IS NOT NULL
             DELETE FROM @CCDTable WHERE PartnerMessageUid IN (SELECT Element FROM dbo.Split(@ExcludePartners,'','')) AND VisitTypeUid = @LabResultVT

		--Removes messages in HL7ATO that are pending to prevent multiple sends
		DELETE HL7ActionTypeObject WHERE HL7ActionTypeObjectUid in
			(SELECT HL7ActionTypeObjectUid FROM HL7ActionTypeObject ato
			JOIN @CCDTable c ON ato.HL7PartnerMessageUid = c.PartnerMessageUid
			WHERE ato.ObjectUid = c.CCDAUid and ato.ActionType = @SendFunction and ato.ObjectType = @ObjectType) 
		
		--Checks to ensure CCDATable has values and then inserts the values into HL7ATO to send CCDAs
		IF Exists (Select * from @CCDTable)
		BEGIN
			INSERT HL7ActionTypeObject(HL7PartnerMessageUid, ActionType, ObjectUid, ObjectType, LastModifiedByUid)  
			SELECT c.PartnerMessageUid
						,@SendFunction
						,c.CCDAUid
						,@ObjectType
						,c.LastModifiedByUid  
			FROM   @CCDTable c
						INNER JOIN HL7PartnerMessage pm on c.PartnerMessageUid = pm.HL7PartnerMessageUid
						INNER JOIN HL7Partner p ON pm.HL7PartnerUid = p.HL7PartnerUid  
						LEFT JOIN ViewActionTypeObjectPartnerMessage atopm ON c.CCDAUid = atopm.ObjectUid AND pm.HL7PartnerUid = atopm.HL7PartnerUid AND atopm.HL7ActionTypeObjectUid IS NULL
						LEFT Join RelHL7PartnerPatientConsent rhpc on rhpc.PatientUid = c.PatientUid and p.HL7PartnerUid = rhpc.HL7PartnerUid
			WHERE  (rhpc.ConsentAgreed = 1 OR (p.ConsentStatus = 1 AND rhpc.ConsentAgreed IS NULL))
						--Bug 58259 new patients get written to RelHL7PartnerPatientConsent regardless of if consent is marked.  If not changed ConsentAgreed = NULL, if denied = 0, if consent
						--is given = 1.  Update also made to CCD_Visit_Complete
		END


END' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[CCM_CCDA_Visit_Complete]'))
EXEC dbo.sp_executesql @statement = N'



CREATE TRIGGER [dbo].[CCM_CCDA_Visit_Complete] ON [dbo].[Visit] FOR INSERT, UPDATE AS  
IF dbo.IsCacheClient() = 0
BEGIN
	--For sending CCM CCDA
	DECLARE @PartnerType varchar(25)
	DECLARE @ActionType varchar(25)
	DECLARE @PartnerUid uniqueidentifier
	DECLARE @TransmissionConfigurationUid uniqueidentifier
	DECLARE @TransmissionType varchar(25)

	Set @PartnerType =''CCM''
	Set @ActionType=''CCDA CCM''

	Select top 1 @PartnerUid=IPT.IntegrationPartnerUid 
	from ListIntegrationPartnerType IPT 
	INNER JOIN ListIntegrationPartner IP
	on IPT.IntegrationPartnerUid = IP.IntegrationPartnerUid
	where IPT.Name=@PartnerType AND IP.Inactive=0

	if @PartnerUid is null
		return

	Select top 1 @TransmissionConfigurationUid=TC.TransmissionConfigurationUid from TransmissionConfiguration TC
	where TC.ActionType=@ActionType AND TC.IntegrationPartnerUid=@PartnerUid

	if @TransmissionConfigurationUid is null
		return

	Set @TransmissionType = (select TransmissionType from TransmissionConfiguration where TransmissionConfigurationUid=@TransmissionConfigurationUid)

	DECLARE @VisitUid UNIQUEIDENTIFIER
	DECLARE @PatientUid UNIQUEIDENTIFIER
	DECLARE @CCDAUid UNIQUEIDENTIFIER

	DECLARE CCD_CUR CURSOR FAST_FORWARD LOCAL FOR 
	SELECT VisitUid, PatientUid FROM INSERTED 

	OPEN CCD_CUR
	FETCH NEXT FROM CCD_CUR INTO @VisitUid, @PatientUid
	WHILE @@FETCH_STATUS =0
	BEGIN
		--THIS SECTION DECIDES IF A CCD SHOULD BE SENT
		IF (SELECT IsCompleted FROM INSERTED WHERE VisitUid = @VisitUid) = 1 
		BEGIN
			--If any CCM are valid then send a ccda
			IF(exists(select top 1 * from PatientCareManagement where PatientUid=@PatientUid 
			AND (ExpirationDate >=GETDATE() OR ExpirationDate IS NULL) 
			AND EffectiveDate <=GETDATE()
			AND CareTypeUid=''14E95BCD-A9BC-41E4-9743-ECDBAD35FB6A''	--CCM Care type in ListMisc
			AND StatusUid=''8ADCE475-B9D5-4A2C-B312-DEE14BAEB427''))	--uid for Accepted from ListPatientCareManagementStatus
			BEGIN
				if(exists(select * from TransmissionOutbound  
					where Status=0 
					AND ForeignObjectUid=@PatientUid 
					AND PatientUid=@PatientUid 
					AND ProviderUid=(select ProviderUid from Visit where VisitUid=@VisitUid)))
				begin
					return
				end

				INSERT	TransmissionOutbound(TransmissionType, ForeignObjectUid, PatientUid, ProviderUid, LastModifiedByUid)
				SELECT	@TransmissionType, PatientUid, PatientUid, ProviderUid, LastModifiedByUid
				FROM	Inserted
				where	VisitUid=@VisitUid
			END
		END
		NEXT_LOOP:
		FETCH NEXT FROM CCD_CUR INTO @VisitUid, @PatientUid
	END
	CLOSE CCD_CUR
	DEALLOCATE CCD_CUR
	SET NOCOUNT OFF
END




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[CCR_Visit_Complete]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[CCR_Visit_Complete] ON [dbo].[Visit] FOR INSERT, UPDATE AS  
IF dbo.IsCacheClient() = 0
BEGIN

	DECLARE @ObjectType varchar(25)
	DECLARE @SendFunction varchar(25)
	
	Set @ObjectType = ''Patient''
	Set @SendFunction =''CCR Generation''
	
	IF NOT EXISTS (SELECT TOP 1 * 	FROM HL7PartnerMessage 
	WHERE (SendFunction = @SendFunction)	AND Send = 1 AND Inactive = 0)
		RETURN

	DECLARE @CCRTable TABLE  
	(
	PartnerMessageUid UNIQUEIDENTIFIER --Array element contents  
	)  

	INSERT INTO @CCRTable
	SELECT	PM.HL7PartnerMessageUid 
	FROM	HL7partner P 
			LEFT JOIN HL7PartnerMessage PM ON PM.HL7partnerUid=P.HL7partnerUid
	WHERE 
			PM.MessageType = ''CCR'' 
			AND PM.SendFunction = @SendFunction
			AND PM.Inactive = 0  
			AND P.Inactive = 0 
			AND PM.Send = 1

	DECLARE @VisitUid UNIQUEIDENTIFIER
	DECLARE @PatientUid UNIQUEIDENTIFIER

	DECLARE CCR_CUR CURSOR FAST_FORWARD LOCAL FOR 
	SELECT VisitUid, PatientUid FROM INSERTED 

	OPEN CCR_CUR
	FETCH NEXT FROM CCR_CUR INTO @VisitUid, @PatientUid
	WHILE @@FETCH_STATUS =0
	BEGIN
		--THIS SECTION DECIDES IF A CCR SHOULD BE SENT
		IF (SELECT IsCompleted FROM INSERTED WHERE VisitUid = @VisitUid) = 1 
		BEGIN

			--delete any rows in hl7actiontypeobject that match the ones we are about to create
			DELETE HL7ActionTypeObject WHERE HL7ActionTypeObjectUid in
			(SELECT HL7ActionTypeObjectUid FROM HL7ActionTypeObject ato
			JOIN @CCRTable c ON ato.HL7PartnerMessageUid = c.PartnerMessageUid
			WHERE ato.ObjectUid = @PatientUid and ato.ActionType = @SendFunction and ato.ObjectType = @ObjectType)
			
			
			INSERT	HL7ActionTypeObject(HL7PartnerMessageUid, ActionType, ObjectUid, ObjectType, LastModifiedByUid)  
			SELECT	pm.HL7PartnerMessageUid, pm.SendFunction, i.PatientUid, @ObjectType, i.LastModifiedByUid  
			FROM	HL7PartnerMessage pm 
					INNER JOIN HL7Partner p ON pm.HL7PartnerUid = p.HL7PartnerUid  
					CROSS JOIN inserted i 
					INNER JOIN Visit vst ON i.VisitUid = vst.VisitUid 
					LEFT JOIN ViewActionTypeObjectPartnerMessage atopm ON i.PatientUid = atopm.ObjectUid AND atopm.ObjectType=@ObjectType
					AND pm.HL7PartnerUid = atopm.HL7PartnerUid AND atopm.SendFunction = @SendFunction
					LEFT JOIN DELETED D ON i.VisitUid = d.VisitUid
			WHERE	pm.SendFunction = @SendFunction AND  
					pm.Send = 1 AND  
					pm.Inactive = 0 AND  
					p.Inactive = 0 AND  
					atopm.HL7ActionTypeObjectUid IS NULL AND
					i.VisitUid = @VisitUid
		END
		NEXT_LOOP:
		FETCH NEXT FROM CCR_CUR INTO @VisitUid, @PatientUid
	END
	CLOSE CCR_CUR
	DEALLOCATE CCR_CUR
	SET NOCOUNT OFF
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[CompletedVisit_UpdateASLVAdditionalInformation]'))
EXEC dbo.sp_executesql @statement = N'


CREATE  TRIGGER [dbo].[CompletedVisit_UpdateASLVAdditionalInformation] 
   ON  [dbo].[Visit] 
   AFTER INSERT, UPDATE
AS 
BEGIN

	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

   IF NOT EXISTS (SELECT * FROM inserted i WHERE i.IsCompleted = 1)
     RETURN ;

   UPDATE ASLVAdditionalInformation
   SET
      ASLVAdditionalInformation.VisitUid = i.VisitUid
   FROM inserted i 
		  INNER JOIN Patient pt ON i.PatientUid = pt.PersonUid
		  INNER JOIN ASLVAdditionalInformation ON ASLVAdditionalInformation.PatientUid = pt.PersonUid
   WHERE i.IsCompleted = 1
		 AND ASLVAdditionalInformation.VisitUid IS NULL
END

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[CompletedVisit_UpdateImmunizationHistory]'))
EXEC dbo.sp_executesql @statement = N'CREATE  TRIGGER [dbo].[CompletedVisit_UpdateImmunizationHistory] 
   ON  [dbo].[Visit] 
   AFTER INSERT, UPDATE
AS 
BEGIN
       -- SET NOCOUNT ON added to prevent extra result sets from
       -- interfering with SELECT statements.
       SET NOCOUNT ON;

       IF dbo.IsCacheClient() = 0  
        begin

       if not exists (
       SELECT HL7PartnerMessageUid,ConsentRequired
       FROM HL7PartnerMessage hpm
       INNER JOIN HL7Partner hm ON hpm.HL7PartnerUid = hm.HL7PartnerUid
       WHERE MessageType = ''VXU''
              AND MessageEvent = ''V04''
              AND hm.Inactive = 0
              AND hpm.Inactive = 0
              AND hpm.SendFunction = ''ImmunizationHistory''
              AND hpm.Send = 1
              )
       begin
              return
       end
       

		      -- Insert statements for trigger here
              update ih
              set OriginCreateTime = i.lastmodifieddate  --just causing trigger to fire
              from inserted i
              join ImmunizationHistory ih on ih.visituid = i.visituid
              where i.IsCompleted = 1 and ih.IsDelete = 0
			  and i.completeddate >ih.lastmodifieddate

       end
END


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[HL7InsertForDFT]'))
EXEC dbo.sp_executesql @statement = N'
CREATE TRIGGER [dbo].[HL7InsertForDFT] ON [dbo].[Visit] 
FOR INSERT, UPDATE

/*
Purpose: Used to track inserts made to the Visit table for HL7
Created On: 20050810
Special Comments
*/

AS
BEGIN
  IF @@ROWCOUNT = 0
    RETURN 

  IF dbo.IsReplicating() = 0
  BEGIN
		SET NOCOUNT ON 

		IF EXISTS (
			SELECT [VisitUid],[ClinicalNoteTypeUid],[AppointmentUid],[PatientCaseUid],[PatientUid],[AccountUid],[SuperbillRequired],[VisitDate],[IsCompleted],[ProviderUid],[ProviderCareTypeUid],[RenderingProviderUid],[ProviderSignatureUid],[ServiceSiteUid],[ServiceSiteTypeUid],[FinancialCenterUid],[SupervisingProviderUid],[Emergency],[AuthorizationCode],[ReferredByProviderUid],[ReferringDate],[PETemplateUid],[OriginalPETemplateUid],[CosignStatusID],[VoiceAttachmentUid],[CaseTypePhaseUid],[CompletedDate],[ABN],[VisitTypeUid],[DefaultStartTime],[DefaultEndTime],[DFTQueuedDateTime],[HistorianUid],[PatientDeclinedClinicalSummary],[HistorianRepName],[SavedByBillingProvider],[SavedByRenderingProvider] FROM INSERTED
			INTERSECT
			SELECT [VisitUid],[ClinicalNoteTypeUid],[AppointmentUid],[PatientCaseUid],[PatientUid],[AccountUid],[SuperbillRequired],[VisitDate],[IsCompleted],[ProviderUid],[ProviderCareTypeUid],[RenderingProviderUid],[ProviderSignatureUid],[ServiceSiteUid],[ServiceSiteTypeUid],[FinancialCenterUid],[SupervisingProviderUid],[Emergency],[AuthorizationCode],[ReferredByProviderUid],[ReferringDate],[PETemplateUid],[OriginalPETemplateUid],[CosignStatusID],[VoiceAttachmentUid],[CaseTypePhaseUid],[CompletedDate],[ABN],[VisitTypeUid],[DefaultStartTime],[DefaultEndTime],[DFTQueuedDateTime],[HistorianUid],[PatientDeclinedClinicalSummary],[HistorianRepName],[SavedByBillingProvider],[SavedByRenderingProvider] FROM DELETED
		)
			RETURN;

		DECLARE @VisitUid UNIQUEIDENTIFIER
		DECLARE @RefillVisitUid UNIQUEIDENTIFIER = ''ADA7EB5D-FD9A-4E9F-88E5-84EDDA9EFC42''
		DECLARE @LabVisitUid UNIQUEIDENTIFIER = ''6A18A657-B912-4C12-828E-A3DF8571D205''


		DECLARE @DFTTable TABLE  
		(  
		  partnerMessageID VARCHAR(50) --Array element contents  
		)  

		INSERT INTO @DFTTable
		Select PM.HL7PartnerMessageUid from HL7partner P LEFT JOIN HL7PartnerMessage PM
		ON
		PM.HL7partnerUid=P.HL7partnerUid
		where 
		PM.MessageType = ''DFT'' 
		and PM.Inactive = 0  
		and P.Inactive = 0 
		and PM.Send = 1
		and PM.SendFunction = ''VisitCharges''


		DECLARE DFT_CUR CURSOR FAST_FORWARD LOCAL FOR 
		  SELECT VisitUid FROM INSERTED 
		DECLARE @COMPLETEDTIME DATETIME

		DECLARE @sendDFTonReadyToSubmit INT
		SELECT @sendDFTonReadyToSubmit = 0  --default to FALSE

		SELECT TOP 1 @sendDFTonReadyToSubmit = isnull(BoolValue,0)
		FROM ListProductParameter 
		WHERE ParameterName = ''SendDFTonReadyToSubmit''


		IF EXISTS (SELECT * FROM listproductparameter WHERE parametername = ''SendDFTonReadyToSubmit'' AND boolvalue = 1)
		BEGIN
			--Set it will use the trigger on Superbill called Superbill_ReadytoSubmit
		Return
		END

		DECLARE @ignoreSuperbillRequired INT
		SELECT @ignoreSuperbillRequired = 0  --default to FALSE

		SELECT TOP 1 @ignoreSuperbillRequired = isnull(BoolValue,0)
		FROM ListProductParameter 
		WHERE ParameterName = ''IgnoreSuperbillRequired''

		DECLARE @resetReadyToSubmit INT
		SELECT @resetReadyToSubmit = 0 
		
		SELECT TOP 1 @resetReadyToSubmit =  isnull(BoolValue,0)
		FROM ListProductParameter 
		WHERE ParameterName = ''ResetReadyToSubmitAfterSend''
		
		DECLARE @SendOnceVisitCompleteNote INT
		SELECT @SendOnceVisitCompleteNote = 0 
		
		DECLARE @NewIsCompleted INT
		DECLARE @PrevIsCompleted INT
		DECLARE @PrevSuperbillrequire INT
		DECLARE @NewSuperbillrequire INT
		
		SELECT TOP 1 @SendOnceVisitCompleteNote =  isnull(BoolValue,0)
		FROM ListProductParameter 
		WHERE ParameterName = ''SendOnceVisitCompleteNote''

		--Use when sending DFT messages and Use Third Party Practice Management set
		Declare @UseThirdParty INT
		Select top 1 @UseThirdParty = isnull(UseThirdPartyPM,0)
		from PracticeSettings
			  
		OPEN DFT_CUR

		FETCH NEXT FROM DFT_CUR INTO @VisitUid

		WHILE @@FETCH_STATUS =0
		BEGIN

		/* BMR 20140128
		Removed temp for removal of SuperbillStatusID change
		
		-- VPA CUSTOM CHANGES
		-- THIS BELOW CONDITION IS ADDED FOR THE VPA CLIENT
		-- TO RESET SUPERBILLSTATUS TO READYTOSUBMIT ONCE THE DFT WENT OUT.
		IF @resetReadyToSubmit = 1 AND 
			(SELECT SuperbillStatusID FROM DELETED WHERE VISITUID = @VISITUID) = 2 AND
			(SELECT IsCompleted FROM DELETED WHERE VisitUid = @VisitUid) = 1 
		BEGIN
		
			-- CMR: This logic now also resides in the Visit.cs BusinessObject
			UPDATE Visit set SuperbillStatusID = 2, LastModifiedDate = GETUTCDATE()				
				WHERE VisitUid = @VisitUid
			GOTO NEXT_LOOP
		END
		-- END VPA CUSTOM CHANGES
		
		IF (@sendDFTonReadyToSubmit = 1) AND
			EXISTS (SELECT * FROM INSERTED WHERE VISITUID = @VISITUID AND ISNULL(SUPERBILLSTATUSID,0) <> 2)
			BEGIN
				GOTO NEXT_LOOP
			END

		*/
			
			
		IF (@SendOnceVisitCompleteNote = 1)
		Begin 
				
			SELECT @NewIsCompleted = IsCompleted FROM INSERTED WHERE VisitUid = @VisitUid
			SELECT @PrevIsCompleted = IsCompleted FROM DELETED WHERE VisitUid = @VisitUid
			SELECT @NewSuperbillRequire= superbillrequired FROM INSERTED WHERE VisitUid = @VisitUid
			SELECT @PrevSuperbillrequire = superbillrequired FROM DELETED WHERE VisitUid = @VisitUid

			-- ONLY GENERATE THE DFT MESSAGE IF THE NOTE WAS NOT PREVIOUSLY COMPLETED BUT IS NOW COMPLETED
			-- TO AVOID GENERATING MULTIPLE MESSAGES
            
			IF (Not (@NewIsCompleted = 1 AND isnull(@PrevIsCompleted,0) = 0)) and 
				(Not (@NewSuperbillRequire = 1 and isnull(@PrevSuperbillrequire,0) = 0))
			BEGIN
				GOTO NEXT_LOOP
			END
			
		End	
	

		  --THIS SECTION DECIDES IF A DFT SHOULD BE SENT
		  IF (SELECT IsCompleted FROM INSERTED WHERE VisitUid = @VisitUid) = 1 AND 
			(SELECT SuperbillRequired FROM INSERTED WHERE VisitUid = @VisitUid) + @UseThirdParty + @ignoreSuperbillRequired >= 1 AND
			(SELECT COUNT(*) FROM INSERTED I 
				--INNER JOIN VisitProcedure VP ON VP.VisitUid = I.VisitUid AND I.VisitUid = @VisitUid 
				--AND IsPerformed <> 0 
				where ((I.VisitTypeUid <> @RefillVisitUid AND I.VisitTypeUid <> @LabVisitUid )OR I.VisitTypeUid IS NULl)) > 0
		  BEGIN
			  --delete any rows in hl7actiontypeobject that match the ones we are about to create
			  delete hl7actiontypeobject where hl7actiontypeobjectuid in
				(  select hl7actiontypeobjectuid
					from hl7actiontypeobject ato
					join @dfttable d on ato.hl7partnermessageuid = d.partnermessageid
					where ato.objectuid = @visituid and ato.actiontype = ''ChargePatient'' and ato.objecttype = ''Visit''
				)
			  
			  INSERT INTO HL7ActionTypeObject (HL7ActionTypeObjectUid, HL7PartnerMessageUid, ActionType, ObjectType,ObjectUid, LastModifiedDate)
			 -- Removed as this is old method of replication(2009) as advised by Kevin : 02/15/11  OUTPUT NEWID(), ''I'', ''HL7ActionTypeObject'', inserted.HL7ActionTypeObjectUid, GETUTCDATE() INTO ReplicationExternalChangeQueue	
			  Select NEWID(), partnerMessageID, ''ChargePatient'',''Visit'', @VisitUid, GETUTCDATE() From @DFTTable
			   
			  --DFTQueuedDate add PRM2011 Patch 7B 
			  Update Visit set DFTQueuedDateTime = GETUTCDATE(), LastModifiedDate = GETUTCDATE()
			  where VisitUid = @VisitUid

		  END
		  NEXT_LOOP:
		  FETCH NEXT FROM DFT_CUR INTO @VisitUid
		END

		CLOSE DFT_CUR
		DEALLOCATE DFT_CUR

		SET NOCOUNT OFF
  END
END



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[HL7UpdateForMDM]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[HL7UpdateForMDM] ON [dbo].[Visit] FOR INSERT,UPDATE AS
	BEGIN
		IF NOT EXISTS ( SELECT TOP 1 * FROM inserted )
			RETURN

		IF dbo.IsReplicating() <> 0
			RETURN
			
		SET NOCOUNT ON 
		DECLARE @VisitUid UNIQUEIDENTIFIER
		DECLARE @MDMTable TABLE  
		(  
			partnerMessageID VARCHAR(50) 
		)  
		INSERT INTO @MDMTable  -- Insert the memory table values
		SELECT 
				HL7PartnerMessageUid 
				FROM HL7PartnerMessage hpm 
					 INNER JOIN HL7Partner hm ON hpm.HL7PartnerUid =  hm.HL7PartnerUid
				WHERE MessageType = ''MDM'' AND 
					  hm.Inactive = 0 AND
					  hpm.Inactive = 0 AND
					  hpm.Send = 1
		IF(SELECT COUNT(*) FROM @MDMTable) = 0
			RETURN

		DECLARE @currentUid uniqueidentifier
		Select @currentuid = null   --initialize/reset variable that controls loop
		Select top 1 @currentuid = partnerMessageID from @MDMTable

		While @currentuid is not null
		Begin
			--MDM T06
			IF ((SELECT IsCompleted FROM INSERTED) = 1 and (SELECT IsCompleted FROM DELETED) = 1) -- check the Note compled 
			BEGIN
				INSERT	HL7ActionTypeObject(HL7PartnerMessageUid, ActionType, ObjectUid, ObjectType, LastModifiedByUid)
				SELECT	pm.HL7PartnerMessageUid, pm.SendFunction,i.VisitUid, ''Update Visit'', i.LastModifiedByUid
					FROM	HL7PartnerMessage pm INNER JOIN HL7Partner p ON pm.HL7PartnerUid = p.HL7PartnerUid
					CROSS JOIN inserted i 
					LEFT JOIN ViewActionTypeObjectPartnerMessage atopm ON  atopm.ObjectType=''Update Visit'' AND pm.HL7PartnerUid = atopm.HL7PartnerUid AND atopm.SendFunction IN (''Create MDM'', ''Update MDM'')
					 WHERE	pm.SendFunction = ''Update MDM'' AND
							  pm.Send = 1 AND
							  pm.Inactive = 0 AND
							  p.Inactive = 0 AND
							  atopm.HL7ActionTypeObjectUid IS NULL
			END
			--MDM T02
			ELSE IF ((SELECT IsCompleted FROM INSERTED) = 1 )
			BEGIN
				INSERT	HL7ActionTypeObject(HL7PartnerMessageUid, ActionType, ObjectUid, ObjectType, LastModifiedByUid)
					SELECT	pm.HL7PartnerMessageUid, pm.SendFunction,i.VisitUid, ''Update Visit'', i.LastModifiedByUid
					FROM	HL7PartnerMessage pm INNER JOIN HL7Partner p ON pm.HL7PartnerUid = p.HL7PartnerUid
							  CROSS JOIN inserted i 
							  LEFT JOIN ViewActionTypeObjectPartnerMessage atopm ON  atopm.ObjectType=''Update Visit'' AND pm.HL7PartnerUid = atopm.HL7PartnerUid AND atopm.SendFunction IN (''Create MDM'', ''Update MDM'')
					WHERE	pm.SendFunction = ''Create MDM'' AND
							  pm.Send = 1 AND
							  pm.Inactive = 0 AND
							  p.Inactive = 0 AND
							  atopm.HL7ActionTypeObjectUid IS NULL
			 END
				
			Delete @MDMTable where partnerMessageID = @currentuid    --remove this row from memory table since we are done with it
			Select @currentuid = null                                             --initialize/reset variable that controls loop, very important to do this at bottom of loop after row has been removed from memory table
			Select top 1 @currentuid = partnerMessageID from @MDMTable --get next UID to work with if there are any left in memory table
	End


END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[SyndromicSurveillance_Visit_Complete]'))
EXEC dbo.sp_executesql @statement = N'/***** Trigger for Syndromic Surveillance ADT messages****/
CREATE TRIGGER [dbo].[SyndromicSurveillance_Visit_Complete] ON [dbo].[Visit] FOR INSERT, UPDATE AS  
IF dbo.IsCacheClient() = 0
BEGIN

	DECLARE @ObjectType varchar(25)
	DECLARE @SendFunction varchar(25)
	
	Set @ObjectType = ''Visit''
	Set @SendFunction =''SyndromicSurveillance''
	
	IF NOT EXISTS (SELECT TOP 1 * 	FROM HL7PartnerMessage 
	WHERE (SendFunction = @SendFunction)	AND Send = 1 AND Inactive = 0)
		RETURN

	DECLARE @ADT_Table TABLE  
	(
	PartnerMessageUid UNIQUEIDENTIFIER --Array element contents  
	)  

	INSERT INTO @ADT_Table
	SELECT	PM.HL7PartnerMessageUid 
	FROM	HL7partner P 
			LEFT JOIN HL7PartnerMessage PM ON PM.HL7partnerUid=P.HL7partnerUid
	WHERE 
			PM.MessageType = ''ADT'' 
			AND PM.MessageEvent = ''A04''
			AND PM.SendFunction = @SendFunction
			AND PM.Inactive = 0  
			AND P.Inactive = 0 
			AND PM.Send = 1

	DECLARE @VisitUid UNIQUEIDENTIFIER
	DECLARE @PatientUid UNIQUEIDENTIFIER

	DECLARE ADT_CUR CURSOR FAST_FORWARD LOCAL FOR 
	SELECT VisitUid, PatientUid FROM INSERTED 

	OPEN ADT_CUR
	FETCH NEXT FROM ADT_CUR INTO @VisitUid, @PatientUid
	WHILE @@FETCH_STATUS =0
	BEGIN
		--THIS SECTION DECIDES IF A CCD SHOULD BE SENT
		IF (SELECT IsCompleted FROM INSERTED WHERE VisitUid = @VisitUid
				AND (VisitTypeUid IS NULL OR VisitTypeUid!=''ADA7EB5D-FD9A-4E9F-88E5-84EDDA9EFC42'')) = 1
		BEGIN

			--delete any rows in hl7actiontypeobject that match the ones we are about to create
			DELETE from HL7ActionTypeObject WHERE HL7ActionTypeObjectUid in
			(SELECT HL7ActionTypeObjectUid FROM HL7ActionTypeObject ato
			JOIN @ADT_Table a ON ato.HL7PartnerMessageUid = a.PartnerMessageUid
			WHERE ato.ObjectUid = @VisitUid and ato.ActionType = @SendFunction and ato.ObjectType = @ObjectType)

			DELETE from HL7Message where HL7MessageUid in
			(SELECT HL7MessageUid FROM HL7Message hm
			JOIN @ADT_Table a ON hm.HL7PartnerMessageUid = a.PartnerMessageUid
			WHERE hm.OriginalObjectUid = @VisitUid and hm.OriginalActionType = @SendFunction and hm.OriginalObjectType = @ObjectType)
			
			
			INSERT	HL7ActionTypeObject(HL7PartnerMessageUid, ActionType, ObjectUid, ObjectType)  
			SELECT	PartnerMessageUid, @SendFunction, @VisitUid, @ObjectType 
			FROM	@ADT_Table

		END
		NEXT_LOOP:
		FETCH NEXT FROM ADT_CUR INTO @VisitUid, @PatientUid
	END
	CLOSE ADT_CUR
	DEALLOCATE ADT_CUR
	SET NOCOUNT OFF
END



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[Visit_InsteadOf_Delete]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[Visit_InsteadOf_Delete]
   ON  [dbo].[Visit]
   INSTEAD OF DELETE
AS 
BEGIN
	SET NOCOUNT ON;

	DECLARE @originatorId VARBINARY(128);
	SELECT @originatorId = dbo.GetChangeTrackingContextFromContextInfo();

	IF @originatorId IS NOT NULL
	BEGIN
		WITH CHANGE_TRACKING_CONTEXT(@originatorId)
		DELETE [VisitDiagnosis]
		FROM [deleted] AS vv
			INNER JOIN [VisitDiagnosis] AS vd ON vv.[VisitUid] = vd.[VisitUid]
	END
	ELSE
	BEGIN
		DELETE [VisitDiagnosis]
		FROM [deleted] AS vv
			INNER JOIN [VisitDiagnosis] AS vd ON vv.[VisitUid] = vd.[VisitUid]
	END

	IF @originatorId IS NOT NULL
	BEGIN
		WITH CHANGE_TRACKING_CONTEXT(@originatorId)
		DELETE [Visit]
		FROM [deleted] AS vv
			INNER JOIN [Visit] AS v ON vv.[VisitUid] = v.[VisitUid]
	END
	ELSE
	BEGIN
		DELETE [Visit]
		FROM [deleted] AS vv
			INNER JOIN [Visit] AS v ON vv.[VisitUid] = v.[VisitUid]
	END
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[VisitAssessmentForm_Delete]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[VisitAssessmentForm_Delete] ON [dbo].[VisitAssessmentForm] AFTER DELETE AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

    DELETE	oo
	FROM	ObservationOrder oo INNER JOIN deleted d ON oo.ObservationOrderUid = d.ObservationOrderUid	

END' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[DFT_Addendums_VisitDiagnosis]'))
EXEC dbo.sp_executesql @statement = N'
-- =============================================
Create TRIGGER [dbo].[DFT_Addendums_VisitDiagnosis] -- Trigger Visit based DFT on Visit Procedure addenda 
   ON  [dbo].[VisitDiagnosis]
   AFTER INSERT,UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	if not exists (
		Select PM.HL7PartnerMessageUid 
			from HL7partner P LEFT JOIN HL7PartnerMessage PM ON	PM.HL7partnerUid=P.HL7partnerUid
		where 
			PM.MessageType = ''DFT''
			and PM.Inactive = 0  
			and P.Inactive = 0 
			and PM.Send = 1
			and PM.SendFunction = ''VisitCharges''
		)
	begin
		return
	end

		IF NOT EXISTS (SELECT ProductParameterUid FROM listproductparameter WHERE parametername = ''TriggerDFTOnVisitProcedureAddenda'' AND boolvalue = 1)
	begin
		return
	end

	-- CONDITIONS:
	-- VisitDiagnosis is changed in Addenda, Visit is completed
	-- and a DFT for the visit has been sent before

	-- Insert statements for trigger here
	update v
		set v.DFTQueuedDateTime = GETUTCDATE() -- just causing trigger to fire
	from inserted i 
		join visit v on i.VisitUid = v.VisitUid and v.IsCompleted = 1 
		join hl7message h on v.visituid = h.OriginalObjectUid
	where 
	i.IsAddendum = 1
END' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[VisitDiagnosis_InsteadOf_Delete]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[VisitDiagnosis_InsteadOf_Delete]
   ON  [dbo].[VisitDiagnosis]
   INSTEAD OF DELETE
AS 
BEGIN
	SET NOCOUNT ON;

	DECLARE @originatorId VARBINARY(128);
	SELECT @originatorId = dbo.GetChangeTrackingContextFromContextInfo();

	IF @originatorId IS NOT NULL
	BEGIN
		WITH CHANGE_TRACKING_CONTEXT(@originatorId)
		DELETE [VisitProcedureDiagnosis]
		FROM [deleted] AS vvd
			INNER JOIN [VisitProcedureDiagnosis] AS vpd ON vvd.[VisitDiagnosisUid] = vpd.[VisitDiagnosisUid]
	END
	ELSE
	BEGIN
		DELETE [VisitProcedureDiagnosis]
		FROM [deleted] AS vvd
			INNER JOIN [VisitProcedureDiagnosis] AS vpd ON vvd.[VisitDiagnosisUid] = vpd.[VisitDiagnosisUid]
	END

	IF @originatorId IS NOT NULL
	BEGIN
		WITH CHANGE_TRACKING_CONTEXT(@originatorId)
		DELETE [VisitDiagnosis]
		FROM [deleted] AS vvd
			INNER JOIN [VisitDiagnosis] AS vd ON vvd.[VisitDiagnosisUid] = vd.[VisitDiagnosisUid]
	END
	ELSE
	BEGIN
		DELETE [VisitDiagnosis]
		FROM [deleted] AS vvd
			INNER JOIN [VisitDiagnosis] AS vd ON vvd.[VisitDiagnosisUid] = vd.[VisitDiagnosisUid]
	END
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[DFT_Addendums]'))
EXEC dbo.sp_executesql @statement = N'-- =============================================
-- Author:		Kevin Crumpton
-- Create date: 08/14/2014
-- Description:	Update Superbill to cause DFT trigger to fire for procs that are Addendums
-- =============================================
CREATE TRIGGER [dbo].[DFT_Addendums] 
   ON  [dbo].[VisitProcedure] 
   AFTER INSERT,UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	IF NOT EXISTS (SELECT * FROM listproductparameter WHERE parametername = ''SendDFTonReadyToSubmit'' AND boolvalue = 1)
	begin
		return
	end

	if not exists (
		Select PM.HL7PartnerMessageUid 
			from HL7partner P LEFT JOIN HL7PartnerMessage PM ON	PM.HL7partnerUid=P.HL7partnerUid
		where 
			PM.MessageType = ''DFT'' 
			and PM.Inactive = 0  
			and P.Inactive = 0 
			and PM.Send = 1
			and PM.SendFunction = ''VisitCharges''
		)
	begin
		return
	end
	
	 IF dbo.IsCacheClient() = 0  
		begin
			-- Insert statements for trigger here
			update s
				set LastModifiedDate = s.LastModifiedDate --just causing trigger to fire
			from inserted i 
				join Superbill s on i.VisitUid = s.VisitUid
			where i.IsAddendum = 1 and i.IsDelete = 0
		end
		
		begin
			-- Insert statements for trigger here
			update v
				set LastModifiedDate = v.LastModifiedDate --just causing trigger to fire
			from inserted i 
				join visit v on i.VisitUid = v.VisitUid
			where i.IsAddendum = 1 and i.IsDelete = 0
		end
	
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[DFT_Addendums_VisitProcedure]'))
EXEC dbo.sp_executesql @statement = N'-- =============================================
Create TRIGGER [dbo].[DFT_Addendums_VisitProcedure] -- Trigger Visit based DFT on Visit Procedure addenda 
   ON  [dbo].[VisitProcedure]
   AFTER INSERT,UPDATE
AS 
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	if not exists (
		Select PM.HL7PartnerMessageUid 
			from HL7partner P LEFT JOIN HL7PartnerMessage PM ON	PM.HL7partnerUid=P.HL7partnerUid
		where 
			PM.MessageType = ''DFT'' 
			and PM.Inactive = 0  
			and P.Inactive = 0 
			and PM.Send = 1
			and PM.SendFunction = ''VisitCharges''
		)
	begin
		return
	end

		IF NOT EXISTS (SELECT ProductParameterUid FROM listproductparameter WHERE parametername = ''TriggerDFTOnVisitProcedureAddenda'' AND boolvalue = 1)
	begin
		return
	end

	-- CONDITIONS:
	-- VisitProcedure is changed in Addenda, Visit is completed
	-- and a DFT for the visit has been sent before

	-- Insert statements for trigger here
	update v
		set v.DFTQueuedDateTime = GETUTCDATE() -- just causing trigger to fire
	from inserted i 
		join visit v on i.VisitUid = v.VisitUid and v.IsCompleted = 1
		join hl7message h on v.visituid = h.OriginalObjectUid
	where 
	i.IsAddendum = 1
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[Audit_Delete]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[Audit_Delete] ON [dbo].[Audit] INSTEAD OF DELETE AS 
		BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
		
		DELETE	ac
		FROM	[AuditCurrent] ac INNER JOIN deleted d ON ac.AuditUid = d.AuditUid
		END' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[Audit_Insert]'))
EXEC dbo.sp_executesql @statement = N'
CREATE TRIGGER [dbo].[Audit_Insert] ON [dbo].[Audit] INSTEAD OF INSERT AS 
		BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		INSERT	[AuditCurrent]
		SELECT	ISNULL(AuditUid, newid()), [Type], TableName, RowPrimaryUid, [Changes],
				Workstation, UserUid, 
				ISNULL(ChangeDate, GETUTCDATE()) AS ChangeDate,
				PatientUid, [Description],
				ISNULL(LastModifiedDate, GETUTCDATE()) AS LastModifiedDate,
				LastModifiedByUid
		FROM	inserted
	    
	END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[Audit_Update]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[Audit_Update] ON [dbo].[Audit] INSTEAD OF UPDATE AS 
		BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		IF UPDATE([Type]) OR UPDATE([Changes]) OR UPDATE([TableName]) OR UPDATE(Workstation) OR UPDATE(UserUid) OR UPDATE([Description]) OR UPDATE(ChangeDate) OR UPDATE(LastModifiedDate) OR UPDATE(LastModifiedByUid)
		BEGIN
			ROLLBACK
			RAISERROR (''Audit updates are not allowed columns.'', 19, 1) WITH LOG;		
		END

		UPDATE	ac
		SET		PatientUid = i.PatientUid
		FROM	[AuditCurrent] ac INNER JOIN inserted i ON ac.AuditUid = i.AuditUid

		UPDATE	aa
		SET		PatientUid = i.PatientUid
		FROM	[AuditArchive] aa INNER JOIN inserted i ON aa.AuditUid = i.AuditUid	    
	END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[AuditFinancials_InsteadOf_Insert]'))
EXEC dbo.sp_executesql @statement = N'


CREATE trigger [dbo].[AuditFinancials_InsteadOf_Insert] ON [dbo].[AuditFinancials] INSTEAD OF INSERT AS
BEGIN
	SET NOCOUNT ON;
	
	INSERT INTO AuditFinancialsArchive
		SELECT * FROM inserted;

END


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[AuditWorkflowLog_Delete]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[AuditWorkflowLog_Delete] ON [dbo].[AuditWorkflowLog] INSTEAD OF DELETE AS 
		BEGIN
		SET NOCOUNT ON;
		
		DELETE	ac
		FROM	[AuditWorkflowLogCurrent] ac INNER JOIN deleted d ON ac.AuditWorkflowLogUid = d.AuditWorkflowLogUid
		END' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[AuditWorkflowLog_Insert]'))
EXEC dbo.sp_executesql @statement = N'
CREATE TRIGGER [dbo].[AuditWorkflowLog_Insert] ON [dbo].[AuditWorkflowLog] INSTEAD OF INSERT AS 
		BEGIN
		SET NOCOUNT ON;

		INSERT	[AuditWorkflowLogCurrent]
		SELECT	ISNULL(AuditWorkflowLogUid, newid())
				, AuditUid
				, ISNULL(WorkflowLogXml, ''<WorkflowLog><Step section=\"Null XML Found\" /></WorkflowLog>'') AS WorkflowLogXml
				, ISNULL(LastModifiedDate, GETUTCDATE()) AS LastModifiedDate
		FROM	inserted

	END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[AuditWorkflowLog_Update]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[AuditWorkflowLog_Update] ON [dbo].[AuditWorkflowLog] INSTEAD OF UPDATE AS 
		BEGIN
		SET NOCOUNT ON;

		UPDATE	ac
		SET		AuditWorkflowLogUid = i.AuditWorkflowLogUid
				, AuditUid = i.AuditUid
				, WorkflowLogXml = i.WorkflowLogXml
				, LastModifiedDate = i.LastModifiedDate
		FROM	[AuditWorkflowLogCurrent] ac INNER JOIN inserted i ON ac.AuditWorkflowLogUid = i.AuditWorkflowLogUid

		UPDATE	aa
		SET		AuditWorkflowLogUid = i.AuditWorkflowLogUid
				, AuditUid = i.AuditUid
				, WorkflowLogXml = i.WorkflowLogXml
				, LastModifiedDate = i.LastModifiedDate
		FROM	[AuditWorkflowLogArchive] aa INNER JOIN inserted i ON aa.AuditWorkflowLogUid = i.AuditWorkflowLogUid	    
	END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[ViewDiagnosisSearchDefinition_Delete]'))
EXEC dbo.sp_executesql @statement = N'


CREATE TRIGGER [dbo].[ViewDiagnosisSearchDefinition_Delete] ON [dbo].[ViewDiagnosisSearchDefinition] INSTEAD OF DELETE AS 
		BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;
		
		DELETE	dsd
		FROM	[ListDiagnosisSearchDefinition] dsd INNER JOIN deleted d ON dsd.DiagnosisSearchDefinitionUid = d.DiagnosisSearchDefinitionUid
		END

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[ViewDiagnosisSearchDefinition_Insert]'))
EXEC dbo.sp_executesql @statement = N'

CREATE TRIGGER [dbo].[ViewDiagnosisSearchDefinition_Insert] ON [dbo].[ViewDiagnosisSearchDefinition] INSTEAD OF INSERT AS 
		BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		INSERT	[ListDiagnosisSearchDefinition]
		SELECT	ISNULL(DiagnosisSearchDefinitionUid, newid()), ExternalID, Name, Definition, ChronicCondition, Inactive,
				UserDefined, LastModifiedByUid, 
				ISNULL(LastModifiedDate, GETUTCDATE()) AS LastModifiedDate
		FROM	inserted
	    
	END

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[ViewDiagnosisSearchDefinition_Update]'))
EXEC dbo.sp_executesql @statement = N'



CREATE TRIGGER [dbo].[ViewDiagnosisSearchDefinition_Update] ON [dbo].[ViewDiagnosisSearchDefinition] INSTEAD OF UPDATE AS 
		BEGIN
		-- SET NOCOUNT ON added to prevent extra result sets from
		-- interfering with SELECT statements.
		SET NOCOUNT ON;

		UPDATE	dsd
		SET		ExternalID = i.ExternalID,
			Name = i.Name,
			Definition = i.Definition,
			Inactive = i.Inactive,
			ChronicCondition = i.ChronicCondition,
			UserDefined = i.UserDefined,
			LastModifiedByUid = i.LastModifiedByUid,
			LastModifiedDate = i.LastModifiedDate
		FROM	[ListDiagnosisSearchDefinition] dsd INNER JOIN inserted i ON dsd.DiagnosisSearchDefinitionUid = i.DiagnosisSearchDefinitionUid
    
	END


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindDocumentBatch_Delete]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[ViewFindDocumentBatch_Delete] ON [dbo].[ViewFindDocumentBatch] INSTEAD OF DELETE AS
BEGIN
	DELETE	db
	FROM	DocumentBatch db INNER JOIN deleted d ON db.DocumentBatchUid = d.DocumentBatchUid
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindDocumentBatch_Update]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[ViewFindDocumentBatch_Update] ON [dbo].[ViewFindDocumentBatch] INSTEAD OF UPDATE AS
BEGIN
	UPDATE	db
	SET		Archive = i.Archive,
			[Description] = i.[Description]
	FROM	DocumentBatch db INNER JOIN inserted i ON db.DocumentBatchUid = i.DocumentBatchUid
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindRoom_Update]'))
EXEC dbo.sp_executesql @statement = N'CREATE Trigger [dbo].[ViewFindRoom_Update] ON [dbo].[ViewFindRoom] INSTEAD OF UPDATE AS
BEGIN
   IF NOT EXISTS(SELECT TOP 1 * FROM inserted)
      RETURN

   UPDATE lr
   SET 
      DisplayOrder     = i.DisplayOrder, 
      LastModifiedDate = GetUTCDate()
   FROM inserted i 
	INNER JOIN ListRoom lr ON lr.RoomUid = i.RoomUid
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[ViewMessages_Delete]'))
EXEC dbo.sp_executesql @statement = N'




CREATE Trigger [dbo].[ViewMessages_Delete] ON [dbo].[ViewMessages] INSTEAD OF DELETE AS
BEGIN
  IF NOT EXISTS ( SELECT TOP 1 * FROM deleted )
    RETURN

	DELETE	m
	FROM	deleted d INNER JOIN HL7Message m ON d.Uid = m.HL7MessageUid
	WHERE	d.Type = 0
	
	--DELETE ANY HL7MESSAGE ROWS ATTACHED TO THE HL7ActionTypeObject row and error that are being deleted
	DELETE M
	FROM deleted d 
		INNER JOIN HL7ActionTypeObject ATO ON D.Uid = ATO.HL7ActionTypeObjectUid
		INNER JOIN HL7MessageError HME ON HME.ActionTypeObjectUid = ATO.HL7ActionTypeObjectUid
		INNER JOIN HL7Message M ON HME.HL7MessageUid = M.HL7MessageUid
	WHERE D.Type = 1
	
	DELETE	ato
	FROM	deleted d INNER JOIN HL7ActionTypeObject ato ON d.Uid = ato.HL7ActionTypeObjectUid
	WHERE	d.Type = 1
END


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[ViewMessages_Update]'))
EXEC dbo.sp_executesql @statement = N'



CREATE Trigger [dbo].[ViewMessages_Update] ON [dbo].[ViewMessages] INSTEAD OF UPDATE AS
BEGIN
  IF NOT EXISTS ( SELECT TOP 1 * FROM inserted )
    RETURN

	IF UPDATE (Reprocess)
	BEGIN
		
		--SPECIAL HANDLING FOR REPROCESSING CLAIM BATCHES
		if EXISTS (SELECT *
					FROM INSERTED i
					join HL7PartnerMessage HPM ON I.HL7PartnerMessageUid = HPM.HL7PartnerMessageUid
					WHERE HPM.MessageType = ''StatementBatch'')
		begin
			UPDATE	m
			SET		m.Status = (Case when m.Status = 400 then 300 --set ready to send if transmission error
									 when m.Status = 100 then 300 --if totally complete/successful then reprocessing just means resending
									 else 0 end),  --otherwise set to reprocess
					LastModifiedDate = GetUTCDate(), RetryMinutes = 1, RetryTime = GETUTCDATE()
			FROM	inserted i INNER JOIN HL7Message m ON i.Uid = m.HL7MessageUid
					join HL7PartnerMessage hpm on hpm.HL7PartnerMessageUid = m.HL7PartnerMessageUid 		
							and i.Reprocess = 1	
		end 
		else
		begin
			UPDATE	m
			SET		m.Status = (Case when m.Status = 400 then 300
									 when hpm.Send = 1 then 300
									 else 0 end),
			LastModifiedDate = GetUTCDate(), RetryMinutes = 1, RetryTime = GETUTCDATE()
			FROM	inserted i INNER JOIN HL7Message m ON i.Uid = m.HL7MessageUid
					join HL7PartnerMessage hpm on hpm.HL7PartnerMessageUid = m.HL7PartnerMessageUid 
			WHERE	i.Type = 0 AND
					i.Reprocess = 1
		end

		--DELETE ANY HL7MESSAGE ROWS ATTACHED TO THE HL7ActionTypeObject row and error that are being deleted
		-- the will be generated when the hl7actiontypeobject row is processed again
		DELETE M
		FROM inserted i 
			INNER JOIN HL7ActionTypeObject ATO ON i.Uid = ATO.HL7ActionTypeObjectUid
			INNER JOIN HL7MessageError HME ON HME.ActionTypeObjectUid = ATO.HL7ActionTypeObjectUid
			INNER JOIN HL7Message M ON HME.HL7MessageUid = M.HL7MessageUid
		
		WHERE i.Type = 1
				AND
				i.Reprocess = 1
		
		UPDATE	ato
		SET		ato.ProcessingError = 0, LastModifiedDate = GetUTCDate()
		FROM	inserted i INNER JOIN HL7ActionTypeObject ato ON i.Uid = ato.HL7ActionTypeObjectUid
		WHERE	i.Type = 1 AND
				i.Reprocess = 1
		
		DELETE	me
		FROM	inserted i INNER JOIN HL7MessageError me ON i.Uid = me.HL7MessageUid
		WHERE	i.Type = 0 AND
				i.Reprocess = 1

		DELETE	me
		FROM	inserted i INNER JOIN HL7MessageError me ON i.Uid = me.ActionTypeObjectUid
		WHERE	i.Type = 1 AND
				i.Reprocess = 1
	END
END





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[ViewSurveyAnswer_Update]'))
EXEC dbo.sp_executesql @statement = N'CREATE Trigger [dbo].[ViewSurveyAnswer_Update] ON [dbo].[ViewSurveyAnswer] INSTEAD OF UPDATE AS
BEGIN
   IF NOT EXISTS(SELECT TOP 1 * FROM inserted)
      RETURN

   UPDATE ss
   SET 
      DisplayOrder     = i.DisplayOrder, 
      LastModifiedDate = GetUTCDate()
   FROM inserted i 
   INNER JOIN RelSurveyAnswerGroupSurveyAnswer ss ON ss.RelSurveyAnswerGroupSurveyAnswerUid = i.RelSurveyAnswerGroupSurveyAnswerUid
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[ViewSurveyQuestion_Update]'))
EXEC dbo.sp_executesql @statement = N'CREATE Trigger [dbo].[ViewSurveyQuestion_Update] ON [dbo].[ViewSurveyQuestion] INSTEAD OF UPDATE AS
BEGIN
   IF NOT EXISTS(SELECT TOP 1 * FROM inserted)
      RETURN

   UPDATE ss
   SET 
      DisplayOrder     = i.DisplayOrder, 
      LastModifiedDate = GetUTCDate()
   FROM inserted i 
   INNER JOIN RelSurveySectionSurveyQuestion ss ON ss.RelSurveySectionSurveyQuestionUid = i.RelSurveySectionSurveyQuestionUid
END
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[ViewSurveySection_Update]'))
EXEC dbo.sp_executesql @statement = N'CREATE Trigger [dbo].[ViewSurveySection_Update] ON [dbo].[ViewSurveySection] INSTEAD OF UPDATE AS
BEGIN
   IF NOT EXISTS(SELECT TOP 1 * FROM inserted)
      RETURN

   UPDATE ss
   SET 
      DisplayOrder     = i.DisplayOrder, 
      LastModifiedDate = GetUTCDate()
   FROM inserted i 
   INNER JOIN RelSurveySurveySection ss ON ss.RelSurveySurveySectionUid = i.RelSurveySurveySectionUid
END
' 
GO

