SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[RawAttachment_SaveContent]'))
EXEC dbo.sp_executesql @statement = N'CREATE TRIGGER [dbo].[RawAttachment_SaveContent] ON [dbo].[RawAttachment] 
instead of UPDATE

AS
SET NOCOUNT ON

IF EXISTS (select TOP 1 * FROM inserted) 
BEGIN
	UPDATE r
		SET r.LastModifiedDate = i.LastModifiedDate, r.UserDefined = i.UserDefined
		FROM RAWATTACHMENT r
		JOIN inserted I ON R.AttachmentUid = I.ATTACHMENTUID

	UPDATE r
		SET r.AttachmentContent = i.attachmentcontent
		FROM RAWATTACHMENT r
		JOIN inserted I ON R.AttachmentUid = I.ATTACHMENTUID
		WHERE i.AttachmentContent IS NOT NULL

	UPDATE r
		SET r.InkImage = i.InkImage
		FROM RAWATTACHMENT r
		JOIN inserted I ON R.AttachmentUid = I.ATTACHMENTUID
		WHERE i.InkImage IS NOT NULL
end
' 
GO

