
-- #123023 _ListDataFormatter_FieldDefinition_Add_PatientMedicationSummary.sql
update ListDataFormatter
set FieldDefinition = '<Fields>
  <CustomFormatter Type="Internal" Origin="Visit" />
  <CustomFormatter Name="Custom Patient Data" Origin="Patient" />
  <CalledDataFormatter Uid="18667128-46B9-4648-B436-0C7A412DFFD5" Prefix="Visit" />
  <CalledDataFormatter Uid="8516DA6B-40B2-4DD7-A728-54B40DE960D0" Prefix="" />
  <CalledDataFormatter Uid="9D7520C3-B507-463F-9CFD-18BDE5A74677" Prefix="" />
  <CalledDataFormatter Uid="9D7520C3-B507-463F-9CFD-18BDE5A74677" Prefix="Rendering" />
  <CalledDataFormatter Uid="9D7520C3-B507-463F-9CFD-18BDE5A74677" Prefix="ReferredBy" />
  <CalledDataFormatter Uid="9D7520C3-B507-463F-9CFD-18BDE5A74677" Prefix="ReferTo" />
  <CalledDataFormatter Uid="161530C1-4D46-467A-96EA-E7234658231D" Prefix="" />
  <CalledDataFormatter Uid="613EA28C-45B0-4520-96B4-A5C512175312" Prefix="Visit" />
  <CalledDataFormatter Uid="613EA28C-45B0-4520-96B4-A5C512175312" Prefix="Patient" />
  <CalledDataFormatter Uid="AD31E16F-3298-4C77-9805-AA5CE115A338" Prefix="" />
  <CalledDataFormatter Uid="161530C1-4D46-467A-96EA-E7234658231D" Prefix="Next" />
  <CalledDataFormatter Uid="9D7520C3-B507-463F-9CFD-18BDE5A74677" Prefix="NextAppointment" />
  <CalledDataFormatter Uid="9D7520C3-B507-463F-9CFD-18BDE5A74677" Prefix="PrimaryCare" />
  <Field Name="VisitDate" Layout="Date" />
  <Field Name="VisitStatus" />
  <Field Name="VisitSavedDate" Layout="Date" />
  <Field Name="VisitCompletedDate" Layout="Date" />
  <Field Name="VisitProviderSignature" AllowsSizing="True" PermitsText="False" formatTypeAqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.ControlParmEditVisit" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="Provider''s signature for this visit - will only print when the note is complete/signed" />
  <Field Name="CCHPI" AllowsList="True" AllowsText="True" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.ControlParmParagraphBullet" MaxLevel="1" />
  <Field Name="CCComment" />
  <Field Name="HPIComment" />
  <Field Name="ROSParagraph" AllowsList="True" AllowsText="True" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.ControlParmParagraphBullet" MaxLevel="0" />
  <Field Name="ROSComment" />
  <Field Name="PE" AllowsList="True" AllowsText="True" />
  <Field Name="PEComment" />
  <Field Name="DXComment" />
  <Field Name="DX" AllowsList="True" AllowsText="True" />
  <Field Name="RXComment" />
  <Field Name="RX" AllowsList="True" AllowsText="True" />
  <Field Name="RXAdministeredDetail" />
  <Field Name="RXDetail" AllowsList="True" AllowsText="True" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="Rx information as well as addendums made" />
  <Field Name="ServicesOrderedComment" />
  <Field Name="ServicesOrdered" AllowsList="True" AllowsText="True" />
  <Field Name="ServicesPerformedComment" />
  <Field Name="ServicesPerformed" AllowsList="True" AllowsText="True" />
  <Field Name="ReviewOfHistoryParagraph" />
  <Field Name="PlanComment" />
  <Field Name="PlanParagraph" />
  <Field Name="CCPhrase" />
  <Field Name="CCPhraseNotes" />
  <Field Name="CCHPIClause" />
  <Field Name="OtherCC" />
  <Field Name="ReturnVisitTime" />
  <Field Name="SOResults" />
  <Field Name="SPResults" />
  <Field Name="ServicesOrderedWithCodes" AllowsList="True" AllowsText="True" />
  <Field Name="ServicesPerformedWithCodes" AllowsList="True" AllowsText="True" />
  <Field Name="VitalsWeight" />
  <Field Name="VitalsHeight" />
  <Field Name="VitalsBMI" />
  <Field Name="VitalsHeadCircumference" />
  <Field Name="VitalsTemperature" />
  <Field Name="VitalsRespirationRate" />
  <Field Name="VitalsSpO2" />
  <Field Name="VitalsSittingHeartRate" />
  <Field Name="VitalsStandingHeartRate" />
  <Field Name="VitalsSupineHeartRate" />
  <Field Name="VitalsBloodPressure" />
  <Field Name="VitalsBloodPressure2" />
  <Field Name="VitalsBloodPressure3" />
  <Field Name="VitalsBloodPressure4" />
  <Field Name="DXAssociationParagraph" />
  <Field Name="PatientInstruction" />
  <Field Name="PEAbnormalParagraph" />
  <Field Name="RXNoAssociation" />
  <Field Name="VitalsComment" />
  <Field Name="AttachmentsToVisitList" />
  <Field Name="ROSParagraphDeniesOnly" />
  <Field Name="ROSParagraphComplaintsOnly" />
  <Field Name="DXWithCodes" AllowsList="True" AllowsText="True" />
  <Field Name="DXCodesOnly" AllowsList="True" AllowsText="True" />
  <Field Name="DXCode1" />
  <Field Name="DXCode2" />
  <Field Name="DXCode3" />
  <Field Name="DXCode4" />
  <Field Name="CCAddendumNotes" />
  <Field Name="HPIAddendumNotes" />
  <Field Name="ROSAddendumNotes" />
  <Field Name="DxAddendumNotes" />
  <Field Name="PEAddendumNotes" />
  <Field Name="RxAddendumNotes" />
  <Field Name="SODxAssociations" />
  <Field Name="SOAddendumNotes" />
  <Field Name="SPEandMComment" />
  <Field Name="SPDxAssociations" />
  <Field Name="SPAddendumNotes" />
  <Field Name="ReimbursementRuleServicesParagraph" />
  <Field Name="ReimbursementRuleServicesCodesAndReasons" />
  <Field Name="ObservationValues" AllowsList="True" AllowsTable="True" />
  <Field Name="VisitServiceSiteName" />
  <Field Name="VisitServiceSiteAddresses" Layout="Address" />
  <Field Name="VisitServiceSitePhones" Layout="Phone" />
  <Field Name="VisitApprovalStatus" />
  <Field Name="ReferralProvidersList" />
  <Field Name="NextAppointmentsList" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="Obsolete, use the NextAppointmentsListAll field" />
  <Field Name="FaxToReferringProvider" />
  <Field Name="FaxToReferralProvider" />
  <Field Name="FaxToPatient" />
  <Field Name="FaxToPrimaryCareProvider" />
  <Field Name="VisitCosignSignature" AllowsSizing="True" PermitsText="False" />
  <Field Name="VisitCosignStatus" />
  <Field Name="RXShort" AllowsList="True" AllowsText="True" />
  <Field Name="RXShortWithAssociation" AllowsList="True" AllowsText="True" />
  <Field Name="ClinicalNoteType" />
  <Field Name="ResultsAssociatedThisVisit" AllowsList="True" AllowsText="True" />
  <Field Name="ResultsAssociatedThisVisitFullComments" AllowsList="True" AllowsText="True" />
  <Field Name="AssessmentForms" />
  <Field Name="ActiveMedicationBeforeVisit" AllowsList="True" AllowsText="True" />
  <Field Name="ActiveMedicationBeforeVisitShort" AllowsList="True" AllowsText="True" />
  <Field Name="ActiveMedicationBeforeVisitWithAssociations" AllowsList="True" AllowsText="True" />
  <Field Name="ActiveMedicationBeforeVisitShortWithAssociations" AllowsList="True" AllowsText="True" />
  <Field Name="PatientMedicationSummary" AllowsTable="True" dataTypeAqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditMedSummary" formatTypeAqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.ControlParmEditVisit" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="Use Patient Medication Summary to display the patient''s current medication, medication prescribed in the visit, or medication discontinued in the visit." />
  <Field Name="CCCommentAddendumNotes" />
  <Field Name="HPICommentAddendumNotes" />
  <Field Name="ROSCommentAddendumNotes" />
  <Field Name="PECommentAddendumNotes" />
  <Field Name="DXCommentAddendumNotes" />
  <Field Name="RXCommentAddendumNotes" />
  <Field Name="ServicesOrderedCommentAddendumNotes" />
  <Field Name="ServicesPerformedCommentAddendumNotes" />
  <Field Name="PlanCommentAddendumNotes" />
  <Field Name="VitalsCommentAddendumNotes" />
  <Field Name="PatientInstructionAddendumNotes" />
  <Field Name="ServicesOrderedByGroup" AllowsList="True" AllowsText="True" />
  <Field Name="ServicesOrderedWithCodeByGroup" AllowsList="True" AllowsText="True" />
  <Field Name="ServicesPerformedByGroup" AllowsList="True" AllowsText="True" />
  <Field Name="ServicesPerformedWithCodeByGroup" AllowsList="True" AllowsText="True" />
  <Field Name="ServicesOrderedHistory" AllowsList="True" AllowsTable="True" />
  <Field Name="ServicesPerformedHistory" AllowsList="True" AllowsTable="True" />
  <Field Name="DSMIVDX" AllowsList="True" AllowsText="True" />
  <Field Name="DSMIVDXWithCodes" AllowsList="True" AllowsText="True" />
  <Field Name="RXWithTracking" AllowsList="True" AllowsText="True" />
  <Field Name="VitalsAddendumNotes" />
  <Field Name="MedicationDiscontinuedInVisit" AllowsList="True" AllowsText="True" />
  <Field Name="GeneralComment" />
  <Field Name="InternalNotes" />
  <Field Name="InternalNotesAddendumNotes" />
  <Field Name="Historian" />
  <Field Name="MedicalDecisionMaking" />
  <Field Name="VisitAccountName" />
  <Field Name="VisitAccountTotalBalance" />
  <Field Name="VisitAccountType" />
  <Field Name="VisitAccountFundType" />
  <Field Name="VisitAccountEligibilityFund" />
  <Field Name="VisitAccountRegion" />
  <Field Name="VisitAccountPatientBalance" />
  <Field Name="VisitConfidentialNote" />
  <Field Name="ABNProcedures" AllowsTable="True" />
  <Field Name="ABNProceduresSpanish" AllowsTable="True" />
  <Field Name="VisitReferredTo" AllowsList="True" AllowsTable="True" />
  <Field Name="ArticulatedPlanText" />
  <Field Name="ArticulatedPlanTextAddendumNotes" />
  <Field Name="StartTime" Layout="Date" Definition="Start time of the visit." />
  <Field Name="EndTime" Layout="Date" Definition="End time of the visit." />
  <Field Name="VisitActionItem" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="Reminders or notes to yourself or another provider for something you need to talk about when the patient comes back in the office for the next visit." />
  <Field Name="ActivitySinceLastVisit" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="Notes about patient activity since last visit that remain with the patient until any of the patient''s notes are closed on FND." />
  <Field Name="NextAppointmentsListAll" dataTypeAqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditFutureAppointments" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="Use Next Appointment List to display all upcoming appointments for patient based on the days or amount selected." />
</Fields>'
where DataFormatterUid = '60CD5640-0B0F-4A76-92D7-164978F9C557'
GO
-- #123023 end

-- #119444 _HTM_ListAttachmentHandler.sql
IF EXISTS (SELECT AttachmentHandlerUid FROM ListAttachmentHandler WHERE Name = 'HTM')
BEGIN
   UPDATE ListAttachmentHandler SET
       AttachmentHandlerUid = '0834E069-4852-40F5-B0B1-802D408AE11D',
      ExternalID = NULL,
      FileNameWildcard = '*.htm;*.html',
      CompressionUid = NULL,
      ViewerAQN = 'iMedica.Prm.Client.UI.Attachments.ControlAttachment_Browser',
      PrinterAQN = 'iMedica.Prm.Client.UI.Attachments.PrintAttachment_Direct',
      ExternalViewerPath = NULL,
      AutoOpen = 0,
      Notes = NULL,
      Inactive = 0,
      Priority = 0,
      BlockUpload = 0,
      UserDefined = 0,
      LastModifiedByUid = NULL,
      LastModifiedDate = '2023-04-10 19:00:00.000'
   WHERE Name = 'HTM'
END
ELSE
BEGIN
   INSERT INTO ListAttachmentHandler(
      AttachmentHandlerUid, ExternalID, Name, FileNameWildcard, CompressionUid, ViewerAQN, PrinterAQN,
      ExternalViewerPath, AutoOpen, Notes, Inactive, Priority, BlockUpload, UserDefined, LastModifiedByUid, LastModifiedDate)
    VALUES(
       '0834E069-4852-40F5-B0B1-802D408AE11D', NULL, 'HTM', '*.htm;*.html', NULL, 'iMedica.Prm.Client.UI.Attachments.ControlAttachment_Browser', 'iMedica.Prm.Client.UI.Attachments.PrintAttachment_Direct',
      NULL, 0, NULL, 0, 0, 0, 0, NULL, '2023-04-10 19:00:00.000')
END
GO

-- #128347_Migration script.sql
-- 128347 CareTrak: Inactivate Clinical Note Slider by Default
update ListUIControl set Inactive = 1 where UIControlUid = '1D74D403-93AA-4286-AEA2-CBF5F901F8F9'
go
update ListFormLayout set Inactive = 1 where FormLayoutUid = 'B7DAB5AA-2FF5-489D-814D-6D616632FA2E'
go

-- #128019_Migration script.sql
-- #128019 - EM Slider: Remove Prolonged code 99417
update ListEMConfiguration set [Configuration] = '{
  "ShowEMStandard": true,
  "Name": "Home/Residence Services",
  "PlaceOfService": 7,
  "TextUnderRadioSelection": "Time can be considered the key factor to qualify for a particular level of E&M services when at least 50% of the provider''s time is spent counseling and/or coordination of care.",
  "UpperSelectionLabel": {
    "Name": "Home/Residence Services",
    "Options": [
      {
        "Name": "New",
        "TypeOfService": 19,
        "AllowMedicalDecisionMaking": true,
        "AllowTime": true,
        "AllowSlider": true,
        "EMTimeCodes": [
          {
            "LevelOfService": 0,
            "Code": "None",
            "MDMValue": "0",
            "Time": "None",
            "AllowMulti": false,
            "CalculationTime": 0
          },
          {
            "LevelOfService": 1,
            "Code": "99341",
            "MDMValue": "1",
            "Time": "15 minutes",
            "AllowMulti": false,
            "CalculationTime": 0
          },
          {
            "LevelOfService": 2,
            "Code": "99342",
            "MDMValue": "2",
            "Time": "30 minutes",
            "AllowMulti": false,
            "CalculationTime": 0
          },
          {
            "LevelOfService": 3,
            "Code": "99344",
            "MDMValue": "3",
            "Time": "60 minutes",
            "AllowMulti": false,
            "CalculationTime": 0
          },
          {
            "LevelOfService": 4,
            "Code": "99345",
            "MDMValue": "4",
            "Time": "75 minutes",
            "AllowMulti": false,
            "CalculationTime": 0
          }
        ],
        "DataLabel": null,
        "AdditionalInformation": null
      },
      {
        "Name": "Established",
        "TypeOfService": 20,
        "AllowMedicalDecisionMaking": true,
        "AllowTime": true,
        "AllowSlider": true,
        "EMTimeCodes": [
          {
            "LevelOfService": 0,
            "Code": "None",
            "MDMValue": "0",
            "Time": "None",
            "AllowMulti": false,
            "CalculationTime": 0
          },
          {
            "LevelOfService": 1,
            "Code": "99347",
            "MDMValue": "1",
            "Time": "20 minutes",
            "AllowMulti": false,
            "CalculationTime": 0
          },
          {
            "LevelOfService": 2,
            "Code": "99348",
            "MDMValue": "2",
            "Time": "30 minutes",
            "AllowMulti": false,
            "CalculationTime": 0
          },
          {
            "LevelOfService": 3,
            "Code": "99349",
            "MDMValue": "3",
            "Time": "40 minutes",
            "AllowMulti": false,
            "CalculationTime": 0
          },
          {
            "LevelOfService": 4,
            "Code": "99350",
            "MDMValue": "4",
            "Time": "60 minutes",
            "AllowMulti": false,
            "CalculationTime": 0
          }
        ],
        "DataLabel": null,
        "AdditionalInformation": null
      }
    ]
  },
  "DetailLabel": {
    "Name": "Home/Residence Detail",
    "Options": [
      {
        "Name": "None",
        "PlaceOfServiceDetail": 0
      },
      {
        "Name": "DOM",
        "PlaceOfServiceDetail": 1
      },
      {
        "Name": "ALF",
        "PlaceOfServiceDetail": 2
      },
      {
        "Name": "AFC",
        "PlaceOfServiceDetail": 3
      }
    ]
  }
}',
LastModifiedDate = '4/26/2023'
where EMConfigurationUid = '0585EE72-FCDD-4558-94EF-99C9D8D72566'
go


update ListEMConfiguration set [Configuration] = '{
  "ShowEMStandard": true,
  "Name": "Office",
  "PlaceOfService": 1,
  "TextUnderRadioSelection": "Time can be considered the key factor to qualify for a particular level of E&M services when at least 50% of the provider''s time is spent counseling and/or coordination of care.",
  "UpperSelectionLabel": {
    "Name": "Office",
    "Options": [
      {
        "Name": "New",
        "TypeOfService": 1,
        "AllowMedicalDecisionMaking": true,
        "AllowTime": true,
        "AllowSlider": true,
        "EMTimeCodes": [
          {
            "LevelOfService": 0,
            "Code": "None",
            "MDMValue": "0",
            "Time": "None",
            "AllowMulti": false,
            "CalculationTime": 0
          },
          {
            "LevelOfService": 1,
            "Code": "99202",
            "MDMValue": "1",
            "Time": "15-29 minutes",
            "AllowMulti": false,
            "CalculationTime": 0
          },
          {
            "LevelOfService": 2,
            "Code": "99203",
            "MDMValue": "2",
            "Time": "30-44 minutes",
            "AllowMulti": false,
            "CalculationTime": 0
          },
          {
            "LevelOfService": 3,
            "Code": "99204",
            "MDMValue": "3",
            "Time": "45-59 minutes",
            "AllowMulti": false,
            "CalculationTime": 0
          },
          {
            "LevelOfService": 4,
            "Code": "99205",
            "MDMValue": "4",
            "Time": "60-74 minutes",
            "AllowMulti": false,
            "CalculationTime": 0
          }
        ],
        "DataLabel": null,
        "AdditionalInformation": null
      },
      {
        "Name": "Established",
        "TypeOfService": 2,
        "AllowMedicalDecisionMaking": true,
        "AllowTime": true,
        "AllowSlider": true,
        "EMTimeCodes": [
          {
            "LevelOfService": 0,
            "Code": "None",
            "MDMValue": "0",
            "Time": "None",
            "AllowMulti": false,
            "CalculationTime": 0
          },
          {
            "LevelOfService": 1,
            "Code": "99211",
            "MDMValue": "-1",
            "Time": "",
            "AllowMulti": false,
            "CalculationTime": 0
          },
          {
            "LevelOfService": 2,
            "Code": "99212",
            "MDMValue": "1",
            "Time": "10-19 minutes",
            "AllowMulti": false,
            "CalculationTime": 0
          },
          {
            "LevelOfService": 3,
            "Code": "99213",
            "MDMValue": "2",
            "Time": "20-29 minutes",
            "AllowMulti": false,
            "CalculationTime": 0
          },
          {
            "LevelOfService": 4,
            "Code": "99214",
            "MDMValue": "3",
            "Time": "30-39 minutes",
            "AllowMulti": false,
            "CalculationTime": 0
          },
          {
            "LevelOfService": 5,
            "Code": "99215",
            "MDMValue": "4",
            "Time": "40-54 minutes",
            "AllowMulti": false,
            "CalculationTime": 0
          }
        ],
        "DataLabel": null,
        "AdditionalInformation": null
      },
      {
        "Name": "Consultation",
        "TypeOfService": 3,
        "AllowMedicalDecisionMaking": true,
        "AllowTime": true,
        "AllowSlider": true,
        "EMTimeCodes": [
          {
            "LevelOfService": 0,
            "Code": "None",
            "MDMValue": "0",
            "Time": "None",
            "AllowMulti": false,
            "CalculationTime": 0
          },
          {
            "LevelOfService": 1,
            "Code": "99242",
            "MDMValue": "1",
            "Time": "20 minutes",
            "AllowMulti": false,
            "CalculationTime": 0
          },
          {
            "LevelOfService": 2,
            "Code": "99243",
            "MDMValue": "2",
            "Time": "30 minutes",
            "AllowMulti": false,
            "CalculationTime": 0
          },
          {
            "LevelOfService": 3,
            "Code": "99244",
            "MDMValue": "3",
            "Time": "40 minutes",
            "AllowMulti": false,
            "CalculationTime": 0
          },
          {
            "LevelOfService": 4,
            "Code": "99245",
            "MDMValue": "4",
            "Time": "55 minutes",
            "AllowMulti": false,
            "CalculationTime": 0
          }
        ],
        "DataLabel": null,
        "AdditionalInformation": null
      }
    ]
  },
  "DetailLabel": null
}',
LastModifiedDate = '5/4/2023'
where EMConfigurationUid = '8A7AE025-D124-4495-9FD0-0F01E8A92FF8'
GO
-- #128019 end

-- #128962 _MasterPharmacy_3316925.sql
UPDATE MasterPharmacy SET Inactive = 1 WHERE MasterPharmacyUid = '00000000-0000-0000-0001-000003316925'
UPDATE ListPharmacy SET Inactive = 1 WHERE MasterPharmacyUid = '00000000-0000-0000-0001-000003316925'
GO

--#130309 - Turn off EventDrivenData in ListProductParameter
--Set Boolvalue to prevent EDDDataBrokerTask from running as well as turn off features from being monitored.
Update ListProductParameter Set BoolValue = 0, XmlValue = 
'<EventDrivenDataFeatures>
  <Feature Name="Appointment" Inactive="true" />
  <Feature Name="Message" Inactive="true" />
  <Feature Name="HospitalRound" Inactive="true" />
  <Feature Name="Visit" Inactive="true" />
</EventDrivenDataFeatures>'
where ProductParameterUid = 'D770105F-2BEA-4220-8FBF-16ED3AACB1AE'
GO

-- #124568 _CDC_Vaccine_Code_Set_Mar_2_2023_Migration.sql
--*****New NDC11s*****
--80631-0102-01
IF NOT EXISTS(SELECT * FROM VaccineUnitUse WHERE NDC11 = '80631-0102-01')
BEGIN
   INSERT [dbo].[VaccineUnitUse] ([VaccineUnitUseUid], [NDCInnerID], [UseUnitLabeler], [UseUnitProduct], [UseUnitPackage], [UseUnitPropName], [UseUnitGenericName], [UseUnitLabelerName], [UseUnitstartDate], [UseUnitEndDate], [UseUnitPackForm], [UseUnitGTIN], [CVXCode], [CVXShortDescription], [NoInner], [NDC11], [LastUpdatedDate], [GTIN], [MVX], [Inactive], [UserDefined], [LastModifiedByUid], [LastModifiedDate]) VALUES (N'5fb7a94f-2a4e-43a9-9afd-dddaa357135d', 4055, N'80631', N'102', N'01', N'NOVAVAX COVID-19 Vaccine, Adjuvanted', N'SARS-COV-2 (COVID-19) vaccine, Subunit, recombinant spike protein-nanoparticle+Matrix-M1 Adjuvant, preservative free, 0.5mL per dose', N'Novavax, Inc.', N'20230201', N'', N'VIAL, MULTI-DOSE, 2.5 mL', N'', N'211', N'COVID-19, subunit, rS-nanoparticle+Matrix-M1 Adjuvant, PF, 0.5 mL', 0, N'80631-0102-01', CAST(N'2023-02-22T00:00:00.000' AS DateTime), N'', N'NVX', 0, 0, NULL, CAST(N'2023-04-19T22:30:41.273' AS DateTime))
END
--58160-0740-02
IF NOT EXISTS(SELECT * FROM VaccineUnitUse WHERE NDC11 = '58160-0740-02')
BEGIN
   INSERT [dbo].[VaccineUnitUse] ([VaccineUnitUseUid], [NDCInnerID], [UseUnitLabeler], [UseUnitProduct], [UseUnitPackage], [UseUnitPropName], [UseUnitGenericName], [UseUnitLabelerName], [UseUnitstartDate], [UseUnitEndDate], [UseUnitPackForm], [UseUnitGTIN], [CVXCode], [CVXShortDescription], [NoInner], [NDC11], [LastUpdatedDate], [GTIN], [MVX], [Inactive], [UserDefined], [LastModifiedByUid], [LastModifiedDate]) VALUES (N'0e84eddd-cd02-4b9d-a61f-ea78358492b5', 4054, N'58160', N'740', N'02', N'Rotarix', N'ROTAVIRUS VACCINE, LIVE, ORAL, PRE-FILLED APPLICATOR', N'GlaxoSmithKline Biologicals SA', N'20230201', N'', N'APPLICATOR 1.5 mL', N'', N'119', N'rotavirus, monovalent', 0, N'58160-0740-02', CAST(N'2023-02-13T00:00:00.000' AS DateTime), N'', N'SKB', 0, 0, NULL, CAST(N'2023-04-19T22:30:41.273' AS DateTime))
END
--****************************

--*****ListCVX Updates*****
Update ListCVXCode Set CVXShortDesc = 'dengue fever tetravalent', CVXFullVaccineName = 'dengue fever vaccine, tetravalent'
WHERE Name = '56'

Update ListCVXCode Set CVXShortDesc = 'meningococcal conjugate quadrivalent, MenACWY-TT (MCV4)', CVXFullVaccineName = 'meningococcal polysaccharide (groups A, C, Y, W-135) tetanus toxoid conjugate vaccine 0.5mL dose, preservative free'
WHERE Name = '203'

Update ListCVXCode Set CVXShortDesc = 'Vaccinia, smallpox Mpox vaccine live, PF, SQ or ID injection', CVXFullVaccineName = 'Vaccinia, smallpox monkeypox vaccine, live attenuated, preservative free, subcutaneous or intradermal injection'
WHERE Name = '206'
--****************************

--*****Reactivated NDCs, set UseUnitEndDate blank & LastUpdatedDate of 02/01/2023 from the following ******
UPDATE VaccineUnitUse Set UseUnitEndDate = '', LastUpdatedDate='2023-02-01 00:00:00.000' WHERE NDC11 in (
'49281-0606-58', 
'43528-0003-01', 
'49281-0246-58',
'49281-0589-58',
'50632-0013-01',
'49281-0215-58',  
'49281-0215-88',
'49281-0790-38',
'49281-0790-88',
'49281-0915-58',
'49281-0915-68'
)
--****************************
GO
-- #124568 end

-- #131698 _RemoveDuplicateCQM2023LRMRow.sql
IF (SELECT COUNT(*) FROM ListRuleMeasure WHERE Name = 'CQM2023') > 1 AND EXISTS (SELECT 1 FROM ListRuleMeasure WHERE Name = 'CQM2023' AND RuleMeasureUid = '9B9EB57A-84AA-48F4-97B8-618AC0B3885D')
BEGIN
   DELETE
   FROM ListRuleMeasure
   WHERE Name = 'CQM2023'
   AND RuleMeasureUid <> '9B9EB57A-84AA-48F4-97B8-618AC0B3885D'
END
GO

-- #130822 _homepage-tile-config-migration_Linked-Apps_canPrint.sql
-- Main logic:
-- Updates ListTileConfiguration and UserTileConfiguration based on changes to
-- default values of properties, or new properties, or deleted properties in TileConfigurationDto
-- The user-changeable properties need to only be migrated for systemdefined rows
-- and the non-userchangeable stuff needs to be migrated for all rows

-- Try to run this first as a trial run to make sure it accomplishes the changes you expect
SET XACT_ABORT ON;
GO
BEGIN TRANSACTION

-- set to 1 to see what the result will be without actually applying it to the database,
-- set to 0 to commit the transaction
DECLARE @trialRun bit = 0

-- Inputs:
DECLARE @pathToObjectContainingProperty NVARCHAR(MAX) = '$'
DECLARE @propertyName NVARCHAR(MAX) = 'canPrint'
-- set to string with the value or null
DECLARE @newValue NVARCHAR(MAX) = 'false'
-- This is the sql data type for @newValue; leave it blank to just handle like a string
-- the cases where this matters are below in the code
-- other options are bit, int, numeric, decimal
DECLARE @newValueType NVARCHAR(MAX) = 'bit'
-- JSON_MODIFY prefix
-- https://learn.microsoft.com/en-us/sql/t-sql/functions/json-modify-transact-sql?view=sql-server-ver16#arguments
-- format: [append] [ lax | strict ]
DECLARE @modifyPrefix NVARCHAR(MAX) = 'lax'
DECLARE @currentTileTypeUid uniqueidentifier = 'C5597BE5-A524-420A-AF61-956652479B21'

-- this is an example object that only contains properties
-- that the user can't change
-- it should basically match the Non-changeable properties in TS for TileConfigurationDto
DECLARE @exampleNonUserChangeableObject NVARCHAR(max) = '
{
  "TileTypeId": "DFEE9D62-92D6-4068-845F-CB11C528D95D",
  "TileTypeName": "Replication Monitor",
  "TileType": 0,
  "Description": "",
  "ShortName": "",
  "TileInstanceId": "0561d8a0-c454-409a-97c5-4df8e62be8f6",
  "isRequired": false,
  "isUnique": false,
  "isCollapsible": true,
  "isConfigurable": false,
  "canLoad": false,
  "isLoaded": false,
  "canMoreVert": false,
  "canRefresh": true,
  "canSort": false,
  "canMaximize": true,
  "displayHeader": true,
  "displayFooter": true,
  "canPrint": false
}
'

-- Calculated variables:
DECLARE @fullPropertyPath NVARCHAR(MAX) = @pathToObjectContainingProperty + '.' + @propertyName
DECLARE @JSON_MODIFY_Path NVARCHAR(MAX) = @modifyPrefix + ' ' + @fullPropertyPath
DECLARE @userChangeable bit =
   CASE WHEN EXISTS(SELECT 1 FROM OPENJSON(@exampleNonUserChangeableObject, '$') WHERE [key] = @propertyName)
      THEN 0
      ELSE 1
   END

SELECT
   @fullPropertyPath as '@fullPropertyPath',
   @newValue as '@newValue',
   @currentTileTypeUid as '@currentTileTypeUid',
   @userChangeable as '@userChangeable'


DECLARE @UpdatedLTC UIDLIST
UPDATE ListTileConfiguration
SET
   Data =
      CASE WHEN (ISJSON(Data) > 0)
          THEN CASE WHEN @newValueType = 'bit'
                  -- have to do a CAST here to not have '' around the true or false
                  -- we may have to add other special cases here as well
                  THEN JSON_MODIFY(Data, 'lax' + ' ' + '$' + '.' + 'canPrint', CAST(@newValue as bit))
                  WHEN @newValueType = 'int'
                  THEN JSON_MODIFY(Data, 'lax' + ' ' + '$' + '.' + 'canPrint', CAST(@newValue as int))
                  WHEN @newValueType = 'decimal' OR @newValueType = 'numeric'
                  THEN JSON_MODIFY(Data, 'lax' + ' ' + '$' + '.' + 'canPrint', CAST(@newValue as decimal))
                  ELSE JSON_MODIFY(Data, 'lax' + ' ' + '$' + '.' + 'canPrint', @newValue)
              END
          ELSE Data
      END,
   TileTypeUid =
      CASE WHEN @fullPropertyPath = '$.TileTypeId'
         THEN @newValue
         ELSE TileTypeUid
      END,
   LastModifiedByUid = NULL,
   LastModifiedDate = GETUTCDATE()
OUTPUT inserted.TileConfigurationUid INTO @UpdatedLTC(Uid)
WHERE TileTypeUid = @currentTileTypeUid
AND (@userChangeable = 0 OR UserDefined = 0)

SELECT 'ListTileConfiguration'
SELECT ltc.*
FROM @UpdatedLTC ltcList
INNER JOIN ListTileConfiguration ltc ON ltcList.Uid = ltc.TileConfigurationUid


-- I think for the usertileconfiguration, it would only overwrite properties that already exist in the JSON,
-- because these are not the full objects, like they are in the Data column of ListTileConfiguration, so it wouldn't make sense that you would be adding to them
-- even if you added a new user changeable property to the Data structure.
-- I think that I would expect that  the user would have to actually go and manually make that change to overwite the row with some value for that property
DECLARE @UpdatedUTC UIDLIST
UPDATE utc
SET
   Data =
      CASE WHEN (ISJSON(utc.Data) > 0) AND EXISTS(SELECT 1 FROM OPENJSON(utc.Data, '$') WHERE [key] = @propertyName)
         THEN CASE WHEN @newValueType = 'bit'
                  -- have to do a CAST here to not have '' around the true or false
                  -- we may have to add other special cases here as well
                  THEN JSON_MODIFY(utc.Data, 'lax' + ' ' + '$' + '.' + 'canPrint', CAST(@newValue as bit))
                  WHEN @newValueType = 'int'
                  THEN JSON_MODIFY(utc.Data, 'lax' + ' ' + '$' + '.' + 'canPrint', CAST(@newValue as int))
                  WHEN @newValueType = 'decimal' OR @newValueType = 'numeric'
                  THEN JSON_MODIFY(utc.Data, 'lax' + ' ' + '$' + '.' + 'canPrint', CAST(@newValue as decimal))
                  ELSE JSON_MODIFY(utc.Data, 'lax' + ' ' + '$' + '.' + 'canPrint', @newValue)
              END
         ELSE utc.Data
      END,
   LastModifiedByUid = NULL,
   LastModifiedDate = GETUTCDATE()
OUTPUT inserted.UserTileConfigurationUid INTO @UpdatedUTC(Uid)
FROM UserTileConfiguration utc
INNER JOIN @UpdatedLTC ltcList ON ltcList.Uid = utc.TileConfigurationUid
AND (@userChangeable = 0 OR utc.UserDefined = 0)

SELECT 'UserTileConfiguration'
SELECT utc.*
FROM @UpdatedUTC utcList
INNER JOIN UserTileConfiguration utc ON utcList.Uid = utc.UserTileConfigurationUid

IF(@trialRun = 1)
   ROLLBACK TRANSACTION
ELSE
   COMMIT TRANSACTION

GO
-- #130822 end

-- #130822 _homepage-tile-config-migration_Replication-Monitor_canPrint.sql
-- Main logic:
-- Updates ListTileConfiguration and UserTileConfiguration based on changes to
-- default values of properties, or new properties, or deleted properties in TileConfigurationDto
-- The user-changeable properties need to only be migrated for systemdefined rows
-- and the non-userchangeable stuff needs to be migrated for all rows

-- Try to run this first as a trial run to make sure it accomplishes the changes you expect

SET XACT_ABORT ON;
GO

BEGIN TRANSACTION


-- set to 1 to see what the result will be without actually applying it to the database,
-- set to 0 to commit the transaction
DECLARE @trialRun bit = 0

-- Inputs:
DECLARE @pathToObjectContainingProperty NVARCHAR(MAX) = '$'
DECLARE @propertyName NVARCHAR(MAX) = 'canPrint'
-- set to string with the value or null
DECLARE @newValue NVARCHAR(MAX) = 'false'
-- This is the sql data type for @newValue; leave it blank to just handle like a string
-- the cases where this matters are below in the code
-- other options are bit, int, numeric, decimal
DECLARE @newValueType NVARCHAR(MAX) = 'bit'
-- JSON_MODIFY prefix
-- https://learn.microsoft.com/en-us/sql/t-sql/functions/json-modify-transact-sql?view=sql-server-ver16#arguments
-- format: [append] [ lax | strict ]
DECLARE @modifyPrefix NVARCHAR(MAX) = 'lax'
DECLARE @currentTileTypeUid uniqueidentifier = 'DFEE9D62-92D6-4068-845F-CB11C528D95D'

-- this is an example object that only contains properties
-- that the user can't change
-- it should basically match the Non-changeable properties in TS for TileConfigurationDto
DECLARE @exampleNonUserChangeableObject NVARCHAR(max) = '
{
  "TileTypeId": "DFEE9D62-92D6-4068-845F-CB11C528D95D",
  "TileTypeName": "Replication Monitor",
  "TileType": 0,
  "Description": "",
  "ShortName": "",
  "TileInstanceId": "0561d8a0-c454-409a-97c5-4df8e62be8f6",
  "isRequired": false,
  "isUnique": false,
  "isCollapsible": true,
  "isConfigurable": false,
  "canLoad": false,
  "isLoaded": false,
  "canMoreVert": false,
  "canRefresh": true,
  "canSort": false,
  "canMaximize": true,
  "displayHeader": true,
  "displayFooter": true,
  "canPrint": false
}
'

-- Calculated variables:
DECLARE @fullPropertyPath NVARCHAR(MAX) = @pathToObjectContainingProperty + '.' + @propertyName
DECLARE @JSON_MODIFY_Path NVARCHAR(MAX) = @modifyPrefix + ' ' + @fullPropertyPath
DECLARE @userChangeable bit =
   CASE WHEN EXISTS(SELECT 1 FROM OPENJSON(@exampleNonUserChangeableObject, '$') WHERE [key] = @propertyName)
      THEN 0
      ELSE 1
   END

SELECT
   @fullPropertyPath as '@fullPropertyPath',
   @newValue as '@newValue',
   @currentTileTypeUid as '@currentTileTypeUid',
   @userChangeable as '@userChangeable'


DECLARE @UpdatedLTC UIDLIST
UPDATE ListTileConfiguration
SET
   Data =
      CASE WHEN (ISJSON(Data) > 0)
          THEN CASE WHEN @newValueType = 'bit'
                  -- have to do a CAST here to not have '' around the true or false
                  -- we may have to add other special cases here as well
                  THEN JSON_MODIFY(Data, 'lax' + ' ' + '$' + '.' + 'canPrint', CAST(@newValue as bit))
                  WHEN @newValueType = 'int'
                  THEN JSON_MODIFY(Data, 'lax' + ' ' + '$' + '.' + 'canPrint', CAST(@newValue as int))
                  WHEN @newValueType = 'decimal' OR @newValueType = 'numeric'
                  THEN JSON_MODIFY(Data, 'lax' + ' ' + '$' + '.' + 'canPrint', CAST(@newValue as decimal))
                  ELSE JSON_MODIFY(Data, 'lax' + ' ' + '$' + '.' + 'canPrint', @newValue)
              END
          ELSE Data
      END,
   TileTypeUid =
      CASE WHEN @fullPropertyPath = '$.TileTypeId'
         THEN @newValue
         ELSE TileTypeUid
      END,
   LastModifiedByUid = NULL,
   LastModifiedDate = GETUTCDATE()
OUTPUT inserted.TileConfigurationUid INTO @UpdatedLTC(Uid)
WHERE TileTypeUid = @currentTileTypeUid
AND (@userChangeable = 0 OR UserDefined = 0)


SELECT 'ListTileConfiguration'
SELECT ltc.*
FROM @UpdatedLTC ltcList
INNER JOIN ListTileConfiguration ltc ON ltcList.Uid = ltc.TileConfigurationUid


-- I think for the usertileconfiguration, it would only overwrite properties that already exist in the JSON,
-- because these are not the full objects, like they are in the Data column of ListTileConfiguration, so it wouldn't make sense that you would be adding to them
-- even if you added a new user changeable property to the Data structure.
-- I think that I would expect that  the user would have to actually go and manually make that change to overwite the row with some value for that property
DECLARE @UpdatedUTC UIDLIST
UPDATE utc
SET
   Data =
      CASE WHEN (ISJSON(utc.Data) > 0) AND EXISTS(SELECT 1 FROM OPENJSON(utc.Data, '$') WHERE [key] = @propertyName)
         THEN CASE WHEN @newValueType = 'bit'
                  -- have to do a CAST here to not have '' around the true or false
                  -- we may have to add other special cases here as well
                  THEN JSON_MODIFY(utc.Data, 'lax' + ' ' + '$' + '.' + 'canPrint', CAST(@newValue as bit))
                  WHEN @newValueType = 'int'
                  THEN JSON_MODIFY(utc.Data, 'lax' + ' ' + '$' + '.' + 'canPrint', CAST(@newValue as int))
                  WHEN @newValueType = 'decimal' OR @newValueType = 'numeric'
                  THEN JSON_MODIFY(utc.Data, 'lax' + ' ' + '$' + '.' + 'canPrint', CAST(@newValue as decimal))
                  ELSE JSON_MODIFY(utc.Data, 'lax' + ' ' + '$' + '.' + 'canPrint', @newValue)
              END
         ELSE utc.Data
      END,
   LastModifiedByUid = NULL,
   LastModifiedDate = GETUTCDATE()
OUTPUT inserted.UserTileConfigurationUid INTO @UpdatedUTC(Uid)
FROM UserTileConfiguration utc
INNER JOIN @UpdatedLTC ltcList ON ltcList.Uid = utc.TileConfigurationUid
AND (@userChangeable = 0 OR utc.UserDefined = 0)

SELECT 'UserTileConfiguration'
SELECT utc.*
FROM @UpdatedUTC utcList
INNER JOIN UserTileConfiguration utc ON utcList.Uid = utc.UserTileConfigurationUid


IF(@trialRun = 1)
   ROLLBACK TRANSACTION
ELSE
   COMMIT TRANSACTION

GO
-- #130822 end

-- #131104 .sql
UPDATE ListFindControlBehavior
SET
    SearchColumns = '[ "LastName", "FirstName", "ExternalID", "Birthdate" ]',
    LastModifiedDate = '2023-06-06 16:49:00'
WHERE
    Id = 'ViewFindPatient'
GO

-- #133203 2023PatHistoryLivingArrangements.sql
IF (SELECT LOINCUid FROM ListQuestion WHERE QuestionUid = '00000000-0000-0000-0000-000000000003') IS NULL
   BEGIN
      UPDATE ListQuestion SET LOINCUid = 'A2B1E436-CE96-4ECD-9CE5-D7453F182CCA' 
         WHERE QuestionUid = '00000000-0000-0000-0000-000000000003'
   END
IF NOT EXISTS (SELECT 1 FROM ListAnswer WHERE AnswerUid = '74015EF7-6B0A-4323-B461-81E986158C91')
   BEGIN
      INSERT INTO ListAnswer (AnswerUid, ExternalID, Name, UserDefined, Inactive) 
         VALUES ('74015EF7-6B0A-4323-B461-81E986158C91', 'LNH', 'Lives in a Nursing Home', '0', '0')

      INSERT INTO RelAnswerGroupAnswer (AnswerGroupUid, AnswerUid, UserDefined) 
         VALUES ('00000000-0000-0000-0000-000000000003', '74015EF7-6B0A-4323-B461-81E986158C91', '0')
   END 
IF NOT EXISTS (SELECT 1 FROM RelQuestionAnswerSnomed WHERE RelQuestionAnswerSnomedUid = '59BB1E59-93FE-4922-9841-B9AD7B52C894' AND QuestionUid = '00000000-0000-0000-0000-000000000003' AND AnswerUid = '74015EF7-6B0A-4323-B461-81E986158C91')
   BEGIN
      INSERT INTO RelQuestionAnswerSnomed (RelQuestionAnswerSnomedUid, QuestionUid, AnswerUid, AnswerSnomedDescriptionUid, AnswerSnomedConceptID, UserDefined) 
         VALUES ('59BB1E59-93FE-4922-9841-B9AD7B52C894', '00000000-0000-0000-0000-000000000003', '74015EF7-6B0A-4323-B461-81E986158C91', '00000000-0000-0000-0000-000541682013', '160734000', '0')
   END 
GO

-- #133736 _DisableMithochonIntegrationPartner.sql
Update ListIntegrationPartner  Set Inactive = 1
where Name = 'Mitochon'  and inactive = 0
GO

-- #134596 _UpdateIntegrationPartner_SurescriptsRLELoginHash.sql
--Add LoginHash to Surescripts RLE IntegrationPartner
IF EXISTS 
   (
      Select Integrationpartneruid
      FROM ListIntegrationPartner 
      WHERE IntegrationPartnerUid = '0609C279-D522-4596-AEB8-51EDA485AD49'
         AND AdditionalOutboundXML LIKE '<SureScriptsPartnerConfiguration>%'
   )
BEGIN

   UPDATE ListIntegrationPartner
      Set AdditionalOutboundXML = replace(AdditionalOutboundXML,'<SureScriptsPartnerConfiguration>','<SureScriptsPartnerConfiguration loginHash="222c883132c028fb69590c5aab01a245cd86aa5837541c1c0a9ea1a9de1a3b3c">')
      WHERE IntegrationPartnerUid = '0609C279-D522-4596-AEB8-51EDA485AD49'

END
GO    

-- #137758 CDC Vaccine Updates July 27 2023 Migration
--*************************************************
--VaccineUnitUse
--Retired entries
Update VaccineUnitUse Set UseUnitEndDate = '20230701', Inactive='1' WHERE NDC11 = '70461-0122-04'
Update VaccineUnitUse Set UseUnitEndDate = '20230630', Inactive='1' WHERE NDC11 IN 
('70461-0322-04','70461-0422-11','33332-0422-11', '33332-0322-04', '58160-0890-41',
'19515-0808-41', '49281-0722-88', '59676-0580-05', '00006-4826-01')
GO

-- #140101 _UpdateTransmissionConfiguration_StagingEndpoints_CPDEV02.sql
UPDATE TransmissionConfiguration
SET
TestAprimaVaultURL = replace(testaprimavaulturl,'cpdev02.aprima.corp','cpdev02.pop.e-mds.com') ,
TestAprimaVaultSubmissionURL = replace(TestAprimaVaultSubmissionURL,'cpdev02.aprima.corp','cpdev02.pop.e-mds.com'),
TestOverrideAprimaVaultURL = replace(TestOverrideAprimaVaultURL,'cpdev02.aprima.corp','cpdev02.pop.e-mds.com'),
TestAprimaVaultSyncURL =replace(TestAprimaVaultSyncURL,'cpdev02.aprima.corp','cpdev02.pop.e-mds.com'),
TestRegistrationURL = replace(TestRegistrationURL,'cpdev02.aprima.corp','cpdev02.pop.e-mds.com')
WHERE 
TestAprimaVaultURL like '%cpdev02%'
or TestAprimaVaultSubmissionURL like '%cpdev02%'
or TestOverrideAprimaVaultURL like '%cpdev02%'
or TestAprimaVaultSyncURL like '%cpdev02%'
or TestRegistrationURL like '%cpdev02%'
GO

-- #140370_CDC_Vaccine_Code_Set_Aug_24_2023 Migration Script
--Update GTINs
Update VaccineUnitUse Set GTIN = '00333332323043' WHERE NDC11 = '33332-0323-04'
Update VaccineUnitUse Set GTIN = '00333332423118' WHERE NDC11 = '33332-0423-11'
Update VaccineUnitUse Set GTIN = '00370461123045' WHERE NDC11 = '70461-0123-04'
Update VaccineUnitUse Set GTIN = '00370461323049' WHERE NDC11 = '70461-0323-04'
Update VaccineUnitUse Set GTIN = '00370461423114' WHERE NDC11 = '70461-0423-11'
GO

-- #141349_DrFirst_TurnOn.sql
IF (dbo.Replication_IsReplicatedDB() = 0 AND NOT EXISTS(SELECT * FROM ListProductParameter WHERE ParameterName = 'eRx.MigratedToDrFirst2'))
BEGIN
   INSERT INTO ListProductParameter(ProductParameterUid, ParameterName, BoolValue) VALUES('CD726290-C75A-4D5D-8429-FB0E70096882', 'eRx.MigratedToDrFirst2', 1)

   UPDATE ip
   SET 
      Inactive          = 0,
      UserDefined       = 2,
      TestMode          = ss.TestMode,
      LastModifiedByUid = null,
      LastModifiedDate  = GETUTCDATE()
   FROM ListIntegrationPartner ip
   INNER JOIN ListIntegrationPartner ss ON ss.IntegrationPartnerUid = '118422AA-C165-4A2E-8389-E5B7E89636EA'
   WHERE ip.IntegrationPartnerUid = '86C4513F-EA5A-4A7D-9C38-68D81A24B6C3'
     AND ip.Name = 'Patient Rx Notifications - DrFirst'
     AND ip.Inactive = 1
     AND ip.UserDefined = 0
     AND ss.Inactive = 0

   UPDATE ip
   SET UserDefined       = 2
   FROM ListIntegrationPartner ip
   WHERE ip.IntegrationPartnerUid = '86C4513F-EA5A-4A7D-9C38-68D81A24B6C3'
     AND ip.Name = 'Patient Rx Notifications - DrFirst'
     AND ip.Inactive = 0
     AND ip.UserDefined = 0

   UPDATE tc
   SET 
      TestMode       = ip.TestMode,
      UserDefined    = 2
   FROM TransmissionConfiguration tc
   INNER JOIN ListIntegrationPartner ip ON ip.IntegrationPartnerUid = tc.IntegrationPartnerUid
   WHERE tc.TransmissionConfigurationUid = '86C4513F-EA5A-4A7D-9C38-68D81A24B6C3'
     AND tc.TransmissionType = 'PatientRxNotification'
     AND ip.IntegrationPartnerUid = '86C4513F-EA5A-4A7D-9C38-68D81A24B6C3'
     AND ip.Name = 'Patient Rx Notifications - DrFirst'
     AND ip.Inactive = 0
     AND tc.TestMode != ip.TestMode
END
GO
-- #141349 end

-- #141457_ActivateMetricsExportJob.sql
IF EXISTS(SELECT * FROM JobSchedule WHERE Inactive = 1 AND JobScheduleUid = 'F4BCAD57-A310-4DE7-A500-0BC88CF60FE4')
BEGIN
   update jobschedule set Inactive = 0 where JobScheduleUid in ('F4BCAD57-A310-4DE7-A500-0BC88CF60FE4')
END
GO

-- #136833 _PlatformRxDownload.sql
UPDATE ListJob 
SET
   AssemblyQualifiedName   = 'iMedica.Framework.Utility.PlatformRxDownloadPrescriberDirectoryJob, JobTask',
   UIAssemblyQualifiedName = NULL
WHERE JobUid = '4BDA1F87-B348-4404-BFBE-5560BEE4235D'
  AND AssemblyQualifiedName <> 'iMedica.Framework.Utility.PlatformRxDownloadPrescriberDirectoryJob, JobTask'

UPDATE ListJob 
SET
   AssemblyQualifiedName   = 'iMedica.Framework.Utility.PlatformRxDownloadPharmacyDirectoryJob, JobTask',
   UIAssemblyQualifiedName = NULL
WHERE JobUid = 'EAFF3043-E1AE-437A-833E-B24295B12B69'
   AND AssemblyQualifiedName <> 'iMedica.Framework.Utility.PlatformRxDownloadPharmacyDirectoryJob, JobTask'

UPDATE ListPharmacyClearinghouse
SET InterfaceDetails.modify('insert <URL type="PlatformRx">http://prescribe.ect.pop.e-mds.com/api/</URL> as first into (root/QA)[1]')
WHERE PharmacyClearinghouseUid = '118422AA-C165-4A2E-8389-E5B7E89636EA'
    AND InterfaceDetails.exist('root/QA/URL[@type="PlatformRx"]') = 0

UPDATE ListPharmacyClearinghouse
SET InterfaceDetails.modify('insert <URL type="PlatformRx">https://erx.emdscloud.com/api/</URL> as first into (root/Prod)[1]')
WHERE PharmacyClearinghouseUid = '118422AA-C165-4A2E-8389-E5B7E89636EA'
    AND InterfaceDetails.exist('root/Prod/URL[@type="PlatformRx"]') = 0
GO

-- #141053_UpdateStagingEndpoints_CPDEV01.sql
UPDATE TransmissionConfiguration
SET
TestAprimaVaultURL = replace(testaprimavaulturl,'cpdev01.aprima.corp','cpdev01.pop.e-mds.com') ,
TestAprimaVaultSubmissionURL = replace(TestAprimaVaultSubmissionURL,'cpdev01.aprima.corp','cpdev01.pop.e-mds.com'),
TestOverrideAprimaVaultURL = replace(TestOverrideAprimaVaultURL,'cpdev01.aprima.corp','cpdev01.pop.e-mds.com'),
TestAprimaVaultSyncURL =replace(TestAprimaVaultSyncURL,'cpdev01.aprima.corp','cpdev01.pop.e-mds.com'),
TestRegistrationURL = replace(TestRegistrationURL,'cpdev01.aprima.corp','cpdev01.pop.e-mds.com')
WHERE testaprimavaulturl like '%cpdev01.aprima.corp%'
or TestAprimaVaultSubmissionURL like '%cpdev01.aprima.corp%'
or TestOverrideAprimaVaultURL like '%cpdev01.aprima.corp%'
or TestAprimaVaultSyncURL like '%cpdev01.aprima.corp%'
or testregistrationurl like '%cpdev01.aprima.corp%'
GO

update listintegrationpartner
set AdditionalOutboundXML = replace(AdditionalOutboundXML,'cpdev01.aprima.corp','cpdev01.pop.e-mds.com')
where AdditionalOutboundXML like '%cpdev01.aprima.corp%'
GO

-- #143160_Update_TypeofVaccine_Antigen_Name.sql
--ListTypeofVaccine
Update ListTypeofVaccine Set Name = 'Covid-19 (Pfizer BioNTech 6 mos - 4 yrs vial multi-dose 3 doses 3mcg/.3mL after dilution)'
WHERE TypeofVaccineUid = '367269F3-09A5-45DA-8F58-BAA026E41288'
--ListTypeofVaccineElement
Update ListTypeofVaccineElement Set Name = 'Covid-19 (Pfizer BioNTech 6 mos - 4 yrs vial multi-dose 3 doses 3mcg/.3mL after dilution)'
WHERE TypeofVaccineElementUid = '7CA5ABF1-B411-412B-8150-813E2E5D6060'
GO

-- #142232 _homepage-tile-config-migration_Appt-Queue_displayPhoneNumber.sql
-- Main logic:
-- Updates ListTileConfiguration and UserTileConfiguration based on changes to
-- default values of properties, or new properties, or deleted properties in TileConfigurationDto
-- The user-changeable properties need to only be migrated for systemdefined rows
-- and the non-userchangeable stuff needs to be migrated for all rows
-- Try to run this first as a trial run to make sure it accomplishes the changes you expect

SET XACT_ABORT ON;
GO

BEGIN TRANSACTION

-- set to 1 to see what the result will be without actually applying it to the database,
-- set to 0 to commit the transaction
DECLARE @trialRun bit = 0

-- Inputs:
DECLARE @pathToObjectContainingProperty NVARCHAR(MAX) = '$'
DECLARE @propertyName NVARCHAR(MAX) = 'displayPhoneNumber'
-- set to string with the value or null
DECLARE @newValue NVARCHAR(MAX) = 'true'
-- This is the sql data type for @newValue; leave it blank to just handle like a string
-- the cases where this matters are below in the code
-- other options are bit, int, numeric, decimal
DECLARE @newValueType NVARCHAR(MAX) = 'bit'
-- JSON_MODIFY prefix
-- https://learn.microsoft.com/en-us/sql/t-sql/functions/json-modify-transact-sql?view=sql-server-ver16#arguments
-- format: [append] [ lax | strict ]
DECLARE @modifyPrefix NVARCHAR(MAX) = 'lax'
DECLARE @currentTileTypeUid uniqueidentifier = '72214A6B-49C5-4D11-8303-D08B23FF58F5'

-- this is an example object that only contains properties
-- that the user can't change
-- it should basically match the Non-changeable properties in TS for TileConfigurationDto
DECLARE @exampleNonUserChangeableObject NVARCHAR(max) = '
{
  "TileTypeId": "DFEE9D62-92D6-4068-845F-CB11C528D95D",
  "TileTypeName": "Replication Monitor",
  "TileType": 0,
  "Description": "",
  "ShortName": "",
  "TileInstanceId": "0561d8a0-c454-409a-97c5-4df8e62be8f6",
  "isRequired": false,
  "isUnique": false,
  "isCollapsible": true,
  "isConfigurable": false,
  "canLoad": false,
  "isLoaded": false,
  "canMoreVert": false,
  "canRefresh": true,
  "canSort": false,
  "canMaximize": true,
  "displayHeader": true,
  "displayFooter": true,
  "canPrint": false
}
'

-- Calculated variables:
DECLARE @fullPropertyPath NVARCHAR(MAX) = @pathToObjectContainingProperty + '.' + @propertyName
DECLARE @JSON_MODIFY_Path NVARCHAR(MAX) = @modifyPrefix + ' ' + @fullPropertyPath
DECLARE @userChangeable bit =
   CASE WHEN EXISTS(SELECT 1 FROM OPENJSON(@exampleNonUserChangeableObject, '$') WHERE [key] = @propertyName)
      THEN 0
      ELSE 1
   END

SELECT
   @fullPropertyPath as '@fullPropertyPath',
   @newValue as '@newValue',
   @currentTileTypeUid as '@currentTileTypeUid',
   @userChangeable as '@userChangeable'


DECLARE @UpdatedLTC UIDLIST
UPDATE ListTileConfiguration
SET
   Data =
      CASE WHEN (ISJSON(Data) > 0)
          THEN CASE WHEN @newValueType = 'bit'
                  -- have to do a CAST here to not have '' around the true or false
                  -- we may have to add other special cases here as well
                  THEN JSON_MODIFY(Data, 'lax' + ' ' + '$' + '.' + 'displayPhoneNumber', CAST(@newValue as bit))
                  WHEN @newValueType = 'int'
                  THEN JSON_MODIFY(Data, 'lax' + ' ' + '$' + '.' + 'displayPhoneNumber', CAST(@newValue as int))
                  WHEN @newValueType = 'decimal' OR @newValueType = 'numeric'
                  THEN JSON_MODIFY(Data, 'lax' + ' ' + '$' + '.' + 'displayPhoneNumber', CAST(@newValue as decimal))
                  ELSE JSON_MODIFY(Data, 'lax' + ' ' + '$' + '.' + 'displayPhoneNumber', @newValue)
              END
          ELSE Data
      END,
   TileTypeUid =
      CASE WHEN @fullPropertyPath = '$.TileTypeId'
         THEN @newValue
         ELSE TileTypeUid
      END,
   LastModifiedByUid = NULL,
   LastModifiedDate = GETUTCDATE()
OUTPUT inserted.TileConfigurationUid INTO @UpdatedLTC(Uid)
WHERE TileTypeUid = @currentTileTypeUid
AND (@userChangeable = 0 OR UserDefined = 0)


SELECT 'ListTileConfiguration'
SELECT ltc.*
FROM @UpdatedLTC ltcList
INNER JOIN ListTileConfiguration ltc ON ltcList.Uid = ltc.TileConfigurationUid


-- I think for the usertileconfiguration, it would only overwrite properties that already exist in the JSON,
-- because these are not the full objects, like they are in the Data column of ListTileConfiguration, so it wouldn't make sense that you would be adding to them
-- even if you added a new user changeable property to the Data structure.
-- I think that I would expect that  the user would have to actually go and manually make that change to overwite the row with some value for that property
DECLARE @UpdatedUTC UIDLIST
UPDATE utc
SET
   Data =
      CASE WHEN (ISJSON(utc.Data) > 0) AND EXISTS(SELECT 1 FROM OPENJSON(utc.Data, '$') WHERE [key] = @propertyName)
         THEN CASE WHEN @newValueType = 'bit'
                  -- have to do a CAST here to not have '' around the true or false
                  -- we may have to add other special cases here as well
                  THEN JSON_MODIFY(utc.Data, 'lax' + ' ' + '$' + '.' + 'displayPhoneNumber', CAST(@newValue as bit))
                  WHEN @newValueType = 'int'
                  THEN JSON_MODIFY(utc.Data, 'lax' + ' ' + '$' + '.' + 'displayPhoneNumber', CAST(@newValue as int))
                  WHEN @newValueType = 'decimal' OR @newValueType = 'numeric'
                  THEN JSON_MODIFY(utc.Data, 'lax' + ' ' + '$' + '.' + 'displayPhoneNumber', CAST(@newValue as decimal))
                  ELSE JSON_MODIFY(utc.Data, 'lax' + ' ' + '$' + '.' + 'displayPhoneNumber', @newValue)
              END
         ELSE utc.Data
      END,
   LastModifiedByUid = NULL,
   LastModifiedDate = GETUTCDATE()
OUTPUT inserted.UserTileConfigurationUid INTO @UpdatedUTC(Uid)
FROM UserTileConfiguration utc
INNER JOIN @UpdatedLTC ltcList ON ltcList.Uid = utc.TileConfigurationUid
AND (@userChangeable = 0 OR utc.UserDefined = 0)

SELECT 'UserTileConfiguration'
SELECT utc.*
FROM @UpdatedUTC utcList
INNER JOIN UserTileConfiguration utc ON utcList.Uid = utc.UserTileConfigurationUid

IF(@trialRun = 1)
   ROLLBACK TRANSACTION
ELSE
   COMMIT TRANSACTION
GO
-- #142232 end

-- #139635 _homepage-tile-config-migration_Appt-Queue_displayApptStatus.sql
-- Main logic:
-- Updates ListTileConfiguration and UserTileConfiguration based on changes to
-- default values of properties, or new properties, or deleted properties in TileConfigurationDto
-- The user-changeable properties need to only be migrated for systemdefined rows
-- and the non-userchangeable stuff needs to be migrated for all rows

-- Try to run this first as a trial run to make sure it accomplishes the changes you expect

SET XACT_ABORT ON;
GO

BEGIN TRANSACTION


-- set to 1 to see what the result will be without actually applying it to the database,
-- set to 0 to commit the transaction
DECLARE @trialRun bit = 0

-- Inputs:
DECLARE @pathToObjectContainingProperty NVARCHAR(MAX) = '$'
DECLARE @propertyName NVARCHAR(MAX) = 'displayApptStatus'
-- set to string with the value or null
DECLARE @newValue NVARCHAR(MAX) = 'true'
-- This is the sql data type for @newValue; leave it blank to just handle like a string
-- the cases where this matters are below in the code
-- other options are bit, int, numeric, decimal
DECLARE @newValueType NVARCHAR(MAX) = 'bit'
-- JSON_MODIFY prefix
-- https://learn.microsoft.com/en-us/sql/t-sql/functions/json-modify-transact-sql?view=sql-server-ver16#arguments
-- format: [append] [ lax | strict ]
DECLARE @modifyPrefix NVARCHAR(MAX) = 'lax'
DECLARE @currentTileTypeUid uniqueidentifier = '72214A6B-49C5-4D11-8303-D08B23FF58F5'

-- this is an example object that only contains properties
-- that the user can't change
-- it should basically match the Non-changeable properties in TS for TileConfigurationDto
DECLARE @exampleNonUserChangeableObject NVARCHAR(max) = '
{
  "TileTypeId": "DFEE9D62-92D6-4068-845F-CB11C528D95D",
  "TileTypeName": "Replication Monitor",
  "TileType": 0,
  "Description": "",
  "ShortName": "",
  "TileInstanceId": "0561d8a0-c454-409a-97c5-4df8e62be8f6",
  "isRequired": false,
  "isUnique": false,
  "isCollapsible": true,
  "isConfigurable": false,
  "canLoad": false,
  "isLoaded": false,
  "canMoreVert": false,
  "canRefresh": true,
  "canSort": false,
  "canMaximize": true,
  "displayHeader": true,
  "displayFooter": true,
  "canPrint": false
}
'

-- Calculated variables:
DECLARE @fullPropertyPath NVARCHAR(MAX) = @pathToObjectContainingProperty + '.' + @propertyName
DECLARE @JSON_MODIFY_Path NVARCHAR(MAX) = @modifyPrefix + ' ' + @fullPropertyPath
DECLARE @userChangeable bit =
   CASE WHEN EXISTS(SELECT 1 FROM OPENJSON(@exampleNonUserChangeableObject, '$') WHERE [key] = @propertyName)
      THEN 0
      ELSE 1
   END

SELECT
   @fullPropertyPath as '@fullPropertyPath',
   @newValue as '@newValue',
   @currentTileTypeUid as '@currentTileTypeUid',
   @userChangeable as '@userChangeable'


DECLARE @UpdatedLTC UIDLIST
UPDATE ListTileConfiguration
SET
   Data =
      CASE WHEN (ISJSON(Data) > 0)
          THEN CASE WHEN @newValueType = 'bit'
                  -- have to do a CAST here to not have '' around the true or false
                  -- we may have to add other special cases here as well
                  THEN JSON_MODIFY(Data, 'lax' + ' ' + '$' + '.' + 'displayApptStatus', CAST(@newValue as bit))
                  WHEN @newValueType = 'int'
                  THEN JSON_MODIFY(Data, 'lax' + ' ' + '$' + '.' + 'displayApptStatus', CAST(@newValue as int))
                  WHEN @newValueType = 'decimal' OR @newValueType = 'numeric'
                  THEN JSON_MODIFY(Data, 'lax' + ' ' + '$' + '.' + 'displayApptStatus', CAST(@newValue as decimal))
                  ELSE JSON_MODIFY(Data, 'lax' + ' ' + '$' + '.' + 'displayApptStatus', @newValue)
              END
          ELSE Data
      END,
   TileTypeUid =
      CASE WHEN @fullPropertyPath = '$.TileTypeId'
         THEN @newValue
         ELSE TileTypeUid
      END,
   LastModifiedByUid = NULL,
   LastModifiedDate = GETUTCDATE()
OUTPUT inserted.TileConfigurationUid INTO @UpdatedLTC(Uid)
WHERE TileTypeUid = @currentTileTypeUid
AND (@userChangeable = 0 OR UserDefined = 0)


SELECT 'ListTileConfiguration'
SELECT ltc.*
FROM @UpdatedLTC ltcList
INNER JOIN ListTileConfiguration ltc ON ltcList.Uid = ltc.TileConfigurationUid


-- I think for the usertileconfiguration, it would only overwrite properties that already exist in the JSON,
-- because these are not the full objects, like they are in the Data column of ListTileConfiguration, so it wouldn't make sense that you would be adding to them
-- even if you added a new user changeable property to the Data structure.
-- I think that I would expect that  the user would have to actually go and manually make that change to overwite the row with some value for that property
DECLARE @UpdatedUTC UIDLIST
UPDATE utc
SET
   Data =
      CASE WHEN (ISJSON(utc.Data) > 0) AND EXISTS(SELECT 1 FROM OPENJSON(utc.Data, '$') WHERE [key] = @propertyName)
         THEN CASE WHEN @newValueType = 'bit'
                  -- have to do a CAST here to not have '' around the true or false
                  -- we may have to add other special cases here as well
                  THEN JSON_MODIFY(utc.Data, 'lax' + ' ' + '$' + '.' + 'displayApptStatus', CAST(@newValue as bit))
                  WHEN @newValueType = 'int'
                  THEN JSON_MODIFY(utc.Data, 'lax' + ' ' + '$' + '.' + 'displayApptStatus', CAST(@newValue as int))
                  WHEN @newValueType = 'decimal' OR @newValueType = 'numeric'
                  THEN JSON_MODIFY(utc.Data, 'lax' + ' ' + '$' + '.' + 'displayApptStatus', CAST(@newValue as decimal))
                  ELSE JSON_MODIFY(utc.Data, 'lax' + ' ' + '$' + '.' + 'displayApptStatus', @newValue)
              END
         ELSE utc.Data
      END,
   LastModifiedByUid = NULL,
   LastModifiedDate = GETUTCDATE()
OUTPUT inserted.UserTileConfigurationUid INTO @UpdatedUTC(Uid)
FROM UserTileConfiguration utc
INNER JOIN @UpdatedLTC ltcList ON ltcList.Uid = utc.TileConfigurationUid
AND (@userChangeable = 0 OR utc.UserDefined = 0)

SELECT 'UserTileConfiguration'
SELECT utc.*
FROM @UpdatedUTC utcList
INNER JOIN UserTileConfiguration utc ON utcList.Uid = utc.UserTileConfigurationUid

IF(@trialRun = 1)
   ROLLBACK TRANSACTION
ELSE
   COMMIT TRANSACTION
GO
-- #139635 end

-- #139635 _homepage-tile-config-migration_Appt-Queue_displayRoom.sql
-- Main logic:
-- Updates ListTileConfiguration and UserTileConfiguration based on changes to
-- default values of properties, or new properties, or deleted properties in TileConfigurationDto
-- The user-changeable properties need to only be migrated for systemdefined rows
-- and the non-userchangeable stuff needs to be migrated for all rows

-- Try to run this first as a trial run to make sure it accomplishes the changes you expect

SET XACT_ABORT ON;
GO

BEGIN TRANSACTION


-- set to 1 to see what the result will be without actually applying it to the database,
-- set to 0 to commit the transaction
DECLARE @trialRun bit = 0

-- Inputs:
DECLARE @pathToObjectContainingProperty NVARCHAR(MAX) = '$'
DECLARE @propertyName NVARCHAR(MAX) = 'displayRoom'
-- set to string with the value or null
DECLARE @newValue NVARCHAR(MAX) = 'true'
-- This is the sql data type for @newValue; leave it blank to just handle like a string
-- the cases where this matters are below in the code
-- other options are bit, int, numeric, decimal
DECLARE @newValueType NVARCHAR(MAX) = 'bit'
-- JSON_MODIFY prefix
-- https://learn.microsoft.com/en-us/sql/t-sql/functions/json-modify-transact-sql?view=sql-server-ver16#arguments
-- format: [append] [ lax | strict ]
DECLARE @modifyPrefix NVARCHAR(MAX) = 'lax'
DECLARE @currentTileTypeUid uniqueidentifier = '72214A6B-49C5-4D11-8303-D08B23FF58F5'

-- this is an example object that only contains properties
-- that the user can't change
-- it should basically match the Non-changeable properties in TS for TileConfigurationDto
DECLARE @exampleNonUserChangeableObject NVARCHAR(max) = '
{
  "TileTypeId": "DFEE9D62-92D6-4068-845F-CB11C528D95D",
  "TileTypeName": "Replication Monitor",
  "TileType": 0,
  "Description": "",
  "ShortName": "",
  "TileInstanceId": "0561d8a0-c454-409a-97c5-4df8e62be8f6",
  "isRequired": false,
  "isUnique": false,
  "isCollapsible": true,
  "isConfigurable": false,
  "canLoad": false,
  "isLoaded": false,
  "canMoreVert": false,
  "canRefresh": true,
  "canSort": false,
  "canMaximize": true,
  "displayHeader": true,
  "displayFooter": true,
  "canPrint": false
}
'

-- Calculated variables:
DECLARE @fullPropertyPath NVARCHAR(MAX) = @pathToObjectContainingProperty + '.' + @propertyName
DECLARE @JSON_MODIFY_Path NVARCHAR(MAX) = @modifyPrefix + ' ' + @fullPropertyPath
DECLARE @userChangeable bit =
   CASE WHEN EXISTS(SELECT 1 FROM OPENJSON(@exampleNonUserChangeableObject, '$') WHERE [key] = @propertyName)
      THEN 0
      ELSE 1
   END

SELECT
   @fullPropertyPath as '@fullPropertyPath',
   @newValue as '@newValue',
   @currentTileTypeUid as '@currentTileTypeUid',
   @userChangeable as '@userChangeable'


DECLARE @UpdatedLTC UIDLIST
UPDATE ListTileConfiguration
SET
   Data =
      CASE WHEN (ISJSON(Data) > 0)
          THEN CASE WHEN @newValueType = 'bit'
                  -- have to do a CAST here to not have '' around the true or false
                  -- we may have to add other special cases here as well
                  THEN JSON_MODIFY(Data, 'lax' + ' ' + '$' + '.' + 'displayRoom', CAST(@newValue as bit))
                  WHEN @newValueType = 'int'
                  THEN JSON_MODIFY(Data, 'lax' + ' ' + '$' + '.' + 'displayRoom', CAST(@newValue as int))
                  WHEN @newValueType = 'decimal' OR @newValueType = 'numeric'
                  THEN JSON_MODIFY(Data, 'lax' + ' ' + '$' + '.' + 'displayRoom', CAST(@newValue as decimal))
                  ELSE JSON_MODIFY(Data, 'lax' + ' ' + '$' + '.' + 'displayRoom', @newValue)
              END
          ELSE Data
      END,
   TileTypeUid =
      CASE WHEN @fullPropertyPath = '$.TileTypeId'
         THEN @newValue
         ELSE TileTypeUid
      END,
   LastModifiedByUid = NULL,
   LastModifiedDate = GETUTCDATE()
OUTPUT inserted.TileConfigurationUid INTO @UpdatedLTC(Uid)
WHERE TileTypeUid = @currentTileTypeUid
AND (@userChangeable = 0 OR UserDefined = 0)


SELECT 'ListTileConfiguration'
SELECT ltc.*
FROM @UpdatedLTC ltcList
INNER JOIN ListTileConfiguration ltc ON ltcList.Uid = ltc.TileConfigurationUid


-- I think for the usertileconfiguration, it would only overwrite properties that already exist in the JSON,
-- because these are not the full objects, like they are in the Data column of ListTileConfiguration, so it wouldn't make sense that you would be adding to them
-- even if you added a new user changeable property to the Data structure.
-- I think that I would expect that  the user would have to actually go and manually make that change to overwite the row with some value for that property
DECLARE @UpdatedUTC UIDLIST
UPDATE utc
SET
   Data =
      CASE WHEN (ISJSON(utc.Data) > 0) AND EXISTS(SELECT 1 FROM OPENJSON(utc.Data, '$') WHERE [key] = @propertyName)
         THEN CASE WHEN @newValueType = 'bit'
                  -- have to do a CAST here to not have '' around the true or false
                  -- we may have to add other special cases here as well
                  THEN JSON_MODIFY(utc.Data, 'lax' + ' ' + '$' + '.' + 'displayRoom', CAST(@newValue as bit))
                  WHEN @newValueType = 'int'
                  THEN JSON_MODIFY(utc.Data, 'lax' + ' ' + '$' + '.' + 'displayRoom', CAST(@newValue as int))
                  WHEN @newValueType = 'decimal' OR @newValueType = 'numeric'
                  THEN JSON_MODIFY(utc.Data, 'lax' + ' ' + '$' + '.' + 'displayRoom', CAST(@newValue as decimal))
                  ELSE JSON_MODIFY(utc.Data, 'lax' + ' ' + '$' + '.' + 'displayRoom', @newValue)
              END
         ELSE utc.Data
      END,
   LastModifiedByUid = NULL,
   LastModifiedDate = GETUTCDATE()
OUTPUT inserted.UserTileConfigurationUid INTO @UpdatedUTC(Uid)
FROM UserTileConfiguration utc
INNER JOIN @UpdatedLTC ltcList ON ltcList.Uid = utc.TileConfigurationUid
AND (@userChangeable = 0 OR utc.UserDefined = 0)

SELECT 'UserTileConfiguration'
SELECT utc.*
FROM @UpdatedUTC utcList
INNER JOIN UserTileConfiguration utc ON utcList.Uid = utc.UserTileConfigurationUid


IF(@trialRun = 1)
   ROLLBACK TRANSACTION
ELSE
   COMMIT TRANSACTION

GO
-- #139635 end

-- #142034 _homepage-tile-config-migration_Appt-Queue_patientIdType.sql
-- Main logic:
-- Updates ListTileConfiguration and UserTileConfiguration based on changes to
-- default values of properties, or new properties, or deleted properties in TileConfigurationDto
-- The user-changeable properties need to only be migrated for systemdefined rows
-- and the non-userchangeable stuff needs to be migrated for all rows

-- Try to run this first as a trial run to make sure it accomplishes the changes you expect

SET XACT_ABORT ON;
GO

BEGIN TRANSACTION


-- set to 1 to see what the result will be without actually applying it to the database,
-- set to 0 to commit the transaction
DECLARE @trialRun bit = 0

-- Inputs:
DECLARE @pathToObjectContainingProperty NVARCHAR(MAX) = '$'
DECLARE @propertyName NVARCHAR(MAX) = 'patientIdType'
-- set to string with the value or null
DECLARE @newValue NVARCHAR(MAX) = 0
-- This is the sql data type for @newValue; leave it blank to just handle like a string
-- the cases where this matters are below in the code
-- other options are bit, int, numeric, decimal
DECLARE @newValueType NVARCHAR(MAX) = 'int'
-- JSON_MODIFY prefix
-- https://learn.microsoft.com/en-us/sql/t-sql/functions/json-modify-transact-sql?view=sql-server-ver16#arguments
-- format: [append] [ lax | strict ]
DECLARE @modifyPrefix NVARCHAR(MAX) = 'lax'
DECLARE @currentTileTypeUid uniqueidentifier = '72214A6B-49C5-4D11-8303-D08B23FF58F5'

-- this is an example object that only contains properties
-- that the user can't change
-- it should basically match the Non-changeable properties in TS for TileConfigurationDto
DECLARE @exampleNonUserChangeableObject NVARCHAR(max) = '
{
  "TileTypeId": "DFEE9D62-92D6-4068-845F-CB11C528D95D",
  "TileTypeName": "Replication Monitor",
  "TileType": 0,
  "Description": "",
  "ShortName": "",
  "TileInstanceId": "0561d8a0-c454-409a-97c5-4df8e62be8f6",
  "isRequired": false,
  "isUnique": false,
  "isCollapsible": true,
  "isConfigurable": false,
  "canLoad": false,
  "isLoaded": false,
  "canMoreVert": false,
  "canRefresh": true,
  "canSort": false,
  "canMaximize": true,
  "displayHeader": true,
  "displayFooter": true,
  "canPrint": false
}
'

-- Calculated variables:
DECLARE @fullPropertyPath NVARCHAR(MAX) = @pathToObjectContainingProperty + '.' + @propertyName
DECLARE @JSON_MODIFY_Path NVARCHAR(MAX) = @modifyPrefix + ' ' + @fullPropertyPath
DECLARE @userChangeable bit =
   CASE WHEN EXISTS(SELECT 1 FROM OPENJSON(@exampleNonUserChangeableObject, '$') WHERE [key] = @propertyName)
      THEN 0
      ELSE 1
   END

SELECT
   @fullPropertyPath as '@fullPropertyPath',
   @newValue as '@newValue',
   @currentTileTypeUid as '@currentTileTypeUid',
   @userChangeable as '@userChangeable'


DECLARE @UpdatedLTC UIDLIST
UPDATE ListTileConfiguration
SET
   Data =
      CASE WHEN (ISJSON(Data) > 0)
          THEN CASE WHEN @newValueType = 'bit'
                  -- have to do a CAST here to not have '' around the true or false
                  -- we may have to add other special cases here as well
                  THEN JSON_MODIFY(Data, 'lax' + ' ' + '$' + '.' + 'patientIdType', CAST(@newValue as bit))
                  WHEN @newValueType = 'int'
                  THEN JSON_MODIFY(Data, 'lax' + ' ' + '$' + '.' + 'patientIdType', CAST(@newValue as int))
                  WHEN @newValueType = 'decimal' OR @newValueType = 'numeric'
                  THEN JSON_MODIFY(Data, 'lax' + ' ' + '$' + '.' + 'patientIdType', CAST(@newValue as decimal))
                  ELSE JSON_MODIFY(Data, 'lax' + ' ' + '$' + '.' + 'patientIdType', @newValue)
              END
          ELSE Data
      END,
   TileTypeUid =
      CASE WHEN @fullPropertyPath = '$.TileTypeId'
         THEN @newValue
         ELSE TileTypeUid
      END,
   LastModifiedByUid = NULL,
   LastModifiedDate = GETUTCDATE()
OUTPUT inserted.TileConfigurationUid INTO @UpdatedLTC(Uid)
WHERE TileTypeUid = @currentTileTypeUid
AND (@userChangeable = 0 OR UserDefined = 0)


SELECT 'ListTileConfiguration'
SELECT ltc.*
FROM @UpdatedLTC ltcList
INNER JOIN ListTileConfiguration ltc ON ltcList.Uid = ltc.TileConfigurationUid


-- I think for the usertileconfiguration, it would only overwrite properties that already exist in the JSON,
-- because these are not the full objects, like they are in the Data column of ListTileConfiguration, so it wouldn't make sense that you would be adding to them
-- even if you added a new user changeable property to the Data structure.
-- I think that I would expect that  the user would have to actually go and manually make that change to overwite the row with some value for that property
DECLARE @UpdatedUTC UIDLIST
UPDATE utc
SET
   Data =
      CASE WHEN (ISJSON(utc.Data) > 0) AND EXISTS(SELECT 1 FROM OPENJSON(utc.Data, '$') WHERE [key] = @propertyName)
         THEN CASE WHEN @newValueType = 'bit'
                  -- have to do a CAST here to not have '' around the true or false
                  -- we may have to add other special cases here as well
                  THEN JSON_MODIFY(utc.Data, 'lax' + ' ' + '$' + '.' + 'patientIdType', CAST(@newValue as bit))
                  WHEN @newValueType = 'int'
                  THEN JSON_MODIFY(utc.Data, 'lax' + ' ' + '$' + '.' + 'patientIdType', CAST(@newValue as int))
                  WHEN @newValueType = 'decimal' OR @newValueType = 'numeric'
                  THEN JSON_MODIFY(utc.Data, 'lax' + ' ' + '$' + '.' + 'patientIdType', CAST(@newValue as decimal))
                  ELSE JSON_MODIFY(utc.Data, 'lax' + ' ' + '$' + '.' + 'patientIdType', @newValue)
              END
         ELSE utc.Data
      END,
   LastModifiedByUid = NULL,
   LastModifiedDate = GETUTCDATE()
OUTPUT inserted.UserTileConfigurationUid INTO @UpdatedUTC(Uid)
FROM UserTileConfiguration utc
INNER JOIN @UpdatedLTC ltcList ON ltcList.Uid = utc.TileConfigurationUid
AND (@userChangeable = 0 OR utc.UserDefined = 0)

SELECT 'UserTileConfiguration'
SELECT utc.*
FROM @UpdatedUTC utcList
INNER JOIN UserTileConfiguration utc ON utcList.Uid = utc.UserTileConfigurationUid


IF(@trialRun = 1)
   ROLLBACK TRANSACTION
ELSE
   COMMIT TRANSACTION
GO
-- #142034 end

-- #143771 #144363 #144143 _ListIcDeleteProcessor_TableName_Update.sql
update ListIcDeleteProcessor
set TableName = 'PersonInsurancePlan'
where IcDeleteProcessorUid = 'CB8B0558-6F68-4867-A254-43B4533CDE41'

update ListIcDeleteProcessor
set TableName = 'VisitPlanDiagnosis'
where IcDeleteProcessorUid = '799ABDB6-071F-4D86-A41A-1CAB59088555'

update ListIcDeleteProcessor
set TableName = 'VisitPlanDiagnosis'
where IcDeleteProcessorUid = '9237DBBD-F132-43D5-AF17-226AD63A456D'
GO

-- #147639 _RemovedFormSubmissionSubscribeLogs.sql
delete IcMessageLog
where IcMessageLogUid = 'CD83E97E-0B96-460E-8130-1D6106E731DC'
or IcMessageLogUid = '10E8EB64-1BAA-4E4C-9B13-537692924D78'
or IcMessageLogUid = '7F9326B7-CF7A-4A6E-966B-12A99461F6A2'
GO

-- #144115 *Current Sex and Birth Sex: Prepopulation 
update Person set BirthGenderUid = GenderUid where BirthGenderUid is null and GenderUid is not null
GO

-- #143863 - FND: Family history does not display on History tile on QAMASTER environments
UPDATE ListUIConfiguration SET Data = REPLACE(Data, '00000000-0000-0000-0000-000000000104', 'A3FAF896-B328-4364-9621-012F8C6643BB')
WHERE Data like '%00000000-0000-0000-0000-000000000104%' AND UIConfigurationDataTypeUid = '54980156-422F-496B-9929-75AAFDABE25A'
GO

-- #148444 Uncle&Aunt Maternal&Paternal Snomed Update Script.sql
UPDATE ListHxRelationship 
SET MaternalSnomedConceptID = '442031000124102',
MaternalDescriptionUid = '00000000-0000-0000-0000-003526000016',
PaternalSnomedConceptID = '442041000124107',
PaternalDescriptionUid = '00000000-0000-0000-0000-003517561017'
WHERE HxRelationshipUid = 'C62CB22C-3BA3-4B17-9112-FF4A38761050'

UPDATE ListHxRelationship 
SET MaternalSnomedConceptID = '736454006',
MaternalDescriptionUid = '00000000-0000-0000-0000-003517552017',
PaternalSnomedConceptID = '736455007',
PaternalDescriptionUid = '00000000-0000-0000-0000-003517554016'
WHERE HxRelationshipUid = '5E3D8FEC-BB4E-489C-AE0C-838EB9704E34'
GO

-- #148297 AllergyNoKnown Migration Script.sql
UPDATE ListIcDeleteProcessor 
SET DeletableRegistryEntityEnumString = 'AllergyNoKnown' 
WHERE IcDeleteProcessorUid = 'BC86B81F-6499-4A33-AAE0-7699E03D31F6'
GO

-- #149668 _UpdateTransmissionConfiguration_StagingEndpoints.sql
UPDATE transmissionconfiguration
SET 
TestAprimaVaultURL = replace (TestAprimaVaultURL ,'cpdev03','cpdev02.pop.e-mds.com'),
TestAprimaVaultSubmissionURL = replace (TestAprimaVaultSubmissionURL ,'cpdev03','cpdev02.pop.e-mds.com'),
TestOverrideAprimaVaultURL = replace (TestOverrideAprimaVaultURL ,'cpdev03','cpdev02.pop.e-mds.com'),
TestAprimaVaultSyncURL = replace (TestAprimaVaultSyncURL ,'cpdev03','cpdev02.pop.e-mds.com'),
TestRegistrationURL = replace (TestRegistrationURL ,'cpdev03','cpdev02.pop.e-mds.com')
WHERE
TestAprimaVaultURL like '%cpdev03%'
or TestAprimaVaultSubmissionURL like '%cpdev03%'
or TestAprimaVaultSyncURL like '%cpdev03%'
or TestOverrideAprimaVaultURL like '%cpdev03%'
or TestRegistrationURL like '%cpdev03%'

GO

-- #149469 
-- User story 149469 - *Recalls: Add Patient Program to the Filter Attributes and Column Display
update ListFindTable set Columns ='<FindColumn name="Selected" caption=" " visible="true" IsEditable="true" datatype="bool" width="20" />
<FindColumn name="CreateDateTime" caption="Date Created" index="createdatetime" visible="true" width="20" datatype="date" hyperlink="true" />
<FindColumn name="PatientName" caption="Patient" index="patientname" visible="true" width="150" hyperlink="true" />
<FindColumn name="ProviderName" caption="Provider" visible="true" width="150" />
<FindColumn name="RecallType" caption="Recall Type" visible="true" width="20" />
<FindColumn name="NotificationUserName" caption="Notification Person" index="notificationusername" visible="true" width="150" />
<FindColumn name="DateNotified" caption="Date Notified" visible="true" width="20" datatype="date" />
<FindColumn name="DateDue" caption="Date Due" visible="true" width="20" datatype="date" />
<FindColumn name="DateSatisfied" caption="Date Satisfied" visible="true" width="20" datatype="date" />
<FindColumn name="HMRule" caption="CDS Rule" visible="true" width="150" />
<FindColumn name="PreferredContactMethod" caption="Preferred Contact Method" index="preferrednotificationmethod" visible="true" width="150" />
<FindColumn name="ContactMethod" caption="Contact Method" visible="true" width="20" />
<FindColumn name="Notes" caption="Notes" visible="true" width="150" />
<FindColumn name="PatientWebAccess" caption="Portal Access" index="patientwebaccess" visible="true" datatype="bool" truevalue="Yes" falsevalue="No" />
<FindColumn name="PatientConditionNames" caption="Patient Condition" index="patientconditionnames" visible="true" width="150"/>
<FindColumn name="PatientProgramNames" caption="Patient Program" index="patientprogramnames" visible="true" width="150"/>
<FindColumn name="Inactive" index="inactive" visible="false" />
<FindColumn name="Name" index="name" visible="false" />' where FindTableUid = '119F0748-2A69-4B8C-A132-EA47B9328FBE'
GO

-- #150995 #153669 _updateHCCcategories.sql   153669_HCC189NotRollingUp.sql
-- Fix for bug 150995 - F33.1 Incorrect HCC Disease Category Description
-- Fix for bug 153669 - HCC not rolling up HCC category 189 Dx when HCC category 106 Dx exists for the patient
-- Fix for bug 153669 - backed out changes
update ListProductParameter set StringValue = '{
  "HCCYear": [
    {
      "Year": "2019",
      "Version": "V23",
      "Description": "CMS-HCC Model",
      "LastModifiedDate": "03/21/2019",
      "rules": [
        {
          "name": "HIV/AIDS",
          "method": "MAX(HCC1)"
        },
        {
          "name": "SEPSIS",
          "method": "MAX(HCC2)"
        },
        {
          "name": "Opportunistic Infections",
          "method": "MAX(HCC6)"
        },
        {
          "name": "Cancer",
          "method": "MAX(HCC8, HCC9, HCC10, HCC11, HCC12)"
        },
        {
          "name": "Diabetes",
          "method": "MAX(HCC17, HCC18, HCC19)"
        },
        {
          "name": "Protein-Calorie Malnutrition",
          "method": "MAX(HCC21)"
        },
        {
          "name": "Morbid Obesity",
          "method": "MAX(HCC22)"
        },
        {
          "name": "Other Significant Endocrine and Metabolic Disorders",
          "method": "MAX(HCC23)"
        },
        {
          "name": "End-Stage Liver Disease",
          "method": "MAX(HCC27, HCC28, HCC29)"
        },
        {
          "name": "Intestinal Obstruction/Perforation",
          "method": "MAX(HCC33)"
        },
        {
          "name": "Chronic Pancreatitis",
          "method": "MAX(HCC34)"
        },
        {
          "name": "Inflammatory Bowel Disease",
          "method": "MAX(HCC35)"
        },
        {
          "name": "Bone/Joint/Muscle Infections/Necrosis",
          "method": "MAX(HCC39)"
        },
        {
          "name": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
          "method": "MAX(HCC40)"
        },
        {
          "name": "Severe Hematological Disorders",
          "method": "MAX(HCC46, HCC48)"
        },
        {
          "name": "IMMUNE",
          "method": "MAX(HCC47)"
        },
        {
          "name": "Substance Use with Psychotic Complications",
          "method": "MAX(HCC54, HCC55, HCC56)"
        },
        {
          "name": "Schizophrenia",
          "method": "MAX(HCC57, HCC58, HCC59, HCC60)"
        },
        {
          "name": "Quadriplegia",
          "method": "MAX(HCC70, HCC71, HCC72, HCC103, HCC104, HCC169)"
        },
        {
          "name": "Cerebral Palsy",
          "method": "MAX(HCC74)"
        },
        {
          "name": "Myasthenia Gravis/Myoneural Disorders and Guillain-Barre Syndrome/Inflammatory and Toxic Neuropathy",
          "method": "MAX(HCC75)"
        },
        {
          "name": "Muscular Dystrophy",
          "method": "MAX(HCC76)"
        },
        {
          "name": "Multiple Sclerosis",
          "method": "MAX(HCC77)"
        },
        {
          "name": "Parkinson/Huntington Diseases",
          "method": "MAX(HCC78)"
        },
        {
          "name": "Seizure Disorders and Convulsions",
          "method": "MAX(HCC79)"
        },
        {
          "name": "CARD_RESP_FAIL",
          "method": "MAX(HCC82, HCC83, HCC84)"
        },
        {
          "name": "CHF",
          "method": "MAX(HCC85)"
        },
        {
          "name": "Acute Myocardial Infarction",
          "method": "MAX(HCC86, HCC87, HCC88)"
        },
        {
          "name": "Specified Heart Arrhythmias",
          "method": "MAX(HCC96)"
        },
        {
          "name": "Cerebral Hemorrhage",
          "method": "MAX(HCC99, HCC100)"
        },
        {
          "name": "Atherosclerosis of Extremity with Ulceration or Gangrene",
          "method": "MAX(HCC106, HCC107, HCC108)"
        },
        {
          "name": "COPD",
          "method": "MAX(HCC110, HCC111, HCC112)"
        },
        {
          "name": "Aspiration and Specified Bacterial Pneumonias",
          "method": "MAX(HCC114, HCC115)"
        },
        {
          "name": "Proliferative Diabetic Retinopathy and Vitreous Hemorrhage",
          "method": "MAX(HCC122)"
        },
        {
          "name": "Exudative Macular Degeneration",
          "method": "MAX(HCC124)"
        },
        {
          "name": "Renal",
          "method": "MAX(HCC134, HCC135, HCC136, HCC137, HCC138)"
        },
        {
          "name": "Ulcer of Skin",
          "method": "MAX(HCC157, HCC158, HCC161)"
        },
        {
          "name": "Severe Skin Burn or Condition",
          "method": "MAX(HCC162)"
        },
        {
          "name": "Severe Head Injury",
          "method": "MAX(HCC166, HCC80, HCC167)"
        },
        {
          "name": "Hip Fracture/Dislocation",
          "method": "MAX(HCC170)"
        },
        {
          "name": "Traumatic Amputations and Complications",
          "method": "MAX(HCC173)"
        },
        {
          "name": "COMPL",
          "method": "MAX(HCC176)"
        },
        {
          "name": "Major Organ Transplant Status or Replacement Status",
          "method": "MAX(HCC186)"
        },
        {
          "name": "Artificial Openings for Feeding or Elimination",
          "method": "MAX(HCC188)"
        },
        {
          "name": "Amputation status, lower limb/amputation complication",
          "method": "MAX(HCC189)"
        },
        {
          "name": "Other",
          "method": "MissingCategory"
        },
        {
          "name": "Disease HCC Total",
          "method": "SUM_ALL"
        }
      ],
      "categories": [
        {
          "Description": "HIV/AIDS",
          "HccModelCat": "1"
        },
        {
          "Description": "Septicemia, sepsis and systemic inflammatory response syndrome/shock",
          "HccModelCat": "2"
        },
        {
          "Description": "Opportunistic infections",
          "HccModelCat": "6"
        },
        {
          "Description": "Metastatic cancer and acute leukemia",
          "HccModelCat": "8"
        },
        {
          "Description": "Lung and other severe cancers",
          "HccModelCat": "9"
        },
        {
          "Description": "Lymphoma and other cancers",
          "HccModelCat": "10"
        },
        {
          "Description": "Colorectal, bladder and other cancers",
          "HccModelCat": "11"
        },
        {
          "Description": "Breast, prostate, and other cancers and tumors",
          "HccModelCat": "12"
        },
        {
          "Description": "Diabetes with acute, complications",
          "HccModelCat": "17"
        },
        {
          "Description": "Diabetes with chronic, complications",
          "HccModelCat": "18"
        },
        {
          "Description": "Diabetes without, complication",
          "HccModelCat": "19"
        },
        {
          "Description": "Protein-calorie malnutrition",
          "HccModelCat": "21"
        },
        {
          "Description": "Morbid obesity",
          "HccModelCat": "22"
        },
        {
          "Description": "Other significant endocrine and metabolic disorders",
          "HccModelCat": "23"
        },
        {
          "Description": "End-stage liver disease",
          "HccModelCat": "27"
        },
        {
          "Description": "Cirrhosis of liver",
          "HccModelCat": "28"
        },
        {
          "Description": "Chronic hepatitis",
          "HccModelCat": "29"
        },
        {
          "Description": "Intestinal obstruction/perforation",
          "HccModelCat": "33"
        },
        {
          "Description": "Chronic pancreatitis",
          "HccModelCat": "34"
        },
        {
          "Description": "Inflammatory bowel disease",
          "HccModelCat": "35"
        },
        {
          "Description": "Bone/joint/muscle infections/necrosis",
          "HccModelCat": "39"
        },
        {
          "Description": "Rheumatoid arthritis and inflammatory connective tissue disease",
          "HccModelCat": "40"
        },
        {
          "Description": "Severe hematological disorders",
          "HccModelCat": "46"
        },
        {
          "Description": "Disorders of immunity",
          "HccModelCat": "47"
        },
        {
          "Description": "Coagulation defects and other specified hematological disorders",
          "HccModelCat": "48"
        },
        {
          "Description": "Dementia with complications",
          "HccModelCat": "51"
        },
        {
          "Description": "Dementia without complication",
          "HccModelCat": "52"
        },
        {
          "Description": "Substance use with psychotic complications",
          "HccModelCat": "54"
        },
        {
          "Description": "Substance use disorder, moderate/severe or substance use with complications",
          "HccModelCat": "55"
        },
        {
          "Description": "Substance use disorder, mild, except alcohol and cannabis",
          "HccModelCat": "56"
        },
        {
          "Description": "Schizophrenia",
          "HccModelCat": "57"
        },
        {
          "Description": "Reactive and unspecified psychosis",
          "HccModelCat": "58"
        },
        {
          "Description": "Major depressive, bipolar and paranoid disorders",
          "HccModelCat": "59"
        },
        {
          "Description": "Personality disorder",
          "HccModelCat": "60"
        },
        {
          "Description": "Quadriplegia",
          "HccModelCat": "70"
        },
        {
          "Description": "Paraplegia",
          "HccModelCat": "71"
        },
        {
          "Description": "Spinal cord disorders/injuries",
          "HccModelCat": "72"
        },
        {
          "Description": "Amyotrophic lateral sclerosis and other motor neuron disease",
          "HccModelCat": "73"
        },
        {
          "Description": "Cerebral palsy",
          "HccModelCat": "74"
        },
        {
          "Description": "Myasthenia gravis/myoneural disorders and guillain-barre syndrome/inflammatory and toxic neuropathy",
          "HccModelCat": "75"
        },
        {
          "Description": "Muscular dystrophy",
          "HccModelCat": "76"
        },
        {
          "Description": "Multiple sclerosis",
          "HccModelCat": "77"
        },
        {
          "Description": "Parkinson''s and Huntington''s diseases",
          "HccModelCat": "78"
        },
        {
          "Description": "Seizure disorders and convulsions",
          "HccModelCat": "79"
        },
        {
          "Description": "Coma, brain compression/anoxic damage",
          "HccModelCat": "80"
        },
        {
          "Description": "Respirator dependence/tracheostomy status",
          "HccModelCat": "82"
        },
        {
          "Description": "Respiratory arrest",
          "HccModelCat": "83"
        },
        {
          "Description": "Cardio-respiratory failure and shock",
          "HccModelCat": "84"
        },
        {
          "Description": "Congestive heart failure",
          "HccModelCat": "85"
        },
        {
          "Description": "Acute myocardial infarction",
          "HccModelCat": "86"
        },
        {
          "Description": "Unstable angina and other acute ischemic heart disease",
          "HccModelCat": "87"
        },
        {
          "Description": "Angina pectoris",
          "HccModelCat": "88"
        },
        {
          "Description": "Specified heart arrhythmias",
          "HccModelCat": "96"
        },
        {
          "Description": "Cerebral hemorrhage",
          "HccModelCat": "99"
        },
        {
          "Description": "Ischemic or unspecified stroke",
          "HccModelCat": "100"
        },
        {
          "Description": "Hemiplegia/hemiparesis",
          "HccModelCat": "103"
        },
        {
          "Description": "Monoplegia, other paralytic syndromes",
          "HccModelCat": "104"
        },
        {
          "Description": "Atherosclerosis of extremity with ulceration or gangrene",
          "HccModelCat": "106"
        },
        {
          "Description": "Vascular disease with complications",
          "HccModelCat": "107"
        },
        {
          "Description": "Vascular disease",
          "HccModelCat": "108"
        },
        {
          "Description": "Cystic fibrosis",
          "HccModelCat": "110"
        },
        {
          "Description": "Chronic obstructive pulmonary disease",
          "HccModelCat": "111"
        },
        {
          "Description": "Fibrosis of lung and other chronic lung disorders",
          "HccModelCat": "112"
        },
        {
          "Description": "Aspiration and specified bacterial pneumonias",
          "HccModelCat": "114"
        },
        {
          "Description": "Pneumococcal pneumonia, empyema, lung abscess",
          "HccModelCat": "115"
        },
        {
          "Description": "Proliferative diabetic retinopathy and vitreous hemorrhage",
          "HccModelCat": "122"
        },
        {
          "Description": "Exudative macular degeneration",
          "HccModelCat": "124"
        },
        {
          "Description": "Dialysis status",
          "HccModelCat": "134"
        },
        {
          "Description": "Acute renal failure",
          "HccModelCat": "135"
        },
        {
          "Description": "Chronic kidney disease (stage 5)",
          "HccModelCat": "136"
        },
        {
          "Description": "Chronic kidney disease, severe (stage 4)",
          "HccModelCat": "137"
        },
        {
          "Description": "Chronic kidney disease, moderate (stage 3)",
          "HccModelCat": "138"
        },
        {
          "Description": "Pressure ulcer of skin with necrosis through to muscle, tendon, bone",
          "HccModelCat": "157"
        },
        {
          "Description": "Pressure ulcer of skin with full thickness skin loss",
          "HccModelCat": "158"
        },
        {
          "Description": "Pressure ulcer of skin with partial thickness skin loss",
          "HccModelCat": "159"
        },
        {
          "Description": "Chronic ulcer of skin, except pressure",
          "HccModelCat": "161"
        },
        {
          "Description": "Severe skin burn or condition",
          "HccModelCat": "162"
        },
        {
          "Description": "Severe head injury",
          "HccModelCat": "166"
        },
        {
          "Description": "Major head injury",
          "HccModelCat": "167"
        },
        {
          "Description": "Vertebral fractures without spinal cord injury",
          "HccModelCat": "169"
        },
        {
          "Description": "Hip fracture/dislocation",
          "HccModelCat": "170"
        },
        {
          "Description": "Traumatic amputations and complications",
          "HccModelCat": "173"
        },
        {
          "Description": "Complication of specified implanted device or graft",
          "HccModelCat": "176"
        },
        {
          "Description": "Major organ transplant status or replacement status",
          "HccModelCat": "186"
        },
        {
          "Description": "Artificial openings for feeding or elimination",
          "HccModelCat": "188"
        },
        {
          "Description": "Amputation status, lower limb/amputation complication",
          "HccModelCat": "189"
        }
      ]
    },
    {
      "Year": "2020",
      "Version": "V24",
      "Description": "CMS-HCC Model",
      "LastModifiedDate": "11/24/2021",
      "rules": [
        {
          "name": "HIV/AIDS",
          "method": "MAX(HCC1)"
        },
        {
          "name": "SEPSIS",
          "method": "MAX(HCC2)"
        },
        {
          "name": "Opportunistic Infections",
          "method": "MAX(HCC6)"
        },
        {
          "name": "Cancer",
          "method": "MAX(HCC8, HCC9, HCC10, HCC11, HCC12)"
        },
        {
          "name": "Diabetes",
          "method": "MAX(HCC17, HCC18, HCC19)"
        },
        {
          "name": "Protein-Calorie Malnutrition",
          "method": "MAX(HCC21)"
        },
        {
          "name": "Morbid Obesity",
          "method": "MAX(HCC22)"
        },
        {
          "name": "Other Significant Endocrine and Metabolic Disorders",
          "method": "MAX(HCC23)"
        },
        {
          "name": "End-stage liver disease",
          "method": "MAX(HCC27, HCC28, HCC29, HCC80)"
        },
        {
          "name": "Intestinal Obstruction/Perforation",
          "method": "MAX(HCC33)"
        },
        {
          "name": "Chronic Pancreatitis",
          "method": "MAX(HCC34)"
        },
        {
          "name": "Inflammatory Bowel Disease",
          "method": "MAX(HCC35)"
        },
        {
          "name": "Bone/Joint/Muscle Infections/Necrosis",
          "method": "MAX(HCC39)"
        },
        {
          "name": "Rheumatoid Arthritis and Inflammatory Connective Tissue Disease",
          "method": "MAX(HCC40)"
        },
        {
          "name": "Hematological Disorders",
          "method": "MAX(HCC46, HCC48)"
        },
        {
          "name": "IMMUNE",
          "method": "MAX(HCC47)"
        },
        {
          "name": "Dementia",
          "method": "MAX(HCC51, HCC52)"
        },
        {
          "name": "Substance Use with Psychotic Complications",
          "method": "MAX(HCC54, HCC55, HCC56)"
        },
        {
          "name": "Schizophrenia",
          "method": "MAX(HCC57, HCC58, HCC59, HCC60)"
        },
        {
          "name": "Quadriplegia/hemiplegia/hemiparesis",
          "method": "MAX(HCC70, HCC71, HCC72, HCC103, HCC104, HCC169)"
        },
        {
          "name": "Amyotrophic lateral sclerosis and other motor neuron disease",
          "method": "MAX(HCC73)"
        },
        {
          "name": "Cerebral Palsy",
          "method": "MAX(HCC74)"
        },
        {
          "name": "Myasthenia Gravis/Myoneural Disorders and Guillain-Barre Syndrome/Inflammatory and Toxic Neuropathy",
          "method": "MAX(HCC75)"
        },
        {
          "name": "Muscular Dystrophy",
          "method": "MAX(HCC76)"
        },
        {
          "name": "Multiple Sclerosis",
          "method": "MAX(HCC77)"
        },
        {
          "name": "Parkinson/Huntington Diseases",
          "method": "MAX(HCC78)"
        },
        {
          "name": "Seizure Disorders and Convulsions",
          "method": "MAX(HCC79)"
        },
        {
          "name": "CARD_RESP_FAIL",
          "method": "MAX(HCC82, HCC83, HCC84)"
        },
        {
          "name": "CHF",
          "method": "MAX(HCC85)"
        },
        {
          "name": "Acute Myocardial Infarction",
          "method": "MAX(HCC86, HCC87, HCC88)"
        },
        {
          "name": "Specified Heart Arrhythmias",
          "method": "MAX(HCC96)"
        },
        {
          "name": "Cerebral Hemorrhage",
          "method": "MAX(HCC99, HCC100)"
        },
        {
          "name": "Atherosclerosis of Extremity with Ulceration or Gangrene",
          "method": "MAX(HCC106, HCC107, HCC108)"
        },
        {
          "name": "COPD",
          "method": "MAX(HCC110, HCC111, HCC112)"
        },
        {
          "name": "Aspiration and Specified Bacterial Pneumonias",
          "method": "MAX(HCC114, HCC115)"
        },
        {
          "name": "Proliferative Diabetic Retinopathy and Vitreous Hemorrhage",
          "method": "MAX(HCC122)"
        },
        {
          "name": "Exudative Macular Degeneration",
          "method": "MAX(HCC124)"
        },
        {
          "name": "Renal",
          "method": "MAX(HCC134, HCC135, HCC136, HCC137, HCC138)"
        },
        {
          "name": "Ulcer of Skin",
          "method": "MAX(HCC157, HCC158, HCC161)"
        },
        {
          "name": "Pressure ulcer of skin with partial thickness skin loss",
          "method": "MAX(HCC159)"
        },
        {
          "name": "Severe Skin Burn or Condition",
          "method": "MAX(HCC162)"
        },
        {
          "name": "Severe Head Injury",
          "method": "MAX(HCC166, HCC167)"
        },
        {
          "name": "Hip Fracture/Dislocation",
          "method": "MAX(HCC170)"
        },
        {
          "name": "Traumatic Amputations and Complications",
          "method": "MAX(HCC173)"
        },
        {
          "name": "Complication of specified implanted device or graft",
          "method": "MAX(HCC176)"
        },
        {
          "name": "Major Organ Transplant Status or Replacement Status",
          "method": "MAX(HCC186)"
        },
        {
          "name": "Artificial Openings for Feeding or Elimination",
          "method": "MAX(HCC188)"
        },
        {
          "name": "Amputation status, lower limb/amputation complication",
          "method": "MAX(HCC189)"
        },
        {
          "name": "Other",
          "method": "MissingCategory"
        },
        {
          "name": "Disease HCC Total",
          "method": "SUM_ALL"
        }
      ],
      "categories": [
        {
          "Description": "HIV/AIDS",
          "HccModelCat": "1"
        },
        {
          "Description": "Septicemia, sepsis and systemic inflammatory response syndrome/shock",
          "HccModelCat": "2"
        },
        {
          "Description": "Opportunistic infections",
          "HccModelCat": "6"
        },
        {
          "Description": "Metastatic cancer and acute leukemia",
          "HccModelCat": "8"
        },
        {
          "Description": "Lung and other severe cancers",
          "HccModelCat": "9"
        },
        {
          "Description": "Lymphoma and other cancers",
          "HccModelCat": "10"
        },
        {
          "Description": "Colorectal, bladder and other cancers",
          "HccModelCat": "11"
        },
        {
          "Description": "Breast, prostate, and other cancers and tumors",
          "HccModelCat": "12"
        },
        {
          "Description": "Diabetes with acute, complications",
          "HccModelCat": "17"
        },
        {
          "Description": "Diabetes with chronic, complications",
          "HccModelCat": "18"
        },
        {
          "Description": "Diabetes without, complication",
          "HccModelCat": "19"
        },
        {
          "Description": "Protein-calorie malnutrition",
          "HccModelCat": "21"
        },
        {
          "Description": "Morbid obesity",
          "HccModelCat": "22"
        },
        {
          "Description": "Other significant endocrine and metabolic disorders",
          "HccModelCat": "23"
        },
        {
          "Description": "End-stage liver disease",
          "HccModelCat": "27"
        },
        {
          "Description": "Cirrhosis of liver",
          "HccModelCat": "28"
        },
        {
          "Description": "Chronic hepatitis",
          "HccModelCat": "29"
        },
        {
          "Description": "Intestinal obstruction/perforation",
          "HccModelCat": "33"
        },
        {
          "Description": "Chronic pancreatitis",
          "HccModelCat": "34"
        },
        {
          "Description": "Inflammatory bowel disease",
          "HccModelCat": "35"
        },
        {
          "Description": "Bone/joint/muscle infections/necrosis",
          "HccModelCat": "39"
        },
        {
          "Description": "Rheumatoid arthritis and inflammatory connective tissue disease",
          "HccModelCat": "40"
        },
        {
          "Description": "Severe hematological disorders",
          "HccModelCat": "46"
        },
        {
          "Description": "Disorders of immunity",
          "HccModelCat": "47"
        },
        {
          "Description": "Coagulation defects and other specified hematological disorders",
          "HccModelCat": "48"
        },
        {
          "Description": "Dementia with complications",
          "HccModelCat": "51"
        },
        {
          "Description": "Dementia without complication",
          "HccModelCat": "52"
        },
        {
          "Description": "Substance use with psychotic complications",
          "HccModelCat": "54"
        },
        {
          "Description": "Substance use disorder, moderate/severe or substance use with complications",
          "HccModelCat": "55"
        },
        {
          "Description": "Substance use disorder, mild, except alcohol and cannabis",
          "HccModelCat": "56"
        },
        {
          "Description": "Schizophrenia",
          "HccModelCat": "57"
        },
        {
          "Description": "Reactive and unspecified psychosis",
          "HccModelCat": "58"
        },
        {
          "Description": "Major depressive, bipolar and paranoid disorders",
          "HccModelCat": "59"
        },
        {
          "Description": "Personality disorder",
          "HccModelCat": "60"
        },
        {
          "Description": "Quadriplegia",
          "HccModelCat": "70"
        },
        {
          "Description": "Paraplegia",
          "HccModelCat": "71"
        },
        {
          "Description": "Spinal cord disorders/injuries",
          "HccModelCat": "72"
        },
        {
          "Description": "Amyotrophic lateral sclerosis and other motor neuron disease",
          "HccModelCat": "73"
        },
        {
          "Description": "Cerebral palsy",
          "HccModelCat": "74"
        },
        {
          "Description": "Myasthenia gravis/myoneural disorders and guillain-barre syndrome/inflammatory and toxic neuropathy",
          "HccModelCat": "75"
        },
        {
          "Description": "Muscular dystrophy",
          "HccModelCat": "76"
        },
        {
          "Description": "Multiple sclerosis",
          "HccModelCat": "77"
        },
        {
          "Description": "Parkinson''s and Huntington''s diseases",
          "HccModelCat": "78"
        },
        {
          "Description": "Seizure disorders and convulsions",
          "HccModelCat": "79"
        },
        {
          "Description": "Coma, brain compression/anoxic damage",
          "HccModelCat": "80"
        },
        {
          "Description": "Respirator dependence/tracheostomy status",
          "HccModelCat": "82"
        },
        {
          "Description": "Respiratory arrest",
          "HccModelCat": "83"
        },
        {
          "Description": "Cardio-respiratory failure and shock",
          "HccModelCat": "84"
        },
        {
          "Description": "Congestive heart failure",
          "HccModelCat": "85"
        },
        {
          "Description": "Acute myocardial infarction",
          "HccModelCat": "86"
        },
        {
          "Description": "Unstable angina and other acute ischemic heart disease",
          "HccModelCat": "87"
        },
        {
          "Description": "Angina pectoris",
          "HccModelCat": "88"
        },
        {
          "Description": "Specified heart arrhythmias",
          "HccModelCat": "96"
        },
        {
          "Description": "Cerebral hemorrhage",
          "HccModelCat": "99"
        },
        {
          "Description": "Ischemic or unspecified stroke",
          "HccModelCat": "100"
        },
        {
          "Description": "Hemiplegia/hemiparesis",
          "HccModelCat": "103"
        },
        {
          "Description": "Monoplegia, other paralytic syndromes",
          "HccModelCat": "104"
        },
        {
          "Description": "Atherosclerosis of extremity with ulceration or gangrene",
          "HccModelCat": "106"
        },
        {
          "Description": "Vascular disease with complications",
          "HccModelCat": "107"
        },
        {
          "Description": "Vascular disease",
          "HccModelCat": "108"
        },
        {
          "Description": "Cystic fibrosis",
          "HccModelCat": "110"
        },
        {
          "Description": "Chronic obstructive pulmonary disease",
          "HccModelCat": "111"
        },
        {
          "Description": "Fibrosis of lung and other chronic lung disorders",
          "HccModelCat": "112"
        },
        {
          "Description": "Aspiration and specified bacterial pneumonias",
          "HccModelCat": "114"
        },
        {
          "Description": "Pneumococcal pneumonia, empyema, lung abscess",
          "HccModelCat": "115"
        },
        {
          "Description": "Proliferative diabetic retinopathy and vitreous hemorrhage",
          "HccModelCat": "122"
        },
        {
          "Description": "Exudative macular degeneration",
          "HccModelCat": "124"
        },
        {
          "Description": "Dialysis status",
          "HccModelCat": "134"
        },
        {
          "Description": "Acute renal failure",
          "HccModelCat": "135"
        },
        {
          "Description": "Chronic kidney disease (stage 5)",
          "HccModelCat": "136"
        },
        {
          "Description": "Chronic kidney disease, severe (stage 4)",
          "HccModelCat": "137"
        },
        {
          "Description": "Chronic kidney disease, moderate (stage 3)",
          "HccModelCat": "138"
        },
        {
          "Description": "Pressure ulcer of skin with necrosis through to muscle, tendon, bone",
          "HccModelCat": "157"
        },
        {
          "Description": "Pressure ulcer of skin with full thickness skin loss",
          "HccModelCat": "158"
        },
        {
          "Description": "Pressure ulcer of skin with partial thickness skin loss",
          "HccModelCat": "159"
        },
        {
          "Description": "Chronic ulcer of skin, except pressure",
          "HccModelCat": "161"
        },
        {
          "Description": "Severe skin burn or condition",
          "HccModelCat": "162"
        },
        {
          "Description": "Severe head injury",
          "HccModelCat": "166"
        },
        {
          "Description": "Major head injury",
          "HccModelCat": "167"
        },
        {
          "Description": "Vertebral fractures without spinal cord injury",
          "HccModelCat": "169"
        },
        {
          "Description": "Hip fracture/dislocation",
          "HccModelCat": "170"
        },
        {
          "Description": "Traumatic amputations and complications",
          "HccModelCat": "173"
        },
        {
          "Description": "Complication of specified implanted device or graft",
          "HccModelCat": "176"
        },
        {
          "Description": "Major organ transplant status or replacement status",
          "HccModelCat": "186"
        },
        {
          "Description": "Artificial openings for feeding or elimination",
          "HccModelCat": "188"
        },
        {
          "Description": "Amputation status, lower limb/amputation complication",
          "HccModelCat": "189"
        }
      ]
    }
  ]
}'
where ProductParameterUid = 'E8F3D5A3-F9FE-434C-981C-63855F09A426'
go
-- #150995 #153669 end

-- #154146 _UpdateIntegrationPartnerEndpoint_RTPS.sql
IF EXISTS (
	SELECT 1 FROM ListIntegrationPartner
			WHERE IntegrationPartnerUid = 'DE089355-C000-4FC0-9706-4145E2D04FD4'
			AND AdditionalOutboundXML like '%https://integration.aprima.com/rest/ConnectiveRxRTPS%'
)
BEGIN
	UPDATE ListIntegrationPartner
	SET AdditionalOutboundXML = '<settings corepointTestBaseUrl="https://apigateway.healthportalsite.com:7443/infor/CustomerApi/prm/rest/ConnectiveRxRTPS" corepointProdBaseUrl="https://integrations.emdscloud.com/infor/CustomerApi/prm/rest/ConnectiveRxRTPS" testBaseUrl="https://rtps-api-uat.connectiverx.com/v1/patient-savings" baseUrl="https://rtps-api.connectiverx.com/v1/patient-savings">    <ProviderOptOut />  </settings>  '
	WHERE IntegrationPartnerUid = 'DE089355-C000-4FC0-9706-4145E2D04FD4'
END
GO

-- #154147 _UpdateTransmissionConfigurationEndpoint_Certificate.sql
IF EXISTS (
	SELECT 1 FROM TransmissionConfiguration
	WHERE
		TransmissionConfigurationUid = 'A885276B-3B8D-4914-A2D6-EE5C7198E359'
	AND
		AprimaVaultSyncURL = 'https://integration.aprima.com/cert/PartnerService'
)
BEGIN 
	UPDATE TransmissionConfiguration
		SET AprimaVaultSyncURL = 'https://integrations.emdscloud.com/infor/CustomerApi/prm/util/cert/partnerservice',
		TestAprimaVaultSyncURL = 'https://apigateway.healthportalsite.com:7443/infor/CustomerApi/prm/util/cert/partnerservice'
	WHERE
		TransmissionConfigurationUid = 'A885276B-3B8D-4914-A2D6-EE5C7198E359'
END
GO

-- #153836 _MIgration.sql
--Update CVXCode 24
Update ListCVXCode Set CVXFullVaccineName='Anthrax vaccine, adsorbed, pre-exposure and post-exposure prophylaxis',
CVXShortDesc='Anthrax, pre-exposure prophylaxis, post-exposure prophylaxis'
WHERE CVXCodeUid = '28152B4C-0970-481B-B63C-972EAF5B6FCD'
--Inactive VaccineUnitUse rows
Update VaccineUnitUse Set Inactive = 1, UseUnitEndDate='20240108' where
NDC11 in ('58160-0855-01')
Update VaccineUnitUse Set Inactive = 1, UseUnitEndDate='20231231' where
NDC11 in ('49281-0355-78', '49281-0323-88')
GO

-- #153534 _FixPrimayDisplayName_ViewFindUserAndUserGroup.sql
update ListFindControlBehavior set ColumnsConfig = '{      "PrimaryKey": "UId",      "PrimaryDisplayName": "InternalName",      "InactiveColumnName": "Inactive",      "Columns": [          {              "ColumnName": "InternalName",              "ColumnDisplayName": "Name",              "Visible": "true",              "CanFilter": "true",              "CanSelect": "true",              "Type": "string",              "Width": "200",              "SortOrder": "1"          },          {              "ColumnName": "UId",              "Visible": "false"          },          {              "ColumnName": "Inactive",              "ColumnDisplayName": "Inactive",              "Visible": "false",              "CanFilter": "true",              "Type": "bool"          }      ]  }'
where FindControlBehaviorUid = 'DAF5E08E-60F7-4351-AD3B-C2F5D4A819B8'
GO

-- #157923 _DeletePollIntakeEventsPollingProcessor.sql
delete from ListIcPollingProcessor
where IcPollingProcessorUid = '665695F2-E3BD-49C9-BBAA-886FC0DB8B5F'
GO

-- #158157 Remove default entry for Premium Patient Portal Outbound job.
delete from JobNotification
where JobNotificationUid = '7D16BE9D-0CA2-4FC3-A7CA-D40FD27D64EB'
GO

-- #158877 - Add ANSI 2 Telehealth
if exists(select * from ListServiceSiteType where Name = 'Telehealth')
begin
	update ListServiceSiteType set ANSICode = '02', ExternalID ='02', LastModifiedDate = '03/25/2024' where Name = 'Telehealth'
end
else begin
	insert into ListServiceSiteType (ServiceSiteTypeUid, ExternalID, ANSICode, Name, UserDefined, LastModifiedDate)
		values ('46154A76-14C7-45C5-96A5-213FEAA9F7C9', '02', '02', 'Telehealth', 0, '03/25/2024')
end
go
update ListEMServiceSite set ANSICode = '02', ExternalID = '02', LastModifiedDate = '03/25/2024' where EMServiceSiteUid = 'EE915218-2205-4766-985A-395E1375D76A'
go

-- #159059 _QAProcessorsRemoval.sql
delete from ListIcProcessor
where IcProcessorUid = 'DC239402-29F4-4504-864D-45A3A70E185E' 
or IcProcessorUid = '8C1A7441-EFB6-4E9F-9508-354C69EA1D94' 
or IcProcessorUid = '1A013731-5C2B-4D95-9ABF-C087B0C9C2E5'

update ListIcProcessor
set Inactive = 1
where IcProcessorUid = 'AE421B75-C605-480B-8008-C2F3AE307588' or IcProcessorUid = 'DFA9BC25-045C-4F99-878A-A3B3463BB331'
GO

/*
  Bug #156446  : Prescription Queue - Add Unmatched Requests Filter and Display Unmatched Requests in the list
	lcordell - removed by request 8/12/24

*/

-- #152068 - Add custom control to Premium Portal Outbound job.sql
update listjob set UIAssemblyQualifiedName = 'iMedica.Prm.Client.UI.JobEngine.ControlInteliChartJob' where jobuid = '384A0AC7-713D-47C2-BA9A-7668DB210966'
GO

-- #160731, #158562 Fix MVX column for Moderna Covid-19 vaccine
update VaccineUnitUse Set MVX = 'MOD' where VaccineUnitUseUid IN 
('33849D86-CC8A-421B-A99E-7B6925CF68D5', '4E6BB144-F2EC-42E8-A6D5-6ED64D77ECA8', 'BF3C7897-7D04-4089-8325-E76674C6284F')
GO


-- #97468 Update_ListDataFormatter_VisitStandardData.sql
UPDATE ListDataFormatter
SET FieldDefinition = '<Fields>
  <CustomFormatter Type="Internal" Origin="Visit" />
  <CustomFormatter Name="Custom Patient Data" Origin="Patient" />
  <CalledDataFormatter Uid="18667128-46B9-4648-B436-0C7A412DFFD5" Prefix="Visit" />
  <CalledDataFormatter Uid="8516DA6B-40B2-4DD7-A728-54B40DE960D0" Prefix="" />
  <CalledDataFormatter Uid="9D7520C3-B507-463F-9CFD-18BDE5A74677" Prefix="" />
  <CalledDataFormatter Uid="9D7520C3-B507-463F-9CFD-18BDE5A74677" Prefix="Rendering" />
  <CalledDataFormatter Uid="9D7520C3-B507-463F-9CFD-18BDE5A74677" Prefix="ReferredBy" />
  <CalledDataFormatter Uid="9D7520C3-B507-463F-9CFD-18BDE5A74677" Prefix="ReferTo" />
  <CalledDataFormatter Uid="161530C1-4D46-467A-96EA-E7234658231D" Prefix="" />
  <CalledDataFormatter Uid="613EA28C-45B0-4520-96B4-A5C512175312" Prefix="Visit" />
  <CalledDataFormatter Uid="613EA28C-45B0-4520-96B4-A5C512175312" Prefix="Patient" />
  <CalledDataFormatter Uid="AD31E16F-3298-4C77-9805-AA5CE115A338" Prefix="" />
  <CalledDataFormatter Uid="161530C1-4D46-467A-96EA-E7234658231D" Prefix="Next" />
  <CalledDataFormatter Uid="9D7520C3-B507-463F-9CFD-18BDE5A74677" Prefix="NextAppointment" />
  <CalledDataFormatter Uid="9D7520C3-B507-463F-9CFD-18BDE5A74677" Prefix="PrimaryCare" />
  <Field Name="VisitDate" Layout="Date" />
  <Field Name="VisitStatus" />
  <Field Name="VisitSavedDate" Layout="Date" />
  <Field Name="VisitCompletedDate" Layout="Date" />
  <Field Name="VisitProviderSignature" AllowsSizing="True" PermitsText="False" formatTypeAqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.ControlParmEditVisit" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="Provider''s signature for this visit - will only print when the note is complete/signed" />
  <Field Name="CCHPI" AllowsList="True" AllowsText="True" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.ControlParmParagraphBullet" MaxLevel="1" />
  <Field Name="CCComment" />
  <Field Name="HPIComment" />
  <Field Name="ROSParagraph" AllowsList="True" AllowsText="True" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.ControlParmParagraphBullet" MaxLevel="0" />
  <Field Name="ROSComment" />
  <Field Name="PE" AllowsList="True" AllowsText="True" />
  <Field Name="PEComment" />
  <Field Name="DXComment" />
  <Field Name="DX" AllowsList="True" AllowsText="True" />
  <Field Name="RXComment" />
  <Field Name="RX" AllowsList="True" AllowsText="True" />
  <Field Name="RXAdministeredDetail" />
  <Field Name="RXDetail" AllowsList="True" AllowsText="True" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="Rx information as well as addendums made" />
  <Field Name="ServicesOrderedComment" />
  <Field Name="ServicesOrdered" AllowsList="True" AllowsText="True" />
  <Field Name="ServicesPerformedComment" />
  <Field Name="ServicesPerformed" AllowsList="True" AllowsText="True" />
  <Field Name="ReviewOfHistoryParagraph" />
  <Field Name="PlanComment" />
  <Field Name="PlanParagraph" />
  <Field Name="CCPhrase" />
  <Field Name="CCPhraseNotes" />
  <Field Name="CCHPIClause" />
  <Field Name="OtherCC" />
  <Field Name="ReturnVisitTime" />
  <Field Name="SOResults" />
  <Field Name="SPResults" />
  <Field Name="ServicesOrderedWithCodes" AllowsList="True" AllowsText="True" />
  <Field Name="ServicesPerformedWithCodes" AllowsList="True" AllowsText="True" />
  <Field Name="VitalsWeight" />
  <Field Name="VitalsHeight" />
  <Field Name="VitalsBMI" />
  <Field Name="VitalsHeadCircumference" />
  <Field Name="VitalsTemperature" />
  <Field Name="VitalsRespirationRate" />
  <Field Name="VitalsSpO2" />
  <Field Name="VitalsSittingHeartRate" />
  <Field Name="VitalsStandingHeartRate" />
  <Field Name="VitalsSupineHeartRate" />
  <Field Name="VitalsBloodPressure" />
  <Field Name="VitalsBloodPressure2" />
  <Field Name="VitalsBloodPressure3" />
  <Field Name="VitalsBloodPressure4" />
  <Field Name="DXAssociationParagraph" />
  <Field Name="PatientInstruction" />
  <Field Name="PEAbnormalParagraph" />
  <Field Name="RXNoAssociation" />
  <Field Name="VitalsComment" />
  <Field Name="AttachmentsToVisitList" />
  <Field Name="ROSParagraphDeniesOnly" />
  <Field Name="ROSParagraphComplaintsOnly" />
  <Field Name="DXWithCodes" AllowsList="True" AllowsText="True" />
  <Field Name="DXCodesOnly" AllowsList="True" AllowsText="True" />
  <Field Name="DXCode1" />
  <Field Name="DXCode2" />
  <Field Name="DXCode3" />
  <Field Name="DXCode4" />
  <Field Name="CCAddendumNotes" />
  <Field Name="HPIAddendumNotes" />
  <Field Name="ROSAddendumNotes" />
  <Field Name="DxAddendumNotes" />
  <Field Name="PEAddendumNotes" />
  <Field Name="RxAddendumNotes" />
  <Field Name="SODxAssociations" />
  <Field Name="SOAddendumNotes" />
  <Field Name="SPEandMComment" />
  <Field Name="SPDxAssociations" />
  <Field Name="SPAddendumNotes" />
  <Field Name="ReimbursementRuleServicesParagraph" />
  <Field Name="ReimbursementRuleServicesCodesAndReasons" />
  <Field Name="ObservationValues" AllowsList="True" AllowsTable="True" />
  <Field Name="VisitServiceSiteName" />
  <Field Name="VisitServiceSiteAddresses" Layout="Address" />
  <Field Name="VisitServiceSitePhones" Layout="Phone" />
  <Field Name="VisitApprovalStatus" />
  <Field Name="ReferralProvidersList" />
  <Field Name="NextAppointmentsList" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="Obsolete, use the NextAppointmentsListAll field" />
  <Field Name="FaxToReferringProvider" />
  <Field Name="FaxToReferralProvider" />
  <Field Name="FaxToPatient" />
  <Field Name="FaxToPrimaryCareProvider" />
  <Field Name="VisitCosignSignature" AllowsSizing="True" PermitsText="False" />
  <Field Name="VisitCosignStatus" />
  <Field Name="RXShort" AllowsList="True" AllowsText="True" />
  <Field Name="RXShortWithAssociation" AllowsList="True" AllowsText="True" />
  <Field Name="ClinicalNoteType" />
  <Field Name="ResultsAssociatedThisVisit" AllowsList="True" AllowsText="True" />
  <Field Name="ResultsAssociatedThisVisitFullComments" AllowsList="True" AllowsText="True" />
  <Field Name="AssessmentForms" />
  <Field Name="ActiveMedicationBeforeVisit" AllowsList="True" AllowsText="True" />
  <Field Name="ActiveMedicationBeforeVisitShort" AllowsList="True" AllowsText="True" />
  <Field Name="ActiveMedicationBeforeVisitWithAssociations" AllowsList="True" AllowsText="True" />
  <Field Name="ActiveMedicationBeforeVisitShortWithAssociations" AllowsList="True" AllowsText="True" />
  <Field Name="PatientMedicationSummary" AllowsTable="True" dataTypeAqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditMedSummary" formatTypeAqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.ControlParmEditVisit" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="Use Patient Medication Summary to display the patient''s current medication, medication prescribed in the visit, or medication discontinued in the visit." />
  <Field Name="CCCommentAddendumNotes" />
  <Field Name="HPICommentAddendumNotes" />
  <Field Name="ROSCommentAddendumNotes" />
  <Field Name="PECommentAddendumNotes" />
  <Field Name="DXCommentAddendumNotes" />
  <Field Name="RXCommentAddendumNotes" />
  <Field Name="ServicesOrderedCommentAddendumNotes" />
  <Field Name="ServicesPerformedCommentAddendumNotes" />
  <Field Name="PlanCommentAddendumNotes" />
  <Field Name="VitalsCommentAddendumNotes" />
  <Field Name="PatientInstructionAddendumNotes" />
  <Field Name="ServicesOrderedByGroup" AllowsList="True" AllowsText="True" />
  <Field Name="ServicesOrderedWithCodeByGroup" AllowsList="True" AllowsText="True" />
  <Field Name="ServicesPerformedByGroup" AllowsList="True" AllowsText="True" />
  <Field Name="ServicesPerformedWithCodeByGroup" AllowsList="True" AllowsText="True" />
  <Field Name="ServicesOrderedHistory" AllowsList="True" AllowsTable="True" />
  <Field Name="ServicesPerformedHistory" AllowsList="True" AllowsTable="True" />
  <Field Name="DSMIVDX" AllowsList="True" AllowsText="True" />
  <Field Name="DSMIVDXWithCodes" AllowsList="True" AllowsText="True" />
  <Field Name="RXWithTracking" AllowsList="True" AllowsText="True" />
  <Field Name="VitalsAddendumNotes" />
  <Field Name="MedicationDiscontinuedInVisit" AllowsList="True" AllowsText="True" />
  <Field Name="GeneralComment" />
  <Field Name="InternalNotes" />
  <Field Name="InternalNotesAddendumNotes" />
  <Field Name="Historian" />
  <Field Name="MedicalDecisionMaking" />
  <Field Name="VisitAccountName" />
  <Field Name="VisitAccountTotalBalance" />
  <Field Name="VisitAccountType" />
  <Field Name="VisitAccountFundType" />
  <Field Name="VisitAccountEligibilityFund" />
  <Field Name="VisitAccountRegion" />
  <Field Name="VisitAccountPatientBalance" />
  <Field Name="VisitConfidentialNote" />
  <Field Name="VisitServiceSiteDirectAddress" />
  <Field Name="RenderingProviderDirectAddress" />
  <Field Name="ABNProcedures" AllowsTable="True" />
  <Field Name="ABNProceduresSpanish" AllowsTable="True" />
  <Field Name="VisitReferredTo" AllowsList="True" AllowsTable="True" />
  <Field Name="ArticulatedPlanText" />
  <Field Name="ArticulatedPlanTextAddendumNotes" />
  <Field Name="StartTime" Layout="Date" Definition="Start time of the visit." />
  <Field Name="EndTime" Layout="Date" Definition="End time of the visit." />
  <Field Name="VisitActionItem" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="Reminders or notes to yourself or another provider for something you need to talk about when the patient comes back in the office for the next visit." />
  <Field Name="ActivitySinceLastVisit" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="Notes about patient activity since last visit that remain with the patient until any of the patient''s notes are closed on FND." />
  <Field Name="NextAppointmentsListAll" dataTypeAqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditFutureAppointments" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="Use Next Appointment List to display all upcoming appointments for patient based on the days or amount selected." />
</Fields>'
where DataFormatterUid = '60CD5640-0B0F-4A76-92D7-164978F9C557'
GO
-- #97468 end pt 1

-- #97468 Update_ListDataFormatter_PatientStandardData.sql
UPDATE ListDataFormatter
SET FieldDefinition = '<Fields>
  <CalledDataFormatter Uid="18667128-46B9-4648-B436-0C7A412DFFD5" Prefix="" />
  <CalledDataFormatter Uid="9D7520C3-B507-463F-9CFD-18BDE5A74677" Prefix="PrimaryCare" />
  <CalledDataFormatter Uid="9D7520C3-B507-463F-9CFD-18BDE5A74677" Prefix="ReferredBy" />
  <CalledDataFormatter Uid="9D7520C3-B507-463F-9CFD-18BDE5A74677" Prefix="Practice" />
  <CalledDataFormatter Uid="04F3CEFD-81CB-4DB3-967C-407542776334" Prefix="" />
  <Field EmailPersonNotification="True" Name="PatientNames" Layout="Name" PlainTextPersonNotification="True" />
  <Field Name="PatientPrimaryAddresses" Layout="Address" />
  <Field Name="PatientSecondaryAddresses" Layout="Address" />
  <Field Name="PracticeProviderDirectAddress" Formatters="Patient Standard Data" />
  <Field Name="PatientExternalID" SMS="True" />
  <Field Name="PatientDOB" Layout="Date" />
  <Field Name="PatientAge" />
  <Field Name="PatientGender" Layout="CheckedBox" ListTable="ListGender" ListTableTitle="Patient Gender" ListTableUid="8BB7A012-33CD-400A-BCFA-7BB322D393E1" />
  <Field Name="PatientGenderInitial" />
  <Field Name="PatientMedicalRecordNumber" />
  <Field Name="PatientSSN" />
  <Field Name="PatientPhones" Layout="Phone" />
  <Field Name="PatientPronouns" Layout="Pronoun" />
  <Field Name="PatientInfoSentence" />
  <Field Name="PatientPrimaryEmail" />
  <Field Name="PatientSecondaryEmail" />
  <Field Name="PatientDeathDate" Layout="Date" />
  <Field Name="PatientMaritalStatus" Layout="CheckedBox" ListTable="ListMaritalStatus" ListTableTitle="Marital Status" ListTableUid="5C291314-BFE9-4148-8846-142C0D09DF16" />
  <Field Name="PatientRace" Layout="CheckedBox" ListTable="ListRace" ListTableTitle="Patient Race" ListTableUid="23E51DE0-67B1-4CD0-BC94-3B6FBFF6DE28" />
  <Field Name="PatientEthnicity" Layout="CheckedBox" ListTable="ListEthnicity" ListTableTitle="Patient Ethnicity" ListTableUid="23E51DE0-67B1-4CD0-BC94-3B6FBFF6DE28" />
  <Field Name="PatientLanguage" Layout="CheckedBox" ListTable="ListLanguage" ListTableTitle="Patient Language" ListTableUid="AA50D048-9076-4E80-8C34-34018787BD90" />
  <Field Name="PatientDominantHand" />
  <Field Name="PatientIsHispanic" />
  <Field Name="PatientPhoto" />
  <Field Name="ContactsNamesLine" />
  <Field Name="ContactsNamesMultiLine" />
  <Field Name="ContactsRelationships" />
  <Field Name="ContactsRelationshipsMultiLine" />
  <Field Name="ContactsPhones" Layout="Phone" />
  <Field Name="ContactsPhonesMultiLine" Layout="Phone" />
  <Field Name="ContactsWithAddress" />
  <Field Name="PatientEmployer" />
  <Field Name="PatientEmploymentStatus" Layout="CheckedBox" ListTable="ListEmploymentStatus" ListTableTitle="Employment Status" ListTableUid="A38C1CDC-E28B-41D3-84EA-2C22B77023A5" />
  <Field Name="PatientOccupation" />
  <Field Name="PatientEmployedFrom" />
  <Field Name="PatientEmployedTo" />
  <Field Name="PatientPharmacyName" />
  <Field Name="PatientPharmacyAddresses" Layout="Address" />
  <Field Name="PatientPharmacyPhones" Layout="Phone" />
  <Field Name="PatientPrimaryInsurancePayerPlan" Layout="CheckedBox" ListTable="ViewInsuranceCarrier" ListTableTitle="Insurance Carrier" />
  <Field Name="PatientPrimaryInsuranceGroupID" />
  <Field Name="PatientPrimaryInsuranceMemberID" />
  <Field Name="PatientPrimaryInsuranceSubscriber" />
  <Field Name="PatientPrimaryInsuranceSubscriberDOB" Layout="Date" />
  <Field Name="PatientPrimaryInsuranceSubscriberRelationship" />
  <Field Name="PatientPrimaryInsuranceAuthorizeAssignment" />
  <Field Name="PatientPrimaryInsurancePrimaryCoPay" />
  <Field Name="PatientPrimaryInsuranceSpecialistCoPay" />
  <Field Name="PatientPrimaryInsuranceOtherCoPay" />
  <Field Name="PatientPrimaryInsuranceAddresses" Layout="Address" />
  <Field Name="PatientSecondaryInsuranceAddresses" Layout="Address" />
  <Field Name="PatientSecondaryInsurancePayerPlan" Layout="CheckedBox" ListTable="ViewInsuranceCarrier" ListTableTitle="Insurance Carrier" />
  <Field Name="PatientSecondaryInsuranceGroupID" />
  <Field Name="PatientSecondaryInsuranceMemberID" />
  <Field Name="PatientSecondaryInsuranceSubscriber" />
  <Field Name="PatientSecondaryInsuranceSubscriberDOB" Layout="Date" />
  <Field Name="PatientSecondaryInsuranceSubscriberRelationship" />
  <Field Name="PatientSecondaryInsuranceAuthorizeAssignment" />
  <Field Name="PatientSecondaryInsurancePrimaryCoPay" />
  <Field Name="PatientSecondaryInsuranceSpecialistCoPay" />
  <Field Name="PatientSecondaryInsuranceOtherCoPay" />
  <Field Name="PatientTertiaryInsurancePayerPlan" Layout="CheckedBox" ListTable="ViewInsuranceCarrier" ListTableTitle="Insurance Carrier" />
  <Field Name="PatientTertiaryInsuranceGroupID" />
  <Field Name="PatientTertiaryInsuranceMemberID" />
  <Field Name="PatientTertiaryInsuranceSubscriber" />
  <Field Name="PatientTertiaryInsuranceSubscriberDOB" Layout="Date" />
  <Field Name="PatientTertiaryInsuranceSubscriberRelationship" />
  <Field Name="PatientTertiaryInsuranceAuthorizeAssignment" />
  <Field Name="PatientTertiaryInsurancePrimaryCoPay" />
  <Field Name="PatientTertiaryInsuranceSpecialistCoPay" />
  <Field Name="PatientTertiaryInsuranceOtherCoPay" />
  <Field Name="PatientTertiaryInsuranceAddresses" Layout="Address" />
  <Field Name="AccountName" />
  <Field Name="AccountTotalBalance" />
  <Field Name="AccountType" />
  <Field Name="AccountFundType" />
  <Field Name="AccountEligibilityFund" />
  <Field Name="AccountRegion" />
  <Field Name="AccountPatientBalance" />
  <Field Name="PatientReferredTo" AllowsList="True" AllowsTable="True" formatTypeAqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.ControlParmEditVisit" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="From the Referral order Includes, Name, specialty, status, service site, Appointment, Appointment Notes, Referral Order Notes, visit date, Care Type" />
  <Field Name="AppointmentsLast90Days" AllowsList="True" AllowsText="True" />
  <Field Name="MothersMaidenName" />
  <Field Name="MothersMaidenNames" Layout="MothersMaidenName" />
  <Field Name="MaidenName" />
  <Field Name="PatientPersonNotes" />
  <Field Name="PatientSexualOrientation" />
  <Field Name="PatientGenderIdentity" />
  <Field Name="PatientStory" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="A brief snapshot of the patient’s history. It can be used to summarize the patient’s healthcare experience as it evolves." />
  <Field Name="PatientProgram" dataTypeAqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditActiveWithEffectiveAndExpiration" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="Use Patient Program to display all active programs for the patient or all programs associated to the patient based on the display type. This display can include effective or expiration dates." />
  <Field Name="WebAccountUserName" dataTypeAqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditPersonRelationship" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="This field is used to display the patient or person username created for web account." />
  <Field Name="PatientCondition" dataTypeAqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditPatientCondition" aqn="iMedica.Prm.Client.UI.PrmGeneralControls.Edit.ParameterEditors.DataEditors.ControlParmEditDataField" Definition="This field is used to display the patient''s condition(s) configured in demographics." />
</Fields>'
where DataFormatterUid = '8516DA6B-40B2-4DD7-A728-54B40DE960D0'
GO
-- #97468 end pt 2
