IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CreateSynonyms]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[CreateSynonyms]
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROCEDURE [dbo].[CreateSynonyms] @db_extension VARCHAR(50) = NULL AS
BEGIN

/*
This script will create all the table synonyms for Attachment and Common
Execute this script in the main "PRM" database.
*/

declare @SQL varchar(2000)
declare @dbName sysname
declare @tablename sysname
declare @schematype VARCHAR(50)
declare @schemacolumnname VARCHAR(50)

SET NOCOUNT ON
IF NOT EXISTS (SELECT * from ListProductParameter WHERE ParameterName = 'CommonDatabase')
	INSERT INTO [ListProductParameter]([ProductParameterUid], [ParameterName],[StringValue],[Inactive],[UserDefined],[LastModifiedDate]) 
		VALUES	(NEWID(), 'CommonDatabase', 'PRM_Common', '0', '1', GetUTCDate() )

IF @db_extension IS NULL
	BEGIN
		exec CreateSynonyms 'Attachment';
		exec CreateSynonyms 'Common';
		exec CreateSynonyms 'Formulary';
		RETURN
	END
ELSE IF @db_extension = 'Common'	
	BEGIN
		SELECT @dbName = StringValue from ListProductParameter WHERE ParameterName = 'CommonDatabase'
	END
ELSE IF @db_extension = 'Formulary'	
	BEGIN
		SELECT @dbName = StringValue + '_Formulary' from ListProductParameter WHERE ParameterName = 'CommonDatabase'
	END
ELSE IF @db_extension = ''
	SET	@dbName = SUBSTRING(DB_NAME(), 1, CHARINDEX('_', DB_NAME()) - 1)
ELSE
	BEGIN
		set @dbName = DB_Name() + '_' + @db_extension
	END		

create table #tempTableNames1
(
	[Name] varchar(2000),
	[Type] VARCHAR(50),
	[ColumnName] VARCHAR(50)
)

set @SQL ='insert into #tempTableNames1 ([Name], [Type], [ColumnName]) select [Table_Name], ''Tables'', ''Table_Name'' FROM ' +
		  QuoteName(@dbName) + '.INFORMATION_SCHEMA.Tables WHERE Table_Type = ''BASE TABLE''' 

exec (@SQL)

set @SQL ='insert into #tempTableNames1 ([Name], [Type], [ColumnName]) select [Specific_Name], ''Routines'', ''Specific_Name'' FROM ' +
		  QuoteName(@dbName) + '.INFORMATION_SCHEMA.Routines WHERE Routine_Type IN (''Procedure'', ''FUNCTION'')' 

exec (@SQL)

set @SQL ='insert into #tempTableNames1 ([Name], [Type], [ColumnName]) select [Table_Name], ''Views'', ''Table_Name'' FROM ' +
		  QuoteName(@dbName) + '.INFORMATION_SCHEMA.Views ' 

exec (@SQL)

DECLARE name_cursor CURSOR FOR select [Name], [Type], [ColumnName] from #tempTableNames1

OPEN name_cursor

FETCH NEXT FROM name_cursor INTO @tablename, @schematype, @schemacolumnname
WHILE (@@fetch_status <> -1)
BEGIN
	 IF (@@fetch_status <> -2)
	 BEGIN
		SET @SQL =
		'IF EXISTS (SELECT * FROM sys.synonyms WHERE name = N''' + @tablename + ''')' +
		'DROP SYNONYM [dbo].' + QuoteName(@tablename) + ';' +
		'IF NOT EXISTS (SELECT * FROM INFORMATION_SCHEMA.' + @schematype + ' WHERE ' + @schemacolumnname + ' = ''' + @tablename + ''')' + 
		'BEGIN;' +
		'CREATE SYNONYM [dbo].' + QuoteName(@tablename) + ' FOR ' + QuoteName(@dbName) + '.[dbo].' + QuoteName(@tablename) + ';' +
		'PRINT ''created synonym ' + QuoteName(@dbName) + '.[dbo].' + QuoteName(@tablename) + ''';' + 
		'END;'
	
		--select @sql          
		exec (@SQL)

	END
	FETCH NEXT FROM name_cursor INTO @tablename, @schematype, @schemacolumnname
END
CLOSE name_cursor
DEALLOCATE name_cursor

print ''
print 'Done'

SET NOCOUNT OFF
END
GO

-- Now run the new proc to make the synonyms

exec CreateSynonyms;
GO