-- copied from ReportUpdates.sql to fix unique index migration issue
-- #60294 Reports-Create Trigger to Disallow Changes to ListReportRDL and ListReport for all reports
-- disable these triggers before updates
IF EXISTS (select * from sys.objects where type = 'TR' and name = 'BlockReportRdlUpdates')
	ALTER TABLE [dbo].[ListReportRdl] DISABLE TRIGGER [BlockReportRdlUpdates]
GO
IF EXISTS (select * from sys.objects where type = 'TR' and name = 'BlockReportUpdates')
	ALTER TABLE [dbo].[ListReport] DISABLE TRIGGER [BlockReportUpdates]
GO

-- #123867 _MIGRATION.sql
DELETE from ListReportRdl where ReportRdlUid in 
(
'CD187A20-E30D-4183-95E0-BDCD0D0C5141', -- Total A/R Aging Detail
'039E39E1-45A3-4538-A7E8-8B153ED3A17D', -- Total A/R Aging Summary
'0BF4C45F-362F-4B37-BA98-55A51AF34957' -- Total AR Aging Excel
);
DELETE from ListReport where reportuid in 
(
'D044F932-1D27-487A-AA78-2DE0D4F8E450', -- Total A/R Aging Detail
'72AB87D4-5D3B-4A2E-9C32-A4AE6C0FB3B8', -- Total A/R Aging Summary
'EA6D1507-21FB-407A-AD15-EC9D0CBFAD23' -- Total AR Aging Excel
);
DELETE from ListUserDefinedControl where UserDefinedControlGroupUid = 'A9F2C6B9-7563-4755-A14E-E59E856498B6';
DELETE from ListUserDefinedControlGroup where UserDefinedControlGroupUid = 'A9F2C6B9-7563-4755-A14E-E59E856498B6';
GO
-- cleanup lingering FK references
DELETE PSD
FROM   PrintSetDetail PSD
WHERE  ReportUid NOT IN (SELECT ReportUid FROM ListReport)
GO


-- no need to enable the trigger above as it will enable in ReportUpdates.sql
-- #60294 Keep this at the top
