-- #60294 Reports-Create Trigger to Disallow Changes to ListReportRDL and ListReport for all reports
-- disable these triggers before updates
IF EXISTS (select * from sys.objects where type = 'TR' and name = 'BlockReportRdlUpdates')
	ALTER TABLE [dbo].[ListReportRdl] DISABLE TRIGGER [BlockReportRdlUpdates]
GO
IF EXISTS (select * from sys.objects where type = 'TR' and name = 'BlockReportUpdates')
	ALTER TABLE [dbo].[ListReport] DISABLE TRIGGER [BlockReportUpdates]
GO
-- #60294 Keep this at the top


-- #100020  11/22/2022 zfernandez 100020 Superbills report - modify report so that some fields operate a little differently, to enhance performance.  
UPDATE Listuserdefinedcontrol 
SET
	UserDefined = 0, 
	LastModifiedByUid = NULL, 
	LastModifiedDate = '2022-11-22 00:00:00', 
	ControlProperties = 
		'<?xml version="1.0" encoding="utf-8"?>
		<UserDefinedControls>
			<Control>
				<ControlType>TIMESPAN</ControlType>
				<Name>Superbill</Name>
				<Uid>f2e52f89-7f2c-466a-a878-459f82fa12c9</Uid>
				<Required>TRUE</Required>
			</Control>
		</UserDefinedControls>'		-- Adding 'Today' as default and making TIMESPAN required on Superbill
WHERE UserDefinedControlUid = '4CC5F5F0-F6D4-4927-BBA7-1C89BC04D4C0'
GO

-- #101309 patients by age_MIGRATION.sql
IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '4509e54a-8299-4a21-be60-1bebf9d04c48') -- rendering providers
BEGIN
DELETE from ListUserDefinedControl where UserDefinedControlUid = '4509e54a-8299-4a21-be60-1bebf9d04c48'
END
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid in ('4509e54a-8299-4a21-be60-1bebf9d04c48','C349E277-EC3A-4028-8A38-D63BB3373322')) -- visit providers
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('c349e277-ec3a-4028-8a38-d63bb3373322','ProviderUid',0,'Visit Providers','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>RenderingProviderUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Provider</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewProvider</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','e9ec0c9f-8add-4b64-9090-427cd5608e12',3,0,0,'11/20/2022 6:00:00 PM')
END
GO
UPDATE ListUserDefinedControl 
set UserDefined=0
,LastModifiedByUid=null
,LastModifiedDate='2022-11-21 00:00:00.000'
where UserDefinedControlGroupUid='E9EC0C9F-8ADD-4B64-9090-427CD5608E12'

UPDATE ListUserDefinedControl 
set SortOrder='7'
where UserDefinedControluid='C4AC71C1-92D6-4B86-BF65-5DAA76AF5FA9' -- Exclude Patient Statuses

UPDATE ListUserDefinedControl 
set SortOrder='8'
where UserDefinedControluid='4D948E37-45EA-4FA7-821B-1C227ED86C0E' -- Exclude Patient Conditions

UPDATE ListUserDefinedControl 
set SortOrder='9'
where UserDefinedControluid='656A6440-91B1-4614-813B-B53C3EE51F25' -- Exclude Patient Programs

UPDATE ListUserDefinedControl 
set SortOrder='10'
where UserDefinedControluid='C3FC00BB-8955-4EA1-AAD6-65511F59A7CF' -- Include Inactive Patients

UPDATE ListUserDefinedControl 
set SortOrder='11'
where UserDefinedControluid='C104AC69-244B-4292-B27D-2553D2ACDCC2' -- Include Deceased Patients

UPDATE ListUserDefinedControl 
set SortOrder='12'
where UserDefinedControluid='888AC67A-489A-4C08-91C6-F72176A8F7ED'; -- Exclude PHI

UPDATE ListReport 
set Modifier=5 
where reportuid = 'C75F2800-978E-4593-B63F-551BF2866B88'

UPDATE ListReportRdl 
SET ReportFormat='Report' 
where ReportRdlUid = 'B95B566A-6753-41B8-9B99-4DDBD2C266E8'
GO

-- #116678 _InsurancePlanDetail_Update_Migration.sql
update ListUserDefinedControl
set label='Plan Name First Character From' -- Plan Name End Character
where UserDefinedControlUid='42919FB2-F60D-412F-8519-87A00A274081';

update ListUserDefinedControl
set label='Plan Name First Character To' -- Plan Name Start Character
where UserDefinedControlUid='3CC74788-5573-4381-95C2-8E33EA51F87C';
GO

-- #116185 Update ListUserDefinedControl Appointments CDS Report Group Migration.sql
--20221206 zfernandez story 116185 update appointment and clinical decision support summary report  add financial center filter
--delete ListUserDefinedControls for Appointments CDS Report Group
IF EXISTS (
	SELECT UserDefinedControlGroupUid 
	FROM ListUserDefinedControl
	WHERE UserDefinedControlGroupUid = 
		'4774ed5f-117a-4bd6-9dc4-ac7b1c01279d' -- Appointment CDS Report
	)
BEGIN
	DELETE
	FROM ListUserDefinedControl
	WHERE UserDefinedControlGroupUid = 
		'4774ed5f-117a-4bd6-9dc4-ac7b1c01279d' -- Appointment CDS Report
END
GO

--SortOrder 0
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'1f91f432-8262-4999-9c84-0b18594a0f36'
	,'Sortby'
	,0
	,'Sort by'
	,'8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
	,'<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>Sortby</Name><ButtonLabel>Patient</ButtonLabel><ButtonValue>Patient</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>Sortby</Name><ButtonLabel>Calendar</ButtonLabel><ButtonValue>Calendar</ButtonValue><Default>false</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>Sortby</Name><ButtonLabel>Provider</ButtonLabel><ButtonValue>Provider</ButtonValue><Default>false</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>Sortby</Name><ButtonLabel>Date</ButtonLabel><ButtonValue>Date</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
	,'4774ed5f-117a-4bd6-9dc4-ac7b1c01279d'
	,10
	,0
	,0
	,'12/05/2022 0:00:00 AM'
	)

--SortOrder 1
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'6ffe910d-4230-4f16-bad6-0da0423647ea'
	,'PatientUID'
	,0
	,'Patient'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>PatientUID</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Patient</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewFindPatient</FindTableName></Control></UserDefinedControls>'
	,'4774ed5f-117a-4bd6-9dc4-ac7b1c01279d'
	,0
	,0
	,0
	,'12/05/2022 0:00:00 AM'
	)

--SortOrder 2
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'eca13add-f549-4251-bf12-5f94893cf9fd'
	,'ProviderUID'
	,0
	,'Provider'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProviderUID</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Provider</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewProvider</FindTableName></Control></UserDefinedControls>'
	,'4774ed5f-117a-4bd6-9dc4-ac7b1c01279d'
	,2
	,0
	,0
	,'12/05/2022 0:00:00 AM'
	)

--SortOrder 3
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'72540fcd-a056-4ee6-9610-60d16289307a'
	,'FromTimeOption'
	,0
	,'From Time Option'
	,'8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
	,'<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>FromTimeOption</Name><ButtonLabel>AM</ButtonLabel><ButtonValue>AM</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>FromTimeOption</Name><ButtonLabel>PM</ButtonLabel><ButtonValue>PM</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
	,'4774ed5f-117a-4bd6-9dc4-ac7b1c01279d'
	,11
	,0
	,0
	,'12/05/2022 0:00:00 AM'
	)

--SortOrder 4
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'b8b370ca-f450-4f82-8eea-78010139bee3'
	,'AppointmentTypeUID'
	,0
	,'Appointment Type'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>AppointmentTypeUID</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Appointment Type</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListAppointmentType</FindTableName></Control></UserDefinedControls>'
	,'4774ed5f-117a-4bd6-9dc4-ac7b1c01279d'
	,5
	,0
	,0
	,'12/05/2022 0:00:00 AM'
	)

--SortOrder 5
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'3060738d-e220-48d7-b9a9-7c07650c1570'
	,'ProviderOption'
	,0
	,'Provider Option'
	,'8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
	,'<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Billing Provider</ButtonLabel><ButtonValue>BillingProvider</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Rendering Provider</ButtonLabel><ButtonValue>RenderingProvider</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
	,'4774ed5f-117a-4bd6-9dc4-ac7b1c01279d'
	,3
	,0
	,0
	,'12/05/2022 0:00:00 AM'
	)

--SortOrder 6
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'73cfdb89-a47a-456d-9042-908638ff4ec8'
	,'FinancialCenterUid'
	,0
	,'Financial Centers'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>FinancialCenterUid</Name><SelectType>Multi</SelectType><Conjunction>or</Conjunction><EntryNameInFindTable>Financial Center</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>FinancialCenter</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	,'4774ed5f-117a-4bd6-9dc4-ac7b1c01279d'
	,7
	,0
	,0
	,'12/05/2022 0:00:00 AM'
	)

--SortOrder 7
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'cd2dcdc5-0f09-434b-a6bd-91b0f68dc53b'
	,'FromTime'
	,0
	,'From Time'
	,'68cbe02c-d310-44ac-ae8d-faf93ce4d64b'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>NUMERIC</ControlType><Name>FromTime</Name><MinValue>1</MinValue><MaxValue>12</MaxValue><DefaultValue>12</DefaultValue><DecimalPlaces>0</DecimalPlaces></Control></UserDefinedControls>'
	,'4774ed5f-117a-4bd6-9dc4-ac7b1c01279d'
	,9
	,0
	,0
	,'12/05/2022 0:00:00 AM'
	)

--SortOrder 8
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'eaa92d7a-afcb-4bb0-8753-92b2888876b9'
	,'AppointmentStatusUID'
	,0
	,'Appointment Status'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>AppointmentStatusUID</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Appointment Status</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListAppointmentStatus</FindTableName></Control></UserDefinedControls>'
	,'4774ed5f-117a-4bd6-9dc4-ac7b1c01279d'
	,6
	,0
	,0
	,'12/05/2022 0:00:00 AM'
	)

--SortOrder 9
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'24ccdb8c-100e-436b-a5be-978cf7eaf083'
	,'ToTime'
	,0
	,'To Time'
	,'68cbe02c-d310-44ac-ae8d-faf93ce4d64b'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>NUMERIC</ControlType><Name>ToTime</Name><MinValue>1</MinValue><MaxValue>12</MaxValue><DefaultValue>12</DefaultValue><DecimalPlaces>0</DecimalPlaces></Control></UserDefinedControls>'
	,'4774ed5f-117a-4bd6-9dc4-ac7b1c01279d'
	,12
	,0
	,0
	,'12/05/2022 0:00:00 AM'
	)

--SortOrder 10
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'f5161a6d-55c4-4398-b7c5-a81d216e89bd'
	,'ServiceSiteUID'
	,0
	,'Service Site'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ServiceSiteUID</Name><SelectType>Multi</SelectType><Conjunction>or</Conjunction><EntryNameInFindTable>Service Site</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListServiceSite</FindTableName></Control></UserDefinedControls>'
	,'4774ed5f-117a-4bd6-9dc4-ac7b1c01279d'
	,8
	,0
	,0
	,'12/05/2022 0:00:00 AM'
	)

--SortOrder 11
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'46b589ec-7347-4b61-8c45-afd88ca45670'
	,'CalendarUID'
	,0
	,'Calendar'
	,'8a957d7c-8b86-4a67-8336-b830c30fd123'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>CalendarUID</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Calendar</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListCalendar</FindTableName></Control></UserDefinedControls>'
	,'4774ed5f-117a-4bd6-9dc4-ac7b1c01279d'
	,1
	,0
	,0
	,'12/05/2022 0:00:00 AM'
	)

--SortOrder 12
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'ede948ba-7aac-435d-896a-d09997e5b006'
	,'ToTimeOption'
	,0
	,'To Time Option'
	,'8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
	,'<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ToTimeOption</Name><ButtonLabel>AM</ButtonLabel><ButtonValue>AM</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ToTimeOption</Name><ButtonLabel>PM</ButtonLabel><ButtonValue>PM</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
	,'4774ed5f-117a-4bd6-9dc4-ac7b1c01279d'
	,13
	,0
	,0
	,'12/05/2022 0:00:00 AM'
	)

--SortOrder 13
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	,[Name]
	,[Inactive]
	,[Label]
	,[ControlTypeUid]
	,[ControlProperties]
	,[UserDefinedControlGroupUid]
	,[SortOrder]
	,[UserDefined]
	,[RDLDesigner]
	,[LastModifiedDate]
	)
VALUES (
	'ecdf9832-8336-4b49-9aba-ee694a729919'
	,'AppTimespan'
	,0
	,'Appointment Date'
	,'df87d0d5-bf48-49fb-abbc-cb75cc29eb64'
	,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>AppTimespan</Name><Uid>f2e52f89-7f2c-466a-a878-459f82fa12c9</Uid></Control></UserDefinedControls>'
	,'4774ed5f-117a-4bd6-9dc4-ac7b1c01279d'
	,4
	,0
	,0
	,'12/05/2022 0:00:00 AM'
	)
GO
-- #116185 end	
	
-- #117727 Update ListUserDefinedControl Payments By Payer Migration.sql
--20221212 zfernandez story 117727 Application Error when Viewing PM Financial Analysis Report(s):
IF  EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '723A0355-99F9-42EC-974E-86414921B2E0')
BEGIN
delete from ListUserDefinedControl where UserDefinedControlUid = '723A0355-99F9-42EC-974E-86414921B2E0'
END
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '723A0355-99F9-42EC-974E-86414921B2E0')
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('723a0355-99f9-42ec-974e-86414921b2e0','PayerUid',0,'Payers','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>Payer</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Person/Corporation</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewPersonCorporation</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','debda9f5-2344-4a07-99e9-0d346afc289d',4,0,0,'12/11/2022 6:00:00 PM')
END
GO 

-- #104918 104918 Update ListUserDefinedControl EDIClaimFiles.sql
-- 20221221 zfernandez story 104918 EDI Claim Files report - Enhancements
-- Reorder control order to match RDL
UPDATE ListUserDefinedControl
SET SortOrder = 0
WHERE UserDefinedControlUid = '265C2674-771A-4ACB-8526-69480A4AC575'

UPDATE ListUserDefinedControl
SET SortOrder = 1
WHERE UserDefinedControlUid = 'F2D32C09-A383-4D44-84B8-8A7D7CF43747'

UPDATE ListUserDefinedControl
SET SortOrder = 2
WHERE UserDefinedControlUid = '1001F589-5ECD-4354-BFD3-CC04F0DF1965'

UPDATE ListUserDefinedControl
SET UserDefined = 0
	,LastModifiedByUid = NULL
	,LastModifiedDate = '12/21/2022'
WHERE UserDefinedControlGroupUid = '590B6706-B754-40B8-8892-7A8F494B6044'
GO


-- #117586 Update ListUserDefinedControl AppointmentCDS.sql
--20221227 zfernandez story 117586 appointment and CDS report, clean up parameter order, Add Financial Center to Filter/Header
UPDATE ListUserDefinedControl
SET Label = 'Appointment Dates'
	,ControlProperties = '<?xml version="1.0" encoding="utf-8"?>
<UserDefinedControls>
	<Control>
		<ControlType>TIMESPAN</ControlType>
		<Name>AppTimespan</Name>
		<Uid>f2e52f89-7f2c-466a-a878-459f82fa12c9</Uid>
		<Required>TRUE</Required>
	</Control>
</UserDefinedControls>'
	,SortOrder = 0
	,UserDefined = 0
	,LastModifiedByUid = NULL
	,LastModifiedDate = '12/27/2022'
WHERE UserDefinedControlUid = 'ECDF9832-8336-4B49-9ABA-EE694A729919'

UPDATE ListUserDefinedControl
SET Label = 'Calendars'
	,SortOrder = 1
	,UserDefined = 0
	,LastModifiedByUid = NULL
	,LastModifiedDate = '12/27/2022'
WHERE UserDefinedControlUid = '46B589EC-7347-4B61-8C45-AFD88CA45670'

UPDATE ListUserDefinedControl
SET Label = 'Providers'
	,SortOrder = 2
	,UserDefined = 0
	,LastModifiedByUid = NULL
	,LastModifiedDate = '12/27/2022'
WHERE UserDefinedControlUid = 'ECA13ADD-F549-4251-BF12-5F94893CF9FD'

UPDATE ListUserDefinedControl
-- Provider Option
SET SortOrder = 3
	,UserDefined = 0
	,LastModifiedByUid = NULL
	,LastModifiedDate = '12/27/2022'
WHERE UserDefinedControlUid = '3060738D-E220-48D7-B9A9-7C07650C1570'

UPDATE ListUserDefinedControl
-- Financial Centers
SET SortOrder = 4
	,UserDefined = 0
	,LastModifiedByUid = NULL
	,LastModifiedDate = '12/27/2022'
WHERE UserDefinedControlUid = '73CFDB89-A47A-456D-9042-908638FF4EC8'

UPDATE ListUserDefinedControl
SET Label = 'Service Sites'
	,SortOrder = 5
	,UserDefined = 0
	,LastModifiedByUid = NULL
	,LastModifiedDate = '12/27/2022'
WHERE UserDefinedControlUid = 'F5161A6D-55C4-4398-B7C5-A81D216E89BD'

UPDATE ListUserDefinedControl
SET Label = 'Patients'
	,SortOrder = 6
	,UserDefined = 0
	,LastModifiedByUid = NULL
	,LastModifiedDate = '12/27/2022'
WHERE UserDefinedControlUid = '6FFE910D-4230-4F16-BAD6-0DA0423647EA'

UPDATE ListUserDefinedControl
SET Label = 'Appointment Types'
	,SortOrder = 7
	,UserDefined = 0
	,LastModifiedByUid = NULL
	,LastModifiedDate = '12/27/2022'
WHERE UserDefinedControlUid = 'B8B370CA-F450-4F82-8EEA-78010139BEE3'

UPDATE ListUserDefinedControl
SET Label = 'Appointment Statuses'
	,SortOrder = 8
	,UserDefined = 0
	,LastModifiedByUid = NULL
	,LastModifiedDate = '12/27/2022'
WHERE UserDefinedControlUid = 'EAA92D7A-AFCB-4BB0-8753-92B2888876B9'

UPDATE ListUserDefinedControl
-- Sort By
SET SortOrder = 9
	,UserDefined = 0
	,LastModifiedByUid = NULL
	,LastModifiedDate = '12/27/2022'
WHERE UserDefinedControlUid = '1F91F432-8262-4999-9C84-0B18594A0F36'

UPDATE ListUserDefinedControl
-- Sort By
SET SortOrder = 10
	,UserDefined = 0
	,LastModifiedByUid = NULL
	,LastModifiedDate = '12/27/2022'
WHERE UserDefinedControlUid = 'CD2DCDC5-0F09-434B-A6BD-91B0F68DC53B'
GO
-- #117586 end


-- #101787 zfernandez story 101751 New Report - Revenue Forecast
IF EXISTS (
	SELECT UserDefinedControlGroupUid 
	FROM ListUserDefinedControl
	WHERE UserDefinedControlGroupUid = 
		'F9D5AE32-65E6-4BB4-9A17-3AD3D90BE342' -- Amount Allowed Summary
	)
BEGIN
	DELETE
	FROM ListUserDefinedControl
	WHERE UserDefinedControlGroupUid = 
		'F9D5AE32-65E6-4BB4-9A17-3AD3D90BE342' -- Amount Allowed Summary
END
GO

--Sort Order 0
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '71351AF2-BD8D-46D6-B64D-8E815A10D108')
BEGIN
	INSERT INTO ListUserDefinedControl
		(
			UserDefinedControlUid
			,Name
			,ExternalID
			,Notes
			,Inactive
			,Label
			,ControlTypeUid
			,ControlProperties
			,UserDefinedControlGroupUid
			,SortOrder
			,UserDefined
			,RDLDesigner
			,LastModifiedByUid
			,LastModifiedDate
		)
	VALUES
		(
			'71351AF2-BD8D-46D6-B64D-8E815A10D108'
			,'AmountAllowedScheduleUid'
			,NULL
			,NULL
			,0
			,'Amount Allowed Schedule'
			,'8A957D7C-8B86-4A67-8336-B830C30FD123'
			,'<?xml version="1.0" encoding="utf-8"?>
<UserDefinedControls>
	<Control>
		<ControlType>FIND</ControlType>
		<Name>AmountAllowedScheduleUid</Name>
		<SelectType>Multi</SelectType>
		<Conjunction>and</Conjunction>
		<EntryNameInFindTable>Amount Allowed Schedule</EntryNameInFindTable>
		<ColumnName>Name</ColumnName>
		<ControlContextKey>Name</ControlContextKey>
		<FindTableName>AmountAllowSchedule</FindTableName>
	</Control>
</UserDefinedControls>'
			,'F9D5AE32-65E6-4BB4-9A17-3AD3D90BE342'
			,0
			,0
			,0
			,NULL
			,'2023-01-20'
		)
END
GO

--Sort Order 1
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'F0B584D7-65BA-4EBE-AB22-43BC03B0BC37')
BEGIN
	INSERT INTO ListUserDefinedControl
		(
			UserDefinedControlUid
			,Name
			,ExternalID
			,Notes
			,Inactive
			,Label
			,ControlTypeUid
			,ControlProperties
			,UserDefinedControlGroupUid
			,SortOrder
			,UserDefined
			,RDLDesigner
			,LastModifiedByUid
			,LastModifiedDate
		)
	VALUES
		(
			'F0B584D7-65BA-4EBE-AB22-43BC03B0BC37'
			,'ProviderUid'
			,NULL
			,NULL
			,0
			,'Provider'
			,'8A957D7C-8B86-4A67-8336-B830C30FD123'
			,'<?xml version="1.0" encoding="utf-8"?>
<UserDefinedControls>
	<Control>
		<ControlType>FIND</ControlType>
		<Name>ProviderUid</Name>
		<SelectType>Multi</SelectType>
		<Conjunction>and</Conjunction>
		<EntryNameInFindTable>Provider</EntryNameInFindTable>
		<ColumnName>Name</ColumnName>
		<ControlContextKey>Name</ControlContextKey>
		<FindTableName>ViewProvider</FindTableName>
	</Control>
</UserDefinedControls>'
			,'F9D5AE32-65E6-4BB4-9A17-3AD3D90BE342'
			,1
			,0
			,0
			,NULL
			,'2023-01-20'
		)
END
GO

--Sort Order 2
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '2F345693-6E7A-4AAA-8574-95B6345C44BD')
BEGIN
	INSERT INTO ListUserDefinedControl
		(
			UserDefinedControlUid
			,Name
			,ExternalID
			,Notes
			,Inactive
			,Label
			,ControlTypeUid
			,ControlProperties
			,UserDefinedControlGroupUid
			,SortOrder
			,UserDefined
			,RDLDesigner
			,LastModifiedByUid
			,LastModifiedDate
		)
	VALUES
		(
			'2F345693-6E7A-4AAA-8574-95B6345C44BD'
			,'ProviderOption'
			,NULL
			,NULL
			,0
			,'Provider Option'
			,'8E4C7B83-2EF4-4C5C-AB00-9F2564CD0B97'
			,'<?xml version="1.0" encoding="utf-8"?>
<UserDefinedControls>
	<Controls>
		<Control>
			<ControlType>RADIOBUTTON</ControlType>
			<Name>ProviderOption</Name>
			<ButtonLabel>Rendering Provider</ButtonLabel>
			<ButtonValue>Rendering</ButtonValue>
			<Default>false</Default>
		</Control>
		<Control>
			<ControlType>RADIOBUTTON</ControlType>
			<Name>ProviderOption</Name>
			<ButtonLabel>Billing Provider</ButtonLabel>
			<ButtonValue>Billing</ButtonValue>
			<Default>true</Default>
		</Control>
	</Controls>
</UserDefinedControls>'
			,'F9D5AE32-65E6-4BB4-9A17-3AD3D90BE342'
			,2
			,0
			,0
			,NULL
			,'2023-01-20'
		)
END
GO

--Sort Order 3
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'C450BC49-6FEF-4183-B401-5AF41EA35DC3')
BEGIN
	INSERT INTO ListUserDefinedControl
		(
			UserDefinedControlUid
			,Name
			,ExternalID
			,Notes
			,Inactive
			,Label
			,ControlTypeUid
			,ControlProperties
			,UserDefinedControlGroupUid
			,SortOrder
			,UserDefined
			,RDLDesigner
			,LastModifiedByUid
			,LastModifiedDate
		)
	VALUES
		(
			'C450BC49-6FEF-4183-B401-5AF41EA35DC3'
			,'FinancialCenterUid'
			,NULL
			,NULL
			,0
			,'Financial Centers'
			,'8A957D7C-8B86-4A67-8336-B830C30FD123'
			,'<?xml version="1.0" encoding="utf-8"?>
<UserDefinedControls>
	<Control>
		<ControlType>FIND</ControlType>
		<Name>FinancialCenterUid</Name>
		<SelectType>Multi</SelectType>
		<Conjunction>and</Conjunction>
		<EntryNameInFindTable>Financial Center</EntryNameInFindTable>
		<ColumnName>Name</ColumnName>
		<ControlContextKey>Name</ControlContextKey>
		<FindTableName>FinancialCenter</FindTableName>
		<Required>FALSE</Required>
	</Control>
</UserDefinedControls>'
			,'F9D5AE32-65E6-4BB4-9A17-3AD3D90BE342'
			,3
			,0
			,0
			,NULL
			,'2023-01-20'
		)
END
GO

--Sort Order 4
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '75D20203-D61C-4708-A8BC-304B1BE98D50')
BEGIN
	INSERT INTO ListUserDefinedControl
		(
			UserDefinedControlUid
			,Name
			,ExternalID
			,Notes
			,Inactive
			,Label
			,ControlTypeUid
			,ControlProperties
			,UserDefinedControlGroupUid
			,SortOrder
			,UserDefined
			,RDLDesigner
			,LastModifiedByUid
			,LastModifiedDate
		)
	VALUES
		(
			'75D20203-D61C-4708-A8BC-304B1BE98D50'
			,'ServiceSiteUid'
			,NULL	
			,NULL	
			,0	
			,'Service Sites'
			,'8A957D7C-8B86-4A67-8336-B830C30FD123'
			,'<?xml version="1.0" encoding="utf-8"?>
<UserDefinedControls>
	<Control>
		<ControlType>FIND</ControlType>
		<Name>ServiceSiteUid</Name>
		<SelectType>Multi</SelectType>
		<Conjunction>and</Conjunction>
		<EntryNameInFindTable>Service Site</EntryNameInFindTable>
		<ColumnName>Name</ColumnName>
		<ControlContextKey>Name</ControlContextKey>
		<FindTableName>ListServiceSite</FindTableName>
		<Required>FALSE</Required>
	</Control>
</UserDefinedControls>'
			,'F9D5AE32-65E6-4BB4-9A17-3AD3D90BE342'
			,4
			,0
			,0
			,NULL
			,'2023-01-20'
		)
END
GO

--Sort Order 5
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'F4C29913-D1BF-4E89-A5A9-24744B741C74')
BEGIN
	INSERT INTO ListUserDefinedControl
		(
			UserDefinedControlUid
			,Name
			,ExternalID
			,Notes
			,Inactive
			,Label
			,ControlTypeUid
			,ControlProperties
			,UserDefinedControlGroupUid
			,SortOrder
			,UserDefined
			,RDLDesigner
			,LastModifiedByUid
			,LastModifiedDate
		)
	VALUES
		(
			'F4C29913-D1BF-4E89-A5A9-24744B741C74'
			,'AAS'
			,NULL
			,NULL
			,0	
			,'Service Date'
			,'DF87D0D5-BF48-49FB-ABBC-CB75CC29EB64'
			,'<?xml version="1.0" encoding="utf-8"?>
<UserDefinedControls>
	<Control>
		<ControlType>TIMESPAN</ControlType>
		<Name>AAS</Name>
		<Uid>f2e52f89-7f2c-466a-a878-459f82fa12c9</Uid>
	</Control>
</UserDefinedControls>'
			,'F9D5AE32-65E6-4BB4-9A17-3AD3D90BE342'
			,5
			,0
			,0
			,NULL
			,'2023-01-20'
		)
END
GO

--Sort Order 6
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'B9A98D64-5ECF-4E31-B455-18D0A24D7E49')
BEGIN
	INSERT INTO ListUserDefinedControl
		(
			UserDefinedControlUid
			,Name
			,ExternalID
			,Notes
			,Inactive
			,Label
			,ControlTypeUid
			,ControlProperties
			,UserDefinedControlGroupUid
			,SortOrder
			,UserDefined
			,RDLDesigner
			,LastModifiedByUid
			,LastModifiedDate
		)
	VALUES
		(
			'B9A98D64-5ECF-4E31-B455-18D0A24D7E49'
			,'DateOption'
			,NULL
			,NULL
			,0
			,'Date Option'
			,'8E4C7B83-2EF4-4C5C-AB00-9F2564CD0B97'
			,'<?xml version="1.0" encoding="utf-8"?>
<UserDefinedControls>
	<Controls>
		<Control>
			<ControlType>RADIOBUTTON</ControlType>
			<Name>DateOption</Name>
			<ButtonLabel>Service Date</ButtonLabel>
			<ButtonValue>Service</ButtonValue>
			<Default>true</Default>
		</Control>
		<Control>
			<ControlType>RADIOBUTTON</ControlType>
			<Name>DateOption</Name>
			<ButtonLabel>Posting Date</ButtonLabel>
			<ButtonValue>Posting</ButtonValue>
			<Default>false</Default>
		</Control>
	</Controls>
</UserDefinedControls>'
			,'F9D5AE32-65E6-4BB4-9A17-3AD3D90BE342'
			,6
			,0
			,0
			,NULL
			,'2023-01-20'
		)
END
GO
-- #101787 end


-- #101751 Update ListUserDefinedControl RevenueForecast.sql
--20230206 zfernandez story 101751 New Report - Revenue Forecast
-- 03/20/23 lc need this row from ListUserDefinedControlGroup 
IF NOT EXISTS (select * from ListUserDefinedControlGroup where UserDefinedControlGroupUid = 'F3DCBB3A-54D7-4F4C-987E-0300699C86E8')
	INSERT INTO ListUserDefinedControlGroup (UserDefinedControlGroupUid, Name, LastModifiedDate)
	VALUES ('F3DCBB3A-54D7-4F4C-987E-0300699C86E8', 'Revenue Forecast', '2023-01-10 00:00:00.000')

IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlGroupUid = 'F3DCBB3A-54D7-4F4C-987E-0300699C86E8')
BEGIN
	delete from ListUserDefinedControl where UserDefinedControlGroupUid = 'F3DCBB3A-54D7-4F4C-987E-0300699C86E8'
END
GO

INSERT INTO ListUserDefinedControl
VALUES
	--Sort Order 0
	(
		'D056CE97-B764-4156-BF8D-928E3CFFF77F'
		,'RevenueForecast'
		,NULL
		,NULL
		,0
		,'Dates'
		,'DF87D0D5-BF48-49FB-ABBC-CB75CC29EB64'
		,'<?xml version="1.0" encoding="utf-8"?>
<UserDefinedControls>
	<Control>
		<ControlType>TIMESPAN</ControlType>
		<Name>RevenueForecast</Name>
		<Uid>f2e52f89-7f2c-466a-a878-459f82fa12c9</Uid>
		<Required>TRUE</Required>
	</Control>
</UserDefinedControls>'
		,'F3DCBB3A-54D7-4F4C-987E-0300699C86E8'
		,0
		,0
		,0
		,NULL
		,'2023-02-06'
	),
	--Sort Order 1
	(
		'58836E6A-99AB-4155-898F-7D64DDF862CF'
		,'DateOption'
		,NULL
		,NULL
		,0
		,'Date Option'
		,'8E4C7B83-2EF4-4C5C-AB00-9F2564CD0B97'
		,'<?xml version="1.0" encoding="utf-8"?>
<UserDefinedControls>
	<Controls>
		<Control>
			<ControlType>RADIOBUTTON</ControlType>
			<Name>DateOption</Name>
			<ButtonLabel>Posting</ButtonLabel>
			<ButtonValue>Posting</ButtonValue>
			<Default>true</Default>
		</Control>
		<Control>
			<ControlType>RADIOBUTTON</ControlType>
			<Name>DateOption</Name>
			<ButtonLabel>Service</ButtonLabel>
			<ButtonValue>Service</ButtonValue>
			<Default>false</Default>
		</Control>
	</Controls>
</UserDefinedControls>'
		,'F3DCBB3A-54D7-4F4C-987E-0300699C86E8'
		,1
		,0
		,0
		,NULL
		,'2023-02-06'
	),
	--Sort Order 2
	(
		'3F2220D2-C802-4C03-8EAD-D58CE42F8D3A'
		,'ProviderUid'
		,NULL
		,NULL
		,0
		,'Providers'
		,'8A957D7C-8B86-4A67-8336-B830C30FD123'
		,'<?xml version="1.0" encoding="utf-8"?>
<UserDefinedControls>
	<Control>
		<ControlType>FIND</ControlType>
		<Name>ProviderUid</Name>
		<SelectType>Multi</SelectType>
		<Conjunction>and</Conjunction>
		<EntryNameInFindTable>Provider</EntryNameInFindTable>
		<ColumnName>Name</ColumnName>
		<ControlContextKey>Name</ControlContextKey>
		<FindTableName>ViewProvider</FindTableName>
		<Required>FALSE</Required>
	</Control>
</UserDefinedControls>'
		,'F3DCBB3A-54D7-4F4C-987E-0300699C86E8'
		,2
		,0
		,0
		,NULL
		,'2023-02-06'
	),
	--Sort Order 3
	(
		'3ABAE984-3851-4B59-AC8E-FAA458F4A5E6'
		,'ProviderOption'
		,NULL
		,NULL
		,0
		,'Provider Option'
		,'8E4C7B83-2EF4-4C5C-AB00-9F2564CD0B97'
		,'<?xml version="1.0" encoding="utf-8"?>
<UserDefinedControls>
	<Controls>
		<Control>
			<ControlType>RADIOBUTTON</ControlType>
			<Name>ProviderOption</Name>
			<ButtonLabel>Billing Provider</ButtonLabel>
			<ButtonValue>Billing Providers</ButtonValue>
			<Default>true</Default>
		</Control>
		<Control>
			<ControlType>RADIOBUTTON</ControlType>
			<Name>ProviderOption</Name>
			<ButtonLabel>Rendering Provider</ButtonLabel>
			<ButtonValue>Rendering Providers</ButtonValue>
			<Default>false</Default>
		</Control>
	</Controls>
</UserDefinedControls>'
		,'F3DCBB3A-54D7-4F4C-987E-0300699C86E8'
		,3
		,0
		,0
		,NULL
		,'2023-02-06'
	),
	--Sort Order 4
	(
		'249C7E11-0B3D-43C2-99E1-823603BC0AAB'
		,'FCUid'
		,NULL
		,NULL
		,0
		,'Financial Centers'
		,'8A957D7C-8B86-4A67-8336-B830C30FD123'
		,'<?xml version="1.0" encoding="utf-8"?>
<UserDefinedControls>
	<Control>
		<ControlType>FIND</ControlType>
		<Name>FCUid</Name>
		<SelectType>Multi</SelectType>
		<Conjunction>and</Conjunction>
		<EntryNameInFindTable>Financial Center</EntryNameInFindTable>
		<ColumnName>Name</ColumnName>
		<ControlContextKey>Name</ControlContextKey>
		<FindTableName>FinancialCenter</FindTableName>
		<Required>FALSE</Required>
	</Control>
</UserDefinedControls>'
		,'F3DCBB3A-54D7-4F4C-987E-0300699C86E8'
		,4
		,0
		,0
		,NULL
		,'2023-02-06'
	),
	--Sort Order 5
	(
		'E86FEA59-BB42-4D77-8C06-7108D1CDB8EC'
		,'ServiceSiteUid'
		,NULL
		,NULL
		,0
		,'Service Sites'
		,'8A957D7C-8B86-4A67-8336-B830C30FD123'
		,'<?xml version="1.0" encoding="utf-8"?>
<UserDefinedControls>
	<Control>
		<ControlType>FIND</ControlType>
		<Name>ServiceSiteUid</Name>
		<SelectType>Multi</SelectType>
		<Conjunction>and</Conjunction>
		<EntryNameInFindTable>Service Site</EntryNameInFindTable>
		<ColumnName>Name</ColumnName>
		<ControlContextKey>Name</ControlContextKey>
		<FindTableName>ListServiceSite</FindTableName>
		<Required>FALSE</Required>
	</Control>
</UserDefinedControls>'
		,'F3DCBB3A-54D7-4F4C-987E-0300699C86E8'
		,5
		,0
		,0
		,NULL
		,'2023-02-06'
	),
	--Sort Order 6
	(
		'3001638E-5778-4220-8D4C-3EB46FC9D0C1'
		,'GroupByUid'
		,NULL
		,NULL
		,0
		,'Group By'
		,'8A957D7C-8B86-4A67-8336-B830C30FD123'
		,'<?xml version="1.0" encoding="utf-8"?>
<UserDefinedControls>
	<Control>
		<ControlType>FIND</ControlType>
		<Name>GroupByUid</Name>
		<SelectType>Single</SelectType>
		<Conjunction>none</Conjunction>
		<EntryNameInFindTable>Account Type Procedure</EntryNameInFindTable>
		<ColumnName>Name</ColumnName>
		<ControlContextKey>Name</ControlContextKey>
		<FindTableName>Account_Type_Procedure</FindTableName>
		<Required>FALSE</Required>
	</Control>
</UserDefinedControls>'
		,'F3DCBB3A-54D7-4F4C-987E-0300699C86E8'
		,6
		,0
		,0
		,NULL
		,'2023-02-06'
	)

GO
-- #101751 end

-- #111550 _InsuranceProductivity_MIGRATION.sql
update ListReport
set Modifier=5
where reportuid='C271C665-6052-43C3-AB35-8B9FFBA744BC';

update ListReportRdl
set ReportFormat='Report'
where ReportRdlUid='E1F4EAEF-F253-4DD0-8F27-486CAC206635';

update ListReportRdl
set ReportFormat='Excel'
where ReportRdlUid='26C7953C-4A6E-4F45-A38A-C4BD60F293D2';
GO

-- #92194 ProcedureCodesAndGroups MIGRATION.sql
UPDATE ListReport
SET Modifier = 5
WHERE ReportUid = '8D3A255C-8B75-4BED-A321-586DAA1A12F9' --Procedure Codes and Groups

UPDATE ListReportRdl
SET ReportFormat = 'Report'
WHERE ReportRdlUid = '84ABFC28-4BD2-429C-B157-D38BFFAC9071' --Procedure Codes And Groups
GO


