ALTER TABLE ListTileType NOCHECK CONSTRAINT ALL
GO
Update olddata
SET
olddata.[Name] = newdata.[Name]
, olddata.[InActive] = (CASE WHEN (newdata.[Inactive] = 1 AND olddata.UserDefined = 0) THEN 1 ELSE olddata.[Inactive] END)
, olddata.[LastModifiedDate] = (CASE WHEN olddata.LastModifiedDate > newdata.LastModifiedDate THEN olddata.LastModifiedDate ELSE newdata.LastModifiedDate END)
FROM migtemp_ListTileType AS newdata
INNER JOIN ListTileType AS olddata ON
newdata.TileTypeUid = olddata.TileTypeUid
GO
INSERT ListTileType
SELECT newdata.*
FROM migtemp_ListTileType AS newdata
LEFT JOIN ListTileType AS olddata ON
newdata.TileTypeUid = olddata.TileTypeUid
WHERE
olddata.TileTypeUid IS NULL
GO
DROP TABLE migtemp_ListTileType
GO
ALTER TABLE ListTileType WITH CHECK CHECK CONSTRAINT ALL
GO
