<?xml version="1.0"?>
<xsl:stylesheet
    version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:msxsl="urn:schemas-microsoft-com:xslt"
    xmlns:user="urn:schemas-imedica.com:prm">
  <xsl:template match="ROOT/Person">
    <xsl:element name="DIV">
      <xsl:attribute name="ID">printDiv</xsl:attribute>
      <xsl:attribute name="name">Survey</xsl:attribute>
      <table border="0" cellpadding="1" cellspacing="0" width="98%" align="center">
        <col width="40%"/>
        <col width="12%"/>
        <col width="12%"/>
        <col width="12%"/>
        <col width="12%"/>
        <col width="12%"/>
        <col width="20"/>
        <col width="0%"/>
        <tr class="insideGreyHeader">
          <td align="left" nowrap="true" valign="top" style="padding-right:15px;">
            <span class="smallHeader">Questionnaire Name</span>
          </td>
          <td align="center" nowrap="true" valign="top" style="padding-right:15px;">
            <span class="smallHeader">Start Date </span>
          </td>
          <td align="center" nowrap="true" valign="top" style="padding-right:15px;">
            <span class="smallHeader">Expiration Date</span>
          </td>
          <td align="center" nowrap="true" valign="top" style="padding-right:15px;">
            <span class="smallHeader">One Time</span>
          </td>
          <td align="center" nowrap="true" valign="top" style="padding-right:15px;">
            <span class="smallHeader">Completed Date</span>
          </td>
          <td align="center" nowrap="true" valign="top">
            <span class="smallHeader">Status</span>
          </td>
          <TD></TD>
          <td></td>
        </tr>
        <xsl:choose>
          <xsl:when test="Patient/RelSurveyPatient/@RelSurveyPatientUid[.!='']">
            <xsl:for-each select="Patient/RelSurveyPatient">
              <tr class="picklist" ID="MyRow" NAME="MyRow" style="cursor:hand">
                <xsl:if test="position() mod 2 = 0">
                  <xsl:attribute name="bgcolor">whitesmoke</xsl:attribute>
                </xsl:if>
                <xsl:if test="position() mod 2 = 1">
                  <xsl:attribute name="bgcolor">white</xsl:attribute>
                </xsl:if>
                <xsl:attribute name="onMouseOver">hiliteRow("picklist","#cccccc");</xsl:attribute>
                <xsl:attribute name="onMouseOut">setTrBgColor(this);</xsl:attribute>
                <td align="left" valign="top">
                  <xsl:attribute name="onClick">
                    if(iMedica.Patient.EditSurvey('<xsl:value-of select="@RelSurveyPatientUid"/>')) init1();
                  </xsl:attribute>
                  <span class="small">
                    <xsl:value-of select="ListSurvey/@Name"/>
                  </span>
                </td>
                <td align="center" nowrap="true" valign="top">
                  <xsl:attribute name="onClick">
                    if(iMedica.Patient.EditSurvey('<xsl:value-of select="@RelSurveyPatientUid"/>')) init1();
                  </xsl:attribute>
                  <span class="small">
                    <xsl:value-of select="user:getStringDate(string(@EffectiveDate))"/>
                  </span>
                </td>
                <td align="center" nowrap="true" valign="top">
                  <xsl:attribute name="onClick">
                    if(iMedica.Patient.EditSurvey('<xsl:value-of select="@RelSurveyPatientUid"/>')) init1();
                  </xsl:attribute>
                  <span class="small">
                    <xsl:value-of select="user:getStringDate(string(@ExpirationDate))"/>
                  </span>
                </td>
                <td align="center" nowrap="true" valign="top">
                  <xsl:attribute name="onClick">
                    if(iMedica.Patient.EditSurvey('<xsl:value-of select="@RelSurveyPatientUid"/>')) init1();
                  </xsl:attribute>
                  <span class="small">
                    <xsl:if test="@OneTime[.='True']">
                      <input type="checkbox" style="text-align:center" disabled="1" checked="1" />
                    </xsl:if>
                    <xsl:if test="@OneTime[.!='True']">
                      <input type="checkbox" style="text-align:center" disabled="1" />
                    </xsl:if>
                  </span>
                </td>
                <td align="center" nowrap="true" valign="top">
                  <xsl:if test="@Completed[.='True']">
                    <xsl:attribute name="onClick">
                      if(iMedica.Patient.ViewSurvey('<xsl:value-of select="@RelSurveyPatientUid"/>')) init1();
                    </xsl:attribute>
                  </xsl:if>
                  <xsl:if test="@Completed[.!='True']">
                    <xsl:attribute name="onClick">
                      if(iMedica.Patient.EditSurvey('<xsl:value-of select="@RelSurveyPatientUid"/>')) init1();
                    </xsl:attribute>
                  </xsl:if>
                  <span class="small" style="text-decoration:underline">
                    <xsl:value-of select="user:getStringDate(string(@CompletionDate))"/>
                  </span>
                </td>
                <td align="center" nowrap="true" valign="top">
                  <span class="small">
                    <xsl:if test="@Imported[.='True']">
                      <xsl:if test="@OneTime[.='True']">
                        Imported/Closed
                      </xsl:if>
                      <xsl:if test="@OneTime[.!='True']">
                        Imported/Open
                      </xsl:if>
                    </xsl:if>
                    <xsl:if test="@Imported[.!='True']">
                      <xsl:if test="@Completed[.='True']">
                        Ready for Import
                      </xsl:if>
                      <xsl:if test="@Completed[.!='True']">
                        Open
                      </xsl:if>
                    </xsl:if>
                  </span>
                </td>
                <TD width="20" valign="top">
                  <button type="button" title="Click here to delete this questionnaire" style="height 10px">
                    <xsl:attribute name="onClick">
                      if (iMedica.Patient.DeleteSurvey('<xsl:value-of select="@RelSurveyPatientUid"/>')) init1();
                    </xsl:attribute>
                    <b>X</b>
                  </button>
                </TD>
                <td width="0" valign="top">
                  <xsl:element name="INPUT">
                    <xsl:attribute name="TYPE">hidden</xsl:attribute>
                    <xsl:attribute name="ID">
                      surveyUUID<xsl:value-of select="UUID"/>
                    </xsl:attribute>
                    <xsl:attribute name="NAME">
                      surveyUUID<xsl:value-of select="UUID"/>
                    </xsl:attribute>
                    <xsl:attribute name="VALUE">
                      <xsl:value-of select="UUID"/>
                    </xsl:attribute>
                  </xsl:element>
                </td>
              </tr>
            </xsl:for-each>
          </xsl:when>
          <xsl:otherwise>
            <tr id="MyRow" name="MyRow" class="picklist" bgcolor="white">
              <td width="598" colspan="6" align="center" nowrap="true" valign="top">
                <span class="hint">(No Questionnaires listed for this patient.)</span>
              </td>
            </tr>
          </xsl:otherwise>
        </xsl:choose>
      </table>
      <br/>
    </xsl:element>
    <table width="98%" align="center" border="0" cellpadding="1" cellspacing="0" style="table-layout: fixed;">
      <tr>
        <td width="90%" valign="top">
          <span class="hint">
            Click on a 'Questionnaire Name' to edit the Questionnaire.
            Click on a 'Completion Date' to view Patient Answers.
            Click '<B>Add</B>' to add a new Questionnaire.
          </span>
        </td>
        <td width="10%" align="right">
          <input id="btnPrintDemographics" type="button" class="blueBtn" value="Add" >
            <xsl:attribute name="onClick">
              if(iMedica.Patient.AddSurvey('<xsl:value-of select="//@PersonUid"/>')) init1();
            </xsl:attribute>
          </input>
        </td>
      </tr>
    </table>

    <br/>
    <br/>
    
    <xsl:choose>
      <xsl:when test="PersonWeb/@PatientWebAccess[.='True']">
        <div style="text-align:center">
          <input type="button" class="blueBtn" value="Reset Web Account" >
            <xsl:attribute name="onClick">
              if(iMedica.Patient.EditPatientWeb('<xsl:value-of select="//@PersonUid"/>')) init1();
            </xsl:attribute>
          </input>          
        </div>
      </xsl:when>
      
      <xsl:when test="PersonWeb/@PatientWebAccess">
        <div style="text-align:center">
          <input type="button" class="blueBtn" value="Activate Web Account" >
            <xsl:attribute name="onClick">
              if(iMedica.Patient.EditPatientWeb('<xsl:value-of select="//@PersonUid"/>')) init1();
            </xsl:attribute>
          </input>          
        </div>
      </xsl:when>
         
      <!--
      <xsl:otherwise>
        <div style="text-align:center">
          <xsl:choose>
            <xsl:when test="(string-length(//@Email1) &gt; 0) or (string-length(//@Email2) &gt; 0)">
              <input type="button" class="blueBtn" value="Create Web Account" >
                <xsl:attribute name="onClick">
                  if(iMedica.Patient.AddPatientWeb('<xsl:value-of select="//@PersonUid"/>')) init1();
                </xsl:attribute>
              </input>
            </xsl:when>
            <xsl:otherwise>
              <input type="button" class="blueBtn" value="Create Web Account" disabled="">
                <xsl:attribute name="onClick">
                  if(iMedica.Patient.AddPatientWeb('<xsl:value-of select="//@PersonUid"/>')) init1();
                </xsl:attribute>
              </input>
              <br/>
              <span style="color:red;font:10pt arial, verdana;">Patient must have an Email address in order to create an account</span>
            </xsl:otherwise>
          </xsl:choose>
        </div>
      </xsl:otherwise>
      -->
            
      <xsl:otherwise>
        <div style="text-align:center">
          <input type="button" class="blueBtn" value="Create Web Account" >
            <xsl:attribute name="onClick">
              if(iMedica.Patient.AddPatientWeb('<xsl:value-of select="//@PersonUid"/>')) init1();
            </xsl:attribute>
          </input>
        </div>
      </xsl:otherwise>
            
    </xsl:choose>

  </xsl:template>
  <msxsl:script language="Jscript" implements-prefix="user">
    <![CDATA[
		function convertXMLDateTimeToJSDateObj(strDate)
		{
			// parse the XML datetime string: yyyy-MM-ddThh:mm:ss
			return new Date(strDate.substring(5,10) + '-' + strDate.substring(0,4) + ' ' + strDate.substring(11,16));
		}

		function convertDateToStringDate(dDate)
		{
			var theMonth = (dDate.getMonth()+1);
			var theDate = dDate.getDate();
			if (theMonth < 10) {
				theMonth = "0" + (theMonth);
			}
			if (theDate < 10) {
				theDate = "0" + theDate;
			}
			var strDate = theMonth + "/" + theDate + "/" + dDate.getFullYear().toString();
			return strDate;
		}

		function getStringDate(sXMLDateTime)
		{
			if (sXMLDateTime != "")
				return convertDateToStringDate(convertXMLDateTimeToJSDateObj(sXMLDateTime));
			return "";
		}

		// Need to add support for .trim() manually
		String.prototype.trim = String_trim;
		function String_trim() {
			//
			// trims spaces from both ends of a string
			if(this.length > 0) {
				var start = 0;
				while(((this.charAt(start)).valueOf() == " ".valueOf()) && (start < this.length)) {
					start++;
				}
				if(start >= this.length) {
					return ""; //string contains spaces only.
				}
				var endstr = this.length - 1;
				while(((this.charAt(endstr)).valueOf() == " ".valueOf()) && (endstr >= 0)) {
					endstr--;
				}
				return this.substring(start,endstr+1);
			}
			else {
			return "" + this;
			}
		}
		]]>
  </msxsl:script>
</xsl:stylesheet>