SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[eRxFormularyDownload]') AND type in (N'U'))
BEGIN
CREATE TABLE [eRxFormularyDownload](
	[eRxFormularyDownloadUid] [uniqueidentifier] NOT NULL,
	[PayorID] [varchar](30) NOT NULL,
	[ListType] [varchar](50) NOT NULL,
	[ListTypeID] [varchar](50) NOT NULL,
	[LastDownloadedDate] [datetime] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[FormularyAlternativesNDC]') AND type in (N'U'))
BEGIN
CREATE TABLE [FormularyAlternativesNDC](
	[FormularyAlternativesNDCUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[FormularyAlternativesOrgUid] [uniqueidentifier] NOT NULL,
	[NDC] [varchar](11) NOT NULL,
	[medid] [int] NOT NULL,
	[Alternative_NDC] [varchar](11) NOT NULL,
	[Alternative_medid] [int] NOT NULL,
	[FormularyProdFormuStatUid] [uniqueidentifier] NOT NULL,
	[ListEffectiveDate] [datetime] NOT NULL,
	[ImportedVersion] [bigint] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[FormularyAlternativesOrg]') AND type in (N'U'))
BEGIN
CREATE TABLE [FormularyAlternativesOrg](
	[FormularyAlternativesOrgUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[FormularyVendorUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[AlternativesID] [varchar](10) NOT NULL,
	[PayorID] [varchar](100) NOT NULL,
	[SourceName] [varchar](35) NOT NULL,
	[UserDefined] [bit] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[Notes] [text] NULL,
	[ListEffectiveDate] [datetime] NOT NULL,
	[LastDownloadedDate] [datetime] NOT NULL,
	[ImportedVersion] [bigint] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[FormularyCopayNDC]') AND type in (N'U'))
BEGIN
CREATE TABLE [FormularyCopayNDC](
	[FormularyCopayNDCUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[FormularyCopayOrgUid] [uniqueidentifier] NOT NULL,
	[NDC] [varchar](11) NOT NULL,
	[medid] [int] NOT NULL,
	[PharmacyType] [varchar](1) NOT NULL,
	[FlatCopayAmount] [varchar](10) NULL,
	[PercentCopayRate] [varchar](10) NULL,
	[FirstCopayTerm] [varchar](1) NULL,
	[MinimumCopay] [varchar](10) NULL,
	[MaximumCopay] [varchar](10) NULL,
	[DaysSupplyPerCopay] [varchar](3) NULL,
	[CopayTier] [varchar](2) NULL,
	[MaximumCopayTier] [varchar](2) NULL,
	[Description] [varchar](max) NULL,
	[ListEffectiveDate] [datetime] NOT NULL,
	[ImportedVersion] [bigint] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[FormularyCopayOrg]') AND type in (N'U'))
BEGIN
CREATE TABLE [FormularyCopayOrg](
	[FormularyCopayOrgUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[FormularyVendorUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[CopayListID] [varchar](10) NOT NULL,
	[CopayID] [varchar](40) NOT NULL,
	[PayorID] [varchar](100) NOT NULL,
	[SourceName] [varchar](35) NOT NULL,
	[UserDefined] [bit] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[ListEffectiveDate] [datetime] NOT NULL,
	[LastDownloadedDate] [datetime] NOT NULL,
	[ImportedVersion] [bigint] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[FormularyCopaySummary]') AND type in (N'U'))
BEGIN
CREATE TABLE [FormularyCopaySummary](
	[FormularyCopaySummaryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[FormularyCopayOrgUid] [uniqueidentifier] NOT NULL,
	[FormularyProdFormuStatUid] [uniqueidentifier] NOT NULL,
	[ProductType] [varchar](1) NOT NULL,
	[PharmacyType] [varchar](1) NOT NULL,
	[OutOfPocketRangeStart] [varchar](10) NULL,
	[OutOfPocketRangeEnd] [varchar](10) NULL,
	[FlatCopayAmount] [varchar](10) NULL,
	[PercentCopayRate] [varchar](10) NULL,
	[FirstCopayTerm] [varchar](1) NULL,
	[MinimumCopay] [varchar](10) NULL,
	[MaximumCopay] [varchar](10) NULL,
	[DaysSupplyPerCopay] [varchar](3) NULL,
	[CopayTier] [varchar](2) NULL,
	[MaximumCopayTier] [varchar](2) NULL,
	[Description] [varchar](max) NULL,
	[ListEffectiveDate] [datetime] NOT NULL,
	[ImportedVersion] [bigint] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[FormularyCoverageNDC]') AND type in (N'U'))
BEGIN
CREATE TABLE [FormularyCoverageNDC](
	[FormularyCoverageNDCUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[FormularyCoverageOrgUid] [uniqueidentifier] NOT NULL,
	[CoverageListType] [varchar](2) NOT NULL,
	[NDC] [varchar](11) NOT NULL,
	[medid] [int] NOT NULL,
	[TextMessageShort] [varchar](100) NOT NULL,
	[TextMessageLong] [varchar](200) NULL,
	[TextMessageType] [varchar](2) NULL,
	[StepNDC] [varchar](11) NULL,
	[StepQualifier] [varchar](2) NULL,
	[Step_medid] [int] NULL,
	[StepClassID] [varchar](5) NULL,
	[StepSubClassID] [varchar](5) NULL,
	[StepNumberOfDrugsToTry] [tinyint] NULL,
	[StepOrder] [varchar](1) NOT NULL,
	[StepDiagnosisCode] [varchar](15) NULL,
	[StepDiagnosisQualifier] [varchar](2) NULL,
	[QuantityMax] [varchar](10) NOT NULL,
	[QuantityMaxQualifier] [varchar](2) NOT NULL,
	[QuantityTimePeriod] [varchar](2) NULL,
	[QuantityStartDate] [datetime] NULL,
	[QuantityEndDate] [datetime] NULL,
	[QuantityUnits] [varchar](4) NULL,
	[AgeMin] [varchar](3) NOT NULL,
	[AgeMinQualifier] [varchar](1) NULL,
	[AgeMax] [varchar](3) NOT NULL,
	[AgeMaxQualifier] [varchar](1) NULL,
	[GenderCode] [varchar](1) NOT NULL,
	[ResourceLinkType] [varchar](2) NULL,
	[URL] [varchar](255) NOT NULL,
	[ListEffectiveDate] [datetime] NOT NULL,
	[FormularyTextMessageUid] [uniqueidentifier] NULL,
	[ImportedVersion] [bigint] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[FormularyCoverageOrg]') AND type in (N'U'))
BEGIN
CREATE TABLE [FormularyCoverageOrg](
	[FormularyCoverageOrgUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[FormularyVendorUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[CoverageListID] [varchar](10) NOT NULL,
	[CoverageID] [varchar](40) NOT NULL,
	[PayorID] [varchar](100) NOT NULL,
	[SourceName] [varchar](35) NOT NULL,
	[UserDefined] [bit] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[ListEffectiveDate] [datetime] NOT NULL,
	[LastDownloadedDate] [datetime] NOT NULL,
	[ImportedVersion] [bigint] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[FormularyCoverageSummary]') AND type in (N'U'))
BEGIN
CREATE TABLE [FormularyCoverageSummary](
	[FormularyCoverageSummaryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[FormularyCoverageOrgUid] [uniqueidentifier] NOT NULL,
	[CoverageListType] [varchar](2) NOT NULL,
	[ResourceLinkType] [varchar](2) NULL,
	[URL] [varchar](255) NOT NULL,
	[ListEffectiveDate] [datetime] NOT NULL,
	[ImportedVersion] [bigint] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[FormularyOrg]') AND type in (N'U'))
BEGIN
CREATE TABLE [FormularyOrg](
	[FormularyOrgUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[Name] [varchar](100) NOT NULL,
	[FormularyIdentifierUid] [uniqueidentifier] NOT NULL,
	[Address1] [varchar](100) NULL,
	[Address2] [varchar](100) NULL,
	[City] [varchar](25) NULL,
	[State] [varchar](3) NULL,
	[Zip] [varchar](10) NULL,
	[Country] [varchar](25) NULL,
	[PhoneNumber] [varchar](22) NULL,
	[FormularyVendorUid] [uniqueidentifier] NOT NULL,
	[UnlistedBrandFormularyStatusUid] [uniqueidentifier] NULL,
	[UnlistedGenericFormularyStatusUid] [uniqueidentifier] NULL,
	[UnlistedBrandOTCFormularyStatusUid] [uniqueidentifier] NULL,
	[UnlistedGenericOTCFormularyStatusUid] [uniqueidentifier] NULL,
	[UnlistedSuppliesFormularyStatusUid] [uniqueidentifier] NULL,
	[RelativeCostLimitFormularyStatusUid] [uniqueidentifier] NULL,
	[LastDownloadedDate] [datetime] NULL,
	[SourceName] [varchar](35) NULL,
	[PayorID] [varchar](100) NULL,
	[FormularyID] [varchar](10) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Notes] [varchar](max) NULL,
	[ImportedVersion] [bigint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[FormularyProductNDC]') AND type in (N'U'))
BEGIN
CREATE TABLE [FormularyProductNDC](
	[FormularyProductNDCUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[FormularyIdentifierUid] [uniqueidentifier] NOT NULL,
	[NDC] [varchar](11) NOT NULL,
	[medid] [int] NOT NULL,
	[FormularyProdFormuStatUid] [uniqueidentifier] NOT NULL,
	[FormularyProdCostIndexUid] [uniqueidentifier] NULL,
	[ListEffectiveDate] [datetime] NOT NULL,
	[ImportedVersion] [bigint] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[FormularyTextMessage]') AND type in (N'U'))
BEGIN
CREATE TABLE [FormularyTextMessage](
	[FormularyTextMessageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[FormularyCoverageOrgUid] [uniqueidentifier] NOT NULL,
	[TextMessageShort] [varchar](100) NOT NULL,
	[TextMessageLong] [varchar](200) NULL,
	[TextMessageType] [varchar](2) NULL,
	[ImportedVersion] [bigint] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ImportFormularyAlternativesNDCQueue]') AND type in (N'U'))
BEGIN
CREATE TABLE [ImportFormularyAlternativesNDCQueue](
	[FormularyAlternativesNDCUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[FormularyAlternativesOrgUid] [uniqueidentifier] NOT NULL,
	[NDC] [varchar](11) NOT NULL,
	[medid] [int] NOT NULL,
	[Alternative_NDC] [varchar](11) NOT NULL,
	[Alternative_medid] [int] NOT NULL,
	[FormularyProdFormuStatUid] [uniqueidentifier] NOT NULL,
	[ListEffectiveDate] [datetime] NOT NULL,
	[ImportedVersion] [bigint] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ImportFormularyCopayNDCQueue]') AND type in (N'U'))
BEGIN
CREATE TABLE [ImportFormularyCopayNDCQueue](
	[FormularyCopayNDCUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[FormularyCopayOrgUid] [uniqueidentifier] NOT NULL,
	[NDC] [varchar](11) NOT NULL,
	[medid] [int] NOT NULL,
	[PharmacyType] [varchar](1) NOT NULL,
	[FlatCopayAmount] [varchar](10) NULL,
	[PercentCopayRate] [varchar](10) NULL,
	[FirstCopayTerm] [varchar](1) NULL,
	[MinimumCopay] [varchar](10) NULL,
	[MaximumCopay] [varchar](10) NULL,
	[DaysSupplyPerCopay] [varchar](3) NULL,
	[CopayTier] [varchar](2) NULL,
	[MaximumCopayTier] [varchar](2) NULL,
	[Description] [varchar](max) NULL,
	[ListEffectiveDate] [datetime] NOT NULL,
	[ImportedVersion] [bigint] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ImportFormularyCopaySummaryQueue]') AND type in (N'U'))
BEGIN
CREATE TABLE [ImportFormularyCopaySummaryQueue](
	[FormularyCopaySummaryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[FormularyCopayOrgUid] [uniqueidentifier] NOT NULL,
	[FormularyProdFormuStatUid] [uniqueidentifier] NOT NULL,
	[ProductType] [varchar](1) NOT NULL,
	[PharmacyType] [varchar](1) NOT NULL,
	[OutOfPocketRangeStart] [varchar](10) NULL,
	[OutOfPocketRangeEnd] [varchar](10) NULL,
	[FlatCopayAmount] [varchar](10) NULL,
	[PercentCopayRate] [varchar](10) NULL,
	[FirstCopayTerm] [varchar](1) NULL,
	[MinimumCopay] [varchar](10) NULL,
	[MaximumCopay] [varchar](10) NULL,
	[DaysSupplyPerCopay] [varchar](3) NULL,
	[CopayTier] [varchar](2) NULL,
	[MaximumCopayTier] [varchar](2) NULL,
	[Description] [varchar](max) NULL,
	[ListEffectiveDate] [datetime] NOT NULL,
	[ImportedVersion] [bigint] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ImportFormularyCoverageNDCQueue]') AND type in (N'U'))
BEGIN
CREATE TABLE [ImportFormularyCoverageNDCQueue](
	[FormularyCoverageNDCUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[FormularyCoverageOrgUid] [uniqueidentifier] NOT NULL,
	[CoverageListType] [varchar](2) NOT NULL,
	[NDC] [varchar](11) NOT NULL,
	[medid] [int] NOT NULL,
	[TextMessageShort] [varchar](100) NOT NULL,
	[TextMessageLong] [varchar](200) NULL,
	[TextMessageType] [varchar](2) NULL,
	[StepNDC] [varchar](11) NULL,
	[StepQualifier] [varchar](2) NULL,
	[Step_medid] [int] NULL,
	[StepClassID] [varchar](5) NULL,
	[StepSubClassID] [varchar](5) NULL,
	[StepNumberOfDrugsToTry] [tinyint] NULL,
	[StepOrder] [varchar](1) NOT NULL,
	[StepDiagnosisCode] [varchar](15) NULL,
	[StepDiagnosisQualifier] [varchar](2) NULL,
	[QuantityMax] [varchar](10) NOT NULL,
	[QuantityMaxQualifier] [varchar](2) NOT NULL,
	[QuantityTimePeriod] [varchar](2) NULL,
	[QuantityStartDate] [datetime] NULL,
	[QuantityEndDate] [datetime] NULL,
	[QuantityUnits] [varchar](4) NULL,
	[AgeMin] [varchar](3) NOT NULL,
	[AgeMinQualifier] [varchar](1) NULL,
	[AgeMax] [varchar](3) NOT NULL,
	[AgeMaxQualifier] [varchar](1) NULL,
	[GenderCode] [varchar](1) NOT NULL,
	[ResourceLinkType] [varchar](2) NULL,
	[URL] [varchar](255) NOT NULL,
	[ListEffectiveDate] [datetime] NOT NULL,
	[FormularyTextMessageUid] [uniqueidentifier] NULL,
	[ImportedVersion] [bigint] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ImportFormularyCoverageSummaryQueue]') AND type in (N'U'))
BEGIN
CREATE TABLE [ImportFormularyCoverageSummaryQueue](
	[FormularyCoverageSummaryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[FormularyCoverageOrgUid] [uniqueidentifier] NOT NULL,
	[CoverageListType] [varchar](2) NOT NULL,
	[ResourceLinkType] [varchar](2) NULL,
	[URL] [varchar](255) NOT NULL,
	[ListEffectiveDate] [datetime] NOT NULL,
	[ImportedVersion] [bigint] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ImportFormularyProductNDCQueue]') AND type in (N'U'))
BEGIN
CREATE TABLE [ImportFormularyProductNDCQueue](
	[FormularyProductNDCUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[FormularyIdentifierUid] [uniqueidentifier] NOT NULL,
	[NDC] [varchar](11) NOT NULL,
	[medid] [int] NOT NULL,
	[FormularyProdFormuStatUid] [uniqueidentifier] NOT NULL,
	[FormularyProdCostIndexUid] [uniqueidentifier] NULL,
	[ListEffectiveDate] [datetime] NOT NULL,
	[ImportedVersion] [bigint] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ImportFormularyTextMessageQueue]') AND type in (N'U'))
BEGIN
CREATE TABLE [ImportFormularyTextMessageQueue](
	[FormularyTextMessageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[FormularyCoverageOrgUid] [uniqueidentifier] NOT NULL,
	[TextMessageShort] [varchar](100) NOT NULL,
	[TextMessageLong] [varchar](200) NULL,
	[TextMessageType] [varchar](2) NULL,
	[ImportedVersion] [bigint] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListFormularyIdentifier]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListFormularyIdentifier](
	[FormularyIdentifierUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[Name] [varchar](100) NOT NULL,
	[FormularyVendorUid] [uniqueidentifier] NOT NULL,
	[LastDownloadedDate] [datetime] NULL,
	[SourceName] [varchar](35) NULL,
	[PayorID] [varchar](100) NULL,
	[FormularyID] [varchar](10) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Notes] [varchar](max) NULL,
	[ImportedVersion] [bigint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListFormularyProdCostIndex]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListFormularyProdCostIndex](
	[FormularyProdCostIndexUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListFormularyProdCostIndex_FormularyProdCostIndexUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListFormularyProdCostIndex_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[FormularyVendorUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListFormularyProdCostIndex_FormularyVendorUid]  DEFAULT ('00000000-0000-0000-0000-000000000001'),
	[RelativeCost] [varchar](2) NULL,
	[RelativeCostSort] [int] NOT NULL CONSTRAINT [DF_ListFormularyProdCostIndex_RelativeCostSort]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListFormularyProdCostIndex_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListFormularyProdCostIndex_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListFormularyProdFormuStat]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListFormularyProdFormuStat](
	[FormularyProdFormuStatUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListFormularyProdFormuStat_FormularyProdFormuStatUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListFormularyProdFormuStat_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[FormularyVendorUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListFormularyProdFormuStat_FormularyVendorUid]  DEFAULT ('00000000-0000-0000-0000-000000000001'),
	[FormularyStatus] [varchar](2) NULL,
	[PreferredSort] [int] NOT NULL CONSTRAINT [DF_ListFormularyProdFormuStat_PreferredSort]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListFormularyProdFormuStat_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListFormularyProdFormuStat_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[ListFormularyVendor]') AND type in (N'U'))
BEGIN
CREATE TABLE [ListFormularyVendor](
	[FormularyVendorUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListFormularyVendor_FormularyVendorUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListFormularyVendor_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[UserDefined] [bit] NOT NULL CONSTRAINT [DF_ListFormularyVendor_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListFormularyVendor_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[VersionCommonFormulary]') AND type in (N'U'))
BEGIN
CREATE TABLE [VersionCommonFormulary](
	[PRMVersion] [varchar](24) NOT NULL,
	[PRMSeq] [int] NOT NULL,
	[PRMBuild] [varchar](24) NULL,
	[ReleaseName] [varchar](50) NULL,
	[Vendor] [varchar](50) NULL,
	[Status] [int] NOT NULL CONSTRAINT [DF_VersionPRM_Status]  DEFAULT ((0)),
	[Message] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_VersionPRM_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_VersionPRM_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
END
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'GenerateEntityObject' , N'SCHEMA',N'dbo', N'TABLE',N'eRxFormularyDownload', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'eRxFormularyDownload'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverReplicate' , N'SCHEMA',N'dbo', N'TABLE',N'eRxFormularyDownload', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'eRxFormularyDownload'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverReplicate' , N'SCHEMA',N'dbo', N'TABLE',N'FormularyAlternativesNDC', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FormularyAlternativesNDC'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverReplicate' , N'SCHEMA',N'dbo', N'TABLE',N'FormularyAlternativesOrg', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FormularyAlternativesOrg'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverReplicate' , N'SCHEMA',N'dbo', N'TABLE',N'FormularyCopayNDC', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FormularyCopayNDC'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverReplicate' , N'SCHEMA',N'dbo', N'TABLE',N'FormularyCopayOrg', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FormularyCopayOrg'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverReplicate' , N'SCHEMA',N'dbo', N'TABLE',N'FormularyCopaySummary', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FormularyCopaySummary'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverReplicate' , N'SCHEMA',N'dbo', N'TABLE',N'FormularyCoverageNDC', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FormularyCoverageNDC'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverReplicate' , N'SCHEMA',N'dbo', N'TABLE',N'FormularyCoverageOrg', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FormularyCoverageOrg'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverReplicate' , N'SCHEMA',N'dbo', N'TABLE',N'FormularyCoverageSummary', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FormularyCoverageSummary'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverReplicate' , N'SCHEMA',N'dbo', N'TABLE',N'FormularyOrg', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FormularyOrg'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverReplicate' , N'SCHEMA',N'dbo', N'TABLE',N'FormularyProductNDC', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FormularyProductNDC'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverReplicate' , N'SCHEMA',N'dbo', N'TABLE',N'FormularyTextMessage', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'FormularyTextMessage'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'GenerateEntityObject' , N'SCHEMA',N'dbo', N'TABLE',N'ImportFormularyAlternativesNDCQueue', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ImportFormularyAlternativesNDCQueue'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'GenerateEntityObject' , N'SCHEMA',N'dbo', N'TABLE',N'ImportFormularyCopayNDCQueue', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ImportFormularyCopayNDCQueue'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'GenerateEntityObject' , N'SCHEMA',N'dbo', N'TABLE',N'ImportFormularyCopaySummaryQueue', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ImportFormularyCopaySummaryQueue'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'GenerateEntityObject' , N'SCHEMA',N'dbo', N'TABLE',N'ImportFormularyCoverageNDCQueue', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ImportFormularyCoverageNDCQueue'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'GenerateEntityObject' , N'SCHEMA',N'dbo', N'TABLE',N'ImportFormularyCoverageSummaryQueue', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ImportFormularyCoverageSummaryQueue'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'GenerateEntityObject' , N'SCHEMA',N'dbo', N'TABLE',N'ImportFormularyProductNDCQueue', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ImportFormularyProductNDCQueue'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'GenerateEntityObject' , N'SCHEMA',N'dbo', N'TABLE',N'ImportFormularyTextMessageQueue', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ImportFormularyTextMessageQueue'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverReplicate' , N'SCHEMA',N'dbo', N'TABLE',N'ListFormularyIdentifier', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFormularyIdentifier'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverReplicate' , N'SCHEMA',N'dbo', N'TABLE',N'ListFormularyProdCostIndex', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFormularyProdCostIndex'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverReplicate' , N'SCHEMA',N'dbo', N'TABLE',N'ListFormularyProdFormuStat', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFormularyProdFormuStat'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverReplicate' , N'SCHEMA',N'dbo', N'TABLE',N'ListFormularyVendor', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFormularyVendor'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'VersionCommonFormulary', N'COLUMN',N'PRMVersion'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'3 digit version number, e.g., 5.0.0' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VersionCommonFormulary', @level2type=N'COLUMN',@level2name=N'PRMVersion'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'VersionCommonFormulary', N'COLUMN',N'PRMSeq'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'sequence number under Version. ' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VersionCommonFormulary', @level2type=N'COLUMN',@level2name=N'PRMSeq'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'VersionCommonFormulary', N'COLUMN',N'PRMBuild'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'YYYYMMDD format. Optional info for the build.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VersionCommonFormulary', @level2type=N'COLUMN',@level2name=N'PRMBuild'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'GenerateEntityObject' , N'SCHEMA',N'dbo', N'TABLE',N'VersionCommonFormulary', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VersionCommonFormulary'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverReplicate' , N'SCHEMA',N'dbo', N'TABLE',N'VersionCommonFormulary', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VersionCommonFormulary'
GO

