SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ConvertToBytesCommon]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[ConvertToBytesCommon](@input varchar(50)) RETURNS BIGINT AS
BEGIN
	IF SUBSTRING(@input, DATALENGTH(@input) - 1, 2) = ''KB''
		RETURN convert(BIGINT, SUBSTRING(@input, 0, DATALENGTH(@input) - 2)) * 1024
	
	RETURN convert(BIGINT, SUBSTRING(@input, 0, DATALENGTH(@input) - 2)) * 1024 * 1024
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IMO_BuildModifierCodeList]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[IMO_BuildModifierCodeList]
(
	@icd10 VARCHAR(10),
	@provideTempTable BIT = 0
)
RETURNS VARCHAR(MAX)
AS
BEGIN

	DECLARE @listStr VARCHAR(MAX)

	IF (@provideTempTable=0)
		SELECT @listStr = COALESCE(@listStr+'','' , '''') + CAST(SL.ICD_MODIFIER_IMO_CODE AS VARCHAR(MAX))
			FROM (SELECT DISTINCT ICD_MODIFIER_IMO_CODE 
				FROM IMO_TEMP_MODIFIER
				WHERE ICD_BASE_TEXT_CODE = @icd10) SL;
	ELSE
		SELECT @listStr = COALESCE(@listStr+'','' , '''') + CAST(SL.ICD_MODIFIER_IMO_CODE AS VARCHAR(MAX))
			FROM (SELECT DISTINCT MM.ICD_MODIFIER_IMO_CODE 
				FROM IMO_ICD ICD
					INNER JOIN IMO_ICD_MODIFIER_MAP MM ON ICD.ICD_IMO_CODE = MM.ICD_IMO_CODE
				WHERE ICD.ICD_BASE_TEXT_CODE = @icd10) SL;
	RETURN @listStr;

END

/*

*/













' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IMO_BuildSnoMedCodeList]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[IMO_BuildSnoMedCodeList]
(
	@icd10 VARCHAR(10)
)
RETURNS VARCHAR(MAX)
AS
BEGIN
	DECLARE @listStr VARCHAR(MAX)
	SELECT @listStr = COALESCE(@listStr+'','' , '''') + CAST(SL.SCT_CONCEPT_ID AS VARCHAR(MAX))
		FROM (SELECT DISTINCT TOP 100 PREF_LEXICALS_TEXT_IMO_FLAG, SCT_CONCEPT_ID 
					FROM IMO_TEMP_SNOMED WITH (NOLOCK)
					WHERE ICD_BASE_TEXT_CODE = @icd10 
					ORDER BY PREF_LEXICALS_TEXT_IMO_FLAG DESC, SCT_CONCEPT_ID) SL;
	-- Need SubQuery to get them in order and TOP to allow the ORDER in SubQuery
	RETURN @listStr;

END












' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IMO_StripToNextRoot]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[IMO_StripToNextRoot]
(
	@icd10Child VARCHAR(10)
)
RETURNS VARCHAR(MAX)
AS
BEGIN

	IF (ISNULL(@icd10Child,'''') = '''') 
		RETURN '''';

	IF (CHARINDEX(''.'', @icd10Child)=0) -- no . no need to strip
		RETURN @icd10Child;

	-- now we know we at least have S52.1 - or longer ... rule is it never comes in with a lagging dot

	DECLARE @tempString VARCHAR(MAX) = '''';
	SELECT @tempString = SUBSTRING(@icd10Child,0,LEN(@icd10Child));
	IF (SUBSTRING(@tempString,LEN(@tempString),1)=''.'')
		SELECT @tempString = SUBSTRING(@tempString,0,LEN(@tempString));
	RETURN @tempString;

END

/*
BEGIN

SELECT dbo.StripToNextRoot(''S53'');

END
*/










' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_CreateSearchDescription]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 08/01/2018
-- Description:	Returns a search description string.
-- =================================================================
CREATE FUNCTION [dbo].[NDD_CreateSearchDescription](
              @description varchar(255)
              )
RETURNS varchar(255)
AS
begin
	declare @searchDesc varchar(255) = ''''
	declare @i int = 1
	declare @char varchar(1)
	declare @spaceLastCharacter bit = 0

	while (@i <= LEN(@description))
	begin
		set @char = SUBSTRING(@description, @i, 1)
		if (@char NOT IN(''.'', '''''''', ''"'', ''%'', ''#'', ''!''))
		begin
			if ((PATINDEX(''[A-Za-z]%'', @char) > 0)
				OR (PATINDEX(''[0-9]%'', @char) > 0))
			begin
				set @searchDesc = @searchDesc + UPPER(@char)
				set @spaceLastCharacter = 0
			end
			else begin
				if (@spaceLastCharacter = 0)
					set @searchDesc = @searchDesc + '' ''
				set @spaceLastCharacter = 1
			end
		end

		set @i = @i + 1
	end

	return RTRIM(LTRIM(@searchDesc))
end
' 
END

GO

