-- #152924 -Dpn-ReferralOwner.sql
DECLARE @dpn TABLE(DpnGroupUid UNIQUEIDENTIFIER NOT NULL PRIMARY KEY, RelDpnGroupDpnNodeUid UNIQUEIDENTIFIER NOT NULL DEFAULT(NEWID()))
-- get list of DPNs that need to be updated with a referral owner node
INSERT INTO @dpn(DpnGroupUid)
SELECT dpn.DpnGroupUid
FROM ListDpnGroup dpn
INNER JOIN RelDpnGroupOrderAction act on act.DpnGroupUid = dpn.DpnGroupUid
WHERE act.ProductParameterUid = 'A336390A-5C72-4CA5-A9F6-40EE9A741CCE'
  AND dpn.UserDefined = 1
  AND NOT EXISTS(
   SELECT *
   FROM RelDpnGroupDpnNode rel
   WHERE rel.DpnGroupUid = dpn.DpnGroupUid
     AND rel.DpnNodeUid = '7E391272-E81E-4DCC-B186-11127FA2722B')

-- Add the referral owner node to the DPNs
INSERT INTO RelDpnGroupDpnNode(RelDpnGroupDpnNodeUid, DpnGroupUid, DpnNodeUid, IsNodeLeaf, DisplayOrder, UserDefined, IsMultiSelect)
SELECT
   RelDpnGroupDpnNodeUid = dpn.RelDpnGroupDpnNodeUid,
   DpnGroupUid           = dpn.DpnGroupUid,
   DpnNodeUid            = '7E391272-E81E-4DCC-B186-11127FA2722B',
   IsNodeLeaf            = 0,
   DisplayOrder          = (SELECT MAX(rel.DisplayOrder) + 1 FROM RelDpnGroupDpnNode rel WHERE rel.DpnGroupUid = dpn.DpnGroupUid AND NodeLevel = 0),
   UserDefined           = 1,
   IsMultiSelect         = 0
FROM @dpn dpn

-- Map the referral owner node to the order action
UPDATE act
SET MapOrderActionTemplateXml = REPLACE(CONVERT(VARCHAR(MAX), act.MapOrderActionTemplateXml), '</OrderAction>', '<Property name="ReferralOwnerUid" RelDpnGroupDpnNodeUid="' + CONVERT(VARCHAR(50), dpn.RelDpnGroupDpnNodeUid) + '" /></OrderAction>')
FROM RelDpnGroupOrderAction act
INNER JOIN RelDpnGroupDpnNode dpn ON dpn.DpnGroupUid = act.DpnGroupUid AND DpnNodeUid = '7E391272-E81E-4DCC-B186-11127FA2722B'
WHERE act.ProductParameterUid = 'A336390A-5C72-4CA5-A9F6-40EE9A741CCE'
  AND CONVERT(VARCHAR(MAX), act.MapOrderActionTemplateXml) NOT LIKE '%ReferralOwnerUid%'
GO

-- #161529 _InsuranceCarrier_ClaimStatusPayerUid-MigrationScript.sql
-- Set InsuranceCarrier.ClaimStatusPayerUid based on InsuranceCarrier.ElectronicPayerUid
UPDATE ins
SET ClaimStatusPayerUid = csp.ClaimStatusPayerUid
FROM ListProductParameter lpp
CROSS APPLY (SELECT XMLValue = CONVERT(XML, lpp.XMLValue)) xap
CROSS APPLY xap.XMLValue.nodes('/ClaimsPayerCode_to_ClaimStatusPayerCode/map') AS mdx(MapItem)
CROSS APPLY (SELECT ClaimsPayerCode      = mdx.MapItem.value('(@ClaimsPayerCode)[1]', 'VARCHAR(50)'),
                    ClaimStatusPayerCode = mdx.MapItem.value('(@ClaimStatusPayerCode)[1]', 'VARCHAR(50)')) map
INNER JOIN ListElectronicPayer pay ON pay.ClearingHousePayerID = map.ClaimsPayerCode
INNER JOIN ListClaimStatusPayer csp ON csp.ExternalID = map.ClaimStatusPayerCode
INNER JOIN InsuranceCarrier ins ON ins.ElectronicPayerUid = pay.ElectronicPayerUid
WHERE lpp.ProductParameterUid = '5FCB7652-BA35-483A-A1EC-ABFF09831C3B'
  AND lpp.BoolValue = 1
  AND pay.ClaimClearingHouseUid = 'D6E113A1-171F-4C35-91E0-01DCCA171B7D'  -- eMedix
  AND ins.ClaimStatusPayerUid IS NULL
GO

-- #155641 _ListMacro_SetPatientRequired.sql
-- replaced by #167443 _ListMacro_update.sql
update ListMacro
set ListMacro.VisitRequired = 0

update ListMacro
set ListMacro.VisitRequired = 1
from ListMacro lm
where lm.DataContext = 1 or lm.DataSource = 1 or lm.Goal is not null or exists (select 1 from ListMacroDiagnosis lmd where lmd.MacroUid = lm.MacroUid) or exists (select 1 from ListMacroProcedure lmp where lmp.MacroUid = lm.MacroUid)

UPDATE ListMacro
SET PatientRequired = 1
WHERE Name NOT IN ('date', 'today');
GO

-- #161359 _homepage-tile-config-migration_Prescription-Queue_unassignedPrescriptions (1).sql
-- Main logic:
-- Updates ListTileConfiguration and UserTileConfiguration based on changes to
-- default values of properties, or new properties, or deleted properties in TileConfigurationDto
-- The user-changeable properties need to only be migrated for systemdefined rows
-- and the non-userchangeable stuff needs to be migrated for all rows

-- Try to run this first as a trial run to make sure it accomplishes the changes you expect

SET XACT_ABORT ON;
GO

BEGIN TRANSACTION


-- set to 1 to see what the result will be without actually applying it to the database,
-- set to 0 to commit the transaction
DECLARE @trialRun bit = 0

-- Inputs:
DECLARE @pathToObjectContainingProperty NVARCHAR(MAX) = '$'
DECLARE @propertyName NVARCHAR(MAX) = 'unassignedPrescriptions'
-- set to string with the value or null
DECLARE @newValue NVARCHAR(MAX) = 'true'
-- This is the sql data type for @newValue; leave it blank to just handle like a string
-- the cases where this matters are below in the code
-- other options are bit, int, numeric, decimal
DECLARE @newValueType NVARCHAR(MAX) = 'bit'
-- JSON_MODIFY prefix
-- https://learn.microsoft.com/en-us/sql/t-sql/functions/json-modify-transact-sql?view=sql-server-ver16#arguments
-- format: [append] [ lax | strict ]
DECLARE @modifyPrefix NVARCHAR(MAX) = 'lax'
DECLARE @currentTileTypeUid uniqueidentifier = 'DAD2A405-8AF3-4831-8BC6-52B5C8959558'

-- this is an example object that only contains properties
-- that the user can't change
-- it should basically match the Non-changeable properties in TS for TileConfigurationDto
DECLARE @exampleNonUserChangeableObject NVARCHAR(max) = '
{
  "TileTypeId": "DFEE9D62-92D6-4068-845F-CB11C528D95D",
  "TileTypeName": "Replication Monitor",
  "TileType": 0,
  "Description": "",
  "ShortName": "",
  "TileInstanceId": "0561d8a0-c454-409a-97c5-4df8e62be8f6",
  "isRequired": false,
  "isUnique": false,
  "isCollapsible": true,
  "isConfigurable": false,
  "canLoad": false,
  "isLoaded": false,
  "canMoreVert": false,
  "canRefresh": true,
  "canSort": false,
  "canMaximize": true,
  "displayHeader": true,
  "displayFooter": true,
  "canPrint": false
}
'

-- Calculated variables:
DECLARE @fullPropertyPath NVARCHAR(MAX) = @pathToObjectContainingProperty + '.' + @propertyName
DECLARE @JSON_MODIFY_Path NVARCHAR(MAX) = @modifyPrefix + ' ' + @fullPropertyPath
DECLARE @userChangeable bit =
	CASE WHEN EXISTS(SELECT 1 FROM OPENJSON(@exampleNonUserChangeableObject, '$') WHERE [key] = @propertyName)
		THEN 0
		ELSE 1
	END

SELECT
	@fullPropertyPath as '@fullPropertyPath',
	@newValue as '@newValue',
	@currentTileTypeUid as '@currentTileTypeUid',
	@userChangeable as '@userChangeable'


DECLARE @UpdatedLTC UIDLIST
UPDATE ListTileConfiguration
SET
	Data =
		CASE WHEN (ISJSON(Data) > 0)
			 THEN CASE WHEN @newValueType = 'bit'
					   -- have to do a CAST here to not have '' around the true or false
					   -- we may have to add other special cases here as well
					   THEN JSON_MODIFY(Data, 'lax' + ' ' + '$' + '.' + 'unassignedPrescriptions', CAST(@newValue as bit))
					   WHEN @newValueType = 'int'
					   THEN JSON_MODIFY(Data, 'lax' + ' ' + '$' + '.' + 'unassignedPrescriptions', CAST(@newValue as int))
					   WHEN @newValueType = 'decimal' OR @newValueType = 'numeric'
					   THEN JSON_MODIFY(Data, 'lax' + ' ' + '$' + '.' + 'unassignedPrescriptions', CAST(@newValue as decimal))
					   ELSE JSON_MODIFY(Data, 'lax' + ' ' + '$' + '.' + 'unassignedPrescriptions', @newValue)
				  END
			 ELSE Data
		END,
	TileTypeUid =
		CASE WHEN @fullPropertyPath = '$.TileTypeId'
			THEN @newValue
			ELSE TileTypeUid
		END,
	LastModifiedByUid = NULL,
	LastModifiedDate = GETUTCDATE()
OUTPUT inserted.TileConfigurationUid INTO @UpdatedLTC(Uid)
WHERE TileTypeUid = @currentTileTypeUid
AND (@userChangeable = 0 OR UserDefined = 0)


SELECT 'ListTileConfiguration'
SELECT ltc.*
FROM @UpdatedLTC ltcList
INNER JOIN ListTileConfiguration ltc ON ltcList.Uid = ltc.TileConfigurationUid


-- I think for the usertileconfiguration, it would only overwrite properties that already exist in the JSON,
-- because these are not the full objects, like they are in the Data column of ListTileConfiguration, so it wouldn't make sense that you would be adding to them
-- even if you added a new user changeable property to the Data structure.
-- I think that I would expect that  the user would have to actually go and manually make that change to overwite the row with some value for that property
DECLARE @UpdatedUTC UIDLIST
UPDATE utc
SET
	Data =
		CASE WHEN (ISJSON(utc.Data) > 0) AND EXISTS(SELECT 1 FROM OPENJSON(utc.Data, '$') WHERE [key] = @propertyName)
			THEN CASE WHEN @newValueType = 'bit'
					   -- have to do a CAST here to not have '' around the true or false
					   -- we may have to add other special cases here as well
					   THEN JSON_MODIFY(utc.Data, 'lax' + ' ' + '$' + '.' + 'unassignedPrescriptions', CAST(@newValue as bit))
					   WHEN @newValueType = 'int'
					   THEN JSON_MODIFY(utc.Data, 'lax' + ' ' + '$' + '.' + 'unassignedPrescriptions', CAST(@newValue as int))
					   WHEN @newValueType = 'decimal' OR @newValueType = 'numeric'
					   THEN JSON_MODIFY(utc.Data, 'lax' + ' ' + '$' + '.' + 'unassignedPrescriptions', CAST(@newValue as decimal))
					   ELSE JSON_MODIFY(utc.Data, 'lax' + ' ' + '$' + '.' + 'unassignedPrescriptions', @newValue)
				  END
			ELSE utc.Data
		END,
	LastModifiedByUid = NULL,
	LastModifiedDate = GETUTCDATE()
OUTPUT inserted.UserTileConfigurationUid INTO @UpdatedUTC(Uid)
FROM UserTileConfiguration utc
INNER JOIN @UpdatedLTC ltcList ON ltcList.Uid = utc.TileConfigurationUid
AND (@userChangeable = 0 OR utc.UserDefined = 0)

SELECT 'UserTileConfiguration'
SELECT utc.*
FROM @UpdatedUTC utcList
INNER JOIN UserTileConfiguration utc ON utcList.Uid = utc.UserTileConfigurationUid


IF(@trialRun = 1)
	ROLLBACK TRANSACTION
ELSE
	COMMIT TRANSACTION
GO
-- #161359 end
