SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeDupeImportPats]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[DeDupeImportPats] AS' 
END
GO
ALTER PROCEDURE [dbo].[DeDupeImportPats]

AS
BEGIN



	DECLARE @Pats TABLE(PatientUid UNIQUEIDENTIFIER)
	INSERT INTO @Pats
	SELECT PersonUid
	FROM Person
	WHERE Notes = 'QRDAImport'

	Update per  set firstname = 
	case
		when len(fn1) <> 1 then fn1
		when len(fn2) <> 1 then fn2
		else per.firstname
	end
	from @Pats p
	JOIN person per ON p.PatientUid = per.PersonUid
	inner join 
	(
	select per.personuid, per2.personuid as personuid2, per.lastname ln1,	
		per.firstname fn1, per2.lastname ln2, per2.firstname fn2 from person per
	inner join person per2 on per.birthdate = per2.birthdate and per.lastname = per2.lastname 
		and per.personuid <> per2.personuid and left(per.firstname,1) = left(per2.firstname,1)
		and (len(per.firstname) = 1 or len(per2.firstname) = 1)
	) names on per.personuid = names.personuid 



	Update per set lastname = 
	case
		when len(ln1) <> 1 then ln1
		when len(ln2) <> 1 then ln2
		else per.firstname
	end
	from @Pats p
	JOIN person per ON p.PatientUid = per.PersonUid
	inner join 
	(
	select per.personuid, per2.personuid as personuid2, per.lastname ln1, 
		per.firstname fn1, per2.lastname ln2, per2.firstname fn2 from person per
	inner join person per2 on 
		per.birthdate = per2.birthdate and 
		per.firstname = per2.firstname and 
		per.personuid <> per2.personuid and 
		left(per.lastname,1) = left(per2.lastname,1) and 
		(len(per.lastname) = 1 or len(per2.lastname) = 1)
	) names on per.personuid = names.personuid 




	select cast(null as uniqueidentifier ) as personuid, cast(null as uniqueidentifier ) as personuidDupe into #dupsToDelete from person where person.lastname = '###'
	update patient set inactive = 0 from patient pat
 
	--select per.personuid, count(*)  as VisitCnt, string_agg(convert(varchar(20), vis.visitdate, 112),'') as VisitString into #VisitPatients from person per 
	--inner join visit vis on vis.PatientUid = per.personuid
	--group by per.personuid 
	CREATE TABLE #VisitPatients
	(
		personuid uniqueidentifier , 
		VisitCnt int , 
		VisitString varchar(max),
		ProviderString VARCHAR(MAX)
	
	)

	insert into #VisitPatients
	select per.personuid, count(*)  as VisitCnt, ''  as VisitString, '' AS providerString  
	from @Pats p
	JOIN person per ON p.PatientUid = per.PersonUid
	inner join visit vis on vis.PatientUid = per.personuid
	group by per.personuid 

	declare @PatientString  table 
	(
	personuid UNIQUEIDENTIFIER , 
	visitstring varchar(max) default '',
	providerString varchar(max) default '',
	done bit default 0 
	)



	insert into @PatientString (personuid)
	select personuid 
	from @Pats p
	JOIN person per on p.PatientUid = per.PersonUid



	declare @Personuid UNIQUEIDENTIFIER = null

	declare @Visitstring varchar(max) = ''
	DECLARE @ProviderString VARCHAR(MAX) = ''
	select top 1 @Personuid = personuid from @PatientString where done = 0

	while @Personuid is not null
	Begin
		select @Visitstring = '', @ProviderString = ''
		select @Visitstring = @VisitString + convert(varchar(20), vis.visitdate, 112)
		from Visit vis where patientuid = @Personuid order by vis.visitdate desc

		SELECT @ProviderString = @ProviderString + CONVERT(VARCHAR(50), vis.ProviderUid)
		from Visit vis where patientuid = @Personuid order by vis.visitdate desc

		update @PatientString  
		set done = 1
			,visitstring = @Visitstring 
			,providerString = @ProviderString
		where personuid = @Personuid

		select @Personuid = null
		select top 1 @Personuid = personuid from @PatientString where done = 0
	ENd

	UPDATE vp
	SET visitstring = vis.visitstring
		,ProviderString = vis.providerString
	FROM #VisitPatients vp 
	INNER JOIN @PatientString vis 
	on vis.personuid = vp.personuid 

	select * from #VisitPatients


	DECLARE @TestPatienStatustUID UNIQUEIDENTIFIER = null
	SELECT @TestPatienStatustUID = PatientStatusUID FROM listpatientstatus  WHERE NAME = 'Test Patient'
	DELETE FROM relPatientStatus where PatientStatusUid = @TestPatienStatustUID 



	--BEGIN --birthdate, visitstring, visitcnt , Name initials
	--	INSERT INTO #dupsToDelete(personuid, personuiddupe) 
	--	SELECT personuid, personuiddupe from (
	--		SELECT LEFT(per.lastname,1) + right(per.lastname,1) + left(per.firstname,1)  + right(per.firstname,1) AS INITIALS,
	--			per.birthdate, vp.VisitCnt ,vp.visitstring, 
	--			min(per.personuid) as personuid, max(per.personuid) as personuidDupe,  count(*) as dupcnt  FROM PERSON PER
	--		INNER JOIN #VisitPatients vp on vp.PersonUid = per.personuid
	--		LEFT JOIN #dupsToDelete dtd on per.personuid = dtd.personuid
	--		WHERE dtd.personuid is null
	--		GROUP BY left(per.lastname,1) + right(per.lastname,1) + left(per.firstname,1)  + right(per.firstname,1),
	--		per.birthdate, vp.visitstring, vp.VisitCnt
	--		HAVING COUNT(*) = 2
	--	) BLAH
	--END

	--exec Sp_DeactivateDuplicates


	select per.lastname, per.firstname, vp.* from #VisitPatients vp
	inner join person per on per.PersonUid = vp.PersonUid
	order by vp.VisitString  asc





	BEGIN --visitstring, visitcnt, birthdate, lastname, first 3 of first name 
		INSERT INTO #dupsToDelete(personuid, personuiddupe) 
		SELECT personuid, personuiddupe from (


		select per.lastname, left(per.firstname, 3) as fname, per.birthdate, VP.VisitCnt , VP.visitstring, 
				min(per.personuid) as personuid, max(per.personuid) as personuidDupe,  count(*) as dupcnt  FROM PERSON PER
		inner join #VisitPatients vp on vp.PersonUid = per.personuid
		left join #dupsToDelete dtd on per.personuid = dtd.personuid
		where dtd.personuid is null
		group by per.lastname,left(per.firstname, 3),  VP.VisitCnt , VP.visitstring, per.birthdate
		having count(*) = 2

		) blah
	END

	BEGIN --visitstring, visitcnt, birthdate, lastname, first 3 of first name 
		INSERT INTO #dupsToDelete(personuid, personuiddupe) 
		SELECT personuid, personuiddupe from (


		select soundex(per.lastname) as fn, soundex(per.firstname)ln, per.birthdate, VP.VisitCnt , VP.visitstring, 
				min(per.personuid) as personuid, max(per.personuid) as personuidDupe,  count(*) as dupcnt  FROM PERSON PER
		inner join #VisitPatients vp on vp.PersonUid = per.personuid
		left join #dupsToDelete dtd on per.personuid = dtd.personuid
		where dtd.personuid is null
		group by soundex(per.lastname), soundex(per.firstname),  VP.VisitCnt , VP.visitstring, per.birthdate
		having count(*) = 2

		) blah
	END



		BEGIN --visitstring, visitcnt, birthdate, lastname, last 3 of first name 
			INSERT INTO #dupsToDelete(personuid, personuiddupe) 
			SELECT personuid, personuiddupe from (


			select per.lastname, right(per.firstname, 3) as fname, per.birthdate, VP.VisitCnt , VP.visitstring, 
					min(per.personuid) as personuid, max(per.personuid) as personuidDupe,  count(*) as dupcnt  FROM PERSON PER
			inner join #VisitPatients vp on vp.PersonUid = per.personuid
			left join #dupsToDelete dtd on per.personuid = dtd.personuid
			where dtd.personuid is null
			group by per.lastname,right(per.firstname, 3),  VP.VisitCnt , VP.visitstring, per.birthdate
			having count(*) = 2

			) blah
		END
		BEGIN --visitstring, visitcnt, birthdate, lastname, last 3 of first name 
			INSERT INTO #dupsToDelete(personuid, personuiddupe) 
			SELECT personuid, personuiddupe from (


			select soundex(per.lastname) as lname, soundex(per.firstname) as fname, per.birthdate, VP.VisitCnt , VP.visitstring, 
					min(per.personuid) as personuid, max(per.personuid) as personuidDupe,  count(*) as dupcnt  FROM PERSON PER
			inner join #VisitPatients vp on vp.PersonUid = per.personuid
			left join #dupsToDelete dtd on per.personuid = dtd.personuid
			where dtd.personuid is null
			group by soundex(per.lastname), soundex(per.firstname),  VP.VisitCnt , VP.visitstring, per.birthdate
			having count(*) = 2

			) blah
		END
		BEGIN --name, birthdate, visit counts:0
			INSERT INTO #dupsToDelete(personuid, personuiddupe) 
			SELECT personuid, personuiddupe from (


			select lastname, firstname, per.birthdate,  vp.VisitCnt, vp.visitstring , 
					min(per.personuid) as personuid, max(per.personuid) as personuidDupe,  count(*) as dupcnt  FROM PERSON PER
			inner join #VisitPatients vp on vp.PersonUid = per.personuid
			left join #dupsToDelete dtd on per.personuid = dtd.personuid
			where dtd.personuid is null
			group by lastname, firstname, per.birthdate, vp.VisitCnt , vp.visitstring
			having count(*) = 2

			) blah
		END
		BEGIN --Lastname, soundex of firstname, birthdate, visitcount:4 
			INSERT INTO #dupsToDelete(personuid, personuiddupe) 
			SELECT personuid, personuiddupe from (


			select per.lastname, soundex(per.firstname) as fn, per.birthdate, vp.visitcnt, vp.visitstring, 
					min(per.personuid) as personuid, max(per.personuid) as personuidDupe,  count(*) as dupcnt  FROM PERSON PER
			inner join #VisitPatients vp on vp.PersonUid = per.personuid
			left join #dupsToDelete dtd on per.personuid = dtd.personuid
			where dtd.personuid is null
			group by lastname, soundex(per.firstname), per.birthdate, vp.VisitCnt , vp.visitstring
			having count(*) = 2

			) blah
		END
		BEGIN --soundex of lastname, firstname, birthdate, visit count:3
			INSERT INTO #dupsToDelete(personuid, personuiddupe) 
			SELECT personuid, personuiddupe from (
			select soundex(per.lastname) as fn, per.firstname as lf, per.birthdate, 
					min(per.personuid) as personuid, max(per.personuid) as personuidDupe,  count(*) as dupcnt  FROM PERSON PER
			inner join #VisitPatients vp on vp.PersonUid = per.personuid
			left join #dupsToDelete dtd on per.personuid = dtd.personuid
			where dtd.personuid is null
			group by soundex(per.lastname) , per.firstname, per.birthdate, vp.VisitCnt 
			having count(*) = 2

			) blah
		END
		BEGIN --lastname, firstname, visit count :20
			INSERT INTO #dupsToDelete(personuid, personuiddupe) 
			SELECT personuid, personuiddupe from (


			select per.lastname as ln, per.firstname as fn, vp.visitstring,
					min(per.personuid) as personuid, max(per.personuid) as personuidDupe,  count(*) as dupcnt  FROM PERSON PER
			inner join #VisitPatients vp on vp.PersonUid = per.personuid
			left join #dupsToDelete dtd on per.personuid = dtd.personuid
			where dtd.personuid is null
			group by per.lastname , per.firstname, vp.VisitCnt,  vp.visitstring
			having count(*) = 2
			) blah

		END
		BEGIN --birthdate, lastname, visitcnt, firstname initials, len of firstname
			INSERT INTO #dupsToDelete(personuid, personuiddupe) 
			SELECT personuid, personuiddupe from (


			select per.lastname as ln, len(per.firstname) lenfname ,  left(per.firstname,1) + right(per.firstname,1)  as fn, vp.providerString,
					min(per.personuid) as personuid, max(per.personuid) as personuidDupe,  count(*) as dupcnt  
			FROM PERSON PER
			inner join #VisitPatients vp on vp.PersonUid = per.personuid
			left join #dupsToDelete dtd on per.personuid = dtd.personuid
			where dtd.personuid is null
			group by per.birthdate, per.lastname, len(per.firstname), left(per.firstname,1) + right(per.firstname,1), vp.VisitCnt , vp.providerString

			having count(*) = 2

			) blah
		END
		BEGIN --birthdate, firstname, visitcnt, first and last letter of lastname
			INSERT INTO #dupsToDelete(personuid, personuiddupe) 
			SELECT personuid, personuiddupe from (


			select per.Firstname as ln, len( per.lastname) as lenlname, left(per.Lastname,1) + right(per.lastname,1)   as fn, 
					min(per.personuid) as personuid, max(per.personuid) as personuidDupe,  count(*) as dupcnt  FROM PERSON PER
			inner join #VisitPatients vp on vp.PersonUid = per.personuid
			left join #dupsToDelete dtd on per.personuid = dtd.personuid
			where dtd.personuid is null
			group by per.birthdate, per.Firstname,len( per.lastname), left(per.Lastname,1) + right(per.lastname,1), vp.VisitCnt 

			having count(*) = 2

			) blah
		END


		BEGIN
			INSERT INTO #dupsToDelete(personuid, personuiddupe) 
			SELECT personuid, personuiddupe from (


			select left(per.lastname,2) as lastname , per.firstname as firstname, per.birthdate, vp.visitcnt, vp.visitstring, 
					min(per.personuid) as personuid, max(per.personuid) as personuidDupe,  count(*) as dupcnt  FROM PERSON PER
			inner join #VisitPatients vp on vp.PersonUid = per.personuid
			left join #dupsToDelete dtd on per.personuid = dtd.personuid
			where dtd.personuid is null 
			group by left(per.lastname,2), per.firstname, per.birthdate, vp.VisitCnt , vp.visitstring
			having count(*) = 2

			) blah
		END
		BEGIN
			INSERT INTO #dupsToDelete(personuid, personuiddupe) 
			SELECT personuid, personuiddupe from (


			select per.lastname as lastname, per.birthdate, per.Computed_Phone1_PhoneNumber, vp.visitcnt, vp.visitstring, 
					min(per.personuid) as personuid, max(per.personuid) as personuidDupe,  count(*) as dupcnt  FROM PERSON PER
			inner join #VisitPatients vp on vp.PersonUid = per.personuid
			left join #dupsToDelete dtd on per.personuid = dtd.personuid
			where dtd.personuid is null 
			group by per.lastname, per.birthdate, per.Computed_Phone1_PhoneNumber, vp.VisitCnt , vp.visitstring
			having count(*) = 2

			) blah
		END

		BEGIN
			DELETE #dupsToDelete
			WHERE PersonUidDupe IN (SELECT PersonUid FROM ViewFindPatient vfp WHERE vfp.LastName = 'Reeves' AND vfp.FirstName = 'Edward' AND Birthdate = '1955-04-12')
			OR PersonUid IN (SELECT PersonUid FROM ViewFindPatient vfp WHERE vfp.LastName = 'Reeves' AND vfp.FirstName = 'Edward' AND Birthdate = '1955-04-12')


			DELETE #dupsToDelete
			WHERE PersonUid IN (SELECT PersonUid FROM ViewFindPatient WHERE LastName = 'Watts' AND FirstName = 'Ken' AND Birthdate = '1949-11-13')
					   
			INSERT INTO #dupsToDelete (personuid, personuiddupe)
			SELECT PersonUid, PersonUid FROM Person WHERE LastName = 'Watts' AND FirstName = 'Ken' AND Birthdate = '1949-11-13' AND GenderUid IN ('E5DED511-EE8A-4B47-AA68-8FF9F74741A1')
		END

		BEGIN
			INSERT INTO #dupsToDelete (personuid, personuiddupe)
			SELECT PersonUid, PersonUid FROM Person WHERE Lastname = 'Glover' AND FirstName = 'Chris' AND Birthdate = '1949-05-29'
		END
		BEGIN
			INSERT INTO #dupsToDelete (personuid, personuiddupe)
			SELECT PersonUid, PersonUid FROM Person WHERE Lastname = 'Harris' AND FirstName = 'Shelly' AND Birthdate = '1967-05-12'
		END



	if 1 = 0 --this throws a bug
	BEGIN --null birthdays
		insert into #dupsToDelete(personuid) 
		select personuid from 
		(
			select top 1 per.personuid from person per
		left join #dupsToDelete dtd on per.personuid = dtd.personuid
		where  per.birthdate is null  and dtd.personuid is null 

		) blah
	END

	DECLARE @TodaysDate DATETIME = getdate()



	SELECT * FROM #dupsToDelete

	INSERT INTO relPatientStatus (patientuid, patientstatusuid , LastModifiedDate ) 
	SELECT distinct 
	per.personuid ,
	@TestPatienStatustUID, @TodaysDate
	FROM person per 
		INNER JOIN #dupsToDelete dtd on per.personuid = 
		iif(len(per.lastname) = 1 or len(per.firstname) = 1,dtd.personuid ,dtd.personuiddupe)
		LEFT JOIN relPatientStatus rps  ON per.PersonUid = rps.patientuid 
	WHERE rps.PatientUid  is null



	UPDATE relPatientStatus set PatientStatusUid = @TestPatienStatustUID from relPatientStatus  rps
	INNER JOIN #dupsToDelete dtd on rps.PatientUid  = dtd.Personuid 

	UPDATE per
	SET Notes = NULL
	FROM Person per
	JOIN @Pats pat on per.PersonUid = pat.PatientUid


	DROP TABLE #dupsToDelete
	DROP TABLE #VisitPatients
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetSeed]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[GetSeed] AS' 
END
GO
ALTER PROC [dbo].[GetSeed]  -- by LGodolphin 8/16/05

  @SeedName varchar(255)

AS
BEGIN
SET XACT_ABORT ON;
DECLARE @SeedValue int
DECLARE @SeedTran varchar (20)
SELECT @SeedTran = 'seed_tran'

SELECT @SeedValue = SeedValue FROM SeedTable WHERE (SeedName = @SeedName)

IF (@SeedValue is NULL)
  BEGIN
    BEGIN TRANSACTION @SeedTran 
	INSERT INTO SeedTable 
	(
		SeedName,
		SeedValue
	) 
	VALUES 
	(
		@SeedName,
		1
	)

	SELECT @SeedValue = SeedValue FROM SeedTable WHERE (SeedName = @SeedName)
	--Print 'getSeed - New Seed: ' + convert(varchar(20), @SeedValue)
	COMMIT TRANSACTION @SeedTran
	RETURN @SeedValue
  END
ELSE 
  BEGIN
   BEGIN TRANSACTION @SeedTran		 
	UPDATE SeedTable 
		SET SeedValue = SeedValue + 1, LastModifiedDate = getutcdate()
		WHERE (SeedName = @SeedName)
	SELECT @SeedValue = SeedValue FROM SeedTable WHERE (SeedName = @SeedName)
	--Print 'getSeed - Update Seed: ' + convert(varchar(20), @SeedValue)
	COMMIT TRANSACTION @SeedTran
	RETURN @SeedValue
  END
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAccessionNumber]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[GetAccessionNumber] AS' 
END
GO
ALTER PROCEDURE [dbo].[GetAccessionNumber] (@id as varchar(14) OUTPUT)
AS
BEGIN

declare @prefix varchar(255)
set @prefix = '00000'

declare @postfix varchar(255)
set @postfix = '0000000000'

declare @isCacheClient bit
if ( dbo.IsCacheClient() = 1 )
	set @isCacheClient = 1


-- Get the prefix
if ( @isCacheClient = 1 )
	Begin
		SELECT @prefix = @prefix + cast(ID AS varchar(5)) 
		FROM ListCacheMachine 
		 WHERE URL in (SERVERPROPERTY ('ServerName'), SERVERPROPERTY ('Machinename'))
	 End
-- Get the trailing portion
declare @seed varchar(14)
exec @seed = GetSeed 'AccessionNumber'

set @postfix = @postfix + cast(@seed as varchar(7))

-- And build the final
-- need to return on 11 digits because that is the limit in hl7GenerateAccessions
-- Split prefixing based on if it is cacheclient
if( @isCacheClient = 1)
	
	Begin
		set @id = right(@prefix, 5) + right(@postfix, 7)
		return;
	End

else
	
	Begin
		set @id = right(('00000000000'+ @seed), 12)
		return;
	End

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ManualCollectionStatusChange]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ManualCollectionStatusChange] AS' 
END
GO
ALTER PROCEDURE [dbo].[ManualCollectionStatusChange]
(
	@AccountResponsiblePartyUid		uniqueidentifier,
	@OldCollectionStatusUid				uniqueidentifier,
	@NewCollectionStatusUid				uniqueidentifier,
	@ChangedByUid									uniqueidentifier
)
AS
BEGIN
	DECLARE @Now															datetime
	SET @Now = GetUTCDate()

	DECLARE @CurrentCollectionStatusUid				uniqueidentifier
	DECLARE @CurrentCollectionStatusLevelUid	uniqueidentifier
	DECLARE @NewCollectionStatusLevelUid			uniqueidentifier
	DECLARE @CalculatedPaymentAmount					money
	DECLARE @IsExpireDayOfMonth								bit
	DECLARE @CurrentExpirationDate						datetime
	DECLARE @NewExpirationDate								datetime
	DECLARE @CurrentDateEnteredStatus					datetime
	DECLARE @CurrentDateEnteredStatusLevel		datetime
	DECLARE @NewDateEnteredStatus							datetime
	DECLARE @NewDateEnteredStatusLevel				datetime

	DECLARE	@GlobalSufficientPercentage				decimal(9,4)
	DECLARE @ChangedByName										varchar(100)
	SELECT
		@CurrentCollectionStatusUid = @OldCollectionStatusUid,
		@CurrentCollectionStatusLevelUid = CollectionStatusLevelUid
	FROM
		AccountResponsibleParty
	WHERE
		AccountResponsiblePartyUid = @AccountResponsiblePartyUid

	IF @CurrentCollectionStatusUid = @NewCollectionStatusUid
	BEGIN
		RETURN
	END

	SELECT
		@GlobalSufficientPercentage = GlobalSufficientPercentage
	FROM
		CollectionStatusGlobal

	SELECT
		@ChangedByName = dbo.UDF_getFormattedName('', p.Firstname, p.MiddleName, p.LastName, '')
	FROM
		Person p
	WHERE
		PersonUid = @ChangedByUid

	SELECT
		@CurrentExpirationDate = CollectionStatusExpirationDate,
		@CurrentDateEnteredStatus = DateEnteredStatus,
		@CurrentDateEnteredStatusLevel = DateEnteredStatusLevel
	FROM
		AccountResponsibleParty
	WHERE
		AccountResponsiblePartyUid = @AccountResponsiblePartyUid

	SET	@NewCollectionStatusLevelUid = dbo.GetCollectionStatusLevelForAccountResponsibleParty(@AccountResponsiblePartyUid,@NewCollectionStatusUid)
	SET @CalculatedPaymentAmount = dbo.GetAccountResponsiblePartyOriginalCollectionsBalance(@AccountResponsiblePartyUid) * (@GlobalSufficientPercentage / 100)

	IF @IsExpireDayOfMonth = 1
	BEGIN
		SET	@NewExpirationDate = DateAdd(month, 1, @CurrentExpirationDate)
	END
	ELSE
	BEGIN
		SET	@NewExpirationDate = DateAdd(day, (SELECT ExpirationNumberOfDays FROM CollectionStatusLevel WHERE CollectionStatusLevelUid = @NewCollectionStatusLevelUid), @Now)
	END

	IF @NewCollectionStatusUid <> @CurrentCollectionStatusUid
	BEGIN
		SET @NewDateEnteredStatus = @Now
	END
	ELSE
	BEGIN
		SET @NewDateEnteredStatus = @CurrentDateEnteredStatus
	END
		
	IF @NewCollectionStatusLevelUid <> @CurrentCollectionStatusLevelUid
	BEGIN
		SET @NewDateEnteredStatusLevel = @Now
	END
	ELSE
	BEGIN
		SET @NewDateEnteredStatusLevel = @CurrentDateEnteredStatusLevel
	END

	INSERT INTO
		CollectionHistory
	(
		AccountResponsiblePartyUid,
		InitialCollectionStatusUid,
		InitialCollectionStatusLevelUid,
		NewCollectionStatusUid,
		NewCollectionStatusLevelUid,
		CreatedDateTime,
		Reason,
		Notes
	)
	SELECT
		@AccountResponsiblePartyUid,
		@CurrentCollectionStatusUid,
		@CurrentCollectionStatusLevelUid,
		@NewCollectionStatusUid,
		@NewCollectionStatusLevelUid,
		@Now,
		'This Account Reponsible Party has been manually changed to this Collection Status by ' + isnull(@ChangedByName, 'Unknown'),
		''

	UPDATE
		AccountResponsibleParty
	SET
		CollectionStatusUid = @NewCollectionStatusUid,
		CollectionStatusLevelUid = @NewCollectionStatusLevelUid,
		CollectionStatusExpirationDate = @NewExpirationDate,
		CalculatedPaymentAmount = 
			CASE WHEN NOT @CalculatedPaymentAmount IS NULL THEN @CalculatedPaymentAmount ELSE 0 END,
		DateEnteredStatus = @NewDateEnteredStatus,
		DateEnteredStatusLevel = @NewDateEnteredStatusLevel,
		PaymentsLastProcessed = @Now,
		LastModifiedDate = @Now
	WHERE
		AccountResponsiblePartyUid = @AccountResponsiblePartyUid

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MUI_Master_Report_UpdateDetailInformation]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[MUI_Master_Report_UpdateDetailInformation] AS' 
END
GO
ALTER PROC [dbo].[MUI_Master_Report_UpdateDetailInformation]
(
	@ItemDefinitionUid UNIQUEIDENTIFIER,
	@ReportMode          BIT,
	@Debug               INT
)
AS
BEGIN
	SET NOCOUNT ON;
	IF (@Debug = 1)
	BEGIN
		SELECT 'MUI_Master_Report_UpdateDetailInformation -- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END	
	
	
	
	UPDATE #tblMeaningfulUseDetail 
		SET 
			CategoryNumber = (select mucd.CategoryNumber 
							  from MeaningfulUseItemDefinition muid inner join MeaningfulUseCategoryDefinition mucd on muid.CategoryUid = mucd.CategoryUid
							  where muid.ItemDefinitionUid = @ItemDefinitionUid),	
			
			MeasureNumber  = (select muid.MeasureNumber 
							  from MeaningfulUseItemDefinition muid inner join MeaningfulUseCategoryDefinition mucd on muid.CategoryUid = mucd.CategoryUid
							  where muid.ItemDefinitionUid = @ItemDefinitionUid),
			                      
			SubMeasureNumber = (select muid.SubMeasureNumber 
                                from MeaningfulUseItemDefinition muid inner join MeaningfulUseCategoryDefinition mucd on muid.CategoryUid = mucd.CategoryUid
                                where muid.ItemDefinitionUid = @ItemDefinitionUid),
			                         
			PersonLnFn     = (Person.LastName + ', ' + Person.FirstName),
			                            
			ProviderUid    = (Patient.ProviderUid),
			                              
			ProviderLnFn   = (SELECT LastName + ', ' + FirstName FROM Person WHERE PersonUid = Patient.ProviderUid)
		
			FROM   #tblMeaningfulUseDetail mu 
					 INNER JOIN Person ON Person.PersonUid = mu.PersonUid
					 LEFT OUTER JOIN Patient ON Patient.PersonUid = Person.PersonUid 
			
			WHERE  mu.ItemDefinitionUid = @ItemDefinitionUid
	
	
	-- If no detail rows for given metric, insert row indicating this.
	DECLARE @NumDetailRows INT
	SET @NumDetailRows = (SELECT COUNT(*) FROM #tblMeaningfulUseDetail mu WHERE mu.ItemDefinitionUid = @ItemDefinitionUid)      
	IF (@NumDetailRows <= 0)
	BEGIN
		INSERT INTO #tblMetricUidsWithoutDetailRows (ItemDefinitionUid) VALUES (@ItemDefinitionUid)
	END		
	
	
	
	IF (@Debug = 1)
	BEGIN
		SELECT 'MUI_Master_Report_UpdateDetailInformation -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END	
	
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_E-Prescribing_1_NonControlled]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_E-Prescribing_1_NonControlled] AS' 
END
GO
--
-- Date    : 2018.12.03
-- Purpose : MU Stage 3
-- TFS     : 43001 - Meaningful Use 2015-2017 Objectives as a Dashboard and Report
--

ALTER PROC [dbo].[2019PI_E-Prescribing_1_NonControlled]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_E-Prescribing_1_NonControlled-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = '52A3A1BE-62AE-4668-A307-1955A80CFFDA',
		@RxStatusTransmittedSuccessfully [uniqueidentifier] = 'B1F7EFAF-D56D-4BAD-AE1F-8205E1D00B58', 
		@RxStatusQueuedForTransmission   [uniqueidentifier] = '0605B6F6-2FE4-49CB-B868-9DF448AB3E01'

	TRUNCATE TABLE #MetricDataTemp

	-- Initialize work table
	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
	SELECT @ItemDefinitionUid AS [ItemDefinitionUid]
		, med.[PersonUid]
		, COUNT(sts.[eRxStatusUid]) AS [NumeratorValue]                        
		, COUNT(med.[MedicationSIGUid]) AS [DenominatorValue]
		, null AS [YesNo]
	FROM   [#tblMedicationList] AS med
		LEFT JOIN [ListeRxStatus] AS sts WITH(NOLOCK) ON  med.[eRxStatusUid] = sts.[eRxStatusUid]
		 AND (sts.[eRxStatusUid] IN(@RxStatusTransmittedSuccessfully, @RxStatusQueuedForTransmission))
	WHERE med.[Dispensable] = 1
		AND med.[IsSampleGiven] = 0
		AND med.[IsAdministered] = 0
		AND med.[reffederaldeaclasscode] = 0
		AND [SIGDetailCount] = 1
	GROUP BY med.[PersonUid]
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_E-Prescribing_1_NonControlled -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_E-Prescribing_2_Controlled]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_E-Prescribing_2_Controlled] AS' 
END
GO
--
-- Date    : 2018.12.03
-- Purpose : MU Stage 3
-- TFS     : 43001 - Meaningful Use 2015-2017 Objectives as a Dashboard and Report
--

ALTER PROC [dbo].[2019PI_E-Prescribing_2_Controlled]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_E-Prescribing_2_Controlled-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = '511E0ECF-F843-43F5-ABA5-DC54B99BCD27',
		@RxStatusTransmittedSuccessfully [uniqueidentifier] = 'B1F7EFAF-D56D-4BAD-AE1F-8205E1D00B58', 
		@RxStatusQueuedForTransmission   [uniqueidentifier] = '0605B6F6-2FE4-49CB-B868-9DF448AB3E01'

	TRUNCATE TABLE #MetricDataTemp

	-- Initialize work table
	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
	SELECT @ItemDefinitionUid AS [ItemDefinitionUid]
		, med.[PersonUid]
		, COUNT(sts.[eRxStatusUid]) AS [NumeratorValue]                        
		, COUNT(med.[MedicationSIGUid]) AS [DenominatorValue]
		, null AS [YesNo]
	FROM   [#tblMedicationList] AS med
		LEFT JOIN [ListeRxStatus] AS sts WITH(NOLOCK) ON  med.[eRxStatusUid] = sts.[eRxStatusUid]
		 AND (sts.[eRxStatusUid] IN(@RxStatusTransmittedSuccessfully, @RxStatusQueuedForTransmission))
	WHERE med.[Dispensable] = 1
		AND med.[IsSampleGiven] = 0
		AND med.[IsAdministered] = 0
		AND med.[reffederaldeaclasscode] >= 0
		AND [SIGDetailCount] = 1
	GROUP BY med.[PersonUid]
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_E-Prescribing_2_Controlled -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_E-Prescribing_3_PDMP]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_E-Prescribing_3_PDMP] AS' 
END
GO
--
-- Date    : 2018.12.03
-- Purpose : MU Stage 3
-- TFS     : 43001 - Meaningful Use 2015-2017 Objectives as a Dashboard and Report
--

ALTER PROC [dbo].[2019PI_E-Prescribing_3_PDMP]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_E-Prescribing_3_PDMP-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = '2A520871-A655-4F6A-A0BA-7D488381B8CD',
		@RxStatusTransmittedSuccessfully [uniqueidentifier] = 'B1F7EFAF-D56D-4BAD-AE1F-8205E1D00B58', 
		@RxStatusQueuedForTransmission   [uniqueidentifier] = '0605B6F6-2FE4-49CB-B868-9DF448AB3E01'

	TRUNCATE TABLE #MetricDataTemp

	--DECLARE @Audit TABLE (PatientUid UNIQUEIDENTIFIER)
	--INSERT INTO @Audit
	--SELECT a.PatientUid
	--FROM [#tblMedicationList] m
	--INNER JOIN Audit a on m.PersonUid = a.PatientUid 
	--	AND a.ChangeDate >= @RptTimespan_StartDate AND a.ChangeDate <= @RptTimespan_EndDate
	--	AND a.Description LIKE 'Appriss RX Report Requested Successfully%' or Description LIKE 'LogiCoy Report requested successfully%'

	-- Initialize work table
	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
	--THIS is not the right query
	--And needs to be changed to what is correct
	SELECT @ItemDefinitionUid AS [ItemDefinitionUid]
		, med.[PersonUid]
		, CASE WHEN a.PatientUid IS NOT NULL THEN 1 ELSE 0 END AS [NumeratorValue]                        
		, CASE WHEN med.PersonUid IS NOT NULL THEN 1 ELSE 0 END AS [DenominatorValue]
		, null AS [YesNo]
	FROM   [#tblMedicationList] AS med
	INNER JOIN [ListeRxStatus] AS sts WITH(NOLOCK) ON  med.[eRxStatusUid] = sts.[eRxStatusUid]
		 AND (sts.[eRxStatusUid] IN(@RxStatusTransmittedSuccessfully, @RxStatusQueuedForTransmission))
	LEFT JOIN cus_PDMP_Pats a on med.PersonUid = a.PatientUid
	WHERE med.[Dispensable] = 1
		AND med.[IsSampleGiven] = 0
		AND med.[IsAdministered] = 0
		AND med.[reffederaldeaclasscode] >= 2
		AND [SIGDetailCount] = 1
	GROUP BY med.[PersonUid], a.PatientUid
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_E-Prescribing_3_PDMP -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_E-Prescribing_4_VerifyOpioidAgreement]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_E-Prescribing_4_VerifyOpioidAgreement] AS' 
END
GO
ALTER PROC [dbo].[2019PI_E-Prescribing_4_VerifyOpioidAgreement]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_E-Prescribing_4_VerifyOpioidAgreement-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = '0928DA86-A1C8-4AA3-B7EA-6F5CEA042621',
		@RxStatusTransmittedSuccessfully [uniqueidentifier] = 'B1F7EFAF-D56D-4BAD-AE1F-8205E1D00B58', 
		@RxStatusQueuedForTransmission   [uniqueidentifier] = '0605B6F6-2FE4-49CB-B868-9DF448AB3E01',
		@OpioidTreatmentAgreement UNIQUEIDENTIFIER = '3B3E0D30-F233-4928-A2FA-C3501ACA296C'

	TRUNCATE TABLE #MetricDataTemp

	DECLARE @Meds TABLE (MedicationSigUid UNIQUEIDENTIFIER, MedStartDate DATE, MedEndDate DATE)
	INSERT INTO @Meds
	SELECT tm.MedicationSigUid, sig.OverallStartDate, (CASE WHEN COALESCE(sig.OverallStopDate, @RptTimespan_EndDate) <= @RptTimespan_EndDate THEN COALESCE(sig.OverallStopDate, @RptTimespan_EndDate) ELSE @RptTimespan_EndDate END)
	FROM [#tblMedicationList] tm
	INNER JOIN MedicationSIG sig WITH(NOLOCK) on tm.MedicationSIGUid = sig.MedicationSIGUid
	WHERE tm.[reffederaldeaclasscode] = 2

	DELETE t
	FROM [#tblMedicationList] t
	INNER JOIN @Meds m on t.MedicationSIGUid = m.MedicationSigUid
	WHERE DATEDIFF(DAY, MedStartDate, MedEndDate) < 30

	DECLARE @ListAtt TABLE (PatientUid UNIQUEIDENTIFIER, AttachmentGroupUid UNIQUEIDENTIFIER)
	INSERT INTO @ListAtt
	SELECT PersonUid, rag.AttachmentGroupUid
	FROM RelAttachmentGroup rag WITH(NOLOCK)
	INNER JOIN Attachment a WITH(NOLOCK) on rag.AttachmentGroupUid = a.AttachmentGroupUid AND a.FileDate <= @RptTimespan_EndDate
	INNER JOIN AttachmentGroup ag WITH(NOLOCK) on a.AttachmentGroupUid = ag.AttachmentGroupUid
	WHERE (a.AttachmentTypeUid = @OpioidTreatmentAgreement OR ag.AttachmentTypeUid = @OpioidTreatmentAgreement)

	-- Initialize work table
	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
	SELECT @ItemDefinitionUid AS [ItemDefinitionUid]
		, med.[PersonUid]
		, COUNT(la.AttachmentGroupUid) AS [NumeratorValue]                        
		, COUNT(med.[MedicationSIGUid]) AS [DenominatorValue]
		, null AS [YesNo]
	FROM   [#tblMedicationList] AS med
	INNER JOIN [ListeRxStatus] AS sts WITH(NOLOCK) ON  med.[eRxStatusUid] = sts.[eRxStatusUid]
		 AND (sts.[eRxStatusUid] IN(@RxStatusTransmittedSuccessfully, @RxStatusQueuedForTransmission))
	LEFT JOIN @ListAtt la on med.[PersonUid] = la.PatientUid
	WHERE med.[Dispensable] = 1
		AND med.[IsSampleGiven] = 0
		AND med.[IsAdministered] = 0
		AND med.[reffederaldeaclasscode] = 2
		AND [SIGDetailCount] = 1
	GROUP BY med.[PersonUid]
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_E-Prescribing_4_VerifyOpioidAgreement -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_HealthInformationExchange_1_Sending]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_HealthInformationExchange_1_Sending] AS' 
END
GO
--
-- Date    : 2018.12.03
-- Purpose : MU Stage 3
-- TFS     : 43001 - Meaningful Use 2015-2017 Objectives as a Dashboard and Report
--

ALTER PROC [dbo].[2019PI_HealthInformationExchange_1_Sending]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_HealthInformationExchange_1_Sending-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

     DECLARE @UTC_RptTimespan_StartDate DATETIME,@UTC_RptTimespan_EndDate DATETIME
      SELECT @UTC_RptTimespan_StartDate = @RptTimespan_StartDate
      SELECT @UTC_RptTimespan_EndDate   = DATEADD(DAY,1,@RptTimespan_EndDate)

      --RecordDisclosureAudit limit range, -1 day from min referral date and +3 days to max referral date
      DECLARE @RecordDisclosureAudit_StartDate DATE,@RecordDisclosureAudit_EndDate DATE
      SELECT @RecordDisclosureAudit_StartDate = DATEADD(DAY,-1,@RptTimespan_StartDate)
      SELECT @RecordDisclosureAudit_EndDate   = DATEADD(DAY,3,@RptTimespan_EndDate)

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = '1BE16FA8-97F6-40BD-8F59-BCD8BC622E49'

      TRUNCATE TABLE #MetricDataTemp

      ;WITH cte_pr AS (
            select pr.*,dbo.UDF_CQMTestPatient (pr.PatientUid) AS TestPatient
            FROM ViewPatientReferralConsultReport pr 
			INNER JOIN #tblVisitList t on pr.VisitUid = t.VisitUid
            LEFT JOIN PatientReferral p on pr.PatientReferralUid = p.PatientReferralUid
            LEFT JOIN VisitProcedure vp on p.VisitProcedureUid = vp.VisitProcedureUid
            LEFT JOIN ListProcedure lp on vp.ProcedureUid = lp.ProcedureUid      
            WHERE pr.RefType = 'PatientReferral'
                        AND (pr.ReferredByProviderUid IN (SELECT Element FROM dbo.Split(@ProviderUid, ',')) OR @ProviderUid IS NULL)
                        AND pr.ReferralDate >= @UTC_RptTimespan_StartDate AND pr.ReferralDate < @RecordDisclosureAudit_EndDate
                        AND (lp.ProcedureCodeTypeUid IS NULL OR lp.ProcedureCodeTypeUid NOT IN ('1E605C00-13F0-4B95-AEDB-7AA2E30A8BED'))
      ),
      cte_rda AS (
            SELECT [DisclosureDate] ,
                  [DisclosureType] ,
                  [PatientUid] ,
                  rda.[PatientReferralUid] ,
                  [AttachmentGroupUid] ,
                  rda.[VisitUid] ,
                  [IsPortal],
                  [DisclosureMethod],
                  [Status],
                  [DisclosurePurpose]
            FROM RecordDisclosureAudit rda WITH(NOLOCK)
			--LEFT JOIN PatientReferral pr on rda.PatientReferralUid = pr.PatientReferralUid AND pr.ReferredByProviderUid = @ProviderUid
            WHERE DisclosureDate >= @RecordDisclosureAudit_StartDate
                  AND DisclosureType in (1,    -- Complete Chart
                                                      2,    -- Clinical Summary
                                                      11)  -- ContinuityOfCareDocument
                  AND DisclosureMethod IN (1,5,6,7)
                  AND DisclosurePurpose <> 'Released to Patient' --2016.02.23 dmg
                  AND [Status] > 0
      )
      INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
            SELECT @ItemDefinitionUid AS ItemDefinitionUid
                        ,r.PatientUid
                         ,COUNT(distinct CASE WHEN  rda.DisclosureType IS NOT NULL and rda.status = 4 THEN rda.PatientReferralUid
                              ELSE NULL END) AS NumeratorValue            
						,COUNT(distinct CASE WHEN r.PatientReferralUid is not null  and (r.ReferralStatus in ('Initiated', 'Appointment Confirmed')) THEN r.PatientReferralUid
                             ELSE NULL END) AS DenominatorValue 
                        ,null AS YesNo
            FROM cte_pr r 
           LEFT JOIN cte_rda rda ON r.PatientUid=rda.patientuid AND
                                    (
                                          r.VisitUid=rda.VisitUid 
                                          OR r.PatientReferralUid=rda.PatientReferralUid 
                                          OR r.AttachmentGroupUid=rda.AttachmentGroupUid
                                          --OR DATEDIFF(day,r.ReferralDate,rda.DisclosureDate) >= -1
                                    )
            WHERE r.TestPatient = 0
            GROUP BY r.PatientUid
            
      UPDATE #tblMeaningfulUseDetail
      SET NumeratorValue = 
            CASE 
                  WHEN NumeratorValue > DenominatorValue THEN DenominatorValue 
                  ELSE NumeratorValue 
            END
	  WHERE ItemDefinitionUid = @ItemDefinitionUid
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_HealthInformationExchange_1_Sending -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_HealthInformationExchange_2_Receiving]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_HealthInformationExchange_2_Receiving] AS' 
END
GO
--
-- Date    : 2018.12.03
-- Purpose : MU Stage 3
-- TFS     : 43001 - Meaningful Use 2015-2017 Objectives as a Dashboard and Report
--

ALTER PROC [dbo].[2019PI_HealthInformationExchange_2_Receiving]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_HealthInformationExchange_2_Receiving-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

	DECLARE @UTC_RptTimespan_StartDate DATETIME,@UTC_RptTimespan_EndDate DATETIME
	SELECT @UTC_RptTimespan_StartDate = @RptTimespan_StartDate, @UTC_RptTimespan_EndDate = @RptTimespan_EndDate
	SELECT @UTC_RptTimespan_StartDate = '01/01/'+CONVERT(VARCHAR(4),DATEPART(YEAR,@UTC_RptTimespan_StartDate))

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = '1389065B-874A-491F-B10C-D23B07BF853D'

	DECLARE @InitiatedReferrals TABLE (PatientReferralUid UNIQUEIDENTIFIER)
	INSERT INTO @InitiatedReferrals
	SELECT DISTINCT PatientReferralUid 
	FROM PatientReferralHistory 
	WHERE ReferralTrackingStatusUid IN ('0673DB25-454C-44D8-B83F-AFCF97879AAD','3B180FEC-FAE0-4850-AE16-6172CC31F7A7')

	TRUNCATE TABLE #MetricDataTemp

	;WITH cte_Ref AS (
	SELECT vfp.PersonUid AS PatUid
			, rag.VisitUid AS Uid
			, COALESCE(a.AttachmentUid, ag.AttachmentGroupUid) AS AttUid
			, COALESCE(a.FileDate, ag.LastModifiedDate) AS AttDate
			, aa.HasClinicalDocument AS NumID
			, aa.MedicationAllergiesReconciledDate
			, aa.MedicationsReconciledDate
			, aa.ProblemsReconciledDate
			, a.AttachmentTypeUid
			, latDM.ExternalID AS AttachmentTypeID
	FROM #tblPatientList vfp
	INNER JOIN RelAttachmentGroup rag on vfp.PersonUid = rag.PersonUid
	INNER JOIN Visit v on rag.VisitUid = v.VisitUid AND (v.VisitDate >= @RptTimespan_StartDate AND v.VisitDate <= @RptTimespan_EndDate)
	INNER JOIN #tblProviderList prov on v.ProviderUid = prov.ProviderUid
	LEFT JOIN Attachment a on rag.AttachmentGroupUid = a.AttachmentGroupUid
	LEFT JOIN ListAttachmentType latDM on a.AttachmentTypeUid = latDM.AttachmentTypeUid
	LEFT JOIN AttachmentGroup ag on rag.AttachmentGroupUid = ag.AttachmentGroupUid
	INNER JOIN ListAttachmentType lat on (a.AttachmentTypeUid = lat.AttachmentTypeUid OR ag.AttachmentTypeUid = lat.AttachmentTypeUid) AND (lat.AttachmentTypeUid = 'B71B8F20-7B7D-4A7C-9E75-05811A0791AD')
	LEFT JOIN MessageAA aa on rag.RelAttachmentGroupUid = aa.RelAttachmentGroupUid --AND aa.SummaryOfCareReconciledDate IS NOT NULL
	LEFT JOIN Message m on aa.MessageUid = m.MessageUid

	UNION ALL

	SELECT vfp.PersonUid AS PatUid
			, pr.PatientReferralUid AS Uid
			, aa.MessageUid AS AttUid
			, pr.CreatedDate AS AttDate
			, aa.HasClinicalDocument AS NumID
			, aa.MedicationAllergiesReconciledDate
			, aa.MedicationsReconciledDate
			, aa.ProblemsReconciledDate
			, att.AttachmentTypeUid
			, lat.ExternalID AS AttachmentTypeID
	FROM #tblPatientList vfp
	INNER JOIN RelAttachmentGroup r ON vfp.PersonUid = r.PersonUid
	INNER JOIN MessageAA aa ON aa.RelAttachmentGroupUid = r.RelAttachmentGroupUid --AND aa.ElectronicSummaryOfCareReceived = 1
	LEFT JOIN Attachment att on r.AttachmentGroupUid = att.AttachmentGroupUid
	LEFT JOIN ListAttachmentType lat on att.AttachmentTypeUid = lat.AttachmentTypeUid
	INNER JOIN PatientReferral pr on r.PatientReferralUid = pr.PatientReferralUid 
			AND (pr.CreatedDate >= @RptTimespan_StartDate AND pr.CreatedDate <= @RptTimespan_EndDate)
			AND pr.ReferralTrackingStatusUid <> '3B180FEC-FAE0-4850-AE16-6172CC31F7A7'
	INNER JOIN PatientProviderRelationship ppr on pr.PatientProviderRelationshipUid = ppr.PatientProviderRelationshipUid
	INNER JOIN #tblProviderList prov on pr.ReferredByProviderUid = prov.ProviderUid
	INNER JOIN @InitiatedReferrals ir on pr.PatientReferralUid = ir.PatientReferralUid
	)


	--SELECT * FROM cte_Ref
	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
		SELECT @ItemDefinitionUid AS ItemDefinitionUid
				,PatUid
				,COUNT(distinct CASE WHEN MedicationAllergiesReconciledDate IS NOT NULL 
						AND MedicationsReconciledDate IS NOT NULL
						AND ProblemsReconciledDate IS NOT NULL
							THEN Uid
						WHEN AttachmentTypeUid = '91293E86-6AA1-4B30-AA00-7DDD42135D64' THEN Uid
						WHEN AttachmentTypeID = 'DMail' THEN Uid
							ELSE NULL END) AS NumeratorValue
				,COUNT(DISTINCT Uid) AS DenominatorValue
				,NULL AS YesNo
		FROM cte_Ref
		GROUP BY PatUid


	IF EXISTS (
		SELECT TOP 1 *
		FROM #tblMeaningfulUseDetail
		WHERE [ItemDefinitionUid] = @ItemDefinitionUid
	)
    BEGIN
	    UPDATE [#tblMeaningfulUseDetail]
		SET [NumeratorValue] = CASE WHEN [NumeratorValue] > [DenominatorValue] THEN [DenominatorValue] ELSE [NumeratorValue] END
    END
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_HealthInformationExchange_2_Receiving -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_Master_SynchronizeVisitAndPatient]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_Master_SynchronizeVisitAndPatient] AS' 
END
GO
ALTER PROCEDURE [dbo].[2019PI_Master_SynchronizeVisitAndPatient] (
	@Debug [bit] = 0,
	@IncludeTestPatients [bit] = 0
)
AS
BEGIN
	IF (@Debug = 1)
	BEGIN
		SELECT '[2019PI_Master_SynchronizeVisitAndPatient] -- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	UPDATE [#tblVisitList]
		SET [HasPortalAccount] = oa.[HasPortalAccount]
			,[SummaryProvidedToPatient] = CASE WHEN oa.[HasPortalAccount] = 1
							THEN v.[VisitDate]
							ELSE v.[SummaryProvidedToPatient] END 
			,[TestPat] = p.[testPat]
	--select v.*
	from [#tblPatientList] AS p
		INNER JOIN [#tblVisitList] AS v ON p.[PersonUid] = v.[PatientUid]
		OUTER APPLY (SELECT CASE WHEN  p.[HasPortalAccount] = 1
									AND (
										(v.[VisitDate] BETWEEN p.[PortalValid] AND p.[PortalExpire])
										OR (p.[PortalValid] IS NULL AND v.[VisitDate] <= p.[PortalExpire])
										OR (p.[PortalExpire] IS NULL AND p.[PortalValid] <= v.[VisitDate])
										OR (p.[PortalValid] IS NULL AND p.[PortalExpire] IS NULL)
										)
							THEN 1
							ELSE 0 END AS [HasPortalAccount]) AS oa

	IF @IncludeTestPatients = 0
	BEGIN
		DELETE [#tblPatientList] where [TestPat] = 1
	END

	DELETE [#tblVisitList]
	FROM [#tblVisitList] AS v
		LEFT JOIN [#tblPatientList] AS p ON v.[PatientUid] = p.[PersonUid]
	WHERE p.[PersonUid] IS NULL

	IF @Debug = 1
	BEGIN
		select *
		from [#tblVisitList]

		select *
		from [#tblPatientList]
	END

	IF (@Debug = 1)
	BEGIN
		SELECT '[2019PI_Master_SynchronizeVisitAndPatient] -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_Master_PopulateMedicationList]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_Master_PopulateMedicationList] AS' 
END
GO
ALTER PROC [dbo].[2019PI_Master_PopulateMedicationList]
(
    @ProviderUid			[varchar](max),
    @ProviderBilling		[bit],
	@RptTimespan_StartDate	[date],
	@RptTimespan_EndDate	[date],
	@IncludeTestPatients	[bit] = 0,
	@Debug					[bit] = 0
)	
AS
BEGIN
	IF (@Debug = 1)
	BEGIN
		SELECT '[2019PI_Master_PopulateMedicationList] -- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	--CreatedDateTime is a DATETIME UTC value, DiscontinueRecordDate is a DATE
	DECLARE @UTC_RptTimespan_StartDate [datetime] = [dbo].[getPracticeUTCDateTime] (@RptTimespan_StartDate),
		@UTC_RptTimespan_EndDate [datetime] = DATEADD(DAY, 1, [dbo].[getPracticeUTCDateTime](@RptTimespan_EndDate)),
		@DiscontinueReason_Deleted [uniqueidentifier] = 'E322D823-F96D-4070-AF3B-AAB21B21E6A9',
		@VisitTypeStrikeOut [uniqueidentifier] = 'FB954167-9D1C-43B7-9F5B-A76260654C96',
		@PatientTypeTest [uniqueidentifier] = '77A41E18-5554-4874-9454-54DC3D7A33A0'

	CREATE TABLE [#tblMedicationList_Sub]
	(
		[MedicationSIGUid]					[uniqueidentifier] NOT NULL,
		[CreatedDate]						[datetime] NOT NULL,
		[RelVisitMedicationUid]				[uniqueidentifier],
		[PersonUid]							[uniqueidentifier],
		[TestPat]							[bit],
		[LicensedHealthcareProfessional]	[bit] NOT NULL,
		[Dispensable]						[bit] NULL,
		[IsSampleGiven]						[bit] NOT NULL,
		[IsAdministered]					[bit] NOT NULL,
		[reffederaldeaclasscode]			[int] NULL,
		[SIGDetailCount]					[int] NULL,
		[eRxStatusUid]						[uniqueidentifier]
	)

	INSERT [#tblMedicationList_Sub] ([MedicationSIGUid]
		,[CreatedDate]
		,[RelVisitMedicationUid]
		,[PersonUid]
		,[TestPat]
		,[LicensedHealthcareProfessional]
		,[Dispensable]
		,[IsSampleGiven]
		,[IsAdministered]
		,[reffederaldeaclasscode]
		,[SIGDetailCount]
		,[eRxStatusUid]
	)
	SELECT DISTINCT ms.[MedicationSIGUid]
		,ms.[CreatedDateTime]
		,rvm.[RelVisitMedicationUid]
		,p.[PersonUid]
		,[TestPatient].[IsTestPatient] AS [TestPat]
		,COALESCE(u.[LicensedHealthcareProfessional], 0) AS [LicensedHealthcareProfessional]
		,CASE WHEN fdb_d.[medid] IS NOT NULL THEN 1 ELSE 0 END AS [Dispensable]
		,ms.[IsSampleGiven]
		,ms.[IsAdministered]
		,COALESCE(ms.FederalDEAClassCode,lms.[Schedule], fdb_d.[reffederaldeaclasscode])
		,(SELECT COUNT([SIGDetailUid]) FROM [SIGDetail] with(nolock) WHERE [MedicationSIGUid] = ms.[MedicationSIGUid]) AS [SIGDetailCount]
		,rvm.[eRxStatusUid]
	FROM #tblVisitList AS vv
		INNER JOIN [Visit] AS v WITH(NOLOCK) ON vv.[VisitUid] = v.[VisitUid]
			AND vv.[PatientUid] = v.[PatientUid]
			AND (v.[VisitTypeUid] is null or v.[VisitTypeUid] != @VisitTypeStrikeOut)
		INNER JOIN [RelVisitMedication] AS rvm WITH(NOLOCK) ON v.[VisitUid] = rvm.[VisitUid]
		INNER JOIN [MedicationSIG] AS ms WITH(NOLOCK) ON rvm.[MedicationSIGUid] = ms.[MedicationSIGUid]
			AND rvm.[Prescribed] = 1 
		INNER JOIN [Person] AS p WITH(NOLOCK) on v.[PatientUid] = p.[PersonUid]
		LEFT JOIN [UserPRM] AS u WITH(NOLOCK) ON ms.[CreatedBy] = u.[PersonUid]
		LEFT JOIN [dbo].[NDD_SearchDispensable] AS fdb_d with(nolock) ON fdb_d.[IsDelete] = 0 AND fdb_d.[medid] = ms.[FDB_MEDID]
		LEFT JOIN [RelMedicationStateScheduledDrugName] AS ssd WITH(NOLOCK) on fdb_d.[mnid] = [dbo].[GUIDToInt](ssd.[DrugNameUid])
		LEFT JOIN [ListMedicationStateScheduled] AS lms WITH(NOLOCK) on ssd.[MedicationStateScheduledUid] = lms.[MedicationStateScheduledUid]
		CROSS APPLY
		(
			SELECT (
				CASE WHEN EXISTS(
					SELECT TOP 1 *
					FROM [RelPatientStatus] AS rps WITH(NOLOCK) 
					WHERE rps.[PatientUid]=v.[PatientUid] 
						AND rps.[PatientStatusUid] = @PatientTypeTest
					) THEN 1
					ELSE 0
				END
				) AS [IsTestPatient]
		) AS [TestPatient]
	WHERE NOT EXISTS(SELECT TOP 1 * FROM [RelPatientStatus] AS rps WITH(NOLOCK) WHERE rps.[PatientUid] = p.[PersonUid] AND rps.[PatientStatusUid] = @PatientTypeTest)
		AND (p.[DeathDate] IS NULL OR p.[DeathDate] >= @RptTimespan_StartDate)
		AND (
			v.[VisitTypeUid] <> @visitTypeStrikeOut
			OR v.[VisitTypeUid] IS NULL
			)
		AND ms.[CreatedDateTime] >= @UTC_RptTimespan_StartDate AND ms.[CreatedDateTime] < @UTC_RptTimespan_EndDate
		AND ms.[ProviderUid] IN (SELECT [ProviderUid] FROM [#tblProviderList])
		AND (
				(ms.[DiscontinueReasonUid] IS NULL) 
			or 
				(ms.[DiscontinueRecordDate] >= @RptTimespan_StartDate 
					AND ms.[DiscontinueReasonUid] != @DiscontinueReason_Deleted)
			)

	INSERT INTO #tblMedicationList
	SELECT DISTINCT s.* FROM #tblMedicationList_Sub s
	INNER JOIN (SELECT MedicationSIGUid AS MaxUid, MAX(CONVERT(TINYINT,reffederaldeaclasscode)) AS MaxClassCode FROM #tblMedicationList_Sub GROUP BY MedicationSIGUid) ms on s.MedicationSIGUid = ms.MaxUid
			AND s.reffederaldeaclasscode = ms.MaxClassCode

	IF @IncludeTestPatients = 0 
	BEGIN
		DELETE #tblMedicationList
		WHERE [TestPat] = 1
	END

	IF (@Debug = 1)
	BEGIN
		SELECT '[2019PI_Master_PopulateMedicationList] -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_Master_PopulateOrderList]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_Master_PopulateOrderList] AS' 
END
GO
ALTER PROC [dbo].[2019PI_Master_PopulateOrderList]
(
--Move Provider and Billing/Rendering logic to populatevisitlist
    @ProviderUid			[varchar](max),
    @ProviderBilling		[bit],
	@RptTimespan_StartDate	[date],
	@RptTimespan_EndDate	[date],
	@IncludeTestPatients	[bit] = 0,
	@Debug					[bit] = 0
)	
AS
BEGIN
	IF (@Debug = 1)
	BEGIN
		SELECT '[2019PI_Master_PopulateOrderList] -- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	DECLARE @VisitTypeStrikeOut [uniqueidentifier] = 'FB954167-9D1C-43B7-9F5B-A76260654C96',
		@PatientTypeTest [uniqueidentifier] = '77A41E18-5554-4874-9454-54DC3D7A33A0'

	--No UTC conversion, OrderDate is a DATE field
	INSERT [#tblOrderList] ([ObservationOrderUid]
		,[PatientUid]
		,[TestPat]
		,[VPUid]
		,[CreatedBy]
		,[OrderDate]
		,[ProcedureCodeTypeUid]
		,[ProcedureCodeTypeName]
		,[AttachmentTypeUid]
		,[AttachmentTypeName]
		,[LicensedHealthcareProfessional]
		,[ImageResultsDirectlyAccessible]
		,[ResultStatusID]
	)
	--**JRB** ADD CreatedBy uid to the #tblOrderList to exclude nulls for order measures
	SELECT DISTINCT oo.[ObservationOrderUid]
		,oo.[PatientUid]
		,[TestPatient].[IsTestPatient] AS [TestPat]
		,vp.[VisitProcedureUid]
		,oo.[CreatedBy]
		,COALESCE(oo.[OrderDate], oo.[PerformDate], oo.[CreatedDateTime]) AS [OrderDate]
		,lp.[ProcedureCodeTypeUid]
		,pct.[Name]
		,CD.[AttachmentTypeUid]
		,COALESCE(loat.[Name], ooat.[Name]) AS [Name]
		,COALESCE(u.[LicensedHealthcareProfessional], 0) AS [LicensedHealthcareProfessional]
		,lp.[ImageResultsDirectlyAccessible]
		, oo.[ResultStatusID]
	FROM [#tblVisitList] AS vv
		INNER JOIN [ObservationOrder] AS oo WITH(NOLOCK) ON vv.[PatientUid] = oo.[PatientUid]
		INNER JOIN [Person] AS pat WITH(NOLOCK) on oo.[PatientUid] = pat.[PersonUid]
		LEFT JOIN [Visit] AS v WITH(NOLOCK) on oo.[VisitUid] = v.[VisitUid]
		LEFT JOIN [VisitProcedure] AS vp WITH(NOLOCK) on oo.[VisitProcedureUid] = vp.[VisitProcedureUid] 
		LEFT JOIN [ListProcedure] AS lp WITH(NOLOCK) on vp.[ProcedureUid] = lp.[ProcedureUid]
		LEFT JOIN [ListProcedureCodeType] AS pct WITH(NOLOCK) ON lp.[ProcedureCodeTypeUid] = pct.[ProcedureCodeTypeUid]
		LEFT JOIN [ListLaboratoryOrder] AS lo WITH(NOLOCK) ON oo.[LaboratoryOrderUid] = lo.[LaboratoryOrderUid]
		LEFT JOIN [ListAttachmentType] AS loat WITH(NOLOCK) on lo.[AttachmentTypeUid] = loat.[AttachmentTypeUid]
		LEFT JOIN [ListAttachmentType] AS ooat WITH(NOLOCK) on oo.[AttachmentTypeUid] = ooat.[AttachmentTypeUid]
		LEFT JOIN [UserPRM] AS u WITH(NOLOCK) ON oo.[CreatedBy] = u.[PersonUid]
		CROSS APPLY (
			SELECT COALESCE(oo.[OrderDate], CONVERT([date], oo.[CreatedDateTime])) AS [CDate]
				,COALESCE(loat.[AttachmentTypeUid], ooat.[AttachmentTypeUid]) AS [AttachmentTypeUid]
		) AS [CD]
		CROSS APPLY
		(
			SELECT (
				CASE WHEN EXISTS(
					SELECT TOP 1 *
					FROM [RelPatientStatus] AS rps WITH(NOLOCK) 
					WHERE rps.[PatientUid]=v.[PatientUid] 
						AND rps.[PatientStatusUid] = @PatientTypeTest
					) THEN 1
					ELSE 0
				END
				) AS [IsTestPatient]
		) AS [TestPatient]
	WHERE (pat.[DeathDate] IS NULL OR pat.[DeathDate] >= @RptTimespan_StartDate)
		AND CD.[CDate] BETWEEN @RptTimespan_StartDate AND @RptTimespan_EndDate
		AND oo.[OrderProviderUid] IN (SELECT [ProviderUid] FROM [#tblProviderList])
		AND oo.[IsDelete] = 0
		AND oo.[ResultStatusID] > - 1
		AND vp.[NegationReasonUid] IS NULL
		AND (vp.[IsDelete] = 0 or vp.[IsDelete] IS NULL)
		AND (
			v.[VisitTypeUid] <> @visitTypeStrikeOut
			OR v.[VisitTypeUid] IS NULL
			)

	IF @IncludeTestPatients = 0 
	BEGIN
		DELETE #tblOrderList
		WHERE [TestPat] = 1
	END

	IF (@Debug = 1)
	BEGIN
		SELECT '[2019PI_Master_PopulateOrderList] -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FindEduFormsForVisit]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[FindEduFormsForVisit] AS' 
END
GO
ALTER PROCEDURE [dbo].[FindEduFormsForVisit]
	-- Add the parameters for the stored procedure here
	@ProviderUid VARCHAR(MAX) = NULL
	,@ProviderBilling BIT = 0
	,@StartDate DATE = NULL
	,@EndDate DATE = NULL
	,@PatientUid UNIQUEIDENTIFIER = NULL
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	DECLARE @VisitUids TABLE (VisitUid UNIQUEIDENTIFIER, VisitDate DATE)
	INSERT INTO @VisitUids
	SELECT VisitUid, VisitDate
	FROM Visit
	WHERE (@PatientUid IS NULL OR PatientUid = @PatientUid)
	AND ((@StartDate IS NULL OR VisitDate >= @StartDate) AND (@EndDate IS NULL OR VisitDate <= @EndDate))
	AND (
		(@ProviderBilling = 1 AND [ProviderUid] IN (SELECT [ProviderUid] FROM [#tblProviderList])) 
		OR (@ProviderBilling = 0 AND [RenderingProviderUid] IN (SELECT [ProviderUid] FROM [#tblProviderList])) 
		)

	INSERT INTO #EduForms
	SELECT DISTINCT VisitUid, VisitDate, ObjectUid, ObjectName FROM
	(
		SELECT v.VisitUid, v.VisitDate, VisitEduFormUid AS ObjectUid, 'VisitEduForm' AS ObjectName
		FROM @VisitUids v
		INNER JOIN [VisitEduForm] vef on v.VisitUid = vef.VisitUid AND (vef.[ReportUid] IS NULL OR vef.[ReportUid] != '900377C9-D12C-4F73-B5F0-429FF928DEF8')

		UNION ALL

		SELECT v.VisitUid, v.VisitDate, vp.VisitProcedureUid, 'VisitProcedure'
		FROM @VisitUids v
		INNER JOIN VisitProcedure vp on v.VisitUid = vp.VisitUid
		INNER JOIN RelEduFormProcedure relp on vp.ProcedureUid = relp.ProcedureUid
		INNER JOIN RelEduFormAssociation rela on relp.RelEduFormAssociationUid = rela.RelEduFormAssociationUid
		INNER JOIN ListEduForm lef on rela.EduFormUid = lef.EduFormUid

		UNION ALL

		SELECT v.VisitUid, v.VisitDate, vd.VisitDiagnosisUid, 'VisitDiagnosis'
		FROM @VisitUids v
		INNER JOIN VisitDiagnosis vd on v.VisitUid = vd.VisitUid
		INNER JOIN RelEduFormDiagnosis reld on vd.Code = reld.Code9 OR vd.Code10 = reld.Code10
		INNER JOIN RelEduFormAssociation rela2 on reld.RelEduFormAssociationUid = rela2.RelEduFormAssociationUid
		INNER JOIN ListEduForm lef2 on rela2.EduFormUid = lef2.EduFormUid

		UNION ALL

		SELECT v.VisitUid, v.VisitDate, VisitCCUid, 'VisitCC'
		FROM @VisitUids v
		INNER JOIN VisitCC cc on v.VisitUid = cc.VisitUid
		INNER JOIN RelCCSystemSymptom rcc on cc.CCSymptomUid = rcc.CCSymptomUid-- OR cc.CCSystemUid = rcc.CCSystemUid
		INNER JOIN RelEduFormCCSymptom relc on rcc.RelCCSystemSymptomUid = relc.RelCCSystemSymptomUid
		INNER JOIN RelEduFormAssociation rela3 on relc.RelEduFormAssociationUid = rela3.RelEduFormAssociationUid
		INNER JOIN ListEduForm lef3 on rela3.EduFormUid = lef3.EduFormUid

		UNION ALL

		SELECT v.VisitUid, v.VisitDate, oo.ObservationOrderUid, 'ObservationOrder'
		FROM @VisitUids v
		INNER JOIN ObservationOrder oo on v.VisitUid = oo.VisitUid
		INNER JOIN ObservationValue ov on oo.ObservationOrderUid = ov.ObservationOrderUid
		INNER JOIN ListObservationItem loi on ov.ObservationItemUid = loi.ObservationItemUid
		INNER JOIN RelEduFormObservationItem relo on loi.ObservationItemUid = relo.ObservationItemUid
		INNER JOIN RelEduFormAssociation rela4 on relo.RelEduFormAssociationUid = rela4.RelEduFormAssociationUid
		INNER JOIN ListEduForm lef4 on rela4.EduFormUid = lef4.EduFormUid
	) a

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_Master_PopulateVisitList]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_Master_PopulateVisitList] AS' 
END
GO
ALTER PROC [dbo].[2019PI_Master_PopulateVisitList]
(
--Move Provider and Billing/Rendering logic to populatevisitlist
    @ProviderUid			[varchar](max),
    @ProviderBilling		[bit],
	@RptTimespan_StartDate	[date],
	@RptTimespan_EndDate	[date],
	@Debug					[bit] = 0,
	@ServiceSiteUID			[varchar](max) = null, 
	@FinancialCenterUID		[varchar](max) = null
)	
AS
BEGIN
	IF (@Debug = 1)
	BEGIN
		SELECT '[2019PI_Master_PopulateVisitList] -- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	--        
	-- History of Changes
	--                                       
	--   Name      Date            Description
	--   ==================================================================================================================
	-- 

	DECLARE @VisitTypeStrikeOut [uniqueidentifier] = 'FB954167-9D1C-43B7-9F5B-A76260654C96',
		@WithinDays [int] = 3

	CREATE TABLE [#ServiceSites]
	(
		[ServiceSiteUID] [uniqueidentifier] primary key
	) 
	CREATE TABLE [#FinancialCenters]
	(
		[FinancialCenterUID] [uniqueidentifier] primary key
	) 

	IF @ServiceSiteUID IS NOT NULL
	BEGIN
		SET @ServiceSiteUID = RTRIM(LTRIM(@ServiceSiteUID))
	END

	IF @ServiceSiteUID IS NULL OR LEN(@ServiceSiteUID) < 1 
	BEGIN
		INSERT INTO #ServiceSites
		SELECT [ServiceSiteUID]
		FROM [ListServiceSite] with(nolock)
	END
	ELSE
	BEGIN
		INSERT INTO #ServiceSites 
		SELECT DISTINCT lss.[ServiceSiteUid]
		FROM [dbo].[Split](@ServiceSiteUID, ',') AS vss
			INNER JOIN [ListServiceSite] AS lss with(nolock) ON vss.[Element] = lss.[ServiceSiteUid]
	END

	IF @FinancialCenterUID IS NOT NULL
	BEGIN
		SET @FinancialCenterUID = RTRIM(LTRIM(@FinancialCenterUID))
	END

	IF @FinancialCenterUID IS NULL OR LEN(@FinancialCenterUID) < 1
	BEGIN
		INSERT INTO #FinancialCenters
		SELECT [FinancialCenterUid]
		FROM [FinancialCenter] with(nolock)
	END
	ELSE
	BEGIN
		INSERT INTO #FinancialCenters
		SELECT DISTINCT lfc.[FinancialCenterUid]
		FROM [dbo].[Split](@FinancialCenterUID, ',') AS vfc
			INNER JOIN [FinancialCenter] AS lfc with(nolock) ON vfc.[Element] = lfc.[FinancialCenterUid]
	END

	BEGIN --EduForms
		CREATE TABLE #EduForms (VisitUid UNIQUEIDENTIFIER, VisitDate DATE, ObjectUid UNIQUEIDENTIFIER, ObjectName VARCHAR(50))
		EXEC FindEduFormsForVisit
			@ProviderUid = @ProviderUid
			,@ProviderBilling = @ProviderBilling
			,@StartDate = @RptTimespan_StartDate
			,@EndDate = @RptTimespan_EndDate
	END


	--VisitDate is a DATE field and does NOT get UTC adjustment
	INSERT INTO #tblVisitList (
		[VisitUid],
		[PatientUid],
		[VisitDate],
		[ProviderUid],
		[RenderingProviderUid],
		[SummaryProvidedToPatient],
		[HasPortalAccount],
		[PatientDeclinedClinicalSummary],
		[LastSavedByUid],
		[SavedByBillingProvider],
		[SavedByRenderingProvider],
		[TransitionOfCare],
		[MedicationChecked],
		[DrugAllergyChecked],
		[ProblemChecked],
		[IsEM],
		[IsVP],
		[HasEduForm],
		[PrintedDate]
		)
	SELECT v.[VisitUid]
		,v.[PatientUid]
		,v.[VisitDate]
		,v.[ProviderUid]
		,v.[RenderingProviderUid]
		,[VisitRDADisclosureDate].[DisclosureDate]
		,NULL AS [HasPortalAccount]
		,v.[PatientDeclinedClinicalSummary]
		,v.[LastSavedByUid]
		,v.[SavedByBillingProvider]
		,v.[SavedByRenderingProvider]
		,vc.[TransitionOfCare]
		,vc.[MedicationChecked] AS [MedicationChecked]
		,vc.DrugAllergyChecked
		,vc.ProblemDiagnosisChecked
		,MAX(CONVERT(SMALLINT,COALESCE(IsEM.[IsEM],0)))  AS [IsEm]
		,MAX(CONVERT(SMALLINT,COALESCE(IsVP.[IsPerformed],0))) AS [IsVP]
		,MAX(CASE WHEN vef.[VisitUid] IS NOT NULL THEN 1 ELSE 0 END) AS [HasEduForm]
		,MIN(vef.VisitDate) AS [PrintedDate]
	FROM Visit AS v with(nolock)
		INNER JOIN #ServiceSites AS Sites on Sites.[ServiceSiteUID] = v.[ServiceSiteUid]
		INNER JOIN #FinancialCenters AS Fin on fin.[FinancialCenterUID] = v.[FinancialCenterUid]
		LEFT JOIN [VisitComplexity] AS vc ON v.[VisitUid] = vc.[VisitUid]
		LEFT JOIN [VisitProcedure] AS IsEm on v.[VisitUid] = IsEm.[VisitUid] AND IsEm.[IsEM] <> 0
		LEFT JOIN [VisitProcedure] AS IsVP on v.[VisitUid] = IsVP.[VisitUid] AND IsVP.[IsPerformed] <> 0
		LEFT JOIN #EduForms vef ON v.[Visituid] = vef.[VisitUid]
		--LEFT JOIN [VisitEduForm] AS vef ON v.[Visituid] = vef.[VisitUid] AND (vef.[ReportUid] IS NULL OR vef.[ReportUid] != '900377C9-D12C-4F73-B5F0-429FF928DEF8')
		CROSS APPLY
		(
			SELECT MIN([DisclosureDate]) AS [DisclosureDate]
			FROM [RecordDisclosureAudit] WITH(NOLOCK) 
			WHERE [DisclosureDate] BETWEEN DATEADD(DAY, -1, v.[VisitDate]) AND DATEADD(DAY,@WithinDays,v.[VisitDate])
				AND ([PatientUid] = v.[PatientUid]	OR [VisitUid] = v.[VisitUid])
				AND [DisclosureType] in (1,    -- Complete Chart
										2,    -- Clinical Summary
										11)  -- ContinuityOfCareDocument
		) AS [VisitRDADisclosureDate]
	WHERE  v.[VisitDate] BETWEEN @RptTimespan_StartDate AND @RptTimespan_EndDate
			AND (v.[VisitTypeUid] is null or v.[VisitTypeUid] != @VisitTypeStrikeOut)
			AND (
				(v.[ProviderUid] IN (SELECT [ProviderUid] FROM [#tblProviderList]) AND @ProviderBilling = 1) 
				OR (v.[RenderingProviderUid] IN (SELECT [ProviderUid] FROM [#tblProviderList]) AND @ProviderBilling = 0) 
				)
	GROUP BY v.[VisitUid]
		,v.[PatientUid]
		,v.[VisitDate]
		,v.[ProviderUid]
		,v.[RenderingProviderUid]
		,[VisitRDADisclosureDate].[DisclosureDate]
		--,[HasPortalAccount]
		,v.[PatientDeclinedClinicalSummary]
		,v.[LastSavedByUid]
		,v.[SavedByBillingProvider]
		,v.[SavedByRenderingProvider]
		,vc.[TransitionOfCare]
		,vc.[MedicationChecked]
		,vc.DrugAllergyChecked
		,vc.ProblemDiagnosisChecked

	IF (@Debug = 1)
	BEGIN
		SELECT '[MUIII_Master_PopulateVisitList] -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_Master_PopulateProviderList]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_Master_PopulateProviderList] AS' 
END
GO
ALTER PROCEDURE [dbo].[2019PI_Master_PopulateProviderList]
    @ProviderUid [varchar](max),
	@HasProviderUid [bit] out
AS
BEGIN
	SET NOCOUNT ON;

	IF @ProviderUid IS NOT NULL
	BEGIN
		SET @ProviderUid = RTRIM(LTRIM(@ProviderUid))
	END

	IF @ProviderUid IS NULL OR LEN(@ProviderUid) < 1
	BEGIN
		SET @HasProviderUid = 0
		INSERT [#tblProviderList]
		SELECT [PersonUid]
		FROM [ViewFindProvider] with(nolock)
	END
	ELSE
	BEGIN
		SET @HasProviderUid = 1
		INSERT [#tblProviderList]
		SELECT DISTINCT vfp.[PersonUid]
		FROM [dbo].[Split](@ProviderUid, ',') AS vp
			INNER JOIN [ViewFindProvider] AS vfp with(nolock) ON vp.[Element] = vfp.[PersonUid]
	END
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FillPDMPPatsTable]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[FillPDMPPatsTable] AS' 
END
GO
ALTER PROCEDURE [dbo].[FillPDMPPatsTable]
AS
BEGIN


	IF EXISTS (select * from sys.tables where name='cus_PDMP_Pats')
	BEGIN
		IF COL_LENGTH('dbo.cus_PDMP_Pats', 'ChangeDate') IS NULL
		BEGIN
			DROP TABLE cus_PDMP_Pats
		END
	END

	IF NOT EXISTS (select * from sys.tables where name='cus_PDMP_Pats')
	BEGIN
		CREATE TABLE cus_PDMP_Pats (PatientUid UNIQUEIDENTIFIER,  Description VARCHAR(MAX), ChangeDate DATETIME)
	END

	IF NOT EXISTS (SELECT 1 FROM ListIntegrationPartner WHERE IntegrationPartnerUid IN ('685A5D14-0499-46FB-B16A-0F69D94B74E5','39F55A0C-68DA-475F-9755-748A25AD0B31') AND Inactive = 0)
		RETURN;

	DECLARE
		@ProviderUid			[varchar](max) = NULL,
		@ProviderBilling		[bit] = 0,
		@RptTimespan_StartDate	[date] = DATEADD(DAY, -365, GETUTCDATE()),
		@RptTimespan_EndDate	[date] = GETUTCDATE(),
		@IncludeTestPatients	[bit] = 0,
		@Debug					[bit] = 0,
		@IP_LMD					[date] = NULL

		SELECT @IP_LMD = MIN(LastModifiedDate) FROM ListIntegrationPartner WHERE IntegrationPartnerUid IN ('685A5D14-0499-46FB-B16A-0F69D94B74E5','39F55A0C-68DA-475F-9755-748A25AD0B31') AND Inactive = 0

		CREATE TABLE [#tblProviderList]
		(
			[ProviderUid] [uniqueidentifier] NOT NULL primary key clustered
		)

		SELECT @RptTimespan_StartDate = COALESCE(MAX(ChangeDate), @IP_LMD)
				,@RptTimespan_EndDate = GETUTCDATE()
		FROM cus_PDMP_Pats
	 
		DECLARE @HasProviderUid [bit] = 0
		EXEC [2019PI_Master_PopulateProviderList] @ProviderUid, @HasProviderUid out

		CREATE TABLE [#tblMedicationList]
		(
			[MedicationSIGUid]					[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
			[CreatedDate]						[datetime] NOT NULL,
			[RelVisitMedicationUid]				[uniqueidentifier],
			[PersonUid]							[uniqueidentifier],
			[TestPat]							[bit],
			[LicensedHealthcareProfessional]	[bit] NOT NULL,
			[Dispensable]						[bit] NULL,
			[IsSampleGiven]						[bit] NOT NULL,
			[IsAdministered]					[bit] NOT NULL,
			[reffederaldeaclasscode]			[bit] NULL,
			[SIGDetailCount]					[int] NULL,
			[eRxStatusUid]						[uniqueidentifier]
		)

	CREATE TABLE [#tblVisitList]
		(
			[VisitUid]							[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
			[VisitDate]							[date]         NOT NULL,
			[PatientUid]						[uniqueidentifier] NOT NULL,
			[TestPat]					   		[bit],
			[IsEM]								[bit],
			[IsVP]								[bit],
			[ProviderUid]						[varchar](max),
			[RenderingProviderUid]				[varchar](max),
			[LastSavedByUid]					[uniqueidentifier],
			[SavedByBillingProvider]			[bit],
			[SavedByRenderingProvider]			[bit],
			[TransitionOfCare]					[bit],
			[MedicationChecked]					[bit],
			[DrugAllergyChecked]				[bit],
			[ProblemChecked]					[bit],
			[SummaryProvidedToPatient]			[date],
			[PatientDeclinedClinicalSummary]	[bit],
			[HasEduForm]						[bit],
			[HasPortalAccount]					[bit],
			[PrintedDate]						[date]
		)
		--
		-- PopulateVisitList
		EXEC [2019PI_Master_PopulateVisitList] @ProviderUid,
			@ProviderBilling,
			@RptTimespan_StartDate,
			@RptTimespan_EndDate,
			@Debug,
			NULL,
			NULL

		--CreatedDateTime is a DATETIME UTC value, DiscontinueRecordDate is a DATE
		DECLARE @UTC_RptTimespan_StartDate [datetime] = [dbo].[getPracticeUTCDateTime] (@RptTimespan_StartDate),
			@UTC_RptTimespan_EndDate [datetime] = DATEADD(DAY, 1, [dbo].[getPracticeUTCDateTime](@RptTimespan_EndDate)),
			@DiscontinueReason_Deleted [uniqueidentifier] = 'E322D823-F96D-4070-AF3B-AAB21B21E6A9',
			@VisitTypeStrikeOut [uniqueidentifier] = 'FB954167-9D1C-43B7-9F5B-A76260654C96',
			@PatientTypeTest [uniqueidentifier] = '77A41E18-5554-4874-9454-54DC3D7A33A0'

		INSERT #tblMedicationList ([MedicationSIGUid]
			,[CreatedDate]
			,[RelVisitMedicationUid]
			,[PersonUid]
			,[TestPat]
			,[LicensedHealthcareProfessional]
			,[Dispensable]
			,[IsSampleGiven]
			,[IsAdministered]
			,[reffederaldeaclasscode]
			,[SIGDetailCount]
			,[eRxStatusUid]
		)
		SELECT DISTINCT ms.[MedicationSIGUid]
			,ms.[CreatedDateTime]
			,rvm.[RelVisitMedicationUid]
			,p.[PersonUid]
			,[TestPatient].[IsTestPatient] AS [TestPat]
			,COALESCE(u.[LicensedHealthcareProfessional], 0) AS [LicensedHealthcareProfessional]
			,CASE WHEN fdb_d.[medid] IS NOT NULL THEN 1 ELSE 0 END AS [Dispensable]
			,ms.[IsSampleGiven]
			,ms.[IsAdministered]
			,COALESCE(lms.[Schedule], fdb_d.[reffederaldeaclasscode])
			,(SELECT COUNT([SIGDetailUid]) FROM [SIGDetail] with(nolock) WHERE [MedicationSIGUid] = ms.[MedicationSIGUid]) AS [SIGDetailCount]
			,rvm.[eRxStatusUid]
		FROM #tblVisitList AS vv
			INNER JOIN [Visit] AS v WITH(NOLOCK) ON vv.[VisitUid] = v.[VisitUid]
				AND vv.[PatientUid] = v.[PatientUid]
				AND (v.[VisitTypeUid] is null or v.[VisitTypeUid] != @VisitTypeStrikeOut)
			INNER JOIN [RelVisitMedication] AS rvm WITH(NOLOCK) ON v.[VisitUid] = rvm.[VisitUid]
			INNER JOIN [MedicationSIG] AS ms WITH(NOLOCK) ON rvm.[MedicationSIGUid] = ms.[MedicationSIGUid]
				AND rvm.[Prescribed] = 1 
			INNER JOIN [Person] AS p WITH(NOLOCK) on v.[PatientUid] = p.[PersonUid]
			LEFT JOIN [UserPRM] AS u WITH(NOLOCK) ON ms.[CreatedBy] = u.[PersonUid]
			LEFT JOIN [dbo].[NDD_SearchDispensable] AS fdb_d with(nolock) ON fdb_d.[IsDelete] = 0 AND fdb_d.[medid] = ms.[FDB_MEDID]
			LEFT JOIN [RelMedicationStateScheduledDrugName] AS ssd WITH(NOLOCK) on fdb_d.[mnid] = [dbo].[GUIDToInt](ssd.[DrugNameUid])
			LEFT JOIN [ListMedicationStateScheduled] AS lms WITH(NOLOCK) on ssd.[MedicationStateScheduledUid] = lms.[MedicationStateScheduledUid]
			CROSS APPLY
			(
				SELECT (
					CASE WHEN EXISTS(
						SELECT TOP 1 *
						FROM [RelPatientStatus] AS rps WITH(NOLOCK) 
						WHERE rps.[PatientUid]=v.[PatientUid] 
							AND rps.[PatientStatusUid] = @PatientTypeTest
						) THEN 1
						ELSE 0
					END
					) AS [IsTestPatient]
			) AS [TestPatient]
		WHERE NOT EXISTS(SELECT TOP 1 * FROM [RelPatientStatus] AS rps WITH(NOLOCK) WHERE rps.[PatientUid] = p.[PersonUid] AND rps.[PatientStatusUid] = @PatientTypeTest)
			AND (p.[DeathDate] IS NULL OR p.[DeathDate] >= @RptTimespan_StartDate)
			AND (
				v.[VisitTypeUid] <> @visitTypeStrikeOut
				OR v.[VisitTypeUid] IS NULL
				)
			AND ms.[CreatedDateTime] >= @UTC_RptTimespan_StartDate AND ms.[CreatedDateTime] < @UTC_RptTimespan_EndDate
			AND ms.[ProviderUid] IN (SELECT [ProviderUid] FROM [#tblProviderList])
			AND (
					(ms.[DiscontinueReasonUid] IS NULL) 
				or 
					(ms.[DiscontinueRecordDate] >= @RptTimespan_StartDate 
						AND ms.[DiscontinueReasonUid] != @DiscontinueReason_Deleted)
				)

		IF @IncludeTestPatients = 0 
		BEGIN
			DELETE #tblMedicationList
			WHERE [TestPat] = 1
		END

		INSERT INTO cus_PDMP_Pats
		SELECT DISTINCT a.PatientUid, Description, a.ChangeDate
		FROM #tblMedicationList m
		INNER JOIN Audit a on m.PersonUid = a.PatientUid 
			AND a.ChangeDate >= @RptTimespan_StartDate
			AND (a.Description LIKE '%Appriss%' or Description LIKE '%LogiCoy%')

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_Master_PopulatePatientList]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_Master_PopulatePatientList] AS' 
END
GO
ALTER PROC [dbo].[2019PI_Master_PopulatePatientList]
(
	@ProviderUid			[varchar](max),  
	@RptTimespan_StartDate	[date],
	@RptTimespan_EndDate	[date],
	@ProviderBilling		[bit],
	@ProviderRendering		[bit],
	@Debug					[bit] = 0
)
AS
BEGIN
	IF (@Debug = 1)
	BEGIN
		SELECT '[2019PI_Master_PopulatePatientList] -- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	DECLARE @2YearsAgo  [date] = DATEADD(YEAR, -2, @RptTimespan_StartDate),
		@3YearsAgo  [date] = DATEADD(YEAR, -3, @RptTimespan_StartDate),                                             
		@5YearsAgo  [date] = DATEADD(YEAR, -5, @RptTimespan_StartDate),
		@13YearsAgo [date] = DATEADD(YEAR, -13, @RptTimespan_StartDate),
		@65YearsAgo [date] = DATEADD(YEAR, -65, @RptTimespan_StartDate),
		@VisitTypeStrikeOut [uniqueidentifier] = 'FB954167-9D1C-43B7-9F5B-A76260654C96',
		@PatientTypeTest    [uniqueidentifier] = '77A41E18-5554-4874-9454-54DC3D7A33A0'

	DECLARE @Portal TABLE 
	(	
		[PatientUid] [uniqueidentifier],
		[PersonUid] [uniqueidentifier],
		[CreatedDate] [date],
		[ExpirationDate] [date],
		primary key([PatientUid], [PersonUid]
	)
	)

	INSERT INTO @Portal
	SELECT DISTINCT vp.[PatientUid]
		,pw.[PersonUid]
		,CAST(pw.[CreatedDateTime] AS [date]) AS [CreatedDate]
		,CAST(NULL AS [date]) AS [ExpirationDate]
	FROM (SELECT DISTINCT [PatientUid] FROM [#tblVisitList]) AS vp
		INNER JOIN [RelPatientPersonWeb] AS rel with(nolock) ON vp.[PatientUid] = rel.[PatientUid]
		INNER JOIN [PersonWeb] pw with(nolock) ON (rel.[PersonUid] = pw.[PersonUid]) and pw.[PatientWebAccess] <> 0
     
	--VisitDate is a DATE field and does NOT get UTC conversion
	--DeathDate is a DATE field and does NOT get UTC conversion
	INSERT INTO [#tblPatientList] (
			[PersonUid],
			[PatientLnFn],
			[Birthdate],
			[TestPat],
			[IsEM],
			[IsVP],
			[FullDemographics],
			[HasEduForm],
			[EduFormPrinted],
			[HasPortalAccount],
			[PortalPerson],
			[PortalValid],
			[PortalExpire],
			[SummaryProvidedToPatient],
			[TransitionOfCare],
			[MedicationChecked],
			[SavedByBillingProvider],
			[SavedByRenderingProvider],
			[YearsOldOrOlder2],
			[YearsOldOrOlder3], 
			[YearsOldOrYounger5],
			[YearsOldOrOlder13],
			[YearsOldOrOlder65]
		) 
		SELECT p.[PersonUid]
			,p.[LastName] + ', ' + p.[FirstName] AS [PatientLnFn]
			,p.[Birthdate]
			,[TestPatient].[IsTestPatient] AS [TestPat]
			,MAX(CONVERT(SMALLINT,v.[IsEM])) AS [IsEM]
			,MAX(CONVERT(SMALLINT,v.[IsVP])) AS [IsVP]
			,(Case WHEN p.[LanguageUid] IS NOT NULL 
					AND p.[GenderUid] IS NOT NULL 
					AND (EXISTS(SELECT TOP 1 * FROM [RelPersonRace] AS rpr with(nolock) WHERE rpr.[PersonUid] = p.[PersonUid]))
					AND (EXISTS(SELECT TOP 1 * FROM [RelPersonEthnicity] AS rpe with(nolock) WHERE rpe.[PersonUid] = p.[PersonUid]))
					AND p.[Birthdate] IS NOT NULL 
				THEN 1 
				ELSE 0 END) AS [FullDemographics]
			,MAX(CONVERT(SMALLINT,v.[HasEduForm])) AS [HasEduForm]
			,MAX(CASE WHEN v.[PrintedDate] IS NOT NULL THEN 1 ELSE 0 END) AS [EduFormPrinted]
			,MAX(CASE WHEN portal.[PersonUid] IS NOT NULL AND (portal.[ExpirationDate] IS NULL OR portal.[ExpirationDate] > @RptTimespan_EndDate) THEN 1  
				  ELSE 0
				 END) AS [HasPortalAccount]
			,MAX(CONVERT(VARCHAR(100),portal.[PatientUid])) AS [PortalPerson]
			,MIN(portal.[CreatedDate]) AS [PortalValid]
			,MAX(portal.[ExpirationDate]) AS [PortalExpire]
			,MAX(CASE WHEN v.[SummaryProvidedToPatient] IS NOT NULL THEN 1 ELSE 0 END) AS [SummaryProvidedToPatient]
			,MAX(CONVERT(SMALLINT,v.[TransitionOfCare])) AS [TransitionOfCare]
			,MAX(CONVERT(SMALLINT,v.[MedicationChecked])) AS [MedicationChecked]
			,MAX(CONVERT(SMALLINT,v.[SavedByBillingProvider])) AS [SavedByBillingProvider]
			,MAX(CONVERT(SMALLINT,v.[SavedByRenderingProvider])) AS [SavedByRenderingProvider]
			,CASE WHEN (p.[Birthdate] <= @2YearsAgo) THEN 1 -- 2 years old or older
				WHEN p.[Birthdate] IS NOT NULL THEN 0
				ELSE NULL
				END AS [YearsOldOrOlder2]
			,CASE WHEN (p.[Birthdate] <= @3YearsAgo) THEN 1  -- 3 years old or younger 
				WHEN p.[Birthdate] IS NOT NULL THEN 0                                                                 
				ELSE NULL                                                                                         
				END AS [YearsOldOrOlder3]
			,CASE WHEN (p.[Birthdate] >= @5YearsAgo) THEN 1  -- 5 years old or younger 
				WHEN p.[Birthdate] IS NOT NULL THEN 0
				ELSE NULL
				END AS [YearsOldOrYounger5]
			,CASE WHEN (p.Birthdate <= @13YearsAgo) THEN 1  -- 13 years old or older
				WHEN p.[Birthdate] IS NOT NULL THEN 0
				ELSE NULL
				END AS [YearsOldOrOlder13]
			,CASE WHEN (p.[Birthdate] <= @65YearsAgo) THEN 1  -- 65 years old or older
				WHEN p.[Birthdate] IS NOT NULL THEN 0
				ELSE NULL
				END AS [YearsOldOrOlder65]
		FROM [#tblVisitList] AS v
			INNER JOIN [Person] AS p WITH(NOLOCK) ON v.[PatientUid] = p.[PersonUid]
				AND (p.[DeathDate] IS NULL OR p.[DeathDate] >= @RptTimespan_StartDate)
			LEFT JOIN @Portal AS portal on v.[PatientUid] = portal.[PatientUid]
			CROSS APPLY
			(
				SELECT (
					CASE WHEN EXISTS(
						SELECT TOP 1 *
						FROM [RelPatientStatus] AS rps WITH(NOLOCK) 
						WHERE rps.[PatientUid] = v.[PatientUid] 
							AND rps.[PatientStatusUid] = @PatientTypeTest
						) THEN 1
						ELSE 0
					END
					) AS [IsTestPatient]
			) AS [TestPatient]
		where [TestPatient].[IsTestPatient]= 0
		GROUP BY p.[PersonUid]
			,p.[LastName]
			,p.[FirstName]
			,p.[Birthdate]
			,[TestPatient].[IsTestPatient]
			,p.[LanguageUid]
			,p.[GenderUid]
			--,p.RaceUid,p.EthnicityUid


	IF (@Debug = 1)
	BEGIN
		SELECT '[2019PI_Master_PopulatePatientList] -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_ProviderToPatientExchange]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_ProviderToPatientExchange] AS' 
END
GO
--
-- Date    : 2018.12.03
-- Purpose : MU Stage 3
-- TFS     : 43001 - Meaningful Use 2015-2017 Objectives as a Dashboard and Report
--

ALTER PROC [dbo].[2019PI_ProviderToPatientExchange]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_ProviderToPatientExchange-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = '796D0340-ADD3-41E3-8D97-14EDB9015CCE'

	TRUNCATE TABLE [#MetricDataTemp]

	-- Populate Denominator Value
	INSERT INTO [#tblMeaningfulUseDetail] ([ItemDefinitionUid]
		, [PersonUid]
		, [NumeratorValue]
		, [DenominatorValue]
		, [YesNo]
	)
	SELECT @ItemDefinitionUid AS [ItemDefinitionUid]
		, p.PersonUid
		, COUNT(DISTINCT CASE WHEN p.[HasPortalAccount] <> 0 THEN p.[PersonUid]
				ELSE NULL END)AS [NumeratorValue]           
		, COUNT(DISTINCT p.[PersonUid]) AS [DenominatorValue]
		, null AS [YesNo]
	FROM  [#tblPatientList] AS p
	WHERE (p.[IsEM] <> 0 OR p.IsVP <> 0)
	GROUP BY p.[PersonUid]
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_ProviderToPatientExchange -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_Master_DesktopControl]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_Master_DesktopControl] AS' 
END
GO
ALTER PROC [dbo].[2019PI_Master_DesktopControl]
(
	@ProviderUid			[varchar](max) = NULL,  
	@RptTimespan_StartDate	[date],
	@RptTimespan_EndDate	[date],
	@ProviderBilling		[bit] = 1,
	@ProviderRendering		[bit] = 0,
	@Debug					[int] = 0,
	@includetestpat			[bit] = 0,
	@ServiceSiteUID			[varchar](max) = null, 
	@FinancialCenterUID		[varchar](max) = null
)
AS
BEGIN
	--
	-- Calling syntax :    
	--
	--

	IF (@RptTimespan_StartDate IS NULL)
	BEGIN
		SET @RptTimespan_StartDate = '01-01-1900'
	END 
	IF (@RptTimespan_EndDate IS NULL)
	BEGIN
		SET @RptTimespan_EndDate = GETDATE()
	END 

	CREATE TABLE [#tblProviderList]
	(
		[ProviderUid] [uniqueidentifier] NOT NULL primary key clustered
	)
	 	 
	DECLARE @HasProviderUid [bit] = 0
	EXEC [2019PI_Master_PopulateProviderList] @ProviderUid, @HasProviderUid out

	-- Measure stored procedure flag indicating Meaningful Use data will be used for a report
	DECLARE @ReportMode [bit] = 0

	IF NOT EXISTS (SELECT 1 FROM sysobjects WHERE Name='cus_PDMP_Pats' and XType='U')
		EXEC FillPDMPPatsTable
		

	CREATE TABLE [#tblVisitList]
	(
		[VisitUid]							[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[VisitDate]							[date]         NOT NULL,
		[PatientUid]						[uniqueidentifier] NOT NULL,
		[TestPat]					   		[bit],
		[IsEM]								[bit],
		[IsVP]								[bit],
		[ProviderUid]						[varchar](max),
		[RenderingProviderUid]				[varchar](max),
		[LastSavedByUid]					[uniqueidentifier],
		[SavedByBillingProvider]			[bit],
		[SavedByRenderingProvider]			[bit],
		[TransitionOfCare]					[bit],
		[MedicationChecked]					[bit],
		[DrugAllergyChecked]				[bit],
		[ProblemChecked]					[bit],
		[SummaryProvidedToPatient]			[date],
		[PatientDeclinedClinicalSummary]	[bit],
		[HasEduForm]						[bit],
		[HasPortalAccount]					[bit],
		[PrintedDate]						[date]
	)
	--
	-- PopulateVisitList
	EXEC [2019PI_Master_PopulateVisitList] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@Debug,
		@ServiceSiteUID,
		@FinancialCenterUID
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblVisitList]
		ORDER BY [VisitDate] DESC 
	END

	CREATE TABLE [#tblPatientList] 
	(
		[PersonUid]					[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[PatientLnFn]				[varchar](250),
		[Birthdate]					[date],
		[TestPat]					[bit],
		[IsEM]						[bit],
		[IsVP]						[bit],
		[FullDemographics]			[bit],
		[HasEduForm]				[bit],
		[EduFormPrinted]			[bit],
		[HasPortalAccount]			[bit],
		[PortalPerson]				[uniqueidentifier] NULL,
		[PortalValid]				[date] NULL,
		[PortalExpire]				[date] NULL,
		[SummaryProvidedToPatient]	[bit],
		[TransitionOfCare]			[bit],
		[MedicationChecked]			[bit],
		[SavedByBillingProvider]	[bit],
		[SavedByRenderingProvider]	[bit],
		[YearsOldOrOlder2]			[bit] NULL,
		[YearsOldOrOlder3]			[bit] NULL,
		[YearsOldOrYounger5]		[bit] NULL, 
		[YearsOldOrOlder13]			[bit] NULL,
		[YearsOldOrOlder65]			[bit] NULL
	)
	--
	-- Populate Patient List
	EXEC [2019PI_Master_PopulatePatientList] @ProviderUid, 
			@RptTimespan_StartDate,
			@RptTimespan_EndDate,
			@ProviderBilling,
			@ProviderRendering,
			@Debug

	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblPatientList]
		ORDER BY [PatientLnFn]
	END

	--back fill #tblVisitList with patient specific information
	--delete test patient records from #tblVisitList AND #tblPatientList IF @includetestpat = 0
	EXEC [2019PI_Master_SynchronizeVisitAndPatient] @Debug = @Debug,
		@IncludeTestPatients = @includetestpat

	-- Build list of Medications that are within reporting range
	CREATE TABLE #tblMedicationList
	(
		[MedicationSIGUid]					[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[CreatedDate]						[datetime] NOT NULL,
		[RelVisitMedicationUid]				[uniqueidentifier],
		[PersonUid]							[uniqueidentifier],
		[TestPat]							[bit],
		[LicensedHealthcareProfessional]	[bit] NOT NULL,
		[Dispensable]						[bit] NULL,
		[IsSampleGiven]						[bit] NOT NULL,
		[IsAdministered]					[bit] NOT NULL,
		[reffederaldeaclasscode]			[int] NULL,
		[SIGDetailCount]					[int] NULL,
		[eRxStatusUid]						[uniqueidentifier]
	)
	--
	-- PopulateMedicationList
	EXEC [2019PI_Master_PopulateMedicationList]
		@ProviderUid
		, @ProviderBilling
		, @RptTimespan_StartDate
		, @RptTimespan_EndDate
		, @includetestpat
		, @Debug
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblMedicationList]
		ORDER BY [CreatedDate] DESC 
	END

	-- Build list of Orders that are within reporting range
	CREATE TABLE [#tblOrderList]
	(
		[ObservationOrderUid]				[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[PatientUid]						[uniqueidentifier] NOT NULL,
		[TestPat]					   		[bit],
		[VPUid]								[uniqueidentifier] NULL,
		[CreatedBy]							[uniqueidentifier] NULL,
		[OrderDate]							[datetime]         NOT NULL,
		[ProcedureCodeTypeUid]				[uniqueidentifier] NULL,
		[ProcedureCodeTypeName]				[varchar](500)     NULL,
		[AttachmentTypeUid]					[uniqueidentifier] NULL,
		[AttachmentTypeName]				[varchar](500)	NULL,
		[LicensedHealthcareProfessional]	[bit]			NOT NULL,
		[ImageResultsDirectlyAccessible]	[bit]			NULL,
		[ResultStatusID]					[int]			NULL
	)
	--
	-- PopulateOrderList
	EXEC [2019PI_Master_PopulateOrderList] @ProviderUid
		, @ProviderBilling
		, @RptTimespan_StartDate
		, @RptTimespan_EndDate
		, @includetestpat
		, @Debug
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblOrderList]
		ORDER BY [OrderDate] DESC 
	END

	-- Create work table that will hold the Meaningful Use results
	CREATE TABLE [#tblMeaningfulUseDetail] 
	(
		[RowId]               [int] IDENTITY(1,1) PRIMARY KEY,     -- Primary Key
		[ItemDefinitionUid]   [uniqueidentifier],                  -- MeaningfulUseItemDefinition.ItemDefinitionUid   
		[PersonUid]           [uniqueidentifier] NULL,             -- Unique list of Visit.PatientUid
		[NumeratorValue]      [int] NULL,                          -- See MeaningfulUseItemDefinition.NumeratorDesc
		[DenominatorValue]    [int] NULL,                          -- See MeaningfulUseItemDefinition.DenominatorDesc
		[YesNo]               [int] NULL                           -- See MeaningfulUseItemdefinition.YesNo.  Null-NA, 0-No/False, 1-Yes/True.
		unique clustered ([RowId])
	)  

	CREATE NONCLUSTERED INDEX [MUDetail_ItemDef_PersonUid] ON [#tblMeaningfulUseDetail]
	(
		[ItemDefinitionUid] ASC,
		[PersonUid] ASC
	)
	WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

	-- Create temp table that can be used by measure procs
	CREATE TABLE [#MetricDataTemp]
	(
		[PersonUid]							[uniqueidentifier] NOT NULL,
		[HeightRecorded]					[int] NULL,
		[WeightRecorded]					[int] NULL,
		[BloodPressureRecorded]				[int] NULL,
		[LabResultTotalCount]				[int] NULL, 
		[LabResultTemplatedCount]			[int] NULL,
		[TaskDocGenCount]					[int] NULL, 
		[TaskDocGenCompleteCount]			[int] NULL,   
		[VisitCount]						[int] NULL, 
		[ClinicalSummaryProvidedCount]		[int] NULL,  
		[PreventativeFollowupDueCount]		[int] NULL, 
		[PreventativeFollowupSentCount]		[int] NULL,   
		[SeenByAnotherProviderCount]		[int] NULL, 
		[MedicalCheckedCount]				[int] NULL,  
		[ReferralCount]						[int] NULL, 
		[ReferralClinicalSummaryProvided]	[int] NULL
	) 	
	
	-- Proc based on MUII_Master_DesktopControl
	--  
	-- Calculate Measures
	EXEC [2019PI_E-Prescribing_1_NonControlled] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_E-Prescribing_2_Controlled] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_E-Prescribing_3_PDMP] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_E-Prescribing_4_VerifyOpioidAgreement] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_HealthInformationExchange_1_Sending] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_HealthInformationExchange_2_Receiving] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_ProviderToPatientExchange] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	-- Drop temp tables that are used by measure procs
	BEGIN TRY
		DROP TABLE [#tblVisitList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#tblPatientList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#tblProviderList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#MetricDataTemp]
	END TRY 
	BEGIN CATCH
	END CATCH

	-- Define table that will be returned to caller
	DECLARE @tblMeaingfulUseSummaryCoreAndMenuSet TABLE
	(
		[RowId]             [int] IDENTITY(1,1) PRIMARY KEY,
		[ItemDefinitionUid] [uniqueidentifier],
		[CategoryNumber]    [int] NULL,
		[CategoryName]      [varchar](100) NULL,
		[MeasureNumber]     [int] NULL, 
		[SubMeasureNumber]  [int] NULL,
		[MeasureDesc]       [varchar](500) NULL,
		[DenominatorDesc]   [varchar](250) NULL,
		[DenominatorValue]  [int] NULL,
		[NumeratorDesc]     [varchar](250) NULL,
		[NumeratorValue]    [int] NULL,
		[YesNo]     [varchar](50)  NULL,
		[CurrentValue]	  [varchar](25)  NULL,
		[GoalDesc]          [varchar](250) NULL,
		[GoalValue]         [varchar](10)  NULL,
		[MetGoal]           [bit] NULL, 
		[ProviderUid]       [varchar](max) NULL,
		[ProviderLnFn]      [varchar](150) NULL,       
		unique clustered  ([RowId])
	) 

	-- Determine if there are any MU detail rows to base metrics against
	DECLARE @NumDetailRows [int]

	-- Walk through list of defined Meaningful Use metrics and popluate @tblMeaingfulUseSummaryCoreAndMenuSet 
	DECLARE @ItemDefinitionUid [uniqueidentifier]
		, @CategoryUid [uniqueidentifier]
		, @CategoryNumber [int]
		, @CategoryName [varchar](100)
		, @MeasureNumber [int]
		, @SubMeasureNumber [int]
		, @MeasureDesc [varchar](500)
		, @ExclusionDesc [varchar](250)
		, @DenominatorDesc [varchar](250)
		, @NumeratorDesc [varchar](250)
		, @YesNo [varchar](50)
		, @GoalDesc [varchar](250)
		, @GoalValue [decimal](5, 2)
		, @DenominatorSumValue [int]
		, @NumeratorSumValue [int]
		, @CurValue [varchar](25)
		, @MetGoal [bit]    
        
    --
    -- Populate table that will be returned to caller
	DECLARE cursor_MU_Definitions CURSOR FAST_FORWARD FOR 
		SELECT muid.[ItemDefinitionUid]
			, muid.[CategoryUid]
			, mucd.[CategoryNumber]
			, mucd.[CategoryName]
			, muid.[MeasureNumber]
			, muid.[SubMeasureNumber]
			, muid.[MeasureDesc]
			, muid.[ExclusionDesc]
			, muid.[DenominatorDesc]
			, muid.[NumeratorDesc]
			, muid.[YesNo]
			, muid.[GoalDesc]
			, muid.[GoalValue]
		FROM [MeaningfulUseItemDefinition] AS muid with(nolock)
			INNER JOIN [MeaningfulUseCategoryDefinition] AS mucd with(nolock) ON muid.[CategoryUid] = mucd.[CategoryUid]
		WHERE muid.[StageUid] = '5B148CD9-713E-4024-A18F-28AC42FB0265'   --2019 PI
		ORDER BY mucd.[CategoryName]
			, mucd.[CategoryNumber]
			, muid.[MeasureNumber]
    --
    OPEN cursor_MU_Definitions
    --
	FETCH NEXT FROM cursor_MU_Definitions 
		INTO @ItemDefinitionUid
			, @CategoryUid
			, @CategoryNumber
			, @CategoryName
			, @MeasureNumber
			, @SubMeasureNumber
			, @MeasureDesc
			, @ExclusionDesc
			, @DenominatorDesc
			, @NumeratorDesc
			, @YesNo
			, @GoalDesc
			, @GoalValue 
    --
   -- Make sure we have a valid cursor row
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @DenominatorSumValue = 0
		SET @NumeratorSumValue = 0
		SET @CurValue = '' 
		SET @MetGoal = 0 
		SET @NumDetailRows = 0
		
		-- Check if current MU metric has a numerator and denominator
		IF @YesNo IS NULL
		BEGIN
			-- Make sure we have some data for current metric
			SET @NumDetailRows = (SELECT COUNT(*)
								  FROM [#tblMeaningfulUseDetail]
								  WHERE [ItemDefinitionUid] = @ItemDefinitionUid
								 )
			IF (@NumDetailRows > 0)
			BEGIN
				-- Current MU metric has a numerator and demoninator
				SELECT  @DenominatorSumValue = SUM(mud.[DenominatorValue])
					, @NumeratorSumValue   = SUM(mud.[NumeratorValue]) 
				FROM     [#tblMeaningfulUseDetail] AS mud
				WHERE    mud.[ItemDefinitionUid] = @ItemDefinitionUid
				GROUP BY mud.[ItemDefinitionUid] 
			END    
           
			IF @DenominatorSumValue <= 0
			BEGIN
				SET @CurValue = 'N/A' 
			END 
			ELSE IF @NumeratorSumValue <= 0
			BEGIN 
				SET @CurValue = '0.00%' 
			END 
			ELSE 
			BEGIN 
				-- Calculate current MU metric value
				SET @CurValue = CONVERT(VARCHAR(10), CONVERT(DECIMAL(8,2), (CONVERT(DECIMAL(8,2), @NumeratorSumValue) / CONVERT(DECIMAL(8,2), @DenominatorSumValue)) * 100)) + '%'
	                  
				-- Determine if goal is satisfied
				IF CONVERT(DECIMAL(8,2), (CONVERT(DECIMAL(8,2), @NumeratorSumValue) / CONVERT(DECIMAL(8,2), @DenominatorSumValue)) * 100) > @GoalValue
				BEGIN
					SET @MetGoal = 1
				END 
			END 
             
			-- Insert MU summary row
			INSERT INTO @tblMeaingfulUseSummaryCoreAndMenuSet ([ItemDefinitionUid]
				, [CategoryNumber]
				, [CategoryName]
				, [MeasureNumber]
				, [SubMeasureNumber]
				, [MeasureDesc]
				, [DenominatorDesc]
				, [DenominatorValue]
				, [NumeratorDesc]
				, [NumeratorValue]
				, [YesNo]
				, [CurrentValue]
				, [GoalDesc]
				, [GoalValue]
				, [MetGoal]
				, [ProviderUid]
				, [ProviderLnFn]
			)   
			VALUES (@ItemDefinitionUid
				, @CategoryNumber
				, @CategoryName
				, @MeasureNumber
				, @SubMeasureNumber
				, @MeasureDesc
				, @DenominatorDesc
				, @DenominatorSumValue
				, @NumeratorDesc
				, @NumeratorSumValue
				, @YesNo
				, @CurValue
				, @GoalDesc
				, CONVERT([varchar](10), @GoalValue)
				, @MetGoal
				, null
				, null
			)  
		END 
		ELSE 
		BEGIN
			-- Current MU metric is YES/NO.  
			INSERT INTO @tblMeaingfulUseSummaryCoreAndMenuSet([ItemDefinitionUid]
				, [CategoryNumber]
				, [CategoryName]
				, [MeasureNumber]
				, [SubMeasureNumber]
				, [MeasureDesc]
				, [DenominatorDesc]
				, [DenominatorValue]
				, [NumeratorDesc]
				, [NumeratorValue]
				, [YesNo]
				, [CurrentValue]
				, [GoalDesc]
				, [GoalValue]
				, [MetGoal]
				, [ProviderUid]
				, [ProviderLnFn]
			)  
			VALUES (@ItemDefinitionUid
				, @CategoryNumber
				, @CategoryName
				, @MeasureNumber
				, @SubMeasureNumber
				, @MeasureDesc
				, @DenominatorDesc
				, null
				, @NumeratorDesc
				, null
				, @YesNo
				, null
				, @GoalDesc
				, null
				, null
				, null
				, null
			)  
		END
		-- 
		-- Get next cursor_MU_Definitions row
		FETCH NEXT FROM cursor_MU_Definitions INTO @ItemDefinitionUid
			, @CategoryUid
			, @CategoryNumber
			, @CategoryName
			, @MeasureNumber
			, @SubMeasureNumber
			, @MeasureDesc
			, @ExclusionDesc
			, @DenominatorDesc
			, @NumeratorDesc
			, @YesNo
			, @GoalDesc
			, @GoalValue 
    END
    --
    -- Close and Deallocate cursor
    CLOSE cursor_MU_Definitions
    DEALLOCATE cursor_MU_Definitions
	
	-- Return Meaningful Use results to caller
	SELECT 'MeaingfulUseSummaryCoreAndMenuSet'
	SELECT [RowId]
		, [ItemDefinitionUid]
		, [CategoryNumber]
		, [CategoryName]
		, [MeasureNumber]
		, [SubMeasureNumber]
		, [MeasureDesc]
		, [DenominatorDesc]
		, [DenominatorValue]
		, [NumeratorDesc]
		, [NumeratorValue]
		, [YesNo]
		, [CurrentValue]
		, [GoalDesc]
		, [GoalValue]
		, [MetGoal]
		, [ProviderUid]
		, [ProviderLnFn]
	FROM @tblMeaingfulUseSummaryCoreAndMenuSet    
	ORDER BY [CategoryNumber] ASC
		, [MeasureNumber] ASC
		, [SubMeasureNumber] ASC 
	
	IF (@Debug <> 0)
	BEGIN
		SELECT 'GOOD BYE'
	END 
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MUI_Master_Report_InsertAttestMeasureDetail]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[MUI_Master_Report_InsertAttestMeasureDetail] AS' 
END
GO
ALTER PROC [dbo].[MUI_Master_Report_InsertAttestMeasureDetail]
(
	@ItemDefinitionUid UNIQUEIDENTIFIER,
	@ReportMode          BIT,
	@Debug               INT
)
AS
BEGIN
	SET NOCOUNT ON;
	IF (@Debug = 1)
	BEGIN
		SELECT 'MUI_Master_Report_InsertAttestMeasureDetail -- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END 


	INSERT INTO #tblMeaningfulUseDetail 
		(ItemDefinitionUid, CategoryNumber, MeasureNumber, SubMeasureNumber, PersonUid, PersonLnFn, ProviderUid, ProviderLnFn, NumeratorValue, DenominatorValue, YesNo)
	VALUES 
		(@ItemDefinitionUid

		,(select mucd.CategoryNumber 
		from MeaningfulUseItemDefinition muid inner join MeaningfulUseCategoryDefinition mucd on muid.CategoryUid = mucd.CategoryUid
		where muid.ItemDefinitionUid = @ItemDefinitionUid)

		,(select muid.MeasureNumber 
		from MeaningfulUseItemDefinition muid inner join MeaningfulUseCategoryDefinition mucd on muid.CategoryUid = mucd.CategoryUid
		where muid.ItemDefinitionUid = @ItemDefinitionUid)   

		,(select muid.SubMeasureNumber 
		from MeaningfulUseItemDefinition muid inner join MeaningfulUseCategoryDefinition mucd on muid.CategoryUid = mucd.CategoryUid
		where muid.ItemDefinitionUid = @ItemDefinitionUid)

		,null        --AS PersonUid
		,null        --AS PersonLnFn 
		,null        --AS ProviderUid
		,null        --AS ProviderLnFn      
		,-1          --AS NumeratorValue     
		,-1          --AS DenominatorValue
		,1)          --AS YesNo


	IF (@Debug = 1)
	BEGIN
		SELECT 'MUI_Master_Report_InsertAttestMeasureDetail -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END	
	
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MIPS_2018_Master_Report_DeleteReportInstance]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[MIPS_2018_Master_Report_DeleteReportInstance] AS' 
END
GO
ALTER PROCEDURE [dbo].[MIPS_2018_Master_Report_DeleteReportInstance] 
	@ReportInstanceUid [uniqueidentifier]
AS
BEGIN
	SET NOCOUNT ON;

	IF @ReportInstanceUid IS NULL
		OR @ReportInstanceUid = '00000000-0000-0000-0000-000000000000'
		RETURN

	EXEC sp_executesql N'IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[CUS_MeaningfulUseDetail]'') AND type in (N''U'')) DELETE [CUS_MeaningfulUseDetail] WHERE [ReportInstanceUid] = @ReportInstanceUid',
		N'@ReportInstanceUid [uniqueidentifier]', @ReportInstanceUid 
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_Master_Report]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_Master_Report] AS' 
END
GO
ALTER PROC [dbo].[2019PI_Master_Report]
(
	@ReportInstanceUid [uniqueidentifier],
	@ProviderUid [varchar](max) = NULL, 
	@RptTimespan_StartDate [date],
	@RptTimespan_EndDate [date],
	@ProviderOption [varchar](100) = 'Billing Provider', --	Billing Provider and Rendering Provider 
	@Debug [int] = 0,
	@includetestpat	[bit] = 0,
	@ServiceSiteUID	[varchar](max) = null, 
	@FinancialCenterUID	[varchar](max) = null
)
AS
BEGIN
	SET NOCOUNT ON;
	--
	--  

	IF (@RptTimespan_StartDate IS NULL)
	BEGIN
		SET @RptTimespan_StartDate = '01-01-1900'
	END 
	IF (@RptTimespan_EndDate IS NULL)
	BEGIN
		SET @RptTimespan_EndDate = GETDATE()
	END

	CREATE TABLE [#tblProviderList]
	(
		[ProviderUid] [uniqueidentifier] NOT NULL primary key clustered
	)
	 
	DECLARE @HasProviderUid [bit] = 0
	EXEC [2019PI_Master_PopulateProviderList] @ProviderUid, @HasProviderUid out

	DECLARE @ClaimFormatValueTypeProviderNPIUid [uniqueidentifier] = 'CE282F4E-A866-49BA-9636-C4BA0439E907',
		@ReportMode [bit] = 1,
		@ProviderBilling [bit] = 0,
		@ProviderRendering [bit] = 0,
		@ProviderNPI [varchar](100) = null

	-- Find the first provider has provider NPI

	SELECT TOP 1 @ProviderNPI = [Value]
	FROM [ClaimFormatValue] with(nolock)
	WHERE [ClaimFormatValueTypeUid] = @ClaimFormatValueTypeProviderNPIUid
		AND [ProviderUid] IN (SELECT [ProviderUid] FROM [#tblProviderList])

	-- Set local Billing and Rendering Provider Flags
	IF (@ProviderOption = 'Billing Provider')
	BEGIN
		SET @ProviderBilling = 1
		SET @ProviderRendering = 0
	END
	ELSE
	BEGIN
		SET @ProviderBilling = 0
		SET @ProviderRendering = 1	
	END

	IF NOT EXISTS (SELECT 1 FROM sysobjects WHERE Name='cus_PDMP_Pats' and XType='U')
		EXEC FillPDMPPatsTable

	-- Measure stored procedure flag indicating Meaningful Use data will be used for a report
CREATE TABLE [#tblVisitList]
	(
		[VisitUid]							[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[VisitDate]							[date]         NOT NULL,
		[PatientUid]						[uniqueidentifier] NOT NULL,
		[TestPat]					   		[bit],
		[IsEM]								[bit],
		[IsVP]								[bit],
		[ProviderUid]						[varchar](max),
		[RenderingProviderUid]				[varchar](max),
		[LastSavedByUid]					[uniqueidentifier],
		[SavedByBillingProvider]			[bit],
		[SavedByRenderingProvider]			[bit],
		[TransitionOfCare]					[bit],
		[MedicationChecked]					[bit],
		[DrugAllergyChecked]				[bit],
		[ProblemChecked]					[bit],
		[SummaryProvidedToPatient]			[date],
		[PatientDeclinedClinicalSummary]	[bit],
		[HasEduForm]						[bit],
		[HasPortalAccount]					[bit],
		[PrintedDate]						[date]
	)
	--
	-- PopulateVisitList
	EXEC [2019PI_Master_PopulateVisitList] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@Debug,
		@ServiceSiteUID,
		@FinancialCenterUID

	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblVisitList]
		ORDER BY [VisitDate] DESC 
	END

	CREATE TABLE [#tblPatientList] 
	(
		[PersonUid]					[uniqueidentifier] NOT NULL primary key clustered,
		[PatientLnFn]				[varchar](250),
		[Birthdate]					[date],
		[TestPat]					[bit],
		[IsEM]						[bit],
		[IsVP]						[bit],
		[FullDemographics]			[bit],
		[HasEduForm]				[bit],
		[EduFormPrinted]			[bit],
		[HasPortalAccount]			[bit],
		[PortalPerson]				[uniqueidentifier] NULL,
		[PortalValid]				[date] NULL,
		[PortalExpire]				[date] NULL,
		[SummaryProvidedToPatient]	[bit],
		[TransitionOfCare]			[bit],
		[MedicationChecked]			[bit],
		[SavedByBillingProvider]	[bit],
		[SavedByRenderingProvider]	[bit],
		[YearsOldOrOlder2]			[bit] NULL,
		[YearsOldOrOlder3]			[bit] NULL,
		[YearsOldOrYounger5]		[bit] NULL, 
		[YearsOldOrOlder13]			[bit] NULL,
		[YearsOldOrOlder65]			[bit] NULL
	)
	--
	-- Populate Patient List
	EXEC [2019PI_Master_PopulatePatientList] 
			@ProviderUid, 
			@RptTimespan_StartDate,
			@RptTimespan_EndDate,
			@ProviderBilling,
			@ProviderRendering,
			@Debug

	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblPatientList]
		ORDER BY [PatientLnFn]
	END

	--back fill #tblVisitList with patient specific information
	--delete test patient records from #tblVisitList AND #tblPatientList IF @includetestpat = 0
	EXEC [2019PI_Master_SynchronizeVisitAndPatient] @Debug = @Debug,
		@IncludeTestPatients = @includetestpat

	-- Build list of Medications that are within reporting range
	CREATE TABLE [#tblMedicationList]
	(
		[MedicationSIGUid]					[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[CreatedDate]						[datetime] NOT NULL,
		[RelVisitMedicationUid]				[uniqueidentifier],
		[PersonUid]							[uniqueidentifier],
		[TestPat]							[bit],
		[LicensedHealthcareProfessional]	[bit] NOT NULL,
		[Dispensable]						[bit] NULL,
		[IsSampleGiven]						[bit] NOT NULL,
		[IsAdministered]					[bit] NOT NULL,
		[reffederaldeaclasscode]			[int] NULL,
		[SIGDetailCount]					[int] NULL,
		[eRxStatusUid]						[uniqueidentifier]
	)
	--
	-- PopulateMedicationList
	EXEC [2019PI_Master_PopulateMedicationList] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@includetestpat,
		@Debug
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblMedicationList]
		ORDER BY [CreatedDate] DESC 
	END

	-- Build list of Orders that are within reporting range
	CREATE TABLE [#tblOrderList]
	(
		[ObservationOrderUid]				[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[PatientUid]						[uniqueidentifier] NOT NULL,
		[TestPat]					 		[bit],
		[VPUid]								[uniqueidentifier] NULL,
		[CreatedBy]							[uniqueidentifier] NULL,
		[OrderDate]							[datetime] NOT NULL,
		[ProcedureCodeTypeUid]				[uniqueidentifier] NULL,
		[ProcedureCodeTypeName]				[varchar](500) NULL,
		[AttachmentTypeUid]					[uniqueidentifier] NULL,
		[AttachmentTypeName]				[varchar](500) NULL,
		[LicensedHealthcareProfessional]	[bit] NOT NULL,
		[ImageResultsDirectlyAccessible]	[bit] NULL,
		[ResultStatusID]					[int] NULL
	)
	--
	-- PopulateOrderList
	EXEC [2019PI_Master_PopulateOrderList] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@includetestpat,
		@Debug
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblOrderList]
		ORDER BY [OrderDate] DESC 
	END

	-- Create work table that will hold the Meaningful Use results
	CREATE TABLE [#tblMeaningfulUseDetail] 
	(
		[RowId]				[int] IDENTITY(1,1) PRIMARY KEY, -- Primary Key
		[ItemDefinitionUid]	[uniqueidentifier], -- MeaningfulUseItemDefinition.ItemDefinitionUid
		[CategoryName]		[varchar](500) NULL, -- MeaningfulUseCategoryDefinition.CategoryName
		[CategoryNumber]	[int] NULL, -- MeaningfulUseCategoryDefinition.CategoryNumber
		[MeasureNumber]		[int] NULL, -- MeaningfulUseItemDefinition.MeasureNumber 
		[SubMeasureNumber]	[int] NULL, -- MeaningfulUseItemDefinition.SubMeasureNumber
		[PersonUid]			[uniqueidentifier] NULL, -- Unique list of Visit.PatientUid
		[PersonLnFn]		[varchar](150) NULL, -- Patient name
		[ProviderUid]		[varchar](MAX) NULL,
		[ProviderLnFn]		[varchar](150) NULL, 
		[NumeratorValue]	[int] NULL, -- See MeaningfulUseItemDefinition.NumeratorDesc
		[DenominatorValue]	[int] NULL, -- See MeaningfulUseItemDefinition.DenominatorDesc
		[YesNo]				[int] NULL -- See MeaningfulUseItemdefinition.YesNo. Null-NA, 0-No/False, 1-Yes/True.
		unique clustered (RowId)
	) 
 
	CREATE NONCLUSTERED INDEX [MUDetail_ItemDef_PersonUid] ON #tblMeaningfulUseDetail
	(
		ItemDefinitionUid ASC,
		PersonUid ASC
	)
	WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]


	-- Params used in determining if any detail rows were found for given metric
	CREATE TABLE [#tblMetricUidsWithoutDetailRows] 
	(
		[ItemDefinitionUid] [uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED
	)

	-- Create temp table that can be used by measure procs
	CREATE TABLE [#MetricDataTemp]
	(
		[PersonUid] [uniqueidentifier] NOT NULL,
		[HeightRecorded] [int] NULL,
		[WeightRecorded] [int] NULL,
		[BloodPressureRecorded] [int] NULL,
		[LabResultTotalCount] [int] NULL, 
		[LabResultTemplatedCount] [int] NULL,
		[TaskDocGenCount] [int] NULL, 
		[TaskDocGenCompleteCount] [int] NULL, 
		[VisitCount] [int] NULL, 
		[ClinicalSummaryProvidedCount] [int] NULL, 
		[PreventativeFollowupDueCount] [int] NULL, 
		[PreventativeFollowupSentCount] [int] NULL, 
		[SeenByAnotherProviderCount] [int] NULL, 
		[MedicalCheckedCount] [int] NULL, 
		[ReferralCount] [int] NULL, 
		[ReferralClinicalSummaryProvided] [int] NULL
	) 	

	-- Proc based on MUII_Master_DesktopControl
	--  
	-- Calculate Measures
	-- ACI_TRANS_PPHI_1 == Objective 1 == MUII Core Measure 9
	-- Must attest yes

	-- ACI_TRANS_EP_1 == Objective 4 == MUII Core Measure 2, Sub Measure NULL; ItemDefinitionUid : F3A49E2B-E4FF-4D78-A3D5-EEA12A5FBF58
	EXEC [2019PI_E-Prescribing_1_NonControlled] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_E-Prescribing_2_Controlled] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_E-Prescribing_3_PDMP] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_E-Prescribing_4_VerifyOpioidAgreement] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_HealthInformationExchange_1_Sending] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_HealthInformationExchange_2_Receiving] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_ProviderToPatientExchange] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	-- Drop temp tables that are used by measure procs
	BEGIN TRY
		DROP TABLE [#tblVisitList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#tblPatientList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#tblProviderList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#MetricDataTemp]
	END TRY 
	BEGIN CATCH
	END CATCH

	-- For measures that do not have any detail rows, we need to insert a row, so it will be included in the RDL report.
	DECLARE @NumDetailRows [int]
	SET @NumDetailRows = (SELECT COUNT(*) FROM [#tblMetricUidsWithoutDetailRows])
	IF (@NumDetailRows > 0)
	BEGIN
		INSERT INTO [#tblMeaningfulUseDetail] ([ItemDefinitionUid],
			[CategoryNumber],
			[CategoryName],
			[MeasureNumber],
			[SubMeasureNumber],
			[PersonUid],
			[PersonLnFn],
			[ProviderUid],
			[ProviderLnFn],
			[NumeratorValue],
			[DenominatorValue],
			[YesNo]
		)
			SELECT NoData.[ItemDefinitionUid] AS [ItemDefinitionUid]
			,(
				select mucd.[CategoryNumber] 
				from [MeaningfulUseItemDefinition] AS muid with(nolock)
					inner join [MeaningfulUseCategoryDefinition] AS mucd with(nolock) on muid.[CategoryUid] = mucd.[CategoryUid]
				where muid.[ItemDefinitionUid] = NoData.[ItemDefinitionUid]
			) AS [CategoryNumber]

			,(
				select mucd.CategoryName
				from [MeaningfulUseItemDefinition] AS muid with(nolock)
					inner join [MeaningfulUseCategoryDefinition] AS mucd with(nolock) on muid.[CategoryUid] = mucd.[CategoryUid]
				where muid.[ItemDefinitionUid] = NoData.[ItemDefinitionUid]
			) AS [CategoryName]

			,(
				select muid.[MeasureNumber]
				from [MeaningfulUseItemDefinition] AS muid with(nolock)
					inner join [MeaningfulUseCategoryDefinition] AS mucd with(nolock) on muid.[CategoryUid] = mucd.[CategoryUid]
				where muid.[ItemDefinitionUid] = NoData.[ItemDefinitionUid]
			) AS [MeasureNumber] 

			,(
				select muid.[SubMeasureNumber] 
				from [MeaningfulUseItemDefinition] AS muid with(nolock)
					inner join [MeaningfulUseCategoryDefinition] AS mucd with(nolock) on muid.[CategoryUid] = mucd.[CategoryUid]
				where muid.[ItemDefinitionUid] = NoData.[ItemDefinitionUid]
			) AS [SubMeasureNumber] 

			,NULL AS [PersonUid] 
			,'N / A' AS [PersonLnFn]
			,NULL AS [ProviderUid] 
			,'' AS [ProviderLnFn]
			,0 AS [NumeratorValue]
			,0 AS [DenominatorValue]
			,0 AS [YesNo]
		FROM [#tblMetricUidsWithoutDetailRows] AS [NoData] 
	END

	--
	-- For measures that are Yes/No (Must attest Yes), insert a detail row that will be included in the RDL report
	--

	-- ACI_TRANS_PPHI_1 == Objective 1 == MUII Core Measure 9
	DECLARE @ItemDefinitionUid [uniqueidentifier] = '9745E6BF-99FF-490B-992A-E4D315E2B13A' 
	EXEC [MUI_Master_Report_InsertAttestMeasureDetail] @ItemDefinitionUid, @ReportMode,	@Debug

	-- Pick 2 registries
	SET @ItemDefinitionUid = '9DB682EA-0CFD-4975-9D2F-06132E096F78' 
	EXEC [MUI_Master_Report_InsertAttestMeasureDetail] @ItemDefinitionUid, @ReportMode, @Debug

	-- Define table that will be returned to caller
	DECLARE @tblMeaingfulUseSummaryCoreAndMenuSet TABLE
	(
		[RowId]             [int] IDENTITY(1,1) PRIMARY KEY,
		[ItemDefinitionUid] [uniqueidentifier],
		[CategoryNumber]    [int] NULL,
		[CategoryName]      [varchar](100) NULL,
		[MeasureNumber]     [int] NULL, 
		[SubMeasureNumber]  [int] NULL,
		[MeasureDesc]       [varchar](500) NULL,
		[DenominatorDesc]   [varchar](250) NULL,
		[DenominatorValue]  [int] NULL,
		[NumeratorDesc]     [varchar](250) NULL,
		[NumeratorValue]    [int] NULL,
		[YesNo]     [varchar](50)  NULL,
		[CurrentValue]	  [varchar](25)  NULL,
		[GoalDesc]          [varchar](250) NULL,
		[GoalValue]         [varchar](10)  NULL,
		[MetGoal]           [bit] NULL, 
		[ProviderUid]       [varchar](max) NULL,
		[ProviderLnFn]      [varchar](150) NULL,       
		unique clustered  ([RowId])
	) 

	-- Determine if there are any MU detail rows to base metrics against
	-- Walk through list of defined Meaningful Use metrics and popluate @tblMeaingfulUseSummaryCoreAndMenuSet 
	DECLARE @CategoryUid [uniqueidentifier]
		, @CategoryNumber [int]
		, @CategoryName [varchar](100)
		, @MeasureNumber [int]
		, @SubMeasureNumber [int]
		, @MeasureDesc [varchar](500)
		, @ExclusionDesc [varchar](250)
		, @DenominatorDesc [varchar](250)
		, @NumeratorDesc [varchar](250)
		, @YesNo [varchar](50)
		, @GoalDesc [varchar](250)
		, @GoalValue [decimal](5, 2)
		, @DenominatorSumValue [int]
		, @NumeratorSumValue [int]
		, @CurValue [varchar](25)
		, @MetGoal [bit]    
        
    --
    -- Populate table that will be returned to caller
	DECLARE cursor_MU_Definitions CURSOR FAST_FORWARD FOR 
		SELECT muid.[ItemDefinitionUid]
			, muid.[CategoryUid]
			, mucd.[CategoryNumber]
			, mucd.[CategoryName]
			, muid.[MeasureNumber]
			, muid.[SubMeasureNumber]
			, muid.[MeasureDesc]
			, muid.[ExclusionDesc]
			, muid.[DenominatorDesc]
			, muid.[NumeratorDesc]
			, muid.[YesNo]
			, muid.[GoalDesc]
			, muid.[GoalValue]
		FROM [MeaningfulUseItemDefinition] AS muid with(nolock)
			INNER JOIN [MeaningfulUseCategoryDefinition] AS mucd with(nolock) ON muid.[CategoryUid] = mucd.[CategoryUid]
		WHERE muid.[StageUid] = '5B148CD9-713E-4024-A18F-28AC42FB0265'   -- 2019 PI
		ORDER BY mucd.[CategoryName]
			, mucd.[CategoryNumber]
			, muid.[MeasureNumber]
    --
    OPEN cursor_MU_Definitions
    --
	FETCH NEXT FROM cursor_MU_Definitions 
		INTO @ItemDefinitionUid
			, @CategoryUid
			, @CategoryNumber
			, @CategoryName
			, @MeasureNumber
			, @SubMeasureNumber
			, @MeasureDesc
			, @ExclusionDesc
			, @DenominatorDesc
			, @NumeratorDesc
			, @YesNo
			, @GoalDesc
			, @GoalValue 
    --
   -- Make sure we have a valid cursor row
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @DenominatorSumValue = 0
		SET @NumeratorSumValue = 0
		SET @CurValue = '' 
		SET @MetGoal = 0 
		SET @NumDetailRows = 0
		
		-- Check if current MU metric has a numerator and denominator
		IF @YesNo IS NULL
		BEGIN
			-- Make sure we have some data for current metric
			SET @NumDetailRows = (SELECT COUNT(*)
								  FROM [#tblMeaningfulUseDetail]
								  WHERE [ItemDefinitionUid] = @ItemDefinitionUid
								 )
			IF (@NumDetailRows > 0)
			BEGIN
				-- Current MU metric has a numerator and demoninator
				SELECT  @DenominatorSumValue = SUM(mud.[DenominatorValue])
					, @NumeratorSumValue   = SUM(mud.[NumeratorValue]) 
				FROM     [#tblMeaningfulUseDetail] AS mud
				WHERE    mud.[ItemDefinitionUid] = @ItemDefinitionUid
				GROUP BY mud.[ItemDefinitionUid] 
			END    
           
			IF @DenominatorSumValue <= 0
			BEGIN
				SET @CurValue = 'N/A' 
			END 
			ELSE IF @NumeratorSumValue <= 0
			BEGIN 
				SET @CurValue = '0.00%' 
			END 
			ELSE 
			BEGIN 
				-- Calculate current MU metric value
				SET @CurValue = CONVERT(VARCHAR(10), CONVERT(DECIMAL(8,2), (CONVERT(DECIMAL(8,2), @NumeratorSumValue) / CONVERT(DECIMAL(8,2), @DenominatorSumValue)) * 100)) + '%'
	                  
				-- Determine if goal is satisfied
				IF CONVERT(DECIMAL(8,2), (CONVERT(DECIMAL(8,2), @NumeratorSumValue) / CONVERT(DECIMAL(8,2), @DenominatorSumValue)) * 100) > @GoalValue
				BEGIN
					SET @MetGoal = 1
				END 
			END 
             
			-- Insert MU summary row
			INSERT INTO @tblMeaingfulUseSummaryCoreAndMenuSet ([ItemDefinitionUid]
				, [CategoryNumber]
				, [CategoryName]
				, [MeasureNumber]
				, [SubMeasureNumber]
				, [MeasureDesc]
				, [DenominatorDesc]
				, [DenominatorValue]
				, [NumeratorDesc]
				, [NumeratorValue]
				, [YesNo]
				, [CurrentValue]
				, [GoalDesc]
				, [GoalValue]
				, [MetGoal]
				, [ProviderUid]
				, [ProviderLnFn]
			)   
			VALUES (@ItemDefinitionUid
				, @CategoryNumber
				, @CategoryName
				, @MeasureNumber
				, @SubMeasureNumber
				, @MeasureDesc
				, @DenominatorDesc
				, @DenominatorSumValue
				, @NumeratorDesc
				, @NumeratorSumValue
				, @YesNo
				, @CurValue
				, @GoalDesc
				, CONVERT([varchar](10), @GoalValue)
				, @MetGoal
				, null
				, null
			)  
		END 
		ELSE 
		BEGIN
			-- Current MU metric is YES/NO.  
			INSERT INTO @tblMeaingfulUseSummaryCoreAndMenuSet([ItemDefinitionUid]
				, [CategoryNumber]
				, [CategoryName]
				, [MeasureNumber]
				, [SubMeasureNumber]
				, [MeasureDesc]
				, [DenominatorDesc]
				, [DenominatorValue]
				, [NumeratorDesc]
				, [NumeratorValue]
				, [YesNo]
				, [CurrentValue]
				, [GoalDesc]
				, [GoalValue]
				, [MetGoal]
				, [ProviderUid]
				, [ProviderLnFn]
			)  
			VALUES (@ItemDefinitionUid
				, @CategoryNumber
				, @CategoryName
				, @MeasureNumber
				, @SubMeasureNumber
				, @MeasureDesc
				, @DenominatorDesc
				, null
				, @NumeratorDesc
				, null
				, @YesNo
				, null
				, @GoalDesc
				, null
				, null
				, null
				, null
			)  
		END
		-- 
		-- Get next cursor_MU_Definitions row
		FETCH NEXT FROM cursor_MU_Definitions INTO @ItemDefinitionUid
			, @CategoryUid
			, @CategoryNumber
			, @CategoryName
			, @MeasureNumber
			, @SubMeasureNumber
			, @MeasureDesc
			, @ExclusionDesc
			, @DenominatorDesc
			, @NumeratorDesc
			, @YesNo
			, @GoalDesc
			, @GoalValue 
    END
    --
    -- Close and Deallocate cursor
    CLOSE cursor_MU_Definitions
    DEALLOCATE cursor_MU_Definitions

	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CUS_MeaningfulUseDetail]') AND type in (N'U'))
	BEGIN
	CREATE TABLE [dbo].[CUS_MeaningfulUseDetail](
		[MeaningfulUseDetailUid] [uniqueidentifier] NOT NULL,
		[ReportInstanceUid] [uniqueidentifier] NOT NULL,
		[ItemDefinitionUid] [uniqueidentifier] NULL,
		[CategoryName] [varchar](500) NULL,
		[CategoryNumber] [int] NULL,
		[MeasureNumber] [int] NULL,
		[SubMeasureNumber] [int] NULL,
		[PersonUid] [uniqueidentifier] NULL,
		[PersonLnFn] [varchar](150) NULL,
		[ProviderUid] [varchar](max) NULL,
		[ProviderLnFn] [varchar](150) NULL,
		[ProviderNPI] [varchar](250) NULL,
		[NumeratorValue] [int] NULL,
		[DenominatorValue] [int] NULL,
		[YesNo] [int] NULL,
		[ObjectiveDesc] [varchar](500) NULL,
		[MeasureDesc] [varchar](600) NOT NULL,
		[MeasureDetailDesc] [varchar](600) NULL,
		[ExclusionDesc] [varchar](600) NULL,
		[DenominatorDesc] [varchar](500) NULL,
		[NumeratorDesc] [varchar](500) NULL,
		[GoalDesc] [varchar](250) NULL,
		[LastModifiedDate] [datetime] NOT NULL,
	 CONSTRAINT [PK_CUS_MeaningfulUseDetail] PRIMARY KEY CLUSTERED 
	(
		[MeaningfulUseDetailUid] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
	END

	IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CUS_MeaningfulUseDetail]') AND name = N'IX_CUS_MeaningfulUseDetail')
		CREATE NONCLUSTERED INDEX [IX_CUS_MeaningfulUseDetail] ON [dbo].[CUS_MeaningfulUseDetail]
		(
			[ReportInstanceUid] ASC,
			[ItemDefinitionUid] ASC,
			[PersonUid] ASC
		)
		INCLUDE ( 	[CategoryName],
			[CategoryNumber],
			[MeasureNumber],
			[NumeratorValue],
			[DenominatorValue],
			[ExclusionDesc],
			[DenominatorDesc],
			[SubMeasureNumber],
			[PersonLnFn],
			[ProviderUid],
			[ProviderLnFn],
			[NumeratorDesc],
			[GoalDesc],
			[YesNo],
			[ObjectiveDesc],
			[MeasureDesc],
			[MeasureDetailDesc],
			[MeaningfulUseDetailUid],
			[ProviderNPI],
			[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF_CUS_MeaningfulUseDetail_MeaningfulUseDetailUid]') AND type = 'D')
	BEGIN
		ALTER TABLE [dbo].[CUS_MeaningfulUseDetail] ADD  CONSTRAINT [DF_CUS_MeaningfulUseDetail_MeaningfulUseDetailUid]  DEFAULT (newid()) FOR [MeaningfulUseDetailUid]
	END

	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF_CUS_MeaningfulUseDetail_LastModifiedDate]') AND type = 'D')
	BEGIN
		ALTER TABLE [dbo].[CUS_MeaningfulUseDetail] ADD  CONSTRAINT [DF_CUS_MeaningfulUseDetail_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
	END

	EXEC MIPS_2018_Master_Report_DeleteReportInstance @ReportInstanceUid
	--
	-- Return detail table to caller
	--
	INSERT [CUS_MeaningfulUseDetail](
		[ReportInstanceUid],
		[ItemDefinitionUid],
		[CategoryName],
		[CategoryNumber],
		[MeasureNumber],
		[SubMeasureNumber],
		[PersonUid],
		[PersonLnFn],
		[ProviderUid],
		[ProviderLnFn],
		[ProviderNPI],
		[NumeratorValue],
		[DenominatorValue],
		[YesNo],
		[ObjectiveDesc],
		[MeasureDesc],
		[MeasureDetailDesc],
		[ExclusionDesc],
		[DenominatorDesc],
		[NumeratorDesc],
		[GoalDesc]
	)
	SELECT @ReportInstanceUid AS [ReportInstanceUid],
		t.[ItemDefinitionUid],
		COALESCE(t.[CategoryName], mucd.[CategoryName]) AS [CategoryName],
		t.[CategoryNumber],
		t.[MeasureNumber],
		t.[SubMeasureNumber],
		t.[PersonUid],
		t.[PersonLnFn],
		[ProviderUid],
		t.[ProviderLnFn],
		@ProviderNPI AS [ProviderNPI],
		t.[NumeratorValue],
		t.[DenominatorValue],
		t.[YesNo],
		MUID.[ObjectiveDesc],
		MUID.[MeasureDesc],
		MUID.[MeasureDetailDesc],
		MUID.[ExclusionDesc],
		MUID.[DenominatorDesc],
		MUID.[NumeratorDesc],
		MUID.[GoalDesc]
	FROM [#tblMeaningfulUseDetail] AS t
		INNER JOIN [MeaningfulUseItemDefinition] AS MUID with(nolock) ON MUID.[ItemDefinitionUid] = t.[ItemDefinitionUid]
		INNER JOIN [MeaningfulUseCategoryDefinition] AS mucd with (nolock) ON MUID.[CategoryUid] = mucd.[CategoryUid]
	ORDER BY [CategoryName] ASC,
		[CategoryNumber] ASC,
		[MeasureNumber] ASC,
		[SubMeasureNumber] ASC,
		[NumeratorValue] DESC,
		[DenominatorValue] DESC,
		[PersonLnFn] ASC 
	
	BEGIN TRY
		DROP TABLE [#tblMeaningfulUseDetail]
	END TRY
	BEGIN CATCH
	END CATCH
	
	-- Return Meaningful Use results to caller
	SELECT [RowId]
		, [ItemDefinitionUid]
		, [CategoryNumber]
		, [CategoryName]
		, [MeasureNumber]
		, [SubMeasureNumber]
		, [MeasureDesc]
		, [DenominatorDesc]
		, [DenominatorValue]
		, [NumeratorDesc]
		, [NumeratorValue]
		, [YesNo]
		, [CurrentValue]
		, [GoalDesc]
		, [GoalValue]
		, [MetGoal]
		, [ProviderUid]
		, [ProviderLnFn]
	FROM @tblMeaingfulUseSummaryCoreAndMenuSet    
	ORDER BY [CategoryNumber] ASC
		, [MeasureNumber] ASC
		, [SubMeasureNumber] ASC 
	
	IF (@Debug <> 0)
	BEGIN
		SELECT 'GOOD BYE'
	END 
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_Master_Report_DeleteReportInstance]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_Master_Report_DeleteReportInstance] AS' 
END
GO
ALTER PROCEDURE [dbo].[2019PI_Master_Report_DeleteReportInstance] 
	@ReportInstanceUid [uniqueidentifier]
AS
BEGIN
	SET NOCOUNT ON;

	IF @ReportInstanceUid IS NULL
		OR @ReportInstanceUid = '00000000-0000-0000-0000-000000000000'
		RETURN

	EXEC sp_executesql N'IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[CUS_MeaningfulUseDetail]'') AND type in (N''U'')) DELETE [CUS_MeaningfulUseDetail] WHERE [ReportInstanceUid] = @ReportInstanceUid',
		N'@ReportInstanceUid [uniqueidentifier]', @ReportInstanceUid 
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_Master_Report_LoadItemDefinition]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_Master_Report_LoadItemDefinition] AS' 
END
GO
ALTER PROCEDURE [dbo].[2019PI_Master_Report_LoadItemDefinition]
	@ReportInstanceUid [uniqueidentifier],
	@ItemDefinitionUid	[uniqueidentifier]AS
BEGIN
	DECLARE @EmptyUid [uniqueidentifier] = '00000000-0000-0000-0000-000000000000'

	IF @ReportInstanceUid IS NULL
		OR @ReportInstanceUid = @EmptyUid
		OR @ItemDefinitionUid IS NULL
		OR @ItemDefinitionUid = @EmptyUid
		RETURN

	DECLARE @sql [nvarchar](max) = N'IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[CUS_MeaningfulUseDetail]'') AND type in (N''U''))
		SELECT [ItemDefinitionUid], [CategoryName], [CategoryNumber], [MeasureNumber], [SubMeasureNumber], [PersonUid], [PersonLnFn],
			[ProviderUid], [ProviderLnFn], [ProviderNPI], [NumeratorValue], [DenominatorValue], [YesNo], [ObjectiveDesc], [MeasureDesc],
			[MeasureDetailDesc], [ExclusionDesc], [DenominatorDesc], [NumeratorDesc],[GoalDesc]
		FROM [CUS_MeaningfulUseDetail] with(nolock)
		WHERE [ReportInstanceUid] =  @ReportInstanceUid
			AND [ItemDefinitionUid] = @ItemDefinitionUid
		ORDER BY [CategoryName] ASC, [CategoryNumber] ASC, [MeasureNumber] ASC,	[SubMeasureNumber] ASC,	[NumeratorValue] DESC, [DenominatorValue] DESC,
			[PersonLnFn] ASC'

	EXEC sp_executesql @sql, N'@ReportInstanceUid [uniqueidentifier], @ItemDefinitionUid [uniqueidentifier]'
		, @ReportInstanceUid
		, @ItemDefinitionUid
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_Medicaid_CoreMeasure_02_SubMeasure_01]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_Medicaid_CoreMeasure_02_SubMeasure_01] AS' 
END
GO
ALTER PROC [dbo].[2019PI_Medicaid_CoreMeasure_02_SubMeasure_01]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_Medicaid_CoreMeasure_02_SubMeasure_01 controlled substances-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Generate and transmit permissible prescriptions electronically (eRx) for controlled substances.
	--
	-- Goal              : More than 50 percent of all permissible prescriptions, or all prescriptions, written by the EP 
	--                     are queried for a drug formulary and transmitted electronically using CEHRT.
	--                
	-- Exclusion         : Any EP who:  
	--                      (1) Writes fewer than 100 permissible prescriptions during the EHR reporting period.  
	--                      (2) Does not have a pharmacy within their organization and there are no pharmacies that accept electronic 
	--                           prescriptions within 10 miles of the practice location at the start of his/her EHR reporting period.
	--
	-- Denominator       : Number of prescriptions written for drugs requiring a prescription in order to be dispensed 
	--                     other than controlled substances during the EHR reporting period; or Number of prescriptions 
	--                     written for drugs requiring a prescription in order to be dispensed during the EHR reporting period.
	--
	-- Numerator         : The number of prescriptions in the denominator generated, queried for a drug formulary and 
	--                     transmitted electronically using CEHRT.
	--

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = '0F078236-FF39-4323-80E2-3074BF71984C'
	DECLARE @RxStatusTransmittedSuccessfully UNIQUEIDENTIFIER = 'B1F7EFAF-D56D-4BAD-AE1F-8205E1D00B58' 
	DECLARE @RxStatusQueuedForTransmission   UNIQUEIDENTIFIER = '0605B6F6-2FE4-49CB-B868-9DF448AB3E01'

	TRUNCATE TABLE #MetricDataTemp

	-- Initialize work table
	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
	SELECT @ItemDefinitionUid AS [ItemDefinitionUid]
		, med.[PersonUid]
		, COUNT(sts.[eRxStatusUid]) AS [NumeratorValue]                        
		, COUNT(med.[MedicationSIGUid]) AS [DenominatorValue]
		, null AS [YesNo]
	FROM   [#tblMedicationList] AS med
		INNER JOIN MedicationSIG sig on med.[MedicationSIGUid] = sig.MedicationSIGUid AND sig.FederalDEAClassCode > 0
		LEFT JOIN [ListeRxStatus] AS sts WITH(NOLOCK) ON  med.[eRxStatusUid] = sts.[eRxStatusUid]
		 AND (sts.[eRxStatusUid] IN(@RxStatusTransmittedSuccessfully, @RxStatusQueuedForTransmission))
	WHERE med.[Dispensable] <> 0
		AND med.[IsSampleGiven] = 0
		AND med.[IsAdministered] = 0
		--AND (med.[reffederaldeaclasscode] IS NULL OR med.[reffederaldeaclasscode] <> 0)
		AND [SIGDetailCount] = 1
	GROUP BY med.[PersonUid]
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_Medicaid_CoreMeasure_02_SubMeasure_01 -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_Medicaid_CoreMeasure_02_SubMeasure_02]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_Medicaid_CoreMeasure_02_SubMeasure_02] AS' 
END
GO
ALTER PROC [dbo].[2019PI_Medicaid_CoreMeasure_02_SubMeasure_02]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	IF (@Debug = 1)
	BEGIN
		SELECT 'MUIII_CoreMeasure_02 non-controlled substances-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- 2019PI Medicaid CoreMeasure 02 SubMeasure 02
	-- ================================================
	--
	-- Objective         : Generate and transmit permissible prescriptions electronically (eRx) for non-controlled substances.
	--
	-- Goal              : More than 50 percent of all permissible prescriptions, or all prescriptions, written by the EP 
	--                     are queried for a drug formulary and transmitted electronically using CEHRT.
	--                
	-- Exclusion         : Any EP who:  
	--                      (1) Writes fewer than 100 permissible prescriptions during the EHR reporting period.  
	--                      (2) Does not have a pharmacy within their organization and there are no pharmacies that accept electronic 
	--                           prescriptions within 10 miles of the practice location at the start of his/her EHR reporting period.
	--
	-- Denominator       : Number of prescriptions written for drugs requiring a prescription in order to be dispensed 
	--                     other than controlled substances during the EHR reporting period; or Number of prescriptions 
	--                     written for drugs requiring a prescription in order to be dispensed during the EHR reporting period.
	--
	-- Numerator         : The number of prescriptions in the denominator generated, queried for a drug formulary and 
	--                     transmitted electronically using CEHRT.
	--

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = 'D1DA3596-E1E1-4BB6-B747-EE1107671F27'
	DECLARE @RxStatusTransmittedSuccessfully UNIQUEIDENTIFIER = 'B1F7EFAF-D56D-4BAD-AE1F-8205E1D00B58' 
	DECLARE @RxStatusQueuedForTransmission   UNIQUEIDENTIFIER = '0605B6F6-2FE4-49CB-B868-9DF448AB3E01'

	TRUNCATE TABLE #MetricDataTemp

	-- Initialize work table
	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
	SELECT @ItemDefinitionUid AS [ItemDefinitionUid]
		, med.[PersonUid]
		, COUNT(sts.[eRxStatusUid]) AS [NumeratorValue]                        
		, COUNT(med.[MedicationSIGUid]) AS [DenominatorValue]
		, null AS [YesNo]
	FROM   [#tblMedicationList] AS med
		LEFT JOIN [ListeRxStatus] AS sts WITH(NOLOCK) ON  med.[eRxStatusUid] = sts.[eRxStatusUid]
		 AND (sts.[eRxStatusUid] IN(@RxStatusTransmittedSuccessfully, @RxStatusQueuedForTransmission))
	WHERE med.[Dispensable] <> 0
		AND med.[IsSampleGiven] = 0
		AND med.[IsAdministered] = 0
		AND med.[reffederaldeaclasscode] = 0
		AND [SIGDetailCount] = 1
	GROUP BY med.[PersonUid]
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_Medicaid_CoreMeasure_02_SubMeasure_02 -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_Medicaid_CoreMeasure_04_SubMeasure_01]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_Medicaid_CoreMeasure_04_SubMeasure_01] AS' 
END
GO
ALTER PROC [dbo].[2019PI_Medicaid_CoreMeasure_04_SubMeasure_01]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_Medicaid_CoreMeasure_04_SubMeasure_01 -- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END


	-- MU Stage 3 Core Measure 4 -- Sub Measure 1 of 3
	-- =========================================
	--
	-- Objective         : Use computerized provider order entry (CPOE) for medication, laboratory and radiology 
	--                     orders directly entered by any licensed healthcare professional who can enter orders 
	--                     into the medical record per state, local and professional guidelines.
	--
	-- Goal              : More than 60 percent of medication orders created by the EP during the EHR reporting 
	--                     period are recorded using CPOE.
	--
	-- Exclusion         : Any EP who writes fewer than 100 medication, radiology, or laboratory orders during the EHR reporting period.
	--
	-- Denominator       : Number of MEDICATION orders created by the EP during the EHR reporting period.
	--
	-- Numerator         : The number of orders in the denominator recorded using CPOE.
	--
	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = 'F115A467-6E9E-4951-A12B-8162D80A6E8E'
	DECLARE @DiscontinueReason_Deleted UNIQUEIDENTIFIER = 'E322D823-F96D-4070-AF3B-AAB21B21E6A9'
	DECLARE @VisitTypeStrikeOut UNIQUEIDENTIFIER = 'FB954167-9D1C-43B7-9F5B-A76260654C96'
	DECLARE @PatientTypeTest    UNIQUEIDENTIFIER = '77A41E18-5554-4874-9454-54DC3D7A33A0'
	DECLARE @UTC_RptTimespan_StartDate DATETIME,@UTC_RptTimespan_EndDate DATETIME
	SELECT @UTC_RptTimespan_StartDate = dbo.getPracticeUTCDateTime (@RptTimespan_StartDate)
	SELECT @UTC_RptTimespan_EndDate   = DATEADD(DAY,1,dbo.getPracticeUTCDateTime(@RptTimespan_EndDate))

	TRUNCATE TABLE #MetricDataTemp

	IF OBJECT_ID('#tblMedicationOrderList', 'U') IS NOT NULL
	begin 
		--delete from #tblMedicationOrderList
		drop table #tblMedicationOrderList
	end


	CREATE TABLE #tblMedicationOrderList
	(
		MedicationSIGUid				UNIQUEIDENTIFIER NOT NULL PRIMARY KEY CLUSTERED,
		CreatedDate						DATETIME NOT NULL,
		RelVisitMedicationUid			UNIQUEIDENTIFIER,
		PersonUid						UNIQUEIDENTIFIER,
		TestPat							BIT,
		LicensedHealthcareProfessional	BIT				NOT NULL,
		Dispensable						BIT				NULL,
		IsSampleGiven					BIT				NOT NULL,
		IsAdministered					BIT				NOT NULL,
		reffederaldeaclasscode			BIT				NULL,
		SIGDetailCount					INT				NULL,
		eRxStatusUid					UNIQUEIDENTIFIER
	)

	--- User Different table MedicationList
	INSERT #tblMedicationOrderList (MedicationSIGUid,CreatedDate,RelVisitMedicationUid,PersonUid,TestPat
			,LicensedHealthcareProfessional,Dispensable,IsSampleGiven,IsAdministered,reffederaldeaclasscode,SIGDetailCount,eRxStatusUid)
	SELECT ms.MedicationSIGUid,ms.CreatedDateTime,rvm.RelVisitMedicationUid,p.PersonUid,dbo.UDF_CQMTestPatient(p.PersonUid) AS TestPat
		,COALESCE(u.LicensedHealthcareProfessional,0) AS LicensedHealthcareProfessional
		,CASE WHEN fdb_d.medid IS NOT NULL THEN 1 ELSE 0 END AS Dispensable,ms.IsSampleGiven,ms.IsAdministered,fdb_d.reffederaldeaclasscode
		,(SELECT COUNT(SIGDetailUid) FROM SIGDetail WHERE MedicationSIGUid = ms.MedicationSIGUid) AS SIGDetailCount
		,rvm.eRxStatusUid
	FROM MedicationSIG ms WITH(NOLOCK)
	INNER JOIN RelVisitMedication rvm WITH(NOLOCK) ON ms.MedicationSIGUid=rvm.MedicationSIGUid AND  (rvm.ReadyToPrescribe=1 or rvm.Prescribed= 1) 
	INNER JOIN Visit v WITH(NOLOCK) ON rvm.VisitUid=v.VisitUid AND (v.VisitTypeUid is null or v.VisitTypeUid != @VisitTypeStrikeOut)
	INNER JOIN Person p WITH(NOLOCK) on v.PatientUid=p.PersonUid
	LEFT JOIN UserPRM u WITH(NOLOCK) ON ms.CreatedBy=u.PersonUid
	LEFT JOIN dbo.NDD_SearchDispensable fdb_d ON fdb_d.IsDelete = 0 AND fdb_d.medid = ms.FDB_MEDID
	WHERE NOT EXISTS(SELECT rps.PatientUid FROM RelPatientStatus rps WITH(NOLOCK) WHERE rps.PatientUid=p.PersonUid AND rps.PatientStatusUid = @PatientTypeTest)
		AND (p.DeathDate IS NULL OR p.DeathDate >= @RptTimespan_StartDate)
		AND (
			v.visittypeuid <> @visitTypeStrikeOut
			OR v.visittypeuid IS NULL
			)
		AND ms.CreatedDateTime >= @UTC_RptTimespan_StartDate AND ms.CreatedDateTime < @UTC_RptTimespan_EndDate
		AND (ms.ProviderUid IN (SELECT Element FROM dbo.Split(@ProviderUid, ',')) OR @ProviderUid IS NULL)
		AND (
				(ms.DiscontinueReasonUid IS NULL) 
			or 
				(ms.DiscontinueRecordDate >= @RptTimespan_StartDate 
					AND ms.DiscontinueReasonUid != @DiscontinueReason_Deleted)
			)

	-- calculate DEN and NUM
	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
	SELECT @ItemDefinitionUid AS ItemDefinitionUid
			,med.PersonUid
--			,SUM(CONVERT(INT,COALESCE(med.LicensedHealthcareProfessional,0))) AS NumeratorValue            
			,COUNT(distinct (CASE WHEN med.LicensedHealthcareProfessional = 1 THEN med.MedicationSIGUid ELSE NULL END)) AS NumeratorValue            
			,COUNT(distinct med.MedicationSIGUid) AS DenominatorValue
			,null AS YesNo
	FROM   #tblMedicationOrderList med
	WHERE med.Dispensable=1 
		--and med.IsSampleGiven=0 
		--and med.IsAdministered=0 
		--and med.reffederaldeaclasscode=0
		--and med.sigdetailcount=1
	GROUP BY med.PersonUid

	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END


	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_Medicaid_CoreMeasure_04_SubMeasure_01 -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_Medicaid_CoreMeasure_04_SubMeasure_02]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_Medicaid_CoreMeasure_04_SubMeasure_02] AS' 
END
GO
ALTER PROC [dbo].[2019PI_Medicaid_CoreMeasure_04_SubMeasure_02]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_Medicaid_CoreMeasure_04_SubMeasure_02 -- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MU Stage 3 Core Measure 4 -- Sub Measure 2 of 3
	-- =========================================
	--
	-- Objective         : Use computerized provider order entry (CPOE) for medication, laboratory and radiology 
	--                      orders directly entered by any licensed healthcare professional who can enter orders 
	--                     into the medical record per state, local and professional guidelines.
	--
	-- Goal              : More than 60 percent of LABORATORY orders created by the EP during the EHR reporting 
	--                     period are recorded using CPOE.
	--
	-- Exclusion         : Any EP who writes fewer than 100 medication, radiology, or laboratory orders during the EHR reporting period.
	--
	-- Denominator       : Number of radiology orders created by the EP during the EHR reporting period.
	--
	-- Numerator         : The number of orders in the denominator recorded using CPOE.
	--
	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = '0F264F2C-9EAD-4680-9494-6141A0B56F38'
	TRUNCATE TABLE #MetricDataTemp

	DECLARE @LabProcedureTypeUid UNIQUEIDENTIFIER = 'ED8E7B10-9769-4D4D-9816-1117A95AF96A'

	--#tblOrderList already screens for TestPatient, StrikeOut and IsDelete of Visit, VisitProcedure, and ObservationOrder
	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
	SELECT @ItemDefinitionUid AS ItemDefinitionUid
		,oo.PatientUid
		,COUNT(distinct CASE WHEN oo.LicensedHealthcareProfessional=1 THEN oo.ObservationOrderUid
			ELSE NULL END) AS NumeratorValue            
--		,SUM(CONVERT(INT,COALESCE(oo.LicensedHealthcareProfessional,0))) AS NumeratorValue            
		,COUNT(distinct oo.ObservationOrderUid) AS DenominatorValue
		,null AS YesNo
	FROM   #tblOrderList oo 
	WHERE (oo.ProcedureCodeTypeUid = @LabProcedureTypeUid OR oo.ProcedureCodeTypeName like '%Lab%' OR oo.AttachmentTypeName LIKE '%Lab%Result%') 
		AND oo.CreatedBy IS NOT NULL
	GROUP BY oo.PatientUid


	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_Medicaid_CoreMeasure_04_SubMeasure_02 -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_Medicaid_CoreMeasure_04_SubMeasure_03]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_Medicaid_CoreMeasure_04_SubMeasure_03] AS' 
END
GO
ALTER PROC [dbo].[2019PI_Medicaid_CoreMeasure_04_SubMeasure_03]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_Medicaid_CoreMeasure_04_SubMeasure_03 -- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- 2015 Core Measure 3 -- Sub Measure 3 of 3
	-- =========================================
	-- Diagnostic Imaging = Radiology
	--
	-- Objective         : Use computerized provider order entry (CPOE) for medication, laboratory and radiology 
	--                     orders directly entered by any licensed healthcare professional who can enter orders 
	--                     into the medical record per state, local and professional guidelines.
	--
	-- Goal              : More than 60 percent of Diagnositic Imaging orders created by the EP during the EHR reporting
	--                     period are recorded using CPOE.
	--
	-- Exclusion         : Any EP who writes fewer than 100 medication, radiology, or laboratory orders during the EHR reporting period.
	--
	-- Denominator       : Number of diagnositic imagine orders created by the EP during the EHR reporting period.
	--
	-- Numerator     : The number of orders in the denominator recorded using CPOE.
	--
	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = '2ACEDD6C-B488-4C90-851D-7926183D4035'
	TRUNCATE TABLE #MetricDataTemp

	DECLARE @RadProcedureTypeUid UNIQUEIDENTIFIER = '7B04148E-4902-496B-B027-F0EE5038D157'

	--#tblOrderList already screens for TestPatient, StrikeOut and IsDelete of Visit, VisitProcedure, and ObservationOrder
	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
	SELECT @ItemDefinitionUid AS ItemDefinitionUid
		,oo.PatientUid
		,COUNT(distinct CASE WHEN oo.LicensedHealthcareProfessional=1 THEN oo.ObservationOrderUid
			ELSE NULL END) AS NumeratorValue            
--		,SUM(CONVERT(INT,COALESCE(oo.LicensedHealthcareProfessional,0))) AS NumeratorValue            
		,COUNT(distinct oo.ObservationOrderUid) AS DenominatorValue
		,null AS YesNo
	FROM   #tblOrderList oo 
	WHERE (oo.ProcedureCodeTypeUid = @RadProcedureTypeUid OR oo.ProcedureCodeTypeName like '%Radiology%' OR oo.AttachmentTypeName LIKE '%Radiology%Result%')
		AND oo.CreatedBy IS NOT NULL
	GROUP BY oo.PatientUid


	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END


	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_Medicaid_CoreMeasure_04_SubMeasure_03 -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_Medicaid_CoreMeasure_05_SubMeasure_01]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_Medicaid_CoreMeasure_05_SubMeasure_01] AS' 
END
GO
ALTER PROC [dbo].[2019PI_Medicaid_CoreMeasure_05_SubMeasure_01]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT,
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_Medicaid_CoreMeasure_05_SubMeasure_01 -- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- 2015 Core Measure 8 -- Sub Measure 1 of 2
	-- ==============
	--
	-- Objective         : Provide patients the ability to view online, download and transmit their health
	--                     information within four business days of the information being available to the EP.
	--
	-- Goal              : More than 80 percent of all unique patients seen by the EP during the EHR reporting
	--                     period are provided timely (available to the patient within 4 business days after 
	--                     the information is available to the EP) online access to their health information.
	--
	-- Exclusion         : (1) Neither orders nor creates any of the information listed for inclusion as 
	--                         part of both measures, except for "Patient name" and "Provider`s name and 
	--                         office contact information, may exclude both measures.  
	--                 
	--                     (2) Conducts 80 percent or more of his or her patient encounters in a county 
	--                         that does not have 80 percent or more of its housing units with 3Mbps broadband 
	--                         availability according to the latest information available from the FCC on the 
	--                         first day of the EHR reporting period may exclude only the second measure.
	--
	-- Denominator       : Number of unique patients seen by the EP during the EHR reporting period.
	--
	-- Numerator         : The number of patients in the denominator who have timely (within 4 business days
	--                     after the information is available to the EP) online access to their health information.
	--                     Number of patients with Portal Accounts.
	--
	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = '642156DB-51EF-4900-9E19-A62408DAB4D5'
	TRUNCATE TABLE #MetricDataTemp

	-- Populate Denominator Value
	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
		SELECT @ItemDefinitionUid AS ItemDefinitionUid
				,p.PersonUid
				,COUNT(DISTINCT CASE WHEN p.HasPortalAccount > 0 THEN p.PersonUid
						ELSE NULL END)AS NumeratorValue            
				,COUNT(DISTINCT p.PersonUid) AS DenominatorValue
				,null AS YesNo
		FROM  #tblPatientList p
		WHERE p.IsEM = 1
		GROUP BY p.PersonUid
    
    
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_Medicaid_CoreMeasure_05_SubMeasure_01 -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_Medicaid_CoreMeasure_05_SubMeasure_02]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_Medicaid_CoreMeasure_05_SubMeasure_02] AS' 
END
GO
ALTER PROC [dbo].[2019PI_Medicaid_CoreMeasure_05_SubMeasure_02]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_Medicaid_CoreMeasure_05_SubMeasure_02 -- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- 2015 Core Measure 6  (Same as Stage 1 Menu Set 7)
	-- =============================================
	--
	-- Objective         : Use clinically relevant information from Certified EHR Technology to identify
	--                     patient-specific education resources and provide those resources to the patient.
	--
	-- Goal              : Patient-specific education resources identified by Certified EHR Technology are 
	--                     provided to patients for more than 35 percent of all unique patients with office 
	--                     visits seen by the EP during the EHR reporting period.
	-- 
	-- Exclusion         : Any EP who has no office visits during the EHR reporting period.
	--
	-- Denominator       : Number of unique patients with office visits seen by the EP during the EHR reporting period.
	--
	-- Numerator         : Number of patients in the denominator who were provided patient-specific education resources
	--                     identified by the Certified EHR Technology.
	--

	--PrintedDate is a DATETIME UTC value, VisitDate is a DATE
	DECLARE @UTC_RptTimespan_StartDate DATETIME,@UTC_RptTimespan_EndDate DATETIME
	SELECT @UTC_RptTimespan_StartDate = dbo.getPracticeUTCDateTime (@RptTimespan_StartDate)
	SELECT @UTC_RptTimespan_EndDate   = DATEADD(DAY,1,dbo.getPracticeUTCDateTime(@RptTimespan_EndDate))


	--Check that the education forms are configured to show on protal
	DECLARE @ShowEduFormsOnPortal BIT
		,@AllowPatientsToViewEducationalMaterial UNIQUEIDENTIFIER = 'AAAD592B-0BFF-4141-9F1C-504786CFE873'
	SELECT @ShowEduFormsOnPortal=BoolValue
	FROM ListProductParameter pp
	WHERE ProductParameterUid=@AllowPatientsToViewEducationalMaterial


	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = '6F41FD2A-9105-4F4E-8A14-55A1173F69EF'
	TRUNCATE TABLE #MetricDataTemp

	-- Populate Denominator Value
	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
		SELECT @ItemDefinitionUid AS ItemDefinitionUid
				,p.PersonUid
				,COUNT(DISTINCT CASE WHEN p.HasEduForm = 1 
						AND (
							(p.HasPortalAccount = 1 AND @ShowEduFormsOnPortal=1)
							) THEN p.PersonUid
						ELSE NULL END) AS NumeratorValue            
				,COUNT(DISTINCT p.PersonUid) AS DenominatorValue
				,null AS YesNo
		FROM #tblPatientList p
		WHERE p.IsEM = 1
		GROUP BY p.PersonUid
 
   
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_Medicaid_CoreMeasure_05_SubMeasure_02 -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END


END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_Medicaid_CoreMeasure_06_SubMeasure_01]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_Medicaid_CoreMeasure_06_SubMeasure_01] AS' 
END
GO
ALTER PROC [dbo].[2019PI_Medicaid_CoreMeasure_06_SubMeasure_01]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT,
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_Medicaid_CoreMeasure_06_SubMeasure_01 -- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END
	
	-- MU Stage 3 Core Measure 6 -- Sub Measure 1 of 2
	-- =========================================
	--
	-- Objective         : Provide patients the ability to view online, download and transmit their health
	--                     information within four business days of the information being available to the EP.
	--
	-- Goal              : More than 5 percent of all unique patients seen by the EP during the EHR reporting 
	--                     period (or their authorized representatives) view, download, or transmit to a third 
	--                     party their health information.
	--
	-- Exclusion         : (1) Neither orders nor creates any of the information listed for inclusion as 
	--                         part of both measures, except for "Patient name" and "Provider`s name and 
	--                         office contact information, may exclude both measures.  
	--                        
	--                     (2) Conducts 50 percent or more of his or her patient encounters in a county 
	--                         that does not have 50 percent or more of its housing units with 3Mbps broadband 
	--                         availability according to the latest information available from the FCC on the 
	--                         first day of the EHR reporting period may exclude only the second measure.
	--
	-- Denominator       : Number of unique patients seen by the EP during the EHR reporting period.
	--
	-- Numerator         : The number of unique patients (or their authorized representatives) in the 
	--                     denominator who have viewed online, downloaded, or transmitted to a third 
	--                     party the patient`s health information.
	--
	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = 'D54C6F25-B9AB-4FCD-8AC9-DB7837723528'
	TRUNCATE TABLE #MetricDataTemp
	

	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
		SELECT @ItemDefinitionUid AS ItemDefinitionUid
				,p.PersonUid
				,COUNT(DISTINCT CASE WHEN ViewedOnline.PatientUid IS NOT NULL THEN p.PersonUid
						ELSE NULL END)AS NumeratorValue            
				,COUNT(DISTINCT p.PersonUid) AS DenominatorValue
				,null AS YesNo
		FROM   #tblPatientList p
		OUTER APPLY (SELECT TOP 1 rda.PatientUid 
						FROM RecordDisclosureAudit rda 
						WHERE (rda.DisclosureDate BETWEEN @RptTimespan_StartDate AND @RptTimespan_EndDate)
							AND (rda.DisclosureType in (1,    -- Complete Chart
														2,    -- Clinical Summary
														11))  -- ContinuityOfCareDocument
							AND rda.PatientUid = p.PersonUid
							AND (rda.IsPortal = 1)
					) AS ViewedOnline
		WHERE p.IsEM = 1
		GROUP BY p.PersonUid


	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_Medicaid_CoreMeasure_06_SubMeasure_01 -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_Medicaid_CoreMeasure_06_SubMeasure_02]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_Medicaid_CoreMeasure_06_SubMeasure_02] AS' 
END
GO
ALTER PROC [dbo].[2019PI_Medicaid_CoreMeasure_06_SubMeasure_02]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT,
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_Medicaid_CoreMeasure_06_SubMeasure_02 -- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END


	-- MU Stage 3 Objective 6, Measure 2
	-- ===================
	--
	-- Objective         : Use secure electronic messaging to communicate with patients on relevant health information.
	--
	-- Goal              : A secure message was sent using the electronic messaging function of CEHRT by more than 5% of all unique patients
	--					   (or their authorized representatives) seen by the EP during the EHR reporting period.
	--                      
	-- Exclusion         : Any EP who has no office visits during the EHR reporting period, or any EP who conducts 50 percent
	--                     or more of his or her patient encounters in a county that does not have 50 percent or more of its 
	--                     housing units with 3Mbps broadband availability according to the latest information available from 
	--                     the FCC on the first day of the EHR reporting period.
	--
	-- Denominator       : Number of unique patients seen by the EP during the EHR reporting period.
	--
	-- Numerator         : The number of patients or patient-authorized representatives in the denominator who send a secure 
	--                     electronic message to the EP that is received using the electronic messaging function of CEHRT 
	--                     during the EHR reporting period.
	--

	DECLARE @MessageType_PatientInput UNIQUEIDENTIFIER = '5E9280E5-3388-49E8-A5AE-4DFFBB0A9B89'
		,@MessageSubType_Demographics UNIQUEIDENTIFIER = 'D1D54662-29C2-44DA-A0CF-28FEFDF5D825'
		,@MessageSubType_PatientPortalError UNIQUEIDENTIFIER = '786E319F-01EF-48B8-A5A2-8499334A660D'
		,@ProviderUids VARCHAR(MAX)

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = 'B1AB7499-1E00-440E-9E0A-6A161285047F'
	TRUNCATE TABLE #MetricDataTemp

		
    --Force this value to null and populate the @Providers table accordingly
	SELECT @ProviderUid  = NULL

	IF @ProviderUid IS NULL
	BEGIN
		DECLARE @Providers TABLE (ProviderUid VARCHAR(MAX))
		SET @ProviderUids = ''
		
		INSERT INTO @Providers
		SELECT DISTINCT personuid
		FROM UserPrm
		
		IF @ProviderBilling = 1
			BEGIN
				INSERT INTO @Providers
				SELECT DISTINCT RenderingProviderUid
				FROM #tblVisitList
				WHERE RenderingProviderUid IS NOT NULL
			END
			ELSE
			BEGIN
				INSERT INTO @Providers
				SELECT DISTINCT ProviderUid
				FROM #tblVisitList
				WHERE ProviderUid IS NOT NULL
			END

		SELECT @ProviderUids = @ProviderUids+ProviderUid+','
		FROM @Providers
		WHERE ProviderUid IS NOT NULL

		IF LEN(@ProviderUids) > 0
			SELECT @ProviderUids = LEFT(@ProviderUids, LEN(@ProviderUids) - 1)	
	END
	--ELSE
		--SET @ProviderUids = @ProviderUid

	-- Populate Denominator Value

	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
		SELECT @ItemDefinitionUid AS ItemDefinitionUid
				,p.PersonUid
				,COUNT(DISTINCT CASE WHEN m.MessageUid IS NOT NULL THEN m.PersonUid
					ELSE NULL END) AS NumeratorValue      
				,COUNT(DISTINCT p.PersonUid) AS DenominatorValue
				,null AS YesNo
		FROM #tblPatientList p
		OUTER APPLY (SELECT Parameter FROM SplitCLR(@ProviderUids,',')) prov
		LEFT JOIN [Message] m ON m.CreatedByUid = prov.Parameter
			AND m.PersonUid = p.PersonUid
			AND m.MessageTypeUid = @MessageType_PatientInput
			AND m.MessageSubTypeUid NOT IN(@MessageSubType_Demographics,@MessageSubType_PatientPortalError)
		    AND m.CreatedDate BETWEEN @RptTimespan_StartDate AND @RptTimespan_EndDate
			--AND m.StrikeOut = 0 -- DO NOT Exclude strike outs, Patient can not strike out and did send a message
		WHERE p.IsEM = 1
		GROUP BY p.PersonUid

	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END

	
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_Medicaid_CoreMeasure_06_SubMeasure_02 -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_Medicaid_CoreMeasure_06_SubMeasure_03]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_Medicaid_CoreMeasure_06_SubMeasure_03] AS' 
END
GO
ALTER PROC [dbo].[2019PI_Medicaid_CoreMeasure_06_SubMeasure_03]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT,
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_Medicaid_CoreMeasure_06_SubMeasure_03 -- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END


	-- MU Stage 3 Objective 6, Measure 2
	-- ===================
	--
	-- Objective         : Incorporate patient-generated health data into the application
	--
	-- Goal              : Patient generated health data or data from a nonclinical setting is incorporated into the 
	--					   CEHRT for more than 5 percent of all unique patients seen by the EP during the EHR reporting period.
	--                      
	--
	-- Denominator       : Number of unique patients seen by the EP during the EHR reporting period.
	--
	-- Numerator         : The number of patients in the denominator for whom data from non-clinical settings, which may include 
	--					   patient-generated health data, is captured through the CEHRT into the patient record during the EHR reporting period.
	--

	DECLARE @PatientDataAttachmentTypeUid UNIQUEIDENTIFIER = 'F61572DF-B00C-44B9-AE18-32EA780FCD01'
	DECLARE @AdvanceDirectiveTypeUid UNIQUEIDENTIFIER = '10101011-0000-0000-0000-000000000101'

		,@ProviderUids VARCHAR(MAX)

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = '36D59AB7-C2ED-4231-8654-A0B574B9511F'
	TRUNCATE TABLE #MetricDataTemp

		
    --Force this value to null and populate the @Providers table accordingly
	SELECT @ProviderUid  = NULL

	IF @ProviderUid IS NULL
	BEGIN
		DECLARE @Providers TABLE (ProviderUid VARCHAR(MAX))
		SET @ProviderUids = ''
		
		INSERT INTO @Providers
		SELECT DISTINCT personuid
		FROM UserPrm
		
		IF @ProviderBilling = 1
			BEGIN
				INSERT INTO @Providers
				SELECT DISTINCT RenderingProviderUid
				FROM #tblVisitList
				WHERE RenderingProviderUid IS NOT NULL
			END
			ELSE
			BEGIN
				INSERT INTO @Providers
				SELECT DISTINCT ProviderUid
				FROM #tblVisitList
				WHERE ProviderUid IS NOT NULL
			END

		SELECT @ProviderUids = @ProviderUids+ProviderUid+','
		FROM @Providers
		WHERE ProviderUid IS NOT NULL

		IF LEN(@ProviderUids) > 0
			SELECT @ProviderUids = LEFT(@ProviderUids, LEN(@ProviderUids) - 1)	
	END
	--ELSE
		--SET @ProviderUids = @ProviderUid

	-- Populate Denominator Value

	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
		SELECT @ItemDefinitionUid AS ItemDefinitionUid
				,p.PersonUid
				,COUNT(DISTINCT CASE WHEN a.AttachmentUid IS NOT NULL OR ag.AttachmentGroupUid IS NOT NULL THEN COALESCE(a.AttachmentUid,ag.AttachmentGroupUid)
					ELSE NULL END) AS NumeratorValue      
				,COUNT(DISTINCT p.PersonUid) AS DenominatorValue
				,null AS YesNo
		FROM #tblPatientList p
		LEFT JOIN [RelAttachmentGroup] r ON p.PersonUid = r.PersonUid
		LEFT JOIN Attachment a on r.AttachmentGroupUid = a.AttachmentGroupUid AND a.AttachmentTypeUid IN (@PatientDataAttachmentTypeUid,@AdvanceDirectiveTypeUid)
		LEFT JOIN AttachmentGroup ag on r.AttachmentGroupUid = ag.AttachmentGroupUid AND ag.AttachmentTypeUid IN (@PatientDataAttachmentTypeUid,@AdvanceDirectiveTypeUid)
		WHERE p.IsEM = 1
		GROUP BY p.PersonUid

	IF EXISTS (
		SELECT 1
		FROM #tblMeaningfulUseDetail
		WHERE [ItemDefinitionUid] = @ItemDefinitionUid
	)
    BEGIN
	    UPDATE [#tblMeaningfulUseDetail]
		SET [NumeratorValue] = CASE WHEN [NumeratorValue] > [DenominatorValue] THEN [DenominatorValue] ELSE [NumeratorValue] END
		WHERE [ItemDefinitionUid] = @ItemDefinitionUid
    END

	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END

	
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_Medicaid_CoreMeasure_06_SubMeasure_03 -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_Medicaid_CoreMeasure_07_SubMeasure_01]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_Medicaid_CoreMeasure_07_SubMeasure_01] AS' 
END
GO
ALTER PROC [dbo].[2019PI_Medicaid_CoreMeasure_07_SubMeasure_01]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
      @RptTimespan_StartDate DATE,
      @RptTimespan_EndDate   DATE,
      @ReportMode            BIT, 
      @Debug                 INT
)
AS
BEGIN
      SET NOCOUNT ON;
      IF (@Debug = 1)
      BEGIN
            SELECT 'MUIII_CoreMeasure_07_SubMeasure_1 -- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
      END

      --              
      -- Date           Description 
      -- ==============================================================================================================
      -- 2016.Feb.23    Removed from eligible disclosures those with purpose "Released to Patient" since those are not transmitted electronically. (Bug 46779)
      -- 2014.May.13    Asked by Cornell (Bug #29625) to make the denominator the same as CoreMeasure 15, SubMeasure 01.
        --

      -- MU Stage 3 Core Measure 7 -- Sub Measure 1 of 3
      -- =========================================
      --
      -- Objective         : The EP who transitions their patient to another setting of care or provider of 
      --                     care or refers their patient to another provider of care should provide summary 
      --                     care record for each transition of care or referral.
      --
      -- Goal              : The EP who transitions or refers their patient to another setting of care or provider
      --                     of care provides a summary of care record for more than 10 percent of such transitions 
      --                     and referrals either (a) electronically transmitted using CEHRT to a recipient or 
      --                     (b) where the recipient receives the summary of care record via exchange facilitated by 
      --                     an organization that is a NwHIN Exchange participant or in a manner that is consistent 
      --                     with the governance mechanism ONC establishes for the NwHIN.
      --
      -- Exclusion         : Any EP who transfers a patient to another setting or refers a patient to 
      --                     another provider less than 100 times during the EHR reporting period is 
      --                     excluded from all three measures.
      --
      -- Denominator       : Number of transitions of care and referrals during the EHR reporting period for
      --                     which the EP was the transferring or referring provider.
      --
      -- Numerator         : The number of transitions of care and referrals in the denominator where a summary of 
      --                     care record was a) electronically transmitted using CEHRT to a recipient or b) where 
      --                     the recipient receives the summary of care record via exchange facilitated by an organization 
      --                     that is a NwHIN Exchange participant or in a manner that is consistent with the governance 
      --                     mechanism ONC establishes for the nationwide health information network. The organization can 
      --                     be a third-party or the sender`s own organization.
      --
      DECLARE @UTC_RptTimespan_StartDate DATETIME,@UTC_RptTimespan_EndDate DATETIME
      SELECT @UTC_RptTimespan_StartDate = @RptTimespan_StartDate
      SELECT @UTC_RptTimespan_EndDate   = DATEADD(DAY,1,@RptTimespan_EndDate)

      --RecordDisclosureAudit limit range, -1 day from min referral date and +3 days to max referral date
      DECLARE @RecordDisclosureAudit_StartDate DATE,@RecordDisclosureAudit_EndDate DATE
      SELECT @RecordDisclosureAudit_StartDate = DATEADD(DAY,-1,@RptTimespan_StartDate)
      SELECT @RecordDisclosureAudit_EndDate   = DATEADD(DAY,3,@RptTimespan_EndDate)

      DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = '605A8E57-A2B9-4EBC-896A-EACDB4FBECC5'
      TRUNCATE TABLE #MetricDataTemp

      ;WITH cte_pr AS (
            select pr.*,dbo.UDF_CQMTestPatient (pr.PatientUid) AS TestPatient
            FROM ViewPatientReferralConsultReport pr 
            LEFT JOIN PatientReferral p on pr.PatientReferralUid = p.PatientReferralUid
            LEFT JOIN VisitProcedure vp on p.VisitProcedureUid = vp.VisitProcedureUid
            LEFT JOIN ListProcedure lp on vp.ProcedureUid = lp.ProcedureUid      
            WHERE pr.RefType = 'PatientReferral'
                        AND (pr.ReferredByProviderUid IN (SELECT Element FROM dbo.Split(@ProviderUid, ',')) OR @ProviderUid IS NULL)
                        AND pr.ReferralDate >= @UTC_RptTimespan_StartDate AND pr.ReferralDate < @RecordDisclosureAudit_EndDate
                        AND (lp.ProcedureCodeTypeUid IS NULL OR lp.ProcedureCodeTypeUid NOT IN ('1E605C00-13F0-4B95-AEDB-7AA2E30A8BED'))
      ),
      cte_rda AS (
            SELECT [DisclosureDate] ,
                  [DisclosureType] ,
                  [PatientUid] ,
                  rda.[PatientReferralUid] ,
                  [AttachmentGroupUid] ,
                  rda.[VisitUid] ,
                  [IsPortal],
                  [DisclosureMethod],
                  [Status],
                  [DisclosurePurpose]
            FROM RecordDisclosureAudit rda WITH(NOLOCK)
			--LEFT JOIN PatientReferral pr on rda.PatientReferralUid = pr.PatientReferralUid AND pr.ReferredByProviderUid = @ProviderUid
            WHERE DisclosureDate >= @RecordDisclosureAudit_StartDate
                  AND DisclosureType in (1,    -- Complete Chart
                                                      2,    -- Clinical Summary
                                                      11)  -- ContinuityOfCareDocument
                  AND DisclosureMethod IN (1,5,6,7)
                  AND DisclosurePurpose <> 'Released to Patient' --2016.02.23 dmg
                  AND [Status] > 0
      )
      INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
            SELECT @ItemDefinitionUid AS ItemDefinitionUid
                        ,r.PatientUid
                         ,COUNT(distinct CASE WHEN  rda.DisclosureType IS NOT NULL and rda.status = 4 THEN rda.PatientReferralUid
                              ELSE NULL END) AS NumeratorValue            
						,COUNT(distinct CASE WHEN r.PatientReferralUid is not null  and (r.ReferralStatus in ('Initiated', 'Appointment Confirmed')) THEN r.PatientReferralUid
                             ELSE NULL END) AS DenominatorValue 
                        ,null AS YesNo
            FROM cte_pr r 
           LEFT JOIN cte_rda rda ON r.PatientUid=rda.patientuid AND
                                    (
                                          r.VisitUid=rda.VisitUid 
                                          OR r.PatientReferralUid=rda.PatientReferralUid 
                                          OR r.AttachmentGroupUid=rda.AttachmentGroupUid
                                          OR DATEDIFF(day,r.ReferralDate,rda.DisclosureDate) >= -1
                                    )
            WHERE r.TestPatient = 0
            GROUP BY r.PatientUid
            
      UPDATE #tblMeaningfulUseDetail
      SET NumeratorValue = 
            CASE 
                  WHEN NumeratorValue > DenominatorValue THEN DenominatorValue 
                  ELSE NumeratorValue 
            END
	  WHERE ItemDefinitionUid = @ItemDefinitionUid

      IF (@ReportMode = 1)
      BEGIN
            EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
      END
      
      
      IF (@Debug = 1)
      BEGIN
            SELECT '2019PI_Medicaid_CoreMeasure_07_SubMeasure_01 -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
      END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_Medicaid_CoreMeasure_07_SubMeasure_02]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_Medicaid_CoreMeasure_07_SubMeasure_02] AS' 
END
GO
ALTER PROC [dbo].[2019PI_Medicaid_CoreMeasure_07_SubMeasure_02]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_Medicaid_CoreMeasure_07_SubMeasure_02 -- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	--This is not the logic, needs to be updated

	-- MU Stage 3 Core Measure 7 -- Sub Measure 2 of 3
	-- =========================================
	--
	-- Objective         : The EP who transitions their patient to another setting of care or provider of 
	--                     care or refers their patient to another provider of care should provide summary 
	--                     care record for each transition of care or referral.
	--
	-- Goal              : The EP who transitions or refers their patient to another setting of care or provider
	--                     of care provides a summary of care record for more than 10 percent of such transitions 
	--                     and referrals either (a) electronically transmitted using CEHRT to a recipient or 
	--                     (b) where the recipient receives the summary of care record via exchange facilitated by 
	--                     an organization that is a NwHIN Exchange participant or in a manner that is consistent 
	--                     with the governance mechanism ONC establishes for the NwHIN.
	--
	-- Exclusion         : Any EP who transfers a patient to another setting or refers a patient to 
	--                     another provider less than 100 times during the EHR reporting period is 
	--                     excluded from all three measures.
	--
	-- Denominator       : Number of transitions of care and referrals during the EHR reporting period for
	--                     which the EP was the transferring or referring provider.
	--
	-- Numerator         : The number of transitions of care and referrals in the denominator where a summary of 
	--                     care record was a) electronically transmitted using CEHRT to a recipient or b) where 
	--                     the recipient receives the summary of care record via exchange facilitated by an organization 
	--                     that is a NwHIN Exchange participant or in a manner that is consistent with the governance 
	--                     mechanism ONC establishes for the nationwide health information network. The organization can 
	--                     be a third-party or the sender`s own organization.
	--
	DECLARE @UTC_RptTimespan_StartDate DATETIME,@UTC_RptTimespan_EndDate DATETIME
	SELECT @UTC_RptTimespan_StartDate = @RptTimespan_StartDate, @UTC_RptTimespan_EndDate = @RptTimespan_EndDate
	SELECT @UTC_RptTimespan_StartDate = '01/01/'+CONVERT(VARCHAR(4),DATEPART(YEAR,@UTC_RptTimespan_StartDate))

	DECLARE @InitiatedReferrals TABLE (PatientReferralUid UNIQUEIDENTIFIER)
	INSERT INTO @InitiatedReferrals
	SELECT DISTINCT PatientReferralUid 
	FROM PatientReferralHistory 
	WHERE ReferralTrackingStatusUid IN ('0673DB25-454C-44D8-B83F-AFCF97879AAD','3B180FEC-FAE0-4850-AE16-6172CC31F7A7')

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = '056B6817-F151-4B0B-A910-2830145E7A4D'
	TRUNCATE TABLE #MetricDataTemp

	--INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
	--	SELECT @ItemDefinitionUid AS ItemDefinitionUid
	--			,t.PersonUid
	--			,COUNT(distinct CASE WHEN aa.SummaryOfCareReconciledDate IS NOT NULL THEN aa.SummaryOfCareReconciledDate
	--				ELSE NULL END) AS NumeratorValue            
	--			,COUNT(distinct t.PersonUid) AS DenominatorValue
	--			,null AS YesNo
	--	FROM #tblPatientList t
	--	INNER JOIN RelAttachmentGroup r ON t.PersonUid = r.PersonUid
	--	CROSS APPLY (SELECT TOP 1 * FROM MessageAA a WHERE a.RelAttachmentGroupUid = r.RelAttachmentGroupUid AND a.ElectronicSummaryOfCareReceived = 1 ORDER BY SummaryOfCareReconciledDate DESC) aa
	--	INNER JOIN Message m on aa.MessageUid = m.MessageUid AND (m.CreatedDate >= @UTC_RptTimespan_StartDate AND m.CreatedDate <= @UTC_RptTimespan_EndDate)
	--	GROUP BY t.PersonUid

	;WITH cte_Ref AS (
	SELECT vfp.PersonUid AS PatUid, rag.VisitUid AS Uid, COALESCE(a.AttachmentUid, ag.AttachmentGroupUid) AS AttUid, COALESCE(a.FileDate, ag.LastModifiedDate) AS AttDate, aa.HasClinicalDocument
	FROM #tblPatientList vfp
	INNER JOIN RelAttachmentGroup rag on vfp.PersonUid = rag.PersonUid
	INNER JOIN Visit v on rag.VisitUid = v.VisitUid AND (v.VisitDate >= @RptTimespan_StartDate AND v.VisitDate <= @RptTimespan_EndDate)
	INNER JOIN #tblProviderList prov on v.ProviderUid = prov.ProviderUid
	LEFT JOIN Attachment a on rag.AttachmentGroupUid = a.AttachmentGroupUid
	LEFT JOIN AttachmentGroup ag on rag.AttachmentGroupUid = ag.AttachmentGroupUid
	INNER JOIN ListAttachmentType lat on (a.AttachmentTypeUid = lat.AttachmentTypeUid OR ag.AttachmentTypeUid = lat.AttachmentTypeUid) AND (lat.AttachmentTypeUid = 'B71B8F20-7B7D-4A7C-9E75-05811A0791AD')
	LEFT JOIN MessageAA aa on rag.RelAttachmentGroupUid = aa.RelAttachmentGroupUid --AND aa.SummaryOfCareReconciledDate IS NOT NULL
	LEFT JOIN Message m on aa.MessageUid = m.MessageUid

	UNION ALL

	SELECT vfp.PersonUid AS PatUid, pr.PatientReferralUid AS Uid, aa.MessageUid AS AttUid, pr.CreatedDate AS AttDate, aa.HasClinicalDocument
	FROM #tblPatientList vfp
	INNER JOIN RelAttachmentGroup r ON vfp.PersonUid = r.PersonUid
	INNER JOIN MessageAA aa ON aa.RelAttachmentGroupUid = r.RelAttachmentGroupUid AND aa.ElectronicSummaryOfCareReceived = 1
	INNER JOIN PatientReferral pr on r.PatientReferralUid = pr.PatientReferralUid AND (pr.CreatedDate >= @RptTimespan_StartDate AND pr.CreatedDate <= @RptTimespan_EndDate)
	INNER JOIN PatientProviderRelationship ppr on pr.PatientProviderRelationshipUid = ppr.PatientProviderRelationshipUid
	INNER JOIN #tblProviderList prov on pr.ReferredByProviderUid = prov.ProviderUid
	INNER JOIN @InitiatedReferrals ir on pr.PatientReferralUid = ir.PatientReferralUid
	)


	--SELECT * FROM cte_Ref
	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
		SELECT @ItemDefinitionUid AS ItemDefinitionUid
				,PatUid
				,COUNT(distinct CASE WHEN HasClinicalDocument > 0 THEN Uid
							ELSE NULL END) AS NumeratorValue
				,COUNT(DISTINCT Uid) AS DenominatorValue
				,NULL AS YesNo
		FROM cte_Ref
		GROUP BY PatUid


	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_Medicaid_CoreMeasure_07_SubMeasure_02 -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_Medicaid_CoreMeasure_07_SubMeasure_03]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_Medicaid_CoreMeasure_07_SubMeasure_03] AS' 
END
GO
ALTER PROC [dbo].[2019PI_Medicaid_CoreMeasure_07_SubMeasure_03]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_Medicaid_CoreMeasure_07_SubMeasure_03 -- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	--This is not the logic, needs to be updated

	-- MU Stage 3 Core Measure 7 -- Sub Measure 3 of 3
	-- =========================================
	--
	-- Objective         : The EP who transitions their patient to another setting of care or provider of 
	--                     care or refers their patient to another provider of care should provide summary 
	--                     care record for each transition of care or referral.
	--
	-- Goal              : The EP who transitions or refers their patient to another setting of care or provider
	--                     of care provides a summary of care record for more than 10 percent of such transitions 
	--                     and referrals either (a) electronically transmitted using CEHRT to a recipient or 
	--                     (b) where the recipient receives the summary of care record via exchange facilitated by 
	--                     an organization that is a NwHIN Exchange participant or in a manner that is consistent 
	--                     with the governance mechanism ONC establishes for the NwHIN.
	--
	-- Exclusion         : Any EP who transfers a patient to another setting or refers a patient to 
	--                     another provider less than 100 times during the EHR reporting period is 
	--                     excluded from all three measures.
	--
	-- Denominator       : Number of transitions of care and referrals during the EHR reporting period for
	--                     which the EP was the transferring or referring provider.
	--
	-- Numerator         : The number of transitions of care and referrals in the denominator where a summary of 
	--                     care record was a) electronically transmitted using CEHRT to a recipient or b) where 
	--                     the recipient receives the summary of care record via exchange facilitated by an organization 
	--                     that is a NwHIN Exchange participant or in a manner that is consistent with the governance 
	--                     mechanism ONC establishes for the nationwide health information network. The organization can 
	--                     be a third-party or the sender`s own organization.
	--
	DECLARE @UTC_RptTimespan_StartDate DATETIME,@UTC_RptTimespan_EndDate DATETIME
	SELECT @UTC_RptTimespan_StartDate = @RptTimespan_StartDate
	SELECT @UTC_RptTimespan_EndDate   = DATEADD(DAY,1,@RptTimespan_EndDate)
	--SELECT @UTC_RptTimespan_StartDate = '01/01/'+CONVERT(VARCHAR(4),DATEPART(YEAR,@UTC_RptTimespan_StartDate))

	DECLARE @InitiatedReferrals TABLE (PatientReferralUid UNIQUEIDENTIFIER)
	INSERT INTO @InitiatedReferrals
	SELECT DISTINCT PatientReferralUid 
	FROM PatientReferralHistory 
	WHERE ReferralTrackingStatusUid IN ('0673DB25-454C-44D8-B83F-AFCF97879AAD','3B180FEC-FAE0-4850-AE16-6172CC31F7A7')

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = '1DE8C2E2-9213-42C8-B07F-08EC43342C79'
	TRUNCATE TABLE #MetricDataTemp

	DECLARE @PatReconciled TABLE (PatientUid UNIQUEIDENTIFIER, MessageCnt SMALLINT, VisitDate DATE)
	INSERT INTO @PatReconciled
	SELECT DISTINCT r.PersonUid, COUNT(DISTINCT m.MessageUid), NULL
	FROM MessageAA aa
	INNER JOIN Message m on aa.MessageUid = m.MessageUid AND (m.CreatedDate >= @RptTimespan_StartDate AND m.CreatedDate <= @RptTimespan_EndDate)
	INNER JOIN RelAttachmentGroup r on aa.RelAttachmentGroupUid = r.RelAttachmentGroupUid
	LEFT JOIN Attachment a on r.AttachmentGroupUid = a.AttachmentGroupUid
	LEFT JOIN ListAttachmentType latDM on a.AttachmentTypeUid = latDM.AttachmentTypeUid
	LEFT JOIN AttachmentGroup ag on r.AttachmentGroupUid = ag.AttachmentGroupUid
	INNER JOIN ListAttachmentType lat on (a.AttachmentTypeUid = lat.AttachmentTypeUid OR ag.AttachmentTypeUid = lat.AttachmentTypeUid) 
		AND ((lat.AttachmentTypeUid IN ('91293E86-6AA1-4B30-AA00-7DDD42135D64')) OR lat.ExternalID = 'DMail')
	INNER JOIN PatientReferral pr on r.PatientReferralUid = pr.PatientReferralUid
	INNER JOIN @InitiatedReferrals ir on pr.PatientReferralUid = ir.PatientReferralUid
	INNER JOIN #tblProviderList prov on pr.ReferredByProviderUid = prov.ProviderUid
	LEFT JOIN #tblVisitList tv on tv.PatientUid = r.PersonUid
	WHERE (aa.MedicationAllergiesReconciledDate IS NOT NULL AND aa.MedicationsReconciledDate IS NOT NULL AND aa.ProblemsReconciledDate IS NOT NULL)
		OR lat.AttachmentTypeUid = '91293E86-6AA1-4B30-AA00-7DDD42135D64' 
		OR lat.ExternalID = 'DMail'
	GROUP BY r.PersonUid, aa.MedicationAllergiesReconciledDate, aa.MedicationsReconciledDate, aa.ProblemsReconciledDate

	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
		SELECT @ItemDefinitionUid AS ItemDefinitionUid
				,v.PatientUid
				,SUM(CONVERT(INT,CASE WHEN v.MedicationChecked > 0 AND v.DrugAllergyChecked > 0 AND v.ProblemChecked> 0 THEN v.TransitionOfCare 
					ELSE 0 END)) AS NumeratorValue            
				,SUM(CONVERT(INT,v.TransitionOfCare)) AS DenominatorValue
				,null AS YesNo
		FROM #tblVisitList v
		WHERE v.IsEM = 1
		GROUP BY v.PatientUid

	UPDATE t
	SET NumeratorValue = CASE WHEN p.PatientUid IS NOT NULL THEN NumeratorValue+MessageCnt ELSE NumeratorValue END
	FROM #tblMeaningfulUseDetail t
	INNER JOIN @PatReconciled p on t.PersonUid = p.PatientUid
	WHERE ItemDefinitionUid = @ItemDefinitionUid

      UPDATE #tblMeaningfulUseDetail
      SET NumeratorValue = 
            CASE 
                  WHEN NumeratorValue > DenominatorValue THEN DenominatorValue 
                  ELSE NumeratorValue 
            END
	  WHERE ItemDefinitionUid = @ItemDefinitionUid

	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_Medicaid_CoreMeasure_07_SubMeasure_03 -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_Medicaid_Master_SynchronizeVisitAndPatient]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_Medicaid_Master_SynchronizeVisitAndPatient] AS' 
END
GO
ALTER PROCEDURE [dbo].[2019PI_Medicaid_Master_SynchronizeVisitAndPatient] (
	@Debug [bit] = 0,
	@IncludeTestPatients [bit] = 0
)
AS
BEGIN
	IF (@Debug = 1)
	BEGIN
		SELECT '[2019PI_Medicaid_Master_SynchronizeVisitAndPatient] -- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	UPDATE [#tblVisitList]
		SET [HasPortalAccount] = oa.[HasPortalAccount]
			,[SummaryProvidedToPatient] = CASE WHEN oa.[HasPortalAccount] = 1
							THEN v.[VisitDate]
							ELSE v.[SummaryProvidedToPatient] END 
			,[TestPat] = p.[testPat]
	--select v.*
	from [#tblPatientList] AS p
		INNER JOIN [#tblVisitList] AS v ON p.[PersonUid] = v.[PatientUid]
		OUTER APPLY (SELECT CASE WHEN  p.[HasPortalAccount] = 1
									AND (
										(v.[VisitDate] BETWEEN p.[PortalValid] AND p.[PortalExpire])
										OR (p.[PortalValid] IS NULL AND v.[VisitDate] <= p.[PortalExpire])
										OR (p.[PortalExpire] IS NULL AND p.[PortalValid] <= v.[VisitDate])
										OR (p.[PortalValid] IS NULL AND p.[PortalExpire] IS NULL)
										)
							THEN 1
							ELSE 0 END AS [HasPortalAccount]) AS oa

	IF @IncludeTestPatients = 0
	BEGIN
		DELETE [#tblPatientList] where [TestPat] = 1
	END

	DELETE [#tblVisitList]
	FROM [#tblVisitList] AS v
		LEFT JOIN [#tblPatientList] AS p ON v.[PatientUid] = p.[PersonUid]
	WHERE p.[PersonUid] IS NULL

	IF @Debug = 1
	BEGIN
		select *
		from [#tblVisitList]

		select *
		from [#tblPatientList]
	END

	IF (@Debug = 1)
	BEGIN
		SELECT '[2019PI_Medicaid_Master_SynchronizeVisitAndPatient] -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_Medicaid_Master_PopulateMedicationList]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_Medicaid_Master_PopulateMedicationList] AS' 
END
GO
ALTER PROC [dbo].[2019PI_Medicaid_Master_PopulateMedicationList]
(
    @ProviderUid			[varchar](max),
    @ProviderBilling		[bit],
	@RptTimespan_StartDate	[date],
	@RptTimespan_EndDate	[date],
	@IncludeTestPatients	[bit] = 0,
	@Debug					[bit] = 0
)	
AS
BEGIN
	IF (@Debug = 1)
	BEGIN
		SELECT '[2019PI_Master_PopulateMedicationList] -- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	--CreatedDateTime is a DATETIME UTC value, DiscontinueRecordDate is a DATE
	DECLARE @UTC_RptTimespan_StartDate [datetime] = [dbo].[getPracticeUTCDateTime] (@RptTimespan_StartDate),
		@UTC_RptTimespan_EndDate [datetime] = DATEADD(DAY, 1, [dbo].[getPracticeUTCDateTime](@RptTimespan_EndDate)),
		@DiscontinueReason_Deleted [uniqueidentifier] = 'E322D823-F96D-4070-AF3B-AAB21B21E6A9',
		@VisitTypeStrikeOut [uniqueidentifier] = 'FB954167-9D1C-43B7-9F5B-A76260654C96',
		@PatientTypeTest [uniqueidentifier] = '77A41E18-5554-4874-9454-54DC3D7A33A0'

	INSERT [#tblMedicationList] ([MedicationSIGUid]
		,[CreatedDate]
		,[RelVisitMedicationUid]
		,[PersonUid]
		,[TestPat]
		,[LicensedHealthcareProfessional]
		,[Dispensable]
		,[IsSampleGiven]
		,[IsAdministered]
		,[reffederaldeaclasscode]
		,[SIGDetailCount]
		,[eRxStatusUid]
	)
	SELECT DISTINCT ms.[MedicationSIGUid]
		,ms.[CreatedDateTime]
		,rvm.[RelVisitMedicationUid]
		,p.[PersonUid]
		,[TestPatient].[IsTestPatient] AS [TestPat]
		,COALESCE(u.[LicensedHealthcareProfessional], 0) AS [LicensedHealthcareProfessional]
		,CASE WHEN fdb_d.[medid] IS NOT NULL THEN 1 ELSE 0 END AS [Dispensable]
		,ms.[IsSampleGiven]
		,ms.[IsAdministered]
		,COALESCE(lms.[Schedule], fdb_d.[reffederaldeaclasscode])
		,(SELECT COUNT([SIGDetailUid]) FROM [SIGDetail] with(nolock) WHERE [MedicationSIGUid] = ms.[MedicationSIGUid]) AS [SIGDetailCount]
		,rvm.[eRxStatusUid]
	FROM #tblVisitList AS vv
		INNER JOIN [Visit] AS v WITH(NOLOCK) ON vv.[VisitUid] = v.[VisitUid]
			AND vv.[PatientUid] = v.[PatientUid]
			AND (v.[VisitTypeUid] is null or v.[VisitTypeUid] != @VisitTypeStrikeOut)
		INNER JOIN [RelVisitMedication] AS rvm WITH(NOLOCK) ON v.[VisitUid] = rvm.[VisitUid]
		INNER JOIN [MedicationSIG] AS ms WITH(NOLOCK) ON rvm.[MedicationSIGUid] = ms.[MedicationSIGUid]
			AND rvm.[Prescribed] = 1 
		INNER JOIN [Person] AS p WITH(NOLOCK) on v.[PatientUid] = p.[PersonUid]
		LEFT JOIN [UserPRM] AS u WITH(NOLOCK) ON ms.[CreatedBy] = u.[PersonUid]
		LEFT JOIN [dbo].[NDD_SearchDispensable] AS fdb_d with(nolock) ON fdb_d.[IsDelete] = 0 AND fdb_d.[medid] = ms.[FDB_MEDID]
		LEFT JOIN [RelMedicationStateScheduledDrugName] AS ssd WITH(NOLOCK) on fdb_d.[mnid] = [dbo].[GUIDToInt](ssd.[DrugNameUid])
		LEFT JOIN [ListMedicationStateScheduled] AS lms WITH(NOLOCK) on ssd.[MedicationStateScheduledUid] = lms.[MedicationStateScheduledUid]
		CROSS APPLY
		(
			SELECT (
				CASE WHEN EXISTS(
					SELECT TOP 1 *
					FROM [RelPatientStatus] AS rps WITH(NOLOCK) 
					WHERE rps.[PatientUid]=v.[PatientUid] 
						AND rps.[PatientStatusUid] = @PatientTypeTest
					) THEN 1
					ELSE 0
				END
				) AS [IsTestPatient]
		) AS [TestPatient]
	WHERE NOT EXISTS(SELECT TOP 1 * FROM [RelPatientStatus] AS rps WITH(NOLOCK) WHERE rps.[PatientUid] = p.[PersonUid] AND rps.[PatientStatusUid] = @PatientTypeTest)
		AND (p.[DeathDate] IS NULL OR p.[DeathDate] >= @RptTimespan_StartDate)
		AND (
			v.[VisitTypeUid] <> @visitTypeStrikeOut
			OR v.[VisitTypeUid] IS NULL
			)
		AND ms.[CreatedDateTime] >= @UTC_RptTimespan_StartDate AND ms.[CreatedDateTime] < @UTC_RptTimespan_EndDate
		AND ms.[ProviderUid] IN (SELECT [ProviderUid] FROM [#tblProviderList])
		AND (
				(ms.[DiscontinueReasonUid] IS NULL) 
			or 
				(ms.[DiscontinueRecordDate] >= @RptTimespan_StartDate 
					AND ms.[DiscontinueReasonUid] != @DiscontinueReason_Deleted)
			)

	IF @IncludeTestPatients = 0 
	BEGIN
		DELETE #tblMedicationList
		WHERE [TestPat] = 1
	END

	IF (@Debug = 1)
	BEGIN
		SELECT '[2019PI_Master_PopulateMedicationList] -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_Medicaid_Master_PopulateOrderList]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_Medicaid_Master_PopulateOrderList] AS' 
END
GO
ALTER PROC [dbo].[2019PI_Medicaid_Master_PopulateOrderList]
(
--Move Provider and Billing/Rendering logic to populatevisitlist
    @ProviderUid			[varchar](max),
    @ProviderBilling		[bit],
	@RptTimespan_StartDate	[date],
	@RptTimespan_EndDate	[date],
	@IncludeTestPatients	[bit] = 0,
	@Debug					[bit] = 0
)	
AS
BEGIN
	IF (@Debug = 1)
	BEGIN
		SELECT '[2019PI_Medicaid_Master_PopulateOrderList] -- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	DECLARE @VisitTypeStrikeOut [uniqueidentifier] = 'FB954167-9D1C-43B7-9F5B-A76260654C96',
		@PatientTypeTest [uniqueidentifier] = '77A41E18-5554-4874-9454-54DC3D7A33A0'

	--No UTC conversion, OrderDate is a DATE field
	INSERT [#tblOrderList] ([ObservationOrderUid]
		,[PatientUid]
		,[TestPat]
		,[VPUid]
		,[CreatedBy]
		,[OrderDate]
		,[ProcedureCodeTypeUid]
		,[ProcedureCodeTypeName]
		,[AttachmentTypeUid]
		,[AttachmentTypeName]
		,[LicensedHealthcareProfessional]
		,[ImageResultsDirectlyAccessible]
		,[ResultStatusID]
	)
	--**JRB** ADD CreatedBy uid to the #tblOrderList to exclude nulls for order measures
	SELECT DISTINCT oo.[ObservationOrderUid]
		,oo.[PatientUid]
		,[TestPatient].[IsTestPatient] AS [TestPat]
		,vp.[VisitProcedureUid]
		,oo.[CreatedBy]
		,COALESCE(oo.[OrderDate], oo.[PerformDate], oo.[CreatedDateTime]) AS [OrderDate]
		,lp.[ProcedureCodeTypeUid]
		,pct.[Name]
		,CD.[AttachmentTypeUid]
		,COALESCE(loat.[Name], ooat.[Name]) AS [Name]
		,COALESCE(u.[LicensedHealthcareProfessional], 0) AS [LicensedHealthcareProfessional]
		,lp.[ImageResultsDirectlyAccessible]
		, oo.[ResultStatusID]
	FROM [#tblVisitList] AS vv
		INNER JOIN [ObservationOrder] AS oo WITH(NOLOCK) ON vv.[PatientUid] = oo.[PatientUid]
		INNER JOIN [Person] AS pat WITH(NOLOCK) on oo.[PatientUid] = pat.[PersonUid]
		LEFT JOIN [Visit] AS v WITH(NOLOCK) on oo.[VisitUid] = v.[VisitUid]
		LEFT JOIN [VisitProcedure] AS vp WITH(NOLOCK) on oo.[VisitProcedureUid] = vp.[VisitProcedureUid] 
		LEFT JOIN [ListProcedure] AS lp WITH(NOLOCK) on vp.[ProcedureUid] = lp.[ProcedureUid]
		LEFT JOIN [ListProcedureCodeType] AS pct WITH(NOLOCK) ON lp.[ProcedureCodeTypeUid] = pct.[ProcedureCodeTypeUid]
		LEFT JOIN [ListLaboratoryOrder] AS lo WITH(NOLOCK) ON oo.[LaboratoryOrderUid] = lo.[LaboratoryOrderUid]
		LEFT JOIN [ListAttachmentType] AS loat WITH(NOLOCK) on lo.[AttachmentTypeUid] = loat.[AttachmentTypeUid]
		LEFT JOIN [ListAttachmentType] AS ooat WITH(NOLOCK) on oo.[AttachmentTypeUid] = ooat.[AttachmentTypeUid]
		LEFT JOIN [UserPRM] AS u WITH(NOLOCK) ON oo.[CreatedBy] = u.[PersonUid]
		CROSS APPLY (
			SELECT COALESCE(oo.[OrderDate], CONVERT([date], oo.[CreatedDateTime])) AS [CDate]
				,COALESCE(loat.[AttachmentTypeUid], ooat.[AttachmentTypeUid]) AS [AttachmentTypeUid]
		) AS [CD]
		CROSS APPLY
		(
			SELECT (
				CASE WHEN EXISTS(
					SELECT TOP 1 *
					FROM [RelPatientStatus] AS rps WITH(NOLOCK) 
					WHERE rps.[PatientUid]=v.[PatientUid] 
						AND rps.[PatientStatusUid] = @PatientTypeTest
					) THEN 1
					ELSE 0
				END
				) AS [IsTestPatient]
		) AS [TestPatient]
	WHERE (pat.[DeathDate] IS NULL OR pat.[DeathDate] >= @RptTimespan_StartDate)
		AND CD.[CDate] BETWEEN @RptTimespan_StartDate AND @RptTimespan_EndDate
		AND oo.[OrderProviderUid] IN (SELECT [ProviderUid] FROM [#tblProviderList])
		AND oo.[IsDelete] = 0
		AND oo.[ResultStatusID] > - 1
		AND vp.[NegationReasonUid] IS NULL
		AND (vp.[IsDelete] = 0 or vp.[IsDelete] IS NULL)
		AND (
			v.[VisitTypeUid] <> @visitTypeStrikeOut
			OR v.[VisitTypeUid] IS NULL
			)

	IF @IncludeTestPatients = 0 
	BEGIN
		DELETE #tblOrderList
		WHERE [TestPat] = 1
	END

	IF (@Debug = 1)
	BEGIN
		SELECT '[2019PI_Medicaid_Master_PopulateOrderList] -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_Medicaid_Master_PopulatePatientList]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_Medicaid_Master_PopulatePatientList] AS' 
END
GO
ALTER PROC [dbo].[2019PI_Medicaid_Master_PopulatePatientList]
(
	@ProviderUid			[varchar](max),  
	@RptTimespan_StartDate	[date],
	@RptTimespan_EndDate	[date],
	@ProviderBilling		[bit],
	@ProviderRendering		[bit],
	@Debug					[bit] = 0
)
AS
BEGIN
	IF (@Debug = 1)
	BEGIN
		SELECT '[2019PI_Medicaid_Master_PopulatePatientList] -- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	DECLARE @2YearsAgo  [date] = DATEADD(YEAR, -2, @RptTimespan_StartDate),
		@3YearsAgo  [date] = DATEADD(YEAR, -3, @RptTimespan_StartDate),                                             
		@5YearsAgo  [date] = DATEADD(YEAR, -5, @RptTimespan_StartDate),
		@13YearsAgo [date] = DATEADD(YEAR, -13, @RptTimespan_StartDate),
		@65YearsAgo [date] = DATEADD(YEAR, -65, @RptTimespan_StartDate),
		@VisitTypeStrikeOut [uniqueidentifier] = 'FB954167-9D1C-43B7-9F5B-A76260654C96',
		@PatientTypeTest    [uniqueidentifier] = '77A41E18-5554-4874-9454-54DC3D7A33A0'

	DECLARE @Portal TABLE 
	(	
		[PatientUid] [uniqueidentifier],
		[PersonUid] [uniqueidentifier],
		[CreatedDate] [date],
		[ExpirationDate] [date],
		primary key([PatientUid], [PersonUid]
	)
	)

	INSERT INTO @Portal
	SELECT DISTINCT vp.[PatientUid]
		,pw.[PersonUid]
		,CAST(pw.[CreatedDateTime] AS [date]) AS [CreatedDate]
		,CAST(NULL AS [date]) AS [ExpirationDate]
	FROM (SELECT DISTINCT [PatientUid] FROM [#tblVisitList]) AS vp
		INNER JOIN [RelPatientPersonWeb] AS rel with(nolock) ON vp.[PatientUid] = rel.[PatientUid]
		INNER JOIN [PersonWeb] pw with(nolock) ON (rel.[PersonUid] = pw.[PersonUid]) and pw.[PatientWebAccess] <> 0
     
	--VisitDate is a DATE field and does NOT get UTC conversion
	--DeathDate is a DATE field and does NOT get UTC conversion
	INSERT INTO [#tblPatientList] (
			[PersonUid],
			[PatientLnFn],
			[Birthdate],
			[TestPat],
			[IsEM],
			[IsVP],
			[FullDemographics],
			[HasEduForm],
			[EduFormPrinted],
			[HasPortalAccount],
			[PortalPerson],
			[PortalValid],
			[PortalExpire],
			[SummaryProvidedToPatient],
			[TransitionOfCare],
			[MedicationChecked],
			[SavedByBillingProvider],
			[SavedByRenderingProvider],
			[YearsOldOrOlder2],
			[YearsOldOrOlder3], 
			[YearsOldOrYounger5],
			[YearsOldOrOlder13],
			[YearsOldOrOlder65]
		) 
		SELECT p.[PersonUid]
			,p.[LastName] + ', ' + p.[FirstName] AS [PatientLnFn]
			,p.[Birthdate]
			,[TestPatient].[IsTestPatient] AS [TestPat]
			,MAX(CONVERT(SMALLINT,v.[IsEM])) AS [IsEM]
			,MAX(CONVERT(SMALLINT,v.[IsVP])) AS [IsVP]
			,(Case WHEN p.[LanguageUid] IS NOT NULL 
					AND p.[GenderUid] IS NOT NULL 
					AND (EXISTS(SELECT TOP 1 * FROM [RelPersonRace] AS rpr with(nolock) WHERE rpr.[PersonUid] = p.[PersonUid]))
					AND (EXISTS(SELECT TOP 1 * FROM [RelPersonEthnicity] AS rpe with(nolock) WHERE rpe.[PersonUid] = p.[PersonUid]))
					AND p.[Birthdate] IS NOT NULL 
				THEN 1 
				ELSE 0 END) AS [FullDemographics]
			,MAX(CONVERT(SMALLINT,v.[HasEduForm])) AS [HasEduForm]
			,MAX(CASE WHEN v.[PrintedDate] IS NOT NULL THEN 1 ELSE 0 END) AS [EduFormPrinted]
			,MAX(CASE WHEN portal.[PersonUid] IS NOT NULL AND (portal.[ExpirationDate] IS NULL OR portal.[ExpirationDate] > @RptTimespan_EndDate) THEN 1  
				  ELSE 0
				 END) AS [HasPortalAccount]
			,MAX(CONVERT(VARCHAR(100),portal.[PatientUid])) AS [PortalPerson]
			,MIN(portal.[CreatedDate]) AS [PortalValid]
			,MAX(portal.[ExpirationDate]) AS [PortalExpire]
			,MAX(CASE WHEN v.[SummaryProvidedToPatient] IS NOT NULL THEN 1 ELSE 0 END) AS [SummaryProvidedToPatient]
			,MAX(CONVERT(SMALLINT,v.[TransitionOfCare])) AS [TransitionOfCare]
			,MAX(CONVERT(SMALLINT,v.[MedicationChecked])) AS [MedicationChecked]
			,MAX(CONVERT(SMALLINT,v.[SavedByBillingProvider])) AS [SavedByBillingProvider]
			,MAX(CONVERT(SMALLINT,v.[SavedByRenderingProvider])) AS [SavedByRenderingProvider]
			,CASE WHEN (p.[Birthdate] <= @2YearsAgo) THEN 1 -- 2 years old or older
				WHEN p.[Birthdate] IS NOT NULL THEN 0
				ELSE NULL
				END AS [YearsOldOrOlder2]
			,CASE WHEN (p.[Birthdate] <= @3YearsAgo) THEN 1  -- 3 years old or younger 
				WHEN p.[Birthdate] IS NOT NULL THEN 0                                                                 
				ELSE NULL                                                                                         
				END AS [YearsOldOrOlder3]
			,CASE WHEN (p.[Birthdate] >= @5YearsAgo) THEN 1  -- 5 years old or younger 
				WHEN p.[Birthdate] IS NOT NULL THEN 0
				ELSE NULL
				END AS [YearsOldOrYounger5]
			,CASE WHEN (p.Birthdate <= @13YearsAgo) THEN 1  -- 13 years old or older
				WHEN p.[Birthdate] IS NOT NULL THEN 0
				ELSE NULL
				END AS [YearsOldOrOlder13]
			,CASE WHEN (p.[Birthdate] <= @65YearsAgo) THEN 1  -- 65 years old or older
				WHEN p.[Birthdate] IS NOT NULL THEN 0
				ELSE NULL
				END AS [YearsOldOrOlder65]
		FROM [#tblVisitList] AS v
			INNER JOIN [Person] AS p WITH(NOLOCK) ON v.[PatientUid] = p.[PersonUid]
				AND (p.[DeathDate] IS NULL OR p.[DeathDate] >= @RptTimespan_StartDate)
			LEFT JOIN @Portal AS portal on v.[PatientUid] = portal.[PatientUid]
			CROSS APPLY
			(
				SELECT (
					CASE WHEN EXISTS(
						SELECT TOP 1 *
						FROM [RelPatientStatus] AS rps WITH(NOLOCK) 
						WHERE rps.[PatientUid] = v.[PatientUid] 
							AND rps.[PatientStatusUid] = @PatientTypeTest
						) THEN 1
						ELSE 0
					END
					) AS [IsTestPatient]
			) AS [TestPatient]
		where [TestPatient].[IsTestPatient]= 0
		GROUP BY p.[PersonUid]
			,p.[LastName]
			,p.[FirstName]
			,p.[Birthdate]
			,[TestPatient].[IsTestPatient]
			,p.[LanguageUid]
			,p.[GenderUid]
			--,p.RaceUid,p.EthnicityUid


	IF (@Debug = 1)
	BEGIN
		SELECT '[2019PI_Medicaid_Master_PopulatePatientList] -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_Medicaid_Master_PopulateProviderList]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_Medicaid_Master_PopulateProviderList] AS' 
END
GO
ALTER PROCEDURE [dbo].[2019PI_Medicaid_Master_PopulateProviderList]
    @ProviderUid [varchar](max),
	@HasProviderUid [bit] out
AS
BEGIN
	SET NOCOUNT ON;

	IF @ProviderUid IS NOT NULL
	BEGIN
		SET @ProviderUid = RTRIM(LTRIM(@ProviderUid))
	END

	IF @ProviderUid IS NULL OR LEN(@ProviderUid) < 1
	BEGIN
		SET @HasProviderUid = 0
		INSERT [#tblProviderList]
		SELECT [PersonUid]
		FROM [ViewFindProvider] with(nolock)
	END
	ELSE
	BEGIN
		SET @HasProviderUid = 1
		INSERT [#tblProviderList]
		SELECT DISTINCT vfp.[PersonUid]
		FROM [dbo].[Split](@ProviderUid, ',') AS vp
			INNER JOIN [ViewFindProvider] AS vfp with(nolock) ON vp.[Element] = vfp.[PersonUid]
	END
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_Medicaid_Master_PopulateVisitList]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_Medicaid_Master_PopulateVisitList] AS' 
END
GO
ALTER PROC [dbo].[2019PI_Medicaid_Master_PopulateVisitList]
(
--Move Provider and Billing/Rendering logic to populatevisitlist
    @ProviderUid			[varchar](max),
    @ProviderBilling		[bit],
	@RptTimespan_StartDate	[date],
	@RptTimespan_EndDate	[date],
	@Debug					[bit] = 0,
	@ServiceSiteUID			[varchar](max) = null, 
	@FinancialCenterUID		[varchar](max) = null
)	
AS
BEGIN
	IF (@Debug = 1)
	BEGIN
		SELECT '[2019PI_Medicaid_Master_PopulateVisitList] -- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	--        
	-- History of Changes
	--                                       
	--   Name      Date            Description
	--   ==================================================================================================================
	-- 

	DECLARE @VisitTypeStrikeOut [uniqueidentifier] = 'FB954167-9D1C-43B7-9F5B-A76260654C96',
		@WithinDays [int] = 3

	CREATE TABLE [#ServiceSites]
	(
		[ServiceSiteUID] [uniqueidentifier] primary key
	) 
	CREATE TABLE [#FinancialCenters]
	(
		[FinancialCenterUID] [uniqueidentifier] primary key
	) 

	IF @ServiceSiteUID IS NOT NULL
	BEGIN
		SET @ServiceSiteUID = RTRIM(LTRIM(@ServiceSiteUID))
	END

	IF @ServiceSiteUID IS NULL OR LEN(@ServiceSiteUID) < 1 
	BEGIN
		INSERT INTO #ServiceSites
		SELECT [ServiceSiteUID]
		FROM [ListServiceSite] with(nolock)
	END
	ELSE
	BEGIN
		INSERT INTO #ServiceSites 
		SELECT DISTINCT lss.[ServiceSiteUid]
		FROM [dbo].[Split](@ServiceSiteUID, ',') AS vss
			INNER JOIN [ListServiceSite] AS lss with(nolock) ON vss.[Element] = lss.[ServiceSiteUid]
	END

	IF @FinancialCenterUID IS NOT NULL
	BEGIN
		SET @FinancialCenterUID = RTRIM(LTRIM(@FinancialCenterUID))
	END

	IF @FinancialCenterUID IS NULL OR LEN(@FinancialCenterUID) < 1
	BEGIN
		INSERT INTO #FinancialCenters
		SELECT [FinancialCenterUid]
		FROM [FinancialCenter] with(nolock)
	END
	ELSE
	BEGIN
		INSERT INTO #FinancialCenters
		SELECT DISTINCT lfc.[FinancialCenterUid]
		FROM [dbo].[Split](@FinancialCenterUID, ',') AS vfc
			INNER JOIN [FinancialCenter] AS lfc with(nolock) ON vfc.[Element] = lfc.[FinancialCenterUid]
	END

	BEGIN --EduForms
		CREATE TABLE #EduForms (VisitUid UNIQUEIDENTIFIER, VisitDate DATE, ObjectUid UNIQUEIDENTIFIER, ObjectName VARCHAR(50))
		EXEC FindEduFormsForVisit
			@ProviderUid = @ProviderUid
			,@ProviderBilling = @ProviderBilling
			,@StartDate = @RptTimespan_StartDate
			,@EndDate = @RptTimespan_EndDate
	END

	--VisitDate is a DATE field and does NOT get UTC adjustment
	INSERT INTO #tblVisitList (
		[VisitUid],
		[PatientUid],
		[VisitDate],
		[ProviderUid],
		[RenderingProviderUid],
		[SummaryProvidedToPatient],
		[HasPortalAccount],
		[PatientDeclinedClinicalSummary],
		[LastSavedByUid],
		[SavedByBillingProvider],
		[SavedByRenderingProvider],
		[TransitionOfCare],
		[MedicationChecked],
		[DrugAllergyChecked],
		[ProblemChecked],
		[IsEM],
		[IsVP],
		[HasEduForm],
		[PrintedDate]
		)
	SELECT v.[VisitUid]
		,v.[PatientUid]
		,v.[VisitDate]
		,v.[ProviderUid]
		,v.[RenderingProviderUid]
		,[VisitRDADisclosureDate].[DisclosureDate]
		,NULL AS [HasPortalAccount]
		,v.[PatientDeclinedClinicalSummary]
		,v.[LastSavedByUid]
		,v.[SavedByBillingProvider]
		,v.[SavedByRenderingProvider]
		,vc.[TransitionOfCare]
		,vc.[MedicationChecked] AS [MedicationChecked]
		,vc.DrugAllergyChecked
		,vc.ProblemDiagnosisChecked
		,MAX(CONVERT(SMALLINT,COALESCE(IsEM.[IsEM],0)))  AS [IsEm]
		,MAX(CONVERT(SMALLINT,COALESCE(IsVP.[IsPerformed],0))) AS [IsVP]
		,MAX(CASE WHEN vef.[VisitUid] IS NOT NULL THEN 1 ELSE 0 END) AS [HasEduForm]
		,MIN(vef.[VisitDate]) AS [PrintedDate]
	FROM Visit AS v with(nolock)
		INNER JOIN #ServiceSites AS Sites on Sites.[ServiceSiteUID] = v.[ServiceSiteUid]
		INNER JOIN #FinancialCenters AS Fin on fin.[FinancialCenterUID] = v.[FinancialCenterUid]
		LEFT JOIN [VisitComplexity] AS vc ON v.[VisitUid] = vc.[VisitUid]
		LEFT JOIN [VisitProcedure] AS IsEm on v.[VisitUid] = IsEm.[VisitUid] AND IsEm.[IsEM] <> 0
		LEFT JOIN [VisitProcedure] AS IsVP on v.[VisitUid] = IsVP.[VisitUid] AND IsVP.[IsPerformed] <> 0
		LEFT JOIN #EduForms vef ON v.[Visituid] = vef.[VisitUid]
		CROSS APPLY
		(
			SELECT MIN([DisclosureDate]) AS [DisclosureDate]
			FROM [RecordDisclosureAudit] WITH(NOLOCK) 
			WHERE [DisclosureDate] BETWEEN DATEADD(DAY, -1, v.[VisitDate]) AND DATEADD(DAY,@WithinDays,v.[VisitDate])
				AND ([PatientUid] = v.[PatientUid]	OR [VisitUid] = v.[VisitUid])
				AND [DisclosureType] in (1,    -- Complete Chart
										2,    -- Clinical Summary
										11)  -- ContinuityOfCareDocument
		) AS [VisitRDADisclosureDate]
	WHERE  v.[VisitDate] BETWEEN @RptTimespan_StartDate AND @RptTimespan_EndDate
			AND (v.[VisitTypeUid] is null or v.[VisitTypeUid] != @VisitTypeStrikeOut)
			AND (
				(v.[ProviderUid] IN (SELECT [ProviderUid] FROM [#tblProviderList]) AND @ProviderBilling = 1) 
				OR (v.[RenderingProviderUid] IN (SELECT [ProviderUid] FROM [#tblProviderList]) AND @ProviderBilling = 0) 
				)
	GROUP BY v.[VisitUid]
		,v.[PatientUid]
		,v.[VisitDate]
		,v.[ProviderUid]
		,v.[RenderingProviderUid]
		,[VisitRDADisclosureDate].[DisclosureDate]
		--,[HasPortalAccount]
		,v.[PatientDeclinedClinicalSummary]
		,v.[LastSavedByUid]
		,v.[SavedByBillingProvider]
		,v.[SavedByRenderingProvider]
		,vc.[TransitionOfCare]
		,vc.[MedicationChecked]
		,vc.DrugAllergyChecked
		,vc.ProblemDiagnosisChecked

	IF (@Debug = 1)
	BEGIN
		SELECT '[2019PI_Medicaid_Master_PopulateVisitList] -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_Medicaid_Master_DesktopControl]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_Medicaid_Master_DesktopControl] AS' 
END
GO
ALTER PROC [dbo].[2019PI_Medicaid_Master_DesktopControl]
(
	@ProviderUid			[varchar](max) = NULL,  
	@RptTimespan_StartDate	[date],
	@RptTimespan_EndDate	[date],
	@ProviderBilling		[bit] = 1,
	@ProviderRendering		[bit] = 0,
	@Debug					[int] = 0,
	@includetestpat			[bit] = 0,
	@ServiceSiteUID			[varchar](max) = null, 
	@FinancialCenterUID		[varchar](max) = null
)
AS
BEGIN
	--
	-- Calling syntax :    
	--
	--

	IF (@RptTimespan_StartDate IS NULL)
	BEGIN
		SET @RptTimespan_StartDate = '01-01-1900'
	END 
	IF (@RptTimespan_EndDate IS NULL)
	BEGIN
		SET @RptTimespan_EndDate = GETDATE()
	END 

	IF @ProviderBilling = 0 AND @ProviderRendering = 0
		SET @ProviderBilling = 1

	CREATE TABLE [#tblProviderList]
	(
		[ProviderUid] [uniqueidentifier] NOT NULL primary key clustered
	)
	 	 
	DECLARE @HasProviderUid [bit] = 0
	EXEC [2019PI_Medicaid_Master_PopulateProviderList] @ProviderUid, @HasProviderUid out

	-- Measure stored procedure flag indicating Meaningful Use data will be used for a report
	DECLARE @ReportMode [bit] = 0

	CREATE TABLE [#tblVisitList]
	(
		[VisitUid]							[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[VisitDate]							[date]         NOT NULL,
		[PatientUid]						[uniqueidentifier] NOT NULL,
		[TestPat]					   		[bit],
		[IsEM]								[bit],
		[IsVP]								[bit],
		[ProviderUid]						[varchar](max),
		[RenderingProviderUid]				[varchar](max),
		[LastSavedByUid]					[uniqueidentifier],
		[SavedByBillingProvider]			[bit],
		[SavedByRenderingProvider]			[bit],
		[TransitionOfCare]					[bit],
		[MedicationChecked]					[bit],
		[DrugAllergyChecked]				[bit],
		[ProblemChecked]					[bit],
		[SummaryProvidedToPatient]			[date],
		[PatientDeclinedClinicalSummary]	[bit],
		[HasEduForm]						[bit],
		[HasPortalAccount]					[bit],
		[PrintedDate]						[date]
	)
	--
	-- PopulateVisitList
	EXEC [2019PI_Medicaid_Master_PopulateVisitList] @ProviderUid
		, @ProviderBilling
		, @RptTimespan_StartDate
		, @RptTimespan_EndDate
		, @Debug
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblVisitList]
		ORDER BY [VisitDate] DESC 
	END

	CREATE TABLE [#tblPatientList] 
	(
		[PersonUid]					[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[PatientLnFn]				[varchar](250),
		[Birthdate]					[date],
		[TestPat]					[bit],
		[IsEM]						[bit],
		[IsVP]						[bit],
		[FullDemographics]			[bit],
		[HasEduForm]				[bit],
		[EduFormPrinted]			[bit],
		[HasPortalAccount]			[bit],
		[PortalPerson]				[uniqueidentifier] NULL,
		[PortalValid]				[date] NULL,
		[PortalExpire]				[date] NULL,
		[SummaryProvidedToPatient]	[bit],
		[TransitionOfCare]			[bit],
		[MedicationChecked]			[bit],
		[SavedByBillingProvider]	[bit],
		[SavedByRenderingProvider]	[bit],
		[YearsOldOrOlder2]			[bit] NULL,
		[YearsOldOrOlder3]			[bit] NULL,
		[YearsOldOrYounger5]		[bit] NULL, 
		[YearsOldOrOlder13]			[bit] NULL,
		[YearsOldOrOlder65]			[bit] NULL
	)
	--
	-- Populate Patient List
	EXEC [2019PI_Medicaid_Master_PopulatePatientList] @ProviderUid, 
			@RptTimespan_StartDate,
			@RptTimespan_EndDate,
			@ProviderBilling,
			@ProviderRendering,
			@Debug

	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblPatientList]
		ORDER BY [PatientLnFn]
	END

	--back fill #tblVisitList with patient specific information
	--delete test patient records from #tblVisitList AND #tblPatientList IF @includetestpat = 0
	EXEC [2019PI_Medicaid_Master_SynchronizeVisitAndPatient] @Debug = @Debug,
		@IncludeTestPatients = @includetestpat

	-- Build list of Medications that are within reporting range
	CREATE TABLE #tblMedicationList
	(
		[MedicationSIGUid]					[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[CreatedDate]						[datetime] NOT NULL,
		[RelVisitMedicationUid]				[uniqueidentifier],
		[PersonUid]							[uniqueidentifier],
		[TestPat]							[bit],
		[LicensedHealthcareProfessional]	[bit] NOT NULL,
		[Dispensable]						[bit] NULL,
		[IsSampleGiven]						[bit] NOT NULL,
		[IsAdministered]					[bit] NOT NULL,
		[reffederaldeaclasscode]			[bit] NULL,
		[SIGDetailCount]					[int] NULL,
		[eRxStatusUid]						[uniqueidentifier]
	)
	--
	-- PopulateMedicationList
	EXEC [2019PI_Medicaid_Master_PopulateMedicationList]
		@ProviderUid
		, @ProviderBilling
		, @RptTimespan_StartDate
		, @RptTimespan_EndDate
		, @includetestpat
		, @Debug
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblMedicationList]
		ORDER BY [CreatedDate] DESC 
	END

	-- Build list of Orders that are within reporting range
	CREATE TABLE [#tblOrderList]
	(
		[ObservationOrderUid]				[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[PatientUid]						[uniqueidentifier] NOT NULL,
		[TestPat]					   		[bit],
		[VPUid]								[uniqueidentifier] NULL,
		[CreatedBy]							[uniqueidentifier] NULL,
		[OrderDate]							[datetime]         NOT NULL,
		[ProcedureCodeTypeUid]				[uniqueidentifier] NULL,
		[ProcedureCodeTypeName]				[varchar](500)     NULL,
		[AttachmentTypeUid]					[uniqueidentifier] NULL,
		[AttachmentTypeName]				[varchar](500)	NULL,
		[LicensedHealthcareProfessional]	[bit]			NOT NULL,
		[ImageResultsDirectlyAccessible]	[bit]			NULL,
		[ResultStatusID]					[int]			NULL
	)
	--
	-- PopulateOrderList
	EXEC [2019PI_Medicaid_Master_PopulateOrderList] @ProviderUid
		, @ProviderBilling
		, @RptTimespan_StartDate
		, @RptTimespan_EndDate
		, @includetestpat
		, @Debug
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblOrderList]
		ORDER BY [OrderDate] DESC 
	END

	-- Create work table that will hold the Meaningful Use results
	CREATE TABLE [#tblMeaningfulUseDetail] 
	(
		[RowId]               [int] IDENTITY(1,1) PRIMARY KEY,     -- Primary Key
		[ItemDefinitionUid]   [uniqueidentifier],                  -- MeaningfulUseItemDefinition.ItemDefinitionUid   
		[PersonUid]           [uniqueidentifier] NULL,             -- Unique list of Visit.PatientUid
		[NumeratorValue]      [int] NULL,                          -- See MeaningfulUseItemDefinition.NumeratorDesc
		[DenominatorValue]    [int] NULL,                          -- See MeaningfulUseItemDefinition.DenominatorDesc
		[YesNo]               [int] NULL                           -- See MeaningfulUseItemdefinition.YesNo.  Null-NA, 0-No/False, 1-Yes/True.
		unique clustered ([RowId])
	)  

	CREATE NONCLUSTERED INDEX [MUDetail_ItemDef_PersonUid] ON [#tblMeaningfulUseDetail]
	(
		[ItemDefinitionUid] ASC,
		[PersonUid] ASC
	)
	WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

	-- Create temp table that can be used by measure procs
	CREATE TABLE [#MetricDataTemp]
	(
		[PersonUid]							[uniqueidentifier] NOT NULL,
		[HeightRecorded]					[int] NULL,
		[WeightRecorded]					[int] NULL,
		[BloodPressureRecorded]				[int] NULL,
		[LabResultTotalCount]				[int] NULL, 
		[LabResultTemplatedCount]			[int] NULL,
		[TaskDocGenCount]					[int] NULL, 
		[TaskDocGenCompleteCount]			[int] NULL,   
		[VisitCount]						[int] NULL, 
		[ClinicalSummaryProvidedCount]		[int] NULL,  
		[PreventativeFollowupDueCount]		[int] NULL, 
		[PreventativeFollowupSentCount]		[int] NULL,   
		[SeenByAnotherProviderCount]		[int] NULL, 
		[MedicalCheckedCount]				[int] NULL,  
		[ReferralCount]						[int] NULL, 
		[ReferralClinicalSummaryProvided]	[int] NULL
	) 	
	
	-- Proc based on MUII_Master_DesktopControl
	--  
	-- Calculate Measures
	EXEC [2019PI_Medicaid_CoreMeasure_02_SubMeasure_01] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_Medicaid_CoreMeasure_02_SubMeasure_02] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_Medicaid_CoreMeasure_04_SubMeasure_01] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_Medicaid_CoreMeasure_04_SubMeasure_02] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_Medicaid_CoreMeasure_04_SubMeasure_03] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_Medicaid_CoreMeasure_05_SubMeasure_01] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_Medicaid_CoreMeasure_05_SubMeasure_02] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE 

	EXEC [2019PI_Medicaid_CoreMeasure_06_SubMeasure_01] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_Medicaid_CoreMeasure_06_SubMeasure_02] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_Medicaid_CoreMeasure_06_SubMeasure_03] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_Medicaid_CoreMeasure_07_SubMeasure_01] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_Medicaid_CoreMeasure_07_SubMeasure_02] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_Medicaid_CoreMeasure_07_SubMeasure_03] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	-- Drop temp tables that are used by measure procs
	BEGIN TRY
		DROP TABLE [#tblVisitList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#tblPatientList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#tblProviderList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#MetricDataTemp]
	END TRY 
	BEGIN CATCH
	END CATCH

	-- Define table that will be returned to caller
	DECLARE @tblMeaingfulUseSummaryCoreAndMenuSet TABLE
	(
		[RowId]             [int] IDENTITY(1,1) PRIMARY KEY,
		[ItemDefinitionUid] [uniqueidentifier],
		[CategoryNumber]    [int] NULL,
		[CategoryName]      [varchar](100) NULL,
		[MeasureNumber]     [int] NULL, 
		[SubMeasureNumber]  [int] NULL,
		[MeasureDesc]       [varchar](500) NULL,
		[DenominatorDesc]   [varchar](250) NULL,
		[DenominatorValue]  [int] NULL,
		[NumeratorDesc]     [varchar](250) NULL,
		[NumeratorValue]    [int] NULL,
		[YesNo]     [varchar](50)  NULL,
		[CurrentValue]	  [varchar](25)  NULL,
		[GoalDesc]          [varchar](250) NULL,
		[GoalValue]         [varchar](10)  NULL,
		[MetGoal]           [bit] NULL, 
		[ProviderUid]       [varchar](max) NULL,
		[ProviderLnFn]      [varchar](150) NULL,       
		unique clustered  ([RowId])
	) 

	-- Determine if there are any MU detail rows to base metrics against
	DECLARE @NumDetailRows [int]

	-- Walk through list of defined Meaningful Use metrics and popluate @tblMeaingfulUseSummaryCoreAndMenuSet 
	DECLARE @ItemDefinitionUid [uniqueidentifier]
		, @CategoryUid [uniqueidentifier]
		, @CategoryNumber [int]
		, @CategoryName [varchar](100)
		, @MeasureNumber [int]
		, @SubMeasureNumber [int]
		, @MeasureDesc [varchar](500)
		, @ExclusionDesc [varchar](250)
		, @DenominatorDesc [varchar](250)
		, @NumeratorDesc [varchar](250)
		, @YesNo [varchar](50)
		, @GoalDesc [varchar](250)
		, @GoalValue [decimal](5, 2)
		, @DenominatorSumValue [int]
		, @NumeratorSumValue [int]
		, @CurValue [varchar](25)
		, @MetGoal [bit]    
        
    --
    -- Populate table that will be returned to caller
	DECLARE cursor_MU_Definitions CURSOR FAST_FORWARD FOR 
		SELECT muid.[ItemDefinitionUid]
			, muid.[CategoryUid]
			, mucd.[CategoryNumber]
			, mucd.[CategoryName]
			, muid.[MeasureNumber]
			, muid.[SubMeasureNumber]
			, muid.[MeasureDesc]
			, muid.[ExclusionDesc]
			, muid.[DenominatorDesc]
			, muid.[NumeratorDesc]
			, muid.[YesNo]
			, muid.[GoalDesc]
			, muid.[GoalValue]
		FROM [MeaningfulUseItemDefinition] AS muid with(nolock)
			INNER JOIN [MeaningfulUseCategoryDefinition] AS mucd with(nolock) ON muid.[CategoryUid] = mucd.[CategoryUid]
		WHERE muid.[StageUid] = 'CE4AB3AA-9FA7-4B81-B5F4-34AE309E6244'   --2019 PI Medicaid
		ORDER BY mucd.[CategoryName]
			, mucd.[CategoryNumber]
			, muid.[MeasureNumber]
    --
    OPEN cursor_MU_Definitions
    --
	FETCH NEXT FROM cursor_MU_Definitions 
		INTO @ItemDefinitionUid
			, @CategoryUid
			, @CategoryNumber
			, @CategoryName
			, @MeasureNumber
			, @SubMeasureNumber
			, @MeasureDesc
			, @ExclusionDesc
			, @DenominatorDesc
			, @NumeratorDesc
			, @YesNo
			, @GoalDesc
			, @GoalValue 
    --
   -- Make sure we have a valid cursor row
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @DenominatorSumValue = 0
		SET @NumeratorSumValue = 0
		SET @CurValue = '' 
		SET @MetGoal = 0 
		SET @NumDetailRows = 0
		
		-- Check if current MU metric has a numerator and denominator
		IF @YesNo IS NULL
		BEGIN
			-- Make sure we have some data for current metric
			SET @NumDetailRows = (SELECT COUNT(*)
								  FROM [#tblMeaningfulUseDetail]
								  WHERE [ItemDefinitionUid] = @ItemDefinitionUid
								 )
			IF (@NumDetailRows > 0)
			BEGIN
				-- Current MU metric has a numerator and demoninator
				SELECT  @DenominatorSumValue = SUM(mud.[DenominatorValue])
					, @NumeratorSumValue   = SUM(mud.[NumeratorValue]) 
				FROM     [#tblMeaningfulUseDetail] AS mud
				WHERE    mud.[ItemDefinitionUid] = @ItemDefinitionUid
				GROUP BY mud.[ItemDefinitionUid] 
			END    
           
			IF @DenominatorSumValue <= 0
			BEGIN
				SET @CurValue = 'N/A' 
			END 
			ELSE IF @NumeratorSumValue <= 0
			BEGIN 
				SET @CurValue = '0.00%' 
			END 
			ELSE 
			BEGIN 
				-- Calculate current MU metric value
				SET @CurValue = CONVERT(VARCHAR(10), CONVERT(DECIMAL(8,2), (CONVERT(DECIMAL(8,2), @NumeratorSumValue) / CONVERT(DECIMAL(8,2), @DenominatorSumValue)) * 100)) + '%'
	                  
				-- Determine if goal is satisfied
				IF CONVERT(DECIMAL(8,2), (CONVERT(DECIMAL(8,2), @NumeratorSumValue) / CONVERT(DECIMAL(8,2), @DenominatorSumValue)) * 100) > @GoalValue
				BEGIN
					SET @MetGoal = 1
				END 
			END 
             
			-- Insert MU summary row
			INSERT INTO @tblMeaingfulUseSummaryCoreAndMenuSet ([ItemDefinitionUid]
				, [CategoryNumber]
				, [CategoryName]
				, [MeasureNumber]
				, [SubMeasureNumber]
				, [MeasureDesc]
				, [DenominatorDesc]
				, [DenominatorValue]
				, [NumeratorDesc]
				, [NumeratorValue]
				, [YesNo]
				, [CurrentValue]
				, [GoalDesc]
				, [GoalValue]
				, [MetGoal]
				, [ProviderUid]
				, [ProviderLnFn]
			)   
			VALUES (@ItemDefinitionUid
				, @CategoryNumber
				, @CategoryName
				, @MeasureNumber
				, @SubMeasureNumber
				, @MeasureDesc
				, @DenominatorDesc
				, @DenominatorSumValue
				, @NumeratorDesc
				, @NumeratorSumValue
				, @YesNo
				, @CurValue
				, @GoalDesc
				, CONVERT([varchar](10), @GoalValue)
				, @MetGoal
				, null
				, null
			)  
		END 
		ELSE 
		BEGIN
			-- Current MU metric is YES/NO.  
			INSERT INTO @tblMeaingfulUseSummaryCoreAndMenuSet([ItemDefinitionUid]
				, [CategoryNumber]
				, [CategoryName]
				, [MeasureNumber]
				, [SubMeasureNumber]
				, [MeasureDesc]
				, [DenominatorDesc]
				, [DenominatorValue]
				, [NumeratorDesc]
				, [NumeratorValue]
				, [YesNo]
				, [CurrentValue]
				, [GoalDesc]
				, [GoalValue]
				, [MetGoal]
				, [ProviderUid]
				, [ProviderLnFn]
			)  
			VALUES (@ItemDefinitionUid
				, @CategoryNumber
				, @CategoryName
				, @MeasureNumber
				, @SubMeasureNumber
				, @MeasureDesc
				, @DenominatorDesc
				, null
				, @NumeratorDesc
				, null
				, @YesNo
				, null
				, @GoalDesc
				, null
				, null
				, null
				, null
			)  
		END
		-- 
		-- Get next cursor_MU_Definitions row
		FETCH NEXT FROM cursor_MU_Definitions INTO @ItemDefinitionUid
			, @CategoryUid
			, @CategoryNumber
			, @CategoryName
			, @MeasureNumber
			, @SubMeasureNumber
			, @MeasureDesc
			, @ExclusionDesc
			, @DenominatorDesc
			, @NumeratorDesc
			, @YesNo
			, @GoalDesc
			, @GoalValue 
    END
    --
    -- Close and Deallocate cursor
    CLOSE cursor_MU_Definitions
    DEALLOCATE cursor_MU_Definitions
	
	-- Return Meaningful Use results to caller
	SELECT 'MeaingfulUseSummaryCoreAndMenuSet'
	SELECT [RowId]
		, [ItemDefinitionUid]
		, [CategoryNumber]
		, [CategoryName]
		, [MeasureNumber]
		, [SubMeasureNumber]
		, [MeasureDesc]
		, [DenominatorDesc]
		, [DenominatorValue]
		, [NumeratorDesc]
		, [NumeratorValue]
		, [YesNo]
		, [CurrentValue]
		, [GoalDesc]
		, [GoalValue]
		, [MetGoal]
		, [ProviderUid]
		, [ProviderLnFn]
	FROM @tblMeaingfulUseSummaryCoreAndMenuSet    
	ORDER BY [CategoryNumber] ASC
		, [MeasureNumber] ASC
		, [SubMeasureNumber] ASC 
	
	IF (@Debug <> 0)
	BEGIN
		SELECT 'GOOD BYE'
	END 
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_Medicaid_Master_Report]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_Medicaid_Master_Report] AS' 
END
GO
ALTER PROC [dbo].[2019PI_Medicaid_Master_Report]
(
	@ReportInstanceUid [uniqueidentifier],
	@ProviderUid [varchar](max) = NULL, 
	@RptTimespan_StartDate [date],
	@RptTimespan_EndDate [date],
	@ProviderOption [varchar](100) = 'Billing Provider', --	Billing Provider and Rendering Provider 
	@Debug [int] = 0,
	@includetestpat	[bit] = 0,
	@ServiceSiteUID	[varchar](max) = null, 
	@FinancialCenterUID	[varchar](max) = null
)
AS
BEGIN
	SET NOCOUNT ON;
	--
	-- 

	IF (@RptTimespan_StartDate IS NULL)
	BEGIN
		SET @RptTimespan_StartDate = '01-01-1900'
	END 
	IF (@RptTimespan_EndDate IS NULL)
	BEGIN
		SET @RptTimespan_EndDate = GETDATE()
	END

	CREATE TABLE [#tblProviderList]
	(
		[ProviderUid] [uniqueidentifier] NOT NULL primary key clustered
	)
	 
	DECLARE @HasProviderUid [bit] = 0
	EXEC [2019PI_Medicaid_Master_PopulateProviderList] @ProviderUid, @HasProviderUid out

	DECLARE @ClaimFormatValueTypeProviderNPIUid [uniqueidentifier] = 'CE282F4E-A866-49BA-9636-C4BA0439E907',
		@ReportMode [bit] = 1,
		@ProviderBilling [bit] = 0,
		@ProviderRendering [bit] = 0,
		@ProviderNPI [varchar](100) = null

	-- Find the first provider has provider NPI

	SELECT TOP 1 @ProviderNPI = [Value]
	FROM [ClaimFormatValue] with(nolock)
	WHERE [ClaimFormatValueTypeUid] = @ClaimFormatValueTypeProviderNPIUid
		AND [ProviderUid] IN (SELECT [ProviderUid] FROM [#tblProviderList])

	-- Set local Billing and Rendering Provider Flags
	IF (@ProviderOption = 'Billing Provider')
	BEGIN
		SET @ProviderBilling = 1
		SET @ProviderRendering = 0
	END
	ELSE
	BEGIN
		SET @ProviderBilling = 0
		SET @ProviderRendering = 1	
	END

	-- Measure stored procedure flag indicating Meaningful Use data will be used for a report
CREATE TABLE [#tblVisitList]
	(
		[VisitUid]							[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[VisitDate]							[date]         NOT NULL,
		[PatientUid]						[uniqueidentifier] NOT NULL,
		[TestPat]					   		[bit],
		[IsEM]								[bit],
		[IsVP]								[bit],
		[ProviderUid]						[varchar](max),
		[RenderingProviderUid]				[varchar](max),
		[LastSavedByUid]					[uniqueidentifier],
		[SavedByBillingProvider]			[bit],
		[SavedByRenderingProvider]			[bit],
		[TransitionOfCare]					[bit],
		[MedicationChecked]					[bit],
		[DrugAllergyChecked]				[bit],
		[ProblemChecked]					[bit],
		[SummaryProvidedToPatient]			[date],
		[PatientDeclinedClinicalSummary]	[bit],
		[HasEduForm]						[bit],
		[HasPortalAccount]					[bit],
		[PrintedDate]						[date]
	)
	--
	-- PopulateVisitList
	EXEC [2019PI_Medicaid_Master_PopulateVisitList] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@Debug,
		@ServiceSiteUID,
		@FinancialCenterUID

	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblVisitList]
		ORDER BY [VisitDate] DESC 
	END

	CREATE TABLE [#tblPatientList] 
	(
		[PersonUid]					[uniqueidentifier] NOT NULL primary key clustered,
		[PatientLnFn]				[varchar](250),
		[Birthdate]					[date],
		[TestPat]					[bit],
		[IsEM]						[bit],
		[IsVP]						[bit],
		[FullDemographics]			[bit],
		[HasEduForm]				[bit],
		[EduFormPrinted]			[bit],
		[HasPortalAccount]			[bit],
		[PortalPerson]				[uniqueidentifier] NULL,
		[PortalValid]				[date] NULL,
		[PortalExpire]				[date] NULL,
		[SummaryProvidedToPatient]	[bit],
		[TransitionOfCare]			[bit],
		[MedicationChecked]			[bit],
		[SavedByBillingProvider]	[bit],
		[SavedByRenderingProvider]	[bit],
		[YearsOldOrOlder2]			[bit] NULL,
		[YearsOldOrOlder3]			[bit] NULL,
		[YearsOldOrYounger5]		[bit] NULL, 
		[YearsOldOrOlder13]			[bit] NULL,
		[YearsOldOrOlder65]			[bit] NULL
	)
	--
	-- Populate Patient List
	EXEC [2019PI_Medicaid_Master_PopulatePatientList] 
			@ProviderUid, 
			@RptTimespan_StartDate,
			@RptTimespan_EndDate,
			@ProviderBilling,
			@ProviderRendering,
			@Debug

	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblPatientList]
		ORDER BY [PatientLnFn]
	END

	--back fill #tblVisitList with patient specific information
	--delete test patient records from #tblVisitList AND #tblPatientList IF @includetestpat = 0
	EXEC [2019PI_Medicaid_Master_SynchronizeVisitAndPatient] @Debug = @Debug,
		@IncludeTestPatients = @includetestpat

	-- Build list of Medications that are within reporting range
	CREATE TABLE [#tblMedicationList]
	(
		[MedicationSIGUid]					[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[CreatedDate]						[datetime] NOT NULL,
		[RelVisitMedicationUid]				[uniqueidentifier],
		[PersonUid]							[uniqueidentifier],
		[TestPat]							[bit],
		[LicensedHealthcareProfessional]	[bit] NOT NULL,
		[Dispensable]						[bit] NULL,
		[IsSampleGiven]						[bit] NOT NULL,
		[IsAdministered]					[bit] NOT NULL,
		[reffederaldeaclasscode]			[bit] NULL,
		[SIGDetailCount]					[int] NULL,
		[eRxStatusUid]						[uniqueidentifier]
	)
	--
	-- PopulateMedicationList
	EXEC [2019PI_Medicaid_Master_PopulateMedicationList] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@includetestpat,
		@Debug
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblMedicationList]
		ORDER BY [CreatedDate] DESC 
	END

	-- Build list of Orders that are within reporting range
	CREATE TABLE [#tblOrderList]
	(
		[ObservationOrderUid]				[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[PatientUid]						[uniqueidentifier] NOT NULL,
		[TestPat]					 		[bit],
		[VPUid]								[uniqueidentifier] NULL,
		[CreatedBy]							[uniqueidentifier] NULL,
		[OrderDate]							[datetime] NOT NULL,
		[ProcedureCodeTypeUid]				[uniqueidentifier] NULL,
		[ProcedureCodeTypeName]				[varchar](500) NULL,
		[AttachmentTypeUid]					[uniqueidentifier] NULL,
		[AttachmentTypeName]				[varchar](500) NULL,
		[LicensedHealthcareProfessional]	[bit] NOT NULL,
		[ImageResultsDirectlyAccessible]	[bit] NULL,
		[ResultStatusID]					[int] NULL
	)
	--
	-- PopulateOrderList
	EXEC [2019PI_Medicaid_Master_PopulateOrderList] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@includetestpat,
		@Debug
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblOrderList]
		ORDER BY [OrderDate] DESC 
	END

	-- Create work table that will hold the Meaningful Use results
	CREATE TABLE [#tblMeaningfulUseDetail] 
	(
		[RowId]				[int] IDENTITY(1,1) PRIMARY KEY, -- Primary Key
		[ItemDefinitionUid]	[uniqueidentifier], -- MeaningfulUseItemDefinition.ItemDefinitionUid
		[CategoryName]		[varchar](500) NULL, -- MeaningfulUseCategoryDefinition.CategoryName
		[CategoryNumber]	[int] NULL, -- MeaningfulUseCategoryDefinition.CategoryNumber
		[MeasureNumber]		[int] NULL, -- MeaningfulUseItemDefinition.MeasureNumber 
		[SubMeasureNumber]	[int] NULL, -- MeaningfulUseItemDefinition.SubMeasureNumber
		[PersonUid]			[uniqueidentifier] NULL, -- Unique list of Visit.PatientUid
		[PersonLnFn]		[varchar](150) NULL, -- Patient name
		[ProviderUid]		[varchar](MAX) NULL,
		[ProviderLnFn]		[varchar](150) NULL, 
		[NumeratorValue]	[int] NULL, -- See MeaningfulUseItemDefinition.NumeratorDesc
		[DenominatorValue]	[int] NULL, -- See MeaningfulUseItemDefinition.DenominatorDesc
		[YesNo]				[int] NULL -- See MeaningfulUseItemdefinition.YesNo. Null-NA, 0-No/False, 1-Yes/True.
		unique clustered (RowId)
	) 
 
	CREATE NONCLUSTERED INDEX [MUDetail_ItemDef_PersonUid] ON #tblMeaningfulUseDetail
	(
		ItemDefinitionUid ASC,
		PersonUid ASC
	)
	WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]


	-- Params used in determining if any detail rows were found for given metric
	CREATE TABLE [#tblMetricUidsWithoutDetailRows] 
	(
		[ItemDefinitionUid] [uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED
	)

	-- Create temp table that can be used by measure procs
	CREATE TABLE [#MetricDataTemp]
	(
		[PersonUid] [uniqueidentifier] NOT NULL,
		[HeightRecorded] [int] NULL,
		[WeightRecorded] [int] NULL,
		[BloodPressureRecorded] [int] NULL,
		[LabResultTotalCount] [int] NULL, 
		[LabResultTemplatedCount] [int] NULL,
		[TaskDocGenCount] [int] NULL, 
		[TaskDocGenCompleteCount] [int] NULL, 
		[VisitCount] [int] NULL, 
		[ClinicalSummaryProvidedCount] [int] NULL, 
		[PreventativeFollowupDueCount] [int] NULL, 
		[PreventativeFollowupSentCount] [int] NULL, 
		[SeenByAnotherProviderCount] [int] NULL, 
		[MedicalCheckedCount] [int] NULL, 
		[ReferralCount] [int] NULL, 
		[ReferralClinicalSummaryProvided] [int] NULL
	) 	

	-- Proc based on MUII_Master_DesktopControl
	--  
	-- Calculate Measures
	-- ACI_TRANS_PPHI_1 == Objective 1 == MUII Core Measure 9
	-- Must attest yes

	EXEC [2019PI_Medicaid_CoreMeasure_02_SubMeasure_01] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_Medicaid_CoreMeasure_02_SubMeasure_02] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_Medicaid_CoreMeasure_04_SubMeasure_01] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_Medicaid_CoreMeasure_04_SubMeasure_02] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_Medicaid_CoreMeasure_04_SubMeasure_03] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_Medicaid_CoreMeasure_05_SubMeasure_01] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_Medicaid_CoreMeasure_05_SubMeasure_02] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE 

	EXEC [2019PI_Medicaid_CoreMeasure_06_SubMeasure_01] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_Medicaid_CoreMeasure_06_SubMeasure_02] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_Medicaid_CoreMeasure_06_SubMeasure_03] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_Medicaid_CoreMeasure_07_SubMeasure_01] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_Medicaid_CoreMeasure_07_SubMeasure_02] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2019PI_Medicaid_CoreMeasure_07_SubMeasure_03] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	-- Drop temp tables that are used by measure procs
	BEGIN TRY
		DROP TABLE [#tblVisitList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#tblPatientList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#tblProviderList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#MetricDataTemp]
	END TRY 
	BEGIN CATCH
	END CATCH

	-- For measures that do not have any detail rows, we need to insert a row, so it will be included in the RDL report.
	DECLARE @NumDetailRows [int]
	SET @NumDetailRows = (SELECT COUNT(*) FROM [#tblMetricUidsWithoutDetailRows])
	IF (@NumDetailRows > 0)
	BEGIN
		INSERT INTO [#tblMeaningfulUseDetail] ([ItemDefinitionUid],
			[CategoryNumber],
			[CategoryName],
			[MeasureNumber],
			[SubMeasureNumber],
			[PersonUid],
			[PersonLnFn],
			[ProviderUid],
			[ProviderLnFn],
			[NumeratorValue],
			[DenominatorValue],
			[YesNo]
		)
			SELECT NoData.[ItemDefinitionUid] AS [ItemDefinitionUid]
			,(
				select mucd.[CategoryNumber] 
				from [MeaningfulUseItemDefinition] AS muid with(nolock)
					inner join [MeaningfulUseCategoryDefinition] AS mucd with(nolock) on muid.[CategoryUid] = mucd.[CategoryUid]
				where muid.[ItemDefinitionUid] = NoData.[ItemDefinitionUid]
			) AS [CategoryNumber]

			,(
				select mucd.CategoryName
				from [MeaningfulUseItemDefinition] AS muid with(nolock)
					inner join [MeaningfulUseCategoryDefinition] AS mucd with(nolock) on muid.[CategoryUid] = mucd.[CategoryUid]
				where muid.[ItemDefinitionUid] = NoData.[ItemDefinitionUid]
			) AS [CategoryName]

			,(
				select muid.[MeasureNumber]
				from [MeaningfulUseItemDefinition] AS muid with(nolock)
					inner join [MeaningfulUseCategoryDefinition] AS mucd with(nolock) on muid.[CategoryUid] = mucd.[CategoryUid]
				where muid.[ItemDefinitionUid] = NoData.[ItemDefinitionUid]
			) AS [MeasureNumber] 

			,(
				select muid.[SubMeasureNumber] 
				from [MeaningfulUseItemDefinition] AS muid with(nolock)
					inner join [MeaningfulUseCategoryDefinition] AS mucd with(nolock) on muid.[CategoryUid] = mucd.[CategoryUid]
				where muid.[ItemDefinitionUid] = NoData.[ItemDefinitionUid]
			) AS [SubMeasureNumber] 

			,NULL AS [PersonUid] 
			,'N / A' AS [PersonLnFn]
			,NULL AS [ProviderUid] 
			,'' AS [ProviderLnFn]
			,0 AS [NumeratorValue]
			,0 AS [DenominatorValue]
			,0 AS [YesNo]
		FROM [#tblMetricUidsWithoutDetailRows] AS [NoData] 
	END

	--
	-- For measures that are Yes/No (Must attest Yes), insert a detail row that will be included in the RDL report
	--

	-- ACI_TRANS_PPHI_1 == Objective 1 == MUII Core Measure 9
	DECLARE @ItemDefinitionUid [uniqueidentifier] = '9745E6BF-99FF-490B-992A-E4D315E2B13A' 
	EXEC [MUI_Master_Report_InsertAttestMeasureDetail] @ItemDefinitionUid, @ReportMode,	@Debug

	-- Pick 2 registries
	SET @ItemDefinitionUid = '9DB682EA-0CFD-4975-9D2F-06132E096F78' 
	EXEC [MUI_Master_Report_InsertAttestMeasureDetail] @ItemDefinitionUid, @ReportMode, @Debug

	-- Define table that will be returned to caller
	DECLARE @tblMeaingfulUseSummaryCoreAndMenuSet TABLE
	(
		[RowId]             [int] IDENTITY(1,1) PRIMARY KEY,
		[ItemDefinitionUid] [uniqueidentifier],
		[CategoryNumber]    [int] NULL,
		[CategoryName]      [varchar](100) NULL,
		[MeasureNumber]     [int] NULL, 
		[SubMeasureNumber]  [int] NULL,
		[MeasureDesc]       [varchar](500) NULL,
		[DenominatorDesc]   [varchar](250) NULL,
		[DenominatorValue]  [int] NULL,
		[NumeratorDesc]     [varchar](250) NULL,
		[NumeratorValue]    [int] NULL,
		[YesNo]     [varchar](50)  NULL,
		[CurrentValue]	  [varchar](25)  NULL,
		[GoalDesc]          [varchar](250) NULL,
		[GoalValue]         [varchar](10)  NULL,
		[MetGoal]           [bit] NULL, 
		[ProviderUid]       [varchar](max) NULL,
		[ProviderLnFn]      [varchar](150) NULL,       
		unique clustered  ([RowId])
	) 

	-- Determine if there are any MU detail rows to base metrics against
	-- Walk through list of defined Meaningful Use metrics and popluate @tblMeaingfulUseSummaryCoreAndMenuSet 
	DECLARE @CategoryUid [uniqueidentifier]
		, @CategoryNumber [int]
		, @CategoryName [varchar](100)
		, @MeasureNumber [int]
		, @SubMeasureNumber [int]
		, @MeasureDesc [varchar](500)
		, @ExclusionDesc [varchar](250)
		, @DenominatorDesc [varchar](250)
		, @NumeratorDesc [varchar](250)
		, @YesNo [varchar](50)
		, @GoalDesc [varchar](250)
		, @GoalValue [decimal](5, 2)
		, @DenominatorSumValue [int]
		, @NumeratorSumValue [int]
		, @CurValue [varchar](25)
		, @MetGoal [bit]    
        
    --
    -- Populate table that will be returned to caller
	DECLARE cursor_MU_Definitions CURSOR FAST_FORWARD FOR 
		SELECT muid.[ItemDefinitionUid]
			, muid.[CategoryUid]
			, mucd.[CategoryNumber]
			, mucd.[CategoryName]
			, muid.[MeasureNumber]
			, muid.[SubMeasureNumber]
			, muid.[MeasureDesc]
			, muid.[ExclusionDesc]
			, muid.[DenominatorDesc]
			, muid.[NumeratorDesc]
			, muid.[YesNo]
			, muid.[GoalDesc]
			, muid.[GoalValue]
		FROM [MeaningfulUseItemDefinition] AS muid with(nolock)
			INNER JOIN [MeaningfulUseCategoryDefinition] AS mucd with(nolock) ON muid.[CategoryUid] = mucd.[CategoryUid]
		WHERE muid.[StageUid] = 'CE4AB3AA-9FA7-4B81-B5F4-34AE309E6244'   -- 2019 PI Medicaid
		ORDER BY mucd.[CategoryName]
			, mucd.[CategoryNumber]
			, muid.[MeasureNumber]
    --
    OPEN cursor_MU_Definitions
    --
	FETCH NEXT FROM cursor_MU_Definitions 
		INTO @ItemDefinitionUid
			, @CategoryUid
			, @CategoryNumber
			, @CategoryName
			, @MeasureNumber
			, @SubMeasureNumber
			, @MeasureDesc
			, @ExclusionDesc
			, @DenominatorDesc
			, @NumeratorDesc
			, @YesNo
			, @GoalDesc
			, @GoalValue 
    --
   -- Make sure we have a valid cursor row
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @DenominatorSumValue = 0
		SET @NumeratorSumValue = 0
		SET @CurValue = '' 
		SET @MetGoal = 0 
		SET @NumDetailRows = 0
		
		-- Check if current MU metric has a numerator and denominator
		IF @YesNo IS NULL
		BEGIN
			-- Make sure we have some data for current metric
			SET @NumDetailRows = (SELECT COUNT(*)
								  FROM [#tblMeaningfulUseDetail]
								  WHERE [ItemDefinitionUid] = @ItemDefinitionUid
								 )
			IF (@NumDetailRows > 0)
			BEGIN
				-- Current MU metric has a numerator and demoninator
				SELECT  @DenominatorSumValue = SUM(mud.[DenominatorValue])
					, @NumeratorSumValue   = SUM(mud.[NumeratorValue]) 
				FROM     [#tblMeaningfulUseDetail] AS mud
				WHERE    mud.[ItemDefinitionUid] = @ItemDefinitionUid
				GROUP BY mud.[ItemDefinitionUid] 
			END    
           
			IF @DenominatorSumValue <= 0
			BEGIN
				SET @CurValue = 'N/A' 
			END 
			ELSE IF @NumeratorSumValue <= 0
			BEGIN 
				SET @CurValue = '0.00%' 
			END 
			ELSE 
			BEGIN 
				-- Calculate current MU metric value
				SET @CurValue = CONVERT(VARCHAR(10), CONVERT(DECIMAL(8,2), (CONVERT(DECIMAL(8,2), @NumeratorSumValue) / CONVERT(DECIMAL(8,2), @DenominatorSumValue)) * 100)) + '%'
	                  
				-- Determine if goal is satisfied
				IF CONVERT(DECIMAL(8,2), (CONVERT(DECIMAL(8,2), @NumeratorSumValue) / CONVERT(DECIMAL(8,2), @DenominatorSumValue)) * 100) > @GoalValue
				BEGIN
					SET @MetGoal = 1
				END 
			END 
             
			-- Insert MU summary row
			INSERT INTO @tblMeaingfulUseSummaryCoreAndMenuSet ([ItemDefinitionUid]
				, [CategoryNumber]
				, [CategoryName]
				, [MeasureNumber]
				, [SubMeasureNumber]
				, [MeasureDesc]
				, [DenominatorDesc]
				, [DenominatorValue]
				, [NumeratorDesc]
				, [NumeratorValue]
				, [YesNo]
				, [CurrentValue]
				, [GoalDesc]
				, [GoalValue]
				, [MetGoal]
				, [ProviderUid]
				, [ProviderLnFn]
			)   
			VALUES (@ItemDefinitionUid
				, @CategoryNumber
				, @CategoryName
				, @MeasureNumber
				, @SubMeasureNumber
				, @MeasureDesc
				, @DenominatorDesc
				, @DenominatorSumValue
				, @NumeratorDesc
				, @NumeratorSumValue
				, @YesNo
				, @CurValue
				, @GoalDesc
				, CONVERT([varchar](10), @GoalValue)
				, @MetGoal
				, null
				, null
			)  
		END 
		ELSE 
		BEGIN
			-- Current MU metric is YES/NO.  
			INSERT INTO @tblMeaingfulUseSummaryCoreAndMenuSet([ItemDefinitionUid]
				, [CategoryNumber]
				, [CategoryName]
				, [MeasureNumber]
				, [SubMeasureNumber]
				, [MeasureDesc]
				, [DenominatorDesc]
				, [DenominatorValue]
				, [NumeratorDesc]
				, [NumeratorValue]
				, [YesNo]
				, [CurrentValue]
				, [GoalDesc]
				, [GoalValue]
				, [MetGoal]
				, [ProviderUid]
				, [ProviderLnFn]
			)  
			VALUES (@ItemDefinitionUid
				, @CategoryNumber
				, @CategoryName
				, @MeasureNumber
				, @SubMeasureNumber
				, @MeasureDesc
				, @DenominatorDesc
				, null
				, @NumeratorDesc
				, null
				, @YesNo
				, null
				, @GoalDesc
				, null
				, null
				, null
				, null
			)  
		END
		-- 
		-- Get next cursor_MU_Definitions row
		FETCH NEXT FROM cursor_MU_Definitions INTO @ItemDefinitionUid
			, @CategoryUid
			, @CategoryNumber
			, @CategoryName
			, @MeasureNumber
			, @SubMeasureNumber
			, @MeasureDesc
			, @ExclusionDesc
			, @DenominatorDesc
			, @NumeratorDesc
			, @YesNo
			, @GoalDesc
			, @GoalValue 
    END
    --
    -- Close and Deallocate cursor
    CLOSE cursor_MU_Definitions
    DEALLOCATE cursor_MU_Definitions

	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CUS_MeaningfulUseDetail]') AND type in (N'U'))
	BEGIN
	CREATE TABLE [dbo].[CUS_MeaningfulUseDetail](
		[MeaningfulUseDetailUid] [uniqueidentifier] NOT NULL,
		[ReportInstanceUid] [uniqueidentifier] NOT NULL,
		[ItemDefinitionUid] [uniqueidentifier] NULL,
		[CategoryName] [varchar](500) NULL,
		[CategoryNumber] [int] NULL,
		[MeasureNumber] [int] NULL,
		[SubMeasureNumber] [int] NULL,
		[PersonUid] [uniqueidentifier] NULL,
		[PersonLnFn] [varchar](150) NULL,
		[ProviderUid] [varchar](max) NULL,
		[ProviderLnFn] [varchar](150) NULL,
		[ProviderNPI] [varchar](250) NULL,
		[NumeratorValue] [int] NULL,
		[DenominatorValue] [int] NULL,
		[YesNo] [int] NULL,
		[ObjectiveDesc] [varchar](500) NULL,
		[MeasureDesc] [varchar](600) NOT NULL,
		[MeasureDetailDesc] [varchar](600) NULL,
		[ExclusionDesc] [varchar](600) NULL,
		[DenominatorDesc] [varchar](500) NULL,
		[NumeratorDesc] [varchar](500) NULL,
		[GoalDesc] [varchar](250) NULL,
		[LastModifiedDate] [datetime] NOT NULL,
	 CONSTRAINT [PK_CUS_MeaningfulUseDetail] PRIMARY KEY CLUSTERED 
	(
		[MeaningfulUseDetailUid] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
	END

	IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CUS_MeaningfulUseDetail]') AND name = N'IX_CUS_MeaningfulUseDetail')
		CREATE NONCLUSTERED INDEX [IX_CUS_MeaningfulUseDetail] ON [dbo].[CUS_MeaningfulUseDetail]
		(
			[ReportInstanceUid] ASC,
			[ItemDefinitionUid] ASC,
			[PersonUid] ASC
		)
		INCLUDE ( 	[CategoryName],
			[CategoryNumber],
			[MeasureNumber],
			[NumeratorValue],
			[DenominatorValue],
			[ExclusionDesc],
			[DenominatorDesc],
			[SubMeasureNumber],
			[PersonLnFn],
			[ProviderUid],
			[ProviderLnFn],
			[NumeratorDesc],
			[GoalDesc],
			[YesNo],
			[ObjectiveDesc],
			[MeasureDesc],
			[MeasureDetailDesc],
			[MeaningfulUseDetailUid],
			[ProviderNPI],
			[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF_CUS_MeaningfulUseDetail_MeaningfulUseDetailUid]') AND type = 'D')
	BEGIN
		ALTER TABLE [dbo].[CUS_MeaningfulUseDetail] ADD  CONSTRAINT [DF_CUS_MeaningfulUseDetail_MeaningfulUseDetailUid]  DEFAULT (newid()) FOR [MeaningfulUseDetailUid]
	END

	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF_CUS_MeaningfulUseDetail_LastModifiedDate]') AND type = 'D')
	BEGIN
		ALTER TABLE [dbo].[CUS_MeaningfulUseDetail] ADD  CONSTRAINT [DF_CUS_MeaningfulUseDetail_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
	END

	EXEC MIPS_2018_Master_Report_DeleteReportInstance @ReportInstanceUid
	--
	-- Return detail table to caller
	--
	INSERT [CUS_MeaningfulUseDetail](
		[ReportInstanceUid],
		[ItemDefinitionUid],
		[CategoryName],
		[CategoryNumber],
		[MeasureNumber],
		[SubMeasureNumber],
		[PersonUid],
		[PersonLnFn],
		[ProviderUid],
		[ProviderLnFn],
		[ProviderNPI],
		[NumeratorValue],
		[DenominatorValue],
		[YesNo],
		[ObjectiveDesc],
		[MeasureDesc],
		[MeasureDetailDesc],
		[ExclusionDesc],
		[DenominatorDesc],
		[NumeratorDesc],
		[GoalDesc]
	)
	SELECT @ReportInstanceUid AS [ReportInstanceUid],
		t.[ItemDefinitionUid],
		COALESCE(t.[CategoryName], mucd.[CategoryName]) AS [CategoryName],
		t.[CategoryNumber],
		t.[MeasureNumber],
		t.[SubMeasureNumber],
		t.[PersonUid],
		t.[PersonLnFn],
		[ProviderUid],
		t.[ProviderLnFn],
		@ProviderNPI AS [ProviderNPI],
		t.[NumeratorValue],
		t.[DenominatorValue],
		t.[YesNo],
		MUID.[ObjectiveDesc],
		MUID.[MeasureDesc],
		MUID.[MeasureDetailDesc],
		MUID.[ExclusionDesc],
		MUID.[DenominatorDesc],
		MUID.[NumeratorDesc],
		MUID.[GoalDesc]
	FROM [#tblMeaningfulUseDetail] AS t
		INNER JOIN [MeaningfulUseItemDefinition] AS MUID with(nolock) ON MUID.[ItemDefinitionUid] = t.[ItemDefinitionUid]
		INNER JOIN [MeaningfulUseCategoryDefinition] AS mucd with (nolock) ON MUID.[CategoryUid] = mucd.[CategoryUid]
	ORDER BY [CategoryName] ASC,
		[CategoryNumber] ASC,
		[MeasureNumber] ASC,
		[SubMeasureNumber] ASC,
		[NumeratorValue] DESC,
		[DenominatorValue] DESC,
		[PersonLnFn] ASC 
	
	BEGIN TRY
		DROP TABLE [#tblMeaningfulUseDetail]
	END TRY
	BEGIN CATCH
	END CATCH
	
	-- Return Meaningful Use results to caller
	SELECT [RowId]
		, [ItemDefinitionUid]
		, [CategoryNumber]
		, [CategoryName]
		, [MeasureNumber]
		, [SubMeasureNumber]
		, [MeasureDesc]
		, [DenominatorDesc]
		, [DenominatorValue]
		, [NumeratorDesc]
		, [NumeratorValue]
		, [YesNo]
		, [CurrentValue]
		, [GoalDesc]
		, [GoalValue]
		, [MetGoal]
		, [ProviderUid]
		, [ProviderLnFn]
	FROM @tblMeaingfulUseSummaryCoreAndMenuSet    
	ORDER BY [CategoryNumber] ASC
		, [MeasureNumber] ASC
		, [SubMeasureNumber] ASC 
	
	IF (@Debug <> 0)
	BEGIN
		SELECT 'GOOD BYE'
	END 
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_Medicaid_Master_Report_DeleteReportInstance]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_Medicaid_Master_Report_DeleteReportInstance] AS' 
END
GO
ALTER PROCEDURE [dbo].[2019PI_Medicaid_Master_Report_DeleteReportInstance] 
	@ReportInstanceUid [uniqueidentifier]
AS
BEGIN
	SET NOCOUNT ON;

	IF @ReportInstanceUid IS NULL
		OR @ReportInstanceUid = '00000000-0000-0000-0000-000000000000'
		RETURN

	EXEC sp_executesql N'IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[CUS_MeaningfulUseDetail]'') AND type in (N''U'')) DELETE [CUS_MeaningfulUseDetail] WHERE [ReportInstanceUid] = @ReportInstanceUid',
		N'@ReportInstanceUid [uniqueidentifier]', @ReportInstanceUid 
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2019PI_Medicaid_Master_Report_LoadItemDefinition]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2019PI_Medicaid_Master_Report_LoadItemDefinition] AS' 
END
GO
ALTER PROCEDURE [dbo].[2019PI_Medicaid_Master_Report_LoadItemDefinition]
	@ReportInstanceUid [uniqueidentifier],
	@ItemDefinitionUid	[uniqueidentifier]AS
BEGIN
	DECLARE @EmptyUid [uniqueidentifier] = '00000000-0000-0000-0000-000000000000'

	IF @ReportInstanceUid IS NULL
		OR @ReportInstanceUid = @EmptyUid
		OR @ItemDefinitionUid IS NULL
		OR @ItemDefinitionUid = @EmptyUid
		RETURN

	DECLARE @sql [nvarchar](max) = N'IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[CUS_MeaningfulUseDetail]'') AND type in (N''U''))
		SELECT [ItemDefinitionUid], [CategoryName], [CategoryNumber], [MeasureNumber], [SubMeasureNumber], [PersonUid], [PersonLnFn],
			[ProviderUid], [ProviderLnFn], [ProviderNPI], [NumeratorValue], [DenominatorValue], [YesNo], [ObjectiveDesc], [MeasureDesc],
			[MeasureDetailDesc], [ExclusionDesc], [DenominatorDesc], [NumeratorDesc],[GoalDesc]
		FROM [CUS_MeaningfulUseDetail] with(nolock)
		WHERE [ReportInstanceUid] =  @ReportInstanceUid
			AND [ItemDefinitionUid] = @ItemDefinitionUid
		ORDER BY [CategoryName] ASC, [CategoryNumber] ASC, [MeasureNumber] ASC,	[SubMeasureNumber] ASC,	[NumeratorValue] DESC, [DenominatorValue] DESC,
			[PersonLnFn] ASC'

	EXEC sp_executesql @sql, N'@ReportInstanceUid [uniqueidentifier], @ItemDefinitionUid [uniqueidentifier]'
		, @ReportInstanceUid
		, @ItemDefinitionUid
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2020PI_E-Prescribing_1_NonControlled]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2020PI_E-Prescribing_1_NonControlled] AS' 
END
GO
--
-- Date    : 2018.12.03
-- Purpose : MU Stage 3
-- TFS     : 43001 - Meaningful Use 2015-2017 Objectives as a Dashboard and Report
--

ALTER PROC [dbo].[2020PI_E-Prescribing_1_NonControlled]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_E-Prescribing_1_NonControlled-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = 'B2DE6EA2-B6DF-47D3-9B22-FE0A5E301DC4',
		@RxStatusTransmittedSuccessfully [uniqueidentifier] = 'B1F7EFAF-D56D-4BAD-AE1F-8205E1D00B58', 
		@RxStatusQueuedForTransmission   [uniqueidentifier] = '0605B6F6-2FE4-49CB-B868-9DF448AB3E01'

	TRUNCATE TABLE #MetricDataTemp

	-- Initialize work table
	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
	SELECT @ItemDefinitionUid AS [ItemDefinitionUid]
		, med.[PersonUid]
		, COUNT(sts.[eRxStatusUid]) AS [NumeratorValue]                        
		, COUNT(med.[MedicationSIGUid]) AS [DenominatorValue]
		, null AS [YesNo]
	FROM   [#tblMedicationList] AS med
		LEFT JOIN [ListeRxStatus] AS sts WITH(NOLOCK) ON  med.[eRxStatusUid] = sts.[eRxStatusUid]
		 AND (sts.[eRxStatusUid] IN(@RxStatusTransmittedSuccessfully, @RxStatusQueuedForTransmission))
	WHERE med.[Dispensable] = 1
		AND med.[IsSampleGiven] = 0
		AND med.[IsAdministered] = 0
		AND med.[reffederaldeaclasscode] = 0
		AND [SIGDetailCount] = 1
	GROUP BY med.[PersonUid]
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_E-Prescribing_1_NonControlled -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2020PI_E-Prescribing_2_Controlled]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2020PI_E-Prescribing_2_Controlled] AS' 
END
GO
--
-- Date    : 2018.12.03
-- Purpose : MU Stage 3
-- TFS     : 43001 - Meaningful Use 2015-2017 Objectives as a Dashboard and Report
--

ALTER PROC [dbo].[2020PI_E-Prescribing_2_Controlled]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_E-Prescribing_2_Controlled-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = '1DFC1A89-3FF8-49D5-B115-F620C4443C0C',
		@RxStatusTransmittedSuccessfully [uniqueidentifier] = 'B1F7EFAF-D56D-4BAD-AE1F-8205E1D00B58', 
		@RxStatusQueuedForTransmission   [uniqueidentifier] = '0605B6F6-2FE4-49CB-B868-9DF448AB3E01'

	TRUNCATE TABLE #MetricDataTemp

	-- Initialize work table
	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
	SELECT @ItemDefinitionUid AS [ItemDefinitionUid]
		, med.[PersonUid]
		, COUNT(sts.[eRxStatusUid]) AS [NumeratorValue]                        
		, COUNT(med.[MedicationSIGUid]) AS [DenominatorValue]
		, null AS [YesNo]
	FROM   [#tblMedicationList] AS med
		LEFT JOIN [ListeRxStatus] AS sts WITH(NOLOCK) ON  med.[eRxStatusUid] = sts.[eRxStatusUid]
		 AND (sts.[eRxStatusUid] IN(@RxStatusTransmittedSuccessfully, @RxStatusQueuedForTransmission))
	WHERE med.[Dispensable] = 1
		AND med.[IsSampleGiven] = 0
		AND med.[IsAdministered] = 0
		AND med.[reffederaldeaclasscode] >= 0
		AND [SIGDetailCount] = 1
	GROUP BY med.[PersonUid]
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_E-Prescribing_2_Controlled -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2020PI_E-Prescribing_3_PDMP]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2020PI_E-Prescribing_3_PDMP] AS' 
END
GO
--
-- Date    : 2018.12.03
-- Purpose : MU Stage 3
-- TFS     : 43001 - Meaningful Use 2015-2017 Objectives as a Dashboard and Report
--

ALTER PROC [dbo].[2020PI_E-Prescribing_3_PDMP]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_E-Prescribing_3_PDMP-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = '1BF1FFC6-C2A2-4BF4-9EA9-E026829B30C5',
		@RxStatusTransmittedSuccessfully [uniqueidentifier] = 'B1F7EFAF-D56D-4BAD-AE1F-8205E1D00B58', 
		@RxStatusQueuedForTransmission   [uniqueidentifier] = '0605B6F6-2FE4-49CB-B868-9DF448AB3E01'

	TRUNCATE TABLE #MetricDataTemp

	--DECLARE @Audit TABLE (PatientUid UNIQUEIDENTIFIER)
	--INSERT INTO @Audit
	--SELECT a.PatientUid
	--FROM [#tblMedicationList] m
	--INNER JOIN Audit a on m.PersonUid = a.PatientUid 
	--	AND a.ChangeDate >= @RptTimespan_StartDate AND a.ChangeDate <= @RptTimespan_EndDate
	--	AND a.Description LIKE 'Appriss RX Report Requested Successfully%' or Description LIKE 'LogiCoy Report requested successfully%'

	-- Initialize work table
	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
	--THIS is not the right query
	--And needs to be changed to what is correct
	SELECT @ItemDefinitionUid AS [ItemDefinitionUid]
		, med.[PersonUid]
		, CASE WHEN a.PatientUid IS NOT NULL THEN 1 ELSE 0 END AS [NumeratorValue]                        
		, CASE WHEN med.PersonUid IS NOT NULL THEN 1 ELSE 0 END AS [DenominatorValue]
		, null AS [YesNo]
	FROM   [#tblMedicationList] AS med
	INNER JOIN [ListeRxStatus] AS sts WITH(NOLOCK) ON  med.[eRxStatusUid] = sts.[eRxStatusUid]
		 AND (sts.[eRxStatusUid] IN(@RxStatusTransmittedSuccessfully, @RxStatusQueuedForTransmission))
	LEFT JOIN cus_PDMP_Pats a on med.PersonUid = a.PatientUid
	WHERE med.[Dispensable] = 1
		AND med.[IsSampleGiven] = 0
		AND med.[IsAdministered] = 0
		AND med.[reffederaldeaclasscode] >= 2
		AND [SIGDetailCount] = 1
	GROUP BY med.[PersonUid], a.PatientUid
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_E-Prescribing_3_PDMP -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2020PI_HealthInformationExchange_1_Sending]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2020PI_HealthInformationExchange_1_Sending] AS' 
END
GO
ALTER PROC [dbo].[2020PI_HealthInformationExchange_1_Sending]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_HealthInformationExchange_1_Sending-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

     DECLARE @UTC_RptTimespan_StartDate DATETIME,@UTC_RptTimespan_EndDate DATETIME
      SELECT @UTC_RptTimespan_StartDate = @RptTimespan_StartDate
      SELECT @UTC_RptTimespan_EndDate   = DATEADD(DAY,1,@RptTimespan_EndDate)

      --RecordDisclosureAudit limit range, -1 day from min referral date and +3 days to max referral date
      DECLARE @RecordDisclosureAudit_StartDate DATE,@RecordDisclosureAudit_EndDate DATE
      SELECT @RecordDisclosureAudit_StartDate = DATEADD(DAY,-1,@RptTimespan_StartDate)
      SELECT @RecordDisclosureAudit_EndDate   = DATEADD(DAY,3,@RptTimespan_EndDate)

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = '789BD081-CA92-4C01-A895-EEAA848B1164'
	DECLARE @ExcludedReferrals TABLE (PatientReferralUid UNIQUEIDENTIFIER)

	INSERT INTO @ExcludedReferrals
	SELECT ViewUid FROM ViewPatientOutboundReferral v
	INNER JOIN ListProviderCareType p WITH(NOLOCK) on v.ProviderCareTypeUid = p.ProviderCareTypeUid AND p.ExcludeFromReferrals = 1

	INSERT INTO @ExcludedReferrals
	SELECT PatientReferralUid FROM PatientReferral WHERE ReferralTrackingStatusUid = 'F7D1B72C-83ED-4D2E-8AB2-2B86F31E8EB2'

      TRUNCATE TABLE #MetricDataTemp

      ;WITH cte_pr AS (
            select pr.*,dbo.UDF_CQMTestPatient (pr.PatientUid) AS TestPatient
            FROM ViewPatientReferralConsultReport pr 
			INNER JOIN #tblVisitList t on pr.VisitUid = t.VisitUid
            LEFT JOIN PatientReferral p WITH(NOLOCK) on pr.PatientReferralUid = p.PatientReferralUid
            LEFT JOIN VisitProcedure vp WITH(NOLOCK) on p.VisitProcedureUid = vp.VisitProcedureUid
            LEFT JOIN ListProcedure lp WITH(NOLOCK) on vp.ProcedureUid = lp.ProcedureUid      
			LEFT JOIN @ExcludedReferrals er on pr.PatientReferralUid = er.PatientReferralUid
            WHERE pr.RefType = 'PatientReferral'
                        AND (pr.ReferredByProviderUid IN (SELECT Element FROM dbo.Split(@ProviderUid, ',')) OR @ProviderUid IS NULL)
                        AND pr.ReferralDate >= @UTC_RptTimespan_StartDate AND pr.ReferralDate < @RecordDisclosureAudit_EndDate
                        AND (lp.ProcedureCodeTypeUid IS NULL OR lp.ProcedureCodeTypeUid NOT IN ('1E605C00-13F0-4B95-AEDB-7AA2E30A8BED'))
						AND er.PatientReferralUid IS NULL
      ),
      cte_rda AS (
            SELECT [DisclosureDate] ,
                  [DisclosureType] ,
                  [PatientUid] ,
                  rda.[PatientReferralUid] ,
                  [AttachmentGroupUid] ,
                  rda.[VisitUid] ,
                  [IsPortal],
                  [DisclosureMethod],
                  [Status],
                  [DisclosurePurpose]
            FROM RecordDisclosureAudit rda WITH(NOLOCK)
			--LEFT JOIN PatientReferral pr on rda.PatientReferralUid = pr.PatientReferralUid AND pr.ReferredByProviderUid = @ProviderUid
            WHERE DisclosureDate >= @RecordDisclosureAudit_StartDate
                  AND DisclosureType in (1,    -- Complete Chart
                                                      2,    -- Clinical Summary
                                                      11)  -- ContinuityOfCareDocument
                  AND DisclosureMethod IN (1,5,6,7)
                  AND DisclosurePurpose <> 'Released to Patient' --2016.02.23 dmg
                  AND [Status] > 0
      )
      INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
            SELECT @ItemDefinitionUid AS ItemDefinitionUid
                        ,r.PatientUid
                         ,COUNT(distinct CASE WHEN  rda.DisclosureType IS NOT NULL and rda.status = 4 THEN rda.PatientReferralUid
                              ELSE NULL END) AS NumeratorValue            
						,COUNT(distinct CASE WHEN r.PatientReferralUid is not null  and (r.ReferralStatus in ('Initiated', 'Appointment Confirmed')) THEN r.PatientReferralUid
                             ELSE NULL END) AS DenominatorValue 
                        ,null AS YesNo
            FROM cte_pr r 
           LEFT JOIN cte_rda rda ON r.PatientUid=rda.patientuid AND
                                    (
                                          r.VisitUid=rda.VisitUid 
                                          OR r.PatientReferralUid=rda.PatientReferralUid 
                                          OR r.AttachmentGroupUid=rda.AttachmentGroupUid
                                          --OR DATEDIFF(day,r.ReferralDate,rda.DisclosureDate) >= -1
                                    )
            WHERE r.TestPatient = 0
            GROUP BY r.PatientUid
            
      UPDATE #tblMeaningfulUseDetail
      SET NumeratorValue = 
            CASE 
                  WHEN NumeratorValue > DenominatorValue THEN DenominatorValue 
                  ELSE NumeratorValue 
            END
	  WHERE ItemDefinitionUid = @ItemDefinitionUid
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_HealthInformationExchange_1_Sending -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2020PI_HealthInformationExchange_2_Receiving]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2020PI_HealthInformationExchange_2_Receiving] AS' 
END
GO
ALTER PROC [dbo].[2020PI_HealthInformationExchange_2_Receiving]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_HealthInformationExchange_2_Receiving-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

	DECLARE @UTC_RptTimespan_StartDate DATETIME,@UTC_RptTimespan_EndDate DATETIME
	SELECT @UTC_RptTimespan_StartDate = @RptTimespan_StartDate, @UTC_RptTimespan_EndDate = @RptTimespan_EndDate
	SELECT @UTC_RptTimespan_StartDate = '01/01/'+CONVERT(VARCHAR(4),DATEPART(YEAR,@UTC_RptTimespan_StartDate))

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = '7C17B839-3E29-4AEC-9640-F23A52AFDC36'

	DECLARE @InitiatedReferrals TABLE (PatientReferralUid UNIQUEIDENTIFIER)
	INSERT INTO @InitiatedReferrals
	SELECT DISTINCT PatientReferralUid 
	FROM PatientReferralHistory 
	WHERE ReferralTrackingStatusUid IN ('0673DB25-454C-44D8-B83F-AFCF97879AAD','3B180FEC-FAE0-4850-AE16-6172CC31F7A7')

	TRUNCATE TABLE #MetricDataTemp

	;WITH cte_Ref AS (
	SELECT vfp.PersonUid AS PatUid
			, rag.VisitUid AS Uid
			, COALESCE(a.AttachmentUid, ag.AttachmentGroupUid) AS AttUid
			, COALESCE(a.FileDate, ag.LastModifiedDate) AS AttDate
			, aa.HasClinicalDocument AS NumID
			, aa.MedicationAllergiesReconciledDate
			, aa.MedicationsReconciledDate
			, aa.ProblemsReconciledDate
			, a.AttachmentTypeUid
			, latDM.ExternalID AS AttachmentTypeID
	FROM #tblPatientList vfp
	INNER JOIN RelAttachmentGroup rag on vfp.PersonUid = rag.PersonUid
	INNER JOIN Visit v on rag.VisitUid = v.VisitUid AND (v.VisitDate >= @RptTimespan_StartDate AND v.VisitDate <= @RptTimespan_EndDate)
	INNER JOIN #tblProviderList prov on v.ProviderUid = prov.ProviderUid
	LEFT JOIN Attachment a on rag.AttachmentGroupUid = a.AttachmentGroupUid
	LEFT JOIN ListAttachmentType latDM on a.AttachmentTypeUid = latDM.AttachmentTypeUid
	LEFT JOIN AttachmentGroup ag on rag.AttachmentGroupUid = ag.AttachmentGroupUid
	INNER JOIN ListAttachmentType lat on (a.AttachmentTypeUid = lat.AttachmentTypeUid OR ag.AttachmentTypeUid = lat.AttachmentTypeUid) AND (lat.AttachmentTypeUid = 'B71B8F20-7B7D-4A7C-9E75-05811A0791AD')
	LEFT JOIN MessageAA aa on rag.RelAttachmentGroupUid = aa.RelAttachmentGroupUid --AND aa.SummaryOfCareReconciledDate IS NOT NULL
	LEFT JOIN Message m on aa.MessageUid = m.MessageUid

	UNION ALL

	SELECT vfp.PersonUid AS PatUid
			, pr.PatientReferralUid AS Uid
			, aa.MessageUid AS AttUid
			, pr.CreatedDate AS AttDate
			, aa.HasClinicalDocument AS NumID
			, aa.MedicationAllergiesReconciledDate
			, aa.MedicationsReconciledDate
			, aa.ProblemsReconciledDate
			, att.AttachmentTypeUid
			, lat.ExternalID AS AttachmentTypeID
	FROM #tblPatientList vfp
	INNER JOIN RelAttachmentGroup r ON vfp.PersonUid = r.PersonUid
	INNER JOIN MessageAA aa ON aa.RelAttachmentGroupUid = r.RelAttachmentGroupUid --AND aa.ElectronicSummaryOfCareReceived = 1
	LEFT JOIN Attachment att on r.AttachmentGroupUid = att.AttachmentGroupUid
	LEFT JOIN ListAttachmentType lat on att.AttachmentTypeUid = lat.AttachmentTypeUid
	INNER JOIN PatientReferral pr on r.PatientReferralUid = pr.PatientReferralUid 
			AND (pr.CreatedDate >= @RptTimespan_StartDate AND pr.CreatedDate <= @RptTimespan_EndDate)
			AND pr.ReferralTrackingStatusUid <> '3B180FEC-FAE0-4850-AE16-6172CC31F7A7'
	INNER JOIN PatientProviderRelationship ppr on pr.PatientProviderRelationshipUid = ppr.PatientProviderRelationshipUid
	INNER JOIN #tblProviderList prov on pr.ReferredByProviderUid = prov.ProviderUid
	INNER JOIN @InitiatedReferrals ir on pr.PatientReferralUid = ir.PatientReferralUid
	)


	--SELECT * FROM cte_Ref
	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
		SELECT @ItemDefinitionUid AS ItemDefinitionUid
				,PatUid
				,COUNT(distinct CASE WHEN MedicationAllergiesReconciledDate IS NOT NULL 
						AND MedicationsReconciledDate IS NOT NULL
						AND ProblemsReconciledDate IS NOT NULL
							THEN Uid
						WHEN AttachmentTypeUid = '91293E86-6AA1-4B30-AA00-7DDD42135D64' THEN Uid
						WHEN AttachmentTypeID = 'DMail' THEN Uid
							ELSE NULL END) AS NumeratorValue
				,COUNT(DISTINCT Uid) AS DenominatorValue
				,NULL AS YesNo
		FROM cte_Ref
		GROUP BY PatUid


	IF EXISTS (
		SELECT TOP 1 *
		FROM #tblMeaningfulUseDetail
		WHERE [ItemDefinitionUid] = @ItemDefinitionUid
	)
    BEGIN
	    UPDATE [#tblMeaningfulUseDetail]
		SET [NumeratorValue] = CASE WHEN [NumeratorValue] > [DenominatorValue] THEN [DenominatorValue] ELSE [NumeratorValue] END
    END
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_HealthInformationExchange_2_Receiving -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2020PI_ProviderToPatientExchange]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2020PI_ProviderToPatientExchange] AS' 
END
GO
ALTER PROC [dbo].[2020PI_ProviderToPatientExchange]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_ProviderToPatientExchange-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = '1CB10175-5BE1-4260-BFB5-7EBD5A3767E6'

	TRUNCATE TABLE [#MetricDataTemp]

	-- Populate Denominator Value
	INSERT INTO [#tblMeaningfulUseDetail] ([ItemDefinitionUid]
		, [PersonUid]
		, [NumeratorValue]
		, [DenominatorValue]
		, [YesNo]
	)
	SELECT @ItemDefinitionUid AS [ItemDefinitionUid]
		, p.PersonUid
		, COUNT(DISTINCT CASE WHEN p.[HasPortalAccount] <> 0 THEN p.[PersonUid]
				ELSE NULL END)AS [NumeratorValue]           
		, COUNT(DISTINCT p.[PersonUid]) AS [DenominatorValue]
		, null AS [YesNo]
	FROM  [#tblPatientList] AS p
	WHERE (p.[IsEM] <> 0 OR p.IsVP <> 0)
	GROUP BY p.[PersonUid]
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2019PI_ProviderToPatientExchange -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2020PI_Master_DesktopControl]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2020PI_Master_DesktopControl] AS' 
END
GO
ALTER PROC [dbo].[2020PI_Master_DesktopControl]
(
	@ProviderUid			[varchar](max) = NULL,  
	@RptTimespan_StartDate	[date],
	@RptTimespan_EndDate	[date],
	@ProviderBilling		[bit] = 1,
	@ProviderRendering		[bit] = 0,
	@Debug					[int] = 0,
	@includetestpat			[bit] = 0,
	@ServiceSiteUID			[varchar](max) = null, 
	@FinancialCenterUID		[varchar](max) = null
)
AS
BEGIN

SET NOCOUNT ON;
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;
	--
	-- Calling syntax :    
	--
	--

	IF (@RptTimespan_StartDate IS NULL)
	BEGIN
		SET @RptTimespan_StartDate = '01-01-1900'
	END 
	IF (@RptTimespan_EndDate IS NULL)
	BEGIN
		SET @RptTimespan_EndDate = GETDATE()
	END 

	CREATE TABLE [#tblProviderList]
	(
		[ProviderUid] [uniqueidentifier] NOT NULL primary key clustered
	)
	 	 
	DECLARE @HasProviderUid [bit] = 0
	EXEC [2019PI_Master_PopulateProviderList] @ProviderUid, @HasProviderUid out

	-- Measure stored procedure flag indicating Meaningful Use data will be used for a report
	DECLARE @ReportMode [bit] = 0

	IF NOT EXISTS (SELECT 1 FROM sysobjects WHERE Name='cus_PDMP_Pats' and XType='U')
		EXEC FillPDMPPatsTable
		

	CREATE TABLE [#tblVisitList]
	(
		[VisitUid]							[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[VisitDate]							[date]         NOT NULL,
		[PatientUid]						[uniqueidentifier] NOT NULL,
		[TestPat]					   		[bit],
		[IsEM]								[bit],
		[IsVP]								[bit],
		[ProviderUid]						[varchar](max),
		[RenderingProviderUid]				[varchar](max),
		[LastSavedByUid]					[uniqueidentifier],
		[SavedByBillingProvider]			[bit],
		[SavedByRenderingProvider]			[bit],
		[TransitionOfCare]					[bit],
		[MedicationChecked]					[bit],
		[DrugAllergyChecked]				[bit],
		[ProblemChecked]					[bit],
		[SummaryProvidedToPatient]			[date],
		[PatientDeclinedClinicalSummary]	[bit],
		[HasEduForm]						[bit],
		[HasPortalAccount]					[bit],
		[PrintedDate]						[date]
	)
	--
	-- PopulateVisitList
	EXEC [2019PI_Master_PopulateVisitList] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@Debug,
		@ServiceSiteUID,
		@FinancialCenterUID
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblVisitList]
		ORDER BY [VisitDate] DESC 
	END

	CREATE TABLE [#tblPatientList] 
	(
		[PersonUid]					[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[PatientLnFn]				[varchar](250),
		[Birthdate]					[date],
		[TestPat]					[bit],
		[IsEM]						[bit],
		[IsVP]						[bit],
		[FullDemographics]			[bit],
		[HasEduForm]				[bit],
		[EduFormPrinted]			[bit],
		[HasPortalAccount]			[bit],
		[PortalPerson]				[uniqueidentifier] NULL,
		[PortalValid]				[date] NULL,
		[PortalExpire]				[date] NULL,
		[SummaryProvidedToPatient]	[bit],
		[TransitionOfCare]			[bit],
		[MedicationChecked]			[bit],
		[SavedByBillingProvider]	[bit],
		[SavedByRenderingProvider]	[bit],
		[YearsOldOrOlder2]			[bit] NULL,
		[YearsOldOrOlder3]			[bit] NULL,
		[YearsOldOrYounger5]		[bit] NULL, 
		[YearsOldOrOlder13]			[bit] NULL,
		[YearsOldOrOlder65]			[bit] NULL
	)
	--
	-- Populate Patient List
	EXEC [2019PI_Master_PopulatePatientList] @ProviderUid, 
			@RptTimespan_StartDate,
			@RptTimespan_EndDate,
			@ProviderBilling,
			@ProviderRendering,
			@Debug

	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblPatientList]
		ORDER BY [PatientLnFn]
	END

	--back fill #tblVisitList with patient specific information
	--delete test patient records from #tblVisitList AND #tblPatientList IF @includetestpat = 0
	EXEC [2019PI_Master_SynchronizeVisitAndPatient] @Debug = @Debug,
		@IncludeTestPatients = @includetestpat

	-- Build list of Medications that are within reporting range
	CREATE TABLE #tblMedicationList
	(
		[MedicationSIGUid]					[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[CreatedDate]						[datetime] NOT NULL,
		[RelVisitMedicationUid]				[uniqueidentifier],
		[PersonUid]							[uniqueidentifier],
		[TestPat]							[bit],
		[LicensedHealthcareProfessional]	[bit] NOT NULL,
		[Dispensable]						[bit] NULL,
		[IsSampleGiven]						[bit] NOT NULL,
		[IsAdministered]					[bit] NOT NULL,
		[reffederaldeaclasscode]			[int] NULL,
		[SIGDetailCount]					[int] NULL,
		[eRxStatusUid]						[uniqueidentifier]
	)
	--
	-- PopulateMedicationList
	EXEC [2019PI_Master_PopulateMedicationList]
		@ProviderUid
		, @ProviderBilling
		, @RptTimespan_StartDate
		, @RptTimespan_EndDate
		, @includetestpat
		, @Debug
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblMedicationList]
		ORDER BY [CreatedDate] DESC 
	END

	-- Build list of Orders that are within reporting range
	CREATE TABLE [#tblOrderList]
	(
		[ObservationOrderUid]				[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[PatientUid]						[uniqueidentifier] NOT NULL,
		[TestPat]					   		[bit],
		[VPUid]								[uniqueidentifier] NULL,
		[CreatedBy]							[uniqueidentifier] NULL,
		[OrderDate]							[datetime]         NOT NULL,
		[ProcedureCodeTypeUid]				[uniqueidentifier] NULL,
		[ProcedureCodeTypeName]				[varchar](500)     NULL,
		[AttachmentTypeUid]					[uniqueidentifier] NULL,
		[AttachmentTypeName]				[varchar](500)	NULL,
		[LicensedHealthcareProfessional]	[bit]			NOT NULL,
		[ImageResultsDirectlyAccessible]	[bit]			NULL,
		[ResultStatusID]					[int]			NULL
	)
	--
	-- PopulateOrderList
	EXEC [2019PI_Master_PopulateOrderList] @ProviderUid
		, @ProviderBilling
		, @RptTimespan_StartDate
		, @RptTimespan_EndDate
		, @includetestpat
		, @Debug
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblOrderList]
		ORDER BY [OrderDate] DESC 
	END

	-- Create work table that will hold the Meaningful Use results
	CREATE TABLE [#tblMeaningfulUseDetail] 
	(
		[RowId]               [int] IDENTITY(1,1) PRIMARY KEY,     -- Primary Key
		[ItemDefinitionUid]   [uniqueidentifier],                  -- MeaningfulUseItemDefinition.ItemDefinitionUid   
		[PersonUid]           [uniqueidentifier] NULL,             -- Unique list of Visit.PatientUid
		[NumeratorValue]      [int] NULL,                          -- See MeaningfulUseItemDefinition.NumeratorDesc
		[DenominatorValue]    [int] NULL,                          -- See MeaningfulUseItemDefinition.DenominatorDesc
		[YesNo]               [int] NULL                           -- See MeaningfulUseItemdefinition.YesNo.  Null-NA, 0-No/False, 1-Yes/True.
		unique clustered ([RowId])
	)  

	CREATE NONCLUSTERED INDEX [MUDetail_ItemDef_PersonUid] ON [#tblMeaningfulUseDetail]
	(
		[ItemDefinitionUid] ASC,
		[PersonUid] ASC
	)
	WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

	-- Create temp table that can be used by measure procs
	CREATE TABLE [#MetricDataTemp]
	(
		[PersonUid]							[uniqueidentifier] NOT NULL,
		[HeightRecorded]					[int] NULL,
		[WeightRecorded]					[int] NULL,
		[BloodPressureRecorded]				[int] NULL,
		[LabResultTotalCount]				[int] NULL, 
		[LabResultTemplatedCount]			[int] NULL,
		[TaskDocGenCount]					[int] NULL, 
		[TaskDocGenCompleteCount]			[int] NULL,   
		[VisitCount]						[int] NULL, 
		[ClinicalSummaryProvidedCount]		[int] NULL,  
		[PreventativeFollowupDueCount]		[int] NULL, 
		[PreventativeFollowupSentCount]		[int] NULL,   
		[SeenByAnotherProviderCount]		[int] NULL, 
		[MedicalCheckedCount]				[int] NULL,  
		[ReferralCount]						[int] NULL, 
		[ReferralClinicalSummaryProvided]	[int] NULL
	) 	
	
	-- Proc based on MUII_Master_DesktopControl
	--  
	-- Calculate Measures
	EXEC [2020PI_E-Prescribing_1_NonControlled] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2020PI_E-Prescribing_2_Controlled] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2020PI_E-Prescribing_3_PDMP] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

--Removed for the 2020 Measure
	--EXEC [2019PI_E-Prescribing_4_VerifyOpioidAgreement] @ProviderUid,
	--	@ProviderBilling,
	--	@RptTimespan_StartDate,
	--	@RptTimespan_EndDate,
	--	@ReportMode,
	--	@Debug  -- DONE

	EXEC [2020PI_HealthInformationExchange_1_Sending] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2020PI_HealthInformationExchange_2_Receiving] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2020PI_ProviderToPatientExchange] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	-- Drop temp tables that are used by measure procs
	BEGIN TRY
		DROP TABLE [#tblVisitList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#tblPatientList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#tblProviderList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#MetricDataTemp]
	END TRY 
	BEGIN CATCH
	END CATCH

	-- Define table that will be returned to caller
	DECLARE @tblMeaingfulUseSummaryCoreAndMenuSet TABLE
	(
		[RowId]             [int] IDENTITY(1,1) PRIMARY KEY,
		[ItemDefinitionUid] [uniqueidentifier],
		[CategoryNumber]    [int] NULL,
		[CategoryName]      [varchar](100) NULL,
		[MeasureNumber]     [int] NULL, 
		[SubMeasureNumber]  [int] NULL,
		[MeasureDesc]       [varchar](500) NULL,
		[DenominatorDesc]   [varchar](250) NULL,
		[DenominatorValue]  [int] NULL,
		[NumeratorDesc]     [varchar](250) NULL,
		[NumeratorValue]    [int] NULL,
		[YesNo]     [varchar](50)  NULL,
		[CurrentValue]	  [varchar](25)  NULL,
		[GoalDesc]          [varchar](250) NULL,
		[GoalValue]         [varchar](10)  NULL,
		[MetGoal]           [bit] NULL, 
		[ProviderUid]       [varchar](max) NULL,
		[ProviderLnFn]      [varchar](150) NULL,       
		unique clustered  ([RowId])
	) 

	-- Determine if there are any MU detail rows to base metrics against
	DECLARE @NumDetailRows [int]

	-- Walk through list of defined Meaningful Use metrics and popluate @tblMeaingfulUseSummaryCoreAndMenuSet 
	DECLARE @ItemDefinitionUid [uniqueidentifier]
		, @CategoryUid [uniqueidentifier]
		, @CategoryNumber [int]
		, @CategoryName [varchar](100)
		, @MeasureNumber [int]
		, @SubMeasureNumber [int]
		, @MeasureDesc [varchar](500)
		, @ExclusionDesc [varchar](250)
		, @DenominatorDesc [varchar](250)
		, @NumeratorDesc [varchar](250)
		, @YesNo [varchar](50)
		, @GoalDesc [varchar](250)
		, @GoalValue [decimal](5, 2)
		, @DenominatorSumValue [int]
		, @NumeratorSumValue [int]
		, @CurValue [varchar](25)
		, @MetGoal [bit]    
        
    --
    -- Populate table that will be returned to caller
	DECLARE cursor_MU_Definitions CURSOR FAST_FORWARD FOR 
		SELECT muid.[ItemDefinitionUid]
			, muid.[CategoryUid]
			, mucd.[CategoryNumber]
			, mucd.[CategoryName]
			, muid.[MeasureNumber]
			, muid.[SubMeasureNumber]
			, muid.[MeasureDesc]
			, muid.[ExclusionDesc]
			, muid.[DenominatorDesc]
			, muid.[NumeratorDesc]
			, muid.[YesNo]
			, muid.[GoalDesc]
			, muid.[GoalValue]
		FROM [MeaningfulUseItemDefinition] AS muid with(nolock)
			INNER JOIN [MeaningfulUseCategoryDefinition] AS mucd with(nolock) ON muid.[CategoryUid] = mucd.[CategoryUid]
/*Replace w/new StageUid*/		WHERE muid.[StageUid] = 'E35CB2B2-DE24-4C20-B139-91EBEF6B19A8'   --2020 PI
		ORDER BY mucd.[CategoryName]
			, mucd.[CategoryNumber]
			, muid.[MeasureNumber]
    --
    OPEN cursor_MU_Definitions
    --
	FETCH NEXT FROM cursor_MU_Definitions 
		INTO @ItemDefinitionUid
			, @CategoryUid
			, @CategoryNumber
			, @CategoryName
			, @MeasureNumber
			, @SubMeasureNumber
			, @MeasureDesc
			, @ExclusionDesc
			, @DenominatorDesc
			, @NumeratorDesc
			, @YesNo
			, @GoalDesc
			, @GoalValue 
    --
   -- Make sure we have a valid cursor row
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @DenominatorSumValue = 0
		SET @NumeratorSumValue = 0
		SET @CurValue = '' 
		SET @MetGoal = 0 
		SET @NumDetailRows = 0
		
		-- Check if current MU metric has a numerator and denominator
		IF @YesNo IS NULL
		BEGIN
			-- Make sure we have some data for current metric
			SET @NumDetailRows = (SELECT COUNT(*)
								  FROM [#tblMeaningfulUseDetail]
								  WHERE [ItemDefinitionUid] = @ItemDefinitionUid
								 )
			IF (@NumDetailRows > 0)
			BEGIN
				-- Current MU metric has a numerator and demoninator
				SELECT  @DenominatorSumValue = SUM(mud.[DenominatorValue])
					, @NumeratorSumValue   = SUM(mud.[NumeratorValue]) 
				FROM     [#tblMeaningfulUseDetail] AS mud
				WHERE    mud.[ItemDefinitionUid] = @ItemDefinitionUid
				GROUP BY mud.[ItemDefinitionUid] 
			END    
           
			IF @DenominatorSumValue <= 0
			BEGIN
				SET @CurValue = 'N/A' 
			END 
			ELSE IF @NumeratorSumValue <= 0
			BEGIN 
				SET @CurValue = '0.00%' 
			END 
			ELSE 
			BEGIN 
				-- Calculate current MU metric value
				SET @CurValue = CONVERT(VARCHAR(10), CONVERT(DECIMAL(8,2), (CONVERT(DECIMAL(8,2), @NumeratorSumValue) / CONVERT(DECIMAL(8,2), @DenominatorSumValue)) * 100)) + '%'
	                  
				-- Determine if goal is satisfied
				IF CONVERT(DECIMAL(8,2), (CONVERT(DECIMAL(8,2), @NumeratorSumValue) / CONVERT(DECIMAL(8,2), @DenominatorSumValue)) * 100) > @GoalValue
				BEGIN
					SET @MetGoal = 1
				END 
			END 
             
			-- Insert MU summary row
			INSERT INTO @tblMeaingfulUseSummaryCoreAndMenuSet ([ItemDefinitionUid]
				, [CategoryNumber]
				, [CategoryName]
				, [MeasureNumber]
				, [SubMeasureNumber]
				, [MeasureDesc]
				, [DenominatorDesc]
				, [DenominatorValue]
				, [NumeratorDesc]
				, [NumeratorValue]
				, [YesNo]
				, [CurrentValue]
				, [GoalDesc]
				, [GoalValue]
				, [MetGoal]
				, [ProviderUid]
				, [ProviderLnFn]
			)   
			VALUES (@ItemDefinitionUid
				, @CategoryNumber
				, @CategoryName
				, @MeasureNumber
				, @SubMeasureNumber
				, @MeasureDesc
				, @DenominatorDesc
				, @DenominatorSumValue
				, @NumeratorDesc
				, @NumeratorSumValue
				, @YesNo
				, @CurValue
				, @GoalDesc
				, CONVERT([varchar](10), @GoalValue)
				, @MetGoal
				, null
				, null
			)  
		END 
		ELSE 
		BEGIN
			-- Current MU metric is YES/NO.  
			INSERT INTO @tblMeaingfulUseSummaryCoreAndMenuSet([ItemDefinitionUid]
				, [CategoryNumber]
				, [CategoryName]
				, [MeasureNumber]
				, [SubMeasureNumber]
				, [MeasureDesc]
				, [DenominatorDesc]
				, [DenominatorValue]
				, [NumeratorDesc]
				, [NumeratorValue]
				, [YesNo]
				, [CurrentValue]
				, [GoalDesc]
				, [GoalValue]
				, [MetGoal]
				, [ProviderUid]
				, [ProviderLnFn]
			)  
			VALUES (@ItemDefinitionUid
				, @CategoryNumber
				, @CategoryName
				, @MeasureNumber
				, @SubMeasureNumber
				, @MeasureDesc
				, @DenominatorDesc
				, null
				, @NumeratorDesc
				, null
				, @YesNo
				, null
				, @GoalDesc
				, null
				, null
				, null
				, null
			)  
		END
		-- 
		-- Get next cursor_MU_Definitions row
		FETCH NEXT FROM cursor_MU_Definitions INTO @ItemDefinitionUid
			, @CategoryUid
			, @CategoryNumber
			, @CategoryName
			, @MeasureNumber
			, @SubMeasureNumber
			, @MeasureDesc
			, @ExclusionDesc
			, @DenominatorDesc
			, @NumeratorDesc
			, @YesNo
			, @GoalDesc
			, @GoalValue 
    END
    --
    -- Close and Deallocate cursor
    CLOSE cursor_MU_Definitions
    DEALLOCATE cursor_MU_Definitions
	
	-- Return Meaningful Use results to caller
	SELECT 'MeaingfulUseSummaryCoreAndMenuSet'
	SELECT [RowId]
		, [ItemDefinitionUid]
		, [CategoryNumber]
		, [CategoryName]
		, [MeasureNumber]
		, [SubMeasureNumber]
		, [MeasureDesc]
		, [DenominatorDesc]
		, [DenominatorValue]
		, [NumeratorDesc]
		, [NumeratorValue]
		, [YesNo]
		, [CurrentValue]
		, [GoalDesc]
		, [GoalValue]
		, [MetGoal]
		, [ProviderUid]
		, [ProviderLnFn]
	FROM @tblMeaingfulUseSummaryCoreAndMenuSet    
	ORDER BY [CategoryNumber] ASC
		, [MeasureNumber] ASC
		, [SubMeasureNumber] ASC 
	
	IF (@Debug <> 0)
	BEGIN
		SELECT 'GOOD BYE'
	END 
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2020PI_Master_Report]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2020PI_Master_Report] AS' 
END
GO
ALTER PROC [dbo].[2020PI_Master_Report]
(
	@ReportInstanceUid [uniqueidentifier],
	@ProviderUid [varchar](max) = NULL, 
	@RptTimespan_StartDate [date],
	@RptTimespan_EndDate [date],
	@ProviderOption [varchar](100) = 'Billing Provider', --	Billing Provider and Rendering Provider 
	@Debug [int] = 0,
	@includetestpat	[bit] = 0,
	@ServiceSiteUID	[varchar](max) = null, 
	@FinancialCenterUID	[varchar](max) = null
)
AS
BEGIN
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;
	--
	--  

	IF (@RptTimespan_StartDate IS NULL)
	BEGIN
		SET @RptTimespan_StartDate = '01-01-1900'
	END 
	IF (@RptTimespan_EndDate IS NULL)
	BEGIN
		SET @RptTimespan_EndDate = GETDATE()
	END

	CREATE TABLE [#tblProviderList]
	(
		[ProviderUid] [uniqueidentifier] NOT NULL primary key clustered
	)
	 
	DECLARE @HasProviderUid [bit] = 0
	EXEC [2019PI_Master_PopulateProviderList] @ProviderUid, @HasProviderUid out

	DECLARE @ClaimFormatValueTypeProviderNPIUid [uniqueidentifier] = 'CE282F4E-A866-49BA-9636-C4BA0439E907',
		@ReportMode [bit] = 1,
		@ProviderBilling [bit] = 0,
		@ProviderRendering [bit] = 0,
		@ProviderNPI [varchar](100) = null

	-- Find the first provider has provider NPI

	SELECT TOP 1 @ProviderNPI = [Value]
	FROM [ClaimFormatValue] with(nolock)
	WHERE [ClaimFormatValueTypeUid] = @ClaimFormatValueTypeProviderNPIUid
		AND [ProviderUid] IN (SELECT [ProviderUid] FROM [#tblProviderList])

	-- Set local Billing and Rendering Provider Flags
	IF (@ProviderOption = 'Billing Provider')
	BEGIN
		SET @ProviderBilling = 1
		SET @ProviderRendering = 0
	END
	ELSE
	BEGIN
		SET @ProviderBilling = 0
		SET @ProviderRendering = 1	
	END

	IF NOT EXISTS (SELECT 1 FROM sysobjects WHERE Name='cus_PDMP_Pats' and XType='U')
		EXEC FillPDMPPatsTable

	-- Measure stored procedure flag indicating Meaningful Use data will be used for a report
CREATE TABLE [#tblVisitList]
	(
		[VisitUid]							[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[VisitDate]							[date]         NOT NULL,
		[PatientUid]						[uniqueidentifier] NOT NULL,
		[TestPat]					   		[bit],
		[IsEM]								[bit],
		[IsVP]								[bit],
		[ProviderUid]						[varchar](max),
		[RenderingProviderUid]				[varchar](max),
		[LastSavedByUid]					[uniqueidentifier],
		[SavedByBillingProvider]			[bit],
		[SavedByRenderingProvider]			[bit],
		[TransitionOfCare]					[bit],
		[MedicationChecked]					[bit],
		[DrugAllergyChecked]				[bit],
		[ProblemChecked]					[bit],
		[SummaryProvidedToPatient]			[date],
		[PatientDeclinedClinicalSummary]	[bit],
		[HasEduForm]						[bit],
		[HasPortalAccount]					[bit],
		[PrintedDate]						[date]
	)
	--
	-- PopulateVisitList
	EXEC [2019PI_Master_PopulateVisitList] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@Debug,
		@ServiceSiteUID,
		@FinancialCenterUID

	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblVisitList]
		ORDER BY [VisitDate] DESC 
	END

	CREATE TABLE [#tblPatientList] 
	(
		[PersonUid]					[uniqueidentifier] NOT NULL primary key clustered,
		[PatientLnFn]				[varchar](250),
		[Birthdate]					[date],
		[TestPat]					[bit],
		[IsEM]						[bit],
		[IsVP]						[bit],
		[FullDemographics]			[bit],
		[HasEduForm]				[bit],
		[EduFormPrinted]			[bit],
		[HasPortalAccount]			[bit],
		[PortalPerson]				[uniqueidentifier] NULL,
		[PortalValid]				[date] NULL,
		[PortalExpire]				[date] NULL,
		[SummaryProvidedToPatient]	[bit],
		[TransitionOfCare]			[bit],
		[MedicationChecked]			[bit],
		[SavedByBillingProvider]	[bit],
		[SavedByRenderingProvider]	[bit],
		[YearsOldOrOlder2]			[bit] NULL,
		[YearsOldOrOlder3]			[bit] NULL,
		[YearsOldOrYounger5]		[bit] NULL, 
		[YearsOldOrOlder13]			[bit] NULL,
		[YearsOldOrOlder65]			[bit] NULL
	)
	--
	-- Populate Patient List
	EXEC [2019PI_Master_PopulatePatientList] 
			@ProviderUid, 
			@RptTimespan_StartDate,
			@RptTimespan_EndDate,
			@ProviderBilling,
			@ProviderRendering,
			@Debug

	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblPatientList]
		ORDER BY [PatientLnFn]
	END

	--back fill #tblVisitList with patient specific information
	--delete test patient records from #tblVisitList AND #tblPatientList IF @includetestpat = 0
	EXEC [2019PI_Master_SynchronizeVisitAndPatient] @Debug = @Debug,
		@IncludeTestPatients = @includetestpat

	-- Build list of Medications that are within reporting range
	CREATE TABLE [#tblMedicationList]
	(
		[MedicationSIGUid]					[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[CreatedDate]						[datetime] NOT NULL,
		[RelVisitMedicationUid]				[uniqueidentifier],
		[PersonUid]							[uniqueidentifier],
		[TestPat]							[bit],
		[LicensedHealthcareProfessional]	[bit] NOT NULL,
		[Dispensable]						[bit] NULL,
		[IsSampleGiven]						[bit] NOT NULL,
		[IsAdministered]					[bit] NOT NULL,
		[reffederaldeaclasscode]			[int] NULL,
		[SIGDetailCount]					[int] NULL,
		[eRxStatusUid]						[uniqueidentifier]
	)
	--
	-- PopulateMedicationList
	EXEC [2019PI_Master_PopulateMedicationList] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@includetestpat,
		@Debug
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblMedicationList]
		ORDER BY [CreatedDate] DESC 
	END

	-- Build list of Orders that are within reporting range
	CREATE TABLE [#tblOrderList]
	(
		[ObservationOrderUid]				[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[PatientUid]						[uniqueidentifier] NOT NULL,
		[TestPat]					 		[bit],
		[VPUid]								[uniqueidentifier] NULL,
		[CreatedBy]							[uniqueidentifier] NULL,
		[OrderDate]							[datetime] NOT NULL,
		[ProcedureCodeTypeUid]				[uniqueidentifier] NULL,
		[ProcedureCodeTypeName]				[varchar](500) NULL,
		[AttachmentTypeUid]					[uniqueidentifier] NULL,
		[AttachmentTypeName]				[varchar](500) NULL,
		[LicensedHealthcareProfessional]	[bit] NOT NULL,
		[ImageResultsDirectlyAccessible]	[bit] NULL,
		[ResultStatusID]					[int] NULL
	)
	--
	-- PopulateOrderList
	EXEC [2019PI_Master_PopulateOrderList] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@includetestpat,
		@Debug
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblOrderList]
		ORDER BY [OrderDate] DESC 
	END

	-- Create work table that will hold the Meaningful Use results
	CREATE TABLE [#tblMeaningfulUseDetail] 
	(
		[RowId]				[int] IDENTITY(1,1) PRIMARY KEY, -- Primary Key
		[ItemDefinitionUid]	[uniqueidentifier], -- MeaningfulUseItemDefinition.ItemDefinitionUid
		[CategoryName]		[varchar](500) NULL, -- MeaningfulUseCategoryDefinition.CategoryName
		[CategoryNumber]	[int] NULL, -- MeaningfulUseCategoryDefinition.CategoryNumber
		[MeasureNumber]		[int] NULL, -- MeaningfulUseItemDefinition.MeasureNumber 
		[SubMeasureNumber]	[int] NULL, -- MeaningfulUseItemDefinition.SubMeasureNumber
		[PersonUid]			[uniqueidentifier] NULL, -- Unique list of Visit.PatientUid
		[PersonLnFn]		[varchar](150) NULL, -- Patient name
		[ProviderUid]		[varchar](MAX) NULL,
		[ProviderLnFn]		[varchar](150) NULL, 
		[NumeratorValue]	[int] NULL, -- See MeaningfulUseItemDefinition.NumeratorDesc
		[DenominatorValue]	[int] NULL, -- See MeaningfulUseItemDefinition.DenominatorDesc
		[YesNo]				[int] NULL -- See MeaningfulUseItemdefinition.YesNo. Null-NA, 0-No/False, 1-Yes/True.
		unique clustered (RowId)
	) 
 
	CREATE NONCLUSTERED INDEX [MUDetail_ItemDef_PersonUid] ON #tblMeaningfulUseDetail
	(
		ItemDefinitionUid ASC,
		PersonUid ASC
	)
	WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]


	-- Params used in determining if any detail rows were found for given metric
	CREATE TABLE [#tblMetricUidsWithoutDetailRows] 
	(
		[ItemDefinitionUid] [uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED
	)

	-- Create temp table that can be used by measure procs
	CREATE TABLE [#MetricDataTemp]
	(
		[PersonUid] [uniqueidentifier] NOT NULL,
		[HeightRecorded] [int] NULL,
		[WeightRecorded] [int] NULL,
		[BloodPressureRecorded] [int] NULL,
		[LabResultTotalCount] [int] NULL, 
		[LabResultTemplatedCount] [int] NULL,
		[TaskDocGenCount] [int] NULL, 
		[TaskDocGenCompleteCount] [int] NULL, 
		[VisitCount] [int] NULL, 
		[ClinicalSummaryProvidedCount] [int] NULL, 
		[PreventativeFollowupDueCount] [int] NULL, 
		[PreventativeFollowupSentCount] [int] NULL, 
		[SeenByAnotherProviderCount] [int] NULL, 
		[MedicalCheckedCount] [int] NULL, 
		[ReferralCount] [int] NULL, 
		[ReferralClinicalSummaryProvided] [int] NULL
	) 	

	-- Proc based on MUII_Master_DesktopControl
	--  
	-- Calculate Measures
	-- ACI_TRANS_PPHI_1 == Objective 1 == MUII Core Measure 9
	-- Must attest yes

	-- ACI_TRANS_EP_1 == Objective 4 == MUII Core Measure 2, Sub Measure NULL; ItemDefinitionUid : F3A49E2B-E4FF-4D78-A3D5-EEA12A5FBF58
	EXEC [2020PI_E-Prescribing_1_NonControlled] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2020PI_E-Prescribing_2_Controlled] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2020PI_E-Prescribing_3_PDMP] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

--Removed for 2020 Medicare PI Report
	--EXEC [2019PI_E-Prescribing_4_VerifyOpioidAgreement] @ProviderUid,
	--	@ProviderBilling,
	--	@RptTimespan_StartDate,
	--	@RptTimespan_EndDate,
	--	@ReportMode,
	--	@Debug  -- DONE

	EXEC [2020PI_HealthInformationExchange_1_Sending] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2020PI_HealthInformationExchange_2_Receiving] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2020PI_ProviderToPatientExchange] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	-- Drop temp tables that are used by measure procs
	BEGIN TRY
		DROP TABLE [#tblVisitList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#tblPatientList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#tblProviderList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#MetricDataTemp]
	END TRY 
	BEGIN CATCH
	END CATCH

	-- For measures that do not have any detail rows, we need to insert a row, so it will be included in the RDL report.
	DECLARE @NumDetailRows [int]
	SET @NumDetailRows = (SELECT COUNT(*) FROM [#tblMetricUidsWithoutDetailRows])
	IF (@NumDetailRows > 0)
	BEGIN
		INSERT INTO [#tblMeaningfulUseDetail] ([ItemDefinitionUid],
			[CategoryNumber],
			[CategoryName],
			[MeasureNumber],
			[SubMeasureNumber],
			[PersonUid],
			[PersonLnFn],
			[ProviderUid],
			[ProviderLnFn],
			[NumeratorValue],
			[DenominatorValue],
			[YesNo]
		)
			SELECT NoData.[ItemDefinitionUid] AS [ItemDefinitionUid]
			,(
				select mucd.[CategoryNumber] 
				from [MeaningfulUseItemDefinition] AS muid with(nolock)
					inner join [MeaningfulUseCategoryDefinition] AS mucd with(nolock) on muid.[CategoryUid] = mucd.[CategoryUid]
				where muid.[ItemDefinitionUid] = NoData.[ItemDefinitionUid]
			) AS [CategoryNumber]

			,(
				select mucd.CategoryName
				from [MeaningfulUseItemDefinition] AS muid with(nolock)
					inner join [MeaningfulUseCategoryDefinition] AS mucd with(nolock) on muid.[CategoryUid] = mucd.[CategoryUid]
				where muid.[ItemDefinitionUid] = NoData.[ItemDefinitionUid]
			) AS [CategoryName]

			,(
				select muid.[MeasureNumber]
				from [MeaningfulUseItemDefinition] AS muid with(nolock)
					inner join [MeaningfulUseCategoryDefinition] AS mucd with(nolock) on muid.[CategoryUid] = mucd.[CategoryUid]
				where muid.[ItemDefinitionUid] = NoData.[ItemDefinitionUid]
			) AS [MeasureNumber] 

			,(
				select muid.[SubMeasureNumber] 
				from [MeaningfulUseItemDefinition] AS muid with(nolock)
					inner join [MeaningfulUseCategoryDefinition] AS mucd with(nolock) on muid.[CategoryUid] = mucd.[CategoryUid]
				where muid.[ItemDefinitionUid] = NoData.[ItemDefinitionUid]
			) AS [SubMeasureNumber] 

			,NULL AS [PersonUid] 
			,'N / A' AS [PersonLnFn]
			,NULL AS [ProviderUid] 
			,'' AS [ProviderLnFn]
			,0 AS [NumeratorValue]
			,0 AS [DenominatorValue]
			,0 AS [YesNo]
		FROM [#tblMetricUidsWithoutDetailRows] AS [NoData] 
	END

	--
	-- For measures that are Yes/No (Must attest Yes), insert a detail row that will be included in the RDL report
	--

	-- ACI_TRANS_PPHI_1 == Objective 1 == MUII Core Measure 9
	DECLARE @ItemDefinitionUid [uniqueidentifier] = '1D8DEE46-CB1A-45DD-B0FF-FE04DDBD1310' 
	EXEC [MUI_Master_Report_InsertAttestMeasureDetail] @ItemDefinitionUid, @ReportMode,	@Debug

	-- Pick 2 registries
	SET @ItemDefinitionUid = 'CC4FF4BA-CA32-41F7-A157-5426E59C81AE' 
	EXEC [MUI_Master_Report_InsertAttestMeasureDetail] @ItemDefinitionUid, @ReportMode, @Debug

	-- Define table that will be returned to caller
	DECLARE @tblMeaingfulUseSummaryCoreAndMenuSet TABLE
	(
		[RowId]             [int] IDENTITY(1,1) PRIMARY KEY,
		[ItemDefinitionUid] [uniqueidentifier],
		[CategoryNumber]    [int] NULL,
		[CategoryName]      [varchar](100) NULL,
		[MeasureNumber]     [int] NULL, 
		[SubMeasureNumber]  [int] NULL,
		[MeasureDesc]       [varchar](500) NULL,
		[DenominatorDesc]   [varchar](250) NULL,
		[DenominatorValue]  [int] NULL,
		[NumeratorDesc]     [varchar](250) NULL,
		[NumeratorValue]    [int] NULL,
		[YesNo]     [varchar](50)  NULL,
		[CurrentValue]	  [varchar](25)  NULL,
		[GoalDesc]          [varchar](250) NULL,
		[GoalValue]         [varchar](10)  NULL,
		[MetGoal]           [bit] NULL, 
		[ProviderUid]       [varchar](max) NULL,
		[ProviderLnFn]      [varchar](150) NULL,       
		unique clustered  ([RowId])
	) 

	-- Determine if there are any MU detail rows to base metrics against
	-- Walk through list of defined Meaningful Use metrics and popluate @tblMeaingfulUseSummaryCoreAndMenuSet 
	DECLARE @CategoryUid [uniqueidentifier]
		, @CategoryNumber [int]
		, @CategoryName [varchar](100)
		, @MeasureNumber [int]
		, @SubMeasureNumber [int]
		, @MeasureDesc [varchar](500)
		, @ExclusionDesc [varchar](250)
		, @DenominatorDesc [varchar](250)
		, @NumeratorDesc [varchar](250)
		, @YesNo [varchar](50)
		, @GoalDesc [varchar](250)
		, @GoalValue [decimal](5, 2)
		, @DenominatorSumValue [int]
		, @NumeratorSumValue [int]
		, @CurValue [varchar](25)
		, @MetGoal [bit]    
        
    --
    -- Populate table that will be returned to caller
	DECLARE cursor_MU_Definitions CURSOR FAST_FORWARD FOR 
		SELECT muid.[ItemDefinitionUid]
			, muid.[CategoryUid]
			, mucd.[CategoryNumber]
			, mucd.[CategoryName]
			, muid.[MeasureNumber]
			, muid.[SubMeasureNumber]
			, muid.[MeasureDesc]
			, muid.[ExclusionDesc]
			, muid.[DenominatorDesc]
			, muid.[NumeratorDesc]
			, muid.[YesNo]
			, muid.[GoalDesc]
			, muid.[GoalValue]
		FROM [MeaningfulUseItemDefinition] AS muid with(nolock)
			INNER JOIN [MeaningfulUseCategoryDefinition] AS mucd with(nolock) ON muid.[CategoryUid] = mucd.[CategoryUid]
/*Replace w/new StageUid*/		WHERE muid.[StageUid] = 'E35CB2B2-DE24-4C20-B139-91EBEF6B19A8'   -- 2020 PI
		ORDER BY mucd.[CategoryName]
			, mucd.[CategoryNumber]
			, muid.[MeasureNumber]
    --
    OPEN cursor_MU_Definitions
    --
	FETCH NEXT FROM cursor_MU_Definitions 
		INTO @ItemDefinitionUid
			, @CategoryUid
			, @CategoryNumber
			, @CategoryName
			, @MeasureNumber
			, @SubMeasureNumber
			, @MeasureDesc
			, @ExclusionDesc
			, @DenominatorDesc
			, @NumeratorDesc
			, @YesNo
			, @GoalDesc
			, @GoalValue 
    --
   -- Make sure we have a valid cursor row
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @DenominatorSumValue = 0
		SET @NumeratorSumValue = 0
		SET @CurValue = '' 
		SET @MetGoal = 0 
		SET @NumDetailRows = 0
		
		-- Check if current MU metric has a numerator and denominator
		IF @YesNo IS NULL
		BEGIN
			-- Make sure we have some data for current metric
			SET @NumDetailRows = (SELECT COUNT(*)
								  FROM [#tblMeaningfulUseDetail]
								  WHERE [ItemDefinitionUid] = @ItemDefinitionUid
								 )
			IF (@NumDetailRows > 0)
			BEGIN
				-- Current MU metric has a numerator and demoninator
				SELECT  @DenominatorSumValue = SUM(mud.[DenominatorValue])
					, @NumeratorSumValue   = SUM(mud.[NumeratorValue]) 
				FROM     [#tblMeaningfulUseDetail] AS mud
				WHERE    mud.[ItemDefinitionUid] = @ItemDefinitionUid
				GROUP BY mud.[ItemDefinitionUid] 
			END    
           
			IF @DenominatorSumValue <= 0
			BEGIN
				SET @CurValue = 'N/A' 
			END 
			ELSE IF @NumeratorSumValue <= 0
			BEGIN 
				SET @CurValue = '0.00%' 
			END 
			ELSE 
			BEGIN 
				-- Calculate current MU metric value
				SET @CurValue = CONVERT(VARCHAR(10), CONVERT(DECIMAL(8,2), (CONVERT(DECIMAL(8,2), @NumeratorSumValue) / CONVERT(DECIMAL(8,2), @DenominatorSumValue)) * 100)) + '%'
	                  
				-- Determine if goal is satisfied
				IF CONVERT(DECIMAL(8,2), (CONVERT(DECIMAL(8,2), @NumeratorSumValue) / CONVERT(DECIMAL(8,2), @DenominatorSumValue)) * 100) > @GoalValue
				BEGIN
					SET @MetGoal = 1
				END 
			END 
             
			-- Insert MU summary row
			INSERT INTO @tblMeaingfulUseSummaryCoreAndMenuSet ([ItemDefinitionUid]
				, [CategoryNumber]
				, [CategoryName]
				, [MeasureNumber]
				, [SubMeasureNumber]
				, [MeasureDesc]
				, [DenominatorDesc]
				, [DenominatorValue]
				, [NumeratorDesc]
				, [NumeratorValue]
				, [YesNo]
				, [CurrentValue]
				, [GoalDesc]
				, [GoalValue]
				, [MetGoal]
				, [ProviderUid]
				, [ProviderLnFn]
			)   
			VALUES (@ItemDefinitionUid
				, @CategoryNumber
				, @CategoryName
				, @MeasureNumber
				, @SubMeasureNumber
				, @MeasureDesc
				, @DenominatorDesc
				, @DenominatorSumValue
				, @NumeratorDesc
				, @NumeratorSumValue
				, @YesNo
				, @CurValue
				, @GoalDesc
				, CONVERT([varchar](10), @GoalValue)
				, @MetGoal
				, null
				, null
			)  
		END 
		ELSE 
		BEGIN
			-- Current MU metric is YES/NO.  
			INSERT INTO @tblMeaingfulUseSummaryCoreAndMenuSet([ItemDefinitionUid]
				, [CategoryNumber]
				, [CategoryName]
				, [MeasureNumber]
				, [SubMeasureNumber]
				, [MeasureDesc]
				, [DenominatorDesc]
				, [DenominatorValue]
				, [NumeratorDesc]
				, [NumeratorValue]
				, [YesNo]
				, [CurrentValue]
				, [GoalDesc]
				, [GoalValue]
				, [MetGoal]
				, [ProviderUid]
				, [ProviderLnFn]
			)  
			VALUES (@ItemDefinitionUid
				, @CategoryNumber
				, @CategoryName
				, @MeasureNumber
				, @SubMeasureNumber
				, @MeasureDesc
				, @DenominatorDesc
				, null
				, @NumeratorDesc
				, null
				, @YesNo
				, null
				, @GoalDesc
				, null
				, null
				, null
				, null
			)  
		END
		-- 
		-- Get next cursor_MU_Definitions row
		FETCH NEXT FROM cursor_MU_Definitions INTO @ItemDefinitionUid
			, @CategoryUid
			, @CategoryNumber
			, @CategoryName
			, @MeasureNumber
			, @SubMeasureNumber
			, @MeasureDesc
			, @ExclusionDesc
			, @DenominatorDesc
			, @NumeratorDesc
			, @YesNo
			, @GoalDesc
			, @GoalValue 
    END
    --
    -- Close and Deallocate cursor
    CLOSE cursor_MU_Definitions
    DEALLOCATE cursor_MU_Definitions

	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CUS_MeaningfulUseDetail]') AND type in (N'U'))
	BEGIN
	CREATE TABLE [dbo].[CUS_MeaningfulUseDetail](
		[MeaningfulUseDetailUid] [uniqueidentifier] NOT NULL,
		[ReportInstanceUid] [uniqueidentifier] NOT NULL,
		[ItemDefinitionUid] [uniqueidentifier] NULL,
		[CategoryName] [varchar](500) NULL,
		[CategoryNumber] [int] NULL,
		[MeasureNumber] [int] NULL,
		[SubMeasureNumber] [int] NULL,
		[PersonUid] [uniqueidentifier] NULL,
		[PersonLnFn] [varchar](150) NULL,
		[ProviderUid] [varchar](max) NULL,
		[ProviderLnFn] [varchar](150) NULL,
		[ProviderNPI] [varchar](250) NULL,
		[NumeratorValue] [int] NULL,
		[DenominatorValue] [int] NULL,
		[YesNo] [int] NULL,
		[ObjectiveDesc] [varchar](500) NULL,
		[MeasureDesc] [varchar](600) NOT NULL,
		[MeasureDetailDesc] [varchar](600) NULL,
		[ExclusionDesc] [varchar](600) NULL,
		[DenominatorDesc] [varchar](500) NULL,
		[NumeratorDesc] [varchar](500) NULL,
		[GoalDesc] [varchar](250) NULL,
		[LastModifiedDate] [datetime] NOT NULL,
	 CONSTRAINT [PK_CUS_MeaningfulUseDetail] PRIMARY KEY CLUSTERED 
	(
		[MeaningfulUseDetailUid] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
	END

	IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CUS_MeaningfulUseDetail]') AND name = N'IX_CUS_MeaningfulUseDetail')
		CREATE NONCLUSTERED INDEX [IX_CUS_MeaningfulUseDetail] ON [dbo].[CUS_MeaningfulUseDetail]
		(
			[ReportInstanceUid] ASC,
			[ItemDefinitionUid] ASC,
			[PersonUid] ASC
		)
		INCLUDE ( 	[CategoryName],
			[CategoryNumber],
			[MeasureNumber],
			[NumeratorValue],
			[DenominatorValue],
			[ExclusionDesc],
			[DenominatorDesc],
			[SubMeasureNumber],
			[PersonLnFn],
			[ProviderUid],
			[ProviderLnFn],
			[NumeratorDesc],
			[GoalDesc],
			[YesNo],
			[ObjectiveDesc],
			[MeasureDesc],
			[MeasureDetailDesc],
			[MeaningfulUseDetailUid],
			[ProviderNPI],
			[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF_CUS_MeaningfulUseDetail_MeaningfulUseDetailUid]') AND type = 'D')
	BEGIN
		ALTER TABLE [dbo].[CUS_MeaningfulUseDetail] ADD  CONSTRAINT [DF_CUS_MeaningfulUseDetail_MeaningfulUseDetailUid]  DEFAULT (newid()) FOR [MeaningfulUseDetailUid]
	END

	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF_CUS_MeaningfulUseDetail_LastModifiedDate]') AND type = 'D')
	BEGIN
		ALTER TABLE [dbo].[CUS_MeaningfulUseDetail] ADD  CONSTRAINT [DF_CUS_MeaningfulUseDetail_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
	END

	EXEC MIPS_2018_Master_Report_DeleteReportInstance @ReportInstanceUid
	--
	-- Return detail table to caller
	--
	INSERT [CUS_MeaningfulUseDetail](
		[ReportInstanceUid],
		[ItemDefinitionUid],
		[CategoryName],
		[CategoryNumber],
		[MeasureNumber],
		[SubMeasureNumber],
		[PersonUid],
		[PersonLnFn],
		[ProviderUid],
		[ProviderLnFn],
		[ProviderNPI],
		[NumeratorValue],
		[DenominatorValue],
		[YesNo],
		[ObjectiveDesc],
		[MeasureDesc],
		[MeasureDetailDesc],
		[ExclusionDesc],
		[DenominatorDesc],
		[NumeratorDesc],
		[GoalDesc]
	)
	SELECT @ReportInstanceUid AS [ReportInstanceUid],
		t.[ItemDefinitionUid],
		COALESCE(t.[CategoryName], mucd.[CategoryName]) AS [CategoryName],
		t.[CategoryNumber],
		t.[MeasureNumber],
		t.[SubMeasureNumber],
		t.[PersonUid],
		t.[PersonLnFn],
		[ProviderUid],
		t.[ProviderLnFn],
		@ProviderNPI AS [ProviderNPI],
		t.[NumeratorValue],
		t.[DenominatorValue],
		t.[YesNo],
		MUID.[ObjectiveDesc],
		MUID.[MeasureDesc],
		MUID.[MeasureDetailDesc],
		MUID.[ExclusionDesc],
		MUID.[DenominatorDesc],
		MUID.[NumeratorDesc],
		MUID.[GoalDesc]
	FROM [#tblMeaningfulUseDetail] AS t
		INNER JOIN [MeaningfulUseItemDefinition] AS MUID with(nolock) ON MUID.[ItemDefinitionUid] = t.[ItemDefinitionUid]
		INNER JOIN [MeaningfulUseCategoryDefinition] AS mucd with (nolock) ON MUID.[CategoryUid] = mucd.[CategoryUid]
	ORDER BY [CategoryName] ASC,
		[CategoryNumber] ASC,
		[MeasureNumber] ASC,
		[SubMeasureNumber] ASC,
		[NumeratorValue] DESC,
		[DenominatorValue] DESC,
		[PersonLnFn] ASC 
	
	BEGIN TRY
		DROP TABLE [#tblMeaningfulUseDetail]
	END TRY
	BEGIN CATCH
	END CATCH
	
	-- Return Meaningful Use results to caller
	SELECT [RowId]
		, [ItemDefinitionUid]
		, [CategoryNumber]
		, [CategoryName]
		, [MeasureNumber]
		, [SubMeasureNumber]
		, [MeasureDesc]
		, [DenominatorDesc]
		, [DenominatorValue]
		, [NumeratorDesc]
		, [NumeratorValue]
		, [YesNo]
		, [CurrentValue]
		, [GoalDesc]
		, [GoalValue]
		, [MetGoal]
		, [ProviderUid]
		, [ProviderLnFn]
	FROM @tblMeaingfulUseSummaryCoreAndMenuSet    
	ORDER BY [CategoryNumber] ASC
		, [MeasureNumber] ASC
		, [SubMeasureNumber] ASC 
	
	IF (@Debug <> 0)
	BEGIN
		SELECT 'GOOD BYE'
	END 
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2021PI_E-Prescribing_1_NonControlled]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2021PI_E-Prescribing_1_NonControlled] AS' 
END
GO
ALTER PROC [dbo].[2021PI_E-Prescribing_1_NonControlled]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

	IF (@Debug = 1)
	BEGIN
		SELECT '2021PI_E-Prescribing_1_NonControlled-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = 'FBCC67CC-4400-4D2A-9499-22A189B9E797',
		@RxStatusTransmittedSuccessfully [uniqueidentifier] = 'B1F7EFAF-D56D-4BAD-AE1F-8205E1D00B58', 
		@RxStatusQueuedForTransmission   [uniqueidentifier] = '0605B6F6-2FE4-49CB-B868-9DF448AB3E01'

	TRUNCATE TABLE #MetricDataTemp

	-- Initialize work table
	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
	SELECT @ItemDefinitionUid AS [ItemDefinitionUid]
		, med.[PersonUid]
		, COUNT(sts.[eRxStatusUid]) AS [NumeratorValue]                        
		, COUNT(med.[MedicationSIGUid]) AS [DenominatorValue]
		, null AS [YesNo]
	FROM   [#tblMedicationList] AS med
		LEFT JOIN [ListeRxStatus] AS sts WITH(NOLOCK) ON  med.[eRxStatusUid] = sts.[eRxStatusUid]
		 AND (sts.[eRxStatusUid] IN(@RxStatusTransmittedSuccessfully, @RxStatusQueuedForTransmission))
	WHERE med.[Dispensable] = 1
		AND med.[IsSampleGiven] = 0
		AND med.[IsAdministered] = 0
		AND med.[reffederaldeaclasscode] = 0
		AND [SIGDetailCount] = 1
	GROUP BY med.[PersonUid]
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2021PI_E-Prescribing_1_NonControlled -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2021PI_E-Prescribing_2_Controlled]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2021PI_E-Prescribing_2_Controlled] AS' 
END
GO
ALTER PROC [dbo].[2021PI_E-Prescribing_2_Controlled]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

	IF (@Debug = 1)
	BEGIN
		SELECT '2021PI_E-Prescribing_2_Controlled-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = '391DBB1F-700C-4595-B9DD-4423068AEC14',
		@RxStatusTransmittedSuccessfully [uniqueidentifier] = 'B1F7EFAF-D56D-4BAD-AE1F-8205E1D00B58', 
		@RxStatusQueuedForTransmission   [uniqueidentifier] = '0605B6F6-2FE4-49CB-B868-9DF448AB3E01'

	TRUNCATE TABLE #MetricDataTemp

	-- Initialize work table
	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
	SELECT @ItemDefinitionUid AS [ItemDefinitionUid]
		, med.[PersonUid]
		, COUNT(sts.[eRxStatusUid]) AS [NumeratorValue]                        
		, COUNT(med.[MedicationSIGUid]) AS [DenominatorValue]
		, null AS [YesNo]
	FROM   [#tblMedicationList] AS med
		LEFT JOIN [ListeRxStatus] AS sts WITH(NOLOCK) ON  med.[eRxStatusUid] = sts.[eRxStatusUid]
		 AND (sts.[eRxStatusUid] IN(@RxStatusTransmittedSuccessfully, @RxStatusQueuedForTransmission))
	WHERE med.[Dispensable] = 1
		AND med.[IsSampleGiven] = 0
		AND med.[IsAdministered] = 0
		AND med.[reffederaldeaclasscode] >= 0
		AND [SIGDetailCount] = 1
	GROUP BY med.[PersonUid]
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2021PI_E-Prescribing_2_Controlled -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2021PI_E-Prescribing_3_PDMP]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2021PI_E-Prescribing_3_PDMP] AS' 
END
GO
ALTER PROC [dbo].[2021PI_E-Prescribing_3_PDMP]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

	IF (@Debug = 1)
	BEGIN
		SELECT '2021PI_E-Prescribing_3_PDMP-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = 'FB4919AB-797F-476B-A59F-7EAF997C5B6F',
		@RxStatusTransmittedSuccessfully [uniqueidentifier] = 'B1F7EFAF-D56D-4BAD-AE1F-8205E1D00B58', 
		@RxStatusQueuedForTransmission   [uniqueidentifier] = '0605B6F6-2FE4-49CB-B868-9DF448AB3E01'

	TRUNCATE TABLE #MetricDataTemp

	--DECLARE @Audit TABLE (PatientUid UNIQUEIDENTIFIER)
	--INSERT INTO @Audit
	--SELECT a.PatientUid
	--FROM [#tblMedicationList] m
	--INNER JOIN Audit a on m.PersonUid = a.PatientUid 
	--	AND a.ChangeDate >= @RptTimespan_StartDate AND a.ChangeDate <= @RptTimespan_EndDate
	--	AND a.Description LIKE 'Appriss RX Report Requested Successfully%' or Description LIKE 'LogiCoy Report requested successfully%'

	-- Initialize work table
	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
	--THIS is not the right query
	--And needs to be changed to what is correct
	SELECT @ItemDefinitionUid AS [ItemDefinitionUid]
		, med.[PersonUid]
		, CASE WHEN a.PatientUid IS NOT NULL THEN 1 ELSE 0 END AS [NumeratorValue]                        
		, CASE WHEN med.PersonUid IS NOT NULL THEN 1 ELSE 0 END AS [DenominatorValue]
		, null AS [YesNo]
	FROM   [#tblMedicationList] AS med
	INNER JOIN [ListeRxStatus] AS sts WITH(NOLOCK) ON  med.[eRxStatusUid] = sts.[eRxStatusUid]
		 AND (sts.[eRxStatusUid] IN(@RxStatusTransmittedSuccessfully, @RxStatusQueuedForTransmission))
	LEFT JOIN cus_PDMP_Pats a on med.PersonUid = a.PatientUid
	WHERE med.[Dispensable] = 1
		AND med.[IsSampleGiven] = 0
		AND med.[IsAdministered] = 0
		AND med.[reffederaldeaclasscode] >= 2
		AND [SIGDetailCount] = 1
	GROUP BY med.[PersonUid], a.PatientUid
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2021PI_E-Prescribing_3_PDMP -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2021PI_HealthInformationExchange_1_Sending]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2021PI_HealthInformationExchange_1_Sending] AS' 
END
GO
ALTER PROC [dbo].[2021PI_HealthInformationExchange_1_Sending]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

	IF (@Debug = 1)
	BEGIN
		SELECT '2021PI_HealthInformationExchange_1_Sending-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

     DECLARE @UTC_RptTimespan_StartDate DATETIME,@UTC_RptTimespan_EndDate DATETIME
      SELECT @UTC_RptTimespan_StartDate = @RptTimespan_StartDate
      SELECT @UTC_RptTimespan_EndDate   = DATEADD(DAY,1,@RptTimespan_EndDate)

      --RecordDisclosureAudit limit range, -1 day from min referral date and +3 days to max referral date
      DECLARE @RecordDisclosureAudit_StartDate DATE,@RecordDisclosureAudit_EndDate DATE
      SELECT @RecordDisclosureAudit_StartDate = DATEADD(DAY,-1,@RptTimespan_StartDate)
      SELECT @RecordDisclosureAudit_EndDate   = DATEADD(DAY,3,@RptTimespan_EndDate)

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = '95BBE181-C523-49F7-8076-5F5146332499'
	DECLARE @ExcludedReferrals TABLE (PatientReferralUid UNIQUEIDENTIFIER)

	INSERT INTO @ExcludedReferrals
	SELECT ViewUid FROM ViewPatientOutboundReferral v
	INNER JOIN ListProviderCareType p WITH(NOLOCK) on v.ProviderCareTypeUid = p.ProviderCareTypeUid AND p.ExcludeFromReferrals = 1

	INSERT INTO @ExcludedReferrals
	SELECT PatientReferralUid FROM PatientReferral WHERE ReferralTrackingStatusUid = 'F7D1B72C-83ED-4D2E-8AB2-2B86F31E8EB2'

      TRUNCATE TABLE #MetricDataTemp

      ;WITH cte_pr AS (
            select pr.*,dbo.UDF_CQMTestPatient (pr.PatientUid) AS TestPatient
            FROM ViewPatientReferralConsultReport pr 
			INNER JOIN #tblVisitList t on pr.VisitUid = t.VisitUid
            LEFT JOIN PatientReferral p WITH(NOLOCK) on pr.PatientReferralUid = p.PatientReferralUid
            LEFT JOIN VisitProcedure vp WITH(NOLOCK) on p.VisitProcedureUid = vp.VisitProcedureUid
            LEFT JOIN ListProcedure lp WITH(NOLOCK) on vp.ProcedureUid = lp.ProcedureUid      
			LEFT JOIN @ExcludedReferrals er on pr.PatientReferralUid = er.PatientReferralUid
            WHERE pr.RefType = 'PatientReferral'
                        AND (pr.ReferredByProviderUid IN (SELECT Element FROM dbo.Split(@ProviderUid, ',')) OR @ProviderUid IS NULL)
                        AND pr.ReferralDate >= @UTC_RptTimespan_StartDate AND pr.ReferralDate < @RecordDisclosureAudit_EndDate
                        AND (lp.ProcedureCodeTypeUid IS NULL OR lp.ProcedureCodeTypeUid NOT IN ('1E605C00-13F0-4B95-AEDB-7AA2E30A8BED'))
						AND er.PatientReferralUid IS NULL
      ),
      cte_rda AS (
            SELECT [DisclosureDate] ,
                  [DisclosureType] ,
                  [PatientUid] ,
                  rda.[PatientReferralUid] ,
                  [AttachmentGroupUid] ,
                  rda.[VisitUid] ,
                  [IsPortal],
                  [DisclosureMethod],
                  [Status],
                  [DisclosurePurpose]
            FROM RecordDisclosureAudit rda WITH(NOLOCK)
			--LEFT JOIN PatientReferral pr on rda.PatientReferralUid = pr.PatientReferralUid AND pr.ReferredByProviderUid = @ProviderUid
            WHERE DisclosureDate >= @RecordDisclosureAudit_StartDate
                  AND DisclosureType in (1,    -- Complete Chart
                                                      2,    -- Clinical Summary
                                                      11)  -- ContinuityOfCareDocument
                  AND DisclosureMethod IN (1,5,6,7)
                  AND DisclosurePurpose <> 'Released to Patient' --2016.02.23 dmg
                  AND [Status] > 0
      )
      INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
            SELECT @ItemDefinitionUid AS ItemDefinitionUid
                        ,r.PatientUid
                         ,COUNT(distinct CASE WHEN  rda.DisclosureType IS NOT NULL and rda.status = 4 THEN rda.PatientReferralUid
                              ELSE NULL END) AS NumeratorValue            
						,COUNT(distinct CASE WHEN r.PatientReferralUid is not null  and (r.ReferralStatus in ('Initiated', 'Appointment Confirmed')) THEN r.PatientReferralUid
                             ELSE NULL END) AS DenominatorValue 
                        ,null AS YesNo
            FROM cte_pr r 
           LEFT JOIN cte_rda rda ON r.PatientUid=rda.patientuid AND
                                    (
                                          r.VisitUid=rda.VisitUid 
                                          OR r.PatientReferralUid=rda.PatientReferralUid 
                                          OR r.AttachmentGroupUid=rda.AttachmentGroupUid
                                          --OR DATEDIFF(day,r.ReferralDate,rda.DisclosureDate) >= -1
                                    )
            WHERE r.TestPatient = 0
            GROUP BY r.PatientUid
            
      UPDATE #tblMeaningfulUseDetail
      SET NumeratorValue = 
            CASE 
                  WHEN NumeratorValue > DenominatorValue THEN DenominatorValue 
                  ELSE NumeratorValue 
            END
	  WHERE ItemDefinitionUid = @ItemDefinitionUid
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2021PI_HealthInformationExchange_1_Sending -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2021PI_HealthInformationExchange_2_Receiving]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2021PI_HealthInformationExchange_2_Receiving] AS' 
END
GO
ALTER PROC [dbo].[2021PI_HealthInformationExchange_2_Receiving]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

	IF (@Debug = 1)
	BEGIN
		SELECT '2021PI_HealthInformationExchange_2_Receiving-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

	DECLARE @UTC_RptTimespan_StartDate DATETIME,@UTC_RptTimespan_EndDate DATETIME
	SELECT @UTC_RptTimespan_StartDate = @RptTimespan_StartDate, @UTC_RptTimespan_EndDate = @RptTimespan_EndDate
	SELECT @UTC_RptTimespan_StartDate = '01/01/'+CONVERT(VARCHAR(4),DATEPART(YEAR,@UTC_RptTimespan_StartDate))

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = 'D01D1E71-45F3-403A-AB18-E2FB3B05D815'

	DECLARE @InitiatedReferrals TABLE (PatientReferralUid UNIQUEIDENTIFIER)
	INSERT INTO @InitiatedReferrals
	SELECT DISTINCT PatientReferralUid 
	FROM PatientReferralHistory 
	WHERE ReferralTrackingStatusUid IN ('0673DB25-454C-44D8-B83F-AFCF97879AAD','3B180FEC-FAE0-4850-AE16-6172CC31F7A7')

	TRUNCATE TABLE #MetricDataTemp

	;WITH cte_Ref AS (
	SELECT vfp.PersonUid AS PatUid
			, rag.VisitUid AS Uid
			, COALESCE(a.AttachmentUid, ag.AttachmentGroupUid) AS AttUid
			, COALESCE(a.FileDate, ag.LastModifiedDate) AS AttDate
			, aa.HasClinicalDocument AS NumID
			, aa.MedicationAllergiesReconciledDate
			, aa.MedicationsReconciledDate
			, aa.ProblemsReconciledDate
			, a.AttachmentTypeUid
			, latDM.ExternalID AS AttachmentTypeID
	FROM #tblPatientList vfp
	INNER JOIN RelAttachmentGroup rag on vfp.PersonUid = rag.PersonUid
	INNER JOIN Visit v on rag.VisitUid = v.VisitUid AND (v.VisitDate >= @RptTimespan_StartDate AND v.VisitDate <= @RptTimespan_EndDate)
	INNER JOIN #tblProviderList prov on v.ProviderUid = prov.ProviderUid
	LEFT JOIN Attachment a on rag.AttachmentGroupUid = a.AttachmentGroupUid
	LEFT JOIN ListAttachmentType latDM on a.AttachmentTypeUid = latDM.AttachmentTypeUid
	LEFT JOIN AttachmentGroup ag on rag.AttachmentGroupUid = ag.AttachmentGroupUid
	INNER JOIN ListAttachmentType lat on (a.AttachmentTypeUid = lat.AttachmentTypeUid OR ag.AttachmentTypeUid = lat.AttachmentTypeUid) AND (lat.AttachmentTypeUid = 'B71B8F20-7B7D-4A7C-9E75-05811A0791AD')
	LEFT JOIN MessageAA aa on rag.RelAttachmentGroupUid = aa.RelAttachmentGroupUid --AND aa.SummaryOfCareReconciledDate IS NOT NULL
	LEFT JOIN Message m on aa.MessageUid = m.MessageUid

	UNION ALL

	SELECT vfp.PersonUid AS PatUid
			, pr.PatientReferralUid AS Uid
			, aa.MessageUid AS AttUid
			, pr.CreatedDate AS AttDate
			, aa.HasClinicalDocument AS NumID
			, aa.MedicationAllergiesReconciledDate
			, aa.MedicationsReconciledDate
			, aa.ProblemsReconciledDate
			, att.AttachmentTypeUid
			, lat.ExternalID AS AttachmentTypeID
	FROM #tblPatientList vfp
	INNER JOIN RelAttachmentGroup r ON vfp.PersonUid = r.PersonUid
	INNER JOIN MessageAA aa ON aa.RelAttachmentGroupUid = r.RelAttachmentGroupUid --AND aa.ElectronicSummaryOfCareReceived = 1
	LEFT JOIN Attachment att on r.AttachmentGroupUid = att.AttachmentGroupUid
	LEFT JOIN ListAttachmentType lat on att.AttachmentTypeUid = lat.AttachmentTypeUid
	INNER JOIN PatientReferral pr on r.PatientReferralUid = pr.PatientReferralUid 
			AND (pr.CreatedDate >= @RptTimespan_StartDate AND pr.CreatedDate <= @RptTimespan_EndDate)
			AND pr.ReferralTrackingStatusUid <> '3B180FEC-FAE0-4850-AE16-6172CC31F7A7'
	INNER JOIN PatientProviderRelationship ppr on pr.PatientProviderRelationshipUid = ppr.PatientProviderRelationshipUid
	INNER JOIN #tblProviderList prov on pr.ReferredByProviderUid = prov.ProviderUid
	INNER JOIN @InitiatedReferrals ir on pr.PatientReferralUid = ir.PatientReferralUid
	)


	--SELECT * FROM cte_Ref
	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
		SELECT @ItemDefinitionUid AS ItemDefinitionUid
				,PatUid
				,COUNT(distinct CASE WHEN MedicationAllergiesReconciledDate IS NOT NULL 
						AND MedicationsReconciledDate IS NOT NULL
						AND ProblemsReconciledDate IS NOT NULL
							THEN Uid
						WHEN AttachmentTypeUid = '91293E86-6AA1-4B30-AA00-7DDD42135D64' THEN Uid
						WHEN AttachmentTypeID = 'DMail' THEN Uid
							ELSE NULL END) AS NumeratorValue
				,COUNT(DISTINCT Uid) AS DenominatorValue
				,NULL AS YesNo
		FROM cte_Ref
		GROUP BY PatUid


	IF EXISTS (
		SELECT TOP 1 *
		FROM #tblMeaningfulUseDetail
		WHERE [ItemDefinitionUid] = @ItemDefinitionUid
	)
    BEGIN
	    UPDATE [#tblMeaningfulUseDetail]
		SET [NumeratorValue] = CASE WHEN [NumeratorValue] > [DenominatorValue] THEN [DenominatorValue] ELSE [NumeratorValue] END
    END
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2021PI_HealthInformationExchange_2_Receiving -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2021PI_ProviderToPatientExchange]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2021PI_ProviderToPatientExchange] AS' 
END
GO
ALTER PROC [dbo].[2021PI_ProviderToPatientExchange]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

	IF (@Debug = 1)
	BEGIN
		SELECT '2021PI_ProviderToPatientExchange-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = '63BD9815-C771-4A13-B40B-0F1E8DE4035C'

	TRUNCATE TABLE [#MetricDataTemp]

	-- Populate Denominator Value
	INSERT INTO [#tblMeaningfulUseDetail] ([ItemDefinitionUid]
		, [PersonUid]
		, [NumeratorValue]
		, [DenominatorValue]
		, [YesNo]
	)
	SELECT @ItemDefinitionUid AS [ItemDefinitionUid]
		, p.PersonUid
		, COUNT(DISTINCT CASE WHEN p.[HasPortalAccount] <> 0 THEN p.[PersonUid]
				ELSE NULL END)AS [NumeratorValue]           
		, COUNT(DISTINCT p.[PersonUid]) AS [DenominatorValue]
		, null AS [YesNo]
	FROM  [#tblPatientList] AS p
	WHERE (p.[IsEM] <> 0 OR p.IsVP <> 0)
	GROUP BY p.[PersonUid]
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2021PI_ProviderToPatientExchange -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2021PI_Master_DesktopControl]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2021PI_Master_DesktopControl] AS' 
END
GO
ALTER PROC [dbo].[2021PI_Master_DesktopControl]
(
	@ProviderUid			[varchar](max) = NULL,  
	@RptTimespan_StartDate	[date],
	@RptTimespan_EndDate	[date],
	@ProviderBilling		[bit] = 1,
	@ProviderRendering		[bit] = 0,
	@Debug					[int] = 0,
	@includetestpat			[bit] = 0,
	@ServiceSiteUID			[varchar](max) = null, 
	@FinancialCenterUID		[varchar](max) = null
)
AS
BEGIN

SET NOCOUNT ON;
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;
	--
	-- Calling syntax :    
	--
	--

	IF (@RptTimespan_StartDate IS NULL)
	BEGIN
		SET @RptTimespan_StartDate = '01-01-1900'
	END 
	IF (@RptTimespan_EndDate IS NULL)
	BEGIN
		SET @RptTimespan_EndDate = GETDATE()
	END 

	CREATE TABLE [#tblProviderList]
	(
		[ProviderUid] [uniqueidentifier] NOT NULL primary key clustered
	)
	 	 
	DECLARE @HasProviderUid [bit] = 0
	EXEC [2019PI_Master_PopulateProviderList] @ProviderUid, @HasProviderUid out

	-- Measure stored procedure flag indicating Meaningful Use data will be used for a report
	DECLARE @ReportMode [bit] = 0

	IF NOT EXISTS (SELECT 1 FROM sysobjects WHERE Name='cus_PDMP_Pats' and XType='U')
		EXEC FillPDMPPatsTable
		

	CREATE TABLE [#tblVisitList]
	(
		[VisitUid]							[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[VisitDate]							[date]         NOT NULL,
		[PatientUid]						[uniqueidentifier] NOT NULL,
		[TestPat]					   		[bit],
		[IsEM]								[bit],
		[IsVP]								[bit],
		[ProviderUid]						[varchar](max),
		[RenderingProviderUid]				[varchar](max),
		[LastSavedByUid]					[uniqueidentifier],
		[SavedByBillingProvider]			[bit],
		[SavedByRenderingProvider]			[bit],
		[TransitionOfCare]					[bit],
		[MedicationChecked]					[bit],
		[DrugAllergyChecked]				[bit],
		[ProblemChecked]					[bit],
		[SummaryProvidedToPatient]			[date],
		[PatientDeclinedClinicalSummary]	[bit],
		[HasEduForm]						[bit],
		[HasPortalAccount]					[bit],
		[PrintedDate]						[date]
	)
	--
	-- PopulateVisitList
	EXEC [2019PI_Master_PopulateVisitList] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@Debug,
		@ServiceSiteUID,
		@FinancialCenterUID
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblVisitList]
		ORDER BY [VisitDate] DESC 
	END

	CREATE TABLE [#tblPatientList] 
	(
		[PersonUid]					[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[PatientLnFn]				[varchar](250),
		[Birthdate]					[date],
		[TestPat]					[bit],
		[IsEM]						[bit],
		[IsVP]						[bit],
		[FullDemographics]			[bit],
		[HasEduForm]				[bit],
		[EduFormPrinted]			[bit],
		[HasPortalAccount]			[bit],
		[PortalPerson]				[uniqueidentifier] NULL,
		[PortalValid]				[date] NULL,
		[PortalExpire]				[date] NULL,
		[SummaryProvidedToPatient]	[bit],
		[TransitionOfCare]			[bit],
		[MedicationChecked]			[bit],
		[SavedByBillingProvider]	[bit],
		[SavedByRenderingProvider]	[bit],
		[YearsOldOrOlder2]			[bit] NULL,
		[YearsOldOrOlder3]			[bit] NULL,
		[YearsOldOrYounger5]		[bit] NULL, 
		[YearsOldOrOlder13]			[bit] NULL,
		[YearsOldOrOlder65]			[bit] NULL
	)
	--
	-- Populate Patient List
	EXEC [2019PI_Master_PopulatePatientList] @ProviderUid, 
			@RptTimespan_StartDate,
			@RptTimespan_EndDate,
			@ProviderBilling,
			@ProviderRendering,
			@Debug

	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblPatientList]
		ORDER BY [PatientLnFn]
	END

	--back fill #tblVisitList with patient specific information
	--delete test patient records from #tblVisitList AND #tblPatientList IF @includetestpat = 0
	EXEC [2019PI_Master_SynchronizeVisitAndPatient] @Debug = @Debug,
		@IncludeTestPatients = @includetestpat

	-- Build list of Medications that are within reporting range
	CREATE TABLE #tblMedicationList
	(
		[MedicationSIGUid]					[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[CreatedDate]						[datetime] NOT NULL,
		[RelVisitMedicationUid]				[uniqueidentifier],
		[PersonUid]							[uniqueidentifier],
		[TestPat]							[bit],
		[LicensedHealthcareProfessional]	[bit] NOT NULL,
		[Dispensable]						[bit] NULL,
		[IsSampleGiven]						[bit] NOT NULL,
		[IsAdministered]					[bit] NOT NULL,
		[reffederaldeaclasscode]			[int] NULL,
		[SIGDetailCount]					[int] NULL,
		[eRxStatusUid]						[uniqueidentifier]
	)
	--
	-- PopulateMedicationList
	EXEC [2019PI_Master_PopulateMedicationList]
		@ProviderUid
		, @ProviderBilling
		, @RptTimespan_StartDate
		, @RptTimespan_EndDate
		, @includetestpat
		, @Debug
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblMedicationList]
		ORDER BY [CreatedDate] DESC 
	END

	-- Build list of Orders that are within reporting range
	CREATE TABLE [#tblOrderList]
	(
		[ObservationOrderUid]				[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[PatientUid]						[uniqueidentifier] NOT NULL,
		[TestPat]					   		[bit],
		[VPUid]								[uniqueidentifier] NULL,
		[CreatedBy]							[uniqueidentifier] NULL,
		[OrderDate]							[datetime]         NOT NULL,
		[ProcedureCodeTypeUid]				[uniqueidentifier] NULL,
		[ProcedureCodeTypeName]				[varchar](500)     NULL,
		[AttachmentTypeUid]					[uniqueidentifier] NULL,
		[AttachmentTypeName]				[varchar](500)	NULL,
		[LicensedHealthcareProfessional]	[bit]			NOT NULL,
		[ImageResultsDirectlyAccessible]	[bit]			NULL,
		[ResultStatusID]					[int]			NULL
	)
	--
	-- PopulateOrderList
	EXEC [2019PI_Master_PopulateOrderList] @ProviderUid
		, @ProviderBilling
		, @RptTimespan_StartDate
		, @RptTimespan_EndDate
		, @includetestpat
		, @Debug
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblOrderList]
		ORDER BY [OrderDate] DESC 
	END

	-- Create work table that will hold the Meaningful Use results
	CREATE TABLE [#tblMeaningfulUseDetail] 
	(
		[RowId]               [int] IDENTITY(1,1) PRIMARY KEY,     -- Primary Key
		[ItemDefinitionUid]   [uniqueidentifier],                  -- MeaningfulUseItemDefinition.ItemDefinitionUid   
		[PersonUid]           [uniqueidentifier] NULL,             -- Unique list of Visit.PatientUid
		[NumeratorValue]      [int] NULL,                          -- See MeaningfulUseItemDefinition.NumeratorDesc
		[DenominatorValue]    [int] NULL,                          -- See MeaningfulUseItemDefinition.DenominatorDesc
		[YesNo]               [int] NULL                           -- See MeaningfulUseItemdefinition.YesNo.  Null-NA, 0-No/False, 1-Yes/True.
		unique clustered ([RowId])
	)  

	CREATE NONCLUSTERED INDEX [MUDetail_ItemDef_PersonUid] ON [#tblMeaningfulUseDetail]
	(
		[ItemDefinitionUid] ASC,
		[PersonUid] ASC
	)
	WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

	-- Create temp table that can be used by measure procs
	CREATE TABLE [#MetricDataTemp]
	(
		[PersonUid]							[uniqueidentifier] NOT NULL,
		[HeightRecorded]					[int] NULL,
		[WeightRecorded]					[int] NULL,
		[BloodPressureRecorded]				[int] NULL,
		[LabResultTotalCount]				[int] NULL, 
		[LabResultTemplatedCount]			[int] NULL,
		[TaskDocGenCount]					[int] NULL, 
		[TaskDocGenCompleteCount]			[int] NULL,   
		[VisitCount]						[int] NULL, 
		[ClinicalSummaryProvidedCount]		[int] NULL,  
		[PreventativeFollowupDueCount]		[int] NULL, 
		[PreventativeFollowupSentCount]		[int] NULL,   
		[SeenByAnotherProviderCount]		[int] NULL, 
		[MedicalCheckedCount]				[int] NULL,  
		[ReferralCount]						[int] NULL, 
		[ReferralClinicalSummaryProvided]	[int] NULL
	) 	
	
	-- Proc based on MUII_Master_DesktopControl
	--  
	-- Calculate Measures
	EXEC [2021PI_E-Prescribing_1_NonControlled] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2021PI_E-Prescribing_2_Controlled] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2021PI_E-Prescribing_3_PDMP] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE
		
	EXEC [2021PI_HealthInformationExchange_1_Sending] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2021PI_HealthInformationExchange_2_Receiving] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2021PI_ProviderToPatientExchange] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	-- Drop temp tables that are used by measure procs
	BEGIN TRY
		DROP TABLE [#tblVisitList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#tblPatientList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#tblProviderList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#MetricDataTemp]
	END TRY 
	BEGIN CATCH
	END CATCH

	-- Define table that will be returned to caller
	DECLARE @tblMeaingfulUseSummaryCoreAndMenuSet TABLE
	(
		[RowId]             [int] IDENTITY(1,1) PRIMARY KEY,
		[ItemDefinitionUid] [uniqueidentifier],
		[CategoryNumber]    [int] NULL,
		[CategoryName]      [varchar](100) NULL,
		[MeasureNumber]     [int] NULL, 
		[SubMeasureNumber]  [int] NULL,
		[MeasureDesc]       [varchar](500) NULL,
		[DenominatorDesc]   [varchar](250) NULL,
		[DenominatorValue]  [int] NULL,
		[NumeratorDesc]     [varchar](250) NULL,
		[NumeratorValue]    [int] NULL,
		[YesNo]     [varchar](50)  NULL,
		[CurrentValue]	  [varchar](25)  NULL,
		[GoalDesc]          [varchar](250) NULL,
		[GoalValue]         [varchar](10)  NULL,
		[MetGoal]           [bit] NULL, 
		[ProviderUid]       [varchar](max) NULL,
		[ProviderLnFn]      [varchar](150) NULL,       
		unique clustered  ([RowId])
	) 

	-- Determine if there are any MU detail rows to base metrics against
	DECLARE @NumDetailRows [int]

	-- Walk through list of defined Meaningful Use metrics and popluate @tblMeaingfulUseSummaryCoreAndMenuSet 
	DECLARE @ItemDefinitionUid [uniqueidentifier]
		, @CategoryUid [uniqueidentifier]
		, @CategoryNumber [int]
		, @CategoryName [varchar](100)
		, @MeasureNumber [int]
		, @SubMeasureNumber [int]
		, @MeasureDesc [varchar](500)
		, @ExclusionDesc [varchar](250)
		, @DenominatorDesc [varchar](250)
		, @NumeratorDesc [varchar](250)
		, @YesNo [varchar](50)
		, @GoalDesc [varchar](250)
		, @GoalValue [decimal](5, 2)
		, @DenominatorSumValue [int]
		, @NumeratorSumValue [int]
		, @CurValue [varchar](25)
		, @MetGoal [bit]    
        
    --
    -- Populate table that will be returned to caller
	DECLARE cursor_MU_Definitions CURSOR FAST_FORWARD FOR 
		SELECT muid.[ItemDefinitionUid]
			, muid.[CategoryUid]
			, mucd.[CategoryNumber]
			, mucd.[CategoryName]
			, muid.[MeasureNumber]
			, muid.[SubMeasureNumber]
			, muid.[MeasureDesc]
			, muid.[ExclusionDesc]
			, muid.[DenominatorDesc]
			, muid.[NumeratorDesc]
			, muid.[YesNo]
			, muid.[GoalDesc]
			, muid.[GoalValue]
		FROM [MeaningfulUseItemDefinition] AS muid with(nolock)
			INNER JOIN [MeaningfulUseCategoryDefinition] AS mucd with(nolock) ON muid.[CategoryUid] = mucd.[CategoryUid]
/*Replace w/new StageUid*/		WHERE muid.[StageUid] = 'FF9E6E95-D980-456A-B303-98209637DC4A'   --2021 PI
		ORDER BY mucd.[CategoryName]
			, mucd.[CategoryNumber]
			, muid.[MeasureNumber]
    --
    OPEN cursor_MU_Definitions
    --
	FETCH NEXT FROM cursor_MU_Definitions 
		INTO @ItemDefinitionUid
			, @CategoryUid
			, @CategoryNumber
			, @CategoryName
			, @MeasureNumber
			, @SubMeasureNumber
			, @MeasureDesc
			, @ExclusionDesc
			, @DenominatorDesc
			, @NumeratorDesc
			, @YesNo
			, @GoalDesc
			, @GoalValue 
    --
   -- Make sure we have a valid cursor row
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @DenominatorSumValue = 0
		SET @NumeratorSumValue = 0
		SET @CurValue = '' 
		SET @MetGoal = 0 
		SET @NumDetailRows = 0
		
		-- Check if current MU metric has a numerator and denominator
		IF @YesNo IS NULL
		BEGIN
			-- Make sure we have some data for current metric
			SET @NumDetailRows = (SELECT COUNT(*)
								  FROM [#tblMeaningfulUseDetail]
								  WHERE [ItemDefinitionUid] = @ItemDefinitionUid
								 )
			IF (@NumDetailRows > 0)
			BEGIN
				-- Current MU metric has a numerator and demoninator
				SELECT  @DenominatorSumValue = SUM(mud.[DenominatorValue])
					, @NumeratorSumValue   = SUM(mud.[NumeratorValue]) 
				FROM     [#tblMeaningfulUseDetail] AS mud
				WHERE    mud.[ItemDefinitionUid] = @ItemDefinitionUid
				GROUP BY mud.[ItemDefinitionUid] 
			END    
           
			IF @DenominatorSumValue <= 0
			BEGIN
				SET @CurValue = 'N/A' 
			END 
			ELSE IF @NumeratorSumValue <= 0
			BEGIN 
				SET @CurValue = '0.00%' 
			END 
			ELSE 
			BEGIN 
				-- Calculate current MU metric value
				SET @CurValue = CONVERT(VARCHAR(10), CONVERT(DECIMAL(8,2), (CONVERT(DECIMAL(8,2), @NumeratorSumValue) / CONVERT(DECIMAL(8,2), @DenominatorSumValue)) * 100)) + '%'
	                  
				-- Determine if goal is satisfied
				IF CONVERT(DECIMAL(8,2), (CONVERT(DECIMAL(8,2), @NumeratorSumValue) / CONVERT(DECIMAL(8,2), @DenominatorSumValue)) * 100) > @GoalValue
				BEGIN
					SET @MetGoal = 1
				END 
			END 
             
			-- Insert MU summary row
			INSERT INTO @tblMeaingfulUseSummaryCoreAndMenuSet ([ItemDefinitionUid]
				, [CategoryNumber]
				, [CategoryName]
				, [MeasureNumber]
				, [SubMeasureNumber]
				, [MeasureDesc]
				, [DenominatorDesc]
				, [DenominatorValue]
				, [NumeratorDesc]
				, [NumeratorValue]
				, [YesNo]
				, [CurrentValue]
				, [GoalDesc]
				, [GoalValue]
				, [MetGoal]
				, [ProviderUid]
				, [ProviderLnFn]
			)   
			VALUES (@ItemDefinitionUid
				, @CategoryNumber
				, @CategoryName
				, @MeasureNumber
				, @SubMeasureNumber
				, @MeasureDesc
				, @DenominatorDesc
				, @DenominatorSumValue
				, @NumeratorDesc
				, @NumeratorSumValue
				, @YesNo
				, @CurValue
				, @GoalDesc
				, CONVERT([varchar](10), @GoalValue)
				, @MetGoal
				, null
				, null
			)  
		END 
		ELSE 
		BEGIN
			-- Current MU metric is YES/NO.  
			INSERT INTO @tblMeaingfulUseSummaryCoreAndMenuSet([ItemDefinitionUid]
				, [CategoryNumber]
				, [CategoryName]
				, [MeasureNumber]
				, [SubMeasureNumber]
				, [MeasureDesc]
				, [DenominatorDesc]
				, [DenominatorValue]
				, [NumeratorDesc]
				, [NumeratorValue]
				, [YesNo]
				, [CurrentValue]
				, [GoalDesc]
				, [GoalValue]
				, [MetGoal]
				, [ProviderUid]
				, [ProviderLnFn]
			)  
			VALUES (@ItemDefinitionUid
				, @CategoryNumber
				, @CategoryName
				, @MeasureNumber
				, @SubMeasureNumber
				, @MeasureDesc
				, @DenominatorDesc
				, null
				, @NumeratorDesc
				, null
				, @YesNo
				, null
				, @GoalDesc
				, null
				, null
				, null
				, null
			)  
		END
		-- 
		-- Get next cursor_MU_Definitions row
		FETCH NEXT FROM cursor_MU_Definitions INTO @ItemDefinitionUid
			, @CategoryUid
			, @CategoryNumber
			, @CategoryName
			, @MeasureNumber
			, @SubMeasureNumber
			, @MeasureDesc
			, @ExclusionDesc
			, @DenominatorDesc
			, @NumeratorDesc
			, @YesNo
			, @GoalDesc
			, @GoalValue 
    END
    --
    -- Close and Deallocate cursor
    CLOSE cursor_MU_Definitions
    DEALLOCATE cursor_MU_Definitions
	
	-- Return Meaningful Use results to caller
	SELECT 'MeaingfulUseSummaryCoreAndMenuSet'
	SELECT [RowId]
		, [ItemDefinitionUid]
		, [CategoryNumber]
		, [CategoryName]
		, [MeasureNumber]
		, [SubMeasureNumber]
		, [MeasureDesc]
		, [DenominatorDesc]
		, [DenominatorValue]
		, [NumeratorDesc]
		, [NumeratorValue]
		, [YesNo]
		, [CurrentValue]
		, [GoalDesc]
		, [GoalValue]
		, [MetGoal]
		, [ProviderUid]
		, [ProviderLnFn]
	FROM @tblMeaingfulUseSummaryCoreAndMenuSet    
	ORDER BY [CategoryNumber] ASC
		, [MeasureNumber] ASC
		, [SubMeasureNumber] ASC 
	
	IF (@Debug <> 0)
	BEGIN
		SELECT 'GOOD BYE'
	END 
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2021PI_Master_Report]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2021PI_Master_Report] AS' 
END
GO
ALTER PROC [dbo].[2021PI_Master_Report]
(
	@ReportInstanceUid		[uniqueidentifier],
	@ProviderUid			[varchar](max) = NULL, 
	@RptTimespan_StartDate	[date],
	@RptTimespan_EndDate	[date],
	@ProviderOption			[varchar](100) = 'Billing Provider', --	Billing Provider and Rendering Provider 
	@Debug					[int] = 0,
	@includetestpat			[bit] = 0,
	@ServiceSiteUID			[varchar](max) = null, 
	@FinancialCenterUID		[varchar](max) = null
)
AS
BEGIN
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;
	--
	--  

	IF (@RptTimespan_StartDate IS NULL)
	BEGIN
		SET @RptTimespan_StartDate = '01-01-1900'
	END 
	IF (@RptTimespan_EndDate IS NULL)
	BEGIN
		SET @RptTimespan_EndDate = GETDATE()
	END

	CREATE TABLE [#tblProviderList]
	(
		[ProviderUid] [uniqueidentifier] NOT NULL primary key clustered
	)
	 
	DECLARE @HasProviderUid [bit] = 0
	EXEC [2019PI_Master_PopulateProviderList] @ProviderUid, @HasProviderUid out

	DECLARE @ClaimFormatValueTypeProviderNPIUid [uniqueidentifier] = 'CE282F4E-A866-49BA-9636-C4BA0439E907',
		@ReportMode [bit] = 1,
		@ProviderBilling [bit] = 0,
		@ProviderRendering [bit] = 0,
		@ProviderNPI [varchar](100) = null

	-- Find the first provider has provider NPI

	SELECT TOP 1 @ProviderNPI = [Value]
	FROM [ClaimFormatValue] with(nolock)
	WHERE [ClaimFormatValueTypeUid] = @ClaimFormatValueTypeProviderNPIUid
		AND [ProviderUid] IN (SELECT [ProviderUid] FROM [#tblProviderList])

	-- Set local Billing and Rendering Provider Flags
	IF (@ProviderOption = 'Billing Provider')
	BEGIN
		SET @ProviderBilling = 1
		SET @ProviderRendering = 0
	END
	ELSE
	BEGIN
		SET @ProviderBilling = 0
		SET @ProviderRendering = 1	
	END

	IF NOT EXISTS (SELECT 1 FROM sysobjects WHERE Name='cus_PDMP_Pats' and XType='U')
		EXEC FillPDMPPatsTable

	-- Measure stored procedure flag indicating Meaningful Use data will be used for a report
CREATE TABLE [#tblVisitList]
	(
		[VisitUid]							[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[VisitDate]							[date]         NOT NULL,
		[PatientUid]						[uniqueidentifier] NOT NULL,
		[TestPat]					   		[bit],
		[IsEM]								[bit],
		[IsVP]								[bit],
		[ProviderUid]						[varchar](max),
		[RenderingProviderUid]				[varchar](max),
		[LastSavedByUid]					[uniqueidentifier],
		[SavedByBillingProvider]			[bit],
		[SavedByRenderingProvider]			[bit],
		[TransitionOfCare]					[bit],
		[MedicationChecked]					[bit],
		[DrugAllergyChecked]				[bit],
		[ProblemChecked]					[bit],
		[SummaryProvidedToPatient]			[date],
		[PatientDeclinedClinicalSummary]	[bit],
		[HasEduForm]						[bit],
		[HasPortalAccount]					[bit],
		[PrintedDate]						[date]
	)
	--
	-- PopulateVisitList
	EXEC [2019PI_Master_PopulateVisitList] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@Debug,
		@ServiceSiteUID,
		@FinancialCenterUID

	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblVisitList]
		ORDER BY [VisitDate] DESC 
	END

	CREATE TABLE [#tblPatientList] 
	(
		[PersonUid]					[uniqueidentifier] NOT NULL primary key clustered,
		[PatientLnFn]				[varchar](250),
		[Birthdate]					[date],
		[TestPat]					[bit],
		[IsEM]						[bit],
		[IsVP]						[bit],
		[FullDemographics]			[bit],
		[HasEduForm]				[bit],
		[EduFormPrinted]			[bit],
		[HasPortalAccount]			[bit],
		[PortalPerson]				[uniqueidentifier] NULL,
		[PortalValid]				[date] NULL,
		[PortalExpire]				[date] NULL,
		[SummaryProvidedToPatient]	[bit],
		[TransitionOfCare]			[bit],
		[MedicationChecked]			[bit],
		[SavedByBillingProvider]	[bit],
		[SavedByRenderingProvider]	[bit],
		[YearsOldOrOlder2]			[bit] NULL,
		[YearsOldOrOlder3]			[bit] NULL,
		[YearsOldOrYounger5]		[bit] NULL, 
		[YearsOldOrOlder13]			[bit] NULL,
		[YearsOldOrOlder65]			[bit] NULL
	)
	--
	-- Populate Patient List
	EXEC [2019PI_Master_PopulatePatientList] 
			@ProviderUid, 
			@RptTimespan_StartDate,
			@RptTimespan_EndDate,
			@ProviderBilling,
			@ProviderRendering,
			@Debug

	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblPatientList]
		ORDER BY [PatientLnFn]
	END

	--back fill #tblVisitList with patient specific information
	--delete test patient records from #tblVisitList AND #tblPatientList IF @includetestpat = 0
	EXEC [2019PI_Master_SynchronizeVisitAndPatient] @Debug = @Debug,
		@IncludeTestPatients = @includetestpat

	-- Build list of Medications that are within reporting range
	CREATE TABLE [#tblMedicationList]
	(
		[MedicationSIGUid]					[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[CreatedDate]						[datetime] NOT NULL,
		[RelVisitMedicationUid]				[uniqueidentifier],
		[PersonUid]							[uniqueidentifier],
		[TestPat]							[bit],
		[LicensedHealthcareProfessional]	[bit] NOT NULL,
		[Dispensable]						[bit] NULL,
		[IsSampleGiven]						[bit] NOT NULL,
		[IsAdministered]					[bit] NOT NULL,
		[reffederaldeaclasscode]			[int] NULL,
		[SIGDetailCount]					[int] NULL,
		[eRxStatusUid]						[uniqueidentifier]
	)
	--
	-- PopulateMedicationList
	EXEC [2019PI_Master_PopulateMedicationList] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@includetestpat,
		@Debug
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblMedicationList]
		ORDER BY [CreatedDate] DESC 
	END

	-- Build list of Orders that are within reporting range
	CREATE TABLE [#tblOrderList]
	(
		[ObservationOrderUid]				[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[PatientUid]						[uniqueidentifier] NOT NULL,
		[TestPat]					 		[bit],
		[VPUid]								[uniqueidentifier] NULL,
		[CreatedBy]							[uniqueidentifier] NULL,
		[OrderDate]							[datetime] NOT NULL,
		[ProcedureCodeTypeUid]				[uniqueidentifier] NULL,
		[ProcedureCodeTypeName]				[varchar](500) NULL,
		[AttachmentTypeUid]					[uniqueidentifier] NULL,
		[AttachmentTypeName]				[varchar](500) NULL,
		[LicensedHealthcareProfessional]	[bit] NOT NULL,
		[ImageResultsDirectlyAccessible]	[bit] NULL,
		[ResultStatusID]					[int] NULL
	)
	--
	-- PopulateOrderList
	EXEC [2019PI_Master_PopulateOrderList] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@includetestpat,
		@Debug
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblOrderList]
		ORDER BY [OrderDate] DESC 
	END

	-- Create work table that will hold the Meaningful Use results
	CREATE TABLE [#tblMeaningfulUseDetail] 
	(
		[RowId]				[int] IDENTITY(1,1) PRIMARY KEY, -- Primary Key
		[ItemDefinitionUid]	[uniqueidentifier], -- MeaningfulUseItemDefinition.ItemDefinitionUid
		[CategoryName]		[varchar](500) NULL, -- MeaningfulUseCategoryDefinition.CategoryName
		[CategoryNumber]	[int] NULL, -- MeaningfulUseCategoryDefinition.CategoryNumber
		[MeasureNumber]		[int] NULL, -- MeaningfulUseItemDefinition.MeasureNumber 
		[SubMeasureNumber]	[int] NULL, -- MeaningfulUseItemDefinition.SubMeasureNumber
		[PersonUid]			[uniqueidentifier] NULL, -- Unique list of Visit.PatientUid
		[PersonLnFn]		[varchar](150) NULL, -- Patient name
		[ProviderUid]		[varchar](MAX) NULL,
		[ProviderLnFn]		[varchar](150) NULL, 
		[NumeratorValue]	[int] NULL, -- See MeaningfulUseItemDefinition.NumeratorDesc
		[DenominatorValue]	[int] NULL, -- See MeaningfulUseItemDefinition.DenominatorDesc
		[YesNo]				[int] NULL -- See MeaningfulUseItemdefinition.YesNo. Null-NA, 0-No/False, 1-Yes/True.
		unique clustered (RowId)
	) 
 
	CREATE NONCLUSTERED INDEX [MUDetail_ItemDef_PersonUid] ON #tblMeaningfulUseDetail
	(
		ItemDefinitionUid ASC,
		PersonUid ASC
	)
	WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]


	-- Params used in determining if any detail rows were found for given metric
	CREATE TABLE [#tblMetricUidsWithoutDetailRows] 
	(
		[ItemDefinitionUid] [uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED
	)

	-- Create temp table that can be used by measure procs
	CREATE TABLE [#MetricDataTemp]
	(
		[PersonUid] [uniqueidentifier] NOT NULL,
		[HeightRecorded] [int] NULL,
		[WeightRecorded] [int] NULL,
		[BloodPressureRecorded] [int] NULL,
		[LabResultTotalCount] [int] NULL, 
		[LabResultTemplatedCount] [int] NULL,
		[TaskDocGenCount] [int] NULL, 
		[TaskDocGenCompleteCount] [int] NULL, 
		[VisitCount] [int] NULL, 
		[ClinicalSummaryProvidedCount] [int] NULL, 
		[PreventativeFollowupDueCount] [int] NULL, 
		[PreventativeFollowupSentCount] [int] NULL, 
		[SeenByAnotherProviderCount] [int] NULL, 
		[MedicalCheckedCount] [int] NULL, 
		[ReferralCount] [int] NULL, 
		[ReferralClinicalSummaryProvided] [int] NULL
	) 	

	-- Proc based on MUII_Master_DesktopControl
	--  
	-- Calculate Measures
	-- ACI_TRANS_PPHI_1 == Objective 1 == MUII Core Measure 9
	-- Must attest yes

	-- ACI_TRANS_EP_1 == Objective 4 == MUII Core Measure 2, Sub Measure NULL; ItemDefinitionUid : F3A49E2B-E4FF-4D78-A3D5-EEA12A5FBF58
	EXEC [2021PI_E-Prescribing_1_NonControlled] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2021PI_E-Prescribing_2_Controlled] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2021PI_E-Prescribing_3_PDMP] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2021PI_HealthInformationExchange_1_Sending] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2021PI_HealthInformationExchange_2_Receiving] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE
		
	EXEC [2021PI_ProviderToPatientExchange] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	-- Drop temp tables that are used by measure procs
	BEGIN TRY
		DROP TABLE [#tblVisitList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#tblPatientList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#tblProviderList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#MetricDataTemp]
	END TRY 
	BEGIN CATCH
	END CATCH

	-- For measures that do not have any detail rows, we need to insert a row, so it will be included in the RDL report.
	DECLARE @NumDetailRows [int]
	SET @NumDetailRows = (SELECT COUNT(*) FROM [#tblMetricUidsWithoutDetailRows])
	IF (@NumDetailRows > 0)
	BEGIN
		INSERT INTO [#tblMeaningfulUseDetail] ([ItemDefinitionUid],
			[CategoryNumber],
			[CategoryName],
			[MeasureNumber],
			[SubMeasureNumber],
			[PersonUid],
			[PersonLnFn],
			[ProviderUid],
			[ProviderLnFn],
			[NumeratorValue],
			[DenominatorValue],
			[YesNo]
		)
			SELECT NoData.[ItemDefinitionUid] AS [ItemDefinitionUid]
			,(
				select mucd.[CategoryNumber] 
				from [MeaningfulUseItemDefinition] AS muid with(nolock)
					inner join [MeaningfulUseCategoryDefinition] AS mucd with(nolock) on muid.[CategoryUid] = mucd.[CategoryUid]
				where muid.[ItemDefinitionUid] = NoData.[ItemDefinitionUid]
			) AS [CategoryNumber]

			,(
				select mucd.CategoryName
				from [MeaningfulUseItemDefinition] AS muid with(nolock)
					inner join [MeaningfulUseCategoryDefinition] AS mucd with(nolock) on muid.[CategoryUid] = mucd.[CategoryUid]
				where muid.[ItemDefinitionUid] = NoData.[ItemDefinitionUid]
			) AS [CategoryName]

			,(
				select muid.[MeasureNumber]
				from [MeaningfulUseItemDefinition] AS muid with(nolock)
					inner join [MeaningfulUseCategoryDefinition] AS mucd with(nolock) on muid.[CategoryUid] = mucd.[CategoryUid]
				where muid.[ItemDefinitionUid] = NoData.[ItemDefinitionUid]
			) AS [MeasureNumber] 

			,(
				select muid.[SubMeasureNumber] 
				from [MeaningfulUseItemDefinition] AS muid with(nolock)
					inner join [MeaningfulUseCategoryDefinition] AS mucd with(nolock) on muid.[CategoryUid] = mucd.[CategoryUid]
				where muid.[ItemDefinitionUid] = NoData.[ItemDefinitionUid]
			) AS [SubMeasureNumber] 

			,NULL AS [PersonUid] 
			,'N / A' AS [PersonLnFn]
			,NULL AS [ProviderUid] 
			,'' AS [ProviderLnFn]
			,0 AS [NumeratorValue]
			,0 AS [DenominatorValue]
			,0 AS [YesNo]
		FROM [#tblMetricUidsWithoutDetailRows] AS [NoData] 
	END

	--
	-- For measures that are Yes/No (Must attest Yes), insert a detail row that will be included in the RDL report
	--

	-- ACI_TRANS_PPHI_1 == Objective 1 == MUII Core Measure 9
	DECLARE @ItemDefinitionUid [uniqueidentifier] = '1D8DEE46-CB1A-45DD-B0FF-FE04DDBD1310' 
	EXEC [MUI_Master_Report_InsertAttestMeasureDetail] @ItemDefinitionUid, @ReportMode,	@Debug

	-- Pick 2 registries
	SET @ItemDefinitionUid = 'CC4FF4BA-CA32-41F7-A157-5426E59C81AE' 
	EXEC [MUI_Master_Report_InsertAttestMeasureDetail] @ItemDefinitionUid, @ReportMode, @Debug

	-- Define table that will be returned to caller
	DECLARE @tblMeaingfulUseSummaryCoreAndMenuSet TABLE
	(
		[RowId]             [int] IDENTITY(1,1) PRIMARY KEY,
		[ItemDefinitionUid] [uniqueidentifier],
		[CategoryNumber]    [int] NULL,
		[CategoryName]      [varchar](100) NULL,
		[MeasureNumber]     [int] NULL, 
		[SubMeasureNumber]  [int] NULL,
		[MeasureDesc]       [varchar](500) NULL,
		[DenominatorDesc]   [varchar](250) NULL,
		[DenominatorValue]  [int] NULL,
		[NumeratorDesc]     [varchar](250) NULL,
		[NumeratorValue]    [int] NULL,
		[YesNo]     [varchar](50)  NULL,
		[CurrentValue]	  [varchar](25)  NULL,
		[GoalDesc]          [varchar](250) NULL,
		[GoalValue]         [varchar](10)  NULL,
		[MetGoal]           [bit] NULL, 
		[ProviderUid]       [varchar](max) NULL,
		[ProviderLnFn]      [varchar](150) NULL,       
		unique clustered  ([RowId])
	) 

	-- Determine if there are any MU detail rows to base metrics against
	-- Walk through list of defined Meaningful Use metrics and popluate @tblMeaingfulUseSummaryCoreAndMenuSet 
	DECLARE @CategoryUid [uniqueidentifier]
		, @CategoryNumber [int]
		, @CategoryName [varchar](100)
		, @MeasureNumber [int]
		, @SubMeasureNumber [int]
		, @MeasureDesc [varchar](500)
		, @ExclusionDesc [varchar](250)
		, @DenominatorDesc [varchar](250)
		, @NumeratorDesc [varchar](250)
		, @YesNo [varchar](50)
		, @GoalDesc [varchar](250)
		, @GoalValue [decimal](5, 2)
		, @DenominatorSumValue [int]
		, @NumeratorSumValue [int]
		, @CurValue [varchar](25)
		, @MetGoal [bit]    
        
    --
    -- Populate table that will be returned to caller
	DECLARE cursor_MU_Definitions CURSOR FAST_FORWARD FOR 
		SELECT muid.[ItemDefinitionUid]
			, muid.[CategoryUid]
			, mucd.[CategoryNumber]
			, mucd.[CategoryName]
			, muid.[MeasureNumber]
			, muid.[SubMeasureNumber]
			, muid.[MeasureDesc]
			, muid.[ExclusionDesc]
			, muid.[DenominatorDesc]
			, muid.[NumeratorDesc]
			, muid.[YesNo]
			, muid.[GoalDesc]
			, muid.[GoalValue]
		FROM [MeaningfulUseItemDefinition] AS muid with(nolock)
			INNER JOIN [MeaningfulUseCategoryDefinition] AS mucd with(nolock) ON muid.[CategoryUid] = mucd.[CategoryUid]
/*Replace w/new StageUid*/		WHERE muid.[StageUid] = 'FF9E6E95-D980-456A-B303-98209637DC4A'   -- 2021 PI
		ORDER BY mucd.[CategoryName]
			, mucd.[CategoryNumber]
			, muid.[MeasureNumber]
    --
    OPEN cursor_MU_Definitions
    --
	FETCH NEXT FROM cursor_MU_Definitions 
		INTO @ItemDefinitionUid
			, @CategoryUid
			, @CategoryNumber
			, @CategoryName
			, @MeasureNumber
			, @SubMeasureNumber
			, @MeasureDesc
			, @ExclusionDesc
			, @DenominatorDesc
			, @NumeratorDesc
			, @YesNo
			, @GoalDesc
			, @GoalValue 
    --
   -- Make sure we have a valid cursor row
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @DenominatorSumValue = 0
		SET @NumeratorSumValue = 0
		SET @CurValue = '' 
		SET @MetGoal = 0 
		SET @NumDetailRows = 0
		
		-- Check if current MU metric has a numerator and denominator
		IF @YesNo IS NULL
		BEGIN
			-- Make sure we have some data for current metric
			SET @NumDetailRows = (SELECT COUNT(*)
								  FROM [#tblMeaningfulUseDetail]
								  WHERE [ItemDefinitionUid] = @ItemDefinitionUid
								 )
			IF (@NumDetailRows > 0)
			BEGIN
				-- Current MU metric has a numerator and demoninator
				SELECT  @DenominatorSumValue = SUM(mud.[DenominatorValue])
					, @NumeratorSumValue   = SUM(mud.[NumeratorValue]) 
				FROM     [#tblMeaningfulUseDetail] AS mud
				WHERE    mud.[ItemDefinitionUid] = @ItemDefinitionUid
				GROUP BY mud.[ItemDefinitionUid] 
			END    
           
			IF @DenominatorSumValue <= 0
			BEGIN
				SET @CurValue = 'N/A' 
			END 
			ELSE IF @NumeratorSumValue <= 0
			BEGIN 
				SET @CurValue = '0.00%' 
			END 
			ELSE 
			BEGIN 
				-- Calculate current MU metric value
				SET @CurValue = CONVERT(VARCHAR(10), CONVERT(DECIMAL(8,2), (CONVERT(DECIMAL(8,2), @NumeratorSumValue) / CONVERT(DECIMAL(8,2), @DenominatorSumValue)) * 100)) + '%'
	                  
				-- Determine if goal is satisfied
				IF CONVERT(DECIMAL(8,2), (CONVERT(DECIMAL(8,2), @NumeratorSumValue) / CONVERT(DECIMAL(8,2), @DenominatorSumValue)) * 100) > @GoalValue
				BEGIN
					SET @MetGoal = 1
				END 
			END 
             
			-- Insert MU summary row
			INSERT INTO @tblMeaingfulUseSummaryCoreAndMenuSet ([ItemDefinitionUid]
				, [CategoryNumber]
				, [CategoryName]
				, [MeasureNumber]
				, [SubMeasureNumber]
				, [MeasureDesc]
				, [DenominatorDesc]
				, [DenominatorValue]
				, [NumeratorDesc]
				, [NumeratorValue]
				, [YesNo]
				, [CurrentValue]
				, [GoalDesc]
				, [GoalValue]
				, [MetGoal]
				, [ProviderUid]
				, [ProviderLnFn]
			)   
			VALUES (@ItemDefinitionUid
				, @CategoryNumber
				, @CategoryName
				, @MeasureNumber
				, @SubMeasureNumber
				, @MeasureDesc
				, @DenominatorDesc
				, @DenominatorSumValue
				, @NumeratorDesc
				, @NumeratorSumValue
				, @YesNo
				, @CurValue
				, @GoalDesc
				, CONVERT([varchar](10), @GoalValue)
				, @MetGoal
				, null
				, null
			)  
		END 
		ELSE 
		BEGIN
			-- Current MU metric is YES/NO.  
			INSERT INTO @tblMeaingfulUseSummaryCoreAndMenuSet([ItemDefinitionUid]
				, [CategoryNumber]
				, [CategoryName]
				, [MeasureNumber]
				, [SubMeasureNumber]
				, [MeasureDesc]
				, [DenominatorDesc]
				, [DenominatorValue]
				, [NumeratorDesc]
				, [NumeratorValue]
				, [YesNo]
				, [CurrentValue]
				, [GoalDesc]
				, [GoalValue]
				, [MetGoal]
				, [ProviderUid]
				, [ProviderLnFn]
			)  
			VALUES (@ItemDefinitionUid
				, @CategoryNumber
				, @CategoryName
				, @MeasureNumber
				, @SubMeasureNumber
				, @MeasureDesc
				, @DenominatorDesc
				, null
				, @NumeratorDesc
				, null
				, @YesNo
				, null
				, @GoalDesc
				, null
				, null
				, null
				, null
			)  
		END
		-- 
		-- Get next cursor_MU_Definitions row
		FETCH NEXT FROM cursor_MU_Definitions INTO @ItemDefinitionUid
			, @CategoryUid
			, @CategoryNumber
			, @CategoryName
			, @MeasureNumber
			, @SubMeasureNumber
			, @MeasureDesc
			, @ExclusionDesc
			, @DenominatorDesc
			, @NumeratorDesc
			, @YesNo
			, @GoalDesc
			, @GoalValue 
    END
    --
    -- Close and Deallocate cursor
    CLOSE cursor_MU_Definitions
    DEALLOCATE cursor_MU_Definitions

	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CUS_MeaningfulUseDetail]') AND type in (N'U'))
	BEGIN
	CREATE TABLE [dbo].[CUS_MeaningfulUseDetail](
		[MeaningfulUseDetailUid] [uniqueidentifier] NOT NULL,
		[ReportInstanceUid] [uniqueidentifier] NOT NULL,
		[ItemDefinitionUid] [uniqueidentifier] NULL,
		[CategoryName] [varchar](500) NULL,
		[CategoryNumber] [int] NULL,
		[MeasureNumber] [int] NULL,
		[SubMeasureNumber] [int] NULL,
		[PersonUid] [uniqueidentifier] NULL,
		[PersonLnFn] [varchar](150) NULL,
		[ProviderUid] [varchar](max) NULL,
		[ProviderLnFn] [varchar](150) NULL,
		[ProviderNPI] [varchar](250) NULL,
		[NumeratorValue] [int] NULL,
		[DenominatorValue] [int] NULL,
		[YesNo] [int] NULL,
		[ObjectiveDesc] [varchar](500) NULL,
		[MeasureDesc] [varchar](600) NOT NULL,
		[MeasureDetailDesc] [varchar](600) NULL,
		[ExclusionDesc] [varchar](600) NULL,
		[DenominatorDesc] [varchar](500) NULL,
		[NumeratorDesc] [varchar](500) NULL,
		[GoalDesc] [varchar](250) NULL,
		[LastModifiedDate] [datetime] NOT NULL,
	 CONSTRAINT [PK_CUS_MeaningfulUseDetail] PRIMARY KEY CLUSTERED 
	(
		[MeaningfulUseDetailUid] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
	END

	IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CUS_MeaningfulUseDetail]') AND name = N'IX_CUS_MeaningfulUseDetail')
		CREATE NONCLUSTERED INDEX [IX_CUS_MeaningfulUseDetail] ON [dbo].[CUS_MeaningfulUseDetail]
		(
			[ReportInstanceUid] ASC,
			[ItemDefinitionUid] ASC,
			[PersonUid] ASC
		)
		INCLUDE ( 	[CategoryName],
			[CategoryNumber],
			[MeasureNumber],
			[NumeratorValue],
			[DenominatorValue],
			[ExclusionDesc],
			[DenominatorDesc],
			[SubMeasureNumber],
			[PersonLnFn],
			[ProviderUid],
			[ProviderLnFn],
			[NumeratorDesc],
			[GoalDesc],
			[YesNo],
			[ObjectiveDesc],
			[MeasureDesc],
			[MeasureDetailDesc],
			[MeaningfulUseDetailUid],
			[ProviderNPI],
			[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF_CUS_MeaningfulUseDetail_MeaningfulUseDetailUid]') AND type = 'D')
	BEGIN
		ALTER TABLE [dbo].[CUS_MeaningfulUseDetail] ADD  CONSTRAINT [DF_CUS_MeaningfulUseDetail_MeaningfulUseDetailUid]  DEFAULT (newid()) FOR [MeaningfulUseDetailUid]
	END

	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF_CUS_MeaningfulUseDetail_LastModifiedDate]') AND type = 'D')
	BEGIN
		ALTER TABLE [dbo].[CUS_MeaningfulUseDetail] ADD  CONSTRAINT [DF_CUS_MeaningfulUseDetail_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
	END

	EXEC MIPS_2018_Master_Report_DeleteReportInstance @ReportInstanceUid
	--
	-- Return detail table to caller
	--
	INSERT [CUS_MeaningfulUseDetail](
		[ReportInstanceUid],
		[ItemDefinitionUid],
		[CategoryName],
		[CategoryNumber],
		[MeasureNumber],
		[SubMeasureNumber],
		[PersonUid],
		[PersonLnFn],
		[ProviderUid],
		[ProviderLnFn],
		[ProviderNPI],
		[NumeratorValue],
		[DenominatorValue],
		[YesNo],
		[ObjectiveDesc],
		[MeasureDesc],
		[MeasureDetailDesc],
		[ExclusionDesc],
		[DenominatorDesc],
		[NumeratorDesc],
		[GoalDesc]
	)
	SELECT @ReportInstanceUid AS [ReportInstanceUid],
		t.[ItemDefinitionUid],
		COALESCE(t.[CategoryName], mucd.[CategoryName]) AS [CategoryName],
		t.[CategoryNumber],
		t.[MeasureNumber],
		t.[SubMeasureNumber],
		t.[PersonUid],
		t.[PersonLnFn],
		[ProviderUid],
		t.[ProviderLnFn],
		@ProviderNPI AS [ProviderNPI],
		t.[NumeratorValue],
		t.[DenominatorValue],
		t.[YesNo],
		MUID.[ObjectiveDesc],
		MUID.[MeasureDesc],
		MUID.[MeasureDetailDesc],
		MUID.[ExclusionDesc],
		MUID.[DenominatorDesc],
		MUID.[NumeratorDesc],
		MUID.[GoalDesc]
	FROM [#tblMeaningfulUseDetail] AS t
		INNER JOIN [MeaningfulUseItemDefinition] AS MUID with(nolock) ON MUID.[ItemDefinitionUid] = t.[ItemDefinitionUid]
		INNER JOIN [MeaningfulUseCategoryDefinition] AS mucd with (nolock) ON MUID.[CategoryUid] = mucd.[CategoryUid]
	ORDER BY [CategoryName] ASC,
		[CategoryNumber] ASC,
		[MeasureNumber] ASC,
		[SubMeasureNumber] ASC,
		[NumeratorValue] DESC,
		[DenominatorValue] DESC,
		[PersonLnFn] ASC 
	
	BEGIN TRY
		DROP TABLE [#tblMeaningfulUseDetail]
	END TRY
	BEGIN CATCH
	END CATCH
	
	-- Return Meaningful Use results to caller
	SELECT [RowId]
		, [ItemDefinitionUid]
		, [CategoryNumber]
		, [CategoryName]
		, [MeasureNumber]
		, [SubMeasureNumber]
		, [MeasureDesc]
		, [DenominatorDesc]
		, [DenominatorValue]
		, [NumeratorDesc]
		, [NumeratorValue]
		, [YesNo]
		, [CurrentValue]
		, [GoalDesc]
		, [GoalValue]
		, [MetGoal]
		, [ProviderUid]
		, [ProviderLnFn]
	FROM @tblMeaingfulUseSummaryCoreAndMenuSet    
	ORDER BY [CategoryNumber] ASC
		, [MeasureNumber] ASC
		, [SubMeasureNumber] ASC 
	
	IF (@Debug <> 0)
	BEGIN
		SELECT 'GOOD BYE'
	END 
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2022PI_E-Prescribing_1_NonControlled]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2022PI_E-Prescribing_1_NonControlled] AS' 
END
GO
ALTER PROC [dbo].[2022PI_E-Prescribing_1_NonControlled]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

	IF (@Debug = 1)
	BEGIN
		SELECT '2022PI_E-Prescribing_1_NonControlled-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = 'E2109033-C203-432B-BE45-0445B9611E01',
		@RxStatusTransmittedSuccessfully [uniqueidentifier] = 'B1F7EFAF-D56D-4BAD-AE1F-8205E1D00B58', 
		@RxStatusQueuedForTransmission   [uniqueidentifier] = '0605B6F6-2FE4-49CB-B868-9DF448AB3E01'

	TRUNCATE TABLE #MetricDataTemp

	-- Initialize work table
	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
	SELECT @ItemDefinitionUid AS [ItemDefinitionUid]
		, med.[PersonUid]
		, COUNT(sts.[eRxStatusUid]) AS [NumeratorValue]                        
		, COUNT(med.[MedicationSIGUid]) AS [DenominatorValue]
		, null AS [YesNo]
	FROM   [#tblMedicationList] AS med
		LEFT JOIN [ListeRxStatus] AS sts WITH(NOLOCK) ON  med.[eRxStatusUid] = sts.[eRxStatusUid]
		 AND (sts.[eRxStatusUid] IN(@RxStatusTransmittedSuccessfully, @RxStatusQueuedForTransmission))
	WHERE med.[Dispensable] = 1
		AND med.[IsSampleGiven] = 0
		AND med.[IsAdministered] = 0
		AND med.[reffederaldeaclasscode] = 0
		AND [SIGDetailCount] = 1
	GROUP BY med.[PersonUid]
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2022PI_E-Prescribing_1_NonControlled -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2022PI_E-Prescribing_2_Controlled]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2022PI_E-Prescribing_2_Controlled] AS' 
END
GO
ALTER PROC [dbo].[2022PI_E-Prescribing_2_Controlled]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

	IF (@Debug = 1)
	BEGIN
		SELECT '2022PI_E-Prescribing_2_Controlled-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = 'AE3292A7-6925-4F01-8D1D-041BDB2B8ABE',
		@RxStatusTransmittedSuccessfully [uniqueidentifier] = 'B1F7EFAF-D56D-4BAD-AE1F-8205E1D00B58', 
		@RxStatusQueuedForTransmission   [uniqueidentifier] = '0605B6F6-2FE4-49CB-B868-9DF448AB3E01'

	TRUNCATE TABLE #MetricDataTemp

	-- Initialize work table
	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
	SELECT @ItemDefinitionUid AS [ItemDefinitionUid]
		, med.[PersonUid]
		, COUNT(sts.[eRxStatusUid]) AS [NumeratorValue]                        
		, COUNT(med.[MedicationSIGUid]) AS [DenominatorValue]
		, null AS [YesNo]
	FROM   [#tblMedicationList] AS med
		LEFT JOIN [ListeRxStatus] AS sts WITH(NOLOCK) ON  med.[eRxStatusUid] = sts.[eRxStatusUid]
		 AND (sts.[eRxStatusUid] IN(@RxStatusTransmittedSuccessfully, @RxStatusQueuedForTransmission))
	WHERE med.[Dispensable] = 1
		AND med.[IsSampleGiven] = 0
		AND med.[IsAdministered] = 0
		AND med.[reffederaldeaclasscode] >= 0
		AND [SIGDetailCount] = 1
	GROUP BY med.[PersonUid]
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2022P2_E-Prescribing_2_Controlled -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2022PI_E-Prescribing_3_PDMP]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2022PI_E-Prescribing_3_PDMP] AS' 
END
GO
ALTER PROC [dbo].[2022PI_E-Prescribing_3_PDMP]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

	IF (@Debug = 1)
	BEGIN
		SELECT '2022PI_E-Prescribing_3_PDMP-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = 'C363E72C-D727-4DA6-8907-935D4A1389BD',
		@RxStatusTransmittedSuccessfully [uniqueidentifier] = 'B1F7EFAF-D56D-4BAD-AE1F-8205E1D00B58', 
		@RxStatusQueuedForTransmission   [uniqueidentifier] = '0605B6F6-2FE4-49CB-B868-9DF448AB3E01'

	TRUNCATE TABLE #MetricDataTemp

	--DECLARE @Audit TABLE (PatientUid UNIQUEIDENTIFIER)
	--INSERT INTO @Audit
	--SELECT a.PatientUid
	--FROM [#tblMedicationList] m
	--INNER JOIN Audit a on m.PersonUid = a.PatientUid 
	--	AND a.ChangeDate >= @RptTimespan_StartDate AND a.ChangeDate <= @RptTimespan_EndDate
	--	AND a.Description LIKE 'Appriss RX Report Requested Successfully%' or Description LIKE 'LogiCoy Report requested successfully%'

	-- Initialize work table
	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
	--THIS is not the right query
	--And needs to be changed to what is correct
	SELECT @ItemDefinitionUid AS [ItemDefinitionUid]
		, med.[PersonUid]
		, CASE WHEN a.PatientUid IS NOT NULL THEN 1 ELSE 0 END AS [NumeratorValue]                        
		, CASE WHEN med.PersonUid IS NOT NULL THEN 1 ELSE 0 END AS [DenominatorValue]
		, null AS [YesNo]
	FROM   [#tblMedicationList] AS med
	INNER JOIN [ListeRxStatus] AS sts WITH(NOLOCK) ON  med.[eRxStatusUid] = sts.[eRxStatusUid]
		 AND (sts.[eRxStatusUid] IN(@RxStatusTransmittedSuccessfully, @RxStatusQueuedForTransmission))
	LEFT JOIN cus_PDMP_Pats a on med.PersonUid = a.PatientUid
	WHERE med.[Dispensable] = 1
		AND med.[IsSampleGiven] = 0
		AND med.[IsAdministered] = 0
		AND med.[reffederaldeaclasscode] >= 2
		AND [SIGDetailCount] = 1
	GROUP BY med.[PersonUid], a.PatientUid
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2022PI_E-Prescribing_3_PDMP -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2022PI_HealthInformationExchange_1_Sending]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2022PI_HealthInformationExchange_1_Sending] AS' 
END
GO
ALTER PROC [dbo].[2022PI_HealthInformationExchange_1_Sending]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

	IF (@Debug = 1)
	BEGIN
		SELECT '2022PI_HealthInformationExchange_1_Sending-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

     DECLARE @UTC_RptTimespan_StartDate DATETIME,@UTC_RptTimespan_EndDate DATETIME
      SELECT @UTC_RptTimespan_StartDate = @RptTimespan_StartDate
      SELECT @UTC_RptTimespan_EndDate   = DATEADD(DAY,1,@RptTimespan_EndDate)

      --RecordDisclosureAudit limit range, -1 day from min referral date and +3 days to max referral date
      DECLARE @RecordDisclosureAudit_StartDate DATE,@RecordDisclosureAudit_EndDate DATE
      SELECT @RecordDisclosureAudit_StartDate = DATEADD(DAY,-1,@RptTimespan_StartDate)
      SELECT @RecordDisclosureAudit_EndDate   = DATEADD(DAY,3,@RptTimespan_EndDate)

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = '1CA5A56E-F8B7-4C57-8610-122DF21C6EBD'
	DECLARE @ExcludedReferrals TABLE (PatientReferralUid UNIQUEIDENTIFIER)

	INSERT INTO @ExcludedReferrals
	SELECT ViewUid FROM ViewPatientOutboundReferral v
	INNER JOIN ListProviderCareType p WITH(NOLOCK) on v.ProviderCareTypeUid = p.ProviderCareTypeUid AND p.ExcludeFromReferrals = 1

	INSERT INTO @ExcludedReferrals
	SELECT PatientReferralUid FROM PatientReferral WHERE ReferralTrackingStatusUid = 'F7D1B72C-83ED-4D2E-8AB2-2B86F31E8EB2'

      TRUNCATE TABLE #MetricDataTemp

      ;WITH cte_pr AS (
            select pr.*,dbo.UDF_CQMTestPatient (pr.PatientUid) AS TestPatient
            FROM ViewPatientReferralConsultReport pr 
			INNER JOIN #tblVisitList t on pr.VisitUid = t.VisitUid
            LEFT JOIN PatientReferral p WITH(NOLOCK) on pr.PatientReferralUid = p.PatientReferralUid
            LEFT JOIN VisitProcedure vp WITH(NOLOCK) on p.VisitProcedureUid = vp.VisitProcedureUid
            LEFT JOIN ListProcedure lp WITH(NOLOCK) on vp.ProcedureUid = lp.ProcedureUid      
			LEFT JOIN @ExcludedReferrals er on pr.PatientReferralUid = er.PatientReferralUid
            WHERE pr.RefType = 'PatientReferral'
                        AND (pr.ReferredByProviderUid IN (SELECT Element FROM dbo.Split(@ProviderUid, ',')) OR @ProviderUid IS NULL)
                        AND pr.ReferralDate >= @UTC_RptTimespan_StartDate AND pr.ReferralDate < @RecordDisclosureAudit_EndDate
                        AND (lp.ProcedureCodeTypeUid IS NULL OR lp.ProcedureCodeTypeUid NOT IN ('1E605C00-13F0-4B95-AEDB-7AA2E30A8BED'))
						AND er.PatientReferralUid IS NULL
      ),
      cte_rda AS (
            SELECT [DisclosureDate] ,
                  [DisclosureType] ,
                  [PatientUid] ,
                  rda.[PatientReferralUid] ,
                  [AttachmentGroupUid] ,
                  rda.[VisitUid] ,
                  [IsPortal],
                  [DisclosureMethod],
                  [Status],
                  [DisclosurePurpose]
            FROM RecordDisclosureAudit rda WITH(NOLOCK)
			--LEFT JOIN PatientReferral pr on rda.PatientReferralUid = pr.PatientReferralUid AND pr.ReferredByProviderUid = @ProviderUid
            WHERE DisclosureDate >= @RecordDisclosureAudit_StartDate
                  AND DisclosureType in (1,    -- Complete Chart
                                                      2,    -- Clinical Summary
                                                      11)  -- ContinuityOfCareDocument
                  AND DisclosureMethod IN (1,5,6,7)
                  AND DisclosurePurpose <> 'Released to Patient' --2016.02.23 dmg
                  AND [Status] > 0
      )
      INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
            SELECT @ItemDefinitionUid AS ItemDefinitionUid
                        ,r.PatientUid
                         ,COUNT(distinct CASE WHEN  rda.DisclosureType IS NOT NULL and rda.status = 4 THEN rda.PatientReferralUid
                              ELSE NULL END) AS NumeratorValue            
						,COUNT(distinct CASE WHEN r.PatientReferralUid is not null  and (r.ReferralStatus in ('Initiated', 'Appointment Confirmed')) THEN r.PatientReferralUid
                             ELSE NULL END) AS DenominatorValue 
                        ,null AS YesNo
            FROM cte_pr r 
           LEFT JOIN cte_rda rda ON r.PatientUid=rda.patientuid AND
                                    (
                                          r.VisitUid=rda.VisitUid 
                                          OR r.PatientReferralUid=rda.PatientReferralUid 
                                          OR r.AttachmentGroupUid=rda.AttachmentGroupUid
                                          --OR DATEDIFF(day,r.ReferralDate,rda.DisclosureDate) >= -1
                                    )
            WHERE r.TestPatient = 0
            GROUP BY r.PatientUid
            
      UPDATE #tblMeaningfulUseDetail
      SET NumeratorValue = 
            CASE 
                  WHEN NumeratorValue > DenominatorValue THEN DenominatorValue 
                  ELSE NumeratorValue 
            END
	  WHERE ItemDefinitionUid = @ItemDefinitionUid
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2022PI_HealthInformationExchange_1_Sending -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2022PI_HealthInformationExchange_2_Receiving]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2022PI_HealthInformationExchange_2_Receiving] AS' 
END
GO
ALTER PROC [dbo].[2022PI_HealthInformationExchange_2_Receiving]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

	IF (@Debug = 1)
	BEGIN
		SELECT '2022PI_HealthInformationExchange_2_Receiving-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

	DECLARE @UTC_RptTimespan_StartDate DATETIME,@UTC_RptTimespan_EndDate DATETIME
	SELECT @UTC_RptTimespan_StartDate = @RptTimespan_StartDate, @UTC_RptTimespan_EndDate = @RptTimespan_EndDate
	SELECT @UTC_RptTimespan_StartDate = '01/01/'+CONVERT(VARCHAR(4),DATEPART(YEAR,@UTC_RptTimespan_StartDate))

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = '2C7E98CD-42F2-4E1E-A985-745BC84C36EF'

	DECLARE @InitiatedReferrals TABLE (PatientReferralUid UNIQUEIDENTIFIER)
	INSERT INTO @InitiatedReferrals
	SELECT DISTINCT PatientReferralUid 
	FROM PatientReferralHistory 
	WHERE ReferralTrackingStatusUid IN ('0673DB25-454C-44D8-B83F-AFCF97879AAD','3B180FEC-FAE0-4850-AE16-6172CC31F7A7')

	TRUNCATE TABLE #MetricDataTemp

	;WITH cte_Ref AS (
	SELECT vfp.PersonUid AS PatUid
			, rag.VisitUid AS Uid
			, COALESCE(a.AttachmentUid, ag.AttachmentGroupUid) AS AttUid
			, COALESCE(a.FileDate, ag.LastModifiedDate) AS AttDate
			, aa.HasClinicalDocument AS NumID
			, aa.MedicationAllergiesReconciledDate
			, aa.MedicationsReconciledDate
			, aa.ProblemsReconciledDate
			, a.AttachmentTypeUid
			, latDM.ExternalID AS AttachmentTypeID
	FROM #tblPatientList vfp
	INNER JOIN RelAttachmentGroup rag on vfp.PersonUid = rag.PersonUid
	INNER JOIN Visit v on rag.VisitUid = v.VisitUid AND (v.VisitDate >= @RptTimespan_StartDate AND v.VisitDate <= @RptTimespan_EndDate)
	INNER JOIN #tblProviderList prov on v.ProviderUid = prov.ProviderUid
	LEFT JOIN Attachment a on rag.AttachmentGroupUid = a.AttachmentGroupUid
	LEFT JOIN ListAttachmentType latDM on a.AttachmentTypeUid = latDM.AttachmentTypeUid
	LEFT JOIN AttachmentGroup ag on rag.AttachmentGroupUid = ag.AttachmentGroupUid
	INNER JOIN ListAttachmentType lat on (a.AttachmentTypeUid = lat.AttachmentTypeUid OR ag.AttachmentTypeUid = lat.AttachmentTypeUid) AND (lat.AttachmentTypeUid = 'B71B8F20-7B7D-4A7C-9E75-05811A0791AD')
	LEFT JOIN MessageAA aa on rag.RelAttachmentGroupUid = aa.RelAttachmentGroupUid --AND aa.SummaryOfCareReconciledDate IS NOT NULL
	LEFT JOIN Message m on aa.MessageUid = m.MessageUid

	UNION ALL

	SELECT vfp.PersonUid AS PatUid
			, pr.PatientReferralUid AS Uid
			, aa.MessageUid AS AttUid
			, pr.CreatedDate AS AttDate
			, aa.HasClinicalDocument AS NumID
			, aa.MedicationAllergiesReconciledDate
			, aa.MedicationsReconciledDate
			, aa.ProblemsReconciledDate
			, att.AttachmentTypeUid
			, lat.ExternalID AS AttachmentTypeID
	FROM #tblPatientList vfp
	INNER JOIN RelAttachmentGroup r ON vfp.PersonUid = r.PersonUid
	INNER JOIN MessageAA aa ON aa.RelAttachmentGroupUid = r.RelAttachmentGroupUid --AND aa.ElectronicSummaryOfCareReceived = 1
	LEFT JOIN Attachment att on r.AttachmentGroupUid = att.AttachmentGroupUid
	LEFT JOIN ListAttachmentType lat on att.AttachmentTypeUid = lat.AttachmentTypeUid
	INNER JOIN PatientReferral pr on r.PatientReferralUid = pr.PatientReferralUid 
			AND (pr.CreatedDate >= @RptTimespan_StartDate AND pr.CreatedDate <= @RptTimespan_EndDate)
			AND pr.ReferralTrackingStatusUid <> '3B180FEC-FAE0-4850-AE16-6172CC31F7A7'
	INNER JOIN PatientProviderRelationship ppr on pr.PatientProviderRelationshipUid = ppr.PatientProviderRelationshipUid
	INNER JOIN #tblProviderList prov on pr.ReferredByProviderUid = prov.ProviderUid
	INNER JOIN @InitiatedReferrals ir on pr.PatientReferralUid = ir.PatientReferralUid
	)


	--SELECT * FROM cte_Ref
	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
		SELECT @ItemDefinitionUid AS ItemDefinitionUid
				,PatUid
				,COUNT(distinct CASE WHEN MedicationAllergiesReconciledDate IS NOT NULL 
						AND MedicationsReconciledDate IS NOT NULL
						AND ProblemsReconciledDate IS NOT NULL
							THEN Uid
						WHEN AttachmentTypeUid = '91293E86-6AA1-4B30-AA00-7DDD42135D64' THEN Uid
						WHEN AttachmentTypeID = 'DMail' THEN Uid
							ELSE NULL END) AS NumeratorValue
				,COUNT(DISTINCT Uid) AS DenominatorValue
				,NULL AS YesNo
		FROM cte_Ref
		GROUP BY PatUid


	IF EXISTS (
		SELECT TOP 1 *
		FROM #tblMeaningfulUseDetail
		WHERE [ItemDefinitionUid] = @ItemDefinitionUid
	)
    BEGIN
	    UPDATE [#tblMeaningfulUseDetail]
		SET [NumeratorValue] = CASE WHEN [NumeratorValue] > [DenominatorValue] THEN [DenominatorValue] ELSE [NumeratorValue] END
    END
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2022PI_HealthInformationExchange_2_Receiving -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2022PI_ProviderToPatientExchange]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2022PI_ProviderToPatientExchange] AS' 
END
GO
ALTER PROC [dbo].[2022PI_ProviderToPatientExchange]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

	IF (@Debug = 1)
	BEGIN
		SELECT '2022PI_ProviderToPatientExchange-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = 'CE15C31B-31AD-4F83-9653-C09C0C60E61F'

	TRUNCATE TABLE [#MetricDataTemp]

	-- Populate Denominator Value
	INSERT INTO [#tblMeaningfulUseDetail] ([ItemDefinitionUid]
		, [PersonUid]
		, [NumeratorValue]
		, [DenominatorValue]
		, [YesNo]
	)
	SELECT @ItemDefinitionUid AS [ItemDefinitionUid]
		, p.PersonUid
		, COUNT(DISTINCT CASE WHEN p.[HasPortalAccount] <> 0 THEN p.[PersonUid]
				ELSE NULL END)AS [NumeratorValue]           
		, COUNT(DISTINCT p.[PersonUid]) AS [DenominatorValue]
		, null AS [YesNo]
	FROM  [#tblPatientList] AS p
	WHERE (p.[IsEM] <> 0 OR p.IsVP <> 0)
	GROUP BY p.[PersonUid]
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2022PI_ProviderToPatientExchange -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2022PI_Master_DesktopControl]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2022PI_Master_DesktopControl] AS' 
END
GO
ALTER PROC [dbo].[2022PI_Master_DesktopControl]
(
	@ProviderUid			[varchar](max) = NULL,  
	@RptTimespan_StartDate	[date],
	@RptTimespan_EndDate	[date],
	@ProviderBilling		[bit] = 1,
	@ProviderRendering		[bit] = 0,
	@Debug					[int] = 0,
	@includetestpat			[bit] = 0,
	@ServiceSiteUID			[varchar](max) = null, 
	@FinancialCenterUID		[varchar](max) = null
)
AS
BEGIN

SET NOCOUNT ON;
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;
	--
	-- Calling syntax :    
	--
	--

	IF (@RptTimespan_StartDate IS NULL)
	BEGIN
		SET @RptTimespan_StartDate = '01-01-1900'
	END 
	IF (@RptTimespan_EndDate IS NULL)
	BEGIN
		SET @RptTimespan_EndDate = GETDATE()
	END 

	CREATE TABLE [#tblProviderList]
	(
		[ProviderUid] [uniqueidentifier] NOT NULL primary key clustered
	)
	 	 
	DECLARE @HasProviderUid [bit] = 0
	EXEC [2019PI_Master_PopulateProviderList] @ProviderUid, @HasProviderUid out

	-- Measure stored procedure flag indicating Meaningful Use data will be used for a report
	DECLARE @ReportMode [bit] = 0

	IF NOT EXISTS (SELECT 1 FROM sysobjects WHERE Name='cus_PDMP_Pats' and XType='U')
		EXEC FillPDMPPatsTable
		

	CREATE TABLE [#tblVisitList]
	(
		[VisitUid]							[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[VisitDate]							[date]         NOT NULL,
		[PatientUid]						[uniqueidentifier] NOT NULL,
		[TestPat]					   		[bit],
		[IsEM]								[bit],
		[IsVP]								[bit],
		[ProviderUid]						[varchar](max),
		[RenderingProviderUid]				[varchar](max),
		[LastSavedByUid]					[uniqueidentifier],
		[SavedByBillingProvider]			[bit],
		[SavedByRenderingProvider]			[bit],
		[TransitionOfCare]					[bit],
		[MedicationChecked]					[bit],
		[DrugAllergyChecked]				[bit],
		[ProblemChecked]					[bit],
		[SummaryProvidedToPatient]			[date],
		[PatientDeclinedClinicalSummary]	[bit],
		[HasEduForm]						[bit],
		[HasPortalAccount]					[bit],
		[PrintedDate]						[date]
	)
	--
	-- PopulateVisitList
	EXEC [2019PI_Master_PopulateVisitList] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@Debug,
		@ServiceSiteUID,
		@FinancialCenterUID
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblVisitList]
		ORDER BY [VisitDate] DESC 
	END

	CREATE TABLE [#tblPatientList] 
	(
		[PersonUid]					[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[PatientLnFn]				[varchar](250),
		[Birthdate]					[date],
		[TestPat]					[bit],
		[IsEM]						[bit],
		[IsVP]						[bit],
		[FullDemographics]			[bit],
		[HasEduForm]				[bit],
		[EduFormPrinted]			[bit],
		[HasPortalAccount]			[bit],
		[PortalPerson]				[uniqueidentifier] NULL,
		[PortalValid]				[date] NULL,
		[PortalExpire]				[date] NULL,
		[SummaryProvidedToPatient]	[bit],
		[TransitionOfCare]			[bit],
		[MedicationChecked]			[bit],
		[SavedByBillingProvider]	[bit],
		[SavedByRenderingProvider]	[bit],
		[YearsOldOrOlder2]			[bit] NULL,
		[YearsOldOrOlder3]			[bit] NULL,
		[YearsOldOrYounger5]		[bit] NULL, 
		[YearsOldOrOlder13]			[bit] NULL,
		[YearsOldOrOlder65]			[bit] NULL
	)
	--
	-- Populate Patient List
	EXEC [2019PI_Master_PopulatePatientList] @ProviderUid, 
			@RptTimespan_StartDate,
			@RptTimespan_EndDate,
			@ProviderBilling,
			@ProviderRendering,
			@Debug

	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblPatientList]
		ORDER BY [PatientLnFn]
	END

	--back fill #tblVisitList with patient specific information
	--delete test patient records from #tblVisitList AND #tblPatientList IF @includetestpat = 0
	EXEC [2019PI_Master_SynchronizeVisitAndPatient] @Debug = @Debug,
		@IncludeTestPatients = @includetestpat

	-- Build list of Medications that are within reporting range
	CREATE TABLE #tblMedicationList
	(
		[MedicationSIGUid]					[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[CreatedDate]						[datetime] NOT NULL,
		[RelVisitMedicationUid]				[uniqueidentifier],
		[PersonUid]							[uniqueidentifier],
		[TestPat]							[bit],
		[LicensedHealthcareProfessional]	[bit] NOT NULL,
		[Dispensable]						[bit] NULL,
		[IsSampleGiven]						[bit] NOT NULL,
		[IsAdministered]					[bit] NOT NULL,
		[reffederaldeaclasscode]			[int] NULL,
		[SIGDetailCount]					[int] NULL,
		[eRxStatusUid]						[uniqueidentifier]
	)
	--
	-- PopulateMedicationList
	EXEC [2019PI_Master_PopulateMedicationList]
		@ProviderUid
		, @ProviderBilling
		, @RptTimespan_StartDate
		, @RptTimespan_EndDate
		, @includetestpat
		, @Debug
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblMedicationList]
		ORDER BY [CreatedDate] DESC 
	END

	-- Build list of Orders that are within reporting range
	CREATE TABLE [#tblOrderList]
	(
		[ObservationOrderUid]				[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[PatientUid]						[uniqueidentifier] NOT NULL,
		[TestPat]					   		[bit],
		[VPUid]								[uniqueidentifier] NULL,
		[CreatedBy]							[uniqueidentifier] NULL,
		[OrderDate]							[datetime]         NOT NULL,
		[ProcedureCodeTypeUid]				[uniqueidentifier] NULL,
		[ProcedureCodeTypeName]				[varchar](500)     NULL,
		[AttachmentTypeUid]					[uniqueidentifier] NULL,
		[AttachmentTypeName]				[varchar](500)	NULL,
		[LicensedHealthcareProfessional]	[bit]			NOT NULL,
		[ImageResultsDirectlyAccessible]	[bit]			NULL,
		[ResultStatusID]					[int]			NULL
	)
	--
	-- PopulateOrderList
	EXEC [2019PI_Master_PopulateOrderList] @ProviderUid
		, @ProviderBilling
		, @RptTimespan_StartDate
		, @RptTimespan_EndDate
		, @includetestpat
		, @Debug
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblOrderList]
		ORDER BY [OrderDate] DESC 
	END

	-- Create work table that will hold the Meaningful Use results
	CREATE TABLE [#tblMeaningfulUseDetail] 
	(
		[RowId]               [int] IDENTITY(1,1) PRIMARY KEY,     -- Primary Key
		[ItemDefinitionUid]   [uniqueidentifier],                  -- MeaningfulUseItemDefinition.ItemDefinitionUid   
		[PersonUid]           [uniqueidentifier] NULL,             -- Unique list of Visit.PatientUid
		[NumeratorValue]      [int] NULL,                          -- See MeaningfulUseItemDefinition.NumeratorDesc
		[DenominatorValue]    [int] NULL,                          -- See MeaningfulUseItemDefinition.DenominatorDesc
		[YesNo]               [int] NULL                           -- See MeaningfulUseItemdefinition.YesNo.  Null-NA, 0-No/False, 1-Yes/True.
		unique clustered ([RowId])
	)  

	CREATE NONCLUSTERED INDEX [MUDetail_ItemDef_PersonUid] ON [#tblMeaningfulUseDetail]
	(
		[ItemDefinitionUid] ASC,
		[PersonUid] ASC
	)
	WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

	-- Create temp table that can be used by measure procs
	CREATE TABLE [#MetricDataTemp]
	(
		[PersonUid]							[uniqueidentifier] NOT NULL,
		[HeightRecorded]					[int] NULL,
		[WeightRecorded]					[int] NULL,
		[BloodPressureRecorded]				[int] NULL,
		[LabResultTotalCount]				[int] NULL, 
		[LabResultTemplatedCount]			[int] NULL,
		[TaskDocGenCount]					[int] NULL, 
		[TaskDocGenCompleteCount]			[int] NULL,   
		[VisitCount]						[int] NULL, 
		[ClinicalSummaryProvidedCount]		[int] NULL,  
		[PreventativeFollowupDueCount]		[int] NULL, 
		[PreventativeFollowupSentCount]		[int] NULL,   
		[SeenByAnotherProviderCount]		[int] NULL, 
		[MedicalCheckedCount]				[int] NULL,  
		[ReferralCount]						[int] NULL, 
		[ReferralClinicalSummaryProvided]	[int] NULL
	) 	
	
	-- Proc based on MUII_Master_DesktopControl
	--  
	-- Calculate Measures
	EXEC [2022PI_E-Prescribing_1_NonControlled] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2022PI_E-Prescribing_2_Controlled] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2022PI_E-Prescribing_3_PDMP] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE
		
	EXEC [2022PI_HealthInformationExchange_1_Sending] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2022PI_HealthInformationExchange_2_Receiving] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2022PI_ProviderToPatientExchange] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	-- Drop temp tables that are used by measure procs
	BEGIN TRY
		DROP TABLE [#tblVisitList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#tblPatientList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#tblProviderList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#MetricDataTemp]
	END TRY 
	BEGIN CATCH
	END CATCH

	-- Define table that will be returned to caller
	DECLARE @tblMeaingfulUseSummaryCoreAndMenuSet TABLE
	(
		[RowId]             [int] IDENTITY(1,1) PRIMARY KEY,
		[ItemDefinitionUid] [uniqueidentifier],
		[CategoryNumber]    [int] NULL,
		[CategoryName]      [varchar](100) NULL,
		[MeasureNumber]     [int] NULL, 
		[SubMeasureNumber]  [int] NULL,
		[MeasureDesc]       [varchar](500) NULL,
		[DenominatorDesc]   [varchar](250) NULL,
		[DenominatorValue]  [int] NULL,
		[NumeratorDesc]     [varchar](250) NULL,
		[NumeratorValue]    [int] NULL,
		[YesNo]     [varchar](50)  NULL,
		[CurrentValue]	  [varchar](25)  NULL,
		[GoalDesc]          [varchar](250) NULL,
		[GoalValue]         [varchar](10)  NULL,
		[MetGoal]           [bit] NULL, 
		[ProviderUid]       [varchar](max) NULL,
		[ProviderLnFn]      [varchar](150) NULL,       
		unique clustered  ([RowId])
	) 

	-- Determine if there are any MU detail rows to base metrics against
	DECLARE @NumDetailRows [int]

	-- Walk through list of defined Meaningful Use metrics and popluate @tblMeaingfulUseSummaryCoreAndMenuSet 
	DECLARE @ItemDefinitionUid [uniqueidentifier]
		, @CategoryUid [uniqueidentifier]
		, @CategoryNumber [int]
		, @CategoryName [varchar](100)
		, @MeasureNumber [int]
		, @SubMeasureNumber [int]
		, @MeasureDesc [varchar](500)
		, @ExclusionDesc [varchar](250)
		, @DenominatorDesc [varchar](250)
		, @NumeratorDesc [varchar](250)
		, @YesNo [varchar](50)
		, @GoalDesc [varchar](250)
		, @GoalValue [decimal](5, 2)
		, @DenominatorSumValue [int]
		, @NumeratorSumValue [int]
		, @CurValue [varchar](25)
		, @MetGoal [bit]    
        
    --
    -- Populate table that will be returned to caller
	DECLARE cursor_MU_Definitions CURSOR FAST_FORWARD FOR 
		SELECT muid.[ItemDefinitionUid]
			, muid.[CategoryUid]
			, mucd.[CategoryNumber]
			, mucd.[CategoryName]
			, muid.[MeasureNumber]
			, muid.[SubMeasureNumber]
			, muid.[MeasureDesc]
			, muid.[ExclusionDesc]
			, muid.[DenominatorDesc]
			, muid.[NumeratorDesc]
			, muid.[YesNo]
			, muid.[GoalDesc]
			, muid.[GoalValue]
		FROM [MeaningfulUseItemDefinition] AS muid with(nolock)
			INNER JOIN [MeaningfulUseCategoryDefinition] AS mucd with(nolock) ON muid.[CategoryUid] = mucd.[CategoryUid]
/*Replace w/new StageUid*/		WHERE muid.[StageUid] = '6A0CB116-E484-49AF-98F3-99B7B2A142A8'   --2021 PI
		ORDER BY mucd.[CategoryName]
			, mucd.[CategoryNumber]
			, muid.[MeasureNumber]
    --
    OPEN cursor_MU_Definitions
    --
	FETCH NEXT FROM cursor_MU_Definitions 
		INTO @ItemDefinitionUid
			, @CategoryUid
			, @CategoryNumber
			, @CategoryName
			, @MeasureNumber
			, @SubMeasureNumber
			, @MeasureDesc
			, @ExclusionDesc
			, @DenominatorDesc
			, @NumeratorDesc
			, @YesNo
			, @GoalDesc
			, @GoalValue 
    --
   -- Make sure we have a valid cursor row
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @DenominatorSumValue = 0
		SET @NumeratorSumValue = 0
		SET @CurValue = '' 
		SET @MetGoal = 0 
		SET @NumDetailRows = 0
		
		-- Check if current MU metric has a numerator and denominator
		IF @YesNo IS NULL
		BEGIN
			-- Make sure we have some data for current metric
			SET @NumDetailRows = (SELECT COUNT(*)
								  FROM [#tblMeaningfulUseDetail]
								  WHERE [ItemDefinitionUid] = @ItemDefinitionUid
								 )
			IF (@NumDetailRows > 0)
			BEGIN
				-- Current MU metric has a numerator and demoninator
				SELECT  @DenominatorSumValue = SUM(mud.[DenominatorValue])
					, @NumeratorSumValue   = SUM(mud.[NumeratorValue]) 
				FROM     [#tblMeaningfulUseDetail] AS mud
				WHERE    mud.[ItemDefinitionUid] = @ItemDefinitionUid
				GROUP BY mud.[ItemDefinitionUid] 
			END    
           
			IF @DenominatorSumValue <= 0
			BEGIN
				SET @CurValue = 'N/A' 
			END 
			ELSE IF @NumeratorSumValue <= 0
			BEGIN 
				SET @CurValue = '0.00%' 
			END 
			ELSE 
			BEGIN 
				-- Calculate current MU metric value
				SET @CurValue = CONVERT(VARCHAR(10), CONVERT(DECIMAL(8,2), (CONVERT(DECIMAL(8,2), @NumeratorSumValue) / CONVERT(DECIMAL(8,2), @DenominatorSumValue)) * 100)) + '%'
	                  
				-- Determine if goal is satisfied
				IF CONVERT(DECIMAL(8,2), (CONVERT(DECIMAL(8,2), @NumeratorSumValue) / CONVERT(DECIMAL(8,2), @DenominatorSumValue)) * 100) > @GoalValue
				BEGIN
					SET @MetGoal = 1
				END 
			END 
             
			-- Insert MU summary row
			INSERT INTO @tblMeaingfulUseSummaryCoreAndMenuSet ([ItemDefinitionUid]
				, [CategoryNumber]
				, [CategoryName]
				, [MeasureNumber]
				, [SubMeasureNumber]
				, [MeasureDesc]
				, [DenominatorDesc]
				, [DenominatorValue]
				, [NumeratorDesc]
				, [NumeratorValue]
				, [YesNo]
				, [CurrentValue]
				, [GoalDesc]
				, [GoalValue]
				, [MetGoal]
				, [ProviderUid]
				, [ProviderLnFn]
			)   
			VALUES (@ItemDefinitionUid
				, @CategoryNumber
				, @CategoryName
				, @MeasureNumber
				, @SubMeasureNumber
				, @MeasureDesc
				, @DenominatorDesc
				, @DenominatorSumValue
				, @NumeratorDesc
				, @NumeratorSumValue
				, @YesNo
				, @CurValue
				, @GoalDesc
				, CONVERT([varchar](10), @GoalValue)
				, @MetGoal
				, null
				, null
			)  
		END 
		ELSE 
		BEGIN
			-- Current MU metric is YES/NO.  
			INSERT INTO @tblMeaingfulUseSummaryCoreAndMenuSet([ItemDefinitionUid]
				, [CategoryNumber]
				, [CategoryName]
				, [MeasureNumber]
				, [SubMeasureNumber]
				, [MeasureDesc]
				, [DenominatorDesc]
				, [DenominatorValue]
				, [NumeratorDesc]
				, [NumeratorValue]
				, [YesNo]
				, [CurrentValue]
				, [GoalDesc]
				, [GoalValue]
				, [MetGoal]
				, [ProviderUid]
				, [ProviderLnFn]
			)  
			VALUES (@ItemDefinitionUid
				, @CategoryNumber
				, @CategoryName
				, @MeasureNumber
				, @SubMeasureNumber
				, @MeasureDesc
				, @DenominatorDesc
				, null
				, @NumeratorDesc
				, null
				, @YesNo
				, null
				, @GoalDesc
				, null
				, null
				, null
				, null
			)  
		END
		-- 
		-- Get next cursor_MU_Definitions row
		FETCH NEXT FROM cursor_MU_Definitions INTO @ItemDefinitionUid
			, @CategoryUid
			, @CategoryNumber
			, @CategoryName
			, @MeasureNumber
			, @SubMeasureNumber
			, @MeasureDesc
			, @ExclusionDesc
			, @DenominatorDesc
			, @NumeratorDesc
			, @YesNo
			, @GoalDesc
			, @GoalValue 
    END
    --
    -- Close and Deallocate cursor
    CLOSE cursor_MU_Definitions
    DEALLOCATE cursor_MU_Definitions
	
	-- Return Meaningful Use results to caller
	SELECT 'MeaingfulUseSummaryCoreAndMenuSet'
	SELECT [RowId]
		, [ItemDefinitionUid]
		, [CategoryNumber]
		, [CategoryName]
		, [MeasureNumber]
		, [SubMeasureNumber]
		, [MeasureDesc]
		, [DenominatorDesc]
		, [DenominatorValue]
		, [NumeratorDesc]
		, [NumeratorValue]
		, [YesNo]
		, [CurrentValue]
		, [GoalDesc]
		, [GoalValue]
		, [MetGoal]
		, [ProviderUid]
		, [ProviderLnFn]
	FROM @tblMeaingfulUseSummaryCoreAndMenuSet    
	ORDER BY [CategoryNumber] ASC
		, [MeasureNumber] ASC
		, [SubMeasureNumber] ASC 
	
	IF (@Debug <> 0)
	BEGIN
		SELECT 'GOOD BYE'
	END 
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2022PI_Master_Report]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2022PI_Master_Report] AS' 
END
GO
ALTER PROC [dbo].[2022PI_Master_Report]
(
	@ReportInstanceUid		[uniqueidentifier],
	@ProviderUid			[varchar](max) = NULL, 
	@RptTimespan_StartDate	[date],
	@RptTimespan_EndDate	[date],
	@ProviderOption			[varchar](100) = 'Billing Provider', --	Billing Provider and Rendering Provider 
	@Debug					[int] = 0,
	@includetestpat			[bit] = 0,
	@ServiceSiteUID			[varchar](max) = null, 
	@FinancialCenterUID		[varchar](max) = null
)
AS
BEGIN
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;
	--
	--  

	IF (@RptTimespan_StartDate IS NULL)
	BEGIN
		SET @RptTimespan_StartDate = '01-01-1900'
	END 
	IF (@RptTimespan_EndDate IS NULL)
	BEGIN
		SET @RptTimespan_EndDate = GETDATE()
	END

	CREATE TABLE [#tblProviderList]
	(
		[ProviderUid] [uniqueidentifier] NOT NULL primary key clustered
	)
	 
	DECLARE @HasProviderUid [bit] = 0
	EXEC [2019PI_Master_PopulateProviderList] @ProviderUid, @HasProviderUid out

	DECLARE @ClaimFormatValueTypeProviderNPIUid [uniqueidentifier] = 'CE282F4E-A866-49BA-9636-C4BA0439E907',
		@ReportMode [bit] = 1,
		@ProviderBilling [bit] = 0,
		@ProviderRendering [bit] = 0,
		@ProviderNPI [varchar](100) = null

	-- Find the first provider has provider NPI

	SELECT TOP 1 @ProviderNPI = [Value]
	FROM [ClaimFormatValue] with(nolock)
	WHERE [ClaimFormatValueTypeUid] = @ClaimFormatValueTypeProviderNPIUid
		AND [ProviderUid] IN (SELECT [ProviderUid] FROM [#tblProviderList])

	-- Set local Billing and Rendering Provider Flags
	IF (@ProviderOption = 'Billing Provider')
	BEGIN
		SET @ProviderBilling = 1
		SET @ProviderRendering = 0
	END
	ELSE
	BEGIN
		SET @ProviderBilling = 0
		SET @ProviderRendering = 1	
	END

	IF NOT EXISTS (SELECT 1 FROM sysobjects WHERE Name='cus_PDMP_Pats' and XType='U')
		EXEC FillPDMPPatsTable

	-- Measure stored procedure flag indicating Meaningful Use data will be used for a report
CREATE TABLE [#tblVisitList]
	(
		[VisitUid]							[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[VisitDate]							[date]         NOT NULL,
		[PatientUid]						[uniqueidentifier] NOT NULL,
		[TestPat]					   		[bit],
		[IsEM]								[bit],
		[IsVP]								[bit],
		[ProviderUid]						[varchar](max),
		[RenderingProviderUid]				[varchar](max),
		[LastSavedByUid]					[uniqueidentifier],
		[SavedByBillingProvider]			[bit],
		[SavedByRenderingProvider]			[bit],
		[TransitionOfCare]					[bit],
		[MedicationChecked]					[bit],
		[DrugAllergyChecked]				[bit],
		[ProblemChecked]					[bit],
		[SummaryProvidedToPatient]			[date],
		[PatientDeclinedClinicalSummary]	[bit],
		[HasEduForm]						[bit],
		[HasPortalAccount]					[bit],
		[PrintedDate]						[date]
	)
	--
	-- PopulateVisitList
	EXEC [2019PI_Master_PopulateVisitList] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@Debug,
		@ServiceSiteUID,
		@FinancialCenterUID

	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblVisitList]
		ORDER BY [VisitDate] DESC 
	END

	CREATE TABLE [#tblPatientList] 
	(
		[PersonUid]					[uniqueidentifier] NOT NULL primary key clustered,
		[PatientLnFn]				[varchar](250),
		[Birthdate]					[date],
		[TestPat]					[bit],
		[IsEM]						[bit],
		[IsVP]						[bit],
		[FullDemographics]			[bit],
		[HasEduForm]				[bit],
		[EduFormPrinted]			[bit],
		[HasPortalAccount]			[bit],
		[PortalPerson]				[uniqueidentifier] NULL,
		[PortalValid]				[date] NULL,
		[PortalExpire]				[date] NULL,
		[SummaryProvidedToPatient]	[bit],
		[TransitionOfCare]			[bit],
		[MedicationChecked]			[bit],
		[SavedByBillingProvider]	[bit],
		[SavedByRenderingProvider]	[bit],
		[YearsOldOrOlder2]			[bit] NULL,
		[YearsOldOrOlder3]			[bit] NULL,
		[YearsOldOrYounger5]		[bit] NULL, 
		[YearsOldOrOlder13]			[bit] NULL,
		[YearsOldOrOlder65]			[bit] NULL
	)
	--
	-- Populate Patient List
	EXEC [2019PI_Master_PopulatePatientList] 
			@ProviderUid, 
			@RptTimespan_StartDate,
			@RptTimespan_EndDate,
			@ProviderBilling,
			@ProviderRendering,
			@Debug

	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblPatientList]
		ORDER BY [PatientLnFn]
	END

	--back fill #tblVisitList with patient specific information
	--delete test patient records from #tblVisitList AND #tblPatientList IF @includetestpat = 0
	EXEC [2019PI_Master_SynchronizeVisitAndPatient] @Debug = @Debug,
		@IncludeTestPatients = @includetestpat

	-- Build list of Medications that are within reporting range
	CREATE TABLE [#tblMedicationList]
	(
		[MedicationSIGUid]					[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[CreatedDate]						[datetime] NOT NULL,
		[RelVisitMedicationUid]				[uniqueidentifier],
		[PersonUid]							[uniqueidentifier],
		[TestPat]							[bit],
		[LicensedHealthcareProfessional]	[bit] NOT NULL,
		[Dispensable]						[bit] NULL,
		[IsSampleGiven]						[bit] NOT NULL,
		[IsAdministered]					[bit] NOT NULL,
		[reffederaldeaclasscode]			[int] NULL,
		[SIGDetailCount]					[int] NULL,
		[eRxStatusUid]						[uniqueidentifier]
	)
	--
	-- PopulateMedicationList
	EXEC [2019PI_Master_PopulateMedicationList] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@includetestpat,
		@Debug
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblMedicationList]
		ORDER BY [CreatedDate] DESC 
	END

	-- Build list of Orders that are within reporting range
	CREATE TABLE [#tblOrderList]
	(
		[ObservationOrderUid]				[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[PatientUid]						[uniqueidentifier] NOT NULL,
		[TestPat]					 		[bit],
		[VPUid]								[uniqueidentifier] NULL,
		[CreatedBy]							[uniqueidentifier] NULL,
		[OrderDate]							[datetime] NOT NULL,
		[ProcedureCodeTypeUid]				[uniqueidentifier] NULL,
		[ProcedureCodeTypeName]				[varchar](500) NULL,
		[AttachmentTypeUid]					[uniqueidentifier] NULL,
		[AttachmentTypeName]				[varchar](500) NULL,
		[LicensedHealthcareProfessional]	[bit] NOT NULL,
		[ImageResultsDirectlyAccessible]	[bit] NULL,
		[ResultStatusID]					[int] NULL
	)
	--
	-- PopulateOrderList
	EXEC [2019PI_Master_PopulateOrderList] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@includetestpat,
		@Debug
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblOrderList]
		ORDER BY [OrderDate] DESC 
	END

	-- Create work table that will hold the Meaningful Use results
	CREATE TABLE [#tblMeaningfulUseDetail] 
	(
		[RowId]				[int] IDENTITY(1,1) PRIMARY KEY, -- Primary Key
		[ItemDefinitionUid]	[uniqueidentifier], -- MeaningfulUseItemDefinition.ItemDefinitionUid
		[CategoryName]		[varchar](500) NULL, -- MeaningfulUseCategoryDefinition.CategoryName
		[CategoryNumber]	[int] NULL, -- MeaningfulUseCategoryDefinition.CategoryNumber
		[MeasureNumber]		[int] NULL, -- MeaningfulUseItemDefinition.MeasureNumber 
		[SubMeasureNumber]	[int] NULL, -- MeaningfulUseItemDefinition.SubMeasureNumber
		[PersonUid]			[uniqueidentifier] NULL, -- Unique list of Visit.PatientUid
		[PersonLnFn]		[varchar](150) NULL, -- Patient name
		[ProviderUid]		[varchar](MAX) NULL,
		[ProviderLnFn]		[varchar](150) NULL, 
		[NumeratorValue]	[int] NULL, -- See MeaningfulUseItemDefinition.NumeratorDesc
		[DenominatorValue]	[int] NULL, -- See MeaningfulUseItemDefinition.DenominatorDesc
		[YesNo]				[int] NULL -- See MeaningfulUseItemdefinition.YesNo. Null-NA, 0-No/False, 1-Yes/True.
		unique clustered (RowId)
	) 
 
	CREATE NONCLUSTERED INDEX [MUDetail_ItemDef_PersonUid] ON #tblMeaningfulUseDetail
	(
		ItemDefinitionUid ASC,
		PersonUid ASC
	)
	WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]


	-- Params used in determining if any detail rows were found for given metric
	CREATE TABLE [#tblMetricUidsWithoutDetailRows] 
	(
		[ItemDefinitionUid] [uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED
	)

	-- Create temp table that can be used by measure procs
	CREATE TABLE [#MetricDataTemp]
	(
		[PersonUid] [uniqueidentifier] NOT NULL,
		[HeightRecorded] [int] NULL,
		[WeightRecorded] [int] NULL,
		[BloodPressureRecorded] [int] NULL,
		[LabResultTotalCount] [int] NULL, 
		[LabResultTemplatedCount] [int] NULL,
		[TaskDocGenCount] [int] NULL, 
		[TaskDocGenCompleteCount] [int] NULL, 
		[VisitCount] [int] NULL, 
		[ClinicalSummaryProvidedCount] [int] NULL, 
		[PreventativeFollowupDueCount] [int] NULL, 
		[PreventativeFollowupSentCount] [int] NULL, 
		[SeenByAnotherProviderCount] [int] NULL, 
		[MedicalCheckedCount] [int] NULL, 
		[ReferralCount] [int] NULL, 
		[ReferralClinicalSummaryProvided] [int] NULL
	) 	

	-- Proc based on MUII_Master_DesktopControl
	--  
	-- Calculate Measures
	-- ACI_TRANS_PPHI_1 == Objective 1 == MUII Core Measure 9
	-- Must attest yes

	-- ACI_TRANS_EP_1 == Objective 4 == MUII Core Measure 2, Sub Measure NULL; ItemDefinitionUid : F3A49E2B-E4FF-4D78-A3D5-EEA12A5FBF58
	EXEC [2022PI_E-Prescribing_1_NonControlled] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2022PI_E-Prescribing_2_Controlled] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2022PI_E-Prescribing_3_PDMP] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2022PI_HealthInformationExchange_1_Sending] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2022PI_HealthInformationExchange_2_Receiving] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE
		
	EXEC [2022PI_ProviderToPatientExchange] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	-- Drop temp tables that are used by measure procs
	BEGIN TRY
		DROP TABLE [#tblVisitList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#tblPatientList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#tblProviderList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#MetricDataTemp]
	END TRY 
	BEGIN CATCH
	END CATCH

	-- For measures that do not have any detail rows, we need to insert a row, so it will be included in the RDL report.
	DECLARE @NumDetailRows [int]
	SET @NumDetailRows = (SELECT COUNT(*) FROM [#tblMetricUidsWithoutDetailRows])
	IF (@NumDetailRows > 0)
	BEGIN
		INSERT INTO [#tblMeaningfulUseDetail] ([ItemDefinitionUid],
			[CategoryNumber],
			[CategoryName],
			[MeasureNumber],
			[SubMeasureNumber],
			[PersonUid],
			[PersonLnFn],
			[ProviderUid],
			[ProviderLnFn],
			[NumeratorValue],
			[DenominatorValue],
			[YesNo]
		)
			SELECT NoData.[ItemDefinitionUid] AS [ItemDefinitionUid]
			,(
				select mucd.[CategoryNumber] 
				from [MeaningfulUseItemDefinition] AS muid with(nolock)
					inner join [MeaningfulUseCategoryDefinition] AS mucd with(nolock) on muid.[CategoryUid] = mucd.[CategoryUid]
				where muid.[ItemDefinitionUid] = NoData.[ItemDefinitionUid]
			) AS [CategoryNumber]

			,(
				select mucd.CategoryName
				from [MeaningfulUseItemDefinition] AS muid with(nolock)
					inner join [MeaningfulUseCategoryDefinition] AS mucd with(nolock) on muid.[CategoryUid] = mucd.[CategoryUid]
				where muid.[ItemDefinitionUid] = NoData.[ItemDefinitionUid]
			) AS [CategoryName]

			,(
				select muid.[MeasureNumber]
				from [MeaningfulUseItemDefinition] AS muid with(nolock)
					inner join [MeaningfulUseCategoryDefinition] AS mucd with(nolock) on muid.[CategoryUid] = mucd.[CategoryUid]
				where muid.[ItemDefinitionUid] = NoData.[ItemDefinitionUid]
			) AS [MeasureNumber] 

			,(
				select muid.[SubMeasureNumber] 
				from [MeaningfulUseItemDefinition] AS muid with(nolock)
					inner join [MeaningfulUseCategoryDefinition] AS mucd with(nolock) on muid.[CategoryUid] = mucd.[CategoryUid]
				where muid.[ItemDefinitionUid] = NoData.[ItemDefinitionUid]
			) AS [SubMeasureNumber] 

			,NULL AS [PersonUid] 
			,'N / A' AS [PersonLnFn]
			,NULL AS [ProviderUid] 
			,'' AS [ProviderLnFn]
			,0 AS [NumeratorValue]
			,0 AS [DenominatorValue]
			,0 AS [YesNo]
		FROM [#tblMetricUidsWithoutDetailRows] AS [NoData] 
	END

	--
	-- For measures that are Yes/No (Must attest Yes), insert a detail row that will be included in the RDL report
	--

	---- ACI_TRANS_PPHI_1 == Objective 1 == MUII Core Measure 9
	DECLARE @ItemDefinitionUid [uniqueidentifier] --= '1D8DEE46-CB1A-45DD-B0FF-FE04DDBD1310' 
	--EXEC [MUI_Master_Report_InsertAttestMeasureDetail] @ItemDefinitionUid, @ReportMode,	@Debug

	---- Pick 2 registries
	--SET @ItemDefinitionUid = 'CC4FF4BA-CA32-41F7-A157-5426E59C81AE' 
	--EXEC [MUI_Master_Report_InsertAttestMeasureDetail] @ItemDefinitionUid, @ReportMode, @Debug

	-- Define table that will be returned to caller
	DECLARE @tblMeaingfulUseSummaryCoreAndMenuSet TABLE
	(
		[RowId]             [int] IDENTITY(1,1) PRIMARY KEY,
		[ItemDefinitionUid] [uniqueidentifier],
		[CategoryNumber]    [int] NULL,
		[CategoryName]      [varchar](100) NULL,
		[MeasureNumber]     [int] NULL, 
		[SubMeasureNumber]  [int] NULL,
		[MeasureDesc]       [varchar](500) NULL,
		[DenominatorDesc]   [varchar](250) NULL,
		[DenominatorValue]  [int] NULL,
		[NumeratorDesc]     [varchar](250) NULL,
		[NumeratorValue]    [int] NULL,
		[YesNo]     [varchar](50)  NULL,
		[CurrentValue]	  [varchar](25)  NULL,
		[GoalDesc]          [varchar](250) NULL,
		[GoalValue]         [varchar](10)  NULL,
		[MetGoal]           [bit] NULL, 
		[ProviderUid]       [varchar](max) NULL,
		[ProviderLnFn]      [varchar](150) NULL,       
		unique clustered  ([RowId])
	) 

	-- Determine if there are any MU detail rows to base metrics against
	-- Walk through list of defined Meaningful Use metrics and popluate @tblMeaingfulUseSummaryCoreAndMenuSet 
	DECLARE @CategoryUid [uniqueidentifier]
		, @CategoryNumber [int]
		, @CategoryName [varchar](100)
		, @MeasureNumber [int]
		, @SubMeasureNumber [int]
		, @MeasureDesc [varchar](500)
		, @ExclusionDesc [varchar](250)
		, @DenominatorDesc [varchar](250)
		, @NumeratorDesc [varchar](250)
		, @YesNo [varchar](50)
		, @GoalDesc [varchar](250)
		, @GoalValue [decimal](5, 2)
		, @DenominatorSumValue [int]
		, @NumeratorSumValue [int]
		, @CurValue [varchar](25)
		, @MetGoal [bit]    
        
    --
    -- Populate table that will be returned to caller
	DECLARE cursor_MU_Definitions CURSOR FAST_FORWARD FOR 
		SELECT muid.[ItemDefinitionUid]
			, muid.[CategoryUid]
			, mucd.[CategoryNumber]
			, mucd.[CategoryName]
			, muid.[MeasureNumber]
			, muid.[SubMeasureNumber]
			, muid.[MeasureDesc]
			, muid.[ExclusionDesc]
			, muid.[DenominatorDesc]
			, muid.[NumeratorDesc]
			, muid.[YesNo]
			, muid.[GoalDesc]
			, muid.[GoalValue]
		FROM [MeaningfulUseItemDefinition] AS muid with(nolock)
			INNER JOIN [MeaningfulUseCategoryDefinition] AS mucd with(nolock) ON muid.[CategoryUid] = mucd.[CategoryUid]
/*Replace w/new StageUid*/		WHERE muid.[StageUid] = '6A0CB116-E484-49AF-98F3-99B7B2A142A8'   -- 2021 PI
		ORDER BY mucd.[CategoryName]
			, mucd.[CategoryNumber]
			, muid.[MeasureNumber]
    --
    OPEN cursor_MU_Definitions
    --
	FETCH NEXT FROM cursor_MU_Definitions 
		INTO @ItemDefinitionUid
			, @CategoryUid
			, @CategoryNumber
			, @CategoryName
			, @MeasureNumber
			, @SubMeasureNumber
			, @MeasureDesc
			, @ExclusionDesc
			, @DenominatorDesc
			, @NumeratorDesc
			, @YesNo
			, @GoalDesc
			, @GoalValue 
    --
   -- Make sure we have a valid cursor row
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @DenominatorSumValue = 0
		SET @NumeratorSumValue = 0
		SET @CurValue = '' 
		SET @MetGoal = 0 
		SET @NumDetailRows = 0
		
		-- Check if current MU metric has a numerator and denominator
		IF @YesNo IS NULL
		BEGIN
			-- Make sure we have some data for current metric
			SET @NumDetailRows = (SELECT COUNT(*)
								  FROM [#tblMeaningfulUseDetail]
								  WHERE [ItemDefinitionUid] = @ItemDefinitionUid
								 )
			IF (@NumDetailRows > 0)
			BEGIN
				-- Current MU metric has a numerator and demoninator
				SELECT  @DenominatorSumValue = SUM(mud.[DenominatorValue])
					, @NumeratorSumValue   = SUM(mud.[NumeratorValue]) 
				FROM     [#tblMeaningfulUseDetail] AS mud
				WHERE    mud.[ItemDefinitionUid] = @ItemDefinitionUid
				GROUP BY mud.[ItemDefinitionUid] 
			END    
           
			IF @DenominatorSumValue <= 0
			BEGIN
				SET @CurValue = 'N/A' 
			END 
			ELSE IF @NumeratorSumValue <= 0
			BEGIN 
				SET @CurValue = '0.00%' 
			END 
			ELSE 
			BEGIN 
				-- Calculate current MU metric value
				SET @CurValue = CONVERT(VARCHAR(10), CONVERT(DECIMAL(8,2), (CONVERT(DECIMAL(8,2), @NumeratorSumValue) / CONVERT(DECIMAL(8,2), @DenominatorSumValue)) * 100)) + '%'
	                  
				-- Determine if goal is satisfied
				IF CONVERT(DECIMAL(8,2), (CONVERT(DECIMAL(8,2), @NumeratorSumValue) / CONVERT(DECIMAL(8,2), @DenominatorSumValue)) * 100) > @GoalValue
				BEGIN
					SET @MetGoal = 1
				END 
			END 
             
			-- Insert MU summary row
			INSERT INTO @tblMeaingfulUseSummaryCoreAndMenuSet ([ItemDefinitionUid]
				, [CategoryNumber]
				, [CategoryName]
				, [MeasureNumber]
				, [SubMeasureNumber]
				, [MeasureDesc]
				, [DenominatorDesc]
				, [DenominatorValue]
				, [NumeratorDesc]
				, [NumeratorValue]
				, [YesNo]
				, [CurrentValue]
				, [GoalDesc]
				, [GoalValue]
				, [MetGoal]
				, [ProviderUid]
				, [ProviderLnFn]
			)   
			VALUES (@ItemDefinitionUid
				, @CategoryNumber
				, @CategoryName
				, @MeasureNumber
				, @SubMeasureNumber
				, @MeasureDesc
				, @DenominatorDesc
				, @DenominatorSumValue
				, @NumeratorDesc
				, @NumeratorSumValue
				, @YesNo
				, @CurValue
				, @GoalDesc
				, CONVERT([varchar](10), @GoalValue)
				, @MetGoal
				, null
				, null
			)  
		END 
		ELSE 
		BEGIN
			-- Current MU metric is YES/NO.  
			INSERT INTO @tblMeaingfulUseSummaryCoreAndMenuSet([ItemDefinitionUid]
				, [CategoryNumber]
				, [CategoryName]
				, [MeasureNumber]
				, [SubMeasureNumber]
				, [MeasureDesc]
				, [DenominatorDesc]
				, [DenominatorValue]
				, [NumeratorDesc]
				, [NumeratorValue]
				, [YesNo]
				, [CurrentValue]
				, [GoalDesc]
				, [GoalValue]
				, [MetGoal]
				, [ProviderUid]
				, [ProviderLnFn]
			)  
			VALUES (@ItemDefinitionUid
				, @CategoryNumber
				, @CategoryName
				, @MeasureNumber
				, @SubMeasureNumber
				, @MeasureDesc
				, @DenominatorDesc
				, null
				, @NumeratorDesc
				, null
				, @YesNo
				, null
				, @GoalDesc
				, null
				, null
				, null
				, null
			)  
		END
		-- 
		-- Get next cursor_MU_Definitions row
		FETCH NEXT FROM cursor_MU_Definitions INTO @ItemDefinitionUid
			, @CategoryUid
			, @CategoryNumber
			, @CategoryName
			, @MeasureNumber
			, @SubMeasureNumber
			, @MeasureDesc
			, @ExclusionDesc
			, @DenominatorDesc
			, @NumeratorDesc
			, @YesNo
			, @GoalDesc
			, @GoalValue 
    END
    --
    -- Close and Deallocate cursor
    CLOSE cursor_MU_Definitions
    DEALLOCATE cursor_MU_Definitions

	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CUS_MeaningfulUseDetail]') AND type in (N'U'))
	BEGIN
	CREATE TABLE [dbo].[CUS_MeaningfulUseDetail](
		[MeaningfulUseDetailUid] [uniqueidentifier] NOT NULL,
		[ReportInstanceUid] [uniqueidentifier] NOT NULL,
		[ItemDefinitionUid] [uniqueidentifier] NULL,
		[CategoryName] [varchar](500) NULL,
		[CategoryNumber] [int] NULL,
		[MeasureNumber] [int] NULL,
		[SubMeasureNumber] [int] NULL,
		[PersonUid] [uniqueidentifier] NULL,
		[PersonLnFn] [varchar](150) NULL,
		[ProviderUid] [varchar](max) NULL,
		[ProviderLnFn] [varchar](150) NULL,
		[ProviderNPI] [varchar](250) NULL,
		[NumeratorValue] [int] NULL,
		[DenominatorValue] [int] NULL,
		[YesNo] [int] NULL,
		[ObjectiveDesc] [varchar](500) NULL,
		[MeasureDesc] [varchar](600) NOT NULL,
		[MeasureDetailDesc] [varchar](600) NULL,
		[ExclusionDesc] [varchar](600) NULL,
		[DenominatorDesc] [varchar](500) NULL,
		[NumeratorDesc] [varchar](500) NULL,
		[GoalDesc] [varchar](250) NULL,
		[LastModifiedDate] [datetime] NOT NULL,
	 CONSTRAINT [PK_CUS_MeaningfulUseDetail] PRIMARY KEY CLUSTERED 
	(
		[MeaningfulUseDetailUid] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
	END

	IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CUS_MeaningfulUseDetail]') AND name = N'IX_CUS_MeaningfulUseDetail')
		CREATE NONCLUSTERED INDEX [IX_CUS_MeaningfulUseDetail] ON [dbo].[CUS_MeaningfulUseDetail]
		(
			[ReportInstanceUid] ASC,
			[ItemDefinitionUid] ASC,
			[PersonUid] ASC
		)
		INCLUDE ( 	[CategoryName],
			[CategoryNumber],
			[MeasureNumber],
			[NumeratorValue],
			[DenominatorValue],
			[ExclusionDesc],
			[DenominatorDesc],
			[SubMeasureNumber],
			[PersonLnFn],
			[ProviderUid],
			[ProviderLnFn],
			[NumeratorDesc],
			[GoalDesc],
			[YesNo],
			[ObjectiveDesc],
			[MeasureDesc],
			[MeasureDetailDesc],
			[MeaningfulUseDetailUid],
			[ProviderNPI],
			[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF_CUS_MeaningfulUseDetail_MeaningfulUseDetailUid]') AND type = 'D')
	BEGIN
		ALTER TABLE [dbo].[CUS_MeaningfulUseDetail] ADD  CONSTRAINT [DF_CUS_MeaningfulUseDetail_MeaningfulUseDetailUid]  DEFAULT (newid()) FOR [MeaningfulUseDetailUid]
	END

	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF_CUS_MeaningfulUseDetail_LastModifiedDate]') AND type = 'D')
	BEGIN
		ALTER TABLE [dbo].[CUS_MeaningfulUseDetail] ADD  CONSTRAINT [DF_CUS_MeaningfulUseDetail_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
	END

	EXEC MIPS_2018_Master_Report_DeleteReportInstance @ReportInstanceUid
	--
	-- Return detail table to caller
	--
	INSERT [CUS_MeaningfulUseDetail](
		[ReportInstanceUid],
		[ItemDefinitionUid],
		[CategoryName],
		[CategoryNumber],
		[MeasureNumber],
		[SubMeasureNumber],
		[PersonUid],
		[PersonLnFn],
		[ProviderUid],
		[ProviderLnFn],
		[ProviderNPI],
		[NumeratorValue],
		[DenominatorValue],
		[YesNo],
		[ObjectiveDesc],
		[MeasureDesc],
		[MeasureDetailDesc],
		[ExclusionDesc],
		[DenominatorDesc],
		[NumeratorDesc],
		[GoalDesc]
	)
	SELECT @ReportInstanceUid AS [ReportInstanceUid],
		t.[ItemDefinitionUid],
		COALESCE(t.[CategoryName], mucd.[CategoryName]) AS [CategoryName],
		t.[CategoryNumber],
		t.[MeasureNumber],
		t.[SubMeasureNumber],
		t.[PersonUid],
		t.[PersonLnFn],
		[ProviderUid],
		t.[ProviderLnFn],
		@ProviderNPI AS [ProviderNPI],
		t.[NumeratorValue],
		t.[DenominatorValue],
		t.[YesNo],
		MUID.[ObjectiveDesc],
		MUID.[MeasureDesc],
		MUID.[MeasureDetailDesc],
		MUID.[ExclusionDesc],
		MUID.[DenominatorDesc],
		MUID.[NumeratorDesc],
		MUID.[GoalDesc]
	FROM [#tblMeaningfulUseDetail] AS t
		INNER JOIN [MeaningfulUseItemDefinition] AS MUID with(nolock) ON MUID.[ItemDefinitionUid] = t.[ItemDefinitionUid]
		INNER JOIN [MeaningfulUseCategoryDefinition] AS mucd with (nolock) ON MUID.[CategoryUid] = mucd.[CategoryUid]
	ORDER BY [CategoryName] ASC,
		[CategoryNumber] ASC,
		[MeasureNumber] ASC,
		[SubMeasureNumber] ASC,
		[NumeratorValue] DESC,
		[DenominatorValue] DESC,
		[PersonLnFn] ASC 
	
	BEGIN TRY
		DROP TABLE [#tblMeaningfulUseDetail]
	END TRY
	BEGIN CATCH
	END CATCH
	
	-- Return Meaningful Use results to caller
	SELECT [RowId]
		, [ItemDefinitionUid]
		, [CategoryNumber]
		, [CategoryName]
		, [MeasureNumber]
		, [SubMeasureNumber]
		, [MeasureDesc]
		, [DenominatorDesc]
		, [DenominatorValue]
		, [NumeratorDesc]
		, [NumeratorValue]
		, [YesNo]
		, [CurrentValue]
		, [GoalDesc]
		, [GoalValue]
		, [MetGoal]
		, [ProviderUid]
		, [ProviderLnFn]
	FROM @tblMeaingfulUseSummaryCoreAndMenuSet    
	ORDER BY [CategoryNumber] ASC
		, [MeasureNumber] ASC
		, [SubMeasureNumber] ASC 
	
	IF (@Debug <> 0)
	BEGIN
		SELECT 'GOOD BYE'
	END 
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2023PI_E-Prescribing_1_NonControlled]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2023PI_E-Prescribing_1_NonControlled] AS' 
END
GO
ALTER PROC [dbo].[2023PI_E-Prescribing_1_NonControlled]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

	IF (@Debug = 1)
	BEGIN
		SELECT '2023PI_E-Prescribing_1_NonControlled-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = 'BE5F8F23-3AF4-4650-8010-30C82512F71A',
		@RxStatusTransmittedSuccessfully [uniqueidentifier] = 'B1F7EFAF-D56D-4BAD-AE1F-8205E1D00B58', 
		@RxStatusQueuedForTransmission   [uniqueidentifier] = '0605B6F6-2FE4-49CB-B868-9DF448AB3E01'

	TRUNCATE TABLE #MetricDataTemp

	-- Initialize work table
	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
	SELECT @ItemDefinitionUid AS [ItemDefinitionUid]
		, med.[PersonUid]
		, COUNT(sts.[eRxStatusUid]) AS [NumeratorValue]                        
		, COUNT(med.[MedicationSIGUid]) AS [DenominatorValue]
		, null AS [YesNo]
	FROM   [#tblMedicationList] AS med
		LEFT JOIN [ListeRxStatus] AS sts WITH(NOLOCK) ON  med.[eRxStatusUid] = sts.[eRxStatusUid]
		 AND (sts.[eRxStatusUid] IN(@RxStatusTransmittedSuccessfully, @RxStatusQueuedForTransmission))
	WHERE med.[Dispensable] = 1
		AND med.[IsSampleGiven] = 0
		AND med.[IsAdministered] = 0
		AND med.[reffederaldeaclasscode] = 0
		AND [SIGDetailCount] = 1
	GROUP BY med.[PersonUid]
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2023PI_E-Prescribing_1_NonControlled -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2023PI_E-Prescribing_2_Controlled]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2023PI_E-Prescribing_2_Controlled] AS' 
END
GO
ALTER PROC [dbo].[2023PI_E-Prescribing_2_Controlled]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

	IF (@Debug = 1)
	BEGIN
		SELECT '2023PI_E-Prescribing_2_Controlled-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = 'C4458FFB-774F-4644-894E-50E5F7D5544F',
		@RxStatusTransmittedSuccessfully [uniqueidentifier] = 'B1F7EFAF-D56D-4BAD-AE1F-8205E1D00B58', 
		@RxStatusQueuedForTransmission   [uniqueidentifier] = '0605B6F6-2FE4-49CB-B868-9DF448AB3E01'

	TRUNCATE TABLE #MetricDataTemp

	-- Initialize work table
	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
	SELECT @ItemDefinitionUid AS [ItemDefinitionUid]
		, med.[PersonUid]
		, COUNT(sts.[eRxStatusUid]) AS [NumeratorValue]                        
		, COUNT(med.[MedicationSIGUid]) AS [DenominatorValue]
		, null AS [YesNo]
	FROM   [#tblMedicationList] AS med
		LEFT JOIN [ListeRxStatus] AS sts WITH(NOLOCK) ON  med.[eRxStatusUid] = sts.[eRxStatusUid]
		 AND (sts.[eRxStatusUid] IN(@RxStatusTransmittedSuccessfully, @RxStatusQueuedForTransmission))
	WHERE med.[Dispensable] = 1
		AND med.[IsSampleGiven] = 0
		AND med.[IsAdministered] = 0
		AND med.[reffederaldeaclasscode] >= 0
		AND [SIGDetailCount] = 1
	GROUP BY med.[PersonUid]
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2023P2_E-Prescribing_2_Controlled -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2023PI_E-Prescribing_3_PDMP]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2023PI_E-Prescribing_3_PDMP] AS' 
END
GO
ALTER PROC [dbo].[2023PI_E-Prescribing_3_PDMP]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

	IF (@Debug = 1)
	BEGIN
		SELECT '2023PI_E-Prescribing_3_PDMP-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = 'FCA82C54-A757-4C2A-ADD6-EDAD470E49DA',
		@RxStatusTransmittedSuccessfully [uniqueidentifier] = 'B1F7EFAF-D56D-4BAD-AE1F-8205E1D00B58', 
		@RxStatusQueuedForTransmission   [uniqueidentifier] = '0605B6F6-2FE4-49CB-B868-9DF448AB3E01'

	TRUNCATE TABLE #MetricDataTemp

	--DECLARE @Audit TABLE (PatientUid UNIQUEIDENTIFIER)
	--INSERT INTO @Audit
	--SELECT a.PatientUid
	--FROM [#tblMedicationList] m
	--INNER JOIN Audit a on m.PersonUid = a.PatientUid 
	--	AND a.ChangeDate >= @RptTimespan_StartDate AND a.ChangeDate <= @RptTimespan_EndDate
	--	AND a.Description LIKE 'Appriss RX Report Requested Successfully%' or Description LIKE 'LogiCoy Report requested successfully%'

	-- Initialize work table
	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
	--THIS is not the right query
	--And needs to be changed to what is correct
	SELECT @ItemDefinitionUid AS [ItemDefinitionUid]
		, med.[PersonUid]
		, CASE WHEN a.PatientUid IS NOT NULL THEN 1 ELSE 0 END AS [NumeratorValue]                        
		, CASE WHEN med.PersonUid IS NOT NULL THEN 1 ELSE 0 END AS [DenominatorValue]
		, null AS [YesNo]
	FROM   [#tblMedicationList] AS med
	INNER JOIN [ListeRxStatus] AS sts WITH(NOLOCK) ON  med.[eRxStatusUid] = sts.[eRxStatusUid]
		 AND (sts.[eRxStatusUid] IN(@RxStatusTransmittedSuccessfully, @RxStatusQueuedForTransmission))
	LEFT JOIN cus_PDMP_Pats a on med.PersonUid = a.PatientUid
	WHERE med.[Dispensable] = 1
		AND med.[IsSampleGiven] = 0
		AND med.[IsAdministered] = 0
		AND med.[reffederaldeaclasscode] >= 2
		AND [SIGDetailCount] = 1
	GROUP BY med.[PersonUid], a.PatientUid
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2023PI_E-Prescribing_3_PDMP -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2023PI_HealthInformationExchange_1_Sending]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2023PI_HealthInformationExchange_1_Sending] AS' 
END
GO
ALTER PROC [dbo].[2023PI_HealthInformationExchange_1_Sending]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

	IF (@Debug = 1)
	BEGIN
		SELECT '2023PI_HealthInformationExchange_1_Sending-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

     DECLARE @UTC_RptTimespan_StartDate DATETIME,@UTC_RptTimespan_EndDate DATETIME
      SELECT @UTC_RptTimespan_StartDate = @RptTimespan_StartDate
      SELECT @UTC_RptTimespan_EndDate   = DATEADD(DAY,1,@RptTimespan_EndDate)

      --RecordDisclosureAudit limit range, -1 day from min referral date and +3 days to max referral date
      DECLARE @RecordDisclosureAudit_StartDate DATE,@RecordDisclosureAudit_EndDate DATE
      SELECT @RecordDisclosureAudit_StartDate = DATEADD(DAY,-1,@RptTimespan_StartDate)
      SELECT @RecordDisclosureAudit_EndDate   = DATEADD(DAY,3,@RptTimespan_EndDate)

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = '38314B3F-79FF-4903-9E3C-6B28D711EA92'
	DECLARE @ExcludedReferrals TABLE (PatientReferralUid UNIQUEIDENTIFIER)

	INSERT INTO @ExcludedReferrals
	SELECT ViewUid FROM ViewPatientOutboundReferral v
	INNER JOIN ListProviderCareType p WITH(NOLOCK) on v.ProviderCareTypeUid = p.ProviderCareTypeUid AND p.ExcludeFromReferrals = 1

	INSERT INTO @ExcludedReferrals
	SELECT PatientReferralUid FROM PatientReferral WHERE ReferralTrackingStatusUid = 'F7D1B72C-83ED-4D2E-8AB2-2B86F31E8EB2'

      TRUNCATE TABLE #MetricDataTemp

      ;WITH cte_pr AS (
            select pr.*,dbo.UDF_CQMTestPatient (pr.PatientUid) AS TestPatient
            FROM ViewPatientReferralConsultReport pr 
			INNER JOIN #tblVisitList t on pr.VisitUid = t.VisitUid
            LEFT JOIN PatientReferral p WITH(NOLOCK) on pr.PatientReferralUid = p.PatientReferralUid
            LEFT JOIN VisitProcedure vp WITH(NOLOCK) on p.VisitProcedureUid = vp.VisitProcedureUid
            LEFT JOIN ListProcedure lp WITH(NOLOCK) on vp.ProcedureUid = lp.ProcedureUid      
			LEFT JOIN @ExcludedReferrals er on pr.PatientReferralUid = er.PatientReferralUid
            WHERE pr.RefType = 'PatientReferral'
                        AND (pr.ReferredByProviderUid IN (SELECT Element FROM dbo.Split(@ProviderUid, ',')) OR @ProviderUid IS NULL)
                        AND pr.ReferralDate >= @UTC_RptTimespan_StartDate AND pr.ReferralDate < @RecordDisclosureAudit_EndDate
                        AND (lp.ProcedureCodeTypeUid IS NULL OR lp.ProcedureCodeTypeUid NOT IN ('1E605C00-13F0-4B95-AEDB-7AA2E30A8BED'))
						AND er.PatientReferralUid IS NULL
      ),
      cte_rda AS (
            SELECT [DisclosureDate] ,
                  [DisclosureType] ,
                  [PatientUid] ,
                  rda.[PatientReferralUid] ,
                  [AttachmentGroupUid] ,
                  rda.[VisitUid] ,
                  [IsPortal],
                  [DisclosureMethod],
                  [Status],
                  [DisclosurePurpose]
            FROM RecordDisclosureAudit rda WITH(NOLOCK)
			--LEFT JOIN PatientReferral pr on rda.PatientReferralUid = pr.PatientReferralUid AND pr.ReferredByProviderUid = @ProviderUid
            WHERE DisclosureDate >= @RecordDisclosureAudit_StartDate
                  AND DisclosureType in (1,    -- Complete Chart
                                                      2,    -- Clinical Summary
                                                      11)  -- ContinuityOfCareDocument
                  AND DisclosureMethod IN (1,5,6,7)
                  AND DisclosurePurpose <> 'Released to Patient' --2016.02.23 dmg
                  AND [Status] > 0
      )
      INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
            SELECT @ItemDefinitionUid AS ItemDefinitionUid
                        ,r.PatientUid
                         ,COUNT(distinct CASE WHEN  rda.DisclosureType IS NOT NULL and rda.status = 4 THEN rda.PatientReferralUid
                              ELSE NULL END) AS NumeratorValue            
						,COUNT(distinct CASE WHEN r.PatientReferralUid is not null  and (r.ReferralStatus in ('Initiated', 'Appointment Confirmed')) THEN r.PatientReferralUid
                             ELSE NULL END) AS DenominatorValue 
                        ,null AS YesNo
            FROM cte_pr r 
           LEFT JOIN cte_rda rda ON r.PatientUid=rda.patientuid AND
                                    (
                                          r.VisitUid=rda.VisitUid 
                                          OR r.PatientReferralUid=rda.PatientReferralUid 
                                          OR r.AttachmentGroupUid=rda.AttachmentGroupUid
                                          --OR DATEDIFF(day,r.ReferralDate,rda.DisclosureDate) >= -1
                                    )
            WHERE r.TestPatient = 0
            GROUP BY r.PatientUid
            
      UPDATE #tblMeaningfulUseDetail
      SET NumeratorValue = 
            CASE 
                  WHEN NumeratorValue > DenominatorValue THEN DenominatorValue 
                  ELSE NumeratorValue 
            END
	  WHERE ItemDefinitionUid = @ItemDefinitionUid
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2023PI_HealthInformationExchange_1_Sending -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2023PI_HealthInformationExchange_2_Receiving]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2023PI_HealthInformationExchange_2_Receiving] AS' 
END
GO
ALTER PROC [dbo].[2023PI_HealthInformationExchange_2_Receiving]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

	IF (@Debug = 1)
	BEGIN
		SELECT '2023PI_HealthInformationExchange_2_Receiving-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

	DECLARE @UTC_RptTimespan_StartDate DATETIME,@UTC_RptTimespan_EndDate DATETIME
	SELECT @UTC_RptTimespan_StartDate = @RptTimespan_StartDate, @UTC_RptTimespan_EndDate = @RptTimespan_EndDate
	SELECT @UTC_RptTimespan_StartDate = '01/01/'+CONVERT(VARCHAR(4),DATEPART(YEAR,@UTC_RptTimespan_StartDate))

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = '221A5847-FFA5-4B1B-A8AD-C06AEF8721C8'

	DECLARE @InitiatedReferrals TABLE (PatientReferralUid UNIQUEIDENTIFIER)
	INSERT INTO @InitiatedReferrals
	SELECT DISTINCT PatientReferralUid 
	FROM PatientReferralHistory 
	WHERE ReferralTrackingStatusUid IN ('0673DB25-454C-44D8-B83F-AFCF97879AAD','3B180FEC-FAE0-4850-AE16-6172CC31F7A7')

	TRUNCATE TABLE #MetricDataTemp

	;WITH cte_Ref AS (
	SELECT vfp.PersonUid AS PatUid
			, rag.VisitUid AS Uid
			, COALESCE(a.AttachmentUid, ag.AttachmentGroupUid) AS AttUid
			, COALESCE(a.FileDate, ag.LastModifiedDate) AS AttDate
			, aa.HasClinicalDocument AS NumID
			, aa.MedicationAllergiesReconciledDate
			, aa.MedicationsReconciledDate
			, aa.ProblemsReconciledDate
			, a.AttachmentTypeUid
			, latDM.ExternalID AS AttachmentTypeID
	FROM #tblPatientList vfp
	INNER JOIN RelAttachmentGroup rag on vfp.PersonUid = rag.PersonUid
	INNER JOIN Visit v on rag.VisitUid = v.VisitUid AND (v.VisitDate >= @RptTimespan_StartDate AND v.VisitDate <= @RptTimespan_EndDate)
	INNER JOIN #tblProviderList prov on v.ProviderUid = prov.ProviderUid
	LEFT JOIN Attachment a on rag.AttachmentGroupUid = a.AttachmentGroupUid
	LEFT JOIN ListAttachmentType latDM on a.AttachmentTypeUid = latDM.AttachmentTypeUid
	LEFT JOIN AttachmentGroup ag on rag.AttachmentGroupUid = ag.AttachmentGroupUid
	INNER JOIN ListAttachmentType lat on (a.AttachmentTypeUid = lat.AttachmentTypeUid OR ag.AttachmentTypeUid = lat.AttachmentTypeUid) AND (lat.AttachmentTypeUid = 'B71B8F20-7B7D-4A7C-9E75-05811A0791AD')
	LEFT JOIN MessageAA aa on rag.RelAttachmentGroupUid = aa.RelAttachmentGroupUid --AND aa.SummaryOfCareReconciledDate IS NOT NULL
	LEFT JOIN Message m on aa.MessageUid = m.MessageUid

	UNION ALL

	SELECT vfp.PersonUid AS PatUid
			, pr.PatientReferralUid AS Uid
			, aa.MessageUid AS AttUid
			, pr.CreatedDate AS AttDate
			, aa.HasClinicalDocument AS NumID
			, aa.MedicationAllergiesReconciledDate
			, aa.MedicationsReconciledDate
			, aa.ProblemsReconciledDate
			, att.AttachmentTypeUid
			, lat.ExternalID AS AttachmentTypeID
	FROM #tblPatientList vfp
	INNER JOIN RelAttachmentGroup r ON vfp.PersonUid = r.PersonUid
	INNER JOIN MessageAA aa ON aa.RelAttachmentGroupUid = r.RelAttachmentGroupUid --AND aa.ElectronicSummaryOfCareReceived = 1
	LEFT JOIN Attachment att on r.AttachmentGroupUid = att.AttachmentGroupUid
	LEFT JOIN ListAttachmentType lat on att.AttachmentTypeUid = lat.AttachmentTypeUid
	INNER JOIN PatientReferral pr on r.PatientReferralUid = pr.PatientReferralUid 
			AND (pr.CreatedDate >= @RptTimespan_StartDate AND pr.CreatedDate <= @RptTimespan_EndDate)
			AND pr.ReferralTrackingStatusUid <> '3B180FEC-FAE0-4850-AE16-6172CC31F7A7'
	INNER JOIN PatientProviderRelationship ppr on pr.PatientProviderRelationshipUid = ppr.PatientProviderRelationshipUid
	INNER JOIN #tblProviderList prov on pr.ReferredByProviderUid = prov.ProviderUid
	INNER JOIN @InitiatedReferrals ir on pr.PatientReferralUid = ir.PatientReferralUid
	)


	--SELECT * FROM cte_Ref
	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
		SELECT @ItemDefinitionUid AS ItemDefinitionUid
				,PatUid
				,COUNT(distinct CASE WHEN MedicationAllergiesReconciledDate IS NOT NULL 
						AND MedicationsReconciledDate IS NOT NULL
						AND ProblemsReconciledDate IS NOT NULL
							THEN Uid
						WHEN AttachmentTypeUid = '91293E86-6AA1-4B30-AA00-7DDD42135D64' THEN Uid
						WHEN AttachmentTypeID = 'DMail' THEN Uid
							ELSE NULL END) AS NumeratorValue
				,COUNT(DISTINCT Uid) AS DenominatorValue
				,NULL AS YesNo
		FROM cte_Ref
		GROUP BY PatUid


	IF EXISTS (
		SELECT TOP 1 *
		FROM #tblMeaningfulUseDetail
		WHERE [ItemDefinitionUid] = @ItemDefinitionUid
	)
    BEGIN
	    UPDATE [#tblMeaningfulUseDetail]
		SET [NumeratorValue] = CASE WHEN [NumeratorValue] > [DenominatorValue] THEN [DenominatorValue] ELSE [NumeratorValue] END
    END
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2023PI_HealthInformationExchange_2_Receiving -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2023PI_ProviderToPatientExchange]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2023PI_ProviderToPatientExchange] AS' 
END
GO
ALTER PROC [dbo].[2023PI_ProviderToPatientExchange]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

	IF (@Debug = 1)
	BEGIN
		SELECT '2023PI_ProviderToPatientExchange-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = '18A9A253-7C4B-4C36-AD56-FBC0F361C986'

	TRUNCATE TABLE [#MetricDataTemp]

	-- Populate Denominator Value
	INSERT INTO [#tblMeaningfulUseDetail] ([ItemDefinitionUid]
		, [PersonUid]
		, [NumeratorValue]
		, [DenominatorValue]
		, [YesNo]
	)
	SELECT @ItemDefinitionUid AS [ItemDefinitionUid]
		, p.PersonUid
		, COUNT(DISTINCT CASE WHEN p.[HasPortalAccount] <> 0 THEN p.[PersonUid]
				ELSE NULL END)AS [NumeratorValue]           
		, COUNT(DISTINCT p.[PersonUid]) AS [DenominatorValue]
		, null AS [YesNo]
	FROM  [#tblPatientList] AS p
	WHERE (p.[IsEM] <> 0 OR p.IsVP <> 0)
	GROUP BY p.[PersonUid]
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2023PI_ProviderToPatientExchange -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2023PI_Master_DesktopControl]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2023PI_Master_DesktopControl] AS' 
END
GO
ALTER PROC [dbo].[2023PI_Master_DesktopControl]
(
	@ProviderUid			[varchar](max) = NULL,  
	@RptTimespan_StartDate	[date],
	@RptTimespan_EndDate	[date],
	@ProviderBilling		[bit] = 1,
	@ProviderRendering		[bit] = 0,
	@Debug					[int] = 0,
	@includetestpat			[bit] = 0,
	@ServiceSiteUID			[varchar](max) = null, 
	@FinancialCenterUID		[varchar](max) = null
)
AS
BEGIN

SET NOCOUNT ON;
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;
	--
	-- Calling syntax :    
	--
	--

	IF (@RptTimespan_StartDate IS NULL)
	BEGIN
		SET @RptTimespan_StartDate = '01-01-1900'
	END 
	IF (@RptTimespan_EndDate IS NULL)
	BEGIN
		SET @RptTimespan_EndDate = GETDATE()
	END 

	CREATE TABLE [#tblProviderList]
	(
		[ProviderUid] [uniqueidentifier] NOT NULL primary key clustered
	)
	 	 
	DECLARE @HasProviderUid [bit] = 0
	EXEC [2019PI_Master_PopulateProviderList] @ProviderUid, @HasProviderUid out

	-- Measure stored procedure flag indicating Meaningful Use data will be used for a report
	DECLARE @ReportMode [bit] = 0

	IF NOT EXISTS (SELECT 1 FROM sysobjects WHERE Name='cus_PDMP_Pats' and XType='U')
		EXEC FillPDMPPatsTable
		

	CREATE TABLE [#tblVisitList]
	(
		[VisitUid]							[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[VisitDate]							[date]         NOT NULL,
		[PatientUid]						[uniqueidentifier] NOT NULL,
		[TestPat]					   		[bit],
		[IsEM]								[bit],
		[IsVP]								[bit],
		[ProviderUid]						[varchar](max),
		[RenderingProviderUid]				[varchar](max),
		[LastSavedByUid]					[uniqueidentifier],
		[SavedByBillingProvider]			[bit],
		[SavedByRenderingProvider]			[bit],
		[TransitionOfCare]					[bit],
		[MedicationChecked]					[bit],
		[DrugAllergyChecked]				[bit],
		[ProblemChecked]					[bit],
		[SummaryProvidedToPatient]			[date],
		[PatientDeclinedClinicalSummary]	[bit],
		[HasEduForm]						[bit],
		[HasPortalAccount]					[bit],
		[PrintedDate]						[date]
	)
	--
	-- PopulateVisitList
	EXEC [2019PI_Master_PopulateVisitList] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@Debug,
		@ServiceSiteUID,
		@FinancialCenterUID
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblVisitList]
		ORDER BY [VisitDate] DESC 
	END

	CREATE TABLE [#tblPatientList] 
	(
		[PersonUid]					[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[PatientLnFn]				[varchar](250),
		[Birthdate]					[date],
		[TestPat]					[bit],
		[IsEM]						[bit],
		[IsVP]						[bit],
		[FullDemographics]			[bit],
		[HasEduForm]				[bit],
		[EduFormPrinted]			[bit],
		[HasPortalAccount]			[bit],
		[PortalPerson]				[uniqueidentifier] NULL,
		[PortalValid]				[date] NULL,
		[PortalExpire]				[date] NULL,
		[SummaryProvidedToPatient]	[bit],
		[TransitionOfCare]			[bit],
		[MedicationChecked]			[bit],
		[SavedByBillingProvider]	[bit],
		[SavedByRenderingProvider]	[bit],
		[YearsOldOrOlder2]			[bit] NULL,
		[YearsOldOrOlder3]			[bit] NULL,
		[YearsOldOrYounger5]		[bit] NULL, 
		[YearsOldOrOlder13]			[bit] NULL,
		[YearsOldOrOlder65]			[bit] NULL
	)
	--
	-- Populate Patient List
	EXEC [2019PI_Master_PopulatePatientList] @ProviderUid, 
			@RptTimespan_StartDate,
			@RptTimespan_EndDate,
			@ProviderBilling,
			@ProviderRendering,
			@Debug

	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblPatientList]
		ORDER BY [PatientLnFn]
	END

	--back fill #tblVisitList with patient specific information
	--delete test patient records from #tblVisitList AND #tblPatientList IF @includetestpat = 0
	EXEC [2019PI_Master_SynchronizeVisitAndPatient] @Debug = @Debug,
		@IncludeTestPatients = @includetestpat

	-- Build list of Medications that are within reporting range
	CREATE TABLE #tblMedicationList
	(
		[MedicationSIGUid]					[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[CreatedDate]						[datetime] NOT NULL,
		[RelVisitMedicationUid]				[uniqueidentifier],
		[PersonUid]							[uniqueidentifier],
		[TestPat]							[bit],
		[LicensedHealthcareProfessional]	[bit] NOT NULL,
		[Dispensable]						[bit] NULL,
		[IsSampleGiven]						[bit] NOT NULL,
		[IsAdministered]					[bit] NOT NULL,
		[reffederaldeaclasscode]			[int] NULL,
		[SIGDetailCount]					[int] NULL,
		[eRxStatusUid]						[uniqueidentifier]
	)
	--
	-- PopulateMedicationList
	EXEC [2019PI_Master_PopulateMedicationList]
		@ProviderUid
		, @ProviderBilling
		, @RptTimespan_StartDate
		, @RptTimespan_EndDate
		, @includetestpat
		, @Debug
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblMedicationList]
		ORDER BY [CreatedDate] DESC 
	END

	-- Build list of Orders that are within reporting range
	CREATE TABLE [#tblOrderList]
	(
		[ObservationOrderUid]				[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[PatientUid]						[uniqueidentifier] NOT NULL,
		[TestPat]					   		[bit],
		[VPUid]								[uniqueidentifier] NULL,
		[CreatedBy]							[uniqueidentifier] NULL,
		[OrderDate]							[datetime]         NOT NULL,
		[ProcedureCodeTypeUid]				[uniqueidentifier] NULL,
		[ProcedureCodeTypeName]				[varchar](500)     NULL,
		[AttachmentTypeUid]					[uniqueidentifier] NULL,
		[AttachmentTypeName]				[varchar](500)	NULL,
		[LicensedHealthcareProfessional]	[bit]			NOT NULL,
		[ImageResultsDirectlyAccessible]	[bit]			NULL,
		[ResultStatusID]					[int]			NULL
	)
	--
	-- PopulateOrderList
	EXEC [2019PI_Master_PopulateOrderList] @ProviderUid
		, @ProviderBilling
		, @RptTimespan_StartDate
		, @RptTimespan_EndDate
		, @includetestpat
		, @Debug
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblOrderList]
		ORDER BY [OrderDate] DESC 
	END

	-- Create work table that will hold the Meaningful Use results
	CREATE TABLE [#tblMeaningfulUseDetail] 
	(
		[RowId]               [int] IDENTITY(1,1) PRIMARY KEY,     -- Primary Key
		[ItemDefinitionUid]   [uniqueidentifier],                  -- MeaningfulUseItemDefinition.ItemDefinitionUid   
		[PersonUid]           [uniqueidentifier] NULL,             -- Unique list of Visit.PatientUid
		[NumeratorValue]      [int] NULL,                          -- See MeaningfulUseItemDefinition.NumeratorDesc
		[DenominatorValue]    [int] NULL,                          -- See MeaningfulUseItemDefinition.DenominatorDesc
		[YesNo]               [int] NULL                           -- See MeaningfulUseItemdefinition.YesNo.  Null-NA, 0-No/False, 1-Yes/True.
		unique clustered ([RowId])
	)  

	CREATE NONCLUSTERED INDEX [MUDetail_ItemDef_PersonUid] ON [#tblMeaningfulUseDetail]
	(
		[ItemDefinitionUid] ASC,
		[PersonUid] ASC
	)
	WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

	-- Create temp table that can be used by measure procs
	CREATE TABLE [#MetricDataTemp]
	(
		[PersonUid]							[uniqueidentifier] NOT NULL,
		[HeightRecorded]					[int] NULL,
		[WeightRecorded]					[int] NULL,
		[BloodPressureRecorded]				[int] NULL,
		[LabResultTotalCount]				[int] NULL, 
		[LabResultTemplatedCount]			[int] NULL,
		[TaskDocGenCount]					[int] NULL, 
		[TaskDocGenCompleteCount]			[int] NULL,   
		[VisitCount]						[int] NULL, 
		[ClinicalSummaryProvidedCount]		[int] NULL,  
		[PreventativeFollowupDueCount]		[int] NULL, 
		[PreventativeFollowupSentCount]		[int] NULL,   
		[SeenByAnotherProviderCount]		[int] NULL, 
		[MedicalCheckedCount]				[int] NULL,  
		[ReferralCount]						[int] NULL, 
		[ReferralClinicalSummaryProvided]	[int] NULL
	) 	
	
	-- Proc based on MUII_Master_DesktopControl
	--  
	-- Calculate Measures
	EXEC [2023PI_E-Prescribing_1_NonControlled] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2023PI_E-Prescribing_2_Controlled] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2023PI_E-Prescribing_3_PDMP] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE
		
	EXEC [2023PI_HealthInformationExchange_1_Sending] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2023PI_HealthInformationExchange_2_Receiving] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2023PI_ProviderToPatientExchange] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	-- Drop temp tables that are used by measure procs
	BEGIN TRY
		DROP TABLE [#tblVisitList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#tblPatientList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#tblProviderList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#MetricDataTemp]
	END TRY 
	BEGIN CATCH
	END CATCH

	-- Define table that will be returned to caller
	DECLARE @tblMeaingfulUseSummaryCoreAndMenuSet TABLE
	(
		[RowId]             [int] IDENTITY(1,1) PRIMARY KEY,
		[ItemDefinitionUid] [uniqueidentifier],
		[CategoryNumber]    [int] NULL,
		[CategoryName]      [varchar](100) NULL,
		[MeasureNumber]     [int] NULL, 
		[SubMeasureNumber]  [int] NULL,
		[MeasureDesc]       [varchar](500) NULL,
		[DenominatorDesc]   [varchar](250) NULL,
		[DenominatorValue]  [int] NULL,
		[NumeratorDesc]     [varchar](250) NULL,
		[NumeratorValue]    [int] NULL,
		[YesNo]     [varchar](50)  NULL,
		[CurrentValue]	  [varchar](25)  NULL,
		[GoalDesc]          [varchar](250) NULL,
		[GoalValue]         [varchar](10)  NULL,
		[MetGoal]           [bit] NULL, 
		[ProviderUid]       [varchar](max) NULL,
		[ProviderLnFn]      [varchar](150) NULL,       
		unique clustered  ([RowId])
	) 

	-- Determine if there are any MU detail rows to base metrics against
	DECLARE @NumDetailRows [int]

	-- Walk through list of defined Meaningful Use metrics and popluate @tblMeaingfulUseSummaryCoreAndMenuSet 
	DECLARE @ItemDefinitionUid [uniqueidentifier]
		, @CategoryUid [uniqueidentifier]
		, @CategoryNumber [int]
		, @CategoryName [varchar](100)
		, @MeasureNumber [int]
		, @SubMeasureNumber [int]
		, @MeasureDesc [varchar](500)
		, @ExclusionDesc [varchar](250)
		, @DenominatorDesc [varchar](250)
		, @NumeratorDesc [varchar](250)
		, @YesNo [varchar](50)
		, @GoalDesc [varchar](250)
		, @GoalValue [decimal](5, 2)
		, @DenominatorSumValue [int]
		, @NumeratorSumValue [int]
		, @CurValue [varchar](25)
		, @MetGoal [bit]    
        
    --
    -- Populate table that will be returned to caller
	DECLARE cursor_MU_Definitions CURSOR FAST_FORWARD FOR 
		SELECT muid.[ItemDefinitionUid]
			, muid.[CategoryUid]
			, mucd.[CategoryNumber]
			, mucd.[CategoryName]
			, muid.[MeasureNumber]
			, muid.[SubMeasureNumber]
			, muid.[MeasureDesc]
			, muid.[ExclusionDesc]
			, muid.[DenominatorDesc]
			, muid.[NumeratorDesc]
			, muid.[YesNo]
			, muid.[GoalDesc]
			, muid.[GoalValue]
		FROM [MeaningfulUseItemDefinition] AS muid with(nolock)
			INNER JOIN [MeaningfulUseCategoryDefinition] AS mucd with(nolock) ON muid.[CategoryUid] = mucd.[CategoryUid]
/*Replace w/new StageUid*/		WHERE muid.[StageUid] = 'F7671FC8-43C3-4F60-8CF0-4DA79A0A28F7'   --2023 PI
		ORDER BY mucd.[CategoryName]
			, mucd.[CategoryNumber]
			, muid.[MeasureNumber]
    --
    OPEN cursor_MU_Definitions
    --
	FETCH NEXT FROM cursor_MU_Definitions 
		INTO @ItemDefinitionUid
			, @CategoryUid
			, @CategoryNumber
			, @CategoryName
			, @MeasureNumber
			, @SubMeasureNumber
			, @MeasureDesc
			, @ExclusionDesc
			, @DenominatorDesc
			, @NumeratorDesc
			, @YesNo
			, @GoalDesc
			, @GoalValue 
    --
   -- Make sure we have a valid cursor row
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @DenominatorSumValue = 0
		SET @NumeratorSumValue = 0
		SET @CurValue = '' 
		SET @MetGoal = 0 
		SET @NumDetailRows = 0
		
		-- Check if current MU metric has a numerator and denominator
		IF @YesNo IS NULL
		BEGIN
			-- Make sure we have some data for current metric
			SET @NumDetailRows = (SELECT COUNT(*)
								  FROM [#tblMeaningfulUseDetail]
								  WHERE [ItemDefinitionUid] = @ItemDefinitionUid
								 )
			IF (@NumDetailRows > 0)
			BEGIN
				-- Current MU metric has a numerator and demoninator
				SELECT  @DenominatorSumValue = SUM(mud.[DenominatorValue])
					, @NumeratorSumValue   = SUM(mud.[NumeratorValue]) 
				FROM     [#tblMeaningfulUseDetail] AS mud
				WHERE    mud.[ItemDefinitionUid] = @ItemDefinitionUid
				GROUP BY mud.[ItemDefinitionUid] 
			END    
           
			IF @DenominatorSumValue <= 0
			BEGIN
				SET @CurValue = 'N/A' 
			END 
			ELSE IF @NumeratorSumValue <= 0
			BEGIN 
				SET @CurValue = '0.00%' 
			END 
			ELSE 
			BEGIN 
				-- Calculate current MU metric value
				SET @CurValue = CONVERT(VARCHAR(10), CONVERT(DECIMAL(8,2), (CONVERT(DECIMAL(8,2), @NumeratorSumValue) / CONVERT(DECIMAL(8,2), @DenominatorSumValue)) * 100)) + '%'
	                  
				-- Determine if goal is satisfied
				IF CONVERT(DECIMAL(8,2), (CONVERT(DECIMAL(8,2), @NumeratorSumValue) / CONVERT(DECIMAL(8,2), @DenominatorSumValue)) * 100) > @GoalValue
				BEGIN
					SET @MetGoal = 1
				END 
			END 
             
			-- Insert MU summary row
			INSERT INTO @tblMeaingfulUseSummaryCoreAndMenuSet ([ItemDefinitionUid]
				, [CategoryNumber]
				, [CategoryName]
				, [MeasureNumber]
				, [SubMeasureNumber]
				, [MeasureDesc]
				, [DenominatorDesc]
				, [DenominatorValue]
				, [NumeratorDesc]
				, [NumeratorValue]
				, [YesNo]
				, [CurrentValue]
				, [GoalDesc]
				, [GoalValue]
				, [MetGoal]
				, [ProviderUid]
				, [ProviderLnFn]
			)   
			VALUES (@ItemDefinitionUid
				, @CategoryNumber
				, @CategoryName
				, @MeasureNumber
				, @SubMeasureNumber
				, @MeasureDesc
				, @DenominatorDesc
				, @DenominatorSumValue
				, @NumeratorDesc
				, @NumeratorSumValue
				, @YesNo
				, @CurValue
				, @GoalDesc
				, CONVERT([varchar](10), @GoalValue)
				, @MetGoal
				, null
				, null
			)  
		END 
		ELSE 
		BEGIN
			-- Current MU metric is YES/NO.  
			INSERT INTO @tblMeaingfulUseSummaryCoreAndMenuSet([ItemDefinitionUid]
				, [CategoryNumber]
				, [CategoryName]
				, [MeasureNumber]
				, [SubMeasureNumber]
				, [MeasureDesc]
				, [DenominatorDesc]
				, [DenominatorValue]
				, [NumeratorDesc]
				, [NumeratorValue]
				, [YesNo]
				, [CurrentValue]
				, [GoalDesc]
				, [GoalValue]
				, [MetGoal]
				, [ProviderUid]
				, [ProviderLnFn]
			)  
			VALUES (@ItemDefinitionUid
				, @CategoryNumber
				, @CategoryName
				, @MeasureNumber
				, @SubMeasureNumber
				, @MeasureDesc
				, @DenominatorDesc
				, null
				, @NumeratorDesc
				, null
				, @YesNo
				, null
				, @GoalDesc
				, null
				, null
				, null
				, null
			)  
		END
		-- 
		-- Get next cursor_MU_Definitions row
		FETCH NEXT FROM cursor_MU_Definitions INTO @ItemDefinitionUid
			, @CategoryUid
			, @CategoryNumber
			, @CategoryName
			, @MeasureNumber
			, @SubMeasureNumber
			, @MeasureDesc
			, @ExclusionDesc
			, @DenominatorDesc
			, @NumeratorDesc
			, @YesNo
			, @GoalDesc
			, @GoalValue 
    END
    --
    -- Close and Deallocate cursor
    CLOSE cursor_MU_Definitions
    DEALLOCATE cursor_MU_Definitions
	
	-- Return Meaningful Use results to caller
	SELECT 'MeaingfulUseSummaryCoreAndMenuSet'
	SELECT [RowId]
		, [ItemDefinitionUid]
		, [CategoryNumber]
		, [CategoryName]
		, [MeasureNumber]
		, [SubMeasureNumber]
		, [MeasureDesc]
		, [DenominatorDesc]
		, [DenominatorValue]
		, [NumeratorDesc]
		, [NumeratorValue]
		, [YesNo]
		, [CurrentValue]
		, [GoalDesc]
		, [GoalValue]
		, [MetGoal]
		, [ProviderUid]
		, [ProviderLnFn]
	FROM @tblMeaingfulUseSummaryCoreAndMenuSet    
	ORDER BY [CategoryNumber] ASC
		, [MeasureNumber] ASC
		, [SubMeasureNumber] ASC 
	
	IF (@Debug <> 0)
	BEGIN
		SELECT 'GOOD BYE'
	END 
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2023PI_Master_Report]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2023PI_Master_Report] AS' 
END
GO
ALTER PROC [dbo].[2023PI_Master_Report]
(
	@ReportInstanceUid		[uniqueidentifier],
	@ProviderUid			[varchar](max) = NULL, 
	@RptTimespan_StartDate	[date],
	@RptTimespan_EndDate	[date],
	@ProviderOption			[varchar](100) = 'Billing Provider', --	Billing Provider and Rendering Provider 
	@Debug					[int] = 0,
	@includetestpat			[bit] = 0,
	@ServiceSiteUID			[varchar](max) = null, 
	@FinancialCenterUID		[varchar](max) = null
)
AS
BEGIN
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;
	--
	--  

	IF (@RptTimespan_StartDate IS NULL)
	BEGIN
		SET @RptTimespan_StartDate = '01-01-1900'
	END 
	IF (@RptTimespan_EndDate IS NULL)
	BEGIN
		SET @RptTimespan_EndDate = GETDATE()
	END

	CREATE TABLE [#tblProviderList]
	(
		[ProviderUid] [uniqueidentifier] NOT NULL primary key clustered
	)
	 
	DECLARE @HasProviderUid [bit] = 0
	EXEC [2019PI_Master_PopulateProviderList] @ProviderUid, @HasProviderUid out

	DECLARE @ClaimFormatValueTypeProviderNPIUid [uniqueidentifier] = 'CE282F4E-A866-49BA-9636-C4BA0439E907',
		@ReportMode [bit] = 1,
		@ProviderBilling [bit] = 0,
		@ProviderRendering [bit] = 0,
		@ProviderNPI [varchar](100) = null

	-- Find the first provider has provider NPI

	SELECT TOP 1 @ProviderNPI = [Value]
	FROM [ClaimFormatValue] with(nolock)
	WHERE [ClaimFormatValueTypeUid] = @ClaimFormatValueTypeProviderNPIUid
		AND [ProviderUid] IN (SELECT [ProviderUid] FROM [#tblProviderList])

	-- Set local Billing and Rendering Provider Flags
	IF (@ProviderOption = 'Billing Provider')
	BEGIN
		SET @ProviderBilling = 1
		SET @ProviderRendering = 0
	END
	ELSE
	BEGIN
		SET @ProviderBilling = 0
		SET @ProviderRendering = 1	
	END

	IF NOT EXISTS (SELECT 1 FROM sysobjects WHERE Name='cus_PDMP_Pats' and XType='U')
		EXEC FillPDMPPatsTable

	-- Measure stored procedure flag indicating Meaningful Use data will be used for a report
CREATE TABLE [#tblVisitList]
	(
		[VisitUid]							[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[VisitDate]							[date]         NOT NULL,
		[PatientUid]						[uniqueidentifier] NOT NULL,
		[TestPat]					   		[bit],
		[IsEM]								[bit],
		[IsVP]								[bit],
		[ProviderUid]						[varchar](max),
		[RenderingProviderUid]				[varchar](max),
		[LastSavedByUid]					[uniqueidentifier],
		[SavedByBillingProvider]			[bit],
		[SavedByRenderingProvider]			[bit],
		[TransitionOfCare]					[bit],
		[MedicationChecked]					[bit],
		[DrugAllergyChecked]				[bit],
		[ProblemChecked]					[bit],
		[SummaryProvidedToPatient]			[date],
		[PatientDeclinedClinicalSummary]	[bit],
		[HasEduForm]						[bit],
		[HasPortalAccount]					[bit],
		[PrintedDate]						[date]
	)
	--
	-- PopulateVisitList
	EXEC [2019PI_Master_PopulateVisitList] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@Debug,
		@ServiceSiteUID,
		@FinancialCenterUID

	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblVisitList]
		ORDER BY [VisitDate] DESC 
	END

	CREATE TABLE [#tblPatientList] 
	(
		[PersonUid]					[uniqueidentifier] NOT NULL primary key clustered,
		[PatientLnFn]				[varchar](250),
		[Birthdate]					[date],
		[TestPat]					[bit],
		[IsEM]						[bit],
		[IsVP]						[bit],
		[FullDemographics]			[bit],
		[HasEduForm]				[bit],
		[EduFormPrinted]			[bit],
		[HasPortalAccount]			[bit],
		[PortalPerson]				[uniqueidentifier] NULL,
		[PortalValid]				[date] NULL,
		[PortalExpire]				[date] NULL,
		[SummaryProvidedToPatient]	[bit],
		[TransitionOfCare]			[bit],
		[MedicationChecked]			[bit],
		[SavedByBillingProvider]	[bit],
		[SavedByRenderingProvider]	[bit],
		[YearsOldOrOlder2]			[bit] NULL,
		[YearsOldOrOlder3]			[bit] NULL,
		[YearsOldOrYounger5]		[bit] NULL, 
		[YearsOldOrOlder13]			[bit] NULL,
		[YearsOldOrOlder65]			[bit] NULL
	)
	--
	-- Populate Patient List
	EXEC [2019PI_Master_PopulatePatientList] 
			@ProviderUid, 
			@RptTimespan_StartDate,
			@RptTimespan_EndDate,
			@ProviderBilling,
			@ProviderRendering,
			@Debug

	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblPatientList]
		ORDER BY [PatientLnFn]
	END

	--back fill #tblVisitList with patient specific information
	--delete test patient records from #tblVisitList AND #tblPatientList IF @includetestpat = 0
	EXEC [2019PI_Master_SynchronizeVisitAndPatient] @Debug = @Debug,
		@IncludeTestPatients = @includetestpat

	-- Build list of Medications that are within reporting range
	CREATE TABLE [#tblMedicationList]
	(
		[MedicationSIGUid]					[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[CreatedDate]						[datetime] NOT NULL,
		[RelVisitMedicationUid]				[uniqueidentifier],
		[PersonUid]							[uniqueidentifier],
		[TestPat]							[bit],
		[LicensedHealthcareProfessional]	[bit] NOT NULL,
		[Dispensable]						[bit] NULL,
		[IsSampleGiven]						[bit] NOT NULL,
		[IsAdministered]					[bit] NOT NULL,
		[reffederaldeaclasscode]			[int] NULL,
		[SIGDetailCount]					[int] NULL,
		[eRxStatusUid]						[uniqueidentifier]
	)
	--
	-- PopulateMedicationList
	EXEC [2019PI_Master_PopulateMedicationList] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@includetestpat,
		@Debug
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblMedicationList]
		ORDER BY [CreatedDate] DESC 
	END

	-- Build list of Orders that are within reporting range
	CREATE TABLE [#tblOrderList]
	(
		[ObservationOrderUid]				[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[PatientUid]						[uniqueidentifier] NOT NULL,
		[TestPat]					 		[bit],
		[VPUid]								[uniqueidentifier] NULL,
		[CreatedBy]							[uniqueidentifier] NULL,
		[OrderDate]							[datetime] NOT NULL,
		[ProcedureCodeTypeUid]				[uniqueidentifier] NULL,
		[ProcedureCodeTypeName]				[varchar](500) NULL,
		[AttachmentTypeUid]					[uniqueidentifier] NULL,
		[AttachmentTypeName]				[varchar](500) NULL,
		[LicensedHealthcareProfessional]	[bit] NOT NULL,
		[ImageResultsDirectlyAccessible]	[bit] NULL,
		[ResultStatusID]					[int] NULL
	)
	--
	-- PopulateOrderList
	EXEC [2019PI_Master_PopulateOrderList] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@includetestpat,
		@Debug
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblOrderList]
		ORDER BY [OrderDate] DESC 
	END

	-- Create work table that will hold the Meaningful Use results
	CREATE TABLE [#tblMeaningfulUseDetail] 
	(
		[RowId]				[int] IDENTITY(1,1) PRIMARY KEY, -- Primary Key
		[ItemDefinitionUid]	[uniqueidentifier], -- MeaningfulUseItemDefinition.ItemDefinitionUid
		[CategoryName]		[varchar](500) NULL, -- MeaningfulUseCategoryDefinition.CategoryName
		[CategoryNumber]	[int] NULL, -- MeaningfulUseCategoryDefinition.CategoryNumber
		[MeasureNumber]		[int] NULL, -- MeaningfulUseItemDefinition.MeasureNumber 
		[SubMeasureNumber]	[int] NULL, -- MeaningfulUseItemDefinition.SubMeasureNumber
		[PersonUid]			[uniqueidentifier] NULL, -- Unique list of Visit.PatientUid
		[PersonLnFn]		[varchar](150) NULL, -- Patient name
		[ProviderUid]		[varchar](MAX) NULL,
		[ProviderLnFn]		[varchar](150) NULL, 
		[NumeratorValue]	[int] NULL, -- See MeaningfulUseItemDefinition.NumeratorDesc
		[DenominatorValue]	[int] NULL, -- See MeaningfulUseItemDefinition.DenominatorDesc
		[YesNo]				[int] NULL -- See MeaningfulUseItemdefinition.YesNo. Null-NA, 0-No/False, 1-Yes/True.
		unique clustered (RowId)
	) 
 
	CREATE NONCLUSTERED INDEX [MUDetail_ItemDef_PersonUid] ON #tblMeaningfulUseDetail
	(
		ItemDefinitionUid ASC,
		PersonUid ASC
	)
	WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]


	-- Params used in determining if any detail rows were found for given metric
	CREATE TABLE [#tblMetricUidsWithoutDetailRows] 
	(
		[ItemDefinitionUid] [uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED
	)

	-- Create temp table that can be used by measure procs
	CREATE TABLE [#MetricDataTemp]
	(
		[PersonUid] [uniqueidentifier] NOT NULL,
		[HeightRecorded] [int] NULL,
		[WeightRecorded] [int] NULL,
		[BloodPressureRecorded] [int] NULL,
		[LabResultTotalCount] [int] NULL, 
		[LabResultTemplatedCount] [int] NULL,
		[TaskDocGenCount] [int] NULL, 
		[TaskDocGenCompleteCount] [int] NULL, 
		[VisitCount] [int] NULL, 
		[ClinicalSummaryProvidedCount] [int] NULL, 
		[PreventativeFollowupDueCount] [int] NULL, 
		[PreventativeFollowupSentCount] [int] NULL, 
		[SeenByAnotherProviderCount] [int] NULL, 
		[MedicalCheckedCount] [int] NULL, 
		[ReferralCount] [int] NULL, 
		[ReferralClinicalSummaryProvided] [int] NULL
	) 	

	-- Proc based on MUII_Master_DesktopControl
	--  
	-- Calculate Measures
	-- ACI_TRANS_PPHI_1 == Objective 1 == MUII Core Measure 9
	-- Must attest yes

	-- ACI_TRANS_EP_1 == Objective 4 == MUII Core Measure 2, Sub Measure NULL; ItemDefinitionUid : F3A49E2B-E4FF-4D78-A3D5-EEA12A5FBF58
	EXEC [2023PI_E-Prescribing_1_NonControlled] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2023PI_E-Prescribing_2_Controlled] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2023PI_E-Prescribing_3_PDMP] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2023PI_HealthInformationExchange_1_Sending] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2023PI_HealthInformationExchange_2_Receiving] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE
		
	EXEC [2023PI_ProviderToPatientExchange] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	-- Drop temp tables that are used by measure procs
	BEGIN TRY
		DROP TABLE [#tblVisitList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#tblPatientList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#tblProviderList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#MetricDataTemp]
	END TRY 
	BEGIN CATCH
	END CATCH

	-- For measures that do not have any detail rows, we need to insert a row, so it will be included in the RDL report.
	DECLARE @NumDetailRows [int]
	SET @NumDetailRows = (SELECT COUNT(*) FROM [#tblMetricUidsWithoutDetailRows])
	IF (@NumDetailRows > 0)
	BEGIN
		INSERT INTO [#tblMeaningfulUseDetail] ([ItemDefinitionUid],
			[CategoryNumber],
			[CategoryName],
			[MeasureNumber],
			[SubMeasureNumber],
			[PersonUid],
			[PersonLnFn],
			[ProviderUid],
			[ProviderLnFn],
			[NumeratorValue],
			[DenominatorValue],
			[YesNo]
		)
			SELECT NoData.[ItemDefinitionUid] AS [ItemDefinitionUid]
			,(
				select mucd.[CategoryNumber] 
				from [MeaningfulUseItemDefinition] AS muid with(nolock)
					inner join [MeaningfulUseCategoryDefinition] AS mucd with(nolock) on muid.[CategoryUid] = mucd.[CategoryUid]
				where muid.[ItemDefinitionUid] = NoData.[ItemDefinitionUid]
			) AS [CategoryNumber]

			,(
				select mucd.CategoryName
				from [MeaningfulUseItemDefinition] AS muid with(nolock)
					inner join [MeaningfulUseCategoryDefinition] AS mucd with(nolock) on muid.[CategoryUid] = mucd.[CategoryUid]
				where muid.[ItemDefinitionUid] = NoData.[ItemDefinitionUid]
			) AS [CategoryName]

			,(
				select muid.[MeasureNumber]
				from [MeaningfulUseItemDefinition] AS muid with(nolock)
					inner join [MeaningfulUseCategoryDefinition] AS mucd with(nolock) on muid.[CategoryUid] = mucd.[CategoryUid]
				where muid.[ItemDefinitionUid] = NoData.[ItemDefinitionUid]
			) AS [MeasureNumber] 

			,(
				select muid.[SubMeasureNumber] 
				from [MeaningfulUseItemDefinition] AS muid with(nolock)
					inner join [MeaningfulUseCategoryDefinition] AS mucd with(nolock) on muid.[CategoryUid] = mucd.[CategoryUid]
				where muid.[ItemDefinitionUid] = NoData.[ItemDefinitionUid]
			) AS [SubMeasureNumber] 

			,NULL AS [PersonUid] 
			,'N / A' AS [PersonLnFn]
			,NULL AS [ProviderUid] 
			,'' AS [ProviderLnFn]
			,0 AS [NumeratorValue]
			,0 AS [DenominatorValue]
			,0 AS [YesNo]
		FROM [#tblMetricUidsWithoutDetailRows] AS [NoData] 
	END

	--
	-- For measures that are Yes/No (Must attest Yes), insert a detail row that will be included in the RDL report
	--

	---- ACI_TRANS_PPHI_1 == Objective 1 == MUII Core Measure 9
	DECLARE @ItemDefinitionUid [uniqueidentifier] --= '1D8DEE46-CB1A-45DD-B0FF-FE04DDBD1310' 
	--EXEC [MUI_Master_Report_InsertAttestMeasureDetail] @ItemDefinitionUid, @ReportMode,	@Debug

	---- Pick 2 registries
	--SET @ItemDefinitionUid = 'CC4FF4BA-CA32-41F7-A157-5426E59C81AE' 
	--EXEC [MUI_Master_Report_InsertAttestMeasureDetail] @ItemDefinitionUid, @ReportMode, @Debug

	-- Define table that will be returned to caller
	DECLARE @tblMeaingfulUseSummaryCoreAndMenuSet TABLE
	(
		[RowId]             [int] IDENTITY(1,1) PRIMARY KEY,
		[ItemDefinitionUid] [uniqueidentifier],
		[CategoryNumber]    [int] NULL,
		[CategoryName]      [varchar](100) NULL,
		[MeasureNumber]     [int] NULL, 
		[SubMeasureNumber]  [int] NULL,
		[MeasureDesc]       [varchar](500) NULL,
		[DenominatorDesc]   [varchar](250) NULL,
		[DenominatorValue]  [int] NULL,
		[NumeratorDesc]     [varchar](250) NULL,
		[NumeratorValue]    [int] NULL,
		[YesNo]     [varchar](50)  NULL,
		[CurrentValue]	  [varchar](25)  NULL,
		[GoalDesc]          [varchar](250) NULL,
		[GoalValue]         [varchar](10)  NULL,
		[MetGoal]           [bit] NULL, 
		[ProviderUid]       [varchar](max) NULL,
		[ProviderLnFn]      [varchar](150) NULL,       
		unique clustered  ([RowId])
	) 

	-- Determine if there are any MU detail rows to base metrics against
	-- Walk through list of defined Meaningful Use metrics and popluate @tblMeaingfulUseSummaryCoreAndMenuSet 
	DECLARE @CategoryUid [uniqueidentifier]
		, @CategoryNumber [int]
		, @CategoryName [varchar](100)
		, @MeasureNumber [int]
		, @SubMeasureNumber [int]
		, @MeasureDesc [varchar](500)
		, @ExclusionDesc [varchar](250)
		, @DenominatorDesc [varchar](250)
		, @NumeratorDesc [varchar](250)
		, @YesNo [varchar](50)
		, @GoalDesc [varchar](250)
		, @GoalValue [decimal](5, 2)
		, @DenominatorSumValue [int]
		, @NumeratorSumValue [int]
		, @CurValue [varchar](25)
		, @MetGoal [bit]    
        
    --
    -- Populate table that will be returned to caller
	DECLARE cursor_MU_Definitions CURSOR FAST_FORWARD FOR 
		SELECT muid.[ItemDefinitionUid]
			, muid.[CategoryUid]
			, mucd.[CategoryNumber]
			, mucd.[CategoryName]
			, muid.[MeasureNumber]
			, muid.[SubMeasureNumber]
			, muid.[MeasureDesc]
			, muid.[ExclusionDesc]
			, muid.[DenominatorDesc]
			, muid.[NumeratorDesc]
			, muid.[YesNo]
			, muid.[GoalDesc]
			, muid.[GoalValue]
		FROM [MeaningfulUseItemDefinition] AS muid with(nolock)
			INNER JOIN [MeaningfulUseCategoryDefinition] AS mucd with(nolock) ON muid.[CategoryUid] = mucd.[CategoryUid]
/*Replace w/new StageUid*/		WHERE muid.[StageUid] = 'F7671FC8-43C3-4F60-8CF0-4DA79A0A28F7'   -- 2023 PI
		ORDER BY mucd.[CategoryName]
			, mucd.[CategoryNumber]
			, muid.[MeasureNumber]
    --
    OPEN cursor_MU_Definitions
    --
	FETCH NEXT FROM cursor_MU_Definitions 
		INTO @ItemDefinitionUid
			, @CategoryUid
			, @CategoryNumber
			, @CategoryName
			, @MeasureNumber
			, @SubMeasureNumber
			, @MeasureDesc
			, @ExclusionDesc
			, @DenominatorDesc
			, @NumeratorDesc
			, @YesNo
			, @GoalDesc
			, @GoalValue 
    --
   -- Make sure we have a valid cursor row
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @DenominatorSumValue = 0
		SET @NumeratorSumValue = 0
		SET @CurValue = '' 
		SET @MetGoal = 0 
		SET @NumDetailRows = 0
		
		-- Check if current MU metric has a numerator and denominator
		IF @YesNo IS NULL
		BEGIN
			-- Make sure we have some data for current metric
			SET @NumDetailRows = (SELECT COUNT(*)
								  FROM [#tblMeaningfulUseDetail]
								  WHERE [ItemDefinitionUid] = @ItemDefinitionUid
								 )
			IF (@NumDetailRows > 0)
			BEGIN
				-- Current MU metric has a numerator and demoninator
				SELECT  @DenominatorSumValue = SUM(mud.[DenominatorValue])
					, @NumeratorSumValue   = SUM(mud.[NumeratorValue]) 
				FROM     [#tblMeaningfulUseDetail] AS mud
				WHERE    mud.[ItemDefinitionUid] = @ItemDefinitionUid
				GROUP BY mud.[ItemDefinitionUid] 
			END    
           
			IF @DenominatorSumValue <= 0
			BEGIN
				SET @CurValue = 'N/A' 
			END 
			ELSE IF @NumeratorSumValue <= 0
			BEGIN 
				SET @CurValue = '0.00%' 
			END 
			ELSE 
			BEGIN 
				-- Calculate current MU metric value
				SET @CurValue = CONVERT(VARCHAR(10), CONVERT(DECIMAL(8,2), (CONVERT(DECIMAL(8,2), @NumeratorSumValue) / CONVERT(DECIMAL(8,2), @DenominatorSumValue)) * 100)) + '%'
	                  
				-- Determine if goal is satisfied
				IF CONVERT(DECIMAL(8,2), (CONVERT(DECIMAL(8,2), @NumeratorSumValue) / CONVERT(DECIMAL(8,2), @DenominatorSumValue)) * 100) > @GoalValue
				BEGIN
					SET @MetGoal = 1
				END 
			END 
             
			-- Insert MU summary row
			INSERT INTO @tblMeaingfulUseSummaryCoreAndMenuSet ([ItemDefinitionUid]
				, [CategoryNumber]
				, [CategoryName]
				, [MeasureNumber]
				, [SubMeasureNumber]
				, [MeasureDesc]
				, [DenominatorDesc]
				, [DenominatorValue]
				, [NumeratorDesc]
				, [NumeratorValue]
				, [YesNo]
				, [CurrentValue]
				, [GoalDesc]
				, [GoalValue]
				, [MetGoal]
				, [ProviderUid]
				, [ProviderLnFn]
			)   
			VALUES (@ItemDefinitionUid
				, @CategoryNumber
				, @CategoryName
				, @MeasureNumber
				, @SubMeasureNumber
				, @MeasureDesc
				, @DenominatorDesc
				, @DenominatorSumValue
				, @NumeratorDesc
				, @NumeratorSumValue
				, @YesNo
				, @CurValue
				, @GoalDesc
				, CONVERT([varchar](10), @GoalValue)
				, @MetGoal
				, null
				, null
			)  
		END 
		ELSE 
		BEGIN
			-- Current MU metric is YES/NO.  
			INSERT INTO @tblMeaingfulUseSummaryCoreAndMenuSet([ItemDefinitionUid]
				, [CategoryNumber]
				, [CategoryName]
				, [MeasureNumber]
				, [SubMeasureNumber]
				, [MeasureDesc]
				, [DenominatorDesc]
				, [DenominatorValue]
				, [NumeratorDesc]
				, [NumeratorValue]
				, [YesNo]
				, [CurrentValue]
				, [GoalDesc]
				, [GoalValue]
				, [MetGoal]
				, [ProviderUid]
				, [ProviderLnFn]
			)  
			VALUES (@ItemDefinitionUid
				, @CategoryNumber
				, @CategoryName
				, @MeasureNumber
				, @SubMeasureNumber
				, @MeasureDesc
				, @DenominatorDesc
				, null
				, @NumeratorDesc
				, null
				, @YesNo
				, null
				, @GoalDesc
				, null
				, null
				, null
				, null
			)  
		END
		-- 
		-- Get next cursor_MU_Definitions row
		FETCH NEXT FROM cursor_MU_Definitions INTO @ItemDefinitionUid
			, @CategoryUid
			, @CategoryNumber
			, @CategoryName
			, @MeasureNumber
			, @SubMeasureNumber
			, @MeasureDesc
			, @ExclusionDesc
			, @DenominatorDesc
			, @NumeratorDesc
			, @YesNo
			, @GoalDesc
			, @GoalValue 
    END
    --
    -- Close and Deallocate cursor
    CLOSE cursor_MU_Definitions
    DEALLOCATE cursor_MU_Definitions

	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CUS_MeaningfulUseDetail]') AND type in (N'U'))
	BEGIN
	CREATE TABLE [dbo].[CUS_MeaningfulUseDetail](
		[MeaningfulUseDetailUid] [uniqueidentifier] NOT NULL,
		[ReportInstanceUid] [uniqueidentifier] NOT NULL,
		[ItemDefinitionUid] [uniqueidentifier] NULL,
		[CategoryName] [varchar](500) NULL,
		[CategoryNumber] [int] NULL,
		[MeasureNumber] [int] NULL,
		[SubMeasureNumber] [int] NULL,
		[PersonUid] [uniqueidentifier] NULL,
		[PersonLnFn] [varchar](150) NULL,
		[ProviderUid] [varchar](max) NULL,
		[ProviderLnFn] [varchar](150) NULL,
		[ProviderNPI] [varchar](250) NULL,
		[NumeratorValue] [int] NULL,
		[DenominatorValue] [int] NULL,
		[YesNo] [int] NULL,
		[ObjectiveDesc] [varchar](500) NULL,
		[MeasureDesc] [varchar](600) NOT NULL,
		[MeasureDetailDesc] [varchar](600) NULL,
		[ExclusionDesc] [varchar](600) NULL,
		[DenominatorDesc] [varchar](500) NULL,
		[NumeratorDesc] [varchar](500) NULL,
		[GoalDesc] [varchar](250) NULL,
		[LastModifiedDate] [datetime] NOT NULL,
	 CONSTRAINT [PK_CUS_MeaningfulUseDetail] PRIMARY KEY CLUSTERED 
	(
		[MeaningfulUseDetailUid] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
	END

	IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CUS_MeaningfulUseDetail]') AND name = N'IX_CUS_MeaningfulUseDetail')
		CREATE NONCLUSTERED INDEX [IX_CUS_MeaningfulUseDetail] ON [dbo].[CUS_MeaningfulUseDetail]
		(
			[ReportInstanceUid] ASC,
			[ItemDefinitionUid] ASC,
			[PersonUid] ASC
		)
		INCLUDE ( 	[CategoryName],
			[CategoryNumber],
			[MeasureNumber],
			[NumeratorValue],
			[DenominatorValue],
			[ExclusionDesc],
			[DenominatorDesc],
			[SubMeasureNumber],
			[PersonLnFn],
			[ProviderUid],
			[ProviderLnFn],
			[NumeratorDesc],
			[GoalDesc],
			[YesNo],
			[ObjectiveDesc],
			[MeasureDesc],
			[MeasureDetailDesc],
			[MeaningfulUseDetailUid],
			[ProviderNPI],
			[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF_CUS_MeaningfulUseDetail_MeaningfulUseDetailUid]') AND type = 'D')
	BEGIN
		ALTER TABLE [dbo].[CUS_MeaningfulUseDetail] ADD  CONSTRAINT [DF_CUS_MeaningfulUseDetail_MeaningfulUseDetailUid]  DEFAULT (newid()) FOR [MeaningfulUseDetailUid]
	END

	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF_CUS_MeaningfulUseDetail_LastModifiedDate]') AND type = 'D')
	BEGIN
		ALTER TABLE [dbo].[CUS_MeaningfulUseDetail] ADD  CONSTRAINT [DF_CUS_MeaningfulUseDetail_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
	END

	EXEC MIPS_2018_Master_Report_DeleteReportInstance @ReportInstanceUid
	--
	-- Return detail table to caller
	--
	INSERT [CUS_MeaningfulUseDetail](
		[ReportInstanceUid],
		[ItemDefinitionUid],
		[CategoryName],
		[CategoryNumber],
		[MeasureNumber],
		[SubMeasureNumber],
		[PersonUid],
		[PersonLnFn],
		[ProviderUid],
		[ProviderLnFn],
		[ProviderNPI],
		[NumeratorValue],
		[DenominatorValue],
		[YesNo],
		[ObjectiveDesc],
		[MeasureDesc],
		[MeasureDetailDesc],
		[ExclusionDesc],
		[DenominatorDesc],
		[NumeratorDesc],
		[GoalDesc]
	)
	SELECT @ReportInstanceUid AS [ReportInstanceUid],
		t.[ItemDefinitionUid],
		COALESCE(t.[CategoryName], mucd.[CategoryName]) AS [CategoryName],
		t.[CategoryNumber],
		t.[MeasureNumber],
		t.[SubMeasureNumber],
		t.[PersonUid],
		t.[PersonLnFn],
		[ProviderUid],
		t.[ProviderLnFn],
		@ProviderNPI AS [ProviderNPI],
		t.[NumeratorValue],
		t.[DenominatorValue],
		t.[YesNo],
		MUID.[ObjectiveDesc],
		MUID.[MeasureDesc],
		MUID.[MeasureDetailDesc],
		MUID.[ExclusionDesc],
		MUID.[DenominatorDesc],
		MUID.[NumeratorDesc],
		MUID.[GoalDesc]
	FROM [#tblMeaningfulUseDetail] AS t
		INNER JOIN [MeaningfulUseItemDefinition] AS MUID with(nolock) ON MUID.[ItemDefinitionUid] = t.[ItemDefinitionUid]
		INNER JOIN [MeaningfulUseCategoryDefinition] AS mucd with (nolock) ON MUID.[CategoryUid] = mucd.[CategoryUid]
	ORDER BY [CategoryName] ASC,
		[CategoryNumber] ASC,
		[MeasureNumber] ASC,
		[SubMeasureNumber] ASC,
		[NumeratorValue] DESC,
		[DenominatorValue] DESC,
		[PersonLnFn] ASC 
	
	BEGIN TRY
		DROP TABLE [#tblMeaningfulUseDetail]
	END TRY
	BEGIN CATCH
	END CATCH
	
	-- Return Meaningful Use results to caller
	SELECT [RowId]
		, [ItemDefinitionUid]
		, [CategoryNumber]
		, [CategoryName]
		, [MeasureNumber]
		, [SubMeasureNumber]
		, [MeasureDesc]
		, [DenominatorDesc]
		, [DenominatorValue]
		, [NumeratorDesc]
		, [NumeratorValue]
		, [YesNo]
		, [CurrentValue]
		, [GoalDesc]
		, [GoalValue]
		, [MetGoal]
		, [ProviderUid]
		, [ProviderLnFn]
	FROM @tblMeaingfulUseSummaryCoreAndMenuSet    
	ORDER BY [CategoryNumber] ASC
		, [MeasureNumber] ASC
		, [SubMeasureNumber] ASC 
	
	IF (@Debug <> 0)
	BEGIN
		SELECT 'GOOD BYE'
	END 
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2024PI_E-Prescribing_1_NonControlled]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2024PI_E-Prescribing_1_NonControlled] AS' 
END
GO
ALTER   PROC [dbo].[2024PI_E-Prescribing_1_NonControlled]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

	IF (@Debug = 1)
	BEGIN
		SELECT '2024PI_E-Prescribing_1_NonControlled-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = '08BC1CF0-ABCF-4126-B9D8-89A2237A21E6',
		@RxStatusTransmittedSuccessfully [uniqueidentifier] = 'B1F7EFAF-D56D-4BAD-AE1F-8205E1D00B58', 
		@RxStatusQueuedForTransmission   [uniqueidentifier] = '0605B6F6-2FE4-49CB-B868-9DF448AB3E01'

	TRUNCATE TABLE #MetricDataTemp

	-- Initialize work table
	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
	SELECT @ItemDefinitionUid AS [ItemDefinitionUid]
		, med.[PersonUid]
		, COUNT(sts.[eRxStatusUid]) AS [NumeratorValue]                        
		, COUNT(med.[MedicationSIGUid]) AS [DenominatorValue]
		, null AS [YesNo]
	FROM   [#tblMedicationList] AS med
		LEFT JOIN [ListeRxStatus] AS sts WITH(NOLOCK) ON  med.[eRxStatusUid] = sts.[eRxStatusUid]
		 AND (sts.[eRxStatusUid] IN(@RxStatusTransmittedSuccessfully, @RxStatusQueuedForTransmission))
	WHERE med.[Dispensable] = 1
		AND med.[IsSampleGiven] = 0
		AND med.[IsAdministered] = 0
		AND med.[reffederaldeaclasscode] = 0
		AND [SIGDetailCount] = 1
	GROUP BY med.[PersonUid]
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2024PI_E-Prescribing_1_NonControlled -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2024PI_E-Prescribing_2_Controlled]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2024PI_E-Prescribing_2_Controlled] AS' 
END
GO
ALTER   PROC [dbo].[2024PI_E-Prescribing_2_Controlled]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

	IF (@Debug = 1)
	BEGIN
		SELECT '2024PI_E-Prescribing_2_Controlled-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = '5898B6F2-8FA1-4640-ADAB-0792701125B6',
		@RxStatusTransmittedSuccessfully [uniqueidentifier] = 'B1F7EFAF-D56D-4BAD-AE1F-8205E1D00B58', 
		@RxStatusQueuedForTransmission   [uniqueidentifier] = '0605B6F6-2FE4-49CB-B868-9DF448AB3E01'

	TRUNCATE TABLE #MetricDataTemp

	-- Initialize work table
	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
	SELECT @ItemDefinitionUid AS [ItemDefinitionUid]
		, med.[PersonUid]
		, COUNT(sts.[eRxStatusUid]) AS [NumeratorValue]                        
		, COUNT(med.[MedicationSIGUid]) AS [DenominatorValue]
		, null AS [YesNo]
	FROM   [#tblMedicationList] AS med
		LEFT JOIN [ListeRxStatus] AS sts WITH(NOLOCK) ON  med.[eRxStatusUid] = sts.[eRxStatusUid]
		 AND (sts.[eRxStatusUid] IN(@RxStatusTransmittedSuccessfully, @RxStatusQueuedForTransmission))
	WHERE med.[Dispensable] = 1
		AND med.[IsSampleGiven] = 0
		AND med.[IsAdministered] = 0
		AND med.[reffederaldeaclasscode] >= 0
		AND [SIGDetailCount] = 1
	GROUP BY med.[PersonUid]
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2024P2_E-Prescribing_2_Controlled -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2024PI_E-Prescribing_3_PDMP]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2024PI_E-Prescribing_3_PDMP] AS' 
END
GO
ALTER   PROC [dbo].[2024PI_E-Prescribing_3_PDMP]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

	IF (@Debug = 1)
	BEGIN
		SELECT '2024PI_E-Prescribing_3_PDMP-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = 'DA69B535-32C2-4327-AE57-BF4ED57061EC',
		@RxStatusTransmittedSuccessfully [uniqueidentifier] = 'B1F7EFAF-D56D-4BAD-AE1F-8205E1D00B58', 
		@RxStatusQueuedForTransmission   [uniqueidentifier] = '0605B6F6-2FE4-49CB-B868-9DF448AB3E01'

	TRUNCATE TABLE #MetricDataTemp

	-- Initialize work table
	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
	--THIS is not the right query
	--And needs to be changed to what is correct
	SELECT @ItemDefinitionUid AS [ItemDefinitionUid]
		, med.[PersonUid]
		, CASE WHEN a.PatientUid IS NOT NULL THEN 1 ELSE 0 END AS [NumeratorValue]                        
		, CASE WHEN med.PersonUid IS NOT NULL THEN 1 ELSE 0 END AS [DenominatorValue]
		, null AS [YesNo]
	FROM   [#tblMedicationList] AS med
	INNER JOIN [ListeRxStatus] AS sts WITH(NOLOCK) ON  med.[eRxStatusUid] = sts.[eRxStatusUid]
		 AND (sts.[eRxStatusUid] IN(@RxStatusTransmittedSuccessfully, @RxStatusQueuedForTransmission))
	LEFT JOIN cus_PDMP_Pats a on med.PersonUid = a.PatientUid
	WHERE med.[Dispensable] = 1
		AND med.[IsSampleGiven] = 0
		AND med.[IsAdministered] = 0
		AND med.[reffederaldeaclasscode] >= 2
		AND [SIGDetailCount] = 1
	GROUP BY med.[PersonUid], a.PatientUid
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2024PI_E-Prescribing_3_PDMP -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2024PI_HealthInformationExchange_1_Sending]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2024PI_HealthInformationExchange_1_Sending] AS' 
END
GO
ALTER   PROC [dbo].[2024PI_HealthInformationExchange_1_Sending]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

	IF (@Debug = 1)
	BEGIN
		SELECT '2024PI_HealthInformationExchange_1_Sending-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

     DECLARE @UTC_RptTimespan_StartDate DATETIME,@UTC_RptTimespan_EndDate DATETIME
      SELECT @UTC_RptTimespan_StartDate = @RptTimespan_StartDate
      SELECT @UTC_RptTimespan_EndDate   = DATEADD(DAY,1,@RptTimespan_EndDate)

      --RecordDisclosureAudit limit range, -1 day from min referral date and +3 days to max referral date
      DECLARE @RecordDisclosureAudit_StartDate DATE,@RecordDisclosureAudit_EndDate DATE
      SELECT @RecordDisclosureAudit_StartDate = DATEADD(DAY,-1,@RptTimespan_StartDate)
      SELECT @RecordDisclosureAudit_EndDate   = DATEADD(DAY,3,@RptTimespan_EndDate)

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = '3BEED90D-F686-4D1D-B060-F4FFE8BDE266'
	DECLARE @ExcludedReferrals TABLE (PatientReferralUid UNIQUEIDENTIFIER)

	INSERT INTO @ExcludedReferrals
	SELECT ViewUid FROM ViewPatientOutboundReferral v
	INNER JOIN ListProviderCareType p WITH(NOLOCK) on v.ProviderCareTypeUid = p.ProviderCareTypeUid AND p.ExcludeFromReferrals = 1

	INSERT INTO @ExcludedReferrals
	SELECT PatientReferralUid FROM PatientReferral WHERE ReferralTrackingStatusUid = 'F7D1B72C-83ED-4D2E-8AB2-2B86F31E8EB2'

      TRUNCATE TABLE #MetricDataTemp

      ;WITH cte_pr AS (
            select pr.*,dbo.UDF_CQMTestPatient (pr.PatientUid) AS TestPatient
            FROM ViewPatientReferralConsultReport pr 
			INNER JOIN #tblVisitList t on pr.VisitUid = t.VisitUid
            LEFT JOIN PatientReferral p WITH(NOLOCK) on pr.PatientReferralUid = p.PatientReferralUid
            LEFT JOIN VisitProcedure vp WITH(NOLOCK) on p.VisitProcedureUid = vp.VisitProcedureUid
            LEFT JOIN ListProcedure lp WITH(NOLOCK) on vp.ProcedureUid = lp.ProcedureUid      
			LEFT JOIN @ExcludedReferrals er on pr.PatientReferralUid = er.PatientReferralUid
            WHERE pr.RefType = 'PatientReferral'
                        AND (pr.ReferredByProviderUid IN (SELECT Element FROM dbo.Split(@ProviderUid, ',')) OR @ProviderUid IS NULL)
                        AND pr.ReferralDate >= @UTC_RptTimespan_StartDate AND pr.ReferralDate < @RecordDisclosureAudit_EndDate
                        AND (lp.ProcedureCodeTypeUid IS NULL OR lp.ProcedureCodeTypeUid NOT IN ('1E605C00-13F0-4B95-AEDB-7AA2E30A8BED'))
						AND er.PatientReferralUid IS NULL
      ),
      cte_rda AS (
            SELECT [DisclosureDate] ,
                  [DisclosureType] ,
                  [PatientUid] ,
                  rda.[PatientReferralUid] ,
                  [AttachmentGroupUid] ,
                  rda.[VisitUid] ,
                  [IsPortal],
                  [DisclosureMethod],
                  [Status],
                  [DisclosurePurpose]
            FROM RecordDisclosureAudit rda WITH(NOLOCK)
            WHERE DisclosureDate >= @RecordDisclosureAudit_StartDate
                  AND DisclosureType in (1,    -- Complete Chart
                                                      2,    -- Clinical Summary
                                                      11)  -- ContinuityOfCareDocument
                  AND DisclosureMethod IN (1,5,6,7)
                  AND DisclosurePurpose <> 'Released to Patient'
                  AND [Status] > 0
      )
      INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
            SELECT @ItemDefinitionUid AS ItemDefinitionUid
                        ,r.PatientUid
                         ,COUNT(distinct CASE WHEN  rda.DisclosureType IS NOT NULL and rda.status = 4 THEN rda.PatientReferralUid
                              ELSE NULL END) AS NumeratorValue            
						,COUNT(distinct CASE WHEN r.PatientReferralUid is not null  and (r.ReferralStatus in ('Initiated', 'Appointment Confirmed')) THEN r.PatientReferralUid
                             ELSE NULL END) AS DenominatorValue 
                        ,null AS YesNo
            FROM cte_pr r 
           LEFT JOIN cte_rda rda ON r.PatientUid=rda.patientuid AND
                                    (
                                          r.VisitUid=rda.VisitUid 
                                          OR r.PatientReferralUid=rda.PatientReferralUid 
                                          OR r.AttachmentGroupUid=rda.AttachmentGroupUid
                                          --OR DATEDIFF(day,r.ReferralDate,rda.DisclosureDate) >= -1
                                    )
            WHERE r.TestPatient = 0
            GROUP BY r.PatientUid
            
      UPDATE #tblMeaningfulUseDetail
      SET NumeratorValue = 
            CASE 
                  WHEN NumeratorValue > DenominatorValue THEN DenominatorValue 
                  ELSE NumeratorValue 
            END
	  WHERE ItemDefinitionUid = @ItemDefinitionUid
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2024PI_HealthInformationExchange_1_Sending -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2024PI_HealthInformationExchange_2_Receiving]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2024PI_HealthInformationExchange_2_Receiving] AS' 
END
GO
ALTER   PROC [dbo].[2024PI_HealthInformationExchange_2_Receiving]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

	IF (@Debug = 1)
	BEGIN
		SELECT '2024PI_HealthInformationExchange_2_Receiving-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

	DECLARE @UTC_RptTimespan_StartDate DATETIME,@UTC_RptTimespan_EndDate DATETIME
	SELECT @UTC_RptTimespan_StartDate = @RptTimespan_StartDate, @UTC_RptTimespan_EndDate = @RptTimespan_EndDate
	SELECT @UTC_RptTimespan_StartDate = '01/01/'+CONVERT(VARCHAR(4),DATEPART(YEAR,@UTC_RptTimespan_StartDate))

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = 'B0B912AF-E1EE-4E95-A352-3F7672CAB41F'

	DECLARE @InitiatedReferrals TABLE (PatientReferralUid UNIQUEIDENTIFIER)
	INSERT INTO @InitiatedReferrals
	SELECT DISTINCT PatientReferralUid 
	FROM PatientReferralHistory 
	WHERE ReferralTrackingStatusUid IN ('0673DB25-454C-44D8-B83F-AFCF97879AAD','3B180FEC-FAE0-4850-AE16-6172CC31F7A7')

	TRUNCATE TABLE #MetricDataTemp

	;WITH cte_Ref AS (
	SELECT vfp.PersonUid AS PatUid
			, rag.VisitUid AS Uid
			, COALESCE(a.AttachmentUid, ag.AttachmentGroupUid) AS AttUid
			, COALESCE(a.FileDate, ag.LastModifiedDate) AS AttDate
			, aa.HasClinicalDocument AS NumID
			, aa.MedicationAllergiesReconciledDate
			, aa.MedicationsReconciledDate
			, aa.ProblemsReconciledDate
			, a.AttachmentTypeUid
			, latDM.ExternalID AS AttachmentTypeID
	FROM #tblPatientList vfp
	INNER JOIN RelAttachmentGroup rag on vfp.PersonUid = rag.PersonUid
	INNER JOIN Visit v on rag.VisitUid = v.VisitUid AND (v.VisitDate >= @RptTimespan_StartDate AND v.VisitDate <= @RptTimespan_EndDate)
	INNER JOIN #tblProviderList prov on v.ProviderUid = prov.ProviderUid
	LEFT JOIN Attachment a on rag.AttachmentGroupUid = a.AttachmentGroupUid
	LEFT JOIN ListAttachmentType latDM on a.AttachmentTypeUid = latDM.AttachmentTypeUid
	LEFT JOIN AttachmentGroup ag on rag.AttachmentGroupUid = ag.AttachmentGroupUid
	INNER JOIN ListAttachmentType lat on (a.AttachmentTypeUid = lat.AttachmentTypeUid OR ag.AttachmentTypeUid = lat.AttachmentTypeUid) AND (lat.AttachmentTypeUid = 'B71B8F20-7B7D-4A7C-9E75-05811A0791AD')
	LEFT JOIN MessageAA aa on rag.RelAttachmentGroupUid = aa.RelAttachmentGroupUid --AND aa.SummaryOfCareReconciledDate IS NOT NULL
	LEFT JOIN Message m on aa.MessageUid = m.MessageUid

	UNION ALL

	SELECT vfp.PersonUid AS PatUid
			, pr.PatientReferralUid AS Uid
			, aa.MessageUid AS AttUid
			, pr.CreatedDate AS AttDate
			, aa.HasClinicalDocument AS NumID
			, aa.MedicationAllergiesReconciledDate
			, aa.MedicationsReconciledDate
			, aa.ProblemsReconciledDate
			, att.AttachmentTypeUid
			, lat.ExternalID AS AttachmentTypeID
	FROM #tblPatientList vfp
	INNER JOIN RelAttachmentGroup r ON vfp.PersonUid = r.PersonUid
	INNER JOIN MessageAA aa ON aa.RelAttachmentGroupUid = r.RelAttachmentGroupUid --AND aa.ElectronicSummaryOfCareReceived = 1
	LEFT JOIN Attachment att on r.AttachmentGroupUid = att.AttachmentGroupUid
	LEFT JOIN ListAttachmentType lat on att.AttachmentTypeUid = lat.AttachmentTypeUid
	INNER JOIN PatientReferral pr on r.PatientReferralUid = pr.PatientReferralUid 
			AND (pr.CreatedDate >= @RptTimespan_StartDate AND pr.CreatedDate <= @RptTimespan_EndDate)
			AND pr.ReferralTrackingStatusUid <> '3B180FEC-FAE0-4850-AE16-6172CC31F7A7'
	INNER JOIN PatientProviderRelationship ppr on pr.PatientProviderRelationshipUid = ppr.PatientProviderRelationshipUid
	INNER JOIN #tblProviderList prov on pr.ReferredByProviderUid = prov.ProviderUid
	INNER JOIN @InitiatedReferrals ir on pr.PatientReferralUid = ir.PatientReferralUid
	)


	--SELECT * FROM cte_Ref
	INSERT INTO #tblMeaningfulUseDetail (ItemDefinitionUid, PersonUid, NumeratorValue, DenominatorValue, YesNo)
		SELECT @ItemDefinitionUid AS ItemDefinitionUid
				,PatUid
				,COUNT(distinct CASE WHEN MedicationAllergiesReconciledDate IS NOT NULL 
						AND MedicationsReconciledDate IS NOT NULL
						AND ProblemsReconciledDate IS NOT NULL
							THEN Uid
						WHEN AttachmentTypeUid = '91293E86-6AA1-4B30-AA00-7DDD42135D64' THEN Uid
						WHEN AttachmentTypeID = 'DMail' THEN Uid
							ELSE NULL END) AS NumeratorValue
				,COUNT(DISTINCT Uid) AS DenominatorValue
				,NULL AS YesNo
		FROM cte_Ref
		GROUP BY PatUid


	IF EXISTS (
		SELECT TOP 1 *
		FROM #tblMeaningfulUseDetail
		WHERE [ItemDefinitionUid] = @ItemDefinitionUid
	)
    BEGIN
	    UPDATE [#tblMeaningfulUseDetail]
		SET [NumeratorValue] = CASE WHEN [NumeratorValue] > [DenominatorValue] THEN [DenominatorValue] ELSE [NumeratorValue] END
    END
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2024PI_HealthInformationExchange_2_Receiving -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2024PI_ProviderToPatientExchange]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2024PI_ProviderToPatientExchange] AS' 
END
GO
ALTER   PROC [dbo].[2024PI_ProviderToPatientExchange]
(
    @ProviderUid           VARCHAR(MAX),
    @ProviderBilling       BIT,
	@RptTimespan_StartDate DATE,
	@RptTimespan_EndDate   DATE,
	@ReportMode            BIT, 
	@Debug                 INT
)
AS
BEGIN
	
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

	IF (@Debug = 1)
	BEGIN
		SELECT '2024PI_ProviderToPatientExchange-- STARTING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

	-- MUIII Core Measure 2
	-- ================================================
	--
	-- Objective         : Fill
	--
	-- Goal              : Fill
	--                     
	--                
	-- Exclusion         : Fill
	--                      
	--                      
	--                     
	--
	-- Denominator       : Fill
	--                     
	--                     
	--
	-- Numerator         : Fill
	--                     
	--

	DECLARE @ItemDefinitionUid UNIQUEIDENTIFIER = '5745B3F8-606B-4CFE-9DF0-6FE5F7790275'

	TRUNCATE TABLE [#MetricDataTemp]

	-- Populate Denominator Value
	INSERT INTO [#tblMeaningfulUseDetail] ([ItemDefinitionUid]
		, [PersonUid]
		, [NumeratorValue]
		, [DenominatorValue]
		, [YesNo]
	)
	SELECT @ItemDefinitionUid AS [ItemDefinitionUid]
		, p.PersonUid
		, COUNT(DISTINCT CASE WHEN p.[HasPortalAccount] <> 0 THEN p.[PersonUid]
				ELSE NULL END)AS [NumeratorValue]           
		, COUNT(DISTINCT p.[PersonUid]) AS [DenominatorValue]
		, null AS [YesNo]
	FROM  [#tblPatientList] AS p
	WHERE (p.[IsEM] <> 0 OR p.IsVP <> 0)
	GROUP BY p.[PersonUid]
                       
            
	IF (@ReportMode = 1)
	BEGIN
		EXEC [MUI_Master_Report_UpdateDetailInformation] @ItemDefinitionUid, @ReportMode, @Debug
	END
	
	                   
	IF (@Debug = 1)
	BEGIN
		SELECT '2024PI_ProviderToPatientExchange -- ENDING : ' + CONVERT(VARCHAR, GETDATE(), 120)
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2024PI_Master_DesktopControl]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2024PI_Master_DesktopControl] AS' 
END
GO
ALTER   PROC [dbo].[2024PI_Master_DesktopControl]
(
	@ProviderUid			[varchar](max) = NULL,  
	@RptTimespan_StartDate	[date],
	@RptTimespan_EndDate	[date],
	@ProviderBilling		[bit] = 1,
	@ProviderRendering		[bit] = 0,
	@Debug					[int] = 0,
	@includetestpat			[bit] = 0,
	@ServiceSiteUID			[varchar](max) = null, 
	@FinancialCenterUID		[varchar](max) = null
)
AS
BEGIN

SET NOCOUNT ON;
SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;
	--
	-- Calling syntax :    
	--
	--

	IF (@RptTimespan_StartDate IS NULL)
	BEGIN
		SET @RptTimespan_StartDate = '01-01-1900'
	END 
	IF (@RptTimespan_EndDate IS NULL)
	BEGIN
		SET @RptTimespan_EndDate = GETDATE()
	END 

	CREATE TABLE [#tblProviderList]
	(
		[ProviderUid] [uniqueidentifier] NOT NULL primary key clustered
	)
	 	 
	DECLARE @HasProviderUid [bit] = 0
	EXEC [2019PI_Master_PopulateProviderList] @ProviderUid, @HasProviderUid out

	-- Measure stored procedure flag indicating Meaningful Use data will be used for a report
	DECLARE @ReportMode [bit] = 0

	IF NOT EXISTS (SELECT 1 FROM sysobjects WHERE Name='cus_PDMP_Pats' and XType='U')
		EXEC FillPDMPPatsTable
		

	CREATE TABLE [#tblVisitList]
	(
		[VisitUid]							[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[VisitDate]							[date]         NOT NULL,
		[PatientUid]						[uniqueidentifier] NOT NULL,
		[TestPat]					   		[bit],
		[IsEM]								[bit],
		[IsVP]								[bit],
		[ProviderUid]						[varchar](max),
		[RenderingProviderUid]				[varchar](max),
		[LastSavedByUid]					[uniqueidentifier],
		[SavedByBillingProvider]			[bit],
		[SavedByRenderingProvider]			[bit],
		[TransitionOfCare]					[bit],
		[MedicationChecked]					[bit],
		[DrugAllergyChecked]				[bit],
		[ProblemChecked]					[bit],
		[SummaryProvidedToPatient]			[date],
		[PatientDeclinedClinicalSummary]	[bit],
		[HasEduForm]						[bit],
		[HasPortalAccount]					[bit],
		[PrintedDate]						[date]
	)
	--
	-- PopulateVisitList
	EXEC [2019PI_Master_PopulateVisitList] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@Debug,
		@ServiceSiteUID,
		@FinancialCenterUID
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblVisitList]
		ORDER BY [VisitDate] DESC 
	END

	CREATE TABLE [#tblPatientList] 
	(
		[PersonUid]					[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[PatientLnFn]				[varchar](250),
		[Birthdate]					[date],
		[TestPat]					[bit],
		[IsEM]						[bit],
		[IsVP]						[bit],
		[FullDemographics]			[bit],
		[HasEduForm]				[bit],
		[EduFormPrinted]			[bit],
		[HasPortalAccount]			[bit],
		[PortalPerson]				[uniqueidentifier] NULL,
		[PortalValid]				[date] NULL,
		[PortalExpire]				[date] NULL,
		[SummaryProvidedToPatient]	[bit],
		[TransitionOfCare]			[bit],
		[MedicationChecked]			[bit],
		[SavedByBillingProvider]	[bit],
		[SavedByRenderingProvider]	[bit],
		[YearsOldOrOlder2]			[bit] NULL,
		[YearsOldOrOlder3]			[bit] NULL,
		[YearsOldOrYounger5]		[bit] NULL, 
		[YearsOldOrOlder13]			[bit] NULL,
		[YearsOldOrOlder65]			[bit] NULL
	)
	--
	-- Populate Patient List
	EXEC [2019PI_Master_PopulatePatientList] @ProviderUid, 
			@RptTimespan_StartDate,
			@RptTimespan_EndDate,
			@ProviderBilling,
			@ProviderRendering,
			@Debug

	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblPatientList]
		ORDER BY [PatientLnFn]
	END

	--back fill #tblVisitList with patient specific information
	--delete test patient records from #tblVisitList AND #tblPatientList IF @includetestpat = 0
	EXEC [2019PI_Master_SynchronizeVisitAndPatient] @Debug = @Debug,
		@IncludeTestPatients = @includetestpat

	-- Build list of Medications that are within reporting range
	CREATE TABLE #tblMedicationList
	(
		[MedicationSIGUid]					[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[CreatedDate]						[datetime] NOT NULL,
		[RelVisitMedicationUid]				[uniqueidentifier],
		[PersonUid]							[uniqueidentifier],
		[TestPat]							[bit],
		[LicensedHealthcareProfessional]	[bit] NOT NULL,
		[Dispensable]						[bit] NULL,
		[IsSampleGiven]						[bit] NOT NULL,
		[IsAdministered]					[bit] NOT NULL,
		[reffederaldeaclasscode]			[int] NULL,
		[SIGDetailCount]					[int] NULL,
		[eRxStatusUid]						[uniqueidentifier]
	)
	--
	-- PopulateMedicationList
	EXEC [2019PI_Master_PopulateMedicationList]
		@ProviderUid
		, @ProviderBilling
		, @RptTimespan_StartDate
		, @RptTimespan_EndDate
		, @includetestpat
		, @Debug
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblMedicationList]
		ORDER BY [CreatedDate] DESC 
	END

	-- Build list of Orders that are within reporting range
	CREATE TABLE [#tblOrderList]
	(
		[ObservationOrderUid]				[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[PatientUid]						[uniqueidentifier] NOT NULL,
		[TestPat]					   		[bit],
		[VPUid]								[uniqueidentifier] NULL,
		[CreatedBy]							[uniqueidentifier] NULL,
		[OrderDate]							[datetime]         NOT NULL,
		[ProcedureCodeTypeUid]				[uniqueidentifier] NULL,
		[ProcedureCodeTypeName]				[varchar](500)     NULL,
		[AttachmentTypeUid]					[uniqueidentifier] NULL,
		[AttachmentTypeName]				[varchar](500)	NULL,
		[LicensedHealthcareProfessional]	[bit]			NOT NULL,
		[ImageResultsDirectlyAccessible]	[bit]			NULL,
		[ResultStatusID]					[int]			NULL
	)
	--
	-- PopulateOrderList
	EXEC [2019PI_Master_PopulateOrderList] @ProviderUid
		, @ProviderBilling
		, @RptTimespan_StartDate
		, @RptTimespan_EndDate
		, @includetestpat
		, @Debug
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblOrderList]
		ORDER BY [OrderDate] DESC 
	END

	-- Create work table that will hold the Meaningful Use results
	CREATE TABLE [#tblMeaningfulUseDetail] 
	(
		[RowId]               [int] IDENTITY(1,1) PRIMARY KEY,     -- Primary Key
		[ItemDefinitionUid]   [uniqueidentifier],                  -- MeaningfulUseItemDefinition.ItemDefinitionUid   
		[PersonUid]           [uniqueidentifier] NULL,             -- Unique list of Visit.PatientUid
		[NumeratorValue]      [int] NULL,                          -- See MeaningfulUseItemDefinition.NumeratorDesc
		[DenominatorValue]    [int] NULL,                          -- See MeaningfulUseItemDefinition.DenominatorDesc
		[YesNo]               [int] NULL                           -- See MeaningfulUseItemdefinition.YesNo.  Null-NA, 0-No/False, 1-Yes/True.
		unique clustered ([RowId])
	)  

	CREATE NONCLUSTERED INDEX [MUDetail_ItemDef_PersonUid] ON [#tblMeaningfulUseDetail]
	(
		[ItemDefinitionUid] ASC,
		[PersonUid] ASC
	)
	WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

	-- Create temp table that can be used by measure procs
	CREATE TABLE [#MetricDataTemp]
	(
		[PersonUid]							[uniqueidentifier] NOT NULL,
		[HeightRecorded]					[int] NULL,
		[WeightRecorded]					[int] NULL,
		[BloodPressureRecorded]				[int] NULL,
		[LabResultTotalCount]				[int] NULL, 
		[LabResultTemplatedCount]			[int] NULL,
		[TaskDocGenCount]					[int] NULL, 
		[TaskDocGenCompleteCount]			[int] NULL,   
		[VisitCount]						[int] NULL, 
		[ClinicalSummaryProvidedCount]		[int] NULL,  
		[PreventativeFollowupDueCount]		[int] NULL, 
		[PreventativeFollowupSentCount]		[int] NULL,   
		[SeenByAnotherProviderCount]		[int] NULL, 
		[MedicalCheckedCount]				[int] NULL,  
		[ReferralCount]						[int] NULL, 
		[ReferralClinicalSummaryProvided]	[int] NULL
	) 	
	
	-- Proc based on MUII_Master_DesktopControl
	--  
	-- Calculate Measures
	EXEC [2024PI_E-Prescribing_1_NonControlled] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2024PI_E-Prescribing_2_Controlled] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2024PI_E-Prescribing_3_PDMP] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE
		
	EXEC [2024PI_HealthInformationExchange_1_Sending] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2024PI_HealthInformationExchange_2_Receiving] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2024PI_ProviderToPatientExchange] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	-- Drop temp tables that are used by measure procs
	BEGIN TRY
		DROP TABLE [#tblVisitList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#tblPatientList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#tblProviderList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#MetricDataTemp]
	END TRY 
	BEGIN CATCH
	END CATCH

	-- Define table that will be returned to caller
	DECLARE @tblMeaingfulUseSummaryCoreAndMenuSet TABLE
	(
		[RowId]             [int] IDENTITY(1,1) PRIMARY KEY,
		[ItemDefinitionUid] [uniqueidentifier],
		[CategoryNumber]    [int] NULL,
		[CategoryName]      [varchar](100) NULL,
		[MeasureNumber]     [int] NULL, 
		[SubMeasureNumber]  [int] NULL,
		[MeasureDesc]       [varchar](500) NULL,
		[DenominatorDesc]   [varchar](250) NULL,
		[DenominatorValue]  [int] NULL,
		[NumeratorDesc]     [varchar](250) NULL,
		[NumeratorValue]    [int] NULL,
		[YesNo]     [varchar](50)  NULL,
		[CurrentValue]	  [varchar](25)  NULL,
		[GoalDesc]          [varchar](250) NULL,
		[GoalValue]         [varchar](10)  NULL,
		[MetGoal]           [bit] NULL, 
		[ProviderUid]       [varchar](max) NULL,
		[ProviderLnFn]      [varchar](150) NULL,       
		unique clustered  ([RowId])
	) 

	-- Determine if there are any MU detail rows to base metrics against
	DECLARE @NumDetailRows [int]

	-- Walk through list of defined Meaningful Use metrics and popluate @tblMeaingfulUseSummaryCoreAndMenuSet 
	DECLARE @ItemDefinitionUid [uniqueidentifier]
		, @CategoryUid [uniqueidentifier]
		, @CategoryNumber [int]
		, @CategoryName [varchar](100)
		, @MeasureNumber [int]
		, @SubMeasureNumber [int]
		, @MeasureDesc [varchar](500)
		, @ExclusionDesc [varchar](250)
		, @DenominatorDesc [varchar](250)
		, @NumeratorDesc [varchar](250)
		, @YesNo [varchar](50)
		, @GoalDesc [varchar](250)
		, @GoalValue [decimal](5, 2)
		, @DenominatorSumValue [int]
		, @NumeratorSumValue [int]
		, @CurValue [varchar](25)
		, @MetGoal [bit]    
        
    --
    -- Populate table that will be returned to caller
	DECLARE cursor_MU_Definitions CURSOR FAST_FORWARD FOR 
		SELECT muid.[ItemDefinitionUid]
			, muid.[CategoryUid]
			, mucd.[CategoryNumber]
			, mucd.[CategoryName]
			, muid.[MeasureNumber]
			, muid.[SubMeasureNumber]
			, muid.[MeasureDesc]
			, muid.[ExclusionDesc]
			, muid.[DenominatorDesc]
			, muid.[NumeratorDesc]
			, muid.[YesNo]
			, muid.[GoalDesc]
			, muid.[GoalValue]
		FROM [MeaningfulUseItemDefinition] AS muid with(nolock)
			INNER JOIN [MeaningfulUseCategoryDefinition] AS mucd with(nolock) ON muid.[CategoryUid] = mucd.[CategoryUid]
/*Replace w/new StageUid*/		WHERE muid.[StageUid] = 'FE7C779A-DE0F-4A85-8629-D5FDFB740354'   --2023 PI
		ORDER BY mucd.[CategoryName]
			, mucd.[CategoryNumber]
			, muid.[MeasureNumber]
    --
    OPEN cursor_MU_Definitions
    --
	FETCH NEXT FROM cursor_MU_Definitions 
		INTO @ItemDefinitionUid
			, @CategoryUid
			, @CategoryNumber
			, @CategoryName
			, @MeasureNumber
			, @SubMeasureNumber
			, @MeasureDesc
			, @ExclusionDesc
			, @DenominatorDesc
			, @NumeratorDesc
			, @YesNo
			, @GoalDesc
			, @GoalValue 
    --
   -- Make sure we have a valid cursor row
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @DenominatorSumValue = 0
		SET @NumeratorSumValue = 0
		SET @CurValue = '' 
		SET @MetGoal = 0 
		SET @NumDetailRows = 0
		
		-- Check if current MU metric has a numerator and denominator
		IF @YesNo IS NULL
		BEGIN
			-- Make sure we have some data for current metric
			SET @NumDetailRows = (SELECT COUNT(*)
								  FROM [#tblMeaningfulUseDetail]
								  WHERE [ItemDefinitionUid] = @ItemDefinitionUid
								 )
			IF (@NumDetailRows > 0)
			BEGIN
				-- Current MU metric has a numerator and demoninator
				SELECT  @DenominatorSumValue = SUM(mud.[DenominatorValue])
					, @NumeratorSumValue   = SUM(mud.[NumeratorValue]) 
				FROM     [#tblMeaningfulUseDetail] AS mud
				WHERE    mud.[ItemDefinitionUid] = @ItemDefinitionUid
				GROUP BY mud.[ItemDefinitionUid] 
			END    
           
			IF @DenominatorSumValue <= 0
			BEGIN
				SET @CurValue = 'N/A' 
			END 
			ELSE IF @NumeratorSumValue <= 0
			BEGIN 
				SET @CurValue = '0.00%' 
			END 
			ELSE 
			BEGIN 
				-- Calculate current MU metric value
				SET @CurValue = CONVERT(VARCHAR(10), CONVERT(DECIMAL(8,2), (CONVERT(DECIMAL(8,2), @NumeratorSumValue) / CONVERT(DECIMAL(8,2), @DenominatorSumValue)) * 100)) + '%'
	                  
				-- Determine if goal is satisfied
				IF CONVERT(DECIMAL(8,2), (CONVERT(DECIMAL(8,2), @NumeratorSumValue) / CONVERT(DECIMAL(8,2), @DenominatorSumValue)) * 100) > @GoalValue
				BEGIN
					SET @MetGoal = 1
				END 
			END 
             
			-- Insert MU summary row
			INSERT INTO @tblMeaingfulUseSummaryCoreAndMenuSet ([ItemDefinitionUid]
				, [CategoryNumber]
				, [CategoryName]
				, [MeasureNumber]
				, [SubMeasureNumber]
				, [MeasureDesc]
				, [DenominatorDesc]
				, [DenominatorValue]
				, [NumeratorDesc]
				, [NumeratorValue]
				, [YesNo]
				, [CurrentValue]
				, [GoalDesc]
				, [GoalValue]
				, [MetGoal]
				, [ProviderUid]
				, [ProviderLnFn]
			)   
			VALUES (@ItemDefinitionUid
				, @CategoryNumber
				, @CategoryName
				, @MeasureNumber
				, @SubMeasureNumber
				, @MeasureDesc
				, @DenominatorDesc
				, @DenominatorSumValue
				, @NumeratorDesc
				, @NumeratorSumValue
				, @YesNo
				, @CurValue
				, @GoalDesc
				, CONVERT([varchar](10), @GoalValue)
				, @MetGoal
				, null
				, null
			)  
		END 
		ELSE 
		BEGIN
			-- Current MU metric is YES/NO.  
			INSERT INTO @tblMeaingfulUseSummaryCoreAndMenuSet([ItemDefinitionUid]
				, [CategoryNumber]
				, [CategoryName]
				, [MeasureNumber]
				, [SubMeasureNumber]
				, [MeasureDesc]
				, [DenominatorDesc]
				, [DenominatorValue]
				, [NumeratorDesc]
				, [NumeratorValue]
				, [YesNo]
				, [CurrentValue]
				, [GoalDesc]
				, [GoalValue]
				, [MetGoal]
				, [ProviderUid]
				, [ProviderLnFn]
			)  
			VALUES (@ItemDefinitionUid
				, @CategoryNumber
				, @CategoryName
				, @MeasureNumber
				, @SubMeasureNumber
				, @MeasureDesc
				, @DenominatorDesc
				, null
				, @NumeratorDesc
				, null
				, @YesNo
				, null
				, @GoalDesc
				, null
				, null
				, null
				, null
			)  
		END
		-- 
		-- Get next cursor_MU_Definitions row
		FETCH NEXT FROM cursor_MU_Definitions INTO @ItemDefinitionUid
			, @CategoryUid
			, @CategoryNumber
			, @CategoryName
			, @MeasureNumber
			, @SubMeasureNumber
			, @MeasureDesc
			, @ExclusionDesc
			, @DenominatorDesc
			, @NumeratorDesc
			, @YesNo
			, @GoalDesc
			, @GoalValue 
    END
    --
    -- Close and Deallocate cursor
    CLOSE cursor_MU_Definitions
    DEALLOCATE cursor_MU_Definitions
	
	-- Return Meaningful Use results to caller
	SELECT 'MeaingfulUseSummaryCoreAndMenuSet'
	SELECT [RowId]
		, [ItemDefinitionUid]
		, [CategoryNumber]
		, [CategoryName]
		, [MeasureNumber]
		, [SubMeasureNumber]
		, [MeasureDesc]
		, [DenominatorDesc]
		, [DenominatorValue]
		, [NumeratorDesc]
		, [NumeratorValue]
		, [YesNo]
		, [CurrentValue]
		, [GoalDesc]
		, [GoalValue]
		, [MetGoal]
		, [ProviderUid]
		, [ProviderLnFn]
	FROM @tblMeaingfulUseSummaryCoreAndMenuSet    
	ORDER BY [CategoryNumber] ASC
		, [MeasureNumber] ASC
		, [SubMeasureNumber] ASC 
	
	IF (@Debug <> 0)
	BEGIN
		SELECT 'GOOD BYE'
	END 
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[2024PI_Master_Report]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[2024PI_Master_Report] AS' 
END
GO
ALTER   PROC [dbo].[2024PI_Master_Report]
(
	@ReportInstanceUid		[uniqueidentifier],
	@ProviderUid			[varchar](max) = NULL, 
	@RptTimespan_StartDate	[date],
	@RptTimespan_EndDate	[date],
	@ProviderOption			[varchar](100) = 'Billing Provider', --	Billing Provider and Rendering Provider 
	@Debug					[int] = 0,
	@includetestpat			[bit] = 0,
	@ServiceSiteUID			[varchar](max) = null, 
	@FinancialCenterUID		[varchar](max) = null
)
AS
BEGIN
	SET NOCOUNT ON;
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;
	--
	--  

	IF (@RptTimespan_StartDate IS NULL)
	BEGIN
		SET @RptTimespan_StartDate = '01-01-1900'
	END 
	IF (@RptTimespan_EndDate IS NULL)
	BEGIN
		SET @RptTimespan_EndDate = GETDATE()
	END

	CREATE TABLE [#tblProviderList]
	(
		[ProviderUid] [uniqueidentifier] NOT NULL primary key clustered
	)
	 
	DECLARE @HasProviderUid [bit] = 0
	EXEC [2019PI_Master_PopulateProviderList] @ProviderUid, @HasProviderUid out

	DECLARE @ClaimFormatValueTypeProviderNPIUid [uniqueidentifier] = 'CE282F4E-A866-49BA-9636-C4BA0439E907',
		@ReportMode [bit] = 1,
		@ProviderBilling [bit] = 0,
		@ProviderRendering [bit] = 0,
		@ProviderNPI [varchar](100) = null

	-- Find the first provider has provider NPI

	SELECT TOP 1 @ProviderNPI = [Value]
	FROM [ClaimFormatValue] with(nolock)
	WHERE [ClaimFormatValueTypeUid] = @ClaimFormatValueTypeProviderNPIUid
		AND [ProviderUid] IN (SELECT [ProviderUid] FROM [#tblProviderList])

	-- Set local Billing and Rendering Provider Flags
	IF (@ProviderOption = 'Billing Provider')
	BEGIN
		SET @ProviderBilling = 1
		SET @ProviderRendering = 0
	END
	ELSE
	BEGIN
		SET @ProviderBilling = 0
		SET @ProviderRendering = 1	
	END

	IF NOT EXISTS (SELECT 1 FROM sysobjects WHERE Name='cus_PDMP_Pats' and XType='U')
		EXEC FillPDMPPatsTable

	-- Measure stored procedure flag indicating Meaningful Use data will be used for a report
CREATE TABLE [#tblVisitList]
	(
		[VisitUid]							[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[VisitDate]							[date]         NOT NULL,
		[PatientUid]						[uniqueidentifier] NOT NULL,
		[TestPat]					   		[bit],
		[IsEM]								[bit],
		[IsVP]								[bit],
		[ProviderUid]						[varchar](max),
		[RenderingProviderUid]				[varchar](max),
		[LastSavedByUid]					[uniqueidentifier],
		[SavedByBillingProvider]			[bit],
		[SavedByRenderingProvider]			[bit],
		[TransitionOfCare]					[bit],
		[MedicationChecked]					[bit],
		[DrugAllergyChecked]				[bit],
		[ProblemChecked]					[bit],
		[SummaryProvidedToPatient]			[date],
		[PatientDeclinedClinicalSummary]	[bit],
		[HasEduForm]						[bit],
		[HasPortalAccount]					[bit],
		[PrintedDate]						[date]
	)
	--
	-- PopulateVisitList
	EXEC [2019PI_Master_PopulateVisitList] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@Debug,
		@ServiceSiteUID,
		@FinancialCenterUID

	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblVisitList]
		ORDER BY [VisitDate] DESC 
	END

	CREATE TABLE [#tblPatientList] 
	(
		[PersonUid]					[uniqueidentifier] NOT NULL primary key clustered,
		[PatientLnFn]				[varchar](250),
		[Birthdate]					[date],
		[TestPat]					[bit],
		[IsEM]						[bit],
		[IsVP]						[bit],
		[FullDemographics]			[bit],
		[HasEduForm]				[bit],
		[EduFormPrinted]			[bit],
		[HasPortalAccount]			[bit],
		[PortalPerson]				[uniqueidentifier] NULL,
		[PortalValid]				[date] NULL,
		[PortalExpire]				[date] NULL,
		[SummaryProvidedToPatient]	[bit],
		[TransitionOfCare]			[bit],
		[MedicationChecked]			[bit],
		[SavedByBillingProvider]	[bit],
		[SavedByRenderingProvider]	[bit],
		[YearsOldOrOlder2]			[bit] NULL,
		[YearsOldOrOlder3]			[bit] NULL,
		[YearsOldOrYounger5]		[bit] NULL, 
		[YearsOldOrOlder13]			[bit] NULL,
		[YearsOldOrOlder65]			[bit] NULL
	)
	--
	-- Populate Patient List
	EXEC [2019PI_Master_PopulatePatientList] 
			@ProviderUid, 
			@RptTimespan_StartDate,
			@RptTimespan_EndDate,
			@ProviderBilling,
			@ProviderRendering,
			@Debug

	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblPatientList]
		ORDER BY [PatientLnFn]
	END

	--back fill #tblVisitList with patient specific information
	--delete test patient records from #tblVisitList AND #tblPatientList IF @includetestpat = 0
	EXEC [2019PI_Master_SynchronizeVisitAndPatient] @Debug = @Debug,
		@IncludeTestPatients = @includetestpat

	-- Build list of Medications that are within reporting range
	CREATE TABLE [#tblMedicationList]
	(
		[MedicationSIGUid]					[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[CreatedDate]						[datetime] NOT NULL,
		[RelVisitMedicationUid]				[uniqueidentifier],
		[PersonUid]							[uniqueidentifier],
		[TestPat]							[bit],
		[LicensedHealthcareProfessional]	[bit] NOT NULL,
		[Dispensable]						[bit] NULL,
		[IsSampleGiven]						[bit] NOT NULL,
		[IsAdministered]					[bit] NOT NULL,
		[reffederaldeaclasscode]			[int] NULL,
		[SIGDetailCount]					[int] NULL,
		[eRxStatusUid]						[uniqueidentifier]
	)
	--
	-- PopulateMedicationList
	EXEC [2019PI_Master_PopulateMedicationList] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@includetestpat,
		@Debug
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblMedicationList]
		ORDER BY [CreatedDate] DESC 
	END

	-- Build list of Orders that are within reporting range
	CREATE TABLE [#tblOrderList]
	(
		[ObservationOrderUid]				[uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED,
		[PatientUid]						[uniqueidentifier] NOT NULL,
		[TestPat]					 		[bit],
		[VPUid]								[uniqueidentifier] NULL,
		[CreatedBy]							[uniqueidentifier] NULL,
		[OrderDate]							[datetime] NOT NULL,
		[ProcedureCodeTypeUid]				[uniqueidentifier] NULL,
		[ProcedureCodeTypeName]				[varchar](500) NULL,
		[AttachmentTypeUid]					[uniqueidentifier] NULL,
		[AttachmentTypeName]				[varchar](500) NULL,
		[LicensedHealthcareProfessional]	[bit] NOT NULL,
		[ImageResultsDirectlyAccessible]	[bit] NULL,
		[ResultStatusID]					[int] NULL
	)
	--
	-- PopulateOrderList
	EXEC [2019PI_Master_PopulateOrderList] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@includetestpat,
		@Debug
	--
	IF (@Debug <> 0) 
	BEGIN
		SELECT *
		FROM [#tblOrderList]
		ORDER BY [OrderDate] DESC 
	END

	-- Create work table that will hold the Meaningful Use results
	CREATE TABLE [#tblMeaningfulUseDetail] 
	(
		[RowId]				[int] IDENTITY(1,1) PRIMARY KEY, -- Primary Key
		[ItemDefinitionUid]	[uniqueidentifier], -- MeaningfulUseItemDefinition.ItemDefinitionUid
		[CategoryName]		[varchar](500) NULL, -- MeaningfulUseCategoryDefinition.CategoryName
		[CategoryNumber]	[int] NULL, -- MeaningfulUseCategoryDefinition.CategoryNumber
		[MeasureNumber]		[int] NULL, -- MeaningfulUseItemDefinition.MeasureNumber 
		[SubMeasureNumber]	[int] NULL, -- MeaningfulUseItemDefinition.SubMeasureNumber
		[PersonUid]			[uniqueidentifier] NULL, -- Unique list of Visit.PatientUid
		[PersonLnFn]		[varchar](150) NULL, -- Patient name
		[ProviderUid]		[varchar](MAX) NULL,
		[ProviderLnFn]		[varchar](150) NULL, 
		[NumeratorValue]	[int] NULL, -- See MeaningfulUseItemDefinition.NumeratorDesc
		[DenominatorValue]	[int] NULL, -- See MeaningfulUseItemDefinition.DenominatorDesc
		[YesNo]				[int] NULL -- See MeaningfulUseItemdefinition.YesNo. Null-NA, 0-No/False, 1-Yes/True.
		unique clustered (RowId)
	) 
 
	CREATE NONCLUSTERED INDEX [MUDetail_ItemDef_PersonUid] ON #tblMeaningfulUseDetail
	(
		ItemDefinitionUid ASC,
		PersonUid ASC
	)
	WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]


	-- Params used in determining if any detail rows were found for given metric
	CREATE TABLE [#tblMetricUidsWithoutDetailRows] 
	(
		[ItemDefinitionUid] [uniqueidentifier] NOT NULL PRIMARY KEY CLUSTERED
	)

	-- Create temp table that can be used by measure procs
	CREATE TABLE [#MetricDataTemp]
	(
		[PersonUid] [uniqueidentifier] NOT NULL,
		[HeightRecorded] [int] NULL,
		[WeightRecorded] [int] NULL,
		[BloodPressureRecorded] [int] NULL,
		[LabResultTotalCount] [int] NULL, 
		[LabResultTemplatedCount] [int] NULL,
		[TaskDocGenCount] [int] NULL, 
		[TaskDocGenCompleteCount] [int] NULL, 
		[VisitCount] [int] NULL, 
		[ClinicalSummaryProvidedCount] [int] NULL, 
		[PreventativeFollowupDueCount] [int] NULL, 
		[PreventativeFollowupSentCount] [int] NULL, 
		[SeenByAnotherProviderCount] [int] NULL, 
		[MedicalCheckedCount] [int] NULL, 
		[ReferralCount] [int] NULL, 
		[ReferralClinicalSummaryProvided] [int] NULL
	) 	

	-- Proc based on MUII_Master_DesktopControl
	--  
	-- Calculate Measures
	-- ACI_TRANS_PPHI_1 == Objective 1 == MUII Core Measure 9
	-- Must attest yes

	-- ACI_TRANS_EP_1 == Objective 4 == MUII Core Measure 2, Sub Measure NULL; ItemDefinitionUid : F3A49E2B-E4FF-4D78-A3D5-EEA12A5FBF58
	EXEC [2024PI_E-Prescribing_1_NonControlled] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2024PI_E-Prescribing_2_Controlled] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2024PI_E-Prescribing_3_PDMP] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2024PI_HealthInformationExchange_1_Sending] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	EXEC [2024PI_HealthInformationExchange_2_Receiving] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE
		
	EXEC [2024PI_ProviderToPatientExchange] @ProviderUid,
		@ProviderBilling,
		@RptTimespan_StartDate,
		@RptTimespan_EndDate,
		@ReportMode,
		@Debug  -- DONE

	-- Drop temp tables that are used by measure procs
	BEGIN TRY
		DROP TABLE [#tblVisitList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#tblPatientList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#tblProviderList]
	END TRY 
	BEGIN CATCH
	END CATCH

	BEGIN TRY
		DROP TABLE [#MetricDataTemp]
	END TRY 
	BEGIN CATCH
	END CATCH

	-- For measures that do not have any detail rows, we need to insert a row, so it will be included in the RDL report.
	DECLARE @NumDetailRows [int]
	SET @NumDetailRows = (SELECT COUNT(*) FROM [#tblMetricUidsWithoutDetailRows])
	IF (@NumDetailRows > 0)
	BEGIN
		INSERT INTO [#tblMeaningfulUseDetail] ([ItemDefinitionUid],
			[CategoryNumber],
			[CategoryName],
			[MeasureNumber],
			[SubMeasureNumber],
			[PersonUid],
			[PersonLnFn],
			[ProviderUid],
			[ProviderLnFn],
			[NumeratorValue],
			[DenominatorValue],
			[YesNo]
		)
			SELECT NoData.[ItemDefinitionUid] AS [ItemDefinitionUid]
			,(
				select mucd.[CategoryNumber] 
				from [MeaningfulUseItemDefinition] AS muid with(nolock)
					inner join [MeaningfulUseCategoryDefinition] AS mucd with(nolock) on muid.[CategoryUid] = mucd.[CategoryUid]
				where muid.[ItemDefinitionUid] = NoData.[ItemDefinitionUid]
			) AS [CategoryNumber]

			,(
				select mucd.CategoryName
				from [MeaningfulUseItemDefinition] AS muid with(nolock)
					inner join [MeaningfulUseCategoryDefinition] AS mucd with(nolock) on muid.[CategoryUid] = mucd.[CategoryUid]
				where muid.[ItemDefinitionUid] = NoData.[ItemDefinitionUid]
			) AS [CategoryName]

			,(
				select muid.[MeasureNumber]
				from [MeaningfulUseItemDefinition] AS muid with(nolock)
					inner join [MeaningfulUseCategoryDefinition] AS mucd with(nolock) on muid.[CategoryUid] = mucd.[CategoryUid]
				where muid.[ItemDefinitionUid] = NoData.[ItemDefinitionUid]
			) AS [MeasureNumber] 

			,(
				select muid.[SubMeasureNumber] 
				from [MeaningfulUseItemDefinition] AS muid with(nolock)
					inner join [MeaningfulUseCategoryDefinition] AS mucd with(nolock) on muid.[CategoryUid] = mucd.[CategoryUid]
				where muid.[ItemDefinitionUid] = NoData.[ItemDefinitionUid]
			) AS [SubMeasureNumber] 

			,NULL AS [PersonUid] 
			,'N / A' AS [PersonLnFn]
			,NULL AS [ProviderUid] 
			,'' AS [ProviderLnFn]
			,0 AS [NumeratorValue]
			,0 AS [DenominatorValue]
			,0 AS [YesNo]
		FROM [#tblMetricUidsWithoutDetailRows] AS [NoData] 
	END

	--
	-- For measures that are Yes/No (Must attest Yes), insert a detail row that will be included in the RDL report
	--

	---- ACI_TRANS_PPHI_1 == Objective 1 == MUII Core Measure 9
	DECLARE @ItemDefinitionUid [uniqueidentifier] --= '1D8DEE46-CB1A-45DD-B0FF-FE04DDBD1310' 
	--EXEC [MUI_Master_Report_InsertAttestMeasureDetail] @ItemDefinitionUid, @ReportMode,	@Debug

	---- Pick 2 registries
	--SET @ItemDefinitionUid = 'CC4FF4BA-CA32-41F7-A157-5426E59C81AE' 
	--EXEC [MUI_Master_Report_InsertAttestMeasureDetail] @ItemDefinitionUid, @ReportMode, @Debug

	-- Define table that will be returned to caller
	DECLARE @tblMeaingfulUseSummaryCoreAndMenuSet TABLE
	(
		[RowId]             [int] IDENTITY(1,1) PRIMARY KEY,
		[ItemDefinitionUid] [uniqueidentifier],
		[CategoryNumber]    [int] NULL,
		[CategoryName]      [varchar](100) NULL,
		[MeasureNumber]     [int] NULL, 
		[SubMeasureNumber]  [int] NULL,
		[MeasureDesc]       [varchar](500) NULL,
		[DenominatorDesc]   [varchar](250) NULL,
		[DenominatorValue]  [int] NULL,
		[NumeratorDesc]     [varchar](250) NULL,
		[NumeratorValue]    [int] NULL,
		[YesNo]     [varchar](50)  NULL,
		[CurrentValue]	  [varchar](25)  NULL,
		[GoalDesc]          [varchar](250) NULL,
		[GoalValue]         [varchar](10)  NULL,
		[MetGoal]           [bit] NULL, 
		[ProviderUid]       [varchar](max) NULL,
		[ProviderLnFn]      [varchar](150) NULL,       
		unique clustered  ([RowId])
	) 

	-- Determine if there are any MU detail rows to base metrics against
	-- Walk through list of defined Meaningful Use metrics and popluate @tblMeaingfulUseSummaryCoreAndMenuSet 
	DECLARE @CategoryUid [uniqueidentifier]
		, @CategoryNumber [int]
		, @CategoryName [varchar](100)
		, @MeasureNumber [int]
		, @SubMeasureNumber [int]
		, @MeasureDesc [varchar](500)
		, @ExclusionDesc [varchar](250)
		, @DenominatorDesc [varchar](250)
		, @NumeratorDesc [varchar](250)
		, @YesNo [varchar](50)
		, @GoalDesc [varchar](250)
		, @GoalValue [decimal](5, 2)
		, @DenominatorSumValue [int]
		, @NumeratorSumValue [int]
		, @CurValue [varchar](25)
		, @MetGoal [bit]    
        
    --
    -- Populate table that will be returned to caller
	DECLARE cursor_MU_Definitions CURSOR FAST_FORWARD FOR 
		SELECT muid.[ItemDefinitionUid]
			, muid.[CategoryUid]
			, mucd.[CategoryNumber]
			, mucd.[CategoryName]
			, muid.[MeasureNumber]
			, muid.[SubMeasureNumber]
			, muid.[MeasureDesc]
			, muid.[ExclusionDesc]
			, muid.[DenominatorDesc]
			, muid.[NumeratorDesc]
			, muid.[YesNo]
			, muid.[GoalDesc]
			, muid.[GoalValue]
		FROM [MeaningfulUseItemDefinition] AS muid with(nolock)
			INNER JOIN [MeaningfulUseCategoryDefinition] AS mucd with(nolock) ON muid.[CategoryUid] = mucd.[CategoryUid]
/*Replace w/new StageUid*/		WHERE muid.[StageUid] = 'FE7C779A-DE0F-4A85-8629-D5FDFB740354'   -- 2024 PI
		ORDER BY mucd.[CategoryName]
			, mucd.[CategoryNumber]
			, muid.[MeasureNumber]
    --
    OPEN cursor_MU_Definitions
    --
	FETCH NEXT FROM cursor_MU_Definitions 
		INTO @ItemDefinitionUid
			, @CategoryUid
			, @CategoryNumber
			, @CategoryName
			, @MeasureNumber
			, @SubMeasureNumber
			, @MeasureDesc
			, @ExclusionDesc
			, @DenominatorDesc
			, @NumeratorDesc
			, @YesNo
			, @GoalDesc
			, @GoalValue 
    --
   -- Make sure we have a valid cursor row
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @DenominatorSumValue = 0
		SET @NumeratorSumValue = 0
		SET @CurValue = '' 
		SET @MetGoal = 0 
		SET @NumDetailRows = 0
		
		-- Check if current MU metric has a numerator and denominator
		IF @YesNo IS NULL
		BEGIN
			-- Make sure we have some data for current metric
			SET @NumDetailRows = (SELECT COUNT(*)
								  FROM [#tblMeaningfulUseDetail]
								  WHERE [ItemDefinitionUid] = @ItemDefinitionUid
								 )
			IF (@NumDetailRows > 0)
			BEGIN
				-- Current MU metric has a numerator and demoninator
				SELECT  @DenominatorSumValue = SUM(mud.[DenominatorValue])
					, @NumeratorSumValue   = SUM(mud.[NumeratorValue]) 
				FROM     [#tblMeaningfulUseDetail] AS mud
				WHERE    mud.[ItemDefinitionUid] = @ItemDefinitionUid
				GROUP BY mud.[ItemDefinitionUid] 
			END    
           
			IF @DenominatorSumValue <= 0
			BEGIN
				SET @CurValue = 'N/A' 
			END 
			ELSE IF @NumeratorSumValue <= 0
			BEGIN 
				SET @CurValue = '0.00%' 
			END 
			ELSE 
			BEGIN 
				-- Calculate current MU metric value
				SET @CurValue = CONVERT(VARCHAR(10), CONVERT(DECIMAL(8,2), (CONVERT(DECIMAL(8,2), @NumeratorSumValue) / CONVERT(DECIMAL(8,2), @DenominatorSumValue)) * 100)) + '%'
	                  
				-- Determine if goal is satisfied
				IF CONVERT(DECIMAL(8,2), (CONVERT(DECIMAL(8,2), @NumeratorSumValue) / CONVERT(DECIMAL(8,2), @DenominatorSumValue)) * 100) > @GoalValue
				BEGIN
					SET @MetGoal = 1
				END 
			END 
             
			-- Insert MU summary row
			INSERT INTO @tblMeaingfulUseSummaryCoreAndMenuSet ([ItemDefinitionUid]
				, [CategoryNumber]
				, [CategoryName]
				, [MeasureNumber]
				, [SubMeasureNumber]
				, [MeasureDesc]
				, [DenominatorDesc]
				, [DenominatorValue]
				, [NumeratorDesc]
				, [NumeratorValue]
				, [YesNo]
				, [CurrentValue]
				, [GoalDesc]
				, [GoalValue]
				, [MetGoal]
				, [ProviderUid]
				, [ProviderLnFn]
			)   
			VALUES (@ItemDefinitionUid
				, @CategoryNumber
				, @CategoryName
				, @MeasureNumber
				, @SubMeasureNumber
				, @MeasureDesc
				, @DenominatorDesc
				, @DenominatorSumValue
				, @NumeratorDesc
				, @NumeratorSumValue
				, @YesNo
				, @CurValue
				, @GoalDesc
				, CONVERT([varchar](10), @GoalValue)
				, @MetGoal
				, null
				, null
			)  
		END 
		ELSE 
		BEGIN
			-- Current MU metric is YES/NO.  
			INSERT INTO @tblMeaingfulUseSummaryCoreAndMenuSet([ItemDefinitionUid]
				, [CategoryNumber]
				, [CategoryName]
				, [MeasureNumber]
				, [SubMeasureNumber]
				, [MeasureDesc]
				, [DenominatorDesc]
				, [DenominatorValue]
				, [NumeratorDesc]
				, [NumeratorValue]
				, [YesNo]
				, [CurrentValue]
				, [GoalDesc]
				, [GoalValue]
				, [MetGoal]
				, [ProviderUid]
				, [ProviderLnFn]
			)  
			VALUES (@ItemDefinitionUid
				, @CategoryNumber
				, @CategoryName
				, @MeasureNumber
				, @SubMeasureNumber
				, @MeasureDesc
				, @DenominatorDesc
				, null
				, @NumeratorDesc
				, null
				, @YesNo
				, null
				, @GoalDesc
				, null
				, null
				, null
				, null
			)  
		END
		-- 
		-- Get next cursor_MU_Definitions row
		FETCH NEXT FROM cursor_MU_Definitions INTO @ItemDefinitionUid
			, @CategoryUid
			, @CategoryNumber
			, @CategoryName
			, @MeasureNumber
			, @SubMeasureNumber
			, @MeasureDesc
			, @ExclusionDesc
			, @DenominatorDesc
			, @NumeratorDesc
			, @YesNo
			, @GoalDesc
			, @GoalValue 
    END
    --
    -- Close and Deallocate cursor
    CLOSE cursor_MU_Definitions
    DEALLOCATE cursor_MU_Definitions

	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CUS_MeaningfulUseDetail]') AND type in (N'U'))
	BEGIN
	CREATE TABLE [dbo].[CUS_MeaningfulUseDetail](
		[MeaningfulUseDetailUid] [uniqueidentifier] NOT NULL,
		[ReportInstanceUid] [uniqueidentifier] NOT NULL,
		[ItemDefinitionUid] [uniqueidentifier] NULL,
		[CategoryName] [varchar](500) NULL,
		[CategoryNumber] [int] NULL,
		[MeasureNumber] [int] NULL,
		[SubMeasureNumber] [int] NULL,
		[PersonUid] [uniqueidentifier] NULL,
		[PersonLnFn] [varchar](150) NULL,
		[ProviderUid] [varchar](max) NULL,
		[ProviderLnFn] [varchar](150) NULL,
		[ProviderNPI] [varchar](250) NULL,
		[NumeratorValue] [int] NULL,
		[DenominatorValue] [int] NULL,
		[YesNo] [int] NULL,
		[ObjectiveDesc] [varchar](500) NULL,
		[MeasureDesc] [varchar](600) NOT NULL,
		[MeasureDetailDesc] [varchar](600) NULL,
		[ExclusionDesc] [varchar](600) NULL,
		[DenominatorDesc] [varchar](500) NULL,
		[NumeratorDesc] [varchar](500) NULL,
		[GoalDesc] [varchar](250) NULL,
		[LastModifiedDate] [datetime] NOT NULL,
	 CONSTRAINT [PK_CUS_MeaningfulUseDetail] PRIMARY KEY CLUSTERED 
	(
		[MeaningfulUseDetailUid] ASC
	)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
	) ON [PRIMARY] TEXTIMAGE_ON [PRIMARY]
	END

	IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CUS_MeaningfulUseDetail]') AND name = N'IX_CUS_MeaningfulUseDetail')
		CREATE NONCLUSTERED INDEX [IX_CUS_MeaningfulUseDetail] ON [dbo].[CUS_MeaningfulUseDetail]
		(
			[ReportInstanceUid] ASC,
			[ItemDefinitionUid] ASC,
			[PersonUid] ASC
		)
		INCLUDE ( 	[CategoryName],
			[CategoryNumber],
			[MeasureNumber],
			[NumeratorValue],
			[DenominatorValue],
			[ExclusionDesc],
			[DenominatorDesc],
			[SubMeasureNumber],
			[PersonLnFn],
			[ProviderUid],
			[ProviderLnFn],
			[NumeratorDesc],
			[GoalDesc],
			[YesNo],
			[ObjectiveDesc],
			[MeasureDesc],
			[MeasureDetailDesc],
			[MeaningfulUseDetailUid],
			[ProviderNPI],
			[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]

	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF_CUS_MeaningfulUseDetail_MeaningfulUseDetailUid]') AND type = 'D')
	BEGIN
		ALTER TABLE [dbo].[CUS_MeaningfulUseDetail] ADD  CONSTRAINT [DF_CUS_MeaningfulUseDetail_MeaningfulUseDetailUid]  DEFAULT (newid()) FOR [MeaningfulUseDetailUid]
	END

	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DF_CUS_MeaningfulUseDetail_LastModifiedDate]') AND type = 'D')
	BEGIN
		ALTER TABLE [dbo].[CUS_MeaningfulUseDetail] ADD  CONSTRAINT [DF_CUS_MeaningfulUseDetail_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
	END

	EXEC MIPS_2018_Master_Report_DeleteReportInstance @ReportInstanceUid
	--
	-- Return detail table to caller
	--
	INSERT [CUS_MeaningfulUseDetail](
		[ReportInstanceUid],
		[ItemDefinitionUid],
		[CategoryName],
		[CategoryNumber],
		[MeasureNumber],
		[SubMeasureNumber],
		[PersonUid],
		[PersonLnFn],
		[ProviderUid],
		[ProviderLnFn],
		[ProviderNPI],
		[NumeratorValue],
		[DenominatorValue],
		[YesNo],
		[ObjectiveDesc],
		[MeasureDesc],
		[MeasureDetailDesc],
		[ExclusionDesc],
		[DenominatorDesc],
		[NumeratorDesc],
		[GoalDesc]
	)
	SELECT @ReportInstanceUid AS [ReportInstanceUid],
		t.[ItemDefinitionUid],
		COALESCE(t.[CategoryName], mucd.[CategoryName]) AS [CategoryName],
		t.[CategoryNumber],
		t.[MeasureNumber],
		t.[SubMeasureNumber],
		t.[PersonUid],
		t.[PersonLnFn],
		[ProviderUid],
		t.[ProviderLnFn],
		@ProviderNPI AS [ProviderNPI],
		t.[NumeratorValue],
		t.[DenominatorValue],
		t.[YesNo],
		MUID.[ObjectiveDesc],
		MUID.[MeasureDesc],
		MUID.[MeasureDetailDesc],
		MUID.[ExclusionDesc],
		MUID.[DenominatorDesc],
		MUID.[NumeratorDesc],
		MUID.[GoalDesc]
	FROM [#tblMeaningfulUseDetail] AS t
		INNER JOIN [MeaningfulUseItemDefinition] AS MUID with(nolock) ON MUID.[ItemDefinitionUid] = t.[ItemDefinitionUid]
		INNER JOIN [MeaningfulUseCategoryDefinition] AS mucd with (nolock) ON MUID.[CategoryUid] = mucd.[CategoryUid]
	ORDER BY [CategoryName] ASC,
		[CategoryNumber] ASC,
		[MeasureNumber] ASC,
		[SubMeasureNumber] ASC,
		[NumeratorValue] DESC,
		[DenominatorValue] DESC,
		[PersonLnFn] ASC 
	
	BEGIN TRY
		DROP TABLE [#tblMeaningfulUseDetail]
	END TRY
	BEGIN CATCH
	END CATCH
	
	-- Return Meaningful Use results to caller
	SELECT [RowId]
		, [ItemDefinitionUid]
		, [CategoryNumber]
		, [CategoryName]
		, [MeasureNumber]
		, [SubMeasureNumber]
		, [MeasureDesc]
		, [DenominatorDesc]
		, [DenominatorValue]
		, [NumeratorDesc]
		, [NumeratorValue]
		, [YesNo]
		, [CurrentValue]
		, [GoalDesc]
		, [GoalValue]
		, [MetGoal]
		, [ProviderUid]
		, [ProviderLnFn]
	FROM @tblMeaingfulUseSummaryCoreAndMenuSet    
	ORDER BY [CategoryNumber] ASC
		, [MeasureNumber] ASC
		, [SubMeasureNumber] ASC 
	
	IF (@Debug <> 0)
	BEGIN
		SELECT 'GOOD BYE'
	END 
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetUniqueID]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[GetUniqueID] AS' 
END
GO
ALTER PROC [dbo].[GetUniqueID] --by LGodolphin 08/16/05
@TableName 	varchar(255) = '',
@Constraint	varchar(255) = 'ExternalID'

AS
BEGIN

DECLARE 
@Seed		int,
@SeedString	varchar(80),
@Count		int,
@ParmDefinition nvarchar(255), 
@SQLString 	nvarchar(255)

--IF ((@TableName <> '') AND (EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N'[dbo].[' + @TableName + ']') and OBJECTPROPERTY(id, N'IsUserTable') = 1)))
--BEGIN

  --print 'GetUniqueID - Begin'
  WHILE (@TableName<>'') 
  BEGIN
  
    EXEC @Seed = GetSeed @TableName
    SET @SeedString = CONVERT(varchar(80), @Seed)
    --print 'Seed: ' + @SeedString
    SET @ParmDefinition = N'@SeedValue varchar(80), @CountValue int OUT'
    SET @SQLString = N'SET @CountValue = (SELECT Count(*) FROM ' + @TableName + ' WHERE ' + @Constraint + ' = @SeedValue)'

    EXECUTE sp_executesql @SQLString, @ParmDefinition, @SeedValue = @SeedString,
                      @CountValue = @Count OUTPUT

      IF @Count = 0
        BEGIN
	  --print 'getUniqueID - Seed: ' + convert(varchar(20), @Seed)
	  SELECT @Seed as UniqueID
	  RETURN @Seed
	  BREAK
        END
  END --While

--END --IF @TableName<>''

END --Procedure


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AccountResponsibleParty_FixRPID]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AccountResponsibleParty_FixRPID] AS' 
END
GO
-- =============================================
-- Author:		aprima ( David Wallace )
-- Create date: 05/13/2011
-- Modified: 05/17/2011 ( Kellye Bernecker ) - added check for '(Auto ID)' 
--                      and empty string in externalID and added @count parameter.
--						write data to temp table
-- Description:	Display or fix AccountResponsibleParties with null external IDs
-- =============================================
ALTER PROCEDURE [dbo].[AccountResponsibleParty_FixRPID]
AS
BEGIN

	SET NOCOUNT ON;
	
	DECLARE @id varchar(25)
	DECLARE @arpUid uniqueidentifier
	SET @arpUid = NULL 
    
	SELECT TOP 1 @arpUid = arp.AccountResponsiblePartyUid 
	FROM AccountResponsibleParty arp  
	WHERE arp.ExternalID IS NULL or arp.ExternalID = '' or arp.ExternalID = '(Auto ID)'
	
	declare @auditdesc varchar(500)
	declare @workstation varchar(250)
	declare @userName varchar(500)
	declare @modifier varchar(500)
	declare @userGroup varchar(500)
	
	WHILE (@arpUid IS NOT NULL)
	BEGIN
	  -- get unique id from seed table	
	  EXEC @id = GetUniqueID 'AccountResponsibleParty'
	  
	  -- Update accountResponsiblePartyRow
	  UPDATE AccountResponsibleParty
		SET ExternalID = @id
		WHERE AccountResponsiblePartyUid = @arpUid
		
	  set @auditdesc = 'SQL job detected and corrected an invalid ExternalID for AccountResponsibleParty ''' + convert(varchar(50),@arpUid) + '''.  The new ExternalID value is: ''' + @id + '''.'
	  set @workstation = convert(varchar(500),(select SERVERPROPERTY('MachineName')))
	
	  insert into audit (Type, Workstation, description)
	  values('Aprima-SQL', @workstation, @auditdesc)
	
	  -- Get next in line to be updated
	  SET @arpUid = NULL 
	  SELECT TOP 1 @arpUid = arp.AccountResponsiblePartyUid 
	  FROM AccountResponsibleParty arp 
	  WHERE arp.ExternalID IS NULL or arp.ExternalID = '' or arp.ExternalID = '(Auto ID)'
	END		
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AccountResponsiblePartyAccountReport]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AccountResponsiblePartyAccountReport] AS' 
END
GO
ALTER PROC [dbo].[AccountResponsiblePartyAccountReport] @AccountResponsiblePartyUid varchar(1000) AS
/*
	01/28/2008 - Qatalys - #13128 - Modified Balance with BalanceAll
	12/20/2013 - Pancratius		Removed dbo.UDF_utcToCurrent function from all date columns
*/
BEGIN
SELECT
	ARPAR.AccountResponsiblePartyUid,
	ARPAR.ARPName,
	ARPAR.Address1,
	ARPAR.Address2,
	ARPAR.City,
	ARPAR.State,
	ARPAR.Zip,
	ARPAR.PhoneNumber,
	ARPAR.CollectionStatus,
	ARPAR.CollectionStatusLevel,
	ARPAR.CollectionsBalance,
	PaymentDueDate,
	ARPAR.PaymentAmount,
    LGT.lastPaymentAmount AS LastPaymentAmount,
    LGT.lastPaymentDate AS LastPaymentDate,
	ARPAR.AccountUid,
	ARPAR.AccountName,
	ARPAR.PatientUid,
	ARPAR.PatientLastName,
	ARPAR.PatientFirstName,
	ARPAR.PatientBirthDate,
	ARPAR.PatientLiability,
	ARPAR.TotalBalance
FROM
	[MDOL_RPT2_VIEW_AccountResponsiblePartyAccountReport] ARPAR
LEFT JOIN
	MDOL_RPT2_VIEW_LedgerGetTransactions LGT
ON
	ARPAR.AccountUid = LGT.AccountUid	
WHERE
		ARPAR.AccountResponsiblePartyUid = @AccountResponsiblePartyUid
ORDER BY LGT.LastPaymentdate desc		
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AddLOINCToProcedures]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AddLOINCToProcedures] AS' 
END
GO
ALTER PROCEDURE [dbo].[AddLOINCToProcedures]
AS
BEGIN
	IF EXISTS(select PRMCode
		   from MASTER_MU2_InterfaceDataMapping m WITH(NOLOCK)
		   inner join MasterProcedureToLoinc map WITH(NOLOCK) on m.PRMCode=map.LOINC_CODE
		   inner join ListProcedure p WITH(NOLOCK) on map.PROCIT_VOCAB_IMO_CODE=p.Code and p.MasterProcedureUid is not null and p.UserDefined IN(0,1,2)
		   inner join ListLOINC ll WITH(NOLOCK) on map.LOINC_CODE=ll.Name
		   where m.Rootid='2.16.840.1.113883.6.1'
		   AND p.LOINCUid IS NULL)
       BEGIN
	   update p set p.LOINCUid=ll.LOINCUid
       --select PRMCode
       from MASTER_MU2_InterfaceDataMapping m WITH(NOLOCK)
       inner join MasterProcedureToLoinc map WITH(NOLOCK) on m.PRMCode=map.LOINC_CODE
       inner join ListProcedure p WITH(NOLOCK) on map.PROCIT_VOCAB_IMO_CODE=p.Code and p.MasterProcedureUid is not null and p.UserDefined IN(0,1,2)
       inner join ListLOINC ll WITH(NOLOCK) on map.LOINC_CODE=ll.Name
       where m.Rootid='2.16.840.1.113883.6.1'
	   AND p.LOINCUid IS NULL
	   END
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AddRelCCSymptomMFU]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AddRelCCSymptomMFU] AS' 
END
GO
ALTER PROC [dbo].[AddRelCCSymptomMFU] (@providerUid uniqueidentifier, @ccSystemUid uniqueidentifier, @ccSymptomUid uniqueidentifier) AS
BEGIN
	DECLARE @relCCSystemSymptomUid uniqueidentifier
	SELECT	@relCCSystemSymptomUid = dbo.UDFGetRelCCSystemSymptom(@ccSystemUid, @ccSymptomUid)
	
	IF @relCCSystemSymptomUid IS NULL
		RETURN

	UPDATE	RelFindTableMFU
	SET		[Count] = [Count] + 1
	WHERE	FindTableUid = '9C4CA244-69D6-4FAF-A16F-60A7645B577C' AND
			UserUid = @providerUid AND
			[Uid] = @relCCSystemSymptomUid

    IF NOT EXISTS(SELECT * FROM UserPRM WHERE PersonUid = @providerUid)
       RETURN

	IF @@ROWCOUNT = 0 /* no row updated, so add new row */
		INSERT	RelFindTableMFU(FindTableUid, UserUid, [Uid], [Count])
		VALUES	('9C4CA244-69D6-4FAF-A16F-60A7645B577C', @providerUid, @relCCSystemSymptomUid, 1)
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AlterXmlSchema]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AlterXmlSchema] AS' 
END
GO
ALTER PROC [dbo].[AlterXmlSchema] @xmlSchemaName VARCHAR(255), @xmlSchema NVARCHAR(MAX) AS

DECLARE @table TABLE(	TableName VARCHAR(255),
						ColumnName VARCHAR(255)
					)
					
DECLARE @index TABLE(	TableName VARCHAR(255),
						ColumnName VARCHAR(255),
						IndexName VARCHAR(255)
					)
declare @SQL varchar(2000)

PRINT 'Getting list of tables with XML bound Schema'
			
INSERT	@table
SELECT	t.name AS [Table], c.name AS [Column]
FROM	sys.xml_schema_collections xsc INNER JOIN sys.columns c ON xsc.xml_collection_id = c.xml_collection_id
		INNER JOIN sys.objects t ON c.object_id = t.object_id AND t.Type = 'U'
WHERE	xsc.name = @xmlSchemaName

DECLARE @tableName VARCHAR(255)
DECLARE @columnName VARCHAR(255)

PRINT 'Removing Schema from the Columns'
DECLARE cur CURSOR FOR SELECT * FROM @table
OPEN cur

FETCH NEXT FROM cur INTO @tableName, @columnName
WHILE @@FETCH_STATUS = 0
BEGIN	
	PRINT 'Running DBCC CleanTable on ' + @tableName
	SELECT @SQL = N'DBCC CLEANTABLE (0, "' + QUOTENAME(@tableName) + '") WITH NO_INFOMSGS;'
	EXEC (@SQL)
	-- exec('DBCC CLEANTABLE (0, "' + @tableName + '") WITH NO_INFOMSGS;')

	PRINT 'Altering Column Removing Schema ' + @tableName + '.' + @columnName
	exec('ALTER TABLE [' + @tableName + '] ALTER COLUMN ' + @columnName + ' XML')

	PRINT 'Running DBCC CleanTable on ' + @tableName
	SELECT @SQL = N'DBCC CLEANTABLE (0, "' + QUOTENAME(@tableName) + '") WITH NO_INFOMSGS;'
	EXEC (@SQL)
	-- exec('DBCC CLEANTABLE (0, "' + @tableName + '") WITH NO_INFOMSGS;')

	FETCH NEXT FROM cur INTO @tableName, @columnName
END
CLOSE cur

PRINT 'Rebuilding Views to remove XML Schema'
DECLARE @views TABLE( value VARCHAR(MAX))
DECLARE @viewName VARCHAR(255)
DECLARE @views_text VARCHAR(MAX)
DECLARE vws CURSOR FOR SELECT t.name AS [View]
	FROM	sys.xml_schema_collections xsc INNER JOIN sys.columns c ON xsc.xml_collection_id = c.xml_collection_id
			INNER JOIN sys.objects t ON c.object_id = t.object_id AND t.Type = 'V'
	WHERE	xsc.name = @xmlSchemaName

OPEN vws
FETCH NEXT FROM vws INTO @viewName
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @views_text = ''
	DELETE FROM @views
	
	INSERT INTO @views exec sp_helptext @viewName
	
	SELECT @views_text = @views_text + value FROM @views

	exec('DROP VIEW ' + @viewName)
	
	exec(@views_text)	

	FETCH NEXT FROM vws INTO @viewName
END
CLOSE vws

IF EXISTS(SELECT * FROM sys.xml_schema_collections WHERE name = @xmlSchemaName)
BEGIN
	PRINT 'Dropping Xml Schema'
	exec('DROP XML SCHEMA COLLECTION ' + @xmlSchemaName)
END

PRINT 'Creating Xml Schema'
select 'CREATE XML SCHEMA COLLECTION ' + @xmlSchemaName + ' AS N''' + @xmlSchema + ''''
exec('CREATE XML SCHEMA COLLECTION ' + @xmlSchemaName + ' AS N''' + @xmlSchema + '''')

PRINT 'Adding Schema to the Columns'
OPEN cur
FETCH NEXT FROM cur INTO @tableName, @columnName
WHILE @@FETCH_STATUS = 0
BEGIN	
	PRINT 'Running DBCC CleanTable on ' + @tableName
	SELECT @SQL = N'DBCC CLEANTABLE (0, "' + QUOTENAME(@tableName) + '") WITH NO_INFOMSGS;'
	EXEC (@SQL)
	-- exec('DBCC CLEANTABLE (0, "' + @tableName + '") WITH NO_INFOMSGS;')
	
	PRINT 'Altering Column Adding Schema ' + @tableName + '.' + @columnName
	exec('ALTER TABLE [' + @tableName + '] ALTER COLUMN ' + @columnName + ' XML(' + @xmlSchemaName + ')')

	PRINT 'Running DBCC CleanTable on ' + @tableName
	SELECT @SQL = N'DBCC CLEANTABLE (0, "' + QUOTENAME(@tableName) + '") WITH NO_INFOMSGS;'
	EXEC (@SQL)
	-- exec('DBCC CLEANTABLE (0, "' + @tableName + '") WITH NO_INFOMSGS;')
	
	FETCH NEXT FROM cur INTO @tableName, @columnName
END
CLOSE cur
DEALLOCATE cur

PRINT 'Rebuilding Views for Schema'
OPEN vws
FETCH NEXT FROM vws INTO @viewName
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @views_text = ''
	DELETE FROM @views
	
	INSERT INTO @views exec sp_helptext @viewName
	
	SELECT @views_text = @views_text + value FROM @views

	exec('DROP VIEW ' + @viewName)
	
	exec(@views_text)	

	FETCH NEXT FROM vws INTO @viewName
END
CLOSE vws
DEALLOCATE vws


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PatientHasQualifyingObservation]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[PatientHasQualifyingObservation] AS' 
END
GO
ALTER PROC [dbo].[PatientHasQualifyingObservation]
	(@PatientUid uniqueidentifier,
	@HMRuleUid uniqueidentifier,
	@Result varchar(4000) OUTPUT)
	
AS  

BEGIN 
	declare @tempPK uniqueidentifier
	DECLARE @sql varchar(4000)
	DECLARE @ortext varchar(5)
	SET @ortext = ''
	SET @sql = ' SELECT COUNT(*), '''
	SET @sql += CAST(@PatientUid AS varchar(50)) + ''', ''' + CAST(@HMRuleUid AS varchar(50))
	SET @sql += ''' FROM ViewCDSObservationValue ov '
	SET @sql += ' WHERE ov.PatientUid = ''' + CAST(@PatientUid AS varchar(50)) + ''''
	DECLARE @type int
	DECLARE @stringoiuid varchar(50)
	DECLARE @subtype varchar(50)
	DECLARE @decimalvalue decimal(16,4)
	DECLARE @decimalvalue2 decimal(16,4)
	DECLARE @testvalue varchar(50)
	
	declare  @temp table (
		PK uniqueidentifier,
		Done bit,
		TypeNum smallint, 
		ObservationItemUid uniqueidentifier, 
		SubType varchar(100),
		DecimalValue1 decimal,
		DecimalValue2 decimal,
		TestValue nvarchar(max),
		DisplayOrder int
	)

	insert into @temp
	SELECT
		NEWID(),
		0,
		[Type], 
		CAST(ObservationItemUid AS varchar(50)), 
		Subtype, 
		DecimalValue1,
		DecimalValue2,
		CASE 
			WHEN DecimalValue1 is null THEN '''' + StringValue + ''''
			ELSE '''' + ''''
		END,
		DisplayOrder
	FROM HMRuleObservationTest
	WHERE HMRuleUid = @HMRuleUid
	ORDER BY DisplayOrder;

	if(exists(select * from @temp))
	begin
	SET @sql += ' AND ( '

	declare @prevType TINYINT = 0
	while(exists(select top 1 * from @temp where Done=0))
	begin
		--select @type=TypeNum, @stringoiuid, @subtype, @decimalvalue, @decimalvalue2, @testvalue
		select top 1 
		@tempPK=PK,
		@type=TypeNum,
		@stringoiuid=ObservationItemUid,
		@subtype=SubType,
		@decimalvalue=DecimalValue1,
		@decimalvalue2=DecimalValue2,
		@testvalue=TestValue
		from @temp
		where Done=0
		order by DisplayOrder

		IF (@type = 3 AND @prevType = 3) SET @sql += ' OR '
		SET @prevType = @type

		SET @sql +=
			CASE 
				WHEN @type = 1 OR @type = 2 
					THEN @subtype
				WHEN @stringoiuid = '00000000-0000-0000-7777-100000000073'  OR
					@stringoiuid = '00000000-0000-0000-7777-100000000074'  OR
					@stringoiuid = '00000000-0000-0000-7777-100000000075'  OR
					@stringoiuid = '00000000-0000-0000-7777-100000000076'
					THEN
						CASE 
							WHEN @subtype = '<' OR @subtype = '<='
								THEN
								'( observationitemuid = ''' + @stringoiuid + 
								''' and ( metricvalue1 ' + @subtype + ' ' + 
								cast(@decimalvalue as varchar(50)) + ' and ' +
								'metricvalue2 ' + @subtype + ' ' +
								cast(@decimalvalue2 as varchar(50)) + '))'
							ELSE
								'( observationitemuid = ''' + @stringoiuid + 
								''' and ( metricvalue1 ' + @subtype + ' ' + 
								cast(@decimalvalue as varchar(50)) + ' or ' +
								'metricvalue2 ' + @subtype + ' ' +
								cast(@decimalvalue2 as varchar(50)) + '))'
						END
				ELSE

					CASE WHEN @decimalvalue IS NULL 
						THEN
							'( observationitemuid = ''' + @stringoiuid +
							''' and observationvalue is not null and observationvalue ' + 
							@subtype + ' ' + @testvalue + ') ' 
						ELSE
							'( observationitemuid = ''' + @stringoiuid +
							''' and ((observationvaluedecimal is not null and observationvaluedecimal ' + 
							@subtype + ' ' + cast(@decimalvalue as varchar(50)) + ') or ' +
							' metricvalue1 ' + @subtype + ' ' + cast(@decimalvalue as varchar(50)) + '))'
					END
			END
		update @temp
		set Done=1
		where PK=@tempPK

	end
	SET @sql += ' )'
	END
	SELECT @Result = @sql
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CreateHMRuleIsDueMessage]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[CreateHMRuleIsDueMessage] AS' 
END
GO
ALTER PROC [dbo].[CreateHMRuleIsDueMessage]
(
	@PatientHMRuleUid [uniqueidentifier]
)
AS
/************************************************************************************************/
/* Name:	CreateHMRuleIsDueMessage 							*/
/* Desc:	This stored procedure will create a message when a PatientHMRule becomes due	*/
/*		It will create one message and assign it to each message recipient related to	*/
/*		this HMRule									*/
/*												*/
/* DATE		MODIFIED BY		MODIFICATIONS						*/
/* 08/19/2005	Chip Pace		Created							*/
/* 06/26/2006	Ken Simone		Set IsModified for replication							*/
/* 09/25/2006	Ken Simone		Remove IsModified							*/
/*												*/
/************************************************************************************************/
BEGIN

	SET NOCOUNT ON;
  SET XACT_ABORT ON;
	DECLARE @Inactive [bit] = 0

--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
	IF NOT EXISTS(
		SELECT TOP 1 *
		FROM [PatientHMRule] WITH(NOLOCK)
			JOIN [ListHMRule] WITH(NOLOCK) ON [ListHMRule].[HMRuleUid] = [PatientHMRule].[HMRuleUid]
			JOIN [RelHMRuleClinicCenter] WITH(NOLOCK) ON [RelHMRuleClinicCenter].[HMRuleUid] = [ListHMRule].[HMRuleUid]
			JOIN [RelHMRuleClinicCenterMsgRecipient] WITH(NOLOCK) ON [RelHMRuleClinicCenterMsgRecipient].[HMRuleClinicCenterUid] = [RelHMRuleClinicCenter].[HMRuleClinicCenterUid]
		WHERE [PatientHMRule].[PatientHMRuleUid] = @PatientHMRuleUid
			AND [ListHMRule].[Inactive] = @Inactive
	)
	BEGIN
		RETURN
	END
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group

	BEGIN TRANSACTION

	/* Create a new MessageUid									*/
	/************************************************************************************************/
	DECLARE @NewGuid [uniqueidentifier] = NEWID()

	/* Get the current date										*/
	/************************************************************************************************/
	DECLARE @CurrentDate [datetime] = GETUTCDATE()	

	/* Get the default Message Urgency								*/
	/************************************************************************************************/
	DECLARE	@MessageUrgencyUid [uniqueidentifier]
	SELECT TOP 1 @MessageUrgencyUid = [MessageUrgencyUid]
	FROM [ListMessageUrgency]
	WHERE [IsDefault] = 1

	/* Insert the Message Record									*/
	/************************************************************************************************/
	INSERT INTO	[Message]
	(
		[MessageUid],
		[PersonUid],
		[MessageTypeUid],
		[MessageSubTypeUid],
		[Header],
		[MessageUrgencyUid],
		[CreatedDate],
		[CreatedDateTime],
		[DateToBeCompleted]
	)
	SELECT DISTINCT	@NewGuid,
		[PatientHMRule].[PatientUid],
		'10101010-0000-0000-0000-000000000005', -- Task Message Type
		'10101010-0000-0000-0000-000000000050', -- HMRule Message Sub Type
		[ListHMRule].[Name] + ' Is Due',
		@MessageUrgencyUid,
		CAST(GETDATE() AS DATE),
		@CurrentDate,
		[PatientHMRule].[DueDate]
	FROM [PatientHMRule]
		JOIN [ListHMRule] ON [ListHMRule].[HMRuleUid] = [PatientHMRule].[HMRuleUid]
		JOIN [RelHMRuleClinicCenter] ON [RelHMRuleClinicCenter].[HMRuleUid] = [ListHMRule].[HMRuleUid]
		JOIN [RelHMRuleClinicCenterMsgRecipient] ON [RelHMRuleClinicCenterMsgRecipient].[HMRuleClinicCenterUid] = [RelHMRuleClinicCenter].[HMRuleClinicCenterUid]
	WHERE [PatientHMRule].[PatientHMRuleUid] = @PatientHMRuleUid
		AND [ListHMRule].[Inactive] = @Inactive


	/* Insert the MessageTask Record								*/
	/************************************************************************************************/
	INSERT INTO	[MessageTask]
	(
		[MessageUid],
		[Note],
		[PatientHMRuleUid]
	)
	SELECT @NewGuid,
		[ListHMRule].[Name] + ' Is Due',
		[PatientHMRule].[PatientHMRuleUid]
	FROM [PatientHMRule]
		JOIN [ListHMRule] ON [ListHMRule].[HMRuleUid] = [PatientHMRule].[HMRuleUid]
		JOIN [Message] ON [Message].[MessageUid] = @NewGuid
	WHERE [PatientHMRule].[PatientHMRuleUid] = @PatientHMRuleUid
		AND [ListHMRule].[Inactive] = @Inactive

	/* Insert the "User" MessageUser record(s)							*/
	/************************************************************************************************/
	INSERT INTO	[MessageUser]
	(
		[UserUid],
		[MessageUid]
	)
	SELECT DISTINCT	[RelHMRuleClinicCenterMsgRecipient].[UserUid],
		@NewGuid
	FROM [RelHMRuleClinicCenterMsgRecipient]
		JOIN [RelHMRuleClinicCenter] ON [RelHMRuleClinicCenter].[HMRuleClinicCenterUid] = [RelHMRuleClinicCenterMsgRecipient].[HMRuleClinicCenterUid]
		JOIN [PatientHMRule] ON [PatientHMRule].[HMRuleUid] = [RelHMRuleClinicCenter].[HMRuleUid]
		JOIN [ListHMRule] ON [ListHMRule].[HMRuleUid] = [PatientHMRule].[HMRuleUid]
	WHERE [PatientHMRule].[PatientHMRuleUid] = @PatientHMRuleUid
		AND [RelHMRuleClinicCenterMsgRecipient].[UserUid] IS NOT NULL
		AND [ListHMRule].[Inactive] = @Inactive

	/* Insert the "UserGroup" MessageUser record(s)							*/
	/************************************************************************************************/
	INSERT INTO	[MessageUser]
	(
		[UserGroupUid],
		[MessageUid]
	)
	SELECT DISTINCT	[RelHMRuleClinicCenterMsgRecipient].[UserGroupUid],
		@NewGuid
	FROM [RelHMRuleClinicCenterMsgRecipient]
		JOIN [RelHMRuleClinicCenter]  ON [RelHMRuleClinicCenter].[HMRuleClinicCenterUid] = [RelHMRuleClinicCenterMsgRecipient].[HMRuleClinicCenterUid]
		JOIN [PatientHMRule] ON [PatientHMRule].[HMRuleUid] = [RelHMRuleClinicCenter].[HMRuleUid]
		JOIN [ListHMRule] ON [ListHMRule].[HMRuleUid] = [PatientHMRule].[HMRuleUid]
	WHERE [PatientHMRule].[PatientHMRuleUid] = @PatientHMRuleUid
		AND [RelHMRuleClinicCenterMsgRecipient].[UserGroupUid] IS NOT NULL
		AND [ListHMRule].[Inactive] = @Inactive

	COMMIT
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ApplyHMRulesToPatients]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ApplyHMRulesToPatients] AS' 
END
GO
ALTER  PROC [dbo].[ApplyHMRulesToPatients]
(
    @PatientUid uniqueidentifier,
    @HMRuleUid	uniqueidentifier,                  -- @HMRuleUid is required in order to inactivate patient rules that no longer meet criteria.
    @InactivateNonRelevantPatientRules bit = null,  -- If TRUE, then inactivate old patient rules that no longer meet the criteria 
														-- this flag only honored if PatientUid is null and HMRuleUid is not null
	@ShowDebug bit = 0
)
AS
BEGIN
	--This was completely rewritten in Mar 2013 for requirements related to Meaningful Use II
	--It now executes in two sections:  the first when @PatientUid is not null, meaning "update any rules for 
	--this patient"; the second executes for all patients.  
	--The second argument defines how many rules will be checked:  if a Uid is provided, only that rule
	--is checked.  If no Uid is provided, all rules are checked.
	--I also added a ShowDebug option to aid debugging this thing when all else fails.
	--Within each execution section, three processes are carried out.  1) Are there any new rules fired?
	--2) Should any existing rules that have been deactivated be reactivated?  3) Should any rules be removed?
	--The third section only actually removes rules when the @InactivateNonRelevantPatientRules argument is 1

	SET NOCOUNT ON;
  SET XACT_ABORT ON;
	
	DECLARE @FALSE BIT
	SELECT @FALSE = 0

	DECLARE @TRUE BIT
	SELECT @TRUE = 1

	DECLARE @RuleCount int
	SET @RuleCount = 0
		
	DECLARE	@CurrentDate datetime

	DECLARE @Years 	uniqueidentifier
	DECLARE @Months	uniqueidentifier
	DECLARE @Weeks 	uniqueidentifier
	DECLARE @Days 	uniqueidentifier

	DECLARE @Mins	int
	
	DECLARE @RetestHMRuleUid uniqueidentifier
	DECLARE @RetestPatientUid uniqueidentifier
	DECLARE @Answer varchar(4000)

	declare @tempPatientRuleTable table
	(
		PK uniqueidentifier DEFAULT(newid()),
		PatientUid uniqueidentifier,
		HMRuleUid uniqueidentifier
	)
	declare @tempPK uniqueidentifier
	declare @tempObsPatientUid uniqueidentifier
	declare @tempObsHMRuleUid uniqueidentifier

	DECLARE @ObservationTestCount TABLE
	(
		[Found] [int] DEFAULT(0),
		[PatientUid] [uniqueidentifier],
		[HMRuleUid] [uniqueidentifier]
		primary key([PatientUid], [HMRuleUid])
	)
		

/* Determine the Current Date																	*/
/************************************************************************************************/
	SET	@CurrentDate = CAST(GETUTCDATE() AS DATE)
	SET	@Mins = DATEDIFF(n, GETDATE(), GETUTCDATE())

/* Determine the Time Type Uids 																*/
/************************************************************************************************/
	SELECT 	@Years = TimeTypeUid FROM ListTimeType WHERE Name = 'Years'
	SELECT 	@Months = TimeTypeUid FROM ListTimeType WHERE Name = 'Months'
	SELECT 	@Weeks = TimeTypeUid FROM ListTimeType WHERE Name = 'Weeks'
	SELECT 	@Days = TimeTypeUid FROM ListTimeType WHERE Name = 'Days'
	
	-- skip the process if there is no HMRule
	IF NOT EXISTS ( SELECT TOP 1 *
					FROM ListHMRule
					WHERE Inactive = 0
				  )
	BEGIN
		IF @PatientUid IS NOT NULL 
		BEGIN
			SELECT @RuleCount
		END
		RETURN
	END

	-- skip the process if the patient is inactive or dead.
	IF @PatientUid IS NOT NULL 
	BEGIN
		IF EXISTS ( SELECT TOP 1 *
				  FROM Patient AS pp INNER JOIN Person AS p
					ON pp.PersonUid = p.PersonUid 
					  AND (pp.Inactive <> 0 OR p.DeathDate IS NOT NULL)
			WHERE pp.PersonUid = @PatientUid)
		BEGIN
			SELECT @RuleCount
			RETURN
		END
	END

	-- skip the process if the HM Rule action is only to display an alert popup.
	IF @HMRuleUid IS NOT NULL
	BEGIN
		IF NOT EXISTS (SELECT TOP 1 * FROM RelHMRuleProcedure WHERE RelHMRuleProcedure.HMRuleUid = @HMRuleUid)
		BEGIN 
			-- No Procedure to complete is associated with the HM Rule.  Therefore, rule only displays an alert message.
			SELECT @RuleCount
			RETURN
		END                
	END

	BEGIN TRANSACTION
	
	CREATE TABLE #NewRules
		(
		HMRuleName varchar(100),
		HMRuleUid uniqueidentifier,
		PatientName varchar(100),
		PatientUid uniqueidentifier,
		IsDue bit,
		DueDate datetime,
		PastDueDate datetime
		)

	DECLARE @patient TABLE
		(	
		Birthdate DATETIME NULL,
		GenderUid UNIQUEIDENTIFIER NULL,
		FirstName VARCHAR(100) NULL,
		LastName VARCHAR(100) NULL
		)

		-- temp tables used to cull inactive rules
	CREATE TABLE #NonRelevantPatientRules 
		(PatientHMRuleUid uniqueidentifier)  -- List of patient rules that no longer meet the criteria.
	CREATE TABLE #CurrentPatientRules 
		(PatientHMRuleUid uniqueidentifier)      -- Current list of patient rules that meet the criteria.
		
		-- working version of ListHMRule
	CREATE TABLE #RuleCriteria
			(
			HMRuleName varchar(100),
			HMRuleUid uniqueidentifier,
			AgeToDate datetime,
			AgeFromDate datetime,
			GenderUid uniqueidentifier,
			AgeFrom int,
			AgeTo int,
			AgeTimeTypeUid uniqueidentifier,
			RecurFrom int,
			RecurTo int,
			RecurTimeTypeUid uniqueidentifier,
			AdvanceWarning int,
			AdvanceWarningTimeTypeUid uniqueidentifier,
			DiseaseUid uniqueidentifier,
			FDB_MNID int,
			FDB_ClassID int,
			DrugAllergyQuestionUid uniqueidentifier,
			HasObservationCriteria int
			)

	IF @InactivateNonRelevantPatientRules IS NOT NULL
	BEGIN
	
		IF @InactivateNonRelevantPatientRules = @TRUE
		BEGIN
		
			IF @HMRuleUid IS NOT NULL
			BEGIN
			
				IF @PatientUid IS NOT NULL
				BEGIN
					INSERT INTO #NonRelevantPatientRules 
						(PatientHMRuleUid)
					SELECT PatientHMRuleUid 
						FROM PatientHMRule 
						WHERE HMRuleUid = @HMRuleUid AND PatientUid = @PatientUid    
				END
				ELSE
				BEGIN
					INSERT INTO #NonRelevantPatientRules 
						(PatientHMRuleUid)
					SELECT PatientHMRuleUid 
						FROM PatientHMRule 
						WHERE HMRuleUid = @HMRuleUid 
				END 
			END
		END
	END
	IF NOT EXISTS (SELECT TOP 1 * FROM #NonRelevantPatientRules)
	BEGIN
		--  No need to inactivate anything if no active ones are found for the input request
		SELECT @InactivateNonRelevantPatientRules = @FALSE
	END 


		--Populate the working copy of ListHMRule:  notice when the second arguement
		--to the stored proc is not null, only that one rule is added here
	INSERT INTO   #RuleCriteria
		(
			HMRuleName,
			HMRuleUid,
			AgeToDate,
			AgeFromDate,
			GenderUid,
			AgeFrom,
			AgeTo,
			AgeTimeTypeUid,
			RecurFrom,
			RecurTo,
			RecurTimeTypeUid,
			AdvanceWarning,
			AdvanceWarningTimeTypeUid,
			DiseaseUid,
			FDB_MNID,
			FDB_ClassID,
			DrugAllergyQuestionUid,
			HasObservationCriteria
		)
		SELECT 
			lhmr.Name,
			lhmr.HMRuleUid, 
			lhmr.AgeToDate,
			CASE lhmr.AdvanceWarningTimeTypeUid
				WHEN @Years THEN DATEADD(year, lhmr.AdvanceWarning,lhmr.AgeFromDate)
				WHEN @Months THEN DATEADD(month, lhmr.AdvanceWarning,lhmr.AgeFromDate)
				WHEN @Weeks THEN DATEADD(day, lhmr.AdvanceWarning * 7,lhmr.AgeFromDate)
				WHEN @Days THEN DATEADD(day, lhmr.AdvanceWarning,lhmr.AgeFromDate)
			END AS AgeFromDate,
			lhmr.GenderUid,
			lhmr.AgeFrom,
			lhmr.AgeTo,
			lhmr.AgeTimeTypeUid,
			lhmr.RecurFrom,
			lhmr.RecurTo,
			lhmr.RecurTimeTypeUid,
			lhmr.AdvanceWarning,
			lhmr.AdvanceWarningTimeTypeUid,
			lhmr.DiseaseUid,
			lhmr.FDB_MNID,
			lhmr.FDB_ClassID,
			lhmr.DrugAllergyQuestionUid,
			lhmr.HasObservationCriteria
		FROM  
			(SELECT DISTINCT	
				ListHMRule.Name,
				ListHMRule.HMRuleUid,
				CASE AgeTimeTypeUid
					WHEN @Years THEN DATEADD(day,1,DATEADD(year,-AgeTo -1,@CurrentDate))
					WHEN @Months THEN DATEADD(day,1,DATEADD(month,-AgeTo -1, @CurrentDate))
					WHEN @Weeks THEN DATEADD(day,1,DATEADD(day,(-AgeTo -1) * 7, @CurrentDate))
					WHEN @Days THEN DATEADD(day, -AgeTo, @CurrentDate)
				END AS AgeToDate,
				CASE AgeTimeTypeUid
					WHEN @Years THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(year,-AgeFrom,@CurrentDate)))
					WHEN @Months THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(month,-AgeFrom, @CurrentDate)))
					WHEN @Weeks THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(day,-AgeFrom * 7, @CurrentDate)))
					WHEN @Days THEN DATEADD(second,-1,DATEADD(day, -AgeFrom+1, @CurrentDate))
				END AS AgeFromDate,
				RelHMRuleGender.GenderUid,
				ListHMRule.AgeFrom,
				ListHMRule.AgeTo,
				ListHMRule.AgeTimeTypeUid,
				ListHMRule.RecurFrom,
				ListHMRule.RecurTo,
				ListHMRule.RecurTimeTypeUid,
				ListHMRule.AdvanceWarning,
				ListHMRule.AdvanceWarningTimeTypeUid,
				CASE WHEN RelHMRuleDisease.RelHMRuleDiseaseUid IS NOT NULL
					THEN RelHMRuleDisease.DiseaseUid
					ELSE NULL
					END
				AS DiseaseUid,
				CASE WHEN RelHMRuleDrugName.RelHMRuleDrugNameUid IS NOT NULL
					THEN RelHMRuleDrugName.FDB_MNID
					ELSE NULL
					END
				AS FDB_MNID,
				CASE WHEN RelHMRuleDrugClass.RelHMRuleDrugClassUid IS NOT NULL
					THEN RelHMRuleDrugClass.FDB_ClassID
					ELSE NULL
					END
				AS FDB_ClassID,
				CASE WHEN RelHMRuleDrugAllergy.RelHMRuleDrugAllergyUid IS NOT NULL
					THEN RelHMRuleDrugAllergy.QuestionUid
					ELSE NULL
					END
				AS DrugAllergyQuestionUid,
				(SELECT COUNT(*) FROM HMRuleObservationTest WHERE HMRuleUid = ListHMRule.HMRuleUid)
				AS HasObservationCriteria
			FROM  ListHMRule
				JOIN  RelHMRuleGender ON 
					1 = 
					(CASE WHEN @HMRuleUid IS NOT NULL THEN 
							(CASE WHEN ListHMRule.HMRuleUid = @HMRuleUid THEN 1 
							ELSE 0 END)
						  ELSE 1
					END)
					AND RelHMRuleGender.HMRuleUid = ListHMRule.HMRuleUid
					AND ListHMRule.Inactive = 0
				JOIN  ListGender ON 
					ListGender.GenderUid = RelHMRuleGender.GenderUid AND 
					ListGender.Inactive = 0	
				LEFT JOIN
					RelHMRuleDisease ON
						RelHMRuleDisease.HMRuleUid = ListHMRule.HMRuleUid
				LEFT JOIN
					RelHMRuleDrugName ON
						RelHMRuleDrugName.HMRuleUid = ListHMRule.HMRuleUid
				LEFT JOIN
					RelHMRuleDrugClass ON
						RelHMRuleDrugClass.HMRuleUid = ListHMRule.HMRuleUid
				LEFT JOIN
					RelHMRuleDrugAllergy ON
						RelHMRuleDrugAllergy.HMRuleUid = ListHMRule.HMRuleUid
			) AS lhmr
			
	IF @ShowDebug = 1
	BEGIN
		SELECT 'RuleCriteria'			
		SELECT * FROM #RuleCriteria
	END

		--Perform all setup logic to determine what needs to happen to the PatientHMRule table when
		--only one patient is processed
	IF @PatientUid IS NOT NULL
	BEGIN		            
		INSERT	@patient
		SELECT  
			per.Birthdate, 
			per.GenderUid, 
			per.FirstName, 
			per.LastName
		FROM	
			Patient pat INNER JOIN 
			Person per ON pat.PersonUid = per.PersonUid
		WHERE	
			pat.PersonUid = @PatientUid AND
			pat.Inactive = 0 AND
			per.Deathdate IS NULL
            
		--Nothing is done unless rules were found to process
		IF EXISTS ( SELECT TOP 1 * FROM #RuleCriteria )
		BEGIN

		--Determine any rules that have not had a PatientHMRUle made that need one
			INSERT INTO   #NewRules   
				(
					HMRuleName,
					HMRuleUid,
					PatientName,
					PatientUid,
					IsDue,
					DueDate
				)
				SELECT DISTINCT 
					#RuleCriteria.HMRuleName,
					#RuleCriteria.HMRuleUid,
					pat.FirstName + ' ' + pat.LastName,
					@PatientUid,
					1,
					CASE 
						WHEN PO.RelHMRulePatientOverrideUid IS NULL 
						THEN        
							CASE #RuleCriteria.AgeTimeTypeUid
								WHEN @Years THEN DATEADD(year,#RuleCriteria.AgeFrom,pat.BirthDate)
								WHEN @Months THEN DATEADD(month,#RuleCriteria.AgeFrom,pat.BirthDate)
								WHEN @Weeks THEN DATEADD(day,#RuleCriteria.AgeFrom * 7,pat.BirthDate)
								WHEN @Days THEN DATEADD(day,#RuleCriteria.AgeFrom,pat.BirthDate)
							END -- AS DueDate
						ELSE 
							CASE PO.AgeTimeTypeUid
								WHEN @Years THEN DATEADD(year,PO.AgeFrom,pat.BirthDate)
								WHEN @Months THEN DATEADD(month,PO.AgeFrom,pat.BirthDate)
								WHEN @Weeks THEN DATEADD(day,PO.AgeFrom * 7,pat.BirthDate)
								WHEN @Days THEN DATEADD(day,PO.AgeFrom,pat.BirthDate)
						END -- AS DueDate                       
					END AS DueDate                       
				FROM            
					@patient pat  JOIN            
					#RuleCriteria ON 
						pat.GenderUid = #RuleCriteria.GenderUid  LEFT JOIN            
					PatientHMRule ON 
						(PatientHMRule.PatientUid = @PatientUid  AND 
						PatientHMRule.HMRuleUid = #RuleCriteria.HMRuleUid AND 
						PatientHMRule.Inactive   = 0)  LEFT JOIN       
					#NewRules ON 
						(#RuleCriteria.HMRuleUid = #NewRules.HMRuleUid  AND 
						#NewRules.PatientUid = @PatientUid)  LEFT JOIN       
					RelHMRulePatientOverride PO ON 
						(PO.PatientUid = @PatientUid  AND 
						PO.HMRuleUid = #RuleCriteria.HMRuleUid)  LEFT JOIN
					ViewCDSPatientDisease ON
						ViewCDSPatientDisease.PatientUid = @PatientUid  AND
						ViewCDSPatientDisease.DiseaseUid = #RuleCriteria.DiseaseUid  LEFT JOIN
					ViewCDSPatientMedicationNameOrClass ON
						ViewCDSPatientMedicationNameOrClass.PersonUid = @PatientUid  AND
						(ViewCDSPatientMedicationNameOrClass.FDB_MNID = #RuleCriteria.FDB_MNID  OR
						ViewCDSPatientMedicationNameOrClass.FDB_ClassID = #RuleCriteria.FDB_ClassID)  LEFT JOIN
					ViewCDSPatientDrugAllergy  ON
						ViewCDSPatientDrugAllergy.PersonUid = @PatientUid  AND
						ViewCDSPatientDrugAllergy.QuestionUid = #RuleCriteria.DrugAllergyQuestionUid    
				WHERE           
					PatientHMRule.PatientHMRuleUid IS NULL  AND -- Ensure that this rule doesn't already exist for this patient
					#NewRules.HMRuleUid IS NULL  AND -- Ensure that this rule did not already get created for this patient
					pat.Birthdate 
						BETWEEN 
							CASE 
								WHEN PO.AgeTimeTypeUid IS NULL THEN #RuleCriteria.AgeToDate
								WHEN PO.AgeTimeTypeUid = @Years  THEN DATEADD(day,1,DATEADD(year,-PO.AgeTo -1,@CurrentDate))
								WHEN PO.AgeTimeTypeUid = @Months THEN DATEADD(day,1,DATEADD(month,-PO.AgeTo -1, @CurrentDate))
								WHEN PO.AgeTimeTypeUid = @Weeks  THEN DATEADD(day,1,DATEADD(day,(-PO.AgeTo -1) * 7, @CurrentDate))
								WHEN PO.AgeTimeTypeUid = @Days   THEN DATEADD(day, -PO.AgeTo, @CurrentDate)
							END 
						AND 
							CASE WHEN PO.AgeTimeTypeUid IS NULL THEN #RuleCriteria.AgeFromDate                                             
								 WHEN PO.AgeTimeTypeUid = @Years  THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(year,-PO.AgeFrom,@CurrentDate)))
								 WHEN PO.AgeTimeTypeUid = @Months THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(month,-PO.AgeFrom, @CurrentDate)))
								 WHEN PO.AgeTimeTypeUid = @Weeks  THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(day,-PO.AgeFrom * 7, @CurrentDate)))
								 WHEN PO.AgeTimeTypeUid = @Days THEN DATEADD(second,-1,DATEADD(day, -PO.AgeFrom+1, @CurrentDate))
							END                       
					AND 
					(1 = (CASE 
							WHEN PO.Inactive IS NULL THEN 1  -- Override does not exist.  Therefore, PatientHMRule is not disabled.
							WHEN PO.Inactive = 1     THEN 0  -- Override does exist.  Inactive flag for override is TRUE.   PatientRule is disabled.
							WHEN PO.Inactive = 0     THEN 1  -- Override does exist.  Inactive flag for override is FALSE.  PatientRule is not disabled.
					END))                                             
					AND
					(1 = (CASE 
							WHEN #RuleCriteria.DiseaseUid IS NULL THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							WHEN ViewCDSPatientDisease.PatientUid = @PatientUid
								AND ViewCDSPatientDisease.DiseaseUid = #RuleCriteria.DiseaseUid THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							ELSE 0
							END))
					AND
					(1 = (CASE
							WHEN #RuleCriteria.FDB_MNID IS NULL AND #RuleCriteria.FDB_ClassID IS NULL THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							WHEN ViewCDSPatientMedicationNameOrClass.PersonUid = @PatientUid
								AND
								(
									(								
										(#RuleCriteria.FDB_MNID IS NOT NULL AND	ViewCDSPatientMedicationNameOrClass.FDB_MNID = #RuleCriteria.FDB_MNID)
										OR (#RuleCriteria.FDB_ClassID IS NOT NULL AND ViewCDSPatientMedicationNameOrClass.FDB_ClassID = #RuleCriteria.FDB_ClassID)
									)
									AND (ViewCDSPatientMedicationNameOrClass.ActiveDate IS NOT NULL AND ViewCDSPatientMedicationNameOrClass.ActiveDate <= @CurrentDate)
									AND (ViewCDSPatientMedicationNameOrClass.InactiveDate IS NULL OR ViewCDSPatientMedicationNameOrClass.InactiveDate >= @CurrentDate)
									AND (ViewCDSPatientMedicationNameOrClass.OverallStartDate IS NOT NULL AND ViewCDSPatientMedicationNameOrClass.OverallStartDate <= @CurrentDate)
									AND (ViewCDSPatientMedicationNameOrClass.OverallStopDate IS NULL OR ViewCDSPatientMedicationNameOrClass.OverallStopDate >= @CurrentDate)
								)
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
								THEN 1
							ELSE 0
							END))
					AND
					(1 = (CASE
							WHEN #RuleCriteria.DrugAllergyQuestionUid IS NULL  THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							WHEN ViewCDSPatientDrugAllergy.PersonUid = @PatientUid
								AND ViewCDSPatientDrugAllergy.QuestionUid = #RuleCriteria.DrugAllergyQuestionUid 
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
								THEN 1
							ELSE 0
							END))
							

			IF @ShowDebug = 1
			BEGIN
				SELECT 'NewRUles'
				SELECT COUNT(*) FROM #NewRules
				SELECT * FROM #NewRules
			END

			--Create a crossreference for any rules that include observation tests so the dynamic sql for those
			--tests can be built	

			insert into @tempPatientRuleTable(HMRuleUid, PatientUid)
			SELECT 
				DISTINCT #NewRules.HMRuleUid,
				#NewRules.PatientUid
			FROM 
				#RuleCriteria  JOIN
				#NewRules  ON	#NewRules.HMRuleUid = #RuleCriteria.HMRuleUid
			WHERE
				#RuleCriteria.HasObservationCriteria <> 0;

			while(exists(select top 1 * from @tempPatientRuleTable))
			begin
				select top 1 @tempPK=PK, @tempObsPatientUid=PatientUid, @tempObsHMRuleUid=HMRuleUid 
				from @tempPatientRuleTable

				IF @ShowDebug = 1
				BEGIN
					SELECT 'Observation HMRule/Patient Checks'
					SELECT @tempObsPatientUid
					SELECT @tempObsHMRuleUid
				END
						
				SET @Answer = NULL
				EXEC [PatientHasQualifyingObservation] 
					@tempObsPatientUid, @tempObsHMRuleUid, @Result = @Answer OUTPUT;
							
				IF @ShowDebug = 1
				BEGIN
					SELECT '@Answer for @tempObsHMRuleUid'
					SELECT @Answer
					SELECT @tempObsHMRuleUid
				END
						
				IF @Answer IS NOT NULL
				BEGIN
				--Create the dynamic sql to run the test, then exec it to load a count of
				--hits on the rule.  If the number is positive, the rule is fired.
					INSERT INTO @ObservationTestCount  ( Found, PatientUid, HMRuleUid )
					exec (@Answer)
							
				END

				delete @tempPatientRuleTable where PK=@tempPK
			end

			--If any observation tests had positive results, keep them, else delete the rules that failed their
			--observation test from the temp table.			
			IF EXISTS (SELECT TOP 1 * FROM @ObservationTestCount WHERE Found = 0 )
			BEGIN
				DELETE FROM #NewRules
					FROM #NewRules AS nr JOIN 
						@ObservationTestCount otc ON 
							nr.PatientUid = otc.PatientUid AND
							nr.HMRuleUid = otc.HMRuleUid 
					WHERE 
						otc.Found = 0
			END

			IF @ShowDebug = 1
			BEGIN
				SELECT 'NewRUles AFTER Observation Test Validation'
				SELECT * FROM @ObservationTestCount
				SELECT COUNT(*) FROM #NewRules
				SELECT * FROM #NewRules
			END
			
		--Review any pre-existing rules for this patient and make them due if their rules have refired.
			UPDATE   PatientHMRule
				SET		
					IsDue = 1, 
					LastModifiedDate = GETUTCDATE()
				FROM	    
					PatientHMRule JOIN	    
					#RuleCriteria ON 
						(PatientHMRule.PatientUid = @PatientUid AND 
						#RuleCriteria.HMRuleUid = PatientHMRule.HMRuleUid AND 
						PatientHMRule.Inactive  = @FALSE AND 
						PatientHMRule.IsDue = @FALSE) JOIN      
					@patient pat ON pat.GenderUid = #RuleCriteria.GenderUid LEFT JOIN 
					RelHMRulePatientOverride PO ON 
						(PO.PatientUid = @PatientUid AND 
						PO.HMRuleUid = PatientHMRule.HMRuleUid)LEFT JOIN
					ViewCDSPatientDisease ON
						ViewCDSPatientDisease.PatientUid = @PatientUid  AND
						ViewCDSPatientDisease.DiseaseUid = #RuleCriteria.DiseaseUid  LEFT JOIN
					ViewCDSPatientMedicationNameOrClass ON
						ViewCDSPatientMedicationNameOrClass.PersonUid = @PatientUid  AND
						(ViewCDSPatientMedicationNameOrClass.FDB_MNID = #RuleCriteria.FDB_MNID  OR
						ViewCDSPatientMedicationNameOrClass.FDB_ClassID = #RuleCriteria.FDB_ClassID)  LEFT JOIN
					ViewCDSPatientDrugAllergy  ON
						ViewCDSPatientDrugAllergy.PersonUid = @PatientUid  AND
						ViewCDSPatientDrugAllergy.QuestionUid = #RuleCriteria.DrugAllergyQuestionUid  LEFT JOIN
					@ObservationTestCount otc ON
						(otc.PatientUid = @PatientUid  AND
						otc.HMRuleUid = #RuleCriteria.HMRuleUid)
				WHERE 
					pat.Birthdate 
						BETWEEN 
							CASE 
								WHEN PO.AgeTimeTypeUid IS NULL 
									THEN #RuleCriteria.AgeToDate
								WHEN PO.AgeTimeTypeUid = @Years  
									THEN DATEADD(day,1,DATEADD(year,-PO.AgeTo -1,@CurrentDate))
								WHEN PO.AgeTimeTypeUid = @Months 
									THEN DATEADD(day,1,DATEADD(month,-PO.AgeTo -1, @CurrentDate))
								WHEN PO.AgeTimeTypeUid = @Weeks  
									THEN DATEADD(day,1,DATEADD(day,(-PO.AgeTo -1) * 7, @CurrentDate))
								WHEN PO.AgeTimeTypeUid = @Days   
									THEN DATEADD(day, -PO.AgeTo, @CurrentDate)
							END 
						AND 
							CASE 
								WHEN PO.AgeTimeTypeUid IS NULL 
									THEN #RuleCriteria.AgeFromDate                                               
								WHEN PO.AgeTimeTypeUid = @Years  
									THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(year,-PO.AgeFrom,@CurrentDate)))
								WHEN PO.AgeTimeTypeUid = @Months 
									THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(month,-PO.AgeFrom, @CurrentDate)))
								WHEN PO.AgeTimeTypeUid = @Weeks  
									THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(day,-PO.AgeFrom * 7, @CurrentDate)))
								WHEN PO.AgeTimeTypeUid = @Days   
									THEN DATEADD(second,-1,DATEADD(day, -PO.AgeFrom+1, @CurrentDate))
							END          
					AND 
					@CurrentDate >= 
						CASE #RuleCriteria.AdvanceWarningTimeTypeUid
							WHEN @Years 
								THEN DATEADD(year,-#RuleCriteria.AdvanceWarning,PatientHMRule.DueDate)
							WHEN @Months 
								THEN DATEADD(month,-#RuleCriteria.AdvanceWarning, PatientHMRule.DueDate)
							WHEN @Weeks 
								THEN DATEADD(day,-#RuleCriteria.AdvanceWarning * 7, PatientHMRule.DueDate)
							WHEN @Days 
								THEN DATEADD(day, -#RuleCriteria.AdvanceWarning, PatientHMRule.DueDate)
						END
					AND
					(1 = 
						(CASE 
							WHEN PO.Inactive IS NULL 
								THEN 1  -- Override does not exist.  Therefore, PatientHMRule is not disabled.
							WHEN PO.Inactive = 1     
								THEN 0  -- Override does exist.  Inactive flag for override is TRUE.   PatientRule is disabled.
							WHEN PO.Inactive = 0     
								THEN 1  -- Override does exist.  Inactive flag for override is FALSE.  PatientRule is not disabled.
						END)
					)                                              
					AND
					(1 = (CASE 
							WHEN #RuleCriteria.DiseaseUid IS NULL THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							WHEN ViewCDSPatientDisease.PatientUid = @PatientUid 
								AND ViewCDSPatientDisease.DiseaseUid = #RuleCriteria.DiseaseUid THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							ELSE 0
							END))
					AND
					(1 = (CASE
							WHEN #RuleCriteria.FDB_MNID IS NULL AND #RuleCriteria.FDB_ClassID IS NULL THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							WHEN ViewCDSPatientMedicationNameOrClass.PersonUid = @PatientUid
								AND
								(
									(
										(#RuleCriteria.FDB_MNID IS NOT NULL AND	ViewCDSPatientMedicationNameOrClass.FDB_MNID = #RuleCriteria.FDB_MNID)
										OR (#RuleCriteria.FDB_ClassID IS NOT NULL AND ViewCDSPatientMedicationNameOrClass.FDB_ClassID = #RuleCriteria.FDB_ClassID)
									)
									AND (ViewCDSPatientMedicationNameOrClass.ActiveDate IS NOT NULL  AND ViewCDSPatientMedicationNameOrClass.ActiveDate <= @CurrentDate)
									AND (ViewCDSPatientMedicationNameOrClass.InactiveDate IS NULL  OR ViewCDSPatientMedicationNameOrClass.InactiveDate >= @CurrentDate)
									AND (ViewCDSPatientMedicationNameOrClass.OverallStartDate IS NOT NULL  AND ViewCDSPatientMedicationNameOrClass.OverallStartDate <= @CurrentDate)
									AND (ViewCDSPatientMedicationNameOrClass.OverallStopDate IS NULL  OR ViewCDSPatientMedicationNameOrClass.OverallStopDate >= @CurrentDate)
								)
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
								THEN 1
							ELSE 0
							END))
					AND
					(1 = (CASE
							WHEN #RuleCriteria.DrugAllergyQuestionUid IS NULL  THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							WHEN ViewCDSPatientDrugAllergy.PersonUid = @PatientUid
								AND ViewCDSPatientDrugAllergy.QuestionUid = #RuleCriteria.DrugAllergyQuestionUid 
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
								THEN 1
							ELSE 0
							END))
					AND
					(1 = (CASE
							WHEN #RuleCriteria.HasObservationCriteria < 1  THEN 1
							WHEN otc.Found > 0 THEN 1
							ELSE 0
							END))

			--If we are deleting inactive rules, then find out which ones have gone inactive
			IF @InactivateNonRelevantPatientRules = @TRUE
			BEGIN
				INSERT INTO #CurrentPatientRules 
					(PatientHMRuleUid)
				SELECT 
					PatientHMRule.PatientHMRuleUid
				FROM   
					#RuleCriteria JOIN 
					@patient pat ON pat.GenderUid = #RuleCriteria.GenderUid JOIN 
					PatientHMRule ON 
						(PatientHMRule.PatientUid = @PatientUid AND 
						PatientHMRule.HMRuleUid  = #RuleCriteria.HMRuleUid AND 
						PatientHMRule.Inactive   = 0) LEFT JOIN 
					RelHMRulePatientOverride PO ON 
						(PO.PatientUid = @PatientUid AND
						PO.HMRuleUid = #RuleCriteria.HMRuleUid)LEFT JOIN
					ViewCDSPatientDisease ON
						ViewCDSPatientDisease.PatientUid = @PatientUid  AND
						ViewCDSPatientDisease.DiseaseUid = #RuleCriteria.DiseaseUid  LEFT JOIN
					ViewCDSPatientMedicationNameOrClass ON
						ViewCDSPatientMedicationNameOrClass.PersonUid = @PatientUid  AND
						(ViewCDSPatientMedicationNameOrClass.FDB_MNID = #RuleCriteria.FDB_MNID  OR
						ViewCDSPatientMedicationNameOrClass.FDB_ClassID = #RuleCriteria.FDB_ClassID)  LEFT JOIN
					ViewCDSPatientDrugAllergy  ON
						ViewCDSPatientDrugAllergy.PersonUid = @PatientUid  AND
						ViewCDSPatientDrugAllergy.QuestionUid = #RuleCriteria.DrugAllergyQuestionUid  LEFT JOIN
					@ObservationTestCount otc  ON
						(otc.PatientUid = @PatientUid  AND
						otc.HMRuleUid = #RuleCriteria.HMRuleUid)    
				WHERE  
					pat.Birthdate 
						BETWEEN 
							CASE 
								WHEN PO.AgeTimeTypeUid IS NULL THEN #RuleCriteria.AgeToDate
								WHEN PO.AgeTimeTypeUid = @Years  THEN DATEADD(day,1,DATEADD(year,-PO.AgeTo -1,@CurrentDate))
								WHEN PO.AgeTimeTypeUid = @Months THEN DATEADD(day,1,DATEADD(month,-PO.AgeTo -1, @CurrentDate))
								WHEN PO.AgeTimeTypeUid = @Weeks  THEN DATEADD(day,1,DATEADD(day,(-PO.AgeTo -1) * 7, @CurrentDate))
								WHEN PO.AgeTimeTypeUid = @Days   THEN DATEADD(day, -PO.AgeTo, @CurrentDate)
							END 
						AND      
							CASE 
								WHEN PO.AgeTimeTypeUid IS NULL THEN #RuleCriteria.AgeFromDate                                               
								WHEN PO.AgeTimeTypeUid = @Years  THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(year,-PO.AgeFrom,@CurrentDate)))
								WHEN PO.AgeTimeTypeUid = @Months THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(month,-PO.AgeFrom, @CurrentDate)))
								WHEN PO.AgeTimeTypeUid = @Weeks  THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(day,-PO.AgeFrom * 7, @CurrentDate)))
								WHEN PO.AgeTimeTypeUid = @Days   THEN DATEADD(second,-1,DATEADD(day, -PO.AgeFrom+1, @CurrentDate))
							END  
					AND
					(1 = 
						(CASE 
							WHEN PO.Inactive IS NULL THEN 1  -- Override does not exist.  Therefore, PatientHMRule is not disabled.
							WHEN PO.Inactive = 1     THEN 0  -- Override does exist.  Inactive flag for override is TRUE.   PatientRule is disabled.
							WHEN PO.Inactive = 0     THEN 1  -- Override does exist.  Inactive flag for override is FALSE.  PatientRule is not disabled.
						END))
					AND
					(1 = (CASE 
							WHEN #RuleCriteria.DiseaseUid IS NULL THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							WHEN ViewCDSPatientDisease.PatientUid = @PatientUid 
								AND ViewCDSPatientDisease.DiseaseUid = #RuleCriteria.DiseaseUid THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							ELSE 0
							END))
					AND
					(1 = (CASE
							WHEN #RuleCriteria.FDB_MNID IS NULL AND #RuleCriteria.FDB_ClassID IS NULL THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							WHEN ViewCDSPatientMedicationNameOrClass.PersonUid = @PatientUid
								AND 
								(
									(
										(#RuleCriteria.FDB_MNID IS NOT NULL AND ViewCDSPatientMedicationNameOrClass.FDB_MNID = #RuleCriteria.FDB_MNID)
										OR (#RuleCriteria.FDB_ClassID IS NOT NULL AND ViewCDSPatientMedicationNameOrClass.FDB_ClassID = #RuleCriteria.FDB_ClassID)
									)
									AND (ViewCDSPatientMedicationNameOrClass.ActiveDate IS NOT NULL  AND ViewCDSPatientMedicationNameOrClass.ActiveDate <= @CurrentDate)
									AND (ViewCDSPatientMedicationNameOrClass.InactiveDate IS NULL  OR ViewCDSPatientMedicationNameOrClass.InactiveDate >= @CurrentDate)
									AND (ViewCDSPatientMedicationNameOrClass.OverallStartDate IS NOT NULL  AND ViewCDSPatientMedicationNameOrClass.OverallStartDate <= @CurrentDate)
									AND (ViewCDSPatientMedicationNameOrClass.OverallStopDate IS NULL  OR ViewCDSPatientMedicationNameOrClass.OverallStopDate >= @CurrentDate)
								)
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
								THEN 1
							ELSE 0
							END))
					AND
					(1 = (CASE
							WHEN #RuleCriteria.DrugAllergyQuestionUid IS NULL  THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							WHEN ViewCDSPatientDrugAllergy.PersonUid = @PatientUid
								AND ViewCDSPatientDrugAllergy.QuestionUid = #RuleCriteria.DrugAllergyQuestionUid 
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
								THEN 1
							ELSE 0
							END))
					AND
					(1 = (CASE
							WHEN #RuleCriteria.HasObservationCriteria < 1  THEN 1
							WHEN otc.Found > 0 THEN 1
							ELSE 0
							END))
							
			END  --  @InactivateNonRelevantPatientRules = @TRUE
			
		END  --  EXISTS ( SELECT TOP 1 * FROM #RuleCriteria )
							
	END   -- @PatientUid IS NOT NULL
	ELSE
	BEGIN

		--Process ALL patients
		IF EXISTS ( SELECT TOP 1 * FROM #RuleCriteria )
		BEGIN
		--For any patient, process the list of rules that have been selected		
			INSERT INTO   #NewRules   
				(
				HMRuleName,
				HMRuleUid,
				PatientName,
				PatientUid,
				IsDue,
				DueDate
				)
			SELECT DISTINCT 
				#RuleCriteria.HMRuleName,
				#RuleCriteria.HMRuleUid,
				Person.FirstName + ' ' + Person.LastName,
				Patient.PersonUid,		
				1,	
				CASE 
					WHEN PO.RelHMRulePatientOverrideUid IS NULL 
					THEN 
						CASE #RuleCriteria.AgeTimeTypeUid
							WHEN @Years THEN DATEADD(year,#RuleCriteria.AgeFrom,Person.BirthDate)
							WHEN @Months THEN DATEADD(month,#RuleCriteria.AgeFrom,Person.BirthDate)
							WHEN @Weeks THEN DATEADD(day,#RuleCriteria.AgeFrom * 7,Person.BirthDate)
							WHEN @Days THEN DATEADD(day,#RuleCriteria.AgeFrom,Person.BirthDate)
						END -- AS DueDate
					ELSE 
						CASE PO.AgeTimeTypeUid
							WHEN @Years THEN DATEADD(year,PO.AgeFrom,Person.BirthDate)
							WHEN @Months THEN DATEADD(month,PO.AgeFrom,Person.BirthDate)
							WHEN @Weeks THEN DATEADD(day,PO.AgeFrom * 7,Person.BirthDate)
							WHEN @Days THEN DATEADD(day,PO.AgeFrom,Person.BirthDate)
						END -- AS DueDate   
				END AS DueDate  
			FROM 
				Patient JOIN            
				Person ON 
					(Patient.Inactive  = 0 AND 
					Person.PersonUid = Patient.PersonUid AND 
					Person.DeathDate IS NULL) JOIN            
				#RuleCriteria ON 
					(Person.GenderUid = #RuleCriteria.GenderUid AND 
					Person.BirthDate 
						BETWEEN 
							#RuleCriteria.AgeToDate 
						AND 
							#RuleCriteria.AgeFromDate) LEFT JOIN       
				PatientHMRule ON 
					(PatientHMRule.HMRuleUid = #RuleCriteria.HMRuleUid AND 
					PatientHMRule.PatientUid = Patient.PersonUid AND 
					PatientHMRule.Inactive   = 0) LEFT JOIN       
				RelHMRulePatientOverride PO ON 
					(PO.PatientUid = Patient.PersonUid AND 
					PO.HMRuleUid = #RuleCriteria.HMRuleUid)  LEFT JOIN
				ViewCDSPatientDisease ON
					ViewCDSPatientDisease.PatientUid = Person.PersonUid  AND
					ViewCDSPatientDisease.DiseaseUid = #RuleCriteria.DiseaseUid  LEFT JOIN
				ViewCDSPatientMedicationNameOrClass ON
					ViewCDSPatientMedicationNameOrClass.PersonUid = Person.PersonUid  AND
					(ViewCDSPatientMedicationNameOrClass.FDB_MNID = #RuleCriteria.FDB_MNID  OR
					ViewCDSPatientMedicationNameOrClass.FDB_ClassID = #RuleCriteria.FDB_ClassID)  LEFT JOIN
				ViewCDSPatientDrugAllergy  ON
					ViewCDSPatientDrugAllergy.PersonUid = Person.PersonUid  AND
					ViewCDSPatientDrugAllergy.QuestionUid = #RuleCriteria.DrugAllergyQuestionUid    					
			WHERE           
				PatientHMRule.PatientHMRuleUid IS NULL AND
				Person.Birthdate 
					BETWEEN 
						CASE 
							WHEN PO.AgeTimeTypeUid IS NULL 
								THEN #RuleCriteria.AgeToDate
							WHEN PO.AgeTimeTypeUid = @Years  
								THEN DATEADD(day,1,DATEADD(year,-PO.AgeTo -1,@CurrentDate))
							WHEN PO.AgeTimeTypeUid = @Months 
								THEN DATEADD(day,1,DATEADD(month,-PO.AgeTo -1, @CurrentDate))
							WHEN PO.AgeTimeTypeUid = @Weeks  
								THEN DATEADD(day,1,DATEADD(day,(-PO.AgeTo -1) * 7, @CurrentDate))
							WHEN PO.AgeTimeTypeUid = @Days   
								THEN DATEADD(day, -PO.AgeTo, @CurrentDate)
						END 
					AND 
						CASE 
							WHEN PO.AgeTimeTypeUid IS NULL 
								THEN #RuleCriteria.AgeFromDate                                               
							WHEN PO.AgeTimeTypeUid = @Years  
								THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(year,-PO.AgeFrom,@CurrentDate)))
							WHEN PO.AgeTimeTypeUid = @Months 
								THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(month,-PO.AgeFrom, @CurrentDate)))
							WHEN PO.AgeTimeTypeUid = @Weeks  
								THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(day,-PO.AgeFrom * 7, @CurrentDate)))
							WHEN PO.AgeTimeTypeUid = @Days   
								THEN DATEADD(second,-1,DATEADD(day, -PO.AgeFrom+1, @CurrentDate))
						END
				AND
				(1 = 
					(CASE WHEN PO.Inactive IS NULL THEN 1  -- Override does not exist.  Therefore, PatientHMRule is not disabled.
						WHEN PO.Inactive = 1     THEN 0  -- Override does exist.  Inactive flag for override is TRUE.   PatientRule is disabled.
						WHEN PO.Inactive = 0     THEN 1  -- Override does exist.  Inactive flag for override is FALSE.  PatientRule is not disabled.
					END))  
				AND
				(1 = (CASE 
						WHEN #RuleCriteria.DiseaseUid IS NULL THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
						WHEN ViewCDSPatientDisease.PatientUid = Person.PersonUid
							AND ViewCDSPatientDisease.DiseaseUid = #RuleCriteria.DiseaseUid THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
						ELSE 0
						END))
				AND
				(1 = (CASE
						WHEN #RuleCriteria.FDB_MNID IS NULL AND #RuleCriteria.FDB_ClassID IS NULL THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
						WHEN ViewCDSPatientMedicationNameOrClass.PersonUid = Person.PersonUid
							AND 
							(
								(
									(#RuleCriteria.FDB_MNID IS NOT NULL AND ViewCDSPatientMedicationNameOrClass.FDB_MNID = #RuleCriteria.FDB_MNID)
									OR (#RuleCriteria.FDB_ClassID IS NOT NULL AND ViewCDSPatientMedicationNameOrClass.FDB_ClassID = #RuleCriteria.FDB_ClassID)
								)
								AND (ViewCDSPatientMedicationNameOrClass.ActiveDate IS NOT NULL  AND ViewCDSPatientMedicationNameOrClass.ActiveDate <= @CurrentDate)
								AND (ViewCDSPatientMedicationNameOrClass.InactiveDate IS NULL  OR ViewCDSPatientMedicationNameOrClass.InactiveDate >= @CurrentDate)
								AND (ViewCDSPatientMedicationNameOrClass.OverallStartDate IS NOT NULL  AND ViewCDSPatientMedicationNameOrClass.OverallStartDate <= @CurrentDate)
								AND (ViewCDSPatientMedicationNameOrClass.OverallStopDate IS NULL  OR ViewCDSPatientMedicationNameOrClass.OverallStopDate >= @CurrentDate)
							)
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							THEN 1
						ELSE 0
						END))
				AND
				(1 = (CASE
						WHEN #RuleCriteria.DrugAllergyQuestionUid IS NULL  THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
						WHEN ViewCDSPatientDrugAllergy.PersonUid = Person.PersonUid
							AND ViewCDSPatientDrugAllergy.QuestionUid = #RuleCriteria.DrugAllergyQuestionUid 
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							THEN 1
						ELSE 0
						END))
						
			IF @ShowDebug = 1
			BEGIN
				SELECT 'NewRUles'
				SELECT COUNT(*) FROM #NewRules
				SELECT * FROM #NewRules
			END

			--If any rules have observation tests, generate the dynamic sql to make those tests,
			--then run that sql for all patients

			insert into @tempPatientRuleTable(HMRuleUid, PatientUid)
			SELECT 
				DISTINCT #NewRules.HMRuleUid,
				#NewRules.PatientUid
			FROM 
				#RuleCriteria  JOIN
				#NewRules  ON	#NewRules.HMRuleUid = #RuleCriteria.HMRuleUid
			WHERE
				#RuleCriteria.HasObservationCriteria <> 0;

			while(exists(select top 1 * from @tempPatientRuleTable))
			begin
				select top 1 @tempPK=PK, @tempObsPatientUid=PatientUid, @tempObsHMRuleUid=HMRuleUid 
				from @tempPatientRuleTable

				SET @Answer = NULL
				EXEC [PatientHasQualifyingObservation] 
					@tempObsPatientUid, @tempObsHMRuleUid, @Result = @Answer OUTPUT;
						
				IF @Answer IS NOT NULL
				BEGIN
				--Create the dynamic sql to run the test, then exec it to load a count of
				--hits on the rule.  If the number is positive, the rule is fired.
					INSERT INTO @ObservationTestCount  ( Found, PatientUid, HMRuleUid )
					exec (@Answer)
				END

				delete @tempPatientRuleTable where PK=@tempPK
			end

			--If any patients had observations outside the range desired, remove the rules 
			IF EXISTS (SELECT TOP 1 * FROM @ObservationTestCount WHERE Found = 0 )
			BEGIN
				DELETE FROM #NewRules
					FROM #NewRules AS nr JOIN 
						@ObservationTestCount otc ON 
							nr.PatientUid = otc.PatientUid AND
							nr.HMRuleUid = otc.HMRuleUid 
					WHERE 
						otc.Found = 0
			END
			
			IF @ShowDebug = 1
			BEGIN
				SELECT 'NewRUles AFTER Observation Test Validation'
				SELECT * FROM @ObservationTestCount
				SELECT COUNT(*) FROM #NewRules
				SELECT * FROM #NewRules
			END
			
			--Now review all existing rules that have gone inactive to see if they should be reactivated
			UPDATE   PatientHMRule
			SET       
				IsDue = 1, 
				LastModifiedDate = GETUTCDATE()
			FROM      
				PatientHMRule  JOIN      
				#RuleCriteria ON 
					(#RuleCriteria.HMRuleUid = PatientHMRule.HMRuleUid  AND 
					PatientHMRule.IsDue    = 0  AND 
					PatientHMRule.Inactive = 0)  JOIN  
				Patient ON 
					(Patient.PersonUid = PatientHMRule.PatientUid  AND 
					Patient.Inactive = 0)  JOIN      
				Person ON 
					(Person.PersonUid = Patient.PersonUid  AND 
					Person.DeathDate IS NULL  AND 
					Person.GenderUid = #RuleCriteria.GenderUid)  LEFT JOIN 
				RelHMRulePatientOverride PO ON 
					(PO.PatientUid = Patient.PersonUid  AND 
					PO.HMRuleUid = PatientHMRule.HMRuleUid)  LEFT JOIN
				ViewCDSPatientDisease ON
					ViewCDSPatientDisease.PatientUid = Person.PersonUid  AND
					ViewCDSPatientDisease.DiseaseUid = #RuleCriteria.DiseaseUid  LEFT JOIN
				ViewCDSPatientMedicationNameOrClass ON
					ViewCDSPatientMedicationNameOrClass.PersonUid = Person.PersonUid  AND
					(ViewCDSPatientMedicationNameOrClass.FDB_MNID = #RuleCriteria.FDB_MNID  OR
					ViewCDSPatientMedicationNameOrClass.FDB_ClassID = #RuleCriteria.FDB_ClassID)  LEFT JOIN
				ViewCDSPatientDrugAllergy  ON
					ViewCDSPatientDrugAllergy.PersonUid = Person.PersonUid  AND
					ViewCDSPatientDrugAllergy.QuestionUid = #RuleCriteria.DrugAllergyQuestionUid  LEFT JOIN
				@ObservationTestCount otc  ON
					(otc.PatientUid = Patient.PersonUid  AND
					otc.HMRuleUid = #RuleCriteria.HMRuleUid)    
			WHERE     
				Person.Birthdate 
					BETWEEN 
						CASE 
							WHEN PO.AgeTimeTypeUid IS NULL THEN #RuleCriteria.AgeToDate
							WHEN PO.AgeTimeTypeUid = @Years  THEN DATEADD(day,1,DATEADD(year,-PO.AgeTo -1,@CurrentDate))
							WHEN PO.AgeTimeTypeUid = @Months THEN DATEADD(day,1,DATEADD(month,-PO.AgeTo -1, @CurrentDate))
							WHEN PO.AgeTimeTypeUid = @Weeks  THEN DATEADD(day,1,DATEADD(day,(-PO.AgeTo -1) * 7, @CurrentDate))
							WHEN PO.AgeTimeTypeUid = @Days   THEN DATEADD(day, -PO.AgeTo, @CurrentDate)
						END 
					AND 
						CASE 
							WHEN PO.AgeTimeTypeUid IS NULL THEN #RuleCriteria.AgeFromDate                        
							WHEN PO.AgeTimeTypeUid = @Years  THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(year,-PO.AgeFrom,@CurrentDate)))
							WHEN PO.AgeTimeTypeUid = @Months THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(month,-PO.AgeFrom, @CurrentDate)))
							WHEN PO.AgeTimeTypeUid = @Weeks  THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(day,-PO.AgeFrom * 7, @CurrentDate)))
							WHEN PO.AgeTimeTypeUid = @Days THEN DATEADD(second,-1,DATEADD(day, -PO.AgeFrom+1, @CurrentDate))
						END  
				AND       
                (@CurrentDate >= 
					CASE #RuleCriteria.AdvanceWarningTimeTypeUid
						WHEN @Years THEN DATEADD(year,-#RuleCriteria.AdvanceWarning,PatientHMRule.DueDate)
						WHEN @Months THEN DATEADD(month,-#RuleCriteria.AdvanceWarning, PatientHMRule.DueDate)
						WHEN @Weeks THEN DATEADD(day,-#RuleCriteria.AdvanceWarning * 7, PatientHMRule.DueDate)
						WHEN @Days THEN DATEADD(day, -#RuleCriteria.AdvanceWarning, PatientHMRule.DueDate)
					END)
				AND
				(1 = 
					(CASE
						WHEN PO.Inactive IS NULL THEN 1  -- Override does not exist.  Therefore, PatientHMRule is not disabled.
						WHEN PO.Inactive = 1     THEN 0  -- Override does exist.  Inactive flag for override is TRUE.   PatientRule is disabled.
						WHEN PO.Inactive = 0     THEN 1  -- Override does exist. Inactive flag for override is FALSE.  PatientRule is not disabled.
					END))
				AND
				(1 = (CASE 
						WHEN #RuleCriteria.DiseaseUid IS NULL THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
						WHEN ViewCDSPatientDisease.PatientUid = Person.PersonUid
							AND ViewCDSPatientDisease.DiseaseUid = #RuleCriteria.DiseaseUid
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							THEN 1
						ELSE 0
						END))
				AND
				(1 = (CASE
						WHEN #RuleCriteria.FDB_MNID IS NULL AND #RuleCriteria.FDB_ClassID IS NULL THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
						WHEN ViewCDSPatientMedicationNameOrClass.PersonUid = Person.PersonUid
							AND 
							(
								(
									(#RuleCriteria.FDB_MNID IS NOT NULL AND ViewCDSPatientMedicationNameOrClass.FDB_MNID = #RuleCriteria.FDB_MNID)
									OR (#RuleCriteria.FDB_ClassID IS NOT NULL AND ViewCDSPatientMedicationNameOrClass.FDB_ClassID = #RuleCriteria.FDB_ClassID)
								)
								AND (ViewCDSPatientMedicationNameOrClass.ActiveDate IS NOT NULL  AND ViewCDSPatientMedicationNameOrClass.ActiveDate <= @CurrentDate)
								AND (ViewCDSPatientMedicationNameOrClass.InactiveDate IS NULL  OR ViewCDSPatientMedicationNameOrClass.InactiveDate >= @CurrentDate)
								AND (ViewCDSPatientMedicationNameOrClass.OverallStartDate IS NOT NULL  AND ViewCDSPatientMedicationNameOrClass.OverallStartDate <= @CurrentDate)
								AND (ViewCDSPatientMedicationNameOrClass.OverallStopDate IS NULL  OR ViewCDSPatientMedicationNameOrClass.OverallStopDate >= @CurrentDate)
							)
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							THEN 1
						ELSE 0
						END))
				AND
				(1 = (CASE
						WHEN #RuleCriteria.DrugAllergyQuestionUid IS NULL  THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
						WHEN ViewCDSPatientDrugAllergy.PersonUid = Person.PersonUid
							AND ViewCDSPatientDrugAllergy.QuestionUid = #RuleCriteria.DrugAllergyQuestionUid 
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							THEN 1
						ELSE 0
						END))
				AND
				(1 = (CASE
						WHEN #RuleCriteria.HasObservationCriteria < 1  THEN 1
						WHEN otc.Found > 0 THEN 1
						ELSE 0
						END))
				
				--Find any rules that should be deactivated
				INSERT INTO #CurrentPatientRules 
					(PatientHMRuleUid)
				SELECT 
					PatientHMRule.PatientHMRuleUid
				FROM   
					Patient  JOIN 
					Person ON 
						(Person.PersonUid = Patient.PersonUid  AND 
						Patient.Inactive = 0  AND 
						Person.DeathDate IS NULL)  JOIN 
					#RuleCriteria ON 
						Person.GenderUid = #RuleCriteria.GenderUid   JOIN 
					PatientHMRule ON 
						(PatientHMRule.HMRuleUid = #RuleCriteria.HMRuleUid  AND 
						PatientHMRule.PatientUid = Patient.PersonUid  AND 
						PatientHMRule.Inactive = 0)  LEFT JOIN 
					RelHMRulePatientOverride PO ON 
						(PO.PatientUid = Patient.PersonUid  AND 
						PO.HMRuleUid = #RuleCriteria.HMRuleUid)  LEFT JOIN
					ViewCDSPatientDisease ON
						ViewCDSPatientDisease.PatientUid = Person.PersonUid  AND
						ViewCDSPatientDisease.DiseaseUid = #RuleCriteria.DiseaseUid  LEFT JOIN
					ViewCDSPatientMedicationNameOrClass ON
						ViewCDSPatientMedicationNameOrClass.PersonUid = Person.PersonUid  AND
						(ViewCDSPatientMedicationNameOrClass.FDB_MNID = #RuleCriteria.FDB_MNID  OR
						ViewCDSPatientMedicationNameOrClass.FDB_ClassID = #RuleCriteria.FDB_ClassID)  LEFT JOIN
					ViewCDSPatientDrugAllergy  ON
						ViewCDSPatientDrugAllergy.PersonUid = Person.PersonUid  AND
						ViewCDSPatientDrugAllergy.QuestionUid = #RuleCriteria.DrugAllergyQuestionUid  LEFT JOIN
					@ObservationTestCount otc  ON
						(otc.PatientUid = Patient.PersonUid  AND
						otc.HMRuleUid = #RuleCriteria.HMRuleUid)
				WHERE  
					Person.Birthdate 
						BETWEEN 
							CASE
								WHEN PO.AgeTimeTypeUid IS NULL THEN #RuleCriteria.AgeToDate
								WHEN PO.AgeTimeTypeUid = @Years  THEN DATEADD(day,1,DATEADD(year,-PO.AgeTo -1,@CurrentDate))
								WHEN PO.AgeTimeTypeUid = @Months THEN DATEADD(day,1,DATEADD(month,-PO.AgeTo -1, @CurrentDate))
								WHEN PO.AgeTimeTypeUid = @Weeks  THEN DATEADD(day,1,DATEADD(day,(-PO.AgeTo -1) * 7, @CurrentDate))
								WHEN PO.AgeTimeTypeUid = @Days   THEN DATEADD(day, -PO.AgeTo, @CurrentDate)
							END 
						AND     
							CASE 
								WHEN PO.AgeTimeTypeUid IS NULL THEN #RuleCriteria.AgeFromDate                     
								WHEN PO.AgeTimeTypeUid = @Years  THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(year,-PO.AgeFrom,@CurrentDate)))
								WHEN PO.AgeTimeTypeUid = @Months THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(month,-PO.AgeFrom, @CurrentDate)))
								WHEN PO.AgeTimeTypeUid = @Weeks  THEN DATEADD(second,-1,DATEADD(day,1,DATEADD(day,-PO.AgeFrom * 7, @CurrentDate)))
								WHEN PO.AgeTimeTypeUid = @Days   THEN DATEADD(second,-1,DATEADD(day, -PO.AgeFrom+1, @CurrentDate))
							END 
					AND         
					(1 = 
						(CASE 
							WHEN PO.Inactive IS NULL THEN 1 -- Override does not exist.  Therefore, PatientHMRule is not disabled.
							WHEN PO.Inactive = 1 THEN 0  -- Override does exist. Inactive flag for override is TRUE.   PatientRule is disabled.
							WHEN PO.Inactive = 0  THEN 1  -- Override does exist. Inactive flag for override is FALSE. PatientRule is not disabled.
						END))
					AND
					(1 = (CASE 
							WHEN #RuleCriteria.DiseaseUid IS NULL THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							WHEN ViewCDSPatientDisease.PatientUid = Person.PersonUid
								AND ViewCDSPatientDisease.DiseaseUid = #RuleCriteria.DiseaseUid
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
								THEN 1
							ELSE 0
						END))
					AND
					(1 = (CASE
							WHEN #RuleCriteria.FDB_MNID IS NULL AND #RuleCriteria.FDB_ClassID IS NULL THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							WHEN ViewCDSPatientMedicationNameOrClass.PersonUid = Person.PersonUid
								AND 
								(
									(
										(#RuleCriteria.FDB_MNID IS NOT NULL AND ViewCDSPatientMedicationNameOrClass.FDB_MNID = #RuleCriteria.FDB_MNID)
										OR (#RuleCriteria.FDB_ClassID IS NOT NULL AND ViewCDSPatientMedicationNameOrClass.FDB_ClassID = #RuleCriteria.FDB_ClassID)
									)
									AND (ViewCDSPatientMedicationNameOrClass.ActiveDate IS NOT NULL  AND ViewCDSPatientMedicationNameOrClass.ActiveDate <= @CurrentDate)
									AND (ViewCDSPatientMedicationNameOrClass.InactiveDate IS NULL  OR ViewCDSPatientMedicationNameOrClass.InactiveDate >= @CurrentDate)
									AND (ViewCDSPatientMedicationNameOrClass.OverallStartDate IS NOT NULL  AND ViewCDSPatientMedicationNameOrClass.OverallStartDate <= @CurrentDate)
									AND	(ViewCDSPatientMedicationNameOrClass.OverallStopDate IS NULL  OR ViewCDSPatientMedicationNameOrClass.OverallStopDate >= @CurrentDate)
								)
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
								THEN 1
							ELSE 0
						END))
					AND
					(1 = (CASE
							WHEN #RuleCriteria.DrugAllergyQuestionUid IS NULL  THEN 1
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
							WHEN ViewCDSPatientDrugAllergy.PersonUid = Person.PersonUid
								AND ViewCDSPatientDrugAllergy.QuestionUid = #RuleCriteria.DrugAllergyQuestionUid 
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
								THEN 1
							ELSE 0
							END))
					AND
					(1 = (CASE
							WHEN #RuleCriteria.HasObservationCriteria < 1  THEN 1
							WHEN otc.Found > 0 THEN 1
							ELSE 0
							END))


								                                              
		END  --  EXISTS ( SELECT TOP 1 * FROM #RuleCriteria )
	END   -- @PatientUid IS  NULL
	

	IF @ShowDebug = 1
	BEGIN
		SELECT '#CurrentPatientRules'
		SELECT COUNT(*) FROM #CurrentPatientRules
		SELECT * FROM #CurrentPatientRules
	END

/************************************************************************************************/
/************************************************************************************************/
/* Insert the Selected Rules and clean up the temp tables										*/
/************************************************************************************************/
/************************************************************************************************/

	IF EXISTS ( SELECT TOP 1 * FROM #NewRules)
	BEGIN
	
/* Adjust the DueDate for CurrentDate															*/
/************************************************************************************************/
		UPDATE 	#NewRules
		SET 	    
			DueDate = @CurrentDate
		WHERE 	
			DueDate < @CurrentDate

/* Calculate the PastDueDate 																	*/
/************************************************************************************************/
		UPDATE #NewRules
		SET 
			PastDueDate = 
				CASE RecurTimeTypeUid
					WHEN @Years THEN DATEADD(year,RecurTo - RecurFrom,DueDate)
					WHEN @Months THEN DATEADD(month,RecurTo - RecurFrom,DueDate)
					WHEN @Weeks THEN DATEADD(day,(RecurTo - RecurFrom) * 7,DueDate)
					WHEN @Days THEN DATEADD(day,RecurTo - RecurFrom,DueDate)
				END -- AS PastDueDate
		FROM 
			#NewRules   JOIN 
			ListHMRule ON 
				ListHMRule.HMRuleUid = #NewRules.HMRuleUid


/* If recurring rule and max recurrences has been reached, then don't readd the rule */
/* Fix for TFS Bug #16606.                                                           */
/*************************************************************************************/   
		DELETE FROM #NewRules 
		WHERE 
			EXISTS 
				(SELECT 
					* 
				FROM   
					ListHMRule 
				WHERE  
					ListHMRule.HMRuleUid = #NewRules.HMRuleUid   AND 
					(
						(ListHMRule.LimitRecurrences = 1  AND 
							(SELECT	COUNT(*)    
								FROM   
									PatientHMRule   INNER JOIN 
									PatientHMRuleDetail ON 
										PatientHMRuleDetail.PatientHMRuleUid = PatientHMRule.PatientHMRuleUid
								WHERE  
									PatientHMRule.PatientUid = #NewRules.PatientUid   AND 
									PatientHMRule.HMRuleUid = #NewRules.HMRuleUid
							) >= ListHMRule.MaxRecurrence
						)  OR
						(ListHMRule.RecurFrom = 0 AND ListHMRule.RecurTo = 0  -- this is a one time rule
							AND EXISTS (SELECT *            
										FROM   PatientHMRule 
										WHERE  PatientHMRule.PatientUid = #NewRules.PatientUid 
											   AND PatientHMRule.HMRuleUid = #NewRules.HMRuleUid 
											   AND PatientHMRule.Inactive = 1   -- one time rule is inactive
											   AND PatientHMRule.IsDue = 0)      -- one time rule is not due
						) 
					) 
				)

/* Bug #10552 - HMR Rule pop-up based on actioning a recurring rule should not occur. */
/* Determine how many patient rules are being readded.                          */
		DECLARE @NumRulesBeingReAdded int 
		SET @NumRulesBeingReAdded = 0

		IF @PatientUid IS NOT NULL
		BEGIN
		
			SET @NumRulesBeingReAdded = 
				(SELECT 
					COUNT(*) 
				FROM  
					PatientHMRule phmr INNER JOIN 
					#NewRules nr ON  
						(phmr.HMRuleUid  = nr.HMRuleUid   AND 
						phmr.PatientUid = nr.PatientUid  AND 
						phmr.Inactive   = 1))

			IF @NumRulesBeingReAdded IS NULL
			BEGIN
			SET @NumRulesBeingReAdded = 0
			END   
			
		END   --@PatientUid IS NOT NULL

/* Insert the New Rules 																		*/
/************************************************************************************************/
		INSERT INTO [PatientHMRule]
		(
			[HMRuleUid],
			[PatientUid],
			[IsDue],
			[DueDate],
			[PastDueDate]
		)
		SELECT
			vphmr.[HMRuleUid],
			vphmr.[PatientUid],
			vphmr.[IsDue],
			DATEADD(n, @Mins, vphmr.[DueDate]),
			DATEADD(n, @Mins, vphmr.[PastDueDate])
		FROM #NewRules AS  vphmr
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group
			LEFT OUTER JOIN [PatientHMRule] AS phmr ON vphmr.[HMRuleUid] = phmr.[HMRuleUid]
				AND vphmr.[PatientUid] = phmr.[PatientUid]
				AND vphmr.[IsDue] = phmr.[IsDue]
				AND phmr.[Inactive] = 0
		WHERE phmr.[PatientHMRuleUid] IS NULL
--	Bug 52651 - Daily Maintenance not running causes the log to fill up and end up having to break the availability group

/* Increment the Rule Count 																	*/
/**********************************************************************************************/
		SET @RuleCount = @@RowCount - @NumRulesBeingReAdded
		
	END  --EXISTS ( SELECT TOP 1 * FROM #NewRules)


-- =====================================================================================================================
-- Do not include any HM Rules that only display an alert popup message.  Alert popup messages are display on demand.
-- IF HMRuleUid is not in RelHMRuleProcedure,
--   THEN no procedure to complete is associated with the HM rule - therefore, rule only displays an alert message. 
-- =====================================================================================================================
	DECLARE @HMRuleToDelete_TBL TABLE
	(
		[HMRuleUid] [uniqueidentifier] primary key
	)

    IF @PatientUid IS NOT NULL
    BEGIN
		INSERT @HMRuleToDelete_TBL
		SELECT DISTINCT rhmrp.[HMRuleUid]
		FROM [RelHMRuleProcedure] AS rhmrp with(nolock)
			INNER JOIN [PatientHMRule] as phmr with(nolock) on rhmrp.[HMRuleUid] = phmr.[HMRuleUid]
		WHERE phmr.[PatientUid] = @PatientUid
    END
    ELSE
    BEGIN
		INSERT @HMRuleToDelete_TBL
		SELECT DISTINCT [HMRuleUid]
		FROM [RelHMRuleProcedure] with(nolock)
	END

	IF EXISTS(
		SELECT TOP 1 *
		FROM @HMRuleToDelete_TBL
	)
	BEGIN
		IF @PatientUid IS NOT NULL
		BEGIN
			DELETE FROM [PatientHMRule] 
			WHERE [PatientUid] = @PatientUid
				AND [HMRuleUid] NOT IN ( SELECT [HMRuleUid] FROM @HMRuleToDelete_TBL )
		END
		ELSE
		BEGIN
			DELETE FROM [PatientHMRule] 
			WHERE [HMRuleUid] NOT IN ( SELECT [HMRuleUid] FROM @HMRuleToDelete_TBL )
		END
	END

	IF @ShowDebug = 1
	BEGIN
		SELECT '@InactivateNonRelevantPatientRules'
		SELECT @InactivateNonRelevantPatientRules
	END

-- ===================================================
-- Inactivate patient rules that no long meet criteria
-- ===================================================
	IF @InactivateNonRelevantPatientRules = @TRUE
	BEGIN
		
		IF @ShowDebug = 1
		BEGIN
			SELECT '@InactivateNonRelevantPatientRules = @TRUE'
		END
	
		IF EXISTS (SELECT TOP 1 * FROM #NonRelevantPatientRules)
		BEGIN
		
			IF @ShowDebug = 1
			BEGIN
				SELECT 'EXISTS (SELECT TOP 1 * FROM #NonRelevantPatientRules)'
			END
		
			IF EXISTS (SELECT TOP 1 * FROM #CurrentPatientRules)
			BEGIN
			
				IF @ShowDebug = 1
				BEGIN
					SELECT '#NonRelevantPatientRules 1'
				END
-- Take initial list of patient rules and remove current list of patient rules.
-- Remaining list should be patient rules that no longer meet the criteria.
				DELETE FROM #NonRelevantPatientRules 
				WHERE 
					PatientHMRuleUid IN 
						(SELECT DISTINCT(PatientHMRuleUid) FROM #CurrentPatientRules)
			END   --EXISTS (SELECT TOP 1 * FROM #CurrentPatientRules)

-- Check if there are any patient rules that no longer meet patient rule criteria.
			IF EXISTS (SELECT TOP 1 * FROM #NonRelevantPatientRules)
			BEGIN
				IF @ShowDebug = 1
				BEGIN
					SELECT '#NonRelevantPatientRules 2'
				END
			
				DECLARE @DeleteIncompleteIsDueMsgs BIT      
				SET @DeleteIncompleteIsDueMsgs = 
					(SELECT TOP 1 HMRulesDeleteNonRelevantIsDueMessages FROM PracticeSettings)  

				DECLARE @CompleteIncompleteIsDueMsgs BIT
				SELECT @CompleteIncompleteIsDueMsgs = 
					(SELECT TOP 1 HMRulesCompleteNonRelevantIsDueMessages FROM PracticeSettings)   

				DECLARE @CompletedByUid UNIQUEIDENTIFIER
				SET @CompletedByUid = 
					(SELECT TOP 1 HMRulesCompletedByUid FROM PracticeSettings) 

				IF @DeleteIncompleteIsDueMsgs = @TRUE
				BEGIN
					IF @ShowDebug = 1
					BEGIN
						SELECT '#NonRelevantPatientRules 3'
					END
				
-- Delete any incomplete HMRuleIsDueAlert messages that are associated to patient rules that no longer meet rule criteria.  
-- Db trigger will delete MessageUser and MessageTask rows.
					DELETE FROM Message 
					WHERE 
						MessageUid IN 
							(SELECT DISTINCT 
								msg.MessageUid 
							FROM   
								#NonRelevantPatientRules nrpr   JOIN 
								MessageTask mt ON 
									mt.PatientHMRuleUid = nrpr.PatientHMRuleUid  	JOIN 
									Message msg ON 
										msg.MessageUid = mt.MessageUid 
							WHERE  
								mt.PatientHMRuleUid IS NOT NULL   AND 
								msg.CompletedByUid IS NULL   AND 
								msg.DateCompleted IS NULL) 
								
				END     --@DeleteIncompleteIsDueMsgs = @TRUE
				ELSE 
				BEGIN  
					IF @ShowDebug = 1
					BEGIN
						SELECT '#NonRelevantPatientRules 4'
					END
				
-- Complete any incomplete HMRuleIsDueAlert messages that are associated to patient rules that no longer meet rule criteria.

					IF @CompleteIncompleteIsDueMsgs = @TRUE   AND 
						@CompletedByUid IS NOT NULL   AND 
						@CompletedByUid <> CAST('00000000-0000-0000-0000-000000000000' AS UNIQUEIDENTIFIER)
					BEGIN     
					
						UPDATE Message 
						SET 
							CompletedByUid = @CompletedByUid, 
							DateCompleted = GETUTCDATE()
						WHERE 
							MessageUid IN 
								(SELECT DISTINCT 
									msg.MessageUid 
								FROM   
									#NonRelevantPatientRules nrpr   JOIN 
									MessageTask mt ON 
										mt.PatientHMRuleUid = nrpr.PatientHMRuleUid  JOIN 
									Message msg ON 
										msg.MessageUid = mt.MessageUid 
								WHERE  
									mt.PatientHMRuleUid IS NOT NULL   AND 
									msg.CompletedByUid IS NULL   AND 
									msg.DateCompleted IS NULL)
									
					END       --complex test starting @CompleteIncompleteIsDueMsgs = @TRUE   AND 
					
				END   --  NOT  @DeleteIncompleteIsDueMsgs = @TRUE

				IF @ShowDebug = 1
				BEGIN
					SELECT '#NonRelevantPatientRules 5'
				END
-- Delete any patient rules that no longer meet criteria and have no PatientHMRuleDetail and MessageTask rows.
				DELETE FROM PatientHMRule 
				WHERE 
					PatientHMRule.PatientHMRuleUid IN 
						(SELECT DISTINCT 
							nrpr.PatientHMRuleUid
						FROM   
							#NonRelevantPatientRules nrpr   LEFT JOIN 
							MessageTask mt ON 
								mt.PatientHMRuleUid = nrpr.PatientHMRuleUid  LEFT JOIN 
							PatientHMRuleDetail phmrd ON 
								phmrd.PatientHMRuleUid = nrpr.PatientHMRuleUid
						WHERE  
							mt.PatientHMRuleUid IS NULL   AND 
							phmrd.PatientHMRuleUid IS NULL)

-- Inactivate remaining patient rules that no longer meet criteria.
--   These patient rules probable have PatientHMRuleDetail and/or MessageTask rows. 
				UPDATE   PatientHMRule 
				SET 
					Inactive = @TRUE, 
					LastModifiedDate = GETUTCDATE()
				WHERE 
					PatientHMRuleUid IN 
						(SELECT DISTINCT 
							nrpr.PatientHMRuleUid 
						FROM   
							#NonRelevantPatientRules nrpr   LEFT JOIN 
							MessageTask mt ON 
								mt.PatientHMRuleUid = nrpr.PatientHMRuleUid  LEFT JOIN 
							PatientHMRuleDetail phmrd ON 
								phmrd.PatientHMRuleUid = nrpr.PatientHMRuleUid                                     
						WHERE  
							mt.PatientHMRuleUid IS NOT NULL   OR 
							phmrd.PatientHMRuleUid IS NOT NULL) 
					AND Inactive != @TRUE
					
			END   -- EXISTS (SELECT TOP 1 * FROM #CurrentPatientRules)
			
		END -- EXISTS (SELECT TOP 1 * FROM #NonRelevantPatientRules)
		
	END -- IF @InactivateNonRelevantPatientRules = @TRUE

	COMMIT TRAN

	DROP TABLE #RuleCriteria
	DROP TABLE #NewRules
	DROP TABLE #NonRelevantPatientRules
	DROP TABLE #CurrentPatientRules

/* RETURN the Rule Count 																		*/
/************************************************************************************************/
	IF @PatientUid IS NOT NULL
	BEGIN
	  SELECT @RuleCount
	END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AppointmentTelehealthPatient_SyncLastModified]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AppointmentTelehealthPatient_SyncLastModified] AS' 
END
GO
ALTER proc [dbo].[AppointmentTelehealthPatient_SyncLastModified] @columnToSync varchar(50), @appointmentUid uniqueidentifier
as
begin
	declare @sql nvarchar(4000)
	
	select @sql = 'update appointment set ' + @columnToSync + ' = LastModifiedDate where AppointmentUid = ''' + convert(varchar(50), @appointmentuid) + ''''

	exec sp_executesql @sql
end


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ApptTelehealthParticipant_GetUpdatedAppointments]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ApptTelehealthParticipant_GetUpdatedAppointments] AS' 
END
GO
ALTER proc [dbo].[ApptTelehealthParticipant_GetUpdatedAppointments]
as
begin
	begin try
		drop table #tempParticipants
	end try
	begin catch
	end catch

	declare @cutoffdate datetime --only look at last 24 hours of appts to avoid query being too large
	select @cutoffdate = dateadd(hour, -24, getutcdate())

	declare @maxEmailSendAttempts int = 3
	declare @maxSMSSendAttempts int = 3

	;with RecentlyModifiedAppointments as
	(
		select *
		from Appointment a with(nolock)
		where a.LastModifiedDate > @cutoffdate
	)
	select p.* into #tempParticipants
	from AppointmentTelehealthParticipant p with(nolock)
	join RecentlyModifiedAppointments a with(nolock) on p.AppointmentUid = a.AppointmentUid
	join ListAppointmentStatus s with(nolock) on a.AppointmentStatusUid = s.AppointmentStatusUid
	join ListRoom r with(nolock) on a.RoomUid = r.RoomUid
	where ((p.ApptUpdateEmailLastModifiedDate < a.LastModifiedDate and p.ApptUpdateEmailSendAttempts < @maxEmailSendAttempts)
			or
			(p.ApptUpdateSMSLastModifiedDate < a.LastModifiedDate and p.ApptUpdateSMSSendAttempts < @maxSMSSendAttempts))
		and s.IsCanceledStatus = 0 --not canceled
		and r.RoomType = 2 --video room
		and p.IsUninvited = 0

	select 'AppointmentTelehealthParticipant'
	select * from #tempParticipants

	select 'Appointment'
	select *
	from Appointment a 
	where a.AppointmentUid in (select AppointmentUid from #tempParticipants)

	drop table #tempParticipants
end


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ApptTelehealthPatient_GetUpdatedAppointments]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ApptTelehealthPatient_GetUpdatedAppointments] AS' 
END
GO
ALTER proc [dbo].[ApptTelehealthPatient_GetUpdatedAppointments]
as
begin
	begin try
		drop table #tempAppts
	end try
	begin catch
	end catch

	declare @cutoffdate datetime --only look at last 24 hours of appts to avoid query being too large
	select @cutoffdate = dateadd(hour, -24, getutcdate())

	declare @maxEmailSendAttempts int = 3
	declare @maxSMSSendAttempts int = 3

	;with RecentlyModifiedAppointments as
	(
		select a.AppointmentUid
		from Appointment a with(nolock)
		where a.LastModifiedDate > @cutoffdate
	)
	select rm.* into #tempAppts
	from RecentlyModifiedAppointments rm with(nolock)
	join Appointment a on rm.AppointmentUid = a.AppointmentUid
	join ListAppointmentStatus s with(nolock) on a.AppointmentStatusUid = s.AppointmentStatusUid
	join ListRoom r with(nolock) on a.RoomUid = r.RoomUid
	where ((a.TelehealthApptUpdateEmailLastModifiedDate < a.LastModifiedDate and a.TelehealthApptUpdateEmailSendAttempts < @maxEmailSendAttempts)
			or
			(a.TelehealthApptUpdateSMSLastModifiedDate < a.TelehealthApptUpdateSMSLastModifiedDate and a.TelehealthApptUpdateSMSSendAttempts < @maxSMSSendAttempts))
		-- and s.IsCanceledStatus = 0 --not canceled --returned canceled appts in query so that we can send cancel notifications
		and r.RoomType = 2 --video room

	select 'Appointment'
	select a.* 
		from #tempAppts t
		join Appointment a on t.AppointmentUid = a.AppointmentUid

	drop table #tempAppts
end


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RemoveDuplicateExternalID]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[RemoveDuplicateExternalID] AS' 
END
GO
ALTER PROC [dbo].[RemoveDuplicateExternalID]
@TableName	varchar(50)
AS

BEGIN
	DECLARE @SqlString nvarchar(1000)

	SET @SqlString = N'
	DECLARE @ExtID int

	DECLARE csrExternalID CURSOR DYNAMIC FOR 
	  SELECT ExternalID FROM [' + @TableName + ']
		WHERE ExternalID in 
		  (SELECT ExternalID FROM [' + @TableName + '] GROUP BY ExternalID HAVING COUNT(*) > 1) OR ExternalID is null
	FOR UPDATE

	OPEN csrExternalID
	FETCH NEXT FROM csrExternalID

	WHILE @@FETCH_STATUS = 0
	BEGIN
	  EXEC @ExtID = GetUniqueID ''' + @TableName + '''
	  UPDATE [' + @TableName + '] SET ExternalID = @ExtID WHERE CURRENT OF csrExternalID
	  FETCH NEXT FROM csrExternalID
	END

	CLOSE csrExternalID
	DEALLOCATE csrExternalID'

	EXECUTE sp_executesql @SqlString
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_AddMissingRPsAndAccounts]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_AddMissingRPsAndAccounts] AS' 
END
GO
ALTER PROC [dbo].[AR_AddMissingRPsAndAccounts]
AS

-- Add missing RPs and accounts as needed. Useful after incomplete migrations or HL7 inserts.
set nocount on
declare @ext int
select top 1 @ext = Seedvalue from SeedTable where SeedName = 'Account'
set @ext = coalesce(1 + @ext, 1)

insert into AccountResponsibleParty(PersonUid)
select PersonUid from Person 
where PersonUid not in (select PersonUid from Account WITH (NOLOCK)) 
and PersonUid not in (select PersonUid from AccountResponsibleParty WITH (NOLOCK) where PersonUid is not null)

insert into Account(Name, ExternalID, PersonUid, AccountResponsiblePartyUid, IsMain, ResponsiblePartyRelationshipUid)
select 'Main', @ext, PersonUid, AccountResponsiblePartyUid, 1, '7B4C63C7-FE13-48EF-81E5-3AFC963F3FEE' from AccountResponsibleParty 
where PersonUid is not null and PersonUid not in (select PersonUid from Account WITH (NOLOCK))

insert into AccountPeriod(AccountUid)
select AccountUid from Account 
where AccountUid not in (select AccountUid from AccountPeriod WITH (NOLOCK))

exec RemoveDuplicateExternalID 'Account'
exec RemoveDuplicateExternalID 'AccountResponsibleParty'

-- set RP relationship to self when misset
update Account set ResponsiblePartyRelationshipUid = '7B4C63C7-FE13-48EF-81E5-3AFC963F3FEE' 
from AccountResponsibleParty 
where Account.AccountResponsiblePartyUid = AccountResponsibleParty.AccountResponsiblePartyUid 
and (Account.ResponsiblePartyRelationshipUid is null or Account.ResponsiblePartyRelationshipUid != '7B4C63C7-FE13-48EF-81E5-3AFC963F3FEE')
and Account.PersonUid = AccountResponsibleParty.PersonUid

--set RP relationship to unknown when misset to self
update Account set ResponsiblePartyRelationshipUid = '11EADEE6-52DC-4FE1-BFD4-E1C03ABAAA51' 
from AccountResponsibleParty 
where Account.AccountResponsiblePartyUid = AccountResponsibleParty.AccountResponsiblePartyUid
and Account.ResponsiblePartyRelationshipUid = '7B4C63C7-FE13-48EF-81E5-3AFC963F3FEE'
and Account.PersonUid != AccountResponsibleParty.PersonUid


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ResetAccountInsuranceDisplayOrder]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ResetAccountInsuranceDisplayOrder] AS' 
END
GO
ALTER PROCEDURE [dbo].[ResetAccountInsuranceDisplayOrder]
	@accountUid uniqueidentifier = null 
AS
BEGIN
	-- SET NOCOUNT ON added to prevent extra result sets from
	-- interfering with SELECT statements.
	SET NOCOUNT ON;

	-- This 'trick' is used in ControlAccount to deal with some save issues in the Display Orders 
	-- Do not remember details but is needed for way implemented in past
	-- Bug 33960 Updated 
	-- Also related to past CASE Case # 00187841
	-- 2014-12-02 BMR
	
	IF (@accountUid IS NULL) -- keeping old implementation but should not be called this way any longer -- bug 33960
		BEGIN
			UPDATE AccountInsurance SET DisplayOrder = DisplayOrder - 100
				WHERE DisplayOrder > 100;
		END
	ELSE
		BEGIN
			UPDATE AccountInsurance 
				SET AccountInsurance.DisplayOrder = AccountInsurance.DisplayOrder - 100
				FROM AccountInsurance 
					INNER JOIN AccountPeriod ON AccountInsurance.AccountPeriodUid = AccountPeriod.AccountPeriodUid
				WHERE AccountPeriod.AccountUid = @accountUid
					AND AccountInsurance.DisplayOrder > 100;
		END

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_AuditAccountPeriods]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_AuditAccountPeriods] AS' 
END
GO
ALTER PROC [dbo].[AR_AuditAccountPeriods]
	@AccountUid uniqueidentifier = null 
AS

	-- first, fix up display orders
	-- see notes in ResetAccountInsuranceDisplayOrder for details
	EXEC ResetAccountInsuranceDisplayOrder @accountUid = @AccountUid; -- this audit gets called by ControlAccount

--Audits the specified account, or all if not specified
	if @AccountUid is NULL
	begin

		--Any dupe or missing main accounts for persons with accounts?
		if exists(select PersonUid from Account where IsMain = 1 group by PersonUid having count(*) > 1)
			begin
				RAISERROR('There are persons with multiple main accounts', 16, 1)
				return
			end

		if exists(select PersonUid from Account where PersonUid not in (select a2.PersonUid from Account a2 where a2.IsMain = 1))
			begin
				RAISERROR('There are persons without main accounts', 16, 1)
				return
			end

		--Any out of order effective date and termination date?
		if exists(select * from AccountPeriod where EffectiveDate is not null and ExpirationDate is not null and EffectiveDate > ExpirationDate)
			begin
				RAISERROR('There is an invalid account period with effective date after its expiration date', 16, 1)
				return
			end

		--Any overlapping account periods?
		if exists(select * from AccountPeriod ap1, AccountPeriod ap2 where ap1.AccountUid = ap2.AccountUid and ap1.AccountPeriodUid != ap2.AccountPeriodUid and ((ap1.EffectiveDate is null and ap2.EffectiveDate is null) or (ap1.EffectiveDate is not null and ap2.EffectiveDate is not null and ap1.EffectiveDate = ap2.EffectiveDate)))
			begin
				RAISERROR('There are invalid overlapping account periods (duplicate effective dates)', 16, 1)
				return
			end
		if exists(select * from AccountPeriod ap1, AccountPeriod ap2 where ap1.AccountUid = ap2.AccountUid and ap1.AccountPeriodUid != ap2.AccountPeriodUid and ap2.EffectiveDate is not null and (ap1.EffectiveDate is null or ap1.EffectiveDate < ap2.EffectiveDate) and (ap1.ExpirationDate is null or dateadd(dd, 1, ap1.ExpirationDate) > ap2.EffectiveDate))
			begin
				RAISERROR('There are invalid overlapping account periods', 16, 1)
				return
			end

		--Any bad insurance orders?
		if exists(select * from AccountInsurance ai, AccountPeriod ap where ai.AccountPeriodUid = ap.AccountPeriodUid and ai.DisplayOrder < 1)
			begin
				RAISERROR('There is an invalid insurance order', 16, 1)
				return
			end
		if exists(select * from AccountInsurance ai1, AccountInsurance ai2, AccountPeriod ap where ai1.AccountPeriodUid = ap.AccountPeriodUid and ai2.AccountPeriodUid = ap.AccountPeriodUid and ai1.AccountInsuranceUid != ai2.AccountInsuranceUid and ai1.DisplayOrder = ai2.DisplayOrder)
			begin
				RAISERROR('There are duplicate insurance orders', 16, 1)
				return
			end
		if exists(select * from AccountInsurance ai1, AccountPeriod ap where ai1.AccountPeriodUid = ap.AccountPeriodUid and ai1.DisplayOrder > 1 and not exists(select * from AccountInsurance ai2 where ai2.AccountPeriodUid = ai1.AccountPeriodUid and ai2.DisplayOrder = (ai1.DisplayOrder - 1)))
			begin
				RAISERROR('There are missing insurance orders', 16, 1)
				return
			end
	end
	else --we have an accountuid
	begin

		--Any dupe or missing main accounts for persons with accounts?
		if exists(select PersonUid from Account where (AccountUid = @AccountUid) and IsMain = 1 group by PersonUid having count(*) > 1)
			begin
				RAISERROR('There are persons with multiple main accounts', 16, 1)
				return
			end

		if exists(select PersonUid from Account where (AccountUid = @AccountUid) and PersonUid not in (select a2.PersonUid from Account a2 where a2.IsMain = 1))
			begin
				RAISERROR('There are persons without main accounts', 16, 1)
				return
			end

		--Any out of order effective date and termination date?
		if exists(select * from AccountPeriod where (AccountUid = @AccountUid) and EffectiveDate is not null and ExpirationDate is not null and EffectiveDate > ExpirationDate)
			begin
				RAISERROR('There is an invalid account period with effective date after its expiration date', 16, 1)
				return
			end

		--Any overlapping account periods?
		if exists(select * from AccountPeriod ap1, AccountPeriod ap2 where (ap1.AccountUid = @AccountUid) and ap1.AccountUid = ap2.AccountUid and ap1.AccountPeriodUid != ap2.AccountPeriodUid and ((ap1.EffectiveDate is null and ap2.EffectiveDate is null) or (ap1.EffectiveDate is not null and ap2.EffectiveDate is not null and ap1.EffectiveDate = ap2.EffectiveDate)))
			begin
				RAISERROR('There are invalid overlapping account periods (duplicate effective dates)', 16, 1)
				return
			end
		if exists(select * from AccountPeriod ap1, AccountPeriod ap2 where (ap1.AccountUid = @AccountUid) and ap1.AccountUid = ap2.AccountUid and ap1.AccountPeriodUid != ap2.AccountPeriodUid and ap2.EffectiveDate is not null and (ap1.EffectiveDate is null or ap1.EffectiveDate < ap2.EffectiveDate) and (ap1.ExpirationDate is null or dateadd(dd, 1, ap1.ExpirationDate) > ap2.EffectiveDate))
			begin
				RAISERROR('There are invalid overlapping account periods', 16, 1)
				return
			end

		--Any bad insurance orders?
		if exists(select * from AccountInsurance ai, AccountPeriod ap where (ap.AccountUid = @AccountUid) and ai.AccountPeriodUid = ap.AccountPeriodUid and ai.DisplayOrder < 1)
			begin
				RAISERROR('There is an invalid insurance order', 16, 1)
				return
			end
		if exists(select * from AccountInsurance ai1, AccountInsurance ai2, AccountPeriod ap where (ap.AccountUid = @AccountUid) and ai1.AccountPeriodUid = ap.AccountPeriodUid and ai2.AccountPeriodUid = ap.AccountPeriodUid and ai1.AccountInsuranceUid != ai2.AccountInsuranceUid and ai1.DisplayOrder = ai2.DisplayOrder)
			begin
				RAISERROR('There are duplicate insurance orders', 16, 1)
				return
			end
		if exists(select * from AccountInsurance ai1, AccountPeriod ap where (ap.AccountUid = @AccountUid) and ai1.AccountPeriodUid = ap.AccountPeriodUid and ai1.DisplayOrder > 1 and not exists(select * from AccountInsurance ai2 where ai2.AccountPeriodUid = ai1.AccountPeriodUid and ai2.DisplayOrder = (ai1.DisplayOrder - 1)))
			begin
				RAISERROR('There are missing insurance orders', 16, 1)
				return
			end
	end


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_AuditAggregates]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_AuditAggregates] AS' 
END
GO
ALTER PROCEDURE [dbo].[AR_AuditAggregates]      
   
AS    

/*
	Using this SP to test the financials for consistancy ... 
	For each block added, document what it tests for, what the startup state should be and what the ending state is expected to be
*/  


/*
	This was an issue in MHUC
	BMR 20120822 - Added after found issue on site
*/
select distinct sb.ExternalID, CASE WHEN ISNULL(l.VoidLedgerUid, los.LedgerUid) IS NULL THEN 0 ELSE 1 END AS Voided
	--into #temp_MismatchedInsurancePlans
	from AR_LedgerDetail ld
		inner join AR_Ledger l on ld.LedgerUid = l.LedgerUid
		left join AR_Ledger los on l.LedgerUid = los.VoidLedgerUid
		--inner join AR_LedgerDetail ldos on ld.LedgerUid = ldos.LedgerUid and ld.IsCredit != ldos.IsCredit
		inner join SuperbillProcedure sbp on ld.SuperbillProcedureUid = sbp.SuperbillProcedureUid
		inner join ViewSuperbillInsurance sb on sbp.SuperbillUid = sb.SuperbillUid and ld.LiabilityOwner = sb.DisplayOrder
	where ld.LiabilityOwner > 0 -- insurance only
		and ld.InsurancePlanUid != sb.InsurancePlanUid -- mismatched plan
	order by sb.ExternalID

/*
select *
	from ViewSuperbillInsurance
	where externalid = 'FPZ4180'
*/



/*
OLD CONTENT
EXEC AR_SetSuperbillAggregate @processAll = 1 -- update Superbill Aggregate
EXEC AR_SetDepositAggregate  -- update Deposit Aggregate
EXEC AR_SetBatchIsClosedAggregate -- Update ARBatch.IsClosed
*/


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_AuditFeeSchedulePeriods]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_AuditFeeSchedulePeriods] AS' 
END
GO
ALTER PROC [dbo].[AR_AuditFeeSchedulePeriods] 
	@FeeScheduleUid uniqueidentifier = null 
AS
--Audits the specified FeeSchedule, or all if not specified

	DECLARE @ErrorMessage as varchar(100)
	DECLARE @ErrorMessage2 as varchar(100)
	SET @ErrorMessage = 'The Fee Schedule data in the database may be corrupted: '
	if  @FeeScheduleUid is not null
		SET @ErrorMessage2 = 'Click on the FIX button in the Fee Schedule Period Section to try and fix the problem.'

	--Any out of order effective date and termination date?
	if exists(select * from FeeSchedulePeriod where (@FeeScheduleUid is null or FeeScheduleUid = @FeeScheduleUid) and EffectiveDate is not null and ExpirationDate is not null and EffectiveDate > ExpirationDate)
		begin
			RAISERROR('%s %s %s', 16, 1, @ErrorMessage, 'There is an invalid FeeSchedule period with effective date after its expiration date.', @ErrorMessage2)
			return
		end

	--Any overlapping FeeSchedule periods?
	if exists(select * from FeeSchedulePeriod ap1, FeeSchedulePeriod ap2 where (@FeeScheduleUid is null or ap1.FeeScheduleUid = @FeeScheduleUid) and ap1.FeeScheduleUid = ap2.FeeScheduleUid and ap1.FeeSchedulePeriodUid != ap2.FeeSchedulePeriodUid and ((ap1.EffectiveDate is null and ap2.EffectiveDate is null) or (ap1.EffectiveDate is not null and ap2.EffectiveDate is not null and ap1.EffectiveDate = ap2.EffectiveDate)))
		begin
			RAISERROR('%s %s %s', 16, 1, @ErrorMessage, 'There are invalid overlapping FeeSchedule periods (duplicate effective dates).', @ErrorMessage2)
			return
		end
	if exists(select * from FeeSchedulePeriod ap1, FeeSchedulePeriod ap2 where (@FeeScheduleUid is null or ap1.FeeScheduleUid = @FeeScheduleUid) and ap1.FeeScheduleUid = ap2.FeeScheduleUid and ap1.FeeSchedulePeriodUid != ap2.FeeSchedulePeriodUid and ap2.EffectiveDate is not null and (ap1.EffectiveDate is null or ap1.EffectiveDate < ap2.EffectiveDate) and (ap1.ExpirationDate is null or dateadd(dd, 1, ap1.ExpirationDate) > ap2.EffectiveDate))
		begin
			RAISERROR('%s %s %s', 16, 1, @ErrorMessage, 'There are invalid overlapping FeeSchedule periods.', @ErrorMessage2)
			return
		end

	--Any RVU schedules incorrectly set to allow auto update/populate?
	if exists(select * from FeeSchedule FS INNER JOIN FeeSchedulePeriod FSP ON FS.FeeScheduleUid = FSP.FeeScheduleUid  
			where (@FeeScheduleUid is null or FS.FeeScheduleUid = @FeeScheduleUid) and FSP.RVUScheduleUid is not null and FSP.IsAutoPopulated = 1)
		begin
			RAISERROR('%s %s %s', 16, 1, @ErrorMessage, 'There is an RVU based FeeSchedule that is misset to allow automatic population from payment entry.', @ErrorMessage2)
			return
		end

	if exists(select * from FeeSchedule FS INNER JOIN FeeSchedulePeriod FSP ON FS.FeeScheduleUid = FSP.FeeScheduleUid 
			where (@FeeScheduleUid is null or FS.FeeScheduleUid = @FeeScheduleUid) and FSP.RVUScheduleUid is not null and FSP.IsAutoUpdated = 1)
		begin
			RAISERROR('%s %s %s', 16, 1, @ErrorMessage, 'There is an RVU based FeeSchedulePeriod that is misset to allow automatic updates from payment entry.', @ErrorMessage2)
			return
		end

	--Any schedules have conflicting amount allowed settings?
	if exists(select * from FeeScheduleFee where (@FeeScheduleUid is null or FeeSchedulePeriodUid in (select FeeSchedulePeriodUid from FeeSchedulePeriod where FeeScheduleUid = @FeeScheduleUid)) and 1 < Convert(int, IsInsurancePlanPhysician) + Convert(int, IsInsurancePlanOther) + (case when FixedCopayAmount is null then 0 else 1 end) + (case when InsurancePercent is null then 0 else 1 end))
		begin
			RAISERROR('%s %s %s', 16, 1, @ErrorMessage, 'There are schedules with conflicting amount allowed settings.', @ErrorMessage2)
			return
		end


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_AutoUncompleteBatch]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_AutoUncompleteBatch] AS' 
END
GO
ALTER PROC [dbo].[AR_AutoUncompleteBatch]
	@arBatchUid UNIQUEIDENTIFIER
AS

	UPDATE ARBatch SET IsLocked = 0, LastModifiedDate = GETUTCDATE()
		WHERE ARBatchUid = @arBatchUid


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_ChangeBatch_SuperbillProcedures]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_ChangeBatch_SuperbillProcedures] AS' 
END
GO
ALTER PROCEDURE [dbo].[AR_ChangeBatch_SuperbillProcedures] 
(
	@arBatchUidTarget UNIQUEIDENTIFIER = NULL,
	@superbillProcedureUids VARCHAR(MAX) = NULL
)
AS
BEGIN 

	-- used by SuperbillProcedure.ChangeARBatch to change batch
	SELECT Element AS SuperbillProcedureUid
		INTO #tempSuperbillProceduresSelected
		FROM dbo.Split(@superbillProcedureUids,',');
	
	-- Audit Batch changes
	DECLARE @chgDesc VARCHAR(2000) -- LENGTH OF Audit.changes
	-- NOTE:  Using 'STUFF' to allow XML PATH to concatenate however I can't directly put results into @chgDesc.  STUFF works around that.
	SELECT @chgDesc = STUFF(
							',' + (select 'Superbill=''' + sb.ExternalID + ''', Procedure=''' + lp.Code + ''''
							from #tempSuperbillProceduresSelected tps
									left outer join SuperbillProcedure sbp with (nolock) on tps.SuperbillProcedureUid = sbp.SuperbillProcedureUid
									left outer join ListProcedure lp with (nolock) on sbp.ProcedureUid = lp.ProcedureUid
									left outer join Superbill sb with (nolock) on sbp.SuperbillUid = sb.SuperbillUid
							for XML PATH('AR_ChangeBatch_SuperbillProcedures')),
							1,1,'')	

	Insert into AuditCurrent(AuditUid, Type, Changes, Workstation, UserUid, ChangeDate, Description, LastModifiedDate )
	Values ( NEWID(), 'Aprima-SQL', 
			'<audit date="' + convert(nvarchar(30),GetUTCDate(), 120) +'"' +
				'<sql="' + 'AR_ChangeBatch_SuperbillProcedures @arBatchUidTarget=''' + CONVERT(varchar(max), @arBatchUidTarget) + ''', @superbillProcedureUids=''' + @superbillProcedureUids + '''' + '" />' +
				'</audit>', 
			'Unknown', null, GETUTCDATE(), 
			@chgDesc, 
			GETUTCDATE() )	
	-- End audit batch changes

	-- Actual batch change
	UPDATE AR_Ledger  
		SET AR_Ledger.ARBatchUid = @arBatchUidTarget
		FROM AR_Ledger 
			INNER JOIN AR_LedgerDetail LD ON AR_Ledger.LedgerUid = LD.LedgerUid
												AND AR_Ledger.EntryType = 1 -- Charge
			INNER JOIN ARBatch ARB ON AR_Ledger.ArBatchUid = ARB.ARBatchUid
			INNER JOIN #tempSuperbillProceduresSelected SBP ON LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid
		WHERE ARB.IsLocked = 0 AND ARB.IsClosed = 0;

	DROP TABLE #tempSuperbillProceduresSelected;

	SELECT 'NameValuePair' -- blocking failure
	SELECT 'Return Info','None'

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_ChangeBatch_Superbills]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_ChangeBatch_Superbills] AS' 
END
GO
ALTER PROCEDURE [dbo].[AR_ChangeBatch_Superbills] 
(
	@arBatchUidTarget UNIQUEIDENTIFIER = NULL,
	@superbillUids VARCHAR(MAX) = NULL
)
AS
BEGIN 
	-- used by Superbill.ChangeARBatch to change batch

	SELECT Element AS SuperbillUid
		INTO #tempSuperbillsSelected
		FROM dbo.Split(@superbillUids,',');

	-- Audit Batch changes
	DECLARE @chgDesc VARCHAR(2000) -- LENGTH OF Audit.changes
	-- NOTE:  Using 'STUFF' to allow XML PATH to concatenate however I can't directly put results into @chgDesc.  STUFF works around that.
	SELECT @chgDesc = STUFF(
							',' + (select 'Superbill=''' + sb.ExternalID + ''''
							from #tempSuperbillsSelected tps
									left outer join Superbill sb with (nolock) on tps.SuperbillUid = sb.SuperbillUid
							for XML PATH('AR_ChangeBatch_Superbills')),
							1,1,'')	

	Insert into AuditCurrent(AuditUid, Type, Changes, Workstation, UserUid, ChangeDate, Description, LastModifiedDate )
	Values ( NEWID(), 'Aprima-SQL', 
			'<audit date="' + convert(nvarchar(30),GetUTCDate(), 120) +'"' +
				'<sql="' + 'AR_ChangeBatch_Superbills @arBatchUidTarget=''' + CONVERT(varchar(max), @arBatchUidTarget) + ''', @superbillUids=''' + @superbillUids + '''' + '" />' +
				'</audit>', 
			'Unknown', null, GETUTCDATE(), 
			@chgDesc, 
			GETUTCDATE() )	
	-- End audit batch changes

	SELECT L.LedgerUid, SBP.SuperbillUid, SB.ExternalID, SBP.SuperbillProcedureUid,  LP.Code AS ProcedureCode, 
			CASE WHEN ARB.IsClosed = 1 OR ARB.IsLocked = 1 THEN 2 ELSE 1 END AS BatchStatus, -- 1 if open, 2 if closed or locked
			CASE WHEN ARB.IsClosed = 0 AND ARB.IsLocked = 0 THEN @arBatchUidTarget ELSE NULL END AS NewBatchUid
		INTO #tempLedgersAffected
		FROM AR_Ledger L
			INNER JOIN AR_LedgerDetail LD ON L.LedgerUid = LD.LedgerUid
			INNER JOIN ARBatch ARB ON L.ArBatchUid = ARB.ARBatchUid
			INNER JOIN SuperbillProcedure SBP ON LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid
			INNER JOIN ListProcedure LP ON SBP.ProcedureUid = LP.ProcedureUid
			INNER JOIN Superbill SB ON SBP.SuperbillUid = SB.SuperbillUid
			INNER JOIN #tempSuperbillsSelected TSS ON SBP.SuperbillUid = TSS.SuperbillUid
		WHERE (L.EntryType = 1) -- Charge
			OR (L.EntryType = 4 AND  -- Added For Bug 32123
				(SELECT COUNT(*) FROM AR_RelLedgerTag LT WHERE LT.Value = 'ChargeTransfer' AND LT.LedgerUid = L.LedgerUid)>0) 

	UPDATE AR_Ledger 
		SET AR_Ledger.ARBatchUid = #tempLedgersAffected.NewBatchUid
		FROM AR_Ledger 
			INNER JOIN #tempLedgersAffected ON AR_Ledger.LedgerUid = #tempLedgersAffected.LedgerUid
		WHERE NOT #tempLedgersAffected.NewBatchUid IS NULL

	SELECT 'NameValuePair' -- blocking failure
	SELECT CAST(SuperbillProcedureUid AS VARCHAR(50)),  ExternalID + ';' 
				+ CASE WHEN SumBatchStatus > 2 THEN 'Changed Partial'
						WHEN SumBatchStatus = 2 THEN 'Changed None'
						ELSE 'Changed All' END + ';' 
				+ ProcedureCode
			FROM (SELECT SuperbillProcedureUid, ProcedureCode, ExternalID, SUM(BatchStatus) AS SumBatchStatus
					FROM (SELECT DISTINCT SuperbillProcedureUid, ProcedureCode, ExternalID, BatchStatus
								FROM #tempLedgersAffected TLA) TLAD
						 GROUP BY SuperbillProcedureUid, ProcedureCode, ExternalID) TLADA
			ORDER BY ExternalID, ProcedureCode

	DROP TABLE #tempLedgersAffected;
	DROP TABLE #tempSuperbillsSelected;

END


/*
	AR_ChangeBatch_Superbills
	BMR 2013-02-28 - Changed Value Returned for Sucess
		
*/

-- EXEC AR_ChangeBatch_Superbills @arBatchUidTarget = 'a0cb3706-2124-42fb-9820-464419b80337', @superbillUids = 'a846ebe4-c1f6-4f88-bf14-00f360419b86'


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_Cleanup_MoveEqualAndOppositeSBPLiabilities]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_Cleanup_MoveEqualAndOppositeSBPLiabilities] AS' 
END
GO
/*
We have cases where we have equal but opposite sign balances between insurance and patient
This script attemps to transfer liability for this amount over to the correct liability owner
Afterwards, for those 'fixed', sets Superbill Status to Completed where no remaining balance
Associated Podiatry initial target ... may need at other sites
BROY 20110817
*/


ALTER PROC [dbo].[AR_Cleanup_MoveEqualAndOppositeSBPLiabilities]
AS
BEGIN

DECLARE @BUID UNIQUEIDENTIFIER
DECLARE @BPrefix VARCHAR(50)
DECLARE @OwnerUid UNIQUEIDENTIFIER
DECLARE @superbillProcedureUid UNIQUEIDENTIFIER
DECLARE @liabilityBalance MONEY
DECLARE @assignedLiabilityBalance MONEY
DECLARE @ledgerDetailUidOverCharge UNIQUEIDENTIFIER
DECLARE @ledgerUidNew UNIQUEIDENTIFIER
DECLARE @sourceLedgerQuantity INT

GOTO PARTTWO

SELECT @BUID = ArBatchUid FROM ARBatch WHERE CAST(Notes AS VARCHAR(MAX)) = 'Balance Equal And Opposite SBP Liabilities'
IF (@BUID IS NULL)
BEGIN
	SET @BUID = NEWID()

	INSERT INTO ARBatch(ARBatchUid, Name, Notes, 
		  LastModifiedDate, GLDate, IsLocked, OwnerUID)
	  VALUES (@BUID,'Balance Equal And Opposite SBP Liabilities ' + CAST(GetDate() As VarChar(25)),'Balance Equal And Opposite SBP Liabilities',
		   GETUTCDATE(),DATEADD(hh,12,CAST(GETDATE() AS DATE)),0,@OwnerUid)
END
      
SELECT * FROM ARBatch WHERE ARBatchUid = @BUID

SELECT VSBPA.*
     FROM AR_ViewSuperbillProcedureAggregate VSBPA
          INNER JOIN SuperbillProcedure SBP ON VSBPA.SuperbillProcedureUid = SBP.SuperbillProcedureUid
     WHERE VSBPA.LiabilityBalance = 0 and VSBPA.AssignedLiabilityBalance <> 0
          --AND VSBPA.SuperbillProcedureUid = 'B6D34B64-EB40-4D05-B3DE-0197CDD4F5F1'

SELECT SB.SuperbillUid, VSBA.LiabilityBalance,
          VSBA.AssignedLiabilityBalance
     INTO #targetSuperbillsExclueOthers
     FROM AR_ViewSuperbillAggregate VSBA
          INNER JOIN Superbill SB ON VSBA.SuperbillUid = SB.SuperbillUid
     WHERE VSBA.LiabilityBalance = 0 and VSBA.AssignedLiabilityBalance = 0 -- both patient and insurance are zero total on the superbill

SELECT SBP.SuperbillProcedureUid, VSBPA.LiabilityBalance,
          VSBPA.AssignedLiabilityBalance, SBP.SuperbillUid
     INTO #targetSuperbillProcedures
     FROM AR_ViewSuperbillProcedureAggregate VSBPA
          INNER JOIN SuperbillProcedure SBP ON VSBPA.SuperbillProcedureUid = SBP.SuperbillProcedureUid
          INNER JOIN #targetSuperbillsExclueOthers TSB ON SBP.SuperbillUid = TSB.SuperbillUid -- limit to Superbills with both patient and insurance = 0
     WHERE VSBPA.LiabilityBalance = 0 and VSBPA.AssignedLiabilityBalance <> 0 
		--AND VSBPA.SuperbillProcedureUid = 'B6D34B64-EB40-4D05-B3DE-0197CDD4F5F1'
		
SELECT DISTINCT SuperbillUid
	INTO #targetSuperbills
	FROM #targetSuperbillProcedures

DECLARE @targetLiabilityOwner INT

WHILE EXISTS(SELECT SuperbillProcedureUid FROM #targetSuperbillProcedures)
BEGIN  
     SELECT TOP 1 @superbillProcedureUid = SuperbillProcedureUid, @liabilityBalance = LiabilityBalance,
              @assignedLiabilityBalance = AssignedLiabilityBalance
          FROM #targetSuperbillProcedures  
     SELECT TOP 1 @targetLiabilityOwner = LiabilityOwner 
		FROM (SELECT SBP.SuperbillUid, SBP.SuperbillProcedureUid, LD.LiabilityOwner, SUM(LD.Amount) AS Balance, COUNT_BIG(*) AS Count   
					FROM dbo.SuperbillProcedure SBP    
						INNER JOIN dbo.AR_LedgerDetail LD ON SBP.SuperbillProcedureUid = LD.SuperbillProcedureUid
					GROUP BY SBP.SuperbillUid, SBP.SuperbillProcedureUid, LD.LiabilityOwner )  VSCLOACS
		WHERE VSCLOACS.SuperbillProcedureUid = @superbillProcedureUid AND VSCLOACS.LiabilityOwner > 0 AND VSCLOACS.Balance<>0 -- Update to insure correct LO
     SELECT TOP 1 @ledgerDetailUidOverCharge = LD.LedgerDetailUid, @sourceLedgerQuantity = L.Quantity
          FROM AR_LedgerDetail LD
              INNER JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid
          WHERE LD.LiabilityOwner > 0 AND LD.SuperbillProcedureUid = @superbillProcedureUid
              AND LD.IsCredit = 0 AND L.EntryType IN (1,4) AND LD.LiabilityOwner = @targetLiabilityOwner
          ORDER BY LD.LastModifiedDate DESC
       --SELECT '@ledgerDetailUidOverCharge', @ledgerDetailUidOverCharge
  --   SELECT LDOutside.* FROM AR_LedgerDetail LD
		--INNER JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid
		--INNER JOIN AR_LedgerDetail LDOutside ON L.LedgerUid = LDOutside.LedgerUid
		--WHERE LD.LedgerDetailUid = @ledgerDetailUidOverCharge ORDER BY IsCredit
     IF (@superbillProcedureUid=NULL OR @ledgerDetailUidOverCharge=NULL)
          CONTINUE
     SELECT @ledgerUidNew = NEWID()
     --SELECT '@ledgerUidNew', @ledgerUidNew
     INSERT INTO AR_Ledger(LedgerUid, EntryDate, ArBatchUid, ShortName, EntryType, Quantity, CreatedDateTime, LastModifiedDate)
          SELECT  @ledgerUidNew, CAST(GETDATE() AS DATE), @BUID, 'Balance Entry',
              4, @sourceLedgerQuantity, GETUTCDATE(), GETUTCDATE()
     -- DEBIT
     INSERT INTO AR_LedgerDetail(LedgerDetailUid, LedgerUid, Amount, LiabilityOwner, LedgerAccountUid, IncomeAccountUid,
              AccountResponsiblePartyUid, SuperbillProcedureUid, SuperbillProcedureUnits, AccountUid, InsurancePlanUid,
              RenderingProviderUid, ClaimingProviderUid, FinancialCenterUid, ServiceSiteUid, IsCredit, CreatedDateTIME, LastModifiedDate)
          SELECT  NEWID(), @ledgerUidNew, @assignedLiabilityBalance, 0,  LedgerAccountUid, IncomeAccountUid,
                   AccountResponsiblePartyUid, SuperbillProcedureUid, SuperbillProcedureUnits, AccountUid, NULL,
                   RenderingProviderUid, ClaimingProviderUid, FinancialCenterUid, ServiceSiteUid, 0, GETUTCDATE(), GETUTCDATE()
              FROM AR_LedgerDetail WHERE LedgerDetailUid = @ledgerDetailUidOverCharge
     -- CREDIT
     INSERT INTO AR_LedgerDetail(LedgerDetailUid, LedgerUid, Amount, LiabilityOwner, LedgerAccountUid, IncomeAccountUid,
              AccountResponsiblePartyUid, SuperbillProcedureUid, SuperbillProcedureUnits, AccountUid, InsurancePlanUid,
              RenderingProviderUid, ClaimingProviderUid, FinancialCenterUid, ServiceSiteUid, IsCredit, CreatedDateTime, LastModifiedDate)
          SELECT  NEWID(), @ledgerUidNew, 0-@assignedLiabilityBalance, LiabilityOwner,  LedgerAccountUid, IncomeAccountUid,
                   AccountResponsiblePartyUid, SuperbillProcedureUid, SuperbillProcedureUnits, AccountUid, InsurancePlanUid,
                   RenderingProviderUid, ClaimingProviderUid, FinancialCenterUid, ServiceSiteUid, 1, GETUTCDATE(), GETUTCDATE()
              FROM AR_LedgerDetail WHERE LedgerDetailUid = @ledgerDetailUidOverCharge
     DELETE FROM #targetSuperbillProcedures
          WHERE SuperbillProcedureUid = @superbillProcedureUid 
     SELECT @superbillProcedureUid = NULL, @ledgerDetailUidOverCharge = NULL  
     --SELECT * FROM AR_LedgerDetail WHERE LedgerUid = @ledgerUidNew ORDER BY IsCredit
END

SELECT VSBPA.*
     FROM AR_ViewSuperbillProcedureAggregate VSBPA
          INNER JOIN SuperbillProcedure SBP ON VSBPA.SuperbillProcedureUid = SBP.SuperbillProcedureUid
     WHERE VSBPA.LiabilityBalance = 0 and VSBPA.AssignedLiabilityBalance <> 0
		--AND VSBPA.SuperbillProcedureUid = 'B6D34B64-EB40-4D05-B3DE-0197CDD4F5F1'

SELECT SB.ExternalID, VSA.*
     FROM AR_ViewSuperbillAggregate VSA
          inner join Superbill SB on VSA.SuperbillUid = SB.SuperbillUid
     WHERE VSA.LiabilityBalance = 0 and VSA.AssignedLiabilityBalance <> 0
     ORDER BY SB.ExternalID

IF NOT (EXISTS(SELECT ARBatchUid FROM AR_Ledger WHERE ArBatchUid = @BUID))
      DELETE FROM ArBatch WHERE ArBatchUid = @BUID
      
      SELECT * FROM ARBatch WHERE ARBatchUid = @BUID
      
UPDATE Superbill -- set fixed that went to $0 as complete
	SET SuperbillStatusUid = '30F64D66-55CB-4438-BB2F-7A6250399312' -- completed
	WHERE SuperbillUid IN
	(
		SELECT VSA.SuperbillUid 
			FROM AR_ViewSuperbillAggregate VSA
				INNER JOIN #targetSuperbills TS ON VSA.SuperbillUid = TS.SuperbillUid
			WHERE VSA.LiabilityBalance = 0 AND VSA.AssignedLiabilityBalance = 0
	)
  
DROP TABLE #targetSuperbills    
DROP TABLE #targetSuperbillProcedures

PARTTWO:

/*
	PART II - In 2009, Insurance Plan is determined via the superbill account and thus no historical is kept
	In 2011, the Ledger detail keeps this historical info ...
	Seems there is a problem in the migration and in the pre Patch4 code that tranfers and applies Insurance Plan
	liability incorrectly ... 
	This update, syncs the liability values to the CURRENT (non historical) data which is no worse than as pre-migration
	Patch4 fixes will also fix this in 'new' transfers 
*/

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_LedgerDetail]') AND name = N'IX_AR_LedgerDetail_LiabilityOwner_ForLRQ')
DROP INDEX [IX_AR_LedgerDetail_LiabilityOwner_ForLRQ] ON [dbo].[AR_LedgerDetail] WITH ( ONLINE = OFF )

CREATE NONCLUSTERED INDEX [IX_AR_LedgerDetail_LiabilityOwner_ForLRQ] ON [dbo].[AR_LedgerDetail] 
(
	[LiabilityOwner] ASC
)
INCLUDE ( [SuperbillProcedureUid],
[InsurancePlanUid]) 

UPDATE LD
	SET LD.InsurancePlanUid = PIP.InsurancePlanUid
	FROM AR_LedgerDetail LD 
		INNER JOIN SuperbillProcedure SBP ON LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid
		INNER JOIN Superbill SB ON SBP.SuperbillUid = SB.SuperbillUid
		INNER JOIN SuperbillAggregate SBA ON SB.SuperbillUid = SBA.SuperbillUid
			INNER JOIN AccountInsurance AI ON SBA.AccountPeriodUid = AI.AccountPeriodUid AND AI.DisplayOrder = LD.LiabilityOwner
			INNER JOIN PersonInsurancePlan PIP ON AI.PersonInsurancePlanUid = PIP.PersonInsurancePlanUid
	WHERE LD.InsurancePlanUid <> PIP.InsurancePlanUid

IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_LedgerDetail]') AND name = N'IX_AR_LedgerDetail_LiabilityOwner_ForLRQ')
DROP INDEX [IX_AR_LedgerDetail_LiabilityOwner_ForLRQ] ON [dbo].[AR_LedgerDetail] WITH ( ONLINE = OFF )

END

/*
BEGIN TRANSACTION
EXEC dbo.AR_Cleanup_MoveEqualAndOppositeSBPLiabilities
ROLLBACK TRANSACTION
-- C0F97F46-8BD9-456A-A446-18E776D695B3
*/


/*
BEGIN TRANSACTION
DELETE
	FROM AR_Ledger 
	WHERE ShortName = 'Balance Entry'
		AND ARBatchUid IN (SELECT ARBatchUid FROM ARBatch WHERE CAST(Notes AS VARCHAR(MAX)) = 'Balance Equal And Opposite SBP Liabilities')
ROLLBACK TRANSACTION
*/


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_EC_finalizeEReportImport]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_EC_finalizeEReportImport] AS' 
END
GO
ALTER PROC [dbo].[AR_EC_finalizeEReportImport]
AS
UPDATE eReportRows SET
	superbillUid = eReportRows.patientAccountNumber,
	providerUid = ViewSuperbillPayer.ClaimingProviderUid,
	patientUid = account.personUID,
	insuredUid = COALESCE(ViewSuperbillPayer.InsuredPersonUid, ViewSuperbillPayer.InsuredCorporationUid),
	InsuranceCarrierUid = ViewSuperbillPayer.InsuranceCarrierUid,
	LastModifiedDate = GetUTCDate()
FROM eReportDetails
INNER JOIN eReportRows ON
	eReportRows.eReportDetailUid = eReportDetails.eReportDetailUid
INNER JOIN ViewSuperbillPayer ON
	ViewSuperbillPayer.superbillUid = eReportRows.patientAccountNumber AND
	ViewSuperbillPayer.InsuranceOrder = 1 

LEFT JOIN account ON
	account.accountUID = ViewSuperbillPayer.AccountUid 

WHERE
	eReportDetails.status = 'IMPORTING'

UPDATE eReportDetails 
	SET status = 'NEW' ,
	LastModifiedDate = GetUTCDate()
WHERE status = 'IMPORTING'


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_EC_insertEReportDetail]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_EC_insertEReportDetail] AS' 
END
GO
ALTER PROC [dbo].[AR_EC_insertEReportDetail]
	--@siteID int,
	@reportNumber varchar(50),
	@eReportDetailGUID uniqueidentifier = null output,
	@SBBatchRowGUID uniqueidentifier = null,
	@messageprocessDate datetime = null,
	@status varchar(50) = null,
	@totalCharge money = null,
	@totalClaims int = null,
	@acceptedCharges money = null,
	@acceptedClaims int = null
AS
SET @eReportDetailGUID = NEWID()

INSERT INTO eReportDetails
(eReportDetailUid, importDate, messageprocessDate, status, reportNumber, totalCharge, totalClaims, acceptedCharges, acceptedClaims,
	--siteID,
	ClaimBatchUid)
VALUES
(
	@eReportDetailGUID,
	GETUTCDATE(),
	ISNULL(@messageprocessDate,GETUTCDATE()),
	ISNULL(@status,'NEW'),
	@reportNumber,
	@totalCharge,
	@totalClaims,
	@acceptedCharges,
	@acceptedClaims,
	--@siteID,
	@SBBatchRowGUID)


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_EC_insertEReportRow]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_EC_insertEReportRow] AS' 
END
GO
ALTER PROC [dbo].[AR_EC_insertEReportRow]
	@eClaimBatchGUID uniqueidentifier,
	@type varchar(50),
	@messageDescription varchar(255),
	@additionalInformation varchar(255),
	@providerID varchar(50),
	@insuredID uniqueidentifier,
	@patientID uniqueidentifier,
	@superbillID uniqueidentifier,
	@payerID varchar(25),
	@ElectronicPayerUid uniqueidentifier
--	@siteID int
AS
INSERT INTO eReportRows
(	eReportDetailUid, superbillUid, providerUid, InsuranceCarrierUid, patientUid,  insuredUid,errorDescription, additionalClaimInformation,
	errorFlag,ClaimPayerId, eReportRowUid, epayerUid)	--	,new_eReportRowUid) --SiteID, --JW 11/03/05 Changed last column from ElectronicPayerUid to epayerUid as this matches our current schema.
VALUES
(	@eClaimBatchGUID, @superbillID,@providerID,NULL, @patientID,@insuredID, --@siteID, 
 	@messageDescription,@additionalInformation, 'E', @payerID, NEWID(), @ElectronicPayerUid )	--, NEWID())


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_EC_markSBBatchFinished]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_EC_markSBBatchFinished] AS' 
END
GO
ALTER  PROCEDURE [dbo].[AR_EC_markSBBatchFinished]
	@eClaimBatchGUID uniqueidentifier,
	@Status varchar(50),
	@LastModifiedByUid uniqueidentifier
AS
SET NOCOUNT ON
--	declare @submissionNumber INT
--	select @submissionNumber = Value from PluginSettings where Name like 'SubmissionNumber'
	UPDATE ClaimBatch 
		SET Status = @Status,
		LastModifiedByUid = @LastModifiedByUid,
		LastModifiedDate = GetUTCDAte()--,
--		SubmissionNumber = @submissionNumber
	WHERE ClaimBatchUid  = @eClaimBatchGUID

	
SET NOCOUNT OFF


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_EC_updateSBBatchDetailStatus]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_EC_updateSBBatchDetailStatus] AS' 
END
GO
ALTER PROC [dbo].[AR_EC_updateSBBatchDetailStatus]
	@eClaimBatchGUID uniqueidentifier,
	@superbillID uniqueidentifier,
	@Status varchar(50)
AS
SET NOCOUNT ON

	UPDATE ClaimBatchDetail
	SET status = @Status,
	LastModifiedDate = GetUTCDate()
	WHERE
		ClaimBatchDetail.SuperBillUid = @superbillID AND
		ClaimBatchUid = @eClaimBatchGUID

SET NOCOUNT OFF


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genSecondary_InfoCHC]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genSecondary_InfoCHC] AS' 
END
GO
ALTER PROCEDURE [dbo].[AR_genSecondary_InfoCHC] 
      @SuperBillUid uniqueidentifier,
      @DisplayOrder varchar(1) 
      
AS
BEGIN
	  -- CHC
	  --   NOTE:  Need the current insurance payer to determine if sending asCHC
	DECLARE @billingType int
	select @billingType = cap.BillingType
	FROM #XMLClaims_Sec_temp 
			INNER JOIN Superbill sb with (nolock) on #XMLClaims_Sec_temp.[OTHERPAYER!1!SuperBillID] = sb.SuperbillUid
			inner join SuperbillAggregate sba with (nolock) on sb.SuperbillUid= sba.SuperbillUid
			INNER JOIN ChcInsurancePlan cip with (nolock) on sba.CurrentInsurancePlanUid = cip.InsurancePlanUid
			INNER JOIN ChcListApprovalSetting cas with (nolock) on cip.ApprovalSettingUid = cas.ApprovalSettingUid
			INNER JOIN ChcApprovalPeriod cap with (nolock) on cas.ApprovalSettingUid = cap.ApprovalSettingUid
																AND (cap.EffectiveDate IS NULL OR sb.ServiceDateStart >= cap.EffectiveDate )
																AND (cap.ExpirationDate	IS NULL OR sb.ServiceDateStart <= cap.ExpirationDate )
	WHERE #XMLClaims_Sec_temp.tag = 1 -- OtherPayer
			AND #XMLClaims_Sec_temp.[OTHERPAYER!1!SuperBillID] = @SuperBillUid

	if ( @billingType IS NULL )			-- CHC?
		return ;
	if ( @billingType NOT IN ( 0, 3 ) ) -- FQHC or RHC
		return ;

	-- Creae a working table for all superbill procedures with FQHC revenue codes
	CREATE TABLE #fqhc_temp
	(
			[CLAIM!400!PID] UNIQUEIDENTIFIER,
			SuperbillProcedureUid UNIQUEIDENTIFIER,
			ProcedureUid UNIQUEIDENTIFIER,
			RevenueCode VARCHAR(10),
			RevenueCodeOrder int
	)

	-- Insert into working fqhc table ( Only those with billing type of 0 which is fqhc )
	--  Revenue code procedures based on:
	--     Superbill, SuperbillProcedureUid, RevenueCode
	--     (Include a revenueCodeOrder to allow grouping later )
	INSERT INTO #fqhc_temp( [CLAIM!400!PID], SuperbillProcedureUid, ProcedureUid, RevenueCode, RevenueCodeOrder)
		SELECT @SuperBillUid AS [CLAIM!400!PID],
			   sbp.SuperbillProcedureUid AS SuperbillProcedureUid,
			   sbp.ProcedureUid AS ProcedureUid,
			   lp.RevenueCode AS RevenueCode,
			   ROW_NUMBER() OVER( PARTITION BY lp.RevenueCode ORDER BY sbp.DisplayOrder asc) AS RevenueCodeOrder
		FROM SuperbillProcedure sbp WITH (NOLOCK) 
				INNER JOIN ListProcedure lp WITH (NOLOCK) ON sbp.ProcedureUid = lp.ProcedureUid
		WHERE sbp.SuperbillUid = @SuperbillUid AND (ISNULL(sbp.DontClaim,0) = 0)
		ORDER BY sbp.DisplayOrder

	-- Update procedure revenue codes with RHC ( 3 ) revenue codes (Mapping Table for RHC)
	IF ( @billingType in ( 3 ) ) -- RHC
	BEGIN
		UPDATE #fqhc_temp
			SET #fqhc_temp.RevenueCode = mi.SubstitutionText
			FROM #fqhc_temp
					INNER JOIN MapItem mi WITH (NOLOCK) ON mi.MapSourceUid = '649D2F6A-D215-41F3-963F-E912AACAF335' -- RHC 
															AND #fqhc_temp.ProcedureUid = mi.FindTableFromItemUid
	END

	--For FQHC/RHC billing type, only want Procs with RevenueCodes
	-- Remove those without revenue codes
	-- PROCCOB
	DELETE #XMLClaims_Sec_temp 
	FROM #XMLClaims_Sec_temp
			LEFT OUTER JOIN #fqhc_temp ON #XMLClaims_Sec_temp.[PROCCOB!2!ProcID] = #fqhc_temp.SuperbillProcedureUid
	WHERE	#XMLClaims_Sec_temp.tag = 2  
			AND (IsNull(#fqhc_temp.RevenueCode,'0') = '0')
	-- PROCADJ
	DELETE #XMLClaims_Sec_temp 
	FROM #XMLClaims_Sec_temp
			LEFT OUTER JOIN #fqhc_temp ON #XMLClaims_Sec_temp.[PROCADJ!4!ProcID] = #fqhc_temp.SuperbillProcedureUid
	WHERE	#XMLClaims_Sec_temp.tag = 4
			AND (IsNull(#fqhc_temp.RevenueCode,'0') = '0')
	-- PROCCOBERA
	DELETE #XMLClaims_Sec_temp 
	FROM #XMLClaims_Sec_temp
			LEFT OUTER JOIN #fqhc_temp ON #XMLClaims_Sec_temp.[PROCCOBERA!5!ProcID] = #fqhc_temp.SuperbillProcedureUid
	WHERE	#XMLClaims_Sec_temp.tag = 5
			AND (IsNull(#fqhc_temp.RevenueCode,'0') = '0')

	---------------------------------------------------------------------------------------------------------------------
	-- PROCCOB - Payments
	-- "MOVE" all payments to the "rolled up" code, Need only one payment ( SVD ) so roll up to one payment
	;with myCTE AS
	(	-- 1.  Need to sum up "revenue code" procedures based on #fqhc_temp
		select f2.SuperbillProcedureUid, #XMLClaims_Sec_temp.[PROCCOB!2!LiabilityOwner], 
		SUM(CAST(#XMLClaims_Sec_temp.[PROCCOB!2!AmountPaid] AS FLOAT)) AS TotalAmountPaid
		from #XMLClaims_Sec_temp
			INNER JOIN #fqhc_temp f1 ON #XMLClaims_Sec_temp.[PROCCOB!2!ProcID] = f1.SuperbillProcedureUid   -- Matches on sbp in #fqhc_temp
			INNER JOIN #fqhc_temp f2 ON f1.RevenueCode = f2.RevenueCode AND f2.RevenueCodeOrder = 1			-- matches f1 sbp with it's "roll up" sbp where revenue code order is 1
		where #XMLClaims_Sec_temp.tag = 2
		group by f2.SuperbillProcedureUid, #XMLClaims_Sec_temp.[PROCCOB!2!LiabilityOwner]
	) -- 2.  Now update the "first-order" Revenue Code Order with the new total
	UPDATE #XMLClaims_Sec_temp
	SET #XMLClaims_Sec_temp.[PROCCOB!2!AmountPaid] = mc.TotalAmountPaid
	FROM #XMLClaims_Sec_temp
			INNER JOIN myCTE mc ON #XMLClaims_Sec_temp.[PROCCOB!2!ProcID] = mc.SuperbillProcedureUid
									AND #XMLClaims_Sec_temp.[PROCCOB!2!LiabilityOwner] = mc.[PROCCOB!2!LiabilityOwner]
	where #XMLClaims_Sec_temp.tag = 2  -- PROCCOB

	-- 3. Delete the "second-order" Revenue payments ( Revenue code order is 2 through n )
	DELETE #XMLClaims_Sec_temp
	FROM #XMLClaims_Sec_temp
			INNER JOIN #fqhc_temp f3 ON #XMLClaims_Sec_temp.[PROCCOB!2!ProcID] = f3.SuperbillProcedureUid
											AND f3.RevenueCodeOrder != 1
	WHERE #XMLClaims_Sec_temp.tag = 2

	---------------------------------------------------------------------------------------------------------------------
	-- PROCADJ ( Remarks )
	UPDATE #XMLClaims_Sec_temp
	SET #XMLClaims_Sec_temp.[PROCADJ!4!ProcID] = f2.SuperbillProcedureUid
	FROM #XMLClaims_Sec_temp
			INNER JOIN #fqhc_temp f1 ON #XMLClaims_Sec_temp.[PROCADJ!4!ProcID] = f1.SuperbillProcedureUid
			INNER JOIN #fqhc_temp f2 ON f1.RevenueCode = f2.RevenueCode AND f2.RevenueCodeOrder = 1
	WHERE #XMLClaims_Sec_temp.tag = 4
			AND f1.RevenueCodeOrder != 1

	---------------------------------------------------------------------------------------------------------------------
	-- PROCCOBERA ( Adjustments )
	UPDATE #XMLClaims_Sec_temp
	SET #XMLClaims_Sec_temp.[PROCCOBERA!5!ProcID] = f2.SuperbillProcedureUid
	FROM #XMLClaims_Sec_temp
			INNER JOIN #fqhc_temp f1 ON #XMLClaims_Sec_temp.[PROCCOBERA!5!ProcID] = f1.SuperbillProcedureUid
			INNER JOIN #fqhc_temp f2 ON f1.RevenueCode = f2.RevenueCode AND f2.RevenueCodeOrder = 1
	WHERE #XMLClaims_Sec_temp.tag = 5
			AND f1.RevenueCodeOrder != 1

END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genSecondary_Info]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genSecondary_Info] AS' 
END
GO
ALTER PROCEDURE [dbo].[AR_genSecondary_Info] 
      @SuperBillUid uniqueidentifier,
      @DisplayOrder varchar(1) 
      
AS
BEGIN

SET NOCOUNT ON;

SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED;

CREATE TABLE #XMLClaims_Sec_temp (
				  tag INT,
				  parent INT,
				  [OTHERPAYER!1!LiabilityOwner] SMALLINT,				-- Insurance 
				  [OTHERPAYER!1!displayorder] SMALLINT,					-- Procedure Order
				  [OTHERPAYER!1!orgName] VARCHAR(80),
				  [OTHERPAYER!1!payerResponsibility] VARCHAR(1),
				  [OTHERPAYER!1!isWCC] SMALLINT ,
				  [OTHERPAYER!1!CopayPrimary] VARCHAR(19), --Decimal(19,2), /*MONEY*/
				  [OTHERPAYER!1!LN] VARCHAR(40),
				  [OTHERPAYER!1!FN] VARCHAR(40),
				  [OTHERPAYER!1!suffix] VARCHAR(40),
				  [OTHERPAYER!1!birthdate] VARCHAR(10),
				  [OTHERPAYER!1!gender] VARCHAR(1),
				  [OTHERPAYER!1!PlanmemberID] VARCHAR(40),
				  [OTHERPAYER!1!groupID] VARCHAR(40),
				  [OTHERPAYER!1!Relationship]  VARCHAR(2),
				  [OTHERPAYER!1!groupName] VARCHAR (100),
				  [OTHERPAYER!1!planType] VARCHAR (2),
				  [OTHERPAYER!1!IDType] VARCHAR (2),
				  [OTHERPAYER!1!ID] VARCHAR (10),
				  [OTHERPAYER!1!ReimbursementRate] VARCHAR(8) ,
				  [OTHERPAYER!1!HCPCSPayableAmount] VARCHAR(19),  /*MONEY*/
				  [OTHERPAYER!1!MOARemarkCode1] VARCHAR(8),
				  [OTHERPAYER!1!MOARemarkCode2] VARCHAR(8),
				  [OTHERPAYER!1!MOARemarkCode3] VARCHAR(8),
				  [OTHERPAYER!1!MOARemarkCode4] VARCHAR(8),
				  [OTHERPAYER!1!MOARemarkCode5] VARCHAR(8),
				  [OTHERPAYER!1!ESRDPaymentAmount] VARCHAR(19), /*MONEY*/
				  [OTHERPAYER!1!NonpayableProfessionalComponentAmount] VARCHAR(19),  /*MONEY*/
				  [OTHERPAYER!1!AdjudicationDate] datetime,
				  [OTHERPAYER!1!ICN] VARCHAR(50),
				  [OTHERPAYER!1!PayerPaidAmount] VARCHAR(19), /*MONEY*/
				  [OTHERPAYER!1!PatientPaidAmount] VARCHAR(19), /*MONEY*/
				  [OTHERPAYER!1!InsuranceAdjustment] VARCHAR(19), /*MONEY*/
				  [OTHERPAYER!1!AllowedAmount] VARCHAR(19), /*MONEY*/
				  [OTHERPAYER!1!DiscountAmount] VARCHAR(19), /*MONEY*/
				  [OTHERPAYER!1!PerDayLimitAmount] VARCHAR(19), /*MONEY*/
				  [OTHERPAYER!1!PatientResponsibleAmount] VARCHAR(19), /*MONEY*/
				  [OTHERPAYER!1!address1] VARCHAR(55),
				  [OTHERPAYER!1!address2] VARCHAR(55),
				  [OTHERPAYER!1!city] VARCHAR(30),
				  [OTHERPAYER!1!zip] VARCHAR(15),
				  [OTHERPAYER!1!state] VARCHAR(2),
				  [OTHERPAYER!1!elecPayerID] VARCHAR(55),
				  [OTHERPAYER!1!SuperBillID] UNIQUEIDENTIFIER,
				  [OTHERPAYER!1!insuranceplanuid] UNIQUEIDENTIFIER,   
				  [PROCCOB!2!ProcID] UNIQUEIDENTIFIER,
				  [PROCCOB!2!proc] VARCHAR(48),
				  [PROCCOB!2!AmountPaid] VARCHAR(19), /*MONEY*/
				  [PROCCOB!2!PatPaid] VARCHAR(19), /*MONEY*/
				  [PROCCOB!2!AmountAllowed] VARCHAR(19), /*MONEY*/
				  [PROCCOB!2!NDC] VARCHAR(15),
				  [PROCCOB!2!procM1] VARCHAR(8),
				  [PROCCOB!2!procM2] VARCHAR(8),
				  [PROCCOB!2!procM3] VARCHAR(8),
				  [PROCCOB!2!procM4] VARCHAR(8),
				  [PROCCOB!2!units] VARCHAR(10),
				  [PROCCOB!2!DatePaid] datetime,
				  [PROCCOB!2!TaxPaid] VARCHAR(19), /*MONEY*/
				  [PROCCOB!2!lineControlNo] VARCHAR(50),
				  [PROCCOB!2!LiabilityOwner] SMALLINT,
				  [PROCCOB!2!RevenueCode] VARCHAR(10),
				  [CLAIMADJ!3!LiabilityOwner] SMALLINT,
				  [CLAIMADJ!3!CroupCodeEraCode] VARCHAR(8),
				  [CLAIMADJ!3!ReasonCodeEraCode] VARCHAR(8),
				  [CLAIMADJ!3!AdjMoney] VARCHAR(19), /*MONEY*/
				  [CLAIMADJ!3!Quantity] SMALLINT,
				  [PROCADJ!4!ProcID] UNIQUEIDENTIFIER,
				  [PROCADJ!4!LiabilityOwner] SMALLINT,
				  [PROCADJ!4!proc] VARCHAR(48) ,
				  [PROCADJ!4!CroupCodeEraCode] VARCHAR(8),
				  [PROCADJ!4!ReasonCodeEraCode] VARCHAR(8),
				  [PROCADJ!4!AdjMoney] VARCHAR(19), /*MONEY*/
				  [PROCADJ!4!Quantity] SMALLINT,
				  [PROCADJ!4!insuranceplanuid] UNIQUEIDENTIFIER,
				  [PROCCOBERA!5!ProcID] UNIQUEIDENTIFIER,
				  [PROCCOBERA!5!LiabilityOwner] SMALLINT,
				  [PROCCOBERA!5!proc] VARCHAR(48),
				  [PROCCOBERA!5!CroupCodeEraCode] VARCHAR(8),
				  [PROCCOBERA!5!ReasonCodeEraCode] VARCHAR(8),
				  [PROCCOBERA!5!AdjMoney] VARCHAR(19), /*MONEY*/
				  [PROCCOBERA!5!Quantity] SMALLINT,
				  [PROCCOBERA!5!insuranceplanuid] UNIQUEIDENTIFIER,
				  -- 3048 start
				  [INSURANCEPLAN!6!InsurancePlanUid] UNIQUEIDENTIFIER,
				  [INSURANCEPLAN!6!address1] VARCHAR(100),
				  [INSURANCEPLAN!6!address2] VARCHAR(100),
				  [INSURANCEPLAN!6!city] VARCHAR(50),
				  [INSURANCEPLAN!6!state] VARCHAR(10),
				  [INSURANCEPLAN!6!zip] VARCHAR(20)
					-- 3048 end
)
    
INSERT INTO #XMLClaims_Sec_temp
     (
                  tag,
                  parent,  
                  [OTHERPAYER!1!displayorder] , 
                  [OTHERPAYER!1!LiabilityOwner],    
				  [OTHERPAYER!1!orgName], --Corporation.NAME
				  [OTHERPAYER!1!payerResponsibility], --accountinsurance.Displayorder
                  [OTHERPAYER!1!isWCC] ,
                  [OTHERPAYER!1!CopayPrimary], --personInsurancePlan.copayprimary
				  [OTHERPAYER!1!LN],
                  [OTHERPAYER!1!FN],
                  [OTHERPAYER!1!suffix],
                  [OTHERPAYER!1!birthdate],
                  [OTHERPAYER!1!gender],
                  [OTHERPAYER!1!PlanmemberID] ,
                  [OTHERPAYER!1!groupID],
                  [OTHERPAYER!1!Relationship],  
                  [OTHERPAYER!1!groupName],
                  [OTHERPAYER!1!planType],
                  [OTHERPAYER!1!IDType],
                  [OTHERPAYER!1!ID],
                  [OTHERPAYER!1!ReimbursementRate] ,
                  [OTHERPAYER!1!HCPCSPayableAmount] ,
                  [OTHERPAYER!1!MOARemarkCode1] ,
                  [OTHERPAYER!1!MOARemarkCode2] ,
                  [OTHERPAYER!1!MOARemarkCode3] ,
                  [OTHERPAYER!1!MOARemarkCode4] ,
                  [OTHERPAYER!1!MOARemarkCode5] ,
                  [OTHERPAYER!1!ESRDPaymentAmount] ,
                  [OTHERPAYER!1!NonpayableProfessionalComponentAmount] ,
                  [OTHERPAYER!1!AdjudicationDate] ,
                  [OTHERPAYER!1!ICN],
                  [OTHERPAYER!1!DiscountAmount] ,
                  [OTHERPAYER!1!PerDayLimitAmount],
                  [OTHERPAYER!1!PatientResponsibleAmount] ,
                  [OTHERPAYER!1!address1] ,
                  [OTHERPAYER!1!address2],
                  [OTHERPAYER!1!city] ,
                  [OTHERPAYER!1!zip] ,
                  [OTHERPAYER!1!state] ,
                  [OTHERPAYER!1!elecPayerID],
                  [OTHERPAYER!1!SuperBillID],
                  [OTHERPAYER!1!insuranceplanuid]

            )

SELECT            
                  1 as tag,
                  NULL AS parent,  
                  AccountInsurance.DisplayOrder AS   [OTHERPAYER!1!LiabilityOwner] ,
                  AccountInsurance.DisplayOrder AS [OTHERPAYER!1!displayorder],
                  CONVERT(VARCHAR(80),Corporation.NAME) AS [OTHERPAYER!1!orgName], --Corporation.NAME
                   (CASE WHEN AccountInsurance.DisplayOrder = 1 THEN 'P'  
                         WHEN AccountInsurance.DisplayOrder = 2 THEN 'S'  
                         WHEN AccountInsurance.DisplayOrder = 3 THEN 'T' 
                         WHEN AccountInsurance.DisplayOrder = 4 THEN 'A'  
                         WHEN AccountInsurance.DisplayOrder = 5 THEN 'B'  
                         WHEN AccountInsurance.DisplayOrder = 6 THEN 'C'  
                         WHEN AccountInsurance.DisplayOrder = 7 THEN 'D'  
                         WHEN AccountInsurance.DisplayOrder = 8 THEN 'E'  
                         WHEN AccountInsurance.DisplayOrder = 9 THEN 'F'  
                         WHEN AccountInsurance.DisplayOrder = 10 THEN 'G'  
                         WHEN AccountInsurance.DisplayOrder = 22 THEN 'H'  
                        ELSE ''  
                        END)       AS [OTHERPAYER!1!payerResponsibility],
                    CASE WHEN PersonInsurancePlan.PersonUid IS NOT NULL THEN 0  
                    WHEN PersonInsurancePlan.CorporationUid IS NOT NULL THEN 1 END AS [OTHERPAYER!1!isWCC],
                  CONVERT( VARCHAR(19), CAST(personInsurancePlan.copayprimary AS float)) AS [OTHERPAYER!1!CopayPrimary], --personInsurancePlan.copayprimary
                  CONVERT( VARCHAR(40), person.lastname) AS [OTHERPAYER!1!LN],
CONVERT( VARCHAR(40), person.firstname) AS [OTHERPAYER!1!FN],
                  CONVERT( VARCHAR(40), person.suffix) AS [OTHERPAYER!1!suffix],
				  CONVERT( VARCHAR(10), Person.BirthDate,101) AS [OTHERPAYER!1!birthdate],
                  CONVERT( VARCHAR(1),  ListGender.ANSICode) As [OTHERPAYER!1!gender],
                  CONVERT( VARCHAR(40), PersonInsurancePlan.PlanMemberID) AS [OTHERPAYER!1!PlanmemberID],
                  CONVERT( VARCHAR(40), PersonInsurancePlan.PlanGroupID) AS [OTHERPAYER!1!groupID],
				  CONVERT( VARCHAR(2),  ListRelationship.ANSICode) AS [OTHERPAYER!1!Relationship],   
                  CONVERT( VARCHAR(100), Insuranceplan.Name) AS [OTHERPAYER!1!groupName],
                  CONVERT( VARCHAR(2),  COALESCE (ListAccountType.ANSICode, '')) AS [OTHERPAYER!1!planType],
                  'PI'                                AS [OTHERPAYER!1!IDType],
                  CONVERT(VARCHAR(10), ListElectronicPayer.ClearingHousePayerID)              AS [OTHERPAYER!1!ID],
                  COBClaimDetail.ReimbursementRate    AS [OTHERPAYER!1!ReimbursementRate] ,
                  --REPLACE(COBClaimDetail.HCPCSPayableAmount, '.00', '')    
				  CONVERT(VARCHAR(19), CAST(COBClaimDetail.HCPCSPayableAmount AS FLOAT)) AS [OTHERPAYER!1!HCPCSPayableAmount] ,
                  CONVERT( VARCHAR(8), lecRemark1.Code )   AS [OTHERPAYER!1!MOARemarkCode1] ,
                  CONVERT( VARCHAR(8), lecRemark2.Code )  AS [OTHERPAYER!1!MOARemarkCode2] ,
				  CONVERT( VARCHAR(8), lecRemark3.Code ) AS [OTHERPAYER!1!MOARemarkCode3] ,
				  CONVERT( VARCHAR(8), lecRemark4.Code ) AS [OTHERPAYER!1!MOARemarkCode4] ,
                  CONVERT( VARCHAR(8), lecRemark5.Code )   AS [OTHERPAYER!1!MOARemarkCode5] ,
                  CONVERT( VARCHAR(19), CAST(COBClaimDetail.ESRDPaymentAmount AS FLOAT))    AS [OTHERPAYER!1!ESRDPaymentAmount] ,
				  CONVERT( VARCHAR(19), CAST(COBClaimDetail.NonpayableProfessionalComponentAmount AS FLOAT))   AS [OTHERPAYER!1!NonpayableProfessionalComponentAmount] ,
                  COBClaimDetail.AdjudicationDate    AS [OTHERPAYER!1!AdjudicationDate],
                  CONVERT( VARCHAR(30), COBClaimDetail.ICN) AS [OTHERPAYER!1!ICN],
                  CONVERT(VARCHAR(19), CAST(COBClaimDetail.DiscountAmount AS FLOAT)) AS [OTHERPAYER!1!DiscountAmount],
                  CONVERT(VARCHAR(19), CAST(COBClaimDetail.PerDayLimitAmount AS FLOAT)) AS [OTHERPAYER!1!PerDayLimitAmount] ,
                  CONVERT(VARCHAR(19), CAST(COBClaimDetail.PatientResponsibleAmount AS FLOAT)) AS [OTHERPAYER!1!PatientResponsibleAmount] ,
                  Person.Address1.value('(/Address/Address1)[1]', 'VARCHAR(100)') AS [OTHERPAYER!1!address1],
                  Person.Address1.value('(/Address/Address2)[1]', 'VARCHAR(100)') AS [OTHERPAYER!1!address2],
                  Person.Address1.value('(/Address/City)[1]', 'VARCHAR(100)') AS [OTHERPAYER!1!city] ,
                  Person.Address1.value('(/Address/Zip)[1]', 'VARCHAR(100)') AS [OTHERPAYER!1!zip] ,
                  Person.Address1.value('(/Address/State)[1]', 'VARCHAR(100)') AS [OTHERPAYER!1!state] ,
                  ISNULL(CAST(lep.PayerOrgID AS VARCHAR(50)),'')    AS [OTHERPAYER!1!elecPayerID],
                  @SuperBillUid AS [OTHERPAYER!1!SuperBillID],
                  InsurancePlan.InsurancecarrierUID AS [OTHERPAYER!1!insuranceplanuid]
      FROM         Superbill AS s 
                  INNER JOIN account ON  account.accountUid = s.accountUid  
                  INNER JOIN AccountResponsibleParty ON   Account.AccountResponsiblePartyUid = AccountResponsibleParty.AccountResponsiblePartyUid  
                  INNER JOIN AccountPeriod ON  AccountPeriod.Accountuid = account.accountUid  AND ((AccountPeriod.effectiveDate IS NOT NULL AND AccountPeriod.ExpirationDate IS NULL AND AccountPeriod.effectiveDate <= s.serviceDateEnd)
                        OR (AccountPeriod.effectiveDate IS NULL AND AccountPeriod.ExpirationDate IS NOT NULL AND AccountPeriod.expirationDate >= s.serviceDateEnd) 
                        OR (AccountPeriod.effectiveDate IS NOT NULL AND AccountPeriod.ExpirationDate IS NOT NULL AND AccountPeriod.effectiveDate <= s.serviceDateEnd AND AccountPeriod.expirationDate >= s.serviceDateEnd) 
                        OR (AccountPeriod.effectiveDate IS NULL AND AccountPeriod.ExpirationDate IS NULL))
                  INNER JOIN AccountInsurance  ON  AccountInsurance.AccountPeriodUid = AccountPeriod.AccountPeriodUid  --AND AccountInsurance.DisplayOrder = 1--(AccountInsurance.DisplayOrder = 1 or AccountInsurance.DisplayOrder = 2 or AccountInsurance.DisplayOrder = 3)
                  INNER JOIN PersonInsurancePlan  ON PersonInsurancePlan.PersonInsurancePlanUid = AccountInsurance.PersonInsurancePlanUid  
                  INNER JOIN InsurancePlan  ON InsurancePlan.InsurancePlanUid = PersonInsurancePlan.InsurancePlanUid  
                  INNER JOIN InsuranceCarrier ON InsuranceCarrier.CorporationUid = InsurancePlan.InsuranceCarrierUid 
                  LEFT JOIN Corporation ON Corporation.CorporationUid = InsuranceCarrier.CorporationUid
                  INNER JOIN Person  ON PersonInsurancePlan.PersonUid = Person.PersonUid  
                  INNER JOIN ListRelationShip  ON AccountInsurance.RelationShipUID = ListRelationShip.RelationShipUID  
                  LEFT JOIN ListAccountType ON ListAccountType.AccountTypeUid =-- InsuranceCarrier.AccountTypeUid     
                                          CASE WHEN InsurancePlan.UseInsuranceCarrierAccountType = 1 
                                               THEN InsuranceCarrier.AccountTypeUid           --Added by Aji 2006 03 22
                                               ELSE InsurancePlan.AccountTypeUid END    
                  LEFT JOIN listgender on listgender.genderuid = person.genderuid
                  LEFT JOIN ListElectronicPayer  ON ListElectronicPayer.ElectronicPayerUid = InsuranceCarrier.ElectronicPayerUid
                  LEFT JOIN COBClaimDetail on COBClaimDetail.superbilluid = s.superbilluid 
										AND (COBClaimDetail.InsuranceOrder <> @DisplayOrder AND COBClaimDetail.insuranceorder <> '0')
                                          and AccountInsurance.displayorder = COBClaimDetail.insuranceorder --COBClaimDetail.InsuranceOrder <> @DisplayOrder
                  LEFT JOIN ListERACode  lecRemark1 ON COBClaimDetail.MOARemarkCode1Uid = lecRemark1.ERACodeUID AND lecRemark1.TYPE = 'remark'
                  LEFT JOIN ListERACode  lecRemark2 ON COBClaimDetail.MOARemarkCode2Uid = lecRemark2.ERACodeUID AND lecRemark2.TYPE = 'remark'
                  LEFT JOIN ListERACode  lecRemark3 ON COBClaimDetail.MOARemarkCode3Uid = lecRemark3.ERACodeUID AND lecRemark3.TYPE = 'remark'
                  LEFT JOIN ListERACode  lecRemark4 ON COBClaimDetail.MOARemarkCode4Uid = lecRemark4.ERACodeUID AND lecRemark4.TYPE = 'remark'
                  LEFT JOIN ListERACode  lecRemark5 ON COBClaimDetail.MOARemarkCode5Uid = lecRemark5.ERACodeUID AND lecRemark5.TYPE = 'remark'
                  LEFT JOIN ListElectronicPayer lep ON lep.ElectronicPayerUid = InsuranceCarrier.ElectronicPayerUid

WHERE       s.superbilluid =  @SuperBillUid 
                  AND accountinsurance.Displayorder <> @DisplayOrder

-- OtherPayer ( Insurance )
--select * from #XMLClaims_Sec_temp
           
-- No need to send ( or calculate ) payments/adjustments if @DisplayOrder ( insurance we are NOT concerned with ) is primary
-- ASSUMING that when sending primary we don't have or don't need to send secondary( tertiary, ... ) info along
 
 -- NOTE:  REQUIRES EDI837Creator.dll built after 4/25/2013
if ( @DisplayOrder <> 1 )
BEGIN
	-- tag 2
	INSERT INTO #XMLClaims_Sec_temp
	(
	  tag,
	  parent,
	  [OTHERPAYER!1!LiabilityOwner],
	  [PROCCOB!2!ProcID],     
	  [PROCCOB!2!proc],
	  [PROCCOB!2!NDC],
	  [PROCCOB!2!procM1],
	  [PROCCOB!2!procM2],
	  [PROCCOB!2!procM3],
	  [PROCCOB!2!procM4],
	 [PROCCOB!2!units],
	  [PROCCOB!2!lineControlNo],
	  [PROCCOB!2!AmountPaid],
	  [PROCCOB!2!LiabilityOwner]	
	)
	SELECT   
	  2         AS tag,
	  1         AS parent,
	   COALESCE(AR_LedgerDetail.LiabilityOwner,1) AS [OTHERPAYER!1!LiabilityOwner],					  
			SuperbillProcedure.SuperbillProcedureUid          AS [PROCCOB!2!ProcID],
		ListProcedure.Code                        AS [PROCCOB!2!proc],
		ListProcedure.NDC AS [PROCCOB!2!NDC],
	  (CASE       WHEN dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 1) = '' THEN
			NULL
			ELSE
			dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 1)

	  END)        AS [PROCCOB!2!procM1],
	  (CASE       WHEN dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 2) = '' THEN
			NULL
			ELSE
			dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 2)
	  END)          AS [PROCCOB!2!procM2],
	  (CASE       WHEN dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 3) = '' THEN
			NULL
			ELSE
			dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 3)
	  END)                                AS [PROCCOB!2!procM3],
	  (CASE       WHEN dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 4) = '' THEN
			NULL
			ELSE
			dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 4)
	  END)                                AS [PROCCOB!2!procM4],
      
	  CONVERT(VARCHAR,SuperbillProcedure.Units) AS [PROCCOB!2!units],
	  Superbill.ExternalID +''+CONVERT(VARCHAR,SuperbillProcedure.DisplayOrder) AS  [PROCCOB!2!lineControlNo],
	  --	-sum(AR_LedgerDetail.amount) AS [PROCCOB!2!AmountPaid],
	  --CONVERT(VARCHAR(19), CAST(sum( CASE WHEN AR_Ledger.EntryType = 2 THEN -AR_LedgerDetail.amount ELSE 0 END ) AS FLOAT) ) AS [PROCCOB!2!AmountPaid],
	  [dbo].[UDF_TrimZeroes](sum( CASE WHEN AR_Ledger.EntryType = 2 THEN -AR_LedgerDetail.amount ELSE 0 END )) AS [PROCCOB!2!AmountPaid],
	  COALESCE(AR_LedgerDetail.LiabilityOwner,1) AS [PROCCOB!2!LiabilityOwner]
	FROM #XMLClaims_Sec_temp
		INNER JOIN SuperbillProcedure on SuperbillProcedure.superbillUid = @SuperBillUid AND (ISNULL(SuperbillProcedure.DontClaim,0) = 0)
		INNER JOIN ViewSuperbillProcedure_IsVoid on ViewSuperbillProcedure_IsVoid.SuperbillProcedureUid = SuperbillProcedure.SuperbillProcedureUid AND ViewSuperbillProcedure_IsVoid.IsVoid = '0' --added per bug 9450
		INNER JOIN ListProcedure ON ListProcedure.ProcedureUid = SuperbillProcedure.ProcedureUid
		--INNER JOIN ListProcedureCodeType ON ListProcedureCodeType.ProcedureCodeTypeUid = ListProcedure.ProcedureCodeTypeUid
												-- AND ListProcedureCodeType.Name IN ('CPT','HCPCS') 
		INNER JOIN Superbill on Superbill.superbillUid = SuperbillProcedure.superbillUid
		-- LEFT OUTER JOIN used just in case there is NOT a payment but there are adjustments, etc
		LEFT OUTER JOIN AR_LedgerDetail on AR_LedgerDetail.superbillprocedureUID = SuperbillProcedure.superbillProcedureUID 
												AND AR_LedgerDetail.LiabilityOwner = #XMLClaims_Sec_temp.[OTHERPAYER!1!LiabilityOwner]
												AND AR_LedgerDetail.LiabilityOwner <> 0
		LEFT OUTER JOIN AR_Ledger on AR_Ledger.LedgerUid = AR_LedgerDetail.LedgerUid and AR_Ledger.EntryType = 2	-- Distribution				
		LEFT OUTER JOIN listcredittype on listcredittype.credittypeuid = AR_LedgerDetail.IncomeAccountUid 
												AND ListCreditType.credittypeuid <> '914DD6FB-6EBB-43A5-A6FC-09FD156CCF26'
												AND ListCreditType.IsPayment = 1
	WHERE
		(#XMLClaims_Sec_temp.tag = 1 ) AND (SuperbillProcedure.superbilluid = @SuperBillUid)
	 GROUP BY Superbill.ExternalID, SuperbillProcedure.SuperbillProcedureUid,
				ListProcedure.Code, ListProcedure.NDC, 
				SuperbillProcedure.DisplayOrder, SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid,
				SuperbillProcedure.Units, 
				COALESCE(AR_LedgerDetail.LiabilityOwner,1)

	-- PROCCOB ( Superbill Procedures by Insurance )
	-- select * from #XMLClaims_Sec_temp
			            
	--**************************************************************************************************************************
	-- tag 3
	INSERT INTO #XMLClaims_Sec_temp
	(
					tag,
					parent,
					[OTHERPAYER!1!LiabilityOwner],
					[OTHERPAYER!1!DisplayOrder],					
					[CLAIMADJ!3!LiabilityOwner],
					[CLAIMADJ!3!CroupCodeEraCode],
					[CLAIMADJ!3!ReasonCodeEraCode] ,
					[CLAIMADJ!3!AdjMoney] ,
					[CLAIMADJ!3!Quantity] 
	)
	SELECT   
					3      AS Tag,
					1                                  AS parent, -- was 2
					COBClaimDetail.InsuranceOrder AS [OTHERPAYER!1!LiabilityOwner],
					0							  AS [OTHERPAYER!1!DisplayOrder],		-- Claim level adjustment not attached to specific procedure so set a 0
					COBClaimDetail.InsuranceOrder AS [CLAIMADJ!3!LiabilityOwner],
					lecGroup.Code  AS [CLAIMADJ!3!CroupCodeEraCode],
					lecReason.Code AS [CLAIMADJ!3!ReasonCodeEraCode] ,
					--CONVERT( VARCHAR(19), CAST( SUM(COBClaimAdjustments.Amount) AS FLOAT)) AS [CLAIMADJ!3!AdjMoney] ,
					[dbo].[UDF_TrimZeroes]( COBClaimAdjustments.Amount) AS [CLAIMADJ!3!AdjMoney] ,
					COBClaimAdjustments.Quantity AS [CLAIMADJ!3!Quantity] 

	FROM            #XMLClaims_Sec_temp
					RIGHT JOIN COBClaimDetail on COBClaimDetail.SuperBillUID = @SuperBillUid
					RIGHT JOIN COBClaimAdjustments on COBClaimAdjustments.COBClaimDetailUID = COBClaimDetail.COBClaimDetailUID
					RIGHT JOIN ListERACode  lecGroup ON  COBClaimAdjustments.GroupCodeERACodeUid = lecGroup.ERACodeUID AND lecGroup.TYPE = 'group'
					RIGHT JOIN ListERACode lecReason ON  COBClaimAdjustments.ReasonCodeERACodeUid = lecReason.ERACodeUID --AND lecReason.TYPE = 'status'
	WHERE
					#XMLClaims_Sec_temp.tag = 2 and COBClaimDetail.InsuranceOrder <> 0
					AND lecGroup.Code IS NOT NULL AND lecReason.Code IS NOT NULL
	GROUP BY COBClaimDetail.InsuranceOrder,
			 lecGroup.Code,
			 lecReason.Code,
			 COBClaimAdjustments.Quantity,
			 COBClaimAdjustments.Amount

	-- CLAIMADJ ( CLAIM level procedure adjustments )
	-- select * from #XMLClaims_Sec_temp
	-- tag 4
	INSERT INTO #XMLClaims_Sec_temp
	(
							 tag,
							 parent,
							 [OTHERPAYER!1!LiabilityOwner],	-- Insurance payer
							 [OTHERPAYER!1!DisplayOrder],	-- procedure display order
							 [PROCADJ!4!ProcID] ,
							 [PROCADJ!4!LiabilityOwner],
							 [PROCADJ!4!proc] ,
							 [PROCADJ!4!CroupCodeEraCode],
							 [PROCADJ!4!ReasonCodeEraCode] ,
							 [PROCADJ!4!AdjMoney] ,
							 [PROCADJ!4!Quantity] ,
							 [PROCADJ!4!insuranceplanuid]
	)
	SELECT   
					4									AS Tag,
					1                                   AS parent, -- was 2
				    cobd.InsuranceOrder					AS [OTHERPAYER!1!LiabilityOwner],
					sbp.DisplayOrder					AS [OTHERPAYER!1!DisplayOrder],		-- procedure display order
					sbp.SuperbillProcedureUid			AS [PROCADJ!4!ProcID] ,
				    cobd.InsuranceOrder					AS [PROCADJ!4!LiabilityOwner] ,
					lp.Code								AS [PROCADJ!4!proc] ,
					grp.Code							AS [PROCADJ!4!CroupCodeEraCode],
					rsn.Code							AS [PROCADJ!4!ReasonCodeEraCode] ,
					--CONVERT(VARCHAR(19), CAST(SUM(-(cobl.Amount)) AS FLOAT))                 AS [PROCADJ!4!AdjMoney] ,
					[dbo].[UDF_TrimZeroes]( SUM(-(cobl.Amount)) ) AS [PROCADJ!4!AdjMoney] ,
					cobl.Quantity						AS [PROCADJ!4!Quantity] ,
					xClaimsIns.[OTHERPAYER!1!insuranceplanuid]                AS [PROCADJ!4!insuranceplanuid]    
	FROM #XMLClaims_Sec_temp 
			INNER JOIN SuperbillProcedure sbp ON #XMLClaims_Sec_temp.[PROCCOB!2!ProcID] = sbp.SuperbillProcedureUid -- was sbp.superbillUid = @SuperBillUid 
													AND ISNULL(sbp.DontClaim,0) = 0
			inner join ListProcedure lp on sbp.ProcedureUid = lp.ProcedureUid
			inner join COBLineAdjustments cobl on sbp.SuperbillProcedureUid = cobl.SuperbillProcedureUid -- All Remarks for this superbill/procedures
			inner join COBClaimDetail cobd on cobl.COBClaimDetailUid = cobd.COBClaimDetailUid
													AND #XMLClaims_Sec_temp.[OTHERPAYER!1!LiabilityOwner] = cobd.InsuranceOrder
			inner join Deposit d on cobl.DepositUid = d.DepositUid                -- Use deposit to determine liability owner
			INNER join ListERACode grp on cobl.GroupCodeERACodeUid = grp.ERACodeUid
			INNER join ListERACode rsn on cobl.ReasonCodeERACodeUid = rsn.ERACodeUid
			LEFT OUTER JOIN #XMLClaims_Sec_temp xClaimsIns ON xClaimsIns.tag = 1
																AND xClaimsIns.[OTHERPAYER!1!LiabilityOwner] = cobd.InsuranceOrder
	WHERE
		  (#XMLClaims_Sec_temp.tag = 2 and sbp.superbilluid = @SuperBillUid)
	GROUP BY cobd.InsuranceOrder,
			 sbp.DisplayOrder,
			 sbp.SuperbillProcedureUid,
			 lp.Code,
			 grp.Code,
			 rsn.Code,
			 cobl.Quantity,
			 xClaimsIns.[OTHERPAYER!1!insuranceplanuid]
	HAVING SUM(-(cobl.Amount)) != 0 

	-- PROCCOB ( Procedure remarks )

	--***********************************************************************************************
	-- tag 6

	INSERT INTO #XMLClaims_Sec_temp
		(
		   tag,
		   parent,
		   [OTHERPAYER!1!LiabilityOwner],
		   [OTHERPAYER!1!DisplayOrder],
		   [PROCCOB!2!ProcID],
		   [INSURANCEPLAN!6!address1],
			[INSURANCEPLAN!6!address2],
			[INSURANCEPLAN!6!city],
			[INSURANCEPLAN!6!state],
			[INSURANCEPLAN!6!zip],
			[INSURANCEPLAN!6!InsurancePlanUid]
		)
		SELECT   
			6 AS Tag,
			1 AS parent, 
			#XMLClaims_Sec_temp.[OTHERPAYER!1!LiabilityOwner] AS [OTHERPAYER!1!LiabilityOwner],
			#XMLClaims_Sec_temp.[OTHERPAYER!1!DisplayOrder]   AS [OTHERPAYER!1!DisplayOrder],
			#XMLClaims_Sec_temp.[PROCCOB!2!ProcID]            AS [PROCCOB!2!ProcID],
			--InsurancePlan.InsurancePlanUid						  AS  [OTHERPAYER!1!insuranceplanuid],
			-- Address1
			CASE WHEN ISNULL(InsurancePlan.UseCarrierAddress,0) = 1 
				 THEN corp.Address.value('(/Address/Address1)[1]', 'VARCHAR(100)')
			     ELSE InsurancePlan.Address.value('(/Address/Address1)[1]', 'VARCHAR(100)') 
			END AS [INSURANCEPLAN!6!address1],
			-- Address2
			CASE WHEN ISNULL(InsurancePlan.UseCarrierAddress,0) = 1 
				 THEN corp.Address.value('(/Address/Address2)[1]', 'VARCHAR(100)')
			     ELSE InsurancePlan.Address.value('(/Address/Address2)[1]', 'VARCHAR(100)') 
			END AS [INSURANCEPLAN!6!address2],
			-- City
			CASE WHEN ISNULL(InsurancePlan.UseCarrierAddress,0) = 1 
				 THEN corp.Address.value('(/Address/City)[1]', 'VARCHAR(100)')
			     ELSE InsurancePlan.Address.value('(/Address/City)[1]', 'VARCHAR(100)') 
			END AS [INSURANCEPLAN!6!city],
			-- State
			CASE WHEN ISNULL(InsurancePlan.UseCarrierAddress,0) = 1 
				 THEN corp.Address.value('(/Address/State)[1]', 'VARCHAR(100)')
			     ELSE InsurancePlan.Address.value('(/Address/State)[1]', 'VARCHAR(100)') 
			END AS [INSURANCEPLAN!6!state],
			-- Zip
			CASE WHEN ISNULL(InsurancePlan.UseCarrierAddress,0) = 1 
				 THEN corp.Address.value('(/Address/Zip)[1]', 'VARCHAR(100)')
			     ELSE InsurancePlan.Address.value('(/Address/Zip)[1]', 'VARCHAR(100)') 
			END AS [INSURANCEPLAN!6!zip],
			   InsurancePlan.InsurancePlanUid AS [INSURANCEPLAN!6!InsurancePlanUid]

			FROM         #XMLClaims_Sec_temp 
						INNER JOIN Superbill s ON #XMLClaims_Sec_temp.[OTHERPAYER!1!SuperBillID] = s.SuperbillUid
						INNER JOIN account ON  account.accountUid = s.accountUid  
						INNER JOIN AccountPeriod ON  AccountPeriod.Accountuid = account.accountUid  AND ((AccountPeriod.effectiveDate IS NOT NULL AND AccountPeriod.ExpirationDate IS NULL AND AccountPeriod.effectiveDate <= s.serviceDateEnd)
								OR (AccountPeriod.effectiveDate IS NULL AND AccountPeriod.ExpirationDate IS NOT NULL AND AccountPeriod.expirationDate >= s.serviceDateEnd) 
								OR (AccountPeriod.effectiveDate IS NOT NULL AND AccountPeriod.ExpirationDate IS NOT NULL AND AccountPeriod.effectiveDate <= s.serviceDateEnd AND AccountPeriod.expirationDate >= s.serviceDateEnd) 
								OR (AccountPeriod.effectiveDate IS NULL AND AccountPeriod.ExpirationDate IS NULL))
						INNER JOIN AccountInsurance  ON  AccountInsurance.AccountPeriodUid = AccountPeriod.AccountPeriodUid  
															AND AccountInsurance.DisplayOrder <> @DisplayOrder
						INNER JOIN PersonInsurancePlan  ON PersonInsurancePlan.PersonInsurancePlanUid = AccountInsurance.PersonInsurancePlanUid  
						INNER JOIN InsurancePlan  ON InsurancePlan.InsurancePlanUid = PersonInsurancePlan.InsurancePlanUid 
						INNER JOIN Corporation corp ON InsurancePlan.InsuranceCarrierUid = corp.CorporationUid
		WHERE #XMLClaims_Sec_temp.tag = 1
				AND #XMLClaims_Sec_temp.[OTHERPAYER!1!SuperBillID] IS NOT NULL
	
	
	-- tag 5	
	INSERT INTO #XMLClaims_Sec_temp
	(
	  tag,
	  parent,
	  [OTHERPAYER!1!LiabilityOwner],		-- insurance payer
	  [OTHERPAYER!1!displayorder],			-- procedure display order
	  [PROCCOBERA!5!ProcID], 
	  [PROCCOBERA!5!LiabilityOwner], 
	  [PROCCOBERA!5!proc],
	  [PROCCOBERA!5!CroupCodeEraCode],
	  [PROCCOBERA!5!ReasonCodeEraCode],
	  [PROCCOBERA!5!AdjMoney],
	  [PROCCOBERA!5!insuranceplanuid]
	)
	SELECT   
	  5                                                       AS Tag,
	  1 AS parent, -- was 2
	  AR_LedgerDetail.LiabilityOwner AS [OTHERPAYER!1!LiabilityOwner],		-- insurance payer
	  SuperbillProcedure.DisplayOrder AS [OTHERPAYER!1!DisplayOrder],		-- procedure display order
	  SuperbillProcedure.SuperbillProcedureUid                AS [PROCCOBERA!5!ProcID],
	  AR_LedgerDetail.LiabilityOwner        AS [PROCCOBERA!5!LiabilityOwner] ,
	  ListProcedure.Code     AS [PROCCOBERA!5!proc],
	  lecGroup.Code    AS [PROCCOBERA!5!CroupCodeEraCode],
	  lecReason.Code                 AS [PROCCOBERA!5!ReasonCodeEraCode],
	  --CONVERT(VARCHAR(19), CAST(SUM(-AR_LedgerDetail.Amount) AS FLOAT))         AS [PROCCOBERA!5!AdjMoney],
	  dbo.UDF_TrimZeroes( SUM(-AR_LedgerDetail.Amount) ) AS [PROCCOBERA!5!AdjMoney],
	  --AR_LedgerDetail.InsurancePayerUid AS [PROCCOBERA!5!insuranceplanuid]--,  
	  #XMLClaims_Sec_temp.[OTHERPAYER!1!insuranceplanuid] AS [PROCCOBERA!5!insuranceplanuid]  
	FROM #XMLClaims_Sec_temp
			INNER JOIN SuperbillProcedure ON SuperbillProcedure.superbillUid = @SuperBillUid AND ISNULL(SuperbillProcedure.DontClaim,0) = 0
			INNER JOIN ListProcedure ON ListProcedure.ProcedureUid = SuperbillProcedure.ProcedureUid
			--LEFT JOIN ListProcedureCodeType ON ListProcedureCodeType.ProcedureCodeTypeUid = ListProcedure.ProcedureCodeTypeUid AND ListProcedureCodeType.Name IN ('CPT','HCPCS')
			--LEFT JOIN ListProcedureServiceType ON ListProcedureServiceType.ProcedureServiceTypeUid = ListProcedure.ProcedureServiceTypeUid
			INNER JOIN AR_LedgerDetail on AR_LedgerDetail.superbillprocedureUID = SuperbillProcedure.SuperbillProcedureUid -- #XMLClaims_Sec_temp.[PROCCOB!2!ProcID]
			INNER JOIN AR_Ledger on AR_Ledger.LedgerUid = AR_LedgerDetail.LedgerUid 
									AND AR_Ledger.EntryType = 3
									AND AR_Ledger.VoidLedgerUid IS NULL
									AND #XMLClaims_Sec_temp.[OTHERPAYER!1!LiabilityOwner] = AR_LedgerDetail.LiabilityOwner
			--LEFT JOIN listcredittype on listcredittype.credittypeuid = AR_LedgerDetail.IncomeAccountUid
			INNER JOIN ListERACode  lecGroup ON AR_Ledger.GroupERACodeUid = lecGroup.ERACodeUID AND lecGroup.TYPE = 'group'
			INNER JOIN ListERACode lecReason ON AR_Ledger.ReasonERACodeUid = lecReason.ERACodeUID AND (lecReason.TYPE = 'status' OR lecReason.TYPE = 'reason')
			LEFT OUTER JOIN AR_Ledger arlVoid on AR_Ledger.LedgerUid = arlVoid.VoidLedgerUid
			--LEFT OUTER JOIN #XMLClaims_Sec_temp xClaimsIns ON xClaimsIns.tag = 1
			--													AND xClaimsIns.[OTHERPAYER!1!LiabilityOwner] = AR_LedgerDetail.LiabilityOwner
	WHERE
			#XMLClaims_Sec_temp.tag = 1 --AND
			--(listcredittype.isAdjustment = '1' OR (listcredittype.isAdjustment = '0' AND listcredittype.IsPayment = '0' )))
			--ListCreditType.TransactionTypeUid = 'DFE2CDCD-F156-4C5C-A56E-52D7CD3105D3' -- Contractual Adjustment
			AND arlVoid.LedgerUid IS NULL
	GROUP BY AR_LedgerDetail.LiabilityOwner,
			 SuperbillProcedure.DisplayOrder,
			 SuperbillProcedure.SuperbillProcedureUid,
			 ListProcedure.Code,
			 lecGroup.Code,
			 lecReason.Code,
			 #XMLClaims_Sec_temp.[OTHERPAYER!1!insuranceplanuid]
	HAVING SUM(-AR_LedgerDetail.Amount) != 0 

	-- PROCCOBERA ( Contractual adjustments )
	-- select * from #XMLClaims_Sec_temp

	-- 3048 start
	INSERT INTO #XMLClaims_Sec_temp
	(
	  tag,
	  parent,
	  [INSURANCEPLAN!6!address1],
	  [INSURANCEPLAN!6!address2],
	  [INSURANCEPLAN!6!city],
	  [INSURANCEPLAN!6!state],
	  [INSURANCEPLAN!6!zip]
	)
	SELECT   
	  6                                                       AS Tag,
	  1 AS parent, 

	  'a' as [INSURANCEPLAN!6!address1],
	  'b' as [INSURANCEPLAN!6!address2],
	  'c' as [INSURANCEPLAN!6!city],
	  'd' as [INSURANCEPLAN!6!state],
	  'e' as[INSURANCEPLAN!6!zip]
      FROM #XMLClaims_Sec_temp
		   INNER JOIN InsurancePlan ON #XMLClaims_Sec_temp.[OTHERPAYER!1!insuranceplanuid] = InsurancePlan.InsurancePlanUid
	  WHERE tag = 1

	-- 3048 end


	--Tax Paid
	UPDATE				#XMLClaims_Sec_temp
	SET					[PROCCOB!2!TaxPaid] = CONVERT( VARCHAR(19), CAST(
												  (SELECT -sum(DISTINCT AR_LedgerDetail.amount)
												  FROM superbillprocedure
												   JOIN AR_LedgerDetail on AR_LedgerDetail.superbillprocedureUID = #XMLClaims_Sec_temp.[PROCCOB!2!ProcID]
												  
												   JOIN AR_Ledger on AR_Ledger.LedgerUid = AR_LedgerDetail.LedgerUid and AR_Ledger.EntryType = 2
												  RIGHT JOIN listcredittype on listcredittype.credittypeuid = AR_LedgerDetail.IncomeAccountUid AND listcredittype.credittypeuid = '914DD6FB-6EBB-43A5-A6FC-09FD156CCF26'
												  WHERE superbillprocedure.superbillProcedureUID = #XMLClaims_Sec_temp.[PROCCOB!2!ProcID]
												  AND listcredittype.IsPayment = 1) AS FLOAT))


	--Patient Paid
	UPDATE				#XMLClaims_Sec_temp
	SET					[PROCCOB!2!PatPaid] = CONVERT( VARCHAR(19), CAST(
												(SELECT -sum(DISTINCT AR_LedgerDetail.amount)
											   FROM superbillprocedure
											   JOIN AR_LedgerDetail on AR_LedgerDetail.superbillprocedureUID = #XMLClaims_Sec_temp.[PROCCOB!2!ProcID]
											   JOIN AR_Ledger on AR_Ledger.LedgerUid = AR_LedgerDetail.LedgerUid and AR_Ledger.EntryType = 2
											   JOIN listcredittype on listcredittype.credittypeuid = AR_LedgerDetail.IncomeAccountUid
											   WHERE superbillprocedure.superbillProcedureUID = #XMLClaims_Sec_temp.[PROCCOB!2!ProcID] 
											   AND AR_LedgerDetail.accountresponsiblepartyuid is not null) AS FLOAT) )
	--*** Procedure Ammount allowed
	UPDATE				#XMLClaims_Sec_temp
	SET					[PROCCOB!2!AmountAllowed] = CONVERT( VARCHAR(19), CAST(
	                                                 (SELECT top 1 AR_RelLedgerDetailModifier.ActualAmountAllowed
							    					 FROM superbillprocedure
													 JOIN AR_LedgerDetail on AR_LedgerDetail.superbillprocedureUID = #XMLClaims_Sec_temp.[PROCCOB!2!ProcID] AND AR_LedgerDetail.LiabilityOwner = #XMLClaims_Sec_temp.[PROCCOB!2!LiabilityOwner]
													 JOIN AR_RelLedgerDetailModifier on AR_RelLedgerDetailModifier.LedgerDetailUid = AR_LedgerDetail.LedgerDetailUid
													 WHERE superbillprocedure.superbillProcedureUID = #XMLClaims_Sec_temp.[PROCCOB!2!ProcID]
													 order by AR_RelLedgerDetailModifier.LastModifiedDate desc) AS FLOAT))

	--*** Procedure date paid or Adjducated
	UPDATE				#XMLClaims_Sec_temp
	SET					[PROCCOB!2!DatePaid] = (SELECT top 1 CONVERT(VARCHAR, AR_Ledger.EntryDate, 101)    
												FROM Superbill 
												JOIN superbillprocedure on SuperbillProcedure.SuperbillUid = Superbill.SuperbillUid
												JOIN AR_LedgerDetail on AR_LedgerDetail.superbillprocedureUID = #XMLClaims_Sec_temp.[PROCCOB!2!ProcID] 
												JOIN AR_Ledger on AR_Ledger.LedgerUid = AR_LedgerDetail.LedgerUid and AR_Ledger.EntryType = 2 
												WHERE superbillprocedure.superbillprocedureUID = #XMLClaims_Sec_temp.[PROCCOB!2!ProcID] 
												ORDER BY AR_Ledger.EntryDate DESC)

    -- RevenueCode
	UPDATE #XMLClaims_Sec_temp
	   SET [PROCCOB!2!RevenueCode] = lp.RevenueCode
	   FROM #XMLClaims_Sec_temp 
	           INNER Join SuperbillProcedure sbp on #XMLClaims_Sec_temp.[PROCCOB!2!ProcID] = sbp.SuperbillProcedureUid
			   INNER JOIN ListProcedure lp on sbp.ProcedureUid = lp.ProcedureUid

	-- CHC
	EXEC AR_genSecondary_InfoCHC @SuperBillUid = @SuperBillUid, @DisplayOrder=@DisplayOrder
					                   
END  

--SELECT * FROM #XMLClaims_Sec_temp
--ORDER BY  #XMLClaims_Sec_temp.[OTHERPAYER!1!LiabilityOwner], tag, #XMLClaims_Sec_temp.[OTHERPAYER!1!DisplayOrder], #XMLClaims_Sec_temp.[PROCCOB!2!ProcID]

SELECT * FROM #XMLClaims_Sec_temp
ORDER BY  #XMLClaims_Sec_temp.[OTHERPAYER!1!LiabilityOwner], tag, #XMLClaims_Sec_temp.[OTHERPAYER!1!DisplayOrder], #XMLClaims_Sec_temp.[PROCCOB!2!ProcID]
FOR XML EXPLICIT 
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_SERVICEFACILITY]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_SERVICEFACILITY] AS' 
END
GO
ALTER PROC [dbo].[AR_genXMLClaims_SERVICEFACILITY]
AS

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],
	[CLAIM!400!PID],
	[PATIENT!300!PEID],
	[SUBSCRIBER!200!PEID],
	[PAYER!230!ID!hide], 	--Added by Shweta

	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
	[SERVICEFACILITY!430!PID],
	[SERVICEFACILITY!430!type],
	[SERVICEFACILITY!430!orgName],
	[SERVICEFACILITY!430!address1],
	[SERVICEFACILITY!430!address2],
	[SERVICEFACILITY!430!city],
	[SERVICEFACILITY!430!state],
	[SERVICEFACILITY!430!zip],
	[SERVICEFACILITY!430!phone],
	[SERVICEFACILITY!430!siteType],
	[SERVICEFACILITY!430!PrimaryIDType],
	[SERVICEFACILITY!430!PrimaryID],
	[SERVICEFACILITY!430!IDType],
	[SERVICEFACILITY!430!ID],
    [FINANCIALCENTER!105!FCID],
	[CLAIM!400!AccountID],
	[CLAIM!400!AccountPeriodID] 
)
SELECT
	430 					AS Tag,
	400 					AS parent,
	[SITE!100!PID]				AS [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]		AS [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]	AS [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]		AS [SITE!100!payToAddressID!hide],
	[CLAIM!400!PID]			AS [CLAIM!400!PID],
	[PATIENT!300!PEID]			AS [PATIENT!300!PEID],
	[SUBSCRIBER!200!PEID]		AS [SUBSCRIBER!200!PEID],
	#XMLClaims_temp.[PAYER!230!ID!hide]	AS [PAYER!230!ID!hide],			-- added by Shweta

	[RENDERER!410!ID!hide]			AS [RENDERER!410!ID!hide],
	[RENDERER!410!PEID]			AS [RENDERER!410!ID!hide],
	[SERVICEFACILITY!430!PID]		AS [SERVICEFACILITY!430!PID],
	'77'					AS [SERVICEFACILITY!430!type],		-- 5010 changed FA to 77
    (CASE WHEN ListServiceSite.FormalName IS NOT NULL THEN ListServiceSite.FormalName
          ELSE ListServiceSite.Name
     END)	AS [SERVICEFACILITY!430!orgName],
	ListServiceSite.[Address].value('(/Address/Address1)[1]', 'VARCHAR(100)') AS [SERVICEFACILITY!430!address1],
	ListServiceSite.[Address].value('(/Address/Address2)[1]', 'VARCHAR(100)') AS [SERVICEFACILITY!430!address2],
	ListServiceSite.[Address].value('(/Address/City)[1]', 'VARCHAR(100)') AS [SERVICEFACILITY!430!city],
	UPPER(ListServiceSite.[Address].value('(/Address/State)[1]', 'VARCHAR(100)')) AS [SERVICEFACILITY!430!state],
	ListServiceSite.[Address].value('(/Address/Zip)[1]', 'VARCHAR(100)') AS [SERVICEFACILITY!430!zip],
	dbo.stripSpecialChars(ListServiceSite.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)')) AS [SERVICEFACILITY!430!phone],

	ListServiceSiteType.ANSICode		AS [SERVICEFACILITY!430!siteType],

	[CLAIM!400!facilityPrimaryIDType] 		AS [SERVICEFACILITY!430!PrimaryIDType],
	[CLAIM!400!facilityPrimaryID] 			AS [SERVICEFACILITY!430!PrimaryID],
	[CLAIM!400!facilityIDType] 		AS [SERVICEFACILITY!430!IDType],
	[CLAIM!400!facilityID] 			AS [SERVICEFACILITY!430!ID],
    [FINANCIALCENTER!105!FCID]     AS  [FINANCIALCENTER!105!FCID],
	#XMLClaims_temp.[CLAIM!400!AccountID] as [CLAIM!400!AccountID],
	#XMLClaims_temp.[CLAIM!400!AccountPeriodID] as [CLAIM!400!AccountPeriodID]
FROM #XMLClaims_temp
	INNER JOIN ListServiceSite on ListServiceSite.ServiceSiteUid = #XMLClaims_temp.[SERVICEFACILITY!430!PID]
	LEFT JOIN ListServiceSiteType ON ListServiceSiteType.ServiceSiteTypeUid = ListServiceSite.ServiceSiteTypeUid
WHERE
	#XMLClaims_temp.tag = 400


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_PROVIDER]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_PROVIDER] AS' 
END
GO
/*
Modifications : Regarding DEFECT #9657	: 26 Feb 2007	: FIG
*/

ALTER PROC [dbo].[AR_genXMLClaims_PROVIDER]
AS
INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],
	--[CLAIM!400!PID],
	[PROVIDER!110!PID],
	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
	[BILLINGPROVIDER!120!FCID],
	[BILLINGPROVIDER!120!FileAsGroup],
	--[PAYTOPROVIDER!130!IDType],
	--[PAYTOPROVIDER!130!ID],
	
	--DEFECT #9657
	[PAYTOPROVIDER!130!NPISecIDType],
	[PAYTOPROVIDER!130!NPISecID],
	
	[BILLINGPROVIDER!120!IDType],
	[BILLINGPROVIDER!120!ID],
	
	--DEFECT #9657
	[BILLINGPROVIDER!120!NPISecIDType],
	[BILLINGPROVIDER!120!NPISecID],
    [FINANCIALCENTER!105!FCID]
)
SELECT DISTINCT
	110 								AS	Tag,
	105 								AS	parent,
	[SITE!100!PID]						AS	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID]			AS	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]	AS	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]		AS	[SITE!100!payToAddressID!hide],
	--[CLAIM!400!PID]					AS	[CLAIM!400!PID],
	[RENDERER!410!ID!hide]				AS	[PROVIDER!110!PID],
	[RENDERER!410!ID!hide]				AS	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID]					AS	[RENDERER!410!PEID],
	[BILLINGPROVIDER!120!FCID]			AS	[BILLINGPROVIDER!120!FCID],
	[BILLINGPROVIDER!120!FileAsGroup]	AS	[BILLINGPROVIDER!120!FileAsGroup],
	--[PAYTOPROVIDER!130!IDType] 			AS	[PAYTOPROVIDER!130!IDType],
	--[PAYTOPROVIDER!130!ID] 				AS	[PAYTOPROVIDER!130!ID],
	
	--DEFECT #9657
	[PAYTOPROVIDER!130!NPISecIDType]	AS	[PAYTOPROVIDER!130!NPISecIDType],
	[PAYTOPROVIDER!130!NPISecID]		AS	[PAYTOPROVIDER!130!NPISecID],

	[BILLINGPROVIDER!120!IDType] 		AS	[BILLINGPROVIDER!120!IDType],
	[BILLINGPROVIDER!120!ID] 			AS	[BILLINGPROVIDER!120!ID],
	
	--DEFECT #9657
	[BILLINGPROVIDER!120!NPISecIDType]	AS	[BILLINGPROVIDER!120!NPISecIDType],
	[BILLINGPROVIDER!120!NPISecID]		AS	[BILLINGPROVIDER!120!NPISecID],
    [FINANCIALCENTER!105!FCID]	        AS  [FINANCIALCENTER!105!FCID]
	
FROM #XMLClaims_temp
WHERE
	#XMLClaims_temp.tag = 400


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_PATIENT]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_PATIENT] AS' 
END
GO
ALTER PROC [dbo].[AR_genXMLClaims_PATIENT]
AS

-- test
declare @scrubsubscriber int
set @scrubsubscriber = 0
select @scrubsubscriber = coalesce(lpp.IntegerValue,0) from ListProductParameter lpp
							where ParameterName = 'Scrub.Subscriber' 
-- end test

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],
	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
	[CLAIM!400!PID],
	[SUBSCRIBER!200!PEID],
	[PATIENT!300!PEID],
	[PATIENT!300!prefix],
	[PATIENT!300!LN],
	[PATIENT!300!FN],
	[PATIENT!300!MI],
	[PATIENT!300!suffix],
	[PATIENT!300!gender],
	[PATIENT!300!birthdate],
	[PATIENT!300!deathdate],
	[PATIENT!300!employer],
	[PATIENT!300!address1],
	[PATIENT!300!address2],
	[PATIENT!300!city],
	[PATIENT!300!state],
	[PATIENT!300!zip],
	[PATIENT!300!phoneNumber],
	[PATIENT!300!rIDType],
	[PATIENT!300!rID],
	[PATIENT!300!IDType],
	[PATIENT!300!ID],
	[PATIENT!300!patientRelationToInsured],
	[PAYER!230!ID!hide],					
    [FINANCIALCENTER!105!FCID],
	[CLAIM!400!AccountID],
	[CLAIM!400!AccountPeriodID]
)
SELECT DISTINCT
	300 					AS tag,
	200 					AS parent,
	[SITE!100!PID]				AS  [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]		AS  [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]	AS  [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]		AS  [SITE!100!payToAddressID!hide],

	[RENDERER!410!ID!hide]			AS  [RENDERER!410!ID!hide],
	[RENDERER!410!PEID] 			AS  [RENDERER!410!PEID],
	[CLAIM!400!PID]			AS  [CLAIM!400!PID],
	[SUBSCRIBER!200!PEID]		AS  [SUBSCRIBER!200!PEID],
	
	Person.PersonUid			AS  [PATIENT!300!PEID],		--[PATIENT!300!PEID]
	' '					AS  [PATIENT!300!prefix],		-- As Medicare is rejecting the claims because of Mr and Mrs. now we are using as blank
	UPPER(Person.LastName)		AS  [PATIENT!300!LN],
	UPPER(Person.FirstName)		AS  [PATIENT!300!FN],
	UPPER(Person.MiddleName)		AS  [PATIENT!300!MI],
	Person.Suffix				AS  [PATIENT!300!suffix],
	ListGender.ANSICode			AS  [PATIENT!300!gender],
	CONVERT(VARCHAR(10),Person.BirthDate,101)	AS  [PATIENT!300!birthdate],
	CONVERT(VARCHAR(10),Person.deathdate,101)	AS  [PATIENT!300!deathdate],
	Corporation.Name			AS  [PATIENT!300!employer],  
	Person.Address1.value('(/Address/Address1)[1]', 'VARCHAR(100)') AS  [PATIENT!300!address1],
	Person.Address1.value('(/Address/Address2)[1]', 'VARCHAR(100)') AS  [PATIENT!300!address2],
	Person.Address1.value('(/Address/City)[1]', 'VARCHAR(100)') AS  [PATIENT!300!city],
	UPPER(Person.Address1.value('(/Address/State)[1]', 'VARCHAR(100)')) AS  [PATIENT!300!state],
	Person.Address1.value('(/Address/Zip)[1]', 'VARCHAR(100)') AS [PATIENT!300!zip],
	dbo.stripSpecialChars(Person.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)')) AS  [PATIENT!300!phoneNumber],
	
	'SY'							AS  [PATIENT!300!rIDType],
	dbo.stripSpecialChars(Person.SocialSecurityNumber)	AS  [PATIENT!300!rID],
	'MI'							AS  [PATIENT!300!IDType],
	dbo.stripSpecialChars([CLAIM!400!patientMemberID])	AS  [PATIENT!300!ID],

	[PATIENT!300!patientRelationToInsured],
	[PAYER!230!ID!hide]					AS [PAYER!230!ID!hide],			-- added by Shweta
     [FINANCIALCENTER!105!FCID] AS  [FINANCIALCENTER!105!FCID], 
	#XMLClaims_temp.[CLAIM!400!AccountID] AS [CLAIM!400!AccountID],
	#XMLClaims_temp.[CLAIM!400!AccountPeriodID] as [CLAIM!400!AccountPeriodID]
FROM #XMLClaims_temp
		LEFT JOIN Person ON Person.PersonUid = #XMLClaims_temp.[PATIENT!300!PEID]
		LEFT JOIN ListGender ON Person.GenderUid = ListGender.GenderUid
		LEFT JOIN Employer ON Person.PersonUid = Employer.CorporationUid
		LEFT JOIN Corporation ON Employer.CorporationUid = Corporation.CorporationUid
WHERE
	#XMLClaims_temp.tag = 400
	AND #XMLClaims_temp.[PATIENT!300!PEID] <> #XMLClaims_temp.[SUBSCRIBER!200!PEID]
	AND (@scrubsubscriber = 0 OR #XMLCLaims_temp.[PATIENT!300!patientRelationToInsured] <> 18 )

--select * 
--from 
--#XMLClaims_temp


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_SUBSCRIBER]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_SUBSCRIBER] AS' 
END
GO
ALTER PROC [dbo].[AR_genXMLClaims_SUBSCRIBER]
AS

/*
Modified On: 20050823
Modifications Made:	1. For handling WCC Case... OP values from Person or Corporation table.
			Corporation Name is populated in OrgName element
*/
-- 2016-07-11 Bug 36412 - Country Code

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],
	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
	[SUBSCRIBER!200!PEID],
	[PAYER!230!ID!hide],
	[PAYER!230!planType!hide],
	[SUBSCRIBER!200!prefix],
	[SUBSCRIBER!200!LN],
	[SUBSCRIBER!200!FN],
	[SUBSCRIBER!200!MI],
	[SUBSCRIBER!200!suffix],
	[SUBSCRIBER!200!gender],
	[SUBSCRIBER!200!birthdate],
	[SUBSCRIBER!200!employer],
	[SUBSCRIBER!200!occupation],
	[SUBSCRIBER!200!address1],
	[SUBSCRIBER!200!address2],
	[SUBSCRIBER!200!city],
	[SUBSCRIBER!200!state],
	[SUBSCRIBER!200!zip],
	[SUBSCRIBER!200!country],
	[SUBSCRIBER!200!phoneNumber],
	[SUBSCRIBER!200!rIDType],
	[SUBSCRIBER!200!rID],
	[SUBSCRIBER!200!IDType],
	[SUBSCRIBER!200!ID],
	[SUBSCRIBER!200!payerResponsibility],
	[SUBSCRIBER!200!DISPLAYORDER],
	[SUBSCRIBER!200!Phone1],
	[SUBSCRIBER!200!Phone1Type],
	[SUBSCRIBER!200!Phone2],
	[SUBSCRIBER!200!Phone2Type],
	[SUBSCRIBER!200!Email1],
	[SUBSCRIBER!200!SpecialCase],
	[SUBSCRIBER!200!groupID],	
	[SUBSCRIBER!200!groupName],	-- Added for AK Medicaid by Qatalys	
	[SUBSCRIBER!200!isWCC],		-- added by SM for WCC handling
    [FINANCIALCENTER!105!FCID],
	[SUBSCRIBER!200!AccountID],
	[SUBSCRIBER!200!AccountPeriodID],
	[CLAIM!400!AccountID],
	[CLAIM!400!AccountPeriodID]
)	
SELECT DISTINCT
	200 						AS tag,
	110 						AS parent,
	#XMLClaims_temp.[SITE!100!PID]		AS [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]			AS [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]		AS [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]			AS [SITE!100!payToAddressID!hide],

	[RENDERER!410!ID!hide]				AS [RENDERER!410!ID!hide],
	[RENDERER!410!PEID]				AS [RENDERER!410!PEID],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN Person.personUId 
		WHEN [SUBSCRIBER!200!isWCC] = 1 THEN inc.CorporationUid END AS [SUBSCRIBER!200!PEID],

	#XMLClaims_temp.[PAYER!230!ID!hide]		AS [PAYER!230!ID!hide],
	#XMLClaims_temp.[PAYER!230!planType!hide]	AS [PAYER!230!planType!hide],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN CAST( Person.prefix AS varchar(10))
		                                 ELSE NULL END AS [SUBSCRIBER!200!prefix],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN  UPPER(Person.LastName) 
		ELSE NULL END AS [SUBSCRIBER!200!LN],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN  UPPER(Person.FirstName) 
		ELSE NULL END AS [SUBSCRIBER!200!FN],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN UPPER(Person.MiddleName) 
		ELSE NULL END AS [SUBSCRIBER!200!MI],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN Person.suffix
		ELSE NULL END AS [SUBSCRIBER!200!suffix],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN ListGender.ANSICode
		ELSE NULL END AS [SUBSCRIBER!200!gender],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN CONVERT(VARCHAR, Person.birthdate,101)
		ELSE NULL END AS [SUBSCRIBER!200!birthdate],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN Corporation.Name 
		ELSE  inc.Name END AS [SUBSCRIBER!200!employer],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN CONVERT(VARCHAR(50),ListOccupation.Name) -- 57803
		ELSE NULL END AS [SUBSCRIBER!200!occupation],	

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		Person.Address1.value('(/Address/Address1)[1]', 'VARCHAR(100)')
	ELSE
		inc.[Address].value('(/Address/Address1)[1]', 'VARCHAR(100)')
	END AS [SUBSCRIBER!200!address1],
	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		Person.Address1.value('(/Address/Address2)[1]', 'VARCHAR(100)')
	ELSE
		inc.[Address].value('(/Address/Address2)[1]', 'VARCHAR(100)')
	END AS [SUBSCRIBER!200!address2],
	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		Person.Address1.value('(/Address/City)[1]', 'VARCHAR(100)')
	ELSE
		inc.[Address].value('(/Address/City)[1]', 'VARCHAR(100)')
	END AS [SUBSCRIBER!200!city],
	UPPER(CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		Person.Address1.value('(/Address/State)[1]', 'VARCHAR(100)')
	ELSE
		inc.[Address].value('(/Address/State)[1]', 'VARCHAR(100)')
	END) AS [SUBSCRIBER!200!state],
	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		Person.Address1.value('(/Address/Zip)[1]', 'VARCHAR(100)')
	ELSE
		inc.[Address].value('(/Address/Zip)[1]', 'VARCHAR(100)')
	END AS [SUBSCRIBER!200!zip],
	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		UPPER(LEFT(Person.Address1.value('(/Address/Country)[1]', 'VARCHAR(100)'), 2))
	ELSE
		UPPER(LEFT( inc.[Address].value('(/Address/Country)[1]', 'VARCHAR(100)'), 2))
	END AS [SUBSCRIBER!200!country],
	dbo.stripSpecialChars (CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		Person.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)')
	ELSE
		inc.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)')
	END) AS [SUBSCRIBER!200!phoneNumber],

	'SY'						AS [SUBSCRIBER!200!rIDType],
	dbo.stripSpecialChars(Person.SocialSecurityNumber) AS [SUBSCRIBER!200!rID],

	'MI'						AS [SUBSCRIBER!200!IDType],
	[CLAIM!400!subscriberMemberID] AS [SUBSCRIBER!200!ID],

	[SUBSCRIBER!200!payerResponsibility]		AS [SUBSCRIBER!200!payerResponsibility],
	[SUBSCRIBER!200!DISPLAYORDER] as [SUBSCRIBER!200!DISPLAYORDER],

	-- Phone1
	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		Person.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(20)')
	ELSE
		inc.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(20)')
	END AS [SUBSCRIBER!200!Phone1],
	-- Phone1Type
	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		Person.Phone1.value('(/Phone/PhoneType)[1]', 'VARCHAR(50)')
	ELSE
		inc.Phone1.value('(/Phone/PhoneType)[1]', 'VARCHAR(50)')
	END AS [SUBSCRIBER!200!Phone1Type],
	-- Phone2
	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		Person.Phone2.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(20)')
	ELSE
		inc.Phone2.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(20)')
	END AS [SUBSCRIBER!200!Phone2],
	-- Phone2Type
	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		Person.Phone2.value('(/Phone/PhoneType)[1]', 'VARCHAR(50)')
	ELSE
		inc.Phone2.value('(/Phone/PhoneType)[1]', 'VARCHAR(50)')
	END AS [SUBSCRIBER!200!Phone2Type],
	-- Email1
	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN Person.Email1 ELSE inc.Email1 END AS  [SUBSCRIBER!200!Email1],
    (Case WHEN ( pis.Value IS NOT NULL AND pis.Value like '%17667(True)%') THEN '31873' ELSE NULL END) AS [SUBSCRIBER!200!SpecialCase], -- See bug 31873

	[CLAIM!400!patientgroupID]			AS [SUBSCRIBER!200!groupID]
	,[CLAIM!400!patientgroupName]			As [SUBSCRIBER!200!groupName]	-- Added for AK Medicaid by Qatalys
	,[SUBSCRIBER!200!isWCC]			AS [SUBSCRIBER!200!isWCC],
    [FINANCIALCENTER!105!FCID]      AS  [FINANCIALCENTER!105!FCID],
	#XMLClaims_temp.[CLAIM!400!AccountID]			AS [SUBSCRIBER!200!ACCOUNTID],
	#XMLClaims_temp.[CLAIM!400!AccountPeriodID]		AS [SUBSCRIBER!200!AccountPeriodID],
	#XMLClaims_temp.[CLAIM!400!AccountID]			AS [CLAIM!400!ACCOUNTID],
	#XMLClaims_temp.[CLAIM!400!AccountPeriodID]		AS [CLAIM!400!AccountPeriodID]   

FROM #XMLClaims_temp
		INNER JOIN ClaimBatch cb with (nolock) on #XMLClaims_temp.[SITE!100!eClaimBatchGUID] = cb.ClaimBatchUid
		LEFT JOIN Person with (nolock) ON	Person.PersonUid = [SUBSCRIBER!200!PEID]
		LEFT JOIN ListGender with (nolock) ON	Person.GenderUid = ListGender.GenderUid
		-- in case Insured is an Organization
		LEFT JOIN Corporation inc with (nolock) ON 	inc.CorporationUid = [SUBSCRIBER!200!PEID]
		LEFT JOIN PersonEmployer (nolock)  ON	PersonEmployer.PersonUid = Person.PersonUid
		LEFT JOIN Corporation with (nolock) ON	PersonEmployer.EmployerUid = Corporation.CorporationUid
		LEFT JOIN ListOccupation with (nolock) ON PersonEmployer.OccupationUid = ListOccupation.OccupationUid
		LEFT OUTER JOIN PlugInSettings pis WITH (NOLOCK) on cb.ClaimClearingHouseUid = pis.ClaimClearingHouseUid															
																and pis.Name = 'SpecialCase'
WHERE
	#XMLClaims_temp.tag = 400 AND
	#XMLClaims_temp.[SUBSCRIBER!200!PEID] IS NOT NULL


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_SUPERVISING]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_SUPERVISING] AS' 
END
GO
/*  
Modifications : Regarding DEFECT #9657	: 26 Feb 2007	: FIG
				2014-05-29 Bug29864
*/  


ALTER PROC [dbo].[AR_genXMLClaims_SUPERVISING]
AS

--DEFECT #9657
DECLARE @ProviderNPIUid UNIQUEIDENTIFIER
SELECT @ProviderNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'Provider NPI' AND ISNULL(cfvt1.Inactive, 0) = 0		--EmployerGö£+Ñs Identification Number

DECLARE @EINUid UNIQUEIDENTIFIER
SELECT @EINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'ETIN' AND ISNULL(cfvt1.Inactive, 0) = 0		--EmployerGö£+Ñs Identification Number

DECLARE @UPINUid UNIQUEIDENTIFIER
SELECT @UPINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'UPIN' AND ISNULL(cfvt1.Inactive, 0) = 0

DECLARE @SSNUid UNIQUEIDENTIFIER
SELECT @SSNUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'SSN' AND ISNULL(cfvt1.Inactive, 0) = 0		

-- SUPERVISING!415
INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],
	[CLAIM!400!PID],
	[PATIENT!300!PEID],
	[SUBSCRIBER!200!PEID],
	[PAYER!230!ID!hide],		--added by Shweta
	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
	--[SUPERVISING!415!PEID],
	[SUPERVISING!415!PID],
	[SUPERVISING!415!LN],
	[SUPERVISING!415!FN],
	[SUPERVISING!415!MI],
	[SUPERVISING!415!orgName],
	[SUPERVISING!415!IDType],
	[SUPERVISING!415!ID],
	[SUPERVISING!415!rIDType],
	[SUPERVISING!415!rID],
	--[SUPERVISING!415!providerTaxonomyCode],
    [FINANCIALCENTER!105!FCID],
	[CLAIM!400!AccountID],
	[CLAIM!400!AccountPeriodID]    
)
SELECT
	415 						AS tag,
	400 						AS parent,
	[SITE!100!PID]					AS [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]			AS [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]		AS [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]			AS [SITE!100!payToAddressID!hide],
	[CLAIM!400!PID]				AS [CLAIM!400!PID],
	[PATIENT!300!PEID]				AS [PATIENT!300!PEID],
	[SUBSCRIBER!200!PEID]			AS [SUBSCRIBER!200!PEID],
	#XMLClaims_temp.[PAYER!230!ID!hide]		AS [PAYER!230!ID!hide],			-- added by Shweta

	[RENDERER!410!ID!hide]				AS [RENDERER!410!ID!hide],
	[RENDERER!410!PEID]				AS [RENDERER!410!PEID],

	--Provider.PersonUid				AS [SUPERVISING!415!PEID],

	Provider.PersonUid				AS [SUPERVISING!415!PID],

	UPPER(Person.LastName)			AS [SUPERVISING!415!LN],
	UPPER(Person.FirstName)			AS [SUPERVISING!415!FN],
	UPPER(Person.MiddleName)			AS [SUPERVISING!415!MI],

	NULL						AS [SUPERVISING!415!orgName],
    
	--DEFECT #9657
	CASE WHEN [CLAIM!400!SendNPI] = 1 THEN
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				'XX'
			 WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				'24'
			 ELSE
				'34'
		END	
	ELSE
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				'24'
			 ELSE
				'34'
		END			
	END
	AS [SUPERVISING!415!IDType],
	
	CASE WHEN [CLAIM!400!SendNPI] = 1 THEN
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid)
			WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN 
				dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			ELSE	
				COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'') 
		END
	ELSE
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN 
				dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			ELSE	
				COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'') 
		END
	END
	AS [SUPERVISING!415!ID],

--	'1G'						AS [REFERRER!420!rIDType],
--	dbo.stripSpecialChars(COALESCE(dbo.UDF_getFormatVaribleValue (0, @UPINUid,0,Provider.PersonUid,NULL,NULL,NULL) ,Provider.UPIN))		AS [REFERRER!420!rID]

(CASE WHEN dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
     ELSE InsurancePlan.ElectronicClaimFormatUid END,
     4,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) = '' THEN '1G'
  ELSE 
	dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
    ELSE InsurancePlan.ElectronicClaimFormatUid END,  
     5,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid)
 END) AS [SUPERVISING!415!rIDType],

(CASE WHEN dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
     ELSE InsurancePlan.ElectronicClaimFormatUid END,
     4,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) = '' THEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @UPINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) ,'')
ELSE 
	dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
     ELSE InsurancePlan.ElectronicClaimFormatUid END,
     4,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) 
END) AS [SUPERVISING!415!rID] ,
--ISNULL(ListSpecialty.ANSICode,'')				AS [REFERRER!415!providerTaxonomyCode],
      [FINANCIALCENTER!105!FCID]  AS   [FINANCIALCENTER!105!FCID], 
	[CLAIM!400!AccountID]						AS [CLAIM!400!AccountID],
	[CLAIM!400!AccountPeriodID]					AS [CLAIM!400!AccountPeriodID]
FROM #XMLClaims_temp
INNER JOIN Provider ON
	Provider.PersonUid = #XMLClaims_temp.[SUPERVISING!415!PID]
INNER JOIN Person ON
	Provider.PersonUid = Person.PersonUid
LEFT JOIN ListSpecialty ON 
	Provider.SpecialtyUid = ListSpecialty.SpecialtyUid
INNER JOIN Superbill ON 
	/*Superbill.ReferringProviderUid = #XMLClaims_temp.[SUPERVISING!415!PID] AND */Superbill.SuperbillUid = [CLAIM!400!PID]
INNER JOIN ViewSuperbillFinancialDetails on ViewSuperbillFinancialDetails.SuperbillUid = Superbill.SuperbillUid 	
INNER JOIN SuperbillUB ON SuperbillUB.SuperBillUID = ViewSuperbillFinancialDetails.SuperBillUID and SuperbillUB.SUPERVISINGProviderUID = #XMLClaims_temp.[SUPERVISING!415!PID]
INNER JOIN Claimbatchdetail ON 
	Claimbatchdetail.SuperbillUid = SuperbillUB.SuperbillUid AND Claimbatchdetail.ClaimBatchUID = [SITE!100!eClaimBatchGUID] 
  INNER JOIN account ON  
   account.accountUid = superbill.accountUid  
  INNER JOIN AccountResponsibleParty ON  
   Account.AccountResponsiblePartyUid = AccountResponsibleParty.AccountResponsiblePartyUid  
  INNER JOIN AccountPeriod ON  
   AccountPeriod.Accountuid = account.accountUid  
	AND ((AccountPeriod.effectiveDate IS NOT NULL AND AccountPeriod.ExpirationDate IS NULL AND AccountPeriod.effectiveDate <= superbill.serviceDateEnd)
	  OR (AccountPeriod.effectiveDate IS NULL AND AccountPeriod.ExpirationDate IS NOT NULL AND AccountPeriod.expirationDate >= superbill.serviceDateEnd) 
	  OR (AccountPeriod.effectiveDate IS NOT NULL AND AccountPeriod.ExpirationDate IS NOT NULL AND AccountPeriod.effectiveDate <= superbill.serviceDateEnd AND AccountPeriod.expirationDate >= superbill.serviceDateEnd) 
	  OR (AccountPeriod.effectiveDate IS NULL AND AccountPeriod.ExpirationDate IS NULL))
/*   AND (AccountPeriod.effectiveDate <= superbill.serviceDateEnd  
    AND (AccountPeriod.ExpirationDate IS NULL  
    OR AccountPeriod.ExpirationDate >= superbill.serviceDateEnd) OR AccountPeriod.effectiveDate IS NULL)  */
  INNER JOIN AccountInsurance  ON  
   AccountInsurance.AccountPeriodUid = AccountPeriod.AccountPeriodUid  
  INNER JOIN PersonInsurancePlan  
   ON PersonInsurancePlan.PersonInsurancePlanUid = AccountInsurance.PersonInsurancePlanUid  
   AND PersonInsurancePlan.InsurancePlanUid = Claimbatchdetail.InsurancePlanUid  
  INNER JOIN InsurancePlan  
   ON InsurancePlan.InsurancePlanUid = PersonInsurancePlan.InsurancePlanUid  
  INNER JOIN InsuranceCarrier  
   ON InsuranceCarrier.CorporationUid = InsurancePlan.InsuranceCarrierUid  	

WHERE
	#XMLClaims_temp.tag = 400

-- ORDERING!425
INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],
	[CLAIM!400!PID],
	[PATIENT!300!PEID],
	[SUBSCRIBER!200!PEID],
	[PAYER!230!ID!hide],		--added by Shweta
	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
	--[ORDERING!425!PEID],
	[ORDERING!425!PID],
	[ORDERING!425!LN],
	[ORDERING!425!FN],
	[ORDERING!425!MI],
	[ORDERING!425!orgName],
	[ORDERING!425!IDType],
	[ORDERING!425!ID],
	[ORDERING!425!rIDType],
	[ORDERING!425!rID],
	--[SUPERVISING!415!providerTaxonomyCode],
    [FINANCIALCENTER!105!FCID],
	[CLAIM!400!AccountID],
	[CLAIM!400!AccountPeriodID]    
)
SELECT
	425 						AS tag,
	400 						AS parent,
	[SITE!100!PID]					AS [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]			AS [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]		AS [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]			AS [SITE!100!payToAddressID!hide],
	[CLAIM!400!PID]				AS [CLAIM!400!PID],
	[PATIENT!300!PEID]				AS [PATIENT!300!PEID],
	[SUBSCRIBER!200!PEID]			AS [SUBSCRIBER!200!PEID],
	#XMLClaims_temp.[PAYER!230!ID!hide]		AS [PAYER!230!ID!hide],			

	[RENDERER!410!ID!hide]				AS [RENDERER!410!ID!hide],
	[RENDERER!410!PEID]				AS [RENDERER!410!PEID],

	Provider.PersonUid				AS [ORDERING!425!PID],

	UPPER(Person.LastName)			AS [ORDERING!425!LN],
	UPPER(Person.FirstName)			AS [ORDERING!425!FN],
	UPPER(Person.MiddleName)		AS [ORDERING!425!MI],
	NULL							AS [ORDERING!425!orgName],
    
	--DEFECT #9657
	CASE WHEN [CLAIM!400!SendNPI] = 1 THEN
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,Provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid) <> '' THEN
				'XX'
			 WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid) <> '' THEN
				'24'
			 ELSE
				'34'
		END	
	ELSE
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid) <> '' THEN
				'24'
			 ELSE
				'34'
		END			
	END
	AS [SUPERVISING!415!IDType],
	
	CASE WHEN [CLAIM!400!SendNPI] = 1 THEN
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,Provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid) <> '' THEN
				dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,Provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid)
			WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid) <> '' THEN
				dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid) <> '' THEN 
				dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			ELSE	
				COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'') 
		END
	ELSE
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid) <> '' THEN
				dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid) <> '' THEN 
				dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			ELSE	
				COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'') 
		END
	END
	AS [SUPERVISING!415!ID],

(CASE WHEN dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
     ELSE InsurancePlan.ElectronicClaimFormatUid END,
     4,provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid) = '' THEN '1G'
  ELSE 
	dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
    ELSE InsurancePlan.ElectronicClaimFormatUid END,  
     5,provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid)
 END) AS [SUPERVISING!415!rIDType],

(CASE WHEN dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
     ELSE InsurancePlan.ElectronicClaimFormatUid END,
     4,provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid) = '' THEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @UPINUid,0,Provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid) ,'')
ELSE 
	dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
     ELSE InsurancePlan.ElectronicClaimFormatUid END,
     4,provider.PersonUid,NULL,sba.serviceSiteUID,NULL,sba.FinancialCenterUid) 
END) AS [SUPERVISING!415!rID] ,
      [FINANCIALCENTER!105!FCID]  AS   [FINANCIALCENTER!105!FCID], 
	[CLAIM!400!AccountID]						AS [CLAIM!400!AccountID],
	[CLAIM!400!AccountPeriodID]					AS [CLAIM!400!AccountPeriodID]
FROM #XMLClaims_temp
	INNER JOIN Provider ON Provider.PersonUid = #XMLClaims_temp.[ORDERING!425!PID]
	INNER JOIN Person ON Provider.PersonUid = Person.PersonUid
	INNER JOIN Superbill ON Superbill.SuperbillUid = [CLAIM!400!PID]
	INNER JOIN SuperbillAggregate sba ON Superbill.SuperbillUid = sba.SuperbillUid	
	INNER JOIN Claimbatchdetail ON Claimbatchdetail.SuperbillUid = sba.SuperbillUid AND Claimbatchdetail.ClaimBatchUID = [SITE!100!eClaimBatchGUID] 
	INNER JOIN AccountPeriod ON sba.AccountPeriodUid = AccountPeriod.AccountPeriodUid
	  INNER JOIN AccountInsurance  ON  AccountInsurance.AccountPeriodUid = AccountPeriod.AccountPeriodUid  
	  INNER JOIN PersonInsurancePlan  ON PersonInsurancePlan.PersonInsurancePlanUid = AccountInsurance.PersonInsurancePlanUid  
										   AND PersonInsurancePlan.InsurancePlanUid = Claimbatchdetail.InsurancePlanUid  
	  INNER JOIN InsurancePlan ON InsurancePlan.InsurancePlanUid = PersonInsurancePlan.InsurancePlanUid  
	  INNER JOIN InsuranceCarrier  ON InsuranceCarrier.CorporationUid = InsurancePlan.InsuranceCarrierUid  	
	--LEFT JOIN ListSpecialty ON Provider.SpecialtyUid = ListSpecialty.SpecialtyUid

WHERE
	#XMLClaims_temp.tag = 400


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_REFERRER]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_REFERRER] AS' 
END
GO
ALTER PROC [dbo].[AR_genXMLClaims_REFERRER]
AS

DECLARE @ProviderNPIUid UNIQUEIDENTIFIER
SELECT @ProviderNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'Provider NPI' AND ISNULL(cfvt1.Inactive, 0) = 0		--EmployerGö£+Ñs Identification Number

DECLARE @EINUid UNIQUEIDENTIFIER
SELECT @EINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'ETIN' AND ISNULL(cfvt1.Inactive, 0) = 0		--EmployerGö£+Ñs Identification Number

DECLARE @UPINUid UNIQUEIDENTIFIER
SELECT @UPINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'UPIN' AND ISNULL(cfvt1.Inactive, 0) = 0

DECLARE @SSNUid UNIQUEIDENTIFIER
SELECT @SSNUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'SSN' AND ISNULL(cfvt1.Inactive, 0) = 0		

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],
	[CLAIM!400!PID],
	[PATIENT!300!PEID],
	[SUBSCRIBER!200!PEID],
	[PAYER!230!ID!hide],		
	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
	[REFERRER!420!PEID],
	[REFERRER!420!PID],
	[REFERRER!420!LN],
	[REFERRER!420!FN],
	[REFERRER!420!MI],
	[REFERRER!420!orgName],
	[REFERRER!420!IDType],
	[REFERRER!420!ID],
	[REFERRER!420!rIDType],
	[REFERRER!420!rID],
	[REFERRER!420!providerTaxonomyCode],
    [FINANCIALCENTER!105!FCID],
	[CLAIM!400!AccountID],
	[CLAIM!400!AccountPeriodID]
)
SELECT
	420 						AS tag,
	400 						AS parent,
	[SITE!100!PID]					AS [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]			AS [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]		AS [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]			AS [SITE!100!payToAddressID!hide],
	[CLAIM!400!PID]				AS [CLAIM!400!PID],
	[PATIENT!300!PEID]				AS [PATIENT!300!PEID],
	[SUBSCRIBER!200!PEID]			AS [SUBSCRIBER!200!PEID],
	#XMLClaims_temp.[PAYER!230!ID!hide]		AS [PAYER!230!ID!hide],			
	[RENDERER!410!ID!hide]				AS [RENDERER!410!ID!hide],
	[RENDERER!410!PEID]				AS [RENDERER!410!PEID],
	Provider.PersonUid				AS [REFERRER!420!PEID],
	Provider.PersonUid				AS [REFERRER!420!PID],
	UPPER(Person.LastName)			AS [REFERRER!420!LN],
	UPPER(Person.FirstName)			AS [REFERRER!420!FN],
	UPPER(Person.MiddleName)			AS [REFERRER!420!MI],
	NULL						AS [REFERRER!420!orgName],

	CASE WHEN [CLAIM!400!SendNPI] = 1 THEN
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				'XX'
			 WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				'24'
			 ELSE
				'34'
		END	
	ELSE
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				'24'
			 ELSE
				'34'
		END			
	END
	AS [REFERRER!420!IDType],
	
	CASE WHEN [CLAIM!400!SendNPI] = 1 THEN
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid)
			WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN 
				dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			ELSE	
				COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'') 
		END
	ELSE
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN 
				dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			ELSE	
				COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'') 
		END
	END
	AS [REFERRER!420!ID],

	(CASE WHEN dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
		 ELSE InsurancePlan.ElectronicClaimFormatUid END,
		 4,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) = '' THEN '1G'
	  ELSE 
		dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
		ELSE InsurancePlan.ElectronicClaimFormatUid END,  
		 5,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid)
	 END) AS [REFERRER!420!rIDType],

	(CASE WHEN dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
		 ELSE InsurancePlan.ElectronicClaimFormatUid END,
		 4,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) = '' THEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @UPINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) ,'')
	ELSE 
		dbo.UDF_getFormatVaribleValue(2,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
		 ELSE InsurancePlan.ElectronicClaimFormatUid END,
		 4,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) 
	END) AS [REFERRER!420!rID] ,
	ISNULL(ListSpecialty.ANSICode,'')				AS [REFERRER!420!providerTaxonomyCode],
      [FINANCIALCENTER!105!FCID]  AS   [FINANCIALCENTER!105!FCID],
	  #XMLClaims_temp.[CLAIM!400!AccountID] as [CLAIM!400!AccountID],
	  #XMLClaims_temp.[CLAIM!400!AccountPeriodID] AS [CLAIM!400!AccountPeriodID] 
FROM #XMLClaims_temp
	INNER JOIN Provider ON Provider.PersonUid = #XMLClaims_temp.[REFERRER!420!PID]
	INNER JOIN Person ON Provider.PersonUid = Person.PersonUid
	LEFT JOIN ListSpecialty ON Provider.SpecialtyUid = ListSpecialty.SpecialtyUid
	INNER JOIN Superbill ON Superbill.SuperbillUid = [CLAIM!400!PID]
	INNER JOIN Claimbatchdetail ON Claimbatchdetail.SuperbillUid = Superbill.SuperbillUid AND Claimbatchdetail.ClaimBatchUID = [SITE!100!eClaimBatchGUID] 
	INNER JOIN ViewSuperbillFinancialDetails ON ViewSuperbillFinancialDetails.SuperbillUid = Claimbatchdetail.SuperbillUid	
	INNER JOIN account ON  account.accountUid = superbill.accountUid  
	INNER JOIN AccountResponsibleParty ON  Account.AccountResponsiblePartyUid = AccountResponsibleParty.AccountResponsiblePartyUid  
	INNER JOIN AccountPeriod ON  AccountPeriod.Accountuid = account.accountUid  
									AND ((AccountPeriod.effectiveDate IS NOT NULL AND AccountPeriod.ExpirationDate IS NULL AND AccountPeriod.effectiveDate <= superbill.serviceDateEnd)
										OR (AccountPeriod.effectiveDate IS NULL AND AccountPeriod.ExpirationDate IS NOT NULL AND AccountPeriod.expirationDate >= superbill.serviceDateEnd) 
										OR (AccountPeriod.effectiveDate IS NOT NULL AND AccountPeriod.ExpirationDate IS NOT NULL AND AccountPeriod.effectiveDate <= superbill.serviceDateEnd AND AccountPeriod.expirationDate >= superbill.serviceDateEnd) 
										OR (AccountPeriod.effectiveDate IS NULL AND AccountPeriod.ExpirationDate IS NULL))
	INNER JOIN AccountInsurance  ON  AccountInsurance.AccountPeriodUid = AccountPeriod.AccountPeriodUid  
	INNER JOIN PersonInsurancePlan ON PersonInsurancePlan.PersonInsurancePlanUid = AccountInsurance.PersonInsurancePlanUid  
										AND PersonInsurancePlan.InsurancePlanUid = Claimbatchdetail.InsurancePlanUid  
	INNER JOIN InsurancePlan ON InsurancePlan.InsurancePlanUid = PersonInsurancePlan.InsurancePlanUid  
	INNER JOIN InsuranceCarrier  ON InsuranceCarrier.CorporationUid = InsurancePlan.InsuranceCarrierUid   	
WHERE
	#XMLClaims_temp.tag = 400


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_RENDERER]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_RENDERER] AS' 
END
GO
ALTER PROC [dbo].[AR_genXMLClaims_RENDERER]
AS

DECLARE @ProviderNPIUid UNIQUEIDENTIFIER
SELECT @ProviderNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'Provider NPI' AND ISNULL(cfvt1.Inactive, 0) = 0	

DECLARE @FinancialCenterNPIUid UNIQUEIDENTIFIER
 SELECT @FinancialCenterNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Financial Center NPI'  AND ISNULL(cfvt1.Inactive, 0) = 0  

DECLARE @EINUid UNIQUEIDENTIFIER
SELECT @EINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'ETIN' AND ISNULL(cfvt1.Inactive, 0) = 0	

DECLARE @FinancialCenterEINUid UNIQUEIDENTIFIER  
 SELECT @FinancialCenterEINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Financial Center ETIN'  AND ISNULL(cfvt1.Inactive, 0) = 0--EmployerGö£+Ñs Identification Number  

DECLARE @SSNUid UNIQUEIDENTIFIER
SELECT @SSNUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'SSN' AND ISNULL(cfvt1.Inactive, 0) = 0	

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],
	[CLAIM!400!PID],
	[PATIENT!300!PEID],
	[SUBSCRIBER!200!PEID],
	[PAYER!230!ID!hide],				
	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
	[RENDERER!410!LN],
	[RENDERER!410!FN],
	[RENDERER!410!MI],
	[RENDERER!410!address1],
	[RENDERER!410!address2],
	[RENDERER!410!city],
	[RENDERER!410!state],
	[RENDERER!410!zip],
	[RENDERER!410!dayPhone],
	[RENDERER!410!providerTaxonomyCode],
	[RENDERER!410!rIDType],
	[RENDERER!410!rID],
	[RENDERER!410!IDType],
	[RENDERER!410!ID],
	[RENDERER!410!CLIA],
	[RENDERER!410!MamographyCertNo],
	[RENDERER!410!SendCLIA],
	[RENDERER!410!SendMamographyCertNo],
    [FINANCIALCENTER!105!FCID],
	[CLAIM!400!AccountID],
	[CLAIM!400!AccountPeriodID]	
)
SELECT
	410 							AS tag,
	400 							AS parent,
	[SITE!100!PID]					AS [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]			AS [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]	AS [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]		AS [SITE!100!payToAddressID!hide],
	[CLAIM!400!PID]					AS [CLAIM!400!PID],
	[PATIENT!300!PEID]				AS [PATIENT!300!PEID],
	[SUBSCRIBER!200!PEID]			AS [SUBSCRIBER!200!PEID],
	#XMLClaims_temp.[PAYER!230!ID!hide]		AS [PAYER!230!ID!hide],			

	Provider.PersonUid				AS [RENDERER!410!ID!hide],
	Provider.PersonUid				AS [RENDERER!410!PEID],
	Person.LastName					AS [RENDERER!410!LN],
	Person.FirstName				AS [RENDERERE!410!FN],
	Person.MiddleName				AS [RENDERER!410!MI],
		Person.Address1.value('(/Address/Address1)[1]', 'VARCHAR(100)') AS [RENDERER!410!address1],
	Person.Address1.value('(/Address/Address2)[1]', 'VARCHAR(100)') AS [RENDERER!410!address2],
	Person.Address1.value('(/Address/City)[1]', 'VARCHAR(100)') AS [RENDERER!410!city],
	UPPER(Person.Address1.value('(/Address/State)[1]', 'VARCHAR(100)')) AS [RENDERER!410!state],
	Person.Address1.value('(/Address/Zip)[1]', 'VARCHAR(100)') AS [RENDERER!410!zip],
	dbo.stripSpecialChars(Person.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)')) AS [RENDERER!410!dayPhone],

	ISNULL(ListSpecialty.ANSICode,'')				AS [RENDERER!410!providerTaxonomyCode],
	[CLAIM!400!providerIDType]						AS [RENDERER!410!rIDType],
	[CLAIM!400!providerID]							AS [RENDERER!410!rID],

	CASE WHEN [CLAIM!400!SendNPI] = 1 THEN
		(CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid ,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), '') <> '' THEN
				'XX'
			  WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid ,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				'24'
			  WHEN [BILLINGPROVIDER!120!FileAsGroup] = 0 THEN 
				'34'
			  ELSE ''
		 END)	
	ELSE 
		(CASE WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid ,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				'24'
			  WHEN [BILLINGPROVIDER!120!FileAsGroup] = 0 THEN 
				'34'
			  ELSE ''
		 END)	
	END AS [RENDERER!410!IDType],

	CASE WHEN [CLAIM!400!SendNPI] = 1 THEN
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid ,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				dbo.UDF_getFormatVaribleValue (0, @ProviderNPIUid ,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid)
			WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid ,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				dbo.UDF_getFormatVaribleValue (0, @EINUid ,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			WHEN [BILLINGPROVIDER!120!FileAsGroup] = 0 THEN
				CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN 
						dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
					ELSE	
						COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'')
				END
			ELSE ''
		END	
	ELSE 
		CASE WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid ,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
				dbo.UDF_getFormatVaribleValue (0, @EINUid ,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
			WHEN [BILLINGPROVIDER!120!FileAsGroup] = 0 THEN
				CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN 
						dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
					ELSE	
						COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'')
				END
			ELSE ''
		END
	END AS [RENDERER!410!ID], 

   dbo.stripSpecialChars(dbo.UDF_getFormatVaribleValue(2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN 
           InsuranceCarrier.ElectronicClaimFormatUid ELSE InsurancePlan.ElectronicClaimFormatUid END,10,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid))
      AS [RENDERER!410!CLIA],
 
    dbo.stripSpecialChars(dbo.UDF_getFormatVaribleValue(2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN 
           InsuranceCarrier.ElectronicClaimFormatUid ELSE InsurancePlan.ElectronicClaimFormatUid END,11,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid))
      AS [RENDERER!410!MamographyCertNo],	
 
    dbo.UDF_SendValue(CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN 
           InsuranceCarrier.ElectronicClaimFormatUid ELSE InsurancePlan.ElectronicClaimFormatUid END,1,1,Superbill.SuperbillUid) AS [RENDERER!410!SendCLIA],

	dbo.UDF_SendValue(CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN 
           InsuranceCarrier.ElectronicClaimFormatUid ELSE InsurancePlan.ElectronicClaimFormatUid END,1,2,Superbill.SuperbillUid) AS  [RENDERER!410!SendMamographyCertNo],

      [FINANCIALCENTER!105!FCID]  AS  [FINANCIALCENTER!105!FCID],
	#XMLClaims_temp.[CLAIM!400!AccountID] as [CLAIM!400!AccountID],
	#XMLClaims_temp.[CLAIM!400!AccountPeriodID] as [CLAIM!400!AccountPeriodID]
FROM #XMLClaims_temp
	INNER JOIN Provider ON Provider.PersonUid = #XMLClaims_temp.[RENDERER!410!PEID]
	INNER JOIN Person ON Person.PersonUid = Provider.PersonUid
	LEFT JOIN ListSpecialty ON 	Provider.SpecialtyUid = ListSpecialty.SpecialtyUid
	LEFT JOIN ViewSuperbillFinancialDetails on ViewSuperbillFinancialDetails.SuperbillUid =  [CLAIM!400!PID] 
			AND ViewSuperbillFinancialDetails.ClaimingProviderUid = #XMLClaims_temp.[RENDERER!410!PEID] AND ViewSuperbillFinancialDetails.SuperbillUid = [CLAIM!400!PID]--2011 change
	LEFT JOIN Superbill ON Superbill.SuperbillUid = ViewSuperbillFinancialDetails.SuperbillUid --AND Superbill.SuperbillUid = [CLAIM!400!PID]	
	LEFT JOIN Claimbatchdetail ON Claimbatchdetail.SuperbillUid = Superbill.SuperbillUid AND Claimbatchdetail.ClaimBatchUID = [SITE!100!eClaimBatchGUID] 
	INNER JOIN InsurancePlan ON Claimbatchdetail.InsuranceplanUid=InsurancePlan.InsuranceplanUid 
	INNER JOIN InsuranceCarrier ON InsuranceCarrier.CorporationUid = #XMLClaims_temp.[PAYER!230!ID!hide]
WHERE
	#XMLClaims_temp.tag = 400


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_RESPONSIBLEPARTY]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_RESPONSIBLEPARTY] AS' 
END
GO
-- 2015-02-18 dsw 35524 (33744)- Remove validation check for Responsible Party information during EDI creation.

ALTER PROC [dbo].[AR_genXMLClaims_RESPONSIBLEPARTY]
AS
/*
	Note: Here we are assuming that ClaimPayerID is unique for all carriers. This conclusion has been deducted from 
		the PS - Stored Procedure
*/
	-- 35524 (33744)- Remove validation check for Responsible Party information during EDI creation.
	DECLARE @scrubResponsibleParty bit
	SELECT @scrubResponsibleParty = ( COALESCE( lpp.IntegerValue, 0 ) )
	FROM ListProductParameter lpp with (nolock) 
	WHERE lpp.ProductParameterUid = 'D913C232-E6B2-4D07-8231-043FD80609EF'
		AND lpp.ParameterName = 'Scrub.ResponsibleParty'

	INSERT INTO #XMLClaims_temp
	(
		tag,
		parent,
		[SITE!100!PID],
		[SITE!100!eClaimBatchGUID],
		[SITE!100!claimSubmitterID!hide],
		[SITE!100!payToAddressID!hide],
		[RENDERER!410!ID!hide],
		[RENDERER!410!PEID],
		[SUBSCRIBER!200!PEID],
		[RESPONSIBLEPARTY!240!ID!hide],
		[RESPONSIBLEPARTY!240!PEID],
		[RESPONSIBLEPARTY!240!prefix],
		[RESPONSIBLEPARTY!240!LN],
		[RESPONSIBLEPARTY!240!FN],
		[RESPONSIBLEPARTY!240!MI],
		[RESPONSIBLEPARTY!240!suffix],
		[RESPONSIBLEPARTY!240!address1],
		[RESPONSIBLEPARTY!240!address2],
		[RESPONSIBLEPARTY!240!city],
		[RESPONSIBLEPARTY!240!state],
		[RESPONSIBLEPARTY!240!zip],		
		[RESPONSIBLEPARTY!240!contactName],
		[RESPONSIBLEPARTY!240!contact1String],
		[RESPONSIBLEPARTY!240!isCorporation],
		[FINANCIALCENTER!105!FCID],
		[CLAIM!400!AccountID],
		[CLAIM!400!AccountPeriodID] 
	)
	SELECT DISTINCT
		240 						AS tag,
		200 						AS parent,

		#XMLClaims_temp.[SITE!100!PID]		AS [SITE!100!PID],
		[SITE!100!eClaimBatchGUID]			AS [SITE!100!eClaimBatchGUID],
		[SITE!100!claimSubmitterID!hide]		AS [SITE!100!claimSubmitterID!hide],
		[SITE!100!payToAddressID!hide]			AS [SITE!100!payToAddressID!hide],
		[RENDERER!410!ID!hide]				AS [RENDERER!410!ID!hide],
		[RENDERER!410!PEID]				AS [RENDERER!410!PEID],
		#XMLClaims_temp.[SUBSCRIBER!200!PEID] 	AS [SUBSCRIBER!200!PEID],

		
		CASE WHEN [RESPONSIBLEPARTY!240!isCorporation]	 = 0 THEN Person.personUId 
		WHEN [RESPONSIBLEPARTY!240!isCorporation]	 = 1 THEN Corporation.CorporationUid END 	[RESPONSIBLEPARTY!240!ID!hide],

		-- 35524 - Even though AccountResponsibleParty is different than subscriber, make it "appear" the same so Loop 2010BC does not output
		CASE WHEN @scrubResponsibleParty = 1                 THEN #XMLClaims_temp.[SUBSCRIBER!200!PEID] -- 35524 - 
		     WHEN [RESPONSIBLEPARTY!240!isCorporation]	 = 0 THEN Person.personUId 
		     WHEN [RESPONSIBLEPARTY!240!isCorporation]	 = 1 THEN Corporation.CorporationUid END 	AS [RESPONSIBLEPARTY!240!PEID],

		' '						AS [RESPONSIBLEPARTY!240!prefix],		-- As Medicare is rejecting the claims because of Mr and Mrs. now we are using as blank

		CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN  UPPER(Person.LastName) 
			ELSE CONVERT(VARCHAR(50), UPPER(Corporation.Name)) END 	  AS [RESPONSIBLEPARTY!240!LN],

		CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN  UPPER(Person.FirstName) 
			ELSE NULL END 				  AS [RESPONSIBLEPARTY!240!FN],

		CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN UPPER(Person.MiddleName) 
			ELSE NULL END 			 AS [RESPONSIBLEPARTY!240!MI],

		CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN UPPER(Person.Suffix) 
			 ELSE NULL END 			 AS [RESPONSIBLEPARTY!240!suffix],

		CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN
			Person.Address1.value('(/Address/Address1)[1]', 'VARCHAR(100)')
		ELSE
			Corporation.[Address].value('(/Address/Address1)[1]', 'VARCHAR(100)')
		END AS [RESPONSIBLEPARTY!240!address1],
		CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN
			Person.Address1.value('(/Address/Address2)[1]', 'VARCHAR(100)')
		ELSE
			Corporation.[Address].value('(/Address/Address2)[1]', 'VARCHAR(100)')
		END AS [RESPONSIBLEPARTY!240!address2],
		CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN
			Person.Address1.value('(/Address/City)[1]', 'VARCHAR(100)')
		ELSE
			Corporation.[Address].value('(/Address/City)[1]', 'VARCHAR(100)')
		END AS [RESPONSIBLEPARTY!240!city],
		UPPER(CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN
			Person.Address1.value('(/Address/State)[1]', 'VARCHAR(100)')
		ELSE
			Corporation.[Address].value('(/Address/State)[1]', 'VARCHAR(100)')
		END) AS [RESPONSIBLEPARTY!240!state],
		CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN
			Person.Address1.value('(/Address/Zip)[1]', 'VARCHAR(100)')
		ELSE
			Corporation.[Address].value('(/Address/Zip)[1]', 'VARCHAR(100)')
		END AS [RESPONSIBLEPARTY!240!zip],

		CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN  UPPER(COALESCE(Person.FirstName +' '+ Person.LastName, '')) 
			WHEN [RESPONSIBLEPARTY!240!isCorporation] = 1 THEN UPPER(COALESCE(Corporation.PrimaryContact, Corporation.SecondaryContact, ''))  END 	  											AS [RESPONSIBLEPARTY!240!contactName],

		dbo.stripSpecialChars(CASE WHEN [RESPONSIBLEPARTY!240!isCorporation] = 0 THEN
			Person.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)')
		ELSE
			Corporation.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)')
		END) AS [RESPONSIBLEPARTY!240!contact1String],

		[RESPONSIBLEPARTY!240!isCorporation]		AS [RESPONSIBLEPARTY!240!isCorporation],
        [FINANCIALCENTER!105!FCID]					AS [FINANCIALCENTER!105!FCID],   
		[CLAIM!400!AccountID] AS [CLAIM!400!AccountID],
		[CLAIM!400!AccountPeriodID] AS [CLAIM!400!AccountPeriodID] 
	FROM #XMLClaims_temp
			LEFT JOIN Person ON Person.PersonUid = [RESPONSIBLEPARTY!240!PEID]
			LEFT JOIN Corporation ON Corporation.CorporationUid = [RESPONSIBLEPARTY!240!PEID]
	WHERE
		tag  = 400
		AND #XMLClaims_temp.[RESPONSIBLEPARTY!240!PEID] IS NOT NULL


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_BILLINGPROVIDER]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_BILLINGPROVIDER] AS' 
END
GO
/*
Modifications : Regarding DEFECT #9657	: 26 Feb 2007	: FIG
*/

ALTER PROC [dbo].[AR_genXMLClaims_BILLINGPROVIDER]
 AS
--1 BILLINGPROVIDER (claimSubmitter) / PAYTOPROVIDER (payToAddress)
-- payToSSID,billingSSID

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],
	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
	[BILLINGPROVIDER!120!FCID],
	[BILLINGPROVIDER!120!FileAsGroup],
	[BILLINGPROVIDER!120!PID],
	--[BILLINGPROVIDER!120!orgName],
	[BILLINGPROVIDER!120!LN],
	[BILLINGPROVIDER!120!FN],
	[BILLINGPROVIDER!120!MI],
	[BILLINGPROVIDER!120!address1],
	[BILLINGPROVIDER!120!address2],
	[BILLINGPROVIDER!120!city],
	[BILLINGPROVIDER!120!state],
	[BILLINGPROVIDER!120!zip],
	[BILLINGPROVIDER!120!phone],
	[BILLINGPROVIDER!120!siteType],
	[BILLINGPROVIDER!120!IDType],
	[BILLINGPROVIDER!120!ID],	
	--DEFECT #9657
	[BILLINGPROVIDER!120!NPISecIDType],
    [BILLINGPROVIDER!120!NPISecID],

	[BILLINGPROVIDER!120!LocationNo],
    [FINANCIALCENTER!105!FCID]
)
SELECT
	120 					AS Tag,
	110 					AS parent,

	[SITE!100!PID]				AS [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]		AS [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]		AS [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]		AS [SITE!100!payToAddressID!hide],
	[RENDERER!410!ID!hide]			AS [RENDERER!410!ID!hide],
	[RENDERER!410!PEID]			AS [RENDERER!410!PEID],
	[BILLINGPROVIDER!120!FCID]	AS [BILLINGPROVIDER!120!FCID],
	[BILLINGPROVIDER!120!FileAsGroup]	AS	[BILLINGPROVIDER!120!FileAsGroup],

	CASE WHEN [BILLINGPROVIDER!120!FileAsGroup] = 1 THEN Fc.FinancialCenterUid
			ELSE Per.PersonUid  END		AS [BILLINGPROVIDER!120!PID],
	CASE WHEN [BILLINGPROVIDER!120!FileAsGroup] =  1 THEN  UPPER(Fc.Name)
			ELSE  UPPER(Per.LastName) END 	    AS [BILLINGPROVIDER!120!LN],	
	CASE [BILLINGPROVIDER!120!FileAsGroup] WHEN 1 THEN   NULL
			ELSE UPPER(Per.FirstName) END 	AS [BILLINGPROVIDER!120!FN],
	CASE [BILLINGPROVIDER!120!FileAsGroup] WHEN 1 THEN  NULL
			ELSE UPPER(Per.MiddleName)  END 	AS [BILLINGPROVIDER!120!MI],	

	CASE WHEN [BILLINGPROVIDER!120!FileAsGroup] = 1 THEN Fc.[Address].value('(/Address/Address1)[1]', 'VARCHAR(100)')
													ELSE Per.Address1.value('(/Address/Address1)[1]', 'VARCHAR(100)') 
	END AS [BILLINGPROVIDER!120!address1],
	CASE WHEN [BILLINGPROVIDER!120!FileAsGroup] = 1 THEN Fc.[Address].value('(/Address/Address2)[1]', 'VARCHAR(100)')
													ELSE Per.Address1.value('(/Address/Address2)[1]', 'VARCHAR(100)') 
	END AS [BILLINGPROVIDER!120!address2],											
	CASE WHEN [BILLINGPROVIDER!120!FileAsGroup] = 1 THEN Fc.[Address].value('(/Address/City)[1]', 'VARCHAR(100)')
													ELSE Per.Address1.value('(/Address/City)[1]', 'VARCHAR(100)') 
	END AS [BILLINGPROVIDER!120!city],
	UPPER(CASE WHEN [BILLINGPROVIDER!120!FileAsGroup] = 1 THEN Fc.[Address].value('(/Address/State)[1]', 'VARCHAR(100)')
													ELSE Per.Address1.value('(/Address/State)[1]', 'VARCHAR(100)') 
	END) AS [BILLINGPROVIDER!120!state],
	CASE WHEN [BILLINGPROVIDER!120!FileAsGroup] = 1 THEN Fc.[Address].value('(/Address/Zip)[1]', 'VARCHAR(100)')
													ELSE Per.Address1.value('(/Address/Zip)[1]', 'VARCHAR(100)') 
	END AS [BILLINGPROVIDER!120!zip],
	dbo.stripSpecialChars(COALESCE(CASE WHEN [BILLINGPROVIDER!120!FileAsGroup] = 1 THEN Fc.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)') ELSE per.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)') END,'')) AS [BILLINGPROVIDER!120!phone],
	ListServiceSiteType.ANSICode		AS [BILLINGPROVIDER!120!siteType],

	[BILLINGPROVIDER!120!IDType]		AS [BILLINGPROVIDER!120!IDType],
	[BILLINGPROVIDER!120!ID]			 AS [BILLINGPROVIDER!120!ID],	

	--DEFECT #9657
	[BILLINGPROVIDER!120!NPISecIDType]	AS [BILLINGPROVIDER!120!NPISecIDType],
	[BILLINGPROVIDER!120!NPISecID]  	AS [BILLINGPROVIDER!120!NPISecID],

	'0001'					AS [BILLINGPROVIDER!120!LocationNo],
    [FINANCIALCENTER!105!FCID] AS [FINANCIALCENTER!105!FCID]

FROM #XMLClaims_temp

INNER JOIN dbo.claimsubmitter ON
	claimSubmitter.ClaimSubmitterUid = #XMLClaims_temp.[SITE!100!claimSubmitterID!hide]

INNER JOIN Person Per ON Per.PersonUid = [RENDERER!410!PEID]

INNER JOIN FinancialCenter Fc ON Fc.FinancialCenterUid = [BILLINGPROVIDER!120!FCID]



LEFT JOIN ListServiceSite ON
	ListServiceSite.serviceSiteUid = claimSubmitter.ClaimSubmitterServiceSiteUid


LEFT JOIN ListServiceSiteType ON
	ListServiceSite.ServiceSiteTypeUid = ListServiceSiteType.ServiceSiteTypeUid
	
WHERE
	#XMLClaims_temp.tag = 110


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_CLAIM]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_CLAIM] AS' 
END
GO
ALTER PROC [dbo].[AR_genXMLClaims_CLAIM]
 @ClaimBatchUid UniqueIdentifier,  
 @claimsFetched int = 0 output  
WITH RECOMPILE AS
/*  
********************************************************************
CYS SC 07/23/09 - Added for Service Site bug (CYS Case #22420):
	[CLAIM!400!BillingProvider_IDType] VARCHAR(50)
	[CLAIM!400!BillingProvider_ID] VARCHAR(50)
CYS SC 07/23/09 - Added logic for Service Site NPI Overrides to:
	[BILLINGPROVIDER!120!IDType] and [BILLINGPROVIDER!120!ID] 
********************************************************************
CYS SC 10/22/09 - Remove NF ContractTypeCodes from TotalBill calc
Modified On: 20051011  
Modifications Made: 2. Modified for Accident date  
   1. For handling WCC Case... setting isWCC column : 20050823  

Modifications : Regarding DEFECT #9657	: 26 Feb 2007	: FIG
*/  
 
--DEFECT #9657
 DECLARE @ProviderNPIUid UNIQUEIDENTIFIER
 SELECT @ProviderNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 WITH (NOLOCK) 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt WITH (NOLOCK) ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Provider NPI'  AND ISNULL(cfvt1.Inactive, 0) = 0  

 DECLARE @ServiceSiteNPIUid UNIQUEIDENTIFIER
 SELECT @ServiceSiteNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 WITH (NOLOCK)   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt WITH (NOLOCK) ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Service Site NPI'  AND ISNULL(cfvt1.Inactive, 0) = 0  

DECLARE @PayToProviderNPIUid UNIQUEIDENTIFIER
 SELECT @PayToProviderNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1  WITH (NOLOCK)  
		INNER JOIN ListClaimFormatValueTypeType lcfvtt WITH (NOLOCK) ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Pay To Provider NPI'  AND ISNULL(cfvt1.Inactive, 0) = 0  

 DECLARE @FinancialCenterNPIUid UNIQUEIDENTIFIER
 SELECT @FinancialCenterNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 WITH (NOLOCK)   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt WITH (NOLOCK) ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Financial Center NPI'  AND ISNULL(cfvt1.Inactive, 0) = 0  

 DECLARE @SSNUid UNIQUEIDENTIFIER
 SELECT @SSNUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 WITH (NOLOCK) 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt WITH (NOLOCK) ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'SSN' AND ISNULL(cfvt1.Inactive, 0) = 0	
 
 DECLARE @EINUid UNIQUEIDENTIFIER  
 SELECT @EINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 WITH (NOLOCK)   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt WITH (NOLOCK) ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'ETIN'  AND ISNULL(cfvt1.Inactive, 0) = 0--EmployerGö£+Ñs Identification Number  

 DECLARE @FinancialCenterEINUid UNIQUEIDENTIFIER  
 SELECT @FinancialCenterEINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 WITH (NOLOCK) 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt WITH (NOLOCK) ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Financial Center ETIN'  AND ISNULL(cfvt1.Inactive, 0) = 0--EmployerGö£+Ñs Identification Number  
 
-- test
declare @scrubsubscriber int
set @scrubsubscriber = 0
select @scrubsubscriber = coalesce(lpp.IntegerValue,0) from ListProductParameter lpp
							where ParameterName = 'Scrub.Subscriber' 
-- end test
 
  Declare @ecf TABLE 
 ( 
   SuperbillUid uniqueidentifier, 
   ElectronicClaimFormatUid uniqueidentifier,
   GroupOrInd varchar(255),
   IsIndividual bit,
   filingTypeSSN bit, 
   SSN	varchar(255),
   NPIOverrideUid uniqueidentifier,		-- Guid of ClaimFormatValueType for NPI override on a specific ElectronicClaimFormat 
   NPIOverrideFixedValue varchar(255)	-- Fixed value for NPI override on a specific ElectronicClaimFormat
   ,SVCodes varchar(500)                 -- Fixed value for Code Descr.SV101/SV202 override on a specific ElectronicClaimFormat

 ) ;
 INSERT INTO @ecf( SuperbillUid, ElectronicClaimFormatUid, filingTypeSSN )
	 SELECT sb.SuperbillUid,
	        CASE WHEN ip.UseCarrierElectronicClaimFormat = 1 
				 THEN ic.ElectronicClaimFormatUid  
 				 ELSE ip.ElectronicClaimFormatUid END AS ElectronicClaimFormatUid,
 			0 as filingTypeSSN			-- default is to file for EIN for both group and individual filing types
  FROM #XMLClaims_temp  
  INNER JOIN ClaimBatch cb WITH (NOLOCK) ON cb.ClaimBatchUid = #XMLClaims_temp.[SITE!100!eClaimBatchGUID]  
  INNER JOIN ClaimBatchDetail cbd WITH (NOLOCK) ON cbd.ClaimBatchUid = cb.ClaimBatchUid   
  INNER JOIN superbill sb WITH (NOLOCK) on sb.SuperbillUid = cbd.SuperbillUid --2011 change 
  INNER JOIN SuperbillAggregate sba WITH (NOLOCK) ON sb.SuperbillUid = sba.SuperbillUid  
  INNER JOIN account act WITH (NOLOCK) ON act.accountUid = sb.accountUid  
  INNER JOIN AccountInsurance  ai WITH (NOLOCK) ON ai.AccountPeriodUid = sba.AccountPeriodUid --ap.AccountPeriodUid 
											AND sba.CurrentCarrier = ai.DisplayOrder   
  INNER JOIN PersonInsurancePlan pip WITH (NOLOCK) ON pip.PersonInsurancePlanUid = ai.PersonInsurancePlanUid  
											--AND pip.InsurancePlanUid = cbd.InsurancePlanUid  
  INNER JOIN InsurancePlan ip WITH (NOLOCK) ON ip.InsurancePlanUid = pip.InsurancePlanUid  
  INNER JOIN InsuranceCarrier ic WITH (NOLOCK) ON ic.CorporationUid = ip.InsuranceCarrierUid   
  LEFT JOIN ViewSuperbillCurrentLiabilityOwnerAndCarrier cl WITH (NOLOCK) ON sb.superbillUid = cl.superbillUid
WHERE  
  #XMLClaims_temp.tag = 100  --and ai.DisplayOrder = cl.CurrentCarrier-- this will make sure that we select current carrier when primary and secondary are the same
 
  --select * from @ecf
  
  Update @ecf
	Set GroupOrInd=	dbo.UDF_getFormatVaribleValue (2, ecf.ElectronicClaimFormatUid ,9,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), -- Electronic==2, Filing Type = 9
	    filingTypeSSN = dbo.UDF_getFormatVariableValue2 (2, ecf.ElectronicClaimFormatUid ,9,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), -- Electronic==2, Filing Type=9, Get Value2 ( If 1 then SSN else EIN )
		SSN = COALESCE ( NULLIF(dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), ''),
		                 ISNULL(p.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,''))
 FROM @ecf ecf
	INNER JOIN superbill sb on ecf.SuperbillUid = sb.SuperbillUid 
    INNER JOIN ViewSuperbillFinancialDetails ON ViewSuperbillFinancialDetails.superbillUid = sb.SuperbillUid and sb.claimPaper=0 -- Confirm that the drop to paper override isn't set.  
    INNER JOIN provider ON provider.PersonUID = ViewSuperbillFinancialDetails.ClaimingProviderUid    --We have to use RenderingProviderUid  :Aji 2005 10 21 
    INNER JOIN Person p on Provider.PersonUid = p.PersonUid 
	
  Update @ecf
	SET IsIndividual= CASE (ecf.GroupOrInd) WHEN '1' THEN 1
										    WHEN 'individual' THEN 1
										    ELSE 0 END
  FROM @ecf ecf 
  			
  --select * from @ecf
  
-- Find the NPI Override for the ListClaimFormat ( if one exists )
  UPDATE @ecf
	SET NPIOverrideUid = cfvt.ClaimFormatValueTypeUid,
		NPIOverrideFixedValue = cfo.FixedValue
	FROM @ecf ecf
			INNER JOIN ClaimFormatOption cfo WITH (NOLOCK) ON ecf.ElectronicClaimFormatUid = cfo.ClaimFormatUid
			INNER JOIN ListClaimFormatOptionType cfot WITH (NOLOCK) ON cfot.ClaimFormatOptionTypeUid = cfo.ClaimFormatOptionTypeUid
			INNER JOIN ListClaimFormatValueType cfvt WITH (NOLOCK) on cfo.ClaimFormatValueTypeUid = cfvt.ClaimFormatValueTypeUid
	WHERE cfo.ClaimFormatUid = ecf.ElectronicClaimFormatUid								-- cf.Name = 'e-Medicare'
 			--and cfot.ClaimFormatOptionTypeUid = '39EAD079-2603-4D12-9D94-C96585C39185'	-- cfot.Name = 'NPI Override'
			and cfot.Name = 'NPI Override'

  UPDATE @ecf
	SET SVCodes = cfo.Codes
	FROM @ecf ecf
	        inner join ListClaimFormat lcf on ecf.ElectronicClaimFormatUid = lcf.ClaimFormatUid  AND lcf.ClaimFormatTypeUid IN ('0BAF0B1A-48E6-403A-8981-2B58618DFC07') -- Electronic 837
			INNER JOIN ClaimFormatOption cfo WITH (NOLOCK) ON ecf.ElectronicClaimFormatUid = cfo.ClaimFormatUid
	WHERE   cfo.ClaimFormatUid = ecf.ElectronicClaimFormatUid								-- cf.Name = 'e-Medicare'
 			and cfo.ClaimFormatOptionTypeUid = '187D0379-3336-4CC9-82D4-4252B6A5EDDE'	-- cfot.Name = 'Code Descr.SV101/SV202'
 
   --select * from @ecf
 
 -- end test
 SET @claimsFetched =0  
 INSERT INTO #XMLClaims_temp  
 (  
  tag,  
  parent,  
  [SITE!100!PID],  
  [SITE!100!eClaimBatchGUID],  
  [SITE!100!claimSubmitterID!hide],  
  [SITE!100!payToAddressID!hide],  
  [CLAIM!400!PID],  
  [CLAIM!400!accountNumber],  
  [CLAIM!400!MedicalRecordNumber], -- Added for Ak Medicaid by Qatalys
  [CLAIM!400!totalBill],  
  [CLAIM!400!diag1],  
  [CLAIM!400!diag2],  
  [CLAIM!400!diag3],  
  [CLAIM!400!diag4],  
  [CLAIM!400!diag5],  
  [CLAIM!400!diag6],  
  [CLAIM!400!diag7],  
  [CLAIM!400!diag8],  
  [CLAIM!400!diag9],  
  [CLAIM!400!diag10],  
  [CLAIM!400!diag11],  
  [CLAIM!400!diag12], 
  [PAYER!230!ID!hide],  
  [PAYER!230!planType!hide],  
  [PATIENT!300!PEID],  
  [SUBSCRIBER!200!PEID],  
  [RESPONSIBLEPARTY!240!ID!hide],
  [RESPONSIBLEPARTY!240!PEID],			--Added by AW for 2010BC loop  2006 03 15
  [SUBSCRIBER!200!payerResponsibility],
  [SUBSCRIBER!200!DisplayOrder], --ADDED FOR SECONDARY CLAIMS   
  [PATIENT!300!patientRelationToInsured],  
  [CLAIM!400!patientMemberID],  
  [CLAIM!400!patientgroupID],  
  [CLAIM!400!patientgroupName],			-- Added for AK Medicaid by Qatalys
  [CLAIM!400!subscriberMemberID],  
  [CLAIM!400!authorizeAssignment],  
  [RENDERER!410!ID!hide],  
  [RENDERER!410!PEID],  
  [SUPERVISING!415!PID], 
  [ORDERING!425!PID], 
  [BILLINGPROVIDER!120!FCID],
  [BILLINGPROVIDER!120!FileAsGroup], 
  [REFERRER!420!PID],  
  [CLAIM!400!providerID],  
  [CLAIM!400!providerIDType],  
  [CLAIM!400!providerGroupID],  
  [CLAIM!400!providerGroupIDType],
  [CLAIM!400!providerGroupID2],  
  [CLAIM!400!providerGroupIDType2],
  [CLAIM!400!facilityPrimaryID],
  [CLAIM!400!facilityPrimaryIDType],
  [CLAIM!400!facilityID],  
  [CLAIM!400!facilityIDType],
  [PAYTOPROVIDER!130!IDType],  
  [PAYTOPROVIDER!130!ID], 
  [PAYTOPROVIDER!130!NPISecIDType],
  [PAYTOPROVIDER!130!NPISecID],
  [BILLINGPROVIDER!120!IDType],  
  [BILLINGPROVIDER!120!ID],
  [BILLINGPROVIDER!120!NPISecIDType],
  [BILLINGPROVIDER!120!NPISecID],
  [PROC!450!emergency],  
  [CLAIM!400!claimFrequencyCode],  
  [CLAIM!400!providerSignatureOnFile],  
  [CLAIM!400!patientAcceptAssignment],  
  [CLAIM!400!releaseOfInformation],  
  [CLAIM!400!patientSignatureSource],  
  [CLAIM!400!patientSignatureDate],  
  [CLAIM!400!siteType],  
  [CLAIM!400!relatedCausesCode],  
  [CLAIM!400!accidentState],  
  [CLAIM!400!accidentDate],   
  [CLAIM!400!onsetCurrentDate],  
  [CLAIM!400!onsetFirstDate],  
  [CLAIM!400!onsetFirstDateQualifier], -- dsw 09/24/2018, 11329
  [CLAIM!400!noWorkFromDate],  
  [CLAIM!400!noWorkToDate],  
  [CLAIM!400!hospitalizationStartDate],  
  [CLAIM!400!hospitalizationEndDate],
  [CLAIM!400!InitialTreatmentDate],  
  [CLAIM!400!familyPlan], 
  [CLAIM!400!ClaimNote],	-- Added for AK Medicaid by Qatalys 
  [CLAIM!400!Note],      -- Igor 9/29/09 per 2517 had to add this so that AK Medicaid code will not be broken		
  [CLAIM!400!NoteReferenceCode],--2517 added 09/28/2009	
  [CLAIM!400!priorAuthorizationCode],	
  [CLAIM!400!SendNPI],
  [CLAIM!400!Dmerc], 	
  [CLAIM!400!SendPQRIproc],
  [CLAIM!400!Output2310D],
  [CLAIM!400!OutputAAE], --bug 5129
  [CLAIM!400!OutputPR], --added 5/9/2011
  [CLAIM!400!ICN],	--ADDED ICN NUMBER REPORTED IN LOOP 2300 6/19/08
  [CLAIM!400!EPSDT] ,   --added 07/21/09 bug 1430
  [CLAIM!400!EPSDTReferralCondIndicator1] ,--added 07/21/09  bug 1430
  [CLAIM!400!EPSDTReferralCondIndicator2],--added 07/21/09  bug 1430
  [CLAIM!400!EPSDTReferralCondIndicator3] ,--added 07/21/09 bug 1430
  [CLAIM!400!EPSDTReferralCondIndicator4] ,--added 07/21/09 bug 1430
  [CLAIM!400!InsuranceTypeCode],
  [CLAIM!400!AuthReferralIndicator] , --bug 2570
  [CLAIM!400!BillingProvider_IDType],  
  [CLAIM!400!BillingProvider_ID],		 
  [CLAIM!400!LMPDate],
  [CLAIM!400!UserDefinedXml],
  [CLAIM!400!ResubmissionCode],
  [CLAIM!400!DelayReasonCode] , --bug 869
  [CLAIM!400!DateLastSeenBySupervising] , --bug 249	
  [CLAIM!400!SecPayerID] ,
  [CLAIM!400!SecPayerCode],
  [CLAIM!400!AssumedDate],
  [CLAIM!400!RelinquishedDate],
  [CLAIM!400!PatientPaidAmount],  
  [SERVICEFACILITY!430!PID],  
  [PROC!450!serviceLocation] ,
  [PROC!450!lineControlNo],
  [SUBSCRIBER!200!isWCC],  -- added by SM   
  [RESPONSIBLEPARTY!240!isCorporation],			--Added by AW for 2010BC loop  2006 03 15
  [FINANCIALCENTER!105!FCID],
  [CLAIM!400!AccountID],
  [CLAIM!400!AccountName],
  [ClAIM!400!AccountPeriodID],
  [CLAIM!400!PaperworkTypeID],
  [CLAIM!400!PaperworkTransmissionCodeID],
  [CLAIM!400!PaperworkControlNum],
  [CLAIM!400!Allow5010Codes],
  [CLAIM!400!UseICD10],
  [CLAIM!400!ElectronicClaimFormatUid],
  [CLAIM!400!ReleaseClaimAndIgnoreComplianceErrors]
  ,[CLAIM!400!SVCodes]
  )  
  SELECT DISTINCT  
  400     AS tag, 
  -- test
  -- (CASE WHEN account.personUID = COALESCE(PersonInsurancePlan.PersonUid, PersonInsurancePlan.CorporationUid) THEN 200 ELSE 300  END)      AS parent,  
  
  (CASE WHEN @scrubsubscriber = 2 and ListRelationship.ANSICode  = '18' THEN 200
        WHEN @scrubsubscriber = 2 and ListRelationship.ANSICode <> '18' THEN 300
        WHEN account.personUID = COALESCE(PersonInsurancePlan.PersonUid, PersonInsurancePlan.CorporationUid) THEN 200 
		ELSE 300  END)      AS parent,  
  [SITE!100!PID]    AS [SITE!100!PID],   
  [SITE!100!eClaimBatchGUID]  AS [SITE!100!eClaimBatchGUID],    
  [SITE!100!claimSubmitterID!hide] AS [SITE!100!claimSubmitterID!hide],   
  [SITE!100!payToAddressID!hide]  AS [SITE!100!payToAddressID!hide],   
  superbill.SuperbillUid   AS [CLAIM!400!PID],  --SuperbillUid  
  CONVERT(VARCHAR(50),superbill.externalID) AS [CLAIM!400!accountNumber],  
  CONVERT(VARCHAR(50),Patient.MedicalRecordNumber) AS [CLAIM!400!MedicalRecordNumber],
  --CAST((SELECT SUM(ISNULL(TotalCharge,0)) FROM SuperbillProcedure sbp   
		--	LEFT JOIN ListContractTypeCode ON ListContractTypeCode.ContractTypeCodeUid = sbp.ContractTypeCodeUid
		--	LEFT JOIN ListProcedure on ListProcedure.ProcedureUID = sbp.ProcedureUID
		--	INNER JOIN ViewSuperbillProcedure_IsVoid on ViewSuperbillProcedure_IsVoid.SuperbillProcedureUid = sbp.SuperbillProcedureUid  --added per bug 9450
		--	WHERE sbp.SuperbillUid = superbill.superbillUid AND /*--added per bug 9450*/ViewSuperbillProcedure_IsVoid.IsVoid = '0' AND 
		--		(ISNULL(ListContractTypeCode.Name,'') <> 'NF' AND ISNULL(ListContractTypeCode.ANSICode,'') <> 'NF') AND
		--			ISNULL(sbp.DontClaim, 0) = 0 ) 
		--AS VARCHAR(50)) AS [CLAIM!400!totalBill],  
	0 AS [CLAIM!400!totalBill],  -- Now calculated in AR_genXMLClaims_Proc
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart THEN NULLIF( COALESCE(sbd1.Code10, sbd1.Code9), '' ) ELSE NULLIF( sbd1.Code9, '' ) END AS [CLAIM!400!diag1],
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart THEN NULLIF( COALESCE(sbd2.Code10, sbd2.Code9), '' ) ELSE NULLIF( sbd2.Code9, '' ) END AS [CLAIM!400!diag2],
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart THEN NULLIF( COALESCE(sbd3.Code10, sbd3.Code9), '' ) ELSE NULLIF( sbd3.Code9, '' ) END AS [CLAIM!400!diag3],
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart THEN NULLIF( COALESCE(sbd4.Code10, sbd4.Code9), '' ) ELSE NULLIF( sbd4.Code9, '' ) END AS [CLAIM!400!diag4],
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart THEN NULLIF( COALESCE(sbd5.Code10, sbd5.Code9), '' ) ELSE NULLIF( sbd5.Code9, '' ) END AS [CLAIM!400!diag5],
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart THEN NULLIF( COALESCE(sbd6.Code10, sbd6.Code9), '' ) ELSE NULLIF( sbd6.Code9, '' ) END AS [CLAIM!400!diag6],
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart THEN NULLIF( COALESCE(sbd7.Code10, sbd7.Code9), '' ) ELSE NULLIF( sbd7.Code9, '' ) END AS [CLAIM!400!diag7],
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart THEN NULLIF( COALESCE(sbd8.Code10, sbd8.Code9), '' ) ELSE NULLIF( sbd8.Code9, '' ) END AS [CLAIM!400!diag8],
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart THEN NULLIF( COALESCE(sbd9.Code10, sbd9.Code9), '' ) ELSE NULLIF( sbd9.Code9, '' ) END AS [CLAIM!400!diag9],
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart THEN NULLIF( COALESCE(sbd10.Code10, sbd10.Code9), '' ) ELSE NULLIF( sbd10.Code9, '' ) END AS [CLAIM!400!diag10],
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart THEN NULLIF( COALESCE(sbd11.Code10, sbd11.Code9), '' ) ELSE NULLIF( sbd11.Code9, '' ) END AS [CLAIM!400!diag11],
	CASE WHEN InsuranceCarrier.ICD10Date <= superbill.ServiceDateStart THEN NULLIF( COALESCE(sbd12.Code10, sbd12.Code9), '' ) ELSE NULLIF( sbd12.Code9, '' ) END AS [CLAIM!400!diag12],

  InsuranceCarrier.CorporationUid  AS [PAYER!230!ID!hide],  --InsuranceCarrier.CorporationUid  
  PersonInsurancePlan.InsurancePlanUid AS [PAYER!230!planType!hide],   --????payer.planType  
  Superbill.PatientUid    AS [PATIENT!300!PEID],  
  COALESCE(PersonInsurancePlan.PersonUid, PersonInsurancePlan.CorporationUid) AS [SUBSCRIBER!200!PEID],   
  COALESCE(AccountResponsibleParty.PersonUid, AccountResponsibleParty.CorporationUid)	AS  [RESPONSIBLEPARTY!240!ID!hide],				--Added by AW for 2010BC loop  2006 03 15
  COALESCE(AccountResponsibleParty.PersonUid, AccountResponsibleParty.CorporationUid)	AS  [RESPONSIBLEPARTY!240!PEID],				--Added by AW for 2010BC loop 2006 03 15  
  (CASE WHEN AccountInsurance.DisplayOrder = 1 THEN 'P'  
   WHEN AccountInsurance.DisplayOrder = 2 THEN 'S'  
        ELSE 'T' END)        AS [SUBSCRIBER!200!payerResponsibility],  
  AccountInsurance.DisplayOrder AS [SUBSCRIBER!200!DisplayOrder],
  ListRelationship.ANSICode      AS [PATIENT!300!patientRelationToInsured],    
  LTRIM(RTRIM((ISNULL(PersonInsurancePlan.PlanMemberID, '') + ISNULL(AccountInsurance.policyNumberSuffix, '')))) AS [CLAIM!400!patientMemberID],  
  PersonInsurancePlan.PlanGroupID    AS [CLAIM!400!patientgroupID],  
  InsurancePlan.Name				 AS [CLAIM!400!patientgroupName], -- Added for AK Medicaid by Qatalys
  UPPER(LTRIM(RTRIM((ISNULL(PersonInsurancePlan.PlanMemberID, '') + ISNULL(AccountInsurance.policyNumberSuffix, ''))))) AS [CLAIM!400!subscriberMemberID],  
  PersonInsurancePlan.AuthorizeAssignment   AS [CLAIM!400!authorizeAssignment],  
  LOWER(ViewSuperbillFinancialDetails.ClaimingProviderUid)     AS [RENDERER!410!ID!hide],  --2011 change
  ViewSuperbillFinancialDetails.ClaimingProviderUid      AS [RENDERER!410!PEID],			--2011 change
  ub.SupervisingProviderUid      AS [SUPERVISING!415!PID],	
  Superbill.OrderingProviderUid		 AS [ORDERING!425!PID],
  ViewSuperbillFinancialDetails.FinancialCenterUid	AS [BILLINGPROVIDER!120!FCID], --2011 change
  CASE WHEN ( ecf.IsIndividual=1 )
       THEN 0	   
	   ELSE 1	END AS [BILLINGPROVIDER!120!FileAsGroup], --2011 change

  COALESCE(pc.ReferredByProviderUid, superbill.referringProviderUid)     AS [REFERRER!420!PID],  --2011 change 
  dbo.UDF_getFormatVaribleValue(2,ecf.ElectronicClaimFormatUid,  
      0,ViewSuperbillFinancialDetails.ClaimingProviderUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) AS [CLAIM!400!providerID],  
 
  dbo.UDF_getFormatVaribleValue(2,ecf.ElectronicClaimFormatUid  
      ,1,ViewSuperbillFinancialDetails.ClaimingProviderUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) AS [CLAIM!400!providerIDType],  
  
dbo.UDF_getFormatVaribleValue(2,ecf.ElectronicClaimFormatUid  
      ,CASE WHEN ( ecf.IsIndividual =1 )THEN 0 ELSE 2 END,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) AS [CLAIM!400!providerGroupID],  
 
 dbo.UDF_getFormatVaribleValue(2,ecf.ElectronicClaimFormatUid  
      ,CASE WHEN ( ecf.IsIndividual=1) THEN 1 ELSE 3 END ,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) AS [CLAIM!400!providerGroupIDType],  

dbo.UDF_getFormatVaribleValue(2,ecf.ElectronicClaimFormatUid  
      ,CASE WHEN (ecf.IsIndividual=1) THEN 0 ELSE 18 END,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) AS [CLAIM!400!providerGroupID2],  
 
 dbo.UDF_getFormatVaribleValue(2,ecf.ElectronicClaimFormatUid  
      ,CASE WHEN (ecf.IsIndividual=1)
       THEN 1 ELSE 19 END ,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) AS [CLAIM!400!providerGroupIDType2],  
 CASE WHEN lcf.SendNPI = 1 
      THEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @ServiceSiteNPIUid,0,NULL,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), '')
	  ELSE '' END AS [CLAIM!400!facilityPrimaryID],

 CASE WHEN lcf.SendNPI = 1 THEN 'XX' ELSE '' END [CLAIM!400!facilityPrimaryIDType],
 
  -- Bug 33171 - Removed call to dbo.stripSpecialChars
 dbo.UDF_getFormatVaribleValue(2,ecf.ElectronicClaimFormatUid  
      ,6,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) AS [CLAIM!400!facilityID],  
 
 dbo.UDF_getFormatVaribleValue(2,ecf.ElectronicClaimFormatUid  
      ,7,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) AS [CLAIM!400!facilityIDType],  
  
  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual=1) THEN @PayToProviderNPIUid
				ELSE @ServiceSiteNPIUid END ,0,NULL, NULL,ViewSuperbillFinancialDetails.ServiceSiteUid, NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), '') <> '' 
		THEN  'XX' 
		WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), '') <> '' 
		THEN  '24'  
		ELSE  '34'  END)     AS [PAYTOPROVIDER!130!IDType],  
  
  (CASE WHEN dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual=1) THEN @PayToProviderNPIUid
				ELSE @ServiceSiteNPIUid END,0,NULL, NULL,ViewSuperbillFinancialDetails.ServiceSiteUid, NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
			dbo.UDF_getFormatVaribleValue (0, CASE WHEN  (ecf.IsIndividual=1 ) THEN @PayToProviderNPIUid
				ELSE @ServiceSiteNPIUid END,0,NULL,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid, NULL,ViewSuperbillFinancialDetails.FinancialCenterUid)
		WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
			dbo.UDF_getFormatVaribleValue (0, @EINUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
		WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN 
			dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 			
		ELSE	
			COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'')
  END)	AS [PAYTOPROVIDER!130!ID],  
 
  (CASE WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,NULL,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' 
        THEN 'EI'
		ELSE ''
	    END)	AS [PAYTOPROVIDER!130!NPISecIDType],

  (CASE WHEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,NULL,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' 
        THEN dbo.UDF_getFormatVaribleValue (0, @EINUid,0,NULL,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid)
		ELSE ''
		END)	AS [PAYTOPROVIDER!130!NPISecID],

  CASE WHEN lcf.SendNPI = 1 THEN		
		--CYS SC 07/23/09 - Added logic for Service Site NPI Overrides
		(CASE WHEN COALESCE(ecf.NPIOverrideFixedValue,
						    NULLIF( dbo.UDF_getFormatVaribleValue (0, ecf.NPIOverrideUid,0,NULL,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), ''),
						    '') <> '' 
			  THEN 'XX'
		ELSE
	  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual=1) THEN @ProviderNPIUid
					ELSE @FinancialCenterNPIUid END,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), '') <> '' THEN  
					'XX'
				WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual=1) THEN @EINUid
					ELSE @FinancialCenterEINUid END,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), '') <> '' THEN  
					'24'  
				WHEN (ecf.IsIndividual=1) THEN 
					'34'
				ELSE ''
			 END)  
		END)	--ServiceSite NPI not <> ''
	--Not NPI
	ELSE (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual=1) THEN @EINUid
				ELSE @FinancialCenterEINUid END,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), '') <> '' THEN  
				'24'  
			WHEN (ecf.IsIndividual=1) THEN 
				'34'
			ELSE ''
	      END)
	END	   
	AS [BILLINGPROVIDER!120!IDType],  
  
	CASE WHEN lcf.SendNPI = 1 THEN
		--CYS SC 07/23/09 - Added logic for Service Site NPI Overrides
		(CASE WHEN COALESCE(ecf.NPIOverrideFixedValue,
						    NULLIF( dbo.UDF_getFormatVaribleValue (0, ecf.NPIOverrideUid,0,ViewSuperbillFinancialDetails.ClaimingProviderUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), ''),
						    '') <> '' 
			  THEN COALESCE(ecf.NPIOverrideFixedValue,
						    NULLIF( dbo.UDF_getFormatVaribleValue (0, ecf.NPIOverrideUid,0,ViewSuperbillFinancialDetails.ClaimingProviderUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), ''),
						    '')
			ELSE 
			--CYS SC 07/23/09 - Service Site NPI Override - END
			  (CASE	  --DEFECT #9657
				WHEN dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual=1) THEN @ProviderNPIUid
					ELSE @FinancialCenterNPIUid END,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN 
						dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual=1) THEN @ProviderNPIUid
						ELSE @FinancialCenterNPIUid END,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid)
				WHEN dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual=1) THEN @EINUid
					ELSE @FinancialCenterEINUid END,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
						dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual=1) THEN @EINUid
						ELSE @FinancialCenterEINUid END,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 
				WHEN (ecf.IsIndividual=1) THEN 
					CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN 
							dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 
						ELSE COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'') END
				ELSE ''

		END) 
	  END) --ServiceSite NPI not <> ''
	--Not NPI
	ELSE (CASE	WHEN dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual=1) THEN @EINUid
				ELSE @FinancialCenterEINUid END,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN
					dbo.UDF_getFormatVaribleValue (0, CASE WHEN (ecf.IsIndividual=1) THEN @EINUid
					ELSE @FinancialCenterEINUid END,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 
			WHEN (ecf.IsIndividual=1) THEN 
				CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' THEN 
						dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 
					ELSE	
						COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'') END
			ELSE ''
		  END)
	END AS [BILLINGPROVIDER!120!ID],
	 
   CASE WHEN (lcf.SendNPI = 1 AND ecf.filingTypeSSN = 1 ) -- SendNPI AND use SSN
	    THEN
		  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0,
															 CASE WHEN (ecf.IsIndividual=1) THEN @ProviderNPIUid ELSE @FinancialCenterNPIUid END,
															 0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), '') = '' 
				THEN  ''
				WHEN dbo.UDF_getFormatVaribleValue (0, 
													CASE WHEN (ecf.IsIndividual=1) THEN @SSNUid ELSE @FinancialCenterEINUid END,
													0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' 
				THEN 'SY'
				ELSE ''
			END)	
	    WHEN (lcf.SendNPI = 1)							  -- SendNPI AND USE EIN ( DEFAULT )
	    THEN 
		  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, 
															 CASE WHEN (ecf.IsIndividual=1) THEN @ProviderNPIUid ELSE @FinancialCenterNPIUid END,
															 0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), '') = '' 
				THEN  ''
				WHEN dbo.UDF_getFormatVaribleValue (0, 
													CASE WHEN (ecf.IsIndividual=1) THEN @EINUid ELSE @FinancialCenterEINUid END,
													0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' 
				THEN 'EI'
				WHEN (ecf.IsIndividual=1) 
				THEN 'SY'
				ELSE ''
			END)	
	    ELSE ''
	END	AS [BILLINGPROVIDER!120!NPISecIDType],


   CASE 
        WHEN (lcf.SendNPI = 1 AND ecf.filingTypeSSN = 1) -- SendNPI AND USE SSN
        THEN 
		  --DEFECT #9657
		  (CASE WHEN (ecf.IsIndividual=1) 
				THEN 
					CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' 
						 THEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 				
						 ELSE COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'') END
				ELSE
					''
			END)
        WHEN lcf.SendNPI = 1 -- SendNPI AND USE EIN ( DEFAULT )
        THEN 
	  --DEFECT #9657
	  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, 
	                                                     CASE WHEN (ecf.IsIndividual=1) THEN @ProviderNPIUid ELSE @FinancialCenterNPIUid END,
														 0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid), '') = '' 
			THEN  ''
			WHEN dbo.UDF_getFormatVaribleValue (0, 
			                                    CASE WHEN (ecf.IsIndividual=1) THEN @EINUid ELSE @FinancialCenterEINUid END,
			                                    0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' 
			THEN dbo.UDF_getFormatVaribleValue (0, 
										        CASE WHEN (ecf.IsIndividual=1) THEN @EINUid ELSE @FinancialCenterEINUid END,
			                                    0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 					
			WHEN (ecf.IsIndividual=1) -- EIN not found so try SSN
			THEN 
				CASE WHEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) <> '' 
					 THEN dbo.UDF_getFormatVaribleValue (0, @SSNUid,0,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) + ISNULL(Provider.eClaimSiteTaxID,'') 				
					 ELSE COALESCE(Person.SocialSecurityNumber,'') + ISNULL(Provider.eClaimSiteTaxID,'') END
			ELSE
				''
		END)
	ELSE ''
	END	AS [BILLINGPROVIDER!120!NPISecID],

  (CASE WHEN superbill.emergency = 1 THEN  'Y' ELSE  ''  END)        AS [PROC!450!emergency],  
   1      AS [CLAIM!400!claimFrequencyCode],  
'Y'    AS [CLAIM!400!providerSignatureOnFile],  
  
  -- CLM08  
  (CASE WHEN PersonInsurancePlan.AuthorizeAssignment = 1 THEN  
   'Y'  
   ELSE  
   'N'  
  END)        AS [CLAIM!400!patientAcceptAssignment],  
		(CASE WHEN 1 = 1 -- JW 1/16/06 In GA4 we're going to assume the box is always check use this logic.
              THEN  'Y'  
              ELSE  '' --N  
			END)        AS [CLAIM!400!releaseOfInformation],
  '' AS  [CLAIM!400!patientSignatureSource],
  CONVERT(VARCHAR,superbill.ServiceDateStart,101)   AS [CLAIM!400!patientSignatureDate],  
  ListServiceSiteType.ANSICode      AS [CLAIM!400!siteType],  
  ListRelatedCause.ANSICode     AS [CLAIM!400!relatedCausesCode],  
  superbill.RelatedCauseState     AS [CLAIM!400!accidentState],    
  ISNULL(superbill.RelatedCauseDate, superbill.OnsetDate)  AS [CLAIM!400!accidentDate],  
  superbill.onsetDate       AS [CLAIM!400!onsetCurrentDate],  
  superbill.onsetFirstDate      AS [CLAIM!400!onsetFirstDate],
  NULL AS [CLAIM!400!onsetFirstDateQualifier],  
  superbill.noWorkFromDate     AS [CLAIM!400!noWorkFromDate],  
  superbill.noWorkToDate      AS [CLAIM!400!noWorkToDate],  
  superbill.HospitalizationStartDate     AS [CLAIM!400!hospitalizationStartDate],  
  superbill.HospitalizationEndDate     AS [CLAIM!400!hospitalizationEndDate],  
  superbill.InitialTreatmentDate     AS [CLAIM!400!InitialTreatmentDate],
  superbill.EPSDT       AS [CLAIM!400!familyPlan],  
  ISNULL(CONVERT(VARCHAR(80),superbill.ClaimNote), '')		AS [CLAIM!400!ClaimNote], -- Add for AK Medicaid by Qatalys
  ISNULL(CONVERT(VARCHAR(80),superbill.ClaimNote), '')          AS [CLAIM!400!Note], -- Igor 9/29/09 per 2517 had to add this so that AK Medicaid code will not be broken
  listclaimheadernotecode.ANSICode      AS [CLAIM!400!NoteReferenceCode], -- 2517 added 9/28/09	  
 CASE WHEN Superbillaggregate.CurrentCarrier = 1 THEN COALESCE(superbill.PriorAuthorizationCode, '')						-- Primary
	     WHEN Superbillaggregate.CurrentCarrier = 2 THEN COALESCE(superbill.PriorAuthorizationCode_InsuranceCarrier2, '')		-- Secondary
	     WHEN Superbillaggregate.CurrentCarrier = 3 THEN COALESCE(superbill.PriorAuthorizationCode_InsuranceCarrier3, '')		-- Tertiary
	     ELSE '' END AS [CLAIM!400!priorAuthorizationCode],
  lcf.SendNPI AS [CLAIM!400!SendNPI],
  lcf.Dmerc AS [CLAIM!400!Dmerc],	
  lcf.SendPQRIproc	AS [CLAIM!400!SendPQRIproc],
  lcf.Output2310D	AS [CLAIM!400!Output2310D], --bug 1420
  lcf.OutputAAE	AS [CLAIM!400!OutputAAE], --bug 5129
  lcf.BHTTypePR	AS [CLAIM!400!OutputPR],--added 5/9/2011
CONVERT(VARCHAR(50), cobcd.ICN) AS [CLAIM!400!ICN], --ADDED ICN NUMBER REPORTDED IN LOOP 2300 6/19/08
  superbill.EPSDT       AS [CLAIM!400!EPSDT], --ADDED 07/21/09 bug 1430
  lepsdt1.ExternalID as EPSDTReferralCondIndicator1 ,--ADDED 07/21/09 bug 1430
  lepsdt2.ExternalID as EPSDTReferralCondIndicator2 ,--ADDED 07/21/09 bug 1430
  lepsdt3.ExternalID as EPSDTReferralCondIndicator3 ,--ADDED 07/21/09 bug 1430
  lepsdt4.ExternalID as EPSDTReferralCondIndicator4 ,--ADDED 07/21/09 bug 1430
  lmsrc.ANSICode AS [CLAIM!400!InsuranceTypeCode],
  (CASE WHEN superbill.AuthReferralIndicator = 1 THEN 'G1' ELSE '9F' END)        AS [CLAIM!400!AuthReferralIndicator],  --bug 2570	
  '' AS [CLAIM!400!BillingProvider_IDType],   
  '' AS [CLAIM!400!BillingProvider_ID],		
  superbill.LMPDate       AS [CLAIM!400!LMPDate], 
  convert(varchar(MAX),superbill.UserDefinedXml)        AS  [CLAIM!400!UserDefinedXml], -- Previously 300 rather than MAX
  superbill.ResubmissionCode AS [CLAIM!400!ResubmissionCode],
  ldr.ANSICode  AS [CLAIM!400!DelayReasonCode] , --869
  superbill.DateLastSeenBySupervising AS [CLAIM!400!DateLastSeenBySupervising] ,--249
  dbo.stripSpecialChars(dbo.UDF_getFormatVaribleValue(2, ecf.ElectronicClaimFormatUid,18,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid))
      AS [CLAIM!400!SecPayerID],
 
dbo.stripSpecialChars(dbo.UDF_getFormatVaribleValue(2, ecf.ElectronicClaimFormatUid,19,Provider.PersonUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid))      
AS [CLAIM!400!SecPayerCode],
  ub.AssumedDate AS   [CLAIM!400!AssumedDate],
  ub.RelinquishedDate AS   [CLAIM!400!RelinquishedDate],      
  (Case WHEN ( pis.Value IS NOT NULL AND pis.Value like '%17667(True)%') THEN vsa.UnAssignedDistribution ELSE NULL END) AS [CLAIM!400!PatientPaidAmount], -- See bug 17667
  ViewSuperbillFinancialDetails.serviceSiteUID      AS [SERVICEFACILITY!430!PID],  
  ListServiceSiteType.ANSICode     AS [PROC!450!serviceLocation],  
  Superbill.ExternalID	AS [PROC!450!lineControlNo],
  CASE WHEN PersonInsurancePlan.PersonUid IS NOT NULL THEN 0  
       WHEN PersonInsurancePlan.CorporationUid IS NOT NULL THEN 1 END AS [SUBSCRIBER!200!isWCC] ,
  CASE WHEN AccountResponsibleParty.PersonUid IS NOT NULL THEN 0  
       WHEN AccountResponsibleParty.CorporationUid IS NOT NULL THEN 1 END AS [RESPONSIBLEPARTY!240!isCorporation],  	--Added by AW for 2010BC loop  2006 03 15  
  ViewSuperbillFinancialDetails.FinancialCenterUid   AS  [FINANCIALCENTER!105!FCID],
  account.AccountUid AS [CLAIM!400!AccountID],
  CONVERT(VARCHAR(50),account.Name) AS [CLAIM!400!AccountName],  -- 29692
  SuperbillAggregate.AccountPeriodUid AS [CLAIM!400!AccountPeriodID],
  SUBSTRING(ISNULL( lpt.ANSICode, ''),1,2) as [CLAIM!400!PaperworkTypeID],
  SUBSTRING(ISNULL( lptc.ANSICode, ''),1,2) as [CLAIM!400!PaperworkTransmissionCodeID],
  SUBSTRING(ISNULL( superbill.PaperworkControlNum, ''),1,50)  as [CLAIM!400!PaperworkControlNum],
  0 as [CLAIM!400!Allow5010Codes],
  CASE WHEN InsuranceCarrier.ICD10Date <= Superbill.ServiceDateStart THEN 1 ELSE 0 END AS [CLAIM!400!UseICD10],
  ecf.[ElectronicClaimFormatUid] AS [CLAIM!400!ElectronicClaimFormatUid],
  Superbill.ReleaseClaimAndIgnoreComplianceErrors AS [CLAIM!400!ReleaseClaimAndIgnoreComplianceErrors]
  ,ecf.SVCodes AS [CLAIM!400!SVCodes]
 FROM #XMLClaims_temp  
  INNER JOIN ClaimBatch WITH (NOLOCK) ON ClaimBatch.ClaimBatchUid = #XMLClaims_temp.[SITE!100!eClaimBatchGUID]  
  INNER JOIN ClaimBatchDetail WITH (NOLOCK) ON ClaimBatchDetail.ClaimBatchUid = ClaimBatch.ClaimBatchUid   
  INNER JOIN superbill WITH (NOLOCK) on superbill.SuperbillUid = ClaimBatchDetail.SuperbillUid --2011 change 
  INNER JOIN SuperbillAggregate WITH (NOLOCK) ON superbill.SuperbillUid = SuperbillAggregate.SuperbillUid  
  INNER JOIN  ViewSuperbillFinancialDetails ON ViewSuperbillFinancialDetails.superbillUid = superbill.SuperbillUid and superbill.claimPaper=0 -- Confirm that the drop to paper override isn't set.  
  INNER JOIN account WITH (NOLOCK) ON account.accountUid = superbill.accountUid  
  INNER JOIN AccountResponsibleParty WITH (NOLOCK) ON Account.AccountResponsiblePartyUid = AccountResponsibleParty.AccountResponsiblePartyUid  
  INNER JOIN AccountPeriod WITH (NOLOCK) ON AccountPeriod.AccountPeriodUid = SuperbillAggregate.AccountPeriodUid 
  INNER JOIN AccountInsurance WITH (NOLOCK)  ON AccountInsurance.AccountPeriodUid = SuperbillAggregate.AccountPeriodUid -- AccountPeriod.AccountPeriodUid 
											AND SuperbillAggregate.CurrentCarrier = AccountInsurance.DisplayOrder   
  INNER JOIN PersonInsurancePlan WITH (NOLOCK) ON PersonInsurancePlan.PersonInsurancePlanUid = AccountInsurance.PersonInsurancePlanUid  
											--AND PersonInsurancePlan.InsurancePlanUid = Claimbatchdetail.InsurancePlanUid  
  INNER JOIN InsurancePlan WITH (NOLOCK) ON InsurancePlan.InsurancePlanUid = PersonInsurancePlan.InsurancePlanUid  
  INNER JOIN InsuranceCarrier WITH (NOLOCK) ON InsuranceCarrier.CorporationUid = InsurancePlan.InsuranceCarrierUid  
  INNER JOIN AR_ViewSuperbillAggregate vsa WITH (NOLOCK) ON Superbill.SuperbillUid = vsa.SuperbillUid 	
  LEFT JOIN ListClaimFormat lcf WITH (NOLOCK) ON lcf.ClaimFormatUid = (CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 
															  THEN InsuranceCarrier.ElectronicClaimFormatUid
														  ELSE InsurancePlan.ElectronicClaimFormatUid END)	
  INNER JOIN @ecf ecf ON Superbill.SuperbillUid = ecf.SuperbillUid
  -- THIS WILL BE SENT AS THE CLAIM RENDERING PROVIDER  
  INNER JOIN provider WITH (NOLOCK) ON provider.PersonUID = ViewSuperbillFinancialDetails.ClaimingProviderUid    --We have to use RenderingProviderUid  :Aji 2005 10 21  
  INNER JOIN Person WITH (NOLOCK) ON Person.PersonUid = Provider.PersonUid  
  INNER JOIN ListServiceSite WITH (NOLOCK) ON  ListServiceSite.serviceSiteUID = ViewSuperbillFinancialDetails.serviceSiteUID   
  LEFT JOIN ListServiceSiteType ListServiceSiteType WITH (NOLOCK) ON ListServiceSiteType.ServiceSiteTypeUid = ListServiceSite.ServiceSiteTypeUid  
  LEFT JOIN ListRelationship ListRelationship WITH (NOLOCK) ON ListRelationship.RelationshipUid = AccountInsurance.RelationshipUid   
  LEFT JOIN ListRelatedCause ListRelatedCause WITH (NOLOCK) ON ListRelatedCause.RelatedCauseUid = superbill.RelatedCauseUid   
  INNER JOIN ListSuperBillStatus WITH (NOLOCK) ON Superbill.SuperbillStatusUid  = ListSuperBillStatus.SuperbillStatusUid  
  LEFT JOIN SuperbillDiagnosis sbd1 WITH (NOLOCK) ON sbd1.SuperBillUid = superbill.superbillUid AND sbd1.DisplayOrder =1  
  LEFT JOIN SuperbillDiagnosis sbd2 WITH (NOLOCK) ON sbd2.SuperBillUid = superbill.superbillUid AND sbd2.DisplayOrder =2  
  LEFT JOIN SuperbillDiagnosis sbd3 WITH (NOLOCK) ON sbd3.SuperBillUid = superbill.superbillUid AND sbd3.DisplayOrder =3  
LEFT JOIN SuperbillDiagnosis sbd4 WITH (NOLOCK) ON sbd4.SuperBillUid = superbill.superbillUid AND sbd4.DisplayOrder =4  
  LEFT JOIN SuperbillDiagnosis sbd5 WITH (NOLOCK) ON sbd5.SuperBillUid = superbill.superbillUid AND sbd5.DisplayOrder =5    
  LEFT JOIN SuperbillDiagnosis sbd6 WITH (NOLOCK) ON sbd6.SuperBillUid = superbill.superbillUid AND sbd6.DisplayOrder =6  
LEFT JOIN SuperbillDiagnosis sbd7 WITH (NOLOCK) ON sbd7.SuperBillUid = superbill.superbillUid AND sbd7.DisplayOrder =7  
  LEFT JOIN SuperbillDiagnosis sbd8 WITH (NOLOCK) ON sbd8.SuperBillUid = superbill.superbillUid AND sbd8.DisplayOrder =8  
  LEFT JOIN SuperbillDiagnosis sbd9 WITH (NOLOCK) ON sbd9.SuperBillUid = superbill.superbillUid AND sbd9.DisplayOrder =9  
  LEFT JOIN SuperbillDiagnosis sbd10 WITH (NOLOCK) ON sbd10.SuperBillUid = superbill.superbillUid AND sbd10.DisplayOrder =10  
  LEFT JOIN SuperbillDiagnosis sbd11 WITH (NOLOCK) ON sbd11.SuperBillUid = superbill.superbillUid AND sbd11.DisplayOrder =11  
  LEFT JOIN SuperbillDiagnosis sbd12 WITH (NOLOCK) ON sbd12.SuperBillUid = superbill.superbillUid AND sbd12.DisplayOrder =12  
  --LEFT JOIN ListDiagnosis Ld1 ON Ld1.DiagnosisUid = sbd1.DiagnosisUid  
  --LEFT JOIN ListDiagnosis Ld2 ON Ld2.DiagnosisUid = sbd2.DiagnosisUid  
  --LEFT JOIN ListDiagnosis Ld3 ON Ld3.DiagnosisUid = sbd3.DiagnosisUid  
  --LEFT JOIN ListDiagnosis Ld4 ON Ld4.DiagnosisUid = sbd4.DiagnosisUid  
  --LEFT JOIN ListDiagnosis Ld5 ON Ld5.DiagnosisUid = sbd5.DiagnosisUid  
  --LEFT JOIN ListDiagnosis Ld6 ON Ld6.DiagnosisUid = sbd6.DiagnosisUid  
  --LEFT JOIN ListDiagnosis Ld7 ON Ld7.DiagnosisUid = sbd7.DiagnosisUid  
  --LEFT JOIN ListDiagnosis Ld8 ON Ld8.DiagnosisUid = sbd8.DiagnosisUid  
  LEFT JOIN COBClaimDetail  cobcd WITH (NOLOCK) ON cobcd.SuperBillUid = superbill.superbillUid AND cobcd.InsuranceOrder = AccountInsurance.DisplayOrder
  INNER JOIN Patient WITH (NOLOCK) ON Patient.PersonUid = Superbill.PatientUid  
  LEFT JOIN ListSignatureSource WITH (NOLOCK) ON Patient.SignatureSourceUid = ListSignatureSource.SignatureSourceUid  
  LEFT JOIN ViewSuperbillCurrentLiabilityOwnerAndCarrier WITH (NOLOCK) ON superbill.superbillUid = ViewSuperbillCurrentLiabilityOwnerAndCarrier.superbillUid
  LEFT JOIN listmedicaresecondaryreasoncode lmsrc WITH (NOLOCK) on lmsrc.MedicareSecondaryReasonCodeUID = Accountperiod.MedicareSecondaryReasonCodeUID
  LEFT JOIN ListDelayReason ldr WITH (NOLOCK) on ldr.DelayReasonUid = superbill.DelayReasonUid --869
  LEFT JOIN ListEPSDTReferralCondIndicator lepsdt1 WITH (NOLOCK) on lepsdt1.EPSDTReferralCondIndicatorUid = superbill.EPSDTReferralCondIndicator1Uid -- addd 07/21/09 bug 1430
  LEFT JOIN ListEPSDTReferralCondIndicator lepsdt2 WITH (NOLOCK) on lepsdt2.EPSDTReferralCondIndicatorUid = superbill.EPSDTReferralCondIndicator2Uid -- addd 07/21/09 bug 1430
  LEFT JOIN ListEPSDTReferralCondIndicator lepsdt3 WITH (NOLOCK) on lepsdt3.EPSDTReferralCondIndicatorUid = superbill.EPSDTReferralCondIndicator3Uid -- addd 07/21/09 bug 1430
  LEFT JOIN ListEPSDTReferralCondIndicator lepsdt4 WITH (NOLOCK) on lepsdt4.EPSDTReferralCondIndicatorUid = superbill.EPSDTReferralCondIndicator4Uid -- addd 07/21/09 bug 1430
  LEFT JOIN listclaimheadernotecode WITH (NOLOCK) on listclaimheadernotecode.claimheadernotecodeuid = superbill.claimheadernotecodeuid----2517
  LEFT JOIN PatientCase pc WITH (NOLOCK) on superbill.PatientCaseUid = pc.PatientCaseUid
  LEFT OUTER JOIN PlugInSettings pis WITH (NOLOCK) on ClaimBatch.ClaimClearingHouseUid = pis.ClaimClearingHouseUid AND pis.Name = 'SpecialCase'
LEFT OUTER JOIN SuperbillUB ub WITH (NOLOCK) ON ub.SuperbillUid = superbill.SuperbillUid  
  LEFT OUTER JOIN ListPaperworkType lpt with (nolock) on Superbill.PaperworkTypeUid = lpt.PaperworkTypeUid
  LEFT OUTER JOIN ListPaperworkTransmissionCode lptc with (nolock) on Superbill.PaperworkTransmissionCodeUid = lptc.PaperworkTransmissionCodeUid
 WHERE  
  #XMLClaims_temp.tag = 100  --and AccountInsurance.DisplayOrder = ViewSuperbillCurrentLiabilityOwnerAndCarrier.CurrentCarrier-- this will make sure that we select current carrier when primary and secondary are the same
  
 SET @claimsFetched = @@ROWCOUNT

	--CYS SC 07/23/09 - Added for Service Site bug (CYS Case #22420)
	UPDATE #XMLClaims_temp SET 
		[CLAIM!400!BillingProvider_IDType] = [BILLINGPROVIDER!120!IDType],
		[CLAIM!400!BillingProvider_ID] = [BILLINGPROVIDER!120!ID]
	WHERE tag = 400 ;

  -- Move primaryIC search to seperate query because it was causing excess reads 
  UPDATE #XMLClaims_temp
  SET #XMLClaims_temp.[CLAIM!400!providerAcceptAssignment] = -- CLM07
	  (CASE WHEN sb.UsePrimaryPayerAcceptAssignment = 1 
			THEN ( CASE WHEN primaryIC.AcceptAssignment = 1        THEN 'A'	-- Assigned
						WHEN primaryIC.AcceptAssignmentLabOnly = 1 THEN 'B'	-- Lab Only
						ELSE 'C' END )										-- Not Assigned
			ELSE
				( CASE WHEN sb.AcceptAssignment = 1		   THEN 'A'	-- Assigned  
						WHEN sb.AcceptAssignmentLabOnly = 1 THEN 'B'	-- Lab Only
						ELSE 'C' end )										-- Not Assigned
		END)           
  FROM #XMLClaims_temp 
		INNER JOIN Superbill sb with (NOLOCK) ON #XMLClaims_temp.[CLAIM!400!PID] = sb.SuperbillUid 
		INNER JOIN SuperbillAggregate sba WITH (NOLOCK) ON sb.SuperbillUid = sba.SuperbillUid
		INNER JOIN AccountInsurance primaryAI WITH (NOLOCK) ON primaryAI.AccountPeriodUid = sba.AccountPeriodUid AND primaryAI.DisplayOrder = 1
		INNER JOIN PersonInsurancePlan primaryPIP WITH (NOLOCK) ON primaryAI.PersonInsurancePlanUid = primaryPIP.PersonInsurancePlanUid 
		INNER JOIN InsurancePlan primaryIP WITH (NOLOCK) ON primaryPIP.InsurancePlanUid = primaryIP.InsurancePlanUid
		INNER JOIN InsuranceCarrier primaryIC WITH (NOLOCK) ON primaryIP.InsuranceCarrierUid = primaryIC.CorporationUid
  WHERE #XMLClaims_temp.tag = 400
		AND primaryAI.DisplayOrder = 1

  -- Set "switch" to allow some 5010 functionality to go into 4010
  --    -  SBR05 ( 2320 ) - allow InsuranceTypeCode values
  UPDATE #XMLClaims_temp
  SET [CLAIM!400!Allow5010Codes] = CASE WHEN NULLIF(pis.Value, '0') IS NULL THEN 0 ELSE 1 END
  FROM #XMLClaims_temp
		INNER JOIN ClaimBatch WITH (NOLOCK) ON ClaimBatch.ClaimBatchUid = #XMLClaims_temp.[SITE!100!eClaimBatchGUID]  
		INNER JOIN PlugInSettings pis WITH (NOLOCK) ON ClaimBatch.ClaimClearingHouseUid = pis.ClaimClearingHouseUid AND pis.Name = 'Allow5010CodesIn4010'
  WHERE  #XMLClaims_temp.tag = 400 

  -- Bug 31476: EDI Requirements for Health Net payer Encounter
  DECLARE @moopClaims TABLE ( superbillUid UNIQUEIDENTIFIER, InsuranceOrder int ) ;
  INSERT INTO @moopClaims( superbillUid, InsuranceOrder )
  	SELECT #XMLClaims_temp.[CLAIM!400!PID] as superbillUid,
		   cb.InsuranceOrder as InsuranceOrder
	FROM #XMLClaims_temp
			INNER JOIN ClaimBatchDetail cbd with (nolock) on #XMLClaims_temp.[CLAIM!400!PID] = cbd.SuperbillUid
															and #XMLClaims_temp.[SITE!100!eClaimBatchGUID] = cbd.ClaimBatchUid
			INNER JOIN ClaimBatch cb with (nolock) on cbd.ClaimBatchUid = cb.ClaimBatchUid
			INNER JOIN SuperbillAggregate sba WITH (NOLOCK) ON cbd.SuperbillUid = sba.SuperbillUid  
			INNER JOIN AccountInsurance  ai WITH (NOLOCK) ON ai.AccountPeriodUid = sba.AccountPeriodUid --ap.AccountPeriodUid 
																AND sba.CurrentCarrier = ai.DisplayOrder   
			INNER JOIN PersonInsurancePlan pip WITH (NOLOCK) ON pip.PersonInsurancePlanUid = ai.PersonInsurancePlanUid  
			INNER JOIN InsurancePlan ip WITH (NOLOCK) ON pip.InsurancePlanUid = ip.InsurancePlanUid  
			INNER JOIN InsuranceCarrier ic WITH (NOLOCK) ON ic.CorporationUid = ip.InsuranceCarrierUid 
																AND UPPER(ic.Notes) like '%MOOP_PATIENTPAIDAMOUNT_SUMPR%'
	WHERE #XMLClaims_temp.tag = 400 -- for each claim

  IF EXISTS ( SELECT * FROM @moopClaims )
  BEGIN		
	;with myCTE2 AS
	(
	SELECT mpc.superbillUid as superbillUid, SUM(cobl.Amount) as Amount
	FROM  @moopClaims mpc
			INNER JOIN COBClaimDetail cobd with (nolock) on mpc.superbillUid = cobd.SuperbillUid
																AND mpc.InsuranceOrder > cobd.InsuranceOrder -- assuming we want sum of all previous insurance
			INNER JOIN COBLineAdjustments cobl with (nolock) on cobd.COBClaimDetailUid = cobl.COBClaimDetailUid
			INNER JOIN ListERACode lec with (nolock) on cobl.GroupCodeERACodeUid = lec.ERACodeUid
		WHERE lec.Code = 'PR'		-- only PR codes
		GROUP BY mpc.superbillUid
	)
	Update #XMLClaims_temp
		SET [CLAIM!400!PatientPaidAmount] = CASE WHEN mc.Amount IS NULL THEN 0 ELSE -mc.Amount END
		FROM #XMLClaims_temp
			LEFT OUTER JOIN myCTE2 mc on mc.superbillUid = #XMLClaims_temp.[CLAIM!400!PID]
		WHERE #XMLClaims_temp.tag = 400   
  END

  -- CHC DSW 60093
Update #XMLClaims_temp
	Set [CLAIM!400!ChcBillingType] = cap.BillingType
FROM #XMLClaims_temp 
		INNER JOIN Superbill sb with (nolock) on #XMLClaims_temp.[CLAIM!400!PID] = sb.SuperbillUid
		inner join SuperbillAggregate sba with (nolock) on sb.SuperbillUid= sba.SuperbillUid
		INNER JOIN ChcInsurancePlan cip with (nolock) on sba.CurrentInsurancePlanUid = cip.InsurancePlanUid
		INNER JOIN ChcListApprovalSetting cas with (nolock) on cip.ApprovalSettingUid = cas.ApprovalSettingUid
		INNER JOIN ChcApprovalPeriod cap with (nolock) on cas.ApprovalSettingUid = cap.ApprovalSettingUid
															AND (cap.EffectiveDate IS NULL OR sb.ServiceDateStart >= cap.EffectiveDate )
															AND (cap.ExpirationDate	IS NULL OR sb.ServiceDateStart <= cap.ExpirationDate )
WHERE #XMLClaims_temp.tag = 400


-- 11329, Acute Manifestation Date qualifier is not generating/transmitting in 837P in Loop 2300 DTP03 (453)
-- 16256, client unable to send out claims
Update #XMLClaims_temp
  SET [CLAIM!400!onsetFirstDateQualifier] = CONVERT(VARCHAR(3),lcfvt.ExternalID)
  FROM #XMLClaims_temp
		INNER JOIN Superbill sb with (nolock) on #XMLClaims_temp.[CLAIM!400!PID] = sb.SuperbillUid
		INNER JOIN ListClaimFormatValueType lcfvt On sb.OnsetFirstQualifierUid = lcfvt.ClaimFormatValueTypeUid


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_FINANCIALCENTER]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_FINANCIALCENTER] AS' 
END
GO
ALTER PROC [dbo].[AR_genXMLClaims_FINANCIALCENTER]
AS

	/* Need to retrieve claim format for specific insurance on superbill */
	DECLARE @ClaimFormatUid uniqueidentifier
	SET @ClaimFormatUid = null;
	;with thisClaim
	as
	(
		select top 1 xt.[SITE!100!eClaimBatchGUID] AS batchGuid
		from #XMLClaims_temp xt
		where xt.[SITE!100!eClaimBatchGUID] IS NOT NULL
	)
	select @ClaimFormatUid = CASE IP.UseCarrierElectronicClaimFormat 
			WHEN 1 THEN IC.ElectronicClaimFormatUId
			ELSE IP.ElectronicClaimFormatUId END
			--@FinancialCenterUid = sba.FinancialCenterUid 
	from --ClaimBatch cb
		--	inner join ClaimBatchDetail cbd on cb.ClaimBatchUid = cbd.ClaimBatchUid
		 ClaimBatchDetail cbd 
			inner join thisClaim tc on cbd.ClaimBatchUid = tc.batchGuid
			inner join Superbill sb on cbd.SuperbillUid = sb.SuperbillUid
			inner join SuperbillAggregate sba on sb.SuperbillUid = sba.SuperbillUid -- Need current insurance liability owner
			inner join AccountPeriod ap on sb.AccountUid = ap.AccountUid
											AND (ap.EffectiveDate IS NULL OR (ap.EffectiveDate <= sb.ServiceDateStart) )
											AND (ap.ExpirationDate IS NULL OR (ap.ExpirationDate >= sb.ServiceDateStart) )
			inner join AccountInsurance ai on ap.AccountPeriodUid = ai.AccountPeriodUid
												and ai.DisplayOrder = 
														coalesce( sba.CurrentCarrier, sb.CurrentCarrierOverride, 1 ) 
														-- Order of preference
														-- 1) Current Carrier from aggregate
														-- 2) Superbill liability owner flag
														-- 3) Primary ( last resort )
			inner join PersonInsurancePlan pip on ai.PersonInsurancePlanUid = pip.PersonInsurancePlanUid
			inner join InsurancePlan ip on pip.InsurancePlanUid = ip.InsurancePlanUid
			inner join InsuranceCarrier ic on ip.InsuranceCarrierUid = ic.CorporationUid
				
	-- Submitter ID 
	DECLARE @submitterIDClaimFormatValueTypeUid UNIQUEIDENTIFIER
	SET @submitterIDClaimFormatValueTypeUid = null
	select @submitterIDClaimFormatValueTypeUid=lcfvt.ClaimFormatValueTypeUid--, lcfvt.*
	from ListClaimFormatOptionType lcfot
			inner join ListClaimFormatType lcft on lcfot.ClaimFormatTypeUid = lcft.ClaimFormatTypeUid
			inner join ClaimFormatOption cfo on lcfot.ClaimFormatOptionTypeUid = cfo.ClaimFormatOptionTypeUid
			inner join ListClaimFormat lcf on cfo.ClaimFormatUid = lcf.ClaimFormatUid
			inner join ListClaimFormatValueType lcfvt on cfo.ClaimFormatValueTypeUid = lcfvt.ClaimFormatValueTypeUid
	where lcfot.ClaimFormatOptionTypeUid = 'EC66D3D8-193B-416E-95B4-3A5DC1D088B4'		-- Submitter ID on electronic payer
			and cfo.ClaimFormatUid = @ClaimformatUid -- 'F43FD3CD-C30F-4CF3-A579-3759DA6441F0'				-- Claim Format ( i.e. e-Medicare )

	-- Financial Center PayTo true/false & PayToAddress
	DECLARE @PayToFinancialCenter BIT = NULL
	SELECT @PayToFinancialCenter = CASE WHEN cfo.ClaimFormatOptionUid IS NOT NULL THEN 1 ELSE NULL END
	FROM ListClaimFormatOptionType lcfot
				inner join ClaimFormatOption cfo on lcfot.ClaimFormatOptionTypeUid = cfo.ClaimFormatOptionTypeUid
				 -- inner join ListClaimFormatValueType lcfvt on cfo.ClaimFormatValueTypeUid = lcfvt.ClaimFormatValueTypeUid
				 	 AND cfo.ClaimFormatValueTypeUid = '145E4D94-991D-4329-9F51-8E45519F88C2' -- Pay To Financial Center Address
				--	--AND lcfvt.ClaimFormatValueTypeUid = '999AD8DE-370C-4B17-8709-94A5020C5DF4' -- Pay To Default Address
	WHERE lcfot.ClaimFormatOptionTypeUid in( '54F048A9-AA54-4964-ACEE-CC1A9F6E0508', 'C45B2F56-D802-4CFB-A0B2-A2FBB9EB0505') -- Pay To Address
				and cfo.ClaimFormatUid = @ClaimformatUid 

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],
    [FINANCIALCENTER!105!FCID],
    [FINANCIALCENTER!105!SubmitterID],
	[FINANCIALCENTER!105!PayToFinancialCenter] ,
	[FINANCIALCENTER!105!PayToAddress1],
	[FINANCIALCENTER!105!PayToAddress2],
	[FINANCIALCENTER!105!PayToCity],
	[FINANCIALCENTER!105!PayToState],
	[FINANCIALCENTER!105!PayToZip]
)
SELECT  DISTINCT 
    105 								    AS	Tag,
	100 								AS	parent,
	[SITE!100!PID]						AS	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID]			AS	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]	AS	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]		AS	[SITE!100!payToAddressID!hide],
    [FINANCIALCENTER!105!FCID]          AS  [FINANCIALCENTER!105!FCID],
   	dbo.UDF_getFormatVaribleValue(0, @submitterIDClaimFormatValueTypeUid, 0, NULL, NULL, NULL, NULL, [FINANCIALCENTER!105!FCID]) AS [FINANCIALCENTER!105!SubmitterID],
	@PayToFinancialCenter AS [FINANCIALCENTER!105!PayToFinancialCenter],
	fc.[PayToAddress].value('(/Address/Address1)[1]', 'VARCHAR(100)') AS [FINANCIALCENTER!105!PayToAddress1],
	fc.[PayToAddress].value('(/Address/Address2)[1]', 'VARCHAR(100)') AS [FINANCIALCENTER!105!PayToAddress2],
	fc.[PayToAddress].value('(/Address/City)[1]', 'VARCHAR(100)') AS [FINANCIALCENTER!105!PayToCity],
	UPPER(fc.[PayToAddress].value('(/Address/State)[1]', 'VARCHAR(100)')) AS [FINANCIALCENTER!105!PayToState],
	fc.[PayToAddress].value('(/Address/Zip)[1]', 'VARCHAR(100)') AS [FINANCIALCENTER!105!PayToZip]
FROM #XMLClaims_temp
	INNER JOIN FinancialCenter fc on [FINANCIALCENTER!105!FCID] = fc.FinancialCenterUid
WHERE
	#XMLClaims_temp.tag = 400


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_PAYER]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_PAYER] AS' 
END
GO
ALTER PROC [dbo].[AR_genXMLClaims_PAYER]
AS

/*
	Note: Here we are assuming that ClaimPayerID is unique for all carriers. This conclusion has been deducted from 
		the PS - Stored Procedure
*/

	/* Need to retrieve claim format for specific insurance on superbill */
	DECLARE @ClaimFormatUid uniqueidentifier
	--DECLARE @FinancialCenterUid uniqueidentifier
	DECLARE @taxonomyClaimFormatValueTypeUid uniqueidentifier
	DECLARE @submitterIDClaimFormatValueTypeUid uniqueidentifier
	
	SET @ClaimFormatUid = null;
	;with thisClaim
	as
	(
		select top 1 xt.[SITE!100!eClaimBatchGUID] AS batchGuid
		from #XMLClaims_temp xt
		where xt.[SITE!100!eClaimBatchGUID] IS NOT NULL
	)
	select @ClaimFormatUid = CASE IP.UseCarrierElectronicClaimFormat 
			WHEN 1 THEN IC.ElectronicClaimFormatUId
			ELSE IP.ElectronicClaimFormatUId END
	from  ClaimBatchDetail cbd 
			inner join thisClaim tc on cbd.ClaimBatchUid = tc.batchGuid
			inner join Superbill sb on cbd.SuperbillUid = sb.SuperbillUid
			inner join SuperbillAggregate sba on sb.SuperbillUid = sba.SuperbillUid -- Need current insurance liability owner
			inner join AccountPeriod ap on sb.AccountUid = ap.AccountUid
											AND (ap.EffectiveDate IS NULL OR (ap.EffectiveDate <= sb.ServiceDateStart) )
											AND (ap.ExpirationDate IS NULL OR (ap.ExpirationDate >= sb.ServiceDateStart) )
			inner join AccountInsurance ai on ap.AccountPeriodUid = ai.AccountPeriodUid
												and ai.DisplayOrder = 
														coalesce( sba.CurrentCarrier, sb.CurrentCarrierOverride, 1 ) 
														-- Order of preference
														-- 1) Current Carrier from aggregate
														-- 2) Superbill liability owner flag
														-- 3) Primary ( last resort )
			inner join PersonInsurancePlan pip on ai.PersonInsurancePlanUid = pip.PersonInsurancePlanUid
			inner join InsurancePlan ip on pip.InsurancePlanUid = ip.InsurancePlanUid
			inner join InsuranceCarrier ic on ip.InsuranceCarrierUid = ic.CorporationUid
				
	--where cb.ClaimBatchUid = '64988181-5BF3-4DEA-BC65-77C5917F3898'
	SET @taxonomyClaimFormatValueTypeUid = null
	select @taxonomyClaimFormatValueTypeUid=lcfvt.ClaimFormatValueTypeUid--, lcfvt.*
	from ListClaimFormatOptionType lcfot
			inner join ListClaimFormatType lcft on lcfot.ClaimFormatTypeUid = lcft.ClaimFormatTypeUid
			inner join ClaimFormatOption cfo on lcfot.ClaimFormatOptionTypeUid = cfo.ClaimFormatOptionTypeUid
			inner join ListClaimFormat lcf on cfo.ClaimFormatUid = lcf.ClaimFormatUid
			inner join ListClaimFormatValueType lcfvt on cfo.ClaimFormatValueTypeUid = lcfvt.ClaimFormatValueTypeUid
	where lcfot.ClaimFormatOptionTypeUid = '75FCD463-CDA2-46E9-8D12-DBAEFA9D953F'		-- Taxonomy Code for Professional
			and cfo.ClaimFormatUid = @ClaimformatUid -- 'F43FD3CD-C30F-4CF3-A579-3759DA6441F0'				-- Claim Format ( i.e. e-Medicare )
	-- Submitter ID 
	SET @submitterIDClaimFormatValueTypeUid = null
	select @submitterIDClaimFormatValueTypeUid=lcfvt.ClaimFormatValueTypeUid--, lcfvt.*
	from ListClaimFormatOptionType lcfot
			inner join ListClaimFormatType lcft on lcfot.ClaimFormatTypeUid = lcft.ClaimFormatTypeUid
			inner join ClaimFormatOption cfo on lcfot.ClaimFormatOptionTypeUid = cfo.ClaimFormatOptionTypeUid
			inner join ListClaimFormat lcf on cfo.ClaimFormatUid = lcf.ClaimFormatUid
			inner join ListClaimFormatValueType lcfvt on cfo.ClaimFormatValueTypeUid = lcfvt.ClaimFormatValueTypeUid
	where lcfot.ClaimFormatOptionTypeUid = 'EC66D3D8-193B-416E-95B4-3A5DC1D088B4'		-- Submitter ID on electronic payer
			and cfo.ClaimFormatUid = @ClaimformatUid -- 'F43FD3CD-C30F-4CF3-A579-3759DA6441F0'				-- Claim Format ( i.e. e-Medicare )

	INSERT INTO #XMLClaims_temp
	(
		tag,
		parent,
		[SITE!100!PID],
		[SITE!100!eClaimBatchGUID],
		[SITE!100!claimSubmitterID!hide],
		[SITE!100!payToAddressID!hide],
		[RENDERER!410!ID!hide],
		[RENDERER!410!PEID],
		[SUBSCRIBER!200!PEID],
		[PAYER!230!ID!hide],
		[PAYER!230!CarrierID],
		[PAYER!230!planType],
		[PAYER!230!orgName],
		[PAYER!230!planName],
		[PAYER!230!address1],
		[PAYER!230!address2],
		[PAYER!230!city],
		[PAYER!230!state],
		[PAYER!230!zip],
		[PAYER!230!phone],
		[PAYER!230!capitated],
		[PAYER!230!acceptAssignment],
		[PAYER!230!Inactive],  --Added for Inactive Insurance Payer.
		[PAYER!230!codes] ,
		[PAYER!230!Mammcodes] ,--4974
		[PAYER!230!IDType],
		[PAYER!230!ID],
		[PAYER!230!elecPayerID],
		[PAYER!230!EPSDTCodes],--added 08/04/2009 for 1430
		[PAYER!230!PayerOrgID]	, --added 2418 9/29/09
		[PAYER!230!ClearingHouseName], --added 2418 9/29/09
		[PAYER!230!SuperiorMedicaid],--added 2418 and 2209 9/29/09
		[PAYER!230!TexasMedicaid], --added 2418 and 2209 9/29/09
		[PAYER!230!TaxonomyCode],  -- added for 13369, 13953 3/21/12
        [FINANCIALCENTER!105!FCID],
        [FINANCIALCENTER!105!SubmitterID],   
		[CLAIM!400!AccountID],
		[CLAIM!400!AccountPeriodID] 
	)
	SELECT DISTINCT
		230 						AS tag,
		200 						AS parent,
		#XMLClaims_temp.[SITE!100!PID]		AS [SITE!100!PID],
		[SITE!100!eClaimBatchGUID]			AS [SITE!100!eClaimBatchGUID],
		[SITE!100!claimSubmitterID!hide]		AS [SITE!100!claimSubmitterID!hide],
		[SITE!100!payToAddressID!hide]			AS [SITE!100!payToAddressID!hide],
		[RENDERER!410!ID!hide]				AS [RENDERER!410!ID!hide],
		[RENDERER!410!PEID]				AS [RENDERER!410!PEID],
		#XMLClaims_temp.[SUBSCRIBER!200!PEID] 	AS [SUBSCRIBER!200!PEID],

		InsuranceCarrier.CorporationUid			AS [PAYER!230!ID!hide], --InsurancePlan.InsurancePlanUid
		InsuranceCarrier.CorporationUid			AS [PAYER!230!CarrierID],
		COALESCE (ListAccountType.ANSICode, '') AS [PAYER!230!planType],
		Corporation.Name				AS [PAYER!230!orgName],
		InsurancePlan.Name				AS [PAYER!230!planName],

		CASE WHEN InsurancePlan.UseCarrierAddress = 1 THEN 
			Corporation.[Address].value('(/Address/Address1)[1]', 'VARCHAR(100)')
		ELSE
			InsurancePlan.[Address].value('(/Address/Address1)[1]', 'VARCHAR(100)')
		END AS [PAYER!230!address1],
		CASE WHEN InsurancePlan.UseCarrierAddress = 1 THEN 
			Corporation.[Address].value('(/Address/Address2)[1]', 'VARCHAR(100)')
		ELSE
			InsurancePlan.[Address].value('(/Address/Address2)[1]', 'VARCHAR(100)')
		END AS [PAYER!230!address2],
		CASE WHEN InsurancePlan.UseCarrierAddress = 1 THEN 
			Corporation.[Address].value('(/Address/City)[1]', 'VARCHAR(100)')
		ELSE
			InsurancePlan.[Address].value('(/Address/City)[1]', 'VARCHAR(100)')
		END AS [PAYER!230!city],
		UPPER(CASE WHEN InsurancePlan.UseCarrierAddress = 1 THEN 
			Corporation.[Address].value('(/Address/State)[1]', 'VARCHAR(100)')
		ELSE
			InsurancePlan.[Address].value('(/Address/State)[1]', 'VARCHAR(100)')
		END) AS [PAYER!230!state],
		CASE WHEN InsurancePlan.UseCarrierAddress = 1 THEN 
			Corporation.[Address].value('(/Address/Zip)[1]', 'VARCHAR(100)')
		ELSE
			InsurancePlan.[Address].value('(/Address/Zip)[1]', 'VARCHAR(100)')
		END AS [PAYER!230!zip],
		dbo.stripSpecialChars(CASE WHEN InsurancePlan.UseCarrierAddress = 1 THEN 
			Corporation.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)')
		ELSE
			InsurancePlan.Phone.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)')
		END ) AS [PAYER!230!phone],

		InsurancePlan.IsCapitated			AS [PAYER!230!capitated],	

		(CASE WHEN InsuranceCarrier.AcceptAssignment = 1 THEN
			'A'
		ELSE
			'C'
		END)						AS [PAYER!230!acceptAssignment],
		--Added for Inactive Insurance Payer.
        InsuranceCarrier.Inactive  	AS [PAYER!230!Inactive],
		ISNULL(CAST(cfo.codes AS VARCHAR(50)),'')	 AS [PAYER!230!codes] ,
		ISNULL(CAST(cfo2.codes AS VARCHAR(50)),'')	[PAYER!230!Mammcodes] ,--4974
		'PI'						AS [PAYER!230!IDType],
		lep.ClearingHousePayerID 			AS [PAYER!230!ID],
		ISNULL(CAST(lep.ElectronicPayerUid AS VARCHAR(50)),'')			AS [PAYER!230!elecPayerID],
		--
		
		ISNULL(cfo1.Codes ,'')	 AS [PAYER!230!EPSDTCodes],
		lep.PayerOrgID 			AS [PAYER!230!PayerOrgID],--added 2418 9/29/09
		ListClaimClearinghouse.Name as [PAYER!230!ClearingHouseName],--added 2418 9/29/09
		--(CASE WHEN ListAccountType.ANSICode = 'MC'  AND (Corporation.Name LIKE '%Superior%') THEN '1' ELSE	'0' 	END) AS  [PAYER!230!SuperiorMedicaid],--added 2418 and 2209 9/29/09
		'0' AS  [PAYER!230!SuperiorMedicaid], --added 30369 07/24/2014

       --(CASE WHEN ListAccountType.ANSICode = 'MC' AND Corporation.[Address].value('(/Address/State)[1]', 'VARCHAR(2)') =  'TX'	THEN '1'	ELSE'0'	END) AS  [PAYER!230!TexasMedicaid],--added 2418 and 2209 9/29/09	
       '0' AS  [PAYER!230!TexasMedicaid],--added 30369 07/24/2014	
		dbo.UDF_getFormatVaribleValue(0, @taxonomyClaimFormatValueTypeUid, 0, NULL, NULL, NULL, NULL, [FINANCIALCENTER!105!FCID]) AS [PAYER!230!TaxonomyCode],
        [FINANCIALCENTER!105!FCID] AS   [FINANCIALCENTER!105!FCID],
   		[FINANCIALCENTER!105!SubmitterID] AS [FINANCIALCENTER!105!SubmitterID],
		#XMLClaims_temp.[CLAIM!400!AccountID] AS [CLAIM!400!AccountID],
		#XMLClaims_temp.[CLAIM!400!AccountPeriodID] AS [CLAIM!400!AccountPeriodID] 
	FROM #XMLClaims_temp
		INNER JOIN InsurancePlan ON InsurancePlan.InsurancePlanUid = [PAYER!230!planType!hide]	--ClaimBatchDetail.InsurancePlanUid
		INNER JOIN InsuranceCarrier ON InsuranceCarrier.CorporationUid = [PAYER!230!ID!hide]		--InsurancePlan.InsuranceCarrierUid --[PAYER!230!ID!hide]
		INNER JOIN Corporation ON Corporation.CorporationUid = InsuranceCarrier.CorporationUid
		LEFT JOIN ListAccountType ON ListAccountType.AccountTypeUid =  -- InsuranceCarrier.AccountTypeUid	
											CASE WHEN InsurancePlan.UseInsuranceCarrierAccountType = 1 THEN InsuranceCarrier.AccountTypeUid		--Added by Aji 2006 03 22
												ELSE InsurancePlan.AccountTypeUid END
		LEFT join claimformatoption cfo on cfo.claimformatuid = CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.electronicclaimformatuid		--Added by Aji 2006 03 22
		ELSE InsurancePlan.electronicclaimformatuid END and cfo.fixedvalue is null and cfo.claimformatvaluetypeuid = 'FFF19D24-8250-4355-9B4B-60333EAEF3E4'
		LEFT join listclaimformatvaluetype lcfvt on lcfvt.claimformatvaluetypeuid = cfo.claimformatvaluetypeuid 
		LEFT join claimformatoption cfo1 on cfo1.claimformatuid = CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.electronicclaimformatuid		
		ELSE InsurancePlan.electronicclaimformatuid END and cfo1.fixedvalue is null and cfo1.claimformatvaluetypeuid = 'FE1D5047-6059-4051-B041-08C33031BB9F'
		LEFT join listclaimformatvaluetype lcfvt1 on lcfvt1.claimformatvaluetypeuid = cfo1.claimformatvaluetypeuid 

		LEFT join claimformatoption cfo2 on cfo1.claimformatuid = CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.electronicclaimformatuid		
		ELSE InsurancePlan.electronicclaimformatuid END and cfo1.fixedvalue is null and cfo2.claimformatvaluetypeuid = 'E8BC8BFD-D327-48B3-8188-1A166BBD4906'
		LEFT join listclaimformatvaluetype lcfvt2 on lcfvt2.claimformatvaluetypeuid = cfo2.claimformatvaluetypeuid 

		LEFT JOIN ListElectronicPayer lep ON lep.ElectronicPayerUid = InsuranceCarrier.ElectronicPayerUid
		left join ListClaimClearinghouse on ListClaimClearinghouse.ClaimClearinghouseUID = lep.ClaimClearinghouseUID--added 2418 9/29/09
	WHERE
		tag IN (200)	
		AND [PAYER!230!ID!hide] IS NOT NULL

	-- Substitution text for Payer ID  ONLY IF MapItems exist for MapSource Service Site payer ID Mapping
	UPDATE xtPayer SET xtPayer.[PAYER!230!ID] = COALESCE(NULLIF(CONVERT(varchar(80),mi.SubstitutionText),''), xtPayer.[PAYER!230!ID])
	FROM #XMLClaims_temp xt
		INNER JOIN SuperbillAggregate sba  ON xt.[Claim!400!PID] = sba.SuperbillUid AND xt.tag = 400 
		INNER JOIN InsurancePlan ip ON sba.CurrentInsurancePlanUid = ip.insuranceplanuid
		INNER JOIN #xmlclaims_temp xtPayer ON ip.InsuranceCarrierUid = xtPayer.[Payer!230!ID!Hide] AND xtPayer.tag = 230 -- PAYER tag
		INNER JOIN MapItem mi on xtPayer.[Payer!230!ID!Hide] = mi.FindTableFromItemUid
									   AND sba.ServiceSiteUid = mi.FindTableToItemUid
									   AND mi.MapSourceUid = '9D67626A-1CE9-4642-AAAD-181C305E5052'


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_PAYTOPROVIDER]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_PAYTOPROVIDER] AS' 
END
GO
/*
Modifications : Regarding DEFECT #9657	: 26 Feb 2007	: FIG
*/


ALTER PROC [dbo].[AR_genXMLClaims_PAYTOPROVIDER]
AS

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],
	[PAYTOPROVIDER!130!PID],
	[PAYTOPROVIDER!130!PEID],
	[PAYTOPROVIDER!130!orgName],
	[PAYTOPROVIDER!130!FN],
	[PAYTOPROVIDER!130!LN],
	[PAYTOPROVIDER!130!address1],
	[PAYTOPROVIDER!130!address2],
	[PAYTOPROVIDER!130!city],
	[PAYTOPROVIDER!130!state],
	[PAYTOPROVIDER!130!zip],
	[PAYTOPROVIDER!130!phone],
	[PAYTOPROVIDER!130!IDType],
	[PAYTOPROVIDER!130!ID],

	--DEFECT #9657
	[PAYTOPROVIDER!130!NPISecIDType],
    [PAYTOPROVIDER!130!NPISecID],

	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
     [FINANCIALCENTER!105!FCID] 
)

SELECT DISTINCT
	130 								AS Tag,
	110 								AS parent,
	[SITE!100!PID]						AS [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]			AS [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]	AS [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]		AS [SITE!100!payToAddressID!hide],
	ListServiceSite.ServiceSiteUid		AS [PAYTOPROVIDER!130!PID],

	NULL								AS [PAYTOPROVIDER!130!PEID],

	-- BILLINGPROVIDER!120!FileAsGroup not used to determine ListServiceSite or Corporation.  
	-- ALWAYS assume corporation
	--CASE [BILLINGPROVIDER!120!FileAsGroup] WHEN 0 
	--                                       THEN ListServiceSite.Name	
	--									   ELSE Corporation.Name END	AS [PAYTOPROVIDER!130!orgName],
	ListServiceSite.Name AS [PAYTOPROVIDER!130!orgName],
	NULL								AS [PAYTOPROVIDER!130!FN],  
	NULL								AS [PAYTOPROVIDER!130!LN], -- Assumes always orgName
	ListServiceSite.[Address].value('(/Address/Address1)[1]', 'VARCHAR(100)') AS [PAYTOPROVIDER!130!address1],
	ListServiceSite.[Address].value('(/Address/Address2)[1]', 'VARCHAR(100)') AS [PAYTOPROVIDER!130!address2],
	ListServiceSite.[Address].value('(/Address/City)[1]', 'VARCHAR(100)') AS [PAYTOPROVIDER!130!city],
	UPPER( ListServiceSite.[Address].value('(/Address/State)[1]', 'VARCHAR(100)')) AS [PAYTOPROVIDER!130!state],
	ListServiceSite.[Address].value('(/Address/Zip)[1]', 'VARCHAR(100)') AS [PAYTOPROVIDER!130!zip],
	dbo.stripSpecialChars( ListServiceSite.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)')) AS [PAYTOPROVIDER!130!phone],

	--[PAYTOPROVIDER!130!IDType] 			AS [PAYTOPROVIDER!130!IDType],
	--[PAYTOPROVIDER!130!ID]				AS [PAYTOPROVIDER!130!ID],	
	--[PAYTOPROVIDER!130!NPISecIDType]	AS	[PAYTOPROVIDER!130!NPISecIDType],
    --[PAYTOPROVIDER!130!NPISecID]		AS	[PAYTOPROVIDER!130!NPISecID],
    -- Use Billing provider identification
	[BILLINGPROVIDER!120!IDType] 			AS [PAYTOPROVIDER!130!IDType],
	[BILLINGPROVIDER!120!ID]				AS [PAYTOPROVIDER!130!ID],	
	[BILLINGPROVIDER!120!NPISecIDType]	AS	[PAYTOPROVIDER!130!NPISecIDType],
    [BILLINGPROVIDER!120!NPISecID]		AS	[PAYTOPROVIDER!130!NPISecID],
	
	[RENDERER!410!ID!hide]				AS [RENDERER!410!ID!hide],
	[RENDERER!410!PEID]					AS [RENDERER!410!PEID],
    [FINANCIALCENTER!105!FCID]          AS  [FINANCIALCENTER!105!FCID]

FROM #XMLClaims_temp
	INNER JOIN dbo.claimsubmitter ON #XMLClaims_temp.[SITE!100!claimSubmitterID!hide] = claimSubmitter.ClaimSubmitterUid 
	LEFT JOIN ListServiceSite ON claimSubmitter.PayToServiceSiteUid = ListServiceSite.ServiceSiteUid 
	INNER JOIN Provider ON Provider.PersonUid = [RENDERER!410!PEID]
	LEFT JOIN Corporation ON Provider.PayToProviderCorporationUid = Corporation.CorporationUid
	LEFT JOIN ListServiceSiteType ON ListServiceSite.ServiceSiteTypeUid = ListServiceSiteType.ServiceSiteTypeUid
WHERE
	#XMLClaims_temp.tag = 110 AND
	#XMLClaims_temp.[SITE!100!payToAddressID!hide] IS NOT NULL
	AND LEN(#XMLClaims_temp.[SITE!100!payToAddressID!hide]) > 0

UNION ALL

SELECT DISTINCT
	130 							AS Tag,
	110 							AS parent,
	[SITE!100!PID]					AS [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]			AS [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]	AS [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]		AS [SITE!100!payToAddressID!hide],
	NULL					AS [PAYTOPROVIDER!130!PID],
	Provider.PersonUid		AS [PAYTOPROVIDER!130!PEID],
	NULL					AS [PAYTOPROVIDER!130!orgName],
	NULL					AS [PAYTOPROVIDER!130!FN],
	NULL					AS [PAYTOPROVIDER!130!LN],
	NULL					AS [PAYTOPROVIDER!130!address1],
	NULL					AS [PAYTOPROVIDER!130!address2],
	NULL					AS [PAYTOPROVIDER!130!city],
	NULL					AS [PAYTOPROVIDER!130!state],
	NULL					AS [PAYTOPROVIDER!130!zip],
	NULL					AS [PAYTOPROVIDER!130!phone],
	-- Use billing provider's identification
-- 24 = Employers Identification Number | 34 = Social Security Number
	--[PAYTOPROVIDER!130!IDType] 		AS [PAYTOPROVIDER!130!IDType],
	--[PAYTOPROVIDER!130!ID]			AS [PAYTOPROVIDER!130!ID],
	[BILLINGPROVIDER!120!IDType] 		AS [PAYTOPROVIDER!130!IDType],
	[BILLINGPROVIDER!120!ID]			AS [PAYTOPROVIDER!130!ID],
    NULL	 AS 	[PAYTOPROVIDER!130!NPISecIDType],
    NULL	 AS	    [PAYTOPROVIDER!130!NPISecID],
    
	[RENDERER!410!ID!hide]			AS [RENDERER!410!ID!hide],
	[RENDERER!410!PEID]				AS [RENDERER!410!PEID],
    [FINANCIALCENTER!105!FCID]          AS  [FINANCIALCENTER!105!FCID]

FROM #XMLClaims_temp
	INNER JOIN Provider ON #XMLClaims_temp.[RENDERER!410!ID!hide] = Provider.PersonUid 
WHERE
	#XMLClaims_temp.tag = 110 AND
	#XMLClaims_temp.[SITE!100!payToAddressID!hide] IS NULL


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_PROC_ExciseTax]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_PROC_ExciseTax] AS' 
END
GO
-- Modifications:
-- 2016-10-24 dsw - 51952:Hawaii Tax Changes to be handled in Claims and ERA processing

ALTER proc [dbo].[AR_genXMLClaims_PROC_ExciseTax]
AS

	-- Retrieve all procedures with an excise tax
	--   1)  Electronic Claim Format has an "Excise Tax Code" option type specified
	--   2)  Procedure has tax ( [PROC!450!TotalTax]  != 0 )
	-- NOTE:  UDF_getFormatVaribleValue retrieves the excise procedure code.  If there is no excise procedure code and/or there is not tax then there is nothing to do so just return
	 DECLARE @exciseProcs TABLE 
	 (
	   [PROC!450!ID!hide] UNIQUEIDENTIFIER,		-- superbillProcedureUid
	   [PROC!450!count] SMALLINT,				-- display order
	   [CLAIM!400!PID] UNIQUEIDENTIFIER,		-- superbillUid
	   exciseProc VARCHAR(25),					-- excise tax procedure code
	   codeDesc VARCHAR(1024),					-- excise tax procedure code desc
	   codeType VARCHAR(50),					-- excise tax procedure code type
	   codeName VARCHAR(50)						-- excise tax 
	 ) ;
	 INSERT INTO @exciseProcs( [PROC!450!ID!hide], [PROC!450!count], [CLAIM!400!PID], exciseProc )
		SELECT	#XMLClaims_temp.[PROC!450!ID!hide],
				#XMLClaims_temp.[PROC!450!count],
				#XMLClaims_temp.[CLAIM!400!PID],
				dbo.UDF_getFormatVaribleValue(2, #XMLClaims_temp.[CLAIM!400!ElectronicClaimFormatUid],  
												20,ViewSuperbillFinancialDetails.ClaimingProviderUid,NULL,ViewSuperbillFinancialDetails.serviceSiteUID,NULL,ViewSuperbillFinancialDetails.FinancialCenterUid) AS exciseProc 
		FROM #XMLClaims_temp
				INNER JOIN  ViewSuperbillFinancialDetails ON #XMLClaims_temp.[CLAIM!400!PID] = ViewSuperbillFinancialDetails.superbillUid   -- gets information for UDF_getFormatVaribleValue function
		WHERE #XMLClaims_temp.TAG = '450' -- Procedures
				and #XMLClaims_temp.[PROC!450!TotalTax] != 0 -- MUST HAVE TAX to add an excise tax procedure

	-- Remove ANY procedure WITHOUT an excise procedure code
	DELETE FROM @exciseProcs
	WHERE exciseProc IS NULL

	-- short-circuit if no excise procs and nothing to do
	if (NOT EXISTS ( SELECT * FROM @exciseProcs )) return 

	-- Retrieve excise code description
	-- Since exciseProc is just a string it does not point to a specific procedure code.
	--  MUST find one procedure code if multiple exist.  The following ranks the excise procedure code and orders by last modified date
	;with myCTE AS
	(	-- 1) Get distinct excise procedure codes
		select DISTINCT exciseProc from @exciseProcs
	),
	myCTE2 AS
	(   -- 2) Rank by LastModifiedDate just in case there are duplicates
		select mc.exciseProc,
				ROW_NUMBER() OVER( PARTITION BY mc.exciseProc ORDER BY lp.LastModifiedDate DESC) as ranking,
				lp.ProcedureUid,
				lp.LongDescription,
				lp.ProcedureCodeTypeUid
		from myCTE mc
				INNER JOIN ListProcedure lp WITH (NOLOCK) ON mc.exciseProc = lp.Code
	)
	UPDATE @exciseProcs 
		SET codeDesc = mc2.LongDescription,
			codeType = pct.ExternalID,
			codeName = pct.Name
	FROM @exciseProcs ep
			INNER JOIN myCTE2 mc2 on ep.exciseProc = mc2.exciseProc
										AND mc2.ranking = 1				-- Upate @excise proces with #1 ranked procedure code
			INNER JOIN ListProcedureCodeType pct WITH (NOLOCK) ON mc2.ProcedureCodeTypeUid = pct.ProcedureCodeTypeUid

/*
	select #XMLClaims_temp.[PROC!450!ID!hide], #XMLClaims_temp.[PROC!450!proc], #XMLClaims_temp.[PROC!450!count] 
	from @exciseProcs ep
			INNER JOIN #XMLClaims_temp on ep.[CLAIM!400!PID] = #XMLClaims_temp.[CLAIM!400!PID]
											AND  #XMLClaims_temp.TAG = '450'
											AND  #XMLClaims_temp.[PROC!450!count] > ep.[PROC!450!count]
*/
	-- Move current procedures display order to allow for tax procedures under each one
	;with myCTE AS
	(   -- This calculates via procCount how much to move procedures following the excise procedures
		--   i.e.  If there are 3 procedures and procedure #1 and #2 both have an excise tax then procedure #3 must be moved down 2 spaces to allow for the 
		--         additional excise procedure on #1 and #2
		select #XMLClaims_temp.[PROC!450!ID!hide], COUNT(#XMLClaims_temp.[PROC!450!ID!hide]) as procCount--#XMLClaims_temp.[PROC!450!proc], #XMLClaims_temp.[PROC!450!count], 
		from @exciseProcs ep
				INNER JOIN #XMLClaims_temp on ep.[CLAIM!400!PID] = #XMLClaims_temp.[CLAIM!400!PID]
												AND  #XMLClaims_temp.TAG = '450'
												AND  #XMLClaims_temp.[PROC!450!count] > ep.[PROC!450!count] -- finds "following" procedures to the excise procedure
		group by #XMLClaims_temp.[PROC!450!ID!hide]
	)
	UPDATE #XMLClaims_temp
		SET #XMLClaims_temp.[PROC!450!count] += mc.procCount	-- adds the amount to be moved to the displayorder
		FROM myCTE mc
				INNER JOIN #XMLClaims_temp ON mc.[PROC!450!ID!hide] = #XMLClaims_temp.[PROC!450!ID!hide]
		WHERE #XMLClaims_temp.TAG = '450' -- Procedures

	-- Create "Tax" procedures for each taxed procedure
	--   Does this by duplicating the current procedure with the tax, modifying the duplicate, and then inserting back into #XMLClaims_temp
	SELECT #XMLClaims_temp.*
	INTO #XMLClaims_HTaxProcs
	from @exciseProcs ep
			INNER JOIN #XMLClaims_temp on ep.[PROC!450!ID!hide] = #XMLClaims_temp.[PROC!450!ID!hide]
			
	-- Set displayOrder, procedure code and charge (tax) on new tax procedures
	UPDATE #XMLClaims_HTaxProcs
		SET [PROC!450!ID!hide] = newid(),
			[PROC!450!count] = #XMLClaims_HTaxProcs.[PROC!450!count] + 1,
			[PROC!450!proc] = ep.exciseProc,
			[PROC!450!description] = ep.codeDesc,
			[PROC!450!charge] = [PROC!450!TotalTax],
			[PROC!450!procCodeType] = ep.codeType,
			[PROC!450!procCodeName] = ep.codeName
		FROM #XMLClaims_HTaxProcs
				INNER JOIN @exciseProcs ep ON #XMLClaims_HTaxProcs.[PROC!450!ID!hide] = ep.[PROC!450!ID!hide]

	-- Update existing procedures to remove tax
	UPDATE #XMLClaims_temp
		SET [PROC!450!charge] -= [PROC!450!TotalTax]
		FROM #XMLClaims_temp
				INNER JOIN @exciseProcs ep ON #XMLClaims_Temp.[PROC!450!ID!hide] = ep.[PROC!450!ID!hide]
		WHERE #XMLClaims_temp.TAG = '450' -- Procedures

	-- Add excise tax procedures to procedures on #XMLClaims_temp
	INSERT INTO #XMLClaims_temp
		SELECT *
		FROM #XMLClaims_HTaxProcs

	/*
	INSERT INTO #XMLClaims_temp
		select	[PROC!450!ID!hide] = newid()--,
				--[PROC!450!count] = #XMLClaims_temp.[PROC!450!count]+1,
				--[PROC!450!proc] = 'S9999',
				--[PROC!450!procM1] = #XMLClaims_temp.[PROC!450!procM1],
				--[PROC!450!procM2] = #XMLClaims_temp.[PROC!450!procM2],
				--[PROC!450!procM3] = #XMLClaims_temp.[PROC!450!procM3],
				--[PROC!450!procM4] = #XMLClaims_temp.[PROC!450!procM4],
				--[PROC!450!diag1] = #XMLClaims_temp.[PROC!450!diag1],
				--[PROC!450!diag2] = #XMLClaims_temp.[PROC!450!diag2],
				--[PROC!450!diag3] = #XMLClaims_temp.[PROC!450!diag3],
				--[PROC!450!diag4] = #XMLClaims_temp.[PROC!450!diag4],
				--[PROC!450!diag5] = #XMLClaims_temp.[PROC!450!diag5],
				--[PROC!450!diag6] = #XMLClaims_temp.[PROC!450!diag6],
				--[PROC!450!diag7] = #XMLClaims_temp.[PROC!450!diag7],
				--[PROC!450!diag8] = #XMLClaims_temp.[PROC!450!diag8],
				--[PROC!450!diag9] = #XMLClaims_temp.[PROC!450!diag9],
				--[PROC!450!diag10] = #XMLClaims_temp.[PROC!450!diag10],
				--[PROC!450!diag11] = #XMLClaims_temp.[PROC!450!diag11],
				--[PROC!450!diag12] = #XMLClaims_temp.[PROC!450!diag12],
				--[PROC!450!unitType] = #XMLClaims_temp.[PROC!450!unitType], --='UN'
				--[PROC!450!units] = #XMLClaims_temp.[PROC!450!units],
				--[PROC!450!charge] = #XMLClaims_temp.[PROC!450!TotalTax],
				--[PROC!450!procedureType] = #XMLClaims_temp.[PROC!450!procedureType],
				--[PROC!450!procCodeType] = #XMLClaims_temp.[PROC!450!procCodeType],
				--[PROC!450!procCodeName] = #XMLClaims_temp.[PROC!450!procCodeName],
				--[PROC!450!description] = #XMLClaims_temp.[PROC!450!description],
				--[PROC!450!serviceDate] = #XMLClaims_temp.[PROC!450!serviceDate],
				--[PROC!450!serviceDateEnd] = #XMLClaims_temp.[PROC!450!serviceDateEnd],
				--[PROC!450!emergency] = #XMLClaims_temp.[PROC!450!emergency],
				--[PROC!450!serviceLocation] = #XMLClaims_temp.[PROC!450!serviceLocation],
				--[PROC!450!lineControlNo] = #XMLClaims_temp.[PROC!450!lineControlNo],
				--[PROC!450!TotalTax] = #XMLClaims_temp.[PROC!450!TotalTax],
				--[PROC!450!ProcID] = #XMLClaims_temp.[PROC!450!ProcID]
	from #XMLClaims_temp
	WHERE #XMLClaims_temp.TAG = '450' -- Procedures
*/
	
	/*
	select 
		[PROC!450!ID!hide] ,
		[PROC!450!count] ,
		[PROC!450!proc] ,
		[PROC!450!procM1] ,
		[PROC!450!procM2] ,
		[PROC!450!procM3] ,
		[PROC!450!procM4] ,
		[PROC!450!diag1] ,
		[PROC!450!diag2] ,
		[PROC!450!diag3] ,
		[PROC!450!diag4] ,
		[PROC!450!diag5] ,
		[PROC!450!diag6] ,
		[PROC!450!diag7] ,
		[PROC!450!diag8] ,
		[PROC!450!diag9] ,
		[PROC!450!diag10] ,
		[PROC!450!diag11] ,
		[PROC!450!diag12] ,
		[PROC!450!unitType] , --='UN'
		[PROC!450!units] ,
		[PROC!450!charge] ,
		[PROC!450!procedureType] ,
		[PROC!450!procCodeType] ,
		[PROC!450!procCodeName],
		[PROC!450!description] ,
		[PROC!450!serviceDate],
		[PROC!450!serviceDateEnd] ,
		[PROC!450!emergency] ,
		[PROC!450!serviceLocation] ,
		[PROC!450!lineControlNo] ,
		[PROC!450!TotalTax] ,
		[PROC!450!ProcID] 
	from #XMLClaims_HTaxProcs
	WHERE #XMLClaims_HTaxProcs.TAG = '450' -- Procedures
	ORDER BY [PROC!450!count] ASC
	*/


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_PROC]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_PROC] AS' 
END
GO
-- Modifications:
--CYS SC 10/22/09 - Remove NF ContractTypeCodes
--                  adds [PROC!450!ContractTypeCodeName], [PROC!450!ContractTypeCodeAnsi]
-- 2014-05-02  dsw Performance Improvements
--					Replaced ViewSuperbillProcedure_IsVoid with ViewSuperbillProcedure_NonVoidedWithLedgers
-- 2014-07-31  dsw 16026
--                  Added PURCHASEDSERVICE
-- 2014-09-02 dsw - Added code to sum procedure charges for claim
-- 2015-03-06 dsw - Added 	[PROC!450!FamilyPlanning] BIT
-- 2016-01-08 dsw - 44998, Changed float to decimal(10,2) when summing charge.  Got imprecision otherwise
-- 2016-10-26 dsw - 51952: Hawaii Tax Changes to be handled in Claims and ERA Processing

ALTER proc [dbo].[AR_genXMLClaims_PROC]
AS


	-- Find/Map procedure substitution text
	DECLARE @ProcedureAliases TABLE -- As defined by the map items table
	(
	  superbillProcedureUid uniqueidentifier,
	  aliasText varchar(200),
	  rowNo int
	)
	INSERT INTO @ProcedureAliases(superbillProcedureUid, aliasText, rowNo)
		select sbp.SuperbillProcedureUid, mi.SubstitutionText, ROW_NUMBER() OVER( PARTITION BY sbp.SuperbillProcedureUid ORDER BY mi.LastModifiedDate desc)
		FROM #XMLClaims_temp
			  INNER JOIN SuperbillProcedure sbp ON sbp.superbillUid = #XMLClaims_temp.[CLAIM!400!PID]
												AND ISNULL(sbp.DontClaim,0) = 0
			  INNER JOIN Superbill sb on 	sbp.SuperbillUid = sb.SuperbillUid
			  INNER JOIN SuperbillAggregate sa on sb.SuperbillUid = sa.SuperbillUid
			  INNER JOIN Account act on sb.AccountUid = act.AccountUid
			  INNER JOIN AccountPeriod ap on act.AccountUid = ap.AccountUid
	  										and (ap.EffectiveDate IS NULL OR ( ap.EffectiveDate <= sb.ServiceDateEnd))
	  										and (ap.ExpirationDate IS NULL OR ( ap.ExpirationDate >= sb.ServiceDateEnd))
			  INNER JOIN AccountInsurance ai on ap.AccountPeriodUid = ai.AccountPeriodUid
												and sa.CurrentCarrier = ai.DisplayOrder
			  INNER JOIN PersonInsurancePlan pip on ai.PersonInsurancePlanUid = pip.PersonInsurancePlanUid
			  INNER JOIN InsurancePlan ip on pip.InsurancePlanUid = ip.InsurancePlanUid
			  INNER JOIN MapItem mi on ip.InsuranceCarrierUid = mi.FindTableFromItemUid
											and sbp.ProcedureUid = mi.FindTableToItemUid 
														
	--SELECT *
	--FROM @ProcedureAliases

	INSERT INTO #XMLClaims_temp
	(
		tag,
		parent,
		[SITE!100!PID],
		[SITE!100!eClaimBatchGUID],
		[SITE!100!claimSubmitterID!hide],
		[SITE!100!payToAddressID!hide],
		[RENDERER!410!ID!hide],
		[RENDERER!410!PEID],
		[CLAIM!400!PID],
	    [CLAIM!400!ChcBillingType],								-- DSW, 60093
		[PATIENT!300!PEID],
		[SUBSCRIBER!200!PEID],
		[PAYER!230!ID!hide],			
		[PROC!450!ID!hide],
		[PROC!450!count],
		[PROC!450!proc],
		[PROC!450!revenueCode],
		[PROC!450!procM1],
		[PROC!450!procM2],
		[PROC!450!procM3],
		[PROC!450!procM4],
		[PROC!450!diag1],
		[PROC!450!diag2],
		[PROC!450!diag3],
		[PROC!450!diag4],
		[PROC!450!diag5],
		[PROC!450!diag6],
		[PROC!450!diag7],
		[PROC!450!diag8],
		[PROC!450!diag9],
		[PROC!450!diag10],
		[PROC!450!diag11],
		[PROC!450!diag12],
		[PROC!450!unitType], --='UN'
		[PROC!450!units],
		[PROC!450!charge],
		[PROC!450!procedureType],
		[PROC!450!procCodeType],
		[PROC!450!procCodeName],
		[PROC!450!description],
		[PROC!450!serviceDate],
		[PROC!450!serviceDateEnd],
		[PROC!450!emergency],
		[PROC!450!serviceLocation],
		[PROC!450!lineControlNo],
		[PROC!450!TotalTax],
		[PROC!450!ProcID] ,
		[PROC!450!NoteReferenceCode],
		[PROC!450!Note],
		[PROC!450!NDC],
		[PROC!450!MedicationMeasurementValue],
		[PROC!450!MedicationMeasurementReference],
		[PROC!450!MedicationMeasurementQualifier],
		[PROC!450!COST],
		[PROC!450!NDCQuantity],
		[PROC!450!NDCUnitMeasure] ,
		[PROC!450!ContractTypeCodeName],
		[PROC!450!ContractTypeCodeAnsi],
	    [PROC!450!PaperworkTypeID],
	    [PROC!450!PaperworkTransmissionCodeID],
	    [PROC!450!PaperworkControlNum],

		[PROC!450!UserDefinedXml],

		[FINANCIALCENTER!105!FCID],
		[CLAIM!400!AccountID],
		[CLAIM!400!AccountPeriodID],
		[CLAIM!400!ElectronicClaimFormatUid]
	)
	SELECT DISTINCT

		450 						AS Tag,
		400 						AS parent,
		#XMLClaims_temp.[SITE!100!PID]		AS [SITE!100!PID],
		[SITE!100!eClaimBatchGUID]			AS [SITE!100!eClaimBatchGUID],
		[SITE!100!claimSubmitterID!hide]		AS [SITE!100!claimSubmitterID!hide],
		[SITE!100!payToAddressID!hide]			AS [SITE!100!payToAddressID!hide],
		[RENDERER!410!ID!hide]				AS [RENDERER!410!ID!hide],
		[RENDERER!410!PEID]				AS [RENDERER!410!PEID],
		#XMLClaims_temp.[CLAIM!400!PID]		AS [CLAIM!400!PID],
		#XMLClaims_temp.[CLAIM!400!ChcBillingType] AS [CLAIM!400!ChcBillingType], -- DSW 60093
		#XMLClaims_temp.[PATIENT!300!PEID]		AS [PATIENT!300!PEID],
		#XMLClaims_temp.[SUBSCRIBER!200!PEID]	AS [SUBSCRIBER!200!PEID],
		#XMLClaims_temp.[PAYER!230!ID!hide]		AS [PAYER!230!ID!hide],


		SuperbillProcedure.SuperbillProcedureUid		AS [PROC!450!ID!hide],
		dbo.GetSuperbillProcedureRowNumber(SuperbillProcedure.SuperbillProcedureUid) AS [PROC!450!count],
		COALESCE( al.aliasText, ListProcedure.Code ) AS [PROC!450!proc],
		ListProcedure.RevenueCode               AS [PROC!450!revenueCode], -- 60093
		(CASE 	WHEN dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 1) = '' 
		        THEN NULL
			    ELSE dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 1) END)						AS [PROC!450!procM1],
		(CASE 	WHEN dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 2) = '' 
		        THEN NULL
			    ELSE dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 2) END)						AS [PROC!450!procM2],
		(CASE 	WHEN dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 3) = '' 
		        THEN NULL
			    ELSE dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 3) END)						AS [PROC!450!procM3],
		(CASE 	WHEN dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 4) = '' 
		        THEN NULL
			    ELSE dbo.UDF_getModifier(SuperbillProcedure.superbillUid, SuperbillProcedure.SuperBillProcedureUid, 4) END)						AS [PROC!450!procM4],
		
		(CASE 	WHEN SuperbillProcedure.DiagnosisPointer1 = 0 THEN NULL	ELSE SuperbillProcedure.DiagnosisPointer1 END)						AS [PROC!450!diag1],
		(CASE 	WHEN SuperbillProcedure.DiagnosisPointer2 = 0 THEN NULL ELSE SuperbillProcedure.DiagnosisPointer2 END)						AS [PROC!450!diag2],
		(CASE 	WHEN SuperbillProcedure.DiagnosisPointer3 = 0 THEN NULL ELSE SuperbillProcedure.DiagnosisPointer3 END)						AS [PROC!450!diag3],
		(CASE 	WHEN SuperbillProcedure.DiagnosisPointer4 = 0 THEN NULL ELSE SuperbillProcedure.DiagnosisPointer4 END)						AS [PROC!450!diag4],
		(CASE 	WHEN SuperbillProcedure.DiagnosisPointer5 = 0 THEN NULL ELSE SuperbillProcedure.DiagnosisPointer5 END)						AS [PROC!450!diag5],
		(CASE 	WHEN SuperbillProcedure.DiagnosisPointer6 = 0 THEN NULL ELSE SuperbillProcedure.DiagnosisPointer6 END)						AS [PROC!450!diag6],
		(CASE 	WHEN SuperbillProcedure.DiagnosisPointer7 = 0 THEN NULL ELSE SuperbillProcedure.DiagnosisPointer7 END)						AS [PROC!450!diag7],
		(CASE 	WHEN SuperbillProcedure.DiagnosisPointer8 = 0 THEN NULL ELSE SuperbillProcedure.DiagnosisPointer8 END)						AS [PROC!450!diag8],
		(CASE 	WHEN SuperbillProcedure.DiagnosisPointer9 = 0 THEN NULL ELSE SuperbillProcedure.DiagnosisPointer9 END)						AS [PROC!450!diag9],
		(CASE 	WHEN SuperbillProcedure.DiagnosisPointer10 = 0 THEN NULL ELSE SuperbillProcedure.DiagnosisPointer10 END)						AS [PROC!450!diag10],
		(CASE 	WHEN SuperbillProcedure.DiagnosisPointer11 = 0 THEN NULL ELSE SuperbillProcedure.DiagnosisPointer11 END)						AS [PROC!450!diag11],
		(CASE 	WHEN SuperbillProcedure.DiagnosisPointer12 = 0 THEN NULL ELSE SuperbillProcedure.DiagnosisPointer12 END)						AS [PROC!450!diag12],

		'UN'						AS [PROC!450!unitType],
		CONVERT(VARCHAR,SuperbillProcedure.Units)	AS [PROC!450!units],
		CONVERT(VARCHAR,SuperbillProcedure.TotalCharge,0) AS [PROC!450!charge],
		ListProcedureServiceType.ANSICode		AS [PROC!450!procedureType],
		'HC'						AS [PROC!450!procCodeType],
		ListProcedureCodeType.Name AS [PROC!450!procCodeName],
		ListProcedure.ShortDescription			AS [PROC!450!description],
		CONVERT(VARCHAR, SuperbillProcedure.ProcedureServiceDateStart, 101)			AS [PROC!450!serviceDate],
		CONVERT(VARCHAR, SuperbillProcedure.ProcedureServiceDateEnd, 101)			AS [PROC!450!serviceDateEnd],
		[PROC!450!emergency]				AS [PROC!450!emergency],
		[PROC!450!serviceLocation]			AS [PROC!450!serviceLocation],
		[PROC!450!lineControlNo]+''+CONVERT(VARCHAR,SuperbillProcedure.DisplayOrder)	AS [PROC!450!lineControlNo],
		SuperbillProcedure.TotalTax		AS [PROC!450!TotalTax],
		SuperbillProcedure.SuperbillProcedureUID AS [PROC!450!ProcID] ,
 		'ADD'                    AS  [PROC!450!NoteReferenceCode],
		CASE WHEN COALESCE(SuperbillProcedure.NDC,'') = '' 
		     THEN CONVERT(VARCHAR(80),SUBSTRING(COALESCE(SuperbillProcedure.Notes,''),1,80),80)
			 WHEN SuperbillProcedure.NDC IS NOT NULL AND disp.MedDesc IS NOT NULL 
			 THEN SUBSTRING( (Convert(varchar(80), disp.MedDesc) + ' ' + Convert(varchar(80), COALESCE(SuperbillProcedure.Notes,''))), 1, 80)
			 WHEN SuperbillProcedure.NDC IS NOT NULL AND listProcedure.LongDescription IS NOT NULL 
			 THEN SUBSTRING( (Convert(varchar(80), listProcedure.LongDescription) + ' ' + Convert(varchar(80), COALESCE(SuperbillProcedure.Notes,''))), 1, 80)
			 ELSE CONVERT(VARCHAR(80),SUBSTRING(COALESCE(SuperbillProcedure.Notes,''),1,80),80) END  AS  [PROC!450!Note],
		COALESCE(SuperbillProcedure.NDC,'') AS  [PROC!450!NDC],
		SuperbillProcedure.MedicationMeasurementValue AS [PROC!450!MedicationMeasurementValue],
		SuperbillProcedure.MedicationMeasurementReference AS [PROC!450!MedicationMeasurementReference],
		ListMeasurementQualifier.ANSICode AS [PROC!450!MedicationMeasurementQualifier]	,
		SuperbillProcedure.COST AS [PROC!450!COST],
		SuperbillProcedure.NDCQuantity AS [PROC!450!NDCQuantity],
		CONVERT(VARCHAR(2),listNDCUnitMeasure.ANSICode)  AS[PROC!450!NDCUnitMeasure] ,
		ISNULL(ListContractTypeCode.Name,'') AS [PROC!450!ContractTypeCodeName],
		ISNULL(ListContractTypeCode.ANSICode,'') AS [PROC!450!ContractTypeCodeAnsi],
	    SUBSTRING(ISNULL(lpt.ANSICode, ''), 1, 2) AS [PROC!450!PaperworkTypeID],
	    SUBSTRING(ISNULL(lptc.ANSICode, ''), 1, 2) AS  [PROC!450!PaperworkTransmissionCodeID],
	    SUBSTRING(ISNULL(SuperbillProcedure.PaperworkControlNum, ''), 1, 50) AS  [PROC!450!PaperworkControlNum],
		convert(varchar(8000),SuperbillProcedure.UserDefinedXml) AS [PROC!450!UserDefinedXml],
		 [FINANCIALCENTER!105!FCID]   AS  [FINANCIALCENTER!105!FCID],
		 #XMLClaims_temp.[CLAIM!400!AccountID] as [CLAIM!400!AccountID],
		 #XMLClaims_temp.[CLAIM!400!AccountPeriodID] as [CLAIM!400!AccountPeriodID],
		 #XMLClaims_temp.[CLAIM!400!ElectronicClaimFormatUid] AS [CLAIM!400!ElectronicClaimFormatUid]
	FROM #XMLClaims_temp
			INNER JOIN SuperbillProcedure ON SuperbillProcedure.superbillUid = #XMLClaims_temp.[CLAIM!400!PID]
												AND ISNULL(SuperbillProcedure.DontClaim,0) = 0
												AND ISNULL(SuperbillProcedure.Inactive,0) = 0
			INNER JOIN ViewSuperbillProcedure_NonVoidedWithLedgers sbpnv with (nolock) on SuperbillProcedure.SuperbillProcedureUid = sbpnv.superbillProcedureUid
			INNER JOIN ListProcedure ON	ListProcedure.ProcedureUid = SuperbillProcedure.ProcedureUid
			LEFT JOIN ListProcedureCodeType ON ListProcedureCodeType.ProcedureCodeTypeUid = ListProcedure.ProcedureCodeTypeUid
													AND ListProcedureCodeType.Name IN ('CPT','HCPCS', 'PQRI')
			LEFT JOIN ListProcedureServiceType ON ListProcedureServiceType.ProcedureServiceTypeUid = ListProcedure.ProcedureServiceTypeUid
			LEFT JOIN listNDCUnitMeasure on listNDCUnitMeasure.NDCUnitMeasureUID = SuperbillProcedure.NDCUnitMeasureUID
			LEFT JOIN ListMeasurementQualifier ON ListMeasurementQualifier.MeasurementQualifierUid = SuperbillProcedure.MedicationMeasurementQualifierUID
			LEFT JOIN ListContractTypeCode ON ListContractTypeCode.ContractTypeCodeUid = SuperbillProcedure.ContractTypeCodeUid
			LEFT OUTER JOIN dbo.NDD_SearchDispensable disp on disp.IsDelete = 0 AND SuperbillProcedure.FDB_MEDID = disp.medid
			LEFT OUTER JOIN @ProcedureAliases al on superbillProcedure.SuperbillProcedureUid = al.superbillProcedureUid
														AND al.rowNo = 1
			LEFT OUTER JOIN ListPaperworkType lpt on superbillProcedure.PaperworkTypeUid = lpt.PaperworkTypeUid
			LEFT OUTER JOIN ListPaperworkTransmissionCode lptc on SuperbillProcedure.PaperworkTransmissionCodeUid = lptc.PaperworkTransmissionCodeUid
	WHERE
		#XMLClaims_temp.tag = 400 
	DELETE #XMLClaims_temp WHERE TAG = '450' AND
		([PROC!450!ContractTypeCodeName] = 'NF' OR [PROC!450!ContractTypeCodeAnsi] = 'NF')

	-- PurchasedServiceCharge
	--  Purchased Service / Outside Lab for this specific procedure
	INSERT INTO #XMLClaims_temp
	(
		tag,
		parent,
		[SITE!100!PID],
		[SITE!100!eClaimBatchGUID],
		[FINANCIALCENTER!105!FCID],
		[RENDERER!410!ID!hide],
		[SUBSCRIBER!200!PEID],
		[CLAIM!400!AccountID],
		[CLAIM!400!AccountPeriodID] ,
		[PATIENT!300!PEID],
		[CLAIM!400!PID],
		[PROC!450!ID!hide],
		[PROC!450!count],
		[PROC!450!proc],
		[PURCHASEDSERVICE!455!PURCHASEDSERVICEUID],
		[PURCHASEDSERVICE!455!Charge] ,
		[PURCHASEDSERVICE!455!Name] ,
		[PURCHASEDSERVICE!455!NPI],
		[PURCHASEDSERVICE!455!orgName],
		[PURCHASEDSERVICE!455!ID2] ,	-- 4010, Loop 2310C, Purchased Service Provider Secondary Identification
		[PURCHASEDSERVICE!455!IDType2] 		-- 4010, Loop 2310C, Purchased Service Provider Secondary Identification		 
	)
	SELECT DISTINCT
		455 						AS Tag,			-- PURCHASEDSERVICE
		450 						AS parent,		-- PROC
		#XMLClaims_temp.[SITE!100!PID]		AS [SITE!100!PID],
		#XMLClaims_temp.[SITE!100!eClaimBatchGUID]			AS [SITE!100!eClaimBatchGUID],
		#XMLClaims_temp.[FINANCIALCENTER!105!FCID]   AS  [FINANCIALCENTER!105!FCID],
		#XMLClaims_temp.[RENDERER!410!ID!hide]				AS [RENDERER!410!ID!hide],
		#XMLClaims_temp.[SUBSCRIBER!200!PEID]		AS [SUBSCRIBER!200!PEID],
		#XMLClaims_temp.[CLAIM!400!AccountID] as [CLAIM!400!AccountID],
		#XMLClaims_temp.[CLAIM!400!AccountPeriodID] as [CLAIM!400!AccountPeriodID],
		#XMLClaims_temp.[PATIENT!300!PEID]		AS [PATIENT!300!PEID],
		#XMLClaims_temp.[CLAIM!400!PID]		AS [CLAIM!400!PID],
		#XMLClaims_temp.[PROC!450!ID!hide]  AS [PROC!450!ID!hide],
		#XMLClaims_temp.[PROC!450!count]	AS [PROC!450!count],
		#XMLClaims_temp.[PROC!450!proc]		AS [PROC!450!proc],

		msp.CorporationUid					AS [PURCHASEDSERVICE!455!PURCHASEDSERVICEUID],
		CONVERT(VARCHAR, sbp.PurchasedServiceCharge, 0)			AS   [PURCHASEDSERVICE!455!Charge] ,
		corp.Name							AS   [PURCHASEDSERVICE!455!Name] ,	
		dbo.UDF_getFormatVariableValueByMedicalServicesProviderUid(	'C9BB7DB2-26B1-40C5-BF4D-52FD702100FA', -- C9BB7DB2-26B1-40C5-BF4D-52FD702100FA==Medical Services Provider NPI
																	sbp.MedicalServicesProviderUid,
																	sba.ServiceSiteUid,
																	sba.FinancialCenterUid)
																	AS [PURCHASEDSERVICE!455!NPI] , 
		corp.Name								AS [PURCHASEDSERVICE!455!orgName],
		dbo.UDF_getFormatVariableValueByMedicalServicesProvider( #XMLClaims_temp.[CLAIM!400!ElectronicClaimFormatUid], 
		                                                         2, 0, -- ElectronicClaimFormat, 'Purchased Service ID'
																 sbp.MedicalServicesProviderUid, sba.ServiceSiteUid, sba.FinancialCenterUid
															    ) AS [PURCHASEDSERVICE!455!ID2],
		dbo.UDF_getFormatVariableValueByMedicalServicesProvider( #XMLClaims_temp.[CLAIM!400!ElectronicClaimFormatUid], 
		                                                         2, 1, -- ElectronicClaimFormat, 'Purchased Service ID Type'
																 sbp.MedicalServicesProviderUid, sba.ServiceSiteUid, sba.FinancialCenterUid
															    ) AS [PURCHASEDSERVICE!455!IDType2]
	FROM #XMLClaims_temp
			INNER JOIN SuperbillProcedure sbp with (nolock) ON  #XMLClaims_temp.[PROC!450!ID!hide] = sbp.SuperbillProcedureUid
			INNER JOIN MedicalServicesProvider msp with (nolock) ON sbp.MedicalServicesProviderUid = msp.CorporationUid
			INNER JOIN Corporation corp with (nolock) on msp.CorporationUid = corp.CorporationUid
			INNER JOIN SuperbillAggregate sba with (nolock) on sbp.SuperbillUid = sba.SuperbillUid
	WHERE
		#XMLClaims_temp.tag = 450  -- PROC 

	-- SET #XMLClaims_temp.[Claim!400!totalBill] by summing procedure charges
	-- Bug 44998 - Changed float to decimal(10,2)	01/08/2016
	;with myCTE as
	(
		select #XMLClaims_temp.[CLAIM!400!PID] as uid,
				sum(cast(coalesce(#XMLClaims_temp.[PROC!450!charge], '0') as decimal(10,2))) as total
		from #XMLClaims_temp
		WHERE tag = 450
		group by #XMLClaims_temp.[CLAIM!400!PID]
	)
	UPDATE #XMLClaims_temp
	SET #XMLClaims_temp.[Claim!400!totalBill] = 
			CASE WHEN mc.total = 0 THEN '0' ELSE CONVERT(varchar(12), mc.total, 128) END  -- new
	From #XMLClaims_temp		
			INNER JOIN myCTE mc ON #XMLClaims_temp.[CLAIM!400!PID] = mc.uid
	WHERE #XMLClaims_temp.tag = 400


	UPDATE #XMLClaims_temp
	Set #XMLClaims_temp.[PROC!450!FamilyPlanning] = fsf.FamilyPlanning
	from #XMLClaims_temp
			INNER JOIN SuperbillProcedure sbp with (nolock) ON #XMLClaims_temp.[PROC!450!ProcID] = sbp.SuperbillProcedureUid
			INNER JOIN Superbill sb with (nolock) on sbp.superbillUid = sb.SuperbillUid
			INNER JOIN ListProcedure lp with (nolock) ON sbp.ProcedureUid = lp.ProcedureUid
			INNER JOIN FeeSchedulePeriod fsp with (nolock) on sb.AmountAllowedSchedulePeriodUid = fsp.FeeSchedulePeriodUid
			INNER JOIN FeeScheduleFee fsf with (nolock) on fsp.FeeSchedulePeriodUid = fsf.FeeSchedulePeriodUid
							and lp.ProcedureUid = fsf.ProcedureUid
							and fsf.FamilyPlanning = 1
	WHERE #XMLClaims_temp.TAG = '450' -- Procedures

	-- Bug 51952: Hawaii Tax Changes to be handled in Claims and ERA Processing
	exec AR_genxmlclaims_PROC_ExciseTax


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_PROC_MA]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_PROC_MA] AS' 
END
GO
-- Modifications:
--CYS SC 10/22/09 - Remove NF ContractTypeCodes
--                  adds [PROC!450!ContractTypeCodeName], [PROC!450!ContractTypeCodeAnsi]
-- 2014-05-02  dsw Performance Improvements
--					Replaced ViewSuperbillProcedure_IsVoid with ViewSuperbillProcedure_NonVoidedWithLedgers
-- 2014-07-31  dsw 16026
--                  Added PURCHASEDSERVICE
-- 2014-09-02 dsw - Added code to sum procedure charges for claim
-- 2015-03-06 dsw - Added 	[PROC!450!FamilyPlanning] BIT
-- 2016-01-08 dsw - 44998, Changed float to decimal(10,2) when summing charge.  Got imprecision otherwise
-- 2016-10-26 dsw - 51952: Hawaii Tax Changes to be handled in Claims and ERA Processing

ALTER proc [dbo].[AR_genXMLClaims_PROC_MA]
AS

-- CHC Changes
/***** Medicare A Rollup Logic ********************************************
MA SP Rolls up the revenue codes - all fees for a specific rev code are rolled into a single Proc for that Rev Code
Any procs with missing Rev Codes are deleted

*/

------------------------------------------------------------------------------------------------------------------------------
-- FQHC solution
-- RHC Solution ( Works like FQHC BUT ALSO uses a mapping table to override revenue codes )

-- FQHC ( chcBillingType == 0 ), RHC ( chcBillingType == 3 )
-- Groups ( Rolls Up ) procedures by revenue code
-- NOTE:  Throws out procedures with no revenue code

-- Creae a working table for all superbill procedures with FQHC revenue codes
CREATE TABLE #fqhc_temp
(
		[CLAIM!400!PID] UNIQUEIDENTIFIER,
		SuperbillProcedureUid UNIQUEIDENTIFIER,
		ProcedureUid UNIQUEIDENTIFIER,
		RevenueCode VARCHAR(10),
		RevenueCodeOrder int,
		Charge MONEY
)


-- Insert into working fqhc table ( Only those with billing type of 0 which is fqhc )
--  Revenue code procedures based on:
--     Superbill, SuperbillProcedureUid, RevenueCode
--     (Include a revenueCodeOrder to allow grouping later )
INSERT INTO #fqhc_temp( [CLAIM!400!PID], SuperbillProcedureUid, ProcedureUid, RevenueCode, Charge)
	SELECT #XMLClaims_temp.[CLAIM!400!PID] AS [CLAIM!400!PID],
		   sbp.SuperbillProcedureUid AS SuperbillProcedureUid,
		   sbp.ProcedureUid AS ProcedureUid,
		   #XMLClaims_temp.[PROC!450!revenueCode] AS RevenueCode,
		   --ROW_NUMBER() OVER( PARTITION BY #xmlClaims_temp.[CLAIM!400!PID], #XMLClaims_temp.[PROC!450!revenueCode] ORDER BY sbp.DisplayOrder asc) AS RevenueCodeOrder,
		   CASE WHEN (ISNUMERIC(#XMLClaims_temp.[PROC!450!Charge]) = 1 ) THEN CONVERT( MONEY, #XMLClaims_temp.[PROC!450!Charge]) ELSE 0 END AS Charge
	FROM #XMLClaims_temp
			INNER JOIN SuperbillProcedure sbp ON sbp.SuperbillProcedureUid = #XMLClaims_temp.[PROC!450!ID!hide]
	WHERE #XMLClaims_temp.tag = 450 -- PROC,  ( only ones remaining have revenue codes )
			AND #XMLClaims_temp.[CLAIM!400!ChcBillingType] IN (0,3) -- FQHC==0, RHC=3
			AND (IsNull([PROC!450!revenueCode],'0') != '0') -- anything WITH a revenue code
	ORDER BY sbp.DisplayOrder

----???
--	SELECT #XMLClaims_temp.[CLAIM!400!PID] AS [CLAIM!400!PID],
--		   sbp.SuperbillProcedureUid AS SuperbillProcedureUid,
--		   sbp.ProcedureUid AS ProcedureUid,
--		   #XMLClaims_temp.[PROC!450!revenueCode] AS RevenueCode,#XMLClaims_temp.[PROC!450!Charge], #XMLClaims_temp.[PROC!450!proc],
--		   --ROW_NUMBER() OVER( PARTITION BY #xmlClaims_temp.[CLAIM!400!PID], #XMLClaims_temp.[PROC!450!revenueCode] ORDER BY sbp.DisplayOrder asc) AS RevenueCodeOrder,
--		   CASE WHEN (ISNUMERIC(#XMLClaims_temp.[PROC!450!Charge]) = 1 ) THEN CONVERT( MONEY, #XMLClaims_temp.[PROC!450!Charge]) ELSE 0 END AS Charge
--	FROM #XMLClaims_temp
--			INNER JOIN SuperbillProcedure sbp ON sbp.SuperbillProcedureUid = #XMLClaims_temp.[PROC!450!ID!hide]
--	WHERE #XMLClaims_temp.tag = 450 -- PROC,  ( only ones remaining have revenue codes )
--			AND #XMLClaims_temp.[CLAIM!400!ChcBillingType] IN (0,3) -- FQHC==0, RHC=3


--select *
--from #fqhc_temp
---- ???

IF ( EXISTS( SELECT * FROM #fqhc_temp ) )
BEGIN

	-- Update procedure revenue codes with RHC ( 3 ) revenue codes (Mapping Table for RHC)
	UPDATE #XMLClaims_temp
		SET #XMLClaims_temp.[PROC!450!revenueCode] = mi.SubstitutionText
		FROM #XMLClaims_temp
				INNER JOIN #fqhc_temp ON #xmlClaims_temp.[CLAIM!400!PID] = #fqhc_temp.[CLAIM!400!PID]
				INNER JOIN MapItem mi WITH (NOLOCK) ON mi.MapSourceUid = '649D2F6A-D215-41F3-963F-E912AACAF335' -- RHC 
														AND #fqhc_temp.ProcedureUid = mi.FindTableFromItemUid
		WHERE #XMLClaims_temp.tag = 450 -- PROC
				AND #XMLClaims_temp.[PROC!450!revenueCode] IS NOT NULL
			    AND #XMLClaims_temp.[CLAIM!400!ChcBillingType] = 3 -- RHC=3 ( ONLY for RHC, NOT FOR FQHC )

	--For FQHC/RHC billing type, only want Procs with RevenueCodes
	-- Remove those without revenue codes
	DELETE #XMLClaims_temp 
	WHERE	(tag = '450') AND 
			([CLAIM!400!ChcBillingType] IN (0,3)) AND -- FQHC==0, RHC=3
			(IsNull([PROC!450!revenueCode],'0') = '0')

	-- Create a revenueCodeOrder based on "substituted" revenue code
	;with myCTE as
	(
		SELECT #fqhc_temp.[CLAIM!400!PID], #fqhc_temp.SuperbillProcedureUid, #XMLClaims_temp.[PROC!450!revenueCode] as RevenueCode,
				ROW_NUMBER() OVER( PARTITION BY #fqhc_temp.[CLAIM!400!PID], #XMLClaims_temp.[PROC!450!revenueCode] ORDER BY sbp.DisplayOrder asc) as RevenueCodeOrder
		FROM #XMLClaims_temp
				INNER JOIN #fqhc_temp ON #XMLClaims_temp.[PROC!450!ID!hide] = #fqhc_temp.SuperbillProcedureUid
				INNER JOIN SuperbillProcedure sbp WITH (NOLOCK) ON #fqhc_temp.SuperbillProcedureUid = sbp.SuperbillProcedureUid
		WHERE #XMLClaims_temp.tag = 450 -- PROC
	)
	Update #fqhc_temp
		SET RevenueCode = mc.RevenueCode,
			RevenueCodeOrder = mc.RevenueCodeOrder
	FROM #fqhc_temp
			INNER JOIN myCTE mc on #fqhc_temp.[CLAIM!400!PID] = mc.[CLAIM!400!PID] 
									AND #fqhc_temp.SuperbillProcedureUid = mc.SuperbillProcedureUid

	--
	-- select * from #fqhc_temp order by RevenueCodeOrder asc
	--

	-- Now create a common table expression summing up like revenue codes based on 
	--  superbill and revenueCode
	-- Then
	--  Update the working table with the total for each revenue code
	--   NOTE:  only change the first revenue code entry since others are duplicates and will be thrown out later
	;with myCTE AS
	(
		select #fqhc_temp.[CLAIM!400!PID], #fqhc_temp.RevenueCode, Sum( #fqhc_temp.Charge) as TotalRevCodeCharge
		from #fqhc_temp
		group by #fqhc_temp.[CLAIM!400!PID], #fqhc_temp.RevenueCode
	)
	UPDATE #fqhc_temp
		SET #fqhc_temp.Charge = myCTE.TotalRevCodeCharge
	FROM #fqhc_temp
			INNER JOIN myCTE ON #fqhc_temp.[CLAIM!400!PID] = myCTE.[CLAIM!400!PID]
									AND #fqhc_temp.RevenueCode = myCTE.RevenueCode
	WHERE #fqhc_temp.RevenueCodeOrder = 1 -- Only change the 1st entry of this revenue code

	-- Now delete all "duplicate" revenue codes
	--   Those in working table with a revenueCodeOrder > 1
	DELETE #XMLClaims_temp
	FROM #XMLClaims_temp
				INNER JOIN #fqhc_temp ON #XMLClaims_temp.[PROC!450!ID!hide] = #fqhc_temp.SuperbillProcedureUid	
	WHERE #XMLClaims_temp.tag = 450 -- PROC,  ( only ones remaining have revenue codes )
			AND #XMLClaims_temp.[CLAIM!400!ChcBillingType] IN ( 0, 3) -- FQHC==0, RHC==3
			AND #fqhc_temp.RevenueCodeOrder > 1		-- Only delete the duplicate revenue codes after the first one

	-- Now update the "first" revenue code with the new sum of all revenue codes
	Update #XMLClaims_temp
		SET #XMLClaims_temp.[PROC!450!Charge] = CONVERT(VARCHAR(10), #fqhc_temp.Charge)
	FROM #XMLClaims_temp
			INNER JOIN #fqhc_temp ON #XMLClaims_temp.[CLAIM!400!PID] = #fqhc_temp.[CLAIM!400!PID]
												AND #XMLClaims_temp.[PROC!450!ID!hide] = #fqhc_temp.SuperbillProcedureUid
	WHERE #XMLClaims_temp.tag = 450 -- proc
	-- only thing left should be thos with RevenueCodeOrder of 1

	--
	-- select * from #fqhc_temp order by RevenueCodeOrder asc
	--

	-- Update claim "Total Charge" now that everything is rolled up
	;WITH myCTE AS
	(
		select #XMLClaims_temp.[CLAIM!400!PID], SUM( CONVERT(MONEY,#XMLClaims_temp.[PROC!450!Charge])) AS TotalCharge	
		from #XMLClaims_temp
			INNER JOIN #fqhc_temp ON #XMLClaims_temp.[CLAIM!400!PID] = #fqhc_temp.[CLAIM!400!PID]
												AND #XMLClaims_temp.[PROC!450!ID!hide] = #fqhc_temp.SuperbillProcedureUid
	    WHERE #XMLClaims_temp.tag = 450 -- proc
		GROUP BY #XMLClaims_temp.[CLAIM!400!PID]
	)
	UPDATE #XMLClaims_temp 
		SET [CLAIM!400!totalBill] = CONVERT(VARCHAR(10),  mc.TotalCharge)
	FROM #XMLClaims_temp
			INNER JOIN myCTE mc on #XMLClaims_temp.[CLAIM!400!PID] = mc.[CLAIM!400!PID]
	WHERE #XMLClaims_temp.tag = 400

END

TRUNCATE TABLE 	#fqhc_temp  -- don't drop yet because used in RHC "legacy" detail ( treats RHC like FQHC )

-----------------------------------------------------------------------------------------------------------------------------------
-- RHC Detail solution
CREATE TABLE #rhc_temp
(
		[CLAIM!400!PID] UNIQUEIDENTIFIER,
		ServiceDateStart DATETIME,							-- Superbill service date
		MinDisplayOrder int,					-- minimum procedure display order on claim
		totalBill money										-- sum of charges on claim
)

-- Insert into working rhc table ( Only thos with billing type of 0 which is rhc )
INSERT INTO #rhc_temp( [CLAIM!400!PID], ServiceDateStart, totalBill)
	SELECT #XMLClaims_temp.[CLAIM!400!PID] AS [CLAIM!400!PID], sb.ServiceDateStart AS ServiceDateStart, 0 as totalBill
	FROM #XMLClaims_temp
			INNER JOIN Superbill sb WITH (NOLOCK) ON #XMLClaims_temp.[CLAIM!400!PID] = sb.SuperbillUid
	WHERE #XMLClaims_temp.tag = 400 -- CLAIMS
			AND #XMLClaims_temp.[CLAIM!400!ChcBillingType] = 2 -- RHC

IF ( EXISTS( SELECT * FROM #rhc_temp ) )
BEGIN
	-- For RHC,
	-- If "Legacy RHC" then convert revenue codes to older version
	--    Part A: Get RHC Legacy Date from MapSource Notes
	DECLARE @rhcLegacyDate date
	declare @rhcLegacyInfo varchar(500)
	declare @endIndex int
	SELECT @rhcLegacyInfo = Notes FROM MapSource WITH (NOLOCK) WHERE MapSourceUid = 'A2D729F2-F416-4528-BE63-B27A0F95F001'

	select @endindex = CHARINDEX(', RHCs are required to report', @rhcLegacyInfo)
	if ( @endIndex > 14 )
	begin
		select @rhcLegacyDate = CONVERT(date, SUBSTRING(@rhcLegacyInfo, 13, (@endIndex-13)), 104)
	end
	else
	begin
		select @rhcLegacyDate = '2016-04-01' -- If unable to "decipher" date use hard-coded date
	end

	-- test     select @rhcLegacyDate as RHCLegacyDate, 'A2D729F2-F416-4528-BE63-B27A0F95F001' AS MapSource

	-- Part B:  Update procedure revenue codes with legacy revenue codes only if before legacy date
	UPDATE #XMLClaims_temp
		SET #XMLClaims_temp.[PROC!450!revenueCode] = mi.SubstitutionText
		FROM #XMLClaims_temp
				INNER JOIN #rhc_temp ON #xmlClaims_temp.[CLAIM!400!PID] = #rhc_temp.[CLAIM!400!PID]
											AND #rhc_temp.ServiceDateStart < @rhcLegacyDate
				INNER JOIN SuperbillProcedure sbp WITH (NOLOCK) ON #XMLClaims_temp.[PROC!450!ID!hide] = sbp.SuperbillProcedureUid 
				INNER JOIN MapItem mi WITH (NOLOCK) ON mi.MapSourceUid = 'A2D729F2-F416-4528-BE63-B27A0F95F001' -- RHC Detail
														AND sbp.ProcedureUid = mi.FindTableFromItemUid
		WHERE #XMLClaims_temp.tag = 450 -- PROC
				AND #XMLClaims_temp.[PROC!450!revenueCode] IS NOT NULL

	--For RHC billing type, only want Procs with RevenueCodes
	-- Remove those without revenue codes
	DELETE #XMLClaims_temp 
	WHERE	(tag = '450') AND 
			([CLAIM!400!ChcBillingType] = 2) AND
			(IsNull([PROC!450!revenueCode],'0') = '0')

	;with myCTE AS
	(
		select #rhc_temp.[CLAIM!400!PID] AS [CLAIM!400!PID],
				SUM( CONVERT(MONEY,#XMLClaims_temp.[PROC!450!charge])) as [PROC!450!charge]
		from #rhc_temp
				INNER JOIN #XMLClaims_temp ON #rhc_temp.[CLAIM!400!PID] = #XMLClaims_temp.[CLAIM!400!PID]
	    WHERE #XMLClaims_temp.tag = 450 -- proc
		GROUP BY #rhc_temp.[CLAIM!400!PID]
	)
	UPDATE #rhc_temp
		SET totalBill = mc.[PROC!450!charge]
		FROM #rhc_temp
				INNER JOIN myCTE mc ON #rhc_temp.[CLAIM!400!PID] = mc.[CLAIM!400!PID]

	-----------------------------------------------------------------------------------------------
	-- Post Legacy claims ( After legacy date claims )
	-----------------------------------------------------------------------------------------------
	-- Part C: For "post" legacy RHC claims....
	--  The first superbill procedure contains the sum of all procedures on the claim
	--  Subsequent procedures are not changed
	;with myCTE AS
	(
		-- Retrieve the minimum superbill procedure for each rhc claim and total bill on claim so we don't have to calculate it
		SELECT #rhc_temp.[CLAIM!400!PID] as [CLAIM!400!PID], #rhc_temp.totalBill, MIN( sbp.DisplayOrder ) as minDisplayOrder
		FROM #rhc_temp
				INNER JOIN SuperbillProcedure sbp WITH (NOLOCK) ON #rhc_temp. [CLAIM!400!PID] = sbp.SuperbillUid
																	and sbp.DontClaim = 0
		WHERE #rhc_temp.ServiceDateStart >= @rhcLegacyDate
		GROUP BY #rhc_temp.[CLAIM!400!PID], #rhc_temp.totalBill
	)
	UPDATE #XMLClaims_temp
	SET #XMLClaims_temp.[PROC!450!charge] = myCTE.totalBill
	FROM #XMLClaims_temp
			INNER JOIN myCTE ON #xmlClaims_temp.[CLAIM!400!PID] = myCTE.[CLAIM!400!PID]
			INNER JOIN SuperbillProcedure sbp WITH (NOLOCK) ON #XMLClaims_temp.[PROC!450!ID!hide] = sbp.SuperbillProcedureUid 
																and myCTE.minDisplayOrder = sbp.DisplayOrder
	WHERE #XMLClaims_temp.tag = 450 -- PROC

	-- PartD: For "post" legacy RHC Claims
	-- Now that the first procedure has changed, change the total billed amount on the claim
	;with myCTE as
	(
		select #XMLClaims_temp.[CLAIM!400!PID] as uid,
				sum(cast(coalesce(#XMLClaims_temp.[PROC!450!charge], '0') as decimal(10,2))) as total
		from #XMLClaims_temp
				INNER JOIN #rhc_temp ON #xmlClaims_temp.[CLAIM!400!PID] = #rhc_temp.[CLAIM!400!PID]
											AND #rhc_temp.ServiceDateStart >= @rhcLegacyDate
		WHERE #XMLClaims_temp.tag = 450
		group by #XMLClaims_temp.[CLAIM!400!PID]
	)
	UPDATE #XMLClaims_temp
	SET #XMLClaims_temp.[Claim!400!totalBill] = 
			CASE WHEN mc.total = 0 THEN '0' ELSE CONVERT(varchar(12), mc.total, 128) END  -- new
	From #XMLClaims_temp		
			INNER JOIN myCTE mc ON #XMLClaims_temp.[CLAIM!400!PID] = mc.uid
	WHERE #XMLClaims_temp.tag = 400;
	
	-----------------------------------------------------------------------------------------------
	-- Legacy claims ( before legacy date claims )
	-- 
	-----------------------------------------------------------------------------------------------
	-- Part E: Insert into working fqhc/rhc table 
	-- Treat like FQHC FOR LEGACY ITEMS
	INSERT INTO #fqhc_temp( [CLAIM!400!PID], SuperbillProcedureUid, RevenueCode, RevenueCodeOrder, Charge)
		SELECT #XMLClaims_temp.[CLAIM!400!PID] AS [CLAIM!400!PID],
			   sbp.SuperbillProcedureUid AS SuperbillProcedureUid,
			   #XMLClaims_temp.[PROC!450!revenueCode] AS RevenueCode,
			   ROW_NUMBER() OVER( PARTITION BY #xmlClaims_temp.[CLAIM!400!PID], #XMLClaims_temp.[PROC!450!revenueCode] ORDER BY sbp.DisplayOrder asc) AS RevenueCodeOrder,
			   CASE WHEN (ISNUMERIC(#XMLClaims_temp.[PROC!450!Charge]) = 1 ) THEN CONVERT( MONEY, #XMLClaims_temp.[PROC!450!Charge]) ELSE 0 END AS Charge
		FROM #rhc_temp  -- Only grabs those with legacy items
				INNER JOIN #XMLClaims_temp ON #rhc_temp.[CLAIM!400!PID] = #XMLClaims_temp.[CLAIM!400!PID]
				INNER JOIN SuperbillProcedure sbp ON sbp.SuperbillProcedureUid = #XMLClaims_temp.[PROC!450!ID!hide]
		WHERE #rhc_temp.ServiceDateStart < @rhcLegacyDate
			    AND #XMLClaims_temp.tag = 450 -- PROC,  ( only ones remaining have revenue codes )
				AND (IsNull([PROC!450!revenueCode],'0') != '0') -- anything WITH a revenue code
		ORDER BY sbp.DisplayOrder

	-- NOTE: #fqhc_temp contains only those procedures with a "legacy" rhc date
	-- test select * from #fqhc_temp

	-- Part F: Remove those without revenue codes (rhc/fqhc)
	DELETE #XMLClaims_temp
	FROM #rhc_temp
			INNER JOIN #XMLClaims_temp ON  #rhc_temp.[CLAIM!400!PID] = #XMLClaims_temp.[CLAIM!400!PID]
											AND #rhc_temp.ServiceDateStart < @rhcLegacyDate
	WHERE	(#XMLClaims_temp.tag = '450') AND 
			(IsNull(#XMLClaims_temp.[PROC!450!revenueCode],'0') = '0')

	-- 	-- Now create a common table expression summing up like revenue codes based on 
	--  superbill and revenueCode
	-- Then
	--  Update the working table with the total for each revenue code
	--   NOTE:  only change the first revenue code entry since others are duplicates and will be thrown out later
	;with myCTE AS
	(
		select #fqhc_temp.[CLAIM!400!PID], #fqhc_temp.RevenueCode, Sum( #fqhc_temp.Charge) as TotalRevCodeCharge
		from #fqhc_temp
		group by #fqhc_temp.[CLAIM!400!PID], #fqhc_temp.RevenueCode
	)
	UPDATE #fqhc_temp
		SET #fqhc_temp.Charge = myCTE.TotalRevCodeCharge
	FROM #fqhc_temp 
				INNER JOIN myCTE ON #fqhc_temp.[CLAIM!400!PID] = myCTE.[CLAIM!400!PID]
									AND #fqhc_temp.RevenueCode = myCTE.RevenueCode
	WHERE #fqhc_temp.RevenueCodeOrder = 1 -- Only change the 1st entry of this revenue code

	-- test select * from #fqhc_temp

	-- Now delete all "duplicate" revenue codes
	-- Those in working table with a revenueCodeOrder > 1
	DELETE #XMLClaims_temp
	FROM #XMLClaims_temp
				INNER JOIN #fqhc_temp ON #XMLClaims_temp.[PROC!450!ID!hide] = #fqhc_temp.SuperbillProcedureUid	
	WHERE #XMLClaims_temp.tag = 450 -- PROC,  ( only ones remaining have revenue codes )
			--AND #XMLClaims_temp.[CLAIM!400!ChcBillingType] = 0 -- FQHC
			AND #fqhc_temp.RevenueCodeOrder > 1		-- Only delete the duplicate revenue codes after the first one

	--Part G:  Now update the "first" revenue code with the new sum of all revenue codes
	Update #XMLClaims_temp
		SET #XMLClaims_temp.[PROC!450!Charge] = CONVERT(VARCHAR(10), #fqhc_temp.Charge)
	FROM #XMLClaims_temp 
			INNER JOIN #fqhc_temp ON #XMLClaims_temp.[CLAIM!400!PID] = #fqhc_temp.[CLAIM!400!PID]
												AND #XMLClaims_temp.[PROC!450!ID!hide] = #fqhc_temp.SuperbillProcedureUid
	WHERE #XMLClaims_temp.tag = 450 -- proc

	-- Part F: Update claim "Total Charge" now that everything is rolled up
	;WITH myCTE AS
	(
		select #XMLClaims_temp.[CLAIM!400!PID], SUM( CONVERT(MONEY,#XMLClaims_temp.[PROC!450!Charge])) AS TotalCharge 
		from #XMLClaims_temp
			INNER JOIN #fqhc_temp ON #XMLClaims_temp.[CLAIM!400!PID] = #fqhc_temp.[CLAIM!400!PID]
												AND #XMLClaims_temp.[PROC!450!ID!hide] = #fqhc_temp.SuperbillProcedureUid
	    WHERE #XMLClaims_temp.tag = 450 -- proc
		GROUP BY #XMLClaims_temp.[CLAIM!400!PID]
	)
	UPDATE #XMLClaims_temp 
		SET [CLAIM!400!totalBill] = CONVERT(VARCHAR(10),  mc.TotalCharge)
	FROM #XMLClaims_temp
			INNER JOIN myCTE mc on #XMLClaims_temp.[CLAIM!400!PID] = mc.[CLAIM!400!PID]
	WHERE #XMLClaims_temp.tag = 400
	
END
DROP TABLE #rhc_temp
DROP TABLE #fqhc_temp

-----------------------------------------------------------------------------------------------------------------------------------
-- PPS solution
CREATE TABLE #pps_temp
(
		[CLAIM!400!PID] UNIQUEIDENTIFIER		
)
-- Insert into working rhc table ( Only thos with billing type of 0 which is rhc )
INSERT INTO #pps_temp( [CLAIM!400!PID] )
	SELECT #XMLClaims_temp.[CLAIM!400!PID] AS [CLAIM!400!PID]
	FROM #XMLClaims_temp
	WHERE #XMLClaims_temp.tag = 400 -- CLAIMS
			AND #XMLClaims_temp.[CLAIM!400!ChcBillingType] = 1 -- PPS

IF ( EXISTS( SELECT * FROM #pps_temp ) )
BEGIN

	-- Working temp table for pps with claim, sbp, and chcRelApprovalSetting
	CREATE TABLE #ppsProc_temp
	(
			[CLAIM!400!PID] UNIQUEIDENTIFIER,
			[PROC!450!ID!hide] UNIQUEIDENTIFIER,
			InsurancePlanUid UNIQUEIDENTIFIER,
			PostingType int,
			Rate MONEY,
			UseFeeSchedule bit,
			UseAllowedAmount bit
	)	
	
	-- Find ALL PPS procedures from #pps_temp claim table
	--  Get PostingType	( 0 == Post to Financials, 1 == Claim Reference Only
	--		Rate			Rate for now is hard-set rate from CHC settings ( may change based on Posting Type, UseFeeSchedule, UseAllowedAmoount)
	--      UseFeeSchedule	Get Rate value from FeeSchedule ( ClaimingProvider or InsurancePlan or InsuranceCarrier)
	--		UseAllowedAmount  Get Rate value from Amount Allowed Schedule ( InsurancePlan or Insurance Carrier )
	--      
	INSERT INTO #ppsProc_temp([CLAIM!400!PID], [PROC!450!ID!hide], InsurancePlanUid, PostingType, Rate, UseFeeSchedule, UseAllowedAmount)
		SELECT #pps_temp.[CLAIM!400!PID], #XMLClaims_temp.[PROC!450!ID!hide], cip.InsurancePlanUid as InsurancePlanUid,
			    coalesce(cras.PostingType,0) as PostingType,
				cras.Rate, COALESCE(cras.UseFeeSchedule,0) AS UseFeeSchedule, COALESCE(cras.UseAllowedAmount,0) AS UseAllowedAmount
		FROM #pps_temp
			INNER JOIN Superbill sb with (nolock) ON #pps_temp.[CLAIM!400!PID] = sb.SuperbillUid
			inner join SuperbillAggregate sba with (nolock) on sb.SuperbillUid = sba.SuperbillUid
			INNER JOIN ChcInsurancePlan cip with (nolock) on sba.CurrentInsurancePlanUid = cip.InsurancePlanUid
			INNER JOIN ChcListApprovalSetting cas with (nolock) on cip.ApprovalSettingUid = cas.ApprovalSettingUid
			INNER JOIN ChcApprovalPeriod cap with (nolock) on cas.ApprovalSettingUid = cap.ApprovalSettingUid
																AND (cap.EffectiveDate IS NULL OR sb.ServiceDateStart >= cap.EffectiveDate )
																AND (cap.ExpirationDate	IS NULL OR sb.ServiceDateStart <= cap.ExpirationDate )
			INNER JOIN ChcRelApprovalSetting cras with (nolock) on cap.ApprovalPeriodUid = cras.ApprovalPeriodUid
																AND sba.ServiceSiteUid = cras.ServiceSiteUid
			INNER JOIN #XMLClaims_temp ON #XMLClaims_temp.tag = 450
											AND #pps_temp.[CLAIM!400!PID] = #XMLClaims_temp.[CLAIM!400!PID] 
			INNER JOIN SuperbillProcedure sbp WITH (NOLOCK) ON #XMLClaims_temp.[PROC!450!ProcID] = sbp.SuperbillProcedureUid
																AND sbp.ProcedureUid = cras.ProcedureUid

	-- Reorder procedure "display Order" moving PPS procedures to "top"
	;WITH myCTE AS
	(
		SELECT #pps_temp.[CLAIM!400!PID],  #XMLClaims_temp.[PROC!450!ProcID] as ProcID, #XMLClaims_temp.[PROC!450!count] as OriginalCount,
				CASE WHEN #ppsProc_temp.[PROC!450!ID!hide] IS NULL THEN 0 ELSE 1 END AS ppsProc,
				ROW_NUMBER() OVER( PARTITION BY #pps_temp.[CLAIM!400!PID] 
									ORDER BY CASE WHEN #ppsProc_temp.[PROC!450!ID!hide] IS NULL THEN 0 ELSE 1 END desc,
											 #XMLClaims_temp.[PROC!450!count] asc) AS procOrder

		FROM #pps_temp
			INNER JOIN #XMLClaims_temp ON #XMLClaims_temp.tag = 450
											AND #pps_temp.[CLAIM!400!PID] = #XMLClaims_temp.[CLAIM!400!PID] 
			LEFT OUTER JOIN #ppsProc_temp ON #XMLClaims_temp.[PROC!450!ProcID] = #ppsProc_temp.[PROC!450!ID!hide]
	)
	UPDATE #XMLClaims_temp
		SET #XMLClaims_temp.[PROC!450!count] = mc.procOrder
		FROM #XMLClaims_temp
				INNER JOIN myCTE mc ON #XMLClaims_temp.[PROC!450!ProcID] = mc.ProcID
										AND #XMLClaims_temp.tag = 450

	-- Set rate for any procedure that has posting type of "Claim Reference Only" ( PostingType == 1 )
	-- DEBUGHelp  select * from #ppsProc_temp where #ppsProc_temp.PostingType = 1 -- Claim Reference Only

	-- Posting Type == Claim Reference Only, UseAllowedAmount =1
	UPDATE #ppsProc_temp
		SET #ppsProc_temp.Rate = CASE WHEN ( COALESCE(ip.UseCarrierAmountAllowedFeeSchedule,0) = 0 )
												 THEN COALESCE(fsf.Fee, #ppsProc_temp.Rate, 0)				-- Insurance Amount Allowed or rate or 0
													 ELSE COALESCE(fsfip.Fee, fsf.Fee, #ppsProc_temp.Rate, 0) END	-- Plan Amount Allowed or Insurance Amount allowed or rate or 0
		FROM #ppsProc_temp 
				-- Superbill Procedures
				INNER JOIN SuperbillProcedure sbp WITH (NOLOCK) ON #ppsProc_temp.[PROC!450!ID!hide] = sbp.SuperbillProcedureUid
				-- Insurance tables
				INNER JOIN InsurancePlan ip WITH (NOLOCK) ON #ppsProc_temp.InsurancePlanUid = ip.InsurancePlanUid
				INNER JOIN InsuranceCarrier ic WITH (NOLOCK) ON ip.InsuranceCarrierUid = ic.CorporationUid
				-- Amount Allowed - Insurance Carrier Fee
				left outer join FeeSchedule fsAA with (nolock) on ic.AmountAllowedFeeScheduleUid = fsAA.FeeScheduleUid
				left outer join FeeSchedulePeriod fsp with (nolock) on fsAA.FeeScheduleUid = fsp.FeeScheduleUid
															and (fsp.EffectiveDate IS NULL OR sbp.ProcedureServiceDateStart >= fsp.EffectiveDate) 
															and (fsp.ExpirationDate IS NULL OR sbp.ProcedureServiceDateStart <= fsp.ExpirationDate)
				left outer join FeeScheduleFee fsf with (nolock) on fsp.FeeSchedulePeriodUid = fsf.FeeSchedulePeriodUid
															and sbp.ProcedureUid = fsf.ProcedureUid
				-- Amount Allowed - Insurance Plan Fee
				left outer join FeeSchedule fsAAip with (nolock) on ip.AmountAllowedFeeScheduleUid = fsAAip.FeeScheduleUid
				left outer join FeeSchedulePeriod fspip with (nolock) on fsAAip.FeeScheduleUid = fspip.FeeScheduleUid
															and (fspip.EffectiveDate IS NULL OR sbp.ProcedureServiceDateStart >= fspip.EffectiveDate) 
															and (fspip.ExpirationDate IS NULL OR sbp.ProcedureServiceDateStart <= fspip.ExpirationDate)
				left outer join FeeScheduleFee fsfip with (nolock) on fspip.FeeSchedulePeriodUid = fsfip.FeeSchedulePeriodUid
															and sbp.ProcedureUid = fsfip.ProcedureUid
		WHERE #ppsProc_temp.PostingType = 1				-- Claim Reference Only
				AND #ppsProc_temp.UseAllowedAmount = 1  -- Allowed Amount

	-- Posting Type == Claim Reference Only, UseFeeSchedule =1
	UPDATE #ppsProc_temp
		SET #ppsProc_temp.Rate = CASE   WHEN (COALESCE(ip.UseProviderFeeSchedule,0) = 1) 							-- Use Provider Fee Schedule
										THEN COALESCE(fsfPR.Fee, #ppsProc_temp.Rate, 0) 							-- Provider Fee or Rate or 0
										WHEN (COALESCE(ip.UseCarrierFeeSchedule,0) = 0)  
										THEN COALESCE(fsfic.Fee, #ppsProc_temp.Rate, 0)				-- Insurance Carrier Fee  or rate or 0
										ELSE COALESCE(fsfip.Fee, fsfic.Fee, #ppsProc_temp.Rate, 0) END	-- Insurance Plan Fee or Insurance Carrier Fee or rate or 0
		FROM #ppsProc_temp 
				-- Superbill Procedures
				INNER JOIN SuperbillProcedure sbp WITH (NOLOCK) ON #ppsProc_temp.[PROC!450!ID!hide] = sbp.SuperbillProcedureUid
				-- Superbill Aggregate
				INNER JOIN SuperbillAggregate sba WITH (NOLOCK) ON #ppsProc_temp.[CLAIM!400!PID] = sba.SuperbillUid
				-- Insurance tables
				INNER JOIN InsurancePlan ip WITH (NOLOCK) ON #ppsProc_temp.InsurancePlanUid = ip.InsurancePlanUid
				INNER JOIN InsuranceCarrier ic WITH (NOLOCK) ON ip.InsuranceCarrierUid = ic.CorporationUid
				INNER JOIN Provider cPR WITH (NOLOCK) ON sba.ClaimingProviderUid = cPR.PersonUid
				-- Fee Schedule - Insurance Carrier fee
				left outer join FeeSchedule fsic with (nolock) on ic.FeeScheduleUid = fsic.FeeScheduleUid
				left outer join FeeSchedulePeriod fspic with (nolock) on fsic.FeeScheduleUid = fspic.FeeScheduleUid
															and (sbp.ProcedureServiceDateStart >= fspic.EffectiveDate or fspic.EffectiveDate is null) 
															and (sbp.ProcedureServiceDateStart <= fspic.ExpirationDate or fspic.ExpirationDate is null)
				left outer join FeeScheduleFee fsfic with (nolock) on fspic.FeeSchedulePeriodUid = fsfic.FeeSchedulePeriodUid
															and sbp.ProcedureUid = fsfic.ProcedureUid
				-- Fee Schedule - Insurance Plan fee
				left outer join FeeSchedule fsip with (nolock) on ip.FeeScheduleUid = fsip.FeeScheduleUid
				left outer join FeeSchedulePeriod fspip with (nolock) on fsip.FeeScheduleUid = fspip.FeeScheduleUid
															and (sbp.ProcedureServiceDateStart >= fspip.EffectiveDate or fspip.EffectiveDate is null) 
															and (sbp.ProcedureServiceDateStart <= fspip.ExpirationDate or fspip.ExpirationDate is null)
				left outer join FeeScheduleFee fsfip with (nolock) on fspip.FeeSchedulePeriodUid = fsfip.FeeSchedulePeriodUid
															and sbp.ProcedureUid = fsfip.ProcedureUid
				-- Fee Schedule - Provider
				left outer join FeeSchedule fsPR with (nolock) on cPR.FeeScheduleUid = fsPR.FeeScheduleUid
				left outer join FeeSchedulePeriod fspPR with (nolock) on fsPR.FeeScheduleUid = fspPR.FeeScheduleUid
															and (sbp.ProcedureServiceDateStart >= fspPR.EffectiveDate or fspPR.EffectiveDate is null) 
															and (sbp.ProcedureServiceDateStart <= fspPR.ExpirationDate or fspPR.ExpirationDate is null)
				left outer join FeeScheduleFee fsfPR with (nolock) on fspPR.FeeSchedulePeriodUid = fsfPR.FeeSchedulePeriodUid
															and sbp.ProcedureUid = fsfPR.ProcedureUid
		WHERE #ppsProc_temp.PostingType = 1				-- Claim Reference Only
				AND #ppsProc_temp.UseFeeSchedule = 1	-- FeeSchedule

	-- DEBUGHelp  select * from #ppsProc_temp where #ppsProc_temp.PostingType = 1 -- Claim Reference Only

	-- Posting Type == Claim Reference Only, Rate specified  in either CHC settings, FeeSchedule or AmountAllowed
	UPDATE #XMLClaims_temp
		SET #XMLClaims_temp.[PROC!450!charge] = #ppsProc_temp.Rate
		FROM #XMLClaims_temp
				INNER JOIN #ppsProc_temp on #XMLClaims_temp.[PROC!450!ProcID] = #ppsProc_temp.[PROC!450!ID!hide]
												AND #ppsProc_temp.PostingType = 1 -- Claim Reference
		WHERE #XMLClaims_temp.tag = 450

	-- Now that the first procedure has changed, change the total billed amount on the claim
	;with myCTE as
	(
		select DISTINCT [CLAIM!400!PID] FROM #ppsProc_temp WHERE PostingType = 1 -- Claim Reference Only
	)
	,myCTE2 as
	(
		select #XMLClaims_temp.[CLAIM!400!PID] as uid,
				sum(cast(coalesce(#XMLClaims_temp.[PROC!450!charge], '0') as decimal(10,2))) as total
		from #XMLClaims_temp
				INNER JOIN myCTE ON #XMLClaims_temp.[CLAIM!400!PID] = myCTE.[CLAIM!400!PID]
		WHERE #XMLClaims_temp.tag = 450
		group by #XMLClaims_temp.[CLAIM!400!PID]
	)
	UPDATE #XMLClaims_temp
	SET #XMLClaims_temp.[Claim!400!totalBill] = 
			CASE WHEN mc.total = 0 THEN '0' ELSE CONVERT(varchar(12), mc.total, 128) END  -- new
	From #XMLClaims_temp		
			INNER JOIN myCTE2 mc ON #XMLClaims_temp.[CLAIM!400!PID] = mc.uid
	WHERE #XMLClaims_temp.tag = 400
	
	-- DEBUG  select * from #XMLClaims_temp

	DROP TABLE #ppsProc_temp
END
DROP TABLE #pps_temp
--- CHC Changes end


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims] AS' 
END
GO
-- 2014-05-29 Bug 29864
-- 2015-02-27 bUG 35706
-- 2015-03-06 Bug 34673
-- 2016-03-09 Task 47436 RHC Detail, dsw, Add CHCBillingtype
-- 2017-04-13 Bug 56452:Patient Name versus Insurance Subscriber Name when Relationship is Self
-- 2016-07-11 Bug 36412 - Country Code
-- 2024/03/22 bug 159066 - extend email1 from 50 to 100 char limit
-- 2024/04/10 bug 151879 - extend subsriber phones from 20 to 30 character limit

ALTER PROC [dbo].[AR_genXMLClaims]
	@ClaimBatchuid uniqueidentifier,
	@InstanceID uniqueidentifier = null output
AS
/*  
********************************************************************
CYS SC 07/23/09 - Added for Service Site bug (CYS Case #22420):
	[CLAIM!400!BillingProvider_IDType] VARCHAR(50)
	[CLAIM!400!BillingProvider_ID] VARCHAR(50)
********************************************************************
Modified On: 20051011
Modifications Made:	2. For Accident date
			1. For handling WCC Case... added isWCC column to temp table: 20050823

Modifications : Regarding DEFECT #9657	: 26 Feb 2007	: FIG
				33768 - Allow ICD10 codes in 4010 837 xml
*/
-- 

/*
General Structure of the return document:
	<PROVIDER>
		<BILLINGPROVIDER/>
		<PAYTOPROVIDER/>
		<SUBSCRIBER>
			<SUBSCRIBER/>
			<PAYER/>
			<PATIENT>
				<PATIENT/>
				<CLAIMS>
					<CLAIM/>
					<RENDERER/>
					<SITE/>
					<PROC/>
					<PROC/>
				</CLAIMS>
			</PATIENT>
		</SUBSCRIBER>
	</PROVIDER>
*/
SET NOCOUNT ON

DECLARE @claimsFetched INT

DECLARE @eClaimFileUID UNIQUEIDENTIFIER
SET @eClaimFileUID = NEWID()

---------------------------------------------------------------------------------------------------------------
-- ICD10 table for payers wanting ICD10 codes
--CREATE TABLE #icd10Payers ( payerUid UNIQUEIDENTIFIER ) ;
--;with myCTE as
--(
--  SELECT COALESCE(XMLValue, '') as XMLValue
--	from ListProductParameter
--	where ProductParameterUid = '38E0B6D3-7421-4172-B4E6-EC94F167DF64'	-- Temp_ICD10_Implementation
--)
--INSERT INTO #icd10Payers
--	SELECT --c.query('.') AS XMLFragment,
--			c.value('(@guid)','UNIQUEIDENTIFIER') AS payerUid
--	FROM myCTE
--		CROSS APPLY XMLValue.nodes('/ICD10Transition/Payer') as t(c)
----SELECT * FROM #icd10Payers

----------------------------------------------------------------------------------------------------------------
CREATE TABLE #XMLClaims_temp (
	tag INT,
	parent INT,
	[SITE!100!PID] UNIQUEIDENTIFIER,
	[SITE!100!eClaimBatchGUID] UNIQUEIDENTIFIER,
	[SITE!100!claimSubmitterID!hide] UNIQUEIDENTIFIER,
	[SITE!100!payToAddressID!hide] UNIQUEIDENTIFIER,
	[PROVIDER!110!PID] VARCHAR(50),
	[CLAIM!400!PID] UNIQUEIDENTIFIER,
	[CLAIM!400!accountNumber] VARCHAR(50),
	[CLAIM!400!MedicalRecordNumber] VARCHAR(50), -- Added for Ak Medicaid by Qatalys
	[CLAIM!400!totalBill] VARCHAR(12),
	[CLAIM!400!diag1] VARCHAR(50),
	[CLAIM!400!diag2] VARCHAR(50),
	[CLAIM!400!diag3] VARCHAR(50),
	[CLAIM!400!diag4] VARCHAR(50),
	[CLAIM!400!diag5] VARCHAR(50),
	[CLAIM!400!diag6] VARCHAR(50),
	[CLAIM!400!diag7] VARCHAR(50),
	[CLAIM!400!diag8] VARCHAR(50),
	[CLAIM!400!diag9] VARCHAR(50),
	[CLAIM!400!diag10] VARCHAR(50),
	[CLAIM!400!diag11] VARCHAR(50),
	[CLAIM!400!diag12] VARCHAR(50),
	[CLAIM!400!patientMemberID] VARCHAR(110),
	[CLAIM!400!patientgroupID] VARCHAR(50),
	[CLAIM!400!patientgroupName] VARCHAR(110),			-- Added for AK Medicadi by Qatalys
	[CLAIM!400!subscriberMemberID] VARCHAR(50),
	[CLAIM!400!authorizeAssignment] TINYINT,
	[CLAIM!400!providerID] VARCHAR(50),
	[CLAIM!400!providerIDType] VARCHAR(50),
	[CLAIM!400!providerGroupID] VARCHAR(50),
	[CLAIM!400!providerGroupIDType] VARCHAR(50),
    [CLAIM!400!providerGroupID2] VARCHAR(50),
	[CLAIM!400!providerGroupIDType2] VARCHAR(50),
	[CLAIM!400!facilityPrimaryID] VARCHAR(50),
	[CLAIM!400!facilityPrimaryIDType] VARCHAR(50),
	[CLAIM!400!facilityID] VARCHAR(50),
	[CLAIM!400!facilityIDType] VARCHAR(50),
	[CLAIM!400!claimFrequencyCode] INT,
	[CLAIM!400!providerSignatureOnFile] VARCHAR(1),
	[CLAIM!400!providerAcceptAssignment] VARCHAR(1),
	[CLAIM!400!patientAcceptAssignment] VARCHAR(1),
	[CLAIM!400!releaseOfInformation] VARCHAR(1),
	[CLAIM!400!patientSignatureSource] VARCHAR(1),
	[CLAIM!400!patientSignatureDate] VARCHAR(20),
	[CLAIM!400!siteType] VARCHAR(2),
	[CLAIM!400!onsetCurrentDate] DATETIME,
	[CLAIM!400!onsetFirstDate] DATETIME,
	[CLAIM!400!onsetFirstDateQualifier] VARCHAR(3), -- dsw 9/24/2018 11329
	[CLAIM!400!noWorkFromDate] DATETIME,
	[CLAIM!400!noWorkToDate] DATETIME,
	[CLAIM!400!hospitalizationStartDate] DATETIME,
	[CLAIM!400!hospitalizationEndDate] DATETIME,
	[CLAIM!400!InitialTreatmentDate] DATETIME,
	[CLAIM!400!familyPlan] INT,
	[CLAIM!400!ClaimNote] VARCHAR(150),	-- Added for AK Medicaid by Qatalys
	[CLAIM!400!Note] VARCHAR(150),	-- Igor 9/29/09 per 2517 had to add this so that AK Medicaid code will not be broken
    [CLAIM!400!NoteReferenceCode] VARCHAR(4),	-- 2517 added 09/28/2009
	[CLAIM!400!relatedCausesCode] VARCHAR(2),
	[CLAIM!400!accidentState] VARCHAR(2),
	[CLAIM!400!accidentDate] DATETIME,
	[CLAIM!400!priorAuthorizationCode] VARCHAR(50),
	[CLAIM!400!SendNPI] BIT,
	[CLAIM!400!Dmerc] BIT,
	[CLAIM!400!SendPQRIproc] BIT,
	[CLAIM!400!Output2310D] BIT, --bug 1420
	[CLAIM!400!OutputAAE] BIT, --bug 5129
	[CLAIM!400!OutputPR] BIT,--added 5/9/2011
	[CLAIM!400!ICN] VARCHAR(80),	--ADDED ICN NUMBER REPORTDED IN LOOP 2300 6/19/08
	[CLAIM!400!EPSDT] BIT, --added 07/21/09
	[CLAIM!400!EPSDTReferralCondIndicator1] VARCHAR(2),--added 07/21/09
	[CLAIM!400!EPSDTReferralCondIndicator2] VARCHAR(2),--added 07/21/09
	[CLAIM!400!EPSDTReferralCondIndicator3] VARCHAR(2),--added 07/21/09
	[CLAIM!400!EPSDTReferralCondIndicator4] VARCHAR(2),--added 07/21/09
	[CLAIM!400!InsuranceTypeCode]VARCHAR(2),
	[CLAIM!400!AuthReferralIndicator] VARCHAR(2), --bug 2570
	[CLAIM!400!DelayReasonCode] VARCHAR(30), --bug 869
	[CLAIM!400!DateLastSeenBySupervising] DATETIME, --bug 249

	--CYS SC 07/23/09 - Added for Service Site bug (CYS Case #22420)
	[CLAIM!400!BillingProvider_IDType] VARCHAR(50),  
	[CLAIM!400!BillingProvider_ID] VARCHAR(50),	
	[CLAIM!400!LMPDate] DATETIME,	
	[CLAIM!400!UserDefinedXml] VARCHAR(8000),
	[CLAIM!400!ResubmissionCode] VARCHAR(50),	 
    [CLAIM!400!SecPayerID] VARCHAR(50),
	[CLAIM!400!SecPayerCode] VARCHAR(50),
	[CLAIM!400!AssumedDate] DATETIME,
	[CLAIM!400!RelinquishedDate] DATETIME,
	[CLAIM!400!PatientPaidAmount] MONEY,
	[CLAIM!400!AccountID] UNIQUEIDENTIFIER,
	[CLAIM!400!AccountName] VARCHAR(50),
	[CLAIM!400!AccountPeriodID] UNIQUEIDENTIFIER,	
	[CLAIM!400!PaperworkTypeID] VARCHAR(2),
	[CLAIM!400!PaperworkTransmissionCodeID] VARCHAR(2),
	[CLAIM!400!PaperworkControlNum] VARCHAR(50),
	[CLAIM!400!Allow5010Codes] BIT,
	[CLAIM!400!UseICD10] BIT,
	[CLAIM!400!ElectronicClaimFormatUid] UNIQUEIDENTIFIER,
	[CLAIM!400!ChcBillingType] int,								-- DSW, ADDED 3/8/2016
	[CLAIM!400!ReleaseClaimAndIgnoreComplianceErrors] BIT,
        [CLAIM!400!SVCodes] VARCHAR(500),  -- 57927, 57525
	[BILLINGPROVIDER!120!PID] UNIQUEIDENTIFIER,
	[BILLINGPROVIDER!120!LN]	VARCHAR(60),
	[BILLINGPROVIDER!120!FN]	VARCHAR(50),
	[BILLINGPROVIDER!120!MI]	VARCHAR(50),
	[BILLINGPROVIDER!120!address1] VARCHAR(100),
	[BILLINGPROVIDER!120!address2] VARCHAR(100),
	[BILLINGPROVIDER!120!city] VARCHAR(50),
	[BILLINGPROVIDER!120!state] VARCHAR(10),
	[BILLINGPROVIDER!120!zip] VARCHAR(20),
	[BILLINGPROVIDER!120!phone] VARCHAR(30),
	[BILLINGPROVIDER!120!siteType] SMALLINT,
	[BILLINGPROVIDER!120!IDType] VARCHAR(50),
	[BILLINGPROVIDER!120!ID] VARCHAR(50),	
	[BILLINGPROVIDER!120!FCID] UNIQUEIDENTIFIER,
	[BILLINGPROVIDER!120!FileAsGroup] BIT,
	--DEFECT #9657
	[BILLINGPROVIDER!120!NPISecIDType] VARCHAR(50),
	[BILLINGPROVIDER!120!NPISecID] VARCHAR(50),

	[BILLINGPROVIDER!120!LocationNo] VARCHAR(10),

	[PATIENT!300!PEID] UNIQUEIDENTIFIER,
	[PATIENT!300!PEID2!hide] UNIQUEIDENTIFIER, -- added for #46452
	[PATIENT!300!prefix] VARCHAR(10),
	[PATIENT!300!LN] VARCHAR(50),
	[PATIENT!300!FN] VARCHAR(50),
	[PATIENT!300!MI] VARCHAR(50),
	[PATIENT!300!suffix] VARCHAR(20),
	[PATIENT!300!gender] VARCHAR(50),
	[PATIENT!300!birthdate] VARCHAR(12),
	[PATIENT!300!deathdate] VARCHAR(12),	--Added for AK Medicaid
	[PATIENT!300!employer] VARCHAR(100),
	[PATIENT!300!occupation] VARCHAR(50),
	[PATIENT!300!address1] VARCHAR(100),
	[PATIENT!300!address2] VARCHAR(100),
	[PATIENT!300!city] VARCHAR(50),
	[PATIENT!300!state] VARCHAR(10),
	[PATIENT!300!zip] VARCHAR(20),
	[PATIENT!300!phoneNumber] VARCHAR(30),
	[PATIENT!300!rIDType] VARCHAR(50),
	[PATIENT!300!rID] VARCHAR(50),
	[PATIENT!300!IDType] VARCHAR(50),
	[PATIENT!300!ID] VARCHAR(50),
	[PATIENT!300!patientRelationToInsured] VARCHAR(4),

	[PAYER!230!ID!hide] UNIQUEIDENTIFIER,
	[PAYER!230!CarrierID] UNIQUEIDENTIFIER,
	[PAYER!230!planType!hide] UNIQUEIDENTIFIER,
	[PAYER!230!planType] VARCHAR(4),
	[PAYER!230!orgName] VARCHAR(100),
	[PAYER!230!planName] VARCHAR(100),
	[PAYER!230!address1] VARCHAR(100),
	[PAYER!230!address2] VARCHAR(100),
	[PAYER!230!city] VARCHAR(50),	
    [PAYER!230!Inactive] BIT,       --Added for Inactive Payers
	[PAYER!230!codes] VARCHAR(50), --added for loop2310A
	[PAYER!230!Mammcodes] VARCHAR(50),--added per bug 4974
	[PAYER!230!state] VARCHAR(10),
	[PAYER!230!zip] VARCHAR(20),
	[PAYER!230!phone] VARCHAR(30),
	[PAYER!230!capitated] BIT,
	[PAYER!230!acceptAssignment] VARCHAR(1),
	[PAYER!230!IDType] VARCHAR(50),
	[PAYER!230!ID] VARCHAR(50),
	[PAYER!230!elecPayerID] VARCHAR(50),
	[PAYER!230!rIDType] VARCHAR(50),
	[PAYER!230!rID] VARCHAR(50),
	[PAYER!230!EPSDTCodes] VARCHAR(100), --added for 1430 DMERC
	[PAYER!230!PayerOrgID]	VARCHAR(50), --added 2418 9/29/09
	[PAYER!230!ClearingHouseName] VARCHAR(50), --added 2418 9/29/09
	[PAYER!230!SuperiorMedicaid]VARCHAR(1), -- ADDED FOR 2418 AND 2209
	[PAYER!230!TexasMedicaid] VARCHAR(1), -- ADDED FOR 2418 AND 2209
    [PAYER!230!TaxonomyCode] VARCHAR(50), -- Added for 13369, 13953
   
	[PAYTOPROVIDER!130!PID] UNIQUEIDENTIFIER,
	[PAYTOPROVIDER!130!PEID] UNIQUEIDENTIFIER,
	[PAYTOPROVIDER!130!FN] VARCHAR(50),
	[PAYTOPROVIDER!130!LN] VARCHAR(50),
	[PAYTOPROVIDER!130!orgName] VARCHAR(50),
	[PAYTOPROVIDER!130!address1] VARCHAR(100),
	[PAYTOPROVIDER!130!address2] VARCHAR(100),
	[PAYTOPROVIDER!130!city] VARCHAR(50),
	[PAYTOPROVIDER!130!state] VARCHAR(10),
	[PAYTOPROVIDER!130!zip] VARCHAR(20),
	[PAYTOPROVIDER!130!phone] VARCHAR(30),
	[PAYTOPROVIDER!130!siteType] SMALLINT,
	[PAYTOPROVIDER!130!IDType] VARCHAR(50),
	[PAYTOPROVIDER!130!ID] VARCHAR(50),
	--DEFECT #9657
	[PAYTOPROVIDER!130!NPISecIDType] VARCHAR(50),
	[PAYTOPROVIDER!130!NPISecID] VARCHAR(50),
	
	[PROC!450!ID!hide] UNIQUEIDENTIFIER,
	[PROC!450!count] SMALLINT,
	[PROC!450!proc] VARCHAR(48),
	[PROC!450!revenueCode] VARCHAR(10), --60093
	[PROC!450!procM1] VARCHAR(8),
	[PROC!450!procM2] VARCHAR(8),
	[PROC!450!procM3] VARCHAR(8),
	[PROC!450!procM4] VARCHAR(8),
	[PROC!450!diag1] SMALLINT,
	[PROC!450!diag2] SMALLINT,
	[PROC!450!diag3] SMALLINT,
	[PROC!450!diag4] SMALLINT,
	[PROC!450!diag5] SMALLINT,
	[PROC!450!diag6] SMALLINT,
	[PROC!450!diag7] SMALLINT,
	[PROC!450!diag8] SMALLINT,
	[PROC!450!diag9] SMALLINT,
	[PROC!450!diag10] SMALLINT,
	[PROC!450!diag11] SMALLINT,
	[PROC!450!diag12] SMALLINT,
	[PROC!450!unitType] VARCHAR(2), --='UN'
	[PROC!450!units] VARCHAR(10),
	[PROC!450!charge] VARCHAR(13),
	[PROC!450!procedureType] VARCHAR(10),
	[PROC!450!procCodeType] VARCHAR(50),
	[PROC!450!procCodeName]VARCHAR(15),
	[PROC!450!description] VARCHAR(255),
	[PROC!450!serviceDate] VARCHAR(12),
	[PROC!450!serviceDateEnd] VARCHAR(12),
	[PROC!450!emergency] VARCHAR(1),
	[PROC!450!serviceLocation] VARCHAR(10),
	[PROC!450!lineControlNo] VARCHAR(50),
	[PROC!450!TotalTax] MONEY,
	[PROC!450!ProcID] UNIQUEIDENTIFIER,
	
    --Defect #11325
    [PROC!450!NoteReferenceCode] VARCHAR(3),
    [PROC!450!Note] VARCHAR(80),
    [PROC!450!NDC]VARCHAR(48),

	[PROC!450!MedicationMeasurementValue] DECIMAL(5,2),
	[PROC!450!MedicationMeasurementReference] BIT,
	[PROC!450!MedicationMeasurementQualifier] VARCHAR(10),
	  -- 2060
    [PROC!450!COST]MONEY,
	[PROC!450!NDCQuantity]varchar(15),
	[PROC!450!NDCUnitMeasure] varchar(2),
	--CYS SC 10/22/09
    [PROC!450!ContractTypeCodeName] VARCHAR(50),
    [PROC!450!ContractTypeCodeAnsi] VARCHAR(10),
	[PROC!450!PaperworkTypeID] VARCHAR(2),
	[PROC!450!PaperworkTransmissionCodeID] VARCHAR(2),
	[PROC!450!PaperworkControlNum] VARCHAR(50),
    [PROC!450!UserDefinedXml] VARCHAR(8000),
	[PROC!450!FamilyPlanning] BIT,

	[PURCHASEDSERVICE!455!PURCHASEDSERVICEUID] UNIQUEIDENTIFIER,
	[PURCHASEDSERVICE!455!Charge] VARCHAR(13),
	[PURCHASEDSERVICE!455!Name] VARCHAR(100),	
	[PURCHASEDSERVICE!455!NPI] VARCHAR(50),
	[PURCHASEDSERVICE!455!orgName] VARCHAR(50),
	[PURCHASEDSERVICE!455!IDType2] VARCHAR(3),	-- 4010, Loop 2310C, Purchased Service Provider Secondary Identification
	[PURCHASEDSERVICE!455!ID2] VARCHAR(50),		-- 4010, Loop 2310C, Purchased Service Provider Secondary Identification
	----	
	[RENDERER!410!ID!hide] UNIQUEIDENTIFIER,	--(50),
	[RENDERER!410!PEID] UNIQUEIDENTIFIER,
	[RENDERER!410!LN] VARCHAR(50),
	[RENDERER!410!FN] VARCHAR(50),
	[RENDERER!410!MI] VARCHAR(50),
	[RENDERER!410!address1] VARCHAR(100),
	[RENDERER!410!address2] VARCHAR(100),
	[RENDERER!410!city] VARCHAR(50),
	[RENDERER!410!state] VARCHAR(10),
	[RENDERER!410!zip] VARCHAR(20),
	[RENDERER!410!dayPhone] VARCHAR(30),
	[RENDERER!410!providerTaxonomyCode] VARCHAR(15),
	[RENDERER!410!rIDType] VARCHAR(50),
	[RENDERER!410!rID] VARCHAR(50),
	[RENDERER!410!IDType] VARCHAR(50),
	[RENDERER!410!ID] VARCHAR(50),
	[RENDERER!410!CLIA] VARCHAR(50),
--  Added for Defect#12625
    [RENDERER!410!MamographyCertNo] VARCHAR(50),
	[RENDERER!410!SendCLIA] BIT,
	[RENDERER!410!SendMamographyCertNo] BIT,
	
 	[SUPERVISING!415!PID] UNIQUEIDENTIFIER,--
	[SUPERVISING!415!LN] VARCHAR(50),--
	[SUPERVISING!415!FN] VARCHAR(50),--
	[SUPERVISING!415!MI] VARCHAR(50),--
	[SUPERVISING!415!orgName] VARCHAR(50),
	[SUPERVISING!415!dayPhone] VARCHAR(30),--
	[SUPERVISING!415!rIDType] VARCHAR(50),--
	[SUPERVISING!415!rID] VARCHAR(50),--
	[SUPERVISING!415!IDType] VARCHAR(50),--
	[SUPERVISING!415!ID] VARCHAR(50),--

-- Added on 6/3/2009 new Supervising Provider
	[REFERRER!420!PEID] UNIQUEIDENTIFIER,
	[REFERRER!420!PID] UNIQUEIDENTIFIER,
	[REFERRER!420!LN] VARCHAR(50),
	[REFERRER!420!FN] VARCHAR(50),
	[REFERRER!420!MI] VARCHAR(50),
	[REFERRER!420!orgName] VARCHAR(50),
	[REFERRER!420!rIDType] VARCHAR(50),
	[REFERRER!420!rID] VARCHAR(50),
	[REFERRER!420!IDType] VARCHAR(50),
	[REFERRER!420!ID] VARCHAR(50),
	[REFERRER!420!providerTaxonomyCode] VARCHAR(15),

 	[ORDERING!425!PID] UNIQUEIDENTIFIER,--
	[ORDERING!425!LN] VARCHAR(50),--
	[ORDERING!425!FN] VARCHAR(50),--
	[ORDERING!425!MI] VARCHAR(50),--
	[ORDERING!425!orgName] VARCHAR(50),
	[ORDERING!425!dayPhone] VARCHAR(30),--
	[ORDERING!425!rIDType] VARCHAR(50),--
	[ORDERING!425!rID] VARCHAR(50),--
	[ORDERING!425!IDType] VARCHAR(50),--
	[ORDERING!425!ID] VARCHAR(50),--

	[SERVICEFACILITY!430!PID] UNIQUEIDENTIFIER,
	[SERVICEFACILITY!430!type] VARCHAR(50),
	[SERVICEFACILITY!430!orgName] VARCHAR(50),
	[SERVICEFACILITY!430!address1] VARCHAR(100),
	[SERVICEFACILITY!430!address2] VARCHAR(100),
	[SERVICEFACILITY!430!city] VARCHAR(50),
	[SERVICEFACILITY!430!state] VARCHAR(10),
	[SERVICEFACILITY!430!zip] VARCHAR(20),
	[SERVICEFACILITY!430!phone] VARCHAR(30),
	[SERVICEFACILITY!430!siteType] SMALLINT,
	[SERVICEFACILITY!430!PrimaryIDType] VARCHAR(50),
	[SERVICEFACILITY!430!PrimaryID] VARCHAR(50),
	[SERVICEFACILITY!430!IDType] VARCHAR(50),
	[SERVICEFACILITY!430!ID] VARCHAR(50),

	[SUBSCRIBER!200!PEID] UNIQUEIDENTIFIER,
	[SUBSCRIBER!200!SSN] VARCHAR(50),
	[SUBSCRIBER!200!prefix] VARCHAR(10),
	[SUBSCRIBER!200!LN] VARCHAR(50),
	[SUBSCRIBER!200!FN] VARCHAR(50),
	[SUBSCRIBER!200!MI] VARCHAR(50),
	[SUBSCRIBER!200!suffix] VARCHAR(20),
	[SUBSCRIBER!200!gender] VARCHAR(50),
	[SUBSCRIBER!200!birthdate] VARCHAR(12),
	[SUBSCRIBER!200!employer] VARCHAR(100),
	[SUBSCRIBER!200!occupation] VARCHAR(50),
	[SUBSCRIBER!200!address1] VARCHAR(100),
	[SUBSCRIBER!200!address2] VARCHAR(100),
	[SUBSCRIBER!200!city] VARCHAR(50),
	[SUBSCRIBER!200!state] VARCHAR(10),
	[SUBSCRIBER!200!zip] VARCHAR(20),
	[SUBSCRIBER!200!country] VARCHAR(2),
	[SUBSCRIBER!200!phoneNumber] VARCHAR(30),
	[SUBSCRIBER!200!rIDType] VARCHAR(50),
	[SUBSCRIBER!200!rID] VARCHAR(50),
	[SUBSCRIBER!200!IDType] VARCHAR(50),
	[SUBSCRIBER!200!ID] VARCHAR(50),
	[SUBSCRIBER!200!payerResponsibility] VARCHAR(4),
	[SUBSCRIBER!200!DisplayOrder] SMALLINT,
	[SUBSCRIBER!200!groupID] VARCHAR(50),
	[SUBSCRIBER!200!groupName] VARCHAR(100),
	[SUBSCRIBER!200!isWCC] BIT,					-- by SM for WCC handling
	[SUBSCRIBER!200!AccountID] UNIQUEIDENTIFIER,
	[SUBSCRIBER!200!AccountPeriodID] UNIQUEIDENTIFIER,
	[SUBSCRIBER!200!Phone1] varchar(30),
	[SUBSCRIBER!200!Phone1Type] varchar(50),
	[SUBSCRIBER!200!Phone2] varchar(30),
	[SUBSCRIBER!200!Phone2Type] varchar(50),
	[SUBSCRIBER!200!Email1] varchar(100),
	[SUBSCRIBER!200!SpecialCase] varchar(50),

	[RESPONSIBLEPARTY!240!ID!hide] UNIQUEIDENTIFIER,
	[RESPONSIBLEPARTY!240!PEID] UNIQUEIDENTIFIER,			--Added by AW for 2010BC loop  2006 03 15
	[RESPONSIBLEPARTY!240!prefix] VARCHAR(10),
	[RESPONSIBLEPARTY!240!LN] VARCHAR(50),
	[RESPONSIBLEPARTY!240!FN] VARCHAR(50),
	[RESPONSIBLEPARTY!240!MI] VARCHAR(50),
	[RESPONSIBLEPARTY!240!suffix] VARCHAR(20),
	[RESPONSIBLEPARTY!240!address1] VARCHAR(100),
	[RESPONSIBLEPARTY!240!address2] VARCHAR(100),
	[RESPONSIBLEPARTY!240!city] VARCHAR(50),
	[RESPONSIBLEPARTY!240!state] VARCHAR(10),
	[RESPONSIBLEPARTY!240!zip] VARCHAR(50),	
	[RESPONSIBLEPARTY!240!contactName] VARCHAR(100),
	[RESPONSIBLEPARTY!240!contact1String] VARCHAR(22),
	[RESPONSIBLEPARTY!240!isCorporation] BIT,
    [FINANCIALCENTER!105!FCID] UNIQUEIDENTIFIER, 	
	[FINANCIALCENTER!105!SubmitterID] VARCHAR(50),
	[FINANCIALCENTER!105!PayToFinancialCenter] BIT,
	[FINANCIALCENTER!105!PayToAddress1] VARCHAR(100),
	[FINANCIALCENTER!105!PayToAddress2] VARCHAR(100),
	[FINANCIALCENTER!105!PayToCity] VARCHAR(50),
	[FINANCIALCENTER!105!PayToState] VARCHAR(10),
	[FINANCIALCENTER!105!PayToZip] VARCHAR(20)
)

SET @InstanceID = NEWID()

--SELECT CB.ClaimBatchUid, CB.[Status] -- collect up the original to resotre on CATCH if neeed
--	INTO #tempClaimBatchProcessing
--	FROM ClaimBatch CB
--	WHERE ClaimBatchUid = @ClaimBatchuid 
--		AND (CB.[Status] IS NULL OR CB.[Status] = 'Exporting')
	
--BEGIN TRY ------------------------  BEGIN TRY ----------------------------------------

UPDATE ClaimBatch 
	SET Status =  CAST(@InstanceID AS VARCHAR(50)),
		LastModifiedDate = GetUTCDate()
	WHERE ClaimBatchUid = @ClaimBatchuid 
		AND (Status IS NULL OR Status = 'Exporting')

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]
)
SELECT
	100 AS tag,
	NULL AS parent,
	NULL 					AS [SITE!100!PID],
	@ClaimBatchuid				AS [SITE!100!eClaimBatchGUID],
	claimSubmitter.claimSubmitterUid	AS [SITE!100!claimSubmitterID!hide],
	claimSubmitter.PayToServiceSiteUid	AS [SITE!100!payToAddressID!hide]
FROM  claimSubmitter, ClaimBatch
	WHERE ClaimBatch.Status = CAST(@InstanceID AS VARCHAR(50))

EXEC AR_genXMLClaims_CLAIM @ClaimBatchuid, @claimsFetched = @claimsFetched OUTPUT

IF(@claimsFetched > 0)
BEGIN
	EXEC AR_genXMLClaims_FINANCIALCENTER
	EXEC AR_genXMLClaims_PROVIDER
	EXEC AR_genXMLClaims_BILLINGPROVIDER
	EXEC AR_genXMLClaims_PAYTOPROVIDER
	EXEC AR_genXMLClaims_SUBSCRIBER
	EXEC AR_genXMLClaims_PATIENT
	EXEC AR_genXMLClaims_PAYER
	EXEC AR_genXmlClaims_RESPONSIBLEPARTY
	EXEC AR_genXMLClaims_PROC
	EXEC AR_genXMLClaims_PROC_MA -- 60093
	EXEC AR_genXMLClaims_REFERRER
	EXEC AR_genXMLClaims_SUPERVISING
	EXEC AR_genXMLClaims_RENDERER
	EXEC AR_genXMLClaims_SERVICEFACILITY
	SET NOCOUNT OFF

-- Bug 56452:Patient Name versus Insurance Subscriber Name when Relationship is Self
UPDATE #XMLClaims_temp
set [PATIENT!300!PEID2!hide] = [PATIENT!300!PEID]

declare @scrubsubscriber int
set @scrubsubscriber = 0
select @scrubsubscriber = coalesce(lpp.IntegerValue,0) from ListProductParameter lpp
							where ParameterName = 'Scrub.Subscriber' 
if @scrubsubscriber > 0
	UPDATE #XMLClaims_temp
	set  [PATIENT!300!PEID]= [SUBSCRIBER!200!PEID]
	WHERE [PATIENT!300!patientRelationToInsured] = 18
	AND TAG = 300
-- Bug 56452:end changes


	SELECT
	*
	FROM #XMLClaims_temp
	ORDER BY
    [SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
    [FINANCIALCENTER!105!FCID],
	[RENDERER!410!ID!hide],
	[SUBSCRIBER!200!PEID],
	[CLAIM!400!AccountID],
	[CLAIM!400!AccountPeriodID],
	[PATIENT!300!PEID2!hide],
	[CLAIM!400!PID],
	[PROC!450!count],
	parent,
	tag
	FOR XML EXPLICIT
END
ELSE
BEGIN
	SELECT
	*
	FROM #XMLClaims_temp
	ORDER BY
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
    [FINANCIALCENTER!105!FCID],
	[RENDERER!410!ID!hide],
	[SUBSCRIBER!200!PEID],
	[PATIENT!300!PEID2!hide],
	[CLAIM!400!PID],
	[PROC!450!count],
	parent,
	tag
	FOR XML EXPLICIT
END

--END TRY ------------------------  END TRY ----------------------------------------

--BEGIN CATCH ------------------------  BEGIN CATCH ----------------------------------------

--UPDATE ClaimBatch -- don't use alias, DBCheck barks on it ... 
--	SET ClaimBatch.[Status] = #tempClaimBatchProcessing.[Status]
--	FROM #tempClaimBatchProcessing
--		INNER JOIN ClaimBatch ON #tempClaimBatchProcessing.ClaimBatchUid = ClaimBatch.ClaimBatchUid

--END CATCH ------------------------  BEGIN CATCH ----------------------------------------


--DROP TABLE #tempClaimBatchProcessing;


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_Inst_SERVICEFACILITY]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_Inst_SERVICEFACILITY] AS' 
END
GO
ALTER PROC [dbo].[AR_genXMLClaims_Inst_SERVICEFACILITY]
AS

--1 SERVICEFACILITY

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],
	[CLAIM!400!PID],
	[PATIENT!300!PEID],
	[SUBSCRIBER!200!PEID],
	[PAYER!230!ID!hide], 	--Added by Shweta

	[PROVIDER!110!PID],			--CYS SC 11/03/08

	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
	[SERVICEFACILITY!430!PID],
	[SERVICEFACILITY!430!type],
	[SERVICEFACILITY!430!orgName],
	[SERVICEFACILITY!430!address1],
	[SERVICEFACILITY!430!address2],
	[SERVICEFACILITY!430!city],
	[SERVICEFACILITY!430!state],
	[SERVICEFACILITY!430!zip],
	[SERVICEFACILITY!430!phone],
	[SERVICEFACILITY!430!siteType],
	[SERVICEFACILITY!430!PrimaryIDType],
	[SERVICEFACILITY!430!PrimaryID],
	[SERVICEFACILITY!430!IDType],
	[SERVICEFACILITY!430!ID],
    [FINANCIALCENTER!105!FCID] 
)
SELECT
	430 					AS Tag,
	400 					AS parent,
	[SITE!100!PID]				AS [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]		AS [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]	AS [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]		AS [SITE!100!payToAddressID!hide],
	[CLAIM!400!PID]			AS [CLAIM!400!PID],
	[PATIENT!300!PEID]			AS [PATIENT!300!PEID],
	[SUBSCRIBER!200!PEID]		AS [SUBSCRIBER!200!PEID],
	#XMLClaims_temp.[PAYER!230!ID!hide]	AS [PAYER!230!ID!hide],			-- added by Shweta

	[PROVIDER!110!PID]		AS [PROVIDER!110!PID],			--CYS SC 11/03/08

	[RENDERER!410!ID!hide]			AS [RENDERER!410!ID!hide],
	[RENDERER!410!PEID]			AS [RENDERER!410!ID!hide],
	[SERVICEFACILITY!430!PID]		AS [SERVICEFACILITY!430!PID],
	--FIX ME: I ASsume that this is the Service Facility -NOT- An Idependent Lab or Testing Lab AS we don't capture that information in the app. (ANSIX12N doc p304)
	'77'					AS [SERVICEFACILITY!430!type],		-- was 'FA' 5010 uses 77
    --Added for Defect #11471
    (CASE WHEN ListServiceSite.FormalName IS NOT NULL THEN ListServiceSite.FormalName
          ELSE ListServiceSite.Name
     END)	AS [SERVICEFACILITY!430!orgName],
     --
	ListServiceSite.[Address].value('(/Address/Address1)[1]', 'VARCHAR(100)') AS [SERVICEFACILITY!430!address1],
	ListServiceSite.[Address].value('(/Address/Address2)[1]', 'VARCHAR(100)')AS [SERVICEFACILITY!430!address2],
	ListServiceSite.[Address].value('(/Address/City)[1]', 'VARCHAR(100)')AS [SERVICEFACILITY!430!city],
	UPPER(ListServiceSite.[Address].value('(/Address/State)[1]', 'VARCHAR(100)')) AS [SERVICEFACILITY!430!state],
	ListServiceSite.[Address].value('(/Address/Zip)[1]', 'VARCHAR(100)') AS [SERVICEFACILITY!430!zip],
	dbo.stripSpecialChars(ListServiceSite.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)')) AS [SERVICEFACILITY!430!phone],			

	ListServiceSiteType.ANSICode		AS [SERVICEFACILITY!430!siteType],
	--FIX ME: I ASsume that the Facility ID is of some special type. We'll probably have to add a setting for this later (see ANSIX12N 837 X098 docs p305)
--	'24'					AS [SERVICEFACILITY!430!IDType],			--XX As it is decided to use ETIN  hence changed to '24'
--	ListServiceSite.FacilityID			AS [SERVICEFACILITY!430!ID]
	[CLAIM!400!facilityPrimaryIDType] 		AS [SERVICEFACILITY!430!PrimaryIDType],
	[CLAIM!400!facilityPrimaryID] 			AS [SERVICEFACILITY!430!PrimaryID],
	[CLAIM!400!facilityIDType] 		AS [SERVICEFACILITY!430!IDType],
	[CLAIM!400!facilityID] 			AS [SERVICEFACILITY!430!ID],
    [FINANCIALCENTER!105!FCID]     AS  [FINANCIALCENTER!105!FCID]
	

/*	  dbo.UDF_getFormatVaribleValue(4,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
      ELSE InsurancePlan.ElectronicClaimFormatUid END,  
      0,provider.PersonUid,NULL,superbill.serviceSiteUID,NULL) AS [CLAIM!400!providerID],  
  dbo.UDF_getFormatVaribleValue(4,CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
      ELSE InsurancePlan.ElectronicClaimFormatUid END  
      ,1,provider.PersonUid,NULL,superbill.serviceSiteUID,NULL) AS [CLAIM!400!providerIDType],  */

FROM #XMLClaims_temp
INNER JOIN ListServiceSite on
	ListServiceSite.ServiceSiteUid = #XMLClaims_temp.[SERVICEFACILITY!430!PID]
LEFT JOIN ListServiceSiteType ON
	ListServiceSiteType.ServiceSiteTypeUid = ListServiceSite.ServiceSiteTypeUid
WHERE
	#XMLClaims_temp.tag = 400


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_Inst_PROVIDER]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_Inst_PROVIDER] AS' 
END
GO
ALTER PROC [dbo].[AR_genXMLClaims_Inst_PROVIDER]
AS
BEGIN
	DECLARE @zeroGuid as UniqueIdentifier
	SET @zeroGuid = '00000000-0000-0000-0000-000000000000'

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],
	--[CLAIM!400!PID],
	[PROVIDER!110!PID],
	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
	
	--CYS SC 10/31/08
--	[ATTENDING!140!PID],
--	[ATTENDING!140!PEID],
--	[ATTENDING!140!FCID],
--	[ATTENDING!140!FileAsGroup],
--	[SUPERVISING!150!PID],
--	[SUPERVISING!150!PEID],
--	[SUPERVISING!150!FCID],
--	[SUPERVISING!150!FileAsGroup],
--	
	[BILLINGPROVIDER!120!FCID],
	[BILLINGPROVIDER!120!FileAsGroup],
	[PAYTOPROVIDER!130!IDType],
	[PAYTOPROVIDER!130!ID],
	
	--DEFECT #9657
	[PAYTOPROVIDER!130!NPISecIDType],
	[PAYTOPROVIDER!130!NPISecID],
	
	[BILLINGPROVIDER!120!IDType],
	[BILLINGPROVIDER!120!ID],

/* CYS SC - Individual Dr ID regardless of filing type */
	[BILLINGPROVIDER!120!IDType_Dr],
	[BILLINGPROVIDER!120!ID_Dr],	
	
	--DEFECT #9657
	[BILLINGPROVIDER!120!NPISecIDType],
	[BILLINGPROVIDER!120!NPISecID],

	/* CYS SC - Individual Dr ID regardless of filing type */
	[BILLINGPROVIDER!120!NPISecIDType_Dr],
	[BILLINGPROVIDER!120!NPISecID_Dr],

    [FINANCIALCENTER!105!FCID]
)
SELECT DISTINCT
	110 								AS	Tag,
	105 								AS	parent,
	[SITE!100!PID]						AS	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID]			AS	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]	AS	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]		AS	[SITE!100!payToAddressID!hide],
	--[CLAIM!400!PID]					AS	[CLAIM!400!PID],
	
-- CYS 10/31/08	
	CASE 
		WHEN ISNULL([SUPERVISING!150!PEID],@zeroGuid) <> @zeroGuid THEN [SUPERVISING!150!PEID]
        WHEN ISNULL([ATTENDING!140!PEID] ,@zeroGuid) <> @zeroGuid THEN [ATTENDING!140!PEID]
        ELSE [RENDERER!410!ID!hide]
	END AS [PROVIDER!110!PID],	

	[RENDERER!410!ID!hide]				AS	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID]					AS	[RENDERER!410!PEID],

	--CYS SC 10/31/08
--	[ATTENDING!140!PID]					AS  [ATTENDING!140!PID],
--	[ATTENDING!140!PEID]				AS  [ATTENDING!140!PEID],
--	[ATTENDING!140!FCID]				AS  [ATTENDING!140!FCID],
--	[ATTENDING!140!FileAsGroup]			AS  [ATTENDING!140!FileAsGroup],
--
--	[SUPERVISING!150!PID]				AS	[SUPERVISING!150!PID],
--	[SUPERVISING!150!PEID]				AS	[SUPERVISING!150!PEID],
--	[SUPERVISING!150!FCID]				AS	[SUPERVISING!150!FCID],
--	[SUPERVISING!150!FileAsGroup]		AS	[SUPERVISING!150!FileAsGroup],
	

	[BILLINGPROVIDER!120!FCID]			AS	[BILLINGPROVIDER!120!FCID],
	[BILLINGPROVIDER!120!FileAsGroup]	AS	[BILLINGPROVIDER!120!FileAsGroup],
	[PAYTOPROVIDER!130!IDType] 			AS	[PAYTOPROVIDER!130!IDType],
	[PAYTOPROVIDER!130!ID] 				AS	[PAYTOPROVIDER!130!ID],
	
	--DEFECT #9657
	[PAYTOPROVIDER!130!NPISecIDType]	AS	[PAYTOPROVIDER!130!NPISecIDType],
	[PAYTOPROVIDER!130!NPISecID]		AS	[PAYTOPROVIDER!130!NPISecID],

	[BILLINGPROVIDER!120!IDType] 		AS	[BILLINGPROVIDER!120!IDType],
	[BILLINGPROVIDER!120!ID] 			AS	[BILLINGPROVIDER!120!ID],

	/* CYS SC - Individual Dr ID regardless of filing type */
	[BILLINGPROVIDER!120!IDType_Dr]		AS [BILLINGPROVIDER!120!IDType_Dr],
	[BILLINGPROVIDER!120!ID_Dr]			AS [BILLINGPROVIDER!120!ID_Dr],	

	--DEFECT #9657
	[BILLINGPROVIDER!120!NPISecIDType]	AS	[BILLINGPROVIDER!120!NPISecIDType],
	[BILLINGPROVIDER!120!NPISecID]		AS	[BILLINGPROVIDER!120!NPISecID],

	/* CYS SC - Individual Dr ID regardless of filing type */
	[BILLINGPROVIDER!120!NPISecIDType_Dr]	AS [BILLINGPROVIDER!120!NPISecIDType_Dr],
	[BILLINGPROVIDER!120!NPISecID_Dr]		AS [BILLINGPROVIDER!120!NPISecID_Dr],

    [FINANCIALCENTER!105!FCID]	        AS  [FINANCIALCENTER!105!FCID]
	
FROM #XMLClaims_temp
WHERE
	#XMLClaims_temp.tag = '400'
END


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_Inst_SUBSCRIBER]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_Inst_SUBSCRIBER] AS' 
END
GO
ALTER PROC [dbo].[AR_genXMLClaims_Inst_SUBSCRIBER]
AS

/*
Modified On: 20050823
Modifications Made:	1. For handling WCC Case... OP values from Person or Corporation table.
			Corporation Name is populated in OrgName element
*/
-- 2016-07-11 Bug 36412 - Country Code

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],

	[PROVIDER!110!PID],			--CYS SC 11/03/08		

	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
	[SUBSCRIBER!200!PEID],
	[PAYER!230!ID!hide],
	[PAYER!230!planType!hide],
--	[PATIENT!300!PEID],			-- if populated, generates one subscriber per patient. DOES NOT group them.
	[SUBSCRIBER!200!prefix],
	[SUBSCRIBER!200!LN],
	[SUBSCRIBER!200!FN],
	[SUBSCRIBER!200!MI],
	[SUBSCRIBER!200!suffix],
	[SUBSCRIBER!200!gender],
	[SUBSCRIBER!200!birthdate],
	[SUBSCRIBER!200!employer],
	[SUBSCRIBER!200!occupation],
	[SUBSCRIBER!200!address1],
	[SUBSCRIBER!200!address2],
	[SUBSCRIBER!200!city],
	[SUBSCRIBER!200!state],
	[SUBSCRIBER!200!zip],
	[SUBSCRIBER!200!country],
	[SUBSCRIBER!200!phoneNumber],
	[SUBSCRIBER!200!rIDType],
	[SUBSCRIBER!200!rID],
	[SUBSCRIBER!200!IDType],
	[SUBSCRIBER!200!ID],
	[SUBSCRIBER!200!payerResponsibility],
	[SUBSCRIBER!200!DISPLAYORDER],
	[SUBSCRIBER!200!groupID],	
	[SUBSCRIBER!200!isWCC],		-- added by SM for WCC handling
    [FINANCIALCENTER!105!FCID]
)	
SELECT DISTINCT
	200 						AS tag,
	110 						AS parent,
	#XMLClaims_temp.[SITE!100!PID]		AS [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]			AS [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]		AS [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]			AS [SITE!100!payToAddressID!hide],

	[PROVIDER!110!PID] AS			[PROVIDER!110!PID],	--CYS SC 11/03/08

	[RENDERER!410!ID!hide]				AS [RENDERER!410!ID!hide],
	[RENDERER!410!PEID]				AS [RENDERER!410!PEID],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN Person.personUId 
		WHEN [SUBSCRIBER!200!isWCC] = 1 THEN inc.CorporationUid END AS [SUBSCRIBER!200!PEID],

	#XMLClaims_temp.[PAYER!230!ID!hide]		AS [PAYER!230!ID!hide],
	#XMLClaims_temp.[PAYER!230!planType!hide]	AS [PAYER!230!planType!hide],
--	#XMLClaims_temp.[PATIENT!300!PEID]		AS [PATIENT!300!PEID],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN CAST( Person.prefix AS varchar(10))
		                                 ELSE NULL END AS [SUBSCRIBER!200!prefix],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN  UPPER(Person.LastName) 
		ELSE NULL END AS [SUBSCRIBER!200!LN],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN  UPPER(Person.FirstName) 
		ELSE NULL END AS [SUBSCRIBER!200!FN],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN UPPER(Person.MiddleName) 
		ELSE NULL END AS [SUBSCRIBER!200!MI],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN Person.suffix
		ELSE NULL END AS [SUBSCRIBER!200!suffix],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN ListGender.ANSICode
		ELSE NULL END AS [SUBSCRIBER!200!gender],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN CONVERT(VARCHAR, Person.birthdate,101)
		ELSE NULL END AS [SUBSCRIBER!200!birthdate],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN Corporation.Name 
		ELSE  inc.Name END AS [SUBSCRIBER!200!employer],

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN ListOccupation.Name
		ELSE NULL END AS [SUBSCRIBER!200!occupation],	

	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		Person.Address1.value('(/Address/Address1)[1]', 'VARCHAR(100)')
	ELSE
		inc.[Address].value('(/Address/Address1)[1]', 'VARCHAR(100)')
	END AS [SUBSCRIBER!200!address1],
	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		Person.Address1.value('(/Address/Address2)[1]', 'VARCHAR(100)')
	ELSE
		inc.[Address].value('(/Address/Address2)[1]', 'VARCHAR(100)')
	END AS [SUBSCRIBER!200!address2],
	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		Person.Address1.value('(/Address/City)[1]', 'VARCHAR(100)')
	ELSE
		inc.[Address].value('(/Address/City)[1]', 'VARCHAR(100)')
	END AS [SUBSCRIBER!200!city],
	UPPER(CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		Person.Address1.value('(/Address/State)[1]', 'VARCHAR(100)')
	ELSE
		inc.[Address].value('(/Address/State)[1]', 'VARCHAR(100)')
	END) AS [SUBSCRIBER!200!state],
	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		Person.Address1.value('(/Address/Zip)[1]', 'VARCHAR(100)')
	ELSE
		inc.[Address].value('(/Address/Zip)[1]', 'VARCHAR(100)')
	END AS [SUBSCRIBER!200!zip],
	CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		UPPER(LEFT(Person.Address1.value('(/Address/Country)[1]', 'VARCHAR(100)'), 2))
	ELSE
		UPPER(LEFT( inc.[Address].value('(/Address/Country)[1]', 'VARCHAR(100)'), 2))
	END AS [SUBSCRIBER!200!country],

	dbo.stripSpecialChars (CASE WHEN [SUBSCRIBER!200!isWCC] = 0 THEN 
		Person.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)')
	ELSE
		inc.Phone1.value('(/Phone/PhoneNumber)[1]', 'VARCHAR(50)')
	END) AS [SUBSCRIBER!200!phoneNumber],

	'SY'						AS [SUBSCRIBER!200!rIDType],
	dbo.stripSpecialChars(Person.SocialSecurityNumber) AS [SUBSCRIBER!200!rID],

	'MI'						AS [SUBSCRIBER!200!IDType],
	[CLAIM!400!subscriberMemberID] AS [SUBSCRIBER!200!ID],

	[SUBSCRIBER!200!payerResponsibility]		AS [SUBSCRIBER!200!payerResponsibility],
	[SUBSCRIBER!200!DISPLAYORDER] as [SUBSCRIBER!200!DISPLAYORDER],
	[CLAIM!400!patientgroupID]			AS [SUBSCRIBER!200!groupID]
--	,[CLAIM!400!PID] 				AS [SUBSCRIBER!200!SBUid!Hide]	-- added by SM for PAYER NODE JOINS
	,[SUBSCRIBER!200!isWCC]			AS [SUBSCRIBER!200!isWCC],
    [FINANCIALCENTER!105!FCID]      AS  [FINANCIALCENTER!105!FCID]   

FROM #XMLClaims_temp 

LEFT JOIN Person ON
	Person.PersonUid = [SUBSCRIBER!200!PEID]
LEFT JOIN ListGender ON
	Person.GenderUid = ListGender.GenderUid

-- in case Insured is an Organization
LEFT JOIN Corporation inc ON 
	inc.CorporationUid = [SUBSCRIBER!200!PEID]

LEFT JOIN PersonEmployer ON
	PersonEmployer.PersonUid = Person.PersonUid
LEFT JOIN Corporation ON
	PersonEmployer.EmployerUid = Corporation.CorporationUid
LEFT JOIN ListOccupation ON
	PersonEmployer.OccupationUid = ListOccupation.OccupationUid

-- get the phone number depending upon person or corporatiob

WHERE
	#XMLClaims_temp.tag = 400 AND
	#XMLClaims_temp.[SUBSCRIBER!200!PEID] IS NOT NULL


GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_genXMLClaims_Inst_SUPERVISING]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AR_genXMLClaims_Inst_SUPERVISING] AS' 
END
GO
ALTER PROC [dbo].[AR_genXMLClaims_Inst_SUPERVISING]
 AS

--CYS SC 12/01/08 - added logic to [SUPERVISING!150!IDType] and [SUPERVISING!150!ID] 
-- for Service Site NPI Overrides.

DECLARE @mainFinancialCenter AS UNIQUEIDENTIFIER
SET @mainFinancialCenter = '14B99C94-EDAC-47BD-97B9-CF421AC16018'

 DECLARE @ProviderNPIUid UNIQUEIDENTIFIER
 SELECT @ProviderNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Provider NPI'  AND ISNULL(cfvt1.Inactive, 0) = 0  

 DECLARE @ServiceSiteNPIUid UNIQUEIDENTIFIER
 SELECT @ServiceSiteNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Service Site NPI'  AND ISNULL(cfvt1.Inactive, 0) = 0  

DECLARE @PayToProviderNPIUid UNIQUEIDENTIFIER
 SELECT @PayToProviderNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Pay To Provider NPI'  AND ISNULL(cfvt1.Inactive, 0) = 0  

 DECLARE @FinancialCenterNPIUid UNIQUEIDENTIFIER
 SELECT @FinancialCenterNPIUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Financial Center NPI'  AND ISNULL(cfvt1.Inactive, 0) = 0  

 DECLARE @SSNUid UNIQUEIDENTIFIER
 SELECT @SSNUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'SSN' AND ISNULL(cfvt1.Inactive, 0) = 0	
 
 DECLARE @EINUid UNIQUEIDENTIFIER  
 SELECT @EINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'ETIN'  AND ISNULL(cfvt1.Inactive, 0) = 0--EmployerGö£+Ñs Identification Number  

 DECLARE @FinancialCenterEINUid UNIQUEIDENTIFIER  
 SELECT @FinancialCenterEINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1   
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid   
		AND lcfvtt.Name = 'Claim Format Value'  
		WHERE cfvt1.Name LIKE 'Financial Center ETIN'  AND ISNULL(cfvt1.Inactive, 0) = 0--EmployerGö£+Ñs Identification Number  

DECLARE @UPINUid UNIQUEIDENTIFIER
SELECT @UPINUid = cfvt1.ClaimFormatValueTypeUid FROM ListClaimFormatValueType cfvt1 
		INNER JOIN ListClaimFormatValueTypeType lcfvtt ON lcfvtt.ClaimFormatValueTypeTypeUid = cfvt1.ClaimFormatValueTypeTypeUid 
		AND lcfvtt.Name = 'Claim Format Value'
		WHERE cfvt1.Name LIKE 'UPIN' AND ISNULL(cfvt1.Inactive, 0) = 0

INSERT INTO #XMLClaims_temp
(
	tag,
	parent,
	[SITE!100!PID],
	[SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide],

	[PROVIDER!110!PID],	--CYS SC 11/03/08

	[RENDERER!410!ID!hide],
	[RENDERER!410!PEID],
	[SUPERVISING!150!PEID],
	[SUPERVISING!150!FCID],
	[SUPERVISING!150!FileAsGroup],
	[SUPERVISING!150!PID],
	--[SUPERVISING!150!orgName],
	[SUPERVISING!150!LN],
	[SUPERVISING!150!FN],
	[SUPERVISING!150!MI],

	[SUPERVISING!150!address1],
	[SUPERVISING!150!address2],
	[SUPERVISING!150!city],
	[SUPERVISING!150!state],
	[SUPERVISING!150!zip],
	[SUPERVISING!150!phone],
	[SUPERVISING!150!siteType],
	[SUPERVISING!150!IDType],
	[SUPERVISING!150!ID],	

	/* CYS SC - Individual Dr ID regardless of filing type */
	[SUPERVISING!150!IDType_Dr],
	[SUPERVISING!150!ID_Dr],	

	--DEFECT #9657
	[SUPERVISING!150!NPISecIDType],
    [SUPERVISING!150!NPISecID],

	/* CYS SC - Individual Dr ID regardless of filing type */
	[SUPERVISING!150!NPISecIDType_Dr],
	[SUPERVISING!150!NPISecID_Dr],

	[SUPERVISING!150!LocationNo],
    [FINANCIALCENTER!105!FCID],
	[SUPERVISING!150!SuperbillUid]		--CYS SC 11/04/08
)
SELECT
	150 					AS Tag,
	110 					AS parent,

	[SITE!100!PID]				AS [SITE!100!PID],
	[SITE!100!eClaimBatchGUID]		AS [SITE!100!eClaimBatchGUID],
	[SITE!100!claimSubmitterID!hide]		AS [SITE!100!claimSubmitterID!hide],
	[SITE!100!payToAddressID!hide]		AS [SITE!100!payToAddressID!hide],

	[PROVIDER!110!PID]				AS [PROVIDER!110!PID],	--CYS SC 11/03/08

	[RENDERER!410!ID!hide]			AS [RENDERER!410!ID!hide],
	[RENDERER!410!PEID]			AS [RENDERER!410!PEID],
	[SUPERVISING!150!PEID] AS [SUPERVISING!150!PEID],
	[SUPERVISING!150!FCID]	AS [SUPERVISING!150!FCID],
	[SUPERVISING!150!FileAsGroup]	AS	[SUPERVISING!150!FileAsGroup],
	[SUPERVISING!150!PID] AS [SUPERVISING!150!PID],
	[SUPERVISING!150!LN] AS [SUPERVISING!150!LN],
	[SUPERVISING!150!FN] AS [SUPERVISING!150!FN],
	[SUPERVISING!150!MI] AS [SUPERVISING!150!MI],
	[SUPERVISING!150!address1] AS [SUPERVISING!150!address1],
	[SUPERVISING!150!address2] AS [SUPERVISING!150!address2],
	[SUPERVISING!150!city] AS [SUPERVISING!150!city],
	[SUPERVISING!150!state] AS [SUPERVISING!150!state],
	[SUPERVISING!150!zip] AS [SUPERVISING!150!zip],	
	[SUPERVISING!150!phone] AS [SUPERVISING!150!phone],
	
	ListServiceSiteType.ANSICode		AS [SUPERVISING!150!siteType],

	[SUPERVISING!150!IDType]		AS [SUPERVISING!150!IDType],
	[SUPERVISING!150!ID]			 AS [SUPERVISING!150!ID],	

	[SUPERVISING!150!IDType_Dr]		AS [SUPERVISING!150!IDType_Dr],
	[SUPERVISING!150!ID_Dr]			AS [SUPERVISING!150!ID_Dr],	

	--DEFECT #9657
	[SUPERVISING!150!NPISecIDType]	AS [SUPERVISING!150!NPISecIDType],
	[SUPERVISING!150!NPISecID]  	AS [SUPERVISING!150!NPISecID],

	[SUPERVISING!150!NPISecIDType_Dr]	AS [SUPERVISING!150!NPISecIDType_Dr],
	[SUPERVISING!150!NPISecID_Dr]		AS [SUPERVISING!150!NPISecID_Dr],

	'0001'					AS [SUPERVISING!150!LocationNo],
    [FINANCIALCENTER!105!FCID] AS [FINANCIALCENTER!105!FCID],
	[CLAIM!400!PID] AS [SUPERVISING!150!SuperbillUid]		--CYS SC 11/04/08

FROM #XMLClaims_temp
INNER JOIN dbo.claimsubmitter ON
	claimSubmitter.ClaimSubmitterUid = #XMLClaims_temp.[SITE!100!claimSubmitterID!hide]

LEFT JOIN ListServiceSite ON
	ListServiceSite.serviceSiteUid = claimSubmitter.ClaimSubmitterServiceSiteUid
LEFT JOIN ListServiceSiteType ON
	ListServiceSite.ServiceSiteTypeUid = ListServiceSiteType.ServiceSiteTypeUid
WHERE
	--#XMLClaims_temp.tag = 110
	#XMLClaims_temp.tag = 400

UPDATE #XMLClaims_temp SET [SUPERVISING!150!FCID] = @mainFinancialCenter
	WHERE tag = '150' AND [SUPERVISING!150!FCID] IS NULL

UPDATE #XMLClaims_temp SET 
	[SUPERVISING!150!FileAsGroup] =
	CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, 
		CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
			ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = 'individual')  OR 
            (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
			ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) ='1'  ))
       THEN 0	   
       ELSE 1	
	END,
	
	[SUPERVISING!150!IDType] =
	CASE WHEN lcf.SendNPI = 1 THEN		
		--CYS SC - Service Site NPI Override
		(CASE WHEN Exists(SELECT * FROM ClaimFormatOption cfo
				INNER JOIN [ListClaimFormatOptionType] ot ON ot.ClaimFormatOptionTypeUid = cfo.ClaimFormatOptionTypeUid 
					WHERE (ClaimFormatUid = 
					CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
						ELSE InsurancePlan.ElectronicClaimFormatUid END) 
					AND (ot.Name = 'NPI Override'))
				AND COALESCE(dbo.UDF_getFormatVaribleValue (0, @ServiceSiteNPIUid,0,NULL,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid), '') <> '' 
			THEN 'XX'
		ELSE 
		--CYS SC - Service Site NPI Override End
		  (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = '1')) THEN @ProviderNPIUid
					ELSE @FinancialCenterNPIUid END,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid), '') <> '' THEN  
					'XX'
				WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = '1')) THEN @EINUid
					ELSE @FinancialCenterEINUid END,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid), '') <> '' THEN  
					'24'  
				WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = '1')) THEN 
					'34'
				ELSE ''
		   END)  
		END)	--ServiceSite NPI not <> ''
	--Not NPI
	ELSE (CASE WHEN COALESCE(dbo.UDF_getFormatVaribleValue (0, CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = '1')) THEN @EINUid
				ELSE @FinancialCenterEINUid END,0,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid), '') <> '' THEN  
				'24'  
			WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
				ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = '1')) THEN 
				'34'
			ELSE ''
	      END)
	END,	   

	[SUPERVISING!150!ID] =
	CASE WHEN lcf.SendNPI = 1 THEN
		--CYS SC - Service Site NPI Override
		(CASE WHEN Exists(SELECT * FROM ClaimFormatOption cfo
				INNER JOIN [ListClaimFormatOptionType] ot ON ot.ClaimFormatOptionTypeUid = cfo.ClaimFormatOptionTypeUid 
					WHERE (ClaimFormatUid = 
					CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
						ELSE InsurancePlan.ElectronicClaimFormatUid END) 
					AND (ot.Name = 'NPI Override'))
				AND COALESCE(dbo.UDF_getFormatVaribleValue (0, @ServiceSiteNPIUid,0,NULL,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid), '') <> '' 
			THEN dbo.UDF_getFormatVaribleValue (0, @ServiceSiteNPIUid,0,NULL,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,ViewSuperbillFinancialDetails.financialCenterUid)
		ELSE 
		--CYS SC - Service Site NPI Override End
		  (CASE	WHEN dbo.UDF_getFormatVaribleValue (0, CASE WHEN ((dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,provider.PersonUid,NULL,ViewSuperbillFinancialDetails.ServiceSiteUid,NULL,provider.FinancialCenterUid) = 'individual') OR (dbo.UDF_getFormatVaribleValue (2, CASE WHEN InsurancePlan.UseCarrierElectronicClaimFormat = 1 THEN InsuranceCarrier.ElectronicClaimFormatUid  
					ELSE InsurancePlan.ElectronicClaimFormatUid END,9,p