
-- #175566 - APCM: New Care Management Option
-- add missing columns
DECLARE @tb varchar(30) = 'PatientCareManagement'
IF COL_LENGTH(@tb, 'ConsentUid') IS NULL
AND COL_LENGTH(@tb, 'QMBUid') IS NULL
AND COL_LENGTH(@tb, 'APCMLevelUid') IS NULL
begin
	ALTER TABLE dbo.PatientCareManagement ADD
		ConsentUid uniqueidentifier NULL,
		QMBUid uniqueidentifier NULL,
		APCMLevelUid uniqueidentifier NULL

	ALTER TABLE dbo.PatientCareManagement ADD CONSTRAINT
		FK_PatientCareManagement_ListMisc1 FOREIGN KEY
		(
		ConsentUid
		) REFERENCES dbo.ListMisc
		(
		MiscUid
		) ON UPDATE  NO ACTION 
		 ON DELETE  NO ACTION 
	
	ALTER TABLE dbo.PatientCareManagement ADD CONSTRAINT
		FK_PatientCareManagement_ListMisc2 FOREIGN KEY
		(
		QMBUid
		) REFERENCES dbo.ListMisc
		(
		MiscUid
		) ON UPDATE  NO ACTION 
		 ON DELETE  NO ACTION 
	
	ALTER TABLE dbo.PatientCareManagement ADD CONSTRAINT
		FK_PatientCareManagement_ListUserDefinedData FOREIGN KEY
		(
		APCMLevelUid
		) REFERENCES dbo.ListUserDefinedData
		(
		UserDefinedDataUid
		) ON UPDATE  NO ACTION 
		 ON DELETE  NO ACTION 
	
	ALTER TABLE dbo.PatientCareManagement SET (LOCK_ESCALATION = TABLE)

end
GO



-- #175568 - *APCM Billing: Care Management Review Filter and Superbill Creation Guidelines 
-- add column IsAPCM
DECLARE @tb varchar(30) = 'PatientCareManagementLog'
IF COL_LENGTH(@tb, 'IsAPCM') IS NULL
begin
	ALTER TABLE dbo.PatientCareManagementLog ADD
		IsAPCM bit NULL
end
go

if exists (select * from dbo.sysobjects where id = object_id(N'[dbo].[SetLogDateForAPCM]') and OBJECTPROPERTY(id, N'IsProcedure') = 1)
drop procedure [dbo].[SetLogDateForAPCM]
GO

SET QUOTED_IDENTIFIER ON 
GO
SET ANSI_NULLS ON 
GO

CREATE PROCEDURE [dbo].[SetLogDateForAPCM]
	@LogDate [DateTime]
AS
begin
	-- delete all log entries for APCM
	delete PatientCareManagementLog where PatientCareManagementLogUid in (select PatientCareManagementLogUid from PatientCareManagementLog where IsAPCM = 1)

	INSERT INTO PatientCareManagementLog (PatientCareManagementLogUid, LogDate, PatientUid, ProviderUid, IsAPCM)
		SELECT newid(), @LogDate, PatientUid, ProviderUid, 1 as [IsAPCM]
			FROM PatientCareManagement t1 where t1.CareTypeUid = '37B2B82F-B851-4B9D-9D35-A3B07C6045AB'
end
go

-- update ListUserDefinedData rows
update ListUserDefinedData set ExternalID = 'GPCM1' where UserDefinedDataUid = '5D1DB607-E779-44B0-96DB-53F1D17E0636'
update ListUserDefinedData set ExternalID = 'GPCM2' where UserDefinedDataUid = 'E74AA34F-5616-4414-97B0-C10E764CDCBA'
update ListUserDefinedData set ExternalID = 'GPCM3' where UserDefinedDataUid = '5CD8AB45-23AB-4E53-8F06-56C7E58CD78C'
go

-- add test data
if (not exists(select * from ListProcedure where Code = 'GPCM1'))
begin
	INSERT INTO ListProcedure (ExternalID, Code, MasterProcedureUid, ProcedureCodeTypeUid, ShortDescription, LongDescription, IsEM, EffectiveDate, ExpirationDate, GenerateObservationOrder, UserDefined)
	SELECT 
		'GPCM1' as ExternalID, 
		'GPCM1' as Code, 
		'00000000-0000-0000-0000-000000000000' as MasterProcedureUid, 
		'00000000-0000-0000-0000-000000000002' as ProcedureCodeTypeUid, 
		'one chronic condition' as ShortDescription,
		'one chronic condition' as LongDescription, 
		0 as IsEM, 
		'2025-01-01' as EffectiveDate, 
		null as ExpirationDate, 
		0 as GenerateObservationOrder,
		1 as UserDefined
end
go

if (not exists(select * from ListProcedure where Code = 'GPCM2'))
begin
	INSERT INTO ListProcedure (ExternalID, Code, MasterProcedureUid, ProcedureCodeTypeUid, ShortDescription, LongDescription, IsEM, EffectiveDate, ExpirationDate, GenerateObservationOrder, UserDefined)
	SELECT 
		'GPCM2' as ExternalID, 
		'GPCM2' as Code, 
		'00000000-0000-0000-0000-000000000000' as MasterProcedureUid, 
		'00000000-0000-0000-0000-000000000002' as ProcedureCodeTypeUid, 
		'two or more chronic conditions' as ShortDescription,
		'two or more chronic conditions' as LongDescription, 
		0 as IsEM, 
		'2025-01-01' as EffectiveDate, 
		null as ExpirationDate, 
		0 as GenerateObservationOrder,
		1 as UserDefined
end
go

if (not exists(select * from ListProcedure where Code = 'GPCM3'))
begin
	INSERT INTO ListProcedure (ExternalID, Code, MasterProcedureUid, ProcedureCodeTypeUid, ShortDescription, LongDescription, IsEM, EffectiveDate, ExpirationDate, GenerateObservationOrder, UserDefined)
	SELECT 
		'GPCM3' as ExternalID, 
		'GPCM3' as Code, 
		'00000000-0000-0000-0000-000000000000' as MasterProcedureUid, 
		'00000000-0000-0000-0000-000000000002' as ProcedureCodeTypeUid, 
		'two or more chronic conditions and QMB' as ShortDescription,
		'two or more chronic conditions and QMB' as LongDescription, 
		0 as IsEM, 
		'2025-01-01' as EffectiveDate, 
		null as ExpirationDate, 
		0 as GenerateObservationOrder,
		1 as UserDefined
end
go
