BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ChargeCapture]') AND name = 'HospitalizationStartDate')
    ALTER TABLE [ChargeCapture] ADD [HospitalizationStartDate] datetime NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ChargeCapture]') AND name = 'HospitalizationEndDate')
    ALTER TABLE [ChargeCapture] ADD [HospitalizationEndDate] datetime NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ChargeCapture]') AND name = 'AppointmentUid')
    ALTER TABLE [ChargeCapture] ADD [AppointmentUid] uniqueidentifier NULL 
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'DunningMsgs' AND COLUMN_NAME = 'DunningMsg1')
ALTER TABLE [DunningMsgs]  ALTER COLUMN [DunningMsg1] nvarchar(max) NULL 
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'DunningMsgs' AND COLUMN_NAME = 'DunningMsg2')
ALTER TABLE [DunningMsgs]  ALTER COLUMN [DunningMsg2] nvarchar(max) NULL 
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'DunningMsgs' AND COLUMN_NAME = 'DunningMsg3')
ALTER TABLE [DunningMsgs]  ALTER COLUMN [DunningMsg3] nvarchar(max) NULL 
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'DunningMsgs' AND COLUMN_NAME = 'DunningMsg4')
ALTER TABLE [DunningMsgs]  ALTER COLUMN [DunningMsg4] nvarchar(max) NULL 
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'DunningMsgs' AND COLUMN_NAME = 'DunningMsg5')
ALTER TABLE [DunningMsgs]  ALTER COLUMN [DunningMsg5] nvarchar(max) NULL 
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'DunningMsgs' AND COLUMN_NAME = 'DunningMsg6')
ALTER TABLE [DunningMsgs]  ALTER COLUMN [DunningMsg6] nvarchar(max) NULL 
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Origin' , N'SCHEMA',N'dbo', N'TABLE',N'ErrorReport', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Origin' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ErrorReport'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ToAvoid' , N'SCHEMA',N'dbo', N'TABLE',N'ErrorReport', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.ToAvoid' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ErrorReport'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'ErrorReport', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.XferDirection' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ErrorReport'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Origin' , N'SCHEMA',N'dbo', N'TABLE',N'ErrorReport', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Origin', @value=N'<Unknown value="0" /><ClientUI value="1" /><ClientNoUI value="2" /><Appserver value="3" /><WebClientUI value="4" /><WebClientNoUI value="5" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ErrorReport'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ToAvoid' , N'SCHEMA',N'dbo', N'TABLE',N'ErrorReport', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.ToAvoid', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ErrorReport'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'ErrorReport', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Upload' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ErrorReport'
GO
BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'FinancialCenter' AND COLUMN_NAME = 'StatementFooter')
ALTER TABLE [FinancialCenter]  ALTER COLUMN [StatementFooter] nvarchar(max) NULL 
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IcBackgroundTaskQueue]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[IcBackgroundTaskQueue](
	[IcBackgroundTaskQueueUid] [uniqueidentifier] NOT NULL,
	[ProcessorName] [varchar](100) NOT NULL,
	[ProcessorParameters] [varchar](max) NULL,
	[IsSent] [bit] NOT NULL,
	[IsSuccessful] [bit] NOT NULL,
	[IsPriority] [bit] NOT NULL,
	[SentDate] [datetime] NULL,
	[RetryAttempts] [tinyint] NOT NULL,
	[MaxRetryAttempts] [tinyint] NOT NULL,
	[Error] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModififedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'None' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'IcBackgroundTaskQueue'

ALTER TABLE [IcBackgroundTaskQueue] ADD  CONSTRAINT [DF_IcBackgroundTaskQueue_IsSent]  DEFAULT ((0)) FOR [IsSent]
ALTER TABLE [IcBackgroundTaskQueue] ADD  CONSTRAINT [DF_IcBackgroundTaskQueue_IsSuccessful]  DEFAULT ((0)) FOR [IsSuccessful]
ALTER TABLE [IcBackgroundTaskQueue] ADD  CONSTRAINT [DF_IcBackgroundTaskQueue_IsPriority]  DEFAULT ((0)) FOR [IsPriority]
ALTER TABLE [IcBackgroundTaskQueue] ADD  CONSTRAINT [DF_IcBackgroundTaskQueue_RetryAttempts]  DEFAULT ((0)) FOR [RetryAttempts]
ALTER TABLE [IcBackgroundTaskQueue] ADD  CONSTRAINT [DF_IcBackgroundTaskQueue_MaxRetryAttempts]  DEFAULT ((0)) FOR [MaxRetryAttempts]
ALTER TABLE [IcBackgroundTaskQueue] ADD  CONSTRAINT [DF_IcBackgroundTaskQueue_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_IcMessageLog]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_IcMessageLog](
	[IcMessageLogUid] [uniqueidentifier] NOT NULL,
	[MessageObjectId] [uniqueidentifier] NULL,
	[SentDateTime] [datetime] NOT NULL,
	[RawSend] [varchar](max) NOT NULL,
	[RepliedDateTime] [datetime] NULL,
	[HttpStatusCode] [int] NULL,
	[RawReturn] [varchar](max) NULL,
	[WebApiDirectory] [varchar](100) NULL,
	[MessageCategory] [varchar](100) NULL,
	[MessageName] [varchar](100) NULL,
	[CallsLeftPerMinute] [int] NULL,
	[DiagnosticMessage] [varchar](max) NULL,
	[SuccessfullyTransmitted] [bit] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'InteliChart', @value=N'TransmittedLoggingTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_IcMessageLog'

ALTER TABLE [migtemp_IcMessageLog] ADD  CONSTRAINT [DF_IcMessageLog_IcMessageLogUid]  DEFAULT (newid()) FOR [IcMessageLogUid]

END
Truncate Table migtemp_IcMessageLog
INSERT [migtemp_IcMessageLog]([IcMessageLogUid],[MessageObjectId],[SentDateTime],[RawSend],[RepliedDateTime],[HttpStatusCode],[RawReturn],[WebApiDirectory],[MessageCategory],[MessageName],[CallsLeftPerMinute],[DiagnosticMessage])
SELECT [IcMessageLogUid],[MessageObjectId],[SentDateTime],[RawSend],[RepliedDateTime],[HttpStatusCode],[RawReturn],[WebApiDirectory],[MessageCategory],[MessageName],[CallsLeftPerMinute],[DiagnosticMessage]
FROM [IcMessageLog]

DROP TABLE [IcMessageLog]

exec  sp_rename 'migtemp_IcMessageLog', 'IcMessageLog'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IcMessageQueue]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[IcMessageQueue](
	[IcMessageQueueUid] [uniqueidentifier] NOT NULL,
	[DiagnosticDetails] [varchar](max) NULL,
	[EntityId] [varchar](100) NOT NULL,
	[EntityType] [tinyint] NOT NULL,
	[IsAccepted] [bit] NOT NULL,
	[IsSent] [bit] NOT NULL,
	[SentDate] [datetime] NULL,
	[UpdateContent] [varchar](max) NULL,
	[SentCount] [tinyint] NOT NULL,
	[HttpStatusCode] [varchar](100) NULL,
	[SendResponseResultType] [varchar](100) NULL,
	[Error] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'None' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'IcMessageQueue'

ALTER TABLE [IcMessageQueue] ADD  CONSTRAINT [DF_IcMessageQueue_EntityType]  DEFAULT ((0)) FOR [EntityType]
ALTER TABLE [IcMessageQueue] ADD  CONSTRAINT [DF_IcMessageQueue_IsAccepted]  DEFAULT ((0)) FOR [IsAccepted]
ALTER TABLE [IcMessageQueue] ADD  CONSTRAINT [DF_IcMessageQueue_IsSent]  DEFAULT ((0)) FOR [IsSent]
ALTER TABLE [IcMessageQueue] ADD  CONSTRAINT [DF_IcMessageQueue_SentCount]  DEFAULT ((0)) FOR [SentCount]
ALTER TABLE [IcMessageQueue] ADD  CONSTRAINT [DF_IcMessageQueue_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_IcTransacted]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_IcTransacted](
	[IcTransactedUid] [uniqueidentifier] NOT NULL,
	[InteliChartApiName] [varchar](128) NOT NULL,
	[Reviewed] [datetime] NULL,
	[Transmitted] [bit] NULL,
	[FilterReason] [varchar](2048) NULL,
	[DeleteSent] [bit] NOT NULL
) ON [PRIMARY]


ALTER TABLE [migtemp_IcTransacted] ADD  CONSTRAINT [DF_IcTransacted_IcTransactedUid]  DEFAULT (newid()) FOR [IcTransactedUid]
ALTER TABLE [migtemp_IcTransacted] ADD  CONSTRAINT [DF_IcTransacted_InteliChartApiName]  DEFAULT ('') FOR [InteliChartApiName]
ALTER TABLE [migtemp_IcTransacted] ADD  CONSTRAINT [DF_IcTransacted_Reviewed]  DEFAULT (getutcdate()) FOR [Reviewed]
ALTER TABLE [migtemp_IcTransacted] ADD  CONSTRAINT [DF_IcTransacted_Transmitted]  DEFAULT ((1)) FOR [Transmitted]
ALTER TABLE [migtemp_IcTransacted] ADD  CONSTRAINT [DF_IcTransacted_DeleteSent]  DEFAULT ((0)) FOR [DeleteSent]

END
Truncate Table migtemp_IcTransacted
INSERT [migtemp_IcTransacted]([IcTransactedUid],[InteliChartApiName])
SELECT [IcTransactedUid],[InteliChartApiName]
FROM [IcTransacted]

DROP TABLE [IcTransacted]

exec  sp_rename 'migtemp_IcTransacted', 'IcTransacted'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_IMO_ProblemIT_Attribute]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_IMO_ProblemIT_Attribute](
	[IMO_ProblemIT_AttributeUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_IMO_ProblemIT_Attribute_IMO_ProblemIT_AttributeUid]  DEFAULT (newid()),
	[Range] [varchar](25) NOT NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_IMO_ProblemIT_Attribute_DisplayOrder]  DEFAULT ((0)),
	[IncludeInPatientDiagnosis] [bit] NULL CONSTRAINT [DF_IMO_ProblemIT_Attribute_IncludeInPatientDiagnosis]  DEFAULT ((1)),
	[DSMAxis] [varchar](25) NULL,
	[LifeLong] [bit] NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_IMO_ProblemIT_Attribute_Inactive]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_IMO_ProblemIT_Attribute_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_IMO_ProblemIT_Attribute_UserDefined]  DEFAULT ((1)),
	[Sort2Bottom] [bit] NULL
) ON [PRIMARY]



END
Truncate Table migtemp_IMO_ProblemIT_Attribute
INSERT [migtemp_IMO_ProblemIT_Attribute]([IMO_ProblemIT_AttributeUid],[Range],[DisplayOrder],[IncludeInPatientDiagnosis],[DSMAxis],[LifeLong],[Notes],[Inactive],[LastModifiedByUid],[LastModifiedDate])
SELECT [IMO_ProblemIT_AttributeUid],[Range],[DisplayOrder],[IncludeInPatientDiagnosis],[DSMAxis],[LifeLong],[Notes],[Inactive],[LastModifiedByUid],[LastModifiedDate]
FROM [IMO_ProblemIT_Attribute]

DROP TABLE [IMO_ProblemIT_Attribute]

exec  sp_rename 'migtemp_IMO_ProblemIT_Attribute', 'IMO_ProblemIT_Attribute'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListDecileCQM]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListDecileCQM](
	[DecileCQMUID] [uniqueidentifier] NOT NULL CONSTRAINT [df_ListDecileCQM_DecileCQMUID]  DEFAULT (newsequentialid()),
	[MeasureName] [varchar](max) NOT NULL,
	[Measure_ID] [varchar](20) NOT NULL,
	[CQMUID] [uniqueidentifier] NOT NULL,
	[CQMYear] [varchar](7) NOT NULL,
	[Decile1_Low] [numeric](6, 3) NULL,
	[Decile1_High] [numeric](6, 3) NULL,
	[Decile2_Low] [numeric](6, 3) NULL,
	[Decile2_High] [numeric](6, 3) NULL,
	[Decile3_Low] [numeric](6, 3) NULL,
	[Decile3_High] [numeric](6, 3) NULL,
	[Decile4_Low] [numeric](6, 3) NULL,
	[Decile4_High] [numeric](6, 3) NULL,
	[Decile5_Low] [numeric](6, 3) NULL,
	[Decile5_High] [numeric](6, 3) NULL,
	[Decile6_Low] [numeric](6, 3) NULL,
	[Decile6_High] [numeric](6, 3) NULL,
	[Decile7_Low] [numeric](6, 3) NULL,
	[Decile7_High] [numeric](6, 3) NULL,
	[Decile8_Low] [numeric](6, 3) NULL,
	[Decile8_High] [numeric](6, 3) NULL,
	[Decile9_Low] [numeric](6, 3) NULL,
	[Decile9_High] [numeric](6, 3) NULL,
	[Decile10_Low] [numeric](6, 3) NULL,
	[Decile10_High] [numeric](6, 3) NULL,
	[Inactive] [bit] NULL CONSTRAINT [df_ListDecileCQM_Inactive]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NULL CONSTRAINT [df_ListDecileCQM_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NULL CONSTRAINT [df_ListDecileCQM_UserDefined]  DEFAULT ((0)),
	[LastModifiedByUID] [uniqueidentifier] NULL
) ON [PRIMARY]



END
Truncate Table migtemp_ListDecileCQM
INSERT [migtemp_ListDecileCQM]([DecileCQMUID],[MeasureName],[Measure_ID],[CQMUID],[CQMYear],[Decile3_Low],[Decile3_High],[Decile4_Low],[Decile4_High],[Decile5_Low],[Decile5_High],[Decile6_Low],[Decile6_High],[Decile7_Low],[Decile7_High],[Decile8_Low],[Decile8_High],[Decile9_Low],[Decile9_High],[Decile10_Low],[Decile10_High],[Inactive],[LastModifiedDate],[UserDefined],[LastModifiedByUID])
SELECT [DecileCQMUID],[MeasureName],[Measure_ID],[CQMUID],[CQMYear],[Decile3_Low],[Decile3_High],[Decile4_Low],[Decile4_High],[Decile5_Low],[Decile5_High],[Decile6_Low],[Decile6_High],[Decile7_Low],[Decile7_High],[Decile8_Low],[Decile8_High],[Decile9_Low],[Decile9_High],[Decile10_Low],[Decile10_High],[Inactive],[LastModifiedDate],[UserDefined],[LastModifiedByUID]
FROM [ListDecileCQM]

DROP TABLE [ListDecileCQM]

exec  sp_rename 'migtemp_ListDecileCQM', 'ListDecileCQM'

exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListDpnGroup]') AND name = 'LockNodes')
    ALTER TABLE [ListDpnGroup] ADD [LockNodes] bit NOT NULL CONSTRAINT DF_ListDpnGroup_LockNodes DEFAULT ((0)) 
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListEditorControlLaunchContext]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListEditorControlLaunchContext](
	[ListEditorControlLaunchContextUid] [uniqueidentifier] NOT NULL,
	[Folder] [varchar](50) NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[ListEditorControlId] [varchar](50) NULL,
	[ListEditorItemImplemented] [bit] NOT NULL CONSTRAINT [DF_ListEditorControlLaunchContext_ListEditorItemImplemented]  DEFAULT ((0)),
	[NewImplemented] [bit] NOT NULL CONSTRAINT [DF_ListEditorControlLaunchContext_NewImplemented]  DEFAULT ((0)),
	[ModifyImplemented] [bit] NOT NULL CONSTRAINT [DF_ListEditorControlLaunchContext_ModifyImplemented]  DEFAULT ((0)),
	[DeleteImplemented] [bit] NOT NULL CONSTRAINT [DF_ListEditorControlLaunchContext_DeleteImplemented]  DEFAULT ((0)),
	[FindControlBehaviorUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListEditorControlLaunchContext_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListEditorControlLaunchContext'


END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListFhirLaunchParameterField]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListFhirLaunchParameterField](
	[FhirLaunchParameterFieldUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListFhirLaunchParameterField_FhirLaunchParameterFieldUid]  DEFAULT (newid()),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListFhirLaunchParameterField_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[ContextType] [varchar](50) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListFhirLaunchParameterField_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListFhirLaunchParameterField_LastModifiedDate]  DEFAULT (getutcdate()),
	[SqlTemplate] [nvarchar](max) NULL
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListFindControlBehavior]') AND name = 'ValidationConfig')
    ALTER TABLE [ListFindControlBehavior] ADD [ValidationConfig] varchar(max) NULL 
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListFormattingTemplate]') AND name = 'IsReadOnly')
    ALTER TABLE [ListFormattingTemplate] ADD [IsReadOnly] bit NOT NULL CONSTRAINT DF_ListFormattingTemplate_IsReadOnly DEFAULT ((0)) 
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListGroupUIConfiguration]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListGroupUIConfiguration](
	[GroupUIConfigurationUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListGroupUIConfiguration_GroupUIConfigurationUid]  DEFAULT (newid()),
	[UIConfigurationDataTypeUid] [uniqueidentifier] NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[RestrictedToPersonUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListGroupUIConfiguration_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListGroupUIConfiguration_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListGroupUIConfiguration_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]



END
Truncate Table migtemp_ListGroupUIConfiguration
INSERT [migtemp_ListGroupUIConfiguration]([GroupUIConfigurationUid],[ExternalID],[Name],[RestrictedToPersonUid],[Notes],[Inactive],[UserDefined],[LastModifiedByUid],[LastModifiedDate])
SELECT [GroupUIConfigurationUid],[ExternalID],[Name],[RestrictedToPersonUid],[Notes],[Inactive],[UserDefined],[LastModifiedByUid],[LastModifiedDate]
FROM [ListGroupUIConfiguration]

DROP TABLE [ListGroupUIConfiguration]

exec  sp_rename 'migtemp_ListGroupUIConfiguration', 'ListGroupUIConfiguration'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListIcDeleteProcessor]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListIcDeleteProcessor](
	[IcDeleteProcessorUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListIcDeleteProcessor_IcDeleteProcessorUid]  DEFAULT (newid()),
	[DeletableRegistryEntityEnumString] [varchar](100) NOT NULL,
	[ProcessingOrder] [int] NOT NULL,
	[OriginalMessageName] [varchar](100) NOT NULL,
	[TableName] [varchar](100) NOT NULL,
	[DeleteView] [varchar](100) NOT NULL,
	[AdditionalParameters] [varchar](max) NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListIcDeleteProcessor_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListIcDeleteProcessor_Inactive]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListIcDeleteProcessor_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'None' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListIcDeleteProcessor'


END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListIcPollingProcessor]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListIcPollingProcessor](
	[IcPollingProcessorUid] [uniqueidentifier] NOT NULL,
	[SendablePayload] [varchar](100) NOT NULL,
	[ProcessingOrder] [int] NOT NULL,
	[WebApiDirectory] [varchar](500) NULL,
	[MessageName] [varchar](500) NULL,
	[AdditionalParameters] [varchar](max) NULL,
	[Notes] [varchar](max) NULL,
	[IsPriority] [bit] NOT NULL CONSTRAINT [DF_ListIcPollingProcessor_IsPriority]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListIcPollingProcessor_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListIcPollingProcessor_Inactive]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListIcPollingProcessor_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'None' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListIcPollingProcessor'


END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListIcProcessor]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListIcProcessor](
	[IcProcessorUid] [uniqueidentifier] NOT NULL,
	[SendablePayload] [varchar](100) NOT NULL,
	[ProcessingOrder] [int] NOT NULL,
	[WebApiDirectory] [varchar](500) NULL,
	[MessageCategory] [varchar](500) NULL,
	[MessageName] [varchar](500) NULL,
	[IsSubscribeOperation] [bit] NOT NULL CONSTRAINT [DF_ListIcProcessor_IsSubscribeOperation]  DEFAULT ((0)),
	[IsUnsubscribeOperation] [bit] NOT NULL CONSTRAINT [DF_ListIcProcessor_IsUnsubscribeOperation]  DEFAULT ((0)),
	[IsDeleteOperation] [bit] NOT NULL CONSTRAINT [DF_ListIcProcessor_IsDeleteOperation]  DEFAULT ((0)),
	[AdditionalParameters] [varchar](max) NULL,
	[Notes] [varchar](max) NULL,
	[IsPriority] [bit] NOT NULL CONSTRAINT [DF_ListIcProcessor_IsPriority]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListIcProcessor_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListIcProcessor_Inactive]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListIcProcessor_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'None' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListIcProcessor'


END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListIcRequestProcessor]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListIcRequestProcessor](
	[IcRequestProcessorUid] [uniqueidentifier] NOT NULL,
	[SendablePayload] [varchar](100) NOT NULL,
	[WebApiDirectory] [varchar](500) NULL,
	[MessageCategory] [varchar](500) NULL,
	[MessageName] [varchar](500) NULL,
	[AdditionalParameters] [varchar](max) NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListIcRequestProcessor_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListIcRequestProcessor_Inactive]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListIcRequestProcessor_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'None' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListIcRequestProcessor'


END
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ListLOINC' AND COLUMN_NAME = 'COMPONENT')
ALTER TABLE [ListLOINC]  ALTER COLUMN [COMPONENT] varchar(max) NOT NULL 
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ListLOINC' AND COLUMN_NAME = 'SYSTEM')
ALTER TABLE [ListLOINC]  ALTER COLUMN [SYSTEM] varchar(250) NULL 
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ListLOINC' AND COLUMN_NAME = 'CLASS')
ALTER TABLE [ListLOINC]  ALTER COLUMN [CLASS] varchar(250) NULL 
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ListLOINC' AND COLUMN_NAME = 'STATUS')
ALTER TABLE [ListLOINC]  ALTER COLUMN [STATUS] varchar(250) NULL 
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListReport]') AND name = 'UIConfigurationUid')
    ALTER TABLE [ListReport] ADD [UIConfigurationUid] uniqueidentifier NULL 
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListUIConfiguration]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListUIConfiguration](
	[UIConfigurationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListUIConfiguration_UIConfigurationUid]  DEFAULT (newid()),
	[UIConfigurationDataTypeUid] [uniqueidentifier] NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NULL,
	[Notes] [varchar](max) NULL,
	[Data] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListUIConfiguration_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListUIConfiguration_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListUIConfiguration_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]



END
Truncate Table migtemp_ListUIConfiguration
INSERT [migtemp_ListUIConfiguration]([UIConfigurationUid],[ExternalID],[Name],[Notes],[Data],[Inactive],[UserDefined],[LastModifiedByUid],[LastModifiedDate])
SELECT [UIConfigurationUid],[ExternalID],[Name],[Notes],[Data],[Inactive],[UserDefined],[LastModifiedByUid],[LastModifiedDate]
FROM [ListUIConfiguration]

DROP TABLE [ListUIConfiguration]

exec  sp_rename 'migtemp_ListUIConfiguration', 'ListUIConfiguration'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListUIConfigurationDataType]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListUIConfigurationDataType](
	[UIConfigurationDataTypeUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListUIConfigurationDataType_ListUIConfigurationDataTypeUid]  DEFAULT (newid()),
	[ExternalId] [varchar](100) NULL,
	[Name] [varchar](100) NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListUIConfigurationDataType_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListUIConfigurationDataType_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListUIFilter]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListUIFilter](
	[UIFilterUid] [uniqueidentifier] NOT NULL,
	[UIFilterTypeUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](50) NULL,
	[Name] [varchar](50) NOT NULL,
	[Data] [varchar](max) NULL,
	[UIConfigurationUid] [uniqueidentifier] NULL,
	[FilterUid] [uniqueidentifier] NULL,
	[RestrictedToUid] [uniqueidentifier] NULL,
	[Inactive] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[AllowMaintenance] [bit] NOT NULL,
	[HasSecurity] [bit] NOT NULL,
	[SecurityGroupUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Relation to ListUIConfiguration for a specfic filter if data is meant for that UIConfig row.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListUIFilter', @level2type=N'COLUMN',@level2name=N'UIConfigurationUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Relation to ListFilter row this was migrated from or null if not migreated from ListFilter.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListUIFilter', @level2type=N'COLUMN',@level2name=N'FilterUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The last date the row was updated or the date added.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListUIFilter', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'

ALTER TABLE [ListUIFilter] ADD  CONSTRAINT [DF_ListUIFilter_ListUIFilterUid]  DEFAULT (newid()) FOR [UIFilterUid]
ALTER TABLE [ListUIFilter] ADD  CONSTRAINT [DF_ListUIFilter_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [ListUIFilter] ADD  CONSTRAINT [DF_ListUIFilter_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [ListUIFilter] ADD  CONSTRAINT [DF_ListUIFilter_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListUIFilterType]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListUIFilterType](
	[UIFilterTypeUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListUIFilterType_UIFilterTypeUid]  DEFAULT (newid()),
	[ExternalId] [varchar](100) NULL,
	[Name] [varchar](100) NOT NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListUIFilterType_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListUIFilterType_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_Message]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_Message](
	[MessageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_Message_MessageUid]  DEFAULT (newid()),
	[ParentMessageUid] [uniqueidentifier] NULL,
	[CreatedByUid] [uniqueidentifier] NULL,
	[PersonUid] [uniqueidentifier] NULL,
	[MessageTypeUid] [uniqueidentifier] NOT NULL,
	[MessageSubTypeUid] [uniqueidentifier] NULL,
	[Header] [varchar](8000) NULL,
	[MessageUrgencyUid] [uniqueidentifier] NULL,
	[MessageStatusUid] [uniqueidentifier] NULL,
	[CreatedDate] [date] NOT NULL CONSTRAINT [DF_Message_CreatedDate]  DEFAULT (getdate()),
	[CreatedDateTime] [datetime] NOT NULL CONSTRAINT [DF_Message_DateCreated]  DEFAULT (getutcdate()),
	[DateToBeCompleted] [date] NULL,
	[AutoComplete] [bit] NOT NULL CONSTRAINT [DF_Message_AutoComplete]  DEFAULT ((0)),
	[DateCompleted] [datetime] NULL,
	[LastReadByUid] [uniqueidentifier] NULL,
	[CompletedByUid] [uniqueidentifier] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[StrikeOut] [bit] NOT NULL CONSTRAINT [DF_Message_StrikeOut_1]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_Msgs_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[MessageDataXML] [xml] NULL,
	[FirstReadDate] [datetime] NULL,
	[MessageXML] [xml] NULL,
	[EventTypeUid] [uniqueidentifier] NULL,
	[ExternalMessageId] [varchar](100) NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the guid of the message' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'MessageUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the guid of the message that is the parent. This is used when a message is split into multiple messages. Each of the new messages will have its parent set to the message from which it originated.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'ParentMessageUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the person that created the message' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'CreatedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the patient with whom  the message is associated' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'PersonUid'
EXEC sys.sp_addextendedproperty @name=N'ClassMap', @value=N'<query table=''ListMessageType'' name=''Name'' key=''MessageTypeUid'' MessageDataXML=''MessageDataXmlType''/>' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'MessageTypeUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the type of the message' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'MessageTypeUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the string used to display the message in a list' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'Header'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the urgency of the message' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'MessageUrgencyUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the status of the message. A message that is completed can be archived.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'MessageStatusUid'
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'DateCreated' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'CreatedDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the (UTC) date and time the message was created' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'CreatedDateTime'
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'DateCreated' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'CreatedDateTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the (UTC) date and time the message was completed' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'DateCompleted'
EXEC sys.sp_addextendedproperty @name=N'Replication.LimitContentSizeSelectByValueOf', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'DateCompleted'
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'DateCompleted'
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'CompletedByUid'
EXEC sys.sp_addextendedproperty @name=N'Type', @value=N'object' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'MessageDataXML'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the event type of the message' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'EventTypeUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Table that stores message envelopes. The context of a message is stored in a separate table, e.g. MessageTask or MessageRx' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message'
EXEC sys.sp_addextendedproperty @name=N'Replication.IgnoreConflictColumns', @value=N'DateCompleted,LastReadByUid,CompletedByUid' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message'
EXEC sys.sp_addextendedproperty @name=N'Replication.Lock', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message'
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'FK_Message_Person' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message'
EXEC sys.sp_addextendedproperty @name=N'Replication.RootTableOfNonAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message'


END
Truncate Table migtemp_Message
INSERT [migtemp_Message]([MessageUid],[ParentMessageUid],[CreatedByUid],[PersonUid],[MessageTypeUid],[MessageSubTypeUid],[Header],[MessageUrgencyUid],[MessageStatusUid],[CreatedDate],[CreatedDateTime],[DateToBeCompleted],[AutoComplete],[DateCompleted],[LastReadByUid],[CompletedByUid],[VisitUid],[StrikeOut],[LastModifiedDate],[LastModifiedByUid],[MessageDataXML],[FirstReadDate],[MessageXML],[EventTypeUid])
SELECT [MessageUid],[ParentMessageUid],[CreatedByUid],[PersonUid],[MessageTypeUid],[MessageSubTypeUid],[Header],[MessageUrgencyUid],[MessageStatusUid],[CreatedDate],[CreatedDateTime],(SELECT dbo.ConvertTimeByTimezone(DateToBeCompleted, (SELECT TOP 1 StringValue FROM ListProductParameter WHERE ParameterName = 'TimeZoneString'))),[AutoComplete],[DateCompleted],[LastReadByUid],[CompletedByUid],[VisitUid],[StrikeOut],[LastModifiedDate],[LastModifiedByUid],CONVERT(nvarchar(max), [MessageDataXML]),[FirstReadDate],CONVERT(nvarchar(max), [MessageXML]),[EventTypeUid]
FROM [Message]

DROP TABLE [Message]

exec  sp_rename 'migtemp_Message', 'Message'

exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[PatientCareManagementLog]') AND name = 'IsBHI')
    ALTER TABLE [PatientCareManagementLog] ADD [IsBHI] bit NOT NULL CONSTRAINT DF_PatientCareManagementLog_IsBHI DEFAULT ((0)) 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[PatientCareManagementLog]') AND name = 'BHICOCM')
    ALTER TABLE [PatientCareManagementLog] ADD [BHICOCM] bit NOT NULL CONSTRAINT DF_PatientCareManagementLog_BHICOCM DEFAULT ((0)) 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[PatientCareManagementLog]') AND name = 'BHIGeneral')
    ALTER TABLE [PatientCareManagementLog] ADD [BHIGeneral] bit NOT NULL CONSTRAINT DF_PatientCareManagementLog_BHIGeneral DEFAULT ((0)) 
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[Person]') AND name = 'InterpreterRequired')
    ALTER TABLE [Person] ADD [InterpreterRequired] bit NULL 
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PracticeSettings' AND COLUMN_NAME = 'StatementFooter')
ALTER TABLE [PracticeSettings]  ALTER COLUMN [StatementFooter] nvarchar(max) NULL 
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[Provider]') AND name = 'HCCDenialResponseConfigurationId')
    ALTER TABLE [Provider] ADD [HCCDenialResponseConfigurationId] smallint NULL 
exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'AutoLinkDxCpt' , N'SCHEMA',N'dbo', N'TABLE',N'Provider', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'AutoLinkDxCpt' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Provider'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'DefaultEMPlaceofServiceID' , N'SCHEMA',N'dbo', N'TABLE',N'Provider', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'DefaultEMPlaceofServiceID' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Provider'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'DocumentFaxElection' , N'SCHEMA',N'dbo', N'TABLE',N'Provider', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'DocumentFaxElection' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Provider'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'iforeignkey' , N'SCHEMA',N'dbo', N'TABLE',N'Provider', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'iforeignkey' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Provider'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'ProviderLicense' , N'SCHEMA',N'dbo', N'TABLE',N'Provider', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'ProviderLicense' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Provider'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'ProviderRoleID' , N'SCHEMA',N'dbo', N'TABLE',N'Provider', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'ProviderRoleID' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Provider'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Cache.Required' , N'SCHEMA',N'dbo', N'TABLE',N'Provider', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.Cache.Required' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Provider'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'Provider', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.EMRAdminTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Provider'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Patient' , N'SCHEMA',N'dbo', N'TABLE',N'Provider', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.Patient' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Provider'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'ROSOrder' , N'SCHEMA',N'dbo', N'TABLE',N'Provider', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'ROSOrder' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Provider'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'SignatureTypeId' , N'SCHEMA',N'dbo', N'TABLE',N'Provider', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'SignatureTypeId' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Provider'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'Provider', N'COLUMN',N'FTE'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Provider', @level2type=N'COLUMN',@level2name=N'FTE'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'Provider', N'COLUMN',N'ROSOrder'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Provider', @level2type=N'COLUMN',@level2name=N'ROSOrder'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'AutoLinkDxCpt' , N'SCHEMA',N'dbo', N'TABLE',N'Provider', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'AutoLinkDxCpt', @value=N'<NoAutoLink value="0" /><AutoLinkAll value="1" /><AutoLinkOnlyEM value="2" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Provider'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'DefaultEMPlaceofServiceID' , N'SCHEMA',N'dbo', N'TABLE',N'Provider', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'DefaultEMPlaceofServiceID', @value=N'<Office value="0" description="Office" /><NursingFacility value="1" description="Nursing Facility" /><HomeServices value="2" description="Home Services" /><RestHome value="3" description="Rest Home" /><Observation value="4" description="Observation" /><Inpatient value="5" description="Inpatient" /><CriticalCare value="6" description="Critical Care" /><ER value="7" description="ER" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Provider'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'DocumentFaxElection' , N'SCHEMA',N'dbo', N'TABLE',N'Provider', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'DocumentFaxElection', @value=N'<NoFax value="0" />
<AutoFax value="1" />
<Prompt value="2" />
' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Provider'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'HCCDenialResponseConfigurationId' , N'SCHEMA',N'dbo', N'TABLE',N'Provider', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'HCCDenialResponseConfigurationId', @value=N'<NA value="0"/><Optional value="1"/><Required value="2"/>' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Provider'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'iforeignkey' , N'SCHEMA',N'dbo', N'TABLE',N'Provider', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'iforeignkey', @value=N'UserPRM' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Provider'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'ProviderLicense' , N'SCHEMA',N'dbo', N'TABLE',N'Provider', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'ProviderLicense', @value=N'<None value="0" />
<EMR value="1" />
<PM value="2" />
<PRM value="3" />
' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Provider'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'ProviderRoleID' , N'SCHEMA',N'dbo', N'TABLE',N'Provider', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'ProviderRoleID', @value=N'<Physician value="1" />
<OtherProvider value="2" />
<TestProvider value="3" />
' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Provider'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Cache.Required' , N'SCHEMA',N'dbo', N'TABLE',N'Provider', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.Cache.Required', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Provider'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'Provider', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Provider'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Patient' , N'SCHEMA',N'dbo', N'TABLE',N'Provider', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'!FK_Provider_Person' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Provider'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'ROSOrder' , N'SCHEMA',N'dbo', N'TABLE',N'Provider', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'ROSOrder', @value=N'<HeadToToe value="0" />
<Alphabetical value="1" />
<UserDefined value="2" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Provider'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'SignatureTypeId' , N'SCHEMA',N'dbo', N'TABLE',N'Provider', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'SignatureTypeId', @value=N'<None value="0" />
<Permanent value="1" />
<OncePerDay value="2" />
<OncePerLogin value="3" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Provider'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'Provider', N'COLUMN',N'FTE'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The full time equivalent percentage for this provider' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Provider', @level2type=N'COLUMN',@level2name=N'FTE'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'Provider', N'COLUMN',N'ROSOrder'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0 - Head to Toe; 1 - Alphabetical; 2 - User Defined' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Provider', @level2type=N'COLUMN',@level2name=N'ROSOrder'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Provider' , N'SCHEMA',N'dbo', N'TABLE',N'ProviderDefaultSIG', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.Provider' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ProviderDefaultSIG'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'oldname' , N'SCHEMA',N'dbo', N'TABLE',N'ProviderDefaultSIG', N'COLUMN',N'KdbConfigurationUid'))
EXEC sys.sp_dropextendedproperty @name=N'oldname' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ProviderDefaultSIG', @level2type=N'COLUMN',@level2name=N'KdbConfigurationUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ProviderDefaultSIG', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ProviderDefaultSIG'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'oldname' , N'SCHEMA',N'dbo', N'TABLE',N'ProviderDefaultSIG', N'COLUMN',N'KdbConfigurationUid'))
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'ProviderUid' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ProviderDefaultSIG', @level2type=N'COLUMN',@level2name=N'KdbConfigurationUid'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelFormLayoutUIConfiguration]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelFormLayoutUIConfiguration](
	[RelFormLayoutUIConfigurationUid] [uniqueidentifier] NOT NULL,
	[FormLayoutUid] [uniqueidentifier] NOT NULL,
	[UIConfigurationUid] [uniqueidentifier] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]


ALTER TABLE [RelFormLayoutUIConfiguration] ADD  CONSTRAINT [DF_RelFormLayoutUIConfiguration_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [RelFormLayoutUIConfiguration] ADD  CONSTRAINT [DF_RelFormLayoutUIConfiguration_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelMacroGroupSecurity]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelMacroGroupSecurity](
	[MacroGroupSecurityUid] [uniqueidentifier] NOT NULL,
	[MacroGroupUid] [uniqueidentifier] NOT NULL,
	[UserUid] [uniqueidentifier] NULL,
	[UserGroupUid] [uniqueidentifier] NULL,
	[NewAllowed] [bit] NOT NULL,
	[ModifyAllowed] [bit] NOT NULL,
	[DeleteAllowed] [bit] NOT NULL,
	[IsLockedBySystem] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]


ALTER TABLE [RelMacroGroupSecurity] ADD  CONSTRAINT [DF_RelMacroGroupSecurity_NewAllowed]  DEFAULT ((0)) FOR [NewAllowed]
ALTER TABLE [RelMacroGroupSecurity] ADD  CONSTRAINT [DF_RelMacroGroupSecurity_ModifiedAllowed]  DEFAULT ((0)) FOR [ModifyAllowed]
ALTER TABLE [RelMacroGroupSecurity] ADD  CONSTRAINT [DF_RelMacroGroupSecurity_DeleteAllowed]  DEFAULT ((0)) FOR [DeleteAllowed]
ALTER TABLE [RelMacroGroupSecurity] ADD  CONSTRAINT [DF_RelMacroGroupSecurity_IsLockedBySystem]  DEFAULT ((0)) FOR [IsLockedBySystem]
ALTER TABLE [RelMacroGroupSecurity] ADD  CONSTRAINT [DF_RelMacroGroupSecurity_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [RelMacroGroupSecurity] ADD  CONSTRAINT [DF_RelMacroGroupSecurity_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelUIFilterUserPRM]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelUIFilterUserPRM](
	[RelUIFilterUserPRMUid] [uniqueidentifier] NOT NULL,
	[UIFilterTypeUid] [uniqueidentifier] NOT NULL,
	[SubType] [varchar](50) NOT NULL,
	[UIFilterUid] [uniqueidentifier] NOT NULL,
	[UserPRMUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]


ALTER TABLE [RelUIFilterUserPRM] ADD  CONSTRAINT [DF_RelUIFilterUserPRM_RelUIFilterUserPRMUid]  DEFAULT (newid()) FOR [RelUIFilterUserPRMUid]
ALTER TABLE [RelUIFilterUserPRM] ADD  CONSTRAINT [DF_RelUIFilterUserPRM_SubType]  DEFAULT ('') FOR [SubType]
ALTER TABLE [RelUIFilterUserPRM] ADD  CONSTRAINT [DF_RelUIFilterUserPRM_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelUserDefinedControlGroupUIConfiguration]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelUserDefinedControlGroupUIConfiguration](
	[RelUserDefinedControlGroupUIConfigurationUid] [uniqueidentifier] NOT NULL,
	[UserDefinedControlGroupUid] [uniqueidentifier] NOT NULL,
	[UIConfigurationUid] [uniqueidentifier] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]


ALTER TABLE [RelUserDefinedControlGroupUIConfiguration] ADD  CONSTRAINT [DF_RelUserDefinedControlGroupUIConfiguration_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [RelUserDefinedControlGroupUIConfiguration] ADD  CONSTRAINT [DF_RelUserDefinedControlGroupUIConfiguration_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SuspectedDiagnosis]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[SuspectedDiagnosis](
	[SuspectedDiagnosisUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[DeniedProviderUid] [uniqueidentifier] NULL,
	[CreatedByUid] [uniqueidentifier] NOT NULL,
	[CreateDate] [datetime] NOT NULL,
	[DeniedDate] [datetime] NULL,
	[Code] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[Name] [varchar](255) NULL,
	[DeniedReason] [varchar](max) NULL,
	[SnomedCTConceptId] [bigint] NULL,
	[DSMAxis] [varchar](250) NULL,
	[HccCommunityFactors] [decimal](4, 3) NULL,
	[HccModelCat] [int] NULL,
	[LexicalCode] [bigint] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]


ALTER TABLE [SuspectedDiagnosis] ADD  CONSTRAINT [DF_SuspectedDiagnosis_RowGuid]  DEFAULT (newid()) FOR [SuspectedDiagnosisUid]
ALTER TABLE [SuspectedDiagnosis] ADD  CONSTRAINT [DF_SuspectedDiagnosis_CreateDate]  DEFAULT (getutcdate()) FOR [CreateDate]
ALTER TABLE [SuspectedDiagnosis] ADD  CONSTRAINT [DF_SuspectedDiagnosis_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UIConfigurationHistory]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[UIConfigurationHistory](
	[UIConfigurationHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[UIConfigurationUid] [uniqueidentifier] NOT NULL,
	[IsCurrentHistoryRow] [bit] NOT NULL,
	[GroupingUid] [uniqueidentifier] NULL,
	[UIConfigurationDataTypeUid] [uniqueidentifier] NULL,
	[Version] [smallint] NOT NULL,
	[IsPublished] [bit] NOT NULL,
	[UIConfigurationHistoryDataUid] [uniqueidentifier] NOT NULL,
	[IsDelete] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[ActiveDate] [date] NULL,
	[InactiveDate] [date] NULL,
	[CreatedDateTime] [datetime] NOT NULL,
	[Sequence] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Marks the current active row in a UIConfigurationHistoryUid within the same GroupUid. Can be used to form a filter for returning rows.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UIConfigurationHistory', @level2type=N'COLUMN',@level2name=N'IsCurrentHistoryRow'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Is used to find all the history rows belonging to the IsCurrentHistoryRow row. The first row create for a new row’s PK will populate the value for the GroupingUid.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UIConfigurationHistory', @level2type=N'COLUMN',@level2name=N'GroupingUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Marks a row "Deleted" without removing the row. The UI will show this row as struck-out.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UIConfigurationHistory', @level2type=N'COLUMN',@level2name=N'IsDelete'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Allows finding the history rows within the same GroupUid that are active. Can be used with InactiveDate and GroupUid to form a filter for returning rows.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UIConfigurationHistory', @level2type=N'COLUMN',@level2name=N'ActiveDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Allows finding the history rows within the same GroupUid that are inactive. Can be used with ActiveDate and GroupUid to form a filter for returning rows.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UIConfigurationHistory', @level2type=N'COLUMN',@level2name=N'InactiveDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Allows sorting the history rows within the same GroupUid in the order entered.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UIConfigurationHistory', @level2type=N'COLUMN',@level2name=N'Sequence'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The last date the row was updated or the date added.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UIConfigurationHistory', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'

ALTER TABLE [UIConfigurationHistory] ADD  CONSTRAINT [DF_UIConfigurationHistory_UIConfigurationHistoryUid]  DEFAULT (newid()) FOR [UIConfigurationHistoryUid]
ALTER TABLE [UIConfigurationHistory] ADD  CONSTRAINT [DF_UIConfigurationHistory_IsCurrentHistoryRow]  DEFAULT ((0)) FOR [IsCurrentHistoryRow]
ALTER TABLE [UIConfigurationHistory] ADD  CONSTRAINT [DF_UIConfigurationHistory_IsPublished]  DEFAULT ((0)) FOR [IsPublished]
ALTER TABLE [UIConfigurationHistory] ADD  CONSTRAINT [DF_UIConfigurationHistory_IsDelete]  DEFAULT ((0)) FOR [IsDelete]
ALTER TABLE [UIConfigurationHistory] ADD  CONSTRAINT [DF_UIConfigurationHistory_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [UIConfigurationHistory] ADD  CONSTRAINT [DF_UIConfigurationHistory_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [UIConfigurationHistory] ADD  CONSTRAINT [DF_UIConfigurationHistory_CreatedDateTime]  DEFAULT (getutcdate()) FOR [CreatedDateTime]
ALTER TABLE [UIConfigurationHistory] ADD  CONSTRAINT [DF_UIConfigurationHistory_Sequence]  DEFAULT (getutcdate()) FOR [Sequence]
ALTER TABLE [UIConfigurationHistory] ADD  CONSTRAINT [DF_UIConfigurationHistory_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UIConfigurationHistoryData]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[UIConfigurationHistoryData](
	[UIConfigurationHistoryDataUid] [uniqueidentifier] NOT NULL,
	[Data] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]


ALTER TABLE [UIConfigurationHistoryData] ADD  CONSTRAINT [DF_UIConfigurationHistoryData_UIConfigurationHistoryDataUid]  DEFAULT (newid()) FOR [UIConfigurationHistoryDataUid]
ALTER TABLE [UIConfigurationHistoryData] ADD  CONSTRAINT [DF_UIConfigurationHistoryData_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [UIConfigurationHistoryData] ADD  CONSTRAINT [DF_UIConfigurationHistoryData_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO


