<?xml version="1.0"?>
<xsl:stylesheet version="1.0"
 xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
 xmlns:msxsl="urn:schemas-microsoft-com:xslt"
 xmlns:user="urn:schemas-imedica.com:prm">
	<xsl:template match="PatientOutsideProviders">
		<xsl:element name="DIV">
			<xsl:attribute name="ID">printDiv</xsl:attribute>
			<xsl:attribute name="name">PatientOutsideProviders</xsl:attribute>
			<table border="0" cellpadding="1" cellspacing="0" width="98%" align="center" style="table-layout: fixed;">
        <col width="15%"/>
        <col width="18%"/>
        <col width="35%"/>
        <col width="10%"/>
        <col width="10%"/>
        <col width="6%"/>
        <col width="6%"/>
        <TR class="insideGreyHeader">
					<TD align="left" nowrap="true" valign="top">
						<SPAN class="smallHeader">Provider Name</SPAN>
					</TD>
          <TD align="left" nowrap="true" valign="top">
            <SPAN class="smallHeader">Specialty</SPAN>
          </TD>
          <TD align="left" nowrap="true" valign="top">
            <SPAN class="smallHeader">Address</SPAN>
          </TD>
          <TD align="left" nowrap="true" valign="top">
						<SPAN class="smallHeader">Phone1</SPAN>
					</TD>
          <TD align="left" nowrap="true" valign="top">
            <SPAN class="smallHeader">Phone2</SPAN>
          </TD>
          <TD align="left" nowrap="true" valign="top">
            <SPAN class="smallHeader">UPIN</SPAN>
          </TD>
          <TD align="left" nowrap="true" valign="top">
            <SPAN class="smallHeader">NPI</SPAN>
          </TD>
        </TR>
			</table>
			<table border="0" cellpadding="1" cellspacing="0" width="98%" align="center" style="table-layout: fixed;">
        <col width="15%"/>
        <col width="18%"/>
        <col width="35%"/>
        <col width="10%"/>
        <col width="10%"/>
        <col width="6%"/>
        <col width="6%"/>
        <xsl:choose>
					<xsl:when test="ViewOutsideProvider/@ProviderUid[.!='']">
						<xsl:for-each select="ViewOutsideProvider">
							<xsl:sort select="@DisplayOrder" order="ascending"/>
							<TR class="picklist" ID="MyRow" NAME="MyRow" style="cursor:hand">
								<xsl:if test="position() mod 2 = 0">
									<xsl:attribute name="bgcolor">whitesmoke</xsl:attribute>
								</xsl:if>
								<xsl:if test="position() mod 2 = 1">
									<xsl:attribute name="bgcolor">white</xsl:attribute>
								</xsl:if>
								<xsl:attribute name="onMouseOver">hiliteRow("picklist","#cccccc");</xsl:attribute>
								<xsl:attribute name="onMouseOut">setTrBgColor(this);</xsl:attribute>
								
                <TD align="left" nowrap="true" title="Click here to edit this provider" class="small">
									<xsl:attribute name="onClick">
                    if (iMedica.Patient.EditOutsideProvider('<xsl:value-of select="@PatientOutsideProviderUid"/>')) init1();
                  </xsl:attribute>
										<xsl:value-of select="@ProviderName"/>
								</TD>
                <TD align="left" nowrap="true" title="Click here to edit this provider" class="small">
                  <xsl:attribute name="onClick">
                    if (iMedica.Patient.EditOutsideProvider('<xsl:value-of select="@PatientOutsideProviderUid"/>')) init1();
                  </xsl:attribute>
                     <xsl:value-of select="@Specialty"/>
                </TD>
                <TD align="left" nowrap="true" title="Click here to edit this provider" class="small">
                  <xsl:attribute name="onClick">
                    if (iMedica.Patient.EditOutsideProvider('<xsl:value-of select="@PatientOutsideProviderUid"/>')) init1();
                  </xsl:attribute>
                    <xsl:value-of select="@Address1"/>&#xa0;<xsl:value-of select="@Address2"/>,&#xa0;<xsl:value-of select="@City"/>&#xa0;<xsl:value-of select="@State"/>
                 </TD>
								<TD align="left" nowrap="true" hint="Click here to edit this pharmacy" class="small">
									<xsl:attribute name="onClick">
                    if (iMedica.Patient.EditOutsideProvider('<xsl:value-of select="@PatientOutsideProviderUid"/>')) init1();
                  </xsl:attribute>
                  <xsl:value-of select="@Phone1"/>
                </TD>
                <TD align="left" nowrap="true" title="Click here to edit this pharmacy" class="small">
                  <xsl:attribute name="onClick">
                    if (iMedica.Patient.EditOutsideProvider('<xsl:value-of select="@PatientOutsideProviderUid"/>')) init1();
                  </xsl:attribute>
										<xsl:value-of select="@Phone2"/>
								</TD>
                <TD align="left" nowrap="true" title="Click here to edit this pharmacy" class="small">
                  <xsl:attribute name="onClick">
                    if (iMedica.Patient.EditOutsideProvider('<xsl:value-of select="@PatientOutsideProviderUid"/>')) init1();
                  </xsl:attribute>
                  <xsl:value-of select="@DefaultUPIN"/>
                </TD>
                <TD align="left" nowrap="true" title="Click here to edit this pharmacy" class="small">
                  <xsl:attribute name="onClick">
                    if (iMedica.Patient.EditOutsideProvider('<xsl:value-of select="@PatientOutsideProviderUid"/>')) init1();
                  </xsl:attribute>
                  <xsl:value-of select="@DefaultNPI"/>
                </TD>

                <TD width="20" valign="top">
									<button type="button" title="Click here to delete this pharmacy" style="height 10px">
										<xsl:attribute name="onClick">
                      if (iMedica.Patient.DeleteOutsideProvider('<xsl:value-of select="@PatientOutsideProviderUid"/>')) init1();
										</xsl:attribute>
										<b>X</b>
									</button>
								</TD>
								<TD width="0" valign="top">
									<xsl:element name="INPUT">
										<xsl:attribute name="TYPE">hidden</xsl:attribute>
										<xsl:attribute name="ID">
											contactUUID<xsl:value-of select="UUID"/>
										</xsl:attribute>
										<xsl:attribute name="NAME">
											contactUUID<xsl:value-of select="UUID"/>
										</xsl:attribute>
										<xsl:attribute name="VALUE">
											<xsl:value-of select="UUID"/>
										</xsl:attribute>
									</xsl:element>
								</TD>
							</TR>
						</xsl:for-each>
					</xsl:when>
					<xsl:otherwise>
						<TR ID="MyRow" NAME="MyRow" CLASS="picklist" bgcolor="white">
							<TD width="598" colspan="6" align="center" nowrap="true" valign="top">
								<SPAN class="hint">(No Outside Providers listed for this Patient.)</SPAN>
							</TD>
						</TR>
					</xsl:otherwise>
				</xsl:choose>
			</table>
			<br/>
		</xsl:element>
		<!--printDIV-->
		<table width="98%" align="center" border="0" cellpadding="1" cellspacing="0" style="table-layout: fixed;">
			<TR>
				<TD width="70%" valign="top">
					<SPAN class="hint">
						Click on the X button next to a Provider to remove it. Click '<B>Add</B>' to find and add a new Provider.
					</SPAN>
				</TD>
				<TD width="30%" align="right">
					<input id="btnPrintDemographics" type="button" class="blueBtn" value="Add" >
						<xsl:attribute name="onClick">if(iMedica.Patient.AddOutsideProvider(PersonUid)) init1();</xsl:attribute>
					</input>
				</TD>
			</TR>
		</table>

	</xsl:template>
</xsl:stylesheet>