angular.module("aprima-provider-api",["restangular","angularLocalStorage","lodash","aprima-core","aprima-bridge","aprima-config","aprima-legacy-common"]),angular.module("aprima-provider-api").factory("AppointmentRepository",["AprimaRestangular","MetadataRepository","$q","moment","AprimaAnalytics","SingleAccessSet",function(AprimaRestangular,MetadataRepository,$q,moment,AprimaAnalytics,SingleAccessSet){"use strict";var apptListeners=[],modifiedCalendarIdsForCalendarList=new SingleAccessSet,modifiedCalendarIdsForDashboard=new SingleAccessSet;function getAppointment(uid,appComponent,subRoute){var timing=AprimaAnalytics.startTiming(appComponent||"AppointmentRepository","api","getAppointment"),restangular=AprimaRestangular.get();return restangular.all("appointments"+(subRoute||"")).one(uid).get().then(function(appt){return appt.getClone=function(){return restangular.copy(appt)},appt}).finally(timing.stop)}var updateAppointment=function(appt){var timing=AprimaAnalytics.startTiming("AppointmentRepository","api","updateAppointment");return appt.put().finally(timing.stop).finally(function(){appt.Calendar&&(modifiedCalendarIdsForCalendarList.add(appt.Calendar.Id),modifiedCalendarIdsForDashboard.add(appt.Calendar.Id))})},createAppointment=function(appt,subRoute){var timing=AprimaAnalytics.startTiming("AppointmentRepository","api","createAppointment");return AprimaRestangular.get().all("appointments"+(subRoute||"")).post(appt).finally(timing.stop).finally(function(){appt.Calendar&&(modifiedCalendarIdsForCalendarList.add(appt.Calendar.Id),modifiedCalendarIdsForDashboard.add(appt.Calendar.Id))})};function getAppointmentsInternal(calendarId,params,restangularOptions,appComponent){var timing=AprimaAnalytics.startTiming(appComponent||"AppointmentRepository","api","getAppointments");return calendarId?AprimaRestangular.get(restangularOptions).all("calendars/"+calendarId+"/appointments").getList(params).finally(timing.stop):$q.when([])}return{getAppointmentDetails:function(uid,appComponent){return getAppointment(uid,appComponent)},getAppointmentMetadata:function($scope){var timing=AprimaAnalytics.startTiming("AppointmentRepository","api","getAppointmentMetadata");return MetadataRepository.getMetadata("appointmentdetail",$scope).finally(timing.stop)},getDashboardAppointments:function(calendar,restangularOptions,appComponent){angular.isString(restangularOptions)&&(appComponent=restangularOptions,restangularOptions=null),restangularOptions=restangularOptions||{ignoreCache:!1};var calendarId=calendar.Id||null,options={date:moment().format("MM-DD-YYYY"),offsetMinutes:moment().utcOffset()};return restangularOptions.ignoreCache=modifiedCalendarIdsForDashboard.contains(calendarId)||restangularOptions.ignoreCache,getAppointmentsInternal(calendarId,options,restangularOptions,appComponent)},getAppointments:function(calendarId,params,restangularOptions,appComponent){return angular.isString(restangularOptions)&&(appComponent=restangularOptions,restangularOptions=null),(restangularOptions=restangularOptions||{ignoreCache:!1}).ignoreCache=modifiedCalendarIdsForCalendarList.contains(calendarId)||restangularOptions.ignoreCache,getAppointmentsInternal(calendarId,params,restangularOptions,appComponent)},getGroupAppointmentMetadata:function($scope){var timing=AprimaAnalytics.startTiming("AppointmentRepository","api","getAppointmentMetadata");return MetadataRepository.getMetadata("groupvisitappointment",$scope).finally(timing.stop)},getBlockingEventAppointmentMetadata:function($scope){var timing=AprimaAnalytics.startTiming("AppointmentRepository","api","getAppointmentMetadata");return MetadataRepository.getMetadata("blockingeventappointment",$scope).finally(timing.stop)},getEventAppointmentMetadata:function($scope){var timing=AprimaAnalytics.startTiming("AppointmentRepository","api","getAppointmentMetadata");return MetadataRepository.getMetadata("eventappointment",$scope).finally(timing.stop)},getGroupAppointment:function(uid,appComponent){return getAppointment(uid,appComponent,"/group-visit")},getEventAppointment:function(uid,appComponent){return getAppointment(uid,appComponent,"/event")},addListener:function(callback){apptListeners&&callback&&apptListeners.indexOf(callback)<0&&apptListeners.push(callback)},removeListener:function(callback){apptListeners&&callback&&0<=apptListeners.indexOf(callback)&&apptListeners.pop(callback)},getBlockingEventAppointment:function(uid,appComponent){return getAppointment(uid,appComponent,"/blocking-event")},updatePatientAppointment:function(appt){return updateAppointment(appt)},createPatientAppointment:function(appt){return createAppointment(appt)},updateGroupAppointment:function(appt){return updateAppointment(appt)},createGroupAppointment:function(appt){return createAppointment(appt,"/group-visit")},updateEventAppointment:function(appt){return updateAppointment(appt)},createEventAppointment:function(appt){return createAppointment(appt,"/event")},updateBlockingEventAppointment:function(appt){return updateAppointment(appt)},createBlockingEventAppointment:function(appt){return createAppointment(appt,"/blocking-event")}}}]),angular.module("aprima-provider-api").factory("AttachmentApprovalRepository",["AprimaRestangular",function(AprimaRestangular){"use strict";return{approve:function(messageUid,attachmentUid){return AprimaRestangular.get().one("aamessage",messageUid).one("approve",attachmentUid).post()}}}]),angular.module("aprima-provider-api").factory("AttachmentRepository",["AprimaRestangular","AprimaAnalytics",function(aprimaRestangular,AprimaAnalytics){"use strict";return{getAttachment:function(attachmentId,requestSettings,applicationComponent,disableInLinePdf){var timing=AprimaAnalytics.startTiming(applicationComponent||"AttachmentRepository","api","getAttachment"),inlinePDF=!disableInLinePdf,queryString="?page="+requestSettings.page+"&height="+requestSettings.height+"&width="+requestSettings.width+"&inLinePDF="+inlinePDF;return aprimaRestangular.get().one("attachments/"+attachmentId+queryString).get().finally(timing.stop)},getAttachmentStaticUrl:function(attachmentId,applicationComponent){var timing=AprimaAnalytics.startTiming(applicationComponent||"AttachmentRepository","api","getAttachmentStaticUrl");return aprimaRestangular.get().one("attachments-url/"+attachmentId).get().finally(timing.stop)},getAttachmentRetainOriginalFormat:function(attachmentId,applicationComponent){var timing=AprimaAnalytics.startTiming(applicationComponent||"AttachmentRepository","api","getAttachmentRetainOriginalFormat");return aprimaRestangular.get().one("attachments/"+attachmentId+"?retainoriginalformat=true").get().finally(timing.stop)}}}]),function(angular,Object){"use strict";var blockedSlotBehavior={};window.Object.defineProperties(blockedSlotBehavior,{None:{value:"None",writable:!1,enumerable:!0,configurable:!1},Override:{value:"Override",writable:!1,enumerable:!0,configurable:!1},BookInAddition:{value:"BookInAddition",writable:!1,enumerable:!0,configurable:!1}}),angular.module("aprima-provider-api").constant("BlockedSlotBehavior",blockedSlotBehavior)}(window.angular),angular.module("aprima-provider-api").factory("CalendarRepository",["AprimaRestangular","$q",function(AprimaRestangular,$q){"use strict";return{getDayTemplate:function(calendarId,params){if(calendarId)return AprimaRestangular.get().all("calendars/"+calendarId+"/daytemplate").getList(params);return $q.when([])},getAppointmentOpenSlots:function(search){return search?search.calendarId?search.date?(search={calendarId:search.calendarId,startDate:search.date,appointmentTypeId:search.appointmentTypeId},AprimaRestangular.get().all("calendars").one(search.calendarId).all("opentemplateslots").getList(search)):$q.when(new Error("date must be defined")):$q.when(new Error("calendarId must be defined")):$q.when(new Error("search object must be defined"))}}}]),function(angular){"use strict";window.angular.module("aprima-provider-api").factory("CustomDiagnosisRepository",["$q","AprimaAnalytics","AprimaRestangular",function($q,AprimaAnalytics,AprimaRestangular){var routePrefix="custom-diagnosis";return{getdiagnoses:_.partial(getdiagnoses,null),abortable:function(promisesToAbort){return{getdiagnoses:_.partial(getdiagnoses,promisesToAbort)}}};function getdiagnoses(promisesToAbort,paramsObj){var result=function(promisesToAbort,route,params,getFn){var restElement=AprimaRestangular.get().all(routePrefix).all(route);promisesToAbort&&(restElement=restElement.abortable(promisesToAbort));return getFn(restElement,params).then(function(data){return _.isNil(data)?$q.reject("IMO "+api+" request failed for params: "+JSON.stringify(params)):data})}(promisesToAbort,"getdiagnoses",paramsObj,customGet);return result}function customGet(element,params){return element.customGET("",params)}}])}(),angular.module("aprima-provider-api").factory("DiagnosisRepository",["AprimaRestangular",function(aprimaRestangular){"use strict";return{getDiagnoses:function(searchString,records,codeType){var queryString="?maxRecords="+(records=records||20);return queryString+=codeType?"ICD10"===codeType?"&icd10Code=":"&icd9Code=":"&diagnosisText=",queryString+=searchString,aprimaRestangular.get().all("diagnoses/"+queryString).getList()},getModifiers:function(){return aprimaRestangular.get().all("diagnosis/modifiers").getList()}}}]),function(angular){"use strict";window.angular.module("aprima-provider-api").factory("DosingService",["$q","DosingServiceTs",function($q,DosingServiceTs){return{convertToCommonUnit:function(dosageUnits,dosageAmount){return DosingServiceTs.convertToCommonUnit(dosageUnits,dosageAmount)},getDoseRangeInfo:function(ageInDays,medId,gcnSeqNo,weightKg,heightCm,gestationalAge,doseTypeIndicator,icdCode){var promise=DosingServiceTs.getDoseRangeInfo(ageInDays,medId,gcnSeqNo,weightKg,heightCm,gestationalAge,doseTypeIndicator,icdCode).toPromise();return $q.when(promise)},getMinMaxWarning:function(sigInstructions,rxParameters,patientDetails){var promise=DosingServiceTs.getMinMaxWarning(sigInstructions,rxParameters,patientDetails).toPromise();return $q.when(promise)},getDosingDetailsFull:function(visitId,patientId,defaultValue){var promise=DosingServiceTs.getDosingDetailsFull(visitId,patientId,defaultValue).toPromise();return $q.when(promise)},getVariableDoseRanges:function(gcnSeqNo){var promise=DosingServiceTs.getVariableDoseRanges(gcnSeqNo).toPromise();return $q.when(promise)},mapDoseParams:function(sigInstructions,rxParameters,patientDetails){return DosingServiceTs.mapDoseParams(sigInstructions,rxParameters,patientDetails)}}}])}(),angular.module("aprima-provider-api").factory("DrugRepository",["_","AprimaRestangular","AprimaAnalytics","Guid",function(_,AprimaRestangular,AprimaAnalytics,Guid){"use strict";return{getDrugFormularyInfo:function(medId,patientId,restangularOptions){restangularOptions=restangularOptions||{ignoreCache:!1};var timing=AprimaAnalytics.startTiming("DrugRepository","api","get drug formulary info");return AprimaRestangular.get(restangularOptions).all("drugs/"+medId+"/formularyalternatives/"+patientId).getList().finally(timing.stop)},getDrugRepresentativeFormularies:function(medId,eRxEligibilityId,patientId,relVisitMedicationId,pharmacyId,days,dispenseAsWritten,totalQuantity,unitOfMeasureId,previousPMBCParameters,previousRFSParameters,providerId,restangularOptions){restangularOptions=restangularOptions||{ignoreCache:!1};var timing=AprimaAnalytics.startTiming("DrugRepository","api","get drug representative formularies"),restangular=AprimaRestangular.get(restangularOptions),url="drugs/"+medId+"/representativeformularies/"+(eRxEligibilityId||Guid.empty())+"?days="+(days||"")+"&dispenseAsWritten="+(dispenseAsWritten||"")+"&proposedRelVisitMedicationId="+(relVisitMedicationId||"")+"&patientId="+(patientId||"")+"&pharmacyId="+(pharmacyId||Guid.empty())+"&totalQuantity="+(totalQuantity||"")+"&unitOfMeasureId="+(unitOfMeasureId||"")+"&previousPMBCParameters="+(previousPMBCParameters?encodeURIComponent(previousPMBCParameters):"")+"&previousRFSParameters="+(previousRFSParameters?encodeURIComponent(previousRFSParameters):"")+"&providerId="+(providerId||Guid.empty())+(medId?"":"&ignoreCache="+(new Date).getTime());return restangular.one(url).get().finally(timing.stop)},getDrugFormularyDetail:function(medId,patientId,restangularOptions){restangularOptions=restangularOptions||{ignoreCache:!1};var timing=AprimaAnalytics.startTiming();return AprimaRestangular.get(restangularOptions).all("drugs/"+medId+"/formularydetail/"+patientId).getList().finally(timing.stop)},nddDrugScreening:function(patientId,drug,otherDrugs,previousMedicationSigId){var timing=AprimaAnalytics.startTiming("DrugRepository","api","nddDrugScreening");return AprimaRestangular.get().one("patients/"+patientId+"/nddscreening").customPOST({Drug:drug,OtherDrugs:otherDrugs,PreviousMedicationSigUid:previousMedicationSigId}).finally(timing.stop)}}}]),angular.module("aprima-provider-api").factory("ExternalPatientsRepository",["AprimaRestangular","MetadataRepository","AprimaAnalytics","storage","_",function(AprimaRestangular,MetadataRepository,AprimaAnalytics,storage,_){"use strict";var storageKey="external-patients.reload-list";function requestExternalPatients(result){return storage.set(storageKey,!0),result}return{getExternalPatients:function(externalPatientListId,restangularOptions,appComponent){restangularOptions=_.defaults(restangularOptions||{},{ignoreCache:storage.get(storageKey)||!1});var timing=AprimaAnalytics.startTiming(appComponent||"PatientRepository","api","getExternalPatients");return AprimaRestangular.get(restangularOptions).all("externalpatients/"+externalPatientListId).getList({date:moment().startOf("day").toJSON()}).finally(function(){timing.stop(),restangularOptions.ignoreCache&&storage.remove(storageKey)})},getExternalPatient:function(hospitalRoundId){return AprimaRestangular.get().all("externalpatients").one("patients").one(hospitalRoundId).get()},addExternalPatient:function(command){return AprimaRestangular.get().all("externalpatients").post(command).then(requestExternalPatients)},editExternalPatient:function(command){return AprimaRestangular.get().all("externalpatients").one("patients").one(command.HospitalRoundId).customPUT(command).then(requestExternalPatients)},getAddExternalPatientModelMetadata:function($scope){return MetadataRepository.getMetadata("addexternalpatient",$scope)},getEditExternalPatientModelMetadata:function($scope){return MetadataRepository.getMetadata("editexternalpatient",$scope)},dischargePatient:function(hospitalRoundId){return AprimaRestangular.get().all("externalpatients").one(hospitalRoundId).post("",{HospitalRoundId:hospitalRoundId}).then(requestExternalPatients)}}}]),function(angular){"use strict";angular.module("aprima-provider-api").factory("FinancialCenterService",["_","$q","AprimaAnalytics","AprimaCache","AprimaRestangular","ServerInfoRepository",function(_,$q,AprimaAnalytics,AprimaCache,AprimaRestangular,ServerInfoRepository){var defaultCache=AprimaCache.Default.httpMode;return{getDefault:function(defaultToMain,providerId,serviceSiteId,calendarId){return function(route,params,requiredFeature,cache){if(requiredFeature&&!ServerInfoRepository.isFeatureSupported(requiredFeature))return $q.when(null);var timing=AprimaAnalytics.startTiming("FinancialCenterService","api",route);return AprimaRestangular.get().one("financialcenters",route).withHttpConfig({cache:cache}).get(params).finally(timing.stop)}("default",{defaultToMain:!!defaultToMain,providerId:providerId,serviceSiteId:serviceSiteId,calendarId:calendarId},"DefaultFinancialCenter",defaultCache)}}}])}(window.angular),function(angular){"use strict";window.angular.module("aprima-provider-api").factory("EpaRepository",["AprimaRestangular",function(AprimaRestangular){return{canSendEpaRequest:function(){return AprimaRestangular.get().one("complex-permissions","send-epa-request").get()},sendEpaRequest:function(relVisitMedicationId){return AprimaRestangular.get().one("rx",relVisitMedicationId).all("epa-request").post()}}}])}(),function(){"use strict";angular.module("aprima-provider-api").factory("FncDxRepository",["AprimaRestangular",function(AprimaRestangular){return{getDiagnoses:function(patientId,visitId){return AprimaRestangular.get().one("patients",patientId).one("fnc",visitId).all("dx").getList()},postImoDiagnoses:function(patientId,visitId,result){return AprimaRestangular.get().one("patients",patientId).one("fnc",visitId).all("dx-term").post(result)},postDiagnoses:function(patientId,visitId,result){return AprimaRestangular.get().one("patients",patientId).one("fnc",visitId).all("dx").post(result)},deleteDiagnosis:function(patientId,visitId,diagnosisId){return AprimaRestangular.get().one("patients",patientId).one("fnc",visitId).one("dx",diagnosisId).remove()},deleteDiagnoses:function(patientId,visitId,diagnosisIds){return AprimaRestangular.get().one("patients",patientId).one("fnc",visitId).all("dx").remove({diagnosisIds:diagnosisIds})}}}])}(),function(){"use strict";angular.module("aprima-provider-api").factory("FncPlanRepository",["AprimaRestangular","DeviceSettings","$q","Bridge",function(AprimaRestangular,DeviceSettings,$q,Bridge){return{getPlans:function(patientId,visitId){var url="patients/"+patientId+"/fnc/"+visitId+"/plan";return AprimaRestangular.get({ignoreCache:!0}).all(url).getList()},inactivatePlan:function(plan,patientId){if(DeviceSettings.isPrm)Bridge.fireEvent("inactivate-diagnosis",{PatientId:patientId,VisitDate:plan.VisitDate,VisitId:plan.VisitUid,VisitDiagnosisId:plan.VisitDiagnosisUid});else{var url="patients/"+patientId+"/fnc/"+plan.VisitUid+"/inactivatediagnosis/"+plan.VisitDiagnosisUid;AprimaRestangular.get({ignoreCache:!0}).all(url).post().then(function(){Bridge.fireEvent("inactivated-diagnosis",plan.VisitDiagnosisUid)}).catch(function(error){console.log("Error inactivating diagnosis: "+error)})}},saveDefaults:function(patientId,visitId,planConfigurationId,configuration){var url="patients/"+patientId+"/fnc/"+visitId+"/plan/defaults/"+planConfigurationId;return AprimaRestangular.get({ignoreCache:!0}).all(url).post(configuration)},updatePlan:function(plan){return plan.put()}}}])}(),function(){"use strict";angular.module("aprima-provider-api").factory("FncRepository",["AprimaAnalytics","AprimaRestangular",function(AprimaAnalytics,AprimaRestangular){return{getClinicalNotes:function(providerId){var timing=AprimaAnalytics.startTiming("FncRepository","api","getClinicalNotes");return AprimaRestangular.get().all("fnc/clinicalnotetypes/"+providerId).getList().finally(timing.stop)},getContext:function(patientId,visitId){var timing=AprimaAnalytics.startTiming("FncRepository","api","getContext");return AprimaRestangular.get().one("patients/"+patientId+"/fnc/"+visitId+"/context").get().finally(timing.stop)},createVisitFromAppt:function(appointmentId,clinicalNoteTypeId){var timing=AprimaAnalytics.startTiming("FncRepository","api","createVisitFromAppt");return AprimaRestangular.get().all("fnc").post({AppointmentId:appointmentId,ClinicalNoteTypeId:clinicalNoteTypeId}).finally(timing.stop)},getAuthCode:function(patientCaseId,visitDate){var timing=AprimaAnalytics.startTiming("FncRepository","api","getAuthCode");return AprimaRestangular.get().one("fnc/patientcases",patientCaseId).customGET("authorizationcode",{visitDate:visitDate}).finally(timing.stop)}}}])}(),function(angular){"use strict";angular.module("aprima-provider-api").factory("FncRxRepository",["AprimaRestangular","AprimaAnalytics",function(AprimaRestangular,AprimaAnalytics){return{addPrescription:function(patientId,visitId,prescription){var timing=AprimaAnalytics.startTiming("FncRxRepository","api","addPrescription");return AprimaRestangular.get().all("patients/"+patientId+"/fnc/"+visitId+"/rx/addprescription").post(prescription).finally(timing.stop)},changeMedication:function(patientId,visitId,relPatientMedicationId,prescription){var timing=AprimaAnalytics.startTiming("FncRxRepository","api","changeMedication");return AprimaRestangular.get().all("patients/"+patientId+"/fnc/"+visitId+"/rx/change-prescription").post({Prescription:prescription,RelPatientMedicationId:relPatientMedicationId}).finally(timing.stop)},changeMedicationFromHistoryOnly:function(patientId,visitId,relPatientMedicationId,prescription){var timing=AprimaAnalytics.startTiming("FncRxRepository","api","changeMedicationFromHistoryOnly");return AprimaRestangular.get().all("patients/"+patientId+"/fnc/"+visitId+"/rx/change-prescription-from-history-only").post({Prescription:prescription,RelPatientMedicationId:relPatientMedicationId}).finally(timing.stop)},deleteRx:function(relVisitMedicationId){return AprimaRestangular.get().one("fnc/rx",relVisitMedicationId).remove()},editPrescription:function(patientId,visitId,prescription){var timing=AprimaAnalytics.startTiming("FncRxRepository","api","editPrescription");return AprimaRestangular.get().all("patients/"+patientId+"/fnc/"+visitId+"/rx/editprescription").post(prescription).finally(timing.stop)},editPrescriptionDiagnosis:function(patientId,visitId,relVisitMedicationId,problems){var timing=AprimaAnalytics.startTiming("FncRxRepository","api","editPrescriptionDiagnosis");return AprimaRestangular.get().all("patients/"+patientId+"/fnc/"+visitId+"/rx/"+relVisitMedicationId+"/editprescriptiondiagnosis").post(problems).finally(timing.stop)},getAuthorizedPrescriberList:function(sigType){var timing=AprimaAnalytics.startTiming("FncRxRepository","api","getAuthorizedPrescriberList");return AprimaRestangular.get().all("fnc/rx/authorizedprescriberlist").getList({sigType:sigType}).finally(timing.stop)},getDrugScreeningResults:function(patientId,visitId){var timing=AprimaAnalytics.startTiming("FncRxRepository","api","drugScreening");return AprimaRestangular.get().one("patients/"+patientId+"/fnc/"+visitId+"/rx/screening").get().finally(timing.stop)},getNddDrugScreeningResultsFromPatient:function(patientId){var timing=AprimaAnalytics.startTiming("FncRxRepository","api","getNddDrugScreeningResultsFromPatient");return AprimaRestangular.get().one("patients/"+patientId+"/fnc/rx/nddscreening").get().finally(timing.stop)},getNddDrugScreeningResults:function(patientId,visitId){var timing=AprimaAnalytics.startTiming("FncRxRepository","api","nddDrugScreening");return AprimaRestangular.get().one("patients/"+patientId+"/fnc/"+visitId+"/rx/nddscreening").get().finally(timing.stop)},getPrescriberRights:function(){var timing=AprimaAnalytics.startTiming("FncRxRepository","api","getPrescriberRights");return AprimaRestangular.get().one("fnc/rx/prescriberrights").get().finally(timing.stop)},getSigwriterNddDrugScreeningResults:function(patientId,visitId,drug,medicationSigId){var timing=AprimaAnalytics.startTiming("FncRxRepository","api","sigwriterDrugScreening");return AprimaRestangular.get().all("patients/"+patientId+"/fnc/"+visitId+"/rx/sigwriter/nddscreening").post({Drug:drug,MedicationSigId:medicationSigId}).finally(timing.stop)},getVisitMedStatus:function(relVisitMedicationId){var timing=AprimaAnalytics.startTiming("FncRxRepository","api","getVisitMedicationStatus");return AprimaRestangular.get().all("fnc").all("rx").one("visit-medication-status",relVisitMedicationId).get().finally(timing.stop)},getVisitMedStatuses:function(relVisitMedicationIdList){var timing=AprimaAnalytics.startTiming("FncRxRepository","api","getVisitMedicationStatuses"),restangular=AprimaRestangular.get(),params={relVisitMedicationIds:relVisitMedicationIdList};return restangular.all("fnc").all("rx").all("visit-medication-status").customGET("",params).then(function(data){return data&&data.Results?data.Results:$q.reject("Could not retrieve medication statuses")}).finally(timing.stop)},getVisitPrescriptions:function(patientId,visitId){var timing=AprimaAnalytics.startTiming("FncRxRepository","api","getVisitPrescriptions");return AprimaRestangular.get().all("patients/"+patientId+"/fnc/"+visitId+"/rx").getList().finally(timing.stop)},refillMedication:function(patientId,visitId,relPatientMedicationId,prescription){var timing=AprimaAnalytics.startTiming("FncRxRepository","api","refillMedication");return AprimaRestangular.get().all("patients/"+patientId+"/fnc/"+visitId+"/rx/refillprescription").post({Prescription:prescription,RelPatientMedicationId:relPatientMedicationId}).finally(timing.stop)},refillMedicationFromPreviousVisit:function(patientId,visitId,relVisitMedicationId,prescription){var timing=AprimaAnalytics.startTiming("FncRxRepository","api","refillMedicationFromPreviousVisit");return AprimaRestangular.get().one("patients",patientId).one("fnc",visitId).all("rx/refill-previous-visit-prescription").post({Prescription:prescription,SelectedRelVisitMedicationId:relVisitMedicationId}).finally(timing.stop)},startChange:function(patientId,visitId,relPatientMedicationId,sigType){var timing=AprimaAnalytics.startTiming("FncRxRepository","api","startChange");return AprimaRestangular.get().one("patients/"+patientId+"/fnc/"+visitId+"/rx/start-change").get({relPatientMedicationId:relPatientMedicationId,sigType:sigType}).finally(timing.stop)},startChangeFromHistoryOnly:function(patientId,visitId,relPatientMedicationId,sigType){var timing=AprimaAnalytics.startTiming("FncRxRepository","api","startChangeFromHistoryOnly");return AprimaRestangular.get().one("patients/"+patientId+"/fnc/"+visitId+"/rx/start-change-from-history-only").get({relPatientMedicationId:relPatientMedicationId,sigType:sigType}).finally(timing.stop)},startCppMedication:function(patientId,visitId,cppMedicationId,sigType){var timing=AprimaAnalytics.startTiming("FncRxRepository","api","startCppMedication");return AprimaRestangular.get().one("patients/"+patientId+"/fnc/"+visitId+"/rx/start-cpp-medication").get({cppMedicationId:cppMedicationId,sigType:sigType}).finally(timing.stop)},startRefill:function(patientId,visitId,relPatientMedicationId,sigType){var timing=AprimaAnalytics.startTiming("FncRxRepository","api","startRefill");return AprimaRestangular.get().one("patients/"+patientId+"/fnc/"+visitId+"/rx/startrefill").get({relPatientMedicationId:relPatientMedicationId,sigType:sigType}).finally(timing.stop)},startRefillFromPreviousVisit:function(patientId,visitId,relVisitMedicationId,sigType){var timing=AprimaAnalytics.startTiming("FncRxRepository","api","startRefillFromPreviousVisit");return AprimaRestangular.get().one("patients",patientId).one("fnc",visitId).customGET("rx/start-previous-visit-refill",{relVisitMedicationId:relVisitMedicationId,sigType:sigType}).finally(timing.stop)},startRefills:function(patientId,visitId,relPatientMedicationIds,sigType){var timing=AprimaAnalytics.startTiming("FncRxRepository","api","startRefills");return AprimaRestangular.get().one("patients/"+patientId+"/fnc/"+visitId+"/rx/startrefills").get({relPatientMedicationIds:relPatientMedicationIds,sigType:sigType}).finally(timing.stop)},updateRxPharmacies:function(relVisitMedicationIds,patientId,pharmacyId){var timing=AprimaAnalytics.startTiming("FncRxRepository","api","updateRxPharmacies");return AprimaRestangular.get().all("fnc/rx/pharmacy").post({RelVisitMedicationIds:relVisitMedicationIds,PatientId:patientId,PharmacyId:pharmacyId}).finally(timing.stop)},getQueuedMedications:function(patientId){var timing=AprimaAnalytics.startTiming("FncRxRepository","api","getVisitPrescriptions");return AprimaRestangular.get().all("patients/"+patientId+"/fnc/queued-rx").getList().finally(timing.stop)},deleteQueuedMedication:function(relVisitMedicationId){return AprimaRestangular.get().one("/fnc/queued-rx",relVisitMedicationId).remove()},updateRxRefill:function(patientId,visitId,relVisitMedicationId,refillQty,medicaitonDays){var timing=AprimaAnalytics.startTiming("FncRxRepository","api","editPrescription");return AprimaRestangular.get().all("patients/"+patientId+"/fnc/"+visitId+"/rx/"+relVisitMedicationId+"/refill/"+refillQty+"/days/"+medicaitonDays).post().finally(timing.stop)}}}])}(angular),function(angular){"use strict";window.angular.module("aprima-provider-api").factory("FncVisitInfoRepository",["AprimaAnalytics","AprimaRestangular","MetadataRepository",function(AprimaAnalytics,AprimaRestangular,MetadataRepository){return{create:function(visitInfo){var timing=AprimaAnalytics.startTiming("FncRepository","api","createVisitInfo");return AprimaRestangular.get().all("fnc/visit-info").post(visitInfo).finally(timing.stop)},save:function(visitInfo){var timing=AprimaAnalytics.startTiming("FncRepository","api","saveVisitInfo");return AprimaRestangular.get().all("fnc/visit-info").customPUT(visitInfo).finally(timing.stop)},get:function(visitId){var timing=AprimaAnalytics.startTiming("FncRepository","api","getVisitInfo");return AprimaRestangular.get().one("fnc",visitId).customGET("visit-info").finally(timing.stop)},getMetadata:function(scope){var timing=AprimaAnalytics.startTiming("AppointmentRepository","api","getVisitInfoMetadata");return MetadataRepository.getMetadata("visit-info",scope).finally(timing.stop)}}}])}(),function(){"use strict";angular.module("aprima-provider-api").factory("VisitCommentRepository",["AprimaAnalytics","AprimaRestangular",function(AprimaAnalytics,AprimaRestangular){return{getVisitComment:function(visitId,visitCommentType){var timing=AprimaAnalytics.startTiming("VisitCommentRepository","api","getContext");return AprimaRestangular.get().one("visitcomment/"+visitId).get({visitComment:visitCommentType}).finally(timing.stop)},updateVisitComment:function(visitCommentTypeDto){var timing=AprimaAnalytics.startTiming("VisitCommentRepository","api","getContext");return AprimaRestangular.get().one("visitcomment/update/").customPOST(visitCommentTypeDto).finally(timing.stop)}}}])}(),function(angular){"use strict";window.angular.module("aprima-provider-api").factory("GeneralNotesRepository",["$q","AprimaCache","AprimaRestangular",function($q,AprimaCache,AprimaRestangular){var service={search:function(searchText,generalNoteTypeId,includeInactive){return AprimaRestangular.get().all("general-notes").getList({searchText:searchText,generalNoteTypeUid:generalNoteTypeId,includeInactive:includeInactive})},getGeneralNoteType:function(noteTypeOrId){var cachedItem=generalNoteTypeCache.getClone(noteTypeOrId);if(cachedItem)return $q.when(cachedItem);return AprimaRestangular.get().all("general-note-types").get(noteTypeOrId).then(function(data){return data?(data.plain&&(data=data.plain()),generalNoteTypeCache.put(noteTypeOrId,data),data):$q.reject("Could not retrieve GeneralNoteType")})},saveGeneralNoteTypeSetting:function(noteTypeKey,generalNoteType){return AprimaRestangular.get().one("settings","general-note-types").customPUT({NoteTypeKey:noteTypeKey,GeneralNoteType:generalNoteType}).then(function(data){return data&&data.NoteTypeKey&&data.GeneralNoteType?generalNoteTypeCache.put(data.NoteTypeKey,data.GeneralNoteType):generalNoteTypeCache.remove(noteTypeKey),data})}},generalNoteTypeCache=AprimaCache.Default;return service}])}(),function(angular){"use strict";angular.module("aprima-provider-api").factory("HxMedicationRepository",["AprimaAnalytics","AprimaRestangular",function(AprimaAnalytics,AprimaRestangular){return{addPrescription:function(patientId,visitId,skippedSigwriter,prescription){var timing=AprimaAnalytics.startTiming("HxMedicationRepository","api","addPrescription"),restangular=AprimaRestangular.get(),dto={Prescription:prescription,SkippedSigwriter:skippedSigwriter,VisitId:visitId};return restangular.all("patients/"+patientId+"/addprescription").post(dto).finally(timing.stop)},deleteMedication:function(medication,visitId){var timing=AprimaAnalytics.startTiming("HxMedicationRepository","api","deleteMedication");return AprimaRestangular.get().one("history/visit",visitId).one("medication",medication.RelPatientMedicationUid).remove().finally(timing.stop)},getMedicationListFilters:function(subtype){var timing=AprimaAnalytics.startTiming("HxMedicationRepository","api","getMedicationListFilters"),queryString="?subtype="+subtype;return AprimaRestangular.get().one("history/rx-filters"+queryString).get().finally(timing.stop)},getPatientTakesNoMeds:function(patientId,visitId){var timing=AprimaAnalytics.startTiming("HxMedicationRepository","api","getPatientTakesNoMeds"),restangular=AprimaRestangular.get(),params={VisitId:visitId};return restangular.one("patients/"+patientId+"/patienttakesnomeds").get(params).finally(timing.stop)},getPrescriptionHistory:function(patientId,visitId,filterId){var timing=AprimaAnalytics.startTiming("FncRxRepository","api","getPrescriptionHistory"),restangular=AprimaRestangular.get(),params={FilterId:filterId,VisitId:visitId};return restangular.one("patients/"+patientId+"/rx-history").get(params).finally(timing.stop)},getPrescriptionHistoryForDiscontinueCancel:function(patientId,visitId,relPatientMedicationIds){var timing=AprimaAnalytics.startTiming("HxMedicationRepository","api","getPrescriptionHistoryForDiscontinueCancel"),params={RelPatientMedicationIds:relPatientMedicationIds,VisitId:visitId};return AprimaRestangular.get().one("patients/"+patientId+"/rxhistory/discontinue-cancel").get(params).finally(timing.stop)},getTransitionOfCare:function(patientId,visitId){var timing=AprimaAnalytics.startTiming("HxMedicationRepository","api","getTransitionOfCare"),restangular=AprimaRestangular.get(),params={VisitId:visitId};return restangular.one("patients/"+patientId+"/transitionofcare").get(params).finally(timing.stop)},setMedicationFilter:function(setMedicationFilterDto){var timing=AprimaAnalytics.startTiming("HxMedicationRepository","api","setMedicationFilter");return AprimaRestangular.get().all("history/rx-filter").post(setMedicationFilterDto).finally(timing.stop)},setPatientTakesNoMeds:function(patientId,visitId,patientTakesNoMeds){var timing=AprimaAnalytics.startTiming("HxMedicationRepository","api","setPatientTakesNoMeds"),restangular=AprimaRestangular.get(),params={VisitId:visitId};return restangular.all("patients/"+patientId+"/patienttakesnomeds").post(patientTakesNoMeds,params).finally(timing.stop)},setTransitionOfCare:function(patientId,visitId,transitionOfCare){var timing=AprimaAnalytics.startTiming("HxMedicationRepository","api","setTransitionOfCare"),restangular=AprimaRestangular.get(),params={VisitId:visitId};return restangular.all("patients/"+patientId+"/transitionofcare").post(transitionOfCare,params).finally(timing.stop)},getPatientMedStatus:function(relPatientMedicationId){var timing=AprimaAnalytics.startTiming("HxMedicationRepository","api","getPatientMedicationStatus");return AprimaRestangular.get().all("history").one("patient-medication-status",relPatientMedicationId).get().finally(timing.stop)},getPatientMedStatuses:function(relPatientMedicationIdList){var timing=AprimaAnalytics.startTiming("HxMedicationRepository","api","getPatientMedicationStatuses");return AprimaRestangular.get().all("history").all("patient-medication-status").customPOST(relPatientMedicationIdList).then(function(data){return data&&data.Results?data.Results:$q.reject("Could not retrieve medication statuses")}).finally(timing.stop)},discontinueCancelMedications:function(patientId,dto){var timing=AprimaAnalytics.startTiming("HxMedicationRepository","api","discontinueCancelMedications");return AprimaRestangular.get().all("patients/"+patientId+"/rxhistory/process-discontinue-cancel").post(dto).finally(timing.stop)},isRxOnPatientAllergyList:function(patientId,visitId,relPatientMedicationId){var timing=AprimaAnalytics.startTiming("HxMedicationRepository","api","isRxOnPatientAllergyList"),params={RelPatientMedicationId:relPatientMedicationId,VisitId:visitId};return AprimaRestangular.get().one("patients/"+patientId+"/rxhistory/on-patient-drug-allergy-list").get(params).finally(timing.stop)},getCompareInfoForDiscontinueCancel:function(patientId,relPatientMedicationId){var timing=AprimaAnalytics.startTiming("HxMedicationRepository","api","getCompareInfoForDiscontinueCancel");return AprimaRestangular.get().one("patients/"+patientId+"/rxhistory/discontinue-cancel/compare/"+relPatientMedicationId).get().finally(timing.stop)}}}])}(angular),angular.module("aprima-provider-api").factory("MedicalDevicesRepository",["AprimaRestangular",function(AprimaRestangular){"use strict";return{getMedicalDeviceParseUdi:function(uniqueDeviceId){var searchCriteria={UniqueDeviceIdentifier:uniqueDeviceId};return AprimaRestangular.get().one("history/medical-device/").customGET("parse-udi",searchCriteria)},getMedicalDeviceLookup:function(deviceId,uniqueDeviceId){var searchCriteria={DeviceIdentifier:deviceId,UniqueDeviceIdentifier:uniqueDeviceId};return AprimaRestangular.get().one("history/medical-device/").customGET("lookup",searchCriteria)},getMedicalDevices:function(patientId,visitId){var searchCriteria={PatientId:patientId,VisitId:visitId};return AprimaRestangular.get().one("history/medical-device/patient/").customGET(patientId+"/",searchCriteria)},createMedicalDevice:function(createDeviceAttributes){return AprimaRestangular.get().all("history/medical-device/patient/"+createDeviceAttributes.PatientId+"/").post(createDeviceAttributes)},updateMedicalDevice:function(updateDeviceAttributes){return AprimaRestangular.get().one("history/medical-device/patient/"+updateDeviceAttributes.PatientId+"/device/"+updateDeviceAttributes.PatientMedicalDeviceHistoryId).customPUT(updateDeviceAttributes)},displayMedicalDeviceHistory:function(patientId,groupingId){return AprimaRestangular.get().one("history/medical-device/patient/"+patientId+"/device/"+groupingId+"/history").get()}}}]),function(angular){"use strict";window.angular.module("aprima-provider-api").factory("ImoDiagnosisRepository",["$q","AprimaAnalytics","AprimaRestangular","ImoPatient",function($q,AprimaAnalytics,AprimaRestangular,ImoPatient){var routePrefix="imo-problem";return{term:_.partial(term,null),terms:_.partial(terms,null),detail:_.partial(detail,null),details:_.partial(details,null),count:_.partial(count,null),abortable:function(promisesToAbort){return{term:_.partial(term,promisesToAbort),terms:_.partial(terms,promisesToAbort),detail:_.partial(detail,promisesToAbort),details:_.partial(details,promisesToAbort),count:_.partial(count,promisesToAbort)}}};function term(promisesToAbort,paramsObj){var result=get(promisesToAbort,"terms",paramsObj,regularGet);return result}function terms(promisesToAbort,paramsObj,patient){var params=createPatientParams(paramsObj,patient),result=get(promisesToAbort,"terms",params,customGet);return result}function detail(promisesToAbort,paramsObj){var result=get(promisesToAbort,"detail-terms",paramsObj,regularGet);return result}function details(promisesToAbort,paramsObj){var result=get(promisesToAbort,"detail-terms",paramsObj,customGet);return result}function count(promisesToAbort,paramsObj,patient){var params=createPatientParams(paramsObj,patient);params.CountOnly=!0;var result=get(promisesToAbort,"terms",params,customGet);return result}function createPatientParams(paramsObj,patient){return paramsObj=paramsObj||{},patient instanceof ImoPatient&&(patient.hasAge&&(paramsObj.PatientAge=patient.standardizedAge),patient.hasGender&&(paramsObj.PatientGender=patient.standardizedGender)),paramsObj}function get(promisesToAbort,route,params,getFn){var restElement=AprimaRestangular.get().all(routePrefix).all(route);return promisesToAbort&&(restElement=restElement.abortable(promisesToAbort)),getFn(restElement,params).then(function(data){return _.isNil(data)?$q.reject("IMO "+api+" request failed for params: "+JSON.stringify(params)):data})}function regularGet(element,params){return element.get(params)}function customGet(element,params){return element.customGET("",params)}}])}(),function(angular){"use strict";window.angular.module("aprima-provider-api").factory("ImoDiagnosisService",["_","$q","AprimaCache","ImoDiagnosisRepository",function(_,$q,AprimaCache,ImoDiagnosisRepository){return{term:function(code,localCache){return getSingle(code,AprimaCache.ImoTerms,localCache,ImoDiagnosisRepository.term)},terms:function(codes,localCache){return getList(codes,AprimaCache.ImoTerms,localCache,ImoDiagnosisRepository.terms)},detail:function(code,localCache){return getSingle(code,AprimaCache.ImoDetails,localCache,ImoDiagnosisRepository.detail)},details:function(codes,localCache){return getList(codes,AprimaCache.ImoDetails,localCache,ImoDiagnosisRepository.details)}};function getSingle(code,aprimaCache,localCache,getData){var result=(localCache=localCache||{})[code]||aprimaCache.get(code);return result&&result.LexicalCode===code?$q.when(result):getData(code).then(function(data){return data&&data.LexicalCode?(data.plain&&(data=data.plain()),localCache[code]=data,aprimaCache.put(code,data),data):$q.reject("Could not retrieve IMO term")})}function getList(codes,aprimaCache,localCache,getData){if(_.isArray(codes)){if(_.isEmpty(codes))return $q.when([])}else codes=[codes];localCache=localCache||{};var result=[],codesToBeLoaded=[];return _.forEach(codes,function(code){var item=localCache[code]||aprimaCache.get(code);item&&item.LexicalCode===code?result.push(item):codesToBeLoaded.push(code)}),_.isEmpty(codesToBeLoaded)?$q.when(result):getData({LexicalCodes:codesToBeLoaded}).then(function(data){return data&&data.Results?(_.forEach(data.Results,function(term){localCache[term.LexicalCode]=term,aprimaCache.put(term.LexicalCode,term),result.push(term)}),result):$q.reject("Could not retrieve all IMO terms")})}}])}(),function(angular){"use strict";window.angular.module("aprima-provider-api").factory("ListService",["_","$q","AprimaAnalytics","AprimaCache","ListRepository","MessageTypes","RequestTypes",function(_,$q,AprimaAnalytics,AprimaCache,ListRepository,MessageTypes,RequestTypes){var defaultCache,medicationsListTypeRegex=/^medications-/i;return{getList:getList,getLists:function(lists,$scope,applicationComponent){var listPromises=(_.isArray(lists)?_.map:_.mapValues)(lists,function(listType,scopeProperty){return getList(listType,$scope,scopeProperty,applicationComponent)}),allPromises=$q.all(listPromises);$scope&&(allPromises=allPromises.then(function(data){return $scope.removeHttpError(RequestTypes.listData),data},function(response){var message={};return message["is"+response.status]=response.listType,$scope.addHttpError(response,message,RequestTypes.listData),$q.reject(response)}));return allPromises}};function getList(listType,$scope,scopeProperty,applicationComponent){var promise,responseListType,queryListType=listType&&listType.name||listType,listParams=listType&&listType.params,timing=AprimaAnalytics.startTiming(applicationComponent||"ListService","api","getList-"+queryListType);return medicationsListTypeRegex.test(queryListType)?queryListType="medications/"+(responseListType=queryListType.replace(medicationsListTypeRegex,"")):responseListType=queryListType.split("/")[0],promise=internalGetList(queryListType,listParams).then(function(list){var plainList=list&&list.plain?list.plain():list;return plainList},function(response){return response.listType=responseListType,$q.reject(response)}),$scope&&scopeProperty&&(promise=promise.then(function(list){return $scope[scopeProperty]=list})),promise.finally(timing.stop)}function internalGetList(listName,listParams){if("appointmentduration"===listName){var durations=[getMinutesDurationObject(10),getMinutesDurationObject(15),getMinutesDurationObject(20),getMinutesDurationObject(30),getMinutesDurationObject(45),getMinutesDurationObject(60),getHoursDurationObject(2),getHoursDurationObject(3),getHoursDurationObject(4),getHoursDurationObject(8)];return $q.when(durations)}if("messagetypessupportedforcreate"===listName)return $q.all([internalGetList("messagetypes",null),internalGetList("messagesubtypes",null)]).then(function(lists){var types,subTypes,supportedTypes=MessageTypes.SupportedMessageTypesForCreate.Types,supportedSubTypes=MessageTypes.SupportedMessageTypesForCreate.SubTypes;return types=_(lists[0]).filter(function(t){return 0<=_.findIndex(supportedTypes,{id:t.Id})}).map(function(t){return{messageTypeId:t.Id,messageSubTypeId:null,name:t.Name,requiredFeature:_.find(supportedTypes,{id:t.Id}).requiredFeature}}).value(),subTypes=_(lists[1]).filter(function(t){return 0<=_.findIndex(supportedSubTypes,{id:t.Id})}).map(function(t){return{messageTypeId:t.MessageTypeId,messageSubTypeId:t.Id,name:t.Name,requiredFeature:_.find(supportedSubTypes,{id:t.Id}).requiredFeature}}).value(),_(_.union(types,subTypes)).sortBy("name").value()});var promise=ListRepository.getListJs(listName,listParams,function(){defaultCache||(defaultCache=AprimaCache.Lists);return defaultCache}());return $q.when(promise)}function getMinutesDurationObject(minutes,prefix,suffix){var opts=_.defaults({minutes:minutes,prefix:prefix,suffix:suffix},{prefix:minutes,suffix:"minutes"});return{Id:minutes,Description:opts.prefix+" "+opts.suffix}}function getHoursDurationObject(hours){return getMinutesDurationObject(60*hours,hours,"hours")}}])}(),angular.module("aprima-provider-api").factory("Locker",["LockManager","$log","_",function(LockManager,$log,_){"use strict";function Locker(objArr,$scope,lockType,objId,objName){if(!objArr||_.isArray(objArr)&&!objArr.length)throw new Error("Lockable object must be defined");if(!lockType)throw new Error("LockType must be defined");var self=this;self.objs=_.isArray(objArr)?objArr:[objArr],self.$scope=$scope,self.lockType=lockType;var obj=self.objs[0];if(self.objId=objId||obj.Id,self.objName=objName,!self.objId)throw new Error("Lockable object ID must be defined or must exist on lockable object");$scope&&($scope.$on("locks.updated",function(event,args){_.forEach(self.objs,function(obj){var currentLock=obj.LockInfo;currentLock&&currentLock.InstanceId===args.oldLock.InstanceId&&(obj.LockInfo=args.newLock)})}),$scope.$on("$destroy",function(){self.unlock()}))}return Locker.prototype={lock:function(){var self=this,objs=self.objs;return LockManager.lock(this.lockType,this.objId).then(function(lock){return _.forEach(objs,function(obj){obj.LockInfo=lock,obj.LockInstanceId=lock.InstanceId}),lock},function(response){$log.info("Unsuccessful in locking "+self.objName+": "+response),_.forEach(objs,function(obj){obj.LockInfo=response.data})})},unlock:function(lockInfo){var self=this,objs=self.objs;if(!(lockInfo=lockInfo||objs[0].LockInfo))throw new Error("Cannot unlock "+self.objName+" with null or undefined LockInfo.");return LockManager.unlock(lockInfo.LockType,lockInfo.ObjectId).then(function(lock){_.forEach(objs,function(obj){obj.LockInfo=lock})},function(response){$log.info("Unsuccessful in unlocking "+self.objName+": "+response),_.forEach(objs,function(obj){obj.LockInfo=response.data})})}},Locker}]),angular.module("aprima-provider-api").factory("LockManager",["LockRepository","$log","_","$rootScope","$interval","$q","CurrentUser",function(LockRepository,$log,_,$rootScope,$interval,$q,CurrentUser){"use strict";var refreshInterval,locks=[];function refreshLocks(){locks&&locks.length&&CurrentUser.isAuthenticated&&_.each(locks,refreshLock)}function refreshLock(lock){LockRepository.lock(lock.LockType,lock.ObjectId,lock.InstanceId).then(function(lockResponse){lockResponse=lockResponse.plain(),_.remove(locks,lock),locks.push(lockResponse),$rootScope.$broadcast("locks.updated",{oldLock:lock,newLock:lockResponse,isLocked:!0})},function(response){$log.error("Error refreshing lock: "),$log.error(response),_.remove(locks,lock),$rootScope.$broadcast("locks.updated",{oldLock:lock,newLock:response.data,isLocked:!1})})}return{lock:function(lockType,objectId){return LockRepository.lock(lockType,objectId).then(function(l){return locks.push(l.plain()),l})},unlock:function(lockType,objectId){var currentLock=function(lockType,objectId){return _.find(locks,{LockType:lockType,ObjectId:objectId})}(lockType,objectId);return currentLock?LockRepository.unlock(currentLock.LockType,currentLock.ObjectId,currentLock.InstanceId).then(function(){_.remove(locks,function(l){return l.LockType.toLowerCase()===currentLock.LockType.toLowerCase()&&l.ObjectId.toLowerCase()===currentLock.ObjectId.toLowerCase()&&l.InstanceId.toLowerCase()===currentLock.InstanceId.toLowerCase()})},function(response){$log.error("Error unlocking lock id= "+objectId),$log.error(response)}):$q.reject(new Error("Lock was not found in local cache"))},isLocked:function(lockType,objectId,instanceId){return LockRepository.isLocked(lockType,objectId,instanceId)},getLocks:function(){return _.cloneDeep(locks)},refreshLocks:refreshLocks,startRefreshingLocks:function(){refreshInterval=$interval(refreshLocks,3e4)},stopRefreshingLocks:function(){$interval.cancel(refreshInterval)}}}]),angular.module("aprima-provider-api").factory("LockRepository",["AprimaRestangular","ServerInfoRepository","CurrentUser","$q","_",function(AprimaRestangular,ServerInfoRepository,CurrentUser,$q,_){"use strict";var unsupportedLockTypePromise=$q.reject(new Error("Lock Type is not supported by older server"));function getRestangularizedLock(lockObjId){return AprimaRestangular.get().one("locks",lockObjId)}function getQueryStringObj(instanceId){var qs={};return instanceId&&(qs.instanceId=instanceId),qs}function isNewLockingSupported(){return ServerInfoRepository.isFeatureSupported("LockManagement")}function isLockTypeSupported(lockType){return isNewLockingSupported()||_.startsWith(lockType.toLowerCase(),"message")}return{lock:function(lockType,lockObjId,instanceId){return isNewLockingSupported()?getRestangularizedLock(lockObjId).customPUT({},lockType,getQueryStringObj(instanceId)):isLockTypeSupported(lockType)?AprimaRestangular.get().all("message/"+lockObjId).customPUT({ObjectId:lockObjId,LockType:lockType,InstanceId:instanceId||CurrentUser.deviceId},"lock").then(function(m){return m.LockType=m.LockType||"Message",m}):unsupportedLockTypePromise},unlock:function(lockType,lockObjId,instanceId){return isNewLockingSupported()?getRestangularizedLock(lockObjId).customDELETE(lockType,getQueryStringObj(instanceId)):isLockTypeSupported(lockType)?AprimaRestangular.get().all("message/"+lockObjId).customDELETE("lock"):unsupportedLockTypePromise},isLocked:function(lockType,lockObjId,instanceId){return isNewLockingSupported()?getRestangularizedLock(lockObjId).one(lockType).get(getQueryStringObj(instanceId)):isLockTypeSupported(lockType)?$q.reject(new Error("Cannot determine whether a resource is locked using an older server.")):unsupportedLockTypePromise}}}]),angular.module("aprima-provider-api").factory("MessageLocker",["Locker",function(Locker){"use strict";function MessageLocker(message,$scope,lockType,messageId){Locker.call(this,message,$scope,lockType||"Message",messageId,"Message")}return(MessageLocker.prototype=Object.create(Locker.prototype,{})).constructor=MessageLocker}]),angular.module("aprima-provider-api").factory("VisitLocker",["Locker",function(Locker){"use strict";function VisitLocker(visit,$scope,lockType,visitId){Locker.call(this,visit,$scope,lockType||"VisitNote",visitId,"Visit")}return(VisitLocker.prototype=Object.create(Locker.prototype,{})).constructor=VisitLocker}]),angular.module("aprima-provider-api").factory("MessageRepository",["AprimaRestangular","CurrentUser","$q","Bridge","MetadataRepository","AprimaAnalytics",function(Restangular,CurrentUser,$q,Bridge,MetadataRepository,AprimaAnalytics){"use strict";var messageListeners=[];function getAll(messageFilterId,restangularOptions,appComponent){restangularOptions=restangularOptions||{ignoreCache:!1};var timing=AprimaAnalytics.startTiming(appComponent||"MessageRepository","api","getMessages");return Restangular.get(restangularOptions).all("users/"+CurrentUser.get().userId+"/messages").getList({filterId:messageFilterId}).finally(timing.stop)}function emitUpdateMessage(){if(messageListeners)for(var i=messageListeners.length-1;0<=i;i--)messageListeners[i]()}return{getAll:getAll,getDashboardMessages:function(messageFilterId){return messageFilterId?getAll(messageFilterId):$q.when([])},getMessage:function(messageId,appComponent){var timing=AprimaAnalytics.startTiming(appComponent||"MessageRepository","api","getMessage");return Restangular.get().one("messages/"+messageId).get().then(function(m){return Bridge.updateBadges(),m}).finally(timing.stop)},savePhoneMessage:function(message,appComponent){var timing=AprimaAnalytics.startTiming(appComponent||"MessageRepository","api","savePhoneMessage");return Restangular.get().one("messages").customPUT(message,"phone/"+message.Id,{},{}).then(function(data){return emitUpdateMessage(),data}).finally(timing.stop)},saveTaskMessage:function(message,appComponent){var timing=AprimaAnalytics.startTiming(appComponent||"MessageRepository","api","saveTaskMessage");return Restangular.get().one("messages").customPUT(message,"task/"+message.Id,{},{}).then(function(data){return emitUpdateMessage(),data}).finally(timing.stop)},savePortalMessage:function(message,appComponent){var timing=AprimaAnalytics.startTiming(appComponent||"MessageRepository","api","saveTaskMessage");return Restangular.get().one("messages").customPUT(message,"portal/"+message.Id,{},{}).then(function(data){return emitUpdateMessage(),data}).finally(timing.stop)},replyToPortalMessage:function(message,appComponent){var timing=AprimaAnalytics.startTiming(appComponent||"MessageRepository","api","replyToPortalMessage");return Restangular.get().one("messages").customPUT(message,"portal/"+message.Id+"/reply",{},{}).then(function(data){return emitUpdateMessage(),data}).finally(timing.stop)},getPhoneMessageDetails:function(messageId,appComponent){var timing=AprimaAnalytics.startTiming(appComponent||"MessageRepository","api","getPhoneMessage");return Restangular.get().one("messages/phone/"+messageId).get().then(function(m){return Bridge.updateBadges(),m}).finally(timing.stop)},getTaskMessageDetails:function(messageId,appComponent){var timing=AprimaAnalytics.startTiming(appComponent||"MessageRepository","api","getTaskMessage");return Restangular.get().one("messages/task/"+messageId).get().then(function(m){return Bridge.updateBadges(),m}).finally(timing.stop)},getPortalMessageDetails:function(messageId,appComponent){var timing=AprimaAnalytics.startTiming(appComponent||"MessageRepository","api","getPortalMessage");return Restangular.get().one("messages/portal/"+messageId).get().then(function(m){return Bridge.updateBadges(),emitUpdateMessage(),m}).finally(timing.stop)},createTaskMessage:function(message){var timing=AprimaAnalytics.startTiming("MessageRepository","api","createTaskMessage");return Restangular.get().all("messages/task/").post(message).finally(timing.stop)},getTaskMessageMetadata:function($scope){var timing=AprimaAnalytics.startTiming("MessageRepository","api","getCreateTaskMessageMetadata");return MetadataRepository.getMetadata("createtaskmessage",$scope).finally(timing.stop)},createPhoneMessage:function(message){var timing=AprimaAnalytics.startTiming("MessageRepository","api","createPhoneMessage");return Restangular.get().all("messages/phone/").post(message).finally(timing.stop)},getPhoneMessageMetadata:function($scope){var timing=AprimaAnalytics.startTiming("MessageRepository","api","getPortalMessageMetadata");return MetadataRepository.getMetadata("createphonemessage",$scope).finally(timing.stop)},addListener:function(callback){messageListeners&&callback&&messageListeners.indexOf(callback)<0&&messageListeners.push(callback)},removeListener:function(callback){messageListeners&&callback&&0<=messageListeners.indexOf(callback)&&messageListeners.pop(callback)},createPortalMessage:function(message){var timing=AprimaAnalytics.startTiming("MessageRepository","api","createPortalMessage");return Restangular.get().all("messages/portal/").post(message).finally(timing.stop)},getPortalMessageMetadata:function($scope){var timing=AprimaAnalytics.startTiming("MessageRepository","api","getCreatePortalMessageMetadata");return MetadataRepository.getMetadata("createportalmessage",$scope).finally(timing.stop)},getAttachmentApprovalMessage:function(messageId,appComponent){var timing=AprimaAnalytics.startTiming(appComponent||"MessageRepository","api","getAAMessage");return Restangular.get().one("messages/aamessage",messageId).get().then(function(m){return Bridge.updateBadges(),m}).finally(timing.stop)},saveAttachmentApprovalMessage:function(command,appComponent){var timing=AprimaAnalytics.startTiming(appComponent||"MessageRepository","api","saveAAMessage");return Restangular.get().one("messages").customPUT(command,"aamessage/"+command.Id,{},{}).then(function(data){return emitUpdateMessage(),data}).finally(timing.stop)},getServiceOrderApprovalMessage:function(messageId,appComponent){var timing=AprimaAnalytics.startTiming(appComponent||"MessageRepository","api","getServiceOrderApprovalMessage");return Restangular.get().one("messages/serviceorderapprovalmessage",messageId).get().then(function(data){return Bridge.updateBadges(),data}).finally(timing.stop)},saveServiceOrderApprovalMessage:function(message,appComponent){var timing=AprimaAnalytics.startTiming(appComponent||"MessageRepository","api","saveServiceOrderApprovalMessage");return Restangular.get().one("messages").customPUT(message,"serviceorderapprovalmessage/"+message.Id,{},{}).then(function(data){return emitUpdateMessage(),data}).finally(timing.stop)},getRxRefillMessage:function(messageId,appComponent){var timing=AprimaAnalytics.startTiming(appComponent||"MessageRepository","api","getRxRefillMessage");return Restangular.get().one("messages/rx-refill/"+messageId).get().then(function(m){return Bridge.updateBadges(),emitUpdateMessage(),m}).finally(timing.stop)},saveRxRefillMessage:function(message,appComponent){var timing=AprimaAnalytics.startTiming(appComponent||"MessageRepository","api","saveRxRefillMessage");return Restangular.get().one("messages").customPUT(message,"rx-refill/"+message.Id,{},{}).then(function(data){return emitUpdateMessage(),data}).finally(timing.stop)},getRxRefillMessageV2:function(messageId,appComponent){var timing=AprimaAnalytics.startTiming(appComponent||"MessageRepository","api","getRxRefillMessageV2");return Restangular.get().one("messages/rx-refill-v2/"+messageId).get().then(function(m){return Bridge.updateBadges(),emitUpdateMessage(),m}).finally(timing.stop)},saveRxRefillMessageV2:function(message,appComponent){var timing=AprimaAnalytics.startTiming(appComponent||"MessageRepository","api","saveRxRefillMessageV2");return Restangular.get().one("messages").customPUT(message,"rx-refill-v2",{},{}).then(function(data){return emitUpdateMessage(),data}).finally(timing.stop)},getPharmacyRefillMessage:function(messageId,appComponent){var timing=AprimaAnalytics.startTiming(appComponent||"MessageRepository","api","getPharmacyRefillMessage");return Restangular.get().one("messages/pharmacy-refill/"+messageId).get().then(function(m){return Bridge.updateBadges(),emitUpdateMessage(),(request=(msg=m)&&msg.RefillRequest)&&(request.hasOwnProperty("PrescribedMedication")||(request.PrescribedMedication={Comment:request.MedicationComment,Date:request.MedicationDate,Duration:request.MedicationDate,Name:request.MedicationName,ProductCode:request.MedicationNdc,ProductCodeDescription:request.MedicationNdc?request.MedicationNdc+" (NDC)":null,PotencyUnitCode:request.MedicationPotencyUnitCode,Quantity:request.MedicationQuantity,QuantityQualifierTerm:request.MedicationQuantityQualifier,Sig:request.MedicationSig,Strength:request.MedicationStrength,StrengthUnits:request.MedicationStrengthUnits})),m=msg;var msg,request}).finally(timing.stop)},savePharmacyRefillMessage:function(message,appComponent){var timing=AprimaAnalytics.startTiming(appComponent||"MessageRepository","api","savePharmacyRefillMessage");return Restangular.get().one("messages").customPUT(message,"pharmacy-refill/"+message.Id,{},{}).then(function(data){return emitUpdateMessage(),data}).finally(timing.stop)},getPharmacyRefillMessageMetadata:function($scope){var timing=AprimaAnalytics.startTiming("MessageRepository","api","getPharmacyRefillMessageMetadata");return MetadataRepository.getMetadata("pharmacyrefillmessage",$scope).finally(timing.stop)},getPatientPortalMessageRoutingType:function(){var timing=AprimaAnalytics.startTiming("MessageRepository","api","getPatientPortalMessageRoutingType");return Restangular.get().one("messages/patientportal/routingtype").get().finally(timing.stop)}}}]),function(angular){"use strict";window.angular.module("aprima-provider-api").factory("MetadataRepository",["$filter","$q","AprimaRestangular","LocalStorageRepository","moment",function($filter,$q,aprimaRestangular,LocalStorageRepository,moment){return{getMetadata:function(typeName,$scope){return function(typeName){var metadata=LocalStorageRepository.getKey(getKey(typeName),"metadata"),deferred=$q.defer();metadata?deferred.resolve(metadata):deferred.reject("Metadata was not in storage");return deferred.promise}(typeName).catch(function(){return function(typeName){return aprimaRestangular.get().one("metadata/"+typeName).get()}(typeName).then(function(metadata){return parseRawMetadata(metadata)})}).then(function(metadata){return LocalStorageRepository.setKey(getKey(typeName),metadata,"metadata"),metadata}).then(function(metadata){return $scope&&($scope.metadata=metadata),metadata})},parseRawMetadata:parseRawMetadata};function getKey(typeName){return"metadata."+typeName}function parseRawMetadata(rawMetadata){return rawMetadata.Fields=function metadataParser(metadata){var fields={};_.forEach(metadata.Fields,function(field){for(var propertyName,dots=field.FieldName.split("."),obj=fields;1<dots.length;)propertyName=dots.shift(),fields[propertyName]||(fields[propertyName]={}),obj=fields[propertyName];propertyName=dots.shift(),(obj[propertyName]=field).ElementMetadata&&(field.Fields=metadataParser(field.ElementMetadata),delete field.ElementMetadata),(0<=field.FieldName.indexOf("Date")||0<=field.FieldName.indexOf("date"))&&(field.Minimum&&(field.Minimum=moment(field.Minimum).toDate()),field.Maximum&&(field.Maximum=moment(field.Maximum).toDate()))});return fields}(rawMetadata),rawMetadata}}])}(),angular.module("aprima-provider-api").factory("MetadataService",[function(){"use strict";return{getObjectFromMetadata:function(metadata,attrs){if(metadata){var stack=attrs.ngModel.split("."),obj=metadata.Fields;return stack.shift(),(obj=stack.reduce(function(obj,prop){return obj&&obj.hasOwnProperty(prop)?obj[prop]:obj},obj))||!1}},convertNgModelExprToMetadataExpr:function(ngModelExpr){if(ngModelExpr){var stack=ngModelExpr.split(".");return 2===stack.length?"metadata.Fields."+stack[1]:null}}}}]),angular.module("aprima-provider-api").factory("NoteRepository",["AprimaRestangular",function(aprimaRestangular){"use strict";return{getNotes:function(filterId){return aprimaRestangular.get().all("notes/"+filterId).getList()}}}]),function(angular){"use strict";angular.module("aprima-provider-api").factory("ChargeCaptureRepository",["$q","AprimaRestangular","MetadataRepository","ServerInfoRepository",function($q,AprimaRestangular,MetadataRepository,ServerInfoRepository){return{getProviderChargeCaptures:function(providerUid){return ServerInfoRepository.isFeatureSupported("ChargeCaptureDesktopTile")?AprimaRestangular.get().one("chargecaptures/provider",providerUid).get():$q.when([])},getChargeCapture:function(patientUid,chargeCaptureUid){return ServerInfoRepository.isFeatureSupported("ChargeCaptureDesktopTile")?AprimaRestangular.get().one("chargecapture/patient",patientUid).customGET("chargecaptureid",{chargeCaptureId:chargeCaptureUid}):AprimaRestangular.get().one("chargecapture",patientUid).get()},getChargeCaptureMetadata:function($scope){return MetadataRepository.getMetadata("createchargecapture",$scope)},createChargeCapture:function(command){return AprimaRestangular.get().all("chargecapture").post(command)},editChargeCapture:function(patientUid,command){return AprimaRestangular.get().one("chargecapture").customPUT(command)},removeChargeCapture:function(chargeCaptureUid){return ServerInfoRepository.isFeatureSupported("ChargeCaptureDesktopTile")?AprimaRestangular.get().one("chargecapture/remove",chargeCaptureUid).get():$q.reject("Removing a eMDs Round is not supported with this server version.")}}}])}(window.angular),angular.module("aprima-provider-api").factory("DiagnosisSummaryRepository",["AprimaRestangular","AprimaAnalytics","ServerInfoRepository",function(AprimaRestangular,AprimaAnalytics,ServerInfoRepository){"use strict";return{getDiagnosisSummaries:function(patientId,restangularOptions){{if(ServerInfoRepository.isFeatureSupported("DiagnosisSummary")){restangularOptions=restangularOptions||{ignoreCache:!1};var timing=AprimaAnalytics.startTiming("DiagnosisSummaryRepository","api","get diagnosis summaries"),restangular=AprimaRestangular.get(restangularOptions);return restangular.one("patients/"+patientId+"/diagnosis-summaries/").get().finally(timing.stop)}throw new Error("Unsupported feature of getting Diagnosis Summaries")}},getDiagnosisSummary:function(patientId,summaryId,restangularOptions){{if(ServerInfoRepository.isFeatureSupported("DiagnosisSummary")){restangularOptions=restangularOptions||{ignoreCache:!1};var timing=AprimaAnalytics.startTiming("DiagnosisSummaryRepository","api","get diagnosis summary"),restangular=AprimaRestangular.get(restangularOptions);return restangular.one("patients/"+patientId+"/diagnosis-summaries/"+summaryId).get().finally(timing.stop)}throw new Error("Unsupported feature of getting Diagnosis Summary")}}}}]),angular.module("aprima-provider-api").factory("PatientAttachmentRepository",["AprimaRestangular","AprimaAnalytics","DeviceSettings","MetadataRepository","SingleAccessSet",function(AprimaRestangular,AprimaAnalytics,DeviceSettings,MetadataRepository,SingleAccessSet){"use strict";var modifiedPatientIds=new SingleAccessSet,defaultIgnoreCache=DeviceSettings.isPrm;return{getPatientAttachments:function(patientId,restangularOptions,applicationComponent){var timing=AprimaAnalytics.startTiming(applicationComponent||"PatientAttachmentRepository","api","getPatientAttachments");return(restangularOptions=restangularOptions||{ignoreCache:defaultIgnoreCache}).ignoreCache=modifiedPatientIds.contains(patientId)||restangularOptions.ignoreCache,AprimaRestangular.get(restangularOptions).one("patients",patientId).one("attachments").get().finally(timing.stop)},getPatientAttachmentGroup:function(patientId,relAttachmentGroupId,restangularOptions,applicationComponent){var timing=AprimaAnalytics.startTiming(applicationComponent||"PatientAttachmentRepository","api","getPatientAttachmentGroup");return restangularOptions=restangularOptions||{ignoreCache:defaultIgnoreCache},AprimaRestangular.get(restangularOptions).one("patients",patientId).one("attachments",relAttachmentGroupId).get().finally(timing.stop)},addPatientAttachment:function(patientId,patientAttachment,applicationComponent){var timing=AprimaAnalytics.startTiming(applicationComponent||"PatientAttachmentRepository","api","addPatientAttachment");return AprimaRestangular.get().one("patients",patientId).one("attachments").customPOST(patientAttachment).finally(timing.stop).finally(function(){modifiedPatientIds.add(patientId)})},getAddPatientAttachmentMetadata:function($scope){return MetadataRepository.getMetadata("addpatientattachment",$scope)}}}]),angular.module("aprima-provider-api").factory("PatientRecallsRepository",["AprimaRestangular","AprimaAnalytics",function(AprimaRestangular,AprimaAnalytics){"use strict";return{getRecalls:function(id){var timing=AprimaAnalytics.startTiming("PatientRecallsRepository","api","get recalls");return AprimaRestangular.get().one("patients",id).getList("recalls").finally(timing.stop)}}}]),function(angular){"use strict";window.angular.module("aprima-provider-api").factory("PatientRepository",["$rootScope","AprimaAnalytics","AprimaRestangular","DeviceSettings","LocalStorageRepository","MetadataRepository","SingleAccessSet",function($rootScope,AprimaAnalytics,AprimaRestangular,DeviceSettings,LocalStorageRepository,MetadataRepository,SingleAccessSet){var visitCacheSet=new SingleAccessSet,medicationsCacheSet=new SingleAccessSet,defaultIgnoreCache=DeviceSettings.isPrm;return $rootScope.$on("visit-updated",function(event,opts){visitCacheSet.add(opts.patientId),medicationsCacheSet.add(opts.patientId)}),{getPatient:function(uid,restangularOptions,applicationComponent){_.isString(restangularOptions)&&!applicationComponent&&(applicationComponent=restangularOptions,restangularOptions=null),restangularOptions=restangularOptions||{ignoreCache:defaultIgnoreCache};var timing=AprimaAnalytics.startTiming(applicationComponent||"PatientRepository","api","getPatient");return AprimaRestangular.get(restangularOptions).one("patients",uid).get().finally(timing.stop)},getDemographics:function(uid,restangularOptions){restangularOptions=restangularOptions||{ignoreCache:defaultIgnoreCache};var timing=AprimaAnalytics.startTiming("PatientRepository","api","get patient demographics");return AprimaRestangular.get(restangularOptions).one("patients/"+uid+"/demographics").get().finally(timing.stop)},geteRxEligibilities:function(uid,restangularOptions){restangularOptions=restangularOptions||{ignoreCache:defaultIgnoreCache};var timing=AprimaAnalytics.startTiming("PatientRepository","api","get patient eRxEligibilities");return AprimaRestangular.get(restangularOptions).one("patients/"+uid+"/erxeligibilities").get().finally(timing.stop)},getAllergies:function(uid,restangularOptions){restangularOptions=restangularOptions||{ignoreCache:defaultIgnoreCache};var timing=AprimaAnalytics.startTiming("PatientRepository","api","get patient allergies");return AprimaRestangular.get(restangularOptions).one("patients/"+uid+"/allergies").get().finally(timing.stop)},getAppointments:function(uid,restangularOptions){restangularOptions=restangularOptions||{ignoreCache:defaultIgnoreCache};var timing=AprimaAnalytics.startTiming("PatientRepository","api","get patient appointments");return AprimaRestangular.get(restangularOptions).one("patients/"+uid+"/appointments").get().finally(timing.stop)},getPrimaryInsurance:function(uid,restangularOptions){restangularOptions=restangularOptions||{ignoreCache:defaultIgnoreCache};var timing=AprimaAnalytics.startTiming("PatientRepository","api","get patient primary insurance");return AprimaRestangular.get(restangularOptions).one("patients/"+uid+"/primary-insurance").get().finally(timing.stop)},getProblems:function(uid,restangularOptions){return internalGetProblems(uid,!0,restangularOptions)},getActiveProblems:function(uid,restangularOptions){return internalGetProblems(uid,!1,restangularOptions)},getMedications:getMedications,getRemarks:function(uid,restangularOptions){restangularOptions=restangularOptions||{ignoreCache:defaultIgnoreCache};var timing=AprimaAnalytics.startTiming("PatientRepository","api","get patient remarks");return AprimaRestangular.get(restangularOptions).one("patients/"+uid+"/remarks").get().finally(timing.stop)},getRecentVisits:function(uid,restangularOptions){restangularOptions=restangularOptions||{ignoreCache:defaultIgnoreCache||visitCacheSet.contains(uid)};var timing=AprimaAnalytics.startTiming("PatientRepository","api","get patient visits");return AprimaRestangular.get(restangularOptions).one("patients/"+uid+"/recentvisits").get().finally(timing.stop)},getOrders:function(uid,restangularOptions){restangularOptions=restangularOptions||{ignoreCache:defaultIgnoreCache};var timing=AprimaAnalytics.startTiming("PatientRepository","api","get patient orders");return AprimaRestangular.get(restangularOptions).one("patients/"+uid+"/orders").getList().finally(timing.stop)},getObservationResults:function(uid,filter,restangularOptions){restangularOptions=restangularOptions||{ignoreCache:defaultIgnoreCache};var timing=AprimaAnalytics.startTiming("PatientRepository","api","get patient observation results"),restangular=AprimaRestangular.get(restangularOptions),params={dataFilter:filter};return restangular.one("patients",uid).customGET("observationresults",params).finally(timing.stop)},getVitals:function(uid,vitalsDefaultSettingId,restangularOptions){restangularOptions=restangularOptions||{ignoreCache:defaultIgnoreCache};var timing=AprimaAnalytics.startTiming("PatientRepository","api","get patient vitals"),obsDefaultSettingId=vitalsDefaultSettingId||LocalStorageRepository.getPatientVitalsDefaultSettingId()||"";return AprimaRestangular.get(restangularOptions).one("patients",uid).customGET("vitals",{observationDefaultSettingId:obsDefaultSettingId}).finally(timing.stop)},getObservations:function(uid,filter,restangularOptions){restangularOptions=restangularOptions||{ignoreCache:defaultIgnoreCache};var timing=AprimaAnalytics.startTiming("PatientRepository","api","get patient observations");return AprimaRestangular.get(restangularOptions).one("patients",uid).customGET("observations",{dataFilter:filter}).finally(timing.stop)},getHealthMaintenanceReminders:function(uid,restangularOptions){restangularOptions=restangularOptions||{ignoreCache:defaultIgnoreCache};var timing=AprimaAnalytics.startTiming("PatientRepository","api","get patient health maintenance reminders");return AprimaRestangular.get(restangularOptions).one("patients/"+uid+"/healthmaintenancereminders").get().finally(timing.stop)},getObservationValues:function(patientId,observationOrderId,restangularOptions){restangularOptions=restangularOptions||{ignoreCache:defaultIgnoreCache};var timing=AprimaAnalytics.startTiming("PatientRepository","api","get patient observation values");return AprimaRestangular.get(restangularOptions).one("patients",patientId).one("observationresults",observationOrderId).get().finally(timing.stop)},createPatient:function(patient){var timing=AprimaAnalytics.startTiming("PatientRepository","api","createPatient");return AprimaRestangular.get().all("patients/").post(patient).finally(timing.stop)},getCreatePatientMetadata:function($scope){var timing=AprimaAnalytics.startTiming("PatientRepository","api","getCreatePatientMetadata");return MetadataRepository.getMetadata("patientcreation",$scope).finally(timing.stop)},getMostRecentObservationValues:function(uid,filter,restangularOptions){restangularOptions=restangularOptions||{ignoreCache:defaultIgnoreCache};var timing=AprimaAnalytics.startTiming("PatientRepository","api","get most recent patient observation values"),restangular=AprimaRestangular.get(restangularOptions),params={dataFilter:filter};return restangular.one("patients",uid).customGET("most-recent-observation-values",params).finally(timing.stop)},updatePatientPhoto:function(patientId,patientPhoto,applicationComponent){var timing=AprimaAnalytics.startTiming(applicationComponent||"PatientRepository","api","updatePatientPhoto");return AprimaRestangular.get().one("patients",patientId).one("photo").customPUT(patientPhoto).finally(timing.stop)},getPharmacies:function(uid,restangularOptions){restangularOptions=restangularOptions||{ignoreCache:defaultIgnoreCache};var timing=AprimaAnalytics.startTiming("PatientRepository","api","get patient pharmacies");return AprimaRestangular.get(restangularOptions).one("patients/"+uid+"/pharmacies").get().finally(timing.stop)},getEmVisits:function(uid,restangularOptions){restangularOptions=restangularOptions||{ignoreCache:defaultIgnoreCache};var timing=AprimaAnalytics.startTiming("PatientRepository","api","getEmVisits");return AprimaRestangular.get().one("patients/",uid).all("em-visits").getList().finally(timing.stop)},getMedicationsByGroup:function(uid,restangularOptions){return getMedications(uid,restangularOptions).then(function(medications){for(var group,result={medications:medications,medicationsExist:!1},drugClasses=[],groupValue="seed_value",i=0;i<medications.length;i++){var medication=medications[i];groupValue!==medication.DrugClassName&&(void 0!==group&&drugClasses.push(group),group={label:medication.DrugClassName,active:!1,medications:[]},groupValue=group.label),group.medications.push(medication),medication.IsActive&&(group.active=!0,result.medicationsExist=!0)}return group&&drugClasses.push(group),result.drugClasses=drugClasses,result})},getPatientDetails:function(uid,restangularOptions){restangularOptions=restangularOptions||{ignoreCache:defaultIgnoreCache};var timing=AprimaAnalytics.startTiming("PatientRepository","api","getPatientDetails");return AprimaRestangular.get(restangularOptions).one("patients/"+uid+"/details").get().finally(timing.stop)},getAccounts:function(patientId){var timing=AprimaAnalytics.startTiming("PatientRepository","api","getAccounts");return AprimaRestangular.get().one("patients",patientId).getList("accounts").finally(timing.stop)},getPatientCases:function(patientId){var timing=AprimaAnalytics.startTiming("PatientRepository","api","getPatientCases");return AprimaRestangular.get().one("patients",patientId).getList("patientcases").finally(timing.stop)},getPatientInformation:function(patientUid,appointmentUid,visitUid,accountUid,restangularOptions){restangularOptions=restangularOptions||{ignoreCache:defaultIgnoreCache};var timing=AprimaAnalytics.startTiming("PatientRepository","api","getPatientInformation");return AprimaRestangular.get(restangularOptions).one("patientInformation/"+patientUid+"/"+appointmentUid+"/"+visitUid+"/"+accountUid).get().finally(timing.stop)},deletePatientPharmacy:function(patientPharmacyUid){var timing=AprimaAnalytics.startTiming("PatientRepository","api","DeletePatientPharamciesById");return AprimaRestangular.get().one("patients/pharmacy/"+patientPharmacyUid).remove().finally(timing.stop)},setPharmacyOrder:function(list,patientId){var timing=AprimaAnalytics.startTiming("PatientRepository","api","SetPatientPharmacySortOrder");return AprimaRestangular.get().all("patients/"+patientId+"/pharmacy/order").post(list).finally(timing.stop)}};function internalGetProblems(uid,includeInactive,restangularOptions){restangularOptions=restangularOptions||{ignoreCache:defaultIgnoreCache};var timing=AprimaAnalytics.startTiming("PatientRepository","api","get patient problems"),restangular=AprimaRestangular.get(restangularOptions);return restangular.one("patients",uid).getList("problems",{activeOnly:!includeInactive}).finally(timing.stop)}function getMedications(uid,restangularOptions){restangularOptions=restangularOptions||{ignoreCache:defaultIgnoreCache||medicationsCacheSet.contains(uid)};var timing=AprimaAnalytics.startTiming("PatientRepository","api","get patient medications"),restangular=AprimaRestangular.get(restangularOptions);return restangular.one("patients/"+uid+"/medications").get().finally(timing.stop)}}])}(),angular.module("aprima-provider-api").factory("VisitRepository",["AprimaRestangular","AprimaAnalytics","$rootScope",function(AprimaRestangular,AprimaAnalytics,$rootScope){"use strict";return{getVisit:function(patientId,visitId){var timing=AprimaAnalytics.startTiming("VisitRepository","api","get visit info");return AprimaRestangular.get().one("patients/"+patientId+"/visits/"+visitId).get().finally(timing.stop)},getVisitDetail:function(visitId){var timing=AprimaAnalytics.startTiming("VisitRepository","api","get visit detail");return AprimaRestangular.get().one("visits/"+visitId).get().finally(timing.stop)},getVisitDocument:function(patientId,visitId){var timing=AprimaAnalytics.startTiming("VisitRepository","api","get visit document");return AprimaRestangular.get().one("patients/"+patientId+"/visits/"+visitId+"/document").get().finally(timing.stop)},createVisit:function(visit){var timing=AprimaAnalytics.startTiming("VisitRepository","api","create visit");return AprimaRestangular.get().all("visits").post(visit).finally(timing.stop).finally(function(){$rootScope.$emit("visit-updated",{patientId:visit.Patient.Id})})},getVisitByAppointment:function(appointmentId){var timing=AprimaAnalytics.startTiming("VisitRepository","api","get appointment visit");return AprimaRestangular.get().one("visit-appointment/"+appointmentId).get().finally(timing.stop)},getVisitDocumentForVisitText:function(patientId,visitId){var timing=AprimaAnalytics.startTiming("VisitRepository","api","get visit document for visit text");return AprimaRestangular.get().one("patients/"+patientId+"/visits/"+visitId+"/documentvisittext").get().finally(timing.stop)}}}]),angular.module("aprima-provider-api").factory("PersonRepository",["AprimaAnalytics","AprimaRestangular",function(AprimaAnalytics,AprimaRestangular){"use strict";return{updatePersonPhoto:function(patientId,patientPhoto,applicationComponent){var timing=AprimaAnalytics.startTiming(applicationComponent||"PersonRepository","api","updatePersonPhoto");return AprimaRestangular.get().one("persons",patientId).one("photo").customPUT(patientPhoto).finally(timing.stop)}}}]),angular.module("aprima-provider-api").factory("PharmacyRepository",["AprimaRestangular","MetadataRepository","$q","moment","AprimaAnalytics","AprimaCache",function(AprimaRestangular,MetadataRepository,$q,moment,AprimaAnalytics,AprimaCache){"use strict";var defaultCache;return{getPharmacy:function(id,appComponent){var timing=AprimaAnalytics.startTiming(appComponent||"PharmacyRepository","api","getPharmacy");return AprimaRestangular.get().all("lists/pharmacies").one(id).get().finally(timing.stop)},getPharmacyByMasterPharmacyId:function(id,appComponent){var timing=AprimaAnalytics.startTiming(appComponent||"PharmacyRepository","api","getPharmacyByMasterPharmacyId");return AprimaRestangular.get().all("lists/masterpharmacies").one(id).get().finally(timing.stop)},searchPharmacies:function(searchText,appComponent){var timing=AprimaAnalytics.startTiming(appComponent||"PharmacyRepository","api","getPharmacy");return AprimaRestangular.get().all("lists/pharmacies").withHttpConfig({cache:getDefaultCache()}).getList({query:searchText}).finally(timing.stop)},searchPharmaciesIncludeAllMailOrders:function(searchText,appComponent){var timing=AprimaAnalytics.startTiming(appComponent||"PharmacyRepository","api","getPharmacy");return AprimaRestangular.get().all("lists/pharmacies").withHttpConfig({cache:getDefaultCache()}).getList({query:searchText,includeAllMailOrders:!0}).finally(timing.stop)}};function getDefaultCache(){return defaultCache||(defaultCache=AprimaCache.Default.httpMode),defaultCache}}]),function(){"use strict";angular.module("aprima-provider-api").factory("GatewayService",["$q","GatewayServiceTs",function($q,GatewayServiceTs){return{findClientServer:function(clientId,gatewayPrefix){var promise=GatewayServiceTs.findClientServer(clientId,gatewayPrefix).toPromise();return $q.when(promise)}}}])}(),function(){"use strict";angular.module("aprima-provider-api").factory("LoginInitializationService",["$q","LoginInitializationServiceTs",function($q,LoginInitializationServiceTs){return{initializeFromPrmLogin:function(userLoginInfo){var promise=LoginInitializationServiceTs.initializeFromPrmLogin(userLoginInfo);return $q.when(promise)},initializeFromDesktopLogin:function(vals){var promise=LoginInitializationServiceTs.initializeFromDesktopLogin(vals);return $q.when(promise)},preLogin:function(gatewayUrl,appServerUrl,clientId,username){return LoginInitializationServiceTs.preLogin(gatewayUrl,appServerUrl,clientId,username)},finishPrmLogin:function(){LoginInitializationServiceTs.finishPrmLogin()},updateVersionInfo:function(userLoginInfo){LoginInitializationServiceTs.updateVersionInfo(userLoginInfo)}}}])}(),function(){"use strict";angular.module("aprima-provider-api").factory("PdpmpModalService",["$q","PdpmpModalServiceTs",function($q,PdpmpModalServiceTs){return{openModal:function(config,serviceSiteId,patientId,providerId,visitId,messageId){var promise=PdpmpModalServiceTs.openModal(config,serviceSiteId,patientId,providerId,visitId,messageId).toPromise();return $q.when(promise)},shouldAllowModal:function(config){return PdpmpModalServiceTs.shouldAllowModal(config)}}}])}(),function(){"use strict";angular.module("aprima-provider-api").factory("PdpmpRepository",["$q","PdpmpRepositoryTs",function($q,PdpmpRepositoryTs){return{createReport:function(serviceSiteId,patientId,providerId,visitId,messageId){var promise=PdpmpRepositoryTs.createReport(serviceSiteId,patientId,providerId,visitId,messageId).toPromise();return $q.when(promise)},getConfiguration:function(){var promise=PdpmpRepositoryTs.getConfiguration().toPromise();return $q.when(promise)}}}])}(),function(){"use strict";angular.module("aprima-provider-api").factory("PrmLoginService",["$q","PrmLoginServiceTs",function($q,PrmLoginServiceTs){return{login:function(username,password,userId,clientFeatures){var promise=PrmLoginServiceTs.login(username,password,userId,clientFeatures).toPromise();return $q.when(promise)}}}])}(),function(){"use strict";angular.module("aprima-provider-api").factory("SettingRepository",["$q","SettingRepositoryTs",function($q,SettingRepositoryTs){return{getProviderEpcsSettings:function(userId,siteId){var promise=SettingRepositoryTs.getProviderEpcsSettings(userId,siteId).toPromise();return $q.when(promise)}}}])}(),function(angular){"use strict";window.angular.module("aprima-provider-api").factory("PrmUserRepository",["AprimaAnalytics","AprimaRestangular",function(AprimaAnalytics,AprimaRestangular){return{getUser:function(uid){var timing=AprimaAnalytics.startTiming("PrmUserRepository","api","getUser");return AprimaRestangular.get().all("view-find-user").one(uid).get().finally(timing.stop)},searchUsers:function(inputSearch){inputSearch=inputSearch.replace(/\n|\r/g,"");var timing=AprimaAnalytics.startTiming("PrmUserRepository","api","searchUsers");return AprimaRestangular.get().one("view-find-user/quick-search").get({quicksearch:inputSearch}).finally(timing.stop)}}}])}(),angular.module("aprima-provider-api").factory("ProcedureRepository",["AprimaRestangular",function(aprimaRestangular){"use strict";return{getProcedures:function(searchString){var queryString="?maxRecords=20&procedureText="+searchString;return aprimaRestangular.get().all("procedures/"+queryString).getList()}}}]),function(){"use strict";angular.module("aprima-provider-api").factory("ProviderRepository",["AprimaRestangular","AprimaAnalytics",function(AprimaRestangular,AprimaAnalytics){return{getProviderSupervisorListByProviderId:function(providerId){var timing=AprimaAnalytics.startTiming("ProviderRepository","api","getProviderSupervisorListByProviderId");return AprimaRestangular.get().one("provider/"+providerId+"/supervisors").get().finally(timing.stop)},getProviderById:function(providerId){var timing=AprimaAnalytics.startTiming("ProviderRepository","api","getProvider");return AprimaRestangular.get().one("provider/"+providerId).get().finally(timing.stop)},getSupervisorList:function(){var timing=AprimaAnalytics.startTiming("ProviderRepository","api","getProvider");return AprimaRestangular.get().one("lists/provider").get().finally(timing.stop)},getDefaultSupervisor:function(linkSupervisorDto){var timing=AprimaAnalytics.startTiming("ProviderRepository","api","getDefaultSupervisor");return AprimaRestangular.get().one("provider/default-supervisor").get(linkSupervisorDto).finally(timing.stop)}}}])}(),angular.module("aprima-provider-api").factory("SigWriterRepository",["AprimaRestangular","AprimaAnalytics","MetadataRepository",function(AprimaRestangular,AprimaAnalytics,MetadataRepository){"use strict";return{checkIsSpecialtyId:function(ndc,rxnorm,providerId){var timing=AprimaAnalytics.startTiming("SigWriterRepository","api","checkIsSpecialtyId");return AprimaRestangular.get().one("drugs/specialty/"+ndc+"/"+rxnorm+"/id/"+providerId).get().finally(timing.stop)},getDirectionsSettings:function(drug,providerId,sigType,visitId,checkIsSpecialtyMedication){var restangular=AprimaRestangular.get(),request={Drug:drug,ProviderId:providerId,SigType:sigType,VisitId:visitId,CheckIsSpecialtyMedication:checkIsSpecialtyMedication},timing=AprimaAnalytics.startTiming("SigWriterRepository","api","getDirectionsSettings");return restangular.all("sigwriter/"+providerId+"/directions-settings").post(request).finally(timing.stop)},getDrugCptList:function(medid){var timing=AprimaAnalytics.startTiming("SigWriterRepository","api","getDrugCptList");return AprimaRestangular.get().all("sigwriter/drugcptlist/"+medid).getList().finally(timing.stop())},getDrugSettings:function(sigType,drug,providerId,patientId,visitId,restangularOptions){restangularOptions=restangularOptions||{ignoreCache:!1};var restangular=AprimaRestangular.get(restangularOptions),request={Drug:drug,PatientId:patientId,SigType:sigType,VisitId:visitId},timing=AprimaAnalytics.startTiming("SigWriterRepository","api","getDrugSettings");return restangular.all("sigwriter/"+providerId+"/drug-settings").post(request).finally(timing.stop)},initializeDefaultSig:function(currentRx,providerDefaultSigId,restangularOptions){restangularOptions=restangularOptions||{ignoreCache:!1};var timing=AprimaAnalytics.startTiming("SigWriterRepository","api","initialize default sig"),restangular=AprimaRestangular.get(restangularOptions),params=providerDefaultSigId?"/"+providerDefaultSigId:"";return restangular.all("fnc/rx/initialize-default-sig"+params).post(currentRx).finally(timing.stop)},saveDefaultSig:function(createModifyDefaultSigDto,restangularOptions){restangularOptions=restangularOptions||{ignoreCache:!1};var timing=AprimaAnalytics.startTiming("SigWriterRepository","api","save default sig"),restangular=AprimaRestangular.get(restangularOptions),params=createModifyDefaultSigDto.ProviderDefaultSigId?"/"+createModifyDefaultSigDto.ProviderDefaultSigId:"";return restangular.all("fnc/rx/default-sig"+params).post(createModifyDefaultSigDto).finally(timing.stop)},getDefaultSigMetadata:function($scope){var timing=AprimaAnalytics.startTiming("SigWriterRepository","api","getDefaultSigMetadata");return MetadataRepository.getMetadata("fnc/rx/new-default-sig",$scope).finally(timing.stop)}}}]),function(angular){"use strict";angular.module("aprima-provider-api").factory("LicenseService",["LocalStorageRepository",function(LocalStorageRepository){return{hasFdbDosingLicense:function(){var licenses=LocalStorageRepository.getCurrentUserLicenses();return!licenses||licenses.HasFdbDosing},hasImoDiagnosisLicense:function(){var licenses=LocalStorageRepository.getCurrentUserLicenses();return!licenses||licenses.HasImoDiagnosis}}}])}(angular),angular.module("aprima-provider-api").factory("SettingService",["$q","SettingServiceTs",function($q,SettingServiceTs){"use strict";return{loadSettings:function(){var promise=SettingServiceTs.loadSettings();return $q.when(promise)},updateNativeSettings:function(){SettingServiceTs.updateNativeSettings()},updatePatientDashboardConfiguration:function(dashboardConfiguration){var promise=SettingServiceTs.updatePatientDashboardConfiguration(dashboardConfiguration);return $q.when(promise)},deletePatientDashboardConfiguration:function(dashboardConfiguration){var promise=SettingServiceTs.deletePatientDashboardConfiguration(dashboardConfiguration);return $q.when(promise)},getSigWriterSettings:function(){var promise=SettingServiceTs.getSigWriterSettings().toPromise();return $q.when(promise)},imperialUnitsAllowed:function(){return SettingServiceTs.imperialUnitsAllowed()},getPatientDashboardWidgets:function(){return SettingServiceTs.getPatientDashboardWidgets()},getAppointmentsListSettings:function(){return SettingServiceTs.getAppointmentsListSettings()},setAppointmentsListSettings:function(settings){SettingServiceTs.setAppointmentsListSettings(settings)},getMessagesListSettings:function(){return SettingServiceTs.getMessagesListSettings()},setMessagesListSettings:function(settings){SettingServiceTs.setMessagesListSettings(settings)},getAppointmentsBadgeSettings:function(){return SettingServiceTs.getAppointmentsBadgeSettings()},setAppointmentsBadgeSettings:function(settings){SettingServiceTs.setAppointmentsBadgeSettings(settings)},getDashboardTileSettings:function(){return SettingServiceTs.getDashboardTileSettings()},setDashboardTileSettings:function(settings){SettingServiceTs.setDashboardTileSettings(settings)},getKdbConfigurationId:function(userId,renderingProviderId,billingProviderId){var promise=SettingServiceTs.getKdbConfigurationId(userId,renderingProviderId,billingProviderId);return $q.when(promise)},getKdbConfigurationIdByVisit:function(userId,visitId){var promise=SettingServiceTs.getKdbConfigurationIdByVisit(userId,visitId);return $q.when(promise)},getDrugSearchIncludeInactive:function(providerId){var promise=SettingServiceTs.getDrugSearchIncludeInactive(providerId);return $q.when(promise)}}}]),function(angular){"use strict";window.angular.module("aprima-provider-api").factory("ValidationResult",["ObjUtil",function(ObjUtil){return ValidationResult.mapFromApi=function(resultObj){return resultObj?new ValidationResult(resultObj.HasWarning,resultObj.Message):new ValidationResult},ValidationResult;function ValidationResult(hasWarning,message){ObjUtil.defineReadonlyProps(this,{hasWarning:!!hasWarning,message:message||""})}}])}(),function(angular){"use strict";angular.module("aprima-provider-api").factory("ValidationWarnings",["_","$q","AprimaAnalytics","AprimaCache","AprimaRestangular","ServerInfoRepository","ValidationResult",function(_,$q,AprimaAnalytics,AprimaCache,AprimaRestangular,ServerInfoRepository,ValidationResult){var defaultCache=AprimaCache.Default.httpMode;return{insuranceExclusion:function(providerId,patientId,accountId){return get("insurance-exclusion",{providerId:providerId,patientId:patientId,accountId:accountId},"ProviderInsuranceExclusionWarning",defaultCache)},inOfficeHours:function(calendarId,startDate,endDate){return get("office-hours",{calendarId:calendarId,startDate:startDate,endDate:endDate},"CalendarOfficeHoursWarning",defaultCache)}};function get(route,params,requiredFeature,cache){if(requiredFeature&&!ServerInfoRepository.isFeatureSupported(requiredFeature))return $q.when(new ValidationResult);var timing=AprimaAnalytics.startTiming("ValidationWarnings","api",route);return AprimaRestangular.get().one("warnings",route).withHttpConfig({cache:cache}).get(params).then(function(data){return ValidationResult.mapFromApi(data)}).finally(timing.stop)}}])}(window.angular),angular.module("aprima-provider-api").factory("VersionService",["VersionServiceTs",function(VersionServiceTs){"use strict";return{checkVersions:function(userLoginInfo){return VersionServiceTs.ensureVersions(userLoginInfo).then(function(){return VersionServiceTs.checkVersions(userLoginInfo.SupportedApiVersions,userLoginInfo.MinClientVersion)})}}}]);
//# sourceMappingURL=aprima-provider-api.min.js.map