angular.module("aprima-fnc",["ui.router","restangular","ngTouch","ngAnimate","ui.bootstrap","angularLocalStorage","gettext","lodash","toaster","rt.debounce","hmTouchEvents","mgo-angular-wizard","ngDraggable","ngSanitize","dotjem.angular.tree","aprima-core","aprima-core-ui","aprima-bridge","aprima-config","aprima-legacy-common","aprima-provider-api","aprima-sigwriter","aprima-utils","aprima-imo","aprima-rxcoupon","aprima-patient"]),angular.module("aprima-fnc").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("/fnc/component-views/fncPatientHeader.html",'<div ng-cloak>\r\n    <headroom id="fnc-patient-header" offset="0" tolerance="{up: 100, down: 0}">\r\n        <div id="fnc-patient-header-detail" class="flex-row center-v">\r\n            <div class="overflow-ellipsis">\r\n                <span class="fnc-patient-box patient-status">S</span>\r\n                <span class="fnc-patient-box patient-condition">C</span>\r\n                <span class="fnc-patient-box patient-program">P</span>\r\n                {{::$ctrl.patientDetails.LastName}},&nbsp;{{::$ctrl.patientDetails.FirstName}}\r\n                <span ng-if="$ctrl.patientDetails.BirthDate">| DOB: <ap-date-formatter format="date" date="{{::$ctrl.patientDetails.BirthDate}}"></ap-date-formatter></span>\r\n                <span ng-if="$ctrl.patientDetails.Age"> | {{::$ctrl.patientDetails.Age}}</span>\r\n                <span ng-if="$ctrl.patientDetails.GenderAnsi"> | {{::$ctrl.patientDetails.GenderAnsi}}</span>\r\n                <span ng-if="$ctrl.patientDetails.ExternalId"> | ID: {{::$ctrl.patientDetails.ExternalId}}</span>\r\n                <span ng-if="$ctrl.patientDetails.InsuranceCarrier"> | {{::$ctrl.patientDetails.InsuranceCarrier}}</span>\r\n                <span ng-if="$ctrl.patientDetails.InsurancePlan"> | {{::$ctrl.patientDetails.InsurancePlan}}</span>\r\n                <span ng-if="$ctrl.patientDetails.MedicalRecordNumber"> | MRN: {{::$ctrl.patientDetails.MedicalRecordNumber}}</span>\r\n            </div>\r\n            <span class="ap-aprima-logo flex-pull-right"></span>\r\n        </div>\r\n    </headroom>\r\n\r\n    <div id="fnc-patient-header-placeholder">\r\n    </div>\r\n</div>'),$templateCache.put("/fnc/component-views/fncShell.html",'<fnc-patient-header patient="$ctrl.context.Patient" />\r\n\r\n<wizard name="{{$ctrl.wizardName}}"\r\n        hide-indicators="true"\r\n        on-finish="$ctrl.onFinish()">\r\n\r\n    <div id="{{$ctrl.fncStepsIndicatorContainerId}}" class="steps-indicator-container" ng-if="$ctrl.getShouldShowIndicators()">\r\n        <ul class="steps-indicator steps-{{$ctrl.getWizard().getEnabledSteps().length}}">\r\n            <li ng-class="{default: !step.completed && !step.selected, current: step.selected && !step.completed, done: step.completed && !step.selected, editing: step.selected && step.completed}"\r\n                ng-repeat="step in $ctrl.getWizard().getEnabledSteps()">\r\n\r\n                <a ng-click="$ctrl.goToStep(step)">{{step.wzTitle}}</a>\r\n            </li>\r\n        </ul>\r\n    </div>\r\n    <div class="native-buttons-container row" ng-if="$ctrl.getShouldShowIndicators()">\r\n        <div class="col-xs-12">\r\n            <button id="fnc-pdb-button" ng-click="$ctrl.onPdbClicked()">PDB</button>\r\n            <button id="fnc-visit-info-button" ng-click="$ctrl.onVisitInfoClicked()">Visit Info</button>\r\n            <button id="fnc-previous-button" ng-click="$ctrl.onPreviousClicked()" ng-disabled="$ctrl.selectedTab.IsFirst">Back</button>\r\n            <button id="fnc-next-button" ng-click="$ctrl.onNextClicked()" ng-disabled="$ctrl.selectedTab.IsLast">Next</button>\r\n        </div>\r\n    </div>\r\n    <wz-step ng-repeat="step in $ctrl.steps"\r\n             wz-data="step"\r\n             wz-title="{{step.wzTitle}}">\r\n\r\n        <div id="{{step.id}}" class="panel panel-fnc">\r\n            <div class="panel-body">\r\n                <ng-include src="step.templateUrl" />\r\n            </div>\r\n        </div>\r\n    </wz-step>\r\n</wizard>'),$templateCache.put("/fnc/component-views/fncVisitInfo.html",'<div class="container-fluid container-flush" ng-cloak>\r\n    <div ng-form="visitInfoForm" novalidate>\r\n        <div class="form-section">\r\n            <div class="row">\r\n                <div class="col-xs-12 col-md-6">\r\n                    <div class="form-group">\r\n                        <label class="control-label" translate>Billing Provider</label>\r\n                        <ap-select>\r\n                            <select ng-disabled="!$ctrl.visit"\r\n                                    class="form-control"\r\n                                    id="billingProvider"\r\n                                    name="billingProvider"\r\n                                    ng-model="$ctrl.visit.BillingProvider"\r\n                                    ng-change="$ctrl.changeBillingProvider()"\r\n                                    ng-options="$ctrl.providerName(x) for x in $ctrl.providers track by x.Id"\r\n                                    ap-metadata>\r\n                            </select>\r\n                        </ap-select>\r\n                    </div>\r\n                </div>\r\n\r\n                <div class="col-xs-12 col-md-6">\r\n                    <div class="form-group">\r\n                        <label class="control-label" translate>Rendering Provider</label>\r\n                        <ap-select>\r\n                            <select ng-disabled="!$ctrl.visit"\r\n                                    class="form-control"\r\n                                    id="renderingProvider"\r\n                                    name="renderingProvider"\r\n                                    ng-model="$ctrl.visit.RenderingProvider"\r\n                                    ng-change="$ctrl.changeRenderingProvider()"\r\n                                    ng-options="$ctrl.providerName(x) for x in $ctrl.providers track by x.Id"\r\n                                    ap-metadata>\r\n                            </select>\r\n                        </ap-select>\r\n                    </div>\r\n                </div>\r\n\r\n                <div class="col-xs-12 col-md-6">\r\n                    <div class="form-group">\r\n                        <label class="control-label" translate>Service Site</label>\r\n                        <ap-select>\r\n                            <select ng-disabled="!$ctrl.visit"\r\n                                    class="form-control"\r\n                                    id="serviceSite"\r\n                                    name="serviceSite"\r\n                                    ng-model="$ctrl.visit.ServiceSite"\r\n                                    ng-options="x.Name || x.Description for x in $ctrl.serviceSites track by x.Id"\r\n                                    ap-metadata>\r\n                            </select>\r\n                        </ap-select>\r\n                    </div>\r\n                </div>\r\n\r\n                <div class="col-xs-12 col-md-6">\r\n                    <div class="form-group">\r\n                        <label class="control-label" translate>Supervising Provider</label>\r\n                        <ap-select>\r\n                            <select ng-disabled="!$ctrl.visit"\r\n                                    class="form-control"\r\n                                    id="supervisingProvider"\r\n                                    name="supervisingProvider"\r\n                                    ng-model="$ctrl.visit.SupervisingProvider"\r\n                                    ng-options="$ctrl.providerName(x) for x in $ctrl.providers track by x.Id"\r\n                                    ap-metadata>\r\n                            </select>\r\n                        </ap-select>\r\n                    </div>\r\n                </div>\r\n\r\n                <div class="col-xs-12 col-md-6">\r\n                    <div class="form-group">\r\n                        <label class="control-label" translate>Referring Provider</label>\r\n                        <ap-select>\r\n                            <select ng-disabled="!$ctrl.visit"\r\n                                    class="form-control"\r\n                                    id="referringProvider"\r\n                                    name="referringProvider"\r\n                                    ng-model="$ctrl.visit.ReferringProvider"\r\n                                    ng-options="$ctrl.providerName(x) for x in $ctrl.providers track by x.Id"\r\n                                    ap-metadata>\r\n                            </select>\r\n                        </ap-select>\r\n                    </div>\r\n                </div>\r\n\r\n                <div class="col-xs-12 col-md-6">\r\n                    <div class="form-group">\r\n                        <label class="control-label" translate>Authorization Code</label>\r\n                        <input ng-disabled="!$ctrl.visit"\r\n                               type="text"\r\n                               class="form-control"\r\n                               id="authorizationCode"\r\n                               name="authorizationCode"\r\n                               ng-model="$ctrl.visit.AuthorizationCode"\r\n                               ap-metadata>\r\n                        </input>\r\n                    </div>\r\n                </div>\r\n\r\n                <div class="col-xs-12 col-md-6">\r\n                    <div class="form-group">\r\n                        <label class="control-label" translate>Patient Case</label>\r\n                        <ap-select>\r\n                            <select ng-disabled="!$ctrl.visit"\r\n                                    class="form-control"\r\n                                    id="patientCase"\r\n                                    name="patientCase"\r\n                                    ng-model="$ctrl.visit.PatientCase"\r\n                                    ng-change="$ctrl.changePatientCase()"\r\n                                    ng-options="$ctrl.caseDescription(x) for x in $ctrl.patientCases track by x.Id"\r\n                                    ap-metadata>\r\n                            </select>\r\n                        </ap-select>\r\n                    </div>\r\n                </div>\r\n\r\n                <div class="col-xs-12 col-md-6">\r\n                    <div class="form-group">\r\n                        <label class="control-label" translate>Referring Date</label>\r\n                        <input ng-disabled="!$ctrl.visit"\r\n                               type="date"\r\n                               class="form-control"\r\n                               id="referringDate"\r\n                               name="referringDate"\r\n                               ng-model="$ctrl.visit.ReferringDate"\r\n                               ng-max="$ctrl.visit.VisitDate || $ctrl.today"\r\n                               ng-model-options="{ updateOn: \'blur\', allowInvalid: 1 }"\r\n                               ap-metadata>\r\n                        </input>\r\n                    </div>\r\n                </div>\r\n\r\n                <div class="col-xs-12 col-md-6">\r\n                    <div class="form-group">\r\n                        <label class="control-label" translate>Appointment Date</label>\r\n                        <p class="form-control-static"\r\n                           id="appointmentDate">\r\n                            <ap-date-formatter\r\n                                date="{{$ctrl.visit.Appointment.StartDate}}"\r\n                                format="date">\r\n                            </ap-date-formatter>\r\n                        </p>\r\n                    </div>\r\n                </div>\r\n\r\n                <div class="col-xs-12 col-md-6">\r\n                    <div class="form-group">\r\n                        <label class="control-label" translate>Date of Service</label>\r\n                        <input ng-disabled="!$ctrl.visit"\r\n                               type="date"\r\n                               class="form-control"\r\n                               id="visitDate"\r\n                               name="visitDate"\r\n                               ng-model="$ctrl.visit.VisitDate"\r\n                               ng-model-options="{ updateOn: \'blur\', allowInvalid: 1 }"\r\n                               ap-metadata>\r\n                        </input>\r\n                    </div>\r\n                </div>\r\n\r\n                <div class="col-xs-12 col-md-6">\r\n                    <div class="form-group">\r\n                        <label class="control-label" translate>Account</label>\r\n                        <ap-select>\r\n                            <select ng-disabled="!$ctrl.visit"\r\n                                    class="form-control"\r\n                                    id="account"\r\n                                    name="account"\r\n                                    ng-model="$ctrl.visit.Account"\r\n                                    ng-options="x.Name for x in $ctrl.accounts track by x.Id"\r\n                                    ap-metadata>\r\n                            </select>\r\n                        </ap-select>\r\n                    </div>\r\n                </div>\r\n\r\n                <div class="col-xs-12 col-md-6">\r\n                    <div class="form-group">\r\n                        <label class="control-label" translate>Financial Center</label>\r\n                        <ap-select>\r\n                            <select ng-disabled="!$ctrl.visit"\r\n                                    class="form-control"\r\n                                    id="financialCenter"\r\n                                    name="financialCenter"\r\n                                    ng-model="$ctrl.visit.FinancialCenter"\r\n                                    ng-options="x.Name for x in $ctrl.financialCenters track by x.Id"\r\n                                    ap-metadata>\r\n                            </select>\r\n                        </ap-select>\r\n                    </div>\r\n                </div>\r\n\r\n                <div class="col-xs-12 col-md-6">\r\n                    <div class="form-group">\r\n                        <label class="control-label" translate>Patient Conditions</label>\r\n                        <select ng-disabled="!$ctrl.visit"\r\n                                multiple\r\n                                class="form-control"\r\n                                id="patientConditions"\r\n                                name="patientConditions"\r\n                                ng-model="$ctrl.visit.PatientConditions"\r\n                                ng-options="x.Name for x in $ctrl.conditions track by x.Id"\r\n                                ap-metadata>\r\n                        </select>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n\r\n            <div class="row">\r\n                <div class="col-xs-12 col-md-6">\r\n                    <div class="form-group">\r\n                        <label class="control-label" translate>Historian</label>\r\n                        <ap-select>\r\n                            <select ng-disabled="!$ctrl.visit"\r\n                                    class="form-control"\r\n                                    id="historian"\r\n                                    name="historian"\r\n                                    ng-model="$ctrl.visit.Historian"\r\n                                    ng-options="x.Name for x in $ctrl.historians track by x.Id"\r\n                                    ap-metadata>\r\n                            </select>\r\n                        </ap-select>\r\n                    </div>\r\n                </div>\r\n\r\n                <div class="col-xs-12 col-md-6">\r\n                    <div class="form-group">\r\n                        <label class="control-label" translate>Historian Name</label>\r\n                        <input ng-disabled="!$ctrl.visit"\r\n                               type="text"\r\n                               class="form-control"\r\n                               id="historianName"\r\n                               name="historianName"\r\n                               ng-model="$ctrl.visit.HistorianName"\r\n                               ap-metadata>\r\n                        </input>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n\r\n        <div class="form-section-secondary">\r\n            <div class="row">\r\n                <div class="col-xs-12">\r\n                    <div class="form-group">\r\n                        <label class="control-label" translate>Visit Type</label>\r\n                        <ap-select>\r\n                            <select ng-disabled="!$ctrl.visit || !$ctrl.canChangeVisitType()"\r\n                                    class="form-control"\r\n                                    id="visitType"\r\n                                    name="visitType"\r\n                                    ng-model="$ctrl.visit.VisitType"\r\n                                    ng-options="(x.Name || x.Description) + \' Visit\' disable when !$ctrl.visitTypeAllowed(x) for x in $ctrl.visitTypes track by x.Id"\r\n                                    ng-change="$ctrl.changeVisitType()"\r\n                                    ap-metadata>\r\n                            </select>\r\n                        </ap-select>\r\n                    </div>\r\n                </div>\r\n\r\n                <div class="col-xs-12">\r\n                    <div class="form-group">\r\n                        <label class="control-label" translate>Reason For Type</label>\r\n                        <textarea ng-disabled="!$ctrl.visit || !$ctrl.canChangeReason()"\r\n                                   class="form-control"\r\n                                   id="reasonForVisitType"\r\n                                   name="reasonForVisitType"\r\n                                   ng-model="$ctrl.visit.ReasonForVisitType"\r\n                                   rows="2"\r\n                                   ap-auto-grow\r\n                                   ap-required="metadata.Fields.ReasonForVisitType.IsRequired || $ctrl.visit.VisitType !== $ctrl.standardVisit">\r\n                        </textarea>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>\r\n'),$templateCache.put("/fnc/component-views/fncVisitInfoModal.html",'<div ap-full-modal>\r\n    <form ng-submit="$ctrl.save($ctrl.visit, visitInfoModalForm)" name="visitInfoModalForm" novalidate>\r\n        <div class="modal-header">\r\n            <span class="modal-title">\r\n                {{::\'Visit Information\' | translate}}\r\n                <ap-spinner data-size="1" ng-show="$ctrl.loadingVisit"></ap-spinner>\r\n            </span>\r\n            <button type="button" class="close" ng-click="$ctrl.cancel()">&times;</button>\r\n        </div>\r\n        <div class="modal-body">\r\n            <div class="modal-container">\r\n                <ng-include src="\'/fnc/component-views/fncVisitInfo.html\'" />\r\n            </div>\r\n        </div>\r\n        <div class="modal-footer modal-footer-slim">\r\n            <div class="row">\r\n                <div class="col-xs-6">\r\n                    <button type="submit" class="btn btn-primary">\r\n                        Save\r\n                        <ap-spinner class="ng-hide" ng-show="$ctrl.savingVisit"></ap-spinner>\r\n                    </button>\r\n                </div>\r\n                <div class="col-xs-6">\r\n                    <button type="button" class="btn btn-default" ng-click="$ctrl.cancel()">Cancel</button>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </form>\r\n</div>\r\n'),$templateCache.put("/fnc/component-views/visitCommentTextarea.html",'<tinymce\r\n    hide-toolbar="$ctrl.hideToolbar"\r\n    use-advanced-toolbar="$ctrl.useAdvancedToolbar"\r\n    value="$ctrl.comment"\r\n    value-changed="$ctrl.onSave(updatedValue)"\r\n/>\r\n'),$templateCache.put("/fnc/tabs/dx/component-views/fncDx.html",'<div id="fnc-dx">\r\n    <div class="row">\r\n        <div class="col col-md-1">\r\n            <div class="tinymce-icon pull-right" ng-click="$ctrl.toggleHide()"></div>\r\n        </div>\r\n\r\n        <div class="col col-md-10">\r\n                <div ng-if="$ctrl.loadCommentError">\r\n                        <uib-alert type="danger">\r\n                            {{::"An error has occurred and the DX Comment could not be loaded." | translate}}\r\n                        </uib-alert>\r\n                </div>\r\n            <div ng-if="$ctrl.loadingComment">\r\n                    <div class="spinner-container text-center">\r\n                        <ap-spinner size="3"></ap-spinner>\r\n                    </div>\r\n            </div>\r\n            <div ng-if="!$ctrl.loadingComment && !$ctrl.loadCommentError">\r\n                <span ng-if="$ctrl.hideContainer" ng-bind-html="$ctrl.tinymceModel"></span>\r\n            </div>\r\n            <div ng-if="!$ctrl.hideContainer">\r\n                    <visit-comment-textarea\r\n                        use-advanced-toolbar="true"\r\n                        visit-comment-type="$ctrl.visitCommentType"\r\n                        visit-id="$ctrl.visitId"\r\n                    />\r\n            </div>\r\n        </div>\r\n\r\n        <div class="col col-md-1"></div>\r\n    </div>\r\n    <div class="table-fnc-dx-container">\r\n        <table class="table table-v18 table-flush-left">\r\n            <thead>\r\n            <tr>\r\n                <th st-ratio="10">{{::\'Type\' | translate}}</th>\r\n                <th st-ratio="25">{{::\'Diagnosis\' | translate}}</th>\r\n                <th st-ratio="30">{{::\'Problem\' | translate}}</th>\r\n                <th st-ratio="25">{{::\'Notes\' | translate}}</th>\r\n                <th st-ratio="10">{{::\'Action\' | translate}}</th>\r\n            <tr>\r\n            </thead>\r\n            <tbody>\r\n            <tr ng-if="$ctrl.loadingDx">\r\n                <td colspan="5">\r\n                    <div class="spinner-container text-center">\r\n                        <ap-spinner size="3"></ap-spinner>\r\n                    </div>\r\n                </td>\r\n            </tr>\r\n            <tr ng-if="!$ctrl.loadingDx && $ctrl.loadDxError">\r\n                <td colspan="5">\r\n                    <uib-alert type="danger">\r\n                        {{::"An error has occurred and the diagnoses could not be loaded." | translate}}\r\n                    </uib-alert>\r\n                </td>\r\n            </tr>\r\n            <tr ng-repeat="item in $ctrl.diagnoses track by $index" ng-if="!$ctrl.loadingDx && !$ctrl.loadDxError">\r\n                <td>\r\n                    {{item.Type.Name}}\r\n                </td>\r\n                <td>\r\n                    {{item.FullDescription}}\r\n                </td>\r\n                <td>\r\n                    {{item.Problem.Name}}\r\n                </td>\r\n                <td>\r\n                    {{item.Notes}}\r\n                </td>\r\n                <td>\r\n                    <div class="dropdown dropdown-v18" uib-dropdown auto-close="outsideClick">\r\n                        <button type="button" data-toggle="dropdown">\r\n                            {{::\'Action\' | translate}}\r\n                            <span class="ap-chevron-down-gray"></span>\r\n                            <ap-spinner size="1" ng-show="item.actionInProgress"></ap-spinner>\r\n                        </button>\r\n                        <ul class="dropdown-menu" uib-dropdown-menu role="menu">\r\n                            <li class="clickable" ng-click="$ctrl.removeDiagnosis(item)">\r\n                                <a>Remove</a>\r\n                            </li>\r\n                        </ul>\r\n                    </div>\r\n                </td>\r\n            </tr>\r\n            </tbody>\r\n        </table>\r\n    </div>\r\n    <div class="fnc-search">\r\n        <div>\r\n            <input type="text" placeholder="Search new diagnosis" ng-click="$ctrl.imoSearch()" ng-model="$ctrl.imoSearchInput">\r\n        </div>\r\n        <div class="row fnc-list-search">\r\n            <div class="col col-xs-4 border-right">\r\n                <div class="left-block">\r\n                    <input type="text" placeholder="Category" ng-model="$ctrl.dxCategorySearch">\r\n                    <div ng-if="$ctrl.loadingDxLists">\r\n                            <div class="spinner-container text-center">\r\n                                <ap-spinner size="3"></ap-spinner>\r\n                            </div>\r\n                    </div>\r\n                    <div ng-if="!$ctrl.loadingDxLists" ng-repeat="group in $ctrl.diagnosisGroups | filter:$ctrl.dxCategorySearch"\r\n                        name="dx-category-{{::$index}}">\r\n                        <div class="clickable list-item "\r\n                             ng-click="$ctrl.selectDxGroup(group)"\r\n                             name="dx-category-header-{{::$index}}">\r\n\r\n                            <span ng-class="{\'selected\' : group.IsSelected}">\r\n                                {{::group.DiagnosisCategoryName}}\r\n                            </span>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n            <div class="col col-xs-8">\r\n                <div class=" right-block">\r\n                    <input type="text" placeholder="Search within lists" ng-model="$ctrl.dxSearch">\r\n                </div>\r\n                <div ng-if="!$ctrl.loadingDxLists" ng-repeat="diagnosis in $ctrl.activeDxGroup | filter:$ctrl.dxSearch" class="list-item">\r\n                    <div class="clickable" ng-class="{\'selected\' : diagnosis.IsSelected}" ng-click="$ctrl.addDiagnosis(diagnosis)">\r\n                        ({{::diagnosis.DiagnosisCode10 || diagnosis.DiagnosisCode9}}) {{::diagnosis.DiagnosisName}}\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>\r\n\r\n\r\n'),$templateCache.put("/fnc/tabs/hx/medical-devices/component-views/hxMedicalDevices.html",'<div class="container-fluid container-flush history-container" ng-cloak>\r\n    <div class="ng-hide"\r\n        ng-class="{ \'fixed-medical-device-footer-present\' : (($ctrl.model.DeviceHistory.ActiveDevices.length + $ctrl.model.DeviceHistory.InactiveDevices.length) > 0) }"\r\n        ng-show="!$ctrl.loading && !$ctrl.httpError">\r\n\r\n        <div class="row">\r\n            <div class="panel panel-default panel-flush">\r\n\r\n                <div class="col-xs-12 col-flush new-medical-device">\r\n                    <div class="col-xs-12 col-flush new-medical-device-header clickable" ng-click="$ctrl.model.NlmDeviceSearch.IsHeaderCollapsed =! $ctrl.model.NlmDeviceSearch.IsHeaderCollapsed">\r\n                        <span ng-if="$ctrl.model.NlmDeviceSearch.IsHeaderCollapsed" class="down-double-arrows-header-svg"></span>\r\n                        <span ng-if="!$ctrl.model.NlmDeviceSearch.IsHeaderCollapsed" class="up-double-arrows-header-svg"></span>\r\n                        <label class="new-medical-device-header-text clickable">{{ :: \'Add New Medical Device\' | translate }}</label>\r\n                    </div>\r\n\r\n                    <div uib-collapse="$ctrl.model.NlmDeviceSearch.IsHeaderCollapsed">\r\n                        <div class="col-xs-12 col-flush find-new-medical-device-form">\r\n                            <form id="find-device-form" name="findDeviceForm">\r\n                                <div class="col-xs-10 col-flush">\r\n                                    <div class="form-group">\r\n                                        <input type="text"\r\n                                               class="form-control"\r\n                                               name="udiSearchItem" id="udiSearchItem"\r\n                                               ng-disabled="$ctrl.model.IsReadOnly"\r\n                                               ng-model="$ctrl.model.NlmDeviceSearch.UniqueDeviceId"\r\n                                               ng-change="$ctrl.onUdiSearchItemChange()"\r\n                                               placeholder="{{ :: \'Please scan a Unique Device Identifier\' | translate }}" >\r\n                                        <span class="text-danger ng-hide" ng-show="$ctrl.model.Errors.IsError()">\r\n                                            {{ $ctrl.model.Errors.ErrorMessage() }}\r\n                                        </span>\r\n                                    </div>\r\n                                </div>\r\n\r\n                                <div class="col-xs-2 col-flush">\r\n                                    <button class="btn btn-default button-margins-left-right-10 pull-right"\r\n                                            ng-disabled="($ctrl.model.NlmDeviceSearch.SearchInProgress || $ctrl.model.IsReadOnly)"\r\n                                            ng-click="$ctrl.onScanBarcodeButtonClick()">\r\n                                        <span class="ng-hide" ng-show="$ctrl.model.NlmDeviceSearch.SearchInProgress"><i class="fa fa-spinner fa-spin"></i></span>\r\n                                        {{ $ctrl.model.NlmDeviceSearch.ButtonCaption }}\r\n                                    </button>\r\n                                </div>\r\n                            </form>\r\n                        </div>\r\n\r\n                        <div ng-if="$ctrl.model.NlmDeviceSearch.HasSearchBeenPerformed && $ctrl.model.NlmDeviceSearch.DeviceFound" class="col-xs-12 col-flush">\r\n                            <div class="col-xs-12 col-flush medical-device-search-results-header">\r\n                                <div class="col-xs-7 col-flush">\r\n                                    <label class="medical-device-search-results-header-text">{{ :: \'1 UDI FOUND\' | translate }}</label>\r\n                                </div>\r\n\r\n                                <div class="col-xs-1 medical-device-search-results-column-header"><label>{{ :: \'MRI SAFETY STATUS\' | translate }}</label></div>\r\n                                <div class="col-xs-1 medical-device-search-results-column-header"><label>{{ :: \'RUBBER +LATEX\' | translate }}</label></div>\r\n                                <div class="col-xs-1 medical-device-search-results-column-header"><label>{{ :: \'EXPIRATION\' | translate }}</label></div>\r\n                                <div class="col-xs-2 medical-device-search-results-column-header"><label>{{ :: \'NOTE\' |translate }}</label></div>\r\n                            </div>\r\n\r\n                            <ap-medical-device medical-device="$ctrl.model.NlmDeviceSearch.SearchResult"\r\n                                               background-white="true"\r\n                                               is-collapsed="false"\r\n                                               is-read-only="$ctrl.model.IsReadOnly"\r\n                                               device-type="$ctrl.model.MedicalDeviceType.Lookup">\r\n                            </ap-medical-device>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n\r\n\r\n                <div class="col-xs-12 col-flush medical-device-history">\r\n                    <div class="col-xs-12 col-flush medical-device-history-header clickable" ng-click="$ctrl.model.DeviceHistory.IsHistoryCollapsed = !$ctrl.model.DeviceHistory.IsHistoryCollapsed">\r\n                        <span ng-if="$ctrl.model.DeviceHistory.IsHistoryCollapsed" class="down-double-arrows-header-svg"></span>\r\n                        <span ng-if="!$ctrl.model.DeviceHistory.IsHistoryCollapsed" class="up-double-arrows-header-svg"></span>\r\n                        <label class="medical-device-history-header-text clickable">{{ :: \'Medical Device History\' | translate }}</label>\r\n                    </div>\r\n\r\n                    <div uib-collapse="$ctrl.model.DeviceHistory.IsHistoryCollapsed">\r\n                        <div class="col-xs-12 col-flush">\r\n                            <div class="col-xs-12 col-flush medical-device-history-sub-header">\r\n                                <div class="col-xs-7 col-flush">\r\n                                    <label class="medical-device-history-sub-header-text">{{ :: \'ACTIVE\' | translate }}</label>\r\n                                    <span ng-if="!$ctrl.model.DeviceHistory.ActiveDevices.length" class="medical-device-history-no-devices-found">{{ :: \'No Devices Found\' | translate }}</span>\r\n                                </div>\r\n\r\n                                <div class="col-xs-1 medical-device-history-column-header"><label>{{ :: \'MRI SAFETY STATUS\' | translate }}</label></div>\r\n                                <div class="col-xs-1 medical-device-history-column-header"><label>{{ :: \'RUBBER +LATEX\' | translate }}</label></div>\r\n                                <div class="col-xs-1 medical-device-history-column-header"><label>{{ :: \'EXPIRATION\' | translate }}</label></div>\r\n                                <div class="col-xs-2 medical-device-history-column-header">\r\n                                    <label>{{ :: \'NOTE\' |translate }}</label>\r\n                                    <span class="pull-right" ng-click="$ctrl.model.DeviceHistory.IsActiveCollapsed = !$ctrl.model.DeviceHistory.IsActiveCollapsed">\r\n                                        <span class="pull-right clickable medical-device-single-arrow-margin-active"\r\n                                              ng-class="$ctrl.model.DeviceHistory.IsActiveCollapsed ? \'down-single-arrow-item-svg\' : \'up-single-arrow-item-svg\'">\r\n                                        </span>\r\n                                    </span>\r\n                                </div>\r\n                            </div>\r\n\r\n                            <div uib-collapse="$ctrl.model.DeviceHistory.IsActiveCollapsed" class="col-xs-12 col-flush" ng-repeat="device in $ctrl.model.DeviceHistory.ActiveDevices">\r\n                                <ap-medical-device medical-device="device"\r\n                                                   background-white="{{$even}}"\r\n                                                   is-collapsed="{{device.IsCollapsed}}"\r\n                                                   is-read-only="$ctrl.model.IsReadOnly"\r\n                                                   device-type="$ctrl.model.MedicalDeviceType.Active">\r\n                                </ap-medical-device>\r\n                            </div>\r\n                        </div>\r\n\r\n                        <div class="col-xs-12 col-flush">\r\n                            <div class="col-xs-12 col-flush medical-device-history-sub-header" ng-drop="true" ng-drop-success="$ctrl.onDropMedicalDevice($data, {TargetDeviceType:\'INACTIVE\'})">\r\n                                <div class="col-xs-7 col-flush">\r\n                                    <label class="medical-device-history-sub-header-text">{{ :: \'INACTIVE\' | translate }}</label>\r\n                                    <span ng-if="!$ctrl.model.DeviceHistory.InactiveDevices.length" class="medical-device-history-no-devices-found">{{ :: \'No Devices Found\' | translate }}</span>\r\n                                </div>\r\n                                <div class="col-xs-5 col-flush">\r\n                                    <span class="pull-right" ng-click="$ctrl.model.DeviceHistory.IsInactiveCollapsed = !$ctrl.model.DeviceHistory.IsInactiveCollapsed">\r\n                                        <span class="pull-right clickable medical-device-single-arrow-margin"\r\n                                              ng-class="$ctrl.model.DeviceHistory.IsInactiveCollapsed ? \'down-single-arrow-item-svg\' : \'up-single-arrow-item-svg\'">\r\n                                        </span>\r\n                                    </span>\r\n                                </div>\r\n                            </div>\r\n\r\n                            <div uib-collapse="$ctrl.model.DeviceHistory.IsInactiveCollapsed" class="col-xs-12 col-flush" ng-repeat="device in $ctrl.model.DeviceHistory.InactiveDevices">\r\n                                <ap-medical-device medical-device="device"\r\n                                                   background-white="{{$even}}"\r\n                                                   is-collapsed="{{device.IsCollapsed}}"\r\n                                                   is-read-only="$ctrl.model.IsReadOnly"\r\n                                                   device-type="$ctrl.model.MedicalDeviceType.Inactive">\r\n                                </ap-medical-device>\r\n                            </div>\r\n                        </div>\r\n\r\n                        <div class="col-xs-12 col-flush">\r\n                            <div class="col-xs-12 col-flush medical-device-history-sub-header" ng-drop="true" ng-drop-success="$ctrl.onDropMedicalDevice($data, {TargetDeviceType:\'DELETED\'})">\r\n                                <div class="col-xs-7 col-flush">\r\n                                    <label class="medical-device-history-sub-header-text">{{ :: \'DELETED (Entered in error)\' | translate }}</label>\r\n                                    <span ng-if="!$ctrl.model.DeviceHistory.DeletedDevices.length" class="medical-device-history-no-devices-found">{{ :: \'No Devices Found\' | translate }}</span>\r\n                                </div>\r\n                                <div class="col-xs-5 col-flush">\r\n                                    <span class="pull-right" ng-click="$ctrl.model.DeviceHistory.IsDeleteCollapsed = !$ctrl.model.DeviceHistory.IsDeleteCollapsed">\r\n                                        <span class="pull-right clickable medical-device-single-arrow-margin"\r\n                                              ng-class="$ctrl.model.DeviceHistory.IsDeleteCollapsed ? \'down-single-arrow-item-svg\' : \'up-single-arrow-item-svg\'">\r\n                                        </span>\r\n                                    </span>\r\n                                </div>\r\n                            </div>\r\n\r\n                            <div uib-collapse="$ctrl.model.DeviceHistory.IsDeleteCollapsed" class="col-xs-12 col-flush" ng-repeat="device in $ctrl.model.DeviceHistory.DeletedDevices">\r\n                                <ap-medical-device medical-device="device"\r\n                                                   background-white="{{$even}}"\r\n                                                   is-collapsed="{{device.IsCollapsed}}"\r\n                                                   is-read-only="$ctrl.model.IsReadOnly"\r\n                                                   device-type="$ctrl.model.MedicalDeviceType.Deleted">\r\n                                </ap-medical-device>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="ng-hide" ng-show="$ctrl.loading || $ctrl.httpError">\r\n        <div class="row">\r\n            <div class="panel panel-default panel-flush">\r\n                <div class="panel-body">\r\n                    <div class="row">\r\n                        <div class="col-xs-12 text-center" ng-show="$ctrl.loading">\r\n                            <span><i class="fa fa-spinner fa-spin"></i></span>\r\n                            {{ :: \'Loading Medical Device History\' | translate }}\r\n                        </div>\r\n                        <div class="col-xs-12 text-center" ng-show="$ctrl.httpError.unhandled">\r\n                            <uib-alert type="danger">\r\n                                {{ :: \'An error has occurred and the medical device history could not be loaded.\' | translate }}\r\n                            </uib-alert>\r\n                        </div>\r\n                        <div class="col-xs-12 text-center" ng-show="$ctrl.httpError.is403">\r\n                            {{ :: \'You do not have access to this patient\\\'s medical medical device history.\' | translate }}\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="navbar navbar-default navbar-fixed-bottom medical-device-drop-area"\r\n         ng-show="($ctrl.model.DeviceHistory.ActiveDevices.length + $ctrl.model.DeviceHistory.InactiveDevices.length) > 0 && !$ctrl.loading && !$ctrl.httpError">\r\n\r\n        <table style="width:100%;">\r\n            <tr>\r\n                <td class="medical-device-drop-area-column medical-device-drop-area-vr" ng-drop="true" ng-drop-success="$ctrl.onDropMedicalDevice($data, {TargetDeviceType:\'INACTIVE\'})">\r\n                    <span>{{ :: \'Drag devices here to inactivate them\' | translate }}</span>\r\n                </td>\r\n                <td class="medical-device-drop-area-column" ng-drop="true" ng-drop-success="$ctrl.onDropMedicalDevice($data, {TargetDeviceType:\'DELETED\'})">\r\n                    <span>{{ :: \'Drag devices here to delete them\' | translate }}</span>\r\n                </td>\r\n            </tr>\r\n        </table>\r\n    </div>\r\n\r\n</div>'),$templateCache.put("/fnc/tabs/hx/medical-devices/component-views/medicalDeviceDelete.html",'<div id="medical-device-delete">\r\n    <div id="medical-device-delete-loading" ng-show="$ctrl.loadingMedicalDeviceDelete">\r\n        <div class="row">\r\n            <div class="col-xs-12 text-center">\r\n                {{::\'Loading Medical Device Delete\' | translate}}\r\n                <br/>\r\n                <ap-spinner data-size="3"></ap-spinner>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div id="medical-device-delete-content" ng-show="!$ctrl.loadingMedicalDeviceDelete && !ctrl.$scope.httpError">\r\n        <div class="col-xs-12 col-flush center-horizontally">\r\n            <label class="modal-medical-device-name-value">{{:: $ctrl.deviceName }}</label>\r\n        </div>\r\n\r\n        <div class="col-xs-12 col-flush center-horizontally">\r\n            <label class="modal-medical-device-description-value">{{:: $ctrl.deviceDescription }}</label>\r\n        </div>\r\n\r\n        <div class="col-xs-12 col-flush center-horizontally">\r\n            <label class="modal-medical-device-udi-value">{{:: $ctrl.udi }}</label>\r\n        </div>\r\n\r\n        <div class="col-xs-12 col-flush">\r\n            <div class="col-xs-3 col-flush"></div>\r\n            <div class="col-xs-6 col-flush">\r\n                <div class="col-xs-12 col-flush modal-medical-device-reason-header">\r\n                    <label>{{:: \'Please enter your reason for deleting this device.\' | translate}}</label>\r\n                </div>\r\n                <div class="col-xs-12 col-flush">\r\n                    <textarea\r\n                            rows="3"\r\n                            class="form-control"\r\n                            maxlength="8192"\r\n                            ng-model="$ctrl.notes"\r\n                            placeholder="Enter Reason">\r\n                    </textarea>\r\n                </div>\r\n            </div>\r\n            <div class="col-xs-3 col-flush"></div>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="row" ng-if="!!$ctrl.$scope.httpError">\r\n        <div class="col-xs-12" ng-show="$ctrl.$scope.httpError.unhandled">\r\n            <uib-alert type="danger">\r\n                {{::\'An error has occurred and the medical device could not be loaded.\' | translate}}\r\n            </uib-alert>\r\n        </div>\r\n        <div class="col-xs-12" ng-show="$ctrl.$scope.httpError.is403">\r\n            <uib-alert type="danger">\r\n                {{::\'You do not have access to the medical device.\' | translate}}\r\n            </uib-alert>\r\n        </div>\r\n    </div>\r\n</div>'),$templateCache.put("/fnc/tabs/hx/medical-devices/component-views/medicalDeviceHistory.html",'<div id="medical-device-history">\r\n    <div id="medical-device-history-loading" ng-show="$ctrl.loadingMedicalDeviceHistory">\r\n        <div class="row">\r\n            <div class="col-xs-12 text-center">\r\n                {{:: \'Loading Medical Device History\' | translate}}\r\n                <br/>\r\n                <ap-spinner data-size="3"></ap-spinner>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div id="medical-device-history-content" ng-show="!$ctrl.loadingMedicalDeviceHistory && !ctrl.$scope.httpError">\r\n        <table id="medical-device-history-table" class="table table-striped" st-table="vm.model.MedicalDeviceHistory">\r\n            <thead>\r\n                <tr>\r\n                    <th st-ratio="15" st-skip-natural="true">{{::\'Status\' | translate}}</th>\r\n                    <th st-ratio="40" st-skip-natural="true">{{::\'Notes\' | translate}}</th>\r\n                    <th st-ratio="15" st-skip-natural="true">{{::\'Device Active Date\' | translate}}</th>\r\n                    <th st-ratio="15" st-skip-natural="true">{{::\'Device Inactive Date\' | translate}}</th>\r\n                    <th st-ratio="15" st-skip-natural="true">{{::\'Recorded Date\' | translate}}</th>\r\n                </tr>\r\n            </thead>\r\n            <tbody>\r\n            <tr ng-repeat="item in $ctrl.model.MedicalDeviceHistory">\r\n                <td st-ratio="15">{{::item.MedicalDeviceStatusName}}</td>\r\n                <td st-ratio="40"><span class="white-space-pre-line">{{::item.Notes}}</span></td>\r\n                <td st-ratio="15"><span class="white-space-pre-line">{{::item.DeviceActiveDateWithAnswer}}</span></td>\r\n                <td st-ratio="15"><span class="white-space-pre-line">{{::item.DeviceInactiveDateWithAnswer}}</span></td>\r\n                <td st-ratio="15"><ap-date-formatter date="{{::item.Sequence}}" format="date"></ap-date-formatter></td>\r\n            </tr>\r\n            </tbody>\r\n        </table>\r\n    </div>\r\n\r\n    <div class="row" ng-if="!!$ctrl.$scope.httpError">\r\n        <div class="col-xs-12" ng-show="$ctrl.$scope.httpError.unhandled">\r\n            <uib-alert type="danger">\r\n                {{::\'An error has occurred and the medical device history could not be loaded.\' | translate}}\r\n            </uib-alert>\r\n        </div>\r\n        <div class="col-xs-12" ng-show="$ctrl.$scope.httpError.is403">\r\n            <uib-alert type="danger">\r\n                {{::\'You do not have access to the medical device history.\' | translate}}\r\n            </uib-alert>\r\n        </div>\r\n    </div>\r\n</div>'),$templateCache.put("/fnc/tabs/hx/medical-devices/views/apMedicalDevice.html",'<div class="col-xs-12 col-flush medical-device-entry"\r\n     ng-class="model.IsBackgroundWhite ? \'device-history-background-color-white\' : \'device-history-background-color-gray\'"\r\n     ng-drag="isMedicalDeviceDraggable()" ng-drag-data="model.MedicalDevice">\r\n\r\n    <div class="col-xs-12 col-flush">\r\n        <div class="col-xs-7 col-flush clickable medical-device-entry-description-header" ng-click="updateIsCollapsedAttribute()">\r\n            <div class="col-flush pull-left" ng-drag-handle="isMedicalDeviceDraggable()">\r\n                <span ng-if="model.IsCollapsed"  class="down-double-arrows-item-svg medical-device-entry-expand-collapse-item"></span>\r\n                <span ng-if="!model.IsCollapsed" class="up-double-arrows-item-svg medical-device-entry-expand-collapse-item"></span>\r\n            </div>\r\n            <span class="medical-device-description-value" ng-class="{\'medical-device-inactive-color\' : !model.MedicalDevice.IsActive}">{{ model.MedicalDevice.DeviceDescription }}</span>\r\n        </div>\r\n        <div class="col-xs-5">&nbsp;&nbsp;</div>\r\n    </div>\r\n\r\n    <div class="col-xs-12 col-flush padding-top-5-padding-bot-5"></div>\r\n\r\n    <div class="col-xs-12 col-flush">\r\n        <div class="col-xs-7">\r\n            <div class="col-xs-12 medical-device-name-value" ng-class="{\'medical-device-inactive-color\' : !model.MedicalDevice.IsActive}">\r\n                {{ model.MedicalDevice.DeviceName }}\r\n            </div>\r\n            <div class="col-xs-12 medical-device-udi-value" ng-class="{\'medical-device-inactive-color\' : !model.MedicalDevice.IsActive}">\r\n                {{ model.MedicalDevice.UniqueDeviceIdentifier }}\r\n            </div>\r\n        </div>\r\n        <div class="col-xs-1 medical-device-property-value" ng-class="{\'medical-device-inactive-color\' : !model.MedicalDevice.IsActive}">{{ model.MedicalDevice.MriSafetyStatus }}</div>\r\n\r\n        <div class="col-xs-1 medical-device-property-value" ng-class="{\'medical-device-inactive-color\' : !model.MedicalDevice.IsActive}">\r\n            {{ model.MedicalDevice.ContainsNaturalRubberLatex }}\r\n        </div>\r\n\r\n        <div class="col-xs-1 medical-device-property-value" ng-class="{\'medical-device-inactive-color\' : !model.MedicalDevice.IsActive}">{{ model.MedicalDevice.ExpirationDate }}</div>\r\n        <div class="col-xs-2 medical-device-property-value">\r\n            <div class="medical-device-edit-button-container">\r\n                <div class="medical-device-notes-header-value"\r\n                     ng-class="{\'clickable\' : !model.IsReadOnly, \'medical-device-not-allowed\' : model.IsReadOnly, \'medical-device-inactive-color\' : !model.MedicalDeviceType.IsActive}"\r\n                     ng-click="(model.MedicalDevice.DeviceType !== model.MedicalDeviceType.Deleted) && updateMedicalDeviceButtonClick()" >\r\n                    <span ng-if="model.MedicalDevice.Notes">{{model.MedicalDevice.Notes}}</span>\r\n                    <span ng-if="!model.MedicalDevice.Notes">{{ :: \'+ Add Note\' | translate}}</span>\r\n                    <span class="ng-hide" ng-show="model.IsUpdateInProgress"><i class="fa fa-spinner fa-spin"></i></span>\r\n                </div>\r\n                <div class="pull-right medical-device-edit-button">\r\n                    <span ng-class="!model.IsReadOnly ? \'clickable\' : \'medical-device-not-allowed\'" ng-click="updateMedicalDeviceButtonClick()" title="Select to edit medical device">\r\n                        <span class="glyphicon glyphicon-edit"></span>\r\n                    </span>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div uib-collapse="model.IsCollapsed">\r\n        <div class="col-xs-12 padding-top-10-padding-bot-10">\r\n            <div class="col-xs-12 col-flush">\r\n                <div class="col-xs-7 col-flush">\r\n                    <div class="col-xs-12 col-flush vertical-line-left" style="margin-left: 15px;">\r\n                        <div class="col-xs-4 col-flush">\r\n                            <div class="col-xs-12 medical-device-property-header">{{:: \'COMPANY NAME\' | translate }}</div>\r\n                            <div class="col-xs-12 medical-device-property-value" ng-class="{\'medical-device-inactive-color\' : !model.MedicalDevice.IsActive}">{{ model.MedicalDevice.CompanyName }}</div>\r\n\r\n                            <div class="col-xs-12 medical-device-property-header">{{:: \'BRAND NAME\' | translate }}</div>\r\n                            <div class="col-xs-12 medical-device-property-value" ng-class="{\'medical-device-inactive-color\' : !model.MedicalDevice.IsActive}">{{ model.MedicalDevice.BrandName }}</div>\r\n\r\n                            <div class="col-xs-12 medical-device-property-header">{{:: \'MODEL NUMBER\' | translate }}</div>\r\n                            <div class="col-xs-12 medical-device-property-value" ng-class="{\'medical-device-inactive-color\' : !model.MedicalDevice.IsActive}">{{ model.MedicalDevice.ModelNumber }}</div>\r\n\r\n                            <div class="col-xs-12 medical-device-property-header">{{:: \'DEVICE ID\' | translate }}</div>\r\n                            <div class="col-xs-12 medical-device-property-value" ng-class="{\'medical-device-inactive-color\' : !model.MedicalDevice.IsActive}">{{ model.MedicalDevice.DeviceIdentifier }}</div>\r\n\r\n                            <div class="col-xs-12 medical-device-property-header">{{:: \'LOT NUMBER\' | translate }}</div>\r\n                            <div class="col-xs-12 medical-device-property-value" ng-class="{\'medical-device-inactive-color\' : !model.MedicalDevice.IsActive}">{{ model.MedicalDevice.LotNumber }}</div>\r\n                        </div>\r\n                        <div class="col-xs-4 col-flush">\r\n                            <div class="col-xs-12 medical-device-property-header">{{:: \'SERIAL NUMBER\' | translate }}</div>\r\n                            <div class="col-xs-12 medical-device-property-value" ng-class="{\'medical-device-inactive-color\' : !model.MedicalDevice.IsActive}">{{ model.MedicalDevice.SerialNumber }}</div>\r\n\r\n                            <div class="col-xs-12 medical-device-property-header">{{:: \'MANUFACTURING DATE\' | translate }}</div>\r\n                            <div class="col-xs-12 medical-device-property-value" ng-class="{\'medical-device-inactive-color\' : !model.MedicalDevice.IsActive}">{{ model.MedicalDevice.ManufacturingDate }}</div>\r\n\r\n                            <div class="col-xs-12 medical-device-property-header">{{:: \'ISSUING AGENCY\' | translate }}</div>\r\n                            <div class="col-xs-12 medical-device-property-value" ng-class="{\'medical-device-inactive-color\' : !model.MedicalDevice.IsActive}">{{ model.MedicalDevice.IssuingAgency }}</div>\r\n\r\n                            <div class="col-xs-12 medical-device-property-header">{{:: \'DONATION ID\' | translate }}</div>\r\n                            <div class="col-xs-12 medical-device-property-value" ng-class="{\'medical-device-inactive-color\' : !model.MedicalDevice.IsActive}">{{ model.MedicalDevice.DonationId }}</div>\r\n\r\n                            <div class="col-xs-12 medical-device-property-header">{{:: \'HCT/P CODE\' | translate }}</div>\r\n                            <div class="col-xs-12 medical-device-property-value" ng-class="{\'medical-device-inactive-color\' : !model.MedicalDevice.IsActive}">{{ model.MedicalDevice.DeviceHctp }}</div>\r\n                        </div>\r\n                        <div class="col-xs-4 col-flush">\r\n                            <div class="col-xs-12 medical-device-property-header">{{:: \'DEVICE ACTIVE DATE\' | translate }}</div>\r\n                            <div class="col-xs-12 medical-device-property-value" ng-class="{\'medical-device-inactive-color\' : !model.MedicalDevice.IsActive}">\r\n                                {{model.MedicalDevice.DeviceActiveDateAnswerWithValue}}\r\n                            </div>\r\n\r\n                            <div class="col-xs-12 medical-device-property-header">{{:: \'DEVICE INACTIVE DATE\' | translate }}</div>\r\n                            <div class="col-xs-12 medical-device-property-value" ng-class="{\'medical-device-inactive-color\' : !model.MedicalDevice.IsActive}">\r\n                                {{model.MedicalDevice.DeviceInactiveDateAnswerWithValue}}\r\n                            </div>\r\n\r\n                            <div class="col-xs-12 medical-device-property-header">{{:: \'RECORDED DATE\' | translate }}</div>\r\n                            <div class="col-xs-12 medical-device-property-value" ng-class="{\'medical-device-inactive-color\' : !model.MedicalDevice.IsActive}">\r\n                                <ap-date-formatter date="{{model.MedicalDevice.Sequence}}" format="date"></ap-date-formatter>\r\n                                <span ng-if="model.MedicalDevice.DeviceType === model.MedicalDeviceType.Lookup">&nbsp;</span>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n                <div class="col-xs-5 col-flush">\r\n                    <div class="col-xs-12 col-flush">\r\n                        <div class="col-xs-12 medical-device-property-header">\r\n                            <span ng-click="(model.MedicalDevice.DeviceType !== model.MedicalDeviceType.Deleted) && updateMedicalDeviceButtonClick()"\r\n\r\n\r\n                                  ng-class="(!model.IsReadOnly && model.MedicalDevice.DeviceType !== model.MedicalDeviceType.Deleted) ? \'clickable\' : \'medical-device-not-allowed\'">\r\n\r\n\r\n                                {{ :: \'NOTES\' | translate }}\r\n                                <span ng-if="model.MedicalDevice.DeviceType !== model.MedicalDeviceType.Deleted && !model.IsReadOnly">{{ :: \' (click to update)\' | translate}}</span>\r\n                            </span>\r\n                            <span class="ng-hide" ng-show="model.IsUpdateInProgress"><i class="fa fa-spinner fa-spin"></i></span>\r\n                            <span ng-if="model.MedicalDevice.DeviceType !== model.MedicalDeviceType.Lookup" class="pull-right clickable" ng-click="displayMedicalDeviceHistory()">{{ :: \'DISPLAY HISTORY\' | translate }}</span>\r\n                        </div>\r\n                        <div class="col-xs-12 medical-device-property-value"\r\n                             ng-click="(model.MedicalDevice.DeviceType !== model.MedicalDeviceType.Deleted) && updateMedicalDeviceButtonClick()"\r\n                             ng-class="{\'medical-device-inactive-color\' : !model.MedicalDevice.IsActive, \'clickable\' : model.MedicalDevice.DeviceType !== model.MedicalDeviceType.Deleted && !model.IsReadOnly, \'medical-device-not-allowed\' : model.IsReadOnly || model.MedicalDevice.DeviceType === model.MedicalDeviceType.Deleted}">\r\n                            <textarea\r\n                                    rows="5"\r\n                                    ng-readonly="true"\r\n                                    class="form-control"\r\n                                    ng-class="{\'medical-device-inactive-color\' : !model.MedicalDevice.IsActive, \'clickable\' : model.MedicalDevice.DeviceType !== model.MedicalDeviceType.Deleted && !model.IsReadOnly, \'medical-device-not-allowed\' : model.IsReadOnly || model.MedicalDevice.DeviceType === model.MedicalDeviceType.Deleted}"\r\n                                    ng-model="model.MedicalDevice.Notes"\r\n                                    placeholder="Click to Enter Notes">\r\n                            </textarea>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n\r\n            <div class="col-xs-12">\r\n                <div class="col-xs-12" ng-class="model.MedicalDevice.DeviceType === model.MedicalDeviceType.Lookup ? \'horizontal-line-bottom\' : \'horizontal-line-bottom\'"></div>\r\n            </div>\r\n\r\n            <div class="col-xs-12 center-horizontally" ng-if="model.MedicalDevice.DeviceType === model.MedicalDeviceType.Active">\r\n                <button class="btn btn-primary medical-device-button-margins" ng-disabled="model.IsDeactivateInProgress || model.IsReadOnly" ng-click="deactivateDeviceButtonClick()">\r\n                    <span class="ng-hide" ng-show="model.IsDeactivateInProgress"><i class="fa fa-spinner fa-spin"></i></span>\r\n                    {{:: \'INACTIVATE DEVICE\' | translate}}\r\n                </button>\r\n                <button class="btn btn-default medical-device-button-margins" ng-disabled="model.IsDeleteInProgress || model.IsReadOnly" ng-click="deleteDeviceButtonClick()">\r\n                    <span class="ng-hide" ng-show="model.IsDeleteInProgress"><i class="fa fa-spinner fa-spin"></i></span>\r\n                    {{:: \'DELETE DEVICE\' | translate }}\r\n                </button>\r\n            </div>\r\n\r\n            <div class="col-xs-12 center-horizontally" ng-if="model.MedicalDevice.DeviceType === model.MedicalDeviceType.Inactive">\r\n                <button class="btn btn-primary medical-device-button-margins" ng-disabled="model.IsDeleteInProgress || model.IsReadOnly" ng-click="deleteDeviceButtonClick()">\r\n                    <span class="ng-hide" ng-show="model.IsDeleteInProgress"><i class="fa fa-spinner fa-spin"></i></span>\r\n                    {{:: \'DELETE DEVICE\' | translate }}\r\n                </button>\r\n            </div>\r\n\r\n            <div class="col-xs-12 center-horizontally" ng-if="model.MedicalDevice.DeviceType === model.MedicalDeviceType.Lookup">\r\n                <button class="btn btn-primary medical-device-button-margins" ng-disabled="model.IsAddInProgress || model.IsReadOnly" ng-click="addDeviceButtonClick()">\r\n                    <span class="ng-hide" ng-show="model.IsAddInProgress"><i class="fa fa-spinner fa-spin"></i></span>\r\n                    {{:: \'ADD DEVICE\' | translate}}\r\n                </button>\r\n                <button class="btn btn-default medical-device-button-margins" ng-disabled="model.IsReadOnly" ng-click="cancelButtonClick()">\r\n                    {{:: \'CANCEL\' | translate }}\r\n                </button>\r\n            </div>\r\n\r\n        </div>\r\n    </div>\r\n</div>'),$templateCache.put("/fnc/tabs/hx/medical-devices/views/directives/apTimeFrame.html",'<div class="col-xs-12 col-flush">\r\n    <div class="col-xs-5 col-flush">\r\n        <input ng-if="model.IsTimeFrameInputVisible"\r\n               class="form-control"\r\n               id="{{tfInputCtrlId}}"\r\n               name="{{tfInputCtrlId}}"\r\n               ng-model="model.TimeFrame.Value"\r\n               type="number"\r\n               ng-min="1"\r\n               ng-max="99"\r\n               ng-maxlength="2"\r\n               placeholder="{{:: \'Number of \' | translate}}"\r\n               ng-required="true" />\r\n\r\n        <input ng-if="model.IsTimeFrameCalendarVisible"\r\n               class="form-control"\r\n               name="{{calInputCtrlId}}"\r\n               id="{{calInputCtrlId}}"\r\n               type="date"\r\n               max="{{ model.DatePicker.maxDate }}"\r\n               min="{{ model.DatePicker.mixDate }}"\r\n               ng-model="model.TimeFrame.Date"\r\n               ng-model-options="{ updateOn: \'blur\', allowInvalid: 1 }"\r\n               ng-required="true"  />\r\n    </div>\r\n\r\n    <div class="col-xs-7" style="padding-right: 15px; padding-left: 0">\r\n        <select class="form-control arrow-dropdown"\r\n                name="{{tfSelCtrlId}}"\r\n                id="{{tfSelCtrlId}}"\r\n                ng-model="model.TimeFrame.Id"\r\n                ng-change="timeFrameTypeChanged()"\r\n                ng-options="timeFrameType.TimeFrameId as timeFrameType.Name for timeFrameType in timeFrameTypes"\r\n                ap-set-focus\r\n                ap-set-focus-event="change"\r\n                ap-set-focus-id="{{tfInputCtrlId}}, {{calInputCtrlId}}">\r\n        </select>\r\n    </div>\r\n</div>\r\n\r\n<div class="col-xs-12 col-flush text-left" ng-if="formRef[tfInputCtrlId].$invalid && formRef.$submitted">\r\n    <div class="form-group" ng-class="{ \'has-error\' : formRef[tfInputCtrlId].$error}">\r\n        <div ng-show="formRef[tfInputCtrlId].$error.max"><label class="control-label">{{:: \'Please enter a number less than 100.\' | translate}}</label></div>\r\n        <div ng-show="formRef[tfInputCtrlId].$error.min"><label class="control-label">{{:: \'Please enter a number greater than 0.\' | translate}}</label></div>\r\n        <div ng-show="formRef[tfInputCtrlId].$error.maxlength"><label class="control-label">{{:: \'Please enter a number greater than 0.\' | translate}}</label></div>\r\n        <div ng-show="formRef[tfInputCtrlId].$error.required"><label class="control-label">{{:: \'Please enter a number.\'}}</label></div>\r\n    </div>\r\n</div>\r\n\r\n<div class="col-xs-12 col-flush text-left" ng-if="formRef[calInputCtrlId].$invalid && formRef.$submitted">\r\n    <div class="form-group" ng-class="{ \'has-error\' : formRef[calInputCtrlId].$error }">\r\n        <label class="control-label">{{:: \'Please enter a date.\' | translate}}</label>\r\n    </div>\r\n</div>'),$templateCache.put("/fnc/tabs/hx/medical-devices/views/modals/medical-device-delete-modal.html",'<div id="medical-device-delete-modal" class="patient-history-modal" ap-full-modal ap-full-modal-always>\r\n    <div class="modal-header">\r\n        <button type="button" class="close" ng-click="vm.cancel()"><span>&times;</span></button>\r\n        <div class="warning-symbol-svg"></div>\r\n        <div class="modal-subtitle center-horizontally">\r\n            <span>{{:: \'Are you sure you want to DELETE this device?\' | translate}}</span>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="modal-body">\r\n        <medical-device-delete\r\n            udi="vm.model.udi"\r\n            device-name="vm.model.deviceName",\r\n            device-description="vm.model.deviceDescription"\r\n            notes="vm.model.notes">\r\n        </medical-device-delete>\r\n    </div>\r\n\r\n    <div class="modal-footer">\r\n        <div class="col-xs-12 center-horizontally">\r\n            <div class="col-xs-3"></div>\r\n            <div class="col-xs-3">\r\n                <button class="btn btn-primary button-margins" ng-click="vm.close()">\r\n                    <span>{{:: \'DELETE DEVICE\' | translate}}</span>\r\n                </button>\r\n            </div>\r\n            <div class="col-xs-3">\r\n                <button class="btn btn-default button-margins" ng-click="vm.cancel()">\r\n                    {{:: \'CANCEL\' | translate }}\r\n                </button>\r\n            </div>\r\n            <div class="col-xs-3"></div>\r\n        </div>\r\n    </div>\r\n</div>'),$templateCache.put("/fnc/tabs/hx/medical-devices/views/modals/medical-device-edit-modal.html",'<div id="medical-device-edit" class="patient-history-modal" ap-full-modal ap-full-modal-always>\r\n\r\n    <div class="modal-header">\r\n        <button type="button" class="close" ng-click="vm.cancel()">x</button>\r\n        <div class="modal-subtitle">\r\n            <span ng-if="vm.model.medicalDeviceType === vm.model.medicalDeviceTypeConstants.MedicalDeviceType.Lookup">{{::\'Add New Medical Device\' | translate}}</span>\r\n            <span ng-if="vm.model.medicalDeviceType === vm.model.medicalDeviceTypeConstants.MedicalDeviceType.Active">{{::\'Edit Medical Device\' | translate}}</span>\r\n            <span ng-if="vm.model.medicalDeviceType === vm.model.medicalDeviceTypeConstants.MedicalDeviceType.Inactive">{{::\'Deactivate Medical Device\' | translate}}</span>\r\n        </div>\r\n    </div>\r\n\r\n    <form name="medicalDeviceEditForm" novalidate>\r\n        <div class="modal-body">\r\n            <div class="panel panel-edit-device">\r\n                <div class="row form-group">\r\n                    <div class="row" style="margin-bottom:15px;">\r\n                        <div class="col-xs-12 col-flush">\r\n                            <label class="medical-device-property-header">{{::\'Device Name\' | translate}}</label>\r\n                        </div>\r\n                        <div class="col-xs-12 col-flush">\r\n                            <span class="medical-device-property-value">{{:: vm.model.medicalDevice.DeviceName}}</span>\r\n                        </div>\r\n                    </div>\r\n\r\n                    <div class="row" style="margin-bottom:15px;">\r\n                        <div class="col-xs-12 col-flush">\r\n                            <label class="medical-device-property-header">{{::\'Description\' | translate}}</label>\r\n                        </div>\r\n                        <div class="col-xs-12 col-flush">\r\n                            <span class="medical-device-property-value">{{:: vm.model.medicalDevice.DeviceDescription}}</span>\r\n                        </div>\r\n                    </div>\r\n\r\n                    <div class="row" style="margin-bottom:15px;">\r\n                        <div class="col-xs-12 col-flush">\r\n                            <label class="medical-device-property-header">{{::\'Unique Identifier\' | translate}}</label>\r\n                        </div>\r\n                        <div class="col-xs-12 col-flush">\r\n                            <span class="medical-device-property-value">{{:: vm.model.medicalDevice.UniqueDeviceIdentifier}}</span>\r\n                        </div>\r\n                    </div>\r\n\r\n                    <div class="row" style="margin-bottom:15px;">\r\n                        <div class="col-xs-12 col-flush">\r\n                            <label class="medical-device-property-header">{{::\'Notes\' | translate}}</label>\r\n                            <i class="ap-dictation-2 clickable" ng-click="vm.openNotesEditor()"></i>\r\n                        </div>\r\n                        <div class="col-xs-12 col-flush">\r\n                            <textarea rows="3" class="form-control" maxlength="8192" ng-model="vm.model.medicalDevice.Notes" autofocus placeholder="Enter Medical Device Notes"></textarea>\r\n                        </div>\r\n                    </div>\r\n\r\n                    <div class="row" style="margin-bottom:15px;">\r\n                        <div class="col-xs-12 col-flush">\r\n                            <label class="medical-device-property-header">{{::\'Device Active Date\' | translate}}</label>\r\n                        </div>\r\n                        <div class="col-xs-12 col-flush pull-left">\r\n                            <div class="col-xs-6 col-flush pull-left">\r\n                                <ap-time-frame\r\n                                    id="vm.model.medicalDeviceTypeConstants.MedicalDeviceTimeFrameId.Active"\r\n                                    date-time-frame="vm.model.medicalDevice.DeviceActiveDateTimeFrame">\r\n                                </ap-time-frame>\r\n                            </div>\r\n                            <div class="col-xs-6 col-flush"></div>\r\n                        </div>\r\n                    </div>\r\n\r\n                    <div class="row" style="margin-bottom:15px;">\r\n                        <div class="col-xs-12 col-flush">\r\n                            <label class="medical-device-property-header">{{::\'Device Inactive Date\' | translate}}</label>\r\n                        </div>\r\n                        <div class="col-xs-12 col-flush pull-left">\r\n                            <div class="col-xs-6 col-flush pull-left">\r\n                                <ap-time-frame\r\n                                    id="vm.model.medicalDeviceTypeConstants.MedicalDeviceTimeFrameId.Inactive"\r\n                                    date-time-frame="vm.model.medicalDevice.DeviceInactiveDateTimeFrame">\r\n                                </ap-time-frame>\r\n                            </div>\r\n                            <div class="col-xs-6 col-flush"></div>\r\n                        </div>\r\n                    </div>\r\n\r\n                </div>\r\n            </div>\r\n        </div>\r\n\r\n        <div id="medical-device-edit-footer" class="modal-footer">\r\n            <div class="col-xs-12 center-horizontally">\r\n                <div class="col-xs-3"></div>\r\n                <div class="col-xs-3">\r\n                    <button class="btn btn-primary button-margins" ng-click="vm.close(medicalDeviceEditForm)">{{::\'SAVE\' | translate}}</button>\r\n                </div>\r\n                <div class="col-xs-3">\r\n                    <button class="btn btn-default button-margins" ng-click="vm.cancel()">{{::\'CANCEL\' | translate}}</button>\r\n                </div>\r\n                <div class="col-xs-3"></div>\r\n            </div>\r\n        </div>\r\n    </form>\r\n\r\n</div>'),$templateCache.put("/fnc/tabs/hx/medical-devices/views/modals/medical-device-history-modal.html",'<div id="medical-device-history-modal" class="patient-history-modal" ap-full-modal ap-full-modal-always>\r\n    <div class="modal-header">\r\n        <button type="button" class="close" ng-click="vm.cancel()"><span>&times;</span></button>\r\n        <div class="modal-subtitle center-horizontally">\r\n            <div class="col-xs-12 center-horizontally">\r\n                {{ :: \'Medical Device History for\' | translate }}\r\n            </div>\r\n            <div class="col-xs-12 center-horizontally">\r\n                {{ :: vm.model.deviceName}}\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="modal-body">\r\n        <medical-device-history patient-id="vm.model.patientId" grouping-id="vm.model.groupingId"></medical-device-history>\r\n    </div>\r\n\r\n    <div class="modal-footer">\r\n        <div class="col-xs-12 center-horizontally">\r\n            <div class="col-xs-5"></div>\r\n            <div class="col-xs-2"><button class="btn btn-primary button-margins" ng-click="vm.close()">{{:: \'OK\' | translate}}</button></div>\r\n            <div class="col-xs-5"></div>\r\n        </div>\r\n    </div>\r\n</div>'),$templateCache.put("/fnc/tabs/hx/medication/component-views/hxMedication.html",'<div id="hx-medication">\r\n    <div class="row">\r\n        <div class="col-xs-4">\r\n            <div>\r\n                <a class="fnc-rx-link-action"\r\n                   id="fnc-rx-controlled-substance-hx"\r\n                   ng-show="$ctrl.controlledSubstanceHxActive"\r\n                   ng-click="$ctrl.onClickControlledSubstanceHx()">\r\n                \r\n                        {{::\'State Controlled Rx Hx\' | translate}}\r\n                </a>\r\n            </div>\r\n        </div>\r\n        <div class="col-xs-4">\r\n            <div class="fnc-rx-title text-center" ng-if="$ctrl.isInRxTab() || $ctrl.isInRxRefillMessage()">\r\n                <span translate>Patient Medication</span>\r\n            </div>\r\n        </div>\r\n        <div class="col-xs-4 fnc-rx-actions-right">\r\n            <div class="ap-checkbox-right" ng-show="$ctrl.shouldShowPatientTakesNoMeds()">\r\n                <input type="checkbox"\r\n                        name="noMed"\r\n                        id="noMed"\r\n                        ng-model="$ctrl.rxHistory.PatientTakesNoMeds.Value"\r\n                        ng-change="$ctrl.updatePatientTakesNoMeds()"\r\n                        ng-disabled="!$ctrl.rxHistory.PatientTakesNoMeds.CanChange">\r\n                <label for="noMed">{{::\'Patient Takes No Medications\' | translate}}</label>\r\n            </div>\r\n            <div class="ap-checkbox-right" ng-show="$ctrl.shouldShowTransitionOfCare()">\r\n                <input type="checkbox"\r\n                        name="hm-transitionOfCare"\r\n                        id="hm-transitionOfCare"\r\n                        ng-change="$ctrl.updateTransitionOfCare()"\r\n                        ng-model="$ctrl.transitionOfCare.Value">\r\n                <label for="hm-transitionOfCare">{{::\'Transition Of Care\' | translate}}</label>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <table class="table table-v18">\r\n        <thead>\r\n            <tr>\r\n                <th class="checkbox-column">\r\n                    <div class="dropdown dropdown-v18 dropdown-actions" ng-if="$ctrl.multipleSelected && $ctrl.shouldShowMultiHxActions()">\r\n                        <button type="button"\r\n                                class="dropdown-actions-button"\r\n                                id="multi-hx-action-dropdown"\r\n                                data-toggle="dropdown">\r\n                            <div class="ap-actions-ellipsis"></div>\r\n                        </button>\r\n                        <ul class="dropdown-menu" ng-if="$ctrl.multipleSelected">\r\n                            <li class="clickable"\r\n                                ng-if="!medBulkAction.Hide || !medBulkAction.Hide()"\r\n                                ng-repeat="medBulkAction in $ctrl.medicationBulkActions"\r\n                                ng-click="medBulkAction.Action()"\r\n                                id="rx-history-bulk-action-dropdown">\r\n                                {{medBulkAction.Name}}\r\n                            </li>\r\n                        </ul>\r\n                    </div>\r\n                </th>\r\n                <th class="width-80-column">\r\n                    <table class="table table-filter-table">\r\n                        <tbody>\r\n                            <tr>\r\n                                <td>\r\n                                    <span ng-if="$ctrl.loadingHistoryFilters"><ap-spinner size="1"></ap-spinner></span>\r\n                                    <div class="dropdown dropdown-v18 dropdown-table-filter"\r\n                                         ng-if="!$ctrl.loadingHistoryFilters">\r\n                                        <span>{{$ctrl.currentMedicationFilter.Name}}</span>\r\n                                        <button type="button" data-toggle="dropdown" \r\n                                                class="dropdown-table-filter-button pull-right" \r\n                                                id="rx-history-filter-dropdown">\r\n                                            <div class="clickable ap-table-filter"></div>\r\n                                        </button>\r\n                                        <ul class="dropdown-menu" ng-class="!$ctrl.shouldShowAddMedicationToRefillMessage() ? \'col-xs-12\' : \'col-xs-6\'">\r\n                                            <li class="clickable"                                                    \r\n                                                ng-repeat="filter in $ctrl.medicationFilterList"\r\n                                                ng-click="$ctrl.onSelectFilter(filter)"\r\n                                                id="hx-filter-dropdown">\r\n                                                {{filter.Name}}\r\n                                            </li>\r\n                                            <li ng-if="$ctrl.shouldShowModifyFilter" class="clickable"\r\n                                                ng-click="$ctrl.onClickModifyFilter()">\r\n                                                {{::\'Modify\' | translate}}\r\n                                            </li>\r\n                                        </ul>\r\n                                    </div>\r\n                                </td>\r\n                                <td>\r\n                                    <button type="button"\r\n                                        id="hx-drug-search-btn"\r\n                                        name="hx-drug-search-btn"\r\n                                        class="fnc-rx-header-btn enable pull-right"\r\n                                        ng-if="$ctrl.shouldShowAddMedication()"\r\n                                        ng-click="$ctrl.onClickSearchDrugs()">\r\n                                        <div class="fnc-rx-header-btn-text">\r\n                                            {{::\'Add\' | translate}}\r\n                                        </div>\r\n                                    </button>\r\n                                    <button type="button"\r\n                                            id="hx-add-to-refill-message-btn"\r\n                                            name="hx-add-to-refill-message-btn"\r\n                                            class="fnc-rx-header-btn enable pull-right col-xs-6" style="width:100%;"\r\n                                            ng-if="$ctrl.shouldShowAddMedicationToRefillMessage()"\r\n                                            ng-click="$ctrl.onClickAddToRefillMessage()">\r\n                                        <div class="fnc-rx-header-btn-text">\r\n                                            {{::\'Select\' | translate}}\r\n                                        </div>\r\n                                    </button>\r\n                                </td>\r\n                            </tr>\r\n                        </tbody>\r\n                    </table>\r\n                </th>\r\n                <th class="fifth-width-column">{{::\'Doctor\' | translate}}</th>\r\n                <th class="stop-date-column">{{::\'Stop\' | translate}}</th>\r\n                <th class="status-column">{{::\'Status\' | translate}}</th>\r\n                <th class="action-column">{{::\'Action\' | translate}}</th>\r\n            </tr>\r\n        </thead>\r\n        <tbody>\r\n            <tr ng-if="$ctrl.loadingMedicationHistory">\r\n                <td colspan="6">\r\n                    <div class="spinner-container text-center">\r\n                        <ap-spinner size="3"></ap-spinner>\r\n                    </div>\r\n                </td>\r\n            </tr>\r\n            <tr ng-if="!$ctrl.loadingMedicationHistory && $ctrl.loadMedicationHistoryError">\r\n                <td colspan="6">\r\n                    <uib-alert type="danger">\r\n                        {{::"An error has occurred and the medication history could not be loaded." | translate}}\r\n                    </uib-alert>\r\n                </td>\r\n            </tr>\r\n            <tr class="queued" ng-class="{\'hazardous\': med.IsHazardousDrug, \'high-risk\': med.IsHighRisk}" ng-repeat="med in $ctrl.queuedMedications" ng-if="!$ctrl.loadingQueuedMedications">\r\n                <td colspan="2">\r\n                    <div class="flex-row">\r\n                        <span id="fnc-rx-edit-{{med.RelVisitMedicationId}}"\r\n                            class="fnc-rx-medication-text"\r\n                            ng-if="!med.CanEdit">\r\n                            {{med.Description}}\r\n                        </span>\r\n                    </div>\r\n                </td>\r\n                <td>\r\n                    {{:: med.Prescriber || \'&nbsp;\' }}\r\n                </td>\r\n                <td>\r\n                    {{:: med.StopDate || \'&nbsp;\' }}\r\n                </td>\r\n                <td>\r\n                    {{::\'Queued\' | translate}}\r\n                </td>\r\n                <td>\r\n                    <div class="dropdown dropdown-v18 dropdown-actions strikeout-hide">\r\n                        <button type="button"\r\n                                class="dropdown-actions-button"\r\n                                data-toggle="dropdown"\r\n                                id="rx-history-med-dropdown-{{med.RelVisitMedicationId}}">\r\n                            <div class="ap-actions-ellipsis"></div>\r\n                        </button>\r\n                        <ul class="dropdown-menu dropdown-menu-right">\r\n                            <li class="clickable" \r\n                                ng-repeat="medAction in $ctrl.queuedMedicationActions" ng-click="medAction.Action(med)"\r\n                                id="rx-history-med-action-dropdown-{{med.RelVisitMedicationId}}-{{medAction.Id}}">\r\n                                {{medAction.Name}}\r\n                            </li>\r\n                        </ul>\r\n                    </div>\r\n                </td>\r\n            </tr>\r\n            <tr ng-repeat="flattenedItem in $ctrl.flattenedRxHistory.items"\r\n                ng-class="$ctrl.getFlattenedItemClass(flattenedItem)"\r\n                ng-if="!$ctrl.loadingMedicationHistory && !$ctrl.loadMedicationHistoryError && $ctrl.shouldShowFlattenedItem(flattenedItem)"\r\n                ng-show="$ctrl.shouldShowFlattenedItem(flattenedItem)">\r\n\r\n                <td colspan="6" ng-if="flattenedItem.type === \'Group\'">\r\n                    <span>{{::flattenedItem.group.Header.Title}}</span>\r\n                    <i ng-class="flattenedItem.isCollapsed ? \'ap-chevron-up-blue\' : \'ap-chevron-down-blue\'"\r\n                       ng-click="$ctrl.collapseFlattenedItem(flattenedItem)"></i>\r\n                </td>\r\n\r\n                <td colspan="2" ng-if="flattenedItem.type !== \'Group\'">\r\n                    <div>\r\n                        <input type="checkbox"\r\n                                name="med{{flattenedItem.rxHistoryMed.RelPatientMedicationUid}}"\r\n                                id="med{{flattenedItem.rxHistoryMed.RelPatientMedicationUid}}"\r\n                                ng-model="flattenedItem.rxHistoryMed.IsSelected"\r\n                                ng-change="$ctrl.updateSelected()">\r\n                        <label class="lg-touch fnc-rx-medication-text"\r\n                               for="med{{flattenedItem.rxHistoryMed.RelPatientMedicationUid}}">\r\n                               \r\n                            {{:: flattenedItem.rxHistoryMed.Description }}\r\n\r\n                        </label>\r\n                        <a class="grouped-indicator pull-right"\r\n                            ng-click="$ctrl.collapseFlattenedItem(flattenedItem)"\r\n                            ng-if="flattenedItem.totalChildren">{{::flattenedItem.totalChildren}}\r\n                        </a>\r\n                        <a class="ap-information clickable pull-right strikeout-hide"\r\n                            ng-click="$ctrl.openRxInfo(flattenedItem.rxHistoryMed)">\r\n                        </a>\r\n                    </div>\r\n                </td>\r\n                <td ng-if="flattenedItem.type !== \'Group\'">\r\n                    {{:: flattenedItem.rxHistoryMed.ProviderName || \'&nbsp;\' }}\r\n                </td>\r\n                <td ng-if="flattenedItem.type !== \'Group\'">\r\n                    {{:: flattenedItem.rxHistoryMed.StopDateDescription || \'&nbsp;\' }}\r\n                </td>\r\n                <td ng-if="flattenedItem.type !== \'Group\'">\r\n                    <med-status-icon\r\n                        class="strikeout-hide"\r\n                        data-med-status="flattenedItem.rxHistoryMed.status"\r\n                        data-icon-size="1"\r\n                        data-has-details="true"\r\n                        data-other-class="img-center-h"\r\n                        data-med-type="patient">\r\n                    </med-status-icon>\r\n                </td>\r\n                <td ng-if="flattenedItem.type !== \'Group\'">\r\n                    <div class="dropdown dropdown-v18 dropdown-actions strikeout-hide">\r\n                        <button type="button"\r\n                                class="dropdown-actions-button"\r\n                                data-toggle="dropdown"\r\n                                id="rx-history-med-dropdown-{{flattenedItem.rxHistoryMed.RelPatientMedicationUid}}">\r\n                            <div class="ap-actions-ellipsis"></div>\r\n                        </button>\r\n                        <ul class="dropdown-menu dropdown-menu-right">\r\n                            <li class="clickable" \r\n                                ng-if="!flattenedItem || !medAction.Hide || !medAction.Hide(flattenedItem.rxHistoryMed)"\r\n                                ng-repeat="medAction in $ctrl.medicationActions" ng-click="medAction.Action(flattenedItem.rxHistoryMed)"\r\n                                id="rx-history-med-action-dropdown-{{flattenedItem.rxHistoryMed.RelPatientMedicationUid}}-{{medAction.Id}}">\r\n                                {{medAction.Name}}\r\n                            </li>\r\n                        </ul>\r\n                    </div>\r\n                </td>\r\n            </tr>\r\n        </tbody>\r\n    </table>\r\n</div>'),$templateCache.put("/fnc/tabs/hx/medication/component-views/hxMedicationDiscontinueCancel.html",'<div id="medication-discontinue-cancel-component" class="discontinue-cancel-content">\r\n    <div class="row">\r\n        <div class="col-xs-12">\r\n            <table class="table table-v18">\r\n                <thead>\r\n                    <tr>\r\n                        <th style="width:25%">{{::\'Medication Name\' | translate}}</th>\r\n                        <th style="width:10%">{{::\'Start\' | translate}}</th>\r\n                        <th style="width:10%">{{::\'End\' | translate}}</th>\r\n                        <th style="width:25%">{{::\'Reason\' | translate}}</th>\r\n                        <th style="width:5%">{{::\'Cancel\'}}</th>\r\n\r\n                        <th style="width:25%">\r\n                            \x3c!--  {{::\'Pharmacy\' | translate}}  --\x3e\r\n                            <div class="pull-left">\r\n                                <input type="checkbox"\r\n                                       id="mdc-select-all-pharmacies"\r\n                                       name="select-all-pharmacies"\r\n                                       ng-model="$ctrl.selectAllPharmacies"\r\n                                       ng-change="$ctrl.onClickSelectAllPharmacies()"\r\n                                       ap-checkbox-hidden-label="Select All">\r\n                                <button type="button"\r\n                                        id="mdc-search-pharmacies-btn"\r\n                                        name="search-pharmacies-btn"\r\n                                        class="fnc-rx-header-btn"\r\n                                        ng-class="$ctrl.changePharmacyEnabled ? \'enable\' : \'disable\'"\r\n                                        ng-click="$ctrl.onClickSearchPharmacies()">\r\n                                    <div class="fnc-rx-header-btn-text">\r\n                                        {{::\'Change\' | translate}}\r\n                                    </div>\r\n                                </button>\r\n                            </div>\r\n                            {{::\'Pharmacy\' | translate}}\r\n                        </th>\r\n\r\n                    </tr>\r\n                </thead>\r\n\r\n                <tbody>\r\n                    \x3c!-- List of medications to discontinue and/or cancel --\x3e\r\n                    <tr id="mdc-{{med.RelPatientMedicationId}}" ng-repeat="med in $ctrl.medications track by med.RelPatientMedicationId">\r\n                        \x3c!-- Medication Name --\x3e\r\n                        <td>\r\n                            <div class="form-group" id="mdc-drugname-{{med.RelPatientMedicationId}}">\r\n                                {{:: med.Description}}\r\n                                <a class="ap-information clickable pull-right" ng-click="$ctrl.onClickDisplayDetailView(med)"></a>\r\n                            </div>\r\n                        </td>\r\n\r\n                        \x3c!-- Start Date --\x3e\r\n                        <td class="text-center">\r\n                            <div class="form-group" id="mdc-startdate-{{med.RelPatientMedicationId}}">\r\n                                <ap-date-formatter date="{{:: med.StartDate || \' \'}}" format="date"/>\r\n                            </div>\r\n                        </td>\r\n\r\n                        \x3c!-- End Date --\x3e\r\n                        <td class="text-center" ng-click="$ctrl.onClickDisplayDiscontinueMessages(med)" ng-if="!med.IsFutureStartDate">\r\n                            <div class="form-group">\r\n                                <input id="mdc-stopdate-{{med.RelPatientMedicationId}}"\r\n                                       name="mdc-stopdate-{{med.RelPatientMedicationId}}"\r\n                                       type="date"\r\n                                       class="form-control"\r\n                                       ng-class="(med.CanDiscontinueMedication) ? \'cursor-default\' : \'cursor-not-allowed\'"\r\n                                       min="{{med.MinStopDate}}"\r\n                                       max="9998-12-31"\r\n                                       ap-required="false"\r\n                                       ng-model="med.StopDate"\r\n                                       ng-model-options="{ updateOn: \'blur\', allowInvalid: 1 }"\r\n                                       ng-disabled="!med.CanDiscontinueMedication">\r\n                                </input>\r\n                            </div>\r\n                        </td>\r\n                        <td class="text-center" ng-if="med.IsFutureStartDate">\r\n                            <div class="form-group" id="mdc-stopdate-{{med.RelPatientMedicationId}}">\r\n                                <ap-date-formatter date="{{:: med.StopDate || \' \'}}" format="date"/>\r\n                            </div>\r\n                        </td>\r\n\r\n                        \x3c!-- Discontinue Reason --\x3e\r\n                        <td ng-click="$ctrl.onClickDisplayDiscontinueMessages(med)">\r\n                            <div class="form-group">\r\n                                <div class="col-xs-12 col-flush discontinue-cancel-flex-row-center">\r\n                                    <div class="col-xs-10 col-flush pull-left">\r\n                                        <ap-select>\r\n                                            <select id="mdc-discontinue-reason-{{med.RelPatientMedicationId}}"\r\n                                                    class="form-control"\r\n                                                    ng-class="(med.CanDiscontinueMedication) ? \'cursor-default\' : \'cursor-not-allowed\'"\r\n                                                    ng-model="med.DiscontinueReasonId"\r\n                                                    ng-options="reason.Id as reason.Name for reason in $ctrl.discontinueReasonList"\r\n                                                    ng-change="$ctrl.onDiscontinueReasonTypeChanged(med)"\r\n                                                    ng-disabled="!med.CanDiscontinueMedication">\r\n                                            </select>\r\n                                        </ap-select>\r\n                                    </div>\r\n                                    <div class="col-xs-2 col-flush"\r\n                                         ng-class="{\'not-available discontinue-cancel-flex-center pull-right\':!med.CanDiscontinueMedication}">\r\n                                        <i class="clipboard pull-right"\r\n                                           ng-class="(med.CanDiscontinueMedication) ? \'cursor-default clickable\' : \'cursor-not-allowed\'"\r\n                                           id="mdc-discontinue-reason-notes-editor-{{med.RelPatientMedicationId}}"\r\n                                           ng-click="$ctrl.onClickDiscontinueReasonClipboard(med)"\r\n                                           ng-disabled="!med.CanDiscontinueMedication"></i>\r\n                                    </div>\r\n                                </div>\r\n                            </div>\r\n                        </td>\r\n\r\n                        \x3c!-- Cancel Check box --\x3e\r\n                        <td class="text-center">\r\n                            <div class="discontinue-cancel-flex-center" ng-class="{\'not-available cursor-not-allowed\':!med.CanCancelMedication}">\r\n                                <input type="checkbox"\r\n                                       ng-class="{\'position-inherit cursor-not-allowed\':!med.CanCancelMedication}"\r\n                                       id="mdc-cancel-{{med.RelPatientMedicationId}}"\r\n                                       ng-model="med.SendCancelMessage"\r\n                                       ng-click="$ctrl.onClickDisplayCancelErrorMessages(med, \'inner element\')"\r\n                                       ap-checkbox-hidden-label="Cancel Medication">\r\n                            </div>\r\n                        </td>\r\n\r\n                        \x3c!-- Pharmacy that receives cancel message --\x3e\r\n                        <td>\r\n                            <div>\r\n                                <input type="checkbox"\r\n                                       id="mdc-selected-pharmacy-{{med.RelPatientMedicationId}}"\r\n                                       ng-model="med.PharmacySelected"\r\n                                       ng-change="$ctrl.updateSelectAllPharmacies()"\r\n                                       ng-disabled="!med.CanCancelMedication"\r\n                                       ap-checkbox-label="{{med.Pharmacy.Name}}">\r\n                            </div>\r\n                            \x3c!--\r\n                            <div class="form-group">\r\n                                <ap-find-pharmacy\r\n                                    id="mdc-pharmacy-{{med.RelPatientMedicationId}}"\r\n                                    select-disabled="false"\r\n                                    ng-model="med.Pharmacy"\r\n                                    data-patient-id="$ctrl.patientId"\r\n                                    default-list="true">\r\n                                </ap-find-pharmacy>\r\n                            </div>\r\n                            --\x3e\r\n                        </td>\r\n                    </tr>\r\n                </tbody>\r\n            </table>\r\n        </div>\r\n    </div>\r\n\r\n    \x3c!-- Provider List  --\x3e\r\n    <div class="row">\r\n        <div class="col-xs-12 discontinue-cancel-flex-row-end padding-top-15">\r\n            <span class="discontinue-cancel-spinner" ng-if="$ctrl.loadingProviderList"><ap-spinner size="1"></ap-spinner></span>\r\n            <label class="control-label padding-right-10">{{::\'Provider\' | translate}}</label>\r\n            <ap-select>\r\n                <select id="mdc-provider-list"\r\n                        class="form-control width-175"\r\n                        ng-change="$ctrl.onChangeProvider()"\r\n                        ng-model="$ctrl.selectedIds.providerId"\r\n                        ng-options="provider.Id as provider.Description for provider in $ctrl.providers">\r\n                </select>\r\n            </ap-select>\r\n        </div>\r\n    </div>\r\n\r\n    \x3c!-- Supervising Provider List --\x3e\r\n    <div class="row">\r\n        <div class="col-xs-12 discontinue-cancel-flex-row-end padding-top-15">\r\n            <span class="discontinue-cancel-spinner" ng-if="$ctrl.loadingSupervisorList"><ap-spinner size="1"></ap-spinner></span>\r\n            <label class="control-label padding-right-10">{{::\'Supervising Provider\' | translate}}</label>\r\n            <ap-select>\r\n                <select id="mdc-supervisor-list"\r\n                        class="form-control width-175"\r\n                        ng-model="$ctrl.selectedIds.supervisorId"\r\n                        ng-options="supervisor.SupervisorId as supervisor.SupervisorName for supervisor in $ctrl.supervisorList">\r\n                </select>\r\n            </ap-select>\r\n        </div>\r\n    </div>\r\n\r\n    \x3c!-- Service Site List --\x3e\r\n    <div class="row">\r\n        <div class="col-xs-12 discontinue-cancel-flex-row-end padding-top-15">\r\n            <span class="discontinue-cancel-spinner" ng-if="$ctrl.loadingServiceSiteList"><ap-spinner size="1"></ap-spinner></span>\r\n            <label class="control-label padding-right-10">{{::\'Service Site\' | translate}}</label>\r\n            <ap-select>\r\n                <select id="mdc-service-site-list"\r\n                        class="form-control width-175"\r\n                        ng-model="$ctrl.selectedIds.serviceSiteId"\r\n                        ng-options="serviceSite.Id as serviceSite.Name for serviceSite in $ctrl.serviceSiteList">\r\n                </select>\r\n            </ap-select>\r\n        </div>\r\n    </div>\r\n\r\n</div>'),$templateCache.put("/fnc/tabs/hx/medication/component-views/medStatusIcon.html",'<div ng-click="vm.showDetails()"\r\n     ng-class="vm.getClass()">\r\n</div>'),$templateCache.put("/fnc/tabs/hx/medication/views/hxDrugReactionModal.html",'<div id="hx-drug-reaction-modal" ap-full-modal class="modal-v18">\r\n\r\n    <form class="desktop-form" ng-submit="vm.onClickSubmitButton(drugReactionForm)" name="drugReactionForm" novalidate>\r\n        <div class="modal-header">\r\n            <div class="row">\r\n                <div class="col-xs-8 heading-title modal-title">{{\'Select drug reaction:\' | translate}}</div>\r\n                <button id="drm-close-x" type="button" class="close" ng-click="vm.onClickCancelButton()">&times;</button>\r\n            </div>\r\n        </div>\r\n\r\n\r\n        <div class="modal-body">\r\n            <div class="panel panel-discontinue-cancel">\r\n                <div class="panel-body">\r\n\r\n                    <div id="drm-loading" ng-if="vm.loadingDrugReaction">\r\n                        <div class="row">\r\n                            <div class="col-xs-12 text-center">\r\n                                {{:: \'Loading drug reaction list\' | translate}}\r\n                                <br/>\r\n                                <ap-spinner data-size="3"></ap-spinner>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n\r\n                    <div id="drm-content" class="discontinue-cancel-content" ng-if="!vm.loadingDrugReaction">\r\n                        <div class="row">\r\n                            <div class="col-xs-12">\r\n                                <table class="table table-v18">\r\n                                    <thead>\r\n                                        <tr>\r\n                                            <th style="width:5%">{{::\'Select\' | translate}}</th>\r\n                                            <th style="width:95%">{{::\'Reaction\' | translate}}</th>\r\n                                        </tr>\r\n                                    </thead>\r\n\r\n                                    <tbody>\r\n                                         <tr id="drm-drug-reaction-{{drugReaction.Id}}" ng-repeat="drugReaction in vm.drugReactionList">\r\n                                             \x3c!-- Select checkbox --\x3e\r\n                                             <td class="text-center">\r\n                                                 <div>\r\n                                                     <input type="checkbox"\r\n                                                            id="drm-select-{{drugReaction.Id}}"\r\n                                                            ng-model="drugReaction.IsSelected"\r\n                                                            ap-checkbox-hidden-label="Select {{::drugReaction.Name}}">\r\n                                                 </div>\r\n                                             </td>\r\n\r\n                                             \x3c!-- Drug Reaction --\x3e\r\n                                             <td>\r\n                                                 <div class="form-group" id="drm-drug-reaction-text-{{drugReaction.Id}}">\r\n                                                     {{::drugReaction.Name}}\r\n                                                 </div>\r\n                                             </td>\r\n                                         </tr>\r\n                                    </tbody>\r\n                                </table>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n\r\n                </div>\r\n            </div>\r\n        </div>\r\n\r\n        <div class="modal-footer modal-footer-drug-reaction">\r\n            <span class="pull-left padding-left-30">\r\n                <i class="clipboard pull-left clickable"\r\n                   id="drm-drug-reaction-notes-editor"\r\n                   ng-click="vm.onClickDrugReactionClipboard()"></i>\r\n            </span>\r\n\r\n            <span ng-class="vm.shouldSwapButtons() ? \'prm-button-order\' : \'\'">\r\n                <button id="drm-cancel" type="button" class="btn btn-primary btn-drug-reaction" ng-click="vm.onClickCancelButton()">{{::\'Cancel\' | translate}}</button>\r\n                <button id="drm-save"   type="submit" class="btn btn-primary btn-drug-reaction">\r\n                    <span ng-hide="vm.submittingDrugReactionRequest">{{::\'Save\' | translate}}</span>\r\n                    <ap-spinner ng-show="vm.submittingDrugReactionRequest"></ap-spinner>\r\n                </button>\r\n            </span>\r\n        </div>\r\n    </form>\r\n</div>'),$templateCache.put("/fnc/tabs/hx/medication/views/hxMedicationDiscontinueCancelModal.html",'<div id="hx-medication-discontinue-cancel-modal" ap-full-modal class="modal-v18">\r\n\r\n    <form class="desktop-form" ng-submit="vm.onClickSubmitButton()" name="vm.medicationDiscontinueCancelForm" novalidate>\r\n        <div class="modal-header">\r\n            <div class="row">\r\n                <div class="col-xs-8 heading-title modal-title">{{\'Discontinue the following:\' | translate}}</div>\r\n                <button id="mdcm-close-x" type="button" class="close" ng-click="vm.onClickCancelButton()">&times;</button>\r\n            </div>\r\n        </div>\r\n\r\n        <div class="modal-body">\r\n            <div class="panel panel-discontinue-cancel">\r\n                <div class="panel-body">\r\n                    <div id="mdcm-loading" ng-if="vm.loadingDiscontinueCancel">\r\n                        <div class="row">\r\n                            <div class="col-xs-12 text-center">\r\n                                {{:: \'Loading Selected Patient Medications\' | translate}}\r\n                                <br/>\r\n                                <ap-spinner data-size="3"></ap-spinner>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n\r\n                    <div id="mdcm-error" ng-if="!vm.loadingDiscontinueCancel && vm.loadingDiscontinueCancelError">\r\n                        <h4 translate>Error Loading Selected Patient Medication to Discontinue and Cancel:</h4>\r\n                        <span ng-repeat="errorText in vm.loadingDiscontinueCancelError track by $index"><br>{{errorText}}</span>\r\n                    </div>\r\n\r\n                    <div id="mdcm-content" ng-if="!vm.loadingDiscontinueCancel && !vm.loadingDiscontinueCancelError">\r\n                        <hx-medication-discontinue-cancel\r\n                            patient-id="vm.patientId"\r\n                            visit-id="vm.visitId"\r\n                            medications="vm.medications"\r\n                            providers="vm.providers"\r\n                            selected-ids="vm.selectedIds"\r\n                            form-reference="vm.medicationDiscontinueCancelForm"\r\n                            default-provider-ids="vm.defaultProviderIds">\r\n                        </hx-medication-discontinue-cancel>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n\r\n        <div class="modal-footer modal-footer-multi-button" ng-class="vm.shouldSwapButtons() ? \'prm-button-order\' : \'\'">\r\n            <button id="mdcm-cancel" type="button" class="btn btn-primary" ng-click="vm.onClickCancelButton()">{{\'Cancel\' | translate}}</button>\r\n            <button id="mdcm-save"   type="submit" class="btn btn-primary">\r\n                <span ng-hide="vm.submittingDiscontinueCancelRequest">{{::\'Save\' | translate}}</span>\r\n                <ap-spinner ng-show="vm.submittingDiscontinueCancelRequest"></ap-spinner>\r\n            </button>\r\n        </div>\r\n    </form>\r\n</div>'),$templateCache.put("/fnc/tabs/hx/medication/views/hxMedicationDiscontinueCancelWarningModal.html",'<div id="hx-medication-discontinue-cancel-warning-modal" ap-full-modal class="modal-v18">\r\n\r\n    <div class="modal-header">\r\n        <div class="row">\r\n            <div class="col-xs-8 heading-title modal-title">\r\n                <span ng-if="vm.warningType === \'CANCEL\'">{{::\'Please address the following:\' | translate}}</span>\r\n                <span ng-if="vm.warningType === \'DISCONTINUE\'">{{::\'Medication status:\' | translate}}</span>\r\n                <span ng-if="vm.warningType === \'SUBMIT-REQUEST\'">{{::\'Please address the following:\'}}</span>\r\n            </div>\r\n            <button id="mdcwm-close-x" type="button" class="close" ng-click="vm.onClickCloseButton()">&times;</button>\r\n        </div>\r\n    </div>\r\n\r\n    <div class="modal-body">\r\n        <div class="panel panel-discontinue-cancel">\r\n            <div class="panel-body">\r\n                <div id="mdcwm-loading" ng-if="vm.loadingView">\r\n                    <div class="row">\r\n                        <div class="col-xs-12 text-center">\r\n                            {{:: \'Loading Warning Messages\' | translate}}\r\n                            <br/>\r\n                            <ap-spinner data-size="3"></ap-spinner>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n\r\n                <div id="mdcm-error" ng-if="!vm.loadingView && vm.loadingViewError">\r\n                    <h4 translate>Error Loading Discontinue and Cancel Warning Messages:</h4>\r\n                    <span ng-repeat="errorText in vm.loadingError track by $index"><br>{{errorText}}</span>\r\n                </div>\r\n\r\n\r\n                <div id="mdcwm-content" class="discontinue-cancel-content" ng-if="!vm.loadingView">\r\n                    <div class="row">\r\n                        <div class="col-xs-12">\r\n                            <table class="table table-v18">\r\n                                <thead>\r\n                                    <tr>\r\n                                        <th style="width:30%">{{::\'Medication Name\' | translate}}</th>\r\n                                        <th style="width:70%">{{::\'Reason\' | translate}}</th>\r\n                                    </tr>\r\n                                </thead>\r\n\r\n                                <tbody>\r\n                                    <tr id="mdcwm-{{warning.RelPatientMedicationId}}" ng-repeat="warning in vm.warnings | filter: vm.filterIncludeOnlyErrors track by warning.RelPatientMedicationId">\r\n                                        <td class="form-group" id="mdcwm-warning-drugname-{{warning.RelPatientMedicationId}}">\r\n                                            {{:: warning.Description || \' \'}}\r\n                                        </td>\r\n                                        <td class="form-group" id="mdcwm-warning-message-{{warning.RelPatientMedicationId}}">\r\n                                            <div ng-if="warning.DiscontinueMedicationErrors.length > 0"\r\n                                                 id="mdcwm-discontinue-warning-{{warning.RelPatientMedicationId}}-{{$index}}"\r\n                                                 ng-repeat="discontinueWarning in warning.DiscontinueMedicationErrors">\r\n                                                    {{:: discontinueWarning }}\r\n                                            </div>\r\n\r\n                                            <div ng-if="warning.CancelMedicationErrors.length > 0"\r\n                                                 id="mdcwm-cancel-warning-{{warning.RelPatientMedicationId}}-{{$index}}"\r\n                                                 ng-repeat="cancelWarning in warning.CancelMedicationErrors">\r\n                                                    {{:: cancelWarning }}\r\n                                            </div>\r\n                                        </td>\r\n                                    </tr>\r\n                                </tbody>\r\n                            </table>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n\r\n            </div>\r\n        </div>\r\n    </div>\r\n\r\n</div>'),$templateCache.put("/fnc/tabs/hx/medication/views/hxPatientFormularyModal.html",'<div id="hx-patient-formulary-modal" ap-full-modal ap-full-modal-always>\r\n    <div class="modal-header">\r\n        <button id="hpfm-close-x" type="button" class="close" ng-click="vm.cancel()">&times;</button>\r\n        <h4 class="modal-title" translate>Patient Formulary</h4>\r\n    </div>\r\n    <div class="modal-body">\r\n        <div id="patient-formulary-loading" ng-if="vm.loadingPatientFormulary">\r\n            <div class="row">\r\n                <div class="col-xs-12 text-center">\r\n                    Loading Patient Formulary\r\n                    <br/>\r\n                    <ap-spinner data-size="3"></ap-spinner>\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div id="patient-formulary-error" ng-if="!vm.loadingPatientFormulary && vm.formularyErrorMessages">\r\n            <h4 translate>Error Loading Patient Formulary:</h4>\r\n            <span ng-repeat="errorText in vm.formularyErrorMessages track by $index"><br>{{errorText}}</span>\r\n        </div>\r\n        <div id="patient-formulary-content" ng-if="!vm.loadingPatientFormulary && !vm.formularyErrorMessages">\r\n            <patient-rx-benefits\r\n                rx-benefits="vm.rxBenefits"\r\n            />\r\n        </div>\r\n    </div>\r\n    <div class="modal-footer modal-footer-multi-button" ng-class="vm.shouldSwapButtons() ? \'prm-button-order\' : \'\'">\r\n        <button id="hpfm-cancel" class="btn" ng-click="vm.cancel()" translate>Cancel</button>\r\n        <button id="hpfm-ok" class="btn btn-primary" ng-click="vm.ok()" translate>OK</button>\r\n    </div>\r\n</div>'),$templateCache.put("/fnc/tabs/hx/medication/views/hxSigwriterModal.html",'<div ap-full-modal ap-full-modal-always>\r\n    <div class="modal-body modal-body-no-padding">\r\n        <sigwriter-tablet-shell\r\n            options="vm.options"\r\n            canceled="vm.cancel()"\r\n            completed="vm.completed(rx)"\r\n        />\r\n    </div>\r\n</div>'),$templateCache.put("/fnc/tabs/hx/medication/views/medStatusModal.html",'<div ap-full-modal>\r\n    <div class="modal-body modal-blue">\r\n        <med-status-icon\r\n            data-med-status="vm.medStatus"\r\n            data-icon-size="2"\r\n            data-other-class="img-center-h"\r\n            data-med-type="{{vm.medType}}">\r\n        </med-status-icon>\r\n        <div class="text-center modal-spacing-top">\r\n            {{vm.medStatus.StatusMessage}}\r\n        </div>\r\n    </div>\r\n    <div class="modal-footer modal-footer-multi-button modal-footer-center">\r\n        <button type="button"\r\n                 class="btn btn-primary"\r\n                 ng-click="vm.done()"\r\n                 translate>\r\n            OK\r\n        </button>\r\n    </div>\r\n</div>'),$templateCache.put("/fnc/tabs/plan/component-views/fncPlan.html",'<div id="fnc-plan" ng-class="{\'fixed-footer-present\': $ctrl.isBasicInactiveHx}">\r\n    <div class="row">\r\n        <div ng-class="$ctrl.showPatientWidgets ? \'col-xs-8\' : \'col-xs-12\'" ng-show="$ctrl.loadingPlans">\r\n            <div class="spinner-container text-center">\r\n\t\t\t\t<ap-spinner size="4"></ap-spinner>\r\n            </div>\r\n        </div>\r\n        <div ng-class="$ctrl.showPatientWidgets ? \'col-xs-8\' : \'col-xs-12\'" class="ng-hide" ng-show="$ctrl.plansHttpError && !$ctrl.loadingPlans">\r\n            <uib-alert type="danger">\r\n                {{::"An error has occurred and the plans could not be loaded." | translate}}\r\n            </uib-alert>\r\n        </div>\r\n        <div ng-class="$ctrl.showPatientWidgets ? \'col-xs-8\' : \'col-xs-12\'" class="ng-hide" ng-hide="$ctrl.plansHttpError || $ctrl.loadingPlans">\r\n            <div class="row">\r\n                <div class="col-sm-2 col-md-1">\r\n                    <label class="plan-section-label">\r\n                        <span>{{::"Plan" | translate}}</span>\r\n                    </label>\r\n                </div>\r\n                <div class="col-sm-10 col-md-11">\r\n                    <div class="row">\r\n                        <div class="col-xs-12">\r\n                            <div id="plans" class="list-group">\r\n                                <div ng-repeat="planItem in $ctrl.plans | orderBy:\'DisplayOrder\'"\r\n                                     ng-drop="!$ctrl.draggingItem.IsFromHistory"\r\n                                     ng-drop-success="$ctrl.reorderPlan($data, planItem)">\r\n\r\n                                    <fnc-plan-tile\r\n                                        configurable="true"\r\n                                        hosted-from-desktop="$ctrl.hostedFromDesktop"\r\n                                        is-draggable="!$ctrl.isReadonly"\r\n                                        is-readonly="$ctrl.isReadonly"\r\n                                        is-selected="$ctrl.selectedPlanItem === planItem"\r\n                                        patient-id="$ctrl.patientId"\r\n                                        plan-item="planItem"\r\n                                        visit-id="$ctrl.visitId"\r\n                                        incremental-save="$ctrl.incrementalSave(planItem)"\r\n                                        on-drag-start="$ctrl.dragStart(planItem)"\r\n                                        save="$ctrl.save(planItem, skipValidation)"\r\n                                        select="$ctrl.selectPlanItem(planItem)"\r\n                                        unselect="$ctrl.selectPlanItem(null)"\r\n                                    />\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n            <div class="row">\r\n                <div class="col-xs-12">\r\n                    <hr class="history-hr" />\r\n                </div>\r\n            </div>\r\n            <div class="row">\r\n                <div class="col-sm-2 col-md-1">\r\n                    <label class="plan-section-label">\r\n                        <span translate>Active Hx</span>\r\n                    </label>\r\n                </div>\r\n                <div class="col-sm-10 col-md-11">\r\n                    <div class="row">\r\n                        <div class="col-xs-12">\r\n                            <div id="activeHxs" class="list-group">\r\n                                <div class="list-group-item" ng-hide="$ctrl.activeHxs.length">\r\n                                    <div class="text-center-vert text-center">\r\n                                        <span translate>No Active Hx items</span>\r\n                                    </div>\r\n                                </div>\r\n                                <fnc-plan-tile\r\n                                    ng-repeat="activeHx in $ctrl.activeHxs"\r\n                                    hosted-from-desktop="$ctrl.hostedFromDesktop"\r\n                                    is-draggable="!$ctrl.isReadonly"\r\n                                    is-readonly="$ctrl.isReadonly"\r\n                                    plan-item="activeHx"\r\n                                    on-drag-start="$ctrl.dragStart(planItem)"\r\n                                />\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n            <div id="visibilityTracker"></div>\r\n            <div class="ng-hide" ng-hide="$ctrl.isBasicInactiveHx">\r\n                <div class="row">\r\n                    <div class="col-xs-12">\r\n                        <hr class="inactive-hr" />\r\n                    </div>\r\n                </div>\r\n                <div class="row fill-remaining" ng-drop="$ctrl.draggingItem.IsFromHistory" ng-drop-success="$ctrl.inactivatePlan($data)">\r\n                    <div class="col-sm-2 col-md-1">\r\n                        <label class="plan-section-label">\r\n                            <span translate>Inactive Hx</span>\r\n                        </label>\r\n                    </div>\r\n                    <div class="col-sm-10 col-md-11">\r\n                        <div class="row">\r\n                            <div class="col-xs-12">\r\n                                <div id="inactivePlans" class="list-group">\r\n                                    <div class="list-group-item" ng-hide="$ctrl.inactivePlans.length">\r\n                                        <div class="text-center-vert text-center">\r\n                                            <span translate>Drag Active Hx items here to inactivate them</span>\r\n                                        </div>\r\n                                    </div>\r\n                                    <fnc-plan-tile\r\n                                        ng-repeat="planItem in $ctrl.inactivePlans"\r\n                                        hosted-from-desktop="$ctrl.hostedFromDesktop"\r\n                                        is-readonly="$ctrl.isReadonly"\r\n                                        plan-item="planItem"\r\n                                    />\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n\r\n        <div id="patient-widgets" class="col-sm-4 col-flush-right" ng-if="$ctrl.showPatientWidgets">\r\n            <ap-tile-manager data-group-name="\'planTab\'">\r\n                <div ng-repeat="widget in $ctrl.widgets track by widget.Id" ng-init="tile=widget">\r\n                    <ap-tile data-default-collapsed="widget.IsCollapsed" data-tile-id="widget.Id" data-scroller="patient-widgets" data-top-offset="0" data-bottom-offset="0">\r\n                        <ng-include src="widget.view"></ng-include>\r\n                    </ap-tile>\r\n                </div>\r\n            </ap-tile-manager>\r\n        </div>\r\n    </div>\r\n    <div class="navbar navbar-default navbar-fixed-bottom"\r\n         ng-show="$ctrl.isBasicInactiveHx"\r\n         ng-drop="$ctrl.draggingItem.IsFromHistory"\r\n         ng-drop-success="$ctrl.inactivatePlan($data)">\r\n\r\n        <div class="container-fluid">\r\n            <div class="row">\r\n                <div class="col-xs-12">\r\n                    <hr class="inactive-hr" />\r\n                </div>\r\n            </div>\r\n            <div class="row">\r\n                <div class="col-sm-2 col-md-1">\r\n                    <label class="plan-section-label">\r\n                        <span translate>Inactive Hx</span>\r\n                    </label>\r\n                </div>\r\n                <div class="col-sm-10 col-md-11">\r\n                    <div>\r\n                        <span ng-hide="$ctrl.inactivePlans.length" translate>Drag Active Hx items here to inactivate them</span>\r\n                        <span class="ng-hide" ng-show="$ctrl.inactivePlans.length" translate>{{$ctrl.inactivePlans.length}} item(s) have been inactivated</span>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>\r\n'),$templateCache.put("/fnc/tabs/plan/component-views/fncPlanLegacyNotesWidget.html",'<div id="fncPlanLegacyNotesWidget" ng-if="!$ctrl.hostedFromDesktop">\r\n    <tinymce\r\n        tinymce-model="$ctrl.tinymceModel"\r\n        visit-comment-type="$ctrl.visitCommentType"\r\n        on-save="$ctrl.onSave(tinymceModel)"\r\n        on-clear="$ctrl.onClear()"\r\n    />\r\n</div>\r\n<div id="fncPlanLegacyNotesWidget" ng-if="$ctrl.hostedFromDesktop">\r\n    <div class="row">\r\n        <div class="col-sm-12">\r\n            <button type="button" class="btn btn-default" ng-click="$ctrl.edit()">\r\n                <span class="ap-new-note"></span>\r\n            </button>\r\n        </div>\r\n    </div>\r\n    <div class="row">\r\n        <div class="col-sm-12">\r\n            <span>{{$ctrl.item.parsedSelectionValue.preview}}</span>\r\n        </div>\r\n    </div>\r\n</div>'),$templateCache.put("/fnc/tabs/plan/component-views/fncPlanOptionsSelection.html",'<div id="fncPlanOptions">\r\n    <div class="row plan-chosen-options">\r\n        <div class="col-xs-12">\r\n            <div class="plan-chosen-options-container">\r\n                <div dx-start-with="$ctrl.customPlanConfiguration">\r\n                    <table st-table class="table table-striped">\r\n                        <thead ng-if="$dxIsRoot">\r\n                            <tr>\r\n                                <th st-ratio="(10 * ($dxLevel + 1))">Description</th>\r\n                                <th st-ratio="(100 - (10 * ($dxLevel + 1)))">Notes</th>\r\n                                <th></th>\r\n                                <th></th>\r\n                            </tr>\r\n                        </thead>\r\n                        <tbody>\r\n                            <tr ng-if="$dxIsRoot && !$dxPrior.totalSelected">\r\n                                <td colspan="3">\r\n                                    <div class="text-center empty-options-row">\r\n                                        <span translate>Add information by selecting options below.</span>\r\n                                    </div>\r\n                                </td>\r\n                            </tr>\r\n                            <tr ng-repeat="option in $dxPrior.Options" ng-show="option.totalSelected"\r\n                                id="diagnosis-{{::$ctrl.parent.planItem.VisitDiagnosisUid||\'null\'}}-plan-chosen-item-{{::option.Id}}"\r\n                                class="vert-align-td">\r\n\r\n                                <td st-ratio="option.IsLeafNode ? 50 : (10 * ($dxLevel + 1))">\r\n                                    <textarea\r\n                                        class="form-control"\r\n                                        ng-if="option.IsLeafNode && option.totalSelected"\r\n                                        ng-model="option.Name"\r\n                                        placeholder="Description"\r\n                                        rows="1"\r\n                                        ng-readonly="$ctrl.isReadonly"\r\n                                        ap-tab-to-str\r\n                                        ap-focus-str\r\n                                        ap-auto-grow\r\n                                        fnc-plan-options-selection-auto-save/>\r\n                                    <span ng-if="!option.IsLeafNode">{{option.NodeName}}</span>\r\n                                </td>\r\n                                <td colspan="2" ng-if="!option.IsLeafNode && option.totalSelected" st-ratio="(100 - (10 * ($dxLevel + 1)))" class="no-padding">\r\n                                    <div dx-connect="option"></div>\r\n                                </td>\r\n                                <td ng-if="option.IsLeafNode && option.totalSelected" st-ratio="50">\r\n                                    <textarea class="form-control" maxlength="8192"\r\n                                           ng-model="option.Notes" fnc-plan-options-selection-auto-save\r\n                                           placeholder="Notes"\r\n                                           ng-readonly="$ctrl.isReadonly"\r\n                                           rows="1"\r\n                                           ap-auto-grow\r\n                                           ng-if="$ctrl.shouldAllowNotes(option)" />\r\n                                </td>\r\n                                <td ng-if="option.IsLeafNode && option.totalSelected && $ctrl.shouldAllowNotes(option)">\r\n                                    <i class="ap-dictation-2"\r\n                                       ng-click="$ctrl.openFullSelectionNotesEditor(option)"\r\n                                       ng-hide="$ctrl.isReadonly"></i>\r\n                                </td>\r\n                                <td ng-if="option.IsLeafNode && option.totalSelected">\r\n                                    <i class="icon-Icon_X warning"\r\n                                       ng-click="$ctrl.removeCustomPlanItemSelection(option)"\r\n                                       ng-hide="$ctrl.isReadonly"></i>\r\n                                </td>\r\n                            </tr>\r\n                        </tbody>\r\n                    </table>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div class="row plan-custom-configuration" ng-if="!$ctrl.isReadonly">\r\n        <div class="col-sm-2">\r\n            <div class="plan-options-container">\r\n                <div class="list-group">\r\n                    <a class="list-group-item"\r\n                       ng-repeat="firstItem in $ctrl.customPlanConfiguration.Options"\r\n                       ng-click="$ctrl.clickCustomPlanItem(firstItem, $event)"\r\n                       ng-class="$ctrl.getNodeClasses(firstItem)"\r\n                       id="diagnosis-{{::$ctrl.parent.planItem.VisitDiagnosisUid||\'null\'}}-plan-option-item-{{::firstItem.Id}}"\r\n                       ng-if="!firstItem.IsHidden">\r\n\r\n                        <div ng-show="firstItem.totalRequired - firstItem.totalRequiredSelected > 0" class="required-options-missing">\r\n                            <i class="fa fa-asterisk"></i>\r\n                        </div>\r\n                        <div ng-hide="firstItem.IsLeafNode" class="more-options-available">\r\n                            <i class="fa fa-chevron-right"></i>\r\n                        </div>\r\n                        <span>{{firstItem.NodeName}}</span>\r\n                    </a>\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div class="col-sm-10">\r\n            <div class="row">\r\n                <div class="col-xs-12">\r\n                    <div class="row">\r\n                        <div class="plan-options-column"\r\n                             ng-repeat="previousSelectedOption in $ctrl.getSuboptions() track by $index"\r\n                             ng-class="(\'col-xs-\' + $ctrl.getBootstrapColumnNumber($index))"\r\n                             ng-show="$ctrl.customPlanConfiguration.maxLevels > ($index + 1)">\r\n\r\n                            <div class="plan-options-container" ng-if="previousSelectedOption">\r\n                                <div class="list-group" ng-if="!previousSelectedOption.IsLeafNode">\r\n                                    <a class="list-group-item"\r\n                                       ng-repeat="subItem in previousSelectedOption.Options"\r\n                                       ng-click="$ctrl.clickCustomPlanSubitem(subItem, $event)"\r\n                                       ng-class="$ctrl.getNodeClasses(subItem)"\r\n                                       id="diagnosis-{{::$ctrl.parent.planItem.VisitDiagnosisUid||\'null\'}}-plan-option-item-{{::subItem.Id}}"\r\n                                       ng-if="!subItem.IsHidden">\r\n\r\n                                        <div ng-show="subItem.totalRequired - subItem.totalRequiredSelected > 0" class="required-options-missing">\r\n                                            <i class="fa fa-asterisk"></i>\r\n                                        </div>\r\n                                        <div ng-hide="subItem.IsLeafNode" class="more-options-available">\r\n                                            <i class="fa fa-chevron-right"></i>\r\n                                        </div>\r\n                                        <span>{{subItem.NodeName}}</span>\r\n                                    </a>\r\n                                </div>\r\n                                <fnc-plan-recall-widget ng-if="previousSelectedOption.NodeType === $ctrl.SystemGuid.DpnNodePlanRecall"\r\n                                    item="previousSelectedOption"\r\n                                    on-updated-recall-info="$ctrl.updatedRecallInfo()"\r\n                                    select="$ctrl.selectCustomNode(item, shouldBeSelected)"\r\n                                />\r\n                                <fnc-plan-legacy-notes-widget ng-if="previousSelectedOption.NodeType === $ctrl.SystemGuid.DpnNodePlanPatientInstructions"\r\n                                    hosted-from-desktop="$ctrl.hostedFromDesktop"\r\n                                    item="previousSelectedOption"\r\n                                    source="$ctrl.SystemGuid.DpnNodePlanPatientInstructions"\r\n                                    select="$ctrl.selectCustomNode(item, shouldBeSelected)"\r\n                                />\r\n                                <fnc-plan-legacy-notes-widget ng-if="previousSelectedOption.NodeType === $ctrl.SystemGuid.DpnNodePlanPlanNotes"\r\n                                    hosted-from-desktop="$ctrl.hostedFromDesktop"\r\n                                    item="previousSelectedOption"\r\n                                    source="$ctrl.SystemGuid.DpnNodePlanPlanNotes"\r\n                                    select="$ctrl.selectCustomNode(item, shouldBeSelected)"\r\n                                />\r\n                                <fnc-plan-legacy-notes-widget ng-if="previousSelectedOption.NodeType === $ctrl.SystemGuid.DpnNodePlanInternalNotes"\r\n                                    hosted-from-desktop="$ctrl.hostedFromDesktop"\r\n                                    item="previousSelectedOption"\r\n                                    source="$ctrl.SystemGuid.DpnNodePlanInternalNotes"\r\n                                    select="$ctrl.selectCustomNode(item, shouldBeSelected)"\r\n                                />\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>'),$templateCache.put("/fnc/tabs/plan/component-views/fncPlanRecallWidget.html",'<div id="fncPlanRecallWidget">\r\n    <div class="row">\r\n        <div class="col-sm-12">\r\n            <div class="radio recall-type-radio recall-type-radio-simple">\r\n                <label>\r\n                    <input type="radio" name="recallDateType" value="asneeded"\r\n                           ng-model="$ctrl.dateType" ng-change="$ctrl.dateTypeChanged()">\r\n                    {{\'As needed\' | translate}}\r\n                </label>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    \x3c!--<div class="row">\r\n        <div class="col-sm-12">\r\n            <div class="radio recall-type-radio">\r\n                <label>\r\n                    <input type="radio" name="recallDateType" value="specific"\r\n                           ng-model="recall.dateType" ng-change="recall.dateTypeChanged()">\r\n                    {{\'Specific date\' | translate}}\r\n                </label>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div class="row">\r\n        <div class="col-sm-12">\r\n            <div class="panel radio-subpanel form-group">\r\n                <input type="date" class="form-control"\r\n                       ng-model="recall.date"\r\n                       ng-change="recall.dateChanged()"\r\n                       ng-blur="recall.blurDate()">\r\n                </input>\r\n            </div>\r\n        </div>\r\n    </div>--\x3e\r\n    <div class="row">\r\n        <div class="col-sm-12">\r\n            <div class="radio recall-type-radio">\r\n                <label>\r\n                    <input type="radio" name="recallDateType" value="relative"\r\n                           ng-model="$ctrl.dateType" ng-change="$ctrl.dateTypeChanged()">\r\n                    {{\'Relative date\' | translate}}\r\n                </label>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div class="row">\r\n        <div class="col-sm-12">\r\n            <div class="panel radio-subpanel">\r\n                <div class="row">\r\n                    <div class="form-group">\r\n                        <input type="number" class="form-control"\r\n                               ng-model="$ctrl.number" ng-change="$ctrl.timespanChanged()"\r\n                               ng-blur="$ctrl.blurNumber()" />\r\n                    </div>\r\n                    <div class="radio">\r\n                        <label>\r\n                            <input type="radio" name="timePeriod" value="days"\r\n                                   ng-model="$ctrl.timePeriod" ng-change="$ctrl.timespanChanged()">\r\n                            {{\'Days\' | translate}}\r\n                        </label><br/>\r\n                    </div>\r\n                    <div class="radio">\r\n                        <label>\r\n                            <input type="radio" name="timePeriod" value="weeks"\r\n                                   ng-model="$ctrl.timePeriod" ng-change="$ctrl.timespanChanged()">\r\n                            {{\'Weeks\' | translate}}\r\n                        </label><br/>\r\n                    </div>\r\n                    <div class="radio">\r\n                        <label>\r\n                            <input type="radio" name="timePeriod" value="months"\r\n                                   ng-model="$ctrl.timePeriod" ng-change="$ctrl.timespanChanged()">\r\n                            {{\'Months\' | translate}}\r\n                        </label><br/>\r\n                    </div>\r\n                    <div class="radio">\r\n                        <label>\r\n                            <input type="radio" name="timePeriod" value="years"\r\n                                   ng-model="$ctrl.timePeriod" ng-change="$ctrl.timespanChanged()">\r\n                            {{\'Years\' | translate}}\r\n                        </label><br/>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div class="row">\r\n        <div class="col-sm-12">\r\n            <div class="radio recall-type-radio recall-type-radio-simple">\r\n                <label>\r\n                    <input type="radio" name="recallDateType" value="none"\r\n                           ng-model="$ctrl.dateType" ng-change="$ctrl.dateTypeChanged()">\r\n                    {{\'No return visit\' | translate}}\r\n                </label>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>'),$templateCache.put("/fnc/tabs/plan/component-views/fncPlanTile.html",'<div class="fnc-plan-item" id="diagnosis-{{::$ctrl.planItem.VisitDiagnosisUid||\'null\'}}-plan">\r\n    <div class="row">\r\n        <div class="col-xs-12">\r\n            <div class="list-group-item plan-list-group-item" ng-disabled="$ctrl._isDisabled()"\r\n                 hm-propagation="true"\r\n                 ng-click="$ctrl._clickPlan()"\r\n                 ng-class="{\'active-plan\': $ctrl._isSelected(), \'disabled-plan\': $ctrl._isDisabled(), \'expanded-plan\': $ctrl.planItem.isExpanded}"\r\n                 ng-drag="$ctrl._isDraggable()" ng-drag-data="$ctrl.planItem" ng-drag-start="$ctrl._dragStart()">\r\n\r\n                <div class="plan-left-sidebar">\r\n                    <div ng-hide="!$ctrl._isConfigurable()">\r\n                        <input type="checkbox"\r\n                               id="include-diagnosis-{{::$ctrl.planItem.VisitDiagnosisUid||\'null\'}}-plan"\r\n                               ng-disabled="$ctrl.isReadonly"\r\n                               ng-true-value="false" ng-false-value="true"\r\n                               ng-model="$ctrl.planItem.IsExcluded"\r\n                               ng-change="$ctrl._excludePlan()"\r\n                               hm-stop-propagation="true">\r\n                        <label for="include-diagnosis-{{::$ctrl.planItem.VisitDiagnosisUid||\'null\'}}-plan"\r\n                               class="ap-checkbox-hidden-text"\r\n                               hm-stop-propagation="true">\r\n                            Include Plan\r\n                        </label>\r\n                    </div>\r\n                    <div class="reorder"\r\n                         hm-stop-propagation="true"\r\n                         ng-show="$ctrl._isDraggable()"\r\n                         ng-drag-handle="true">\r\n\r\n                        <i class="fa fa-align-justify"></i>\r\n                    </div>\r\n                </div>\r\n\r\n                <div class="plan-ok-sidebar" ng-show="$ctrl._isConfigurable()">\r\n                    <button type="button" class="btn btn-primary plan-ok-button"\r\n                            ng-show="$ctrl._isSelected()"\r\n                            hm-stop-propagation="true"\r\n                            ng-click="$ctrl._onOk()">\r\n                        {{::\'OK\' | translate}}\r\n                    </button>\r\n                </div>\r\n\r\n                <div class="plan-content">\r\n                    <div class="plan-actions" ng-show="$ctrl._isConfigurable() && !$ctrl.isReadonly"\r\n                         ng-class="{\'plan-actions-expanded\': $ctrl.planItem.isExpanded}">\r\n                        <div class="btn-group-vertical">\r\n                            <button type="button" class="btn btn-secondary" id="previousPlanButton"\r\n                                    ng-disabled="$ctrl._isDisabled() || !$ctrl.planItem.Configuration.PreviousPlans.length"\r\n                                    hm-stop-propagation="true"\r\n                                    ng-click="$ctrl._onPreviousPlan()">\r\n\r\n                                {{::\'Previous Plan\' | translate}}\r\n                            </button>\r\n                            <ap-select>\r\n                                <select name="plan-defaults" class="form-control native" ng-disabled="$ctrl._isDisabled()"\r\n                                        ng-model="$ctrl.planItem.selectedDefault"\r\n                                        ng-options="default.Name for default in $ctrl.planItem.Configuration.Defaults"\r\n                                        hm-stop-propagation="true"\r\n                                        ng-change="$ctrl._onSelectDefault()">\r\n                                </select>\r\n                            </ap-select>\r\n                            <button type="button" class="btn btn-secondary" id="saveNewDefaultsButton"\r\n                                    ng-disabled="$ctrl._isDisabled()"\r\n                                    hm-propagation="true"\r\n                                    ng-click="$ctrl._onNew($event)">\r\n                                {{::\'Save New Plan Defaults...\' | translate}}\r\n                            </button>\r\n                        </div>\r\n                    </div>\r\n                    <div class="plan-name">\r\n                        <span>{{::$ctrl.planItem.Name}}</span>\r\n                    </div>\r\n                    <div class="plan-description" ng-class="{\'plan-description-expanded\': $ctrl.planItem.isExpanded}">\r\n                        <span ng-bind-html="$ctrl._formatDescription($ctrl.planItem.Description)"></span>\r\n                    </div>\r\n                    <a class="expand-button" ng-show="$ctrl._isConfigurable() && $ctrl.planItem.Description"\r\n                       hm-stop-propagation="true"\r\n                       ng-click="$ctrl._expand()">\r\n                         \r\n                         {{ $ctrl.planItem.isExpanded ? \'Collapse\' : \'Expand\' | translate }}\r\n                    </a>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div class="row" ng-show="$ctrl._isConfigurable() && $ctrl._isSelected()">\r\n        <div class="col-xs-12">\r\n            <fnc-plan-options-selection ng-hide="$ctrl.isSelectingPreviousPlan"\r\n                configuration="$ctrl.planItem.Configuration"\r\n                custom-plan-configuration="$ctrl.planItem.customPlanConfiguration"\r\n                diagnosis-id="$ctrl.planItem.VisitDiagnosisUid"\r\n                hosted-from-desktop="$ctrl.hostedFromDesktop"\r\n                is-blank="$ctrl._isNewPlan()"\r\n                is-readonly="$ctrl.isReadonly"\r\n                on-updated-recall-info="$ctrl._updatedRecallInfo()"\r\n                register-select-default-callback="$ctrl._registerSelectDefaultCallback(callbackFn)"\r\n                save="$ctrl._incrementalSave()"\r\n            />\r\n            <div id="previousPlans" ng-show="$ctrl.isSelectingPreviousPlan">\r\n                <div class="list-group">\r\n                    <div class="list-group-item"\r\n                         id="previousPlan-{{previousPlan.Id}}"\r\n                         ng-click="$ctrl._onSelectPreviousPlan(previousPlan)"\r\n                         ng-repeat="previousPlan in $ctrl.planItem.Configuration.PreviousPlans">\r\n\r\n                        <span class="previous-plan-date">{{$ctrl._formatPreviousPlanDate(previousPlan.VisitDate)}} - {{previousPlan.FullDescription}}</span><br/>\r\n                        <span ng-bind-html="$ctrl._formatDescription(previousPlan.Description)"></span>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>'),$templateCache.put("/fnc/tabs/plan/views/savePlanDefault.html",'<div class="fnc-save-plan-default-modal">\r\n    <form ng-submit="savePlanDefault.save()">\r\n        <div class="row">\r\n            <div class="col-xs-12">\r\n                <h4>{{savePlanDefault.getTitle()}}</h4>\r\n            </div>\r\n        </div>\r\n        <div class="row">\r\n            <div class="col-xs-12">\r\n                <div class="form-group">\r\n                    <label for="defaultName">Name</label>\r\n                    <input type="text" class="form-control" id="defaultName"\r\n                        ng-model="savePlanDefault.name" required>\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div class="row">\r\n            <div class="col-xs-12">\r\n                <button type="submit" class="btn btn-default">{{\'Save\' | translate}}</button>\r\n            </div>\r\n        </div>\r\n    </form>\r\n</div>'),$templateCache.put("/fnc/tabs/rx/component-views/fncRx.html",'<div id="fnc-rx">\r\n    <table class="table fnc-notes-table">\r\n        <tbody>\r\n            <tr>\r\n                <td>\r\n                    <div class="tinymce-icon pull-right"\r\n                         ng-click="$ctrl.onClickEditRxComment()">\r\n                    </div>\r\n                </td>\r\n                <td>\r\n                    <div ng-if="!$ctrl.loadingComment && $ctrl.loadCommentError">\r\n                        <uib-alert type="danger">\r\n                            {{::"An error has occurred and the RX Comment could not be loaded." | translate}}\r\n                        </uib-alert>\r\n                    </div>\r\n                    <div ng-if="$ctrl.loadingComment">\r\n                        <div class="spinner-container text-center">\r\n                            <ap-spinner size="3"></ap-spinner>\r\n                        </div>\r\n                    </div>\r\n                    <div ng-if="!$ctrl.loadingComment && !$ctrl.loadCommentError">\r\n                        <span id="enter-note-button"\r\n                              class="enter-note-text clickable"\r\n                              ng-if="$ctrl.hideContainer && !$ctrl.tinymceModel"\r\n                              ng-click="$ctrl.toggleHide()">\r\n                              \r\n                              Click to add a new note ...\r\n                        </span>\r\n                        <visit-comment-textarea\r\n                            ng-if="!$ctrl.hideContainer || $ctrl.tinymceModel"\r\n                            hide-toolbar="true"\r\n                            use-advanced-toolbar="true"\r\n                            visit-comment-type="$ctrl.visitCommentType"\r\n                            visit-id="$ctrl.visitId"\r\n                            comment="$ctrl.rxComment"\r\n                            on-comment-updated="$ctrl.onCommentUpdated(updatedValue)">\r\n                        </visit-comment-textarea>\r\n                    </div>\r\n                </td>\r\n            </tr>\r\n        </tbody>\r\n    </table>\r\n    <hr class="fnc-notes-hr">\r\n    <div class="fnc-search">\r\n        <div class="row">\r\n            <div class="col-xs-4">\r\n            </div>\r\n            <div class="col-xs-4">\r\n                <div class="fnc-rx-title text-center">\r\n                    <span translate>Visit Medication</span>\r\n                </div>\r\n            </div>\r\n            <div class="col-xs-4 fnc-rx-actions-right">\r\n                <div>\r\n                    <a class="fnc-rx-link-action"\r\n                       id="fnc-rx-patient-formulary"\r\n                       ng-click="$ctrl.onClickPatientFormulary()">\r\n                       {{::\'Patient Formulary\' | translate}}\r\n                    </a>\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div class="table-fnc-rx-container">\r\n            <table class="table table-v18 table-fnc-rx">\r\n                <thead>\r\n                <tr>\r\n                    <th class="two-thirds-width-column">\r\n                        {{::\'Medication SIG\' | translate}}\r\n                        <button type="button"\r\n                            class="fnc-rx-header-btn enable pull-right"\r\n                            id="fnc-rx-prescribe-btn"\r\n                            ng-click="$ctrl.onClickSearchDrugs()"\r\n                            ng-if="$ctrl.canPrescribe()">\r\n                            <div class="fnc-rx-header-btn-text">\r\n                                {{::\'Prescribe\' | translate}}\r\n                            </div>\r\n                        </button>\r\n                    </th>\r\n                    <th>\r\n                        {{::\'Refills\' | translate}}                        \r\n                    </th>\r\n                    <th class="fnc-rx-medication-refill-days-th-col">\r\n                        {{::\'Days\' | translate}}                        \r\n                    </th>\r\n                    <th>\r\n                        {{::\'Diagnosis\' | translate}}                        \r\n                    </th>\r\n                    <th class="one-third-width-column">\r\n                        <div class="pull-left ap-checkbox-flush">\r\n                            <input type="checkbox"\r\n                                id="select-all-pharmacies"\r\n                                name="select-all-pharmacies"\r\n                                ng-model="$ctrl.selectAllPharmacies"\r\n                                ng-change="$ctrl.onClickSelectAllPharmacies()"\r\n                                ap-checkbox-hidden-label="Select All">\r\n                            <button type="button"\r\n                                id="search-pharmacies-btn"\r\n                                name="search-pharmacies-btn"\r\n                                class="fnc-rx-header-btn"\r\n                                ng-class="$ctrl.changePharmacyEnabled ? \'enable\' : \'disable\'"\r\n                                ng-click="$ctrl.onClickSearchPharmacies()">\r\n                                <div class="fnc-rx-header-btn-text">\r\n                                    {{::\'Change\' | translate}}\r\n                                </div>\r\n                            </button>\r\n                        </div>\r\n                        {{::\'Pharmacy\' | translate}}\r\n                    </th>\r\n                    <th class="status-column">{{::\'Status\' | translate}}</th>\r\n                    <th class="delete-column"></th>\r\n                </tr>\r\n                </thead>\r\n                <tbody>\r\n                <tr ng-if="$ctrl.loadingVisitRx">\r\n                    <td colspan="5">\r\n                        <div class="spinner-container text-center">\r\n                            <ap-spinner size="3"></ap-spinner>\r\n                        </div>\r\n                    </td>\r\n                </tr>\r\n                <tr ng-if="!$ctrl.loadingVisitRx && $ctrl.loadVisitRxError">\r\n                    <td colspan="5">\r\n                        <uib-alert type="danger">\r\n                            {{::"An error has occurred and the visit medications could not be loaded." | translate}}\r\n                        </uib-alert>\r\n                    </td>\r\n                </tr>\r\n                <tr ng-class="{\'fnc-rx-strikeout\': med.IsDeleted, \'hazardous\': med.IsHazardousDrug, \'high-risk\': med.IsHighRisk}" \r\n                    ng-repeat="med in $ctrl.medications" ng-if="!$ctrl.loadingVisitRx && !$ctrl.loadVisitRxError">\r\n                    <td>\r\n                        <div class="flex-row" ng-show="!$ctrl.isSigTextLoading($index)">\r\n                            \r\n                            <span id="fnc-rx-edit-{{med.RelVisitMedicationId}}"\r\n                                class="fnc-rx-medication-text"\r\n                                ng-if="!med.CanEdit">\r\n                                {{med.Description}}\r\n                            </span>\r\n                            <a id="fnc-rx-edit-clickable-{{med.RelVisitMedicationId}}"\r\n                                ng-if="med.CanEdit"\r\n                                class="clickable fnc-rx-medication-text"\r\n                                ng-click="$ctrl.onClickEditRx(med)">\r\n                                {{med.Description}}\r\n                            </a> \r\n                            <a class="ap-information clickable strikeout-hide flex-pull-right"\r\n                                ng-click="$ctrl.openRxInfo(med)">\r\n                            </a>\r\n                        </div>\r\n                        <div ng-show="$ctrl.isSigTextLoading($index)" class="spinner-container text-center" >\r\n                            <ap-spinner size="1"></ap-spinner>\r\n                        </div>\r\n                    </td>\r\n                    <td class="text-center" >                       \r\n                            <input id="fnc-rx-edit-refill-{{med.RelVisitMedicationId}}"\r\n                            type="number" \r\n                                    min="0"\r\n                                    ng-class="$ctrl.isSigTextError($index) ? \'fnc-rx-medication-refill-error\' : \'\'"\r\n                                    ng-model-options="{debounce: 750}"\r\n                                   class="form-control text-center " \r\n                                   ng-model="med.RefillQty"\r\n                                   ng-change="$ctrl.updateRefillsManual($index,med);"\r\n                                   ng-if="med.CanEdit" >\r\n                            <div ng-if="!med.CanEdit">\r\n                                {{med.RefillQty}}\r\n                            </div>\r\n\r\n                    </td>\r\n                    <td class="text-center" >\r\n                        <input id="fnc-rx-edit-days-{{med.RelVisitMedicationId}}"\r\n                        type="number" \r\n                                    min="0"\r\n                                    ng-class="$ctrl.isSigDaystError($index) ? \'fnc-rx-medication-refill-error\' : \'\'"\r\n                                    ng-model-options="{debounce: 750}"\r\n                                   class="form-control text-center " \r\n                                   ng-model="med.MedicationDays"\r\n                                   ng-change="$ctrl.updateRefillsManual($index,med);"\r\n                                   ng-if="med.CanEdit" >\r\n                            <div ng-if="!med.CanEdit">\r\n                                {{med.MedicationDays}}\r\n                            </div>\r\n                    </td>\r\n                    <td class="text-center" >\r\n                        <div ng-if="med.CanEdit">\r\n                            <button id="fnc-rx-edit-dx-{{med.RelVisitMedicationId}}" class="fnc-rx-dx-bnt overflow-ellipsis"\r\n                                    type="button"\r\n                                    class="form-control text-center"\r\n                                    ng-click="$ctrl.onOpenDxSelectModal(med)"\r\n                                    ng-if="med.CanEdit"\r\n                                    ng-model="med.selectedICDCodes">\r\n                                <span class="ap-plus-blue pull-right"></span>\r\n                                <span title="{{med.selectedICDCodes}}">\r\n                                    {{med.selectedICDCodes}}\r\n                                </span>\r\n                            </button>\r\n                        </div>\r\n                        <div ng-if="!med.CanEdit" class="fnc-rx-dx-cannot-edit overflow-ellipsis" title="{{med.selectedICDCodes}}">\r\n                            {{med.selectedICDCodes}}\r\n                        </div>\r\n                    </td>\r\n                    <td>\r\n                        <div ng-if="med.CanEdit">\r\n                            <input type="checkbox"\r\n                                   ng-model="med.pharmacySelected"\r\n                                   ng-change="$ctrl.updateSelectAllPharmacies()"\r\n                                   ap-checkbox-label="{{med.Pharmacy.Name}}">\r\n                        </div>\r\n                        <div ng-if="!med.CanEdit">{{med.Pharmacy.Name}}</div>\r\n                    </td>\r\n                    <td>\r\n                        <div ng-if="(!med.CanEdit || (!med.DefaultRxWorkflowStatus && med.status))">\r\n                            <med-status-icon\r\n                                class="strikeout-hide"\r\n                                data-med-status="med.status"\r\n                                data-icon-size="1"\r\n                                data-has-details="true"\r\n                                data-other-class="img-center-h"\r\n                                data-med-type="visit">\r\n                            </med-status-icon>\r\n                        </div>\r\n                        <div ng-if="(med.CanEdit && med.DefaultRxWorkflowStatus && med.status && med.status.Status && med.status.Status.toUpperCase() === \'NONE\')">\r\n                            <i class="material-icons fnc-rx-workflow-default-status"\r\n                            title="{{ med.DefaultRxWorkflowStatus.Name }}"\r\n                            id="fnc-rx-workflow-default-status-{{med.RelVisitMedicationId}}">error</i>\r\n                        </div>\r\n                    </td>\r\n                    <td>\r\n                        <div ng-if="med.CanDelete" id="delete-rx-button" class="ap-trash-can clickable" ng-click="$ctrl.deleteRx(med)"></div>\r\n                    </td>\r\n                </tr>\r\n                </tbody>\r\n            </table>\r\n        </div>\r\n    </div>\r\n    <div class="fnc-rx-samples">\r\n        <div ng-show="$ctrl.displayDrugSampleBanner" >\r\n            <div>\r\n                <a class="fnc-rx-link-action fnc-rx-actions-right" id="fnc-show-Drug-Sample-Banner" ng-click=\'$ctrl.toggleDrugSampleBanner()\'>Close</a>\r\n            </div>\r\n            <iframe id="docViewer" scrolling="yes" frameborder="1"></iframe>\r\n        </div>\r\n        <div class="row">\r\n            <div class="col-xs-6" ng-show="$ctrl.displayDrugSampleLink">\r\n                <a class="fnc-rx-link-action" id="fnc-show-Drug-Sample-Banner" ng-click=\'$ctrl.toggleDrugSampleBanner()\'>Samples Available</a>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div class="fnc-search">\r\n        <hx-medication\r\n            hosted-from-desktop="$ctrl.hostedFromDesktop"\r\n            prescriber-rights="$ctrl.prescriberRights"\r\n            is-completed="$ctrl.isCompleted"\r\n            prm-state ="$ctrl.prmState"\r\n            visit-id="$ctrl.visitId"\r\n            patient-id="$ctrl.patientId"\r\n            medication-refilled="$ctrl.onMedicationRefilled(sigType, prescription, refilledMedication)"\r\n            medication-changed="$ctrl.onMedicationChanged(sigType, prescription, changedMedication)"\r\n            register-refill-from-hx-only-callback="$ctrl.onRegisterRefillFromHxOnlyCallback(callbackFn)"\r\n            register-tab-selected-callback="$ctrl.childRegisterTabSelectedCallback(\'hx\', callbackFn)"\r\n            kdb-parameters="$ctrl.kdbParameters">\r\n        </hx-medication>\r\n    </div>\r\n</div>\r\n\r\n\r\n\r\n\r\n'),$templateCache.put("/fnc/tabs/rx/views/fncRxDrugScreeningModal.html",'<div ap-full-modal ap-full-modal-always>\r\n    <div class="modal-header">\r\n        <button type="button" class="close" ng-click="$ctrl.cancel()">&times;</button>\r\n    </div>\r\n    <div class="modal-body">\r\n        <sigwriter-wizard-screening-content\r\n            visit-screening-parameters="$ctrl.visitScreeningParameters"\r\n        />\r\n    </div>\r\n</div>'),$templateCache.put("/fnc/tabs/rx/views/FncRxPharmacySearchModal.html",'<div class="modal-noborder">\r\n    <div class="modal-header">\r\n        {{::\'Pharmacy\' | translate}}:\r\n        <button id="btn-close-x"\r\n                type="button"\r\n                class="close"\r\n                ng-click="vm.cancel()">\r\n            &times;\r\n        </button>\r\n    </div>\r\n    <div class="modal-body">\r\n        <uib-alert type="danger"\r\n            ng-if="vm.httpError"\r\n            translate\r\n            class="alert-flush">\r\n            {{::\'There was an error loading the pharmacy list\' | translate}}\r\n        </uib-alert>\r\n        <div ng-if="!vm.httpError">\r\n            <ap-find-pharmacy\r\n                id="PharmacyId"\r\n                name="PharmacyId"\r\n                data-patient-id="vm.patientId"\r\n                data-auto-focus="true"\r\n                display-none="true"\r\n                default-list="true"\r\n                ng-model="vm.pharmacy"\r\n                ng-change="vm.onPharmacySelected()">\r\n            </ap-find-pharmacy>\r\n        </div>\r\n    </div>\r\n</div>'),$templateCache.put("/fnc/tabs/rx/views/fncRxSigwriterModal.html",'<div ap-full-modal ap-full-modal-always class="modal-v18">\r\n    <div class="modal-body modal-body-no-padding">\r\n        <sigwriter-tablet-shell\r\n            options="vm.options"\r\n            canceled="vm.cancel()"\r\n            completed="vm.completed(rx)"\r\n        />\r\n    </div>\r\n</div>'),$templateCache.put("/fnc/tabs/rx/views/visitRefillSigwriterModal.html",'<div ap-full-modal ap-full-modal-always>\r\n    <div class="modal-body modal-body-no-padding">\r\n        <sigwriter-tablet-shell\r\n            options="vm.options"\r\n            canceled="vm.cancel()"\r\n            completed="vm.completed(rx)">\r\n        </sigwriter-tablet-shell>\r\n    </div>\r\n</div>'),$templateCache.put("/fnc/tabs/visitText/component-views/fncVisitText.html",'<div id="fnc-visit-text">\r\n    <div class="text-center" ng-show="$ctrl.loadingVisitText">\r\n        <ap-spinner size="3"></ap-spinner>\r\n    </div>\r\n    <div class="fnc-search"\r\n         ng-bind-html="$ctrl.visit.document.VisitHtml"\r\n         id="visit-ops-html"\r\n         ng-show="!$ctrl.loadingVisitText && !$ctrl.httpErrorVisitText">\r\n    </div>\r\n    <div ng-show="!$ctrl.loadingVisitText && $ctrl.httpErrorVisitText">\r\n        <uib-alert type="danger">\r\n            {{::"An error has occurred and the visit text could not be loaded." | translate}}\r\n        </uib-alert>\r\n    </div>\r\n</div>\r\n'),$templateCache.put("/fnc/views/ccTab.html",'<i class="ap-CC" />'),$templateCache.put("/fnc/views/cdsTab.html",'<i class="ap-CDS" />'),$templateCache.put("/fnc/views/diagnosesTab.html",'<fnc-dx\r\n    patient="$ctrl.context.Patient"\r\n    visit-id="$ctrl.visitId"\r\n    register-tab-selected-callback="$ctrl.registerStepSelectedCallback(step.wzTitle, callbackFn)"\r\n/>\r\n\r\n'),$templateCache.put("/fnc/views/hpiTab.html",'<i class="ap-HPI" />'),$templateCache.put("/fnc/views/hxTab.html",'<hx-medical-devices patient-id="$ctrl.context.Patient.Id" visit-id="$ctrl.visitId" />'),$templateCache.put("/fnc/views/imoModal.html",'<div id="fncImo" ap-full-modal ap-full-modal-always>\r\n    <div class="row">\r\n        <div class="col-xs-12">\r\n            <div class="modal-header">\r\n                <button type="button" class="close" ng-click="vm.cancel()">&times;</button>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div class="modal-body">\r\n        <div class="row">\r\n            <div class="col-xs-12">\r\n                <diagnosis-search patient="vm.patient"\r\n                                  multi-select="vm.multiSelect"\r\n                                  search-text="vm.searchText"\r\n                                  hcc-modal-filtered="vm.hccModalFiltered"\r\n                                  ng-model="vm.selectedTerms"\r\n                                  accept-cancel-action="vm.acceptCancelAction(keyCode)"></diagnosis-search>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div class="modal-footer">\r\n        <div class="row">\r\n            <div class="col-xs-6">\r\n                <button class="btn btn-default" ng-click="vm.ok()">{{\'OK\' | translate}}</button>\r\n            </div>\r\n\r\n            <div class="col-xs-6">\r\n                <button class="btn btn-default" ng-click="vm.cancel()">{{\'Cancel\' | translate}}</button>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>'),$templateCache.put("/fnc/views/medicationsTab.html",'<fnc-rx\r\n    is-completed="$ctrl.context.IsCompleted"\r\n    patient-id="$ctrl.context.Patient.Id"\r\n    visit-id="$ctrl.visitId"\r\n    register-tab-selected-callback="$ctrl.registerStepSelectedCallback(step.wzTitle, callbackFn)">\r\n</fnc-rx>\r\n'),$templateCache.put("/fnc/views/patientDashboardModal.html",'<div id="fncPatientDashboard">\r\n    <div class="row">\r\n        <div class="col-xs-12">\r\n            <div class="modal-header">\r\n                <button type="button" class="close" ng-click="vm.cancel()">&times;</button>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div class="row">\r\n        <div class="col-xs-12">\r\n            <ng-include ng-controller="PatientDashboardCtrl" src="\'/patients/views/patientDashboard.html\'" />\r\n        </div>\r\n    </div>\r\n</div>'),$templateCache.put("/fnc/views/peTab.html",'<i class="ap-PE" />'),$templateCache.put("/fnc/views/planTab.html",'<fnc-plan\r\n    is-readonly="$ctrl.context.IsReadOnly"\r\n    patient-id="$ctrl.context.Patient.Id"\r\n    visit-id="$ctrl.visitId"\r\n    register-tab-selected-callback="$ctrl.registerStepSelectedCallback(step.wzTitle, callbackFn)"\r\n/>'),$templateCache.put("/fnc/views/resTab.html",'<i class="ap-Res" />'),$templateCache.put("/fnc/views/rosTab.html",'<i class="ap-ROS" />'),$templateCache.put("/fnc/views/soTab.html",'<i class="ap-SO" />'),$templateCache.put("/fnc/views/spTab.html",'<i class="ap-SP" />'),$templateCache.put("/fnc/views/unsupportedTab.html","<div id=\"fnc-unsupported-tab\">\r\n    <span translate>The '{{step.wzTitle}}' tab is not supported.</span>\r\n</div>"),$templateCache.put("/fnc/views/visitTextTab.html",'<fnc-visit-text \r\n    patient-id="$ctrl.context.Patient.Id" \r\n    visit-id="$ctrl.visitId" \r\n    register-tab-selected-callback="$ctrl.registerStepSelectedCallback(step.wzTitle, callbackFn)" />\r\n'),$templateCache.put("/fnc/views/vitalsTab.html",'<i class="ap-Vitals" />')}]),function(){"use strict";angular.module("aprima-fnc").component("fncPatientHeader",{templateUrl:"/fnc/component-views/fncPatientHeader.html",bindings:{patient:"<"},controller:["_","DateUtilities",function(_,DateUtilities){var vm=this;function refresh(){vm.patient?(vm.patientDetails=_.cloneDeep(vm.patient),vm.patientDetails.Age=DateUtilities.getPersonAgeAbbr(vm.patient.BirthDate),vm.patient.GenderAnsi&&1<vm.patient.GenderAnsi.length&&(vm.patientDetails.GenderAnsi=vm.patient.GenderAnsi.substring(0,2))):vm.patientDetails=null}vm.patientDetails=null,vm.$onChanges=function(changes){changes.patient&&refresh()},vm.refresh=refresh}]})}(),function(){"use strict";angular.module("aprima-fnc").component("fncShell",{templateUrl:"/fnc/component-views/fncShell.html",bindings:{context:"<",visitId:"<"},controller:["_","$anchorScroll","$scope","$timeout","Bridge","DeviceSettings","FncPatientDashboardModal","FncVisitInfoModal","SystemGuid","WizardHandler",function(_,$anchorScroll,$scope,$timeout,Bridge,DeviceSettings,FncPatientDashboardModal,FncVisitInfoModal,SystemGuid,WizardHandler){var stepSelectedCallbackFns,vm=this,pdbModal=null,visitInfoModal=null,openModal=null;function convertStepTitleToId(stepTitle){return stepTitle.replace(/ /g,"-")+"-top"}function getWizard(){return WizardHandler.wizard(vm.wizardName)}function onAdvanceFncTab(){getWizard().next()}function onOpenFncPdb(){pdbModal||(dismiss(openModal),openModal=pdbModal=FncPatientDashboardModal.openModalOnly(vm.context.Patient.Id),pdbModal.result.finally(function(){pdbModal=null}))}function onOpenVisitInfo(){visitInfoModal||(dismiss(openModal),openModal=visitInfoModal=FncVisitInfoModal.openModalOnly(vm.visitId),visitInfoModal.result.finally(function(){visitInfoModal=null}))}function onRetreatFncTab(){getWizard().previous()}function onSelectFncTab(fncTab){var wizard=getWizard(),step=_.find(vm.steps,function(step){return step.tab.TabSliderUid===fncTab.Id});step&&wizard.goTo(step.wzTitle)}function onStepChanged(eventName,data){var step=data.step,stepTitle=step.wzTitle,fncTab=step.wzData.fncTab,selectedFncTab={IsFirst:0<vm.steps.length&&step.wzData===vm.steps[0],IsLast:0<vm.steps.length&&step.wzData===vm.steps[vm.steps.length-1],Tab:fncTab};vm.selectedTab=selectedFncTab,dismiss(openModal),Bridge.fireEvent("selectedFncTab",selectedFncTab),$timeout(function(){$anchorScroll("fnc-wizard")},0);var callbackFn=stepSelectedCallbackFns[stepTitle];callbackFn&&callbackFn()}function dismiss(modal){modal&&modal.dismiss&&modal.dismiss()}function updateSteps(){var fncTabs=[],steps=[],tabs=vm.context&&vm.context.ClinicalNoteType&&vm.context.ClinicalNoteType.Tabs||[];function getTemplateUrl(tabId){switch(tabId){case SystemGuid.UIControl_Note_CC:return"/fnc/views/ccTab.html";case"ffbb556f-ab4e-478f-a2d7-b4b863a344e9":return"/fnc/views/cdsTab.html";case SystemGuid.UIControl_Note_DX:return"/fnc/views/diagnosesTab.html";case SystemGuid.UIControl_Note_HPI:return"/fnc/views/hpiTab.html";case SystemGuid.UIControl_Note_HX:return"/fnc/views/hxTab.html";case SystemGuid.UIControl_Note_RX:return"/fnc/views/medicationsTab.html";case SystemGuid.UIControl_Note_PE:return"/fnc/views/peTab.html";case SystemGuid.UIControl_Note_Plan:return"/fnc/views/planTab.html";case SystemGuid.UIControl_Note_Results:return"/fnc/views/resTab.html";case SystemGuid.UIControl_Note_ROS:return"/fnc/views/rosTab.html";case SystemGuid.UIControl_Note_SO:return"/fnc/views/soTab.html";case SystemGuid.UIControl_Note_SP:return"/fnc/views/spTab.html";case SystemGuid.UIControl_Note_VisitText:return"/fnc/views/visitTextTab.html";case SystemGuid.UIControl_Note_Vitals:return"/fnc/views/vitalsTab.html";default:return"/fnc/views/unsupportedTab.html"}}tabs.sort(function(a,b){return a.DisplayOrder-b.DisplayOrder}),tabs.forEach(function(tab){var fncTab={Abbreviation:tab.Abbreviation||tab.Name,Id:tab.TabSliderUid,Name:tab.Name};fncTabs.push(fncTab);var step={fncTab:fncTab,tab:tab,templateUrl:getTemplateUrl(tab.TabSliderUid),wzTitle:tab.Name};steps.push(step)}),steps.forEach(function(step){step.id=convertStepTitleToId(step.wzTitle)}),vm.steps=steps,stepSelectedCallbackFns={},Bridge.fireEvent("setupFncDrawer",{Patient:vm.context.Patient,Tabs:fncTabs})}vm.fncStepsIndicatorContainerId="fncStepsIndicatorContainer",vm.selectedTab=null,vm.steps=[],vm.wizardName="fncWizardShell",vm.$onChanges=function(changes){changes.context&&updateSteps()},vm.convertStepTitleToId=convertStepTitleToId,vm.getShouldShowIndicators=function(){return DeviceSettings.isBrowserOrOverride},vm.getWizard=getWizard,vm.goToStep=function(wizardStep){onSelectFncTab(wizardStep.wzData.fncTab)},vm.onNextClicked=function(){Bridge.fireEvent("advanceFncTab")},vm.onPdbClicked=function(){Bridge.fireEvent("openFncPdb")},vm.onVisitInfoClicked=function(){Bridge.fireEvent("openFncVisitInfo")},vm.onPreviousClicked=function(){Bridge.fireEvent("retreatFncTab")},vm.registerStepSelectedCallback=function(stepTitle,callbackFn){stepSelectedCallbackFns[stepTitle]=callbackFn},Bridge.on("advanceFncTab",$scope,onAdvanceFncTab),Bridge.on("openFncPdb",$scope,onOpenFncPdb),Bridge.on("openFncVisitInfo",$scope,onOpenVisitInfo),Bridge.on("retreatFncTab",$scope,onRetreatFncTab),Bridge.on("selectFncTab",$scope,onSelectFncTab),$scope.$on("wizard:stepChanged",onStepChanged)}]})}(),function(angular){"use strict";angular.module("aprima-fnc").component("fncVisitInfoModal",{templateUrl:"/fnc/component-views/fncVisitInfoModal.html",bindings:{visitId:"=?",cancel:"&"},controller:"FncVisitInfoCtrl"}),angular.module("aprima-fnc").component("fncVisitInfo",{templateUrl:"/fnc/component-views/fncVisitInfo.html",bindings:{visitId:"=?"},controller:"FncVisitInfoCtrl"}),angular.module("aprima-fnc").controller("FncVisitInfoCtrl",["$q","$scope","apConfirm","aprgettext","debounce","ErrorService","FncRepository","FncVisitInfoRepository","ListService","MetadataRepository","moment","PatientRepository","Permissions","SecurityRepository","SystemGuid","toaster",function($q,$scope,apConfirm,gettext,debounce,ErrorService,FncRepository,FncVisitInfoRepository,ListService,MetadataRepository,moment,PatientRepository,Permissions,SecurityRepository,SystemGuid,toaster){var vm=this,currentVisitId=null,currentBillingProvider=null,currentRenderingProvider=null,currentPatientCase=null,currentVisitType=null,visitIdWatch=null,strikeoutAllowed=!1,initialReason=null,lists={conditions:"patientconditions",historians:"historians",visitTypes:{name:"visittypes",params:{filterToVisitCreation:!0}},providers:"provider",serviceSites:"servicesite",financialCenters:"financialcenter"};function checkVisitId(){var newVisitId=vm.visitId;newVisitId?currentVisitId!==newVisitId&&function(visitId){if(visitId)return vm.loadingVisit=!0,FncVisitInfoRepository.get(visitId).then(function(data){return data?(processVisit(data),data):$q.reject("Visit Info could not be retrieved.")}).catch(function(response){return ErrorService.displayErrorMessages(response),$q.reject(response)}).finally(function(){vm.loadingVisit=!1});var getWarning=gettext("Visit Id is not associated to any visit");toaster.warning("",getWarning),$q.reject(getWarning)}(newVisitId):vm.visit={},currentVisitId=newVisitId}function canChangeVisitType(){var allowed=!currentVisitId||!vm.visit.VisitType||vm.visit.VisitType===vm.standardVisit;return allowed}function updateFinancialCenter(){var rProvider=vm.visit.RenderingProvider,bProvider=vm.visit.BillingProvider,sSite=vm.visit.ServiceSite,newFinancialCenterId=rProvider.FinancialCenterId||bProvider.FinancialCenterId||sSite.FinancialCenterId;if(newFinancialCenterId){var newFinancialCenter=_.find(vm.financialCenters,{Id:newFinancialCenterId});newFinancialCenter&&(vm.visit.FinancialCenter=newFinancialCenter)}}function setServiceSite(serviceSiteId){if(serviceSiteId){var newServiceSite=_.find(vm.serviceSites,{Id:serviceSiteId});newServiceSite&&(vm.visit.ServiceSite=newServiceSite)}}function setSupervisingProvider(providerId){if(providerId){var newProvider=_.find(vm.providers,{Id:providerId});newProvider&&(vm.visit.SupervisingProvider=newProvider)}}function getStrikeoutPermission(){var promise=SecurityRepository.getPermissions(Permissions.StrikeoutVisits).then(function(permission){return strikeoutAllowed=permission&&permission.IsAllowed,permission}).catch(function(error){return strikeoutAllowed=!1,$q.reject(error)});return promise}function processVisit(visitInfo){if(visitInfo){visitInfo.plain&&(visitInfo=visitInfo.plain());var patientId=visitInfo.Patient&&visitInfo.Patient.Id,currentPatientId=vm.visit&&vm.visit.Patient&&vm.visit.Patient.Id;patientId!==currentPatientId&&(function(patientId){PatientRepository.getAccounts(patientId).then(function(accounts){return vm.accounts=accounts})}(patientId),function(patientId){PatientRepository.getPatientCases(patientId).then(function(patientCases){return vm.patientCases=patientCases})}(patientId)),visitInfo.VisitDate&&(visitInfo.VisitDate=moment(visitInfo.VisitDate).toDate()),visitInfo.ReferringDate&&(visitInfo.ReferringDate=moment(visitInfo.ReferringDate).toDate()),currentVisitType=visitInfo.VisitType=visitInfo.VisitType||vm.standardVisit,currentBillingProvider=visitInfo.BillingProvider,currentRenderingProvider=visitInfo.RenderingProvider,currentPatientCase=visitInfo.PatientCase,currentVisitId=vm.visitId=visitInfo.Id,initialReason=visitInfo.ReasonForVisitType,vm.visit=visitInfo}}vm.standardVisit={Id:"00000000-0000-0000-0000-000000000000",Name:"Standard"},vm.visit={},vm.conditions=[],vm.historians=[],vm.visitTypes=[],vm.providers=[],vm.serviceSites=[],vm.financialCenters=[],vm.patientCases=[],vm.accounts=[],vm.today=new Date,vm.savingVisit=!1,vm.save=debounce(300,function(visit,form){if(visit&&visit.Id&&(!form||form.$valid))return vm.savingVisit=!0,FncVisitInfoRepository.save(visit).then(function(data){return data?(processVisit(data),data):$q.reject("Visit Info could not be retrieved.")}).catch(function(response){return ErrorService.displayErrorMessages(response),$q.reject(response)}).finally(function(){vm.savingVisit=!1});var saveWarning=gettext("Visit is not valid and cannot be saved");return toaster.warning("",saveWarning),$q.reject(saveWarning)}),vm.loadingVisit=!1,vm.changeBillingProvider=function(){var newBillingProvider=vm.visit.BillingProvider;newBillingProvider&&currentBillingProvider!==newBillingProvider&&(setServiceSite(newBillingProvider.DefaultServiceSiteId),updateFinancialCenter());currentBillingProvider=newBillingProvider},vm.changeRenderingProvider=function(){var newRenderingProvider=vm.visit.RenderingProvider;newRenderingProvider&&currentRenderingProvider!==newRenderingProvider&&updateFinancialCenter();currentRenderingProvider=newRenderingProvider},vm.changePatientCase=debounce(300,function(){var newCase=vm.visit.PatientCase;if(newCase&&currentPatientCase!==newCase){if(currentPatientCase&&currentVisitId)return toaster.warning("",gettext("A case is currently selected for this visit, and cannot be changed")),void(vm.visit.PatientCase=currentPatientCase);if(newCase.EndDate)return toaster.warning("",gettext("A case that is closed cannot be selected")),void(vm.visit.PatientCase=currentPatientCase);FncRepository.getAuthCode(newCase.Id,vm.visit.VisitDate).then(function(authCode){vm.visit.AuthorizationCode=authCode}).catch(function(error){return toaster.warning("",gettext("Auth Code associated to selected Patient Case could not be loaded")),$q.reject(error)}),newCase.ReferringDate&&(vm.visit.ReferringDate=moment(newCase.ReferringDate).toDate()),setSupervisingProvider(newCase.SupervisingProviderId)}currentPatientCase=newCase}),vm.changeVisitType=function(){var newVisitType=vm.visit.VisitType,shouldChange=$q.when(!0);newVisitType&&currentVisitType!==newVisitType&&(newVisitType.Id!==SystemGuid.VisitType_StrikeOut&&newVisitType.Id!==SystemGuid.VisitType_Private||(shouldChange=apConfirm("Are you sure you want to set the visit type?  Once set, the visit type cannot be modified.")));shouldChange.then(function(result){result?currentVisitType=newVisitType:vm.visit.VisitType=currentVisitType})},vm.providerName=function(provider){return provider?provider.Name||provider.FirstName+" "+provider.LastName:""},vm.caseDescription=function(caseObj){if(!caseObj)return"";var description=caseObj.Name;caseObj.StartDate&&(description+=" that started "+moment(caseObj.StartDate).format("L"));return description},vm.visitTypeAllowed=function(type){return!type||type.Id!==SystemGuid.VisitType_StrikeOut||strikeoutAllowed},vm.canChangeVisitType=canChangeVisitType,vm.canChangeReason=function(){return canChangeVisitType()||!initialReason},vm.$onDestroy=function(){visitIdWatch&&visitIdWatch()},ListService.getLists(lists).then(function(results){return results?(vm.conditions=results.conditions,vm.historians=results.historians,results.visitTypes&&results.visitTypes.unshift(vm.standardVisit),vm.visitTypes=results.visitTypes,vm.providers=results.providers,vm.serviceSites=results.serviceSites,vm.financialCenters=results.financialCenters,results):$q.reject("Null lists")}).catch(function(error){return toaster.warning("",gettext("Lists could not be loaded")),$q.reject(error)}),FncVisitInfoRepository.getMetadata($scope),getStrikeoutPermission(),visitIdWatch=$scope.$watch(checkVisitId)}])}(window.angular),function(angular){"use strict";window.angular.module("aprima-fnc").component("visitCommentTextarea",{templateUrl:"/fnc/component-views/visitCommentTextarea.html",bindings:{hideToolbar:"<",useAdvancedToolbar:"<",visitCommentType:"<",visitId:"<",comment:"=?",onCommentUpdated:"&"},controller:["VisitCommentRepository",function(VisitCommentRepository){var vm=this;vm.$onInit=function(){vm.comment||VisitCommentRepository.getVisitComment(vm.visitId,vm.visitCommentType).then(function(result){vm.comment=result.VisitComment})},vm.onSave=function(updatedComment){var visitCommentTypeDto={VisitComment:updatedComment,VisitId:vm.visitId,VisitCommentType:vm.visitCommentType};VisitCommentRepository.updateVisitComment(visitCommentTypeDto),vm.onCommentUpdated({updatedValue:updatedComment})}}]})}(),function(angular){"use strict";window.angular.module("aprima-fnc").factory("EpaService",["$q","apConfirmService","EpaRepository",function($q,apConfirmService,EpaRepository){return{getSendEpaPermission:function(){return EpaRepository.canSendEpaRequest()},trySendEpaRequest:function(med){var visitMedicationId=med&&med.RelVisitMedicationUid;return visitMedicationId?apConfirmService.confirm('Would you like to send an ePA request for "'+med.Description+'" ?',"Yes","No").then(function(send){if(send)return EpaRepository.sendEpaRequest(visitMedicationId)}):$q.reject("invalid med")}}}])}(),function(){"use strict";angular.module("aprima-fnc").factory("FncImoModal",["$uibModal","ImoPatient",function($modal,ImoPatient){return{openModal:function(patient,searchText,multiSelect,hccModalFiltered){return openModalOnly(patient,searchText,multiSelect,hccModalFiltered).result},openModalOnly:openModalOnly};function openModalOnly(patient,searchText,multiSelect,hccModalFiltered){return multiSelect=!!multiSelect,hccModalFiltered=!!hccModalFiltered,$modal.open({templateUrl:"/fnc/views/imoModal.html",windowClass:"modal-full fnc-imo",controller:"FncImoModalCtrl",controllerAs:"vm",resolve:{patient:function(){return ImoPatient.mapFromApi(patient)},searchText:function(){return searchText},multiSelect:function(){return multiSelect},hccModalFiltered:function(){return hccModalFiltered}}})}}]),angular.module("aprima-fnc").controller("FncImoModalCtrl",["$uibModalInstance","patient","searchText","multiSelect","hccModalFiltered","$stateParams",function($modalInstance,patient,searchText,multiSelect,hccModalFiltered){var vm=this;function cancel(){$modalInstance.dismiss()}function ok(){$modalInstance.close(vm.selectedTerms)}vm.searchText=searchText,vm.multiSelect=multiSelect,vm.patient=patient,vm.cancel=cancel,vm.selectedTerms=null,vm.ok=ok,vm.acceptCancelAction=function(keyCode){13===keyCode&&ok();27===keyCode&&cancel()},vm.hccModalFiltered=hccModalFiltered}])}(),function(){"use strict";angular.module("aprima-fnc").factory("FncPatientDashboardModal",["$uibModal",function($modal){return{openModal:function(patientId){return openModalOnly(patientId).result},openModalOnly:openModalOnly};function openModalOnly(patientId){return $modal.open({templateUrl:"/fnc/views/patientDashboardModal.html",windowClass:"modal-full fnc-patient-dashboard",controller:"FncPatientDashboardModalCtrl",controllerAs:"vm",resolve:{patientId:function(){return patientId}}})}}]),angular.module("aprima-fnc").controller("FncPatientDashboardModalCtrl",["$uibModalInstance","patientId",function($modalInstance,patientId){this.patientId=patientId,this.cancel=function(){$modalInstance.dismiss()}}])}(),function(angular){"use strict";function VisitInfoModalCtrl($modalInstance,visitId){this.visitId=visitId,this.cancel=function(){$modalInstance.dismiss()}}window.angular.module("aprima-fnc").factory("FncVisitInfoModal",["$uibModal",function($uibModal){return{openModal:function(visitId){return openModalOnly(visitId).result},openModalOnly:openModalOnly};function openModalOnly(visitId){var modalInstance=$uibModal.open({controller:["$uibModalInstance","visitId",VisitInfoModalCtrl],controllerAs:"vm",template:'<fnc-visit-info-modal visit-id="vm.visitId" cancel="vm.cancel()"></fnc-visit-info-modal>',windowClass:"modal-full",resolve:{visitId:function(){return visitId}}});return modalInstance}}])}(),function(){"use strict";angular.module("aprima-fnc").component("fncDx",{templateUrl:"/fnc/tabs/dx/component-views/fncDx.html",bindings:{patient:"<",visitId:"<",registerTabSelectedCallback:"&"},controller:["$sce","apConfirm","debounce","ErrorService","FncDxRepository","FncImoModal","aprgettext","ListService","_","PatientRepository","$q","ServerInfoRepository","toaster","VisitCommentRepository",function($sce,apConfirm,debounce,ErrorService,FncDxRepository,FncImoModal,gettext,ListService,_,PatientRepository,$q,ServerInfoRepository,toaster,VisitCommentRepository){var vm=this,pendingLoadingDx=!1;function imoSearch(searchText){vm.imoSearchText="",FncImoModal.openModal(vm.patient,searchText).then(function(imoResult){existingDiagnosisCheck(imoResult.PrimaryDiagnosis).then(function(result){(void 0===result||result)&&FncDxRepository.postImoDiagnoses(vm.patient.Id,vm.visitId,[imoResult]).then(function(){refreshPatientDiagnoses()}).catch(function(error){vm.saveError=error}).finally(function(){})})})}function onTabSelected(){!function(){vm.loadingDxLists=!0,vm.activeDxGroup=null;var patientDiagnosisPromise=refreshPatientDiagnoses(),diagnosisGroupsPromise=ListService.getList("diagnoses",vm,"diagnosisGroups"),patientDiagnosisListGroupPromise=function(){var patientDiagnosisListGroupPromise;ServerInfoRepository.isFeatureSupported("PatientDiagnosisCodes")?patientDiagnosisListGroupPromise=PatientRepository.getProblems(vm.patient.Id).then(function(result){return _.filter(result,function(item){return!item.IsProblem})}):(patientDiagnosisListGroupPromise=$q.defer()).resolve([]);return patientDiagnosisListGroupPromise}();$q.all([patientDiagnosisListGroupPromise,diagnosisGroupsPromise,patientDiagnosisPromise]).then(function(result){var patientDiagnoses=result[0],diagnosisGroups=result[1];if(0<patientDiagnoses.length){var diagnoses=_.map(patientDiagnoses,function(dx,index){return{ChargeCaptureDiagnosisId:null,DiagnosisId:dx.DiagnosisId,DiagnosisCode9:dx.Icd9Code,DiagnosisCode10:dx.Icd10Code,DiagnosisName:dx.Name,DisplayOrder:index}}),newDiagnosisGroup={DiagnosisCategoryId:null,DiagnosisCategoryName:gettext("Patient Diagnoses"),DisplayOrder:-1,Diagnoses:diagnoses},foundPatientDiagnoses=_.find(diagnosisGroups,function(group){return group.DiagnosisCategoryName===newDiagnosisGroup.DiagnosisCategoryName});foundPatientDiagnoses||diagnosisGroups.unshift(newDiagnosisGroup)}diagnosisGroups[0]&&void 0===diagnosisGroups[0].IsSelected&&(vm.diagnosisGroups=_(diagnosisGroups).map(function(group){return _.assign(group,{IsSelected:!1})}).value()),findIsSelectedDiagnoses()}).finally(function(){vm.loadingDxLists=!1}),vm.getVisitComment()}()}function refreshPatientDiagnoses(){if(!vm.loadingDx)return pendingLoadingDx=!1,vm.loadingDx=!0,FncDxRepository.getDiagnoses(vm.patient.Id,vm.visitId).then(function(diagnoses){vm.loadDxError=null,vm.diagnoses=_.sortBy(diagnoses,"DisplayOrder"),findIsSelectedDiagnoses()}).catch(function(error){vm.loadDxError=error}).finally(function(){vm.loadingDx=!1,pendingLoadingDx&&refreshPatientDiagnoses()});pendingLoadingDx=!0}function findIsSelectedDiagnoses(){_.forEach(vm.diagnosisGroups,function(group){_.forEach(vm.diagnoses,function(item){var foundElement=_.find(group.Diagnoses,function(groupItem){return item.DiagnosisCode10?groupItem.DiagnosisCode10===item.Code10:groupItem.DiagnosisCode9===item.Code9});foundElement&&(foundElement.IsSelected=!0)})})}function existingDiagnosisCheck(diagnosis){var foundElement=_.find(vm.diagnoses,function(item){if(diagnosis.DiagnosisCode10||diagnosis.Icd10Code)return item.Code10===(diagnosis.DiagnosisCode10||diagnosis.Icd10Code)});return foundElement?apConfirm("Diagnosis alredy exsists. Are you sure you want to add <br><strong>'"+foundElement.FullDescription+"'</strong> again?","Yes","No","md"):$q.resolve()}vm.diagnoses=[],vm.imoSearchText="",vm.loadDxError=null,vm.loadCommentError=null,vm.loadingComment=!1,vm.loadingDx=!1,vm.hideContainer=!0,vm.visitCommentType="DXComment",vm.tinymceModel="DX Comment",vm.saveError=null,vm.removeDiagnosis=debounce(300,function(diagnosis){return diagnosis&&diagnosis.Id?apConfirm("Are you sure you want to remove <br><strong>'"+diagnosis.FullDescription+"'</strong> ?","Yes","No","md").then(function(result){return result?(diagnosis.actionInProgress=!0,FncDxRepository.deleteDiagnosis(vm.patient.Id,vm.visitId,diagnosis.Id).then(function(data){return data?(removedDiagnosis=diagnosis,_.forEach(vm.diagnosisGroups,function(group){var foundElement=_.find(group.Diagnoses,function(groupItem){return removedDiagnosis.DiagnosisCode10?groupItem.DiagnosisCode10===removedDiagnosis.Code10:groupItem.DiagnosisCode9===removedDiagnosis.Code9});foundElement&&(foundElement.IsSelected=!1)}),refreshPatientDiagnoses(),data):$q.reject("Error: Diagnosis '"+diagnosis.FullDescription+"' could not be removed.");var removedDiagnosis}).catch(function(response){return ErrorService.displayErrorMessages(response),$q.reject(response)}).finally(function(){diagnosis.actionInProgress=!1})):result}):$q.reject("Diagnosis is not valid and cannot be removed.")}),vm.loadingDxLists=!1,vm.visitCommentType="DXComment",vm.activeDxGroup=null,vm.$onInit=function(){vm.registerTabSelectedCallback({callbackFn:onTabSelected})},vm.toggleHide=function(){vm.hideContainer=!vm.hideContainer,vm.hideContainer&&vm.getVisitComment()},vm.imoSearch=imoSearch,vm.getVisitComment=function(){vm.loadingComment=!0,VisitCommentRepository.getVisitComment(vm.visitId,vm.visitCommentType).then(function(result){vm.tinymceModel=$sce.trustAsHtml(result.VisitComment)}).catch(function(error){vm.loadCommentError=error}).finally(function(){vm.loadingComment=!1})},vm.selectDxGroup=function(group){_.forEach(vm.diagnosisGroups,function(item){item.IsSelected=!1}),group.IsSelected=!0,vm.activeDxGroup=group.Diagnoses},vm.addDiagnosis=function(diagnosis){diagnosis.DiagnosisCode10?existingDiagnosisCheck(diagnosis).then(function(result){if(void 0===result||result){var selectedItemDiagnosis=[{CodeDescription:diagnosis.DiagnosisName,Code10:diagnosis.DiagnosisCode10,Code9:diagnosis.DiagnosisCode9}];FncDxRepository.postDiagnoses(vm.patient.Id,vm.visitId,selectedItemDiagnosis).then(function(){refreshPatientDiagnoses()}).catch(function(error){vm.saveError=error}).finally(function(){})}}):imoSearch(diagnosis.DiagnosisCode9)}}]})}(),function(){"use strict";angular.module("aprima-fnc").component("hxMedicalDevices",{templateUrl:"/fnc/tabs/hx/medical-devices/component-views/hxMedicalDevices.html",bindings:{patientId:"<",visitId:"<",prmWindowsMode:"<",readOnly:"<"},controller:["$rootScope","$scope","toaster","MedicalDevicesRepository","MedicalDevicesService","MedicalDevicesErrorService","MedicalDeviceConstants","BarcodeScanningService",function($rootScope,$scope,toaster,MedicalDevicesRepository,MedicalDevicesService,MedicalDevicesErrorService,MedicalDeviceConstants,BarcodeScanningService){var vm=this;function getDeviceById(id){var filterExpression={PatientMedicalDeviceHistoryId:id},device=_(vm.model.DeviceHistory.ActiveDevices).filter(filterExpression).first();return device||(device=_(vm.model.DeviceHistory.InactiveDevices).filter(filterExpression).first()),device||(device=_(vm.model.DeviceHistory.DeletedDevices).filter(filterExpression).first()),device}function updateDeviceHistoryModel(repositoryMedicalDevices){vm.model.DeviceHistory.ActiveDevices=[],vm.model.DeviceHistory.InactiveDevices=[],vm.model.DeviceHistory.DeletedDevices=[],_.forEach(repositoryMedicalDevices.ActiveDevices,function(activeDevice){activeDevice.IsCollapsed=!0,vm.model.DeviceHistory.ActiveDevices.push(activeDevice)}),_.forEach(repositoryMedicalDevices.InactiveDevices,function(inactiveDevice){inactiveDevice.IsCollapsed=!0,vm.model.DeviceHistory.InactiveDevices.push(inactiveDevice)}),_.forEach(repositoryMedicalDevices.DeletedDevices,function(deletedDevice){deletedDevice.IsCollapsed=!0,vm.model.DeviceHistory.DeletedDevices.push(deletedDevice)})}vm.loading=!1,vm.model={PatientId:vm.patientId,VisitId:vm.visitId,PrmWindowsMode:void 0!==vm.prmWindowsMode&&vm.prmWindowsMode,IsReadOnly:void 0!==vm.readOnly&&vm.readOnly,MedicalDeviceType:MedicalDeviceConstants.MedicalDeviceType,DeviceHistory:{IsHistoryCollapsed:!0,IsActiveCollapsed:!1,IsInactiveCollapsed:!1,IsDeleteCollapsed:!1,ActiveDevices:[],InactiveDevices:[],DeletedDevices:[]},NlmDeviceSearch:{ButtonCaption:"SCAN",IsModeScan:!0,IsModeFind:!1,IsHeaderCollapsed:!1,HasSearchBeenPerformed:!1,SearchInProgress:!1,DeviceFound:!1,UniqueDeviceId:"",DeviceId:"",SearchResult:null},Errors:{IsError:MedicalDevicesErrorService.isError,ErrorMessage:MedicalDevicesErrorService.errorMessage}};var eventListeners={onCancelNewMedicalDevice:null,onAddNewMedicalDevice:null,onUpdateMedicalDevice:null};function createEventListeners(){eventListeners.onCancelNewMedicalDevice=$scope.$on("onCancelNewMedicalDevice",function(){MedicalDevicesErrorService.updateError(""),vm.model.NlmDeviceSearch.SearchResult=null,vm.model.NlmDeviceSearch.UniqueDeviceId="",vm.model.NlmDeviceSearch.HasSearchBeenPerformed=!1,vm.model.NlmDeviceSearch.DeviceFound=!1,updateNlmDeviceSearchMode()}),eventListeners.onAddNewMedicalDevice=$scope.$on("onAddNewMedicalDevice",function(event,data){!function(eventData){MedicalDevicesErrorService.updateError("");var statusId=eventData.DeviceInactiveDateTimeFrame.Id===MedicalDeviceConstants.TimeFrameId.Clear||"444E6DC7-DF0F-45BC-B8C1-C8B4122EED97"===eventData.DeviceInactiveDateTimeFrame.Id.toUpperCase()?MedicalDeviceConstants.MedicalDeviceStatusId.Active:MedicalDeviceConstants.MedicalDeviceStatusId.Inactive;if(eventData){var createParams=MedicalDevicesService.getDeviceCreateParams(vm.patientId,vm.visitId,eventData,statusId);MedicalDevicesRepository.createMedicalDevice(createParams).then(function(data){data.IsSuccess?updateDeviceHistoryModel(data.Result):MedicalDevicesErrorService.updateErrorWithValidationResult(data.ValidationResult)}).catch(function(err){$scope.httpError=err}).finally(function(){vm.model.NlmDeviceSearch.SearchResult=null,vm.model.NlmDeviceSearch.UniqueDeviceId="",vm.model.NlmDeviceSearch.HasSearchBeenPerformed=!1,vm.model.NlmDeviceSearch.DeviceFound=!1,vm.model.DeviceHistory.IsHistoryCollapsed=!1,updateNlmDeviceSearchMode(),vm.model.PrmWindowsMode&&$rootScope.$broadcast("onPrmWindowsModeMedicalDeviceAdd",{PatientId:createParams.PatientId,VisitId:createParams.VisitId,UniqueDeviceId:createParams.UniqueDeviceId,DeviceActiveDate:createParams.DeviceActiveDate,Notes:createParams.Notes,MedicalDeviceStatusId:createParams.MedicalDeviceStatusId})})}}(data)}),eventListeners.onUpdateMedicalDevice=$scope.$on("onUpdateMedicalDevice",function(event,data){onUpdateMedicalDevice(data)})}function onUpdateMedicalDevice(eventData){MedicalDevicesErrorService.updateError("");var device=getDeviceById(eventData.PatientMedicalDeviceHistoryId);if(device){var groupingId=device.GroupingId;device.DeviceActiveDateTimeFrame=eventData.DeviceActiveDateTimeFrame,device.DeviceInactiveDateTimeFrame=eventData.DeviceInactiveDateTimeFrame;var updateParams=MedicalDevicesService.getDeviceUpdateParams(device,eventData.Notes,eventData.MedicalDeviceStatusId);updateParams.VisitId=vm.visitId,MedicalDevicesRepository.updateMedicalDevice(updateParams).then(function(repositoryMedicalDevices){updateDeviceHistoryModel(repositoryMedicalDevices);var updatedDevice=function(id){var filterExpression={GroupingId:id,IsCurrentHistoryRow:!0},device=_(vm.model.DeviceHistory.ActiveDevices).filter(filterExpression).first();device||(device=_(vm.model.DeviceHistory.InactiveDevices).filter(filterExpression).first());device||(device=_(vm.model.DeviceHistory.DeletedDevices).filter(filterExpression).first());return device}(groupingId);updatedDevice.IsCollapsed=!1,vm.model.DeviceHistory.IsHistoryCollapsed=!1}).catch(function(err){$scope.httpError=err}).finally(function(){vm.model.PrmWindowsMode&&$rootScope.$broadcast("onPrmWindowsModeMedicalDeviceUpdate",{PatientMedicalDeviceHistoryId:updateParams.PatientMedicalDeviceHistoryId,PatientId:updateParams.PatientId,VisitId:updateParams.VisitId,GroupingId:updateParams.GroupingId,DeviceActiveDate:updateParams.DeviceActiveDate,DeviceInactiveDate:updateParams.DeviceInactiveDate,Notes:updateParams.Notes,MedicalDeviceStatusId:updateParams.MedicalDeviceStatusId})})}}function onDeviceLookupButtonClick(){MedicalDevicesErrorService.updateError(""),vm.model.NlmDeviceSearch.SearchResult=null,vm.model.NlmDeviceSearch.DeviceFound=!1,vm.model.NlmDeviceSearch.SearchInProgress=!0,MedicalDevicesRepository.getMedicalDeviceLookup(vm.model.NlmDeviceSearch.DeviceId,vm.model.NlmDeviceSearch.UniqueDeviceId).then(function(data){data.IsSuccess?(vm.model.NlmDeviceSearch.SearchResult=data.Result,MedicalDevicesErrorService.updateError(vm.model.NlmDeviceSearch.SearchResult.ErrorMessage),vm.model.NlmDeviceSearch.DeviceFound=!MedicalDevicesErrorService.isError()):MedicalDevicesErrorService.updateErrorWithValidationResult(data.ValidationResult)}).catch(function(err){$scope.httpError=err}).finally(function(){MedicalDevicesErrorService.isError()?vm.model.NlmDeviceSearch.HasSearchBeenPerformed=!1:(vm.model.NlmDeviceSearch.IsHeaderCollapsed=!1,vm.model.NlmDeviceSearch.HasSearchBeenPerformed=!0),vm.model.NlmDeviceSearch.SearchInProgress=!1})}function updateNlmDeviceSearchMode(){vm.model.NlmDeviceSearch.UniqueDeviceId&&0<vm.model.NlmDeviceSearch.UniqueDeviceId.length?(vm.model.NlmDeviceSearch.ButtonCaption="FIND",vm.model.NlmDeviceSearch.IsModeFind=!0,vm.model.NlmDeviceSearch.IsModeScan=!1):(vm.model.NlmDeviceSearch.ButtonCaption="SCAN",vm.model.NlmDeviceSearch.IsModeFind=!1,vm.model.NlmDeviceSearch.IsModeScan=!0)}$scope.$on("$destroy",function(){null!==eventListeners.onCancelNewMedicalDevice&&eventListeners.onCancelNewMedicalDevice(),null!==eventListeners.onAddNewMedicalDevice&&eventListeners.onAddNewMedicalDevice(),null!==eventListeners.onUpdateMedicalDevice&&eventListeners.onUpdateMedicalDevice()}),vm.loading=!0,createEventListeners(),MedicalDevicesRepository.getMedicalDevices(vm.model.PatientId,vm.model.VisitId).then(function(repositoryMedicalDevices){updateDeviceHistoryModel(repositoryMedicalDevices)}).catch(function(err){$scope.httpError=err}).finally(function(){vm.model.DeviceHistory.ActiveDevices.length&&(vm.model.DeviceHistory.IsHistoryCollapsed=!1),updateNlmDeviceSearchMode(),vm.loading=!1}),vm.onUdiSearchItemChange=function(){MedicalDevicesErrorService.updateError(""),updateNlmDeviceSearchMode()},vm.onDropMedicalDevice=function(movingMedicalDevice,customEventObj){if(movingMedicalDevice.DeviceType===customEventObj.TargetDeviceType)return void MedicalDevicesService.updateDraggableStarted(!1);var eventParams=null,device=getDeviceById(movingMedicalDevice.PatientMedicalDeviceHistoryId);device&&(eventParams={PatientMedicalDeviceHistoryId:movingMedicalDevice.PatientMedicalDeviceHistoryId,DeviceActiveDateTimeFrame:device.DeviceActiveDateTimeFrame,DeviceInactiveDateTimeFrame:device.DeviceInactiveDateTimeFrame,Notes:"",MedicalDeviceStatusId:""},customEventObj.TargetDeviceType===MedicalDeviceConstants.MedicalDeviceType.Inactive?(eventParams.MedicalDeviceStatusId=MedicalDeviceConstants.MedicalDeviceStatusId.Inactive,eventParams.Notes="Inactivating medical device."):(eventParams.MedicalDeviceStatusId=MedicalDeviceConstants.MedicalDeviceStatusId.Deleted,eventParams.Notes="Deleting medical device."),onUpdateMedicalDevice(eventParams));MedicalDevicesService.updateDraggableStarted(!1)},vm.onScanBarcodeButtonClick=function(){MedicalDevicesErrorService.updateError(""),vm.model.NlmDeviceSearch.IsModeFind?onDeviceLookupButtonClick():BarcodeScanningService.scanBarcode($scope,function(StatusMessage,ScannedResultText){ScannedResultText?(vm.model.NlmDeviceSearch.UniqueDeviceId=ScannedResultText,onDeviceLookupButtonClick()):StatusMessage&&(MedicalDevicesErrorService.updateError(StatusMessage),toaster.pop("error",StatusMessage))})}}]})}(),function(){"use strict";angular.module("aprima-fnc").component("medicalDeviceDelete",{templateUrl:"/fnc/tabs/hx/medical-devices/component-views/medicalDeviceDelete.html",bindings:{udi:"<",deviceName:"<",deviceDescription:"<",notes:"="},controller:["$rootScope","$scope",function($rootScope,$scope){var vm=this;vm.$scope=$scope,vm.loadingMedicalDeviceDelete=!1,vm.$onChanges=function(changes){changes.deviceDescription&&changes.deviceDescription.currentValue&&(vm.loadingMedicalDeviceDelete=!0,vm.loadingMedicalDeviceDelete=!1)},$rootScope.setupDirectiveScope(vm.$scope)}]})}(),function(){"use strict";angular.module("aprima-fnc").component("medicalDeviceHistory",{templateUrl:"/fnc/tabs/hx/medical-devices/component-views/medicalDeviceHistory.html",bindings:{patientId:"<",groupingId:"<"},controller:["$rootScope","$scope","MedicalDevicesRepository","MedicalDevicesService",function($rootScope,$scope,MedicalDevicesRepository,MedicalDevicesService){var vm=this;vm.$scope=$scope,vm.loadingMedicalDeviceHistory=!1,vm.model={MedicalDeviceHistory:[]},vm.$onChanges=function(changes){changes.patientId&&changes.patientId.currentValue&&(vm.loadingMedicalDeviceHistory=!0,MedicalDevicesRepository.displayMedicalDeviceHistory(vm.patientId,vm.groupingId).then(function(result){result&&(vm.model.MedicalDeviceHistory=[],_.forEach(result.HistoryDevices,function(device){device.DeviceActiveDateWithAnswer=MedicalDevicesService.formatFuzzyDate(device.DeviceActiveDateTimeFrame),device.DeviceInactiveDateWithAnswer=MedicalDevicesService.formatFuzzyDate(device.DeviceInactiveDateTimeFrame),vm.model.MedicalDeviceHistory.push(device)}))}).catch(function(err){vm.$scope.addHttpError(err)}).finally(function(){vm.loadingMedicalDeviceHistory=!1}))},$rootScope.setupDirectiveScope(vm.$scope)}]})}(),function(){"use strict";angular.module("aprima-fnc").directive("apMedicalDevice",["$rootScope","MedicalDevicesService","MedicalDeviceConstants","MedicalDeviceHistoryModal","MedicalDeviceDeleteModal","MedicalDeviceEditModal",function($rootScope,MedicalDevicesService,MedicalDeviceConstants,MedicalDeviceHistoryModal,MedicalDeviceDeleteModal,MedicalDeviceEditModal){return{restrict:"E",templateUrl:"/fnc/tabs/hx/medical-devices/views/apMedicalDevice.html",controller:function($scope){var expirationDate=$scope.medicalDevice.ExpirationDate&&String($scope.medicalDevice.ExpirationDate.toUpperCase()).indexOf("DOES NOT EXIST")<0?$scope.medicalDevice.ExpirationDate:"",uniqueDeviceId=$scope.medicalDevice.UniqueDeviceIdentifier&&String($scope.medicalDevice.UniqueDeviceIdentifier.toUpperCase()).indexOf("DOES NOT EXIST")<0?$scope.medicalDevice.UniqueDeviceIdentifier:"",deviceId=$scope.medicalDevice.DeviceIdentifier&&String($scope.medicalDevice.DeviceIdentifier.toUpperCase()).indexOf("DOES NOT EXIST")<0?$scope.medicalDevice.DeviceIdentifier:"",lotNumber=$scope.medicalDevice.LotNumber&&String($scope.medicalDevice.LotNumber.toUpperCase()).indexOf("DOES NOT EXIST")<0?$scope.medicalDevice.LotNumber:"",serialNumber=$scope.medicalDevice.SerialNumber&&String($scope.medicalDevice.SerialNumber.toUpperCase()).indexOf("DOES NOT EXIST")<0?$scope.medicalDevice.SerialNumber:"",manufacturingDate=$scope.medicalDevice.ManufacturingDate&&String($scope.medicalDevice.ManufacturingDate.toUpperCase()).indexOf("DOES NOT EXIST")<0?$scope.medicalDevice.ManufacturingDate:"",issuingAgency=$scope.medicalDevice.IssuingAgency&&String($scope.medicalDevice.IssuingAgency.toUpperCase()).indexOf("DOES NOT EXIST")<0?$scope.medicalDevice.IssuingAgency:"",donationId=$scope.medicalDevice.DonationId&&String($scope.medicalDevice.DonationId.toUpperCase()).indexOf("DOES NOT EXIST")<0?$scope.medicalDevice.DonationId:"";$scope.model={IsDeleteInProgress:!1,IsDeactivateInProgress:!1,IsAddInProgress:!1,IsUpdateInProgress:!1,IsBackgroundWhite:"true"===$scope.backgroundWhite,IsCollapsed:"true"===$scope.isCollapsed,IsReadOnly:$scope.isReadOnly,MedicalDeviceType:MedicalDeviceConstants.MedicalDeviceType,MedicalDevice:{PatientMedicalDeviceHistoryId:$scope.medicalDevice.PatientMedicalDeviceHistoryId,IsCurrentHistoryHistoryRow:$scope.medicalDevice.IsCurrentHistoryHistoryRow,PatientId:$scope.medicalDevice.PatientId,VisitId:$scope.medicalDevice.VisitId,GroupingId:$scope.medicalDevice.GroupingId,MedicalDeviceStatusId:$scope.medicalDevice.MedicalDeviceStatusId,DeviceName:$scope.medicalDevice.DeviceName,DeviceDescription:$scope.medicalDevice.DeviceDescription,MriSafetyStatus:$scope.medicalDevice.MriSafetyStatus,ContainsNaturalRubberLatex:!0,ExpirationDate:expirationDate,UniqueDeviceIdentifier:uniqueDeviceId,CompanyName:$scope.medicalDevice.CompanyName,BrandName:$scope.medicalDevice.BrandName,ModelNumber:$scope.medicalDevice.ModelNumber,DeviceIdentifier:deviceId,LotNumber:lotNumber,SerialNumber:serialNumber,ManufacturingDate:manufacturingDate,IssuingAgency:issuingAgency,DonationId:donationId,DeviceHctp:$scope.medicalDevice.DeviceHctp,DeviceType:$scope.deviceType,IsActive:$scope.deviceType===MedicalDeviceConstants.MedicalDeviceType.Active,DeviceActiveDate:$scope.medicalDevice.DeviceActiveDate,DeviceActiveDateAnswerWithValue:MedicalDevicesService.formatFuzzyDate($scope.medicalDevice.DeviceActiveDateTimeFrame),DeviceActiveDateTimeFrame:{Answer:$scope.medicalDevice.DeviceActiveDateTimeFrame.Answer,Date:$scope.medicalDevice.DeviceActiveDateTimeFrame.Date,Id:$scope.medicalDevice.DeviceActiveDateTimeFrame.Id,Value:$scope.medicalDevice.DeviceActiveDateTimeFrame.Value},DeviceInactiveDate:$scope.medicalDevice.DeviceInactiveDate,DeviceInactiveDateAnswerWithValue:MedicalDevicesService.formatFuzzyDate($scope.medicalDevice.DeviceInactiveDateTimeFrame),DeviceInactiveDateTimeFrame:{Answer:$scope.medicalDevice.DeviceInactiveDateTimeFrame.Answer,Date:$scope.medicalDevice.DeviceInactiveDateTimeFrame.Date,Id:$scope.medicalDevice.DeviceInactiveDateTimeFrame.Id,Value:$scope.medicalDevice.DeviceInactiveDateTimeFrame.Value},IsDelete:$scope.medicalDevice.IsDelete,Inactive:$scope.medicalDevice.Inactive,Notes:JSON.parse(JSON.stringify($scope.medicalDevice.Notes)),ActiveDate:$scope.medicalDevice.ActiveDate,InactiveDate:$scope.medicalDevice.InactiveDate,Sequence:$scope.medicalDevice.Sequence}};var eventListeners={StartDraggingMedicalDevice:null};eventListeners.StartDraggingMedicalDevice=$scope.$on("draggable:start",function(){MedicalDevicesService.updateDraggableStarted(!0)}),$scope.$on("$destroy",function(){null!==eventListeners.StartDraggingMedicalDevice&&eventListeners.StartDraggingMedicalDevice()}),$scope.isMedicalDeviceDraggable=function(){if($scope.model.IsReadOnly)return!1;var draggable=!1;"ACTIVE"!==$scope.model.MedicalDevice.DeviceType&&"INACTIVE"!==$scope.model.MedicalDevice.DeviceType||(draggable=!0);return draggable},$scope.deactivateDeviceButtonClick=function(){var modalParams={MedicalDevice:{UniqueDeviceIdentifier:$scope.model.MedicalDevice.UniqueDeviceIdentifier,DeviceName:$scope.model.MedicalDevice.DeviceName,DeviceDescription:$scope.model.MedicalDevice.DeviceDescription,Notes:$scope.model.MedicalDevice.Notes,DeviceActiveDateTimeFrame:$scope.model.MedicalDevice.DeviceActiveDateTimeFrame,DeviceInactiveDateTimeFrame:$scope.model.MedicalDevice.DeviceInactiveDateTimeFrame},MedicalDeviceType:MedicalDeviceConstants.MedicalDeviceType.Inactive};MedicalDeviceEditModal.openModal(modalParams).then(function(modalResult){$scope.model.IsDeactivateInProgress=!0,$rootScope.$broadcast("onUpdateMedicalDevice",{PatientMedicalDeviceHistoryId:$scope.model.MedicalDevice.PatientMedicalDeviceHistoryId,DeviceActiveDateTimeFrame:modalResult.deviceActiveDateTimeFrame,DeviceInactiveDateTimeFrame:modalResult.deviceInactiveDateTimeFrame,Notes:modalResult.notes,MedicalDeviceStatusId:MedicalDeviceConstants.MedicalDeviceStatusId.Inactive})})},$scope.updateMedicalDeviceButtonClick=function(){if($scope.model.MedicalDevice.DeviceType===MedicalDeviceConstants.MedicalDeviceType.Deleted)return;if($scope.model.IsReadOnly)return;var modalParams={MedicalDevice:{UniqueDeviceIdentifier:$scope.model.MedicalDevice.UniqueDeviceIdentifier,DeviceName:$scope.model.MedicalDevice.DeviceName,DeviceDescription:$scope.model.MedicalDevice.DeviceDescription,Notes:$scope.model.MedicalDevice.Notes,DeviceActiveDateTimeFrame:$scope.model.MedicalDevice.DeviceActiveDateTimeFrame,DeviceInactiveDateTimeFrame:$scope.model.MedicalDevice.DeviceInactiveDateTimeFrame},MedicalDeviceType:$scope.model.MedicalDevice.DeviceType};MedicalDeviceEditModal.openModal(modalParams).then(function(modalResult){if($scope.model.MedicalDevice.DeviceType===MedicalDeviceConstants.MedicalDeviceType.Lookup)return $scope.model.MedicalDevice.DeviceActiveDateTimeFrame=modalResult.deviceActiveDateTimeFrame,$scope.model.MedicalDevice.DeviceInactiveDateTimeFrame=modalResult.deviceInactiveDateTimeFrame,$scope.model.MedicalDevice.DeviceActiveDateAnswerWithValue=MedicalDevicesService.formatFuzzyDate(modalResult.deviceActiveDateTimeFrame),$scope.model.MedicalDevice.DeviceInactiveDateAnswerWithValue=MedicalDevicesService.formatFuzzyDate(modalResult.deviceInactiveDateTimeFrame),void($scope.model.MedicalDevice.Notes=modalResult.notes);$scope.model.IsUpdateInProgress=!0;var deviceStatusId=$scope.model.MedicalDevice.MedicalDeviceStatusId;$scope.model.MedicalDevice.MedicalDeviceStatusId.toUpperCase()===MedicalDeviceConstants.MedicalDeviceStatusId.Active.toUpperCase()&&modalResult.deviceInactiveDateTimeFrame.Id.toUpperCase()!==MedicalDeviceConstants.TimeFrameId.Clear.toUpperCase()&&"444E6DC7-DF0F-45BC-B8C1-C8B4122EED97"!==modalResult.deviceInactiveDateTimeFrame.Id.toUpperCase()&&(deviceStatusId=MedicalDeviceConstants.MedicalDeviceStatusId.Inactive),$rootScope.$broadcast("onUpdateMedicalDevice",{PatientMedicalDeviceHistoryId:$scope.model.MedicalDevice.PatientMedicalDeviceHistoryId,DeviceActiveDateTimeFrame:modalResult.deviceActiveDateTimeFrame,DeviceInactiveDateTimeFrame:modalResult.deviceInactiveDateTimeFrame,Notes:modalResult.notes,MedicalDeviceStatusId:deviceStatusId})})},$scope.addDeviceButtonClick=function(){$scope.model.IsAddInProgress=!0,$rootScope.$broadcast("onAddNewMedicalDevice",{UniqueDeviceIdentifier:$scope.model.MedicalDevice.UniqueDeviceIdentifier,DeviceActiveDateTimeFrame:$scope.model.MedicalDevice.DeviceActiveDateTimeFrame,DeviceInactiveDateTimeFrame:$scope.model.MedicalDevice.DeviceInactiveDateTimeFrame,Notes:$scope.model.MedicalDevice.Notes})},$scope.cancelButtonClick=function(){$rootScope.$broadcast("onCancelNewMedicalDevice")},$scope.deleteDeviceButtonClick=function(){var modalParams={Udi:$scope.model.MedicalDevice.UniqueDeviceIdentifier,DeviceName:$scope.model.MedicalDevice.DeviceName,DeviceDescription:$scope.model.MedicalDevice.DeviceDescription};MedicalDeviceDeleteModal.openModal(modalParams).then(function(modalResult){$scope.model.IsDeleteInProgress=!0,$rootScope.$broadcast("onUpdateMedicalDevice",{PatientMedicalDeviceHistoryId:$scope.model.MedicalDevice.PatientMedicalDeviceHistoryId,DeviceActiveDateTimeFrame:$scope.model.MedicalDevice.DeviceActiveDateTimeFrame,DeviceInactiveDateTimeFrame:$scope.model.MedicalDevice.DeviceInactiveDateTimeFrame,Notes:modalResult.notes,MedicalDeviceStatusId:MedicalDeviceConstants.MedicalDeviceStatusId.Deleted})})},$scope.displayMedicalDeviceHistory=function(){var modalParams={PatientId:$scope.model.MedicalDevice.PatientId,PatientMedicalDeviceHistoryId:$scope.model.MedicalDevice.PatientMedicalDeviceHistoryId,GroupingId:$scope.model.MedicalDevice.GroupingId,DeviceName:$scope.model.MedicalDevice.DeviceName};MedicalDeviceHistoryModal.openModal(modalParams)},$scope.updateIsCollapsedAttribute=function(){if(MedicalDevicesService.isDraggableStarted())return void MedicalDevicesService.updateDraggableStarted(!1);$scope.model.IsCollapsed=!$scope.model.IsCollapsed}},scope:{medicalDevice:"=medicalDevice",backgroundWhite:"@backgroundWhite",isCollapsed:"@isCollapsed",isReadOnly:"<isReadOnly",deviceType:"=deviceType"}}}])}(),angular.module("aprima-fnc").directive("apSetFocus",["$timeout","$window",function($timeout,$window){"use strict";return{restrict:"A",link:function(scope,element,attrs){element.on(attrs.apSetFocusEvent,function(){var elementIds=attrs.apSetFocusId.split(",");_.forEach(elementIds,function(id){!function(id){$timeout(function(){var element=$window.document.getElementById(id);element&&element.focus()})}(id.trim())})}),scope.$on("$destroy",function(){element.off(attrs.apSetFocusEvent)})}}}]),function(){"use strict";angular.module("aprima-fnc").directive("apTimeFrame",["$q","moment","ListService","MedicalDeviceConstants",function($q,moment,ListService,MedicalDeviceConstants){return{restrict:"E",templateUrl:"/fnc/tabs/hx/medical-devices/views/directives/apTimeFrame.html",scope:{id:"<",dateTimeFrame:"=dateTimeFrame"},require:"^form",link:function(scope,element,attrs,formCtrl){scope.formRef=formCtrl},controller:function($scope){$scope.tfInputCtrlId="tfInput_"+$scope.id,$scope.calInputCtrlId="calInput_"+$scope.id,$scope.tfSelCtrlId="tfSel_"+$scope.id,$scope.model={IsTimeFrameInputVisible:(timeFrameId=$scope.dateTimeFrame.Id,!!(timeFrameId&&timeFrameId.toUpperCase()===MedicalDeviceConstants.TimeFrameId.DaysAgo||timeFrameId&&timeFrameId.toUpperCase()===MedicalDeviceConstants.TimeFrameId.WeeksAgo||timeFrameId&&timeFrameId.toUpperCase()===MedicalDeviceConstants.TimeFrameId.MonthsAgo||timeFrameId&&timeFrameId.toUpperCase()===MedicalDeviceConstants.TimeFrameId.YearsAgo)),IsTimeFrameCalendarVisible:function(timeFrameId){return!(!timeFrameId||timeFrameId.toUpperCase()!==MedicalDeviceConstants.TimeFrameId.Calendar)}($scope.dateTimeFrame.Id),IsTimeFrameDatePickerVisible:!1,TimeFrame:$scope.dateTimeFrame,DatePicker:{ShowDatePicker:!1,DateOptions:{mixDate:moment(new Date).subtract(100,"year"),maxDate:moment(new Date)}}},$scope.model.DisplayDateEditInput=!1,$scope.dateTimeFrame.Id.toUpperCase()===MedicalDeviceConstants.TimeFrameId.Calendar&&""!==$scope.model.TimeFrame.Date&&($scope.model.TimeFrame.Date=new Date($scope.model.TimeFrame.Date));var timeFrameId;""!==$scope.dateTimeFrame.Value&&($scope.model.TimeFrame.Value=parseInt($scope.dateTimeFrame.Value));ListService.getList("timeframes").then(function(types){$scope.timeFrameTypes=types,_.remove($scope.timeFrameTypes,{Name:"_"}),_.remove($scope.timeFrameTypes,{Name:"Clear"}),_.remove($scope.timeFrameTypes,{Name:"--- Clear Selection ---"});var timeFrameEntryClear={TimeFrameId:MedicalDeviceConstants.TimeFrameId.Clear,Name:"--- Clear Selection ---",Notes:"",DefaultValue:"",UseBirthDate:!1,AddToDate:!1,TimespanUnitType:0,TimespanUnitTypeName:"",DisplayOrder:-1};$scope.timeFrameTypes.unshift(timeFrameEntryClear)}),$scope.datePickerChanged=function(){$scope.model.DatePicker.ShowDatePicker=!1},$scope.timeFrameTypeChanged=function(){if($scope.model.DisplayDateEditInput=!1,null===$scope.model.TimeFrame.Id||$scope.model.TimeFrame.Id.toUpperCase()===MedicalDeviceConstants.TimeFrameId.Clear)return $scope.model.TimeFrame.Id="00000000-0000-0000-0000-000000000000",$scope.model.TimeFrame.Value="",$scope.model.TimeFrame.Date="",$scope.model.TimeFrame.Answer="",$scope.model.IsTimeFrameInputVisible=!1,$scope.model.IsTimeFrameCalendarVisible=!1,void($scope.model.DatePicker.ShowDatePicker=!1);$scope.model.TimeFrame.Answer="";var timeFrameItem=_.find($scope.timeFrameTypes,{TimeFrameId:$scope.model.TimeFrame.Id});timeFrameItem&&($scope.model.TimeFrame.Answer=timeFrameItem.Name);if($scope.model.TimeFrame.Id.toUpperCase()===MedicalDeviceConstants.TimeFrameId.Calendar)return $scope.model.TimeFrame.Value="",$scope.model.TimeFrame.Date="",$scope.model.IsTimeFrameInputVisible=!1,$scope.model.IsTimeFrameCalendarVisible=!0,void($scope.model.DatePicker.ShowDatePicker=!0);$scope.model.IsTimeFrameCalendarVisible=!1,$scope.model.DatePicker.ShowDatePicker=!1;var isTimeFrameInputVisible=!0;$scope.model.TimeFrame.Id.toUpperCase()===MedicalDeviceConstants.TimeFrameId.DaysAgo&&(isTimeFrameInputVisible=!0);$scope.model.TimeFrame.Id.toUpperCase()===MedicalDeviceConstants.TimeFrameId.WeeksAgo&&(isTimeFrameInputVisible=!0);$scope.model.TimeFrame.Id.toUpperCase()===MedicalDeviceConstants.TimeFrameId.MonthsAgo&&(isTimeFrameInputVisible=!0);$scope.model.TimeFrame.Id.toUpperCase()===MedicalDeviceConstants.TimeFrameId.YearsAgo&&(isTimeFrameInputVisible=!0);$scope.model.TimeFrame.Id.toUpperCase()===MedicalDeviceConstants.TimeFrameId.Childhood&&(isTimeFrameInputVisible=!1);$scope.model.TimeFrame.Id.toUpperCase()===MedicalDeviceConstants.TimeFrameId.Teenager&&(isTimeFrameInputVisible=!1);$scope.model.TimeFrame.Id.toUpperCase()===MedicalDeviceConstants.TimeFrameId.Birth&&(isTimeFrameInputVisible=!1);$scope.model.TimeFrame.Value="",$scope.model.TimeFrame.Date="",$scope.model.IsTimeFrameInputVisible=isTimeFrameInputVisible}}}}])}(),function(){"use strict";angular.module("aprima-fnc").factory("MedicalDeviceDeleteModal",["$uibModal",function($modal){return{openModal:function(modalParams){return $modal.open({backdrop:"static",templateUrl:"/fnc/tabs/hx/medical-devices/views/modals/medical-device-delete-modal.html",windowClass:"modal-full",controller:"MedicalDeviceDeleteModalCtrl",controllerAs:"vm",resolve:{modalParams:modalParams}}).result}}}]),angular.module("aprima-fnc").controller("MedicalDeviceDeleteModalCtrl",["$uibModalInstance","modalParams",function($modalInstance,modalParams){var vm=this;vm.model={udi:modalParams.Udi,deviceName:modalParams.DeviceName,deviceDescription:modalParams.DeviceDescription,notes:""},vm.cancel=function(){$modalInstance.dismiss()},vm.close=function(){$modalInstance.close({notes:vm.model.notes})}}])}(),function(){"use strict";angular.module("aprima-fnc").factory("MedicalDeviceEditModal",["$uibModal",function($modal){return{openModal:function(modalParams){return $modal.open({backdrop:"static",templateUrl:"/fnc/tabs/hx/medical-devices/views/modals/medical-device-edit-modal.html",windowClass:"modal-full",controller:"MedicalDeviceEditModalCtrl",controllerAs:"vm",resolve:{modalParams:function(){return _.cloneDeep(modalParams)}}}).result}}}]),angular.module("aprima-fnc").controller("MedicalDeviceEditModalCtrl",["$uibModalInstance","toaster","GeneralNotesModal","GeneralNoteTypeKeys","MedicalDeviceConstants","modalParams",function($modalInstance,toaster,GeneralNotesModal,GeneralNoteTypeKeys,MedicalDeviceConstants,modalParams){var vm=this;vm.model={medicalDevice:modalParams.MedicalDevice,medicalDeviceType:modalParams.MedicalDeviceType,medicalDeviceTypeConstants:MedicalDeviceConstants,maxMedicalDeviceCharacters:8192},vm.cancel=function(){$modalInstance.dismiss()},vm.close=function(theForm){if(theForm.$invalid)return void toaster.pop("error","Please resolve any form validation errors");var editResults={notes:vm.model.medicalDevice.Notes,deviceActiveDateTimeFrame:vm.model.medicalDevice.DeviceActiveDateTimeFrame,deviceInactiveDateTimeFrame:vm.model.medicalDevice.DeviceInactiveDateTimeFrame};$modalInstance.close(editResults)},vm.openNotesEditor=function(){GeneralNotesModal.openModal("Medical Device Notes",vm.model.medicalDevice.Notes,!0,vm.model.maxMedicalDeviceCharacters,GeneralNoteTypeKeys.MedicalDeviceHistoryNotes).then(function(result){vm.model.medicalDevice.Notes=result})}}])}(),function(){"use strict";angular.module("aprima-fnc").factory("MedicalDeviceHistoryModal",["$uibModal",function($modal){return{openModal:function(modalParams){return $modal.open({backdrop:"static",templateUrl:"/fnc/tabs/hx/medical-devices/views/modals/medical-device-history-modal.html",windowClass:"modal-full",controller:"MedicalDeviceHistoryModalCtrl",controllerAs:"vm",resolve:{modalParams:modalParams}}).result}}}]),angular.module("aprima-fnc").controller("MedicalDeviceHistoryModalCtrl",["$uibModalInstance","modalParams",function($modalInstance,modalParams){this.model={patientId:modalParams.PatientId,patientMedicalDeviceHistoryId:modalParams.PatientMedicalDeviceHistoryId,groupingId:modalParams.GroupingId,deviceName:modalParams.DeviceName},this.cancel=function(){$modalInstance.dismiss()},this.close=function(){$modalInstance.close()}}])}(),angular.module("aprima-fnc").factory("MedicalDevicesErrorService",[function(){"use strict";var historyError={IsError:!1,ErrorMessage:""};return{updateError:function(errorMessage){errorMessage&&0<errorMessage.length?(historyError.IsError=!0,historyError.ErrorMessage=errorMessage):(historyError.IsError=!1,historyError.ErrorMessage="")},getErrorObject:function(){return historyError},isError:function(){return historyError.IsError},errorMessage:function(){return historyError.ErrorMessage},updateErrorWithValidationResult:function(validationResult){var isError=!1,errorMessage="";validationResult&&"null"!==validationResult&&"undefined"!==validationResult&&validationResult.Errors&&0<validationResult.Errors.length&&(isError=!0,errorMessage=validationResult.Errors[0].ErrorMessage),historyError.IsError=isError,historyError.ErrorMessage=errorMessage}}}]),angular.module("aprima-fnc").factory("MedicalDevicesService",["moment","MedicalDeviceConstants",function(moment,MedicalDeviceConstants){"use strict";var medicalDeviceDragDropProperties={IsDraggableStarted:!1};function formatDateWithAnswer(id,answer,value,date){var dateWithAnswer="";return id.toUpperCase()!==MedicalDeviceConstants.TimeFrameId.Calendar.toUpperCase()?(dateWithAnswer=answer.replace("_",value),date&&0<date.length&&(dateWithAnswer=dateWithAnswer+"\n("+moment(new Date(date)).format("MM/DD/YYYY")+")")):date&&(dateWithAnswer=moment(new Date(date)).format("MM/DD/YYYY")),dateWithAnswer}return{isDraggableStarted:function(){return medicalDeviceDragDropProperties.IsDraggableStarted},updateDraggableStarted:function(dragStarted){medicalDeviceDragDropProperties.IsDraggableStarted=dragStarted},formatFuzzyDate:function(timeFrame){var dateWithAnswer="";return timeFrame&&(timeFrame.Answer?dateWithAnswer=formatDateWithAnswer(timeFrame.Id,timeFrame.Answer,timeFrame.Value,timeFrame.Date):timeFrame.TimeFrameAnswer&&(dateWithAnswer=formatDateWithAnswer(timeFrame.TimeFrameId,timeFrame.TimeFrameAnswer,timeFrame.TimeFrameValue,timeFrame.FuzzyDate))),dateWithAnswer},replaceLineBreaksWithHtmlLineBreak:function(text){var returnText=text,re=new RegExp("\r\n","g");return returnText=returnText.replace(re,"<br/>"),re=new RegExp("\n","g"),returnText=returnText.replace(re,"<br/>")},getDeviceUpdateParams:function(device,notes,deviceStatusId){return{PatientMedicalDeviceHistoryId:device.PatientMedicalDeviceHistoryId,PatientId:device.PatientId,VisitId:device.VisitId,GroupingId:device.GroupingId,DeviceActiveDate:device.DeviceActiveDate,DeviceActiveDateTimeFrame:{Id:device.DeviceActiveDateTimeFrame.Id,Value:device.DeviceActiveDateTimeFrame.Value,Answer:device.DeviceActiveDateTimeFrame.Answer,Date:device.DeviceActiveDateTimeFrame.Date},DeviceInactiveDate:device.DeviceInactiveDate,DeviceInactiveDateTimeFrame:{Id:device.DeviceInactiveDateTimeFrame.Id,Value:device.DeviceInactiveDateTimeFrame.Value,Answer:device.DeviceInactiveDateTimeFrame.Answer,Date:device.DeviceInactiveDateTimeFrame.Date},Notes:notes,MedicalDeviceStatusId:deviceStatusId}},getDeviceCreateParams:function(patientId,visitId,device,deviceStatusId){return{PatientId:patientId,VisitId:visitId,UniqueDeviceId:device.UniqueDeviceIdentifier,DeviceActiveDateTimeFrame:{Id:device.DeviceActiveDateTimeFrame.Id,Value:device.DeviceActiveDateTimeFrame.Value,Answer:device.DeviceActiveDateTimeFrame.Answer,Date:device.DeviceActiveDateTimeFrame.Date},DeviceInactiveDateTimeFrame:{Id:device.DeviceInactiveDateTimeFrame.Id,Value:device.DeviceInactiveDateTimeFrame.Value,Answer:device.DeviceInactiveDateTimeFrame.Answer,Date:device.DeviceInactiveDateTimeFrame.Date},Notes:device.Notes,MedicalDeviceStatusId:deviceStatusId}}}}]).constant("MedicalDeviceConstants",{MedicalDeviceStatusId:{Active:"AFE93D97-1588-4A54-9DB4-BDD1E9546DA8",Inactive:"6D8843EE-7B0E-4015-8A59-E3CE5806478E",Deleted:"C3C6C10D-6498-4996-A8F0-0D46739E3870"},TimeFrameId:{Clear:"00000000-0000-0000-0000-000000000000",Calendar:"2A65CC34-B700-4BE1-BC0C-BC3947ABDBB4",Birth:"86317D78-C519-4FE3-8F02-B794FFB00357",Childhood:"4CE23CF0-C9BB-4016-900F-76A567A3C82C",Teenager:"3FF31D6D-0706-429D-9ACF-C54E081ECD29",DaysAgo:"E21ED176-0B54-401C-9FD9-F4376AA1B8B6",WeeksAgo:"C887168A-B5E3-4547-B8C7-190555956062",MonthsAgo:"10051306-DC98-45A3-B9BB-9C1C1FD06FC2",YearsAgo:"D903B3D9-796E-45F2-BE6F-EC676863C0B5"},MedicalDeviceType:{Active:"ACTIVE",Inactive:"INACTIVE",Deleted:"DELETED",Lookup:"LOOKUP"},MedicalDeviceTimeFrameId:{Active:"1ABDD322-28A6-4D56-8A7F-F5F6452A2715",Inactive:"85A955B8-C83F-415E-AF95-D779E457FDFC"}}),function(angular){"use strict";angular.module("aprima-fnc").component("hxMedication",{templateUrl:"/fnc/tabs/hx/medication/component-views/hxMedication.html",bindings:{allowRefillFromHxOnly:"<",hostedFromDesktop:"<",isCompleted:"<",patientId:"<",prescriberRights:"<",prmState:"<",transitionOfCareInit:"<",visitId:"<",medicationRefilled:"&",medicationChanged:"&",refillFromHxOnly:"&",refreshed:"&",registerRefillFromHxOnlyCallback:"&",registerTabSelectedCallback:"&",kdbParameters:"<?"},controller:["$q","$scope","_","apConfirmService","aprgettext","Bridge","DeviceSettings","DrugCoreService","DrugDetailModal","DrugDocumentationModal","EpaService","ErrorService","FncRxDrugSearchModal","FncRxRepository","FncRxService","Guid","HxChangeFromHistoryOnlySigwriterModal","HxDrugSearchModal","HxMedicationDiscontinueCancelModal","HxMedicationRepository","HxMedicationService","HxRefillSigwriterModal","HxChangeSigwriterModal","HxSigwriterModal","MedicationHistoryFilterSubtype","PdpmpModalService","PdpmpRepository","PrmState","SaveRxModal","SigwriterDrugScreeningService","SigwriterDrugSearchService","SigwriterRxService","toaster",function($q,$scope,_,apConfirmService,aprgettext,Bridge,DeviceSettings,DrugCoreService,DrugDetailModal,DrugDocumentationModal,EpaService,ErrorService,FncRxDrugSearchModal,FncRxRepository,FncRxService,Guid,HxChangeFromHistoryOnlySigwriterModal,HxDrugSearchModal,HxMedicationDiscontinueCancelModal,HxMedicationRepository,HxMedicationService,HxRefillSigwriterModal,HxChangeSigwriterModal,HxSigwriterModal,MedicationHistoryFilterSubtype,PdpmpModalService,PdpmpRepository,PrmState,SaveRxModal,SigwriterDrugScreeningService,SigwriterDrugSearchService,SigwriterRxService,toaster){var vm=this,pendingRefresh=!1,canSendEpa=!1,deferredDesktopGetPrescriptionHistory=null,emptyFilter={FilterId:Guid.empty(),Name:"",IsLastSelected:!1,ActiveFilter:"All",MaintenanceFilter:"All"};vm.currentMedicationFilter=emptyFilter,vm.flattenedRxHistory=null,vm.loadHistoryFiltersError=null,vm.loadingHistoryFilters=!1,vm.loadingMedicationHistory=!1,vm.loadingQueuedMedications=!1,vm.loadMedicationHistoryError=null,vm.loadQueuedMedicationsError=null,vm.medHxs=[],vm.medicationActions=[{Id:"1",Name:"Refill",Description:"Initiate a refill",Hide:function(rxHistoryMed){return!isInFnc()&&!vm.allowRefillFromHxOnly||!rxHistoryMed||!rxHistoryMed.CanRefill||!vm.prescriberRights||!vm.prescriberRights.IsAllowedRxWrite||!vm.prescriberRights.IsAllowedRxRefill||!vm.prescriberRights.AuthorizedPrescribers||!vm.prescriberRights.AuthorizedPrescribers.length||vm.isCompleted},Action:refillMedication},{Id:"2",Name:"D/C",Description:"Discontinue the drug",Hide:function(rxHistoryMed){return!rxHistoryMed.CanDiscontinue||isInRxRefillMessage()},Action:function(rxHistoryMed){var rpmIds=[];rpmIds.push(rxHistoryMed.RelPatientMedicationUid),HxMedicationDiscontinueCancelModal.openModal(rpmIds,vm.patientId,vm.visitId).then(function(){var selMedHxItems=_.filter(getSelectedMedications(),function(medHxItem){return medHxItem.RelPatientMedicationUid!==rxHistoryMed.RelPatientMedicationUid});Bridge.fireEvent("hx-rx-discontinue",{}),vm.refresh(selMedHxItems)})}},{Id:"3",Name:"Change",Description:"Change the current",Hide:function(rxHistoryMed){return!(isInFnc()||isInPatientDemographics())||!rxHistoryMed||!rxHistoryMed.CanChangeMedication||!vm.prescriberRights||!vm.prescriberRights.IsAllowedRxWrite||!vm.prescriberRights.IsAllowedRxRefill||isInRxRefillMessage()},Action:function(rxHistoryMed){if(isInPatientDemographics())return void function(rxHistoryMed){if(!rxHistoryMed||!rxHistoryMed.CanChangeMedication)return;var patientId=vm.patientId,visitId=vm.visitId,changeRxVisitId="00000000-0000-0000-0000-000000000000";function openChangeFromHistoryOnlySigwriter(rx){var options={rx:rx};HxChangeFromHistoryOnlySigwriterModal.openModal(rxHistoryMed,options,changeRxVisitId).then(changeFromHistoryOnlyCompleted)}function changeFromHistoryOnlyCompleted(){vm.refresh()}FncRxRepository.startChangeFromHistoryOnly(patientId,visitId,rxHistoryMed.RelPatientMedicationUid,"ChangeRx").then(function(result){changeRxVisitId=result.VisitInfo.VisitId,result.VisitInfo.visitId=null,result.VisitInfo.VisitId=null,SigwriterRxService.loadFromSigwriterResultsDto("ChangeRx",patientId,result.Prescription,result.VisitInfo).then(openChangeFromHistoryOnlySigwriter)}).catch(function(error){!function(error,toasterMessage){toaster.error(toasterMessage);var errMsg=ErrorService.convertToErrorMessages(error);console.log(toasterMessage),console.log(errMsg)}(error,"Error initializing change from history only")})}(rxHistoryMed);var patientId=vm.patientId,visitId=vm.visitId,sigType="ChangeRx";if(!rxHistoryMed||!rxHistoryMed.CanChangeMedication)return;function openChangeSigwriter(rx){var options={rx:rx};HxChangeSigwriterModal.openModal(rxHistoryMed,options).then(function(results){var prescription,changedMedication;prescription=results.prescription,changedMedication=results.visitMedication,vm.refresh(),function(prescription,changedMedication,sigType){vm.medicationChanged({prescription:prescription,changedMedication:changedMedication,sigType:sigType}),FncRxService.postAddRelVisitMedication(vm.visitId,changedMedication.RelVisitMedicationId,prescription.FromDesktop)}(prescription,changedMedication,sigType)})}FncRxRepository.startChange(patientId,visitId,rxHistoryMed.RelPatientMedicationUid,sigType).then(function(result){SigwriterRxService.loadFromSigwriterResultsDto(sigType,patientId,result.Prescription,result.VisitInfo).then(openChangeSigwriter)}).catch(function(error){var consoleMessage="Unknown error initializing change";error&&error.data&&error.data.ModelState&&error.data.ModelState.commandResult&&0<error.data.ModelState.commandResult.length&&(consoleMessage=error.data.ModelState.commandResult[0]),toaster.error(consoleMessage)})}},{Id:"4",Name:"Detail",Description:"Detail",Action:showDetail},{Id:"5",Name:"PDR",Description:"Show PDR",Hide:function(rxHistoryMed){return!rxHistoryMed.CanShowPdr},Action:function(rxHistoryMed){DrugDocumentationModal.openModal(rxHistoryMed.Sig.FdbMedId,rxHistoryMed.Sig.NDC,vm.patientId)}},{Id:"6",Name:"Print",Description:"Print",Hide:function(rxHistoryMed){return!rxHistoryMed.CanPrint||isInRxRefillMessage()},Action:function(rxHistoryMed){var vm={RelVisitMedicationId:rxHistoryMed.RelVisitMedicationUid};Bridge.fireEvent("visitmedication-print",vm)}},{Id:"7",Name:"Delete",Description:"Delete",Hide:function(rxHistoryMed){return!rxHistoryMed.CanDelete||isInRxRefillMessage()},Action:deleteMedication},{Id:"8",Name:"ePA",Description:"Send ePA request",Hide:function(){return!canSendEpa||isInRxRefillMessage()},Action:function(rxHistoryMed){return EpaService.trySendEpaRequest(rxHistoryMed).catch(function(error){var errorMessages=ErrorService.convertToErrorMessages(error);return console.error(errorMessages),$q.reject(error)})}}],vm.queuedMedicationActions=[{Id:"4",Name:"Detail",Description:"Detail",Action:function(visitRxMed){var medId=visitRxMed.Sig&&visitRxMed.Sig.MedId||0;DrugDetailModal.openModal(null,medId,vm.patientId,null,null,null,!1)}},{Id:"7",Name:"Delete",Description:"Delete",Action:deleteQueuedMedication}],vm.medicationBulkActions=[{Id:"1",Name:"Refill",Description:"Initiate a refill",Hide:function(){return!isInFnc()&&!vm.allowRefillFromHxOnly||!vm.prescriberRights||!vm.prescriberRights.IsAllowedRxWrite||!vm.prescriberRights.IsAllowedRxRefill||!vm.prescriberRights.AuthorizedPrescribers||!vm.prescriberRights.AuthorizedPrescribers.length||vm.isCompleted},Action:function(){var selectedMedications=getSelectedMedications();if(!isInFnc())return void refillMedicationsFromHistoryOnly(selectedMedications);bulkRefillMedications(selectedMedications)}},{Id:"2",Name:"D/C",Description:"Discontinue the drug",Action:function(){var rpmIds=getSelectedMedications().map(function(rxHistoryMed){return rxHistoryMed.RelPatientMedicationUid});rpmIds&&0<rpmIds.length&&HxMedicationDiscontinueCancelModal.openModal(rpmIds,vm.patientId,vm.visitId).then(function(){vm.refresh()})}}],vm.medicationFilterList=[],vm.multipleSelected=!1,vm.rxHistory={},vm.transitionOfCare={},vm.$onInit=function(){vm.transitionOfCare={Value:!!vm.transitionOfCareInit},refreshFilters(),function(){if(vm.controlledSubstanceHxActive=!1,vm.controlledSubstanceHxConfig=void 0,isInHxPatientMedication())return;PdpmpRepository.getConfiguration().then(function(config){vm.controlledSubstanceHxActive=PdpmpModalService.shouldAllowModal(config),vm.controlledSubstanceHxConfig=config})}(),vm.registerRefillFromHxOnlyCallback({callbackFn:onRefillFromHxOnly}),vm.registerTabSelectedCallback({callbackFn:onTabSelected}),EpaService.getSendEpaPermission().then(function(permission){return canSendEpa=permission&&permission.IsAllowed,permission}).catch(function(error){canSendEpa=!1;var errorMessages=ErrorService.convertToErrorMessages(error);return console.error(errorMessages),$q.reject(error)}),Bridge.on("loaded-rx-history",$scope,desktopLoadedPrescriptionHistory),Bridge.on("load-rx-history-error",$scope,desktopGetPrescriptionHistoryError)},vm.collapseFlattenedItem=function(flattenedItem){flattenedItem.isCollapsed=!flattenedItem.isCollapsed},vm.deleteMedication=deleteMedication,vm.deleteQueuedMedication=deleteQueuedMedication,vm.getFlattenedItemClass=function(flattenedItem){switch(flattenedItem.type){case"Group":return flattenedItem.parentItem?"hx-rx-group hx-rx-subgroup":"hx-rx-group";case"Medication":return"hx-rx-medication "+getMedicationClass(flattenedItem.rxHistoryMed);case"ChildMedication":return"hx-rx-medication hx-rx-child-medication "+getMedicationClass(flattenedItem.rxHistoryMed);default:return""}},vm.isInRxTab=isInRxTab,vm.isInRxRefillMessage=isInRxRefillMessage,vm.onClickControlledSubstanceHx=function(){PdpmpModalService.openModal(vm.controlledSubstanceHxConfig,Guid.empty(),Guid.empty(),Guid.empty(),vm.visitId)},vm.onClickModifyFilter=function(){if(vm.shouldShowModifyFilter){var setMedicationFilterDto={FilterId:vm.currentMedicationFilter.FilterId,PrmState:vm.prmState};Bridge.fireEvent("modify-medication-filter",setMedicationFilterDto)}},vm.onClickSearchDrugs=function(){var patientId=vm.patientId,visitId=vm.visitId,kdbParameters=vm.kdbParameters;function openSigwriter(rx){var options={hostedFromDesktop:!!vm.hostedFromDesktop,rx:rx};Bridge.fireEvent("hxsigwriter-open",{});var modalPromise=HxSigwriterModal.openModal(options).then(onSigCompleted).finally(function(){Bridge.fireEvent("hxsigwriter-close",{})});return modalPromise}function skipSigwriter(rx){if(!rx)return $q.reject("Error trying to skip sigwriter and add medication: empty rx");var screenAndSavePromise=SigwriterDrugScreeningService.performDrugScreening(rx.drugScreening.overrideText,rx.drug,patientId,vm.visitId,null).then(function(screeningResult){screeningResult&&(rx.drugScreening.overrideText=screeningResult.overrideText,rx.drugScreening.screeningResult=screeningResult.screeningResult);var sigwriterResults=SigwriterRxService.mapToSigwriterResultsDto(rx);sigwriterResults.FromDesktop=!!vm.hostedFromDesktop;var prescriptionPromise=HxMedicationRepository.addPrescription(patientId,vm.visitId,!0,sigwriterResults).then(onSigCompleted);return prescriptionPromise});return screenAndSavePromise}function onSigCompleted(){Bridge.fireEvent("hx-rx-added",{}),vm.refresh()}HxDrugSearchModal.openModal(patientId,kdbParameters).then(function(result){HxMedicationService.handleDrugSearchResult(result,patientId,visitId,openSigwriter,skipSigwriter)})},vm.onClickAddToRefillMessage=function(){if(!shouldShowAddMedicationToRefillMessage())return;var selectedMedications=_(getSelectedMedications()).filter({CanRefill:!0}).map(function(med){return{RelPatientMedicationUid:med.RelPatientMedicationUid,RelVisitMedicationUid:med.RelVisitMedicationUid,Description:med.Description}}).value();selectedMedications&&0<selectedMedications.length?vm.refillFromHxOnly({selectedMedications:selectedMedications}):apConfirmService.confirm("None of the selected medications can be refilled.")},vm.onSelectFilter=onSelectFilter,vm.openRxInfo=function(rxHistoryMed){Bridge.fireEvent("visitmedication-openinfo",rxHistoryMed.InfoButtonData)},vm.refresh=function(selMedHxItems){if(vm.loadingMedicationHistory||vm.loadingTransitionOfCare||vm.loadingQueuedMedications)return void(pendingRefresh=!0);pendingRefresh=!1;var transitionOfCarePromise=shouldShowTransitionOfCare()&&!vm.hostedFromDesktop?(vm.loadingTransitionOfCare=!0,HxMedicationRepository.getTransitionOfCare(vm.patientId,vm.visitId).then(function(transitionOfCare){vm.transitionOfCare=transitionOfCare}).catch(function(error){vm.transitionOfCare={},console.log(ErrorService.convertToErrorMessages(error))}).finally(function(){vm.loadingTransitionOfCare=!1})):$q.when([]),promises=[function(){vm.loadingMedicationHistory=!0;var loadFn,filterId=vm.currentMedicationFilter?vm.currentMedicationFilter.FilterId:Guid.empty();loadFn=vm.hostedFromDesktop?desktopGetPrescriptionHistory:HxMedicationRepository.getPrescriptionHistory;return loadFn(vm.patientId,vm.visitId,filterId).then(function(data){vm.loadMedicationHistoryError=null,vm.rxHistory=data,function(){var flattenedRxHistory={items:[]},medHxs=[];function flattenGroup(parentItem,group){if(group.Groups){var flattenedItem={group:group,parentItem:parentItem,type:"Group"};flattenedRxHistory.items.push(flattenedItem),group.Groups.forEach(function(group){flattenGroup(flattenedItem,group)})}else group.Subgroups.forEach(function(subgroup){!function(parentItem,subgroup){var primaryMedItem=flattenMedication(parentItem,!1,subgroup.PrimaryMedication);primaryMedItem.isCollapsed=!0,primaryMedItem.totalChildren=subgroup.Medications.length,subgroup.Medications.forEach(function(med){flattenMedication(primaryMedItem,!0,med)})}(parentItem,subgroup)})}function flattenMedication(parentItem,isChildMedication,rxHistoryMed){var flattenedItem={parentItem:parentItem,rxHistoryMed:rxHistoryMed,type:isChildMedication?"ChildMedication":"Medication"};return flattenedRxHistory.items.push(flattenedItem),medHxs.push(rxHistoryMed),flattenedItem}vm.rxHistory.Groups.forEach(function(group){flattenGroup(null,group)}),vm.flattenedRxHistory=flattenedRxHistory,vm.medHxs=medHxs}(),updateSelected(),function(meds){if(!meds||_.isEmpty(meds))return;var ids=_.map(meds,"RelPatientMedicationUid");HxMedicationRepository.getPatientMedStatuses(ids).then(function(statusObj){_.forEach(meds,function(med){med.status=statusObj[med.RelPatientMedicationUid]})}).catch(function(error){var errorMessages=ErrorService.convertToErrorMessages(error);console.error(errorMessages)})}(vm.medHxs)}).catch(function(error){vm.loadMedicationHistoryError=ErrorService.convertToErrorMessages(error)}).finally(function(){vm.loadingMedicationHistory=!1})}(),transitionOfCarePromise,(vm.loadingQueuedMedications=!0,vm.loadQueuedMedicationsError=null,FncRxRepository.getQueuedMedications(vm.patientId).then(function(data){vm.queuedMedications=data}).catch(function(error){vm.loadQueuedMedicationsError=ErrorService.convertToErrorMessages(error)}).finally(function(){vm.loadingQueuedMedications=!1}))];$q.allSettled(promises).finally(function(){pendingRefresh?vm.refresh():vm.loadHistoryFiltersError||vm.loadMedicationHistoryError||vm.loadQueuedMedicationsError||(void 0!==selMedHxItems&&selMedHxItems&&0<selMedHxItems.length&&(_.forEach(vm.medHxs,function(med){_.some(selMedHxItems,{RelPatientMedicationUid:med.RelPatientMedicationUid})?med.IsSelected=!0:med.IsSelected=!1}),updateSelected()),onRefreshed())})},vm.shouldShowAddMedication=function(){return!isInRxTab()&&!isInRxRefillMessage()},vm.shouldShowAddMedicationToRefillMessage=shouldShowAddMedicationToRefillMessage,vm.shouldShowFlattenedItem=function shouldShowFlattenedItem(flattenedItem){if(!flattenedItem)return!1;if(!flattenedItem.parentItem)return!0;if(flattenedItem.parentItem.isCollapsed)return!1;return shouldShowFlattenedItem(flattenedItem.parentItem)},vm.shouldShowMultiHxActions=function(){return!isInRxRefillMessage()},vm.shouldShowPatientTakesNoMeds=function(){return!isInRxRefillMessage()},vm.shouldShowTransitionOfCare=shouldShowTransitionOfCare,vm.updatePatientTakesNoMeds=function(){HxMedicationRepository.setPatientTakesNoMeds(vm.patientId,vm.visitId,vm.rxHistory.PatientTakesNoMeds).then(function(patientTakesNoMeds){vm.rxHistory.PatientTakesNoMeds=patientTakesNoMeds,onRefreshed(),Bridge.fireEvent("patienttakesnomeds-update",vm.rxHistory.PatientTakesNoMeds)}).catch(function(error){var message=aprgettext("Failed to save Patient Takes No Meds.");toaster.pop("error","",message);var errorMessage=ErrorService.convertToErrorMessages(error);console.error(errorMessage)})},vm.updateTransitionOfCare=function(){vm.hostedFromDesktop?Bridge.fireEvent("transitionofcare-update",vm.transitionOfCare):HxMedicationRepository.setTransitionOfCare(vm.patientId,vm.visitId,vm.transitionOfCare).then(function(transitionOfCare){vm.transitionOfCare=transitionOfCare}).catch(function(error){var message=aprgettext("Failed to save Transition of Care.");toaster.pop("error","",message);var errorMessage=ErrorService.convertToErrorMessages(error);console.error(errorMessage)})},vm.updateSelected=updateSelected,vm.showDetail=showDetail,vm.controlledSubstanceHxActive=!1,vm.controlledSubstanceHxConfig=void 0,vm.showMitochonBanner=!1,vm.shouldShowModifyFilter=DeviceSettings.isPrm,vm.mitochonHTML="";var pendingFilterRefresh=!1;function bulkRefillMedications(selectedMedications){var selectedRefillableMedications=[],selectedUnrefillableMedications=[];if(selectedMedications.forEach(function(rxHistoryMed){rxHistoryMed.CanRefill?selectedRefillableMedications.push(rxHistoryMed):selectedUnrefillableMedications.push(getShortDescription(rxHistoryMed))}),0===selectedRefillableMedications.length)apConfirmService.confirm("None of the selected medications can be refilled");else if(0<selectedUnrefillableMedications.length){var message="The following medications can't be refilled: "+selectedUnrefillableMedications.join(", ");apConfirmService.confirm(message).then(function(shouldContinue){shouldContinue&&(1===selectedRefillableMedications.length?refillMedication(selectedRefillableMedications[0]):bulkRefillInternal(selectedMedications,selectedRefillableMedications))})}else bulkRefillInternal(selectedMedications,selectedRefillableMedications)}function bulkRefillInternal(selectedMedications,selectedRefillableMedications){var patientId=vm.patientId,visitId=vm.visitId,rpmIds=selectedRefillableMedications.map(function(rxHistoryMed){return rxHistoryMed.RelPatientMedicationUid});FncRxRepository.startRefills(patientId,visitId,rpmIds,"NewRx").then(function(result){var refillables=[],unrefillables=[];if(result.Refills.forEach(function(refill){refill.Prescription&&refill.CanSkipSigwriter?refillables.push(refill):unrefillables.push(refill)}),0===refillables.length)apConfirmService.confirm("All of the selected medications must be refilled individually");else if(0<unrefillables.length){var unrefillableMedNames=[];selectedMedications.forEach(function(rxHistoryMed){unrefillables.some(function(unrefillable){return rxHistoryMed.RelPatientMedicationUid===unrefillable.RelPatientMedicationId})&&unrefillableMedNames.push(getShortDescription(rxHistoryMed))});var message="The following medications must be refilled individually: "+unrefillableMedNames.join(", ");apConfirmService.confirm(message).then(function(shouldContinue){shouldContinue&&doBulkRefill()})}else doBulkRefill();function doBulkRefill(){DrugCoreService.validateDrugs(_.map(refillables,"Prescription.Drug"),"NewRx").then(function(){SigwriterDrugScreeningService.showDrugScreening(null,result.DrugScreening).then(function(screeningResult){var savePromises=[];refillables.forEach(function(refill){var prescription=refill.Prescription;prescription.FromDesktop=!!vm.hostedFromDesktop,prescription.ScreeningOverride=screeningResult.overrideText,prescription.ScreeningResult=screeningResult.screeningResult;var savePromise=FncRxRepository.refillMedication(patientId,visitId,refill.RelPatientMedicationId,prescription);savePromise.then(function(refilledMedication){onMedicationRefilled(prescription,refilledMedication,"NewRx")}),savePromises.push(savePromise)}),SaveRxModal.openModal($q.all(savePromises)).finally(function(){vm.refresh()})})})}}).catch(function(error){var errorMessages=ErrorService.convertToErrorMessages(error);toaster.error("Unable to refill the medications. Error = "+errorMessages),console.log(errorMessages)})}function deleteMedication(rxHistoryMed){apConfirmService.confirm("Are you sure you want to delete "+rxHistoryMed.Description+"?","Yes","No").then(function(result){result&&HxMedicationRepository.deleteMedication(rxHistoryMed,vm.visitId).catch(function(error){var errorMessages=ErrorService.convertToErrorMessages(error);toaster.error("Unable to delete medication. Error = "+errorMessages),console.log(errorMessages)}).finally(function(){Bridge.fireEvent("hx-rx-deleted",{}),vm.refresh()})})}function deleteQueuedMedication(visitRxMed){apConfirmService.confirm("Are you sure you want to delete "+visitRxMed.Description+"?","Yes","No").then(function(result){result&&FncRxRepository.deleteQueuedMedication(visitRxMed.RelVisitMedicationId).catch(function(error){var errorMessages=ErrorService.convertToErrorMessages(error);toaster.error("Unable to delete medication. Error = "+errorMessages),console.log(errorMessages)}).finally(function(){vm.refresh()})})}function desktopGetPrescriptionHistory(patientId,visitId,filterId){return deferredDesktopGetPrescriptionHistory=$q.defer(),Bridge.fireEvent("load-rx-history",{PatientId:patientId,VisitId:visitId,FilterId:filterId}),deferredDesktopGetPrescriptionHistory.promise}function desktopGetPrescriptionHistoryError(error){deferredDesktopGetPrescriptionHistory.reject(error)}function desktopLoadedPrescriptionHistory(rxHistory){deferredDesktopGetPrescriptionHistory.resolve(rxHistory)}function getMedicationClass(rxHistoryMed){var result;return result=rxHistoryMed.IsActive?rxHistoryMed.IsDeleted?"fnc-rx-strikeout":rxHistoryMed.IsMaintenanceAfterStopDate?"fnc-rx-medication-bold":"fnc-rx-medication-normal":rxHistoryMed.IsDeleted?"fnc-rx-medication-italic fnc-rx-strikeout":"fnc-rx-medication-italic",rxHistoryMed.IsHighRisk&&(result+=" high-risk"),rxHistoryMed.IsHazardousDrug&&(result+=" hazardous"),result}function getShortDescription(rxHistoryMed){var drugName=rxHistoryMed.Sig&&rxHistoryMed.Sig.DrugName;return drugName||rxHistoryMed.Description}function getSelectedMedications(){return _.filter(vm.medHxs,{IsSelected:!0})}function isInFnc(){return isInHxTab()||isInRxTab()}function isInHxTab(){return vm.prmState===PrmState.Fnc.HxTab}function isInRxTab(){return vm.prmState===PrmState.Fnc.RxTab}function isInRxRefillMessage(){return vm.prmState===PrmState.Message.ManualRxRefill}function isInPatientDemographics(){return isInHxPatientMedication()}function isInHxPatientMedication(){return vm.prmState===PrmState.History.Patient.Medication}function refreshFilters(){vm.loadingHistoryFilters?pendingFilterRefresh=!0:(pendingFilterRefresh=!1,function(){vm.loadingHistoryFilters=!0;var subtype=vm.prmState===PrmState.Fnc.RxTab?MedicationHistoryFilterSubtype.Rx:MedicationHistoryFilterSubtype.Default;return HxMedicationRepository.getMedicationListFilters(subtype).then(function(data){vm.loadHistoryFiltersError=null,vm.medicationFilterList=data,vm.medicationFilterList.unshift(emptyFilter)}).catch(function(error){vm.loadHistoryFiltersError=ErrorService.convertToErrorMessages(error)}).finally(function(){vm.loadingHistoryFilters=!1})}().finally(function(){if(pendingFilterRefresh)refreshFilters();else{var filter=_(vm.medicationFilterList).find({IsLastSelected:!0});filter&&(vm.currentMedicationFilter=filter,vm.refresh())}}))}function onMedicationRefilled(prescription,refilledMedication,sigType){vm.medicationRefilled({prescription:prescription,refilledMedication:refilledMedication,sigType:sigType}),FncRxService.postAddRelVisitMedication(vm.visitId,refilledMedication.RelVisitMedicationId,prescription.FromDesktop)}function onSelectFilter(filter,fromModifyFilter){vm.currentMedicationFilter=filter;var subtype=vm.prmState===PrmState.Fnc.RxTab?MedicationHistoryFilterSubtype.Rx:MedicationHistoryFilterSubtype.Default,setMedicationFilterDto={FilterId:filter.FilterId,FilterSubtype:subtype};HxMedicationRepository.setMedicationFilter(setMedicationFilterDto).then(function(){if(subtype===MedicationHistoryFilterSubtype.Default){var patientMedicationHistoryFilterDto={FilterId:filter.FilterId};Bridge.fireEvent("set-patient-medication-history-filter",patientMedicationHistoryFilterDto)}fromModifyFilter?refreshFilters():vm.refresh()})}function onRefreshed(){var hasHxData=vm.rxHistory&&(0<vm.rxHistory.TotalHistoryMedications||vm.rxHistory.PatientTakesNoMeds&&vm.rxHistory.PatientTakesNoMeds.Value);vm.refreshed({hasHxData:hasHxData})}function onRefillFromHxOnly(request){request.SelectedMedications&&request.SelectedMedications.length&&(1<request.SelectedMedications.length?bulkRefillMedications(request.SelectedMedications):refillMedication(request.SelectedMedications[0]))}function onTabSelected(){vm.refresh()}function refillMedication(rxHistoryMed){if(isInFnc()){var patientId=vm.patientId,visitId=vm.visitId,sigType="NewRx";if(rxHistoryMed&&rxHistoryMed.CanRefill)if(rxHistoryMed.Sig&&rxHistoryMed.Sig.FdbMedId)FncRxService.refillFromHx(sigType,rxHistoryMed,patientId,visitId,vm.hostedFromDesktop).then(function(results){refillCompleted(results.prescription,results.visitMedication)});else{var initialText=rxHistoryMed.Sig&&rxHistoryMed.Sig.DrugName||"",kdbParameters=vm.kdbParameters;FncRxDrugSearchModal.openModal(patientId,initialText,kdbParameters).then(function(searchResult){var visitInfo={visitId:visitId};SigwriterDrugSearchService.createNewRxFromDrugSearchResult(sigType,searchResult.drugSearchResult,searchResult.switchToGeneric,searchResult.dosingSuggestion,searchResult.useEnhancedDrugSearch,patientId,!1,!0,visitInfo).then(function(rx){!function(rx){var options={rx:rx};HxRefillSigwriterModal.openModal(rxHistoryMed,options,!!vm.hostedFromDesktop).then(function(results){refillCompleted(results.prescription,results.visitMedication)})}(rx)}).catch(function(){toaster.error("Unknown error initializing SIG Writer")})})}}else{if(!rxHistoryMed)return;refillMedicationsFromHistoryOnly([rxHistoryMed])}function refillCompleted(prescription,refilledMedication){vm.refresh(),onMedicationRefilled(prescription,refilledMedication,sigType)}}function shouldShowAddMedicationToRefillMessage(){return isInRxRefillMessage()}function shouldShowTransitionOfCare(){return isInHxTab()}function showDetail(rxHistoryMed){var medId=rxHistoryMed.Sig&&rxHistoryMed.Sig.FdbMedId||0;DrugDetailModal.openModal(null,medId,vm.patientId,rxHistoryMed.RelPatientMedicationUid,null,null,!1)}function updateSelected(){var selectedMedications=getSelectedMedications(),numberSelected=selectedMedications.length;vm.multipleSelected=1<numberSelected}function refillMedicationsFromHistoryOnly(medicationsToRefill){if(medicationsToRefill&&0!==medicationsToRefill.length){for(var hxMedsToRefill=_.cloneDeep(medicationsToRefill),indx=0;indx<hxMedsToRefill.length;indx++)hxMedsToRefill[indx].status&&delete hxMedsToRefill[indx].status;vm.refillFromHxOnly({selectedMedications:hxMedsToRefill})}}Bridge.on("modify-medication-filter-result",null,function(data){onSelectFilter(data,!0)})}]})}(angular),function(angular){"use strict";angular.module("aprima-fnc").component("hxMedicationDiscontinueCancel",{templateUrl:"/fnc/tabs/hx/medication/component-views/hxMedicationDiscontinueCancel.html",bindings:{patientId:"<",visitId:"<",medications:"<",providers:"<",selectedIds:"<",formReference:"<",defaultProviderIds:"<"},controller:["$q","ErrorService","FncRxPharmacySearchModal","GeneralNotesModal","GeneralNoteTypeKeys","RxChangeConstants","HxDrugReactionModal","HxMedicationDiscontinueCancelWarningModal","HxMedicationRepository","HxMedicationService","ListService","MedDiscontinueCancelConstants","MedDiscontinueCancelService","ProviderRepository","RxChangeService","toaster",function($q,ErrorService,FncRxPharmacySearchModal,GeneralNotesModal,GeneralNoteTypeKeys,RxChangeConstants,HxDrugReactionModal,HxMedicationDiscontinueCancelWarningModal,HxMedicationRepository,HxMedicationService,ListService,MedDiscontinueCancelConstants,MedDiscontinueCancelService,ProviderRepository,RxChangeService,toaster){var vm=this;function setDefaultForSendCancelMessageCheckbox(){null===vm.medications||vm.medications.length<=0||_.forEach(vm.medications,function(medication){medication.CanCancelMedication&&medication.CancelMedicationIsSelectedByDefault&&(medication.SendCancelMessage=!0)})}function onChangeProvider(){vm.selectedIds.providerId&&function(providerId){if(vm.supervisorList=[],vm.selectedIds.supervisorId=MedDiscontinueCancelConstants.Guid.Empty,(vm.loadSupervisorListError=null)===providerId||providerId===MedDiscontinueCancelConstants.Guid.Empty)return vm.loadingSupervisorList=!1;vm.loadingSupervisorList=!0,ProviderRepository.getProviderSupervisorListByProviderId(providerId).then(function(providerSupervisorsDto){vm.supervisorList=providerSupervisorsDto.Supervisors}).catch(function(error){vm.loadSupervisorListError=ErrorService.convertToErrorMessages(error),toaster.error("Unable to retrieve provider supervisor list. Error =  "+vm.loadSupervisorListError),console.log(vm.loadSupervisorListError)}).finally(function(){vm.supervisorList&&0<vm.supervisorList.length&&(vm.selectedIds.supervisorId=MedDiscontinueCancelService.getProviderSupervisorDefaultForDiscontinueCancelView(vm.supervisorList,vm.medications)),vm.loadingSupervisorList=!1})}(vm.selectedIds.providerId)}function updateSelectedPharmacies(pharmacy){pharmacy&&0!==_.size(vm.medications)&&_.forEach(vm.medications,function(medication){medication.PharmacySelected&&(medication.Pharmacy=pharmacy)})}function updateChangePharmacyEnabled(){vm.changePharmacyEnabled=!1,_.some(vm.medications,"PharmacySelected")&&(vm.changePharmacyEnabled=!0)}vm.changePharmacyEnabled=!1,vm.discontinueReasonList=[],vm.loadDiscontinueReasonListError=null,vm.loadServiceSiteListError=null,vm.loadSupervisorListError=null,vm.loadingDiscontinueReasonList=!0,vm.loadingIsRxOnPatientAllergyList=!1,vm.loadingIsRxOnPatientAllergyListError=null,vm.loadingProviderList=!0,vm.loadingServiceSiteList=!0,vm.loadingSupervisorList=!0,vm.maxInternalNoteCharacters=HxMedicationService.getMaxDiscontinueReasonCharacters(),vm.serviceSiteList=[],vm.supervisorList=[],vm.selectAllPharmacies=!1,vm.$onInit=function(){setDefaultForSendCancelMessageCheckbox(),vm.loadingDiscontinueReasonList=!0,vm.discontinueReasonList=[],vm.loadDiscontinueReasonListError=null,ListService.getList("discontinuereasons").then(function(discontinueReasonListDto){vm.discontinueReasonList=discontinueReasonListDto}).catch(function(error){vm.loadDiscontinueReasonListError=ErrorService.convertToErrorMessages(error),toaster.error("Unable to retrieve discontinue reasons. Error =  "+vm.loadDiscontinueReasonListError),console.log(vm.loadDiscontinueReasonListError)}).finally(function(){vm.loadingDiscontinueReasonList=!1}),vm.loadingServiceSiteList=!0,vm.serviceSiteList=[],vm.loadServiceSiteListError=null,vm.selectedIds.serviceSiteId=MedDiscontinueCancelConstants.Guid.Empty,ListService.getList("servicesite").then(function(serviceSiteListDto){vm.serviceSiteList=_.filter(serviceSiteListDto,{InternalSite:!0})}).catch(function(error){vm.loadServiceSiteListError=ErrorService.convertToErrorMessages(error),toaster.error("Unable to retrieve service sites. Error =  "+vm.loadServiceSiteListError),console.log(vm.loadServiceSiteListError)}).finally(function(){vm.serviceSiteList&&0<vm.serviceSiteList.length&&(vm.selectedIds.serviceSiteId=MedDiscontinueCancelService.getServiceSiteDefaultForDiscontinueCancelView(vm.serviceSiteList,vm.medications)),vm.loadingServiceSiteList=!1})},vm.$onChanges=function(changes){changes.medications&&changes.medications.currentValue&&changes.providers&&changes.providers.currentValue&&(vm.loadingProviderList=!1,0<changes.providers.currentValue.length?(vm.selectedIds.providerId=MedDiscontinueCancelService.selectDefaultProvider(vm.defaultProviderIds,vm.providers),onChangeProvider()):vm.loadingSupervisorList=!1)},vm.onClickDiscontinueReasonClipboard=function(med){if(!med.CanDiscontinueMedication)return;function onDiscontinueReasonTextUpdated(result){med.AdditionalDiscontinueReasonText=result}GeneralNotesModal.openModal("Discontinue Reason",med.AdditionalDiscontinueReasonText,!0,vm.maxInternalNoteCharacters,GeneralNoteTypeKeys.DrugDiscontinueOverrideReason).then(onDiscontinueReasonTextUpdated)},vm.onClickDisplayCancelErrorMessages=function(med,elementId){if(console.log(elementId),!med.SendCancelMessage)return;if(med.CanCancelMedication)return;med.SendCancelMessage=!1;var cancelWarnings=[{RelPatientMedicationId:med.RelPatientMedicationId,Description:med.Description,CancelMedicationErrors:med.CancelMedicationErrors}];HxMedicationDiscontinueCancelWarningModal.openModal(cancelWarnings,vm.patientId,"CANCEL")},vm.onClickDisplayDetailView=function(med){console.log("onClickDisplayDetailView() - PatientMedicationId : "+med.RelPatientMedicationId),HxMedicationRepository.getCompareInfoForDiscontinueCancel(vm.patientId,med.RelPatientMedicationId).then(function(data){RxChangeService.displayRxMessageCompareModal(data,null,RxChangeConstants.CompareInfoModalCaller.DiscontinueCancel)}).catch(function(error){RxChangeService.displayErrorMessage("Unable to display detail view.",error)})},vm.onClickDisplayDiscontinueMessages=function(med){if(med.CanDiscontinueMedication)return;var cancelWarnings=[{RelPatientMedicationId:med.RelPatientMedicationId,Description:med.Description,DiscontinueMedicationErrors:med.DiscontinueMedicationErrors}];HxMedicationDiscontinueCancelWarningModal.openModal(cancelWarnings,vm.patientId,"DISCONTINUE")},vm.onClickSearchPharmacies=function(){if(!vm.changePharmacyEnabled)return;FncRxPharmacySearchModal.openModal(vm.patientId).then(function(pharmacy){updateSelectedPharmacies(pharmacy)})},vm.onClickSelectAllPharmacies=function(){_.forEach(vm.medications,function(medication){medication.CanCancelMedication?medication.PharmacySelected=vm.selectAllPharmacies:medication.PharmacySelected=!1}),updateChangePharmacyEnabled()},vm.onChangeProvider=onChangeProvider,vm.onDiscontinueReasonTypeChanged=function(med){if(med.DrugReactions=[],med.DrugReactionText="",vm.loadingIsRxOnPatientAllergyListError=null,med.DiscontinueReasonId!==MedDiscontinueCancelConstants.DiscontinueReasonId.AllergicReaction)return;vm.loadingIsRxOnPatientAllergyList=!0,HxMedicationRepository.isRxOnPatientAllergyList(vm.patientId,vm.visitId,med.RelPatientMedicationId).then(function(result){function onDrugReactionUpdated(result){med.DrugReactionText=result.DrugReactionText,med.DrugReactions=result.DrugReactions}vm.loadingIsRxOnPatientAllergyList=!1,result.IsRxOnPatientAllergyList||HxDrugReactionModal.openModal(vm.patientId).then(onDrugReactionUpdated)}).catch(function(error){vm.loadingIsRxOnPatientAllergyListError=ErrorService.convertToErrorMessages(error),toaster.error("Unable to determine if drug is on patient allergy list. Error =  "+vm.loadingIsRxOnPatientAllergyListError),console.log(vm.loadingIsRxOnPatientAllergyListError)}).finally(function(){vm.loadingIsRxOnPatientAllergyList=!1})},vm.updateSelectAllPharmacies=function(){vm.selectAllPharmacies=!1,_.every(vm.medications,"PharmacySelected")&&(vm.selectAllPharmacies=!0);updateChangePharmacyEnabled()}}]})}(angular),function(angular){"use strict";angular.module("aprima-fnc").component("medStatusIcon",{templateUrl:"/fnc/tabs/hx/medication/component-views/medStatusIcon.html",bindings:{medStatus:"<",iconSize:"@",hasDetails:"<",otherClass:"@",medType:"@"},controller:["MedStatusModal","MedStatusService",function(MedStatusModal,MedStatusService){var vm=this,getIconClassFn=angular.noop,getDefaultMessageFn=angular.noop;function getClass(){var fullClass="",iconClass=getIconClassFn(vm.medStatus&&vm.medStatus.Status);if(!iconClass)return"";fullClass+=iconClass;var sizeClass=MedStatusService.getSizeClass(vm.iconSize);return sizeClass&&(fullClass+=" "+sizeClass),vm.hasDetails&&(fullClass+=" clickable"),vm.otherClass&&(fullClass+=" "+vm.otherClass),fullClass}function showDetails(){vm.hasDetails&&vm.medStatus&&MedStatusModal.openModal(vm.medStatus,vm.medType,getDefaultMessageFn)}vm.$onInit=function(){"visit"===vm.medType?(getIconClassFn=MedStatusService.getVisitIconClass,getDefaultMessageFn=MedStatusService.getDefaultVisitMessage):"patient"===vm.medType&&(getIconClassFn=MedStatusService.getPatientIconClass,getDefaultMessageFn=MedStatusService.getDefaultPatientMessage);vm.getClass=getClass,vm.showDetails=showDetails}}],controllerAs:"vm"})}(window.angular),function(angular){"use strict";angular.module("aprima-fnc").factory("HxChangeFromHistoryOnlySigwriterModal",["$uibModal",function($modal){return{openModal:function(hxMed,options,changeRxVisitId){return openModalOnly(hxMed,options,changeRxVisitId).result},openModalOnly:openModalOnly};function openModalOnly(hxMed,options,changeRxVisitId){return $modal.open({templateUrl:"/fnc/tabs/hx/medication/views/hxSigwriterModal.html",windowClass:"modal-full modal-sigwriter-tablet",controller:"HxChangeFromHistoryOnlySigwriterModalCtrl",controllerAs:"vm",resolve:{hxMed:function(){return hxMed},options:function(){return options},changeRxVisitId:function(){return changeRxVisitId}}})}}]),angular.module("aprima-fnc").controller("HxChangeFromHistoryOnlySigwriterModalCtrl",["$uibModalInstance","hxMed","options","changeRxVisitId","FncRxRepository","SaveRxModal","SigwriterRxService",function($modalInstance,hxMed,options,changeRxVisitId,FncRxRepository,SaveRxModal,SigwriterRxService){this.options=options,this.cancel=function(){$modalInstance.dismiss()},this.completed=function(rx){var patientId=rx.patient.Id,visitId=changeRxVisitId,prescription=SigwriterRxService.mapToSigwriterResultsDto(rx),savePromise=FncRxRepository.changeMedicationFromHistoryOnly(patientId,visitId,hxMed.RelPatientMedicationUid,prescription);SaveRxModal.openModal(savePromise).then(function(changeFromHistoryOnlyResponseDto){$modalInstance.close({prescription:prescription,changeFromHistoryOnlyResponseDto:changeFromHistoryOnlyResponseDto})})}}])}(angular),function(angular){"use strict";angular.module("aprima-fnc").factory("HxChangeSigwriterModal",["$uibModal",function($modal){return{openModal:function(hxMed,options){return openModalOnly(hxMed,options).result},openModalOnly:openModalOnly};function openModalOnly(hxMed,options){return $modal.open({templateUrl:"/fnc/tabs/hx/medication/views/hxSigwriterModal.html",windowClass:"modal-full modal-sigwriter-tablet",controller:"HxChangeSigwriterModalCtrl",controllerAs:"vm",resolve:{hxMed:function(){return hxMed},options:function(){return options}}})}}]),angular.module("aprima-fnc").controller("HxChangeSigwriterModalCtrl",["$uibModalInstance","hxMed","options","FncRxRepository","SaveRxModal","SigwriterRxService",function($modalInstance,hxMed,options,FncRxRepository,SaveRxModal,SigwriterRxService){this.options=options,this.cancel=function(){$modalInstance.dismiss()},this.completed=function(rx){var patientId=rx.patient.Id,visitId=rx.visit.VisitId,prescription=SigwriterRxService.mapToSigwriterResultsDto(rx),savePromise=FncRxRepository.changeMedication(patientId,visitId,hxMed.RelPatientMedicationUid,prescription);SaveRxModal.openModal(savePromise).then(function(visitMedication){$modalInstance.close({prescription:prescription,visitMedication:visitMedication})})}}])}(angular),function(angular){"use strict";angular.module("aprima-fnc").factory("HxDrugReactionModal",["$uibModal",function($modal){return{openModal:function(patientId){var drugReactionArgs={patientId:patientId};return $modal.open({backdrop:"static",templateUrl:"/fnc/tabs/hx/medication/views/hxDrugReactionModal.html",windowClass:"modal-full",controller:"HxDrugReactionModalCtrl",controllerAs:"vm",resolve:{drugReactionArgs:drugReactionArgs}}).result}}}]),angular.module("aprima-fnc").controller("HxDrugReactionModalCtrl",["$uibModalInstance","DeviceSettings","drugReactionArgs","ErrorService","GeneralNotesModal","GeneralNoteTypeKeys","HxMedicationService","ListService","toaster",function($modalInstance,DeviceSettings,drugReactionArgs,ErrorService,GeneralNotesModal,GeneralNoteTypeKeys,HxMedicationService,ListService,toaster){var vm=this,answerGroupIdAllergyReaction="00000000-0000-0000-0000-000000108000";vm.drugReactionList=[],vm.drugReactionText="",vm.loadDrugReactionListError=null,vm.loadingDrugReaction=!1,vm.maxInternalNoteCharacters=HxMedicationService.getMaxDrugReactionCharacters(),vm.patientId=drugReactionArgs.patientId,vm.submittingDrugReactionRequest=!1,vm.onClickCancelButton=function(){$modalInstance.dismiss()},vm.onClickDrugReactionClipboard=function(){function onDrugReactionReasonTextUpdated(result){vm.drugReactionText=result}GeneralNotesModal.openModal("Drug Reaction Reason",vm.drugReactionText,!0,vm.maxInternalNoteCharacters,GeneralNoteTypeKeys.DrugReactionReason).then(onDrugReactionReasonTextUpdated)},vm.onClickSubmitButton=function(form){vm.submittingDrugReactionRequest=!0;var selectedReactions=_.filter(vm.drugReactionList,{IsSelected:!0}).map(function(drugReaction){var selectedItem={AnswerId:drugReaction.AnswerId,Name:drugReaction.Name};return selectedItem});if(selectedReactions.length<=0)return void toaster.pop("warning","",gettext("Please make a selection."));if(form.$valid){var result={DrugReactionText:vm.drugReactionText,DrugReactions:selectedReactions};$modalInstance.close(result)}vm.submittingDrugReactionRequest=!1},vm.shouldSwapButtons=function(){return DeviceSettings.isPrm},function(){vm.loadingDrugReaction=!0,vm.drugReactionList=[],vm.loadDrugReactionListError=null;var listObj={name:"answers-by-answer-group",params:{answerGroupId:answerGroupIdAllergyReaction}};ListService.getList(listObj).then(function(result){vm.drugReactionList=result.map(function(drugReaction){return drugReaction.IsSelected=!1,drugReaction})}).catch(function(error){vm.loadDrugReactionListError=ErrorService.convertToErrorMessages(error),toaster.error("Unable to retrieve allergy reaction list. Error =  "+vm.loadDrugReactionListError),console.log(vm.loadDrugReactionListError)}).finally(function(){vm.loadingDrugReaction=!1})}()}])}(angular),function(){"use strict";angular.module("aprima-fnc").factory("HxDrugSearchModal",["$q","SigwriterDrugSearchV1ModalService",function($q,SigwriterDrugSearchV1ModalService){return{openModal:function(patientId,kdbParameters){var promise=SigwriterDrugSearchV1ModalService.openModal$("",patientId,kdbParameters,!0).toPromise().then(function(result){return result.isSuccess?result.resultValue:$q.reject(result)});return $q.when(promise)}}}])}(),function(angular){"use strict";angular.module("aprima-fnc").factory("HxMedicationDiscontinueCancelModal",["$uibModal",function($modal){return{openModal:function(rpmIds,patientId,visitId){var drugDiscontinueArgs={relPatientMedicationIds:rpmIds,patientId:patientId,visitId:visitId};return $modal.open({backdrop:"static",templateUrl:"/fnc/tabs/hx/medication/views/hxMedicationDiscontinueCancelModal.html",windowClass:"modal-full",controller:"HxMedicationDiscontinueCancelModalCtrl",controllerAs:"vm",resolve:{drugDiscontinueArgs:drugDiscontinueArgs}}).result}}}]),angular.module("aprima-fnc").controller("HxMedicationDiscontinueCancelModalCtrl",["$uibModalInstance","drugDiscontinueArgs","aprgettext","DeviceSettings","ErrorService","HxMedicationDiscontinueCancelWarningModal","HxMedicationRepository","MedDiscontinueCancelConstants","toaster",function($modalInstance,drugDiscontinueArgs,gettext,DeviceSettings,ErrorService,HxMedicationDiscontinueCancelWarningModal,HxMedicationRepository,MedDiscontinueCancelConstants,toaster){var vm=this;vm.defaultProviderIds={currentUserId:MedDiscontinueCancelConstants.Guid.Empty,renderingProviderId:MedDiscontinueCancelConstants.Guid.Empty,billingProviderId:MedDiscontinueCancelConstants.Guid.Empty},vm.loadingDiscontinueCancel=!0,vm.loadingDiscontinueCancelError=null,vm.medications=[],vm.patientId=drugDiscontinueArgs.patientId,vm.providers=[],vm.relPatientMedicationIds=drugDiscontinueArgs.relPatientMedicationIds,vm.selectedIds={providerId:MedDiscontinueCancelConstants.Guid.Empty,supervisorId:MedDiscontinueCancelConstants.Guid.Empty,serviceSiteId:MedDiscontinueCancelConstants.Guid.Empty},vm.submittingDiscontinueCancelError=null,vm.submittingDiscontinueCancelRequest=!1,vm.visitId=drugDiscontinueArgs.visitId,vm.onClickCancelButton=function(){$modalInstance.dismiss()},vm.onClickSubmitButton=function(){var discontinueCancelSuccess=!1;vm.submittingDiscontinueCancelRequest=!0,vm.submittingDiscontinueCancelError=null;var requests=[];if(_.forEach(vm.medications,function(med){if(med.CanCancelMedication&&med.SendCancelMessage||med.CanDiscontinueMedication){var request={RelPatientMedicationId:med.RelPatientMedicationId,DiscontinueMedication:med.CanDiscontinueMedication,DiscontinueReasonId:med.DiscontinueReasonId,DiscontinueReasonText:med.AdditionalDiscontinueReasonText,DrugReactions:med.DrugReactions,DrugReactionText:med.DrugReactionText,DiscontinueEndDate:med.StopDate,CancelMedication:med.SendCancelMessage,PharmacyId:null!=med.Pharmacy?med.Pharmacy.Id:MedDiscontinueCancelConstants.Guid.Empty};requests.push(request)}}),requests.length<=0)return vm.submittingDiscontinueCancelRequest=!1,void toaster.pop("warning","",gettext("Please make a selection."));if(vm.medicationDiscontinueCancelForm.$valid){var requestPackage={PatientId:vm.patientId,VisitId:vm.visitId,ProviderId:null!=vm.selectedIds.providerId?vm.selectedIds.providerId:MedDiscontinueCancelConstants.Guid.Empty,SupervisingProviderId:null!=vm.selectedIds.supervisorId?vm.selectedIds.supervisorId:MedDiscontinueCancelConstants.Guid.Empty,ServiceSiteId:null!=vm.selectedIds.serviceSiteId?vm.selectedIds.serviceSiteId:MedDiscontinueCancelConstants.Guid.Empty,Requests:requests};HxMedicationRepository.discontinueCancelMedications(vm.patientId,requestPackage).then(function(resultsDto){discontinueCancelSuccess=resultsDto.Success,resultsDto.Success||HxMedicationDiscontinueCancelWarningModal.openModal(resultsDto.Results,vm.patientId,"SUBMIT-REQUEST")}).catch(function(error){vm.submittingDiscontinueCancelError=ErrorService.convertToErrorMessages(error),toaster.error("Unable to discontinue/cancel selected medications. Error =  "+vm.submittingDiscontinueCancelError),console.log(vm.submittingDiscontinueCancelError)}).finally(function(){vm.submittingDiscontinueCancelRequest=!1,discontinueCancelSuccess&&$modalInstance.close(!0)})}else vm.submittingDiscontinueCancelRequest=!1,toaster.pop("warning","",gettext("Please address validation errors."))},vm.shouldSwapButtons=function(){return DeviceSettings.isPrm},vm.medications=[],vm.providers=[],HxMedicationRepository.getPrescriptionHistoryForDiscontinueCancel(vm.patientId,vm.visitId,vm.relPatientMedicationIds).then(function(discontinueCancelProviderDto){vm.medications=discontinueCancelProviderDto.Medications.map(function(med){return"string"==typeof med.StopDate&&(med.StopDate=new Date(moment(med.StopDate).toISOString())),med.MinStopDate=moment(med.StartDate).format("YYYY-MM-DD"),med.DiscontinueReasonId===MedDiscontinueCancelConstants.Guid.Empty&&med.CanDiscontinueMedication&&(med.DiscontinueReasonId=MedDiscontinueCancelConstants.DiscontinueReasonId.Discontinued),med.PharmacySelected=!1,med.SendCancelMessage=!1,med.DrugReactions=[],med.DrugReactionText="",med}),vm.providers=discontinueCancelProviderDto.Provders,vm.defaultProviderIds.currentUserId=discontinueCancelProviderDto.CurrentUserId,vm.defaultProviderIds.renderingProviderId=discontinueCancelProviderDto.RenderingProviderId,vm.defaultProviderIds.billingProviderId=discontinueCancelProviderDto.BillingProviderId}).catch(function(error){vm.loadingDiscontinueCancelError=ErrorService.convertToErrorMessages(error),console.log(vm.loadingDiscontinueCancelError),toaster.error("Unable to retrieve patient medication history. Error =  "+vm.loadingDiscontinueCancelError)}).finally(function(){vm.loadingDiscontinueCancel=!1})}])}(angular),function(angular){"use strict";angular.module("aprima-fnc").factory("HxMedicationDiscontinueCancelWarningModal",["$uibModal",function($modal){return{openModal:function(warnings,patientId,warningType){var drugDiscontinueCancelWarningArgs={warnings:warnings,patientId:patientId,warningType:warningType};return $modal.open({backdrop:"static",templateUrl:"/fnc/tabs/hx/medication/views/hxMedicationDiscontinueCancelWarningModal.html",windowClass:"modal-full",controller:"HxMedicationDiscontinueCancelWarningModalCtrl",controllerAs:"vm",resolve:{drugDiscontinueCancelWarningArgs:drugDiscontinueCancelWarningArgs}}).result}}}]),angular.module("aprima-fnc").controller("HxMedicationDiscontinueCancelWarningModalCtrl",["$uibModalInstance","drugDiscontinueCancelWarningArgs",function($modalInstance,drugDiscontinueCancelWarningArgs){var vm=this;vm.loadingView=!1,vm.loadingError=null,vm.warnings=drugDiscontinueCancelWarningArgs.warnings,vm.warningType=drugDiscontinueCancelWarningArgs.warningType,vm.onClickCloseButton=function(){$modalInstance.dismiss()},vm.filterIncludeOnlyErrors=function(warning){if(warning.CancelMedicationErrors&&0<warning.CancelMedicationErrors.length||warning.DiscontinueMedicationErrors&&0<warning.DiscontinueMedicationErrors.length)return!0},vm.loadingView=!0,vm.loadingView=!1}])}(angular),function(){"use strict";angular.module("aprima-fnc").factory("HxMedicationService",["$q","apConfirmService","SigwriterDrugSearchService","toaster",function($q,apConfirmService,SigwriterDrugSearchService,toaster){return{getMaxDrugReactionCharacters:function(){return 32e3},getMaxDiscontinueReasonCharacters:function(){return 32e3},handleDrugSearchResult:function(result,patientId,visitId,fillSigDetailsFn,skipFillSigDetailsFn){if(!result)return $q.reject("Invalid drug search result");fillSigDetailsFn=fillSigDetailsFn||angular.noop,skipFillSigDetailsFn=skipFillSigDetailsFn||angular.noop;var visitInfo={visitId:visitId};return SigwriterDrugSearchService.createNewRxFromDrugSearchResult("Hx",result.drugSearchResult,result.switchToGeneric,result.dosingSuggestion,result.useEnhancedDrugSearch,patientId,!1,!0,visitInfo).then(function(rx){var canPrescribe=result.drugSearchResult&&result.drugSearchResult.CanBePrescribed,detailsConfirmation=canPrescribe?apConfirmService.confirm("Do you want to specify the SIG details?","Yes","No"):$q.when(),sigCompletedPromise=detailsConfirmation.then(function(enterDetails){return enterDetails?fillSigDetailsFn(rx):skipFillSigDetailsFn(rx)});return sigCompletedPromise},function(error){return toaster.error("Unknown error initializing SIG Writer"),$q.reject(error)}).catch(function(error){return result.drugSearchResult&&(result.drugSearchResult.indicateSelected=!1),$q.reject(error)})}}}])}(),function(angular){"use strict";angular.module("aprima-fnc").factory("HxPatientFormularyModal",["$uibModal",function($modal){return{openModal:function(patientId){return $modal.open({backdrop:"static",templateUrl:"/fnc/tabs/hx/medication/views/hxPatientFormularyModal.html",windowClass:"modal-full",controller:"HxPatientFormularyModalCtrl",controllerAs:"vm",resolve:{patientId:function(){return patientId}}}).result}}}]),angular.module("aprima-fnc").controller("HxPatientFormularyModalCtrl",["$uibModalInstance","DeviceSettings","ErrorService","patientId","PatientRepository",function($modalInstance,DeviceSettings,ErrorService,patientId,PatientRepository){var vm=this;function onFailure(error){vm.formularyErrorMessages=ErrorService.convertToErrorMessages(error)}function onSuccess(result){vm.rxBenefits=result}vm.loadingPatientFormulary=!0,vm.rxBenefits=null,vm.formularyErrorMessages=null,vm.cancel=function(){$modalInstance.dismiss()},vm.ok=function(){$modalInstance.close()},vm.shouldSwapButtons=function(){return DeviceSettings.isPrm},PatientRepository.geteRxEligibilities(patientId).then(onSuccess).catch(onFailure).finally(function(){vm.loadingPatientFormulary=!1})}])}(window.angular),function(angular){"use strict";angular.module("aprima-fnc").factory("HxRefillSigwriterModal",["$uibModal",function($modal){return{openModal:function(hxMed,options,hostedFromDesktop){return openModalOnly(hxMed,options,hostedFromDesktop).result},openModalOnly:openModalOnly};function openModalOnly(hxMed,options,hostedFromDesktop){return $modal.open({templateUrl:"/fnc/tabs/hx/medication/views/hxSigwriterModal.html",windowClass:"modal-full modal-sigwriter-tablet",controller:"HxRefillSigwriterModalCtrl",controllerAs:"vm",resolve:{hostedFromDesktop:function(){return hostedFromDesktop},hxMed:function(){return hxMed},options:function(){return options}}})}}]),angular.module("aprima-fnc").controller("HxRefillSigwriterModalCtrl",["$uibModalInstance","hostedFromDesktop","hxMed","options","FncRxRepository","SaveRxModal","SigwriterRxService",function($modalInstance,hostedFromDesktop,hxMed,options,FncRxRepository,SaveRxModal,SigwriterRxService){this.options=options,this.cancel=function(){$modalInstance.dismiss()},this.completed=function(rx){var patientId=rx.patient.Id,visitId=rx.visit.VisitId,prescription=SigwriterRxService.mapToSigwriterResultsDto(rx);prescription.FromDesktop=hostedFromDesktop;var savePromise=FncRxRepository.refillMedication(patientId,visitId,hxMed.RelPatientMedicationUid,prescription);SaveRxModal.openModal(savePromise).then(function(visitMedication){$modalInstance.close({prescription:prescription,visitMedication:visitMedication})})}}])}(angular),function(){"use strict";angular.module("aprima-fnc").factory("HxSigwriterModal",["$uibModal",function($modal){return{openModal:function(options){return openModalOnly(options).result},openModalOnly:openModalOnly};function openModalOnly(options){return $modal.open({templateUrl:"/fnc/tabs/hx/medication/views/hxSigwriterModal.html",windowClass:"modal-full modal-sigwriter-tablet",controller:"HxSigwriterModalCtrl",controllerAs:"vm",resolve:{options:function(){return options}}})}}]),angular.module("aprima-fnc").controller("HxSigwriterModalCtrl",["$uibModalInstance","Guid","options","HxMedicationRepository","SaveRxModal","SigwriterRxService",function($modalInstance,Guid,options,HxMedicationRepository,SaveRxModal,SigwriterRxService){this.options=options,this.cancel=function(){$modalInstance.dismiss()},this.completed=function(rx){var patientId=rx.patient.Id,visitId=rx.visit?rx.visit.VisitId:Guid.empty(),prescription=SigwriterRxService.mapToSigwriterResultsDto(rx);prescription.FromDesktop=options.hostedFromDesktop;var savePromise=HxMedicationRepository.addPrescription(patientId,visitId,!1,prescription);SaveRxModal.openModal(savePromise).then(function(patientMedication){$modalInstance.close({patientMedication:patientMedication})})}}])}(),function(){"use strict";angular.module("aprima-fnc").constant("MedDiscontinueCancelConstants",{DiscontinueReasonId:{Discontinued:"be13824c-b025-46b2-931c-378c00585ef7",AllergicReaction:"106bff92-868b-4ad6-a1ea-d26b3e71ffd8"},Guid:{Empty:"00000000-0000-0000-0000-000000000000"}}),angular.module("aprima-fnc").factory("MedDiscontinueCancelService",["MedDiscontinueCancelConstants",function(MedDiscontinueCancelConstants){return{getServiceSiteDefaultForDiscontinueCancelView:function(serviceSites,medicationsToDiscontinueCancel){var defaultServiceSiteId=MedDiscontinueCancelConstants.Guid.Empty;if(null===serviceSites||serviceSites.length<=0)return defaultServiceSiteId;if(null===medicationsToDiscontinueCancel||medicationsToDiscontinueCancel.length<=0)return defaultServiceSiteId;var filterServiceSites=[];_.forEach(medicationsToDiscontinueCancel,function(med){if(0<(filterServiceSites=_.filter(serviceSites,{Id:med.ServiceSiteId})).length)return defaultServiceSiteId=filterServiceSites[0].Id,!1}),defaultServiceSiteId===MedDiscontinueCancelConstants.Guid.Empty&&(defaultServiceSiteId=serviceSites[0].Id);return defaultServiceSiteId},getProviderSupervisorDefaultForDiscontinueCancelView:function(providerSupervisors,medicationsToDiscontinueCancel){var defaultSupervisorId=MedDiscontinueCancelConstants.Guid.Empty;if(null===providerSupervisors||providerSupervisors.length<=0)return defaultSupervisorId;if(null===medicationsToDiscontinueCancel||medicationsToDiscontinueCancel.length<=0)return defaultSupervisorId;var filterProviderSupervisors=[];_.forEach(medicationsToDiscontinueCancel,function(med){if(0<(filterProviderSupervisors=_.filter(providerSupervisors,{SupervisorId:med.SupervisingProviderId})).length)return defaultSupervisorId=filterProviderSupervisors[0].SupervisorId,!1}),defaultSupervisorId===MedDiscontinueCancelConstants.Guid.Empty&&(defaultSupervisorId=providerSupervisors[0].SupervisorId);return defaultSupervisorId},selectDefaultProvider:function(defaultProviderIds,providers){var defaultProviderId=MedDiscontinueCancelConstants.Guid.Empty;if(null===defaultProviderIds)return defaultProviderId;if(null===providers||providers.length<=0)return defaultProviderId;var defaultId=[];if(defaultProviderIds.currentUserId&&defaultProviderIds.currentUserId!==MedDiscontinueCancelConstants.Guid.Empty&&0<(defaultId=_.filter(providers,{Id:defaultProviderIds.currentUserId})).length)return defaultId[0].Id;if(defaultProviderIds.renderingProviderId&&defaultProviderIds.renderingProviderId!==MedDiscontinueCancelConstants.Guid.Empty&&0<(defaultId=_.filter(providers,{Id:defaultProviderIds.renderingProviderId})).length)return defaultId[0].Id;return 1===providers.length?providers[0].Id:MedDiscontinueCancelConstants.Guid.Empty}}}])}(),function(angular){"use strict";angular.module("aprima-fnc").factory("MedStatusModal",["$uibModal",function($modal){return{openModal:function(medStatus,medType,getDefaultMessageFn){return $modal.open({backdrop:"static",templateUrl:"/fnc/tabs/hx/medication/views/medStatusModal.html",controller:"MedStatusModalCtrl",controllerAs:"vm",windowClass:"modal-center-v modal-v18",resolve:{medStatus:function(){return medStatus},medType:function(){return medType},getDefaultMessageFn:function(){return getDefaultMessageFn}}}).result}}}]),angular.module("aprima-fnc").controller("MedStatusModalCtrl",["$uibModalInstance","getDefaultMessageFn","medStatus","MedStatusService","medType",function($modalInstance,getDefaultMessageFn,medStatus,MedStatusService,medType){var getDefault=getDefaultMessageFn||angular.noop,status=medStatus&&medStatus.Status,statusMessage=medStatus&&medStatus.StatusMessage||getDefault(status);this.medStatus={Status:status,StatusMessage:statusMessage},this.medType=medType,this.done=function(){$modalInstance.close()}}])}(window.angular),function(angular){"use strict";window.angular.module("aprima-fnc").factory("MedStatusService",["_",function(_){var defaultMessageByPatientMedStatus={None:"No status available.",PrescribedQueued:"The ePrescription was queued to be sent to the pharmacy.",PrescribedSent:"The ePrescription was sent to the pharmacy.",PrescribedSuccess:"The ePrescription completed successfully.",PrescribedError:"An error occurred while ePrescribing the medication.",CancelledQueued:"The ePrescription Cancellation was queued to be sent.",CancelledSent:"The ePrescription Cancellation was sent.",CancelledSuccess:"The ePrescription Cancellation completed successfully.",CancelledError:"An error occurred while cancelling the ePrescription.",PrintedOrFaxed:"The prescription was printed or faxed successfully."},defaultMessageByVisitMedStatus=_.defaults({},defaultMessageByPatientMedStatus),iconClassesByPatientMedStatus={None:"",PrescribedQueued:"ap-med-status-prescribed-queued",PrescribedSent:"ap-med-status-prescribed-sent",PrescribedSuccess:"ap-med-status-prescribed-success",PrescribedError:"ap-med-status-prescribed-error",CancelledQueued:"ap-med-status-cancelled-queued",CancelledSent:"ap-med-status-cancelled-sent",CancelledSuccess:"ap-med-status-cancelled-success",CancelledError:"ap-med-status-cancelled-error",PrintedOrFaxed:"ap-med-status-printed"},iconClassesByVisitMedStatus=_.defaults({},iconClassesByPatientMedStatus),sizeClassesBySize={1:"ap-med-status-1x",2:"ap-med-status-2x"};return{getDefaultPatientMessage:function(status){return defaultMessageByPatientMedStatus[status]||defaultMessageByPatientMedStatus.None},getPatientIconClass:function(status){return iconClassesByPatientMedStatus[status]||iconClassesByPatientMedStatus.None},getDefaultVisitMessage:function(status){return defaultMessageByVisitMedStatus[status]||defaultMessageByVisitMedStatus.None},getVisitIconClass:function(status){return iconClassesByVisitMedStatus[status]||iconClassesByVisitMedStatus.None},getSizeClass:function(size){return sizeClassesBySize[size]||""}}}])}(),function(){"use strict";angular.module("aprima-fnc").component("fncPlan",{templateUrl:"/fnc/tabs/plan/component-views/fncPlan.html",bindings:{hostedFromDesktop:"<",isReadonly:"<",patientId:"<",visitId:"<",registerFncSaveCallback:"&",registerTabSelectedCallback:"&"},controller:["$q","$scope","$timeout","_","aprgettext","Bridge","debounce","IntersectionObserverService","LocalStorageRepository","PanelConfigurationService","PatientDashboardHelper","FncPlanRepository","toaster","uxConstants",function($q,$scope,$timeout,_,gettext,Bridge,debounce,IntersectionObserverService,LocalStorageRepository,PanelConfigurationService,PatientDashboardHelper,FncPlanRepository,toaster,uxConstants){var emptyGuid="00000000-0000-0000-0000-000000000000",vm=this;function blockSave(){var message=gettext("Unable to save Plan NOW because this note is Read Only.");return toaster.pop("error","",message),$q.reject(message)}function inactivatedDiagnosis(visitDiagnosisId){var index=_.findIndex(vm.activeHxs,{VisitDiagnosisUid:visitDiagnosisId});if(-1<index){var planItem=vm.activeHxs.splice(index,1)[0];vm.inactivePlans.push(planItem),planItem.IsExcluded=!0}}function inactiveHxObserverCallback(entries){var intersectionRect=entries[0].intersectionRect;vm.isBasicInactiveHx=!(intersectionRect.height||intersectionRect.width),$scope.$apply()}function initPatientTiles(configId){var allConfigs=LocalStorageRepository.getPatientDashboardConfigurations("all"),pageConfig=_(allConfigs).find({Id:configId})||_(allConfigs).find({Id:"23a63f6d-1fd1-4bf0-888e-000000000003"})||_(allConfigs).sortBy("DisplayOrder").head(),layoutWithConfig=PanelConfigurationService.getLayoutWithConfig(pageConfig.Id,"DesktopTiles",void 0,"all"),tileLayout=PatientDashboardHelper.getLayout(layoutWithConfig,3);vm.allWidgets=_.flatMap(tileLayout,function(a){return _.flatMap(a.columns,function(b){return _.flatMap(b.widgets)})})}function onFncSave(saveRequest){var deferred=$q.defer(),result={Id:saveRequest.Id};return saveAll(saveRequest.BypassRequiredCheck).then(function(){result.Success=!0}).catch(function(error){result.Success=!1,-1===error.status?result.Reason="Unable to connect to server.":result.Reason=error.statusText+" ("+error.status+")",result.Error=JSON.stringify(error)}).finally(function(){deferred.resolve(result)}),deferred.promise}function onTabSelected(){return refreshRecalls(),vm.loadingPlans=!0,FncPlanRepository.getPlans(vm.patientId,vm.visitId).then(function(data){vm.plansHttpError=null,function(data){if(vm.activeHxs=[],vm.inactivePlans=[],vm.plans=[],data.forEach(function(dataItem){var p;dataItem.IsFromHistory?vm.activeHxs.push(dataItem):(vm.plans.push(dataItem),(p=dataItem).Configuration||(p.Configurations&&p.Configurations.length?p.Configuration=p.Configurations[0]:p.Configuration={Defaults:[],Options:[]}),p.Configuration.Options||(p.Configuration.Options=[]),p.Configuration.Options.length||p.Configuration.Options.push({DisplayOrder:0,Name:"No plan associated",NodeName:"No plan associated",Id:emptyGuid,IsLeafNode:!0}),p.Configuration.PreviousPlans||(p.Configuration.PreviousPlans=[]),p.Configuration.Defaults.sort(function(a,b){return a.Name.localeCompare(b.Name)}),sortOptions(p.Configuration),p.Configuration.Defaults.forEach(function(d){sortOptions(d)}),p.Configuration.PreviousPlans.forEach(function(pp){sortOptions(pp.Configuration)}),vm.sessionIdentifier||(vm.sessionIdentifier=p.SessionIdentifier))}),vm.plans.some(function(i){return i.DisplayOrderFromDB})){var maxOrder=vm.plans.length;vm.plans.forEach(function(p){p.DisplayOrderFromDB||(p.DisplayOrder-=maxOrder,p.DisplayOrderFromDB=p.DisplayOrder)}),vm.plans.sort(function(a,b){return a.DisplayOrderFromDB-b.DisplayOrderFromDB});for(var i=0;i<vm.plans.length;i++)vm.plans[i].DisplayOrderFromDB=vm.plans[i].DisplayOrder=i+1;vm.isReadonly||saveAll(!0,!0)}function sortOptions(planItem){!planItem.IsLeafNode&&planItem.Options&&(planItem.Options.sort(function(a,b){return a.DisplayOrder-b.DisplayOrder}),planItem.Options.forEach(function(child){sortOptions(child)}))}}(data)}).catch(function(response){vm.plansHttpError=response}).finally(function(){vm.loadingPlans=!1})}function refreshRecalls(){$scope.$broadcast("refresh-widget-recalls")}function save(planItem,skipValidation,skipRefreshRecalls){return planItem.VisitDiagnosisUid?vm.saveFunc(planItem,skipValidation,skipRefreshRecalls):vm.setNextUpdate(function(){return vm.saveFunc(planItem,skipValidation,skipRefreshRecalls)})}function saveAll(skipValidation,skipRefreshRecalls){if(vm.isReadonly)return blockSave();var promises=[];return vm.plans.forEach(function(planItem){promises.push(save(planItem,skipValidation,!0))}),$q.all(promises).then(function(){skipRefreshRecalls||refreshRecalls()})}function storePlan(source,target){if(target.IsSelected=!!source.totalSelected,target.Name=source.Name,target.Notes=source.Notes,target.SelectionDisplayValue=source.SelectionDisplayValue,target.SelectionValue=source.parsedSelectionValue?JSON.stringify(source.parsedSelectionValue):null,!source.IsLeafNode)for(var i=0;i<source.Options.length;i++)storePlan(source.Options[i],target.Options[i])}vm.activeHxs=[],vm.inactivePlans=[],vm.isBasicInactiveHx=!0,vm.loadingPlans=!1,vm.plans=[],vm.plansHttpError=null,vm.sessionIdentifier=null,vm.showPatientWidgets=!0,vm.widgets=[],vm.allWidgets=[],vm.$onInit=function(){vm.registerFncSaveCallback({callbackFn:onFncSave}),vm.registerTabSelectedCallback({callbackFn:onTabSelected})},vm.dragStart=function(planItem){vm.draggingItem=planItem},vm.inactivatePlan=function(planItem){vm.hostedFromDesktop?Bridge.fireEvent("inactivate-diagnosis",{PatientId:vm.patientId,VisitDate:planItem.VisitDate,VisitId:planItem.VisitUid,VisitDiagnosisId:planItem.VisitDiagnosisUid}):FncPlanRepository.inactivatePlan(planItem,vm.patientId)},vm.incrementalSave=debounce(uxConstants.incrementalSaveTime,function(planItem){save(planItem,!0)}),vm.reorderPlan=function(movingPlan,targetPlan){var startIndex,endIndex,increment,movingDisplayOrder=movingPlan.DisplayOrder,targetDisplayOrder=targetPlan.DisplayOrder;increment=targetDisplayOrder<movingDisplayOrder?(startIndex=movingDisplayOrder-1,endIndex=targetDisplayOrder,1):(startIndex=movingDisplayOrder+1,endIndex=targetDisplayOrder,-1);for(var i=startIndex;0<increment?endIndex<=i:i<=endIndex;i-=increment){var index=_.findIndex(vm.plans,{DisplayOrder:i});if(-1<index){var currentPlan=vm.plans[index];currentPlan.DisplayOrder+=increment,currentPlan.DisplayOrderFromDB=currentPlan.DisplayOrder}}movingPlan.DisplayOrderFromDB=movingPlan.DisplayOrder=targetDisplayOrder,vm.plans.forEach(function(planItem){planItem.DisplayOrderFromDB||(planItem.DisplayOrderFromDB=planItem.DisplayOrder)}),saveAll(!0)},vm.save=save,vm.selectPlanItem=function(planItem){$timeout(function(){vm.widgets=[]},0),vm.selectedPlanItem!==planItem&&(initPatientTiles((vm.selectedPlanItem=planItem)&&planItem.Configuration&&planItem.Configuration.PatientDashboardConfigurationId),$timeout(function(){Array.prototype.push.apply(vm.widgets,vm.allWidgets)},1))},vm.saveFunc=function(planItem,skipValidation,skipRefreshRecalls){{if(vm.isReadonly)return blockSave();if(!skipValidation&&!planItem.IsExcluded&&0<planItem.customPlanConfiguration.totalRequired-planItem.customPlanConfiguration.totalRequiredSelected){var message=gettext("Please select all required items.");return toaster.pop("error","",message),$q.reject(message)}}vm.incrementalSave.cancel();var promise,customPlanConfiguration=planItem.customPlanConfiguration;customPlanConfiguration&&(storePlan(customPlanConfiguration,planItem.Configuration),planItem.customPlanConfiguration=null);return planItem.SessionIdentifier=vm.sessionIdentifier,promise=FncPlanRepository.updatePlan(planItem).then(function(updatedPlan){return planItem.Description=updatedPlan.Description,planItem.Id=updatedPlan.Id,planItem.RecallUid=updatedPlan.RecallUid,planItem.updatedRecallInfo&&(planItem.updatedRecallInfo=!1,skipRefreshRecalls||refreshRecalls()),updatedPlan}),planItem.customPlanConfiguration=customPlanConfiguration,promise},vm.currentUpdatePromise=null,vm.updateNosPlanPromiseFunc=null,vm.setNextUpdate=function(func){return vm.updateNosPlanPromiseFunc=func,vm.processUpdateNos()},vm.processUpdateNos=function(){if(vm.currentUpdatePromise||!vm.updateNosPlanPromiseFunc)return vm.currentUpdatePromise;var updateFunc=vm.updateNosPlanPromiseFunc;vm.updateNosPlanPromiseFunc=null;var updatePromise=updateFunc().then(function(result){return vm.updateNosPlanIsProcessing=!1,vm.currentUpdatePromise=null,vm.updateNosPlanPromiseFunc?vm.processUpdateNos():result}).catch(function(){vm.updateNosPlanIsProcessing=!1,vm.currentUpdatePromise=null,vm.updateNosPlanPromiseFunc&&vm.processUpdateNos()});return vm.currentUpdatePromise=updatePromise},function(){var disconnectObserver=IntersectionObserverService.observeWithSelector("#visibilityTracker",inactiveHxObserverCallback);disconnectObserver&&$scope.$on("$destroy",disconnectObserver);Bridge.on("inactivated-diagnosis",$scope,inactivatedDiagnosis),initPatientTiles()}()}]})}(),function(){"use strict";angular.module("aprima-fnc").component("fncPlanLegacyNotesWidget",{templateUrl:"/fnc/tabs/plan/component-views/fncPlanLegacyNotesWidget.html",bindings:{hostedFromDesktop:"<",item:"=",source:"<",select:"&"},controller:["Bridge","SystemGuid",function(Bridge,SystemGuid){var fauxScope,vm=this,onDestroyListeners=[];function dstPlanTextLoaded(result){vm.item.parsedSelectionValue.preview=result.Preview,vm.item.SelectionDisplayValue=result.Preview}function editedLegacyNotes(result){vm.item.parsedSelectionValue.preview=result.Preview,vm.item.SelectionDisplayValue=result.Preview,vm.select({item:vm.item,shouldBeSelected:!!result.Preview})}vm.$onDestroy=function(){onDestroyListeners.forEach(function(onDestroyListener){onDestroyListener(arguments)})},vm.$onInit=function(){vm.item.parsedSelectionValue||(vm.item.parsedSelectionValue={});fauxScope={$on:function(eventName,callback){"$destroy"===eventName&&onDestroyListeners.push(callback)}},vm.item.NodeType===vm.SystemGuid.DpnNodePlanPatientInstructions&&(Bridge.fireEvent("select-patient-instructions",{NodeType:vm.source}),Bridge.on("loaded-dst-plan-text",fauxScope,dstPlanTextLoaded));Bridge.on("edited-legacy-notes",fauxScope,editedLegacyNotes)},vm.edit=function(){Bridge.fireEvent("edit-legacy-notes",{NodeType:vm.source})},vm.SystemGuid=SystemGuid}]})}(),function(){"use strict";angular.module("aprima-fnc").component("fncPlanOptionsSelection",{templateUrl:"/fnc/tabs/plan/component-views/fncPlanOptionsSelection.html",bindings:{configuration:"<",customPlanConfiguration:"=",diagnosisId:"<",hostedFromDesktop:"<",isBlank:"<",isReadonly:"<",onUpdatedRecallInfo:"&",registerSelectDefaultCallback:"&",save:"&"},controller:["$element","$timeout","Bridge","SystemGuid",function($element,$timeout,Bridge,SystemGuid){var fauxScope,vm=this,onDestroyListeners=[];function clearCustomPlanItemSelection(item){item.IsLeafNode?item.totalSelected&&toggleCustomPlanItemSelection(item):item.Options.forEach(function(child){clearCustomPlanItemSelection(child)})}function clickCustomPlanSubitem(subItem,event){(subItem.parent.selectedItem=subItem).NodeType||toggleCustomPlanItemSelection(subItem,event),incrementalSave()}function editedSelectionNotes(args){if(args.DiagnosisId===vm.diagnosisId){var node=function findNode(nodeId,parent){{if(parent.Id===nodeId)return parent;if(!parent.IsLeafNode){for(var node=null,i=0;i<parent.Options.length;i++){var child=parent.Options[i],result=findNode(nodeId,child);if(result){node=result;break}}return node}}return null}(args.NodeId,vm.customPlanConfiguration);node&&(node.Notes=args.Notes,incrementalSave())}}function getMaxLevels(){var selectedItem;return selectedItem=vm.customPlanConfiguration?vm.customPlanConfiguration.selectedItem:null,getMaxLevel(selectedItem)||2;function getMaxLevel(item){var maxLevel=0;return item&&(maxLevel=1,item.IsLeafNode?item.NodeType&&maxLevel++:item.Options.forEach(function(subItem){maxLevel=Math.max(maxLevel,getMaxLevel(subItem)+1)})),maxLevel}}function incrementalSave(){vm.save()}function initializeCustomPlanConfiguration(configuration,isNewPlan){vm.customPlanConfiguration=loadPlan(configuration,isNewPlan)}function loadPlan(source,isNewPlan){var target={IsMultiSelect:!0,maxLevels:0,Name:source.Name,Options:_.cloneDeep(source.Options),selectedItem:null,totalRequired:0,totalRequiredSelected:0,totalSelected:0};return target.Options.forEach(function(option){!function prepareNode(node,parent){node.parent=parent;node.totalRequired=0;node.totalRequiredSelected=0;node.totalSelected=0;if(node.IsRequired)for(var currentItem=node;currentItem;)currentItem.totalRequired+=1,currentItem=currentItem.parent;isNewPlan?(node.parsedSelectionValue=null,node.SelectionValue=null):node.SelectionValue&&(node.parsedSelectionValue=JSON.parse(node.SelectionValue));node.IsLeafNode?(isNewPlan?node.IsPreSelected:node.IsSelected)&&toggleCustomPlanItemSelection(node):node.Options.forEach(function(child){prepareNode(child,node)})}(option,target)}),target}function onSelectDefault(selectedDefault){selectedDefault?vm.customPlanConfiguration=loadPlan(selectedDefault,!1):initializeCustomPlanConfiguration(vm.configuration,!0),updatedRecallInfo(),incrementalSave()}function toggleCustomPlanItemSelection(item,event){if(item.IsLeafNode){for(var currentItem=item;currentItem.totalSelected||currentItem.parent.IsMultiSelect||clearCustomPlanItemSelection(currentItem.parent),(currentItem=currentItem.parent).parent;);for(var isSelected=!(currentItem=item).totalSelected,numRequired=0;currentItem;){var wasSelected=!!currentItem.totalSelected;currentItem.totalSelected+=isSelected?1:-1,currentItem.IsRequired&&(wasSelected&&!currentItem.totalSelected?numRequired-=1:!wasSelected&&currentItem.totalSelected&&(numRequired+=1)),currentItem.totalRequiredSelected+=numRequired,currentItem=currentItem.parent}if(item.totalSelected){if(event&&event.currentTarget&&event.currentTarget.id){var chosenItemId=event.currentTarget.id.replace("option","chosen");$timeout(function(){$element.find("#"+chosenItemId+" textarea").first().focus()})}}else item.Name=item.NodeName}}function updatedRecallInfo(){vm.onUpdatedRecallInfo()}vm.SystemGuid=SystemGuid,vm.clickCustomPlanItem=function(item,event){clickCustomPlanSubitem(item,event),vm.customPlanConfiguration.maxLevels=getMaxLevels()},vm.clickCustomPlanSubitem=clickCustomPlanSubitem,vm.getBootstrapColumnNumber=function($index){switch(vm.customPlanConfiguration.maxLevels){case 0:case 1:return 12;case 2:case 3:case 4:case 5:return 12/(vm.customPlanConfiguration.maxLevels-1);case 6:return $index<4?2:4;case 7:return 2;default:return 1}},vm.getNodeClasses=function(node){var classes=[];node.parent.selectedItem&&node.parent.selectedItem.Id===node.Id&&classes.push("plan-option-active");node.totalSelected?classes.push("plan-option-selected"):node.IsRequired&&classes.push("plan-option-required");return classes.join(" ")},vm.getSuboptions=function(){var suboptions=[],relevantItem=vm.customPlanConfiguration;if(relevantItem&&relevantItem.maxLevels)for(var i=0;i<vm.customPlanConfiguration.maxLevels-1;i++)relevantItem=relevantItem?relevantItem.selectedItem:relevantItem,suboptions.push(relevantItem);return suboptions},vm.incrementalSave=incrementalSave,vm.onSelectDefault=onSelectDefault,vm.openFullSelectionNotesEditor=function(item){Bridge.fireEvent("edit-selection-notes",{DiagnosisId:vm.diagnosisId,NodeId:item.Id,Notes:item.Notes})},vm.removeCustomPlanItemSelection=function(item){item.parsedSelectionValue&&(item.parsedSelectionValue.preview=null);item.SelectionValue=null,item.NodeType&&Bridge.fireEvent("remove-selection-notes",{NodeType:item.NodeType});toggleCustomPlanItemSelection(item),item.NodeType===SystemGuid.DpnNodePlanRecall&&updatedRecallInfo();incrementalSave()},vm.selectCustomNode=function(item,shouldBeSelected){!!item.totalSelected!=!!shouldBeSelected&&toggleCustomPlanItemSelection(item);incrementalSave()},vm.shouldAllowNotes=function(item){return!item.NodeType},vm.toggleCustomPlanItemSelection=toggleCustomPlanItemSelection,vm.updatedRecallInfo=updatedRecallInfo,vm.$onDestroy=function(){onDestroyListeners.forEach(function(onDestroyListener){onDestroyListener(arguments)})},vm.$onInit=function(){vm.registerSelectDefaultCallback({callbackFn:onSelectDefault})},function(){vm.customPlanConfiguration||initializeCustomPlanConfiguration(vm.configuration,vm.isBlank);fauxScope={$on:function(eventName,callback){"$destroy"===eventName&&onDestroyListeners.push(callback)}},Bridge.on("edited-selection-notes",fauxScope,editedSelectionNotes)}()}]}),angular.module("aprima-fnc").directive("fncPlanOptionsSelectionAutoSave",[function(){return{restrict:"A",require:["^fncPlanOptionsSelection","ngModel"],link:function(scope,element,attrs,ctrls){var vm=ctrls[0],ngModel=ctrls[1];vm&&ngModel&&ngModel.$viewChangeListeners.push(function(){vm.incrementalSave()})}}}])}(),function(){"use strict";angular.module("aprima-fnc").component("fncPlanRecallWidget",{bindings:{item:"=",onUpdatedRecallInfo:"&",select:"&"},templateUrl:"/fnc/tabs/plan/component-views/fncPlanRecallWidget.html",controller:["gettext","moment","toaster",function(gettext,moment,toaster){var vm=this;function formatDate(date){return moment(date).format("YYYY-MM-DD")}function isValidDate(){return vm.date&&!vm.minDateMoment.isAfter(vm.date)}function isValidNumber(){return angular.isNumber(vm.number)&&vm.number>=vm.minNumber&&vm.number<=vm.maxNumber}function sync(){var shouldBeSelected="specific"===vm.dateType&&isValidDate()||"relative"===vm.dateType&&isValidNumber()&&vm.timePeriod||"asneeded"===vm.dateType;if(vm.item.parsedSelectionValue.date=isValidDate()?formatDate(vm.date):null,vm.item.parsedSelectionValue.dateType=vm.dateType,vm.item.parsedSelectionValue.number=isValidNumber()?vm.number:null,vm.item.parsedSelectionValue.timePeriod=vm.timePeriod,shouldBeSelected)switch(vm.dateType){case"asneeded":vm.item.SelectionDisplayValue="As needed";break;case"specific":vm.item.SelectionDisplayValue=moment(vm.date).format("L");break;case"relative":vm.item.SelectionDisplayValue=vm.number+" "+gettext(vm.timePeriod);break;default:vm.item.SelectionDisplayValue=null}else vm.item.SelectionDisplayValue=null;vm.onUpdatedRecallInfo(),vm.select({item:vm.item,shouldBeSelected:!!shouldBeSelected})}vm.date=null,vm.dateType="asneeded",vm.maxNumber=90,vm.minDate=null,vm.minNumber=1,vm.number=null,vm.timePeriod=null,vm.blurDate=function(){if(!vm.date)return;if(!isValidDate()){var message=gettext("The return visit date must be after today");toaster.pop("warning","",message),vm.date=vm.minDateMoment.toDate(),sync()}},vm.blurNumber=function(){if(!angular.isNumber(vm.number))return;if(!isValidNumber()){var message=gettext("The return visit date must be between 1 and 90");toaster.pop("warning","",message),vm.number=vm.number<vm.minNumber?vm.minNumber:vm.maxNumber,sync()}},vm.dateChanged=function(){vm.dateType="specific",sync()},vm.dateTypeChanged=function(){sync()},vm.formatDate=formatDate,vm.timespanChanged=function(){var validDate=isValidNumber()&&vm.timePeriod;vm.dateType="relative",validDate&&(vm.date=moment().add(vm.number,vm.timePeriod).toDate());sync()},function(){vm.item.parsedSelectionValue?(vm.date=vm.item.parsedSelectionValue.date?moment(vm.item.parsedSelectionValue.date).toDate():vm.item.parsedSelectionValue.date,vm.dateType=vm.item.parsedSelectionValue.dateType,vm.number=vm.item.parsedSelectionValue.number,vm.timePeriod=vm.item.parsedSelectionValue.timePeriod):vm.item.parsedSelectionValue={};vm.minDateMoment=moment().add(1,"days").startOf("day"),sync()}()}]})}(),function(){"use strict";angular.module("aprima-fnc").component("fncPlanTile",{templateUrl:"/fnc/tabs/plan/component-views/fncPlanTile.html",bindings:{configurable:"<",hostedFromDesktop:"<",isDraggable:"<",isReadonly:"<",isSelected:"<",patientId:"<",planItem:"<",visitId:"<",incrementalSave:"&",onDragStart:"&",save:"&",select:"&",unselect:"&"},controller:["$q","$timeout","$uibModal","Bridge","moment","FncPlanRepository",function($q,$timeout,$uibModal,Bridge,moment,FncPlanRepository){var selectDefaultCallbackFn,vm=this;function _clickPlan(){vm.planItem.IsExcluded||vm.select()}function _isConfigurable(){return vm.configurable}function _save(skipValidation){return _isConfigurable()?vm.save({skipValidation:skipValidation}):$q.resolve(null)}function _selectDefault(selectedDefault){selectDefaultCallbackFn&&selectDefaultCallbackFn(selectedDefault)}vm._clickPlan=_clickPlan,vm._dragStart=function(){vm.onDragStart({planItem:vm.planItem})},vm._excludePlan=function(){vm.isSelected&&vm.planItem.IsExcluded&&vm.unselect();$timeout(function(){Bridge.fireEvent("exclude-plan-change",{Exclude:vm.planItem.IsExcluded})}),_save(!0)},vm._expand=function(){vm.planItem.isExpanded=!vm.planItem.isExpanded},vm._formatDescription=function(description){return(description||"").replace(/<tab\/>/g,"&nbsp;").replace(/<newline\/>/g,"<br/>")},vm._formatPreviousPlanDate=function(date){return moment(date).format("L")},vm._incrementalSave=function(){_isConfigurable()&&vm.incrementalSave()},vm._isConfigurable=_isConfigurable,vm._isDisabled=function(){return!vm.planItem||vm.planItem.IsExcluded},vm._isDraggable=function(){return vm.isDraggable},vm._isNewPlan=function(){return 0===getNumSelected(vm.planItem.Configuration);function getNumSelected(node){var totalSelected=0;return node.IsLeafNode?node.IsSelected&&(totalSelected+=1):node.Options.forEach(function(child){totalSelected+=getNumSelected(child)}),totalSelected}},vm._isSelected=function(){return vm.isSelected},vm._onOk=function(){vm.isReadonly?vm.unselect():_save(!1).then(function(){vm.unselect(),vm.planItem.isExpanded=!1})},vm._onNew=function($event){if(!vm.isSelected)return;$event.stopPropagation(),_save(!0).then(function(){$uibModal.open({controller:"SavePlanDefaultCtrl",controllerAs:"savePlanDefault",templateUrl:"/fnc/tabs/plan/views/savePlanDefault.html",resolve:{planName:function(){return vm.planItem.Configuration.Name}}}).result.then(function(result){var configuration=_.cloneDeep(vm.planItem.Configuration),configurationId=configuration.Id;configuration.Id="00000000-0000-0000-0000-000000000000",configuration.Name=result.name,FncPlanRepository.saveDefaults(vm.patientId,vm.visitId,configurationId,configuration).then(function(newDefault){configuration.Id=newDefault.Id;for(var added=!1,i=0;i<vm.planItem.Configuration.Defaults.length;i++)if(configuration.Name.localeCompare(vm.planItem.Configuration.Defaults[i].Name)<1){vm.planItem.Configuration.Defaults.splice(i,0,configuration),added=!0;break}added||vm.planItem.Configuration.Defaults.push(configuration),vm.planItem.selectedDefault=configuration})})})},vm._onPreviousPlan=function(){vm.isSelected||_clickPlan();$timeout(function(){vm.isSelectingPreviousPlan=!vm.isSelectingPreviousPlan})},vm._onSelectDefault=function(){vm.isSelected||_clickPlan();$timeout(function(){Bridge.fireEvent("select-plan-defaults",{ListPlanDefaultsUid:vm.planItem.selectedDefault?vm.planItem.selectedDefault.Id:"00000000-0000-0000-0000-000000000000"}),_selectDefault(vm.planItem.selectedDefault)})},vm._onSelectPreviousPlan=function(previousPlan){vm.planItem.selectedDefault=null,vm.isSelectingPreviousPlan=!1,$timeout(function(){Bridge.fireEvent("select-previous-plan",{VisitUid:previousPlan.VisitUid}),_selectDefault(previousPlan.Configuration)})},vm._registerSelectDefaultCallback=function(callbackFn){selectDefaultCallbackFn=callbackFn},vm._save=_save,vm._updatedRecallInfo=function(){vm.planItem.updatedRecallInfo=!0}}]})}(),function(){"use strict";angular.module("aprima-fnc").controller("SavePlanDefaultCtrl",["$uibModalInstance","aprgettext","planName",function($uibModalInstance,gettext,planName){var savePlanDefault=this;savePlanDefault.name=null,savePlanDefault.getTitle=function(){return gettext("New Default for ")+planName},savePlanDefault.save=function(){$uibModalInstance.close(savePlanDefault)}}])}(),function(){"use strict";angular.module("aprima-fnc").component("fncRx",{templateUrl:"/fnc/tabs/rx/component-views/fncRx.html",bindings:{hostedFromDesktop:"<",isCompleted:"<",patientId:"<",visitId:"<",getStateFromDesktopContext:"&",registerRefillFromHxOnlyCallback:"&",registerTabSelectedCallback:"&",updateDesktopContext:"&",kdbParameters:"<?"},controller:["$timeout","$q","$injector","$interval","$sce","$scope","apConfirm","Bridge","ErrorService","FncRxDrugSearchModal","FncRxPharmacySearchModal","FncRxRepository","FncRxService","HxPatientFormularyModal","PrmState","ServerInfoRepository","SettingService","SigwriterDrugSearchService","toaster","VisitCommentRepository","DxProblemsModal",function($timeout,$q,$injector,$interval,$sce,$scope,apConfirm,Bridge,ErrorService,FncRxDrugSearchModal,FncRxPharmacySearchModal,FncRxRepository,FncRxService,HxPatientFormularyModal,PrmState,ServerInfoRepository,SettingService,SigwriterDrugSearchService,toaster,VisitCommentRepository,DxProblemsModal){var vm=this,initallySelected=!1,pendingRefresh=!1,refillFromHxOnlyCallbackFn=null,tabSelectedCallbackFns={},medStatusIntervalMs=6e4,medStatusIntervalPromise=null,kdbConfigSupported=ServerInfoRepository.isFeatureSupported(["Settings_KdbConfiguration"]),deferredSearchDrugs=null,deferredSaveVisit=null,searchDrugsFn=null;function fillInKdbConfig(){!vm.kdbParameters&&vm.visitId&&kdbConfigSupported&&(vm.kdbParameters={kdbConfigurationId:SettingService.getKdbConfigurationIdByVisit(null,vm.visitId)})}function formatterModal(value){if(!value)return null;var code=value.Icd10Code||value.Icd9Code,name=value.Name,description=name;return name&&code&&(description=code+" - "+name),!name&&code&&(description=code),description}function getOrderModal(item){if(!item)return"2";return vm.orderByDisplayOrder?SigwriterDxProblemsService.getSortOrderForSelectedDxProblemItem(item):""+(item.IsProblem?1:0)+(item.Name&&item.Name.toLowerCase())}function getEditableMedications(){var editableMedications=_.filter(vm.medications,"CanEdit");return editableMedications}function getVisitComment(){vm.loadingComment=!0,VisitCommentRepository.getVisitComment(vm.visitId,vm.visitCommentType).then(function(result){vm.tinymceModel=$sce.trustAsHtml(result.VisitComment)}).catch(function(error){vm.loadCommentError=ErrorService.convertToErrorMessages(error)}).finally(function(){vm.loadingComment=!1})}function loadVisitMedications(){vm.loadingVisitRx=!0,FncRxRepository.getVisitPrescriptions(vm.patientId,vm.visitId).then(function(visitMedications){var meds,updateFn;vm.loadVisitRxError=null,vm.medications=visitMedications,vm.medications=(meds=vm.medications,_.forEach(meds,function(med){0===med.MedicationDays&&(med.MedicationDays=null)}),meds),vm.medications=function(meds){return _.forEach(meds,function(med){med.selectedICDCodes="",med.Problems&&_.forEach(_.orderBy(med.Problems,["DisplayOrder","Name"],["asc"]),function(problem){var value,code=(value=problem)?value.Icd10Code||value.Icd9Code:null;med.selectedICDCodes?med.selectedICDCodes=" "+med.selectedICDCodes+", "+code:med.selectedICDCodes=code})}),meds}(vm.medications),updateFn=function(){return function(meds){if(!meds||_.isEmpty(meds))return $q.reject();var ids=_.map(meds,"RelVisitMedicationId");return FncRxRepository.getVisitMedStatuses(ids).then(function(statusObj){return _.forEach(meds,function(med){med.status=statusObj[med.RelVisitMedicationId]}),statusObj}).catch(function(error){var errorMessages=ErrorService.convertToErrorMessages(error);console.error(errorMessages)})}(vm.medications)},cancelStatusAutoUpdate(),updateFn().finally(function(){medStatusIntervalPromise=$interval(updateFn,medStatusIntervalMs)})}).catch(function(error){vm.loadVisitRxError=ErrorService.convertToErrorMessages(error)}).finally(function(){vm.loadingVisitRx=!1})}function onEditedRxComment(data){data&&(vm.rxComment=data.Notes,vm.hideContainer&&toggleHide())}function onLatestRxComment(data){data&&(vm.rxComment=data.Notes,vm.hideContainer=!1)}function handleUnsavedAllergyCheck(data){data?apConfirm("Drug allergy changes must be saved before creating a new prescription. Save changes and continue?","Yes","No").then(function(result){result?(deferredSaveVisit=$q.defer(),Bridge.fireEvent("sigwriter-save-visit",{}),deferredSaveVisit.promise).then(function(){deferredSearchDrugs.resolve()},function(){deferredSearchDrugs.resolve()}):deferredSearchDrugs.reject()},function(){deferredSearchDrugs.reject()}):deferredSearchDrugs.resolve()}function desktopSearchDrugs(){(deferredSearchDrugs=$q.defer(),Bridge.fireEvent("sigwriter-check-unsaved-allergy",{}),deferredSearchDrugs.promise).then(function(){searchDrugs()})}function searchDrugs(){var patientId=vm.patientId;FncRxDrugSearchModal.openModal(patientId,void 0,vm.kdbParameters).then(function(result){var visitInfo={visitId:vm.visitId};SigwriterDrugSearchService.createNewRxFromDrugSearchResult("NewRx",result.drugSearchResult,result.switchToGeneric,result.dosingSuggestion,result.useEnhancedDrugSearch,patientId,!1,!0,visitInfo).then(function(rx){var sigwriterPromise=FncRxService.openSigwriterToAddPrescription(rx,!!vm.hostedFromDesktop);openSigwriter(sigwriterPromise)}).catch(function(response){response&&response.cancelled||toaster.error("Unknown error initializing SIG Writer")})})}function openSigwriter(sigwriterPromise){Bridge.fireEvent("sigwriter-open",{}),sigwriterPromise.then(function(result){vm.updateDesktopContext({prescription:result.prescription,relVisitMedicationId:result.visitMedication.RelVisitMedicationId,sigType:result.sigType}),refresh()}).finally(function(){Bridge.fireEvent("sigwriter-close",{})})}function compile(element){var el=angular.element(element);el.injector().invoke(function($compile){$compile(el)})}function setDocSrc(doc){var el=document.getElementById("docViewer");el.removeAttribute("src"),el.setAttribute("srcdoc",$sce.trustAsHtml(doc)),compile(el)}function onRefillFromHxOnly(request){refillFromHxOnlyCallbackFn&&refillFromHxOnlyCallbackFn(request)}function onTabSelected(){initallySelected=!0,refresh()}function refresh(){vm.refillQtyErrorIndex=-1,vm.selectAllPharmacies=!1,vm.changePharmacyEnabled=!1,Bridge.fireEvent("latest-rx-comment");var hxCallbackFn=tabSelectedCallbackFns.hx;if(hxCallbackFn&&hxCallbackFn(),vm.loadingPrescriberRights||vm.loadingVisitRx)pendingRefresh=!0;else{pendingRefresh=!1;var promises=[(vm.loadingPrescriberRights=!0,FncRxRepository.getPrescriberRights().then(function(prescriberRights){vm.prescriberRights=prescriberRights}).catch(function(error){vm.prescriberRights={},toaster.error("Error loading Prescriber Rights. "+ErrorService.convertToErrorMessages(error))}).finally(function(){vm.loadingPrescriberRights=!1})),loadVisitMedications()];$q.allSettled(promises).finally(function(){pendingRefresh&&refresh()})}}function toggleHide(){vm.hideContainer=!vm.hideContainer,vm.hideContainer&&vm.getVisitComment()}function updateSelectedPharmacies(pharmacy){var editableMedications=getEditableMedications();if(0!==_.size(editableMedications)){var pharmacyId=pharmacy&&pharmacy.Id,medicationIds=_.filter(editableMedications,"pharmacySelected").map(function(medication){return medication.RelVisitMedicationId});FncRxRepository.updateRxPharmacies(medicationIds,vm.patientId,pharmacyId).finally(function(){refresh();var vmUpdated={RelVisitMedicationIds:medicationIds};Bridge.fireEvent("multiplevisitmedication-update",vmUpdated)})}}function updateChangePharmacyEnabled(){vm.changePharmacyEnabled=!1;var editableMedications=getEditableMedications();_.some(editableMedications,"pharmacySelected")&&(vm.changePharmacyEnabled=!0)}function autoHideDrugSampleBanner(){vm.toggleDrugSampleBannerModified||vm.toggleDrugSampleBanner(!0)}function cancelStatusAutoUpdate(){medStatusIntervalPromise&&$interval.cancel(medStatusIntervalPromise)}vm.changePharmacyEnabled=!1,vm.hideContainer=!0,vm.itemsSelected=0,vm.loadCommentError=null,vm.loadingComment=!1,vm.loadingVisitRx=!1,vm.loadVisitRxError=null,vm.displayDrugSampleBanner=!1,vm.displayDrugSampleLink=!1,vm.mitochonHTML="",vm.medications=[],vm.prescriberRights={},vm.rxComment=void 0,vm.selectAllPharmacies=!1,vm.prmState=PrmState.Fnc.RxTab,vm.tinymceModel="RX Comment",vm.visitCommentType="RXComment",vm.refillQtyErrorIndex=-1,vm.refillDaysErrorIndex=-1,vm.refillQtyLoadingIndex=-1,vm.orderByDisplayOrder=!0,vm.displayIcdOnly=!0,vm.$onInit=function(){Bridge.on("drugSampleBanner-Result",$scope,function(data){data&&(vm.displayDrugSampleBanner=!0,vm.displayDrugSampleLink=!1,$timeout(autoHideDrugSampleBanner,15e3),setDocSrc(data))}),Bridge.on("edited-rx-comment",$scope,onEditedRxComment),Bridge.on("latest-rx-comment",$scope,onLatestRxComment),searchDrugsFn=vm.hostedFromDesktop?desktopSearchDrugs:searchDrugs;Bridge.on("sigwriter-check-unsaved-allergy-result",$scope,handleUnsavedAllergyCheck),Bridge.on("sigwriter-save-visit-result",$scope,function(){deferredSaveVisit.resolve()}),getVisitComment(),fillInKdbConfig(),vm.OnLoadGetDrugSampleBanner(),vm.registerRefillFromHxOnlyCallback({callbackFn:onRefillFromHxOnly}),vm.registerTabSelectedCallback({callbackFn:onTabSelected})},vm.$onDestroy=function(){cancelStatusAutoUpdate()},vm.canPrescribe=function(){return!vm.isCompleted&&vm.prescriberRights&&vm.prescriberRights.IsAllowedRxWrite&&vm.prescriberRights.AuthorizedPrescribers&&vm.prescriberRights.AuthorizedPrescribers.length},vm.childRegisterTabSelectedCallback=function(name,callbackFn){tabSelectedCallbackFns[name]=callbackFn,initallySelected&&callbackFn()},vm.deleteRx=function(med){apConfirm("Are you sure you want to delete "+med.Sig.DrugName+"?","Yes","No").then(function(result){result&&FncRxRepository.deleteRx(med.RelVisitMedicationId).catch(function(error){toaster.pop("error","","Error deleting prescription. "+ErrorService.convertToErrorMessages(error))}).finally(function(){vm.refresh();var vmUpdated={RelVisitMedicationId:med.RelVisitMedicationId};Bridge.fireEvent("visitmedication-delete",vmUpdated)})})},vm.getVisitComment=getVisitComment,vm.onClickPatientFormulary=function(){HxPatientFormularyModal.openModal(vm.patientId)},vm.onClickEditRxComment=function(){Bridge.fireEvent("edit-rx-comment",{Notes:vm.rxComment||null})},vm.onClickSearchDrugs=function(){searchDrugsFn()},vm.onClickSearchPharmacies=function(){if(!vm.changePharmacyEnabled)return;FncRxPharmacySearchModal.openModal(vm.patientId).then(function(pharmacy){updateSelectedPharmacies(pharmacy)})},vm.onClickSelectAllPharmacies=function(){var editableMedications=getEditableMedications();_.forEach(editableMedications,function(medication){medication.pharmacySelected=vm.selectAllPharmacies}),updateChangePharmacyEnabled()},vm.onClickEditRx=function(med){var sigwriterPromise=FncRxService.editPrescription(vm.patientId,vm.visitId,med.RelVisitMedicationId,!!vm.hostedFromDesktop,vm.getStateFromDesktopContext);sigwriterPromise.catch(function(){toaster.error("Unknown error initializing SIG Writer")}),openSigwriter(sigwriterPromise)},vm.onEditedRxComment=onEditedRxComment,vm.onMedicationChanged=function(sigType,prescription,changedMedication){vm.updateDesktopContext({relVisitMedicationId:changedMedication.RelVisitMedicationId,prescription:prescription,sigType:sigType}),refresh()},vm.onMedicationRefilled=function(sigType,prescription,refilledMedication){vm.updateDesktopContext({relVisitMedicationId:refilledMedication.RelVisitMedicationId,prescription:prescription,sigType:sigType}),refresh()},vm.onRegisterRefillFromHxOnlyCallback=function(callback){refillFromHxOnlyCallbackFn=callback},vm.onCommentUpdated=function(updatedValue){Bridge.fireEvent("save-rx-comment",{Notes:updatedValue,VisitId:vm.visitId,VisitCommentType:vm.visitCommentType})},vm.searchDrugs=searchDrugs,vm.openRxInfo=function(medication){Bridge.fireEvent("visitmedication-openinfo",medication.InfoButtonData)},vm.OnLoadGetDrugSampleBanner=function(){Bridge.fireEvent("loadDrugSampleBanner",{})},vm.toggleDrugSampleBanner=function(forceHide){vm.toggleDrugSampleModified=!0,vm.displayDrugSampleBanner||forceHide?(vm.displayDrugSampleBanner=!1,vm.displayDrugSampleLink=!0):(vm.displayDrugSampleBanner=!0,vm.displayDrugSampleLink=!1)},vm.refresh=refresh,vm.toggleHide=toggleHide,vm.updateSelectAllPharmacies=function(){vm.selectAllPharmacies=!1;var editableMedications=getEditableMedications();_.every(editableMedications,"pharmacySelected")&&(vm.selectAllPharmacies=!0);updateChangePharmacyEnabled()},vm.updateRefillsManual=function(index,med){!_.isInteger(med.RefillQty)||med.RefillQty<0||99<med.RefillQty?(vm.refillQtyErrorIndex=index,toaster.error("SIG is not valid. Please correct all errors.")):med.MedicationDays<0||999<med.MedicationDays?(vm.refillDaysErrorIndex=index,toaster.error("SIG is not valid. Please correct all errors.")):(vm.refillQtyLoadingIndex=index,vm.refillQtyErrorIndex=-1,vm.refillDaysErrorIndex=-1,FncRxRepository.updateRxRefill(vm.patientId,vm.visitId,med.RelVisitMedicationId,med.RefillQty,med.MedicationDays).then(function(){if(0!==_.size(vm.medications)){var medicationIds=[];medicationIds.push(vm.medications[index].RelVisitMedicationId);var vmUpdated={RelVisitMedicationIds:medicationIds};Bridge.fireEvent("multiplevisitmedication-update",vmUpdated)}}).catch(function(error){toaster.error(error.data.ModelState.commandResult[0])}).finally(function(){vm.refillQtyLoadingIndex=-1}))},vm.isSigTextLoading=function(index){return index===vm.refillQtyLoadingIndex},vm.isSigTextError=function(index){return index===vm.refillQtyErrorIndex},vm.isSigDaystError=function(index){return index===vm.refillDaysErrorIndex},vm.onOpenDxSelectModal=function(med){var selectedItems=[];return _.forEach(med.Problems,function(problem){selectedItems.push(problem)}),DxProblemsModal.openModal(vm.patientId,void 0,!0,selectedItems,formatterModal,getOrderModal).then(function(newProblems){FncRxRepository.editPrescriptionDiagnosis(vm.patientId,vm.visitId,med.RelVisitMedicationId,newProblems).then(function(){var medicationIds=[];medicationIds.push(med.RelVisitMedicationId);var vmUpdated={RelVisitMedicationIds:medicationIds};Bridge.fireEvent("multiplevisitmedication-update",vmUpdated),refresh()}).catch(function(error){toaster.error(error.data.ModelState.commandResult[0])}).finally(function(){})}).catch(function(response){ErrorService.addHttpErrorToScope(vm,response)}).finally(function(){})}}]})}(),function(){"use strict";angular.module("aprima-fnc").factory("FncRxDrugScreeningModal",["$uibModal",function($modal){return{openModal:function(patientId,visitId){return $modal.open({backdrop:"static",templateUrl:"/fnc/tabs/rx/views/fncRxDrugScreeningModal.html",windowClass:"modal-full",controller:"FncRxDrugScreeningCtrl",controllerAs:"$ctrl",resolve:{patientId:function(){return patientId},visitId:function(){return visitId}}}).result}}}]),angular.module("aprima-fnc").controller("FncRxDrugScreeningCtrl",["$uibModalInstance","patientId","visitId",function($modalInstance,patientId,visitId){this.visitScreeningParameters={patientId:patientId,visitId:visitId},this.cancel=function(){$modalInstance.dismiss()}}])}(),function(){"use strict";angular.module("aprima-fnc").factory("FncRxDrugSearchModal",["$q","SigwriterDrugSearchV1ModalService",function($q,SigwriterDrugSearchV1ModalService){return{openModal:function(patientId,initialSearchText,kdbParameters){var promise=SigwriterDrugSearchV1ModalService.openModal$(initialSearchText,patientId,kdbParameters).toPromise().then(function(result){return result.isSuccess?result.resultValue:$q.reject(result)});return $q.when(promise)}}}])}(),function(){"use strict";angular.module("aprima-fnc").factory("FncRxPharmacySearchModal",["$uibModal",function($modal){return{openModal:function(patientId){return openModalOnly(patientId).result},openModalOnly:openModalOnly};function openModalOnly(patientId){return $modal.open({templateUrl:"/fnc/tabs/rx/views/FncRxPharmacySearchModal.html",controller:"FncRxPharmacySearchModalCtrl",controllerAs:"vm",resolve:{patientId:function(){return patientId}}})}}]),angular.module("aprima-fnc").controller("FncRxPharmacySearchModalCtrl",["$uibModalInstance","patientId",function($modalInstance,patientId){var vm=this;vm.patientId=patientId,vm.pharmacy={},vm.cancel=function(){$modalInstance.dismiss()},vm.onPharmacySelected=function(){$modalInstance.close(vm.pharmacy)}}])}(),function(angular){"use strict";angular.module("aprima-fnc").factory("FncRxService",["$q","_","DrugCoreService","ErrorService","FncRxRepository","FncRxSigwriterModal","HxRefillSigwriterModal","RxCouponService","SaveRxModal","SigwriterDrugScreeningService","SigwriterRxService","VisitRefillSigwriterModal",function($q,_,DrugCoreService,ErrorService,FncRxRepository,FncRxSigwriterModal,HxRefillSigwriterModal,RxCouponService,SaveRxModal,SigwriterDrugScreeningService,SigwriterRxService,VisitRefillSigwriterModal){return{addPrescriptionFromCppMedication:function(patientId,visitId,cppMedicationId,skipSigwriter,hostedFromDesktop){return FncRxRepository.startCppMedication(patientId,visitId,cppMedicationId,"NewRx").then(function(startCppResult){var prescription=startCppResult.Prescription;return DrugCoreService.validateDrugs(prescription.Drug,"NewRx").then(function(){if(prescription.FromDesktop=hostedFromDesktop,skipSigwriter&&startCppResult.CanSkipSigwriter){var drug=prescription.Drug;return SigwriterDrugScreeningService.performDrugScreening(null,drug,patientId,visitId,null).then(function(screeningResult){prescription.ScreeningOverride=screeningResult.overrideText,prescription.ScreeningResult=screeningResult.screeningResult;var savePromise=FncRxRepository.addPrescription(patientId,visitId,prescription);return SaveRxModal.openModal(savePromise).then(function(visitMedication){return postAddRelVisitMedication(visitId,visitMedication.RelVisitMedicationId,hostedFromDesktop),{prescription:prescription,visitMedication:visitMedication,sigType:"NewRx"}})})}return SigwriterRxService.loadFromSigwriterResultsDto("NewRx",patientId,prescription,startCppResult.VisitInfo).then(function(rx){return openSigwriterToAddPrescription(rx)})})})},editPrescription:function(patientId,visitId,relVisitMedicationId,hostedFromDesktop,preprocessRxFn){var visitInfo={visitId:visitId};return SigwriterRxService.loadFromExistingRelVisitMedication("EditRx",patientId,relVisitMedicationId,visitInfo,preprocessRxFn).then(function(rx){return openSigwriterToEditPrescription(rx,hostedFromDesktop).catch(function(){})})},openSigwriterToAddPrescription:openSigwriterToAddPrescription,openSigwriterToEditPrescription:openSigwriterToEditPrescription,postAddRelVisitMedication:postAddRelVisitMedication,refillFromHx:function(sigType,rxHistoryMed,patientId,visitId,fromDesktop){return rxHistoryMed?(fromDesktop=!!fromDesktop,fullMedicationRefill(sigType,patientId,visitId,rxHistoryMed.RelPatientMedicationUid,fromDesktop,FncRxRepository.startRefill,FncRxRepository.refillMedication,function(rx){var options={rx:rx};return HxRefillSigwriterModal.openModal(rxHistoryMed,options,fromDesktop)})):$q.reject("Invalid rxHistoryMed")},refillFromPreviousVisit:function(sigType,relVisitMedicationId,patientId,visitId,fromDesktop){return relVisitMedicationId?fullMedicationRefill(sigType,patientId,visitId,relVisitMedicationId,fromDesktop=!!fromDesktop,FncRxRepository.startRefillFromPreviousVisit,FncRxRepository.refillMedicationFromPreviousVisit,function(rx){var options={hostedFromDesktop:fromDesktop,rx:rx};return VisitRefillSigwriterModal.openModal(relVisitMedicationId,options)}).then(function(results){return postAddRelVisitMedication(visitId,results.visitMedication.Id,fromDesktop),results}):$q.reject("Invalid relVisitMedicationId")}};function openSigwriterToAddPrescription(rx,hostedFromDesktop){var options={hostedFromDesktop:hostedFromDesktop,rx:rx};return FncRxSigwriterModal.openModal(options).then(function(results){var prescription=results.prescription,visitMedication=results.visitMedication;return postAddRelVisitMedication(rx.visit.VisitId,visitMedication.RelVisitMedicationId,prescription.FromDesktop),{prescription:prescription,visitMedication:visitMedication,sigType:rx.sigType}})}function openSigwriterToEditPrescription(rx,hostedFromDesktop){var options={hostedFromDesktop:hostedFromDesktop,rx:rx};return FncRxSigwriterModal.openModal(options).then(function(results){var visitMedication=results.visitMedication;return{prescription:results.prescription,visitMedication:visitMedication,sigType:rx.sigType}})}function postAddRelVisitMedication(visitId,relVisitMedicationId,fromDesktop){fromDesktop||RxCouponService.downloadAndSaveRxCoupon(visitId,relVisitMedicationId)}function fullMedicationRefill(sigType,patientId,visitId,relVisitOrPatientMedId,fromDesktop,startRefillFn,refillMedFn,openSigwriterFn){if(!patientId||!visitId||!relVisitOrPatientMedId)return $q.reject(new Error("Invalid sigType, patientId, visitId, relVisitMedicationId, or relPatientMedicationId"));fromDesktop=!!fromDesktop;var refillPromise=startRefillFn(patientId,visitId,relVisitOrPatientMedId,sigType).then(function(result){if(!result)return $q.reject(new Error("Undefined med for refill"));var drug=result.Prescription.Drug,previousMedicationSigId=result.Prescription.PreviousMedicationSigUid;return DrugCoreService.validateDrugs(drug,sigType).then(function(){if(result.CanSkipSigwriter){var skipAndSavePromise=SigwriterDrugScreeningService.performDrugScreening(null,drug,patientId,visitId,previousMedicationSigId).then(function(screeningResult){var prescription=result.Prescription;prescription.FromDesktop=fromDesktop,prescription.ScreeningOverride=screeningResult.overrideText,prescription.ScreeningResult=screeningResult.screeningResult;var savePromise=refillMedFn(patientId,visitId,relVisitOrPatientMedId,prescription);return SaveRxModal.openModal(savePromise).then(function(visitMedication){var fullResult={prescription:prescription,visitMedication:visitMedication,sigType:sigType};return fullResult}).catch(goToSigwriter)});return skipAndSavePromise}var openSigwriterPromise=goToSigwriter();return openSigwriterPromise;function goToSigwriter(){return SigwriterRxService.loadFromSigwriterResultsDto(sigType,patientId,result.Prescription,result.VisitInfo).then(function(rx){return openSigwriterFn(rx).then(function(results){var fullResult={prescription:results.prescription,visitMedication:results.visitMedication,sigType:sigType};return fullResult},function(){return $q.reject({cancelled:!0})})})}})}).catch(function(response){return response&&response.cancelled||ErrorService.displayErrorMessages("Unknown error initializing refill"),$q.reject(response)});return refillPromise}}])}(angular),function(){"use strict";angular.module("aprima-fnc").factory("FncRxSigwriterModal",["$uibModal",function($modal){return{openModal:function(options){return openModalOnly(options).result},openModalOnly:openModalOnly};function openModalOnly(options){return $modal.open({templateUrl:"/fnc/tabs/rx/views/fncRxSigwriterModal.html",windowClass:"modal-full modal-sigwriter-tablet",controller:"FncRxSigwriterModalCtrl",controllerAs:"vm",resolve:{options:function(){return options}}})}}]),angular.module("aprima-fnc").controller("FncRxSigwriterModalCtrl",["$uibModalInstance","options","Bridge","FncRxRepository","SaveRxModal","SigwriterRxService",function($modalInstance,options,Bridge,FncRxRepository,SaveRxModal,SigwriterRxService){function cancel(){$modalInstance.dismiss()}this.options=options,this.cancel=cancel,this.completed=function(rx){var patientId=rx.patient.Id,visitId=rx.visit.VisitId,prescription=SigwriterRxService.mapToSigwriterResultsDto(rx);prescription.FromDesktop=options.hostedFromDesktop;var savePromise=null;savePromise="EditRx"===rx.sigType?FncRxRepository.editPrescription(patientId,visitId,prescription):FncRxRepository.addPrescription(patientId,visitId,prescription);return SaveRxModal.openModal(savePromise).then(function(visitMedication){$modalInstance.close({prescription:prescription,visitMedication:visitMedication})})},Bridge.on("sigwriter-accept-close",null,function(){cancel()})}])}(),function(angular){"use strict";angular.module("aprima-fnc").factory("VisitRefillSigwriterModal",["$uibModal",function($modal){return{openModal:function(relVisitMedicationId,options){return openModalOnly(relVisitMedicationId,options).result},openModalOnly:openModalOnly};function openModalOnly(relVisitMedicationId,options){return $modal.open({templateUrl:"/fnc/tabs/rx/views/visitRefillSigwriterModal.html",windowClass:"modal-full modal-sigwriter-tablet",controller:"VisitRefillSigwriterModalCtrl",controllerAs:"vm",resolve:{options:function(){return options},relVisitMedicationId:function(){return relVisitMedicationId}}})}}]),angular.module("aprima-fnc").controller("VisitRefillSigwriterModalCtrl",["$uibModalInstance","options","FncRxRepository","relVisitMedicationId","SaveRxModal","SigwriterRxService",function($modalInstance,options,FncRxRepository,relVisitMedicationId,SaveRxModal,SigwriterRxService){this.options=options,this.cancel=function(){$modalInstance.dismiss()},this.completed=function(rx){var patientId=rx.patient.Id,visitId=rx.visit.VisitId,prescription=SigwriterRxService.mapToSigwriterResultsDto(rx);prescription.FromDesktop=options.hostedFromDesktop;var savePromise=FncRxRepository.refillMedicationFromPreviousVisit(patientId,visitId,relVisitMedicationId,prescription);SaveRxModal.openModal(savePromise).then(function(visitMedication){$modalInstance.close({prescription:prescription,visitMedication:visitMedication})})}}])}(window.angular),function(){"use strict";angular.module("aprima-fnc").component("fncVisitText",{templateUrl:"/fnc/tabs/visitText/component-views/fncVisitText.html",bindings:{patientId:"<",visitId:"<",registerTabSelectedCallback:"&"},controller:["$scope","VisitRepository","$q","$sce",function($scope,VisitRepository,$q,$sce){var vm=this;function onTabSelected(){vm.loadingVisitText||(vm.loadingVisitText=!0,VisitRepository.getVisitDocumentForVisitText(vm.patientId,vm.visitId).then(function(data){vm.visit.document=data,vm.visit.document.VisitHtml=$sce.trustAsHtml(vm.visit.document.VisitHtml)}).catch(function(response){return vm.httpErrorVisitText=response,$q.reject(response)}).finally(function(){vm.loadingVisitText=!1}))}vm.loadingVisitText=!1,vm.visit={},vm.$onInit=function(){vm.registerTabSelectedCallback({callbackFn:onTabSelected})}}]})}();
//# sourceMappingURL=aprima-fnc.min.js.map