﻿<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="html" encoding="UTF-8"/>
  <xsl:template match="/">
    <html>
      <head>
        <title>Session List</title>
        <link href="ActivityMonitor.css" type="text/css" rel="stylesheet"/>
        <META HTTP-EQUIV="CACHE-CONTROL" CONTENT="NO-CACHE" />
        <script src="ClientScripts.js" type="text/javascript"></script>
      </head>
      <body>
        <table border="1">
          <tr>
            <td>Port</td>
            <td>
              <xsl:value-of select="Http/@port"/>
            </td>
          </tr>
          <tr>
            <td>SSL</td>
            <td>
              <xsl:value-of select="Http/@ssl"/>
            </td>
          </tr>
          <tr>
            <td>Default Domain</td>
            <td>
              <xsl:value-of select="Http/@defaultDomain"/>
            </td>
          </tr>
        </table>
        <br />
        <table width="100%">
          <thead>
            <tr>
              <td>
                Name
              </td>
              <td>
                URL
              </td>
              <td>
                Data
              </td>
            </tr>
          </thead>
          <tbody>
            <xsl:for-each select="Http/*">
              <tr>
                <xsl:if test="position() mod 2 = 0">
                  <xsl:attribute name="class">oddrow</xsl:attribute>
                </xsl:if>
                <xsl:if test="position() mod 2 = 1">
                  <xsl:attribute name="class">evenrow</xsl:attribute>
                </xsl:if>
                <td>
                    <xsl:value-of select="name(.)"/>
                </td>
                <td>
                  <xsl:value-of select="@url" />
                </td>
                <td>
                  <xsl:value-of select="@data" disable-output-escaping="yes"/>
                </td>
              </tr>              
            </xsl:for-each>
          </tbody>
        </table>
      </body>
    </html>
  </xsl:template>
</xsl:stylesheet>