BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[eRxMedicationHistoryDetail]') AND name = 'SigTextDirection')
    ALTER TABLE [eRxMedicationHistoryDetail] ADD [SigTextDirection] varchar(1200) NULL 
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[IcTransmitted_Patient]') AND name = 'LastReviewDateUTC')
    ALTER TABLE [IcTransmitted_Patient] DROP COLUMN [LastReviewDateUTC] 
IF EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[IcTransmitted_Patient]') AND name = 'PayLoad')
    ALTER TABLE [IcTransmitted_Patient] DROP COLUMN [PayLoad] 
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IcTransmitted_Patient_PracticeSettings]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[IcTransmitted_Patient_PracticeSettings](
	[TransmittedUid] [uniqueidentifier] NOT NULL,
	[PersonUid] [uniqueidentifier] NOT NULL,
	[PracticeSettingsUid] [uniqueidentifier] NOT NULL,
	[LastSuccessfulTransmissionDateUTC] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'InteliChart', @value=N'TransmittedTrackingTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'IcTransmitted_Patient_PracticeSettings'

ALTER TABLE [IcTransmitted_Patient_PracticeSettings] ADD  CONSTRAINT [DF_IcTransmitted_Patient_PracticeSettings_TransmittedUid]  DEFAULT (newid()) FOR [TransmittedUid]
ALTER TABLE [IcTransmitted_Patient_PracticeSettings] ADD  CONSTRAINT [DF_IcTransmitted_Patient_PracticeSettings_LastSuccessfulTransmissionDateUTC]  DEFAULT (getutcdate()) FOR [LastSuccessfulTransmissionDateUTC]

END
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[VisitComplexity]') AND name = 'CounselingDescriptionHTML')
    ALTER TABLE [VisitComplexity] ADD [CounselingDescriptionHTML] varchar(max) NULL 
exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'BasedOnTypeID' , N'SCHEMA',N'dbo', N'TABLE',N'VisitComplexity', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'BasedOnTypeID' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitComplexity'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'DocumentMdmBasedOn' , N'SCHEMA',N'dbo', N'TABLE',N'VisitComplexity', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'DocumentMdmBasedOn' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitComplexity'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'PlaceOfServiceDetail' , N'SCHEMA',N'dbo', N'TABLE',N'VisitComplexity', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'PlaceOfServiceDetail' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitComplexity'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'TypeOfService' , N'SCHEMA',N'dbo', N'TABLE',N'VisitComplexity', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'TypeOfService' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitComplexity'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'VisitComplexity', N'COLUMN',N'MedicalChecked'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitComplexity', @level2type=N'COLUMN',@level2name=N'MedicalChecked'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'BasedOnTypeID' , N'SCHEMA',N'dbo', N'TABLE',N'VisitComplexity', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'BasedOnTypeID', @value=N'<None value="0" /><Time value="2" /><Documentation value="3" /><DecisionMaking2021 value="4" /><Time2021 value="5" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitComplexity'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'DocumentMdmBasedOn' , N'SCHEMA',N'dbo', N'TABLE',N'VisitComplexity', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'DocumentMdmBasedOn', @value=N'<None value="0" />
<Guideline value="1" />
<Selected value="2" />
' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitComplexity'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'PlaceOfServiceDetail' , N'SCHEMA',N'dbo', N'TABLE',N'VisitComplexity', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'PlaceOfServiceDetail', @value=N'<None value="0" />
<DOM value="1" />
<ALF value="2" />
<AFC value="3" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitComplexity'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'TypeOfService' , N'SCHEMA',N'dbo', N'TABLE',N'VisitComplexity', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'TypeOfService', @value=N'<None value="0" />
<OfficeNewPatient value="1" />
<OfficeEstablishedPatient value="2" />
<OfficeConsult value="3" />
<NursingFaclityInitial value="4" />
<NursingFaclitySubsequent value="5" />
<HospitalObervationInitial value="6" />
<HospitalObervationDischarge value="7" />
<HospitalObervationInpatient value="8" />
<HospitalInpatientInitial value="9" />
<HospitalInpatientSubsequent value="10" />
<HospitalInpatientDischarge value="11" />
<HospitalInpatientInpatient value="12" />
<HospitalInpatientConsultation value="13" />
<HospitalCriticalCareAdult value="14" />
<HospitalCriticalCarePediatric value="15" />
<HospitalCriticalCareNeonatal value="16" />
<HospitalERVisit value="17" />
<HospitalERAdvancedLifeSupport value="18" />
<HomeServicesNewPatient value="19" />
<HomeServicesEstablishedPatient value="20" />
<RestHomeNewPatient value="21" />
<RestHomeEstablishedPatient value="22" />
<NursingFaclityDischarge value="23" />
<TelehealthNewFaceToFace value="24" />
<TelehealthEstablishedFaceToFace value="25" />
<TelehealthNewNonFaceToFace value="26" />
<TelehealthEstablishedNonFaceToFace value="27" />
<HospitalObervationInpatientInitial value="28" />
<HospitalObervationInpatientSubsequent value="29" />
<HospitalObervationOrInpatient value="30" />
<HospitalObervationInpatientDischarge value="31" />
<HospitalObervationInpatientConsultation value="32" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitComplexity'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'VisitComplexity', N'COLUMN',N'MedicalChecked'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Hx CheckedFlag: 0: none; 1: checked; 2: modified; 3: checked + modified' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitComplexity', @level2type=N'COLUMN',@level2name=N'MedicalChecked'
GO

