<?xml version='1.0'?>
<xsl:stylesheet version="1.0"
      xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="html"/>
	<xsl:template match="/">
		<Root>
			<Patient>
Patient ID :<xsl:value-of select="/DICOMXMLConverted/Patient_ID_00100020"/>	
Patient Name :<xsl:value-of select="/DICOMXMLConverted/Patients_Name_00100010"/> 
Gender :<xsl:value-of select="/DICOMXMLConverted/Patients_Sex_00100040"/> 
Birth Date :<xsl:value-of select="normalize-space(/DICOMXMLConverted/Patients_Birth_Date_00100030)"/>
			</Patient>
			<Diagnosis>
				<xsl:apply-templates select="/DICOMXMLConverted/Annotation_Sequence_0040B020">
				</xsl:apply-templates>
			</Diagnosis>
			<Speed>
<xsl:apply-templates select="/DICOMXMLConverted/Waveform_Sequence_54000100"></xsl:apply-templates>
			</Speed>
		</Root>
	</xsl:template>
 
  	<xsl:template match="Annotation_Sequence_0040B020">
		<xsl:for-each select="Item">
			<xsl:if test="Numeric_Value_0040A30A != ''">
				<Item>
					<Name>
						<xsl:value-of select="Concept_Name_Code_Sequence_0040A043/Item/Code_Meaning_00080104"/>
					</Name>
					<Value>
						<xsl:value-of select="Numeric_Value_0040A30A"/>
					</Value>
				</Item>
			</xsl:if>
			<xsl:if test="Unformatted_Text_Value_00700006 != ''">
				<Rhythm>
					<xsl:value-of select="Unformatted_Text_Value_00700006"/>
				</Rhythm>
			</xsl:if>
			<!--<xsl:apply-templates select="Referenced_Series_Sequence_00081115">
			</xsl:apply-templates>--> 
		</xsl:for-each>
	</xsl:template>

	<xsl:template match="Waveform_Sequence_54000100">F <xsl:value-of select="Item/Channel_Definition_Sequence_003A0200/Item/Notch_Filter_Frequency_003A0222"/>~<xsl:value-of select="Item/Channel_Definition_Sequence_003A0200/Item/Filter_Low_Frequency_003A0220"/>-<xsl:value-of select="Item/Channel_Definition_Sequence_003A0200/Item/Filter_High_Frequency_003A0221"/> Hz
	</xsl:template>
		
</xsl:stylesheet>