angular.module("aprima-legacy-common",["ui.router","restangular","ngTouch","ngAnimate","truncate","ui.bootstrap","angularLocalStorage","gettext","lodash","toaster","rt.debounce","hmTouchEvents","aprima-core","aprima-bridge","aprima-config"]),angular.module("aprima-legacy-common").value("moment",window.moment),function(){"use strict";var messageTypes={LabResultMessageGuid:"",TaskMessageGuid:"10101010-0000-0000-0000-000000000005",PortalAppointmentQuestionMessageGuid:"fd4e2c5d-29c6-4a51-bd20-551d6ed90843",PortalBillingQuestionMessageGuid:"73366ba8-0149-47e0-875b-cb12bb4cb250",PortalDemographicsQuestionMessageGuid:"dffb40d0-2318-41a9-8eef-94c58babb9b9",PortalGeneralQuestionMessageGuid:"9af1089b-e98b-4758-80f8-0435b143426d",PortalRxQuestionMessageGuid:"e94b7146-407d-4f92-a393-de8429b7bfbf",PhoneMessageGuid:"10101010-0000-0000-0000-000000000003",LabMessageGuid:"f05f9c71-a893-46c3-a7fe-37988f48a782",AttachmentApprovalGuid:"10101010-0000-0000-0000-000000000002",ServiceOrderApprovalMessageGuid:"10101010-0000-0000-0000-000000000008",RxRefillRequestMessageGuid:"136d8762-82ec-487d-9448-f52469a3cdcd",PatientRxRefillRequestMessageGuid:"b1b7d286-1fb2-43d0-a883-7946b1cd8751",PharmacyRefillRequestMessageGuid:"d7716f70-61d6-4ec0-8ba6-01afc95e99f2"};messageTypes.SupportedMessageTypesForCreate={Types:[{id:messageTypes.TaskMessageGuid},{id:messageTypes.PhoneMessageGuid,requiredFeature:"PhoneMessageCreation"}],SubTypes:[{id:messageTypes.PortalGeneralQuestionMessageGuid}]};var appointmentScheduleTypes={PatientVisit:{id:"patientvisit",name:"Patient Visit"},Event:{id:"event",name:"Event",requiredFeature:"Appointments_DifferentScheduleTypes"},BlockingEvent:{id:"blockingevent",name:"Blocking Event",requiredFeature:"Appointments_DifferentScheduleTypes"},GroupVisit:{id:"groupvisit",name:"Group Visit",requiredFeature:"Appointments_DifferentScheduleTypes"}};appointmentScheduleTypes.List=_.values(appointmentScheduleTypes);angular.module("aprima-legacy-common").constant("MessageTypes",messageTypes),angular.module("aprima-legacy-common").constant("AppointmentScheduleTypes",appointmentScheduleTypes),angular.module("aprima-legacy-common").constant("RequestTypes",{listData:"listData",default:"default"})}(),angular.module("aprima-legacy-common").run(["CustomModuleRunService",function(CustomModuleRunService){"use strict";CustomModuleRunService.add(["$rootScope","ErrorService","RequestTypes","$transitions",function($rootScope,ErrorService,RequestTypes,$transitions){$rootScope.requestTypes=RequestTypes,$rootScope.addHttpError=function(httpResponse,messages,type){return httpResponse.isAborted?httpResponse:ErrorService.addHttpErrorToScope(this,httpResponse,messages,type)},$rootScope.removeHttpError=function(type){return ErrorService.removeHttpErrorFromScope(this,type)},$rootScope.setupDirectiveScope=function($scope){$scope.addHttpError=$rootScope.addHttpError,$scope.removeHttpError=$rootScope.removeHttpError},$transitions.onSuccess({},function(){$rootScope.removeHttpError()})}])}]),angular.module("aprima-legacy-common").run(["CustomModuleRunService",function(CustomModuleRunService){"use strict";CustomModuleRunService.add(["$rootScope","TransitionManager","AprimaAnalytics","DeviceSettings","_","toaster",function($rootScope,TransitionManager,AprimaAnalytics,DeviceSettings,_,toaster){$rootScope.goBack=function(){TransitionManager.goBack(),AprimaAnalytics.sendEvent("user","click","back button")},$rootScope.isEmpty=function(obj){return _.isEmpty(obj)},$rootScope.isPhone=DeviceSettings.isPhoneOrOverride,$rootScope.isTablet=DeviceSettings.isTabletOrOverride,$rootScope.isBrowser=DeviceSettings.isBrowserOrOverride,$rootScope.tryToastModelStateError=function(response){var modelState=response.ModelState||response.data&&response.data.ModelState;modelState&&modelState.commandResult&&_(modelState.commandResult).forEach(function(e){toaster.pop("error","",e)})}}])}]),angular.module("aprima-legacy-common").run(["CustomModuleRunService",function(CustomModuleRunService){"use strict";CustomModuleRunService.add(["LocalStorageRepository","LanguageFactory",function(LocalStorageRepository,LanguageFactory){var currentLanguage;LocalStorageRepository.getLang()?currentLanguage=LocalStorageRepository.getLang():navigator.userLanguage?currentLanguage=navigator.userLanguage:navigator.language&&(currentLanguage=navigator.language),currentLanguage&&LanguageFactory.setLang(currentLanguage)}])}]),angular.module("aprima-legacy-common").factory("aprgettext",["gettextCatalog",function(gettextCatalog){"use strict";return function(text){return gettextCatalog.getString(text)}}]),angular.module("aprima-legacy-common").run(["CustomModuleRunService",function(CustomModuleRunService){"use strict";CustomModuleRunService.add(["Bridge","$transitions","AppRoutes","_","$uibModalStack",function(Bridge,$transitions,AppRoutes,_,$uibModalStack){$transitions.onSuccess({},function(transition){$uibModalStack.dismissAll("pageTransition");var toState=transition.targetState()||{},toStateName=toState&&toState.name()||"",appRoute=_.find(AppRoutes,{state:toStateName});appRoute&&appRoute.nativeSettings&&!appRoute.nativeSettings.ctrlSetsUpPage&&Bridge.setupPage(appRoute.nativeSettings)})}])}]),angular.module("aprima-legacy-common").run(["CustomModuleRunService",function(CustomModuleRunService){"use strict";CustomModuleRunService.add(["$rootScope","$location","$log","AprimaAnalytics","$state",function($rootScope,$location,$log,AprimaAnalytics,$state){$rootScope.$watch(function(){return $location.path()},function(a){var output=$state.current.description?$state.current.description:a;$log.info("url has changed: "+output),AprimaAnalytics.sendPageView(output)})}])}]),function(angular){"use strict";function momentSetup(moment){moment.fn.removeOffset=function(){return this.add(this.utcOffset(),"minutes").utc()},moment.fn.formatRemoveOffset=function(){return this.removeOffset().format()},moment.fn.startOfDate=function(){return this.startOf("day").toDate()}}window.angular.module("aprima-legacy-common").run(["CustomModuleRunService",function(CustomModuleRunService){CustomModuleRunService.add(["moment",momentSetup])}])}(),angular.module("aprima-legacy-common").run(["CustomModuleRunService",function(CustomModuleRunService){"use strict";CustomModuleRunService.add(["Restangular","_","HttpAbortableContext","$qHelpers",function(Restangular,_,HttpAbortableContext,$qHelpers){var abortableFields={};function wrapCallsToRestangularizedElement(restangularizedElement,promiseInterceptor){return _(restangularizedElement).functions().forEach(function(key){var elementFn=restangularizedElement[key],wrappedKey="_"+key;restangularizedElement[wrappedKey]=restangularizedElement[wrappedKey]||elementFn,restangularizedElement[key]=function(){var result=elementFn.apply(this,arguments);return $qHelpers.isPromise(result)&&(result=promiseInterceptor(result)),result}}),restangularizedElement}abortableFields.abortable="abortable",abortableFields.aborts="aborts",Restangular.setRestangularFields(abortableFields),Restangular.setOnElemRestangularized(function(element,isCollection,route,restangularObject){element&&restangularObject.configuration.isRestangularized(element)&&(element.aborts=function(promisesToAbort){return wrapCallsToRestangularizedElement(this,function(promise){return $qHelpers.abortPromises(promisesToAbort),promise}),this},element.abortable=function(promisesToAbort){var abortableContext=new HttpAbortableContext(promisesToAbort),httpConfig=restangularObject.configuration.restangularFields.httpConfig;return this[httpConfig]=_.defaults(this[httpConfig],{timeout:abortableContext.abortPromise}),wrapCallsToRestangularizedElement(this,abortableContext.wrap),this});return element})}])}]),angular.module("aprima-legacy-common").config(["$provide",function($provide){"use strict";$provide.decorator("$exceptionHandler",["$delegate","$injector",function($delegate,$injector){var AprimaAnalytics;return function(exception,cause){var message=exception.message+' (caused by "'+cause+'")';try{(AprimaAnalytics=AprimaAnalytics||$injector.get("AprimaAnalytics")).sendException(message)}catch(ex){}$delegate(exception,cause)}}])}]),angular.module("aprima-legacy-common").filter("apPatientThumbnailSrc",[function(){"use strict";return function(patientId,height,width){if(patientId){height&&!width&&(width=height);var url="patients/"+patientId+"/thumbnail";return height&&(url+="?height="+height+"&width="+width),url}}}]),function(){"use strict";angular.module("aprima-legacy-common").filter("apPersonThumbnailSrc",["ServerInfoRepository",function(ServerInfoRepository){return function(personId,height,width){if(personId&&ServerInfoRepository.isFeatureSupported(["PersonPhoto"])){height&&!width&&(width=height);var url="persons/"+personId+"/thumbnail";return height&&(url+="?height="+height+"&width="+width),url}}}])}(),function(angular){"use strict";window.angular.module("aprima-legacy-common").factory("DoseRange",["ObjUtil",function(ObjUtil){return DoseRange.mapFromDto=function(obj){return obj?new DoseRange(obj):null},DoseRange;function DoseRange(obj){ObjUtil.defineReadonlyProps(this,{Id:obj.Id,WeightRequired:obj.WeightRequired,BodySurfaceAreaRequired:obj.BodySurfaceAreaRequired,LowDose:obj.LowDose,LowDoseUnits:obj.LowDoseUnits,HighDose:obj.HighDose,HighDoseUnits:obj.HighDoseUnits,MaximumDosePerDay:obj.MaximumDosePerDay,MaximumDosePerDayUnits:obj.MaximumDosePerDayUnits,MaximumSingleDose:obj.MaximumSingleDose,MaximumSingleDoseUnits:obj.MaximumSingleDoseUnits,MaximumLifetimeDose:obj.MaximumLifetimeDose,MaximumLifetimeDoseUnits:obj.MaximumLifetimeDoseUnits,NteAmountPerSingleDose:obj.NteAmountPerSingleDose,NteAmountPerSingleDoseUnits:obj.NteAmountPerSingleDoseUnits,LowFrequency:obj.LowFrequency,HighFrequency:obj.HighFrequency,LowDuration:obj.LowDuration,HighDuration:obj.HighDuration,AdjustedLowDose:obj.AdjustedLowDose,AdjustedHighDose:obj.AdjustedHighDose,AdjustedMaximumSingleDose:obj.AdjustedMaximumSingleDose,AdjustedMaximumDosePerDay:obj.AdjustedMaximumDosePerDay,AdjustedMaximumLifetimeDose:obj.AdjustedMaximumLifetimeDose,AdjustedNteAmountPerSingleDose:obj.AdjustedNteAmountPerSingleDose,RangeLowDose:obj.RangeLowDose,RangeLowDoseUnits:obj.RangeLowDoseUnits,RangeHighDose:obj.RangeHighDose,RangeHighDoseUnits:obj.RangeHighDoseUnits,RangeLowDoseForm:obj.RangeLowDoseForm,RangeLowDoseFormUnits:obj.RangeLowDoseFormUnits,RangeHighDoseForm:obj.RangeHighDoseForm,RangeHighDoseFormUnits:obj.RangeHighDoseFormUnits,NtePediDailyDoseStrength:obj.NtePediDailyDoseStrength,NtePediDailyDoseStrengthUnits:obj.NtePediDailyDoseStrengthUnits,NtePediDailyDoseForm:obj.NtePediDailyDoseForm,NtePediDailyDoseFormUnits:obj.NtePediDailyDoseFormUnits,IngredientStrength:obj.IngredientStrength,IngredientStrengthUomAbbr:obj.IngredientStrengthUomAbbr,IngredientStrengthUomDesc:obj.IngredientStrengthUomDesc,IngredientVolume:obj.IngredientVolume,IngredientVolumeUomAbbr:obj.IngredientVolumeUomAbbr,IngredientVolumeUomDesc:obj.IngredientVolumeUomDesc,WeightKg:obj.WeightKg,BodySurfaceArea:obj.BodySurfaceArea,ErrorMsg:obj.ErrorMsg,HasError:obj.HasError})}}])}(),function(angular){"use strict";window.angular.module("aprima-legacy-common").factory("DoseRangeInfo",["DoseRange","ObjUtil",function(DoseRange,ObjUtil){return DoseRangeInfo.mapFromDto=function(obj){return obj?new DoseRangeInfo(obj):null},DoseRangeInfo;function DoseRangeInfo(obj){DoseRange.call(this,obj),ObjUtil.defineReadonlyProps(this,{MaxMinInformation:obj.MaxMinInformation})}}])}(),function(angular){"use strict";window.angular.module("aprima-legacy-common").factory("ImoPatient",["_","DateUtilities","ObjUtil",function(_,DateUtilities,ObjUtil){var femaleRegex=/^f(emale)?$/i,maleRegex=/^m(ale)?$/i;return ImoPatient.mapFromApi=function(patient){if(!patient)return null;var name=patient.FirstName+" "+patient.LastName,birthDate=patient.BirthDate||patient.DateOfBirth,deathDate=patient.DeathDate,ageInfo=DateUtilities.getPersonAge(birthDate,deathDate,"years"),gender=patient.Gender||patient.GenderName||patient.GenderAnsi;return new ImoPatient(name,ageInfo.age,gender)},ImoPatient;function ImoPatient(name,ageInYears,gender){var standardizedAge=null;ageInYears=parseFloat(ageInYears),!_.isNaN(ageInYears)&&0<=ageInYears&&(standardizedAge=_.round(ageInYears));var standardizedGender=null;femaleRegex.test(gender)?standardizedGender="F":maleRegex.test(gender)&&(standardizedGender="M"),ObjUtil.defineReadonlyProps(this,{name:name,age:ageInYears,standardizedAge:standardizedAge,hasAge:!!standardizedAge||0===standardizedAge,gender:gender,standardizedGender:standardizedGender,hasGender:!!standardizedGender})}}])}(),angular.module("aprima-legacy-common").factory("AprimaAnalytics",["Bridge","$timeout","_",function(Bridge,$timeout,_){"use strict";var sendTiming=function(category,label,timingValue,page){$timeout(function(){Bridge.trackTiming(category,label,timingValue,page)},0)};function stopTiming(timing){timing.endTime=(new Date).getTime(),timing.value=moment(timing.endTime).diff(moment(timing.startTime),"millisecond"),sendTiming(timing.category,timing.label,timing.value,timing.page)}return{sendEvent:function(category,action,label,value){$timeout(function(){Bridge.trackEvent(category,action,label,value)},0)},sendTiming:sendTiming,sendPageView:function(location){$timeout(function(){Bridge.trackPageChange(location)},0)},sendException:function(message){$timeout(function(){Bridge.trackException(message)},0)},startTiming:function(page,category,label){var timing={startTime:(new Date).getTime(),page:page,label:label,category:category};return timing.stop=_.partial(stopTiming,timing),timing},stopTiming:stopTiming}}]),angular.module("aprima-legacy-common").factory("AprimaRestangular",["$log","$state","_","AppRoutes","Bridge","BrowserService","configuration","debugLogService","LocalStorageRepository","Restangular","TransitionManager",function($log,$state,_,AppRoutes,Bridge,BrowserService,configuration,debugLogService,LocalStorageRepository,Restangular,TransitionManager){"use strict";var alwaysIgnoreCache=!1,debugModeValue=LocalStorageRepository.getSupportedFeatures();return{get:function(endpointBase,options){return _.isString(endpointBase)||options||(options=endpointBase,endpointBase=null),options=_.defaults(options||{},{ignoreCache:BrowserService.isLegacyIE(),debugMode:!1}),Restangular.withConfig(function(RestangularConfigurer){var clientUrl=LocalStorageRepository.getClientURL();if(!clientUrl)throw new Error("Cannot send request (configuration error): empty ClientURL");var urlComponents=[clientUrl.replace(/\/$/,""),"api",endpointBase||"",configuration.SERVER_API_VERSION],baseUrl=_.filter(urlComponents,function(c){return!_.isNull(c)&&!_.isEmpty(c)}).join("/");RestangularConfigurer.setBaseUrl(baseUrl);var headers={"Auth-Token":LocalStorageRepository.getJsonWebToken(),ApiKey:configuration.API_KEY};options.ignoreCache&&(Bridge.fireEvent("clear-cache",{}),headers["Cache-Control"]="no-cache, no-store, must-revalidate",headers.Pragma="no-cache",headers.Expires=new Date),RestangularConfigurer.setDefaultHeaders(headers);var debugModeFeature=function(features){angular.isArray(features)||(features=[features]);var supportedFeatures=debugModeValue;return _.intersection(features,supportedFeatures).length===features.length}("DebuggerFeature");debugModeFeature?(RestangularConfigurer.addFullRequestInterceptor(function(element,operation,what,url,_5,parameters){return alwaysIgnoreCache&&operation.toLowerCase(),debugLogService.getDebugMode()?{params:_.assignIn(parameters,{t:(new Date).toJSON(),debug:!0,levels:"info,debug,fatal,warn,error"})}:element}),RestangularConfigurer.addResponseInterceptor(function(data,operation,what,url,response){return debugLogService.getDebugMode()&&($log.log("URL:",url),$log.log("WHAT:",what),$log.log("THE HEADERS ARE:",JSON.stringify(response.headers(),null,2))),data})):RestangularConfigurer.addFullRequestInterceptor(function(element,operation,what,url,_5,parameters){return alwaysIgnoreCache&&"get"===operation.toLowerCase()?{params:_.assignIn(parameters,{t:(new Date).toJSON()})}:element}),RestangularConfigurer.setErrorInterceptor(function(response){if(401===response.status){var deviceId=LocalStorageRepository.getDeviceId(),jwt=LocalStorageRepository.getJsonWebToken(),msg="User logged out by 401. Redirected to login. DeviceId="+deviceId+" JWT:"+(jwt=void 0===jwt?"undefined":jwt?jwt.length:'"falsy token"');$log.info(msg),Bridge.trackException(msg),$state.current.alternativeLoginRoute?TransitionManager.transition({appRoute:AppRoutes.statementslogin.state}):TransitionManager.transition({appRoute:AppRoutes.login.state})}else debugModeFeature&&200!==response.status&&debugLogService.getDebugMode()&&$log.log("THE EXCEPTION INFORMATION:",JSON.stringify(response.headers(),null,2));if(response.data&&response.data.ModelState){var errorCode=response.data.ModelState["commandResult-ErrorCode"];errorCode&&(response.errorCode=parseInt(errorCode))}return!0})})},getUrl:function(endpointBase,parent){var urlComponents=[LocalStorageRepository.getClientURL(),"api",endpointBase||"",configuration.SERVER_API_VERSION,parent];return[_.filter(urlComponents,function(c){return!_.isNull(c)&&!_.isEmpty(c)}).join("/"),{"Auth-Token":LocalStorageRepository.getJsonWebToken(),ApiKey:configuration.API_KEY}]},disableCaching:function(){alwaysIgnoreCache=!0}}}]),function(angular){"use strict";window.angular.module("aprima-legacy-common").factory("AuthorizationService",["CurrentUser","ServerInfoRepository",function(CurrentUser,ServerInfoRepository){return{isUserProvider:function(){if(ServerInfoRepository.isFeatureSupported("ProviderAuthorization")){var user=CurrentUser.get();return user.permissions&&("True"===user.permissions.IsProvider||!0===user.permissions.IsProvider)}return!0},icd10User:function(){var user=CurrentUser.get();return user.permissions&&("True"===user.permissions.ICD10User||!0===user.permissions.ICD10User)}}}])}(),angular.module("aprima-legacy-common").factory("CurrentUser",["LocalStorageRepository","TransitionManager","Bridge","LogOffService","$state","LogInService","$rootScope",function(LocalStorageRepository,TransitionManager,Bridge,LogOffService,$state,LogInService,$rootScope){"use strict";var previousTransition;return $rootScope.$on("TransitionActivated",function(evt,transition){previousTransition=transition}),Bridge.on("force-logoff-user",null,function(){LogInService.setRedirect(previousTransition),LogOffService.logoff().then(function(){TransitionManager.transition({appRoute:"login",opts:{replaceCurrentState:!0}})})}),{isAuthenticated:function(){return!!LocalStorageRepository.getJsonWebToken()},get:function(){return{name:LocalStorageRepository.getUserName(),fullName:LocalStorageRepository.getUserFullName(),userId:LocalStorageRepository.getUserID(),token:LocalStorageRepository.getJsonWebToken(),clientId:LocalStorageRepository.getClientID(),clientURL:LocalStorageRepository.getClientURL(),deviceId:LocalStorageRepository.getDeviceId(),permissions:LocalStorageRepository.getUserPermissions()}}}}]),angular.module("aprima-legacy-common").factory("DashboardStructure",["ServerInfoRepository","VersionService","CurrentUser","DeviceSettings","widgetViews","configuration",function(ServerInfoRepository,VersionService,CurrentUser,DeviceSettings,widgetViews,configuration){"use strict";function mapV1ConfigurationsToV2(configs){return _.map(configs,function(config){return{Id:config.Type,ExternalId:"",Name:config.Type,DisplayOrder:"All"===config.Type?0:1,PhoneTiles:mapTiles(config,1),TabletTiles:mapTiles(config,2),DesktopTiles:mapTiles(config,3)}});function mapTiles(config,numColumns){return _(config.WidgetDescriptors).filter(function(tile){return"header"!==tile.Name}).map(_.partialRight(mapTile,numColumns)).value()}function mapTile(tile,index,collection,numColumns){return{Id:tile.Id,TileDescriptorId:_.find(widgetViews,{name:tile.Name}).id,Name:tile.Name,Heading:tile.Heading,ColumnSpan:Math.min(DeviceSettings.isPhoneOrOverride||"dblCol"!==tile.Column?1:2,numColumns||2),IsCollapsed:"remarks"!==tile.Name,Filter:tile.Filter}}}return{get:function(numColumns){var routeSuffix="phone";switch(numColumns){case 1:routeSuffix="phone";break;case 2:routeSuffix="tablet";break;case 3:routeSuffix="desktop";break;case void 0:case null:routeSuffix="";break;default:throw new Error("Unsupported number of columns for dashboard configuration: "+numColumns)}return VersionService.checkVersionValid(ServerInfoRepository.getPrmAssemblyVersion(),configuration.MIN_PRM_DASHBOARD_VERSION)?{repositoryRoute:"settings/patient-dashboards/"+routeSuffix,mapFn:_.identity}:{repositoryRoute:"settings/patientdashboards/"+CurrentUser.get().userId,mapFn:mapV1ConfigurationsToV2}}}}]),angular.module("aprima-legacy-common").factory("DateUtilities",["_","moment","LanguageFactory",function(_,moment,LanguageFactory){"use strict";var words={years:{en_us:"Years",es_mx:"Años"},months:{en_us:"Months",es_mx:"Meses"},days:{en_us:"Days",es_mx:"Días"},weeks:{en_us:"Weeks",es_mx:"Semanas"},deceased:{en_us:"deceased at",es_mx:"fallecido en"}},lang=LanguageFactory.getLang();return{getPersonAge:_getPersonAge,displayAge:function(person,options){var ageString,langCode=lang.code.toLowerCase();if(!person||""===person.birthdate)return"";ageString=person.age+" "+person.units,person.deceased&&(ageString=words.deceased[langCode]+" "+ageString);if(options&&"age"===options.display)return ageString;if(options&&"birthdate"===options.display)return person.birthdate;return person.birthdate+" ("+ageString+")"},getDurationString:function(refDate){var diff=Date.parse(refDate)-new Date,msg=moment.duration(diff).humanize();return diff<0?msg+" ago":"in "+msg},getPersonAgeAbbr:function(birthDate,deathDate,unit){moment(birthDate,"MM/DD/YYYY").isValid()||(birthDate=moment(birthDate).format("L"));var ageInfo=_getPersonAge(birthDate,deathDate,unit);return ageInfo.age+""+ageInfo.units.charAt(0).toLowerCase()}};function _getPersonAge(birthDate,deathDate,unit){var end,years,months,days,weeks,_units="Years",_age=0,_deceased=!1,langCode=lang.code.toLowerCase(),birthDateMoment=birthDate;if(moment.locale(langCode),!moment(birthDate+"","MM/DD/YYYY").isValid())return{birthdate:"",age:0,units:words.years[langCode]};birthDateMoment=moment(birthDate,"MM/DD/YYYY");var tempDeathDate=moment(deathDate+"","MM/DD/YYYY");return tempDeathDate.isValid()?(end=tempDeathDate,_deceased=!0):end=moment(),years=end.diff(birthDateMoment,"years"),months=end.diff(birthDateMoment,"months"),days=end.diff(birthDateMoment,"days"),weeks=end.diff(birthDateMoment,"weeks"),_units=!unit&&days<14||"days"===unit?(_age=days,words.days[langCode]||"Days"):!unit&&months<2||"weeks"===unit?(_age=weeks,words.weeks[langCode]||"Weeks"):!unit&&years<2||"months"===unit?(_age=months,words.months[langCode]||"Months"):(_age=years,words.years[langCode]||"Years"),{birthdate:moment(birthDate,"MM/DD/YYYY").format("L"),deathdate:moment(deathDate,"MM/DD/YYYY").format("L"),age:_age,units:_units,deceased:_deceased}}}]),angular.module("aprima-legacy-common").factory("debugLogService",[function(){"use strict";var debugMode=!1;return{disableDebugMode:function(){debugMode=!1},enableDebugMode:function(){debugMode=!0},getDebugMode:function(){return debugMode}}}]),function(angular,Math){"use strict";var AdjustedForWeight=" (adjusted for patient's weight)";angular.module("aprima-legacy-common").factory("DoseRangeUtil",["_","NumUtil","StringBuilder","SystemGuid",function(_,NumUtil,StringBuilder,SystemGuid){return{createWeightBasedMaxMinInformation:function(weightBasedDoseRange){if(!weightBasedDoseRange)return"";var sb=StringBuilder.init();addDoseRange(sb,weightBasedDoseRange.LowDoseAmount,weightBasedDoseRange.LowDoseAmountUnits,weightBasedDoseRange.HighDoseAmount,weightBasedDoseRange.HighDoseAmountUnits),0<sb.Length&&sb.AppendLine();addDoseRange(sb,weightBasedDoseRange.LowDoseForm,weightBasedDoseRange.LowDoseFormUnits,weightBasedDoseRange.HighDoseForm,weightBasedDoseRange.HighDoseFormUnits),0<sb.Length&&sb.AppendLine();return addNTEInfo(sb,weightBasedDoseRange.NTEAmount,weightBasedDoseRange.NTEAmountUnits),addNTEInfo(sb,weightBasedDoseRange.NTEForm,weightBasedDoseRange.NTEFormUnits),function(sb,nte,nteUnits){sb&&0<nte&&(sb.Append("Single Dose NTE: "),sb.Append(numFormat(nte,"0.00")),nteUnits&&(sb.Append(" "),sb.Append(nteUnits)),sb.AppendLine())}(sb,weightBasedDoseRange.NTESingleDoseAmount,weightBasedDoseRange.NTESingleDoseAmountUnits),sb.ToString()},formatAgeInDays:formatAgeInDays,getWeightBasedSummary:getWeightBasedSummary,mapVariableDosingFromDto:function(variableDosingDto){if(!variableDosingDto)return null;var variableDosing={isDisabled:!1,minAge:variableDosingDto.MinAgeInDays,maxAge:variableDosingDto.MaxAgeInDays,defaultDosingQuantity:variableDosingDto.DefaultDosingQuantity,defaultMaximumDoseQuantity:variableDosingDto.DefaultMaximumDoseQuantity,variableDosingTypeId:variableDosingDto.VariableDosingTypeId,overrides:_.map(variableDosingDto.Overrides,function(override){return{minAge:override.MinAgeInDays,maxAge:override.MaxAgeInDays,overrideDosingQuantity:override.OverrideDosingQuantity,overrideMaximumDoseQuantity:override.OverrideMaximumDoseQuantity}}),calculationErrors:variableDosingDto.CalculationErrors},processedDosingType=processDosingType(variableDosing.variableDosingTypeId);return variableDosing.unitDescription=processedDosingType.dosingUnits,variableDosing.maxUnitDescription=processedDosingType.maxDoseUnits,variableDosing.summary=getWeightBasedSummary(variableDosing),variableDosing},mapVariableDosingToDto:function(variableDosing){return!variableDosing||variableDosing.isDisabled?null:{DefaultDosingQuantity:variableDosing.defaultDosingQuantity,DefaultMaximumDoseQuantity:variableDosing.defaultMaximumDoseQuantity,MaxAgeInDays:variableDosing.maxAge,MinAgeInDays:variableDosing.minAge,Overrides:_.map(variableDosing.overrides,function(override){return{MaxAgeInDays:override.maxAge,MinAgeInDays:override.minAge,OverrideDosingQuantity:override.overrideDosingQuantity,OverrideMaximumDoseQuantity:override.overrideMaximumDoseQuantity}}),VariableDosingTypeId:variableDosing.variableDosingTypeId}},processDoseRanges:function(variableDoseRanges){var variableDosingTypeId,weightBasedDoseRanges=variableDoseRanges.WeightBasedDoseRanges||[],minAge=365,maxAge=0;weightBasedDoseRanges.forEach(function(doseRange){var matches=doseRange.MaxMinInformation&&doseRange.MaxMinInformation.match(/\r\n/g),maxMinInformationRows=(matches||[]).length+1;doseRange.maxMinInformationRows=maxMinInformationRows,doseRange.MinAgeInDays<minAge&&(minAge=doseRange.MinAgeInDays),doseRange.MaxAgeInDays>maxAge&&(maxAge=doseRange.MaxAgeInDays),variableDosingTypeId=doseRange.VariableDosingTypeId});var processedDosingType=processDosingType(variableDosingTypeId);return{weightBasedDoseRanges:weightBasedDoseRanges,dosingUnits:processedDosingType.dosingUnits,maxAge:maxAge,maxDoseUnits:processedDosingType.maxDoseUnits,minAge:minAge,variableDosingTypeId:variableDosingTypeId}},GetMaxMinWarningMsg:function(drc,amount,frequencyPerDay,durationOfTherapyInDays){if(!drc)return"";if(drc.ErrorMsg&&-1===drc.ErrorMsg.indexOf("there is no dosing information supplied for this patient"))return drc.ErrorMsg;durationOfTherapyInDays=durationOfTherapyInDays||0;var dailyDose=function(drc,amount,frequencyPerDay){if(!drc)return 0;var dosingValue=0,dosePerDay=multiply(amount=amount||0,frequencyPerDay=frequencyPerDay||0),strength=0;0<=drc.IngredientStrength&&(strength=drc.IngredientStrength);dosingValue=isMilliliterUnitVolume(drc)?multiply(strength,divide(amount,drc.IngredientVolume)):multiply(strength,dosePerDay);return dosingValue}(drc,amount=amount||0,frequencyPerDay=frequencyPerDay||0);{if(0<drc.AdjustedLowDose&&dailyDose<drc.AdjustedLowDose)return"The dosing is less than the recommended daily dosing; "+fdbDosingInformation(drc);if(0<drc.AdjustedHighDose&&0<drc.AdjustedMaximumSingleDose&&dailyDose>drc.AdjustedHighDose&&dailyDose<drc.AdjustedMaximumSingleDose)return"The dosing is greater than the recommended daily dosing; "+fdbDosingInformation(drc);if(0<drc.AdjustedHighDose&&dailyDose>drc.AdjustedHighDose)return"The dosing is greater than the recommended daily dosing; "+fdbDosingInformation(drc);if(0<drc.AdjustedMaximumDosePerDay&&dailyDose>drc.AdjustedMaximumDosePerDay||0<drc.AdjustedNteAmountPerSingleDose&&dailyDose>drc.AdjustedNteAmountPerSingleDose)return"The dosing is greater than the recommended maximum single dose; "+fdbDosingInformation(drc);if(0<drc.LowFrequency&&drc.LowFrequency>frequencyPerDay)return"Prescribed frequency of administration per day is less than the recommended minimum frequency of administration range for the drug.  Please evaluate frequency.";if(0<drc.HighFrequency&&frequencyPerDay>drc.HighFrequency)return"Prescribed frequency of administration per day is greater than the recommended maximum frequency of administration for the drug.  Please evaluate frequency.";if(0<drc.LowDuration&&durationOfTherapyInDays<drc.LowDuration)return"Prescribed duration is less than the recommended low duration for the drug.";if(0<drc.HighDuration&&durationOfTherapyInDays>drc.HighDuration)return"Prescribed duration is greater than the highest recommended duration for the drug."}return""},CreateMaxMinInformation:function(drc){if(!drc)return"";var sb=StringBuilder.init();drc.ErrorMsg&&0<drc.ErrorMsg.length&&(sb.AppendLine(drc.ErrorMsg),sb.AppendLine(),sb.AppendLine());var doseLow=0,doseHigh=0,doseFormLow=0,doseFormHigh=0,doseUnit="",doseResult=function(drc){var result={doseLow:0,doseHigh:0};if(!drc)return result;0<=drc.RangeLowDose&&0<=drc.RangeHighDose&&(result.doseLow=drc.LowDose,result.doseHigh=drc.HighDose);drc.WeightRequired&&0<=drc.WeightKg&&(result.doseLow=multiply(result.doseLow,Math.max(1,drc.WeightKg)),result.doseHigh=multiply(result.doseHigh,Math.max(1,drc.WeightKg)));if(drc.BodySurfaceAreaRequired&&0<=drc.BodySurfaceArea){var bsa=drc.BodySurfaceArea;result.doseLow=divide(multiply(result.doseLow,bsa),1.73),result.doseHigh=divide(multiply(result.doseHigh,bsa),1.73)}return result}(drc);doseLow=doseResult.doseLow,doseHigh=doseResult.doseHigh;var formDoseResult=function(drc){var result={doseFormLow:0,doseFormHigh:0};if(!drc)return result;0<=drc.RangeLowDoseForm&&0<=drc.RangeHighDoseForm&&(result.doseFormLow=drc.RangeLowDoseForm,result.doseFormHigh=drc.RangeHighDoseForm);drc.WeightRequired&&0<=drc.WeightKg&&(result.doseFormLow=multiply(result.doseFormLow,Math.max(1,drc.WeightKg)),result.doseFormHigh=multiply(result.doseFormHigh,Math.max(1,drc.WeightKg)));if(drc.BodySurfaceAreaRequired&&0<=drc.BodySurfaceArea){var bsa=drc.BodySurfaceArea;result.doseFormLow=divide(multiply(result.doseFormLow,bsa),1.73),result.doseFormHigh=divide(multiply(result.doseFormHigh,bsa),1.73)}return result}(drc);doseFormLow=formDoseResult.doseFormLow,doseFormHigh=formDoseResult.doseFormHigh,0<doseLow&&0<doseHigh&&(sb.Append(fdbDosingInformation(drc)),sb.AppendLine(),sb.AppendLine(),doseUnit=drc.RangeLowDoseUnits?doseUnitOnly(doseUnit=drc.RangeLowDoseUnits):"",sb.Append("dose "),sb.Append(numFormat(doseLow,"[0].[00]")),sb.Append(" "),sb.Append(doseUnit),doseUnit=drc.RangeHighDoseUnits?doseUnitOnly(doseUnit=drc.RangeHighDoseUnits):"",sb.Append(" to "),sb.Append(numFormat(doseHigh,"[0].[00]")),sb.Append(" "),sb.Append(doseUnit),drc.WeightRequired&&sb.Append(AdjustedForWeight),drc.BodySurfaceAreaRequired&&sb.Append(" (adjusted for body surface area)"));0<doseFormLow&&0<doseFormHigh&&(doseUnit=drc.RangeLowDoseFormUnits?doseUnitOnly(doseUnit=drc.RangeLowDoseFormUnits):"",sb.AppendLine(),sb.Append("dose form "),sb.Append(numFormat(doseFormLow,"[0].[00]")),sb.Append(" "),sb.Append(doseUnit),doseUnit=drc.RangeHighDoseFormUnits?doseUnitOnly(doseUnit=drc.RangeHighDoseFormUnits):"",sb.Append(" to "),sb.Append(numFormat(doseFormHigh,"[0].[00]")),sb.Append(" "),sb.Append(doseUnit),drc.WeightRequired&&sb.Append(AdjustedForWeight),drc.BodySurfaceAreaRequired&&sb.Append(" (adjusted for body surface area)"));return sb.ToString()},CalculateDosingInformation:function(drc,frequencyPerDay,mg){if(!drc)return"";if(frequencyPerDay=frequencyPerDay||0,0<(mg=mg||0))return isMilliliterUnitVolume(drc)?function(drc,frequencyPerDay,mg){if(!drc)return"";frequencyPerDay=frequencyPerDay||0,mg=mg||0;var sb=StringBuilder.init();drc.WeightRequired&&0<=drc.WeightKg&&(sb.Append(numFormat(multiply(mg,drc.WeightKg),"0.0")),sb.Append(" mg "),sb.AppendLine(AdjustedForWeight),sb.AppendLine());if(0<mg&&0<drc.IngredientVolume&&0<drc.IngredientStrength){var ml=divide(drc.IngredientVolume,drc.IngredientStrength),totalML=0;totalML=drc.WeightRequired&&0<=drc.WeightKg?multiply(ml,mg,drc.WeightKg):multiply(ml,mg),sb.Append(function(drc,frequencyPerDay,dose){var sb=StringBuilder.init();if(frequencyPerDay=frequencyPerDay||0,dose=dose||0,isMilliliterUnitVolume(drc)){var timesPerDay=frequencyPerDay;0===frequencyPerDay&&(sb.AppendLine("Cannot calculate a single dose without a frequency."),timesPerDay=1);var convertDose=_.round(divide(dose,timesPerDay),1);0!==convertDose&&(sb.AppendLine(),sb.Append("Milliliter(s) "),0<frequencyPerDay?(sb.Append("single dose "),sb.Append(numFormat(convertDose,"[0].[0]"))):(sb.Append("per day "),sb.Append(numFormat(multiply(convertDose,timesPerDay),"[0].[0]"))))}return sb.ToString()}(drc,frequencyPerDay,totalML)),sb.AppendLine(),sb.Append("Daily total ml: "),sb.Append(numFormat(totalML,"0.0")),drc.WeightRequired?sb.Append(" = (("):sb.Append(" = ("),sb.Append(numFormat(ml,"0.0[000]")),sb.Append(" (ml per mg) * "),sb.Append(numFormat(mg,"0.0")),drc.WeightRequired?(sb.Append(") * "),sb.Append(numFormat(drc.WeightKg||0,"0.000")),sb.Append("(kg))")):sb.Append(")")}return sb.ToString()}(drc,frequencyPerDay,mg):function(drc,mg){if(!drc)return"";mg=mg||0;var sb=StringBuilder.init(),bsa=0,adjustedMG=mg,strength=0;0<=drc.IngredientStrength&&(strength=drc.IngredientStrength);drc.WeightRequired?(adjustedMG=multiply(mg,drc.WeightKg||0),sb.Append(numFormat(adjustedMG,"0.0")),sb.Append(" mg "),sb.AppendLine(AdjustedForWeight),sb.AppendLine()):drc.BodySurfaceAreaRequired&&0<=drc.BodySurfaceArea&&(bsa=drc.BodySurfaceArea,adjustedMG=divide(multiply(bsa,mg),1.73),sb.Append(numFormat(adjustedMG,"0.0")),sb.Append(" mg "),sb.AppendLine(" (adjusted for body surface area)"),sb.AppendLine());sb.Append(function(mg,strength){mg=mg||0,strength=strength||0;var sb=StringBuilder.init(),convertDose=Math.floor(mg);0!==convertDose&&(sb.Append("Milligram(s) "),sb.Append("single dose "),sb.Append(numFormat(convertDose,"[0]")));var dose,num1,num2,result,remainder,formatted=(dose=divide(convertDose=_.round(mg,3),strength),result="",num1=dose=dose||0,num2=Math.trunc(dose),.499<(remainder=NumUtil.subtract(num1,num2))&&remainder<.999&&(result=" 1/2"),result=numFormat(Math.trunc(dose),"[0]")+result);return formatted&&(sb.AppendLine(),sb.Append("Each "),sb.Append("single dose "),sb.Append(formatted)),sb.ToString()}(adjustedMG,strength)),drc.WeightRequired?(sb.AppendLine(),sb.AppendLine(),sb.Append("Single dose mg: "),sb.Append(numFormat(adjustedMG,"0.0")),sb.Append(" = ("),sb.Append(numFormat(mg,"0.0")),sb.Append("(mg) * "),sb.Append(numFormat(drc.WeightKg||0,"0.000")),sb.Append("(kg))")):drc.BodySurfaceAreaRequired&&(sb.AppendLine(),sb.AppendLine(),sb.Append("Single pediatric dose mg: "),sb.Append(numFormat(adjustedMG,"0.0")),sb.Append(" = (("),sb.Append(numFormat(bsa,"0.0[000]")),sb.Append(" (bsa m2) * "),sb.Append(numFormat(mg,"0.0")),sb.Append(" (adult dose mg)"),sb.AppendLine(") / 1.73)"),sb.AppendLine(),sb.Append("Body Surface Area is calculated using the 'DuBois and DuBois 2' formula."));return sb.ToString()}(drc,mg);return""},allowsBsaAdjustment:function(drc,patientAgeInDays){return!!drc&&(patientAgeInDays=patientAgeInDays||0,drc.BodySurfaceAreaRequired||patientAgeInDays<=6569&&drc.WeightRequired&&canCalculateByMg(drc))},canCalculateByMg:canCalculateByMg};function canCalculateByMg(drc){var strengthUomAbbr=drc&&drc.IngredientStrengthUomAbbr;if(!strengthUomAbbr)return!1;var isMg="mg"===strengthUomAbbr.toLowerCase();return isMg}function formatAgeInDays(ageInDays){return ageInDays<60?numFormat(ageInDays/7,"0")+" weeks":ageInDays<730?numFormat(ageInDays/30.5,"0")+" months":numFormat(ageInDays/365,"0")+" years"}function getWeightBasedSummary(weightBasedDosing){var sb=StringBuilder.init();return 0<weightBasedDosing.minAge&&(sb.Append("Age "),sb.Append(formatAgeInDays(0)),sb.Append(" - "),sb.AppendLine(formatAgeInDays(weightBasedDosing.minAge-1)),sb.AppendLine("  Manual Input Required")),weightBasedDosing.overrides.forEach(function(doseRange){sb.AppendLine(),sb.Append("Age "),sb.Append(formatAgeInDays(doseRange.minAge)),sb.Append(" - "),sb.AppendLine(formatAgeInDays(doseRange.maxAge)),sb.Append("  "),sb.Append(doseRange.overrideDosingQuantity?doseRange.overrideDosingQuantity:weightBasedDosing.defaultDosingQuantity),sb.Append(" "),sb.Append(weightBasedDosing.unitDescription);var maxDose=doseRange.overrideMaximumDoseQuantity?doseRange.overrideMaximumDoseQuantity:weightBasedDosing.defaultMaximumDoseQuantity;maxDose&&(sb.AppendLine(),sb.Append("  Maximum Dose "),sb.Append(maxDose),sb.Append(" "),sb.Append(weightBasedDosing.maxUnitDescription)),sb.AppendLine()}),sb.AppendLine(),sb.Append("Age "),sb.Append(formatAgeInDays(weightBasedDosing.maxAge+1)),sb.AppendLine(" and older"),sb.Append("  Manual Input Required"),sb.ToString()}function processDosingType(variableDosingTypeId){var dosingUnits,maxDoseUnits;switch(variableDosingTypeId){case SystemGuid.DosingCalculatorUnitGPerKgPerDay:dosingUnits="g/kg/day",maxDoseUnits="g";break;case SystemGuid.DosingCalculatorUnitMcgPerKgPerDay:dosingUnits="mcg/kg/day",maxDoseUnits="mcg";break;case SystemGuid.DosingCalculatorUnitMgPerKgPerDay:dosingUnits="mg/kg/day",maxDoseUnits="mg";break;case SystemGuid.DosingCalculatorUnitMlPerKgPerDay:dosingUnits="mL/kg/day",maxDoseUnits="mL"}return{dosingUnits:dosingUnits,maxDoseUnits:maxDoseUnits}}function isMilliliterUnitVolume(drc){return!!drc&&!!(drc.IngredientVolumeUomAbbr&&"ml"===drc.IngredientVolumeUomAbbr.toLowerCase()&&0<drc.IngredientVolume)}function addDoseRange(sb,low,lowUnits,high,highUnits){sb&&0<low&&0<high&&(sb.Append(numFormat(low,"0.00")),lowUnits&&(sb.Append(" "),sb.Append(lowUnits)),sb.Append(" - "),sb.Append(numFormat(high,"0.00")),highUnits&&(sb.Append(" "),sb.Append(highUnits)))}function addNTEInfo(sb,nte,nteUnits){sb&&0<nte&&(sb.Append("NTE: "),sb.Append(numFormat(nte,"0.00")),nteUnits&&(sb.Append(" "),sb.Append(nteUnits)),sb.AppendLine())}function doseFormRange(drc,sb){drc&&sb&&addDoseRange(sb,drc.RangeLowDoseForm,drc.RangeLowDoseFormUnits,drc.RangeHighDoseForm,drc.RangeHighDoseFormUnits)}function doseRange(drc,sb){drc&&sb&&addDoseRange(sb,drc.RangeLowDose,drc.RangeLowDoseUnits,drc.RangeHighDose,drc.RangeHighDoseUnits)}function fdbDosingInformation(drc){var sb=StringBuilder.init();return isMilliliterUnitVolume(drc)?(doseFormRange(drc,sb),0<sb.Length&&sb.Append("; "),doseRange(drc,sb)):(doseRange(drc,sb),0<sb.Length&&sb.Append("; "),doseFormRange(drc,sb)),sb.ToString()}function doseUnitOnly(doseUnit){if(!doseUnit)return doseUnit;var len=doseUnit.indexOf("/");return 0<len&&(doseUnit=doseUnit.substr(0,len)),doseUnit}function multiply(){var result=NumUtil.multiply.apply(null,arguments);return result}function divide(num1,num2){var result=NumUtil.divide(num1,num2);return result}function numFormat(num,format){var result=NumUtil.format(num,format);return result}}])}(window.angular,window.Math),function(angular){"use strict";window.angular.module("aprima-legacy-common").factory("ErrorService",["_","aprgettext","RequestTypes","toaster",function(_,gettext,RequestTypes,toaster){return{convertToErrorMessages:convertToErrorMessages,displayErrorMessages:function(error,asHtml){var errors=_.isArray(error)?error:convertToErrorMessages(error);return errors.forEach(function(err){toaster.pop({type:"error",title:"",body:err,bodyOutputType:asHtml?"trustedHtml":""})}),errors},addHttpErrorToScope:function(scope,httpResponse,messages,type){var error={type:type||RequestTypes.default},key="is"+httpResponse.status;error[key]=!0,error.reason=messages&&messages[key],403===httpResponse.status?error.responseMessage=httpResponse.headers()["reason-phrase"]:error.unhandled=!0;return error.reason=error.reason||error.responseMessage,scope.httpError=error},removeHttpErrorFromScope:function(scope,type){scope.hasOwnProperty("httpError")&&scope.httpError&&(!type&&scope.httpError.type===RequestTypes.default||scope.httpError.type===type)&&(scope.httpError=null)}};function convertToErrorMessages(error){var errors=[];if(!error)return errors.push(getGenericError()),errors;if(_.isString(error))return errors.push(error),errors;var modelState=error.data&&error.data.ModelState||error.ModelState;if(modelState&&(_(modelState).flatMap(function(value){return value||[]}).forEach(function(err){errors.push(gettext(err))}),errors.length))return errors;var validationResult=error.data&&error.data.ValidationResult||error.ValidationResult;if(validationResult&&!validationResult.IsValid&&(_(validationResult.Errors).forEach(function(err){errors.push(gettext(err.ErrorMessage))}),errors.length))return errors;if(error.status&&error.statusText)errors.push(gettext("An error has occurred. Status: "+error.status+": "+error.statusText));else{var genericError=getGenericError();error.Message&&(genericError+=" "+error.Message),errors.push(genericError)}return errors}function getGenericError(){return gettext("An error has occurred and the process cannot be completed.")}}])}(),angular.module("aprima-legacy-common").factory("LanguageFactory",["gettextCatalog","LocalStorageRepository","TranslateService",function(gettextCatalog,LocalStorageRepository,TranslateService){"use strict";var currentLang={code:gettextCatalog.currentLanguage},langOptions=[{name:"English",id:"en_US"},{name:"Spanish",id:"es_MX"}];function normalizeToUnderscore(language){return language?language.replace("-","_"):language}function updateCurrentLangCode(code){gettextCatalog.currentLanguage=normalizeToUnderscore(code),currentLang.code=code,TranslateService.use(currentLang.code)}function getLang(){return updateCurrentLangCode(currentLang.code?normalizeToUnderscore(currentLang.code):"en_US"),currentLang}return{setLang:function(language){updateCurrentLangCode(language),LocalStorageRepository.setLang(gettextCatalog.currentLanguage)},getLang:getLang,getLangOptions:langOptions,getActiveLanguage:function(){return _.find(langOptions,{id:getLang().code})}}}]),angular.module("aprima-legacy-common").factory("ListNavigationService",["$log","$filter","Bridge",function($log,$filter,Bridge){"use strict";var cachedEnumerators=[],activeItems=[];return{buildAndCacheEnumerator:function(enumeratorName,list,orderPredicate,transitionFunction){var filter=$filter("orderBy"),enumerator=this.buildEnumerator(filter(list,orderPredicate),transitionFunction);return cachedEnumerators[enumeratorName]=enumerator,activeItems[enumeratorName]&&enumerator.setActiveItemById(activeItems[enumeratorName]),enumerator},getEnumerator:function(enumeratorName){return cachedEnumerators[enumeratorName]},buildEnumerator:function(list,callbackFunction){$log.info("enumerator built");var currentIndex=-1,transitionFunction=function(item){currentIndex=list.indexOf(item),callbackFunction&&callbackFunction(item)},next=function(){var lookupIndex;if(-1!==currentIndex){if(currentIndex===list.length-1)return null;lookupIndex=currentIndex+1}else{if(0===list.length)return null;lookupIndex=0}return list[lookupIndex]},canGoNext=function(){return-1!==currentIndex&&currentIndex!==list.length-1},currentItem=function(){return-1!==currentIndex?list[currentIndex]:null};return{next:next,previous:function(){var lookupIndex;if(-1!==currentIndex){if(0===currentIndex)return null;lookupIndex=currentIndex-1}else{if(0===list.length)return null;lookupIndex=list.length-1}return list[lookupIndex]},first:function(){return 0===list.length?null:list[0]},last:function(){return 0===list.length?null:list[list.length-1]},moveToNextItem:function(){var next=this.next();next&&transitionFunction(next)},moveToPreviousItem:function(){var previous=this.previous();previous&&transitionFunction(previous)},moveToFirstItem:function(){transitionFunction(this.first())},moveToLastItem:function(){transitionFunction(this.last())},moveToItem:function(item){var indexOf=list.indexOf(item);if(!(0<=indexOf))throw new Exception("Cannot move to item as it does not exist in the list.");currentIndex=indexOf,transitionFunction(item)},canGoNext:canGoNext,canGoPrevious:function(){return-1!==currentIndex&&0!==currentIndex},getNavStatus:function(){return{canGoForward:this.canGoNext(),canGoBack:this.canGoPrevious()}},setActiveItemById:function(id){for(var i=0;i<=list.length-1;i++)if(list[i].Id===id){currentIndex=i;break}},currentItem:currentItem,toArray:function(){var oldIndex=currentIndex,arr=[];for(currentIndex=0,currentItem()&&arr.push(currentItem());canGoNext();)arr.push(next()),currentIndex++;return currentIndex=oldIndex,arr}}},hydrateListNavigationProperties:function(enumeratorName,settings){var enumerator=cachedEnumerators[enumeratorName];enumerator&&(angular.forEach(settings.phone.modes,function(value){angular.forEach(value.headers,function(headerValue){headerValue.requiresNavSettings&&(headerValue.listNavigationProperties=enumerator.getNavStatus())})}),angular.forEach(settings.tablet.modes,function(value){angular.forEach(value.headers,function(headerValue){headerValue.requiresNavSettings&&(headerValue.listNavigationProperties=enumerator.getNavStatus())})}))},setAsBridgeHandler:function(enumeratorName,$scope){var enumerator=cachedEnumerators[enumeratorName];enumerator&&Bridge.on("navigate-item",$scope,function(data){switch(data.navigationType){case"next":enumerator.moveToNextItem();break;case"previous":enumerator.moveToPreviousItem()}})},registerActiveItemForList:function(listType,itemId,settings,$scope){var enumerator=this.getEnumerator(listType);enumerator&&(enumerator.setActiveItemById(itemId),this.hydrateListNavigationProperties(listType,settings),this.setAsBridgeHandler(listType,$scope)),activeItems[listType]=itemId},deregisterActiveItemForList:function(listType,itemId){activeItems[listType]&&activeItems[listType]===itemId&&(activeItems[listType]=null)},setActiveItemByIdForEnumerator:function(enumeratorName,id){var enumerator=cachedEnumerators[enumeratorName];enumerator&&enumerator.setActiveItemById(id)}}}]),angular.module("aprima-legacy-common").factory("LocalStorageRepository",["storage","_","WebCommonStorageRepository",function(storage,_,WebCommonStorageRepository){"use strict";var trueRegex=/^true$/i,falseRegex=/^false$/i,overwritePropertiesAndSave=function(destinationGetter,source,storageKey){var destination=destinationGetter()||{};destination=_.assign(destination,source),storage.set(storageKey,destination)},defaultPropertiesAndSave=function(destinationGetter,source,storageKey){var destination=destinationGetter()||{};destination=_.defaults(destination,source),storage.set(storageKey,destination)};function getPatientDashboardsKey(type){var key="patientDashboardConfigurations";return angular.isNumber(type)&&(type+="cols"),type&&(key+="."+type),key}return{clearAll:function(){WebCommonStorageRepository.clearAll()},getIsActiveDirectoryUser:function(){return storage.get("activeDirectoryUser")},setIsActiveDirectoryUser:function(value){storage.set("activeDirectoryUser",value)},getClientID:function(){return WebCommonStorageRepository.getClientId()},setClientID:function(value){WebCommonStorageRepository.setClientId(value)},getNotificationTimeout:function(){return storage.get("notificationTimeout")},setNotificationTimeout:function(value){storage.set("notificationTimeout",value)},getClientURL:function(){return WebCommonStorageRepository.getClientUrl()},setClientURL:function(value){WebCommonStorageRepository.setClientUrl(value)},getGatewayUrl:function(){return storage.get("gatewayUrl")},setGatewayUrl:function(value){storage.set("gatewayUrl",value)},setJsonWebToken:function(jwt){WebCommonStorageRepository.setJsonWebToken(jwt)},getJsonWebToken:function(){return WebCommonStorageRepository.getJsonWebToken()},removeJsonWebToken:function(){WebCommonStorageRepository.removeJsonWebToken()},setUserName:function(username){storage.set("userName",username)},getUserName:function(){return storage.get("userName")},setBirthDate:function(birthDate){storage.set("birthDate",birthDate)},getBirthDate:function(){return storage.get("birthDate")},setAccessCode:function(statementId){storage.set("accessCode",statementId)},getAccessCode:function(){return storage.get("accessCode")},setUserFullName:function(name){storage.set("userFullName",name)},getUserFullName:function(){return storage.get("userFullName")},removeUserName:function(){storage.remove("userName")},setUserID:function(userid){WebCommonStorageRepository.setUserId(userid)},getUserID:function(){return WebCommonStorageRepository.getUserId()},getIsPatient:function(){return storage.get("isPatient")},setIsPatient:function(isPatient){storage.set("isPatient",isPatient)},getSupportedFeatures:function(){return storage.get("apiSupportedFeatures")},removeUserID:function(){storage.remove("userId")},setLang:function(lang){storage.set("lang",lang)},getLang:function(){return storage.get("lang")},setDefaultSuperbillSubmissionMethod:function(methodId){storage.set("superbillMethod",methodId)},getDefaultSuperbillSubmissionMethod:function(){return storage.get("superbillMethod")},setKey:function(key,value,keyType){if(storage.set(key,value),keyType){var keyDictionary,activeKeys=storage.get(keyType+"keys");keyDictionary=activeKeys?activeKeys.split(","):[],_.includes(keyDictionary,key)||(keyDictionary.push(key),storage.set(keyType+"keys",keyDictionary.join(",")))}},getKey:function(key,keyType){var k=storage.get(key);if(keyType){var keyDictionary,activeKeys=storage.get(keyType+"keys");keyDictionary=activeKeys?activeKeys.split(","):[],_.includes(keyDictionary,key)||(keyDictionary.push(key),storage.set(keyType+"keys",keyDictionary.join(",")))}return k},removeKey:function(key){storage.remove(key)},setPatientDashboardWidgets:function(widget){storage.set("patientDashboardWidgets",widget)},getPatientDashboardWidgets:function(){return storage.get("patientDashboardWidgets")},setPatientDashboardConfigurations:function(newList,type){var list=this.getPatientDashboardConfigurations(type)||[],hasV1Tiles=_.some(list,function(val){return!_.isUndefined(val.WidgetDescriptors)});_.isEmpty(list)||hasV1Tiles||_.forEach(newList,function(val){val.Tiles=_.map(val.Tiles,function(tile){var savedConfig=_(list).find({Id:val.Id});if(savedConfig){var savedTile=_(savedConfig.Tiles).find({Id:tile.Id});if(savedTile)return _.defaults(tile,savedTile)}return tile})}),storage.set(getPatientDashboardsKey(type),newList)},removePatientDashboardWidgets:function(){storage.remove("patientDashboardWidgets")},overwritePatientDashboardConfigurations:function(newList,type){storage.set(getPatientDashboardsKey(type),newList)},getPatientDashboardConfigurations:function(type){return storage.get(getPatientDashboardsKey(type))},removePatientDashboardConfigurations:function(type){storage.remove(getPatientDashboardsKey(type))},getDashboardTileSettings:function(){return storage.get("settings.dashboard.tiles")},setDashboardTileSettings:function(settings){return overwritePropertiesAndSave(this.getDashboardTileSettings,settings,"settings.dashboard.tiles")},setDefaultDashboardTileSettings:function(settings){return defaultPropertiesAndSave(this.getDashboardTileSettings,settings,"settings.dashboard.tiles")},getAppointmentsListSettings:function(){return storage.get("settings.appointmentslist")},setAppointmentsListSettings:function(settings){return overwritePropertiesAndSave(this.getAppointmentsListSettings,settings,"settings.appointmentslist")},setDefaultAppointmentsListSettings:function(settings){return defaultPropertiesAndSave(this.getAppointmentsListSettings,settings,"settings.appointmentslist")},getMessagesListSettings:function(){return storage.get("settings.messageslist")},setMessagesListSettings:function(settings){return overwritePropertiesAndSave(this.getMessagesListSettings,settings,"settings.messageslist")},setDefaultMessagesListSettings:function(settings){var messageSettings=this.getMessagesListSettings();return messageSettings&&messageSettings.messageFilterId?storage.set("settings.messageslist",settings):defaultPropertiesAndSave(this.getMessagesListSettings,settings,"settings.messageslist")},getAppointmentsBadgeSettings:function(){return storage.get("settings.appointments.badge.settings")},setAppointmentsBadgeSettings:function(settings){return overwritePropertiesAndSave(this.getAppointmentsBadgeSettings,settings,"settings.appointments.badge.settings")},setDefaultAppointmentsBadgeSettings:function(settings){return defaultPropertiesAndSave(this.getAppointmentsBadgeSettings,settings,"settings.appointments.badge.settings")},getDefaultServiceSiteId:function(){return storage.get("serviceSiteId")},setDefaultServiceSiteId:function(serviceSiteId){storage.set("serviceSiteId",serviceSiteId)},getDeviceId:function(){return storage.get("deviceId")},setDeviceId:function(deviceId){storage.set("deviceId",deviceId)},getPhoneMessageGeneralNoteTypeId:function(){return storage.get("settings.phoneMessageGeneralNoteTypeId")},setPhoneMessageGeneralNoteTypeId:function(id){storage.set("settings.phoneMessageGeneralNoteTypeId",id)},getTaskMessageGeneralNoteTypeId:function(){return storage.get("settings.taskMessageGeneralNoteTypeId")},setTaskMessageGeneralNoteTypeId:function(id){storage.set("settings.taskMessageGeneralNoteTypeId",id)},getPharmacyGeneralNoteTypeId:function(){return storage.get("settings.pharmacyGeneralNoteTypeId")},setPharmacyGeneralNoteTypeId:function(id){storage.set("settings.pharmacyGeneralNoteTypeId",id)},getPortalMessageGeneralNoteTypeId:function(){return storage.get("settings.portalMessageGeneralNoteTypeId")},setPortalMessageGeneralNoteTypeId:function(id){storage.set("settings.portalMessageGeneralNoteTypeId",id)},getRxRefillMessageGeneralNoteTypeId:function(){return storage.get("settings.rxRefillMessageGeneralNoteTypeId")},setRxRefillMessageGeneralNoteTypeId:function(id){storage.set("settings.rxRefillMessageGeneralNoteTypeId",id)},getPharmacyRefillMessageGeneralNoteTypeId:function(){return storage.get("settings.pharmacyRefillMessageGeneralNoteTypeId")},setPharmacyRefillMessageGeneralNoteTypeId:function(id){storage.set("settings.pharmacyRefillMessageGeneralNoteTypeId",id)},getPatientVitalsDefaultSettingId:function(){return storage.get("settings.patientVitalsDefaultSettingId")},setPatientVitalsDefaultSettingId:function(id){storage.set("settings.patientVitalsDefaultSettingId",id)},getMedicationOverrideGeneralNoteTypeId:function(){return storage.get("settings.medicationOverrideGeneralNoteTypeId")},setMedicationOverrideGeneralNoteTypeId:function(id){storage.set("settings.medicationOverrideGeneralNoteTypeId",id)},getCurrentUserLicenses:function(){return storage.get("settings.currentUserLicenses")},setCurrentUserLicenses:function(licenses){storage.set("settings.currentUserLicenses",licenses)},getIsERxEnabled:function(){return storage.get("settings.erxenabled")},setIsERxEnabled:function(enabled){storage.set("settings.erxenabled",!!enabled)},getAllowImperialUnits:function(){return storage.get("settings.allowImperialUnitsInPrescription")},setAllowImperialUnits:function(allowed){storage.set("settings.allowImperialUnitsInPrescription",!!allowed)},getApplicationVersion:function(){return storage.get("applicationVersion")},setApplicationVersion:function(version){storage.set("applicationVersion",version)},getUserPermissions:function(){return storage.get("userPermissions")},setUserPermissions:function(permissions){permissions=function(permissions){var permissionObj=permissions||{};for(var prop in permissionObj)trueRegex.test(permissionObj[prop])?permissionObj[prop]=!0:falseRegex.test(permissionObj[prop])&&(permissionObj[prop]=!1);return permissionObj}(permissions),storage.set("userPermissions",permissions)},getAskedUserForTouchID:function(){return storage.get("askedUserForTouchID")},setAskedUserForTouchID:function(prompt){storage.set("askedUserForTouchID",prompt)},getUserEnabledTouchID:function(){return storage.get("userEnabledTouchID")},setUserEnabledTouchID:function(enabled){storage.set("userEnabledTouchID",enabled)},getOncePerLoginChartConsent:function(){return storage.get("OncePerLoginChartConsent")},setOncePerLoginChartConsent:function(enabled){storage.set("OncePerLoginChartConsent",enabled)},clearKeysOfType:function(keyType){var activeKeys=storage.get(keyType+"keys");if(activeKeys){var keyDictionary=activeKeys.split(",");_.forEach(keyDictionary,function(key){storage.remove(key)})}storage.remove(keyType+"keys")},clearSessionStorage:function(){clearKeysOfType("list"),clearKeysOfType("metadata")},clearOldVersionCache:function(){storage.remove("messagetypessupportedforcreate")}}}]),angular.module("aprima-legacy-common").factory("LogInService",["DeviceSettings",function(DeviceSettings){"use strict";var redirectState,redirectParams,isCustomRedirect,customTransition;function setDefaultRedirect(){isCustomRedirect=!1,redirectState=DeviceSettings.isDevice?"dashboard":"landing",redirectParams=null}return setDefaultRedirect(),{getRedirect:function(){if(isCustomRedirect)return customTransition;var redirect={appRoute:redirectState,opts:redirectParams||{}};return redirect.opts.replaceCurrentState=!0,redirect},setDefaultRedirect:setDefaultRedirect,setRedirect:function(transition){isCustomRedirect=!0,(customTransition=transition).opts.replaceCurrentState=!0}}}]),angular.module("aprima-legacy-common").factory("LogOffService",["AprimaAnalytics","Bridge","LocalStorageRepository","$q",function(AprimaAnalytics,Bridge,LocalStorageRepository,$q){"use strict";return{logoff:function(){return LocalStorageRepository.removeJsonWebToken(),LocalStorageRepository.removeUserID(),AprimaAnalytics.sendEvent("user","click","logoff",0),Bridge.logoff("logoff"),$q.when()}}}]),angular.module("aprima-legacy-common").factory("AppointmentTransitionToHelper",["apFilterFeatureFilter","AppointmentScheduleTypes",function(apFilterFeature,AppointmentScheduleTypes){"use strict";var routes={};return routes[AppointmentScheduleTypes.PatientVisit.id]={view:"appointment",edit:"editAppointment",add:"addAppointment",requiredFeature:AppointmentScheduleTypes.PatientVisit.requiredFeature},routes[AppointmentScheduleTypes.GroupVisit.id]={view:"groupAppointment",edit:"editGroupAppointment",add:"addGroupAppointment",requiredFeature:AppointmentScheduleTypes.GroupVisit.requiredFeature},routes[AppointmentScheduleTypes.Event.id]={view:"eventAppointment",edit:"editEventAppointment",add:"addEventAppointment",requiredFeature:AppointmentScheduleTypes.Event.requiredFeature},routes[AppointmentScheduleTypes.BlockingEvent.id]={view:"blockingEventAppointment",edit:"editBlockingEventAppointment",add:"addBlockingEventAppointment",requiredFeature:AppointmentScheduleTypes.BlockingEvent.requiredFeature},{getTransition:function(apptScheduleType,patientId,calendarId,edit,apptId){if(!apptScheduleType)return!1;var filteredRoutes=apFilterFeature(routes,"requiredFeature"),transition={opts:{}},lowerScheduleType=apptScheduleType.toLowerCase();if(apptId){transition.opts.id=apptId;var property=edit?"edit":"view";transition.appRoute=filteredRoutes[lowerScheduleType]&&filteredRoutes[lowerScheduleType][property]||filteredRoutes[AppointmentScheduleTypes.PatientVisit.id][property]}else transition.appRoute=filteredRoutes[lowerScheduleType]&&filteredRoutes[lowerScheduleType].add||filteredRoutes[AppointmentScheduleTypes.PatientVisit.id].add;return patientId&&(transition.opts.patientid=patientId),calendarId&&(transition.opts.calendarId=calendarId),transition}}}]),angular.module("aprima-legacy-common").provider("AppRoutes",["_",function(_){"use strict";var appRoutes={getAppRoutes:getAppRoutes,setupAppRoutes:setupAppRoutes};function setupAppRoutes(newAppRoutes){_.defaults(appRoutes,newAppRoutes)}function getAppRoutes(){return appRoutes}this.setupAppRoutes=setupAppRoutes,this.getAppRoutes=getAppRoutes,this.$get=[function(){return getAppRoutes()}]}]),angular.module("aprima-legacy-common").factory("BrowserWebViewManager",["$window","$state",function($window,$state){"use strict";return{activateView:function(appRoute,transition){var opts=transition.opts;return opts.replaceCurrentState&&!0===opts.replaceCurrentState?$state.go(appRoute.state,opts,{location:"replace"}):$state.go(appRoute.state,opts),!0},goBack:function(){$window.history.back()}}}]),angular.module("aprima-legacy-common").factory("MessageTransitionToHelper",["MessageTypes","_","apFilterFeatureFilter",function(MessageTypes,_,apFilterFeature){"use strict";var routes={};return routes[MessageTypes.PhoneMessageGuid]={route:"phonemessage"},routes[MessageTypes.TaskMessageGuid]={route:"taskmessage"},routes[MessageTypes.LabMessageGuid]={route:"labmessage"},routes[MessageTypes.PortalAppointmentQuestionMessageGuid]={route:"portalmessage"},routes[MessageTypes.PortalBillingQuestionMessageGuid]={route:"portalmessage"},routes[MessageTypes.PortalDemographicsQuestionMessageGuid]={route:"portalmessage"},routes[MessageTypes.PortalGeneralQuestionMessageGuid]={route:"portalmessage"},routes[MessageTypes.PortalRxQuestionMessageGuid]={route:"portalmessage"},routes[MessageTypes.AttachmentApprovalGuid]={route:"aamessage"},routes[MessageTypes.ServiceOrderApprovalMessageGuid]={route:"serviceorderapprovalmessage"},routes[MessageTypes.RxRefillRequestMessageGuid]={route:"rxrefillmessage",requiredFeature:"Messages_RxRefill,Visits_RX"},routes[MessageTypes.PatientRxRefillRequestMessageGuid]={route:"rxrefillmessage",requiredFeature:"Messages_RxRefill,Visits_RX"},routes[MessageTypes.PharmacyRefillRequestMessageGuid]={route:"pharmacyrefillmessage",requiredFeature:"Messages_PharmacyRefill,Visits_RX"},{getTransitionForMessage:function(messageTypeId,messageId,messageSubTypeId,createNew,options){var transition={appRoute:"message",opts:{id:messageId}};options&&_.merge(transition.opts,options);var lowerMessageTypeId=messageTypeId.toLowerCase(),lowerMessageSubTypeId=messageSubTypeId.toLowerCase(),filteredRoutes=apFilterFeature(routes,"requiredFeature");return transition.appRoute=(createNew?"create":"")+(filteredRoutes[lowerMessageTypeId]&&filteredRoutes[lowerMessageTypeId].route||filteredRoutes[lowerMessageSubTypeId]&&filteredRoutes[lowerMessageSubTypeId].route||"message"),transition}}}]),angular.module("aprima-legacy-common").factory("RouteFormatter",["$urlMatcherFactory","_",function($urlMatcherFactory,_){"use strict";return{formatRoute:function(routePattern,params){return params=_.isUndefined(params)?{}:params,$urlMatcherFactory.compile(routePattern).format(params)},formatRelativeRoute:function(routePattern,parentRoutePattern,params){return params=_.isUndefined(params)?{}:params,0===routePattern.indexOf(parentRoutePattern+"/")&&(routePattern=routePattern.substring(parentRoutePattern.length)),$urlMatcherFactory.compile(routePattern).format(params)}}}]),angular.module("aprima-legacy-common").service("TransitionManager",["$log","$state","AppRoutes","_","WebViewManager","$rootScope","$transitions",function($log,$state,AppRoutes,_,WebViewManager,$rootScope,$transitions){"use strict";var previousTransition;$transitions.onStart({},function(transition){var fromState=transition.from()||{},fromStateName=fromState&&fromState.name||"",toState=transition.targetState()||{},toStateName=toState&&toState.name()||"",appRoute=_(AppRoutes).findKey({state:fromStateName||toStateName});previousTransition={appRoute:appRoute,opts:_.cloneDeep(transition.params("from"))}});var transitionToState=function(transition,replaceState){if(transition=function(transition){return transition?(transition=_.defaults(transition,{type:"transition",appRoute:"",opts:{}}),$log.info("TransitionManager postMessage to "+JSON.stringify(transition)),transition):void $log.warn("Cannot transition to null or undefined transition")}(transition)){var targetRoute=AppRoutes[transition.appRoute];return targetRoute?(_.isBoolean(transition.opts.replaceCurrentState)||(_.isBoolean(replaceState)?transition.opts.replaceCurrentState=replaceState:$state.current&&$state.current.name===targetRoute.state?transition.opts.replaceCurrentState=!0:transition.opts.replaceCurrentState=!1),targetRoute.options&&(transition.opts=_.merge(transition.opts,targetRoute.options)),$rootScope.$broadcast("TransitionActivated",transition),WebViewManager.activateView(targetRoute,transition)):($log.warn('Unable to find AppRoute: "'+transition.appRoute+'". Aborting transition.'),!1)}};return{transition:transitionToState,replaceCurrentState:function(transition){transitionToState(transition,!0)},goBack:function(){WebViewManager.goBack()},getPreviousTransition:function(){return previousTransition}}}]),angular.module("aprima-legacy-common").factory("WebViewManager",["$log","BrowserWebViewManager","XamarinWebViewManager","DeviceSettings",function($log,BrowserWebViewManager,XamarinWebViewManager,DeviceSettings){"use strict";return DeviceSettings.isStandaloneBrowser?($log.info("Using BrowserWebViewManager for standalone browser"),BrowserWebViewManager):DeviceSettings.isDevice||DeviceSettings.isPrm?($log.info("Using XamarinWebViewManager"),XamarinWebViewManager):($log.info("Using BrowserWebViewManager"),BrowserWebViewManager)}]),angular.module("aprima-legacy-common").factory("XamarinWebViewManager",["RouteFormatter","_","Bridge","$state",function(RouteFormatter,_,Bridge,$state){"use strict";return Bridge.onNavigate(function(d){if(!_.isUndefined(d)){var opts=JSON.parse(d.opts);opts&&!0===opts.replaceCurrentState?$state.go(d.state,opts,{location:"replace"}):$state.go(d.state,opts)}}),{activateView:function(appRoute,transition){var rawRoute=appRoute.route;appRoute.route&&(rawRoute=function completeRoute(appState){var parentSeperator=appState.state.lastIndexOf(".");if(0<parentSeperator){var parentState=$state.get(appState.state.substring(0,parentSeperator));return completeRoute({state:parentState.name,route:parentState.url})+appState.route}return appState.route}(appRoute));var route=appRoute.route?RouteFormatter.formatRelativeRoute(rawRoute,$state.get("^").url,transition.opts):"";return Bridge.navigate(appRoute,route,transition),!0},goBack:function(){Bridge.goBack()}}}]),angular.module("aprima-legacy-common").factory("NoteTypeRepository",["_","SystemGuid",function(_,SystemGuid){"use strict";var supportedTabs=["3e4888e6-a0be-4e5b-bdbf-3da7d4f71375",SystemGuid.UIControl_Note_CC,SystemGuid.UIControl_Note_CCHPI,"ffbb556f-ab4e-478f-a2d7-b4b863a344e9",SystemGuid.UIControl_Note_Confidential,"2c513cab-0d52-4e06-b64f-dc6391e464b7",SystemGuid.UIControl_Note_DX,SystemGuid.UIControl_Note_DXDSM,SystemGuid.UIControl_Note_GeneralNote,"8b40d89b-3511-42a4-b07b-decadc72647e",SystemGuid.UIControl_Note_HPI,SystemGuid.UIControl_Note_HX,"38080e33-7a49-4e4d-9d5c-ff87319d8307",SystemGuid.UIControl_Note_PE,SystemGuid.UIControl_Note_Plan,SystemGuid.UIControl_Note_Results,SystemGuid.UIControl_Note_ROS,SystemGuid.UIControl_Note_ROSPE,SystemGuid.UIControl_Note_RX,"871c47ed-372f-4c89-a4b8-c753951ca93e",SystemGuid.UIControl_Note_SO,SystemGuid.UIControl_Note_SP,SystemGuid.UIControl_Note_VisitText,SystemGuid.UIControl_Note_Vitals],supportedSliders=["2f35a3bb-0778-4cd6-a178-7734e7b4836e","4836176d-e412-47e9-ab6b-b549515c8007","bf9d1d68-cdcc-48f0-8080-1815212914fb","41e171a8-667a-4ade-aba4-dc7ce21c30d7","87d90295-1cbf-41cd-8582-fad6e0a7a4b9","142937f8-4c55-4c15-9677-f1a2105a019e","5b8fa2e2-31fa-40aa-bbf6-9d969ae5cc71","41e171a8-667a-4ade-aba4-dc7ce21c30d7","48606f65-ddf6-4f83-afaf-7dfb842d13d6","881ee22a-9193-45b3-85f5-818e4bd6ece9","b9d820ab-b216-47bf-af2d-b7ebfb79a137","14266173-8cfc-4b4e-8fa6-8f95ea61e03d"];function isNoteTabsSupported(note){if(_.isNil(note))return!1;var noteTabs=_.map(note.Tabs,"TabSliderUid");return _.intersection(noteTabs,supportedTabs).length===noteTabs.length}function isNoteSlidersSupported(note){if(_.isNil(note))return!1;var noteSliders=_.map(note.Sliders,"TabSliderUid");return _.intersection(noteSliders,supportedSliders).length===noteSliders.length}return{isNoteTypeSupported:function(note){return!_.isNil(note)&&isNoteTabsSupported(note)&&isNoteSlidersSupported(note)},isNoteTabsSupported:isNoteTabsSupported,isNoteSlidersSupported:isNoteSlidersSupported}}]),angular.module("aprima-legacy-common").factory("$qHelpers",["$q","_","$timeout",function($q,_,$timeout){"use strict";return{whenFirstSuccess:function(promises){var deferred=$q.defer(),results=[],resolved=!1,rejectionFlagValue={};function tryResolveToFirstSuccess(){var index=-1,length=results?results.length:0;if(!results||resolved)return!1;for(;++index<length;){var result=results[index];if(void 0===result)return!1;if(result!==rejectionFlagValue)return resolved=!0,deferred.resolve(result),results=null,!1}deferred.reject("Could not resolve first successful promise. All promises were rejected.")}return _.forEach(promises,function(promise,index){results[index]=void 0,promise.then(function(result){resolved||(results[index]=result,tryResolveToFirstSuccess())},function(){resolved||(results[index]=rejectionFlagValue,tryResolveToFirstSuccess())})}),deferred.promise},timeout:function(promise,time){var deferred=$q.defer(),timeoutPromise=$timeout(function(){deferred.reject("Promise took too long to resolve and was rejected.")},time);return promise.then(function(result){deferred.resolve(result)}).catch(function(err){deferred.reject(err)}).finally(function(){$timeout.cancel(timeoutPromise)}),deferred.promise},delay:function(promise,time){var deferred=$q.defer();return $timeout(function(){promise.then(function(result){deferred.resolve(result)}).catch(function(err){deferred.reject(err)})},time),deferred.promise},abortablePromise:abortablePromise,isPromise:function(value){return!!(value&&angular.isFunction(value.then)&&angular.isFunction(value.catch)&&angular.isFunction(value.finally))},abortPromises:abortPromises,abortPromise:abortPromise};function abortablePromise(promise,previousPromises,shouldRejectOnAbort){var deferred=$q.defer();shouldRejectOnAbort=angular.isFunction(shouldRejectOnAbort)?_.once(shouldRejectOnAbort):function(){return!0},abortPromises(previousPromises),promise.then(function(result){deferred.resolve(result)},function(error){deferred.reject(error)});var error={isAborted:!0,msg:"Aborted"};return deferred.promise.abort=function(){var shouldAbort=!!shouldRejectOnAbort(error);return shouldAbort&&deferred.reject(error),shouldAbort},replaceChainFnsWithAbortableFns(deferred.promise,"then"),replaceChainFnsWithAbortableFns(deferred.promise,"catch"),replaceChainFnsWithAbortableFns(deferred.promise,"finally"),deferred.promise}function abortPromises(promises){_.isArray(promises)?_.forEach(promises,function(promise){abortPromise(promise)}):abortPromise(promises)}function abortPromise(promise){promise&&promise.abort&&promise.abort()}function replaceChainFnsWithAbortableFns(promise,chainFnKey){var wrappedKey="_"+chainFnKey,wrappedFn=promise[wrappedKey]=promise[wrappedKey]||promise[chainFnKey]||angular.noop;promise[chainFnKey]=function(){var chained=wrappedFn.apply(promise,arguments);return _.isFunction(chained.abort)?chained:abortablePromise(chained,null,function(){return promise.abort()})}}}]),angular.module("aprima-legacy-common").factory("HttpAbortableContext",["$q","$qHelpers","_",function($q,$qHelpers,_){"use strict";return function(previousPromiseToAbort){var abortDeferred=$q.defer();return{abortPromise:abortDeferred.promise,wrap:function(promise){var abortedError;return promise=promise.catch(function(error){return abortedError&&error&&error.status<0&&_.assign(error,abortedError),$q.reject(error)}),$qHelpers.abortablePromise(promise,previousPromiseToAbort,function(error){return abortedError=error,abortDeferred.resolve(),!1})}}}}]),function(angular){"use strict";window.angular.module("aprima-legacy-common").constant("Permissions",{Schedule:"schedule",FullNoteComposer:"fnc",StrikeoutVisits:"strikeoutvisits"})}(),function(angular){"use strict";window.angular.module("aprima-legacy-common").factory("SecurityRepository",["_","$q","AprimaCache","AprimaRestangular",function(_,$q,AprimaCache,AprimaRestangular){var defaultCache=AprimaCache.Permissions.httpMode;return{getPermissions:function(permissionName){return AprimaRestangular.get().one("permissions",permissionName).withHttpConfig({cache:defaultCache}).get().then(function(securityPermission){return securityPermission?(_.has(securityPermission,"IsAllowed")||(securityPermission.IsAllowed=!0),securityPermission):$q.reject("No permission matches '"+permissionName+"'")})}}}])}(),function(angular){"use strict";window.angular.module("aprima-legacy-common").factory("TileGroup",["_","AprimaCache",function(_,AprimaCache){var groupStates={userPreference:0,allExpanded:1,allCollapsed:2};return function(tileGroupName,config,storageType,disablePersistence){this.setupTile=function(tileId,defaultValue,forceDefault){var tile=tiles[tileId];tile&&!forceDefault||(tile=tiles[tileId]={isCollapsed:defaultValue});groupState===groupStates.allExpanded?tile.isCollapsed=!1:groupState===groupStates.allCollapsed?tile.isCollapsed=!0:groupState===groupStates.userPreference&&persist&&save();return tile},this.toggle=function(tileId){var tile=tiles[tileId];if(!tile)return;tile.isCollapsed=!tile.isCollapsed,groupState===groupStates.userPreference&&persist&&save()},this.nextState=function(){groupState=groupState!==groupStates.allCollapsed?groupState+1:groupStates.userPreference,updateTiles()},this.changeConfiguration=function(config){if(!config||configuration===config)return;configuration=config,updateTiles()},this.getName=function(){return name},this.setPersistence=function(enable){persist=!!enable};var name=tileGroupName,persist=!disablePersistence,configuration=config||"default",type="tileGroup",tiles={},groupState=groupStates.userPreference,cache=AprimaCache.getOrCreateOverride(type+"."+name,{storagePrefix:"caches."});persist&&cache.setStorageMode(storageType||"localStorage");function save(){return cache.put(configuration,tiles)}function updateTiles(){if(groupState!==groupStates.userPreference){var newValue=groupState===groupStates.allCollapsed;_.forEach(tiles,function(val){val.isCollapsed=newValue})}else _.merge(tiles,cache.get(configuration))}updateTiles()}}])}(),angular.module("aprima-legacy-common").value("widgetViews",[{id:"259e6a7b-64a8-437c-82b7-000000000001",name:"allergies",displayName:"Allergies",userPlaceable:!0,view:"/patients/views/dashboard-widgets/allergiesTile.html"},{id:"259e6a7b-64a8-437c-82b7-000000000002",name:"appointments",displayName:"Appointments",userPlaceable:!0,view:"/patients/views/dashboard-widgets/appointmentsTile.html"},{id:"259e6a7b-64a8-437c-82b7-000000000003",name:"demographics",displayName:"Demographics",userPlaceable:!0,view:"/patients/views/dashboard-widgets/demographicsTile.html"},{id:"259e6a7b-64a8-437c-82b7-000000000004",name:"header",displayName:"Patient Header",userPlaceable:!1,view:"/patients/views/dashboard-widgets/patientHeaderTile.html"},{id:"259e6a7b-64a8-437c-82b7-000000000009",name:"problems",displayName:"Problem List",userPlaceable:!0,view:"/patients/views/dashboard-widgets/problemListTile.html"},{id:"259e6a7b-64a8-437c-82b7-000000000006",name:"medications",displayName:"Active Medications",userPlaceable:!0,view:"/patients/views/dashboard-widgets/medicationsTile.html"},{id:"259e6a7b-64a8-437c-82b7-000000000012",name:"visits",displayName:"Visits",userPlaceable:!0,view:"/patients/views/dashboard-widgets/visitsTile.html"},{id:"259e6a7b-64a8-437c-82b7-000000000010",name:"remarks",displayName:"Remarks",userPlaceable:!0,view:"/patients/views/dashboard-widgets/remarksTile.html"},{id:"259e6a7b-64a8-437c-82b7-000000000008",name:"orders",displayName:"Orders",userPlaceable:!0,view:"/patients/views/dashboard-widgets/ordersTile.html"},{id:"259e6a7b-64a8-437c-82b7-000000000007",name:"observationResults",displayName:"Observation Results",userPlaceable:!0,view:"/patients/views/dashboard-widgets/observationResultsTile.html"},{id:"259e6a7b-64a8-437c-82b7-000000000011",name:"vitals",displayName:"Vitals",userPlaceable:!0,view:"/patients/views/dashboard-widgets/vitalsTile.html"},{id:"259e6a7b-64a8-437c-82b7-000000000005",name:"healthMaintenanceReminders",displayName:"Health Reminders",userPlaceable:!0,view:"/patients/views/dashboard-widgets/healthMaintenanceRemindersTile.html"},{id:"259e6a7b-64a8-437c-82b7-000000000013",name:"attachments",displayName:"Attachments",userPlaceable:!0,view:"/patients/views/dashboard-widgets/attachmentsTile.html"},{id:"259e6a7b-64a8-437c-82b7-000000000014",name:"observationValues",displayName:"Observation Values",userPlaceable:!0,view:"/patients/views/dashboard-widgets/observationValuesTile.html"},{id:"259e6a7b-64a8-437c-82b7-000000000015",name:"diagnosisSummaries",displayName:"Diagnosis Summaries",userPlaceable:!0,view:"/patients/views/dashboard-widgets/diagnosisSummariesTiles.html"},{id:"259e6a7b-64a8-437c-82b7-000000000016",name:"recalls",displayName:"Recalls",userPlaceable:!0,view:"/patients/views/dashboard-widgets/recallsTile.html"}]);
//# sourceMappingURL=aprima-legacy-common.min.js.map