angular.module("aprima-bridge",["aprima-core","lodash"]),angular.module("aprima-bridge").factory("AndroidBridge",["XamarinBridge","_",function(XamarinBridge,_){"use strict";return _.cloneDeep(XamarinBridge)}]),angular.module("aprima-bridge").factory("Bridge",["$log","IosBridge","AndroidBridge","WebBridge","PrmBridge","DeviceSettings",function($log,IosBridge,AndroidBridge,WebBridge,PrmBridge,DeviceSettings){"use strict";var getLog=function(){return $log.delegate||$log};return DeviceSettings.isStandaloneBrowser?(getLog().info("Using WebBridge for standalone browser"),WebBridge):DeviceSettings.isIos?(getLog().info("Using iOSBridge"),IosBridge):DeviceSettings.isAndroid?(getLog().info("Using AndroidBridge"),AndroidBridge):DeviceSettings.isPrm?(getLog().info("Using PrmBridge"),PrmBridge):(getLog().info("Using WebBridge"),WebBridge)}]),function(angular){"use strict";window.angular.module("aprima-bridge").factory("CustomModuleRunService",["$injector",function($injector){var hasRun=!1,runFns=[];return{add:function(fn){if(hasRun)throw new Error("CustomModuleRunService has already run");runFns.push(fn)},run:function(){if(hasRun)throw new Error("CustomModuleRunService has already run");hasRun=!0,runFns.forEach($injector.invoke)}}}])}(),angular.module("aprima-bridge").factory("IosBridge",["XamarinBridge","_",function(XamarinBridge,_){"use strict";return _.cloneDeep(XamarinBridge)}]),angular.module("aprima-bridge").factory("PrmBridge",["XamarinBridge","_",function(XamarinBridge,_){"use strict";return _.cloneDeep(XamarinBridge)}]),angular.module("aprima-bridge").factory("WebBridge",["$rootScope","$log","_",function($rootScope,$log,_){"use strict";var getLog=function(){return $log.delegate||$log};return{onNavigate:angular.noop,trackPageChange:function(location){getLog().debug("Page Change: "+_.pad(location,30))},trackEvent:function(category,action,label,value){getLog().debug("Event: "+_.pad(category,20)+" | "+_.pad(action,20)+" | "+_.pad(label,20)+" | "+_.pad(value,20))},trackException:function(message){getLog().debug("Exception: "+message)},trackTiming:function(category,label,timingValue,page){getLog().debug("Timing: "+_.pad(page,30)+" | "+_.pad(category,7)+" | "+_.pad(label,30)+" | "+_.pad(timingValue,5)+"ms")},changeUserInfo:angular.noop,setupPage:angular.noop,setHeaderMode:angular.noop,goBack:angular.noop,logoff:angular.noop,pageFinished:angular.noop,pickMedia:angular.noop,updateSettings:function(settings){getLog().info("calling web bridge: settings = "+JSON.stringify(settings))},createModalAlert:function(alert){getLog().error("WebBridge.createModalAlert  ----------"),getLog().error("alert.title  = "+alert.title),getLog().error("alert.message = "+alert.message)},closeSearchHeader:angular.noop,updateBadges:angular.noop,updatePageIndicator:angular.noop,overriddenMessages:angular.noop,debugModeToggled:angular.noop,updateInactivityTimeout:angular.noop,scanBarcode:angular.noop,on:function(event,$scope,fn){var removerEventListener=$rootScope.$on(event,function(e,args){function handler(){fn(args)}$scope&&$scope.$evalAsync?$scope.$evalAsync(function(){handler()}):handler()});return $scope&&$scope.$on("$destroy",function(){getLog().info("removing listener from bridge due to $scope.$destroy event"),removerEventListener(),$scope=fn=null}),removerEventListener},fireEvent:function(event,data){$rootScope.$broadcast(event,data)}}}]),angular.module("aprima-bridge").factory("XamarinBridge",["$timeout","_","HostedBridgeService",function($timeout,_,HostedBridgeService){"use strict";var getBridge=function(){return HostedBridgeService};return{fireEvent:function(eventName,data){getBridge().fireEvent(eventName,data)},navigate:function(appRoute,route,transition){try{getBridge().fireEvent("navigate",{command:{Route:route,Page:"/index.html",State:appRoute.state,ListUiControlName:appRoute.listUiControlName,Options:JSON.stringify(transition.opts),PageOptions:JSON.stringify(transition.pageOpts)}})}catch(e){console.warn(e.message)}},trackPageChange:function(location){getBridge().fireEvent("trackPageChange",{page:location})},trackException:function(msg){getBridge().fireEvent("trackException",{message:msg})},trackEvent:function(category,action,label,value){getBridge().fireEvent("trackEvent",{category:category||"",action:action||"",label:label||"",value:value||""})},trackTiming:function(category,label,value,page){getBridge().fireEvent("trackTiming",{category:category||"",label:label||"",value:value||"",page:page||""})},logoff:function(message){getBridge().fireEvent("logoff",{message:message})},onNavigate:function(fn){getBridge().addEventListener("navigate",fn)},on:function(event,$scope,fn){var handlerForScope=function(args){function handler(){fn(args)}$scope&&$scope.$evalAsync?$scope.$evalAsync(function(){handler()}):handler()},removeEventListener=function(){getBridge().removeEventListener(event,handlerForScope),removeEventListener=angular.noop};return $scope&&$scope.$on("$destroy",function(){removeEventListener()}),getBridge().addEventListener(event,handlerForScope),removeEventListener},changeUserInfo:function(jsonWebToken,clientUrl,userId){getBridge().fireEvent("changeUserInfo",{UserInfo:{JsonWebToken:jsonWebToken,ClientUrl:clientUrl,UserId:userId}})},updateSettings:function(s){var settings=[];!1===_.isArray(s)?settings.push(s):settings=s,getBridge().fireEvent("updateSettings",{settings:settings})},setupPage:function(nativeSettings){getBridge().fireEvent("setupPage",nativeSettings)},setHeaderMode:function(mode){getBridge().fireEvent("setHeaderMode",{mode:mode})},createModalAlert:function(args){getBridge().fireEvent("createModalAlert",args)},closeSearchHeader:function(){getBridge().fireEvent("closeSearchHeader",{})},goBack:function(){getBridge().fireEvent("goBack",{})},pageFinished:function(){$timeout(function(){getBridge().fireEvent("pagefinished",{})},0)},pickMedia:function(id,buttonText){getBridge().fireEvent("pickMedia",{Id:id,SaveButtonText:buttonText})},updateBadges:function(){getBridge().fireEvent("updateBadges",{})},updatePageIndicator:function(itemCount,currentItem,useLastHeader){getBridge().fireEvent("updatePageIndicator",{itemCount:itemCount,currentItem:currentItem,useLastHeader:useLastHeader})},overriddenMessages:function(args){getBridge().fireEvent("overriddenMessages",{fileKey:args[1],logData:JSON.stringify([].slice.call(args,2))})},debugModeToggled:function(args){getBridge().fireEvent("debugModeToggled",{debugMessage:args[0],fileKey:args[1],extraInfo:JSON.stringify([].slice.call(args,2))})},updateInactivityTimeout:function(userInactivityTimeout){getBridge().fireEvent("updateInactivityTimeout",{timeout:userInactivityTimeout})},scanBarcode:function(id){getBridge().fireEvent("scanBarcode",{Id:id})}}}]);
//# sourceMappingURL=aprima-bridge.min.js.map