angular.module('apEasyScroller', []);

angular.module('apEasyScroller').directive('apEasyScroller',
    ['$window', '_',
        function ($window, _) {
            'use strict';

            var easyScrollerListener = function (eScroll, elm) {
                var viewHeight = $window.innerHeight;
                var eleHeight = elm.scrollHeight;
                elm.style.height = '0px';
                if (eleHeight - viewHeight > 0) {
                    elm.style.height = (elm.scrollHeight-viewHeight)+'px';
                }
                eScroll.reflow();
                //change to correct height for backdrop
                elm.style.height = elm.scrollHeight + 'px';
            };

            return {
                restrict: 'EA',
                link: function ($scope, elm) {
                    elm = elm[0];
                    var eScroll = new EasyScroller(elm, {
                        scrollingY: true,
                        scrollingX: false
                    });

                    var updateFn = function () {
                        easyScrollerListener(eScroll, elm);
                    };

                    $window.addEventListener('touchstart', updateFn, false);
                    $window.addEventListener('mousedown', updateFn, false);
                    $window.addEventListener('mousewheel', updateFn, false);

                    $scope.$on('es-page-height-change', function(){
                        eScroll.scrollTo(0, 0, false);
                    })
                }
            }
        }]);