angular.module("account",["ngCookies","gettext","restangular","lodash","search","aprima-core","aprima-bridge","aprima-config","aprima-legacy-common","aprima-provider-api","aprima-patient-api"]),angular.module("account").config(["AppRoutesProvider","$stateProvider",function(AppRoutesProvider,$stateProvider){"use strict";var appRoutes={changepassword:{state:"change-password",route:"/changepassword"}};AppRoutesProvider.setupAppRoutes(appRoutes),$stateProvider.state(appRoutes.changepassword.state,{url:appRoutes.changepassword.route,component:"changePassword"})}]),angular.module("account").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("/account/views/changepassword.html",'<form name="changepasswordform" ng-submit="$ctrl.submit(changepasswordform)" novalidate>\r\n    <div ng-if="!$ctrl.loading && !httpError && $ctrl.isActiveDirectoryUser" class="panel-body panel-flush">\r\n        <div class="panel-subheading">\r\n            {{::\'Active Directory User Passwords Must Be Changed Through Windows\' | translate}}\r\n        </div>\r\n    </div>\r\n    <div ng-if="!$ctrl.loading && !httpError && !$ctrl.isActiveDirectoryUser" class="panel-body panel-flush">\r\n        <div class="panel-subheading">\r\n            {{::\'Please create a new password:\' | translate}}\r\n        </div>\r\n        <div class="row">\r\n            <div class="col-xs-12">\r\n                <div class="form-group"\r\n                            ng-class="{ \'has-error\' : changepasswordform.oldPassword.$invalid && changepasswordform.$submitted}">\r\n                    <label class="control-label">{{::\'Old Password\' | translate}}</label>\r\n                    <div class="form-group">\r\n                        <input class="form-control"\r\n                                id="oldpassword"\r\n                                name="oldPassword"\r\n                                ng-model="$ctrl.model.OldPassword"\r\n                                type="password"\r\n                                placeholder="Old Password"\r\n                                ng-disabled="showSecurityQuestions"\r\n                                required\r\n                                >\r\n                        <span ng-show="changepasswordform.oldPassword.$invalid && changepasswordform.$submitted"\r\n                                class="help-block ng-hide">\r\n                        {{::\'Not valid.\' | translate}}\r\n                        </span>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div class="row">\r\n            <div class="col-xs-12">\r\n                <div class="form-group"\r\n                     ng-class="{ \'has-error\' : changepasswordform.newPassword.$invalid && changepasswordform.$submitted}">\r\n                    <label class="control-label">{{::\'New Password\' | translate}}</label>\r\n                    <input class="form-control"\r\n                           id="newPassword"\r\n                           name="newPassword"\r\n                           ng-model="$ctrl.model.NewPassword"\r\n                           type="password"\r\n                           placeholder="New Password"\r\n                           ng-minlength="5"\r\n                           required\r\n                            >\r\n                    <span ng-show="changepasswordform.newPassword.$invalid && changepasswordform.$submitted"\r\n                          class="help-block ng-hide">\r\n                            {{::\'Password must be at least 5 characters.\' | translate}}\r\n                    </span>\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div class="row">\r\n            <div class="col-xs-12">\r\n                <div class="form-group"\r\n                     ng-class="{ \'has-error\' : changepasswordform.confirmNewPassword.$invalid && changepasswordform.$submitted}">\r\n                    <label class="control-label">{{::\'Retype New Password\' | translate}}</label>\r\n                    <input class="form-control"\r\n                           id="confirmNewPassword"\r\n                           name="confirmNewPassword"\r\n                           ng-model="$ctrl.confirmNewPassword"\r\n                           type="password"\r\n                           placeholder="Retype Password"\r\n                           ng-pattern="$ctrl.model.NewPassword"\r\n                           required\r\n                            >\r\n                    <span ng-show="changepasswordform.confirmNewPassword.$invalid && changepasswordform.$submitted"\r\n                          class="help-block ng-hide">\r\n                            {{::\'Passwords do not match.\' | translate}}\r\n                    </span>\r\n                </div>\r\n            </div>\r\n        </div>\r\n        <div class="panel-footer panel-flush">\r\n            <div class="row">\r\n                <div class="col-xs-6">\r\n                    <button type="button" class="btn btn-default2 btn-lg" ng-click="$ctrl.back()">{{\'Back\' | translate}}</button>\r\n                </div>\r\n                <div class="col-xs-6">\r\n                    <button type="submit" class="btn btn-primary btn-lg pull-right"\r\n                            ng-disabled="$ctrl.loading">\r\n                        <ap-spinner ng-show="$ctrl.loading"></ap-spinner>\r\n                        {{\'Submit\' | translate}}\r\n                    </button>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div ng-if="$ctrl.loading || httpError">\r\n        <div class="text-center" ng-if="$ctrl.loading">\r\n            <ap-spinner size="3"></ap-spinner>\r\n        </div>\r\n        <div class="alert alert-danger" ng-if="httpError.unhandled" ng-cloak>\r\n            {{"An error has occurred and the page could not be loaded." | translate}}\r\n        </div>\r\n        <div class="alert alert-danger" ng-if="httpError.is403" ng-cloak>\r\n            {{"You do not have access to this info."| translate}}\r\n        </div>\r\n    </div>\r\n</form>')}]),function(){"use strict";angular.module("account").component("changePassword",{bindings:{},templateUrl:"/account/views/changepassword.html",controller:["$stateParams","FacilitySecurityRepository","gettext","LocalStorageRepository","toaster","TransitionManager",function($stateParams,FacilitySecurityRepository,gettext,LocalStorageRepository,toaster,TransitionManager){var vm=this;vm.confirmNewPassword="",vm.loading=!1,vm.userName="",vm.model={Id:LocalStorageRepository.getUserID(),OldPassword:"",NewPassword:""},vm.back=function(){TransitionManager.goBack()},vm.submit=function(form){if(form.$invalid)return;vm.loading=!0,FacilitySecurityRepository.postChangePassword(vm.model).then(function(){toaster.pop("success","",gettext("Password has been changed successfully. Please login with new password.")),TransitionManager.transition({appRoute:"login"})}).catch(function(error){toaster.pop("error","",gettext(error.data))}).finally(function(){vm.loading=!1})},vm.$onInit=function(){vm.isActiveDirectoryUser=LocalStorageRepository.getIsActiveDirectoryUser(),vm.userName=LocalStorageRepository.getUserName()}}]})}(),angular.module("app",["ngCookies","restangular","ui.router","ui.router.upgrade","gettext","restangular","lodash","ngIdle","aprima-core","aprima-bridge","aprima-config","aprima-facility-api","aprima-legacy-common","aprima-provider-api","aprima-patient-api","aprima-utils"]).constant("AppId",{PracticeName:"2AD081A3-A195-4093-9C7F-1563BD3179A3",MessageSubHeader:"B348F800-1FCB-4397-9E1A-2226AFD836E4"}).config(["IdleProvider",function(IdleProvider){"use strict";IdleProvider.interrupt("keydown mousedown mousewheel"),IdleProvider.autoResume(!0),IdleProvider.keepalive(!1),IdleProvider.idle(600),IdleProvider.timeout(1)}]),function(angular){"use strict";function ApFacilityPortalCtrl($rootScope,$scope,CustomModuleRunService){var vm={loadedAngular:!1,isLoginView:function(){return $rootScope.loginView},onAngularInitialized:function(){CustomModuleRunService.run(),vm.loadedAngular=!0},shouldHideFooter:function(){return $rootScope.hideFooter},shouldHideToolbar:function(){return $rootScope.hideHeader}};$scope.vm=vm}window.angular.module("app").directive("apFacilityPortal",function(){return{restrict:"E",controller:["$rootScope","$scope","CustomModuleRunService",ApFacilityPortalCtrl],templateUrl:"/app/views/apFacilityPortal.html"}})}(),angular.module("app").config(["AppRoutesProvider",function(AppRoutesProvider){"use strict";AppRoutesProvider.setupAppRoutes({})}]),angular.module("app").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("/app/partials/desktopRuler/views/apDesktopRuler.html",'<div class="container-fluid container-flush ap-application-margin ap-application-content desktop-ruler-height">\r\n    <div class="desktop-ruler-margin-left">P-L</div>\r\n\r\n    <div class="desktop-ruler-column-left">01</div>\r\n    <div class="desktop-ruler-gutter"></div>\r\n\r\n    <div class="desktop-ruler-column-left">02</div>\r\n    <div class="desktop-ruler-gutter"></div>\r\n\r\n    <div class="desktop-ruler-column-left">03</div>\r\n    <div class="desktop-ruler-gutter"></div>\r\n\r\n    <div class="desktop-ruler-column-left">04</div>\r\n    <div class="desktop-ruler-gutter"></div>\r\n\r\n    <div class="desktop-ruler-column-left">05</div>\r\n    <div class="desktop-ruler-gutter"></div>\r\n\r\n    <div class="desktop-ruler-column-left">06</div>\r\n    <div class="desktop-ruler-gutter"></div>\r\n\r\n    <div class="desktop-ruler-column-left">07</div>\r\n    <div class="desktop-ruler-gutter"></div>\r\n\r\n    <div class="desktop-ruler-column-left">08</div>\r\n    <div class="desktop-ruler-gutter"></div>\r\n    <div class="desktop-ruler-column-left">09</div>\r\n\r\n    <div class="desktop-ruler-gutter"></div>\r\n    <div class="desktop-ruler-column-left">10</div>\r\n\r\n    <div class="desktop-ruler-gutter"></div>\r\n    <div class="desktop-ruler-column-left">11</div>\r\n\r\n    <div class="desktop-ruler-gutter"></div>\r\n    <div class="desktop-ruler-column-left">12</div>\r\n\r\n    <div class="desktop-ruler-gutter"></div>\r\n    <div class="desktop-ruler-column-left">13</div>\r\n\r\n    <div class="desktop-ruler-gutter"></div>\r\n    <div class="desktop-ruler-column-left">14</div>\r\n\r\n    <div class="desktop-ruler-gutter"></div>\r\n    <div class="desktop-ruler-column-left">15</div>\r\n\r\n    <div class="desktop-ruler-gutter"></div>\r\n    <div class="desktop-ruler-column-left">16</div>\r\n\r\n    <div class="desktop-ruler-margin-right">P-R</div>\r\n</div>'),$templateCache.put("/app/partials/footer/views/apFooter.html",'<div class="row" ng-cloak>\r\n    <div class="ap-footer ap-application-padding">\r\n        <div class="col-xs-4">\r\n            <span>\r\n                 {{\'Powered by\' | translate}}&nbsp;&nbsp;\r\n                <img src="images/spacer.png" class="ap-footer-logo">\r\n            </span>\r\n        </div>\r\n        <div class="col-xs-8">\r\n            <div class="row">\r\n                <div class="col-xs-12">\r\n                    <span class="pull-right">\r\n                        <a class="clickable" ng-click="viewPrivacyPolicyImage()">{{\'Privacy Policy\' | translate}}</a>\r\n                        <span ng-if="apFooter.PatientAuthenticated">\r\n                            &nbsp;&nbsp;|&nbsp;&nbsp;\r\n                        </span>\r\n                    </span>\r\n                </div>\r\n            </div>\r\n            <div class="row">\r\n                <div class="col-xs-12">\r\n                    <span class="pull-right">\r\n                      &copy; {{\'Aprima Medical Software 2015.  All rights reserved.\' | translate}}\r\n                    </span>\r\n                </div>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>'),$templateCache.put("/app/partials/header/views/apHeader.html",'\r\n<div class="ap-header flexbox flexbox-horizontal-center" ng-cloak>\r\n    <div class="flexbox-pull-left">\r\n        <span>\r\n            <img src="images/spacer.png" class="header-image">\r\n        </span>\r\n        <span class="header-title" ng-if="!apHeader.practiceName">\r\n        </span>\r\n    </div>\r\n\r\n    <div class="flexbox-pull-right">\r\n        <span class="header-dropdown header-menu header-item flush-right">\r\n\r\n            <div class="dropdown">\r\n                <button class="btn btn-header dropdown-toggle btn-flush-right btn-header-image no-image" type="button" id="header-context-menu" data-toggle="dropdown" aria-expanded="true">\r\n                    <span class="header-text1">{{\'Welcome,\'|translate}}&nbsp;&nbsp;</span>\r\n                    <span class="header-text2">{{apHeader.activeUserFullName | translate}} </span>\r\n                    <span class="caret"></span>\r\n                </button>\r\n                <ul class="dropdown-menu dropdown-menu-right no-image" role="menu" aria-labelledby="header-context-menu">\r\n                    <li role="presentation">\r\n                        <a id="context-signout" role="menuitem" tabindex="3" ng-click="signOff()">{{\'Sign Out\' | translate}}</a>\r\n                    </li>\r\n                </ul>\r\n            </div>\r\n          </span>\r\n\r\n        <div class="ap-mobile-menu-button" ng-click="toggleMobileNav()">\r\n            <span class="glyphicon glyphicon-menu-hamburger"></span>\r\n        </div>\r\n\r\n        <span class = "header-item pull-right center-text" ng-if="loading"><ap-spinner></ap-spinner></span>\r\n    </div>\r\n</div>'),$templateCache.put("/app/partials/mobileNav/views/apMobileNav.html",'\x3c!--Begin mobile nav bar--\x3e\r\n<div class="dropdown ap-mobile-nav slide-in" collapse="!showMobileNav" ng-cloak>\r\n  <div ng-if="showMobileNav">\r\n\r\n    <div class="ap-mobile-nav-item ap-mobile-nav-welcome flexbox flexbox-horizontal-center">\r\n        {{:: \'Welcome\' | translate}}, {{ ::headerData.activeUserFullName }}\r\n    </div>\r\n\r\n      <div class="ap-mobile-nav-item ap-mobile-nav-signout flexbox flexbox-horizontal-center" ng-click="signOff()">\r\n          <i class="fa fa-power-off"></i>\r\n          <span class="nav-item">\r\n        {{:: \'Sign out\' | translate}}\r\n      </span>\r\n      </div>\r\n    </div>\r\n</div>\r\n'),$templateCache.put("/app/partials/toolbar/views/apToolbar.html",'<div class="btn-group btn-group-justified ap-toolbar ap-application-margin ap-application-content hidden-print" role="group" ng-cloak>\r\n        <div class="btn-group"\r\n             ng-class="(!toolbarItem || toolbarItem === \'welcome\')? \'btn-group-toolbar-selected btn-group-flush-left\' : \'btn-group-toolbar btn-group-flush-left\'"\r\n             role="group">\r\n                <button\r\n                        class="btn btn-nowrap btn-toolbar underline"\r\n                        id="welcome-btn"\r\n                        ng-if="notifications.Welcome.IsActive && !blankToolbar.BackToHome.IsActive"\r\n                        data-transition-to="{appRoute: \'dashboard\'}">\r\n\r\n                    <img src="images/spacer.png" class="toolbar-svg home-selected" ng-if="(!toolbarItem || toolbarItem === \'welcome\')">\r\n                    <img src="images/spacer.png" class="toolbar-svg home" ng-if="(toolbarItem && toolbarItem !== \'welcome\')">\r\n                    <div>\r\n                        {{:: \'Welcome\' | translate}}\r\n                    </div>\r\n                </button>\r\n        </div>\r\n    </div>'),$templateCache.put("/app/views/apFacilityPortal.html",'<div ng-if="!vm.loadedAngular">\r\n    <ap-force-load-angular (angular-initialized)="vm.onAngularInitialized()" />\r\n</div>\r\n<div ng-if="vm.loadedAngular">\r\n    <ap-header ng-if="!vm.shouldHideToolbar()"></ap-header>\r\n    <ap-toolbar ng-if="!vm.shouldHideToolbar()"></ap-toolbar>\r\n    <ap-mobile-nav ng-if="!vm.shouldHideToolbar()"></ap-mobile-nav>\r\n\r\n    <div ng-class="(vm.shouldHideToolbar())?\'ap-main-content\':\'ap-main-content-toolbar\'">\r\n        <div\r\n            id="main-content"\r\n            ng-class="!vm.isLoginView() ? \'ap-application-margin ap-application-content\' : \'container-fluid container-flush\'"\r\n            ui-view>\r\n        </div>\r\n\r\n        <toaster-container toaster-options="{}"></toaster-container>\r\n        <ap-footer ng-if="!vm.shouldHideFooter()"></ap-footer>\r\n    </div>\r\n</div>'),$templateCache.put("/app/views/modals/multiDownloadModal.html",'<div>\r\n    <div class="row">\r\n        <div class="col-xs-12">\r\n            <div class="modal-header">\r\n                <button type="button" class="close" ng-click="vm.cancel()">&times;</button>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div class="modal-body">\r\n        <div class="row">\r\n            <div class="col-xs-12">\r\n                <multi-checkbox selectedlist="vm.selectedList" sourcelist="vm.sourceList"\r\n                                value="vm.value" label="vm.label" all="vm.all" sort-by="vm.sortBy"></multi-checkbox>\r\n            </div>\r\n        </div>\r\n    </div>\r\n    <div class="modal-footer">\r\n        <div class="row">\r\n            <div class="col-xs-6"><button class="btn btn-default submit" ng-disabled="vm.Downloading || vm.selectedList.length === 0" ap-save-to-file="vm.downloadMultipleVisits()">\r\n                <i class="fa fa-download" ng-hide="vm.Downloading" aria-hidden="true"></i>\r\n                <ap-spinner ng-show="vm.Downloading"></ap-spinner>\r\n            </button>\r\n            </div>\r\n            <div class="col-xs-6">\r\n                <button class="btn btn-default" ng-click="vm.cancel()">{{\'Cancel\' | translate}}</button>\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>'),$templateCache.put("/app/views/modals/viewDocumentModal.html",'<div class="modal-default">\r\n    <div class="modal-header">\r\n        <button type="button" class="close" ng-click="vm.cancel()"><span>&times;</span></button>\r\n        <span class="modal-subtitle">{{vm.model.Title}}</span>\r\n    </div>\r\n\r\n    <div class="modal-body modal-max-height">\r\n        <ap-document-viewer-with-download\r\n            disable-inline-pdf="vm.model.DisableInlinePdf"\r\n            document-id="vm.model.DocumentId"\r\n            download-file-name="vm.model.DownloadFileName"\r\n            enable-download="vm.model.EnableDownload"\r\n            document-download="vm.downloadDocument(documentId)"\r\n            document-load="vm.loadDocument(documentId, requestSettings)"\r\n        ></ap-document-viewer-with-download>\r\n    </div>\r\n\r\n    <div class="modal-footer">\r\n        <button type="button" class="btn btn-default2 btn-lg" ng-click="vm.ok()">{{::\'Close\' | translate}}</button>\r\n    </div>\r\n</div>')}]),function(angular){"use strict";angular.module("app").factory("MultiDownloadModal",["$uibModal",function($modal){return{openMultiModal:function(multiVisitObj){var formattingTemplateId=multiVisitObj.formattingTemplateId,selectedList=multiVisitObj.selectedList,sourceList=multiVisitObj.sourceList,value=multiVisitObj.value,label=multiVisitObj.label,all=multiVisitObj.all,sortBy=multiVisitObj.sortBy,patientId=multiVisitObj.patientId,externalId=multiVisitObj.externalId;return $modal.open({backdrop:"static",templateUrl:"/app/views/modals/multiDownloadModal.html",windowClass:"modal-full",controller:"MultiDownloadModalCtrl",controllerAs:"vm",resolve:{formattingTemplateId:function(){return formattingTemplateId},selectedList:function(){return selectedList},sourceList:function(){return sourceList},value:function(){return value},label:function(){return label},all:function(){return all},sortBy:function(){return sortBy},patientId:function(){return patientId},externalId:function(){return externalId}}}).result}}}]),angular.module("app").controller("MultiDownloadModalCtrl",["$uibModalInstance","FacilityVisitRepository","formattingTemplateId","selectedList","sourceList","value","label","all","sortBy","patientId","externalId",function($modalInstance,FacilityVisitRepository,formattingTemplateId,selectedList,sourceList,value,label,all,sortBy,patientId,externalId){var vm=this;vm.formattingTemplateId=formattingTemplateId,vm.selectedList=selectedList,vm.sourceList=sourceList,vm.value=value,vm.label=label,vm.all=all,vm.sortBy=sortBy,vm.patientId=patientId,vm.externalId=externalId,vm.Downloading=!1,vm.cancel=function(){vm.selectedList=[],$modalInstance.dismiss()},vm.downloadMultipleVisits=function(){vm.Downloading=!0;var visitIds=[];return _.forEach(vm.selectedList,function(item){visitIds.push(item.VisitId)}),FacilityVisitRepository.getVisitPdfs(vm.formattingTemplateId,vm.patientId,visitIds).then(function(data){return null===data?$modalInstance.close("error"):$modalInstance.close("success"),{Data:data.Data,Extension:"pdf",FileName:"ID"+vm.externalId+"_Visits"}})}}])}(window.angular),function(angular){"use strict";angular.module("app").factory("ViewDocumentModal",["$uibModal",function($uibModal){return{openViewDocumentModal:function(modalConfig){$uibModal.open({templateUrl:"/app/views/modals/viewDocumentModal.html",controller:"ViewDocumentModalCtrl",windowClass:"modal-full",controllerAs:"vm",resolve:{modalConfig:function(){return modalConfig}}})}}}]),angular.module("app").controller("ViewDocumentModalCtrl",["$uibModalInstance","modalConfig",function($uibModalInstance,modalConfig){var vm=this;vm.ok=function(){$uibModalInstance.close()},vm.cancel=function(){$uibModalInstance.dismiss()},vm.loadDocument=function(documentId,requestSettings){return vm.loadingDocument=!0,modalConfig.DocumentLoad(documentId,requestSettings).finally(function(){vm.loadingDocument=!1})},vm.downloadDocument=function(documentId){return vm.downloadingDocument=!0,modalConfig.DocumentDownload(documentId).finally(function(){vm.downloadingDocument=!1})},vm.downloadingDocument=!1,vm.model={Title:modalConfig.Title,EnableDownload:!!modalConfig.DocumentDownload,DownloadFileName:modalConfig.DownloadFileName,DocumentId:modalConfig.DocumentId,DisableInlinePdf:modalConfig.DisableInlinePdf}}])}(window.angular),angular.module("app").directive("apDesktopRuler",[function(){"use strict";return{restrict:"E",templateUrl:"/app/partials/desktopRuler/views/apDesktopRuler.html",scope:!0,transclude:!1,link:function(){}}}]),angular.module("app").directive("apFooter",["BrowserService","ConsentRepository","aprgettext","ViewDocumentModal",function(BrowserService,ConsentRepository,gettext,ViewDocumentModal){"use strict";return{restrict:"E",templateUrl:"/app/partials/footer/views/apFooter.html",scope:!0,transclude:!1,link:function(scope){scope.apFooter={},scope.viewPrivacyPolicyImage=function(){scope.isModalDisplayed=!0;var modalConfig={Title:gettext("Privacy Policy"),DocumentId:"privacypolicy",DocumentLoad:function(documentId,requestSettings){return ConsentRepository.getAgreementPrivacyPolicyImage(requestSettings)},DocumentDownload:function(){return ConsentRepository.downloadAgreementPrivacyPolicy().then(function(data){return{Data:data.Data,FileName:"PrivacyPolicy",Extension:"pdf"}}).catch(function(response){scope.addHttpError(response)}).finally(function(){})},DisableInlinePdf:!BrowserService.supportsInlinePdf()};ViewDocumentModal.openViewDocumentModal(modalConfig)},scope.$on("$destroy",function(){})}}}]),angular.module("app").directive("apHeader",["aprgettext","CurrentUserRepository","LogOffService","TransitionManager","SessionService","$rootScope","$log",function(gettext,CurrentUserRepository,LogOffService,TransitionManager,SessionService,$rootScope,$log){"use strict";return{restrict:"E",templateUrl:"/app/partials/header/views/apHeader.html",scope:!0,transclude:!1,link:function(scope){var activeUser,headerDataListener=$rootScope.$on("HeaderData:requested",function(event,requestor){var headerData={activeUserId:scope.apHeader.activeUserId,activeUserFullName:scope.apHeader.activeUserFullName,requestor:requestor};$rootScope.$broadcast("HeaderData:updated",headerData)});activeUser=CurrentUserRepository.getActiveUser(),scope.apHeader={activeUserId:activeUser.id,activeUserFullName:activeUser.fullName,practiceName:""},scope.$on("$destroy",function(){headerDataListener()}),scope.toggleMobileNav=function(){SessionService.setShowMobileNav(!SessionService.getShowMobileNav())},scope.signOff=function(){$log.info("User has selected the Sign Out option from the header drop down menu."),LogOffService.logoff().then(function(){TransitionManager.transition({appRoute:"login"})})}}}}]),angular.module("app").directive("apMobileNav",["$rootScope","SessionService","TransitionManager","LogOffService",function($rootScope,SessionService,TransitionManager,LogOffService){"use strict";return{restrict:"E",templateUrl:"/app/partials/mobileNav/views/apMobileNav.html",scope:!0,transclude:!1,link:function(scope){scope.showMobileNav=SessionService.getShowMobileNav(),scope.headerData={},scope.transitionAndCloseNav=function(transition){TransitionManager.transition(transition),SessionService.setShowMobileNav(!1)};var headerUpdateListener=$rootScope.$on("HeaderData:updated",function(event,data){data&&"apMobileNav"!==(data.requestor||"apMobileNav")||(scope.headerData=data)});scope.signOff=function(){LogOffService.logoff().then(function(){TransitionManager.transition({appRoute:"login"}),SessionService.setShowMobileNav(!1)})},scope.setActiveUser=function(personId){$rootScope.$broadcast("ActiveUser:updated",personId),SessionService.setShowMobileNav(!1)},$rootScope.$broadcast("HeaderData:requested","apMobileNav");var showMobileNavListener=scope.$on("ShowMobileNav:updated",function(event,data){scope.showMobileNav=data});scope.$on("$destroy",function(){showMobileNavListener(),headerUpdateListener()})}}}]),angular.module("app").directive("apToolbar",["$rootScope","$transitions","AppRoutes","TransitionManager",function($rootScope,$transitions,AppRoutes,TransitionManager){"use strict";return{restrict:"E",templateUrl:"/app/partials/toolbar/views/apToolbar.html",scope:!0,transclude:!1,link:function(scope){scope.blankToolbar={IsActive:!1,BackToHome:{IsActive:!1}},$rootScope.hideToolbar;var stateChangeListener=$transitions.onSuccess({},function(transition){var toState=transition.targetState()||{},toStateName=toState&&toState.name()||"",appRoute=_.find(AppRoutes,{state:toStateName});scope.toolbarItem=appRoute&&appRoute.portalSettings&&appRoute.portalSettings.toolbarItem,"blank"===scope.toolbarItem?(_.forEach(scope.notifications,function(toolbarButton){toolbarButton.IsActive=!1}),scope.blankToolbar.IsActive=!0,scope.blankToolbar.BackToHome.IsActive=!0):scope.blankToolbar.IsActive&&resetToolbarState()});function resetToolbarState(){scope.blankToolbar.IsActive=!1,scope.blankToolbar.BackToHome.IsActive=!1}scope.$on("$destroy",function(){stateChangeListener()}),scope.backToHome=function(){resetToolbarState(),TransitionManager.transition({appRoute:"dashboard"})}}}}]),function(angular){"use strict";window.angular.module("app").factory("ContentAttributeService",["UrlParsingService",function(UrlParsingService){return{getClientConfig:function(){return UrlParsingService.parsePortalUrl("/facilityportal/")}}}])}(),angular.module("app").factory("CurrentUserRepository",["storage","$timeout","LocalStorageRepository",function(storage){"use strict";return{getActiveUser:function(){var activeUser=storage.get("activeUser");return{id:activeUser&&activeUser.id,fullName:activeUser&&activeUser.fullName,userName:activeUser&&activeUser.userName,activeDirectoryUser:activeUser&&activeUser.activeDirectoryUser}},setActiveUser:function(id,firstName,lastName,userName,activeDirectoryUser){var activeUser={id:id,fullName:firstName+" "+lastName,userName:userName,activeDirectoryUser:activeDirectoryUser};storage.set("activeUser",activeUser)},removeActiveUse:function(){storage.remove("activeUser")}}}]),function(angular){"use strict";window.angular.module("app").factory("FacilitySettingsService",["$q","FacilitySettingsRepository",function($q,FacilitySettingsRepository){var clinicalSummaryTemplates,settingsPromise;return{getSettings:getSettings,getTemplates:function(){return getSettings().then(function(){return clinicalSummaryTemplates})}};function getSettings(ignoreCache){return!ignoreCache&&settingsPromise?settingsPromise.catch(function(){return settingsPromise=getSettingsFromServer()}):settingsPromise=getSettingsFromServer()}function getSettingsFromServer(){return FacilitySettingsRepository.getSettings().then(function(data){return data?(clinicalSummaryTemplates=data.ClinicalSummaryTemplates,data):$q.reject("Invalid Settings data")})}}])}(),angular.module("app").factory("GatewayFactory",["Restangular","LoginFactory","LocalStorageRepository","configuration","$q","$qHelpers","aprgettext",function(Restangular,LoginFactory,LocalStorageRepository,configuration,$q,$qHelpers,gettext){"use strict";var gateways=_(configuration.GATEWAYS).map(function(gateway){var restangular=Restangular.withConfig(function(){});return restangular.setBaseUrl(gateway.url),restangular.setDefaultHeaders({ApiKey:configuration.API_KEY}),{prefix:gateway.prefix,restangular:restangular}});return{login:function(clientId,username,password,gatewayPrefix,userId){return configuration.DEV_HOSTED?function(clientId,gatewayPrefix){var clientUrl=LocalStorageRepository.getClientURL();if(clientUrl){var deferred=$q.defer();return deferred.resolve(clientUrl),deferred.promise}var filteredGateways=gateways;if(gatewayPrefix&&!(filteredGateways=filteredGateways.filter(function(gateway){return gateway.prefix===gatewayPrefix})).some())return $q.reject(new Error(gettext("Gateway prefix is not recognized.")));var gatewayRequests=filteredGateways.map(function(gateway){return gateway.restangular.one("home",clientId).get()}).map(function(promise){return $qHelpers.timeout(promise,5e3)}).value();return $qHelpers.whenFirstSuccess(gatewayRequests).then(function(serverInfo){return LocalStorageRepository.setClientURL(serverInfo.AppServerUrl),serverInfo.AppServerUrl},function(response){return $q.reject(new Error(gettext("Gateway connection error")+" ("+response.status+")"))})}(clientId,gatewayPrefix).then(loginWithUrl):loginWithUrl(LocalStorageRepository.getClientURL());function loginWithUrl(url){return LocalStorageRepository.clearAll(),LocalStorageRepository.setClientURL(url),LocalStorageRepository.setClientID(clientId),LoginFactory.postLogin(url,clientId,username,password,userId,configuration.CLIENT_FEATURES)}}}}]),function(){"use strict";angular.module("app").factory("LoginFactory",["$log","$q","AprimaRestangular","Bridge","CurrentUserRepository","LocalStorageRepository","aprgettext","ServerInfoRepository","SessionService","VersionService","MultipleUserAccountsError",function($log,$q,AprimaRestangular,Bridge,CurrentUserRepository,LocalStorageRepository,gettext,ServerInfoRepository,SessionService,VersionService,MultipleUserAccountsError){var loginErrorCodes_UnknownClientId=4,loginErrorCodes_LoginFailed=8,loginErrorCodes_InactiveUser=32,loginErrorCodes_NotAllowedToLogin=64,loginErrorCodes_PrmVersionUnsupported=128,loginErrorCodes_MultipleUserAccounts=256;return{postLogin:function(clientURL,_clientId,_username,_password,userId,clientFeatures){return AprimaRestangular.get("facility").one("login").customPOST({Username:_username,Password:_password,ClientId:_clientId,DeviceId:LocalStorageRepository.getDeviceId(),UserId:userId,ClientFeatures:clientFeatures}).then(function(userLoginInfo){var msg,authToken=userLoginInfo.JsonWebToken;return VersionService.checkVersions(userLoginInfo.SupportedApiVersions,userLoginInfo.MinClientVersion).then(function(validationSuccesful){if(!1===validationSuccesful)return $q.reject(new Error(gettext("Client Version not compatible with api server. Please update your app.")));if(userLoginInfo){if(!userLoginInfo.DeviceId)return $q.reject(new Error(gettext("Client Version not compatible with api server. Please update your app.")))}else msg=gettext("Unexpected null result from server in Login");return msg&&($log.warn(msg),Bridge.trackException(msg)),LocalStorageRepository.setIsActiveDirectoryUser(userLoginInfo.IsActiveDirectoryUser),LocalStorageRepository.setDeviceId(userLoginInfo.DeviceId),LocalStorageRepository.setJsonWebToken(authToken),LocalStorageRepository.setUserName(_username),LocalStorageRepository.setUserFullName(userLoginInfo.FirstName+" "+userLoginInfo.LastName),LocalStorageRepository.setUserID(userLoginInfo.Id),function(userLoginInfo){userLoginInfo&&userLoginInfo.ProductVersions&&(userLoginInfo.ProductVersions.PrmAssemblyVersion&&ServerInfoRepository.setPrmAssemblyVersion(userLoginInfo.ProductVersions.PrmAssemblyVersion),userLoginInfo.ProductVersions.PrmDatabaseVersion&&ServerInfoRepository.setPrmDatabaseVersion(userLoginInfo.ProductVersions.PrmDatabaseVersion),userLoginInfo.ProductVersions.PrmDatabaseBuild&&ServerInfoRepository.setPrmDatabaseBuild(userLoginInfo.ProductVersions.PrmDatabaseBuild),userLoginInfo.ProductVersions.AppServiceVersion&&ServerInfoRepository.setMobileAssemblyVersion(userLoginInfo.ProductVersions.AppServiceVersion),userLoginInfo.SupportedFeatures&&ServerInfoRepository.setSupportedFeatures(userLoginInfo.SupportedFeatures))}(userLoginInfo),SessionService.setNewPasswordRequired(userLoginInfo.IsNewPasswordRequired),Bridge.changeUserInfo(authToken,clientURL,userLoginInfo.Id),CurrentUserRepository.setActiveUser(userLoginInfo.Id,userLoginInfo.FirstName,userLoginInfo.LastName,_username,userLoginInfo.IsActiveDirectoryUser),$q.when(userLoginInfo)})}).catch(function(response){var msg=gettext("login error"),errorCode=null;if(401===response.status){if(msg=gettext("Invalid username or password"),(errorCode=angular.isNumber(response.data.ErrorCode)?response.data.ErrorCode:0)&loginErrorCodes_MultipleUserAccounts){var error=new MultipleUserAccountsError(response.data.UserOptions);return $q.reject(error)}errorCode&loginErrorCodes_UnknownClientId?msg=gettext("Unknown clientId ("+_clientId+")."):errorCode&loginErrorCodes_LoginFailed?msg=gettext("Invalid username or password"):errorCode&loginErrorCodes_InactiveUser?msg=gettext("This user account is not active and cannot login."):errorCode&loginErrorCodes_NotAllowedToLogin?msg=gettext("This user account does not have the required permissions to login."):errorCode&loginErrorCodes_PrmVersionUnsupported&&(msg=gettext("PRM version out of date.  Please contact customer support about upgrading."))}return $q.reject(new Error(msg))})}}}])}(),function(){"use strict";function MultipleUserAccountsError(message,userOptions){angular.isArray(message)&&(userOptions=message,message=null),this.name="MultipleUserAccountsError",this.message=message||"Cannot login due to multiple user accounts",this.userOptions=userOptions}(MultipleUserAccountsError.prototype=new Error).constructor=MultipleUserAccountsError,angular.module("app").constant("MultipleUserAccountsError",MultipleUserAccountsError)}(),function(){"use strict";angular.module("app").factory("SearchService",["FacilityPatientRepository",function(FacilityPatientRepository){var service={};return clearLastSearch(),service.clearLastSearch=clearLastSearch,service.getPatients=function(userQuery){var searchCriteria={firstName:userQuery.fName,lastName:userQuery.lName,phoneNumber:userQuery.phoneNum,socialSecurityNumber:userQuery.ssn,medicalRecordNumber:userQuery.mrn,fromDate:userQuery.fromDate,toDate:userQuery.toDate,template:userQuery.template};return FacilityPatientRepository.getPatients(searchCriteria).then(function(data){return service.lastSearch=userQuery,service.lastSearchResults=data})},service;function clearLastSearch(){service.lastSearchResults=[],service.lastSearch={fName:"",lName:"",phoneNum:"",ssn:"",mrn:"",fromDate:"",toDate:""}}}])}(),angular.module("app").factory("SessionService",["$rootScope",function($rootScope){"use strict";var sessionParams={PatientAuthenticated:!1,PracticeConsentAccepted:!1,DisplayDashboardToolbar:!1,ShowHeaderNavigationMenu:!1,NewPasswordRequired:!1,ShowMobileNav:!1};return{resetSessionParams:function(sessionsParams){sessionsParams.NewPasswordRequired=!1},getNewPasswordRequired:function(){return sessionParams.NewPasswordRequired},setNewPasswordRequired:function(value){sessionParams.NewPasswordRequired=value},setShowMobileNav:function(value){sessionParams.ShowMobileNav=value,$rootScope.$broadcast("ShowMobileNav:updated",sessionParams.ShowMobileNav)},getShowMobileNav:function(){return sessionParams.ShowMobileNav}}}]),angular.module("display",["ngCookies","gettext","restangular","lodash","search","aprima-core","aprima-bridge","aprima-config","aprima-legacy-common","aprima-facility-api","aprima-provider-api","aprima-patient-api"]),angular.module("display").config(["AppRoutesProvider","$stateProvider",function(AppRoutesProvider,$stateProvider){"use strict";var appRoutes={display:{state:"display",route:"/display/{patientSearchResult:json}",portalSettings:{hideHeader:!1}}};AppRoutesProvider.setupAppRoutes(appRoutes),$stateProvider.state(appRoutes.display.state,{url:appRoutes.display.route,component:"display"})}]),angular.module("display").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("/display/views/display.html",'<div class="container-fluid">\r\n    <div class="panel panel-primary">\r\n\r\n        <div class="panel-header panel-header-secondary">\r\n            <img class="rounded-corner-md border-width-md extra-dark-grey-border list-item-thumbnail"\r\n                 lazy-src="{{$ctrl.patient.PatientId | apPatientThumbnailSrc:50:50}}">\r\n            <div class="panel-title panel-title-secondary">\r\n                <div class="patient-name">{{$ctrl.patient.FirstName + \' \' + $ctrl.patient.LastName}}</div>\r\n                <ap-date-formatter date="{{$ctrl.patient.BirthDate}}" format="long-date"></ap-date-formatter>\r\n            </div>\r\n        </div>\r\n\r\n        <nav class="navbar navbar-default">\r\n            <div class="navbar-header">\r\n                <button type="button" class="navbar-toggle collapsed" data-toggle="collapse" data-target="#bs-example-navbar-collapse-1" aria-expanded="false">\r\n                    <span class="sr-only">Toggle navigation</span>\r\n                    <span class="icon-bar"></span>\r\n                    <span class="icon-bar"></span>\r\n                    <span class="icon-bar"></span>\r\n                </button>\r\n            </div>\r\n\r\n            <div class="collapse navbar-collapse" id="bs-example-navbar-collapse-1">\r\n                <ul class="nav navbar-nav">\r\n                    <li><a ng-click="$ctrl.backToSearch()"><i class="fa fa-search" aria-hidden="false" style="padding-right: 5px"></i>Back to Search</a></li>\r\n                    <li class="active"><a ng-click="$ctrl.selectPreviousNote()">Previous Note<span class="sr-only">(current)</span></a></li>\r\n                    <li><a ng-click="$ctrl.multiVisitModal()">Download Multiple</a></li>\r\n                </ul>\r\n                <ul class="nav navbar-nav navbar-right">\r\n                    <li><a ng-click="$ctrl.selectNextNote()">Next Note</a></li>\r\n                    <li class="dropdown">\r\n                        <a class="dropdown-toggle" data-toggle="dropdown" role="button" aria-haspopup="true" aria-expanded="false">Notes<span class="caret"></span></a>\r\n                        <ul class="dropdown-menu">\r\n                            <li>\r\n                                <a ng-repeat="visit in $ctrl.visitNoteList" ng-click="$ctrl.selectVisitNote($index)">{{$ctrl.formatDate(visit.Date)}}</a>\r\n                            </li>\r\n                        </ul>\r\n                    </li>\r\n                </ul>\r\n            </div>\r\n        </nav>\r\n\r\n        <div class="panel panel-default panel-flush">\r\n            <div class="panel-body">\r\n                <div class="row">\r\n                    <div class="col-xs-12 col-xs-flush">\r\n                        <ap-document-viewer-with-download\r\n                            disable-inline-pdf="$ctrl.disableInlinePdf"\r\n                            document-id="$ctrl.documentId"\r\n                            enable-download="$ctrl.documentId"\r\n                            document-download="$ctrl.downloadVisit(documentId)"\r\n                            document-load="$ctrl.getVisit(documentId)"\r\n                        ></ap-document-viewer-with-download>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n\r\n    </div>\r\n</div>')}]),function(angular){"use strict";window.angular.module("display").component("display",{bindings:{},templateUrl:"/display/views/display.html",controller:["$stateParams","aprgettext","BrowserService","DisplayService","FacilityVisitRepository","MultiDownloadModal","toaster","TransitionManager",function($stateParams,gettext,BrowserService,DisplayService,FacilityVisitRepository,MultiDownloadModal,toaster,TransitionManager){var vm=this;function selectVisitNote(index){var visit=vm.visitNoteList[index];visit&&(vm.documentId=visit.VisitId,vm.currentVisitNoteIndex=index)}vm.currentVisitNoteIndex=null,vm.documentId=null,vm.disableInlinePdf=!BrowserService.supportsInlinePdf(),vm.formattingTemplateId=null,vm.patient=null,vm.patientName="",vm.multiVisit={selectedList:[],sourceList:[],value:"",label:"",all:!0,sortBy:"Date",patientId:"",externalId:""},vm.$onInit=function(){$stateParams.patientSearchResult&&(vm.patient=$stateParams.patientSearchResult.patient,vm.formattingTemplateId=$stateParams.patientSearchResult.formattingTemplateId);vm.patient&&(vm.patientName=vm.patient.FirstName+" "+vm.patient.LastName.substring(0,vm.patient.LastName.length-2),vm.documentId=vm.patient.VisitId);DisplayService.getOrderedVisitNoteList(vm.patient.PatientId).then(function(orderedVisitNoteList){if(orderedVisitNoteList.success){if(vm.visitNoteList=orderedVisitNoteList.data,vm.currentVisitNoteIndex=null,vm.visitNoteList&&vm.visitNoteList.length)for(var i=0;i<vm.visitNoteList.length;i++)if(vm.visitNoteList[i].VisitId===vm.documentId){vm.currentVisitNoteIndex=i;break}}else toaster.pop("error","","Failed to get Notes")})},vm.backToSearch=function(){TransitionManager.transition({appRoute:"search"})},vm.downloadVisit=function(documentId){return FacilityVisitRepository.getVisitPdf(documentId,vm.patient.PatientId,vm.formattingTemplateId).catch(function(){toaster.pop("error","",gettext("An error occurred while downloading visit.  Please try again or contact your practice for further assistance."))})},vm.formatDate=function(date){return date.format("YYYY-MM-DD")},vm.getVisit=function(documentId){return FacilityVisitRepository.getVisitPdf(documentId,vm.patient.PatientId,vm.formattingTemplateId)},vm.multiVisitModal=function(){vm.multiVisit.formattingTemplateId=vm.formattingTemplateId,vm.multiVisit.sourceList=vm.visitNoteList,vm.multiVisit.patientId=vm.patient.PatientId,vm.multiVisit.externalId=vm.patient.ExternalId,MultiDownloadModal.openMultiModal(vm.multiVisit).then(function(result){"error"===result&&toaster.pop("error","",gettext("An error occurred while downloading visit.  Please try again or contact your practice for further assistance.")),"success"===result&&toaster.pop("success","",gettext("Download successful. Please check your downloads folder for your file."))})},vm.selectNextNote=function(){var nextIndex=vm.visitNoteList&&vm.visitNoteList.length&&(vm.currentVisitNoteIndex||0===vm.currentVisitNoteIndex)?vm.currentVisitNoteIndex+1:null;null!==nextIndex&&nextIndex<vm.visitNoteList.length?selectVisitNote(nextIndex):toaster.warning("This is the last note")},vm.selectPreviousNote=function(){var previousIndex=vm.visitNoteList&&vm.visitNoteList.length&&(vm.currentVisitNoteIndex||0===vm.currentVisitNoteIndex)?vm.currentVisitNoteIndex-1:null;null!==previousIndex&&0<=previousIndex?selectVisitNote(previousIndex):toaster.warning("This is the first note")},vm.selectVisitNote=selectVisitNote}]})}(),function(){"use strict";angular.module("display").factory("DisplayService",["_","FacilityVisitRepository",function(_,FacilityVisitRepository){return{getOrderedVisitNoteList:function(patientId){return FacilityVisitRepository.getVisitNoteList(patientId).then(function(data){var visitList=data;if(null===visitList)return visitList;var processedVisitList=[];return _.each(visitList,function(visit){processedVisitList.push({VisitId:visit.VisitId,Date:moment(visit.Date)})}),processedVisitList.sort(function(a,b){return b.Date-a.Date}),{success:!0,data:processedVisitList}})}}}])}(),angular.module("login",["app","ngCookies","gettext","restangular","lodash","aprima-core","aprima-bridge","aprima-config","aprima-facility-api","aprima-legacy-common","aprima-provider-api","aprima-patient-api"]),angular.module("login").config(["AppRoutesProvider","$stateProvider",function(AppRoutesProvider,$stateProvider){"use strict";var appRoutes={login:{state:"login",route:"/login",portalSettings:{hideToolbar:!0,hideHeader:!0,toolbarItem:"login"}}};AppRoutesProvider.setupAppRoutes(appRoutes),$stateProvider.state(appRoutes.login.state,{url:appRoutes.login.route,component:"login"})}]),angular.module("login").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("/login/views/login.html",'\ufeff<div class="body" ng-cloak>\r\n    <div id="login-container" class="container-fluid" ap-login-background client-Id="model.clientID">\r\n        <div class="row">\r\n            <div class="col-xs-12 col-xs-flush col-md-6 col-md-offset-3">\r\n                <div id="login-header" class="logo-group">\r\n                    <div class="row">&nbsp;</div>\r\n                    <div class="modal-dialog modal-dialog-login">\r\n                        <div class="row">\r\n                            <div class="col-xs-12 col-xs-flush col-md-10">\r\n                                <div class="modal-content">\r\n                                    <div class="modal-header">\r\n                                        <div class="text-center">\r\n                                            <img src="images/spacer.png" class="login-image">\r\n                                            <title>{{::\'Login\' | translate}}</title>\r\n                                            <div class="modal-subtitle" id="myModalLabel2" ng-if="model.practiceName">\r\n                                                {{model.practiceName}}\r\n                                            </div>\r\n                                        </div>\r\n                                    </div>\r\n                                    <div class="modal-body">\r\n                                        <form id="login-form" name="loginForm" ap-form-focus ng-submit="$ctrl.login()"\r\n                                              novalidate>\r\n                                            <div ng-if="!$ctrl.selectUserMode">\r\n                                                <div class="form-group"\r\n                                                     ng-class="{ \'has-error\' : loginForm.userName.$invalid && submitted}">\r\n\r\n                                                    <label for="userName">{{::\'Username\' | translate}}</label>\r\n\r\n                                                    <input type="text" class="form-control" name="userName"\r\n                                                           ng-model="$ctrl.model.username"\r\n                                                           placeholder="{{\'Username\' | translate}}"\r\n                                                           id="userName"\r\n                                                           ng-change="model.userId = null;"\r\n                                                           required>\r\n\r\n                                                    <span ng-show="loginForm.userName.$invalid && submitted"\r\n                                                          class="text-danger ng-hide">\r\n                                                        {{::\'Not valid.\' | translate}}\r\n                                                    </span>\r\n                                                </div>\r\n\r\n                                                <div class="form-group"\r\n                                                     ng-class="{ \'has-error\' : loginForm.passwordInput.$invalid && submitted}">\r\n                                                    <label for="passwordInput">{{::\'Password\' | translate}}</label>\r\n\r\n                                                    <input type="password" class="form-control" name="passwordInput"\r\n                                                           ng-model="$ctrl.model.password"\r\n                                                           id="passwordInput"\r\n                                                           placeholder="{{\'Password\' | translate}}"\r\n                                                           required>\r\n                                                    <b class="tooltip tooltip-top-right">\r\n                                                        <i class="fa fa-lock txt-color-teal"></i>\r\n                                                        {{::\'Enter your password\' | translate}}\r\n                                                    </b>\r\n                                                    <span ng-show="loginForm.passwordInput.$invalid && submitted"\r\n                                                          class="help-block ng-hide">\r\n                                                        {{::\'Not valid.\' | translate}}\r\n                                                    </span>\r\n                                                </div>\r\n                                            </div>\r\n                                            <div ng-if="$ctrl.selectUserMode">\r\n                                                <div class="form-group">\r\n                                                    <label for="$ctrl.userOption">{{::\'Select User\' | translate}}</label>\r\n                                                    <ap-select>\r\n                                                    <select class="form-control" name="userOption"\r\n                                                        ng-model="$ctrl.model.userId"\r\n                                                        id="userOption"\r\n                                                        placeholder="{{\'Select User\' | translate}}"\r\n                                                        ng-options="user.UserId as (user.LastName + \', \' + user.FirstName) for user in $ctrl.userOptions"\r\n                                                        ap-required="true">\r\n                                                    </select>\r\n                                                    </ap-select>\r\n                                                    <span ng-show="form.password.$invalid && form.$submitted"\r\n                                                        class="help-block ng-hide">\r\n                                                        {{::\'Not valid.\' | translate}}\r\n                                                    </span>\r\n                                                </div>\r\n                                                <div class="text-left">\r\n                                                    <span translate>\r\n                                                        Your login is associated with multiple users. Please select the user you would like to login as.\r\n                                                    </span>\r\n                                                </div>\r\n                                            </div>   \r\n                                            <div class="text-center">\r\n                                                <span class="text-danger ng-hide"\r\n                                                      ng-show="loginForm.passwordInput.$invalid && submitted">\r\n                                                    {{::\'Login could not be completed.\' | translate}}\r\n                                                </span>\r\n\r\n                                                <div ng-show="$ctrl.errorMessage" class="ng-hide">\r\n                                                    <span class="text-danger keep-whitespace-line">\r\n                                                        {{$ctrl.errorMessage | translate}}\r\n                                                    </span>\r\n                                                </div>\r\n                                            </div>\r\n                                            <div>\r\n                                                <button type="submit" class="btn btn-primary btn-lg btn-block btn-login"\r\n                                                        ng-disabled="$ctrl.loading">\r\n                                                    <span class="ng-hide" ng-show="$ctrl.loading"><ap-spinner></ap-spinner></span>\r\n                                                    {{\'Login\' | translate}}\r\n                                                </button>\r\n                                            </div>\r\n                                        </form>\r\n                                    </div>\r\n                                </div>\r\n                            </div>\r\n                        </div>\r\n                    </div>\r\n                </div>\r\n            </div>\r\n        </div>\r\n        \x3c!-- Below is a hack to get the android webview to behave properly while logging in.\r\n        If this is removed, it will cause random whitespace to appear after login.  Please don\'t remove. --\x3e\r\n        <div class="row" style="overflow: hidden; min-height: 1px;">\r\n            <div class="col-xs-12 col-sm-10 col-sm-offset-1 col-md-6 col-md-offset-3"\r\n                 style="margin-bottom: -99999px; padding-bottom: 99999px;"></div>\r\n        </div>\r\n    </div>\r\n</div>\r\n')}]),function(){"use strict";angular.module("login").component("login",{bindings:{},templateUrl:"/login/views/login.html",controller:["$rootScope","Bridge","configuration","ContentAttributeService","FacilitySettingsService","GatewayFactory","gettext","LocalStorageRepository","SearchService","SessionService","TransitionManager","MultipleUserAccountsError",function($rootScope,Bridge,configuration,ContentAttributeService,FacilitySettingsService,GatewayFactory,gettext,LocalStorageRepository,SearchService,SessionService,TransitionManager,MultipleUserAccountsError){var vm=this;vm.errorMessage="",vm.submitted=!1,vm.loading=!1,vm.loadingAssistance=!1,vm.loginAssistanceInfo=null,vm.model={},vm.practiceName=null,vm.selectUserMode=!1,vm.$onInit=function(){vm.model={clientID:LocalStorageRepository.getClientID()||"0",username:LocalStorageRepository.getUserName()||"",userId:LocalStorageRepository.getUserID()||null,password:"",gateway:null},vm.gateways=_.map(_.cloneDeep(configuration.GATEWAYS),function(g){return g.display=g.prefix+" - "+g.url,g}),configuration.DEV_HOSTED||ContentAttributeService.getClientConfig().then(function(data){var oldClientId=LocalStorageRepository.getClientID(),newClientId=data.clientId;oldClientId!==newClientId&&LocalStorageRepository.clearAll(),LocalStorageRepository.setClientURL(data.hostUrl),LocalStorageRepository.setClientID(newClientId),vm.model.clientID=newClientId}).catch(function(){vm.errorMessage=gettext("Error loading page. Unknown Client Id"),Bridge.createModalAlert({title:gettext("Loading Error"),message:vm.errorMessage,buttons:[gettext("Okay")]})})},vm.login=function(){vm.errorMessage=null,vm.loading=!0;var userId=vm.selectUserMode?vm.model.userId:null;GatewayFactory.login(vm.model.clientID,vm.model.username,vm.model.password,vm.model.gateway?vm.model.gateway.prefix:null,userId).then(function(){FacilitySettingsService.getSettings(!0).then(function(data){data&&data.ClinicalSummaryTemplates&&data.ClinicalSummaryTemplates.length?(SearchService.clearLastSearch(),!0===SessionService.getNewPasswordRequired()?TransitionManager.transition({appRoute:"changepassword"}):($rootScope.$broadcast("IdleStartWatch"),TransitionManager.transition({appRoute:"search"}))):vm.errorMessage="Facility portal settings invalid,\n contact practice"}).catch(function(err){vm.errorMessage=err.message,Bridge.createModalAlert({title:gettext("Facility portal settings invalid,\n contact practice"),message:err.message,buttons:[gettext("Okay")]})})}).catch(function(err){err instanceof MultipleUserAccountsError?(vm.selectUserMode=!0,vm.userOptions=err.userOptions):(vm.errorMessage=err.message,Bridge.createModalAlert({title:gettext("Login Error"),message:err.message,buttons:[gettext("Okay")]}))}).finally(function(){vm.loading=!1})}}]})}(),angular.module("login").factory("LoginService",["LocalStorageRepository","$q","$location",function(LocalStorageRepository,$q,$location){"use strict";return{getClientConfig:function(){var splitResult=$location.absUrl().toLowerCase().split("/portal/");if(2!==splitResult.length)return $q.when(!1);var hostUrl=splitResult[0],clientConfig={ClientId:splitResult[1].split("/")[0],HostUrl:hostUrl};return $q.when(clientConfig)}}}]),angular.module("search",["app","ngCookies","gettext","restangular","lodash","aprima-core","aprima-bridge","aprima-config","aprima-legacy-common","aprima-facility-api","aprima-provider-api","aprima-patient-api"]),angular.module("search").config(["AppRoutesProvider","$stateProvider",function(AppRoutesProvider,$stateProvider){"use strict";var appRoutes={search:{state:"search",route:"/search",portalSettings:{hideToolbar:!0,hideHeader:!1}}};AppRoutesProvider.setupAppRoutes(appRoutes),$stateProvider.state(appRoutes.search.state,{url:appRoutes.search.route,component:"search"})}]),angular.module("search").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("/search/views/search.html",'<div class="text-center" ng-if="$ctrl.loadingTemplates">\r\n    <ap-spinner size="3"></ap-spinner>\r\n</div>\r\n<div ng-if="!$ctrl.loadingTemplates" class="container panel panel-default">\r\n    <div ng-class="{ \'alert\': flash, \'alert-success\': flash.type === \'success\', \'alert-danger\': flash.type === \'error\' }" ng-if="flash" ng-bind="flash.message"></div>\r\n    <p></p>\r\n    <div class="row">\r\n        <div id="searchHeading">\r\n            <h4>\r\n                {{::\'Search Patients\' | translate}}\r\n            </h4>\r\n        </div>  \r\n    </div>\r\n    <div class="row">\r\n        <form name="form" ng-submit="$ctrl.search()" role="form">\r\n            <div class="row">\r\n                <div class="input-field col col-xs-12 col-md-6 panel-row-bottom">\r\n                    <label for="lName" class="active">{{::\'Last Name\' | translate}}</label>\r\n                    <input id="lName" value="" type="text" class="validate form-control" ng-model="$ctrl.lastSearch.lName" />\r\n                </div>\r\n                <div class="input-field col col-xs-12 col-md-6 panel-row-bottom">\r\n                    <label for="fName" class="active">{{::\'First Name\' | translate}}</label>\r\n                    <input id="fName" type="text" class="validate form-control" ng-model="$ctrl.lastSearch.fName">\r\n                </div>\r\n            </div>\r\n            <div class="row">\r\n                <div class="input-field col col-xs-12 panel-row-bottom">\r\n                    <label class="active" for="phoneNum">{{::\'Phone\' | translate}}</label>\r\n                    <input id="phoneNum" type="text" placeholder="(xxx)xxx-xxxx" class="validate form-control" ng-model="$ctrl.lastSearch.phoneNum">\r\n                </div>\r\n            </div>\r\n            <div class="row">\r\n                <div class="input-field col col-xs-12 panel-row-bottom">\r\n                    <label class="active" for="ssn">{{::\'SSN\' | translate}}</label>\r\n                    <input id="ssn" type="text" placeholder="xxx-xx-xxxx" class="validate form-control" ng-model="$ctrl.lastSearch.ssn">\r\n                </div>\r\n            </div>\r\n            <div class="row">\r\n                <div class="input-field col col-xs-12 panel-row-bottom">\r\n                    <label for="mrn" class="active">{{::\'MRN\' | translate}}</label>\r\n                    <input id="mrn" type="text" class="validate form-control active" ng-model="$ctrl.lastSearch.mrn">\r\n                </div>\r\n            </div>\r\n            <div class="row">\r\n                <div class="input-field col col-xs-12 col-md-6">\r\n                    <label class="active" for="fromdate">{{::\'With visit notes from\' | translate}}</label>\r\n                    <input id="fromdate" type="text" placeholder="Forever" class="validate form-control" ng-model="$ctrl.lastSearch.fromDate">\r\n                </div>\r\n                <div class="input-field col col-xs-12 col-md-6">\r\n                    <label class="active" for="todate">{{::\'To\' | translate}}</label>\r\n                    <input id="todate" type="text" placeholder="Today" class="validate form-control" ng-model="$ctrl.lastSearch.toDate">\r\n                </div>\r\n            </div>\r\n            <p></p>\r\n            <div class="row">\r\n                <div class="form-actions col-md-1">\r\n                    <button type="button" ng-click="$ctrl.clear()" class="waves-effect waves-light btn pull-left btn-search-main" >\r\n                        {{::\'Clear\' | translate}}\r\n                    </button>\r\n                </div>\r\n                <div class="col-md-offset-7 col-md-3">\r\n                    <ap-select>\r\n                       <select id="formattingTemplateDropdown" class="form-control" name="templateDropdown"\r\n                                ng-model="$ctrl.lastSearch.template" ng-options="template.Name for template in $ctrl.templates"\r\n                                ap-required="true">\r\n                        </select>\r\n                    </ap-select>\r\n                </div>\r\n                <div class="form-actions col-md-1">\r\n                    <button id="searchSearchButton" type="submit" ng-disable="$ctrl.dataLoading" \r\n                            class="waves-effect waves-light btn btn-primary pull-right btn-search-main" >\r\n                        {{::\'Search\' | translate}}\r\n                    </button>\r\n                </div>\r\n            </div>\r\n        </form>\r\n    </div>\r\n    <div class="text-center" ng-show="$ctrl.dataLoading">\r\n        <ap-spinner size="3"></ap-spinner>\r\n    </div>\r\n    <div ng-show="!$ctrl.dataLoading" class="card">\r\n        <div class="card-content">\r\n            <table id="example" class="highlight mdl-data-table" cellspacing="0" width="100%">\r\n                <thead>\r\n                <tr>\r\n                    <th>{{::\'ID\' | translate}}</th>\r\n                    <th>{{::\'Name\' | translate}}</th>\r\n                    <th>{{::\'DOB\' | translate}}</th>\r\n                    <th>{{::\'Most Recent Visit Date\' | translate}}</th>\r\n                    <th></th>\r\n                    <th></th>\r\n                </tr>\r\n                </thead>\r\n                <tbody>\r\n                <tr ng-repeat="result in $ctrl.searchResults | orderBy:[\'LastName\', \'FirstName\']">\r\n                    <td>{{::result.ExternalId}}</td>\r\n                    <td ng-click="$ctrl.display(result)" class="clickable"><span>{{::result.FirstName}}</span>\r\n                        <span>{{::result.LastName}}</span></td>\r\n                    <td><ap-date-formatter date="{{::result.BirthDate}}" format="short-date"></ap-date-formatter></td>\r\n                    <td><ap-date-formatter date="{{::result.VisitDate}}" format="short-date"></ap-date-formatter>\r\n                        <span ng-if="$ctrl.isActiveDirectoryUser && !result.IsCompletedVisit"> {{::\'(Incomplete Visit)\' | translate}}</span>\r\n                    </td>\r\n\r\n                    </td>\r\n                    <td class="text-center">\r\n                        <button ng-if="!result.Downloaded" ap-save-to-file="$ctrl.downloadVisit(result)">\r\n                            <i ng-show="!result.Downloading" class="fa fa-download"></i>\r\n                            <ap-spinner ng-show="result.Downloading"></ap-spinner>\r\n                        </button>\r\n                        <i ng-show="!result.Downloading && result.Downloaded" class="fa fa-download green"></i>\r\n                    </td>\r\n                    <td>\r\n                        <button class="btn btn-default" ng-click="$ctrl.display(result)"><span translate>View</span></button>\r\n                    </td>\r\n                </tr>\r\n                </tbody>\r\n            </table>\r\n            <div ng-show="$ctrl.searchResults.length === 0 && !$ctrl.dataLoading">\r\n                {{::\'No Matches Found\' | translate}}\r\n            </div>\r\n        </div>\r\n    </div>\r\n</div>')}]),function(){"use strict";angular.module("search").component("search",{bindings:{},templateUrl:"/search/views/search.html",controller:["aprgettext","FacilitySettingsService","FacilityVisitRepository","LocalStorageRepository","LogOffService","moment","SearchService","toaster","TransitionManager","$q","_",function(gettext,FacilitySettingsService,FacilityVisitRepository,LocalStorageRepository,LogOffService,moment,SearchService,toaster,TransitionManager,$q,_){var vm=this;function clear(){SearchService.clearLastSearch(),vm.lastSearch.fName="",vm.lastSearch.lName="",vm.lastSearch.phoneNum="",vm.lastSearch.ssn="",vm.lastSearch.mrn="",vm.lastSearch.fromDate="",vm.lastSearch.toDate="",vm.searchResults=[]}function search(){""!==vm.lastSearch.fName||""!==vm.lastSearch.lName||""!==vm.lastSearch.phoneNum||""!==vm.lastSearch.ssn||""!==vm.lastSearch.mrn||""!==vm.lastSearch.fromDate||""!==vm.lastSearch.toDate?(vm.dataLoading=!0,vm.userQuery={fName:vm.lastSearch.fName,lName:vm.lastSearch.lName,phoneNum:vm.lastSearch.phoneNum,ssn:vm.lastSearch.ssn,mrn:vm.lastSearch.mrn,fromDate:vm.lastSearch.fromDate,toDate:vm.lastSearch.toDate,template:vm.lastSearch.template},SearchService.getPatients(vm.userQuery).then(function(data){vm.searchResults=_(data.plain()).map(function(result){return _.assign(result,{Downloading:!1,Downloaded:!1})}).value()}).catch(function(){toaster.pop("error","",gettext("An error occurred while searching.  Please try again or contact your practice for further assistance."))}).finally(function(){vm.dataLoading=!1})):toaster.pop("error","","Please enter search terms")}function downloadVisit(result){return 4<vm.downloadingCounter?(toaster.pop("warn","",gettext("Maximum downloading visits have been reached. Please try again momentarily.")),$q.reject("Maximum downloading visits have been reached. Please try again momentarily.")):vm.lastSearch.template&&vm.lastSearch.template.FormattingTemplateUid?(vm.downloadingCounter++,result.Downloading=!0,FacilityVisitRepository.getVisitPdf(result.VisitId,result.PatientId,vm.lastSearch.template.FormattingTemplateUid).then(function(data){return result.Downloaded=!0,{Data:data.Data,Extension:data.Extension,FileName:result.ExternalId+"_Visit_"+moment(result.VisitDate).format("l")}}).catch(function(){toaster.pop("error","",gettext("An error occurred while downloading visit.  Please try again or contact your practice for further assistance."))}).finally(function(){result.Downloading=!1,vm.downloadingCounter--})):(toaster.pop("warn","",gettext("No template selected.")),$q.reject("No template selected."))}function logout(){LogOffService.logoff(),TransitionManager.transition({appRoute:"login"})}function display(result){SearchService.lastSearch.template=vm.lastSearch.template;var patientSearchResult={patient:result,formattingTemplateId:vm.lastSearch.template.FormattingTemplateUid};TransitionManager.transition({appRoute:"display",opts:{patientSearchResult:patientSearchResult}})}vm.$onInit=function(){vm.loadingTemplates=!0,vm.searchResults=SearchService.lastSearchResults,vm.lastSearch=SearchService.lastSearch,vm.patient=[],vm.isActiveDirectoryUser=LocalStorageRepository.getIsActiveDirectoryUser(),vm.downloadingCounter=0,vm.clear=clear,vm.search=search,vm.logout=logout,vm.display=display,vm.downloadVisit=downloadVisit,FacilitySettingsService.getTemplates().then(function(data){vm.templates=data,vm.lastSearch.template||(vm.lastSearch.template=vm.templates&&vm.templates[0]),vm.lastSearch.template||toaster.error("The practice has not configured any Formatting Models.")}).finally(function(){vm.loadingTemplates=!1})}}]})}(),angular.module("all",["ngFacilityPortal","account","app","display","login","search","ngIdle","ui.bootstrap","aprima-legacy-common","aprima-provider-api","aprima-core-ui","aprima-patient-api","aprima-utils"]),angular.module("all").run(["CustomModuleRunService",function(CustomModuleRunService){"use strict";CustomModuleRunService.add(["$log","$rootScope","AppRoutes","_","Idle","LogOffService","$transitions","TransitionManager",function($log,$rootScope,AppRoutes,_,Idle,LogOffService,$transitions,TransitionManager){$rootScope.hideToolbar=!0,$rootScope.hideHeader=!0,$transitions.onStart({},function(transition){var appRoute=_.find(AppRoutes,{state:transition.to().name});$rootScope.hideHeader=!!(appRoute&&appRoute.portalSettings&&appRoute.portalSettings.hideHeader),$rootScope.hideFooter=!!(appRoute&&appRoute.portalSettings&&appRoute.portalSettings.hideFooter),$rootScope.loginView=!(!appRoute||!appRoute.state||"login"!==appRoute.state),$rootScope.loginView||$rootScope.$broadcast("IdleStartWatch")}),$rootScope.$on("IdleTimeout",function(){$log.info("Idle timeout has expired.  Logging client out and transitioning to login view.  "+moment().format("lll")),Idle.running()&&Idle.unwatch(),LogOffService.logoff().then(function(){TransitionManager.transition({appRoute:"login"})})}),$rootScope.$on("IdleStartWatch",function(){Idle.watch()})}])}]),angular.module("all").config(["$urlRouterProvider","$urlServiceProvider","AppRoutesProvider",function($urlRouterProvider,$urlServiceProvider,AppRoutesProvider){"use strict";var appRoutes=AppRoutesProvider.getAppRoutes();$urlRouterProvider.when("",appRoutes.login.route).when("/",appRoutes.login.route),$urlServiceProvider.deferIntercept()}]);
//# sourceMappingURL=aprima-facilityportal.min.js.map