﻿<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
  <xsl:output method="html" encoding="UTF-8"/>
  <xsl:template match="/">
    <link href="ActivityMonitor.css" type="text/css" rel="stylesheet"/>
    <table width="100%">
      <thead>
        <tr>
          <td>
            Private
          </td>
          <td>
            Virtual
          </td>
          <td>
            Handles
          </td>
          <td>
            Gen 0
          </td>
          <td>
            Gen 1
          </td>
          <td>
            Gen 2
          </td>
          <td>
            Large
          </td>
        </tr>
      </thead>
      <tbody>
        <tr class="oddrow">
          <xsl:for-each select="process/memory">
            <td>
              <xsl:value-of select="@private_mb"/>mb
            </td>
            <td>
              <xsl:value-of select="@virtual_mb"/>mb
            </td>
          </xsl:for-each>
          <xsl:for-each select="process/garbage_collector">
            <td>
              <xsl:value-of select="@handles"/>
            </td>
            <td>
              <xsl:value-of select="@gen0"/>
            </td>
            <td>
              <xsl:value-of select="@gen1"/>
            </td>
            <td>
              <xsl:value-of select="@gen2"/>
            </td>
            <td>
              <xsl:value-of select="@large"/>
            </td>
          </xsl:for-each>
        </tr>
      </tbody>
    </table>
    Network
    <xsl:choose>
      <xsl:when test="process/instance/categoryName[@name='.NET CLR Networking 4.0.0.0']/counter">
        <table>
          <thead>
            <tr>
              <td class="rightborder">
                Sent
              </td>
              <td class="rightborder">
                Received
              </td>
              <td>
                Connections
              </td>
              <td>
                Compression
              </td>
            </tr>        
          </thead>
          <tbody>
            <tr class="evenrow">
              <xsl:for-each select="process/instance/categoryName[@name='.NET CLR Networking 4.0.0.0']/counter">
                <td class="rightborder">
                  <xsl:value-of select="@value"/>
                </td>
              </xsl:for-each>
            </tr>
          </tbody>
        </table>
      </xsl:when>
      <xsl:otherwise>
        <table>
          <tr>
            <td>
              The Performance Counters are not enabled
            </td>
          </tr>          
        </table>
      </xsl:otherwise>
    </xsl:choose>
    SQL Server
    <table>
      <thread>
        <tr>
          <td class="rightborder">
            <b>Pool</b>
          </td>
          <td colspan="2" align="center" class="rightborder">
            <b>Active</b>
          </td>
          <td colspan="2" class="rightborder">
            <b>Connections</b>
          </td>
          <td>
            <b>Max</b>
          </td>
        </tr>
        <tr>
          <td class="rightborder">
            <b>Groups</b>
          </td>
          <td class="rightborder">
            <b>Pools</b>
          </td>
          <td class="rightborder">
            <b>Connections</b>
          </td>
          <td class="rightborder">
            <b>Free</b>
          </td>
          <td class="rightborder">
            <b>Pooled</b>
          </td>
          <td>
            <b>Pool Size</b>
          </td>
        </tr>
      </thread>
      <tbody>
        <tr class="oddrow">
          <xsl:for-each select="process/instance/categoryName[@name='.NET Data Provider for SqlServer']/counter">
            <td class="rightborder">
              <xsl:value-of select="@value"/>
            </td>
          </xsl:for-each>
        </tr>
      </tbody>
    </table>
  </xsl:template>
</xsl:stylesheet>