﻿<?xml version="1.0"?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="html" encoding="UTF-8"/>
<xsl:template match="/">
<link href="ActivityMonitor.css" type="text/css" rel="stylesheet"/>
<table width="100%">
  <thead>
    <tr>
      <td width="45%">
        Type Name
      </td>
      <td width="20%">
        Machine Name
      </td>
      <td width="15%">
        Job Schedule
      </td>
      <td width="10%">
        Start
      </td>
      <td width="10%">
        Duration
      </td>
    </tr>
  </thead> 
  <tbody>
	<xsl:for-each select="RunningTasks/asynctask">
    <tr>
      <xsl:if test="position() mod 2 = 0">
        <xsl:attribute name="class">oddrow</xsl:attribute>
      </xsl:if>
      <xsl:if test="position() mod 2 = 1">
        <xsl:attribute name="class">evenrow</xsl:attribute>
      </xsl:if>
      <td>
        <xsl:attribute name="title">ID = <xsl:value-of select="@ID"/></xsl:attribute>
        <xsl:choose>
          <xsl:when test="@hasData = 'True'">
            <a>
              <xsl:choose>
                <xsl:when test="@xslfile != ''">
                  <xsl:attribute name="href">
                    <xsl:value-of select="@xslfile" />?uid=<xsl:value-of select="@ID"/>
                  </xsl:attribute>
                </xsl:when>
                <xsl:otherwise>
                  <xsl:attribute name="href">
                    task.xml?uid=<xsl:value-of select="@ID"/>
                  </xsl:attribute>
                </xsl:otherwise>
              </xsl:choose>
              <xsl:attribute name="target">_blank</xsl:attribute>
              <xsl:value-of select="@typeName" />
              <xsl:if test="@method != ''">
                (<xsl:value-of select="@method"/>)
              </xsl:if>
            </a>
          </xsl:when>
          <xsl:otherwise>
            <xsl:value-of select="@typeName" />
            <xsl:if test="@method != ''">
              (<xsl:value-of select="@method"/>)
            </xsl:if>
          </xsl:otherwise>
        </xsl:choose>
      </td>
      <td>
        <xsl:value-of select="@machineName" />
      </td>
      <TD valign="top">
        <xsl:value-of select="@jobScheduleName" />
      </TD>
      <TD valign="top">
        <xsl:value-of select="@start" />
      </TD>
      <TD valign="top">
        <xsl:value-of select="@duration" />
      </TD>
    </tr>
    <xsl:if test="@statusMessage != ''">
      <tr>
        <xsl:if test="position() mod 2 = 0">
          <xsl:attribute name="class">oddrow</xsl:attribute>
        </xsl:if>
        <xsl:if test="position() mod 2 = 1">
          <xsl:attribute name="class">evenrow</xsl:attribute>
        </xsl:if>
        <td style="border-top-width: 0px" colspan="6">
          Status: <xsl:value-of select="@statusMessage" />
        </td>
      </tr>
    </xsl:if>
	</xsl:for-each>
  </tbody>
</table>
  <xsl:for-each select="RunningTasks">
    <B>
      Total Tasks Running: <xsl:value-of select="@count" />
    </B>
  </xsl:for-each>
</xsl:template>
</xsl:stylesheet>
