<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xs="http://www.w3.org/2001/XMLSchema" exclude-result-prefixes="xs">
	<xsl:output method="xml" encoding="UTF-8" indent="yes"/>
	<xsl:template match="/">
		<SCH>
			<xsl:for-each select="visit">
				<SCH.1>
					<xsl:value-of select="string(@id)"/>
				</SCH.1>
			</xsl:for-each>
			<SCH.3>
				<xsl:for-each select="visit">
					<SCH.3.1>
						<xsl:value-of select="string(@columnheading)"/>
					</SCH.3.1>
				</xsl:for-each>
			</SCH.3>
			<SCH.7>
				<xsl:for-each select="visit">
					<SCH.7.1>
						<xsl:value-of select="string(@comments)"/>
					</SCH.7.1>
				</xsl:for-each>
			</SCH.7>
			<xsl:for-each select="visit">
				<SCH.8>
					<xsl:value-of select="string(@appointmenttype)"/>
				</SCH.8>
			</xsl:for-each>
			<SCH.11>
				<xsl:for-each select="visit">
					<SCH.11.1>
						<xsl:value-of select="string(@visitstartdatetime)"/>
					</SCH.11.1>
				</xsl:for-each>
				<xsl:for-each select="visit">
					<SCH.11.2>
						<xsl:value-of select="string(@date)"/>
					</SCH.11.2>
				</xsl:for-each>
			</SCH.11>
			<xsl:for-each select="visit">
				<SCH.25>
					<xsl:value-of select="string(@apptstatus)"/>
				</SCH.25>
			</xsl:for-each>
			<PID>
				<xsl:for-each select="visit">
					<PID.2>
						<xsl:value-of select="string(patientlist/patient/@id)"/>
					</PID.2>
				</xsl:for-each>
				<xsl:for-each select="visit">
					<PID.3>
						<xsl:value-of select="string(patientlist/patient/@id)"/>
					</PID.3>
				</xsl:for-each>
				<PID.5>
					<xsl:for-each select="visit">
						<PID.5.1>
							<xsl:value-of select="substring-before(string(patientlist/patient/@name), ',')"/>
						</PID.5.1>
					</xsl:for-each>
					<xsl:for-each select="visit">
						<PID.5.2>
							<xsl:value-of select="substring-after(string(patientlist/patient/@name), ',')"/>
						</PID.5.2>
					</xsl:for-each>
				</PID.5>
				<xsl:for-each select="visit">
					<PID.19>
						<xsl:value-of select="normalize-space(string(patientlist/patient/@ssn))"/>
					</PID.19>
				</xsl:for-each>
				<PV1>
					<PV1.7>
						<xsl:for-each select="visit">
							<PV1.7.1>
								<xsl:value-of select="string(@profilecode)"/>
							</PV1.7.1>
						</xsl:for-each>
						<xsl:for-each select="visit">
							<PV1.7.2>
								<xsl:value-of select="substring-before(string(@providername), ',')"/>
							</PV1.7.2>
						</xsl:for-each>
						<xsl:for-each select="visit">
							<PV1.7.3>
								<xsl:value-of select="substring-after(string(@providername), ',')"/>
							</PV1.7.3>
						</xsl:for-each>									
					</PV1.7>
				</PV1>
				<AIL>
					<AIL.3>
						<xsl:for-each select="visit">
							<AIL.3.1>
								<xsl:value-of select="string(@facilitycode)"/>
							</AIL.3.1>
						</xsl:for-each>
						<xsl:for-each select="visit">
							<AIL.3.2>
								<xsl:value-of select="string(@facilityname)"/>
							</AIL.3.2>
						</xsl:for-each>
					</AIL.3>
				</AIL>
				<AIP>
					<AIP.3>
						<xsl:for-each select="visit">
							<AIP.3.2>
								<xsl:value-of select="substring-before(string(@providername), ',')"/>
							</AIP.3.2>
						</xsl:for-each>
						<xsl:for-each select="visit">
							<AIP.3.3>
								<xsl:value-of select="substring-after(string(@providername), ',')"/>
							</AIP.3.3>
						</xsl:for-each>
					</AIP.3>
				</AIP>
			</PID>
		</SCH>
	</xsl:template>
</xsl:stylesheet>
