<?xml version="1.0" encoding="utf-8"?>
<xsl:stylesheet version="1.0" xmlns="urn:hl7-org:v3" xmlns:sdtc="urn:hl7-org:sdtc" xmlns:voc="urn:hl7-org:v3/voc" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:hl7-org:v3 http://xreg2.nist.gov:8080/hitspValidation/schema/cdar2c32/infrastructure/cda/C32_CDA.xsd" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"   xmlns:ms="urn:schemas-microsoft-com:xslt"  xmlns:dt="urn:schemas-microsoft-com:datatypes">
	<xsl:output method="xml" omit-xml-declaration="no" indent="yes"/>
	<xsl:template match="CCD">
		<ClinicalDocument xmlns="urn:hl7-org:v3" xmlns:voc="urn:hl7-org:v3/voc" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:schemaLocation="urn:hl7-org:v3 http://healthinfo.med.dal.ca/hl7intro/CDA_R2_NormativeWebEdition/infrastructure/cda/CDA.xsd">
			<xsl:variable name="Rulenum"/>
			<realmCode code="US"/>
			<typeId root="2.16.840.1.113883.1.3" extension="POCD_HD000040"/>
			<!-- QRDA Category III Release 1 template ID  -->
			<templateId root="2.16.840.1.113883.10.20.27.1.1"/>
			<id root="26a42253-99f5-48e7-9274-b467c6c7f623"/>
			<!-- SHALL QRDA III document type code -->
			<code code="55184-6" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" displayName="Quality Reporting Document Architecture Calculated Summary Report"/>
			<!-- SHALL Title, content optional -->
			<title>QRDA Calculated Summary Report</title>
			<effectiveTime>
				<xsl:attribute name="value">
					<xsl:value-of select="DocumentDateTime" />
				</xsl:attribute>
			</effectiveTime>
			<confidentialityCode code="N" codeSystem="2.16.840.1.113883.5.25"/>
			<languageCode code="en-US"/>
			<!-- SHOULD The version of the file being submitted. -->
			<versionNumber value="1"/>
			<!-- SHALL contain recordTarget and ID - but ID is nulled to NA. This is an aggregate summary report. Therefore CDA's required patient identifier is nulled. -->
			<recordTarget>
				<patientRole>
					<id nullFlavor="NA"/>
				</patientRole>
			</recordTarget>
			<!-- SHALL have 1..* author. SHALL have at least one device and/or one person. 
					The author of the CDA document in this element is a device. -->
			<author>
				<time>
					<xsl:attribute name="value">
						<xsl:value-of select="DocumentDateTime" />
					</xsl:attribute>
				</time>
				<assignedAuthor>
					<!-- author ID. This may be an NPI, or any other type of ID. -->
					<id root="2.16.840.1.113883.4.6" extension="111111111" assigningAuthorityName="NPI">
						<xsl:attribute name="extension">
							<xsl:value-of select="//patient/provider/providerNPI/value" />
						</xsl:attribute>
					</id>

					<assignedAuthoringDevice>
						<softwareName>Aprima PRM</softwareName>
					</assignedAuthoringDevice>
					<representedOrganization>
						<!-- The organization id is optional, but the name is required -->
						<id extension="110001" root="2.16.840.1.113883.19.5"/>
						<name>
							<xsl:value-of select="//organization/name"/>
						</name>
					</representedOrganization>
				</assignedAuthor>
			</author>
			<!-- person author example -->
			<author>
				<time>
					<xsl:attribute name="value">
						<xsl:value-of select="DocumentDateTime" />
					</xsl:attribute>
				</time>
				<assignedAuthor>
					<!-- author ID. This may be an NPI, or any other type of ID. -->
					<id root="2.16.840.1.113883.4.6" extension="111111112" assigningAuthorityName="NPI">
						<xsl:attribute name="extension">
							<xsl:value-of select="//patient/provider/providerNPI/value" />
						</xsl:attribute>
					</id>
					<assignedPerson>
						<name>
							<given>
								<xsl:value-of select="//patient/provider/name/given"/>
							</given>
							<family>
								<xsl:value-of select="//patient/provider/name/family"/>
							</family>
						</name>
					</assignedPerson>
					<representedOrganization>
						<!-- The organization id is optional -->
						<id root="2.16.840.1.113883.19.5" />
						<name>
							<xsl:value-of select="//organization/name"/>
						</name>
					</representedOrganization>
				</assignedAuthor>
			</author>
			<!-- The custodian of the CDA document is the same as the legal authenticator in this example and represents the reporting organization. -->
			<!-- SHALL -->
			<custodian>
				<assignedCustodian>
					<representedCustodianOrganization>
						<!-- SHALL have an id - This is an example root -->
						<id root="2.16.840.1.113883.19.5"/>
						<!-- SHOULD Name not required -->
						<name>
							<xsl:value-of select="//organization/name"/>
						</name>
					</representedCustodianOrganization>
				</assignedCustodian>
			</custodian>
			<!-- The legal authenticator of the CDA document is a single person who is at the 
					 same organization as the custodian in this example. This element must be present. -->
			<!-- SHALL -->
			<legalAuthenticator>
				<!-- SHALL -->
				<time>
					<xsl:attribute name="value">
						<xsl:value-of select="DocumentDateTime" />
					</xsl:attribute>
				</time>
				<!-- SHALL -->
				<signatureCode code="S"/>
				<assignedEntity>
					<!-- SHALL ID -->
					<id root="bc01a5d1-3a34-4286-82cc-43eb04c972a7"/>
					<!-- SHALL -->
					<representedOrganization>
						<!-- SHALL Id -->
						<!-- example root -->
						<id root="2.16.840.1.113883.19.5"/>
						<!-- SHOULD Name not required -->
						<name>
							<xsl:value-of select="//organization/name"/>
						</name>
					</representedOrganization>
				</assignedEntity>
			</legalAuthenticator>
			<!-- MAY - Device Participant Medical Record Device  
					 EHR Certification Number, represented by RGPR = regulated product: A product regulated by some governmental orgnization.  -->
			<participant typeCode="DEV">
				<associatedEntity classCode="RGPR">
					<!-- SHALL have at least one id, form can vary -->
					<!-- if the EHR has an ONC certification number, SHOULD use it here -->
					<id root="2.16.840.1.113883.3.2074.1" extension="30000001SVIWEAK" assigningAuthorityName="ONC"/>
					<!-- if the EHR has a CMS Security Code, MAY use it here -->
					<id root="2.16.840.1.113883.3.249.21" extension="98765"/>
					<code code="129465004" displayName="Aprima EHR" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED-CT"/>
				</associatedEntity>
			</participant>
			<!-- MAY: information about the service provider -->
			<documentationOf typeCode="DOC">
				<serviceEvent classCode="PCPR">
					<!-- care provision -->
					<effectiveTime>
						<low value="20120601"/>
						<high value="20120915"/>
					</effectiveTime>
					<!-- You can include multiple performers, each with optional NPI, TIN, CCN. -->
					<performer typeCode="PRF">
						<time>
							<low value="20100425">
								<xsl:attribute name="value">
									<xsl:value-of select="//messageStartDate" />
								</xsl:attribute>
							</low>
							<high value="20100425">
								<xsl:attribute name="value">
									<xsl:value-of select="//messageEndDate"/>
								</xsl:attribute>
							</high>
						</time>
						<assignedEntity>
							<!-- SHALL contain at least one id -->
							<!-- This is the optional provider NPI -->
							<id root="2.16.840.1.113883.4.6" extension="111111111" assigningAuthorityName="NPI">
								<xsl:attribute name="extension">
									<xsl:value-of select="//patient/provider/providerNPI/value" />
								</xsl:attribute>
							</id>
							<!-- MAY: The email address of the provider's data submitted -->
							<telecom value="mailto:user@hostname">
								<xsl:attribute name="value">
									<xsl:value-of select="//patient/provider/email" />
								</xsl:attribute>
							</telecom>
							<representedOrganization>
								<!-- This is the optional organization TIN -->
								<id root="2.16.840.1.113883.4.2" extension="1234567" assigningAuthorityName="TIN">
									<xsl:attribute name="extension">
										<xsl:value-of select="//patient/provider/providerTPIN/value" />
									</xsl:attribute>
								</id>

								<!-- This is the optional organization CCN -->
								<id root="2.16.840.1.113883.4.336" extension="54321" assigningAuthorityName="CCN"/>
							</representedOrganization>
						</assignedEntity>
					</performer>
				</serviceEvent>
			</documentationOf>
			<!--   MAY: participation waiver indicates the eligible professional has given the DSV (data submission vendor) 
						 permission to submit data on their behalf-->
			<authorization>
				<consent>
					<id root="84613250-e75e-11e1-aff1-0800200c9a66"/>
					<!-- SHALL single value binding -->
					<code code="425691002" displayName="consent given for electronic record sharing" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED-CT"/>
					<statusCode code="completed"/>
				</consent>
			</authorization>
			<component>
				<structuredBody>
					<component>
						<section>
							<!-- QRDA Reporting Parameters Section template -->
							<templateId root="2.16.840.1.113883.10.20.17.2.1"/>
							<!-- QRDA Category III Reporting Parameters templateId -->
							<templateId root="2.16.840.1.113883.10.20.27.2.2"/>
							<code code="55187-9" codeSystem="2.16.840.1.113883.6.1"/>
							<title>Reporting Parameters</title>
							<text>
								<list>
									<item>
										Reporting period:
										<xsl:value-of select="//messageStartDate" />
										TO
										<xsl:value-of select="//messageEndDate" />
									</item>
									<!--taking measure start date and end date-->
									<item>
										First encounter:
										<xsl:value-of select="//messageStartDate" />
									</item>
									<item>
										Last encounter:
										<xsl:value-of select="//messageEndDate" />
									</item>
								</list>
							</text>
							<entry typeCode="DRIV">
								<act classCode="ACT" moodCode="EVN">
									<templateId root="2.16.840.1.113883.10.20.17.3.8"/>
									<id root="55a43e20-6463-46eb-81c3-9a3a1ad41225"/>
									<code code="252116004" codeSystem="2.16.840.1.113883.6.96" displayName="Observation Parameters"/>
									<!-- This reporting period shows that Good Health Clinic is sending data for the first quarter of the year.
											 The referenced measure definition may be valid for the entire year or more-->
									<effectiveTime>
										<!-- The first day of the period reported. -->
										<low value="20100425">
											<xsl:attribute name="value">
												<xsl:value-of select="//messageStartDate" />
											</xsl:attribute>
										</low>
										<!-- The last day of the period reported. -->
										<high value="20100425">
											<xsl:attribute name="value">
												<xsl:value-of select="//messageEndDate"/>
											</xsl:attribute>
										</high>
									</effectiveTime>
								</act>
							</entry>
							<entry>
								<encounter classCode="ENC" moodCode="EVN">
									<!-- Optional encounter dates in the reporting period -->
									<templateId root="2.16.840.1.113883.10.20.27.3.11"/>
									<!-- Optional id of the first encounter of the reporting period-->
									<id root="4fd7e43d-e21d-45b3-a0ed-fe122efb96a9"/>
									<effectiveTime>
										<!-- The month, day and year of the first service encounter of the reporting period (From date) -->
										<low value="20100425">
											<xsl:attribute name="value">
												<xsl:value-of select="//messageStartDate" />
											</xsl:attribute>
										</low>
									</effectiveTime>
								</encounter>
							</entry>
							<entry>
								<encounter classCode="ENC" moodCode="EVN">
									<!-- Optional encounter dates in the reporting period -->
									<templateId root="2.16.840.1.113883.10.20.27.3.11"/>
									<!-- Optional id of the last encounter of the reporting period-->
									<id root="3e2b00b6-f846-4941-adb6-53eb88876a30"/>
									<effectiveTime>
										<!-- The month, day and year of the last service encounter of the reporting period (To date) -->
										<high value="20100425">
											<xsl:attribute name="value">
												<xsl:value-of select="//messageEndDate"/>
											</xsl:attribute>
										</high>
									</effectiveTime>
								</encounter>
							</entry>
						</section>
					</component>
					<component>
						<section>
							<!-- QRDA Measure Section template -->
							<templateId root="2.16.840.1.113883.10.20.24.2.2"/>
							<!-- QRDA Category III Measure Section template -->
							<templateId root="2.16.840.1.113883.10.20.27.2.1"/>
							<code code="55186-1" displayName="measure section" codeSystem="2.16.840.1.113883.6.1"/>
							<title>Measure Section</title>
							<text>
								<xsl:apply-templates select="//MeasureHeader"/>
							</text>
							<!--<xsl:apply-templates select="//MeasureHeaderDetails"/>-->
							<xsl:call-template name="MeasureHeaderDetails" />
						</section>
					</component>
				</structuredBody>
			</component>
		</ClinicalDocument>
	</xsl:template>

	<!--MEASURE HEADER-->
	<xsl:template name="MeasureHeader"  match="//MeasureHeader">
		<xsl:for-each select="//Measures">
			<table border="1" width="100%">
				<thead>
					<tr>
						<th>eMeasure Title</th>
						<th>Version neutral identifier</th>
						<th>eMeasure Version Number</th>
						<th>NQF eMeasure Number</th>
						<th>eMeasure Identifier (MAT)</th>
						<th>Version specific identifier</th>
					</tr>
				</thead>
				<tbody>
					<tr>
            <xsl:choose>
                <xsl:when test="MeasureID='1'"><td>Preventive Care and Screening: Screening for Clinical Depression and Follow-Up Plan</td></xsl:when>
                <xsl:when test="MeasureID='3'"><td>Closing the referral loop: receipt of specialist report</td></xsl:when>
                <xsl:when test="MeasureID='11'"><td>Documentation of Current Medications in the Medical Record</td></xsl:when>
                <xsl:when test="MeasureID='12'"><td>Preventive Care and Screening: Body Mass Index (BMI) Screening and Follow-Up</td></xsl:when>
                <xsl:when test="MeasureID='14'"><td>Children Who Have Dental Decay or Cavities</td></xsl:when>
                <xsl:when test="MeasureID='17'"><td>Functional Status Assessment for Complex Chronic Conditions</td></xsl:when>
                <xsl:when test="MeasureID='18'"><td>Childhood Immunization Status</td></xsl:when>
                <xsl:when test="MeasureID='23'"><td>Use of Appropriate Medications for Asthma</td></xsl:when>
                <xsl:when test="MeasureID='33'"><td>ADHD: Follow-Up Care for Children Prescribed Attention-Deficit/Hyperactivity Disorder (ADHD) Medication</td></xsl:when>
                <xsl:when test="MeasureID='35'"><td>Preventive Care and Screening: Tobacco Use: Screening and Cessation Intervention</td></xsl:when>
                <xsl:when test="MeasureID='43'"><td>Appropriate Testing for Children with Pharyngitis</td></xsl:when>
                <xsl:when test="MeasureID='47'"><td>Chlamydia Screening for Women</td></xsl:when>
                <xsl:when test="MeasureID='48'"><td>Appropriate Treatment for Children with Upper Respiratory Infection (URI)</td></xsl:when>
                <xsl:when test="MeasureID='49'"><td>Weight Assessment and Counseling for Nutrition and Physical Activity for Children and Adolescents</td></xsl:when>
                <xsl:when test="MeasureID='50'"><td>Use of High-Risk Medications in the Elderly</td></xsl:when>
                <xsl:when test="MeasureID='58'"><td>Controlling High Blood Pressure</td></xsl:when>
                <xsl:when test="MeasureID='59'"><td>Use of Imaging Studies for Low Back Pain</td></xsl:when>
            </xsl:choose>
            <xsl:choose>
                <xsl:when test="MeasureID='1'"><td>9A031E24-3D9B-11E1-8634-00237D5BF174</td></xsl:when>
                <xsl:when test="MeasureID='3'"><td>F58FC0D6-EDF5-416A-8D29-79AFBFD24DEA</td></xsl:when>
                <xsl:when test="MeasureID='11'"><td>9A032D9C-3D9B-11E1-8634-00237D5BF174</td></xsl:when>
                <xsl:when test="MeasureID='12'"><td>9A031BB8-3D9B-11E1-8634-00237D5BF174</td></xsl:when>
                <xsl:when test="MeasureID='14'"><td>61947125-4376-4A7B-AB7A-AC2BE9BD9138</td></xsl:when>
                <xsl:when test="MeasureID='17'"><td>BB9B8EF7-0354-40E0-BEC7-D6891B7DF519</td></xsl:when>
                <xsl:when test="MeasureID='18'"><td>B2802B7A-3580-4BE8-9458-921AEA62B78C</td></xsl:when>
                <xsl:when test="MeasureID='23'"><td>59E84144-6332-4369-AEBD-03A7899CA3DA</td></xsl:when>
                <xsl:when test="MeasureID='33'"><td>703CC49B-B653-4885-80E8-245A057F5AE9</td></xsl:when>
                <xsl:when test="MeasureID='35'"><td>E35791DF-5B25-41BB-B260-673337BC44A8</td></xsl:when>
                <xsl:when test="MeasureID='43'"><td>BEB1C33C-2549-4E7F-9567-05ED38448464</td></xsl:when>
                <xsl:when test="MeasureID='47'"><td>C9930664-BE3D-4FFE-AE4A-5CF4933ECB89</td></xsl:when>
                <xsl:when test="MeasureID='48'"><td>E455FAC0-F2CB-4074-A351-1E68A90FB7CF</td></xsl:when>
                <xsl:when test="MeasureID='49'"><td>0B63F730-25D6-4248-B11F-8C09C66A04EB</td></xsl:when>
                <xsl:when test="MeasureID='50'"><td>A3837FF8-1ABC-4BA9-800E-FD4E7953ADBD</td></xsl:when>
                <xsl:when test="MeasureID='58'"><td>ABDC37CC-BAC6-4156-9B91-D1BE2C8B7268</td></xsl:when>
                <xsl:when test="MeasureID='59'"><td>B6016B47-B65D-4BE0-866F-1D397886CA89</td></xsl:when>
            </xsl:choose>
            <xsl:choose>
                <xsl:when test="MeasureID='1'"><td>2</td></xsl:when>
                <xsl:when test="MeasureID='3'"><td>1</td></xsl:when>
                <xsl:when test="MeasureID='11'"><td>2</td></xsl:when>
                <xsl:when test="MeasureID='12'"><td>1</td></xsl:when>
                <xsl:when test="MeasureID='14'"><td>1</td></xsl:when>
                <xsl:when test="MeasureID='17'"><td>2</td></xsl:when>
                <xsl:when test="MeasureID='18'"><td>1</td></xsl:when>
                <xsl:when test="MeasureID='23'"><td>1</td></xsl:when>
                <xsl:when test="MeasureID='33'"><td>2</td></xsl:when>
                <xsl:when test="MeasureID='35'"><td>1</td></xsl:when>
                <xsl:when test="MeasureID='43'"><td>1</td></xsl:when>
                <xsl:when test="MeasureID='47'"><td>1</td></xsl:when>
                <xsl:when test="MeasureID='48'"><td>1</td></xsl:when>
                <xsl:when test="MeasureID='49'"><td>1</td></xsl:when>
                <xsl:when test="MeasureID='50'"><td>1</td></xsl:when>
                <xsl:when test="MeasureID='58'"><td>1</td></xsl:when>
                <xsl:when test="MeasureID='59'"><td>2</td></xsl:when>
            </xsl:choose>
            <xsl:choose>
                <xsl:when test="MeasureID='1'"><td>0418</td></xsl:when>
                <xsl:when test="MeasureID='3'"><td></td></xsl:when>
                <xsl:when test="MeasureID='11'"><td>0419</td></xsl:when>
                <xsl:when test="MeasureID='12'"><td>0421</td></xsl:when>
                <xsl:when test="MeasureID='14'"><td></td></xsl:when>
                <xsl:when test="MeasureID='17'"><td></td></xsl:when>
                <xsl:when test="MeasureID='18'"><td>0038</td></xsl:when>
                <xsl:when test="MeasureID='23'"><td>0036</td></xsl:when>
                <xsl:when test="MeasureID='33'"><td>0108</td></xsl:when>
                <xsl:when test="MeasureID='35'"><td>0028</td></xsl:when>
                <xsl:when test="MeasureID='43'"><td>0002</td></xsl:when>
                <xsl:when test="MeasureID='47'"><td>0033</td></xsl:when>
                <xsl:when test="MeasureID='48'"><td>0069</td></xsl:when>
                <xsl:when test="MeasureID='49'"><td>0024</td></xsl:when>
                <xsl:when test="MeasureID='50'"><td>0022</td></xsl:when>
                <xsl:when test="MeasureID='58'"><td>0018</td></xsl:when>
                <xsl:when test="MeasureID='59'"><td>0052</td></xsl:when>
            </xsl:choose>
            <xsl:choose>
                <xsl:when test="MeasureID='1'"><td>CMS002</td></xsl:when>
                <xsl:when test="MeasureID='3'"><td>CMS050</td></xsl:when>
                <xsl:when test="MeasureID='11'"><td>CMS068</td></xsl:when>
                <xsl:when test="MeasureID='12'"><td>CMS069</td></xsl:when>
                <xsl:when test="MeasureID='14'"><td>CMS075</td></xsl:when>
                <xsl:when test="MeasureID='17'"><td>CMS090</td></xsl:when>
                <xsl:when test="MeasureID='18'"><td>CMS117</td></xsl:when>
                <xsl:when test="MeasureID='23'"><td>CMS126</td></xsl:when>
                <xsl:when test="MeasureID='33'"><td>CMS136</td></xsl:when>
                <xsl:when test="MeasureID='35'"><td>CMS138</td></xsl:when>
                <xsl:when test="MeasureID='43'"><td>CMS146</td></xsl:when>
                <xsl:when test="MeasureID='47'"><td>CMS153</td></xsl:when>
                <xsl:when test="MeasureID='48'"><td>CMS154</td></xsl:when>
                <xsl:when test="MeasureID='49'"><td>CMS155</td></xsl:when>
                <xsl:when test="MeasureID='50'"><td>CMS156</td></xsl:when>
                <xsl:when test="MeasureID='58'"><td>CMS165</td></xsl:when>
                <xsl:when test="MeasureID='59'"><td>CMS166</td></xsl:when>
            </xsl:choose>
            <xsl:choose>
                <xsl:when test="MeasureID='1'"><td>8A4D92B2-3AE8-F461-013A-F4E544D7003E</td></xsl:when>
                <xsl:when test="MeasureID='3'"><td>8A4D92B2-356D-A09E-0135-C5FFA8972292</td></xsl:when>
                <xsl:when test="MeasureID='11'"><td>8A4D92B2-3B79-4CE2-013B-906DFFF52068</td></xsl:when>
                <xsl:when test="MeasureID='12'"><td>8A4D92B2-3A00-2A25-013A-4B927224747D</td></xsl:when>
                <xsl:when test="MeasureID='14'"><td>8A4D92B2-370B-19FA-0137-282DDBCF35DC</td></xsl:when>
                <xsl:when test="MeasureID='17'"><td>8A4D92B2-3B79-4CE2-013B-904950F61CB7</td></xsl:when>
                <xsl:when test="MeasureID='18'"><td>8A4D92B2-39CA-AF4B-0139-CAE9ED8A01BD</td></xsl:when>
                <xsl:when test="MeasureID='23'"><td>8A4D92B2-397A-48D2-0139-C648B33D5582</td></xsl:when>
                <xsl:when test="MeasureID='33'"><td>8A4D92B2-397A-48D2-0139-9BB3331F4C02</td></xsl:when>
                <xsl:when test="MeasureID='35'"><td>8A4D92B2-3946-CDAE-0139-77DE6F785ED7</td></xsl:when>
                <xsl:when test="MeasureID='43'"><td>8A4D92B2-3946-CDAE-0139-77F580AE6690</td></xsl:when>
                <xsl:when test="MeasureID='47'"><td>8A4D92B2-3946-CDAE-0139-77FE9FDC6853</td></xsl:when>
                <xsl:when test="MeasureID='48'"><td>8A4D92B2-3946-CDAE-0139-77FE9FDC6853</td></xsl:when>
                <xsl:when test="MeasureID='49'"><td>8A4D92B2-397A-48D2-0139-7CC6B5B8011E</td></xsl:when>
                <xsl:when test="MeasureID='50'"><td>8A4D92B2-3946-CDAE-0139-77E59FA3632E</td></xsl:when>
                <xsl:when test="MeasureID='58'"><td>8A4D92B2-397A-48D2-0139-C6208B875109</td></xsl:when>
                <xsl:when test="MeasureID='59'"><td>8A4D92B2-39CA-AF4B-0139-D49A6C2A1DD7</td></xsl:when>
            </xsl:choose>
					</tr>
				</tbody>
			</table>

			<!--<content styleCode="Bold">Member of Measure Set: Clinical Quality Measure Set</content>-->
			<list>
				<xsl:call-template name="PerformanceRate">
					<xsl:with-param name="Rulenumber" select="MeasureID" />
					<xsl:with-param name="Totals" select="Totals" />
				</xsl:call-template>
				<xsl:call-template name="ReportingRate">
					<xsl:with-param name="Rulenumber" select="MeasureID" />
					<xsl:with-param name="Totals" select="Totals" />
				</xsl:call-template>
				<xsl:for-each select="Population">
					<item>
						<xsl:call-template name="InitialPatientPopulation">
							<xsl:with-param name="Rulenumber" select="MeasureID" />
							<xsl:with-param name="PopulationSelector" select="@PopulationSelector" />
							<xsl:with-param name="Totals" select="Totals" />
						</xsl:call-template>
						<list>
							<xsl:call-template name="InitialPatientPopulationDetails">
								<xsl:with-param name="Rulenumber" select="MeasureID" />
								<xsl:with-param name="PopulationSelector" select="@PopulationSelector" />
								<xsl:with-param name="Totals" select="Totals" />
							</xsl:call-template>
						</list>
					</item>
					<item>
						<xsl:call-template name="Denominator">
							<xsl:with-param name="Rulenumber" select="MeasureID" />
							<xsl:with-param name="PopulationSelector" select="@PopulationSelector" />
							<xsl:with-param name="Totals" select="Totals" />
						</xsl:call-template>
						<list>
							<xsl:call-template name="DenominatorDetails">
								<xsl:with-param name="Rulenumber" select="MeasureID" />
								<xsl:with-param name="PopulationSelector" select="@PopulationSelector" />
								<xsl:with-param name="Totals" select="Totals" />
							</xsl:call-template>
						</list>
					</item>
					<xsl:for-each select="Numerator">
						<item>
							<xsl:call-template name="Numerator">
								<xsl:with-param name="Rulenumber" select="MeasureID" />
								<xsl:with-param name="PopulationSelector" select="@PopulationSelector" />
								<xsl:with-param name="InstanceSelector" select="@InstanceSelector" />
								<xsl:with-param name="Totals" select="Totals" />
							</xsl:call-template>
							<list>
								<xsl:call-template name="NumeratorDetails">
									<xsl:with-param name="Rulenumber" select="MeasureID" />
									<xsl:with-param name="PopulationSelector" select="@PopulationSelector" />
									<xsl:with-param name="InstanceSelector" select="@InstanceSelector" />
									<xsl:with-param name="Totals" select="Totals" />
								</xsl:call-template>
							</list>
						</item>
					</xsl:for-each>
					<xsl:for-each select="DenominatorExclusions">
						<item>
							<xsl:call-template name="DenominatorExclusions">
								<xsl:with-param name="Rulenumber" select="MeasureID" />
								<xsl:with-param name="PopulationSelector" select="@PopulationSelector" />
								<xsl:with-param name="InstanceSelector" select="@InstanceSelector" />
								<xsl:with-param name="Totals" select="Totals" />
							</xsl:call-template>
							<list>
								<xsl:call-template name="DenominatorExclusionsDetails">
									<xsl:with-param name="Rulenumber" select="MeasureID" />
									<xsl:with-param name="PopulationSelector" select="@PopulationSelector" />
									<xsl:with-param name="InstanceSelector" select="@InstanceSelector" />
									<xsl:with-param name="Totals" select="Totals" />
								</xsl:call-template>
							</list>
						</item>
					</xsl:for-each>
					<xsl:for-each select="./DenominatorExceptions">
						<item>
							<xsl:call-template name="DenominatorExceptions">
								<xsl:with-param name="Rulenumber" select="MeasureID" />
								<xsl:with-param name="PopulationSelector" select="@PopulationSelector" />
								<xsl:with-param name="InstanceSelector" select="@InstanceSelector" />
								<xsl:with-param name="Totals" select="Totals" />
							</xsl:call-template>
							<list>
								<xsl:call-template name="DenominatorExceptionsDetails">
									<xsl:with-param name="Rulenumber" select="MeasureID" />
									<xsl:with-param name="PopulationSelector" select="@PopulationSelector" />
									<xsl:with-param name="InstanceSelector" select="@InstanceSelector" />
									<xsl:with-param name="Totals" select="Totals" />
								</xsl:call-template>
							</list>
						</item>
					</xsl:for-each>
				</xsl:for-each>
			</list>
		</xsl:for-each>
	</xsl:template>
	<!--END OF TEMPLATE MEASURE HEADER-->

	<xsl:template name="PerformanceRate"  match="//PerformanceRate">
		<xsl:param name="Rulenumber" />
		<xsl:param name="Totals" />
		<xsl:for-each select="//measureDetails/Measure[Rulenumber=$Rulenumber and Title='1' and PopulationSelector='1']">
			<item>
				<content styleCode="Bold">Performance Rate</content>
				<xsl:value-of select='Totals'/>
			</item>
		</xsl:for-each>
	</xsl:template>
	<!--END OF TEMPLATE PerformanceRate-->
	
	<xsl:template name="ReportingRate"  match="//ReportingRate">
		<xsl:param name="Rulenumber" />
		<xsl:param name="Totals" />
		<xsl:for-each select="//measureDetails/Measure[Rulenumber=$Rulenumber and Title='2' and PopulationSelector='1']">
			<item>
				<content styleCode="Bold">Reporting Rate</content>
				<xsl:value-of select='Totals'/>
			</item>
		</xsl:for-each>
	</xsl:template>
	<!--END OF TEMPLATE ReportingRate-->
	
	<xsl:template name="InitialPatientPopulation"  match="//InitialPatientPopulation">
		<xsl:param name="Rulenumber" />
		<xsl:param name="PopulationSelector" />
		<xsl:param name="Totals" />
		<xsl:variable name="elems" select="//measureDetails/Measure[Rulenumber=$Rulenumber and Title='3' and PopulationSelector=$PopulationSelector]"/>
		<xsl:for-each select="$elems">
			<content styleCode="Bold">Initial Patient Population</content>
			<xsl:value-of select='Totals'/>
		</xsl:for-each>
		<xsl:if test="not($elems)">
			<content styleCode="Bold">Initial Patient Population</content>
			<xsl:text>0</xsl:text>
		</xsl:if>		
	</xsl:template>
	<!--END OF TEMPLATE InitialPatientPopulation-->

	<xsl:template name="InitialPatientPopulationDetails"  match="//InitialPatientPopulationDetails">
		<xsl:param name="Rulenumber" />
		<xsl:param name="PopulationSelector" />
		<xsl:param name="Totals" />
		<xsl:variable name="elems" select="//measureDetails/Measure[Rulenumber=$Rulenumber and Title='3' and PopulationSelector=$PopulationSelector]"/>
		<xsl:for-each select="$elems">
			<item>
				<content styleCode="Bold">
					<xsl:value-of select='SubHeading'/>
				</content>
				<xsl:value-of select='Totals'/>
			</item>
		</xsl:for-each>
		<xsl:if test="not($elems)">
			<item>
				<content styleCode="Bold">-</content>
				<xsl:text>0</xsl:text>
			</item>
		</xsl:if>
	</xsl:template>
	<!--END OF TEMPLATE InitialPatientPopulationDetails-->

	<xsl:template name="Denominator"  match="//Denominator">
		<xsl:param name="Rulenumber" />
		<xsl:param name="PopulationSelector" />
		<xsl:param name="Totals" />
		<xsl:variable name="elems" select="//measureDetails/Measure[Rulenumber=$Rulenumber and Title='4' and PopulationSelector=$PopulationSelector]"/>
		<xsl:for-each select="$elems">
			<content styleCode="Bold">Denominator</content>
			<xsl:value-of select='Totals'/>
		</xsl:for-each>
		<xsl:if test="not($elems)">
			<item>
				<content styleCode="Bold">Denominator</content>
				<xsl:text>0</xsl:text>
			</item>
		</xsl:if>
	</xsl:template>
	<!--END OF TEMPLATE Denominator-->

	<xsl:template name="DenominatorDetails"  match="//DenominatorDetails">
		<xsl:param name="Rulenumber" />
		<xsl:param name="PopulationSelector" />
		<xsl:param name="Totals" />
		<xsl:variable name="elems" select="//measureDetails/Measure[Rulenumber=$Rulenumber and Title='4' and PopulationSelector=$PopulationSelector]"/>
		<xsl:for-each select="$elems">
			<item>
				<content styleCode="Bold">
					<xsl:value-of select='SubHeading'/>
				</content>
				<xsl:value-of select='Totals'/>
			</item>
		</xsl:for-each>
		<xsl:if test="not($elems)">
			<item>
				<content styleCode="Bold">-</content>
				<xsl:text>0</xsl:text>
			</item>
		</xsl:if>
	</xsl:template>
	<!--END OF TEMPLATE Denominator Details-->

	<xsl:template name="Numerator"  match="//Numerator">
		<xsl:param name="Rulenumber" />
		<xsl:param name="PopulationSelector" />
		<xsl:param name="InstanceSelector" />
		<xsl:param name="Totals" />
		<xsl:variable name="elems" select="//measureDetails/Measure[Rulenumber=$Rulenumber and Title='5' and PopulationSelector=$PopulationSelector and InstanceSelector=$InstanceSelector]"/>
		<xsl:for-each select="$elems">
			<content styleCode="Bold">Numerator</content>
			<xsl:text>0</xsl:text>
		</xsl:for-each>
		<xsl:if test="not($elems)">
			<item>
				<content styleCode="Bold">Numerator</content>
				<xsl:text>0</xsl:text>
			</item>
		</xsl:if>
	</xsl:template>
	<!--END OF TEMPLATE Numerator-->

	<xsl:template name="NumeratorDetails"  match="//NumeratorDetails">
		<xsl:param name="Rulenumber" />
		<xsl:param name="PopulationSelector" />
		<xsl:param name="InstanceSelector" />
		<xsl:param name="Totals" />
		<xsl:variable name="elems" select="//measureDetails/Measure[Rulenumber=$Rulenumber and Title='5' and PopulationSelector=$PopulationSelector and InstanceSelector=$InstanceSelector]"/>
		<xsl:for-each select="$elems">
			<item>
				<content styleCode="Bold">
					<xsl:value-of select='SubHeading'/>
				</content>
				<xsl:value-of select='Totals'/>
			</item>
		</xsl:for-each>
		<xsl:for-each select="$elems">
			<content styleCode="Bold">-</content>
			<xsl:text>0</xsl:text>
		</xsl:for-each>
	</xsl:template>
	<!--END OF TEMPLATE Numerator Details-->

	<xsl:template name="DenominatorExclusions"  match="//DenominatorExclusions">
		<xsl:param name="Rulenumber" />
		<xsl:param name="PopulationSelector" />
		<xsl:param name="InstanceSelector" />
		<xsl:param name="Totals" />
		<xsl:variable name="elems" select="//measureDetails/Measure[Rulenumber=$Rulenumber and Title='6' and PopulationSelector=$PopulationSelector and InstanceSelector=$InstanceSelector]"/>
		<xsl:for-each select="$elems">
			<content styleCode="Bold">Denominator Exclusions</content>
			<xsl:value-of select='Totals'/>
		</xsl:for-each>
		<xsl:if test="not($elems)">
			<item>
				<content styleCode="Bold">Denominator Exclusions</content>
				<xsl:text>0</xsl:text>
			</item>
		</xsl:if>
	</xsl:template>
	<!--END OF TEMPLATE Numerator-->

	<xsl:template name="DenominatorExclusionsDetails"  match="//DenominatorExclusionsDetails">
		<xsl:param name="Rulenumber" />
		<xsl:param name="PopulationSelector" />
		<xsl:param name="InstanceSelector" />
		<xsl:param name="Totals" />
		<xsl:variable name="elems" select="//measureDetails/Measure[Rulenumber=$Rulenumber and Title='6' and PopulationSelector=$PopulationSelector and InstanceSelector=$InstanceSelector]"/>
		<xsl:for-each select="$elems">
			<item>
				<content styleCode="Bold">
					<xsl:value-of select='SubHeading'/>
				</content>
				<xsl:value-of select='Totals'/>
			</item>
		</xsl:for-each>
		<xsl:for-each select="$elems">
			<content styleCode="Bold">-</content>
			<xsl:text>0</xsl:text>
		</xsl:for-each>
	</xsl:template>
	<!--END OF TEMPLATE Numerator Details-->

	<xsl:template name="DenominatorExceptions"  match="//DenominatorExceptions">
		<xsl:param name="Rulenumber" />
		<xsl:param name="PopulationSelector" />
		<xsl:param name="InstanceSelector" />
		<xsl:param name="Totals" />
		<xsl:variable name="elems" select="//measureDetails/Measure[Rulenumber=$Rulenumber and Title='7' and PopulationSelector=$PopulationSelector and InstanceSelector=$InstanceSelector]"/>
		<xsl:for-each select="$elems">
			<content styleCode="Bold">Denominator Exceptions</content>
			<xsl:value-of select='Totals'/>
		</xsl:for-each>
		<xsl:if test="not($elems)">
			<item>
				<content styleCode="Bold">Denominator Exceptions</content>
				<xsl:text>0</xsl:text>
			</item>
		</xsl:if>
	</xsl:template>
	<!--END OF TEMPLATE DenominatorExceptions-->

	<xsl:template name="DenominatorExceptionsDetails"  match="//DenominatorExceptionsDetails">
		<xsl:param name="Rulenumber" />
		<xsl:param name="PopulationSelector" />
		<xsl:param name="InstanceSelector" />
		<xsl:param name="Totals" />
		<xsl:variable name="elems" select="//measureDetails/Measure[Rulenumber=$Rulenumber and Title='7' and PopulationSelector=$PopulationSelector and InstanceSelector=$InstanceSelector]"/>
		<xsl:for-each select="$elems">
			<item>
				<content styleCode="Bold">
					<xsl:value-of select='SubHeading'/>
				</content>
				<xsl:value-of select='Totals'/>
			</item>
		</xsl:for-each>
		<xsl:for-each select="$elems">
			<content styleCode="Bold">-</content>
			<xsl:text>0</xsl:text>
		</xsl:for-each>
	</xsl:template>
	<!--END OF TEMPLATE DenominatorExceptionsDetails Details-->


	<!--MEASURE HEADER-->
	<xsl:template name="MeasureHeaderDetails"  match="//MeasureHeaderDetails">
		<xsl:for-each select="//rulenumberDetails/Rule">
			<entry>
				<organizer classCode="CLUSTER" moodCode="EVN">

					<!-- Implied template Measure Reference templateId -->
					<templateId root="2.16.840.1.113883.10.20.24.3.98"/>
					<!-- SHALL 1..* (one for each referenced measure) Measure Reference and Results template -->
					<templateId root="2.16.840.1.113883.10.20.27.3.1"/>
					<statusCode code="completed"/>
					<reference typeCode="REFR">
						<externalDocument classCode="DOC" moodCode="EVN">
							<!-- SHALL: required Id but not restricted to the eMeasure Document/Id-->
							<!-- QualityMeasureDocument/id This is the version specific identifier for eMeasure -->
							<xsl:choose>
								<xsl:when test="@Rulenumber='1'"><id root="8A4D92B2-3AE8-F461-013A-F4E544D7003E"/></xsl:when>
								<xsl:when test="@Rulenumber='3'"><id root="8A4D92B2-356D-A09E-0135-C5FFA8972292"/></xsl:when>
								<xsl:when test="@Rulenumber='11'"><id root="8A4D92B2-3B79-4CE2-013B-906DFFF52068"/></xsl:when>
								<xsl:when test="@Rulenumber='12'"><id root="8A4D92B2-3A00-2A25-013A-4B927224747D"/></xsl:when>
								<xsl:when test="@Rulenumber='14'"><id root="8A4D92B2-370B-19FA-0137-282DDBCF35DC"/></xsl:when>
								<xsl:when test="@Rulenumber='17'"><id root="8A4D92B2-3B79-4CE2-013B-904950F61CB7"/></xsl:when>
								<xsl:when test="@Rulenumber='18'"><id root="8A4D92B2-39CA-AF4B-0139-CAE9ED8A01BD"/></xsl:when>
								<xsl:when test="@Rulenumber='23'"><id root="8A4D92B2-397A-48D2-0139-C648B33D5582"/></xsl:when>
								<xsl:when test="@Rulenumber='33'"><id root="8A4D92B2-397A-48D2-0139-9BB3331F4C02"/></xsl:when>
								<xsl:when test="@Rulenumber='35'"><id root="8A4D92B2-3946-CDAE-0139-77DE6F785ED7"/></xsl:when>
								<xsl:when test="@Rulenumber='43'"><id root="8A4D92B2-3946-CDAE-0139-77F580AE6690"/></xsl:when>
								<xsl:when test="@Rulenumber='47'"><id root="8A4D92B2-397A-48D2-0139-B0CC617E335D"/></xsl:when>
								<xsl:when test="@Rulenumber='48'"><id root="8A4D92B2-3946-CDAE-0139-77FE9FDC6853"/></xsl:when>
								<xsl:when test="@Rulenumber='49'"><id root="8A4D92B2-397A-48D2-0139-7CC6B5B8011E"/></xsl:when>
								<xsl:when test="@Rulenumber='50'"><id root="8A4D92B2-3946-CDAE-0139-77E59FA3632E"/></xsl:when>
								<xsl:when test="@Rulenumber='58'"><id root="8A4D92B2-397A-48D2-0139-C6208B875109"/></xsl:when>
								<xsl:when test="@Rulenumber='59'"><id root="8A4D92B2-39CA-AF4B-0139-D49A6C2A1DD7"/></xsl:when>
							</xsl:choose>
							<!-- SHOULD: This is the NQF Number, root is an NQF OID and for eMeasure Number and extension is the eMeasure's NQF number -->
							<xsl:choose>
								<xsl:when test="@Rulenumber='1'"><id root="2.16.840.1.113883.3.560.1" extension="0418"/></xsl:when>
								<xsl:when test="@Rulenumber='3'"><id root="2.16.840.1.113883.3.560.1" extension="N/A"/></xsl:when>
								<xsl:when test="@Rulenumber='11'"><id root="2.16.840.1.113883.3.560.1" extension="0419"/></xsl:when>
								<xsl:when test="@Rulenumber='12'"><id root="2.16.840.1.113883.3.560.1" extension="0421"/></xsl:when>
								<xsl:when test="@Rulenumber='14'"><id root="2.16.840.1.113883.3.560.1" extension="N/A"/></xsl:when>
								<xsl:when test="@Rulenumber='17'"><id root="2.16.840.1.113883.3.560.1" extension="N/A"/></xsl:when>
								<xsl:when test="@Rulenumber='18'"><id root="2.16.840.1.113883.3.560.1" extension="0038"/></xsl:when>
								<xsl:when test="@Rulenumber='23'"><id root="2.16.840.1.113883.3.560.1" extension="0036"/></xsl:when>
								<xsl:when test="@Rulenumber='33'"><id root="2.16.840.1.113883.3.560.1" extension="0108"/></xsl:when>
								<xsl:when test="@Rulenumber='35'"><id root="2.16.840.1.113883.3.560.1" extension="0028"/></xsl:when>
								<xsl:when test="@Rulenumber='43'"><id root="2.16.840.1.113883.3.560.1" extension="0002"/></xsl:when>
								<xsl:when test="@Rulenumber='47'"><id root="2.16.840.1.113883.3.560.1" extension="0033"/></xsl:when>
								<xsl:when test="@Rulenumber='48'"><id root="2.16.840.1.113883.3.560.1" extension="0069"/></xsl:when>
								<xsl:when test="@Rulenumber='49'"><id root="2.16.840.1.113883.3.560.1" extension="0024"/></xsl:when>
								<xsl:when test="@Rulenumber='50'"><id root="2.16.840.1.113883.3.560.1" extension="0022"/></xsl:when>
								<xsl:when test="@Rulenumber='58'"><id root="2.16.840.1.113883.3.560.1" extension="0018"/></xsl:when>
								<xsl:when test="@Rulenumber='59'"><id root="2.16.840.1.113883.3.560.1" extension="0052"/></xsl:when>
							</xsl:choose>
							<!-- SHOULD: eMeasure Measure Authoring Tool Identifier -->
							<id root="2.16.840.1.113883.3.560.101.2" extension="71"/>
							<code code="57024-2" codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC" displayName="Health Quality Measure Document"/>
							<!-- SHOULD This is the title of the eMeasure -->
							<xsl:choose>
								<xsl:when test="@Rulenumber='1'"><text>Preventive Care and Screening: Screening for Clinical Depression and Follow-Up Plan</text></xsl:when>
								<xsl:when test="@Rulenumber='3'"><text>Preventive Care and Screening: Screening for Clinical Depression and Follow-Up Plan</text></xsl:when>
								<xsl:when test="@Rulenumber='11'"><text>Documentation of Current Medications in the Medical Record</text></xsl:when>
								<xsl:when test="@Rulenumber='12'"><text>Preventive Care and Screening: Body Mass Index (BMI) Screening and Follow-Up</text></xsl:when>
								<xsl:when test="@Rulenumber='14'"><text>Children Who Have Dental Decay or Cavities</text></xsl:when>
								<xsl:when test="@Rulenumber='17'"><text>Functional Status Assessment for Complex Chronic Conditions</text></xsl:when>
								<xsl:when test="@Rulenumber='18'"><text>Childhood Immunization Status</text></xsl:when>
								<xsl:when test="@Rulenumber='23'"><text>Use of Appropriate Medications for Asthma</text></xsl:when>
								<xsl:when test="@Rulenumber='33'"><text>ADHD: Follow-Up Care for Children Prescribed Attention-Deficit/Hyperactivity Disorder (ADHD) Medication</text></xsl:when>
								<xsl:when test="@Rulenumber='35'"><text>Preventive Care and Screening: Tobacco Use: Screening and Cessation Intervention</text></xsl:when>
								<xsl:when test="@Rulenumber='43'"><text>Appropriate Testing for Children with Pharyngitis</text></xsl:when>
								<xsl:when test="@Rulenumber='47'"><text>Chlamydia Screening for Women</text></xsl:when>
								<xsl:when test="@Rulenumber='48'"><text>Appropriate Treatment for Children with Upper Respiratory Infection (URI)</text></xsl:when>
								<xsl:when test="@Rulenumber='49'"><text>Weight Assessment and Counseling for Nutrition and Physical Activity for Children and Adolescents</text></xsl:when>
								<xsl:when test="@Rulenumber='50'"><text>Use of High-Risk Medications in the Elderly</text></xsl:when>
								<xsl:when test="@Rulenumber='58'"><text>Controlling High Blood Pressure</text></xsl:when>
								<xsl:when test="@Rulenumber='59'"><text>Use of Imaging Studies for Low Back Pain</text></xsl:when>
							</xsl:choose>
							<!-- SHOULD: setId is the eMeasure version neutral id  -->
							<xsl:choose>
								<xsl:when test="@Rulenumber='1'"><setId root="9A031E24-3D9B-11E1-8634-00237D5BF174"/></xsl:when>
								<xsl:when test="@Rulenumber='3'"><setId root="F58FC0D6-EDF5-416A-8D29-79AFBFD24DEA"/></xsl:when>
								<xsl:when test="@Rulenumber='11'"><setId root="9A032D9C-3D9B-11E1-8634-00237D5BF174"/></xsl:when>
								<xsl:when test="@Rulenumber='12'"><setId root="9A031BB8-3D9B-11E1-8634-00237D5BF174"/></xsl:when>
								<xsl:when test="@Rulenumber='14'"><setId root="61947125-4376-4A7B-AB7A-AC2BE9BD9138"/></xsl:when>
								<xsl:when test="@Rulenumber='17'"><setId root="BB9B8EF7-0354-40E0-BEC7-D6891B7DF519"/></xsl:when>
								<xsl:when test="@Rulenumber='18'"><setId root="B2802B7A-3580-4BE8-9458-921AEA62B78C"/></xsl:when>
								<xsl:when test="@Rulenumber='23'"><setId root="59E84144-6332-4369-AEBD-03A7899CA3DA"/></xsl:when>
								<xsl:when test="@Rulenumber='33'"><setId root="703CC49B-B653-4885-80E8-245A057F5AE9"/></xsl:when>
								<xsl:when test="@Rulenumber='35'"><setId root="E35791DF-5B25-41BB-B260-673337BC44A8"/></xsl:when>
								<xsl:when test="@Rulenumber='43'"><setId root="BEB1C33C-2549-4E7F-9567-05ED38448464"/></xsl:when>
								<xsl:when test="@Rulenumber='47'"><setId root="C9930664-BE3D-4FFE-AE4A-5CF4933ECB89"/></xsl:when>
								<xsl:when test="@Rulenumber='48'"><setId root="E455FAC0-F2CB-4074-A351-1E68A90FB7CF"/></xsl:when>
								<xsl:when test="@Rulenumber='49'"><setId root="0B63F730-25D6-4248-B11F-8C09C66A04EB"/></xsl:when>
								<xsl:when test="@Rulenumber='50'"><setId root="A3837FF8-1ABC-4BA9-800E-FD4E7953ADBD"/></xsl:when>
								<xsl:when test="@Rulenumber='58'"><setId root="F3600ECE-7844-4C8A-84E7-9B4964CBAF4D"/></xsl:when>
								<xsl:when test="@Rulenumber='59'"><setId root="B6016B47-B65D-4BE0-866F-1D397886CA89"/></xsl:when>
							</xsl:choose>
							<!-- This is the sequential eMeasure Version number -->
							<xsl:choose>
								<xsl:when test="@Rulenumber='1'"><versionNumber value="2"/></xsl:when>
								<xsl:when test="@Rulenumber='3'"><versionNumber value="1"/></xsl:when>
								<xsl:when test="@Rulenumber='11'"><versionNumber value="1"/></xsl:when>
								<xsl:when test="@Rulenumber='12'"><versionNumber value="1"/></xsl:when>
								<xsl:when test="@Rulenumber='14'"><versionNumber value="1"/></xsl:when>
								<xsl:when test="@Rulenumber='17'"><versionNumber value="2"/></xsl:when>
								<xsl:when test="@Rulenumber='18'"><versionNumber value="2"/></xsl:when>
								<xsl:when test="@Rulenumber='23'"><versionNumber value="1"/></xsl:when>
								<xsl:when test="@Rulenumber='33'"><versionNumber value="2"/></xsl:when>
								<xsl:when test="@Rulenumber='35'"><versionNumber value="1"/></xsl:when>
								<xsl:when test="@Rulenumber='43'"><versionNumber value="1"/></xsl:when>
								<xsl:when test="@Rulenumber='47'"><versionNumber value="1"/></xsl:when>
								<xsl:when test="@Rulenumber='48'"><versionNumber value="1"/></xsl:when>
								<xsl:when test="@Rulenumber='49'"><versionNumber value="1"/></xsl:when>
								<xsl:when test="@Rulenumber='50'"><versionNumber value="1"/></xsl:when>
								<xsl:when test="@Rulenumber='58'"><versionNumber value="1"/></xsl:when>
								<xsl:when test="@Rulenumber='59'"><versionNumber value="2"/></xsl:when>
							</xsl:choose>
						</externalDocument>
					</reference>
					<!-- SHOULD Reference the measure set it is a member of-->
					<reference typeCode="REFR">
						<externalObservation>
							<!-- SHALL contain id -->
							<id root="b6ac13e2-beb8-4e4f-94ed-fcc397406cd8"/>
							<!-- SHALL single value binding -->
							<code code="55185-3" displayName="measure set"
								codeSystem="2.16.840.1.113883.6.1" codeSystemName="LOINC"/>
							<!-- SHALL text which should be the title of the measures set -->
							<text>Clinical Quality Measure Set </text>
						</externalObservation>
					</reference>

					<!--<content styleCode="Bold">Member of Measure Set: Clinical Quality Measure Set</content>-->

					<xsl:call-template name="PerformanceRateDetails">
						<xsl:with-param name="Rulenumber" select="@Rulenumber" />
					</xsl:call-template>
					<xsl:call-template name="ReportingRateDetails">
						<xsl:with-param name="Rulenumber" select="@Rulenumber" />
					</xsl:call-template>

					<xsl:for-each select="Population">
						<xsl:variable name="StratumElements" select="./Stratum"/>
						<xsl:call-template name="IPPDetails">
							<xsl:with-param name="Rulenumber" select="../@Rulenumber" />
							<xsl:with-param name="PopulationSelector" select="@PopulationSelector" />
							<xsl:with-param name="StratumElements" select="$StratumElements" />
						</xsl:call-template>

						<xsl:call-template name="DenomDetails">
							<xsl:with-param name="Rulenumber" select="../@Rulenumber" />
							<xsl:with-param name="PopulationSelector" select="@PopulationSelector" />
							<xsl:with-param name="StratumElements" select="$StratumElements" />
						</xsl:call-template>

						<xsl:for-each select="Numerator">
							<xsl:call-template name="NumDetails">
								<xsl:with-param name="Rulenumber" select="../../@Rulenumber" />
								<xsl:with-param name="PopulationSelector" select="../@PopulationSelector" />
								<xsl:with-param name="InstanceSelector" select="@InstanceSelector" />
								<xsl:with-param name="StratumElements" select="$StratumElements" />
							</xsl:call-template>
						</xsl:for-each>

						<xsl:for-each select="DenominatorExclusions">
							<xsl:call-template name="DenomExclusionsDetails">
								<xsl:with-param name="Rulenumber" select="../../@Rulenumber" />
								<xsl:with-param name="PopulationSelector" select="../@PopulationSelector" />
								<xsl:with-param name="InstanceSelector" select="@InstanceSelector" />
								<xsl:with-param name="StratumElements" select="$StratumElements" />
							</xsl:call-template>
						</xsl:for-each>

						<xsl:for-each select="./DenominatorExceptions">
							<xsl:call-template name="DenomExceptionDetails">
								<xsl:with-param name="Rulenumber" select="../../@Rulenumber" />
								<xsl:with-param name="PopulationSelector" select="../@PopulationSelector" />
								<xsl:with-param name="InstanceSelector" select="@InstanceSelector" />
								<xsl:with-param name="StratumElements" select="$StratumElements" />
							</xsl:call-template>
						</xsl:for-each>
					</xsl:for-each>
				</organizer>
			</entry>
		</xsl:for-each>
	</xsl:template>
	<!--END OF TEMPLATE MEASURE HEADER DETAILS-->


	<xsl:template name="PerformanceRateDetails"  match="//PerformanceRateDetails">
		<xsl:param name="Rulenumber" />
		<xsl:for-each select="//measureDetails/Measure[Rulenumber=$Rulenumber and Title='1' and PopulationSelector='1']">
			<!-- Optional performance rate template -->
			<component>
				<observation classCode="OBS" moodCode="EVN">
					<!-- MAY 0..1 Performance Rate for Proportion Measure template -->
					<templateId root="2.16.840.1.113883.10.20.27.3.14"/>
					<code code="72510-1" codeSystem="2.16.840.1.113883.6.1" displayName="Performance Rate" codeSystemName="2.16.840.1.113883.6.1"/>
					<statusCode code="completed"/>
					<value xsi:type="REAL" value="0.833">
						<xsl:attribute name="value">
							<xsl:value-of select="Totals" />
						</xsl:attribute>
					</value>

					<!-- MAY 0..1  (Note: this is the reference to the specific Numerator included in the calculation) -->
					<reference typeCode="REFR">
						<externalObservation classCode="OBS" moodCode="EVN">
							<!--The externalObservationID contains the ID of the numerator in the referenced eMeasure.-->
							<id root="17D7EEFE-C12C-4020-BA68-545A3FFC3598"/>
							<code code="NUMER" displayName="Numerator" codeSystem="2.16.840.1.113883.5.1063" codeSystemName="ObservationValue"/>
						</externalObservation>
					</reference>
					<!-- MAY 0..1 Used to represent the predicted rate based on the measure’s risk-adjustment model. -->
					<referenceRange>
						<observationRange>
							<!--Not right one -->
							<value xsi:type="REAL" value="0.625"/>
						</observationRange>
					</referenceRange>
				</observation>
			</component>
		</xsl:for-each>
	</xsl:template>
	<!--END OF TEMPLATE PerformanceRate-->

	<xsl:template name="ReportingRateDetails"  match="//ReportingRateDetails">
		<xsl:param name="Rulenumber" />
		<xsl:for-each select="//measureDetails/Measure[Rulenumber=$Rulenumber and Title='2' and PopulationSelector='1']">
			<!-- Optional reporting rate template -->
			<component>
				<observation classCode="OBS" moodCode="EVN">
					<!-- MAY 0..1 Reporting Rate for Proportion Measure template -->
					<templateId root="2.16.840.1.113883.10.20.27.3.15"/>
					<code code="72509-3" codeSystem="2.16.840.1.113883.6.1" displayName="Reporting Rate" codeSystemName="2.16.840.1.113883.6.1"/>
					<statusCode code="completed"/>
					<value xsi:type="REAL" value="0.84">
						<xsl:attribute name="value">
							<xsl:value-of select='Totals'/>
						</xsl:attribute>
					</value>
				</observation>
			</component>
		</xsl:for-each>
	</xsl:template>
	<!--END OF TEMPLATE ReportingRate-->

	<xsl:template name="IPPDetails"  match="//IPPDetails">
		<xsl:param name="Rulenumber" />
		<xsl:param name="PopulationSelector" />
		<xsl:param name="StratumElements" />
		<xsl:variable name="elems" select="//measureDetails/Measure[Rulenumber=$Rulenumber and Title='3' and PopulationSelector=$PopulationSelector]"/>
		<component>
			<observation classCode="OBS" moodCode="EVN">
				<xsl:for-each select="$elems">
					<xsl:if test="Subtitle=1">
						<!-- Measure Data template -->
						<templateId root="2.16.840.1.113883.10.20.27.3.5"/>
						<code code="ASSERTION" codeSystem="2.16.840.1.113883.5.4" displayName="Assertion" codeSystemName="ActCode"/>
						<statusCode code="completed"/>
						<!-- SHALL value with SHOULD be from valueSetName="ObservationPopulationInclusion valueSetOid="2.16.840.1.113883.1.11.20369" Binding: Dynamic -->
						<value xsi:type="CD" code="IPP" codeSystem="2.16.840.1.113883.5.1063" displayName="initial patient population" codeSystemName="ObservationValue"/>
						<!-- SHALL contain aggregate count template -->
						<entryRelationship typeCode="SUBJ" inversionInd="true">
							<!-- Aggregate Count (2.16.840.1.113883.10.20.27.3.3) -->
							<observation classCode="OBS" moodCode="EVN">
								<!-- Aggregate Count template -->
								<templateId root="2.16.840.1.113883.10.20.27.3.3"/>
								<!-- SHALL single value binding -->
								<code code="MSRAGG" displayName="rate aggregation" codeSystem="2.16.840.1.113883.5.4" codeSystemName="ActCode"/>
								<!--  SHALL value xsi:type="INT"-->
								<value xsi:type="INT">
									<xsl:attribute name="value">
										<xsl:value-of select='format-number(Totals, "#")' />
									</xsl:attribute>
								</value>
								<methodCode code="COUNT" displayName="Count"
									codeSystem="2.16.840.1.113883.5.84"
									codeSystemName="ObservationMethod"/>
							</observation>
						</entryRelationship>
					</xsl:if>
					<xsl:if test="Subtitle=1">
						<xsl:call-template name="ReportStratum">
							<xsl:with-param name="Rulenumber" select="$Rulenumber" />
							<xsl:with-param name="Title" select="3" />
							<xsl:with-param name="PopulationSelector" select="$PopulationSelector" />
							<xsl:with-param name="InstanceSelector" select="0" />
							<xsl:with-param name="StratumElements" select="$StratumElements" />
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="Subtitle=2"><xsl:call-template name="Sex" /></xsl:if>
					<xsl:if test="Subtitle=3"><xsl:call-template name="Race" /></xsl:if>
					<xsl:if test="Subtitle=4"><xsl:call-template name="Ethnicity" /></xsl:if>
					<xsl:if test="Subtitle=5"><xsl:call-template name="Payer" /></xsl:if>
					<xsl:if test="Subtitle=6"><xsl:call-template name="PostalCode" /></xsl:if>
				</xsl:for-each>

				<xsl:if test="not($elems)">
					<!-- Measure Data template -->
					<templateId root="2.16.840.1.113883.10.20.27.3.5"/>
					<code code="ASSERTION" codeSystem="2.16.840.1.113883.5.4" displayName="Assertion" codeSystemName="ActCode"/>
					<statusCode code="completed"/>
					<!-- SHALL value with SHOULD be from valueSetName="ObservationPopulationInclusion valueSetOid="2.16.840.1.113883.1.11.20369" Binding: Dynamic -->
					<value xsi:type="CD" code="IPP" codeSystem="2.16.840.1.113883.5.1063" displayName="initial patient population" codeSystemName="ObservationValue"/>
					<!-- SHALL contain aggregate count template -->
					<entryRelationship typeCode="SUBJ" inversionInd="true">
						<!-- Aggregate Count (2.16.840.1.113883.10.20.27.3.3) -->
						<observation classCode="OBS" moodCode="EVN">
							<!-- Aggregate Count template -->
							<templateId root="2.16.840.1.113883.10.20.27.3.3"/>
							<!-- SHALL single value binding -->
							<code code="MSRAGG" displayName="rate aggregation" codeSystem="2.16.840.1.113883.5.4" codeSystemName="ActCode"/>
							<!--  SHALL value xsi:type="INT"-->
							<value xsi:type="INT" value="0" />
							<methodCode code="COUNT" displayName="Count"
								codeSystem="2.16.840.1.113883.5.84"
								codeSystemName="ObservationMethod"/>
						</observation>
					</entryRelationship>
					<xsl:if test="Subtitle=1">
						<xsl:call-template name="ReportStratum">
							<xsl:with-param name="Rulenumber" select="$Rulenumber" />
							<xsl:with-param name="Title" select="3" />
							<xsl:with-param name="PopulationSelector" select="$PopulationSelector" />
							<xsl:with-param name="InstanceSelector" select="0" />
							<xsl:with-param name="StratumElements" select="$StratumElements" />
						</xsl:call-template>
					</xsl:if>
				</xsl:if>
				
					<!-- SHALL 1..1  (Note: this is the reference for the entire population starting with the first component
													observation at the top within the measure data template-->
				<reference typeCode="REFR">
					<!-- reference to the relevant population in the eMeasure -->
					<externalObservation classCode="OBS" moodCode="EVN">
						<xsl:choose>
							<xsl:when test="$Rulenumber = '1'"><id root="8F0C4421-8FD5-4CF9-B559-FAE930EB13B1" /></xsl:when>
							<xsl:when test="$Rulenumber = '3'"><id root="AA3E3C36-70B6-4DAA-A45E-533618C76035" /></xsl:when>
							<xsl:when test="$Rulenumber = '11'"><id root="7F8CECB8-7F5B-430A-89F7-0A84F3F74D41" /></xsl:when>
							<xsl:when test="$Rulenumber = '12' and $PopulationSelector = '2'"><id root="80E7FAA0-71F7-4E6D-98E3-512BEA3D235C" /></xsl:when>
							<xsl:when test="$Rulenumber = '12' and $PopulationSelector = '3'"><id root="13C1B909-3E7E-437E-9593-094F892560E2" /></xsl:when>
							<xsl:when test="$Rulenumber = '14'"><id root="B3E07238-2B9B-4894-AE82-8426393BAFC3" /></xsl:when>
							<xsl:when test="$Rulenumber = '17'"><id root="86977734-D6D0-4526-B4F7-F60D504655CF" /></xsl:when>
							<xsl:when test="$Rulenumber = '18'"><id root="94582002-CFF2-473E-94EF-8245C9B0E1B8" /></xsl:when>
							<xsl:when test="$Rulenumber = '23'"><id root="155518F5-8B70-49AB-A3CB-E53037D5442D" /></xsl:when>
							<xsl:when test="$Rulenumber = '33' and $PopulationSelector = '1'"><id root="6AC105C9-CD41-4D77-9BAD-E363DA8B0D98" /></xsl:when>
							<xsl:when test="$Rulenumber = '33' and $PopulationSelector = '2'"><id root="0A1BCA92-0DC8-424C-8EF2-148D98899113" /></xsl:when>
							<xsl:when test="$Rulenumber = '35'"><id root="81061D29-9844-4607-9226-275D93E09C1E" /></xsl:when>
							<xsl:when test="$Rulenumber = '43'"><id root="14A38107-50A1-4DD9-A6AB-BC9E5DEDCEB9" /></xsl:when>
							<xsl:when test="$Rulenumber = '47'"><id root="8FE9026F-C329-4664-A595-9D06D80C3A74" /></xsl:when>
							<xsl:when test="$Rulenumber = '48'"><id root="E55811D5-DD67-450A-A253-0D0C8EFCD50E" /></xsl:when>
							<xsl:when test="$Rulenumber = '49'"><id root="E83A6DA6-D34E-4107-8431-2FB2C86738C7" /></xsl:when>
							<xsl:when test="$Rulenumber = '50'"><id root="300101AF-9DCF-497E-B23A-138A2B173861" /></xsl:when>
							<xsl:when test="$Rulenumber = '58'"><id root="3FA0DFB9-5849-46A9-BBA0-97B321F9DBAC" /></xsl:when>
							<xsl:when test="$Rulenumber = '59'"><id root="C8D8831E-A459-48D2-B299-6B6C297601B2" /></xsl:when>
						</xsl:choose>
					</externalObservation>
				</reference>
			</observation>
		</component>
	</xsl:template>
	<!--END OF TEMPLATE IPPDetails-->

	<xsl:template name="DenomDetails"  match="//DenomDetails">
		<xsl:param name="Rulenumber" />
		<xsl:param name="PopulationSelector" />
		<xsl:param name="StratumElements" />
		<xsl:variable name="elems" select="//measureDetails/Measure[Rulenumber=$Rulenumber and Title='4' and PopulationSelector=$PopulationSelector]"/>
		<component>
			<observation classCode="OBS" moodCode="EVN">
				<xsl:for-each select="$elems">
					<xsl:if test="Subtitle=1">
						<!-- Measure Data template -->
						<templateId root="2.16.840.1.113883.10.20.27.3.5"/>
						<code code="ASSERTION" codeSystem="2.16.840.1.113883.5.4" displayName="Assertion" codeSystemName="ActCode"/>
						<statusCode code="completed"/>
						<!-- SHALL value with SHOULD be from valueSetName="ObservationPopulationInclusion "	valueSetOid="2.16.840.1.113883.1.11.20369"	Binding: Dynamic -->
						<value xsi:type="CD" code="DENOM" codeSystem="2.16.840.1.113883.5.1063" displayName="Denominator" codeSystemName="ObservationValue"/>
						<!-- SHALL contain aggregate count template -->
						<entryRelationship typeCode="SUBJ" inversionInd="true">
							<!-- Aggregate Count (2.16.840.1.113883.10.20.27.3.3) -->
							<observation classCode="OBS" moodCode="EVN">
								<!-- Aggregate Count template -->
								<templateId root="2.16.840.1.113883.10.20.27.3.3"/>
								<!-- SHALL single value binding -->
								<code code="MSRAGG" displayName="rate aggregation" codeSystem="2.16.840.1.113883.5.4" codeSystemName="ActCode"/>
								<!--  SHALL value xsi:type="INT"-->
								<value xsi:type="INT">
									<xsl:attribute name="value">
										<xsl:value-of select='format-number(Totals, "#")' />
									</xsl:attribute>
								</value>
								<methodCode code="COUNT" displayName="Count" codeSystem="2.16.840.1.113883.5.84" codeSystemName="ObservationMethod"/>
							</observation>
						</entryRelationship>
					</xsl:if>
					<xsl:if test="Subtitle=1">
						<xsl:call-template name="ReportStratum">
							<xsl:with-param name="Rulenumber" select="$Rulenumber" />
							<xsl:with-param name="Title" select="4" />
							<xsl:with-param name="PopulationSelector" select="$PopulationSelector" />
							<xsl:with-param name="InstanceSelector" select="0" />
							<xsl:with-param name="StratumElements" select="$StratumElements" />
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="Subtitle=2"><xsl:call-template name="Sex" /></xsl:if>
					<xsl:if test="Subtitle=3"><xsl:call-template name="Race" /></xsl:if>
					<xsl:if test="Subtitle=4"><xsl:call-template name="Ethnicity" /></xsl:if>
					<xsl:if test="Subtitle=5"><xsl:call-template name="Payer" /></xsl:if>
					<xsl:if test="Subtitle=6"><xsl:call-template name="PostalCode" /></xsl:if>
				</xsl:for-each>

				<xsl:if test="not($elems)">
					<!-- Measure Data template -->
					<templateId root="2.16.840.1.113883.10.20.27.3.5"/>
					<code code="ASSERTION" codeSystem="2.16.840.1.113883.5.4" displayName="Assertion" codeSystemName="ActCode"/>
					<statusCode code="completed"/>
					<!-- SHALL value with SHOULD be from valueSetName="ObservationPopulationInclusion "	valueSetOid="2.16.840.1.113883.1.11.20369"	Binding: Dynamic -->
					<value xsi:type="CD" code="DENOM" codeSystem="2.16.840.1.113883.5.1063" displayName="Denominator" codeSystemName="ObservationValue"/>
					<!-- SHALL contain aggregate count template -->
					<entryRelationship typeCode="SUBJ" inversionInd="true">
						<!-- Aggregate Count (2.16.840.1.113883.10.20.27.3.3) -->
						<observation classCode="OBS" moodCode="EVN">
							<!-- Aggregate Count template -->
							<templateId root="2.16.840.1.113883.10.20.27.3.3"/>
							<!-- SHALL single value binding -->
							<code code="MSRAGG" displayName="rate aggregation" codeSystem="2.16.840.1.113883.5.4" codeSystemName="ActCode"/>
							<!--  SHALL value xsi:type="INT"-->
							<value xsi:type="INT" value="0" />
							<methodCode code="COUNT" displayName="Count" codeSystem="2.16.840.1.113883.5.84" codeSystemName="ObservationMethod"/>
						</observation>
					</entryRelationship>
					<xsl:call-template name="ReportStratum">
						<xsl:with-param name="Rulenumber" select="$Rulenumber" />
						<xsl:with-param name="Title" select="4" />
						<xsl:with-param name="PopulationSelector" select="$PopulationSelector" />
						<xsl:with-param name="InstanceSelector" select="0" />
						<xsl:with-param name="StratumElements" select="$StratumElements" />
					</xsl:call-template>
				</xsl:if>

				<!-- SHALL 1..1  (Note: this is the reference for the entire population starting with the first component
											observation at the top within the measure data template-->
				<reference typeCode="REFR">
					<!-- reference to the relevant population in the eMeasure -->
					<externalObservation classCode="OBS" moodCode="EVN">
						<xsl:choose>
							<xsl:when test="$Rulenumber = '1'"><id root="AD6CD556-EE4C-4EC1-8AD1-31E48032BE12" /></xsl:when>
							<xsl:when test="$Rulenumber = '3'"><id root="CB2FE04B-C7E7-4F81-B0C6-3A00FAA63491" /></xsl:when>
							<xsl:when test="$Rulenumber = '11'"><id root="7E2CFB02-FA2F-45A7-8896-4045E489F878" /></xsl:when>
							<xsl:when test="$Rulenumber = '12' and $PopulationSelector = '2'"><id root="1B632863-28DC-442E-A270-3B5543BDBF92" /></xsl:when>
							<xsl:when test="$Rulenumber = '12' and $PopulationSelector = '3'"><id root="138F4D66-BA09-4D81-9D16-4F5511039CC6" /></xsl:when>
							<xsl:when test="$Rulenumber = '14'"><id root="E70AAB60-ABC0-4383-901C-6218BB46DFAB" /></xsl:when>
							<xsl:when test="$Rulenumber = '17'"><id root="CBA54C54-C6D5-4E28-9A06-2289AA3E9E52" /></xsl:when>
							<xsl:when test="$Rulenumber = '18'"><id root="07B5512B-D255-4AD2-8197-60E1C570770C" /></xsl:when>
							<xsl:when test="$Rulenumber = '23'"><id root="39D50ED5-FEBA-4A1D-8D8E-B95FED251BE1" /></xsl:when>
							<xsl:when test="$Rulenumber = '33' and $PopulationSelector = '1'"><id root="D80FA9DC-06B3-4885-BD10-0A06E519F124" /></xsl:when>
							<xsl:when test="$Rulenumber = '33' and $PopulationSelector = '2'"><id root="E44D8742-2F48-413B-93B9-92C6328B4CB7" /></xsl:when>
							<xsl:when test="$Rulenumber = '35'"><id root="9A077F22-04FF-4305-8662-ECC38829DCEA" /></xsl:when>
							<xsl:when test="$Rulenumber = '43'"><id root="0002BEB6-F5E8-4755-A95C-1CA6E66BF321" /></xsl:when>
							<xsl:when test="$Rulenumber = '47'"><id root="DAB0D223-4FA9-4B87-807D-1DA41AAE05C8" /></xsl:when>
							<xsl:when test="$Rulenumber = '48'"><id root="C8872545-E3A0-4FC3-82A6-038EED216FEE" /></xsl:when>
							<xsl:when test="$Rulenumber = '49'"><id root="A08E22DD-9B31-40AD-BA5C-5DB43F8FFBE4" /></xsl:when>
							<xsl:when test="$Rulenumber = '50'"><id root="B97723EA-4D1D-49BE-B6AF-EBE6B8DCB0F6" /></xsl:when>
							<xsl:when test="$Rulenumber = '58'"><id root="8DCAA512-21C0-4073-A31E-544E57283486" /></xsl:when>
							<xsl:when test="$Rulenumber = '59'"><id root="0D3BB774-897F-4E93-9EDE-29A9BC018043" /></xsl:when>
						</xsl:choose>
					</externalObservation>
				</reference>
			</observation>
		</component>
	</xsl:template>
	<!--END OF TEMPLATE Denominator Details-->

	<xsl:template name="NumDetails"  match="//NumDetails">
		<xsl:param name="Rulenumber" />
		<xsl:param name="PopulationSelector" />
		<xsl:param name="InstanceSelector" />
		<xsl:param name="StratumElements" />
		<xsl:variable name="elems" select="//measureDetails/Measure[Rulenumber=$Rulenumber and Title='5' and PopulationSelector=$PopulationSelector and InstanceSelector=$InstanceSelector]"/>		
		<component>
			<observation classCode="OBS" moodCode="EVN">
				<xsl:for-each select="$elems">
					<xsl:if test="Subtitle=1">
						<!-- Measure Data template -->
						<templateId root="2.16.840.1.113883.10.20.27.3.5"/>
						<code code="ASSERTION" codeSystem="2.16.840.1.113883.5.4" displayName="Assertion" codeSystemName="ActCode"/>
						<statusCode code="completed"/>
						<!-- SHALL value with SHOULD be from valueSetName="ObservationPopulationInclusion "	valueSetOid="2.16.840.1.113883.1.11.20369"	Binding: Dynamic -->
						<value xsi:type="CD" code="NUMER" codeSystem="2.16.840.1.113883.5.1063" displayName="Numerator" codeSystemName="ObservationValue"/>
						<!-- SHALL contain aggregate count template -->
						<entryRelationship typeCode="SUBJ" inversionInd="true">
							<!-- Aggregate Count (2.16.840.1.113883.10.20.27.3.3) -->
							<observation classCode="OBS" moodCode="EVN">
								<!-- Aggregate Count template -->
								<templateId root="2.16.840.1.113883.10.20.27.3.3"/>
								<code code="MSRAGG" displayName="rate aggregation" codeSystem="2.16.840.1.113883.5.4" codeSystemName="ActCode"/>
								<!--  SHALL value xsi:type="INT"-->
								<value xsi:type="INT">
									<xsl:attribute name="value">
										<xsl:value-of select='format-number(Totals, "#")' />
									</xsl:attribute>
								</value>
								<methodCode code="COUNT" displayName="Count" codeSystem="2.16.840.1.113883.5.84" codeSystemName="ObservationMethod"/>
								<!-- MAY 0..1 Used to represent the predicted count based on the measure’s risk-adjustment model. -->
								<referenceRange>
									<observationRange>
										<value xsi:type="INT" value="0"/>
										<!--FAKE VALUE-->
									</observationRange>
								</referenceRange>
							</observation>
						</entryRelationship>
					</xsl:if>
					<xsl:if test="Subtitle=1">
						<xsl:call-template name="ReportStratum">
							<xsl:with-param name="Rulenumber" select="$Rulenumber" />
							<xsl:with-param name="Title" select="5" />
							<xsl:with-param name="PopulationSelector" select="$PopulationSelector" />
							<xsl:with-param name="InstanceSelector" select="$InstanceSelector" />
							<xsl:with-param name="StratumElements" select="$StratumElements" />
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="Subtitle=2"><xsl:call-template name="Sex" /></xsl:if>
					<xsl:if test="Subtitle=3"><xsl:call-template name="Race" /></xsl:if>
					<xsl:if test="Subtitle=4"><xsl:call-template name="Ethnicity" /></xsl:if>
					<xsl:if test="Subtitle=5"><xsl:call-template name="Payer" /></xsl:if>
					<xsl:if test="Subtitle=6"><xsl:call-template name="PostalCode" /></xsl:if>
				</xsl:for-each>
				
				<xsl:if test="not($elems)">
						<!-- Measure Data template -->
						<templateId root="2.16.840.1.113883.10.20.27.3.5"/>
						<code code="ASSERTION" codeSystem="2.16.840.1.113883.5.4" displayName="Assertion" codeSystemName="ActCode"/>
						<statusCode code="completed"/>
						<!-- SHALL value with SHOULD be from valueSetName="ObservationPopulationInclusion "	valueSetOid="2.16.840.1.113883.1.11.20369"	Binding: Dynamic -->
						<value xsi:type="CD" code="NUMER" codeSystem="2.16.840.1.113883.5.1063" displayName="Numerator" codeSystemName="ObservationValue"/>
						<!-- SHALL contain aggregate count template -->
						<entryRelationship typeCode="SUBJ" inversionInd="true">
							<!-- Aggregate Count (2.16.840.1.113883.10.20.27.3.3) -->
							<observation classCode="OBS" moodCode="EVN">
								<!-- Aggregate Count template -->
								<templateId root="2.16.840.1.113883.10.20.27.3.3"/>
								<code code="MSRAGG" displayName="rate aggregation" codeSystem="2.16.840.1.113883.5.4" codeSystemName="ActCode"/>
								<!--  SHALL value xsi:type="INT"-->
								<value xsi:type="INT" value="0" />
								<methodCode code="COUNT" displayName="Count" codeSystem="2.16.840.1.113883.5.84" codeSystemName="ObservationMethod"/>
								<!-- MAY 0..1 Used to represent the predicted count based on the measure’s risk-adjustment model. -->
								<referenceRange>
									<observationRange>
										<value xsi:type="INT" value="0"/>
										<!--FAKE VALUE-->
									</observationRange>
								</referenceRange>
							</observation>
						</entryRelationship>
					<xsl:call-template name="ReportStratum">
						<xsl:with-param name="Rulenumber" select="$Rulenumber" />
						<xsl:with-param name="Title" select="5" />
						<xsl:with-param name="PopulationSelector" select="$PopulationSelector" />
						<xsl:with-param name="InstanceSelector" select="$InstanceSelector" />
						<xsl:with-param name="StratumElements" select="$StratumElements" />
					</xsl:call-template>
				</xsl:if>

				<!-- SHALL 1..1  (Note: this is the reference for the entire population starting with the first component
												observation at the top within the measure data template-->
				<reference typeCode="REFR">
					<!-- reference to the relevant population in the eMeasure -->
					<externalObservation classCode="OBS" moodCode="EVN">
						<xsl:choose>
							<xsl:when test="$Rulenumber = '1'"><id root="279AF66D-02AD-4B1A-BADE-C6FC0FE88AA6" /></xsl:when>
							<xsl:when test="$Rulenumber = '3'"><id root="7FCD316C-15D3-4A3B-810C-184227A5BFDB" /></xsl:when>
							<xsl:when test="$Rulenumber = '11'"><id root="7B460479-32E8-4DF6-855F-440086CB95F0" /></xsl:when>
							<xsl:when test="$Rulenumber = '12' and $PopulationSelector = '2'"><id root="115A65B2-B550-4385-B92A-B1D3AF875230" /></xsl:when>
							<xsl:when test="$Rulenumber = '12' and $PopulationSelector = '3'"><id root="B5C571FF-F899-4145-A8D4-CF0DFAB8962A" /></xsl:when>
							<xsl:when test="$Rulenumber = '14'"><id root="5486B836-8B5D-4A89-A172-30648A4519F2" /></xsl:when>
							<xsl:when test="$Rulenumber = '17'"><id root="B1F9DF65-674B-4465-8C19-F1523A00FE5D" /></xsl:when>
							<xsl:when test="$Rulenumber = '18'"><id root="5F834E7B-02CA-4A84-B4AB-6713E931A321" /></xsl:when>
							<xsl:when test="$Rulenumber = '23'"><id root="D050C1FA-DB6C-4FB0-A94F-0E450A455A0B" /></xsl:when>
							<xsl:when test="$Rulenumber = '33' and $InstanceSelector = '1'"><id root="5F846CD7-4760-4FD5-B968-E61BF61E5D7E" /></xsl:when>
							<xsl:when test="$Rulenumber = '33' and $InstanceSelector = '2'"><id root="F257DCE1-CB76-4147-BADC-3B52A8003A32" /></xsl:when>
							<xsl:when test="$Rulenumber = '35'"><id root="A4268F7D-181D-4CF4-89DE-C971498A26F5" /></xsl:when>
							<xsl:when test="$Rulenumber = '43'"><id root="035CCE7F-1141-4636-9168-B9D530E980F5" /></xsl:when>
							<xsl:when test="$Rulenumber = '47'"><id root="5EEFBE76-ADDD-4E44-912A-9E1AF9FD4B3B" /></xsl:when>
							<xsl:when test="$Rulenumber = '48'"><id root="B3432497-8340-4526-A0C3-62A0C7F5F01F" /></xsl:when>
							<xsl:when test="$Rulenumber = '49' and $InstanceSelector = '1'"><id root="E60D324E-7606-42C2-8E46-5EE29289725D" /></xsl:when>
							<xsl:when test="$Rulenumber = '49' and $InstanceSelector = '2'"><id root="E3ACA22F-9239-417D-8074-E4882FB0F848" /></xsl:when>
							<xsl:when test="$Rulenumber = '49' and $InstanceSelector = '3'"><id root="84C557E8-41B1-43F6-8C1B-1D204335AAFB" /></xsl:when>
							<xsl:when test="$Rulenumber = '50' and $InstanceSelector = '1'"><id root="5C60D69A-56F1-4649-B965-09C9A458A611" /></xsl:when>
							<xsl:when test="$Rulenumber = '50' and $InstanceSelector = '2'"><id root="4CDE555A-900B-430D-B00F-51AECA354EBE" /></xsl:when>
							<xsl:when test="$Rulenumber = '58'"><id root="21433413-1412-4FD7-B2CC-C3EE419629D8" /></xsl:when>
							<xsl:when test="$Rulenumber = '59'"><id root="4D9729C0-1E98-4514-9B41-31751237FA17" /></xsl:when>
						</xsl:choose>
					</externalObservation>
				</reference>
			</observation>
		</component>
	</xsl:template>
	<!--END OF TEMPLATE Numerator Details-->

	<xsl:template name="DenomExclusionsDetails"  match="//DenomExclusionsDetails">
		<xsl:param name="Rulenumber" />
		<xsl:param name="PopulationSelector" />
		<xsl:param name="InstanceSelector" />
		<xsl:param name="StratumElements" />
		<xsl:variable name="elems" select="//measureDetails/Measure[Rulenumber=$Rulenumber and Title='6' and PopulationSelector=$PopulationSelector and InstanceSelector=$InstanceSelector]"/>
		<component>
			<observation classCode="OBS" moodCode="EVN">
				<xsl:for-each select="$elems">
					<xsl:if test="Subtitle=1">
						<!-- Measure Data template -->
						<templateId root="2.16.840.1.113883.10.20.27.3.5"/>
						<code code="ASSERTION" codeSystem="2.16.840.1.113883.5.4" displayName="Assertion" codeSystemName="ActCode"/>
						<statusCode code="completed"/>
						<!-- SHALL value with SHOULD be from valueSetName="ObservationPopulationInclusion "	valueSetOid="2.16.840.1.113883.1.11.20369"	Binding: Dynamic -->
						<value xsi:type="CD" code="DENEX" codeSystem="2.16.840.1.113883.5.1063" displayName="Denominator Exclusions" codeSystemName="ObservationValue"/>
						<!-- SHALL contain aggregate count template -->
						<entryRelationship typeCode="SUBJ" inversionInd="true">
							<!-- Aggregate Count (2.16.840.1.113883.10.20.27.3.3) -->
							<observation classCode="OBS" moodCode="EVN">
								<!-- Aggregate Count template -->
								<templateId root="2.16.840.1.113883.10.20.27.3.3"/>
								<code code="MSRAGG" displayName="rate aggregation" codeSystem="2.16.840.1.113883.5.4" codeSystemName="ActCode"/>
								<!--  SHALL value xsi:type="INT"-->
								<value xsi:type="INT">
									<xsl:attribute name="value">
										<xsl:value-of select='format-number(Totals, "#")' />
									</xsl:attribute>
								</value>
								<methodCode code="COUNT" displayName="Count" codeSystem="2.16.840.1.113883.5.84" codeSystemName="ObservationMethod"/>
							</observation>
						</entryRelationship>
					</xsl:if>
					<xsl:if test="Subtitle=1">
						<xsl:call-template name="ReportStratum">
							<xsl:with-param name="Rulenumber" select="$Rulenumber" />
							<xsl:with-param name="Title" select="6" />
							<xsl:with-param name="PopulationSelector" select="$PopulationSelector" />
							<xsl:with-param name="InstanceSelector" select="$InstanceSelector" />
							<xsl:with-param name="StratumElements" select="$StratumElements" />
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="Subtitle=2"><xsl:call-template name="Sex" /></xsl:if>
					<xsl:if test="Subtitle=3"><xsl:call-template name="Race" /></xsl:if>
					<xsl:if test="Subtitle=4"><xsl:call-template name="Ethnicity" /></xsl:if>
					<xsl:if test="Subtitle=5"><xsl:call-template name="Payer" /></xsl:if>
					<xsl:if test="Subtitle=6"><xsl:call-template name="PostalCode" /></xsl:if>
				</xsl:for-each>

				<xsl:if test="not($elems)">
					<!-- Measure Data template -->
					<templateId root="2.16.840.1.113883.10.20.27.3.5"/>
					<code code="ASSERTION" codeSystem="2.16.840.1.113883.5.4" displayName="Assertion" codeSystemName="ActCode"/>
					<statusCode code="completed"/>
					<!-- SHALL value with SHOULD be from valueSetName="ObservationPopulationInclusion "	valueSetOid="2.16.840.1.113883.1.11.20369"	Binding: Dynamic -->
					<value xsi:type="CD" code="DENEX" codeSystem="2.16.840.1.113883.5.1063" displayName="Denominator Exclusions" codeSystemName="ObservationValue"/>
					<!-- SHALL contain aggregate count template -->
					<entryRelationship typeCode="SUBJ" inversionInd="true">
						<!-- Aggregate Count (2.16.840.1.113883.10.20.27.3.3) -->
						<observation classCode="OBS" moodCode="EVN">
							<!-- Aggregate Count template -->
							<templateId root="2.16.840.1.113883.10.20.27.3.3"/>
							<code code="MSRAGG" displayName="rate aggregation" codeSystem="2.16.840.1.113883.5.4" codeSystemName="ActCode"/>
							<!--  SHALL value xsi:type="INT"-->
							<value xsi:type="INT" value="0" />
							<methodCode code="COUNT" displayName="Count" codeSystem="2.16.840.1.113883.5.84" codeSystemName="ObservationMethod"/>
						</observation>
					</entryRelationship>
					<xsl:call-template name="ReportStratum">
						<xsl:with-param name="Rulenumber" select="$Rulenumber" />
						<xsl:with-param name="Title" select="6" />
						<xsl:with-param name="PopulationSelector" select="$PopulationSelector" />
						<xsl:with-param name="InstanceSelector" select="$InstanceSelector" />
						<xsl:with-param name="StratumElements" select="$StratumElements" />
					</xsl:call-template>
				</xsl:if>

				<!-- SHALL 1..1  (Note: this is the reference for the entire population starting with the first component
											observation at the top within the measure data template-->
				<reference typeCode="REFR">
					<!-- reference to the relevant population in the eMeasure -->
					<externalObservation classCode="OBS" moodCode="EVN">
						<xsl:choose>
							<xsl:when test="$Rulenumber = '1'"><id root="90B18275-DBB3-4773-9D63-F8A8BBE6B2CA" /></xsl:when>
							<xsl:when test="$Rulenumber = '12' and $PopulationSelector = '2'"><id root="32968CE2-29A3-45B3-8F36-B9A55D4A6ABA" /></xsl:when>
							<xsl:when test="$Rulenumber = '12' and $PopulationSelector = '3'"><id root="153BBCC1-CB2F-43CA-A153-8D4165C2F1DF" /></xsl:when>
							<xsl:when test="$Rulenumber = '17'"><id root="60DC1B8E-95D5-487D-B8CB-F4C0D127EF75" /></xsl:when>
							<xsl:when test="$Rulenumber = '23'"><id root="01E61291-7B85-4D80-9E70-47FEEFFA632B" /></xsl:when>
							<xsl:when test="$Rulenumber = '33' and $PopulationSelector = '1'"><id root="7F262D04-0E40-4CAD-BC6A-6DC160B52950" /></xsl:when>
							<xsl:when test="$Rulenumber = '33' and $PopulationSelector = '2'"><id root="88DE2857-B37F-4B74-B1DD-A8C3CC3D05A3" /></xsl:when>
							<xsl:when test="$Rulenumber = '43'"><id root="7966CC65-62B4-493E-8188-1E393BC900B1" /></xsl:when>
							<xsl:when test="$Rulenumber = '47'"><id root="79BF0F27-D9ED-4A1B-8691-4F530B82E702" /></xsl:when>
							<xsl:when test="$Rulenumber = '48'"><id root="DB8290E9-2933-4EDF-9C8A-80D9AF5074DB" /></xsl:when>
							<xsl:when test="$Rulenumber = '49'"><id root="FE61FF42-F9EF-4ADA-9D3F-E734B8D70E87" /></xsl:when>
							<xsl:when test="$Rulenumber = '58'"><id root="B23AFD67-635A-43A8-8478-2E19E555D11A" /></xsl:when>
							<xsl:when test="$Rulenumber = '59'"><id root="FB466533-16CF-4EA7-B0DA-6248AA7419CC" /></xsl:when>
						</xsl:choose>
					</externalObservation>
				</reference>
			</observation>
		</component>
	</xsl:template>
	<!--END OF TEMPLATE DENOM EXCLUSION Details-->

	<xsl:template name="DenomExceptionDetails"  match="//DenomExceptionsDetails">
		<xsl:param name="Rulenumber" />
		<xsl:param name="PopulationSelector" />
		<xsl:param name="InstanceSelector" />
		<xsl:param name="StratumElements" />
		<xsl:variable name="elems" select="//measureDetails/Measure[Rulenumber=$Rulenumber and Title='7' and PopulationSelector=$PopulationSelector and InstanceSelector=$InstanceSelector]"/>
		<component>
			<observation classCode="OBS" moodCode="EVN">
				<xsl:for-each select="$elems">
					<xsl:if test="Subtitle=1">
						<!-- Measure Data template -->
						<templateId root="2.16.840.1.113883.10.20.27.3.5"/>
						<code code="ASSERTION" codeSystem="2.16.840.1.113883.5.4"
							displayName="Assertion" codeSystemName="ActCode"/>
						<statusCode code="completed"/>
						<!-- SHALL value with SHOULD be from valueSetName="ObservationPopulationInclusion "	valueSetOid="2.16.840.1.113883.1.11.20369"	Binding: Dynamic -->
						<value xsi:type="CD" code="DENEXCEP" codeSystem="2.16.840.1.113883.5.1063" displayName="Denominator Exceptions" codeSystemName="ObservationValue"/>
						<!-- SHALL contain aggregate count template -->
						<entryRelationship typeCode="SUBJ" inversionInd="true">
							<!-- Aggregate Count (2.16.840.1.113883.10.20.27.3.3) -->
							<observation classCode="OBS" moodCode="EVN">
								<!-- Aggregate Count template -->
								<templateId root="2.16.840.1.113883.10.20.27.3.3"/>
								<code code="MSRAGG" displayName="rate aggregation" codeSystem="2.16.840.1.113883.5.4" codeSystemName="ActCode"/>
								<!--  SHALL value xsi:type="INT"-->
								<!-- In this case the count is 0, but it's a population, so send the count. -->
								<value xsi:type="INT">
									<xsl:attribute name="value">
										<xsl:value-of select='format-number(Totals, "#")' />
									</xsl:attribute>
								</value>
								<methodCode code="COUNT" displayName="Count" codeSystem="2.16.840.1.113883.5.84" codeSystemName="ObservationMethod"/>
							</observation>
						</entryRelationship>
					</xsl:if>
					<xsl:if test="Subtitle=1">
						<xsl:call-template name="ReportStratum">
							<xsl:with-param name="Rulenumber" select="$Rulenumber" />
							<xsl:with-param name="Title" select="7" />
							<xsl:with-param name="PopulationSelector" select="$PopulationSelector" />
							<xsl:with-param name="InstanceSelector" select="$InstanceSelector" />
							<xsl:with-param name="StratumElements" select="$StratumElements" />
						</xsl:call-template>
					</xsl:if>
					<xsl:if test="Subtitle=2"><xsl:call-template name="Sex" /></xsl:if>
					<xsl:if test="Subtitle=3"><xsl:call-template name="Race" /></xsl:if>
					<xsl:if test="Subtitle=4"><xsl:call-template name="Ethnicity" /></xsl:if>
					<xsl:if test="Subtitle=5"><xsl:call-template name="Payer" /></xsl:if>
					<xsl:if test="Subtitle=6"><xsl:call-template name="PostalCode" /></xsl:if>
				</xsl:for-each>

				<xsl:if test="not($elems)">
					<!-- Measure Data template -->
					<templateId root="2.16.840.1.113883.10.20.27.3.5"/>
					<code code="ASSERTION" codeSystem="2.16.840.1.113883.5.4"
						displayName="Assertion" codeSystemName="ActCode"/>
					<statusCode code="completed"/>
					<!-- SHALL value with SHOULD be from valueSetName="ObservationPopulationInclusion "	valueSetOid="2.16.840.1.113883.1.11.20369"	Binding: Dynamic -->
					<value xsi:type="CD" code="DENEXCEP" codeSystem="2.16.840.1.113883.5.1063" displayName="Denominator Exceptions" codeSystemName="ObservationValue"/>
					<!-- SHALL contain aggregate count template -->
					<entryRelationship typeCode="SUBJ" inversionInd="true">
						<!-- Aggregate Count (2.16.840.1.113883.10.20.27.3.3) -->
						<observation classCode="OBS" moodCode="EVN">
							<!-- Aggregate Count template -->
							<templateId root="2.16.840.1.113883.10.20.27.3.3"/>
							<code code="MSRAGG" displayName="rate aggregation" codeSystem="2.16.840.1.113883.5.4" codeSystemName="ActCode"/>
							<!--  SHALL value xsi:type="INT"-->
							<!-- In this case the count is 0, but it's a population, so send the count. -->
							<value xsi:type="INT" value="0" />
							<methodCode code="COUNT" displayName="Count" codeSystem="2.16.840.1.113883.5.84" codeSystemName="ObservationMethod"/>
						</observation>
					</entryRelationship>
					<xsl:call-template name="ReportStratum">
						<xsl:with-param name="Rulenumber" select="$Rulenumber" />
						<xsl:with-param name="Title" select="7" />
						<xsl:with-param name="PopulationSelector" select="$PopulationSelector" />
						<xsl:with-param name="InstanceSelector" select="$InstanceSelector" />
						<xsl:with-param name="StratumElements" select="$StratumElements" />
					</xsl:call-template>
				</xsl:if>

				<reference typeCode="REFR">
					<!-- reference to the relevant population in the eMeasure -->
					<externalObservation classCode="OBS" moodCode="EVN">
						<xsl:choose>
							<xsl:when test="$Rulenumber = '1'"><id root="0CDF2A7E-97A7-4B45-8719-A7416C71FDC3" /></xsl:when>
							<xsl:when test="$Rulenumber = '11'"><id root="1D224A7D-99A3-485F-8E74-52F619FE5861" /></xsl:when>
							<xsl:when test="$Rulenumber = '35'"><id root="F5E7BCB0-A1B7-4FE8-AFFF-F0F12D3BBFD3" /></xsl:when>
						</xsl:choose>
					</externalObservation>
				</reference>
			</observation>
		</component>
	</xsl:template>
	<!--END OF TEMPLATE DENOM EXCEPTIONS Details-->

	<!--SECTION MAKING CODES-->

	<xsl:template name="ReportStratum"  match="//ReportStratum">
		<xsl:param name="Rulenumber" />
		<xsl:param name="Title" />
		<xsl:param name="PopulationSelector" />
		<xsl:param name="InstanceSelector" />
		<xsl:param name="StratumElements" />
		<xsl:variable name="SectionInstanceSelector" select="$InstanceSelector" />
		<xsl:for-each select="$StratumElements">
			<xsl:variable name="StratumSelector" select="@StratumSelector" />
			<entryRelationship typeCode="COMP">
				<observation classCode="OBS" moodCode="EVN">
					<xsl:variable name="elems" select="//measureDetails/Measure[Rulenumber=$Rulenumber and Title=$Title and Subtitle=1 and PopulationSelector=$StratumSelector and InstanceSelector=$SectionInstanceSelector]"/>
					<xsl:for-each select="$elems">
						<!-- Reporting Stratum template -->
						<templateId root="2.16.840.1.113883.10.20.27.3.4"/>
						<code code="ASSERTION" codeSystem="2.16.840.1.113883.5.4" displayName="Assertion" codeSystemName="ActCode"/>
						<statusCode code="completed"/>
						<value xsi:type="CD" nullFlavor="OTH">
							<originalText>Stratum</originalText>
						</value>
						<entryRelationship typeCode="SUBJ" inversionInd="true">
							<observation classCode="OBS" moodCode="EVN">
								<!-- SHALL 1..1 Aggregate Count template -->
								<templateId root="2.16.840.1.113883.10.20.27.3.3"/>
								<code code="MSRAGG" displayName="rate aggregation" codeSystem="2.16.840.1.113883.5.4" codeSystemName="ActCode"/>
								<!--  SHALL value xsi:type="INT"-->
								<value xsi:type="INT">
									<xsl:attribute name="value">
										<xsl:value-of select='format-number(Totals, "#")' />
									</xsl:attribute>
								</value>
								<methodCode code="COUNT" displayName="Count" codeSystem="2.16.840.1.113883.5.84" codeSystemName="ObservationMethod"/>
							</observation>
						</entryRelationship>
					</xsl:for-each>

					<xsl:if test="not($elems)">
						<!-- Reporting Stratum template -->
						<templateId root="2.16.840.1.113883.10.20.27.3.4"/>
						<code code="ASSERTION" codeSystem="2.16.840.1.113883.5.4" displayName="Assertion" codeSystemName="ActCode"/>
						<statusCode code="completed"/>
						<value xsi:type="CD" nullFlavor="OTH">
							<originalText>Stratum</originalText>
						</value>
						<entryRelationship typeCode="SUBJ" inversionInd="true">
							<observation classCode="OBS" moodCode="EVN">
								<!-- SHALL 1..1 Aggregate Count template -->
								<templateId root="2.16.840.1.113883.10.20.27.3.3"/>
								<code code="MSRAGG" displayName="rate aggregation" codeSystem="2.16.840.1.113883.5.4" codeSystemName="ActCode"/>
								<!--  SHALL value xsi:type="INT"-->
								<value xsi:type="INT" value="0" />
								<methodCode code="COUNT" displayName="Count" codeSystem="2.16.840.1.113883.5.84" codeSystemName="ObservationMethod"/>
							</observation>
						</entryRelationship>
					</xsl:if>

					<reference typeCode="REFR">
						<!-- reference to the relevant strata in the eMeasure -->
						<externalObservation classCode="OBS" moodCode="EVN">
							<!-- Reference to the first defined Stratum -->
							<xsl:choose>
								<xsl:when test="$Rulenumber = '23' and $StratumSelector = '2'"><id root="B25C761A-E773-4A43-B7C8-7B7AC239C32A" /></xsl:when>
								<xsl:when test="$Rulenumber = '23' and $StratumSelector = '3'"><id root="924D8CB7-57B2-40EC-B136-820CEA0D7436" /></xsl:when>
								<xsl:when test="$Rulenumber = '23' and $StratumSelector = '4'"><id root="EC27DAB6-BEE1-4ABA-9EA7-F2352DBE45EA" /></xsl:when>
								<xsl:when test="$Rulenumber = '23' and $StratumSelector = '5'"><id root="549947EE-15BD-41FA-A1B5-7A25B9F56D18" /></xsl:when>
								<xsl:when test="$Rulenumber = '47' and $StratumSelector = '2'"><id root="5A86F687-6425-45BF-9167-4C311FE929EA" /></xsl:when>
								<xsl:when test="$Rulenumber = '47' and $StratumSelector = '3'"><id root="85F6C45A-82D1-45E2-BAA9-9F0D780AD237" /></xsl:when>
								<xsl:when test="$Rulenumber = '49' and $StratumSelector = '2'"><id root="95DF97E7-810D-48A5-8F02-99FA4B384A7B" /></xsl:when>
								<xsl:when test="$Rulenumber = '49' and $StratumSelector = '3'"><id root="5722134D-5F7C-42AD-914B-E73B4C366D55" /></xsl:when>
							</xsl:choose>
						</externalObservation>
					</reference>
				</observation>
			</entryRelationship>
		</xsl:for-each>
	</xsl:template>
	<!--END OF TEMPLATE ReportStratum-->

	<xsl:template name="PostalCode"  match="//PostalCode">
		<entryRelationship typeCode="COMP">
			<!-- Postal Code Supplemental Data Element (2.16.840.1.113883.10.20.27.3.10)-->
			<!-- Repeat for each postal code that has any data -->
			<observation classCode="OBS" moodCode="EVN">
				<!-- Postal Code Supplemental Data Element template ID -->
				<templateId root="2.16.840.1.113883.10.20.27.3.10"/>
				<!-- SHALL single value binding -->
				<code code="184102003" displayName="patient postal code" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED-CT"/>
				<statusCode code="completed"/>
				<!-- SHALL be xsi:type="ST"-->
				<value xsi:type="ST">92543</value>
				<!-- SHALL 1..1 Aggregate Count template -->
				<entryRelationship typeCode="SUBJ" inversionInd="true">
					<observation classCode="OBS" moodCode="EVN">
						<!-- Aggregate Count template -->
						<templateId root="2.16.840.1.113883.10.20.27.3.3"/>
						<code code="MSRAGG" displayName="rate aggregation" codeSystem="2.16.840.1.113883.5.4" codeSystemName="ActCode"/>
						<!--  SHALL value xsi:type="INT"-->
						<value xsi:type="INT">
							<xsl:attribute name="value">
								<xsl:value-of select='format-number(Totals, "#")' />
							</xsl:attribute>
						</value>
						<methodCode code="COUNT" displayName="Count" codeSystem="2.16.840.1.113883.5.84" codeSystemName="ObservationMethod"/>
					</observation>
				</entryRelationship>
			</observation>
		</entryRelationship>
	</xsl:template>
	<!--END OF TEMPLATE PostalCode-->

	<xsl:template name="Sex"  match="//Sex">
		<entryRelationship typeCode="COMP">
			<!-- Sex Supplemental Data Element (2.16.840.1.113883.10.20.27.3.6) -->
			<observation classCode="OBS" moodCode="EVN">
				<!-- Sex Supplemental Data Element template ID -->
				<templateId root="2.16.840.1.113883.10.20.27.3.6"/>
				<!-- SHALL be single value binding to: -->
				<code code="184100006" displayName="patient sex" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED-CT"/>
				<statusCode code="completed"/>
				<!-- SHALL be drawn from  Value Set: Administrative Gender (HL7 V3) 2.16.840.1.113883.1.11.1 DYNAMIC-->
				<!-- Female -->
				<value xsi:type="CD" codeSystem="2.16.840.1.113883.5.1" codeSystemName="HL7AdministrativeGenderCode">
					<xsl:attribute name="code">
						<xsl:value-of select="Ansicode" />
					</xsl:attribute>
				</value>
				<entryRelationship typeCode="SUBJ" inversionInd="true">
					<observation classCode="OBS" moodCode="EVN">
						<!-- SHALL 1..1 Aggregate Count template -->
						<templateId root="2.16.840.1.113883.10.20.27.3.3"/>
						<code code="MSRAGG" displayName="rate aggregation" codeSystem="2.16.840.1.113883.5.4" codeSystemName="ActCode"/>
						<!--  SHALL value xsi:type="INT"-->
						<value xsi:type="INT">
							<xsl:attribute name="value">
								<xsl:value-of select='format-number(Totals, "#")' />
							</xsl:attribute>
						</value>
						<methodCode code="COUNT" displayName="Count" codeSystem="2.16.840.1.113883.5.84" codeSystemName="ObservationMethod"/>
					</observation>
				</entryRelationship>
			</observation>
		</entryRelationship>
	</xsl:template>
	<!--END OF TEMPLATE Sex-->

	<xsl:template name="Race"  match="//Race">
		<entryRelationship typeCode="COMP">
			<!-- Race Supplemental Data Element (2.16.840.1.113883.10.20.27.3.8) -->
			<observation classCode="OBS" moodCode="EVN">
				<!-- Race Supplemental Data Element template ID -->
				<templateId root="2.16.840.1.113883.10.20.27.3.8"/>
				<code code="103579009" displayName="Race" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED CT"/>
				<statusCode code="completed"/>
				<!-- SHALL be bound to CDC Race Category Value Set OID 2.16.840.1.114222.4.11.836 - dynamic -->
				<value xsi:type="CD" codeSystem="2.16.840.1.113883.6.238" codeSystemName="Race &amp; Ethnicity - CDC">
					<xsl:attribute name="code">
						<xsl:value-of select="Ansicode" />
					</xsl:attribute>
					<xsl:attribute name="displayName">
						<xsl:value-of select="SubHeading" />
					</xsl:attribute>
				</value>
				<entryRelationship typeCode="SUBJ" inversionInd="true">
					<observation classCode="OBS" moodCode="EVN">
						<!-- SHALL 1..1 Aggregate Count template -->
						<templateId root="2.16.840.1.113883.10.20.27.3.3"/>
						<code code="MSRAGG" displayName="rate aggregation" codeSystem="2.16.840.1.113883.5.4" codeSystemName="ActCode"/>
						<!--  SHALL value xsi:type="INT"-->
						<value xsi:type="INT">
							<xsl:attribute name="value">
								<xsl:value-of select='format-number(Totals, "#")' />
							</xsl:attribute>
						</value>
						<methodCode code="COUNT" displayName="Count" codeSystem="2.16.840.1.113883.5.84" codeSystemName="ObservationMethod"/>
					</observation>
				</entryRelationship>
			</observation>
		</entryRelationship>
	</xsl:template>
	<!--END OF TEMPLATE Race-->

	<xsl:template name="Ethnicity"  match="//Ethnicity">
		<entryRelationship typeCode="COMP">
			<!-- Ethnicity Supplemental Data Element (2.16.840.1.113883.10.20.27.3.7) -->
			<observation classCode="OBS" moodCode="EVN">
				<!-- Ethnicity Supplemental Data Element template ID -->
				<templateId root="2.16.840.1.113883.10.20.27.3.7"/>
				<code code="364699009" displayName="Ethnic Group" codeSystem="2.16.840.1.113883.6.96" codeSystemName="SNOMED CT"/>
				<statusCode code="completed"/>
				<!-- SHALL be bound to CDC Ethnicity group Value Set OID 2.16.840.1.114222.4.11.837 - dynamic -->
				<!-- Hispanic -->
				<value xsi:type="CD" codeSystem="2.16.840.1.113883.6.238" codeSystemName="Race &amp; Ethnicity - CDC">
					<xsl:attribute name="code">
						<xsl:if test="Ansicode='Hispanic or Latino'">
							<xsl:text>2135-2</xsl:text>
						</xsl:if>
						<xsl:if test="Ansicode='Not Hispanic or Latino'">
							<xsl:text>2186-5</xsl:text>
						</xsl:if>
					</xsl:attribute>
					<xsl:attribute name="displayName">
						<xsl:value-of select="Ansicode" />
					</xsl:attribute>
				</value>
				<!-- SHALL 1..1 Aggregate Count template -->
				<entryRelationship typeCode="SUBJ" inversionInd="true">
					<observation classCode="OBS" moodCode="EVN">
						<!-- Aggregate Count template -->
						<templateId root="2.16.840.1.113883.10.20.27.3.3"/>
						<code code="MSRAGG" displayName="rate aggregation" codeSystem="2.16.840.1.113883.5.4" codeSystemName="ActCode"/>
						<!--  SHALL value xsi:type="INT"-->
						<value xsi:type="INT">
							<xsl:attribute name="value">
								<xsl:value-of select='format-number(Totals, "#")' />
							</xsl:attribute>
						</value>
						<methodCode code="COUNT" displayName="Count" codeSystem="2.16.840.1.113883.5.84" codeSystemName="ObservationMethod"/>
					</observation>
				</entryRelationship>
			</observation>
		</entryRelationship>
	</xsl:template>
	<!--END OF TEMPLATE Ethnicity-->

	<xsl:template name="Payer"  match="//Payer">
		<entryRelationship typeCode="COMP">
			<!-- Payer Supplemental Data Element (2.16.840.1.113883.10.20.27.3.9) -->
			<observation classCode="OBS" moodCode="EVN">
				<!-- Conforms to Patient Characteristic Payer -->
				<templateId root="2.16.840.1.113883.10.20.24.3.55"/>
				<!-- Payer Supplemental Data Element template ID -->
				<templateId root="2.16.840.1.113883.10.20.27.3.9"/>
				<!-- implied template requires ID -->
				<id nullFlavor="NA"/>
				<!-- SHALL be single value binding to: -->
				<code code="48768-6" displayName="Payment source" codeSystem="2.16.840.1.113883.6.1" codeSystemName="SNOMED-CT"/>
				<statusCode code="completed"/>
				<!-- SHALL be drawn from  Value Set: PHDSC Source of Payment Typology 2.16.840.1.114222.4.11.3591 DYNAMIC-->
				<value xsi:type="CD" code="1" codeSystem="2.16.840.1.113883.3.221.5" codeSystemName="Source of Payment Typology" displayName="Medicare"/>
				<entryRelationship typeCode="SUBJ" inversionInd="true">
					<observation classCode="OBS" moodCode="EVN">
						<!-- SHALL 1..1 Aggregate Count template -->
						<templateId root="2.16.840.1.113883.10.20.27.3.3"/>
						<code code="MSRAGG" displayName="rate aggregation" codeSystem="2.16.840.1.113883.5.4" codeSystemName="ActCode"/>
						<!--  SHALL value xsi:type="INT"-->
						<value xsi:type="INT">
							<xsl:attribute name="value">
								<xsl:value-of select='format-number(Totals, "#")' />
							</xsl:attribute>
						</value>
						<methodCode code="COUNT" displayName="Count" codeSystem="2.16.840.1.113883.5.84" codeSystemName="ObservationMethod"/>
					</observation>
				</entryRelationship>
			</observation>
		</entryRelationship>
	</xsl:template>
	<!--END OF TEMPLATE Payer-->

	<!--END OF SECTION MAKING QUERIES-->

</xsl:stylesheet>
