<?xml version="1.0" encoding="UTF-8" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
	<xsl:output method="xml" omit-xml-declaration="no" indent="yes"/>
	<xsl:template match="PQRI">
		<submission type="PQRI-REGISTRY" option="TEST" version="2.0" xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance" xsi:noNamespaceSchemaLocation="Registry_Payment.xsd">
			<file-audit-data>
				<create-date>
					<xsl:value-of select="DocumentDate" />
				</create-date>
				<create-time>
					<xsl:value-of select="DocumentTime" />
				</create-time>
				<create-by>
					<xsl:value-of select="practiceName" />
				</create-by>
				<version>1.0</version>
				<file-number>1</file-number>
				<number-of-files>
					<xsl:value-of select="fileCount" />
				</number-of-files>>
			</file-audit-data>
			<registry>
				<registry-name>
					<xsl:value-of select="providerName" />
				</registry-name>
				<registry-id>
					<xsl:value-of select="providerTIN" />
				</registry-id>
				<submission-method>
					<xsl:value-of select="submissionMethod" />
				</submission-method>
			</registry>
			<measure-group ID="X">
				<provider>
					<npi>
						<xsl:value-of select="providerNPI" />
					</npi>
					<tin>
						<xsl:value-of select="providerTIN" />
					</tin>
					<waiver-signed>Y</waiver-signed>
					<encounter-from-date>
						<xsl:value-of select="messageStartDate" />
					</encounter-from-date>
					<encounter-to-date>
						<xsl:value-of select="messageEndDate" />
					</encounter-to-date>
					<!--
					<measure-group-stat>
						<ffs-patient-count>2</ffs-patient-count>
						<group-reporting-rate-numerator>27</group-reporting-rate-numerator>
						<group-eligible-instances>30</group-eligible-instances>
						<group-reporting-rate>90.00</group-reporting-rate>
					</measure-group-stat>-->
					
						<xsl:apply-templates select="measures"/>
					
				</provider>
			</measure-group>
		</submission>
	</xsl:template>
	<xsl:template name="measures"  match="//measures">
		<xsl:if test ="//measure/NQF != ''">
					<xsl:for-each select="//measure">
						<pqri-measure>
						<pqri-measure-number>
							<xsl:value-of select="NQF" />
						</pqri-measure-number>
						<eligible-instances>
							<xsl:value-of select="TotalPatients" />
						</eligible-instances>
						<meets-performance-instances>
							<xsl:value-of select="QualifiedCount" />
						</meets-performance-instances>
						<performance-exclusion-instances>
							<xsl:value-of select="Exclusions" />
						</performance-exclusion-instances>
						<performance-not-met-instances>
							<xsl:value-of select="NotMet" />
						</performance-not-met-instances>
						<reporting-rate>
							<xsl:value-of select="ReportingRate" />
						</reporting-rate>
						<xsl:if test ="PerformanceRate != ''">
						<performance-rate>
							<xsl:value-of select="PerformanceRate" />
						</performance-rate>
						</xsl:if>
						<xsl:if test ="PerformanceRate = ''">
							<performance-rate>0</performance-rate>
						</xsl:if>
						</pqri-measure>
						</xsl:for-each>
		</xsl:if>
	</xsl:template>
</xsl:stylesheet>
