SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IMO_LOAD_ICD_MODIFIERS]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[IMO_LOAD_ICD_MODIFIERS] AS' 
END
GO

ALTER PROC [dbo].[IMO_LOAD_ICD_MODIFIERS]
AS
BEGIN

	SELECT 'IMO_ICD_VIEW_MODIFIER';
	SELECT DISTINCT MO.ICD_MODIFIER_UID
      ,MO.ICD_MODIFIER_IMO_CODE
      ,MO.MODIFIER_TYPE
      ,MO.MODIFIER_ITEM
      ,MO.MODIFIER_ITEM_ORDER
      ,MO.MODIFIER_ITEM_DEFAULT
      ,MO.ICD_GLOBAL_CODE
      ,MO.MODIFIER_TYPE_TEXT
      ,MO.LastModifiedDate
		FROM IMO_ICD_MODIFIER MO WITH (NOLOCK)
			INNER JOIN IMO_ICD_MODIFIER_MAP MM WITH (NOLOCK) ON MO.ICD_MODIFIER_IMO_CODE = MM.ICD_MODIFIER_IMO_CODE;
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IMO_Migration_Post]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[IMO_Migration_Post] AS' 
END
GO
ALTER PROCEDURE [dbo].[IMO_Migration_Post] AS
BEGIN
	-- these are no longer used in PRM_Common
	IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'IMO_ICD_BASE_TEXT')
		DROP TABLE [IMO_ICD_BASE_TEXT]
	IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'IMO_ICD_CUSTOM_WORD_INDEX')
		DROP TABLE [IMO_ICD_CUSTOM_WORD_INDEX]
	IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'IMO_ICD_LEXICALS_TEXT')
		DROP TABLE [IMO_ICD_LEXICALS_TEXT]
	IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'IMO_ICD_SNOMEDCT')
		DROP TABLE [IMO_ICD_SNOMEDCT]
	IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'IMO_ICD_WORD_INDEX')
		DROP TABLE [IMO_ICD_WORD_INDEX]
	IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'IMO_ICD9_BASE_TEXT')
		DROP TABLE [IMO_ICD9_BASE_TEXT]
	IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[IMO_ICD_VIEW_CODE_SNO_JOIN]') AND name = N'PK_IMO_ICD_VIEW_CODE_SNO_JOIN')
		DROP INDEX [PK_IMO_ICD_VIEW_CODE_SNO_JOIN] ON [dbo].[IMO_ICD_VIEW_CODE_SNO_JOIN] WITH ( ONLINE = OFF )
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IMO_Migration_Pre]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[IMO_Migration_Pre] AS' 
END
GO


ALTER PROCEDURE [dbo].[IMO_Migration_Pre]
AS
BEGIN
PRINT 'IMO_Migration_Pre'
END 

BEGIN	-- 48533 Slow IMO
	IF EXISTS(SELECT * FROM sys.objects WHERE Name = 'PK_IMO_ICD_NOTES')
		ALTER TABLE [dbo].[IMO_ICD_NOTES] DROP CONSTRAINT [PK_IMO_ICD_NOTES]

	IF EXISTS(SELECT * FROM sys.indexes WHERE Name = 'IX_IMO_ICD_NOTES')
		DROP INDEX [IX_IMO_ICD_NOTES] ON [dbo].[IMO_ICD_NOTES];
END 	-- 48533 Slow IMO

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IMO_ProblemIT_Find_Subsequent_Diagnosis]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[IMO_ProblemIT_Find_Subsequent_Diagnosis] AS' 
END
GO



ALTER PROCEDURE [dbo].[IMO_ProblemIT_Find_Subsequent_Diagnosis]
	@icd09String VARCHAR(MAX), -- the matching ICD09
	@icd10String VARCHAR(MAX) -- the starting ICD10
AS
BEGIN
	/************************************************
	DO NOT USE THIS ANYMORE - HAS BEEN MOVED TO PRM IN 2015 PATCH1 (KEEP HERE FOR 2015 GA RC4 AND PRIOR)
	************************************************/

	-- 20150626 BMR Bug 38929 Added second fetch for broader return if no records
	-- 20150313 BMR Bug 35855

	-- create temp table for clarity ... not intended to be the most efficient .. sql knows it will return 0 rows
	SELECT TOP 0 NEWID() AS SearchUid, Code10, CodeDescription10, HccCommunityFactors, LexCode, ManifestationCode10, Billable10, Specific10, Primary10, 
		Code09, CodeDescription09, SnoMedCodeList, ModifierCodeList, ModifiersExistInSubCodes, Syn,
		CAST(0 AS INT) AS DisplayOrder, CAST(NULL AS UNIQUEIDENTIFIER) AS IMO_ProblemIT_Custom_Uid 
		INTO #tempSearchResults
		FROM IMO_ProblemIT_SearchResult_Base

	DECLARE @locDot TINYINT;
	SELECT @locDot = CHARINDEX('.', @icd10String);
	-- check for incomming format, if not NUM.N at least, then it is not valid as a initial code
	IF ((@locDot=0) OR (@locDot + 1) >= LEN(@icd10String))
		GOTO RETURNRESULTS; 

    -- get original modifier list
	DECLARE @originalModifierList VARCHAR(500);
	SELECT @originalModifierList = ISNULL(dbo.IMO_BuildModifierCodeList(@icd10String,1),'');

	-- we now know we have a potential initial, must check that is is not a subsequent
	-- check if this is already an initial, if not, no action needed
	IF NOT (@originalModifierList LIKE '%165%')
		GOTO RETURNRESULTS; 

    -- swap modifer for match
	SET @originalModifierList = REPLACE(@originalModifierList,'165','166');
	SET @originalModifierList = '%' + REPLACE(@originalModifierList,',','%') + '%'; -- so can use as a LIKE

	-- preprocess to extract the search string
	DECLARE @code10ToSearch VARCHAR(10) = SUBSTRING(@icd10String, 1, LEN(@icd10String)-1); -- lopp off end character
	IF (@locDot = LEN(@code10ToSearch)) -- if last char is now, then lopp it off also
		SET @code10ToSearch = SUBSTRING(@icd10String, 1, LEN(@icd10String)-1);
		
	-- do the search for a subsequent code
	SELECT DISTINCT BA.Code10, BA.CodeDescription10, HccCommunityFactors, LexCode, BA.ManifestationCode10, BA.Billable10, BA.Specific10, BA.Primary10, 
			BA.Code09, BA.CodeDescription09, BA.SnoMedCodeList, BA.ModifierCodeList, BA.ModifiersExistInSubCodes, Syn,
			CAST(0 AS INT) AS DisplayOrder, CAST(NULL AS UNIQUEIDENTIFIER) AS IMO_ProblemIT_Custom_Uid 
		INTO #tempSubsequentCodes
		FROM IMO_ProblemIT_SearchResult_Base BA
		WHERE BA.Code10 LIKE @code10ToSearch + '%' AND BA.Code09 = @icd09String 
			AND BA.ModifierCodeList LIKE (@originalModifierList);

	IF NOT EXISTS(SELECT * FROM #tempSubsequentCodes)
		INSERT INTO #tempSubsequentCodes
		SELECT DISTINCT BA.Code10, BA.CodeDescription10, HccCommunityFactors, LexCode, BA.ManifestationCode10, BA.Billable10, BA.Specific10, BA.Primary10, 
				BA.Code09, BA.CodeDescription09, BA.SnoMedCodeList, BA.ModifierCodeList, BA.ModifiersExistInSubCodes, Syn,
				CAST(0 AS INT) AS DisplayOrder, CAST(NULL AS UNIQUEIDENTIFIER) AS IMO_ProblemIT_Custom_Uid 
			FROM IMO_ProblemIT_SearchResult_Base BA
			WHERE BA.Code10 LIKE @code10ToSearch + '%' AND BA.Code09 = @icd09String 
				AND BA.ModifierCodeList LIKE ('%166%');

	INSERT INTO #tempSearchResults
		SELECT NEWID() AS SearchUid, *
			FROM #tempSubsequentCodes;

RETURNRESULTS:

SELECT 'IMO_View_ProblemIT_SearchResult';
SELECT *
	FROM #tempSearchResults;

IF (NOT OBJECT_ID('tempdb..#tempSubsequentCodes') IS NULL)
	DROP TABLE #tempSubsequentCodes;
DROP TABLE #tempSearchResults;

END;


/*

*/




















GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IMO_ProblemIT_Search_Setup_SearchResultsBase]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[IMO_ProblemIT_Search_Setup_SearchResultsBase] AS' 
END
GO







ALTER PROCEDURE [dbo].[IMO_ProblemIT_Search_Setup_SearchResultsBase]
AS
BEGIN

-- In Case Still Hanging Around BMR 20150716
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IMO_TEMP_SNOMED]') AND type in (N'U'))
	DROP TABLE [dbo].[IMO_TEMP_SNOMED];
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IMO_TEMP_MODIFIER]') AND type in (N'U'))
	DROP TABLE [dbo].[IMO_TEMP_MODIFIER];
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IMO_TEMP_SNO_MOD]') AND type in (N'U'))
	DROP TABLE [dbo].[IMO_TEMP_SNO_MOD];

SELECT DISTINCT ICD.ICD_BASE_TEXT_CODE, PREF_LEXICALS_TEXT_IMO_FLAG, SNO.SCT_CONCEPT_ID
	INTO IMO_TEMP_SNOMED
	FROM IMO_ICD ICD
		INNER JOIN IMO_ICD_SNOMEDCT SNO ON ICD.ICD_LEXICALS_TEXT_IMO_CODE = SNO.ICD_LEXICALS_TEXT_IMO_CODE;

CREATE CLUSTERED INDEX IX_TEMP_SNO
ON IMO_TEMP_SNOMED (ICD_BASE_TEXT_CODE, PREF_LEXICALS_TEXT_IMO_FLAG DESC, SCT_CONCEPT_ID);

SELECT DISTINCT ICD.ICD_BASE_TEXT_CODE, MM.ICD_MODIFIER_IMO_CODE
	INTO IMO_TEMP_MODIFIER
	FROM IMO_ICD ICD
		INNER JOIN IMO_ICD_MODIFIER_MAP MM ON ICD.ICD_IMO_CODE = MM.ICD_IMO_CODE

CREATE CLUSTERED INDEX IX_TEMP_MOD
ON IMO_TEMP_MODIFIER (ICD_BASE_TEXT_CODE, ICD_MODIFIER_IMO_CODE);

SELECT DISTINCT ICD_BASE_TEXT_CODE,
	dbo.IMO_BuildSnoMedCodeList(ICD.ICD_BASE_TEXT_CODE) AS SnoMedCodeList,
	dbo.IMO_BuildModifierCodeList(ICD.ICD_BASE_TEXT_CODE, 0) AS ModifierCodeList
	INTO IMO_TEMP_SNO_MOD
	FROM IMO_ICD ICD

CREATE CLUSTERED INDEX IX_TEMP_SNO_MOD
ON IMO_TEMP_SNO_MOD (ICD_BASE_TEXT_CODE);

DROP TABLE IMO_TEMP_SNOMED;
DROP TABLE IMO_TEMP_MODIFIER;

IF EXISTS(SELECT * FROM sys.tables WHERE name = 'IMO_Temp_ProblemIT_SearchResult_Base')
	DROP Table [IMO_Temp_ProblemIT_SearchResult_Base];

CREATE TABLE IMO_Temp_ProblemIT_SearchResult_Base (
	[Code10] [varchar] (10) not null,
	[CodeDescription10] [varchar] (500) not null,
	[HccCommunityFactors] [decimal](4, 3) NULL,
	[LexCode] [int] not null,
	[LexText] [VARCHAR] (512) NOT NULL,
	[LexCodeForCodeDescription10] [int] NOT NULL,
	[ManifestationCode10] [bit] not null,
	[Billable10] [bit] not null,
	[Specific10] [bit] not null,
	[Primary10] [bit] not null,
	[Code09] [varchar] (10) not null,
	[CodeDescription09] [varchar] (500) not null,
	[SnoMedCodeList] [varchar] (max) null,
	[ModifierCodeList] [varchar] (500) null,
	[ModifiersExistInSubCodes] [bit] not null,
	[Syn] [bit] not null,
	[Code09PrefBase] [int] not null,
	[Code10PrefBase] [int] not null
	);

INSERT INTO IMO_Temp_ProblemIT_SearchResult_Base
SELECT ICD.ICD_BASE_TEXT_CODE AS Code10, BT.BASE_TEXT CodeDescription10, COALESCE(BT.HCC_COMMUNITY_FACTORS, BT9.HCC_COMMUNITY_FACTORS) AS HCC_COMMUNITY_FACTORS, 
				LT.ICD_LEXICALS_TEXT_IMO_CODE AS LexCode, LT.IMO_LC_TEXT AS LexText, 0 AS LexCodeForCodeDescription10,
				BT.MANIFESTATION_CODE AS ManifestationCode10, BT.BILL_TYPE AS Billable10, CASE WHEN BT.NON_SPECIFIC_CODE = 0 THEN 1 ELSE 0 END AS Specific10, 
				CASE WHEN BT.NON_PRIMARY_CODE = 0 THEN 1 ELSE 0 END AS Primary10, ICD9.ICD9_BASE_TEXT_CODE AS Code09, 
				BT9.BASE_TEXT AS CodeDescription09, 
				TSM.SnoMedCodeList AS SnoMedCodeList, TSM.ModifierCodeList AS ModifierCodeList, 
				0 AS ModifiersExistInSubCodes, 0 AS Syn, ICD9.PREF_BASE_FLAG AS Code09PrefBase, ICD.PREF_BASE_FLAG AS Code10PrefBase
	FROM IMO_ICD_LEXICALS_TEXT LT
		INNER JOIN (SELECT DISTINCT ICD_LEXICALS_TEXT_IMO_CODE, ICD_BASE_TEXT_CODE, PREF_BASE_FLAG FROM IMO_ICD WITH (NOLOCK)) ICD  ON LT.ICD_LEXICALS_TEXT_IMO_CODE = ICD.ICD_LEXICALS_TEXT_IMO_CODE 
			INNER JOIN IMO_ICD_BASE_TEXT BT WITH (NOLOCK) ON ICD.ICD_BASE_TEXT_CODE = BT.ICD_BASE_TEXT_CODE 
		INNER JOIN (SELECT DISTINCT ICD_LEXICALS_TEXT_IMO_CODE, ICD9_BASE_TEXT_CODE, PREF_BASE_FLAG FROM IMO_ICD9 WITH (NOLOCK)) ICD9 ON LT.ICD_LEXICALS_TEXT_IMO_CODE = ICD9.ICD_LEXICALS_TEXT_IMO_CODE 
			INNER JOIN IMO_ICD9_BASE_TEXT BT9 WITH (NOLOCK) ON ICD9.ICD9_BASE_TEXT_CODE = BT9.ICD9_BASE_TEXT_CODE
		LEFT JOIN IMO_TEMP_SNO_MOD TSM WITH (NOLOCK) ON ICD.ICD_BASE_TEXT_CODE = TSM.ICD_BASE_TEXT_CODE;

DROP TABLE IMO_TEMP_SNO_MOD;

ALTER TABLE [dbo].[IMO_Temp_ProblemIT_SearchResult_Base] ADD  CONSTRAINT [PK_IMO_Temp_ProblemIT_SearchResult_Base] PRIMARY KEY CLUSTERED 
([LexCode] ASC,	[Code10] ASC,[Code09] ASC,[Code10PrefBase] ASC,[Code09PrefBase] ASC);
CREATE NONCLUSTERED INDEX [IX_IMO_Temp_ProblemIT_SearchResult_Base_PrefBase] ON [dbo].[IMO_Temp_ProblemIT_SearchResult_Base]
([Code09PrefBase] ASC,[Code10PrefBase] ASC,[LexCode] ASC,[Code10] ASC);
CREATE NONCLUSTERED INDEX [IX_IMO_Temp_ProblemIT_SearchResult_Base_LexCode] ON [dbo].[IMO_Temp_ProblemIT_SearchResult_Base]
([LexCode] ASC,[Code09PrefBase] ASC,[Code10PrefBase] ASC,[Code10] ASC);
CREATE NONCLUSTERED INDEX [IX_IMO_Temp_ProblemIT_SearchResult_Base_Code10] ON [dbo].[IMO_Temp_ProblemIT_SearchResult_Base]
([Code10] ASC,[LexCode] ASC,[Code09PrefBase] ASC,[Code10PrefBase] ASC)
INCLUDE ([Code09],[CodeDescription10],[HccCommunityFactors],[ManifestationCode10],[Billable10],	[Specific10],[Primary10],
	[CodeDescription09],[SnoMedCodeList],[ModifierCodeList],[ModifiersExistInSubCodes],	[Syn]) 

-- SET ModifierFlag

SELECT DISTINCT Code10, ModifierCodeList
INTO #tempSearch
FROM IMO_Temp_ProblemIT_SearchResult_Base
WHERE NOT ModifierCodeList IS NULL;

CREATE CLUSTERED INDEX IX_TEMP_SEARCH
ON #tempSearch (Code10)

UPDATE IMO_Temp_ProblemIT_SearchResult_Base 
	SET ModifiersExistInSubCodes = 
		CASE WHEN 
			(SELECT COUNT(*) FROM 
				(
				SELECT DISTINCT ModifierCodeList
				FROM #tempSearch TS 
				WHERE TS.Code10 LIKE dbo.IMO_StripToNextRoot(IMO_Temp_ProblemIT_SearchResult_Base.Code10) + '%'
				) DMCL ) > 1
			THEN 1 ELSE 0 END

DROP TABLE #tempSearch;

-- aggregate up the LexCodeForCodeDescription10
UPDATE IMO_Temp_ProblemIT_SearchResult_Base
	SET LexCodeForCodeDescription10 = ISNULL((SELECT TOP 1 IPITS.LexCode 
											FROM IMO_Temp_ProblemIT_SearchResult_Base IPITS 
											WHERE IPITS.Code10 = IMO_Temp_ProblemIT_SearchResult_Base.Code10 
												AND IPITS.LexText = IMO_Temp_ProblemIT_SearchResult_Base.CodeDescription10),0)

IF EXISTS(SELECT * FROM sys.tables WHERE name = 'IMO_ProblemIT_SearchResult_Base')
	DROP Table [IMO_ProblemIT_SearchResult_Base];

EXEC sp_rename 'IMO_Temp_ProblemIT_SearchResult_Base.PK_IMO_Temp_ProblemIT_SearchResult_Base', 'IMO_ProblemIT_SearchResult_Base.PK_IMO_ProblemIT_SearchResult_Base'; -- must be changed otherwise will get error next run
EXEC sp_rename 'IMO_Temp_ProblemIT_SearchResult_Base.IX_IMO_Temp_ProblemIT_SearchResult_Base_PrefBase', 'IX_IMO_ProblemIT_SearchResult_Base_PrefBase'; -- must be changed otherwise will get error next run
EXEC sp_rename 'IMO_Temp_ProblemIT_SearchResult_Base.IX_IMO_Temp_ProblemIT_SearchResult_Base_LexCode', 'IX_IMO_ProblemIT_SearchResult_Base_LexCode'; -- must be changed otherwise will get error next run
EXEC sp_rename 'IMO_Temp_ProblemIT_SearchResult_Base.IX_IMO_Temp_ProblemIT_SearchResult_Base_Code10', 'IX_IMO_ProblemIT_SearchResult_Base_Code10'; -- must be changed otherwise will get error next run
EXEC sp_rename 'IMO_Temp_ProblemIT_SearchResult_Base', 'IMO_ProblemIT_SearchResult_Base';

DELETE FROM ListProductCommon WHERE ProductCommonUid = '5DF73C5C-7B57-483B-9C2D-3F12E5BA3DA6';
INSERT INTO ListProductCommon (ProductCommonUid, ParameterName, DateTimeValue, LastModifiedDate)
	SELECT '5DF73C5C-7B57-483B-9C2D-3F12E5BA3DA6', 'SearchResult Updates', DATEADD(hh, 12, CAST(CAST(GETUTCDATE() AS DATE) AS DATETIME)), GETUTCDATE();
	
END 

/*
*/


























































GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IMO_ProblemIT_Search_Setup_ClearDeleted]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[IMO_ProblemIT_Search_Setup_ClearDeleted] AS' 
END
GO


ALTER PROCEDURE [dbo].[IMO_ProblemIT_Search_Setup_ClearDeleted]
AS
BEGIN

	/*
		Clean Out IsDeleted Items in Target Database before building indexes
	*/

	DELETE FROM IMO_ICD WHERE IsDeleted = 1;
	DELETE FROM IMO_ICD_BASE_TEXT WHERE IsDeleted = 1;
	DELETE FROM IMO_ICD_CUSTOM_WORD_INDEX WHERE IsDeleted = 1;
	DELETE FROM IMO_ICD_LEXICALS_TEXT WHERE IsDeleted = 1;
	DELETE FROM IMO_ICD_MODIFIER WHERE IsDeleted = 1;
	DELETE FROM IMO_ICD_MODIFIER_MAP WHERE IsDeleted = 1;
	DELETE FROM IMO_ICD_SNOMEDCT WHERE IsDeleted = 1;
	DELETE FROM IMO_ICD_WORD_INDEX WHERE IsDeleted = 1;
	DELETE FROM IMO_ICD9 WHERE IsDeleted = 1;
	DELETE FROM IMO_ICD9_BASE_TEXT WHERE IsDeleted = 1;

END 

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IMO_ProblemIT_Search_Setup_LexicalsAndKeywords]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[IMO_ProblemIT_Search_Setup_LexicalsAndKeywords] AS' 
END
GO



ALTER PROCEDURE [dbo].[IMO_ProblemIT_Search_Setup_LexicalsAndKeywords]
AS
BEGIN

IF EXISTS(SELECT * FROM sys.tables WHERE name = 'IMO_Temp_ProblemIT_Keywords')
	DROP Table [IMO_Temp_ProblemIT_Keywords];
IF EXISTS(SELECT * FROM sys.tables WHERE name = 'IMO_Temp_ProblemIT_Lexicals')
	DROP Table [IMO_Temp_ProblemIT_Lexicals];

CREATE TABLE [IMO_Temp_ProblemIT_Lexicals] (
	[Code] [int] not null,
	[Title] [nvarchar] (500) not null,
	[ICD10_Code] nvarchar(15) null,
	[SCT_CONCEPT_ID] bigint null,
	CONSTRAINT [PK_IMO_Temp_ProblemIT_Lexicals] PRIMARY KEY (code)
	);
	
CREATE TABLE [IMO_Temp_ProblemIT_Keywords] (
	[Code] [int] not null,
	[WORD_TEXT] [nvarchar] (75) not null,
	[WORD_POS] [int] not null,
	CONSTRAINT [FK_IMO_Temp_ProblemIT_Keywords] FOREIGN KEY ([Code]) REFERENCES [IMO_Temp_ProblemIT_Lexicals]
	);

CREATE INDEX [IX_IMO_ProblemIT_Keywords] ON [IMO_Temp_ProblemIT_Keywords] (WORD_TEXT) INCLUDE ([Code],[WORD_POS]); -- -- these names are only unique by table
CREATE INDEX [IX_IMO_ProblemIT_Lexicals] ON [IMO_Temp_ProblemIT_Lexicals] (Code); -- these names are only unique by table

INSERT INTO [IMO_Temp_ProblemIT_Lexicals] ([Code] , [Title] , [ICD10_Code] , [SCT_CONCEPT_ID] )
	SELECT
		A.ICD_LEXICALS_TEXT_IMO_CODE,
		A.IMO_LC_Text,
		B.ICD_BASE_TEXT_CODE,
		C.SCT_CONCEPT_ID
	FROM
		IMO_ICD_LEXICALS_TEXT A
		INNER JOIN IMO_ICD B on A.ICD_LEXICALS_TEXT_IMO_CODE = B. ICD_LEXICALS_TEXT_IMO_CODE and B. PREF_BASE_FLAG = 1
		INNER JOIN IMO_ICD_SNOMEDCT C on A.ICD_LEXICALS_TEXT_IMO_CODE = C.ICD_LEXICALS_TEXT_IMO_CODE and C.PREF_SCT_FLAG = 1
	WHERE
		A.WORD_TYPE in ('PF' , 'SPF' , 'VO' , 'VWS' ) and
		ISNULL(A. CLINICIAN_TERM, 1) != 0;

INSERT INTO [IMO_Temp_ProblemIT_Keywords] (Code, Word_text, WORD_POS)
	SELECT DISTINCT
		a.Code,
		a.word_text,
		a.word_pos
	FROM
	(
		SELECT ICD_LEXICALS_TEXT_IMO_CODE Code, Word_text, CASE WHEN WORD_POS IS NULL THEN 10 ELSE WORD_POS END WORD_POS 
			FROM IMO_ICD_WORD_INDEX
		UNION ALL
		SELECT ICD_LEXICALS_TEXT_IMO_CODE Code, Word_text, 10 WORD_POS 
			FROM IMO_ICD_CUSTOM_WORD_INDEX
	) a,
	[IMO_Temp_ProblemIT_Lexicals] b
	WHERE a.code = b.code;

IF EXISTS(SELECT * FROM sys.tables WHERE name = 'IMO_ProblemIT_Keywords')
	DROP Table [IMO_ProblemIT_Keywords];
IF EXISTS(SELECT * FROM sys.tables WHERE name = 'IMO_ProblemIT_Lexicals')
	DROP Table [IMO_ProblemIT_Lexicals];

EXEC sp_rename 'FK_IMO_Temp_ProblemIT_Keywords', 'FK_IMO_ProblemIT_Keywords'; -- must be changed otherwise will get error next run (Prefixing with table name like PK, does not work)
EXEC sp_rename 'IMO_Temp_ProblemIT_Keywords', 'IMO_ProblemIT_Keywords';
EXEC sp_rename 'IMO_Temp_ProblemIT_Lexicals.PK_IMO_Temp_ProblemIT_Lexicals', 'PK_IMO_ProblemIT_Lexicals'; -- must be changed otherwise will get error next run
EXEC sp_rename 'IMO_Temp_ProblemIT_Lexicals', 'IMO_ProblemIT_Lexicals';

END 

/*
*/



GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IMO_ProblemIT_Search_Setup]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[IMO_ProblemIT_Search_Setup] AS' 
END
GO

ALTER PROCEDURE [dbo].[IMO_ProblemIT_Search_Setup]
AS
BEGIN

	EXEC dbo.IMO_ProblemIT_Search_Setup_ClearDeleted;
	EXEC dbo.IMO_ProblemIT_Search_Setup_LexicalsAndKeywords;
	EXEC dbo.IMO_ProblemIT_Search_Setup_SearchResultsBase;

END 

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ImportCMSCodesFromXml]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ImportCMSCodesFromXml] AS' 
END
GO



/*

exec [dbo].[ImportCMSCodesFromXml]  
	 @CommonDatabase =  'PRM_Common18.1'
	,@Refdatabasename = 'prmhead'

C:\dev\CQM2018\CodeSet\ImportCMSCodesFromXml.sql

select * from CMSCodeXml
select cqmversion, count(*) from MASTER_MU2_InterfaceDataMapping group by cqmversion
select cqmversion, count(*) from MU2_InterfaceDataMapping group by cqmversion



*/


ALTER PROCEDURE [dbo].[ImportCMSCodesFromXml]  
	 @CommonDatabase  varchar(128)  
	,@Refdatabasename varchar(128)  
AS  
BEGIN  
	SET NOCOUNT ON;  
	SET TRANSACTION ISOLATION LEVEL READ UNCOMMITTED

	PRINT @CommonDatabase  
	DECLARE @sql NVARCHAR(MAX)  
  
	IF @CommonDatabase like 'PRM_Common18%'  
	BEGIN  
  
		SET @sql = ';WITH XMLNAMESPACES (''urn:ihe:iti:svs:2008'' as ns)  
  
		INSERT INTO ['+@CommonDatabase+'].[dbo].[MASTER_MU2_InterfaceDataMapping] ([Rootid],[Name],[CCDCode],[PRMCode],[CCDPrintName],[IsDefault],[Inactive],[UserDefined],[LastModifiedDate],[LastModifiedByUid],[NCQMeasure],[TopicIndicator],[NQFNumber],[DataElementName],	[Modifier],[EndDate],[DisplayOrder],[QRDASection],[CQMVersion])  
		SELECT T3.C3.value(''(@codeSystem)[1]'', ''VARCHAR(50)'') AS Rootid  
			,T2.C2.value(''(ns:Group[@displayName="CATEGORY"]/ns:Keyword)[1]'',''VARCHAR(MAX)'') AS Name  
			,T3.C3.value(''(@code)[1]'', ''VARCHAR(100)'') AS PRMCode  
			,T3.C3.value(''(@code)[1]'', ''VARCHAR(100)'') AS CCDCode  
			,LEFT(T3.C3.value(''(@displayName)[1]'', ''VARCHAR(MAX)''),250) AS CCDPrintName  
			,0 AS IsDefault  
			,0 AS Inactive  
			,0 AS userDefined  
			,GETUTCDATE() AS LastModifiedDate  
			,NULL AS LastModifiedByUid  
			,dbp.Measure AS NCQMeasure  
			,T2.C2.value(''(@ID)[1]'',''VARCHAR(MAX)'') AS TopicIndicator  
			,CASE WHEN T2.C2.value(''(ns:Group[@displayName="NQF Number"]/ns:Keyword)[1]'',''VARCHAR(MAX)'') <> ''Not Applicable'' THEN T2.C2.value(''(ns:Group[@displayName="NQF Number"]/ns:Keyword)[1]'',''VARCHAR(MAX)'') ELSE NULL END AS NQFNumber  
			,T2.C2.value(''(@displayName)[1]'', ''VARCHAR(100)'') AS DataElementName  
			,NULL AS Modifier  
			,NULL AS EndDate  
			,1 AS DisplayOrder  
			,CASE WHEN T2.C2.value(''(ns:Group[@displayName="CATEGORY"]/ns:Keyword)[1]'',''VARCHAR(MAX)'') = ''Condition/Diagnosis/Problem'' THEN ''Problem'' ELSE T2.C2.value(''(ns:Group[@displayName="CATEGORY"]/ns:Keyword)[1]'',''VARCHAR(MAX)'') END AS QRDASection  
			,''CQM2019'' AS CQMVersion  
		FROM ['+@Refdatabasename+'].[dbo].[CMSCodeXml] dbp  
		CROSS APPLY dbp.XMLContent.nodes(''(ns:RetrieveMultipleValueSetsResponse/ns:DescribedValueSet[@displayName])'') AS T2(C2)  
		CROSS APPLY T2.C2.nodes(''(ns:ConceptList/ns:Concept)'') AS T3(C3)'  
		PRINT @sql
		EXEC (@sql)  

	END  
  
	IF @CommonDatabase = 'PRM_Common'  
	BEGIN  
  
		SET @sql = ';WITH XMLNAMESPACES (''urn:ihe:iti:svs:2008'' as ns)  
  
		INSERT INTO ['+@CommonDatabase+'].[dbo].[MASTER_MU2_InterfaceDataMapping] ([Rootid],[Name],[CCDCode],[PRMCode],[CCDPrintName],[IsDefault],[Inactive],[UserDefined],[LastModifiedDate],[LastModifiedByUid],[NCQMeasure],[TopicIndicator],[NQFNumber],[DataElementName],[Modifier],[EndDate],[DisplayOrder],[QRDASection])  
		SELECT T3.C3.value(''(@codeSystem)[1]'', ''VARCHAR(50)'') AS Rootid  
			,T2.C2.value(''(ns:Group[@displayName="CATEGORY"]/ns:Keyword)[1]'',''VARCHAR(MAX)'') AS Name  
			,T3.C3.value(''(@code)[1]'', ''VARCHAR(100)'') AS PRMCode  
			,T3.C3.value(''(@code)[1]'', ''VARCHAR(100)'') AS CCDCode  
			,LEFT(T3.C3.value(''(@displayName)[1]'', ''VARCHAR(MAX)''),250) AS CCDPrintName  
			,0 AS IsDefault  
			,0 AS Inactive  
			,0 AS userDefined  
			,GETUTCDATE() AS LastModifiedDate  
			,NULL AS LastModifiedByUid  
			,dbp.Measure AS NCQMeasure  
			,T2.C2.value(''(@ID)[1]'',''VARCHAR(MAX)'') AS TopicIndicator  
			,CASE WHEN T2.C2.value(''(ns:Group[@displayName="NQF Number"]/ns:Keyword)[1]'',''VARCHAR(MAX)'') <> ''Not Applicable'' THEN T2.C2.value(''(ns:Group[@displayName="NQF Number"]/ns:Keyword)[1]'',''VARCHAR(MAX)'') ELSE NULL END AS NQFNumber  
			,T2.C2.value(''(@displayName)[1]'', ''VARCHAR(100)'') AS DataElementName  
			,NULL AS Modifier  
			,NULL AS EndDate  
			,1 AS DisplayOrder  
			,CASE WHEN T2.C2.value(''(ns:Group[@displayName="CATEGORY"]/ns:Keyword)[1]'',''VARCHAR(MAX)'') = ''Condition/Diagnosis/Problem'' THEN ''Problem'' ELSE T2.C2.value(''(ns:Group[@displayName="CATEGORY"]/ns:Keyword)[1]'',''VARCHAR(MAX)'') END AS QRDASection  
		FROM ['+@Refdatabasename+'].[dbo].[CMSCodeXml] dbp  
		CROSS APPLY dbp.XMLContent.nodes(''(ns:RetrieveMultipleValueSetsResponse/ns:DescribedValueSet[@displayName])'') AS T2(C2)  
		CROSS APPLY T2.C2.nodes(''(ns:ConceptList/ns:Concept)'') AS T3(C3)'  
		PRINT @sql
		EXEC (@sql)  
	END  

	SELECT CQMVERSION, COUNT(*) FROM MASTER_MU2_InterfaceDataMapping GROUP BY CQMVersion ORDER BY CQMVersion DESC

END  
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ImportXMLCMSCodeFiles]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[ImportXMLCMSCodeFiles] AS' 
END
GO


ALTER PROCEDURE [dbo].[ImportXMLCMSCodeFiles]  
	@serverName			VARCHAR(500),        -- : SQL Server Name
	@databasename		VARCHAR(128),  		 -- : Database to load XML files to
	@sharedFolderPath	VARCHAR(MAX),  		 -- : Path of the XML files
	@schemaname			VARCHAR(128),  		 -- : Schema Name
	@printorexec		VARCHAR(5) = 'print' -- : execute code or just print the commands 
AS  
	SET NOCOUNT ON  
	PRINT @serverName  
	PRINT @databasename  
	PRINT @sharedFolderPath  
	PRINT @schemaname  
	PRINT @printorexec  
/*  
select @@Servername

EXEC [ImportXMLCMSCodeFiles]   
@serverName = 'DELL5FCCFH2',  
@databasename ='Z-V18-CQM-9100',  
@sharedFolderPath = 'C:\dev\CQM2019\CodeSet\CQM2019CodesetFiles\',  
@schemaname ='dbo',  
@printorexec ='EXEC'  

EXEC [ImportXMLCMSCodeFiles]   
@serverName = 'KODIAK',  
@databasename ='PRMHEAD',  
@sharedFolderPath = '\\kodiak\temp\CQMs\CQM2019XMLFiles\',  
@schemaname ='dbo',  
@printorexec ='EXEC'  


exec [dbo].[ImportCMSCodesFromXml]  
	 @CommonDatabase =  'PRM_Common'
	,@Refdatabasename = 'PRMHEAD'

select count(*) from prm_common.dbo.master_Mu2_Interfacedatamapping where CQMversion = 'CQM2019'
select top 10 * from prm_common.dbo.master_Mu2_Interfacedatamapping  
   
EXEC [ImportXMLCMSCodeFiles]   
@serverName = '783J662\BROBERTS1',  
@databasename ='PRM2015-Patch1-GA_NEW',  
@sharedFolderPath = 'C:\Users\broberts\Desktop\UsefulSQL\MUII\CMS2016Codes\ep_only_cms_20150501\',  
@schemaname ='dbo',  
@printorexec ='EXEC'  
  
EXEC [ImportXMLCMSCodeFiles]   
@serverName = '783J662\BROBERTS1',  
@databasename ='PRM2015-Patch1-GA_NEW',  
@sharedFolderPath = 'C:\Users\broberts\Desktop\UsefulSQL\MUII\CMS2016Codes\ep_only_cms_20150501\',  
@schemaname ='dbo',  
@printorexec ='EXEC'  

print @@servername  

EXEC [ImportXMLCMSCodeFiles]   
@serverName = '783J662\BROBERTS1',  
@databasename ='PRMHead2018',  
@sharedFolderPath = 'C:\Users\broberts\Desktop\UsefulSQL\MUII\CMS2016Codes\ep_only_cms_20150501\',  
@schemaname ='dbo',  
@printorexec ='EXEC'  
select * from 

EXEC [ImportXMLCMSCodeFiles]   
@serverName = 'Kodiak',  
@databasename ='PRMHead',  
@sharedFolderPath = '\\kodiak\temp\CQM2018XMLFiles\',  
@schemaname ='dbo',  
@printorexec ='EXEC'  


  
*/  
  
DECLARE @FilePaths		VARCHAR(MAX) = '' 
DECLARE @UpdateQuery	VARCHAR(MAX) = ''
DECLARE @SQL			VARCHAR(MAX) = ''  
  
IF OBJECT_ID('dbo.#Files', 'U') IS NOT NULL   
	DROP TABLE #Files;   
  
CREATE TABLE #Files (Paths VARCHAR(MAX))  
 
SET @sql = 'IF OBJECT_ID(''['+@databasename+'].dbo.CMSCodeXml'', ''U'') IS NOT NULL   
	DROP TABLE ['+@databasename+'].dbo.CMSCodeXml;'		
  
EXEC (@sql)  
  
SET @sql = 'CREATE TABLE ['+@databasename+'].dbo.CMSCodeXml (  
	FilePath VARCHAR(MAX)  
	,Measure VARCHAR(10)  
	,Content VARBINARY(MAX)  
	,XMLContent XML);'  
PRINT @SQL
   
EXEC (@sql)  
  
/*  
   
(To run this on KODIAK, you will need to save the folder in the temp folder on KODIAK (\\kodiak\temp))  
   
In the folder that contains the XML files, select all, hold down the shift key, right click and select 'Copy as Path'  
Paste the paths into Notepad++, find and replace double-quotes (") with empty strings ('').  
Navigate to the bottom of the list to the front of the last path, hold down Shift and Alt and PageUp to the top of the list.   
The cursor should be at the front of all of the paths, type a comma+open-parenthesis+single-quote ( ,(' ). This should put those characters at the front of each path.  
Move the cursor to the very top, very front of the first path in the list and bring up the Find and Replace window.  
In the Find and Replace window, make sure the 'Extended (...)' radiobutton in the Search Mode box is selected and place ( \r\n ) with a comma+close-parenthesis ( ,) ) without the parentheses.  
This should put everything on one line, turning the paths into a comma-delimited list of strings. Navigate to the end of the string and put a comma+close-parenthesis on the last path to close that item  
Paste this comma-delimited string list into the Insert statement below  
*/  
PRINT 'Getting ready to insert'  
SET @sql =   
'INSERT INTO ['+@databasename+'].dbo.CMSCodeXml (FilePath)   
VALUES  
('''+@sharedFolderPath+'CMS52v4.xml'')  
, ('''+@sharedFolderPath+'CMS56v4.xml''), ('''+@sharedFolderPath+'CMS61v5.xml''), ('''+@sharedFolderPath+'CMS62v4.xml''),  
('''+@sharedFolderPath+'CMS64v5.xml''), ('''+@sharedFolderPath+'CMS65v5.xml''), ('''+@sharedFolderPath+'CMS66v4.xml''), ('''+@sharedFolderPath+'CMS68v5.xml''),  
('''+@sharedFolderPath+'CMS69v4.xml''), ('''+@sharedFolderPath+'CMS74v5.xml''), ('''+@sharedFolderPath+'CMS75v4.xml''), ('''+@sharedFolderPath+'CMS77v4.xml''),  
('''+@sharedFolderPath+'CMS82v3.xml''), ('''+@sharedFolderPath+'CMS90v5.xml''), ('''+@sharedFolderPath+'CMS117v4.xml''),('''+@sharedFolderPath+'CMS122v4.xml''),  
('''+@sharedFolderPath+'CMS123v4.xml''),('''+@sharedFolderPath+'CMS124v4.xml''),('''+@sharedFolderPath+'CMS125v4.xml''),('''+@sharedFolderPath+'CMS126v4.xml''),  
('''+@sharedFolderPath+'CMS127v4.xml''),('''+@sharedFolderPath+'CMS128v4.xml''),('''+@sharedFolderPath+'CMS129v5.xml''),  
('''+@sharedFolderPath+'CMS130v4.xml''),('''+@sharedFolderPath+'CMS131v4.xml''),('''+@sharedFolderPath+'CMS132v4.xml''),('''+@sharedFolderPath+'CMS133v4.xml''),  
('''+@sharedFolderPath+'CMS134v4.xml''),('''+@sharedFolderPath+'CMS135v4.xml''),('''+@sharedFolderPath+'CMS136v5.xml''),('''+@sharedFolderPath+'CMS137v4.xml''),  
('''+@sharedFolderPath+'CMS138v4.xml''),('''+@sharedFolderPath+'CMS139v4.xml''),('''+@sharedFolderPath+'CMS140v4.xml''),('''+@sharedFolderPath+'CMS141v5.xml''),  
('''+@sharedFolderPath+'CMS142v4.xml''),('''+@sharedFolderPath+'CMS143v4.xml''),('''+@sharedFolderPath+'CMS144v4.xml''),('''+@sharedFolderPath+'CMS145v4.xml''),  
('''+@sharedFolderPath+'CMS146v4.xml''),('''+@sharedFolderPath+'CMS147v5.xml''),('''+@sharedFolderPath+'CMS148v4.xml''),('''+@sharedFolderPath+'CMS149v4.xml''),  
('''+@sharedFolderPath+'CMS153v4.xml''),('''+@sharedFolderPath+'CMS154v4.xml''),('''+@sharedFolderPath+'CMS155v4.xml''),('''+@sharedFolderPath+'CMS156v4.xml''),  
('''+@sharedFolderPath+'CMS157v4.xml''),('''+@sharedFolderPath+'CMS158v4.xml''),('''+@sharedFolderPath+'CMS159v4.xml''),('''+@sharedFolderPath+'CMS160v4.xml''),  
('''+@sharedFolderPath+'CMS161v4.xml''),('''+@sharedFolderPath+'CMS163v4.xml''),('''+@sharedFolderPath+'CMS164v4.xml''),('''+@sharedFolderPath+'CMS165v4.xml''),  
('''+@sharedFolderPath+'CMS166v5.xml''),('''+@sharedFolderPath+'CMS167v4.xml''),('''+@sharedFolderPath+'CMS169v4.xml''),('''+@sharedFolderPath+'CMS177v4.xml''),  
('''+@sharedFolderPath+'CMS179v4.xml''),('''+@sharedFolderPath+'CMS182v5.xml''),('''+@sharedFolderPath+'CMS2v5.xml''),  ('''+@sharedFolderPath+'CMS22v4.xml''),  
('''+@sharedFolderPath+'CMS50v4.xml'')'  
  
SET @sql =   
'INSERT INTO ['+@databasename+'].dbo.CMSCodeXml (FilePath)   
VALUES  
('''+@sharedFolderPath+'CMS2v6.xml''),('''+@sharedFolderPath+'CMS22v5.xml''),('''+@sharedFolderPath+'CMS50v5.xml''),('''+@sharedFolderPath+'CMS52v5.xml''),  
('''+@sharedFolderPath+'CMS56v5.xml''),('''+@sharedFolderPath+'CMS61v6.xml''),('''+@sharedFolderPath+'CMS62v5.xml''),('''+@sharedFolderPath+'CMS64v6.xml''),  
('''+@sharedFolderPath+'CMS65V6.xml''),('''+@sharedFolderPath+'CMS66v5.xml''),('''+@sharedFolderPath+'CMS68V6.xml''),('''+@sharedFolderPath+'CMS69V5.xml''),  
('''+@sharedFolderPath+'CMS74V6.xml''),('''+@sharedFolderPath+'CMS75V5.xml''),('''+@sharedFolderPath+'CMS77V5.xml''),('''+@sharedFolderPath+'CMS82V4.xml''),  
('''+@sharedFolderPath+'CMS90V6.xml''),('''+@sharedFolderPath+'CMS117V5.xml''),('''+@sharedFolderPath+'CMS122V5.xml''),('''+@sharedFolderPath+'CMS123V5.xml''),  
('''+@sharedFolderPath+'CMS124V5.xml''),('''+@sharedFolderPath+'CMS125V5.xml''),('''+@sharedFolderPath+'CMS126V5.xml''),('''+@sharedFolderPath+'CMS127V5.xml''),  
('''+@sharedFolderPath+'CMS128V5.xml''),('''+@sharedFolderPath+'CMS129V6.xml''),('''+@sharedFolderPath+'CMS130V5.xml''),('''+@sharedFolderPath+'CMS131V5.xml''),  
('''+@sharedFolderPath+'CMS132V5.xml''),('''+@sharedFolderPath+'CMS133V5.xml''),('''+@sharedFolderPath+'CMS134V5.xml''),('''+@sharedFolderPath+'CMS135V5.xml''),  
('''+@sharedFolderPath+'CMS136V6.xml''),('''+@sharedFolderPath+'CMS137V5.xml''),('''+@sharedFolderPath+'CMS138V5.xml''),('''+@sharedFolderPath+'CMS139V5.xml''),  
('''+@sharedFolderPath+'CMS140V5.xml''),('''+@sharedFolderPath+'CMS141V6.xml''),('''+@sharedFolderPath+'CMS142V5.xml''),('''+@sharedFolderPath+'CMS143V5.xml''),  
('''+@sharedFolderPath+'CMS144V5.xml''),('''+@sharedFolderPath+'CMS145V5.xml''),('''+@sharedFolderPath+'CMS146V5.xml''),('''+@sharedFolderPath+'CMS147V6.xml''),  
('''+@sharedFolderPath+'CMS148V5.xml''),('''+@sharedFolderPath+'CMS149V5.xml''),('''+@sharedFolderPath+'CMS153V6.xml''),('''+@sharedFolderPath+'CMS154V5.xml''),  
('''+@sharedFolderPath+'CMS155V5.xml''),('''+@sharedFolderPath+'CMS156V5.xml''),('''+@sharedFolderPath+'CMS157V5.xml''),('''+@sharedFolderPath+'CMS158V5.xml''),  
('''+@sharedFolderPath+'CMS159V5.xml''),('''+@sharedFolderPath+'CMS160V5.xml''),('''+@sharedFolderPath+'CMS161V5.xml''),('''+@sharedFolderPath+'CMS163V5.xml''),  
('''+@sharedFolderPath+'CMS164V5.xml''),('''+@sharedFolderPath+'CMS165V5.xml''),('''+@sharedFolderPath+'CMS166V6.xml''),('''+@sharedFolderPath+'CMS167V5.xml''),  
('''+@sharedFolderPath+'CMS169V5.xml''),('''+@sharedFolderPath+'CMS177V5.xml''),('''+@sharedFolderPath+'CMS179V5.xml''),('''+@sharedFolderPath+'CMS182V6.xml'')'  
   
--SET @sql =   'INSERT INTO ['+@databasename+'].dbo.CMSCodeXml (FilePath)    VALUES    ('''+@sharedFolderPath+'CMS2v6.xml'')'  
  

PRINT @sharedFolderPath
--2018
SET @sql =   
'INSERT INTO ['+@databasename+'].dbo.CMSCodeXml (FilePath)   
VALUES  
('''+@sharedFolderPath+  'CMS2v7.xml''), 
('''+@sharedFolderPath+ 'CMS22v6.xml''),
('''+@sharedFolderPath+ 'CMS50v6.xml''),
('''+@sharedFolderPath+ 'CMS52v6.xml''),  
('''+@sharedFolderPath+ 'CMS56v6.xml''),
('''+@sharedFolderPath+ 'CMS61v7.xml''),
('''+@sharedFolderPath+ 'CMS62v6.xml''),
('''+@sharedFolderPath+ 'CMS64v7.xml''),  
('''+@sharedFolderPath+ 'CMS65V7.xml''),
('''+@sharedFolderPath+ 'CMS66v6.xml''),
('''+@sharedFolderPath+ 'CMS68V7.xml''),
('''+@sharedFolderPath+ 'CMS69V5.xml''),  
('''+@sharedFolderPath+ 'CMS74V7.xml''),
('''+@sharedFolderPath+ 'CMS75V6.xml''),
('''+@sharedFolderPath+ 'CMS77V6.xml''),
('''+@sharedFolderPath+ 'CMS82V5.xml''),  
('''+@sharedFolderPath+ 'CMS90V7.xml''),
('''+@sharedFolderPath+ 'CMS117V6.xml''),
('''+@sharedFolderPath+ 'CMS122V6.xml''),
('''+@sharedFolderPath+ 'CMS123V6.xml''),  
('''+@sharedFolderPath+ 'CMS124V6.xml''),
('''+@sharedFolderPath+ 'CMS125V6.xml''),
('''+@sharedFolderPath+'CMS126V6.xml''),
('''+@sharedFolderPath+'CMS127V6.xml''),  
('''+@sharedFolderPath+'CMS128V6.xml''),
('''+@sharedFolderPath+'CMS129V7.xml''),
('''+@sharedFolderPath+'CMS130V6.xml''),
('''+@sharedFolderPath+'CMS131V6.xml''),  
('''+@sharedFolderPath+'CMS132V6.xml''),
('''+@sharedFolderPath+'CMS133V6.xml''),
('''+@sharedFolderPath+'CMS134V6.xml''),
('''+@sharedFolderPath+'CMS135V6.xml''),  
('''+@sharedFolderPath+'CMS136V7.xml''),
('''+@sharedFolderPath+'CMS137V6.xml''),
('''+@sharedFolderPath+'CMS138V6.xml''),
('''+@sharedFolderPath+'CMS139V6.xml''),  
('''+@sharedFolderPath+'CMS140V6.xml''),
('''+@sharedFolderPath+'CMS141V7.xml''),
('''+@sharedFolderPath+'CMS142V6.xml''),
('''+@sharedFolderPath+'CMS143V6.xml''),  
('''+@sharedFolderPath+'CMS144V6.xml''),
('''+@sharedFolderPath+'CMS145V6.xml''),
('''+@sharedFolderPath+'CMS146V6.xml''),
('''+@sharedFolderPath+'CMS147V7.xml''),  
('''+@sharedFolderPath+'CMS148V6.xml''),
('''+@sharedFolderPath+'CMS149V6.xml''),
('''+@sharedFolderPath+'CMS153V6.xml''),
('''+@sharedFolderPath+'CMS154V6.xml''),  
('''+@sharedFolderPath+'CMS155V6.xml''),
('''+@sharedFolderPath+'CMS156V6.xml''),
('''+@sharedFolderPath+'CMS157V6.xml''),
('''+@sharedFolderPath+'CMS158V6.xml''),  
('''+@sharedFolderPath+'CMS159V6.xml''),
('''+@sharedFolderPath+'CMS160V6.xml''),
('''+@sharedFolderPath+'CMS161V6.xml''),
('''+@sharedFolderPath+'CMS163V6.xml''),  
('''+@sharedFolderPath+'CMS164V6.xml''),
('''+@sharedFolderPath+'CMS165V6.xml''),
('''+@sharedFolderPath+'CMS166V7.xml''),
('''+@sharedFolderPath+'CMS167V6.xml''),  
('''+@sharedFolderPath+'CMS169V6.xml''),
('''+@sharedFolderPath+'CMS177V6.xml''),
('''+@sharedFolderPath+'CMS347V1.xml''),
('''+@sharedFolderPath+'CMS645V1.xml'')'  



SET @sql =   
'INSERT INTO ['+@databasename+'].dbo.CMSCodeXml (FilePath)   
VALUES  
('''+@sharedFolderPath+  'CMS117v7.xml''), 
   ('''+@sharedFolderPath+  'CMS122v7.xml''),
('''+@sharedFolderPath+  'CMS123v7.xml''),
('''+@sharedFolderPath+  'CMS124v7.xml''),  
('''+@sharedFolderPath+  'CMS125v7.xml''),
('''+@sharedFolderPath+  'CMS127v7.xml''),
('''+@sharedFolderPath+  'CMS128v7.xml''),
('''+@sharedFolderPath+  'CMS129v8.xml''),  
('''+@sharedFolderPath+  'CMS130v7.xml''),
('''+@sharedFolderPath+  'CMS131v7.xml''),
('''+@sharedFolderPath+  'CMS132v7.xml''),
('''+@sharedFolderPath+  'CMS133v7.xml''),  
('''+@sharedFolderPath+  'CMS134v7.xml''),
('''+@sharedFolderPath+  'CMS135v7.xml''),
('''+@sharedFolderPath+  'CMS136v8.xml''),
('''+@sharedFolderPath+  'CMS137v7.xml''),  
('''+@sharedFolderPath+  'CMS138v7.xml''),
('''+@sharedFolderPath+  'CMS139v7.xml''),
('''+@sharedFolderPath+  'CMS142v7.xml''),
('''+@sharedFolderPath+  'CMS143v7.xml''),  
('''+@sharedFolderPath+  'CMS144v7.xml''),
('''+@sharedFolderPath+  'CMS145v7.xml''),
('''+@sharedFolderPath+  'CMS146v7.xml''),
('''+@sharedFolderPath+  'CMS147v8.xml''),  
('''+@sharedFolderPath+  'CMS149v7.xml''),
('''+@sharedFolderPath+  'CMS153v7.xml''),
('''+@sharedFolderPath+  'CMS154v7.xml''),
('''+@sharedFolderPath+  'CMS155v7.xml''),  
('''+@sharedFolderPath+  'CMS156v7.xml''),
('''+@sharedFolderPath+  'CMS157v7.xml''),
('''+@sharedFolderPath+  'CMS158v7.xml''),
('''+@sharedFolderPath+  'CMS159v7.xml''),  
('''+@sharedFolderPath+  'CMS160v7.xml''),
('''+@sharedFolderPath+  'CMS161v7.xml''),
('''+@sharedFolderPath+  'CMS164v7.xml''),
('''+@sharedFolderPath+  'CMS165v7.xml''),  
('''+@sharedFolderPath+  'CMS167v7.xml''),
('''+@sharedFolderPath+  'CMS169v7.xml''),
('''+@sharedFolderPath+  'CMS177v7.xml''),
('''+@sharedFolderPath+  'CMS22v7.xml''),  
('''+@sharedFolderPath+  'CMS249v1.xml''),
('''+@sharedFolderPath+  'CMS2v8.xml''),
('''+@sharedFolderPath+  'CMS347v2.xml''),
('''+@sharedFolderPath+  'CMS349v1.xml''),  
('''+@sharedFolderPath+  'CMS50v7.xml''),
('''+@sharedFolderPath+  'CMS52v7.xml''),
('''+@sharedFolderPath+  'CMS56v7.xml''),
('''+@sharedFolderPath+  'CMS645v2.xml''),  
('''+@sharedFolderPath+  'CMS65v8.xml''),
('''+@sharedFolderPath+  'CMS66v7.xml''),
('''+@sharedFolderPath+  'CMS68v8.xml''),
('''+@sharedFolderPath+  'CMS69v7.xml''),  
('''+@sharedFolderPath+  'CMS74v8.xml''),
('''+@sharedFolderPath+  'CMS75v7.xml''),
('''+@sharedFolderPath+  'CMS82v6.xml''),
('''+@sharedFolderPath+  'CMS90v8.xml''),  
('''+@sharedFolderPath+  ''')'  

 
-- SET @sql = 'INSERT INTO ['+@databasename+'].dbo.CMSCodeXml (FilePath) VALUES ('''+@sharedFolderPath+'CMS2v6.xml'')'  
PRINT @SQL  

  
EXEC (@sql)  
-- print 'Blah1'  
SET @sql =   
'UPDATE ['+@databasename+'].dbo.CMSCodeXml  
SET Measure = REVERSE(SUBSTRING(REVERSE(REPLACE(REPLACE(FilePath, '''+@sharedFolderPath+''', ''''),''.xml'','''')),   
CHARINDEX(''v'', REVERSE(REPLACE(REPLACE(FilePath, '''+@sharedFolderPath+''', ''''),''.xml'','''')))+1, 8000))'  
   
--PRINT @SQL  
EXEC (@sql)  

 
SET @sql =   
'INSERT INTO #Files   
VALUES  
('''+@sharedFolderPath+'CMS52v4.xml''),('''+@sharedFolderPath+'CMS56v4.xml''),('''+@sharedFolderPath+'CMS61v5.xml''),('''+@sharedFolderPath+'CMS62v4.xml''),  
('''+@sharedFolderPath+'CMS64v5.xml''),('''+@sharedFolderPath+'CMS65v5.xml''),('''+@sharedFolderPath+'CMS66v4.xml''),('''+@sharedFolderPath+'CMS68v5.xml''),  
('''+@sharedFolderPath+'CMS69v4.xml''),('''+@sharedFolderPath+'CMS74v5.xml''),('''+@sharedFolderPath+'CMS75v4.xml''),('''+@sharedFolderPath+'CMS77v4.xml''),  
('''+@sharedFolderPath+'CMS82v3.xml''),('''+@sharedFolderPath+'CMS90v5.xml''),('''+@sharedFolderPath+'CMS117v4.xml''),('''+@sharedFolderPath+'CMS122v4.xml''),  
('''+@sharedFolderPath+'CMS123v4.xml''),('''+@sharedFolderPath+'CMS124v4.xml''),('''+@sharedFolderPath+'CMS125v4.xml''),('''+@sharedFolderPath+'CMS126v4.xml''),  
('''+@sharedFolderPath+'CMS127v4.xml''),('''+@sharedFolderPath+'CMS128v4.xml''),('''+@sharedFolderPath+'CMS129v5.xml''),('''+@sharedFolderPath+'CMS130v4.xml''),  
('''+@sharedFolderPath+'CMS131v4.xml''),('''+@sharedFolderPath+'CMS132v4.xml''),('''+@sharedFolderPath+'CMS133v4.xml''),('''+@sharedFolderPath+'CMS134v4.xml''),  
('''+@sharedFolderPath+'CMS135v4.xml''),('''+@sharedFolderPath+'CMS136v5.xml''),('''+@sharedFolderPath+'CMS137v4.xml''),('''+@sharedFolderPath+'CMS138v4.xml''),  
('''+@sharedFolderPath+'CMS139v4.xml''),('''+@sharedFolderPath+'CMS140v4.xml''),('''+@sharedFolderPath+'CMS141v5.xml''),('''+@sharedFolderPath+'CMS142v4.xml''),  
('''+@sharedFolderPath+'CMS143v4.xml''),('''+@sharedFolderPath+'CMS144v4.xml''),('''+@sharedFolderPath+'CMS145v4.xml''),('''+@sharedFolderPath+'CMS146v4.xml''),  
('''+@sharedFolderPath+'CMS147v5.xml''),('''+@sharedFolderPath+'CMS148v4.xml''),('''+@sharedFolderPath+'CMS149v4.xml''),('''+@sharedFolderPath+'CMS153v6.xml''),  
('''+@sharedFolderPath+'CMS154v4.xml''),('''+@sharedFolderPath+'CMS155v4.xml''),('''+@sharedFolderPath+'CMS156v4.xml''),('''+@sharedFolderPath+'CMS157v4.xml''),  
('''+@sharedFolderPath+'CMS158v4.xml''),('''+@sharedFolderPath+'CMS159v4.xml''),('''+@sharedFolderPath+'CMS160v4.xml''),('''+@sharedFolderPath+'CMS161v4.xml''),  
('''+@sharedFolderPath+'CMS163v4.xml''),('''+@sharedFolderPath+'CMS164v4.xml''),('''+@sharedFolderPath+'CMS165v4.xml''),('''+@sharedFolderPath+'CMS166v5.xml''),  
('''+@sharedFolderPath+'CMS167v4.xml''),('''+@sharedFolderPath+'CMS169v4.xml''),('''+@sharedFolderPath+'CMS177v4.xml''),('''+@sharedFolderPath+'CMS179v4.xml''),  
('''+@sharedFolderPath+'CMS182v5.xml''),('''+@sharedFolderPath+'CMS2v5.xml''),('''+@sharedFolderPath+'CMS22v4.xml''),('''+@sharedFolderPath+'CMS50v4.xml'')'  
--PRINT @SQL  
SET @sql =   
'INSERT INTO #Files   
VALUES  
('''+@sharedFolderPath+'CMS2v6.xml''),('''+@sharedFolderPath+'CMS22v5.xml''),('''+@sharedFolderPath+'CMS52v5.xml''),('''+@sharedFolderPath+'CMS56v5.xml''),  
('''+@sharedFolderPath+'CMS65V6.xml''),('''+@sharedFolderPath+'CMS66v5.xml''),('''+@sharedFolderPath+'CMS68V6.xml''),('''+@sharedFolderPath+'CMS69V5.xml''),  
('''+@sharedFolderPath+'CMS74V6.xml''),('''+@sharedFolderPath+'CMS75V5.xml''),('''+@sharedFolderPath+'CMS82V4.xml''),('''+@sharedFolderPath+'CMS90V6.xml''),  
('''+@sharedFolderPath+'CMS117V5.xml''),('''+@sharedFolderPath+'CMS122V5.xml''),('''+@sharedFolderPath+'CMS123V5.xml''),('''+@sharedFolderPath+'CMS124V5.xml''),  
('''+@sharedFolderPath+'CMS125V5.xml''),('''+@sharedFolderPath+'CMS127V5.xml''),('''+@sharedFolderPath+'CMS128V5.xml''),('''+@sharedFolderPath+'CMS129V6.xml''),  
('''+@sharedFolderPath+'CMS130V5.xml''),('''+@sharedFolderPath+'CMS131V5.xml''),('''+@sharedFolderPath+'CMS132V5.xml''),('''+@sharedFolderPath+'CMS133V5.xml''),  
('''+@sharedFolderPath+'CMS134V5.xml''),('''+@sharedFolderPath+'CMS135V5.xml''),('''+@sharedFolderPath+'CMS136V6.xml''),('''+@sharedFolderPath+'CMS137V5.xml''),  
('''+@sharedFolderPath+'CMS138V5.xml''),('''+@sharedFolderPath+'CMS139V5.xml''),('''+@sharedFolderPath+'CMS142V5.xml''),('''+@sharedFolderPath+'CMS143V5.xml''),  
('''+@sharedFolderPath+'CMS144V5.xml''),('''+@sharedFolderPath+'CMS145V5.xml''),('''+@sharedFolderPath+'CMS146V5.xml''),('''+@sharedFolderPath+'CMS147V6.xml''),  
('''+@sharedFolderPath+'CMS149V5.xml''),('''+@sharedFolderPath+'CMS154V5.xml''),('''+@sharedFolderPath+'CMS155V5.xml''),('''+@sharedFolderPath+'CMS156V5.xml''),  
('''+@sharedFolderPath+'CMS157V5.xml''),('''+@sharedFolderPath+'CMS158V5.xml''),('''+@sharedFolderPath+'CMS159V5.xml''),('''+@sharedFolderPath+'CMS160V5.xml''),  
('''+@sharedFolderPath+'CMS161V5.xml''),('''+@sharedFolderPath+'CMS164V5.xml''),('''+@sharedFolderPath+'CMS165V5.xml''),('''+@sharedFolderPath+'CMS166V6.xml''),  
('''+@sharedFolderPath+'CMS167V5.xml''),('''+@sharedFolderPath+'CMS169V5.xml''),('''+@sharedFolderPath+'CMS177V5.xml'')'  
  
SET @sql =   
'INSERT INTO #Files   
VALUES  
('''+@sharedFolderPath+'CMS2v6.xml''),('''+@sharedFolderPath+'CMS22v5.xml''),('''+@sharedFolderPath+'CMS50v5.xml''),('''+@sharedFolderPath+'CMS52v5.xml''),  
('''+@sharedFolderPath+'CMS56v5.xml''),('''+@sharedFolderPath+'CMS61v6.xml''),('''+@sharedFolderPath+'CMS62v5.xml''),('''+@sharedFolderPath+'CMS64v6.xml''),  
('''+@sharedFolderPath+'CMS65V6.xml''),('''+@sharedFolderPath+'CMS66v5.xml''),('''+@sharedFolderPath+'CMS68V6.xml''),('''+@sharedFolderPath+'CMS69V5.xml''),  
('''+@sharedFolderPath+'CMS74V6.xml''),('''+@sharedFolderPath+'CMS75V5.xml''),('''+@sharedFolderPath+'CMS77V5.xml''),('''+@sharedFolderPath+'CMS82V4.xml''),  
('''+@sharedFolderPath+'CMS90V6.xml''),('''+@sharedFolderPath+'CMS117V5.xml''),('''+@sharedFolderPath+'CMS122V5.xml''),('''+@sharedFolderPath+'CMS123V5.xml''),  
('''+@sharedFolderPath+'CMS124V5.xml''),('''+@sharedFolderPath+'CMS125V5.xml''),('''+@sharedFolderPath+'CMS126V5.xml''),('''+@sharedFolderPath+'CMS127V5.xml''),  
('''+@sharedFolderPath+'CMS128V5.xml''),('''+@sharedFolderPath+'CMS129V6.xml''),('''+@sharedFolderPath+'CMS130V5.xml''),('''+@sharedFolderPath+'CMS131V5.xml''),  
('''+@sharedFolderPath+'CMS132V5.xml''),('''+@sharedFolderPath+'CMS133V5.xml''),('''+@sharedFolderPath+'CMS134V5.xml''),('''+@sharedFolderPath+'CMS135V5.xml''),  
('''+@sharedFolderPath+'CMS136V6.xml''),('''+@sharedFolderPath+'CMS137V5.xml''),('''+@sharedFolderPath+'CMS138V5.xml''),('''+@sharedFolderPath+'CMS139V5.xml''),  
('''+@sharedFolderPath+'CMS140V5.xml''),('''+@sharedFolderPath+'CMS141V6.xml''),('''+@sharedFolderPath+'CMS142V5.xml''),('''+@sharedFolderPath+'CMS143V5.xml''),  
('''+@sharedFolderPath+'CMS144V5.xml''),('''+@sharedFolderPath+'CMS145V5.xml''),('''+@sharedFolderPath+'CMS146V5.xml''),('''+@sharedFolderPath+'CMS147V6.xml''),  
('''+@sharedFolderPath+'CMS148V5.xml''),('''+@sharedFolderPath+'CMS149V5.xml''),('''+@sharedFolderPath+'CMS153V5.xml''),('''+@sharedFolderPath+'CMS154V5.xml''),  
('''+@sharedFolderPath+'CMS155V5.xml''),('''+@sharedFolderPath+'CMS156V5.xml''),('''+@sharedFolderPath+'CMS157V5.xml''),('''+@sharedFolderPath+'CMS158V5.xml''),  
('''+@sharedFolderPath+'CMS159V5.xml''),('''+@sharedFolderPath+'CMS160V5.xml''),('''+@sharedFolderPath+'CMS161V5.xml''),('''+@sharedFolderPath+'CMS163V5.xml''),  
('''+@sharedFolderPath+'CMS164V5.xml''),('''+@sharedFolderPath+'CMS165V5.xml''),('''+@sharedFolderPath+'CMS166V6.xml''),('''+@sharedFolderPath+'CMS167V5.xml''),  
('''+@sharedFolderPath+'CMS169V5.xml''),('''+@sharedFolderPath+'CMS177V5.xml''),('''+@sharedFolderPath+'CMS179V5.xml''),('''+@sharedFolderPath+'CMS182V6.xml'')'  
  

--2018
SET @sql =   
'INSERT INTO #Files   
VALUES  
('''+@sharedFolderPath+'CMS2v7.xml''),('''+@sharedFolderPath+'CMS22v6.xml''),('''+@sharedFolderPath+'CMS50v6.xml''),('''+@sharedFolderPath+'CMS52v6.xml''),('''+@sharedFolderPath+'CMS56v6.xml''),  
('''+@sharedFolderPath+'CMS65V7.xml''),('''+@sharedFolderPath+'CMS66v6.xml''),('''+@sharedFolderPath+'CMS68V7.xml''),
('''+@sharedFolderPath+'CMS69V6.xml''),  ('''+@sharedFolderPath+'CMS74V7.xml''),('''+@sharedFolderPath+'CMS75V6.xml''),('''+@sharedFolderPath+'CMS82V5.xml''),
('''+@sharedFolderPath+'CMS90V7.xml''),('''+@sharedFolderPath+'CMS117V6.xml''),('''+@sharedFolderPath+'CMS122V6.xml''),('''+@sharedFolderPath+'CMS123V6.xml''),('''+@sharedFolderPath+'CMS124V6.xml''),  
('''+@sharedFolderPath+'CMS125V6.xml''),('''+@sharedFolderPath+'CMS127V6.xml''),('''+@sharedFolderPath+'CMS128V6.xml''),('''+@sharedFolderPath+'CMS129V7.xml''),  
('''+@sharedFolderPath+'CMS130V6.xml''),('''+@sharedFolderPath+'CMS131V6.xml''),('''+@sharedFolderPath+'CMS132V6.xml''),('''+@sharedFolderPath+'CMS133V6.xml''),  
('''+@sharedFolderPath+'CMS134V6.xml''),('''+@sharedFolderPath+'CMS135V6.xml''),('''+@sharedFolderPath+'CMS136V7.xml''),('''+@sharedFolderPath+'CMS137V6.xml''),  
('''+@sharedFolderPath+'CMS138V6.xml''),('''+@sharedFolderPath+'CMS139V6.xml''),('''+@sharedFolderPath+'CMS142V6.xml''),('''+@sharedFolderPath+'CMS143V6.xml''),  
('''+@sharedFolderPath+'CMS144V6.xml''),('''+@sharedFolderPath+'CMS145V6.xml''),('''+@sharedFolderPath+'CMS146V6.xml''),('''+@sharedFolderPath+'CMS147V7.xml''),  
('''+@sharedFolderPath+'CMS149V6.xml''),('''+@sharedFolderPath+'CMS154V6.xml''),('''+@sharedFolderPath+'CMS155V6.xml''),('''+@sharedFolderPath+'CMS156V6.xml''),  
('''+@sharedFolderPath+'CMS157V6.xml''),('''+@sharedFolderPath+'CMS158V6.xml''),('''+@sharedFolderPath+'CMS159V6.xml''),('''+@sharedFolderPath+'CMS160V6.xml''),  
('''+@sharedFolderPath+'CMS161V6.xml''),('''+@sharedFolderPath+'CMS164V6.xml''),('''+@sharedFolderPath+'CMS165V6.xml''),('''+@sharedFolderPath+'CMS166V7.xml''),  
('''+@sharedFolderPath+'CMS167V6.xml''),('''+@sharedFolderPath+'CMS169V6.xml''),('''+@sharedFolderPath+'CMS177V6.xml''),('''+@sharedFolderPath+'CMS347V1.xml''),('''+@sharedFolderPath+'CMS645V1.xml'')'  



--2019
SET @sql =   
--'INSERT INTO ['+@databasename+'].dbo.CMSCodeXml (FilePath)   
'INSERT INTO #Files  (Paths)   


VALUES  
('''+@sharedFolderPath+  'CMS117v7.xml''), 
 ('''+@sharedFolderPath+  'CMS122v7.xml''),
('''+@sharedFolderPath+  'CMS123v7.xml''),
('''+@sharedFolderPath+  'CMS124v7.xml''),  
('''+@sharedFolderPath+  'CMS125v7.xml''),
('''+@sharedFolderPath+  'CMS127v7.xml''),
('''+@sharedFolderPath+  'CMS128v7.xml''),
('''+@sharedFolderPath+  'CMS129v8.xml''),  
('''+@sharedFolderPath+  'CMS130v7.xml''),
('''+@sharedFolderPath+  'CMS131v7.xml''),
('''+@sharedFolderPath+  'CMS132v7.xml''),
('''+@sharedFolderPath+  'CMS133v7.xml''),  
('''+@sharedFolderPath+  'CMS134v7.xml''),
('''+@sharedFolderPath+  'CMS135v7.xml''),
('''+@sharedFolderPath+  'CMS136v8.xml''),
('''+@sharedFolderPath+  'CMS137v7.xml''),  
('''+@sharedFolderPath+  'CMS138v7.xml''),
('''+@sharedFolderPath+  'CMS139v7.xml''),
('''+@sharedFolderPath+  'CMS142v7.xml''),
('''+@sharedFolderPath+  'CMS143v7.xml''),  
('''+@sharedFolderPath+  'CMS144v7.xml''),
('''+@sharedFolderPath+  'CMS145v7.xml''),
('''+@sharedFolderPath+  'CMS146v7.xml''),
('''+@sharedFolderPath+  'CMS147v8.xml''),  
('''+@sharedFolderPath+  'CMS149v7.xml''),
('''+@sharedFolderPath+  'CMS153v7.xml''),
('''+@sharedFolderPath+  'CMS154v7.xml''),
('''+@sharedFolderPath+  'CMS155v7.xml''),  
('''+@sharedFolderPath+  'CMS156v7.xml''),
('''+@sharedFolderPath+  'CMS157v7.xml''),
('''+@sharedFolderPath+  'CMS158v7.xml''),
('''+@sharedFolderPath+  'CMS159v7.xml''),  
('''+@sharedFolderPath+  'CMS160v7.xml''),
('''+@sharedFolderPath+  'CMS161v7.xml''),
('''+@sharedFolderPath+  'CMS164v7.xml''),
('''+@sharedFolderPath+  'CMS165v7.xml''),  
('''+@sharedFolderPath+  'CMS167v7.xml''),
('''+@sharedFolderPath+  'CMS169v7.xml''),
('''+@sharedFolderPath+  'CMS177v7.xml''),
('''+@sharedFolderPath+  'CMS22v7.xml''),  
('''+@sharedFolderPath+  'CMS249v1.xml''),
('''+@sharedFolderPath+  'CMS2v8.xml''),
('''+@sharedFolderPath+  'CMS347v2.xml''),
('''+@sharedFolderPath+  'CMS349v1.xml''),  
('''+@sharedFolderPath+  'CMS50v7.xml''),
('''+@sharedFolderPath+  'CMS52v7.xml''),
('''+@sharedFolderPath+  'CMS56v7.xml''),
('''+@sharedFolderPath+  'CMS645v2.xml''),  
('''+@sharedFolderPath+  'CMS65v8.xml''),
('''+@sharedFolderPath+  'CMS66v7.xml''),
('''+@sharedFolderPath+  'CMS68v8.xml''),
('''+@sharedFolderPath+  'CMS69v7.xml''),  
('''+@sharedFolderPath+  'CMS74v8.xml''),
('''+@sharedFolderPath+  'CMS75v7.xml''),
('''+@sharedFolderPath+  'CMS82v6.xml''),
('''+@sharedFolderPath+  'CMS90v8.xml'')'  
--('''+@sharedFolderPath+  ''')'  



--2019
--SET @sql =   
----'INSERT INTO ['+@databasename+'].dbo.CMSCodeXml (FilePath)   
--'INSERT INTO #Files  (Paths)   
--VALUES  
--('''+@sharedFolderPath+  'CMS161v7.xml'')' 

 
--SET @sql =   'INSERT INTO #Files    VALUES    ('''+@sharedFolderPath+'CMS153v6.xml'')'  
-- SET @sql =   'INSERT INTO #Files  VALUES ('''+@sharedFolderPath+'CMS2v6.xml'')'  

PRINT @SQL  
EXEC (@sql)  


--select * from [QASQL01].[Z_QAMASTER_2016GA_V18_9100].[dbo].[CMSCodeXml]
--select * from [kodiak].[prmhead].[dbo].[CMSCodeXml]
--insert into #Files select FilePath from   CMSCodeXml where coalesce(content,'') <> ''

DECLARE db_cursor CURSOR FOR    
SELECT Paths  
FROM #Files  
  
OPEN db_cursor     
FETCH NEXT FROM db_cursor INTO @FilePaths  
  
WHILE @@FETCH_STATUS = 0  
BEGIN  
IF (@@fetch_status <> - 2)  
BEGIN  
  
DECLARE @dircommand varchar(1500)  
DECLARE @insertquery varchar(2000)  
SET @updatequery = ''
  
  
SET @updatequery = 'update ['+@serverName+'].['+@databasename+'].['+@schemaname+'].[CMSCodeXml]   
	SET [Content] = (SELECT * FROM OPENROWSET(BULK "'+@FilePaths+'", SINGLE_BLOB)AS x )   
	WHERE [Filepath]="'+@FilePaths+'"'

IF @printorexec ='print'  
BEGIN  
	PRINT @updatequery  
END

PRINT @updatequery
  
IF @printorexec ='exec'  
BEGIN  
	SET @updatequery='SET quoted_identifier off' + char(10)+char(13)+@updatequery  
	exec (@updatequery)  
  
	SET @sql = 'UPDATE ['+@databasename+'].dbo.CMSCodeXml  
		SET XMLContent = CONVERT(VARCHAR(MAX),Content)  
		WHERE FilePath = '''+@FilePaths+''''  
	print @SQL
	EXEC (@sql)  
END  


  
END -- of IF   (@@fetch_status <> -2)  
FETCH NEXT FROM db_cursor INTO @FilePaths    
END  
CLOSE db_cursor  
DEALLOCATE db_cursor  



SET @sql = 'select * from ['+@databasename+'].dbo.CMSCodeXml'  
EXEC (@sql)  



GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_UpdateCopyright]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[NDD_UpdateCopyright] AS' 
END
GO

-- =================================================================
-- Author:		CHM
-- Create date: 06/05/2018
-- Description:	This store procedure will update the copyright 
--				information.
-- =================================================================
ALTER PROC [dbo].[NDD_UpdateCopyright]
		@copyright varchar(512)

AS
BEGIN
	UPDATE NDD_COPYRIGHT_INFO SET Copyright = @copyright, IsCurrentRow = 1, LastModifiedDate = getutcdate() WHERE [Uid] = 'EE2F8685-036E-497E-82BA-C764D7D9E1AA'
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_UpdateSearchDispensable]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[NDD_UpdateSearchDispensable] AS' 
END
GO

-- =================================================================
-- Author:		CHM
-- Create date: 08/22/2018
-- Description:	This store procedure will update table 
--				NDD_SearchDispensable.
--
-- 09/12/2018 - Added new columns "STRENGTH_UOM" and "VOLUME_UOM"
-- =================================================================
ALTER PROC [dbo].[NDD_UpdateSearchDispensable]
AS
BEGIN
	
declare @existingMEDID int
declare @existingIsDelete bit
declare @existingHASH varbinary(128)

declare @newMEDID int
declare @newGCN_SEQNO int
declare @newGENERIC_MEDID int
declare @newMED_STRENGTH [varchar](15)
declare @newMED_STRENGTH_UOM [varchar](15)
declare @newSTRENGTH_UOM [varchar](10)
declare @newVOLUME_UOM [varchar](10)
declare @newMedDesc [varchar](70)
declare @newSearchMedDesc [varchar](73)
declare @newStatusCode [varchar](1)
declare @newStatusCodeDescription [varchar](30) 
declare @newIsMedicalDevice [bit]
declare @newNameSourceCode [varchar](1)
declare @newRefFederalLegendCode [varchar](1) 
declare @newRefMultiSourceCode [varchar](1)
declare @newRefGenericDrugNameCode [varchar](1) 
declare @newIsSingleIngredient [bit]
declare @newrdfmid [int]
declare @newrmid [int]
declare @newrtid [int]
declare @newRouteAbbr [varchar](4) 
declare @newRouteDesc [varchar](30)
declare @newdfid [int]
declare @newDosageFormAbbr [varchar](4)
declare @newDosageFormDesc [varchar](30)
declare @newhicl [int]
declare @newRefFederalDEAClassCode [varchar](1)
declare @newclassid [int]
declare @newClassName [varchar](70)
declare @newRxNormCode [varchar](50)
declare @newRxNormQualifier [varchar](20)
declare @newNDC [varchar](11)

	-- drug name columns
declare @newmnid [int]
declare @newDrugName [varchar](30)
declare @newDrugNameTypeCode [varchar](1)
declare @newDrugNameType [varchar](30)
declare @newDrugNameRxNormCode [varchar](50)
declare @newDrugNameRxNormQualifier [varchar](10)

	-- generic columns
declare @newGenericMedDesc [varchar](70)
declare @newGenericRMID [int]
declare @newGenericMNID [int]
declare @newGenericDrugName [varchar](30)
declare @newGenericRxNormCode [varchar](50)
declare @newGenericRxNormQualifier [varchar](10)
declare @newGenericNDC [varchar](11)

declare @newIsDelete bit
declare @newHASH varbinary(128)

declare @newLastModifiedDate DateTime = getutcdate()

declare @updateCnt int = 0
declare @insertedCnt int = 0
declare @deletedCnt int = 0

declare out_cursor cursor for 
	select
		-- values dispensable medication columns
		dis.MEDID,
		dis.GCN_SEQNO,
		dis.GENERIC_MEDID,
		dis.MED_STRENGTH,
		dis.MED_STRENGTH_UOM,
		drugStrengthUOM.UOM,
		drugVolumeUOM.UOM,
		dis.MED_MEDID_DESC as [MedDesc],
		dbo.NDD_CreateSearchDescription(dis.MED_MEDID_DESC) as [SearchMedDesc],
		dis.MED_STATUS_CD as [StatusCode],
		statusDesc.MED_STATUS_CD_DESC as [StatusCodeDescription],
		dme.IsMedicalDevice as [IsMedicalDevice],
		dis.MED_NAME_SOURCE_CD as [NameSourceCode],
		dis.MED_REF_FED_LEGEND_IND as [RefFederalLegendCode],
		dis.MED_REF_MULTI_SOURCE_CD as [RefMultiSourceCode],
		dis.MED_REF_GEN_DRUG_NAME_CD as [RefGenericDrugNameCode],
		sii.IsSingleIngredient as [IsSingleIngredient],
		dis.ROUTED_DOSAGE_FORM_MED_ID as [rdfmid], -- One ROUTED_DOSAGE_FORM_MED_ID is linked to zero-to-many MED Medication IDs (MEDID).
		form.ROUTED_MED_ID as [rmid],
		routed.MED_ROUTE_ID as [rtid],
		routeInfo.MED_ROUTE_ABBR as [RouteAbbr],
		routeInfo.MED_ROUTE_DESC as [RouteDesc],
		form.MED_DOSAGE_FORM_ID as [dfid],
		doseFormInfo.MED_DOSAGE_FORM_ABBR as [DosageFormAbbr],
		doseFormInfo.MED_DOSAGE_FORM_DESC as [DosageFormDesc],
		gcn_seqnoMstr.HICL_SEQNO as [hicl],
		CASE WHEN dis.MED_REF_DEA_CD = '6' and medNDC.DEA in ('0','1','2','3','4','5') then medNDC.DEA else dis.MED_REF_DEA_CD end as [RefFederalDEAClassCode], 
		medClass.ETC_ID as [ClassID], 
		medClass.ETC_NAME as [ClassName],
		medRxNorm.RxNorm as [RxNormCode],
		medRxNorm.RxNormQualifier as [RxNormQualifier],
		medNDC.NDC as [NDC],

		-- values drug name columns
		drugName.MED_NAME_ID as [MNID],
		drugName.MED_NAME as [DrugName],
		drugName.MED_NAME_TYPE_CD as [DrugNameTypeCode],
		drugName.MED_NAME_TYPE_CD_DESC as [DrugNameType],
		drugNameRxNorm.RxNorm as [DrugNameRxNormCode],
		drugNameRxNorm.RxNormQualifier as [DrugNameRxNormQualifier],
		
		-- generic columns
		genericDis.MED_MEDID_DESC as [GenericMedDesc],
		genericForm.ROUTED_MED_ID as [GenericRMID],
		genericDrugName.MED_NAME_ID as [GenericMNID],
		genericDrugName.MED_NAME as [GenericDrugName],
		genericRxNorm.RxNorm as [GenericRxNormCode],
		genericRxNorm.RxNormQualifier as [GenericRxNormQualifier],
		genericNDC.NDC as [GenericNDC],

		dis.IsDelete

	FROM NDD_RMIID1_MED dis WITH(NOLOCK)
		inner join NDD_RMIDFID1_ROUTED_DOSE_FORM_MED form WITH(NOLOCK) on dis.ROUTED_DOSAGE_FORM_MED_ID = form.ROUTED_DOSAGE_FORM_MED_ID
		inner join NDD_RMISCD1_STATUS_DESC statusDesc WITH(NOLOCK) on statusDesc.MED_STATUS_CD = dis.MED_STATUS_CD
		outer apply (
			SELECT * from NDD_RGCNSEQ4_GCNSEQNO_MSTR
			WHERE GCN_SEQNO = dis.GCN_SEQNO 
		)
		as gcn_seqnoMstr
		outer apply (
			select top 1 t2.UOM_ABBR as [UOM]
			from NDD_RGCNSTR0_INGREDIENT_STRENGTH t1
			inner join NDD_RSTRUOM0_STRENGTH_UOM t2 on t1.STRENGTH_UOM_ID = t2.UOM_ID
			WHERE t1.GCN_SEQNO = dis.GCN_SEQNO
		)
		as drugStrengthUOM
		outer apply (
			select top 1 t3.UOM_ABBR as [UOM]
			from NDD_RGCNSTR0_INGREDIENT_STRENGTH t1
			inner join NDD_RSTRUOM0_STRENGTH_UOM t3 on t1.VOLUME_UOM_ID = t3.UOM_ID
			WHERE t1.GCN_SEQNO = dis.GCN_SEQNO
		)
		as drugVolumeUOM
		outer apply (
			SELECT MED_ROUTE_ID, MED_NAME_ID
			FROM NDD_RMIRMID1_ROUTED_MED t1 WITH(NOLOCK) 
			WHERE form.ROUTED_MED_ID = t1.ROUTED_MED_ID
		) as routed
		outer apply (
			SELECT *
			FROM NDD_RMIRTD1_ROUTE t1
			WHERE t1.MED_ROUTE_ID = routed.MED_ROUTE_ID
		) as routeInfo
		outer apply (
			SELECT *
			FROM NDD_RMIDFD1_DOSE_FORM t1
			WHERE t1.MED_DOSAGE_FORM_ID = form.MED_DOSAGE_FORM_ID
		) as doseFormInfo
		outer apply (
			SELECT t1.MED_NAME, t1.MED_NAME_ID, t2.MED_NAME_TYPE_CD_DESC, t1.MED_NAME_TYPE_CD
			FROM NDD_RMINMID1_MED_NAME t1 WITH(NOLOCK)
				INNER JOIN NDD_RMINMD1_MED_NAME_TYPE_DESC t2 WITH(NOLOCK) on t1.MED_NAME_TYPE_CD = t2.MED_NAME_TYPE_CD
			WHERE t1.MED_NAME_ID = routed.MED_NAME_ID
		) as drugName
		outer apply (
				SELECT top 1 t2.ETC_ID, t2.ETC_NAME 
				FROM NDD_RETCMED0_ETC_MEDID t1
					inner join NDD_RETCTBL0_ETC_ID t2 on t1.ETC_ID = t2.ETC_ID
				WHERE t1.MEDID = dis.MEDID and t1.ETC_DEFAULT_USE_IND = '1'
				order by t2.ETC_SORT_NUMBER
		) as medClass
		outer apply (		
			SELECT top 1 
				t1.EVD_EXT_VOCAB_ID as [RxNorm], 
				case when t1.EVD_EXT_VOCAB_ID is null then null 
						else
							CASE WHEN t1.EVD_LINK_TYPE_ID = 5 THEN 'SBD' ELSE 'SCD' END
					end as [RxNormQualifier],
				case when t1.EVD_LINK_TYPE_ID = 5 then 1 else 0 end as [IsBrandName],
				case when drugName.MED_NAME_TYPE_CD = '1' then t1.EVD_LINK_TYPE_ID * -1 else t1.EVD_LINK_TYPE_ID end as [OrderBy]
			FROM NDD_REVDEL0_EXT_VOCAB_LINK t1 WITH(NOLOCK)
			WHERE t1.IsDelete = 0
				AND t1.EVD_LINK_TYPE_ID IN (1, 5)
				AND t1.EVD_FDB_VOCAB_TYPE_ID = 3 -- MEDID
				AND t1.EVD_FDB_VOCAB_ID = CONVERT(varchar(255), dis.MEDID)
			order by OrderBy
		) as medRxNorm
		outer apply (
			SELECT top 1 
				t1.EVD_EXT_VOCAB_ID as [RxNorm],
				case when t1.EVD_EXT_VOCAB_ID is null then null 
						else
							CASE WHEN t1.EVD_LINK_TYPE_ID = 5 THEN 'SBD' ELSE 'SCD' END
					end as [RxNormQualifier],
				case when t1.EVD_LINK_TYPE_ID = 5 then 1 else 0 end as [IsBrandName],
				case when drugName.MED_NAME_TYPE_CD = '1' then t1.EVD_LINK_TYPE_ID * -1 else t1.EVD_LINK_TYPE_ID end as [OrderBy]
			FROM NDD_REVDEL0_EXT_VOCAB_LINK t1 WITH(NOLOCK)
			WHERE t1.IsDelete = 0
				AND t1.EVD_FDB_VOCAB_TYPE_ID = 1 -- MED_NAME_ID
				AND t1.EVD_FDB_VOCAB_ID = CONVERT(varchar(255), drugName.MED_NAME_ID)
			order by OrderBy
		) as drugNameRxNorm
		outer apply (
			SELECT TOP 1 t1.NDC, t1.DEA
			FROM NDD_RNDC14_NDC_MSTR t1
				INNER JOIN NDD_RMINDC1_NDC_MEDID t2 on t1.NDC = t2.NDC
			WHERE t2.MEDID = dis.MEDID
			ORDER BY
				CASE WHEN dis.MED_REF_DEA_CD = '6' AND t1.OBSDTEC < DATEADD(yy, -3, GETUTCDATE()) THEN 99 ELSE 0 END,
				CASE WHEN dis.MED_REF_DEA_CD = '6' AND t1.DEA IN('1','2','3','4','5') THEN t1.DEA ELSE 99 END,
				ISNULL(t1.OBSDTEC, '99990101') desc,
				t1.UD,
				t1.REPACK,
				t1.PLBLR,
				t1.STPK DESC,
				t1.PS,
				t1.NDC
		) as medNDC
		outer apply (
			select case when (select count(*) from NDD_RMEDST0_MEDID_SEARCH_TERM WHERE MEDID = dis.MEDID) = 0 then 
			  (
					SELECT (case when count(*) > 0 then 1 else 0 end) as [IsMedicalDevice] 
					FROM NDD_RETCTBL0_ETC_ID s1 
					WHERE s1.ETC_ID = medClass.ETC_ID
					and (s1.ETC_ULTIMATE_PARENT_ETC_ID in ( 
						1131,	-- Medical Supplies and Durable Medical Equipment (DME)
						5904	-- Medical Supply, FDB Superset
						)
					or s1.ETC_ID in ( 
						1131,	-- Medical Supplies and Durable Medical Equipment (DME)
						5904	-- Medical Supply, FDB Superset
						)
					)
			  )
			  else 
			  (SELECT TOP 1 MEDICAL_SUPPLY_IND from NDD_RMEDST0_MEDID_SEARCH_TERM WHERE MEDID = dis.MEDID) 
			 end  as [IsMedicalDevice]
		) as dme
		outer apply (
			select case when (
				SELECT COUNT(*) FROM NDD_RGCNSEQ4_GCNSEQNO_MSTR t1
				INNER JOIN NDD_RHICL1_HIC_HICLSEQNO_LINK t2 ON t1.HICL_SEQNO = t2.HICL_SEQNO
				WHERE t1.GCN_SEQNO = dis.GCN_SEQNO 
					AND t2.HIC_SEQN <> 9870 -- preservative free
					-- AND t2.HIC_SEQN <> 739 -- water for injection,sterile
					-- AND t2.HIC_SEQN <> 963 -- dextrose 5 % in water
				) < 2 then 1 else 0 end as [IsSingleIngredient]
		) as sii
		outer apply (
			SELECT *
			FROM NDD_RMIID1_MED t1 WITH(NOLOCK)
			WHERE t1.MEDID = dis.GENERIC_MEDID
		) as genericDis
		outer apply (
			SELECT * 
			FROM NDD_RMIDFID1_ROUTED_DOSE_FORM_MED t1 WITH(NOLOCK) 
			WHERE t1.ROUTED_DOSAGE_FORM_MED_ID = genericDis.ROUTED_DOSAGE_FORM_MED_ID
		) as genericForm
		outer apply (
			SELECT MED_ROUTE_ID, MED_NAME_ID
			FROM NDD_RMIRMID1_ROUTED_MED t1 WITH(NOLOCK) 
			WHERE genericForm.ROUTED_MED_ID = t1.ROUTED_MED_ID
		) as genericRouted
		outer apply (
			SELECT t1.MED_NAME, t1.MED_NAME_ID, t2.MED_NAME_TYPE_CD_DESC, t1.MED_NAME_TYPE_CD
			FROM NDD_RMINMID1_MED_NAME t1 WITH(NOLOCK)
				INNER JOIN NDD_RMINMD1_MED_NAME_TYPE_DESC t2 WITH(NOLOCK) on t1.MED_NAME_TYPE_CD = t2.MED_NAME_TYPE_CD
			WHERE t1.MED_NAME_ID = genericRouted.MED_NAME_ID
		) as genericDrugName
		outer apply (		
			SELECT top 1 
				t1.EVD_EXT_VOCAB_ID as [RxNorm], 
				case when t1.EVD_EXT_VOCAB_ID is null then null 
						else
							CASE WHEN t1.EVD_LINK_TYPE_ID = 5 THEN 'SBD' ELSE 'SCD' END
					end as [RxNormQualifier],
				case when t1.EVD_LINK_TYPE_ID = 5 then 1 else 0 end as [IsBrandName],
				case when genericDrugName.MED_NAME_TYPE_CD = '1' then t1.EVD_LINK_TYPE_ID * -1 else t1.EVD_LINK_TYPE_ID end as [OrderBy]
			FROM NDD_REVDEL0_EXT_VOCAB_LINK t1 WITH(NOLOCK)
			WHERE t1.IsDelete = 0
				AND t1.EVD_LINK_TYPE_ID IN (1, 5)
				AND t1.EVD_FDB_VOCAB_TYPE_ID = 3 -- MEDID
				AND t1.EVD_FDB_VOCAB_ID = CONVERT(varchar(255), dis.GENERIC_MEDID)
			order by OrderBy
		) as genericRxNorm
		outer apply (
			SELECT TOP 1 t1.NDC, t1.DEA
			FROM NDD_RNDC14_NDC_MSTR t1
				INNER JOIN NDD_RMINDC1_NDC_MEDID t2 on t1.NDC = t2.NDC
			WHERE t2.MEDID = dis.GENERIC_MEDID
			ORDER BY
				CASE WHEN dis.MED_REF_DEA_CD = '6' AND t1.OBSDTEC < DATEADD(yy, -3, GETUTCDATE()) THEN 99 ELSE 0 END,
				CASE WHEN dis.MED_REF_DEA_CD = '6' AND t1.DEA IN('1','2','3','4','5') THEN t1.DEA ELSE 99 END,
				ISNULL(t1.OBSDTEC, '99990101') desc,
				t1.UD,
				t1.REPACK,
				t1.PLBLR,
				t1.STPK DESC,
				t1.PS,
				t1.NDC
		) as genericNDC

open out_cursor

fetch NEXT from out_cursor into @newMEDID, @newGCN_SEQNO, @newGENERIC_MEDID, @newMED_STRENGTH, @newMED_STRENGTH_UOM,
		@newSTRENGTH_UOM, @newVOLUME_UOM,
		@newMedDesc, @newSearchMedDesc, @newStatusCode, @newStatusCodeDescription, @newIsMedicalDevice, @newNameSourceCode, 
		@newRefFederalLegendCode, @newRefMultiSourceCode, @newRefGenericDrugNameCode, @newIsSingleIngredient, 
		@newrdfmid, @newrmid, @newrtid, @newRouteAbbr, @newRouteDesc, @newdfid, @newDosageFormAbbr, @newDosageFormDesc,
		@newhicl, @newRefFederalDEAClassCode, @newClassID, @newClassName, @newRxNormCode, @newRxNormQualifier,
		@newNDC, @newMNID, @newDrugName, @newDrugNameTypeCode, @newDrugNameType, @newDrugNameRxNormCode, @newDrugNameRxNormQualifier,
		@newGenericMedDesc, @newGenericRMID, @newGenericMNID ,@newGenericDrugName, @newGenericRxNormCode,
		@newGenericRxNormQualifier, @newGenericNDC,
		@newIsDelete

while (@@fetch_status <> -1)
begin
	if (@@fetch_status <> -2)
	begin
		set @existingMEDID = 0
		select @existingMEDID = medid, @existingIsDelete = IsDelete
		from NDD_SearchDispensable
		where medid = @newmedid

		if (ISNULL(@existingMEDID, 0) > 0)
		begin
			-- found row
			if (@newIsDelete = 1 and @existingIsDelete = 0)
			begin
				-- mark existing row IsDelete "true"
				update NDD_SearchDispensable set IsDelete = @newIsDelete where medid = @newmedid
				set @deletedCnt = @deletedCnt + 1
			end
			else begin
				select @existingHASH = HASHBYTES ('SHA1', 
					CONVERT(VARCHAR(100),ISNULL(GCNSEQNO, 0)) 
					+ CONVERT(VARCHAR(100),ISNULL(GENERIC_MEDID, 0)) 
					+ ISNULL(MED_STRENGTH, '')
					+ ISNULL(MED_STRENGTH_UOM, '')
					+ ISNULL(STRENGTH_UOM, '')
					+ ISNULL(VOLUME_UOM, '')
					+ ISNULL(StatusCode, '')
					+ ISNULL(StatusCodeDescription, '')
					+ ISNULL(MedDesc, '')
					+ ISNULL(SearchMedDesc, '')
					+ CONVERT(VARCHAR(100),ISNULL(IsMedicalDevice, 0)) 
					+ ISNULL(NameSourceCode, '')
					+ ISNULL(RefFederalLegendCode, '')
					+ ISNULL(RefMultiSourceCode, '')
					+ ISNULL(RefGenericDrugNameCode, '')
					+ CONVERT(VARCHAR(100),ISNULL(IsSingleIngredient, 0)) 
					+ CONVERT(VARCHAR(100),ISNULL(rdfmid, 0)) 
					+ CONVERT(VARCHAR(100),ISNULL(rmid, 0)) 
					+ CONVERT(VARCHAR(100),ISNULL(rtid, 0)) 
					+ ISNULL(RouteAbbr, '')
					+ ISNULL(RouteDesc, '')
					+ CONVERT(VARCHAR(100),ISNULL(dfid, 0)) 
					+ ISNULL(DosageFormAbbr, '')
					+ ISNULL(DosageFormDesc, '')
					+ CONVERT(VARCHAR(100),ISNULL(hicl, 0)) 
					+ ISNULL(RefFederalDEAClassCode, '')
					+ CONVERT(VARCHAR(100),ISNULL(classid, 0))
					+ ISNULL(className, '')
					+ ISNULL(RxNormCode, '')
					+ ISNULL(RxNormQualifier, '')
					+ ISNULL(NDC, '')
					+ CONVERT(VARCHAR(100),ISNULL(MNID, 0))
					+ ISNULL(DrugName, '')
					+ ISNULL(DrugNameTypeCode, '')
					+ ISNULL(DrugNameType, '')
					+ ISNULL(DrugNameRxNormCode, '')
					+ ISNULL(DrugNameRxNormQualifier, '')					
					+ ISNULL(GenericMedDesc, '')
					+ CONVERT(VARCHAR(100),ISNULL(GenericRMID, 0))
					+ CONVERT(VARCHAR(100),ISNULL(GenericMNID, 0))
					+ ISNULL(GenericDrugName, '')
					+ ISNULL(GenericRxNormCode, '')
					+ ISNULL(GenericRxNormQualifier, '')
					+ ISNULL(GenericNDC, '')
					)
				from NDD_SearchDispensable
				where medid = @existingMEDID
				set @newHASH = HASHBYTES ('SHA1', 
					CONVERT(VARCHAR(100),ISNULL(@newGCN_SEQNO, 0)) 
					+ CONVERT(VARCHAR(100),ISNULL(@newGENERIC_MEDID, 0)) 
					+ ISNULL(@newMED_STRENGTH, '')
					+ ISNULL(@newMED_STRENGTH_UOM, '')
					+ ISNULL(@newSTRENGTH_UOM, '')
					+ ISNULL(@newVOLUME_UOM, '')
					+ ISNULL(@newStatusCode, '')
					+ ISNULL(@newStatusCodeDescription, '')
					+ ISNULL(@newMedDesc, '')
					+ ISNULL(@newSearchMedDesc, '')
					+ CONVERT(VARCHAR(100),ISNULL(@newIsMedicalDevice, 0)) 
					+ ISNULL(@newNameSourceCode, '')
					+ ISNULL(@newRefFederalLegendCode, '')
					+ ISNULL(@newRefMultiSourceCode, '')
					+ ISNULL(@newRefGenericDrugNameCode, '')
					+ CONVERT(VARCHAR(100),ISNULL(@newIsSingleIngredient, 0)) 
					+ CONVERT(VARCHAR(100),ISNULL(@newrdfmid, 0)) 
					+ CONVERT(VARCHAR(100),ISNULL(@newrmid, 0)) 
					+ CONVERT(VARCHAR(100),ISNULL(@newrtid, 0)) 
					+ ISNULL(@newRouteAbbr, '')
					+ ISNULL(@newRouteDesc, '')
					+ CONVERT(VARCHAR(100),ISNULL(@newdfid, 0)) 
					+ ISNULL(@newDosageFormAbbr, '')
					+ ISNULL(@newDosageFormDesc, '')
					+ CONVERT(VARCHAR(100),ISNULL(@newhicl, 0)) 
					+ ISNULL(@newRefFederalDEAClassCode, '')
					+ CONVERT(VARCHAR(100),ISNULL(@newclassid, 0))
					+ ISNULL(@newclassName, '')
					+ ISNULL(@newRxNormCode, '')
					+ ISNULL(@newRxNormQualifier, '')
					+ ISNULL(@newNDC, '')
					+ CONVERT(VARCHAR(100),ISNULL(@newMNID, 0))
					+ ISNULL(@newDrugName, '')
					+ ISNULL(@newDrugNameTypeCode, '')
					+ ISNULL(@newDrugNameType, '')
					+ ISNULL(@newDrugNameRxNormCode, '')
					+ ISNULL(@newDrugNameRxNormQualifier, '')					
					+ ISNULL(@newGenericMedDesc, '')
					+ CONVERT(VARCHAR(100),ISNULL(@newGenericRMID, 0))
					+ CONVERT(VARCHAR(100),ISNULL(@newGenericMNID, 0))
					+ ISNULL(@newGenericDrugName, '')
					+ ISNULL(@newGenericRxNormCode, '')
					+ ISNULL(@newGenericRxNormQualifier, '')
					+ ISNULL(@newGenericNDC, '')
					)
				if (@newHASH <> @existingHASH)
				begin
					-- update row
					update NDD_SearchDispensable set
							GCNSEQNO = @newGCN_SEQNO, GENERIC_MEDID = @newGENERIC_MEDID, 
							MED_STRENGTH = @newMED_STRENGTH, MED_STRENGTH_UOM = @newMED_STRENGTH_UOM,
							STRENGTH_UOM = @newSTRENGTH_UOM, VOLUME_UOM = @newVOLUME_UOM,
							MedDesc = @newMedDesc, SearchMedDesc = @newSearchMedDesc, StatusCode = @newStatusCode, 
							StatusCodeDescription = @newStatusCodeDescription, IsMedicalDevice = @newIsMedicalDevice, 
							NameSourceCode = @newNameSourceCode, RefFederalLegendCode = @newRefFederalLegendCode, 
							RefMultiSourceCode = @newRefMultiSourceCode, RefGenericDrugNameCode = @newRefGenericDrugNameCode,
							IsSingleIngredient = @newIsSingleIngredient, rdfmid = @newrdfmid, rmid = @newrmid, 
							rtid = @newrtid, RouteAbbr = @newRouteAbbr, RouteDesc = @newRouteDesc, 
							dfid = @newdfid, DosageFormAbbr = @newDosageFormAbbr, DosageFormDesc = @newDosageFormDesc,
							hicl = @newhicl, RefFederalDEAClassCode = @newRefFederalDEAClassCode, 
							ClassID = @newClassID, ClassName = @newClassName, RxNormCode = @newRxNormCode, RxNormQualifier = @newRxNormQualifier,
							NDC = @newNDC, MNID = @newMNID, DrugName = @newDrugName, DrugNameTypeCode = @newDrugNameTypeCode, 
							DrugNameType = @newDrugNameType, DrugNameRxNormCode = @newDrugNameRxNormCode, DrugNameRxNormQualifier = @newDrugNameRxNormQualifier,
							GenericMedDesc = @newGenericMedDesc, GenericRMID = @newGenericRMID, GenericMNID = @newGenericMNID, 
							GenericDrugName = @newGenericDrugName, GenericRxNormCode = @newGenericRxNormCode,
							GenericRxNormQualifier = @newGenericRxNormQualifier, GenericNDC = @newGenericNDC, LastModifiedDate = @newLastModifiedDate
					where medid = @existingMedid

					set @updateCnt = @updateCnt + 1
				end
			end
		end
		else if (@newIsDelete = 0) begin
			-- insert missing row
			insert into NDD_SearchDispensable (
				MEDID, GCNSEQNO, GENERIC_MEDID, MED_STRENGTH, MED_STRENGTH_UOM,
				STRENGTH_UOM, VOLUME_UOM,
				MedDesc, SearchMedDesc, StatusCode, StatusCodeDescription, IsMedicalDevice, NameSourceCode, 
				RefFederalLegendCode, RefMultiSourceCode, RefGenericDrugNameCode, IsSingleIngredient, 
				rdfmid, rmid, rtid, RouteAbbr, RouteDesc, dfid, DosageFormAbbr, DosageFormDesc,
				hicl, RefFederalDEAClassCode, ClassID, ClassName, RxNormCode, RxNormQualifier,
				NDC, MNID, DrugName, DrugNameTypeCode, DrugNameType, DrugNameRxNormCode, DrugNameRxNormQualifier,
				GenericMedDesc, GenericRMID, GenericMNID, GenericDrugName, GenericRxNormCode,
				GenericRxNormQualifier, GenericNDC, IsDelete, LastModifiedDate
			)
			values
			(
				@newMEDID, @newGCN_SEQNO, @newGENERIC_MEDID, @newMED_STRENGTH, @newMED_STRENGTH_UOM,
				@newSTRENGTH_UOM, @newVOLUME_UOM,
				@newMedDesc, @newSearchMedDesc, @newStatusCode, @newStatusCodeDescription, @newIsMedicalDevice, @newNameSourceCode, 
				@newRefFederalLegendCode, @newRefMultiSourceCode, @newRefGenericDrugNameCode, @newIsSingleIngredient, 
				@newrdfmid, @newrmid, @newrtid, @newRouteAbbr, @newRouteDesc, @newdfid, @newDosageFormAbbr, @newDosageFormDesc,
				@newhicl, @newRefFederalDEAClassCode, @newClassID, @newClassName, @newRxNormCode, @newRxNormQualifier,
				@newNDC, @newMNID, @newDrugName, @newDrugNameTypeCode, @newDrugNameType, @newDrugNameRxNormCode, @newDrugNameRxNormQualifier,
				@newGenericMedDesc, @newGenericRMID, @newGenericMNID ,@newGenericDrugName, @newGenericRxNormCode,
				@newGenericRxNormQualifier, @newGenericNDC, @newIsDelete, @newLastModifiedDate
			)

			set @insertedCnt = @insertedCnt + 1
		end
	end
		
	fetch NEXT from out_cursor into @newMEDID, @newGCN_SEQNO, @newGENERIC_MEDID, @newMED_STRENGTH, @newMED_STRENGTH_UOM,
			@newSTRENGTH_UOM, @newVOLUME_UOM,
			@newMedDesc, @newSearchMedDesc, @newStatusCode, @newStatusCodeDescription, @newIsMedicalDevice, @newNameSourceCode, 
			@newRefFederalLegendCode, @newRefMultiSourceCode, @newRefGenericDrugNameCode, @newIsSingleIngredient, 
			@newrdfmid, @newrmid, @newrtid, @newRouteAbbr, @newRouteDesc, @newdfid, @newDosageFormAbbr, @newDosageFormDesc,
			@newhicl, @newRefFederalDEAClassCode, @newClassID, @newClassName, @newRxNormCode, @newRxNormQualifier,
			@newNDC, @newMNID, @newDrugName, @newDrugNameTypeCode, @newDrugNameType, @newDrugNameRxNormCode, @newDrugNameRxNormQualifier,
			@newGenericMedDesc, @newGenericRMID, @newGenericMNID ,@newGenericDrugName, @newGenericRxNormCode,
			@newGenericRxNormQualifier, @newGenericNDC,
			@newIsDelete
end	-- of while outside

close out_cursor
deallocate out_cursor

select @insertedCnt as [rows inserted], @updateCnt as [rows updated], @deletedCnt as [rows marked deleted]


END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_UpdateSearchDrugName]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[NDD_UpdateSearchDrugName] AS' 
END
GO

-- =================================================================
-- Author:		CHM
-- Create date: 08/22/2018
-- Description:	This store procedure will update table 
--				NDD_SearchDrugName.
-- =================================================================
ALTER PROC [dbo].[NDD_UpdateSearchDrugName]
AS
BEGIN

	declare @existingmnid int
	declare @existingIsDelete bit
	declare @existingHASH varbinary(128)

	declare @newmnid int
	declare @newhicl int
	declare @newDrugName varchar(30)
	declare @newSearchDrugName varchar(33)
	declare @newDrugNameTypeCode varchar(1)
	declare @newDrugNameType varchar(30)
	declare @newStatusCode varchar(1)
	declare @newStatusCodeDescription varchar(30)
	declare @newclassid int
	declare @newClassName varchar(70)
	declare @newDrugNameRxNormCode varchar(50)
	declare @newDrugNameRxNormQualifier varchar(10)
	declare @newIsMedicalDevice bit
	declare @newGenericMNID int
	declare @newGenericDrugName varchar(30)
	declare @newGenericNameRxNormCode varchar(50)
	declare @newGenericNameRxNormQualifier varchar(10)
	declare @newIsDelete bit
	declare @newHASH varbinary(128)

	declare @newLastModifiedDate DateTime = getutcdate()

	declare @updateCnt int = 0
	declare @insertedCnt int = 0
	declare @deletedCnt int = 0

	declare out_cursor cursor for 
		select
			drugName.MED_NAME_ID  as [mnid],
			dis.hicl as [hicl],
			drugName.MED_NAME as [DrugName],
			dbo.NDD_CreateSearchDescription(drugName.MED_NAME) as [SearchDrugName],
			drugName.MED_NAME_TYPE_CD as [DrugNameTypeCode],
			nameDesc.MED_NAME_TYPE_CD_DESC as [DrugNameType],
			drugName.MED_STATUS_CD as [StatusCode],
			statusDesc.MED_STATUS_CD_DESC as [StatusCodeDescription],
			drugNameRxNorm.RxNorm as [DrugNameRxNormCode],
			drugNameRxNorm.RxNormQualifier as [DrugNameRxNormQualifier],
			dis.IsMedicalDevice as [IsMedicalDevice],

			-- class columns
			nameClass.ETC_ID as [classid],
			nameClass.ETC_NAME as [className],
	
			-- generic columns
			dis.GenericMNID as [GenericMNID],
			dis.GenericDrugName as [GenericDrugName],
			genericNameRxNorm.RxNorm as [GenericNameRxNormCode],
			genericNameRxNorm.RxNormQualifier as [GenericNameRxNormQualifier],
			drugName.IsDelete
		FROM NDD_RMINMID1_MED_NAME drugName WITH(NOLOCK)
			INNER JOIN NDD_RMINMD1_MED_NAME_TYPE_DESC nameDesc WITH(NOLOCK) on nameDesc.MED_NAME_TYPE_CD = drugName.MED_NAME_TYPE_CD
			INNER JOIN NDD_RMISCD1_STATUS_DESC statusDesc WITH(NOLOCK) on statusDesc.IsDelete = 0 and statusDesc.MED_STATUS_CD = drugName.MED_STATUS_CD
			outer apply (
					SELECT top 1 t2.ETC_ID, t2.ETC_NAME 
					FROM NDD_RETCMNM0_ETC_MED_NAME_ID t1
						inner join NDD_RETCTBL0_ETC_ID t2 on t1.ETC_ID = t2.ETC_ID
					WHERE t1.MED_NAME_ID = drugName.MED_NAME_ID
					order by t2.ETC_SORT_NUMBER
			) as nameClass
			outer apply (
					SELECT top 1 
					t1.EVD_EXT_VOCAB_ID as [RxNorm], 
					case when t1.EVD_EXT_VOCAB_ID is null then null 
						else
							CASE WHEN t1.EVD_LINK_TYPE_ID = 5 THEN 'SBD' ELSE 'SCD' END
						end as [RxNormQualifier],
					case when drugName.MED_NAME_TYPE_CD = '1' then t1.EVD_LINK_TYPE_ID * -1 else t1.EVD_LINK_TYPE_ID end as [OrderBy]
				FROM NDD_REVDEL0_EXT_VOCAB_LINK t1 WITH(NOLOCK)
				WHERE t1.IsDelete = 0
					AND t1.EVD_FDB_VOCAB_TYPE_ID = 1 -- MED_NAME_ID
					AND t1.EVD_FDB_VOCAB_ID = CONVERT(varchar(255), drugName.MED_NAME_ID)
				order by OrderBy
			) as drugNameRxNorm
			outer apply (
				SELECT top 1 t1.GenericMNID, t1.GenericDrugName, t1.hicl, t1.IsMedicalDevice
				FROM NDD_SearchDispensable t1 
				WHERE t1.mnid = drugName.MED_NAME_ID
			) as dis
			outer apply (
				 SELECT top 1
							 t1.EVD_EXT_VOCAB_ID as [RxNorm],
							 case when t1.EVD_EXT_VOCAB_ID is null then null
								   else
										  CASE WHEN t1.EVD_LINK_TYPE_ID = 5 THEN 'SBD' ELSE 'SCD' END
							 end as [RxNormQualifier],
							 -- note: this is a generic, so can assume the order by (generic MED_NAME_TYPE_CD = '2')
							 t1.EVD_LINK_TYPE_ID as [OrderBy]
				 FROM NDD_REVDEL0_EXT_VOCAB_LINK t1 WITH(NOLOCK)
				 WHERE t1.IsDelete = 0
					AND t1.EVD_FDB_VOCAB_TYPE_ID = 1 -- MED_NAME_ID
					AND t1.EVD_FDB_VOCAB_ID = CONVERT(varchar(255), dis.GenericMNID)
				 order by OrderBy
			   ) as genericNameRxNorm

			order by mnid

	open out_cursor
	fetch NEXT from out_cursor into @newMNID, @newhicl, @newDrugName, @newSearchDrugName, @newDrugNameTypeCode, @newDrugNameType,
						@newStatusCode, @newStatusCodeDescription, @newDrugNameRxNormCode, @newDrugNameRxNormQualifier,
						@newIsMedicalDevice, @newclassid, @newclassName, @newGenericMNID, @newGenericDrugName,
						@newGenericNameRxNormCode, @newGenericNameRxNormQualifier, @newIsDelete

	while (@@fetch_status <> -1)
	begin
		if (@@fetch_status <> -2)
		begin
			set @existingmnid = 0
			select @existingmnid = mnid, @existingIsDelete = IsDelete
			from NDD_SearchDrugName
			where mnid = @newmnid

			if (ISNULL(@existingmnid, 0) > 0)
			begin
				-- found row
				if (@newIsDelete = 1 and @existingIsDelete = 0)
				begin
					-- mark existing row IsDelete "true"
					update NDD_SearchDrugName set IsDelete = @newIsDelete where mnid = @newmnid
					set @deletedCnt = @deletedCnt + 1
				end
				else begin
					select @existingHASH = HASHBYTES ('SHA1', 
						CONVERT(VARCHAR(100),ISNULL(hicl, 0)) 
						+ ISNULL(DrugName, '')
						+ ISNULL(SearchDrugName, '')
						+ ISNULL(DrugNameTypeCode, '')
						+ ISNULL(DrugNameType, '')
						+ ISNULL(StatusCode, '')
						+ ISNULL(StatusCodeDescription, '')
						+ ISNULL(DrugNameRxNormCode, '')
						+ ISNULL(DrugNameRxNormQualifier, '')
						+ CONVERT(VARCHAR(100),ISNULL(IsMedicalDevice, 0))
						+ CONVERT(VARCHAR(100),ISNULL(classid, 0))
						+ ISNULL(className, '')
						+ CONVERT(VARCHAR(100),ISNULL(GenericMNID, 0))
						+ ISNULL(GenericDrugName, '')
						+ ISNULL(GenericNameRxNormCode, '')
						+ ISNULL(GenericNameRxNormQualifier, '')
						)
					from NDD_SearchDrugName
					where mnid = @newmnid

					set @newHASH = HASHBYTES ('SHA1', 
						CONVERT(VARCHAR(100),ISNULL(@newhicl, 0)) 
						+ ISNULL(@newDrugName, '')
						+ ISNULL(@newSearchDrugName, '')
						+ ISNULL(@newDrugNameTypeCode, '')
						+ ISNULL(@newDrugNameType, '')
						+ ISNULL(@newStatusCode, '')
						+ ISNULL(@newStatusCodeDescription, '')
						+ ISNULL(@newDrugNameRxNormCode, '')
						+ ISNULL(@newDrugNameRxNormQualifier, '')
						+ CONVERT(VARCHAR(100),ISNULL(@newIsMedicalDevice, 0))
						+ CONVERT(VARCHAR(100),ISNULL(@newclassid, 0))
						+ ISNULL(@newclassName, '')
						+ CONVERT(VARCHAR(100),ISNULL(@newGenericMNID, 0))
						+ ISNULL(@newGenericDrugName, '')
						+ ISNULL(@newGenericNameRxNormCode, '')
						+ ISNULL(@newGenericNameRxNormQualifier, '')
						)
					if (@newHASH <> @existingHASH)
					begin
						-- update row
						update NDD_SearchDrugName set hicl = @newhicl, 
							DrugName = @newDrugName,
							SearchDrugName = @newSearchDrugName,
							DrugNameTypeCode = @newDrugNameTypeCode,
							DrugNameType = @newDrugNameType,
							StatusCode = @newStatusCode,
							StatusCodeDescription = @newStatusCodeDescription,
							DrugNameRxNormCode = @newDrugNameRxNormCode,
							DrugNameRxNormQualifier = @newDrugNameRxNormQualifier,
							IsMedicalDevice = @newIsMedicalDevice,
							classid = @newclassid,
							className = @newclassName,
							GenericMNID = @newGenericMNID,
							GenericDrugName = @newGenericDrugName,
							GenericNameRxNormCode = @newGenericNameRxNormCode,
							GenericNameRxNormQualifier = @newGenericNameRxNormQualifier
						where mnid = @newmnid
						print convert(varchar(100), @newmnid)
						set @updateCnt = @updateCnt + 1
					end
				end
			end
			else if (@newIsDelete = 0) begin
				-- insert missing row
				insert into NDD_SearchDrugName (mnid, hicl, DrugName, SearchDrugName, DrugNameTypeCode, DrugNameType, 
					StatusCode, StatusCodeDescription, DrugNameRxNormCode, DrugNameRxNormQualifier, 
					IsMedicalDevice, classid, className, GenericMNID, GenericDrugName, 
					GenericNameRxNormCode, GenericNameRxNormQualifier, IsDelete, LastModifiedDate)
				values (@newmnid, @newhicl, @newDrugName, @newSearchDrugName, @newDrugNameTypeCode, @newDrugNameType, 
					@newStatusCode, @newStatusCodeDescription, @newDrugNameRxNormCode, @newDrugNameRxNormQualifier, 
					@newIsMedicalDevice, @newclassid, @newclassName, @newGenericMNID, @newGenericDrugName, 
					@newGenericNameRxNormCode, @newGenericNameRxNormQualifier, @newIsDelete, @newLastModifiedDate)

				set @insertedCnt = @insertedCnt + 1
			end
		end
	
		fetch NEXT from out_cursor into @newMNID, @newhicl, @newDrugName, @newSearchDrugName, @newDrugNameTypeCode, @newDrugNameType,
							@newStatusCode, @newStatusCodeDescription, @newDrugNameRxNormCode, @newDrugNameRxNormQualifier,
							@newIsMedicalDevice, @newclassid, @newclassName, @newGenericMNID, @newGenericDrugName,
							@newGenericNameRxNormCode, @newGenericNameRxNormQualifier, @newIsDelete
	end	-- of while outside

	close out_cursor
	deallocate out_cursor

	select @insertedCnt as [rows inserted], @updateCnt as [rows updated], @deletedCnt as [rows marked deleted]

END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_UpdateSearchRouted]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[NDD_UpdateSearchRouted] AS' 
END
GO

-- =================================================================
-- Author:		CHM
-- Create date: 08/22/2018
-- Description:	This store procedure will update table 
--				NDD_SearchRouted.
-- =================================================================
ALTER PROC [dbo].[NDD_UpdateSearchRouted]
AS
BEGIN

	declare @existingrmid int
	declare @existingIsDelete bit
	declare @existingHASH varbinary(128)

	declare @newrmid int
	declare @newhicl int
	declare @newRoutedMedDesc varchar(60)
	declare @newSearchRoutedMedDesc varchar(63)
	declare @newStatusCode varchar(1)
	declare @newStatusCodeDescription varchar(30)
	declare @newclassid int
	declare @newClassName varchar(70)

	declare @newMNID int
	declare @newDrugName varchar(30)
	declare @newDrugNameTypeCode varchar(1)
	declare @newDrugNameType varchar(30)
	declare @newDrugNameRxNormCode varchar(50)
	declare @newDrugNameRxNormQualifier varchar(10)

	declare @newGenericMNID int
	declare @newGenericDrugName varchar(30)
	declare @newGenericNameRxNormCode varchar(50)
	declare @newGenericNameRxNormQualifier varchar(10)

	declare @newrtid int
	declare @newRouteAbbr varchar(4)
	declare @newRouteDesc varchar(30)

	declare @newIsDelete bit
	declare @newHASH varbinary(128)

	declare @newLastModifiedDate DateTime = getutcdate()

	declare @updateCnt int = 0
	declare @insertedCnt int = 0
	declare @deletedCnt int = 0

	declare out_cursor cursor for 
		select
			routed.ROUTED_MED_ID as [rmid],
			dis.hicl as [hicl],
			routed.MED_ROUTED_MED_ID_DESC as [RoutedMedDesc],
			dbo.NDD_CreateSearchDescription(routed.MED_ROUTED_MED_ID_DESC) as [SearchRoutedMedDesc],
			routed.MED_STATUS_CD as [StatusCode],
			statusDesc.MED_STATUS_CD_DESC as [StatusCodeDescription],
			nameClass.ETC_ID as [classid],
			nameClass.ETC_NAME as [className],
	
			-- values drug name columns
			drugName.MED_NAME_ID as [MNID],
			drugName.MED_NAME as [DrugName],
			drugName.MED_NAME_TYPE_CD as [DrugNameTypeCode],
			drugName.MED_NAME_TYPE_CD_DESC as [DrugNameType],
			drugNameRxNorm.RxNorm as [DrugNameRxNormCode],
			drugNameRxNorm.RxNormQualifier as [DrugNameRxNormQualifier],
	
			-- generic columns
			dis.GenericMNID as [GenericMNID],
			dis.GenericDrugName as [GenericDrugName],
			genericNameRxNorm.RxNorm as [GenericNameRxNormCode],
			genericNameRxNorm.RxNormQualifier as [GenericNameRxNormQualifier],

			-- route columns
			routed.MED_ROUTE_ID as [rtid],
			routeInfo.MED_ROUTE_ABBR as [RouteAbbr],
			routeInfo.MED_ROUTE_DESC as  [RouteDesc],
			routed.IsDelete
		from NDD_RMIRMID1_ROUTED_MED routed
			inner join NDD_RMISCD1_STATUS_DESC statusDesc WITH(NOLOCK) on statusDesc.MED_STATUS_CD = routed.MED_STATUS_CD
			outer apply (
				SELECT t1.MED_NAME, t1.MED_NAME_ID, t2.MED_NAME_TYPE_CD_DESC, t1.MED_NAME_TYPE_CD
				FROM NDD_RMINMID1_MED_NAME t1 WITH(NOLOCK)
					INNER JOIN NDD_RMINMD1_MED_NAME_TYPE_DESC t2 WITH(NOLOCK) on t1.MED_NAME_TYPE_CD = t2.MED_NAME_TYPE_CD
				WHERE t1.MED_NAME_ID = routed.MED_NAME_ID
			) as drugName
			outer apply (
					SELECT top 1 t2.ETC_ID, t2.ETC_NAME 
					FROM NDD_RETCMNM0_ETC_MED_NAME_ID t1
						inner join NDD_RETCTBL0_ETC_ID t2 on t1.ETC_ID = t2.ETC_ID
					WHERE t1.MED_NAME_ID = routed.MED_NAME_ID
					order by t2.ETC_SORT_NUMBER
			) as nameClass
			outer apply (
				SELECT *
				FROM NDD_RMIRTD1_ROUTE t1
				WHERE t1.MED_ROUTE_ID = routed.MED_ROUTE_ID
			) as routeInfo
			outer apply (
					SELECT top 1 
					t1.EVD_EXT_VOCAB_ID as [RxNorm], 
					case when t1.EVD_EXT_VOCAB_ID is null then null 
						else
							CASE WHEN t1.EVD_LINK_TYPE_ID = 5 THEN 'SBD' ELSE 'SCD' END
					end as [RxNormQualifier],
					case when drugName.MED_NAME_TYPE_CD = '1' then t1.EVD_LINK_TYPE_ID * -1 else t1.EVD_LINK_TYPE_ID end as [OrderBy]
				FROM NDD_REVDEL0_EXT_VOCAB_LINK t1 WITH(NOLOCK)
				WHERE t1.IsDelete = 0
					AND t1.EVD_FDB_VOCAB_TYPE_ID = 1 -- MED_NAME_ID
					AND t1.EVD_FDB_VOCAB_ID = CONVERT(varchar(255), drugName.MED_NAME_ID)
				order by OrderBy
			) as drugNameRxNorm
			outer apply (
				SELECT top 1 t1.GenericMNID, t1.GenericDrugName, t1.hicl
				FROM NDD_SearchDispensable t1 
				WHERE t1.mnid = routed.MED_NAME_ID
			) as dis
		
			outer apply (
				SELECT top 1
					t1.EVD_EXT_VOCAB_ID as [RxNorm],
					case when t1.EVD_EXT_VOCAB_ID is null then null
							else
								CASE WHEN t1.EVD_LINK_TYPE_ID = 5 THEN 'SBD' ELSE 'SCD' END
					end as [RxNormQualifier],
					case when t1.EVD_LINK_TYPE_ID = 5 then 1 else 0 end as [IsBrandName],
						 -- note: this is a generic, so can assume the order by (generic MED_NAME_TYPE_CD = '2')
					t1.EVD_LINK_TYPE_ID as [OrderBy]
				FROM NDD_REVDEL0_EXT_VOCAB_LINK t1 WITH(NOLOCK)
				WHERE t1.IsDelete = 0
					AND t1.EVD_FDB_VOCAB_TYPE_ID = 1 -- MED_NAME_ID
					AND t1.EVD_FDB_VOCAB_ID = CONVERT(varchar(255), dis.GenericMNID)
				order by OrderBy
			) as genericNameRxNorm
		
	open out_cursor

	fetch NEXT from out_cursor into @newrmid, @newhicl, @newRoutedMedDesc, @newSearchRoutedMedDesc, @newStatusCode, @newStatusCodeDescription, @newclassid, @newClassName, 
				@newMNID, @newDrugName, @newDrugNameTypeCode, @newDrugNameType, @newDrugNameRxNormCode, @newDrugNameRxNormQualifier,
				@newGenericMNID, @newGenericDrugName, @newGenericNameRxNormCode, @newGenericNameRxNormQualifier,
				@newrtid, @newRouteAbbr, @newRouteDesc, @newIsDelete

	while (@@fetch_status <> -1)
	begin
		if (@@fetch_status <> -2)
		begin
			set @existingrmid = 0
			select @existingrmid = rmid, @existingIsDelete = IsDelete
			from NDD_SearchRouted
			where rmid = @newrmid

			if (ISNULL(@existingrmid, 0) > 0)
			begin
				-- found row
				if (@newIsDelete = 1 and @existingIsDelete = 0)
				begin
					-- mark existing row IsDelete "true"
					update NDD_SearchRouted set IsDelete = @newIsDelete where rmid = @newrmid
					set @deletedCnt = @deletedCnt + 1
				end
				else begin
					select @existingHASH = HASHBYTES ('SHA1', 
						CONVERT(VARCHAR(100),ISNULL(hicl, 0)) 
						+ ISNULL(RoutedMedDesc, '')
						+ ISNULL(SearchRoutedMedDesc, '')
						+ ISNULL(StatusCode, '')
						+ ISNULL(StatusCodeDescription, '')
						+ CONVERT(VARCHAR(100),ISNULL(classid, 0))
						+ ISNULL(className, '')
					
						+ CONVERT(VARCHAR(100),ISNULL(MNID, 0))
						+ ISNULL(DrugName, '')
						+ ISNULL(DrugNameTypeCode, '')
						+ ISNULL(DrugNameType, '')
						+ ISNULL(DrugNameRxNormCode, '')
						+ ISNULL(DrugNameRxNormQualifier, '')
					
						+ CONVERT(VARCHAR(100),ISNULL(GenericMNID, 0))
						+ ISNULL(GenericDrugName, '')
						+ ISNULL(GenericNameRxNormCode, '')
						+ ISNULL(GenericNameRxNormQualifier, '')
					
						+ CONVERT(VARCHAR(100),ISNULL(rtid, 0))
						+ ISNULL(RouteAbbr, '')
						+ ISNULL(RouteDesc, '')
						)
					from NDD_SearchRouted
					where rmid = @newrmid

					set @newHASH = HASHBYTES ('SHA1', 
						CONVERT(VARCHAR(100),ISNULL(@newhicl, 0)) 
						+ ISNULL(@newRoutedMedDesc, '')
						+ ISNULL(@newSearchRoutedMedDesc, '') 
						+ ISNULL(@newStatusCode, '')
						+ ISNULL(@newStatusCodeDescription, '')
						+ CONVERT(VARCHAR(100),ISNULL(@newclassid, 0))
						+ ISNULL(@newclassName, '')
					
						+ CONVERT(VARCHAR(100),ISNULL(@newMNID, 0))
						+ ISNULL(@newDrugName, '')
						+ ISNULL(@newDrugNameTypeCode, '')
						+ ISNULL(@newDrugNameType, '')
						+ ISNULL(@newDrugNameRxNormCode, '')
						+ ISNULL(@newDrugNameRxNormQualifier, '')
					
						+ CONVERT(VARCHAR(100),ISNULL(@newGenericMNID, 0))
						+ ISNULL(@newGenericDrugName, '')
						+ ISNULL(@newGenericNameRxNormCode, '')
						+ ISNULL(@newGenericNameRxNormQualifier, '')
					
						+ CONVERT(VARCHAR(100),ISNULL(@newrtid, 0))
						+ ISNULL(@newRouteAbbr, '')
						+ ISNULL(@newRouteDesc, '')
						)
					if (@newHASH <> @existingHASH)
					begin
						-- update row
						update  NDD_SearchRouted set hicl = @newhicl, 
							RoutedMedDesc = @newRoutedMedDesc,
							SearchRoutedMedDesc = @newSearchRoutedMedDesc,
							StatusCode = @newStatusCode,
							StatusCodeDescription = @newStatusCodeDescription,
							classid = @newclassid,
							className = @newclassName,

							mnid = @newMNID,
							DrugName = @newDrugName,
							DrugNameTypeCode = @newDrugNameTypeCode,
							DrugNameType = @newDrugNameType,
							DrugNameRxNormCode = @newDrugNameRxNormCode,
							DrugNameRxNormQualifier = @newDrugNameRxNormQualifier,

							GenericMNID = @newGenericMNID,
							GenericDrugName = @newGenericDrugName,
							GenericNameRxNormCode = @newGenericNameRxNormCode,
							GenericNameRxNormQualifier = @newGenericNameRxNormQualifier,

							rtid = @newrtid,
							RouteAbbr = @newRouteAbbr,
							RouteDesc = @newRouteDesc,
							LastModifiedDate = @newLastModifiedDate
						where rmid = @newrmid

						set @updateCnt = @updateCnt + 1
					end
				end
			end
			else if (@newIsDelete = 0) begin
				-- insert missing row
				insert into NDD_SearchRouted(rmid, hicl, RoutedMedDesc, SearchRoutedMedDesc, StatusCode, StatusCodeDescription, classid, className, 
					mnid, DrugName, DrugNameTypeCode, DrugNameType, DrugNameRxNormCode, DrugNameRxNormQualifier, 
					GenericMNID, GenericDrugName, GenericNameRxNormCode, GenericNameRxNormQualifier, 
					rtid, RouteAbbr, RouteDesc,
					IsDelete, LastModifiedDate)
				values (@newrmid, @newhicl, @newRoutedMedDesc, @newSearchRoutedMedDesc, @newStatusCode, @newStatusCodeDescription, @newclassid, @newclassName, 
					@newmnid, @newDrugName, @newDrugNameTypeCode, @newDrugNameType, @newDrugNameRxNormCode, @newDrugNameRxNormQualifier, 
					@newGenericMNID, @newGenericDrugName, @newGenericNameRxNormCode, @newGenericNameRxNormQualifier, 
					@newrtid, @newRouteAbbr, @newRouteDesc,
					@newIsDelete, @newLastModifiedDate)

				set @insertedCnt = @insertedCnt + 1
			end
		end
	
		fetch NEXT from out_cursor into @newrmid, @newhicl, @newRoutedMedDesc, @newSearchRoutedMedDesc, @newStatusCode, @newStatusCodeDescription, @newclassid, @newClassName, 
				@newMNID, @newDrugName, @newDrugNameTypeCode, @newDrugNameType, @newDrugNameRxNormCode, @newDrugNameRxNormQualifier,
				@newGenericMNID, @newGenericDrugName, @newGenericNameRxNormCode, @newGenericNameRxNormQualifier,
				@newrtid, @newRouteAbbr, @newRouteDesc, @newIsDelete
	end	-- of while outside

	close out_cursor
	deallocate out_cursor

	select @insertedCnt as [rows inserted], @updateCnt as [rows updated], @deletedCnt as [rows marked deleted]

END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_UpdateSearchRxNorm]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[NDD_UpdateSearchRxNorm] AS' 
END
GO

-- =================================================================
-- Author:		CHM
-- Create date: 08/22/2018
-- Description:	This store procedure will update table 
--				NDD_SearchRxNorm.
-- =================================================================
ALTER PROC [dbo].[NDD_UpdateSearchRxNorm]
AS
BEGIN

	declare @existingIsDelete bit

	declare @newPK_HASH varbinary(64)
	declare @newRxNormCode varchar(50)
	declare @newRxNormQualifier varchar(20)
	declare @newRxNormTermType varchar(20)
	declare @newIsBrandName bit
	declare @newMEDID int
	declare @newMNID int
	declare @newNDC varchar(11)
	declare @newIsDelete bit

	declare @newLastModifiedDate DateTime = getutcdate()

	declare @foundCnt int = 0
	declare @insertedCnt int = 0
	declare @deletedCnt int = 0

	declare out_cursor cursor for 
		select
		HASHBYTES ('SHA1', 
			ISNULL(t1.EVD_EXT_VOCAB_ID, '') 
			+ CASE WHEN t1.EVD_LINK_TYPE_ID = 5 THEN 'SBD' ELSE 'SCD' END 
			+ ISNULL(rxq.RxNormTermType, '')
			+ case when t1.EVD_LINK_TYPE_ID = 5 then '1' else '0' end
			+ CONVERT(varchar(100), ISNULL(medid.medid, 0))
			+ CONVERT(varchar(100), ISNULL(mnid.mnid, 0))
			+ CONVERT(varchar(100), ISNULL(ndc.ndc, 0))
		) as [PK_HASH],
		t1.EVD_EXT_VOCAB_ID as [RxNorm],
		CASE WHEN t1.EVD_LINK_TYPE_ID = 5 THEN 'SBD' ELSE 'SCD' END as [RxNormQualifier],
		rxq.RxNormTermType as [RxNormTermType],
		case when t1.EVD_LINK_TYPE_ID = 5 then 1 else 0 end as [IsBrandName],
		medid.medid as [medid],
		mnid.mnid as [mnid],
		ndc.ndc as [NDC],
		t1.IsDelete

		FROM NDD_REVDEL0_EXT_VOCAB_LINK t1 WITH(NOLOCK)
		outer apply (
			SELECT top 1 convert(int, t2.EVD_FDB_VOCAB_ID) as medid
			FROM NDD_REVDEL0_EXT_VOCAB_LINK t2
			WHERE t1.EVD_FDB_VOCAB_ID = t2.EVD_FDB_VOCAB_ID
				AND t1.EVD_FDB_VOCAB_TYPE_ID = t2.EVD_FDB_VOCAB_TYPE_ID
				AND t1.EVD_EXT_VOCAB_ID = t2.EVD_EXT_VOCAB_ID
				AND t1.EVD_EXT_VOCAB_TYPE_ID = t2.EVD_EXT_VOCAB_TYPE_ID
				AND t2.EVD_FDB_VOCAB_TYPE_ID = 3 -- MEDID
			order by t1.EVD_FDB_VOCAB_ID
		) as medid
		outer apply (
			SELECT top 1 convert(int, t2.EVD_FDB_VOCAB_ID) as mnid
			FROM NDD_REVDEL0_EXT_VOCAB_LINK t2
			WHERE t1.EVD_FDB_VOCAB_ID = t2.EVD_FDB_VOCAB_ID
				AND t1.EVD_FDB_VOCAB_TYPE_ID = t2.EVD_FDB_VOCAB_TYPE_ID
				AND t1.EVD_EXT_VOCAB_ID = t2.EVD_EXT_VOCAB_ID
				AND t1.EVD_EXT_VOCAB_TYPE_ID = t2.EVD_EXT_VOCAB_TYPE_ID
				AND t2.EVD_FDB_VOCAB_TYPE_ID = 1 -- mnid
			order by t1.EVD_FDB_VOCAB_ID
		) as mnid
		outer apply (
			SELECT top 1 t2.EVD_FDB_VOCAB_ID as ndc
			FROM NDD_REVDEL0_EXT_VOCAB_LINK t2
			WHERE t1.EVD_FDB_VOCAB_ID = t2.EVD_FDB_VOCAB_ID
				AND t1.EVD_FDB_VOCAB_TYPE_ID = t2.EVD_FDB_VOCAB_TYPE_ID
				AND t1.EVD_EXT_VOCAB_ID = t2.EVD_EXT_VOCAB_ID
				AND t1.EVD_EXT_VOCAB_TYPE_ID = t2.EVD_EXT_VOCAB_TYPE_ID
				AND t2.EVD_FDB_VOCAB_TYPE_ID = 100 -- NDC
			order by t1.EVD_FDB_VOCAB_ID
		) as ndc
		outer apply (
			select top 1 t2.EVD_RXN_TTY as [RxNormTermType]
			from NDD_REVDCS0_RXN_CONCEPT_SOURCE t2 
			where t2.EVD_RXN_SUPPRESS = 'N' -- Not suppressible
			AND t2.EVD_RXN_CODE = t1.EVD_EXT_VOCAB_ID
			order by t2.EVD_RXN_TTY -- desc
		) rxq
		WHERE --t1.IsDelete = 0 and 
			t1.EVD_FDB_VOCAB_TYPE_ID IN (1, 3, 100)

	open out_cursor
	fetch NEXT from out_cursor into @newPK_HASH, @newRxNormCode, @newRxNormQualifier, @newRxNormTermType, @newIsBrandName, @newMEDID, @newMNID, @newNDC, @newIsDelete

	while (@@fetch_status <> -1)
	begin
		if (@@fetch_status <> -2)
		begin
			select @foundCnt = count(*)
			from NDD_SearchRxNorm t1
			where t1.PK_HASH = @newPK_HASH
			if (@foundCnt = 0)
			begin
				insert into NDD_SearchRxNorm (PK_HASH, RxNormCode, RxNormTermType, RxNormQualifier, 
								IsBrandName, medid, mnid, NDC, IsDelete, LastModifiedDate)
				values (@newPK_HASH, @newRxNormCode, @newRxNormTermType, @newRxNormQualifier, 
								@newIsBrandName, @newmedid, @newmnid, @newNDC, @newIsDelete, @newLastModifiedDate)
				set @insertedCnt = @insertedCnt + 1
			end
			else begin
				select @existingIsDelete = IsDelete
				from NDD_SearchRxNorm t1
				where t1.PK_HASH = @newPK_HASH
				if (@newIsDelete <> @existingIsDelete)
				begin
					update NDD_SearchRxNorm set IsDelete = @newIsDelete, LastModifiedDate = @newLastModifiedDate 
						where PK_HASH = @newPK_HASH
					set @deletedCnt = @deletedCnt + 1
				end
			end
		end
	
		fetch NEXT from out_cursor into  @newPK_HASH, @newRxNormCode, @newRxNormQualifier, @newRxNormTermType, @newIsBrandName, @newMEDID, @newMNID, @newNDC, @newIsDelete
	end	-- of while outside

	close out_cursor
	deallocate out_cursor

	select @insertedCnt as [rows inserted], @deletedCnt as [rows marked deleted]

END
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_UpdateFDBData]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[NDD_UpdateFDBData] AS' 
END
GO

-- =================================================================
-- Author:		CHM
-- Create date: 03/21/2018
-- Description:	This store procedure will update FDB NDD tables
-- =================================================================
ALTER PROC [dbo].[NDD_UpdateFDBData]
		@path varchar(1024),		-- set path to folder where data flat files live
		@ProductionDate datetime	-- new production date

AS
BEGIN

	declare @tablename varchar(512)
	declare @max_length int
	declare @Type varchar(255)
	declare @ColumnName varchar(255)
	declare @columnNames varchar(max)
	declare @columnNames@ varchar(max)
	declare @tempTable varchar(max)
	declare @dateColumns varchar(max)
	declare @declares varchar(max)
	declare @where varchar(max)
	declare @updateset varchar(max)
	declare @importTime DateTime
	declare @totalTime DateTime
	declare @tableCnt int
	declare @totalTableCnt int
	declare @sql varchar(max)
	declare @fileExist int
	declare @fileName varchar(8000)

	set @totalTime = GETDATE()
	set @tableCnt = 1
	set @totalTableCnt = 0

	SET NOCOUNT ON
	set xact_abort on

	SELECT DISTINCT @totalTableCnt = COUNT(*) 
		FROM INFORMATION_SCHEMA.TABLES 
		WHERE TABLE_NAME like 'NDD_%' and TABLE_NAME <> 'NDD_PRODUCT_INFO'
		and TABLE_NAME not like 'NDD_Search%'
	
	declare tnames_cursor cursor for
		SELECT DISTINCT Table_Name 
			FROM INFORMATION_SCHEMA.TABLES 
			WHERE TABLE_NAME like 'NDD_%' and TABLE_NAME <> 'NDD_PRODUCT_INFO'
			and TABLE_NAME not like 'NDD_Search%'
			ORDER BY TABLE_NAME

	open tnames_cursor
	fetch NEXT from tnames_cursor into @tablename

	while (@@fetch_status <> -1)
	begin
		if (@@fetch_status <> -2)
		begin
			set @fileName = @path + substring(@tablename, 5, 250)
			EXEC master.dbo.xp_fileexist @fileName, @fileExist OUTPUT
			if (@fileExist = 0)
			begin
				print 'no file ' +  @fileName
				goto cont
			end

			SET @importTime = GETDATE()
			set @columnNames = ''
			set @columnNames@ = ''
			set @tempTable = ''
			set @dateColumns = ''
			set @declares = 'DECLARE @import_Flag varchar(20) DECLARE @cnt int '
			set @where = ''
			set @updateset = ''
			set @sql = ''

			-- get column information
			DECLARE col_cursor CURSOR FOR 
				SELECT col.COLUMN_NAME as [ColumnName], col.DATA_TYPE as [Type], col.CHARACTER_MAXIMUM_LENGTH
					FROM INFORMATION_SCHEMA.COLUMNS col WHERE TABLE_NAME = @tablename
					ORDER BY col.ORDINAL_POSITION
				
			OPEN col_cursor
			FETCH NEXT FROM col_cursor INTO @ColumnName, @Type, @max_length
			WHILE (@@fetch_status <> -1)
			BEGIN
				IF ((@@fetch_status <> -2) AND (@ColumnName <> 'IsDelete')  AND (@ColumnName <> 'LastModifiedDate'))
				BEGIN
					IF (LEN(@columnNames) > 0)
						SET @columnNames = @columnNames + ', '
					SET @columnNames = @columnNames + @ColumnName 
				
					IF (LEN(@updateset) > 0)
						SET @updateset = @updateset + ', '
					SET @updateset = @updateset + @ColumnName + ' = @' + @columnName
				
					IF (LEN(@columnNames@) > 0)
						SET @columnNames@ = @columnNames@ + ', '
					SET @columnNames@ = @columnNames@ + '@' + @ColumnName 
				
					IF (LEN(@tempTable) > 0)
						SET @tempTable = @tempTable + ', '
					
					SET @tempTable = @tempTable + @ColumnName + ' VARCHAR(4000) NULL'			
					SET @declares = @declares + 'DECLARE @' + @ColumnName + ' VARCHAR(4000) '
			
					IF (lower(@Type) = 'datetime')
					BEGIN
						set @dateColumns = @dateColumns +
							' IF (@' + @ColumnName + ' = ''00000000'') ' +
							' BEGIN SET @' + @ColumnName + ' = NULL END '
					END
				END
				FETCH NEXT FROM col_cursor INTO @ColumnName, @Type, @max_length
			END -- of while
			CLOSE col_cursor
			DEALLOCATE col_cursor

			-- get primary keys
			DECLARE pk_cursor CURSOR FOR 
				SELECT column_name as [ColumnName] 
				FROM information_schema.key_column_usage 
				WHERE TABLE_NAME = @tablename and column_name <> 'IsDelete'
			
			OPEN pk_cursor
			FETCH NEXT FROM pk_cursor INTO @ColumnName
			WHILE (@@fetch_status <> -1)
			BEGIN
				IF (LEN(@where) > 0)
					SET @where = @where + ' AND '
				SET @where = @where + @ColumnName + ' = @' + @ColumnName
				
				FETCH NEXT FROM pk_cursor INTO @ColumnName
			END -- of while
			CLOSE pk_cursor
			DEALLOCATE pk_cursor

			set @where = ' WHERE ' + @where
			set @updateset = ' SET ' + @updateset
			set @tempTable = 'CREATE TABLE #ImportFDB ( import_flag varchar(20) null, ' + @tempTable + ') '

			-- set  no count on
			set @sql = 'SET NOCOUNT ON '
			set @sql = @sql + 'declare @importTime DateTime '
			set @sql = @sql + 'declare @addCnt int = 0 '
			set @sql = @sql + 'declare @changeCnt int = 0 '
			set @sql = @sql + 'declare @deleteCnt int = 0 '
			set @sql = @sql + 'SET @importTime = GETDATE() '
			-- drop temp import table
			set @sql = @sql + 'BEGIN TRY DROP TABLE #ImportFDB END TRY BEGIN CATCH END CATCH '
			-- create temp import table
			set @sql = @sql + @tempTable + ' '
			-- bulk insert from file
			set @sql = @sql + 'BULK INSERT #ImportFDB FROM ''' +@fileName +
				''' WITH (DATAFILETYPE = ''char'', FIELDTERMINATOR = ''|'', ROWTERMINATOR = ''\n'', FIRSTROW = 1) '
			-- add declares
			set @sql = @sql + @declares + ' '
			set @sql = @sql + 'BEGIN TRANSACTION '
			-- import loop
			set @sql = @sql + 'DECLARE cat_cursor CURSOR FOR SELECT import_flag, ' + @columnNames + ' FROM #ImportFDB '
			set @sql = @sql + 'OPEN cat_cursor '
			set @sql = @sql + 'FETCH NEXT FROM cat_cursor INTO @import_flag, ' + @columnNames@ + ' '
			set @sql = @sql + 'WHILE (@@fetch_status <> -1) '
			set @sql = @sql + 'BEGIN '
			set @sql = @sql + 'IF (@@fetch_status <> -2) '
			set @sql = @sql + 'BEGIN '
			set @sql = @sql + 'IF (@import_flag = ''A'') '
			set @sql = @sql + 'BEGIN '
			set @sql = @sql + 'set @addCnt = @addCnt + 1 '
			set @sql = @sql + 'END IF (@import_flag = ''C'') '
			set @sql = @sql + 'BEGIN '
			set @sql = @sql + 'set @changeCnt = @changeCnt + 1 '
			set @sql = @sql + 'END IF (@import_flag = ''D'') BEGIN '
			set @sql = @sql + 'set @deleteCnt = @deleteCnt + 1 '
			set @sql = @sql + 'END '
			set @sql = @sql + @dateColumns + ' '
			set @sql = @sql + 'IF (@import_flag = ''A'') '
			set @sql = @sql + 'BEGIN '
			set @sql = @sql + 'SET @cnt = 0 '
			set @sql = @sql + 'SELECT @cnt = COUNT(*) FROM ' + @tablename + ' ' + @where + ' AND IsDelete = 1 '
			set @sql = @sql + 'IF (@cnt > 0) '
			set @sql = @sql + 'BEGIN '
			set @sql = @sql + 'DELETE ' + @tablename + ' ' + @where + ' AND IsDelete = 1 '
			set @sql = @sql + 'END '
			set @sql = @sql + 'SET @cnt = 0 '
			set @sql = @sql + 'SELECT @cnt = COUNT(*) FROM ' + @tablename + ' ' + @where + ' '
			set @sql = @sql + 'IF (@cnt > 0) '
			set @sql = @sql + 'BEGIN '
			set @sql = @sql + 'SET @import_flag = ''C'' '
			set @sql = @sql + 'END '
			set @sql = @sql + 'ELSE BEGIN '
			set @sql = @sql + 'INSERT INTO ' + @tablename + ' ( ' + @columnNames + ', LastModifiedDate ) '
			set @sql = @sql + '	VALUES ( ' + @columnNames@ + ', getutcdate()) '
			set @sql = @sql + 'END '
			set @sql = @sql + 'END '
			set @sql = @sql + 'IF (@import_flag = ''C'') '
			set @sql = @sql + 'BEGIN '
			set @sql = @sql + 'UPDATE ' + @tablename + ' '
			set @sql = @sql + @updateset
			set @sql = @sql + ', LastModifiedDate = getutcdate(), IsDelete = 0 '
			set @sql = @sql + @where + ' '
			set @sql = @sql + 'END '
			set @sql = @sql + 'ELSE IF (@import_flag = ''D'') '
			set @sql = @sql + 'BEGIN '
			set @sql = @sql + 'UPDATE ' + @tablename + ' '
			set @sql = @sql + 'SET IsDelete = 1, LastModifiedDate = getutcdate() '
			set @sql = @sql + @where + ' '
			set @sql = @sql + 'END '
			set @sql = @sql + 'END '
			set @sql = @sql + 'FETCH NEXT FROM cat_cursor INTO @import_flag, ' + @columnNames@ + ' '
			set @sql = @sql + 'END '
			set @sql = @sql + 'CLOSE cat_cursor '
			set @sql = @sql + 'DEALLOCATE cat_cursor '
			set @sql = @sql + 'COMMIT TRANSACTION '
			---- drop temp import table
			set @sql = @sql + 'BEGIN TRY DROP TABLE #ImportFDB END TRY BEGIN CATCH END CATCH '
		
			set @sql = @sql + 'select ''' + CONVERT(varchar(20), @tableCnt) + ' of ' + CONVERT(varchar(20), @totalTableCnt) + ' - ' + @tablename + 
						' Added: '' + convert(varchar(12), @addCnt) + '' Changed: '' + convert(varchar(12), @changeCnt) + '' Deleted: '' + convert(varchar(12), @deleteCnt) as [Update Info]'
			exec (@sql)
			cont:
			SET @tableCnt = @tableCnt + 1
		end -- of if
		fetch NEXT from tnames_cursor into @tablename
	end -- of while

	close tnames_cursor
	deallocate tnames_cursor

	-- change production date
	update NDD_PRODUCT_INFO set IsCurrentRow = 0, IsDelete = 1, LastModifiedDate = getutcdate() where IsCurrentRow = 1
	insert into NDD_PRODUCT_INFO (PRODUCTION_DATE, IsCurrentRow, LastModifiedDate)
		values (@ProductionDate, 1, dateadd(s, 1, getutcdate()))
		
	-- update table NDD_SearchDispensable
	exec NDD_UpdateSearchDispensable

	-- update table NDD_SearchDrugName
	exec NDD_UpdateSearchDrugName

	-- update table NDD_SearchRouted
	exec NDD_UpdateSearchRouted

	-- update table NDD_SearchRxNorm
	exec NDD_UpdateSearchRxNorm

	set @sql = 'DBCC SHRINKDATABASE ( ''' + DB_Name() + ''', TRUNCATEONLY )'
	exec (@sql)
	-- shrink the data file
	set @sql = 'DBCC SHRINKFILE (1, 1) WITH NO_INFOMSGS'
	-- shrink the log file'
	exec (@sql)

END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_UpdateStatus]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[NDD_UpdateStatus] AS' 
END
GO

-- =================================================================
-- Author:		CHM
-- Create date: 03/23/2018
-- Description:	This store procedure will test the update status
--				and return one of the following values:
--				1 - FDB data is up-to-date.
--				2 - FDB data needs to be updating.
--				3 - Appling update out-of-order.
-- =================================================================
ALTER PROC [dbo].[NDD_UpdateStatus]
		@deleteDate datetime,	-- the date value in the row marked 
								-- for deleting in NDDF_PRODUCT_INFO.UPD
		@addDate datetime		-- the date value in the row marked 
								-- for adding in NDDF_PRODUCT_INFO.UPD

AS
BEGIN
	SET NOCOUNT ON
	set xact_abort on

	declare @returnValue int = 3 -- Appling update out-of-order.

	declare @cnt1 int = 0
	declare @cnt2 int = 0

	-- test if FDB data is up to date
	select @cnt1 = count(*) 
	from NDD_PRODUCT_INFO t1
	where t1.IsCurrentRow = 1 
		and t1.IsDelete = 0
		and convert(Date, t1.PRODUCTION_DATE) = convert(Date, @addDate)

	-- test in table NDD_PRODUCT_INFO current row has the same date that is in the @deleteDate
	select @cnt2 = count(*) from NDD_PRODUCT_INFO t1 
	where  t1.IsCurrentRow = 1 
		and t1.IsDelete = 0
		and convert(Date, t1.PRODUCTION_DATE) = convert(Date, @deleteDate)

	if (@cnt1 = 1)
	begin
		set @returnValue = 1 -- FDB data is up-to-date.
	end
	else if ((@cnt1 = 0) and (@cnt2 = 1))
	begin
		set @returnValue = 2 -- FDB data needs to be updating.
	end

	select @returnValue as [Result]
end



GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PRMSpaceUsedCommon]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[PRMSpaceUsedCommon] AS' 
END
GO

ALTER PROC [dbo].[PRMSpaceUsedCommon] @NameLike varchar(40) = '' , @NumberofTables int = 0  AS
BEGIN

	CREATE TABLE #SpaceUsed 
	(
		TableName varchar(255),
		Rows int,
		Reserved varchar(50),
		DataSize varchar(50),
		IndexSize varchar(50),
		Unused varchar(50)
	)
	set NOCOUNT ON

	DECLARE @tableName varchar(255)
	DECLARE cur CURSOR FOR SELECT Name FROM sysobjects WHERE xtype = 'U' AND Name LIKE '%' + @NameLike +'%'

	OPEN cur
	FETCH NEXT FROM cur INTO @tableName
	WHILE @@FETCH_STATUS = 0
	BEGIN
		INSERT INTO #SpaceUsed EXEC sp_spaceused @tableName 

		FETCH NEXT FROM cur INTO @tableName
	END
	CLOSE cur
	DEALLOCATE cur

	DECLARE @dbTotal bigint 
	select @dbTotal = SUM(dbo.ConvertToBytesCommon(Reserved)) from #SpaceUsed

	IF (@NumberofTables = 0)
		BEGIN
				SELECT		*, dbo.ConvertToBytesCommon(Reserved) AS [Total Bytes], CAST(100.0*dbo.ConvertToBytesCommon(Reserved)/@dbTotal as decimal(14,2)) as [Percent]
			FROM		#SpaceUsed
			ORDER BY	[Total Bytes] DESC
		END
	ELSE
		BEGIN
			SELECT		TOP (@NumberofTables) *, dbo.ConvertToBytesCommon(Reserved) AS [Total Bytes], CAST(100.0*dbo.ConvertToBytesCommon(Reserved)/@dbTotal as decimal(14,2)) as [Percent]
			FROM		#SpaceUsed
			ORDER BY	[Total Bytes] DESC
		END
	
	select @dbTotal  / 1024 / 1024 [DB Total Size MB]
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VersionInfoCommon]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[VersionInfoCommon] AS' 
END
GO

ALTER PROC [dbo].[VersionInfoCommon] AS
	SET NOCOUNT ON;
	declare @SQL varchar(2000)
	declare @dbName sysname = DB_Name() + '_Formulary'

	set @sql = 'SELECT vc.PRMVersion + ''.'' + CAST(vc.PRMSeq as varchar) + '' - '' +	vcf.PRMVersion + ''.'' + CAST(vcf.PRMSeq as varchar)  as [CommonVersions] FROM VersionCommon vc 
		inner join ' + QuoteName(@dbName) + '.dbo.VersionCommonFormulary vcf on vc.Status = vcf.Status where vc.Status = 0'

	exec (@SQL)

GO

