IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CreateDatabaseCLR]') AND type in (N'P', N'PC'))
BEGIN
	DROP PROCEDURE [dbo].[CreateDatabaseCLR]
END
GO

SET ANSI_NULLS ON
GO

SET QUOTED_IDENTIFIER ON
GO

CREATE PROC [dbo].[CreateDatabaseCLR] AS
BEGIN
	EXEC sp_executesql N'
		BEGIN
			exec sp_changedbowner ''sa''

			EXEC sp_configure @configname = ''clr enabled'', @configvalue = 1
			RECONFIGURE WITH OVERRIDE
			
			DECLARE @dbname varchar(255) = db_name()
			EXECUTE(''ALTER DATABASE ['' + @dbname + ''] SET TRUSTWORTHY ON'')
			
			IF  EXISTS (SELECT * FROM sys.assemblies asms WHERE asms.name = N''PRMDatabaseCLR'')
			BEGIN
				If EXISTS (SELECT * FROM sys.objects where Name = N''UninstallDatabaseCLR'')
					exec UninstallDatabaseCLR
				
				PRINT ''Dropping Assembly [PRMDatabaseCLR]''
				DROP ASSEMBLY [PRMDatabaseCLR];
			END
		END
		'
	EXEC sp_executesql N'
			USE [master];  -- this will automatically reset to the PRM DB
			DECLARE @dbname varchar(255) = db_name()
		
			IF NOT EXISTS (select name from sys.certificates where name = ''PRMCLRCodeCert2019'')
			BEGIN
				IF  EXISTS (SELECT * FROM sys.assemblies asms WHERE asms.name = N''PRMDatabaseCLR'')
				BEGIN
					If EXISTS (SELECT * FROM sys.objects where Name = N''UninstallDatabaseCLR'')
						exec UninstallDatabaseCLR
					DROP ASSEMBLY [PRMDatabaseCLR];
				END
				EXECUTE(''ALTER DATABASE ['' + @dbname + ''] SET TRUSTWORTHY ON'')
			
				PRINT ''Create temporary [PRMDatabaseCLR] in master''
				-- the string DLLBYTES below will be replaced by the DatabaseCLR post build step
				CREATE ASSEMBLY [PRMDatabaseCLR]
				AUTHORIZATION [dbo]
				FROM 0x4d5a90000300000004000000ffff0000b800000000000000400000000000000000000000000000000000000000000000000000000000000000000000800000000e1fba0e00b409cd21b8014ccd21546869732070726f6772616d2063616e6e6f742062652072756e20696e20444f53206d6f64652e0d0d0a2400000000000000504500004c01030084f8fb5d0000000000000000e00022200b013000008a000000080000000000003ea900000020000000c00000000000100020000000020000040000000000000004000000000000000000010000020000b1ba0000030040850000100000100000000010000010000000000000100000000000000000000000eca800004f00000000c00000700400000000000000000000009400006018000000e000000c000000b4a700001c0000000000000000000000000000000000000000000000000000000000000000000000000000000000000000200000080000000000000000000000082000004800000000000000000000002e746578740000004489000000200000008a000000020000000000000000000000000000200000602e727372630000007004000000c0000000060000008c0000000000000000000000000000400000402e72656c6f6300000c00000000e000000002000000920000000000000000000000000000400000420000000000000000000000000000000020a90000000000004800000002000500505400006453000001000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000001e027b1500000a2a1e027b1600000a2a5602281700000a02037d1500000a02047d1600000a2a0000133003003b0000000100001103750100001b0a062c2f281800000a027b1500000a067b1500000a6f1900000a2c17281a00000a027b1600000a067b1600000a6f1b00000a2a162ad220ad2c1dea20295555a55a281800000a027b1500000a6f1c00000a5820295555a55a281a00000a027b1600000a6f1d00000a582a133007008800000002000011147201000070188d110000012516027b1500000a0a12001201fe150400001b078c0400001b2d14710400001b0b1201078c0400001b2d0426142b0bfe160400001b6f1e00000aa22517027b1600000a0c12021203fe150500001b098c0500001b2d14710500001b0d1203098c0500001b2d0426142b0bfe160500001b6f1e00000aa2281f00000a2a13300600220100000300001102282000000a2c0b7241000070732100000a7a03282000000a2c0b729f000070732100000a7a282200000a0a0672050100701a8d11000001251602a2251703a225180f02282300000aa225190f03282400000aa2282500000a6f2600000a724301007003042d0772570100702b05725f010070282700000a0b0207282800000a0c067267010070088e698c4c00000107282700000a6f2600000a282900000a0d0813041613052b71110411059a732a00000a13060672a901007011066f2b00000a11066f2c00000a8c17000001282700000a6f2600000a11066f2d00000a130712031107282e00000a13081208282f00000a05311e0672f101007011066f3000000a283100000a6f2600000a11066f3200000a110517581305110511048e6932872a5a282200000a721f02007002283300000a6f2600000a2a1e02281700000a2a3a02283400000a02037d030000042a1e027b030000042a3e0203280a00000602047d040000042a1e027b040000042a220203280a0000062a3e0203280a00000602047d050000042a1e027b050000042a1e02283400000a2a0000001b300100330000000400001102282000000a2c0b724d020070732100000a7a0002283500000a2c0917283600000a0ade0cde0326de0016283600000a2a062a00011000000000140013270003200000011330010024000000050000110f00283700000a2c067e3800000a2a0f00283900000a0a1200283a00000a733b00000a2a1330010024000000050000110f00283700000a2c067e3800000a2a0f00283900000a0a1200283c00000a733b00000a2a8e0f01283d00000a7e06000004733e00000a0f00283d00000a6f3f00000a283600000a2aaa0f01283d00000a7e06000004733e00000a0f00283d00000a0f02283d00000a6f4000000a284100000a2a00133006008e000000060000110f00284200000a2c067e4300000a2a0f00283d00000a178d5000000125161f2e9d6f4400000a0a1a8d4c0000010b160c2b1406089a07088f4c000001284500000a260817580c08068e6932e6727f0200701a8d1100000125160716948c4c000001a225170717948c4c000001a225180718948c4c000001a225190719948c4c000001a2282500000a284100000a2a0000133005000a010000070000110f00284200000a2d090f01284200000a2c067e4600000a2a0f00283d00000a178d5000000125161f2e9d6f4400000a0a0f01283d00000a178d5000000125161f2e9d6f4400000a0b068e691a3206078e691a2f067e4600000a2a06169a284700000a0c07169a284700000a0d120209284800000a130411042c081104734900000a2a06179a284700000a130507179a284700000a130612051106284800000a130711072c081107734900000a2a06189a284700000a130807189a284700000a130912081109284800000a130a110a2c08110a734900000a2a06199a284700000a130b07199a284700000a130c120b110c284800000a130d110d2c08110d734900000a2a16734900000a2a00001b300400ae0000000800001172b70200700a0f00284a00000a2c067e4300000a2a046f4b00000a2c067e4300000a2a0f01284200000a2d080f01283d00000a0a734c00000a0b07046f4d00000a6f4e00000ade1d0d72c7020070046f4d00000a72f5020070284f00000a09735000000a7a077221030070060f00285100000a13041204fe16280000016f1e00000a282700000a6f5200000a75270000010c082d067e4300000a2a080f03283d00000a6f5300000a735400000a2a00000110000000003a000e48001d200000011b3004002d0100000900001172b70200700a0f00284200000a2d080f00283d00000a0a160b0f01284a00000a2d78056f4b00000a2d70734c00000a0c08056f4d00000a6f4e00000ade1f130472c7020070056f4d00000a72f5020070284f00000a1104735000000a7a087221030070060f01285100000a13051205fe16280000016f1e00000a282700000a6f5200000a75270000010d092c0d09725703007007280100002b0b0f02284a00000a3a800000000e046f4b00000a2d77734c00000a130611060e046f4d00000a6f4e00000ade1f13087261030070056f4d00000a72f5020070284f00000a1108735000000a7a11067221030070060f02285100000a13051205fe16280000016f1e00000a282700000a6f5200000a7527000001130711072c0e1107725703007007280100002b0b07735500000a2a000000011c0000000030000e3e001f200000010000b60010c6001f200000011b300300210100000a0000110f00285600000a2d090f00285700000a2b01160a0f01284a00000a2d75056f4b00000a2d6d734c00000a0b07056f4d00000a6f4e00000ade1d0d72c7020070056f4d00000a72f5020070284f00000a09735000000a7a0772870300700f01285100000a13041204fe16280000016f1e00000a283100000a6f5200000a75270000010c082c0d0872bb03007006280100002b0a0f02284a00000a2d7f0e046f4b00000a2d76734c00000a130511050e046f4d00000a6f4e00000ade1f13077261030070056f4d00000a72f5020070284f00000a1107735000000a7a110572870300700f02285100000a13041204fe16280000016f1e00000a283100000a6f5200000a7527000001130611062c0e110672bb03007006280100002b0a06735500000a2a000000011c000000002b000e39001d200000010000ab0010bb001f200000011b300300c40100000b0000111200fe150600001b0f00285600000a2d0e12000f00285700000a285800000a0f01284a00000a3ab1000000056f4b00000a3aa6000000734c00000a0b07056f4d00000a6f4e00000ade1d0d72c7020070056f4d00000a72f5020070284f00000a09735000000a7a0772d30300700f01285100000a13041204fe16280000016f1e00000a283100000a6f5200000a75270000010c082c460872090400701206fe150700001b1106280200002b13051205285900000a2c261205285a00000a152e111205285a00000a16fe03735800000a2b0a1207fe150600001b11070a0f02284a00000a3abb0000000e046f4b00000a3aaf000000734c00000a130811080e046f4d00000a6f4e00000ade1f130a7261030070056f4d00000a72f5020070284f00000a110a735000000a7a110872d30300700f02285100000a13041204fe16280000016f1e00000a283100000a6f5200000a7527000001130911092c47110972090400701206fe150700001b1106280200002b130b120b285900000a2c26120b285a00000a152e11120b285a00000a16fe03735800000a2b0a1207fe150600001b11070a1200285b00000a2d0b120cfe151f000001110c2a1200285c00000a735500000a2a011c000000003c000e4a001d200000010000fb00100b011f200000011b300300670000000c00001173680000060a06027d08000004036f4b00000a2c06735d00000a2a036f4d00000a285e00000a6f5f00000a06fe0669000006736000000a280300002b280400002b0b072d06735d00000a2a076f6300000a0c08736400000a0dde0a082c06086f6500000adc092a000110000002005200095b000a000000001b300400430100000d00001172b70200700a0f01284200000a2d080f01283d00000a0a0f00286600000a2d090f00286700000a2b01160b0f02284a00000a2d7b0e046f4b00000a2d72734c00000a0c080e046f4d00000a6f4e00000ade20130472c70200700e046f4d00000a72f5020070284f00000a1104735000000a7a087221030070060f02285100000a13051205fe16280000016f1e00000a282700000a6f5200000a75270000010d092c0d09721b04007007280500002b0b0f03284a00000a3a810000000e056f4b00000a2d78734c00000a130611060e056f4d00000a6f4e00000ade20130872610300700e046f4d00000a72f5020070284f00000a1108735000000a7a11067221030070060f03285100000a13051205fe16280000016f1e00000a282700000a6f5200000a7527000001130711072c0e1107721b04007007280500002b0b07734900000a2a00011c0000000043000f520020200000010000cb0010db0020200000011b300300a70000000e0000110f00284200000a2c06735d00000a2a0f00283d00000a0a150b150c150d734c00000a1304066f6800000a0d07152e0d08152e091200070828330000061104066f4e00000a11046f6900000a736a00000a286b00000a13051105736400000a1306de4211052c0711056f6500000adc130711076f6c00000a07331511076f6d00000a08330b09066f6800000a3302fe1a11076f6c00000a0b11076f6d00000a0cdd79ffffff11062a00011c0000020057000b62000c00000000000024004a6e00362c0000011b300400990000000f000011026f4b00000a2c06735d00000a2a026f4d00000a282000000a2c06735d00000a2a734c00000a25026f4d00000a6f4e00000a7235040070038c22000001048c28000001282700000a0a066f5200000a74270000010b072d06735d00000a2a725d040070076f6e00000a6f6f00000a076f6900000a282700000a736a00000a286b00000a0c08736400000a0dde0a082c06086f6500000adc092a0000000110000002008400098d000a0000000013300400bb000000100000110f00284200000a2c0a1201fe1521000001072a0f00283d00000a282000000a2c0a1201fe1521000001072a0f00283d00000a1200287000000a2d450f00283d00000a28300000060c081200287000000a2d2e081203284500000a2d0a1201fe1521000001072a0920080700003212092034080000300a1200091717287100000a0620080700001717737100000a287200000a1632150620340800001717737100000a287200000a16310a1201fe1521000001072a06733b00000a2a001330030076000000110000110f01283d00000a282000000a2c02022a0f00283700000a2c02022a0f01283d00000a727b04007017287300000a2d08287400000a0a2b0d0f01283d00000a287500000a0a062d1c72870400700f01283d00000a72a3040070284f00000a732100000a7a0f00283900000a06287600000a733b00000a2a00001330030076000000110000110f01283d00000a282000000a2c02022a0f00283700000a2c02022a0f01283d00000a727b04007017287300000a2d08287400000a0a2b0d0f01283d00000a287500000a0a062d1c72870400700f01283d00000a72a3040070284f00000a732100000a7a0f00283900000a06287700000a733b00000a2a00001330060056000000120000110f00284200000a2c087e7800000a0a2b080f00283d00000a0a036f7900000a176a2e1b72c1040070036f7900000a8c58000001287a00000a737b00000a7a06178d500000012516036f7c00000a16939d6f4400000a2a0000133002002e000000120000110274470000010a062c07066f7d00000a0a06282000000a2c0803fe15220000012a0306735400000a81220000012a00001330050024010000130000110214284100000a287e00000a13041104287f00000a2d191104027e7800000a284100000a287e00000a288000000a2b0211040d09287f00000a2d14090f00284200000a283600000a288000000a2b01090c08287f00000a2d58080314284100000a287e00000a13041104287f00000a2d191104037e7800000a284100000a287e00000a288000000a2b0211040d09287f00000a2d14090f01284200000a283600000a288000000a2b0109288000000a2b0108287f00000a2c067e8100000a2a73430000060a060f00283d00000a6f3e0000060f01283d00000a6f7d00000a0b13051613062b30110511069a130706110712081209120a6f400000060611081109110a076f420000062c067e8200000a2a110617581306110611058e6932c87e8100000a2a1b3005000601000014000011022d03142b0602287d00000a1000032d03142b0603287d00000a1001052d03142b0605287d00000a1003738300000a0a031f286f8400000a0b07152e282b1306030717586f8500000a6f8600000a0718580b07036f6800000a32e40316076f8700000a100102282000000a2c32042c23030516056f6800000a036f6800000a288800000a6f8700000a17287300000a2c0e162a030517287300000a2c02162a020517287300000a16310d030517287300000a163002162a066f8900000a2d02172a066f8a00000a0c2b1e1202288b00000a0d05056f6800000a17596f8500000a093305171304de1b1202288c00000a2dd9de0e1202fe160a00001b6f6500000adc162a11042a0000011000000200c8002bf3000e000000001b3004006301000015000011026f4b00000a2d0d026f4d00000a282000000a2c02042a0f01284a00000a2c0b723b050070737b00000a7a0f03284a00000a2c0b727b050070737b00000a7a026f4d00000a285e00000a0a046f4b00000a2d0d046f4d00000a282000000a2c0e066f8d00000a738e00000a0b2b0c046f4d00000a285e00000a0b0672bb0500700f01285100000a13041204fe16280000016f1e00000a72d5050070284f00000a288f00000a0c082d02042a0772bb0500700f03285100000a13041204fe16280000016f1e00000a72d5050070284f00000a288f00000a0d092d22086f8d00000a738e00000a0d0972db050070289000000a058c240000016f9100000a086f9200000a6f9300000a13052b3511056f9400000a130611066f9500000a72db050070289000000a289600000a2d140911066f9500000a11066f9700000a6f9100000a11056f9800000a2dc2de0c11052c0711056f6500000adc076f6300000a736400000a2a000110000002000901424b010c00000000133004008c00000016000011026f4b00000a2d0d026f4d00000a282000000a2c02022a0f01284a00000a2c0b72e3050070737b00000a7a026f4d00000a285e00000a0a0672bb0500700f01285100000a0c1202fe16280000016f1e00000a72d5050070284f00000a288f00000a0b072d02022a076f9900000a066f5f00000a280600002b2d06289b00000a2a066f6300000a736400000a2a8e02289c00000a03289c00000a04289c00000a05289d00000a282b000006283600000a2a13300300550000000000000002282000000a2c02162a03282000000a2c1a052d090204289e00000a2d0c052c0b0204282c0000062c02172a02041a289f00000a16301c052d0b03041a289f00000a16300c052c0b0403282c0000062c02172a162aee02282000000a2d1603282000000a2d0e036f6800000a026f6800000a3102162a0216036f6800000a6f8700000a031a289f00000a16fe0216fe012a000000133005004f000000170000110f00284200000a2c0a1201fe1522000001072a0f00283d00000a6f6800000a185a8d5d0000010a0f00283d00000a6fa000000a160616068e6928a100000a28a200000a066fa300000a735400000a2a001330040091000000180000110f00284200000a2c0b1204fe152200000111042a0f00283d00000a6fa000000a0a068e698d5d0000010b1613052b0f07110506110593d29c1105175813051105068e6932ea73a400000a076fa500000a0c088e6973a600000a0d1613062b1f090811068f5d000001721d06007028a700000a6fa800000a261106175813061106088e6932da096f1e00000a735400000a2a0000001330020034000000190000110f00284200000a2c0a1201fe1535000001072a0f00283d00000a120028a900000a2d0a1201fe1535000001072a0673aa00000a2a133003009f0000001a0000117e7800000a0a7e7800000a0b020c160d2b7f08096f8500000a1304110428ab00000a2c0e06120428ac00000a283300000a0a11041f2f330e06120428ac00000a283300000a0a11041f202e0f11041f2e2e09110428ad00000a2c1b0728310000062c0d06077223060070284f00000a0a7e7800000a0b110428ae00000a2c0e07120428ac00000a283300000a0b0917580d09086f6800000a3f75ffffff062a0013300400f70000001b0000111f188d4700000125167227060070a22517722f060070a225187237060070a22519723f060070a2251a7247060070a2251b724f060070a2251c7257060070a2251d725f060070a2251e7267060070a2251f09726f060070a2251f0a7279060070a2251f0b7281060070a2251f0c7289060070a2251f0d7291060070a2251f0e72a1060070a2251f0f72b3060070a2251f1072bf060070a2251f1172cb060070a2251f1272d5060070a2251f1372df060070a2251f1472ed060070a2251f157201070070a2251f167211070070a2251f177223070070a20a160b2b1406079a0c020817287300000a2d02172a0717580b07068e6932e6162a00133004005d0000001c000011170a170b160c2b4a0250086f8500000a1f0d33220802506f6800000a17592f1602500817586f8500000a1f0a33080617580a170b2b18060333100704330c02025008176faf00000a512a0717580b0817580c0802506f6800000a32ac2a00000013300500e60000001d000011170a170b160c38cd0000000250086f8500000a1f0d33250802506f6800000a17592f1902500817586f8500000a1f0a330b0617580a170b38980000000603408d00000007044086000000150d1513040813052b18025011056f8500000a1f22330511050d2b0b1105175913051105162fe30813062b19025011066f8500000a1f223306110613042b11110617581306110602506f6800000a31dc09152e261104152e21020250160917586f8700000a7235070070025011046fb000000a284f00000a512a02025008176faf00000a512a0717580b0817580c0802506f6800000a3f26ffffff2a221f3080060000042a4e28b100000a2c0b282200000a026f2600000a2a1e1728390000062a1e1628390000062a001b3005001b0100001e00001173b200000a0a28b100000a2c110672590700706fb300000a066fb400000a28b500000a0b076fb600000a7e0a000004252d17267e09000004fe066c00000673b700000a25800a000004280700002b7e0b000004252d17267e09000004fe066d00000673b900000a25800b000004280800002b7e0c000004252d17267e09000004fe066e00000673ba00000a25800c000004280900002b6fbb00000a0c2b56086fbc00000a0d7289070070096fbd00000a283300000a283600000609076fbe00000a6fbf00000ad01e00000128c000000a0206283a00000609076fbe00000a6fbf00000ad01500000128c000000a0206283a000006086f9800000a2da2de0a082c06086f6500000adc066fc100000ade0a062c06066f6500000adc2a0041340000020000009c00000062000000fe0000000a0000000000000002000000060000000a010000100100000a000000000000001b300700980300001f00001173720000060a06047d10000004026fc200000a06fe067300000673c300000a280a00002b7e0d000004252d17267e09000004fe066f00000673c400000a25800d000004280b00002b7e0e000004252d17267e09000004fe067000000673c500000a25800e000004280c00002b140b6fc600000a0c3802030000086fc700000a0d096fbd00000a72bb070070289e00000a2d12096fbd00000a72e1070070289e00000a2b0117055f3acf020000720b080070052d07722f0800702b057241080070096fbd00000a282700000a283600000673c800000a1304053a84000000110472530800701a8d110000012516067b10000004d01500000128c000000a2e0772cf0800702b0572e1080070a22517096fbd00000aa22518067b10000004d01500000128c000000a2e0772eb0800702b05722b090070a22519067b10000004d01500000128c000000a2e0772510900702b05726f090070a26fc900000a2638b70100001104727d090070067b10000004d01500000128c000000a2e0772cf0800702b0572e1080070096fbd00000a6fca00000a26067b10000004d01e00000128c000000a330d110472a10900706fa800000a26161305096fcb00000a13061613073888000000737400000613081108110611079a7d1100000411052c0d110472a70900706fa800000a2609d00400000228c000000a176fcc00000a1108fe067500000673cd00000a280d00002b280e00002b74040000021309110472ad09007011087b110000046fce00000a11087b110000046fcf00000a1109283b0000066fca00000a26171305110717581307110711068e693f6dffffff067b10000004d01e00000128c000000a330d110472bf0900706fa800000a26096fd000000a2c6d096fd000000ad06900000128c000000a2e5b09d00400000228c000000a176fcc00000a7e0f000004252d17267e09000004fe067100000673cd00000a25800f000004280d00002b280e00002b7404000002130a110472c5090070096fd000000a110a283b0000066fd100000a26110472e1090070168d110000016fc900000a26110472130a007003026fd200000a096fbd00000a6fd300000a2673d400000a130b110b0e046fd500000a110b11046f1e00000a6fd600000a72530a0070110b6fd700000a283300000a2836000006110b6fd800000a26de2572610a0070110b6fd700000a283300000a28360000060bde0c110b2c07110b6f6500000adc086f9800000a3af3fcffffde0a082c06086f6500000adc072c02077a2a414c0000000000003603000020000000560300001900000020000001020000001f030000500000006f0300000c00000000000000020000007400000014030000880300000a00000000000000133003009d0100002000001102d04b00000128c000000a2e0d02d01f00000128c000000a330672970a00702a02d04700000128c000000a2e0d02d02200000128c000000a33590375060000022c06729f0a00702a0375050000020a062d0672a70a00702a066f0d00000615330672a70a00702a066f0d0000062c1e72c30a0070066f0d0000060b1201282400000a72d70a0070284f00000a2a72db0a00702a02d04c00000128c000000a2e0d02d02300000128c000000a330672f70a00702a02d06300000128c000000a2e0d02d03500000128c000000a330672ff0a00702a02d01700000128c000000a2e0d02d02100000128c000000a3306720b0b00702a02d02800000128c000000a2e0d02d02400000128c000000a3306721d0b00702a02d02500000128c000000a3306729f0a00702a02d02f00000128c000000a332a0375050000020c723f0b0070082c10086f0d0000060b1201282400000a2b0572550b0070283100000a2a02d02e00000128c000000a33180375070000020d725d0b0070096f10000006283100000a2a72750b0070026fbd00000a72890b0070284f00000a732100000a7a00000013300400a00000002100001172df0b00700a0228d900000a258e69185a1f645873a600000a0b0772f50b00706fa800000a260d1613042b1f0911049113050772fb0b007011058c5d0000016fd100000a261104175813041104098e6932da0328da00000a0c0872df0b0070076f1e00000a6fdb00000a0c08066fdc00000a2c09030828dd00000a2b1772090c007006722f0c00700328de00000a732100000a7a724f0c007003283300000a2a9a03282000000a2c07168d470000012a03188d5000000125161f3b9d25171f2c9d6f4400000a2a00133004006d00000022000011030350252d0426142b05287d00000a510350282000000a2c040414512a03501f286f8400000a0a061533040414512a060b738300000a0c2b140803500617586f8500000a6f8600000a0619580a0603506f6800000a185932e004086fdf00000a5103035016076f8700000a512a00000013300500730000002300001103178d5000000125161f2d9d6f4400000a0a068e2d0b0414510514510e0414512a068e691733170406169a6f7d00000a5105145102040e04283f0000062a068e6918331e0406169a6f7d00000a510506179a6f7d00000a5102050e04283f0000062a72630c007003283300000a732100000a7ab2052d09030417287300000a2a030416046f6800000a036f6800000a288800000a6f8700000a17287300000a2a13300500720000002400001104282000000a2c1802030e04047e7800000a289e00000a28410000062c20162a02030e04162841000006163102162a02040e04162841000006163002162a052c04058e2d02172a0e040e046f6800000a17596f8500000a0a050b160c2b0c070893063302172a0817580c08078e6932ee162a0000133005002b0000002500001102036fe000000a0a06162f02022a0216066f8700000a040206036f6800000a586fb000000a284f00000a2a00133004005a0000002600001102036fe000000a0a06162f02022a0617580b2b040717580b07026f6800000a2f0b02076f8500000a1f2033e807026f6800000a2f160216066f8700000a0402076fb000000a284f00000a2a0216066f8700000a04283300000a2a0000133005008a0000002700001173e100000a0a160b2b5f0203076fe200000a0b0716325d0717580c2b040817580c08026f6800000a2f0b02086f8500000a1f2033e808026f6800000a2f17060207175808075917596f8700000a6fe300000a262b1006020717586fb000000a6fe300000a260817580b07026f6800000a1759329606d04700000128c000000a6fe400000a741800001b2a0000133003003600000026000011160a160b2b250203066fe200000a0a061632210717580b06026f6800000a17592f1206036f6800000a580a06026f6800000a32d2072a52022c0d026f7d00000a282000000a2c02172a162aaa036f6800000a026f6800000a2f02162a020316026f6800000a6f8700000a17287300000a2d02172a162a0000133004005c0000001c000011150a150b160c2b2a02086f8500000a03330a061533060817580a2b1202086f8500000a04330806153104080b2b0d0817580c08026f6800000a32cd07153307026f6800000a0b06153302022a02060706596f8700000a6f7d00000a2a13300500390000002800001102178d500000012516039d6f4400000a0a068e698d280000010b160c2b13070806089a73e500000aa4280000010817580c08068e6932e7072a00000013300300210000002500001102282000000a2c02022a02036fe600000a0a06153302022a0216066f8700000a2a00000013300300210000002500001102282000000a2c02022a02036f8400000a0a06153302022a0216066f8700000a2a00000013300300550000000000000002282000000a2c0703282000000a2a0417594503000000020000000b000000140000002b2402031b6fe700000a2a02031b6fe800000a2a026fe900000a036fe900000a6fdc00000a2a020317287300000a16fe012a000000133004002c0000002500001102282000000a2c02022a02036fe600000a0a06153302022a02061758026f6800000a065917596f8700000a2a13300400d0010000290000110f0028ea00000a230000000000408f4034170f0028ea00000a8c6300000172c70c0070287a00000a2a0f0028eb00000a230000000000004e40341f0f0028eb00000a0a120072cd0c007028ec00000a72d70c0070283300000a2a0f0028ed00000a230000000000004e4034571c8d1100000125160f0028ee00000a0b1201282400000aa2251772db0c0070a225180f0028ef00000a0b1201282400000aa2251972df0c0070a2251a0f0028f000000a8c4c000001a2251b72e30c0070a228f100000a2a0f0028f200000a23000000000000384034711e8d1100000125160f0028f300000a0b1201282400000aa2251772db0c0070a225180f0028ee00000a0b1201282400000aa2251972db0c0070a2251a0f0028ef00000a0b1201282400000aa2251b72df0c0070a2251c0f0028f000000a8c4c000001a2251d72eb0c0070a228f100000a2a1f0a8d1100000125160f00282f00000a8c4c000001a2251772db0c0070a225180f0028f300000a0b1201282400000aa2251972db0c0070a2251a0f0028ee00000a0b1201282400000aa2251b72db0c0070a2251c0f0028ef00000a0b1201282400000aa2251d72df0c0070a2251e0f0028f000000a8c4c000001a2251f0972f50c0070a228f100000a2a13300400530000002600001102036fe000000a0a061533067e7800000a2a06036f6800000a580a04282000000a2c09026f6800000a0b2b090204066fe200000a0b071533067e7800000a2a0206070659046f6800000a5917586f8700000a2a0013300500730000002a00001173f400000a0a02282000000a2c02062a02166f8500000a1f3f330902176fb000000a100002178d5000000125161f269d6f4400000a0b160c2b3107089a178d5000000125161f3d9d6f4400000a0d0609169a098e691730077e7800000a2b0309179a6ff500000a0817580c08078e6932c9062a6202282000000a2d0902031b28f600000a2a03282000000a2a1b300300650000002b000011022d012a026ff700000a6ff800000a0a2b37066ff900000a74410000010b042d0e03076f6f00000a6ffa00000a2d1a02076f6f00000a6f5300000a0c03076f6f00000a086ffb00000a066f9800000a2dc1de110675420000010d092c06096f6500000adc2a000000011000000200100043530011000000004e022d02042a02036f5300000a04280f00002b2a133003004b0000002c000011048c1900001b2c1d0f021200fe151900001b068c1900001bfe161900001b6ffc00000a2c1102036ffa00000a2c0702036ffd00000a2a02030f02fe161900001b6f1e00000a6ffb00000a2a4a022d02032a026ffe00000a03280f00002b2a000013300200310000002c000011022c0902036fff00000a2d0a1200fe151900001b062a02036fff00000a6ffe00000a1200fe151900001b06280f00002b2a000000133002002a0000002d00001102036f5200000a74270000010a062d0a1201fe151900001b072a061201fe151900001b07281000002b2a0000133002001a0000002e00001102036f5200000a74270000010a062d02042a0604281000002b2a000013300300490000002f000011026f0001000a14fe01045f2c2c031f2f6f8400000a0c08153304030b2b090316086f8700000a0b02076f0101000a0a02066f0201000a262b07026f0001000a0a060304285c0000062a00000013300500a701000030000011020a0372fd0c00706f0301000a2c0b03186fb000000a10012b160372030d00706f0301000a2c0903176fb000000a100103178d5000000125161f2f9d6f4400000a0b078e2d02142a026f6f00000a07169a280401000a2c2d07169a72df0c0070280401000a2c1e72070d0070066f6f00000a722b0d007007169a28de00000a732100000a7a170c381001000007089a0d06096f5200000a7427000001130411043af0000000042d02142a091305141306091f5b6f8400000a13071107152e36091f5d11076f0501000a1308110815330b72750d0070732100000a7a091611076f8700000a130509110711081107596f8700000a1306026f0601000a11056f0101000a13040611046f0201000a261106282000000a2d7f1106178d47000001251672c90d0070a2176f0701000a130916130a2b5a1109110a9a251f401f3d284a000006130b1f3d16284a000006130c110c1f271f27284a000006130c110c1f221f22284a000006130c110b282000000a2c0b72d50d0070732100000a7a1104110b110c6ffb00000a110a1758130a110a11098e69329e11040a0817580c08078e693fe7feffff062a0013300200170000002e000011026f0601000a036f0101000a0a02066f0201000a26062a00133007006d00000031000011730801000a0a022d02062a026f0901000a25722f0e007003283300000a6f0a01000a0b0772350e007004283300000a171672390e0070052d03172b01186f0b01000a076f0c01000a0c2b18086f0d01000a6f0e01000a75270000010d06096f0f01000a086f1001000a2de0062a00000013300200ae0100000000000002282000000a2c02032ad01900001b28c000000ad02800000128c000000a33110273e500000a8c28000001a51900001b2ad01900001b28c000000ad04700000128c000000a330702a51900001b2ad01900001b28c000000ad04b00000128c000000a332102723b0e0070289e00000a2d0802281101000a2b01178c4b000001a51900001b2ad01900001b28c000000ad03800000128c000000a330c02281201000aa51900001b2ad01900001b28c000000ad04c00000128c000000a333f026fe900000a723f0e0070289e00000a2c0c168c4c000001a51900001b2a026fe900000a724b0e0070289e00000a39a8000000178c4c000001a51900001b2ad01900001b28c000000ad01b00001b28c000000a331102284700000a8c4c000001a51900001b2ad01900001b28c000000ad01c00001b28c000000a331102281301000a8c63000001a51900001b2ad01900001b28c000000ad00700001b28c000000a331102281401000a8c73000001a51900001b2ad01900001b28c000000a6f1501000a2c16d01900001b28c000000a02281601000aa51900001b2a02d01900001b28c000000a281701000aa51900001b2a5a02282000000a2c02162a027e07000004281801000a2a00000013300200cb0000003200001102282000000a2c0f032d067e7800000a2a72550e00702a7e7800000a0a020b160c389700000007086f8500000a0d091f613215091f7a301006120328ac00000a283300000a0a2b71091f413215091f5a301006120328ac00000a283300000a0a2b57091f303229091f393024066f6800000a2d0c06725f0e0070283300000a0a06120328ac00000a283300000a0a2b290928ad00000a2c0e06725f0e0070283300000a0a2b13091f5f330e06120328ac00000a283300000a0a0817580c08076f6800000a3f5dffffff062a001b3002005a000000330000117e7800000a260272630e00706f1901000a6f1a01000a0a2b22066ff900000a74270000010b076f6f00000a282000000a2d09076f6f00000a0cde1d066f9800000a2dd6de110675420000010d092c06096f6500000adc142a082a000001100000020017002e45001100000000133004005c0000003400001102722f0e007003283300000a6f5200000a75270000010a062c02062a026f0601000a036f0101000a0a02066f0201000a26042c26040b160c2b1a07089a0d098e6918330c0609169a09179a6ffb00000a0817580c08078e6932e0062a133006006000000035000011026ff700000a6f1b01000a2d02142a026ff700000a6f1b01000a8d1800001b0a160b2b2c026ff700000a076f1c01000a0c0607188d470000012516086f6f00000aa22517086f1d01000aa2a20717580b07026ff700000a6f1b01000a32c6062a133005002c0000003600001102036f5300000a0a06282000000a2d0806284700000a2b01160b0203072517580b281e01000a6ffb00000a2a1b3002004a0000003700001102036f1901000a730801000a0a6f1a01000a0b2b13076ff900000a74270000010c06086f0f01000a076f9800000a2de5de110775420000010d092c06096f6500000adc066f1f01000a2a000001100000020013001f320011000000002e726b0e007080070000042aae0372db050070289000000a6f2001000a282101000a73e500000a027c08000004285100000a282201000a2a2e736b00000680090000042a620303d00800000228c000000a166fcc00000a732301000a2a56036f2401000a2c0b036f2401000a8e16fe032a162a1e036f2501000a2a56036f2601000a2c0b036f2601000a8e16fe032a162a1e036f2701000a2a6e0374040000026f0b0000066fe900000a72140f0070289e00000a2a520303027b10000004166fcc00000a732801000a2a720374040000026f0b000006027b110000046fce00000a289e00000a2a0042534a4201000100000000000c00000076322e302e35303732370000000005006c000000b01b0000237e00001c1c0000d818000023537472696e677300000000f43400002c0f0000235553002044000010000000234755494400000030440000340f000023426c6f620000000000000002000001571da209090e000000fa0133001600000100000075000000120000001600000075000000d4000000280100000c00000062000000370000000400000005000000050000001e000000010000000600000005000000090000001000000000009d0d0100000000000a008209ea120600650aea120600ff0aea1206008908691213000a1300000600e60afc0e0600850afc0e0600b80afc0e06002709fc0e0600070afc0e06006709fc0e0600b808fc0e0600e808fc0e0600d108fc0e06003b0afc0e06005608ea120600a515430e06002d08691206009d08691206004f0969120e000109bf110e001e07bf1106006e06430e0600161040020600820e430e06003515430e06007108430e0600130b430e12008f1435140e00260abf110e006d0e61130600cb0f430e0e006b0661130e00550c61130e003d0161130e00920361130e00ed0d61131600b216da0d16006d16da0d06009503430e0600fc00430e1a001c1664101600da10da0d1600b30fda0d0a001f10430e06002f0554140e00aa14611306003601cd02c3003112000006002801cd021a004b086410060025117f170e00470561130e00650ffa1506004e18fc0e06009a07430e06000b10fc0e06004610fc0e0e00dc03fa150a00ab01430e0600591754141200350f44030600680e430e06002212541416004209da0d06003b05430e16007404da0d1600c50ecb0c16004612cb0c06001501cd020600880c430e06001511430e0600c00f430e0e00d217bf1106007a0e430e06004801430e06007118400206002c1040021200ff1735140600ac10430e06002d17430e1a007111641006000701cd020a00300574101a005d0464100600cd1040020600e41040020600cd01430e0600c60c430e1a009c0564101a002a14cb0c0600e80f430e06001d0b430e06006a11430e06001f18430e0600300c7f170600fb10251806004a0e251806005305430e0e00580fd50f06003b10fc0e06001806fc0e06005a05430e0600e107fc0e06008d03430e0e00d203d50f06008f05400216001e0fda0d16005410da0d06007c14430e16000712cb0c16004011cb0c16003311cb0c16002c07cb0c0600fb01430e06002607cb1216004d17da0d00000000050200000000010001000001100095010000450001000100010010007f13000045000300070001001000ee090000710003000a0001001000b3090000100004000c0001001000d2090000100005000e000100100095090000100005000f0001001000e80e0000710006001100010010006714000045000600120001001000ef0e000045000700360001001000fc044a02450007003e0081011000ac02760d450007004400810110008d0dc40d450007005400030110000100000045000800680003211000bf020000450009006a00030110003800000045001000720003011000e70000004500110074000201000043070000fd00120076002100af032f0021009a0333000400e50513030100f70cc1080100920f130336009414c40831003402130306009603c80836000102cd0816001700d1081600a000e40816004e01f5081600c100080916006f0119091600d3012c0906005b07350906004b0d3a0906068c02c1085680f2153f0956802b0d3f095680170d3f09568021143f09502000000000860864150e0201005820000000008608d013910801006020000000008618581289080100782000000000c6001a1441070300bf2000000000c6005104cc000400f42000000000c6007c0c7800040088210000000096004c1343090400b622000000009600c7034b090800cd22000000008618581201000900d522000000008618581210000900e422000000008608d30578000a00ec22000000008618581250090a00fc22000000008608ec0ccc000c000423000000008618581210000c000d23000000008618581208070d001d230000000086087e0f78000f002523000000008618581201000f003023000000009600dc0c56090f00802300000000960089065c091000b0230000000096004d065c091100e023000000009600a50c390312000424000000009600fc03650914003024000000009600940e74091700cc24000000009600ab0e7d091800e4250000000096002c0b89091a00b026000000009600ef0b9b091e000828000000009600fb0baf0923005429000000009600180caf092800402b0000000096004916c2092d00c42b0000000096004d11ce092f00302d0000000096003d17e6093500002e0000000096003f04ef093600b82e0000000096001208fe093900802f000000009600ee06070a3a000430000000009600d806070a3c0088300000000096008102130a3e00ec30000000009600ee171f0a40002831000000009600e5043903420058320000000091000914280a44007c330000000096002304300a4800fc340000000096001104420a4c009435000000009600a4044e0a4e00b835000000009100c1045e0a52001936000000009100ef163004560058360000000096002a0274095800b4360000000096004a0c7409590054370000000096007e15660a5a009437000000009100b3147f065b004038000000009100430d9c005c00443900000000910082116f0a5d00b03900000000910017096f0a6000cd22000000008618581201006300a23a0000000091185e12770a6300ab3a00000000910016074b096300bf3a0000000096005902770a6400c73a0000000096006c02770a6400d03a0000000094000e0f7b0a64002c3c000000009400ec02800a65001c4000000000940069078f0a6a00c8410000000091007e05d6006c00cd22000000008618581201006e0074420000000086003913980a6e009c42000000008600cb149e0a6f0018430000000086000b05a70a71009743000000008600a407b30a7500c443000000008600d804ba0a7800cd22000000008618581201007c004444000000009600631761017c007c44000000009600fe0c61017f00e444000000009600360db40082007c45000000009600db0bc30a8400be4500000000960095189c008600d345000000009600200d300487000046000000009600580ec90a890068460000000096000518d00a8c00b0460000000096001c0ed90a8e00e046000000009600360ed90a90001047000000009600a407df0a920074470000000096002a0ed90a9500ac47000000009600740ce70a97008849000000009600390c61019800e849000000009600fe14ed0a9b00674a000000009600660d30049c00804a000000009600c113f40a9e00044b000000009600600bff0aa100184b000000009600720b0b0ba4006f4b0000000096009e0b160ba700844b0000000096009e0b210ba900c44b0000000096009e0b2d0bac00fc4b0000000096009e0bff0aae00244c0000000096008b16370bb1007c4c0000000096008b16420bb400304e00000000960035164d0bb700544e0000000096001913570bb900d04e000000009600ae0b680bbd008a50000000009600010e9c00bf00a450000000009600c605710bc0007c51000000009600fb05780bc300f45100000000960025167f0bc4005c52000000009600b3138c0bc700c852000000009600d30a950bc80000530000000096002d139d0bca0068530000000091185e12770acc00cd2200000000861858120100cc0074530000000083006800a80bcc00a0530000000091185e12770acd00cd2200000000861858120100cd00ac530000000083002000af0bcd00c553000000008300a900be0bce00db530000000083005701cb0bcf00e353000000008300ca00da0bd000f9530000000083007801e70bd1000154000000008300dc014107d200cd2200000000861858120100d3001d540000000083004d00f60bd300cd2200000000861858120100d4003254000000008300b2014107d40000000100db1700000200d41300000100bb0b00000100e70c00000200ec0700000300990c000004005f15000001009c0400000100e50500000100e50500000200f70c00000100e50500000100e50500000200920f00000100e70c000001006306000001009f0600000100701700000200f90f00000100701700000200f90f00000300101600000100bd0e000001000e02000002001702000001009603000002007c0400000300a80200000400ab05000001007c04000002007603000003006a0300000400a61100000500ef10000001000c0c000002007603000003006a0300000400a61100000500ef1000000100270c000002007603000003006a0300000400a61100000500ef10000001009603000002003304000001005d11000002007c04000003007603000004006a0300000500a61100000600ef1000000100bb0b00000100bb0b00000200480600000300960300000100e81100000100ca0600000200040700000100ca06000002000407000001001115000002009c1100000100a00202000200921100000100d50e00000200ef1100000100500b00000200400b00000300f30300000400ef1100000100010300000200630300000300491700000400860300000100a80200000200960300000100dd1700000200b00c00000300ef1100000400141700000100dd1700000200b00c00000300ef1100000400141700000100100e00000200221700000100010300000100010300000100bb0b00000100bb0b00000100bb0b00000100bb0b00000200d306000003009c1400000100bb0b00000200d306000003009c1400000100651200000100950d000001009f07000002002506000003005b0700000400950d00000500730f000001009f0700000200a602000001003206000002003e0600000100451300000100d91502000200df1400000100140502000200e211020003007c1102000400df1400000100d91500000200bb0b000003001a0500000100e211000002007c1100000300df1400000400bb0b000001006512000002004e0d00000300550d000001006512000002004e0d00000300550d00000100651200000200f90f00000100651200000200f90f00000100621500000100ac0700000200651200000100621500000200271700000300ef03000001006215000002003c12000001006215000002003c12000001006215000002003c1200000100d81700000200bb0b000003004f07000001006215000002003c1200000100531500000100bb0b00000200271700000300ef0300000100111500000100a60200000200bd0200000100010300000200491710100300090400000100aa1600000200480610100300910b00000100aa1600000200480600000300bb0b00000100970410100200910b000001009704000002000c0610100300910b00000100221700000200e70c00000100221700000200e70c10100300910b00000100d01600000200e70c00000300260800000100221700000200e70c00000300260800000100221700000200480600000100221700000200480600000300cb1800000400c30200000100bb0b00000200910b00000100bb0b00000100480610100200b81810100300c60700000100221700000100221700000200480610100300d41300000100aa1600000100aa1600000200ab0500000100e80200000200e60c00000100ce0b00000100db1700000100840000000100840000000100840000000100840000000100db1700000100db1700000100db17090058120100110058120500190058120100210058120a00310058121000390058121000410058121000490058121000510058121000590058121500610058121000690058121000710058121000790058121000810058120100990058121a00a10058120100a90058120100d90058122000f100581201000c00af032f000c009a0333008900581201001400df154a0014001a1454001c00df154a001c001a1454001400510464001c005104640089007c0c7800390277157f003902aa189c0049025812100051020d07a10059027c0c780061027c0c780039027715a600b100e703100039027715ad0069025813b400b900e617bb00c100581210007102b905780071027706c0007102b906c000b9008e15c500c9005615cc007102a205780039027715d00071024408010039026a15d600e1005812010069024f159c00f900b315e1000901b90dec000901bf0df0000901220bc000b9009306c00009015812f500b900a906c0001101220b780079025812fb0079029d0c02017902010407011101b3150d011101b90dec001101bf0d1c013902d31521016102090828011901bf0d4201890246014701610201104c011901581205002101b90dec002901b90dec003101581201002901220b78003101e50d100039026a1561014902581268012101220b700119026304760139019e0a7d01110158121000f90058121500f900b90dec00f900220bec0034005812f8013c00840bec003c00220b0e023400840bec003400220b0e0229015812010051010c082102910246152802440058123d02a102b4074302a102eb156302a902c01070022901581276021102010801001901b90dec001901220bcc003902ec0ccc001902f40d7800b1025812100059011f08ae026101b110cc006101a20fcc0019028804c4021902a2057800b9000908d402b9005812dc02b900a407e3023902a407f10269015c0df80269012903fe026901050305036901180305033902c51813037901ec0c160339026a151a030101581210007901220b200339025d0e780011017b183903f900c10b4403f90080104a03f900f5075303f900c40b53034c00581201003902e70b70033902a01475034c004003f80139028f0c7a03c902900e80034c00e516cc004c002e1286035400d9160e0254007617ec005101a205b40351015812ba03d9027816c103d102b315cb035101720bd2035101c513da035c002e12ee036400d9160e029901a205b403d1027b1801049901220b780001027617ec00a902c90b0100a102e91617042901b00d23041101bf152904f900bf15440339027b1830043902a4073604390219182003f102571847040103200254040103850c5a040903581201001103ba0c7104a10158120500e9027c0c7d01a101ec037804190309088604a90158128d048102cb159a0481027c0c7800810216129a048102b6119a043902c90b7a0339028f0cb60451021f05bb04b1015812010021035f0c100021038b0e0100b9014218d304b9017613d9046c0058123d02a102ac15f204740058123d027c0058123d0284002e12ee038c00d9160e022903a2057800b901f3056b053103a2057800c1016c0571052103fb070100c101c0129f05940058123d029c0058123d02a40058123d02ac002e12ee03b400d9160e02a10158120100a10171151606a10171151f064103f014280629039f132f06bc0058123d02d101a2057800d10185074406c90176074406a10171154a06c101b9057800a10171155206d90158120100d901490f5c0651039b17100051038b17780051036118cc005903fc1379065903ab177f063902010407013902211402015903b717840639026a158a064c0011189d063902e70bb306e901581201003902e70bc506e9014003cb06e9011118d0064101581210003902e30b700339022b0de6063902170de6063902da117800c900aa12f306c9008812f30619037c0c7d01c900eb13f306c900df13cc00c9007c12cc00c9009912cc0039026a15f706c9002615f306c9001c15cc00f10158120100f1014003080739021a140e0719029013240769032e122a070102d91630073901580a02013901ab0a080789001a1441073901170910001902c41778001902070e460731019616630731015f1646071902bb03690739022b0d02013902871830043902e70b88071902be168e073902d3159407d400581201001902f711bb0779039405c10721023517c8077903ac15d7072902d916bb07790397153007d4004003f80129027617ec008902780e9c00c1019707e00789025105f5078902f901fa07a103620eec00f9010c08ff0789023807070879029d0c300419022d132308a9032e122a076903e516cc006103d00b40081902220b780089027c0c4c08d40011189d065101130b65089901bf156e0841017b187508ec0058128908ec00d0139108ec0064150e02f400d0139108f40064150e02f4005812890808004c00a90808005000ae0808005400b30808005800b80802008102bd0812008d02a9081200a102a9081200ad02a9081200c102a90802000503bd0802000903bf0812001903a90821008300060f2e000b00ae082e001300170c2e001b00200c2e0023003f0c2e002b00480c2e0033006b0c2e003b00770c2e004300aa0c2e004b00bf0c2e005300ce0c2e005b00ce0c2e006300ce0c2e006b00d40c2e007300e80c41008300060f43007b00ae0860008b00ae0863008a00ae0880008b00ae0883009b000f0fa0008b00ae08c0008b00ae08e0009300ae08e0006200fe0ce00062000c0d00019300ae08000162001e0d03019b00290f23018a00ae0843018a00ae08a3010b00ae08c3017b00ae08e3017b00ae0803027b00ae0823027b00ae084002a300ae08400262002f0d6002a300ae088002a300ae08a002a300ae08a00262003d0da00262004c0dc002a300ae08c00262003d0dc00262004c0dc00262005d0de002a300ae08e0026200720de0026200830d0003a300ae0800036200980d00036200aa0d2003a300ae0820036200830d20036200bc0d20036200d10d4003a300ae0840036200bc0d6003a300ae088003a300ae08a003a300ae08c003a300ae08c0036200bc0de003a300ae08e0036200e80d0004a300ae0800046200f70d2004a300ae0820046200050e4004a300ae0840046200050e6004a300ae0860046200050e8004a300150e800462003f0e80046200530e80047a00660ec004a300ae080005a300ae082005a300ae084005a300ae08a005a300ae08a0056200900ea0057a009d0ec005a300ae08c0056200c30ec0057a00d00ee005a300ae08e0056200f70ee0069300ae0800079300ae08a00a0b00ae08c00a0b00ae08e00a0b00ae08000b0b00ae08400b0b00ae08400c0b00ae0837006a008900dc00e70014012f0151018201a001b90113027d029b02b702ca02eb020f032503570397030b043f0460047f0492049f04a604ac04bf047a0563066d069206a306a806af06b806bd06dc06ee06fd06170739074d0755075b0772079e070f0816082a08360847085108020001000400030005000400070005000000db17050c0000d4130a0c0000d7050f0c0000f00c130c0000820f0f0c02000100030002000200050002000b00070002000d000900020010000b00260042005c0075007c00f101fe01330269039003e503f803e0041c05380559056205a605c705e30504060d063806d9063e07b207e707ee077f089608048000001200030078076d070000000000004a020000020000000000000000000000a008b60200000000030005000000000000000000a008ba0700000000020000000000000000000000a008940200000000020000000000000000000000a008430e00000000020000000000000000000000a008da0d00000000030005000000000000000000a0086410000000000e0009000f000a0010000a0011000a0012000c00000000000400a1100100000004008d1000000000ab008a0200000000ad008a0200000000af008a0200000000b1008a0200000000b3008a0200000000b5008a0200000000bf008a02aa009c01aa000502c3005d02c5005d02aa00970235015d0271010d05c3002c0571014a057101b805c300d7057101f505c3004006c5004006be003407ae0034070000003c3e635f5f446973706c6179436c61737331325f30003c3e395f5f335f30003c53657475705265666c656374696f6e3e625f5f335f30003c3e635f5f446973706c6179436c617373345f30003c526567697374657246756e6374696f6e50726f633e625f5f30003c4765744b64624f76657272696465456c656d656e743e625f5f30003c3e685f5f5472616e73706172656e744964656e74696669657230003c3e395f5f335f31003c53657475705265666c656374696f6e3e625f5f335f31003c3e395f5f345f31003c526567697374657246756e6374696f6e50726f633e625f5f345f31003c3e635f5f446973706c6179436c617373345f31004e756c6c61626c6560310049456e756d657261626c65603100457175616c697479436f6d706172657260310049456e756d657261746f726031004c69737460310053716c496e74333200546f496e743332003c3e395f5f335f32003c53657475705265666c656374696f6e3e625f5f335f32003c3e395f5f345f32003c526567697374657246756e6374696f6e50726f633e625f5f345f32003c3e665f5f416e6f6e796d6f7573547970653060320046756e636032003c526567697374657246756e6374696f6e50726f633e625f5f3300496e743634003c3e395f5f345f34003c526567697374657246756e6374696f6e50726f633e625f5f345f3400546f496e743136003c3e39003c4d6f64756c653e0056657273696f6e410056657273696f6e42006765745f41534349490046726f6d415343494900584d4c5f5041545445524e0053797374656d2e494f0050524d4461746162617365434c5200496e7374616c6c4461746162617365434c5200556e696e7374616c6c4461746162617365434c520053706c6974434c5200540076616c75655f5f0053797374656d2e4461746100726f7744617461006b646200537472696e674c6962006d73636f726c6962003c3e630069734e756d657269630053797374656d2e436f6c6c656374696f6e732e47656e6572696300646f6300526567697374657246756e6374696f6e50726f630073726300436f6e7665727454696d6546726f6d55746300436f6e7665727454696d65546f5574630046696e6453797374656d54696d655a6f6e6542794964004164640053797374656d2e436f6c6c656374696f6e732e5370656369616c697a6564007372635569640070726f766964657255696400636c696e696343656e7465725569640064737455696400566f69640053716c47756964003c617474726962757465733e695f5f4669656c64003c743e695f5f4669656c6400417070656e644368696c640048656c6c6f576f726c64004462436f6d6d616e640053716c436f6d6d616e640053656e6400417070656e640077696c64636172640052656765785265706c616365007265706c6163650044656c6574654b44424f7665727269646500436f70794b44424f76657272696465006b64624f766572726964650047657446696c7465724f766572726964650047657448617368436f646500584e6f64650053656c65637453696e676c654e6f646500586d6c4e6f6465006b64624974656d4e6f6465006765745f506172656e744e6f6465006e6f6465006d657373616765004973446961676e6f736973436f6465496e53696e676c6552616e6765006973446961676e6f736973436f6465496e52616e67655f436f6d7061726552616e6765004973446961676e6f736973436f6465496e52616e676500446961676e6f73697352616e67650047657452616e67650072616e6765006c696b65006765745f4973417661696c61626c650049456e756d657261626c650049446973706f7361626c650053716c446f75626c6500546f446f75626c650052756e74696d655479706548616e646c65004765745479706546726f6d48616e646c6500437265617465417373656d626c7953514c46696c6500436f6d70696c6500584e616d65006765745f4e616d65006174747269627574654e616d65006765745f46756c6c4e616d650056616c6964586d6c4e616d65006765745f506172616d657465724e616d6500706172616d657465724e616d65004765744e616d65004669727374456c656d656e744e616d6500656c656d656e744e616d6500417373656d626c794e616d6500617373656d626c794e616d6500646c6c66696c656e616d650073637269707466696c656e616d6500436f6e766572744c6f63616c546f55544354696d650075746354696d650053716c4461746554696d65006765745f4c617374577269746554696d6500436f6e76657274555443546f4c6f63616c54696d65006c6f63616c54696d6500546f556e6976657273616c54696d65006765745f4372656174696f6e54696d65006461746574696d65006c696e6500436f6e7665727454696d65546f54696d657a6f6e6500436f6e7665727454696d65427954696d657a6f6e650074696d657a6f6e65006765745f50697065004c6f67506970650053716c50697065005f5479706500586d6c4461746154797065004368616e67655479706500436f6d706172655479706500636f6d70617265547970650061747472696275746554797065004d6170546f53716c54797065006765745f52657475726e54797065006765745f506172616d65746572547970650047657454797065007479706500436f6d7061726500636f6d706172650057686572650053797374656d2e436f7265007265706c616365537061636557697468556e64657273636f7265004d6574686f64426173650064617461626173650046616c736500436c6f736500446973706f736500547279506172736500537472696e67546f44617465004372656174650063726561746500446562756767657242726f777361626c6553746174650044656c657465005841747472696275746500436f6d70696c657247656e6572617465644174747269627574650041747472696275746555736167654174747269627574650044656275676761626c6541747472696275746500446562756767657242726f777361626c6541747472696275746500417373656d626c794b657946696c6541747472696275746500417373656d626c795469746c6541747472696275746500417373656d626c794b65794e616d654174747269627574650053716c50726f6365647572654174747269627574650052656d6f766541747472696275746500417373656d626c7954726164656d61726b41747472696275746500586d6c41747472696275746500446562756767657248696464656e41747472696275746500417373656d626c7944656c61795369676e41747472696275746500457874656e73696f6e4174747269627574650053716c5461626c65526567697374726174696f6e4174747269627574650053716c537472696e67526567697374726174696f6e4174747269627574650053716c586d6c526567697374726174696f6e4174747269627574650053716c526567697374726174696f6e41747472696275746500417373656d626c79436f6e66696775726174696f6e4174747269627574650053716c46756e6374696f6e41747472696275746500417373656d626c794465736372697074696f6e4174747269627574650048617341747472696275746500436f6d70696c6174696f6e52656c61786174696f6e7341747472696275746500417373656d626c7950726f64756374417474726962757465004765744174747269627574650053657441747472696275746500417373656d626c79436f7079726967687441747472696275746500496e6372656d656e7441747472696275746500417373656d626c79436f6d70616e794174747269627574650052756e74696d65436f6d7061746962696c6974794174747269627574650042797465006765745f56616c7565004765744b64624f7665727269646556616c756500757070657252616e676556616c7565006c6f77657252616e676556616c75650047657441747472696275746556616c75650053657441747472696275746556616c7565006765745f48617356616c75650064656661756c7456616c756500476574456c656d656e7456616c756500436f6e7665727456616c75650076616c7565006f705f547275650052656d6f7665006765745f4974656d4f6600436f756e744f66004c617374496e6465784f660047657448696465466c616700476574504544656661756c74466c61670064656661756c74466c616700476574526f7344656e79466c61670064656e79466c616700456e636f64696e6700476574426f756e646564537472696e670048617368537472696e670053716c537472696e67007365745f436f6e6e656374696f6e537472696e670054696d655370616e546f537472696e6700476574537472696e6700537562737472696e67006c6f670049734d617463680052656765784d617463680072616e67654869676800436f6d7075746548617368004d6174680053797374656d2e586d6c2e585061746800436865636b50617468007870617468006765745f4c656e677468006c656e677468005265706c61636546697273745374617274696e675769746800456e64735769746800426567696e73576974680053746172747357697468004765745374617274576974680049734d6f6e7468007069006f6c6456616c006e657756616c006765745f4c6f63616c00417265537472696e6773457175616c00694d65646963612e4672616d65776f726b2e5574696c00586d6c5574696c00696e7374616c6c0050524d4461746162617365434c522e646c6c006765745f4e756c6c006765745f49734e756c6c00694d65646963612e4672616d65776f726b2e586d6c0053797374656d2e586d6c004c6f6164586d6c0053716c586d6c006765745f4f75746572586d6c004973586d6c006765745f4974656d00636f6d706172654974656d0053747269704c6173744974656d004765744c6173744974656d0047657446697273744974656d0053797374656d0048617368416c676f726974686d0050617273655472696d006765745f4973456e756d0053716c426f6f6c65616e00546f426f6f6c65616e0054696d655370616e004f70656e004d696e00476574466f726d617474656450524d56657273696f6e00436f6d7061726550524d56657273696f6e0076657273696f6e00585061746845787072657373696f6e0072616e676553706563696669636174696f6e0053716c53656c66526567697374726174696f6e0053797374656d2e5265666c656374696f6e0053657475705265666c656374696f6e00586d6c417474726962757465436f6c6c656374696f6e004e616d6556616c7565436f6c6c656374696f6e007365745f436f6e6e656374696f6e004462436f6e6e656374696f6e0053716c436f6e6e656374696f6e00636f6e6e656374696f6e006765745f5461626c65446566696e6974696f6e007461626c65446566696e6974696f6e006765745f4c696e65506f736974696f6e00586d6c457863657074696f6e004170706c69636174696f6e457863657074696f6e0053797374656d2e446174612e436f6d6d6f6e00537472696e67436f6d70617269736f6e007061747465726e00436f6d70617265546f004d6574686f64496e666f0046696c65496e666f0054696d655a6f6e65496e666f0046696c6553797374656d496e666f004d656d626572496e666f00506172616d65746572496e666f00586d6c4e616d65644e6f64654d61700053797374656d2e586d6c2e4c696e710053797374656d2e4c696e71006f705f426974776973654f72003c617474726962757465733e6a5f5f54506172003c743e6a5f5f545061720043686172006765745f4c696e654e756d6265720043726561746552656164657200537472696e6752656164657200586d6c5265616465720054657874526561646572006b646250726f7669646572005348413143727970746f5365727669636550726f76696465720049466f726d617450726f766964657200537472696e674275696c64657200586d6c436173654f7264657200586d6c536f72744f7264657200476574446973706c61794f7264657200646973706c61794f72646572004275666665720058436f6e7461696e65720075707065720052656d6f766543686172616374657200706172616d657465720064656c696d69746572006b6462436c696e696343656e7465720049734c6574746572004d6963726f736f66742e53716c5365727665722e53657276657200546f4c6f776572006c6f77657200616e73776572006c6f6f6b466f72004372656174654e6176696761746f720058506174684e6176696761746f72004973536570617261746f720049456e756d657261746f7200476574456e756d657261746f7200736570657261746f720058506174684e6f64654974657261746f72002e63746f72002e6363746f72007374720053797374656d2e446961676e6f7374696373006765745f5365636f6e6473006765745f546f74616c5365636f6e6473006765745f4d696c6c697365636f6e6473006765745f546f74616c4d696c6c697365636f6e6473004765744d6574686f64730053797374656d2e52756e74696d652e496e7465726f7053657276696365730053797374656d2e52756e74696d652e436f6d70696c6572536572766963657300446562756767696e674d6f64657300476574536f727465644368696c644e6f6465730053656c6563744e6f6465730053706c697452616e6765730072616e6765730044656c65746546696c65730047657446696c65730053797374656d2e446174612e53716c54797065730047657454797065730053746f72656450726f63656475726573006765745f4174747269627574657300476574437573746f6d41747472696275746573004765744174747269627574657300436f707941747472696275746573006765745f61747472696275746573006765745f4d696e75746573006765745f546f74616c4d696e757465730052656164416c6c427974657300436f6d70617265446961676e6f73697300457175616c7300436f6e7461696e7300457874656e73696f6e730053797374656d2e546578742e526567756c617245787072657373696f6e730053797374656d2e436f6c6c656374696f6e730055736572446566696e656446756e6374696f6e7300537472696e6753706c69744f7074696f6e730052656765784f7074696f6e7300706f73006765745f43686172730053716c43686172730052656d6f76654e6f6e446174654368617261637465727300476574456e64696e674368617261637465727300656e64696e674368617261637465727300476574506172616d6574657273004765745175657279506172616d657465727300706172616d6574657273006765745f486f757273006765745f546f74616c486f757273004174747269627574655461726765747300456c656d656e747300457869737473006765745f446179730064617973006765745f7400436f6e63617400417070656e64466f726d6174005472795f50617273655f466c6f6174005375627472616374006765745f556e6465726c79696e674f626a6563740053656c656374006f705f496d706c69636974006f705f4578706c6963697400497344696769740053706c6974006c696d6974006765745f44656661756c740046697273744f7244656661756c740053797374656d2e446174612e53716c436c69656e74007265706c6163656d656e740058456c656d656e74004765744368696c64456c656d656e7400437265617465417070656e64456c656d656e74004765744b64624f76657272696465456c656d656e7400437265617465456c656d656e7400586d6c456c656d656e7400585061746853656c656374456c656d656e7400476574456c656d656e74006765745f446f63756d656e74456c656d656e7400656c656d656e7400586d6c446f63756d656e74006765745f4f776e6572446f63756d656e7400646f63756d656e74006765745f43757272656e74006765745f436f756e74006973446961676e6f736973436f6465496e52616e67655f436f6d706172654279526f6f7400636f6d706172654279526f6f7400726f6f7400737461727400436f6e7665727400416464536f72740053616665586d6c436173740064737400586d6c4e6f64654c6973740041727261794c697374005265706c616365466972737400696e707574004d6f76654e6578740053797374656d2e54657874006765745f436f6d6d616e6454657874007365745f436f6d6d616e64546578740052656164416c6c54657874005772697465416c6c54657874006765745f496e6e6572546578740053716c436f6e746578740072616e67654c6f77006765745f4e6f770053706c6974434c525f46696c6c526f7700526567657800546f47756964417272617900546f417272617900546f4368617241727261790053797374656d2e53656375726974792e43727970746f67726170687900476574457865637574696e67417373656d626c7900426c6f636b436f707900457865637574654e6f6e5175657279004469726563746f7279006f705f457175616c697479006f705f496e657175616c6974790049735472696d6d6564537472696e67456d7074790049734e756c6c4f72456d7074790072657475726e4e756c6c466f72456d70747900736f727450726f706572747900003f7b007b002000740020003d0020007b0030007d002c002000610074007400720069006200750074006500730020003d0020007b0031007d0020007d007d00005d5400680065002000700061007400680020006d007500730074002000620065002000730070006500630069006600690065006400200061006e0064002000630061006e006e006f007400200062006500200065006d00700074007900006554006800650020006400610074006100620061007300650020006d007500730074002000620065002000730070006500630069006600690065006400200061006e0064002000630061006e006e006f007400200062006500200065006d00700074007900003d440065006c00650074006500460069006c006500730020007b0030007d002c0020007b0031007d002c0020007b0032007d002c0020007b0033007d0000137b0030007d002d002a002e007b0031007d000107420041004b000007540052004e00004146006f0075006e00640020007b0030007d002000660069006c00650073002000770069007400680020007000610074007400650072006e0020007b0031007d00004743006800650063006b0069006e0067002e002e002e002000460069006c0065006e0061006d0065003a0020007b0030007d00200044006100740065003a0020007b0031007d00002d440065006c006500740069006e0067002000660069006c0065006e0061006d0065003a0020007b0030007d00002d480065006c006c006f00200057006f0072006c0064002000660072006f006d00200043004c0052003a0020000031540068006500200070006100740068002000630061006e006e006f007400200062006500200065006d0070007400790000377b0030003a00440032007d002e007b0031003a00440032007d002e007b0032003a00440034007d002e007b0033003a00440034007d00000f670065006e006500720069006300002d540068006500200043006c0069006e0069006300430065006e00740065007200200058004d004c0020002800002b2900200063006f0075006c00640020006e006f00740020006200650020006c006f00610064006500640000352e002f004f0076006500720072006900640065002f007b0030007d005b0040005500690064003d0022007b0031007d0022005d000009480069006400650000255400680065002000500072006f0076006900640065007200200058004d004c002000280000332e002f004f0076006500720072006900640065002f00700065005b0040005500690064003d0022007b0030007d0022005d000017440065006600610075006c00740046006c006100670000352e002f004f0076006500720072006900640065002f0072006f0073005b0040005500690064003d0022007b0030007d0022005d000011440065006e00790046006c0061006700001944006900730070006c00610079004f00720064006500720000272e002f002a002f007b0030007d005b0040005500690064003d0027007b0031007d0027005d00011d3c007b0030007d003e007b0031007d003c002f007b0030007d003e00000b6c006f00630061006c00001b5400680065002000740069006d0065007a006f006e0065002000001d200077006100730020006e006f007400200066006f0075006e00640000795400680065002000640065006c0069006d00690074006500720020006d00750073007400200062006500200061002000730069006e0067006c00650020006300680061007200610063007400650072002c002000620075007400200069007400730020006c0065006e006700740068002000690073002000003f59006f00750020006d0075007300740020007300700065006300690066007900200061002000760061006c00690064002000730072006300550069006400003f59006f00750020006d0075007300740020007300700065006300690066007900200061002000760061006c0069006400200064007300740055006900640000192e002f002a005b00400055006900640020003d0020002700010527005d000107550069006400003959006f00750020006d0075007300740020007300700065006300690066007900200061002000760061006c006900640020007500690064000005580032000003200000074a0061006e00000746006500620000074d0061007200000741007000720000074d006100790000074a0075006e0000074a0075006c00000741007500670000075300650070000009530065007000740000074f006300740000074e006f0076000007440065006300000f4a0061006e007500610072007900001146006500620072007500610072007900000b4d006100720063006800000b41007000720069006c0000094a0075006e00650000094a0075006c007900000d4100750067007500730074000013530065007000740065006d00620065007200000f4f00630074006f0062006500720000114e006f00760065006d00620065007200001144006500630065006d00620065007200002349004e00560041004c00490044002000410054005400520049004200550054004500002f43006f006e007400650078007400200043006f006e006e0065006300740069006f006e003d007400720075006500003145006e0075006d00650072006100740069006e00670020004d006500740068006f0064007300200066006f0072002000002549006e007300740061006c006c004400610074006100620061007300650043004c005200002955006e0069006e007300740061006c006c004400610074006100620061007300650043004c0052000023200020007b0030007d0020004f0062006a006500630074003a0020007b0031007d000011440072006f007000700069006e00670000114300720065006100740069006e006700007b4900460020004500580049005300540053002800530045004c0045004300540020002a002000460052004f004d0020007b0032007d0020005700480045005200450020007b0033007d0020003d00200027007b0031007d00270029002000440052004f00500020007b0030007d0020005b007b0031007d005d000111460055004e004300540049004f004e000009500052004f004300003f5b0049004e0046004f0052004d004100540049004f004e005f0053004300480045004d0041005d002e005b0052004f005500540049004e00450053005d0000255b007300790073005d002e005b00500072006f0063006500640075007200650073005d00001d5b0052004f005500540049004e0045005f004e0041004d0045005d00000d5b004e0061006d0065005d00002343005200450041005400450020007b0030007d0020005b007b0031007d005d00200000052000280000052c002000001140007b0030007d0020007b0031007d00000529002000001b2000520045005400550052004e00530020007b0030007d002000003120005700490054004800200045005800450043005500540045002000410053002000430041004c004c00450052002000003f2000410053002000450058005400450052004e0041004c0020004e0041004d00450020007b0030007d002e005b007b0031007d005d002e007b0032007d00000d200020002000200020002000003545007800630065007000740069006f006e0020007700680069006c006500200065007800650063007500740069006e00670020000007620069007400000778006d006c00001b6e00760061007200630068006100720028006d0061007800290000136e007600610072006300680061007200280000032900001b6e00760061007200630068006100720028003200350035002900000769006e007400000b66006c006f006100740000116400610074006500740069006d006500002175006e0069007100750065006900640065006e0074006900660069006500720000156e00630068006100720028007b0030007d00290000076d006100780000177400610062006c006500200028007b0030007d00290000135400680065002000540079007000650020000055200064006f006500730020006e006f007400200068006100760065002000610020006d0061007000700069006e0067002000530051004c0020006d0061007000700069006e006700200065006e007400720079000015250044004c004c00420059005400450053002500000530007800000d7b0030003a00780032007d0000255200650070006c006100630065006d0065006e007400200074006500780074003a002000001f20006e006f007400200066006f0075006e006400200069006e003a00200000134d006f0064006900660069006500640020000063540068006500720065002000730068006f0075006c00640020006f006e006c007900200062006500200061002000730069006e0067006c00650020002d00200069006e00730069006400650020007400680065002000720061006e0067006500200001056d007300000930002e00300030000003730000033a0000032e0000076d0069006e00000968006f0075007200000764006100790000052f002f0000032f000023540068006500200069006e0069007400690061006c0020006e006f006400650020000049200064006f00650073006e002700740020006d0061007400630068002000740068006500200072006f006f00740020006f0066002000740068006500200070006100740068002000015349006e00760061006c00690064002000780070006100740068003a002000540068006500200061007400740072006900620075007400650020005d0020006900730020006d0069007300730069006e006700000b200061006e0064002000005949006e00760061006c00690064002000780070006100740068003a002000540068006500200061007400740072006900620075007400650020006e0061006d00650020006900730020006d0069007300730069006e00670000052e002f0000034000000100033100000b660061006c00730065000009740072007500650000094e0055004c004c0000035f0000072e002f002a000080a75e005c003c007b0031007d0028003f003c0078006d006c005400610067003e005c0077002b0029002800280028005c0077007c005c00570029002a005c003e007b0031007d0028003f003c0064006100740061003e002e002a0029005c003c007b0031007d002f007b0031007d005c006b003c0078006d006c005400610067003e0029007c0028005c0073002a002f007b0031007d00290029005c003e007b0031007d0024000017720065007400750072006e00760061006c00750065000037598697367f7046b68e53fc191cf87600032000010420010108052001011115042001010e042001010205200101114905200101116908151208021300130103061300030613010a07011512080213001301071512811901130009000015128119011300072002021300130007151281190113010520010813000a070413001300130113010213000320000e0213010900030e1281210e1d1c12070912590e1d0e115d1d0e081261115d1165040001020e04000012590600020e0e1d1c0600030e0e1c1c0600021d0e0e0e040000115d042000115d0620011165115d032000080500020e0e1c0500020e0e0e040701117d050001117d02040701115d03200002040611808505200101115d062002010e1175042001020e0520020e0e0e0600011180890e0707031d0e1d080804061180890620011d0e1d03060002020e100812070e1d0e1d0e080808080808080808080808040611808d040001080e04200108080f07050e12809912809d1280811180a10600030e0e0e0e072002010e1280810520001180a106200112810d0e0420010e0e1907090e0212809912809d1280811180a112809912809d128081030a01021807080212809912809d1280811180a112809912809d12808137070d151180a5010212809912809d1280811180a1151180a50106151180a50106151180a5010212809912809d128081151180a50106117d06151180a5010205200101130006151180a50106080a01151180a5010604200013000d070412381280a91280ad1280950600011280a90e0a20001512814d011280a909151280f1021280a902052002011c18191001021512814d011e001512814d011e00151280f1021e0002050a011280a90c1001011e001512814d011e000520001280ad062001011280ad1907090e0812809912809d1280811180a112809912809d128081030a01081207080e0808081280991280ad1280951280b10800011280ad12815d0c07040e12809d1280ad12809505200012810d090704115d1180850e08070002020e10115d0620030108080807000208115d115d0507011280b5060003080e0e020500001280b50600011280b50e090002115d115d1280b50307010e02060e0320000a0500020e1c1c0420001d0313070b122c0e117d117d117d1d0e080e0e0e1d030a0002117d11808911808905000102117d080002117d117d117d0306117d110705151280c1010308151180c50103030206151280c10103042001080304200103080520020e0808050002080808092000151180c501130006151180c501031c07071280a91280a91280a91280a91180a1151280c9011280cd1280cd052000128169062001011281690900021280a91281550e0600011281690e072002011281691c0a20001512814d011280cd081512814d011280cd092000151280c901130008151280c9011280cd090002021281691281690b07031280a91280a91180a10b100101081512814d011e000500001280950600010e118089050002020e0e080003080e0e1181710707021d051180890c00050112817d0812817d08080500001281810520010e1d051007071d031d051d051280d111808908080620011d051d050620011280d10e0607020d1180d5060002020e100d042001010d0707050e0e0e080304000102030607031d0e080e050703080808090707080808080808080420010e08030000021307041280d91280dd151280c9011280e11280e10500001280dd0620001d1280e111151280f1021280e1151208021280e11d1c1a1002021512814d011e011512814d011e00151280f1021e001e010e0a021280e1151208021280e11d1c0f151280f102151208021280e11d1c020b0a01151208021280e11d1c11151280f102151208021280e11d1c1280e10e0a02151208021280e11d1c1280e1081512814d011280e108151280c9011280e10520001281990800011280e111819d24070c1240128081151280c9011280e51280e51280d1021d1280e9081244121012101280ed0620001d1280e511151280f1021280e5151208021280e51d1c0e0a021280e5151208021280e51d1c0f151280f102151208021280e51d1c020b0a01151208021280e51d1c11151280f102151208021280e51d1c1280e50e0a02151208021280e51d1c1280e5081512814d011280e508151280c9011280e50820021280d10e1d1c0820031280d10e1c1c0620001d1280e90820021d1c1280e10207151280f1021c02030a011c0520001280e10720021280d10e1c0920041280d10e1c1c1c062001011280d90907041214081214121c0b07060e1280d10e1d0508050500011d050e0400010e0e050002010e0e0700040e0e0e0e0e0a07030808151280c101030520001d13000407011d0e060703031d030803070108042001080e04070208080707031280f50808052002080e08042001081c08200112817d1280e1021d0e0907031d0e1d1180a108072002020e1181710407020d080320000d0500010e1d1c0a07041280f91d0e081d0e052002010e0e080003020e0e1181710c07041281011281050e1281090520001281b10520001281010320001c040a011e000407011e00021e00042001021c06200112809d0e07070212809d1e0005070112809d07070312809d0e0805200012809d08200112810d12810d15070d12809d1d0e080e12809d0e0e08081d0e080e0e0520020803080520001280990920021d0e1d0e1181b9130704151280c10112809d12811112811512809d08151280c10112809d0520001281bd0620011281110e0e2005011c1181c11181c50e1181c90820011281151281110600011280e10e06151180a5010806151180a5010d0400010d0e040001060e0700021c1280e10e0700021c1c1280e10607040e0e08030c070412810112809d0e1281090620011281d50e0b070412809d1d1d0e081d0e0907031d1d0e08128105062001128105080407020e080400010e08130704151280c10112809d12810112809d1281090820011280cd1281690600010e1280cd090002021180a11180a109151208021280e11d1c0720020113001301042000130109151208021280e51d1c08b77a5c561934e0890400000000040100000004020000000403000000010101000206080306117504061180910306123c1206151280f1021280e1151208021280e11d1c1006151280f102151208021280e11d1c021206151280f102151208021280e11d1c1280e11006151280f102151208021280e51d1c021206151280f102151208021280e51d1c1280e50806151280f1021c0204061280e104061280e903061148070004010e0e0208040001010e052002010e08050001117d0e0800011180851180850e00031180891180891180891180890800011180891180890b000211808d118089118089110004118089118091118089128095118089130005117d118089118091118091128095128095120005117d117d1180911180911280951280950b000212809511809112809517000611808d11808d1180891180911180911280951280950800011280951180890e00031280951280951180891180a10800011180851180890b00021180851180851180890b00021280b91180891280bd080002011c10118089070004020e0e020e1100041280951280951180911280951180910b00021280951280951180910f0004117d118089118089118089117d070004020e0e0e020800011180d511808907000301100e08080300000104000101020e0005011280e10e1280e1021280d90800020e1280e112710520011d0e0e08200201100e101d030b2004010e100e100e101d03062003080e0e02082004020e0e1d030e050002080e0e0600030e0e03030800021d1180a10e030500020e0e03070003020e0e11480500010e11650600011280f90e0a00030112809d12809d020b1001031e0012809d0e1e000a1001030112809d0e1e000a1001021e0012810d1e000b1001031e0012810d0e1e00091001021e0012809d0e0a000312809d1280990e020a000312809d12809d0e0209000212809d12809d0e100004151280c10112809d12809d0e0e02081001021e000e1e000600030e0e02020600010e12809d0c000312809d12809d0e1d1d0e0800011d1d0e12809d0700020112809d0e0a00021d12809d1280990e062001021280a90e2001151208021280e11d1c1280e10c200102151208021280e11d1c0e20011280e1151208021280e11d1c0c200102151208021280e51d1c0e20011280e5151208021280e51d1c0e2001151208021280e51d1c1280e5042800130004280013010328000e032800080801000800000000001e01000100540216577261704e6f6e457863657074696f6e5468726f7773010801000200000000002201001d417072696d61204d65646963616c20536f6674776172652c20496e632e00000b010006417072696d6100003201002dc2a92032303035202d20323031392c20417072696d61204d65646963616c20536f6674776172652c20496e632e00001401000f417072696d61e284a2207631382e3300000e010009446576656c6f70657200000501000000001301000e50524d4461746162617365434c5200001501001053514c20434c5220666f722050524d2e00000d01000470617468000400000000110100086461746162617365000100000000100100076d657373616765a00f000000000d01000470617468a00f000000000e010005696e707574ffffffff0000100100077061747465726effffffff00001401000b7265706c6163656d656e74ffffffff00001001000776657273696f6effffffff00001401000b52657475726e56616c7565ffffffff00001101000856657273696f6e412000000000001101000856657273696f6e422000000000001401000b6b64624974656d4e6f6465ff00000000001601000d6174747269627574654e616d65ffffffff00000e01000576616c7565ffffffff00000d0100046e616d65ff00000000000f010006616e73776572ff00000000002901000100540e1146696c6c526f774d6574686f644e616d651053706c6974434c525f46696c6c526f771301000a706172616d6574657273ffffffff00001201000964656c696d697465720100000000002901000b72657475726e76616c756518506172616d65746572204e5641524348415228343030302900000c010003737263ffffffff00002501000b72657475726e76616c756514726573756c74204e56415243484152284d41582900000c0100037372630004000000002601000b72657475726e76616c756515726573756c74204e5641524348415228313032342900000e01000576616c7565ff000000000008010000000000000019010040000000010054020d416c6c6f774d756c7469706c650108010004000000000000000000000084f8fb5d00000000020000001c010000d0a70000d0890000525344533ea4d00dd5b4be418af1d02765cc131001000000443a5c54435f576f726b4469725c346135666265303132666139323739355c4461746162617365434c525c6f626a5c52656c656173655c50524d4461746162617365434c522e7064620000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000014a9000000000000000000002ea9000000200000000000000000000000000000000000000000000020a90000000000000000000000005f436f72446c6c4d61696e006d73636f7265652e646c6c0000000000ff2500200010000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000100100000001800008000000000000000000000000000000100010000003000008000000000000000000000000000000100000000004800000058c00000120400000000000000000000120434000000560053005f00560045005200530049004f004e005f0049004e0046004f0000000000bd04effe00000100030012006d077807030012006d0778073f000000000000000400000002000000000000000000000000000000440000000100560061007200460069006c00650049006e0066006f00000000002400040000005400720061006e0073006c006100740069006f006e00000000000000b00472030000010053007400720069006e006700460069006c00650049006e0066006f0000004e03000001003000300030003000300034006200300000003a001100010043006f006d006d0065006e00740073000000530051004c00200043004c005200200066006f0072002000500052004d002e00000000005c001e00010043006f006d00700061006e0079004e0061006d0065000000000041007000720069006d00610020004d00650064006900630061006c00200053006f006600740077006100720065002c00200049006e0063002e00000046000f000100460069006c0065004400650073006300720069007000740069006f006e0000000000500052004d004400610074006100620061007300650043004c005200000000003e000f000100460069006c006500560065007200730069006f006e0000000000310038002e0033002e0031003900310032002e0031003900300031000000000046001300010049006e007400650072006e0061006c004e0061006d0065000000500052004d004400610074006100620061007300650043004c0052002e0064006c006c00000000007e002d0001004c006500670061006c0043006f0070007900720069006700680074000000a9002000320030003000350020002d00200032003000310039002c00200041007000720069006d00610020004d00650064006900630061006c00200053006f006600740077006100720065002c00200049006e0063002e000000000044000e0001004c006500670061006c00540072006100640065006d00610072006b0073000000000041007000720069006d006100222120007600310038002e00330000004e00130001004f0072006900670069006e0061006c00460069006c0065006e0061006d0065000000500052004d004400610074006100620061007300650043004c0052002e0064006c006c00000000002e0007000100500072006f0064007500630074004e0061006d0065000000000041007000720069006d0061000000000042000f000100500072006f006400750063007400560065007200730069006f006e000000310038002e0033002e0031003900310032002e0031003900300031000000000046000f00010041007300730065006d0062006c0079002000560065007200730069006f006e000000310038002e0033002e0031003900310032002e00310039003000310000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000a000000c00000040390000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000000060180000000202003082185306092a864886f70d010702a082184430821840020101310b300906052b0e03021a0500304c060a2b060104018237020104a03e303c3017060a2b06010401823702010f3009030100a004a20280003021300906052b0e03021a05000414b1be2f6ecf827fb07f469ec308379ad3403eaa82a082130730820414308202fca003020102020b0400000000012f4ee152d7300d06092a864886f70d01010505003057310b300906035504061302424531193017060355040a1310476c6f62616c5369676e206e762d73613110300e060355040b1307526f6f74204341311b301906035504031312476c6f62616c5369676e20526f6f74204341301e170d3131303431333130303030305a170d3238303132383132303030305a3052310b300906035504061302424531193017060355040a1310476c6f62616c5369676e206e762d7361312830260603550403131f476c6f62616c5369676e2054696d657374616d70696e67204341202d20473230820122300d06092a864886f70d01010105000382010f003082010a028201010094ef65f8b5579fa0530d3406eb091fb747186acbf05be4ff27a534d1f7891abf9eb1cd12416e66d481a0858b645a462f99a08d77b1e2bc5cdd22d76a67d0bbe8ca74de8b4f0db052e5905beb470ef1e79f9c0b90653e17963045726d39a11736cab9a08c1b4f0819f68131ad6116a462e6b4409ec3fcfb95f6fbb52e958198e0efc5ebd802597877f7aae3526b509129c5fcf7cd9365d2606122f206fb32dd1651fa0efd8a30f01709a7bbf304aeab90e76cdf7aa9f4efc462275f6f996d3874aa118bdadfc7144ce985b2ecc27d4a268fe756baa6e0cf92538074f403ec68b260bc842000831ba1eeb47405c1298e62d047b1faf053cc18f92e3bf9707eb4250203010001a381e53081e2300e0603551d0f0101ff04040302010630120603551d130101ff040830060101ff020100301d0603551d0e0416041446d83effdce3beff83e6f4859bb0dd6ad614a9c130470603551d200440303e303c0604551d20003034303206082b06010505070201162668747470733a2f2f7777772e676c6f62616c7369676e2e636f6d2f7265706f7369746f72792f30330603551d1f042c302a3028a026a0248622687474703a2f2f63726c2e676c6f62616c7369676e2e6e65742f726f6f742e63726c301f0603551d23041830168014607b661a450d97ca89502f7d04cd34a8fffcfd4b300d06092a864886f70d010105050003820101004e5e56901e46b4d94931f3bb1739281bc216ddfd41dc0905049b6fb2a29ad6992e40990055b5ea3fa52076d38634d417cc553ac782eeefa8babcd8069f1550dfcd167b523a02d7191afdaff0785ce04bc518df3a241edaacb8a95804020730dbb0125efe31bef00448f4f070f83a5e5683cf3dfb0dbcf4c5ed979db9d4dba52784e3389b8ba735864420a43b6da46a0ba183fd28ebdaef28f6cc885dfb0a3b00abe021ebe22f356c0f8e344597eba2f79933357ecb9a8abb454de73f9fc2d98afa65b26ec77e65ffe892e12c31a2f7b02736488f266f3bee4d761f79c3e57f9635bc2d0ecc01b08e7fff518080a792d4b34446648c874f166307314b63b0dff33082049f30820387a00302010202121121d699a764973ef1f8427ee919cc534114300d06092a864886f70d01010505003052310b300906035504061302424531193017060355040a1310476c6f62616c5369676e206e762d7361312830260603550403131f476c6f62616c5369676e2054696d657374616d70696e67204341202d204732301e170d3136303532343030303030305a170d3237303632343030303030305a3060310b3009060355040613025347311f301d060355040a1316474d4f20476c6f62616c5369676e20507465204c74643130302e06035504031327476c6f62616c5369676e2054534120666f72204d532041757468656e7469636f6465202d20473230820122300d06092a864886f70d01010105000382010f003082010a0282010100b017aea2d3b60430561e580fb1ed55a4d654cbd8f6733aec5d5eab25fd36a5fa84c36140c546b559523b42a22e5f136210a95be673d69225b17d23e306b3873a0e43f0d7008953a2113152286e5d40723cf20977a7499297d46c90a076a7fdb8dcb39df207602c4f5898006bd31554e0faddff802c5f18a698ffd4abeca14559b22e6f625de0d919ac8b579ca8262bd917a510d247081a702c338b7f68802ab5a15d6bdd8d02022903aa7c37bbbb294e3d5393b3a6fa8fd25893154cb92dab80a3a325fbaff70864b07a440f5c10d75f6137aa4e6bd3d253259d8273fa2cf972b0a919392a50faa9d03c3acae85beff55f51f4f90ad99735de6a85e6230442af0203010001a382015f3082015b300e0603551d0f0101ff040403020780304c0603551d2004453043304106092b06010401a032011e3034303206082b06010505070201162668747470733a2f2f7777772e676c6f62616c7369676e2e636f6d2f7265706f7369746f72792f30090603551d130402300030160603551d250101ff040c300a06082b0601050507030830420603551d1f043b30393037a035a0338631687474703a2f2f63726c2e676c6f62616c7369676e2e636f6d2f67732f677374696d657374616d70696e6767322e63726c305406082b0601050507010104483046304406082b060105050730028638687474703a2f2f7365637572652e676c6f62616c7369676e2e636f6d2f6361636572742f677374696d657374616d70696e6767322e637274301d0603551d0e04160414d4a2844a385a187fba4f3050bd9dd57a87d609f7301f0603551d2304183016801446d83effdce3beff83e6f4859bb0dd6ad614a9c1300d06092a864886f70d010105050003820101008fa91a916d04a637200e8396de23d36b6e1f6edd643d682122b5f84736698ee1a545c724a222b72909cc545aaec6bccd638eb33d5048e5b4ccaecd928d9e288b134a11aabda3efd3b236fcb4a172bf6d9763798c44bc702f7ef3bcdd8253ab1af6ebfa1c97bcb6379ca41c30bcabbc2d4736df922003e871c658f675059a34f00b595a824434aa80e42f84f6475d96c9b6caca9db7a6bae450d3d437b8ba200ed0d3922a5bc459bba16ddb3cce449dc1382aade38dbdcd09771a10be670a02366488b9b31b26eee79e60c446a8bc61336ccf4eb99cb96af09f37feb53d4f9ad34dffde208e4e97a6fd9f09bc4dca1876c9b04d8550f280d21d06f5580407b118308204eb308203d3a0030201020210606ad8b4a778f67ffdb28ad68e0bad39300d06092a864886f70d01010b0500307f310b3009060355040613025553311d301b060355040a131453796d616e74656320436f72706f726174696f6e311f301d060355040b131653796d616e746563205472757374204e6574776f726b3130302e0603550403132753796d616e74656320436c61737320332053484132353620436f6465205369676e696e67204341301e170d3139313032383030303030305a170d3231313130373233353935395a308182310b3009060355040613025553310e300c06035504080c0554657861733113301106035504070c0a436172726f6c6c746f6e31263024060355040a0c1d417072696d61204d65646963616c20536f6674776172652c20496e632e3126302406035504030c1d417072696d61204d65646963616c20536f6674776172652c20496e632e30820122300d06092a864886f70d01010105000382010f003082010a02820101009ce3059aca19efd9dfa5b86330dc408944950f13ae3031ae5d7392b6ffd5a42fa7d3db54134f02d38362b611ecb94ab025c0edcba5d57c660cdf40f8ffe1c3ff2d9941fff033d2533ae4312b6f334cec9b33bbf0f18507f09bfcd0eea48a77fb60ab97db6c6699abbc704bb43d251eeafe6f7045e0a5a8809da99df769ee2236a9231817f21c6fb920035fe3f7149fa06c2dc77d961bcdb5376e359235d79b1ebff942e94ac2dad75d70c8f8af998457ec31cfac0621e5a121b2e86a283cb5d46333847897ad76b2d96d1f1e38b7c110a5c5aef93b61316a9feff7eb77a96bfc4bdada56d4ffbb82a3310d59bf2352cf5f6938b97022a646fcbae7ca1815a0e10203010001a382015d3082015930090603551d1304023000300e0603551d0f0101ff040403020780302b0603551d1f042430223020a01ea01c861a687474703a2f2f73762e73796d63622e636f6d2f73762e63726c30610603551d20045a30583056060667810c010401304c302306082b06010505070201161768747470733a2f2f642e73796d63622e636f6d2f637073302506082b0601050507020230190c1768747470733a2f2f642e73796d63622e636f6d2f72706130130603551d25040c300a06082b06010505070303305706082b06010505070101044b3049301f06082b060105050730018613687474703a2f2f73762e73796d63642e636f6d302606082b06010505073002861a687474703a2f2f73762e73796d63622e636f6d2f73762e637274301f0603551d23041830168014963b53f0793397af7d83ef2e2bcccab7861e7266301d0603551d0e04160414a05a52b160ae709e120d9ce61c2aa337a8963e88300d06092a864886f70d01010b050003820101002e951e9b1773b4e59c4d02466e1d1928d12b22fcee9c6b553842737aa92bcba63c7cc20d00f1c744c49a604a6eb863af82cbefd3107c3ca0023070b7b99748e655c0757eeb43e662a32f99d57c9c0aa4a15641d04ea409f4016cc2b247e7f4dce5115785e135cd84a06687705659ca6da15a636899de2c71bede47a44b803f51c26bb9b868a14af832c715594ac0b1a103a9d551990808619c2f719ddb347782828df7139d8e16cbc22b522f44b62640d8f13272c158e1192ca73768e5a34ce72f0560608e40985acb998d64e49551fa39dc353d7daf743f4fd0137d69c045eccf2c28e3b1e39debd0caf28e4ae453753a81477a52013ea3f80205b080256a103082055930820441a00302010202103d78d7f9764960b2617df4f01eca862a300d06092a864886f70d01010b05003081ca310b300906035504061302555331173015060355040a130e566572695369676e2c20496e632e311f301d060355040b1316566572695369676e205472757374204e6574776f726b313a3038060355040b1331286329203230303620566572695369676e2c20496e632e202d20466f7220617574686f72697a656420757365206f6e6c79314530430603550403133c566572695369676e20436c6173732033205075626c6963205072696d6172792043657274696669636174696f6e20417574686f72697479202d204735301e170d3133313231303030303030305a170d3233313230393233353935395a307f310b3009060355040613025553311d301b060355040a131453796d616e74656320436f72706f726174696f6e311f301d060355040b131653796d616e746563205472757374204e6574776f726b3130302e0603550403132753796d616e74656320436c61737320332053484132353620436f6465205369676e696e6720434130820122300d06092a864886f70d01010105000382010f003082010a028201010097831e0016af2cb1d208c4d7689351601e71f6e247b4db584d23626ab4bf5a1b51f7a30d187768bbd836ab2f2150da9ef3e75f274e0bc297c8097093a9da5c0d4ea40d91a0b4ec14ce9172542ecea3db44e9521b3f413cca4ae4aac0e839ab53cc21d0cccf7f9be6c2cc586a8215ee3d36cf1cc59707248ef17bbe312d3d6edcb599429f4b61955f1c70ee177ddb8be5618978c7681baf11781a98aec4554753d9b332d6a10e4640c597928ad153a7995b853557d3ea936261200ac7307724114d6283b6ba7b688231ee65cadff9d58db235dc8c2b6f6a725c60849cf20c945ec056520048ccd3f8a57dde2fd713e438a884d546b81386c21b9dea5a38dd9bdb0203010001a38201833082017f302f06082b0601050507010104233021301f06082b060105050730018613687474703a2f2f73322e73796d63622e636f6d30120603551d130101ff040830060101ff020100306c0603551d20046530633061060b6086480186f845010717033052302606082b06010505070201161a687474703a2f2f7777772e73796d617574682e636f6d2f637073302806082b06010505070202301c1a1a687474703a2f2f7777772e73796d617574682e636f6d2f72706130300603551d1f042930273025a023a021861f687474703a2f2f73312e73796d63622e636f6d2f706361332d67352e63726c301d0603551d250416301406082b0601050507030206082b06010505070303300e0603551d0f0101ff04040302010630290603551d1104223020a41e301c311a30180603550403131153796d616e746563504b492d312d353637301d0603551d0e04160414963b53f0793397af7d83ef2e2bcccab7861e7266301f0603551d230418301680147fd365a7c2ddecbbf03009f34339fa02af333133300d06092a864886f70d01010b0500038201010013851a1e69a937f7a0bda4af7e1d6153fe9d8c5e0ca6751e781723ddfdec1a035539fb7195c7655aa78e30d2445a61db706fda2105c22e73ba49f1d193fe5dc9cd5e03e0899e3f741ed7f7388ba9d6cfbb352f3358a89256d1c84d3b82e6798416fc28b0b147f31da23eee87d9a67fa456a53fad842e29de7cbca8aaa33d0401eaba93a20e502229174c87e43a115fd6a425899b056b2fb4c9014c277b0bac190522a060153fdac9fb4d4c8ffb726777fd2794c7ba350e8849fe8dfd28af4a12bd0db39705de440c15fa362b03dcc15001f1a1115d14e5e2bd274b54be2b845e0fa6c374050aef97c38922b11f77f3bdcd43d4f14ca93fb58b84af64f2d01421318204d3308204cf020101308193307f310b3009060355040613025553311d301b060355040a131453796d616e74656320436f72706f726174696f6e311f301d060355040b131653796d616e746563205472757374204e6574776f726b3130302e0603550403132753796d616e74656320436c61737320332053484132353620436f6465205369676e696e672043410210606ad8b4a778f67ffdb28ad68e0bad39300906052b0e03021a0500a0703010060a2b06010401823702010c31023000301906092a864886f70d010903310c060a2b060104018237020104301c060a2b06010401823702010b310e300c060a2b060104018237020115302306092a864886f70d0109043116041405af4d8be6dfa3b3ccc33588fab69fbd7ac64fa6300d06092a864886f70d0101010500048201000bca1b564358ff07c315b69e9fce4527711ce6ceba6df4f5c6eb4b1f5788c175977082e04523865b62dcc204ad0bcca6fd22853417d6fd2f1208125cdb615a0ca405958b887b59f0a17eb0d3789a04a0ac27ff3d2d3dbc7f03a5f24860fb5a7c0fe5b9d10ef62babdcc3ef42015186773d6f5bf438ee7a699dd41c7164d176ff924a7a0afbc52eef3db6a61e75f99dbb1fcd4272bfc396083dc87cb3eb32e7aca9a2f2ba62dcf15c7dc08fe9c4175142dfe2d319b7d951ae8d21847bcd83a49127e6960f63655fcb961b3470562ee0b7c6421ed15d90a2f402d28d0e69a7840458c4cc51df34133c54ff6fdd411d403b50ccf74cf3ac868dd21df31814e154baa18202a23082029e06092a864886f70d0109063182028f3082028b02010130683052310b300906035504061302424531193017060355040a1310476c6f62616c5369676e206e762d7361312830260603550403131f476c6f62616c5369676e2054696d657374616d70696e67204341202d20473202121121d699a764973ef1f8427ee919cc534114300906052b0e03021a0500a081fd301806092a864886f70d010903310b06092a864886f70d010701301c06092a864886f70d010905310f170d3139313231393232323431335a302306092a864886f70d01090431160414bb4a1583d1c45c2c5a61c81d8d83de14002181db30819d060b2a864886f70d010910020c31818d30818a308187308184041463b82fab61f583909695050b00249c502933ec79306c3056a4543052310b300906035504061302424531193017060355040a1310476c6f62616c5369676e206e762d7361312830260603550403131f476c6f62616c5369676e2054696d657374616d70696e67204341202d20473202121121d699a764973ef1f8427ee919cc534114300d06092a864886f70d010101050004820100279c573a4a6d7028b8ea2376c8b11cd2314a7a2287eb14a19cd71318345758b7d50590e6c7fb8a50a1fcfed44ae4a466cdf247464bb4d57892cbbb7e504d07d973bdb980b85257f482ff7a0dcf7e9e15da430bb121ea277e159a9d7257fe165b4a4cb0f08dce01222eeced6be2f4b2a92941a9e1b0fdb94f62f1e83315f4effc070a753fa6116af92c561f4e8f8fdbb296663347e7c9678f5a0084b86ad529417047d1815bab2a321ad45e706c1845cab619e54d677a45af0bd2d14c555912ac58e266d8eac19f70cdbc1f22012be8faceb218fa45fea58472a3c4148211c115817a501905dcc3fda9a5f093b73fe14eca93d3368b70eb0584b006e42927b6b000
				WITH PERMISSION_SET = SAFE;

				PRINT ''Create certificate PRMCLRCodeCert2019 from [PRMDatabaseCLR]''
				CREATE CERTIFICATE PRMCLRCodeCert2019 FROM 	ASSEMBLY [PRMDatabaseCLR]
				-- CREATE CERTIFICATE PRMCLRCodeCert2019 FROM EXECUTABLE FILE = ''\Installation\DBScript\Assemblies\PRMDatabaseCLR.dll''   
			END
			
			IF NOT EXISTS (SELECT name FROM sys.server_principals WHERE name = ''PRMCLRCodeLogin2019'')
			BEGIN
				PRINT ''Create Login PRMCLRCodeLogin2019 from PRMCLRCodeCert2019''
				CREATE LOGIN PRMCLRCodeLogin2019 FROM CERTIFICATE PRMCLRCodeCert2019
				GRANT UNSAFE ASSEMBLY TO PRMCLRCodeLogin2019
			END
			
			IF  EXISTS (SELECT * FROM sys.assemblies asms WHERE asms.name = N''PRMDatabaseCLR'')
			BEGIN
				If EXISTS (SELECT * FROM sys.objects where Name = N''UninstallDatabaseCLR'')
					exec UninstallDatabaseCLR
				PRINT ''Drop temporary Assembly [PRMDatabaseCLR] from master''
				DROP ASSEMBLY [PRMDatabaseCLR];
			END
			IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N''[dbo].[CreateDatabaseCLR]'') AND type in (N''P'', N''PC''))
			BEGIN
				DROP PROCEDURE [dbo].[CreateDatabaseCLR]
			END
			EXECUTE(''ALTER DATABASE ['' + @dbname + ''] SET TRUSTWORTHY OFF'')
		'

	EXEC sp_executesql N'
			-- the string DLLBYTES below will be replaced by the DatabaseCLR post build step
			CREATE ASSEMBLY [PRMDatabaseCLR]
			AUTHORIZATION [dbo]
			FROM 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
			WITH PERMISSION_SET = UNSAFE;
		'
	EXEC sp_executesql N'
			CREATE PROCEDURE [UninstallDatabaseCLR] AS EXTERNAL NAME [PRMDatabaseCLR].[Registration].[UninstallDatabaseCLR]
		'
	EXEC sp_executesql N'
			CREATE PROCEDURE [InstallDatabaseCLR] AS EXTERNAL NAME [PRMDatabaseCLR].[Registration].[InstallDatabaseCLR]
		'
	EXEC sp_executesql N'
			EXEC [InstallDatabaseCLR];
		'
	EXEC sp_executesql N'
			DECLARE @dbname varchar(255) = db_name()
			EXECUTE(''ALTER DATABASE ['' + @dbname  + ''] SET TRUSTWORTHY OFF'')
		'
	/*
		-- 2015 code certificate in the PRM DB run this to verify the certificate and login exist. Login should be in both, cert only in Master
		-- 2018 code certificate in the PRM DB run this to verify the certificate and login exist. Login should be in both, cert only in Master
		-- 2019 code certificate in the PRM DB run this to verify the certificate and login exist. Login should be in both, cert only in Master
		SELECT name [PRM Cert] from sys.certificates where name like 'PRMCLRCodeCert%'
		SELECT name [PRM Login] FROM sys.server_principals WHERE name like 'PRMCLRCodeLogin%'
		SELECT name [master Cert] from master.sys.certificates where name like 'PRMCLRCodeCert%'
		SELECT name [master Login] FROM master.sys.server_principals WHERE name like 'PRMCLRCodeLogin%'
		-- This will remove the cert and login so we can create new ones
		USE master; 
		DROP LOGIN PRMCLRCodeLogin2019
		DROP CERTIFICATE PRMCLRCodeCert2019 
		DROP LOGIN PRMCLRCodeLogin2019
		DROP CERTIFICATE PRMCLRCodeCert2019

		once the CLR has been installed, the follow should be run to verify
		that clr strict security is ON and trustworthy is OFF
		EXEC sp_configure 'show advanced options', 1
		RECONFIGURE;
		EXEC sp_configure 'clr strict security'
		select name, is_trustworthy_on from sys.databases

		-- test with this
		exec HelloWorld 'howdy'
	*/
END
GO

EXEC sp_executesql N'
		EXEC [CreateDatabaseCLR];
	'
GO
