-- #25021_V6R1_TransmissionConfiguration_Updates.sql
UPDATE TransmissionConfiguration
SET
   AprimaVaultSubmissionURL        = 'https://erx2.mednetworx.net/NewPrescription',
   AprimaVaultURL                  = 'https://sm.Mednetworx.net/',
   RegistrationURL                 = 'https://erx2.mednetworx.net/NewPrescription',
   TestAprimaVaultSubmissionURL    = 'https://cpdev02.aprima.corp:40140/NewPrescription',
   TestAprimaVaultURL              = 'https://cpdev02.aprima.corp:34100/',
   TestRegistrationURL             = 'https://cpdev02.aprima.corp:34100/',
   CorepointDownloadProcessorAQN   = 'iMedica.Framework.eRxCorepoint.Transmission.V6R1eNewRxCorepointDownloadProcessor, eRxCorepoint',
   CorepointDataExportGeneratorAQN = 'iMedica.Framework.eRxCorepoint.Generator.V6R1eNewRxCorepointExportGenerator, eRxCorepoint',
   CorepointSenderAQN              = 'iMedica.Framework.eRxCorepoint.Transmission.V6R1eNewRxCorepointSender, eRxCorepoint',
   OutboundQueueGeneratorAQN       = null,
   ExportXMLLayout                 = null,
   ExportBusinessObjectName        = 'RelVisitMedication',
   ExportKeyLookupFieldName        = 'RelVisitMedicationUid'
WHERE TransmissionType = 'NEWRX'

UPDATE TransmissionConfiguration
SET
   AprimaVaultSubmissionURL        = 'https://erx2.mednetworx.net/RefillResponse',
   AprimaVaultURL                  = 'https://sm.Mednetworx.net/',
   RegistrationURL                 = 'https://erx2.mednetworx.net/RefillResponse',
   TestAprimaVaultSubmissionURL    = 'https://cpdev02.aprima.corp:40145/RefillResponse',
   TestAprimaVaultURL              = 'https://cpdev02.aprima.corp:34100/',
   TestRegistrationURL             = 'https://cpdev02.aprima.corp:34100/',
   CorepointDownloadProcessorAQN   = 'iMedica.Framework.eRxCorepoint.Transmission.V6R1eRxRefillResponseCorepointDownloadProcessor, eRxCorepoint',
   CorepointDataExportGeneratorAQN = 'iMedica.Framework.eRxCorepoint.Generator.V6R1eRxRefillResponseCorepointExportGenerator, eRxCorepoint',
   CorepointSenderAQN              = 'iMedica.Framework.eRxCorepoint.Transmission.V6R1eRxRefillResponseCorepointSender, eRxCorepoint',
   OutboundQueueGeneratorAQN       = null,
   ExportXMLLayout                 = null,
   ExportBusinessObjectName        = 'Message',
   ExportKeyLookupFieldName        = 'MessageUid'
WHERE TransmissionType = 'REFRES'

UPDATE TransmissionConfiguration
SET
   AprimaVaultSubmissionURL        = 'https://erx2.mednetworx.net/Cancel',
   AprimaVaultURL                  = 'https://sm.Mednetworx.net/',
   RegistrationURL                 = 'https://erx2.mednetworx.net/Cancel',
   TestAprimaVaultSubmissionURL    = 'https://cpdev02.aprima.corp:40155/Cancel',
   TestAprimaVaultURL              = 'https://cpdev02.aprima.corp:34100/',
   TestRegistrationURL             = 'https://cpdev02.aprima.corp:34100/',
   CorepointDownloadProcessorAQN   = 'iMedica.Framework.eRxCorepoint.Transmission.V6R1eCancelRxCorepointDownloadProcessor, eRxCorepoint',
   CorepointDataExportGeneratorAQN = 'iMedica.Framework.eRxCorepoint.Generator.V6R1eCancelRxCorepointExportGenerator, eRxCorepoint',
   CorepointSenderAQN              = 'iMedica.Framework.eRxCorepoint.Transmission.V6R1eCancelRxCorepointSender, eRxCorepoint',
   OutboundQueueGeneratorAQN       = null,
   ExportXMLLayout                 = null,
   ExportBusinessObjectName        = 'RelPatientMedication',
   ExportKeyLookupFieldName        = 'RelPatientMedicationUid'
WHERE TransmissionType = 'CANRX'

UPDATE TransmissionConfiguration
SET
   AprimaVaultSubmissionURL        = 'https://erx2.mednetworx.net/Change',
   AprimaVaultURL                  = 'https://sm.Mednetworx.net/',
   RegistrationURL                 = 'https://erx2.mednetworx.net/Change',
   TestAprimaVaultSubmissionURL    = 'https://cpdev02.aprima.corp:40150/Change',
   TestAprimaVaultURL              = 'https://cpdev02.aprima.corp:34100/',
   TestRegistrationURL             = 'https://cpdev02.aprima.corp:34100/',
   CorepointDownloadProcessorAQN   = 'iMedica.Framework.eRxCorepoint.Transmission.V6R1eChangeRxResponseCorepointDownloadProcessor, eRxCorepoint',
   CorepointDataExportGeneratorAQN = 'iMedica.Framework.eRxCorepoint.Generator.V6R1eChangeRxResponseCorepointExportGenerator, eRxCorepoint',
   CorepointSenderAQN              = 'iMedica.Framework.eRxCorepoint.Transmission.V6R1eChangeRxResponseCorepointSender, eRxCorepoint',
   OutboundQueueGeneratorAQN       = null,
   ExportXMLLayout                 = null,
   ExportBusinessObjectName        = 'Message',
   ExportKeyLookupFieldName        = 'MessageUid'
WHERE TransmissionType = 'CHGRES'

UPDATE TransmissionConfiguration
SET
   AprimaVaultSyncURL              = 'https://integration.aprima.com/surescripts/directoryRequest',
   RegistrationURL                 = 'https://integration.aprima.com/surescripts/directoryRequest',
   TestAprimaVaultSyncURL          = 'https://cpdev01.aprima.corp:40115/communityexchange/partner/PartnerService',
   TestRegistrationURL             = 'https://cpdev01.aprima.corp:40015/communityexchange/partner/PartnerService',
   ExportXMLLayout                 = null
WHERE TransmissionType IN('eRxOrganizationDirectory','eRxProviderDirectory')

UPDATE TransmissionConfiguration
SET
   AprimaVaultURL                  = 'https://sm2.aprima.com',
   TestAprimaVaultURL              = 'https://cpdev01.aprima.corp:34100'
WHERE TransmissionType IN('RXHREQ', 'INBOUND')

UPDATE TransmissionConfiguration
SET
   AprimaVaultURL                  = 'https://sm2.aprima.com',
   TestAprimaVaultURL              = 'https://cpdev01.aprima.corp:34100'
WHERE TransmissionType IN('RXHREQ', 'INBOUND')

UPDATE TransmissionConfiguration
SET
   TestAprimaVaultURL              = 'https://cpdev01.aprima.corp:34100'
WHERE TransmissionType IN('ELGREQ')

-- UPDATE TransmissionConfiguration
-- SET
   -- AprimaVaultSubmissionURL        = 'https://integration.aprima.com/surescripts/directoryRequest',
   -- AprimaVaultURL                  = 'https://sm2.aprima.com',
   -- RegistrationURL                 = 'https://integration.aprima.com/surescripts/directoryRequest'
-- -- TestAprimaVaultURL              = 'https://cpdev01.aprima.corp:34100',
-- -- TestAprimaVaultSubmissionURL    = 'https://tiran.aprima.corp:51375/communityexchange/partner/PartnerService',
-- -- TestRegistrationURL             = 'https://cpdev01.aprima.corp:40015/communityexchange/partner/PartnerService'
-- WHERE TransmissionType IN('PRVUPD::Prescriber Download')

-- Make sure surescripts TestMode is the same as the IntegrationPartner
UPDATE tc
SET TestMode = ip.TestMode
FROM TransmissionConfiguration tc
INNER JOIN ListIntegrationPartner ip ON ip.IntegrationPartnerUid = tc.IntegrationPartnerUid
WHERE tc.TestMode != ip.TestMode
  AND ip.IntegrationPartnerUid IN('118422AA-C165-4A2E-8389-E5B7E89636EA', '4D1BC44B-31F5-4B41-8F50-A95047266FFC')
GO

-- #28667_TransmissionConfiguration_PrescriberDownload.sql
-- Set the URLs back to what they were previously
UPDATE TransmissionConfiguration
SET
   AprimaVaultURL           = 'https://cpcedirectoryservice.aprima.com/communityexchange/partner/PartnerService',
   AprimaVaultSubmissionURL = 'https://cpdirectoryservice.aprima.com/communityexchange/partner/PartnerService',
   RegistrationURL          = 'https://cpdirectoryservice.aprima.com/communityexchange/partner/PartnerService'
WHERE TransmissionType = 'PRVUPD::Prescriber Download'
GO

-- #29106   29118_ListFilter_V6_RxRefill_Message.sql
-- Add V6 RxRefill Message to any message filters that had one of the two types of deprecated RxRefill messages
UPDATE fil
SET Criteria = aft.txt
FROM ListFilter fil
CROSS APPLY (SELECT txt = SUBSTRING(fil.Criteria, 1, CHARINDEX('<Control Name="_findTextMessageType"', fil.Criteria) - 1)) pre
CROSS APPLY (SELECT txt = SUBSTRING(fil.Criteria, LEN(pre.txt) + 1, CHARINDEX('/>', SUBSTRING(fil.Criteria, LEN(pre.txt), LEN(fil.Criteria))))) fmt
CROSS APPLY (SELECT txt = SUBSTRING(fil.Criteria, LEN(pre.txt) + LEN(fmt.txt) + 1, LEN(fil.Criteria))) pst
CROSS APPLY (SELECT elm = CONVERT(XML, fmt.txt)) elm
CROSS APPLY (
   SELECT txt = pre.txt
              + '<Control'
			  + ' Name="'            + elm.value('(/Control/@Name           )[1]', 'nvarchar(max)') + '"'
			  + ' ControlType="'     + elm.value('(/Control/@ControlType    )[1]', 'nvarchar(max)') + '"'
			  + ' Guid="'            + elm.value('(/Control/@Guid           )[1]', 'nvarchar(max)') + '"'
			  + ' Value="'           + elm.value('(/Control/@Value          )[1]', 'nvarchar(max)') + '"'
			  + ' Tag="'             + elm.value('(/Control/@Tag            )[1]', 'nvarchar(max)') + '"'
			  + ' ForeignKeyIndex="' + elm.value('(/Control/@ForeignKeyIndex)[1]', 'nvarchar(max)') + '"'
			  + ' FindTableUid="'    + elm.value('(/Control/@FindTableUid   )[1]', 'nvarchar(max)') + '"'
			  + ' ExternalId="'      + elm.value('(/Control/@ExternalId     )[1]', 'nvarchar(max)') + '"'
			  + ' Label="'           + elm.value('(/Control/@Label          )[1]', 'nvarchar(max)') + '"'
			  + ' />'
			  + pst.txt) bef
CROSS APPLY (
   SELECT txt = pre.txt
              + '<Control'
			  + ' Name="'            + elm.value('(/Control/@Name           )[1]', 'nvarchar(max)') + '"'
			  + ' ControlType="'     + elm.value('(/Control/@ControlType    )[1]', 'nvarchar(max)') + '"'
			  + ' Guid="'            + elm.value('(/Control/@Guid           )[1]', 'nvarchar(max)') + ';eb31df6b-3685-4639-81f6-026f6278e1dc"'
			  + ' Value="'           + elm.value('(/Control/@Value          )[1]', 'nvarchar(max)') + ';Rx Refill Request"'
			  + ' Tag="'             + elm.value('(/Control/@Tag            )[1]', 'nvarchar(max)') + ';"'
			  + ' ForeignKeyIndex="' + elm.value('(/Control/@ForeignKeyIndex)[1]', 'nvarchar(max)') + ';0"'
			  + ' FindTableUid="'    + elm.value('(/Control/@FindTableUid   )[1]', 'nvarchar(max)') + '"'
			  + ' ExternalId="'      + elm.value('(/Control/@ExternalId     )[1]', 'nvarchar(max)') + '"'
			  + ' Label="'           + elm.value('(/Control/@Label          )[1]', 'nvarchar(max)') + '"'
			  + ' />'
			  + pst.txt) aft
WHERE Type = 'ControlMessageCenterFilter'
  AND (fil.Criteria LIKE '%<Control Name="_findTextMessageType" ControlType="FindTextControl" Guid="%d7716f70-61d6-4ec0-8ba6-01afc95e99f2%" Value="%" Tag="%" ForeignKeyIndex="%" FindTableUid="0fb434e9-fc6c-418c-aa08-501f44d311db" ExternalId="%" Label="Message Type" />%'
    OR fil.Criteria LIKE '%<Control Name="_findTextMessageType" ControlType="FindTextControl" Guid="%a2b88bc2-e7c8-4990-92f6-ae28b5c0dc77%" Value="%" Tag="%" ForeignKeyIndex="%" FindTableUid="0fb434e9-fc6c-418c-aa08-501f44d311db" ExternalId="%" Label="Message Type" />%')
  AND fil.Criteria NOT LIKE '%eb31df6b-3685-4639-81f6-026f6278e1dc%'
  AND fil.Criteria = bef.txt
GO

-- #29611_UpdateListFindControlBehavior_SPDST.sql
IF EXISTS(SELECT * from ListFindControlBehavior where FindControlBehaviorUid = '2AC6FAF3-F4F1-4358-9856-40414F948631')
BEGIN
update ListFindControlBehavior
set FindTableUid = '22C60022-225F-4FFE-AE7C-B0B3863CFBCF'
where FindControlBehaviorUid = '2AC6FAF3-F4F1-4358-9856-40414F948631'
END
GO
