SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AllowFinancialBatchOverride]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE function [dbo].[AllowFinancialBatchOverride]
	()
	returns bit as
begin

	declare @ret bit
	declare @var int
	set @var  = cast(substring(context_info(),1,4) as int) -- get current context info value
	-- MergeData (32), ARMigration (16), PatientMerge (8), Replication UP (1) and DOWN (2) TODO: Modify process once 2011 financials stable to deal with UP conflicts (DOWN does not matter)
	-- Bit 3 (4), reserved for replication OVERRIDE - catch anyway below
	if ((@var & 32 = 32) OR (@var & 16 = 16) OR (@var & 8 = 8) OR (@var & 4 = 4) OR (@var & 2 = 2) OR (@var & 1 = 1)) -- set flags to capture bit on or off
		set @ret = 1
	else
		set @ret = 0
		
	return @ret
end

/*
 
DECLARE @testFlag INT
SET @testFlag = ??? -- which bit are we testing?
 
-- init CONTEXT_INFO for testing
DECLARE @contextInfo int
SET @contextInfo  = 128
SET CONTEXT_INFO @contextInfo

 
-- set CONTEXT_INFO (turn on bit)
DECLARE @currentContextInfo int
DECLARE @newContextInfo int
SET @currentContextInfo  = CAST(SUBSTRING(ISNULL(CONTEXT_INFO(),0),1,4) AS INT)
SET @newContextInfo = @currentContextInfo | @testFlag -- turn on bit
SET CONTEXT_INFO @newContextInfo

-- check CONTEXT_INFO
DECLARE @var int
SET @var  = CAST(SUBSTRING(ISNULL(CONTEXT_INFO(),0),1,4) AS INT)
IF (@var & @testFlag = @testFlag)
      SELECT ''SET''
ELSE
      SELECT ''NOT SET''
 
SELECT ''Allow'', dbo.AllowFinancialBatchOverride()

*/


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SplitList_Uids]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[SplitList_Uids] (@list VARCHAR(MAX), @separator VARCHAR(MAX) = '';'')  
RETURNS @table TABLE ( Value UNIQUEIDENTIFIER ) AS
	BEGIN     
		DECLARE @position INT,   
				@previous INT     
		
		SET @list = @list + @separator     
		
		SET @previous = 1     
		SET @position = CHARINDEX(@separator, @list)     
		WHILE @position > 0   
			BEGIN        
			IF @position - @previous > 0           
				INSERT INTO @table VALUES (CONVERT(UNIQUEIDENTIFIER, LTRIM(RTRIM(SUBSTRING(@list, @previous, @position - @previous)))))
				IF @position >= LEN(@list)   
					BREAK        
			SET @previous = @position + 1        
			SET @position = CHARINDEX(@separator, @list, @previous)     
	END     
	RETURN  
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsCacheClient]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE function [dbo].[IsCacheClient] ()
	returns bit as
begin

	declare @ret bit
	IF EXISTS ( SELECT 1 FROM ReplicationSettings where Name = ''Replication.IsCacheServer'' and BoolValue = 1 )
	BEGIN
		SET @ret = 1
	END
	ELSE
	BEGIN
		SET @ret = 0
	END

	return @ret

end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsReplicating]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE function [dbo].[IsReplicating]
	()
	returns bit as
begin

	DECLARE @var int
	SET @var  = CAST(SUBSTRING(ISNULL(CONTEXT_INFO(),0),1,4) AS INT)

	IF (@var & 7 > 0) -- up, down, or override state 
		RETURN 1
	ELSE
		RETURN 0 
		
	RETURN 0 -- will never get here ... must have a closing return

end


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SystemGuid]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


-- function returning a Prm system Guid
CREATE FUNCTION [dbo].[SystemGuid] (@SystemId int)
RETURNS uniqueidentifier AS  

BEGIN  

  declare @Wrk varchar(200)
  declare @NewGUID uniqueidentifier

  if (@SystemId < 0) 
	set @SystemId = -1 * @SystemId
  set @Wrk = convert (varchar(200), @SystemId)
  while len(@Wrk) < 32 set @Wrk = ''0'' + @Wrk

  set @Wrk = ''10101010'' + ''-'' + SUBSTRING(@Wrk, 9, 4) + ''-'' + SUBSTRING(@Wrk, 13, 4) 
                              + ''-'' + SUBSTRING(@Wrk, 17, 4) + ''-'' + SUBSTRING(@Wrk, 21, 12)
  set @Wrk = ''{'' + @Wrk + ''}''
  set @NewGUID = @Wrk
  return (@NewGUID)
END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Replication_IsReplicatedDB]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[Replication_IsReplicatedDB]
(
)
RETURNS BIT
AS
BEGIN
	DECLARE @Inactive BIT,
			@ReplicatedDB BIT,
			@URL VARCHAR (255)
			
	SELECT @Inactive = 0,
		   @URL = CAST (SERVERPROPERTY (''MachineName'') AS VARCHAR (255))
		
	SELECT TOP 1 @ReplicatedDB =
		CASE WHEN URL = @URL
				OR EXISTS ( 
							SELECT TOP 1 *
							FROM ListCacheMachine AS t
								INNER JOIN ReplicationSettings AS t1 ON t.URL = @URL
									AND t1.Name = ''Replication.IsCacheServer''
									AND t.CacheMachineUid = t1.GuidValue
									AND t1.BoolValue <> 0
						  )
				OR EXISTS (
							SELECT TOP 1 *
							FROM ListCacheMachine AS t
								INNER JOIN ReplicationSettings AS t1 ON t.URL = @URL
									AND t1.Name = ''Replication.STSReconfigInfo''
									AND t.CacheMachineUid = t1.GuidValue
						  )
				OR NOT EXISTS (
								SELECT TOP 1 *
								FROM ReplicationFilter
								WHERE CacheMachineUid = t.CacheMachineUid
									AND TableName = ''ListCacheMachine''
							   )
			 THEN CAST (1 AS BIT)
			 ELSE CAST (0 AS BIT)
		END
	FROM ViewListCacheMachine AS t
	WHERE URL = @URL
		AND Inactive = @Inactive

	RETURN COALESCE (@ReplicatedDB, 0)
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetChangeTrackingContextFromContextInfo]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[GetChangeTrackingContextFromContextInfo]()
RETURNS VARBINARY(128)
BEGIN

	DECLARE @extractedContextInfo VARBINARY(128);
	DECLARE @extractedContextInfoString VARCHAR(MAX)
	DECLARE @retVal VARBINARY(128);
	
	SELECT @extractedContextInfo = CAST(SUBSTRING(CONTEXT_INFO(),33, 128) AS VARBINARY(128));
	IF (NOT @extractedContextInfo IS NULL AND @extractedContextInfo<>CAST('''' AS VARBINARY(128)))
		SET @retVal = @extractedContextInfo;
		
	RETURN @retVal;
	
END

/*
	DECLARE @contextInfo VARBINARY(128);
	DECLARE @contextInfoString VARCHAR(MAX);
	DECLARE @changeTrackingContextString VARCHAR(MAX);
	DECLARE @bitField INT;

	SELECT @bitField = 128;
	SELECT @changeTrackingContextString = '''';
	--SELECT @changeTrackingContextString = ''BrettBrettBrettBrettBret'';

	SET @contextInfoString = CAST(CAST(@bitField AS BINARY(4)) AS VARCHAR(MAX)) 
		+ CAST(CAST('''' AS BINARY(28)) AS VARCHAR(MAX))
		+ CAST(CAST(@changeTrackingContextString AS BINARY(24)) AS VARCHAR(MAX)); 
	SET @contextInfo = CAST(@contextInfoString AS BINARY(128));

	SET CONTEXT_INFO @contextInfo;
	SELECT CONTEXT_INFO()
	
	SELECT dbo.GetChangeTrackingContextFromContextInfo(), CAST(dbo.GetChangeTrackingContextFromContextInfo() AS VARCHAR(MAX))
*/




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Split]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[Split]
 (	@vcDelimitedString VARCHAR(max),
	@vcDelimiter VARCHAR(100) 
 )

RETURNS @tblArray TABLE
   (
	ElementID	smallint	IDENTITY(1,1),  --Array index
   	Element		varchar(1000)			--Array element contents
   )
AS
BEGIN

	DECLARE
	@siIndex	SMALLINT,
	@siStart		SMALLINT,
	@siDelSize	SMALLINT


	SET @siDelSize	= LEN(@vcDelimiter)
	--loop through source string and add elements to destination table array
	WHILE LEN(@vcDelimitedString) > 0
	BEGIN
		SET @siIndex = CHARINDEX(@vcDelimiter, @vcDelimitedString)
		IF @siIndex = 0
		BEGIN
			INSERT INTO @tblArray VALUES(@vcDelimitedString)
			BREAK
		END
		ELSE
		BEGIN
			INSERT INTO @tblArray VALUES(SUBSTRING(@vcDelimitedString, 1,@siIndex - 1))
			SET @siStart = @siIndex + @siDelSize
			SET @vcDelimitedString = SUBSTRING(@vcDelimitedString, @siStart , LEN(@vcDelimitedString) - @siStart + 1)
		END
	END

	RETURN
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAccountResponsiblePartyOriginalCollectionsBalance]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetAccountResponsiblePartyOriginalCollectionsBalance]
(
	@AccountResponsiblePartyUid uniqueidentifier
)
RETURNS
	money
AS
BEGIN
DECLARE	@AccountBalance money
SELECT
	@AccountBalance = Sum(EnteringCollectionsPatientBalance)
FROM
	SuperbillsInAutomatedCollections sic
INNER JOIN
	Superbill s ON
		sic.SuperbillUid = s.SuperbillUid
WHERE
	sic.AccountResponsiblePartyUid = @AccountResponsiblePartyUid

RETURN isnull(@AccountBalance, 0)
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAccountRPBalanceInCollections]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetAccountRPBalanceInCollections]  
(  
 @AccountResponsiblePartyUid UNIQUEIDENTIFIER  
)  
RETURNS  
	MONEY  
AS  
BEGIN  
	DECLARE @AccountBalance money  
	SELECT @AccountBalance = Sum(VSA.LiabilityBalance - VSA.AssignedLiabilityBalance)  
		FROM AR_ViewSuperbillAggregate VSA
			INNER JOIN Superbill SB ON VSA.SuperbillUid =SB.SuperbillUid AND (NOT SB.DateEnteredAutomatedCollections IS NULL 
				AND SB.DateLeftAutomatedCollections IS NULL)
			INNER JOIN Account A ON SB.AccountUid = A.AccountUid 
		WHERE 
			A.AccountResponsiblePartyUid = @AccountResponsiblePartyUid 
		
	RETURN ISNULL(@AccountBalance, 0)  
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetCollectionStatusLevelForAccountResponsibleParty]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetCollectionStatusLevelForAccountResponsibleParty]
(
	@AccountResponsiblePartyUid uniqueidentifier,
	@CollectionStatusUid				uniqueidentifier
)
RETURNS uniqueidentifier
AS
BEGIN
DECLARE @CurrentBalance money
SET @CurrentBalance = dbo.GetAccountRPBalanceInCollections(@AccountResponsiblePartyUid)
DECLARE @CollectionStatusLevelUid uniqueidentifier
SELECT
	@CollectionStatusLevelUid = CollectionStatusLevelUid
FROM
	CollectionStatusLevel
WHERE
		CollectionStatusUid = @CollectionStatusUid AND Inactive=0
AND	(
			@CurrentBalance >= BalanceFrom
			AND
			(
				(
						GreaterThan = 0
					AND
						@CurrentBalance <= BalanceTo
				)
				OR
				(
						GreaterThan = 1
				)
			)
		)
RETURN @CollectionStatusLevelUid
END' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ConvertUTCToLocalTime]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ConvertUTCToLocalTime](@utcTime [datetime])
RETURNS [datetime] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[ConvertUTCToLocalTime]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsWeekDay]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/15/2016
-- Description:	Returns "1" when the current date is "Monday" thur
--				"Friday" and "0" when "Sunday" or "Saturday".
--
--				For translated C# code: see business object 
--				"RelCalendarCalendarTemplateHead.cs";
--				function "IsWeekDay(DateTime oDate)"
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[IsWeekDay](
		@currentDate DATE
		)

RETURNS bit
AS
begin
	declare @isWeekDay bit = 1

	declare @DayOfWeek int = DATEPART(WEEKDAY, @currentDate) -- 1 = Sunday; 2 = Monday; 3 = Tuesday...Saturday = 7

	if ((@DayOfWeek = 1) or (@DayOfWeek = 7))
	begin
		set @isWeekDay = 0
	end

	return @isWeekDay
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetNDayofMonth]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/15/2016
-- Description:	For translated C# code: see business object 
--				"RelCalendarCalendarTemplateHead.cs";	
--				functions "GetNDayofMonth(int iN, DateTime currentDate, bool isWeekDay)"
--				and "GetNDayofMonth(int iN, DateTime currentDate, DayOfWeek dow)"
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[GetNDayofMonth](
		@iN int,
		@currentDate DATE,
		@isWeekDay bit,
		@dayOfWeek int
		)

RETURNS
	DateTime
AS
begin
	
	if (@isWeekDay is not null)
	begin
		set @currentDate = CONVERT(varchar(20), DATEPART(month, @currentDate)) + ''/1/'' +
								CONVERT(varchar(20), DATEPART(year, @currentDate))
		
		while (((@isWeekDay = 1) and (dbo.IsWeekDay(@currentDate) = 0))
				OR
			  ((@isWeekDay = 0) and (dbo.IsWeekDay(@currentDate) = 1)))
		begin
			set @currentDate = DATEADD(day, 1, @currentDate)
		end -- of while

		while (@iN > 0)
		begin
			set @currentDate = DATEADD(day, 1, @currentDate)
			if (((@isWeekDay = 1) and (dbo.IsWeekDay(@currentDate) = 1))
				 OR
			   ((@isWeekDay = 0) and (dbo.IsWeekDay(@currentDate) = 0)))
			begin
				set @iN = @iN - 1
			end
		end -- of while
	end -- of if (@isWeekDay is not null)
	else if (@dayOfWeek is not null)
	begin
		declare @oldCurrentDate DateTime = @currentDate
		set @currentDate = CONVERT(varchar(20), DATEPART(month, @currentDate)) + ''/1/'' +
								CONVERT(varchar(20), DATEPART(year, @currentDate))

		while (DATEPART(WEEKDAY, @currentDate) <> @dayOfWeek)
		begin
			set @currentDate = DATEADD(day, 1, @currentDate)
		end

		while (@iN > 0)
		begin
			set @currentDate = DATEADD(day, 7, @currentDate)
			set @iN = @iN - 1
		end -- of while
	end -- if (@dayOfWeek is not null)

	return @currentDate
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetLastDayofMonth]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/15/2016
-- Description:	For translated C# code: see business object 
--				"RelCalendarCalendarTemplateHead.cs";	
--				functions "GetLastDayofMonth(DateTime currentDate, bool isWeekDay)"
--				and "GetLastDayofMonth(DateTime currentDate, DayOfWeek dow)"
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[GetLastDayofMonth](
		@currentDate DATE,
		@isWeekDay bit,
		@dayOfWeek int
		)

RETURNS DATE
AS
begin
	set @currentDate = DATEADD (month, 1, @currentDate)
	set @currentDate = CONVERT(varchar(20), DATEPART(month, @currentDate)) + ''/1/'' +
							CONVERT(varchar(20), DATEPART(year, @currentDate))
	set @currentDate = DATEADD(day, -1, @currentDate)

	if (@isWeekDay is not null)
	begin
		while (((@isWeekDay = 1) and (dbo.IsWeekDay(@currentDate) = 0))
				OR
			   ((@isWeekDay = 0) and (dbo.IsWeekDay(@currentDate) = 1)))
		begin
			set @currentDate = DATEADD(day, -1, @currentDate)
		end -- of while
	end -- of if (@isWeekDay is not null)
	else if (@dayOfWeek is not null)
	begin
		while ((DATEPART(WEEKDAY, @currentDate) <> @dayOfWeek))
		begin
			set @currentDate = DATEADD(day, -1, @currentDate)
		end
	end

	return @currentDate
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetDateForMonth]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/15/2016
-- Description:	For translated C# code: see business object 
--				"RelCalendarCalendarTemplateHead.cs";	
--				functions "GetDateForMonth(int iPrefix, DateTime currentDate, bool isWeekDay)"
--				and "GetDateForMonth(int iPrefix, DateTime currentDate, DayOfWeek dow)"
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[GetDateForMonth](
		@iPrefix int,
		@currentDate DATE,
		@isWeekDay bit,
		@dayOfWeek int,
		@StartDate DATE
		)

RETURNS DATE
AS
begin
if (@iPrefix = 0) -- last
	begin
		set @currentDate = dbo.GetLastDayofMonth(@currentDate, @isWeekDay, @dayOfWeek)
		if (@currentDate < @StartDate)
		begin
			set @currentDate = dbo.GetLastDayofMonth(DATEADD(month, 1, @currentDate), @isWeekDay, @dayOfWeek)
		end
		else begin
			set @currentDate = dbo.GetNDayofMonth(@iPrefix - 1, @currentDate, @isWeekDay, @isWeekDay)
		end
	end

	return @currentDate
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetNextDateForMonthOption2]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/15/2016
-- Description:	For translated C# code: see business object 
--				"RelCalendarCalendarTemplateHead.cs";
--				method "GetNextDateForMonthOption2(int iPrefix, Guid gUnit, DateTime currentDate)"
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[GetNextDateForMonthOption2](
		@iPrefix int,
		@gUnit uniqueidentifier,
		@currentDate DATE,
		@StartDate DATE
		)

RETURNS DATE
AS
begin
	if (@gUnit = CONVERT(uniqueidentifier, ''F1E71F1B-8025-4875-9DFC-141BCEAF3444'')) -- day
	begin
		if (@iPrefix = 0) -- last day of the month
		begin
			set @currentDate = CONVERT(varchar(20), DATEPART(month, @currentDate)) + ''/1/'' +
									CONVERT(varchar(20), DATEPART(year, @currentDate))
			set @currentDate = DATEADD(month, 1, @currentDate)
			set @currentDate = DATEADD(day, -1, @currentDate)
		end
		else begin
			if (@iPrefix < DATEPART(day, @currentDate))
			begin
				set @currentDate = DATEADD(month, 1, @currentDate)
			end
			set @currentDate = CONVERT(varchar(20), DATEPART(month, @currentDate)) + ''/1/'' +
					CONVERT(varchar(20), DATEPART(year, @currentDate))
			
			set @currentDate = DATEADD(day, @iPrefix - 1, @currentDate)
		end
	end
	else if (@gUnit = CONVERT(uniqueidentifier, ''B3121D9E-9769-4831-8F4E-0678E3F49C13'')) -- weekday
	begin
		set @currentDate = dbo.GetDateForMonth(@iPrefix, @currentDate, 1, null, @StartDate);
	end
	else if (@gUnit = CONVERT(uniqueidentifier, ''EED139E3-4D95-45B4-95BE-50F6B619D43B'')) -- weekday day
	begin
		set @currentDate = dbo.GetDateForMonth(@iPrefix, @currentDate, 0, null, @StartDate);
	end
	else if (@gUnit = CONVERT(uniqueidentifier, ''F0917C45-D974-46D5-B914-57B8E602362B'')) -- Sunday
	begin
		set @currentDate = dbo.GetDateForMonth(@iPrefix, @currentDate, null, 1, @StartDate);
	end
	else if (@gUnit = CONVERT(uniqueidentifier, ''B4658BCB-78BF-46DD-A1F8-52021AC160E1'')) -- Monday
	begin
		set @currentDate = dbo.GetDateForMonth(@iPrefix, @currentDate, null, 2, @StartDate);
	end
	else if (@gUnit = CONVERT(uniqueidentifier, ''F5B6EC8F-FFA2-4489-A916-9916BE193ECC'')) -- Tuesday
	begin
		set @currentDate = dbo.GetDateForMonth(@iPrefix, @currentDate, null, 3, @StartDate);
	end
	else if (@gUnit = CONVERT(uniqueidentifier, ''DA34F712-ED05-455F-97C8-0C6B8DC49C4F'')) -- Wednesday
	begin
		set @currentDate = dbo.GetDateForMonth(@iPrefix, @currentDate, null, 4, @StartDate);
	end
	else if (@gUnit = CONVERT(uniqueidentifier, ''F15B441F-054F-4A74-BB14-4441BA6DE158'')) -- Thursday
	begin
		set @currentDate = dbo.GetDateForMonth(@iPrefix, @currentDate, null, 5, @StartDate);
	end
	else if (@gUnit = CONVERT(uniqueidentifier, ''CF007109-4E97-435A-A37C-F0DAFBFD7DBE'')) -- Friday
	begin
		set @currentDate = dbo.GetDateForMonth(@iPrefix, @currentDate, null, 6, @StartDate);
	end
	else if (@gUnit = CONVERT(uniqueidentifier, ''3C47E0D9-0A04-4420-99B7-496E319900C5'')) -- Saturday
	begin
		set @currentDate = dbo.GetDateForMonth(@iPrefix, @currentDate, null, 7, @StartDate);
	end
	return @currentDate
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CheckMonthlyAssignmentStateOption2]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/15/2016
-- Description: For translated C# code: see business object 
--				"RelCalendarCalendarTemplateHead.cs";
--				function "CheckMonthlyAssignmentStateOption2
--					(XmlDocument xmlDoc, DateTime oDate, out int offset)"
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[CheckMonthlyAssignmentStateOption2](
		@SearchDate DATE,
		@NumDays int,
		@iMonth int,
		@gPrefix uniqueidentifier,
		@gUnit uniqueidentifier,
		@StartDate Date,
		@EndDate Date
		)

RETURNS
@Result Table
	(
		Found bit default (0),
		DaysOffset int default (-1)
	)
begin
	declare @daysOffset int = -1
	declare @found bit = 0
	declare @i int
	declare @iPrefix int
	declare @nextDate DATE
	declare @currentMonthDate DATE
	declare @currentDate DATE = @StartDate
	
	set @currentDate = @StartDate

	set @iPrefix = 1 -- first - CalendarTemplateAssignmentDayPrefix
	if (@gPrefix = CONVERT(uniqueidentifier, ''F933AF8A-D703-499A-B940-827A0D2224A2''))
	begin
		set @iPrefix = 2 -- second - CalendarTemplateAssignmentDayPrefix
	end
	else if (@gPrefix = CONVERT(uniqueidentifier, ''23E2E9F2-8496-475B-85F8-9F70768E68D4''))
	begin
		set @iPrefix = 3 -- third - CalendarTemplateAssignmentDayPrefix
	end
	else if (@gPrefix = CONVERT(uniqueidentifier, ''423085E1-8C4E-4542-A95F-C205B16D524C''))
	begin
		set @iPrefix = 4 -- fourth - CalendarTemplateAssignmentDayPrefix
	end 
	else if (@gPrefix = CONVERT(uniqueidentifier, ''57D0D8DA-8EC6-40DD-BFBC-FCE228ABF107''))
	begin
		set @iPrefix = 5 -- fifth - CalendarTemplateAssignmentDayPrefix
	end 
	else if (@gPrefix = CONVERT(uniqueidentifier, ''8036F9D3-E596-4830-88BB-A247500805AA''))
	begin
		set @iPrefix = 0 -- last - CalendarTemplateAssignmentDayPrefix
	end

	-- goto the first valid Start Date based on the parameters
	set @currentDate = dbo.GetNextDateForMonthOption2(@iPrefix, @gUnit, @currentDate, @StartDate)
	
	declare @stopWhile bit = 0
	while ((@stopWhile = 0) and ((@EndDate is null) OR (@currentDate <= @EndDate)))
	begin
		set @nextDate = dbo.GetNextDateForMonthOption2(@iPrefix, @gUnit, DATEADD(month, @iMonth, @currentDate), @StartDate)

		if (@SearchDate > @nextDate)
		begin
			set @currentDate = @nextDate
		end
		else if (@SearchDate < @currentDate)
		begin
			set @stopWhile = 1
			break
		end
		else begin
			set @i = 0
			while ((@i < @NumDays) and (@stopWhile = 0))
			begin
				set @currentMonthDate = DATEADD(day, @i, @currentDate)

				if ((@SearchDate >= @currentMonthDate) and (@SearchDate < DATEADD(day, @NumDays, @currentDate)))
				begin
					if ((@gPrefix = CONVERT(uniqueidentifier, ''57D0D8DA-8EC6-40DD-BFBC-FCE228ABF107'')) and 
						(
							(@gUnit =  CONVERT(uniqueidentifier, ''F0917C45-D974-46D5-B914-57B8E602362B'')) -- Sunday
							or (@gUnit =  CONVERT(uniqueidentifier, ''B4658BCB-78BF-46DD-A1F8-52021AC160E1'')) -- Monday
							or (@gUnit =  CONVERT(uniqueidentifier, ''F5B6EC8F-FFA2-4489-A916-9916BE193ECC'')) -- Tuesday
							or (@gUnit =  CONVERT(uniqueidentifier, ''DA34F712-ED05-455F-97C8-0C6B8DC49C4F'')) -- Wednesday
							or (@gUnit =  CONVERT(uniqueidentifier, ''F15B441F-054F-4A74-BB14-4441BA6DE158'')) -- Thursday
							or (@gUnit =  CONVERT(uniqueidentifier, ''CF007109-4E97-435A-A37C-F0DAFBFD7DBE'')) -- Friday
							or (@gUnit =  CONVERT(uniqueidentifier, ''3C47E0D9-0A04-4420-99B7-496E319900C5'')) -- Saturday
						)
					   )
					begin
						declare @tempMonthDate DATE = DATEADD(day, -28, @SearchDate)
						if (DATEPART(month, @tempMonthDate) = DATEPART(month, @SearchDate))
						begin
							set @daysOffset = DATEDIFF(day, @SearchDate, @currentMonthDate)
							set @found = 1
							set @stopWhile = 1
							break
						end
						else begin
							set @stopWhile = 1
						end
					end -- of if ((@gPrefix = CONVERT(uniqueidentifier, ''57D0D8DA-8EC6-40DD-BFBC-FCE228ABF107'')) and ...
					else begin			
						set @daysOffset = DATEDIFF(day, @SearchDate, @currentMonthDate) + 1
						set @found = 1
						set @stopWhile = 1
					end
				end -- of if ((@SearchDate >= @currentMonthDate) and (@SearchDate < DATEADD(day, @NumDays, @currentDate)))

				set @i = @i + 1
			end -- of while ((@i < @NumDays) and (@stopWhile = 0))

			set @currentDate = @nextDate
		end

	end -- of while ((@stopWhile = 0) and ((@EndDate is null) OR (@currentDate <= @EndDate)))

	insert into @Result (Found, DaysOffset) values (@found, @daysOffset)

	return 
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetNextDateForMonthOption1]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/15/2016
-- Description:	For translated C# code: see business object 
--				"RelCalendarCalendarTemplateHead.cs";
--				method "GetNextDateForMonthOption1(int iDay, DateTime currentDate)"
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[GetNextDateForMonthOption1](
		@iDay int,
		@currentDate DATE
		)

RETURNS DATE
AS
begin
	declare @iCurrentMonth int

	if (@iDay < DATEPART(day, @currentDate))
	begin
		set @currentDate = DATEADD(month, 1, @currentDate)
	end

	set @currentDate = CONVERT(varchar(20), DATEPART(month, @currentDate)) + ''/1/'' +
					CONVERT(varchar(20), DATEPART(year, @currentDate))
					
	set @iCurrentMonth = DATEPART(month, @currentDate)
	set @currentDate = DATEADD(day, @iDay - 1, @currentDate)

	if (DATEPART(month, @currentDate) > @iCurrentMonth)
	begin
		set @currentDate = CONVERT(varchar(20), DATEPART(month, @currentDate)) + ''/1/'' +
					CONVERT(varchar(20), DATEPART(year, @currentDate))
		set @currentDate = DATEADD(day, -1, @currentDate)
	end

	return @currentDate
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CheckMonthlyAssignmentStateOption1]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/15/2016
-- Description:	For translated C# code: see business object
--				"RelCalendarCalendarTemplateHead.cs";
--				function "CheckMonthlyAssignmentStateOption1
--					(XmlDocument xmlDoc, DateTime oDate, out int offset)"
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[CheckMonthlyAssignmentStateOption1](
		@SearchDate DATE,
		@NumDays int,
		@iDay int,
		@iMonth int,
		@StartDate Date,
		@EndDate Date
		)

RETURNS
@Result Table
	(
		Found bit default (0),
		DaysOffset int default (-1)
	)
begin

	declare @daysOffset int = -1
	declare @found bit = 0
	declare @i int
	declare @currentDate Date = @StartDate

	set @currentDate = dbo.GetNextDateForMonthOption1(@iDay, @currentDate)

	while ((@EndDate is null) or (@currentDate <= @EndDate))
	begin
		declare @nextDate DATE= dbo.GetNextDateForMonthOption1(@iDay, DATEADD(month, @iMonth, @currentDate))
						
		if (@SearchDate > @nextDate)
		begin
			set @currentDate = @nextDate -- skip to next occurrence
		end
		else if (@SearchDate < @currentDate)
		begin
			break
		end
		else begin
			set @i = 0
			while (@i < @NumDays)
			begin
				declare @currentMonthDate DATE = DATEADD(day, @i, @currentDate)
				if ((@SearchDate >= @currentMonthDate) and (@SearchDate < DATEADD(day, @NumDays, @currentDate)))
				begin
					set @DaysOffset = DATEDIFF(day, @currentMonthDate, @SearchDate) + 1
					set @found = 1
					break
				end

				set @i = @i + 1
			end -- of while (@i < @NumDays)
		end
					
		if (@found = 1)
		begin
			break
		end	
		set @currentDate = @nextDate

	end -- while ((@EndDate is null) or (@SearchDate <= @EndDate))

	insert into @Result (Found, DaysOffset) values (@found, @daysOffset)

	return 
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CheckWeeklyAssignmentState]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/15/2016
-- Description:	For translated C# code: see business object 
--				"RelCalendarCalendarTemplateHead.cs";
--				function "CheckWeeklyAssignmentState(DateTime oDate, out int offset)"
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[CheckWeeklyAssignmentState](
		@SearchDate DATE,
		@NumDays int,
		@RecurrencePattern varchar(max),
		@StartDate Date,
		@EndDate Date
		)

RETURNS
@Result Table
	(
		Found bit default (0),
		DaysOffset int default (-1)
	)
begin
	-- <monthly radio="1" day="1" month="1" />
	declare @daysOffset int = -1
	declare @found bit = 0
	declare @i int
	declare @currentDate Date = @StartDate
	
	declare @iWeeks int
	declare @bMonday int
	declare @bTusesday int
	declare @bWednesday int
	declare @bThursday int
	declare @bFriday int
	declare @bSaturday int
	declare @bSunday int

	-- this is a weekly assigment, need to get xml values
	declare @xmlDay xml = @RecurrencePattern
	SELECT  
		@iWeeks = Tbl.Col.value(''@weeks'', ''smallint''),
		@bMonday = Tbl.Col.value(''@mon'', ''smallint''),
		@bTusesday = Tbl.Col.value(''@tue'', ''smallint''),
		@bWednesday = Tbl.Col.value(''@wed'', ''smallint''),
		@bThursday = Tbl.Col.value(''@thu'', ''smallint''),
		@bFriday = Tbl.Col.value(''@fri'', ''smallint''),
		@bSaturday = Tbl.Col.value(''@sat'', ''smallint''),
		@bSunday = Tbl.Col.value(''@sun'', ''smallint'')
	FROM   @xmlDay.nodes(''//weekly'') Tbl(Col)
	
	while ((@EndDate is null) or (@currentDate <= @EndDate))
	begin
		if (@SearchDate > DATEADD(day, 7 + @NumDays, @currentDate))
		begin
			set @currentDate = DATEADD(day, 7 * @iWeeks, @currentDate) -- skip to the next occurrence
		end
		else if (@SearchDate < @currentDate)
		begin
			set @found = 0
			break
		end
		else begin
			set @i = 0
			while (@i < 7)
			begin
				declare @currentWeekDate Date = DATEADD(day, @i, @currentDate)
				declare @dayOfWeek int = DATEPART(WEEKDAY, @currentWeekDate)
				if (@dayOfWeek = 1 and @bSunday <> 0)
				begin
					if (@SearchDate >= @currentWeekDate and @SearchDate < DATEADD(day, @NumDays, @currentWeekDate))
					begin
						set @found = 1
					end
				end
				else if (@dayOfWeek = 2 and @bMonday <> 0)
				begin
					if (@SearchDate >= @currentWeekDate and @SearchDate < DATEADD(day, @NumDays, @currentWeekDate))
					begin
						set @found = 1
					end
				end
				else if (@dayOfWeek = 3 and @bTusesday <> 0)
				begin
					if (@SearchDate >= @currentWeekDate and @SearchDate < DATEADD(day, @NumDays, @currentWeekDate))
					begin
						set @found = 1
					end
				end
				else if (@dayOfWeek = 4 and @bWednesday <> 0)
				begin
					if (@SearchDate >= @currentWeekDate and @SearchDate < DATEADD(day, @NumDays, @currentWeekDate))
					begin
						set @found = 1
					end
				end
				else if (@dayOfWeek = 5 and @bThursday <> 0)
				begin
					if (@SearchDate >= @currentWeekDate and @SearchDate < DATEADD(day, @NumDays, @currentWeekDate))
					begin
						set @found = 1
					end
				end
				else if (@dayOfWeek = 6 and @bFriday <> 0)
				begin
					if (@SearchDate >= @currentWeekDate and @SearchDate < DATEADD(day, @NumDays, @currentWeekDate))
					begin
						set @found = 1
					end
				end
				else if (@dayOfWeek = 7 and @bSaturday <> 0)
				begin
					if (@SearchDate >= @currentWeekDate and @SearchDate < DATEADD(day, @NumDays, @currentWeekDate))
					begin
						set @found = 1
					end
				end

				if (@found = 1)
				begin
					set @daysOffset = DATEDIFF(day, @currentWeekDate, @SearchDate) + 1
					break
				end
				set @i = @i + 1
			end -- of while (@i < 7)
			
			set @currentDate = DATEADD(day, 7 * @iWeeks, @currentDate)
		end
						
		if (@found = 1)
			break

	end -- of while ((@EndDate is null) or (@SearchDate <= @EndDate))

	insert into @Result (Found, DaysOffset) values (@found, @daysOffset)

	return 
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetStartEndTime]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/11/2016
-- Description:	Returns the start time and end time and are the 
--				number of minutes after mid night.
--
--				The below function is a emulation of the C# code 
--				found in “CalendarUtilities.cs”; functions 
--				“GetStartTime” and “GetEndTime”.
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[GetStartEndTime](
		@CalendarUid uniqueidentifier,	-- calendar to be searched
		@SearchDate DATE				-- date to find start time and end time
		)

RETURNS
@StartEndTime table
(
	StartTime int,			-- number of minutes after mid night
	EndTime int,			-- number of minutes after mid night
	DisplayInterval int,	-- number of minutes in an appointment slot
	IsOpen bit default (0),
	CalendarTemplateDayUid uniqueidentifier
)
AS
begin
	declare @found bit = 0
	declare @RecurrencePattern varchar(max)
	declare @StartDate Date
	declare @EndDate Date
	declare @NumDays int
	declare @CalendarTemplateHeadUid uniqueidentifier
	declare @DaysOffset int = -1

	declare rel_cursor cursor for 
			select rel.RecurrencePattern, rel.StartDate, rel.EndDate, lcth.NumDays, lcth.CalendarTemplateHeadUid
			from RelCalendarCalendarTemplateHead rel
				inner join ListCalendarTemplateHead lcth on rel.CalendarTemplateHeadUid = lcth.CalendarTemplateHeadUid
			where rel.CalendarUid = @CalendarUid 
				and rel.StartDate <= @SearchDate 
				and (rel.EndDate >= @SearchDate or rel.EndDate is null)
			order by rel.ZIndex desc

	open rel_cursor

	fetch NEXT from rel_cursor into @RecurrencePattern, @StartDate, @EndDate, @NumDays, @CalendarTemplateHeadUid

	while (@@fetch_status <> -1)
	begin
		if (@@fetch_status <> -2)
		begin
			-- While loop is based on C# code: see business object "RelCalendarCalendarTemplateHead.cs";
			-- function "GetCalendarTemplateDay(DateTime oDate)"

			if (@RecurrencePattern is null) -- continuous
			begin
				set @DaysOffset = DATEDIFF(day, @StartDate, @SearchDate) + 1
				if (@DaysOffset > @NumDays)
				begin
					set @DaysOffset = @DaysOffset % @NumDays
					if (@DaysOffset = 0)
					begin
						set @DaysOffset = @NumDays
					end
				end
				set @found = 1
			end
			else if (SUBSTRING(@RecurrencePattern, 1, 2) = ''<w'') -- weekly
			begin
				select @found = Found, @DaysOffset = DaysOffset 
						from dbo.CheckWeeklyAssignmentState(@SearchDate, @NumDays, @RecurrencePattern, @StartDate, @EndDate)
			end
			else if (SUBSTRING(@RecurrencePattern, 1, 2) = ''<m'') -- monthly
			begin
				set @DaysOffset = -1;
				declare @xmlMonthly xml = @RecurrencePattern

				declare @option1 int
				declare @iDay int
				declare @iMonth int
				declare @gPrefix uniqueidentifier
				declare @gUnit uniqueidentifier
				
				-- get xml data
				SELECT 
					@option1 = Tbl.Col.value(''@radio'', ''smallint''),
					@iDay = Tbl.Col.value(''@day'', ''smallint''),
					@iMonth = Tbl.Col.value(''@month'', ''smallint''),
					@gPrefix = Tbl.Col.value(''@prefix'', ''uniqueidentifier''),
					@gUnit = Tbl.Col.value(''@unit'', ''uniqueidentifier'')
				FROM @xmlMonthly.nodes(''//monthly'') Tbl(Col)

				if (@option1 = 1)
				begin
					select @found = Found, @DaysOffset = DaysOffset 
						from dbo.CheckMonthlyAssignmentStateOption1(@SearchDate, @NumDays, @iDay, @iMonth, @StartDate, @EndDate)
				end
				else begin
					-- <monthly radio="2" month="1" prefix="2a68f31d-1a22-4384-8ae7-ace1488bbd72" unit="b3121d9e-9769-4831-8f4e-0678e3f49c13" />
					select @found = Found, @DaysOffset = DaysOffset 
						from dbo.CheckMonthlyAssignmentStateOption2(@SearchDate, @NumDays, @iMonth, @gPrefix, @gUnit, @StartDate, @EndDate)
				end

			end -- of if (SUBSTRING(@RecurrencePattern, 1, 2) = ''<m'')
			else if (SUBSTRING(@RecurrencePattern, 1, 2) = ''<d'')
			begin
				set @found = 1
				break
			end -- of if (SUBSTRING(@RecurrencePattern, 1, 2) = ''<d'')
		end
	
		if (@found = 1)
			break

		fetch NEXT from rel_cursor into @RecurrencePattern, @StartDate, @EndDate, @NumDays, @CalendarTemplateHeadUid

	end -- of while
		
	close rel_cursor
	deallocate rel_cursor

	declare @StartTime int
	declare @EndTime int
	declare @DisplayInterval int
	declare @IsOpen bit = 1
	declare @CalendarTemplateDayUid uniqueidentifier

	select @StartTime = lctd.StartTime, @IsOpen = lctd.IsOpen, @CalendarTemplateDayUid = lctd.CalendarTemplateDayUid
		from ListCalendarTemplateDay lctd
		where lctd.CalendarTemplateHeadUid = @CalendarTemplateHeadUid
			and lctd.Inactive = 0
			and lctd.TemplateDay = @DaysOffset
	
	if (@StartTime is null)
	begin
		select @StartTime = lcth.StartTime
		from ListCalendarTemplateHead lcth
		where lcth.CalendarTemplateHeadUid = @CalendarTemplateHeadUid
		and lcth.Inactive = 0
	end

	if (@StartTime is null)
	begin
		select @StartTime = lc.StartTime
		from ListCalendar lc 
		where lc.CalendarUid = @CalendarUid
			and lc.Inactive = 0
	end

	select @EndTime = lctd.EndTime, @IsOpen = lctd.IsOpen
		from ListCalendarTemplateDay lctd
		where lctd.CalendarTemplateHeadUid = @CalendarTemplateHeadUid
			and lctd.Inactive = 0
			and lctd.TemplateDay = @DaysOffset
	
	if (@EndTime is null)
	begin
		select @EndTime = lcth.EndTime
		from ListCalendarTemplateHead lcth
		where lcth.CalendarTemplateHeadUid = @CalendarTemplateHeadUid
		and lcth.Inactive = 0
	end

	if (@EndTime is null)
	begin
		select @EndTime = lc.EndTime
		from ListCalendar lc 
		where lc.CalendarUid = @CalendarUid
			and lc.Inactive = 0
	end

	select @DisplayInterval = lcth.DisplayInterval
	from ListCalendarTemplateHead lcth
	where lcth.CalendarTemplateHeadUid = @CalendarTemplateHeadUid
		and lcth.Inactive = 0

	if (@DisplayInterval is null)
	begin
		select @DisplayInterval = lc.DisplayInterval
		from ListCalendar lc 
		where lc.CalendarUid = @CalendarUid
			and lc.Inactive = 0
	end

	insert into @StartEndTime (StartTime, EndTime, DisplayInterval, IsOpen, CalendarTemplateDayUid)
		values (@StartTime, @EndTime, @DisplayInterval, @isOpen, @CalendarTemplateDayUid)

	return
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FindOpenSlotOnCalendar]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/11/2016
-- Description:	
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[FindOpenSlotOnCalendar](
		@CalendarUid uniqueidentifier,			-- calendar to be searched
		@AppointmentTypeUid uniqueidentifier,	-- appointment type
		@SearchDate DATETIME,					-- if null will be populated with the current date
		@LookForAppoinmentTypeOnly bit,			-- when this value is null or zero this function
												-- will return any appointment type that has the
												-- the correct duration
		@LastEndDateTime datetime
		)

RETURNS
@OpenSlotResults table
(
	StartDateTime datetime,
	EndDateTime datetime,
	Duration int, -- in minutes
	AppointmentTypeUid uniqueidentifier,
	IsCalendarActive bit default (1)
)
AS
begin

	declare @startTime int -- minutes after mid-night
	declare @endTime int -- minutes after mid-night
	declare @displayInterval int -- time slot intervals in minutes

	if (@SearchDate is null)
		set @SearchDate = GetDate()

	declare @isOpen bit = 1
	declare @CalendarTemplateDayUid uniqueidentifier
	
	-- find one day''s calendar
	select	@isOpen = IsOpen, 
			@startTime = StartTime, 
			@endTime = EndTime, 
			@displayInterval = DisplayInterval, 
			@CalendarTemplateDayUid = CalendarTemplateDayUid
			from dbo.GetStartEndTime(@CalendarUid, @SearchDate)

	-- create temp working table
	declare @AvailableAppointmentTimeSlots table
	(
		StartTime int, -- minutes after mid-night
		EndTime int, -- minutes after mid-night
		StartDateTime datetime,
		EndDateTime datetime,
		Duration int, -- in minutes
		IsOpen bit default (0),
		Blocked bit default (0),
		AppointmentTypeUid uniqueidentifier,
		AppointmentStatusUid uniqueidentifier
	)

	-- fill in all possible time slots
	declare @timeCnt int = @startTime
	while @timeCnt + @displayInterval < @endTime
	begin
		insert into @AvailableAppointmentTimeSlots 
					(
						StartTime,
						EndTime,
						StartDateTime, 
						EndDateTime,
						Duration,
						IsOpen,
						Blocked
					)
			values	(
						@timeCnt,
						@timeCnt + @displayInterval,
						DATEADD(MINUTE, @timeCnt, convert(datetime, convert(date, @searchDate))), 
						DATEADD(MINUTE, @timeCnt + @displayInterval, convert(datetime, convert(date, @searchDate))),
						@displayInterval,
						@IsOpen,
						0
					)
		set @timeCnt = @timeCnt + @displayInterval
	end
	
	-- populate day slots; if they exists
	if (@CalendarTemplateDayUid is not null)
	begin

		declare @daySlotStartTime int
		declare @daySlotEndTime int
		declare @daySlotAppointmentTypeUid uniqueidentifier
		declare @daySlotBlocking bit
	
		declare dayslot_cursor cursor for 		
			select	lctds.StartTime, lctds.EndTime, lctds.AppointmentTypeUid
			from ListCalendarTemplateDaySlot lctds 
			where CalendarTemplateDayUid = @CalendarTemplateDayUid

		open dayslot_cursor
		fetch NEXT from dayslot_cursor into @daySlotStartTime, @daySlotEndTime, @daySlotAppointmentTypeUid

		while (@@fetch_status <> -1)
		begin
			if (@@fetch_status <> -2)
			begin
				select @daySlotBlocking = lpt.Blocking from ListAppointmentType lpt where lpt.AppointmentTypeUid = @daySlotAppointmentTypeUid
	
				declare @nextEndTime int = @daySlotStartTime

				while @nextEndTime < @daySlotEndTime
				begin
					set @nextEndTime = @nextEndTime + @displayInterval
				end 

				update aapts SET aapts.AppointmentTypeUid = @daySlotAppointmentTypeUid, aapts.Blocked = ISNULL(@daySlotBlocking, 0)
					from @AvailableAppointmentTimeSlots aapts
					where aapts.StartTime >= @daySlotStartTime and aapts.EndTime <= @nextEndTime
			end
			fetch NEXT from dayslot_cursor into @daySlotStartTime, @daySlotEndTime, @daySlotAppointmentTypeUid
		end -- of while
		
		close dayslot_cursor
		deallocate dayslot_cursor

	end

	-- populate appointments
	update aats SET AppointmentStatusUid = a.AppointmentStatusUid
		from Appointment a 
			inner join @AvailableAppointmentTimeSlots aats on dbo.ConvertUTCToLocalTime(a.StartDateTime) >= aats.StartDateTime
				and dbo.ConvertUTCToLocalTime(a.EndDateTime) <= aats.EndDateTime 
		where a.CalendarUid = @CalendarUid

	-- remove any canceled appointment status
	update aats SET AppointmentStatusUid = null
		from @AvailableAppointmentTimeSlots aats
			inner join ListAppointmentStatus lps on lps.AppointmentStatusUid = aats.AppointmentStatusUid
		where lps.IsCanceledStatus = 1
	
	-- find an open slot
	-- get the time required for the appointment type
	declare @RequiredDuration int

	select @RequiredDuration = Duration from ListAppointmentType where AppointmentTypeUid = @AppointmentTypeUid

	-- find "back to back" appointment slots that match the required time for the appointment type

	declare @foundStartDateTime datetime
	declare @foundAppointmentTypeUid uniqueidentifier

	declare @testDuration int = 0
	declare @loopStartDateTime datetime
	declare @loopEndDateTime datetime
	declare @loopDuration int
	declare @loopAppointmentStatusUid uniqueidentifier
	declare @loopAppointmentTypeUid uniqueidentifier
	declare @loopIsOpen bit = 0
	declare @loopBlocked bit = 0

	declare search_cursor cursor for 
		select StartDateTime, EndDateTime, Duration, AppointmentTypeUid, AppointmentStatusUid, IsOpen, Blocked
		from @AvailableAppointmentTimeSlots
		where (@LastEndDateTime is null) or ((@LastEndDateTime is not null) and (EndDateTime > @LastEndDateTime))
	
	open search_cursor
	fetch NEXT from search_cursor into @loopStartDateTime, @loopEndDateTime, @loopDuration, @loopAppointmentTypeUid,
								@loopAppointmentStatusUid, @loopIsOpen, @loopBlocked

	while (@@fetch_status <> -1)
	begin
		if (@@fetch_status <> -2)
		begin
			if ((@loopAppointmentStatusUid is null) and (@loopIsOpen = 1) and (ISNULL(@loopBlocked, 0) = 0))
			begin
				if (@testDuration = 0)
				begin
					set @foundStartDateTime = @loopStartDateTime
					set @foundAppointmentTypeUid = @loopAppointmentTypeUid
				end

				if ((ISNULL(@LookForAppoinmentTypeOnly, 0) = 0) OR
					((ISNULL(@LookForAppoinmentTypeOnly, 0) = 1) and (@loopAppointmentTypeUid = @AppointmentTypeUid)))
				begin
					set @testDuration = @testDuration + @loopDuration
				end
			end
			else begin
				set @testDuration = 0
				set @foundStartDateTime = null
				set @foundAppointmentTypeUid = null
			end
		end
	
		if ((@loopAppointmentStatusUid is null) and (@testDuration >= @RequiredDuration))
		begin
			break
		end
		
		fetch NEXT from search_cursor into @loopStartDateTime, @loopEndDateTime, @loopDuration, @loopAppointmentTypeUid,
									@loopAppointmentStatusUid, @loopIsOpen, @loopBlocked

	end -- of while
		
	close search_cursor
	deallocate search_cursor

	if (@testDuration > 0)
	begin
		insert into @OpenSlotResults(StartDateTime, EndDateTime, Duration, AppointmentTypeUid)
			values (@foundStartDateTime, dateadd(minute, @RequiredDuration, @foundStartDateTime), @RequiredDuration, @foundAppointmentTypeUid)
	end

	RETURN
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[OpenSlotCalendarAppointment]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

-- =================================================================
-- Author:		CHM
-- Create date: 02/17/2016
-- Description:	Returns an open slot for a calendar and appointment
--				type.
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[OpenSlotCalendarAppointment](
	@SearchStartDate DateTime,				-- date to "begin" looking for an open appointment
											-- if "null" will be today
	@SearchEndDate DateTime,				-- date to "end" looking for an open appointment
											-- if "null" will be a 365 days after the "begin" date
	@LookForAppoinmentTypeOnly bit,			-- when this value is null or zero this function
											-- will return any appointment type that has the
											-- the correct duration
	@CalendarUid uniqueidentifier,			-- calendar to be searched
	@AppointmentTypeUid uniqueidentifier,	-- appointment type to look for an open slot
	@OpenSlotOption int,					-- "1" = found first slot; "2" = found second slot;
											-- "3" = found third slot
											-- when "ReturnAllOpenSlots" is not "1" and "OpenSlotOption"
											-- is "null" or greater than "3" then it will be set to 
											-- a default value of "3" 
	@ReturnAllOpenSlots bit                 -- when "1" will return the number of open appointment
											-- slots defined in "OpenSlotOption" max return is "50"
		)

RETURNS
@Results table
	(
		CalendarName varchar(255),
		AppointmentTypeName varchar(255),
		AppointmentStartDateTime datetime,
		WaitTimeInDays decimal(14,3),
		ResultText varchar(30)
	)
AS
begin

	declare @ResultText varchar(30)
	declare @CalendarName varchar(255) = (select Name from ListCalendar where CalendarUid = @CalendarUid)
	declare @AppointmentTypeName varchar(255) = (select Name from ListAppointmentType where AppointmentTypeUid = @AppointmentTypeUid)
	declare @SearchDate datetime = @SearchStartDate
	declare @StartDateTime datetime
	declare @LastEndDateTime datetime
	declare @OpenSlotCount int = 0
	declare @found bit = 0

	if (@SearchStartDate is null)
	begin
		set @SearchStartDate = GETDATE()
	end
	if (@SearchEndDate is null)
	begin
		set @SearchEndDate = DATEADD(day, 365, @SearchStartDate)
	end


	if ((ISNULL(@ReturnAllOpenSlots, 0) = 0) and ((@OpenSlotOption is null) or (@OpenSlotOption > 3)))
	begin
		set @OpenSlotOption = 3
	end
	if ((ISNULL(@ReturnAllOpenSlots, 0) = 1) and (@OpenSlotOption is null))
	begin
		set @OpenSlotOption = 3
	end
	if ((ISNULL(@ReturnAllOpenSlots, 0) = 1) and (@OpenSlotOption > 50))
	begin
		set @OpenSlotOption = 50
	end

	if ((ISNULL(@LookForAppoinmentTypeOnly, 0) = 1) 
		AND (@AppointmentTypeUid is not null)
		AND (@CalendarUid is not null))
	begin
		declare @tempCnt int

		---- is appointment type in calendar
		select @tempCnt = COUNT(*) from ListCalendarTemplateDaySlot lctds
		inner join ListCalendarTemplateDay lctd on lctds.CalendarTemplateDayUid = lctd.CalendarTemplateDayUid
		inner join RelCalendarCalendarTemplateHead rccth on lctd.CalendarTemplateHeadUid = rccth.CalendarTemplateHeadUid
		where rccth.CalendarUid = @CalendarUid and lctds.AppointmentTypeUid = @AppointmentTypeUid 
				and ((rccth.StartDate <= @SearchStartDate and rccth.EndDate is null)
				or (rccth.StartDate <= @SearchStartDate and rccth.EndDate >= @SearchEndDate))

		-- not in calendar; no need to continue
		if (@tempCnt = 0)
		begin
			insert into @Results (
					CalendarName,
					AppointmentTypeName,
					ResultText
				)
			values (
					@CalendarName,
					@AppointmentTypeName,
					''not found''
				)

			return
		end
	end
		
	--declare @dayCount int = 0

	if (ISNULL(@ReturnAllOpenSlots, 0) = 0)
	begin
		if (@OpenSlotOption = 1)
			set @ResultText = ''slot 1''
		else if (@OpenSlotOption = 2)
			set @ResultText = ''slot 2''
		else
			set @ResultText = ''slot 3''
	end
	while ((@SearchDate <= @SearchEndDate) and (@OpenSlotCount < @OpenSlotOption))
	begin
		--set @dayCount = @dayCount + 1
		set @found = 0
		set @StartDateTime = null
		select @StartDateTime = StartDateTime, @LastEndDateTime = EndDateTime 
			from dbo.FindOpenSlotOnCalendar (@CalendarUid, @AppointmentTypeUid, @SearchDate, @LookForAppoinmentTypeOnly, @LastEndDateTime)

		if (@StartDateTime is not null)
		begin
			-- skip times of day that have already passed
			if (CONVERT(decimal(14,3), DATEDIFF(SECOND, @SearchStartDate, @StartDateTime) / 86400.0) > 0)
			begin
				set @OpenSlotCount = @OpenSlotCount + 1 
				if ((@OpenSlotCount = @OpenSlotOption) or (ISNULL(@ReturnAllOpenSlots, 0) = 1))
				begin
					if (ISNULL(@ReturnAllOpenSlots, 0) = 1)
					begin
						set @ResultText = ''slot '' + convert(varchar(20), @OpenSlotCount)
					end

					insert into @Results (
						CalendarName,
						AppointmentTypeName,
						AppointmentStartDateTime,
						WaitTimeInDays,
						ResultText
						)
					values (
						@CalendarName,
						@AppointmentTypeName,
						@StartDateTime,
						CONVERT(decimal(14,3), DATEDIFF(SECOND, @SearchStartDate, @StartDateTime) / 86400.0),
						@ResultText
						)
					set @found = 1
				end
			end 
		end
		if (@found = 0)
		begin
			-- try the next day
			set @SearchDate = DATEADD(day, 1, @SearchDate)
			-- when looking for an appointment type and none is found in the first 30 days; exit
			--if ((ISNULL(@LookForAppoinmentTypeOnly, 0) = 1) and (@dayCount > 30))
			--begin
			--	break
			--end
		end
	end -- end of while ((@SearchDate <= @SearchEndDate) and (@OpenSlotCount < @OpenSlotOption))

	if ((select count(*) from @Results) = 0)
	begin		
		insert into @Results (
			CalendarName,
			AppointmentTypeName,
			ResultText
		)
		values (
			@CalendarName,
			@AppointmentTypeName,
			''not found''
		)
	end

	return
end



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AppointmentAvailabilityReport]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/22/2016
-- Description:	Returns a table of Appointment Availability Report
--				based on supplied parameters.
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[AppointmentAvailabilityReport](
	@SearchStartDate Date,					-- date to "begin" looking for an open appointment
											-- if "null" will be today
	@SearchEndDate Date,					-- date to "end" looking for an open appointment
											-- if "null" will be a 365 days after the "begin" date
	@LookForAppoinmentTypeOnly bit,			-- when this value is null or zero this function
											-- will return any appointment type that has the
											-- the correct duration
	@CalendarUidList varchar(max),			-- list of calendar uids (separated by a semicolon)
											-- to be searched, when null will search all calendars
	@AppointmentTypeUidList varchar(max),	-- list of appointment type uids (separated by a semicolon)
											-- to be searched, when null will search all appointment types
	@OpenSlotOption int,					-- "1" = found first slot; "2" = found second slot;
											-- "3" = found third slot
											-- when "ReturnAllOpenSlots" is not "1" and "OpenSlotOption"
											-- is "null" or greater than "3" then it will be set to 
											-- a default value of "3" 
	@ReturnAllOpenSlots bit                 -- when "1" will return the number of open appointment
											-- slots defined in "OpenSlotOption" max return is "50"
											)
RETURNS
@Results table
	(
		CalendarName varchar(255),
		AppointmentTypeName varchar(255),
		AppointmentStartDateTime datetime,
		WaitTimeInDays decimal(14,3),
		ResultText varchar(30)
	)
AS BEGIN

	declare @CalendarUids table
	(
		CalendarUid uniqueidentifier
	)

	INSERT		@CalendarUids
	SELECT		* 
	FROM		dbo.SplitList_Uids(@CalendarUidList, '','')
	
	declare @AppointmentTypeUids table
	(
		AppointmentTypeUid uniqueidentifier
	)

	INSERT		@AppointmentTypeUids
	SELECT		* 
	FROM		dbo.SplitList_Uids(@AppointmentTypeUidList, '','')
	
	declare @CalendarUid uniqueidentifier
	declare @AppointmentTypeUid uniqueidentifier

	if (@SearchStartDate is null)
	begin
		set @SearchStartDate = GETDATE()
	end
	if (@SearchEndDate is null)
	begin
		set @SearchEndDate = DATEADD(day, 365, @SearchStartDate)
	end

	declare cal_cursor cursor for 
		select CalendarUid 
		from ListCalendar 
		where Inactive = 0
		and ((@CalendarUidList is null) or (CalendarUid in (select CalendarUid from @CalendarUids)))
		order by Name
			
	open cal_cursor

	fetch NEXT from cal_cursor into @CalendarUid

	while (@@fetch_status <> -1)
	begin
		if (@@fetch_status <> -2)
		begin
		
			declare type_cursor cursor for 
				select AppointmentTypeUid 
				from ListAppointmentType 
				where Inactive = 0 and Blocking = 0
				and ((@AppointmentTypeUidList is null) or (AppointmentTypeUid in (select AppointmentTypeUid from @AppointmentTypeUids)))
				order by Name
			
			open type_cursor

			fetch NEXT from type_cursor into @AppointmentTypeUid

			while (@@fetch_status <> -1)
			begin
				if (@@fetch_status <> -2)
				begin			
					insert into @Results (CalendarName, AppointmentTypeName, AppointmentStartDateTime, WaitTimeInDays, ResultText)
						select CalendarName, AppointmentTypeName, AppointmentStartDateTime, WaitTimeInDays, ResultText 
						from dbo.OpenSlotCalendarAppointment(@SearchStartDate, @SearchEndDate, @LookForAppoinmentTypeOnly, 
										@CalendarUid, @AppointmentTypeUid, @OpenSlotOption, @ReturnAllOpenSlots)
				end

				fetch NEXT from type_cursor into @AppointmentTypeUid
			end -- of while

			close type_cursor
			deallocate type_cursor
		end
		
		fetch NEXT from cal_cursor into @CalendarUid
	end -- of while

	close cal_cursor
	deallocate cal_cursor

	return
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_GetTransactionAggregate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[AR_GetTransactionAggregate](@transactionUid uniqueidentifier)
RETURNS @retTable TABLE 
(
    InsAdjustment MONEY,
    PatientAdjustment MONEY,
    PatientTransfer MONEY,
	InsTransfer MONEY
)
AS
BEGIN

	-- Bug 55495:Opening an existing deposit takes about 30seconds to 1 minute top open
	-- Changed call to AR_ViewTransactionsByDeposit to use this so can optimize fetch of transaction aggregates
	-- Otherwise query below and AR_ViewTransactionDeposits pull ALL financials before doing join in AR_ViewTransactionsByDeposit

	INSERT @retTable (InsAdjustment, PatientAdjustment, PatientTransfer, InsTransfer)
		SELECT InsAdjustment, PatientAdjustment, PatientTransfer, InsTransfer FROM AR_ViewTransactionAggregateSub 
		WHERE TransactionUid = @transactionUid
	 
	RETURN ;
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_GetTransactionBatches]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[AR_GetTransactionBatches](@transactionUid uniqueidentifier)
RETURNS @retTable TABLE 
(
    transactionUid uniqueidentifier,
    BatchUids varchar(250),
	BatchNames varchar(250),
	BatchStates varchar(80)
)
AS
BEGIN

	DECLARE @ARBatchUids varchar(MAX) 
	DECLARE @ARBatchNames varchar(MAX)
	DECLARE @ARBatchStates varchar(MAX)
	
	
	 -- Get all ledger entries associated with this superbill''s procedures
	 DECLARE @batchTable TABLE
	 (
	   ARBatchUid uniqueidentifier,
	   Name varchar(255),
	   IsLocked bit,
	   IsClosed bit,
	   GLDate datetime
	 ) ;
	 
	 -- Find batch ledger entries
	 INSERT @batchTable(ARBatchUid, Name, IsLocked, IsClosed, GLDate)
		select distinct arb.ARBatchUid, arb.Name, arb.IsClosed, arb.IsLocked, arb.GLDate
		from AR_LedgerDetail ld
			inner join AR_Ledger l on ld.ledgerUid = l.ledgeruid 
				inner join ARBatch arb on l.ArBatchUid = arb.ARBatchUid
		where l.TransactionUid = @transactionUid
		
	 -- Loop 
	 DECLARE @uid uniqueidentifier
	 DECLARE @name VARCHAR(255)
	 DECLARE @isLocked bit
	 DECLARE @isClosed bit
	 DECLARE @isOpen bit
	 
	 select @ARBatchUids = null,
	        @ARBatchNames = null,
	        @isLocked = 0,  -- Complete
	        @isClosed = 0,  -- Closed
	        @isOpen = 0     -- Open

	 select @ARBatchUids = CASE WHEN @ARBatchUids IS NULL THEN CONVERT(VARCHAR(36), bt.ARBatchUid) ELSE '','' + CONVERT(VARCHAR(36), bt.ARBatchUid) END,
	        @ARBatchNames = CASE WHEN @ARBatchNames IS NULL THEN CONVERT(VARCHAR(255), bt.Name) ELSE '','' + CONVERT(VARCHAR(255), bt.Name) END,
	        @isOpen   = CASE WHEN (bt.IsLocked = 0 AND bt.IsClosed = 0) THEN 1 ELSE @isOpen END,
	        @isLocked = CASE WHEN bt.IsLocked = 1 THEN 1 ELSE @isLocked END,
	        @isClosed = CASE WHEN bt.IsClosed = 1 THEN 1 ELSE @isClosed END
	 FROM @batchTable bt
	 ORDER BY GLDate DESC
	 
	 DECLARE @batchStates varchar(80)
	 select @batchStates = CASE WHEN @isOpen = 1 THEN ''Open'' ELSE '''' END
	 SELECT @batchStates = CASE WHEN @isLocked = 1 AND @batchStates = '''' THEN ''Locked''
	                            WHEN @isLocked = 1 AND @batchStates != '''' THEN '', Locked'' 
	                            ELSE @batchStates END
	 SELECT @batchStates = CASE WHEN @isClosed = 1 AND @batchStates = '''' THEN ''Closed''
	                            WHEN @isClosed = 1 AND @batchStates != '''' THEN '', Closed'' 
	                            ELSE @batchStates END
	 
	 INSERT @retTable(transactionUid, BatchUids,BatchNames, BatchStates)
	   SELECT @transactionUid, @ARBatchUids, @ARBatchNames, @batchStates
	 
  return ;
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_GetTransactionDeposits]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[AR_GetTransactionDeposits](@transactionUid uniqueidentifier)
RETURNS @retTable TABLE 
(
    transactionUid uniqueidentifier,
    depositUids varchar(250),
    depositNames varchar(250)
)
AS
BEGIN

	DECLARE @depositUids varchar(MAX) 
	DECLARE @depositNames varchar(MAX)
	
	 -- Get all ledger entries associated with this superbill''s procedures
	 DECLARE @dTable TABLE
	 (
	   depositUid uniqueidentifier,
	   Name varchar(255),
	   depositDate datetime
	 ) ;
	 
	 -- Find batch ledger entries
	 INSERT @dTable(depositUid, Name, depositDate)
		select distinct ld.DepositUid, d.ReferenceNumber, d.DepositDate
		from AR_LedgerDetail ld
			inner join AR_Ledger l on ld.ledgerUid = l.ledgeruid 
				inner join Deposit d on ld.DepositUid = d.DepositUid
		where l.TransactionUid = @transactionUid
			 
	 select @depositUids = null,
	        @depositNames = null

	 select @depositUids = CASE WHEN @depositUids IS NULL THEN CONVERT(VARCHAR(36), dt.depositUid) ELSE '','' + CONVERT(VARCHAR(36), dt.depositUid) END,
	        @depositNames = CASE WHEN @depositNames IS NULL THEN CONVERT(VARCHAR(255), dt.Name) ELSE '','' + CONVERT(VARCHAR(255), dt.Name) END
	 FROM @dTable dt
	 ORDER BY dt.depositDate DESC
	 	 
	 INSERT @retTable(transactionUid, depositUids, depositNames)
	   SELECT @transactionUid, @depositUids, @depositNames
	 
  return ;
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_SuperbillProcedureBatch]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[AR_SuperbillProcedureBatch]
(
	@superbillFilterXml XML
)
RETURNS 
@SuperbillProcedureBatchTable TABLE 
(
	SuperbillUid UNIQUEIDENTIFIER, 
	SuperbillProcedureUid UNIQUEIDENTIFIER, 
	ArBatchUid UNIQUEIDENTIFIER, 
	ArBatchName VARCHAR(255), 
	ArBatchPostingDate DATETIME
)
AS
BEGIN

	DECLARE @SuperbillFilterTable TABLE
	(
		SuperbillUid UNIQUEIDENTIFIER
	)
	INSERT @SuperbillFilterTable
		SELECT	x.n.value (''@SuperbillUid'', ''UNIQUEIDENTIFIER'') AS SuperbillUid
			FROM @superbillFilterXml.nodes(''Superbills/Superbill'') AS x(n)

	INSERT INTO @SuperbillProcedureBatchTable
		SELECT SuperbillUid, SuperbillProcedureUid, ArBatchUid, 
						ArBatchName, ArBatchPostingDate
			FROM (SELECT VSPBS.SuperbillUid, VSPBS.SuperbillProcedureUid, VSPBS.ArBatchUid, 
							VSPBS.ArBatchName, VSPBS.ArBatchPostingDate,
						RANK() OVER (PARTITION BY SuperbillProcedureUid, CreatedDateTime ORDER BY CreatedDateTime DESC) AS RankValue    
						FROM @SuperbillFilterTable SBFT
							INNER JOIN AR_ViewSuperbillProcedureBatchSub (NOEXPAND) VSPBS ON SBFT.SuperbillUid = VSPBS.SuperbillUid) RANKED 
			WHERE RANKED.RankValue = 1

	RETURN 
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARFN_getBatchFinancialStatus]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[ARFN_getBatchFinancialStatus]  
(  
 @endDate DATETIME,   
 @financialCenterUids VARCHAR(8000)      
)   
RETURNS INT   
AS  
BEGIN  
   
 /*   
 For an end date and optional Financial Center filter (otherwise uses all)  
  returns ...  
    -1 - All Specified Financial Centers Closed Through End Date  
  0 - All Batches Closed Through End Date  
  1 - Not Closed But No Unallocated  
  2 - Not Closed And Unallocated Exist  
 */  
  
 DECLARE @retVal INT  
 SELECT @retVal = 2 -- default to worst case  
  
 DECLARE @ArBatches TABLE                       
 (                            
  ArBatchUid UNIQUEIDENTIFIER                         
 )     
  
 IF  @endDate IS NULL  
  SELECT @endDate = GetDate()  
SELECT @endDate =  DATEADD(DAY,1,@endDate)

 IF NOT (@financialCenterUids IS NULL OR @financialCenterUids = '''')  
 BEGIN  
  IF NOT EXISTS(SELECT FC.FinancialCenterUid FROM FinancialCenter FC  
   WHERE (FC.FinancialCenterUid IN (SELECT Element FROM Split(@financialCenterUids, '',''))) -- get only the specified financial centers  
    --AND cast(convert(varchar, ISNULL(ArClosedThroughDate,''1900-01-01''), 101) AS datetime) < @endDate) -- where close date < end date  
    and (ArClosedThroughDate is null or ArClosedThroughDate <@endDate))
  BEGIN  
   SELECT @retVal = -1  
  END  
 END  
  
 IF @retVal > -1 -- did not pass preliminary financial center test  
 BEGIN      
  INSERT INTO @ArBatches -- get open batches <= end date               
  SELECT ARB.ARBatchUid  
  FROM ArBatch ARB                      
  WHERE ARB.IsClosed = 0 --and cast(convert(varchar, ARB.GlDate, 101) AS datetime) <= @endDate  
  and ARB.GlDate <= @endDate
                         
  IF NOT EXISTS(SELECT ARBatchUid FROM @ArBatches) -- all batches are closed  
   SELECT @retVal = 0  
  ELSE  
  BEGIN  
   IF NOT EXISTS(SELECT DP.DepositUid FROM Deposit DP  
    LEFT JOIN AR_ViewDepositAggregate VD ON DP.DepositUid=VD.DepositUid          
    INNER JOIN @ArBatches ARBLIST ON DP.ArBatchUid = ARBLIST.ArBatchUid                          
    WHERE DP.Amount != (VD.Receipt - VD.ReceiptBalance) AND (DP.Void is null or DP.Void != 1)) -- no unallocated amounts  
    SELECT @retVal = 1   
   ELSE  
    SELECT @retVal = 2  
  END    
 END  
  
 RETURN @retVal  
  
 /* Testing  
  SELECT dbo.ARFN_getBatchFinancialStatus(null, null)  
  SELECT dbo.ARFN_getBatchFinancialStatus(''1901-01-01'', null)  
  SELECT dbo.ARFN_getBatchFinancialStatus(''1901-01-01'', '''')  
  SELECT dbo.ARFN_getBatchFinancialStatus(''1901-01-01'', ''C0414713-2185-4603-B4D7-1ED361C6951D'')  
  SELECT dbo.ARFN_getBatchFinancialStatus(''1901-01-01'', ''14B99C94-EDAC-47BD-97B9-CF421AC16018'')  
  SELECT dbo.ARFN_getBatchFinancialStatus(''2008-08-01'', ''14B99C94-EDAC-47BD-97B9-CF421AC16018'')  
  SELECT * FROM FinancialCenter  
 */  
  
END  
  


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARFN_getFeeScheduleFee]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[ARFN_getFeeScheduleFee]
	(@feeSchedulePeriodUid uniqueidentifier, 
	@procedureUid uniqueidentifier) 
returns money as
begin
	/*	Returns the unit fee for the given fee schedule period and procedure.

		Equivalent to the code in the biz object FeeScheduleFee.cs property Fee.
	*/

	declare @fee money

	select top 1 @fee = (CASE WHEN fsp.RVUScheduleUid is not null 
							and rsv.RVUScheduleValueUid is not null 
							THEN (((rsv.WorkRVU * rs.WorkGPCI) 
								+ (rsv.RBNonFacilityPERVU * rs.PEGPCI) 
								+ (rsv.MPRVU * rs.MPGPCI)) * rs.ConversionFactor)
							ELSE fsf.Fee END) 
	from 
	FeeSchedule fs 
		inner join FeeSchedulePeriod fsp on fsp.FeeScheduleUid = fs.FeeScheduleUid 
		inner join FeeScheduleFee fsf on fsf.FeeSchedulePeriodUid = fsp.FeeSchedulePeriodUid 
			and fsf.Inactive = 0 
		left join RVUSchedule rs on rs.RVUScheduleUid = fsp.RVUScheduleUid 
		left join RVUScheduleValue rsv on rsv.RVUScheduleUid = rs.RVUScheduleUid 
			and rsv.ProcedureUid = @procedureUid 
			and rsv.Inactive = 0 
	where fsp.FeeSchedulePeriodUid = @feeSchedulePeriodUid 
		and fsf.ProcedureUid = @procedureUid 

	return isnull(round(@fee, 2), 0.00)
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARFN_getFeeSchedulePeriod]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ARFN_getFeeSchedulePeriod]
	(@feeScheduleUid uniqueidentifier, 
	@utcDate datetime) 
returns uniqueidentifier as
begin
	/*	Returns the fee schedule period for the given fee schedule on the given UTC date.

		Equivalent to the code in the biz object FeeSchedule.cs method GetFeeSchedulePeriod.
	*/
	declare @FeeSchedulePeriodUid uniqueidentifier 

	select top 1 @FeeSchedulePeriodUid = FeeSchedulePeriodUid 
	from FeeSchedulePeriod 
	where FeeScheduleUid = @feeScheduleUid 
		and (EffectiveDate is null or EffectiveDate <= @utcDate) 
		and (ExpirationDate is null or ExpirationDate > @utcDate) 
	order by EffectiveDate desc

	return @FeeSchedulePeriodUid
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARFN_getGLDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[ARFN_getGLDate] (@dtCreateDate DATE, @dtCurrentPeriodEnd DATE)
RETURNS DATETIME AS 

BEGIN
	DECLARE @theGLDate DATE
	
	IF (@dtCurrentPeriodEnd > @dtCreateDate) 
		SELECT @theGLDate = @dtCreateDate 
	ELSE 
		SELECT @theGLDate = @dtCurrentPeriodEnd 
	
	RETURN @theGLDate
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARFN_getInsLevelName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ARFN_getInsLevelName]
	(@insLevel INT)
RETURNS VARCHAR(10) AS 
BEGIN
	RETURN (CASE @insLevel 
		WHEN Null THEN '''' 
		WHEN 0 THEN '''' 
		WHEN 1 THEN ''Primary'' 
		WHEN 2 THEN ''Secondary'' 
		WHEN 3 THEN ''Tertiary'' 
		WHEN 4 THEN ''Quaternary'' 
		WHEN 5 THEN ''Quinary'' 
		WHEN 6 THEN ''Senary'' 
		WHEN 7 THEN ''Septary'' 
		WHEN 8 THEN ''Ogdoad'' 
		WHEN 9 THEN ''Ennead'' 
		WHEN 10 THEN ''Decad'' 
		ELSE (CONVERT(VARCHAR(8), @insLevel) + ''th'') END)
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARFN_getLiabilityName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[ARFN_getLiabilityName]
	(@liabilityOwner SMALLINT)
RETURNS VARCHAR(10) AS 
BEGIN
	DECLARE @return VARCHAR(10)
	SELECT @return = Upper(dbo.ARFN_getInsLevelName(@liabilityOwner))
	IF (@return = '''') SELECT @return = ''PATIENT''
	RETURN @return
END






' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARFN_getPlanProviderFeeSchedule]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ARFN_getPlanProviderFeeSchedule]
	(@insurancePlanUid uniqueidentifier, 
	@providerUid uniqueidentifier)
returns uniqueidentifier as
begin
	/*	Returns the fee schedule (carrier schedule, plan schedule, or provider schedule) 
		indicated for the given insurance plan and provider.

		Equivalent to the code in the biz object FeeSchedule.cs method GetPlanProviderFeeSchedule.
	*/
	declare @FeeScheduleUid uniqueidentifier 

	-- Use Carrier Fee Schedule
	select @FeeScheduleUid = ic.FeeScheduleUid 
	from InsurancePlan ip, InsuranceCarrier ic 
	where ip.InsuranceCarrierUid = ic.CorporationUid 
		and ip.UseCarrierFeeSchedule = 1 
		and ic.UseProviderFeeSchedule = 0 

	if (@@rowcount > 0)
		return @FeeScheduleUid

	-- Use Plan Fee Schedule
	select @FeeScheduleUid = ip.FeeScheduleUid 
	from InsurancePlan ip, InsuranceCarrier ic 
	where ip.InsuranceCarrierUid = ic.CorporationUid 
		and ip.UseCarrierFeeSchedule = 0 
		and ip.UseProviderFeeSchedule = 0 

	if (@@rowcount > 0)
		return @FeeScheduleUid

	-- Use Provider Fee Schedule
	select @FeeScheduleUid = FeeScheduleUid from Provider where PersonUid = @providerUid
	return @FeeScheduleUid
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_AR_getClaimFormatUid]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[UDF_AR_getClaimFormatUid] (@ClaimPaper bit, 
												 @PlanUseCarrierElectronicClaimFormat bit, @PlanUseCarrierPaperClaimFormat bit, 
												 @PlanElectronicClaimFormatUid uniqueidentifier, @CarrierElectronicClaimFormatUid uniqueidentifier, 
												 @PlanPaperClaimFormatUid uniqueidentifier, @CarrierPaperClaimFormatUid uniqueidentifier,
												 @PlanUseCarrierPaperClaimDefaultOption bit = 1, @PlanPaperClaimDefaultOptionUid uniqueidentifier = null, @CarrierPaperClaimDefaultOptionUid uniqueidentifier = null, 
												 @insuranceOrder int)
RETURNS uniqueidentifier AS
BEGIN
	declare @ElectronicClaimFormatUid uniqueidentifier, @PaperClaimFormatUid uniqueidentifier, @ClaimFormatUid uniqueidentifier, @PaperClaimDefaultOptionUid uniqueidentifier

	-- ElectronicClaimFormatUid
	if (@PlanUseCarrierElectronicClaimFormat = 1)
		set @ElectronicClaimFormatUid = @CarrierElectronicClaimFormatUid
	else
		set @ElectronicClaimFormatUid = @PlanElectronicClaimFormatUid

	-- PaperClaimformatUid
	if (@PlanUseCarrierPaperClaimFormat = 1)
		set @PaperClaimFormatUid = @CarrierPaperClaimFormatUid
	else
		set @PaperClaimFormatUid = @PlanPaperClaimFormatUid

	-- PaperClaimDefaultOptionUid
	if (@PlanUseCarrierPaperClaimDefaultOption = 1)
		SET @PaperClaimDefaultOptionUid = @CarrierPaperClaimDefaultOptionUid
	else
		SET @PaperClaimDefaultOptionUid = @PlanPaperClaimDefaultOptionUid
	if (@PaperClaimDefaultOptionUid IS NULL)
		SET @PaperClaimDefaultOptionUid = ''5B36F9C3-B1CF-4E80-8541-11397058B723''		-- if not set default is None ( Claims default to electronic )
	
	--
	-- PaperClaimDefaultOption ( from ListMisc.ListType == ''PaperClaimOptions'' )
	--		5B36F9C3-B1CF-4E80-8541-11397058B723	None (Claims default to electronic)
	-- 		9CB84C44-19F5-4F32-809C-3350BBE99ACA	Secondary (Non-primary claims will print)
	-- 		09AA94E4-E72B-499E-BF6E-E5FE9E05D8B8	All (All claims will print)
		
	-- Assume electronic unless told to go to paper
	if ( @ClaimPaper = 1 )		-- claim paper set specifically for superbill
		SET @ClaimFormatUid = @PaperClaimFormatUid
	else
	if ( @PaperClaimDefaultOptionUid = ''09AA94E4-E72B-499E-BF6E-E5FE9E05D8B8'' )		-- All ( All claims will print )
		SET @ClaimFormatUid = @PaperClaimFormatUid
	else
	if ( @PaperClaimDefaultOptionUid = ''5B36F9C3-B1CF-4E80-8541-11397058B723'' )  	-- None ( Claims default to Electronic )
		SET @ClaimFormatUid = @ElectronicClaimFormatUid
	else
	if ( @PaperClaimDefaultOptionUid = ''9CB84C44-19F5-4F32-809C-3350BBE99ACA'' AND	-- Secondary ( Non-primary claims will print )
		 @insuranceOrder != 1 )														-- Current Insurance is Non-primary
		SET @ClaimFormatUid = @PaperClaimFormatUid
	else
		SET @ClaimFormatUid = @ElectronicClaimFormatUid

	return @ClaimFormatUid
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARFN_getSuperbillFeeSchedulePeriod]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ARFN_getSuperbillFeeSchedulePeriod]
	(@superbillUid uniqueidentifier) 
returns uniqueidentifier as
begin
	/*	Returns the fee schedule in force for the given superbill.

		Equivalent to the code in the biz object Superbille.cs property FeeSchedulePeriod.
	*/
	declare @InsurancePlanUid uniqueidentifier, @ProviderUid uniqueidentifier, @SBDate datetime 
	declare @FeeScheduleUid uniqueidentifier, @FeeSchedulePeriodUid uniqueidentifier 

	select @InsurancePlanUid = InsurancePlanUid, 
		@ProviderUid = ClaimingProviderUid, 
		@SBDate = ServiceDateEnd 
	from ViewSuperbillPayer 
	where SuperbillUid = @superbillUid and InsuranceOrder = 1

	if (@@rowcount = 0)
		return null

	set @FeeScheduleUid = dbo.ARFN_getPlanProviderFeeSchedule(@InsurancePlanUid, @ProviderUid) 

	if (@FeeScheduleUid is null)
		return null

	return dbo.ARFN_getFeeSchedulePeriod(@FeeScheduleUid, @SBDate)
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARFN_getSuperbillProcedureUnitFee]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ARFN_getSuperbillProcedureUnitFee]
	(@superbillUid uniqueidentifier, 
	@procedureUid uniqueidentifier) 
returns money as 

begin
	/*	Returns the unit fee for the given superbill and procedure.

		Equivalent to the code in the biz object SuperbillProcedure.cs property SetProcedureCharge.
	*/
	declare @FeeSchedulePeriodUid uniqueidentifier 

	set @FeeSchedulePeriodUid = dbo.ARFN_getSuperbillFeeSchedulePeriod(@superbillUid)
	return dbo.ARFN_getFeeScheduleFee(@FeeSchedulePeriodUid, @procedureUid)
end' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAccountPeriod]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[GetAccountPeriod] (@accountuid uniqueidentifier, @date DATE) RETURNS UNIQUEIDENTIFIER AS
	BEGIN
	
		DECLARE	@accountPeriodUid uniqueidentifier
	
		SELECT TOP 1	@accountPeriodUid = ap.AccountPeriodUid
		FROM		AccountPeriod ap
		WHERE		ap.AccountUid = @accountUid AND
					(ap.EffectiveDate <= @date OR ap.EffectiveDate IS NULL) AND
					(ap.ExpirationDate >= @date OR ap.ExpirationDate IS NULL)
		
	RETURN @accountPeriodUid
	END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsLabProcedure]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[IsLabProcedure]
(
	@procedureUid UNIQUEIDENTIFIER
)
RETURNS BIT
AS
BEGIN

	DECLARE @isLabProcedure BIT
	SELECT @isLabProcedure = 0

	IF EXISTS(SELECT 1 
			FROM ListProcedure
			WHERE ProcedureUid = @procedureUid
				AND ProcedureCodeTypeUid = ''00000000-0000-0000-0000-000000000001'' -- CPT Code
				AND LEN(Code)=5 AND SUBSTRING(Code,1,1)=''8'')
		SELECT @isLabProcedure = 1

	RETURN @isLabProcedure
	
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARFN_SuperbillProcedure_InitialPatientLiabilityTrue]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ARFN_SuperbillProcedure_InitialPatientLiabilityTrue]
(
	@superbillProcedureUid UNIQUEIDENTIFIER
)
RETURNS MONEY 
AS
BEGIN

	DECLARE @totalCharge MONEY -- same initially but needed at end to make certain patient portion does not exceed total
	DECLARE @patientLiability MONEY

	-- default case - patient owes it all
	SELECT @patientLiability = ISNULL(SBP.TotalCharge, 0), @totalCharge = ISNULL(SBP.TotalCharge, 0)
		FROM dbo.SuperbillProcedure SBP 
		WHERE SBP.SuperbillProcedureUid = @superbillProcedureUid
		
	-- Patient typically gets no liability if insured authorizes assignment and practice accepts assignment from plan, etc.
	IF EXISTS(SELECT SBP.SuperbillProcedureUid
				FROM dbo.SuperbillProcedure SBP 
				INNER JOIN dbo.Superbill SB ON SBP.SuperbillUid = SB.SuperbillUid
				INNER JOIN dbo.Account A ON SB.AccountUid = A.AccountUid
				INNER JOIN dbo.AccountPeriod AP ON A.AccountUid = AP.AccountUid
				INNER JOIN dbo.AccountInsurance AI ON AP.AccountPeriodUid = AI.AccountPeriodUid
				INNER JOIN dbo.PersonInsurancePlan PIP ON AI.PersonInsurancePlanUid = PIP.PersonInsurancePlanUid
				INNER JOIN dbo.InsurancePlan IP ON PIP.InsurancePlanUid = IP.InsurancePlanUid
				INNER JOIN dbo.InsuranceCarrier IC ON IP.InsuranceCarrierUid = IC.CorporationUid
				INNER JOIN dbo.ListProcedure LP ON SBP.ProcedureUid = LP.ProcedureUid
				WHERE SBP.SuperbillProcedureUid = @superbillProcedureUid 
					AND AP.AccountPeriodUid = dbo.GetAccountPeriod(SB.AccountUid, ISNULL(SB.ServiceDateEnd, GetDate()))
					AND AI.DisplayOrder = 1 -- primary
					AND  SBP.DontClaim = 0 -- NOT SB.CurrentPrimaryAccountInsurance IS NULL
					AND ((SB.UsePersonInsuranceAuthorizeAssignment=1 AND PIP.AuthorizeAssignment=1) 
						OR (SB.UsePersonInsuranceAuthorizeAssignment=0 AND SB.AuthorizeAssignment=1))
					AND ((SB.UsePrimaryPayerAcceptAssignment=1 AND IC.AcceptAssignment=1)
						OR (SB.UsePrimaryPayerAcceptAssignment=1 AND IC.AcceptAssignmentLabOnly=1 AND dbo.IsLabProcedure(LP.ProcedureUid)=1)
						OR (SB.UsePrimaryPayerAcceptAssignment=0 AND SB.AcceptAssignment=1)
						OR (SB.UsePrimaryPayerAcceptAssignment=0 AND SB.AcceptAssignmentLabOnly=1 AND dbo.IsLabProcedure(LP.ProcedureUid)=1)))
		SELECT @patientLiability = 0
		
        IF @patientLiability = 0 -- If insurance seems to owe it all, check for any patient liability 
        BEGIN
        
			DECLARE @copay MONEY 
			DECLARE @insurancePercent SMALLINT
			DECLARE @procedureAllowed MONEY 
			DECLARE @units DECIMAL(20,1)
			DECLARE @multiplyUnits BIT
			DECLARE @coinsurance MONEY 
			
			SELECT @copay = COALESCE(FixedCopayAmount, 0), @insurancePercent = InsurancePercent, @procedureAllowed = ProcedureAllowed, 
				@units = ISNULL(Units, 1), @multiplyUnits = MultiplyUnits
				FROM dbo.SuperbillProcedure 
				WHERE SuperbillProcedureUid = @superbillProcedureUid -- pull seperate to be able to charge for sep in future
				
			IF @multiplyUnits = 0 AND @units<>1
				SELECT @units = 1
			SELECT @coinsurance = ROUND(ISNULL(@procedureAllowed, 0) * ISNULL(100-@insurancePercent, 0)/100, 2) * @units --default coinsurance amount
				-- ATTN ATTN ATTN - This is how impl in code, however, should not use the potentially LARGER Allowed value, right??  
			IF EXISTS(SELECT IC.AcceptAssignment 
					FROM dbo.SuperbillProcedure SBP 
					INNER JOIN dbo.Superbill SB ON SBP.SuperbillUid = SB.SuperbillUid
					INNER JOIN dbo.Account A ON SB.AccountUid = A.AccountUid
					INNER JOIN dbo.AccountPeriod AP ON A.AccountUid = AP.AccountUid
					INNER JOIN dbo.AccountInsurance AI ON AP.AccountPeriodUid = AI.AccountPeriodUid
					INNER JOIN dbo.PersonInsurancePlan PIP ON AI.PersonInsurancePlanUid = PIP.PersonInsurancePlanUid
					INNER JOIN dbo.InsurancePlan IP ON PIP.InsurancePlanUid = IP.InsurancePlanUid
					INNER JOIN dbo.InsuranceCarrier IC ON IP.InsuranceCarrierUid = IC.CorporationUid
					WHERE SBP.SuperbillProcedureUid = @superbillProcedureUid 
						AND AP.AccountPeriodUid = dbo.GetAccountPeriod(SB.AccountUid, ISNULL(SB.ServiceDateEnd, GetDate()))
						AND AI.DisplayOrder = 2 -- secondary
						AND IC.AcceptAssignment = 1)
				SELECT @coinsurance = 0

            SELECT @patientLiability = @copay + @coinsurance -- apply together - future if both are nonn-zero, will bill as sep charges potentially
        END

	IF (@totalCharge < @patientLiability) -- make sure does not exceed total
		SELECT @patientLiability = @totalCharge
		
	RETURN @patientLiability
	
/* Test

SELECT dbo.ARFN_SuperbillProcedure_InitialPatientLiabilityTrue(''1F6FA2D5-20D6-4D17-B094-0539FE20CFC2'')

*/

END






' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRR_DiabetesAcuteLevelOfServiceCodes]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 03/02/2011
-- Description:	Returns a list acute level of service CPT codes.
-- =================================================================
CREATE FUNCTION [dbo].[ARRR_DiabetesAcuteLevelOfServiceCodes]()
RETURNS 
@AcuteEMCodes TABLE
(
	Code varchar(255)
)

AS
begin
	declare @i int
	declare @tempList varchar(MAX)

	-- load acute CPT level service E/M codes
	SET @tempList = 
	''99221, 99222, 99223, 99231, 99232, 99233, 99238, 99239, 99251, 99252, 99253, 99254, 99255, 99291, '' + -- encounter acute inpt
	''99281, 99282, 99283, 99284, 99285'' -- encounter ED
	
	WHILE len(@tempList) > 0
	BEGIN
		SET @i = CHARINDEX('','', @tempList)
		
		if (@i > 0)
		BEGIN
			INSERT INTO @AcuteEMCodes (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
			SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
		END
		ELSE BEGIN
			INSERT INTO @AcuteEMCodes (Code) VALUES ((RTRIM(LTRIM(@tempList))))
			SET @tempList = ''''
		END
	END
	
	RETURN
end' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRR_DiabetesICD9]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

-- =================================================================
-- Author:		CHM
-- Create date: 03/02/2011
-- Description:	Returns a list of ICD9 code for diabetes.
-- =================================================================
CREATE FUNCTION [dbo].[ARRR_DiabetesICD9]()
RETURNS 
@DiabetesICD9 table
(
	ICD9Code varchar(255)
)
AS
begin
	declare @i int
	declare @tempList varchar(MAX)

	-- load all ICD9 codes for diabetes
	SET @tempList = 
	''250, 250.0, 250.00, 250.01, 250.02, 250.03, 250.10, 250.11, 250.12, 250.13, 250.20, 250.21, 250.22, '' +
	''250.23, 250.30, 250.31, 250.32, 250.33, 250.4, 250.40, 250.41, 250.42, 250.43, 250.50, 250.51, 250.52, '' +
	''250.53, 250.60, 250.61, 250.62, 250.63, 250.7, 250.70, 250.71, 250.72, 250.73, 250.8, 250.80, 250.81, '' +
	''250.82, 250.83, 250.9, 250.90, 250.91, 250.92, 250.93, 357.2, 362.0, 362.01, 362.02, 362.03, 362.04, '' +
	''362.05, 362.06, 362.07, 366.41, 648.0, 648.00, 648.01, 648.02, 648.03, 648.04''
	
	WHILE len(@tempList) > 0
	BEGIN
		SET @i = CHARINDEX('','', @tempList)
		
		if (@i > 0)
		BEGIN
			INSERT INTO @DiabetesICD9 (ICD9Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
			SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
		END
		ELSE BEGIN
			INSERT INTO @DiabetesICD9 (ICD9Code) VALUES ((RTRIM(LTRIM(@tempList))))		
			SET @tempList = ''''
		END
	END
	
	RETURN
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRR_DiabetesLevelOfServiceCodes]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 03/02/2011
-- Description:	Returns a list non-acute level of service CPT codes.
-- =================================================================
CREATE FUNCTION [dbo].[ARRR_DiabetesLevelOfServiceCodes]()
RETURNS 
@AcuteEMCodes TABLE
(
	Code varchar(255)
)

AS
begin
	declare @i int
	declare @tempList varchar(MAX)

	-- load non-acute CPT level service E/M codes
	SET @tempList = 
	''99304, 99305, 99306, 99307, 99308, 99309, 99310, 99315, 99316,'' +
		'' 99318, 99324, 99325, 99326, 99327, 99328, 99334, 99335, 99336, 99337, '' + -- encounter non-acute inpatient
	''99201, 99202, 99203, 99204, 99205, 99211, 99212, 99213, 99214, '' +
		''99215, 99217, 99218, 99219, 99220, 99241, 99242, 99243, 99244, '' +
		''99245, 99341, 99342, 99343, 99344, 99345, 99347, 99348, 99349, '' +
		''99350, 99384, 99385, 99386, 99387, 99394, 99395, 99396, 99397, '' +
		''99401, 99402, 99403, 99404, 99411, 99412, 99420, 99429, 99455, 99456, '' + -- encounter outpatient
	''92002, 92003, 92004, 92005, 92006, 92007, 92008, 92009, 92010, 92011, 92012, 92013, 92014'' -- encounter outpatient - opthamological services
	
	WHILE len(@tempList) > 0
	BEGIN
		SET @i = CHARINDEX('','', @tempList)
		
		if (@i > 0)
		BEGIN
			INSERT INTO @AcuteEMCodes (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
			SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
		END
		ELSE BEGIN
			INSERT INTO @AcuteEMCodes (Code) VALUES ((RTRIM(LTRIM(@tempList))))
			SET @tempList = ''''
		END
	END
	
	RETURN
end' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRR_DiabetesRxNorm]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 03/02/2011
-- Description:	Returns a list of RxNormCodes for diabetes medications.
-- =================================================================
CREATE FUNCTION [dbo].[ARRR_DiabetesRxNorm]()
RETURNS 
@RxNorm table
(
	RxNormCode varchar(255)
)
AS
begin
	declare @i int
	declare @tempList varchar(MAX)
	
	SET @tempList = 
	''199149, 199150, 200132, 205329, 205330, 205331, 401938, '' + -- Alph-glucosidas inhibitors
	''200256, 200257, 200258, 311919, 314142, 389139, 861035, 861039, 861042, 861044, 861787, 861790, '' + -- Amylin analogs
	''744863 , 847910, 847915, '' + -- Antidiabetic agents
		''602544, 602549, 602550, 647237, 647239, 706895, 706896, 861731, 861736, 861740, 861743, 861748, '' +
	''861753, 861760, 861763, 861769, 861783, 861787, 861790, 861795, 861806, 861816, 861819, 861822, '' + -- Antidiabetic-combinations
		''665033, 665038, 665042, 860975, 860978, 860981, 860984, 860996, 860999, 861004, 861007, '' +
		''861010, 861021, 861025, 861731, 861736, 861740, 861743, 861748, 861753, 861760, 861763, '' +
	''861769, 861783, 861787, 861790, 861795, 861806, 861816, 861819, 861822, '' + -- Biguanides
	''205314, 237527, 242120, 242916, 242917, 259111, 260265, 283394, 311040, 311041, '' +
	''311053, 311054, 311055, 311056, 311057, 311058, 311059, 311060, 311061, 314038, '' +
	''317800, 351297, 358349, 484322, 485210, 544614, 763002, 763007, 763013, 763014, '' +
	''833159, 847191, 847207, 847211, 847230, 847239, 847252, 847259, 847263, 847416, '' + -- Insulin
	''105374, 153842, 197306, 197307, 197495, 197496, 197737, 198291, 198292, 198293, '' +
	''198294, 199245, 199246, 199247, 199825, 199984, 199985, 200065, 252960, 310488, '' +
	''310489, 310490, 310534, 310536, 310537, 310539, 312440, 312441, 312859, 312860, '' +
	''312861, 313418, 313419, 314000, 314006, 315107, 315239, 317573, 379804, 389137, '' +
	''602544, 602549, 602550, 647237, 647239, 706895, 706896, 757710, 757712, 844809, '' +
	''844824, 844827, 861731, 861736, 861740, 861743, '' +
	''861748, 861753, 861760, 861763, 861783, 861795, 861806, 861816, 861822, '' + -- Sulfonylureas
	''312440, 312441, 312859, 312860, 312861, 317573'' -- Thiazolidinediones

	WHILE len(@tempList) > 0
	BEGIN
		SET @i = CHARINDEX('','', @tempList)
		
		if (@i > 0)
		BEGIN
			INSERT INTO @RxNorm (RxNormCode) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
			SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
		END
		ELSE BEGIN
			INSERT INTO @RxNorm (RxNormCode) VALUES ((RTRIM(LTRIM(@tempList))))		
			SET @tempList = ''''
		END
	END	
	
	RETURN
end' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRA_DiabetesDenominator]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- ===================================================================
-- Author:		chm
-- Create date: 03/02/2011
-- Description:	This function returns the deominator results for the
--				following ARRA rules: 0055, 0056, 0059, 0061, 0062, 
--				0064, 0575
-- ===================================================================
CREATE FUNCTION [dbo].[ARRA_DiabetesDenominator] (
	@PatientUid UNIQUEIDENTIFIER
	,@2YearsAgo DATETIME
	)
RETURNS INT
AS
BEGIN
	-- Change History :
	--
	-- Date			Edited By	Change
	-- ========================================
	-- 2013.Oct.14	JRB		Update SP to not use old diagnosis table
	--
	DECLARE @tempCnt INT
	DECLARE @metDenominator INT
	DECLARE @Visit TABLE (VisitUid UNIQUEIDENTIFIER)

	SET @metDenominator = 0

	-- is the patient currently taking any medications for diabetes
	SELECT @tempCnt = COUNT(*)
	FROM RelPatientMedication rel
	INNER JOIN MedicationSIG sig ON rel.MedicationSIGUid = sig.MedicationSIGUid
		AND rel.PatientUid = @PatientUid
		AND sig.DiscontinueReasonUid IS NULL
		AND sig.OverallStartDate >= @2YearsAgo
	CROSS APPLY (
		SELECT TOP 1 rev.*
		FROM dbo.NDD_SearchRxNorm rev
		INNER JOIN dbo.ARRR_DiabetesRxNorm() norm ON norm.RxNormCode = rev.RxNormCode
		WHERE rev.IsDelete = 0
		  AND (rev.medid = sig.FDB_MEDID OR rev.mnid = sig.FDB_MNID)) rxn

	IF (@tempCnt = 0)
	BEGIN -- no diabetes medications found
		-- does the patient have a history of diabetes
		SET @tempCnt = 0

		SELECT @tempCnt = COUNT(*)
		FROM PatientDXHistory pdx
		INNER JOIN ListProblemStatus lps ON pdx.ProblemStatusUid = lps.ProblemStatusUid
			AND lps.ActiveStatus = 1
			AND pdx.IsDelete = 0
		--INNER JOIN ListOldDiagnosis ld ON pdx.DiagnosisUid = ld.DiagnosisUid
		--INNER JOIN dbo.ARRR_DiabetesICD9() dia ON ld.DiagnosisCode9 = dia.ICD9Code
		INNER JOIN dbo.ARRR_DiabetesICD9() dia ON pdx.Code = dia.ICD9Code
		WHERE pdx.PatientUid = @PatientUid

		IF (@tempCnt = 0)
		BEGIN
			-- if not found in patient history; see if there is an active diagnosis for diabetes and 
			-- at less one acute encounters or at less two non-acute encounters
			DELETE @Visit

			-- get all visit
			INSERT INTO @Visit
			SELECT VisitUid
			FROM Visit
			WHERE PatientUid = @PatientUid
				AND (
					VisitTypeUid IS NULL
					OR VisitTypeUid <> ''FB954167-9D1C-43B7-9F5B-A76260654C96''
					) -- Strike Out

			SET @tempCnt = 0

			SELECT @tempCnt = COUNT(*)
			FROM VisitDiagnosis vd
			--INNER JOIN LisOldtDiagnosis ld ON vd.DiagnosisUid = ld.DiagnosisUid
			--	AND vd.IsDelete = 0
			--INNER JOIN dbo.ARRR_DiabetesICD9() dia ON ld.DiagnosisCode9 = dia.ICD9Code
			INNER JOIN dbo.ARRR_DiabetesICD9() dia ON vd.Code = dia.ICD9Code
			WHERE vd.IsDelete = 0
				AND vd.VisitUid IN (
					SELECT VisitUid
					FROM @Visit
					)
		END

		IF (@tempCnt > 0)
		BEGIN
			SET @tempCnt = 0

			-- test is there at less two an non-acute visit; test first most likely to found something
			SELECT @tempCnt = COUNT(*)
			FROM Visit v
			INNER JOIN VisitProcedure vp ON v.VisitUid = vp.VisitUid
				AND v.PatientUid = @PatientUid
				AND (
					v.VisitTypeUid IS NULL
					OR v.VisitTypeUid <> ''FB954167-9D1C-43B7-9F5B-A76260654C96''
					) -- Strike Out
				AND vp.IsDelete = 0
			INNER JOIN ListProcedure lp ON vp.ProcedureUid = lp.ProcedureUid
			INNER JOIN dbo.ARRR_DiabetesLevelOfServiceCodes() non ON lp.Code = non.Code

			IF (@tempCnt < 2)
			BEGIN
				SET @tempCnt = 0

				-- test is there at less one an acute visit
				SELECT @tempCnt = COUNT(*)
				FROM Visit v
				INNER JOIN VisitProcedure vp ON v.VisitUid = vp.VisitUid
					AND v.PatientUid = @PatientUid
					AND (
						v.VisitTypeUid IS NULL
						OR v.VisitTypeUid <> ''FB954167-9D1C-43B7-9F5B-A76260654C96''
						) -- Strike Out
					AND vp.IsDelete = 0
				INNER JOIN ListProcedure lp ON vp.ProcedureUid = lp.ProcedureUid
				INNER JOIN dbo.ARRR_DiabetesAcuteLevelOfServiceCodes() acute ON lp.Code = acute.Code
			END
		END
	END -- no diabetes medications found

	IF (@tempCnt > 0)
	BEGIN
		SET @metDenominator = 1
	END

	RETURN @metDenominator
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRR_ExcludeDiabetesICD9]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 03/02/2011
-- Description:	Returns a list of all excluded ICD9 codes for diabetes.
-- =================================================================
CREATE FUNCTION [dbo].[ARRR_ExcludeDiabetesICD9]()
RETURNS 
@ExcludeDiabetesICD9 table
(
	ICD9Code varchar(255)
)
AS
begin
	declare @i int
	declare @tempList varchar(MAX)

	-- load exclude ICD9 codes for diabetes
	SET @tempList = 
	''648.0, 648.00, 648.01, 648.02, 648.03, 648.04, '' + -- gestational diabetes
	''256.4, '' + -- polycystic ovaries
	''249, 249.0, 249.00, 249.01, 249.1, 249.10, 249.11, 249.2, 249.20, 249.21, 249.3, '' +
	''249.30, 249.31, 249.4, 249.40, 249.41, 249.5, 249.50, 249.51, 249.6, 249.60, 249.61, '' +
	''249.7, 249.70, 249.71, 249.8, 249.80, 249.81, 249.9, 249.90, 249.91, 251.8, 962.0'' -- steroid induced diabetes

	WHILE len(@tempList) > 0
	BEGIN
		SET @i = CHARINDEX('','', @tempList)
		
		if (@i > 0)
		BEGIN
			INSERT INTO @ExcludeDiabetesICD9 (ICD9Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
			SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
		END
		ELSE BEGIN
			INSERT INTO @ExcludeDiabetesICD9 (ICD9Code) VALUES ((RTRIM(LTRIM(@tempList))))
			SET @tempList = ''''
		END
	END
	
	RETURN
end	
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRA_DiabetesExclusions]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- ===================================================================
-- Author:		chm
-- Create date: 03/12/2011
-- Description:	This function returns the exclusions results for the
--				following ARRA rules: 0059, 0061
-- ===================================================================
CREATE FUNCTION [dbo].[ARRA_DiabetesExclusions] 
(
	@PatientUid uniqueidentifier
)
RETURNS int
AS
BEGIN
	DECLARE @tempCnt int
	DECLARE @metExclusion int
		
	DECLARE @Visit TABLE
	(
		VisitUid uniqueidentifier
	)
	SET @metExclusion = 0
		
	-- does the patient have any excluded diabetes icd9 codes
	SET @tempCnt = 0
	SELECT @tempCnt = COUNT(*) FROM PatientDXHistory pdx 
		INNER JOIN ListProblemStatus lps on pdx.ProblemStatusUid = lps.ProblemStatusUid 
			AND lps.ActiveStatus = 1 AND pdx.IsDelete = 0
		INNER JOIN dbo.ARRR_ExcludeDiabetesICD9() dia ON pdx.Code = dia.ICD9Code
	WHERE pdx.PatientUid = @PatientUid

	IF (@tempCnt = 0)
	BEGIN
		-- if not found in patient history; see if there is an active diagnosis for diabetes
		DELETE @Visit
		-- get all visit
		INSERT INTO @Visit
		SELECT VisitUid FROM Visit 
			WHERE PatientUid = @PatientUid 
					AND (VisitTypeUid is null OR VisitTypeUid <> ''FB954167-9D1C-43B7-9F5B-A76260654C96'') -- Strike Out
		
		SELECT @tempCnt = COUNT(*) FROM VisitDiagnosis vd
		INNER JOIN dbo.ARRR_ExcludeDiabetesICD9() dia ON vd.Code = dia.ICD9Code
		WHERE vd.IsDelete = 0 AND vd.VisitUid IN (SELECT VisitUid FROM @Visit)
	END
	
	IF (@tempCnt > 0)
	BEGIN
		SET @metExclusion = 1
	END
		
	RETURN @metExclusion
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRR_HypertensionICD9]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

-- =================================================================
-- Author:		CHM
-- Create date: 03/03/2011
-- Description:	Returns a list of ICD9 code for Hypertension.
-- =================================================================
CREATE FUNCTION [dbo].[ARRR_HypertensionICD9]()
RETURNS 
@HypertensionICD9 table
(
	ICD9Code varchar(255)
)
AS
begin
	declare @i int
	declare @tempList varchar(MAX)

	-- load all ICD9 codes for hypertension
	SET @tempList = ''401, 401.0, 401.1, 401.9''
	
	WHILE len(@tempList) > 0
	BEGIN
		SET @i = CHARINDEX('','', @tempList)
		
		if (@i > 0)
		BEGIN
			INSERT INTO @HypertensionICD9 (ICD9Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
			SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
		END
		ELSE BEGIN
			INSERT INTO @HypertensionICD9 (ICD9Code) VALUES ((RTRIM(LTRIM(@tempList))))		
			SET @tempList = ''''
		END
	END
	
	RETURN
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRR_OutpatientLevelOfServiceCodes]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 03/03/2011
-- Description:	Returns a list outpatient level of service CPT codes.
-- =================================================================
CREATE FUNCTION [dbo].[ARRR_OutpatientLevelOfServiceCodes]()
RETURNS 
@OutpatientEMCodes TABLE
(
	Code varchar(255)
)

AS
begin
	declare @i int
	declare @tempList varchar(MAX)

	-- load outpatient CPT level service E/M codes
	SET @tempList = ''99201, 99202, 99203, 99204, 99205, 99211, 99212, 99213, 99214, 99215, '' +
		''99217, 99218, 99219, 99220, 99241, 99242, 99243, 99244, 99245, 99341, 99342, 99343, '' +
		''99344, 99345, 99347, 99348, 99349, 99350, 99384, 99385, 99386, 99387, 99394, 99395, '' +
		''99396, 99397, 99401, 99402, 99403, 99404, 99411, 99412, 99420, 99429, 99455, 99456''
	
	WHILE len(@tempList) > 0
	BEGIN
		SET @i = CHARINDEX('','', @tempList)
		
		if (@i > 0)
		BEGIN
			INSERT INTO @OutpatientEMCodes (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
			SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
		END
		ELSE BEGIN
			INSERT INTO @OutpatientEMCodes (Code) VALUES ((RTRIM(LTRIM(@tempList))))
			SET @tempList = ''''
		END
	END
	
	RETURN
end' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AttachmentHandlerFileNameWildcards]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[AttachmentHandlerFileNameWildcards]()

RETURNS @AttachmentHandlersFNW TABLE (	AttachmentHandlerUid UNIQUEIDENTIFIER,
										FileNameWildcard VARCHAR(255),
										CompressionUid UNIQUEIDENTIFIER NULL,
										Priority SMALLINT							
									 )
AS
BEGIN
	DECLARE @attachmentHandlerUid UNIQUEIDENTIFIER
	DECLARE @fileNameWildcard VARCHAR(255)
	DECLARE @compressionUid UNIQUEIDENTIFIER
	DECLARE @priority SMALLINT

	DECLARE	cur CURSOR FORWARD_ONLY FOR SELECT AttachmentHandlerUid, FileNameWildcard, CompressionUid, Priority FROM ListAttachmentHandler ORDER BY Priority
	OPEN cur
	FETCH NEXT FROM cur INTO @attachmentHandlerUid, @fileNameWildcard, @compressionUid, @priority
	WHILE @@FETCH_STATUS = 0
	BEGIN
		INSERT	@AttachmentHandlersFNW
		SELECT	@attachmentHandlerUid, Element, @compressionUid, @priority
		FROM	dbo.Split(@fileNameWildcard, '';'')

		FETCH NEXT FROM cur INTO @attachmentHandlerUid, @fileNameWildcard, @compressionUid, @priority
	END
	RETURN
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatchProcessStatementsPortalOnlyCount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[BatchProcessStatementsPortalOnlyCount](@BatchProcessUid UNIQUEIDENTIFIER)
RETURNS INT
AS
BEGIN
	DECLARE @Completed int

  select @Completed = count(*)
  from StatementBatchDetail sbd with(nolock) 
  LEFT JOIN BatchProcessDetail bpd with(nolock) ON bpd.BatchProcessUid = @BatchProcessUid
  where sbd.StatementBatchDetailUid = bpd.Uid AND sbd.AttachmentUid IS NOT NULL AND sbd.CompletionStatus = 2

  return @Completed
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatchProcessStatementsPrintedCount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[BatchProcessStatementsPrintedCount](@BatchProcessUid UNIQUEIDENTIFIER)
RETURNS INT
AS
BEGIN
	DECLARE @Completed int

  select @Completed = count(*)
  from StatementBatchDetail sbd with(nolock) 
  LEFT JOIN BatchProcessDetail bpd with(nolock) ON bpd.BatchProcessUid = @BatchProcessUid
  where sbd.StatementBatchDetailUid = bpd.Uid AND sbd.AttachmentUid IS NOT NULL AND sbd.CompletionStatus = 1

  return @Completed
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatchProcessStatementsSubmittedCount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[BatchProcessStatementsSubmittedCount](@BatchProcessUid UNIQUEIDENTIFIER)
RETURNS INT
AS
BEGIN
	DECLARE @Completed int

  select @Completed = count(*)
  from StatementBatchDetail sbd with(nolock) 
  LEFT JOIN BatchProcessDetail bpd with(nolock) ON bpd.BatchProcessUid = @BatchProcessUid
  where sbd.StatementBatchDetailUid = bpd.Uid AND sbd.AttachmentUid IS NOT NULL AND (sbd.CompletionStatus = 3 or sbd.CompletionStatus = 4)

  return @Completed
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatchProcessStatementsWithAttachmentCount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[BatchProcessStatementsWithAttachmentCount](@BatchProcessUid UNIQUEIDENTIFIER)
RETURNS INT
AS
BEGIN
	DECLARE @Completed int

  select @Completed = count(*)
  from StatementBatchDetail sbd with(nolock)
  LEFT JOIN BatchProcessDetail bpd with(nolock) ON bpd.BatchProcessUid = @BatchProcessUid
  where sbd.StatementBatchDetailUid = bpd.Uid AND sbd.AttachmentUid IS NOT NULL

  return @Completed
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BigIntToGUID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[BigIntToGUID](@PK_ID bigint)
RETURNS uniqueidentifier AS

BEGIN

  declare @Wrk varchar(200)
  declare @NewGUID uniqueidentifier
  declare @Neg bit

  if @PK_ID = 0
   return ''00000000-0000-0000-0000-00000000FFFF''

  if @PK_ID is not null
    begin
      if (@PK_ID < 0)
        begin
         set @Neg = 1
          set @PK_ID = -1 * @PK_ID
        end
      set @Wrk = convert (varchar(200), @PK_ID)
      while len(@Wrk) < 32 set @Wrk = ''0'' + @Wrk

      if (@Neg = 1 )
             set @Wrk = ''FFFFFFFF'' + ''-'' + SUBSTRING(@Wrk, 9, 4) + ''-'' + SUBSTRING(@Wrk, 13, 4)
                              + ''-'' + SUBSTRING(@Wrk, 17, 4) + ''-'' + SUBSTRING(@Wrk, 21, 12)
      else
             set @Wrk = SUBSTRING(@Wrk, 1, 8) + ''-'' + SUBSTRING(@Wrk, 9, 4) + ''-'' + SUBSTRING(@Wrk, 13, 4)
                              + ''-'' + SUBSTRING(@Wrk, 17, 4) + ''-'' + SUBSTRING(@Wrk, 21, 12)
      set @Wrk = ''{'' + @Wrk + ''}''
      set @NewGUID = @Wrk
    end

  return (@NewGUID)
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CanDeleteVisitAfterDeleteObservationOrder]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[CanDeleteVisitAfterDeleteObservationOrder](@ObservationOrderUid UNIQUEIDENTIFIER, @VisitUid UNIQUEIDENTIFIER = ''00000000-0000-0000-0000-000000000000'', @ForFNCDelete bit = 0) RETURNS BIT AS
BEGIN
   DECLARE 
      @VisitProcedureUid UNIQUEIDENTIFIER

	IF (@ForFNCDelete = 0)
	BEGIN
		SELECT 
			@VisitUid          = VisitUid,
			@VisitProcedureUid = VisitProcedureUid
		FROM ObservationOrder 
		WHERE ObservationOrderUid = @ObservationOrderUid
	END
   
   IF (@VisitProcedureUid IS NULL) SELECT @VisitProcedureUid = ''00000000-0000-0000-0000-000000000000''

   IF (@VisitUid IS NULL) RETURN 0
   IF EXISTS(SELECT * FROM Visit tab WHERE tab.VisitUid = @VisitUid AND tab.IsCompleted = 1) RETURN 0

   IF (@ForFNCDelete = 0)
   BEGIN
		IF NOT EXISTS(SELECT * FROM Visit tab WHERE tab.VisitUid = @VisitUid AND tab.VisitTypeUid = ''6A18A657-B912-4C12-828E-A3DF8571D205'') RETURN 0
		
		IF EXISTS(SELECT * FROM RelAttachmentGroup tab WHERE tab.VisitUid = @VisitUid AND tab.ObservationOrderUid != @ObservationOrderUid) RETURN 0
		IF EXISTS(SELECT * FROM ObservationOrder tab WHERE tab.VisitUid = @VisitUid AND tab.ObservationOrderUid != @ObservationOrderUid) RETURN 0
		IF EXISTS(SELECT * FROM ObservationOrder tab WHERE tab.ResultingVisitUid = @VisitUid AND tab.ObservationOrderUid != @ObservationOrderUid) RETURN 0
		IF EXISTS(SELECT * FROM ObservationValue tab WHERE tab.VisitUid = @VisitUid AND tab.ObservationOrderUid != @ObservationOrderUid) RETURN 0
		IF EXISTS(SELECT * FROM VisitAssessmentForm tab WHERE tab.VisitUid = @VisitUid AND tab.ObservationOrderUid != @ObservationOrderUid) RETURN 0
		IF EXISTS(SELECT * 
             FROM Message tab 
             LEFT JOIN MessageHL7 mhl ON mhl.MessageUid = tab.MessageUid AND mhl.ObservationOrderUid = @ObservationOrderUid
             LEFT JOIN  RelMessageHL7ObservationOrder mrl ON mrl.MessageUid = tab.MessageUid AND mrl.ObservationOrderUid = @ObservationOrderUid
             WHERE tab.VisitUid = @VisitUid 
               AND mhl.MessageUid IS NULL 
               AND mrl.MessageUid IS NULL) RETURN 0
		IF EXISTS(SELECT * FROM Superbill tab WHERE tab.VisitUid = @VisitUid) RETURN 0
		IF EXISTS(SELECT * FROM VisitCC tab WHERE tab.VisitUid = @VisitUid) RETURN 0
		IF EXISTS(SELECT * FROM VisitComplexity tab WHERE tab.VisitUid = @VisitUid) RETURN 0
		IF EXISTS(SELECT * FROM VisitComment tab WHERE tab.VisitUid = @VisitUid) RETURN 0
		IF EXISTS(SELECT * FROM VisitCoSign tab WHERE tab.VisitUid = @VisitUid) RETURN 0
		IF EXISTS(SELECT * FROM VisitData tab WHERE tab.VisitUid = @VisitUid) RETURN 0
		IF EXISTS(SELECT * FROM VisitEduForm tab WHERE tab.VisitUid = @VisitUid) RETURN 0
		IF EXISTS(SELECT * FROM VisitPlan tab WHERE tab.VisitUid = @VisitUid) RETURN 0
		IF EXISTS(SELECT * FROM PQRIHistory tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   END
   ELSE BEGIN -- for FNC delete
		IF EXISTS(SELECT * FROM ObservationOrder oo 
						INNER JOIN ObservationValue ov ON oo.ObservationOrderUid = ov.ObservationOrderUid 
						INNER JOIN ListObservationItem loi ON ov.ObservationItemUid = loi.ObservationItemUid
							AND loi.Name <> ''BMI''
					WHERE loi.IsVitals <> 1 and oo.VisitUid = @visitUid) RETURN 0
   END

   IF EXISTS(SELECT * FROM ClinicalDecisionSupportResults tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM eRxOutbound tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM FaxQueue tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM ImmunizationHistory tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM MedicationSIG tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM MessageAN tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM MessageAuthorization tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM MessageERxRefillRequest tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM MessageInstantMessage tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM MessagePatientLabOrder tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM MessageRxRefill tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM MessageVisitBilling tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM PatientCareManagementLog tab WHERE tab.LoggedFromVisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM PatientFamilyHistory tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM PatientHistory tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM PatientProblemDiagnosisHistory tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM PatientProcedureHistory tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM PatientRecall tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM PatientRecall tab WHERE tab.OriginVisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM PatientReferral tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM RecordDisclosureAudit tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM RelPatientMedication tab WHERE tab.EnteredFromVisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM RelScheduledEduForm tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM RelVisitMedication tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM ScheduledPQRIUpdate tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM VisitAccess tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM VisitCommentExtension tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * 
             FROM VisitDiagnosis tab 
			 LEFT JOIN VisitProcedureDiagnosis org ON org.VisitDiagnosisUid = tab.VisitDiagnosisUid
			 WHERE tab.VisitUid = @VisitUid
			   and (org.VisitProcedureDiagnosisUid IS NULL OR org.VisitProcedureUid != @VisitProcedureUid)) RETURN 0
   IF EXISTS(SELECT * FROM VisitGraphicNotes tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM VisitHpi tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM VisitWatchItem tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM VisitOutsideProvider tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM VisitPE tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM VisitProcedure tab WHERE tab.VisitUid = @VisitUid AND tab.VisitProcedureUid != @VisitProcedureUid) RETURN 0
   IF EXISTS(SELECT * FROM VisitRos tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM VisitTranscription tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM VisitVoiceAttachment tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   
   RETURN 1
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAge]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[GetAge](@birthdate DATE, @date DATE) RETURNS INT AS
BEGIN
	DECLARE @age INT
	
	SET @age = FLOOR(DATEDIFF(day, @birthdate, @date) / 365.25)
	
	RETURN @age
END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CHCGetAgeLevel]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[CHCGetAgeLevel](@personUid UNIQUEIDENTIFIER, @date DATE) RETURNS VARCHAR(50) AS
BEGIN
	DECLARE @birthdate DATE
	SELECT @birthdate = Birthdate FROM Person p WHERE p.PersonUid = @personUid
	DECLARE @age SMALLINT
	SET @age = dbo.GetAge(@birthdate, CASE WHEN @date IS NULL THEN GETDATE() ELSE @date END)
	
	IF @age < 1 
		RETURN ''0 - 1''
	IF @age < 4 
		RETURN ''1 - 4''
	IF @age < 7 
		RETURN ''4 - 7''
	IF @age < 12 
		RETURN ''8 - 12''
	IF @age < 17 
		RETURN ''13 - 17''
	IF @age < 26 
		RETURN ''18 - 26''
	IF @age < 39 
		RETURN ''27 - 39''
	IF @age < 49 
		RETURN ''40 - 49''
	IF @age < 64 
		RETURN ''50 - 64''
	RETURN ''65+''	
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CHCGetInsuranceType]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[CHCGetInsuranceType](@SuperbillUid UNIQUEIDENTIFIER) 
  RETURNS UNIQUEIDENTIFIER 
AS
BEGIN
	DECLARE @retUid UNIQUEIDENTIFIER
	set @retUid = ''10101010-0000-7777-0000-000000000001'' -- Primary Insurance Carrier
	return @retUid ;
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CHCGetPovertyLevel]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[CHCGetPovertyLevel](@accountUid UNIQUEIDENTIFIER, @date DATE) RETURNS VARCHAR(50) AS
BEGIN
	DECLARE @unitedStates AS UNIQUEIDENTIFIER, 
			@alaska AS UNIQUEIDENTIFIER, 
			@hawaii AS UNIQUEIDENTIFIER, 
			@region  AS UNIQUEIDENTIFIER 
	DECLARE @state VARCHAR(3)
	DECLARE @accountResponsiblePartyUid UNIQUEIDENTIFIER
	
	SELECT	@state = p.Address1.value(''(/Address/State)[1]'', ''varchar(100)''),
			@accountResponsiblePartyUid = a.AccountResponsiblePartyUid
	FROM	Account a INNER JOIN AccountResponsibleParty arp ON a.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid
			INNER JOIN Person p ON arp.PersonUid = p.PersonUid
	WHERE	a.AccountUid = @accountUid

	SET @unitedStates = ''10101010-0000-0000-1001-000000000001''
	SET @alaska = ''10101010-0000-0000-1001-000000000002''
	SET @hawaii = ''10101010-0000-0000-1001-000000000003''
	
	IF @state = ''AK''
		SET @region = @alaska
	ELSE IF @state = ''HI''
		SET @region = @hawaii
	ELSE 
		SET @region = @unitedStates
	
	DECLARE @baseAmount MONEY
	DECLARE @incrementalAmount MONEY
	SET @baseAmount = -1.00
	
	SELECT TOP 1	@baseAmount = BaseAmount, @incrementalAmount = IncrementalAmount
	FROM			ChcListFPLSchedule
	WHERE			FPLRegionUid = @region AND
					CAST(EffectiveDate AS DATE) < @date
	ORDER BY		EffectiveDate DESC
	
	DECLARE @familySize SMALLINT
	DECLARE @annualIncome MONEY
	SELECT	@familySize = FamilySize, @annualIncome = MonthlyIncome * 12.0
	FROM	CHCAccountResponsibleParty
	WHERE	AccountResponsiblePartyUid = @accountResponsiblePartyUid
	
	IF @familySize = 0 OR @baseAmount = -1
		RETURN ''Unknown/Not Provided''
		
	DECLARE @FPL_FamSz_Amount MONEY 
	DECLARE @dPercentPoverty DECIMAL (8,2)
	DECLARE @nPercentPoverty INT
	
	IF @familySize = 1 OR @incrementalAmount = 0
		SET @FPL_FamSz_Amount = @baseAmount 
	ELSE
		SET @FPL_FamSz_Amount = @baseAmount + (@incrementalAmount * (@familySize - 1))
		
	SET @dPercentPoverty = (@annualIncome / @FPL_FamSz_Amount)  * 100
	SET @nPercentPoverty = ROUND(@dPercentPoverty, 0)
	
	IF @nPercentPoverty <= 100 
		RETURN ''100% of less''
	IF @nPercentPoverty <= 150
		RETURN ''100-150%''
	IF @nPercentPoverty <= 200
		RETURN ''150-200%''
	IF @nPercentPoverty <= 250
		RETURN ''200-250%''
	IF @nPercentPoverty <= 300
		RETURN ''250-300%''
	IF @nPercentPoverty > 300
		RETURN ''Above 300%''
	
	RETURN ''Unknown/Not Provided''
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CheckANDGetDateFormat]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[CheckANDGetDateFormat]
(
	@Date VARCHAR(50)
)RETURNS VARCHAR(50)
BEGIN

	IF(ISDATE(@Date)=0)
	BEGIN
		If(LTRIM(RTRIM(@Date))='''')
			SET @Date=''-2''
		ELSE
		BEGIN
			DECLARE
			@IDate			INT,
			@C				INT

			SET @IDate=0
			SET @C=0
			
			WHILE @C<LEN(@Date)
			BEGIN	
				If(Substring(@Date,@C,1)=''/'' OR Substring(@Date,@C,1)=''-'')
				BEGIN
					SET @IDATE=@IDATE+1
				END
				SET @C=@C+1
			END
			
			IF (@IDate=0)
--				SET @Date=''-1''
				SET @Date=''01/01/'' + @Date
			ELSE IF (@IDate=1)
				SET @Date=''01/'' + @Date
		END
	END
	
	RETURN @Date		
END

' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CheckPath]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[CheckPath](@path [nvarchar](4000))
RETURNS [bit] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[CheckPath]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CheckRecurTimeType]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE function [dbo].[CheckRecurTimeType]
(
	@RecurTimeTypeUID UNIQUEIDENTIFIER,
	@dt DateTime,
	@recurValue smallint
)
Returns datetime
begin
	Declare @retDate DateTime
	Declare @str varchar(20)

	Select @str=[Name] from ListTimeType where TimeTypeuid = @RecurTimeTypeUID
	
	set @retDate=@dt

	if 	@str = ''Days'' 	
		Set @retDate = DateAdd(day,@recurValue,@dt)
	else if @str = ''Weeks'' 
	begin
		Set @recurValue = @recurValue * 7
		Set @retDate = DateAdd(day,@recurValue,@dt)
	end
	else if @str = ''Months''  
		Set @retDate = DateAdd(month,@recurValue,@dt)
	else if @str = ''Years'' 
		Set @retDate = DateAdd(year,@recurValue,@dt)

	return @retDate 

END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CombineList]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[CombineList]
	(
		@filter varchar(max)
	)
RETURNS varchar(max)
AS
BEGIN
	declare @orderlist varchar(max)
	select @orderlist = ''''

	select @orderlist =  convert(varchar(10), displayorder) + '','' + @orderlist   from ListMisc where ListType = @filter order by DisplayOrder desc
	select @orderlist = left(@orderlist, len(@orderlist)-1)

	RETURN @orderlist
end
' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ComparePRMVersion]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ComparePRMVersion](@VersionA [nvarchar](32), @VersionB [nvarchar](32))
RETURNS [int] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[ComparePRMVersion]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Date_ConvertDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[Date_ConvertDate]
	(
	@date datetime
	)
RETURNS datetime
AS
	BEGIN
	RETURN cast(convert(varchar, @date, 101) AS datetime)
	END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ConvertDateOnly]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ConvertDateOnly]
	(
	@date datetime
	)
RETURNS datetime
AS
	BEGIN
	RETURN dbo.Date_ConvertDate(@date)
	END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[convertFractionToDecimal]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[convertFractionToDecimal](@STR VARCHAR(50))
RETURNS decimal(18,2)
AS
BEGIN
        DECLARE @L VARCHAR(50) = ''''
        DECLARE @A DECIMAL(18,10) = 0
        SET @STR = LTRIM(RTRIM(@STR)); -- Remove extra spaces
        IF ISNUMERIC(@STR) > 0 SET @A = CONVERT(DECIMAL(18,10), @STR) -- Check to see if already real number
        IF CHARINDEX('' '',@STR,0) > 0
        BEGIN
            SET @L = SUBSTRING(@STR,1,CHARINDEX('' '',@STR,0) - 1 )
            SET @STR = SUBSTRING(@STR,CHARINDEX('' '',@STR,0) + 1 ,50 )
            SET @A = CONVERT(DECIMAL(18,10), @L)
        END
        IF CHARINDEX(''/'',@STR,0) > 0
        BEGIN
            SET @L = SUBSTRING(@STR,1,CHARINDEX(''/'',@STR,0) - 1 )
            SET @STR = SUBSTRING(@STR,CHARINDEX(''/'',@STR,0) + 1 ,50 )
            SET @A =  @A + ( CONVERT(DECIMAL(18,10), @L) / CONVERT(DECIMAL(18,10), @STR)  )
        END
        RETURN @A
END
' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ConvertLocalToUTCTime]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ConvertLocalToUTCTime](@localTime [datetime])
RETURNS [datetime] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[ConvertLocalToUTCTime]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ConvertStringToNumeric]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ConvertStringToNumeric] (@Value TEXT)
RETURNS NUMERIC(12, 2)
AS
BEGIN
	DECLARE @string VARCHAR(max)

	SET @string = CONVERT(VARCHAR(MAX), @Value)

	--set @string=''abc93.3ad4''
	DECLARE @IncorrectCharLoc SMALLINT

	SET @IncorrectCharLoc = PATINDEX(''%[^0-9.-]%'', @string)

	WHILE @IncorrectCharLoc > 0
	BEGIN
		SET @string = STUFF(@string, @IncorrectCharLoc, 1, '''')
		SET @IncorrectCharLoc = PATINDEX(''%[^0-9.-]%'', @string)
	END

	SET @string = @string

	IF ISNUMERIC(LEFT(@string,30)) = 1
		AND LEN(@string) > 0
		AND @string != ''.''
		AND @string != ''-''
		AND @string != ''.-''
		AND Len(@string) <= 9
		AND @string != ''-.''
	BEGIN
		RETURN CONVERT(NUMERIC(10, 2), @string)
	END

	RETURN - 1
END' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ConvertTimeByTimezone]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ConvertTimeByTimezone](@datetime [datetime], @timezone [nvarchar](max))
RETURNS [datetime] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[ConvertTimeByTimezone]' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ConvertTimeToTimezone]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ConvertTimeToTimezone](@datetime [datetime], @timezone [nvarchar](max))
RETURNS [datetime] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[ConvertTimeToTimezone]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ConvertToBytes]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[ConvertToBytes](@input varchar(50)) RETURNS BIGINT AS
BEGIN
	IF SUBSTRING(@input, DATALENGTH(@input) - 1, 2) = ''KB''
		RETURN convert(BIGINT, SUBSTRING(@input, 0, DATALENGTH(@input) - 2)) * 1024
	
	RETURN convert(BIGINT, SUBSTRING(@input, 0, DATALENGTH(@input) - 2)) * 1024 * 1024
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ConvertToTimeZonePracticeSettings]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ConvertToTimeZonePracticeSettings](@dt DATETIME) RETURNS DATETIME AS
BEGIN
	DECLARE @timezone VARCHAR(30)
	DECLARE @timeZoneAdj smallint
	DECLARE @daylightsavings bit

	SELECT @timezone = StringValue FROM ListProductParameter WHERE ParameterName = ''TimeZoneString''
	IF @timezone IS NULL
	BEGIN
		SELECT @timeZoneAdj = InTimeZoneAdj, @daylightsavings = ObserveDaylightSavings FROM PracticeSettings

		IF @timeZoneAdj = -5
			SET @timezone = ''Eastern Standard Time''
		ELSE IF @timeZoneAdj = -6
			SET @timezone = ''Central Standard Time''
		ELSE IF @timeZoneAdj = -7 AND @daylightsavings = 0
			SET @timezone = ''US Mountain Standard Time''
		ELSE IF @timeZoneAdj = -7
			SET @timezone = ''Mountain Standard Time''
		ELSE IF @timeZoneAdj = -8
			SET @timezone = ''Pacific Standard Time''
		ELSE IF @timeZoneAdj = -9
			SET @timezone = ''Alaskan Standard Time''
		ELSE IF @timeZoneAdj = -10
			SET @timezone = ''Hawaiian Standard Time''
		ELSE 
			SET @timezone = ''local''
		END

	RETURN dbo.ConvertTimeByTimezone(@dt, @timezone)
END
' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CopyKDBOverride]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[CopyKDBOverride](@src [xml], @srcUid [uniqueidentifier], @dst [xml], @dstUid [uniqueidentifier])
RETURNS [xml] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[CopyKDBOverride]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CorrectVMCProviderExternalID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE function [dbo].[CorrectVMCProviderExternalID] (@ExternalID varchar(200))  
 returns varchar(200) as
begin
	declare @returnID varchar(200)
	declare @i int

	set @returnID = @ExternalID	
	set @i = 0

	while (@i <= len(@ExternalID))
	begin
		set @i = @i + 1
 		if ((substring(@ExternalID, @i, 1) > ''9'') or (substring(@ExternalID, @i, 1) < ''0''))
		begin
			set @returnID = substring (@ExternalID, 1, @i - 1)
			break
		end
	end

	return @returnID
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Date_EndOfMonth]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[Date_EndOfMonth]
	(@dtCurrent DATETIME) 
RETURNS DATETIME
AS
BEGIN
	RETURN DATEADD(DD, -1, CONVERT(DATETIME, CONVERT(VARCHAR, DATEPART(MM, DATEADD(MM, 1, @dtCurrent))) + ''/1/'' + CONVERT(VARCHAR, DATEPART(YY, DATEADD(MM, 1, @dtCurrent)))))
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Date_LocalToUTC]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE function [dbo].[Date_LocalToUTC]  
 (@inLocaleDateTime datetime,  -- the time to convert to local (should be a local datetime value)  
 @inTimeZoneAdj int,   -- the number of hours to adjust for the local timezone  
 @bObserveDaylightSavings tinyint) -- whether or not the local area observes US daylight savings time  
 returns datetime as
BEGIN

declare @outLocalDateTime datetime  
set @outLocalDateTime = dateadd(hh, -1 * @inTimeZoneAdj, @inLocaleDateTime)  
if (@bObserveDaylightSavings = 1) -- figure in daylight savings time  
BEGIN 
	declare @yearToCheck int  
	set @yearToCheck = datepart(yyyy, @outLocalDateTime)  
	declare @DSstart datetime, @DSend datetime  

	-- If 2k7 or greater...
	if ( @yearToCheck >= 2007 )
	BEGIN
	-- determine if we''re in daylight savings time (second Sunday in march through first Sunday in november)  
	   set @DSstart = convert(varchar(4), @yearToCheck) + ''-03-08 02:00:00.000''  
	   set @DSend = convert(varchar(4), @yearToCheck) + ''-11-1 02:00:00.000''  
	   -- figure out the first sunday in April  
	   while (datepart(dw, @DSstart) <> 1) -- dw is 1 for Sunday  
		set @DSstart = dateadd(dd, 1, @DSstart)  
	   -- figure out the last sunday in October  
	   while (datepart(dw, @DSend) <> 1) -- dw is 1 for Sunday  
		set @DSend = dateadd(dd, 1, @DSend)  
	END
	ELSE -- if less than 2k7
	BEGIN
		-- determine if we''re in daylight savings time (1st Sunday in April through last Sunday in October)  
		set @DSstart = convert(varchar(4), @yearToCheck) + ''-04-01 02:00:00.000''  
		set @DSend = convert(varchar(4), @yearToCheck) + ''-10-31 02:00:00.000''  
		-- figure out the first sunday in April  
		while (datepart(dw, @DSstart) <> 1) -- dw is 1 for Sunday  
			set @DSstart = dateadd(dd, 1, @DSstart)  
		-- figure out the last sunday in October  
		while (datepart(dw, @DSend) <> 1) -- dw is 1 for Sunday  
			set @DSend = dateadd(dd, -1, @DSend)  
	END

	-- If in daylight savings, adjust
	if ((@outLocalDateTime >= @DSstart) and (@outLocalDateTime < @DSend))  
		set @outLocalDateTime = dateadd(hh, -1, @outLocalDateTime)  

END -- if observe daylight savings
return @outLocalDateTime  

END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Date_MMDDYY]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



-- the function returns date in MMDDYY format
CREATE    FUNCTION [dbo].[Date_MMDDYY]
(
	@pDate DATETIME
)
RETURNS VARCHAR(6)
AS
BEGIN

	DECLARE @retDate VARCHAR(6)	
	SET @retDate =
		CASE WHEN @pDate <> '''' THEN
			 
			CASE WHEN DATEPART(mm,@pDate) < 10 THEN 
				''0'' + CONVERT(varchar,DATEPART(mm,@pDate)) + CASE WHEN DATEPART(dd,@pDate) < 10 THEN ''0'' + CONVERT(varchar,DATEPART(dd,@pDate)) + RIGHT(DATEPART(yy,@pDate),2) ELSE CONVERT(varchar,DATEPART(dd,@pDate)) + RIGHT(DATEPART(yy,@pDate),2) END
			ELSE
				CONVERT(varchar,DATEPART(mm,@pDate)) +  CASE WHEN DATEPART(dd,@pDate) < 10 THEN ''0'' + CONVERT(varchar,DATEPART(dd,@pDate)) + RIGHT(DATEPART(yy,@pDate),2) ELSE CONVERT(varchar,DATEPART(dd,@pDate)) + RIGHT(DATEPART(yy,@pDate),2) END
			END
		ELSE
			''''
		END
	RETURN @retDate

END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getEndOfMonth]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[getEndOfMonth]
	(@dtCurrent DATETIME) 
RETURNS DATETIME
AS
BEGIN
	RETURN dbo.Date_EndOfMonth(@dtCurrent)
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Date_RelativeFiscalMonthEnd]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[Date_RelativeFiscalMonthEnd]
(
	@dtCurrent DATETIME
)
RETURNS DATETIME
AS
BEGIN
	-- Returns the end of the fiscal month containing the given date
	DECLARE @currentPeriodEnd DATETIME 
	DECLARE @relativePeriodEnd DATETIME
	DECLARE @endOfMonthFlag SMALLINT

	SELECT @currentPeriodEnd = CurrentPeriodEnd, @endOfMonthFlag = CurrentPeriodEndOfMonth FROM PracticeSettings

	IF (@endOfMonthFlag = 1)
		SET @relativePeriodEnd = dbo.getEndOfMonth(@dtCurrent)
	ELSE
		BEGIN
			SET @relativePeriodEnd = DATEADD(MM, DATEDIFF(MM, @currentPeriodEnd, @dtCurrent), @currentPeriodEnd)
			IF (@relativePeriodEnd < @dtCurrent)
				SET @relativePeriodEnd = DATEADD(MM, 1, @relativePeriodEnd)
		END
	RETURN @relativePeriodEnd
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Date_RelativeFiscalYearEnd]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[Date_RelativeFiscalYearEnd]
(
	@dtCurrent datetime
)
RETURNS DATETIME
AS
BEGIN
	-- Returns the end of the fiscal year containing the given date 

	DECLARE @currentFiscalYearEnd DATETIME
	DECLARE @fiscalYearEnd DATETIME
	SELECT @currentFiscalYearEnd = FiscalYearEnd FROM PracticeSettings
 
	SET @fiscalYearEnd = DATEADD(YY, DATEDIFF(YY, @currentFiscalYearEnd, @dtCurrent), @currentFiscalYearEnd)

	IF (@fiscalYearEnd < @dtCurrent)
		SET @fiscalYearEnd = DATEADD(YY, 1, @fiscalYearEnd)
	RETURN @fiscalYearEnd
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Date_SameDay]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[Date_SameDay] (@dtDate1 DATE, @dtDate2 DATE)
RETURNS int AS
BEGIN
RETURN(select (CASE WHEN @dtDate1 = @dtDate2 THEN 1 ELSE 0 END))
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Date_Sunday]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[Date_Sunday]
 (@dateForSunday DATETIME,
 @isAPR INT)  

RETURNS DATETIME 
 AS  

BEGIN 
	DECLARE	 @date1 	 AS	DATETIME
	DECLARE	 @year 		AS	 INT

	SET	 @year=YEAR(@dateForSunday)		
	IF @isAPR = 0				--Firt Sunday of April
	BEGIN 
		SET	 @date1=CONVERT(DATETIME, CAST(@year AS VARCHAR)+''-4-1 02:00'')
			--print @date1
			WHILE 1 = 1
			BEGIN
				IF DATEPART(dw, @date1) = 1
				   BREAK			--First sunday of April
				ELSE
				   SET	 @date1=DATEADD(DAY, 1, @date1)
			END
			--print @date1
	END
	ELSE				--Last Sunday of October
	BEGIN
		SET	 @date1=CONVERT(DATETIME, cast(@year AS VARCHAR)+''-10-31 02:00'')
	
	--print @date1
	WHILE 1 = 1
	BEGIN
		IF DATEPART(dw, @date1) = 1
		   BREAK			--Last sunday of October
		ELSE
		   SET @date1=DATEADD(DAY, -1, @date1)
	END
	
	--print @date1
	END
	RETURN (@date1)
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Date_UTCToLocal]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[Date_UTCToLocal] 
	(	
		@utcDate DATETIME,
		@inTimeZoneAdj INT,					-- the number of hours to adjust for the local timezone
		@bObserveDaylightSavings TINYINT	-- whether or not the local area observes US daylight savings time
	)  
RETURNS 
	DATETIME
AS  
BEGIN 
	RETURN	DATEADD(mi,DATEDIFF(mi, dbo.Date_LocalToUTC(@utcDate, @inTimeZoneAdj, @bObserveDaylightSavings) ,@utcDate ),@utcDate)--Orignal
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getPracticeUTCDateTime]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE  function [dbo].[getPracticeUTCDateTime]
	(@inUTCDateTime datetime)		-- the time to convert to UTC (should be a local datetime value)
	returns datetime as
begin
	declare @inTimeZoneAdj int			-- the number of hours to adjust for the local timezone
	declare @bObserveDaylightSavings tinyint	-- whether or not the local area observes US daylight savings time

	select top 1 @inTimeZoneAdj=InTimeZoneAdj, @bObserveDaylightSavings=ObserveDaylightSavings from PracticeSettings
	return dbo.Date_LocalToUTC(@inUTCDateTime, @inTimeZoneAdj, @bObserveDaylightSavings)
end





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Date_UTCToLocal_Practice]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[Date_UTCToLocal_Practice] 
(@utcDate DATETIME)  
RETURNS 
	DATETIME
AS  
BEGIN 
Return	DateAdd(mi,dateDiff(mi, dbo.getPracticeUTCDateTime(@utcDate) ,@utcDate ),@utcDate)--Orignal
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DateAsYYYYMMInt]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[DateAsYYYYMMInt]
(@Date date)
RETURNS INT
AS
BEGIN
RETURN (YEAR(@Date) * 100) + MONTH(@Date)

END' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeleteKDBOverride]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[DeleteKDBOverride](@kdb [xml], @uid [uniqueidentifier])
RETURNS [xml] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[DeleteKDBOverride]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Diagnosis_GetCode]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE FUNCTION [dbo].[Diagnosis_GetCode] (@code9 varchar(25), @code10 varchar(25))
RETURNS varchar(25) AS
BEGIN

-- MIRRORS IMO_ICD_Helper in code

IF(NOT @code10 IS NULL)
	RETURN @code10;

IF (NOT @code9 IS NULL)
	RETURN @code9;

RETURN NULL; 

END 



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Diagnosis_GetFullDescription]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[Diagnosis_GetFullDescription] (@code9 varchar(25), @code10 varchar(25), @description varchar(255))
RETURNS varchar(512) AS
BEGIN

-- MIRRORS IMO_ICD_Helper in code

DECLARE @codePortion VARCHAR(100);

IF(@code10 IS NULL OR @code10='''')
	SET @codePortion = @code9;

IF(NOT @code10 IS NULL AND NOT @code10='''')
	SET @codePortion = @code10 + ''-'' + @code9;

IF (NOT @codePortion IS NULL AND NOT @codePortion='''')
	RETURN ''('' + @codePortion + '') '' + ISNULL(@description,''<DISC NOT DEFINED>''); -- DISC NOT DEFINED should never happen

RETURN ''''; 

END 





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DispensableDrugTypeDesc]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[DispensableDrugTypeDesc](@medid INT,
                                               @pmid VARCHAR(20),
                                               @federaldeaclasscode VARCHAR(1),
                                               @nametypecode VARCHAR(1),
                                               @refmultisourcecode VARCHAR(1),
                                               @reffederallegendcode VARCHAR(1),
                                               @medicaldeviceind SMALLINT,
                                               @refgenericdrugnamecode VARCHAR(1))  RETURNS VARCHAR(100)
AS
BEGIN
   RETURN CASE
             WHEN @medid IS NULL OR @medid < 1 THEN ''User Defined Drug''
             WHEN (@pmid IS NULL OR @pmid = '''') AND @medicaldeviceind <> 1 THEN ''NDC Required for non-supply Rx/''
             WHEN @federaldeaclasscode = ''0'' THEN ''''
             WHEN @federaldeaclasscode = ''1'' THEN ''DEA Schedule I/''
             WHEN @federaldeaclasscode = ''2'' THEN ''DEA Schedule II/''
             WHEN @federaldeaclasscode = ''3'' THEN ''DEA Schedule III/''
             WHEN @federaldeaclasscode = ''4'' THEN ''DEA Schedule IV/''
             WHEN @federaldeaclasscode = ''5'' THEN ''DEA Schedule V/''
             WHEN @federaldeaclasscode = ''6'' THEN ''Related products span multiple DEA Schedules/''
             ELSE ''Unknown DEA Schedule/''
          END +
          CASE
             WHEN @refmultisourcecode IN(''1'',''3'') AND @nametypecode = ''1'' THEN ''Multi Source Brand''
             WHEN @refmultisourcecode IN(''1'',''3'') AND @nametypecode = ''2'' THEN ''Multi Source Generic''
             WHEN @refmultisourcecode IN(''1'',''3'')                         THEN ''Multi Source''
             WHEN @refmultisourcecode = ''2''       AND @nametypecode = ''1'' THEN ''Single Source Brand''
             WHEN @refmultisourcecode = ''2''       AND @nametypecode = ''2'' THEN ''Single Source Generic''
             WHEN @refmultisourcecode = ''2''                               THEN ''Single Source''
             WHEN @nametypecode = ''1''                                     THEN ''Brand''
             WHEN @nametypecode = ''2''                                     THEN ''Generic''
             ELSE ''''
          END +
          CASE
             WHEN @reffederallegendcode = ''1'' THEN ''/Rx''
             WHEN @reffederallegendcode = ''2'' THEN ''/OTC''
             WHEN @reffederallegendcode = ''3'' THEN ''/Rx-OTC''
             ELSE ''''
          END +
          CASE
             WHEN @medicaldeviceind = 1         THEN ''/Supply''
             WHEN @refgenericdrugnamecode = ''0'' THEN ''/Compound''
             ELSE ''''
          END
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DispensablePA]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[DispensablePA](@medid INT,
                              @daw BIT,
                              @FormularyCoverageOrgUid UNIQUEIDENTIFIER)  RETURNS BIT
AS
BEGIN
   -- if no ePA for the dispensable drug, then no ePA
   IF NOT EXISTS(SELECT *
                 FROM FormularyCoverageNDC fcn (NOLOCK)
                 WHERE fcn.FormularyCoverageOrgUid = @FormularyCoverageOrgUid
                   AND fcn.medid = @medid
                   AND fcn.CoverageListType = ''PA'')
   BEGIN
      RETURN 0
   END

   -- if not allow checking generic alternatives, then ePA required (DAW or generic ePA disabled)
   IF (@daw = 1) RETURN 1

   -- get a list of generic alternatives
   DECLARE @Alternatives TABLE(medid INT NOT NULL PRIMARY KEY)
   INSERT INTO @Alternatives
   SELECT DISTINCT dis.medid
   FROM dbo.NDD_SearchDispensable dis
   INNER JOIN dbo.NDD_SearchDispensable lnk ON lnk.IsDelete = 0 AND lnk.medid = @medid AND lnk.gcnseqno = dis.gcnseqno
   WHERE dis.IsDelete = 0
     AND dis.statuscode = ''0''
     AND dis.medid != @medid
     AND dis.medid > 0
     AND dis.gcnseqno > 0
     AND dis.mnid != -1
     AND dis.DrugNameTypeCode = 2
     AND dis.Ndc != ''''

   -- if there are no generic alternatives, then ePA required
   IF (0 = (SELECT COUNT(*) FROM @Alternatives)) RETURN 1

   -- if one or more of the generic drugs does not require ePA, then ePA not required
   IF NOT EXISTS(SELECT *
                 FROM @Alternatives alt
                 LEFT JOIN dbo.FormularyCoverageNDC fcn (NOLOCK) ON fcn.medid = alt.medid
                                                             AND fcn.FormularyCoverageOrgUid = @FormularyCoverageOrgUid
                                                                AND fcn.CoverageListType = ''PA''
                 WHERE fcn.FormularyCoverageNDCUid IS NULL)
   BEGIN
      RETURN 0
   END

   -- all generics require ePA as well
   RETURN 1
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAllUsersInGroup]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- create UDF to allow Neo query to select objects visible to a user
CREATE FUNCTION [dbo].[GetAllUsersInGroup]
	(
	@UserGroupUid UniqueIdentifier
	)
RETURNS @retTable TABLE (UserUid UniqueIdentifier)
AS

BEGIN
	DECLARE @lUserGroupUid UniqueIdentifier

	DECLARE RetrieveUserGroups CURSOR STATIC LOCAL FOR
		SELECT DISTINCT MemberUserGroupUid FROM UserGroupMember WHERE UserGroupUid = @UserGroupUid AND MemberUserGroupUid IS NOT NULL

	INSERT INTO @retTable 
		SELECT DISTINCT MemberUserUid 
		FROM			UserGroupMember 
		WHERE			UserGroupUid = @UserGroupUid AND 
						MemberUserUid IS NOT NULL AND
						MemberUserUid NOT IN (SELECT UserUid FROM @retTable)

	OPEN RetrieveUserGroups

	FETCH NEXT FROM RetrieveUserGroups
	INTO @lUserGroupUid

	WHILE (@@FETCH_STATUS = 0) 
	BEGIN
		
		INSERT INTO @retTable
		select * from dbo.GetAllUsersInGroup(@lUserGroupUid)
   
		FETCH NEXT FROM RetrieveUserGroups INTO @lUserGroupUid
	END
	
	CLOSE RetrieveUserGroups
	DEALLOCATE RetrieveUserGroups

RETURN
END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsUserInGroup]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[IsUserInGroup](@UserGroupUid [uniqueidentifier], @UserUid [uniqueidentifier])
RETURNS [int] 
AS

begin
    declare @retValue int
	set @retValue=0

	select @retValue=1 from dbo.GetAllUsersInGroup(@UserGroupUid) u where u.UserUid = @UserUid
	return @retValue
end



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DoesUserUidHaveAccessToPatientChart]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[DoesUserUidHaveAccessToPatientChart] ( 
  @in_UserUid    [uniqueidentifier],
  @in_PatientUid [uniqueidentifier])
RETURNS [int]
AS
BEGIN
    DECLARE @retValue INT
	SET @retValue = 0

	--If user is specifially denied
	IF EXISTS(SELECT * FROM ChartAccessDeny WHERE ChartAccessDeny.PatientUid = @in_PatientUid and ChartAccessDeny.UserUid = @in_UserUid)
	BEGIN
		RETURN @retValue
	END

	DECLARE @cUserGroupUid uniqueidentifier
	DECLARE @found bit = 0;

	DECLARE curChartAccessDeny CURSOR FOR
		SELECT distinct UserGroupUid
		FROM ChartAccessDeny
		WHERE ChartAccessDeny.PatientUid = @in_PatientUid and ChartAccessDeny.UserGroupUid is not null

	OPEN curChartAccessDeny
	FETCH NEXT FROM curChartAccessDeny INTO @cUserGroupUid
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF(dbo.IsUserInGroup(@cUserGroupUid, @in_UserUid) = 1)
		BEGIN
			SET @found = 1
			BREAK;
		END
		FETCH NEXT FROM curChartAccessDeny INTO @cUserGroupUid
	END

	CLOSE curChartAccessDeny
	DEALLOCATE curChartAccessDeny 

	if (@found = 1)
	BEGIN
		RETURN @retValue
	END
	
	IF NOT EXISTS (SELECT * FROM ChartAccess WHERE ChartAccess.PatientUid = @in_PatientUid)
	BEGIN
	  SET @retValue = 1
	  RETURN @retValue
	END

	DECLARE @cChartAccessUid uniqueidentifier
	DECLARE @cPatientUid uniqueidentifier
	DECLARE @cUserUid uniqueidentifier

	DECLARE curChartAccess CURSOR FOR
	  SELECT ChartAccessUid, PatientUid, UserUid, UserGroupUid
	  FROM ChartAccess
	  WHERE ChartAccess.PatientUid = @in_PatientUid
	  
	OPEN curChartAccess
	FETCH NEXT FROM curChartAccess INTO @cChartAccessUid, @cPatientUid, @cUserUid, @cUserGroupUid
	WHILE @@FETCH_STATUS = 0
	BEGIN
	  IF (@cUserUid = @in_UserUid)
	  BEGIN
	    SET @retValue = 1
	    BREAK
	  END
	  
	  IF (@cUserGroupUid is not null)
	  BEGIN
	    IF (dbo.IsUserInGroup(@cUserGroupUid, @in_UserUid) = 1)
	    BEGIN
	      SET @retValue = 1
	      BREAK	    
	    END 	  
	  END
	  
	  FETCH NEXT FROM curChartAccess INTO @cChartAccessUid, @cPatientUid, @cUserUid, @cUserGroupUid  
	END   
	
	CLOSE curChartAccess
	DEALLOCATE curChartAccess 
	
	RETURN @retValue
END 




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DoesUserUidHaveAccessToVisit]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[DoesUserUidHaveAccessToVisit] ( 
  @userUid [uniqueidentifier],
  @visitUid [uniqueidentifier])
RETURNS [int]
AS
BEGIN
    DECLARE @retValue INT
	SET @retValue=0
	
	IF NOT EXISTS (SELECT * FROM VisitAccess WHERE VisitAccess.VisitUid = @visitUid)
    BEGIN
      SET @retValue = 1
      RETURN @retValue  
    END	
	
	DECLARE @curVisitAccessUid uniqueidentifier
	DECLARE @curVisitUid uniqueidentifier
	DECLARE @curUserUid uniqueidentifier
	DECLARE @curUserGroupUid uniqueidentifier
	
	DECLARE cursorVisitAccess CURSOR FOR
	  SELECT VisitAccessUid, VisitUid, UserUid, UserGroupUid 
	  FROM VisitAccess 
	  WHERE VisitAccess.VisitUid = @visitUid
	
	OPEN cursorVisitAccess
	FETCH NEXT FROM cursorVisitAccess INTO @curVisitAccessUid, @curVisitUid, @curUserUid, @curUserGroupUid
	WHILE @@FETCH_STATUS = 0
	BEGIN 
	  IF (@curUserUid = @userUid)
	  BEGIN
	    SET @retValue = 1
	    BREAK  
	  END
	  
	  IF (@curUserGroupUid is not null)
	  BEGIN
	    IF (dbo.IsUserInGroup(@curUserGroupUid, @userUid) = 1)
	    BEGIN
	      SET @retValue = 1
	      BREAK	    
	    END 
	  END
	  
	  FETCH NEXT FROM cursorVisitAccess INTO @curVisitAccessUid, @curVisitUid, @curUserUid, @curUserGroupUid 
	END
    	  
    CLOSE cursorVisitAccess
    DEALLOCATE cursorVisitAccess 	
	
	RETURN @retValue
END 


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DoesVisitHaveFormLayout]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[DoesVisitHaveFormLayout] (
	@VisitUid [uniqueidentifier], 
	@FormLayoutUid [uniqueidentifier])
RETURNS INT
AS
BEGIN
	declare @retValue int
	set @retValue=0

	SELECT @retValue=1
	FROM Visit v
	INNER JOIN RelFormLayoutClinicalNoteType rel on rel.ClinicalNoteTypeUid = v.ClinicalNoteTypeUid
	WHERE v.VisitUid = @VisitUid AND rel.FormLayoutUid = @FormLayoutUid
	
	return @retValue
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SplitStrings]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[SplitStrings](@str VARCHAR(MAX), @sep CHAR(1))
RETURNS @returns TABLE(idx INT PRIMARY KEY CLUSTERED, val VARCHAR(MAX))
AS
BEGIN
   DECLARE 
      @name VARCHAR(MAX),
      @pos  INT,
      @i    INT
   SET @i = -1
   WHILE CHARINDEX(@sep, @str) > 0
      BEGIN
         SELECT @pos  = CHARINDEX(@sep, @str)
         SELECT @name = SUBSTRING(@str, 1, @pos-1)
         
         SET @i = @i + 1
         INSERT INTO @returns 
         SELECT @i, @name
         
         SELECT @str = SUBSTRING(@str, @pos+1, LEN(@str)-@pos)
      END

   INSERT INTO @returns
   SELECT @i+1, @str
   
   RETURN   
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ParseEDI]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ParseEDI](@edi VARCHAR(MAX), @ediSegment VARCHAR(100))
RETURNS @parse TABLE(
      tag                  VARCHAR(100)   NOT NULL,
      segment              INT            NOT NULL,
      element              INT            NOT NULL,
      repitition           INT            NOT NULL,
      field                INT            NOT NULL,
      val                  VARCHAR(MAX)   NULL,
                                          PRIMARY KEY CLUSTERED(tag, segment),
                                          UNIQUE NONCLUSTERED(segment, element, repitition, field))
AS
BEGIN
   DECLARE
      @UNA_010_01          CHAR(1)        = SUBSTRING(@edi, 4, 1),
      @UNA_010_02          CHAR(1)        = SUBSTRING(@edi, 5, 1),
      @UNA_010_03          CHAR(1)        = SUBSTRING(@edi, 6, 1),
      @UNA_010_04          CHAR(1)        = SUBSTRING(@edi, 7, 1),
      @UNA_010_05          CHAR(1)        = SUBSTRING(@edi, 8, 1),
      @UNA_010_06          CHAR(1)        = SUBSTRING(@edi, 9, 1)

   DECLARE
      @tag                 VARCHAR(100),
      @segment             INT,
      @element             INT,
      @repitition          INT,
      @field               INT,
      @val                 VARCHAR(MAX)

   -- divide up the top level segments
   INSERT INTO @parse
   SELECT
      tag                = SUBSTRING(val, 1, 3) + CASE
                                                     WHEN SUBSTRING(val, 1, 3) = '''' THEN ''EOF''
                                                     WHEN val LIKE ''PVD'' + @UNA_010_02 + ''P2%'' THEN ''P2''
                                                     WHEN val LIKE ''PVD'' + @UNA_010_02 + ''PC%'' THEN ''PC''
                                                     WHEN val LIKE ''PVD'' + @UNA_010_02 + ''SU%'' THEN ''SU''
                                                     WHEN val LIKE ''DRU'' + @UNA_010_02 + ''D%'' THEN ''D''
                                                     ELSE ''''
                                                  END,
      segment            = idx+1,
      element            = 0,
      repitition         = 0,
      field              = 0,
      val                = val
   FROM dbo.SplitStrings(@edi, @UNA_010_06)
   WHERE @ediSegment IS NULL OR SUBSTRING(val, 1, 3) = @ediSegment

   -- parse segments
   DECLARE segmentCursor CURSOR STATIC FOR
   SELECT tag, segment, element, repitition, field, val FROM @parse WHERE segment > 0 AND element = 0 ORDER BY segment, element, repitition, field
   OPEN segmentCursor
   FETCH NEXT FROM segmentCursor INTO @tag, @segment, @element, @repitition, @field, @val
   WHILE @@FETCH_STATUS = 0
      BEGIN
         INSERT INTO @parse
         SELECT
          tag                = @tag + ''_'' + CASE
                                               WHEN idx < 10 THEN ''0''
                                               ELSE ''''
                                            END + CONVERT(VARCHAR(2), idx) + ''0'',
          segment            = @segment,
          element            = idx+1,
          repitition         = 0,
          field              = 0,
          val                = val
         FROM dbo.SplitStrings(@val, @UNA_010_02)
         FETCH NEXT FROM segmentCursor INTO @tag, @segment, @element, @repitition, @field, @val
      END
   CLOSE segmentCursor
   DEALLOCATE segmentCursor

   -- parse elements
   DECLARE segmentElement CURSOR STATIC FOR
   SELECT tag, segment, element, repitition, field, val FROM @parse WHERE segment > 0 AND element > 0 AND repitition = 0 ORDER BY segment, element, repitition, field
   OPEN segmentElement
   FETCH NEXT FROM segmentElement INTO @tag, @segment, @element, @repitition, @field, @val
   WHILE @@FETCH_STATUS = 0
      BEGIN
         INSERT INTO @parse
         SELECT
          tag                = @tag + ''_'' + CASE
                                               WHEN idx < 10 THEN ''X0''
                                               ELSE ''X''
    END + CONVERT(VARCHAR(2), idx+1),
          segment            = @segment,
          element            = @element,
          repitition         = idx+1,
          field              = 0,
          val                = val
         FROM dbo.SplitStrings(@val, @UNA_010_05)
         FETCH NEXT FROM segmentElement INTO @tag, @segment, @element, @repitition, @field, @val
      END
   CLOSE segmentElement
   DEALLOCATE segmentElement

   -- parse repititions
   DECLARE segmentRepitition CURSOR STATIC FOR
   SELECT tag, segment, element, repitition, field, val FROM @parse WHERE segment > 0 AND element > 0 AND repitition > 0 AND field = 0 ORDER BY segment, element, repitition, field
   OPEN segmentRepitition
   FETCH NEXT FROM segmentRepitition INTO @tag, @segment, @element, @repitition, @field, @val
   WHILE @@FETCH_STATUS = 0
      BEGIN
         INSERT INTO @parse
         SELECT
          tag                = SUBSTRING(@tag, 1, LEN(@tag) -4) + ''_'' +
                                         CASE
                                            WHEN idx+1 < 10 THEN ''0'' + CONVERT(VARCHAR(2), idx+1)
                                            ELSE CONVERT(VARCHAR(2), idx+1)
                                         END +
                                         CASE
                                            WHEN @repitition > 1 THEN ''_'' + CONVERT(VARCHAR(2), @repitition)
                                            ELSE ''''
                                         END,
          segment            = @segment,
          element            = @element,
          repitition         = @repitition,
          field              = idx + 1,
          val                = val
         FROM dbo.SplitStrings(@val, @UNA_010_01)
         FETCH NEXT FROM segmentRepitition INTO @tag, @segment, @element, @repitition, @field, @val
      END
   CLOSE segmentRepitition
   DEALLOCATE segmentRepitition

   RETURN
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EscapeXml]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[EscapeXml](@xml VARCHAR(MAX)) RETURNS VARCHAR(MAX) AS
BEGIN

	SET @xml = REPLACE(@xml, ''&'', ''&amp;'')
	SET @xml = REPLACE(@xml, ''>'', ''&gt;'')
	SET @xml = REPLACE(@xml, ''<'', ''&lt;'')
	SET @xml = REPLACE(@xml, ''"'', ''&quot;'')
	SET @xml = REPLACE(@xml, '''''''', ''&apos;'')
	RETURN @xml
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EDI2Xml]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[EDI2Xml](@edi VARCHAR(MAX)) RETURNS XML
AS
BEGIN
   -- Data Not Done (not comprehensive list yet
   --     <DrugCoverageStatusCode>PR</DrugCoverageStatusCode>
   --     <DrugCoverageStatusCode>AP</DrugCoverageStatusCode>
   --     <DrugCoverageStatusCode>PA</DrugCoverageStatusCode>
   --     <DrugCoverageStatusCode>NF</DrugCoverageStatusCode>
   --     <DrugCoverageStatusCode>NR</DrugCoverageStatusCode>
   --     <PriorAuthorizationStatus>A</PriorAuthorizationStatus>

   DECLARE
      @UNA_010_01          CHAR(1)        = SUBSTRING(@edi, 4, 1),
      @UNA_010_02          CHAR(1)        = SUBSTRING(@edi, 5, 1),
      @UNA_010_03          CHAR(1)        = SUBSTRING(@edi, 6, 1),
      @UNA_010_04          CHAR(1)        = SUBSTRING(@edi, 7, 1),
      @UNA_010_05          CHAR(1)        = SUBSTRING(@edi, 8, 1),
      @UNA_010_06          CHAR(1)        = SUBSTRING(@edi, 9, 1)

   DECLARE
      @MessageXML          VARCHAR(MAX),
      @tag                 VARCHAR(20),
      @segment             INT,
      @element             INT,
      @repitition          INT,
      @field               INT,
      @val                 VARCHAR(MAX)

   DECLARE @parse TABLE(
      tag                  VARCHAR(20)    NOT NULL PRIMARY KEY CLUSTERED,
      segment              INT            NOT NULL,
      element              INT            NOT NULL,
      repitition           INT            NOT NULL,
      field                INT            NOT NULL,
      val                  VARCHAR(MAX)   NULL,
                                          UNIQUE NONCLUSTERED(segment, element, repitition, field))
   INSERT INTO @parse SELECT * FROM dbo.ParseEDI(@edi, null)

   -- strip the SPI out of PVDPC identifiers
   IF EXISTS(SELECT * FROM @parse WHERE tag LIKE ''PVDPC_020_02%'' AND val = ''SPI'')
      BEGIN
         DELETE @parse
       WHERE segment    = (SELECT segment    FROM @parse WHERE tag LIKE ''PVDPC_020_02%'' AND val = ''SPI'')
         AND element    = (SELECT element    FROM @parse WHERE tag LIKE ''PVDPC_020_02%'' AND val = ''SPI'')
         AND repitition = (SELECT repitition FROM @parse WHERE tag LIKE ''PVDPC_020_02%'' AND val = ''SPI'')
         AND field > 0
      END

   -- Provider Specialty
   IF EXISTS(SELECT * FROM @parse WHERE tag LIKE ''PVDPC_040_01'' AND val != '''')
      BEGIN
         UPDATE @parse
         SET val = ''''
         WHERE tag = ''PVDPC_040_01''
      END
   IF EXISTS(SELECT * FROM @parse WHERE tag LIKE ''PVDPC_040_02'' AND val != '''')
      BEGIN
         UPDATE @parse
         SET val = ''''
         WHERE tag = ''PVDPC_040_02''
      END
   IF EXISTS(SELECT * FROM @parse WHERE tag LIKE ''PVDSU_040_01'' AND val != '''')
      BEGIN
         UPDATE @parse
         SET val = ''''
         WHERE tag = ''PVDSU_040_01''
      END
   IF EXISTS(SELECT * FROM @parse WHERE tag LIKE ''PVDSU_040_02'' AND val != '''')
      BEGIN
         UPDATE @parse
         SET val = ''''
         WHERE tag = ''PVDSU_040_02''
      END

   -- Convert State Codes to Upper Case
   UPDATE @parse
   SET val = UPPER(val)
   WHERE tag IN(''PVDP2_080_03'', ''PVDPC_080_03'', ''PVDSU_080_03'', ''PTT_060_03'')

   -- Make sure the telephone is TE
   UPDATE @parse
   SET val = ''TE''
   WHERE tag IN(''PTT_070_02'')
     AND val != ''TE''

   -- DRU Form Code
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_03'')
      BEGIN
         -- NDC
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_03'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_02''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_04'')
      BEGIN
         -- NDC Code
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_04'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''ND''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_03''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_05'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_05'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_04''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_06'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_06'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_05''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_07'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_07'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_06''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_08'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_08'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_07''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_09'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_09'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_08''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_10'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_10'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_09''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_11'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_11'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_10''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_12'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_12'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_11''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_13'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_13'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''AA''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_12''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_14'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_14'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''C38046''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_13''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_15'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_15'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''AB''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_14''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_16'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_16'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''C38046''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_15''
      END

   UPDATE @parse
   SET val = ''AA''
   WHERE tag = ''DRU_010_13''
     AND val != ''AA''

   UPDATE @parse
   SET val = ''C38046''
   WHERE tag = ''DRU_010_14''
     AND val != ''C38046''

   UPDATE @parse
   SET val = ''AB''
   WHERE tag = ''DRU_010_15''
     AND val != ''AB''

   UPDATE @parse
   SET val = ''C38046''
   WHERE tag = ''DRU_010_16''
     AND val != ''C38046''

   -- Quantity Code
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_020_03'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_020_03'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''38''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_020_02''
      END

   UPDATE @parse
   SET val = ''38''
   WHERE tag = ''DRU_020_03''
     AND val != ''38''

   -- Potency Unit Code
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_020_04'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_020_04'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''AC''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_020_03''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_020_05'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_020_05'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''C38046''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_020_04''
      END
      
   UPDATE @parse
   SET val = ''AC''
   WHERE tag = ''DRU_020_04''
     AND val != ''AC''

   UPDATE @parse
   SET val = ISNULL((SELECT CASE qty.val
                               WHEN ''12'' THEN ''C48521''
                               WHEN ''AR'' THEN ''C48539''
                               WHEN ''AV'' THEN ''C48480''
                               WHEN ''BG'' THEN ''C48474''
                               WHEN ''BO'' THEN ''C48477''
                               WHEN ''BX'' THEN ''C48478''
                               WHEN ''CH'' THEN ''C48484''
                               WHEN ''CQ'' THEN ''C48481''
                               WHEN ''EA'' THEN ''C64933''
                               WHEN ''FO'' THEN ''C48494''
                               WHEN ''GR'' THEN ''C48155''
                               WHEN ''IH'' THEN ''C62275''
                               WHEN ''KT'' THEN ''C48504''
                               WHEN ''LT'' THEN ''C48505''
                               WHEN ''ME'' THEN ''C28253''
                               WHEN ''ML'' THEN ''C28254''
                               WHEN ''PT'' THEN ''C48529''
                               WHEN ''SZ'' THEN ''C48540''
                               WHEN ''TB'' THEN ''C48549''
                               WHEN ''U2'' THEN ''C48542''
                               WHEN ''UU'' THEN ''C48506''
                               WHEN ''VI'' THEN ''C48551''
                               WHEN ''Y2'' THEN ''C48541''
                               WHEN ''Y3'' THEN ''C48544''
                               WHEN ''Y7'' THEN ''C69124''
                               ELSE ''C38046''
                            END
                     FROM @parse qty
                     WHERE qty.tag = ''DRU_020_01''
                       AND qty.val != ''''), ''C38046'')
   WHERE tag = ''DRU_020_05''

   -- Quantity Qualifier
   UPDATE @parse
   SET val = ''''
   WHERE tag = ''DRU_020_01''
     AND val != ''''

   -- X fields in 10.6
   UPDATE @parse
   SET val = ''''
   WHERE tag IN(''DRU_010_05'',
                ''DRU_010_07'',
                ''DRU-020-01'',
                ''DRU-030-01'',
                ''DRUD_010_05'',
                ''DRUD_010_07'',
                ''DRUD-020-01'',
                ''DRUD-030-01'',
                ''UIB-010-03'',
                ''UIB-010-04'',
                ''UIB-020'',
                ''UIB-040'',
                ''UIB-050'',
                ''UIB-080-03'',
                ''UIB-090'',
                ''UIH-010-05'',
                ''UIH-040'',
                ''UIH-050-03'',
                ''UIH-060'',
                ''REQ-040'',
                ''REQ-050'',
                ''PVDP2-030'',
                ''PVDP2-040-02'',
                ''PVDP2-060'',
                ''PVDP2-100'',
                ''PVDPC-030'',
                ''PVDPC-040-02'',
                ''PVDPC-060'',
                ''PVDSU-030'',
                ''PVDSU-040-02'',
                ''PVDSU-060'',
                ''OBS-010-03'',
                ''COO-030'',
                ''COO-040-02'',
                ''COO-090'',
                ''COO-110'',
                ''COO-120'',
                ''COO-130'',
                ''COO-140'',
                ''UIZ-010'',
                ''UIZ-030'')

   -- Make sure there is a MedicationDispensed segment (clone MedicationPrescribed if not)
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRUD'')
      BEGIN
         UPDATE @parse
         SET segment = segment + 1
         FROM @parse
         WHERE segment > (SELECT segment FROM @parse WHERE tag = ''DRU'')

         INSERT INTO @parse
         SELECT
            tag = REPLACE(tag, ''DRU'', ''DRUD''),
            segment = segment + 1,
            element = element,
            repitition = repitition,
            field      = field,
            val        = CASE (tag)
                            WHEN ''DRU_010_01'' THEN ''D''
                            ELSE val
                         END
         FROM @parse
         WHERE tag = ''DRU'' OR tag LIKE ''DRU_%''

         UPDATE @parse
         SET val = CONVERT(VARCHAR(MAX), 1 + CONVERT(INT, val))
         WHERE tag = ''UIT_020_01''
      END

   -- Now Reconstruct the EDI
   UPDATE @parse SET val = '''' WHERE field = 0

   -- reconstruct repititions
   DECLARE segmentField CURSOR STATIC FOR
   SELECT tag, segment, element, repitition, field, val FROM @parse WHERE segment > 0 AND element > 0 AND repitition > 0 AND field > 0 ORDER BY segment, element, repitition, field
   OPEN segmentField
   FETCH NEXT FROM segmentField INTO @tag, @segment, @element, @repitition, @field, @val
   WHILE @@FETCH_STATUS = 0
      BEGIN
         UPDATE @parse
         SET val = val + CASE WHEN @field = 1 THEN '''' ELSE @UNA_010_01 END + @val
         WHERE segment = @segment
AND element = @element
           AND repitition = @repitition
           AND field = 0
         FETCH NEXT FROM segmentField INTO @tag, @segment, @element, @repitition, @field, @val
      END
   CLOSE segmentField
   DEALLOCATE segmentField

   -- reconstruct elements
   DECLARE segmentField CURSOR STATIC FOR
   SELECT tag, segment, element, repitition, field, val FROM @parse WHERE segment > 0 AND element > 0 AND repitition > 0 AND field = 0 ORDER BY segment, element, repitition, field
   OPEN segmentField
   FETCH NEXT FROM segmentField INTO @tag, @segment, @element, @repitition, @field, @val
   WHILE @@FETCH_STATUS = 0
      BEGIN
         UPDATE @parse
         SET val = val + CASE WHEN @repitition = 1 THEN '''' ELSE @UNA_010_05 END + @val
         WHERE segment = @segment
           AND element = @element
           AND repitition = 0
           AND field = 0
         FETCH NEXT FROM segmentField INTO @tag, @segment, @element, @repitition, @field, @val
      END
   CLOSE segmentField
   DEALLOCATE segmentField

   -- reconstruct segments
   DECLARE segmentField CURSOR STATIC FOR
   SELECT tag, segment, element, repitition, field, val FROM @parse WHERE segment > 0 AND element > 0 AND repitition = 0 AND field = 0 ORDER BY segment, element, repitition, field
   OPEN segmentField
   FETCH NEXT FROM segmentField INTO @tag, @segment, @element, @repitition, @field, @val
   WHILE @@FETCH_STATUS = 0
      BEGIN
         UPDATE @parse
         SET val = val + CASE WHEN @element = 1 THEN '''' ELSE @UNA_010_02 END + @val
         WHERE segment = @segment
      AND element = 0
           AND repitition = 0
           AND field = 0
         FETCH NEXT FROM segmentField INTO @tag, @segment, @element, @repitition, @field, @val
      END
   CLOSE segmentField
   DEALLOCATE segmentField

   -- reconstruct edi
   DECLARE @oldedi VARCHAR(MAX) = @edi
   SELECT @edi = ''''
   DECLARE segmentField CURSOR STATIC FOR
   SELECT tag, segment, element, repitition, field, val FROM @parse WHERE segment > 0 AND element = 0 AND repitition = 0 AND field = 0 ORDER BY segment, element, repitition, field
   OPEN segmentField
   FETCH NEXT FROM segmentField INTO @tag, @segment, @element, @repitition, @field, @val
   WHILE @@FETCH_STATUS = 0
      BEGIN
         SELECT @edi = @edi + CASE WHEN @segment = 1 THEN '''' ELSE @UNA_010_06 END + val
         FROM @parse
         WHERE segment = @segment
           AND element = 0
           AND repitition = 0
           AND field = 0
         FETCH NEXT FROM segmentField INTO @tag, @segment, @element, @repitition, @field, @val
      END
   CLOSE segmentField
   DEALLOCATE segmentField

   -- Now reconstruct the XML using the modified EDI as starting point
   DELETE @parse
   INSERT INTO @parse SELECT * FROM dbo.ParseEDI(@edi, null) ORDER BY segment, element, repitition, field

   DECLARE @binary TABLE(data VARBINARY(MAX))
   INSERT INTO @binary VALUES(CAST(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(@edi, ''&'', ''&amp;''), ''<'', ''&lt;''), ''>'', ''&gt;''), ''"'', ''&quot;''), '''''''', ''&apos;'') AS VARBINARY(MAX)))

   SET @MessageXML =
      ''<RefillRequest.eRxService xmlns="http://www.ncpdp.org/schema/SCRIPT" version="010" release="006"''
    + '' MessageID="''                   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_030_01''), '''') + ''"''
    +    '' RelatesToMessageID="''          + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_030_02''), '''') + ''"''
    +    '' RxReferenceNumber="''           + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIH_020_01''), '''') + ''"''
    +    '' SentTime="''                    + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_080_01''), 1, 4) + ''-''
                                                 + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_080_01''), 5, 2) + ''-''
                                                 + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_080_01''), 7, 2) + ''T''
                                                 + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_080_02''), 1, 2) + '':''
                                                 + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_080_02''), 3, 2) + '':''
                                                 + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_080_02''), 5, 2)
                                                 + CASE WHEN ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_080_02''), 8, 1), '''') != ''''
                                                      THEN ''.'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_080_02''), 8, 1) ELSE '''' END
                                                 + ''Z'', '''') + ''">''
    +    ''<To Qualifier="D">''             + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_070_01''), '''') + ''</To>''
    +    ''<From Qualifier="P">''           + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_060_01''), '''') + ''</From>''
    +    ''<Request>''
    +       ''<ReturnReceipt>''             + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''REQ_020''), ''0'') + ''</ReturnReceipt>''
    +       ''<RequestReferenceNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''REQ_030''), '''') + ''</RequestReferenceNumber>''
    +    ''</Request>''
    +    ''<Pharmacy>''
    +       ''<Identification>''
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_02'')
                  WHEN ''SPI'' THEN ''<SPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</SPI>''
                  WHEN ''D3''  THEN ''<NCPDPID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</NCPDPID>''
                  WHEN ''94''  THEN ''<FileID>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</FileID>''
                  WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</MedicaidNumber>''
                  WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</PayerID>''
                  WHEN ''BO''  THEN ''<BINLocationNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</BINLocationNumber>''
                  WHEN ''DH''  THEN ''<DEANumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</PriorAuthorization>''
                  WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</NPI>''
 WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_02_2'')
                  WHEN ''SPI'' THEN ''<SPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</SPI>''
                  WHEN ''D3''  THEN ''<NCPDPID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</NCPDPID>''
                  WHEN ''94''  THEN ''<FileID>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</FileID>''
                  WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</MedicaidNumber>''
                  WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</PayerID>''
                  WHEN ''BO''  THEN ''<BINLocationNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</BINLocationNumber>''
                  WHEN ''DH''  THEN ''<DEANumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</PriorAuthorization>''
                  WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</NPI>''
                  WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_02_3'')
                  WHEN ''SPI'' THEN ''<SPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</SPI>''
                  WHEN ''D3''  THEN ''<NCPDPID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</NCPDPID>''
                  WHEN ''94''  THEN ''<FileID>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</FileID>''
                  WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</MedicaidNumber>''
   WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</PayerID>''
                  WHEN ''BO''  THEN ''<BINLocationNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</BINLocationNumber>''
                  WHEN ''DH''  THEN ''<DEANumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</PriorAuthorization>''
                  WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</NPI>''
                  WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +       ''</Identification>''
    +       ''<Specialty>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_040_01''), '''') + ''</Specialty>''
    +       ''<Pharmacist>''
    +          ''<LastName>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_050_01''), '''') + ''</LastName>''
    +          ''<FirstName>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_050_02''), '''') + ''</FirstName>''
    +          ''<MiddleName>''             + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_050_03''), '''') + ''</MiddleName>''
    +          ''<Suffix>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_050_04''), '''') + ''</Suffix>''
    +          ''<Prefix>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_050_05''), '''') + ''</Prefix>''
    +       ''</Pharmacist>''
    +       ''<StoreName>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_070''), '''') + ''</StoreName>''
    +       ''<Address>''
    +          ''<AddressLine1>''           + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_080_01''), '''') + ''</AddressLine1>''
    +          ''<AddressLine2>''           + CASE WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_080_05'') = ''AD2''
                                                THEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_080_06''), '''')
                                                ELSE ''''
                                            END + ''</AddressLine2>''
    +          ''<City>''                   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_080_02''), '''') + ''</City>''
    +          ''<State>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_080_03''), '''') + ''</State>''
    +          ''<ZipCode>''                + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_080_04''), '''') + ''</ZipCode>''
    +          ''<PlaceLocationQualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_080_05''), '''') + ''</PlaceLocationQualifier>''
    +       ''</Address>''
    +       ''<CommunicationNumbers>''
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01'' ), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01''  ), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_02''  ), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_2''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_2''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_02_2''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_3''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_3''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_02_3''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_4''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_4''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_02_4''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_5''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_5''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_02_5''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_6''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_6''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_02_6''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_7''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_7''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_02_7''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_8''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_8''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_02_8''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_9''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_9''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_02_9''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +       ''</CommunicationNumbers>''
    +    ''</Pharmacy>''
    +    ''<Prescriber>''
    +       ''<Identification>''
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_02'')
                  WHEN ''SPI'' THEN ''<SPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</SPI>''
                  WHEN ''D3''  THEN ''<NCPDPID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</NCPDPID>''
                  WHEN ''94''  THEN ''<FileID>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</FileID>''
     WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</MedicaidNumber>''
                  WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</PayerID>''
                  WHEN ''BO''  THEN ''<BINLocationNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</BINLocationNumber>''
                  WHEN ''DH''  THEN ''<DEANumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</PriorAuthorization>''
                WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</NPI>''
                  WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_02_2'')
                  WHEN ''SPI'' THEN ''<SPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</SPI>''
                  WHEN ''D3''  THEN ''<NCPDPID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</NCPDPID>''
                  WHEN ''94''  THEN ''<FileID>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</FileID>''
                  WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</MedicaidNumber>''
                  WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</PayerID>''
                  WHEN ''BO''  THEN ''<BINLocationNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</BINLocationNumber>''
 WHEN ''DH'' THEN ''<DEANumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</PriorAuthorization>''
                  WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</NPI>''
                  WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_02_3'')
                  WHEN ''SPI'' THEN ''<SPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</SPI>''
                  WHEN ''D3''  THEN ''<NCPDPID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</NCPDPID>''
                  WHEN ''94''  THEN ''<FileID>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</FileID>''
                  WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</MedicaidNumber>''
                  WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</PayerID>''
                  WHEN ''BO''  THEN ''<BINLocationNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</BINLocationNumber>''
                  WHEN ''DH''  THEN ''<DEANumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</PriorAuthorization>''
                  WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</NPI>''
                  WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +       ''</Identification>''
    +       ''<Specialty>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_040_01''), '''') + ''</Specialty>''
    +       ''<ClinicName>''                + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_070''), '''') + ''</ClinicName>''
    +       ''<Name>''
    +          ''<LastName>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_050_01''), '''') + ''</LastName>''
    +          ''<FirstName>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_050_02''), '''') + ''</FirstName>''
    +          ''<MiddleName>''             + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_050_03''), '''') + ''</MiddleName>''
    +          ''<Suffix>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_050_04''), '''') + ''</Suffix>''
    +          ''<Prefix>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_050_05''), '''') + ''</Prefix>''
    +       ''</Name>''
    +       ''<Address>''
    +          ''<AddressLine1>''           + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_080_01''), '''') + ''</AddressLine1>''
    +          ''<AddressLine2>''           + CASE WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_080_05'') = ''AD2'' THEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_080_06''), '''') ELSE '''' END + ''</AddressLine2>''
    +          ''<City>''                   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_080_02''), '''') + ''</City>''
    +          ''<State>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_080_03''), '''') + ''</State>''
    +          ''<ZipCode>''                + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_080_04''), '''') + ''</ZipCode>''
    +          ''<PlaceLocationQualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_080_05''), '''') + ''</PlaceLocationQualifier>''
    +       ''</Address>''
    +   ''<CommunicationNumbers>''
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01''  ), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01''  ), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_02''  ), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_2''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_2''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_02_2''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_3''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_3''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_02_3''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_4''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_4''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_02_4''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_5''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_5''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_02_5''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_6''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_6''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_02_6''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +  CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_7''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_7''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_02_7''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_8''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_8''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_02_8''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_9''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_9''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_02_9''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +       ''</CommunicationNumbers>''
    +       CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_100_01''), '''') != ''''
               THEN ''<PrescriberAgent>''
                  +    ''<LastName>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_100_01''), '''') + ''</LastName>''
                  +    ''<FirstName>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_100_02''), '''') + ''</FirstName>''
                  + ''<MiddleName>''     + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_100_03''), '''') + ''</MiddleName>''
                  +    ''<Suffix>''         + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_100_04''), '''') + ''</Suffix>''
                  +    ''<Prefix>''         + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_100_05''), '''') + ''</Prefix>''
                  + ''</PrescriberAgent>''
               ELSE ''''
            END
    +    ''</Prescriber>''
    + CASE WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU'') IS NOT NULL THEN
         ''<Supervisor>''
    +       ''<Identification>''
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_02'')
                  WHEN ''SPI'' THEN ''<SPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</SPI>''
                  WHEN ''D3''  THEN ''<NCPDPID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</NCPDPID>''
                  WHEN ''94''  THEN ''<FileID>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</FileID>''
                  WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</MedicaidNumber>''
                  WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</PayerID>''
                  WHEN ''BO''  THEN ''<BINLocationNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</BINLocationNumber>''
                  WHEN ''DH''  THEN ''<DEANumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</PriorAuthorization>''
                  WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</NPI>''
                  WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_02_2'')
                  WHEN ''SPI'' THEN ''<SPI>''     + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</SPI>''
                  WHEN ''D3''  THEN ''<NCPDPID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</NCPDPID>''
                  WHEN ''94''  THEN ''<FileID>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</FileID>''
                  WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</MedicaidNumber>''
                  WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</PayerID>''
                  WHEN ''BO''  THEN ''<BINLocationNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</BINLocationNumber>''
                  WHEN ''DH''  THEN ''<DEANumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</PriorAuthorization>''
                  WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</NPI>''
                  WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_02_3'')
                  WHEN ''SPI'' THEN ''<SPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</SPI>''
                  WHEN ''D3''  THEN ''<NCPDPID>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</NCPDPID>''
      WHEN ''94''  THEN ''<FileID>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</FileID>''
                  WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</MedicaidNumber>''
                  WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</PayerID>''
                  WHEN ''BO''  THEN ''<BINLocationNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</BINLocationNumber>''
                  WHEN ''DH''  THEN ''<DEANumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</PriorAuthorization>''
                  WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</NPI>''
                  WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +       ''</Identification>''
    +       ''<Specialty>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_040_01''), '''') + ''</Specialty>''
    +       ''<ClinicName>''                + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_070''), '''') + ''</ClinicName>''
    +       ''<Name>''
    +          ''<LastName>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_050_01''), '''') + ''</LastName>''
    +          ''<FirstName>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_050_02''), '''') + ''</FirstName>''
    +          ''<MiddleName>''             + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_050_03''), '''') + ''</MiddleName>''
    +          ''<Suffix>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_050_04''), '''') + ''</Suffix>''
    +          ''<Prefix>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_050_05''), '''') + ''</Prefix>''
    +       ''</Name>''
    +       ''<Address>''
    +          ''<AddressLine1>''           + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_080_01''), '''') + ''</AddressLine1>''
    +          ''<AddressLine2>''           + CASE WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_080_05'') = ''AD2'' THEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_080_06''), '''') ELSE '''' END + ''</AddressLine2>''
    +          ''<City>''                   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_080_02''), '''') + ''</City>''
  +    ''<State>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_080_03''), '''') + ''</State>''
    +          ''<ZipCode>''                + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_080_04''), '''') + ''</ZipCode>''
    +          ''<PlaceLocationQualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_080_05''), '''') + ''</PlaceLocationQualifier>''
    +       ''</Address>''
    +       ''<CommunicationNumbers>''
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01''  ), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01''  ), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_02''  ), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_2''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_2''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_02_2''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_3''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_3''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_02_3''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_4''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_4''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_02_4''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_5''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_5''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_02_5''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_6''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_6''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_02_6''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_7''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_7''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_02_7''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_8''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_8''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_02_8''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_9''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_9''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_02_9''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +       ''</CommunicationNumbers>''
    +     CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_100_01''), '''') != ''''
         THEN ''<PrescriberAgent>''
            +    ''<LastName>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_100_01''), '''') + ''</LastName>''
                  +    ''<FirstName>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_100_02''), '''') + ''</FirstName>''
                  +    ''<MiddleName>''     + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_100_03''), '''') + ''</MiddleName>''
                  +    ''<Suffix>''         + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_100_04''), '''') + ''</Suffix>''
                  +    ''<Prefix>''         + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_100_05''), '''') + ''</Prefix>''
                  + ''</PrescriberAgent>''
               ELSE ''''
            END
    +    ''</Supervisor>''
         ELSE '''' END
    +    ''<Patient>''
    +       ''<PatientRelationship>1</PatientRelationship>''
    +       ''<Identification>''
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_02'')
                  WHEN ''SPI'' THEN ''<SPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</SPI>''
                  WHEN ''D3''  THEN ''<NCPDPID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</NCPDPID>''
                  WHEN ''94''  THEN ''<FileID>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</FileID>''
                WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</MedicaidNumber>''
                  WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</PayerID>''
                  WHEN ''BO''  THEN ''<BINLocationNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</BINLocationNumber>''
                  WHEN ''DH''  THEN ''<DEANumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</PriorAuthorization>''
                  WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</NPI>''
                  WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_02_2'')
                  WHEN ''SPI'' THEN ''<SPI>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</SPI>''
WHEN ''D3''  THEN ''<NCPDPID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</NCPDPID>''
  WHEN ''94''  THEN ''<FileID>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</FileID>''
                  WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</MedicaidNumber>''
                  WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</PayerID>''
                  WHEN ''BO''  THEN ''<BINLocationNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</BINLocationNumber>''
                  WHEN ''DH''  THEN ''<DEANumber>''         + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</PriorAuthorization>''
                  WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</NPI>''
                  WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_02_3'')
                  WHEN ''SPI'' THEN ''<SPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</SPI>''
                  WHEN ''D3''  THEN ''<NCPDPID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</NCPDPID>''
                  WHEN ''94''  THEN ''<FileID>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</FileID>''
                  WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</MedicaidNumber>''
                  WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</PayerID>''
          WHEN ''BO''  THEN ''<BINLocationNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</BINLocationNumber>''
                  WHEN ''DH''  THEN ''<DEANumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</PriorAuthorization>''
                  WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</NPI>''
                  WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +       ''</Identification>''
    +       ''<Name>''
    +          ''<LastName>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_030_01''), '''') + ''</LastName>''
    +          ''<FirstName>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_030_02''), '''') + ''</FirstName>''
    +          ''<MiddleName>''             + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_030_03''), '''') + ''</MiddleName>''
    +          ''<Suffix>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_030_04''), '''') + ''</Suffix>''
    +          ''<Prefix>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_030_05''), '''') + ''</Prefix>''
    +       ''</Name>''
    +       ''<Gender>''                    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_040''), '''') + ''</Gender>''
    +       ''<DateOfBirth><Date>''         + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_020''), 1, 4) + ''-''
                                                     + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_020''), 5, 2) + ''-''
                                                     + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_020''), 7, 2) + ''</Date></DateOfBirth>''
    +       ''<Address>''
    +          ''<AddressLine1>''           + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_060_01''), '''') + ''</AddressLine1>''
    +          ''<AddressLine2>''           + CASE WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_060_05'') = ''AD2'' THEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_060_06''), '''') ELSE '''' END + ''</AddressLine2>''
    +          ''<City>''                   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_060_02''), '''') + ''</City>''
    +          ''<State>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_060_03''), '''') + ''</State>''
    +          ''<ZipCode>''                + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_060_04''), '''') + ''</ZipCode>''
    +          ''<PlaceLocationQualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_060_05''), '''') + ''</PlaceLocationQualifier>''
    +       ''</Address>''
    +       ''<CommunicationNumbers>''
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01''  ), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01''  ), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_02''  ), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_2''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_2''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_02_2''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_3''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_3''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_02_3''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_4''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_4''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_02_4''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_5''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_5''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_02_5''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_6''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_6''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_02_6''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_7''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_7''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_02_7''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_8''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_8''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_02_8''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_9''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_9''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_02_9''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +       ''</CommunicationNumbers>''
    +    ''</Patient>''
    +    ''<MedicationPrescribed>''
    +       CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_10''), '''') + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_11''), '''') + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_12''), '''') != ''''
               THEN ''<DrugDescription>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_10''), '''') + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_11''), '''') + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_12''), '''') + ''</DrugDescription>''
               ELSE ''<DrugDescription>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_02''), '''') + ''</DrugDescription>''
            END
    +       ''<DrugCoded>''
    +          ''<ProductCode>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_03''), '''') + ''</ProductCode>''
    +          ''<ProductCodeQualifier>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_04''), '''') + ''</ProductCodeQualifier>''
    +          ''<Strength>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_06''), '''') + ''</Strength>''
    +       ''<DrugDBCode>''             + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_08''), '''') + ''</DrugDBCode>''
    +          ''<DrugDBCodeQualifier>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_09''), '''') + ''</DrugDBCodeQualifier>''
    +          ''<FormSourceCode/>''
    +          ''<FormCode>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_05''), '''') + ''</FormCode>''
    +          ''<StrengthSourceCode/>''
    +          ''<StrengthCode>''           + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_07''), '''') + ''</StrengthCode>''
    +       ''</DrugCoded>''
    +       ''<Quantity>''
    +          ''<Value>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_020_02''), '''') + ''</Value>''
    +          ''<CodeListQualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_020_03''), '''') + ''</CodeListQualifier>''
    +          ''<UnitSourceCode>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_020_04''), '''') + ''</UnitSourceCode>''
    +          ''<PotencyUnitCode>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_020_05''), '''') + ''</PotencyUnitCode>''            -- CMR??? we need to look this one up
    +       ''</Quantity>''
    +       CASE
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_01''  ) = ''ZDS'' THEN ''<DaysSupply>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02''  ), '''') + ''</DaysSupply>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_01_2'') = ''ZDS'' THEN ''<DaysSupply>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_2''), '''') + ''</DaysSupply>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_01_3'') = ''ZDS'' THEN ''<DaysSupply>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_3''), '''') + ''</DaysSupply>''
               ELSE ''''
            END
    +       ''<Directions>''                + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_030_02''), '''') + ''</Directions>''
    +       ''<Note>''                      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_090_01''), '''')
                                          + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_090_01_2''), '''')
                                          + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_090_01_3''), '''')
    +       ''</Note>''
    +       ''<Refills>''
    +         ''<Qualifier>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_060_01''), '''') + ''</Qualifier>''
    +         ''<Value>''                   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_060_02''), '''') + ''</Value>''
    +       ''</Refills>''
    +       ''<Substitutions>''             + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_050''), '''') + ''</Substitutions>''
    +       CASE
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_01''  ) = ''85'' THEN ''<WrittenDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02''  ), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02''  ), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02''  ), 1, 4), '''') + ''</WrittenDate>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_01_2'') = ''85'' THEN ''<WrittenDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_2''), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_2''), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_2''), 1, 4), '''') + ''</WrittenDate>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_01_3'') = ''85'' THEN ''<WrittenDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_3''), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_3''), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_3''), 1, 4), '''') + ''</WrittenDate>''
               ELSE ''''
            END
    +       CASE
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_01''  ) = ''LD'' THEN ''<LastFillDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02''  ), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02''  ), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02''  ), 1, 4), '''') + ''</LastFillDate>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_01_2'') = ''LD'' THEN ''<LastFillDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_2''), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_2''), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_2''), 1, 4), '''') + ''</LastFillDate>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_01_3'') = ''LD'' THEN ''<LastFillDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_3''), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_3''), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_3''), 1, 4), '''') + ''</LastFillDate>''
               ELSE ''''
            END
    +    ''</MedicationPrescribed>''
    +    ''<MedicationDispensed>'' +
    +     CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_10''), '''') + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_11''), '''') + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_12''), '''') != ''''
               THEN ''<DrugDescription>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_10''), '''') + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_11''), '''') + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_12''), '''') + ''</DrugDescription>''
               ELSE ''<DrugDescription>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_02''), '''') + ''</DrugDescription>''
            END
    +       ''<DrugCoded>''
    +          ''<ProductCode>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_03''), '''') + ''</ProductCode>''
    +          ''<ProductCodeQualifier>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_04''), '''') + ''</ProductCodeQualifier>''
    +          ''<Strength>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_06''), '''') + ''</Strength>''
    +          ''<DrugDBCode>''             + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_08''), '''') + ''</DrugDBCode>''
    +          ''<DrugDBCodeQualifier>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_09''), '''') + ''</DrugDBCodeQualifier>''
    +          ''<FormSourceCode/>''
    +          ''<FormCode>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_05''), '''') + ''</FormCode>''
    +          ''<StrengthSourceCode/>''
    +          ''<StrengthCode>''           + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_07''), '''') + ''</StrengthCode>''
    +       ''</DrugCoded>''
    +       ''<Quantity>''
    +          ''<Value>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_020_02''), '''') + ''</Value>''
    +          ''<CodeListQualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_020_03''), '''') + ''</CodeListQualifier>''
    +          ''<UnitSourceCode>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_020_04''), '''') + ''</UnitSourceCode>''
    +          ''<PotencyUnitCode>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_020_05''), '''') + ''</PotencyUnitCode>''            -- CMR??? we need to look this one up
    +       ''</Quantity>''
    +       CASE
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_01''  ) = ''ZDS'' THEN ''<DaysSupply>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02''  ), '''') + ''</DaysSupply>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_01_2'') = ''ZDS'' THEN ''<DaysSupply>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_2''), '''') + ''</DaysSupply>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_01_3'') = ''ZDS'' THEN ''<DaysSupply>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_3''), '''') + ''</DaysSupply>''
               ELSE ''''
            END
    +       ''<Directions>''                + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_030_02''), '''') + ''</Directions>''
    +       ''<Note>''                      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_090_01''), '''')
                                          + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_090_01_2''), '''')
                                          + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_090_01_3''), '''')
    +       ''</Note>''
    +       ''<Refills>''
    +         ''<Qualifier>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_060_01''), '''') + ''</Qualifier>''
    +         ''<Value>''                   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_060_02''), '''') + ''</Value>''
    +       ''</Refills>''
    +       ''<Substitutions>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_050''), '''') + ''</Substitutions>''
    +       CASE
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_01''  ) = ''85'' THEN ''<WrittenDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02''  ), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02''  ), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02''  ), 1, 4), '''') + ''</WrittenDate>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_01_2'') = ''85'' THEN ''<WrittenDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_2''), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_2''), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_2''), 1, 4), '''') + ''</WrittenDate>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_01_3'') = ''85'' THEN ''<WrittenDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_3''), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_3''), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_3''), 1, 4), '''') + ''</WrittenDate>''
               ELSE ''''
            END
    +       CASE
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_01''  ) = ''LD'' THEN ''<LastFillDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02''  ), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02''  ), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02''  ), 1, 4), '''') + ''</LastFillDate>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_01_2'') = ''LD'' THEN ''<LastFillDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_2''), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_2''), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_2''), 1, 4), '''') + ''</LastFillDate>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_01_3'') = ''LD'' THEN ''<LastFillDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_3''), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_3''), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_3''), 1, 4), '''') + ''</LastFillDate>''
               ELSE ''''
            END
    +    ''</MedicationDispensed>'' +
    +    ''<EDIFACTMessage>'' + (SELECT CAST('''' AS XML).value(''xs:base64Binary(xs:hexBinary(sql:column("data")))'' , ''VARCHAR(MAX)'') FROM @binary) + ''</EDIFACTMessage>''
    + ''</RefillRequest.eRxService>''

   RETURN CONVERT(XML, @MessageXML)
--SELECT CONVERT(XML, @MessageXML)
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EncryptPHI]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE function [dbo].[EncryptPHI]
	()
	returns bit as
begin

	declare @ret bit
	IF EXISTS ( SELECT 1 FROM ListProductParameter where ParameterName = ''EncryptPHI'' and BoolValue = 1 )
		SET @ret = 1
	ELSE
		SET @ret = 0

	return @ret

end




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ERAGetClaimAdjustments]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ERAGetClaimAdjustments](@ERAClaimPaymentInfoUid UNIQUEIDENTIFIER)
RETURNS VARCHAR(50)
AS
BEGIN
	DECLARE @list VARCHAR(50)

	select @list = ISNULL((@list + ''; ''), '''') + 
	                cadj.GroupCode + ''-'' + cadj.ReasonCode + 
	                case when cadj.Amount < 0 then '' ($'' + convert(varchar,-(cadj.Amount),1) + '')'' 
	                     else '' $'' + convert(varchar,cadj.Amount,1) + '''' end 
	from ERAClaimAdjustment cadj
	Where cadj.ERAClaimPaymentInfoUid = @ERAClaimPaymentInfoUid
	ORDER BY cadj.GroupCode, cadj.ReasonCode, cadj.Amount

	return ISNULL(@list, '''')
END


        

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ERAGetCoinsuranceAmount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ERAGetCoinsuranceAmount](@ERAServicePaymentInfoUid UNIQUEIDENTIFIER)
RETURNS MONEY
AS
BEGIN
	DECLARE @ReturnValue MONEY

	SELECT  @ReturnValue = SUM(Amount) FROM ERAServiceAdjustment 
	WHERE ERAServicePaymentInfoUid = @ERAServicePaymentInfoUid AND GroupCode = ''PR'' AND ReasonCode = ''2'' and Amount is not null
	IF (@ReturnValue is null) SET @ReturnValue = 0
	RETURN @ReturnValue
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ERAGetDeductibleAmount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ERAGetDeductibleAmount](@ERAServicePaymentInfoUid UNIQUEIDENTIFIER)
RETURNS MONEY
AS
BEGIN
	DECLARE @ReturnValue MONEY

	SELECT  @ReturnValue = SUM(Amount) FROM ERAServiceAdjustment 
	WHERE ERAServicePaymentInfoUid = @ERAServicePaymentInfoUid AND GroupCode = ''PR'' AND ReasonCode = ''1'' and Amount is not null
	IF (@ReturnValue is null) SET @ReturnValue = 0
	RETURN @ReturnValue
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ERAGetGroupReasonCode]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ERAGetGroupReasonCode](@ERAServicePaymentInfoUid UNIQUEIDENTIFIER)
RETURNS VARCHAR(50)
AS
BEGIN
	DECLARE @list VARCHAR(50)
	SELECT @list = ISNULL((@list + '', ''), '''') + sa.GroupCode + ''-'' + sa.ReasonCode
	FROM ERAServiceAdjustment sa
	WHERE sa.ERAServicePaymentInfoUid = @ERAServicePaymentInfoUid AND
		  sa.ReasonCode NOT IN (''1'', ''2'') AND 
          sa.GroupCode is not NULL AND 
          sa.ReasonCode is not NULL
	ORDER BY sa.LastModifiedDate

	return ISNULL(@list, '''')
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ERAGetLateFilingCharge]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ERAGetLateFilingCharge](@ERAClaimPaymentInfoUid UNIQUEIDENTIFIER)
RETURNS MONEY
AS
BEGIN
	DECLARE @ReturnValue MONEY
	
	SELECT @ReturnValue = SUM(sa.Amount)
	FROM ERAServicePaymentInfo spi 
			INNER JOIN ERAServiceAmount sa on spi.ERAClaimPaymentInfoUid = @ERAClaimPaymentInfoUid
												AND spi.ERAServicePaymentInfoUid = sa.ERAServicePaymentInfoUid
												AND sa.QualifierCode = ''KH'' -- Deduction Amount Late Filing Reduction
	GROUP BY spi.ERAClaimPaymentInfouID
	IF (@ReturnValue is null) SET @ReturnValue = 0
	RETURN @ReturnValue
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ERAGetLQRemarks]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ERAGetLQRemarks](@ERAServicePaymentInfoUid UNIQUEIDENTIFIER)
RETURNS VARCHAR(50)
AS
BEGIN
	DECLARE @list VARCHAR(50)

	select @list = ISNULL((@list + '', ''), '''') + hrc.IndustryCode
	from ERAHealthCareRemarkCode hrc
	Where hrc.ERAServicePaymentInfoUid = @ERAServicePaymentInfoUid
	ORDER BY hrc.IndustryCode

	return ISNULL(@list, '''')
END


        
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ERAGetReasonCodeAmount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ERAGetReasonCodeAmount](@ERAServicePaymentInfoUid UNIQUEIDENTIFIER)
RETURNS MONEY
AS
BEGIN
	DECLARE @ReturnValue MONEY

	SELECT  @ReturnValue = SUM(Amount) FROM ERAServiceAdjustment 
	WHERE ERAServicePaymentInfoUid = @ERAServicePaymentInfoUid 
		  AND ReasonCode NOT IN (''1'',''2'') and Amount is not null
	IF (@ReturnValue is null) SET @ReturnValue = 0
	RETURN @ReturnValue
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ERAGetTransactionError]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[ERAGetTransactionError](@ERATransactionSetUid UNIQUEIDENTIFIER)
RETURNS VARCHAR(1024)
AS
BEGIN
	DECLARE @retVal VARCHAR(1024)
	SET @retVal = NULL
	
	SELECT top 1 @retVal = tse.ErrorText 
    FROM ERATransactionSetError tse with (nolock)
    where tse.ERATransactionSetUid = @ERATransactionSetUid
    ORDER BY tse.LastModifiedDate asc
    
    IF ( @retVal IS NULL )
    BEGIN
	 SELECT top 1 @retVal = cpie.ErrorText 
	 FROM ERAHeader h with (nolock) 
		JOIN ERAClaimPaymentInfo cpi with (nolock) ON h.ERATransactionSetUid = @ERATransactionSetUid
										AND h.ERAHeaderUid = cpi.ERAHeaderUid
		JOIN ERAClaimPaymentInfoError cpie with (nolock) ON cpie.ERAClaimPaymentInfoUid = cpi.ERAClaimPaymentInfoUid
	 ORDER BY cpie.LastModifiedDate asc	  
    END
    
    IF ( @retVal IS NULL )
    BEGIN  
	 SELECT top 1 @retVal = spie.ErrorText 
	 FROM ERAHeader h with (nolock) 
			JOIN ERAClaimPaymentInfo cpi with (nolock) ON h.ERATransactionSetUid = @ERATransactionSetUid
												AND h.ERAHeaderUid = cpi.ERAHeaderUid
			JOIN ERAServicePaymentInfo spi with (nolock) ON spi.ERAClaimPaymentInfoUid = cpi.ERAClaimPaymentInfoUid
			JOIN ERAServicePaymentInfoError spie with (nolock) ON spie.ERAServicePaymentInfoUid = spi.ERAServicePaymentInfoUid
     ORDER BY spie.LastModifiedDate asc
    END
	
	return ISNULL(@retVal, '''')
END


        


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[eRxCoverageFromXML]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[eRxCoverageFromXML]
(
	@coverageXML XML
)
RETURNS @eRxCoverage TABLE
(
	Payor VARCHAR (100),
	PayorID VARCHAR (100),
	LastName VARCHAR (50),
	FirstName VARCHAR (50),
	MiddleName VARCHAR (50),
	Prefix VARCHAR (25),
	Suffix VARCHAR (50),
	DOB DATETIME,
	Gender VARCHAR (1),
	Address1 VARCHAR (100),
	Address2 VARCHAR (100),
	City VARCHAR (25),
	State VARCHAR (3),
	Zip VARCHAR (10),
	RelationshipCode VARCHAR (2),
	Relationship VARCHAR (100),
	StudentStatus VARCHAR (100),
	SubcriberID VARCHAR (100),
	HealthPlanName VARCHAR (100),
	HealthPlanID VARCHAR (100),
	CardholderName VARCHAR (100),
	CardholderID VARCHAR (100),
	PersonCode VARCHAR (25),
	GroupName VARCHAR (100),
	GroupID VARCHAR (100),
	BIN VARCHAR (100),
	PCN VARCHAR (100),
	FormularyID VARCHAR (100),
	AlternativesID VARCHAR (100),
	CoverageID VARCHAR (100),
	CopayID VARCHAR (100),
	ServiceDate DATETIME,
	EligibilityDate DATETIME,
	PharmacyEligible BIT,
	MailOrderEligible BIT
)
AS
BEGIN
	DECLARE @subcriberXML XML,
		@dependentXML XML,
		@coverageInfoXML XML
	
	SELECT 
		@subcriberXML = x.n.query(''subcriber''),
		@dependentXML = x.n.query(''dependent'')
	FROM @coverageXML.nodes(''//coverage'') AS x(n)
	
	SET	@coverageInfoXML =	CASE WHEN @dependentXML IS NOT NULL AND LEN (CAST (@dependentXML AS VARCHAR (MAX))) > 0 THEN @dependentXML
								 ELSE @subcriberXML
							END;
	
	WITH cteeRxCoverage AS
	(
		SELECT 
	-- Payor information
			(SELECT x.n.value(''@organizationName'',''varchar(100)'')
			 FROM @coverageXML.nodes(''//payor'') AS x(n)) AS Payor,
			(SELECT x.n.value(''@ParticipantID'',''varchar(100)'')
			 FROM @coverageXML.nodes(''//payor'') AS x(n)) AS PayorID,

	-- subcriber information
			(SELECT x.n.value(''@lastName'',''varchar(50)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberLastName,
			(SELECT x.n.value(''@firstName'',''varchar(50)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberFirstName,
			(SELECT x.n.value(''@middleName'',''varchar(50)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberMiddleName,
			(SELECT x.n.value(''@prefix'',''varchar(25)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberPrefix,
			(SELECT x.n.value(''@suffix'',''varchar(50)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberSuffix,
			(SELECT x.n.value(''@DOB'',''datetime'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberDOB,
			(SELECT x.n.value(''@gender'',''varchar(1)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberGender,
			(SELECT x.n.value(''@address1'',''varchar(100)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberAddress1,
			(SELECT x.n.value(''@address2'',''varchar(100)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberAddress2,
			(SELECT x.n.value(''@city'',''varchar(25)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberCity,
			(SELECT x.n.value(''@state'',''varchar(3)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberState,
			(SELECT x.n.value(''@zip'',''varchar(10)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberZip,
			(SELECT x.n.value(''@relationshipCode'',''varchar(2)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberRelationshipCode,
			(SELECT x.n.value(''@relationship'',''varchar(100)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberRelationship,
			(SELECT x.n.value(''@studentStatus'',''varchar(100)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberStudentStatus,
			 
	-- dependent information
			(SELECT x.n.value(''@lastName'',''varchar(50)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentLastName,
			(SELECT x.n.value(''@firstName'',''varchar(50)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentFirstName,
			(SELECT x.n.value(''@middleName'',''varchar(50)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentMiddleName,
			(SELECT x.n.value(''@prefix'',''varchar(25)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentPrefix,
			(SELECT x.n.value(''@suffix'',''varchar(50)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentSuffix,
			(SELECT x.n.value(''@DOB'',''datetime'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentDOB,
			(SELECT x.n.value(''@gender'',''varchar(1)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentGender,
			(SELECT x.n.value(''@address1'',''varchar(100)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentAddress1,
			(SELECT x.n.value(''@address2'',''varchar(100)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentAddress2,
			(SELECT x.n.value(''@city'',''varchar(25)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentCity,
			(SELECT x.n.value(''@state'',''varchar(3)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentState,
			(SELECT x.n.value(''@zip'',''varchar(10)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentZip,
			(SELECT x.n.value(''@relationshipCode'',''varchar(2)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentRelationshipCode,
			(SELECT x.n.value(''@relationship'',''varchar(100)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentRelationship,
			(SELECT x.n.value(''@studentStatus'',''varchar(100)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentStudentStatus,
			 
	-- Coverage information
			(SELECT x.n.value(''@SubcriberID'',''varchar(100)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS SubcriberID,
			 
			(SELECT x.n.value(''@HealthPlanName'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''18'''']'') AS x(n)) AS HealthPlanName,
			(SELECT x.n.value(''@HealthPlanID'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''18'''']'') AS x(n)) AS HealthPlanID,
			(SELECT x.n.value(''@CardholderName'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''1W'''']'') AS x(n)) AS CardholderName,
			(SELECT x.n.value(''@CardholderID'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''1W'''']'') AS x(n)) AS CardholderID,
			(SELECT x.n.value(''@PersonCode'',''varchar(25)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''49'''']'') AS x(n)) AS PersonCode,
			(SELECT x.n.value(''@GroupName'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''6P'''']'') AS x(n)) AS GroupName,
			(SELECT x.n.value(''@GroupID'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''6P'''']'') AS x(n)) AS GroupID,
			(SELECT x.n.value(''@BIN'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''N6'''']'') AS x(n)) AS BIN,
			(SELECT x.n.value(''@PCN'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''N6'''']'') AS x(n)) AS PCN,
			(SELECT x.n.value(''@FormularyID'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''IF'''']'') AS x(n)) AS FormularyID,
			(SELECT x.n.value(''@AlternativesID'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''IF'''']'') AS x(n)) AS AlternativesID,
			(SELECT x.n.value(''@CoverageID'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''1L'''']'') AS x(n)) AS CoverageID,
			(SELECT x.n.value(''@CopayID'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''IG'''']'') AS x(n)) AS CopayID,
			(SELECT x.n.value(''@ServiceDate'',''datetime'')
			 FROM @coverageInfoXML.nodes(''//subcriberDates/subcriberDate[@dtpQualifier = ''''472'''']'') AS x(n)) AS ServiceDate,
			(SELECT x.n.value(''@EligibilityDate'',''datetime'')
			 FROM @coverageInfoXML.nodes(''//subcriberDates/subcriberDate[@dtpQualifier = ''''307'''']'') AS x(n)) AS EligibilityDate,
			(SELECT x.n.value(''@coverageTypeCode'',''varchar(10)'')
			 FROM @coverageInfoXML.nodes(''//eligibility[@serviceTypeCode = ''''88'''']'') AS x(n)) AS PharmacyEligible,
			(SELECT x.n.value(''@coverageTypeCode'',''varchar(10)'')
			 FROM @coverageInfoXML.nodes(''//eligibility[@serviceTypeCode = ''''90'''']'') AS x(n)) AS MailOrderEligible
	)
	INSERT @eRxCoverage
	SELECT
		CASE WHEN Payor = '''' THEN NULL ELSE Payor END AS Payor,
		CASE WHEN PayorID = '''' THEN NULL ELSE PayorID END AS PayorID,
		COALESCE (dependentLastName, subcriberLastName) AS LastName,
		COALESCE (dependentFirstName, subcriberFirstName) AS FirstName,
		CASE WHEN COALESCE (dependentMiddleName, subcriberMiddleName) = '''' THEN NULL
			ELSE COALESCE (dependentMiddleName, subcriberMiddleName) END AS MiddleName,
		CASE WHEN COALESCE (dependentPrefix, subcriberPrefix) = '''' THEN NULL
			ELSE COALESCE (dependentPrefix, subcriberPrefix) END AS Prefix,
		CASE WHEN COALESCE (dependentSuffix, subcriberSuffix) = '''' THEN NULL
			ELSE COALESCE (dependentSuffix, subcriberSuffix) END AS Suffix,
		COALESCE (dependentDOB, subcriberDOB) AS DOB,
		COALESCE (dependentGender, subcriberGender) AS Gender,
		COALESCE (dependentAddress1, subcriberAddress1) AS Address1,
		CASE WHEN COALESCE (dependentAddress2, subcriberAddress2) = '''' THEN NULL
			ELSE COALESCE (dependentAddress2, subcriberAddress2) END AS Address2,
		COALESCE (dependentCity, subcriberCity) AS City,
		COALESCE (dependentState, subcriberState) AS State,
		COALESCE (dependentZip, subcriberZip) AS Zip,
		COALESCE (dependentRelationshipCode, subcriberRelationshipCode) AS RelationshipCode,
		COALESCE (dependentRelationship, subcriberRelationship) AS Relationship,
		COALESCE (dependentStudentStatus, subcriberStudentStatus) AS StudentStatus,
		CASE WHEN SubcriberID = '''' THEN NULL ELSE SubcriberID END AS SubcriberID,
		CASE WHEN HealthPlanName = '''' THEN NULL ELSE HealthPlanName END AS HealthPlanName,
		CASE WHEN HealthPlanID = '''' THEN NULL ELSE HealthPlanID END AS HealthPlanID,
		CASE WHEN CardholderName = '''' THEN NULL ELSE CardholderName END AS CardholderName,
		CASE WHEN CardholderID = '''' THEN NULL ELSE CardholderID END AS CardholderID,
		CASE WHEN PersonCode = '''' THEN NULL ELSE PersonCode END AS PersonCode,
		CASE WHEN GroupName = '''' THEN NULL ELSE GroupName END AS GroupName,
		CASE WHEN GroupID = '''' THEN NULL ELSE GroupID END AS GroupID,
		CASE WHEN BIN = '''' THEN NULL ELSE BIN END AS BIN,
		CASE WHEN PCN = '''' THEN NULL ELSE PCN END AS PCN,
		CASE WHEN FormularyID = '''' THEN NULL ELSE FormularyID END AS FormularyID,
		CASE WHEN AlternativesID = '''' THEN NULL ELSE AlternativesID END AS AlternativesID,
		CASE WHEN CoverageID = '''' THEN NULL ELSE CoverageID END AS CoverageID,
		CASE WHEN CopayID = '''' THEN NULL ELSE CopayID END AS CopayID,
		CASE WHEN ServiceDate = '''' THEN NULL ELSE ServiceDate END AS ServiceDate,
		CASE WHEN EligibilityDate = '''' THEN NULL ELSE EligibilityDate END AS EligibilityDate,
		CASE WHEN PharmacyEligible = ''1'' THEN PharmacyEligible ELSE 0 END AS PharmacyEligible,
		CASE WHEN MailOrderEligible = ''1'' THEN MailOrderEligible ELSE 0 END AS MailOrderEligible
	FROM cteeRxCoverage
	
	RETURN
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[eRxOutbound_getRecent]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[eRxOutbound_getRecent] 
(
	@Guid UNIQUEIDENTIFIER
)
RETURNS UNIQUEIDENTIFIER
AS  
BEGIN 

DECLARE @ReturnGuid UNIQUEIDENTIFIER

set @ReturnGuid = null

SELECT TOP 1 @ReturnGuid = eRxOutbound.eRxOutboundUid 
from eRxOutbound 
where (RelVisitMedicationUid = @Guid)
order by LastModifiedDate desc

RETURN @ReturnGuid

END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[eRxOutbound_getRecentLastModifiedDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[eRxOutbound_getRecentLastModifiedDate] 
(
	@Guid UNIQUEIDENTIFIER
)
RETURNS DATETIME
AS  
BEGIN 

DECLARE @Return DATETIME

set @Return = null

SELECT TOP 1 @Return = eRxOutbound.LastModifiedDate 
from eRxOutbound 
where (RelVisitMedicationUid = @Guid)
order by LastModifiedDate desc

RETURN @Return

END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[eRxOutbound_getRecentSuccessful]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[eRxOutbound_getRecentSuccessful] 
(
	@Guid UNIQUEIDENTIFIER
)
RETURNS BIT
AS  
BEGIN 

DECLARE @Return BIT

set @Return = null

SELECT TOP 1 @Return = eRxOutbound.Successful 
from eRxOutbound 
where (RelVisitMedicationUid = @Guid)
order by LastModifiedDate desc

RETURN @Return

END
 
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EscapeXmlElementName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[EscapeXmlElementName](@xml VARCHAR(MAX)) RETURNS VARCHAR(MAX) AS
BEGIN
	SET @xml = REPLACE(@xml, ''&'', '''')
	SET @xml = REPLACE(@xml, ''>'', '''')
	SET @xml = REPLACE(@xml, ''<'', '''')
	SET @xml = REPLACE(@xml, ''"'', '''')
	SET @xml = REPLACE(@xml, '''''''', '''')
	SET @xml = REPLACE(@xml, ''+'', '''')
	SET @xml = REPLACE(@xml, ''|'', '''')
    SET @xml = REPLACE(@xml,'' '','''')

    DECLARE @FirstChar VARCHAR = NULL
    SET @FirstChar = LEFT(@xml,1)
	IF ASCII(UPPER(@FirstChar)) NOT BETWEEN 65 AND 90
	BEGIN
	    IF ASCII(@FirstChar) BETWEEN 48 AND 57
		BEGIN
            SET @xml = ''NUM_'' + @xml
		END
		ELSE
		BEGIN
			SET @xml = ''SCHAR_'' + @xml
		END
	END

	RETURN @xml
END

/*
select convert(XML,''<''+[dbo].[EscapeXmlElementName](''game'')+'' />'')
select convert(XML,''<''+[dbo].[EscapeXmlElementName](''9'')+'' />'')
select convert(XML,''<''+[dbo].[EscapeXmlElementName](''_game'')+'' />'')
select convert(XML,''<''+[dbo].[EscapeXmlElementName](''&game'')+'' />'')
select convert(XML,''<''+[dbo].[EscapeXmlElementName](''"game'')+'' />'')
select convert(XML,''<''+[dbo].[EscapeXmlElementName](''>game'')+'' />'')
select convert(XML,''<''+[dbo].[EscapeXmlElementName](''<game'')+'' />'')
select convert(XML,''<''+[dbo].[EscapeXmlElementName](''+ga-me'')+'' />'')
select convert(XML,''<''+[dbo].[EscapeXmlElementName](''-|game'')+'' />'')
*/' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EZPAY_getNextDetailRec]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


-- =============================================
-- Author:		Patrick Pappenfus, Wiregrass Solutions,  LLC
-- Create date: 1/22/2008
-- Description:	Function for retrieving next Settlement Detail RecNo.
-- =============================================
CREATE FUNCTION [dbo].[EZPAY_getNextDetailRec] 
(
)
RETURNS int
AS
BEGIN
	DECLARE @nextrec int

    SELECT @nextrec = case when max(recno) is null then 1 else MAX(RECNO) + 1 end FROM EZPAYSETTLEMENT_DETAILS
	RETURN @nextrec 
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EZPAY_getNextHistoryRecNo]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

-- =============================================
-- Author:		Patrick Pappenfus, Wiregrass Solutions,  LLC
-- Create date: 1/22/2008
-- Description:	Function for retrieving next History RecNo.
-- =============================================
CREATE FUNCTION [dbo].[EZPAY_getNextHistoryRecNo] 
(
)
RETURNS int
AS
BEGIN
	DECLARE @nextrec int

	SELECT @nextrec = MAX(RECNO) + 1 FROM EZPAYSETTLEMENT_HISTORY
    IF @nextrec IS NULL SELECT @nextrec = 1 

	RETURN @nextrec
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EZPAY_getNextMerchRec]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =============================================
-- Author:		Patrick Pappenfus, Wiregrass Solutions,  LLC
-- Create date: 1/22/2008
-- Description:	Function for retrieving next merchant rec no.
-- =============================================
CREATE FUNCTION [dbo].[EZPAY_getNextMerchRec] 
(
)
RETURNS int
AS
BEGIN
	DECLARE @nextrec int

	SELECT @nextrec = MAX(MERCH_REC) + 1 FROM EZPAYMERCHANT_SETTINGS

	RETURN @nextrec
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FDBSearchString]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[FDBSearchString](@MedDesc VARCHAR(125)) RETURNS VARCHAR(125) AS
BEGIN
   RETURN UPPER(RTRIM(LTRIM((
                   REPLACE(REPLACE(REPLACE(
                   REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(
                   REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(@MedDesc, ''.'', ''''), '''''''', ''''), ''"'', ''''), ''#'', ''''), ''!'', ''''), ''%'', ''''),
                                                                             ''/'', '' ''), ''+'', '' ''), ''-'', '' ''), ''_'', '' ''), ''('', '' ''), '')'', '' ''), ''<'', '' ''), ''>'', '' ''), '','', '' ''), '':'', '' ''),
                                                                             ''  '', '' ''), ''  '', '' ''), ''  '', '' '')))))
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FirstDayOfWeek]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE FUNCTION [dbo].[FirstDayOfWeek] 
(
    @date DATETIME
)
RETURNS DATETIME
AS
BEGIN
	DECLARE @dtFirstDayOfWeek DATETIME
    SET @dtFirstDayOfWeek = CAST (CONVERT (VARCHAR (16), DATEADD(DD, 1 - DATEPART(DW, @date), @date), 101) AS DATETIME)
	RETURN @dtFirstDayOfWeek
END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[fn_GetCQMSystemCode]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[fn_GetCQMSystemCode]()
RETURNS @CodeSystem TABLE
(
	RootID		VARCHAR(50),
	CodeSystem	VARCHAR(50)
)
--SELECT * FROM DBO.fn_GetCQMSystemCOde()
/*
Since we do not store the name assocaited to a root ID anywhere, I created a table valued function that 
can be used by whatever code needs to have that name.
*/
AS
BEGIN
	INSERT INTO @CodeSystem
	VALUES
	(''2.16.840.1.113883.6.96''		,''SNOMED''				),
	(''2.16.840.1.113883.6.4''		,''LOINC''				),
	(''2.16.840.1.113883.3.221.5''	,''SOP''					),  
	(''2.16.840.1.113883.6.13''		,''CDT''					),
	(''2.16.840.1.113883.6.285''		,''HCPCS''				),
	(''2.16.840.1.113883.6.104''		,''ICD-9-PCS''			),
	(''2.16.840.1.113883.6.90''		,''ICD-10-CM''			),
	(''2.16.840.1.113883.6.12''		,''CPT''					),
	(''2.16.840.1.113883.6.238''		,''CDCREC Race/Ethnicity''),
	(''2.16.840.1.113883.6.1''		,''LOINC''				),
	(''2.16.840.1.113883.12.292''		,''CVX''					),
	(''2.16.840.1.113883.6.103''		,''ICD-9-CM''				),
	(''2.16.840.1.113883.5.1''		,''AdministrativeGender''	),
	(''2.16.840.1.113883.6.88''		,''RxNorm''				),
	(''2.16.840.1.113883.18.2''		,''AdministrativeSex''	)
	RETURN 
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FormularyCopayDescription]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[FormularyCopayDescription](
   @FlatCopayAmount       VARCHAR(10),
   @PercentCopayRate      VARCHAR(10),
   @FirstCopayTerm        VARCHAR(1),
   @MinimumCopay          VARCHAR(10),
   @MaximumCopay          VARCHAR(10),
   @DaysSupplyPerCopay    VARCHAR(3),
   @CopayTier             VARCHAR(2),
   @MaximumCopayTier      VARCHAR(2),
   @OutOfPocketRangeStart VARCHAR(10),
   @OutOfPocketRangeEnd   VARCHAR(10)) RETURNS VARCHAR(MAX) AS
BEGIN
   RETURN CASE
              WHEN @FlatCopayAmount IS NOT NULL AND ISNULL(@FirstCopayTerm, ''F'') != ''P'' AND @PercentCopayRate IS NOT NULL THEN ''$'' + @FlatCopayAmount + '' + ''
              WHEN @FlatCopayAmount IS NOT NULL AND ISNULL(@FirstCopayTerm, ''F'') != ''P'' THEN ''$'' + @FlatCopayAmount
              ELSE ''''
           END +
           CASE
              WHEN @PercentCopayRate IS NOT NULL THEN CONVERT(VARCHAR(10), CONVERT(INT, CONVERT(MONEY, @PercentCopayRate) * 100)) + ''%''
              ELSE ''''
           END +
           CASE
              WHEN @FlatCopayAmount IS NOT NULL AND ISNULL(@FirstCopayTerm, ''F'') = ''P'' AND @PercentCopayRate IS NOT NULL THEN '' + $'' + @FlatCopayAmount
              WHEN @FlatCopayAmount IS NOT NULL AND ISNULL(@FirstCopayTerm, ''F'') = ''P'' THEN ''$'' + @FlatCopayAmount
              ELSE ''''
           END +
           CASE
              WHEN @PercentCopayRate IS NOT NULL THEN
                   CASE
                      WHEN @MinimumCopay IS NOT NULL AND @MaximumCopay IS NOT NULL
                         THEN '' (Min:$'' + @MinimumCopay  + '' Max:$'' + @MaximumCopay + '')''
                      WHEN @MinimumCopay IS NOT NULL
                         THEN '' (Min:$'' + @MinimumCopay  + '')''
                      WHEN @MaximumCopay IS NOT NULL
                         THEN '' (Max:$'' + @MaximumCopay  + '')''
                      ELSE ''''
                   END
              ELSE ''''
           END +
           CASE
              WHEN @CopayTier IS NOT NULL AND (@FlatCopayAmount IS NOT NULL OR @PercentCopayRate IS NOT NULL) THEN '', Tier '' + @CopayTier
              WHEN @CopayTier IS NOT NULL THEN ''Tier '' + @CopayTier
              ELSE ''''
           END +
           CASE
              WHEN @MaximumCopayTier IS NOT NULL THEN '', Max Tier '' + @MaximumCopayTier
              ELSE ''''
           END +
           CASE WHEN @DaysSupplyPerCopay IS NOT NULL
              THEN '', '' + @DaysSupplyPerCopay + '' Days Supply''
              ELSE ''''
           END +
           CASE WHEN @OutOfPocketRangeStart IS NOT NULL AND @OutOfPocketRangeEnd IS NOT NULL
              THEN '' With Out Of Pocket Range ($'' + @OutOfPocketRangeStart + '' - $'' + @OutOfPocketRangeEnd + '')''
              ELSE ''''
           END +
           CASE WHEN @OutOfPocketRangeStart IS NOT NULL AND @OutOfPocketRangeEnd IS NULL
              THEN '' With Out Of Pocket Range ($'' + @OutOfPocketRangeStart + '' with no upper range)''
              ELSE ''''
           END
END
' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FromASCII]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[FromASCII](@src [nvarchar](max))
RETURNS [nvarchar](max) WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[FromASCII]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FromBase64]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[FromBase64]
(
	@data [VARCHAR](MAX)
)
RETURNS [VARCHAR](MAX)
AS
BEGIN
	IF @data IS NOT NULL AND LEN(@data) > 0
	BEGIN
		RETURN (SELECT CAST(CAST(N'''' AS XML).value(''xs:base64Binary(sql:variable("@data"))'', ''VARBINARY(MAX)'') AS VARCHAR(MAX)))
	END
	RETURN NULL
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Get_ELGREQ_RestrictToDayPeriod]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[Get_ELGREQ_RestrictToDayPeriod]
(
)
RETURNS [smallint]
AS
BEGIN
	DECLARE @data [smallint],
		@eRxMessageTypeUid [uniqueidentifier] = ''6B18C334-E4A6-4F82-A831-1AAA6CF6009E''	-- ELGREQ

	SELECT @data = [RestrictTo]
	FROM [ListeRxMessageType]
	WHERE [eRxMessageTypeUid] = @eRxMessageTypeUid

	IF @data IS NULL
	BEGIN
		SET @data = 3
	END
	RETURN @data
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GET_InsuranceTotalBalance]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GET_InsuranceTotalBalance]
 (	
	 @superbillUid UNIQUEIDENTIFIER
 )

RETURNS Money AS
BEGIN
		DECLARE	@balance Money
		SELECT  @balance=AssignedLiabilityBalance
		FROM AR_ViewSuperbillAggregate
			WHERE SuperbillUid = @superbillUid			 

	RETURN @balance
END	

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAccountPeriodEligibilityDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[GetAccountPeriodEligibilityDate] (@accountuid uniqueidentifier, @date datetime) 
	RETURNS SMALLINT 
AS
BEGIN

	DECLARE	@accountPeriodUid UNIQUEIDENTIFIER
	DECLARE @eligibilityStatus SMALLINT

	SELECT @accountPeriodUid = dbo.GetAccountPeriod(@accountuid,@date)
	IF (@accountPeriodUid!=NULL)
		SELECT TOP 1 @eligibilityStatus = EligibilityStatus FROM ViewAccountPeriodEligibilityDate
			WHERE AccountPeriodUid = @accountPeriodUid

	RETURN @eligibilityStatus
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAccountResponsiblePartyMostRecentCollectionChargeAmount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE FUNCTION [dbo].[GetAccountResponsiblePartyMostRecentCollectionChargeAmount]
(
	@accountResponsiblePartyUid uniqueidentifier
)
RETURNS 
	money
AS

BEGIN
	DECLARE @mostRecentCollectionChargeAmount money
	SELECT TOP 1 @mostRecentCollectionChargeAmount = LD.Amount 
		FROM SuperbillProcedure SBP WITH (NOLOCK)
		INNER JOIN AR_LedgerDetail LD WITH (NOLOCK) ON SBP.SuperbillProcedureUid = LD.SuperbillProcedureUid
		INNER JOIN AR_Ledger L WITH (NOLOCK) ON LD.LedgerUid = L.LedgerUid
		LEFT JOIN AR_Ledger L_VOID WITH (NOLOCK) ON L.LedgerUid = L_VOID.VoidLedgerUid
		INNER JOIN ARBatch ARB WITH (NOLOCK) ON L.ArBatchUid = ARB.ARBatchUid
		INNER JOIN Superbill SB WITH (NOLOCK) ON SBP.SuperbillUid = SB.SuperbillUid
		INNER JOIN Account AC WITH (NOLOCK) ON SB.AccountUid = AC.AccountUid
	WHERE SBP.procedureuid = (SELECT distinct feedefaultprocedureuid FROM collectionstatusglobal WITH (NOLOCK))
		AND AC.AccountResponsiblePartyUid = @accountResponsiblePartyUid
		AND (L.VoidLedgerUid IS NULL AND L_VOID.LedgerUid IS NULL) -- no voids
		AND LD.IsCredit = 0 -- non reversed charge
	ORDER BY ARB.GLDate DESC

	RETURN isnull(@mostRecentCollectionChargeAmount, 0)
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAccountResponsiblePartyMostRecentPaymentAmount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[GetAccountResponsiblePartyMostRecentPaymentAmount]
(
	@AccountResponsiblePartyUid UNIQUEIDENTIFIER
)
RETURNS 
	MONEY
AS 
BEGIN
	DECLARE @MostRecentPaymentAmount MONEY
	SELECT TOP 1 @MostRecentPaymentAmount = 0 - LD.Amount 
		FROM AR_LedgerDetail LD
			INNER JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid
			LEFT JOIN AR_Ledger voidL ON L.LedgerUid = voidL.VoidLedgerUid
		WHERE L.EntryType = 0 AND LD.IsCredit = 1
			AND voidL.LedgerUid IS NULL AND L.VoidLedgerUid IS NULL
			AND LD.AccountResponsiblePartyUid = @AccountResponsiblePartyUid
		ORDER BY LD.CreatedDateTime DESC -- USE Create Date not Posting Date

	RETURN ISNULL(@MostRecentPaymentAmount, 0)
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAccountResponsiblePartyMostRecentPaymentDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[GetAccountResponsiblePartyMostRecentPaymentDate]
(
	@AccountResponsiblePartyUid UNIQUEIDENTIFIER
)
RETURNS 
	DATETIME
AS
BEGIN
	DECLARE @MostRecentDate DATETIME 
	SELECT TOP 1 @MostRecentDate = LD.CreatedDateTime
		FROM AR_LedgerDetail LD
			INNER JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid
			LEFT JOIN AR_Ledger voidL ON L.LedgerUid = voidL.VoidLedgerUid
		WHERE L.EntryType = 0 AND LD.IsCredit = 1
			AND voidL.LedgerUid IS NULL AND L.VoidLedgerUid IS NULL -- catch both sides of voids and discard
			AND LD.AccountResponsiblePartyUid = @AccountResponsiblePartyUid
		ORDER BY LD.CreatedDateTime DESC -- USE Create Date not Posting Date

	RETURN @MostRecentDate
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAccountResponsiblePartyPaymentTotalAllByDateRange]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[GetAccountResponsiblePartyPaymentTotalAllByDateRange]
(
	@AccountResponsiblePartyUid UNIQUEIDENTIFIER,
	@FromDate DATE,
	@ToDate DATE
)
RETURNS 
	MONEY
AS
BEGIN
	DECLARE @TotalPayments MONEY
	SELECT @TotalPayments = SUM(LD_DebitSide.Amount)
		FROM AR_LedgerDetail LD_DebitSide
			INNER JOIN AR_LedgerDetail LD_CreditSide ON LD_DebitSide.LedgerUid = LD_CreditSide.LedgerUid
			INNER JOIN AR_Ledger L ON LD_DebitSide.LedgerUid = L.LedgerUid
			LEFT JOIN AR_Ledger L_VOID ON L.LedgerUid = L_VOID.VoidLedgerUid
			INNER JOIN SuperbillProcedure SBP ON LD_CreditSide.SuperbillProcedureUid = SBP.SuperbillProcedureUid
			INNER JOIN Superbill SB ON SBP.SuperbillUid = SB.SuperbillUid
			INNER JOIN Account AC ON SB.AccountUid = AC.AccountUid
		WHERE L.EntryType = 2 AND LD_DebitSide.IsCredit = 0 -- Deposit Side of the Distribution
			AND LD_CreditSide.IsCredit = 1
			AND LD_CreditSide.LiabilityOwner = 0 -- bug 17442 and 21991 limit total to payments on patient liabilities only
			AND (L.VoidLedgerUid IS NULL AND L_VOID.LedgerUid IS NULL) -- not voided or voiding
			AND AC.AccountResponsiblePartyUid = @AccountResponsiblePartyUid -- match on the SB side
			AND L.CreatedDateTime BETWEEN @FromDate AND @ToDate  -- USE Create Date not Posting Date

	RETURN isnull(@TotalPayments, 0)
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAddress]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetAddress](@address xml(CONTENT dbo.Address)) RETURNS VARCHAR(255) AS
BEGIN
	IF @address IS NULL
		RETURN NULL
		
	DECLARE @address1 VARCHAR(100)
	DECLARE @address2 VARCHAR(100)
	DECLARE @a VARCHAR(255)
	
	SET @address1 = @address.value(''(/Address/Address1)[1]'', ''VARCHAR(100)'')
	SET @address2 = @address.value(''(/Address/Address2)[1]'', ''VARCHAR(100)'')
	
	IF RTRIM(ISNULL(@address1, '''')) <> ''''
		SET @a = @address1
		
	IF RTRIM(ISNULL(@address2, '''')) <> ''''
	BEGIN
		IF RTRIM(ISNULL(@a, '''')) <> ''''
			SET @a = @a + '' ''
		
		SET @a = @a + @address2
	END
		
	RETURN @a
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetCityStateZip]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetCityStateZip](@address xml(CONTENT dbo.Address)) RETURNS VARCHAR(255) AS
BEGIN
	IF @address IS NULL
		RETURN NULL
		
	DECLARE @city VARCHAR(100)
	DECLARE @state VARCHAR(100)
	DECLARE @zip VARCHAR(100)
	DECLARE @country VARCHAR(100)
	DECLARE @csz VARCHAR(255)
	
	SET @city = @address.value(''(/Address/City)[1]'', ''VARCHAR(100)'')
	SET @state = @address.value(''(/Address/State)[1]'', ''VARCHAR(100)'')
	SET @zip = @address.value(''(/Address/Zip)[1]'', ''VARCHAR(100)'')
	SET @country = @address.value(''(/Address/Country)[1]'', ''VARCHAR(100)'')
	
	IF RTRIM(ISNULL(@city, '''')) <> ''''
		SET @csz = @city
		
	IF RTRIM(ISNULL(@state, '''')) <> ''''
	BEGIN
		IF RTRIM(ISNULL(@csz, '''')) <> ''''
			SET @csz = @csz + '', ''
		
		SET @csz = @csz + @state
	END
	
	IF RTRIM(ISNULL(@zip, '''')) <> ''''
	BEGIN
		IF RTRIM(ISNULL(@csz, '''')) <> ''''
			SET @csz = @csz + ''  ''
		
		SET @csz = @csz + @zip
	END
	
	IF RTRIM(ISNULL(@country, '''')) <> ''''
	BEGIN
		IF RTRIM(ISNULL(@csz, '''')) <> ''''
			SET @csz = @csz + '' ''
			
		SET @csz = @csz + @country
	END
	
	RETURN @csz
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAddressCityStateZip]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetAddressCityStateZip](@address xml(CONTENT dbo.Address)) RETURNS VARCHAR(255) AS
BEGIN
	IF @address IS NULL
		RETURN NULL
		
	DECLARE @a VARCHAR(100)
	DECLARE @address2 VARCHAR(100)
	DECLARE @csz VARCHAR(255)
	DECLARE @acsz VARCHAR(512)	
	
	SET @a = dbo.GetAddress(@address)
	SET @csz = dbo.GetCityStateZip(@address)
	
	IF RTRIM(ISNULL(@a, '''')) <> ''''
		SET @acsz = @a
			
	IF RTRIM(ISNULL(@csz, '''')) <> ''''
	BEGIN
		IF RTRIM(ISNULL(@acsz, '''')) <> ''''
			SET @acsz = @acsz + '' ''
		
		SET @acsz = @acsz + @csz
	END
		
	RETURN @acsz
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAHFSClassificationID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetAHFSClassificationID] (@medid INT, @mnid INT)
RETURNS VARCHAR(6) AS
BEGIN
   DECLARE @classid VARCHAR(6)

   IF (ISNULL(@mnid, 0) > 0)
   BEGIN
      SELECT TOP 1 @classid = cls.classid
      FROM dbo.NDD_SearchDispensable dis
      INNER JOIN dbo.NDD_RAHFSGC1_GCNSEQNO_LINK rel ON rel.IsDelete = 0 AND rel.GCN_SEQNO = dis.gcnseqno
      INNER JOIN dbo.NDD_ViewClassificationAHFS cls ON cls.IsDelete = 0 AND cls.AHFS8 = rel.AHFS8
      WHERE dis.IsDelete = 0
        AND dis.mnid = @mnid
      ORDER BY rel.AHFS_REL
   END
   ELSE
   BEGIN
      SELECT TOP 1 @classid = cls.classid
      FROM dbo.NDD_SearchDispensable dis
      INNER JOIN dbo.NDD_RAHFSGC1_GCNSEQNO_LINK rel ON rel.IsDelete = 0 AND rel.GCN_SEQNO = dis.gcnseqno
      INNER JOIN dbo.NDD_ViewClassificationAHFS cls ON cls.IsDelete = 0 AND cls.AHFS8 = rel.AHFS8
      WHERE dis.IsDelete = 0
        AND dis.medid = @medid
      ORDER BY rel.AHFS_REL
   END
   RETURN @classid
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetBatchNamesByTransaction]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[GetBatchNamesByTransaction](@transactionUid as uniqueidentifier) RETURNS VARCHAR(255) AS
BEGIN
	IF @transactionUid IS NULL
		RETURN NULL
		
	DECLARE @retVal VARCHAR(255)
	select @retVal = stuff( (select distinct '','' + arb.Name
								FROM AR_Ledger arl with (nolock) 
										inner join ARBatch arb with (nolock) on arl.ARBatchUid = arb.ARBatchUid
								where arl.TransactionUid = @transactionUid
								for xml path('''')), 1, 1, '''' )
	return @retVal
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetBatchStateByTransaction]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[GetBatchStateByTransaction](@transactionUid as uniqueidentifier) RETURNS VARCHAR(255) AS
BEGIN
	IF @transactionUid IS NULL
		RETURN NULL
		
	DECLARE @retVal VARCHAR(255)
	SELECT @retVal = stuff( (select DISTINCT '','' +
									CASE WHEN arb.IsClosed = 1 THEN ''Complete''
										 WHEN arb.IsLocked = 1 THEN ''Locked''
										 ELSE						''Open'' END
							 FROM AR_Ledger arl with (nolock)
									INNER JOIN ARBatch arb with (nolock) on arl.ARBatchUid = arb.ARBatchUid
							 WHERE arl.TransactionUid = @transactionUid
							 FOR XML PATH('''')), 1, 1, '''')
	
	return @retVal
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetBatchUidsByTransaction]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[GetBatchUidsByTransaction](@transactionUid as uniqueidentifier) RETURNS VARCHAR(255) AS
BEGIN
	IF @transactionUid IS NULL
		RETURN NULL
		
	DECLARE @retVal VARCHAR(255)
	select @retVal = stuff( (select distinct '','' + convert(varchar(36),arl.arbatchUid)
								FROM AR_Ledger arl with (nolock) 
								where arl.TransactionUid = @transactionUid
								for xml path('''')), 1, 1, '''' )
	return @retVal
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetBestBloodPressure]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetBestBloodPressure](@patientUid UNIQUEIDENTIFIER, @startDate DATE, @endDate DATE)
	RETURNS @PatientBloodPressure TABLE 
	(
		PatientUid UNIQUEIDENTIFIER PRIMARY KEY,
		BloodPressureDate DATE,
		BloodPressure VARCHAR(8),
		Systolic DECIMAL,
		Diastolic DECIMAL
	)
AS
BEGIN
			INSERT			@PatientBloodPressure
			SELECT TOP 1	@patientUid, CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) AS BloodPressureDate,
							CAST(CAST(ov.MetricValue1 AS INT) AS VARCHAR(3)) + ''/'' + CAST(CAST(ov.MetricValue2 AS INT) AS VARCHAR(3)), 
							ov.MetricValue1 AS Systolic, ov.MetricValue2 AS Diastolic
			FROM			ObservationOrder oo INNER JOIN ObservationValue ov ON oo.ObservationOrderUid = ov.ObservationOrderUid
			WHERE			ov.ObservationItemUid = ''00000000-0000-0000-7777-100000000073'' AND
							oo.PatientUid = @patientUid AND
							(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) >= @startDate OR @startDate IS NULL) AND
							(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE)<= @endDate OR @endDate IS NULL) 
			ORDER BY		CASE WHEN ov.MetricValue1 >= 90 OR ov.MetricValue2 >= 140 THEN 2000 + ov.MetricValue1 + ov.MetricValue2 ELSE ov.MetricValue1 + ov.MetricValue2 END, -- Make sure over 90 or 140 is higher than any that isn''t
							COALESCE(oo.ResultDate, oo.PerformDate) DESC
	RETURN 
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getCreditCardName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[getCreditCardName]
(@displayOrder INT)  
RETURNS Varchar(100) AS  
BEGIN 
	Declare @name varchar(100)
	Declare @cntCrCard int
	Set @name=''''
	Select @cntCrCard=count(*) From listpaymenttype Where InternalCardType IS NOT NULL
	IF (@cntCrCard >=@displayOrder)
	BEGIN
--	Select @name = Name from ListCreditCard Where DisplayOrder = @displayOrder
		IF @displayOrder=1
			Select top  1  @name=''''+ name  From listpaymenttype Where InternalCardType IS NOT NULL Order by Name
		IF @displayOrder=2
			Select top  2  @name=''''+ name  From listpaymenttype Where InternalCardType IS NOT NULL Order by Name
		IF @displayOrder=3
			Select top  3  @name=''''+ name  From listpaymenttype Where InternalCardType IS NOT NULL Order by Name
		IF @displayOrder=4
			Select top  4  @name=''''+ name  From listpaymenttype Where InternalCardType IS NOT NULL Order by Name
		IF @displayOrder=5
			Select top  5  @name=''''+ name  From listpaymenttype Where InternalCardType IS NOT NULL Order by Name
		IF @displayOrder=6
			Select top  6  @name=''''+ name  From listpaymenttype Where InternalCardType IS NOT NULL Order by Name
	END

	Return @name
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetCurrentPatientHistoryQuestionAnswerName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetCurrentPatientHistoryQuestionAnswerName](@patientUid UNIQUEIDENTIFIER, @questionUid UNIQUEIDENTIFIER, @date DATE) RETURNS VARCHAR(255) AS
BEGIN
	DECLARE @answerName VARCHAR(255)
	
	SELECT TOP 1	@answerName = vph.AnswerName
	FROM			ViewPatientHistory vph
	WHERE			vph.QuestionUid = @questionUid AND
					(vph.ActiveDate <= @date OR @date IS NULL) AND
					vph.PatientUid = @patientUid					
	ORDER BY		vph.ActiveDate DESC

	RETURN @answerName
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetCustomerNumber]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetCustomerNumber] () RETURNS VARCHAR(10) AS
BEGIN
	-- Declare the return variable here
	DECLARE @xml XML
	DECLARE @customerNumber VARCHAR(10)

	SELECT @xml = XmlValue FROM ListProductParameter WHERE ParameterName = ''RegistrationCustomerLicense''
	IF @xml IS NULL
		RETURN NULL
	
	SELECT @customerNumber = @xml.value(''(/License/Customer/@number)[1]'', ''VARCHAR(10)'')

	RETURN @customerNumber
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetDepositNamesByTransaction]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetDepositNamesByTransaction](@transactionUid as uniqueidentifier) RETURNS VARCHAR(255) AS
BEGIN
	IF @transactionUid IS NULL
		RETURN NULL
		
	DECLARE @retVal VARCHAR(255)
	SELECT @retVal = stuff(( select DISTINCT '','' + d.ReferenceNumber
							FROM AR_Ledger arl with (nolock) 
									INNER JOIN AR_LedgerDetail ld with (nolock) on arl.TransactionUid = @transactionUid 
																					AND arl.LedgerUid = ld.LedgerUid
									INNER JOIN Deposit d with (nolock) on ld.DepositUid = d.DepositUid
							FOR XML PATH('''')), 1, 1, '''')
	return @retVal
END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetDiagnosis]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE FUNCTION [dbo].[GetDiagnosis] (@visitProcedureUid uniqueidentifier) RETURNS VARCHAR(100) AS
	BEGIN
		DECLARE @diagnosis varchar(100)
		DECLARE @diagCode varchar(25)
		
		DECLARE cur CURSOR FOR 
			SELECT		vd.Code
			FROM		VisitProcedureDiagnosis vspd INNER JOIN VisitDiagnosis vd ON vspd.VisitDiagnosisUid = vd.VisitDiagnosisUid
			WHERE		vspd.VisitProcedureUid = @visitProcedureUid
			ORDER BY	vspd.DisplayOrder
			
		OPEN cur

		FETCH NEXT FROM cur INTO @diagCode
		WHILE @@FETCH_STATUS = 0
		BEGIN
			IF NOT @diagnosis IS NULL
				SET @diagnosis = @diagnosis + '',''
			ELSE
				SET @diagnosis = ''''
				
				SET @diagnosis = @diagnosis + @diagCode

			FETCH NEXT FROM cur INTO @diagCode
		END
		
		CLOSE cur
		DEALLOCATE cur
			
	
	RETURN @diagnosis
	
	END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetDiagnosisByMedication]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[GetDiagnosisByMedication] (@MedicationSigUid uniqueidentifier) RETURNS VARCHAR(max) AS
	BEGIN
		DECLARE @diagnosis varchar(max)
		DECLARE @diagCode varchar(max)
		--set @MedicationSigUid = ''BDD5454D-EA16-459F-99CD-2A640E939710''
		DECLARE cur CURSOR FOR 
			SELECT		coalesce(rdm.Code10,rdm.Code9) + '' '' + ISNULL(rdm.CodeDescription,'''')
			FROM		RelMedicationDiagnosis rdm --INNER JOIN VisitDiagnosis vd ON rvm.VisitDiagnosisUid = vd.VisitDiagnosisUid
			WHERE		rdm.MedicationSIGUid = @MedicationSigUid
			ORDER BY	rdm.DisplayOrder
			
		OPEN cur

		FETCH NEXT FROM cur INTO @diagCode
		WHILE @@FETCH_STATUS = 0
		BEGIN
			IF NOT @diagnosis IS NULL
				SET @diagnosis = @diagnosis + '', ''
			ELSE
				SET @diagnosis = ''''
				
				SET @diagnosis = @diagnosis + @diagCode

			FETCH NEXT FROM cur INTO @diagCode
		END
		
		CLOSE cur
		DEALLOCATE cur
		--print @diagnosis	
	
	RETURN @diagnosis
	
	END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetDiagnosisCodeAndName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetDiagnosisCodeAndName]
(
	@code9 VARCHAR(25),
	@code10 VARCHAR(25),
	@codeDescription VARCHAR(255)
)
RETURNS VARCHAR(512)
AS
BEGIN
	DECLARE @code VARCHAR(51)


	IF @code9 IS NOT NULL OR RTRIM(@code9) <> ''''
		SET @code = @code9
	IF @code10 IS NOT NULL OR RTRIM(@code10) <> ''''
		SET @code = @code10 + ''-'' + @code9

	RETURN ''('' + @code + '') '' + @codeDescription
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetDiagnosisCodeList]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[GetDiagnosisCodeList](@superbillProcedureUid uniqueidentifier) 
RETURNS VARCHAR(MAX) AS
BEGIN
	DECLARE @diagnosisCodeList VARCHAR(MAX);

	WITH cteSuperbillProcedureDiagnosis AS
	(
		SELECT SBP.SuperbillProcedureUid, SD.SuperbillDiagnosisUid,
			  SD.DisplayOrder, CAST(0 AS BIT) AS [Inactive],
			  SBP.LastModifiedByUid,
			  GETUTCDATE() AS [LastModifiedDate]
			FROM SuperbillProcedure SBP
				INNER JOIN SuperbillDiagnosis SD ON SBP.SuperbillUid = SD.SuperbillUid 
					AND SBP.DiagnosisPointer1 = SD.DisplayOrder
		UNION
		SELECT SBP.SuperbillProcedureUid, SD.SuperbillDiagnosisUid,
			  SD.DisplayOrder, CAST(0 AS BIT) AS [Inactive],
			  SBP.LastModifiedByUid,
			  GETUTCDATE() AS [LastModifiedDate]
			FROM SuperbillProcedure SBP
				INNER JOIN SuperbillDiagnosis SD ON SBP.SuperbillUid = SD.SuperbillUid 
					AND SBP.DiagnosisPointer2 = SD.DisplayOrder
		UNION
		SELECT SBP.SuperbillProcedureUid, SD.SuperbillDiagnosisUid,
			  SD.DisplayOrder, CAST(0 AS BIT) AS [Inactive],
			  SBP.LastModifiedByUid,
			  GETUTCDATE() AS [LastModifiedDate]
			FROM SuperbillProcedure SBP
				INNER JOIN SuperbillDiagnosis SD ON SBP.SuperbillUid = SD.SuperbillUid 
					AND SBP.DiagnosisPointer3 = SD.DisplayOrder
		UNION
		SELECT SBP.SuperbillProcedureUid, SD.SuperbillDiagnosisUid,
			  SD.DisplayOrder, CAST(0 AS BIT) AS [Inactive],
			  SBP.LastModifiedByUid,
			  GETUTCDATE() AS [LastModifiedDate]
			FROM SuperbillProcedure SBP
				INNER JOIN SuperbillDiagnosis SD ON SBP.SuperbillUid = SD.SuperbillUid 
					AND SBP.DiagnosisPointer4 = SD.DisplayOrder
		UNION
		SELECT SBP.SuperbillProcedureUid, SD.SuperbillDiagnosisUid,
			  SD.DisplayOrder, CAST(0 AS BIT) AS [Inactive],
			  SBP.LastModifiedByUid,
			  GETUTCDATE() AS [LastModifiedDate]
			FROM SuperbillProcedure SBP
				INNER JOIN SuperbillDiagnosis SD ON SBP.SuperbillUid = SD.SuperbillUid 
					AND SBP.DiagnosisPointer5 = SD.DisplayOrder
		UNION
		SELECT SBP.SuperbillProcedureUid, SD.SuperbillDiagnosisUid,
			  SD.DisplayOrder, CAST(0 AS BIT) AS [Inactive],
			  SBP.LastModifiedByUid,
			  GETUTCDATE() AS [LastModifiedDate]
			FROM SuperbillProcedure SBP
				INNER JOIN SuperbillDiagnosis SD ON SBP.SuperbillUid = SD.SuperbillUid 
					AND SBP.DiagnosisPointer6 = SD.DisplayOrder
		UNION
		SELECT SBP.SuperbillProcedureUid, SD.SuperbillDiagnosisUid,
			  SD.DisplayOrder, CAST(0 AS BIT) AS [Inactive],
			  SBP.LastModifiedByUid,
			  GETUTCDATE() AS [LastModifiedDate]
			FROM SuperbillProcedure SBP
				INNER JOIN SuperbillDiagnosis SD ON SBP.SuperbillUid = SD.SuperbillUid 
					AND SBP.DiagnosisPointer7 = SD.DisplayOrder
		UNION
		SELECT SBP.SuperbillProcedureUid, SD.SuperbillDiagnosisUid,
			  SD.DisplayOrder, CAST(0 AS BIT) AS [Inactive],
			  SBP.LastModifiedByUid,
			  GETUTCDATE() AS [LastModifiedDate]
			FROM SuperbillProcedure SBP
				INNER JOIN SuperbillDiagnosis SD ON SBP.SuperbillUid = SD.SuperbillUid 
					AND SBP.DiagnosisPointer8 = SD.DisplayOrder
	), cteSuperbillProcedureInfo AS
	(
	SELECT TOP 10000 VSPD.SuperbillProcedureUid, VSPD.DisplayOrder, -- TOP required for order by
				CASE WHEN LEN(ISNULL(SD.Code10,''''))>0 THEN SD.Code10 ELSE SD.Code9 END AS Code
				FROM cteSuperbillProcedureDiagnosis VSPD
					INNER JOIN SuperbillDiagnosis SD ON VSPD.SuperbillDiagnosisUid = SD.SuperbillDiagnosisUid
					WHERE VSPD.SuperbillProcedureUid = @superbillProcedureUid
					ORDER BY VSPD.SuperbillProcedureUid, VSPD.DisplayOrder
	)
	SELECT	@diagnosisCodeList = COALESCE(@diagnosisCodeList+'','' ,'''') + Code
	FROM	cteSuperbillProcedureInfo;
	
	RETURN @diagnosisCodeList;
END


' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetDisplayOrder]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetDisplayOrder](@displayOrder [int], @kdbItemNode [nvarchar](255), @clinicCenterUid [uniqueidentifier], @providerUid [uniqueidentifier], @kdbClinicCenter [xml], @kdbProvider [xml])
RETURNS [int] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[GetDisplayOrder]' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SplitCLR]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[SplitCLR](@parameters [nvarchar](max), @delimiter [nchar](1))
RETURNS  TABLE (
	[Parameter] [nvarchar](4000) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
) WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[SplitCLR]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetDocumentBatchMeasure]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetDocumentBatchMeasure](@reportParametersXml XML) RETURNS VARCHAR(1000) AS
BEGIN
	DECLARE @measureUids VARCHAR(MAX) = @reportParametersXml.value(''(/parameters/MeasureUid)[1]'', ''VARCHAR(MAX)'')
	DECLARE @measures VARCHAR(1000) = ''''
	DECLARE @cqmUid UNIQUEIDENTIFIER
	DECLARE @externalID VARCHAR(25)
	DECLARE @cms VARCHAR(255)

	DECLARE cur CURSOR READ_ONLY FOR
		SELECT	c.CQMUid, c.ExternalID, c.CMS
		FROM	dbo.SplitCLR(@measureUids, '','') s INNER JOIN ListCQM c ON CAST(s.Parameter AS UNIQUEIDENTIFIER) = c.CQMUid
	OPEN cur

	FETCH NEXT FROM cur INTO @cqmUid, @externalID, @cms
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @measures = @measures + '' '' + @cms

		FETCH NEXT FROM cur INTO @cqmUid, @externalID, @cms
	END
	CLOSE cur
	DEALLOCATE cur

	RETURN RTRIM(@measures)
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SplitList]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[SplitList] (@list VARCHAR(MAX), @separator VARCHAR(MAX) = '','')  
RETURNS @table TABLE   
(  
	Value VARCHAR(MAX))AS   
	BEGIN     
		DECLARE @position INT,   
		@previous INT     
		SET @list = @list + @separator     
		SET @previous = 1     
		SET @position = CHARINDEX(@separator, @list)     
		WHILE @position > 0   
			BEGIN        
			IF @position - @previous > 0           
				INSERT INTO @table VALUES (SUBSTRING(@list, @previous, @position - @previous))        
				IF @position >= LEN(@list)   
					BREAK        
			SET @previous = @position + 1        
			SET @position = CHARINDEX(@separator, @list, @previous)     
		END     
	RETURN  
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetFaxDocumentNames]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetFaxDocumentNames] (@list VARCHAR(MAX), @separator VARCHAR(MAX) = '','')  RETURNS VARCHAR(MAX)
AS
BEGIN

	--Bug #17783	Track Fax. Sent documents are listed by attachment group name not the individual document name
/*	DECLARE @Names VARCHAR(max) 
	(select @Names = COALESCE(COALESCE(@Names + '';'', '''') + ag.Name, @Names)  from AttachmentGroup ag
			LEFT JOIN Attachment a ON a.AttachmentUid in (select Value FROM dbo.SplitList(@list, @separator))
			where a.AttachmentGroupUid = ag.AttachmentGroupUid) 
*/			
	DECLARE @Names VARCHAR(max) 
	(select @Names = COALESCE(COALESCE(@Names + '';'', '''') + a.filename+a.FileExtension, @Names)  from AttachmentGroup ag
			LEFT JOIN Attachment a ON a.AttachmentUid in (select Value FROM dbo.SplitList(@list, @separator))
			where a.AttachmentGroupUid = ag.AttachmentGroupUid) 
return @Names   

END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[StripNonNumeric]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[StripNonNumeric]
	(
		@s VARCHAR(100)
	)
RETURNS VARCHAR(100)
AS
BEGIN
    -- cmr usage:  SELECT dbo.StripNonNumeric(''(12-34%)xaaa'')
	DECLARE @i INT

	SET @i = PATINDEX(''%[^0-9]%'', @s)
	while @i > 0
	begin
		SET @s = replace(@s, substring(@s, @i, 1), '''')
		SET @i = patindex(''%[^0-9]%'', @s)
	end

	RETURN @s
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetPhoneFormatted]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetPhoneFormatted](@phone xml(CONTENT dbo.Phone)) RETURNS VARCHAR(255) AS
BEGIN
	IF @phone IS NULL
		RETURN NULL
		
	DECLARE @phonenumber VARCHAR(100)
	DECLARE @pt VARCHAR(255)
	
	SET @phonenumber = @phone.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(100)'')

	IF RTRIM(ISNULL(@phonenumber, '''')) = ''''
		RETURN NULL
					
	SET @phonenumber = dbo.StripNonNumeric(@phonenumber)
	IF DATALENGTH(@phonenumber) = 7
		SET @pt = SUBSTRING(@phonenumber, 1, 3) + ''-'' + SUBSTRING(@phonenumber, 4, 4)
	ELSE
	BEGIN
		SET @pt = ''('' + SUBSTRING(@phonenumber, 1, 3) + '') '' + SUBSTRING(@phonenumber, 4, 3) + ''-'' + SUBSTRING(@phonenumber, 7, 4)
	
		IF DATALENGTH(@phonenumber) > 10
			SET @pt = @pt + '' x'' + SUBSTRING(@phonenumber, 11, DATALENGTH(@phonenumber) - 11)
	END
	
	RETURN @pt
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetFaxPhone]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[GetFaxPhone](@phone1 xml(CONTENT dbo.Phone) = NULL, @phone2 xml(CONTENT dbo.Phone) = NULL, @phone3 xml(CONTENT dbo.Phone) = NULL, @phone4 xml(CONTENT dbo.Phone) = NULL) RETURNS VARCHAR(100) AS	
BEGIN
	DECLARE @Phonenumber VARCHAR(50)
	
	IF @phone1.value(''(/Phone/PhoneTypeUid)[1]'', ''VARCHAR(100)'') = ''48AF7137-1791-48E4-B338-3DD0A7419073''
		RETURN dbo.GetPhoneFormatted(@phone1)
	
	IF @phone2.value(''(/Phone/PhoneTypeUid)[1]'', ''VARCHAR(100)'') = ''48AF7137-1791-48E4-B338-3DD0A7419073''
		RETURN dbo.GetPhoneFormatted(@phone2)

	IF @phone3.value(''(/Phone/PhoneTypeUid)[1]'', ''VARCHAR(100)'') = ''48AF7137-1791-48E4-B338-3DD0A7419073''
		RETURN dbo.GetPhoneFormatted(@phone3)

	IF @phone4.value(''(/Phone/PhoneTypeUid)[1]'', ''VARCHAR(100)'') = ''48AF7137-1791-48E4-B338-3DD0A7419073''
		RETURN dbo.GetPhoneFormatted(@phone4)

	RETURN NULL
END




' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetFilterOverride]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetFilterOverride](@value [xml], @name [nvarchar](255), @uid [uniqueidentifier])
RETURNS [xml] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[GetFilterOverride]' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetFormattedPRMVersion]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetFormattedPRMVersion](@version [nvarchar](max))
RETURNS [nvarchar](max) WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[GetFormattedPRMVersion]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getFormatVaribleValue]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[getFormatVaribleValue]
(	
	@exportFormatGUID UNIQUEIDENTIFIER,
	@iProvider VARCHAR(50) = NULL
)RETURNS VARCHAR(255)
AS
BEGIN
	DECLARE @retVal VARCHAR(255)
	SELECT	@retVal = ISNULL(eClaimFormatValue.value, '''')	
	FROM ListClaimFormatValueType eListClaimFormatValueType
	LEFT JOIN ClaimFormatValue eClaimFormatValue ON	eClaimFormatValue.ClaimFormatValueTypeUid = eListClaimFormatValueType.ClaimFormatValueTypeUid AND
	(eClaimFormatValue.ProviderUid IS NOT NULL AND CONVERT(VARCHAR(50),eClaimFormatValue.ProviderUid) = @iProvider )
	WHERE	eListClaimFormatValueType.ClaimFormatValueTypeUid = @exportFormatGUID 
RETURN(@retVal)
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetFraminghamScore]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetFraminghamScore](@Age int,@Gender Varchar(2),@TC FLOAT,@Smoker VARCHAR(25),@HDL FLOAT,@BP FLOAT,@Treatment BIT) RETURNS int AS	
BEGIN

	DECLARE @FraminghamRisk INT
	
	Declare @AgeATP Table
	(
		minAge int,
		MaxAge int,
		Points int,
		Gender Varchar(2)
	)

	Insert into @AgeATP Values(20,34,-9,''M'')
	Insert into @AgeATP Values(35,39,-4,''M'')
	Insert into @AgeATP Values(40,44,0,''M'')
	Insert into @AgeATP Values(45,49,3,''M'')
	Insert into @AgeATP Values(50,54,6,''M'')
	Insert into @AgeATP Values(55,59,8,''M'')
	Insert into @AgeATP Values(60,64,10,''M'')
	Insert into @AgeATP Values(65,69,11,''M'')
	Insert into @AgeATP Values(70,74,12,''M'')
	Insert into @AgeATP Values(75,79,13,''M'')
	Insert into @AgeATP Values(20,34,-7,''F'')
	Insert into @AgeATP Values(35,39,-3,''F'')
	Insert into @AgeATP Values(40,44,0,''F'')
	Insert into @AgeATP Values(45,49,3,''F'')
	Insert into @AgeATP Values(50,54,6,''F'')
	Insert into @AgeATP Values(55,59,8,''F'')
	Insert into @AgeATP Values(60,64,10,''F'')
	Insert into @AgeATP Values(65,69,12,''F'')
	Insert into @AgeATP Values(70,74,14,''F'')
	Insert into @AgeATP Values(75,79,16,''F'')

	Declare @TotCholATP Table
	(
		MinChol int,
		MaxChol int,
		MinAge int,
		MaxAge int,
		Points int,
		Gender Varchar(2)
	)

	insert into @TotCholATP Values (0,159,20,39,0,''M'')
	insert into @TotCholATP Values (0,159,40,49,0,''M'')
	insert into @TotCholATP Values (0,159,50,59,0,''M'')
	insert into @TotCholATP Values (0,159,60,69,0,''M'')
	insert into @TotCholATP Values (0,159,70,79,0,''M'')
	insert into @TotCholATP Values (0,159,20,39,0,''F'')
	insert into @TotCholATP Values (0,159,40,49,0,''F'')
	insert into @TotCholATP Values (0,159,50,59,0,''F'')
	insert into @TotCholATP Values (0,159,60,69,0,''F'')
	insert into @TotCholATP Values (0,159,70,79,0,''F'')
	insert into @TotCholATP Values (160,199,20,39,4,''M'')
	insert into @TotCholATP Values (160,199,40,49,3,''M'')
	insert into @TotCholATP Values (160,199,50,59,2,''M'')
	insert into @TotCholATP Values (160,199,60,69,1,''M'')
	insert into @TotCholATP Values (160,199,70,79,0,''M'')
	insert into @TotCholATP Values (160,199,20,39,4,''F'')
	insert into @TotCholATP Values (160,199,40,49,3,''F'')
	insert into @TotCholATP Values (160,199,50,59,2,''F'')
	insert into @TotCholATP Values (160,199,60,69,1,''F'')
	insert into @TotCholATP Values (160,199,70,79,1,''F'')
	insert into @TotCholATP Values (200,239,20,39,7,''M'')
	insert into @TotCholATP Values (200,239,40,49,5,''M'')
	insert into @TotCholATP Values (200,239,50,59,3,''M'')
	insert into @TotCholATP Values (200,239,60,69,1,''M'')
	insert into @TotCholATP Values (200,239,70,79,0,''M'')
	insert into @TotCholATP Values (200,239,20,39,8,''F'')
	insert into @TotCholATP Values (200,239,40,49,6,''F'')
	insert into @TotCholATP Values (200,239,50,59,4,''F'')
	insert into @TotCholATP Values (200,239,60,69,2,''F'')
	insert into @TotCholATP Values (200,239,70,79,1,''F'')
	insert into @TotCholATP Values (240,279,20,39,9,''M'')
	insert into @TotCholATP Values (240,279,40,49,6,''M'')
	insert into @TotCholATP Values (240,279,50,59,4,''M'')
	insert into @TotCholATP Values (240,279,60,69,2,''M'')
	insert into @TotCholATP Values (240,279,70,79,1,''M'')
	insert into @TotCholATP Values (240,279,20,39,11,''F'')
	insert into @TotCholATP Values (240,279,40,49,8,''F'')
	insert into @TotCholATP Values (240,279,50,59,5,''F'')
	insert into @TotCholATP Values (240,279,60,69,3,''F'')
	insert into @TotCholATP Values (240,279,70,79,2,''F'')
	insert into @TotCholATP Values (280,9999,20,39,11,''M'')
	insert into @TotCholATP Values (280,9999,40,49,8,''M'')
	insert into @TotCholATP Values (280,9999,50,59,5,''M'')
	insert into @TotCholATP Values (280,9999,60,69,3,''M'')
	insert into @TotCholATP Values (280,9999,70,79,1,''M'')
	insert into @TotCholATP Values (280,9999,20,39,13,''F'')
	insert into @TotCholATP Values (280,9999,40,49,10,''F'')
	insert into @TotCholATP Values (280,9999,50,59,7,''F'')
	insert into @TotCholATP Values (280,9999,60,69,4,''F'')
	insert into @TotCholATP Values (280,9999,70,79,2,''F'')

	Declare @SmokerATP Table
	(
		Smoker Varchar(25),
		MinAge int,
		MaxAge int,
		Points int,
		Gender Varchar(2)
	)

	insert into @SmokerATP Values (''NonSmoker'',20,39,0,''M'')
	insert into @SmokerATP Values (''NonSmoker'',40,49,0,''M'')
	insert into @SmokerATP Values (''NonSmoker'',50,59,0,''M'')
	insert into @SmokerATP Values (''NonSmoker'',60,69,0,''M'')
	insert into @SmokerATP Values (''NonSmoker'',70,79,0,''M'')
	insert into @SmokerATP Values (''NonSmoker'',20,39,0,''F'')
	insert into @SmokerATP Values (''NonSmoker'',40,49,0,''F'')
	insert into @SmokerATP Values (''NonSmoker'',50,59,0,''F'')
	insert into @SmokerATP Values (''NonSmoker'',60,69,0,''F'')
	insert into @SmokerATP Values (''NonSmoker'',70,79,0,''F'')
	insert into @SmokerATP Values (''Smoker'',20,39,8,''M'')
	insert into @SmokerATP Values (''Smoker'',40,49,5,''M'')
	insert into @SmokerATP Values (''Smoker'',50,59,3,''M'')
	insert into @SmokerATP Values (''Smoker'',60,69,1,''M'')
	insert into @SmokerATP Values (''Smoker'',70,79,1,''M'')
	insert into @SmokerATP Values (''Smoker'',20,39,9,''F'')
	insert into @SmokerATP Values (''Smoker'',40,49,7,''F'')
	insert into @SmokerATP Values (''Smoker'',50,59,4,''F'')
	insert into @SmokerATP Values (''Smoker'',60,69,2,''F'')
	insert into @SmokerATP Values (''Smoker'',70,79,1,''F'')

	Declare @HDLATP Table
	(

		MinHDL int,
		MaxHDL int,
		Points int,
		Gender Varchar(2)
		
	)

	insert into @HDLATP Values (0,39,2,''M'')
	insert into @HDLATP Values (40,49,1,''M'')
	insert into @HDLATP Values (50,59,0,''M'')
	insert into @HDLATP Values (60,999,-1,''M'')
	insert into @HDLATP Values (0,39,2,''F'')
	insert into @HDLATP Values (40,49,1,''F'')
	insert into @HDLATP Values (50,59,0,''F'')
	insert into @HDLATP Values (60,999,-1,''F'')


	Declare @BpATP Table
	(
		MinBp int,
		MaxBp int,
		Points int,
		Gender Varchar(2),
		Treatment bit
	)

	insert into @BpATP Values (0,119,0,''M'',0)
	insert into @BpATP Values (120,129,0,''M'',0)
	insert into @BpATP Values (130,139,1,''M'',0)
	insert into @BpATP Values (140,159,1,''M'',0)
	insert into @BpATP Values (160,999,2,''M'',0)
	insert into @BpATP Values (0,129,0,''F'',0)	
	insert into @BpATP Values (120,129,1,''F'',0)
	insert into @BpATP Values (130,139,2,''F'',0)
	insert into @BpATP Values (140,159,3,''F'',0)
	insert into @BpATP Values (160,999,4,''F'',0)
	insert into @BpATP Values (0,119,0,''M'',1)
	insert into @BpATP Values (120,129,1,''M'',1)
	insert into @BpATP Values (130,139,2,''M'',1)
	insert into @BpATP Values (140,159,2,''M'',1)
	insert into @BpATP Values (160,999,3,''M'',1)
	insert into @BpATP Values (0,129,0,''F'',1)	
	insert into @BpATP Values (120,129,3,''F'',1)
	insert into @BpATP Values (130,139,4,''F'',1)
	insert into @BpATP Values (140,159,5,''F'',1)
	insert into @BpATP Values (160,999,6,''F'',1)


	Declare @ATP Table
	(
		Points int,
		Risk int,
		Gender Varchar(2)
	)

	insert into @ATP Values (0,1,''M'')
	insert into @ATP Values (1,1,''M'')
	insert into @ATP Values (2,1,''M'')
	insert into @ATP Values (3,1,''M'')
	insert into @ATP Values (4,1,''M'')
	insert into @ATP Values (5,2,''M'')
	insert into @ATP Values (6,2,''M'')
	insert into @ATP Values (7,3,''M'')
	insert into @ATP Values (8,4,''M'')
	insert into @ATP Values (9,5,''M'')
	insert into @ATP Values (10,6,''M'')
	insert into @ATP Values (11,8,''M'')
	insert into @ATP Values (12,10,''M'')
	insert into @ATP Values (13,12,''M'')
	insert into @ATP Values (14,16,''M'')
	insert into @ATP Values (15,20,''M'')
	insert into @ATP Values (16,25,''M'')
	insert into @ATP Values (9,1,''F'')
	insert into @ATP Values (10,1,''F'')
	insert into @ATP Values (11,1,''F'')
	insert into @ATP Values (12,1,''F'')
	insert into @ATP Values (13,2,''F'')
	insert into @ATP Values (14,2,''F'')
	insert into @ATP Values (15,3,''F'')
	insert into @ATP Values (16,4,''F'')
	insert into @ATP Values (17,5,''F'')
	insert into @ATP Values (18,6,''F'')
	insert into @ATP Values (19,8,''F'')
	insert into @ATP Values (20,11,''F'')
	insert into @ATP Values (21,14,''F'')
	insert into @ATP Values (22,17,''F'')
	insert into @ATP Values (23,22,''F'')
	insert into @ATP Values (24,27,''F'')
	insert into @ATP Values (25,30,''F'')

--	Select * from @AgeATP
--	Select * from @TotCholATP
--	Select * from @SmokerATP
--	Select * from @HDLATP
--	Select * from @BpATP
--	Select * from @ATP
	--@Age int,@Gender Varchar(2),@TC FLOAT,@Smoker bit,@HDL FLOAT,@BP FLOAT
	Declare @ATPscore INT
	SET @ATPscore=0
	SELECT  @ATPscore=@ATPscore + Points FROM @AgeATP	  WHERE Gender=@Gender AND (minAge<=@Age AND MaxAge>=@Age)
	SELECT  @ATPscore=@ATPscore + Points FROM @TotCholATP WHERE Gender=@Gender AND (minAge<=@Age AND MaxAge>=@Age) AND (MinChol<=@TC AND MaxChol>=@TC)
	SELECT  @ATPscore=@ATPscore + Points FROM @SmokerATP  WHERE Gender=@Gender AND (minAge<=@Age AND MaxAge>=@Age) AND Smoker=@Smoker
	SELECT  @ATPscore=@ATPscore + Points FROM @HDLATP  WHERE Gender=@Gender AND (MinHDL<=@HDL AND MaxHDL>=@HDL) 
	SELECT  @ATPscore=@ATPscore + Points FROM @BpATP  WHERE Gender=@Gender AND (MinBP<=@BP AND MaxBp>=@BP) AND Treatment=@Treatment 
	
	---- Declare @ATP Table
	----(
	----	Points int,
	----	Risk int,
	----	Gender Varchar(2)
	--)
	
	IF (@Gender=''M'' and @ATPscore>16)
	BEGIN
		SET @FraminghamRisk=30
	END
	ELSE
	BEGIN
		SELECT @FraminghamRisk=Risk FROM @ATP WHERE Gender=''M'' AND Points=@ATPscore
	END
	
	IF (@Gender=''F'' and @ATPscore>24)
	BEGIN
		SET @FraminghamRisk=30
	END
	ELSE
	BEGIN
		SELECT @FraminghamRisk=Risk FROM @ATP WHERE Gender=''F'' AND Points=@ATPscore
	END
		
	RETURN @FraminghamRisk	

END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetGroupList_SR]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE Function [dbo].[GetGroupList_SR](@UID uniqueidentifier)
Returns Varchar(2000)
AS
Begin

Declare @Group Varchar(2000)
       Set @Group=null

;With CTE_UserGroupMember AS (
SELECT DISTINCT 
ugm.UserGroupUId,ugm.MemberUserUID,ugm.MemberUserGroupUid
FROM UserGroupMember ugm
WHERE  (ugm.MemberUserUID = @UID  OR ugm.MemberUserGroupUid=@UID)
)

SELECT 
@Group= COALESCE(@Group + '', '','''') + L.Name

       FROM   ListUserGroup L
       join
                     CTE_UserGroupMember ugm 
       on
                     L.UserGroupuid=ugm.UserGroupUId 
       CROSS JOIN 
                     ViewFindUserAndUserGroup fuug
       WHERE  (ugm.MemberUserUID = @UID  OR ugm.MemberUserGroupUid=@UID)AND
                     ((ugm.MemberUserUid = fuug.Uid AND fuug.ForeignKeyIndex = 1) OR
                     (ugm.MemberUserGroupUid = fuug.Uid AND fuug.ForeignKeyIndex = 2))
       Order by L.Name  

	Return @Group
End

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetHCCCategoryGrouping]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetHCCCategoryGrouping](@hccCategory smallint) RETURNS VARCHAR(255) AS
BEGIN
	IF @hccCategory = 1
		RETURN ''HIV/AIDS''
	IF @hccCategory = 2
		RETURN ''SEPSIS''
	IF @hccCategory = 6
		RETURN ''Opportunistic Infections''
	IF @hccCategory = 8 OR @hccCategory = 9 OR @hccCategory = 10 OR @hccCategory = 11 OR @hccCategory = 12
		RETURN ''Cancer''
	IF @hccCategory = 17 OR @hccCategory = 18 OR @hccCategory = 19
		RETURN ''Diabetes''
	IF @hccCategory = 21
		RETURN ''Protein-Calorie Malnutrition''
	IF @hccCategory = 22
		RETURN ''Morbid Obesity''
	IF @hccCategory = 23
		RETURN ''Other Significant Endocrine and Metabolic Disorders''
	IF @hccCategory = 27 OR @hccCategory = 28 OR @hccCategory = 29
		RETURN ''End-Stage Liver Disease''
	IF @hccCategory = 33
		RETURN ''Intestinal Obstruction/Perforation''
	IF @hccCategory = 34
		RETURN ''Chronic Pancreatitis''
	IF @hccCategory = 35
		RETURN ''Inflammatory Bowel Disease''
	IF @hccCategory = 39
		RETURN ''Bone/Joint/Muscle Infections/Necrosis''
	IF @hccCategory = 40
		RETURN ''Rheumatoid Arthritis and Inflammatory Connective Tissue Disease''
	IF @hccCategory = 46 OR @hccCategory = 48
		RETURN ''Severe Hematological Disorders''
	IF @hccCategory = 47
		RETURN ''IMMUNE''
	IF @hccCategory = 54 OR @hccCategory = 55 OR @hccCategory = 60
		RETURN ''Substance Use with Psychotic Complications''
	IF @hccCategory = 57 OR @hccCategory = 58 OR @hccCategory = 59 OR @hccCategory = 60
		RETURN ''Schizophrenia''
	IF @hccCategory = 70 OR @hccCategory = 71 OR @hccCategory = 72 OR @hccCategory = 103 OR @hccCategory = 104 OR @hccCategory = 169
		RETURN ''Quadriplegia''
	IF @hccCategory = 74
		RETURN ''Cerebral Palsy''
	IF @hccCategory = 75
		RETURN ''Myasthenia Gravis/Myoneural Disorders and Guillain-Barre Syndrome/Inflammatory and Toxic Neuropathy''
	IF @hccCategory = 76
		RETURN ''Muscular Dystrophy''
	IF @hccCategory = 77
		RETURN ''Multiple Sclerosis''
	IF @hccCategory = 78
		RETURN ''Parkinson/Huntington Diseases''
	IF @hccCategory = 79
		RETURN ''Seizure Disorders and Convulsions''
	IF @hccCategory = 82 OR @hccCategory = 83 OR @hccCategory = 84
		RETURN ''CARD_RESP_FAIL''
	IF @hccCategory = 85
		RETURN ''CHF''
	IF @hccCategory = 86 OR @hccCategory = 87 OR @hccCategory = 88
		RETURN ''Acute Myocardial Infarction''
	IF @hccCategory = 96
		RETURN ''Specified Heart Arrhythmias''
	IF @hccCategory = 99 OR @hccCategory = 100
		RETURN ''Cerebral Hemorrhage''
	IF @hccCategory = 106 OR @hccCategory = 107 OR @hccCategory = 108
		RETURN ''Atherosclerosis of Extremity with Ulceration or Gangrene''
	IF @hccCategory = 110 OR @hccCategory = 111 OR @hccCategory = 112
		RETURN ''COPD''
	IF @hccCategory = 114 OR @hccCategory = 115
		RETURN ''Aspiration and Specified Bacterial Pneumonias''
	IF @hccCategory = 122
		RETURN ''Proliferative Diabetic Retinopathy and Vitreous Hemorrhage''
	IF @hccCategory = 124
		RETURN ''Exudative Macular Degeneration''
	IF @hccCategory = 134 OR @hccCategory = 135 OR @hccCategory = 136 OR @hccCategory = 137 OR @hccCategory = 138
		RETURN ''Renal''
	IF @hccCategory = 157 OR @hccCategory = 158 OR @hccCategory = 161
		RETURN ''Ulcer of Skin''
	IF @hccCategory = 162
		RETURN ''Severe Skin Burn or Condition''
	IF @hccCategory = 166 OR @hccCategory = 80 OR @hccCategory = 167 
		RETURN ''Severe Head Injury''
	IF @hccCategory = 170
		RETURN ''Hip Fracture/Dislocation''
	IF @hccCategory = 173
		RETURN ''Traumatic Amputations and Complications''
	IF @hccCategory = 176
		RETURN ''COMPL''
	IF @hccCategory = 186
		RETURN  ''Major Organ Transplant Status or Replacement Status''
	IF @hccCategory = 188
		RETURN ''Artificial Openings for Feeding or Elimination''
	IF @hccCategory = 189
		RETURN ''Amputation Status, Lower Limb/Amputation Complication''

	RETURN NULL
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetHCCCommuityFactors]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetHCCCommuityFactors](@code9 VARCHAR(6), @code10 VARCHAR(10)) RETURNS DECIMAL(4,3) AS
BEGIN
	DECLARE @hcc DECIMAL(4,3)

	SELECT	@hcc= MAX(srb.HCCCommunityFactors)
	FROM	IMO_ProblemIT_SearchResult_Base srb
	WHERE	srb.Code09 = @code9 AND
			srb.Code10 = @code10

	RETURN @hcc
END
' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetHideFlag]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetHideFlag](@kdbItemNode [nvarchar](255), @clinicCenterUid [uniqueidentifier], @providerUid [uniqueidentifier], @kdbClinicCenter [xml], @kdbProvider [xml])
RETURNS [bit] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[GetHideFlag]' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[StringToDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[StringToDate](@answer [nvarchar](255))
RETURNS [datetime] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[StringToDate]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetHistoryDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetHistoryDate](@patientUid UNIQUEIDENTIFIER, @question VARCHAR(100)) RETURNS DATE AS BEGIN
	DECLARE @date DATE
	SELECT	@date = dbo.StringToDate(phd.AnswerName)
	FROM	PatientHistory ph INNER JOIN PatientHistoryDetail phd ON ph.PatientHistoryUid = phd.PatientHistoryUid
	WHERE	phd.QuestionUid IN (SELECT QuestionUid FROM ListQuestion WHERE Name LIKE ''%'' + @question + ''%'')
			AND ph.InactiveDate IS NULL
			AND ph.PatientUid = @patientUid
			AND dbo.StringToDate(phd.AnswerName) IS NOT NULL

	RETURN	@date
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetHospitalRoundNames]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetHospitalRoundNames](@hospitalRoundUid uniqueidentifier, @provider bit) 
RETURNS VARCHAR(MAX) AS
BEGIN
	DECLARE @names VARCHAR(MAX)	
	
	IF @provider <> 0
		SELECT	@names = CASE WHEN @names IS NULL THEN '''' ELSE @names + '';'' END + 
				dbo.UDF_GetFormattedInternalName(p.FirstName, p.MiddleName, p.LastName, p.AkaFirstName, p.AkaLastName)
		FROM	RelHospitalRoundProvider rel INNER JOIN ViewProvider p ON rel.ProviderUid = p.PersonUid
		WHERE	rel.HospitalRoundUid = @hospitalRoundUid	
	ELSE	
		SELECT	@names = CASE WHEN @names IS NULL THEN '''' ELSE @names + '';'' END + dbo.GetDiagnosisCodeAndName(rel.Code9, rel.Code10, rel.CodeDescription)
		FROM	RelHospitalRoundDiagnosis rel
		WHERE	rel.HospitalRoundUid = @hospitalRoundUid
		
	RETURN @names
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetHospitalRoundNamesWithID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetHospitalRoundNamesWithID](@hospitalRoundUid uniqueidentifier, @provider bit) 
RETURNS VARCHAR(MAX) AS
BEGIN
	DECLARE @names VARCHAR(MAX)	
	
	IF @provider <> 0
		SELECT	@names = CASE WHEN @names IS NULL THEN '''' ELSE @names + '', '' END + dbo.UDF_GetFormattedInternalName(p.FirstName, p.MiddleName, p.LastName, p.AkaFirstName, p.AkaLastName)
		FROM	RelHospitalRoundProvider rel INNER JOIN ViewProvider p ON rel.ProviderUid = p.PersonUid
		WHERE	rel.HospitalRoundUid = @hospitalRoundUid	
	ELSE	
		SELECT	@names = CASE WHEN @names IS NULL THEN '''' ELSE @names + '', '' END + 		COALESCE(code10, code9) + '' '' + CodeDescription 
		FROM	RelHospitalRoundDiagnosis rel --INNER JOIN VisitDiagnosis vd ON rel.DiagnosisUid = vd.DiagnosisUid
		WHERE	rel.HospitalRoundUid = @hospitalRoundUid
		
	RETURN @names
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetHospitalRounds]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[GetHospitalRounds]
()
RETURNS @retTable TABLE 
(
	HospitalRoundUid UniqueIdentifier,
	ServiceSiteName varchar(255),
	ServiceSiteUid uniqueidentifier,
	PatientName varchar(255),
	PatientUid uniqueidentifier,
	Location varchar(255),
	AdmitDate datetime,
	DischargeDate datetime,
	Notes text,
	ProviderNames varchar(1000),
	ProviderUids varchar(1000),
	DiagnosisNames varchar(1000),
	DiagnosisCodes varchar(1000),
	Inactive bit
)
AS
	BEGIN
	-- Get all data except provider stuff
		insert into @retTable
		select 
			hr.HospitalRoundUid, ss.Name as ServiceSiteName,
			hr.ServiceSiteUid, p.LastName + '', '' + p.FirstName AS PatientName,
			PatientUid, Location, AdmitDate, DischargeDate,  hr.Notes,
			null, null, null, null, hr.Inactive
		from hospitalround hr
		inner join ListServiceSite ss on ss.ServiceSiteUid = hr.ServiceSiteUid
		inner join Person p on p.PersonUid = hr.PatientUid

	-- Now get the providers
	declare @curId uniqueidentifier
	select top 1 @curid = HospitalRoundUid from @retTable order by HospitalRoundUid

	while ( @curId is not null )
	begin
		declare @Names varchar(1000)
		declare @UidsOrCodes varchar(1000)
		set @Names = '''' 
		set @UidsOrCodes = ''''

	-- Provider info
		select @Names = @Names + dbo.UDF_getFormattedInternalName(firstname, middlename, lastname, akafirstname, akalastname) + ''; '',
		@UidsOrCodes = @UidsOrCodes + cast(ProviderUid as varchar(36)) + '';''
		from HospitalRound hr
		inner join RelHospitalRoundProvider rhrpv on rhrpv.HospitalRoundUid = @curId 
		inner join viewprovider vp on vp.personuid = rhrpv.ProviderUid
		where hr.HospitalRoundUid = @curid

		IF (len(@Names) > 0)
			SET @Names = left(@Names, len(@names) - 1)

		update @retTable
		set ProviderNames = @Names, ProviderUids = @UidsOrCodes
		where HospitalRoundUid = @curid and @names <> ''''

	-- Diagnosis names
		set @Names = '''' 
		set @UidsOrCodes = ''''

		select @Names = @Names + rhrd.CodeDescription + '' ('' + coalesce(rhrd.Code9, rhrd.Code10) + ''); '',
		@UidsOrCodes = @UidsOrCodes + cast(rhrd.Code9 as varchar(36)) + '';''
		from HospitalRound hr
		inner join RelHospitalRoundDiagnosis rhrd on rhrd.HospitalRoundUid = @curId 
		where hr.HospitalRoundUid = @curid

		IF (len(@Names) > 0)
			SET @Names = left(@Names, len(@names) - 1)

		update @retTable
		set DiagnosisNames = @Names, DiagnosisCodes = @UidsOrCodes
		where HospitalRoundUid = @curid and @names <> ''''

		-- advance to the next one
		select top 1 @curid = HospitalRoundUid from @retTable where HospitalRoundUid > @curid order by HospitalRoundUid 
		if @@rowcount = 0  set @curid = null
	end
	return 
END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetHospitalRoundSpecificUids]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[GetHospitalRoundSpecificUids](@hospitalRoundUid uniqueidentifier, @provider bit,@provideruid Varchar(max)=Null) 
RETURNS VARCHAR(MAX) AS
BEGIN
	DECLARE	@uidsOrCodes VARCHAR(MAX)
		
	IF @provider <> 0
		SELECT	@uidsOrCodes = CASE WHEN @uidsOrCodes IS NULL THEN '''' ELSE @uidsOrCodes + '';'' END + CONVERT(VARCHAR(36), rel.ProviderUid)
		FROM	RelHospitalRoundProvider rel 
		WHERE	rel.HospitalRoundUid = @hospitalRoundUid
		and (@provideruid is null OR rel.ProviderUid in (Select Element From dbo.Split (@provideruid,'','')))
	ELSE
		SELECT	@uidsOrCodes = CASE WHEN @uidsOrCodes IS NULL THEN '''' ELSE @uidsOrCodes + '';'' END + CONVERT(VARCHAR(36), rel.Code9)
		FROM	RelHospitalRoundDiagnosis rel 
		WHERE	rel.HospitalRoundUid = @hospitalRoundUid
	
	
	RETURN @uidsOrCodes
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetHospitalRoundUids]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetHospitalRoundUids](@hospitalRoundUid uniqueidentifier, @provider bit) 
RETURNS VARCHAR(MAX) AS
BEGIN
	DECLARE	@uidsOrCodes VARCHAR(MAX)
		
	IF @provider <> 0
		SELECT	@uidsOrCodes = CASE WHEN @uidsOrCodes IS NULL THEN '''' ELSE @uidsOrCodes + '';'' END + CONVERT(VARCHAR(36), rel.ProviderUid)
		FROM	RelHospitalRoundProvider rel 
		WHERE	rel.HospitalRoundUid = @hospitalRoundUid
	ELSE
		SELECT	@uidsOrCodes = CASE WHEN @uidsOrCodes IS NULL THEN '''' ELSE @uidsOrCodes + '';'' END + CONVERT(VARCHAR(36), rel.Code9)
		FROM	RelHospitalRoundDiagnosis rel 
		WHERE	rel.HospitalRoundUid = @hospitalRoundUid
	
	
	RETURN @uidsOrCodes
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetIndexColumns]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetIndexColumns]
(
	@object_id int,
	@index_id int
) RETURNS  VARCHAR(MAX) AS 
BEGIN 
		DECLARE @Columns VARCHAR(MAX)
		
		SELECT	@Columns = COALESCE(@Columns + '', '', '''') + c.Name
		FROM	sys.index_columns ic INNER JOIN sys.columns c ON ic.object_id = c.object_id AND ic.column_id = c.column_id
		WHERE   ic.object_id = @object_id AND
				ic.index_id = @index_id AND
				ic.is_included_column = 0
		RETURN @Columns
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetKdbConfigurationUidByProviders]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
/****** Object:  UserDefinedFunction [dbo].[GetKdbConfigurationUidByProviders]    Script Date: 9/24/2019 1:51:58 PM ******/
-- #25759: This function will return the KdbConfigurationUid that is determined based on the current user, and optionally, a billing and rendering provider
CREATE FUNCTION [dbo].[GetKdbConfigurationUidByProviders]( @userUid UNIQUEIDENTIFIER = NULL, @renderingProviderUid UNIQUEIDENTIFIER = NULL, @billingProviderUid UNIQUEIDENTIFIER = NULL) RETURNS UNIQUEIDENTIFIER AS
BEGIN
	DECLARE @kdbConfigurationUid UNIQUEIDENTIFIER = NULL
	DECLARE @currentUserProviderUid UNIQUEIDENTIFIER = NULL

	IF @userUid IS NOT NULL
	BEGIN
		-- try to get KdbConfigurationUid from Provider table for the user
		SELECT @kdbConfigurationUid = p.KdbConfigurationUid,
			   @currentUserProviderUid = p.PersonUid
		FROM Provider p 
		WHERE p.PersonUid = @userUid

		-- If the user is not a Provider, or they don''t have a KdbConfigurationUid set, 
		-- then try to retrieve the KdbConfigurationUid from the ListUserSetting for the user
		IF @kdbConfigurationUid IS NULL
			SELECT	@kdbConfigurationUid = KdbConfigurationUid
			FROM	UserPRM u 
			INNER JOIN ListUserSetting us ON u.UserSettingUid = us.UserSettingUid
			WHERE	u.PersonUid = @userUid
	END

	-- If the user doesn''t have a KdbConfigurationUid on their ListUserSetting, and the user is NOT a Provider,
	-- then try to get the KdbConfigurationUid for the Rendering Provider, or the Billing Provider instead
	IF @kdbConfigurationUid IS NULL AND @currentUserProviderUid IS NULL
	BEGIN
		IF @renderingProviderUid IS NOT NULL 
		AND (@renderingProviderUid <> @userUid OR @userUid IS NULL)
			SET @kdbConfigurationUid = dbo.GetKdbConfigurationUidByProviders(@renderingProviderUid, DEFAULT, DEFAULT)

		IF @kdbConfigurationUid IS NULL 
		AND @billingProviderUid IS NOT NULL 
		AND (@billingProviderUid <> @renderingProviderUid OR @renderingProviderUid IS NULL)
		AND (@billingProviderUid <> @userUid OR @userUid IS NULL)
			SET @kdbConfigurationUid = dbo.GetKdbConfigurationUidByProviders(@billingProviderUid, DEFAULT, DEFAULT)
	END
			
	RETURN @kdbConfigurationUid
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetKdbConfigurationUid]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'/****** Object:  UserDefinedFunction [dbo].[GetKdbConfigurationUid]    Script Date: 9/24/2019 2:48:27 PM ******/
-- #25759: This function has the same behavior as it previously did. The logic was just moved into dbo.GetKdbConfigurationUidByProviders, 
-- and this function was modified to call that function, and return the result.
CREATE FUNCTION [dbo].[GetKdbConfigurationUid]( @userUid UNIQUEIDENTIFIER ) RETURNS UNIQUEIDENTIFIER AS
BEGIN
	DECLARE @kdbConfigurationUid UNIQUEIDENTIFIER = dbo.GetKdbConfigurationUidByProviders(@userUid, DEFAULT, DEFAULT)		
	RETURN @kdbConfigurationUid
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetKdbConfigurationUidByVisit]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
/****** Object:  UserDefinedFunction [dbo].[GetKdbConfigurationUidByVisit]    Script Date: 9/24/2019 1:51:58 PM ******/
-- #25759: This function will return the KdbConfigurationUid that is determined based on the current user, and optionally, values from a Visit
CREATE FUNCTION [dbo].[GetKdbConfigurationUidByVisit]( @userUid UNIQUEIDENTIFIER = NULL, @visitUid UNIQUEIDENTIFIER = NULL) RETURNS UNIQUEIDENTIFIER AS
BEGIN
	DECLARE @kdbConfigurationUid UNIQUEIDENTIFIER = NULL

	-- get the KdbConfigurationUid from just the userUid if the visitUid is null
	IF @userUid IS NOT NULL AND @visitUid IS NULL
		SET @kdbConfigurationUid = dbo.GetKdbConfigurationUidByProviders(@userUid, DEFAULT, DEFAULT)

	-- if the KdbConfigurationUid is still null, then use the userUid, and RenderingProvider or BillingProvider from the Visit to look it up
	IF @kdbConfigurationUid IS NULL AND @visitUid IS NOT NULL
	BEGIN
		DECLARE @renderingProviderUid UNIQUEIDENTIFIER
		DECLARE @billingProviderUid UNIQUEIDENTIFIER

		-- try to get BillingProvider and RenderingProvider from the visit, so they can be used to lookup the KdbConfiguration
		SELECT @renderingProviderUid = v.RenderingProviderUid,
			   @billingProviderUid = v.ProviderUid
		FROM Visit v 
		WHERE v.VisitUid = @visitUid

		SET @kdbConfigurationUid = dbo.GetKdbConfigurationUidByProviders(@userUid, @renderingProviderUid, @billingProviderUid)
	END
			
	RETURN @kdbConfigurationUid
END
' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetKdbOverrideElement]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetKdbOverrideElement](@uid [uniqueidentifier], @kdbOverride [xml])
RETURNS [xml] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[GetKdbOverrideElement]' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetKdbOverrideValue]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetKdbOverrideValue](@uid [uniqueidentifier], @kdbItemNode [nvarchar](255), @kdb [xml], @attributeName [nvarchar](max))
RETURNS [nvarchar](max) WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[GetKdbOverrideValue]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetLastObservationValue]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetLastObservationValue](@patientUid UNIQUEIDENTIFIER, @observationItemUid UNIQUEIDENTIFIER, @startDate DATE, @endDate DATE, @valueType TINYINT = 0) RETURNS VARCHAR(100) AS
BEGIN
	DECLARE @result VARCHAR(100)
	
	SELECT TOP 1	@result =	CASE @valueType
								WHEN 1 THEN
									CAST(ov.MetricValue1 AS VARCHAR(100))
								WHEN 2 THEN
									CAST(ov.MetricValue2 AS VARCHAR(100))
								WHEN 10 THEN
									CONVERT(VARCHAR(100), COALESCE(oo.ResultDate, oo.PerformDate), 101)
								ELSE
									CAST(ov.ObservationValue AS VARCHAR(100))
								END
	FROM			ObservationOrder oo INNER JOIN ObservationValue ov ON oo.ObservationOrderUid = ov.ObservationOrderUid
	WHERE			ov.ObservationItemUid = @observationItemUid AND
					oo.PatientUid = @patientUid AND
					(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) >= @startDate OR @startDate IS NULL) AND
					(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE)<= @endDate OR @endDate IS NULL)
	ORDER BY		COALESCE(oo.ResultDate, oo.PerformDate) DESC

	RETURN			@result
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetLastObservationValueByName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetLastObservationValueByName](@patientUid UNIQUEIDENTIFIER, @observationName VARCHAR(100), @startDate DATE, @endDate DATE, @valueType TINYINT = 0) RETURNS VARCHAR(100) AS
BEGIN
	DECLARE @result VARCHAR(100)
	
	DECLARE cur CURSOR FOR 
		SELECT			CASE @valueType
									WHEN 1 THEN
										CAST(ov.MetricValue1 AS VARCHAR(100))
									WHEN 2 THEN
										CAST(ov.MetricValue2 AS VARCHAR(100))
									WHEN 10 THEN
										CONVERT(VARCHAR(100), COALESCE(oo.ResultDate, oo.PerformDate), 101)
									ELSE
										CAST(ov.ObservationValue AS VARCHAR(100))
									END
		FROM			ObservationOrder oo INNER JOIN ObservationValue ov ON oo.ObservationOrderUid = ov.ObservationOrderUid
						INNER JOIN ListObservationItem oi ON ov.ObservationItemUid = oi.ObservationItemUid
		WHERE			oi.Name LIKE @observationName AND
						oo.PatientUid = @patientUid AND
						(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) >= @startDate OR @startDate IS NULL) AND
						(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE)<= @endDate OR @endDate IS NULL)
		ORDER BY		oo.ResultDate DESC

	OPEN cur
	FETCH NEXT FROM cur INTO @result
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF @result IS NOT NULL AND RTRIM(@result) <> ''''
			RETURN @result
		
		FETCH NEXT FROM cur INTO @result
	END
	
	RETURN @result
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetLastObservationValueTable]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetLastObservationValueTable](@patientUid UNIQUEIDENTIFIER, @observationName VARCHAR(100), @startDate DATE, @endDate DATE, @sortType smallint)
	RETURNS @Observation TABLE 
	(
		PatientUid UNIQUEIDENTIFIER,
		ObservationDate DATE,
		ObservationValue VARCHAR(100)
	)
AS
BEGIN
	IF @sortType = 1
			INSERT			@Observation
			SELECT TOP 1	t.PatientUid, t.ObservationDate, t.ObservationValue
			FROM			(	SELECT	@patientUid AS PatientUid, ov.ObservationValueUid,
										CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) AS ObservationDate,
										CAST(ov.ObservationValue AS VARCHAR(100)) AS ObservationValue
								FROM	ObservationOrder oo INNER JOIN ObservationValue ov ON oo.ObservationOrderUid = ov.ObservationOrderUid
										INNER JOIN ListObservationItem oi ON ov.ObservationItemUid = oi.ObservationItemUid
								WHERE	oi.Name LIKE @observationName AND
										oo.PatientUid = @patientUid AND
										(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) >= @startDate OR @startDate IS NULL) AND
										(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) <= @endDate OR @endDate IS NULL) AND
										ov.ObservationValue IS NOT NULL AND
										RTRIM(CAST(ov.ObservationValue AS VARCHAR(100))) <> '''' AND
										ISNUMERIC(CAST(ov.ObservationValue AS VARCHAR(100))) = 1) t	
			ORDER BY		CAST(t.ObservationValue AS MONEY), t.ObservationDate DESC
	ELSE IF @sortType = 2
			INSERT			@Observation
			SELECT TOP 1	t.PatientUid, t.ObservationDate, t.ObservationValue
			FROM			(	SELECT	@patientUid AS PatientUid, ov.ObservationValueUid,
										CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) AS ObservationDate,
										CAST(ov.ObservationValue AS VARCHAR(100)) AS ObservationValue
								FROM	ObservationOrder oo INNER JOIN ObservationValue ov ON oo.ObservationOrderUid = ov.ObservationOrderUid
										INNER JOIN ListObservationItem oi ON ov.ObservationItemUid = oi.ObservationItemUid
								WHERE	oi.Name LIKE @observationName AND
										oo.PatientUid = @patientUid AND
										(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) >= @startDate OR @startDate IS NULL) AND
										(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) <= @endDate OR @endDate IS NULL) AND
										ov.ObservationValue IS NOT NULL AND
										RTRIM(CAST(ov.ObservationValue AS VARCHAR(100))) <> '''' AND
										ISNUMERIC(CAST(ov.ObservationValue AS VARCHAR(100))) = 1) t	
			ORDER BY		CAST(t.ObservationValue AS MONEY) DESC, t.ObservationDate DESC
	ELSE
			INSERT			@Observation
			SELECT TOP 1	@patientUid, CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) AS ObservationDate,
							ov.ObservationValue							
			FROM			ObservationOrder oo INNER JOIN ObservationValue ov ON oo.ObservationOrderUid = ov.ObservationOrderUid
							INNER JOIN ListObservationItem oi ON ov.ObservationItemUid = oi.ObservationItemUid
			WHERE			oi.Name LIKE @observationName AND
							oo.PatientUid = @patientUid AND
							(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) >= @startDate OR @startDate IS NULL) AND
							(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE)<= @endDate OR @endDate IS NULL) AND
							ov.ObservationValue IS NOT NULL AND
							RTRIM(CAST(ov.ObservationValue AS VARCHAR(MAX))) <> ''''
			ORDER BY		COALESCE(oo.ResultDate, oo.PerformDate) DESC
	RETURN 
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetLastStatementDate_ForAccountResponsibleParty_WithAggregateOption]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetLastStatementDate_ForAccountResponsibleParty_WithAggregateOption] (@accountResponsiblePartyUid UNIQUEIDENTIFIER, @financialCenterUid UNIQUEIDENTIFIER, @aggregateMultpleFinancialCentersTogether BIT = 0)
RETURNS @retTable TABLE (AccountResponsiblePartyUid UNIQUEIDENTIFIER, FinancialCenterUid UNIQUEIDENTIFIER, LastStatementDate DATE, BatchComplete BIT)
AS
BEGIN
 WITH 
 cteStatementsByFinancialCenter AS /* get practice settings */ ( SELECT TOP 1 PS.StatementsByFinancialCenter FROM PracticeSettings PS ),
 cteStatementBatchDetailData AS (
  SELECT SBD.AccountResponsiblePartyUid, SBD.FinancialCenterUid, SBD.StatementDate, SBD.LastModifiedDate, CAST(CASE WHEN (NOT SBDWATCH.StatementBatchUid IS NULL) THEN 1 ELSE 0 END AS BIT) AS BatchComplete
  FROM StatementBatchDetail SBD WITH (NOLOCK)
    INNER JOIN StatementBatch SB WITH (NOLOCK) ON SBD.StatementBatchUid = SB.StatementBatchUid
    LEFT JOIN (
     SELECT DISTINCT StatementBatchUid
     FROM StatementBatchDetail WITH (NOLOCK)
     WHERE NOT AttachmentUid IS NULL
     ) SBDWATCH ON SBD.StatementBatchUid = SBDWATCH.StatementBatchUid
    INNER JOIN cteStatementsByFinancialCenter SBFC ON (1 = 1) -- will always have one record
  WHERE (NOT SB.StatementActionUid = ''A88F5A75-0AD5-4C90-B006-8A007A7FA13C'')
    AND (SBD.AccountResponsiblePartyUid = @accountResponsiblePartyUid)
    AND (  (SBFC.StatementsByFinancialCenter = 0 AND SBD.FinancialCenterUid IS NULL)
        OR (SBFC.StatementsByFinancialCenter = 1 AND SBD.FinancialCenterUid = @financialCenterUid))
  ), 
cteFilteredByBatch AS (
  SELECT DISTINCT AccountResponsiblePartyUid, FinancialCenterUid, CASE WHEN BatchComplete = 0 THEN LastModifiedDate ELSE StatementDate END AS StatementDate, BatchComplete
  FROM cteStatementBatchDetailData A
  WHERE (BatchComplete = 1 AND NOT StatementDate IS NULL) OR (Batchcomplete = 0)
  ), 
cteArpOldData AS (
  SELECT DISTINCT ARP.AccountResponsiblePartyUid, NULL AS FinancialCenterUid, ARP.LastStatementDate AS StatementDate, CAST(1 AS BIT) AS BatchComplete
  FROM AccountResponsibleParty ARP WITH (NOLOCK)
    INNER JOIN cteStatementsByFinancialCenter SBFC ON (1 = 1) -- will always have one record
  WHERE (SBFC.StatementsByFinancialCenter = 0) -- this is an ARP ONLY record
   AND ARP.AccountResponsiblePartyUid = @accountResponsiblePartyUid
  ),
cteArpFCCover AS ( /* we have no ARPFC set like ARP only above - creating FAKE data here */
  
  SELECT DISTINCT @accountResponsiblePartyUid AccountResponsiblePartyUid, @financialCenterUid FinancialCenterUid, NULL AS StatementDate, CAST(1 AS BIT) AS BatchComplete
  FROM cteStatementsByFinancialCenter SBFC
  WHERE (SBFC.StatementsByFinancialCenter = 1) -- these are FC ONLY records
  ), 
cteArpFcOldData AS (
  SELECT DISTINCT ARPFC.AccountResponsiblePartyUid, ARPFC.FinancialCenterUid, ARPFC.LastStatementDate AS StatementDate, CAST(1 AS BIT) AS BatchComplete
  FROM RelAccountResponsiblePartyFinancialCenter ARPFC WITH (NOLOCK)
    INNER JOIN cteStatementsByFinancialCenter SBFC ON (1 = 1) -- will always have one record
  WHERE (SBFC.StatementsByFinancialCenter = 1) -- this is an FC ONLY record
   AND ARPFC.AccountResponsiblePartyUid = @accountResponsiblePartyUid AND ARPFC.FinancialCenterUid = @financialCenterUid
  ), 
cteUnionAll AS (
  SELECT * FROM cteFilteredByBatch  
  UNION
  SELECT * FROM cteArpOldData
  UNION
  SELECT * FROM cteArpFcOldData
  UNION
  SELECT * FROM cteArpFCCover
  ),
cteSbdWithRowNumsSQL AS (
  SELECT SBD.AccountResponsiblePartyUid, SBD.FinancialCenterUid, SBD.StatementDate, 
    ROW_NUMBER() OVER ( PARTITION BY SBD.AccountResponsiblePartyUid, SBD.FinancialCenterUid ORDER BY SBD.StatementDate DESC ) AS ROWNUMWFC, 
    ROW_NUMBER() OVER ( PARTITION BY SBD.AccountResponsiblePartyUid ORDER BY SBD.StatementDate DESC ) AS ROWNUMWOFC, 
    SBD.BatchComplete --  @aggregateMultpleFinancialCentersTogether
    FROM cteUnionAll SBD
  ), 
cteHistoricalLastStatementDateSQL AS (
  SELECT RN.AccountResponsiblePartyUid, CASE WHEN @aggregateMultpleFinancialCentersTogether = 0 THEN RN.FinancialCenterUid ELSE NULL END AS FinancialCenterUid, RN.StatementDate AS LastStatementDate, RN.BatchComplete
  FROM cteSbdWithRowNumsSQL RN
  WHERE (@aggregateMultpleFinancialCentersTogether = 0 AND ROWNUMWFC = 1) OR (@aggregateMultpleFinancialCentersTogether = 1 AND ROWNUMWOFC = 1)
  )
 
 INSERT INTO @retTable (AccountResponsiblePartyUid, FinancialCenterUid, LastStatementDate, BatchComplete)
 SELECT DISTINCT HLSD.* FROM cteHistoricalLastStatementDateSQL HLSD;

 RETURN;
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetLastStatementDatesForAccountResponsiblePartyWithAggregateOption]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE FUNCTION [dbo].[GetLastStatementDatesForAccountResponsiblePartyWithAggregateOption](@accountResponsbilePartyUids VARCHAR(MAX), @financialCenterUids VARCHAR(MAX), @aggregateMultpleFinancialCentersTogether BIT = 0)
RETURNS @retTable TABLE 
(
    AccountResponsiblePartyUid UNIQUEIDENTIFIER,
	FinancialCenterUid UNIQUEIDENTIFIER,
	LastStatementDate DATE,
	BatchComplete BIT
)
AS
BEGIN

WITH cteStatementsByFinancialCenter AS -- get practice settings
(
	SELECT TOP 1  PS.StatementsByFinancialCenter 
		FROM PracticeSettings PS
), cteARP AS -- get AccountResponsiblePartyUid list, either all if none specified 
(
	SELECT DISTINCT CAST(SARP.Element AS UNIQUEIDENTIFIER) AS AccountResponsiblePartyUid  
		FROM dbo.Split(@accountResponsbilePartyUids, '';'')  SARP
			INNER JOIN AccountResponsibleParty ARP WITH (NOLOCK) ON CAST(SARP.Element AS UNIQUEIDENTIFIER) = ARP.AccountResponsiblePartyUid
	UNION
	SELECT AccountResponsiblePartyUid FROM AccountResponsibleParty WHERE @accountResponsbilePartyUids IS NULL
), cteFC AS -- get FinancialCenterUid list, either all if none specified 
(
	SELECT DISTINCT CAST(Element AS UNIQUEIDENTIFIER) AS FinancialCenterUid  
		FROM dbo.Split(@financialCenterUids, '';'') SFC
			INNER JOIN FinancialCenter FC WITH (NOLOCK) ON CAST(SFC.Element AS UNIQUEIDENTIFIER) = FC.FinancialCenterUid

	UNION
	SELECT FinancialCenterUid  FROM FinancialCenter WITH (NOLOCK) WHERE @financialCenterUids IS NULL
), cteStatementBatchDetailData AS
(
 SELECT SBD.AccountResponsiblePartyUid, SBD.FinancialCenterUid,  SBD.StatementDate, SBD.LastModifiedDate, 
		CAST(CASE WHEN (NOT SBDWATCH.StatementBatchUid IS NULL) THEN 1 ELSE 0 END AS BIT) AS BatchComplete 
	FROM StatementBatchDetail SBD WITH (NOLOCK) 
		INNER JOIN StatementBatch SB WITH (NOLOCK) ON SBD.StatementBatchUid = SB.StatementBatchUid 
			LEFT JOIN (SELECT DISTINCT StatementBatchUid FROM StatementBatchDetail WITH (NOLOCK)  WHERE NOT AttachmentUid IS NULL) SBDWATCH ON SBD.StatementBatchUid = SBDWATCH.StatementBatchUid 
			INNER JOIN cteStatementsByFinancialCenter SBFC ON (1=1) -- will always have one record
			INNER JOIN cteARP ARPF ON SBD.AccountResponsiblePartyUid = ARPF.AccountResponsiblePartyUid
			LEFT JOIN cteFC FCF ON SBD.FinancialCenterUid = FCF.FinancialCenterUid
	WHERE (NOT SB.StatementActionUid = ''A88F5A75-0AD5-4C90-B006-8A007A7FA13C'') 
		AND ((SBFC.StatementsByFinancialCenter = 0 AND SBD.FinancialCenterUid IS NULL) 
			OR (SBFC.StatementsByFinancialCenter = 1 AND NOT FCF.FinancialCenterUid IS NULL))
), cteFilteredByBatch AS
(
	SELECT DISTINCT AccountResponsiblePartyUid, FinancialCenterUid,
			CASE WHEN BatchComplete = 0 THEN LastModifiedDate ELSE StatementDate END AS StatementDate,  BatchComplete
		FROM cteStatementBatchDetailData A
		WHERE (BatchComplete = 1 AND NOT StatementDate IS NULL) OR (Batchcomplete = 0)
), cteArpOldData AS
(
	SELECT DISTINCT ARP.AccountResponsiblePartyUid, NULL AS FinancialCenterUid,
			ARP.LastStatementDate AS StatementDate, CAST(1 AS BIT) AS BatchComplete
		FROM AccountResponsibleParty ARP  WITH (NOLOCK)
			INNER JOIN cteStatementsByFinancialCenter SBFC ON (1=1) -- will always have one record
			INNER JOIN cteARP ARPF ON ARP.AccountResponsiblePartyUid = ARPF.AccountResponsiblePartyUid
		WHERE (SBFC.StatementsByFinancialCenter = 0) -- this is an ARP ONLY record
), cteArpFCCover AS -- we have no ARPFC set like ARP only above - creating FAKE data here 
(
	SELECT DISTINCT ARPF.AccountResponsiblePartyUid, FCF.FinancialCenterUid,
			NULL AS StatementDate, CAST(1 AS BIT) AS BatchComplete
		FROM cteARP ARPF 
			INNER JOIN cteStatementsByFinancialCenter SBFC ON (1=1) -- will always have one record
			INNER JOIN cteFC FCF ON (1=1) -- gets me a CROSS JOIN
		WHERE (SBFC.StatementsByFinancialCenter = 1) -- these are FC ONLY records
), cteArpFcOldData AS
(
	SELECT DISTINCT ARPFC.AccountResponsiblePartyUid, ARPFC.FinancialCenterUid,
			ARPFC.LastStatementDate AS StatementDate, CAST(1 AS BIT) AS BatchComplete
		FROM RelAccountResponsiblePartyFinancialCenter ARPFC WITH (NOLOCK)
			INNER JOIN cteStatementsByFinancialCenter SBFC ON (1=1) -- will always have one record
			INNER JOIN cteARP ARPF ON ARPFC.AccountResponsiblePartyUid = ARPF.AccountResponsiblePartyUid
			INNER JOIN cteFC FCF ON (ARPFC.FinancialCenterUid = FCF.FinancialCenterUid) -- limits by FC list
		WHERE (SBFC.StatementsByFinancialCenter = 1) -- this is an FC ONLY record
), cteUnionAll AS
(
	SELECT * FROM cteFilteredByBatch
		UNION 
	SELECT * FROM cteArpOldData
		UNION 
	SELECT * FROM cteArpFcOldData
		UNION 
	SELECT * FROM cteArpFCCover
), cteSbdWithRowNumsSQL AS
(
	SELECT SBD.AccountResponsiblePartyUid, SBD.FinancialCenterUid, SBD.StatementDate, 
			ROW_NUMBER() OVER (PARTITION BY SBD.AccountResponsiblePartyUid, SBD.FinancialCenterUid
				ORDER BY SBD.StatementDate DESC) AS ROWNUMWFC, 
			ROW_NUMBER() OVER (PARTITION BY SBD.AccountResponsiblePartyUid
				ORDER BY SBD.StatementDate DESC) AS ROWNUMWOFC, 
			SBD.BatchComplete  --  @aggregateMultpleFinancialCentersTogether
		FROM cteUnionAll SBD
), cteHistoricalLastStatementDateSQL AS
(
	SELECT RN.AccountResponsiblePartyUid, 
		CASE WHEN @aggregateMultpleFinancialCentersTogether = 0 THEN RN.FinancialCenterUid ELSE NULL END AS FinancialCenterUid, 
		RN.StatementDate AS LastStatementDate, RN.BatchComplete
		FROM cteSbdWithRowNumsSQL RN 
		WHERE (@aggregateMultpleFinancialCentersTogether = 0 AND ROWNUMWFC = 1)
			OR (@aggregateMultpleFinancialCentersTogether = 1 AND ROWNUMWOFC = 1)
)
INSERT INTO @retTable (AccountResponsiblePartyUid, FinancialCenterUid, LastStatementDate, BatchComplete)
SELECT DISTINCT HLSD.*
	FROM cteHistoricalLastStatementDateSQL HLSD;
	 
	RETURN;

END

















' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetLastStatementDatesForAccountResponsibleParty]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE FUNCTION [dbo].[GetLastStatementDatesForAccountResponsibleParty](@accountResponsbilePartyUids VARCHAR(MAX), @financialCenterUids VARCHAR(MAX))
RETURNS @retTable TABLE 
(
    AccountResponsiblePartyUid UNIQUEIDENTIFIER,
	FinancialCenterUid UNIQUEIDENTIFIER,
	LastStatementDate DATE,
	BatchComplete BIT
)
AS
BEGIN

	INSERT INTO @retTable (AccountResponsiblePartyUid, FinancialCenterUid, LastStatementDate, BatchComplete)
	SELECT *
		FROM GetLastStatementDatesForAccountResponsiblePartyWithAggregateOption(@accountResponsbilePartyUids, @financialCenterUids, 0);
	 
	RETURN;

END

















' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetMappedDiagnosis]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
/* Pancratius 01/07/2014: Changed listdiagnosis.diagnosisCode9 to visitDiagnosis.code and commented out listdiagnosis table
Pancratius 03/06/2014: Add ISNULL function to to the visitdiagnosis.code and visitdiagnosis.code10
select
code + '', '' + coalesce(code10,'' '') from visitdiagnosis
20150518 kc add UseICD10 parameter
20150901 kc add else clause to handle labs without HL7 partners. 
*/

CREATE FUNCTION [dbo].[GetMappedDiagnosis](@ProcedureUid uniqueidentifier, @ImedicaAccessionNumber VARCHAR(50),@UseICD10 bit)  
RETURNS VARCHAR(MAX) AS  
BEGIN  
   DECLARE @Diag VARCHAR(MAX)  
   SET @Diag = ''''  
  
   --SELECT @Diag=@Diag + Coalesce(VisitDiagnosis.Code,'' '')+'', ''+Coalesce(VisitDiagnosis.Code10,'' '') + '', ''  
   IF (@UseICD10 = 1) 
   BEGIN
          SELECT @Diag = @Diag + Coalesce(VisitDiagnosis.Code10, VisitDiagnosis.Code) + '', ''
          FROM ObservationOrder  
          INNER JOIN VisitProcedure ON VisitProcedure.VisitProcedureUid = ObservationOrder.VisitProcedureUid  
          INNER JOIN VisitProcedureDiagnosis ON VisitProcedureDiagnosis.VisitProcedureUid = VisitProcedure.VisitProcedureUid  
          INNER JOIN VisitDiagnosis ON VisitProcedureDiagnosis.VisitDiagnosisUid = VisitDiagnosis.VisitDiagnosisUid  
          WHERE ObservationOrder.ImedicaAccessionNumber = @ImedicaAccessionNumber  
               AND VisitProcedure.ProcedureUid = @ProcedureUid  
               AND VisitProcedureDiagnosis.DisplayOrder<>0
          ORDER BY VisitDiagnosis.DisplayOrder  
   END
   ELSE If (@useICD10 = 0)--must be ICD9
   BEGIN
          SELECT @Diag = @Diag + Coalesce(VisitDiagnosis.Code,'' '') + '', ''
          FROM ObservationOrder  
          INNER JOIN VisitProcedure ON VisitProcedure.VisitProcedureUid = ObservationOrder.VisitProcedureUid  
          INNER JOIN VisitProcedureDiagnosis ON VisitProcedureDiagnosis.VisitProcedureUid = VisitProcedure.VisitProcedureUid  
          INNER JOIN VisitDiagnosis ON VisitProcedureDiagnosis.VisitDiagnosisUid = VisitDiagnosis.VisitDiagnosisUid  
          WHERE ObservationOrder.ImedicaAccessionNumber = @ImedicaAccessionNumber  
               AND VisitProcedure.ProcedureUid = @ProcedureUid  
               AND VisitProcedureDiagnosis.DisplayOrder<>0
          ORDER BY VisitDiagnosis.DisplayOrder  
   END
   Else if (@UseICD10 is Null) 
   BEGIN
          SELECT @DIAG = (CASE WHEN (VisitDiagnosis.Code is not null and VisitDiagnosis.Code10 is not null) 
				THEN @Diag + Coalesce(VisitDiagnosis.Code,'' '') +  ''/'' + Coalesce(VisitDiagnosis.Code10,'' '') + '', '' 
				ELSE CASE WHEN (VisitDiagnosis.Code is not null and VisitDiagnosis.Code10 is  null)
				THEN @Diag + Coalesce(VisitDiagnosis.Code,'' '') + '', '' 
				ELSE CASE WHEN (VisitDiagnosis.Code10 is not null and VisitDiagnosis.Code is  null)
				THEN @Diag + Coalesce(VisitDiagnosis.Code10,'' '') + '', '' 
				END
				END
			END )
          FROM ObservationOrder  
          INNER JOIN VisitProcedure ON VisitProcedure.VisitProcedureUid = ObservationOrder.VisitProcedureUid  
          INNER JOIN VisitProcedureDiagnosis ON VisitProcedureDiagnosis.VisitProcedureUid = VisitProcedure.VisitProcedureUid  
          INNER JOIN VisitDiagnosis ON VisitProcedureDiagnosis.VisitDiagnosisUid = VisitDiagnosis.VisitDiagnosisUid  
          WHERE ObservationOrder.ImedicaAccessionNumber = @ImedicaAccessionNumber  
               AND VisitProcedure.ProcedureUid = @ProcedureUid  
               AND VisitProcedureDiagnosis.DisplayOrder<>0
          ORDER BY VisitDiagnosis.DisplayOrder  
   END

       
   IF LEN(@Diag) >1  
      SET @Diag =SUBSTRING(@Diag,1,LEN(@Diag)-1)  
   RETURN @Diag  
END  
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getMaxDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[getMaxDate]
(
	@arg1 AS DATETIME,
	@arg2 AS DATETIME
)
RETURNS DATETIME
AS
BEGIN
	RETURN CASE
		WHEN @arg1 >= @arg2 or @arg2 is NULL THEN @arg1
		WHEN @arg2 > @arg1 or @arg1 is NULL THEN @arg2
		ELSE NULL
	END
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetMD5Hash]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetMD5Hash](@SourceString varchar(8000), @Modulo INT = 0)
	RETURNS INTEGER
AS
BEGIN
	IF @Modulo = 0
		RETURN CAST(HashBytes( ''MD5'', @SourceString) AS INTEGER)
	ELSE
		RETURN ABS(CAST(HashBytes( ''MD5'', @SourceString) AS INTEGER)) % @Modulo
	RETURN 0
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetMemberList_SR]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE Function [dbo].[GetMemberList_SR](@UID uniqueIdentifier)
Returns Varchar(2000)
AS
Begin
	Declare @List Varchar(2000)
	Set @List=null
	
	SELECT	
			@List=COALESCE(@List + '', '' , '''') + Replace(fuug.Name,'','','' '')
	FROM	UserGroupMember ugm CROSS JOIN ViewFindUserAndUserGroup fuug
	WHERE	ugm.UserGroupUid = @UID AND
			((ugm.MemberUserUid = fuug.Uid AND fuug.ForeignKeyIndex = 1) OR
			 (ugm.MemberUserGroupUid = fuug.Uid AND fuug.ForeignKeyIndex = 2))

	Return @List
End

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getFormattedPreferredName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE  FUNCTION [dbo].[UDF_getFormattedPreferredName]
(
        @PersonUid UNIQUEIDENTIFIER
)
RETURNS  VARCHAR(100)

AS
BEGIN

        DECLARE @PreferredName VARCHAR(100)

        SELECT @PreferredName = FormattedPreferredName
                
        FROM ViewPerson WHERE PersonUid = @PersonUid

        RETURN @PreferredName
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetMessageAssignedTo]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetMessageAssignedTo] (@messageUid uniqueidentifier) RETURNS VARCHAR(8000) AS
BEGIN
	DECLARE @assignedTo varchar(8000)
	DECLARE	@userUid uniqueidentifier
	DECLARE @userGroupUid uniqueidentifier

	SET @assignedTo = ''''
	
	DECLARE cur CURSOR FAST_FORWARD LOCAL FOR
		SELECT	UserUid, UserGroupUid FROM MessageUser WHERE MessageUid = @messageUid

	OPEN cur

	FETCH NEXT FROM cur INTO @userUid, @userGroupUid
	WHILE @@FETCH_STATUS = 0  
	BEGIN   
		IF @assignedTo <> ''''
			SET @assignedTo = @assignedTo + '';''
			
		IF NOT @userUid IS NULL
			SET @assignedTo = @assignedTo + RTRIM(dbo.UDF_getFormattedPreferredName(@userUid))
		ELSE
			SET @assignedTo = @assignedTo + RTRIM((SELECT [Name] FROM ListUserGroup WHERE UserGroupUid = @userGroupUid))

		FETCH NEXT FROM cur INTO @userUid, @userGroupUid
	END

	CLOSE cur
	DEALLOCATE cur

	RETURN @assignedTo
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetModifierForSuperbillProcedure]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetModifierForSuperbillProcedure]
(
	@SuperbillProcedureUID UniqueIdentifier
) Returns Varchar(1000)
AS
Begin
	Declare @Modifier Varchar(1000)
		
	SELECT 
		@Modifier= COALESCE(@Modifier + '', '','''') + LPM.Modifier 
	FROM
		SuperbillProcedureModifier SPM
	LEFT JOIN
		ListProcedureModifier LPM
	ON
		LPM.ProcedureModifierUID=SPM.ProcedureModifierUID
	WHERE
		SPM.SuperbillProcedureUID=@SuperbillProcedureUID
	ORDER BY
		SPM.DisplayOrder
	
	Return @Modifier
End

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetModifiers]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[GetModifiers]( @visitProcedureUid uniqueidentifier) RETURNS VARCHAR(100) AS 
	BEGIN
	
	DECLARE @modifiers varchar(100)
	DECLARE @modifier varchar(100)
	
	SELECT	@modifier = m1.ANSICode
	FROM	VisitProcedure vp LEFT JOIN ListProcedureModifier m1 ON vp.ProcedureModifier1Uid = m1.ProcedureModifierUid
	WHERE	vp.VisitProcedureUid = @visitProcedureUid
	
	IF NOT @modifier IS NULL
	BEGIN
		IF NOT @modifiers IS NULL
			SET @modifiers = @modifiers + '',''
		SET @modifiers = ISNULL(@modifiers,'''') + @modifier
	END
		
	SELECT	@modifier = m1.ANSICode
	FROM	VisitProcedure vp LEFT JOIN ListProcedureModifier m1 ON vp.ProcedureModifier2Uid = m1.ProcedureModifierUid
	WHERE	vp.VisitProcedureUid = @VisitProcedureUid
	
	IF NOT @modifier IS NULL
	BEGIN
		IF NOT @modifiers IS NULL
			SET @modifiers = @modifiers + '',''
		SET @modifiers = ISNULL(@modifiers,'''') + @modifier
	END

	SELECT	@modifier = m1.ANSICode
	FROM	VisitProcedure vp LEFT JOIN ListProcedureModifier m1 ON vp.ProcedureModifier3Uid = m1.ProcedureModifierUid
	WHERE	vp.VisitProcedureUid = @VisitProcedureUid
	
	IF NOT @modifier IS NULL
	BEGIN
		IF NOT @modifiers IS NULL
			SET @modifiers = @modifiers + '',''
		SET @modifiers = ISNULL(@modifiers,'''') + @modifier
	END

	SELECT	@modifier = m1.ANSICode
	FROM	VisitProcedure vp LEFT JOIN ListProcedureModifier m1 ON vp.ProcedureModifier4Uid = m1.ProcedureModifierUid
	WHERE	vp.VisitProcedureUid = @VisitProcedureUid
	
	IF NOT @modifier IS NULL
	BEGIN
		IF NOT @modifiers IS NULL
			SET @modifiers = @modifiers + '',''
		SET @modifiers = ISNULL(@modifiers,'''') + @modifier
	END
		
	RETURN @modifiers
	END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetNestedGroups]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE FUNCTION [dbo].[GetNestedGroups]	(
	@IncludeParent bit,
	@UserGroupUid UniqueIdentifier	
)
RETURNS  @retTable TABLE (UserGroupUid UniqueIdentifier)
AS
BEGIN
	IF (@IncludeParent=1) 
	BEGIN
		INSERT INTO @retTable values(@UserGroupUid)
 	END

	DECLARE @lUserGroupUid UniqueIdentifier

	DECLARE RetrieveUserGroups CURSOR STATIC LOCAL FOR
	SELECT MemberUserGroupUid FROM UserGroupMember WHERE 
		UserGroupUid = @UserGroupUid and MemberUserGroupUid is not null

	OPEN RetrieveUserGroups

	FETCH NEXT FROM RetrieveUserGroups
	INTO @lUserGroupUid

	WHILE (@@FETCH_STATUS = 0) 
	BEGIN
		INSERT INTO @retTable values(@lUserGroupUid)
  
		INSERT INTO @retTable
		select * from dbo.GetNestedGroups(0, @lUserGroupUid)
   
		FETCH NEXT FROM RetrieveUserGroups
		INTO @lUserGroupUid
	END
	
	CLOSE RetrieveUserGroups
	DEALLOCATE RetrieveUserGroups

RETURN
END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_utcToCurrentDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[UDF_utcToCurrentDate] 
(@utcDate DATETIME)  
RETURNS 
	DATETIME
AS  
BEGIN 
Return	dbo.Date_UTCToLocal_Practice(@utcDate)
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getPatientBp]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[getPatientBp] -- Returns like 1:30 One and half an hour
(
	@PateintUid Uniqueidentifier,
	@Type VarChar(1)
)
RETURNS DECIMAL(10,2)

BEGIN
	Declare @Bp DECIMAL(10,2)
	Select TOP 1 @Bp= (CASE WHEN @Type=''S'' THEN Metricvalue1 ELSE Metricvalue2 END)
	From [MDOL_RPT2_ViewPatientBP] 
	Where PatientUid=@PateintUid
	Order By MeasureDate Desc,Metricvalue1 ASC, Metricvalue2 ASC
	Return @Bp
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getPatientBP2]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[getPatientBP2] -- Returns like 1:30 One and half an hour
(
	@PateintUid Uniqueidentifier,
	@StartDate datetime=NULL,
	@EndDate datetime=NULL,
	@Type VarChar(1)
)
RETURNS DECIMAL(10,2)

BEGIN
	Declare @Bp DECIMAL(10,2)
	Select TOP 1 @Bp= (CASE WHEN @Type=''S'' THEN Metricvalue1 ELSE Metricvalue2 END)
	From [MDOL_RPT2_ViewPatientBP] 
	Where PatientUid=@PateintUid
	and (@StartDate IS NULL OR MeasureDate  >= @StartDate) AND (@EndDate IS NULL OR MeasureDate  <@EndDate)
	and Metricvalue1 != 0 and Metricvalue2 != 0
	Order By MeasureDate Desc,Metricvalue1 ASC, Metricvalue2 ASC
	Return @Bp
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetPatientCareManagementNames]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetPatientCareManagementNames](@PatientCareManagementUid uniqueidentifier, @provider bit) 
RETURNS VARCHAR(MAX) AS
BEGIN
	DECLARE @names VARCHAR(MAX)	
	
	IF @provider <> 0
		SELECT	@names = CASE WHEN @names IS NULL THEN '''' ELSE @names + '';'' END + 
				dbo.UDF_GetFormattedInternalName(p.FirstName, p.MiddleName, p.LastName, p.AkaFirstName, p.AkaLastName)
		FROM	PatientCareManagement pcm INNER JOIN ViewProvider p ON pcm.ProviderUid = p.PersonUid
		WHERE	pcm.PatientCareManagementUid = @PatientCareManagementUid	
	ELSE	
		SELECT	@names = CASE WHEN @names IS NULL THEN '''' ELSE @names + '';'' END + dbo.GetDiagnosisCodeAndName(rel.Code9, rel.Code10, rel.CodeDescription)
		FROM	RelPatientCareManagementDiagnosis rel
		WHERE	rel.PatientCareManagementUid = @PatientCareManagementUid
		
	RETURN @names
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetPatientCondition]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[GetPatientCondition](@PersonUid uniqueidentifier) RETURNS VARCHAR(MAX) AS
BEGIN
	-- Retrieves all associated patient conditions for a patient. Conditions are delimited by '';'' and is returned as a string.
	IF @PersonUid IS NULL
		RETURN NULL
		
	DECLARE @conditions VARCHAR(MAX)
	
	DECLARE @cur CURSOR;
	DECLARE @PatientConditionUid uniqueidentifier;
	DECLARE @conditionName VARCHAR(255);	
	DECLARE @rowCnt int;	
	DECLARE @cnt int;

	BEGIN
		SET @conditions = NULL;
		Set @rowCnt = 1;

		--determine how many rows will be processed		
		SELECT @cnt = COUNT(*) FROM RelPatientCondition WHERE PatientUid = @PersonUid
	
		SET @cur = CURSOR FOR
		SELECT PatientConditionUid FROM RelPatientCondition WHERE PatientUid = @PersonUid ORDER BY DisplayOrder ASC

		OPEN @cur 
		FETCH NEXT FROM @cur 
		INTO @PatientConditionUid
		
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SELECT @conditionName = Name FROM ListPatientCondition lpc WHERE lpc.PatientConditionUid = @PatientConditionUid
			IF(LEN(@conditionName) > 0)
			BEGIN
				IF (@conditions IS NOT NULL)
					Set @conditions = @conditions + @conditionName
				ELSE
					Set @conditions = @conditionName

				IF(@rowCnt < @cnt)
					Set @conditions = @conditions + ''; ''

				Set @rowCnt = @rowCnt + 1					
			END
			FETCH NEXT FROM @cur 
			INTO @PatientConditionUid
		END; 

		CLOSE @cur ;
		DEALLOCATE @cur;
	END;
			
	RETURN @conditions
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getPatientDemographicsComment]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[getPatientDemographicsComment]
(
 @VisitUid VARCHAR(50),
 @PatientUid VARCHAR(50),
 @TrackingNum VARCHAR(50)  =null
)

RETURNS VARCHAR(MAX)
AS
BEGIN
	DECLARE @NOTES VARCHAR(MAX)
	SELECT TOP 1 @NOTES=NOTES
	FROM ObservationOrder 
	WHERE NOTES LIKE ''%<Patient Demographics Comment>%</Patient Demographics Comment>%'' 
	  AND VisitUid=@VisitUid 
	  AND PatientUid=@PatientUid 
	  AND (TrackingNum=@TrackingNum OR TrackingNum is null)
	  AND IsDelete = 0
	
	Declare @CidxStart int 
    Declare @CidxEnd int
    Set @CidxStart = charindex(''<Patient Demographics Comment>'',@NOTES,1)  
    Set @CidxEnd = charindex(''</Patient Demographics Comment>'',@NOTES,1)
    IF @CidxEnd >30 AND @CidxStart >0
		SELECT @NOTES=Substring(@NOTES, @CidxStart+30, @CidxEnd-@CidxStart-30) 
	ELSE
		SET @NOTES=''''	
	RETURN @NOTES
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getPatientDiastolic_Adult_Diabetes]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[getPatientDiastolic_Adult_Diabetes] -- Returns like 1:30 One and half an hour
(
	@VisitUid Uniqueidentifier
)
RETURNS DECIMAL(10,2)

BEGIN
	Declare @Diastolic DECIMAL(10,2)
	Select Top 1 @Diastolic=Metricvalue2 From ObservationValue Where Visituid=@VisitUid And ObservationItemuid=''00000000-0000-0000-7777-100000000073'' AND MetricValue2 IS NOT NULL AND IsVitals = 1
	Return @Diastolic
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getPatientLabResultsTable]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[getPatientLabResultsTable]
(
	 @PersonUid UNIQUEIDENTIFIER = NULL
	 ,@ObservationItem1Uid varchar(max)= NULL --Modified to use observation item instead of 
	 ,@ObservationItem1Range varchar(max)
	 ,@LogicOpr1 bit=0
	 ,@ObservationItem2Uid varchar(max) = NULL --Modified to use observation item instead of 
	 ,@ObservationItem2Range varchar(max) = NULL
	 ,@LogicOpr2 bit=0
	 ,@ObservationItem3Uid varchar(max) = NULL --Modified to use observation item instead of 
	 ,@ObservationItem3Range varchar(max) = NULL
 	 ,@LabResults_StartDate datetime = NULL
	 ,@LabResults_EndDate datetime = NULL 
	 ,@LaboratoryUid varchar(max) = NULL
)
RETURNS  --  VARCHAR(Max)
  @ReturnTable TABLE (
		ResultList varchar(MAX),
		ProviderList varchar(MAX)
  )
  AS
BEGIN
		DECLARE @LabResultList VARCHAR(Max) = ''N/A''
		DECLARE @ProviderResultList VARCHAR(Max) = ''N/A''

		IF @LaboratoryUid=''''
			SET @LaboratoryUid=NULL
		SET @LabResults_StartDate = ISNULL(@LabResults_StartDate , ''1-01-1997'')
		SET @LabResults_EndDate = ISNULL(@LabResults_EndDate, getdate()) 
	
		--SELECT @LabResults_StartDate = dbo.getPracticeUTCDateTime (@LabResults_StartDate)
		--SELECT @LabResults_EndDate =  DATEADD(DAY,1,dbo.getPracticeUTCDateTime(@LabResults_EndDate))
		
				
		DECLARE @ObservationItem1Start varchar(100)
		DECLARE @ObservationItem1End varchar(100)
		
		Set @ObservationItem1Start = ''0''
		Set @ObservationItem1End = ''999''
		
		If( @ObservationItem1Range IS NOT NULL AND LEN( @ObservationItem1Range) > 0 )
		BEGIN
			select @ObservationItem1Start = Element from Split(@ObservationItem1Range,''-'') where ElementID = 1
			select @ObservationItem1End = Element from Split(@ObservationItem1Range,''-'') where ElementID = 2
		END
		
		DECLARE @ObservationItem2Start varchar(100)
		DECLARE @ObservationItem2End varchar(100)
		
		Set @ObservationItem2Start = ''0''
		Set @ObservationItem2End = ''999''
		
		If( @ObservationItem2Range IS NOT NULL AND LEN(@ObservationItem2Range) > 0 )
		BEGIN
			select @ObservationItem2Start = Element from Split(@ObservationItem2Range,''-'') where ElementID = 1
			select @ObservationItem2End = Element from Split(@ObservationItem2Range,''-'') where ElementID = 2
		END
		
		DECLARE @ObservationItem3Start varchar(100)
		DECLARE @ObservationItem3End varchar(100)
		
		If( @ObservationItem3Range IS NOT NULL AND LEN( @ObservationItem3Range) > 0 )
		BEGIN
			select @ObservationItem3Start = Element from Split(@ObservationItem3Range,''-'') where ElementID = 1
			select @ObservationItem3End = Element from Split(@ObservationItem3Range,''-'') where ElementID = 2
		END
		

		--if (@ObservationItem1Uid != ''00000000-0000-0000-0000-000000000000'' 
		--	OR 
		--	@ObservationItem2Uid != ''00000000-0000-0000-0000-000000000000''
		--	OR
		--	@ObservationItem3Uid != ''00000000-0000-0000-0000-000000000000''
		--	)
		if (@ObservationItem1Uid IS NOT NULL  
			OR 
			@ObservationItem2Uid IS NOT NULL  
			OR
			@ObservationItem3Uid IS NOT NULL  
			)
		BEGIN
			--IF (@LogicOpr1 =0 AND @LogicOpr2 =0)
			--BEGIN
			DECLARE @Result TABLE  
			(
				Result VARCHAR(1000),
				OrderProviderUid VARCHAR(1000),
				ObservationItemUid UNIQUEIDENTIFIER
			)

			DECLARE @DisplayResult Bit
			SET @DisplayResult=0				
						INSERT INTO @Result 
						SELECT PL.LabResult,OrderProviderUid,PL.ObservationItemUid
						 FROM   [MDOL_RPT2_VIEW_PatientLabResultsWithProvider] PL 		
						 Where 
							PL.IsDelete = 0
				            AND
							@PersonUid = PL.PatientUid
							AND
							(
								(
								PL.ObservationItemUid  in (Select element from dbo.Split (@ObservationItem1Uid,'','')) 
								AND PL.NumericObservationValue>=@ObservationItem1Start
								AND PL.NumericObservationValue<=@ObservationItem1End
								)
								OR
								(
									PL.ObservationItemUid in (Select element from dbo.Split (@ObservationItem2Uid,'','')) 
									AND PL.NumericObservationValue>=@ObservationItem2Start
									AND PL.NumericObservationValue<=@ObservationItem2End
									
								)
								OR
								(
									PL.ObservationItemUid in (Select element from dbo.Split (@ObservationItem3Uid,'','')) 
									AND PL.NumericObservationValue>=@ObservationItem3Start
									AND PL.NumericObservationValue<=@ObservationItem3End
							
								)
							)					 
							AND					
							PL.ResultDate >= @LabResults_StartDate AND PL.ResultDate < @LabResults_EndDate
							AND
						(@LaboratoryUid IS NULL OR PL.LaboratoryUid in (Select Element from dbo.Split(@LaboratoryUid,'','')))
						 order by PL.ResultDate
						 						
						 --FOR XML PATH( '''' )
						 --), 2, 2500 ) )*/

			--	END	
			IF (@LogicOpr1 =1 AND @LogicOpr2 =1)
			BEGIN
				IF EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem1Uid,'',''))  
				OR @ObservationItem1Uid IS NULL) AND EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem2Uid,'',''))  
				OR @ObservationItem2Uid IS NULL) AND EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem3Uid,'',''))  
				OR @ObservationItem3Uid IS NULL)
					SET @DisplayResult=1
			END
			IF (@LogicOpr1 =1 AND @LogicOpr2 =0)
			BEGIN
				IF EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem1Uid,'',''))  
				OR @ObservationItem1Uid IS NULL) AND EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem2Uid,'',''))  
				OR @ObservationItem2Uid IS NULL) OR EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem3Uid,'',''))  
				OR @ObservationItem3Uid IS NULL)
					SET @DisplayResult=1
			END	
			IF (@LogicOpr1 =0 AND @LogicOpr2 =1)
			BEGIN
				IF EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem1Uid,'',''))  
				OR @ObservationItem1Uid IS NULL) OR EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem2Uid,'',''))  
				OR @ObservationItem2Uid IS NULL) AND EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem3Uid,'',''))  
				OR @ObservationItem3Uid IS NULL)
					SET @DisplayResult=1
			END			
			IF (@LogicOpr1 =0 AND @LogicOpr2 =0)
			BEGIN
				--IF EXISTS() OR EXISTS() OR EXISTS()
					SET @DisplayResult=1
			END		
			IF @DisplayResult=1 
			BEGIN
			insert into @ReturnTable
			 SELECT  distinct --Result as resultlist, 
		            STUFF((SELECT '','' + r.Result
                        FROM @Result r
                        WHERE r.OrderProviderUid = result.OrderProviderUid
                        FOR XML PATH('''') 
                        ), 1, 1, '''' )
		            AS resultList,
					OrderProviderUid as providerlist
			from @Result result
			END	
			ELSE
				BEGIN
				SET @LabResultList=NULL
				END 
		END
		ELSE
		BEGIN
		insert into @ReturnTable
		SELECT 	distinct
				(substring(
				(SELECT ( '';'' + loi.Name + '': '' + coalesce(nullif(Convert(VARCHAR(50),ISNULL(ov.ObservationValue,'''')),''''),''N/A'') + '' Resulted: '' + (Convert(VARCHAR(50),oo1.ResultDate,101)))
                 FROM    ObservationOrder oo1 
				 INNER JOIN ObservationValue    ov  ON ov.ObservationOrderUid = oo1.ObservationOrderUid 
				 INNER JOIN ListObservationItem loi ON loi.ObservationItemUid = ov.ObservationItemUid 
				 --INNER JOIN ListLOINC           ll  ON ll.LOINCUid            = loi.LOINCUid 
				 inner join Person				PR  ON PR.PersonUid			  = oo1.PatientUid			
				 where 
				    oo1.IsDelete = 0
				    AND
					@PersonUid = oo1.PatientUid				 
					AND					
					oo1.ResultDate >= @LabResults_StartDate AND oo1.ResultDate < @LabResults_EndDate
					AND
					(@LaboratoryUid IS NULL OR oo1.LaboratoryUid in (Select Element from dbo.Split(@LaboratoryUid,'','')))
					and oo.patientuid = oo1.PatientUid and oo.observationorderuid = oo1.ObservationOrderUid
				 order by oo1.ResultDate
				 FOR XML PATH( '''' )
				 ), 2, 2500 )) ,						 
--				 loi.Name + '': '' + coalesce(nullif(Convert(VARCHAR(50),ISNULL(ov.ObservationValue,'''')),''''),''N/A'') + '' Resulted: '' + (Convert(VARCHAR(50),oo.ResultDate,101)) as ResultList,
			    oo.OrderProviderUid as ProviderList
                 FROM    ObservationOrder oo 
				 INNER JOIN ObservationValue    ov  ON ov.ObservationOrderUid = oo.ObservationOrderUid 
				 INNER JOIN ListObservationItem loi ON loi.ObservationItemUid = ov.ObservationItemUid 
				 inner join Person				PR  ON PR.PersonUid			  = oo.PatientUid			
				 where 
				    oo.IsDelete = 0
				    AND
					@PersonUid = oo.PatientUid				 
					AND					
					oo.ResultDate >= @LabResults_StartDate AND oo.ResultDate < @LabResults_EndDate
					AND
					(@LaboratoryUid IS NULL OR oo.LaboratoryUid in (Select Element from dbo.Split(@LaboratoryUid,'','')))
				-- order by oo.ResultDate

		 END		
		
		RETURN
END







' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getPatientLabTestComment]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[getPatientLabTestComment](@Notes Varchar(Max))  RETURNS VARCHAR(MAX) 
AS 
BEGIN 
Declare @Cinx int  
  Set @Cinx = charindex(''<Patient Demographics Comment>'',@NOTES,1)  
 IF @Cinx <1 
 BEGIN
	SET @NOTES=@NOTES
  
 END
 ELSE IF @Cinx =1
 BEGIN 
	Set @Cinx = charindex(''</Patient Demographics Comment>'',@NOTES,1) 
	SELECT TOP 1 @NOTES=Substring(@NOTES, @Cinx+31,LEN(@NOTES)) 
 END
 ELSE
 BEGIN
		SELECT TOP 1 @NOTES=Substring(@NOTES, 1, @Cinx-1) 
 END  
	Return @Notes
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getPatientSystolic_Adult_Diabetes]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[getPatientSystolic_Adult_Diabetes] -- Returns like 1:30 One and half an hour
(
	@VisitUid Uniqueidentifier
)
RETURNS DECIMAL(10,2)

BEGIN
	
	Declare @Sytolic DECIMAL(10,2)
	Select Top 1 @Sytolic=Metricvalue1 From ObservationValue Where Visituid=@VisitUid And ObservationItemuid=''00000000-0000-0000-7777-100000000073'' AND MetricValue1 IS NOT NULL AND IsVitals = 1
	Return @Sytolic
END

' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetPEDefaultFlag]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetPEDefaultFlag](@defaultFlag [bit], @clinicCenterUid [uniqueidentifier], @providerUid [uniqueidentifier], @kdbClinicCenter [xml], @kdbProvider [xml])
RETURNS [bit] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[GetPEDefaultFlag]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetPhoneByType]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetPhoneByType](@phoneType varchar(100), @phone1 xml(CONTENT dbo.Phone) = NULL, @phone2 xml(CONTENT dbo.Phone) = NULL, @phone3 xml(CONTENT dbo.Phone) = NULL, @phone4 xml(CONTENT dbo.Phone) = NULL) RETURNS VARCHAR(100) AS	
BEGIN
	DECLARE @Phonenumber VARCHAR(50)
	
	IF @phone1.value(''(/Phone/PhoneType)[1]'', ''VARCHAR(100)'') = @phoneType OR ISNULL(@phoneType, '''') = ''''
		RETURN dbo.GetPhoneFormatted(@phone1)
	
	IF @phone2.value(''(/Phone/PhoneType)[1]'', ''VARCHAR(100)'') = @phoneType
		RETURN dbo.GetPhoneFormatted(@phone2)

	IF @phone3.value(''(/Phone/PhoneType)[1]'', ''VARCHAR(100)'') = @phoneType
		RETURN dbo.GetPhoneFormatted(@phone3)

	IF @phone4.value(''(/Phone/PhoneType)[1]'', ''VARCHAR(100)'') = @phoneType
		RETURN dbo.GetPhoneFormatted(@phone4)

	RETURN NULL
END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetPersonPhoneByType]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetPersonPhoneByType] (@PersonUid UNIQUEIDENTIFIER, @PhoneType VARCHAR(10)) RETURNS VARCHAR(25) AS  
BEGIN 

	DECLARE @Phone1 xml(CONTENT dbo.Phone)
	DECLARE @Phone2 xml(CONTENT dbo.Phone)
	DECLARE @Phone3 xml(CONTENT dbo.Phone)
	DECLARE @Phone4 xml(CONTENT dbo.Phone)

	SELECT	@Phone1 = Phone1,
			@Phone2 = Phone2,
			@Phone3 = Phone3,
			@Phone4 = Phone4
	FROM	Person
	WHERE	PersonUid = @PersonUid
	
	RETURN dbo.GetPhoneByType(@PhoneType, @Phone1, @Phone2, @Phone3, @Phone4)
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetPhoneAndType]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetPhoneAndType](@phone xml(CONTENT dbo.Phone)) RETURNS VARCHAR(255) AS
BEGIN
	IF @phone IS NULL
		RETURN NULL
		
	DECLARE @phonenumber VARCHAR(100)
	DECLARE @phonetype VARCHAR(100)
	DECLARE @pt VARCHAR(255)
	
	SET @phonenumber = @phone.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(100)'')
	SET @phonetype = @phone.value(''(/Phone/PhoneType)[1]'', ''VARCHAR(100)'')

	IF RTRIM(ISNULL(@phonenumber, '''')) = ''''
		RETURN NULL
		
	IF RTRIM(ISNULL(@phonetype, '''')) <> ''''
	BEGIN
		SET @pt = @phonetype + '': ''	
		SET @pt = @pt + dbo.GetPhoneFormatted(@phone)
	END
	ELSE
		SET @pt = dbo.GetPhoneFormatted(@phone)	
	
	RETURN @pt
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetPracticeLocalDateTime]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetPracticeLocalDateTime]
  (@inUtcSourceDateTime DATETIME)           -- should be a UTC datetime value
  RETURNS DATETIME AS
BEGIN
  DECLARE @inTimeZoneAdj           INT      -- the number of hours to adjust for the local timezone +/-
  DECLARE @bObserveDaylightSavings TINYINT  -- whether or not the local area observes US daylight savings time

  DECLARE @YEAR INT = datepart(Year,@inUtcSourceDateTime)

  DECLARE @DSTStart DateTime = CONVERT(CHAR(4),@YEAR) + ''-MAR-01 02:00''
  DECLARE @OffsetToSecondSunday INT = (8-datepart(dw,@DSTStart)) % 7 + 7 -- 2nd Sunday in March
  SET @DSTStart = DATEADD(DAY,@OffsetToSecondSunday,@DSTStart)

  DECLARE @DSTEnd   DateTime  = CONVERT(CHAR(4),@YEAR) + ''-NOV-01 02:00''
  DECLARE @OffsetToFirstSunday INT = ((8-datepart(dw,@DSTEnd)) % 7)      -- 1st Sunday in November
  SET @DSTEnd = DATEADD(DAY,@OffsetToFirstSunday,@DSTEnd)

  SELECT TOP 1
      @inTimeZoneAdj           = InTimeZoneAdj,
      @bObserveDaylightSavings = ObserveDaylightSavings
    FROM PracticeSettings

  DECLARE @LocalDateTime DATETIME = DATEADD(HOUR,@inTimeZoneAdj,@inUtcSourceDateTime)
  DECLARE @DSTUse INT = CASE WHEN (@bObserveDaylightSavings = 1) AND (@LocalDateTime BETWEEN @DSTStart AND @DSTEnd) THEN 1 ELSE 0 END

  RETURN DATEADD(HOUR,@DSTUse,@LocalDateTime)
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetPrescriptionFullName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetPrescriptionFullName](@MedicationSIGUid uniqueidentifier)
RETURNS varchar(8000)
AS
BEGIN
	DECLARE @String varchar(8000)
	Set @String = ''''
	SELECT @String = @String + CASE @String WHEN '''' THEN '''' ELSE '';  '' END + MedicationSIG.Name + ''; '' + 
		CASE coalesce(DosageQuantity, '''') WHEN '''' THEN '''' ELSE DosageQuantity + '' '' END + 
		CASE coalesce(DosageUnit, '''') WHEN '''' THEN '''' ELSE DosageUnit END + ''; '' + 
		CASE coalesce(MedicationSIG.Route, '''') WHEN '''' THEN '''' ELSE MedicationSIG.Route END + 
		CASE coalesce(Frequency, '''') WHEN '''' THEN '''' ELSE ''; '' + Frequency END + 
		CASE coalesce(Duration, 0) WHEN 0 THEN '''' ELSE ''; '' + cast(Duration as varchar(10)) + '' days'' END +
		CASE coalesce(Quantity, '''') WHEN '''' THEN '''' ELSE ''; Qty: '' + Quantity END +
		CASE coalesce(CONVERT(VARCHAR(50), ItemStartDate), '''') + coalesce(CONVERT(VARCHAR(50), ItemStopDate), '''') WHEN '''' THEN '''' ELSE
			''  ['' + CASE coalesce(ItemStartDate, ''1/1/1900'') WHEN ''1/1/1900'' THEN '''' ELSE convert(varchar(30), ItemStartDate, 101) END + '' - '' + 
			CASE coalesce(ItemStopDate, ''1/1/1900'') WHEN ''1/1/1900'' THEN '''' ELSE convert(varchar(30), ItemStopDate, 101) END + '']'' END
	FROM SIGDetail INNER JOIN MedicationSIG 
			ON SIGDetail.MedicationSIGUid = MedicationSIG.MedicationSIGUid
	WHERE SIGDetail.MedicationSIGUid = @MedicationSIGUid
	ORDER BY DisplayOrder
	RETURN @String
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetPrescriptionFullName_ActiveMedication]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetPrescriptionFullName_ActiveMedication](@MedicationSIGUid uniqueidentifier)
RETURNS varchar(8000)
AS
BEGIN
	DECLARE @String varchar(8000)
	Set @String = ''''
	SELECT @String = @String + CASE @String WHEN '''' THEN '''' ELSE '';  '' END + MedicationSIG.Name + ''; '' + 
		CASE coalesce(DosageQuantity, '''') WHEN '''' THEN '''' ELSE DosageQuantity + '' '' END + 
		CASE coalesce(DosageUnit, '''') WHEN '''' THEN '''' ELSE DosageUnit END + ''; '' + 
		CASE coalesce(MedicationSIG.Route, '''') WHEN '''' THEN '''' ELSE MedicationSIG.Route END + 
		CASE coalesce(Frequency, '''') WHEN '''' THEN '''' ELSE ''; '' + Frequency END + 
		CASE coalesce(Duration, 0) WHEN 0 THEN '''' ELSE ''; '' + cast(Duration as varchar(10)) + '' days'' END +
		CASE coalesce(Quantity, '''') WHEN '''' THEN '''' ELSE ''; Qty: '' + Quantity END +
		CASE coalesce(CONVERT(VARCHAR(50), ItemStartDate), '''') + coalesce(CONVERT(VARCHAR(50), ItemStopDate), '''') WHEN '''' THEN '''' ELSE
			''  ['' + CASE coalesce(ItemStartDate, ''1/1/1900'') WHEN ''1/1/1900'' THEN '''' ELSE convert(varchar(30), ItemStartDate, 101) END + '' - '' + 
			CASE coalesce(ItemStopDate, ''1/1/1900'') WHEN ''1/1/1900'' THEN '''' ELSE convert(varchar(30), ItemStopDate, 101) END + '']'' END
	FROM SIGDetail INNER JOIN MedicationSIG 
			ON SIGDetail.MedicationSIGUid = MedicationSIG.MedicationSIGUid
	WHERE 
		SIGDetail.MedicationSIGUid = @MedicationSIGUid
	AND
			(MedicationSIG.IsMaintenanceDrug = 1 
			OR SIGDetail.ItemStopDate IS NULL 
			OR NOT (SIGDetail.ItemStopDate < GETDATE()))
		AND 
			(MedicationSIG.IsMaintenanceDrug = 1 
			OR SIGDetail.ItemStartDate IS NULL 
			OR NOT (SIGDetail.ItemStartDate >  GETDATE()))
	ORDER BY DisplayOrder
	RETURN @String
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetPrimaryEthnicityUid]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =================================================================
-- Author:		CHM
-- Create date: 02/15/2017
-- Description:	Returns the primary Ethnicity uid for a patient. The 
--				primary Ethnicity is the first Ethnicity found by 
--				display order.
-- =================================================================
CREATE FUNCTION [dbo].[GetPrimaryEthnicityUid] 
(
	@personUid uniqueidentifier
)
RETURNS uniqueidentifier
AS
BEGIN
	declare @ethnicityUid uniqueidentifier

	select top 1 @ethnicityUid = EthnicityUid from RelPersonEthnicity where PersonUid = @personUid order by DisplayOrder

	return @ethnicityUid

END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetPrimaryRaceUid]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =================================================================
-- Author:		CHM
-- Create date: 02/07/2017
-- Description:	Returns the primary race uid for a patient.  The 
--				primary race is the first race found by display 
--				order.
-- =================================================================
CREATE FUNCTION [dbo].[GetPrimaryRaceUid] 
(
	@personUid uniqueidentifier
)
RETURNS uniqueidentifier
AS
BEGIN
	declare @raceUid uniqueidentifier

	select top 1 @raceUid = RaceUid from RelPersonRace where PersonUid = @personUid order by DisplayOrder

	return @raceUid

END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetProcedures]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetProcedures](@range varchar(4000)) RETURNS @results TABLE (ProcedureUid UNIQUEIDENTIFIER) AS 
	BEGIN
	
		SET @range = REPLACE(@range, '','', '';'')

		DECLARE @matches TABLE (	PartA varchar(100) NULL,
									PartB varchar(100) NULL
								)
								
		INSERT @matches(PartA)
		SELECT	LTRIM(RTRIM(Element))
		FROM	dbo.Split(@range, '';'')
		 
		UPDATE	m
		SET		PartA = LTRIM(RTRIM(SUBSTRING(PartA, 1, CHARINDEX(''-'', PartA) - 1))),
				PartB = LTRIM(RTRIM(SUBSTRING(PartA, CHARINDEX(''-'', PartA) + 1, LEN(PartA) - CHARINDEX(''-'', PartA))))
		FROM	@matches m
		WHERE	CHARINDEX(''-'', PartA) > 0
					 
		INSERT	@results
		SELECT	p.ProcedureUid
		FROM	ListProcedure p CROSS JOIN @matches m 
		WHERE	(p.Code = m.PartA AND m.PartB IS NULL) OR
				(p.Code >= m.PartA AND p.Code <= m.PartB)
		 
	RETURN
	END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetProcedureShortDescription]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetProcedureShortDescription]
	(@ProcedureUid UNIQUEIDENTIFIER)
RETURNS VARCHAR(MAX) AS  
BEGIN 
	DECLARE @Description varchar(MAX)

	DECLARE @UseLabPrefix int
	SELECT @UseLabPrefix = 1  --DEFAULT TO ''USE LAB PREFIX''

	SELECT TOP 1 @UseLabPrefix = isnull(BoolValue, 1) 
	FROM ListProductParameter 
	WHERE ParameterName = ''UseLabPrefixOnProcedures''

	IF @UseLabPrefix <> 0
	BEGIN
		SELECT @Description =  ISNULL(LEFT(tab.LabNames, LEN(tab.LabNames)-1) + '': '', '''') + prc.ShortDescription
		FROM ListProcedure prc
        OUTER APPLY (
           SELECT LEFT(lab.Name, 1) + '',''
		   FROM RelProcedureLaboratoryOrder rel
		   INNER JOIN ListLaboratoryOrder llo ON llo.LaboratoryOrderUid = rel.LaboratoryOrderUid
		   INNER JOIN ListLaboratory lab ON lab.LaboratoryUid = llo.LaboratoryUid
		   WHERE rel.ProcedureUid = prc.ProcedureUid
		   ORDER BY rel.DisplayOrder 
           FOR XML PATH(''''))  tab(LabNames) 
		WHERE prc.ProcedureUid = @ProcedureUid

	END
	ELSE
	BEGIN	-- DON''T USE LAB PREFIX, JUST RETURN REGULAR SHORT DESCRIPTION
		SELECT @Description = prc.ShortDescription
		FROM ListProcedure prc
		WHERE ProcedureUid = @ProcedureUid
	END

	RETURN Left(@Description, 50)
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetProviderNPI]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetProviderNPI](	@providerUid UNIQUEIDENTIFIER, @serviceSiteUid UNIQUEIDENTIFIER, @financialCenterUid UNIQUEIDENTIFIER	) RETURNS VARCHAR(25) AS
BEGIN
	-- Declare the return variable here
	DECLARE @npi VARCHAR(25)
	SELECT	@npi = cfv.Value
	FROM	ClaimFormatValue cfv
	WHERE	cfv.ProviderUid = @providerUid AND
			cfv.ClaimFormatValueTypeUid = ''CE282F4E-A866-49BA-9636-C4BA0439E907'' /* Provider NPI */ AND
			(@serviceSiteUid IS NULL OR cfv.ServiceSiteUid IS NULL OR @serviceSiteUid = cfv.ServiceSiteUid) AND
			(@financialCenterUid IS NULL OR cfv.FinancialCenterUid IS NULL OR @financialCenterUid = cfv.FinancialCenterUid)

	RETURN	@npi
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getRelativeFiscalMonthEnd]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[getRelativeFiscalMonthEnd]
(
	@dtCurrent DATETIME
)
RETURNS DATETIME
AS
BEGIN
	RETURN dbo.Date_RelativeFiscalMonthEnd(@dtCurrent)
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getRelativeFiscalYearEnd]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[getRelativeFiscalYearEnd]
(
	@dtCurrent datetime
)
RETURNS DATETIME
AS
BEGIN
	RETURN dbo.Date_RelativeFiscalYearEnd(@dtCurrent)
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getRelativeFiscalYearEnd_AS]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[getRelativeFiscalYearEnd_AS]
(
	@dtCurrent datetime
)
RETURNS DATETIME
AS
BEGIN
	RETURN dbo.Date_RelativeFiscalYearEnd(@dtCurrent)
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getRelativeFiscalYearEnd_RA]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[getRelativeFiscalYearEnd_RA]
(
	@dtCurrent datetime
)
RETURNS DATETIME
AS
BEGIN
	RETURN dbo.Date_RelativeFiscalYearEnd(@dtCurrent)
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetReplicationNames]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetReplicationNames](@cacheMachineUid uniqueidentifier, @provider bit) 
RETURNS VARCHAR(MAX) AS
BEGIN
	DECLARE @names VARCHAR(MAX)	
	
	IF @provider <> 0
		SELECT	@names = CASE WHEN @names IS NULL THEN '''' ELSE @names + '';'' END + 
				dbo.UDF_GetFormattedInternalName(p.FirstName, p.MiddleName, p.LastName, p.AkaFirstName, p.AkaLastName)
		FROM	RelCacheMachineProvider rel INNER JOIN ViewProvider p ON rel.ProviderUid = p.PersonUid
		WHERE	rel.CacheMachineUid = @cacheMachineUid
	ELSE	
		SELECT	@names = CASE WHEN @names IS NULL THEN '''' ELSE @names + '';'' END + u.LastName + '', '' + u.FirstName
		FROM	RelCacheMachineUserPRM rel INNER JOIN ViewFindUser u ON rel.UserPRMUid = u.PersonUid
		WHERE	rel.CacheMachineUid = @cacheMachineUid
		
	RETURN @names
END
' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetRosDenyFlag]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetRosDenyFlag](@denyFlag [bit], @clinicCenterUid [uniqueidentifier], @providerUid [uniqueidentifier], @kdbClinicCenter [xml], @kdbProvider [xml])
RETURNS [bit] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[GetRosDenyFlag]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getSuperbillAge]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




-- 20150924 kculberth incorporate performance improvements by utilizing StatementBatchDetailUid to narrow dataset and moving dunning logic to Header

CREATE FUNCTION [dbo].[getSuperbillAge]
	(@RPUid uniqueidentifier,
	@StatementBatchDetailUid uniqueidentifier)
RETURNS INT AS 
BEGIN

DECLARE @Age INT

;WITH cteSuperbillList as
(
	select superbilluid,AccountResponsiblePartyuid 
	from StatementBatchDetailSuperbill (NOLOCK) sbds
	inner join StatementBatchDetail sbd on sbd.StatementBatchDetailUid = sbds.StatementBatchDetailUid
	where sbds.StatementBatchDetailUid = @StatementBatchDetailUid
)
,cteAgeLiability as
(
	SELECT 
		cteSB.AccountResponsiblePartyUid,cteSB.SuperbillUid,LD.SuperbillProcedureUid, LD.LiabilityOwner,arb.gldate,       
            SUM(Amount) AS LiabilityAmount
      FROM  cteSuperbillList cteSB 
            --INNER JOIN Superbill (NOLOCK) SB ON SB.SuperbillUid = cteSB.SuperbillUid
            INNER JOIN SuperbillProcedure (NOLOCK) SBP ON cteSB.SuperbillUid = SBP.SuperbillUid
			INNER JOIN AR_LedgerDetail (NOLOCK)  LD on LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid       
            INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid  
			--INNER JOIN Account (NOLOCK) A ON A.AccountUid = SB.AccountUid
			INNER JOIN ARBatch (NOLOCK) ARB ON L.ArbatchUid = ARB.ArbatchUid 
			INNER JOIN ViewStatementSuperbillBalanceExcludeStatus vssb on vssb.superbilluid = cteSB.SuperbillUid			
      WHERE NOT LD.SuperbillProcedureUid IS NULL  
			AND LD.LiabilityOwner = 0 
			and cteSB.AccountResponsiblePartyUid = @rpuid
      GROUP BY cteSB.AccountResponsiblePartyUid,LD.SuperbillProcedureUid,cteSB.SuperbillUid,LD.LiabilityOwner,ARB.GLDate
	  HAVING SUM(Amount) <> 0  	  
),
cteAge as 
(
	  SELECT 
	  cteSB.AccountResponsiblePartyUid,--SB.ExternalID,
	  LD.SuperbillProcedureUid,
	  arb.gldate,DATEDIFF(d, ARB.GLDate,GetDate()) as AgingDays
      FROM cteSuperbillList cteSB 
			--INNER JOIN Superbill (NOLOCK) SB ON SB.SuperbillUid = cteSB.SuperbillUid
            INNER JOIN SuperbillProcedure (NOLOCK) SBP ON cteSB.SuperbillUid = SBP.SuperbillUid
			INNER JOIN AR_LedgerDetail (NOLOCK)  LD on LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid       
            INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid  
			--INNER JOIN Account (NOLOCK) A ON A.AccountUid = SB.AccountUid
			INNER JOIN ARBatch (NOLOCK) ARB ON L.ArbatchUid = ARB.ArbatchUid 
			INNER JOIN ViewStatementSuperbillBalanceExcludeStatus vssb on vssb.superbilluid = cteSB.SuperbillUid	
      WHERE NOT LD.SuperbillProcedureUid IS NULL  
			AND LD.LiabilityOwner = 0 	
			AND Patient <> 0
			and cteSB.AccountResponsiblePartyUid = @rpuid						
	  group by cteSB.AccountResponsiblePartyUid,ARB.GLDate,--SB.ExternalID,
	  LD.SuperbillProcedureUid
)

, cte as
(
	select
	ROW_NUMBER() OVER(partition by cte.AccountResponsiblePartyUid order by Max(agingDays) desc ) AS Row,
	cte.accountresponsiblepartyuid,cte.superbillprocedureuid,liabilityamount
	,Max(agingDays) as age	
	FROM cteAgeLiability cte
	inner join cteAge age on age.superbillprocedureuid = cte.superbillprocedureuid and age.gldate = cte.gldate
    group by cte.accountresponsiblepartyuid,cte.superbillprocedureuid,cte.gldate,liabilityamount
)
, cteRunningTotal as
(
	SELECT x.accountresponsiblepartyuid,x.row,x.age, sum(y.liabilityamount) as runningtotal  
	FROM cte X, cte y 
	where y.row <= x.row and x.accountresponsiblepartyuid = y.accountresponsiblepartyuid
	group by x.accountresponsiblepartyuid,x.row,x.age
)
,ctePositiveLiability as
(
	select accountresponsiblepartyuid,row,age,runningtotal,
	ROW_NUMBER() OVER(partition by cteRunningTotal.AccountResponsiblePartyUid order by row asc ) AS Row2
	from cteRunningTotal
	where runningtotal >= 0
)
, cteFinalAge as
(
 select top (1) age from ctePositiveLiability
 where accountresponsiblepartyuid = @RPUid
 and ((runningtotal > 0 and row2 = (select top(1) row2 from ctePositiveLiability where RunningTotal = 0  and accountresponsiblepartyuid = @RPuid order by row desc) + 1) or row2 = 1)
 order by row desc
)


 SELECT @Age = age from cteFinalAge
 
 RETURN @Age

END






' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getStatementDunningMsg]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- 20150924 kculberth incorporate performance improvements by utilizing StatementBatchDetailUid to narrow dataset and moving dunning logic to Header

CREATE FUNCTION [dbo].[getStatementDunningMsg]
	(@RPUid uniqueidentifier,
	 @StatementBatchDetailUid uniqueidentifier)
RETURNS varchar(300) AS 
BEGIN

DECLARE @DunningMsg VARCHAR(300)
DECLARE @Age INT 

select @Age = dbo.getSuperbillAge(@RPUid,@StatementBatchDetailUid)

	select @DunningMsg = (CASE WHEN @Age <=30 AND LEN(Dn.DunningMsg1) >0 THEN ''0-30 Days: ''+ Dn.DunningMsg1
	WHEN @Age >=31 AND @Age <=60  AND LEN(Dn.DunningMsg2) >0 THEN ''31-60 Days: ''+ Dn.DunningMsg2
	WHEN @Age >=61 AND @Age <=90 AND LEN(Dn.DunningMsg3) >0 THEN ''61-90 Days: ''+ Dn.DunningMsg3
	WHEN @Age >=91 AND @Age <=120 AND LEN(Dn.DunningMsg4) >0 THEN ''91-120 Days: ''+ Dn.DunningMsg4
	WHEN @Age >=121 AND LEN(Dn.DunningMsg5) >0 THEN ''121 + Days: ''+ Dn.DunningMsg5
	ELSE ''''
	END) 
	FROM  PracticeSettings ps (nolock) 
	INNER JOIN DunningMsgs Dn (nolock) ON ps.DunningMsgsUid=Dn.DunningMsgsUid
RETURN @DunningMsg

END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getSuperbillAge_MainAccount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'





CREATE FUNCTION [dbo].[getSuperbillAge_MainAccount]
	(@RPUid uniqueidentifier)
RETURNS INT AS 
BEGIN

DECLARE @Age INT

;WITH cteAgeLiability as
(
	SELECT 
		A.AccountResponsiblePartyUid,SB.SuperbillUid,LD.SuperbillProcedureUid, LD.LiabilityOwner,arb.gldate,       
            SUM(Amount) AS LiabilityAmount--,DATEDIFF(d, ARB.GLDate,GetDate()) as AgingDays
      FROM AR_LedgerDetail (NOLOCK)  LD        
            INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid  
            INNER JOIN SuperbillProcedure (NOLOCK) SBP ON LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid
            INNER JOIN Superbill (NOLOCK) SB ON SB.SuperbillUid = SBP.SuperbillUid
			INNER JOIN Account (NOLOCK) A ON A.AccountUid = SB.AccountUid
			INNER JOIN ARBatch (NOLOCK) ARB ON L.ArbatchUid = ARB.ArbatchUid 
			INNER JOIN ViewStatementSuperbillBalanceExcludeStatus vssb on vssb.superbilluid = sb.SuperbillUid			
      WHERE NOT LD.SuperbillProcedureUid IS NULL  
			AND LD.LiabilityOwner = 0 
			and a.AccountResponsiblePartyUid = @rpuid
			and A.ISMAIN = 1
      GROUP BY A.AccountResponsiblePartyUid,LD.SuperbillProcedureUid,SB.SuperbillUid,LD.LiabilityOwner,ARB.GLDate
	  HAVING SUM(Amount) <> 0  	  
),
cteAge as 
(
	  SELECT 
	--ROW_NUMBER() OVER(partition by a.AccountResponsiblePartyUid order by DATEDIFF(d, ARB.GLDate,GetDate()) desc ) AS Row,
	  A.AccountResponsiblePartyUid,SB.ExternalID,LD.SuperbillProcedureUid,
	  arb.gldate,DATEDIFF(d, ARB.GLDate,GetDate()) as AgingDays
      FROM AR_LedgerDetail (NOLOCK)  LD        
            INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid  
            INNER JOIN SuperbillProcedure (NOLOCK) SBP ON LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid
            INNER JOIN Superbill (NOLOCK) SB ON SB.SuperbillUid = SBP.SuperbillUid
			INNER JOIN ARBatch (NOLOCK) ARB ON L.ArbatchUid = ARB.ArbatchUid 
			INNER JOIN Account (NOLOCK) A ON A.AccountUid = SB.AccountUid
			INNER JOIN ViewStatementSuperbillBalanceExcludeStatus vssb on vssb.superbilluid = sb.SuperbillUid
      WHERE NOT LD.SuperbillProcedureUid IS NULL  
			AND LD.LiabilityOwner = 0 	
			AND Patient <> 0
			and a.AccountResponsiblePartyUid = @rpuid
			AND A.IsMain = 1						
	  group by a.AccountResponsiblePartyUid,ARB.GLDate,SB.ExternalID,LD.SuperbillProcedureUid
)

, cte as
(
	select
	ROW_NUMBER() OVER(partition by cte.AccountResponsiblePartyUid order by Max(agingDays) desc ) AS Row,
	cte.accountresponsiblepartyuid,cte.superbillprocedureuid,liabilityamount--,agingDays,cte.gldate--,LiabilityAmount--
	,Max(agingDays) as age	
	FROM cteAgeLiability cte
	inner join cteAge age on age.superbillprocedureuid = cte.superbillprocedureuid and age.gldate = cte.gldate
	inner join ViewStatementSuperbillBalanceExcludeStatus vssb on vssb.SuperbillUid = cte.SuperbillUid
    group by cte.accountresponsiblepartyuid,cte.superbillprocedureuid,cte.gldate,liabilityamount
)
, cteRunningTotal as
(
	SELECT x.accountresponsiblepartyuid,x.row,x.age, sum(y.liabilityamount) as runningtotal  
	FROM cte X, cte y 
	where y.row <= x.row and x.accountresponsiblepartyuid = y.accountresponsiblepartyuid
	group by x.accountresponsiblepartyuid,x.row,x.age
)
,ctePositiveLiability as
(
	select accountresponsiblepartyuid,row,age,runningtotal,
	ROW_NUMBER() OVER(partition by cteRunningTotal.AccountResponsiblePartyUid order by row asc ) AS Row2
	from cteRunningTotal
	where runningtotal >= 0
)
, cteFinalAge as
(
 select top (1) age from ctePositiveLiability
 where accountresponsiblepartyuid = @RPUid
 and ((runningtotal > 0 and row2 = (select top(1) row2 from ctePositiveLiability where RunningTotal = 0  and accountresponsiblepartyuid = @RPuid order by row desc) + 1) or row2 = 1)
 order by row desc
)


 --SELECT @Age = age from cteRunningTotal
 --where accountresponsiblepartyuid = @RPUid
 --and ((runningtotal > 0 and row > (select row from cteRunningTotal where RunningTotal = 0  and accountresponsiblepartyuid = @RPuid)) or row = 1)
 --order by row desc
 
 SELECT @Age = age from cteFinalAge
 
 RETURN @Age

END






' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getStatementDunningMsg_MainAccount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[getStatementDunningMsg_MainAccount]
	(@RPUid uniqueidentifier)
RETURNS varchar(300) AS 
BEGIN

DECLARE @DunningMsg VARCHAR(300)
DECLARE @Age INT 

select @Age = dbo.getSuperbillAge_MainAccount(@RPUid)

	select @DunningMsg = (CASE WHEN @Age <=30 AND LEN(Dn.DunningMsg1) >0 THEN ''0-30 Days: ''+ Dn.DunningMsg1
	WHEN @Age >=31 AND @Age <=60  AND LEN(Dn.DunningMsg2) >0 THEN ''31-60 Days: ''+ Dn.DunningMsg2
	WHEN @Age >=61 AND @Age <=90 AND LEN(Dn.DunningMsg3) >0 THEN ''61-90 Days: ''+ Dn.DunningMsg3
	WHEN @Age >=91 AND @Age <=120 AND LEN(Dn.DunningMsg4) >0 THEN ''91-120 Days: ''+ Dn.DunningMsg4
	WHEN @Age >=121 AND LEN(Dn.DunningMsg5) >0 THEN ''121 + Days: ''+ Dn.DunningMsg5
	ELSE ''''
	END) 
	FROM  PracticeSettings ps (nolock) 
	LEFT JOIN DunningMsgs Dn (nolock) ON ps.DunningMsgsUid=Dn.DunningMsgsUid
RETURN @DunningMsg

END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getSuperbillAgeByFinancialCenter]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

-- 20160503 kc add missing WITH (NOLOCK) 


-- 20150427 kc added "and vssb.FinancialCenterUid = @FCUid" and also added 
--				ViewStatementSuperbillBalanceByFinancialCenterExcludeStatus to cteAgeLiability
--				This seems to improve performance dramatically.
-- 20150605 kc added "and vssb.Patient > 0" to cteAgeLiability to only look at the superbills with patient balance to improve performance.
-- 20160505 kc combined FC and practice aging logic to improve performance dramatically bug 49049

CREATE FUNCTION [dbo].[getSuperbillAgeByFinancialCenter]
	( @RPUid uniqueidentifier,
	@FinancialCenterUid uniqueidentifier)
RETURNS INT AS 
BEGIN
--set @RPUid=''9c3a58bb-a670-469e-b551-2858d2e6bf32''
--set @FinancialCenterUid=''22a79d00-6f81-4301-8470-ffcafc3b3d6d''

DECLARE @Age INT
DECLARE @FCUid uniqueidentifier

SET @FCUid = @FinancialCenterUid
--(select FinancialCenterUid from StatementBatchDetail where StatementBatchDetailUid = @StatementBatchDetailUid)
;WITH cteStatementBatchDetailList as
(
	select top 1 StatementBatchDetailUid from StatementBatchDetail
	where AccountResponsiblePartyUid = @RPUid and FinancialCenterUid = @FinancialCenterUid
	order by LastModifiedDate desc
)
, cteSuperbillList as
(
	select superbilluid,AccountResponsiblePartyuid,FinancialCenterUid 
	from StatementBatchDetailSuperbill (NOLOCK) sbds
	inner join StatementBatchDetail (NOLOCK) sbd on sbd.StatementBatchDetailUid = sbds.StatementBatchDetailUid
	inner join cteStatementBatchDetailList cte on cte.StatementBatchDetailUid = sbd.StatementBatchDetailUid
	where PatientBalance > 0
)
,cteAgeLiability as
(
	SELECT 
		cteSB.AccountResponsiblePartyUid,cteSB.SuperbillUid,LD.SuperbillProcedureUid, LD.LiabilityOwner,arb.gldate,       
            SUM(Amount) AS LiabilityAmount
      FROM  cteSuperbillList cteSB 
            INNER JOIN SuperbillProcedure (NOLOCK) SBP ON cteSB.SuperbillUid = SBP.SuperbillUid
			INNER JOIN AR_LedgerDetail (NOLOCK)  LD on LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid       
            INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid  
			INNER JOIN ARBatch (NOLOCK) ARB ON L.ArbatchUid = ARB.ArbatchUid 
     WHERE NOT LD.SuperbillProcedureUid IS NULL  
			AND LD.LiabilityOwner = 0 
			and cteSB.AccountResponsiblePartyUid = @rpuid
      GROUP BY cteSB.AccountResponsiblePartyUid,LD.SuperbillProcedureUid,cteSB.SuperbillUid,LD.LiabilityOwner,ARB.GLDate
	  HAVING SUM(Amount) <> 0  	  
),
cteAge as 
(
	  SELECT 
	  cteSB.AccountResponsiblePartyUid,
	  LD.SuperbillProcedureUid,
	  arb.gldate,DATEDIFF(d, ARB.GLDate,GetDate()) as AgingDays
      FROM cteSuperbillList cteSB 
            INNER JOIN SuperbillProcedure (NOLOCK) SBP ON cteSB.SuperbillUid = SBP.SuperbillUid
			INNER JOIN AR_LedgerDetail (NOLOCK)  LD on LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid       
            INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid  
			INNER JOIN ARBatch (NOLOCK) ARB ON L.ArbatchUid = ARB.ArbatchUid 
      WHERE NOT LD.SuperbillProcedureUid IS NULL  
			AND LD.LiabilityOwner = 0 	
			and cteSB.AccountResponsiblePartyUid = @rpuid						
	  group by cteSB.AccountResponsiblePartyUid,ARB.GLDate,--SB.ExternalID,
	  LD.SuperbillProcedureUid
)

, cte as
(
	select
	ROW_NUMBER() OVER(partition by cte.AccountResponsiblePartyUid order by Max(agingDays) desc ) AS Row,
	cte.accountresponsiblepartyuid,cte.superbillprocedureuid,liabilityamount
	,Max(agingDays) as age	
	FROM cteAgeLiability cte
	inner join cteAge age on age.superbillprocedureuid = cte.superbillprocedureuid and age.gldate = cte.gldate
    group by cte.accountresponsiblepartyuid,cte.superbillprocedureuid,cte.gldate,liabilityamount
)
, cteRunningTotal as
(
	SELECT x.accountresponsiblepartyuid,x.row,x.age, sum(y.liabilityamount) as runningtotal  
	FROM cte X, cte y 
	where y.row <= x.row and x.accountresponsiblepartyuid = y.accountresponsiblepartyuid
	group by x.accountresponsiblepartyuid,x.row,x.age
)
,ctePositiveLiability as
(
	select accountresponsiblepartyuid,row,age,runningtotal,
	ROW_NUMBER() OVER(partition by cteRunningTotal.AccountResponsiblePartyUid order by row asc ) AS Row2
	from cteRunningTotal
	where runningtotal >= 0
)
, cteFinalAge as
(
 select top (1) age from ctePositiveLiability
 where accountresponsiblepartyuid = @RPUid
 and ((runningtotal > 0 and row2 = (select top(1) row2 from ctePositiveLiability where RunningTotal = 0  and accountresponsiblepartyuid = @RPuid order by row desc) + 1) or row2 = 1)
 order by row desc
)


 SELECT @Age = age from cteFinalAge
 
RETURN @Age

END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getStatementDunningMsgByFinancialCenter]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- 20160505 kculberth bug 49049 pass @RPUid and @FinancialCenterUid to getSuperbillAgeByFinancialCenter

CREATE FUNCTION [dbo].[getStatementDunningMsgByFinancialCenter]
 (@RPUid uniqueidentifier,
  @FinancialCenterUid uniqueidentifier)
RETURNS varchar(300) AS 
BEGIN

--set @RPUid=''9c3a58bb-a670-469e-b551-2858d2e6bf32''
--set @StatementBatchDetailUid=''7B31785A-A801-4E5E-B0C4-3BCB568CA0BE''

DECLARE @DunningMsg VARCHAR(300)
DECLARE @Age INT 

select @Age = dbo.getSuperbillAgeByFinancialCenter(@RPUid,@FinancialCenterUid)
--print @age

	select @DunningMsg = (CASE WHEN @Age <=30 AND LEN(Dn.DunningMsg1) >0 THEN ''0-30 Days: ''+ Dn.DunningMsg1
	WHEN @Age >=31 AND @Age <=60  AND LEN(Dn.DunningMsg2) >0 THEN ''31-60 Days: ''+ Dn.DunningMsg2
	WHEN @Age >=61 AND @Age <=90 AND LEN(Dn.DunningMsg3) >0 THEN ''61-90 Days: ''+ Dn.DunningMsg3
	WHEN @Age >=91 AND @Age <=120 AND LEN(Dn.DunningMsg4) >0 THEN ''91-120 Days: ''+ Dn.DunningMsg4
	WHEN @Age >=121 AND LEN(Dn.DunningMsg5) >0 THEN ''121 + Days: ''+ Dn.DunningMsg5
	ELSE ''''
	END) 
	FROM  FinancialCenter fc (nolock) 
	INNER JOIN StatementBatchDetail sbd WITH (NOLOCK) on sbd.FinancialCenterUid = fc.FinancialCenterUid
	LEFT JOIN DunningMsgs Dn (nolock) ON fc.DunningMsgsUid=Dn.DunningMsgsUid
	where fc.FinancialCenterUid = @FinancialCenterUid
	--where sbd.StatementBatchDetailUid = @StatementBatchDetailUid 
RETURN  @DunningMsg

END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetSuperbillBalanceAll]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[GetSuperbillBalanceAll]
(
	@superbillUid uniqueidentifier
)
RETURNS
	money
AS
BEGIN
	DECLARE	@superbillBalance money
	SELECT @superbillBalance = LiabilityBalance - AssignedLiabilityBalance
		FROM AR_ViewSuperbillAggregate
		WHERE SuperbillUid = @superbillUid
	 RETURN ISNULL(@superbillBalance, 0)
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetSuperbillClaimingProviderSignatureUid]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetSuperbillClaimingProviderSignatureUid]
	(@superbillUid UNIQUEIDENTIFIER) 
RETURNS UNIQUEIDENTIFIER AS
BEGIN
	-- Pulls the appropriate signature record for a superbill
	-- can not return an image in function so just return the record id
	
	DECLARE @claimingProviderUid UNIQUEIDENTIFIER
	DECLARE @superbillServiceDateStart DATETIME
	DECLARE @superbillServiceDateEnd DATETIME
	DECLARE @retVal UNIQUEIDENTIFIER

	IF EXISTS(SELECT SuperbillUid FROM Superbill WHERE SuperbillUid = @superbillUid) -- if superbill exists
	BEGIN
		-- get superbill service start and end dates along with claiming provider
		SELECT @claimingProviderUid = VSFD.ClaimingProviderUid, @superbillServiceDateStart = SB.ServiceDateStart, 
				@superbillServiceDateEnd = SB.ServiceDateEnd
			FROM Superbill SB INNER JOIN ViewSuperbillFinancialDetails VSFD ON SB.SuperbillUid = VSFD.SuperbillUid
			WHERE SB.SuperbillUid = @superbillUid  
		-- get signature record based upon most current in service range
		SELECT @RETVAL = PS.ProviderSignatureUid 
			FROM (SELECT TOP 1 ProviderSignatureUid FROM ProviderSignature
				WHERE DATEPART(yyyy,LastModifiedDate) = DATEPART(yyyy,@superbillServiceDateStart) 
					AND  DATEPART(dy,LastModifiedDate) = DATEPART(dy,@superbillServiceDateStart) 
					AND ProviderUid = @claimingProviderUid ) PS
		-- if nothing in service range
		IF (@RETVAL IS NULL)
			-- get most current signature record by default
			SELECT @RETVAL = PS.ProviderSignatureUid 
				FROM (SELECT TOP 1 ProviderSignatureUid FROM ProviderSignature
					WHERE ProviderUid = @claimingProviderUid ) PS
	END

	RETURN @retVal
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetSuperbillCurrentInsurancePlan]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetSuperbillCurrentInsurancePlan]
(
	@superbillUid uniqueidentifier
)
RETURNS
	uniqueidentifier
AS
BEGIN
    DECLARE @insurancePlanUid uniqueidentifier
	SELECT  @insurancePlanUid = CurrentInsurancePlanUid
	FROM	SuperbillAggregate
	WHERE	SuperbillUid = @superbillUid
    RETURN @insurancePlanUid
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getSuperbillOfResponsibleParty]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE FUNCTION [dbo].[getSuperbillOfResponsibleParty] 
(@RPUid UNIQUEIDENTIFIER)  
RETURNS Varchar(1000) AS  
BEGIN 
	DECLARE 	@SBid 		VARCHAR(MAX)
	
---*OLD*vvv*OLD*vvv*OLD*vvv*OLD*vvv*OLD*vvv*OLD*vvv*OLD*vvv*OLD*vvv*OLD*vvv*OLD*vvv*OLD*vvv*OLD*vvv*OLD*vvv*OLD*vvv
	
----DECLARE 	@Cnt 		BIT
----	DECLARE 	@temp 	VARCHAR(50)
----	DECLARE 	@SSDate		DATETIME
----	DECLARE @InsuranceBalanceOnly BIT
----	DECLARE @CompleteBatch BIT 
----SET QUOTED_IDENTIFIER ON

----SET @CompleteBatch = 0

----	SELECT TOP 1 @InsuranceBalanceOnly=InsuranceBalanceOnlySuperbills FROM PracticeSettings
----	SET @Cnt = 0

----	DECLARE Cur_RPSuperBills Cursor FOR
----	SELECT DISTINCT S.ExternalID, S.ServiceDateStart 
----	FROM
----		Superbill S
----	INNER JOIN
----		Account A
----	ON
----		S.AccountUid = A.AccountUid
----	LEFT JOIN 
----		ViewStatementSuperbillBalance VS WITH (NOEXPAND)
----	ON 
----		VS.RPUid = @RPUid and VS.SuperbillUid = S.SuperbillUid	
----	WHERE 
----		A.AccountResponsiblePartyUid = @RPUid
----	AND	VS.LiabilityBalance <> 0
----	AND ((SELECT TOP 1 InsuranceBalanceOnlySuperbills FROM PracticeSettings)=1 
----		OR 
----         (VS.Patient is not null and VS.Patient!=0)
----		)
----	ORDER BY S.ServiceDateStart DESC		

----	OPEN Cur_RPSuperBills
----	FETCH NEXT FROM Cur_RPSuperBills INTO @temp, @SSDate

----	WHILE @@FETCH_STATUS = 0
----	BEGIN
----		SET @SBid = CASE  
----			WHEN @Cnt = 0 THEN @temp
----			WHEN @Cnt = 1 THEN @SBid + '', ''+@temp
----		END
----		FETCH NEXT FROM Cur_RPSuperBills INTO @temp, @SSDate
----	SET 	@Cnt = 1
----	END

----	CLOSE Cur_RPSuperBills
----	DEALLOCATE Cur_RPSuperBills

----	Return @SBid
----END
---*OLD*^^^*OLD*^^^*OLD*^^^*OLD*^^^*OLD*^^^*OLD*^^^*OLD*^^^*OLD*^^^*OLD*^^^*OLD*^^^*OLD*^^^*OLD*^^^*OLD*^^^*OLD*^^^


---*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv

	SET @SBid = (
	SELECT distinct
    --A.accountresponsiblepartyuid,
    STUFF
    (
        (	select
            '', '' + superbill.ExternalID
			FROM 		Superbill (NOLOCK)
			LEFT JOIN ViewStatementSuperbillBalanceExcludeStatus VS
			ON VS.SuperbillUid = Superbill.SuperbillUid	
			WHERE 
				VS.LiabilityBalance <> 0
				AND (
					(SELECT TOP 1 InsuranceBalanceOnlySuperbills FROM PracticeSettings (NOLOCK)) = 1
					OR 
					 (VS.Patient is not null and VS.Patient!=0)
					)	
				AND Superbill.SuperbillUid = vs.superbilluid
				AND VS.RPUid = @RPUid	    	
            ORDER BY Superbill.ServiceDateStart DESC	
            FOR XML PATH('''')
        ), 1, 1, ''''
    ) AS Superbills
	FROM Account (NOLOCK) A 
	WHERE A.AccountResponsiblePartyUid = @RPUID)
	
	RETURN @SBID
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getSuperbillOfResponsibleParty_MainAccount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

--10/14/2014 - kculberth - updated logic to match regular statements by practice

CREATE FUNCTION [dbo].[getSuperbillOfResponsibleParty_MainAccount] 
(@RPUid UNIQUEIDENTIFIER)  
RETURNS Varchar(1000) AS  
BEGIN 
	DECLARE 	@SBid 		VARCHAR(MAX)
	

	SET @SBid = (
	SELECT distinct
    --A.accountresponsiblepartyuid,
    STUFF
    (
        (	select
            '', '' + Superbill.ExternalID
			FROM Superbill (NOLOCK)
			LEFT JOIN ViewStatementSuperbillBalanceExcludeStatus VS
			ON VS.SuperbillUid = Superbill.SuperbillUid	
			inner join account (NOLOCK) acct on acct.accountuid = Superbill.AccountUid
			WHERE 
				VS.LiabilityBalance <> 0
				AND (
					(SELECT TOP 1 InsuranceBalanceOnlySuperbills FROM PracticeSettings (NOLOCK)) = 1
					OR 
					 (VS.Patient is not null and VS.Patient!=0)
					)	
				AND Superbill.SuperbillUid = vs.superbilluid
				AND VS.RPUid = @RPUid
				and acct.IsMain = 1  	    	
            ORDER BY Superbill.ServiceDateStart DESC	
            FOR XML PATH('''')
        ), 1, 1, ''''
    ) AS Superbills
	FROM Account (NOLOCK) A 
	--WHERE A.AccountResponsiblePartyUid = @RPUID
	--and A.IsMain = 1
	)
	
	RETURN @SBID
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getSuperbillOfResponsiblePartyByFinancialCenter]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'






CREATE FUNCTION [dbo].[getSuperbillOfResponsiblePartyByFinancialCenter]   
(@RPUid UNIQUEIDENTIFIER,  
 @FCUid UNIQUEIDENTIFIER,
 @StatementBatchDetailUid UNIQUEIDENTIFIER  
 )   
RETURNS Varchar(1000) AS  
BEGIN 
	DECLARE 	@SBid 		VARCHAR(MAX)

---*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv

	--;WITH cte_superbills as (
	--	--select sbds.SuperbillUid,sbd.accountresponsiblepartyuid,sbd.financialcenteruid,sbds.PatientBalance,sbds.InsuranceBalance,sb.ExternalID,sb.ServiceDateStart
	--	select sbds.SuperbillUid,sbd.accountresponsiblepartyuid,sbd.financialcenteruid,sbds.PatientBalance,sbds.InsuranceBalance
	--	from StatementBatchDetailSuperbill (NOLOCK) sbds 
	--	inner join StatementBatchDetail (NOLOCK) sbd on sbd.StatementBatchDetailUid = sbds.StatementBatchDetailUid
	--	--inner join Superbill (NOLOCK) sb on sb.SuperbillUid = sbds.SuperbillUid
	--	where sbds.StatementBatchDetailUid = @StatementBatchDetailUid
	--		and sbd.AccountResponsiblePartyUid = @RPUid
	--		and sbd.FinancialCenterUid = @FCUid
	--)
declare @insbalonly int
set @insbalonly = (SELECT TOP 1 InsuranceBalanceOnlySuperbills FROM FinancialCenter (NOLOCK) where FinancialCenter.FinancialCenterUid = @FCUid)
	SELECT @SBid = (
	SELECT distinct
    --A.accountresponsiblepartyuid,
    STUFF
    (
        (	select
            '', '' + sb.ExternalID
			from StatementBatchDetailSuperbill (NOLOCK) sbds 
			inner join StatementBatchDetail (NOLOCK) sbd on sbd.StatementBatchDetailUid = sbds.StatementBatchDetailUid
			INNER JOIN Superbill (NOLOCK) SB on sb.superbilluid = sbds.superbilluid
			--LEFT JOIN ViewStatementSuperbillBalanceByFinancialCenterExcludeStatus VS 
			--ON VS.SuperbillUid = Superbill.SuperbillUid	
			WHERE 
				sbds.PatientBalance+sbds.insurancebalance <> 0
				--VS.LiabilityBalance <> 0
				AND (
					(@insbalonly = 1
					OR 
						sbds.PatientBalance <> 0)
					 --(VS.Patient is not null and VS.Patient!=0)
					)	
				AND 
				sbds.StatementBatchDetailUid = @StatementBatchDetailUid
				--AND Superbill.SuperbillUid = vs.superbilluid
				AND sbd.AccountResponsiblePartyUid = @RPUid and sbd.FinancialCenterUid = @FCUid	    	
            ORDER BY sb.ServiceDateStart DESC	
            FOR XML PATH('''')
        ), 1, 1, ''''
    ) AS Superbills
	)
	--FROM Account (NOLOCK) A 
	--WHERE A.AccountResponsiblePartyUid = @RPUID)
	
	RETURN @SBID
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getSuperbillOfResponsiblePartyStatementBatch]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

-- 20150924 kculberth incorporate performance improvements by utilizing StatementBatchDetailUid to narrow dataset and moving dunning logic to Header

CREATE FUNCTION [dbo].[getSuperbillOfResponsiblePartyStatementBatch] 
(@RPUid UNIQUEIDENTIFIER, @StatementBatchDetailUid UNIQUEIDENTIFIER)  
RETURNS Varchar(1000) AS  
BEGIN 
	DECLARE 	@SBid 		VARCHAR(MAX)
	

	SET @SBid = (
	--SELECT distinct
    --A.accountresponsiblepartyuid,
    STUFF
    (
        (	select
            '', '' + superbill.ExternalID
			FROM StatementBatchDetailSuperbill (NOLOCK) sbds 
			INNER JOIN Superbill (NOLOCK) on sbds.superbilluid = superbill.superbilluid 
			--ViewStatementSuperbillBalanceExcludeStatus VS
			WHERE 
				sbds.PatientBalance+sbds.insurancebalance <> 0
				AND (
					(SELECT TOP 1 InsuranceBalanceOnlySuperbills FROM PracticeSettings (NOLOCK)) = 1
					OR 
					 --(sbds.PatientBalance is not null and sbds.PatientBalance!=0)
					 (sbds.PatientBalance <> 0)
					)	
				 --Superbill.SuperbillUid = vs.superbilluid
				AND 
				StatementBatchDetailUid = @StatementBatchDetailUid	    	
            ORDER BY Superbill.ServiceDateStart DESC	
            FOR XML PATH('''')
        ), 1, 1, ''''
    ) --AS Superbills
	--FROM Account (NOLOCK) A 
	--WHERE A.AccountResponsiblePartyUid = @RPUID
	)
	
	RETURN @SBID
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getSuperbillOfResposibleParty]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[getSuperbillOfResposibleParty] 
(@RPUid UNIQUEIDENTIFIER,
 @FCUid UNIQUEIDENTIFIER

	)  
RETURNS Varchar(1000) AS  
BEGIN 
	DECLARE 	@SBid 		VARCHAR(MAX)
	DECLARE 	@Cnt 		BIT
	DECLARE 	@temp 	VARCHAR(50)
	DECLARE 	@SSDate		DATETIME
	DECLARE @InsuranceBalanceOnly BIT
	DECLARE @CompleteBatch BIT 
SET QUOTED_IDENTIFIER ON

	IF @FCUid  IS NULL
			SELECT TOP 1 @InsuranceBalanceOnly=InsuranceBalanceOnlySuperbills FROM PracticeSettings
	ELSE
			SELECT TOP 1 @InsuranceBalanceOnly=InsuranceBalanceOnlySuperbills FROM FinancialCenter WHERE FinancialCenterUid=@FCUid

	IF @FCUid  IS NULL
			SELECT TOP 1 @CompleteBatch=IncludeCompletedOrClosed FROM PracticeSettings
	ELSE
			SELECT TOP 1 @CompleteBatch=IncludeCompletedOrClosed FROM FinancialCenter WHERE FinancialCenterUid=@FCUid

	SET @Cnt = 0

	DECLARE Cur_RPSuperBills Cursor FOR
	SELECT DISTINCT S.ExternalID, S.ServiceDateStart 
	FROM
		Superbill S
	INNER JOIN
		Account A
	ON
		S.AccountUid = A.AccountUid
	INNER JOIN
		[ViewSuperbillFinancialDetails] VSF
	ON 
		S.SuperbillUid=VSF.SuperbillUid
	LEFT JOIN 
		ViewStatementSuperbillBalance VS WITH (NOEXPAND)
	ON 
		VS.RPUid = @RPUid and VS.SuperbillUid = S.SuperbillUid	
	INNER JOIN 
		[AR_ViewSuperbillCompleteBatch] VSC
	ON
		VSF.SuperbillUid = VSC.SuperbillUid
	WHERE 
		A.AccountResponsiblePartyUid = @RPUid
	AND	VS.LiabilityBalance <> 0
	AND (@FCUid IS NULL OR VSF.FinancialCenterUid=@FCUid)
	AND (@InsuranceBalanceOnly=1 
		OR 
         (VS.Patient is not null and VS.Patient!=0)
		)
	AND
		(@CompleteBatch =0 OR VSC.CompleteBatch=1)
	ORDER BY S.ServiceDateStart DESC		


	OPEN Cur_RPSuperBills
	FETCH NEXT FROM Cur_RPSuperBills INTO @temp, @SSDate

	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @SBid = CASE  
			WHEN @Cnt = 0 THEN @temp
			WHEN @Cnt = 1 THEN @SBid + '', ''+@temp
		END
		FETCH NEXT FROM Cur_RPSuperBills INTO @temp, @SSDate
	SET 	@Cnt = 1
	END

	CLOSE Cur_RPSuperBills
	DEALLOCATE Cur_RPSuperBills

	Return @SBid
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getSuperbillOfResposibleParty_MainAccount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[getSuperbillOfResposibleParty_MainAccount] 
(@RPUid UNIQUEIDENTIFIER,
 @FCUid UNIQUEIDENTIFIER
	)  
RETURNS Varchar(1000) AS  
BEGIN 
	DECLARE 	@SBid 		VARCHAR(MAX)
	DECLARE 	@Cnt 		BIT
	DECLARE 	@temp 	VARCHAR(50)
	DECLARE 	@SSDate		DATETIME
	DECLARE @InsuranceBalanceOnly BIT
	DECLARE @CompleteBatch BIT 
SET QUOTED_IDENTIFIER ON
	IF @FCUid  IS NULL
			SELECT TOP 1 @InsuranceBalanceOnly=InsuranceBalanceOnlySuperbills FROM PracticeSettings
	ELSE
			SELECT TOP 1 @InsuranceBalanceOnly=InsuranceBalanceOnlySuperbills FROM FinancialCenter WHERE FinancialCenterUid=@FCUid
		
	IF @FCUid  IS NULL
			SELECT TOP 1 @CompleteBatch=IncludeCompletedOrClosed FROM PracticeSettings
	ELSE
			SELECT TOP 1 @CompleteBatch=IncludeCompletedOrClosed FROM FinancialCenter WHERE FinancialCenterUid=@FCUid

	SET @Cnt = 0

	DECLARE Cur_RPSuperBills Cursor FOR
	SELECT DISTINCT S.ExternalID, S.ServiceDateStart 
	--FROM Superbill
	--INNER JOIN ARContext ON Superbill.SuperbillUid = ARcontext.SuperbillUid
	--INNER JOIN Charge ON Charge.ARContextUid = ARContext.ARContextUid
	--INNER JOIN ViewARChargeAggregate vaca on Charge.ChargeUid = vaca.ChargeUid
	--INNER JOIN Account ON ARContext.AccountUid = Account.AccountUid
	--LEFT JOIN ViewStatementSuperbillBalance ON ViewStatementSuperbillBalance.RPUid = @RPUid and ViewStatementSuperbillBalance.SuperbillUid = Superbill.SuperbillUid
	FROM
		AR_Ledger L
	INNER JOIN
		AR_LedgerDetail LD
	ON
		L.LedgerUid=LD.LedgerUid AND L.EntryType=1 AND LD.IsCredit=0
	INNER JOIN
		AR_ViewSuperbillProcedureAggregate VSP
	ON
		LD.SuperbillProcedureUid= VSP.SuperbillProcedureUid
	INNER JOIN
		SuperbillProcedure SP
	ON
		SP.SuperbillProcedureUid=LD.SuperbillProcedureUid
	INNER JOIN
		Superbill S
	ON
		S.SuperbillUid=SP.SuperbillUid
	INNER JOIN
		Account A
	ON
		S.AccountUid = A.AccountUid
	LEFT JOIN 
		ViewStatementSuperbillBalance VS WITH (NOEXPAND)
	ON 
		VS.RPUid = @RPUid and VS.SuperbillUid = S.SuperbillUid	
	INNER JOIN 
		[AR_ViewSuperbillCompleteBatch] VSC
	ON
		VS.SuperbillUid = VSC.SuperbillUid
	WHERE 
		A.AccountResponsiblePartyUid = @RPUid
	AND	A.ISMAIN=1		
	AND	VSP.LiabilityBalance <> 0
	AND (@FCUid IS NULL OR LD.FinancialCenterUid=@FCUid)
	AND (@InsuranceBalanceOnly=1 
		OR 
         (VS.Patient is not null and VS.Patient!=0)
		)
	AND
		(@CompleteBatch =0 OR VSC.CompleteBatch=1)
	ORDER BY S.ServiceDateStart DESC		
	--WHERE 
	--	Account.AccountResponsiblePartyUid = @RPUid
	--AND	vaca.BalanceAll > 0
	--AND Charge.ARLockUid is null
	--AND ARContext.Inactive = 0
	--AND (@FCUid IS NULL OR Superbill.FinancialCenterUid=@FCUid)
	--AND (@InsuranceBalanceOnly=1 
	--	OR 
 --        (ViewStatementSuperbillBalance.Patient is not null and ViewStatementSuperbillBalance.Patient!=0)
	--	)
	----And Charge.LiabilityDate <= Dateadd(dd,-30,GetUTCdate())))
	--ORDER BY Superbill.ServiceDateStart DESC

	OPEN Cur_RPSuperBills
	FETCH NEXT FROM Cur_RPSuperBills INTO @temp, @SSDate

	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @SBid = CASE  
			WHEN @Cnt = 0 THEN @temp
			WHEN @Cnt = 1 THEN @SBid + '', ''+@temp
		END
		FETCH NEXT FROM Cur_RPSuperBills INTO @temp, @SSDate
	SET 	@Cnt = 1
	END

	CLOSE Cur_RPSuperBills
	DEALLOCATE Cur_RPSuperBills

	Return @SBid
END









' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetSuperbillProcedureRowNumber]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[GetSuperbillProcedureRowNumber] (@superbillProcedureUid uniqueidentifier) RETURNS int AS
	BEGIN
	
	DECLARE @rowNum int
	
	DECLARE @rowCntSBP TABLE
	(
		rowCnt int,
		superbillProcedureUid uniqueidentifier
    );
    
	INSERT INTO @rowCntSBP( rowCnt, superbillProcedureUid )
		SELECT ROW_NUMBER() OVER ( ORDER BY sbp2.DisplayOrder), 
		       sbp2.SuperbillProcedureUid 
		FROM SuperbillProcedure sbp with (nolock)
				INNER JOIN Superbill sb with (nolock) on sbp.SuperbillProcedureUid = @superbillProcedureUid
																AND sbp.SuperbillUid = sb.SuperbillUid
				INNER JOIN SuperbillProcedure sbp2 with (nolock) on sb.SuperbillUid = sbp2.SuperbillUid
				
	select @rowNum = rc.rowCnt
	from @rowCntSBP rc
	where rc.superbillProcedureUid = @superbillProcedureUid
	
	RETURN @rowNum
	END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetUserGroups]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetUserGroups]
	(
	@UserUid UniqueIdentifier
	)
RETURNS @UserGroup TABLE (	UserGroupUid UniqueIdentifier,
							Name VARCHAR(100))
AS
BEGIN
	INSERT @UserGroup
	VALUES (''{00000101-0000-0000-0000-000000000000}'', ''Everyone'')

	INSERT			@UserGroup
	SELECT DISTINCT ugm.UserGroupUid, ug.Name
	FROM			UserGroupMember ugm INNER JOIN ListUserGroup ug ON ugm.UserGroupUid = ug.UserGroupUId
	WHERE			ugm.MemberUserUid = @UserUid 

	WHILE @@ROWCOUNT > 0
	BEGIN
		INSERT				@UserGroup
		SELECT	DISTINCT	ugm.UserGroupUid, ug.Name
		FROM				@UserGroup ugcurrent INNER JOIN UserGroupMember ugm ON ugcurrent.UserGroupUid = ugm.MemberUserGroupUid
							INNER JOIN ListUserGroup ug ON ugm.UserGroupUid = ug.UserGroupUid
		WHERE				NOT ugm.UserGroupUid IN (SELECT UserGroupUid FROM @UserGroup)
	END

	RETURN
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getUTCDateTime]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE function [dbo].[getUTCDateTime]  
 (@inLocaleDateTime datetime,  -- the time to convert to local (should be a local datetime value)  
 @inTimeZoneAdj int,   -- the number of hours to adjust for the local timezone  
 @bObserveDaylightSavings tinyint) -- whether or not the local area observes US daylight savings time  
 returns datetime as
BEGIN
return dbo.Date_LocalToUTC(@inLocaleDateTime,@inTimeZoneAdj,@bObserveDaylightSavings)
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetVoiceAttachmentStatus]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetVoiceAttachmentStatus] 
(
	@dateRecorded datetime,
    @dateSent datetime,
    @dateReceived datetime,
    @dateMerged datetime,
	@readyToTranscribe bit
)  
RETURNS VARCHAR(25)  
AS

BEGIN
	
	DECLARE @status varchar(25)
	SET @status = NULL

	IF NOT @dateMerged IS NULL
		SET @status = ''Merged''
	ELSE
	BEGIN
		IF NOT @dateReceived IS NULL
			SET @status = ''Received''
		ELSE
		BEGIN
			IF NOT @dateSent IS NULL
				SET @status = ''Sent''
			ELSE
			BEGIN
				IF NOT @dateRecorded IS NULL
				BEGIN
					SET @status = ''Recorded''
					IF (@readyToTranscribe = 0)
						SET @status = ''Not ready to transcribe''
				END
				ELSE
					SET @status = NULL
			END
		END
	END

	RETURN @status

END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GUIDToInt]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'/**********************************************************************************************************************************
 * Convert Guid back to Int                                                                                                       *
 **********************************************************************************************************************************/
CREATE FUNCTION [dbo].[GUIDToInt](@UID uniqueidentifier) RETURNS INT AS
BEGIN
   IF (@UID IS NULL) RETURN NULL
   IF SUBSTRING(CONVERT(VARCHAR(36), @UID), 1, 1) = ''1'' SET @Uid = ''0'' + SUBSTRING(CONVERT(VARCHAR(36), @UID), 2, 35)
   IF (@UID = ''00000000-0000-0000-0000-00000000FFFF'') RETURN 0
   DECLARE @neg BIT = 0
   DECLARE @s VARCHAR(36) = convert(VARCHAR(36), @UID)
   IF SUBSTRING(@S, 1,  LEN(''FFFFFFFF'')) = ''FFFFFFFF''
   BEGIN
      SET @neg = 1
      SET @s = SUBSTRING(@S, LEN(''FFFFFFFF'') + 1, 36)
   END
   SET @s = REPLACE(@s, ''-'', '''')
   SET @s = SUBSTRING(@s, PATINDEX(''%[^0]%'', @s), LEN(@s))
   IF (@s = '''') RETURN 0
   DECLARE @num BIT = (SELECT ISNUMERIC(@s))
   IF @num = 0 RETURN NULL
   DECLARE @i INT = CONVERT(INT, @s)
   IF (@neg = 1) RETURN -@i
   RETURN @i
END
' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[HashString]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[HashString](@src [nvarchar](1024))
RETURNS [nvarchar](max) WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[HashString]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[HexStrToVarBin]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[HexStrToVarBin](@hexstr varchar(8000)) 
RETURNS varbinary(8000) 
AS 
BEGIN 
    DECLARE @hex char(2), @i int, @count int, @b varbinary(8000) 
    SET @count = LEN(@hexstr) 
    SET @b = CAST('''' as varbinary(1)) 
    IF SUBSTRING(@hexstr, 1, 2) = ''0x'' 
        SET @i = 3 
    ELSE 
        SET @i = 1 
    WHILE (@i <= @count) 
     BEGIN 
        SET @hex = SUBSTRING(@hexstr, @i, 2) 
        SET @b = @b + 
                CAST(CASE WHEN SUBSTRING(@hex, 1, 1) LIKE ''[0-9]'' 
                    THEN CAST(SUBSTRING(@hex, 1, 1) as int) 
                    ELSE CAST(ASCII(UPPER(SUBSTRING(@hex, 1, 1)))-55 as int) 
                END * 16 + 
                CASE WHEN SUBSTRING(@hex, 2, 1) LIKE ''[0-9]'' 
                    THEN CAST(SUBSTRING(@hex, 2, 1) as int) 
                    ELSE CAST(ASCII(UPPER(SUBSTRING(@hex, 2, 1)))-55 as int) 
                END as binary(1)) 
        SET @i = @i + 2 
     END 
    RETURN @b 
END ' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Hl7_GetClientID_Sunrise]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE Function [dbo].[Hl7_GetClientID_Sunrise]()
	Returns Varchar(100)
As
Begin
	Declare @ClientID Varchar(6)

	Select @ClientID= C.Value From ClaimFormatValue C  Join ListClaimFormatValueType CF on C.ClaimFormatValueTypeUID=CF.ClaimFormatValueTypeUID
		Where CF.Name=''Sunrise Client ID''
	
	If (Len(@ClientID)<6)
		Set @ClientID=Left(''000000'',6-Len(@ClientId)) + @ClientID

	Return @ClientID
End

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[hl7FindTerminator]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =============================================
-- Author:		Kevin Crumpton
-- Create date: 
-- Description:	Returns a field from a segment
--
-- Known Issues: Assumes fields are separated
--				 by bars ''|''
-- =============================================
CREATE FUNCTION [dbo].[hl7FindTerminator] 
(
	-- Add the parameters for the function here
	@Segment varchar(8000)
)
RETURNS int
AS
BEGIN
	IF @Segment IS NULL OR
		len(@Segment) <= 0
	BEGIN
		GOTO the_end
	END

	DECLARE @Cr varchar(1)
	SELECT @Cr = char(13)

	DECLARE @Lf varchar(1)
	SELECT @Lf = char(10)

	DECLARE @CrLf varchar(2)
	SELECT @CrLf = @Cr + @Lf

	DECLARE @n INT
	SELECT @n = -1

	--lets look for likely terminators for end of segment and cut it off if we can
	DECLARE @end INT
	SELECT @end = -1

	SELECT @end = charindex(@CrLf, @Segment)

	IF isnull(@end,-1) <= 0
	BEGIN
		--LOOK FOR CR, IF CRLF NOT FOUND
		SELECT @end = charindex(@Cr, @Segment)
	END

	IF isnull(@end,-1) <= 0
	BEGIN
		--LOOK FOR LF, IF CRLF and CR NOT FOUND
		SELECT @end = charindex(@Lf, @Segment)
	END

	RETURN @end

	the_end:

	RETURN -1

END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[hl7FindField]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =============================================
-- Author:		Kevin Crumpton
-- Create date: 
-- Description:	Returns a field from a segment
--
-- Known Issues: Assumes fields are separated
--				 by bars ''|''
-- =============================================
CREATE FUNCTION [dbo].[hl7FindField] 
(
	-- Add the parameters for the function here
	@Segment varchar(8000),
	@FieldNum int
)
RETURNS varchar(8000)
AS
BEGIN
	-- Declare the return variable here
	DECLARE @Ret varchar(8000)
	SELECT @Ret = ''''

	DECLARE @FS varchar(1)
	SELECT @FS = ''|''

--	SELECT TOP 1 @msg = convert(varchar(8000),rawmessage) FROM HL7Message WHERE isnull( convert(varchar(8000),rawmessage),'''') <> ''''
--	SELECT @Segment = ''PID''

	IF @Segment IS NULL OR
		@FieldNum IS NULL OR
		len(@Segment) <= 0 OR
		@FieldNum < 0
	BEGIN
		GOTO the_end
	END

	DECLARE @Cr varchar(1)
	SELECT @Cr = char(13)

	DECLARE @Lf varchar(1)
	SELECT @Lf = char(10)

	DECLARE @CrLf varchar(2)
	SELECT @CrLf = @Cr + @Lf

	DECLARE @n INT
	SELECT @n = -1

--	IF isnull(@n,-1) < 0
--		GOTO the_end

--	SELECT @Ret = SUBSTRING(@Segment, @n, len(@Segment) - @n)

	--lets look for likely terminators for end of segment and cut it off if we can
	DECLARE @end INT
	SELECT @end = -1

	SELECT @end = charindex(@CrLf, @Segment)

	IF isnull(@end,-1) <= 0
	BEGIN
		--LOOK FOR CR, IF CRLF NOT FOUND
		SELECT @end = charindex(@Cr, @Segment)
	END



	IF isnull(@end,-1) <= 0
	BEGIN
		--LOOK FOR LF, IF CRLF and CR NOT FOUND
		SELECT @end = charindex(@Lf, @Segment)
	END


	IF isnull(@end,-1) > 0
	BEGIN
		--IF WE FOUND A LINE TERMINATOR, TRUNCATE SEGMENT AT TERMINATOR
		SELECT @Segment = SUBSTRING(@Segment, 0, @end)
	END

	

	DECLARE @i INT
	SELECT @i = 1
	
	WHILE @i <= @FieldNum
	BEGIN
		SELECT @n = CHARINDEX(@FS, @Segment)

		-- not enough fields found before hitting end of segment
		IF isnull(@n,-1) < 0
			GOTO the_end

		SELECT @Segment = SUBSTRING(@Segment, @n + 1, len(@Segment) - (@n))
		SELECT @i = @i + 1
	END

	-- TRIM ANYTHING PAST SEGMENT TERMINATOR IN CASE THIS FIELD IS THE LAST FIELD
	SELECT @n = dbo.hl7FindTerminator(@Segment)
	IF isnull(@n,-1) > 0
		SELECT @Segment = SUBSTRING(@Segment, 0, @n)
	
	SELECT @n = charindex(@FS, @Segment)
	
	-- truncate return value at end of field
	IF isnull(@n,-1) > 0
		SELECT @Segment = SUBSTRING(@Segment, 0, @n)
	
	SELECT @ret = @segment

	the_end:

	-- Return the result of the function
	RETURN @Ret

END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[hl7FindSegment]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =============================================
-- Author:		Kevin Crumpton
-- Create date: 
-- Description:	Returns a segment from a message
--
-- Known Issues: If a field ends with the value
--				of the segment you are searching
--				for, then you may not get the 
--			    beginning of the appropriate
--				segment. Instead, your return
--				value will be the end of the field
--				that matches:
--					@Segment + ''|''
--
--				If multiple segments of same kind,
--				only first one found is returned
-- =============================================
CREATE FUNCTION [dbo].[hl7FindSegment] 
(
	-- Add the parameters for the function here
	@Msg varchar(8000),
	@Segment varchar(8000)
)
RETURNS varchar(8000)
AS
BEGIN
	-- Declare the return variable here
	DECLARE @Ret varchar(8000)

--	DECLARE @Msg varchar(8000)
--	DECLARE @Segment varchar(20)
--	DECLARE @Ret varchar(8000)
--	DECLARE @Debug INT
--	SELECT @Debug = 1

	SELECT @Ret = ''''

--	SELECT TOP 1 @msg = convert(varchar(8000),rawmessage) FROM HL7Message WHERE isnull( convert(varchar(8000),rawmessage),'''') <> ''''
--	SELECT @Segment = ''PID''

	IF @Msg IS NULL OR
		@Segment IS NULL OR
		len(@msg) <= 0 OR
		len(@segment) <= 0
	BEGIN
		GOTO the_end
	END

	DECLARE @Cr varchar(1)
	SELECT @Cr = char(13)

	DECLARE @Lf varchar(1)
	SELECT @Lf = char(10)

	DECLARE @CrLf varchar(2)
	SELECT @CrLf = @Cr + @Lf

	DECLARE @n INT
	SELECT @n = -1

	IF RIGHT(@Segment,1) <> ''|''
		SELECT @Segment = @Segment + ''|''

	SELECT @n = CHARINDEX(@Segment, @Msg) 

	IF isnull(@n,-1) <= 0
		GOTO the_end

	SELECT @Ret = SUBSTRING(@Msg, @n, len(@Msg) - @n)

	--lets look for likely terminators for end of segment and cut it off if we can
	DECLARE @end INT
	SELECT @end = -1

	SELECT @end = charindex(@CrLf, @Ret)

--	IF @Debug = 1
--		PRINT ''CRLF END='' + CONVERT(VARCHAR(20), @end)

	IF isnull(@end,-1) <= 0
	BEGIN
		--LOOK FOR CR, IF CRLF NOT FOUND
		SELECT @end = charindex(@Cr, @Ret)
		
--		IF @Debug = 1
--			PRINT ''CR END='' + CONVERT(VARCHAR(20), @end)

	END



	IF isnull(@end,-1) <= 0
	BEGIN
		--LOOK FOR LF, IF CRLF and CR NOT FOUND
		SELECT @end = charindex(@Lf, @Ret)
		
--		IF @Debug = 1
--			PRINT ''LF END='' + CONVERT(VARCHAR(20), @end)
	END

	IF isnull(@end,-1) <= 0
	BEGIN
		--IF WE HAVEN''T FOUND IT BY NOW, THEN JUST RETURN THE REMAINING PART OF THE MSG
		GOTO THE_END
	END

	SELECT @Ret = SUBSTRING(@Ret, 0, @end)

	the_end:

--	IF @Debug = 1
--	BEGIN
--		PRINT ''*****************************''
--		PRINT @Msg
--		PRINT ''*****************************''
--		PRINT @Ret
--	END

	-- Return the result of the function
	RETURN @Ret

END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[hl7FindSubcomponent]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =============================================
-- Author:		Kevin Crumpton
-- Create date: 
-- Description:	Returns a field from a segment
--
-- Known Issues: Assumes subcomponents are separated
--				 by carats ''^''
--				 Counting starts with 1
-- =============================================
CREATE FUNCTION [dbo].[hl7FindSubcomponent] 
(
	-- Add the parameters for the function here
	@Segment varchar(8000),
	@FieldNum int
)
RETURNS varchar(8000)
AS
BEGIN
	-- Declare the return variable here
	DECLARE @Ret varchar(8000)
	SELECT @Ret = ''''

	DECLARE @FS varchar(1)
	SELECT @FS = ''^''


	IF @Segment IS NULL OR
		@FieldNum IS NULL OR
		len(@Segment) <= 0 OR
		@FieldNum <= 0
	BEGIN
		GOTO the_end
	END

	DECLARE @Cr varchar(1)
	SELECT @Cr = char(13)

	DECLARE @Lf varchar(1)
	SELECT @Lf = char(10)

	DECLARE @CrLf varchar(2)
	SELECT @CrLf = @Cr + @Lf

	DECLARE @n INT
	SELECT @n = -1


	--lets look for likely terminators for end of segment and cut it off if we can
	DECLARE @end INT
	SELECT @end = -1

	SELECT @end = charindex(@CrLf, @Segment)

	IF isnull(@end,-1) <= 0
	BEGIN
		--LOOK FOR CR, IF CRLF NOT FOUND
		SELECT @end = charindex(@Cr, @Segment)
	END



	IF isnull(@end,-1) <= 0
	BEGIN
		--LOOK FOR LF, IF CRLF and CR NOT FOUND
		SELECT @end = charindex(@Lf, @Segment)
	END


	IF isnull(@end,-1) > 0
	BEGIN
		--IF WE FOUND A LINE TERMINATOR, TRUNCATE SEGMENT AT TERMINATOR
		SELECT @Segment = SUBSTRING(@Segment, 0, @end)
	END

	DECLARE @i INT
	SELECT @i = 1
	
	WHILE @i < @FieldNum
	BEGIN
		SELECT @n = CHARINDEX(@FS, @Segment)

		-- not enough fields found before hitting end of segment
		IF isnull(@n,-1) <= 0
			GOTO the_end

		SELECT @Segment = SUBSTRING(@Segment, @n + 1, len(@Segment) - (@n))
		SELECT @i = @i + 1
	END

	-- TRIM ANYTHING PAST SEGMENT TERMINATOR IN CASE THIS FIELD IS THE LAST FIELD
	SELECT @n = dbo.hl7FindTerminator(@Segment)
	IF isnull(@n,-1) > 0
		SELECT @Segment = SUBSTRING(@Segment, 0, @n)
	
	SELECT @n = charindex(@FS, @Segment)
	
	-- truncate return value at end of field
	IF isnull(@n,-1) > 0
		SELECT @Segment = SUBSTRING(@Segment, 0, @n)
	
	SELECT @ret = @segment

	the_end:

	-- Return the result of the function
	RETURN @Ret

END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[hl7GenerateObservationOrderHash]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =============================================
-- Author:		Kevin Crumpton
-- Create date: 09/29/2008
-- Description:	Generates ObservationOrder hash
-- =============================================
CREATE FUNCTION [dbo].[hl7GenerateObservationOrderHash]
(
	-- Add the parameters for the function here
	@ObservationOrderUid uniqueidentifier
)
RETURNS varchar(2000)
AS
BEGIN
	-- Declare the return variable here
	DECLARE @Result varchar(2000)

	-- Add the T-SQL statements to compute the return value here
	--SELECT @Result = ObservationOrderUid

	SELECT @Result =
		''VisitUid:'' + isnull(convert(varchar(40), oo.visituid),''NULL'') + ''_'' +
		''LabUid:'' + isnull(convert(varchar(40), oo.laboratoryuid),''NULL'') + ''_'' +
		''AccNum:'' + isnull(oo.iMedicaAccessionNumber,''NULL'') + ''_'' +
		''PSC:'' + isnull(convert(varchar(10), oo.psc),''NULL'') + ''_'' +
		''BT:'' + isnull(convert(varchar(40),oo.billtypeuid), ''NULL'') + ''_'' +
		--''AO:'' + isnull(convert(varchar(10), DATEDIFF(dd, oo.OrderDate, v.VisitDate)),''NULL'') + ''_'' +
		''AO:'' + isnull(convert(varchar(20), oo.OrderDate, 112), ''NULL'') + ''_'' +    -- CMR: Just use order date (in place of the old days from visitdate)
		''QTemp:'' +
			CASE WHEN oo.LaboratoryUid<>''4524B6E9-2BE4-4E55-9389-514159A6F995'' THEN '''' --Return '''' if the lab is NOT Quest -- J.R. Bluett 20130122
				WHEN TemporaryQuestLabOrder.SplitCategory1 = ''FZ'' THEN convert(varchar(40), oo.ObservationOrderUid) --these all get separate accessions
				WHEN TemporaryQuestLabOrder.SplitCategory1 = ''RT'' AND TemporaryQuestLabOrder.SplitCategory2 = ''P''
						THEN convert(varchar(40), oo.ObservationOrderUid) --these all get separate accessions
				WHEN TemporaryQuestLabOrder.SplitCategory1 = ''RT'' OR TemporaryQuestLabOrder.SplitCategory1 = ''RF''
						THEN ''RTRF''  -- these can be combined into same accession
				ELSE '''' -- orders without a matching row in TemporaryQuestLabOrder or with SplitCategory other than those above can all be combined
			END	+ ''_'' +
		''SplitCat:'' + isnull(hsc.SplitCategory, ''NULL'') + ''_'' +
		''Ex:'' +   --subsection to handle option for forcing one accession per test
			CASE WHEN isnull(lpp.BoolValue,0) <> 0
					THEN convert(varchar(40), oo.ObservationOrderUid) --these all get separate accessions
				ELSE ''''
			END + ''_''
 	FROM ObservationOrder oo
 	    LEFT JOIN Visit v ON v.VisitUid = oo.VisitUid
		LEFT JOIN ListLaboratoryOrder llo ON oo.LaboratoryOrderUid = llo.LaboratoryOrderUid
		LEFT JOIN TemporaryQuestLabOrder ON llo.LabOrderCode = TemporaryQuestLabOrder.LabCode
		LEFT JOIN HL7OrderSplitCategory hsc ON hsc.LaboratoryUid = oo.LaboratoryUid and llo.LabOrderCode = hsc.LabOrderCode
		LEFT JOIN ListProductParameter lpp on lpp.ParameterName = ''GenerateOneAccessionPerTest'' AND
								lpp.GuidValue = oo.LaboratoryUid --this option setting is specific to each individual lab
	WHERE oo.ObservationOrderUid = @ObservationOrderUid

	-- Return the result of the function
	RETURN @Result

END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[hl7MessageDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[hl7MessageDate] 
(
	-- Add the parameters for the function here
	@RawMsg varchar(8000)
)
RETURNS datetime
AS
BEGIN
		IF @RawMsg IS NULL 
		BEGIN
			return null
		END

--		DECLARE @yr varchar(100)
--		DECLARE @mo varchar(100)
--		DECLARE @da varchar(100)
--
--		SELECT @yr = left(dbo.hl7findfield(dbo.hl7findsegment(@RawMsg,''msh''),6),4)
--		SELECT @mo = substring(dbo.hl7findfield(dbo.hl7findsegment(@RawMsg,''msh''),6), 5,2)
--		SELECT @da = substring(dbo.hl7findfield(dbo.hl7findsegment(@RawMsg,''msh''),6), 7,2)

		IF isdate (substring(dbo.hl7findfield(dbo.hl7findsegment(@RawMsg,''msh''),6), 5,2) + ''/'' +
				substring(dbo.hl7findfield(dbo.hl7findsegment(@RawMsg,''msh''),6), 7,2) + ''/'' +
				left(dbo.hl7findfield(dbo.hl7findsegment(@RawMsg,''msh''),6),4)) = 1
		BEGIN
			return convert(datetime,
				substring(dbo.hl7findfield(dbo.hl7findsegment(@RawMsg,''msh''),6), 5,2) + ''/'' +
				substring(dbo.hl7findfield(dbo.hl7findsegment(@RawMsg,''msh''),6), 7,2) + ''/'' +
				left(dbo.hl7findfield(dbo.hl7findsegment(@RawMsg,''msh''),6),4) ,101 )
		END
	
		RETURN NULL
	

end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IMO_BuildCodeSearchRangeWhere]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[IMO_BuildCodeSearchRangeWhere]
(
	@range VARCHAR(800)
)
RETURNS VARCHAR(MAX)
AS
BEGIN

	DECLARE @retVal VARCHAR(MAX) = '''';
	DECLARE @elemA VARCHAR(100);
	DECLARE @elemB VARCHAR(100);
	DECLARE @left VARCHAR(100);
	DECLARE @right VARCHAR(100);
	DECLARE @part VARCHAR(100);

	IF (@range IS NULL OR @range='''')
		RETURN @retVal;

	DECLARE CUR_A CURSOR FOR
		SELECT ELEMENT FROM dbo.Split(@range, '';'');
	OPEN CUR_A;
	FETCH NEXT FROM CUR_A INTO @elemA;

	WHILE @@FETCH_STATUS = 0
	BEGIN

		IF (NOT @elemA IS NULL AND NOT @elemA = '''')
		BEGIN 

			DECLARE CUR_B CURSOR FOR
				SELECT ELEMENT FROM dbo.Split(@elemA, ''-'');
			OPEN CUR_B;
			FETCH NEXT FROM CUR_B INTO @elemB;

			WHILE @@FETCH_STATUS = 0
			BEGIN
				IF (@left IS NULL)
					SET @left = @elemB;
				ELSE
					SET @right = @elemB;

				FETCH NEXT FROM CUR_B INTO @elemB;
			END;

			CLOSE CUR_B;
			DEALLOCATE CUR_B;

			IF (NOT @retVal = '''')
				SET @retVal = @retVal + '' OR '';

			IF (@right IS NULL)
				SET @part = ''[CODE10] = '''''' + @left + '''''' ''; 
			ELSE
				SET @part = ''[CODE10] >= '''''' + @left + '''''' AND [CODE10] < '''''' + @right + '''''' ''; 

			SET @left = NULL;
			SET @right = NULL;
			SET @retVal = @retVal + ''('' + @part + '')'';
		END;

		FETCH NEXT FROM CUR_A INTO @elemA;
	END;

	CLOSE CUR_A;
	DEALLOCATE CUR_A;

	SELECT @retVal = ''( '' +  @retVal + '' OR '' + REPLACE(@retVal,''[CODE10]'',''[CODE09]'') + '' )'';

	RETURN @retVal;

END

/*
	SELECT dbo.IMO_BuildCodeSearchRangeWhere(''1-2;3''); 
*/





















' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsDiagnosisCodeInSingleRange]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[IsDiagnosisCodeInSingleRange](@rangeLow [nvarchar](max), @rangeHigh [nvarchar](max), @lookFor [nvarchar](max), @compareByRoot [bit])
RETURNS [bit] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[IsDiagnosisCodeInSingleRange]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IMO_BuildImoNoteString]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[IMO_BuildImoNoteString]
(
	@icd10 VARCHAR(10)
)
RETURNS VARCHAR(MAX)
AS
BEGIN

	-- Scenario 40641:ICD 10 New Feature to guide providers when additional diagnoses are required to be coded in addition to the original code selected.
	-- 20160411 BMR Bug 48533:Slow IMO

	DECLARE @listStr VARCHAR(MAX)

	SELECT @listStr = COALESCE(@listStr+CHAR(13)+CHAR(10), '''') +  CAST(NT.NOTE_TYPE AS VARCHAR(2)) + '' - '' + CAST(NT.NOTE_TEXT AS VARCHAR(800))
        FROM IMO_ICD_NOTES NT 
		WHERE RANGE_LOW <= @icd10 AND RANGE_HIGH >= @icd10
			AND dbo.IsDiagnosisCodeInSingleRange( RANGE_LOW, RANGE_HIGH , @icd10, 1 ) = 1
        ORDER BY NT.SEQUENCE_ORDER

	RETURN @listStr;

END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IMO_ICD_FullDescription]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

  
CREATE FUNCTION [dbo].[IMO_ICD_FullDescription] 
	(@code10 VARCHAR(10), @code09 VARCHAR(25), @codeDescription VARCHAR(255))
RETURNS VARCHAR(MAX) AS  

BEGIN  

	-- PART I (CODE10-CODE09)
	DECLARE @partOne VARCHAR(100) = '''';
	IF (NOT LTRIM(RTRIM(@code10))='''')
		SET @partOne = @code10;
	
	IF (NOT LTRIM(RTRIM(@code09))='''')
	BEGIN
		IF (NOT @partOne = '''')
			SET @partOne = @partOne + ''-'' + @code09;
		ELSE
			SET @partOne = @code09;
	END
	
	IF (NOT LTRIM(RTRIM(@partOne))='''')
		RETURN ''('' + @partOne + '') '' + ISNULL(@codeDescription,'''');
	
	RETURN ISNULL(@codeDescription,'''');

END

/*
	SELECT dbo.IMO_ICD_FullDescription(NULL, NULL, NULL)
	SELECT dbo.IMO_ICD_FullDescription(NULL, NULL, ''CD'')
	SELECT dbo.IMO_ICD_FullDescription(NULL, ''C09'', NULL)
	SELECT dbo.IMO_ICD_FullDescription(''C10'', NULL, NULL)
	
	SELECT dbo.IMO_ICD_FullDescription(''C10'', ''C09'', NULL)
	SELECT dbo.IMO_ICD_FullDescription(''C10'', ''C09'', ''CD'')
	
	SELECT dbo.IMO_ICD_FullDescription(NULL, ''C09'', NULL)
	SELECT dbo.IMO_ICD_FullDescription(''C10'', NULL, ''CD'')
*/



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IntToGUID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'  
CREATE FUNCTION [dbo].[IntToGUID] (@PK_ID int)
RETURNS uniqueidentifier AS  

BEGIN  

  declare @Wrk varchar(200)
  declare @NewGUID uniqueidentifier
  declare @Neg bit

  if @PK_ID = 0 
	return ''00000000-0000-0000-0000-00000000FFFF''

  if @PK_ID is not null
    begin
      if (@PK_ID < 0) 
        begin
	  set @Neg = 1 
          set @PK_ID = -1 * @PK_ID
        end
      set @Wrk = convert (varchar(200), @PK_ID)
      while len(@Wrk) < 32 set @Wrk = ''0'' + @Wrk

      if (@Neg = 1 )
             set @Wrk = ''FFFFFFFF'' + ''-'' + SUBSTRING(@Wrk, 9, 4) + ''-'' + SUBSTRING(@Wrk, 13, 4) 
                              + ''-'' + SUBSTRING(@Wrk, 17, 4) + ''-'' + SUBSTRING(@Wrk, 21, 12)
      else
             set @Wrk = SUBSTRING(@Wrk, 1, 8) + ''-'' + SUBSTRING(@Wrk, 9, 4) + ''-'' + SUBSTRING(@Wrk, 13, 4) 
                              + ''-'' + SUBSTRING(@Wrk, 17, 4) + ''-'' + SUBSTRING(@Wrk, 21, 12)
      set @Wrk = ''{'' + @Wrk + ''}''
      set @NewGUID = @Wrk
    end
 
  return (@NewGUID)
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsCCMEnabled]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE function [dbo].[IsCCMEnabled] 
(@PatientUid uniqueidentifier, @AsOfDate DATE)
	RETURNS BIT AS
BEGIN
	declare @result bit
	
	IF (SELECT COUNT(*) FROM PatientCareManagement 
		WHERE PatientUid = @PatientUid 
			AND CareTypeUid = ''14E95BCD-A9BC-41E4-9743-ECDBAD35FB6A''
			AND (StatusUid IS NULL OR StatusUid = ''8ADCE475-B9D5-4A2C-B312-DEE14BAEB427'')
			AND (EffectiveDate IS NULL OR EffectiveDate <= @AsOfDate)
			AND (ExpirationDate IS NULL OR ExpirationDate >= @AsOfDate)
		) > 0
		SET @result = 1
	ELSE
		SET @result = 0
	
	return @result
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsCPOEnabled]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE function [dbo].[IsCPOEnabled] 
(@PatientUid uniqueidentifier, @AsOfDate DATE)
	RETURNS BIT AS
BEGIN
	declare @result bit
	
	IF (SELECT COUNT(*) FROM PatientCareManagement 
		WHERE PatientUid = @PatientUid 
			AND CareTypeUid = ''928A4F18-FF1F-4BBA-90D9-66AEE2233C9A''
			AND (StatusUid IS NULL OR StatusUid = ''8ADCE475-B9D5-4A2C-B312-DEE14BAEB427'')
			AND (EffectiveDate IS NULL OR EffectiveDate <= @AsOfDate)
			AND (ExpirationDate IS NULL OR ExpirationDate >= @AsOfDate)
		) > 0
		SET @result = 1
	ELSE
		SET @result = 0
	
	return @result
END





' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsDiagnosisCodeInRange]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[IsDiagnosisCodeInRange](@rangeSpecification [nvarchar](max), @lookFor [nvarchar](max))
RETURNS [bit] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[IsDiagnosisCodeInRange]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsDrugDeleted]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[IsDrugDeleted] (@DiscontinueReasonUid uniqueidentifier)
RETURNS bit AS
BEGIN
	declare @result bit

	set @result = 0

	if (@DiscontinueReasonUid = ''E322D823-F96D-4070-AF3B-AAB21B21E6A9'')
		set @result = 1

	return @result
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsDrugRefilled]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[IsDrugRefilled] (@DiscontinueReasonUid uniqueidentifier)
RETURNS bit AS
BEGIN
	declare @result bit

	set @result = 0

	if (@DiscontinueReasonUid = ''8F132A93-E4A7-4B45-BDBE-AC68E63B1ED4'')
		set @result = 1

	return @result
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsDuplicateHpi]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[IsDuplicateHpi] (@relCCSystemSymptom1Uid uniqueidentifier, @relCCSystemSymptom2Uid uniqueidentifier) RETURNS bit AS
BEGIN
	DECLARE @count int

	SELECT	@count = COUNT(*)
	FROM	RelCCSymptomHpiCategory r1 
	WHERE	r1.RelCCSystemSymptomUid = @relCCSystemSymptom1Uid AND
			r1.HpiCategoryUid NOT IN (SELECT HpiCategoryUid FROM RelCCSymptomHpiCategory WHERE RelCCSystemSymptomUid = @relCCSystemSymptom2Uid)

	IF @count <> 0
		RETURN 0
	
	SELECT	@count = COUNT(*)
	FROM	RelCCSymptomHpiCategory r1 
	WHERE	r1.RelCCSystemSymptomUid = @relCCSystemSymptom2Uid AND
			r1.HpiCategoryUid NOT IN (SELECT HpiCategoryUid FROM RelCCSymptomHpiCategory WHERE RelCCSystemSymptomUid = @relCCSystemSymptom1Uid)
	
	IF @count <> 0
		RETURN 0

	SELECT	@count = COUNT(*)
	FROM	RelCCSymptomHpiCategory r1 INNER JOIN RelCCSymptomHpi h1 ON r1.RelCCSymptomHpiCategoryUid = h1.RelCCSymptomHpiCategoryUid 
	WHERE	r1.RelCCSystemSymptomUid = @relCCSystemSymptom1Uid AND
			h1.HpiUid NOT IN (SELECT HpiUid FROM RelCCSymptomHpiCategory r2 INNER JOIN RelCCSymptomHpi h2 ON r2.RelCCSymptomHpiCategoryUid = h2.RelCCSymptomHpiCategoryUid  WHERE r2.RelCCSystemSymptomUid = @relCCSystemSymptom2Uid)

	IF @count <> 0
		RETURN 0

	SELECT	@count = COUNT(*)
	FROM	RelCCSymptomHpiCategory r1 INNER JOIN RelCCSymptomHpi h1 ON r1.RelCCSymptomHpiCategoryUid = h1.RelCCSymptomHpiCategoryUid 
	WHERE	r1.RelCCSystemSymptomUid = @relCCSystemSymptom2Uid AND
			h1.HpiUid NOT IN (SELECT HpiUid FROM RelCCSymptomHpiCategory r2 INNER JOIN RelCCSymptomHpi h2 ON r2.RelCCSymptomHpiCategoryUid = h2.RelCCSymptomHpiCategoryUid  WHERE r2.RelCCSystemSymptomUid = @relCCSystemSymptom1Uid)

	IF @count <> 0
		RETURN 0
	
	RETURN 1	
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsEmpty]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[IsEmpty](@value VARCHAR(MAX), @default VARCHAR(MAX), @zeroIsEmpty bit = 1) RETURNS VARCHAR(MAX) AS
BEGIN
	IF @value IS NULL
		RETURN @default
	IF RTRIM(@value) = ''''
		RETURN @default
	IF @value = ''0'' AND @zeroIsEmpty = 1
		RETURN @default
	RETURN @value
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsFemale]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE function [dbo].[IsFemale] ( @GenderUid uniqueidentifier )
	RETURNS BIT AS
BEGIN
	declare @result bit
	declare @Name varchar(255)
	declare @ANSICode varchar(255)

	SELECT @Name = Name, @ANSICode = ANSICode FROM ListGender WHERE GenderUid = @GenderUid

	if ((@Name = ''female'') OR (@ANSICode = ''f''))
	BEGIN
		SET @result = 1
	END
	ELSE BEGIN
		SET @result = 0
	END	
	
	return @result
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsPersistentAsthma]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE Function [dbo].[IsPersistentAsthma] 
(@PatientUid  varchar(50),
 @VisitYear  int,
 @MeasureYear  int,
 @VisitType as varchar(3)
)
returns bit as

Begin
	Declare @Ret bit
	SET @Ret = 0
	If (@VisitType = ''EDV'')
	Begin
		--Emergency Department Visit
		If (select count(*) from 
								Visit V  
							Left outer Join 
								VisitDiagnosis VD 
							on V.VisitUid = VD.VisitUid
								
							Left Outer Join 
								VisitProcedure VP
							on
								V.VisitUid = VP.VisitUid
							Left Outer Join 
								ListProcedure LP
							on
								LP.ProcedureUid=VP.ProcedureUid
							Where
								V.PatientUid=@PatientUid
								And 
								Year(V.VisitDate)=@VisitYear
								And
								VD.Code in (''493'')
								And
								LP.code in(''99281'',''99282'',''99283'',''99284'',''99285'')
			) >0
			SET @Ret = 1
	End
	If (@VisitType = ''AID'')
	Begin
		--Acute Inpatient Discharge
		If (select count(*) from 
								Visit V  
							Left outer Join 
								VisitDiagnosis VD 
							on V.VisitUid = VD.VisitUid
								
							Left Outer Join 
								VisitProcedure VP
							on
								V.VisitUid = VP.VisitUid
							Left Outer Join 
								ListProcedure LP
							on
								LP.ProcedureUid=VP.ProcedureUid
							Where
								V.PatientUid=@PatientUid
								And 
								Year(V.VisitDate)=@VisitYear
								And
								VD.Code in (''493'')
								And
								LP.code in(''99221'',''99222'',''99223'',''99231'',''99232'',''99233'', ''99238'',''99239'',''99251'',''99252'',''99253'',''99254'',''99255'',''99261'',''99262'',''99263'',''99291'')
			) >0
			SET @Ret = 1
	End

	If (@VisitType = ''OAV'')
	Begin
		--Outpatient Asthma Visit
		If ((select count(*) from 
								Visit V  
							Left outer Join 
								VisitDiagnosis VD 
							on V.VisitUid = VD.VisitUid
							Left Outer Join 
								VisitProcedure VP
							on
								V.VisitUid = VP.VisitUid
							Left Outer Join 
								ListProcedure LP
							on
								LP.ProcedureUid=VP.ProcedureUid
							Where
								V.PatientUid=@PatientUid
								And 
								Year(V.VisitDate)=@VisitYear
								And
								VD.Code in (''493'')
								And
								LP.code in(''99201'',''99202'',''99203'',''99204'',''99205'',''99211'',''99212'',''99213'',''99214'',''99215'',''99217'',''99218'',''99219'',''99220'',''99241'',''99242'',''99243'',''99244'',''99245'',''99341'',''99342'',''99343'',''99344'',''99345'',''99347'',''99348'',''99349'',''99350'',''99382'',''99383'',''99384'',''99385'',''99386'',''99392'',''99393'',''99394'',''99395'',''99396'',''99401'',''99402'',''99403'',''99404'', ''99411'', ''99412'', ''99420'', ''99429'', ''99499'')
			) >=4) -- 	At least four outpatient asthma visit(s)  
--			And
--				(select count(*) from 
----								Visit V  
----							Left outer Join 
----								VisitMedication VM
----							on V.VisitUid = VM.VisitUid
----							Left outer Join
--								PatientMedication PM
----							on
----								VM.VisitMedicationUid = PM.VisitMedicationUid
--							Left Outer Join 
--								MedicationSigInstruction MS
--							on
--								PM.MedicationComboUid=MS.MedicationComboUid
--							Where
--								PM.PatientUid=@PatientUid
--								And 
--								Year(PM.StartDate)=@VisitYear
--								And
--								MS.DrugName in (''Cromolyn sodium'',''Inhaled corticosteroids'',''Leukotriene modifiers'',''Methylxanthines'',''Nedocromil''))>=2

			SET @Ret = 1
	End

	If (@VisitType = ''FAM'')
	Begin
		--Four Asthma Medication
		Declare @MedicationCount int  -- Asthma medication 
		Declare @LmMedicationCount int -- Leukotriene modifiers
		-- Get Medication Count
--		select @MedicationCount=count(*) from 
----								Visit V  
----							Left outer Join 
----								VisitMedication VM
----							on V.VisitUid = VM.VisitUid
----							Left outer Join
--								PatientMedication PM
----							on
----								VM.VisitMedicationUid = PM.VisitMedicationUid
--							Left Outer Join 
--								MedicationSigInstruction MS
--							on
--								PM.MedicationComboUid=MS.MedicationComboUid
--							Where
--								PM.PatientUid=@PatientUid
--								And 
--								Year(PM.StartDate)=@VisitYear
--								And
--								MS.DrugName in (''Cromolyn sodium'',''Inhaled corticosteroids'',''Leukotriene modifiers'',''Methylxanthines'',''Nedocromil'')
		-- Get Leukotriene modifiers Medication Count
--		select @LmMedicationCount=count(*) from 
----								Visit V  
----							Left outer Join 
----								VisitMedication VM
----							on V.VisitUid = VM.VisitUid
----							Left outer Join
--								PatientMedication PM
----							on
----								VM.VisitMedicationUid = PM.VisitMedicationUid
--							Left Outer Join 
--								MedicationSigInstruction MS
--							on
--								PM.MedicationComboUid=MS.MedicationComboUid
--							Where
--								PM.PatientUid=@PatientUid
--								And 
--								Year(PM.StartDate)=@VisitYear
--								And
--								MS.DrugName = ''Leukotriene modifiers''

								
		If @MedicationCount >=4
		Begin
			if @LmMedicationCount<4 
			Begin
				SET @Ret = 1
			End
			if @LmMedicationCount>=4 -- Sole Leukotriene modifiers
			Begin
				if (select count(*) from 
								Visit V  
--							Left outer Join 
--								VisitMedication VM
--							on V.VisitUid = VM.VisitUid
--							Left outer Join
--								PatientMedication PM
--							on
--								VM.VisitMedicationUid = PM.VisitMedicationUid
--							Left Outer Join 
--								MedicationSigInstruction MS
--							on
--								PM.MedicationComboUid=MS.MedicationComboUid
							Left outer Join 
								VisitDiagnosis VD 
							on V.VisitUid = VD.VisitUid
							Where
								V.PatientUid=@PatientUid
								And 
								(Year(V.VisitDate)=@MeasureYear
									OR
								 Year(V.VisitDate)=@MeasureYear-1)
--								And
--								MS.DrugName = ''Leukotriene modifiers''
								And
								VD.Code in (''493'')) >0 
					Begin
						SET @Ret = 1
					End
			End
		End
	End
	Return @Ret
End




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsPlanExist]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[IsPlanExist]
(
 
 @FeeScheduleUID VARCHAR(MAX),
 @InsurancePlanUID VARCHAR(MAX)

)
RETURNS BIT
AS
BEGIN

	IF(@InsurancePlanUID IS NOT NULL) 
	BEGIN 
	  
	 
		DECLARE @MDOL_RPT2_AmountAllowedSchedule_InsurancePlanIDTable TABLE
		(
		ElementID	SMALLINT,  --Array index
   		InsurancePlanID	VARCHAR(MAX)	--Array element contents
		)

		INSERT INTO @MDOL_RPT2_AmountAllowedSchedule_InsurancePlanIDTable
		SELECT * FROM Split(@InsurancePlanUID,'','')
		
		BEGIN
			IF EXISTS(SELECT * FROM InsurancePlan IP
			JOIN
				InsuranceCarrier IC 
				ON
				IP.InsuranceCarrierUid=IC.CorporationUid
				WHERE  COALESCE(IP.AmountAllowedFeeScheduleUid,IC.AmountAllowedFeeScheduleUid,NULL)= @FeeScheduleUID 
				AND
				InsurancePlanUID IN (SELECT InsurancePlanID FROM @MDOL_RPT2_AmountAllowedSchedule_InsurancePlanIDTable))
			RETURN(1)
			ELSE
			RETURN(0)
		END
	END
	RETURN(1)
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsPregnant]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE function [dbo].[IsPregnant] ( @GenderUid uniqueidentifier, @VisitUid uniqueidentifier, @PatientUid uniqueidentifier, @VisitDate DATE)
	RETURNS BIT AS
BEGIN
	declare @result bit
	
	SET @result = 0
	
	if (dbo.IsFemale(@GenderUid) = 1)
	BEGIN		
		declare @cnt int
		declare @DiagnosisDescription varchar(max)
		
		declare @PregnancyDiagnosisList table
		(
			DiagnosisDescription varchar(255)
		)

		INSERT INTO @PregnancyDiagnosisList (DiagnosisDescription) VALUES (''**PREGNANCY'')
		INSERT INTO @PregnancyDiagnosisList (DiagnosisDescription) VALUES (''PREGNANCY'')
		INSERT INTO @PregnancyDiagnosisList (DiagnosisDescription) VALUES (''**GESTATIONAL DIABETES'')
		INSERT INTO @PregnancyDiagnosisList (DiagnosisDescription) VALUES (''**PLACENTA PREVIA'')
		INSERT INTO @PregnancyDiagnosisList (DiagnosisDescription) VALUES (''GESTATIONAL DIABETES'')
		INSERT INTO @PregnancyDiagnosisList (DiagnosisDescription) VALUES (''PLACENTA PREVIA'')

		INSERT INTO @PregnancyDiagnosisList 
		SELECT DiagnosisCode9 
		FROM ListDiagnosis
		WHERE DiagnosisUid in 
			(SELECT DiagnosisUid FROM RelDiagnosisDisease WHERE DiseaseUid = ''00000000-0000-0000-0000-000000101101'')
		
		 
		-- look in VisitDiagnosis
		DECLARE _cursor CURSOR FOR 
			SELECT vd.Code 
			FROM VisitDiagnosis vd 
			WHERE vd.VisitUid = @VisitUid
			
		OPEN _cursor
		FETCH NEXT FROM _cursor INTO @DiagnosisDescription
		SET @cnt = 0
		
		WHILE (@cnt = 0) AND (@@fetch_status <> -1)
		BEGIN
			IF (@@fetch_status <> -2)
			BEGIN
				SELECT @cnt = COUNT(*) 
				FROM @PregnancyDiagnosisList
				WHERE DiagnosisDescription like ''%'' + @DiagnosisDescription + ''%''
			END
			FETCH NEXT FROM _cursor INTO @DiagnosisDescription
		END
		CLOSE _cursor
		DEALLOCATE _cursor
		
		IF (@cnt > 0)
		BEGIN
			SET @result = 1
		END	
		ELSE BEGIN
			SET @cnt = 0
			
			-- look in PatientHistory
			DECLARE _cursor CURSOR FOR 
				SELECT pp.Name
				 FROM PatientProblem pp
				 INNER JOIN ListProblemStatus lps ON pp.ProblemStatusUid = lps.ProblemStatusUid
				 WHERE (pp.PatientUid = @PatientUid) AND (lps.ActiveStatus = 1) AND
					(pp.ActiveDate <= @VisitDate) AND 
					((pp.InactiveDate IS NULL) OR (pp.InactiveDate > @VisitDate))
					
			
			OPEN _cursor
			FETCH NEXT FROM _cursor INTO @DiagnosisDescription
			SET @cnt = 0
			
			WHILE (@cnt = 0) AND (@@fetch_status <> -1)
			BEGIN
				IF (@@fetch_status <> -2)
				BEGIN
					SELECT @cnt = COUNT(*) 
					FROM @PregnancyDiagnosisList
					WHERE DiagnosisDescription like ''%'' + @DiagnosisDescription + ''%''
				END
				FETCH NEXT FROM _cursor INTO @DiagnosisDescription
			END
			CLOSE _cursor
			DEALLOCATE _cursor
			IF (@cnt > 0)
			BEGIN
				SET @result = 1
			END
			ELSE BEGIN
			
				SET @cnt = 0
				
				-- look in PatientDXHistory
				DECLARE _cursor CURSOR FOR 
					SELECT pdx.Code 
					 FROM PatientDXHistory pdx
					 INNER JOIN ListProblemStatus lps on pdx.ProblemStatusUid = lps.ProblemStatusUid AND lps.ActiveStatus = 1 
					 WHERE (pdx.PatientUid = @PatientUid) AND 
						(pdx.ActiveDate <= @VisitDate) AND 
						((pdx.InactiveDate IS NULL) OR (pdx.InactiveDate > @VisitDate))
				
				OPEN _cursor
				FETCH NEXT FROM _cursor INTO @DiagnosisDescription
				SET @cnt = 0
				
				WHILE (@cnt = 0) AND (@@fetch_status <> -1)
				BEGIN
					IF (@@fetch_status <> -2)
					BEGIN
						SELECT @cnt = COUNT(*) 
						FROM @PregnancyDiagnosisList
						WHERE DiagnosisDescription like ''%'' + @DiagnosisDescription + ''%''
					END
					FETCH NEXT FROM _cursor INTO @DiagnosisDescription
				END
				CLOSE _cursor
				DEALLOCATE _cursor
						
				IF (@cnt > 0)
				BEGIN
					SET @result = 1
				END
			END
		END
	
	END
	
	return @result
END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsUserAllowedVisitConfidentialAccess]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE FUNCTION [dbo].[IsUserAllowedVisitConfidentialAccess](@UserUid [uniqueidentifier], @VisitUid [uniqueidentifier])
RETURNS [bit] 
AS

BEGIN
    DECLARE @retValue bit
	SET @retValue=0

	SELECT @retValue = 1 WHERE @UserUid IN
	(
		SELECT userAllowed.PersonUid FROM UserPRM userAllowed
			INNER JOIN RelVisitConfidentialNoteAccess rvcn ON 
				rvcn.VisitCommentExtensionUid = @VisitUid AND rvcn.UserPRMUid = userAllowed.PersonUid
		UNION
		SELECT userAllowed.PersonUid FROM UserPRM userAllowed
			INNER JOIN UserGroupMember groups ON groups.MemberUserUid = userAllowed.PersonUid
			INNER JOIN RelVisitConfidentialNoteAccess rvcn ON rvcn.UserGroupUid = groups.UserGroupUid AND
				rvcn.VisitCommentExtensionUid = @VisitUid
	)	
	RETURN @retValue
END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[LastDayOfWeek]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[LastDayOfWeek] 
(
    @date DATETIME
)
RETURNS DATETIME
AS
BEGIN
	DECLARE @dtLastDayOfWeek DATETIME
    SET @dtLastDayOfWeek = 
        CAST (CONVERT (VARCHAR (16), DATEADD(DD, 6, [dbo].[FirstDayOfWeek] (@date)), 101) AS DATETIME)
	RETURN @dtLastDayOfWeek
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_FUNCTION_PQRIRule]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[MDOL_RPT2_FUNCTION_PQRIRule]
	(
		@PQRIMeasureUids		VARCHAR(MAX)
	)
RETURNS @retTable TABLE (
						PQRIMeasureUid UniqueIdentifier,
						ReccuranceStartDate DateTime,
						ReccuranceEndDate DateTime
						)
BEGIN

	DECLARE @PQRIMeasureUid UNIQUEIDENTIFIER

	DECLARE PQRIRules CURSOR FOR SELECT Element FROM dbo.Split(@PQRIMeasureUids,'','')

	OPEN PQRIRules

	FETCH NEXT FROM PQRIRules into @PQRIMeasureUid

	WHILE(@@FETCH_STATUS = 0)
	BEGIN
		DECLARE @RecurrenceInterval SMALLINT
		DECLARE @RecurTimeTypeUid UNIQUEIDENTIFIER
		DECLARE @RecurStartDate DATETIME
		DECLARE @RecurEndDate DATETIME

		SET @RecurStartDate = Cast(Cast(''01/01/''+ cast(datepart(year,getdate()) as varchar(4)) as Datetime) as Datetime)
		SET @RecurEndDate = Cast(Cast(''01/01/''+ cast(datepart(year,getdate()) as varchar(4)) as Datetime) as Datetime)

		WHILE (@RecurEndDate < getdate())
		BEGIN

			SELECT 
				@RecurrenceInterval = RecurrenceInterval,	
				@RecurTimeTypeUid = RecurTimeTypeUid  
			FROM ListPQRIMeasure WHERE PQRIMeasureUid = @PQRIMeasureUid
			
			IF (@RecurTimeTypeUid IS NOT NULL AND @RecurrenceInterval > 0)
			BEGIN
				SET @RecurEndDate = dbo.CheckRecurTimeType(@RecurTimeTypeUid, @RecurStartDate, @RecurrenceInterval)

				IF (@RecurEndDate > getdate())
				BEGIN
					SET @RecurEndDate = getdate()
				END
			END
			ELSE
			BEGIN
				SET @RecurEndDate = getdate()
			END

			INSERT INTO @retTable(PQRIMeasureUid, ReccuranceStartDate, ReccuranceEndDate)
			VALUES(@PQRIMeasureUid, @RecurStartDate, @RecurEndDate)

			--SET @RecurStartDate = DATEADD(d, 1, @RecurEndDate)
			SET @RecurStartDate = @RecurEndDate
		END

	FETCH NEXT FROM PQRIRules INTO @PQRIMeasureUid
	END

	CLOSE PQRIRules
	DEALLOCATE PQRIRules

RETURN 

END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_getPatientStatus]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[MDOL_RPT2_getPatientStatus]
(  
	@PatientUid UNIQUEIDENTIFIER
)   
RETURNS  Varchar(Max) AS  
BEGIN    
	DECLARE @PatientStatus VARCHAR(MAX)  

	SET @PatientStatus=''''  

	SELECT @PatientStatus = @PatientStatus + PatientStatusName + '';''  
	FROM  
	(  
		SELECT  
		LPs.Name AS PatientStatusName
		FROM   
		Patient P (NOLOCK)
		JOIN 
		RelPatientStatus RPS (NOLOCK)
		ON
		P.PersonUid = RPS.PatientUid
		LEFT JOIN
		ListPatientStatus LPS (NOLOCK)
		ON 
		RPS.PatientStatusUid = LPS.PatientStatusUid
		WHERE P.PersonUid=@PatientUid
	)A  


	IF LEN(@PatientStatus)>2  
	BEGIN  
	SET @PatientStatus=substring(@PatientStatus,1, len(@PatientStatus)-1)  
	END  
	RETURN @PatientStatus  
END 



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getFormattedPreferredNameFromValues]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE  FUNCTION [dbo].[UDF_getFormattedPreferredNameFromValues]
(
	@firstname as varchar(50),
	@lastname as varchar(50),
	@middlename as varchar(50),
	@suffix as varchar(50)
)
RETURNS  VARCHAR(100)

AS
BEGIN 

	DECLARE @PreferredName VARCHAR(100)

	SET @PreferredName = 
		(CASE WHEN @LastName IS NULL THEN '''' 
			ELSE @LastName + '', '' 
		END )
		+
		RTRIM((CASE WHEN @FirstName IS NULL THEN ''''
			ELSE @FirstName + '' ''
		END )
		+
		(CASE WHEN @MiddleName IS NULL THEN ''''
			WHEN @MiddleName ='''' THEN @MiddleName
			ELSE @MiddleName
		END))
		+
		(CASE WHEN @Suffix IS NULL THEN ''''
			ELSE '', '' + @Suffix
		END)
		
	RETURN @PreferredName
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_getResponsiblePartyPatients]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[MDOL_RPT2_getResponsiblePartyPatients]
(
@AccountResponsiblePartyUID UNIQUEIDENTIFIER,
@IncludeInactivePatients BIT = 0,
@IncluceDeceasedPatients BIT = 0
) 
RETURNS	 Varchar(Max) AS
BEGIN  -- FUNCTION START

	DECLARE @Patient VARCHAR(MAX)


	SET @Patient=''''
	
	SELECT @Patient = @Patient + PatientName + '';''
	FROM
	(
	SELECT 	DISTINCT
		 (CASE WHEN P1.DeathDate IS NOT NULL THEN dbo.UDF_getFormattedPreferredNameFromValues(P1.FirstName,P1.LastName,P1.MiddleName,P1.Suffix)+''(D)''
									WHEN PT.Inactive=1  THEN dbo.UDF_getFormattedPreferredNameFromValues(P1.FirstName,P1.LastName,P1.MiddleName,P1.Suffix)+''(I)'' 
									ELSE  dbo.UDF_getFormattedPreferredNameFromValues(P1.FirstName,P1.LastName,P1.MiddleName,P1.Suffix) END)AS PatientName
	FROM 
		AccountResponsibleParty ARP
	LEFT JOIN
		Account A
	ON
		ARP.AccountResponsiblePartyUID = A.AccountResponsiblePartyUid
	INNER JOIN
		Patient PT
	ON	
		A.PersonUID = PT.PersonUID
	LEFT JOIN 
		Person P1
	ON
		PT.PersonUID = P1.PersonUID
	WHERE 
		ARP.AccountResponsiblePartyUID=@AccountResponsiblePartyUID
	AND
		(@IncludeInactivePatients = 1 OR PT.Inactive = 0)
	AND
		(@IncluceDeceasedPatients = 1 OR P1.DeathDate IS  NULL)
	)A
	

	IF LEN(@Patient)>2
	BEGIN
		SET @Patient=substring(@Patient,1, len(@Patient)-1)
	END
	RETURN @Patient
END -- FUNCTION


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_GetSuperbillUnit_DFS]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[MDOL_RPT2_GetSuperbillUnit_DFS]
	(
	@TypeofProviders VARCHAR(30), 
	@ProviderUid VARCHAR(Max), 
	@FinancialCenter VARCHAR(Max),
	@ServiceSiteUid VARCHAR(Max),
	@FinanceSummary_StartDate DATETIME,
	@FinanceSummary_EndDate DATETIME,
	@DateOption  VARCHAR(30)
	) 
RETURNS Money AS
BEGIN
	DECLARE @Unit Money
	--SELECT @FinanceSummary_EndDate =  DATEADD(DAY,1,@FinanceSummary_EndDate)
	SELECT @Unit=SUM(ISNULL(SBP.Units,0))
	FROM 
		SuperBill SB
	INNER JOIN ViewSuperbillFinancialDetails VSFD ON SB.SuperbillUid = 	VSFD.SuperbillUid
	JOIN
		SuperBillProcedure SBP
	ON 
		SB.SuperbillUid=SBP.SuperbillUid
	JOIN
		ARBatch AR
	ON
		AR.ARBatchUid=SB.ARBatchUid		
	WHERE
	(
		(@DateOption=''Posting''  AND (@FinanceSummary_StartDate IS NULL OR AR.GLDate >= @FinanceSummary_StartDate) AND (@FinanceSummary_EndDate IS NULL OR AR.GLDate < @FinanceSummary_EndDate) )
			OR
		(@DateOption=''Service''  AND (@FinanceSummary_StartDate IS NULL OR SB.ServiceDateStart >= @FinanceSummary_StartDate) AND (@FinanceSummary_EndDate IS NULL OR SB.ServiceDateStart < @FinanceSummary_EndDate) )
	)
	AND
	(    
	(@TypeofProviders=''Billing Providers'' AND (@ProviderUid IS NULL OR VSFD.ClaimingProviderUid  IN (SELECT Element FROM dbo.Split(@ProviderUid, '','')))    )
	 OR    
	(@TypeofProviders=''Rendering Providers'' AND (@ProviderUid IS NULL  OR VSFD.RenderingProviderUid  IN (SELECT Element FROM dbo.Split(@ProviderUid, '','')) )    )
    )  		
	AND      
	(@FinancialCenter is NULL OR VSFD.FinancialCenterUid IN (SELECT Element FROM dbo.Split(@FinancialCenter, '','')) )   
   AND      
	(@ServiceSiteUid is NULL OR VSFD.ServiceSiteUid in (SELECT Element FROM dbo.Split(@ServiceSiteUid, '','')) )   
		   
	RETURN ISNULL(@Unit,0)
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_getTotalAppointment]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[MDOL_RPT2_getTotalAppointment]
	(@ProviderUid Uniqueidentifier,
	@ServiceSiteUid uniqueidentifier,
	@FinancialCenterUid VarChar(Max),
	@StartDate DateTime,
	@EndDate DateTime,
	@ProviderOption BIT = 1 --0 = BillingProvider 1 = RenderingProvider
	) 
RETURNS	 int AS
BEGIN  -- FUNCTION START
	DECLARE @TotalAppts Int
	SELECT @TotalAppts=COUNT(*) 
	FROM   
		ViewAppointmentWithGroup 
	WHERE 
		((@ProviderOption = 0 AND BillingProviderUid = @ProviderUid) OR (@ProviderOption = 1 AND ProviderUid = @ProviderUid))
		--ProviderUid=@ProviderUid
	AND PatientUID IS NOT NULL
	AND ServiceSiteUid=@ServiceSiteUid
	AND FinancialCenterUid=@FinancialCenterUid
	--AND	CONVERT(Varchar, StartDateTime, 101) >= @StartDate AND CONVERT(Varchar, StartDateTime, 101) <=@EndDate
	AND
	(@StartDate IS NULL OR StartDateTime >= @StartDate) AND (@EndDate IS NULL OR StartDateTime < @EndDate)

	RETURN @TotalAppts
END -- FUNCTION
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_getTotalAppointmentCancelled]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[MDOL_RPT2_getTotalAppointmentCancelled]
	(@ProviderUid Uniqueidentifier,
	@ServiceSiteUid uniqueidentifier,
	@FinancialCenterUid VarChar(Max),
	@StartDate DateTime,
	@EndDate DateTime,
	@ProviderOption BIT = 1 --Billing = 0, Rendering = 1
	) 
RETURNS	 int AS
BEGIN  -- FUNCTION START
	DECLARE @TotalApptsCancelled Int
	SELECT @TotalApptsCancelled=COUNT(*) 
	FROM   
	  ViewAppointmentWithGroup 
	Inner Join
	  ListAppointmentStatus   
	On 
	  ViewAppointmentWithGroup.AppointmentStatusUid = ListAppointmentStatus.AppointmentStatusUid
	WHERE 
		((@ProviderOption = 0 AND BillingProviderUid = @ProviderUid) OR (@ProviderOption = 1 AND ProviderUid = @ProviderUid))
	AND PatientUid IS NOT NULL
	AND ViewAppointmentWithGroup.ServiceSiteUid=@ServiceSiteUid
	AND ViewAppointmentWithGroup.FinancialCenterUid=@FinancialCenterUid
	--AND	CONVERT(Varchar, ViewAppointmentWithGroup.StartDateTime, 101) >= @StartDate AND CONVERT(Varchar, ViewAppointmentWithGroup.StartDateTime, 101) <=@EndDate
	AND
	(@StartDate IS NULL OR ViewAppointmentWithGroup.StartDateTime >= @StartDate) AND (@EndDate IS NULL OR ViewAppointmentWithGroup.StartDateTime < @EndDate)
	AND ListAppointmentStatus.Name=''Canceled''

	RETURN @TotalApptsCancelled
END -- FUNCTION
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_getTotalCompleteVisit]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[MDOL_RPT2_getTotalCompleteVisit]
	(@ProviderUid Uniqueidentifier,
	@ServiceSiteUid uniqueidentifier,
	@FinancialCenterUid VarChar(Max),
	@StartDate DateTime,
	@EndDate DateTime,
	@ProviderOption BIT = 1 --Billing = 0, Rendering = 1
	) 
RETURNS	 int AS
BEGIN  -- FUNCTION START
	DECLARE @TotalCompletVisits Int
	SELECT @TotalCompletVisits=COUNT(*) 
	FROM   
		Visit V
	JOIN
		ViewAppointmentWithGroup A
	ON
		V.AppointmentUid=A.AppointmentUid	
	WHERE ((@ProviderOption = 1 AND (V.RenderingProviderUid=@ProviderUid OR (V.RenderingProviderUid IS NULL AND V.ProviderUid=@ProviderUid))) OR (@ProviderOption = 0 AND (V.ProviderUid=@ProviderUid)))
	AND V.isCompleted=1
	AND V.ServiceSiteUid=@ServiceSiteUid
	AND V.FinancialCenterUid=@FinancialCenterUid
	AND	(@StartDate IS NULL OR VisitDate >= @StartDate) AND (@EndDate IS NULL OR VisitDate < @EndDate)
	AND A.PatientUid IS NOT NULL
	RETURN @TotalCompletVisits
END -- FUNCTION
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_getTotalVisit]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[MDOL_RPT2_getTotalVisit]
	(@ProviderUid uniqueidentifier, 
	@ServiceSiteUid uniqueidentifier,
	@FinancialCenterUid VarChar(Max),
	@StartDate DateTime,
	@EndDate DateTime,
	@ProviderOption BIT = 1 --BIlling = 0, Rendering = 1
	) 
RETURNS	 int AS
BEGIN
	DECLARE @TotalVisit  int
	SELECT
		@TotalVisit=COUNT(*)
	FROM 
	 Visit V
	JOIN
		ViewAppointmentWithGroup A
	ON
		V.AppointmentUid=A.AppointmentUid	
	WHERE ((@ProviderOption = 1 AND (V.RenderingProviderUid=@ProviderUid OR (V.RenderingProviderUid IS NULL AND V.ProviderUid=@ProviderUid))) OR (@ProviderOption = 0 AND V.ProviderUid=@ProviderUid))
		AND V.ServiceSiteUid=@ServiceSiteUid
		AND (@FinancialCenterUid IS NULL OR  V.FinancialCenterUid IN (SELECT Element FROM dbo.Split(@FinancialCenterUid,'','')))
	AND	(@StartDate IS NULL OR V.VisitDate >= @StartDate) AND (@EndDate IS NULL OR V.VisitDate < @EndDate)
	AND A.PatientUid IS NOT NULL


	RETURN ISNULL(@TotalVisit,0)

END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_getUserGroupMember]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[MDOL_RPT2_getUserGroupMember]
	(@Uid Uniqueidentifier
	) 
RETURNS	 Varchar(Max) AS
BEGIN  -- FUNCTION START
Declare @UandUG varchar(Max)
set @UandUG=''''
	SELECT	@UandUG=@UandUG + fuug.Name + ''; ''
	FROM	UserGroupMember ugm CROSS JOIN ViewFindUserAndUserGroup fuug
	WHERE	ugm.UserGroupUid = @Uid AND
			((ugm.MemberUserUid = fuug.Uid AND fuug.ForeignKeyIndex = 1) OR
			 (ugm.MemberUserGroupUid = fuug.Uid AND fuug.ForeignKeyIndex = 2))

IF LEN(@UandUG)>2
BEGIN
	SET @UandUG=substring(@UandUG,1, len(@UandUG)-2)
END
RETURN @UandUG
END -- FUNCTION


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_getUserGroupMemberMaxPermission]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[MDOL_RPT2_getUserGroupMemberMaxPermission]
	(
		@Perm int
	) 
RETURNS	 Varchar(50) AS
BEGIN  -- FUNCTION START
	DECLARE @Permission varchar(50)
	SET @Permission = ''''

	IF @Perm & 64 != 0 -- Read only
	BEGIN
		SET @Permission=''Read Only''
	END

	IF @Perm & 2 != 0  -- Created By
	BEGIN
		IF Len(@Permission) > 0 
			SET @Permission = @Permission + '', ''
		SET @Permission= @Permission + ''Created By''
	END

	IF @Perm  & 4 != 0  -- Modify
	BEGIN
		IF Len(@Permission) > 0 
			SET @Permission = @Permission + '', ''
		SET @Permission=@Permission + ''Modify''
	END

	IF @Perm & 128 != 0  -- Complete
	BEGIN
		IF Len(@Permission) > 0 
			SET @Permission = @Permission + '', ''
		SET @Permission= @Permission + ''Complete''
	END
	
	RETURN @Permission
END -- FUNCTION

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MedicationPrescribedFromXML]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[MedicationPrescribedFromXML] 
(
	@MessageXML [xml]
)
RETURNS [varchar](max)
AS
BEGIN
	DECLARE @DrugInfo_TBL TABLE
	(
		[DrugDescription] [varchar](2048),
		[Directions] [varchar](2048),
		[Quantity] [varchar](2048),
		[PotencyUnitCode] [varchar](2048),
		[Refills] [int]
	)

	BEGIN
		WITH XMLNAMESPACES (''http://www.ncpdp.org/schema/SCRIPT'' as ns)
		INSERT @DrugInfo_TBL
		SELECT x.n.value(''(ns:DrugDescription)[1]'', ''[varchar](2048)'') AS [DrugDescription],
			x.n.value(''(ns:Directions)[1]'', ''[varchar](2048)'') AS [Directions],
			x.n.value(''(ns:Quantity/ns:Value)[1]'', ''[varchar](2048)'') AS [Quantity],
			x.n.value(''(ns:Quantity/ns:PotencyUnitCode)[1]'', ''[varchar](2048)'') AS [PotencyUnitCode],
			x.n.value(''(ns:Refills/ns:Value)[1]'', ''[int]'') AS [Refills]
		FROM @MessageXML.nodes(''//ns:MedicationPrescribed'') AS x(n)
	END

	RETURN (
		SELECT
			drugInfo.[DrugDescription] 
			+ '' '' + drugInfo.[Directions]
			+ '', QTY: '' + drugInfo.[Quantity]
			+ '', UOM: '' + COALESCE (uom.[Name], ''Unknown'')
			+ CASE 
					WHEN drugInfo.[Refills] <> 1 THEN ''''
					WHEN drugInfo.[Refills] <= 1 THEN ''''
					ELSE '', Refills: '' + CONVERT ([varchar](256), drugInfo.[Refills] - 1)
				END
		FROM @DrugInfo_TBL AS drugInfo
			LEFT OUTER JOIN [ListSIGQuantityUnitOfMeasure] AS uom ON uom.[NCItCode] = drugInfo.[PotencyUnitCode]
	)
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MedIdFromRxNormCode]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[MedIdFromRxNormCode](@rxnormcode varchar(50)) RETURNS int AS
BEGIN
/*
   Created 05/08/2013

   Finds and returns the MedId for a given RxNorm Code.
    Give priority to generics when ordering results

*/
   DECLARE @medId int
   SELECT @medId = rev.EVD_FDB_VOCAB_ID
   FROM dbo.NDD_REVDEL0_EXT_VOCAB_LINK rev
   INNER JOIN dbo.NDD_SearchDispensable dis ON dis.IsDelete = 0 AND dis.medid = rev. EVD_FDB_VOCAB_ID
   WHERE rev.IsDelete = 0
     AND rev.EVD_EXT_VOCAB_ID = CONVERT (varchar( 255), @rxnormcode)
     AND EVD_FDB_VOCAB_TYPE_ID = 3
     AND EVD_LINK_TYPE_ID IN(1, 5)
   ORDER BY dis.StatusCode, dis.DrugNameTypeCode DESC   -- favoring generic

   RETURN ISNULL(@medId, 0)
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MessageCSObservationOrder]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[MessageCSObservationOrder]
(
	@MessageTypeUid [uniqueidentifier],
	@MessageUid [uniqueidentifier]
)
RETURNS [uniqueidentifier]
AS
BEGIN
	DECLARE @ObservationOrderUid [uniqueidentifier] =
		(
			CASE WHEN @MessageTypeUid = ''10101010-0000-0000-0000-000000000002'' 
				THEN
					(
						SELECT top(1) rag.ObservationOrderUid 
						FROM RelAttachmentGroup rag WITH(NOLOCK), MessageAA maa WITH(NOLOCK)
						WHERE maa.MessageUid = @MessageUid AND
							rag.RelAttachmentGroupUid = maa.RelAttachmentGroupUid
						ORDER BY rag.[LastModifiedDate] DESC
					)
				WHEN @MessageTypeUid = ''10101010-0000-0000-0000-000000000008''
				THEN
					(
						SELECT top(1) rel.ObservationOrderUid 
						FROM RelMessageHL7ObservationOrder rel WITH(NOLOCK)
						WHERE rel.MessageUid =  @MessageUid
						ORDER BY rel.[LastModifiedDate] DESC
					)
				ELSE NULL END
  		)
		RETURN @ObservationOrderUid
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MnidFromRxNormCode]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[MnidFromRxNormCode] (@rxnormcode varchar(50)) RETURNS int AS
BEGIN
/*
   Created 05/08/2013

   Finds and returns the mnid for a given RxNorm Code.

*/
   DECLARE @mnid INT
   SELECT @mnid = ISNULL ( -- brand name
                  (SELECT TOP (1) voc.EVD_FDB_VOCAB_ID
                     FROM dbo.NDD_REVDEL0_EXT_VOCAB_LINK voc
                     INNER JOIN dbo.NDD_SearchDrugName nam ON nam.IsDelete = 0 AND nam.mnid = EVD_FDB_VOCAB_ID AND nam.DrugNameTypeCode = ''1''
                     WHERE voc.IsDelete = 0
					    AND voc.EVD_FDB_VOCAB_TYPE_ID = 1
                        AND voc.EVD_EXT_VOCAB_ID = @RxNormCode
                     ORDER BY nam.StatusCode, voc.EVD_LINK_TYPE_ID DESC, voc.LastModifiedDate DESC),
                         -- generic
                  (SELECT TOP (1) hnm.MED_CONCEPT_ID
                     FROM dbo.NDD_REVDEL0_EXT_VOCAB_LINK voc
                        INNER JOIN dbo.NDD_RHICD5_HIC_DESC ing ON ing.IsDelete = 0 AND ing.HIC_ROOT = voc.EVD_FDB_VOCAB_ID
						-- ??? CMR: Can''t figure this one out?
                        INNER JOIN dbo.NDD_RDAMHHA0_HIC_HICL_ALG_LINK hic ON hic.IsDelete = 0 AND hic.HICL_SEQNO = ing.HIC_SEQN
                        INNER JOIN dbo.NDD_RMEDMHL0_MED_HICLSEQNO_LINK hnm ON hnm.IsDelete = 0 AND hnm.HICL_SEQNO = ing.HIC_SEQN AND hnm.MED_CONCEPT_ID_TYP = ''1''
                        INNER JOIN dbo.NDD_SearchDrugName nam ON nam.IsDelete = 0 AND nam.mnid = hnm.MED_CONCEPT_ID AND nam.DrugNameTypeCode = ''2''
                     WHERE voc.IsDelete = 0
					    AND voc.EVD_EXT_VOCAB_TYPE_ID = 500
                        AND voc.EVD_FDB_VOCAB_TYPE_ID = 104
                        AND voc.EVD_EXT_VOCAB_ID = @RxNormCode
                     ORDER BY nam.StatusCode, voc.EVD_LINK_TYPE_ID, voc.LastModifiedDate DESC ))
     RETURN @mnid
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MU_CreateMapping]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[MU_CreateMapping]
(	
	@RuleNumber VARCHAR(10),
	@CodeTypeList VARCHAR(MAX),
	@DataElementNameList VARCHAR(MAX),
	@SNOMED_96 VARCHAR(50),
	@SNOMED_97 VARCHAR(50),
	@CQMVersion VARCHAR(7) = ''CQM2015'' --2016.04.04 dmg
)
RETURNS @mappings TABLE 
	(
		PRMCode	VARCHAR(50),
		PRMCodeBigInt BIGINT NULL,
		DataElementName VARCHAR(100) NULL,
		TopicIndicator VARCHAR(50) NULL,
		QRDASection VARCHAR(50) NULL,
		Rootid VARCHAR(40) NOT NULL
	)
AS

--2016.04.04 dmg added CQM Versioning

BEGIN
				INSERT	@mappings
				SELECT	[PRMCode], 
						CASE WHEN ISNUMERIC([PRMCode]) = 1 AND RootId IN (@SNOMED_96 ,@SNOMED_97) THEN CAST(convert(FLOAT,PRMCode) AS BIGINT) ELSE NULL END AS PRMCodeBigInt,
						[DataElementName], [TopicIndicator], [QRDASection], [RootId]		
				FROM	[dbo].[MU2_InterfaceDataMapping]
				WHERE	[NCQMeasure] = @RuleNumber
				    AND [CQMVersion] = @CQMVersion --2016.04.04 dmg
					AND (
						[Name] IN (
							SELECT CleanXml
							FROM dbo.SplitCLR(@CodeTypeList, ''|'') g
							CROSS APPLY dbo.RemoveWhitespace(Parameter)
							)
						OR @CodeTypeList IS NULL
						)
					AND (
						[DataElementName] IN (
							SELECT CleanXml
							FROM dbo.SplitCLR(@DataElementNameList, ''|'')
							CROSS APPLY dbo.RemoveWhitespace(Parameter)
							)
						OR @DataElementNameList IS NULL
						)

				RETURN
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_AdultDoseRangeChecking]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 05/07/2018
-- Description:	Returns a table with adult dose range enties. If 
--				rows are not return, no dose range data is available.
--
-- =================================================================

CREATE FUNCTION [dbo].[NDD_AdultDoseRangeChecking](
		@proposed_GCN_SEQNO int	-- gcn_seqno of the proposed medication
		)
RETURNS
@NDD_AdultDosingRangeValues table
(
	PK int IDENTITY NOT NULL PRIMARY KEY,
	RangeLowDose decimal(14, 6) null,
	RangeLowDoseUnits varchar(60),
	RangeHighDose decimal(14, 6) null,
	RangeHighDoseUnits varchar(60),
	RangeLowDoseForm decimal(14, 6) null,
	RangeLowDoseFormUnits varchar(60),
	RangeHighDoseForm decimal(14, 6) null,
	RangeHighDoseFormUnits varchar(60) null
)
AS
begin
	insert into @NDD_AdultDosingRangeValues
	select
		t1.MMAR_MND as [RangeLowDose], t1.MMAR_MNDU as [RangeLowDoseUnits],
		t1.MMAR_MXD as [RangeHighDose], t1.MMAR_MXDU as [RangeHighDoseUnits],
		t1.MMAR_MNU as [RangeLowDoseForm], t1.MMAR_MNUF as [RangeLowDoseFormUnits],
		t1.MMAR_MXU as [RangeHighDoseForm], t1.MMAR_MXUF as [RangeHighDoseFormUnits]
	from NDD_RMMARMA0_ADULT_RANGE_MSTR t1 
	where t1.IsDelete = 0 
		and t1.GCN_SEQNO = @proposed_GCN_SEQNO

	return
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_BaseAllergyAlert]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/18/2014
-- Description:	Returns a table with drug allergies enties.  If the
--				table is empty no drug allergies were found.
--
-- 04/30/2014	rewrote
-- 01/15/2018   add changes to support IsDelete
-- 02/22/2018   made changes to support new table names.
-- =================================================================
CREATE FUNCTION [dbo].[NDD_BaseAllergyAlert](
		@includeInactiveIngredient bit,								-- when 1 (one) inactive ingredient will be included
		@includeIngredient bit,										-- include ingredient in allergy precautions
		@includeAllergenGroup bit,									-- include allergen group in allergy precautions
		@includeCrossSensitivity bit,								-- include cross sensitivity in allergy precautions
		@proposed_ROUTED_MED_ID int,								-- routed_med_id of the proposed medication
		@proposed_MedicationName varchar(255),						-- name of the proposed medication
		@existingAllergyHIC_SEQN ExistingAllergyHIC_SEQN readonly	-- existing list of active allergies
		)
RETURNS
@AllergyAlertResults table
(
	MedicationName varchar(255) null,
	AllergenName varchar(255) null,
	BaseIngredient varchar(255),
	Ingredient varchar(255),
	SpecificAllergenGroup varchar(255) null,
	CrossSensitivity varchar(255),
	InactiveIngredient bit null default (0)
)
AS
begin

	declare @tmpAllergyAlertResults table
	(
		pk int identity,
		MedicationName varchar(255) null,
		AllergenName varchar(255) null,
		BaseIngredient varchar(255),
		Ingredient varchar(255),
		SpecificAllergenGroup varchar(255) null,
		CrossSensitivity varchar(255),
		InactiveIngredient bit null default (0)
	)

	declare @Prospective_HIC_SEQN Table
		(
			HIC_SEQN int null
		)

	declare @Prospective_RELATED_HIC_SEQN Table
		(
			HIC_SEQN int null
		)
		
	declare @PatientAllergen_RELATED_HIC_SEQN Table
		(
			HIC_SEQN int null,
			AllergenName varchar(255) null,
			InactiveIngredient bit null default (0)
		)
		
	declare @PatientAllergenProfile table
		(
			HIC_SEQN int null,
			DAM_ALRGN_GRP int null,
			AllergenName varchar(255) null,
			InactiveIngredient bit null default (0)
		)
		
	declare @CrossSensitiveList table
		(
			HIC_SEQN int null,
			DAM_ALRGN_XSENSE int null,
			AllergenName varchar(255) null,
			InactiveIngredient bit null default (0)
		)
			
	declare @MedicationName varchar(255)
	declare @AllergenName varchar(255)
	declare @DescriptionName varchar(255)
	declare @InactiveIngredient bit
	declare @pk int
	declare @cnt int

	-- Part 1: step 2 and 3; step 2 is the sub-query; page 869
	insert into @Prospective_HIC_SEQN
		select HIC_SEQN from NDD_RHICL1_HIC_HICLSEQNO_LINK WITH(NOLOCK)
			where IsDelete = 0
				and HIC_SEQN <> 9870 -- exclude this ingredient code, preservative free products
				and HICL_SEQNO in (select DISTINCT HICL_SEQNO from NDD_RMEDMHL0_MED_HICLSEQNO_LINK WITH(NOLOCK)
					where IsDelete = 0
						and MED_CONCEPT_ID_TYP = 2 -- routed ROUTED_MED_ID 
						and MED_CONCEPT_ID = @proposed_ROUTED_MED_ID)

	if (@includeInactiveIngredient = 1)
	begin		 
		-- include inactive ingredient
		insert into @Prospective_HIC_SEQN
			select t1.HIC_SEQN from NDD_RMEDRIN0_RMID_INACTV_LINK t1 WITH(NOLOCK) 
				inner join NDD_RHICD5_HIC_DESC t2 WITH(NOLOCK) on t1.HIC_SEQN = t2.HIC_SEQN
			where t1.IsDelete = 0
				and t2.IsDelete = 0
				and t1.ROUTED_MED_ID = @proposed_ROUTED_MED_ID
	end

	-- Part 1: step 4; page 870
	-- get related_hic_seqn for prospective medication
	insert into @Prospective_RELATED_HIC_SEQN		
		select RELATED_HIC_SEQN from NDD_RHICHCR0_HIC_HIC_LINK t1 WITH(NOLOCK)
			inner join @Prospective_HIC_SEQN t2 on t1.IsDelete = 0
				and t1.HIC_SEQN = t2.HIC_SEQN
				and t2.HIC_SEQN <> 9870 -- exclude this ingredient code, preservative free products

	if ((@includeIngredient = 1) or (@includeCrossSensitivity = 1))
	begin
		-- Part 2; step 1; page 871
		-- get related_hic_seqn for current patient''s allergies
		insert into @PatientAllergen_RELATED_HIC_SEQN(HIC_SEQN, AllergenName, InactiveIngredient)			
			select RELATED_HIC_SEQN, t2.AllergenName, t2.InactiveIngredient
			from NDD_RHICHCR0_HIC_HIC_LINK t1 WITH(NOLOCK)
				inner join @ExistingAllergyHIC_SEQN t2 on t1.HIC_SEQN = t2.HIC_SEQN
					and t2.HIC_SEQN <> 9870 -- exclude this ingredient code, preservative free products
			where t1.IsDelete = 0
	end
			 
	-- Part 2; step 2; page 871 
	select @cnt = COUNT(*) from @Prospective_RELATED_HIC_SEQN t1
		inner join @existingAllergyHIC_SEQN t2 on t1.HIC_SEQN = t2.HIC_SEQN
	if (@cnt > 0)
	begin
		insert into @tmpAllergyAlertResults (MedicationName, AllergenName, InactiveIngredient)
			select DISTINCT @proposed_MedicationName as [MedicationName], t2.AllergenName, t2.InactiveIngredient
			from @Prospective_RELATED_HIC_SEQN t1
				inner join @existingAllergyHIC_SEQN t2 on t1.HIC_SEQN = t2.HIC_SEQN
	end
	
	if (@includeIngredient = 1)
	begin	
		-- Part 2; step 2 and step 3; page 871 ingredient-based allergy alerts exist
		-- process ingredient reaction into table @tmpAllergyAlertResults using exists rows 
		-- when possible and inserting rows when needed
		declare out_cursor cursor for
			select DISTINCT @proposed_MedicationName, t3.AllergenName, t2.HIC_DESC, t3.InactiveIngredient
			from @Prospective_RELATED_HIC_SEQN t1 
				inner join NDD_RHICD5_HIC_DESC t2 WITH(NOLOCK) on t1.HIC_SEQN = t2.HIC_SEQN
				inner join @PatientAllergen_RELATED_HIC_SEQN t3 on t3.HIC_SEQN = t2.HIC_SEQN
			where t2.IsDelete = 0
				
		open out_cursor
		fetch NEXT from out_cursor into @MedicationName, @AllergenName, @DescriptionName, @InactiveIngredient

		while (@@fetch_status <> -1)
		begin
			if (@@fetch_status <> -2)
			begin
				set @pk = 0
				select top 1 @pk = pk from @tmpAllergyAlertResults 
						where MedicationName = @MedicationName and AllergenName = @AllergenName and Ingredient is null
						order by pk
					
				if (@pk > 0)
				begin
					update @tmpAllergyAlertResults set Ingredient = @DescriptionName
						where pk = @pk
				end
				else begin
					insert into @tmpAllergyAlertResults (MedicationName, AllergenName, Ingredient, InactiveIngredient)
						values (@MedicationName, @AllergenName, @DescriptionName, @InactiveIngredient)
				end
			end --if (@@fetch_status <> -2)
						
			fetch NEXT from out_cursor into @MedicationName, @AllergenName, @DescriptionName, @InactiveIngredient
		end -- of while
		
		close out_cursor
		deallocate out_cursor
	end -- of if (@includeIngredient = 1)
	
	if (@includeAllergenGroup = 1)
	begin
		
		-- Part 2; step 4 and 5; page 871
		insert into @PatientAllergenProfile (HIC_SEQN, DAM_ALRGN_GRP, AllergenName, InactiveIngredient)
			select DISTINCT t1.HIC_SEQN, t1.DAM_ALRGN_GRP, t3.AllergenName, t3.InactiveIngredient 
			from NDD_RDAMGHC0_HIC_ALRGN_GRP_LINK t1 WITH(NOLOCK)
				inner join NDD_RDAMGHC0_HIC_ALRGN_GRP_LINK t2 WITH(NOLOCK) on t1.DAM_ALRGN_GRP = t2.DAM_ALRGN_GRP
				inner join @ExistingAllergyHIC_SEQN t3 on t2.HIC_SEQN = t3.HIC_SEQN
			where t1.IsDelete = 0
				and t2.IsDelete = 0
		
		-- Part 2; step 6; page 873
		-- process specific allergen group into table @tmpAllergyAlertResults using exists rows 
		-- when possible and inserting rows when needed
		declare out_cursor cursor for 
			select DISTINCT @proposed_MedicationName as [MedicationName], t1.AllergenName, t3.DAM_ALRGN_GRP_DESC, t1.InactiveIngredient
			from @PatientAllergenProfile t1
				inner join @Prospective_RELATED_HIC_SEQN t2 on t2.HIC_SEQN = t1.HIC_SEQN
				inner join NDD_RDAMAGD1_ALRGN_GRP_DESC t3 WITH(NOLOCK) on t1.DAM_ALRGN_GRP = t3.DAM_ALRGN_GRP
				where t3.IsDelete = 0
				order by MedicationName, t1.AllergenName

		open out_cursor
		fetch NEXT from out_cursor into @MedicationName, @AllergenName, @DescriptionName, @InactiveIngredient

		while (@@fetch_status <> -1)
		begin
			if (@@fetch_status <> -2)
			begin
				set @pk = 0
				select top 1 @pk = pk from @tmpAllergyAlertResults 
						where MedicationName = @MedicationName and AllergenName = @AllergenName and SpecificAllergenGroup is null
						order by pk
					
				if (@pk > 0)
				begin
					update @tmpAllergyAlertResults set SpecificAllergenGroup = @DescriptionName
						where pk = @pk
				end
				else begin
					insert into @tmpAllergyAlertResults (MedicationName, AllergenName, SpecificAllergenGroup, InactiveIngredient)
						values (@MedicationName, @AllergenName, @DescriptionName, @InactiveIngredient)
				end
			end --if (@@fetch_status <> -2)
						
			fetch NEXT from out_cursor into @MedicationName, @AllergenName, @DescriptionName, @InactiveIngredient
		end -- of while
		
		close out_cursor
		deallocate out_cursor
	end -- of if (@includeAllergenGroup = 1)
	
	if (@includeCrossSensitivity = 1)
	begin
		-- Part 2; step 7 and step 8; page 873 and 874			
		insert into @CrossSensitiveList (HIC_SEQN, DAM_ALRGN_XSENSE, AllergenName, InactiveIngredient)
			select DISTINCT t1.HIC_SEQN, t1.DAM_ALRGN_XSENSE, t3.AllergenName, t3.InactiveIngredient
			from NDD_RDAMXHC0_HIC_ALRGN_XSENSE_LINK t1 WITH(NOLOCK)
				inner join NDD_RDAMXHC0_HIC_ALRGN_XSENSE_LINK t2 WITH(NOLOCK) on t1.DAM_ALRGN_XSENSE = t2.DAM_ALRGN_XSENSE
				inner join @PatientAllergen_RELATED_HIC_SEQN t3 on t2.HIC_SEQN = t3.HIC_SEQN
			where t1.IsDelete = 0
				and t2.IsDelete = 0
		
		-- process cross-sensitivity reaction into table @tmpAllergyAlertResults using exists rows 
		-- when possible and inserting rows when needed
		declare out_cursor cursor for 	
			select DISTINCT @proposed_MedicationName as [MedicationName], t1.AllergenName, t2.DAM_ALRGN_XSENSE_DESC, t1.InactiveIngredient
			from @CrossSensitiveList t1
				inner join NDD_RDAMCSD1_XSENSIT_ALLERGY_DESC t2 WITH(NOLOCK) on t1.DAM_ALRGN_XSENSE = t2.DAM_ALRGN_XSENSE
				inner join @Prospective_RELATED_HIC_SEQN t3 on t1.HIC_SEQN = t3.HIC_SEQN
			where t2.IsDelete = 0
			order by MedicationName, t1.AllergenName
		open out_cursor
		fetch NEXT from out_cursor into @MedicationName, @AllergenName, @DescriptionName, @InactiveIngredient

		while (@@fetch_status <> -1)
		begin
			if (@@fetch_status <> -2)
			begin
				set @pk = 0
				select top 1 @pk = pk from @tmpAllergyAlertResults 
						where MedicationName = @MedicationName and AllergenName = @AllergenName and CrossSensitivity is null
						order by pk
					
				if (@pk > 0)
				begin
					update @tmpAllergyAlertResults set CrossSensitivity = @DescriptionName
						where pk = @pk
				end
				else begin
					insert into @tmpAllergyAlertResults (MedicationName, AllergenName, CrossSensitivity, InactiveIngredient)
						values (@MedicationName, @AllergenName, @DescriptionName, @InactiveIngredient)
				end
			end --if (@@fetch_status <> -2)
						
			fetch NEXT from out_cursor into @MedicationName, @AllergenName, @DescriptionName, @InactiveIngredient
		end -- of while
		
		close out_cursor
		deallocate out_cursor
	end -- of if (@includeCrossSensitivity = 1)
	
	-- copy @tmpAllergyAlertResults to @AllergyAlertResults
	insert @AllergyAlertResults (MedicationName, AllergenName, BaseIngredient, Ingredient, SpecificAllergenGroup, CrossSensitivity, InactiveIngredient)
			select MedicationName, AllergenName, BaseIngredient, Ingredient, SpecificAllergenGroup, CrossSensitivity, InactiveIngredient 
			from @tmpAllergyAlertResults order by MedicationName, AllergenName
				
	RETURN
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_CollectExistingAllergy_HIC_SEQN]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/10/2014
-- Description:	Returns a table of existing allergies HIC_SEQN.  If
--				the table is empty no HIC_SEQN values were found.
--
-- 01/15/2018   add changes to support IsDelete
-- 02/22/2018   made changes to support new table names.
-- =================================================================
CREATE FUNCTION [dbo].[NDD_CollectExistingAllergy_HIC_SEQN](
		@includeInactiveIngredient bit,					-- when 1 (one) inactive ingredient will be included
		@existingAllergies ExistingAllergies readonly	-- existing list of active allergies
		)
/*
	Patient allergies can be either drug names, allergens or ingredient. A 
	dam concept id type identities what the dam concept id represent. See 
	the table below for supported dam concept id types.
		
	Same as First Data Bank''s; see page 1946
	DAM_CONCEPT_ID_TYP	DAM_CONCEPT_ID_TYP_DESC		identifiers
	------------------  -----------------------		-----------------
	1					Specific Allergen Group		DAM_ALRGN_GRP
	2					Medication Name ID			MED_NAME_ID
	6					Ingredient					HIC_SEQN

*/
RETURNS
@ExistingAllergyHIC_SEQN table
(
	HIC_SEQN int null,
	AllergenName varchar(255) null,
	InactiveIngredient bit null default (0)
)
AS
begin
	declare @isInactiveIngredient bit
	declare @DAM_CONCEPT_ID_TYP int
	declare @DAM_CONCEPT_ID int
	declare @AllergenName varchar(255)
	
	-- collect HIC_SEQN values for existing allergies
	declare out_cursor cursor for 
		select DAM_CONCEPT_ID_TYP, DAM_CONCEPT_ID, AllergenName
		from @existingAllergies

	open out_cursor
	fetch NEXT from out_cursor into @DAM_CONCEPT_ID_TYP, @DAM_CONCEPT_ID, @AllergenName

	while (@@fetch_status <> -1)
	begin
		if (@@fetch_status <> -2)
		begin
			if (@DAM_CONCEPT_ID_TYP = 1)
			begin
				insert into @ExistingAllergyHIC_SEQN (HIC_SEQN, AllergenName)
					select DISTINCT t1.HIC_SEQN, @AllergenName
						from NDD_RDAMGHC0_HIC_ALRGN_GRP_LINK t1 WITH(NOLOCK)
						where t1.IsDelete = 0
							and  t1.HIC_SEQN <> 9870 -- exclude this ingredient code, preservative free products
							and t1.DAM_ALRGN_GRP = @DAM_CONCEPT_ID
			end
			else if (@DAM_CONCEPT_ID_TYP = 2)
			begin
				insert into @ExistingAllergyHIC_SEQN (HIC_SEQN, AllergenName)
					select DISTINCT t2.HIC_SEQN, @AllergenName 
					from NDD_RMEDMHL0_MED_HICLSEQNO_LINK t1 WITH(NOLOCK)
						inner join NDD_RHICL1_HIC_HICLSEQNO_LINK t2 WITH(NOLOCK) on t1.MED_CONCEPT_ID_TYP = 1 
							and t1.MED_CONCEPT_ID = @DAM_CONCEPT_ID
							and t1.HICL_SEQNO = t2.HICL_SEQNO
					where t1.IsDelete = 0
						and t2.IsDelete = 0
							
				if (@includeInactiveIngredient = 1)
				begin							
					insert into @ExistingAllergyHIC_SEQN (HIC_SEQN, AllergenName, InactiveIngredient)
						select DISTINCT t1.HIC_SEQN, @AllergenName, 1 
							from NDD_RMEDNIN0_MNID_INACTV_LINK t1 WITH(NOLOCK) 
								inner join NDD_RHICD5_HIC_DESC t2 WITH(NOLOCK) on t1.HIC_SEQN = t2.HIC_SEQN
							where t1.IsDelete = 0
								and t2.IsDelete = 0
								and  t1.med_name_id = @DAM_CONCEPT_ID
				end
			end
			else if (@DAM_CONCEPT_ID_TYP = 6)
			begin
				set @isInactiveIngredient = 0
				-- test in ingredient is inactive
				select @isInactiveIngredient = HIC_POTENTIALLY_INACTV_IND 
				from NDD_RHICD5_HIC_DESC WITH(NOLOCK)
				where IsDelete = 0 and HIC_SEQN = @DAM_CONCEPT_ID
				
				if (@isInactiveIngredient = 0)
				begin
					insert into @ExistingAllergyHIC_SEQN (HIC_SEQN, AllergenName, InactiveIngredient) 
						values (@DAM_CONCEPT_ID, @AllergenName, @isInactiveIngredient)
				end
				else if (@includeInactiveIngredient = 1)
				begin
					insert into @ExistingAllergyHIC_SEQN (HIC_SEQN, AllergenName, InactiveIngredient) 
						values (@DAM_CONCEPT_ID, @AllergenName, @isInactiveIngredient)
				end
			end
		end -- of if (@@fetch_status <> -2)
		
		fetch NEXT from out_cursor into @DAM_CONCEPT_ID_TYP, @DAM_CONCEPT_ID, @AllergenName
	end	-- of while outside

	close out_cursor
	deallocate out_cursor

	RETURN
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_FindRoutedMedID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 01/24/2014
-- Description:	Returns ROUTED_MED_ID found from either MEDID or
--				GCN_SEQNO.  If both values are supplied, then the 
--				first one found is return. The search order is the 
--				parameter order.

-- 01/24/2018   add changes to support IsDelete
-- 02/22/2018   made changes to support new table names.
-- =================================================================
CREATE FUNCTION [dbo].[NDD_FindRoutedMedID](
		@MEDID int = 0, 
		@GCN_SEQNO int = 0
		)
RETURNS int
AS
begin
	declare @ROUTED_MED_ID int
	
	set @ROUTED_MED_ID = 0
	
	if (ISNULL(@MEDID, 0) > 0)
	begin
		select top 1 @ROUTED_MED_ID = t3.ROUTED_MED_ID
		from NDD_RMIID1_MED t1 
			inner join NDD_RMIDFID1_ROUTED_DOSE_FORM_MED t2 ON t1.ROUTED_DOSAGE_FORM_MED_ID = t2.ROUTED_DOSAGE_FORM_MED_ID
			inner join NDD_RMIRMID1_ROUTED_MED t3 on t2.ROUTED_MED_ID = t3.ROUTED_MED_ID
			where t1.IsDelete = 0
				and t2.IsDelete = 0
				and t2.IsDelete = 0
				and t1.MEDID = @MEDID
	end
	if ((ISNULL(@GCN_SEQNO, 0) > 0) and (@ROUTED_MED_ID = 0))
	begin
		select top 1 @ROUTED_MED_ID = t3.ROUTED_MED_ID
		from NDD_RMIID1_MED t1 
			inner join NDD_RMIDFID1_ROUTED_DOSE_FORM_MED t2 ON t1.ROUTED_DOSAGE_FORM_MED_ID = t2.ROUTED_DOSAGE_FORM_MED_ID
			inner join NDD_RMIRMID1_ROUTED_MED t3 on t2.ROUTED_MED_ID = t3.ROUTED_MED_ID
			where t1.IsDelete = 0
				and t2.IsDelete = 0
				and t2.IsDelete = 0
				and t1.GCN_SEQNO = @GCN_SEQNO
	end

	return @ROUTED_MED_ID
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_AllergyAlert]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 01/24/2018
-- Description:	Returns a table with drug allergies enties.  If the
--				table is empty no drug allergies were found.
--
-- 01/16/2018   rewrote from 2014''s work
-- 02/22/2018   made changes to support new table names.
-- =================================================================
CREATE FUNCTION [dbo].[NDD_AllergyAlert](
		@includeInactiveIngredient bit,									-- when 1 (one) inactive ingredient will be included
		@includeIngredient bit,											-- include ingredient in allergy precautions
		@includeAllergenGroup bit,										-- include allergen group in allergy precautions
		@includeCrossSensitivity bit,									-- include cross sensitivity in allergy precautions
		@proposed_MEDID int,											-- medid of the proposed medication
		@proposed_GCN_SEQNO int,										-- gcn_seqno of the proposed medication
		@proposed_ROUTED_MED_ID int,									-- routed_med_id of the proposed medication
		@proposed_MedicationName varchar(255),							-- name of the proposed medication
		@existingActiveMedication Existing_Active_Medications readonly,	-- existing list of active drugs
		@existingAllergies ExistingAllergies readonly					-- existing list of active allergies
		)
RETURNS
@AllergyAlertResults table
(
	PK int IDENTITY NOT NULL PRIMARY KEY,
	MedicationName varchar(255) null,
	AllergenName varchar(255) null,
	BaseIngredient varchar(255),
	Ingredient varchar(255),
	SpecificAllergenGroup varchar(255) null,
	CrossSensitivity varchar(255),
	InactiveIngredient bit null default (0)
)
AS
begin
	declare @existingAllergyHIC_SEQN ExistingAllergyHIC_SEQN
	declare @MedicationName varchar(255)
	declare @MED_CONCEPT_ID int
	declare @MEDID int
	declare @GCN_SEQNO int
	declare @ROUTED_MED_ID int
	
	-- will always convert to ROUTED_MED_ID; so MED_CONCEPT_ID_TYP will be 2
	if (ISNULL(@proposed_MEDID, 0) > 0)
	begin
		set @MED_CONCEPT_ID = dbo.NDD_FindRoutedMedID(@proposed_MEDID, 0)
	end
	else if (ISNULL(@proposed_GCN_SEQNO, 0) > 0)
	begin
		set @MED_CONCEPT_ID = dbo.NDD_FindRoutedMedID(0, @proposed_GCN_SEQNO)
	end
	else begin
		set @MED_CONCEPT_ID = @proposed_ROUTED_MED_ID
	end
	
	insert into @existingAllergyHIC_SEQN
		select * from dbo.NDD_CollectExistingAllergy_HIC_SEQN (@includeInactiveIngredient, @existingAllergies)

	if (ISNULL(@MED_CONCEPT_ID, 0) > 0)
	begin
		-- only the proposed medication for allergies
		insert into @AllergyAlertResults
			select * from dbo.NDD_BaseAllergyAlert(@includeInactiveIngredient, 
						@includeIngredient, @includeAllergenGroup, @includeCrossSensitivity,
						@MED_CONCEPT_ID, @proposed_MedicationName, @existingAllergyHIC_SEQN)
	end
	else begin
		-- check all medications for allergies
		declare out_cursor cursor for 
			select MedicationName, MEDID, GCN_SEQNO, ROUTED_MED_ID
			from @existingActiveMedication

		open out_cursor
		fetch NEXT from out_cursor into @MedicationName, @MEDID, @GCN_SEQNO, @ROUTED_MED_ID

		while (@@fetch_status <> -1)
		begin
			if (@@fetch_status <> -2)
			begin
				if (ISNULL(@MEDID, 0) > 0)
				begin
					set @MED_CONCEPT_ID = dbo.NDD_FindRoutedMedID(@MEDID, 0)
				end
				else if (ISNULL(@GCN_SEQNO, 0) > 0)
				begin
					set @MED_CONCEPT_ID = dbo.NDD_FindRoutedMedID(0, @GCN_SEQNO)
				end
				else begin
					set @MED_CONCEPT_ID = @ROUTED_MED_ID
				end
				insert into @AllergyAlertResults
					select * 
					from dbo.NDD_BaseAllergyAlert(@includeInactiveIngredient, 
						@includeIngredient, @includeAllergenGroup, @includeCrossSensitivity,
						@MED_CONCEPT_ID, @MedicationName, @existingAllergyHIC_SEQN)
			end
						
			fetch NEXT from out_cursor into @MedicationName, @MEDID, @GCN_SEQNO, @ROUTED_MED_ID
		end -- of while
		
		close out_cursor
		deallocate out_cursor
	end
	
	RETURN
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_FindGCNSEQNO]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 01/24/2018
-- Description:	Returns GCN_SEQNO found with MEDID.
--
-- 02/22/2018   made changes to support new table names.
-- =================================================================
CREATE FUNCTION [dbo].[NDD_FindGCNSEQNO](
		@MEDID int = 0
		)
RETURNS int
AS
begin
	declare @GCN_SEQNO int = 0
		
	if (ISNULL(@MEDID, 0) > 0)
	begin
		select top 1 @GCN_SEQNO = t1.GCN_SEQNO
		from NDD_RMIID1_MED t1 
			where t1.IsDelete = 0
				and t1.MEDID = @MEDID
	end
	
	return @GCN_SEQNO
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_BaseDrugDiseaseContraindications]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 01/17/2018
-- Description:	Returns a table with drug-disease contraindications 
--				enties.  If the table is empty no drug-disease 
--				contraindications were found.
--
-- 01/16/2018   rewrote from 2014''s work
-- 02/22/2018   made changes to support new table names.
-- =================================================================
CREATE FUNCTION [dbo].[NDD_BaseDrugDiseaseContraindications](
		@proposed_MEDID int,						-- medid of the proposed medication
		@proposed_GCN_SEQNO int,					-- gcn_seqno of the proposed medication
		@proposed_ROUTED_MED_ID int,				-- routed_med_id of the proposed medication
		@proposed_MedicationName varchar(255),		-- name of the proposed medication
		@existingDisease ExistingDisease readonly	-- existing list of active diagnosis
		)
RETURNS
@MedicationDisease table
	(
		MedicationName varchar(255) null,
		SeverityLevel varchar(1) null,
		SeverityDescription varchar(255) null,
		NavigationCode varchar(2) null,
		NavigationDescription varchar(255) null,
		Code varchar(255),
		DiseaseDescription varchar(255) null,
		FDBDescription varchar(255) null
	)	
AS
begin
	/*
	Valid Values Table
	DDXCN_SL	Description			PRM colors
	1			Contraindication	Highest - #d00000 (red)
	2			Severe Warning		Second Highest - #e2ae4a (dark orange)
	3			Moderate Warning	Third Highest - #ffcd00 (light orange)

	
	select * from RFMLNVD0_NAVIGATION_DESC
	ML_NAV_CODE  FML_NAV_CODE_DESC 
	------------ -----------------
	01           Equal
	02           Broader
	03           Narrower
	04           Related
	*/

	declare @Proposed_DXID table
		(
			DXID int null,
			DDXCN int null,
			DDXCN_SL varchar(1),
			MedicationName varchar(255) null
		)
		
	declare @ExistingDisease_DXID table
		(
			DXID int null,
			FML_CLIN_CODE varchar(2) null,
			FML_NAV_CODE varchar(2) null,
			ICD_CD_TYPE varchar(2) null,
			Code varchar(255) null,
			DiseaseDesc varchar(255) null
		)
	
	declare @ListMatchingDXID table
		(		
			DXID int null,
			FML_NAV_CODE varchar(2) null,	
			DDXCN int null,
			DDXCN_SL varchar(1),
			MedicationName varchar(255) null,
			Code varchar(255) null,
			DiseaseDesc varchar(255) null,
			Exclude bit null default (0)
		)

	insert into @ExistingDisease_DXID(DXID, FML_CLIN_CODE, FML_NAV_CODE, ICD_CD_TYPE, Code, DiseaseDesc)
		select t1.RELATED_DXID, t1.FML_CLIN_CODE, t1.FML_NAV_CODE, t1.ICD_CD_TYPE, t1.SEARCH_ICD_CD, t2.DiseaseDesc 
		from NDD_RFMLISR1_ICD_SEARCH t1 WITH(NOLOCK) 
			inner join @existingDisease t2 on --t1.FML_CLIN_CODE = 3 -- Drug-Disease Contraindications Module
				--and 
				t1.SEARCH_ICD_CD = t2.ICD_Code
		where t1.IsDelete = 0 and t1.FML_CLIN_CODE = 3
				
	if (ISNULL(@proposed_MEDID, 0) > 0)
	begin
		insert into @Proposed_DXID(DXID, DDXCN, DDXCN_SL, MedicationName)
		select t1.DXID, t1.DDXCN, t1.DDXCN_SL, @proposed_MedicationName
		from NDD_RDDCMMA1_CONTRA_MSTR t1 WITH(NOLOCK)
			inner join NDD_RDDCMGC0_CONTRA_GCNSEQNO_LINK t2 WITH(NOLOCK) on t1.DDXCN = t2.DDXCN
				and t2.GCN_SEQNO = dbo.NDD_FindGCNSEQNO(@proposed_MEDID)
		where t1.IsDelete = 0
			and t2.IsDelete = 0
		order by t1.DDXCN_SL
	end
	else if (ISNULL(@proposed_GCN_SEQNO, 0) > 0)
	begin
		insert into @Proposed_DXID(DXID, DDXCN, DDXCN_SL, MedicationName)
		select t1.DXID, t1.DDXCN, t1.DDXCN_SL, @proposed_MedicationName
		from NDD_RDDCMMA1_CONTRA_MSTR t1 WITH(NOLOCK)
			inner join NDD_RDDCMGC0_CONTRA_GCNSEQNO_LINK t2 WITH(NOLOCK) on t1.DDXCN = t2.DDXCN
				and t2.GCN_SEQNO = @proposed_GCN_SEQNO
		where t1.IsDelete = 0
			and t2.IsDelete = 0
		order by t1.DDXCN_SL
	end
	else begin
		insert into @Proposed_DXID(DXID, DDXCN, DDXCN_SL, MedicationName)
		select t1.DXID, t1.DDXCN, t1.DDXCN_SL, @proposed_MedicationName
		from NDD_RDDCMMA1_CONTRA_MSTR t1 WITH(NOLOCK)
			inner join NDD_RDDCMRM0_ROUTED_MED_LINK t2 WITH(NOLOCK) on t1.DDXCN = t2.DDXCN
				and t2.ROUTED_MED_ID = @proposed_ROUTED_MED_ID
		where t1.IsDelete = 0
			and t2.IsDelete = 0
		order by t1.DDXCN_SL
	end

	insert into @ListMatchingDXID (DXID, DDXCN, DDXCN_SL, FML_NAV_CODE, MedicationName, Code, DiseaseDesc, Exclude)
		select t1.DXID, t1.DDXCN, t1.DDXCN_SL, t2.FML_NAV_CODE, t1.MedicationName, t2.Code, t2.DiseaseDesc,
		ISNULL((select top 1 1 
		from NDD_RFMLISX0_ICD_SEARCH_EXCLUSION t3 WITH(NOLOCK)
			where t3.IsDelete = 0
			and t2.FML_CLIN_CODE = t3.FML_CLIN_CODE
			and t2.Code = t3.SEARCH_ICD_CD
			and t2.ICD_CD_TYPE = t3.ICD_CD_TYPE
			and t2.DXID = t3.RELATED_DXID
			and t1.DDXCN = t3.CLIN_DRUG_GROUP
			), 0) as [Exclude]
		from @Proposed_DXID t1
			inner join @ExistingDisease_DXID t2 on t1.DXID = t2.DXID
			
	insert into @MedicationDisease (MedicationName, SeverityLevel, 
						SeverityDescription, 
						NavigationCode, NavigationDescription, Code, DiseaseDescription, FDBDescription)
		select t1.MedicationName, t1.DDXCN_SL,
				case t1.DDXCN_SL when ''1'' then ''Absolute Contraindication'' 
					else case t1.DDXCN_SL when ''2'' then ''Severe Warning'' 
						else case t1.DDXCN_SL when ''3'' then ''Moderate Warning'' end
					end
				end as [SeverityDescription],
				t3.FML_NAV_CODE, t3.FML_NAV_CODE_DESC,
				t1.Code, t1.DiseaseDesc, t2.DXID_DESC100
		from @ListMatchingDXID t1
		inner join NDD_RFMLDX0_DXID t2 WITH(NOLOCK) on t1.Exclude = 0 and t1.DXID = t2.DXID
		inner join NDD_RFMLNVD0_NAVIGATION_DESC t3 WITH(NOLOCK) on t1.FML_NAV_CODE = t3.FML_NAV_CODE
		where t2.IsDelete = 0
			and t3.IsDelete = 0

	RETURN
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_BaseDrugToDrugInteraction]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 01/26/2018
-- Description:	Returns table enties for any drug to drug
--				interactions.  If the table is empty no 
--				interactions were found.
--
-- 02/22/2018   made changes to support new table names.
-- =================================================================
CREATE FUNCTION [dbo].[NDD_BaseDrugToDrugInteraction](
		@proposed_MEDID int,											-- medid of the proposed medication
		@proposed_GCN_SEQNO int,										-- gcn_seqno of the proposed medication
		@proposed_ROUTED_MED_ID int,									-- routed_med_id of the proposed medication
		@proposed_MedicationName varchar(255),							-- name of the proposed medication
		@existingActiveMedication Existing_Active_Medications readonly	-- existing list of active drugs
		)
RETURNS 
@InteractionResults table
(
	MedicationName1 varchar(255) null,
	MedicationName2 varchar(255) null,
	Severity_Level varchar(1) null,
	SeverityLevelDescription varchar(255) null,
	SeverityDescription varchar(MAX) null,
	ClinicalEffectText1 varchar(100) null,
	ClinicalEffectText2 varchar(100) null,
	ClinicalEffectText3 varchar(100) null,
	ClinicalEffectText4 varchar(100) null,
	InteractionDescription varchar(255) null,
	DDI_CODEX int null
)
AS
BEGIN
/*
	see page 2325
	Valid values column IAMIDENTN, "LineIdentify"
	"A" Mechanism of Action
	"B" Blank Line
	"D" Discussion
	"E" Clinical Effects
	"L" Severity Level
	"M" Patient Management
	"P" Predisposing Factors
	"R" References
	"T" Monograph Title
	
	see page 1984
	DDI_SL Values		Severity Level Description			Severity Level Implications								PRM colors
	-------------		--------------------------------	------------------------------------------------------	-----------------------------
		1				Contraindicated Drug Combination	This drug combination is contraindicated and generally	Highest - #d00000 (red)
															should not be dispensed or administered...

		2				Severe Interaction					Action is required to reduce risk of severe adverse		Second Highest - #e2ae4a (dark orange)
															interaction.
		3				Moderate Interaction				Assess risk to patient and take action as needed.		Third Highest - #ffcd00 (light orange)
		
		9				Undetermined Severity –				Assess risk to patient and take action as needed.		Fourth Highest/Lowest - #d9e986 (light green)
						Alternative Therapy Interaction
*/

	declare @Proposed_DDI_CODEX table
	(
		DDI_CODEX int NULL
	)
	
	declare @Existing_DDI_CODEX table
	(
		DDI_CODEX int NULL
	)
	
	declare @32000_DDI_CODEX table
	(
		DDI_CODEX int NULL
	)
	
	if (ISNULL(@proposed_MEDID, 0) > 0)
	begin
		insert into @Proposed_DDI_CODEX(DDI_CODEX)
			select DDI_CODEX from NDD_RADIMGC4_GCNSEQNO_LINK WITH(NOLOCK) where GCN_SEQNO = dbo.NDD_FindGCNSEQNO(@proposed_MEDID)
	end
	else if (ISNULL(@proposed_GCN_SEQNO, 0) > 0)
	begin
		insert into @Proposed_DDI_CODEX(DDI_CODEX)
			select DDI_CODEX from NDD_RADIMGC4_GCNSEQNO_LINK WITH(NOLOCK) where GCN_SEQNO = @proposed_GCN_SEQNO
	end
	else if (ISNULL(@proposed_ROUTED_MED_ID, 0) > 0)
	begin
		insert into @Proposed_DDI_CODEX(DDI_CODEX)
			select DDI_CODEX from NDD_RDDIMRM0_ROUTED_MED_LINK WITH(NOLOCK) where ROUTED_MED_ID = @proposed_ROUTED_MED_ID
	end
	
	if (exists (select * from @Proposed_DDI_CODEX))
	begin
		declare @GCN_SEQNO int
		declare @ROUTED_MED_ID int
		declare @MedicationName varchar(255)
	
		declare @DDI_CODEX int
		declare @DDI_MONOX int
		declare @tmpStr varchar(255)
		declare @InteractionDescription varchar(255)
		declare @ClinicalEffectText1 varchar(100)
		declare @ClinicalEffectText2 varchar(100)
		declare @ClinicalEffectText3 varchar(100)
		declare @ClinicalEffectText4 varchar(100)
		declare @SeverityLevelDescription varchar(255)
		declare @SeverityDescription varchar(MAX)
		declare @IAMIDENTN varchar(1)
		declare @DDI_SL varchar(1)
		declare @i int
		
		declare out_cursor cursor for 
			select MedicationName, 
					CASE WHEN MEDID is not null and MEDID > 0 THEN dbo.NDD_FindGCNSEQNO(MEDID) ELSE GCN_SEQNO END as [GCN_SEQNO],
					ROUTED_MED_ID
			from @existingActiveMedication

		open out_cursor
		fetch NEXT from out_cursor into @MedicationName, @GCN_SEQNO, @ROUTED_MED_ID

		while (@@fetch_status <> -1)
		begin
			if (@@fetch_status <> -2)
			begin
				delete @Existing_DDI_CODEX
			
				if (ISNULL(@GCN_SEQNO, 0) > 0)
				begin
					insert into @Existing_DDI_CODEX(DDI_CODEX)
						select DDI_CODEX from NDD_RADIMGC4_GCNSEQNO_LINK WITH(NOLOCK) where GCN_SEQNO = @GCN_SEQNO
				end
				else if (ISNULL(@ROUTED_MED_ID, 0) > 0)
				begin
					insert into @Existing_DDI_CODEX(DDI_CODEX)
						select DDI_CODEX from NDD_RDDIMRM0_ROUTED_MED_LINK WITH(NOLOCK) where ROUTED_MED_ID = @ROUTED_MED_ID
				end
			
				insert into @32000_DDI_CODEX (DDI_CODEX)
				select t1.DDI_CODEX
				from @Proposed_DDI_CODEX t1 
				inner join @Existing_DDI_CODEX t2 on t1.DDI_CODEX + t2.DDI_CODEX = 32000

				declare in_cursor cursor for 
					select DDI_CODEX from @32000_DDI_CODEX

				open in_cursor
				fetch NEXT from in_cursor into @DDI_CODEX

				while (@@fetch_status <> -1)
				begin
					if (@@fetch_status <> -2)
					begin
						-- interaction found
						set @InteractionDescription = null
						set @SeverityLevelDescription = null
						set @SeverityDescription = null
						set @ClinicalEffectText1 = null
						set @ClinicalEffectText2 = null
						set @ClinicalEffectText3 = null
						set @ClinicalEffectText4 = null
						set @DDI_MONOX = 0
						set @DDI_SL = null
						
						declare el_cursor cursor for
							select t2.ADI_EFFTXT 
							from NDD_RADIMIE4_CLIN_EFFECTS_LINK t1 WITH(NOLOCK) 
							inner join NDD_RADIMEF0_CLIN_EFFECT t2 WITH(NOLOCK) on t1.ADI_EFFTC = t2.ADI_EFFTC
							where t1.DDI_CODEX = @DDI_CODEX
							
						open el_cursor
						fetch NEXT from el_cursor into @tmpStr

						while (@@fetch_status <> -1)
						begin
							if (@@fetch_status <> -2)
							begin
								if (@ClinicalEffectText1 is null)
								begin
									set @ClinicalEffectText1 = @tmpStr
								end
								else if (@ClinicalEffectText2 is null)
								begin
									set @ClinicalEffectText2 = @tmpStr
								end
								else if (@ClinicalEffectText3 is null)
								begin
									set @ClinicalEffectText3 = @tmpStr
								end
								else if (@ClinicalEffectText4 is null)
								begin
									set @ClinicalEffectText4 = @tmpStr
								end
							end
							fetch NEXT from el_cursor into @tmpStr
						end -- of inside while
									
						close el_cursor
						deallocate el_cursor
							

						select @InteractionDescription = DDI_DES
						from NDD_RADIMMA5_MSTR 
						where IsDelete = 0 and DDI_CODEX = @DDI_CODEX
						
						select @DDI_MONOX = DDI_MONOX, @DDI_SL = DDI_SL 
						from NDD_RADIMMA5_MSTR 
						where IsDelete = 0 and DDI_CODEX = @DDI_CODEX
				
						if (ISNULL(@DDI_SL,'''') <> '''')
						begin
							-- get severity description
							set @SeverityDescription = ''''
											
							declare sl_cursor cursor for 
								select DDI_SLTXT from NDD_RADIMSL1_SEVER_LEVEL
								where IsDelete = 0 and DDI_SL = @DDI_SL
								order by DDI_SLSN

							open sl_cursor
							fetch NEXT from sl_cursor into @tmpStr

							while (@@fetch_status <> -1)
							begin
								if (@@fetch_status <> -2)
								begin
									set @SeverityDescription = @SeverityDescription + '' '' + @tmpStr
								end
								fetch NEXT from sl_cursor into @tmpStr
							end -- of inside while
									
							close sl_cursor
							deallocate sl_cursor

							set @i = CHARINDEX('':'', @SeverityDescription, 1)
							if (@i > 0)
							begin
								set @SeverityLevelDescription = LTRIM(RTRIM(SUBSTRING(@SeverityDescription, 1, @i - 1)))		
								set @SeverityDescription = LTRIM(RTRIM(SUBSTRING(@SeverityDescription, @i + 1, LEN(@SeverityDescription))))
							end

						end -- of if (@DDI_SL > 0)
				
						insert into @InteractionResults(MedicationName1, MedicationName2, 
										Severity_Level, SeverityLevelDescription,
										SeverityDescription,
										ClinicalEffectText1, ClinicalEffectText2, ClinicalEffectText3, ClinicalEffectText4,
										InteractionDescription, DDI_CODEX)
							values (@proposed_MedicationName, @MedicationName,
										@DDI_SL, @SeverityLevelDescription,
										@SeverityDescription,
										@ClinicalEffectText1, @ClinicalEffectText2, @ClinicalEffectText3, @ClinicalEffectText4,
										@InteractionDescription, @DDI_CODEX)
					end -- of if (@@fetch_status <> -2) in_cursor
					
					fetch NEXT from in_cursor into @DDI_CODEX
				end -- of while (@@fetch_status <> -1) in_cursor
				
				close in_cursor
				deallocate in_cursor
			end
		
			fetch NEXT from out_cursor into @MedicationName, @GCN_SEQNO, @ROUTED_MED_ID
		end -- of while (@@fetch_status <> -1) out_cursor

		close out_cursor
		deallocate out_cursor
	end -- of if (exists (select * from @Proposed_DDI_CODEX))

	RETURN
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_BaseDuplicateIngredient]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- ===================================================================
-- Author:		CHM
-- Create date: 01/18/2018
-- Description:	Returns a table with duplicate ingredient enties. If 
--				the table is empty no duplicate ingredient were found.
--
-- 01/18/2018   rewrote from 2014''s work
-- 02/22/2018   made changes to support new table names.
-- ===================================================================
CREATE FUNCTION [dbo].[NDD_BaseDuplicateIngredient](
		@proposed_MEDID int,											-- medid of the proposed medication
		@proposed_GCN_SEQNO int,										-- gcn_seqno of the proposed medication
		@proposed_ROUTED_MED_ID int,									-- routed_med_id of the proposed medication
		@proposed_MedicationName varchar(255),							-- name of the proposed medication
		@existingActiveMedication Existing_Active_Medications readonly	-- existing list of active drugs
		)

RETURNS 
@DuplicateIngredient table
	(
		MedicationName1 varchar(255) null,
		MedicationName2 varchar(255) null,
		IngredientList varchar(MAX) null,
		ListCount int null
	)
	
AS
begin
	declare @Prospective_HIC_SEQN Table
		(
			MedicationName varchar(255) null,
			HIC_SEQN int null,
			HIC_DESC varchar(255) null
		)

	declare @existing_HIC_SEQN Table
		(
			MedicationName varchar(255) null,
			HIC_SEQN int null,
			HIC_DESC varchar(255) null
		)
		
	declare @MEDID int
	declare @GCN_SEQNO int
	declare @ROUTED_MED_ID int
	declare @MedicationName varchar(255)
	declare @Ingredient varchar(255)
	declare @IngredientList varchar(MAX)
	declare @HICL_SEQNO int
	declare @cnt1 int
	declare @cnt2 int

	if (ISNULL(@proposed_MEDID, 0) > 0)
	begin
		 set @GCN_SEQNO = dbo.NDD_FindGCNSEQNO(@proposed_MEDID)
	end
	else if (ISNULL(@proposed_GCN_SEQNO, 0) > 0)
	begin
		 set @GCN_SEQNO = @proposed_GCN_SEQNO
	end
	else begin
		select top 1 @GCN_SEQNO = t1.GCN_SEQNO
		from NDD_RMIID1_MED t1 WITH(NOLOCK) 
			inner join NDD_RMIDFID1_ROUTED_DOSE_FORM_MED t2 WITH(NOLOCK) ON t1.ROUTED_DOSAGE_FORM_MED_ID = t2.ROUTED_DOSAGE_FORM_MED_ID
		where t1.IsDelete = 0
			and t2.IsDelete = 0
			and t2.ROUTED_MED_ID = @proposed_ROUTED_MED_ID
	end

	select @HICL_SEQNO = HICL_SEQNO 
		from NDD_RGCNSEQ4_GCNSEQNO_MSTR t1 WITH(NOLOCK)
		where t1.IsDelete = 0
			and t1.GCN_SEQNO = @GCN_SEQNO
	
	insert into @Prospective_HIC_SEQN(MedicationName, HIC_SEQN, HIC_DESC)
		select @proposed_MedicationName, t1.HIC_SEQN, t2.HIC_DESC from NDD_RHICL1_HIC_HICLSEQNO_LINK t1 WITH(NOLOCK)
				inner join NDD_RHICD5_HIC_DESC t2 WITH(NOLOCK) on t1.HIC = t2.HIC
		where t1.IsDelete = 0
			and t2.IsDelete = 0
			and t1.HICL_SEQNO = @HICL_SEQNO
		
	declare out_cursor cursor for 
		select MedicationName, MEDID, GCN_SEQNO, ROUTED_MED_ID 
			from @existingActiveMedication

	open out_cursor
	fetch NEXT from out_cursor into @MedicationName, @MEDID, @GCN_SEQNO, @ROUTED_MED_ID

	while (@@fetch_status <> -1)
	begin
		if (@@fetch_status <> -2)
		begin
			set @cnt2 = 0
			set @IngredientList = ''''
			delete @existing_HIC_SEQN

			if (ISNULL(@MEDID, 0) > 0)
			begin
				set @GCN_SEQNO = dbo.NDD_FindGCNSEQNO(@MEDID)
			end
			else if (ISNULL(@ROUTED_MED_ID, 0) > 0)
			begin
				select top 1 @GCN_SEQNO = t1.GCN_SEQNO
				from NDD_RMIID1_MED t1 WITH(NOLOCK) 
					inner join NDD_RMIDFID1_ROUTED_DOSE_FORM_MED t2 WITH(NOLOCK) ON t1.ROUTED_DOSAGE_FORM_MED_ID = t2.ROUTED_DOSAGE_FORM_MED_ID
				where t1.IsDelete = 0
					and t2.IsDelete = 0
					and t2.ROUTED_MED_ID = @ROUTED_MED_ID
			end
			
			set @HICL_SEQNO = 0
			select @HICL_SEQNO = HICL_SEQNO from NDD_RGCNSEQ4_GCNSEQNO_MSTR t1 WITH(NOLOCK) where t1.IsDelete = 0 and t1.GCN_SEQNO = @GCN_SEQNO
			
			insert into @existing_HIC_SEQN(MedicationName, HIC_SEQN, HIC_DESC)
				select @proposed_MedicationName, t1.HIC_SEQN, t2.HIC_DESC from NDD_RHICL1_HIC_HICLSEQNO_LINK t1 WITH(NOLOCK)
						inner join NDD_RHICD5_HIC_DESC t2 WITH(NOLOCK) on t1.HIC = t2.HIC
				where  t1.IsDelete = 0
					and t2.IsDelete = 0
					and t1.HICL_SEQNO = @HICL_SEQNO
			
			select @cnt1 = COUNT(*) from @Prospective_HIC_SEQN t1 
				inner join @existing_HIC_SEQN t2 on t1.HIC_SEQN = t2.HIC_SEQN
			if (@cnt1 > 0)
			begin
				set @cnt2 = 0
					
				declare in_cursor cursor for 
					select DISTINCT t1.HIC_DESC from @Prospective_HIC_SEQN t1 
						inner join @existing_HIC_SEQN t2 on t1.HIC_SEQN = t2.HIC_SEQN
						
				open in_cursor
				fetch NEXT from in_cursor into @Ingredient

				while (@@fetch_status <> -1)
				begin
					if (@@fetch_status <> -2)
					begin			
						set @cnt2 = @cnt2 + 1
						if (LEN(@IngredientList) > 0)
						begin
							if (@cnt1 = @cnt2)
							begin
								set @IngredientList = @IngredientList + '' and '' 
							end
							else begin
								set @IngredientList = @IngredientList + '', '' 
							end
						end
						
						set @IngredientList = @IngredientList + @Ingredient
					end -- of if (@@fetch_status <> -2) 
					
					fetch NEXT from in_cursor into @Ingredient
				end	-- of while outside

				close in_cursor
				deallocate in_cursor
				
				if (LEN(@IngredientList) > 0)
				begin
					insert into @DuplicateIngredient (MedicationName1, MedicationName2, IngredientList, ListCount)
						values (@proposed_MedicationName, @MedicationName, @IngredientList, @cnt2)
				end
						
			end
		end -- of if (@@fetch_status <> -2) 

		fetch NEXT from out_cursor into @MedicationName, @MEDID, @GCN_SEQNO, @ROUTED_MED_ID
	end	-- of while outside

	close out_cursor
	deallocate out_cursor
	
	return
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_BaseDuplicateTherapy]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 01/23/2018
-- Description:	Returns a table with duplicate therapy enties.  If 
--				the table is empty no duplicate therapy were found.
--
-- 01/23/2018   rewrote from 2014''s work
-- 02/22/2018   made changes to support new table names.
-- =================================================================
CREATE FUNCTION [dbo].[NDD_BaseDuplicateTherapy](
		@proposed_MEDID int,											-- medid of the proposed medication
		@proposed_GCN_SEQNO int,										-- gcn_seqno of the proposed medication
		@proposed_ROUTED_MED_ID int,									-- routed_med_id of the proposed medication
		@proposed_MedicationName varchar(255),							-- name of the proposed medication
		@existingActiveMedication Existing_Active_Medications readonly	-- existing list of active drugs
		)

RETURNS 
@DuplicateTherapy table
(
	MedicationName1 varchar(255) null,
	MedicationName2 varchar(255) null,
	DPT_Allowance int null,
	ClassDescription varchar(MAX) null
)
AS
begin
	declare @Proposed_Class_ID table
	(
		MedicationName varchar(255) NULL,
		DPT_CLASS_ID int,
		DPT_CLASS_DESC varchar(125) null,
		DPT_ALLOWANCE int null
	)

	declare @ExistingClass_ID table
	(
		MedicationName varchar(255) NULL,
		DPT_CLASS_ID int,
		DPT_CLASS_DESC varchar(125) null
	)

	declare @ClassCount table
	(
		DPT_CLASS_ID int,
		DPT_ALLOWANCE int,
		Found_Count int
	)

	declare @DPT_CLASS_ID int
	declare @DPT_ALLOWANCE int
	declare @GCN_SEQNO int
	declare @ROUTED_MED_ID int
	declare @MedicationName varchar(255)
		
	if (ISNULL(@proposed_MEDID, 0) > 0)
	begin	
		insert into @Proposed_Class_ID (MedicationName, DPT_CLASS_ID, DPT_CLASS_DESC, DPT_ALLOWANCE)
		select @proposed_MedicationName, DPT_CLASS_ID, DPT_CLASS_DESC, DPT_ALLOWANCE 
		from NDD_RDPTCL0_CLASS_ID WITH(NOLOCK)
		where IsDelete = 0 and DPT_CLASS_ID in 
			(
				select DPT_CLASS_ID 
				from NDD_RDPTGC0_GCNSEQNO_LINK WITH(NOLOCK) 
				where IsDelete = 0 and GCN_SEQNO = dbo.NDD_FindGCNSEQNO(@proposed_MEDID)
			)
	end
	else if (ISNULL(@proposed_GCN_SEQNO, 0) > 0)
	begin	
		insert into @Proposed_Class_ID (MedicationName, DPT_CLASS_ID, DPT_CLASS_DESC, DPT_ALLOWANCE)
		select @proposed_MedicationName, DPT_CLASS_ID, DPT_CLASS_DESC, DPT_ALLOWANCE 
		from NDD_RDPTCL0_CLASS_ID WITH(NOLOCK)
		where IsDelete = 0 and DPT_CLASS_ID in 
			(
				select DPT_CLASS_ID 
				from NDD_RDPTGC0_GCNSEQNO_LINK WITH(NOLOCK) 
				where IsDelete = 0 and GCN_SEQNO = @proposed_GCN_SEQNO
			)
	end
	else begin
		insert into @Proposed_Class_ID (MedicationName, DPT_CLASS_ID, DPT_CLASS_DESC, DPT_ALLOWANCE)
		select @proposed_MedicationName, DPT_CLASS_ID, DPT_CLASS_DESC, DPT_ALLOWANCE 
		from NDD_RDPTCL0_CLASS_ID WITH(NOLOCK)
		where IsDelete = 0 and DPT_CLASS_ID in 
			(
				select DPT_CLASS_ID 
				from NDD_RDPTRTM0_ROUTED_MED_LINK WITH(NOLOCK)
				where IsDelete = 0 and ROUTED_MED_ID = @proposed_ROUTED_MED_ID
			)
	end

	-- nothing else to do if there are no proposed class ids
	if (exists (select * from @Proposed_Class_ID))
	begin
		-- get each active medication dpt class list
		declare out_cursor cursor for 
			select MedicationName,
			(CASE WHEN MEDID is not null and MEDID > 0 THEN dbo.NDD_FindGCNSEQNO(MEDID) ELSE GCN_SEQNO END) as [GCN_SEQNO],
			ROUTED_MED_ID 
			from @existingActiveMedication

		open out_cursor
		fetch NEXT from out_cursor into @MedicationName, @GCN_SEQNO, @ROUTED_MED_ID
		
		while (@@fetch_status <> -1)
		begin
			if (@@fetch_status <> -2)
			begin
				if (ISNULL(@GCN_SEQNO, 0) > 0)
				begin	
					insert into @ExistingClass_ID (MedicationName, DPT_CLASS_ID, DPT_CLASS_DESC)
					select @MedicationName, DPT_CLASS_ID, DPT_CLASS_DESC
					from NDD_RDPTCL0_CLASS_ID WITH(NOLOCK)
					where IsDelete = 0
						-- only add class ids that are in the proposed class table
						and DPT_CLASS_ID in (select DPT_CLASS_ID from @Proposed_Class_ID)
						and DPT_CLASS_ID in 
						(
							select DPT_CLASS_ID 
							from NDD_RDPTGC0_GCNSEQNO_LINK WITH(NOLOCK)
							where IsDelete = 0 and GCN_SEQNO = @GCN_SEQNO
						)
				end
				else begin
					insert into @ExistingClass_ID (MedicationName, DPT_CLASS_ID, DPT_CLASS_DESC)
					select @MedicationName, DPT_CLASS_ID, DPT_CLASS_DESC
					from NDD_RDPTCL0_CLASS_ID WITH(NOLOCK)
					where IsDelete = 0
						-- only add class ids that are in the proposed class table
						and DPT_CLASS_ID in (select DPT_CLASS_ID from @Proposed_Class_ID)
						and DPT_CLASS_ID in 
						(
							select DPT_CLASS_ID 
							from NDD_RDPTRTM0_ROUTED_MED_LINK WITH(NOLOCK)
							where IsDelete = 0 and ROUTED_MED_ID = @ROUTED_MED_ID
						)
				end

			end -- of if (@@fetch_status <> -2) outside
					
			fetch NEXT from out_cursor into @MedicationName, @GCN_SEQNO, @ROUTED_MED_ID
		end -- of while outside
				
		close out_cursor
		deallocate out_cursor

		-- nothing else to do if there are no existing class ids
		if (exists (select * from @ExistingClass_ID))
		begin
			declare out1_cursor cursor for 
			select MedicationName, DPT_CLASS_ID
			from @ExistingClass_ID

			open out1_cursor
			fetch NEXT from out1_cursor into @MedicationName, @DPT_CLASS_ID
		
			while (@@fetch_status <> -1)
			begin
				if (@@fetch_status <> -2)
				begin
					-- if class id is already in table class count, add one to found count
					if (exists (select * from @ClassCount where DPT_CLASS_ID = @DPT_CLASS_ID))
					begin
						update @ClassCount set Found_Count = Found_Count + 1 where DPT_CLASS_ID = @DPT_CLASS_ID
					end
					else begin
						-- get DPT_ALLOWANCE from proposed class id table
						select @DPT_ALLOWANCE = DPT_ALLOWANCE from @Proposed_Class_ID where DPT_CLASS_ID = @DPT_CLASS_ID
						-- add new row in table class count table
						insert into @ClassCount (DPT_CLASS_ID, DPT_ALLOWANCE, Found_Count)
							values (@DPT_CLASS_ID, @DPT_ALLOWANCE, 1)
					end
				end
				
				fetch NEXT from out1_cursor into @MedicationName, @DPT_CLASS_ID
			end -- while out1
			
			close out1_cursor
			deallocate out1_cursor
		end

		if (exists (select * from @ClassCount))
		begin
			insert into @DuplicateTherapy (MedicationName1, MedicationName2, DPT_Allowance, ClassDescription)
			select t1.MedicationName, t2.MedicationName, t1.DPT_ALLOWANCE, t2.DPT_CLASS_DESC
			from @Proposed_Class_ID t1
				inner join  @ExistingClass_ID t2 on t1.DPT_CLASS_ID = t2.DPT_CLASS_ID
				inner join @ClassCount t3 on t1.DPT_CLASS_ID = t3.DPT_CLASS_ID
			-- is class id found count greater than the dpt allowance
			where t3.Found_Count > t3.DPT_ALLOWANCE
		end
	end

	RETURN
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_DetailDoseRangeChecking]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 05/07/2018
-- Description:	Returns a table with detail dose range enties. If 
--				rows are not return, no detail dose range data is 
--				available. If any errors occur, a row with the error
--				in the column “ErrorMsg” column will return.
-- 
-- 11/20/2018 - added to return dose range info using DR2_RT (Route 
--				of Administration Indicator)
--
-- NOTES:
--		Column names that start with "Adjusted" are values 
--		adjusted for weight or body surface area as requried.
--
--		Column names that start with "NTE" which is short
--		for "Not To Exceed".
--
-- =================================================================

CREATE FUNCTION [dbo].[NDD_DetailDoseRangeChecking](
	@proposed_GCN_SEQNO int,				-- gcn_seqno of the proposed medication	
	@ageInDays [numeric](5, 0),				-- patient''s age in days
	@weightKg decimal(14, 6),				-- patient weight in kilogram
	@heightCM decimal(14, 6),				-- patient''s height in centimeters
	@GestationalAgeInWeeks numeric(2, 0),	-- patient’s gestational birth age in weeks
	@doseTypeIndicator varchar(2),			-- 01 - LOADING  02 - MAINTENANCE  07 - SINGLE DOSE, will default to maintenance if null
	@DXID int
		)
RETURNS
@NDD_DetailDosingRangeValues table
(
	WeightRequired bit not null,
	BodySurfaceAreaRequired bit not null,
	LowDose decimal(14, 6) null,
	LowDoseUnits varchar(60),
	HighDose decimal(14, 6) null,
	HighDoseUnits varchar(60),
	MaximumDosePerDay decimal(14, 6) null,
	MaximumDosePerDayUnits varchar(60) null,
	MaximumSingleDose decimal(14, 6) null,
	MaximumSingleDoseUnits varchar(60) null,
	MaximumLifetimeDose decimal(14, 6) null,
	MaximumLifetimeDoseUnits varchar(60) null,
	NTEAmountPerSingleDose decimal(14, 6) null,
	NTEAmountPerSingleDoseUnits varchar(60) null,
	LowFrequency decimal(4, 2) null,
	HighFrequency decimal(4, 2) null,
	LowDuration decimal(5, 0) null,
	HighDuration decimal(5, 0) null,
	AdjustedLowDose decimal(14, 6) null,
	AdjustedHighDose decimal(14, 6) null,
	AdjustedMaximumSingleDose decimal(14, 6) null,
	AdjustedMaximumDosePerDay decimal(14, 6) null,
	AdjustedMaximumLifetimeDose decimal(14, 6) null,
	AdjustedNTEAmountPerSingleDose decimal(14, 6) null,
	BodySurfaceArea decimal(14, 6) NULL,
	ErrorMsg varchar(1024) null
)
AS
begin
	declare @resultFound bit = 0
	declare @errorMsg varchar(1024) = ''''
	declare @missingHeight varchar(255) = ''missing requried height''
	declare @missingWeight varchar(255) = ''missing requried weight''
	declare @weightInGrams decimal(14, 6) = @weightKg * 1000 -- convert kg to grams
	--body surface area = 0.007184 * heigth(cm) to the 0.725 power * weight(kg) to the 0.425 power. Du Bois formula
	declare @BodySurfaceArea decimal(14, 6) = 0.007184 * POWER(@heightCM, 0.725) * POWER(@weightKg,0.425)


	declare @DOSING_AGE_SOURCE_ID numeric(4, 0)
	declare @NEOM_GEST_BIRTH_AGE_REQ_IND varchar(1) -- If NEOM_GEST_BIRTH_AGE_REQ_IND equals 1, the gestational age at birth is required
	declare @WEIGHT_REQ_IND varchar(1)		-- Weight Required Indicator; equals 1, the current weight is required
	declare @DR2_LOFREQ numeric(4, 2) = 0	-- Low Frequency of Administration
	declare @DR2_HIFREQ numeric(4, 2) = 0	-- High Frequency of Administration
	declare @DR2_LODOTX numeric(5, 0) = 0	-- Low Duration of Therapy
	declare @DR2_HIDOTX numeric(5, 0) = 0	-- High Duration of Therapy

	declare @DR2_LODOSD numeric(8, 3) = 0	-- Low Dose Per Day
	declare @DR2_LODOSU varchar(2) = ''''		-- Low Dose Per Day Units Code

	declare @DR2_HIDOSD numeric(8, 3) = 0	-- High Dose Per Day
	declare @DR2_HIDOSU varchar(2) = ''''		-- High Dose Per Day Units Code

	declare @DR2_MXDOSD numeric(8, 3) = 0	-- Maximum Dose Per Day
	declare @DR2_MXDOSU varchar(2) = ''''		-- Maximum Dose Per Day Units Code

	declare @DR2_MX1DOS numeric(8, 3) = 0	-- Maximum Amount Per Single Dose
	declare @DR2_MX1DSU varchar(2) = ''''		-- Maximum Amount Per Single Dose Units Code

	declare @DR2_MXLIFD numeric(8, 3) = 0	-- Maximum Lifetime Dose
	declare @DR2_MXLIFU varchar(2) = ''''		-- Maximum Lifetime Dose Units Code

	declare @NTE_SINGLE_DOSE numeric(8, 3) = 0			-- Not-to-Exceed Amount Per Single Dose
	declare @NTE_SINGLE_DOSE_UNIT_CODE varchar(2) = ''''	-- Not-to-Exceed Amount Per Single Dose Units Code
	
	declare @UNITS_CTYP varchar(1)
	declare @AdjustedLowDose decimal(14, 6) 
	declare @AdjustedHighDose decimal(14, 6)
	declare @AdjustedMaximumSingleDose decimal(14, 6)
	declare @AdjustedMaximumDosePerDay decimal(14, 6)
	declare @AdjustedMaximumLifetimeDose decimal(14, 6)
	declare @AdjustedNTE_SINGLE_DOSE decimal(14, 6)

	declare @WeightRequired bit = 0
	declare @BodySurfaceAreaRequired bit = 0

	declare @DR2_RT varchar(3) = ''''

	-- test if range dosing checking information exists
	select @DOSING_AGE_SOURCE_ID = t1.DOSING_AGE_SOURCE_ID, 
			@WEIGHT_REQ_IND = t1.WEIGHT_REQ_IND,
			@NEOM_GEST_BIRTH_AGE_REQ_IND = NEOM_GEST_BIRTH_AGE_REQ_IND
	from NDD_RDRCNMA2_MSTR t1 
	where t1.GCN_SEQNO = @proposed_GCN_SEQNO
		and t1.IsDelete = 0
		and t1.DXID = @DXID
		and t1.DR2_DOSTPI = @DoseTypeIndicator
		and t1.DR2_LOAGED <= @ageInDays -- low age in days
		and t1.DR2_HIAGED >= @ageInDays -- high age in days
		
	-- find DRCM Route of Administration Indicator 
	select @DR2_RT = rt.DR2_RT
	FROM NDD_RMIID1_MED dis WITH(NOLOCK)
	inner join NDD_RMIDFID1_ROUTED_DOSE_FORM_MED form WITH(NOLOCK) on dis.ROUTED_DOSAGE_FORM_MED_ID = form.ROUTED_DOSAGE_FORM_MED_ID
	inner join NDD_RMIRMID1_ROUTED_MED routed WITH(NOLOCK) on routed.ROUTED_MED_ID = form.ROUTED_MED_ID
	inner join NDD_RPEIRM0_RT_MSTR rt WITH(NOLOCK) on routed.MED_ROUTE_ID = rt.MED_ROUTE_ID
	where dis.GCN_SEQNO = @proposed_GCN_SEQNO
	
	if ((ISNULL(@NEOM_GEST_BIRTH_AGE_REQ_IND, ''0'') = ''1'') and (ISNULL(@GestationalAgeInWeeks, 0) = 0))
	begin
		set @errorMsg = ''missing required gestational age''
	end
	else if (@DOSING_AGE_SOURCE_ID is not null)
	begin		
		if (ISNULL(@WEIGHT_REQ_IND, ''0'') = ''1'')
		begin
			set @WeightRequired = 1
			if (ISNULL(@weightInGrams, 0) = 0)
			begin
				set @errorMsg = @missingWeight
			end
			else begin

				if (ISNULL(@NEOM_GEST_BIRTH_AGE_REQ_IND, ''0'') = ''1'')
				begin
					select 
						@DR2_LOFREQ = t1.DR2_LOFREQ, @DR2_HIFREQ = t1.DR2_HIFREQ, 
						@DR2_LODOTX = t1.DR2_LODOTX, @DR2_HIDOTX = t1.DR2_HIDOTX,
						@DR2_LODOSD = t1.DR2_LODOSD, @DR2_LODOSU = t1.DR2_LODOSU,
						@DR2_HIDOSD = t1.DR2_HIDOSD, @DR2_HIDOSU = t1.DR2_HIDOSU,
						@DR2_MXDOSD = t1.DR2_MXDOSD, @DR2_MXDOSU = t1.DR2_MXDOSU,
						@DR2_MX1DOS = t1.DR2_MX1DOS, @DR2_MX1DSU = t1.DR2_MX1DSU,
						@DR2_MXLIFD = t1.DR2_MXLIFD, @DR2_MXLIFU = t1.DR2_MXLIFU,
						@NTE_SINGLE_DOSE = t1.NTE_SINGLE_DOSE, @NTE_SINGLE_DOSE_UNIT_CODE = t1.NTE_SINGLE_DOSE_UNIT_CODE,
						@resultFound = 1
					from NDD_RDRCNMA2_MSTR t1 
					where t1.IsDelete = 0
						and t1.DR2_RT = @DR2_RT
						and t1.GCN_SEQNO = @proposed_GCN_SEQNO
						and t1.DR2_DOSTPI = @DoseTypeIndicator
						and t1.DXID = @DXID
						and t1.DR2_LOAGED <= @ageInDays -- low age in days
						and t1.DR2_HIAGED >= @ageInDays -- high age in days
						and @weightInGrams >= t1.LOW_CURRENT_WEIGHT_GRAMS -- low weight in grams
						-- A High Current Weight of 0 indicates that any weight above the Low Current Weight is covered by the dose record.
						and (t1.HIGH_CURRENT_WEIGHT_GRAMS = 0 or @weightInGrams <= t1.HIGH_CURRENT_WEIGHT_GRAMS) -- high weight in grams
						and t1.NEOM_LOW_GEST_BIRTH_AGE_WEEKS <= @GestationalAgeInWeeks
						and (t1.NEOM_HIGH_GEST_BIRTH_AGE_WEEKS = 0 or t1.NEOM_HIGH_GEST_BIRTH_AGE_WEEKS >= @GestationalAgeInWeeks)
				end
				else begin
					select 
						@DR2_LOFREQ = t1.DR2_LOFREQ, @DR2_HIFREQ = t1.DR2_HIFREQ, 
						@DR2_LODOTX = t1.DR2_LODOTX, @DR2_HIDOTX = t1.DR2_HIDOTX,
						@DR2_LODOSD = t1.DR2_LODOSD, @DR2_LODOSU = t1.DR2_LODOSU,
						@DR2_HIDOSD = t1.DR2_HIDOSD, @DR2_HIDOSU = t1.DR2_HIDOSU,
						@DR2_MXDOSD = t1.DR2_MXDOSD, @DR2_MXDOSU = t1.DR2_MXDOSU,
						@DR2_MX1DOS = t1.DR2_MX1DOS, @DR2_MX1DSU = t1.DR2_MX1DSU,
						@DR2_MXLIFD = t1.DR2_MXLIFD, @DR2_MXLIFU = t1.DR2_MXLIFU,
						@NTE_SINGLE_DOSE = t1.NTE_SINGLE_DOSE, @NTE_SINGLE_DOSE_UNIT_CODE = t1.NTE_SINGLE_DOSE_UNIT_CODE,
						@resultFound = 1
					from NDD_RDRCNMA2_MSTR t1 
					where t1.IsDelete = 0
						and t1.DR2_RT = @DR2_RT
						and t1.GCN_SEQNO = @proposed_GCN_SEQNO
						and t1.DR2_DOSTPI = @DoseTypeIndicator
						and t1.DXID = @DXID
						and t1.DR2_LOAGED <= @ageInDays -- low age in days
						and t1.DR2_HIAGED >= @ageInDays -- high age in days
						and @weightInGrams >= t1.LOW_CURRENT_WEIGHT_GRAMS -- low weight in grams
						-- A High Current Weight of 0 indicates that any weight above the Low Current Weight is covered by the dose record.
						and (t1.HIGH_CURRENT_WEIGHT_GRAMS = 0 or @weightInGrams <= t1.HIGH_CURRENT_WEIGHT_GRAMS) -- high weight in grams
				end
			end
		end -- of if (ISNULL(@WEIGHT_REQ_IND, ''0'') = ''1'')
		else begin
			if (ISNULL(@NEOM_GEST_BIRTH_AGE_REQ_IND, ''0'') = ''1'')
			begin
				select 
					@DR2_LOFREQ = t1.DR2_LOFREQ, @DR2_HIFREQ = t1.DR2_HIFREQ, 
					@DR2_LODOTX = t1.DR2_LODOTX, @DR2_HIDOTX = t1.DR2_HIDOTX,
					@DR2_LODOSD = t1.DR2_LODOSD, @DR2_LODOSU = t1.DR2_LODOSU,
					@DR2_HIDOSD = t1.DR2_HIDOSD, @DR2_HIDOSU = t1.DR2_HIDOSU,
					@DR2_MXDOSD = t1.DR2_MXDOSD, @DR2_MXDOSU = t1.DR2_MXDOSU,
					@DR2_MX1DOS = t1.DR2_MX1DOS, @DR2_MX1DSU = t1.DR2_MX1DSU,
					@DR2_MXLIFD = t1.DR2_MXLIFD, @DR2_MXLIFU = t1.DR2_MXLIFU,
					@NTE_SINGLE_DOSE = t1.NTE_SINGLE_DOSE, @NTE_SINGLE_DOSE_UNIT_CODE = t1.NTE_SINGLE_DOSE_UNIT_CODE,
					@resultFound = 1
				from NDD_RDRCNMA2_MSTR t1 
				where t1.IsDelete = 0
					and t1.DR2_RT = @DR2_RT
					and t1.GCN_SEQNO = @proposed_GCN_SEQNO
					and t1.DR2_DOSTPI = @DoseTypeIndicator
					and t1.DXID = @DXID
					and t1.DR2_LOAGED <= @ageInDays -- low age in days
					and t1.DR2_HIAGED >= @ageInDays -- high age in days
					and t1.NEOM_LOW_GEST_BIRTH_AGE_WEEKS <= @GestationalAgeInWeeks
					and (t1.NEOM_HIGH_GEST_BIRTH_AGE_WEEKS = 0 or t1.NEOM_HIGH_GEST_BIRTH_AGE_WEEKS >= @GestationalAgeInWeeks)
			end -- of if (ISNULL(@NEOM_GEST_BIRTH_AGE_REQ_IND, ''0'') = ''1'')
			else begin
				select 
					@DR2_LOFREQ = t1.DR2_LOFREQ, @DR2_HIFREQ = t1.DR2_HIFREQ, 
					@DR2_LODOTX = t1.DR2_LODOTX, @DR2_HIDOTX = t1.DR2_HIDOTX,
					@DR2_LODOSD = t1.DR2_LODOSD, @DR2_LODOSU = t1.DR2_LODOSU,
					@DR2_HIDOSD = t1.DR2_HIDOSD, @DR2_HIDOSU = t1.DR2_HIDOSU,
					@DR2_MXDOSD = t1.DR2_MXDOSD, @DR2_MXDOSU = t1.DR2_MXDOSU,
					@DR2_MX1DOS = t1.DR2_MX1DOS, @DR2_MX1DSU = t1.DR2_MX1DSU,
					@DR2_MXLIFD = t1.DR2_MXLIFD, @DR2_MXLIFU = t1.DR2_MXLIFU,
					@NTE_SINGLE_DOSE = t1.NTE_SINGLE_DOSE, @NTE_SINGLE_DOSE_UNIT_CODE = t1.NTE_SINGLE_DOSE_UNIT_CODE,
					@resultFound = 1
				from NDD_RDRCNMA2_MSTR t1 
				where t1.IsDelete = 0
					and t1.DR2_RT = @DR2_RT
					and t1.GCN_SEQNO = @proposed_GCN_SEQNO
					and t1.DR2_DOSTPI = @DoseTypeIndicator
					and t1.DXID = @DXID
					and t1.DR2_LOAGED <= @ageInDays -- low age in days
					and t1.DR2_HIAGED >= @ageInDays -- high age in days
			end -- of else if (ISNULL(@NEOM_GEST_BIRTH_AGE_REQ_IND, ''0'') = ''1'')
		end -- of else if (ISNULL(@WEIGHT_REQ_IND, ''0'') = ''1'')

		set @AdjustedLowDose = @DR2_LODOSD
		set @AdjustedHighDose = @DR2_HIDOSD
		set @AdjustedMaximumSingleDose = @DR2_MX1DOS
		set @AdjustedMaximumLifetimeDose = @DR2_MXLIFD
		set @AdjustedMaximumDosePerDay = @DR2_MXDOSD
		set @AdjustedNTE_SINGLE_DOSE = @NTE_SINGLE_DOSE
	
		if ((LEN(@errorMsg) = 0) and (@resultFound = 1))
		begin	
			-- convert Low Dose Per Day
			select @UNITS_CTYP = UNITS_CTYP from NDD_RDRCUND0_UNITS_DESC where DR2_UNITS = @DR2_LODOSU
			if (@UNITS_CTYP = ''1'')
			begin
				set @WeightRequired = 1
				if (ISNULL(@weightKg, 0) = 0)
				begin
					set @errorMsg = @missingWeight
				end
				set @AdjustedLowDose = @DR2_LODOSD * @weightKg
			end
			else if (@UNITS_CTYP = ''2'')
			begin
				set @BodySurfaceAreaRequired = 1
				if (ISNULL(@heightCM, 0) = 0)
				begin
					set @errorMsg = @missingHeight
				end
				set @AdjustedLowDose = @DR2_LODOSD * @BodySurfaceArea
			end
			-- convert High Dose Per Day
			select @UNITS_CTYP = UNITS_CTYP from NDD_RDRCUND0_UNITS_DESC where DR2_UNITS = @DR2_HIDOSU
			if (@UNITS_CTYP = ''1'')
			begin
				set @WeightRequired = 1
				if (ISNULL(@weightKg, 0) = 0)
				begin
					set @errorMsg = @missingWeight
				end
				set @AdjustedHighDose = @DR2_HIDOSD * @weightKg
			end
			else if (@UNITS_CTYP = ''2'')
			begin
				set @BodySurfaceAreaRequired = 1
				if (ISNULL(@heightCM, 0) = 0)
				begin
					set @errorMsg = @missingHeight
				end
				set @AdjustedHighDose = @DR2_HIDOSD * @BodySurfaceArea
			end
			-- convert Maximum Amount Per Single Dose
			select @UNITS_CTYP = UNITS_CTYP from NDD_RDRCUND0_UNITS_DESC where DR2_UNITS = @DR2_MX1DSU
			if (@UNITS_CTYP = ''1'')
			begin
				if (ISNULL(@weightKg, 0) = 0)
				begin
					set @errorMsg = @missingWeight
				end
				set @AdjustedMaximumSingleDose = @DR2_MX1DOS * @weightKg
			end
			else if (@UNITS_CTYP = ''2'')
			begin
				if (ISNULL(@heightCM, 0) = 0)
				begin
					set @errorMsg = @missingHeight
				end
				set @AdjustedMaximumSingleDose = @DR2_MX1DOS * @BodySurfaceArea
				end
			-- convert Maximum Lifetime Dose
			select @UNITS_CTYP = UNITS_CTYP from NDD_RDRCUND0_UNITS_DESC where DR2_UNITS = @DR2_MXLIFU
			if (@UNITS_CTYP = ''1'')
			begin
				if (ISNULL(@weightKg, 0) = 0)
				begin
					set @errorMsg = @missingWeight
				end
				set @AdjustedMaximumLifetimeDose = @DR2_MXLIFD * @weightKg
			end
			else if (@UNITS_CTYP = ''2'')
			begin
				if (ISNULL(@heightCM, 0) = 0)
				begin
					set @errorMsg = @missingHeight
				end
				set @AdjustedMaximumLifetimeDose = @DR2_MXLIFD * @BodySurfaceArea
			end
			-- convert max dose per day
			select @UNITS_CTYP = UNITS_CTYP from NDD_RDRCUND0_UNITS_DESC where DR2_UNITS = @DR2_MXDOSU
			if (@UNITS_CTYP = ''1'')
			begin
				if (ISNULL(@weightKg, 0) = 0)
				begin
					set @errorMsg = @missingWeight
				end
				set @AdjustedMaximumDosePerDay = @DR2_MXDOSD * @weightKg
			end
			else if (@UNITS_CTYP = ''2'')
			begin
				if (ISNULL(@heightCM, 0) = 0)
				begin
					set @errorMsg = @missingHeight
				end
				set @AdjustedMaximumDosePerDay = @DR2_MXDOSD * @BodySurfaceArea
			end
			-- convert Not-to-Exceed Amount Per Single Dose
			select @UNITS_CTYP = UNITS_CTYP from NDD_RDRCUND0_UNITS_DESC where DR2_UNITS = @NTE_SINGLE_DOSE_UNIT_CODE
			if (@UNITS_CTYP = ''1'')
			begin
				if (ISNULL(@weightKg, 0) = 0)
				begin
					set @errorMsg = @missingWeight
				end
				set @AdjustedNTE_SINGLE_DOSE = @NTE_SINGLE_DOSE * @weightKg
			end
			else if (@UNITS_CTYP = ''2'')
			begin
				if (ISNULL(@heightCM, 0) = 0)
				begin
					set @errorMsg = @missingHeight
				end
				set @AdjustedNTE_SINGLE_DOSE = @NTE_SINGLE_DOSE * @BodySurfaceArea
			end
		end -- of if (LEN(@errorMsg) = 0)
	end -- of if (@DOSING_AGE_SOURCE_ID is not null)
	else begin
		declare @cnt int = 0
		select @cnt = COUNT(*)
		from NDD_RDRCNMA2_MSTR t1 
		where t1.GCN_SEQNO = @proposed_GCN_SEQNO
		and t1.IsDelete = 0
		and t1.DR2_RT = @DR2_RT
		and t1.DXID = @DXID

		if (@cnt > 0)
		begin
			set @errorMsg = ''there is no dosing information supplied for this patient''''s age''
		end
	end

	if ((@resultFound = 1) or (LEN(@errorMsg) > 0))
	begin
		insert into @NDD_DetailDosingRangeValues (
				WeightRequired, BodySurfaceAreaRequired,
				LowDose, LowDoseUnits,
				HighDose, HighDoseUnits,
				MaximumDosePerDay, MaximumDosePerDayUnits,
				MaximumSingleDose, MaximumSingleDoseUnits,
				MaximumLifetimeDose, MaximumLifetimeDoseUnits,
				NTEAmountPerSingleDose, NTEAmountPerSingleDoseUnits,
				AdjustedLowDose,  
				AdjustedHighDose, 
				AdjustedMaximumDosePerDay,
				AdjustedMaximumSingleDose,
				AdjustedMaximumLifetimeDose,
				AdjustedNTEAmountPerSingleDose,
				LowFrequency, HighFrequency, LowDuration, HighDuration, BodySurfaceArea, ErrorMsg
			)
			values
			(
				@WeightRequired, @BodySurfaceAreaRequired,
				@DR2_LODOSD,
				(select top 1 UNITS_DESC from NDD_RDRCUND0_UNITS_DESC where DR2_UNITS = @DR2_LODOSU),
				@DR2_HIDOSD,
				(select top 1 UNITS_DESC from NDD_RDRCUND0_UNITS_DESC where DR2_UNITS = @DR2_HIDOSU),
				@DR2_MXDOSD,
				(select top 1 UNITS_DESC from NDD_RDRCUND0_UNITS_DESC where DR2_UNITS = @DR2_MXDOSU),
				@DR2_MX1DOS,
				(select top 1 UNITS_DESC from NDD_RDRCUND0_UNITS_DESC where DR2_UNITS = @DR2_MX1DSU),
				@DR2_MXLIFD,
				(select top 1 UNITS_DESC from NDD_RDRCUND0_UNITS_DESC where DR2_UNITS = @DR2_MXLIFU),
				@NTE_SINGLE_DOSE,
				(select top 1 UNITS_DESC from NDD_RDRCUND0_UNITS_DESC where DR2_UNITS = @NTE_SINGLE_DOSE_UNIT_CODE),
				@AdjustedLowDose,
				@AdjustedHighDose,
				@AdjustedMaximumDosePerDay,
				@AdjustedMaximumSingleDose,
				@AdjustedMaximumLifetimeDose,
				@AdjustedNTE_SINGLE_DOSE,
				@DR2_LOFREQ, @DR2_HIFREQ, @DR2_LODOTX, @DR2_HIDOTX, 
				case when ISNULL(@BodySurfaceAreaRequired, 0) = 1 then ISNULL(@BodySurfaceArea, 0) else null end, 
				@errorMsg
			)
	end

	return
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_PediatricDoseRangeChecking]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 05/04/2018
-- Description:	Returns a table with pediatric dose range enties. If 
--				rows are not return, no dose range data is available.
--
--	NOTE:	Will not return any rows for ages below 30 days or
--			above 6569 days. 
--
-- =================================================================

CREATE FUNCTION [dbo].[NDD_PediatricDoseRangeChecking](
		@proposed_GCN_SEQNO int,	-- gcn_seqno of the proposed medication
		@ageInDays int				-- patient''s age in days
		)
RETURNS
@NDD_PediatricDosingRangeValues table
(
	RangeLowDose decimal(14, 6) null,
	RangeLowDoseUnits varchar(60),
	RangeHighDose decimal(14, 6) null,
	RangeHighDoseUnits varchar(60),
	RangeLowDoseForm decimal(14, 6) null,
	RangeLowDoseFormUnits varchar(60),
	RangeHighDoseForm decimal(14, 6) null,
	RangeHighDoseFormUnits varchar(60) null,
	NTEDailyDoseStrength decimal(14, 6) null, -- Not To Exceed...
	NTEDailyDoseStrengthUnits varchar(60) null, -- Not To Exceed...
	NTEDailyDoseForm decimal(14, 6) null, -- Not To Exceed...
	NTEDailyDoseFormUnits varchar(60) null, -- Not To Exceed...
	ErrorMsg varchar(1024) null
)
AS
begin
	insert into @NDD_PediatricDosingRangeValues
	select
	 t1.PDM_MND as [RangeLowDose], 
	 (select top 1 s1.PDM_UNDESC from NDD_RPDMUND0_PEDI_DOSE_UNIT_DESC s1 where s1.PDM_UNIT = t1.PDM_MNDU) as [RangeLowDoseUnits],
	 t1.PDM_MXD as [RangeHighDose], 
	 (select top 1 s1.PDM_UNDESC from NDD_RPDMUND0_PEDI_DOSE_UNIT_DESC s1 where s1.PDM_UNIT = t1.PDM_MXDU) as [RangeHighDoseUnits],
	 t1.PDM_MNU as [RangeLowDoseForm], 
	(select top 1 s1.PDM_UNDESC from NDD_RPDMUND0_PEDI_DOSE_UNIT_DESC s1 where s1.PDM_UNIT = t1.PDM_MNUF) as [RangeLowDoseFormUnits],
	t1.PDM_MXU as [RangeHighDoseForm], 
	(select top 1 s1.PDM_UNDESC from NDD_RPDMUND0_PEDI_DOSE_UNIT_DESC s1 where s1.PDM_UNIT = t1.PDM_MXUF) as [RangeHighDoseFormUnits],
	t1.PDM_NTED as [NTEDailyDoseStrength], 
	(select top 1 s1.PDM_UNDESC from NDD_RPDMUND0_PEDI_DOSE_UNIT_DESC s1 where s1.PDM_UNIT = t1.PDM_NTEDU) as [NTEDailyDoseStrengthUnits],
	t1.PDM_NTEU as [NTEDailyDoseForm], 
	(select top 1 s1.PDM_UNDESC from NDD_RPDMUND0_PEDI_DOSE_UNIT_DESC s1 where s1.PDM_UNIT = t1.PDM_NTEUF) as [NTEDailyDoseFormUnits],
	case when ISNULL(t1.PDM_MND, -999) = 0 or ISNULL(t1.PDM_MXD, -999) = 0 
				or ISNULL(t1.PDM_MNU, -999) = 0 or ISNULL(t1.PDM_MXU, -999) = 0
				or ISNULL(t1.PDM_NTED, -999) = 0 or ISNULL(t1.PDM_NTEU, -999) = 0
			 then ''potential problems with its use in the age group'' else '''' end as [ErrorMsg]
			 -- see page 731
	from NDD_RPDMMA1_PEDI_MSTR t1 

	where t1.IsDelete = 0
	and t1.GCN_SEQNO = @proposed_GCN_SEQNO
	and t1.PDM_MNAGE<= @ageInDays -- low age in days
	and t1.PDM_MXAGE >= @ageInDays -- high age in days

	return
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_GeriatricDoseRangeChecking]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 05/08/2018
-- Description:	Returns a table with geriatric dose range enties. If 
--				rows are not return, no dose range data is available.
--
-- =================================================================

CREATE FUNCTION [dbo].[NDD_GeriatricDoseRangeChecking](
		@proposed_GCN_SEQNO int	-- gcn_seqno of the proposed medication
		)
RETURNS
@NDD_GeriatricDosingRangeValues table
(
	PK int IDENTITY NOT NULL PRIMARY KEY,
	RangeLowDose decimal(14, 6) null,
	RangeLowDoseUnits varchar(60),
	RangeHighDose decimal(14, 6) null,
	RangeHighDoseUnits varchar(60),
	RangeLowDoseForm decimal(14, 6) null,
	RangeLowDoseFormUnits varchar(60),
	RangeHighDoseForm decimal(14, 6) null,
	RangeHighDoseFormUnits varchar(60) null
)
AS
begin
	insert into @NDD_GeriatricDosingRangeValues
	select
		t1.MMGR_MND as [RangeLowDose], t1.MMGR_MNDU as [RangeLowDoseUnits],
		t1.MMGR_MXD as [RangeHighDose], t1.MMGR_MXDU as [RangeHighDoseUnits],
		t1.MMGR_MNU as [RangeLowDoseForm], t1.MMGR_MNUF as [RangeLowDoseFormUnits],
		t1.MMGR_MXU as [RangeHighDoseForm], t1.MMGR_MXUF as [RangeHighDoseFormUnits]
	from NDD_RMMGRMA1_GERI_RANGE_MSTR t1 
	where t1.IsDelete = 0 
		and t1.GCN_SEQNO = @proposed_GCN_SEQNO

	return
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_DoseRangeChecking]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =================================================================
-- Author:		CHM
-- Create date: 05/08/2018
-- Description:	Returns a table with dose range enties. If rows are 
--				not return, no dose range data is available.  If any 
--				errors occur, a row with the error in the “ErrorMsg” 
--				column will return.
--
-- NOTES:
--		Column names that start with "Adjusted" are values 
--		adjusted for weight or body surface area as requried.
--
--		Column names that start with "NTE" which is short
--		for "Not To Exceed".
--
-- 11/28/2018 - Fixed problem with @resultFound and @errorMsg
-- =================================================================
CREATE FUNCTION [dbo].[NDD_DoseRangeChecking](
	@proposed_MEDID int,					-- medid of the proposed medication
	@proposed_GCN_SEQNO int,				-- gcn_seqno of the proposed medication
	@ageInDays int,							-- patient''s age in days
	@weightKg decimal(14, 6),				-- patient weight in kilogram
	@heightCM decimal(14, 6),				-- patient''s height in centimeters
	@gestationalAgeInWeeks numeric(2, 0),	-- patient’s gestational birth age in weeks
	@doseTypeIndicator varchar(2),			-- 01 - LOADING  02 - MAINTENANCE  07 - SINGLE DOSE, will default to maintenance if null
	@icd_Code varchar(10)					-- the patient''s condition to be treated with this prescription ICD9 or IDC10 code
	)
RETURNS
@NDD_DosingRangeValues table
(
	PK int IDENTITY NOT NULL PRIMARY KEY,
	WeightRequired bit not null,
	BodySurfaceAreaRequired bit not null,
	LowDose decimal(14, 6) null,
	LowDoseUnits varchar(60),
	HighDose decimal(14, 6) null,
	HighDoseUnits varchar(60),
	MaximumDosePerDay decimal(14, 6) null,
	MaximumDosePerDayUnits varchar(60) null,
	MaximumSingleDose decimal(14, 6) null,
	MaximumSingleDoseUnits varchar(60) null,
	MaximumLifetimeDose decimal(14, 6) null,
	MaximumLifetimeDoseUnits varchar(60) null,
	NTEAmountPerSingleDose decimal(14, 6) null,
	NTEAmountPerSingleDoseUnits varchar(60) null,
	LowFrequency decimal(4, 2) null,
	HighFrequency decimal(4, 2) null,
	LowDuration decimal(5, 0) null,
	HighDuration decimal(5, 0) null,
	AdjustedLowDose decimal(14, 6) null,
	AdjustedHighDose decimal(14, 6) null,
	AdjustedMaximumSingleDose decimal(14, 6) null,
	AdjustedMaximumDosePerDay decimal(14, 6) null,
	AdjustedMaximumLifetimeDose decimal(14, 6) null,
	AdjustedNTEAmountPerSingleDose decimal(14, 6) null,
	RangeLowDose decimal(14, 6) null,
	RangeLowDoseUnits varchar(60),
	RangeHighDose decimal(14, 6) null,
	RangeHighDoseUnits varchar(60),
	RangeLowDoseForm decimal(14, 6) null,
	RangeLowDoseFormUnits varchar(60),
	RangeHighDoseForm decimal(14, 6) null,
	RangeHighDoseFormUnits varchar(60) null,
	NTEPediDailyDoseStrength decimal(14, 6) null,
	NTEPediDailyDoseStrengthUnits varchar(60) null,
	NTEPediDailyDoseForm decimal(14, 6) null,
	NTEPediDailyDoseFormUnits varchar(60) null, 
	Ingredient_Strength numeric (19, 6) null,
	Ingredient_Strength_UOM_Abbr varchar(10) null,
	Ingredient_Strength_UOM_Desc varchar(50) NULL,
	Ingredient_Volume numeric (19, 6) null,
	Ingredient_Volume_UOM_Abbr varchar(10) null,
	Ingredient_Volume_UOM_Desc varchar(50) NULL,
	WeightKg decimal(14, 6) NULL,
	BodySurfaceArea decimal(14, 6) NULL,
	ErrorMsg varchar(1024) null
)
AS
BEGIN
/*
NOTES:
	Age ranges are not tied to individual records, but to the module. 
	While there are no universally accepted definitions of Adult and Geriatric, the terms
	are commonly understood to refer to, respectively, 18 - 64 years of age and 65 and
	over, and the Min/Max module follows this convention.

	The following table lists the five Min/Max Dose Modules and indicates the age group defined by the
	module and the context for each.
	DRCM covers patients from 0 days to 110 years, while NEOM covers patients 0 to 364 days. The age for a
	dosing record is coded in days.

	Pediatric Dose Module (PDM) 
		Age in years: 0.083 to 17 years
		Age in days: 30 to 6569 days

	Min/Max Adult Daily Dose Module (MMAD) 
		Age in years: 18 to 64 years
		Age in days: 6570 to 23724

	Min/Max Adult Daily Range Module (MMAR)
		Age in years: 18 to 64 years
		Age in days: 6570 to 23724

	Min/Max Geriatric Daily Dose Module (MMGD)
		Age in years: 65 to 110 years
		Age in days: 23725 to 40150

	Min/Max Geriatric Daily Range Module (MMGR)
		Age in years: 65 to 110 years
		Age in days: 23725 to 40150
*/
	
	declare @resultFound bit = 0
	declare @errorMsg varchar(1024) = ''''
	declare @ageFound bit = 0
	declare @DXID int
	declare @DOSING_AGE_SOURCE_ID numeric(4, 0)
	--declare @WEIGHT_REQ_IND varchar(1)		-- Weight Required Indicator; equals 1, the current weight is required

	--declare @Weight_Required bit = 0
	--declare @BSA_Required bit = 0
	declare @LowDose decimal(14, 6)
	declare @LowDoseUnits varchar(50)
	declare @HighDose decimal(14, 6)
	declare @HighDoseUnits varchar(50)

	declare @MaximumDosePerDay decimal(14, 6)
	declare @MaximumDosePerDayUnits varchar(60)
	declare @MaximumSingleDose decimal(14, 6)
	declare @MaximumSingleDoseUnits varchar(60)
	declare @MaximumLifetimeDose decimal(14, 6)
	declare @MaximumLifetimeDoseUnits varchar(60)
	declare @NTEAmountPerSingleDose decimal(14, 6)
	declare @NTEAmountPerSingleDoseUnits varchar(60)
	declare @LowFrequency decimal(4, 2)
	declare @HighFrequency decimal(4, 2)
	declare @LowDuration decimal(5, 0)
	declare @HighDuration decimal(5, 0)
	
	declare @AdjustedLowDose decimal(14, 6) 
	declare @AdjustedHighDose decimal(14, 6)
	declare @AdjustedMaximumSingleDose decimal(14, 6)
	declare @AdjustedMaximumDosePerDay decimal(14, 6)
	declare @AdjustedMaximumLifetimeDose decimal(14, 6)
	declare @AdjustedNTE_SINGLE_DOSE decimal(14, 6)
	
	declare @WeightRequired bit = 0
	declare @BodySurfaceAreaRequired bit = 0

	declare @RangeLowDose decimal(14, 6)
	declare @RangeLowDoseUnits varchar(50)
	declare @RangeHighDose decimal(14, 6)
	declare @RangeHighDoseUnits varchar(50)
	declare @RangeLowDoseForm decimal(14, 6)
	declare @RangeLowDoseFormUnits varchar(50)
	declare @RangeHighDoseForm decimal(14, 6)
	declare @RangeHighDoseFormUnits varchar(50)
	
	declare @NTEPediDailyDoseStrength decimal(14, 6)
	declare @NTEPediDailyDoseStrengthUnits varchar(60)
	declare @NTEPediDailyDoseForm decimal(14, 6)
	declare @NTEPediDailyDoseFormUnits varchar(60)

	declare @Ingredient_Strength numeric (19, 6)
	declare @Ingredient_Strength_UOM_Abbr varchar(10)
	declare @Ingredient_Strength_UOM_Desc varchar(50)
	declare @Ingredient_Volume numeric (19, 6)
	declare @Ingredient_Volume_UOM_Abbr varchar(10)
	declare @Ingredient_Volume_UOM_Desc varchar(50)

	declare @BodySurfaceArea decimal(14, 6)
		
	if (ISNULL(@proposed_GCN_SEQNO, 0) = 0)
	begin
		select @proposed_GCN_SEQNO = GCN_SEQNO
		from NDD_RMIID1_MED 
		where MEDID = @proposed_MEDID
	end
	if (LEN(ISNULL(@icd_Code, '''')) > 0)
	begin
		select @DXID = RELATED_DXID 
		from NDD_RFMLISR1_ICD_SEARCH 
		where SEARCH_ICD_CD = @ICD_Code
	end
	if (@DXID is null)
	begin
		set @DXID = 4892 -- default screening record
	end

	if (LEN(ISNULL(@doseTypeIndicator, '''')) = 0)
	begin
		set @doseTypeIndicator = ''02'' -- set default dose type indicator to maintenance
	end
	if (ISNULL(@ageInDays, 0) < 1)
	begin
		
		set @errorMsg = ''missing required age''
	end
	else begin
		select 
			@Ingredient_Strength = t1.STRENGTH, 
			@Ingredient_Strength_UOM_Abbr = t2.UOM_ABBR, 
			@Ingredient_Strength_UOM_Desc = t2.UOM_DESC,
			@Ingredient_Volume = t1.VOLUME,
			@Ingredient_Volume_UOM_Abbr = t3.UOM_ABBR,
			@Ingredient_Volume_UOM_Desc = t3.UOM_DESC
		from NDD_RGCNSTR0_INGREDIENT_STRENGTH t1
			left outer join NDD_RSTRUOM0_STRENGTH_UOM t2 on t2.UOM_ID = t1.STRENGTH_UOM_ID
			left outer join NDD_RSTRUOM0_STRENGTH_UOM t3 on t3.UOM_ID = t1.VOLUME_UOM_ID
		where t1.IsDelete = 0 
			and t1.GCN_SEQNO = @proposed_GCN_SEQNO

		select 
			@WeightRequired = t1.WeightRequired, @BodySurfaceAreaRequired = t1.BodySurfaceAreaRequired,
			@LowDose = t1.LowDose, @LowDoseUnits = t1.LowDoseUnits,
			@HighDose = t1.HighDose, @HighDoseUnits = t1.HighDoseUnits,
			@MaximumDosePerDay = t1.MaximumDosePerDay, @MaximumDosePerDayUnits = t1.MaximumDosePerDayUnits,
			@MaximumSingleDose = t1.MaximumSingleDose, @MaximumSingleDoseUnits = t1.MaximumSingleDoseUnits,
			@MaximumLifetimeDose = t1.MaximumLifetimeDose, @MaximumLifetimeDoseUnits = t1.MaximumLifetimeDoseUnits,
			@NTEAmountPerSingleDose = t1.NTEAmountPerSingleDose, @NTEAmountPerSingleDoseUnits = t1.NTEAmountPerSingleDoseUnits,
			@AdjustedLowDose = t1.AdjustedLowDose, @AdjustedHighDose = t1.AdjustedHighDose,
			@AdjustedMaximumDosePerDay = t1.AdjustedMaximumDosePerDay, @AdjustedMaximumLifetimeDose = t1.AdjustedMaximumLifetimeDose,
			@AdjustedMaximumSingleDose = t1.AdjustedMaximumSingleDose, @AdjustedNTE_SINGLE_DOSE = t1.AdjustedNTEAmountPerSingleDose,
			@LowFrequency = t1.LowFrequency, @HighFrequency = t1.HighFrequency,
			@LowDuration = t1.LowDuration, @HighDuration = t1.HighDuration, @BodySurfaceArea = t1.BodySurfaceArea,
			@errorMsg = t1.ErrorMsg, @resultFound = 1
		from NDD_DetailDoseRangeChecking
			(@proposed_GCN_SEQNO, @ageInDays, @weightKg, @heightCM, @GestationalAgeInWeeks, @doseTypeIndicator, @DXID) t1

		-- call sub-function based on age in days
		if ((LEN(@errorMsg) = 0) and
			(@ageInDays >= 30) and (@ageInDays <= 6569)) -- Pediatric 0.083 to 17 years; 30 to 6569 days
		begin
			select 
				@RangeLowDose = RangeLowDose, @RangeLowDoseUnits = RangeLowDoseUnits, 
				@RangeHighDose = RangeHighDose, @RangeHighDoseUnits = RangeHighDoseUnits,
				@RangeLowDoseForm = RangeLowDoseForm, @RangeLowDoseFormUnits = RangeLowDoseFormUnits, 
				@RangeHighDoseForm = RangeHighDoseForm, @RangeHighDoseFormUnits = RangeHighDoseFormUnits,
				@NTEPediDailyDoseStrength = NTEDailyDoseStrength, @NTEPediDailyDoseStrengthUnits = NTEDailyDoseStrengthUnits,
				@NTEPediDailyDoseForm = NTEDailyDoseForm, @NTEPediDailyDoseFormUnits = NTEDailyDoseFormUnits,
				@errorMsg = ErrorMsg,
				@ageFound = 1
			from NDD_PediatricDoseRangeChecking (@proposed_GCN_SEQNO, @ageInDays)
		end
		else if ((LEN(@errorMsg) = 0) and
				(@ageInDays >= 6570) and (@ageInDays <= 23724)) -- Adult 18 to 64 years; 6570 to 23724 days
		begin
			select 
				@RangeLowDose = RangeLowDose, @RangeLowDoseUnits = RangeLowDoseUnits, 
				@RangeHighDose = RangeHighDose, @RangeHighDoseUnits = RangeHighDoseUnits,
				@RangeLowDoseForm = RangeLowDoseForm, @RangeLowDoseFormUnits = RangeLowDoseFormUnits, 
				@RangeHighDoseForm = RangeHighDoseForm, @RangeHighDoseFormUnits = RangeHighDoseFormUnits,
				@ageFound = 1
			from NDD_AdultDoseRangeChecking (@proposed_GCN_SEQNO)
		end
		else if ((LEN(@errorMsg) = 0) and
				(@ageInDays >= 23725) and (@ageInDays <= 40150)) -- Geriatric 65 to 110 years; 23725 to 40150 days
		begin
			select 
				@RangeLowDose = RangeLowDose, @RangeLowDoseUnits = RangeLowDoseUnits, 
				@RangeHighDose = RangeHighDose, @RangeHighDoseUnits = RangeHighDoseUnits,
				@RangeLowDoseForm = RangeLowDoseForm, @RangeLowDoseFormUnits = RangeLowDoseFormUnits, 
				@RangeHighDoseForm = RangeHighDoseForm, @RangeHighDoseFormUnits = RangeHighDoseFormUnits,
				@ageFound = 1
			from NDD_GeriatricDoseRangeChecking (@proposed_GCN_SEQNO)
		end

		if (@resultFound = 1)
		begin
			if ((LEN(@errorMsg) = 0) and (@ageFound = 0))
			begin
				set @errorMsg = ''there is no dosing information supplied for this patient''''s age''
			end
			insert into @NDD_DosingRangeValues (
				WeightRequired, BodySurfaceAreaRequired,
				LowDose, LowDoseUnits,
				HighDose, HighDoseUnits,
				MaximumDosePerDay, MaximumDosePerDayUnits,
				MaximumSingleDose, MaximumSingleDoseUnits,
				MaximumLifetimeDose, MaximumLifetimeDoseUnits,
				NTEAmountPerSingleDose, NTEAmountPerSingleDoseUnits,
				LowFrequency, HighFrequency, LowDuration, HighDuration,
				AdjustedLowDose, AdjustedHighDose,
				AdjustedMaximumDosePerDay, AdjustedMaximumLifetimeDose,
				AdjustedMaximumSingleDose, AdjustedNTEAmountPerSingleDose,
				RangeLowDose, RangeLowDoseUnits,
				RangeHighDose, RangeHighDoseUnits,
				RangeLowDoseForm, RangeLowDoseFormUnits,
				RangeHighDoseForm, RangeHighDoseFormUnits,
				NTEPediDailyDoseStrength, NTEPediDailyDoseStrengthUnits,
				NTEPediDailyDoseForm, NTEPediDailyDoseFormUnits,
				Ingredient_Strength, Ingredient_Strength_UOM_Abbr, Ingredient_Strength_UOM_Desc,
				Ingredient_Volume, Ingredient_Volume_UOM_Abbr, Ingredient_Volume_UOM_Desc,
				WeightKg, BodySurfaceArea, ErrorMsg
			)
			values (
				@WeightRequired, @BodySurfaceAreaRequired,
				@LowDose, @LowDoseUnits,
				@HighDose, @HighDoseUnits,
				@MaximumDosePerDay, @MaximumDosePerDayUnits,
				@MaximumSingleDose, @MaximumSingleDoseUnits,
				@MaximumLifetimeDose, @MaximumLifetimeDoseUnits,
				@NTEAmountPerSingleDose, @NTEAmountPerSingleDoseUnits,
				@LowFrequency, @HighFrequency, @LowDuration, @HighDuration,
				@AdjustedLowDose, @AdjustedHighDose,
				@AdjustedMaximumDosePerDay, @AdjustedMaximumLifetimeDose,
				@AdjustedMaximumSingleDose, @AdjustedNTE_SINGLE_DOSE,
				@RangeLowDose, @RangeLowDoseUnits,
				@RangeHighDose, @RangeHighDoseUnits,
				@RangeLowDoseForm, @RangeLowDoseFormUnits,
				@RangeHighDoseForm, @RangeHighDoseFormUnits,
				@NTEPediDailyDoseStrength, @NTEPediDailyDoseStrengthUnits,
				@NTEPediDailyDoseForm, @NTEPediDailyDoseFormUnits,
				@Ingredient_Strength, @Ingredient_Strength_UOM_Abbr, @Ingredient_Strength_UOM_Desc,
				@Ingredient_Volume, @Ingredient_Volume_UOM_Abbr, @Ingredient_Volume_UOM_Desc, 
				@weightKg, @BodySurfaceArea, @errorMsg
			)

			set @errorMsg = ''''
		end
	end

	if (LEN(@errorMsg) > 0)
	begin
		insert into @NDD_DosingRangeValues(WeightRequired, BodySurfaceAreaRequired, ErrorMsg) values (0, 0, @errorMsg)
	end
	else if (@resultFound = 0)
	begin
		insert into @NDD_DosingRangeValues(WeightRequired, BodySurfaceAreaRequired, ErrorMsg) values (0, 0, ''First Databank does not contain max/min dosing information for the selected medication.'')
	end

	RETURN
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_DosingOrder]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/15/2018
-- Description:	Returns dosing orders.
--
-- 02/22/2018   made changes to support new table names.
-- 09/06/2018	fixed bug #8477
-- =================================================================
CREATE FUNCTION [dbo].[NDD_DosingOrder](
		@POEOSTRID int
		)
RETURNS 
 @DosingOrder table
(
	POEOSTRID int null,
	FullOrderText varchar(MAX) null, -- A complete description of the order.
	DoseFormHigh [numeric](12, 4) null,
	DoseFormHighUnitDescription varchar(30) null,
	DoseFormLow [numeric](12, 4) null,
	DoseFormLowUnitDescription varchar(30) null,
	DoseHigh [numeric](12, 4) null,
	DoseHighUnitDescription varchar(30) null,
	DoseLow [numeric](12, 4) null,
	DoseLowUnitDescription varchar(30) null,
	FrequencyHigh [numeric](3, 0) null,
	FrequencyLow [numeric](3, 0) null,
	IntervalHigh [numeric](3, 0) null,
	IntervalHighUnitDescription varchar(30) null,
	IntervalLow [numeric](3, 0) null,
	IntervalLowUnitDescription varchar(30) null,
	DurationHigh [numeric](3, 0) null,
	DurationHighUnitDescription varchar(30) null,
	DurationLow [numeric](3, 0) null,
	DurationLowUnitDescription varchar(30) null,
	[Route] varchar(30) null,
	AdditionalInstructions varchar(MAX) null
)

AS
begin
	declare @fullOrderText varchar(MAX) = ''''
	declare @additionalInstructions varchar(MAX) = null
	declare @tmpStr varchar(128)
	declare @POETEXTTYP int
	
	----build full order and additional instructions strings
	declare out_cursor cursor for 			
		select t3.POETXLINE, t2.POETEXTTYP
		from NDD_RPOEOSR1_ORDER_STRING t1
		inner join NDD_RPOEOSX1_TEXT_LINK t2 on t1.POEOSTRID = t2.POEOSTRID
		inner join NDD_RPOETXT1_TEXT t3 on t3.POETEXTCDE = t2.POETEXTCDE
		where t1.POEOSTRID = @POEOSTRID
		order by t2.POETEXTTYP, t3.POETXTNUM
	
	open out_cursor
	fetch NEXT from out_cursor into @tmpStr, @POETEXTTYP

	while (@@fetch_status <> -1)
	begin
		if (@@fetch_status <> -2)
		begin
			if (@POETEXTTYP = 80) -- full order
			begin
				set @fullOrderText = @fullOrderText + @tmpStr
			end
			else if (@POETEXTTYP = 90) -- additional instructions
			begin
				if (@additionalInstructions is null)
					set @additionalInstructions = @tmpStr
				else
					set @additionalInstructions = @additionalInstructions + @tmpStr
			end
		end --if (@@fetch_status <> -2)
					
		
		fetch NEXT from out_cursor into @tmpStr, @POETEXTTYP
	end -- of while
	
	close out_cursor
	deallocate out_cursor
	
	insert into @DosingOrder (
				POEOSTRID, FullOrderText, 
				DoseFormHigh, DoseFormHighUnitDescription, 
				DoseFormLow, DoseFormLowUnitDescription,
				DoseHigh, DoseHighUnitDescription, 
				DoseLow, DoseLowUnitDescription,
				FrequencyHigh, FrequencyLow,
				IntervalHigh, IntervalHighUnitDescription, 
				IntervalLow, IntervalLowUnitDescription,
				DurationHigh, DurationHighUnitDescription, 
				DurationLow, DurationLowUnitDescription,
				[Route], AdditionalInstructions)
	select 
		t1.POEOSTRID,
		@fullOrderText as [FullOrderText],

		t1.POEHIGHDFA as [DoseFormHigh],
		(select top 1 t11.POEDESC1 from NDD_RPOECD1_DEFINITION t11 where t11.POEUNITCDE = t1.POEHighDFU) as [DoseFormHighUnitDescription],

		t1.POELOWDFA as [DoseFormLow],
		(select top 1 t11.POEDESC1 from NDD_RPOECD1_DEFINITION t11 where t11.POEUNITCDE = t1.POELOWDFU) as [DoseFormLowUnitDescription],

		t1.POEHIGHD as [DoseHigh],
		(select top 1 t11.POEDESC1 from NDD_RPOECD1_DEFINITION t11 where t11.POEUNITCDE = t1.POEHIGHDU) as [DoseHighUnitDescription],
		t1.POELOWD as [DoseLow],
		(select top 1 t11.POEDESC1 from NDD_RPOECD1_DEFINITION t11 where t11.POEUNITCDE = t1.POELOWDU) as [DoseLowUnitDescription],

		t1.POEHIGHF as [FrequencyHigh],
		t1.POELOWF as [FrequencyLow],

		t1.POEHIGHI as [IntervalHigh],
		(select top 1 t11.POEDESC1 from NDD_RPOECD1_DEFINITION t11 where t11.POEUNITCDE = t1.POEHIGHIU) as [IntervalHighUnitDescription],

		t1.POELOWI as [IntervalLow],
		(select top 1 t11.POEDESC1 from NDD_RPOECD1_DEFINITION t11 where t11.POEUNITCDE = t1.POELOWIU) as [IntervalLowUnitDescription],

		t1.POEHIGHDR as [DurationHigh],
		(select top 1 t11.POEDESC1 from NDD_RPOECD1_DEFINITION t11 where t11.POEUNITCDE = t1.POEHIGHDRU) as [DurationHighUnitDescription],

		t1.POELOWDR as [DurationLow],
		(select top 1 t11.POEDESC1 from NDD_RPOECD1_DEFINITION t11 where t11.POEUNITCDE = t1.POELOWDRU) as [DurationLowUnitDescription],

		(select top 1 t11.POEDESC1 from NDD_RPOECD1_DEFINITION t11 where t11.POEUNITTYP = 3 and t11.POEUNITCDE = t1.POEROUTE) as [Route],
		@additionalInstructions

	from NDD_RPOEOSR1_ORDER_STRING t1
	where t1.POEOSTRID = @POEOSTRID


	return
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_DosingOrderInformation]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =================================================================
-- Author:		CHM
-- Create date: 02/15/2018
-- Description:	This function will return a list of dosing order
--				information, including a default dosing order.
--
-- 02/22/2018   made changes to support new table names.
-- 09/06/2018	fixed bug #8477
-- =================================================================
CREATE FUNCTION [dbo].[NDD_DosingOrderInformation](
		@ageInDays int,				-- patient age in days; if null or zero will not be filter on age
		@icd_Code varchar(10),		-- icd code (either 9 or 10); if null or empty will not be filter on code
		@proposed_MEDID int,		-- medid of the proposed medication
		@proposed_GCN_SEQNO int		-- gcn_seqno of the proposed medication
		)
RETURNS 
@DosingInformation table
 (
	PK int IDENTITY NOT NULL PRIMARY KEY,
	DefaultDosingOrder bit null,
	AgeInDaysHigh int null,
    AgeInDaysLow int null,
	IndicationDescription varchar(1024) null,
	FullOrderText varchar(MAX) null,
	DoseFormHigh [numeric](12, 4) null,
	DoseFormHighUnitDescription varchar(30) null,
	DoseFormLow [numeric](12, 4) null,
	DoseFormLowUnitDescription varchar(30) null,
	DoseHigh [numeric](12, 4) null,
	DoseHighUnitDescription varchar(30) null,
	DoseLow [numeric](12, 4) null,
	DoseLowUnitDescription varchar(30) null,
	FrequencyHigh [numeric](3, 0) null,
	FrequencyLow [numeric](3, 0) null,
	IntervalHigh [numeric](3, 0) null,
	IntervalHighUnitDescription varchar(30) null,
	IntervalLow [numeric](3, 0) null,
	IntervalLowUnitDescription varchar(30) null,
	DurationHigh [numeric](3, 0) null,
	DurationHighUnitDescription varchar(30) null,
	DurationLow [numeric](3, 0) null,
	DurationLowUnitDescription varchar(30) null,
	[Route] varchar(30) null,
	DXID [numeric](8, 0) NULL,
	AdditionalInstructions varchar(MAX) null
 )

AS
begin
	declare @GeneralDosingInformation table
	 (
		POEOSTRID int null,
		AgeInDaysHigh int null,
		AgeInDaysLow int null,
		IndicationDescription varchar(1024) null,
		DXID [numeric](8, 0) NULL
	 )
	 
	declare @POEOSTRID int
	declare @AgeInDaysHigh int 
	declare @AgeInDaysLow int
	declare @IndicationDescription varchar(1024)
	declare @DXID [numeric](8, 0)

	if ((ISNULL(@proposed_MEDID, 0) > 0) and (ISNULL(@proposed_GCN_SEQNO, 0) = 0))
	begin
		set @proposed_GCN_SEQNO = dbo.NDD_FindGCNSEQNO(@proposed_MEDID)
	end

	if (ISNULL(@icd_Code, '''') = '''')
	begin
		insert into @GeneralDosingInformation (POEOSTRID, AgeInDaysLow, AgeInDaysHigh, IndicationDescription, DXID)
			select t4.POEOSTRID, t2.POEMINRANG as [AgeInDaysLow], t2.POEMAXRANG as [AgeInDaysHigh], t3.DXID_DESC56 as [IndicationDescription], t3.DXID
			from NDD_RPOEGSQ2_GCNSEQNO_MSTR t1 WITH(NOLOCK)
			inner join NDD_RPOECL1_CLIN_CONTEXT t2 WITH(NOLOCK) on t1.POECLINID = t2.POECLINID  -- age range
					and ((ISNULL(@ageInDays, 0) = 0) or (@ageInDays >= t2.POEMINRANG and @ageInDays <= t2.POEMAXRANG))
			inner join NDD_RFMLDX0_DXID t3 WITH(NOLOCK) on t1.DXID = t3.DXID
			inner join NDD_RPOEOS1_ORDER_SET t4 WITH(NOLOCK) on t1.POEOSETID = t4.POEOSETID
			where t1.GCN_SEQNO = @proposed_GCN_SEQNO 

		
		-- get default dosing order; if there is one
		select @POEOSTRID = t3.POEOSTRID, @AgeInDaysHigh = t2.POEMAXRANG, @AgeInDaysLow = t2.POEMINRANG
		from NDD_RPOEGCS1_STANDARD_ORDER t1 WITH(NOLOCK)
		inner join NDD_RPOECL1_CLIN_CONTEXT t2 WITH(NOLOCK) on t1.POECLINID = t2.POECLINID  -- age range
					and ((ISNULL(@ageInDays, 0) = 0) or (@ageInDays >= t2.POEMINRANG and @ageInDays <= t2.POEMAXRANG))
		inner join NDD_RPOEOS1_ORDER_SET t3 WITH(NOLOCK) on t1.POEOSETID = t3.POEOSETID
		where t1.GCN_SEQNO =  @proposed_GCN_SEQNO
	end
	else begin
		insert into @GeneralDosingInformation (POEOSTRID, AgeInDaysLow, AgeInDaysHigh, IndicationDescription, DXID)
			select t4.POEOSTRID, t2.POEMINRANG as [AgeInDaysLow], t2.POEMAXRANG as [AgeInDaysHigh], t3.DXID_DESC56 as [IndicationDescription], t3.DXID
			from NDD_RPOEGSQ2_GCNSEQNO_MSTR t1 WITH(NOLOCK)
			inner join NDD_RPOECL1_CLIN_CONTEXT t2 WITH(NOLOCK) on t1.POECLINID = t2.POECLINID  -- age range
					and ((ISNULL(@ageInDays, 0) = 0) or (@ageInDays >= t2.POEMINRANG and @ageInDays <= t2.POEMAXRANG))
			inner join NDD_RFMLDX0_DXID t3 WITH(NOLOCK) on t1.DXID = t3.DXID
			inner join NDD_RPOEOS1_ORDER_SET t4 WITH(NOLOCK) on t1.POEOSETID = t4.POEOSETID
			inner join NDD_RFMLISR1_ICD_SEARCH t5 WITH(NOLOCK) on t1.DXID = t5.RELATED_DXID and t5.FML_CLIN_CODE = 5 -- 5 specifies the query is for POEM
			where t1.GCN_SEQNO = @proposed_GCN_SEQNO and t5.SEARCH_ICD_CD = @icd_Code
	end

	if (ISNULL(@POEOSTRID, 0) > 0)
	begin
	insert into @DosingInformation (
					DefaultDosingOrder,
					AgeInDaysHigh, AgeInDaysLow,
					FullOrderText, DoseFormHigh, DoseFormHighUnitDescription,
					DoseFormLow, DoseFormLowUnitDescription, 
					DoseHigh, DoseHighUnitDescription, DoseLow, DoseLowUnitDescription,
					FrequencyHigh, FrequencyLow,
					IntervalHigh, IntervalHighUnitDescription, IntervalLow, IntervalLowUnitDescription,
					DurationHigh, DurationHighUnitDescription, DurationLow, DurationLowUnitDescription,
					[Route], AdditionalInstructions
					)

				select
					1,
					@AgeInDaysHigh,  @AgeInDaysLow,
					FullOrderText, DoseFormHigh, DoseFormHighUnitDescription,
					DoseFormLow, DoseFormLowUnitDescription, 
					DoseHigh, DoseHighUnitDescription, DoseLow, DoseLowUnitDescription,
					FrequencyHigh, FrequencyLow,
					IntervalHigh, IntervalHighUnitDescription, IntervalLow, IntervalLowUnitDescription,
					DurationHigh, DurationHighUnitDescription, DurationLow, DurationLowUnitDescription,
					[Route], AdditionalInstructions
				from dbo.NDD_DosingOrder (@POEOSTRID)
	end

	declare out_cursor cursor for 
			select POEOSTRID, AgeInDaysHigh, AgeInDaysLow, IndicationDescription, DXID
			from @GeneralDosingInformation
			order by IndicationDescription
	
	open out_cursor
	fetch NEXT from out_cursor into @POEOSTRID, @AgeInDaysHigh, @AgeInDaysLow, @IndicationDescription, @DXID

	while (@@fetch_status <> -1)
	begin
		if (@@fetch_status <> -2)
		begin
			insert into @DosingInformation (
				DefaultDosingOrder,
				AgeInDaysHigh, AgeInDaysLow, IndicationDescription,
				FullOrderText, DoseFormHigh, DoseFormHighUnitDescription,
				DoseFormLow, DoseFormLowUnitDescription, 
				DoseHigh, DoseHighUnitDescription, DoseLow, DoseLowUnitDescription,
				FrequencyHigh, FrequencyLow,
				IntervalHigh, IntervalHighUnitDescription, IntervalLow, IntervalLowUnitDescription,
				DurationHigh, DurationHighUnitDescription, DurationLow, DurationLowUnitDescription,
				[Route], DXID, AdditionalInstructions
				)
			select
				0,
				@AgeInDaysHigh,  @AgeInDaysLow, @IndicationDescription,
				FullOrderText, DoseFormHigh, DoseFormHighUnitDescription,
				DoseFormLow, DoseFormLowUnitDescription, 
				DoseHigh, DoseHighUnitDescription, DoseLow, DoseLowUnitDescription,
				FrequencyHigh, FrequencyLow,
				IntervalHigh, IntervalHighUnitDescription, IntervalLow, IntervalLowUnitDescription,
				DurationHigh, DurationHighUnitDescription, DurationLow, DurationLowUnitDescription,
				[Route], @DXID, AdditionalInstructions
			from dbo.NDD_DosingOrder (@POEOSTRID)
		end --if (@@fetch_status <> -2)
					
		
		fetch NEXT from out_cursor into @POEOSTRID, @AgeInDaysHigh,  @AgeInDaysLow, @IndicationDescription, @DXID
	end -- of while
	
	close out_cursor
	deallocate out_cursor

	return
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_DrugDiseaseContraindications]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 01/18/2018
-- Description:	Returns a table with drug-disease contraindications 
--				enties.  If the table is empty no drug-disease 
--				contraindications were found.
--
-- 01/18/2018   rewrote from 2014''s work
-- 02/22/2018   made changes to support new table names.
-- =================================================================
CREATE FUNCTION [dbo].[NDD_DrugDiseaseContraindications](
		@proposed_MEDID int,											-- medid of the proposed medication
		@proposed_GCN_SEQNO int,										-- gcn_seqno of the proposed medication
		@proposed_ROUTED_MED_ID int,									-- routed_med_id of the proposed medication
		@proposed_MedicationName varchar(255),							-- name of the proposed medication
		@existingDisease ExistingDisease readonly,						-- existing list of active diagnosis
		@existingActiveMedication Existing_Active_Medications readonly	-- existing list of active drugs
		)
RETURNS
@MedicationDisease table
	(
		PK int IDENTITY NOT NULL PRIMARY KEY,
		MedicationName varchar(255) null,
		SeverityLevel varchar(1) null,
		SeverityDescription varchar(255) null,
		NavigationCode varchar(2) null,
		NavigationDescription varchar(255) null,
		Code varchar(255),
		DiseaseDescription varchar(255) null,
		FDBDescription varchar(255) null
	)
AS
begin
	/*
	Valid Values Table
	DDXCN_SL	Description			PRM colors
	1			Contraindication	Highest - #d00000 (red)
	2			Severe Warning		Second Highest - #e2ae4a (dark orange)
	3			Moderate Warning	Third Highest - #ffcd00 (light orange)

	
	select * from RFMLNVD0_NAVIGATION_DESC
	ML_NAV_CODE  FML_NAV_CODE_DESC 
	------------ -----------------
	01           Equal
	02           Broader
	03           Narrower
	04           Related
	*/

	declare @MedicationName varchar(255)
	declare @GCN_SEQNO int
	declare @ROUTED_MED_ID int
		
	if ((ISNULL(@proposed_MEDID, 0) > 0) or (ISNULL(@proposed_GCN_SEQNO, 0) > 0) or (ISNULL(@proposed_ROUTED_MED_ID, 0) > 0))
	begin
		-- only the proposed medication for drug-disease contraindications
		insert into @MedicationDisease
			select * from dbo.NDD_BaseDrugDiseaseContraindications(@proposed_MEDID, @proposed_GCN_SEQNO, @proposed_ROUTED_MED_ID, @proposed_MedicationName, @existingDisease)
	end
	else begin
		-- check all medications for drug-disease contraindications
		declare out_cursor cursor for 
			select MedicationName, 
				(CASE WHEN MEDID is not null and MEDID > 0 THEN dbo.NDD_FindGCNSEQNO(MEDID) ELSE GCN_SEQNO END) as [GCN_SEQNO], 
				ROUTED_MED_ID
			from @existingActiveMedication

		open out_cursor
		fetch NEXT from out_cursor into @MedicationName, @GCN_SEQNO, @ROUTED_MED_ID

		while (@@fetch_status <> -1)
		begin
			if (@@fetch_status <> -2)
			begin
				insert into @MedicationDisease
					select * from dbo.NDD_BaseDrugDiseaseContraindications(0, @GCN_SEQNO, @ROUTED_MED_ID, @MedicationName, @existingDisease)
			end
						
			fetch NEXT from out_cursor into @MedicationName, @GCN_SEQNO, @ROUTED_MED_ID
		end -- of while
	end
	
	RETURN
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_DrugInteractionMonograph]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 03/09/2018
-- Description:	Returns monograph table enties for any drug to drug
--				interactions.
--
-- =================================================================
CREATE FUNCTION [dbo].[NDD_DrugInteractionMonograph](
			@DDI_CODEX int  -- the drug to drug codex value for the monograph to return
		)
RETURNS 
@MonographResults table
(
	MonographTitle varchar(MAX) null,
	MonographSeverity varchar(MAX) null,
	MechanismOfAction varchar(MAX) null,
	ClinicalEffects varchar(MAX) null,
	PredisposingFactors varchar(MAX) null,
	PatientManagement varchar(MAX) null,
	Discussion varchar(MAX) null,
	[References] varchar(MAX) null
)
as
begin
	declare @DDI_MONOX int
	declare @tmpStr varchar(255)
	declare @InteractionDescription varchar(255)
	declare @ClinicalEffectText1 varchar(100)
	declare @ClinicalEffectText2 varchar(100)
	declare @ClinicalEffectText3 varchar(100)
	declare @ClinicalEffectText4 varchar(100)
	declare @SeverityLevelDescription varchar(255)
	declare @SeverityDescription varchar(MAX)
	declare @MonographTitle varchar(MAX)
	declare @MonographSeverity varchar(MAX)
	declare @MechanismOfAction varchar(MAX)
	declare @ClinicalEffects varchar(MAX)
	declare @PredisposingFactors varchar(MAX)
	declare @PatientManagement varchar(MAX)
	declare @Discussion varchar(MAX)
	declare @References varchar(MAX)
	declare @IAMIDENTN varchar(1)

	select @DDI_MONOX = DDI_MONOX
	from NDD_RADIMMA5_MSTR WITH(NOLOCK)
	where IsDelete = 0 and DDI_CODEX = @DDI_CODEX

						
	if (ISNULL(@DDI_MONOX, 0) > 0)
	begin
		declare sl_cursor cursor for 
			select IAMTEXTN, IAMIDENTN
			from NDD_RADIMMO5_MONO WITH(NOLOCK)
			where IsDelete = 0 and DDI_MONOX = @DDI_MONOX
			order by ADI_MONOSN
		open sl_cursor
		fetch NEXT from sl_cursor into @tmpStr, @IAMIDENTN

		while (@@fetch_status <> -1)
		begin
			if (@@fetch_status <> -2)
			begin
				set @tmpStr = @tmpStr  + '' ''
				if (@IAMIDENTN = ''T'')
				begin
					if (@MonographTitle is null)
						set @MonographTitle = ''''
					set @MonographTitle = @MonographTitle + @tmpStr
				end
				else if (@IAMIDENTN = ''L'')
				begin
					if (@MonographSeverity is null)
						set @MonographSeverity = ''''
					set @MonographSeverity = @MonographSeverity + @tmpStr
				end
				else if (@IAMIDENTN = ''A'')
				begin
					if (@MechanismOfAction is null)
						set @MechanismOfAction = ''''
					set @MechanismOfAction = @MechanismOfAction + @tmpStr
				end
				else if (@IAMIDENTN = ''E'')
				begin
					if (@ClinicalEffects is null)
						set @ClinicalEffects = ''''
					set @ClinicalEffects = @ClinicalEffects + @tmpStr
				end
				else if (@IAMIDENTN = ''P'')
				begin
					if (@PredisposingFactors is null)
						set @PredisposingFactors = ''''
					set @PredisposingFactors = @PredisposingFactors + @tmpStr
				end
				else if (@IAMIDENTN = ''M'')
				begin
					if (@PatientManagement is null)
						set @PatientManagement = ''''
					set @PatientManagement = @PatientManagement + @tmpStr
				end
				else if (@IAMIDENTN = ''D'')
				begin
					if (@Discussion is null)
						set @Discussion = ''''
					set @Discussion = @Discussion + @tmpStr
				end
				else if (@IAMIDENTN = ''R'')
				begin
					if (@References is null)
						set @References = ''''
					set @References = @References + @tmpStr
				end
			end
			fetch NEXT from sl_cursor into @tmpStr, @IAMIDENTN
		end -- of while sl_cursor
									
		close sl_cursor
		deallocate sl_cursor
	end -- of if (ISNULL(@DDI_MONOX, 0) > 0)
				
	insert into  @MonographResults (MonographTitle, MonographSeverity, MechanismOfAction,
		ClinicalEffects, PredisposingFactors, PatientManagement, Discussion, [References])
	values (@MonographTitle, @MonographSeverity, @MechanismOfAction,
		@ClinicalEffects, @PredisposingFactors, @PatientManagement, @Discussion, @References)

	return
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_DrugToDrugInteraction]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 01/26/2018
-- Description:	Returns monograph table enties for any drug to drug
--				interactions.  If the table is empty no interactions
--				were found.
--
-- 02/22/2018   made changes to support new table names.
-- =================================================================
CREATE FUNCTION [dbo].[NDD_DrugToDrugInteraction](
		@proposed_MEDID int,											-- medid of the proposed medication
		@proposed_GCN_SEQNO int,										-- gcn_seqno of the proposed medication
		@proposed_ROUTED_MED_ID int,									-- routed_med_id of the proposed medication
		@proposed_MedicationName varchar(255),							-- name of the proposed medication
		@existingActiveMedication Existing_Active_Medications readonly	-- existing list of active drugs
		)
RETURNS 
@InteractionResults table
(
	PK int IDENTITY NOT NULL PRIMARY KEY,
	MedicationName1 varchar(255) null,
	MedicationName2 varchar(255) null,
	Severity_Level varchar(1) null,
	SeverityLevelDescription varchar(255) null,
	SeverityDescription varchar(MAX) null,
	ClinicalEffectText1 varchar(100) null,
	ClinicalEffectText2 varchar(100) null,
	ClinicalEffectText3 varchar(100) null,
	ClinicalEffectText4 varchar(100) null,
	InteractionDescription varchar(255) null,
	DDI_CODEX int null
)
AS
begin
/*
	see page 2325
	Valid values column IAMIDENTN, "LineIdentify"
	"A" Mechanism of Action
	"B" Blank Line
	"D" Discussion
	"E" Clinical Effects
	"L" Severity Level
	"M" Patient Management
	"P" Predisposing Factors
	"R" References
	"T" Monograph Title
	
	see page 1984
	DDI_SL Values		Severity Level Description			Severity Level Implications								PRM colors
	-------------		--------------------------------	------------------------------------------------------	-----------------------------
		1				Contraindicated Drug Combination	This drug combination is contraindicated and generally	Highest - #d00000 (red)
															should not be dispensed or administered...

		2				Severe Interaction					Action is required to reduce risk of severe adverse		Second Highest - #e2ae4a (dark orange)
															interaction.
		3				Moderate Interaction				Assess risk to patient and take action as needed.		Third Highest - #ffcd00 (light orange)
		
		9				Undetermined Severity –				Assess risk to patient and take action as needed.		Fourth Highest/Lowest - #d9e986 (light green)
						Alternative Therapy Interaction
*/

	if ((ISNULL(@proposed_MEDID, 0) > 0) or (ISNULL(@proposed_GCN_SEQNO, 0) > 0) or (ISNULL(@proposed_ROUTED_MED_ID, 0) > 0))
	begin
		
		insert into @InteractionResults (MedicationName1, MedicationName2, Severity_Level, SeverityLevelDescription,
					SeverityDescription,
					ClinicalEffectText1, ClinicalEffectText2, ClinicalEffectText3, ClinicalEffectText4,
					InteractionDescription, DDI_CODEX)
		select MedicationName1, MedicationName2, Severity_Level, SeverityLevelDescription,
					SeverityDescription,
					ClinicalEffectText1, ClinicalEffectText2, ClinicalEffectText3, ClinicalEffectText4,
					InteractionDescription, DDI_CODEX
		from dbo.NDD_BaseDrugToDrugInteraction (@proposed_MEDID, @proposed_GCN_SEQNO, @proposed_ROUTED_MED_ID, @proposed_MedicationName, @existingActiveMedication)
	end
	else begin
		-- if no proposed medication test active medication list against each other
		declare @DrugsToScreen table
		(
			PK int IDENTITY,
			MedicationName varchar(255) NULL,
			GCN_SEQNO int NULL,
			ROUTED_MED_ID int NULL,
			Tested bit null,
			Testing bit
		)

		declare @ToBeScreen Existing_Active_Medications
	
		declare @PK int
		declare @GCN_SEQNO int
		declare @ROUTED_MED_ID int
		declare @MedicationName varchar(255)
		declare @testing bit
		declare @Tested bit

		insert into @DrugsToScreen (MedicationName, GCN_SEQNO, ROUTED_MED_ID, Tested, Testing)
		select MedicationName, 
			(CASE WHEN MEDID is not null and MEDID > 0 THEN dbo.NDD_FindGCNSEQNO(MEDID) ELSE GCN_SEQNO END) as [GCN_SEQNO], 
			ROUTED_MED_ID, 0, 0
		from @existingActiveMedication

		declare @cnt int = 0
		select @cnt = COUNT(*) from @DrugsToScreen

		while (@cnt > 0)
		begin
			set @PK = null
			select top 1 @PK = PK, @MedicationName = MedicationName, @GCN_SEQNO = GCN_SEQNO, @ROUTED_MED_ID = ROUTED_MED_ID
			from @DrugsToScreen
			where Tested = 0

			update @DrugsToScreen set Tested = 1, Testing = 1 where PK = @PK

			delete @ToBeScreen

			insert into @ToBeScreen (MedicationName, GCN_SEQNO, ROUTED_MED_ID)
			select MedicationName, GCN_SEQNO, ROUTED_MED_ID
			from @DrugsToScreen
			where Testing = 0
			
			insert into @InteractionResults (MedicationName1, MedicationName2, Severity_Level, SeverityLevelDescription,
						SeverityDescription,
						ClinicalEffectText1, ClinicalEffectText2, ClinicalEffectText3, ClinicalEffectText4,
						InteractionDescription, DDI_CODEX)
			select MedicationName1, MedicationName2, Severity_Level, SeverityLevelDescription,
						SeverityDescription,
						ClinicalEffectText1, ClinicalEffectText2, ClinicalEffectText3, ClinicalEffectText4,
						InteractionDescription, DDI_CODEX
			from dbo.NDD_BaseDrugToDrugInteraction (0, @GCN_SEQNO, @ROUTED_MED_ID, @MedicationName, @ToBeScreen)

			update @DrugsToScreen set Testing = 0 where PK = @PK

			set @cnt = @cnt - 1
		end
	end
		
	RETURN
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_DuplicateIngredient]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- ===================================================================
-- Author:		CHM
-- Create date: 01/18/2018
-- Description:	Returns a table with duplicate ingredient enties. If 
--				the table is empty no duplicate ingredient were found.
--
-- 01/18/2018   rewrote from 2014''s work
-- 02/22/2018   made changes to support new table names.
-- ===================================================================
CREATE FUNCTION [dbo].[NDD_DuplicateIngredient](
		@proposed_MEDID int,											-- medid of the proposed medication
		@proposed_GCN_SEQNO int,										-- gcn_seqno of the proposed medication
		@proposed_ROUTED_MED_ID int,									-- routed_med_id of the proposed medication
		@proposed_MedicationName varchar(255),							-- name of the proposed medication
		@existingActiveMedication Existing_Active_Medications readonly	-- existing list of active drugs
		)

RETURNS 
@DuplicateIngredient table
	(
		PK int IDENTITY NOT NULL PRIMARY KEY,
		MedicationName1 varchar(255) null,
		MedicationName2 varchar(255) null,
		IngredientList varchar(MAX) null,
		ListCount int null
	)
	
AS
begin
	if ((ISNULL(@proposed_MEDID, 0) > 0) or (ISNULL(@proposed_GCN_SEQNO, 0) > 0) or (ISNULL(@proposed_ROUTED_MED_ID, 0) > 0))
	begin
		-- only the proposed medication for duplicate ingredient
		insert into @DuplicateIngredient (MedicationName1, MedicationName2, IngredientList, ListCount)
			select MedicationName1, MedicationName2, IngredientList, ListCount
			from dbo.NDD_BaseDuplicateIngredient(@proposed_MEDID, @proposed_GCN_SEQNO, @proposed_ROUTED_MED_ID, @proposed_MedicationName, @existingActiveMedication)
	end
	else begin
		-- if no proposed medication test active medication list against each other
		declare @DrugsToScreen table
		(
			PK int IDENTITY,
			MedicationName varchar(255) NULL,
			MEDID int NULL,
			GCN_SEQNO int NULL,
			ROUTED_MED_ID int NULL,
			Tested bit null,
			Testing bit
		)

		declare @ToBeScreen Existing_Active_Medications
	
		declare @PK int
		declare @MEDID int
		declare @GCN_SEQNO int
		declare @ROUTED_MED_ID int
		declare @MedicationName varchar(255)
		declare @testing bit
		declare @Tested bit

		insert into @DrugsToScreen (MedicationName, MEDID, GCN_SEQNO, ROUTED_MED_ID, Tested, Testing)
		select MedicationName, MEDID, GCN_SEQNO, ROUTED_MED_ID, 0, 0
		from @existingActiveMedication

		declare @cnt int = 0
		select @cnt = COUNT(*) from @DrugsToScreen

		while (@cnt > 0)
		begin
			set @PK = null
			select top 1 @PK = PK, @MedicationName = MedicationName, @MEDID = MEDID, @GCN_SEQNO = GCN_SEQNO, @ROUTED_MED_ID = ROUTED_MED_ID
			from @DrugsToScreen
			where Tested = 0

			update @DrugsToScreen set Tested = 1, Testing = 1 where PK = @PK

			delete @ToBeScreen

			insert into @ToBeScreen (MedicationName, GCN_SEQNO, ROUTED_MED_ID)
			select MedicationName, GCN_SEQNO, ROUTED_MED_ID
			from @DrugsToScreen
			where Testing = 0
			
			insert into @DuplicateIngredient (MedicationName1, MedicationName2, IngredientList, ListCount)
			select MedicationName1, MedicationName2, IngredientList, ListCount
			from dbo.NDD_BaseDuplicateIngredient (@MEDID, @GCN_SEQNO, @ROUTED_MED_ID, @MedicationName, @ToBeScreen)

			update @DrugsToScreen set Testing = 0 where PK = @PK

			set @cnt = @cnt - 1
		end
	end

	-- check for duplicate medication name
	insert into @DuplicateIngredient (MedicationName1,  ListCount)
	select t1.MedicationName + '' appears more than once'', count(*) as [ListCount]
	from @existingActiveMedication t1
	group by t1.MedicationName
	having COUNT(*) > 1

	return
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_DuplicateTherapy]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 01/23/2018
-- Description:	Returns a table with duplicate therapy enties.  If 
--				the table is empty no duplicate therapy were found.
--
-- 01/23/2018   rewrote from 2014''s work
-- 02/22/2018   made changes to support new table names.
-- =================================================================
CREATE FUNCTION [dbo].[NDD_DuplicateTherapy](
		@proposed_MEDID int,											-- medid of the proposed medication
		@proposed_GCN_SEQNO int,										-- gcn_seqno of the proposed medication
		@proposed_ROUTED_MED_ID int,									-- routed_med_id of the proposed medication
		@proposed_MedicationName varchar(255),							-- name of the proposed medication
		@existingActiveMedication Existing_Active_Medications readonly	-- existing list of active drugs
		)

RETURNS 
@DuplicateTherapy table
(
	PK int IDENTITY NOT NULL PRIMARY KEY,
	MedicationName1 varchar(255) null,
	MedicationName2 varchar(255) null,
	DPT_Allowance int null,
	ClassDescription varchar(MAX) null
)
AS
begin
	
	if ((ISNULL(@proposed_MEDID, 0) > 0) or (ISNULL(@proposed_GCN_SEQNO, 0) > 0) or (ISNULL(@proposed_ROUTED_MED_ID, 0) > 0))
	begin
		insert into @DuplicateTherapy (MedicationName1, MedicationName2, DPT_Allowance, ClassDescription)
		select MedicationName1, MedicationName2, DPT_Allowance, ClassDescription
		from dbo.NDD_BaseDuplicateTherapy (@proposed_MEDID, @proposed_GCN_SEQNO, @proposed_ROUTED_MED_ID, @proposed_MedicationName, @existingActiveMedication)
	end
	else begin
		-- if no proposed medication test active medication list against each other
		declare @DrugsToScreen table
		(
			PK int IDENTITY,
			MedicationName varchar(255) NULL,
			GCN_SEQNO int NULL,
			ROUTED_MED_ID int NULL,
			Tested bit null,
			Testing bit
		)

		declare @ToBeScreen Existing_Active_Medications
	
		declare @PK int
		declare @GCN_SEQNO int
		declare @ROUTED_MED_ID int
		declare @MedicationName varchar(255)
		declare @testing bit
		declare @Tested bit

		insert into @DrugsToScreen (MedicationName, GCN_SEQNO, ROUTED_MED_ID, Tested, Testing)
		select MedicationName, 
			(CASE WHEN MEDID is not null and MEDID > 0 THEN dbo.NDD_FindGCNSEQNO(MEDID) ELSE GCN_SEQNO END) as [GCN_SEQNO], 
			ROUTED_MED_ID, 0, 0
		from @existingActiveMedication

		declare @cnt int = 0
		select @cnt = COUNT(*) from @DrugsToScreen

		while (@cnt > 0)
		begin
			set @PK = null
			select top 1 @PK = PK, @MedicationName = MedicationName, @GCN_SEQNO = GCN_SEQNO, @ROUTED_MED_ID = ROUTED_MED_ID
			from @DrugsToScreen
			where Tested = 0

			update @DrugsToScreen set Tested = 1, Testing = 1 where PK = @PK

			delete @ToBeScreen

			insert into @ToBeScreen (MedicationName, GCN_SEQNO, ROUTED_MED_ID)
			select MedicationName, GCN_SEQNO, ROUTED_MED_ID
			from @DrugsToScreen
			where Testing = 0
			
			insert into @DuplicateTherapy (MedicationName1, MedicationName2, DPT_Allowance, ClassDescription)
			select MedicationName1, MedicationName2, DPT_Allowance, ClassDescription
			from dbo.NDD_BaseDuplicateTherapy (0, @GCN_SEQNO, @ROUTED_MED_ID, @MedicationName, @ToBeScreen)

			update @DrugsToScreen set Testing = 0 where PK = @PK

			set @cnt = @cnt - 1
		end
	end

	RETURN
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_FindMedName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 01/24/2014
-- Description:	Returns med name found from MED_NAME_ID, MEDID, 
--				GCN_SEQNO or ROUTED_MED_ID.  If more than one value
--				is supplied, then the first one found is return.
--				The search order is the parameter order.
--
-- 02/22/2018   made changes to support new table names.
-- =================================================================
CREATE FUNCTION [dbo].[NDD_FindMedName](
		@ROUTED_MED_ID int = 0
		,@MEDID int = 0
		,@GCN_SEQNO int = 0
		,@MED_NAME_ID int = 0
		)
RETURNS varchar(255)
AS
begin
	declare @medName varchar(255)
		
	if ((ISNULL(@ROUTED_MED_ID, 0) > 0) AND (@medName is null))
	begin
		select top 1 @medName = t2.MED_NAME
		from NDD_RMIRMID1_ROUTED_MED t1
			inner join NDD_RMINMID1_MED_NAME t2 on t1.MED_NAME_ID = t2.MED_NAME_ID
			where t1.ROUTED_MED_ID = @ROUTED_MED_ID
	end
	
	if ((ISNULL(@MEDID, 0) > 0) AND (@medName is null))
	begin
		select top 1 @medName = t4.MED_NAME
		from NDD_RMIID1_MED t1 
			inner join NDD_RMIDFID1_ROUTED_DOSE_FORM_MED t2 ON t1.ROUTED_DOSAGE_FORM_MED_ID = t2.ROUTED_DOSAGE_FORM_MED_ID
			inner join NDD_RMIRMID1_ROUTED_MED t3 on t2.ROUTED_MED_ID = t3.ROUTED_MED_ID
			inner join NDD_RMINMID1_MED_NAME t4 on t3.MED_NAME_ID = t4.MED_NAME_ID
			where t1.MEDID = @MEDID
	end
	
	if ((ISNULL(@GCN_SEQNO, 0) > 0) AND (@medName is null))
	begin
		select top 1 @medName = t4.MED_NAME
		from NDD_RMIID1_MED t1 
			inner join NDD_RMIDFID1_ROUTED_DOSE_FORM_MED t2 ON t1.ROUTED_DOSAGE_FORM_MED_ID = t2.ROUTED_DOSAGE_FORM_MED_ID
			inner join NDD_RMIRMID1_ROUTED_MED t3 on t2.ROUTED_MED_ID = t3.ROUTED_MED_ID
			inner join NDD_RMINMID1_MED_NAME t4 on t3.MED_NAME_ID = t4.MED_NAME_ID
			where t1.GCN_SEQNO = @GCN_SEQNO
	end
	
	if ((ISNULL(@MED_NAME_ID, 0) > 0) AND (@medName is null))
	BEGIN
		select top 1 @medName = MED_NAME from NDD_RMINMID1_MED_NAME where MED_NAME_ID = @MED_NAME_ID
	END

	return @medName
end' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_GenericDoseRangeChecking]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =================================================================
-- Author:		RSH
-- Create date: 11/29/2018
-- Description:	Returns a table with dose range entries. If no rows 
--				are returned, no dose range data is available.
--
-- NOTES:
--		Column names that start with "NTE" which is short
--		for "Not To Exceed".
--
-- =================================================================

CREATE FUNCTION [dbo].[NDD_GenericDoseRangeChecking](
	@proposed_MEDID int = NULL,		-- medid of the proposed medication, required if gcn_seqno is not given
	@proposed_GCN_SEQNO int	= NULL	-- gcn_seqno of the proposed medication, will lookup by medid if null or zero
	)
RETURNS
@NDD_GenericDosingRangeValues table
(
	PK int IDENTITY NOT NULL PRIMARY KEY,
	MasterMedRouteId decimal(5, 0),
	MasterMedRouteDesc varchar(50),
	MasterDoseType varchar(2) NOT NULL,
	MasterDiseaseId decimal(8, 0),
	MasterMinAgeInDays decimal(5, 0) NOT NULL,
	MasterMaxAgeInDays decimal(5, 0) NOT NULL,
	MasterIsGestationalBirthAgeRequired bit NOT NULL,
	MasterMinGestationAgeInWeeks decimal(2, 0) NOT NULL,
	MasterMaxGestationAgeInWeeks decimal(2, 0) NOT NULL,
	MasterIsWeightRequired bit NOT NULL,
	MasterMinWeightInGrams decimal(6, 0) NOT NULL,
	MasterMaxWeightInGrams decimal(6, 0) NOT NULL,
	MasterIsSurfaceAreaRequired bit NOT NULL,
	MasterLowDose decimal(8, 3),
	MasterLowDoseUnits varchar(12),
	MasterHighDose decimal(8, 3),
	MasterHighDoseUnits varchar(12),
	MasterMaximumDailyDose decimal(8, 3),
	MasterMaximumDailyDoseUnits varchar(12),
	MasterMaximumSingleDose decimal(8, 3),
	MasterMaximumSingleDoseUnits varchar(12),
	MasterMaximumLifetimeDose decimal(8, 3),
	MasterMaximumLifetimeDoseUnits varchar(12),
	MasterLowEliminationHalfLife decimal(5, 2),
	MasterHighEliminationHalfLife decimal(5, 2),
	MasterEliminationHalfLifeUnits varchar(12),
	MasterNTEAmountPerSingleDose decimal(8, 3) NOT NULL,
	MasterNTEAmountPerSingleDoseUnits varchar(12),
	MasterLowFrequency decimal(5, 3),
	MasterHighFrequency decimal(5, 3),
	MasterLowDuration decimal(5, 0),
	MasterHighDuration decimal(5, 0),
	MasterIsAffectedByHepaticImpairment bit NOT NULL,
	MasterIsAffectedByRenalImpairment bit NOT NULL,
	MasterCreatinineClearanceThreshold decimal(3, 0),
	MasterCreatinineClearanceThresholdUnits nvarchar(13),
	ModuleSource varchar(10),
	ModuleMinAgeInDays numeric(5, 0),
	ModuleMaxAgeInDays numeric(5, 0),
	ModuleLowDose decimal(14, 6),
	ModuleLowDoseUnits varchar(60),
	ModuleHighDose decimal(14, 6),
	ModuleHighDoseUnits varchar(60),
	ModuleLowDoseForm decimal(14, 6),
	ModuleLowDoseFormUnits varchar(60),
	ModuleHighDoseForm decimal(14, 6),
	ModuleHighDoseFormUnits varchar(60),
	ModuleNTEDailyDoseStrength decimal(14, 6),
	ModuleNTEDailyDoseStrengthUnits varchar(60),
	ModuleNTEDailyDoseForm decimal(14, 6),
	ModuleNTEDailyDoseFormUnits varchar(60),
	HIC_SEQN decimal(6, 0),
	IngredientStrength numeric(19, 6),
	IngredientStrengthUOMAbbr varchar(10),
	IngredientStrengthUOMDesc varchar(50),
	IngredientVolume numeric(19, 6),
	IngredientVolumeUOMAbbr varchar(10),
	IngredientVolumeUOMDesc varchar(50)
)
/*
NOTES:
	The following table lists the three Min/Max Dose Modules and indicates the age group defined by the
	module and the context for each.
	DRCM covers patients from 0 days to 110 years, while NEOM covers patients 0 to 364 days. The age for a
	dosing record is coded in days.

	Pediatric Dose Module (PDM) 
		Age in years: [0.083, 18) years
		Age in days: 30 to 6569 days

	Min/Max Adult Daily Dose Module (MMAD) 
		Age in years: [18, 65) years
		Age in days: 6570 to 23724

	Min/Max Geriatric Daily Dose Module (MMGD)
		Age in years: [65, 110] years
		Age in days: 23725 to 40150
*/
AS
BEGIN
	IF (ISNULL(@proposed_GCN_SEQNO, 0) = 0) BEGIN
		SELECT @proposed_GCN_SEQNO = GCN_SEQNO
		FROM NDD_RMIID1_MED
		WHERE MEDID = @proposed_MEDID
	END

	INSERT INTO @NDD_GenericDosingRangeValues
	SELECT
		rt.MED_ROUTE_ID as ''MasterMedRouteId'',
		rt.RT_DESC_LONG as ''MasterMedRouteDesc'',
		drcmMaster.DR2_DOSTPI as ''MasterDoseType'',
		drcmMaster.DXID as ''MasterDiseaseId'',
		drcmMaster.DR2_LOAGED as ''MasterMinAgeInDays'',
		drcmMaster.DR2_HIAGED as ''MasterMaxAgeInDays'',
		drcmMaster.NEOM_GEST_BIRTH_AGE_REQ_IND as ''MasterIsGestationalBirthAgeRequired'',
		drcmMaster.NEOM_LOW_GEST_BIRTH_AGE_WEEKS as ''MasterMinGestationAgeInWeeks'',
		drcmMaster.NEOM_HIGH_GEST_BIRTH_AGE_WEEKS as ''MasterMaxGestationAgeInWeeks'',
		drcmMaster.WEIGHT_REQ_IND as ''MasterIsWeightRequired'',
		drcmMaster.LOW_CURRENT_WEIGHT_GRAMS as ''MasterMinWeightInGrams'',
		drcmMaster.HIGH_CURRENT_WEIGHT_GRAMS as ''MasterMaxWeightInGrams'',
		CASE WHEN lowDoseUnits.UNITS_CTYP = 2 OR highDoseUnits.UNITS_CTYP = 2 THEN 1 ELSE 0 END as ''MasterIsSurfaceAreaRequired'',
		drcmMaster.DR2_LODOSD as ''MasterLowDose'',
		lowDoseUnits.UNITS_DESC as ''MasterLowDoseUnits'',
		drcmMaster.DR2_HIDOSD as ''MasterHighDose'',
		highDoseUnits.UNITS_DESC as ''MasterHighDoseUnits'',
		drcmMaster.DR2_MXDOSD as ''MasterMaximumDailyDose'',
		maximumDailyDoseUnits.UNITS_DESC as ''MasterMaximumDailyDoseUnits'',
		drcmMaster.DR2_MX1DOS as ''MasterMaximumSingleDose'',
		maximumSingleDoseUnits.UNITS_DESC as ''MasterMaximumSingleDoseUnits'',
		drcmMaster.DR2_MXLIFD as ''MasterMaximumLifetimeDose'',
		maximumLifetimeDoseUnits.UNITS_DESC as ''MasterMaximumLifetimeDoseUnits'',
		drcmMaster.DR2_THAFLO as ''MasterLowEliminationHalfLife'',
		drcmMaster.DR2_THAFHI as ''MasterHighEliminationHalfLife'',
		CASE WHEN drcmMaster.DR2_THAFU = ''01'' THEN ''minutes'' WHEN drcmMaster.DR2_THAFU = ''02'' THEN ''hours'' WHEN drcmMaster.DR2_THAFU = ''03'' THEN ''days'' ELSE NULL END as ''MasterEliminationHalfLifeUnits'',
		drcmMaster.NTE_SINGLE_DOSE as ''MasterNTEAmountPerSingleDose'',
		maximumNteDoseUnits.UNITS_DESC as ''MasterNTEAmountPerSingleDoseUnits'',
		drcmMaster.DR2_LOFREQ as ''MasterLowFrequency'',
		drcmMaster.DR2_HIFREQ as ''MasterHighFrequency'',
		drcmMaster.DR2_LODOTX as ''MasterLowDuration'',
		drcmMaster.DR2_HIDOTX as ''MasterHighDuration'',
		CASE WHEN drcmMaster.DR2_HEPIMP = ''Y'' THEN 1 ELSE 0 END as ''MasterIsAffectedByHepaticImpairment'',
		CASE WHEN drcmMaster.DR2_RENIMP = ''Y'' THEN 1 ELSE 0 END as ''MasterIsAffectedByRenalImpairment'',
		drcmMaster.DR2_CRCLTH as ''MasterCreatinineClearanceThreshold'',
		CASE WHEN drcmMaster.DR2_CRCLU = ''01'' THEN N''ML/MIN'' WHEN drcmMaster.DR2_CRCLU = ''02'' THEN N''ML/MIN/1.73M²'' ELSE NULL END as ''MasterCreatinineClearanceThresholdUnits'',
		module.*,
		ingStrength.HIC_SEQN as ''HIC_SEQN'',
		ingStrength.STRENGTH as ''IngredientStrength'',
		ingStrengthUom.UOM_ABBR as ''IngredientStrengthUOMAbbr'',
		ingStrengthUom.UOM_DESC as ''IngredientStrengthUOMDesc'',
		ingStrength.VOLUME as ''IngredientVolume'',
		ingVolumeUom.UOM_ABBR as ''IngredientVolumeUOMAbbr'',
		ingVolumeUom.UOM_DESC as ''IngredientVolumeUOMDesc''
	FROM NDD_RDRCNMA2_MSTR drcmMaster
	OUTER APPLY (
		SELECT * FROM (
			SELECT
				''Pediatric'' as ''ModuleSource'',
				pediatric.PDM_MNAGE as ''ModuleMinAgeInDays'',
				pediatric.PDM_MXAGE as ''ModuleMaxAgeInDays'',
				pediatric.PDM_MND as ''ModuleLowDose'',
				ldUnits.PDM_UNDESC as ''ModuleLowDoseUnits'',
				pediatric.PDM_MXD as ''ModuleHighDose'',
				hdUnits.PDM_UNDESC as ''ModuleHighDoseUnits'',
				pediatric.PDM_MNU as ''ModuleLowDoseForm'',
				ldfUnits.PDM_UNDESC as ''ModuleLowDoseFormUnits'',
				pediatric.PDM_MXU as ''ModuleHighDoseForm'',
				hdfUnits.PDM_UNDESC as ''ModuleHighDoseFormUnits'',
				pediatric.PDM_NTED as ''ModuleNTEDailyDoseStrength'',
				nteStrengthUnits.PDM_UNDESC as ''ModuleNTEDailyDoseStrengthUnits'',
				pediatric.PDM_NTEU as ''ModuleNTEDailyDoseForm'',
				nteFormUnits.PDM_UNDESC as ''ModuleNTEDailyDoseFormUnits''
			FROM NDD_RPDMMA1_PEDI_MSTR pediatric
			LEFT OUTER JOIN NDD_RPDMUND0_PEDI_DOSE_UNIT_DESC ldUnits ON ldUnits.PDM_UNIT = pediatric.PDM_MNDU
			LEFT OUTER JOIN NDD_RPDMUND0_PEDI_DOSE_UNIT_DESC hdUnits ON hdUnits.PDM_UNIT = pediatric.PDM_MXDU
			LEFT OUTER JOIN NDD_RPDMUND0_PEDI_DOSE_UNIT_DESC ldfUnits ON ldfUnits.PDM_UNIT = pediatric.PDM_MNUF
			LEFT OUTER JOIN NDD_RPDMUND0_PEDI_DOSE_UNIT_DESC hdfUnits ON hdfUnits.PDM_UNIT = pediatric.PDM_MXUF
			LEFT OUTER JOIN NDD_RPDMUND0_PEDI_DOSE_UNIT_DESC nteStrengthUnits ON nteStrengthUnits.PDM_UNIT = pediatric.PDM_NTEDU
			LEFT OUTER JOIN NDD_RPDMUND0_PEDI_DOSE_UNIT_DESC nteFormUnits ON nteFormUnits.PDM_UNIT = pediatric.PDM_NTEUF
			WHERE pediatric.IsDelete = 0
				AND pediatric.GCN_SEQNO = drcmMaster.GCN_SEQNO
	
			UNION ALL

			SELECT
				''Adult'' as ''ModuleSource'',
				6570 as ''ModuleMinAgeInDays'',
				23724 as ''ModuleMaxAgeInDays'',
				adult.MMAR_MND as ''ModuleLowDose'',
				adult.MMAR_MNDU as ''ModuleLowDoseUnits'',
				adult.MMAR_MXD as ''ModuleHighDose'',
				adult.MMAR_MXDU as ''ModuleHighDoseUnits'',
				adult.MMAR_MNU as ''ModuleLowDoseForm'',
				adult.MMAR_MNUF as ''ModuleLowDoseFormUnits'',
				adult.MMAR_MXU as ''ModuleHighDoseForm'',
				adult.MMAR_MXUF as ''ModuleHighDoseFormUnits'',
				NULL as ''ModuleNTEDailyDoseStrength'',
				NULL as ''ModuleNTEDailyDoseStrengthUnits'',
				NULL as ''ModuleNTEDailyDoseForm'',
				NULL as ''ModuleNTEDailyDoseFormUnits''
			FROM NDD_RMMARMA0_ADULT_RANGE_MSTR adult
			WHERE adult.IsDelete = 0
				AND adult.GCN_SEQNO = drcmMaster.GCN_SEQNO

			UNION ALL

			SELECT
				''Geriatric'' as ''ModuleSource'',
				23725 as ''ModuleMinAgeInDays'',
				40150 as ''ModuleMaxAgeInDays'',
				geriatric.MMGR_MND as ''ModuleLowDose'',
				geriatric.MMGR_MNDU as ''ModuleLowDoseUnits'',
				geriatric.MMGR_MXD as ''ModuleHighDose'',
				geriatric.MMGR_MXDU as ''ModuleHighDoseUnits'',
				geriatric.MMGR_MNU as ''ModuleLowDoseForm'',
				geriatric.MMGR_MNUF as ''ModuleLowDoseFormUnits'',
				geriatric.MMGR_MXU as ''ModuleHighDoseForm'',
				geriatric.MMGR_MXUF as ''ModuleHighDoseFormUnits'',
				NULL as ''ModuleNTEDailyDoseStrength'',
				NULL as ''ModuleNTEDailyDoseStrengthUnits'',
				NULL as ''ModuleNTEDailyDoseForm'',
				NULL as ''ModuleNTEDailyDoseFormUnits''
			FROM NDD_RMMGRMA1_GERI_RANGE_MSTR geriatric 
			WHERE geriatric.IsDelete = 0 
				AND geriatric.GCN_SEQNO = drcmMaster.GCN_SEQNO
		) modules
		WHERE (
				modules.ModuleMinAgeInDays = 0 AND drcmMaster.DR2_LOAGED = 0
				OR modules.ModuleMinAgeInDays >= drcmMaster.DR2_LOAGED AND (modules.ModuleMinAgeInDays <= drcmMaster.DR2_HIAGED OR ISNULL(drcmMaster.DR2_HIAGED, 0) = 0)
			)
			OR	(
				modules.ModuleMaxAgeInDays = 0 AND drcmMaster.DR2_HIAGED = 0
				OR modules.ModuleMaxAgeInDays >= drcmMaster.DR2_LOAGED AND (modules.ModuleMaxAgeInDays <= drcmMaster.DR2_HIAGED OR ISNULL(drcmMaster.DR2_HIAGED, 0) = 0)
			)
	) module
	LEFT OUTER JOIN NDD_RGCNSTR0_INGREDIENT_STRENGTH ingStrength ON ingStrength.GCN_SEQNO = drcmMaster.GCN_SEQNO
	LEFT OUTER JOIN NDD_RSTRUOM0_STRENGTH_UOM ingStrengthUom on ingStrengthUom.UOM_ID = ingStrength.STRENGTH_UOM_ID
	LEFT OUTER JOIN NDD_RSTRUOM0_STRENGTH_UOM ingVolumeUom on ingVolumeUom.UOM_ID = ingStrength.VOLUME_UOM_ID
    LEFT OUTER JOIN NDD_RPEIRM0_RT_MSTR rt ON rt.DR2_RT = drcmMaster.DR2_RT
	LEFT OUTER JOIN NDD_RDRCUND0_UNITS_DESC lowDoseUnits ON lowDoseUnits.DR2_UNITS = drcmMaster.DR2_LODOSU
	LEFT OUTER JOIN NDD_RDRCUND0_UNITS_DESC highDoseUnits ON highDoseUnits.DR2_UNITS = drcmMaster.DR2_HIDOSU
	LEFT OUTER JOIN NDD_RDRCUND0_UNITS_DESC maximumDailyDoseUnits ON maximumDailyDoseUnits.DR2_UNITS = drcmMaster.DR2_MXDOSU
	LEFT OUTER JOIN NDD_RDRCUND0_UNITS_DESC maximumSingleDoseUnits ON maximumSingleDoseUnits.DR2_UNITS = drcmMaster.DR2_MX1DSU
	LEFT OUTER JOIN NDD_RDRCUND0_UNITS_DESC maximumLifetimeDoseUnits ON maximumLifetimeDoseUnits.DR2_UNITS = drcmMaster.DR2_MXLIFU
	LEFT OUTER JOIN NDD_RDRCUND0_UNITS_DESC maximumNteDoseUnits ON maximumNteDoseUnits.DR2_UNITS = drcmMaster.NTE_SINGLE_DOSE_UNIT_CODE
	WHERE
		drcmMaster.GCN_SEQNO = @proposed_GCN_SEQNO
		AND drcmMaster.IsDelete = 0

	RETURN
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_GenericPediatricDoseRangeChecking]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =================================================================
-- Author:		RSH
-- Create date: 11/29/2018
-- Description:	Returns a table with pediatric dose range entries. If no rows 
--				are returned, no dose range data is available.
--
--	NOTE:	Will not return any rows for ages below 30 days or
--			above 6569 days. 
--
-- =================================================================

CREATE FUNCTION [dbo].[NDD_GenericPediatricDoseRangeChecking](
	@proposed_MEDID int = NULL,		-- medid of the proposed medication, required if gcn_seqno is not given
	@proposed_GCN_SEQNO int	= NULL	-- gcn_seqno of the proposed medication, will lookup by medid if null or zero
	)
RETURNS
@NDD_GenericPediatricDosingRangeValues table
(
	PK int IDENTITY NOT NULL PRIMARY KEY,
	MasterMedRouteId decimal(5, 0),
	MasterMedRouteDesc varchar(50),
	MasterDoseType varchar(2),
	MasterDiseaseId decimal(8, 0),
	MasterMinAgeInDays decimal(5, 0),
	MasterMaxAgeInDays decimal(5, 0),
	MasterIsGestationalBirthAgeRequired bit,
	MasterMinGestationAgeInWeeks decimal(2, 0),
	MasterMaxGestationAgeInWeeks decimal(2, 0),
	MasterIsWeightRequired bit,
	MasterMinWeightInGrams decimal(6, 0),
	MasterMaxWeightInGrams decimal(6, 0),
	MasterIsSurfaceAreaRequired bit,
	MasterLowDose decimal(8, 3),
	MasterLowDoseUnits varchar(12),
	MasterHighDose decimal(8, 3),
	MasterHighDoseUnits varchar(12),
	MasterMaximumDailyDose decimal(8, 3),
	MasterMaximumDailyDoseUnits varchar(12),
	MasterMaximumSingleDose decimal(8, 3),
	MasterMaximumSingleDoseUnits varchar(12),
	MasterMaximumLifetimeDose decimal(8, 3),
	MasterMaximumLifetimeDoseUnits varchar(12),
	MasterLowEliminationHalfLife decimal(5, 2),
	MasterHighEliminationHalfLife decimal(5, 2),
	MasterEliminationHalfLifeUnits varchar(12),
	MasterNTEAmountPerSingleDose decimal(8, 3),
	MasterNTEAmountPerSingleDoseUnits varchar(12),
	MasterLowFrequency decimal(5, 3),
	MasterHighFrequency decimal(5, 3),
	MasterLowDuration decimal(5, 0),
	MasterHighDuration decimal(5, 0),
	MasterIsAffectedByHepaticImpairment bit,
	MasterIsAffectedByRenalImpairment bit,
	MasterCreatinineClearanceThreshold decimal(3, 0),
	MasterCreatinineClearanceThresholdUnits nvarchar(13),
	ModuleSource varchar(10) NOT NULL,
	ModuleMinAgeInDays numeric(5, 0) NOT NULL,
	ModuleMaxAgeInDays numeric(5, 0) NOT NULL,
	ModuleLowDose decimal(14, 6),
	ModuleLowDoseUnits varchar(60),
	ModuleHighDose decimal(14, 6),
	ModuleHighDoseUnits varchar(60),
	ModuleLowDoseForm decimal(14, 6),
	ModuleLowDoseFormUnits varchar(60),
	ModuleHighDoseForm decimal(14, 6),
	ModuleHighDoseFormUnits varchar(60),
	ModuleNTEDailyDoseStrength decimal(14, 6),
	ModuleNTEDailyDoseStrengthUnits varchar(60),
	ModuleNTEDailyDoseForm decimal(14, 6),
	ModuleNTEDailyDoseFormUnits varchar(60),
	HIC_SEQN decimal(6, 0),
	IngredientStrength numeric(19, 6),
	IngredientStrengthUOMAbbr varchar(10),
	IngredientStrengthUOMDesc varchar(50),
	IngredientVolume numeric(19, 6),
	IngredientVolumeUOMAbbr varchar(10),
	IngredientVolumeUOMDesc varchar(50)
)
AS
BEGIN
	IF (ISNULL(@proposed_GCN_SEQNO, 0) = 0) BEGIN
		SELECT @proposed_GCN_SEQNO = GCN_SEQNO
		FROM NDD_RMIID1_MED
		WHERE MEDID = @proposed_MEDID
	END

	INSERT INTO @NDD_GenericPediatricDosingRangeValues
	SELECT
		rt.MED_ROUTE_ID as ''MasterMedRouteId'',
		rt.RT_DESC_LONG as ''MasterMedRouteDesc'',
		drcmMaster.DR2_DOSTPI as ''MasterDoseType'',
		drcmMaster.DXID as ''MasterDiseaseId'',
		drcmMaster.DR2_LOAGED as ''MasterMinAgeInDays'',
		drcmMaster.DR2_HIAGED as ''MasterMaxAgeInDays'',
		drcmMaster.NEOM_GEST_BIRTH_AGE_REQ_IND as ''MasterIsGestationalBirthAgeRequired'',
		drcmMaster.NEOM_LOW_GEST_BIRTH_AGE_WEEKS as ''MasterMinGestationAgeInWeeks'',
		drcmMaster.NEOM_HIGH_GEST_BIRTH_AGE_WEEKS as ''MasterMaxGestationAgeInWeeks'',
		drcmMaster.WEIGHT_REQ_IND as ''MasterIsWeightRequired'',
		drcmMaster.LOW_CURRENT_WEIGHT_GRAMS as ''MasterMinWeightInGrams'',
		drcmMaster.HIGH_CURRENT_WEIGHT_GRAMS as ''MasterMaxWeightInGrams'',
		CASE WHEN lowDoseUnits.UNITS_CTYP IS NULL THEN NULL WHEN lowDoseUnits.UNITS_CTYP = 2 OR highDoseUnits.UNITS_CTYP = 2 THEN 1 ELSE 0 END as ''MasterIsSurfaceAreaRequired'',
		drcmMaster.DR2_LODOSD as ''MasterLowDose'',
		lowDoseUnits.UNITS_DESC as ''MasterLowDoseUnits'',
		drcmMaster.DR2_HIDOSD as ''MasterHighDose'',
		highDoseUnits.UNITS_DESC as ''MasterHighDoseUnits'',
		drcmMaster.DR2_MXDOSD as ''MasterMaximumDailyDose'',
		maximumDailyDoseUnits.UNITS_DESC as ''MasterMaximumDailyDoseUnits'',
		drcmMaster.DR2_MX1DOS as ''MasterMaximumSingleDose'',
		maximumSingleDoseUnits.UNITS_DESC as ''MasterMaximumSingleDoseUnits'',
		drcmMaster.DR2_MXLIFD as ''MasterMaximumLifetimeDose'',
		maximumLifetimeDoseUnits.UNITS_DESC as ''MasterMaximumLifetimeDoseUnits'',
		drcmMaster.DR2_THAFLO as ''MasterLowEliminationHalfLife'',
		drcmMaster.DR2_THAFHI as ''MasterHighEliminationHalfLife'',
		CASE WHEN drcmMaster.DR2_THAFU IS NULL THEN NULL WHEN drcmMaster.DR2_THAFU = ''01'' THEN ''minutes'' WHEN drcmMaster.DR2_THAFU = ''02'' THEN ''hours'' WHEN drcmMaster.DR2_THAFU = ''03'' THEN ''days'' ELSE NULL END as ''MasterEliminationHalfLifeUnits'',
		drcmMaster.NTE_SINGLE_DOSE as ''MasterNTEAmountPerSingleDose'',
		maximumNteDoseUnits.UNITS_DESC as ''MasterNTEAmountPerSingleDoseUnits'',
		drcmMaster.DR2_LOFREQ as ''MasterLowFrequency'',
		drcmMaster.DR2_HIFREQ as ''MasterHighFrequency'',
		drcmMaster.DR2_LODOTX as ''MasterLowDuration'',
		drcmMaster.DR2_HIDOTX as ''MasterHighDuration'',
		CASE WHEN drcmMaster.DR2_HEPIMP IS NULL THEN NULL WHEN drcmMaster.DR2_HEPIMP = ''Y'' THEN 1 ELSE 0 END as ''MasterIsAffectedByHepaticImpairment'',
		CASE WHEN drcmMaster.DR2_RENIMP IS NULL THEN NULL WHEN drcmMaster.DR2_RENIMP = ''Y'' THEN 1 ELSE 0 END as ''MasterIsAffectedByRenalImpairment'',
		drcmMaster.DR2_CRCLTH as ''MasterCreatinineClearanceThreshold'',
		CASE WHEN drcmMaster.DR2_CRCLU IS NULL THEN NULL WHEN drcmMaster.DR2_CRCLU = ''01'' THEN N''ML/MIN'' WHEN drcmMaster.DR2_CRCLU = ''02'' THEN N''ML/MIN/1.73M²'' ELSE NULL END as ''MasterCreatinineClearanceThresholdUnits'',
		''Pediatric'' as ''ModuleSource'',
		pediatric.PDM_MNAGE as ''ModuleMinAgeInDays'',
		pediatric.PDM_MXAGE as ''ModuleMaxAgeInDays'',
		pediatric.PDM_MND as ''ModuleLowDose'',
		ldUnits.PDM_UNDESC as ''ModuleLowDoseUnits'',
		pediatric.PDM_MXD as ''ModuleHighDose'',
		hdUnits.PDM_UNDESC as ''ModuleHighDoseUnits'',
		pediatric.PDM_MNU as ''ModuleLowDoseForm'',
		ldfUnits.PDM_UNDESC as ''ModuleLowDoseFormUnits'',
		pediatric.PDM_MXU as ''ModuleHighDoseForm'',
		hdfUnits.PDM_UNDESC as ''ModuleHighDoseFormUnits'',
		pediatric.PDM_NTED as ''ModuleNTEDailyDoseStrength'',
		nteStrengthUnits.PDM_UNDESC as ''ModuleNTEDailyDoseStrengthUnits'',
		pediatric.PDM_NTEU as ''ModuleNTEDailyDoseForm'',
		nteFormUnits.PDM_UNDESC as ''ModuleNTEDailyDoseFormUnits'',
		ingStrength.HIC_SEQN as ''HIC_SEQN'',
		ingStrength.STRENGTH as ''IngredientStrength'',
		ingStrengthUom.UOM_ABBR as ''IngredientStrengthUOMAbbr'',
		ingStrengthUom.UOM_DESC as ''IngredientStrengthUOMDesc'',
		ingStrength.VOLUME as ''IngredientVolume'',
		ingVolumeUom.UOM_ABBR as ''IngredientVolumeUOMAbbr'',
		ingVolumeUom.UOM_DESC as ''IngredientVolumeUOMDesc''
	FROM NDD_RPDMMA1_PEDI_MSTR pediatric
	LEFT JOIN NDD_RPDMUND0_PEDI_DOSE_UNIT_DESC ldUnits ON ldUnits.PDM_UNIT = pediatric.PDM_MNDU
	LEFT JOIN NDD_RPDMUND0_PEDI_DOSE_UNIT_DESC hdUnits ON hdUnits.PDM_UNIT = pediatric.PDM_MXDU
	LEFT JOIN NDD_RPDMUND0_PEDI_DOSE_UNIT_DESC ldfUnits ON ldfUnits.PDM_UNIT = pediatric.PDM_MNUF
	LEFT JOIN NDD_RPDMUND0_PEDI_DOSE_UNIT_DESC hdfUnits ON hdfUnits.PDM_UNIT = pediatric.PDM_MXUF
	LEFT JOIN NDD_RPDMUND0_PEDI_DOSE_UNIT_DESC nteStrengthUnits ON nteStrengthUnits.PDM_UNIT = pediatric.PDM_NTEDU
	LEFT JOIN NDD_RPDMUND0_PEDI_DOSE_UNIT_DESC nteFormUnits ON nteFormUnits.PDM_UNIT = pediatric.PDM_NTEUF
	OUTER APPLY (
		SELECT *
		FROM NDD_RDRCNMA2_MSTR drcm
		WHERE drcm.IsDelete = 0
			AND drcm.GCN_SEQNO = pediatric.GCN_SEQNO
			AND (
				(
					pediatric.PDM_MNAGE = 0 AND drcm.DR2_LOAGED = 0
					OR pediatric.PDM_MNAGE >= drcm.DR2_LOAGED AND (pediatric.PDM_MNAGE <= drcm.DR2_HIAGED OR ISNULL(drcm.DR2_HIAGED, 0) = 0)
				)
				OR	(
					pediatric.PDM_MXAGE = 0 AND drcm.DR2_HIAGED = 0
					OR pediatric.PDM_MXAGE >= drcm.DR2_LOAGED AND (pediatric.PDM_MXAGE <= drcm.DR2_HIAGED OR ISNULL(drcm.DR2_HIAGED, 0) = 0)
				)
			)
	) drcmMaster
	LEFT OUTER JOIN NDD_RGCNSTR0_INGREDIENT_STRENGTH ingStrength ON ingStrength.GCN_SEQNO = drcmMaster.GCN_SEQNO
	LEFT OUTER JOIN NDD_RSTRUOM0_STRENGTH_UOM ingStrengthUom on ingStrengthUom.UOM_ID = ingStrength.STRENGTH_UOM_ID
	LEFT OUTER JOIN NDD_RSTRUOM0_STRENGTH_UOM ingVolumeUom on ingVolumeUom.UOM_ID = ingStrength.VOLUME_UOM_ID
    LEFT OUTER JOIN NDD_RPEIRM0_RT_MSTR rt ON rt.DR2_RT = drcmMaster.DR2_RT
	LEFT OUTER JOIN NDD_RDRCUND0_UNITS_DESC lowDoseUnits ON lowDoseUnits.DR2_UNITS = drcmMaster.DR2_LODOSU
	LEFT OUTER JOIN NDD_RDRCUND0_UNITS_DESC highDoseUnits ON highDoseUnits.DR2_UNITS = drcmMaster.DR2_HIDOSU
	LEFT OUTER JOIN NDD_RDRCUND0_UNITS_DESC maximumDailyDoseUnits ON maximumDailyDoseUnits.DR2_UNITS = drcmMaster.DR2_MXDOSU
	LEFT OUTER JOIN NDD_RDRCUND0_UNITS_DESC maximumSingleDoseUnits ON maximumSingleDoseUnits.DR2_UNITS = drcmMaster.DR2_MX1DSU
	LEFT OUTER JOIN NDD_RDRCUND0_UNITS_DESC maximumLifetimeDoseUnits ON maximumLifetimeDoseUnits.DR2_UNITS = drcmMaster.DR2_MXLIFU
	LEFT OUTER JOIN NDD_RDRCUND0_UNITS_DESC maximumNteDoseUnits ON maximumNteDoseUnits.DR2_UNITS = drcmMaster.NTE_SINGLE_DOSE_UNIT_CODE
	WHERE pediatric.IsDelete = 0
		AND pediatric.GCN_SEQNO = @proposed_GCN_SEQNO

	RETURN
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_GeriatricPrecautions]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 01/16/2018
-- Description:	Returns geriatric precaution table enties for any 
--				drug with geriatric precaution. If the table is 
--				empty no precaution were found.
--
--				If the first three proposed values are 0 (zero) all
--				medications in the existing active medications table 
--				will be tested.
--
-- 01/16/2018   rewrote from 2014''s work
-- 02/22/2018   made changes to support new table names.
-- =================================================================
CREATE FUNCTION [dbo].[NDD_GeriatricPrecautions](
		@proposed_MEDID int,											-- medid of the proposed medication
		@proposed_GCN_SEQNO int,										-- gcn_seqno of the proposed medication
		@proposed_ROUTED_MED_ID int,									-- routed_med_id of the proposed medication
		@proposed_MedicationName varchar(255),							-- name of the proposed medication
		@existingActiveMedication Existing_Active_Medications readonly	-- existing list of active drugs
		)
RETURNS 
@GeriatricPrecautionResults table
(
	PK int IDENTITY NOT NULL PRIMARY KEY,
	MedicationName varchar(255) null,
	Severity_Level varchar(1) null,
	SeverityDescription varchar(512) null,
	Description varchar(255),
	Narrative varchar(512) null,
	RenalFlag varchar(1) null,
	HepaticFlag varchar(1) null,
	CardiovascularFlag varchar(1) null,
	PulmonaryFlag varchar(1) null,
	NeurologicPsychiatricFlag varchar(1) null,
	EndocrineFlag varchar(1) null,
	BEERSIndicator varchar(1) null,
	HEDISIndicator varchar(1) null,
	STOPPIndicator varchar(1) null
)

/*

GERI Severity Level Description Table (RGERISD0_GERI_SEVER_LEVEL_DESC)
GERI_SL		GERI_SL_DESC							PRM colors
1			Contraindication						Highest - #d00000 (red)
2			Management or Monitoring Precaution		Third Highest - #ffcd00 (light orange)

Specific Organ Flag Definitions
GERI_RNL	Geriatric Precaution Organ System Function - Renal					Renal Organ System
GERI_HEP	Geriatric Precaution Organ System Function - Hepatic				Hepatic Organ System
GERI_CARD	Geriatric Precaution Organ System Function - Cardiovascular			Cardiac Organ System
GERI_PULM	Geriatric Precaution Organ System Function - Pulmonary				Pulmonary Organ System
GERI_NEUR	Geriatric Precaution Organ System Function - Neurologic/Psychiatric	Neurologic/Psychiatric System
GERI_END	Geriatric Precaution Organ System Function - Endocrine				Endocrine Organ System

*/
AS
begin
	declare @DrugsToScreen table
	(
		MedicationName varchar(255) NULL,
		GCN_SEQNO int NULL,
		ROUTED_MED_ID int NULL
	)
		
	--declare @GERI_CODE int
	declare @GCN_SEQNO int
	declare @ROUTED_MED_ID int
	declare @MedicationName varchar(255)
	
	if (ISNULL(@proposed_MEDID, 0) > 0)
	begin
		insert into @DrugsToScreen (MedicationName, GCN_SEQNO)
			values (@proposed_MedicationName, dbo.NDD_FindGCNSEQNO(@proposed_MEDID))
	end
	else if (ISNULL(@proposed_GCN_SEQNO, 0) > 0)
	begin
		insert into @DrugsToScreen (MedicationName, GCN_SEQNO)
			values (@proposed_MedicationName, @proposed_GCN_SEQNO)
	end
	else if (ISNULL(@proposed_ROUTED_MED_ID, 0) > 0)
	begin
		insert into @DrugsToScreen (MedicationName, ROUTED_MED_ID)
			values (@proposed_MedicationName, @proposed_ROUTED_MED_ID)
	end
	else begin
		insert into @DrugsToScreen (MedicationName, GCN_SEQNO, ROUTED_MED_ID)
			select MedicationName,
			(CASE WHEN MEDID is not null and MEDID > 0 THEN dbo.NDD_FindGCNSEQNO(MEDID) ELSE GCN_SEQNO END) as [GCN_SEQNO],
			ROUTED_MED_ID 
			from @existingActiveMedication
	end
	
	declare out_cursor cursor for 
		select MedicationName, GCN_SEQNO, ROUTED_MED_ID 
		from @DrugsToScreen

	open out_cursor
	fetch NEXT from out_cursor into @MedicationName, @GCN_SEQNO, @ROUTED_MED_ID

	while (@@fetch_status <> -1)
	begin
		if (@@fetch_status <> -2)
		begin
			if (ISNULL(@GCN_SEQNO, 0) > 0)
			begin
				insert into @GeriatricPrecautionResults (MedicationName,
						Severity_Level, SeverityDescription, Description, Narrative, RenalFlag, HepaticFlag,
						CardiovascularFlag, PulmonaryFlag, NeurologicPsychiatricFlag, EndocrineFlag, BEERSIndicator, HEDISIndicator,
						STOPPIndicator)
					select @MedicationName,
							mstr.GERI_SL, sl.GERI_SL_DESC, mstr.GERI_DESC, mstr.GERI_NARRATIVE, mstr.GERI_RNL, mstr.GERI_HEP,
							mstr.GERI_CARD, mstr.GERI_PULM, mstr.GERI_NEUR, mstr.GERI_END, mstr.GERI_BEERS_IND, mstr.GERI_HEDIS_IND,
							mstr.GERI_STOPP_IND
							from NDD_RGERIMA1_GERI_MSTR  mstr WITH(NOLOCK)
								inner join NDD_RGERISD0_GERI_SEVER_LEVEL_DESC sl WITH(NOLOCK) on mstr.GERI_SL = sl.GERI_SL
							where mstr.IsDelete = 0 and mstr.GERI_CODE in 
								(select GERI_CODE 
									from NDD_RGERIGC0_GERI_GCNSEQNO_LINK WITH(NOLOCK)
								where IsDelete = 0 and GCN_SEQNO = @GCN_SEQNO
								)
			end
			else begin
				insert into @GeriatricPrecautionResults (MedicationName,
						Severity_Level, SeverityDescription, Description, Narrative, RenalFlag, HepaticFlag,
						CardiovascularFlag, PulmonaryFlag, NeurologicPsychiatricFlag, EndocrineFlag, BEERSIndicator, HEDISIndicator,
						STOPPIndicator)
					select @MedicationName,
							mstr.GERI_SL, sl.GERI_SL_DESC, mstr.GERI_DESC, mstr.GERI_NARRATIVE, mstr.GERI_RNL, mstr.GERI_HEP,
							mstr.GERI_CARD, mstr.GERI_PULM, mstr.GERI_NEUR, mstr.GERI_END, mstr.GERI_BEERS_IND, mstr.GERI_HEDIS_IND,
							mstr.GERI_STOPP_IND
							from NDD_RGERIMA1_GERI_MSTR  mstr WITH(NOLOCK)
								inner join NDD_RGERISD0_GERI_SEVER_LEVEL_DESC sl WITH(NOLOCK) on mstr.GERI_SL = sl.GERI_SL
							where mstr.IsDelete = 0 and mstr.GERI_CODE in 
								(
									select GERI_CODE 
									from NDD_RGERIRM0_ROUTED_MED_LINK WITH(NOLOCK) 
									where IsDelete = 0 and ROUTED_MED_ID = @ROUTED_MED_ID
								)
			end
		end -- of if (@@fetch_status <> -2) 
		
		fetch NEXT from out_cursor into @MedicationName, @GCN_SEQNO, @ROUTED_MED_ID
	end	-- of while outside

	close out_cursor
	deallocate out_cursor
	
	RETURN
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_LactationPrecautions]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 01/16/2018
-- Description:	Returns lactation precaution table enties for any 
--				drug with lactation precaution. If the table is 
--				empty no precaution were found.
--
--				If the first three proposed values are 0 (zero) all
--				medications in the existing active medications table 
--				will be tested.
-- 
-- 01/16/2018   rewrote from 2014''s work
-- 02/22/2018   made changes to support new table names.
-- =================================================================
CREATE FUNCTION [dbo].[NDD_LactationPrecautions](
		@proposed_MEDID int,											-- medid of the proposed medication
		@proposed_GCN_SEQNO int,										-- gcn_seqno of the proposed medication
		@proposed_ROUTED_MED_ID int,									-- routed_med_id of the proposed medication
		@proposed_MedicationName varchar(255),							-- name of the proposed medication
		@existingActiveMedication Existing_Active_Medications readonly	-- existing list of active drugs
		)
RETURNS 
@LactationPrecautionResults table
(
	PK int IDENTITY NOT NULL PRIMARY KEY,
	MedicationName varchar(255) null,
	Severity_Level varchar(1) null,
	SeverityLevelDescription varchar(255) null,
	SeverityDescription varchar(MAX) null,
	Description varchar(255),
	EffectsOnInfant varchar(MAX) null,
	ExcretionPotential varchar(MAX) null,
	Narrative varchar(MAX) null
)
AS
begin
/*
Severity								PRM colors
1			Absolute contraindication   Highest - #d00000 (red)
2			Precaution exists           Second Highest - #e2ae4a (dark orange)
3			No known risk               Fourth Highest/Lowest - #d9e986 (light green)
*/
	declare @DrugsToScreen table
	(
		MedicationName varchar(255) NULL,
		GCN_SEQNO int NULL,
		ROUTED_MED_ID int NULL,
		tested bit,
		[order] int
	)
	declare @tempRLACTMA0_LACT_MSTR table
	(
		[LACT_CODE] [numeric](6, 0) NOT NULL,
		[LACT_DESC] [varchar](40) NULL,
		[LACT_SL] [varchar](1) NULL,
		[LACT_EXCRT] [varchar](1) NULL,
		[LACT_LCTN] [varchar](1) NULL,
		[LACT_PRCTN] [varchar](77) NULL
	)
	
	declare @GCN_SEQNO int
	declare @ROUTED_MED_ID int
	declare @MedicationName varchar(255)
	declare @tmpStr varchar(MAX)
	declare @SeverityLevelDescription varchar(255)
	declare @SeverityDescription varchar(MAX)
	declare @EffectsOnInfant varchar(MAX)
	declare @ExcretionPotential varchar(MAX)
	declare @LACT_CODE int
	declare @LACT_SL varchar(1)
	declare @LACT_LCTN int
	declare @LACT_EXCRT int
	declare @i int
	
	
	if (ISNULL(@proposed_MEDID, 0) > 0)
	begin
		insert into @DrugsToScreen (MedicationName, GCN_SEQNO)
			values (@proposed_MedicationName, dbo.NDD_FindGCNSEQNO(@proposed_MEDID))
	end
	else if (ISNULL(@proposed_GCN_SEQNO, 0) > 0)
	begin
		insert into @DrugsToScreen (MedicationName, GCN_SEQNO)
			values (@proposed_MedicationName, @proposed_GCN_SEQNO)
	end
	else if (ISNULL(@proposed_ROUTED_MED_ID, 0) > 0)
	begin
		insert into @DrugsToScreen (MedicationName, ROUTED_MED_ID)
			values (@proposed_MedicationName, @proposed_ROUTED_MED_ID)
	end
	else begin
		insert into @DrugsToScreen (MedicationName, GCN_SEQNO, ROUTED_MED_ID)
			select MedicationName,
			(CASE WHEN MEDID is not null and MEDID > 0 THEN dbo.NDD_FindGCNSEQNO(MEDID) ELSE GCN_SEQNO END) as [GCN_SEQNO],
			ROUTED_MED_ID 
			from @existingActiveMedication
	end
	
	declare out_cursor cursor for 
		select MedicationName, GCN_SEQNO, ROUTED_MED_ID 
		from @DrugsToScreen

	open out_cursor
	fetch NEXT from out_cursor into @MedicationName, @GCN_SEQNO, @ROUTED_MED_ID

	while (@@fetch_status <> -1)
	begin
		if (@@fetch_status <> -2)
		begin
			-- remove all rows in temp table
			delete @tempRLACTMA0_LACT_MSTR

			if (ISNULL(@GCN_SEQNO, 0) > 0)
			begin
				insert into @tempRLACTMA0_LACT_MSTR (LACT_CODE, LACT_DESC, LACT_SL, LACT_EXCRT, LACT_LCTN, LACT_PRCTN)
				select LACT_CODE, LACT_DESC, LACT_SL, LACT_EXCRT, LACT_LCTN, LACT_PRCTN 
				from NDD_RLACTMA0_LACT_MSTR WITH(NOLOCK) 
				where IsDelete = 0 and LACT_CODE in
				(
					select LACT_CODE 
					from NDD_RLACTGC0_LACT_GCNSEQNO_LINK WITH(NOLOCK) 
					where IsDelete = 0 and GCN_SEQNO = @GCN_SEQNO
				)
			end
			else begin
				insert into @tempRLACTMA0_LACT_MSTR (LACT_CODE, LACT_DESC, LACT_SL, LACT_EXCRT, LACT_LCTN, LACT_PRCTN)
				select LACT_CODE, LACT_DESC, LACT_SL, LACT_EXCRT, LACT_LCTN, LACT_PRCTN 
				from NDD_RLACTMA0_LACT_MSTR WITH(NOLOCK)
				where IsDelete = 0 and LACT_CODE in
				(
					select LACT_CODE 
					from NDD_RLACTRM0_ROUTED_MED_LINK WITH(NOLOCK) 
					where IsDelete = 0 and ROUTED_MED_ID = @ROUTED_MED_ID
				)
			end
	
			declare in_cursor cursor for 
				select LACT_CODE, LACT_SL, LACT_EXCRT, LACT_LCTN  
				from  @tempRLACTMA0_LACT_MSTR

			open in_cursor
			fetch NEXT from in_cursor into @LACT_CODE, @LACT_SL, @LACT_EXCRT, @LACT_LCTN

			while (@@fetch_status <> -1)
			begin
				if (@@fetch_status <> -2)
				begin
					set @SeverityLevelDescription = null
					set @SeverityDescription = null
					set @EffectsOnInfant = null
					set @ExcretionPotential = null

					if (ISNULL(@LACT_SL, '''') <> '''')
					begin
						-- get severity description
						set @SeverityLevelDescription = ''''
						set @SeverityDescription = ''''
									
						declare sl_cursor cursor for 
							select LACT_SL_DESC from NDD_RLACTSD0_SEVER_LEVEL_DESC WITH(NOLOCK)
							where IsDelete = 0 and LACT_SL = @LACT_SL
							order by LACT_SLSN

						open sl_cursor
						fetch NEXT from sl_cursor into @tmpStr

						while (@@fetch_status <> -1)
						begin
							if (@@fetch_status <> -2)
							begin
								set @SeverityDescription = @SeverityDescription + '' '' + @tmpStr
							end
							fetch NEXT from sl_cursor into @tmpStr
						end -- of inside while
						
						close sl_cursor
						deallocate sl_cursor
					
						if (@LACT_SL = ''1'')
						begin
							set @SeverityLevelDescription = ''Absolute contraindication''
						end
						else if (@LACT_SL = ''2'')
						begin
							set @SeverityLevelDescription = ''Precaution exists''
						end
						else if (@LACT_SL = ''3'')
						begin
							set @SeverityLevelDescription = ''No known risk''
						end
					
						set @SeverityDescription = LTRIM(RTRIM(REPLACE(@SeverityDescription, @SeverityLevelDescription, '''')))
					
						if (@LACT_SL = ''3'')
						begin
							set @SeverityLevelDescription = ''No known risk''
						end
					
						set @i = CHARINDEX(''.'', @SeverityDescription, 1)
						set @SeverityDescription = LTRIM(RTRIM(SUBSTRING(@SeverityDescription, @i + 1, LEN(@SeverityDescription))))
								+ '' '' + LTRIM(RTRIM(SUBSTRING(@SeverityDescription, 1, @i)))
					end -- of if (@LACT_SL > 0)
				
					if (@LACT_LCTN > 0)
					begin
						-- get effects on infant
						set @EffectsOnInfant = ''''
									
						declare ef_cursor cursor for 
							select LACT_LCTN_DESC from NDD_RLACTID0_EFFECTS_INFANTS_DESC WITH(NOLOCK)
							where IsDelete = 0 and LACT_LCTN = @LACT_LCTN 
							order by LACT_LCTNSN

						open ef_cursor
						fetch NEXT from ef_cursor into @tmpStr

						while (@@fetch_status <> -1)
						begin
							if (@@fetch_status <> -2)
							begin
								set @EffectsOnInfant = @EffectsOnInfant + '' '' + @tmpStr
							end
							fetch NEXT from ef_cursor into @tmpStr
						end -- of inside while
							
						close ef_cursor
						deallocate ef_cursor
					end -- of if (@LACT_LCTN > 0)
				
					if (@LACT_EXCRT > 0)
					begin
						-- get effects on infant
						set @ExcretionPotential = ''''
									
						declare ex_cursor cursor for 
							select LACT_EXCRT_DESC from NDD_RLACTED0_EXCRT_POTENTIAL_DESC WITH(NOLOCK)
							where IsDelete = 0 and LACT_EXCRT = @LACT_EXCRT 
							order by LACT_EXCRTSN

						open ex_cursor
						fetch NEXT from ex_cursor into @tmpStr

						while (@@fetch_status <> -1)
						begin
							if (@@fetch_status <> -2)
							begin
								set @ExcretionPotential = @ExcretionPotential + '' '' + @tmpStr
							end
							fetch NEXT from ex_cursor into @tmpStr
						end -- of inside while
							
						close ex_cursor
						deallocate ex_cursor
					end -- of if (@LACT_EXCRT > 0)
					
					insert into @LactationPrecautionResults(MedicationName, Severity_Level, 
									SeverityLevelDescription, SeverityDescription, Description, 
									EffectsOnInfant, ExcretionPotential, Narrative)
						select @MedicationName, LACT_SL,
								@SeverityLevelDescription, @SeverityDescription, LACT_DESC, 
								LTRIM(RTRIM(@EffectsOnInfant)), LTRIM(RTRIM(@ExcretionPotential)), LACT_PRCTN 
							from NDD_RLACTMA0_LACT_MSTR WITH(NOLOCK) where IsDelete = 0 and LACT_CODE = @LACT_CODE
				end -- of if (@@fetch_status <> -2)
			
				fetch NEXT from in_cursor into @LACT_CODE, @LACT_SL, @LACT_EXCRT, @LACT_LCTN
			end -- of while inside

			close in_cursor
			deallocate in_cursor
		end -- of if (@@fetch_status <> -2) 
		
		fetch NEXT from out_cursor into @MedicationName, @GCN_SEQNO, @ROUTED_MED_ID
	end	-- of while outside

	close out_cursor
	deallocate out_cursor
	
	RETURN
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_PatientEducationMonograph]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 01/25/2018
-- Description:	Returns patient education monograph text 
--
-- 01/16/2018   rewrote from 2014''s work
-- 02/22/2018   made changes to support new table names.
-- =================================================================
CREATE FUNCTION [dbo].[NDD_PatientEducationMonograph](
		@MEDID int,
		@GCN_SEQNO int,
		@returnStyle int = 1 -- text style: 1 = plain text, 2 = html, 3 = html body only 
		)
RETURNS varchar(MAX)
AS
begin
	
	declare @PEMONO int
	declare @PEMTXTEI varchar(10)
	declare @PEMTXTE varchar(255)
	declare @buildStr varchar(MAX)
	declare @replacementText varchar(255)
	declare @blankLine bit
	declare @charPos int
	
	if (ISNULL(@MEDID, 0) > 0)
	begin
		select @PEMONO = t2.PEMONO 
		from NDD_RMIID1_MED t1 WITH(NOLOCK)
			inner join NDD_RPEMOGC0_MONO_GCNSEQNO_LINK t2 WITH(NOLOCK) on t1.GCN_SEQNO = t2.GCN_SEQNO
		where t1.IsDelete = 0
			and t2.IsDelete = 0
			and t1.MEDID = @MEDID
	end
	else begin
		select @PEMONO = PEMONO 
		from NDD_RPEMOGC0_MONO_GCNSEQNO_LINK WITH(NOLOCK)
		where IsDelete = 0
			and GCN_SEQNO = @GCN_SEQNO
	end

	if ((ISNULL(@returnStyle, 0) < 1) or (ISNULL(@returnStyle, 0) > 3))
	begin
		set @returnStyle = 1
	end

	if (@returnStyle = 1)-- plain text
	begin
		set @buildStr = ''''
	end
	else if ((@returnStyle = 2) or -- html
			(@returnStyle = 3)) -- html body only
	begin
		set @buildStr = ''<p>''
		set @blankLine = 1
	end

	declare out_cursor cursor for 
		select PEMTXTEI, PEMTXTE 
		from NDD_RPEMMOE2_MONO WITH(NOLOCK) 
		where IsDelete = 0 and PEMONO = @PEMONO
		order by PEMONOE_SN
	
	open out_cursor
	fetch NEXT from out_cursor into @PEMTXTEI, @PEMTXTE

	while (@@fetch_status <> -1)
	begin
		if (@@fetch_status <> -2)
		begin
			if (@returnStyle = 1) -- plain text
			begin
				if (@PEMTXTEI = ''B'')
				begin
					set @buildStr = @buildStr + CHAR(10) + CHAR(13)
				end
				else begin
					if (SUBSTRING(@PEMTXTE, 1, 2) = ''  '')
					begin
						set @buildStr = @buildStr + CHAR(10) + CHAR(13)
					end
					set @buildStr = @buildStr + @PEMTXTE + '' ''
				end
			end -- plain text
			
			if ((@returnStyle = 2) or -- html
				(@returnStyle = 3)) -- html body only
			begin
				if (@PEMTXTEI = ''B'')
				begin
					set @buildStr = @buildStr + ''</p><p>''
					set @blankLine = 1
				end
				else begin
					if (SUBSTRING(@PEMTXTE, 1, 2) = ''  '')
					begin
						set @buildStr = @buildStr + ''<br></br>''
					end
					if (@blankLine = 1)
					begin
					
						-- boldface some selected text
						set @replacementText = ''''
						set @charPos = CHARINDEX('':'', @PEMTXTE, 1)

						if (@charPos > 0)
						begin
							set @replacementText = SUBSTRING(@PEMTXTE, 1, @charPos)
							if (LEN(@replacementText) > 0)
							begin
								set @PEMTXTE = REPLACE(@PEMTXTE, @replacementText, ''<b>'' + @replacementText + ''</b>'')
							end
						end
					end
					set @buildStr = @buildStr + @PEMTXTE + '' ''
					set @blankLine = 0
				end
			end -- html		
		end --if (@@fetch_status <> -2)
					
		fetch NEXT from out_cursor into @PEMTXTEI, @PEMTXTE
	end -- of while
	
	close out_cursor
	deallocate out_cursor
	
	if (@returnStyle = 2) -- html
	begin
		set @buildStr = ''<html> <body> '' + @buildStr + ''</p> </body> </html>''
	end
	else if (@returnStyle = 3) -- html body only
	begin
		set @buildStr = ''<body> '' + @buildStr + ''</p> </body>''
	end

	return @buildStr		
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_PediatricPrecautions]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 01/17/2018
-- Description:	Returns pediatric precaution table enties for any 
--				drug with pediatric precaution. If the table is 
--				empty no precaution were found.
--
--				If the first three proposed values are 0 (zero) all
--				medications in the existing active medications table 
--				will be tested.
--
-- 01/16/2018   rewrote from 2014''s work
-- 02/22/2018   made changes to support new table names.
-- =================================================================
CREATE FUNCTION [dbo].[NDD_PediatricPrecautions](
		@proposed_MEDID int,											-- medid of the proposed medication
		@proposed_GCN_SEQNO int,										-- gcn_seqno of the proposed medication
		@proposed_ROUTED_MED_ID int,									-- routed_med_id of the proposed medication
		@proposed_MedicationName varchar(255),							-- name of the proposed medication
		@existingActiveMedication Existing_Active_Medications readonly	-- existing list of active drugs
		)
RETURNS 
@PediatricPrecautionResults table
(
	PK int IDENTITY NOT NULL PRIMARY KEY,
	MedicationName varchar(255) null,
	Severity_Level varchar(1) null,
	SeverityDescription varchar(MAX) null,
	Description varchar(255),
	MinimumPrecautionAgeDays int null,
	MaximumPrecautionAgeDays int null,
	Narrative varchar(MAX) null
)
AS
begin
/*
the below comes from table NDD_RPEDISD0_PEDI_SEVER_LEVEL_DESC

PEDI_SL PEDI_SL_DESC							PRM colors
------- ------------------------------------	-------------------------------
1       Contraindication						Highest - #d00000 (red)
2       Severe Precaution						Second Highest - #e2ae4a (dark orange)
3       Management or Monitoring Precaution		Third Highest - #ffcd00 (light orange)

*/

	declare @tempRPEDIMA1_PEDI_MSTR table
	(
		[PEDI_CODE] [numeric](6, 0) NOT NULL,
		[PEDI_DESC] [varchar](34) NOT NULL,
		[PEDI_SL] [varchar](1) NOT NULL,
		[PEDI_MINAG] [numeric](4, 0) NOT NULL,
		[PEDI_MAXAG] [numeric](4, 0) NOT NULL,
		[PEDI_NARRATIVE] [varchar](500) NOT NULL
	)

	declare @DrugsToScreen table
	(
		MedicationName varchar(255) NULL,
		GCN_SEQNO int NULL,
		ROUTED_MED_ID int NULL
	)

	declare @GCN_SEQNO int
	declare @ROUTED_MED_ID int
	declare @MedicationName varchar(255)
	declare @tmpStr varchar(MAX)
	declare @PEDI_CODE int
	
	
	if (ISNULL(@proposed_MEDID, 0) > 0)
	begin
		insert into @DrugsToScreen (MedicationName, GCN_SEQNO)
			values (@proposed_MedicationName, dbo.NDD_FindGCNSEQNO(@proposed_MEDID))
	end
	else if (ISNULL(@proposed_GCN_SEQNO, 0) > 0)
	begin
		insert into @DrugsToScreen (MedicationName, GCN_SEQNO)
			values (@proposed_MedicationName, @proposed_GCN_SEQNO)
	end
	else if (ISNULL(@proposed_ROUTED_MED_ID, 0) > 0)
	begin
		insert into @DrugsToScreen (MedicationName, ROUTED_MED_ID)
			values (@proposed_MedicationName, @proposed_ROUTED_MED_ID)
	end
	else begin
		insert into @DrugsToScreen (MedicationName, GCN_SEQNO, ROUTED_MED_ID)
			select MedicationName,
			(CASE WHEN MEDID is not null and MEDID > 0 THEN dbo.NDD_FindGCNSEQNO(MEDID) ELSE GCN_SEQNO END) as [GCN_SEQNO],
			ROUTED_MED_ID 
			from @existingActiveMedication
	end
	
	declare out_cursor cursor for 
		select MedicationName,  GCN_SEQNO, ROUTED_MED_ID 
		from @DrugsToScreen

	open out_cursor
	fetch NEXT from out_cursor into @MedicationName, @GCN_SEQNO, @ROUTED_MED_ID

	while (@@fetch_status <> -1)
	begin
		if (@@fetch_status <> -2)
		begin
			-- remove rows from temp table
			delete @tempRPEDIMA1_PEDI_MSTR

			if (ISNULL(@GCN_SEQNO, 0) > 0)
			begin
				insert into @tempRPEDIMA1_PEDI_MSTR (PEDI_CODE, PEDI_DESC, PEDI_SL, PEDI_MINAG, PEDI_MAXAG, PEDI_NARRATIVE)
				select PEDI_CODE, PEDI_DESC, PEDI_SL, PEDI_MINAG, PEDI_MAXAG, PEDI_NARRATIVE
				from NDD_RPEDIMA1_PEDI_MSTR WITH(NOLOCK)
				where IsDelete = 0 and PEDI_CODE in
				(
					select PEDI_CODE
					from NDD_RPEDIGC0_PEDI_GCNSEQNO_LINK WITH(NOLOCK)
					where IsDelete = 0 and GCN_SEQNO = @GCN_SEQNO
				)
			end
			else begin
				insert into @tempRPEDIMA1_PEDI_MSTR (PEDI_CODE, PEDI_DESC, PEDI_SL, PEDI_MINAG, PEDI_MAXAG, PEDI_NARRATIVE)
				select PEDI_CODE, PEDI_DESC, PEDI_SL, PEDI_MINAG, PEDI_MAXAG, PEDI_NARRATIVE
				from NDD_RPEDIMA1_PEDI_MSTR WITH(NOLOCK)
				where IsDelete = 0 and PEDI_CODE in
				(
					select PEDI_CODE
					from NDD_RPEDIRM0_ROUTED_MED_LINK WITH(NOLOCK)
					where IsDelete = 0 and ROUTED_MED_ID = @ROUTED_MED_ID
				)
			end

			insert into @PediatricPrecautionResults(MedicationName, Severity_Level, 
							SeverityDescription, Description, MinimumPrecautionAgeDays, MaximumPrecautionAgeDays, Narrative)
			select @MedicationName, mstr.PEDI_SL, sl.PEDI_SL_DESC, mstr.PEDI_DESC, mstr.PEDI_MINAG, mstr.PEDI_MAXAG, mstr.PEDI_NARRATIVE 
			from @tempRPEDIMA1_PEDI_MSTR mstr
				inner join NDD_RPEDISD0_PEDI_SEVER_LEVEL_DESC sl WITH(NOLOCK) on sl.PEDI_SL = mstr.PEDI_SL
			
		end -- of if (@@fetch_status <> -2) 
		
		fetch NEXT from out_cursor into @MedicationName, @GCN_SEQNO, @ROUTED_MED_ID
	end	-- of while outside

	close out_cursor
	deallocate out_cursor

	RETURN
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NDD_PregnancyPrecautions]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 01/16/2018
-- Description:	Returns pregnancy precaution table enties for any 
--				drug with pregnancy precaution. If the table is 
--				empty no precaution were found.
--
--				If the first three proposed values are 0 (zero) all
--				medications in the existing active medications table 
--				will be tested.
--
-- 01/16/2018   rewrote from 2014''s work
-- 02/22/2018   made changes to support new table names.
-- =================================================================
CREATE FUNCTION [dbo].[NDD_PregnancyPrecautions](
		@proposed_MEDID int,											-- medid of the proposed medication
		@proposed_GCN_SEQNO int,										-- gcn_seqno of the proposed medication
		@proposed_ROUTED_MED_ID int,									-- routed_med_id of the proposed medication
		@proposed_MedicationName varchar(255),							-- name of the proposed medication
		@existingActiveMedication Existing_Active_Medications readonly	-- existing list of active drugs
		)
RETURNS 
@PregnancyPrecautionResults table
(	
	PK int IDENTITY NOT NULL PRIMARY KEY,
	MedicationName varchar(255) null,
	Severity_Level varchar(1) null,
	SeverityDescription varchar(MAX) null,
	Description varchar(255),
	Narrative varchar(MAX) null
)
AS
begin
/*
Severity	PRM colors
1           Highest - #d00000 (red)
2           Second Highest - #e2ae4a (dark orange)
X           Highest - #d00000 (red)
D           Second Highest - #e2ae4a (dark orange)
C           Third Highest - #ffcd00 (light orange)
B           Third Highest - #ffcd00 (light orange)
A           Fourth Highest/Lowest - #d9e986 (light green)


Severity_Level

1   CONTRAINDICATED OR NOT RECOMMENDED. EXISTING FDA TERATOGENICITY CATEGORY (IF AVAILABLE) IS AUGMENTED 
	BY INFORMATION SUPPORTING A MORE SEVERE WARNING.


2	NO FDA RATING BUT MAY HAVE PRECAUTIONS OR WARNINGS; MAY HAVE ANIMAL AND/OR HUMAN STUDIES OR PRE OR POST MARKETING INFORMATION.

A	ADEQUATE & WELL-CONTROLLED STUDIES IN PREGNANT WOMEN HAVE FAILED TO DEMONSTRATE A RISK TO THE FETUS IN 1ST TRIMESTER
	OF PREGNANCY (AND NO EVIDENCE OF RISK IN LATER TRIMESTERS).

B	ANIMAL STUDIES HAVE FAILED TO DEMONSTRATE A RISK TO THE FETUS BUT THERE ARE NO WELL-CONTROLLED STUDIES IN PREGNANT 
	WOMEN; OR ANIMAL REPRODUCTION STUDIES HAVE SHOWN AN ADVERSE EFFECT (OTHER THAN DECREASE IN FERTILITY), BUT ADEQUATE AND
	WELL-CONTROLLED STUDIES IN PREGNANT WOMEN HAVE FAILED TO DEMONSTRATE A RISK TO THE FETUS DURING THE FIRST TRIMESTER
	OF PREGNANCY (AND THERE IS NO EVIDENCE OF A RISK IN LATER TRIMESTERS).

C	ANIMAL STUDIES HAVE SHOWN ADVERSE EFFECT ON FETUS BUT NO WELL-CONTROLLED STUDIES IN HUMANS: POTENTIAL BENEFITS MAY
	WARRANT USE IN PREGNANT WOMEN DESPITE POTENTIAL RISKS; OR NO ANIMAL REPRODUCTION STUDIES AND NO ADEQUATE AND
	WELL-CONTROLLED STUDIES IN HUMANS.

D	POSITIVE EVIDENCE OF HUMAN FETAL RISK BASED ON INVESTIGATION OR MARKETING INFORMATION BUT POTENTIAL BENEFITS MAY WARRANT
	USE OF DRUG IN PREGNANT WOMEN DESPITE POTENTIAL RISKS.

X	STUDIES IN ANIMALS OR HUMANS HAVE SHOWN FETAL ABNORMALITIES AND/OR THERE IS POSITIVE EVIDENCE OF FETAL RISK BASED ON
	INVESTIGATIONAL OR MARKETING INFORMATION AND RISKS INVOLVED IN USE OF DRUG IN PREGNANT WOMEN CLEARLY OUTWEIGH POTENTIAL
	BENEFITS.

*/

	declare @tempRPREGMA0_PREG_MSTR table
	(
		[PREG_CODE] [numeric](6, 0) NOT NULL,
		[PREG_DESC] [varchar](41) NULL,
		[PREG_SL] [varchar](1) NULL,
		[PREG_PRCTN] [varchar](80) NULL
	)
	declare @DrugsToScreen table
	(
		MedicationName varchar(255) NULL,
		GCN_SEQNO int NULL,
		ROUTED_MED_ID int NULL
	)

	declare @GCN_SEQNO int
	declare @ROUTED_MED_ID int
	declare @MedicationName varchar(255)
	declare @tmpStr varchar(MAX)
	declare @SeverityDescription varchar(MAX)
	declare @PREG_CODE int
	declare @PREG_DESC varchar(41)
	declare @PREG_SL varchar(1)
	declare @PREG_PRCTN varchar(80)
	
	if (ISNULL(@proposed_MEDID, 0) > 0)
	begin
		insert into @DrugsToScreen (MedicationName, GCN_SEQNO)
			values (@proposed_MedicationName, dbo.NDD_FindGCNSEQNO(@proposed_MEDID))
	end
	else if (ISNULL(@proposed_GCN_SEQNO, 0) > 0)
	begin
		insert into @DrugsToScreen (MedicationName, GCN_SEQNO)
			values (@proposed_MedicationName, @proposed_GCN_SEQNO)
	end
	else if (ISNULL(@proposed_ROUTED_MED_ID, 0) > 0)
	begin
		insert into @DrugsToScreen (MedicationName, ROUTED_MED_ID)
			values (@proposed_MedicationName, @proposed_ROUTED_MED_ID)
	end
	else begin
		insert into @DrugsToScreen (MedicationName, GCN_SEQNO, ROUTED_MED_ID)
			select MedicationName,
			(CASE WHEN MEDID is not null and MEDID > 0 THEN dbo.NDD_FindGCNSEQNO(MEDID) ELSE GCN_SEQNO END) as [GCN_SEQNO],
			ROUTED_MED_ID 
			from @existingActiveMedication
	end
	
	declare out_cursor cursor for 
		select MedicationName, GCN_SEQNO, ROUTED_MED_ID 
		from @DrugsToScreen

	open out_cursor
	fetch NEXT from out_cursor into @MedicationName, @GCN_SEQNO, @ROUTED_MED_ID

	while (@@fetch_status <> -1)
	begin
		if (@@fetch_status <> -2)
		begin
			-- remove all rows in temp table
			delete @tempRPREGMA0_PREG_MSTR

			if (ISNULL(@GCN_SEQNO, 0) > 0)
			begin
				insert into @tempRPREGMA0_PREG_MSTR (PREG_CODE, PREG_DESC, PREG_PRCTN, PREG_SL)
				select PREG_CODE, PREG_DESC, PREG_PRCTN, PREG_SL 
				from NDD_RPREGMA0_PREG_MSTR WITH(NOLOCK) 
				where IsDelete = 0 and PREG_CODE in  
					(
						select preg_code 
						from NDD_RPREGGC0_PREG_GCNSEQNO_LINK WITH(NOLOCK)
						where IsDelete = 0 and GCN_SEQNO = @GCN_SEQNO
					)
			end
			else begin
				insert into @tempRPREGMA0_PREG_MSTR (PREG_CODE, PREG_DESC, PREG_PRCTN, PREG_SL)
				select PREG_CODE, PREG_DESC, PREG_PRCTN, PREG_SL 
				from NDD_RPREGMA0_PREG_MSTR WITH(NOLOCK)
				where IsDelete = 0 and PREG_CODE in  
					(
						select preg_code 
						from NDD_RPREGRM0_ROUTED_MED_LINK WITH(NOLOCK)
						where IsDelete = 0 and ROUTED_MED_ID = @ROUTED_MED_ID
					)
			end

			
			declare in_cursor cursor for 
				select PREG_CODE, PREG_DESC, PREG_PRCTN, PREG_SL  
				from  @tempRPREGMA0_PREG_MSTR

			open in_cursor
			fetch NEXT from in_cursor into @PREG_CODE, @PREG_DESC, @PREG_PRCTN, @PREG_SL

			while (@@fetch_status <> -1)
			begin
				if (@@fetch_status <> -2)
				begin
					set @SeverityDescription = null
					if (ISNULL(@PREG_SL, '''') <> '''')
					begin
						-- get severity description
						set @SeverityDescription = ''''
									
						declare sl_cursor cursor for 
							select PREG_SLD 
							from NDD_RPREGSL0_PREG_SEVER_LEVEL WITH(NOLOCK)
							where IsDelete = 0 
								and PREG_SL = @PREG_SL
							order by PREG_SLSN

						open sl_cursor
						fetch NEXT from sl_cursor into @tmpStr

						while (@@fetch_status <> -1)
						begin
							if (@@fetch_status <> -2)
							begin
								set @SeverityDescription = @SeverityDescription + '' '' + @tmpStr
							end
							fetch NEXT from sl_cursor into @tmpStr
						end -- of inside while
							
						close sl_cursor
						deallocate sl_cursor
					end -- of if (@PREG_SL > 0)

					insert into @PregnancyPrecautionResults(MedicationName, Severity_Level, 
							SeverityDescription, Description, Narrative)
					select @MedicationName, PREG_SL,
							LTRIM(RTRIM(@SeverityDescription)), PREG_DESC, PREG_PRCTN 
						from NDD_RPREGMA0_PREG_MSTR WITH(NOLOCK) 
						where IsDelete = 0
							and PREG_CODE = @PREG_CODE
				end -- of if (@@fetch_status <> -2) 
				fetch NEXT from in_cursor into @PREG_CODE, @PREG_DESC, @PREG_PRCTN, @PREG_SL
			end	-- of while inside
			
			close in_cursor
			deallocate in_cursor

		end -- of if (@@fetch_status <> -2) 

		fetch NEXT from out_cursor into @MedicationName, @GCN_SEQNO, @ROUTED_MED_ID
	end	-- of while outside

	close out_cursor
	deallocate out_cursor

	RETURN
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[OBInformation1]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[OBInformation1]
(
@moduledata VARCHAR(MAX),
@value VARCHAR(MAX)
)

RETURNS VARCHAR(100)

BEGIN
DECLARE @retVal VARCHAR(100)

DECLARE @tempTable TABLE 
(  
	[Name] VARCHAR(MAX),
	[ControlType] VARCHAR(MAX),
	[Value] VARCHAR(MAX),
	[Label] VARCHAR(MAX)  
)  

DECLARE @xml XML  
Declare @Data Varchar(Max)

--SET @xml=@ModuleData --''<CaseTypeModule Name="Estimated Delivery Date"><Control Name="prmTextGADateOfCalc" ControlType="PrmTextBox" Value="8/4/2008" Label="" /><Control Name="prmNoteEDD" ControlType="PrmNote" Value="" Label="Note" /><Control Name="prmTextBoxGAEDDDate" ControlType="PrmTextBox" Value="Undetermined" Label="GA (shows only in debug mode):" /><Control Name="findTextControlGABasis" ControlType="FindTextControl" Guid="" Value="" Tag="" ForeignKeyIndex="" /><Control Name="findTextControlInitialPE" ControlType="FindTextControl" Guid="" Value="" Tag="" ForeignKeyIndex="" /><Control Name="prmGroupBoxEDDUpdate" ControlType="PrmGroupBox" /><Control Name="prmRadioButton18TO20LMP" ControlType="PrmRadioButton" Value="false" Label="Base EDD on LMP" Display="false" /><Control Name="prmTextBoxFinalEDD" ControlType="PrmTextBox" Value="Test" Label="" /><Control Name="prmNumericUpDownUS3Days" ControlType="PrmNumericUpDown" Value="0" /><Control Name="prmNumericUpDownUS3Weeks" ControlType="PrmNumericUpDown" Value="0" /><Control Name="prmNumericUpDownUS2Days" ControlType="PrmNumericUpDown" Value="0" /><Control Name="prmNumericUpDownUS2Weeks" ControlType="PrmNumericUpDown" Value="0" /><Control Name="prmNumericUpDownUS1Days" ControlType="PrmNumericUpDown" Value="0" /><Control Name="prmNumericUpDownUS1Weeks" ControlType="PrmNumericUpDown" Value="0" /><Control Name="findTextControlFinalInitials" ControlType="FindTextControl" Guid="" Value="" Tag="" ForeignKeyIndex="" /><Control Name="findDateBoxUS3EDD" ControlType="FindDateBox" Value="" Label="" Display="false" /><Control Name="findDateBoxUS2EDD" ControlType="FindDateBox" Value="" Label="" Display="false" /><Control Name="findDateBoxUS1EDD" ControlType="FindDateBox" Value="" Label="" Display="false" /><Control Name="findDateBoxFUNDALEDD" ControlType="FindDateBox" Value="" Label="" Display="false" /><Control Name="findDateBoxQUICKEDD" ControlType="FindDateBox" Value="" Label="" Display="false" /><Control Name="prmRadioButtonUS3" ControlType="PrmRadioButton" Value="false" Label="Base EDD on Ultrasound 3" Display="false" /><Control Name="prmRadioButtonUS2" ControlType="PrmRadioButton" Value="false" Label="Base EDD on Ultrasound 2" Display="false" /><Control Name="prmRadioButtonFUNDAL" ControlType="PrmRadioButton" Value="false" Label="Base EDD on Fundal Ht" Display="false" /><Control Name="prmRadioButtonUS1" ControlType="PrmRadioButton" Value="false" Label="Base EDD on Ultrasound 1" Display="false" /><Control Name="prmRadioButtonQUICK" ControlType="PrmRadioButton" Value="true" Label="Base EDD on Quickening" Display="false" /><Control Name="findDateBoxUS3" ControlType="FindDateBox" Value="" Label="Ultrasound 3" Display="false" /><Control Name="findDateBoxUS2" ControlType="FindDateBox" Value="" Label="Ultrasound 2" Display="false" /><Control Name="findDateBoxUS1" ControlType="FindDateBox" Value="" Label="Ultrasound 1" Display="false" /><Control Name="findDateBoxFUNDAL" ControlType="FindDateBox" Value="" Label="Fundal Ht @ Umbilical" Display="false" /><Control Name="findDateBoxQUICK" ControlType="FindDateBox" Value="" Label="Quickening" Display="false" /><Control Name="prmGroupBoxInitialEDD" ControlType="PrmGroupBox" /><Control Name="findTextControlInitialEDDInitials" ControlType="FindTextControl" Guid="" Value="" Tag="" ForeignKeyIndex="" Label="Initial EDD Set By" /><Control Name="prmRadioButtonUS" ControlType="PrmRadioButton" Value="false" Label="Base EDD on Ultrasound" Display="false" /><Control Name="prmRadioButtonIE" ControlType="PrmRadioButton" Value="false" Label="Base EDD on Initial Exam" Display="false" /><Control Name="prmRadioButtonLMP" ControlType="PrmRadioButton" Value="true" Label="Base EDD on LMP" Display="false" /><Control Name="findDateBoxUSEDD" ControlType="FindDateBox" Value="" Label="" Display="false" /><Control Name="findDateBoxIEEDD" ControlType="FindDateBox" Value="" Label="" Display="false" /><Control Name="findDateBoxLMPEDD" ControlType="FindDateBox" Value="5/11/2009" Label="" Display="false" /><Control Name="prmNumericUpDownUSDays" ControlType="PrmNumericUpDown" Value="0" /><Control Name="prmNumericUpDownUSWeeks" ControlType="PrmNumericUpDown" Value="0" /><Control Name="prmNumericUpDownIEDays" ControlType="PrmNumericUpDown" Value="0" /><Control Name="prmNumericUpDownIEWeeks" ControlType="PrmNumericUpDown" Value="0" /><Control Name="findDateBoxUltraSound" ControlType="FindDateBox" Value="" Label="Initial Ultrasound" Display="false" /><Control Name="findDateBoxInitialExam" ControlType="FindDateBox" Value="" Label="Initial Exam" Display="false" /><Control Name="findDateBoxLMP" ControlType="FindDateBox" Value="8/4/2008" Label="LMP" Display="false" /><Control Name="prmTextBoxInitialEDD" ControlType="PrmTextBox" Value="5/11/2009" Label="" /></CaseTypeModule>''

select @Data= REPLACE(@ModuleData,''"<'',''"'')
select @xml= REPLACE(@Data,''>"'',''"'')

INSERT INTO @tempTable  
SELECT Tbl.Col.value(''@Name'', ''varchar(max)'') , 
       Tbl.Col.value(''@ControlType'', ''VARCHAR(max)''),  
       Tbl.Col.value(''@Value'', ''VARCHAR(max)''),
	   Tbl.Col.value(''@Label'',''Varchar(max)'')	 
FROM   @xml.nodes(''//Control'') Tbl(Col) 

SELECT @retVal = [Value] FROM @tempTable WHERE Name = @value

RETURN @retVal
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[OverrideUniqueIdentifierToLower]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[OverrideUniqueIdentifierToLower](@override VARCHAR(MAX)) RETURNS VARCHAR(MAX) AS
BEGIN
	
	DECLARE @pos INT
	SET @pos = 0
	
	SET @pos = CHARINDEX(''Uid'', @override, @pos)
	WHILE @pos > 0
	BEGIN
		SET @override = SUBSTRING(@override, 1, @pos + 4) + LOWER(SUBSTRING(@override, @pos + 5, 36)) + SUBSTRING(@override, @pos + 41, DATALENGTH(@override) - 41)
				
		SET @pos = CHARINDEX(''Uid'', @override, @pos + 45)
	END
	
	RETURN @override
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PatientIsEmVisitCount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[PatientIsEmVisitCount] (
	@PatientUid [uniqueidentifier])
RETURNS INT
AS
BEGIN
	DECLARE @count int = 0;
	SELECT @count =  count(*) from visit where IsEm=1 and PatientUid=@PatientUid;
	RETURN @count;
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PrimaryKeyColumn]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[PrimaryKeyColumn] (@tableName varchar(255)) RETURNS varchar(255) AS
	BEGIN
		DECLARE @primaryKeyColumn varchar(255)
		DECLARE @index_id int
	

		SELECT		@primaryKeyColumn = kcu.COLUMN_NAME
		FROM		INFORMATION_SCHEMA.TABLE_CONSTRAINTS tc INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE kcu ON tc.CONSTRAINT_NAME = kcu.CONSTRAINT_NAME
		WHERE		tc.CONSTRAINT_TYPE = ''Primary Key'' AND
					tc.TABLE_NAME = @tableName
		ORDER BY	kcu.ORDINAL_POSITION

		RETURN		@primaryKeyColumn
	END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[prmGetJobInfo]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =============================================
-- Author:		KC
-- Create date: 02/20/2007
-- Description:	Gets job run summary
-- =============================================
CREATE function [dbo].[prmGetJobInfo] (@pJobScheduleName varchar(50))
	returns @output TABLE (JobScheduleName varchar(100), Description VARCHAR(500),LastStart VARCHAR(500),LastStart_Result VARCHAR(500),
							LastSuccessfulEnd varchar(500), JobInfo varchar(500), JobStatusInfo varchar(500))
AS
BEGIN
	IF @pJobScheduleName IS NULL
		RETURN

	DECLARE @desc varchar(500)
	DECLARE @LastStart varchar(500)
	DECLARE @LastStartdt varchar(500)
	DECLARE @LastStart_Result varchar(500)
	DECLARE @LastSuccessfulEnd varchar(500)
	DECLARE @JobInfo varchar(500)
	DECLARE @repeattime varchar(500)
	DECLARE @JobScheduleName varchar(500)
	DECLARE @Inactive int
	SELECT @inactive = 1
	DECLARE @JobStatusInfo varchar(500)

	DECLARE @jobschid uniqueidentifier
	SELECT TOP 1 @jobschid = jobscheduleuid, @JobScheduleName = Name, @inactive = inactive
		 FROM JobSchedule WHERE name = @pJobScheduleName 
		ORDER BY Inactive ASC  -- put active jobs first

	IF @jobschid IS NULL OR @inactive = 1  -- no job found or it is inactive then use a more liberal search
		SELECT TOP 1 @jobschid = jobscheduleuid, @JobScheduleName = Name, @inactive = inactive
		 FROM JobSchedule WHERE name LIKE (''%'' + @pJobScheduleName + ''%'')
		ORDER BY Inactive ASC -- put active jobs first

	IF @jobschid IS NULL
	begin
		INSERT INTO @output (JobScheduleName, Description)
		SELECT @pJobScheduleName,''Job not found''
		RETURN
	END
	
	IF isnull(@inactive,1) = 1
	BEGIN
		INSERT INTO @output (jobschedulename, description)
		SELECT @JobScheduleName,''***Job is inactive''
		RETURN
	end

	SELECT @JobInfo = ''Repeat Interval = '' + isnull(JobRepeatInterval, ''n/a'') + '' '' + isnull(enumname, ''unknown interval'')
		FROM JobSchedule JS WITH (nolock)
		LEFT JOIN ListJobScheduleTimeBase lj WITH (nolock) ON JS.JobScheduleTimeBaseUid = lj.JobScheduleTimeBaseUid
		WHERE JS.JobScheduleUid = @jobschid

	SELECT @desc = ''job''

	DECLARE @status int
	DECLARE @finishtimeoflaststart datetime

	SELECT TOP 1 @laststartdt = datestarted, @status = Status, @finishtimeoflaststart = dateended, @JobStatusInfo=Convert(varchar(500),JobInfo)
		FROM jobhistory WITH (nolock) 
		WHERE jobscheduleuid = @jobschid
		ORDER BY datestarted desc

	IF @laststartdt IS NULL
	begin
		SELECT @LastStart = ''No last start date found'', @LastStart_Result = ''n/a''
	end
	else
	begin
		SELECT @LastStart =''Last started = '' + convert(varchar(30), @laststartdt), 
				@LastStart_Result = ''Result Status = '' + convert(varchar(20), @status) +
				''  This entry completed at '' + isnull(convert(varchar(30), @laststartdt), ''Didn''''t complete'')
	end

	SELECT TOP 1 @LastSuccessfulEnd = convert(varchar(50),dateended )
		FROM jobhistory with(nolock)
		WHERE jobscheduleuid = @jobschid
			AND status = 0
		ORDER BY dateended desc

	IF @LastSuccessfulEnd IS NULL
	begin
		SELECT @LastSuccessfulEnd = ''No DateEnded found for a successful run''
	end

	INSERT INTO @output
	SELECT @JobScheduleName, @desc, @LastStart, @LastStart_Result, @LastSuccessfulEnd, @JobInfo, @JobStatusInfo

	return
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ReduceList]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[ReduceList]
	(
		@fullList varchar(max),
		@delimiter varchar(1)
	)
RETURNS varchar(max)
AS
BEGIN

    -- Gives us a delimited list that is reduced with first,...,final where more than 3 items in list
	-- 20171121	BRoy	Created

	IF (@fullList IS NULL OR @fullList = '''' or @delimiter IS NULL OR @delimiter = '''' OR @delimiter = '' '')
		return @fullList;

	DECLARE @temp_Values TABLE -- taking definition of SPLIT function
	(
		ElementId SMALLINT,
		Element VARCHAR(1000)
	)

	INSERT INTO @temp_Values (ElementId, Element)
	SELECT * 
		FROM dbo.Split(@fullList, @delimiter)

	DECLARE @itemCount int;
	SELECT @itemCount = COUNT(*)
		FROM @temp_Values;

	IF (@itemCount <= 3)
		return @fullList;

	DECLARE @firstVal VARCHAR(MAX);
	DECLARE @finalVal VARCHAR(MAX);
	SELECT TOP 1 @firstVal = Element FROM @temp_Values ORDER BY ElementId ASC
	SELECT TOP 1 @finalVal = Element FROM @temp_Values ORDER BY ElementId DESC 

	return @firstVal + @delimiter + ''...'' + @delimiter +  @finalVal;

END

/*
	SELECT dbo.ReduceList(''Lorem,ipsum,dolor,sit,amet'', '','') -- normal
	SELECT dbo.ReduceList(''Lorem,sit'', '','') -- get list back - no work
	SELECT dbo.ReduceList(''Lorem,sit,amet'', '','') -- get list back - no work
	SELECT dbo.ReduceList(''Lorem,ipsum,dolor,sit,amet'', null) -- get list back - no work
	SELECT dbo.ReduceList(''Lorem,ipsum,dolor,sit,amet'', '' '') -- get list back - no work
	SELECT dbo.ReduceList(null, '','') -- get list back - no work
*/


' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RegexMatch]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[RegexMatch](@input [nvarchar](max), @pattern [nvarchar](max))
RETURNS [bit] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[RegexMatch]' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RegexReplace]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[RegexReplace](@input [nvarchar](max), @pattern [nvarchar](max), @replacement [nvarchar](max))
RETURNS [nvarchar](max) WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[RegexReplace]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Replication_FirstInstallDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[Replication_FirstInstallDate]
(
	@CacheMachineUid [uniqueidentifier],
	@firstInstallDate [datetime],
	@onCacheClient [bit] = 0,
	@EMRAdminTable [bit] = 0
)
RETURNS [datetime]
AS
BEGIN
	IF @onCacheClient IS NULL
		SET @onCacheClient = 0

	IF @EMRAdminTable IS NULL
		SET @EMRAdminTable = 0

	DECLARE @YearsofPastDateOfServiceInstall [int] = null,
		@DefaultInstallDate [date] = ''01/01/1980'',
		@URL [varchar](255) = null,
		@Setting [varchar](250) = ''FirstInstallDate''

	IF @onCacheClient <> 0
	BEGIN
		SET @firstInstallDate = GETUTCDATE()
	END
	ELSE
	BEGIN
		SELECT TOP 1 @DefaultInstallDate = CAST(COALESCE ([DateTimeValue], @DefaultInstallDate) AS [date])
		FROM [ReplicationSettings] with (nolock)
		WHERE [Name] = @Setting
		ORDER BY [LastModifiedDate] DESC

		IF @EMRAdminTable <> 0
			SET @firstInstallDate = NULL
		ELSE
		BEGIN
			IF @firstInstallDate IS NOT NULL
				AND @firstInstallDate <= @DefaultInstallDate
				SET @firstInstallDate = NULL
			
			IF @firstInstallDate IS NULL
			BEGIN
				SELECT @YearsofPastDateOfServiceInstall = [YearsofPastDateOfServiceInstall]
				FROM [ListCacheMachine] with(nolock)
				WHERE [CacheMachineUid] = @CacheMachineUid

				IF @YearsofPastDateOfServiceInstall IS NULL
				BEGIN
					SELECT TOP 1 @YearsofPastDateOfServiceInstall = [ReplicationYearsofPastDateOfServiceInstall]
					FROM [PracticeSettings] with(nolock)
					ORDER BY [LastModifiedDate]
				END

				IF @YearsofPastDateOfServiceInstall IS NOT NULL
					SET @firstInstallDate = CAST (DATEADD(year, -@YearsofPastDateOfServiceInstall, GETUTCDATE()) AS [date])
			END
		END

		IF @firstInstallDate IS NULL
			SET @firstInstallDate = @DefaultInstallDate
	END

	RETURN @firstInstallDate
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Replication_GetDateTimeSetting]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[Replication_GetDateTimeSetting]
(
	@cacheMachineUid [uniqueidentifier],
	@useDateOnly [bit]
)
RETURNS 
	@vCacheMachine TABLE
	(
		[CacheMachineUid] [uniqueidentifier]
		, [ApptStartDateTime] [datetime]
		, [ApptEndDateTime] [datetime]
		, [DischargeDate] [datetime]
		, [ReplicateEverything] [bit]
	)
AS
BEGIN
	DECLARE @inactive [bit] = 0
		, @replicateEverything [bit] = 0
		, @psHours [int]
		, @processDate [datetime] = GETUTCDATE()
		   
	-- Get practice setting value for appoint window
	SELECT TOP 1 @psHours = [ReplicationAppointmentHours]
	FROM [PracticeSettings] with(nolock)
	ORDER BY [LastModifiedDate]

	INSERT INTO @vCacheMachine ([CacheMachineUid], [ApptStartDateTime]
		, [ApptEndDateTime], [DischargeDate], [ReplicateEverything])
	SELECT [CacheMachineUid], 
		CASE WHEN @useDateOnly <> 0 THEN
			CAST(DATEADD(hh, -8, @processDate) AS [date])
		ELSE
			DATEADD(hh, -8, @processDate)
		END AS [ApptStartDateTime],
		CASE WHEN @useDateOnly <> 0 THEN
			CAST(DATEADD(d, 1, DATEADD(hh, COALESCE([ReplicationAppointmentHours],
				@psHours, 48),	@processDate)) AS [date])
		ELSE			
			DATEADD(hh, COALESCE([ReplicationAppointmentHours], @psHours, 48),
				@processDate)
		END AS [ApptEndDateTime],
		CASE WHEN @useDateOnly <> 0 THEN CAST(@processDate AS [date])
		ELSE @processDate
		END AS [DischargeDate],
		[ReplicateEverything]
	FROM [ViewListCacheMachine] with(nolock)
	WHERE [CacheMachineUid] = @cacheMachineUid
		AND [Inactive] = @inactive
	RETURN 
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Replication_GetPurgeObjectInterval]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[Replication_GetPurgeObjectInterval]
(
	@CacheMachineUid [uniqueidentifier]
)
RETURNS [int]
AS
BEGIN
	DECLARE @ReplicationRemovePatientHours [int]

	SELECT @ReplicationRemovePatientHours = [ReplicationRemovePatientHours]
	FROM [ViewListCacheMachine]
	WHERE [CacheMachineUid] = @CacheMachineUid

	IF @ReplicationRemovePatientHours IS NULL
	BEGIN
		SELECT TOP 1 @ReplicationRemovePatientHours = [ReplicationRemovePatientHours]
		FROM [PracticeSettings]
		WHERE [ReplicationRemovePatientHours] IS NOT NULL
		ORDER BY [LastModifiedDate] DESC
	END

	return COALESCE(@ReplicationRemovePatientHours, 120) -- default to 5 days
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Replication_ServerContext]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[Replication_ServerContext]
(
)
RETURNS varchar(max)
AS
BEGIN
	DECLARE @serverContext varchar(max),
			@Inactive BIT,
			@ReplicatedDB BIT,
			@CacheMachineUid UNIQUEIDENTIFIER,
			@URL VARCHAR (255)
			
	SELECT @Inactive = 0,
		   @URL = CAST (SERVERPROPERTY (''MachineName'') AS VARCHAR (255))
		
	SELECT TOP 1 @ReplicatedDB =
		CASE WHEN URL = @URL
				OR EXISTS ( 
							SELECT TOP 1 *
							FROM ListCacheMachine AS t
								INNER JOIN ReplicationSettings AS t1 ON t.URL = @URL
									AND t1.Name = ''Replication.IsCacheServer''
									AND t.CacheMachineUid = t1.GuidValue
									AND t1.BoolValue <> 0
						  )
				OR EXISTS (
							SELECT TOP 1 *
							FROM ListCacheMachine AS t
								INNER JOIN ReplicationSettings AS t1 ON t.URL = @URL
									AND t1.Name = ''Replication.STSReconfigInfo''
									AND t.CacheMachineUid = t1.GuidValue
						  )
				OR NOT EXISTS (
								SELECT TOP 1 *
								FROM ReplicationFilter
								WHERE CacheMachineUid = t.CacheMachineUid
									AND TableName = ''ListCacheMachine''
							   )
			 THEN CAST (1 AS BIT)
			 ELSE CAST (0 AS BIT)
		END,
		@CacheMachineUid = t.CacheMachineUid
	FROM ViewListCacheMachine AS t
	WHERE URL = @URL
		AND Inactive = @Inactive
	
	IF @ReplicatedDB <> 0
	BEGIN
		SET @serverContext =
			CAST ((
					SELECT ServerConfigXML
					FROM ReplicationStatus
					WHERE ReplicationStatusUid = @CacheMachineUid
				  ) AS varchar (max))
	END
    RETURN @serverContext
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Replication_TransferDirection]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[Replication_TransferDirection]
(
	@onCacheClient [bit],
	@deleteConfig [bit] = 0
)
RETURNS [sysname]
AS
BEGIN
	DECLARE @TransferDirection [sysname],
		@TransferDirection_Download [sysname] = ''Download'',
		@TransferDirection_Upload [sysname] = ''Upload''

	IF @deleteConfig <> 0
	BEGIN
		IF @onCacheClient <> 0
			SET @TransferDirection = @TransferDirection_Download
		ELSE
			SET @TransferDirection = @TransferDirection_Upload
	END
	ELSE
	BEGIN
		IF @onCacheClient <> 0
			SET @TransferDirection = @TransferDirection_Upload
		ELSE
			SET @TransferDirection = @TransferDirection_Download
	END
	RETURN @TransferDirection
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ReturnUinqueID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE  FUNCTION [dbo].[ReturnUinqueID] --by LGodolphin 08/16/05
(
@TableName 	varchar(255) = '''',
@Constraint	varchar(255) = ''ExternalID''
)
RETURNS int
AS
BEGIN

DECLARE 
@Seed		int,
@SeedString	varchar(80),
@Count		int,
@ParmDefinition nvarchar(255), 
@SQLString 	nvarchar(255)

--IF ((@TableName <> '''') AND (EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N''[dbo].['' + @TableName + '']'') and OBJECTPROPERTY(id, N''IsUserTable'') = 1)))
--BEGIN

  --print ''GetUniqueID - Begin''
  WHILE (@TableName<>'''') 
  BEGIN
  
    EXEC @Seed = GetSeed @TableName
    SET @SeedString = CONVERT(varchar(80), @Seed)
    --print ''Seed: '' + @SeedString
    SET @ParmDefinition = N''@SeedValue varchar(80), @CountValue int OUT''
    SET @SQLString = N''SET @CountValue = (SELECT Count(*) FROM '' + @TableName + '' WHERE '' + @Constraint + '' = @SeedValue)''

    EXECUTE sp_executesql @SQLString, @ParmDefinition, @SeedValue = @SeedString,
                      @CountValue = @Count OUTPUT

      IF @Count = 0
        BEGIN
	  --print ''getUniqueID - Seed: '' + convert(varchar(20), @Seed)
	  BREAK
        END
  END --While

--END --IF @TableName<>''''
RETURN @Seed

END --Procedure


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RxGetDigitString]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[RxGetDigitString](@DigitValue varchar)
RETURNS varchar(5)
AS
BEGIN

	DECLARE @DigitString varchar(5)
	SET @DigitString = CASE @DigitValue
				WHEN ''0'' THEN ''''
				WHEN ''1'' THEN ''one''
				WHEN ''2'' THEN ''two''
				WHEN ''3'' THEN ''three''
				WHEN ''4'' THEN ''four''
				WHEN ''5'' THEN ''five''
				WHEN ''6'' THEN ''six''
				WHEN ''7'' THEN ''seven''
				WHEN ''8'' THEN ''eight''
				WHEN ''9'' THEN ''nine''
				ELSE @DigitValue
			END
	RETURN @DigitString
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RxGetNumberString]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[RxGetNumberString] (
		@Number varchar(38) -- Input number with as many as 18 digits
) RETURNS VARCHAR(8000) 
/*
* Converts a integer number as large as 34 digits into the 
* equivalent words.  The first letter is capitalized.
*
* Attribution: Based on NumberToWords by Srinivas Sampath
*        as revised by Nick Barclay
*
* Example:
select dbo.udf_Num_ToWords (1234567890) + CHAR(10)
      +  dbo.udf_Num_ToWords (0) + CHAR(10)
      +  dbo.udf_Num_ToWords (123) + CHAR(10)
select dbo.udf_Num_ToWords(76543210987654321098765432109876543210)
 
DECLARE @i numeric (38,0)
SET @i = 0
WHILE @I <= 1000 BEGIN 
    PRINT convert (char(5), @i)  
            + convert(varchar(255), dbo.udf_Num_ToWords(@i)) 
    SET @I  = @i + 1 
END
*
* Published as the T-SQL UDF of the Week Vol 2 #9 2/17/03
****************************************************************/
AS BEGIN
DECLARE @inputNumber VARCHAR(38)
DECLARE @NumbersTable TABLE (number CHAR(2), word VARCHAR(10))
DECLARE @outputString VARCHAR(8000)
DECLARE @length INT
DECLARE @counter INT
DECLARE @loops INT
DECLARE @position INT
DECLARE @chunk CHAR(3) -- for chunks of 3 numbers
DECLARE @tensones CHAR(2)
DECLARE @hundreds CHAR(1)
DECLARE @tens CHAR(1)
DECLARE @ones CHAR(1)

--clean up @Number by removing anything non-numeric and removing anything 
--to the right of the non-numeric
DECLARE @nPos    INTEGER

SELECT  @nPos = PATINDEX(''%[^0-9]%'', @Number)

 WHILE @nPos > 0
 BEGIN
	SELECT @Number = STUFF(@Number, @nPos, len(@Number), '''')
	SELECT  @nPos = PATINDEX(''%[^0-9]%'', @Number)
 END

 IF ISNUMERIC(@Number) = 1  
 BEGIN 
	IF @Number = 0 Return ''Zero''

	-- initialize the variables
	SELECT @inputNumber = CONVERT(varchar(38), @Number)
		 , @outputString = ''''
		 , @counter = 1
	SELECT @length   = LEN(@inputNumber)
		 , @position = LEN(@inputNumber) - 2
		 , @loops    = LEN(@inputNumber)/3

	-- make sure there is an extra loop added for the remaining numbers
	IF LEN(@inputNumber) % 3 <> 0 SET @loops = @loops + 1

	-- insert data for the numbers and words
	INSERT INTO @NumbersTable   SELECT ''00'', ''''
		UNION ALL SELECT ''01'', ''one''      UNION ALL SELECT ''02'', ''two''
		UNION ALL SELECT ''03'', ''three''    UNION ALL SELECT ''04'', ''four''
		UNION ALL SELECT ''05'', ''five''     UNION ALL SELECT ''06'', ''six''
		UNION ALL SELECT ''07'', ''seven''    UNION ALL SELECT ''08'', ''eight''
		UNION ALL SELECT ''09'', ''nine''     UNION ALL SELECT ''10'', ''ten''
		UNION ALL SELECT ''11'', ''eleven''   UNION ALL SELECT ''12'', ''twelve''
		UNION ALL SELECT ''13'', ''thirteen'' UNION ALL SELECT ''14'', ''fourteen''
		UNION ALL SELECT ''15'', ''fifteen''  UNION ALL SELECT ''16'', ''sixteen''
		UNION ALL SELECT ''17'', ''seventeen'' UNION ALL SELECT ''18'', ''eighteen''
		UNION ALL SELECT ''19'', ''nineteen'' UNION ALL SELECT ''20'', ''twenty''
		UNION ALL SELECT ''30'', ''thirty''   UNION ALL SELECT ''40'', ''forty''
		UNION ALL SELECT ''50'', ''fifty''    UNION ALL SELECT ''60'', ''sixty''
		UNION ALL SELECT ''70'', ''seventy''  UNION ALL SELECT ''80'', ''eighty''
		UNION ALL SELECT ''90'', ''ninety''   

	WHILE @counter <= @loops BEGIN

		-- get chunks of 3 numbers at a time, padded with leading zeros
		SET @chunk = RIGHT(''000'' + SUBSTRING(@inputNumber, @position, 3), 3)

		IF @chunk <> ''000'' BEGIN
			SELECT @tensones = SUBSTRING(@chunk, 2, 2)
				 , @hundreds = SUBSTRING(@chunk, 1, 1)
				 , @tens = SUBSTRING(@chunk, 2, 1)
				 , @ones = SUBSTRING(@chunk, 3, 1)

			-- If twenty or less, use the word directly from @NumbersTable
			IF CONVERT(int, @tensones) <= 20 OR @Ones=''0'' BEGIN
				SET @outputString = (SELECT word 
										  FROM @NumbersTable 
										  WHERE @tensones = number)
					   + CASE @counter WHEN 1 THEN '''' -- No name
						   WHEN 2 THEN '' thousand '' WHEN 3 THEN '' million ''
						   WHEN 4 THEN '' billion ''  WHEN 5 THEN '' trillion ''
						   WHEN 6 THEN '' quadrillion '' WHEN 7 THEN '' quintillion ''
						   WHEN 8 THEN '' sextillion ''  WHEN 9 THEN '' septillion ''
						   WHEN 10 THEN '' octillion ''  WHEN 11 THEN '' nonillion ''
						   WHEN 12 THEN '' decillion ''  WHEN 13 THEN '' undecillion ''
						   ELSE '''' END
								   + @outputString
				END
			 ELSE BEGIN -- break down the ones and the tens separately

				 SET @outputString = '' '' 
								+ (SELECT word 
										FROM @NumbersTable 
										WHERE @tens + ''0'' = number)
								 + ''-''
								 + (SELECT word 
										FROM @NumbersTable 
										WHERE ''0''+ @ones = number)
					   + CASE @counter WHEN 1 THEN '''' -- No name
						   WHEN 2 THEN '' thousand '' WHEN 3 THEN '' million ''
						   WHEN 4 THEN '' billion ''  WHEN 5 THEN '' trillion ''
						   WHEN 6 THEN '' quadrillion '' WHEN 7 THEN '' quintillion ''
						   WHEN 8 THEN '' sextillion ''  WHEN 9 THEN '' septillion ''
						   WHEN 10 THEN '' octillion ''  WHEN 11 THEN '' nonillion ''
						   WHEN 12 THEN '' decillion ''   WHEN 13 THEN '' undecillion ''
						   ELSE '''' END
								+ @outputString
			END

			-- now get the hundreds
			IF @hundreds <> ''0'' BEGIN
				SET @outputString  = (SELECT word 
										  FROM @NumbersTable 
										  WHERE ''0'' + @hundreds = number)
									+ '' hundred '' 
									+ @outputString
			END
		END

		SELECT @counter = @counter + 1
			 , @position = @position - 3

	END

	-- Remove any double spaces
	SET @outputString = LTRIM(RTRIM(REPLACE(@outputString, ''  '', '' '')))
	SET @outputstring = UPPER(LEFT(@outputstring, 1)) + SUBSTRING(@outputstring, 2, 8000)
	
END

RETURN @outputString -- return the result
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RxGetTeenString]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[RxGetTeenString](@Value varchar(2))
RETURNS varchar(9)
AS
BEGIN

	DECLARE @String varchar(9)
	SET @String = CASE RIGHT(@Value,1)
				WHEN ''0'' THEN ''ten''
				WHEN ''1'' THEN ''eleven''
				WHEN ''2'' THEN ''twelve''
				WHEN ''3'' THEN ''thirteen''
				WHEN ''4'' THEN ''fourteen''
				WHEN ''5'' THEN ''fifteen''
				WHEN ''6'' THEN ''sixteen''
				WHEN ''7'' THEN ''seventeen''
				WHEN ''8'' THEN ''eighteen''
				WHEN ''9'' THEN ''nineteen''
				ELSE @Value
			END
	RETURN @String
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RxGetTensString]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[RxGetTensString](@Value varchar)
RETURNS varchar(7)
AS
BEGIN

	DECLARE @String varchar(7)
	SET @String = CASE @Value
				WHEN ''0'' THEN ''''
				WHEN ''1'' THEN ''ten''
				WHEN ''2'' THEN ''twenty''
				WHEN ''3'' THEN ''thirty''
				WHEN ''4'' THEN ''forty''
				WHEN ''5'' THEN ''fifty''
				WHEN ''6'' THEN ''sixty''
				WHEN ''7'' THEN ''seventy''
				WHEN ''8'' THEN ''eighty''
				WHEN ''9'' THEN ''ninety''
				ELSE @Value
			END
	RETURN @String
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RxNormCode]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[RxNormCode](@mnid int) RETURNS VARCHAR(50) AS
BEGIN
/*
	Created 02/05/2010
	
	Finds and returns the Rx Norm Code for a given medication name.
	
	Parameter @mnid is the PK of table dbo.NDD_SearchDrugName used to find the Rx Norm Code.
	
*/
	declare @hicl int
	declare @baseingredientid int
	declare @nametypecode varchar(1)

	declare @RxNormCode varchar(50)

	-- assign @nametypecode
	SELECT @nametypecode = nam.DrugNameTypeCode FROM dbo.NDD_SearchDrugName nam WHERE nam.IsDelete = 0 AND nam.mnid = @mnid
		
	-- assign @hicl
	SELECT @hicl = hic.HICL_SEQNO FROM dbo.NDD_RMEDMHL0_MED_HICLSEQNO_LINK hic WHERE hic.IsDelete = 0 AND hic.MED_CONCEPT_ID_TYP = 1 AND hic.MED_CONCEPT_ID = @mnid

	IF (@nametypecode = ''1'')
	BEGIN
		-- try to find brand name
		SELECT @RxNormCode = lnk.EVD_EXT_VOCAB_ID 
		FROM dbo.NDD_REVDEL0_EXT_VOCAB_LINK lnk
		WHERE lnk.IsDelete = 0
		  AND lnk.EVD_FDB_VOCAB_ID = CONVERT(varchar(255), @mnid)
		  AND lnk.EVD_FDB_VOCAB_TYPE_ID = 1
	END

	IF ((@RxNormCode is null) OR (@RxNormCode = ''''))
	BEGIN
		-- generic drug name
		
		-- find value for baseingredientid
		SELECT @baseingredientid = ing.HIC_ROOT 
			FROM dbo.NDD_RHICD5_HIC_DESC ing
				INNER JOIN dbo.NDD_RDAMHHA0_HIC_HICL_ALG_LINK hic ON hic.IsDelete = 0 AND ing.HIC_SEQN = hic.HICL_SEQNO
			WHERE ing.IsDelete = 0
			  AND hic.DAM_ALRGN_HIC_SEQN = @hicl

		SELECT @RxNormCode = lnk.EVD_EXT_VOCAB_ID 
		FROM dbo.NDD_REVDEL0_EXT_VOCAB_LINK lnk
		WHERE lnk.IsDelete = 0
		  AND lnk.EVD_FDB_VOCAB_ID = CONVERT(varchar(255), @baseingredientid)
		  AND lnk.EVD_EXT_VOCAB_TYPE_ID = 500
		  AND lnk.EVD_FDB_VOCAB_TYPE_ID = 104
	END

	RETURN @RxNormCode
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RxNormCodeFromMedID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[RxNormCodeFromMedID](@medid int) RETURNS VARCHAR(50) AS
BEGIN
/*
   Created 10/11/2010

   Finds and returns the Rx Norm Code for a given dispensable medication.

   Parameter @medid is the PK of table dbo.NDD_SearchDispensable used to find the Rx Norm Code.

*/
   DECLARE @RxNormCode VARCHAR(50)

    SELECT @RxNormCode = dis.RxNormCode
    FROM dbo.NDD_SearchDispensable dis
    WHERE dis.IsDelete = 0
	  AND dis.medid = @medid

   RETURN @RxNormCode
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RxNormCodeFromQuestionUid]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[RxNormCodeFromQuestionUid](@QuestionUid uniqueidentifier) RETURNS VARCHAR(50) AS
BEGIN
/*
	Created 10/11/2010
	
	Finds and returns the Rx Norm Code for a given row from the ListQuestion table.
	
	Parameter @QuestionUid is the PK of table ListQuestion.
	
*/
	declare @RxNormCode varchar(50)
	declare @mnid int
	
	SET @RxNormCode = ''''
	
	SELECT @mnid = FDB_HIC_SEQN FROM ListQuestion WHERE QuestionUid = @QuestionUid AND FDBIDType = ''DrugName''
	
	IF (@mnid is not null AND @mnid > 0)
	BEGIN
		SELECT @RxNormCode = dbo.RxNormCode(@mnid)
	END

	if (@mnid is not null and @mnid < 0)
	begin
		select @RxNormCode = convert(varchar(50),RxNorm) from ListMedication where medid = @mnid
	end
	
	return @RxNormCode
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RxNormQualifierFromMedID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[RxNormQualifierFromMedID](@medid int) RETURNS VARCHAR(10) AS
BEGIN
/*
   Created 10/11/2010

   Finds and returns the Rx Norm Code Qualifier for a given dispensable medication.

   Parameter @medid is the PK of table dbo.NDD_SearchDispensable used to find the Rx Norm Code Qualifier.

*/
   DECLARE @RxNormQualifier VARCHAR(50)

   SELECT @RxNormQualifier = dis.RxNormQualifier
   FROM  dbo.NDD_SearchDispensable dis
   WHERE dis.IsDelete = 0
     AND dis.medid = @medid

   RETURN @RxNormQualifier
END
' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SafeXmlCast]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[SafeXmlCast](@value [nvarchar](max))
RETURNS [xml] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[SafeXmlCast]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ScrubXmlContentTag]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ScrubXmlContentTag](@Src xml)
RETURNS xml AS

BEGIN
	declare @Xml xml

	if CONVERT(VARCHAR(max), @src) is null
		return @Src

	set @Xml = @Src
	set @Xml.modify(''replace value of (/DirectMessages/Attachments/AttachmentData/Content/text())[1] with ""'')

	return @Xml
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ServiceLevelCode]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ServiceLevelCode]
(
	@nServiceLevelCode int
)
RETURNS VARCHAR (1024)
AS
BEGIN
	-- Declare the return variable here
	DECLARE @vcServiceLevelCode VARCHAR (1024)
	SET @vcServiceLevelCode = ''''
	
	IF @nServiceLevelCode IS NULL
		SET @vcServiceLevelCode = ''None''
	ELSE
	BEGIN
		/*
			1 New Rx
			2 Refill
			4 Change
			8 RxFill
			16 Cancel
			32 MedHistory
			64 Eligibility
			128 Not used
			256 Resupply
			512 Census
			1,024 CCR
			2,048 Controlled Substance (EPCS)	
		*/
		IF @nServiceLevelCode & 1 = 1
			SET @vcServiceLevelCode = ''NewRx''

		IF @nServiceLevelCode & 2 = 2
		BEGIN
			IF LEN (@vcServiceLevelCode) > 1
				SET @vcServiceLevelCode = @vcServiceLevelCode + '', ''
			SET @vcServiceLevelCode = @vcServiceLevelCode + ''RefReq/RefRes''
		END

		IF @nServiceLevelCode & 4 = 4
		BEGIN
			IF LEN (@vcServiceLevelCode) > 1
				SET @vcServiceLevelCode = @vcServiceLevelCode + '', ''
			SET @vcServiceLevelCode = @vcServiceLevelCode + ''RxChg/ChgRes''
		END

		IF @nServiceLevelCode & 8 = 8
		BEGIN
			IF LEN (@vcServiceLevelCode) > 1
				SET @vcServiceLevelCode = @vcServiceLevelCode + '', ''
			SET @vcServiceLevelCode = @vcServiceLevelCode + ''RxFill''
		END

		IF @nServiceLevelCode & 16 = 16
		BEGIN
			IF LEN (@vcServiceLevelCode) > 1
				SET @vcServiceLevelCode = @vcServiceLevelCode + '', ''
			SET @vcServiceLevelCode = @vcServiceLevelCode + ''CanRx/CanRxRes''
		END

		IF @nServiceLevelCode & 32 = 32
		BEGIN
			IF LEN (@vcServiceLevelCode) > 1
				SET @vcServiceLevelCode = @vcServiceLevelCode + '', ''
			SET @vcServiceLevelCode = @vcServiceLevelCode + ''Medication History''
		END

		IF @nServiceLevelCode & 64 = 64
		BEGIN
			IF LEN (@vcServiceLevelCode) > 1
				SET @vcServiceLevelCode = @vcServiceLevelCode + '', ''
			SET @vcServiceLevelCode = @vcServiceLevelCode + ''Eligibility''
		END
		
		IF @nServiceLevelCode & 256 = 256
		BEGIN
			IF LEN (@vcServiceLevelCode) > 1
				SET @vcServiceLevelCode = @vcServiceLevelCode + '', ''
			SET @vcServiceLevelCode = @vcServiceLevelCode + ''Resupply''
		END

		IF @nServiceLevelCode & 512 = 512
		BEGIN
			IF LEN (@vcServiceLevelCode) > 1
				SET @vcServiceLevelCode = @vcServiceLevelCode + '', ''
			SET @vcServiceLevelCode = @vcServiceLevelCode + ''Census''
		END

		IF @nServiceLevelCode & 1024 = 1024
		BEGIN
			IF LEN (@vcServiceLevelCode) > 1
				SET @vcServiceLevelCode = @vcServiceLevelCode + '', ''
			SET @vcServiceLevelCode = @vcServiceLevelCode + ''CCR''
		END

		IF @nServiceLevelCode & 2048 = 2048
		BEGIN
			IF LEN (@vcServiceLevelCode) > 1
				SET @vcServiceLevelCode = @vcServiceLevelCode + '', ''
			SET @vcServiceLevelCode = @vcServiceLevelCode + ''Controlled Substance (EPCS)''
		END
	END

	-- Return the result of the function
	RETURN @vcServiceLevelCode
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SpecialtyIDCode]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[SpecialtyIDCode]
(
	@nSpecialtyIDCode int
)
RETURNS VARCHAR (1024)
AS
BEGIN
	-- Declare the return variable here
	DECLARE @vcSpecialtyIDCode VARCHAR (1024)
	SET @vcSpecialtyIDCode = ''''
	
	IF @nSpecialtyIDCode IS NULL
		SET @vcSpecialtyIDCode = '''' -- ''None''
	ELSE
	BEGIN
		IF @nSpecialtyIDCode & 1 = 1
			SET @vcSpecialtyIDCode = ''Mail Order''

		IF @nSpecialtyIDCode & 2 = 2
		BEGIN
			IF LEN (@vcSpecialtyIDCode) > 1
				SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + '', ''
			SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + ''Fax''
		END

		IF @nSpecialtyIDCode & 4 = 4
		BEGIN
			IF LEN (@vcSpecialtyIDCode) > 1
				SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + '', ''
			SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + ''MedReconciliation''
		END

		IF @nSpecialtyIDCode & 8 = 8
		BEGIN
			IF LEN (@vcSpecialtyIDCode) > 1
				SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + '', ''
			SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + ''Retail''
		END

		IF @nSpecialtyIDCode & 16 = 16
		BEGIN
			IF LEN (@vcSpecialtyIDCode) > 1
				SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + '', ''
			SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + ''Specialty''
		END

		IF @nSpecialtyIDCode & 32 = 32
		BEGIN
			IF LEN (@vcSpecialtyIDCode) > 1
				SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + '', ''
			SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + ''Long-Term Care''
		END

		IF @nSpecialtyIDCode & 64 = 64
		BEGIN
			IF LEN (@vcSpecialtyIDCode) > 1
				SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + '', ''
			SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + ''24 Hour''
		END
		
		IF @nSpecialtyIDCode & 256 = 256
		BEGIN
			IF LEN (@vcSpecialtyIDCode) > 1
				SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + '', ''
			SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + ''Physician Assistant''
		END

		IF @nSpecialtyIDCode & 256 = 256
		BEGIN
			IF LEN (@vcSpecialtyIDCode) > 1
				SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + '', ''
			SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + ''Resupply''
		END

		IF @nSpecialtyIDCode & 512 = 512
		BEGIN
			IF LEN (@vcSpecialtyIDCode) > 1
				SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + '', ''
			SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + ''Nurse Practitioner''
		END

		IF @nSpecialtyIDCode & 1024 = 1024
		BEGIN
			IF LEN (@vcSpecialtyIDCode) > 1
				SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + '', ''
			SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + ''Resident''
		END

		IF @nSpecialtyIDCode & 2048 = 2048
		BEGIN
			IF LEN (@vcSpecialtyIDCode) > 1
				SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + '', ''
			SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + ''In-Store Clinic''
		END
	END

	-- Return the result of the function
	RETURN @vcSpecialtyIDCode
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Split_CSRx]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[Split_CSRx]
 (	@vcDelimitedString VARCHAR(8000),
	@vcDelimiter VARCHAR(100) 
 )

RETURNS @tblArray TABLE
   (
	ElementID	smallint	IDENTITY(1,1),  --Array index
   	Element		varchar(1000)			--Array element contents
   )
AS
BEGIN

	DECLARE
	@siIndex	SMALLINT,
	@siStart		SMALLINT,
	@siDelSize	SMALLINT


	SET @siDelSize	= LEN(@vcDelimiter)
	--loop through source string and add elements to destination table array
	WHILE LEN(@vcDelimitedString) > 0
	BEGIN
		SET @siIndex = CHARINDEX(@vcDelimiter, @vcDelimitedString)
		IF @siIndex = 0
		BEGIN
			INSERT INTO @tblArray VALUES(@vcDelimitedString)
			BREAK
		END
		ELSE
		BEGIN
			INSERT INTO @tblArray VALUES(SUBSTRING(@vcDelimitedString, 1,@siIndex - 1))
			SET @siStart = @siIndex + @siDelSize
			SET @vcDelimitedString = SUBSTRING(@vcDelimitedString, @siStart , LEN(@vcDelimitedString) - @siStart + 1)
		END
	END

	RETURN
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Split_RVUProductivityReport]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[Split_RVUProductivityReport]
 (	@vcDelimitedString VARCHAR(8000),
	@vcDelimiter VARCHAR(100) 
 )

RETURNS @tblArray TABLE
   (
	ElementID	smallint	IDENTITY(1,1),  --Array index
   	Element		varchar(1000)			--Array element contents
   )
AS
BEGIN

	DECLARE
	@siIndex	SMALLINT,
	@siStart		SMALLINT,
	@siDelSize	SMALLINT


	SET @siDelSize	= LEN(@vcDelimiter)
	--loop through source string and add elements to destination table array
	WHILE LEN(@vcDelimitedString) > 0
	BEGIN
		SET @siIndex = CHARINDEX(@vcDelimiter, @vcDelimitedString)
		IF @siIndex = 0
		BEGIN
			INSERT INTO @tblArray VALUES(@vcDelimitedString)
			BREAK
		END
		ELSE
		BEGIN
			INSERT INTO @tblArray VALUES(SUBSTRING(@vcDelimitedString, 1,@siIndex - 1))
			SET @siStart = @siIndex + @siDelSize
			SET @vcDelimitedString = SUBSTRING(@vcDelimitedString, @siStart , LEN(@vcDelimitedString) - @siStart + 1)
		END
	END

	RETURN
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Split_RVUReport]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[Split_RVUReport]
 (	@vcDelimitedString VARCHAR(8000),
	@vcDelimiter VARCHAR(100) 
 )

RETURNS @tblArray TABLE
   (
	ElementID	smallint	IDENTITY(1,1),  --Array index
   	Element		varchar(1000)			--Array element contents
   )
AS
BEGIN

	DECLARE
	@siIndex	SMALLINT,
	@siStart		SMALLINT,
	@siDelSize	SMALLINT


	SET @siDelSize	= LEN(@vcDelimiter)
	--loop through source string and add elements to destination table array
	WHILE LEN(@vcDelimitedString) > 0
	BEGIN
		SET @siIndex = CHARINDEX(@vcDelimiter, @vcDelimitedString)
		IF @siIndex = 0
		BEGIN
			INSERT INTO @tblArray VALUES(@vcDelimitedString)
			BREAK
		END
		ELSE
		BEGIN
			INSERT INTO @tblArray VALUES(SUBSTRING(@vcDelimitedString, 1,@siIndex - 1))
			SET @siStart = @siIndex + @siDelSize
			SET @vcDelimitedString = SUBSTRING(@vcDelimitedString, @siStart , LEN(@vcDelimitedString) - @siStart + 1)
		END
	END

	RETURN
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SplitList_AS]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[SplitList_AS] (@list VARCHAR(MAX), @separator VARCHAR(MAX) = '','')  
RETURNS @table TABLE   
(  
	Value VARCHAR(MAX))AS   
	BEGIN     
		DECLARE @position INT,   
		@previous INT     
		SET @list = @list + @separator     
		SET @previous = 1     
		SET @position = CHARINDEX(@separator, @list)     
		WHILE @position > 0   
			BEGIN        
			IF @position - @previous > 0           
				INSERT INTO @table VALUES (SUBSTRING(@list, @previous, @position - @previous))        
				IF @position >= LEN(@list)   
					BREAK        
			SET @previous = @position + 1        
			SET @position = CHARINDEX(@separator, @list, @previous)     
		END     
	RETURN  
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SplitList_FS]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[SplitList_FS] (@list VARCHAR(MAX), @separator VARCHAR(MAX) = '','')  
RETURNS @table TABLE   
(  
	Value VARCHAR(MAX))AS   
	BEGIN     
		DECLARE @position INT,   
		@previous INT     
		SET @list = @list + @separator     
		SET @previous = 1     
		SET @position = CHARINDEX(@separator, @list)     
		WHILE @position > 0   
			BEGIN        
			IF @position - @previous > 0           
				INSERT INTO @table VALUES (SUBSTRING(@list, @previous, @position - @previous))        
				IF @position >= LEN(@list)   
					BREAK        
			SET @previous = @position + 1        
			SET @position = CHARINDEX(@separator, @list, @previous)     
		END     
	RETURN  
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SplitList_Hedis1]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[SplitList_Hedis1] (@list VARCHAR(MAX), @separator VARCHAR(MAX) = '','')  
RETURNS @table TABLE   
(  
	Value VARCHAR(MAX))AS   
	BEGIN     
		DECLARE @position INT,   
		@previous INT     
		SET @list = @list + @separator     
		SET @previous = 1     
		SET @position = CHARINDEX(@separator, @list)     
		WHILE @position > 0   
			BEGIN        
			IF @position - @previous > 0           
				INSERT INTO @table VALUES (SUBSTRING(@list, @previous, @position - @previous))        
				IF @position >= LEN(@list)   
					BREAK        
			SET @previous = @position + 1        
			SET @position = CHARINDEX(@separator, @list, @previous)     
		END     
	RETURN  
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SplitList_Hedis]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[SplitList_Hedis]
 (	@vcDelimitedString VARCHAR(8000),
	@vcDelimiter VARCHAR(100) 
 )

RETURNS @AgeTable TABLE
(
	ElementID  SMALLINT identity(1,1),  --Array index
    Age1  VARCHAR(50), --Array element contents,
	Age2  VARCHAR(50), --Array element contents,
	AgeType Varchar(50)
)
AS
BEGIN

	Declare @AgeTemp Table
	(
		Age  Float --Array element contents,
	)

	DECLARE
	@siIndex	SMALLINT,
	@siStart		SMALLINT,
	@siDelSize	SMALLINT


	SET @siDelSize	= LEN(@vcDelimiter)
	--loop through source string and add elements to destination table array
	WHILE LEN(@vcDelimitedString) > 0
	BEGIN
		SET @siIndex = CHARINDEX(@vcDelimiter, @vcDelimitedString)
		IF @siIndex = 0
		BEGIN
			Delete from @AgeTemp
			INSERT INTO @AgeTemp Select * from SplitList_Hedis1(@vcDelimitedString,''-'')
			INSERT INTO @AgeTable Select Min(Age),Max(Age),@vcDelimitedString from @AgeTemp
			BREAK
		END
		ELSE
		BEGIN
			Delete from @AgeTemp
			INSERT INTO @AgeTemp Select * from SplitList_Hedis1(SUBSTRING(@vcDelimitedString, 1,@siIndex - 1),''-'')
			INSERT INTO @AgeTable Select Min(Age),Max(Age),SUBSTRING(@vcDelimitedString, 1,@siIndex - 1) from @AgeTemp
			SET @siStart = @siIndex + @siDelSize
			SET @vcDelimitedString = SUBSTRING(@vcDelimitedString, @siStart , LEN(@vcDelimitedString) - @siStart + 1)
		END
	END

	RETURN
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SplitList_InsuranceProductivity]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[SplitList_InsuranceProductivity] (@list VARCHAR(MAX), @separator VARCHAR(MAX) = '','')  
RETURNS @table TABLE   
(  
	Value VARCHAR(MAX))AS   
	BEGIN     
		DECLARE @position INT,   
		@previous INT     
		SET @list = @list + @separator     
		SET @previous = 1     
		SET @position = CHARINDEX(@separator, @list)     
		WHILE @position > 0   
			BEGIN        
			IF @position - @previous > 0           
				INSERT INTO @table VALUES (SUBSTRING(@list, @previous, @position - @previous))        
				IF @position >= LEN(@list)   
					BREAK        
			SET @previous = @position + 1        
			SET @position = CHARINDEX(@separator, @list, @previous)     
		END     
	RETURN  
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SplitList_PI]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[SplitList_PI] (@list VARCHAR(MAX), @separator VARCHAR(MAX) = '','')  

RETURNS @table TABLE   

(  

	Value VARCHAR(MAX))AS   

	BEGIN     

		DECLARE @position INT,   

		@previous INT     

		SET @list = @list + @separator     

		SET @previous = 1     

		SET @position = CHARINDEX(@separator, @list)     

		WHILE @position > 0   

			BEGIN        

			IF @position - @previous > 0           

				INSERT INTO @table VALUES (SUBSTRING(@list, @previous, @position - @previous))        

				IF @position >= LEN(@list)   

					BREAK        

			SET @previous = @position + 1        

			SET @position = CHARINDEX(@separator, @list, @previous)     

		END     

	RETURN  

END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SplitList_RA]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[SplitList_RA] (@list VARCHAR(MAX), @separator VARCHAR(MAX) = '','')  
RETURNS @table TABLE   
(  
	Value VARCHAR(MAX))AS   
	BEGIN     
		DECLARE @position INT,   
		@previous INT     
		SET @list = @list + @separator     
		SET @previous = 1     
		SET @position = CHARINDEX(@separator, @list)     
		WHILE @position > 0   
			BEGIN        
			IF @position - @previous > 0           
				INSERT INTO @table VALUES (SUBSTRING(@list, @previous, @position - @previous))        
				IF @position >= LEN(@list)   
					BREAK        
			SET @previous = @position + 1        
			SET @position = CHARINDEX(@separator, @list, @previous)     
		END     
	RETURN  
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SplitList_SR]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[SplitList_SR] (@list VARCHAR(MAX), @separator VARCHAR(MAX) = '','')  
RETURNS @table TABLE   
(  
	Value VARCHAR(MAX))AS   
	BEGIN     
		DECLARE @position INT,   
		@previous INT     
		SET @list = @list + @separator     
		SET @previous = 1     
		SET @position = CHARINDEX(@separator, @list)     
		WHILE @position > 0   
			BEGIN        
			IF @position - @previous > 0           
				INSERT INTO @table VALUES (SUBSTRING(@list, @previous, @position - @previous))        
				IF @position >= LEN(@list)   
					BREAK        
			SET @previous = @position + 1        
			SET @position = CHARINDEX(@separator, @list, @previous)     
		END     
	RETURN  
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SplitList_VP]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[SplitList_VP] (@list VARCHAR(MAX), @separator VARCHAR(MAX) = '','')  
RETURNS @table TABLE   
( 
	Value VARCHAR(MAX))
AS   
	BEGIN     
		DECLARE @position INT,   
		@previous INT     
		SET @list = @list + @separator     
		SET @previous = 1     
		SET @position = CHARINDEX(@separator, @list)     
		WHILE @position > 0   
			BEGIN        
			IF @position - @previous > 0           
				INSERT INTO @table VALUES (SUBSTRING(@list, @previous, @position - @previous))        
				IF @position >= LEN(@list)   
					BREAK        
			SET @previous = @position + 1        
			SET @position = CHARINDEX(@separator, @list, @previous)     
		END     
	RETURN  
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SplitLockHierarchy]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[SplitLockHierarchy] (@vcDelimitedString VARCHAR(max))
RETURNS @tblArray TABLE (
	ElementID SMALLINT IDENTITY(1, 1) --Array index
	,Element VARCHAR(1000) --Array element contents
	)
AS
BEGIN
	--returns each level in a lock hierarchy''s ancestors.
	--given "VisitNote.RX.A", it will return a table with the following rows.
	--| Element ID |     Element    |
	--|------------|----------------|
	--|      1     | VisitNote.RX.A |
	--|      2     |  VisitNote.RX  |
	--|      3     |    VisitNote   |

	DECLARE @siIndex SMALLINT
		,@delimiter NVARCHAR(1)

	SET @delimiter = ''.''
	SET @vcDelimitedString = REVERSE(@vcDelimitedString)

	--loop through source string and add elements to destination table array
	WHILE LEN(@vcDelimitedString) > 0
	BEGIN
		SET @siIndex = CHARINDEX(@delimiter, @vcDelimitedString)

		IF @siIndex = 0
		BEGIN
			INSERT INTO @tblArray
			VALUES (REVERSE(@vcDelimitedString))

			BREAK
		END
		ELSE
		BEGIN
			INSERT INTO @tblArray
			VALUES (REVERSE(@vcDelimitedString))

			SET @vcDelimitedString = SUBSTRING(@vcDelimitedString, @siIndex + 1, LEN(@vcDelimitedString) - @siIndex + 1)
		END
	END

	RETURN
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[stripSpecialChars]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE FUNCTION [dbo].[stripSpecialChars]
	(@inputString varchar(255))
RETURNS varchar(255) AS
BEGIN
-- Quick function to strip special chars for ID and reference number comparisons.
-- For example a SSN could be ''519-99-9999'' or ''519999999'' and you''d want both to be equal.
-- a telephone number could be ''(650)999-9999'' or ''650.999.9999'' or ''650-999-9999'' or ...

--Removes the following chars: - . ( ) _ \ / , * + '' "

DECLARE @RETVAL VARCHAR(255)
SELECT
	@RETVAL =
	REPLACE(
	REPLACE(REPLACE(REPLACE(REPLACE(
	REPLACE(REPLACE(REPLACE(REPLACE(
	REPLACE(REPLACE(REPLACE(REPLACE(@inputString,
	''-'',''''),
	''.'',''''),
	'')'',''''),
	''('',''''),
	''_'',''''),
	''/'',''''),
	''\'',''''),
	'','',''''),
	''*'',''''),
	''+'',''''),
	'''''''',''''),
	''"'',''''),
	'' '','''')

RETURN(@RETVAL)

END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[StrToGUID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE FUNCTION [dbo].[StrToGUID] (@PK_ID varchar(200))
RETURNS uniqueidentifier AS  

BEGIN  

  declare @Wrk varchar(200)
  declare @NewGUID uniqueidentifier

  set @Wrk = @PK_ID

  if @Wrk is not null
    begin
      while len(@Wrk) < 32 set @Wrk = ''0'' + @Wrk

      set @Wrk = SUBSTRING(@Wrk, 1, 8) + ''-'' + SUBSTRING(@Wrk, 9, 4) + ''-'' + SUBSTRING(@Wrk, 13, 4) 
             + ''-'' + SUBSTRING(@Wrk, 17, 4) + ''-'' + SUBSTRING(@Wrk, 21, 12)
      set @Wrk = ''{'' + @Wrk + ''}''
      set @NewGUID = @Wrk
    end
 
  return (@NewGUID)
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SystemEmptyGuid]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


-- function returning a Prm system Guid
CREATE FUNCTION [dbo].[SystemEmptyGuid] (@SystemId int)
RETURNS uniqueidentifier AS  

BEGIN  

  declare @Wrk varchar(200)
  declare @NewGUID uniqueidentifier

  if (@SystemId < 0) 
	set @SystemId = -1 * @SystemId
  set @Wrk = convert (varchar(200), @SystemId)
  while len(@Wrk) < 32 set @Wrk = ''0'' + @Wrk

  set @Wrk = ''00000000'' + ''-'' + SUBSTRING(@Wrk, 9, 4) + ''-'' + SUBSTRING(@Wrk, 13, 4) 
                              + ''-'' + SUBSTRING(@Wrk, 17, 4) + ''-'' + SUBSTRING(@Wrk, 21, 12)
  set @Wrk = ''{'' + @Wrk + ''}''
  set @NewGUID = @Wrk
  return (@NewGUID)
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ToBase64]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ToBase64]
(
	@data [VARCHAR](MAX)
)
RETURNS [VARCHAR](MAX)
AS
BEGIN
	IF @data IS NOT NULL AND LEN(@data) > 0
	BEGIN
		DECLARE	@binaryData varbinary(MAX)
		SET @binaryData =  CAST(@data AS varbinary(max))

		RETURN (SELECT CAST(N'''' AS XML).value(''xs:base64Binary(xs:hexBinary(sql:variable("@binaryData")))'', ''VARCHAR(MAX)''))
	END
	RETURN NULL
END
' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Try_Parse_Float]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[Try_Parse_Float](@value [nvarchar](255))
RETURNS [float] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[Try_Parse_Float]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_AR_getGLDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE FUNCTION [dbo].[UDF_AR_getGLDate] (@dtCreateDate datetime, @dtCurrentPeriodEnd DATE)

RETURNS datetime AS 

BEGIN
	DECLARE @theGLDate DATE
	
	If (@dtCurrentPeriodEnd > @dtCreateDate) 
		Select @theGLDate = @dtCreateDate 
	Else 
		Select @theGLDate = @dtCurrentPeriodEnd 
	
	RETURN @theGLDate
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_AR_getInsLevelName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[UDF_AR_getInsLevelName]
	(@insLevel smallint)
RETURNS varchar(10) AS 
BEGIN
	RETURN (CASE @insLevel 
		WHEN Null THEN '''' 
		WHEN 0 THEN '''' 
		WHEN 1 THEN ''Primary'' 
		WHEN 2 THEN ''Secondary'' 
		WHEN 3 THEN ''Tertiary'' 
		WHEN 4 THEN ''Quaternary'' 
		WHEN 5 THEN ''Quinary'' 
		WHEN 6 THEN ''Senary'' 
		WHEN 7 THEN ''Septary'' 
		WHEN 8 THEN ''Ogdoad'' 
		WHEN 9 THEN ''Ennead'' 
		WHEN 10 THEN ''Decad'' 
		ELSE (convert(varchar(8), @insLevel) + ''th'') END)
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_AR_getLiabilityName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[UDF_AR_getLiabilityName]
	(@liabilityOwner smallint)
RETURNS varchar(10) AS 
BEGIN
	declare @return varchar(10)
	Select @return = Upper(dbo.UDF_AR_getInsLevelName(@liabilityOwner))
	If (@return = '''') Select @return = ''PATIENT''
	RETURN @return
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_AR_getPlanClaimFormatUid]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[UDF_AR_getPlanClaimFormatUid] (@claimPaper bit, @insurancePlanUid uniqueidentifier, @insuranceOrder int) RETURNS uniqueidentifier AS
BEGIN
	DECLARE @useCarrierElectronicClaimFormat bit
	DECLARE @useCarrierPaperClaimFormat bit
	DECLARE @planElectronicClaimFormatUid uniqueidentifier
	DECLARE @carrierElectronicClaimFormatUid uniqueidentifier
	DECLARE @planPaperClaimFormatUid uniqueidentifier
	DECLARE @carrierPaperClaimFormatUid uniqueidentifier
	DECLARE @planUseCarrierPaperClaimDefaultOption bit
	DECLARE @planPaperClaimDefaultOptionUid uniqueidentifier
	DECLARE @carrierPaperClaimDefaultOptionUid uniqueidentifier

	SELECT	@useCarrierElectronicClaimFormat = ip.UseCarrierElectronicClaimFormat,
			@useCarrierPaperClaimFormat = ip.UseCarrierPaperClaimFormat,
			@planElectronicClaimFormatUid = ip.ElectronicClaimFormatUid,
			@carrierElectronicClaimFormatUid = ic.ElectronicClaimFormatUid,
			@planPaperClaimFormatUid = ip.PaperClaimFormatUid, 
			@carrierPaperClaimFormatUid = ic.PaperClaimFormatUid,
			@planUseCarrierPaperClaimDefaultOption = ip.UseCarrierPaperClaimDefaultOption,
			@planPaperClaimDefaultOptionUid = ip.PaperClaimDefaultOptionUid,
			@carrierPaperClaimDefaultOptionUid = ic.PaperClaimDefaultOptionUid
	FROM	InsurancePlan ip 
				INNER JOIN InsuranceCarrier ic ON ip.InsuranceCarrierUid = ic.CorporationUid
	WHERE	ip.InsurancePlanUid = @insurancePlanUid

	RETURN dbo.UDF_AR_getClaimFormatUid(@claimPaper, @useCarrierElectronicClaimFormat, @useCarrierPaperClaimFormat,
										@planElectronicClaimFormatUid , @carrierElectronicClaimFormatUid, 
										@planPaperClaimFormatUid, @carrierPaperClaimFormatUid,
										@planUseCarrierPaperClaimDefaultOption, @planPaperClaimDefaultOptionUid, @carrierPaperClaimDefaultOptionUid, @InsuranceOrder )
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_AR_getTransactionBatches]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_AR_getTransactionBatches](@transactionUid uniqueidentifier) RETURNS VARCHAR(max) AS
BEGIN
	DECLARE		@Batch varchar(max)

	--SELECT 		@Batch = ISNULL(@Batch + '','', '''') + arb.[Name]
	--FROM		ARBatch arb 
	--WHERE		arb.ARBatchUid IN (SELECT c.ARBatchUid FROM ARContext arc INNER JOIN Charge c ON arc.ARContextUid = c.ARContextUid AND arc.SuperbillUid = @SuperbillUid)
	--ORDER BY	arb.Name
	
	--select arl.
	--from AR_Ledger arl 
	--won art.TransactionUid = arl.T

	RETURN		@Batch	
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_AR_getTransactionBatchNames]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_AR_getTransactionBatchNames](@transactionUid uniqueidentifier) RETURNS VARCHAR(max) AS
BEGIN
	DECLARE		@Batch varchar(max);
	
	WITH cteBatches AS
	(
	  SELECT DISTINCT arl.ARBatchUid, arb.Name, arb.GLDate  
	  FROM AR_Ledger arl
			inner join ARBatch arb on arl.ArBatchUid = arb.ARBatchUid
	  WHERE arl.TransactionUid = @transactionUid
	)
	SELECT @Batch = ISNULL(@Batch + '','',  '''') + cteb.Name
	FROM cteBatches cteb
	ORDER BY cteb.GLDate

	RETURN		@Batch	
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_AR_getTransactionBatchState]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[UDF_AR_getTransactionBatchState](@transactionUid uniqueidentifier) RETURNS VARCHAR(max) AS
BEGIN
	DECLARE     @IsLocked int
	DECLARE     @IsClosed int

	SET @IsLocked=0
	SET @IsClosed=0
	
	SELECT @IsLocked = CASE WHEN arbcl.IsLocked = 1 THEN 1 ELSE @IsLocked END,
		   @IsClosed = CASE WHEN arbcl.IsClosed = 1 THEN 1 ELSE @IsClosed END
	FROM AR_Ledger arl
		INNER JOIN AR_ViewBatchClosingsLockedClosed arbcl on arl.ArBatchUid = arbcl.ARBatchUid
	WHERE arl.TransactionUid = @transactionUid 

    IF (@IsClosed=1)
		return ''Closed'';
	IF (@IsLocked=1)
		return ''Complete'';
	return ''Open''
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_AR_getTransactionBatchUids]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_AR_getTransactionBatchUids](@transactionUid uniqueidentifier) RETURNS VARCHAR(max) AS
BEGIN
	DECLARE		@Batch varchar(max);
	
	WITH cteBatches AS
	(
	  SELECT DISTINCT arl.ARBatchUid, arb.Name, arb.GLDate  
	  FROM AR_Ledger arl
			inner join ARBatch arb on arl.ArBatchUid = arb.ARBatchUid
	  WHERE arl.TransactionUid = @transactionUid
	)
	SELECT @Batch = ISNULL(@Batch + '','',  '''') + convert(varchar(100), cteb.ARBatchUid)
	FROM cteBatches cteb
	ORDER BY cteb.GLDate

	RETURN		@Batch	
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_AR_getTransactionDepositNames]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_AR_getTransactionDepositNames](@transactionUid uniqueidentifier) RETURNS VARCHAR(max) AS
BEGIN
	DECLARE		@Deposits varchar(max);
	
	WITH cteDeposits AS
	(
	  SELECT DISTINCT ld.DepositUid, d.ReferenceNumber
	  FROM AR_Ledger arl 
			inner join AR_LedgerDetail ld on arl.TransactionUid = @TransactionUid
											  and arl.LedgerUid = ld.LedgerUid
			inner join Deposit d on ld.DepositUid = d.DepositUid
	)
	SELECT @Deposits = ISNULL(@Deposits + '','',  '''') + cted.ReferenceNumber
	FROM cteDeposits cted
	ORDER BY cted.ReferenceNumber asc

	RETURN		@Deposits
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_AR_getTransactionDepositUids]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_AR_getTransactionDepositUids](@transactionUid uniqueidentifier) RETURNS VARCHAR(max) AS
BEGIN
	DECLARE		@Deposits varchar(max);
	
	WITH cteDeposits AS
	(
	  SELECT DISTINCT ld.DepositUid, d.ReferenceNumber
	  FROM AR_Ledger arl 
			inner join AR_LedgerDetail ld on arl.TransactionUid = @TransactionUid
											  and arl.LedgerUid = ld.LedgerUid
			inner join Deposit d on ld.DepositUid = d.DepositUid
	)
	SELECT @Deposits = ISNULL(@Deposits + '','',  '''') + convert(varchar(100), cted.DepositUid)
	FROM cteDeposits cted
	ORDER BY cted.ReferenceNumber asc

	RETURN		@Deposits
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_AR_getTransactionPayerCreditAndDepositNames]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[UDF_AR_getTransactionPayerCreditAndDepositNames](@transactionUid uniqueidentifier) RETURNS VARCHAR(max) AS
BEGIN
	DECLARE		@Names varchar(max);
	
	WITH ctePayerCredits AS
	(
	  SELECT DISTINCT 2 AS sortOrder, ld.PayerCreditUid, vd.WhoPaidName -- was using note - for consistancy with non transfaction viewsuperbillhistory use whopaidname
	  FROM AR_Ledger arl 
			inner join AR_LedgerDetail ld on arl.TransactionUid = @TransactionUid
											  and arl.LedgerUid = ld.LedgerUid
			inner join AR_PayerCredit apc on ld.PayerCreditUid = apc.PayerCreditUid
			inner join ViewDeposit vd on apc.DepositUid = vd.DepositUid
	),
	cteDeposits AS
	(
	  SELECT DISTINCT 1 AS sortOrder, ld.DepositUid, d.WhoPaidName -- was using reference number - for consistancy with non transfaction viewsuperbillhistory use whopaidname
	  FROM AR_Ledger arl 
			inner join AR_LedgerDetail ld on arl.TransactionUid = @TransactionUid
											  and arl.LedgerUid = ld.LedgerUid
			inner join ViewDeposit d on ld.DepositUid = d.DepositUid
	),
	cteAggregate AS
	(
		SELECT ctePC.sortOrder, ctePC.PayerCreditUid as nameUid, ctepc.WhoPaidName as Name
		FROM ctePayerCredits ctePC
		UNION ALL
		SELECT cteDep.sortOrder, cteDep.DepositUid as nameUid, cteDep.WhoPaidName as Name
		FROM cteDeposits cteDep
	)
	SELECT @Names = ISNULL(@Names + '','',  '''') + cteAgg.Name
	FROM cteAggregate cteAgg
	ORDER BY cteAgg.sortOrder ASC, cteAgg.Name ASC

	RETURN		@Names
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_AR_getTransactionPayerCreditNames]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[UDF_AR_getTransactionPayerCreditNames](@transactionUid uniqueidentifier) RETURNS VARCHAR(max) AS
BEGIN
	DECLARE		@PayerCredits varchar(max);
	
	WITH ctePayerCredits AS
	(
	  SELECT DISTINCT ld.PayerCreditUid, apc.Note
	  FROM AR_Ledger arl 
			inner join AR_LedgerDetail ld on arl.TransactionUid = @TransactionUid
											  and arl.LedgerUid = ld.LedgerUid
			inner join AR_PayerCredit apc on ld.PayerCreditUid = apc.PayerCreditUid
	)
	SELECT @PayerCredits = ISNULL(@PayerCredits + '','',  '''') + ctepc.Note
	FROM ctePayerCredits ctepc
	ORDER BY ctepc.Note asc

	RETURN		@PayerCredits
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getFormatVariableValueByUID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_getFormatVariableValueByUID] 
(
	@exportFormatGUID UNIQUEIDENTIFIER,
	@iProvider VARCHAR(50) = NULL,
	@serviceSiteUid VARCHAR(50) = NULL, 
	@FinancialCenterUid  VARCHAR(50) = NULL
)
RETURNS VARCHAR(255)
AS
BEGIN
	DECLARE @retVal VARCHAR(255)

	SET @iProvider = ISNULL(@iProvider,''00000000-0000-0000-0000-000000000000'')
	SET @serviceSiteUid = ISNULL(@serviceSiteUid, ''00000000-0000-0000-0000-000000000000'')
	SET @FinancialCenterUid = ISNULL(@FinancialCenterUid,''14B99C94-EDAC-47BD-97B9-CF421AC16018'')

	SELECT @retVal = ISNULL(eClaimFormatValue.value, '''')	
	FROM ListClaimFormatValueType eListClaimFormatValueType
			LEFT JOIN ClaimFormatValue eClaimFormatValue ON	eClaimFormatValue.ClaimFormatValueTypeUid = eListClaimFormatValueType.ClaimFormatValueTypeUid AND
						((eClaimFormatValue.ProviderUid IS NOT NULL AND CONVERT(VARCHAR(50),eClaimFormatValue.ProviderUid) = @iProvider )OR (eClaimFormatValue.ProviderUid IS NULL AND @iProvider = ''00000000-0000-0000-0000-000000000000'') OR (eClaimFormatValue.ProviderUid IS NULL)) AND
						((eClaimFormatValue.ServiceSiteUid IS NOT NULL AND CONVERT(VARCHAR(50),eClaimFormatValue.ServiceSiteUid) = @serviceSiteUid) OR (eClaimFormatValue.ServiceSiteUid IS NULL AND @serviceSiteUid = ''00000000-0000-0000-0000-000000000000'') OR (eClaimFormatValue.ServiceSiteUid IS NULL)) AND
						((eClaimFormatValue.FinancialCenterUid IS NOT NULL AND CONVERT(VARCHAR(50), eClaimFormatValue.FinancialCenterUid) = @FinancialCenterUid) OR (eClaimFormatValue.FinancialCenterUid IS NULL AND @FinancialCenterUid = ''14B99C94-EDAC-47BD-97B9-CF421AC16018'') OR (eClaimFormatValue.FinancialCenterUid IS NULL))
	WHERE
		eListClaimFormatValueType.ClaimFormatValueTypeUid = @exportFormatGUID 
	ORDER BY ServiceSiteUid, ProviderUid, FinancialCenterUid

	RETURN(@retVal)
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getFormatVaribleValue]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- DSW 06/11/2014 29051	Modified to allow FixedValue to override ClaimFormat value.  Added Box 29 Type.
-- DSW 01/30/2015 35138 if Box 29 allow claimformat.fixedValue to be priority otherwise use claimformat.value
-- DSW 05/06/2015 35186 if Box 29 allow claimformat.fixedValue to be priority otherwise use claimformat.value
-- DSW 10/25/2016 51952 Add ''Excise Tax Code'' ( added 2-20 )

CREATE FUNCTION [dbo].[UDF_getFormatVaribleValue]
(	@exportFormatType INT,
	@exportFormatGUID UNIQUEIDENTIFIER,
	@exportFormatOptionType INT,
	@iProvider VARCHAR(50) = NULL,
	@renderer VARCHAR(50) = NULL,
	@serviceSiteUid VARCHAR(50) = NULL, --INT = NULL,
	@refUUID UNIQUEIDENTIFIER = NULL,
	@FinancialCenterUid  VARCHAR(50) = NULL
)
RETURNS VARCHAR(255)
AS
BEGIN
	DECLARE @retVal VARCHAR(255)
	DECLARE @FormatOptionTypeName VARCHAR(50)  

	SET @iProvider = ISNULL(@iProvider,''00000000-0000-0000-0000-000000000000'')
	SET @renderer = ISNULL(@renderer,''00000000-0000-0000-0000-000000000000'')
	SET @serviceSiteUid = ISNULL(@serviceSiteUid, ''00000000-0000-0000-0000-000000000000'')
	SET @refUUID = ISNULL(@refUUID,''00000000-0000-0000-0000-000000000000'')
	SET @FinancialCenterUid = ISNULL(@FinancialCenterUid,''14B99C94-EDAC-47BD-97B9-CF421AC16018'')

	IF @exportFormatType = 2 OR @exportFormatType = 3
	BEGIN
		IF @exportFormatType = 2
		BEGIN
			IF @exportFormatOptionType = 0 
				SET @FormatOptionTypeName = ''Rendering Provider ID''
			IF @exportFormatOptionType = 1 
				SET @FormatOptionTypeName = ''Rendering Provider ID Type''
			IF @exportFormatOptionType = 2 
				SET @FormatOptionTypeName = ''Practice/Group ID''
			IF @exportFormatOptionType = 3 
				SET @FormatOptionTypeName = ''Practice/Group ID Type''
			IF @exportFormatOptionType = 4 
				SET @FormatOptionTypeName = ''Referring Provider ID''
			IF @exportFormatOptionType = 5 
				SET @FormatOptionTypeName = ''Referring Provider ID Type''
			IF @exportFormatOptionType = 6 
				SET @FormatOptionTypeName = ''Facility ID''
			IF @exportFormatOptionType = 7 
				SET @FormatOptionTypeName = ''Facility ID Type''
			IF @exportFormatOptionType = 8
				SET @FormatOptionTypeName = ''Submitter ID''
			IF @exportFormatOptionType = 9 
				SET @FormatOptionTypeName = ''File as Group or Individual''
            IF @exportFormatOptionType = 10       -- Added for Defect # 11482
				SET @FormatOptionTypeName = ''CLIA''
            IF @exportFormatOptionType = 11       -- Added for Defect # 12625
				SET @FormatOptionTypeName = ''Mammography Cert''
			IF @exportFormatOptionType = 12			--CYS SC Added for SuoerBill UB
				SET @FormatOptionTypeName = ''Attending Physician ID''
			IF @exportFormatOptionType = 13 
				SET @FormatOptionTypeName = ''Attending Physician ID Type''
			IF @exportFormatOptionType = 14 
				SET @FormatOptionTypeName = ''Operating Physician ID''
			IF @exportFormatOptionType = 15 
				SET @FormatOptionTypeName = ''Operating Physician ID Type''
			IF @exportFormatOptionType = 16 
				SET @FormatOptionTypeName = ''Supervising Physician ID''
			IF @exportFormatOptionType = 17 
				SET @FormatOptionTypeName = ''Supervising Physician ID Type''
			IF @exportFormatOptionType = 18 
				SET @FormatOptionTypeName = ''Payer ID Type - Additional''
			IF @exportFormatOptionType = 19 
				SET @FormatOptionTypeName = ''Payer ID - Additional''
			IF @exportFormatOptionType = 20
				SET @FormatOptionTypeName = ''Excise Tax Code'' -- Dev-Assist 51952
		END
		ELSE
		IF @exportFormatType = 3 -- Paper CMS-1500, Paper CMS-1500 5010
		BEGIN
			IF @exportFormatOptionType = 0 
				SET @FormatOptionTypeName = ''BOX 1''
			IF @exportFormatOptionType = 1 
				SET @FormatOptionTypeName = ''BOX 24K''
			IF @exportFormatOptionType = 2 
				SET @FormatOptionTypeName = ''BOX 33 GRP''
			IF @exportFormatOptionType = 3 
				SET @FormatOptionTypeName = ''BOX 33 PIN''
			IF @exportFormatOptionType = 4 
				SET @FormatOptionTypeName = ''BOX 17A''
			IF @exportFormatOptionType = 5 
				SET @FormatOptionTypeName = ''BOX 19''
			IF @exportFormatOptionType = 6 
				SET @FormatOptionTypeName = ''BOX 25''
			IF @exportFormatOptionType = 7 
				SET @FormatOptionTypeName = ''BOX 25 type''
			IF @exportFormatOptionType = 8 
				SET @FormatOptionTypeName = ''Facility ID''
			IF @exportFormatOptionType = 9 
				SET @FormatOptionTypeName = ''BOX 32b Type''
			IF @exportFormatOptionType = 10 
				SET @FormatOptionTypeName = ''BOX 17a Type''
			IF @exportFormatOptionType = 11 
				SET @FormatOptionTypeName = ''BOX 33GRP Type''
			IF @exportFormatOptionType = 12 
				SET @FormatOptionTypeName = ''BOX 24J''
			IF @exportFormatOptionType = 13 
				SET @FormatOptionTypeName = ''BOX 24J Type''
			IF @exportFormatOptionType = 14 
				SET @FormatOptionTypeName = ''File as Group or Individual''
			IF @exportFormatOptionType = 15 
				SET @FormatOptionTypeName = ''BOX 23''
			IF @exportFormatOptionType = 16 
				SET @FormatOptionTypeName = ''CLIA''
            IF @exportFormatOptionType = 17       -- Added for Defect # 12625
				SET @FormatOptionTypeName = ''Mammography Cert''
			IF @exportFormatOptionType = 18   --ADDED FOR Defect #16535
                SET @FormatOptionTypeName = ''BOX 24K''  
           IF @exportFormatOptionType = 19		-- 				
				SET @FormatOptionTypeName = ''BOX 32b''		-- Bug 20681
			IF @exportFormatOptionType = 20
				Set @FormatOptionTypeName = ''Box 29 Type''	
		END
		
		--SELECT @retVal = CASE WHEN ClaimFormatOption.ClaimFormatValueTypeUid IS NULL THEN  ISNULL(ClaimFormatOption.FixedValue, '''') 
		--					  ELSE ISNULL(ClaimFormatValue.value,'''')
		--			     END
		SELECT @retVal = 
		    CASE WHEN @FormatOptionTypeName =  ''Box 29 Type'' THEN COALESCE( NULLIF(ClaimFormatOption.FixedValue, ''''), NULLIF(ClaimFormatValue.value, ''''), '''')
			                                                 ELSE COALESCE( NULLIF(ClaimFormatValue.value, ''''), NULLIF(ClaimFormatOption.FixedValue, ''''), '''') END
		FROM ClaimFormatOption
			LEFT JOIN ClaimFormatValue ON ClaimFormatValue.ClaimFormatValueTypeUid =  ClaimFormatOption.ClaimFormatValueTypeUid
				AND ((ClaimFormatValue.ProviderUid IS NOT NULL AND CONVERT(VARCHAR(50), ClaimFormatValue.ProviderUid) = @iProvider )OR (ClaimFormatValue.ProviderUid IS NULL AND @iProvider = ''00000000-0000-0000-0000-000000000000'') OR (ClaimFormatValue.ProviderUid IS NULL))
				AND ((ClaimFormatValue.ServiceSiteUid IS NOT NULL AND CONVERT(VARCHAR(50), ClaimFormatValue.ServiceSiteUid) = @serviceSiteUid) OR (ClaimFormatValue.ServiceSiteUid IS NULL AND @serviceSiteUid = ''00000000-0000-0000-0000-000000000000'') OR (ClaimFormatValue.ServiceSiteUid IS NULL ))				
				AND ((ClaimFormatValue.FinancialCenterUid IS NOT NULL AND CONVERT(VARCHAR(50), ClaimFormatValue.FinancialCenterUid) = @FinancialCenterUid) OR (ClaimFormatValue.FinancialCenterUid IS NULL AND @FinancialCenterUid = ''14B99C94-EDAC-47BD-97B9-CF421AC16018'') OR (ClaimFormatValue.FinancialCenterUid IS NULL ))
			LEFT JOIN ListClaimFormatOptionType ON ListClaimFormatOptionType.ClaimFormatOptionTypeUid = ClaimFormatOption.ClaimFormatOptionTypeUid
			WHERE ListClaimFormatOptionType.Name LIKE @FormatOptionTypeName
					AND ClaimFormatOption.ClaimFormatUid = @exportFormatGUID
			ORDER BY ServiceSiteUid, ProviderUid, FinancialCenterUid -- per bug 8968 added FinancialCenterUid to sort order
	END
	ELSE		/* @exportFormatType = 0 */
	BEGIN
		--SELECT @retVal = ISNULL(eClaimFormatValue.value, '''')	
		--FROM ListClaimFormatValueType eListClaimFormatValueType
		--		LEFT JOIN ClaimFormatValue eClaimFormatValue ON	eClaimFormatValue.ClaimFormatValueTypeUid = eListClaimFormatValueType.ClaimFormatValueTypeUid AND
		--					((eClaimFormatValue.ProviderUid IS NOT NULL AND CONVERT(VARCHAR(50),eClaimFormatValue.ProviderUid) = @iProvider )OR (eClaimFormatValue.ProviderUid IS NULL AND @iProvider = ''00000000-0000-0000-0000-000000000000'') OR (eClaimFormatValue.ProviderUid IS NULL)) AND
		--					((eClaimFormatValue.ServiceSiteUid IS NOT NULL AND CONVERT(VARCHAR(50),eClaimFormatValue.ServiceSiteUid) = @serviceSiteUid) OR (eClaimFormatValue.ServiceSiteUid IS NULL AND @serviceSiteUid = ''00000000-0000-0000-0000-000000000000'') OR (eClaimFormatValue.ServiceSiteUid IS NULL)) AND
		--					((eClaimFormatValue.FinancialCenterUid IS NOT NULL AND CONVERT(VARCHAR(50), eClaimFormatValue.FinancialCenterUid) = @FinancialCenterUid) OR (eClaimFormatValue.FinancialCenterUid IS NULL AND @FinancialCenterUid = ''14B99C94-EDAC-47BD-97B9-CF421AC16018'') OR (eClaimFormatValue.FinancialCenterUid IS NULL))
		--WHERE
		--	eListClaimFormatValueType.ClaimFormatValueTypeUid = @exportFormatGUID --and
		--ORDER BY ServiceSiteUid, ProviderUid, FinancialCenterUid
		select @retVal = dbo.UDF_getFormatVariableValueByUid(@exportFormatGuid, @iProvider, @serviceSiteUid, @FinancialCenterUid)
	END

	RETURN(@retVal)

END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_CheckFor1000A]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[UDF_CheckFor1000A]
(	
	@ClaimBatchUId UNIQUEIDENTIFIER
)
RETURNS VARCHAR(255)
AS
BEGIN

	DECLARE CurClaimFormats CURSOR FOR
		select CASE IP.UseCarrierElectronicClaimFormat 
				WHEN 1 THEN IC.ElectronicClaimFormatUId
				ELSE IP.ElectronicClaimFormatUId END as ClaimFormatUid,
				sba.FinancialCenterUid 
		from ClaimBatch cb
				inner join ClaimBatchDetail cbd on cb.ClaimBatchUid = cbd.ClaimBatchUid
				inner join Superbill sb on cbd.SuperbillUid = sb.SuperbillUid
				inner join SuperbillAggregate sba on sb.SuperbillUid = sba.SuperbillUid -- Need current insurance liability owner
				inner join AccountPeriod ap on sb.AccountUid = ap.AccountUid
												AND (ap.EffectiveDate IS NULL OR (ap.EffectiveDate <= sb.ServiceDateStart) )
												AND (ap.ExpirationDate IS NULL OR (ap.ExpirationDate >= sb.ServiceDateStart) )
				inner join AccountInsurance ai on ap.AccountPeriodUid = ai.AccountPeriodUid
													and ai.DisplayOrder = 
															coalesce( sba.CurrentCarrier, sb.CurrentCarrierOverride, 1 ) 
															-- Order of preference
															-- 1) Current Carrier from aggregate
															-- 2) Superbill liability owner flag
															-- 3) Primary ( last resort )
				inner join PersonInsurancePlan pip on ai.PersonInsurancePlanUid = pip.PersonInsurancePlanUid
				inner join InsurancePlan ip on pip.InsurancePlanUid = ip.InsurancePlanUid
				inner join InsuranceCarrier ic on ip.InsuranceCarrierUid = ic.CorporationUid
		where cb.ClaimBatchUid = @ClaimBatchUId
				
	DECLARE @ClaimFormatUId uniqueidentifier 
	DECLARE @financialCenterUid uniqueidentifier
	DECLARE @RetValue VARCHAR(255)

	OPEN CurClaimFormats
	FETCH NEXT FROM CurClaimFormats INTO @ClaimFormatUId, @financialCenterUid

	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @RetValue=''''
		SET @RetValue = dbo.UDF_getFormatVaribleValue (2,@ClaimFormatUId,8,NULL,NULL,NULL,NULL,@financialCenterUid)
		IF NOT @RetValue=''''
		BEGIN
			CLOSE CurClaimFormats
			DEALLOCATE CurClaimFormats

			RETURN(@RetValue)
		END	
		FETCH NEXT FROM CurClaimFormats INTO @ClaimFormatUId, @financialCenterUid
	END
	CLOSE CurClaimFormats
	DEALLOCATE CurClaimFormats

	RETURN(@RetValue)
END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_CQMTestPatient]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_CQMTestPatient] (@PatientUid UNIQUEIDENTIFIER)
RETURNS BIT
AS
BEGIN
	DECLARE @PatientTypeTest    UNIQUEIDENTIFIER = ''77A41E18-5554-4874-9454-54DC3D7A33A0''
		,@TestPat BIT = 0

	IF EXISTS(
		SELECT TOP 1 *
		FROM RelPatientStatus rps WITH(NOLOCK) 
		WHERE rps.PatientUid=@PatientUid 
			AND rps.PatientStatusUid = @PatientTypeTest
	)
	SET @TestPat = 1

	RETURN @TestPat
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_FormatPhoneNumberToUSDomestic]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[UDF_FormatPhoneNumberToUSDomestic](@phoneNumber VARCHAR(25))
RETURNS VARCHAR(25)
BEGIN


    DECLARE @retVal VARCHAR(25)
	SET @retVal = REPLACE( @phoneNumber, '' '', '''');  -- remove any space
	SET @retVal = REPLACE( @retVal, ''-'', '''')  -- remove any dash
	SET @retVal = REPLACE( @retVal, ''('', '''')  -- remove any left paren
	SET @retVal = REPLACE( @retVal, '')'', '''')  -- remove any right paren

	IF ( LEFT(@retVal,2) = ''+1'' )
	  SET @retVal = RIGHT(@retVal, 10);
	ELSE SET @retVal = @phoneNumber ;


	set @retVal =	''('' +
	 				SUBSTRING(@retVal, 1, 3) + 
					'')'' + 
 					SUBSTRING(@retVal, 4, 3) + ''-'' + 
 					SUBSTRING(@retVal, 7, 5)

 	RETURN @retVal


END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getAge]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_getAge]
(
	 @BirthDate DATETIME,
	 @ToDate DATETIME
) 
RETURNS VARCHAR(50)
AS
BEGIN
	DECLARE @Age VARCHAR(50)
	DECLARE @Year INT 
	DECLARE @Month INT 
	DECLARE @Day INT 
	DECLARE @TempDate DATETIME  
	DECLARE @dates INT   
	
	SET @Year=0
	SET @Month=0
	SET @Day=0
	
	DECLARE @Ageyear VARCHAR(50)
	DECLARE @Agemonth VARCHAR(50)
	DECLARE @Ageday VARCHAR(50)

	DECLARE @agevalue INT
	

	
	SET @year=( CASE 
					WHEN DATEADD(YEAR, DATEDIFF(YEAR, @BirthDate , @ToDate),@BirthDate)  > @ToDate

					THEN DATEDIFF(YEAR, @BirthDate , @ToDate) - 1

					ELSE DATEDIFF(YEAR, @BirthDate , @ToDate) END
				)	
	
	
	SET @BirthDate=DATEADD(YEAR,@year,@BirthDate)
	
	SET @Month=( 
					CASE 
					WHEN DATEADD(MONTH, DATEDIFF(MONTH, @BirthDate , @ToDate),@BirthDate)  > @ToDate

					THEN DATEDIFF(MONTH, @BirthDate , @ToDate) - 1

					ELSE DATEDIFF(MONTH, @BirthDate , @ToDate) END
				)	
	
	SET @BirthDate=DATEADD(MONTH,@Month,@BirthDate)

	SET @dates=DATEDIFF(DAY,@BirthDate,@ToDate)


	-- Years
	IF @year > 1
	BEGIN
		SET @Ageyear = CAST(@year AS VARCHAR(5))  +'' Years ''
	END
	
	IF @year = 1
	BEGIN
		SET @Ageyear = CAST(@year AS VARCHAR(5))  +'' Year ''
	END
	
	IF @year <=0
	BEGIN
		SET @Ageyear = ''''
	END


	-- Months
	IF @Month > 1
	BEGIN
		SET @Agemonth = CAST(@Month AS VARCHAR(5))  +'' Months ''
	END
	IF @Month = 1
	BEGIN
		SET @Agemonth = CAST(@Month AS VARCHAR(5))  +'' Month ''
	END
	IF @Month <=0 
	BEGIN
		SET @Agemonth = ''''
	END

	-- Days
	IF @dates > 1
	BEGIN
		SET @Ageday = CAST(@dates AS VARCHAR(5))  +'' Days ''
	END
	IF @dates = 1
	BEGIN
		SET @Ageday = CAST(@dates AS VARCHAR(5))  +'' Day ''
	END
	IF @dates <=0
	BEGIN
		SET @Ageday = ''''
	END

	SET @Age = @Ageyear + @Agemonth + @Ageday

			 
	RETURN @Age
	
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getAgeRange]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_getAgeRange]
(	
	@AgeRange VARCHAR(200)
)
RETURNS  VARCHAR(100)

AS
BEGIN
    DECLARE @Age Int 
    DECLARE @Cnt Int
	DECLARE @ID SMALLINT
    DECLARE @Ages Varchar(100)

	SET @Ages=''''
    Set @AgeRange=Replace(@AgeRange,''-'','','')
	Set @AgeRange=Replace(@AgeRange,'';'','','')
    Set @AgeRange=Replace(@AgeRange,''+'','''')

    DECLARE @ageRangeTable TABLE  
    (  
  	  ElementID 	SMALLINT,
	  AgeRange  	int
    )
    INSERT INTO @ageRangeTable
    SELECT * FROM Split(@AgeRange,'','')

       
    -------------- AgeRange Like ''0-5;5-10'' converts to 0,5,5,10 and below returns 0,5,10 

    Declare Age_Cur Cursor For
      Select AgeRange, count('''') as Cnt from @ageRangeTable group by AgeRange
    OPEN Age_Cur 
	FETCH NEXT FROM Age_Cur Into @age, @cnt
    WHILE @@FETCH_STATUS = 0
    BEGIN
     while( @Cnt >= 2 ) 
        BEGIN
        SELECT TOP 1 @ID=ElementID FROM  @ageRangeTable WHERE AgeRange=@Age 
        DELETE FROM  @ageRangeTable WHERE ElementID =@ID 
        SET @cnt=@cnt-1
        END 
        FETCH NEXT FROM Age_Cur Into @age, @cnt	
	END	
	CLOSE Age_Cur
	DEALLOCATE Age_Cur
 
  ------  AgeRange Like  ''0-5;6-10'' converts to 0,5,6,10 and below returns 0,5,10 
   
   Declare Age_Cur Cursor For
      Select AgeRange from @ageRangeTable group by AgeRange
    OPEN Age_Cur 
	FETCH NEXT FROM Age_Cur Into @age
    WHILE @@FETCH_STATUS = 0
    BEGIN
       Declare Age_Cur1 Cursor For
          Select AgeRange from @ageRangeTable group by AgeRange
       OPEN Age_Cur1 
	   FETCH NEXT FROM Age_Cur1 Into @cnt
       WHILE @@FETCH_STATUS = 0
       BEGIN
       IF(@age-@Cnt=-1)
         BEGIN
          SELECT  @ID=ElementID FROM  @ageRangeTable WHERE AgeRange=@cnt
          DELETE FROM  @ageRangeTable WHERE ElementID =@ID 
         END 
        FETCH NEXT FROM Age_Cur1 Into @cnt
       END
       CLOSE Age_Cur1
	   DEALLOCATE Age_Cur1 
	   FETCH NEXT FROM Age_Cur Into @age
	END	
	CLOSE Age_Cur
	DEALLOCATE Age_Cur 
   

--------- Return As ''5,10,15''

	DECLARE Age_Cur2 Cursor For
       Select AgeRange from @ageRangeTable
    OPEN Age_Cur2
	FETCH NEXT FROM Age_Cur2 Into @age
    WHILE @@FETCH_STATUS = 0
    BEGIN
        IF(@age = 0)
         BEGIN
           SELECT  @ID=ElementID FROM  @ageRangeTable WHERE AgeRange=@age
           DELETE FROM @ageRangeTable Where ElementID=@ID
         END
         ELSE
         BEGIN
           SET @Ages=@Ages+Convert(Varchar,@age)+'',''
         END
        FETCH NEXT FROM Age_Cur2 Into @age
	END	
	CLOSE Age_Cur2
	DEALLOCATE Age_Cur2

	IF(@Ages='''')
	BEGIN
		SET @Ages=0
	END
	ELSE
	BEGIN
      SET @Ages=Substring(@Ages,1,len(@Ages)-1)
	END
    RETURN @Ages
   
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getDate_MMDDYY]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



-- the function returns date in MMDDYY format
CREATE    FUNCTION [dbo].[UDF_getDate_MMDDYY]
(
	@pDate DATETIME
)
RETURNS VARCHAR(6)
AS
BEGIN
	RETURN dbo.Date_MMDDYY(@pDate)
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getApproval_MedicaidPaperClaim]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


  
-- the function returns 1 for approved SuperBill and 0 for non-approved SuperBills  
CREATE  FUNCTION [dbo].[UDF_getApproval_MedicaidPaperClaim]  
(  
 @SuperbillUID UNIQUEIDENTIFIER,  
 @insType INT  
)  
RETURNS INT  
AS  
BEGIN  
  
 DECLARE @ProviderFName varchar(25)  
 DECLARE @ProviderLName varchar(25)  
 DECLARE @Address1 varchar(50)  
 DECLARE @Address2 varchar(50)  
 DECLARE @Address3 varchar(50)  
 DECLARE @Address4 varchar(50)  
 DECLARE @Zip1 varchar(50)  
 DECLARE @Zip2 varchar(50)  
 DECLARE @ProviderID varchar(255)  
 DECLARE @PatientLName varchar(25)  
 DECLARE @PatientFName varchar(25)  
 DECLARE @BillingNumber varchar(20)  
 DECLARE @PrimaryDiagnosisCode varchar(10)  
 DECLARE @BillingDate varchar(6)  
 DECLARE @MedicareApprovedAmount money  
 DECLARE @MedicarePaidDate varchar(6)  
 DECLARE @PrimaryPayer varchar(25)  
 DECLARE @OtherSource varchar(1)  
  
   

 SET @ProviderFName ='''' 
 SET @ProviderLName =''''  
 SET @Address1 ='''' 
 SET @Address2 =''''  
 SET @Address3 =''''
 SET @Address4 =''''
 SET @Zip1 =''''
 SET @Zip2 =''''  
 SET @ProviderID =''''  
 SET @PatientLName ='''' 
 SET @PatientFName =''''
 SET @BillingNumber ='''' 
 SET @PrimaryDiagnosisCode =''''  
 SET @BillingDate =''''
 SET @MedicareApprovedAmount ='''' 
 SET @MedicarePaidDate =''''  
 SET @PrimaryPayer =''''  
 SET @OtherSource =''''  
  
 SELECT   
--Item-1 Provider Name, address, zip  
 @ProviderFName = COALESCE(p2.FirstName,''''), @ProviderLName = COALESCE(p2.LastName,''''),  
 @Address1 = COALESCE(p2.Address1.value(''(/Address/Address1)[1]'', ''VARCHAR(100)''),''''), @Address2 = COALESCE(p2.Address1.value(''(/Address/Address2)[1]'', ''VARCHAR(100)''),''''),  
 @Address3 = COALESCE(p2.Address2.value(''(/Address/Address1)[1]'', ''VARCHAR(100)''),''''), @Address4 = COALESCE(p2.Address2.value(''(/Address/Address2)[1]'', ''VARCHAR(100)''),''''),  
 @Zip1 = COALESCE(p2.Address1.value(''(/Address/Zip)[1]'', ''VARCHAR(100)''),''''), @Zip2 = COALESCE(p2.Address2.value(''(/Address/Zip)[1]'', ''VARCHAR(100)''),''''),  
--Item-2 ProviderNumber  
 @ProviderID = COALESCE(dbo.UDF_getFormatVaribleValue(3,(CASE WHEN IP.UseCarrierPaperClaimFormat = 1 THEN IC.PaperClaimFormatUid      ELSE IP.PaperClaimFormatUid END), 12,VSFD.ClaimingProviderUID,null,VSFD.ServiceSiteUID,null,VSFD.FinancialCenterUID),''''),  
--Item-6 PatientLastName  
 @PatientLName = COALESCE(p1.LastName,''''),   
--Item-7 PatientFirstName  
 @PatientFName = COALESCE(p1.FirstName,''''),  
--Item-9 BillingNumber  
 @BillingNumber = COALESCE(pip.PlanMemberID,''''),  
--Item-10 PrimaryDiagnosisCode  
 @PrimaryDiagnosisCode = COALESCE(sd1.Code9,''''),  
--Item-15 OtherSource  
-- @OtherSource = [dbo].[UDF_getOtherSourceCode] (COALESCE(s.SuperbillUID,s.SuperbillUID)),  
--Item-17 BillingDate  
 @BillingDate = [dbo].[UDF_getDate_MMDDYY] (COALESCE(s.ServiceDateStart,'''')) 
--Item-18 MedicareApprovedAmount  
 --@MedicareApprovedAmount = CASE WHEN (@insType = 2 AND ip1.Name LIKE ''%MEDICARE%'') THEN [dbo].[UDF_getPaidAmount] (COALESCE(s.SuperbillUID,s.SuperbillUID),1) END,  
--Item-25 MedicarePaidDate  
-- @MedicarePaidDate = CASE WHEN COALESCE(CONVERT(VARCHAR(100),s.SuperBillUID),'''') <> '''' THEN  
--    [dbo].[UDF_getMedicarePaidDate] (s.SuperBillUID) ELSE '''' END,  
--  
 --@PrimaryPayer = ip1.Name  
  
  
 FROM Superbill s  
 INNER JOIN ViewSuperbillFinancialDetails VSFD ON s.SuperbillUid = VSFD.SuperbillUid
 INNER JOIN Person p1 ON s.PatientUID = p1.PersonUID  
 INNER JOIN Provider pr ON (pr.PersonUID = VSFD.ClaimingProviderUID AND pr.IsBillingProvider = 1) --***check the condition  
 INNER JOIN Person p2  ON pr.PersonUID = p2.PersonUID  
 INNER JOIN Patient pa ON p1.PersonUID = pa.PersonUID  
 INNER JOIN PersonInsurancePlan pip ON p1.PersonUID = pip.PersonUID  
 INNER JOIN InsurancePlan ip ON pip.InsurancePlanUID = ip.InsurancePlanUID AND ip.Inactive = 0 --AND ip.Name LIKE ''%Medicaid%''   
 LEFT JOIN ListAccountType latIP ON latIP.AccountTypeUid = ip.AccountTypeUid AND latIP.ExternalId = CASE WHEN ip.UseInsuranceCarrierAccountType = 0 THEN ''MC'' END  -- ''MC'' for MEDICAID 
 INNER JOIN InsuranceCarrier ic ON ip.InsuranceCarrierUID = ic.CorporationUID  
 LEFT JOIN ListAccountType latIC ON latIC.AccountTypeUid = ic.AccountTypeUid AND latIC.ExternalId = CASE WHEN ip.UseInsuranceCarrierAccountType = 1 then ''MC'' END  
 --INNER JOIN Corporation co ON (ic.CorporationUID = co.CorporationUID AND co.Name LIKE ''%medicaid%'')  
 INNER JOIN AccountInsurance ai ON pip.PersonInsurancePlanUID = ai.PersonInsurancePlanUID AND ai.DisplayOrder = @insType  
 --LEFT JOIN ListAccountType lat ON ip.AccountTypeUID = lat.AccountTypeUID AND (lat.Name like ''%Medicaid%'') -- OR ip.Name LIKE ''%Medicaid%'')  
    --commented above part as ip.AccountTypeUID can be null, bt ip.Name can''t be null  
 LEFT JOIN SuperbillDiagnosis sd1 ON (s.SuperBillUID = sd1.SuperBillUID AND sd1.DisplayOrder = 1) 
 LEFT JOIN SuperbillDiagnosis sd2 ON (s.SuperBillUID = sd2.SuperBillUID AND sd1.DisplayOrder = 2)  
 JOIN AccountPeriod on ai.AccountPeriodUid=AccountPeriod.AccountPeriodUid 
	AND ((AccountPeriod.effectiveDate IS NOT NULL AND AccountPeriod.ExpirationDate IS NULL AND  AccountPeriod.effectiveDate  <=  S.servicedatestart )
				  OR (AccountPeriod.effectiveDate IS NULL AND AccountPeriod.ExpirationDate IS NOT NULL AND  AccountPeriod.expirationDate  >=  S.servicedatestart ) 
				  OR (AccountPeriod.effectiveDate IS NOT NULL AND AccountPeriod.ExpirationDate IS NOT NULL AND  AccountPeriod.effectiveDate  <=  S.servicedatestart  AND  AccountPeriod.expirationDate  >=  S.servicedatestart ) 
				  OR (AccountPeriod.effectiveDate IS NULL AND AccountPeriod.ExpirationDate IS NULL))
  
 --LEFT JOIN PersonInsurancePlan pip1 ON (p1.PersonUID = pip1.PersonUID)   
 --LEFT JOIN InsurancePlan ip1 ON (ip1.InsurancePlanUID = pip1.InsurancePlanUID)   
 --LEFT JOIN InsuranceCarrier ic1 ON (ic1.CorporationUID = ip1.InsuranceCarrierUID)   
 --LEFT JOIN AccountInsurance ai1 ON (pip1.PersonInsurancePlanUID = ai1.PersonInsurancePlanUID AND ai1.DisplayOrder = 1)   
 ----LEFT JOIN ListAccountType lat1 ON (ip1.AccountTypeUID = lat1.AccountTypeUID)     
   
 --LEFT JOIN ListRelatedCause lrc on (s.RelatedCauseUID = lrc.RelatedCauseUID and lrc.Name like ''%accident%'')  
   
 ----INNER JOIN ClaimBatchDetail c ON (c.SuperBillUID = s.SuperBillUID AND s.ClaimPaper = 1)  
 WHERE s.SuperBillUID = @SuperBillUID AND s.ClaimPaper = 1  -- AND c.ClaimBatchUID = @ClaimBatchUID   
 AND COALESCE(CAST(ip.AccountTypeUid AS VARCHAR(50)), CAST(ic.AccountTypeUid AS VARCHAR(50)), '''') <> ''''  
   
 DECLARE @RETURN INT  
 SET @RETURN = 1  
  
 SET @RETURN =   
  CASE WHEN @ProviderFName = '''' OR @ProviderLName = '''' THEN 0  
  WHEN ((@Address1 = '''' AND @Zip1 = '''') AND (@Address2 = '''' AND @Zip1 = '''')) AND ((@Address3 = '''' AND @Zip2 = '''') AND (@Address4 = '''' AND @Zip2 = '''')) THEN  0  
  WHEN @ProviderID = '''' THEN 0  
  WHEN @PatientLName = '''' THEN 0  
  WHEN @PatientFName = '''' THEN 0  
  WHEN @BillingNumber = '''' THEN 0  
  WHEN @PrimaryDiagnosisCode = '''' THEN 0  
  WHEN @BillingDate = '''' THEN 0  
  --WHEN @PrimaryPayer LIKE ''%MEDICARE%'' AND @insType = 2 AND @MedicareApprovedAmount = 0 THEN 0 [It can be zero when payment is not done. so how to check for missing value?]  
  --WHEN @PrimaryPayer LIKE ''%MEDICARE%'' AND @insType = 2 AND @MedicarePaidDate = '''' THEN 0  
 -- WHEN @PrimaryPayer NOT LIKE ''%MEDICARE%'' AND @insType = 2 AND @OtherSource = '''' THEN 0  
  ELSE 1  
     
  END  
  
--check whether there is a CPT of zero dollar amoun applied to  
 IF @RETURN = 1  
 BEGIN    
  DECLARE @ProcedureCharge MONEY    
  DECLARE CUR_Procedure CURSOR FOR  
    SELECT ProcedureCharge FROM SuperbillProcedure WHERE SuperbillUid = @SuperbillUID AND DontClaim = 0 AND Inactive = 0 ORDER BY DisplayOrder  
   OPEN CUR_Procedure  
   FETCH NEXT FROM CUR_Procedure INTO @ProcedureCharge   
   WHILE @@FETCH_STATUS = 0   
    BEGIN  
     IF @ProcedureCharge = 0.00  
     BEGIN  
SET @RETURN = 0  
      BREAK  
     END      
     FETCH NEXT FROM CUR_Procedure INTO @ProcedureCharge   
    END  
   CLOSE CUR_Procedure  
   DEALLOCATE CUR_Procedure  
 END  
------  
  
 RETURN @RETURN  
END  



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getApproval_UB04PaperClaim]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



-- the function returns 1 for approved SuperBill and 0 for non-approved SuperBills
CREATE  FUNCTION [dbo].[UDF_getApproval_UB04PaperClaim]
(
	@SuperbillUID UNIQUEIDENTIFIER,
	@insType INT
)
RETURNS INT
AS
BEGIN

	DECLARE @ProviderFName varchar(25)
	DECLARE @ProviderLName varchar(25)
	DECLARE @Address1 varchar(50)
	DECLARE @Address2 varchar(50)
	DECLARE @Address3 varchar(50)
	DECLARE @Address4 varchar(50)
	DECLARE @Zip1 varchar(50)
	DECLARE @Zip2 varchar(50)
	DECLARE @ProviderID varchar(255)
	DECLARE @PatientLName varchar(25)
	DECLARE @PatientFName varchar(25)
	DECLARE @BillingNumber varchar(20)
	DECLARE @PrimaryDiagnosisCode varchar(10)
	DECLARE @BillingDate varchar(6)
	DECLARE @MedicareApprovedAmount money
	DECLARE @MedicarePaidDate varchar(6)
	DECLARE @PrimaryPayer varchar(25)
	DECLARE @OtherSource varchar(1)

	

	SELECT 
--Item-1 Provider Name, address, zip
	@ProviderFName = COALESCE(p2.FirstName,''''), @ProviderLName = COALESCE(p2.LastName,''''),
 @Address1 = COALESCE(p2.Address1.value(''(/Address/Address1)[1]'', ''VARCHAR(100)''),''''), @Address2 = COALESCE(p2.Address1.value(''(/Address/Address2)[1]'', ''VARCHAR(100)''),''''),  
 @Address3 = COALESCE(p2.Address2.value(''(/Address/Address1)[1]'', ''VARCHAR(100)''),''''), @Address4 = COALESCE(p2.Address1.value(''(/Address/Address2)[1]'', ''VARCHAR(100)''),''''),  
 @Zip1 = COALESCE(p2.Address1.value(''(/Address/Zip)[1]'', ''VARCHAR(100)''),''''), @Zip2 = COALESCE(p2.Address2.value(''(/Address/Zip)[1]'', ''VARCHAR(100)''),''''),  
--Item-2 ProviderNumber
/* CYS SC - WIll always fail since not using Box24J (parameter=''12'') on UB04 Paper Claim
@ProviderID = COALESCE(dbo.UDF_getFormatVaribleValue(3,(CASE WHEN IP.UseCarrierPaperClaimFormat = 1 THEN IC.PaperClaimFormatUid  
			ELSE IP.PaperClaimFormatUid END), 12,s.ClaimingProviderUID,null,s.ServiceSiteUID,null,s.FinancialCenterUID),''''),
*/
--Item-6 PatientLastName
	@PatientLName = COALESCE(p1.LastName,''''), 
--Item-7 PatientFirstName
	@PatientFName = COALESCE(p1.FirstName,''''),
--Item-9 BillingNumber
	@BillingNumber = COALESCE(pip.PlanMemberID,''''),
--Item-10 PrimaryDiagnosisCode
	@PrimaryDiagnosisCode = COALESCE(sd1.Code9,''''),
--Item-15 OtherSource
--	@OtherSource = [dbo].[UDF_getOtherSourceCode] (COALESCE(s.SuperbillUID,s.SuperbillUID)),
--Item-17 BillingDate
	@BillingDate = [dbo].[UDF_getDate_MMDDYY] (COALESCE(s.ServiceDateStart,'''')),
--Item-18 MedicareApprovedAmount
	--@MedicareApprovedAmount = CASE WHEN (@insType = 2 AND ip1.Name LIKE ''%MEDICARE%'') THEN [dbo].[UDF_getPaidAmount] (COALESCE(s.SuperbillUID,s.SuperbillUID),1) END,
--Item-25 MedicarePaidDate
--	@MedicarePaidDate = CASE WHEN COALESCE(CONVERT(VARCHAR(100),s.SuperBillUID),'''') <> '''' THEN
--				[dbo].[UDF_getMedicarePaidDate] (s.SuperBillUID) ELSE '''' END,
--
	@PrimaryPayer = ip1.Name


	FROM Superbill s
	INNER JOIN ViewSuperbillFinancialDetails VSFD ON s.SuperbillUid = VSFD.SuperbillUid
	INNER JOIN Person p1 ON s.PatientUID = p1.PersonUID
	INNER JOIN Provider pr ON (pr.PersonUID = VSFD.ClaimingProviderUID AND pr.IsBillingProvider = 1)	--***check the condition
	INNER JOIN Person p2  ON pr.PersonUID = p2.PersonUID
	INNER JOIN Patient pa ON p1.PersonUID = pa.PersonUID
	INNER JOIN PersonInsurancePlan pip ON p1.PersonUID = pip.PersonUID
	INNER JOIN InsurancePlan ip ON pip.InsurancePlanUID = ip.InsurancePlanUID AND ip.Inactive = 0 --AND ip.Name LIKE ''%Medicaid%'' 
	LEFT JOIN ListAccountType latIP ON latIP.AccountTypeUid = ip.AccountTypeUid AND latIP.ExternalId = CASE WHEN ip.UseInsuranceCarrierAccountType = 0 THEN ''MC'' END  -- ''MC'' for MEDICAID
	INNER JOIN InsuranceCarrier ic ON ip.InsuranceCarrierUID = ic.CorporationUID
	LEFT JOIN ListAccountType latIC ON latIC.AccountTypeUid = ic.AccountTypeUid AND latIC.ExternalId = CASE WHEN ip.UseInsuranceCarrierAccountType = 1 then ''MC'' END
	--INNER JOIN Corporation co ON (ic.CorporationUID = co.CorporationUID AND co.Name LIKE ''%medicaid%'')
	INNER JOIN AccountInsurance ai ON pip.PersonInsurancePlanUID = ai.PersonInsurancePlanUID AND ai.DisplayOrder = @insType
	--LEFT JOIN ListAccountType lat ON ip.AccountTypeUID = lat.AccountTypeUID AND (lat.Name like ''%Medicaid%'') -- OR ip.Name LIKE ''%Medicaid%'')
				--commented above part as ip.AccountTypeUID can be null, bt ip.Name can''t be null
	LEFT JOIN SuperbillDiagnosis sd1 ON (s.SuperBillUID = sd1.SuperBillUID AND sd1.DisplayOrder = 1)
	LEFT JOIN SuperbillDiagnosis sd2 ON (s.SuperBillUID = sd2.SuperBillUID AND sd1.DisplayOrder = 2)
	
	LEFT JOIN PersonInsurancePlan pip1 ON (p1.PersonUID = pip1.PersonUID) 
	LEFT JOIN InsurancePlan ip1 ON (ip1.InsurancePlanUID = pip1.InsurancePlanUID) 
	LEFT JOIN InsuranceCarrier ic1 ON (ic1.CorporationUID = ip1.InsuranceCarrierUID) 
	LEFT JOIN AccountInsurance ai1 ON (pip1.PersonInsurancePlanUID = ai1.PersonInsurancePlanUID AND ai1.DisplayOrder = 1) 
	--LEFT JOIN ListAccountType lat1 ON (ip1.AccountTypeUID = lat1.AccountTypeUID)   
	
	LEFT JOIN ListRelatedCause lrc on (s.RelatedCauseUID = lrc.RelatedCauseUID and lrc.Name like ''%accident%'')
	
	--INNER JOIN ClaimBatchDetail c ON (c.SuperBillUID = s.SuperBillUID AND s.ClaimPaper = 1)
	WHERE s.SuperBillUID = @SuperBillUID AND s.ClaimPaper = 1 	-- AND c.ClaimBatchUID = @ClaimBatchUID 
	AND COALESCE(CAST(ip.AccountTypeUid AS VARCHAR(50)), CAST(ic.AccountTypeUid AS VARCHAR(50)), '''') <> ''''
	
	DECLARE @RETURN INT
	SET @RETURN = 1

	SET @RETURN = 
		CASE WHEN @ProviderFName = '''' OR @ProviderLName = '''' THEN 0
		WHEN ((@Address1 = '''' AND @Zip1 = '''') AND (@Address2 = '''' AND @Zip1 = '''')) AND ((@Address3 = '''' AND @Zip2 = '''') AND (@Address4 = '''' AND @Zip2 = '''')) THEN  0
		--WHEN @ProviderID = '''' THEN 0
		WHEN @PatientLName = '''' THEN 0
		WHEN @PatientFName = '''' THEN 0
		WHEN @BillingNumber = '''' THEN 0
		WHEN @PrimaryDiagnosisCode = '''' THEN 0
		WHEN @BillingDate = '''' THEN 0
		--WHEN @PrimaryPayer LIKE ''%MEDICARE%'' AND @insType = 2 AND @MedicareApprovedAmount = 0 THEN 0	[It can be zero when payment is not done. so how to check for missing value?]
		--WHEN @PrimaryPayer LIKE ''%MEDICARE%'' AND @insType = 2 AND @MedicarePaidDate = '''' THEN 0
	--	WHEN @PrimaryPayer NOT LIKE ''%MEDICARE%'' AND @insType = 2 AND @OtherSource = '''' THEN 0
		ELSE 1
			
		END

--check whether there is a CPT of zero dollar amoun applied to
	IF @RETURN = 1
	BEGIN		
		DECLARE @ProcedureCharge MONEY		
		DECLARE CUR_Procedure CURSOR FOR
				SELECT ProcedureCharge FROM SuperbillProcedure WHERE SuperbillUid = @SuperbillUID AND DontClaim = 0 AND Inactive = 0 ORDER BY DisplayOrder
			OPEN CUR_Procedure
			FETCH NEXT FROM CUR_Procedure INTO @ProcedureCharge 
			WHILE @@FETCH_STATUS = 0 
				BEGIN
					IF @ProcedureCharge = 0.00
					BEGIN
						SET @RETURN = 0
						BREAK
					END				
					FETCH NEXT FROM CUR_Procedure INTO @ProcedureCharge 
				END
			CLOSE CUR_Procedure
			DEALLOCATE CUR_Procedure
	END
------

	RETURN @RETURN
END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getClaimFormatTypeValue]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_getClaimFormatTypeValue]
(	@FormatTypeUid UNIQUEIDENTIFIER,
	@ProviderUid UNIQUEIDENTIFIER = NULL,
	@FinancialCenterUid UNIQUEIDENTIFIER = NULL,
	@ServiceSiteUid UNIQUEIDENTIFIER = NULL
)
RETURNS VARCHAR(255)
AS
BEGIN
	DECLARE @retVal VARCHAR(255)
	SELECT top 1 @retVal = COALESCE(value, '''''''')
	FROM ClaimFormatValue
	WHERE ClaimFormatValueTypeUid = @FormatTypeUid
	AND ((ProviderUid IS NOT NULL AND ProviderUid = @ProviderUid) OR (ProviderUid IS NULL AND @ProviderUid is NULL) OR (ProviderUid IS NULL))
	AND ((FinancialCenterUid IS NOT NULL AND FinancialCenterUid = @FinancialCenterUid) OR (FinancialCenterUid IS NULL AND @FinancialCenterUid is NULL) OR (FinancialCenterUid IS NULL))
	AND ((ServiceSiteUid IS NOT NULL AND ServiceSiteUid = @ServiceSiteUid) OR (ServiceSiteUid IS NULL AND @ServiceSiteUid is NULL) OR (ServiceSiteUid IS NULL))
	ORDER BY FinancialCenterUid desc, ServiceSiteUid desc
	RETURN @retVal
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getCoInsuranceAmount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[UDF_getCoInsuranceAmount]       
(   
--@ReasonERACodeUid UNIQUEIDENTIFIER,    
@SuperbillUid UNIQUEIDENTIFIER,      
@InsType int    
)      
--@ReasonERACodeUid = ''F1817650-B562-4428-AB3F-0F67267FC631'' is for Deductables    
--@ReasonERACodeUid = 226B3F3A-2D51-4D21-B63B-615EA23E7871 is for Co-Insurance    
RETURNS MONEY       
AS    
BEGIN    
DECLARE @CoInsuranceAmount MONEY    
  
SELECT  
	  @CoInsuranceAmount = -1 * SUM(V.Amount)  
	FROM
		ViewPaymentEntryCredits_MedicaidPaper V
	JOIN   
		ViewERAReasonCode VRC
	ON
		VRC.ERACodeUid = V.ReasonCodeERACodeUid  
	WHERE 				
		V.SuperbillUid =@SuperbillUid
	AND
		VRC.Code =''2''
	AND
		V.LiabilityOwner = @InsType 	
	
 RETURN @CoInsuranceAmount
END    



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getCPTCode]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_getCPTCode]
(
 @SuperbillUid UNIQUEIDENTIFIER,
 @Type Bit

)
RETURNS VARCHAR(255)
AS
BEGIN
	DECLARE @retVal VARCHAR(255),
			@EM  VARCHAR(255),
			@ALL VARCHAR(255),
			@CPT VARCHAR(255),
			@ISEM Bit

	SELECT @retVal = '''', @EM = '''', @ALL = ''''

	IF @Type = 0
	BEGIN
		SELECT @retVal = @retVal + CASE WHEN LEN (@retVal) > 0 THEN '', '' ELSE '''' END + lp.Code 
		FROM ListProcedure AS lp
			INNER JOIN SuperBillProcedure AS sp ON lp.ProcedureUid = sp.ProcedureUid
		WHERE sp.SuperBillUid = @SuperbillUid
		ORDER BY sp.DisplayOrder
	END
	IF @Type = 1
	BEGIN
		SELECT @EM = @EM + CASE WHEN lp.IsEM <> 0 THEN CASE WHEN LEN (@EM) > 0 THEN '', '' ELSE '''' END + lp.Code
						   ELSE ''''
						   END,
			   @ALL = @ALL + CASE WHEN lp.IsEM = 0 THEN CASE WHEN LEN (@ALL) > 0 THEN '', '' ELSE '''' END + lp.Code
								  ELSE ''''
							 END
		FROM ListProcedure AS lp
			INNER JOIN SuperBillProcedure AS sp ON lp.ProcedureUid = sp.ProcedureUid
		WHERE sp.SuperBillUid = @SuperbillUid
		ORDER BY sp.DisplayOrder

		SET @retVal =  @EM + CASE WHEN LEN (@EM) > 0 THEN '', '' ELSE '''' END + @ALL
	END
	RETURN(@retVal)
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getDeductableAmount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_getDeductableAmount]       
(   
--@CreditTypeUid UNIQUEIDENTIFIER = NULL,    
--@ReasonERACodeUid UNIQUEIDENTIFIER,    
@SuperbillUid UNIQUEIDENTIFIER,      
@InsType int    
)      
--@ReasonERACodeUid = ''F1817650-B562-4428-AB3F-0F67267FC631'' is for Deductables    
--@ReasonERACodeUid = 226B3F3A-2D51-4D21-B63B-615EA23E7871 is for Co-Insurance    
RETURNS MONEY       
AS    
BEGIN    
DECLARE @DeductableAmount MONEY    
    
SELECT      
 @DeductableAmount = -1 * SUM(V.Amount)      
FROM
 ViewPaymentEntryCredits_MedicaidPaper V
 JOIN   
	ViewERAReasonCode VRC
	ON
		VRC.ERACodeUid = V.ReasonCodeERACodeUid 
	WHERE 				
		V.SuperbillUid =@SuperbillUid
	AND
		VRC.Code =''1''
	AND
		V.LiabilityOwner = @InsType 
		
 RETURN @DeductableAmount
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getDiagnosis]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[UDF_getDiagnosis]
(
	@SuperbillUid UNIQUEIDENTIFIER ,
	@DisplayOrder INT 
)
RETURNS VARCHAR(255)
AS
BEGIN
		DECLARE @retVal VARCHAR(255)
		SET @retVal = ''''
	
	
		Select @retVal = COALESCE(sbd.Code9, '''')  FROM Superbill d
		INNER JOIN SuperBillDiagnosis sbd ON sbd.SuperbillUid = d.SuperbillUid 
		
		WHERE d.Superbilluid = @SuperbillUid
			AND sbd.displayorder = @DisplayOrder

	RETURN(@retVal)

END














' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getFormattedName_FS]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE  FUNCTION  [dbo].[UDF_getFormattedName_FS]


(


	@sPrefix	varchar(25),


	@sFirstName	varchar(50),


	@sMiddleName	varchar(50),


	@sLastName	varchar(50),


	@sSuffix	varchar(50)


)


RETURNS varchar(100)


AS


BEGIN 


	return(


		(CASE WHEN @sPrefix is null THEN '''' ELSE @sPrefix + '' '' END) 


		+ (CASE WHEN @sLastName is null THEN '''' ELSE @sLastName + '', '' END)


		+ (CASE WHEN @sFirstName is null THEN '''' ELSE @sFirstName END)


		+ (CASE WHEN @sMiddleName is null THEN '''' ELSE '' '' +@sMiddleName END)


		+ (CASE WHEN @sSuffix is null THEN '''' ELSE '', '' + @sSuffix END)


	)





END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getFormattedName_PI]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE  FUNCTION  [dbo].[UDF_getFormattedName_PI]

(

	@sPrefix	varchar(25),

	@sFirstName	varchar(50),

	@sMiddleName	varchar(50),

	@sLastName	varchar(50),

	@sSuffix	varchar(50)

)

RETURNS varchar(100)

AS

BEGIN 

	return(

		(CASE WHEN @sPrefix is null THEN '''' ELSE @sPrefix + '' '' END) 

		+ (CASE WHEN @sLastName is null THEN '''' ELSE @sLastName + '', '' END)

		+ (CASE WHEN @sFirstName is null THEN '''' ELSE @sFirstName END)

		+ (CASE WHEN @sMiddleName is null THEN '''' ELSE '' '' +@sMiddleName END)

		+ (CASE WHEN @sSuffix is null THEN '''' ELSE '', '' + @sSuffix END)

	)



END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getFormattedName_RA]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE  FUNCTION  [dbo].[UDF_getFormattedName_RA]
(
	@sPrefix	varchar(25),
	@sFirstName	varchar(50),
	@sMiddleName	varchar(50),
	@sLastName	varchar(50),
	@sSuffix	varchar(50)
)
RETURNS varchar(100)
AS
BEGIN 
	return(
		(CASE WHEN @sPrefix is null THEN '''' ELSE @sPrefix + '' '' END) 
		+ (CASE WHEN @sLastName is null THEN '''' ELSE @sLastName + '', '' END)
		+ (CASE WHEN @sFirstName is null THEN '''' ELSE @sFirstName END)
		+ (CASE WHEN @sMiddleName is null THEN '''' ELSE '' '' +@sMiddleName END)
		+ (CASE WHEN @sSuffix is null THEN '''' ELSE '', '' + @sSuffix END)
	)

END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getFormattedName_VP]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE  FUNCTION  [dbo].[UDF_getFormattedName_VP]


(


	@sPrefix	varchar(25),


	@sFirstName	varchar(50),


	@sMiddleName	varchar(50),


	@sLastName	varchar(50),


	@sSuffix	varchar(50)


)


RETURNS varchar(100)


AS


BEGIN 


	return(


		(CASE WHEN @sPrefix is null THEN '''' ELSE @sPrefix + '' '' END) 


		+ (CASE WHEN @sLastName is null THEN '''' ELSE @sLastName + '', '' END)


		+ (CASE WHEN @sFirstName is null THEN '''' ELSE @sFirstName END)


		+ (CASE WHEN @sMiddleName is null THEN '''' ELSE '' '' +@sMiddleName END)


		+ (CASE WHEN @sSuffix is null THEN '''' ELSE '', '' + @sSuffix END)


	)





END








' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getFormattedNameChc]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION  [dbo].[UDF_getFormattedNameChc] 
(
    @sPrefix    varchar(25),
    @sFirstName varchar(50),
    @sMiddleName    varchar(50),
    @sLastName  varchar(50),
    @sSuffix    varchar(50)
)
RETURNS varchar(100)
AS
BEGIN 
    /* Example:
    select top 10 
    dbo.UDF_getFormattedNameChc(
        p.Prefix,
        p.FirstName,
        p.MiddleName,
        p.LastName,
        p.Suffix)
    from Person p
    */

    return(
        (CASE WHEN @sPrefix is null THEN '''' ELSE @sPrefix + '' '' END) 
        + (CASE WHEN @sLastName is null THEN '''' ELSE @sLastName + '', '' END)
        + (CASE WHEN @sFirstName is null THEN '''' ELSE @sFirstName END)
        + (CASE WHEN @sMiddleName is null THEN '''' ELSE '' '' +@sMiddleName END)
        + (CASE WHEN @sSuffix is null THEN '''' ELSE '', '' + @sSuffix END)
    )
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getFormatVariableValue2]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_getFormatVariableValue2]

(	@exportFormatType INT,
	@exportFormatGUID UNIQUEIDENTIFIER,
	@exportFormatOptionType INT,
	@iProvider VARCHAR(50) = NULL,
	@renderer VARCHAR(50) = NULL,
	@serviceSiteUid VARCHAR(50) = NULL, --INT = NULL,
	@refUUID UNIQUEIDENTIFIER = NULL,
	@FinancialCenterUid  VARCHAR(50) = NULL
)
RETURNS VARCHAR(255)
AS
BEGIN
	DECLARE @retVal VARCHAR(255)
	SET @retVal='''' 
	
	DECLARE @FormatOptionTypeName VARCHAR(50)  

	SET @iProvider = ISNULL(@iProvider,''00000000-0000-0000-0000-000000000000'')
	SET @renderer = ISNULL(@renderer,''00000000-0000-0000-0000-000000000000'')
	SET @serviceSiteUid = ISNULL(@serviceSiteUid, ''00000000-0000-0000-0000-000000000000'')
	SET @refUUID = ISNULL(@refUUID,''00000000-0000-0000-0000-000000000000'')
	SET @FinancialCenterUid = ISNULL(@FinancialCenterUid,''14B99C94-EDAC-47BD-97B9-CF421AC16018'')
	
	
	-- NOTE:  Modeled after UDF_getFormatVaribleValue but this function returns value2 rather than value
	--        Only using those exportFormatTypes currently needed.  See UDF_getFormatVaribleValue if adding other types
	if ( @exportFormatType = 2 )
	BEGIN
			IF @exportFormatOptionType = 9 
				SET @FormatOptionTypeName = ''File as Group or Individual''
				
		SELECT @retVal = CASE WHEN ClaimFormatOption.ClaimFormatValueTypeUid IS NULL THEN  ISNULL(ClaimFormatOption.FixedValue, '''') 
					ELSE ISNULL(ClaimFormatValue.value2,'''')
					END
			FROM ClaimFormatOption
			LEFT JOIN ClaimFormatValue ON ClaimFormatValue.ClaimFormatValueTypeUid =  ClaimFormatOption.ClaimFormatValueTypeUid
				AND ((ClaimFormatValue.ProviderUid IS NOT NULL AND CONVERT(VARCHAR(50), ClaimFormatValue.ProviderUid) = @iProvider )OR (ClaimFormatValue.ProviderUid IS NULL AND @iProvider = ''00000000-0000-0000-0000-000000000000'') OR (ClaimFormatValue.ProviderUid IS NULL))
				AND ((ClaimFormatValue.ServiceSiteUid IS NOT NULL AND CONVERT(VARCHAR(50), ClaimFormatValue.ServiceSiteUid) = @serviceSiteUid) OR (ClaimFormatValue.ServiceSiteUid IS NULL AND @serviceSiteUid = ''00000000-0000-0000-0000-000000000000'') OR (ClaimFormatValue.ServiceSiteUid IS NULL ))
				AND ((ClaimFormatValue.FinancialCenterUid IS NOT NULL AND CONVERT(VARCHAR(50), ClaimFormatValue.FinancialCenterUid) = @FinancialCenterUid) OR (ClaimFormatValue.FinancialCenterUid IS NULL AND @FinancialCenterUid = ''14B99C94-EDAC-47BD-97B9-CF421AC16018'') OR (ClaimFormatValue.FinancialCenterUid IS NULL ))
			LEFT JOIN ListClaimFormatOptionType ON ListClaimFormatOptionType.ClaimFormatOptionTypeUid = ClaimFormatOption.ClaimFormatOptionTypeUid
			WHERE ListClaimFormatOptionType.Name LIKE @FormatOptionTypeName
				AND ClaimFormatOption.ClaimFormatUid = @exportFormatGUID
			ORDER BY ServiceSiteUid, ProviderUid, FinancialCenterUid -- per bug 8968 added FinancialCenterUid to sort order
		
	END
	
	RETURN(@retVal)
END








' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getFormatVariableValueByMedicalServicesProviderUid]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[UDF_getFormatVariableValueByMedicalServicesProviderUid] 
(
	@exportFormatGUID UNIQUEIDENTIFIER,
	@iMedicalServicesProvider VARCHAR(50) = NULL,
	@serviceSiteUid VARCHAR(50) = NULL, 
	@FinancialCenterUid  VARCHAR(50) = NULL
)
RETURNS VARCHAR(255)
AS
BEGIN
	DECLARE @retVal VARCHAR(255)

	SET @iMedicalServicesProvider = ISNULL(@iMedicalServicesProvider,''00000000-0000-0000-0000-000000000000'')
	SET @serviceSiteUid = ISNULL(@serviceSiteUid, ''00000000-0000-0000-0000-000000000000'')
	SET @FinancialCenterUid = ISNULL(@FinancialCenterUid,''14B99C94-EDAC-47BD-97B9-CF421AC16018'')

	SELECT @retVal = ISNULL(eClaimFormatValue.value, '''')	
	FROM ListClaimFormatValueType eListClaimFormatValueType
			LEFT JOIN ClaimFormatValue eClaimFormatValue ON	eClaimFormatValue.ClaimFormatValueTypeUid = eListClaimFormatValueType.ClaimFormatValueTypeUid AND
						((eClaimFormatValue.MedicalServicesProviderUid IS NOT NULL AND CONVERT(VARCHAR(50),eClaimFormatValue.MedicalServicesProviderUid) = @iMedicalServicesProvider )OR (eClaimFormatValue.MedicalServicesProviderUid IS NULL AND @iMedicalServicesProvider = ''00000000-0000-0000-0000-000000000000'') OR (eClaimFormatValue.MedicalServicesProviderUid IS NULL)) AND
						((eClaimFormatValue.ServiceSiteUid IS NOT NULL AND CONVERT(VARCHAR(50),eClaimFormatValue.ServiceSiteUid) = @serviceSiteUid) OR (eClaimFormatValue.ServiceSiteUid IS NULL AND @serviceSiteUid = ''00000000-0000-0000-0000-000000000000'') OR (eClaimFormatValue.ServiceSiteUid IS NULL)) AND
						((eClaimFormatValue.FinancialCenterUid IS NOT NULL AND CONVERT(VARCHAR(50), eClaimFormatValue.FinancialCenterUid) = @FinancialCenterUid) OR (eClaimFormatValue.FinancialCenterUid IS NULL AND @FinancialCenterUid = ''14B99C94-EDAC-47BD-97B9-CF421AC16018'') OR (eClaimFormatValue.FinancialCenterUid IS NULL))
	WHERE
		eListClaimFormatValueType.ClaimFormatValueTypeUid = @exportFormatGUID 
	ORDER BY ServiceSiteUid, MedicalServicesProviderUid, FinancialCenterUid

	RETURN(@retVal)
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getFormatVariableValueByMedicalServicesProvider]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

-- DSW 08/15/2014 16026	Created for Medical Services Provider

CREATE FUNCTION [dbo].[UDF_getFormatVariableValueByMedicalServicesProvider]
(	@exportFormatGUID UNIQUEIDENTIFIER,			-- ClaimFormatType
	@exportFormatType INT,						-- 2 == Electronic, 3 == Paper
	@exportFormatOptionType INT,				-- Option Type on claim format ( ListClaimFormatOptionType )
	@iMSPProvider VARCHAR(50) = NULL,			-- Medical Services Provider
	@serviceSiteUid VARCHAR(50) = NULL,			--Service Site
	@FinancialCenterUid  VARCHAR(50) = NULL		-- Financial Center
)
RETURNS VARCHAR(255)
AS
BEGIN
	DECLARE @retVal VARCHAR(255)
	DECLARE @FormatOptionTypeName VARCHAR(50)  

	SET @iMSPProvider = ISNULL(@iMSPProvider,''00000000-0000-0000-0000-000000000000'')
	SET @serviceSiteUid = ISNULL(@serviceSiteUid, ''00000000-0000-0000-0000-000000000000'')
	SET @FinancialCenterUid = ISNULL(@FinancialCenterUid,''14B99C94-EDAC-47BD-97B9-CF421AC16018'')

	-- NOTE:  Should be calling UDF_getFormatVariableValueByMedicalServicesProvider if not calling with 2 or 3
	IF @exportFormatType = 2 OR @exportFormatType = 3
	BEGIN
		IF @exportFormatType = 2 -- Electronic
		BEGIN
			IF @exportFormatOptionType = 0 
				SET @FormatOptionTypeName = ''Purchased Service ID''
			IF @exportFormatOptionType = 1 
				SET @FormatOptionTypeName = ''Purchased Service ID Type''
		END
		ELSE
		IF @exportFormatType = 3 -- Paper CMS-1500, Paper CMS-1500 5010
		BEGIN
			IF @exportFormatOptionType = 0 
				SET @FormatOptionTypeName = ''Purchased Service BOX 32b''
			IF @exportFormatOptionType = 1 
				SET @FormatOptionTypeName = ''Purchased Service BOX 32b Type''
		END
		
		SELECT @retVal = COALESCE( NULLIF(cfo.FixedValue, ''''), cfv.value)
		FROM ClaimFormatOption cfo with (nolock)
			LEFT JOIN ClaimFormatValue cfv with (nolock) ON cfo.ClaimFormatValueTypeUid = cfv.ClaimFormatValueTypeUid   
				AND ((cfv.MedicalServicesProviderUid IS NOT NULL AND CONVERT(VARCHAR(50), cfv.MedicalServicesProviderUid) = @iMSPProvider )
				     OR (cfv.MedicalServicesProviderUid IS NULL AND @iMSPProvider = ''00000000-0000-0000-0000-000000000000'') 
					 OR (cfv.MedicalServicesProviderUid IS NULL))
				AND ((cfv.ServiceSiteUid IS NOT NULL AND CONVERT(VARCHAR(50), cfv.ServiceSiteUid) = @serviceSiteUid) 
				     OR (cfv.ServiceSiteUid IS NULL AND @serviceSiteUid = ''00000000-0000-0000-0000-000000000000'') 
					 OR (cfv.ServiceSiteUid IS NULL ))				
				AND ((cfv.FinancialCenterUid IS NOT NULL AND CONVERT(VARCHAR(50), cfv.FinancialCenterUid) = @FinancialCenterUid) 
				     OR (cfv.FinancialCenterUid IS NULL AND @FinancialCenterUid = ''14B99C94-EDAC-47BD-97B9-CF421AC16018'') 
					 OR (cfv.FinancialCenterUid IS NULL ))
			LEFT JOIN ListClaimFormatOptionType cfot with (nolock) ON cfo.ClaimFormatOptionTypeUid = cfot.ClaimFormatOptionTypeUid 
			WHERE cfot.Name LIKE @FormatOptionTypeName
					AND cfo.ClaimFormatUid = @exportFormatGUID
			ORDER BY ServiceSiteUid, MedicalServicesProviderUid, FinancialCenterUid 
	END
	ELSE		/* @exportFormatType = 0 */
	BEGIN
		select @retVal = dbo.UDF_getFormatVariableValueByMedicalServicesProviderUid( @exportFormatGUID, @iMSPProvider, @serviceSiteUid, @FinancialCenterUid)
	END

	RETURN(@retVal)

END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getLabResultList]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE  FUNCTION [dbo].[UDF_getLabResultList]
(
	 @PersonUid UNIQUEIDENTIFIER = NULL
	 ,@TotalCholesterolLOINCUid UNIQUEIDENTIFIER = NULL
	 ,@TotalCholesterol varchar(max)
	 ,@HDLLOINCUid UNIQUEIDENTIFIER = NULL
	 ,@HDL varchar(max) = NULL
	 ,@LDLLOINCUid UNIQUEIDENTIFIER = NULL
	 ,@LDL varchar(max) = NULL
	 ,@TriglyceridesLOINCUid UNIQUEIDENTIFIER = NULL
	 ,@Triglycerides varchar(max) = NULL
 	 ,@LabResults_StartDate datetime = NULL
	 ,@LabResults_EndDate datetime = NULL  
)
RETURNS  VARCHAR(Max)
AS 
BEGIN 
		DECLARE @LabResultList VARCHAR(Max) = ''N/A''

		SET @LabResults_StartDate = ISNULL(@LabResults_StartDate , ''1-01-1997'')
		SET @LabResults_EndDate = ISNULL(@LabResults_EndDate, getdate()) 
	
		SELECT @LabResults_StartDate = dbo.getPracticeUTCDateTime (@LabResults_StartDate)
		SELECT @LabResults_EndDate =  DATEADD(DAY,1,dbo.getPracticeUTCDateTime(@LabResults_EndDate))
				
		DECLARE @TotalCholesterolStart varchar(100)
		DECLARE @TotalCholesterolEnd varchar(100)
		
		Set @TotalCholesterolStart = ''0''
		Set @TotalCholesterolEnd = ''999''
		
		If( @TotalCholesterol IS NOT NULL AND LEN( @TotalCholesterol) > 0 )
		BEGIN
			select @TotalCholesterolStart = Element from Split(@TotalCholesterol,''-'') where ElementID = 1
			select @TotalCholesterolEnd = Element from Split(@TotalCholesterol,''-'') where ElementID = 2
		END
		
		DECLARE @HDLStart varchar(100)
		DECLARE @HDLEnd varchar(100)
		
		Set @HDLStart = ''0''
		Set @HDLEnd = ''999''
		
		If( @HDL IS NOT NULL AND LEN(@HDL) > 0 )
		BEGIN
			select @HDLStart = Element from Split(@HDL,''-'') where ElementID = 1
			select @HDLEnd = Element from Split(@HDL,''-'') where ElementID = 2
		END
		
		DECLARE @LDLStart varchar(100)
		DECLARE @LDLEnd varchar(100)
		
		If( @LDL IS NOT NULL AND LEN( @LDL) > 0 )
		BEGIN
			select @LDLStart = Element from Split(@LDL,''-'') where ElementID = 1
			select @LDLEnd = Element from Split(@LDL,''-'') where ElementID = 2
		END
		
		DECLARE @TriglyceridesStart varchar(100)
		DECLARE @TriglyceridesEnd varchar(100)
		
		Set @TriglyceridesStart = ''0''
		Set @TriglyceridesEnd = ''999''
		
		If( @Triglycerides IS NOT NULL AND LEN( @Triglycerides) > 0 )
		BEGIN
			select @TriglyceridesStart = Element from Split(@Triglycerides,''-'') where ElementID = 1
			select @TriglyceridesEnd = Element from Split(@Triglycerides,''-'') where ElementID = 2
		END

		if (@TotalCholesterolLOINCUid != ''00000000-0000-0000-0000-000000000000'' 
			OR 
			@HDLLOINCUid != ''00000000-0000-0000-0000-000000000000''
			OR
			@LDLLOINCUid != ''00000000-0000-0000-0000-000000000000''
			OR
			@TriglyceridesLOINCUid != ''00000000-0000-0000-0000-000000000000''
			)
		BEGIN
		SELECT @LabResultList = 
				(substring(
				(SELECT ( '';'' + loi.Name + '': '' + coalesce(nullif(Convert(VARCHAR(50),ISNULL(ov.ObservationValue,'''')),''''),''N/A'') + '' Resulted: '' + (Convert(VARCHAR(50),oo.ResultDate,101)))
                 FROM    ObservationOrder oo 
				 INNER JOIN ObservationValue    ov  ON ov.ObservationOrderUid = oo.ObservationOrderUid 
				 INNER JOIN ListObservationItem loi ON loi.ObservationItemUid = ov.ObservationItemUid 
				 INNER JOIN ListLOINC           ll  ON ll.LOINCUid            = loi.LOINCUid 
				 inner join Person				PR  ON PR.PersonUid			  = oo.PatientUid			
				 where 
				    oo.IsDelete = 0
				    AND
					@PersonUid = oo.PatientUid
					AND
					(
					    (
					    loi.LOINCUid = @TotalCholesterolLOINCUid 
					    AND (coalesce(nullif(Convert(VARCHAR(50),ISNULL(ov.ObservationValue,'''')),''''),''''))  >= @TotalCholesterolStart 
					    AND (coalesce(nullif(Convert(VARCHAR(50),ISNULL(ov.ObservationValue,'''')),''''),''''))  <= @TotalCholesterolEnd 
					    )
					    OR
					    (
							loi.LOINCUid = @HDLLOINCUid 
							AND (coalesce(nullif(Convert(VARCHAR(50),ISNULL(ov.ObservationValue,'''')),''''),''''))  >= @HDLStart 
							AND (coalesce(nullif(Convert(VARCHAR(50),ISNULL(ov.ObservationValue,'''')),''''),''''))  <= @HDLEnd
						)
						OR
						(
							loi.LOINCUid = @LDLLOINCUid 
							AND (coalesce(nullif(Convert(VARCHAR(50),ISNULL(ov.ObservationValue,'' '')),'' ''),'' ''))  >= @LDLStart 
							AND (coalesce(nullif(Convert(VARCHAR(50),ISNULL(ov.ObservationValue,'' '')),'' ''),'' ''))  <= @LDLEnd
						)
					OR
						(
							loi.LOINCUid = @TriglyceridesLOINCUid 
							AND (coalesce(nullif(Convert(VARCHAR(50),ISNULL(ov.ObservationValue,'''')),''''),''''))  >= @TriglyceridesStart 
							AND (coalesce(nullif(Convert(VARCHAR(50),ISNULL(ov.ObservationValue,'''')),''''),''''))  <= @TriglyceridesEnd		
						)			    
					)					 
					AND					
					oo.ResultDate >= CONVERT(DATE,@LabResults_StartDate) AND oo.ResultDate < CONVERT(DATE,@LabResults_EndDate)
				 order by oo.ResultDate, loi.Name
				 FOR XML PATH( '''' )
				 ), 2, 2500 ) )		
		END
		ELSE
		BEGIN
		SELECT @LabResultList = 
				(substring(
				(SELECT ( '';'' + loi.Name + '': '' + coalesce(nullif(Convert(VARCHAR(50),ISNULL(ov.ObservationValue,'''')),''''),''N/A'') + '' Resulted: '' + (Convert(VARCHAR(50),oo.ResultDate,101)))
                 FROM    ObservationOrder oo 
				 INNER JOIN ObservationValue    ov  ON ov.ObservationOrderUid = oo.ObservationOrderUid 
				 INNER JOIN ListObservationItem loi ON loi.ObservationItemUid = ov.ObservationItemUid 
				 INNER JOIN ListLOINC           ll  ON ll.LOINCUid            = loi.LOINCUid 
				 inner join Person				PR  ON PR.PersonUid			  = oo.PatientUid			
				 where 
				    oo.IsDelete = 0
				    AND
					@PersonUid = oo.PatientUid				 
					AND					
					oo.ResultDate >= @LabResults_StartDate AND oo.ResultDate < @LabResults_EndDate
				 order by oo.ResultDate, loi.Name
				 FOR XML PATH( '''' )
				 ), 2, 2500 ) )						 
		 END									 
		RETURN @LabResultList
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getLastFilingDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =============================================
-- Author:		<Lionel Godolphin>
-- Create date: <4/27/06>
-- Description:	<Gets Last Filing Date for Superbill>
-- =============================================
CREATE FUNCTION [dbo].[UDF_getLastFilingDate] 
(
	-- Add the parameters for the function here
	@SuperbillUid	uniqueidentifier
)
RETURNS datetime
AS
BEGIN
	-- Declare the return variable here
	DECLARE @LastFilingDate	datetime

	-- Add the T-SQL statements to compute the return value here
	SELECT @LastFilingDate = MAX(ClaimDate) 
		FROM dbo.ClaimBatch cb
		JOIN dbo.ClaimBatchDetail cbd ON (cbd.ClaimBatchUid = cb.ClaimBatchUid)
		WHERE cbd.SuperbillUid = @SuperbillUid

	-- Return the result of the function
	RETURN @LastFilingDate

END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getMedicareApprovedAmount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE FUNCTION [dbo].[UDF_getMedicareApprovedAmount]       
(  
@SuperbillUid UNIQUEIDENTIFIER,      
@InsType int  
)        
RETURNS MONEY        
AS      
  
/*      
Purpose: To return all or Primary diags for a procedure in DFT      
Created On: 20050928      
LastModified On: 20051003      
Modifications Made: 1. For NEO - returning Uid      
Special Comment:      
*/      
  
BEGIN      
DECLARE @MedicareApprovedAmount MONEY    
IF (@InsType>=1) 
 BEGIN
    SELECT @MedicareApprovedAmount=SUM(COALESCE(LDM.ActualAmountAllowed,LDM.OriginalAmountAllowed))
	FROM
		Superbill S
	Join 
	   Superbillprocedure SBP
	 ON
	   SBP.SuperbillUid=S.SuperbillUid
	JOIN
		AR_LedgerDetail LD
	ON
		SBP.SuperbillProcedureUid=LD.SuperbillProcedureUid 	
	JOIN
		AR_Ledger L
	ON
		L.LedgerUid=LD.LedgerUID AND (L.EntryType=1 OR L.EntryType=4)
	JOIN
	  AR_RelLedgerDetailModifier LDM
	ON
	  LDM.LedgerDetailUid=LD.LedgerDetailUid
	WHERE 
	  S.SuperbillUid=@SuperbillUid
		AND
	  LD.LiabilityOwner =@InsType
 END
ELSE    
BEGIN    
 SELECT @MedicareApprovedAmount =SUM( SP.Units * (CASE WHEN FSP.RVUScheduleuid IS NOT NULL THEN ISNULL((RSV.WorkRVU + RBNonFacilityPERVU + RSV.MPRVU),0) ELSE ISNULL(FSF.Fee,0) END))     
 FROM    
 Superbill S    
 JOIN    
 SuperbillProcedure SP    
 ON    
 S.SuperbillUid=SP.SuperbillUid    
 JOIN    
 AccountPeriod  AP    
 ON    
 S.AccountUid = AP.AccountUid  AND (AP.EffectiveDate <= S.ServiceDateStart OR AP.EffectiveDate IS NULL)    
 AND (AP.ExpirationDate >= S.ServiceDateEnd OR AP.ExpirationDate IS NULL)    
 INNER JOIN AccountInsurance AI on AP.AccountPeriodUid=AI.AccountPeriodUid AND AI.DisplayOrder = @InsType       
 INNER JOIN PersonInsurancePlan PIP on AI.PersonInsurancePlanUid=PIP.PersonInsurancePlanUid      
 INNER JOIN InsurancePlan IP on PIP.InsurancePlanUid=IP.InsurancePlanUid      
 INNER JOIN Corporation C on IP.InsuranceCarrierUid=C.CorporationUid      
 INNER JOIN InsuranceCarrier IC ON C.CorporationUid =IC.CorporationUid     
 INNER JOIN    
 FeeSchedule FS    
 ON    
 (IP.FeeScheduleUid = FS.FeeScheduleUid  AND IP.UseCarrierFeeSchedule=0)    
 OR (IC.FeeScheduleUid =FS.FeeScheduleUid AND IP.UseCarrierFeeSchedule=1)    
 INNER JOIN    
 FeeSchedulePeriod  FSP    
 ON    
 FS.FeeScheduleUid =FSP.FeeScheduleUid AND (FSP.EffectiveDate <= S.ServiceDateStart OR FSP.EffectiveDate IS NULL)    
 AND (FSP.ExpirationDate >= S.ServiceDateEnd OR FSP.ExpirationDate IS NULL)    
 LEFT JOIN    
 FeeScheduleFee FSF    
 ON    
 FSP.FeeSchedulePeriodUid = FSF.FeeSchedulePeriodUid AND SP.ProcedureUid = FSF.ProcedureUid    
 LEFT JOIN      
 RVUScheduleValue RSV      
 ON      
 FSP.RVUScheduleUID = RSV.RVUScheduleUID AND SP.Procedureuid=RSV.Procedureuid      
 WHERE S.SuperbillUid=@SuperbillUid    
END    
  
  
IF @MedicareApprovedAmount IS NULL    
set @MedicareApprovedAmount=0.0    
  
RETURN @MedicareApprovedAmount      
END      
  


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getMedicarePaidDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- the function returns "Date Paid By Medicare" (Item-25 in Medicaid paper claim form) in MMDDYY format  
CREATE   FUNCTION [dbo].[UDF_getMedicarePaidDate]  
(  
 @SuperbillUID UNIQUEIDENTIFIER,  
 @CurrentCarrier INT  
)  
RETURNS VARCHAR(6)  
AS  
BEGIN            
  
 DECLARE @retDate VARCHAR(6)   
 DECLARE @pDate DATETIME  
  
  SELECT @pDate = MAX(VDEP.depositdate) 
   FROM Superbill SB  
   INNER JOIN SuperbillProcedure SBP ON SB.SuperbillUid = SBP.SuperbillUid  
   INNER JOIN AR_LedgerDetail LD ON SBP.SuperbillProcedureUid = LD.SuperbillProcedureUid 
   INNER JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid and L.EntryType=2  
   Inner Join AR_Transaction T On T.SuperbillUid = SB.SuperbillUid 
   INNER JOIN ViewDeposit VDEP ON T.DepositUid = VDEP.DepositUid 
   INNER JOIN ListCreditType LCT on LCT.CreditTypeUid=LD.IncomeAccountUid AND LCT.Name Like ''%Insurance Payment%''  
   AND L.VoidLedgerUid is null and NOT L.LedgerUid IN (SELECT VoidLedgerUid FROM AR_Ledger WHERE NOT VoidLedgerUid IS NULL)   
  
   SET @retDate =  
   CASE WHEN ISNULL(@pDate,'''') <> '''' THEN  
    --[dbo].[UDF_getDate_MMDDYY] (@pDate)   
    LEFT(REPLACE(CONVERT(VARCHAR(10), @pDate, 101), ''/'', ''''), 4) + RIGHT(REPLACE(CONVERT(VARCHAR(10), @pDate, 101), ''/'', ''''), 2)  
   ELSE   
    ''''  
   END  
  RETURN @retDate   
END  
  

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getModifier]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[UDF_getModifier]
(
	@SuperbillUid UNIQUEIDENTIFIER ,
	@SuperbillProcedureUid UNIQUEIDENTIFIER ,
	@ModifierOrder INT 
)

RETURNS VARCHAR(255)
AS

BEGIN
	DECLARE @retVal VARCHAR(255)
	DECLARE @Cnt SMALLINT

	SET @Cnt = 0
	SET @retVal = ''''

	DECLARE CUR_Modifier CURSOR FOR
		SELECT 	COALESCE(NULLIF(lpm.ANSICode,''''), NULLIF(lpm.Modifier,''''), '''') AS bpmodifier 
		FROM Superbill d
		LEFT JOIN SuperBillProcedure sbp ON 
			sbp.SuperbillUid = d.SuperbillUid AND ISNULL(sbp.DontClaim,0) = 0
		LEFT JOIN SuperbillProcedureModifier sbpm ON
			sbpm.SuperbillProcedureUid = sbp.SuperbillProcedureUid
		LEFT JOIN ListProcedureModifier lpm ON
			lpm.ProcedureModifierUid = sbpm.ProcedureModifierUid
		WHERE d.Superbilluid = @SuperbillUid
			AND sbpm.SuperbillProcedureUid = @SuperbillProcedureUid
		ORDER BY sbpm.DisplayOrder
	OPEN CUR_Modifier

	FETCH NEXT FROM CUR_Modifier 
	INTO @retVal 
	WHILE @@FETCH_STATUS =0
	BEGIN
		SET @Cnt = @Cnt + 1
		IF @Cnt = @ModifierOrder
			GOTO GOEND
		ELSE
			SET @retVal = ''''
	   FETCH NEXT FROM CUR_Modifier INTO @retVal 
	END

	GOEND:	
	CLOSE CUR_Modifier 
	DEALLOCATE CUR_Modifier 
	RETURN(@retVal)
END






' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getPaidAmount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


-- the function returns amount paid by either Primary/Secondary payer or Patient
CREATE   FUNCTION [dbo].[UDF_getPaidAmount]
(
	@SuperbillUid UNIQUEIDENTIFIER,
	@PaidBy INT	-- 0 for ''Patient'' 
				-- 1 for ''Primary Insurance''
				-- 2 for ''Secondary Insurance''
)
RETURNS MONEY
AS
BEGIN
	DECLARE @retVal MONEY 
	DECLARE @Payer nVARCHAR(10)
	SET @retVal = 0
	SET @Payer = CASE WHEN @PaidBy = 0 THEN 
							''Patient''
						ELSE
							''Insurance''
						END
						
	SELECT @retVal = ISNULL(0-sum( ISNULL(LDCredit.Amount, 0)), 0)
	FROM Superbill SB
		INNER JOIN SuperbillProcedure SBP ON SB.SuperbillUid = SBP.SuperbillUid
		INNER JOIN AR_LedgerDetail LDCredit ON SBP.SuperbillProcedureUid = LDCredit.SuperbillProcedureUid AND LDCredit.IsCredit = 1
		INNER JOIN AR_Ledger L ON LDCredit.LedgerUid = L.LedgerUid
		INNER JOIN AR_LedgerDetail LDDebit ON L.LedgerUid = LDDebit.LedgerUid AND LDDebit.IsCredit = 0
		INNER JOIN Deposit DEP ON LDDebit.DepositUid = DEP.DepositUid
		INNER JOIN ListCreditType LCT ON LDCredit.IncomeAccountUid = LCT.CreditTypeUid
	WHERE SB.SuperbillUid = @SuperbillUID 
		AND (LCT.Name LIKE @Payer + '' Payment'' ) AND LCT.IsPayment = 1
		AND LDCredit.LiabilityOwner = @PaidBy
		AND L.VoidLedgerUid is null and NOT L.LedgerUid IN (SELECT VoidLedgerUid FROM AR_Ledger WHERE NOT VoidLedgerUid IS NULL) 
	
	RETURN(@retVal)
END






' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getOtherSourceCode]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

-- the function returns the other source code, as required by Medicaid paper claims, if a part of payment has already done
CREATE   FUNCTION [dbo].[UDF_getOtherSourceCode]
(
	@SuperbillUid UNIQUEIDENTIFIER,
	@CurrentCarrier INT
)
RETURNS VARCHAR
AS
BEGIN

	DECLARE @OtherSourceCode VARCHAR(2)
	DECLARE @OtherSource VARCHAR(100)
	DECLARE @PaidAmount MONEY
	SET @OtherSourceCode = ''''
	SET @OtherSource  = ''''


	SELECT @OtherSource = lat.ExternalId
	FROM Superbill s
	INNER JOIN PersonInsurancePlan pip ON s.PatientUID = pip.PersonUID
	INNER JOIN InsurancePlan ip ON pip.InsurancePlanUID = ip.InsurancePlanUID AND ip.Inactive = 0
	INNER JOIN InsuranceCarrier ic ON ip.InsuranceCarrierUID = ic.CorporationUID
	INNER JOIN AccountInsurance ai ON pip.PersonInsurancePlanUID = ai.PersonInsurancePlanUID AND ai.DisplayOrder = 1
	LEFT JOIN ListAccountType lat ON ip.AccountTypeUID = lat.AccountTypeUID 
	WHERE s.SuperBillUID = @SuperbillUid

	SET @PaidAmount =
		CASE WHEN @OtherSource = ''09'' THEN 
			 [dbo].[UDF_getPaidAmount] (@SuperbillUid,0)	--Amount paid by patient
		ELSE
			[dbo].[UDF_getPaidAmount] (@SuperbillUid, (@CurrentCarrier - 1))	--Amount paid by previous payer
		END
	
	SET @OtherSourceCode =
		CASE WHEN @PaidAmount > 0 THEN 	--If payment is received from other source
		
			CASE WHEN @OtherSource LIKE ''09'' THEN ''1''   --self/family
			WHEN @OtherSource = ''BL'' THEN ''2''	--Blue Cross / Blue Shield
			WHEN @OtherSource = ''CI'' THEN ''3'' --Private Payer
			WHEN @OtherSource = ''WC'' THEN ''4'' 	--Employer / Union
			--WHEN @OtherSource = ''%%'' THEN ''5''		--Public
			--WHEN @OtherSource = ''%%'' THEN ''7''		--Psychiatric reduction
												--8 is not applicable for OHF
			ELSE 
			 ''6''		--Other 
			END
		--ELSE	--If payment is not received from other source
		
			--CASE WHEN  THEN

			--END
		END
	RETURN @OtherSourceCode
	
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getPastPregAnswers]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_getPastPregAnswers]
(
	@PatientHistoryUid UNIQUEIDENTIFIER ,
	@QuestionUid UNIQUEIDENTIFIER = null
)
RETURNS VARCHAR(8000)
AS
BEGIN
	DECLARE @retVal VARCHAR(255)
	DECLARE @Answer VARCHAR(255)
	DECLARE @Cnt SMALLINT
	Set @Answer = ''''
	Set @Cnt = 0
	DECLARE CUR_Answers CURSOR FOR
	SELECT AnswerName FROM PatientHistoryDetail WHERE PatientHistoryUid = @PatientHistoryUid 
				And QuestionUid = @QuestionUid
	OPEN CUR_Answers
	FETCH NEXT FROM CUR_Answers INTO @retVal 
	WHILE @@FETCH_STATUS = 0
	BEGIN		
		IF @Cnt = 0 
			Set @Answer = @retVal
		ELSE
			Set @Answer = @Answer +'';''+@retVal
		Set @Cnt = @Cnt + 1
	FETCH NEXT FROM CUR_Answers INTO @retVal 			
	END
	CLOSE CUR_Answers 
	DEALLOCATE CUR_Answers 
RETURN(@Answer)
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getPatientLabResultList]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



--DECLARE @A VARCHAR(MAX)
--SELECT @A=DBO.[UDF_getPatientLabResultList] (''A5C92A62-758F-4080-913D-0265CBCB48E7'',''4E10B5B4-262E-4138-9FAC-383A284E18A2'',''0-55'',0,''D273FB90-9738-4A7C-A101-B6FFB24D7D5A'','''',0,NULL,NULL,NULL,NULL,NULL)
--SELECT @A 
--08/04/2016 BLR ObsItemUids can come in as '''' rather than NULL. Added logic that, if this happens, to set them to NULL
--09/20/2019 CH tfs24733 report not pulling in correct values entered in the criteria 
CREATE  FUNCTION [dbo].[UDF_getPatientLabResultList]
(
	 @PersonUid UNIQUEIDENTIFIER = NULL
	 ,@ObservationItem1Uid varchar(max)= NULL --Modified to use observation item instead of 
	 ,@ObservationItem1Range varchar(max)
	 ,@LogicOpr1 bit=0
	 ,@ObservationItem2Uid varchar(max) = NULL --Modified to use observation item instead of 
	 ,@ObservationItem2Range varchar(max) = NULL
	 ,@LogicOpr2 bit=0
	 ,@ObservationItem3Uid varchar(max) = NULL --Modified to use observation item instead of 
	 ,@ObservationItem3Range varchar(max) = NULL
 	 ,@LabResults_StartDate datetime = NULL
	 ,@LabResults_EndDate datetime = NULL 
	 ,@LaboratoryUid varchar(max) = NULL
)
RETURNS  VARCHAR(Max)
AS 
BEGIN 
		DECLARE @LabResultList VARCHAR(Max) = ''N/A''
		IF @LaboratoryUid=''''
			SET @LaboratoryUid=NULL
		SET @LabResults_StartDate = ISNULL(@LabResults_StartDate , ''1-01-1997'')
		SET @LabResults_EndDate = ISNULL(@LabResults_EndDate, getdate())

		IF @ObservationItem1Uid = ''''
			SET @ObservationItem1Uid = NULL

		IF @ObservationItem2Uid = ''''
			SET @ObservationItem2Uid = NULL

		IF @ObservationItem3Uid = ''''
			SET @ObservationItem3Uid = NULL
				
		DECLARE @ObservationItem1Start varchar(100)
		DECLARE @ObservationItem1End varchar(100)
		
		Set @ObservationItem1Start = ''0''
		Set @ObservationItem1End = ''999''
		
		If( @ObservationItem1Range IS NOT NULL AND LEN( @ObservationItem1Range) > 0 )
		BEGIN
			select @ObservationItem1Start = Element from Split(@ObservationItem1Range,''-'') where ElementID = 1
			select @ObservationItem1End = Element from Split(@ObservationItem1Range,''-'') where ElementID = 2
		END
		
		DECLARE @ObservationItem2Start varchar(100)
		DECLARE @ObservationItem2End varchar(100)
		
		Set @ObservationItem2Start = ''0''
		Set @ObservationItem2End = ''999''
		
		If( @ObservationItem2Range IS NOT NULL AND LEN(@ObservationItem2Range) > 0 )
		BEGIN
			select @ObservationItem2Start = Element from Split(@ObservationItem2Range,''-'') where ElementID = 1
			select @ObservationItem2End = Element from Split(@ObservationItem2Range,''-'') where ElementID = 2
		END
		
		DECLARE @ObservationItem3Start varchar(100)
		DECLARE @ObservationItem3End varchar(100)
		
		If( @ObservationItem3Range IS NOT NULL AND LEN( @ObservationItem3Range) > 0 )
		BEGIN
			select @ObservationItem3Start = Element from Split(@ObservationItem3Range,''-'') where ElementID = 1
			select @ObservationItem3End = Element from Split(@ObservationItem3Range,''-'') where ElementID = 2
		END
		

		if (@ObservationItem1Uid IS NOT NULL  
			OR 
			@ObservationItem2Uid IS NOT NULL  
			OR
			@ObservationItem3Uid IS NOT NULL  
			)
		BEGIN
			DECLARE @ResultCollection TABLE (LabResult VARCHAR(1000),ObservationItemUid UNIQUEIDENTIFIER,NumericObservationValue VARCHAR(MAX))
			DECLARE @Result TABLE (Result VARCHAR(1000),ObservationItemUid UNIQUEIDENTIFIER)

			DECLARE @DisplayResult Bit
			SET @DisplayResult=0

			/* Add pre-collection table to omit any value that isn''t int or decimal to account for string or bidnary data truncation error */
			INSERT INTO @ResultCollection
			SELECT PL.LabResult,PL.ObservationItemUid, NumericObservationValue
			FROM   [MDOL_RPT2_VIEW_PatientLabResults] PL 		
			Where PL.IsDelete = 0
			AND @PersonUid = PL.PatientUid
			AND (NumericObservationValue not like ''%[^0-9]%'' OR NumericObservationValue like ''%.%'')
			AND NumericObservationValue NOT LIKE ''%[a-zA-Z]%''
			AND NumericObservationValue NOT LIKE ''%>%''
			AND NumericObservationValue NOT LIKE ''%<%''
			AND NumericObservationValue NOT LIKE ''%/%''
			AND PL.ResultDate >= @LabResults_StartDate AND PL.ResultDate < @LabResults_EndDate
			AND (@LaboratoryUid IS NULL OR PL.LaboratoryUid in (Select Element from dbo.Split(@LaboratoryUid,'','')))
			order by PL.ResultDate

			INSERT INTO @Result 
			SELECT PL.LabResult,PL.ObservationItemUid
				FROM   @ResultCollection PL 		
				Where 
					(
					PL.ObservationItemUid  in (Select element from dbo.Split (@ObservationItem1Uid,'','')) 
					AND ((IsNumeric(NumericObservationValue + ''e0'') = 1 AND CONVERT(NUMERIC(15,4),PL.NumericObservationValue)>=CONVERT(NUMERIC(15,4),@ObservationItem1Start)) OR (IsNumeric(NumericObservationValue + ''e0'') = 0 AND PL.NumericObservationValue>=@ObservationItem1Start))
					AND ((IsNumeric(NumericObservationValue + ''e0'') = 1 AND CONVERT(NUMERIC(15,4),PL.NumericObservationValue)<=CONVERT(NUMERIC(15,4),@ObservationItem1End)) OR (IsNumeric(NumericObservationValue + ''e0'') = 0 AND PL.NumericObservationValue<=@ObservationItem1End))
					)
					OR
					(
						PL.ObservationItemUid in (Select element from dbo.Split (@ObservationItem2Uid,'','')) 
					AND ((IsNumeric(NumericObservationValue + ''e0'') = 1 AND CONVERT(NUMERIC(15,4),PL.NumericObservationValue)>=CONVERT(NUMERIC(15,4),@ObservationItem2Start)) OR (IsNumeric(NumericObservationValue + ''e0'') = 0 AND PL.NumericObservationValue>=@ObservationItem2Start))
					AND ((IsNumeric(NumericObservationValue + ''e0'') = 1 AND CONVERT(NUMERIC(15,4),PL.NumericObservationValue)<=CONVERT(NUMERIC(15,4),@ObservationItem2End)) OR (IsNumeric(NumericObservationValue + ''e0'') = 0 AND PL.NumericObservationValue<=@ObservationItem2End))
					)
					OR
					(
						PL.ObservationItemUid in (Select element from dbo.Split (@ObservationItem3Uid,'','')) 
					AND ((IsNumeric(NumericObservationValue + ''e0'') = 1 AND CONVERT(NUMERIC(15,4),PL.NumericObservationValue)>=CONVERT(NUMERIC(15,4),@ObservationItem3Start)) OR (IsNumeric(NumericObservationValue + ''e0'') = 0 AND PL.NumericObservationValue>=@ObservationItem3Start))
					AND ((IsNumeric(NumericObservationValue + ''e0'') = 1 AND CONVERT(NUMERIC(15,4),PL.NumericObservationValue)<=CONVERT(NUMERIC(15,4),@ObservationItem3End)) OR (IsNumeric(NumericObservationValue + ''e0'') = 0 AND PL.NumericObservationValue<=@ObservationItem3End))
					)

			IF (@LogicOpr1 =1 AND @LogicOpr2 =1)
			BEGIN
				IF EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem1Uid,'',''))  OR @ObservationItem1Uid IS NULL) AND EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem2Uid,'',''))  OR @ObservationItem2Uid IS NULL) AND EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem3Uid,'',''))  OR @ObservationItem3Uid IS NULL)
					SET @DisplayResult=1
			END
			IF (@LogicOpr1 =1 AND @LogicOpr2 =0)
			BEGIN
				IF EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem1Uid,'',''))  OR @ObservationItem1Uid IS NULL) AND EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem2Uid,'',''))  OR @ObservationItem2Uid IS NULL) OR EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem3Uid,'',''))  OR @ObservationItem3Uid IS NULL)
					SET @DisplayResult=1
			END	
			IF (@LogicOpr1 =0 AND @LogicOpr2 =1)
			BEGIN
				IF EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem1Uid,'',''))  OR @ObservationItem1Uid IS NULL) OR EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem2Uid,'',''))  OR @ObservationItem2Uid IS NULL) AND EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem3Uid,'',''))  OR @ObservationItem3Uid IS NULL)
					SET @DisplayResult=1
			END			
			IF (@LogicOpr1 =0 AND @LogicOpr2 =0)
			BEGIN
				--IF EXISTS() OR EXISTS() OR EXISTS()
					SET @DisplayResult=1
			END		
			IF @DisplayResult=1 
			BEGIN
			SELECT @LabResultList = 
						(substring(
				
						( SELECT Result + '''' FROM @Result  FOR XML PATH( '''' )
						 ), 2, 2500 ) )	
			END	
			ELSE
				BEGIN
				SET @LabResultList=NULL
				END 
		END
		ELSE
		BEGIN
		SELECT @LabResultList = 
				(substring(
				(SELECT ( '';'' + loi.Name + '': '' + coalesce(nullif(Convert(VARCHAR(50),ISNULL(ov.ObservationValue,'''')),''''),''N/A'') + '' Resulted: '' + (Convert(VARCHAR(50),oo.ResultDate,101)))
                 FROM    ObservationOrder oo 
				 INNER JOIN ObservationValue    ov  ON ov.ObservationOrderUid = oo.ObservationOrderUid 
				 INNER JOIN ListObservationItem loi ON loi.ObservationItemUid = ov.ObservationItemUid 
				 --INNER JOIN ListLOINC           ll  ON ll.LOINCUid            = loi.LOINCUid 
				 inner join Person				PR  ON PR.PersonUid			  = oo.PatientUid			
				 where 
				    oo.IsDelete = 0
				    AND
					@PersonUid = oo.PatientUid				 
					AND					
					oo.ResultDate >= @LabResults_StartDate AND oo.ResultDate < @LabResults_EndDate
					AND
					(@LaboratoryUid IS NULL OR oo.LaboratoryUid in (Select Element from dbo.Split(@LaboratoryUid,'','')))
				 order by oo.ResultDate
				 FOR XML PATH( '''' )
				 ), 2, 2500 ) )						 
		 END									 
		RETURN @LabResultList
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getPatientLabResultListSingle]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
--09/04/2019 Chayes TFS 19553 Patient List Excel returns blank report due to truncation error

CREATE  FUNCTION [dbo].[UDF_getPatientLabResultListSingle]
(
	 @PersonUid UNIQUEIDENTIFIER = NULL
	 ,@ObservationItem1Uid varchar(max)= NULL --Modified to use observation item instead of 
	 ,@ObservationItem1Range varchar(max)
 	 ,@LabResults_StartDate datetime = NULL
	 ,@LabResults_EndDate datetime = NULL 
	 ,@LaboratoryUid varchar(max) = NULL
)
RETURNS  VARCHAR(Max)
AS 
BEGIN 
		DECLARE @LabResultList VARCHAR(Max) = ''N/A''
		IF @LaboratoryUid=''''
			SET @LaboratoryUid=NULL
		SET @LabResults_StartDate = ISNULL(@LabResults_StartDate , ''1-01-1997'')
		SET @LabResults_EndDate = ISNULL(@LabResults_EndDate, getdate()) 
	
		--SELECT @LabResults_StartDate = dbo.getPracticeUTCDateTime (@LabResults_StartDate)
		--SELECT @LabResults_EndDate =  DATEADD(DAY,1,dbo.getPracticeUTCDateTime(@LabResults_EndDate))
		
				
		DECLARE @ObservationItem1Start varchar(100)
		DECLARE @ObservationItem1End varchar(100)
			
		Set @ObservationItem1Start = ''0''
		Set @ObservationItem1End = ''999''
		
		If( @ObservationItem1Range IS NOT NULL AND LEN( @ObservationItem1Range) > 0 )
		BEGIN
			select @ObservationItem1Start = Element from Split(@ObservationItem1Range,''-'') where ElementID = 1
			select @ObservationItem1End = Element from Split(@ObservationItem1Range,''-'') where ElementID = 2
		END
		
		--if (@ObservationItem1Uid != ''00000000-0000-0000-0000-000000000000'' 
		--	OR 
		--	@ObservationItem2Uid != ''00000000-0000-0000-0000-000000000000''
		--	OR
		--	@ObservationItem3Uid != ''00000000-0000-0000-0000-000000000000''
		--	)
		if (@ObservationItem1Uid IS NOT NULL )
		BEGIN
			--IF (@LogicOpr1 =0 AND @LogicOpr2 =0)
			--BEGIN
			DECLARE @Result TABLE  
			(
				Result VARCHAR(1000),
				ObservationItemUid UNIQUEIDENTIFIER
			)
			DECLARE @DisplayResult Bit
			SET @DisplayResult=0
				--SELECT @LabResultList = 
				--		(substring(
				
						--(
						INSERT INTO @Result 
						SELECT PL.LabResult,PL.ObservationItemUid
						 FROM   [MDOL_RPT2_VIEW_PatientLabResults] PL 		
						 Where 
							PL.IsDelete = 0
				            AND
							@PersonUid = PL.PatientUid
							AND
							(
								PL.ObservationItemUid  in (Select element from dbo.Split (@ObservationItem1Uid,'','')) 
								AND PL.NumericObservationValue>=@ObservationItem1Start
								AND PL.NumericObservationValue<=@ObservationItem1End
								--AND ((IsNumeric(NumericObservationValue + ''e0'') = 1 AND CONVERT(NUMERIC,PL.NumericObservationValue)>=CONVERT(NUMERIC,@ObservationItem1Start)) OR (IsNumeric(NumericObservationValue + ''e0'') = 0 AND PL.NumericObservationValue>=@ObservationItem1Start))
								--AND ((IsNumeric(NumericObservationValue + ''e0'') = 1 AND CONVERT(NUMERIC,PL.NumericObservationValue)<=CONVERT(NUMERIC,@ObservationItem1End)) OR (IsNumeric(NumericObservationValue + ''e0'') = 0 AND PL.NumericObservationValue<=@ObservationItem1End))
								----Chayes: replaced both IsNUMERIC checks here while working with BRoberts due to truncation error in Patient List Excel report----
							)
							AND					
							PL.ResultDate >= @LabResults_StartDate AND PL.ResultDate < @LabResults_EndDate
							AND
						(@LaboratoryUid IS NULL OR PL.LaboratoryUid in (Select Element from dbo.Split(@LaboratoryUid,'','')))
						 order by PL.ResultDate
						 
						
						 --FOR XML PATH( '''' )
						 --), 2, 2500 ) )*/
						 
			--	END	

			IF EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem1Uid,'',''))) 
				SET @DisplayResult=1
				
			IF @DisplayResult=1 
			BEGIN
			SELECT @LabResultList = 
							(substring(
					
							( SELECT Result + '''' FROM @Result  FOR XML PATH( '''' )
							 ), 2, 2500 ) )	
			END	
			ELSE
				BEGIN
					SET @LabResultList=NULL
				END 
		END
		ELSE
		BEGIN --@ObservationItem1Uid IS NULL
		SELECT @LabResultList = 
				(substring(
				(SELECT ( '';'' + loi.Name + '': '' + coalesce(nullif(Convert(VARCHAR(50),ISNULL(ov.ObservationValue,'''')),''''),''N/A'') + '' Resulted: '' + (Convert(VARCHAR(50),oo.ResultDate,101)))
                 FROM    ObservationOrder oo 
				 INNER JOIN ObservationValue    ov  ON ov.ObservationOrderUid = oo.ObservationOrderUid 
				 INNER JOIN ListObservationItem loi ON loi.ObservationItemUid = ov.ObservationItemUid 
				 --INNER JOIN ListLOINC           ll  ON ll.LOINCUid            = loi.LOINCUid 
				 inner join Person				PR  ON PR.PersonUid			  = oo.PatientUid			
				 where 
				    oo.IsDelete = 0
				    AND
					@PersonUid = oo.PatientUid				 
					AND					
					oo.ResultDate >= @LabResults_StartDate AND oo.ResultDate < @LabResults_EndDate
					AND
					(@LaboratoryUid IS NULL OR oo.LaboratoryUid in (Select Element from dbo.Split(@LaboratoryUid,'','')))
				 order by oo.ResultDate
				 FOR XML PATH( '''' )
				 ), 2, 2500 ) )						 
		 END									 
		RETURN @LabResultList
END






' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getPatientLabResultProviderList]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




--DECLARE @A VARCHAR(MAX)
--SELECT @A=DBO.[UDF_getPatientLabResultList] (''A5C92A62-758F-4080-913D-0265CBCB48E7'',''4E10B5B4-262E-4138-9FAC-383A284E18A2'',''0-55'',0,''D273FB90-9738-4A7C-A101-B6FFB24D7D5A'','''',0,NULL,NULL,NULL,NULL,NULL)
--SELECT @A 
CREATE  FUNCTION [dbo].[UDF_getPatientLabResultProviderList]
(
	 @PersonUid UNIQUEIDENTIFIER = NULL
	 ,@ObservationItem1Uid varchar(max)= NULL --Modified to use observation item instead of 
	 ,@ObservationItem1Range varchar(max)
	 ,@LogicOpr1 bit=0
	 ,@ObservationItem2Uid varchar(max) = NULL --Modified to use observation item instead of 
	 ,@ObservationItem2Range varchar(max) = NULL
	 ,@LogicOpr2 bit=0
	 ,@ObservationItem3Uid varchar(max) = NULL --Modified to use observation item instead of 
	 ,@ObservationItem3Range varchar(max) = NULL
 	 ,@LabResults_StartDate datetime = NULL
	 ,@LabResults_EndDate datetime = NULL 
	 ,@LaboratoryUid varchar(max) = NULL
)
RETURNS  VARCHAR(Max)
AS 
BEGIN 
		DECLARE @LabResultList VARCHAR(Max) = ''N/A''
		IF @LaboratoryUid=''''
			SET @LaboratoryUid=NULL
		SET @LabResults_StartDate = ISNULL(@LabResults_StartDate , ''1-01-1997'')
		SET @LabResults_EndDate = ISNULL(@LabResults_EndDate, getdate()) 
	
		--SELECT @LabResults_StartDate = dbo.getPracticeUTCDateTime (@LabResults_StartDate)
		--SELECT @LabResults_EndDate =  DATEADD(DAY,1,dbo.getPracticeUTCDateTime(@LabResults_EndDate))
		
				
		DECLARE @ObservationItem1Start varchar(100)
		DECLARE @ObservationItem1End varchar(100)
		
		Set @ObservationItem1Start = ''0''
		Set @ObservationItem1End = ''999''
		
		If( @ObservationItem1Range IS NOT NULL AND LEN( @ObservationItem1Range) > 0 )
		BEGIN
			select @ObservationItem1Start = Element from Split(@ObservationItem1Range,''-'') where ElementID = 1
			select @ObservationItem1End = Element from Split(@ObservationItem1Range,''-'') where ElementID = 2
		END
		
		DECLARE @ObservationItem2Start varchar(100)
		DECLARE @ObservationItem2End varchar(100)
		
		Set @ObservationItem2Start = ''0''
		Set @ObservationItem2End = ''999''
		
		If( @ObservationItem2Range IS NOT NULL AND LEN(@ObservationItem2Range) > 0 )
		BEGIN
			select @ObservationItem2Start = Element from Split(@ObservationItem2Range,''-'') where ElementID = 1
			select @ObservationItem2End = Element from Split(@ObservationItem2Range,''-'') where ElementID = 2
		END
		
		DECLARE @ObservationItem3Start varchar(100)
		DECLARE @ObservationItem3End varchar(100)
		
		If( @ObservationItem3Range IS NOT NULL AND LEN( @ObservationItem3Range) > 0 )
		BEGIN
			select @ObservationItem3Start = Element from Split(@ObservationItem3Range,''-'') where ElementID = 1
			select @ObservationItem3End = Element from Split(@ObservationItem3Range,''-'') where ElementID = 2
		END
		

		--if (@ObservationItem1Uid != ''00000000-0000-0000-0000-000000000000'' 
		--	OR 
		--	@ObservationItem2Uid != ''00000000-0000-0000-0000-000000000000''
		--	OR
		--	@ObservationItem3Uid != ''00000000-0000-0000-0000-000000000000''
		--	)
		if (@ObservationItem1Uid IS NOT NULL  
			OR 
			@ObservationItem2Uid IS NOT NULL  
			OR
			@ObservationItem3Uid IS NOT NULL  
			)
		BEGIN
			--IF (@LogicOpr1 =0 AND @LogicOpr2 =0)
			--BEGIN
			DECLARE @Result TABLE  
			(
				OrderProviderUid VARCHAR(1000),
				ObservationItemUid UNIQUEIDENTIFIER
			)
			DECLARE @DisplayResult Bit
			SET @DisplayResult=0
				--SELECT @LabResultList = 
				--		(substring(
				
						--(
						INSERT INTO @Result 
						SELECT OrderProviderUid,PL.ObservationItemUid
						 FROM   [MDOL_RPT2_VIEW_PatientLabResultsWithProvider] PL 		
						 Where 
							PL.IsDelete = 0
				            AND
							@PersonUid = PL.PatientUid
							AND
							(
								(
								PL.ObservationItemUid  in (Select element from dbo.Split (@ObservationItem1Uid,'','')) 
								AND PL.NumericObservationValue>=@ObservationItem1Start
								AND PL.NumericObservationValue<=@ObservationItem1End
								)
								OR
								(
									PL.ObservationItemUid in (Select element from dbo.Split (@ObservationItem2Uid,'','')) 
									AND PL.NumericObservationValue>=@ObservationItem2Start
									AND PL.NumericObservationValue<=@ObservationItem2End
									
								)
								OR
								(
									PL.ObservationItemUid in (Select element from dbo.Split (@ObservationItem3Uid,'','')) 
									AND PL.NumericObservationValue>=@ObservationItem3Start
									AND PL.NumericObservationValue<=@ObservationItem3End
							
								)
							)					 
							AND					
							PL.ResultDate >= @LabResults_StartDate AND PL.ResultDate < @LabResults_EndDate
							AND
						(@LaboratoryUid IS NULL OR PL.LaboratoryUid in (Select Element from dbo.Split(@LaboratoryUid,'','')))
						 order by PL.ResultDate
						 						
						 --FOR XML PATH( '''' )
						 --), 2, 2500 ) )*/
						 
			--	END	
			IF (@LogicOpr1 =1 AND @LogicOpr2 =1)
			BEGIN
				IF EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem1Uid,'',''))  OR @ObservationItem1Uid IS NULL) AND EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem2Uid,'',''))  OR @ObservationItem2Uid IS NULL) AND EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem3Uid,'',''))  OR @ObservationItem3Uid IS NULL)
					SET @DisplayResult=1
			END
			IF (@LogicOpr1 =1 AND @LogicOpr2 =0)
			BEGIN
				IF EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem1Uid,'',''))  OR @ObservationItem1Uid IS NULL) AND EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem2Uid,'',''))  OR @ObservationItem2Uid IS NULL) OR EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem3Uid,'',''))  OR @ObservationItem3Uid IS NULL)
					SET @DisplayResult=1
			END	
			IF (@LogicOpr1 =0 AND @LogicOpr2 =1)
			BEGIN
				IF EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem1Uid,'',''))  OR @ObservationItem1Uid IS NULL) OR EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem2Uid,'',''))  OR @ObservationItem2Uid IS NULL) AND EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem3Uid,'',''))  OR @ObservationItem3Uid IS NULL)
					SET @DisplayResult=1
			END			
			IF (@LogicOpr1 =0 AND @LogicOpr2 =0)
			BEGIN
				--IF EXISTS() OR EXISTS() OR EXISTS()
					SET @DisplayResult=1
			END		
			IF @DisplayResult=1 
			BEGIN
			SELECT @LabResultList = 
						(substring(			
						( SELECT OrderProviderUid + '';'' FROM @Result  FOR XML PATH( '''' )
						 ), 1, 2500 ) )	
			END	
			ELSE
				BEGIN
				SET @LabResultList=NULL
				END 
		END
		ELSE
		BEGIN
		SELECT @LabResultList = 
				(substring(
				(SELECT ( '';'' + convert(varchar(40),oo.OrderProviderUid))
                 FROM    ObservationOrder oo 
				 INNER JOIN ObservationValue    ov  ON ov.ObservationOrderUid = oo.ObservationOrderUid 
				 INNER JOIN ListObservationItem loi ON loi.ObservationItemUid = ov.ObservationItemUid 
				 --INNER JOIN ListLOINC           ll  ON ll.LOINCUid            = loi.LOINCUid 
				 inner join Person				PR  ON PR.PersonUid			  = oo.PatientUid		
				 --LEFT JOIN ViewPersonNamesSub OrderProvider WITH (NOEXPAND) ON oo.OrderProviderUid = OrderProvider.PersonUid	
				 where 
				    oo.IsDelete = 0
				    AND
					@PersonUid = oo.PatientUid				 
					AND					
					oo.ResultDate >= @LabResults_StartDate AND oo.ResultDate < @LabResults_EndDate
					AND
					(@LaboratoryUid IS NULL OR oo.LaboratoryUid in (Select Element from dbo.Split(@LaboratoryUid,'','')))
				 order by oo.ResultDate
				 FOR XML PATH( '''' )
				 ), 2, 2500 ) )						 
		 END

		 --remove trailing semicolon
		 set @LabResultList = (select case when right(@LabResultList,1) = '';'' then substring(@LabResultList,1,len(@LabResultList)-1)
							   else @LabResultList END)

		RETURN @LabResultList
END






' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getServiceCode]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE    FUNCTION [dbo].[UDF_getServiceCode]
(
	@SuperBillUID UNIQUEIDENTIFIER,
	@ServiceCount INT
)
RETURNS UNIQUEIDENTIFIER
AS
BEGIN
	DECLARE @Count INT
	DECLARE @RetValue UNIQUEIDENTIFIER
	
	DECLARE CUR_ServiceUID CURSOR FOR
		SELECT sbp.SuperBillProcedureUID 
		FROM SuperBillProcedure sbp
		INNER JOIN ListProcedure lp
		ON sbp.ProcedureUID = lp.ProcedureUID
		WHERE lp.Inactive = 0 
		AND sbp.DontClaim = 0
		AND sbp.Inactive = 0
		AND sbp.SuperBillUID = @SuperBillUID
		--AND sbp.DisplayOrder > @ServiceCount
		ORDER BY sbp.DisplayOrder
	OPEN CUR_ServiceUID 
	FETCH NEXT FROM CUR_ServiceUID INTO @RetValue
	SET @Count = 0
	WHILE @@FETCH_STATUS = 0 
		BEGIN
			SET @Count = @Count + 1
			IF @Count <> @ServiceCount
				BEGIN
					FETCH NEXT FROM CUR_ServiceUID INTO @RetValue
					
				END
			ELSE
				BEGIN
					BREAK
				END
		END

	CLOSE CUR_ServiceUID
	DEALLOCATE CUR_ServiceUID
	
	--SET @Count = @Count - 1
	IF @Count <> @ServiceCount
		BEGIN
			SET @RetValue = ''00000000-0000-0000-0000-000000000000''
		END

	RETURN @RetValue
END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getSunday]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[UDF_getSunday]
 (@dateForSunday DATETIME,
 @isAPR INT)  

RETURNS DATETIME 
 AS  

BEGIN 
	RETURN dbo.Date_Sunday(@dateForSunday,@isAPR)
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getSuperbillProcedureModifier]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[UDF_getSuperbillProcedureModifier]
(
	@SuperbillUid UNIQUEIDENTIFIER ,
	@SuperbillProcedureUid UNIQUEIDENTIFIER
)
RETURNS VARCHAR(255)
AS
BEGIN
	DECLARE @retVal VARCHAR(255)
	SET @retVal = ''''
	SELECT @retVal = @retVal + CASE WHEN LEN (@retVal) > 0 THEN '', '' ELSE '''' END + COALESCE(lpm.ANSICode, '''')
	FROM Superbill AS sb
		LEFT JOIN SuperBillProcedure AS sbp ON sb.SuperbillUid = sbp.SuperbillUid AND COALESCE(sbp.DontClaim,0) = 0
		LEFT JOIN SuperbillProcedureModifier sbpm ON sbp.SuperbillProcedureUid = sbpm.SuperbillProcedureUid
		LEFT JOIN ListProcedureModifier lpm ON sbpm.ProcedureModifierUid = lpm.ProcedureModifierUid
	WHERE sb.Superbilluid = @SuperbillUid
		AND sbpm.SuperbillProcedureUid = @SuperbillProcedureUid
	ORDER BY sbpm.DisplayOrder
	RETURN(@retVal)
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getUPIN]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_getUPIN]
(
   @ProviderUid uniqueidentifier
)
returns Varchar(50)
BEGIN
  DECLARE @Value Varchar(50)
  SELECT @Value=ISNULL(Claimformatvalue.value,'''') FROM ClaimFormatValue 
  WHERE ProviderUid=@ProviderUid
         AND ClaimFormatValueTypeUid=''BE3AAE71-5565-4EDC-A166-3D7B688548B9''
  Return @Value
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getVisitDocumentedCPTCode]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE  FUNCTION [dbo].[UDF_getVisitDocumentedCPTCode]
(
	@VisitUid		UNIQUEIDENTIFIER,
	@PQRIMeasureUID UNIQUEIDENTIFIER
)
RETURNS  VARCHAR(Max)
AS 
BEGIN 
		DECLARE @SPCode VARCHAR(Max)
		
		SELECT -- Procedure
			@SPCode= COALESCE(@SPCode + '', '', '''') + LP.Code
		FROM
			MDOL_RPT2_VIEW_GetCodeForPQRI A
		JOIN
			ListProcedure LP
		ON
			A.ProcedureUID=LP.ProcedureUID
		WHERE 
			VisitUID=@VisitUid
		AND
			A.DocumentedCPT=1
		AND
			PQRIMeasureUID=@PQRIMeasureUID
		RETURN @SPCode
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getVisitICD9]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE  FUNCTION [dbo].[UDF_getVisitICD9]
(
	@VisitUid UNIQUEIDENTIFIER
)
RETURNS  VARCHAR(Max)
AS 
BEGIN 
		DECLARE @ICD9 VARCHAR(Max)
		
		SELECT -- Procedure
			@ICD9= COALESCE(@ICD9 + '', '', '''') + VD.Code
		FROM
			VisitDiagnosis VD
		WHERE 
			VD.VisitUID=@VisitUid
		RETURN @ICD9
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getVisitICD9s]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_getVisitICD9s]
(
	@PatientUid UNIQUEIDENTIFIER,
	@StartDate DATE
)
RETURNS  VARCHAR(Max)
AS 
BEGIN 
		DECLARE @ICD9 VARCHAR(Max)
		
		SELECT		@ICD9= COALESCE(@ICD9 + '', '', '''') + vd.Code
		FROM		Visit v INNER JOIN VisitDiagnosis vd ON v.VisitUid = vd.VisitUid
		WHERE		v.PatientUid = @PatientUid AND
					(v.VisitDate > @StartDate OR @StartDate IS NULL)
		ORDER BY	v.VisitDate, vd.DisplayOrder
		
		RETURN @ICD9
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getVisitProcedureCPTCode]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE  FUNCTION [dbo].[UDF_getVisitProcedureCPTCode]
(
   @VisitUid UNIQUEIDENTIFIER
)
RETURNS  VARCHAR(Max)
AS
BEGIN
      DECLARE @SPCode VARCHAR(Max)

      SELECT -- Procedure
         @SPCode= COALESCE(@SPCode + '', '', '''') + LP.Code
      FROM
         VisitProcedure A
      JOIN
         ListProcedure LP
      ON
         A.ProcedureUID=LP.ProcedureUID
      WHERE
         A.VisitUID=@VisitUid
      RETURN @SPCode
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getVisitProcedureModifier]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
--Return the Procedure Modifier



CREATE  FUNCTION [dbo].[UDF_getVisitProcedureModifier](@VisitProcedureUid UNIQUEIDENTIFIER)
RETURNS  VARCHAR(8000)


AS
BEGIN
   DECLARE @ProcedureModifier VARCHAR(8000)

   SELECT @ProcedureModifier =
      (CASE WHEN LPM1.Modifier IS NULL THEN ''''
            ELSE LPM1.Modifier
      END )
      +
      (CASE WHEN LPM2.Modifier IS NULL THEN ''''
            ELSE '','' + LPM2.Modifier
      END)
      +
      (CASE WHEN LPM3.Modifier IS NULL THEN ''''
            ELSE '', '' + LPM3.Modifier
      END )
      +
      (CASE WHEN LPM4.Modifier IS NULL THEN ''''
            ELSE '', '' + LPM4.Modifier
      END)

   FROM VisitProcedure
   Left Join ListProcedureModifier LPM1 ON VisitProcedure.ProcedureModifier1Uid = LPM1.ProcedureModifierUid
   Left Join ListProcedureModifier LPM2 ON VisitProcedure.ProcedureModifier2Uid = LPM2.ProcedureModifierUid
   Left Join ListProcedureModifier LPM3 ON VisitProcedure.ProcedureModifier3Uid = LPM3.ProcedureModifierUid
   Left Join ListProcedureModifier LPM4 ON VisitProcedure.ProcedureModifier4Uid = LPM4.ProcedureModifierUid
   WHERE VisitProcedureUid = @VisitProcedureUid

   RETURN @ProcedureModifier
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_HeightWeightRefused]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_HeightWeightRefused](@VisitUid UNIQUEIDENTIFIER) 
	RETURNS BIT 
	AS
BEGIN
	DECLARE @Refused BIT = 0

	SELECT @Refused=MAX(s.Refused)
	FROM
	(
	SELECT CASE WHEN ov.Modifier2Name = ''refused'' THEN 1 ELSE 0 END AS Refused
	FROM ObservationValue ov
	WHERE ov.VisitUid=@VisitUid
		AND ov.ObservationItemUid IN(''00000000-0000-0000-7777-100000000070'',''00000000-0000-0000-7777-100000000071'')
	) AS s

	RETURN @Refused
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_HL7_GetCSV]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[UDF_HL7_GetCSV] 
	(@ParseString VARCHAR(25))  
RETURNS VARCHAR(25) 
AS  

BEGIN 
	DECLARE @StrLen INT
	DECLARE @TempValue VARCHAR(10)

	-- Get the length of the String till first comma, reduce it by one
	SET @StrLen = CHARINDEX('','',@ParseString)
	
	IF @StrLen >= 0
	BEGIN		
		
		SET @StrLen = @StrLen - 1
		IF (@StrLen<=0)
		BEGIN
			SET @StrLen = LEN(@ParseString)
		END
		SET @TempValue = SUBSTRING(@ParseString,1,@StrLen)
	
		--Trancate the entered data from the Modifiers string
		SET @ParseString = REPLACE(@ParseString, @TempValue, '''')
	
		IF ((@ParseString IS NOT NULL ) AND (LEN(@ParseString)>0))
		BEGIN
			SET @ParseString = RIGHT(@ParseString,LEN(@ParseString)-1)
		END
	END -- End of If statement

	RETURN @TempValue + ''----'' + @ParseString
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_HL7GetDiags]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

  
  
  
  
CREATE FUNCTION [dbo].[UDF_HL7GetDiags]   
 (@VisitProcedureUid UNIQUEIDENTIFIER,  
 @VisitUid UNIQUEIDENTIFIER)    
RETURNS VARCHAR(70)  
AS  
  
/*  
Purpose: To return all or Primary diags for a procedure in DFT  
Created On: 20050928  
LastModified On: 20051003  
Modifications Made: 1. For NEO - returning Uid  
Special Comment:  
*/  
  
BEGIN  
 DECLARE @SPDiags VARCHAR(70)  
  
 IF (SELECT COUNT(*) FROM VisitDiagnosis WHERE VisitUid = @VisitUid) =  
  (SELECT COUNT(*) FROM VisitProcedureDiagnosis WHERE VisitProcedureUid = @VisitProcedureUid AND DisplayOrder <> 0)  
 BEGIN  
  SET @SPDiags =NULL  
 END  
  
 ELSE  
 BEGIN  
    
  SELECT @SPDiags =VD.Code + ''::'' + VD.Code   
  FROM VisitProcedure vp   
  LEFT JOIN VisitProcedureDiagnosis vpd ON vpd.VisitProcedureUid = vp.VisitProcedureUid    
   AND vpd.DisplayOrder = 1  
  LEFT JOIN VisitDiagnosis vd ON vd.VisitDiagnosisUid = vpd.VisitDiagnosisUid AND vd.VisitUid = vp.VisitUid  
  
  WHERE vp.VisitProcedureUid = @VisitProcedureUid  
    
 END  
  
 RETURN @SPDiags  
END  
  
  
  
  
  
  
  


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_HL7GetFT1Diagnosis]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[UDF_HL7GetFT1Diagnosis](@VisitProcedureUid UNIQUEIDENTIFIER)  
RETURNS VARCHAR(MAX) -- Bug #33408
AS  
BEGIN  
  
 DECLARE @DiagsCode VARCHAR(15)  
 DECLARE @AttachedCode VARCHAR(MAX) -- Bug #33408
  
 SET @AttachedCode =''''  
  
 DECLARE Diags_CUR CURSOR FOR   
  SELECT TOP 8 ISNULL(vd.Code10,vd.Code)	  --ld.DiagnosisCode9   
  FROM VisitProcedureDiagnosis vpd   
  INNER JOIN VisitDiagnosis vd ON vd.VisitDiagnosisUid = vpd.VisitDiagnosisUid  
  --INNER JOIN ListDiagnosis ld ON ld.DiagnosisUid = vd.DiagnosisUid  
  WHERE vpd.VisitProcedureUid = @VisitProcedureUid AND vpd.DisplayOrder <> 0  
  ORDER BY vpd.DisplayOrder  
 OPEN Diags_CUR  
  
 FETCH NEXT FROM Diags_CUR INTO @DiagsCode  
  
 WHILE @@FETCH_STATUS =0  
 BEGIN  
  IF @AttachedCode = ''''  
   SET @AttachedCode = @DiagsCode  
  ELSE  
   SET @AttachedCode = @AttachedCode + '',''  +@DiagsCode  
  
  FETCH NEXT FROM Diags_CUR INTO @DiagsCode  
 END  
  
 CLOSE Diags_CUR  
 DEALLOCATE Diags_CUR  
  
 RETURN @AttachedCode  
END ' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_HL7GetFT1Modifiers]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[UDF_HL7GetFT1Modifiers](@VisitProcedureUid UNIQUEIDENTIFIER)
RETURNS VARCHAR(30)
AS
BEGIN
	DECLARE @AttachedMod VARCHAR(30)

	SET @AttachedMod =''''

	SELECT @AttachedMod = CASE WHEN ISNULL(lm.ANSICode,'''') <> '''' THEN lm.ANSICode + '','' 
				ELSE '''' END +
				CASE WHEN ISNULL(lm2.ANSICode,'''') <> '''' THEN lm2.ANSICode + '','' 
				ELSE '''' END + 
				CASE WHEN ISNULL(lm3.ANSICode,'''') <> '''' THEN lm3.ANSICode + '','' 
				ELSE '''' END +
				CASE WHEN ISNULL(lm4.ANSICode,'''') <> '''' THEN lm4.ANSICode 
				ELSE '''' END
		FROM VisitProcedure vp
		LEFT JOIN ListProcedureModifier  lm ON lm.ProcedureModifierUid = vp.ProcedureModifier1Uid
		LEFT JOIN ListProcedureModifier lm2 ON lm2.ProcedureModifierUid = vp.ProcedureModifier2Uid
		LEFT JOIN ListProcedureModifier lm3 ON lm3.ProcedureModifierUid = vp.ProcedureModifier3Uid
		LEFT JOIN ListProcedureModifier lm4 ON lm4.ProcedureModifierUid = vp.ProcedureModifier4Uid
		WHERE vp.VisitProcedureUid = @VisitProcedureUid

	IF RIGHT(@AttachedMod, 1) = '',''
		SET @AttachedMod = SUBSTRING(@AttachedMod, 1, LEN(@AttachedMod)-1)

	RETURN @AttachedMod
END







' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_IsSameDay]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[UDF_IsSameDay] (@dtDate1 datetime, @dtDate2 datetime)
RETURNS int AS
BEGIN
RETURN dbo.Date_SameDay(@dtDate1,@dtDate2)
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_matchProcCode]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_matchProcCode](
          @Code NVARCHAR(30),
          @CodeList NVARCHAR(MAX)
) 
returns bit         AS
BEGIN
--DECLARE  @Code NVARCHAR(30)
--DECLARE  @CodeList NVARCHAR(MAX)
--set @Code = '' 0001F''
--set @CodeList = ''81000, 82000-82500, 83000; 84000; 0001F''

declare @ret bit
set @ret = 0

IF ( NULLIF(@CodeList, '''') IS NOT NULL )
BEGIN
	DECLARE @T TABLE
	(
	 id INT IDENTITY(1,1), 
	 val1 NVARCHAR(MAX), 
	 val2 NVARCHAR(MAX),
	 int1 int,
	 int2 int
	)

	SET @Code = REPLACE( @Code, '' '', '''') ;
	SET @CodeList = REPLACE( @CodeList, '';'', '','' ) ;
	SET @CodeList = REPLACE( @CodeList, '' '', '''') ;
	--select @CodeList

	declare @x2 nvarchar(max)
	set @x2 =   N''<t><a>'' + REPLACE(@CodeList,'','',''</a></t><t><a>'') + ''</a></t>''
	--select @x2

	DECLARE @xml XML
	SET @xml = REPLACE(@x2, ''-'', ''</a><a>'')

	--SELECT @xml

	INSERT INTO @t(val1, val2)
		select  --T.c.query(''.'') AS result
		T.c.value(''a[1]'', ''VARCHAR(MAX)'') AS v1,
		T.c.value(''a[2]'', ''VARCHAR(MAX)'') AS v2
	from @xml.nodes(''/t'') T(c)

	UPDATE @T
		SET val2 = COALESCE(val2, val1),
			int1 = CASE WHEN (ISNUMERIC(val1)=1) THEN CONVERT(INT, val1) ELSE NULL END,
			int2 = CASE WHEN (ISNUMERIC(COALESCE(val2,val1))=1) THEN CONVERT(INT, COALESCE(val2,val1)) ELSE NULL END
	FROM @T

	--select * from @T

	IF (ISNUMERIC(@Code)=1 )
	BEGIN
		DECLARE @codeInt int
		SET @codeInt = CONVERT(INT, @Code) 

		IF EXISTS(SELECT TOP 1 id 
					FROM @T 
					WHERE int1 IS NOT NULL		
						AND @codeInt >= int1
						AND @codeInt <= int2)
		BEGIN
			SET @ret = 1
		END
	END
	ELSE
	BEGIN
		IF EXISTS( SELECT TOP 1 id 
				   FROM @T
				   WHERE ( val1 = @Code OR val2 = @Code ))
		BEGIN
			SET @ret = 1
		END
	END
END

--select @ret
RETURN @ret
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_MDOL_RPT2_getCPTCode]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_MDOL_RPT2_getCPTCode]
(
 @SuperbillUid UNIQUEIDENTIFIER
)
RETURNS VARCHAR(255)
AS
BEGIN
	DECLARE @retVal VARCHAR(255)

	SELECT @retVal = ''''

		SELECT @retVal = @retVal + CASE WHEN LEN (@retVal) > 0 THEN '', '' ELSE '''' END + lp.Code 
		FROM ListProcedure AS lp WITH (NOLOCK)
		INNER JOIN SuperBillProcedure AS sp WITH (NOLOCK) ON lp.ProcedureUid = sp.ProcedureUid
		WHERE sp.SuperBillUid = @SuperbillUid
		ORDER BY sp.DisplayOrder
	RETURN(@retVal)
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_mergeGUIDs]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- 2015-08-11 Bug 39137 Bug 39137: While in payment entry changing the insurance to secondary insurance repeats multiple Primary and Secondary payers
CREATE FUNCTION [dbo].[UDF_mergeGUIDs]
(
 @guid1 UNIQUEIDENTIFIER,
 @guid2 UNIQUEIDENTIFIER

)
RETURNS UNIQUEIDENTIFIER
AS
BEGIN
-- variables
declare @vb1 binary(16), @vb2 binary(16), @lo binary(8), @hi binary(8)

-- split every 8 bytes into a binary(8), which is a bigint, the largest size usable with XOR
select @vb1 = @guid1, @vb2 = @guid2

-- xor the high and low parts separately
select @hi = convert(binary(8), substring(@vb1,1,8)) ^ convert(bigint, substring(@vb2,1,8))
select @lo = convert(binary(8), substring(@vb1,9,8)) ^ convert(bigint, substring(@vb2,9,8))

-- the final result, concatenating the bytes using char(8) - binary -> uniqueidentifier
RETURN( convert(uniqueidentifier, @hi + @lo)  )
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_MinVersionPRM]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[UDF_MinVersionPRM] 
(
	@MinPRMVersion VARCHAR(20)
	,@MinPRMSeq INT
)
RETURNS BIT
AS
BEGIN
/*
	IF dbo.UDF_MinVersionPRM(''14.0.0'',603) = 1
		SELECT ''TRUE''
*/
	DECLARE @MetMinimum BIT = 0
		,@PRMVersion VARCHAR(20)
		,@PRMSeq INT

	select @PRMVersion=PRMVersion,@PRMSeq=PRMSeq
	from versionprm
	where [status] = 0
		and PRMVersion >= @MinPRMVersion

	IF (
		(@PRMVersion > @MinPRMVersion) 
		OR (
			(@PRMVersion = @MinPRMVersion)
			AND (@PRMSeq >= @MinPRMSeq)
			)
		)
	BEGIN
		SET @MetMinimum = 1
	END

	RETURN @MetMinimum

	--select TOP 1 *
	--from 
	--	(
	--	values(''14.0.0''),(''14.0.1''),(''14.1.0''),(''15.0.0''),(''15.0.1''),(''14.0.01''),(''14.01.0''),(''15.1.0''),(''15.10.0''),(''14.10.10'')
	--	) AS T(c)
	--WHERE c >= ''14.1.0''
	--order by c DESC
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_PatientTimespanVisits]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_PatientTimespanVisits] (
	@PatientUid UNIQUEIDENTIFIER
	,@StartDate DATE
	,@EndDate DATE
	,@ProviderUid UNIQUEIDENTIFIER
	,@ProviderBilling BIT = 1
)
RETURNS INT
BEGIN
	DECLARE @VisitCnt INT = 0
	DECLARE @VisitTypeStrikeOut UNIQUEIDENTIFIER = ''FB954167-9D1C-43B7-9F5B-A76260654C96''
	
	SELECT @VisitCnt = COUNT(DISTINCT v.VisitUid)
	FROM Visit v
	WHERE v.PatientUid = @PatientUid
		AND v.VisitDate BETWEEN @StartDate AND @EndDate
		AND (v.VisitTypeUid is null or v.VisitTypeUid != @VisitTypeStrikeOut)
		AND (
			(v.ProviderUid = @ProviderUid AND @ProviderBilling = 1) 
			OR (v.RenderingProviderUid = @ProviderUid AND @ProviderBilling = 0) 
			OR @ProviderUid IS NULL
			)

	RETURN @VisitCnt
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_PayerPlanofFeeSchedule]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[UDF_PayerPlanofFeeSchedule]
(
 @corporationUID UNIQUEIDENTIFIER,
 @FeeScheduleUID UNIQUEIDENTIFIER
)
RETURNS VARCHAR(255)
AS
BEGIN
	DECLARE @retVal VARCHAR(255)
			

	SELECT @retVal = ''''

	
	BEGIN
		SELECT @retVal = @retVal + CASE WHEN LEN (@retVal) > 0 THEN '', '' ELSE '''' END + IP.name
		FROM 
				Insuranceplan AS IP
		LEFT JOIN
			Corporation C
		ON
			IP.InsuranceCarrierUID = C.CorporationUID
		
		where C.CorporationUID=@corporationUID and IP.FeeScheduleUID=@FeeScheduleUId
	END

	RETURN(@retVal)
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_RowCount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[UDF_RowCount] 
(	@TableName VARCHAR(200)	)
RETURNS INT
AS
BEGIN
	DECLARE @count int
	SELECT @count  = SUM(row_count) FROM sys.dm_db_partition_stats (nolock) WHERE object_id = OBJECT_ID(@TableName)  AND index_id < 2
	RETURN @count
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_SendValue]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[UDF_SendValue]
(
  @ClaimFormatGUID UNIQUEIDENTIFIER,  
  @ExportFormatType INT, 
  @ClaimFormatOptionType INT,
  @SuperbilUid UNIQUEIDENTIFIER
)
RETURNS bit
BEGIN			
		DECLARE @IsSend  bit
		DECLARE @CNT INT
		DECLARE @start AS VARCHAR(50)
        DECLARE @end   AS VARCHAR(50)
		DECLARE @Codes AS VARCHAR(2048)	
		SET @IsSend=0

         
	IF @ExportFormatType = 1    --For Electronic Claims   				
	  BEGIN 
			IF @ClaimFormatOptionType =1  --For CLIA
			  BEGIN 			
				 SELECT  @Codes=CFO.Codes					
				 FROM ClaimFormatOption CFO LEFT JOIN ListClaimFormatOptionType LCFOT ON LCFOT.ClaimFormatOptionTypeUid = CFO.ClaimFormatOptionTypeUid
				 WHERE LCFOT.ClaimFormatOptionTypeUid=''C1242602-6CC4-475E-AEC9-E4C1A68D5E02'' AND CFO.ClaimFormatUid = @ClaimFormatGUID--''7D707B6E-A7ED-4512-BE96-351F4ABF4E32''
              END
			ELSE
           IF @ClaimFormatOptionType =2 --For Mammography Cert
             BEGIN
			    SELECT  @Codes=CFO.Codes
			    FROM ClaimFormatOption CFO LEFT JOIN ListClaimFormatOptionType LCFOT ON LCFOT.ClaimFormatOptionTypeUid = CFO.ClaimFormatOptionTypeUid
			    WHERE LCFOT.ClaimFormatOptionTypeUid= ''A085AFF1-B0D9-420B-AA4D-BA5F38B5E780'' AND CFO.ClaimFormatUid = @ClaimFormatGUID--''7D707B6E-A7ED-4512-BE96-351F4ABF4E32''
             END
      END 

    ELSE IF @ExportFormatType = 2 --For Paper Claims
          BEGIN 
			IF @ClaimFormatOptionType =1  --For CLIA
			  BEGIN 			
				 SELECT  @Codes=CFO.Codes					
				 FROM ClaimFormatOption CFO LEFT JOIN ListClaimFormatOptionType LCFOT ON LCFOT.ClaimFormatOptionTypeUid = CFO.ClaimFormatOptionTypeUid
				 -- WHERE LCFOT.ClaimFormatOptionTypeUid=''3DB4865A-5F8A-403B-8595-281333D1211B'' AND CFO.ClaimFormatUid = @ClaimFormatGUID--''7D707B6E-A7ED-4512-BE96-351F4ABF4E32''
				 -- 3DB4865A-5F8A-403B-8595-281333D1211B is for Paper CMS-1500 5010
				 -- CBE4212E-51F2-4500-AE51-E2D7A1694559 is for Paper CMS-1500
				 WHERE LCFOT.ClaimFormatOptionTypeUid in (''3DB4865A-5F8A-403B-8595-281333D1211B'',''CBE4212E-51F2-4500-AE51-E2D7A1694559'') AND CFO.ClaimFormatUid = @ClaimFormatGUID--''7D707B6E-A7ED-4512-BE96-351F4ABF4E32''

              END
			ELSE
           IF @ClaimFormatOptionType =2 --For Mammography Cert
             BEGIN
			    SELECT  @Codes=CFO.Codes
			    FROM ClaimFormatOption CFO LEFT JOIN ListClaimFormatOptionType LCFOT ON LCFOT.ClaimFormatOptionTypeUid = CFO.ClaimFormatOptionTypeUid
			    WHERE LCFOT.ClaimFormatOptionTypeUid= ''D9A7BE06-3862-4E68-915C-C95E9B6309A5'' AND CFO.ClaimFormatUid = @ClaimFormatGUID--''7D707B6E-A7ED-4512-BE96-351F4ABF4E32''
             END 
         END 
		--	      
		DECLARE @CPTCodes TABLE
			(
				CodeID	SMALLINT,  --Array index
	   			Code	   VARCHAR(50)	--Array element contents
			)

		IF @Codes IS NULL
        BEGIN
			RETURN 1
        END
		ELSE IF (CHARINDEX('';'',@Codes)<> 0 OR CHARINDEX('';'',@Codes)= 0)
        BEGIN
			INSERT INTO @CPTCodes             
					SELECT * FROM Split(@Codes,'';'')
        END
		ELSE IF (CHARINDEX('','',@Codes)<> 0 OR CHARINDEX('','',@Codes)= 0)
        BEGIN
			INSERT INTO @CPTCodes             
					SELECT * FROM Split(@Codes,'','')
        END
			--Check individual codes present in superbill	
		SELECT @CNT=count(*) FROM @CPTCodes C WHERE RTRIM(LTRIM(C.code)) IN (SELECT Code FROM listprocedure LP INNER JOIN superbillprocedure  SP ON 
				  LP.ProcedureUid=SP.ProcedureUid WHERE SP.SuperbillUid=@SuperbilUid) AND 
				  C.Code NOT LIKE ''%-%'' 
	  IF @CNT>0
	    SET @IsSend = 1
	  ELSE
	  BEGIN
			  DECLARE @CPTCode AS VARCHAR(50)
			  DECLARE @RangeCPTCodes TABLE
				(
					CodeID	SMALLINT,  --Array index
					Code	VARCHAR(50)	--Array element contents
				)

			  DECLARE @SuperbillCodes TABLE
						(							
	   						sCode	VARCHAR(50)	
						)

			  DECLARE  Cur_CodeRange CURSOR FOR
				SELECT Code FROM @CPTCodes where code like (''%-%'')
			  OPEN Cur_CodeRange 
		      
			  FETCH NEXT FROM Cur_CodeRange INTO @CPTCode		
					WHILE @@FETCH_STATUS=0
					BEGIN
						
						INSERT INTO @RangeCPTCodes 
							SELECT * FROM split(@CPTCode,''-'')
						--SELECT * FROM @RangeCPTCodes
						
                        INSERT INTO @SuperbillCodes SELECT Code 
													FROM listprocedure LP INNER JOIN superbillprocedure  SP ON LP.ProcedureUid=SP.ProcedureUid 
													WHERE SP.SuperbillUid=@SuperbilUid 
															AND SP.DontClaim = 0			-- if not sending, then don''t check

						SET @end=(SELECT TOP 1 code FROM @RangeCPTCodes ORDER BY code DESC)
                        SET @end=RTRIM(LTRIM(@end))
						SELECT @start=code FROM @RangeCPTCodes WHERE code !=@end
						SET @start=RTRIM(LTRIM(@start))

                        IF(ISNUMERIC(@start)<>0 AND ISNUMERIC(@end)<>0)
						  BEGIN 			
						   SELECT @CNT=COUNT(*) FROM @SuperbillCodes S WHERE ISNUMERIC(S.sCode)=1 
																				AND S.sCode != ''.'' -- if code is a dot then IsNumeric is 1 but can''t convert to Float
																				AND CONVERT(FLOAT, S.sCode) BETWEEN CONVERT(FLOAT,@start) AND CONVERT(FLOAT,@end) 
						 END
						ELSE IF (ISNUMERIC(@start)=0 AND ISNUMERIC(@end)=0)					
						  BEGIN
						   SELECT @CNT=COUNT(*) FROM @SuperbillCodes S WHERE S.sCode BETWEEN  @start AND @end 	
						  END

						IF @CNT>0
							 SET @IsSend=1    
					    DELETE  FROM @RangeCPTCodes
						DELETE FROM @SuperbillCodes       	         
						FETCH NEXT FROM Cur_CodeRange INTO @CPTCode
					END
			  CLOSE Cur_CodeRange
			  DEALLOCATE Cur_CodeRange  
	   END
		RETURN @IsSend

END		 ' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_TrimZeroes]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[UDF_TrimZeroes] ( @Input MONEY )
RETURNS VARCHAR(19)
AS
BEGIN
	DECLARE @z VARCHAR(19)		-- Eventual return value

	-- Remove leading and trailing zeroes
	--   1.  Cast to decimal with a precision of 3 places to right of decimal
	--   2.  Replace ALL zeroes with space character ( Assumes NO spaces will be returned in return value )
	--   3.  Trim leading ( LTRIM ) and trailing ( RTRIM ) spaces
	--   4.  Replace ( reconvert ) remaining/inner space characters back to zero
	SET @z = REPLACE(RTRIM(LTRIM(REPLACE( CAST(@Input AS DECIMAL(19,3)),  ''0'','' ''))),'' '',''0'') 

	-- Remove trailing decimal point if at end of string
	--   ( Same method as above but assume ''.'' rather than ''0''
	SET @z = REPLACE(RTRIM(REPLACE( @z,  ''.'','' '')),'' '',''.'')

	-- If everything replace then input was all zeroes so just return a ''0'' as string
	IF ( LEN(@z) = 0 ) RETURN ''0'';

	-- return calculated value
	RETURN @z
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_VisitRDADisclosureDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_VisitRDADisclosureDate] (
	@PatientUid UNIQUEIDENTIFIER
	,@VisitUid UNIQUEIDENTIFIER
	,@VisitDate DATE
	,@WithinDays INT = 1
)
RETURNS DATE
AS 
BEGIN
	DECLARE @DisclosureDate DATE = NULL
		,@MinDisclosureDate DATE = DATEADD(DAY,-1,@VisitDate)
		,@MaxDisclosureDate DATE = DATEADD(DAY,@WithinDays,@VisitDate)

	SELECT @DisclosureDate=MIN(rda.DisclosureDate)
	FROM RecordDisclosureAudit rda WITH(NOLOCK) 
	WHERE rda.DisclosureDate BETWEEN @MinDisclosureDate AND @MaxDisclosureDate
	-- JOIN on VisitUid OR PatientUid to handle bad data migration from 2014GA release to 2014PatchARC2
	-- Future entries and customers who never migrated to 2014PatchARC2 (14.0.0.561) do not need the OR
		AND (rda.PatientUid=@PatientUid	OR rda.VisitUid=@VisitUid)
		AND rda.DisclosureType in (1,    -- Complete Chart
									2,    -- Clinical Summary
									11)  -- ContinuityOfCareDocument

	RETURN @DisclosureDate
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDFCaseVisits]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
/********************************************************************************************/
/* UDFCaseVisits																			*/
/* Collates the visit dates associated with a patient case as a comma delimited string.		*/
/********************************************************************************************/
CREATE FUNCTION [dbo].[UDFCaseVisits]
(
	 @uid uniqueidentifier
)
RETURNS varchar(2000)
AS
begin

  declare @date DATETIME
  declare @dateBuilder varchar(2000)

  set @dateBuilder = ''''
  IF @uid IS NOT NULL
  BEGIN
    declare date_cursor cursor FAST_FORWARD for SELECT DISTINCT dbo.Visit.VisitDate
	  FROM dbo.PatientCase INNER JOIN dbo.Visit ON 
          dbo.PatientCase.PatientCaseUid = dbo.Visit.PatientCaseUid 
	  WHERE  dbo.PatientCase.PatientCaseUid = @uid

    open date_cursor

    fetch next from date_cursor INTO @date

    while (@@fetch_status <> -1)
    begin
      if (@@fetch_status <> -2)
      begin
        if len(@dateBuilder) > 0
        begin
          set @dateBuilder = @dateBuilder + '', ''
        end

		/* Convert date to local datetime & strip off hh:mm:ss from the date */
        set @dateBuilder = @dateBuilder + convert(varchar(11), @date, 101)

       end
     fetch next from date_cursor INTO @date
    end
    close date_cursor
    deallocate date_cursor
  END
  return @dateBuilder	
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDFGetProviderCLIA]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'





CREATE FUNCTION [dbo].[UDFGetProviderCLIA]
	(@ProviderUid UNIQUEIDENTIFIER)
RETURNS VARCHAR(255) AS
BEGIN

	DECLARE @CLIA VARCHAR(50)
	
	DECLARE @ClaimFormatValueTypeUid UNIQUEIDENTIFIER
	
	SELECT @ClaimFormatValueTypeUid = ClaimFormatValueTypeUid FROM ListClaimFormatValueType 
		WHERE Name LIKE  ''Clinical Laboratory Improvement Amendments (CLIA)''


	SELECT @CLIA = ISNULL(ClaimFormatValue.Value,'''') FROM ClaimFormatValue 
		WHERE ISNULL(ClaimFormatValue.ProviderUid, @ProviderUid) = @ProviderUid
		AND ClaimFormatValueTypeUid = @ClaimFormatValueTypeUid

	RETURN @CLIA
END







' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDFGetRelCCSystemSymptom]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE FUNCTION [dbo].[UDFGetRelCCSystemSymptom] (@systemUid [uniqueidentifier], @symptomUid [uniqueidentifier]) RETURNS uniqueidentifier AS
BEGIN

DECLARE @relCCSystemSymptomUid uniqueidentifier

	IF @systemUid IS NULL
		SELECT @relCCSystemSymptomUid = rel.RelCCSystemSymptomUid
		FROM			RelCCSystemSymptom rel INNER JOIN RelCCSymptomHpiCategory hpi ON rel.RelCCSystemSymptomUid = hpi.RelCCSystemSymptomUid
		WHERE			rel.CCSymptomUid = @symptomUid
		ORDER BY		rel.DisplayOrder
	ELSE
		SELECT	@relCCSystemSymptomUid = rel.RelCCSystemSymptomUid
		FROM	RelCCSystemSymptom rel
		WHERE	rel.CCSystemUid = @systemUid AND
				rel.CCSymptomUid = @symptomUid


	RETURN @relCCSystemSymptomUid
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDFPatientConditions]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


/********************************************************************************************/
/* UDFCaseVisits																			*/
/* Collates the PatientConditions associated with a patient as a comma delimited string.		*/
/********************************************************************************************/
CREATE FUNCTION [dbo].[UDFPatientConditions]
(
	 @patientUid uniqueidentifier
)
RETURNS varchar(MAX)
AS
begin

  declare @condition varchar(500)	
  declare @conditionBuilder varchar(MAX)
  set @conditionBuilder = ''''

  IF @patientUid IS NOT NULL
  BEGIN

	--Create a cursor on ListPatientCondition
	declare pc_cursor cursor FAST_FORWARD for 
	SELECT Name 
	FROM ListPatientCondition lpc
	INNER JOIN dbo.RelPatientCondition rpc ON rpc.PatientConditionUid = lpc.PatientConditionUid
	WHERE  rpc.PatientUid = @patientUid
	ORDER BY rpc.DisplayOrder asc

    open pc_cursor
    fetch next from pc_cursor INTO @condition

    while (@@fetch_status <> -1)
    begin
      if (@@fetch_status <> -2)
      begin
        if len(@condition) > 0 AND LEN(@conditionBuilder) > 0
        begin
          set @conditionBuilder = @conditionBuilder + '', ''
        end

        set @conditionBuilder = @conditionBuilder + @condition 

       end
     fetch next from pc_cursor INTO @condition
    end
    close pc_cursor
    deallocate pc_cursor
  END
  return @conditionBuilder	
end




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ufn_ProperCase]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ufn_ProperCase](@Text AS VARCHAR(8000)) 
 RETURNS VARCHAR(8000) 
 AS 
 BEGIN 
    -- declare some variables 
    DECLARE @Reset BIT; 
    DECLARE @Ret VARCHAR(8000); 
    DECLARE @i INT; 
    DECLARE @c VARCHAR(2); 
  
    -- specify reset 
    SELECT @Reset = 1, @i=1, @Ret = ''''; 
  
    IF (UPPER(@Text)=@Text Collate Latin1_General_CS_AI) 
 BEGIN 
  
 -- cycle through each character,  
 -- if non-alpha, uppercase next alpha character. 
 -- if alpha then lowercase subsequent alphas. 
 -- NON-ALPHA EXCEPTIONS ADDED TO REGEXP (eg. apostrophe) 
 WHILE (@i <= len(@Text)) 
                SELECT @c= substring(@Text,@i,1), 
                @Ret = @Ret + CASE WHEN @Reset=1 THEN UPPER(@c) ELSE LOWER(@c) END, 
                @Reset = CASE WHEN @c like ''[a-zA-Z'''']'' THEN 0 ELSE 1 END, 
                @i = @i +1 
  
 -- add a leading and trailing space to indicate word delimiters (bol & eol) 
 SET @Ret = '' '' + @Ret + '' ''; 
  
 -- Any character immediately after non-alpha is now in uppercase. 
 -- Base the following overrides/exceptions on this. 
  
 -- specify exceptions to be lowercased 
 SET @Ret = REPLACE(@Ret, '' And '', LOWER('' And '')); 
 SET @Ret = REPLACE(@Ret, '' At '', LOWER('' At '')); 
 SET @Ret = REPLACE(@Ret, '' Of '', LOWER('' Of '')); 
 SET @Ret = REPLACE(@Ret, '' The '', LOWER('' The '')); 
  
 -- specify exceptions to be uppercased 
 SET @Ret = REPLACE(@Ret, '' Bi '', UPPER('' BI ''));  -- Business Inteligence 
 SET @Ret = REPLACE(@Ret, '' Hr '', UPPER('' HR ''));  -- Human Resources 
 SET @Ret = REPLACE(@Ret, '' It '', UPPER('' IT ''));  -- Info Tech Services 
 SET @Ret = REPLACE(@Ret, '' Po '', UPPER('' PO ''));  -- PO Box
  
 -- specify exceptions to be custom cased: McDonalds, Mc Donalds 
 IF(@Ret LIKE ''% Mc%'') 
 BEGIN 
                SELECT @c = SUBSTRING(@Ret,CHARINDEX('' Mc'',@Ret)+3,1) 
 SET @Ret = REPLACE(@Ret, '' Mc''+LOWER(@c), '' Mc''+UPPER(@c)) 
 END 
  
 -- specify exceptions to be custom cased: O''Neils 
 IF(@Ret LIKE ''% O''''%'') 
 BEGIN 
                SELECT @c = SUBSTRING(@Ret,CHARINDEX('' O'''''',@Ret)+3,1) 
 SET @Ret = REPLACE(@Ret, '' O''''''+LOWER(@c), '' O''''''+UPPER(@c)) 
 END 
  
 -- specify exceptions to be custom cased: D''Artagnan 
 IF(@Ret LIKE ''% D''''%'') 
 BEGIN 
                SELECT @c = SUBSTRING(@Ret,CHARINDEX('' D'''''',@Ret)+3,1) 
 SET @Ret = REPLACE(@Ret, '' D''''''+LOWER(@c), '' D''''''+UPPER(@c)) 
 END 
  
 -- specify exceptions to be custom cased: I''Anson 
 IF(@Ret LIKE ''% I''''%'') 
 BEGIN 
                SELECT @c = SUBSTRING(@Ret,CHARINDEX('' I'''''',@Ret)+3,1) 
 SET @Ret = REPLACE(@Ret, '' I''''''+LOWER(@c), '' I''''''+UPPER(@c)) 
 END 
  
 -- remove leading and trailing spaces 
 SET @Ret = LTRIM(RTRIM(@Ret)); 
  
 END 
    ELSE 
     -- return the string unaffected if it is not in uppercase 
     SET @Ret=@Text 
  
    RETURN @Ret 
  
 END 
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[utcToCurrentDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[utcToCurrentDate] 
	(	
		@utcDate DATETIME,
		@inTimeZoneAdj INT,					-- the number of hours to adjust for the local timezone
		@bObserveDaylightSavings TINYINT	-- whether or not the local area observes US daylight savings time
	)  
RETURNS 
	DATETIME
AS  
BEGIN 
	RETURN	dbo.Date_UTCToLocal(@utcDate,@inTimeZoneAdj,@bObserveDaylightSavings)
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindCacheMachineOutstandingSuperbill]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ViewFindCacheMachineOutstandingSuperbill]
(
)
RETURNS @OutstandingSuperbill_TBL TABLE 
(
	[CacheMachineUid] [uniqueidentifier],
	[URL] [varchar](255),
	[Provider] [varchar](1024),
	[SuperbillCount] [INT]
)
AS
BEGIN
	DECLARE @Search_TBL TABLE
	(
		VisitDate DATETIME,
		VisitUid UNIQUEIDENTIFIER,
		PatientUid UNIQUEIDENTIFIER,
		ProviderUid UNIQUEIDENTIFIER,
		VisitProcedureCount int DEFAULT (0),
		VisitDiagnosisCount int DEFAULT (0),
		SuperbillExternalID VARCHAR (100) null,
		SuperbillCount int DEFAULT (0),
		SuperbillProcedureCount int DEFAULT (0),
		SuperbillDiagnosisCount int DEFAULT (0),
		Changes XML NULL
	)
	DECLARE @superbillStatusUid UNIQUEIDENTIFIER,
			@psuperbillStatusUid UNIQUEIDENTIFIER
	SELECT @superbillStatusUid = ''D2291C14-3F4E-4381-80A7-883C76C9499B'',
		   @psuperbillStatusUid = ''DF81BE7C-71CF-47F4-8573-733E81E30EA8''
		   
	INSERT @Search_TBL (VisitDate, VisitUid, PatientUid, ProviderUid)
	SELECT DISTINCT t.VisitDate, t.VisitUid, t.PatientUid, t.ProviderUid
	FROM Visit AS t WITH (NOLOCK) 
		INNER JOIN RelCacheMachineProvider AS t1 WITH (NOLOCK) ON t.ProviderUid = t1.ProviderUid
		INNER JOIN ListCacheMachine AS t2 ON t1.CacheMachineUid = t2.CacheMachineUid
			AND t2.Inactive = 0
		INNER JOIN Superbill AS t3 WITH (NOLOCK) ON t.VisitUid = t3.VisitUid
			AND t3.SuperbillStatusUid IN ( @superbillStatusUid, @psuperbillStatusUid)
			
	UPDATE @Search_TBL
		SET VisitProcedureCount = t1.VisitProcedureCount
	FROM @Search_TBL AS t
	CROSS APPLY
	(
		SELECT COUNT (*) AS VisitProcedureCount
		FROM VisitProcedure WITH (NOLOCK)
		WHERE VisitUid = t.VisitUid
			AND	IsPerformed = 1
			AND IsDelete = 0
	) AS t1

	UPDATE @Search_TBL
		SET VisitDiagnosisCount = t1.VisitDiagnosisCount
	FROM @Search_TBL AS t
	CROSS APPLY
	(
		SELECT COUNT (*) AS VisitDiagnosisCount
		FROM VisitDiagnosis WITH (NOLOCK)
		WHERE VisitUid = t.VisitUid
			AND IsDelete = 0
	) AS t1

	UPDATE @Search_TBL
		SET SuperbillCount = t1.SuperbillCount,
		SuperbillExternalID = t1.ExternalID
	FROM @Search_TBL AS t
	CROSS APPLY
	(
		SELECT COUNT (*) AS SuperbillCount,
			t1.ExternalID
		FROM Superbill AS t1 WITH (NOLOCK)
		WHERE t1.VisitUid = t.VisitUid
		GROUP BY t1.ExternalID
	) AS t1

	UPDATE @Search_TBL
		SET SuperbillProcedureCount = t1.SuperbillProcedureCount
	FROM @Search_TBL AS t
	CROSS APPLY
	(
		SELECT COUNT (*) AS SuperbillProcedureCount
		FROM Superbill AS t1 WITH (NOLOCK)
		INNER JOIN SuperbillProcedure AS t2 WITH (NOLOCK) ON t1.SuperbillUid = t2.SuperbillUid
		WHERE t1.VisitUid = t.VisitUid
	) AS t1

	UPDATE @Search_TBL
		SET SuperbillDiagnosisCount = t1.SuperbillDiagnosisCount
	FROM @Search_TBL AS t
	CROSS APPLY
	(
		SELECT COUNT (*) AS SuperbillDiagnosisCount
		FROM Superbill AS t1 WITH (NOLOCK)
			INNER JOIN SuperbillDiagnosis AS t2 WITH (NOLOCK) ON t1.SuperbillUid = t2.SuperbillUid
		WHERE t1.VisitUid = t.VisitUid
	) AS t1

	INSERT @OutstandingSuperbill_TBL
	SELECT t2.CacheMachineUid, t2.URL, t3.FullName AS Provider, COUNT (*) AS OutstandingSuperbill
	FROM @Search_TBL AS t
		INNER JOIN RelCacheMachineProvider AS t1 WITH (NOLOCK) ON t.ProviderUid = t1.ProviderUid
		INNER JOIN ViewFindPerson AS t3 WITH (NOLOCK) ON t1.ProviderUid = t3.PersonUid
		INNER JOIN ListCacheMachine AS t2 WITH (NOLOCK) ON t1.CacheMachineUid = t2.CacheMachineUid
			AND t2.Inactive = 0
	WHERE (t.SuperbillDiagnosisCount + t.VisitDiagnosisCount = 0 OR
		   t.SuperbillDiagnosisCount <> t.VisitDiagnosisCount OR
		   t.SuperbillProcedureCount + t.VisitProcedureCount = 0 OR
		   t.SuperbillProcedureCount <> t.VisitProcedureCount) 
	GROUP BY t2.CacheMachineUid, t2.URL, t3.FullName
	RETURN 
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindFormulary]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ViewFindFormulary](
   @medid                        INT = NULL,
   @AbbreviateCopay              BIT = 1,
   @includeFormularyAlternatives BIT = 0,
   @FormularyVendorUid           UNIQUEIDENTIFIER = NULL,
   @FormularyIdentifierUid       UNIQUEIDENTIFIER = NULL,
   @FormularyOrgUid              UNIQUEIDENTIFIER = NULL,
   @FormularyAlternativesOrgUid  UNIQUEIDENTIFIER = NULL,
   @FormularyCopayOrgUid         UNIQUEIDENTIFIER = NULL,
   @FormularyCoverageOrgUid      UNIQUEIDENTIFIER = NULL,
   @PatienteRxEligibilityUid     UNIQUEIDENTIFIER = NULL)

RETURNS
   @ReturnTable TABLE (
      DispensableUid             UNIQUEIDENTIFIER   NOT NULL PRIMARY KEY,
      MEDID                      INT,
      MNID                       INT,
	  RMID                       INT,
      DescDisplay                VARCHAR(125),
      DescSearch                 VARCHAR(125),
      DrugName                   VARCHAR(35),
      NameTypeCode               VARCHAR(1),
      StatusCode                 VARCHAR(1),
      ObsoleteDate               VARCHAR(8),
      Strength                   VARCHAR(255),
      StrengthUnits              VARCHAR(255),
      DoseForm                   VARCHAR(255),
      Route                      VARCHAR(30),
      GenericDrugNameID          INT,
      GenericDrugName            VARCHAR(125),
      GCNSeqNo                   INT,
      FederalDEAClassCode        VARCHAR(10),
      ClassUid                   UNIQUEIDENTIFIER,
      ClassID                    INT,
      ClassDescription           VARCHAR(70),
      ExternalID                 VARCHAR(25),
      Inactive                   BIT,
      UserDefined                TINYINT,
      HICL                       INT,
      FormularyProdFormuStatName VARCHAR(100),
      PreferredSort              INT,
      FormularyProdFormuCostName VARCHAR(100),
      RelativeCostSort           INT,
      NDC                        VARCHAR(20),
      RXNORMCode                 VARCHAR(50),
      RXNORMQualifier            VARCHAR(10),
      CopayRetail                VARCHAR(MAX),
      CopayMail                  VARCHAR(MAX),
      CopaySpecialty             VARCHAR(MAX),
      CopayLongTerm              VARCHAR(MAX),
      CoverageRestrictions       VARCHAR(50),
      IsAlternative              BIT,
      DrugTypeDesc               VARCHAR(100),
      Count                      INT,
      isClassAlternative         BIT,
      isPayerExpansion           BIT)
AS
BEGIN
   ----------------------------------------------------------------------------------------------------
   -- Useful local variables                                                                         --
   ----------------------------------------------------------------------------------------------------
   DECLARE
      @NonReimbursableUid        UNIQUEIDENTIFIER,
      @UnknownUid                UNIQUEIDENTIFIER,
      @AnyUid                    UNIQUEIDENTIFIER,
     @classid                   INT,
      @PharmacyEligible          BIT,
      @MailOrderEligible         BIT

   SELECT @NonReimbursableUid = sts.FormularyProdFormuStatUid
   FROM dbo.ListFormularyProdFormuStat sts (NOLOCK)
   WHERE FormularyVendorUid = ''00000000-0000-0000-0000-000000000002''
     AND (ISNUMERIC([FormularyStatus]) <> 0 AND CAST ([FormularyStatus] AS [int]) = 0)

   SELECT @UnknownUid = sts.FormularyProdFormuStatUid
   FROM dbo.ListFormularyProdFormuStat sts (NOLOCK)
   WHERE FormularyVendorUid = ''00000000-0000-0000-0000-000000000002''
     AND FormularyStatus = ''U''

   SELECT @AnyUid = sts.FormularyProdFormuStatUid
   FROM dbo.ListFormularyProdFormuStat sts (NOLOCK)
   WHERE FormularyVendorUid = ''00000000-0000-0000-0000-000000000002''
     AND FormularyStatus = ''A''

   SELECT
      @PharmacyEligible    = pel.PharmacyEligible,
      @MailOrderEligible   = pel.MailOrderEligible
   FROM PatienteRxEligibility pel
   WHERE pel.PatienteRxEligibilityUid = @PatienteRxEligibilityUid

   SELECT @classid = dis.classid
   FROM dbo.NDD_SearchDispensable dis
   WHERE dis.IsDelete = 0
     AND dis.medid = @medid

   ----------------------------------------------------------------------------------------------------
   -- table to hold dispensable drugs                                                                --
   ----------------------------------------------------------------------------------------------------
   DECLARE @ViewFindDispensable TABLE(
      medid                      INT               NOT NULL PRIMARY KEY CLUSTERED,
      DescDisplay                VARCHAR(125)      NULL,
      nametypecode               VARCHAR(1)        NULL,
      refgenericdrugnamecode     VARCHAR(1)        NULL,
      reffederallegendcode       VARCHAR(1)        NULL,
      refmultisourcecode         VARCHAR(1)        NULL,
      statuscode                 VARCHAR(1)        NULL,
      medicaldeviceind           VARCHAR(1)        NULL,
      Count                      INT               DEFAULT(0),
      isClassAlternative         BIT               NOT NULL DEFAULT(0),
      isPayerExpansion           BIT               NOT NULL DEFAULT(0),
      mnid                       INT               NULL,
      FormularyProdFormuStatUid  UNIQUEIDENTIFIER  NULL,
      FormularyProdCostIndexUid  UNIQUEIDENTIFIER  NULL,
      AlternativesSort           INT               NOT NULL DEFAULT(0),
      CopayRetail                VARCHAR(MAX)      NULL,
      CopayMail                  VARCHAR(MAX)      NULL,
      CopaySpecialty             VARCHAR(MAX)      NULL,
      CopayLongTerm              VARCHAR(MAX)      NULL,
      CoverageRestrictions       VARCHAR(50)       NOT NULL DEFAULT(''''))

   INSERT INTO @ViewFindDispensable(medid, DescDisplay, nametypecode, refgenericdrugnamecode, reffederallegendcode, refmultisourcecode, statuscode, medicaldeviceind)
   SELECT
      medid                   = dis.medid,
      DescDisplay             = dis.MedDesc,
      nametypecode            = dis.DrugNameTypeCode,
      refgenericdrugnamecode  = dis.refgenericdrugnamecode,
      reffederallegendcode    = dis.reffederallegendcode,
      refmultisourcecode      = dis.refmultisourcecode,
      statuscode              = dis.statuscode,
      medicaldeviceind        = dis.IsMedicalDevice
   FROM dbo.NDD_SearchDispensable dis
   WHERE dis.IsDelete = 0
     AND dis.medid = @medid

   ----------------------------------------------------------------------------------------------------
   -- formulary suggested alternatives                                                               --
   ----------------------------------------------------------------------------------------------------
   INSERT INTO @ViewFindDispensable(medid, DescDisplay, nametypecode, refgenericdrugnamecode, reffederallegendcode, refmultisourcecode, statuscode, medicaldeviceind, mnid, AlternativesSort)
   SELECT DISTINCT
      medid                   = dis.medid,
      DescDisplay             = dis.MedDesc,
      nametypecode            = dis.DrugNameTypeCode,
      refgenericdrugnamecode  = dis.refgenericdrugnamecode,
      reffederallegendcode    = dis.reffederallegendcode,
      refmultisourcecode      = dis.refmultisourcecode,
      statuscode              = dis.statuscode,
      medicaldeviceind        = dis.IsMedicalDevice,
      mnid                    = dis.mnid,
      AlternativesSort        = fst.PreferredSort + 1000
   FROM dbo.FormularyAlternativesNDC alt (NOLOCK)
   INNER JOIN dbo.ListFormularyProdFormuStat fst (NOLOCK) ON fst.FormularyProdFormuStatUid = alt.FormularyProdFormuStatUid
   INNER JOIN @ViewFindDispensable vfd ON vfd.medid = alt.medid
   INNER JOIN dbo.NDD_SearchDispensable dis ON dis.IsDelete = 0 AND dis.medid = alt.Alternative_medid
   WHERE alt.FormularyAlternativesOrgUid = @FormularyAlternativesOrgUid
     AND dis.medid NOT IN(SELECT tab.medid FROM @ViewFindDispensable tab)

   -- get list of medids of interest
   DECLARE @DrugName TABLE(mnid INT NOT NULL PRIMARY KEY CLUSTERED)
   INSERT INTO @DrugName(mnid)
   SELECT DISTINCT vfd.mnid
   FROM @ViewFindDispensable vfd
   WHERE vfd.medid != @medid
     AND vfd.mnid IS NOT NULL

   -- fan out to all drugs of the same name
   INSERT INTO @ViewFindDispensable(medid, DescDisplay, nametypecode, refgenericdrugnamecode, reffederallegendcode, refmultisourcecode, statuscode, medicaldeviceind, isPayerExpansion)
   SELECT DISTINCT
      medid                   = dis.medid,
      DescDisplay             = dis.MedDesc,
      nametypecode            = dis.DrugNameTypeCode,
      refgenericdrugnamecode  = dis.refgenericdrugnamecode,
      reffederallegendcode    = dis.reffederallegendcode,
      refmultisourcecode      = dis.refmultisourcecode,
      statuscode              = dis.statuscode,
      medicaldeviceind        = dis.IsMedicalDevice,
      isPayerExpansion        = 1
   FROM @DrugName alt
   INNER JOIN dbo.NDD_SearchDispensable dis ON dis.IsDelete = 0 AND dis.mnid = alt.mnid
   WHERE dis.StatusCode = ''0''
     AND dis.medid NOT IN(SELECT tab.medid FROM @ViewFindDispensable tab)
   ORDER BY dis.MedDesc

   ----------------------------------------------------------------------------------------------------
   -- therapeutic alternatives                                                                       --
   ----------------------------------------------------------------------------------------------------
   INSERT INTO @ViewFindDispensable(medid, DescDisplay, nametypecode, refgenericdrugnamecode, reffederallegendcode, refmultisourcecode, statuscode, medicaldeviceind, isClassAlternative)
   SELECT DISTINCT
      medid                   = dis.medid,
      DescDisplay             = dis.MedDesc,
      nametypecode            = dis.DrugNameTypeCode,
      refgenericdrugnamecode  = dis.refgenericdrugnamecode,
      reffederallegendcode    = dis.reffederallegendcode,
      refmultisourcecode      = dis.refmultisourcecode,
      statuscode              = dis.statuscode,
      medicaldeviceind        = dis.IsMedicalDevice,
      isClassAlternative      = 1
   FROM dbo.NDD_SearchDispensable dis
   INNER JOIN dbo.NDD_RETCMED0_ETC_MEDID etc ON etc.IsDelete = 0
                                            AND etc.MEDID = dis.medid
                                            AND etc.ETC_ID <> 1130 -- don''t allow bulk chemicals bug #15969
                                            AND etc.ETC_ID = @classid
   WHERE @medid != dis.medid
     AND dis.IsDelete = 0
     AND dis.statuscode = ''0''
     AND dis.medid NOT IN(SELECT tab.medid FROM @ViewFindDispensable tab)
     AND dis.medid IN(SELECT medid FROM dbo.NDD_RMINDC1_NDC_MEDID pkg WHERE pkg.IsDelete = 0 AND pkg.medid = dis.medid)
   ORDER BY dis.MedDesc

   ----------------------------------------------------------------------------------------------------
   -- formulary status                                                                               --
   ----------------------------------------------------------------------------------------------------
   UPDATE @ViewFindDispensable
   SET
      FormularyProdCostIndexUid  = frm.FormularyProdCostIndexUid,
      FormularyProdFormuStatUid  = CASE
                                      -- drug exclusion
                                      WHEN cvg.CoverageListType = ''DE'' THEN @NonReimbursableUid

                                      -- ndc specific
                                      WHEN frm.FormularyProdFormuStatUid IS NOT NULL THEN frm.FormularyProdFormuStatUid

                                      -- not in package database
                                      WHEN NOT EXISTS(SELECT TOP 1 * FROM dbo.NDD_RMINDC1_NDC_MEDID pkg WHERE pkg.IsDelete = 0 AND pkg.medid = vfd.medid) THEN @UnknownUid

                                      -- summary level
  WHEN vfd.refgenericdrugnamecode = ''0''                                                                       THEN org.UnlistedSuppliesFormularyStatusUid
                                      WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''1'' AND vfd.reffederallegendcode IN(''2'', ''3'') THEN org.UnlistedBrandOTCFormularyStatusUid
                                      WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''2'' AND vfd.reffederallegendcode IN(''2'', ''3'') THEN org.UnlistedGenericOTCFormularyStatusUid
                                      WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''1''                                           THEN org.UnlistedBrandFormularyStatusUid
                                      WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''2''                                           THEN org.UnlistedGenericFormularyStatusUid
                                   END
   FROM @ViewFindDispensable vfd
   LEFT JOIN dbo.FormularyOrg org (NOLOCK) ON org.FormularyIdentifierUid = @FormularyIdentifierUid
   LEFT JOIN dbo.FormularyProductNDC frm (NOLOCK) ON frm.FormularyIdentifierUid = @FormularyIdentifierUid
                                                 AND frm.medid = vfd.medid
   LEFT JOIN dbo.FormularyCoverageNDC cvg (NOLOCK) ON cvg.FormularyCoverageOrgUid = @FormularyCoverageOrgUid
                                                  AND cvg.medid = vfd.medid
                                                  AND cvg.CoverageListType = ''DE''


   -- remove alternatives that are not on formulary
   DELETE @ViewFindDispensable
   FROM @ViewFindDispensable vfd
   INNER JOIN dbo.ListFormularyProdFormuStat fst (NOLOCK) ON fst.FormularyProdFormuStatUid = vfd.FormularyProdFormuStatUid
   WHERE vfd.isClassAlternative != 0
     AND ISNULL(fst.PreferredSort, 0) < 2

   ----------------------------------------------------------------------------------------------------
   -- copay retail                                                                                   --
   ----------------------------------------------------------------------------------------------------
   IF (@PharmacyEligible = 0)
      BEGIN
         UPDATE @ViewFindDispensable SET CopayRetail = ''Not Eligible''
      END
   ELSE
      BEGIN
         -- summary level
         UPDATE @ViewFindDispensable
         SET CopayRetail    = ISNULL(cop.Description, dbo.FormularyCopayDescription(cop.FlatCopayAmount, cop.PercentCopayRate, cop.FirstCopayTerm, cop.MinimumCopay, cop.MaximumCopay, cop.DaysSupplyPerCopay, cop.CopayTier, cop.MaximumCopayTier, cop.OutOfPocketRangeStart, cop.OutOfPocketRangeEnd))
         FROM @ViewFindDispensable vfd
         INNER JOIN dbo.FormularyCopaySummary cop (NOLOCK) ON cop.FormularyCopayOrgUid = @FormularyCopayOrgUid
                                                 AND cop.FormularyProdFormuStatUid IN(vfd.FormularyProdFormuStatUid, @AnyUid)
                                                 AND cop.PharmacyType IN(''R'',''A'','' '')
                                                 AND CASE cop.ProductType
                                                        WHEN ''0'' THEN 1                         -- Not Specified
                                                        WHEN ''1'' THEN CASE WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''1'' AND vfd.refmultisourcecode = ''2'' THEN 1 ELSE 0 END       -- Single Source Brand
                                                        WHEN ''2'' THEN CASE WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''1'' THEN 1 ELSE 0 END                                        -- Brand
                                                        WHEN ''3'' THEN CASE WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''2'' THEN 1 ELSE 0 END                                        -- Generic
                                                        WHEN ''4'' THEN CASE WHEN vfd.reffederallegendcode IN(''2'', ''3'') THEN 1 ELSE 0 END                                                               -- OTC
                                                        WHEN ''5'' THEN 0                                                                                                                               -- Compound
                                                        WHEN ''6'' THEN CASE WHEN vfd.refgenericdrugnamecode = ''0'' THEN 1 ELSE 0 END                                                                    -- Supply
                                                        WHEN ''7'' THEN CASE WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''1'' AND vfd.refmultisourcecode IN(''1'',''3'') THEN 1 ELSE 0 END -- Multi Source Brand
                                                        WHEN ''A'' THEN 1                                                                                                                               -- Any
                                                        WHEN '' '' THEN 1                                                                                                                               -- Any
                                                     END = 1

         -- ndc specific
         UPDATE @ViewFindDispensable
         SET CopayRetail    = ISNULL(cop.Description, dbo.FormularyCopayDescription(cop.FlatCopayAmount, cop.PercentCopayRate, cop.FirstCopayTerm, cop.MinimumCopay, cop.MaximumCopay, cop.DaysSupplyPerCopay, cop.CopayTier, cop.MaximumCopayTier,NULL,NULL))
         FROM @ViewFindDispensable vfd
         INNER JOIN dbo.FormularyCopayNDC cop (NOLOCK) ON cop.FormularyCopayOrgUid = @FormularyCopayOrgUid
                                             AND cop.medid = vfd.medid
                                             AND cop.PharmacyType IN(''R'',''A'','' '')
      END

   ----------------------------------------------------------------------------------------------------
   -- copay mail                                                                                     --
   ----------------------------------------------------------------------------------------------------
   IF (@MailOrderEligible = 0)
      BEGIN
         UPDATE @ViewFindDispensable SET CopayMail = ''Not Eligible''
      END
   ELSE
      BEGIN
         -- summary level
         UPDATE @ViewFindDispensable
         SET CopayMail      = ISNULL(cop.Description, dbo.FormularyCopayDescription(cop.FlatCopayAmount, cop.PercentCopayRate, cop.FirstCopayTerm, cop.MinimumCopay, cop.MaximumCopay, cop.DaysSupplyPerCopay, cop.CopayTier, cop.MaximumCopayTier, cop.OutOfPocketRangeStart, cop.OutOfPocketRangeEnd))
         FROM @ViewFindDispensable vfd
         INNER JOIN dbo.FormularyCopaySummary cop (NOLOCK) ON cop.FormularyCopayOrgUid = @FormularyCopayOrgUid
                                                 AND cop.FormularyProdFormuStatUid IN(vfd.FormularyProdFormuStatUid, @AnyUid)
                                                 AND cop.PharmacyType IN(''M'',''A'','' '')
                                                 AND CASE cop.ProductType
                                                        WHEN ''0'' THEN 1  -- Not Specified
                                                        WHEN ''1'' THEN CASE WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''1'' AND vfd.refmultisourcecode = ''2'' THEN 1 ELSE 0 END -- Single Source Brand
                                                        WHEN ''2'' THEN CASE WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''1'' THEN 1 ELSE 0 END                                        -- Brand
                                                        WHEN ''3'' THEN CASE WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''2'' THEN 1 ELSE 0 END                                        -- Generic
                                                        WHEN ''4'' THEN CASE WHEN vfd.reffederallegendcode IN(''2'', ''3'') THEN 1 ELSE 0 END        -- OTC
WHEN ''5'' THEN 0                                                                                                                               -- Compound
                                                        WHEN ''6'' THEN CASE WHEN vfd.refgenericdrugnamecode = ''0'' THEN 1 ELSE 0 END                                                                    -- Supply
                                                        WHEN ''7'' THEN CASE WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''1'' AND vfd.refmultisourcecode IN(''1'',''3'') THEN 1 ELSE 0 END -- Multi Source Brand
                                                        WHEN ''A'' THEN 1                                                                                                                               -- Any
                                                        WHEN '' '' THEN 1                                                                                                                               -- Any
                                                     END = 1
         -- ndc specific
         UPDATE @ViewFindDispensable
         SET CopayMail      = ISNULL(cop.Description, dbo.FormularyCopayDescription(cop.FlatCopayAmount, cop.PercentCopayRate, cop.FirstCopayTerm, cop.MinimumCopay, cop.MaximumCopay, cop.DaysSupplyPerCopay, cop.CopayTier, cop.MaximumCopayTier,NULL,NULL))
         FROM @ViewFindDispensable vfd
         INNER JOIN dbo.FormularyCopayNDC cop (NOLOCK) ON cop.FormularyCopayOrgUid = @FormularyCopayOrgUid
                                             AND cop.medid = vfd.medid
                                             AND cop.PharmacyType IN(''M'',''A'','' '')
      END

   ----------------------------------------------------------------------------------------------------
   -- copay specialty                                                                                --
   ----------------------------------------------------------------------------------------------------
   -- summary level
   UPDATE @ViewFindDispensable
   SET CopaySpecialty = ISNULL(cop.Description, dbo.FormularyCopayDescription(cop.FlatCopayAmount, cop.PercentCopayRate, cop.FirstCopayTerm, cop.MinimumCopay, cop.MaximumCopay, cop.DaysSupplyPerCopay, cop.CopayTier, cop.MaximumCopayTier, cop.OutOfPocketRangeStart, cop.OutOfPocketRangeEnd))
   FROM @ViewFindDispensable vfd
   INNER JOIN dbo.FormularyCopaySummary cop (NOLOCK) ON cop.FormularyCopayOrgUid = @FormularyCopayOrgUid
                                           AND cop.FormularyProdFormuStatUid IN(vfd.FormularyProdFormuStatUid, @AnyUid)
                                           AND cop.PharmacyType IN(''S'',''A'','' '')
                                           AND CASE cop.ProductType
                                                  WHEN ''0'' THEN 1                                                                                                                               -- Not Specified
                                                  WHEN ''1'' THEN CASE WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''1'' AND vfd.refmultisourcecode = ''2'' THEN 1 ELSE 0 END       -- Single Source Brand
                                                  WHEN ''2'' THEN CASE WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''1'' THEN 1 ELSE 0 END       -- Brand
                                                  WHEN ''3'' THEN CASE WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''2'' THEN 1 ELSE 0 END                                        -- Generic
                                                  WHEN ''4'' THEN CASE WHEN vfd.reffederallegendcode IN(''2'', ''3'') THEN 1 ELSE 0 END                                                               -- OTC
                                                  WHEN ''5'' THEN 0                         -- Compound
                    WHEN ''6'' THEN CASE WHEN vfd.refgenericdrugnamecode = ''0'' THEN 1 ELSE 0 END                             -- Supply
  WHEN ''7'' THEN CASE WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''1'' AND vfd.refmultisourcecode IN(''1'',''3'') THEN 1 ELSE 0 END -- Multi Source Brand
                                                  WHEN ''A'' THEN 1                                                                                                                               -- Any
                                                  WHEN '' '' THEN 1                                                                                                                               -- Any
                                               END = 1
   -- ndc specific
   UPDATE @ViewFindDispensable
   SET CopaySpecialty = ISNULL(cop.Description, dbo.FormularyCopayDescription(cop.FlatCopayAmount, cop.PercentCopayRate, cop.FirstCopayTerm, cop.MinimumCopay, cop.MaximumCopay, cop.DaysSupplyPerCopay, cop.CopayTier, cop.MaximumCopayTier,NULL,NULL))
   FROM @ViewFindDispensable vfd
   INNER JOIN dbo.FormularyCopayNDC cop (NOLOCK) ON cop.FormularyCopayOrgUid = @FormularyCopayOrgUid
                                       AND cop.medid = vfd.medid
                                       AND cop.PharmacyType IN(''S'',''A'','' '')

   ----------------------------------------------------------------------------------------------------
   -- copay longterm                                                                                 --
   ----------------------------------------------------------------------------------------------------
   -- summary level
   UPDATE @ViewFindDispensable
   SET CopaySpecialty = ISNULL(cop.Description, dbo.FormularyCopayDescription(cop.FlatCopayAmount, cop.PercentCopayRate, cop.FirstCopayTerm, cop.MinimumCopay, cop.MaximumCopay, cop.DaysSupplyPerCopay, cop.CopayTier, cop.MaximumCopayTier, cop.OutOfPocketRangeStart, cop.OutOfPocketRangeEnd))
   FROM @ViewFindDispensable vfd
   INNER JOIN dbo.FormularyCopaySummary cop (NOLOCK) ON cop.FormularyCopayOrgUid = @FormularyCopayOrgUid
                                           AND cop.FormularyProdFormuStatUid IN(vfd.FormularyProdFormuStatUid, @AnyUid)
                                           AND cop.PharmacyType IN(''L'',''A'','' '')
                                           AND CASE cop.ProductType
                                                  WHEN ''0'' THEN 1                                                                                                                               -- Not Specified
                                                  WHEN ''1'' THEN CASE WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''1'' AND vfd.refmultisourcecode = ''2'' THEN 1 ELSE 0 END       -- Single Source Brand
                                                  WHEN ''2'' THEN CASE WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''1'' THEN 1 ELSE 0 END          -- Brand
                                                  WHEN ''3'' THEN CASE WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''2'' THEN 1 ELSE 0 END                                        -- Generic
                                                  WHEN ''4'' THEN CASE WHEN vfd.reffederallegendcode IN(''2'', ''3'') THEN 1 ELSE 0 END                                                               -- OTC
                                                  WHEN ''5'' THEN 0                                                                                                                               -- Compound
                                                  WHEN ''6'' THEN CASE WHEN vfd.refgenericdrugnamecode = ''0'' THEN 1 ELSE 0 END                                     -- Supply
                                WHEN ''7'' THEN CASE WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''1'' AND vfd.refmultisourcecode IN(''1'',''3'') THEN 1 ELSE 0 END -- Multi Source Brand
                      WHEN ''A'' THEN 1                                                     -- Any
           WHEN '' '' THEN 1                   -- Any
 END = 1

   -- copay ndc specific long term
   UPDATE @ViewFindDispensable
   SET CopayLongTerm  = ISNULL(cop.Description, dbo.FormularyCopayDescription(cop.FlatCopayAmount, cop.PercentCopayRate, cop.FirstCopayTerm, cop.MinimumCopay, cop.MaximumCopay, cop.DaysSupplyPerCopay, cop.CopayTier, cop.MaximumCopayTier,NULL,NULL))
   FROM @ViewFindDispensable vfd
   INNER JOIN dbo.FormularyCopayNDC cop (NOLOCK) ON cop.FormularyCopayOrgUid = @FormularyCopayOrgUid
                                       AND cop.medid = vfd.medid
                                       AND cop.PharmacyType IN(''L'',''A'','' '')

   ----------------------------------------------------------------------------------------------------
   -- return the table                                                                               --
   ----------------------------------------------------------------------------------------------------
   INSERT INTO @ReturnTable(
      DispensableUid,
      MEDID,
      MNID,
	  RMID,
      DescDisplay,
      DescSearch,
      DrugName,
      NameTypeCode,
      StatusCode,
      ObsoleteDate,
      Strength,
      StrengthUnits,
      DoseForm,
      Route,
      GenericDrugNameID,
      GenericDrugName,
      GCNSeqNo,
      FederalDEAClassCode,
      ClassUid,
      ClassID,
      ClassDescription,
      ExternalID,
      Inactive,
      UserDefined,
      HICL,
      FormularyProdFormuStatName,
      PreferredSort,
      FormularyProdFormuCostName,
      RelativeCostSort,
      NDC,
      RXNORMCode,
      RXNORMQualifier,
      CopayRetail,
      CopayMail,
      CopaySpecialty,
      CopayLongTerm,
      CoverageRestrictions,
      IsAlternative,
      DrugTypeDesc,
      Count,
      isClassAlternative,
      isPayerExpansion)
   SELECT
      DispensableUid             = dbo.IntToGUID(vfd.medid),
      MEDID                      = vfd.medid,
      MNID                       = dis.mnid,
	  RMID                       = dis.rmid,
      DescDisplay                = dis.MedDesc,
      DescSearch                 = dis.SearchMedDesc,
      DrugName                   = dis.DrugName,
      NameTypeCode               = vfd.nametypecode,
      StatusCode                 = ISNULL(vfd.statuscode, ''0''),
      ObsoleteDate               = NULL,
      Strength                   = dis.MED_STRENGTH,
      StrengthUnits              = dis.MED_STRENGTH_UOM,
      DoseForm                   = dis.DosageFormDesc,
      Route                      = dis.RouteDesc,
      GenericDrugNameID          = dis.genericmnid,
      GenericDrugName            = dis.GenericDrugName,
      GCNSeqNo                   = dis.gcnseqno,
      FederalDEAClassCode        = dis.reffederaldeaclasscode,
      ClassUid                   = dbo.IntToGUID(dis.classid),
      ClassID                    = dis.classid,
      ClassDescription           = dis.ClassName,
      ExternalID                 = NULL,
      Inactive                   = CASE WHEN dis.IsDelete = 1 THEN 1 WHEN dis.StatusCode = ''0'' THEN 0 ELSE 1 END,
      UserDefined                = 0,
      HICL                       = dis.hicl,
      FormularyProdFormuStatName = fst.Name,
      PreferredSort              = CASE WHEN AlternativesSort > 0 THEN vfd.AlternativesSort ELSE ISNULL(fst.PreferredSort, -1) END,
      FormularyProdFormuCostName = CASE
                                    WHEN vfd.FormularyProdFormuStatUid = @NonReimbursableUid THEN NULL
     WHEN vfd.FormularyProdFormuStatUid = @UnknownUid         THEN NULL
                  ELSE cst.Name
             END,
      RelativeCostSort           = CASE
                         WHEN vfd.FormularyProdFormuStatUid = @NonReimbursableUid  THEN -1
                 WHEN vfd.FormularyProdFormuStatUid = @UnknownUid          THEN -1
                       WHEN cst.RelativeCostSort IS NULL           THEN -1
               ELSE cst.RelativeCostSort
          END,
  NDC     = dis.NDC,
      RXNORMCode                 = dis.RXNORMCode,
      RXNORMQualifier            = dis.RXNORMQualifier,
      CopayRetail                = CASE WHEN vfd.CopayRetail    = '''' THEN NULL ELSE vfd.CopayRetail    END,
      CopayMail                  = CASE WHEN vfd.CopayMail      = '''' THEN NULL ELSE vfd.CopayMail      END,
      CopaySpecialty             = CASE WHEN vfd.CopaySpecialty = '''' THEN NULL ELSE vfd.CopaySpecialty END,
      CopayLongTerm              = CASE WHEN vfd.CopayLongTerm  = '''' THEN NULL ELSE vfd.CopayLongTerm  END,
      CoverageRestrictions       = vfr.Restrictions,
      IsAlternative              = CASE WHEN dis.medid = @medid THEN 0 ELSE 1 END,
      DrugTypeDesc               = dbo.DispensableDrugTypeDesc(dis.medid, dis.NDC, dis.reffederaldeaclasscode, dis.DrugNameTypeCode, dis.refmultisourcecode, dis.reffederallegendcode, dis.IsMedicalDevice, dis.refgenericdrugnamecode),
      Count                      = vfd.Count,
      isClassAlternative         = vfd.isClassAlternative,
      isPayerExpansion           = vfd.isPayerExpansion
   FROM @ViewFindDispensable vfd
   LEFT JOIN dbo.NDD_SearchDispensable dis ON dis.IsDelete = 0 AND dis.medid = vfd.medid
   LEFT JOIN dbo.ListFormularyProdFormuStat fst (NOLOCK) ON fst.FormularyProdFormuStatUid = vfd.FormularyProdFormuStatUid
   LEFT JOIN dbo.ListFormularyProdCostIndex cst (NOLOCK) ON cst.FormularyProdCostIndexUid =  vfd.FormularyProdCostIndexUid
   LEFT JOIN dbo.ViewFormularyRestrictions(@FormularyCoverageOrgUid) vfr ON vfr.medid = vfd.medid
   WHERE (vfd.isClassAlternative = 0 OR fst.PreferredSort >= 2)
   ORDER BY Count DESC, IsAlternative, IsClassAlternative, PreferredSort DESC, RelativeCostSort DESC, DescDisplay

RETURN
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindDispensable]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ViewFindDispensable](
   @viewName                     VARCHAR(80) = ''FindDispensableDrug'',
   @UserUid                      UNIQUEIDENTIFIER = NULL,
   @medid                        INT = NULL,
   @classid                      INT = NULL,
   @descsearch                   VARCHAR(255) = ''%'',
   @maxRows                      INT = 100,                          -- -1 = all, no limit
   @hicl                         INT = NULL,
   @mnid                         INT = NULL,
   @gcnseqno                     INT = NULL,
   @includeUserDefined           BIT = 1,
   @includeBrandName             BIT = 1,                            -- include brand names
   @includeGenericName           BIT = 1,                            -- include generic names
   @includeObsolete              BIT = 0,                            -- 0 = exclude obsolete medication, 1 = include obsolete medication
   @includeInactive              BIT = 0,
   @AbbreviateCopay              BIT = 1,
   @includeFormularyAlternatives BIT = 0,
   @FormularyVendorUid           UNIQUEIDENTIFIER = NULL,
   @FormularyIdentifierUid       UNIQUEIDENTIFIER = NULL,
   @FormularyOrgUid              UNIQUEIDENTIFIER = NULL,
   @FormularyAlternativesOrgUid  UNIQUEIDENTIFIER = NULL,
   @FormularyCopayOrgUid         UNIQUEIDENTIFIER = NULL,
   @FormularyCoverageOrgUid      UNIQUEIDENTIFIER = NULL,
   @PatienteRxEligibilityUid     UNIQUEIDENTIFIER = NULL)

RETURNS
   @ReturnTable TABLE (
      DispensableUid             UNIQUEIDENTIFIER   NOT NULL PRIMARY KEY,
      MEDID                      INT,
      MNID                       INT,
	  RMID                       INT,
      DescDisplay                VARCHAR(125),
      DescSearch                 VARCHAR(125),
      DrugName                   VARCHAR(35),
      NameTypeCode               VARCHAR(1),
      StatusCode                 VARCHAR(1),
      ObsoleteDate               VARCHAR(8),
      Strength                   VARCHAR(255),
      StrengthUnits              VARCHAR(255),
      DoseForm                   VARCHAR(255),
      Route                      VARCHAR(30),
      GenericDrugNameID          INT,
      GenericDrugName            VARCHAR(125),
      GCNSeqNo                   INT,
      FederalDEAClassCode        VARCHAR(10),
      ClassUid                   UNIQUEIDENTIFIER,
      ClassID                    INT,
      ClassDescription           VARCHAR(70),
      ExternalID                 VARCHAR(25),
      Inactive                   BIT,
      UserDefined                TINYINT,
      HICL                       INT,
      FormularyProdFormuStatName VARCHAR(100),
      PreferredSort              INT,
      FormularyProdFormuCostName VARCHAR(100),
      RelativeCostSort           INT,
      NDC                        VARCHAR(20),
      RXNORMCode                 VARCHAR(50),
      RXNORMQualifier            VARCHAR(10),
      CopayRetail                VARCHAR(MAX),
      CopayMail                  VARCHAR(MAX),
      CopaySpecialty             VARCHAR(MAX),
      CopayLongTerm              VARCHAR(MAX),
      CoverageRestrictions       VARCHAR(50),
      IsAlternative              BIT,
      DrugTypeDesc               VARCHAR(100),
      Count                      INT,
      isClassAlternative         BIT,
      isPayerExpansion           BIT)
--AS
BEGIN
   IF (@medid > 0 AND @viewName = ''FindDispensableDrug'')
      BEGIN
         -- CMR:  Do all the heavy lifting for formulary in a different view.  Will rip this out for SP1
         INSERT INTO @ReturnTable
         SELECT *
         FROM dbo.ViewFindFormulary(@medid,
                                    @AbbreviateCopay,
                                    @includeFormularyAlternatives,
                                    @FormularyVendorUid,
                                    @FormularyIdentifierUid,
                                    @FormularyOrgUid,
    @FormularyAlternativesOrgUid,
                                    @FormularyCopayOrgUid,
                                    @FormularyCoverageOrgUid,
                                    @PatienteRxEligibilityUid)
         RETURN
      END

   IF (@maxRows < 0)
      BEGIN
         SELECT @maxRows = 9999999
      END

   IF (@descsearch IS NULL)
      BEGIN
         SET @descsearch = ''%''
      END

   SET @descsearch = LTRIM(@descsearch)

   -- get list of DispensableUids of interest
   DECLARE @ViewFindDispensable TABLE(
      medid                      INT               NULL,
      DescDisplay                VARCHAR(125)      NULL,
      nametypecode               VARCHAR(1)        NULL,
      refgenericdrugnamecode     VARCHAR(1)        NULL,
      reffederallegendcode       VARCHAR(1)        NULL,
      refmultisourcecode         VARCHAR(1)        NULL,
      statuscode                 VARCHAR(1)        NULL,
      Count                      INT               DEFAULT(0))


   IF (@viewName = ''FindDispensableDrug'')
      BEGIN
         INSERT INTO @ViewFindDispensable(medid, DescDisplay, nametypecode, refgenericdrugnamecode, reffederallegendcode, refmultisourcecode, statuscode)
         SELECT DISTINCT TOP (@maxRows)
            medid                   = dis.medid,
            DescDisplay             = dis.DescDisplay,
            nametypecode            = dis.nametypecode,
            refgenericdrugnamecode  = dis.refgenericdrugnamecode,
            reffederallegendcode    = dis.reffederallegendcode,
            refmultisourcecode      = dis.refmultisourcecode,
            statuscode              = dis.statuscode
         FROM dbo.InternalFindDispensable dis
         WHERE dis.descsearch LIKE @descsearch
           AND ISNULL(dis.medid, -999) = COALESCE(@medid, ISNULL(dis.medid, -999))
           AND (@classid IS NULL OR @classid = (SELECT TOP 1 etc.ETC_ID
                                                FROM dbo.NDD_RETCMED0_ETC_MEDID etc
                                                WHERE etc.IsDelete = 0
                                                  AND etc.ETC_ID = @classid
                                                  AND etc.MEDID = dis.medid
                                                  AND etc.ETC_ID <> 1130 -- don''t allow bulk chemicals bug #15969
                                                ORDER BY etc.ETC_ID))
           AND ((@includeInactive = 1) OR ((@includeInactive = 0) AND (dis.Inactive = 0)))
           AND ((@includeObsolete = 1) OR ((@includeObsolete = 0) AND (dis.obsoletedate IS NULL) AND (ISNULL(dis.statuscode, ''0'') = ''0'')))
           AND ISNULL(dis.hicl, -999) = COALESCE(@hicl, ISNULL(dis.hicl, -999))
           AND ISNULL(dis.mnid, -999) = COALESCE(@mnid, ISNULL(dis.mnid, -999))
           AND ISNULL(dis.gcnseqno, -999) = COALESCE(@gcnseqno, ISNULL(dis.gcnseqno, -999))
           AND ((@includeUserDefined = 1) OR (dis.UserDefined != 1))
           AND ((dis.UserDefined = 1 AND dis.nametypecode IS NULL)
             -- note: column nametypecode is a varchar(1) and can never be ''999
             OR (dis.nametypecode IN(CASE @includeBrandName   WHEN 1 THEN ''1'' ELSE ''999'' END,
                                     CASE @includeGenericName WHEN 1 THEN ''2'' ELSE ''999'' END)))
         ORDER BY dis.descdisplay
      END

   ELSE IF (@viewName = ''FindEquivalentDispensableDrug'')
      BEGIN
         INSERT INTO @ViewFindDispensable(medid, DescDisplay, nametypecode, refgenericdrugnamecode, reffederallegendcode, refmultisourcecode, statuscode)
         SELECT DISTINCT TOP (@maxRows)
            medid                   = dis.medid,
            DescDisplay             = dis.DescDisplay,
            nametypecode            = dis.nametypecode,
            refgenericdrugnamecode  = dis.refgenericdrugnamecode,
            reffederallegendcode    = dis.reffederallegendcode,
            refmultisourcecode = dis.refmultisourcecode,
  statuscode              = dis.statuscode
         FROM dbo.InternalFindDispensable dis
         INNER JOIN dbo.NDD_SearchDispensable lnk ON lnk.IsDelete = 0 AND lnk.medid = @medid AND lnk.gcnseqno = dis.gcnseqno
         WHERE dis.medid != @medid
           AND dis.gcnseqno > 0
           AND dis.mnid != -1
           AND ((@includeInactive = 1) OR ((@includeInactive = 0) AND (dis.Inactive = 0)))
           AND ((@includeObsolete = 1) OR ((@includeObsolete = 0) AND (dis.obsoletedate IS NULL) AND (ISNULL(dis.statuscode, ''0'') = ''0'')))
           AND ISNULL(dis.hicl, -999) = COALESCE(@hicl, ISNULL(dis.hicl, -999))
           AND ISNULL(dis.mnid, -999) = COALESCE(@mnid, ISNULL(dis.mnid, -999))
           AND ISNULL(dis.gcnseqno, -999) = COALESCE(@gcnseqno, ISNULL(dis.gcnseqno, -999))
           AND ((@includeUserDefined = 1) OR (dis.UserDefined != 1))
           AND ((dis.UserDefined = 1 AND dis.nametypecode IS NULL)
             -- note: column nametypecode is a varchar(1) and can never be ''999
             OR (dis.nametypecode IN(CASE @includeBrandName   WHEN 1 THEN ''1'' ELSE ''999'' END,
                                     CASE @includeGenericName WHEN 1 THEN ''2'' ELSE ''999'' END)))
         ORDER BY dis.descdisplay
      END

   ELSE IF (@viewName IN(''FindMFUDispensableDrug'', ''FindMxUDispensableDrug''))
      BEGIN
         INSERT INTO @ViewFindDispensable(Count, medid, DescDisplay, nametypecode, refgenericdrugnamecode, reffederallegendcode, refmultisourcecode, statuscode)
         SELECT DISTINCT TOP (@maxRows)
            Count                   = vft.Count,
            medid                   = dis.medid,
            DescDisplay             = dis.DescDisplay,
            nametypecode            = dis.nametypecode,
            refgenericdrugnamecode  = dis.refgenericdrugnamecode,
            reffederallegendcode    = dis.reffederallegendcode,
            refmultisourcecode      = dis.refmultisourcecode,
            statuscode              = dis.statuscode
         FROM dbo.InternalFindDispensable dis
         INNER JOIN dbo.ViewFindTableMFUHide vft ON dbo.GUIDToInt(vft.Uid) = dis.medid
                                                AND (vft.Exclude = 0 OR @viewName = ''FindMxUDispensableDrug'')
                                                AND vft.FindTableUid = ''F92F50F5-FBF2-46D0-ABAD-CE321E6D498C''
                                                AND vft.UserUid = @UserUid
         WHERE (@classid IS NULL OR @classid = (SELECT TOP 1 etc.ETC_ID
                                                FROM dbo.NDD_RETCMED0_ETC_MEDID etc
                                                WHERE etc.IsDelete = 0
                                                  AND etc.ETC_ID = @classid
                                                  AND etc.MEDID = dis.medid
                                                  AND etc.ETC_ID <> 1130 -- don''t allow bulk chemicals bug #15969
                                                ORDER BY etc.ETC_ID))
           AND ((@includeInactive = 1) OR ((@includeInactive = 0) AND (dis.Inactive = 0)))
           AND ((@includeObsolete = 1) OR ((@includeObsolete = 0) AND (dis.obsoletedate IS NULL) AND (ISNULL(dis.statuscode, ''0'') = ''0'')))
           AND ISNULL(dis.hicl, -999) = COALESCE(@hicl, ISNULL(dis.hicl, -999))
           AND ISNULL(dis.mnid, -999) = COALESCE(@mnid, ISNULL(dis.mnid, -999))
           AND ISNULL(dis.gcnseqno, -999) = COALESCE(@gcnseqno, ISNULL(dis.gcnseqno, -999))
           AND ((@includeUserDefined = 1) OR (dis.UserDefined != 1))
           AND ((dis.UserDefined = 1 AND dis.nametypecode IS NULL)
             -- note: column nametypecode is a varchar(1) and can never be ''999
             OR (dis.nametypecode IN(CASE @includeBrandName   WHEN 1 THEN ''1'' ELSE ''999'' END,
                                     CASE @includeGenericName WHEN 1 THEN ''2'' ELSE ''999'' END)))
         ORDER BY vft.Count DESC, dis.descdisplay
      END

   ELSE IF (@viewName = ''FindUserDispensableDrug'')
      BEGIN
         INSERT INTO @ViewFindDispensable(medid, DescDisplay, nametypecode, refgenericdrugnamecode, reffederallegendcode, refmultisourcecode, statuscode)
         SELECT DISTINCT TOP (@maxRows)
            medid                   = dis.medid,
            DescDisplay             = dis.DescDisplay,
            nametypecode            = dis.nametypecode,
            refgenericdrugnamecode  = dis.refgenericdrugnamecode,
            reffederallegendcode    = dis.reffederallegendcode,
            refmultisourcecode      = dis.refmultisourcecode,
            statuscode              = dis.statuscode
         FROM dbo.InternalFindDispensable dis
         WHERE dis.descsearch LIKE @descsearch  -- fixed bug #15907
           AND ((@includeInactive = 1) OR ((@includeInactive = 0) AND (dis.Inactive = 0)))
           AND dis.UserDefined = 1
         ORDER BY dis.descdisplay
      END

   -- return the table
   INSERT INTO @ReturnTable(
      DispensableUid,
      MEDID,
      MNID,
	  RMID,
      DescDisplay,
      DescSearch,
      DrugName,
      NameTypeCode,
      StatusCode,
      ObsoleteDate,
      Strength,
      StrengthUnits,
      DoseForm,
      Route,
      GenericDrugNameID,
      GenericDrugName,
      GCNSeqNo,
      FederalDEAClassCode,
      ClassUid,
      ClassID,
      ClassDescription,
      ExternalID,
      Inactive,
      UserDefined,
      HICL,
      PreferredSort,
      RelativeCostSort,
      NDC,
      RXNORMCode,
      RXNORMQualifier,
      IsAlternative,
      DrugTypeDesc,
      Count,
      isClassAlternative,
      isPayerExpansion)
   SELECT
      DispensableUid             = dbo.IntToGUID(dis.medid),
      MEDID                      = dis.medid,
      MNID                       = dis.mnid,
      RMID                       = dis.rmid,
      DescDisplay                = dis.descdisplay,
      DescSearch                 = dis.descsearch,
      DrugName                   = ISNULL(ndd.DrugName, (SELECT lmt.Name FROM ListMedication lmt WHERE lmt.MedicationUid = dbo.IntToGUID(dis.medid))),
      NameTypeCode               = dis.nametypecode,
      StatusCode                 = ISNULL(dis.statuscode, ''0''),
      ObsoleteDate               = dis.obsoletedate,
      Strength                   = dis.strength,
      StrengthUnits              = dis.strengthunits,
      DoseForm                   = ndd.DosageFormDesc,
      Route                      = dis.RouteDesc,
      GenericDrugNameID          = dis.genericmnid,
      GenericDrugName            = ndd.GenericDrugName,
      GCNSeqNo                   = dis.gcnseqno,
      FederalDEAClassCode        = ndd.reffederaldeaclasscode,
      ClassUid                   = dbo.IntToGUID(ndd.classid),
      ClassID                    = ndd.classid,
      ClassDescription           = ndd.ClassName,
      ExternalID                 = dis.ExternalID,
      Inactive                   = dis.Inactive,
      UserDefined                = dis.UserDefined,
      HICL                       = dis.hicl,
      PreferredSort              = 0,
      RelativeCostSort           = 0,
      NDC                        = CASE WHEN dis.UserDefined = 1 THEN rxn.NDC ELSE ndd.NDC END,
      RXNORMCode                 = ISNULL(ndd.RxNormCode, rxn.RxNorm),
      RXNORMQualifier            = ISNULL(ndd.RxNormQualifier, rxn.RxNormQualifier),
      IsAlternative              = 0,
      DrugTypeDesc               = dbo.DispensableDrugTypeDesc(ndd.medid, ndd.NDC, ndd.reffederaldeaclasscode, ndd.DrugNameTypeCode, ndd.RefMultiSourceCode, ndd.RefFederalLegendCode, ndd.IsMedicalDevice, ndd.refgenericdrugnamecode),
      Count                      = vfd.Count,
      isClassAlternative         = 0,
      isPayerExpansion           = 0
   FROM @ViewFindDispensable vfd
   INNER JOIN dbo.InternalFindDispensable dis ON dis.medid = vfd.medid
   LEFT JOIN dbo.NDD_SearchDispensable ndd ON ndd.IsDelete = 0 AND ndd.medid = vfd.medid
   OUTER APPLY (
      SELECT TOP 1 *
      FROM dbo.RelDispensableRxCodes rxn
      WHERE dbo.GUIDToInt(rxn.DispensableUid) = dis.medid
        AND dis.UserDefined = 1) rxn
   ORDER BY Count DESC, IsClassAlternative

RETURN
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindPQRI]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ViewFindPQRI](@PQRIGroupUid UniqueIdentifier)
RETURNS 
@FoundPQRI TABLE
(
	PQRIMeasureUid uniqueidentifier,
	ExternalID varchar(255), 
    Inactive bit,
	[Name] varchar(255), 
	Notes text,
	UserDefined smallint,
	EffectiveDate DateTime,
	ExpirationDate DateTime,
	PQRIDiseaseGroupUid uniqueidentifier
)

AS
begin

if @PQRIGroupUid is null
begin
	INSERT INTO @FoundPQRI (PQRIMeasureUid, ExternalID, Inactive, [Name], Notes, 
				UserDefined, EffectiveDate, ExpirationDate, PQRIDiseaseGroupUid) 
		SELECT dbo.ListPQRIMeasure.PQRIMeasureUid, 
			dbo.ListPQRIMeasure.ExternalID, dbo.ListPQRIMeasure.Inactive, 
			dbo.ListPQRIMeasure.Name, dbo.ListPQRIMeasure.Notes, 
			dbo.ListPQRIMeasure.UserDefined,
			dbo.ListPQRIMeasure.EffectiveDate,
			dbo.ListPQRIMeasure.ExpirationDate,
			dbo.ListPQRIMeasure.PQRIDiseaseGroupUid
		FROM dbo.ListPQRIMeasure
end
else begin
	INSERT INTO @FoundPQRI (PQRIMeasureUid, ExternalID, Inactive, [Name], Notes, 
				UserDefined, EffectiveDate, ExpirationDate, PQRIDiseaseGroupUid)  
	SELECT dbo.ListPQRIMeasure.PQRIMeasureUid, 
		dbo.ListPQRIMeasure.ExternalID, dbo.ListPQRIMeasure.Inactive, 
		dbo.ListPQRIMeasure.Name, dbo.ListPQRIMeasure.Notes, 
		dbo.ListPQRIMeasure.UserDefined,
		dbo.ListPQRIMeasure.EffectiveDate,
		dbo.ListPQRIMeasure.ExpirationDate,
		dbo.ListPQRIMeasure.PQRIDiseaseGroupUid
	FROM dbo.ListPQRIMeasure
        INNER JOIN dbo.RelPQRIMeasurePQRIGroup
		ON dbo.RelPQRIMeasurePQRIGroup.PQRIMeasureUid = dbo.ListPQRIMeasure.PQRIMeasureUid
		AND  PQRIGroupUid = @PQRIGroupUid
end


return
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewPrimaryInsurance]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ViewPrimaryInsurance] (@patientUid UNIQUEIDENTIFIER, @accountUid UNIQUEIDENTIFIER, @date DATETIME, @patienteRxEligibilityUid UNIQUEIDENTIFIER)
RETURNS 
@viewPrimaryInsurance TABLE 
(
	AccountUid UNIQUEIDENTIFIER NOT NULL,
	AccountName VARCHAR(100),
	IsMain BIT NOT NULL,
	PatientUid UNIQUEIDENTIFIER NOT NULL,
	AccountPeriodUid UNIQUEIDENTIFIER,
	InsuranceCarrierUid UNIQUEIDENTIFIER,
	InsuranceCarrierName VARCHAR(100),
	InsurancePlanUid UNIQUEIDENTIFIER,
	InsurancePlanName VARCHAR(100),
	InsurancePhoneNumber VARCHAR(50),
	ReimbursementRuleUid UNIQUEIDENTIFIER,
	IsEPrescribingIncentive BIT NOT NULL,
	PQRIGroupUid UNIQUEIDENTIFIER,
	PatienteRxEligibilityUid UNIQUEIDENTIFIER,	
	FormularyOrgUid UNIQUEIDENTIFIER,
	FormularyOrgName VARCHAR(100),
	FormularyIdentifierUid UNIQUEIDENTIFIER,
	FormularyVendorUid UNIQUEIDENTIFIER,
	FormularyID VARCHAR(10),
	FormularyAlternativesOrgUid UNIQUEIDENTIFIER,
	AlternativesID VARCHAR(10),
	FormularyCopayOrgUid UNIQUEIDENTIFIER,
	FormularyCoverageOrgUid UNIQUEIDENTIFIER,
	MailOrderEligible bit,
	EligibilityDate DATETIME,
	ExpirationDate DATETIME,
	LastSucceedRXBenefitsDownloadedDate DATETIME,
	LastSucceedeMedHXDownloadedDate DATETIME,
	PlanMemberID VARCHAR(50),
	PlanGroupID VARCHAR(50),
	InsuredName VARCHAR(100),
	InsuredRelation VARCHAR(100),
	AccountType VARCHAR(50),
	AccountTypeANSICode VARCHAR(2))
AS
BEGIN
	IF @accountUid IS NULL
		SELECT	@accountUid = AccountUid
		FROM	Account
		WHERE	PersonUid = @patientUid AND
				IsMain = 1
				
	IF @patientUid IS NULL
		SELECT	@patientUid = PersonUid
		FROM	Account
		WHERE	AccountUid = @accountUid
		
	DECLARE @accountPeriodUid UNIQUEIDENTIFIER
	

	INSERT	@viewPrimaryInsurance
	SELECT	a.AccountUid, a.Name AS AccountName, a.IsMain,
			a.PersonUid AS PatientUid,			
			ap.AccountPeriodUid,
			ip.InsuranceCarrierUid, c.Name AS InsuranceCarrierName,
			ip.InsurancePlanUid, ip.Name AS InsurancePlanName,
			CASE WHEN ip.UseCarrierAddress = 1 THEN c.[Phone1].value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(100)'') ELSE ip.[Phone].value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(100)'') END AS InsurancePhoneNumber,
			ISNULL(ip.ReimbursementRuleUid, ic.ReimbursementRuleUid) AS ReimbursementRuleUid,
			ISNULL(ic.IsEPrescribingIncentive, 0),
			ic.PQRIGroupUid,
			elg.PatienteRxEligibilityUid,
			fo.FormularyOrgUid,
			fo.Name AS FormularyOrgName,
			fo.FormularyIdentifierUid,
			fo.FormularyVendorUid,
			fo.FormularyID,
			elg.FormularyAlternativesOrgUid,
			fao.AlternativesID,			
			elg.FormularyCopayOrgUid,
			elg.FormularyCoverageOrgUid,
			ISNULL(elg.MailOrderEligible, 1),
			elg.EligibilityDate,
			elg.ExpirationDate,		
			dl.LastSucceedRXBenefitsDownloadedDate,
			dl.LastSucceedeMedHXDownloadedDate,
			pip.PlanMemberID, pip.PlanGroupID,
			ins.FullName AS InsuredName, r.Name AS InsuredRelation,
			at.Name AS AccountType, at.ANSICode AS AccountTypeANSICode
	FROM	Account a INNER JOIN AccountPeriod ap ON a.AccountUid = ap.AccountUid
			LEFT JOIN AccountInsurance ai ON ai.AccountPeriodUid = ap.AccountPeriodUid AND ai.DisplayOrder = 1
			LEFT JOIN PersonInsurancePlan pip ON ai.PersonInsurancePlanUid = pip.PersonInsurancePlanUid
			LEFT JOIN InsurancePlan ip ON pip.InsurancePlanUid = ip.InsurancePlanUid
			LEFT JOIN InsuranceCarrier ic ON ip.InsuranceCarrierUid = ic.CorporationUid
			LEFT JOIN Corporation c ON ic.CorporationUid = c.CorporationUid
			LEFT JOIN PatienteRxEligibility elg ON ISNULL(@patienteRxEligibilityUid, a.PatienteRxEligibilityUid) = elg.PatienteRxEligibilityUid
			LEFT JOIN FormularyAlternativesOrg fao ON elg.FormularyAlternativesOrgUid = fao.FormularyAlternativesOrgUid
			LEFT JOIN FormularyOrg fo ON elg.FormularyOrgUid = fo.FormularyOrgUid
			LEFT JOIN eRxBenefitsDownload AS dl ON a.PersonUid = dl.PatientUid
			LEFT JOIN ViewPerson ins ON pip.PersonUid = ins.PersonUid
			LEFT JOIN ListRelationship r ON ai.RelationshipUid = r.RelationshipUid
			LEFT JOIN ListAccountType at ON ap.AccountTypeUid = at.AccountTypeUid
	WHERE	(	@accountUid = ''00000000-0000-0000-0000-000000000000'' OR
				a.AccountUid = @accountUid
			) AND
			a.PersonUid = @patientUid AND
			ap.AccountPeriodUid = dbo.GetAccountPeriod(a.AccountUid, @date)
	
	UPDATE	vpi
	SET		IsEPrescribingIncentive = 1
	FROM	@viewPrimaryInsurance vpi INNER JOIN AccountInsurance ai ON vpi.AccountPeriodUid = ai.AccountPeriodUid
			LEFT JOIN PersonInsurancePlan pip ON ai.PersonInsurancePlanUid = pip.PersonInsurancePlanUid
			LEFT JOIN InsurancePlan ip ON pip.InsurancePlanUid = ip.InsurancePlanUid
			LEFT JOIN InsuranceCarrier ic ON ip.InsuranceCarrierUid = ic.CorporationUid
	WHERE	ic.IsEPrescribingIncentive = 1 AND
			vpi.IsEPrescribingIncentive = 0

	UPDATE	vpi
	SET		PQRIGroupUid = ic.PQRIGroupUid
	FROM	@viewPrimaryInsurance vpi INNER JOIN AccountInsurance ai ON vpi.AccountPeriodUid = ai.AccountPeriodUid
			LEFT JOIN PersonInsurancePlan pip ON ai.PersonInsurancePlanUid = pip.PersonInsurancePlanUid
			LEFT JOIN InsurancePlan ip ON pip.InsurancePlanUid = ip.InsurancePlanUid
			LEFT JOIN InsuranceCarrier ic ON ip.InsuranceCarrierUid = ic.CorporationUid
	WHERE	NOT ic.PQRIGroupUid IS NULL AND
			vpi.PQRIGroupUid IS NULL
	RETURN 
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewSQLSourceCode]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ViewSQLSourceCode](@doSortOrder BIT)
RETURNS
   @ReturnTable TABLE (
      dbname            SYSNAME        NOT NULL,
      type_desc         NVARCHAR(60)   NOT NULL,
      name              SYSNAME        NOT NULL,
      entity            SYSNAME        NOT NULL,
      subentity         SYSNAME        NOT NULL,
      object_id         INT            NULL,
      parent_object_id  INT            NULL,
      modify_date       DATETIME       NULL,
      sort_order        INT            NOT NULL DEFAULT(0),
      source            VARCHAR(MAX)   NOT NULL,
                                       PRIMARY KEY CLUSTERED(name, entity, subentity, type_desc))
AS
BEGIN
   /************************************************************************
    * Build up list of source in table variable                            *
    ************************************************************************/
   DECLARE @SourceCode TABLE(
      object_id         INT            NULL,
      parent_object_id  INT            NULL,
      type_desc         NVARCHAR(60)   NOT NULL,
      name              SYSNAME        NOT NULL,
      entity            SYSNAME        NOT NULL,
      subentity         SYSNAME        NOT NULL,
      modify_date       DATETIME       NULL,
      sort_order        INT            NOT NULL DEFAULT(0),
      source            VARCHAR(MAX)   NOT NULL,
                                       PRIMARY KEY CLUSTERED(name, entity, subentity, type_desc))

   /************************************************************************
    * Procedures, Views, Functions and Triggers                            *
    ************************************************************************/
   INSERT INTO @SourceCode
   SELECT
      object_id         = obj.object_id,
      parent_object_id  = obj.parent_object_id,
      type_desc         = obj.type_desc,
      name              = obj.name,
      entity            = CASE obj.type_desc
                             WHEN ''SQL_TRIGGER'' THEN tab.name
                             ELSE obj.name
                          END,
      subentity         = '''',
      modify_date       = obj.modify_date,
      sort_order        = 0,
      source            = mdl.definition
   FROM sys.objects obj
   LEFT JOIN sys.sql_modules mdl ON mdl.object_id = obj.object_id
   LEFT JOIN sys.objects tab ON tab.object_id = obj.parent_object_id
   WHERE obj.type_desc IN(''SQL_STORED_PROCEDURE'',''VIEW'',''SQL_TABLE_VALUED_FUNCTION'',''SQL_INLINE_TABLE_VALUED_FUNCTION'',''SQL_SCALAR_FUNCTION'',''SQL_TRIGGER'')

   /************************************************************************
    * User Tables (no PK, FK, defaults, etc put in create statement)       *
    ************************************************************************/
   DECLARE
      @column_id     INT,
      @max_column_id INT

   INSERT INTO @SourceCode
   SELECT
      object_id         = obj.object_id,
      parent_object_id  = obj.parent_object_id,
      type_desc         = obj.type_desc,
      name              = obj.name,
      entity            = obj.name,
      subentity         = '''',
      modify_date       = obj.modify_date,
      sort_order        = 0,
      source            = ''CREATE TABLE '' + obj.name + ''(''
   FROM sys.objects obj
   WHERE obj.type_desc IN(''USER_TABLE'')

   SELECT
      @column_id     = MIN(col.column_id),
      @max_column_id = MAX(col.column_id)
   FROM sys.columns col
   INNER JOIN @SourceCode src ON src.object_id = col.object_id

   WHILE (@column_id <= @max_column_id)
      BEGIN
         UPDATE @SourceCode
         SET source = source
                    + CASE WHEN @column_id = 1 THEN '''' ELSE '', '' END
                    + col.name
                    + '' ''
                    + typ.name
                    + CASE typ.name
                         WHEN ''varbinary''      THEN ''('' + CASE WHEN col.max_length = -1 THEN ''max'' ELSE CONVERT(VARCHAR(80), col.max_length) END + '')''
                         WHEN ''varchar''        THEN ''('' + CASE WHEN col.max_length = -1 THEN ''max'' ELSE CONVERT(VARCHAR(80), col.max_length) END + '')''
                         WHEN ''nvarchar''       THEN ''('' + CASE WHEN col.max_length = -1 THEN ''max'' ELSE CONVERT(VARCHAR(80), col.max_length/2) END + '')''
                         WHEN ''binary''         THEN ''('' + CONVERT(VARCHAR(80), col.max_length) + '')''
                         WHEN ''char''           THEN ''('' + CONVERT(VARCHAR(80), col.max_length) + '')''
                         WHEN ''nchar''          THEN ''('' + CONVERT(VARCHAR(80), col.max_length/2) + '')''
                         WHEN ''datetime2''      THEN ''('' + CONVERT(VARCHAR(80), col.precision) + '')''
                         WHEN ''datetimeoffset'' THEN ''('' + CONVERT(VARCHAR(80), col.precision) + '')''
                         WHEN ''time''           THEN ''('' + CONVERT(VARCHAR(80), col.precision) + '')''
                         WHEN ''decimal''        THEN ''('' + CONVERT(VARCHAR(80), col.precision) + '','' + CONVERT(VARCHAR(80), col.scale) + '')''
                         WHEN ''numeric''        THEN ''('' + CONVERT(VARCHAR(80), col.precision) + '','' + CONVERT(VARCHAR(80), col.scale) + '')''
                         WHEN ''float''          THEN CASE WHEN col.precision != 53 THEN ''('' + CONVERT(VARCHAR(80), col.precision) + '')'' ELSE '''' END
                         WHEN ''xml''            THEN CASE WHEN col.xml_collection_id != 0
                                                       THEN ''(CONTENT dbo.'' + (SELECT sch.name FROM sys.xml_schema_collections sch where sch.xml_collection_id = col.xml_collection_id) + '')''
                                                       ELSE ''''
                                                    END
                         ELSE ''''
                      END +
                    + CASE WHEN col.is_rowguidcol = 1 THEN '' ROWGUIDCOL'' ELSE '''' END
                    + CASE WHEN col.is_nullable = 0 THEN '' NOT NULL'' ELSE '' NULL'' END
                    + CASE WHEN col.is_filestream = 1 THEN '' FILESTREAM'' ELSE '''' END
         FROM @SourceCode src
         INNER JOIN sys.columns col ON col.object_id = src.object_id AND col.column_id = @column_id
         INNER JOIN sys.types typ ON typ.system_type_id = col.system_type_id AND typ.user_type_id = col.user_type_id
         WHERE src.type_desc IN(''USER_TABLE'')
         SET @column_id = @column_id + 1
      END

   UPDATE @SourceCode
   SET source = source + '')''
   WHERE type_desc IN(''USER_TABLE'')


   /************************************************************************
    * Synonyms                                                             *
    ************************************************************************/
   INSERT INTO @SourceCode
   SELECT
      object_id         = obj.object_id,
      parent_object_id  = obj.parent_object_id,
      type_desc         = obj.type_desc,
      name              = obj.name,
      entity            = obj.name,
      subentity         = '''',
      modify_date       = obj.modify_date,
      sort_order        = 0,
      source            = ''CREATE SYNONYM '' + obj.name + '' FOR '' + syn.base_object_name
   FROM sys.objects obj
   LEFT JOIN sys.synonyms syn ON syn.object_id = obj.object_id
   WHERE obj.type_desc IN(''SYNONYM'')


   /************************************************************************
    * Defaults                                                             *
    ************************************************************************/
   INSERT INTO @SourceCode
   SELECT
      object_id         = obj.object_id,
      parent_object_id  = obj.parent_object_id,
      type_desc         = obj.type_desc,
      name              = obj.name,
      entity            = tab.name,
      subentity         = col.name,
      modify_date       = obj.modify_date,
      sort_order        = 0,
      source            = ''ALTER TABLE '' + tab.name
      + '' ADD CONSTRAINT ['' + obj.name
                          + ''] DEFAULT''
                          + def.definition
                          + '' FOR '' + col.name
   FROM sys.objects obj
   INNER JOIN sys.default_constraints def ON def.object_id = obj.object_id
   INNER JOIN sys.objects tab ON tab.object_id = def.parent_object_id
   INNER JOIN sys.columns col ON col.object_id = def.parent_object_id AND col.column_id = def.parent_column_id
   WHERE obj.type_desc IN(''DEFAULT_CONSTRAINT'')
     AND tab.type_desc != ''SQL_TABLE_VALUED_FUNCTION''


   /************************************************************************
    * Checks (not all options supported)                                   *
    ************************************************************************/
   INSERT INTO @SourceCode
   SELECT
      object_id         = obj.object_id,
      parent_object_id  = obj.parent_object_id,
      type_desc         = obj.type_desc,
      name              = obj.name,
      entity            = tab.name,
      subentity         = ''xxx'',
      modify_date       = obj.modify_date,
      sort_order        = 0,
      source            = ''ALTER TABLE '' + tab.name
                          + '' ADD CONSTRAINT '' + obj.name
                          + '' CHECK''
                          + chk.definition
   FROM sys.objects obj
   INNER JOIN sys.objects tab ON tab.object_id = obj.parent_object_id
   INNER JOIN sys.check_constraints chk ON chk.object_id = obj.object_id AND chk.name = obj.name
   WHERE obj.type_desc IN(''CHECK_CONSTRAINT'')


   /************************************************************************
    * Primary keys (not all options supported)                             *
    ************************************************************************/
   INSERT INTO @SourceCode
   SELECT
      object_id         = obj.object_id,
      parent_object_id  = obj.parent_object_id,
      type_desc         = obj.type_desc,
      name              = obj.name,
      entity            = tab.name,
      subentity         = '''',
      modify_date       = obj.modify_date,
      sort_order        = 0,
      source            = ''ALTER TABLE '' + tab.name + '' ADD CONSTRAINT ['' + obj.name + ''] PRIMARY KEY '' + CASE WHEN ind.type = 1 THEN ''CLUSTERED('' ELSE ''NONCLUSTERED('' END
   FROM sys.objects obj
   INNER JOIN sys.indexes ind ON ind.object_id = obj.parent_object_id AND ind.name = obj.name
   INNER JOIN sys.objects tab ON tab.object_id = obj.parent_object_id
   WHERE obj.type_desc IN(''PRIMARY_KEY_CONSTRAINT'')
     AND tab.type_desc != ''SQL_TABLE_VALUED_FUNCTION''
   DECLARE
      @key_ordinal     INT,
      @max_key_ordinal INT

   SELECT
      @key_ordinal     = MIN(ink.key_ordinal),
      @max_key_ordinal = MAX(ink.key_ordinal)
   FROM @SourceCode src
   INNER JOIN sys.indexes ind ON ind.object_id = src.parent_object_id AND ind.name = src.name
   INNER JOIN sys.index_columns ink ON ink.object_id = ind.object_id AND ink.index_id = ind.index_id
   WHERE src.type_desc IN(''PRIMARY_KEY_CONSTRAINT'')

   WHILE (@key_ordinal <= @max_key_ordinal)
      BEGIN
         UPDATE @SourceCode
         SET source     = source
                        + CASE WHEN @key_ordinal = 1 THEN '''' ELSE '', '' END
                        + col.name
                        + CASE WHEN is_descending_key = 1 THEN '' DESC'' ELSE '''' END,
             subentity  = CASE WHEN @key_ordinal = 1 THEN col.name ELSE '''' END
         FROM @SourceCode src
         INNER JOIN sys.objects obj ON obj.object_id = src.object_id
         INNER JOIN sys.indexes ind ON ind.object_id = obj.parent_object_id AND ind.name = obj.name
         --INNER JOIN sys.objects tab ON tab.object_id = obj.parent_object_id
         INNER JOIN sys.index_columns ink ON ink.object_id = ind.object_id AND ink.index_id = ind.index_id AND ink.key_ordinal = @key_ordinal
         INNER JOIN sys.columns col ON col.object_id = obj.parent_object_id AND col.column_id = ink.column_id
         WHERE obj.type_desc IN(''PRIMARY_KEY_CONSTRAINT'')
           AND ink.is_included_column = 0

         SET @key_ordinal = @key_ordinal + 1
      END

   UPDATE @SourceCode
   SET source = source + '')''
   WHERE type_desc IN(''PRIMARY_KEY_CONSTRAINT'')


   /************************************************************************
    * Foreign keys (not all options supported)                             *
    ************************************************************************/
   INSERT INTO @SourceCode
   SELECT
      object_id         = obj.object_id,
      parent_object_id  = obj.parent_object_id,
      type_desc         = obj.type_desc,
      name              = obj.name,
      entity            = tab.name,
      subentity         = fkc.name,
      modify_date       = obj.modify_date,
      sort_order        = 0,
      source            = ''ALTER TABLE '' + tab.name
                          + '' ADD CONSTRAINT '' + obj.name
                          + '' FOREIGN KEY('' + fkc.name + '') REFERENCES ''
                          + tbl.name + ''('' + rfc.name + '')''
                          + (CASE fky.update_referential_action_desc
                                WHEN ''NO_ACTION''   THEN ''''
                                WHEN ''CASCADE''     THEN '' ON UPDATE CASCADE''
                                WHEN ''SET_NULL''    THEN '' ON UPDATE SET NULL''
                                WHEN ''SET_DEFAULT'' THEN '' ON UPDATE SET DEFAULT''
                             END)
                          + (CASE fky.delete_referential_action_desc
                                WHEN ''NO_ACTION''   THEN ''''
                                WHEN ''CASCADE''     THEN '' ON DELETE CASCADE''
                                WHEN ''SET_NULL''    THEN '' ON DELETE SET NULL''
                                WHEN ''SET_DEFAULT'' THEN '' ON DELETE SET DEFAULT''
                             END)
   FROM sys.objects obj
   INNER JOIN sys.objects tab ON tab.object_id = obj.parent_object_id
   INNER JOIN sys.foreign_keys fky ON fky.object_id = obj.object_id AND fky.name = obj.name
   INNER JOIN sys.objects tbl ON tbl.object_id = fky.referenced_object_id
   INNER JOIN sys.foreign_key_columns cns ON cns.constraint_object_id = obj.object_id
   INNER JOIN sys.columns fkc ON fkc.object_id = cns.parent_object_id AND fkc.column_id = cns.parent_column_id
   INNER JOIN sys.columns rfc ON rfc.object_id = cns.referenced_object_id AND rfc.column_id = cns.referenced_column_id
   WHERE obj.type_desc IN(''FOREIGN_KEY_CONSTRAINT'')


   /************************************************************************
    * Indexes (not all options supported)                                  *
    ************************************************************************/
   DECLARE @ix_schema TABLE(
      TableName    VARCHAR(128)   NOT NULL,
      IndexName    VARCHAR(128)   NOT NULL,
      ColumnName   VARCHAR(128)   NOT NULL,
      KeyNo        INT            NOT NULL,
      ColNo        INT            NOT NULL,
      IsClustered  BIT            NOT NULL,
      IsUnique     BIT            NOT NULL,
      IsDescending BIT            NOT NULL,
      PRIMARY KEY CLUSTERED(TableName, IndexName, ColumnName, KeyNo, ColNo))

   INSERT INTO @ix_schema(
      TableName,
      IndexName,
      ColumnName,
      KeyNo,
      ColNo,
      IsClustered,
      IsUnique,
      IsDescending)
   SELECT
      TableName    = RTRIM(obj.name),
      IndexName    = RTRIM(ind.name),
      ColumnName   = RTRIM(col.name),
      KeyNo        = RTRIM(ink.key_ordinal),
      ColNo        = RTRIM(col.column_id),
      IsClustered  = CASE WHEN ind.type = 1 THEN 1 ELSE 0 END,
      IsUnique     = CASE WHEN ind.is_unique = 1 THEN 1 ELSE 0 END,
      IsDescending = ink.is_descending_key
   FROM sys.indexes ind
   INNER JOIN sys.objects obj ON obj.object_id = ind.object_id
                             AND obj.type != ''S''
   INNER JOIN sys.index_columns ink ON ink.object_id = ind.object_id
                                   AND ink.index_id = ind.index_id
   INNER JOIN sys.columns col ON col.object_id = ind.object_id
                             AND col.column_id = ink.column_id
   WHERE ind.is_primary_key = 0
     AND obj.type_desc != ''INTERNAL_TABLE''
   ORDER BY obj.name, ind.name, col.name

   DECLARE @ix_create TABLE(
      TableName    VARCHAR(128)   NOT NULL,
      IndexName    VARCHAR(128)   NOT NULL,
      IsClustered  BIT            NOT NULL,
      IsUnique     BIT            NOT NULL,
      IndexStr     VARCHAR(MAX)   NULL,
      IndexInc     VARCHAR(MAX)   NULL,
      IndexSQL     VARCHAR(MAX)   NULL,
      PRIMARY KEY CLUSTERED(TableName, IndexName))

   INSERT INTO @ix_create(
      TableName,
      IndexName,
      IsClustered,
      IsUnique)
   SELECT DISTINCT
      TableName,
      IndexName,
      IsClustered,
      IsUnique
   FROM @ix_schema

   DECLARE
      @i        INT,
      @MaxColNo INT

   SET @i = 1
   SELECT @MaxColNo = MAX(KeyNo) FROM @ix_schema
   WHILE @i <= @MaxColNo
      BEGIN
         UPDATE @ix_create
         SET IndexStr = ISNULL(IndexStr + '', '', '''') + ixs.ColumnName + CASE WHEN ixs.IsDescending = 1 THEN '' DESC'' ELSE '''' END
         FROM @ix_create ind
         INNER JOIN @ix_schema ixs ON ixs.TableName = ind.TableName
                                  AND ixs.IndexName = ind.IndexName
                                  AND ixs.KeyNo = @i
         SELECT @i = @i + 1
      END

   SET @i = 1
   SELECT @MaxColNo = MAX(ColNo) FROM @ix_schema
   WHILE @i <= @MaxColNo
      BEGIN
         UPDATE @ix_create
         SET IndexInc = ISNULL(IndexInc + '', '', '''') + ixs.ColumnName + CASE WHEN ixs.IsDescending = 1 THEN '' DESC'' ELSE '''' END
         FROM @ix_create ind
         INNER JOIN @ix_schema ixs ON ixs.TableName = ind.TableName
                                  AND ixs.IndexName = ind.IndexName
                                  AND ixs.KeyNo = 0
                                  AND ixs.ColNo = @i
         SELECT @i = @i + 1
      END

   UPDATE @ix_create
   SET IndexSQL =
            ''CREATE '' +
            CASE WHEN ind.IsUnique = 1 THEN ''UNIQUE '' ELSE '''' END +
            CASE WHEN ind.IsClustered = 1 THEN ''CLUSTERED '' ELSE '''' END +
            ''INDEX '' +
            ind.IndexName +
            '' ON '' + ind.TableName +
            ''('' + ind.IndexStr + '')'' +
            ISNULL('' INCLUDE('' + ind.IndexInc + '')'', '''')
   FROM @ix_create ind
   LEFT JOIN sys.objects obj ON obj.type_desc = ''UNIQUE_CONSTRAINT'' AND obj.name = ind.IndexName
   WHERE obj.object_id IS NULL

   UPDATE @ix_create
   SET IndexSQL =
            ''ALTER TABLE '' + ind.TableName +
            '' ADD CONSTRAINT '' + ind.IndexName +
            CASE WHEN ind.IsUnique = 1 THEN '' UNIQUE'' ELSE '''' END +
            CASE WHEN ind.IsClustered = 1 THEN '' CLUSTERED'' ELSE '' NONCLUSTERED'' END +
            ''('' + ind.IndexStr + '')''
   FROM @ix_create ind
   LEFT JOIN sys.objects obj ON obj.type_desc = ''UNIQUE_CONSTRAINT'' AND obj.name = ind.IndexName
   WHERE obj.object_id IS NOT NULL

   INSERT INTO @SourceCode
   SELECT
      object_id         = obj.object_id,
      parent_object_id  = obj.parent_object_id,
      type_desc         = ISNULL(obj.type_desc, ''INDEX''),
      name              = ISNULL(obj.name, ind.IndexName),
      entity            = ind.TableName,
      subentity         = '''',
      modify_date       = obj.modify_date,
      sort_order        = 0,
      source            = ind.IndexSQL
   FROM @ix_create ind
   LEFT JOIN sys.objects obj ON obj.type_desc = ''UNIQUE_CONSTRAINT'' AND obj.name = ind.IndexName

   /************************************************************************
    * User Defined Data Types                                              *
    ************************************************************************/
   INSERT INTO @SourceCode
   SELECT
      object_id         = NULL,
      parent_object_id  = NULL,
      type_desc         = ''USER-DEFINED-DATA-TYPE'',
      name              = udt.name,
      entity            = '''',
      subentity         = '''',
      modify_date       = NULL,
      sort_order        = 0,
      source            = ''CREATE TYPE dbo.'' + udt.name
                          + '' FROM  ''
                          + sys.name
                          + (CASE WHEN udt.is_nullable = 1 THEN '' NULL'' ELSE '' NOT NULL'' END)
   FROM sys.types udt
   INNER JOIN sys.types sys ON sys.user_type_id = udt.system_type_id
   WHERE udt.is_user_defined = 1


   /************************************************************************
    * XML Schemas                                                          *
    ************************************************************************/
   INSERT INTO @SourceCode
   SELECT
      object_id         = NULL,
      parent_object_id  = NULL,
      type_desc         = ''XML_SCHEMA'',
      name              = xsc.name,
      entity            = '''',
      subentity         = '''',
      modify_date       = NULL,
      sort_order        = 0,
      source            = ''CREATE XML SCHEMA COLLECTION '' + xsc.name + '' AS '''''' + REPLACE(CONVERT(VARCHAR(MAX), xml_schema_namespace(schema_name(xsc.schema_id), xsc.name)), '''''''', '''''''''''') + ''''''''
   FROM sys.xml_schema_collections xsc
   WHERE xsc.name != ''sys''


   /************************************************************************
    * Extended Properties                                                  *
    ************************************************************************/
   INSERT INTO @SourceCode
   SELECT
      object_id         = NULL,
      parent_object_id  = ext.major_id,
      type_desc         = ''EXTENDED-PROPERTY-'' + CASE obj.type_desc
                                                    WHEN ''USER_TABLE'' THEN ''TABLE''
                                                    WHEN ''VIEW''       THEN ''VIEW''
                                                    WHEN ''SQL_INLINE_TABLE_VALUED_FUNCTION'' THEN ''FUNCTION''
                                                    WHEN ''SQL_STORED_PROCEDURE'' THEN ''PROCEDURE''
                                                    WHEN ''SQL_SCALAR_FUNCTION'' THEN ''FUNCTION''
                                                    WHEN ''SQL_TABLE_VALUED_FUNCTION'' THEN ''FUNCTION''
                                                 END +
                                                 CASE
                                                    WHEN ext.minor_id > 0 THEN ''-COLUMN''
                                                    ELSE ''''
                                                 END,
      name              = ext.name,
      entity            = OBJECT_NAME(ext.major_id),
      subentity         = ISNULL(col.name, ''''),
      modify_date       = NULL,
      sort_order        = 0,
      source            = ''EXEC sys.sp_addextendedproperty @name='''''' + ext.name + '''''''' +
                          '', @value='' + ISNULL('''''''' +  REPLACE(CONVERT(VARCHAR(MAX), ext.value), '''''''', '''''''''''') + '''''''', ''NULL'') +
                          '', @level0type=''''SCHEMA'''''' +
                          '', @level0name=''''dbo'''''' +
                          '', @level1type='''''' + CASE obj.type_desc
                                                  WHEN ''USER_TABLE'' THEN ''TABLE''
                                                  WHEN ''VIEW''       THEN ''VIEW''
                                                  WHEN ''SQL_INLINE_TABLE_VALUED_FUNCTION'' THEN ''FUNCTION''
                                                  WHEN ''SQL_STORED_PROCEDURE'' THEN ''PROCEDURE''
                                                  WHEN ''SQL_SCALAR_FUNCTION'' THEN ''FUNCTION''
                                                  WHEN ''SQL_TABLE_VALUED_FUNCTION'' THEN ''FUNCTION''
     END +
                          '''''', @level1name='''''' + OBJECT_NAME(ext.major_id) + '''''''' +
                          (CASE
                              WHEN col.name IS NULL THEN ''''
                              ELSE '', @level2type=''''COLUMN'' + '''''', @level2name='''''' + ISNULL(col.name, '''') + ''''''''
                           END)
   FROM sys.extended_properties AS ext
   INNER JOIN sys.objects obj ON obj.object_id = ext.major_id
   LEFT JOIN sys.tables AS tab ON tab.object_id = ext.major_id
   LEFT JOIN sys.columns AS col ON col.object_id = ext.major_id
                                AND col.column_id = ext.minor_id
   WHERE ext.name != ''microsoft_database_tools_support''

   /************************************************************************
    * Dependency graph                                                     *
    ************************************************************************/
   IF (@doSortOrder = 1)
      BEGIN
         DECLARE @t1 table(         PRIMARY KEY(tid, pid), UNIQUE(pid, tid),
            tid      INT            NOT NULL DEFAULT(0),    -- temp object id
            pid      INT            NOT NULL DEFAULT(0),    -- parent or child object id
            bDone    SMALLINT       NULL)                   -- NULL means dependencies not yet evaluated

         DECLARE @t2 TABLE(         PRIMARY KEY(tid, pid), UNIQUE(pid, tid),
            tid      INT            NOT NULL,
            pid      INT            NOT NULL,
            bDone    SMALLINT       NULL)

         -- get all the objects
         INSERT @t1(pid)
         SELECT pid = sos.object_id
         FROM sys.objects sos
         WHERE sos.type_desc NOT IN(''PRIMARY_KEY_CONSTRAINT'',
                                    ''FOREIGN_KEY_CONSTRAINT'',
                                    ''UNIQUE_CONSTRAINT'',
                                    ''SYSTEM_TABLE'',
                                    ''DEFAULT_CONSTRAINT'',
                                    ''INTERNAL_TABLE'',
                                    ''CLR_STORED_PROCEDURE'',
                                    ''CLR_SCALAR_FUNCTION'',
                                    ''SERVICE_QUEUE'')

         WHILE (SELECT COUNT(*) FROM @t1 WHERE bDone IS NULL) > 0
            BEGIN
               -- Trigger --> Table
               INSERT @t2(tid, pid)
               SELECT
                  tid      = tmp.pid,
                  pid      = sos.parent_object_id
               FROM @t1 tmp
               INNER JOIN sys.objects sos ON sos.object_id = tmp.pid
               INNER JOIN sys.objects par ON par.object_id = sos.parent_object_id
               WHERE tmp.bDone IS NULL
                 AND sos.type_desc = ''SQL_TRIGGER''
                 AND sos.parent_object_id != 0

               -- Object --> sysdepends parents
               UNION
               SELECT
                  tid      = tmp.pid,
                  pid      = dep.depid
               FROM @t1 tmp
               INNER JOIN sys.sysdepends dep ON dep.id = tmp.pid
               INNER JOIN sys.objects sos ON sos.object_id = dep.depid
               WHERE tmp.bDone is null

               -- Object --> sysreferences parents (PK/UQ tables referenced by one)
               UNION
               SELECT
                  tid      = tmp.pid,
                  pid      = r.rkeyid
               FROM @t1 tmp
               INNER JOIN sysreferences r ON r.fkeyid = tmp.pid
               INNER JOIN sys.objects sos ON sos.object_id = r.rkeyid
               WHERE tmp.bDone IS NULL

               UPDATE @T1 SET bDone = 1

               INSERT @t1
               SELECT new.*
               FROM @t2 new
               LEFT JOIN @t1 old ON old.tid = new.tid AND old.pid = new.pid
               WHERE old.pid IS NULL

               DELETE @t2
            END

         INSERT @t1(tid, bDone)
         SELECT DISTINCT
            tid      = tmp.pid,
            bDone    = 0
        FROM @t1 tmp
         LEFT JOIN @t1 tab ON tab.tid = tmp.pid AND tab.tid != tab.pid    AND tab.tid != 0 AND tab.pid != 0
         WHERE tab.tid IS NULL

         -- remove self-refs
         DELETE @t1 WHERE tid = pid

         -- remove rows where the trigger is the parent.
         DELETE tmp
         FROM @t1 tmp
         INNER JOIN sys.objects sos ON sos.object_id = tmp.pid
         WHERE sos.type_desc = ''SQL_TRIGGER''

         -- update statistics
         DELETE tmp
         FROM @t1 tmp
         WHERE tmp.tid = 0 OR tmp.tid = tmp.pid

         DELETE tmp
         FROM @t1 tmp
         INNER JOIN @t1 tab ON tab.tid = tmp.tid AND tab.pid != 0
         WHERE tmp.pid = 0
           AND tmp.tid != 0

         UPDATE @t1 SET bDone = 0
         DECLARE
            @curid         INT,
            @rowsaffected  INT

         SET @curid = 1
         SET @rowsaffected = 1
         WHILE (@rowsaffected <> 0)
            BEGIN
               UPDATE @t1
               SET bDone = @curid
               FROM @t1 t1
               WHERE t1.bDone = 0
                 AND t1.tid NOT IN(SELECT DISTINCT tmp.tid
                                   FROM @t1 tmp
                                   INNER JOIN @t1 tab ON tab.tid = tmp.pid AND tab.bDone = 0
                                   WHERE tmp.pid != 0
                                     AND tmp.tid != 0)

               SET @rowsaffected = @@rowcount
               SET @curid = @curid + 1
            END

         UPDATE @t1 SET bDone = @curid WHERE bDone = 0

         DECLARE @ObjectHierarchy TABLE(
            object_id     INT      NOT NULL PRIMARY KEY,
            object_seq    INT      NOT NULL)

         INSERT @ObjectHierarchy
         SELECT DISTINCT
            object_id  = sos.object_id,
            object_seq = tmp.bDone
         FROM sys.objects sos
         INNER JOIN @t1 tmp ON tmp.tid = sos.object_id AND tmp.tid != 0

         UPDATE @SourceCode
         SET sort_order = CASE src.type_desc
                             WHEN ''USER-DEFINED-DATA-TYPE''           THEN  10000
                             WHEN ''XML_SCHEMA''                       THEN  20000
                             WHEN ''SYNONYM''                          THEN  30000
                             WHEN ''USER_TABLE''                       THEN  40000
                             WHEN ''SQL_SCALAR_FUNCTION''              THEN  50000
                             WHEN ''VIEW''                             THEN  50000
                             WHEN ''SQL_INLINE_TABLE_VALUED_FUNCTION'' THEN  50000
                             WHEN ''SQL_TABLE_VALUED_FUNCTION''        THEN  50000
                             WHEN ''SQL_STORED_PROCEDURE''             THEN  50000
                             WHEN ''PRIMARY_KEY_CONSTRAINT''           THEN  90000
                             WHEN ''FOREIGN_KEY_CONSTRAINT''           THEN 100000
                             WHEN ''DEFAULT_CONSTRAINT''               THEN 110000
                             WHEN ''INDEX''                            THEN 120000
                             WHEN ''UNIQUE_CONSTRAINT''                THEN 130000
                             WHEN ''SQL_TRIGGER''                      THEN 140000
                             WHEN ''EXTENDED-PROPERTY-FUNCTION''       THEN 160000
                             WHEN ''EXTENDED-PROPERTY-TABLE''          THEN 170000
                             WHEN ''EXTENDED-PROPERTY-TABLE-COLUMN''   THEN 180000
                             WHEN ''EXTENDED-PROPERTY-VIEW''           THEN 190000
                             WHEN ''EXTENDED-PROPERTY-VIEW-COLUMN''    THEN 200000
                          END + ISNULL(object_seq, 0)
         FROM @SourceCode src
         LEFT JOIN @ObjectHierarchy ohi ON ohi.object_id = src.object_id
      END

   /************************************************************************
    * Return the table results               *
    ************************************************************************/
   INSERT INTO @ReturnTable(
      dbname,
      type_desc,
      name,
      entity,
      subentity,
      object_id,
      parent_object_id,
      modify_date,
      sort_order,
      source)
   SELECT
      dbname            = DB_NAME(),
      type_desc         = src.type_desc,
      name              = src.name,
      entity            = src.entity,
      subentity         = src.subentity,
      object_id         = src.object_id,
      parent_object_id  = src.parent_object_id,
      modify_date       = src.modify_date,
      sort_order        = src.sort_order,
      source            = src.source                        -- REPLACE(REPLACE(src.source, ''(NOEXPAND)'', ''''), ''NOEXPAND, '', '''')
   FROM @SourceCode src
   ORDER BY src.sort_order, src.type_desc, src.name DESC

   RETURN
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[VisitCSCosignStatus]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[VisitCSCosignStatus]
(
	@VisitUid [uniqueidentifier]
)
RETURNS [varchar](1024)
AS
BEGIN
	DECLARE @cosignStatus [varchar](1024) =
	(
		SELECT TOP(1) 
		CASE WHEN IsApproved = 1 THEN ''Approved '' 
		ELSE ''For