IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Account]') AND name = N'IX_Account')
CREATE CLUSTERED INDEX [IX_Account] ON [dbo].[Account]
(
	[PersonUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AccountPeriod]') AND name = N'IX_AccountPeriod')
CREATE CLUSTERED INDEX [IX_AccountPeriod] ON [dbo].[AccountPeriod]
(
	[AccountUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Appointment]') AND name = N'IX_Appointment')
CREATE CLUSTERED INDEX [IX_Appointment] ON [dbo].[Appointment]
(
	[CalendarUid] ASC,
	[StartDateTime] ASC,
	[EndDateTime] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Attachment]') AND name = N'IX_Attachment')
CREATE CLUSTERED INDEX [IX_Attachment] ON [dbo].[Attachment]
(
	[AttachmentGroupUid] ASC,
	[DisplayOrder] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AuditArchive]') AND name = N'IX_LastModifiedDate')
CREATE CLUSTERED INDEX [IX_LastModifiedDate] ON [dbo].[AuditArchive]
(
	[LastModifiedDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AuditCurrent]') AND name = N'IX_LastModifiedDate')
CREATE CLUSTERED INDEX [IX_LastModifiedDate] ON [dbo].[AuditCurrent]
(
	[LastModifiedDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AuditWorkflowLogArchive]') AND name = N'IX_AuditWorkflowLogArchive_LastModifiedDate')
CREATE CLUSTERED INDEX [IX_AuditWorkflowLogArchive_LastModifiedDate] ON [dbo].[AuditWorkflowLogArchive]
(
	[LastModifiedDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AuditWorkflowLogCurrent]') AND name = N'IX_AuditWorkflowLogCurrent_LastModifiedDate')
CREATE CLUSTERED INDEX [IX_AuditWorkflowLogCurrent_LastModifiedDate] ON [dbo].[AuditWorkflowLogCurrent]
(
	[LastModifiedDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ChargeCaptureDiagnosis]') AND name = N'IX_ChargeCaptureDiagnosis_ChargeCaptureUid')
CREATE CLUSTERED INDEX [IX_ChargeCaptureDiagnosis_ChargeCaptureUid] ON [dbo].[ChargeCaptureDiagnosis]
(
	[ChargeCaptureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ChargeCaptureProcedure]') AND name = N'IX_ChargeCaptureProcedure_ChargeCaptureUid')
CREATE CLUSTERED INDEX [IX_ChargeCaptureProcedure_ChargeCaptureUid] ON [dbo].[ChargeCaptureProcedure]
(
	[ChargeCaptureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ErrorReport]') AND name = N'IX_LastModifiedDate')
CREATE CLUSTERED INDEX [IX_LastModifiedDate] ON [dbo].[ErrorReport]
(
	[LastModifiedDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[JobHistory]') AND name = N'IX_JobHistory_LastModifiedDate')
CREATE CLUSTERED INDEX [IX_JobHistory_LastModifiedDate] ON [dbo].[JobHistory]
(
	[LastModifiedDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListFindControlBehavior]') AND name = N'IX_ListFindControlBehavior')
CREATE CLUSTERED INDEX [IX_ListFindControlBehavior] ON [dbo].[ListFindControlBehavior]
(
	[Id] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListScrubProfile]') AND name = N'IX_ExternalID')
CREATE CLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListScrubProfile]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MasterSnomedDescription]') AND name = N'IX_MasterSnomedDescription_Term')
CREATE CLUSTERED INDEX [IX_MasterSnomedDescription_Term] ON [dbo].[MasterSnomedDescription]
(
	[term] ASC,
	[category] ASC,
	[conceptId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageNote]') AND name = N'IX_MessageNote')
CREATE CLUSTERED INDEX [IX_MessageNote] ON [dbo].[MessageNote]
(
	[MessageUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageUser]') AND name = N'IX_MessageUser_MessageUid')
CREATE CLUSTERED INDEX [IX_MessageUser_MessageUid] ON [dbo].[MessageUser]
(
	[MessageUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientCP_CarePlan]') AND name = N'IX_PatientCP_CarePlan_1')
CREATE CLUSTERED INDEX [IX_PatientCP_CarePlan_1] ON [dbo].[PatientCP_CarePlan]
(
	[PatientUid] ASC,
	[PatientCP_CarePlanUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientCP_GoalHistory]') AND name = N'IX_PatientCP_GoalHistory_1')
CREATE CLUSTERED INDEX [IX_PatientCP_GoalHistory_1] ON [dbo].[PatientCP_GoalHistory]
(
	[PatientCP_CarePlanUid] ASC,
	[IsCurrentHistoryRow] DESC,
	[GroupingUid] ASC,
	[Sequence] DESC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientCP_GoalReviewHistory]') AND name = N'IX_PatientCP_GoalReviewHistory_1')
CREATE CLUSTERED INDEX [IX_PatientCP_GoalReviewHistory_1] ON [dbo].[PatientCP_GoalReviewHistory]
(
	[PatientCP_GoalHistoryUid] ASC,
	[IsCurrentHistoryRow] DESC,
	[GroupingUid] ASC,
	[Sequence] DESC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientCP_HealthConcernHistory]') AND name = N'IX_PatientCP_HealthConcernHistory_1')
CREATE CLUSTERED INDEX [IX_PatientCP_HealthConcernHistory_1] ON [dbo].[PatientCP_HealthConcernHistory]
(
	[PatientCP_CarePlanUid] ASC,
	[IsCurrentHistoryRow] DESC,
	[GroupingUid] ASC,
	[Sequence] DESC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientCP_InterventionHistory]') AND name = N'IX_PatientCP_InterventionHistory_1')
CREATE CLUSTERED INDEX [IX_PatientCP_InterventionHistory_1] ON [dbo].[PatientCP_InterventionHistory]
(
	[PatientCP_CarePlanUid] ASC,
	[IsCurrentHistoryRow] DESC,
	[GroupingUid] ASC,
	[Sequence] DESC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientMedicalDeviceHistory]') AND name = N'IX_PatientMedicalDeviceHistory_1')
CREATE CLUSTERED INDEX [IX_PatientMedicalDeviceHistory_1] ON [dbo].[PatientMedicalDeviceHistory]
(
	[PatientUid] ASC,
	[IsCurrentHistoryRow] DESC,
	[GroupingUid] ASC,
	[Sequence] DESC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientProblemDiagnosisHistory]') AND name = N'IX_PatientProblemDiagnosisHistory')
CREATE CLUSTERED INDEX [IX_PatientProblemDiagnosisHistory] ON [dbo].[PatientProblemDiagnosisHistory]
(
	[PatientUid] ASC,
	[IsCurrentHistoryRow] ASC,
	[GroupingUid] ASC,
	[Sequence] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientProcedureHistory]') AND name = N'IX_PatientProcedureHistory_1')
CREATE CLUSTERED INDEX [IX_PatientProcedureHistory_1] ON [dbo].[PatientProcedureHistory]
(
	[PatientUid] ASC,
	[IsCurrentHistoryRow] DESC,
	[HistoryGroupUid] ASC,
	[GroupingUid] ASC,
	[Sequence] DESC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelAccountResponsiblePartyFinancialCenter]') AND name = N'IX_AccountResponsiblePartyUid')
CREATE CLUSTERED INDEX [IX_AccountResponsiblePartyUid] ON [dbo].[RelAccountResponsiblePartyFinancialCenter]
(
	[AccountResponsiblePartyUid] ASC,
	[FinancialCenterUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCP_CarePlan_CP_Goal]') AND name = N'IX_RelCP_CarePlan_CP_Goal_1')
CREATE CLUSTERED INDEX [IX_RelCP_CarePlan_CP_Goal_1] ON [dbo].[RelCP_CarePlan_CP_Goal]
(
	[CP_CarePlanUid] ASC,
	[CP_GoalUid] ASC,
	[RelCP_CarePlan_CP_GoalUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelObservationItemDxTileConfiguration]') AND name = N'IX_RelObservationItemDxTileConfiguration_1')
CREATE CLUSTERED INDEX [IX_RelObservationItemDxTileConfiguration_1] ON [dbo].[RelObservationItemDxTileConfiguration]
(
	[DxTileConfigurationUid] ASC,
	[RelObservationItemDxTileConfigurationUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelOrderedProcedurePatientProcedureHistory]') AND name = N'IX_RelOrderedProcedurePatientProcedureHistory')
CREATE CLUSTERED INDEX [IX_RelOrderedProcedurePatientProcedureHistory] ON [dbo].[RelOrderedProcedurePatientProcedureHistory]
(
	[PatientProcedureHistoryUid] ASC,
	[VisitProcedureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPatientCP_Goal_PatientCP_HealthConcern]') AND name = N'IX_RelPatientCP_Goal_PatientCP_HealthConcern_1')
CREATE CLUSTERED INDEX [IX_RelPatientCP_Goal_PatientCP_HealthConcern_1] ON [dbo].[RelPatientCP_Goal_PatientCP_HealthConcern]
(
	[PatientCP_GoalHistoryUid] ASC,
	[PatientCP_HealthConcernHistoryUid] ASC,
	[RelPatientCP_Goal_PatientCP_HealthConcernUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPatientCP_Goal_PatientCP_Intervention]') AND name = N'IX_RelPatientCP_Goal_PatientCP_Intervention_1')
CREATE CLUSTERED INDEX [IX_RelPatientCP_Goal_PatientCP_Intervention_1] ON [dbo].[RelPatientCP_Goal_PatientCP_Intervention]
(
	[PatientCP_GoalHistoryUid] ASC,
	[PatientCP_InterventionHistoryUid] ASC,
	[RelPatientCP_Goal_PatientCP_InterventionUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPatientCP_Goal_PatientProblemDiagnosis]') AND name = N'IX_RelPatientCP_Goal_PatientProblemDiagnosis_1')
CREATE CLUSTERED INDEX [IX_RelPatientCP_Goal_PatientProblemDiagnosis_1] ON [dbo].[RelPatientCP_Goal_PatientProblemDiagnosis]
(
	[PatientCP_GoalHistoryUid] ASC,
	[PatientProblemDiagnosisHistoryUid] ASC,
	[RelPatientCP_Goal_PatientProblemDiagnosisUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPatientCP_HealthConcern_ObservationItem]') AND name = N'IX_RelPatientCP_HealthConcern_ObservationItem_1')
CREATE CLUSTERED INDEX [IX_RelPatientCP_HealthConcern_ObservationItem_1] ON [dbo].[RelPatientCP_HealthConcern_ObservationItem]
(
	[PatientCP_HealthConcernHistoryUid] ASC,
	[ObservationItemUid] ASC,
	[RelPatientCP_HealthConcern_ObservationItemUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPatientCP_HealthConcern_PatientHistory]') AND name = N'IX_RelPatientCP_HealthConcern_PatientHistory_1')
CREATE CLUSTERED INDEX [IX_RelPatientCP_HealthConcern_PatientHistory_1] ON [dbo].[RelPatientCP_HealthConcern_PatientHistory]
(
	[PatientCP_HealthConcernHistoryUid] ASC,
	[PatientHistoryDetailUid] ASC,
	[RelPatientCP_HealthConcern_PatientHistoryUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPatientCP_HealthConcern_PatientProblemDiagnosis]') AND name = N'IX_RelPatientCP_HealthConcern_PatientProblemDiagnosis_1')
CREATE CLUSTERED INDEX [IX_RelPatientCP_HealthConcern_PatientProblemDiagnosis_1] ON [dbo].[RelPatientCP_HealthConcern_PatientProblemDiagnosis]
(
	[PatientCP_HealthConcernHistoryUid] ASC,
	[PatientProblemDiagnosisHistoryUid] ASC,
	[RelPatientCP_HealthConcern_PatientProblemDiagnosisUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPerformProcedurePatientProcedureHistory]') AND name = N'IX_RelPerformProcedurePatientProcedureHistory')
CREATE CLUSTERED INDEX [IX_RelPerformProcedurePatientProcedureHistory] ON [dbo].[RelPerformProcedurePatientProcedureHistory]
(
	[PatientProcedureHistoryUid] ASC,
	[VisitProcedureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Visit]') AND name = N'IX_Visit')
CREATE CLUSTERED INDEX [IX_Visit] ON [dbo].[Visit]
(
	[PatientUid] ASC,
	[VisitDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitCC]') AND name = N'IX_VisitCC')
CREATE CLUSTERED INDEX [IX_VisitCC] ON [dbo].[VisitCC]
(
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitCoSign]') AND name = N'IX_VisitCoSign')
CREATE CLUSTERED INDEX [IX_VisitCoSign] ON [dbo].[VisitCoSign]
(
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitDiagnosis]') AND name = N'IX_VisitDiagnosis')
CREATE CLUSTERED INDEX [IX_VisitDiagnosis] ON [dbo].[VisitDiagnosis]
(
	[VisitDiagnosisUid] ASC,
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitEduForm]') AND name = N'IX_VisitEduForm')
CREATE CLUSTERED INDEX [IX_VisitEduForm] ON [dbo].[VisitEduForm]
(
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitGraphicNotes]') AND name = N'IX_VisitGraphicNotes')
CREATE CLUSTERED INDEX [IX_VisitGraphicNotes] ON [dbo].[VisitGraphicNotes]
(
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitHpi]') AND name = N'IX_VisitHpi')
CREATE CLUSTERED INDEX [IX_VisitHpi] ON [dbo].[VisitHpi]
(
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitPE]') AND name = N'IX_VisitPE')
CREATE CLUSTERED INDEX [IX_VisitPE] ON [dbo].[VisitPE]
(
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitProcedure]') AND name = N'IX_VisitProcedure')
CREATE CLUSTERED INDEX [IX_VisitProcedure] ON [dbo].[VisitProcedure]
(
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitProcedureDiagnosis]') AND name = N'IX_VisitProcedureDiagnosis')
CREATE CLUSTERED INDEX [IX_VisitProcedureDiagnosis] ON [dbo].[VisitProcedureDiagnosis]
(
	[VisitProcedureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitRos]') AND name = N'IX_VisitRos')
CREATE CLUSTERED INDEX [IX_VisitRos] ON [dbo].[VisitRos]
(
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitTranscription]') AND name = N'IX_VisitTranscription')
CREATE CLUSTERED INDEX [IX_VisitTranscription] ON [dbo].[VisitTranscription]
(
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitWatchItem]') AND name = N'IX_VisitWatchItem')
CREATE CLUSTERED INDEX [IX_VisitWatchItem] ON [dbo].[VisitWatchItem]
(
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AccessionTracking]') AND name = N'IX_LastModifiedDate')
CREATE NONCLUSTERED INDEX [IX_LastModifiedDate] ON [dbo].[AccessionTracking]
(
	[LastModifiedDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Account]') AND name = N'IRX_AccountUid_PersonUidW')
CREATE NONCLUSTERED INDEX [IRX_AccountUid_PersonUidW] ON [dbo].[Account]
(
	[AccountUid] ASC,
	[PersonUid] ASC
)
INCLUDE ( 	[ExternalID],
	[AccountResponsiblePartyUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Account]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[Account]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Account]') AND name = N'IX_IsMain')
CREATE NONCLUSTERED INDEX [IX_IsMain] ON [dbo].[Account]
(
	[IsMain] ASC
)
INCLUDE ( 	[AccountUid],
	[PersonUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Account]') AND name = N'IXR_AccountResponsiblePartyUid_ExternalID_AccountUid')
CREATE NONCLUSTERED INDEX [IXR_AccountResponsiblePartyUid_ExternalID_AccountUid] ON [dbo].[Account]
(
	[AccountResponsiblePartyUid] ASC,
	[ExternalID] ASC,
	[AccountUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Account]') AND name = N'IXR_AccountResponsiblePartyUid_PersonUid_ExternalID_AccountUid')
CREATE NONCLUSTERED INDEX [IXR_AccountResponsiblePartyUid_PersonUid_ExternalID_AccountUid] ON [dbo].[Account]
(
	[AccountResponsiblePartyUid] ASC,
	[PersonUid] ASC,
	[ExternalID] ASC,
	[AccountUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Account]') AND name = N'PatienteRxEligibilityUid')
CREATE NONCLUSTERED INDEX [PatienteRxEligibilityUid] ON [dbo].[Account]
(
	[PatienteRxEligibilityUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Account]') AND name = N'Person_Account_AccountResponsibleParty')
CREATE NONCLUSTERED INDEX [Person_Account_AccountResponsibleParty] ON [dbo].[Account]
(
	[PersonUid] ASC,
	[AccountUid] ASC,
	[AccountResponsiblePartyUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AccountInsurance]') AND name = N'AccountPeriod')
CREATE NONCLUSTERED INDEX [AccountPeriod] ON [dbo].[AccountInsurance]
(
	[AccountPeriodUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AccountInsurance]') AND name = N'AccountPerson_PersonInsurancePlan')
CREATE NONCLUSTERED INDEX [AccountPerson_PersonInsurancePlan] ON [dbo].[AccountInsurance]
(
	[AccountPeriodUid] ASC,
	[PersonInsurancePlanUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AccountInsurance]') AND name = N'DisplayOrder_PersonInsurancePlanUid_AccountPeriodUid')
CREATE NONCLUSTERED INDEX [DisplayOrder_PersonInsurancePlanUid_AccountPeriodUid] ON [dbo].[AccountInsurance]
(
	[DisplayOrder] ASC,
	[PersonInsurancePlanUid] ASC,
	[AccountPeriodUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AccountInsurance]') AND name = N'IX_AccountInsurance_LastModifiedDate')
CREATE NONCLUSTERED INDEX [IX_AccountInsurance_LastModifiedDate] ON [dbo].[AccountInsurance]
(
	[LastModifiedDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AccountInsurance]') AND name = N'IX_AccountPeriod_DisplayOrder')
CREATE UNIQUE NONCLUSTERED INDEX [IX_AccountPeriod_DisplayOrder] ON [dbo].[AccountInsurance]
(
	[AccountPeriodUid] ASC,
	[DisplayOrder] ASC
)
INCLUDE ( 	[PersonInsurancePlanUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AccountInsurance]') AND name = N'IXR_DisplayOrder_AccountPeriodUid_PersonInsurancePlanUid')
CREATE NONCLUSTERED INDEX [IXR_DisplayOrder_AccountPeriodUid_PersonInsurancePlanUid] ON [dbo].[AccountInsurance]
(
	[DisplayOrder] ASC,
	[AccountPeriodUid] ASC,
	[PersonInsurancePlanUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AccountInsurance]') AND name = N'ParentAccountInsuranceUid')
CREATE NONCLUSTERED INDEX [ParentAccountInsuranceUid] ON [dbo].[AccountInsurance]
(
	[ParentAccountInsuranceUid] ASC
)
INCLUDE ( 	[PersonInsurancePlanUid],
	[DisplayOrder],
	[RelationshipUid],
	[PolicyNumberSuffix],
	[LastModifiedDate],
	[LastModifiedByUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AccountInsurance]') AND name = N'PersonInsurancePlanUid')
CREATE NONCLUSTERED INDEX [PersonInsurancePlanUid] ON [dbo].[AccountInsurance]
(
	[PersonInsurancePlanUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AccountPeriod]') AND name = N'Account_AccountPeriod')
CREATE NONCLUSTERED INDEX [Account_AccountPeriod] ON [dbo].[AccountPeriod]
(
	[AccountUid] ASC,
	[AccountPeriodUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AccountPeriod]') AND name = N'AccountPeriodUid_AccountUid_EffectiveDate_ExpirationDate')
CREATE NONCLUSTERED INDEX [AccountPeriodUid_AccountUid_EffectiveDate_ExpirationDate] ON [dbo].[AccountPeriod]
(
	[AccountPeriodUid] ASC,
	[AccountUid] ASC,
	[EffectiveDate] ASC,
	[ExpirationDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AccountPeriod]') AND name = N'IX_AccountPeriod_PeriodDate')
CREATE NONCLUSTERED INDEX [IX_AccountPeriod_PeriodDate] ON [dbo].[AccountPeriod]
(
	[AccountUid] ASC,
	[ExpirationDate] ASC,
	[EffectiveDate] ASC,
	[AccountPeriodUid] ASC,
	[AccountTypeUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AccountPeriod]') AND name = N'IXR_ExpirationDate_AccountUid_AccountPeriodUid')
CREATE NONCLUSTERED INDEX [IXR_ExpirationDate_AccountUid_AccountPeriodUid] ON [dbo].[AccountPeriod]
(
	[ExpirationDate] ASC,
	[AccountUid] ASC,
	[AccountPeriodUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AccountResponsibleParty]') AND name = N'AccountResponsibleParty_Corporation')
CREATE NONCLUSTERED INDEX [AccountResponsibleParty_Corporation] ON [dbo].[AccountResponsibleParty]
(
	[AccountResponsiblePartyUid] ASC,
	[CorporationUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AccountResponsibleParty]') AND name = N'AccountResponsibleParty_Person')
CREATE NONCLUSTERED INDEX [AccountResponsibleParty_Person] ON [dbo].[AccountResponsibleParty]
(
	[AccountResponsiblePartyUid] ASC,
	[PersonUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AccountResponsibleParty]') AND name = N'ExternalID')
CREATE NONCLUSTERED INDEX [ExternalID] ON [dbo].[AccountResponsibleParty]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AccountResponsibleParty]') AND name = N'IX_AccountResponsibleParty_UniquePersonCorporation')
CREATE UNIQUE NONCLUSTERED INDEX [IX_AccountResponsibleParty_UniquePersonCorporation] ON [dbo].[AccountResponsibleParty]
(
	[PersonUid] ASC,
	[CorporationUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AccountResponsibleParty]') AND name = N'IX_Corporation')
CREATE NONCLUSTERED INDEX [IX_Corporation] ON [dbo].[AccountResponsibleParty]
(
	[CorporationUid] ASC
)
INCLUDE ( 	[ExternalID]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AccountResponsibleParty]') AND name = N'IX_DateEnteredStatusLevel')
CREATE NONCLUSTERED INDEX [IX_DateEnteredStatusLevel] ON [dbo].[AccountResponsibleParty]
(
	[DateEnteredStatusLevel] ASC
)
INCLUDE ( 	[AccountResponsiblePartyUid],
	[CollectionStatusLevelUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AccountResponsibleParty]') AND name = N'IX_ExcludeFromAutomatedCollections')
CREATE NONCLUSTERED INDEX [IX_ExcludeFromAutomatedCollections] ON [dbo].[AccountResponsibleParty]
(
	[ExcludeFromAutomatedCollections] ASC
)
INCLUDE ( 	[AccountResponsiblePartyUid],
	[PersonUid],
	[CorporationUid],
	[CollectionStatusUid],
	[CollectionStatusLevelUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AccountResponsibleParty]') AND name = N'IX_PersonUid_ExternalID')
CREATE NONCLUSTERED INDEX [IX_PersonUid_ExternalID] ON [dbo].[AccountResponsibleParty]
(
	[PersonUid] ASC
)
INCLUDE ( 	[ExternalID]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AccountResponsiblePartyCreditCardAuthorizationCache]') AND name = N'IX_AccountResponsiblePartyCreditCardAuthorizationCache_ARP_AuthAmt')
CREATE NONCLUSTERED INDEX [IX_AccountResponsiblePartyCreditCardAuthorizationCache_ARP_AuthAmt] ON [dbo].[AccountResponsiblePartyCreditCardAuthorizationCache]
(
	[AccountResponsiblePartyUid] ASC,
	[TotalAuthorizationAmount] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AddressHistory]') AND name = N'ix_AddressHistory_PersonUid')
CREATE NONCLUSTERED INDEX [ix_AddressHistory_PersonUid] ON [dbo].[AddressHistory]
(
	[PersonUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Appointment]') AND name = N'CalendarUid_AppointmentUid')
CREATE NONCLUSTERED INDEX [CalendarUid_AppointmentUid] ON [dbo].[Appointment]
(
	[CalendarUid] ASC,
	[AppointmentUid] ASC
)
INCLUDE ( 	[AppointmentTypeUid],
	[AppointmentStatusUid],
	[PatientUid],
	[StartDateTime],
	[EndDateTime]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Appointment]') AND name = N'IDX_AccountUid_AppointmentUid')
CREATE NONCLUSTERED INDEX [IDX_AccountUid_AppointmentUid] ON [dbo].[Appointment]
(
	[AccountUid] ASC
)
INCLUDE ( 	[AppointmentUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Appointment]') AND name = N'IDX_Appointment_ProviderUid_PatientUid_StartDateTime')
CREATE NONCLUSTERED INDEX [IDX_Appointment_ProviderUid_PatientUid_StartDateTime] ON [dbo].[Appointment]
(
	[ProviderUid] ASC,
	[PatientUid] ASC
)
INCLUDE ( 	[StartDateTime]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Appointment]') AND name = N'IDX_Appointment_StartDateTime')
CREATE NONCLUSTERED INDEX [IDX_Appointment_StartDateTime] ON [dbo].[Appointment]
(
	[StartDateTime] ASC
)
INCLUDE ( 	[PatientUid],
	[AppointmentUid],
	[AppointmentTypeUid],
	[AppointmentStatusUid],
	[CheckinDateTime],
	[DischargeDateTime],
	[PatientCaseUid],
	[AccountUid],
	[CalendarUid],
	[ServiceSiteUid],
	[FinancialCenterUid],
	[ProviderUid],
	[ProviderCareTypeUid],
	[ReferredbyProviderUid],
	[ReferringDate],
	[Phone],
	[CallConfirmStatusUid],
	[CallConfirmStatusDetail],
	[Reason],
	[AuthorizationReminder],
	[AuthorizationCode],
	[EndDateTime],
	[ExternalID],
	[Notes],
	[CreatedByUid],
	[CreatedDateTime],
	[LastModifiedDate],
	[LastModifiedByUid],
	[TriggerOverride],
	[ReferralSrcUid],
	[ScheduleType],
	[PatientGroupUid],
	[RecurringInstanceUid],
	[AppointmentReplicationDataXml],
	[BillingProviderUid],
	[ClipboardUserUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Appointment]') AND name = N'IX_Appointment_AppointmentStatusUid_StartDateTime')
CREATE NONCLUSTERED INDEX [IX_Appointment_AppointmentStatusUid_StartDateTime] ON [dbo].[Appointment]
(
	[AppointmentStatusUid] ASC,
	[StartDateTime] ASC
)
INCLUDE ( 	[AppointmentUid],
	[PatientUid],
	[ProviderUid],
	[BillingProviderUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Appointment]') AND name = N'IX_Appointment_Calendar_StartDate_EndDate')
CREATE NONCLUSTERED INDEX [IX_Appointment_Calendar_StartDate_EndDate] ON [dbo].[Appointment]
(
	[AppointmentUid] ASC,
	[CalendarUid] ASC,
	[StartDateTime] ASC,
	[EndDateTime] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Appointment]') AND name = N'IX_Appointment_ClipboardUserUid')
CREATE NONCLUSTERED INDEX [IX_Appointment_ClipboardUserUid] ON [dbo].[Appointment]
(
	[ClipboardUserUid] ASC
)
INCLUDE ( 	[CalendarUid],
	[StartDateTime],
	[EndDateTime]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Appointment]') AND name = N'IX_Appointment_Financials')
CREATE NONCLUSTERED INDEX [IX_Appointment_Financials] ON [dbo].[Appointment]
(
	[AppointmentUid] ASC,
	[FinancialCenterUid] ASC,
	[ServiceSiteUid] ASC,
	[ProviderUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Appointment]') AND name = N'IX_Appointment_StartDateTime_EndDateTime')
CREATE NONCLUSTERED INDEX [IX_Appointment_StartDateTime_EndDateTime] ON [dbo].[Appointment]
(
	[StartDateTime] ASC,
	[EndDateTime] ASC
)
INCLUDE ( 	[AppointmentUid],
	[AccountUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Appointment]') AND name = N'IX_AppointmentStatus')
CREATE NONCLUSTERED INDEX [IX_AppointmentStatus] ON [dbo].[Appointment]
(
	[AppointmentStatusUid] ASC
)
INCLUDE ( 	[AppointmentTypeUid],
	[PatientUid],
	[CalendarUid],
	[StartDateTime]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Appointment]') AND name = N'IX_AppointmentStatus_StartDate_Patient_Provider_Calendar_Appointment_ServiceSite')
CREATE NONCLUSTERED INDEX [IX_AppointmentStatus_StartDate_Patient_Provider_Calendar_Appointment_ServiceSite] ON [dbo].[Appointment]
(
	[AppointmentStatusUid] ASC,
	[StartDateTime] ASC,
	[PatientUid] ASC,
	[ProviderUid] ASC,
	[CalendarUid] ASC,
	[AppointmentUid] ASC,
	[ServiceSiteUid] ASC
)
INCLUDE ( 	[AccountUid],
	[FinancialCenterUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Appointment]') AND name = N'IX_ApptUid_Start_CalendarUid_End')
CREATE NONCLUSTERED INDEX [IX_ApptUid_Start_CalendarUid_End] ON [dbo].[Appointment]
(
	[AppointmentUid] ASC,
	[StartDateTime] ASC,
	[CalendarUid] ASC,
	[EndDateTime] ASC
)
INCLUDE ( 	[AppointmentStatusUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Appointment]') AND name = N'IX_CallConfirmStatus')
CREATE NONCLUSTERED INDEX [IX_CallConfirmStatus] ON [dbo].[Appointment]
(
	[CallConfirmStatusUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Appointment]') AND name = N'IX_ClipboardUser')
CREATE NONCLUSTERED INDEX [IX_ClipboardUser] ON [dbo].[Appointment]
(
	[ClipboardUserUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Appointment]') AND name = N'IX_CreatedBy')
CREATE NONCLUSTERED INDEX [IX_CreatedBy] ON [dbo].[Appointment]
(
	[CreatedByUid] ASC
)
INCLUDE ( 	[CalendarUid],
	[StartDateTime],
	[EndDateTime]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Appointment]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[Appointment]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Appointment]') AND name = N'IX_LastModifiedBy')
CREATE NONCLUSTERED INDEX [IX_LastModifiedBy] ON [dbo].[Appointment]
(
	[LastModifiedByUid] ASC
)
INCLUDE ( 	[CalendarUid],
	[StartDateTime],
	[EndDateTime]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Appointment]') AND name = N'IX_Patient_Appointment_Calendar_StartDateTime_EndDateTime')
CREATE NONCLUSTERED INDEX [IX_Patient_Appointment_Calendar_StartDateTime_EndDateTime] ON [dbo].[Appointment]
(
	[PatientUid] ASC,
	[AppointmentUid] ASC,
	[CalendarUid] ASC,
	[StartDateTime] ASC,
	[EndDateTime] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Appointment]') AND name = N'IX_Patient_StartDateTime')
CREATE NONCLUSTERED INDEX [IX_Patient_StartDateTime] ON [dbo].[Appointment]
(
	[PatientUid] ASC,
	[StartDateTime] ASC
)
INCLUDE ( 	[ProviderUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Appointment]') AND name = N'IX_PatientCaseUid_CalendarUid_StartDateTime_EndDateTime')
CREATE NONCLUSTERED INDEX [IX_PatientCaseUid_CalendarUid_StartDateTime_EndDateTime] ON [dbo].[Appointment]
(
	[PatientCaseUid] ASC,
	[CalendarUid] ASC,
	[StartDateTime] ASC,
	[EndDateTime] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Appointment]') AND name = N'IX_RecurringInstance')
CREATE NONCLUSTERED INDEX [IX_RecurringInstance] ON [dbo].[Appointment]
(
	[RecurringInstanceUid] ASC
)
INCLUDE ( 	[AppointmentStatusUid],
	[StartDateTime]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Appointment]') AND name = N'IX_ServiceSite_FinancialCenter_Provider_Patient')
CREATE NONCLUSTERED INDEX [IX_ServiceSite_FinancialCenter_Provider_Patient] ON [dbo].[Appointment]
(
	[ServiceSiteUid] ASC,
	[FinancialCenterUid] ASC,
	[ProviderUid] ASC,
	[PatientUid] ASC
)
INCLUDE ( 	[StartDateTime]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Appointment]') AND name = N'IXR_AppointmentUid_CalendarUid_StartDateTime_EndDateTime_PatientCaseUid')
CREATE NONCLUSTERED INDEX [IXR_AppointmentUid_CalendarUid_StartDateTime_EndDateTime_PatientCaseUid] ON [dbo].[Appointment]
(
	[AppointmentUid] ASC,
	[CalendarUid] ASC,
	[StartDateTime] ASC,
	[EndDateTime] ASC,
	[PatientCaseUid] ASC,
	[ProviderUid] ASC,
	[ReferredbyProviderUid] ASC,
	[CreatedByUid] ASC,
	[LastModifiedByUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Appointment]') AND name = N'IXR_AppointmentUid_CalendarUid_StartDateTime_EndDateTime_PatientUidW')
CREATE NONCLUSTERED INDEX [IXR_AppointmentUid_CalendarUid_StartDateTime_EndDateTime_PatientUidW] ON [dbo].[Appointment]
(
	[AppointmentUid] ASC,
	[CalendarUid] ASC,
	[StartDateTime] ASC,
	[EndDateTime] ASC,
	[PatientUid] ASC
)
INCLUDE ( 	[PatientCaseUid],
	[ProviderUid],
	[ReferredbyProviderUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_Ledger]') AND name = N'IX_AR_Ledger_ArBatchUid')
CREATE NONCLUSTERED INDEX [IX_AR_Ledger_ArBatchUid] ON [dbo].[AR_Ledger]
(
	[ArBatchUid] ASC
)
INCLUDE ( 	[CreatedDateTime],
	[EntryDate],
	[ShortName],
	[EntryType],
	[VoidLedgerUid],
	[Reconciled],
	[TransactionUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_Ledger]') AND name = N'IX_AR_Ledger_EntryType')
CREATE NONCLUSTERED INDEX [IX_AR_Ledger_EntryType] ON [dbo].[AR_Ledger]
(
	[EntryType] ASC
)
INCLUDE ( 	[LedgerUid],
	[TransactionUid],
	[ArBatchUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_Ledger]') AND name = N'IX_AR_Ledger_LedgerVoidLedger')
CREATE NONCLUSTERED INDEX [IX_AR_Ledger_LedgerVoidLedger] ON [dbo].[AR_Ledger]
(
	[LedgerUid] ASC,
	[VoidLedgerUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_Ledger]') AND name = N'IX_AR_Ledger_VoidLedgerLedger')
CREATE NONCLUSTERED INDEX [IX_AR_Ledger_VoidLedgerLedger] ON [dbo].[AR_Ledger]
(
	[VoidLedgerUid] ASC,
	[LedgerUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_Ledger]') AND name = N'IX_TransactionUid')
CREATE NONCLUSTERED INDEX [IX_TransactionUid] ON [dbo].[AR_Ledger]
(
	[TransactionUid] ASC
)
INCLUDE ( 	[LedgerUid],
	[EntryType]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_Ledger]') AND name = N'IX_TransactionUid_EntryType')
CREATE NONCLUSTERED INDEX [IX_TransactionUid_EntryType] ON [dbo].[AR_Ledger]
(
	[TransactionUid] ASC,
	[EntryType] ASC
)
INCLUDE ( 	[LedgerUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_LedgerDetail]') AND name = N'das_LegerDetailPerformance')
CREATE NONCLUSTERED INDEX [das_LegerDetailPerformance] ON [dbo].[AR_LedgerDetail]
(
	[InsurancePlanUid] ASC
)
INCLUDE ( 	[SuperbillProcedureUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_LedgerDetail]') AND name = N'IX_AccountResponsiblePartyUid_PayerCreditUid')
CREATE NONCLUSTERED INDEX [IX_AccountResponsiblePartyUid_PayerCreditUid] ON [dbo].[AR_LedgerDetail]
(
	[AccountResponsiblePartyUid] ASC,
	[PayerCreditUid] ASC
)
INCLUDE ( 	[LedgerUid],
	[RenderingProviderUid],
	[FinancialCenterUid],
	[ServiceSiteUid],
	[Amount]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_LedgerDetail]') AND name = N'IX_AR_LedgerDetail_Deposit')
CREATE NONCLUSTERED INDEX [IX_AR_LedgerDetail_Deposit] ON [dbo].[AR_LedgerDetail]
(
	[DepositUid] ASC,
	[IsCredit] ASC
)
INCLUDE ( 	[LedgerUid],
	[LedgerDetailUid],
	[SuperbillProcedureUid],
	[Amount],
	[RenderingProviderUid],
	[ClaimingProviderUid],
	[FinancialCenterUid],
	[ServiceSiteUid],
	[LiabilityOwner],
	[IncomeAccountUid],
	[CreatedDateTime],
	[PayerCreditUid],
	[InsurancePayerUid],
	[AccountResponsiblePartyUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_LedgerDetail]') AND name = N'IX_AR_LedgerDetail_LedgerUid_Covering')
CREATE NONCLUSTERED INDEX [IX_AR_LedgerDetail_LedgerUid_Covering] ON [dbo].[AR_LedgerDetail]
(
	[LedgerUid] ASC
)
INCLUDE ( 	[Amount],
	[LiabilityOwner],
	[LedgerAccountUid],
	[IncomeAccountUid],
	[InsurancePayerUid],
	[AccountResponsiblePartyUid],
	[SuperbillProcedureUid],
	[SuperbillProcedureUnits],
	[DepositUid],
	[PayerCreditUid],
	[InsurancePlanUid],
	[RenderingProviderUid],
	[ClaimingProviderUid],
	[FinancialCenterUid],
	[ServiceSiteUid],
	[MigrationUid],
	[IsCredit],
	[CreatedDateTime],
	[LastModifiedDate],
	[LastModifiedByUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_LedgerDetail]') AND name = N'IX_AR_LedgerDetail_SuperbillProcedure_InsurancePlan_CreatedDate')
CREATE UNIQUE NONCLUSTERED INDEX [IX_AR_LedgerDetail_SuperbillProcedure_InsurancePlan_CreatedDate] ON [dbo].[AR_LedgerDetail]
(
	[SuperbillProcedureUid] ASC,
	[InsurancePlanUid] ASC,
	[CreatedDateTime] ASC,
	[LedgerDetailUid] ASC,
	[FinancialCenterUid] ASC
)
INCLUDE ( 	[LedgerUid],
	[Amount],
	[LiabilityOwner],
	[IsCredit],
	[InsurancePayerUid],
	[IncomeAccountUid],
	[ServiceSiteUid],
	[RenderingProviderUid]) WITH (PAD_INDEX = ON, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_LedgerDetail]') AND name = N'ix_AR_LedgerDetail_SuperbillProcedureUid')
CREATE NONCLUSTERED INDEX [ix_AR_LedgerDetail_SuperbillProcedureUid] ON [dbo].[AR_LedgerDetail]
(
	[SuperbillProcedureUid] ASC
)
INCLUDE ( 	[LedgerDetailUid],
	[LedgerUid],
	[Amount],
	[LiabilityOwner],
	[LedgerAccountUid],
	[IncomeAccountUid],
	[InsurancePayerUid],
	[AccountResponsiblePartyUid],
	[SuperbillProcedureUnits],
	[DepositUid],
	[PayerCreditUid],
	[AccountUid],
	[InsurancePlanUid],
	[RenderingProviderUid],
	[ClaimingProviderUid],
	[FinancialCenterUid],
	[ServiceSiteUid],
	[MigrationUid],
	[IsCredit],
	[CreatedDateTime],
	[LastModifiedDate],
	[LastModifiedByUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_LedgerDetail]') AND name = N'IX_LastModifiedDate')
CREATE NONCLUSTERED INDEX [IX_LastModifiedDate] ON [dbo].[AR_LedgerDetail]
(
	[LastModifiedDate] ASC
)
INCLUDE ( 	[SuperbillProcedureUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_LedgerDetail]') AND name = N'IX_LiabilityOwner')
CREATE NONCLUSTERED INDEX [IX_LiabilityOwner] ON [dbo].[AR_LedgerDetail]
(
	[LiabilityOwner] ASC
)
INCLUDE ( 	[LedgerDetailUid],
	[LedgerUid],
	[Amount],
	[SuperbillProcedureUid],
	[RenderingProviderUid],
	[ClaimingProviderUid],
	[FinancialCenterUid],
	[ServiceSiteUid],
	[IsCredit],
	[CreatedDateTime]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_LedgerDetail]') AND name = N'IX_PayerCreditUid_IsCredit')
CREATE NONCLUSTERED INDEX [IX_PayerCreditUid_IsCredit] ON [dbo].[AR_LedgerDetail]
(
	[PayerCreditUid] ASC,
	[IsCredit] ASC,
	[Amount] ASC,
	[DepositUid] ASC
)
INCLUDE ( 	[LedgerUid],
	[AccountResponsiblePartyUid],
	[RenderingProviderUid],
	[FinancialCenterUid],
	[ServiceSiteUid],
	[InsurancePayerUid],
	[ClaimingProviderUid],
	[LedgerDetailUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_RelLedgerDetailProcedureModifier]') AND name = N'IX_LedgerDetail')
CREATE NONCLUSTERED INDEX [IX_LedgerDetail] ON [dbo].[AR_RelLedgerDetailProcedureModifier]
(
	[LedgerDetailUid] ASC
)
INCLUDE ( 	[RelLedgerDetailProcedureModifierUid],
	[ProcedureModifierUid],
	[DisplayOrder],
	[Inactive],
	[LastModifiedDate],
	[LastModifiedByUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_RelLedgerTag]') AND name = N'IX_AR_RelLedgerTag_LedgerUid_Value')
CREATE UNIQUE NONCLUSTERED INDEX [IX_AR_RelLedgerTag_LedgerUid_Value] ON [dbo].[AR_RelLedgerTag]
(
	[LedgerUid] ASC,
	[Value] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_Transaction]') AND name = N'IX_DepositUid')
CREATE NONCLUSTERED INDEX [IX_DepositUid] ON [dbo].[AR_Transaction]
(
	[DepositUid] ASC
)
INCLUDE ( 	[TransactionUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_Transaction]') AND name = N'IX_Superbill')
CREATE NONCLUSTERED INDEX [IX_Superbill] ON [dbo].[AR_Transaction]
(
	[SuperbillUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_Transaction]') AND name = N'IX_Transaction_LastModifiedDate')
CREATE NONCLUSTERED INDEX [IX_Transaction_LastModifiedDate] ON [dbo].[AR_Transaction]
(
	[LastModifiedDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ARBatch]') AND name = N'ARBatch_WithInclude')
CREATE NONCLUSTERED INDEX [ARBatch_WithInclude] ON [dbo].[ARBatch]
(
	[ARBatchUid] ASC
)
INCLUDE ( 	[Name],
	[GLDate],
	[IsLocked]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ARBatch]') AND name = N'IX_ARBatch_LastModifiedDate')
CREATE NONCLUSTERED INDEX [IX_ARBatch_LastModifiedDate] ON [dbo].[ARBatch]
(
	[LastModifiedDate] DESC,
	[ARBatchUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ARBatch]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ARBatch]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ARBatch]') AND name = N'IX_IsLocked_OwnerUid_GLDate')
CREATE NONCLUSTERED INDEX [IX_IsLocked_OwnerUid_GLDate] ON [dbo].[ARBatch]
(
	[IsLocked] ASC,
	[OwnerUid] ASC,
	[GLDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ARBatch]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ARBatch]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ARBatch]') AND name = N'IX_Owner')
CREATE NONCLUSTERED INDEX [IX_Owner] ON [dbo].[ARBatch]
(
	[OwnerUid] ASC
)
INCLUDE ( 	[ARBatchUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ARContext]') AND name = N'Account_Inactive_ARContext_Superbill_SuperbillProcedure_ShortDescription_LongDescription')
CREATE NONCLUSTERED INDEX [Account_Inactive_ARContext_Superbill_SuperbillProcedure_ShortDescription_LongDescription] ON [dbo].[ARContext]
(
	[AccountUid] ASC,
	[Inactive] ASC,
	[ARContextUid] ASC,
	[SuperbillProcedureUid] ASC,
	[SuperbillUid] ASC,
	[ShortDescription] ASC,
	[LongDescription] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ARContext]') AND name = N'ARContext_Superbill')
CREATE NONCLUSTERED INDEX [ARContext_Superbill] ON [dbo].[ARContext]
(
	[ARContextUid] ASC,
	[SuperbillUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ARContext]') AND name = N'IRX_ARContextUid_AccountUid_SuperbillUid')
CREATE NONCLUSTERED INDEX [IRX_ARContextUid_AccountUid_SuperbillUid] ON [dbo].[ARContext]
(
	[ARContextUid] ASC,
	[AccountUid] ASC,
	[SuperbillUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ARContext]') AND name = N'IX_AccountUid_SuperbillUid')
CREATE NONCLUSTERED INDEX [IX_AccountUid_SuperbillUid] ON [dbo].[ARContext]
(
	[AccountUid] ASC,
	[SuperbillUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ARContext]') AND name = N'IX_ClaimingProvider_Superbill')
CREATE NONCLUSTERED INDEX [IX_ClaimingProvider_Superbill] ON [dbo].[ARContext]
(
	[ClaimingProviderUid] ASC,
	[SuperbillUid] ASC
)
INCLUDE ( 	[ARContextUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ARContext]') AND name = N'IX_ClaimingProvider_SuperbillProcedure')
CREATE NONCLUSTERED INDEX [IX_ClaimingProvider_SuperbillProcedure] ON [dbo].[ARContext]
(
	[ClaimingProviderUid] ASC,
	[SuperbillProcedureUid] ASC
)
INCLUDE ( 	[ARContextUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ARContext]') AND name = N'IX_Inactive_Account_Uid_inc')
CREATE NONCLUSTERED INDEX [IX_Inactive_Account_Uid_inc] ON [dbo].[ARContext]
(
	[Inactive] ASC,
	[AccountUid] ASC
)
INCLUDE ( 	[ARContextUid],
	[SuperbillUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ARContext]') AND name = N'IX_SuperbillProcedureUid')
CREATE NONCLUSTERED INDEX [IX_SuperbillProcedureUid] ON [dbo].[ARContext]
(
	[SuperbillProcedureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ARContext]') AND name = N'IXR_Inactive_SuperbillProcedureUid_SuperbillUid_ARContextUid_ShortDescription_LongDescription')
CREATE NONCLUSTERED INDEX [IXR_Inactive_SuperbillProcedureUid_SuperbillUid_ARContextUid_ShortDescription_LongDescription] ON [dbo].[ARContext]
(
	[Inactive] ASC,
	[SuperbillProcedureUid] ASC,
	[SuperbillUid] ASC,
	[ARContextUid] ASC,
	[ShortDescription] ASC,
	[LongDescription] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ARContext]') AND name = N'IXR_Inactive_SuperbillUid_ARContextUid')
CREATE NONCLUSTERED INDEX [IXR_Inactive_SuperbillUid_ARContextUid] ON [dbo].[ARContext]
(
	[Inactive] ASC,
	[SuperbillUid] ASC,
	[ARContextUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ARContext]') AND name = N'IXR_Inactive_SuperbillUid_ARContextUid_SuperbillProcedureUid')
CREATE NONCLUSTERED INDEX [IXR_Inactive_SuperbillUid_ARContextUid_SuperbillProcedureUid] ON [dbo].[ARContext]
(
	[Inactive] ASC,
	[SuperbillUid] ASC,
	[ARContextUid] ASC,
	[SuperbillProcedureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ARContext]') AND name = N'IXR_SuperbillUid_Inactive')
CREATE NONCLUSTERED INDEX [IXR_SuperbillUid_Inactive] ON [dbo].[ARContext]
(
	[SuperbillUid] ASC,
	[Inactive] ASC
)
INCLUDE ( 	[ARContextUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Attachment]') AND name = N'Attachment_AttachmentGroup_FileDate')
CREATE NONCLUSTERED INDEX [Attachment_AttachmentGroup_FileDate] ON [dbo].[Attachment]
(
	[AttachmentGroupUid] ASC,
	[FileDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Attachment]') AND name = N'Attachment_AttachmentGroupUid_AttachmentUid')
CREATE NONCLUSTERED INDEX [Attachment_AttachmentGroupUid_AttachmentUid] ON [dbo].[Attachment]
(
	[AttachmentGroupUid] ASC,
	[AttachmentUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Attachment]') AND name = N'IDX_Attachment_LastModifiedDate_AttachmentUid_AttachmentGroupUid')
CREATE NONCLUSTERED INDEX [IDX_Attachment_LastModifiedDate_AttachmentUid_AttachmentGroupUid] ON [dbo].[Attachment]
(
	[LastModifiedDate] ASC
)
INCLUDE ( 	[AttachmentUid],
	[AttachmentGroupUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Attachment]') AND name = N'IX_AttachmentContentSize_GraphicNote_FileExtension')
CREATE NONCLUSTERED INDEX [IX_AttachmentContentSize_GraphicNote_FileExtension] ON [dbo].[Attachment]
(
	[AttachmentContentSize] ASC,
	[GraphicNoteUid] ASC,
	[FileExtension] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Attachment]') AND name = N'IX_AttachmentGroup_FileName')
CREATE NONCLUSTERED INDEX [IX_AttachmentGroup_FileName] ON [dbo].[Attachment]
(
	[AttachmentGroupUid] ASC,
	[FileName] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Attachment]') AND name = N'IX_Compression')
CREATE NONCLUSTERED INDEX [IX_Compression] ON [dbo].[Attachment]
(
	[CompressionUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Attachment]') AND name = N'IX_FileName')
CREATE NONCLUSTERED INDEX [IX_FileName] ON [dbo].[Attachment]
(
	[FileName] ASC
)
INCLUDE ( 	[AttachmentUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Attachment]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[Attachment]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AttachmentApproval]') AND name = N'IX_ApprovedByUserPRM')
CREATE NONCLUSTERED INDEX [IX_ApprovedByUserPRM] ON [dbo].[AttachmentApproval]
(
	[ApprovedByUserPRMUid] ASC
)
INCLUDE ( 	[AttachmentUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AttachmentGroup]') AND name = N'IDXI_AttachmentGroup_StrikeOut')
CREATE NONCLUSTERED INDEX [IDXI_AttachmentGroup_StrikeOut] ON [dbo].[AttachmentGroup]
(
	[StrikeOut] ASC
)
INCLUDE ( 	[AttachmentGroupUid],
	[AttachmentTypeUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AttachmentGroup]') AND name = N'IX_AttachmentGroupUid')
CREATE NONCLUSTERED INDEX [IX_AttachmentGroupUid] ON [dbo].[AttachmentGroup]
(
	[AttachmentGroupUid] ASC
)
INCLUDE ( 	[AttachmentTypeUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AttachmentGroup]') AND name = N'IX_AttachmentTypeUid')
CREATE NONCLUSTERED INDEX [IX_AttachmentTypeUid] ON [dbo].[AttachmentGroup]
(
	[AttachmentTypeUid] ASC,
	[LastModifiedDate] ASC
)
INCLUDE ( 	[AttachmentGroupUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AuditArchive]') AND name = N'IX_Type')
CREATE NONCLUSTERED INDEX [IX_Type] ON [dbo].[AuditArchive]
(
	[Type] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AuditArchive]') AND name = N'Patient')
CREATE NONCLUSTERED INDEX [Patient] ON [dbo].[AuditArchive]
(
	[PatientUid] ASC,
	[ChangeDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AuditArchive]') AND name = N'UserPatient')
CREATE NONCLUSTERED INDEX [UserPatient] ON [dbo].[AuditArchive]
(
	[UserUid] ASC,
	[PatientUid] ASC,
	[ChangeDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AuditCurrent]') AND name = N'IX_Type')
CREATE NONCLUSTERED INDEX [IX_Type] ON [dbo].[AuditCurrent]
(
	[Type] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AuditCurrent]') AND name = N'Patient')
CREATE NONCLUSTERED INDEX [Patient] ON [dbo].[AuditCurrent]
(
	[PatientUid] ASC,
	[ChangeDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AuditCurrent]') AND name = N'UserPatient')
CREATE NONCLUSTERED INDEX [UserPatient] ON [dbo].[AuditCurrent]
(
	[UserUid] ASC,
	[PatientUid] ASC,
	[ChangeDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AuditWorkflowLogArchive]') AND name = N'IX_AuditWorkflowLogArchive_AuditUid')
CREATE NONCLUSTERED INDEX [IX_AuditWorkflowLogArchive_AuditUid] ON [dbo].[AuditWorkflowLogArchive]
(
	[AuditUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AuditWorkflowLogCurrent]') AND name = N'IX_AuditWorkflowLogCurrent_AuditUid')
CREATE NONCLUSTERED INDEX [IX_AuditWorkflowLogCurrent_AuditUid] ON [dbo].[AuditWorkflowLogCurrent]
(
	[AuditUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[BatchProcessDetail]') AND name = N'ix_BatchProcessDetail_Uid')
CREATE NONCLUSTERED INDEX [ix_BatchProcessDetail_Uid] ON [dbo].[BatchProcessDetail]
(
	[Uid] ASC
)
INCLUDE ( 	[BatchProcessDetailUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[BatchProcessDetail]') AND name = N'IX_BatchProcessUid')
CREATE NONCLUSTERED INDEX [IX_BatchProcessUid] ON [dbo].[BatchProcessDetail]
(
	[BatchProcessUid] ASC
)
INCLUDE ( 	[BatchProcessDetailUid],
	[Selected],
	[DetailXml],
	[Error],
	[Uid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CaseAuthorization]') AND name = N'CaseAuth_PatientCaseUid')
CREATE NONCLUSTERED INDEX [CaseAuth_PatientCaseUid] ON [dbo].[CaseAuthorization]
(
	[PatientCaseUid] ASC
)
INCLUDE ( 	[CaseAuthorizationUid],
	[ExternalID],
	[Name],
	[AuthorizationCode],
	[AuthorizationExpirationDate],
	[InitialVisitNum],
	[RemainingVisitNum],
	[AccountPeriodUid],
	[PrimaryInsuranceRBType],
	[PrimaryAuthorizationCode],
	[SecondaryInsuranceRBType],
	[SecondaryAuthorizationCode],
	[TertiaryInsuranceRBType],
	[TertiaryAuthorizationCode],
	[Inactive],
	[Notes],
	[ActiveAuthorizationCode],
	[UserDefined],
	[LastModifiedDate],
	[LastModifiedByUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CaseAuthorizationCode]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[CaseAuthorizationCode]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ChargeCapture]') AND name = N'IX_PatientUid_IsOpen')
CREATE NONCLUSTERED INDEX [IX_PatientUid_IsOpen] ON [dbo].[ChargeCapture]
(
	[PatientUid] ASC,
	[IsOpen] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ChargeCapturePatientDiagnosisHistory]') AND name = N'IX_PatientUid')
CREATE NONCLUSTERED INDEX [IX_PatientUid] ON [dbo].[ChargeCapturePatientDiagnosisHistory]
(
	[PatientUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ChargePostQueue]') AND name = N'IX_Superbill_IsPosted')
CREATE NONCLUSTERED INDEX [IX_Superbill_IsPosted] ON [dbo].[ChargePostQueue]
(
	[SuperbillUid] ASC,
	[IsPosted] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ChartAccess]') AND name = N'IX_ChartAccess_Covering')
CREATE NONCLUSTERED INDEX [IX_ChartAccess_Covering] ON [dbo].[ChartAccess]
(
	[PatientUid] ASC,
	[UserUid] ASC,
	[UserGroupUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ChartAccess]') AND name = N'IX_ChartAccess_PatientUid')
CREATE NONCLUSTERED INDEX [IX_ChartAccess_PatientUid] ON [dbo].[ChartAccess]
(
	[PatientUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ClaimBatch]') AND name = N'IX_ClaimingUser')
CREATE NONCLUSTERED INDEX [IX_ClaimingUser] ON [dbo].[ClaimBatch]
(
	[ClaimingUserUid] ASC
)
INCLUDE ( 	[ClaimBatchUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ClaimBatch]') AND name = N'IX_EClaimFileUid')
CREATE NONCLUSTERED INDEX [IX_EClaimFileUid] ON [dbo].[ClaimBatch]
(
	[EClaimFileUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ClaimBatch]') AND name = N'IX_Status')
CREATE NONCLUSTERED INDEX [IX_Status] ON [dbo].[ClaimBatch]
(
	[Status] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ClaimBatch]') AND name = N'IX_SubmissionNumber')
CREATE NONCLUSTERED INDEX [IX_SubmissionNumber] ON [dbo].[ClaimBatch]
(
	[SubmissionNumber] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ClaimBatch]') AND name = N'IXR_ClaimBatchUid_ClaimDate')
CREATE NONCLUSTERED INDEX [IXR_ClaimBatchUid_ClaimDate] ON [dbo].[ClaimBatch]
(
	[InsuranceOrder] ASC,
	[ClaimDate] ASC
)
INCLUDE ( 	[ClaimBatchUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ClaimBatchDetail]') AND name = N'IX_ClaimBatchDetailUid_SuperbillUid')
CREATE NONCLUSTERED INDEX [IX_ClaimBatchDetailUid_SuperbillUid] ON [dbo].[ClaimBatchDetail]
(
	[ClaimBatchUid] ASC,
	[SuperbillUid] ASC,
	[InsurancePlanUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ClaimBatchDetail]') AND name = N'IXR_SuperbillUid_InsurancePlanUid_ClaimBatchUid')
CREATE NONCLUSTERED INDEX [IXR_SuperbillUid_InsurancePlanUid_ClaimBatchUid] ON [dbo].[ClaimBatchDetail]
(
	[SuperbillUid] ASC,
	[InsurancePlanUid] ASC,
	[ClaimBatchUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ClaimFormatValue]') AND name = N'IdxUniqueClaimFormatValue')
CREATE UNIQUE NONCLUSTERED INDEX [IdxUniqueClaimFormatValue] ON [dbo].[ClaimFormatValue]
(
	[ClaimFormatValueTypeUid] ASC,
	[ProviderUid] ASC,
	[ServiceSiteUid] ASC,
	[FinancialCenterUid] ASC,
	[ProcedureUid] ASC,
	[MedicalServicesProviderUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ClaimFormatValue]') AND name = N'IX_ClaimFormatValueTypeUid_Value')
CREATE NONCLUSTERED INDEX [IX_ClaimFormatValueTypeUid_Value] ON [dbo].[ClaimFormatValue]
(
	[ClaimFormatValueTypeUid] ASC,
	[Value] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ClaimFormatValue]') AND name = N'IX_Provider')
CREATE NONCLUSTERED INDEX [IX_Provider] ON [dbo].[ClaimFormatValue]
(
	[ProviderUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ClinicCenterAttachment]') AND name = N'IX_ClinicCenterAttachment')
CREATE UNIQUE NONCLUSTERED INDEX [IX_ClinicCenterAttachment] ON [dbo].[ClinicCenterAttachment]
(
	[ClinicCenterUid] ASC,
	[AttachmentUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ClinicCenterChargeTicketDiagnosis]') AND name = N'IX_ClinicCenterChargeTicketDiagnosis')
CREATE UNIQUE NONCLUSTERED INDEX [IX_ClinicCenterChargeTicketDiagnosis] ON [dbo].[ClinicCenterChargeTicketDiagnosis]
(
	[ClinicCenterUid] ASC,
	[ChargeTicketDiagnosisUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ClinicCenterChargeTicketDiagnosis]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ClinicCenterChargeTicketDiagnosis]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ClinicCenterChargeTicketSO]') AND name = N'IX_ClinicCenterChargeTicketSO')
CREATE UNIQUE NONCLUSTERED INDEX [IX_ClinicCenterChargeTicketSO] ON [dbo].[ClinicCenterChargeTicketSO]
(
	[ClinicCenterUid] ASC,
	[ChargeTicketSOUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ClinicCenterChargeTicketSO]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ClinicCenterChargeTicketSO]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ClinicCenterChargeTicketSP]') AND name = N'IX_ClinicCenterChargeTicketSP')
CREATE UNIQUE NONCLUSTERED INDEX [IX_ClinicCenterChargeTicketSP] ON [dbo].[ClinicCenterChargeTicketSP]
(
	[ClinicCenterUid] ASC,
	[ChargeTicketSPUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ClinicCenterChargeTicketSP]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ClinicCenterChargeTicketSP]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ClinicCenterCpp]') AND name = N'IX_ClinicCenterCpp')
CREATE UNIQUE NONCLUSTERED INDEX [IX_ClinicCenterCpp] ON [dbo].[ClinicCenterCpp]
(
	[ClinicCenterUid] ASC,
	[CppUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ClinicCenterCpp]') AND name = N'IX_CppUid')
CREATE NONCLUSTERED INDEX [IX_CppUid] ON [dbo].[ClinicCenterCpp]
(
	[CppUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ClinicCenterObservationItem]') AND name = N'IX_ClinicCenterObservationItem')
CREATE UNIQUE NONCLUSTERED INDEX [IX_ClinicCenterObservationItem] ON [dbo].[ClinicCenterObservationItem]
(
	[ClinicCenterUid] ASC,
	[RelObservationObservationItemUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ClinicCenterObservationItem]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ClinicCenterObservationItem]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ClinicCenterObservationItemQualifier]') AND name = N'IX_ClinicCenterObservationItemQualifier')
CREATE UNIQUE NONCLUSTERED INDEX [IX_ClinicCenterObservationItemQualifier] ON [dbo].[ClinicCenterObservationItemQualifier]
(
	[ClinicCenterUid] ASC,
	[RelObservationItemQualifierUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ClinicCenterObservationItemQualifier]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ClinicCenterObservationItemQualifier]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ClinicCenterProcedureModifier]') AND name = N'IX_ClinicCenterProcedureModifier')
CREATE UNIQUE NONCLUSTERED INDEX [IX_ClinicCenterProcedureModifier] ON [dbo].[ClinicCenterProcedureModifier]
(
	[ClinicCenterUid] ASC,
	[ProcedureModifierUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ClinicCenterProcedureModifier]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ClinicCenterProcedureModifier]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Cms1500Claim]') AND name = N'IX_ClaimBatch')
CREATE NONCLUSTERED INDEX [IX_ClaimBatch] ON [dbo].[Cms1500Claim]
(
	[ClaimBatchUID] ASC
)
INCLUDE ( 	[SuperBillUId]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[COBClaimDetail]') AND name = N'IX_Superbill')
CREATE NONCLUSTERED INDEX [IX_Superbill] ON [dbo].[COBClaimDetail]
(
	[SuperbillUid] ASC
)
INCLUDE ( 	[InsuranceOrder],
	[ReimbursementRate],
	[HCPCSPayableAmount],
	[MOARemarkCode1Uid],
	[MOARemarkCode2Uid],
	[MOARemarkCode3Uid],
	[MOARemarkCode4Uid],
	[MOARemarkCode5Uid],
	[ESRDPaymentAmount],
	[NonpayableProfessionalComponentAmount],
	[AdjudicationDate],
	[DiscountAmount],
	[PerDayLimitAmount],
	[PatientResponsibleAmount],
	[COBClaimDetailUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[COBClaimDetail]') AND name = N'IX_Superbill_InsuranceOrder')
CREATE NONCLUSTERED INDEX [IX_Superbill_InsuranceOrder] ON [dbo].[COBClaimDetail]
(
	[SuperbillUid] ASC,
	[InsuranceOrder] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[COBLineAdjustments]') AND name = N'IX_COBClaimDetail')
CREATE NONCLUSTERED INDEX [IX_COBClaimDetail] ON [dbo].[COBLineAdjustments]
(
	[COBClaimDetailUid] ASC
)
INCLUDE ( 	[DepositUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[COBLineAdjustments]') AND name = N'IX_Deposit')
CREATE NONCLUSTERED INDEX [IX_Deposit] ON [dbo].[COBLineAdjustments]
(
	[DepositUid] ASC
)
INCLUDE ( 	[COBLineAdjustmentsUid],
	[COBClaimDetailUid],
	[SuperbillProcedureUid],
	[CreditTypeUid],
	[GroupCodeERACodeUid],
	[ReasonCodeERACodeUid],
	[Amount],
	[Quantity],
	[StatementNote]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[COBLineAdjustments]') AND name = N'IX_SuperbillProcedure')
CREATE NONCLUSTERED INDEX [IX_SuperbillProcedure] ON [dbo].[COBLineAdjustments]
(
	[SuperbillProcedureUid] ASC
)
INCLUDE ( 	[GroupCodeERACodeUid],
	[ReasonCodeERACodeUid],
	[Amount],
	[Quantity]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[COBLineAdjustments]') AND name = N'IX_Transaction')
CREATE NONCLUSTERED INDEX [IX_Transaction] ON [dbo].[COBLineAdjustments]
(
	[TransactionUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CollectionHistory]') AND name = N'IX_AccountResponsibleParty')
CREATE NONCLUSTERED INDEX [IX_AccountResponsibleParty] ON [dbo].[CollectionHistory]
(
	[AccountResponsiblePartyUid] ASC
)
INCLUDE ( 	[CollectionHistoryUid],
	[InitialCollectionStatusUid],
	[InitialCollectionStatusLevelUid],
	[NewCollectionStatusUid],
	[NewCollectionStatusLevelUid],
	[CreatedDateTime],
	[DisableAlert],
	[Reason]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CollectionLetter]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[CollectionLetter]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CollectionLetter]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[CollectionLetter]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CollectionLetterPrintQueue]') AND name = N'IX_RelAttachmentGroupUid')
CREATE NONCLUSTERED INDEX [IX_RelAttachmentGroupUid] ON [dbo].[CollectionLetterPrintQueue]
(
	[RelAttachmentGroupUid] ASC
)
INCLUDE ( 	[CollectionLetterPrintQueueUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CollectionMessage]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[CollectionMessage]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CollectionMessage]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[CollectionMessage]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CollectionStatusGlobal]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[CollectionStatusGlobal]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CollectionStatusGlobal]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[CollectionStatusGlobal]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CollectionStatusLevel]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[CollectionStatusLevel]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CollectionStatusLevel]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[CollectionStatusLevel]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Corporation]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[Corporation]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Corporation]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[Corporation]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CppCC]') AND name = N'IX_CppCC')
CREATE NONCLUSTERED INDEX [IX_CppCC] ON [dbo].[CppCC]
(
	[CppUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CppDiagnosis]') AND name = N'IX_Code10')
CREATE NONCLUSTERED INDEX [IX_Code10] ON [dbo].[CppDiagnosis]
(
	[Code10] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CppDiagnosis]') AND name = N'IX_Code9')
CREATE NONCLUSTERED INDEX [IX_Code9] ON [dbo].[CppDiagnosis]
(
	[Code9] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CppDiagnosis]') AND name = N'IX_Cpp')
CREATE NONCLUSTERED INDEX [IX_Cpp] ON [dbo].[CppDiagnosis]
(
	[CppUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CppDiagnosis]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[CppDiagnosis]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CppDiet]') AND name = N'IX_CPP')
CREATE NONCLUSTERED INDEX [IX_CPP] ON [dbo].[CppDiet]
(
	[CppUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CppDiet]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[CppDiet]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CppExercise]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[CppExercise]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CppHpi]') AND name = N'IXR_CppUid')
CREATE NONCLUSTERED INDEX [IXR_CppUid] ON [dbo].[CppHpi]
(
	[CppUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CppMedication]') AND name = N'IX_Cpp')
CREATE NONCLUSTERED INDEX [IX_Cpp] ON [dbo].[CppMedication]
(
	[CppUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CppMedication]') AND name = N'IX_MedicationSIGUid')
CREATE NONCLUSTERED INDEX [IX_MedicationSIGUid] ON [dbo].[CppMedication]
(
	[MedicationSIGUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CppMedication]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[CppMedication]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CppPatientInstruction]') AND name = N'IX_CPP')
CREATE NONCLUSTERED INDEX [IX_CPP] ON [dbo].[CppPatientInstruction]
(
	[CppUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CppPE]') AND name = N'IX_Cpp')
CREATE NONCLUSTERED INDEX [IX_Cpp] ON [dbo].[CppPE]
(
	[CppUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CppPE]') AND name = N'IX_CppPE')
CREATE UNIQUE NONCLUSTERED INDEX [IX_CppPE] ON [dbo].[CppPE]
(
	[CppUid] ASC,
	[PETemplateUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CppPEDescription]') AND name = N'IX_Cpp')
CREATE NONCLUSTERED INDEX [IX_Cpp] ON [dbo].[CppPEDescription]
(
	[CppUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CppPEDescription]') AND name = N'IX_Cpp_PETemplate')
CREATE NONCLUSTERED INDEX [IX_Cpp_PETemplate] ON [dbo].[CppPEDescription]
(
	[CppUid] ASC,
	[PETemplateUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CppPEDescription]') AND name = N'IX_CPP_Template_ParentSystem_System_Symptom_Description')
CREATE UNIQUE NONCLUSTERED INDEX [IX_CPP_Template_ParentSystem_System_Symptom_Description] ON [dbo].[CppPEDescription]
(
	[PETemplateUid] ASC,
	[PEParentSystemUid] ASC,
	[PESystemUid] ASC,
	[PESymptomUid] ASC,
	[PEDescriptionUid] ASC,
	[CppUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CppRos]') AND name = N'IX_Cpp_System_Symptom')
CREATE UNIQUE NONCLUSTERED INDEX [IX_Cpp_System_Symptom] ON [dbo].[CppRos]
(
	[CppUid] ASC,
	[RosSystemUid] ASC,
	[RosSymptomUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CppRos]') AND name = N'IX_CppRos')
CREATE NONCLUSTERED INDEX [IX_CppRos] ON [dbo].[CppRos]
(
	[CppUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CppSO]') AND name = N'IX_CppUid')
CREATE NONCLUSTERED INDEX [IX_CppUid] ON [dbo].[CppSO]
(
	[CppUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CppSO]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[CppSO]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CppSO]') AND name = N'ProcedureUid')
CREATE NONCLUSTERED INDEX [ProcedureUid] ON [dbo].[CppSO]
(
	[ProcedureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CppSP]') AND name = N'IX_CppUid')
CREATE NONCLUSTERED INDEX [IX_CppUid] ON [dbo].[CppSP]
(
	[CppUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CppSP]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[CppSP]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CppSP]') AND name = N'IX_Procedure')
CREATE NONCLUSTERED INDEX [IX_Procedure] ON [dbo].[CppSP]
(
	[ProcedureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CreditCardTransactionHistory]') AND name = N'IX_CreditCardTransactionHistory')
CREATE NONCLUSTERED INDEX [IX_CreditCardTransactionHistory] ON [dbo].[CreditCardTransactionHistory]
(
	[DepositUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[CreditCardTransactionHistory]') AND name = N'IX_CreditCardTransactionHistory_1')
CREATE NONCLUSTERED INDEX [IX_CreditCardTransactionHistory_1] ON [dbo].[CreditCardTransactionHistory]
(
	[MerchID] ASC,
	[TxID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Deposit]') AND name = N'ARBatch')
CREATE NONCLUSTERED INDEX [ARBatch] ON [dbo].[Deposit]
(
	[ARBatchUid] ASC
)
INCLUDE ( 	[DepositUid],
	[Amount],
	[Void]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Deposit]') AND name = N'IX_Amount_WhoPaidInsCarrier_Reference_Void')
CREATE NONCLUSTERED INDEX [IX_Amount_WhoPaidInsCarrier_Reference_Void] ON [dbo].[Deposit]
(
	[Amount] ASC,
	[WhoPaidInsuranceCarrierUid] ASC,
	[ReferenceNumber] ASC,
	[Void] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Deposit]') AND name = N'IX_AppointmentUid_DepositMacroUid_Void')
CREATE NONCLUSTERED INDEX [IX_AppointmentUid_DepositMacroUid_Void] ON [dbo].[Deposit]
(
	[AppointmentUid] ASC,
	[DepositMacroUid] ASC,
	[Void] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Deposit]') AND name = N'IX_ARBatchUid_Void')
CREATE NONCLUSTERED INDEX [IX_ARBatchUid_Void] ON [dbo].[Deposit]
(
	[ARBatchUid] ASC,
	[Void] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Deposit]') AND name = N'IX_Deposit_LastModifiedDate')
CREATE NONCLUSTERED INDEX [IX_Deposit_LastModifiedDate] ON [dbo].[Deposit]
(
	[LastModifiedDate] DESC,
	[DepositUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Deposit]') AND name = N'IX_Deposit_ReplicationAppointmentUid')
CREATE NONCLUSTERED INDEX [IX_Deposit_ReplicationAppointmentUid] ON [dbo].[Deposit]
(
	[ReplicationAppointmentUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Deposit]') AND name = N'IX_DepositDate_Void_WhoPaidInsuranceCarrier')
CREATE NONCLUSTERED INDEX [IX_DepositDate_Void_WhoPaidInsuranceCarrier] ON [dbo].[Deposit]
(
	[DepositDate] ASC,
	[Void] ASC,
	[WhoPaidInsuranceCarrierUid] ASC
)
INCLUDE ( 	[DepositUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Deposit]') AND name = N'IX_ParentDeposit')
CREATE NONCLUSTERED INDEX [IX_ParentDeposit] ON [dbo].[Deposit]
(
	[ParentDepositUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Deposit]') AND name = N'IX_ReferenceNumber')
CREATE NONCLUSTERED INDEX [IX_ReferenceNumber] ON [dbo].[Deposit]
(
	[ReferenceNumber] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Deposit]') AND name = N'IX_Void')
CREATE NONCLUSTERED INDEX [IX_Void] ON [dbo].[Deposit]
(
	[Void] ASC
)
INCLUDE ( 	[Amount],
	[DepositDate],
	[PaymentTypeUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Deposit]') AND name = N'IX_WhoPaidPerson')
CREATE NONCLUSTERED INDEX [IX_WhoPaidPerson] ON [dbo].[Deposit]
(
	[WhoPaidPersonUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Deposit]') AND name = N'IX_WhoPaidPerson_Void')
CREATE NONCLUSTERED INDEX [IX_WhoPaidPerson_Void] ON [dbo].[Deposit]
(
	[WhoPaidPersonUid] ASC,
	[Void] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Deposit]') AND name = N'IXR_DepositUid_PaymentTypeUid_WhoPaidInsuranceCarrierUid_DepositDateW')
CREATE NONCLUSTERED INDEX [IXR_DepositUid_PaymentTypeUid_WhoPaidInsuranceCarrierUid_DepositDateW] ON [dbo].[Deposit]
(
	[DepositUid] ASC,
	[PaymentTypeUid] ASC,
	[WhoPaidInsuranceCarrierUid] ASC,
	[DepositDate] ASC
)
INCLUDE ( 	[WhoPaidPersonUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[DepositSuperbill_09]') AND name = N'IX_SuperbillUid')
CREATE NONCLUSTERED INDEX [IX_SuperbillUid] ON [dbo].[DepositSuperbill_09]
(
	[SuperbillUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[DepositSuperbill_09]') AND name = N'IX_Unique_DepositSuperbill')
CREATE UNIQUE NONCLUSTERED INDEX [IX_Unique_DepositSuperbill] ON [dbo].[DepositSuperbill_09]
(
	[DepositUid] ASC,
	[SuperbillUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[DocumentBatchPatient]') AND name = N'IX_DocumentBatch_Patient')
CREATE UNIQUE NONCLUSTERED INDEX [IX_DocumentBatch_Patient] ON [dbo].[DocumentBatchPatient]
(
	[DocumentBatchUid] ASC,
	[PatientUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[DocumentBatchPatient]') AND name = N'IX_DocumentBatchPatient_DBPUid')
CREATE NONCLUSTERED INDEX [IX_DocumentBatchPatient_DBPUid] ON [dbo].[DocumentBatchPatient]
(
	[DocumentBatchUid] ASC
)
INCLUDE ( 	[DocumentBatchPatientUid],
	[PatientUid],
	[FirstName],
	[LastName],
	[BirthDate],
	[DeathDate],
	[SocialSecurityNumber],
	[PCPUid],
	[PatientExternalId],
	[GenderUid],
	[RaceUid],
	[EthnicityUid],
	[InsurancePlanUid],
	[Zip],
	[ReportDetailXml],
	[PatientReportIntermediateXml],
	[PatientReportXml],
	[PatientReportExportFilename],
	[Error],
	[LastModifiedByUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[DocumentBatchPatient]') AND name = N'IX_DocumentBatchPatient_DBUid_BirthDate_DeathDate')
CREATE NONCLUSTERED INDEX [IX_DocumentBatchPatient_DBUid_BirthDate_DeathDate] ON [dbo].[DocumentBatchPatient]
(
	[DocumentBatchUid] ASC,
	[BirthDate] ASC,
	[DeathDate] ASC,
	[LastName] ASC,
	[FirstName] ASC
)
INCLUDE ( 	[DocumentBatchPatientUid],
	[PatientUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[DocumentBatchPatient]') AND name = N'IX_DocumentBatchPatient_DBUid_DBPUid')
CREATE NONCLUSTERED INDEX [IX_DocumentBatchPatient_DBUid_DBPUid] ON [dbo].[DocumentBatchPatient]
(
	[DocumentBatchUid] ASC,
	[DocumentBatchPatientUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[DocumentBatchPatient]') AND name = N'IX_DocumentBatchPatient_PatUid_DBPUid')
CREATE NONCLUSTERED INDEX [IX_DocumentBatchPatient_PatUid_DBPUid] ON [dbo].[DocumentBatchPatient]
(
	[PatientUid] ASC,
	[DocumentBatchPatientUid] ASC
)
INCLUDE ( 	[InsurancePlanUid],
	[Zip]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[DocumentBatchPatientMeasure]') AND name = N'IX_DocumentBatchPatient_Measure_PopulationNumber_StratumNumber_NumeratorNumber')
CREATE UNIQUE NONCLUSTERED INDEX [IX_DocumentBatchPatient_Measure_PopulationNumber_StratumNumber_NumeratorNumber] ON [dbo].[DocumentBatchPatientMeasure]
(
	[DocumentBatchPatientUid] ASC,
	[MeasureUid] ASC,
	[NumeratorNumber] ASC,
	[PopulationNumber] ASC,
	[StratumNumber] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[DocumentBatchPatientMeasure]') AND name = N'IX_DocumentBatchPatientMeasure_DBPUid_RuleNum_PopNum')
CREATE NONCLUSTERED INDEX [IX_DocumentBatchPatientMeasure_DBPUid_RuleNum_PopNum] ON [dbo].[DocumentBatchPatientMeasure]
(
	[DocumentBatchPatientUid] ASC,
	[RuleNumber] ASC,
	[PopulationNumber] ASC
)
INCLUDE ( 	[InNumerator],
	[InDenominator],
	[InException],
	[InExclusion]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[DocumentBatchPatientMeasure]') AND name = N'IX_DocumentBatchPatientMeasure_PopNum_DBPUid_RuleNum')
CREATE NONCLUSTERED INDEX [IX_DocumentBatchPatientMeasure_PopNum_DBPUid_RuleNum] ON [dbo].[DocumentBatchPatientMeasure]
(
	[PopulationNumber] ASC,
	[DocumentBatchPatientUid] ASC,
	[RuleNumber] ASC
)
INCLUDE ( 	[InNumerator],
	[NumeratorNumber],
	[InDenominator],
	[InException],
	[InExclusion]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[DocumentBatchPatientMeasure]') AND name = N'IX_DocumentBatchPatientMeasure_PopNum_DBPUid_RuleNum2')
CREATE NONCLUSTERED INDEX [IX_DocumentBatchPatientMeasure_PopNum_DBPUid_RuleNum2] ON [dbo].[DocumentBatchPatientMeasure]
(
	[PopulationNumber] ASC,
	[DocumentBatchPatientUid] ASC,
	[RuleNumber] ASC
)
INCLUDE ( 	[InNumerator],
	[InDenominator],
	[InException],
	[InExclusion]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[downloadedFiles]') AND name = N'IX_name')
CREATE NONCLUSTERED INDEX [IX_name] ON [dbo].[downloadedFiles]
(
	[name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eClaimFile]') AND name = N'IX_TransmittedBy')
CREATE NONCLUSTERED INDEX [IX_TransmittedBy] ON [dbo].[eClaimFile]
(
	[TransmittedByUid] ASC
)
INCLUDE ( 	[EClaimFileUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eDemographicsOutbound]') AND name = N'IX_eDemographicsOutboundExtId')
CREATE NONCLUSTERED INDEX [IX_eDemographicsOutboundExtId] ON [dbo].[eDemographicsOutbound]
(
	[PatientExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eDemographicsOutbound]') AND name = N'IX_eDemographicsOutboundPatUid')
CREATE NONCLUSTERED INDEX [IX_eDemographicsOutboundPatUid] ON [dbo].[eDemographicsOutbound]
(
	[PatientUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eDemographicsOutbound]') AND name = N'IX_eDemographicsOutboundSubNum')
CREATE NONCLUSTERED INDEX [IX_eDemographicsOutboundSubNum] ON [dbo].[eDemographicsOutbound]
(
	[SubmissionNumber] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eEnrollmentsOutbound]') AND name = N'IX_eEnrollmentsOutboundAccountUid')
CREATE NONCLUSTERED INDEX [IX_eEnrollmentsOutboundAccountUid] ON [dbo].[eEnrollmentsOutbound]
(
	[AccountUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eEnrollmentsOutbound]') AND name = N'IX_eEnrollmentsOutboundPatientExternalID')
CREATE NONCLUSTERED INDEX [IX_eEnrollmentsOutboundPatientExternalID] ON [dbo].[eEnrollmentsOutbound]
(
	[PatientExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eEnrollmentsOutbound]') AND name = N'IX_eEnrollmentsOutboundPatientUid')
CREATE NONCLUSTERED INDEX [IX_eEnrollmentsOutboundPatientUid] ON [dbo].[eEnrollmentsOutbound]
(
	[PatientUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eEnrollmentsOutbound]') AND name = N'IX_eEnrollmentsOutboundPersonInsurancePlanUid')
CREATE NONCLUSTERED INDEX [IX_eEnrollmentsOutboundPersonInsurancePlanUid] ON [dbo].[eEnrollmentsOutbound]
(
	[PersonInsurancePlanUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eEnrollmentsOutbound]') AND name = N'IX_eEnrollmentsOutboundTransConfigUid')
CREATE NONCLUSTERED INDEX [IX_eEnrollmentsOutboundTransConfigUid] ON [dbo].[eEnrollmentsOutbound]
(
	[TransmissionConfigurationUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[EligibilityRequest]') AND name = N'IX_PersonInsurancePlan')
CREATE NONCLUSTERED INDEX [IX_PersonInsurancePlan] ON [dbo].[EligibilityRequest]
(
	[PersonInsurancePlanUid] ASC
)
INCLUDE ( 	[RequestDateTime]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[EligibilityRequest]') AND name = N'IX_ProviderUid')
CREATE NONCLUSTERED INDEX [IX_ProviderUid] ON [dbo].[EligibilityRequest]
(
	[ProviderUid] ASC
)
INCLUDE ( 	[EligibilityRequestUid],
	[PatientUid],
	[PersonInsurancePlanUid],
	[RequestDateTime],
	[DateOfService],
	[MainAccountOnly],
	[TransmitDateTime],
	[TransmitStatus],
	[SubmissionID],
	[RequestXML],
	[RequestX12],
	[ResponseXML],
	[ResponseX12],
	[Error],
	[EligibilityStatusUid],
	[CopayPrimary],
	[CopaySpecialist],
	[CopayOther],
	[InNetworkCoinsurance],
	[InNetworkDeductible],
	[InNetworkRemaining],
	[InNetworkMet],
	[OutNetworkCoinsurance],
	[OutNetworkDeductible],
	[OutNetworkRemaining],
	[OutNetworkMet],
	[EligibilityEffectiveDate],
	[EligibilityExpirationDate],
	[EligibilityNotes],
	[RequestType],
	[LastModifiedDate],
	[LastModifiedByUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[EligibilityRequest]') AND name = N'IX_SubmissionID')
CREATE NONCLUSTERED INDEX [IX_SubmissionID] ON [dbo].[EligibilityRequest]
(
	[SubmissionID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[EligibilityRequest]') AND name = N'IxTransmissStatus')
CREATE NONCLUSTERED INDEX [IxTransmissStatus] ON [dbo].[EligibilityRequest]
(
	[TransmitStatus] ASC
)
INCLUDE ( 	[EligibilityRequestUid],
	[PatientUid],
	[PersonInsurancePlanUid],
	[ProviderUid],
	[RequestDateTime],
	[DateOfService],
	[MainAccountOnly],
	[TransmitDateTime],
	[SubmissionID],
	[RequestXML],
	[RequestX12],
	[ResponseXML],
	[ResponseX12],
	[Error],
	[EligibilityStatusUid],
	[CopayPrimary],
	[CopaySpecialist],
	[CopayOther],
	[InNetworkCoinsurance],
	[InNetworkDeductible],
	[InNetworkRemaining],
	[InNetworkMet],
	[OutNetworkCoinsurance],
	[OutNetworkDeductible],
	[OutNetworkRemaining],
	[OutNetworkMet],
	[EligibilityEffectiveDate],
	[EligibilityExpirationDate],
	[EligibilityNotes],
	[RequestType],
	[LastModifiedDate],
	[LastModifiedByUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[EligibilityRequest]') AND name = N'PatientUid')
CREATE NONCLUSTERED INDEX [PatientUid] ON [dbo].[EligibilityRequest]
(
	[PatientUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[EmailStatusBlock]') AND name = N'IX_EmailStatusBlock')
CREATE NONCLUSTERED INDEX [IX_EmailStatusBlock] ON [dbo].[EmailStatusBlock]
(
	[EmailAddress] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[EmailUnsubscribeGroup]') AND name = N'IX_EmailUnsubscribeGroup')
CREATE UNIQUE NONCLUSTERED INDEX [IX_EmailUnsubscribeGroup] ON [dbo].[EmailUnsubscribeGroup]
(
	[Type] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ERAClaimAdjustment]') AND name = N'IX_ERAClaimPaymentInfo')
CREATE NONCLUSTERED INDEX [IX_ERAClaimPaymentInfo] ON [dbo].[ERAClaimAdjustment]
(
	[ERAClaimPaymentInfoUid] ASC
)
INCLUDE ( 	[ERAClaimAdjustmentUid],
	[GroupCode],
	[GroupCodeERACodeUid],
	[ReasonCode],
	[ReasonCodeERACodeUid],
	[Amount],
	[Quantity],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ERAClaimAmount]') AND name = N'IX_ERAClaimPaymentInfo')
CREATE NONCLUSTERED INDEX [IX_ERAClaimPaymentInfo] ON [dbo].[ERAClaimAmount]
(
	[ERAClaimPaymentInfoUid] ASC
)
INCLUDE ( 	[ERAClaimAmountUid],
	[QualifierCode],
	[Amount],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ERAClaimAmount]') AND name = N'IX_ERAClaimPaymentInfo_QualifierCode')
CREATE NONCLUSTERED INDEX [IX_ERAClaimPaymentInfo_QualifierCode] ON [dbo].[ERAClaimAmount]
(
	[ERAClaimPaymentInfoUid] ASC,
	[QualifierCode] ASC
)
INCLUDE ( 	[Amount]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ERAClaimEntity]') AND name = N'IX_ERAClaimEntity')
CREATE NONCLUSTERED INDEX [IX_ERAClaimEntity] ON [dbo].[ERAClaimEntity]
(
	[TypeQualifier] ASC,
	[ERAClaimPaymentInfoUid] ASC,
	[IdentifierCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ERAClaimEntity]') AND name = N'IX_ERAClaimPaymentInfoUid')
CREATE NONCLUSTERED INDEX [IX_ERAClaimPaymentInfoUid] ON [dbo].[ERAClaimEntity]
(
	[ERAClaimPaymentInfoUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ERAClaimPaymentInfo]') AND name = N'IX_ERAClaimPaymentInfo')
CREATE NONCLUSTERED INDEX [IX_ERAClaimPaymentInfo] ON [dbo].[ERAClaimPaymentInfo]
(
	[ERAHeaderUid] ASC,
	[ERAClaimPaymentInfoUid] ASC,
	[ClaimSubmitterID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ERAClaimPaymentInfo]') AND name = N'IX_ERAClaimPaymentInfoUid_ERAHeaderUid_RuleStatus')
CREATE NONCLUSTERED INDEX [IX_ERAClaimPaymentInfoUid_ERAHeaderUid_RuleStatus] ON [dbo].[ERAClaimPaymentInfo]
(
	[ERAClaimPaymentInfoUid] ASC,
	[ERAHeaderUid] ASC,
	[RuleStatus] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ERAClaimPaymentInfo]') AND name = N'IX_ERAHeader')
CREATE NONCLUSTERED INDEX [IX_ERAHeader] ON [dbo].[ERAClaimPaymentInfo]
(
	[ERAHeaderUid] ASC
)
INCLUDE ( 	[ERAClaimPaymentInfoUid],
	[ProcessStatus]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ERAClaimPaymentInfo]') AND name = N'IX_Patient')
CREATE NONCLUSTERED INDEX [IX_Patient] ON [dbo].[ERAClaimPaymentInfo]
(
	[PatientUid] ASC
)
INCLUDE ( 	[ERAClaimPaymentInfoUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ERAClaimPaymentInfo]') AND name = N'IX_Transaction')
CREATE NONCLUSTERED INDEX [IX_Transaction] ON [dbo].[ERAClaimPaymentInfo]
(
	[TransactionUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ERAClaimPaymentInfoError]') AND name = N'ix_ERAClaimPaymentInfoError_ERAClaimPaymentInfoUid')
CREATE NONCLUSTERED INDEX [ix_ERAClaimPaymentInfoError_ERAClaimPaymentInfoUid] ON [dbo].[ERAClaimPaymentInfoError]
(
	[ERAClaimPaymentInfoUid] ASC
)
INCLUDE ( 	[ErrorText],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ERAHeader]') AND name = N'IX_ERATransactionSetUid')
CREATE NONCLUSTERED INDEX [IX_ERATransactionSetUid] ON [dbo].[ERAHeader]
(
	[ERATransactionSetUid] ASC
)
INCLUDE ( 	[ERAHeaderUid],
	[AssignedNumber],
	[ReferenceID],
	[FacilityTypeCode],
	[FiscalPeriodDate],
	[TotalClaimCount],
	[TotalClaimChargeAmount],
	[TotalCoveredChargeAmount],
	[TotalNoncoveredChargeAmount],
	[TotalDeniedChargeAmount],
	[TotalProviderPaymentAmount],
	[TotalInterestAmount],
	[TotalContractualAdjustmentAmount],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ERAHealthCareRemarkCode]') AND name = N'IX_ERAServicePaymentInfo')
CREATE NONCLUSTERED INDEX [IX_ERAServicePaymentInfo] ON [dbo].[ERAHealthCareRemarkCode]
(
	[ERAServicePaymentInfoUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ERAServiceAdjustment]') AND name = N'IX_Credit')
CREATE NONCLUSTERED INDEX [IX_Credit] ON [dbo].[ERAServiceAdjustment]
(
	[CreditUid] ASC
)
INCLUDE ( 	[ERAServiceAdjustmentUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ERAServiceAdjustment]') AND name = N'IX_ERAServiceAdjustment')
CREATE NONCLUSTERED INDEX [IX_ERAServiceAdjustment] ON [dbo].[ERAServiceAdjustment]
(
	[ERAServicePaymentInfoUid] ASC,
	[GroupCode] ASC,
	[ReasonCode] ASC,
	[Amount] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ERAServiceAdjustment]') AND name = N'IX_LedgerDetail')
CREATE NONCLUSTERED INDEX [IX_LedgerDetail] ON [dbo].[ERAServiceAdjustment]
(
	[LedgerDetailUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ERAServiceAmount]') AND name = N'IX_ERAServiceAmount')
CREATE NONCLUSTERED INDEX [IX_ERAServiceAmount] ON [dbo].[ERAServiceAmount]
(
	[ERAServicePaymentInfoUid] ASC,
	[QualifierCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ERAServiceIdentification]') AND name = N'IX_ERAServiceIdentification')
CREATE NONCLUSTERED INDEX [IX_ERAServiceIdentification] ON [dbo].[ERAServiceIdentification]
(
	[ReferenceIDQualifier] ASC,
	[ERAServicePaymentInfoUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ERAServiceIdentification]') AND name = N'IX_ERAServicePaymentInfo')
CREATE NONCLUSTERED INDEX [IX_ERAServicePaymentInfo] ON [dbo].[ERAServiceIdentification]
(
	[ERAServicePaymentInfoUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ERAServicePaymentInfo]') AND name = N'ARContext')
CREATE NONCLUSTERED INDEX [ARContext] ON [dbo].[ERAServicePaymentInfo]
(
	[ARContextUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ERAServicePaymentInfo]') AND name = N'ERAServicePaymentInfo')
CREATE NONCLUSTERED INDEX [ERAServicePaymentInfo] ON [dbo].[ERAServicePaymentInfo]
(
	[ERAClaimPaymentInfoUid] ASC
)
INCLUDE ( 	[SuperbillProcedureUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ERAServicePaymentInfo]') AND name = N'IX_Credit')
CREATE NONCLUSTERED INDEX [IX_Credit] ON [dbo].[ERAServicePaymentInfo]
(
	[CreditUid] ASC
)
INCLUDE ( 	[ERAServicePaymentInfoUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ERAServicePaymentInfo]') AND name = N'IX_LedgerDetail')
CREATE NONCLUSTERED INDEX [IX_LedgerDetail] ON [dbo].[ERAServicePaymentInfo]
(
	[LedgerDetailUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ERAServicePaymentInfo]') AND name = N'IX_SuperbillProcedure')
CREATE NONCLUSTERED INDEX [IX_SuperbillProcedure] ON [dbo].[ERAServicePaymentInfo]
(
	[SuperbillProcedureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ERAServicePaymentInfoError]') AND name = N'IX_ERAServicePaymentInfoUid')
CREATE NONCLUSTERED INDEX [IX_ERAServicePaymentInfoUid] ON [dbo].[ERAServicePaymentInfoError]
(
	[ERAServicePaymentInfoUid] ASC
)
INCLUDE ( 	[ERAServicePaymentInfoErrorUid],
	[LastModifiedDate],
	[Sequence]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ERATransactionSet]') AND name = N'IX_ERATransactionSet_ERAFunctionalGroupUid')
CREATE NONCLUSTERED INDEX [IX_ERATransactionSet_ERAFunctionalGroupUid] ON [dbo].[ERATransactionSet]
(
	[ERAFunctionalGroupUid] ASC
)
INCLUDE ( 	[ERATransactionSetUid],
	[ControlNumber],
	[TransactionHandlingCode],
	[TotalMonetaryAmount],
	[CreditDebitFlagCode],
	[PaymentMethodCode],
	[CheckIssueDate],
	[TraceTypeCode],
	[ReferenceID],
	[ProductionDate],
	[PayerName],
	[PayerID],
	[RuleStatus],
	[Archived]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ERATransactionSet]') AND name = N'IX_RuleStatus_Archived')
CREATE NONCLUSTERED INDEX [IX_RuleStatus_Archived] ON [dbo].[ERATransactionSet]
(
	[RuleStatus] ASC,
	[Archived] ASC
)
INCLUDE ( 	[ERATransactionSetUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ERATransactionSetDeposit]') AND name = N'DepositUid')
CREATE NONCLUSTERED INDEX [DepositUid] ON [dbo].[ERATransactionSetDeposit]
(
	[DepositUid] ASC
)
INCLUDE ( 	[ERATransactionSetUid],
	[PayerUid],
	[MonetaryAmount]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ERATransactionSetDeposit]') AND name = N'IX_ERATransactionSetDeposit')
CREATE NONCLUSTERED INDEX [IX_ERATransactionSetDeposit] ON [dbo].[ERATransactionSetDeposit]
(
	[ERATransactionSetUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eReportRows]') AND name = N'IDX_InsuredUid')
CREATE NONCLUSTERED INDEX [IDX_InsuredUid] ON [dbo].[eReportRows]
(
	[insuredUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eReportRows]') AND name = N'IX_ClaimReportStatus_errorflag')
CREATE NONCLUSTERED INDEX [IX_ClaimReportStatus_errorflag] ON [dbo].[eReportRows]
(
	[ClaimReportStatusUid] ASC,
	[errorFlag] ASC
)
INCLUDE ( 	[superbillUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eReportRows]') AND name = N'IX_eReportRows_coverPerSuperbill')
CREATE NONCLUSTERED INDEX [IX_eReportRows_coverPerSuperbill] ON [dbo].[eReportRows]
(
	[superbillUid] ASC,
	[ClaimReportStatusUid] ASC,
	[errorFlag] ASC,
	[followUp] ASC,
	[LastModifiedByUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eReportRows]') AND name = N'IX_InsuranceCarrierUid_inc')
CREATE NONCLUSTERED INDEX [IX_InsuranceCarrierUid_inc] ON [dbo].[eReportRows]
(
	[InsuranceCarrierUid] ASC
)
INCLUDE ( 	[eReportRowUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eReportRows]') AND name = N'IX_Patient')
CREATE NONCLUSTERED INDEX [IX_Patient] ON [dbo].[eReportRows]
(
	[patientUid] ASC
)
INCLUDE ( 	[eReportRowUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eReportRows]') AND name = N'IX_Superbill_ClaimReportStatus_ErrorFlag')
CREATE NONCLUSTERED INDEX [IX_Superbill_ClaimReportStatus_ErrorFlag] ON [dbo].[eReportRows]
(
	[superbillUid] ASC,
	[ClaimReportStatusUid] ASC,
	[errorFlag] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eReportRows]') AND name = N'IX_SUPERBILLUID_INC')
CREATE NONCLUSTERED INDEX [IX_SUPERBILLUID_INC] ON [dbo].[eReportRows]
(
	[superbillUid] ASC
)
INCLUDE ( 	[eReportRowUid],
	[eReportDetailUid],
	[ClaimReportStatusUid],
	[insuredUid],
	[InsuranceCarrierUid],
	[errorDescription],
	[additionalClaimInformation],
	[perSeErrorCode],
	[errorFlag],
	[LastModifiedDate],
	[LastModifiedByUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ErrorReport]') AND name = N'IX_UserName_Uploaded')
CREATE NONCLUSTERED INDEX [IX_UserName_Uploaded] ON [dbo].[ErrorReport]
(
	[UserName] ASC,
	[Uploaded] ASC
)
INCLUDE ( 	[ErrorReportUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxBenefitsDownload]') AND name = N'IX_eRxBenefitsDownload_LastModifiedDate')
CREATE NONCLUSTERED INDEX [IX_eRxBenefitsDownload_LastModifiedDate] ON [dbo].[eRxBenefitsDownload]
(
	[LastModifiedDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxBenefitsDownload]') AND name = N'IX_eRxBenefitsDownload_PatientLastSucceedeMedHXDownloadedDate')
CREATE NONCLUSTERED INDEX [IX_eRxBenefitsDownload_PatientLastSucceedeMedHXDownloadedDate] ON [dbo].[eRxBenefitsDownload]
(
	[PatientUid] ASC,
	[LastSucceedeMedHXDownloadedDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxBenefitsDownload]') AND name = N'IX_eRxBenefitsDownload_PatientLastSucceedRXBenefitsDownloadedDate')
CREATE NONCLUSTERED INDEX [IX_eRxBenefitsDownload_PatientLastSucceedRXBenefitsDownloadedDate] ON [dbo].[eRxBenefitsDownload]
(
	[PatientUid] ASC,
	[LastSucceedRXBenefitsDownloadedDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxEligibilityOutbound]') AND name = N'IDX_eRxEligibilityOutbound_AccountUid')
CREATE NONCLUSTERED INDEX [IDX_eRxEligibilityOutbound_AccountUid] ON [dbo].[eRxEligibilityOutbound]
(
	[AccountUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxEligibilityOutbound]') AND name = N'IX_eRxEligibilityOutbound_Processed_PharmacyClearinghouseUid')
CREATE NONCLUSTERED INDEX [IX_eRxEligibilityOutbound_Processed_PharmacyClearinghouseUid] ON [dbo].[eRxEligibilityOutbound]
(
	[Processed] ASC,
	[PharmacyClearinghouseUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxEligibilityOutbound]') AND name = N'IX_Patient_LastModifiedDate')
CREATE NONCLUSTERED INDEX [IX_Patient_LastModifiedDate] ON [dbo].[eRxEligibilityOutbound]
(
	[PatientUid] ASC,
	[LastModifiedDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxEligibilityOutbound]') AND name = N'IX_Patient_RequestDate')
CREATE NONCLUSTERED INDEX [IX_Patient_RequestDate] ON [dbo].[eRxEligibilityOutbound]
(
	[PatientUid] ASC,
	[RequestDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxEligibilityOutbound]') AND name = N'IX_Patient_Successful')
CREATE NONCLUSTERED INDEX [IX_Patient_Successful] ON [dbo].[eRxEligibilityOutbound]
(
	[PatientUid] ASC,
	[Successful] ASC
)
INCLUDE ( 	[eRxEligibilityOutboundUid],
	[ProviderUid],
	[PharmacyClearinghouseUid],
	[eRxMessageTypeUid],
	[eRxStatusUid],
	[RequestDate],
	[SendResponse],
	[Processed],
	[OrderNumber],
	[OrderDateTime],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxEligibilityOutbound]') AND name = N'IX_RequestDate')
CREATE NONCLUSTERED INDEX [IX_RequestDate] ON [dbo].[eRxEligibilityOutbound]
(
	[RequestDate] ASC
)
INCLUDE ( 	[PatientUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxInbound]') AND name = N'IDX_eRxInbound_ProviderUid')
CREATE NONCLUSTERED INDEX [IDX_eRxInbound_ProviderUid] ON [dbo].[eRxInbound]
(
	[ProviderUid] ASC
)
INCLUDE ( 	[eRxInboundUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxInbound]') AND name = N'IX_eRxMessageType_LastModifiedDate')
CREATE NONCLUSTERED INDEX [IX_eRxMessageType_LastModifiedDate] ON [dbo].[eRxInbound]
(
	[eRxMessageTypeUid] ASC,
	[LastModifiedDate] ASC
)
INCLUDE ( 	[eRxInboundUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxInbound]') AND name = N'IX_ProviderUid_eRxInboundUid')
CREATE NONCLUSTERED INDEX [IX_ProviderUid_eRxInboundUid] ON [dbo].[eRxInbound]
(
	[ProviderUid] ASC
)
INCLUDE ( 	[eRxInboundUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxInbound]') AND name = N'Processed_eRxMessageType')
CREATE NONCLUSTERED INDEX [Processed_eRxMessageType] ON [dbo].[eRxInbound]
(
	[Processed] ASC,
	[eRxMessageTypeUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxInbound]') AND name = N'Processed_eRxMessageTypeUid')
CREATE NONCLUSTERED INDEX [Processed_eRxMessageTypeUid] ON [dbo].[eRxInbound]
(
	[eRxMessageTypeUid] ASC,
	[Processed] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxMedicationHistory]') AND name = N'IX_Patient')
CREATE NONCLUSTERED INDEX [IX_Patient] ON [dbo].[eRxMedicationHistory]
(
	[PatientUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxMedicationHistory]') AND name = N'IX_Patient_ProcessStatus')
CREATE NONCLUSTERED INDEX [IX_Patient_ProcessStatus] ON [dbo].[eRxMedicationHistory]
(
	[PatientUid] ASC,
	[ProcessStatus] ASC,
	[LastDownloadedDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxMedicationHistoryDetail]') AND name = N'IX_Patient')
CREATE NONCLUSTERED INDEX [IX_Patient] ON [dbo].[eRxMedicationHistoryDetail]
(
	[PatientUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxMedicationHistoryDetail]') AND name = N'IX_Patient_IsProcessed')
CREATE NONCLUSTERED INDEX [IX_Patient_IsProcessed] ON [dbo].[eRxMedicationHistoryDetail]
(
	[PatientUid] ASC,
	[IsProcessed] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxMedicationHistoryDetail]') AND name = N'IX_RelPatientMedicationUid')
CREATE NONCLUSTERED INDEX [IX_RelPatientMedicationUid] ON [dbo].[eRxMedicationHistoryDetail]
(
	[RelPatientMedicationUid] ASC
)
INCLUDE ( 	[eRxMedicationHistoryDetailUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxMedicationHistoryOutbound]') AND name = N'eRxMedicationHistoryOutboundUid_ProviderUid_PatientUid_LastModifiedDate')
CREATE NONCLUSTERED INDEX [eRxMedicationHistoryOutboundUid_ProviderUid_PatientUid_LastModifiedDate] ON [dbo].[eRxMedicationHistoryOutbound]
(
	[PharmacyClearinghouseUid] ASC,
	[eRxMessageTypeUid] ASC,
	[Processed] ASC
)
INCLUDE ( 	[eRxMedicationHistoryOutboundUid],
	[ProviderUid],
	[PatientUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxMedicationHistoryOutbound]') AND name = N'IX_eRxMedicationHistoryOutbound')
CREATE NONCLUSTERED INDEX [IX_eRxMedicationHistoryOutbound] ON [dbo].[eRxMedicationHistoryOutbound]
(
	[PatientUid] ASC,
	[OrderNumber] ASC,
	[OrderDateTime] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxMedicationHistoryOutbound]') AND name = N'IX_eRxMedicationHistoryOutbound_1')
CREATE NONCLUSTERED INDEX [IX_eRxMedicationHistoryOutbound_1] ON [dbo].[eRxMedicationHistoryOutbound]
(
	[PatientUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxMedicationHistoryOutbound]') AND name = N'IX_eRxMedicationHistoryOutbound_Processed_PharmacyClearinghouseUid')
CREATE NONCLUSTERED INDEX [IX_eRxMedicationHistoryOutbound_Processed_PharmacyClearinghouseUid] ON [dbo].[eRxMedicationHistoryOutbound]
(
	[Processed] ASC,
	[PharmacyClearinghouseUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxMedicationHistoryOutbound]') AND name = N'IX_eRxMessageType_OrderNumber')
CREATE NONCLUSTERED INDEX [IX_eRxMessageType_OrderNumber] ON [dbo].[eRxMedicationHistoryOutbound]
(
	[eRxMessageTypeUid] ASC,
	[OrderNumber] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxOutbound]') AND name = N'IX_eRxOutbound_OrderNumber_eRxMsgType')
CREATE NONCLUSTERED INDEX [IX_eRxOutbound_OrderNumber_eRxMsgType] ON [dbo].[eRxOutbound]
(
	[OrderNumber] ASC,
	[eRxMessageTypeUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxOutbound]') AND name = N'IX_PHARMACYUID_INC')
CREATE NONCLUSTERED INDEX [IX_PHARMACYUID_INC] ON [dbo].[eRxOutbound]
(
	[PharmacyUid] ASC,
	[Processed] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxOutbound]') AND name = N'IX_Processed_PharmancyClearinghouse')
CREATE NONCLUSTERED INDEX [IX_Processed_PharmancyClearinghouse] ON [dbo].[eRxOutbound]
(
	[Processed] ASC,
	[PharmacyClearinghouseUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxOutbound]') AND name = N'IX_SIGDetailUid_eRxOutboundUid_VisitUid')
CREATE NONCLUSTERED INDEX [IX_SIGDetailUid_eRxOutboundUid_VisitUid] ON [dbo].[eRxOutbound]
(
	[SIGDetailUid] ASC
)
INCLUDE ( 	[eRxOutboundUid],
	[VisitUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxOutbound]') AND name = N'IXR_VisitMedicationUid')
CREATE NONCLUSTERED INDEX [IXR_VisitMedicationUid] ON [dbo].[eRxOutbound]
(
	[RelVisitMedicationUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxOutbound]') AND name = N'IXR_VisitUid')
CREATE NONCLUSTERED INDEX [IXR_VisitUid] ON [dbo].[eRxOutbound]
(
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxProcessStatus]') AND name = N'IX_eRxProcessStatusTransmissionOutboundUid')
CREATE NONCLUSTERED INDEX [IX_eRxProcessStatusTransmissionOutboundUid] ON [dbo].[eRxProcessStatus]
(
	[TransmissionOutboundUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[eRxPRVBRDOutbound]') AND name = N'[IX_eRxPRVBRDOutbound _ Processed_PharmacyClearinghouseUid_eRxMessageTypeUid')
CREATE NONCLUSTERED INDEX [[IX_eRxPRVBRDOutbound _ Processed_PharmacyClearinghouseUid_eRxMessageTypeUid] ON [dbo].[eRxPRVBRDOutbound]
(
	[Processed] ASC,
	[PharmacyClearinghouseUid] ASC,
	[eRxMessageTypeUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ExternalDataReporting]') AND name = N'NonClusteredIndex-20150106-173336')
CREATE NONCLUSTERED INDEX [NonClusteredIndex-20150106-173336] ON [dbo].[ExternalDataReporting]
(
	[ReportInstanceUid] ASC
)
INCLUDE ( 	[InsertSequence]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FaxQueue]') AND name = N'IDX_FaxQueue_VisitUid')
CREATE NONCLUSTERED INDEX [IDX_FaxQueue_VisitUid] ON [dbo].[FaxQueue]
(
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FaxQueue]') AND name = N'ix_FaxQueue_Submitted_FaxType')
CREATE NONCLUSTERED INDEX [ix_FaxQueue_Submitted_FaxType] ON [dbo].[FaxQueue]
(
	[Submitted] ASC,
	[FaxType] ASC
)
INCLUDE ( 	[FaxQueueUid],
	[Parameters]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FaxQueue]') AND name = N'IX_Patient')
CREATE NONCLUSTERED INDEX [IX_Patient] ON [dbo].[FaxQueue]
(
	[PatientUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FaxQueue]') AND name = N'IX_TransactionID')
CREATE NONCLUSTERED INDEX [IX_TransactionID] ON [dbo].[FaxQueue]
(
	[TransactionID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FaxQueue]') AND name = N'IX_TransactionID_XDN')
CREATE NONCLUSTERED INDEX [IX_TransactionID_XDN] ON [dbo].[FaxQueue]
(
	[TransactionID] ASC,
	[XDN] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FaxQueue]') AND name = N'IX_User_LastModifiedDate')
CREATE NONCLUSTERED INDEX [IX_User_LastModifiedDate] ON [dbo].[FaxQueue]
(
	[UserUid] ASC,
	[LastModifiedDate] ASC
)
INCLUDE ( 	[FaxQueueUid],
	[TransactionID],
	[StatusID],
	[Submitted],
	[Message],
	[FaxNumber],
	[RetryFaxNumber],
	[FaxType],
	[FaxReceipientName],
	[SubmitTime],
	[CompletionTime],
	[Parameters],
	[FaxCoverSheetUid],
	[ServicedBy],
	[PatientUid],
	[FaxServerUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FeeSchedule]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[FeeSchedule]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FeeSchedule]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[FeeSchedule]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FeeScheduleFee]') AND name = N'IX_FeeSchedulePeriod')
CREATE NONCLUSTERED INDEX [IX_FeeSchedulePeriod] ON [dbo].[FeeScheduleFee]
(
	[FeeSchedulePeriodUid] ASC
)
INCLUDE ( 	[FeeScheduleFeeUid],
	[Fee],
	[IsInsurancePlanPhysician],
	[IsInsurancePlanOther],
	[FixedCopayAmount],
	[ProcedureUid],
	[InsurancePercent],
	[Inactive],
	[UserDefined],
	[GlobalPeriodDays],
	[LastModifiedDate],
	[LastModifiedByUid],
	[MultiplyUnits],
	[ContractTypeCodeUid],
	[PayorPlanSetUid],
	[FamilyPlanning]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FeeScheduleFee]') AND name = N'IX_Procedure_FeeSchedulePeriod')
CREATE NONCLUSTERED INDEX [IX_Procedure_FeeSchedulePeriod] ON [dbo].[FeeScheduleFee]
(
	[ProcedureUid] ASC,
	[FeeSchedulePeriodUid] ASC
)
INCLUDE ( 	[Fee]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FeeSchedulePeriod]') AND name = N'IX_FeeSchedule')
CREATE NONCLUSTERED INDEX [IX_FeeSchedule] ON [dbo].[FeeSchedulePeriod]
(
	[FeeScheduleUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FeeSchedulePeriod]') AND name = N'IX_FeeSchedule_Effective_Expiration')
CREATE NONCLUSTERED INDEX [IX_FeeSchedule_Effective_Expiration] ON [dbo].[FeeSchedulePeriod]
(
	[FeeScheduleUid] ASC,
	[EffectiveDate] ASC,
	[ExpirationDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FinancialCenter]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[FinancialCenter]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FinancialCenter]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[FinancialCenter]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[FormTemplate]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[FormTemplate]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[HL7ActionTypeObject]') AND name = N'HL7ATO_Object_ActionType_Error')
CREATE NONCLUSTERED INDEX [HL7ATO_Object_ActionType_Error] ON [dbo].[HL7ActionTypeObject]
(
	[ActionType] ASC,
	[ObjectUid] ASC,
	[ProcessingError] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[HL7ActionTypeObject]') AND name = N'IX_HL7PartnerMessage_ObjectType_Object')
CREATE NONCLUSTERED INDEX [IX_HL7PartnerMessage_ObjectType_Object] ON [dbo].[HL7ActionTypeObject]
(
	[HL7PartnerMessageUid] ASC,
	[ObjectType] ASC,
	[ObjectUid] ASC
)
INCLUDE ( 	[HL7ActionTypeObjectUid],
	[ProcessingError]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[HL7ActionTypeObject]') AND name = N'IX_Object')
CREATE NONCLUSTERED INDEX [IX_Object] ON [dbo].[HL7ActionTypeObject]
(
	[ObjectUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[HL7ActionTypeObject]') AND name = N'IX_Object_ActionType')
CREATE NONCLUSTERED INDEX [IX_Object_ActionType] ON [dbo].[HL7ActionTypeObject]
(
	[ObjectUid] ASC,
	[ActionType] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[HL7ActionTypeObject]') AND name = N'IX_ObjectType_Object')
CREATE NONCLUSTERED INDEX [IX_ObjectType_Object] ON [dbo].[HL7ActionTypeObject]
(
	[ObjectType] ASC,
	[ObjectUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[HL7IdMap]') AND name = N'IX_HL7IdMap')
CREATE NONCLUSTERED INDEX [IX_HL7IdMap] ON [dbo].[HL7IdMap]
(
	[HL7PartnerUid] ASC,
	[MapType] ASC,
	[ExternalId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[HL7MappedField]') AND name = N'IX_HL7MappedSegment_Inactive')
CREATE NONCLUSTERED INDEX [IX_HL7MappedSegment_Inactive] ON [dbo].[HL7MappedField]
(
	[HL7MappedSegmentUid] ASC,
	[Inactive] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[HL7MappedField]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[HL7MappedField]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[HL7MappedSegment]') AND name = N'IX_Inactive_MessageType')
CREATE NONCLUSTERED INDEX [IX_Inactive_MessageType] ON [dbo].[HL7MappedSegment]
(
	[Inactive] ASC,
	[MessageType] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[HL7MappedSegment]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[HL7MappedSegment]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[HL7Message]') AND name = N'HL7PartnerMessage_Status_HL7Message')
CREATE NONCLUSTERED INDEX [HL7PartnerMessage_Status_HL7Message] ON [dbo].[HL7Message]
(
	[RetryTime] ASC,
	[Status] ASC,
	[HL7MessageUid] ASC
)
INCLUDE ( 	[HL7PartnerMessageUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[HL7Message]') AND name = N'IX_HL7_MessageControlId')
CREATE NONCLUSTERED INDEX [IX_HL7_MessageControlId] ON [dbo].[HL7Message]
(
	[MessageControlID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[HL7Message]') AND name = N'IX_HL7Message')
CREATE NONCLUSTERED INDEX [IX_HL7Message] ON [dbo].[HL7Message]
(
	[HL7PartnerMessageUid] ASC,
	[Status] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[HL7Message]') AND name = N'IX_HL7Message_OriginalObject')
CREATE NONCLUSTERED INDEX [IX_HL7Message_OriginalObject] ON [dbo].[HL7Message]
(
	[OriginalObjectUid] ASC,
	[OriginalObjectType] ASC,
	[OriginalActionType] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[HL7Message]') AND name = N'IX_HL7PartnerMessage_LastModifiedDate')
CREATE NONCLUSTERED INDEX [IX_HL7PartnerMessage_LastModifiedDate] ON [dbo].[HL7Message]
(
	[HL7PartnerMessageUid] ASC,
	[LastModifiedDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[HL7Message]') AND name = N'IX_LastModifiedDate')
CREATE NONCLUSTERED INDEX [IX_LastModifiedDate] ON [dbo].[HL7Message]
(
	[LastModifiedDate] ASC
)
INCLUDE ( 	[HL7MessageUid],
	[HL7PartnerMessageUid],
	[Status],
	[RetryTime]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[HL7Message]') AND name = N'IXR_HL7PartnerMessageUidW')
CREATE NONCLUSTERED INDEX [IXR_HL7PartnerMessageUidW] ON [dbo].[HL7Message]
(
	[HL7PartnerMessageUid] ASC
)
INCLUDE ( 	[HL7MessageUid],
	[Status],
	[RetryTime],
	[LastModifiedDate],
	[XmlMessage],
	[RawMessage],
	[RetryMinutes],
	[MessageControlID]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[HL7Message]') AND name = N'Status_RetryTime')
CREATE NONCLUSTERED INDEX [Status_RetryTime] ON [dbo].[HL7Message]
(
	[Status] ASC,
	[RetryTime] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[HL7MessageError]') AND name = N'IX_HL7MessageError')
CREATE NONCLUSTERED INDEX [IX_HL7MessageError] ON [dbo].[HL7MessageError]
(
	[HL7MessageUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[HL7MessageError]') AND name = N'IX_HL7MessageUid_LastModifiedDate')
CREATE NONCLUSTERED INDEX [IX_HL7MessageUid_LastModifiedDate] ON [dbo].[HL7MessageError]
(
	[HL7MessageUid] ASC,
	[LastModifiedDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[HL7MessageError]') AND name = N'IXR_ActionTypeObjectUidW')
CREATE NONCLUSTERED INDEX [IXR_ActionTypeObjectUidW] ON [dbo].[HL7MessageError]
(
	[ActionTypeObjectUid] ASC
)
INCLUDE ( 	[HL7MessageErrorUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[HL7MessageError]') AND name = N'IXR_LastModifiedDateW')
CREATE NONCLUSTERED INDEX [IXR_LastModifiedDateW] ON [dbo].[HL7MessageError]
(
	[LastModifiedDate] ASC
)
INCLUDE ( 	[HL7MessageErrorUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[HL7MessageTracking]') AND name = N'IX_HL7MessageUid_ObjectUid')
CREATE NONCLUSTERED INDEX [IX_HL7MessageUid_ObjectUid] ON [dbo].[HL7MessageTracking]
(
	[HL7MessageUid] ASC,
	[ObjectUid] ASC
)
INCLUDE ( 	[HL7MessageTrackingUid],
	[HL7PartnerMessageUid],
	[ObjectType],
	[TransmitLocalDateTime],
	[LastModifiedDate],
	[LastModifiedByUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[HL7OrderSplitCategory]') AND name = N'IX_HL7OrderSplitCategory')
ALTER TABLE [dbo].[HL7OrderSplitCategory] ADD  CONSTRAINT [IX_HL7OrderSplitCategory] UNIQUE NONCLUSTERED 
(
	[LabOrderCode] ASC,
	[LaboratoryUid] ASC,
	[SplitCategory] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[HL7Partner]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[HL7Partner]
(
	[ExternalId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[HL7Partner]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[HL7Partner]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[HL7PartnerMessage]') AND name = N'HL7PartnerMessage_MessageType_HL7Partner_MessageEvent_ProcessorAQN')
CREATE NONCLUSTERED INDEX [HL7PartnerMessage_MessageType_HL7Partner_MessageEvent_ProcessorAQN] ON [dbo].[HL7PartnerMessage]
(
	[HL7PartnerMessageUid] ASC,
	[MessageType] ASC,
	[HL7PartnerUid] ASC,
	[MessageEvent] ASC,
	[ProcessorAQN] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[HL7PartnerMessage]') AND name = N'HL7PM_MessageType')
CREATE NONCLUSTERED INDEX [HL7PM_MessageType] ON [dbo].[HL7PartnerMessage]
(
	[MessageType] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[HospitalRound]') AND name = N'IX_Patient')
CREATE NONCLUSTERED INDEX [IX_Patient] ON [dbo].[HospitalRound]
(
	[PatientUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ImmunizationHistory]') AND name = N'IX_ImmunizationHistory_TypeOfVaccineUid')
CREATE NONCLUSTERED INDEX [IX_ImmunizationHistory_TypeOfVaccineUid] ON [dbo].[ImmunizationHistory]
(
	[TypeofVaccineUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ImmunizationHistory]') AND name = N'IX_Patient')
CREATE NONCLUSTERED INDEX [IX_Patient] ON [dbo].[ImmunizationHistory]
(
	[PatientUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ImmunizationHistory]') AND name = N'IX_VisitUid')
CREATE NONCLUSTERED INDEX [IX_VisitUid] ON [dbo].[ImmunizationHistory]
(
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ImmunizationHistory]') AND name = N'VisitProcedureUid')
CREATE NONCLUSTERED INDEX [VisitProcedureUid] ON [dbo].[ImmunizationHistory]
(
	[VisitProcedureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[InstantMessage]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[InstantMessage]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[InstantMessage]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[InstantMessage]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[InsurancePlan]') AND name = N'InsuranceCarrier_InsurancePlan')
CREATE NONCLUSTERED INDEX [InsuranceCarrier_InsurancePlan] ON [dbo].[InsurancePlan]
(
	[InsuranceCarrierUid] ASC,
	[InsurancePlanUid] ASC
)
INCLUDE ( 	[Name]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[InsurancePlan]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[InsurancePlan]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[InsurancePlan]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[InsurancePlan]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[InterfaceDataMapping]') AND name = N'IX_InterfaceDataMapping_DataElem_Meas_Name')
CREATE NONCLUSTERED INDEX [IX_InterfaceDataMapping_DataElem_Meas_Name] ON [dbo].[InterfaceDataMapping]
(
	[DataElementName] ASC,
	[QRDAMeasure] ASC,
	[Name] ASC
)
INCLUDE ( 	[PRMCode]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[InterfaceDataMapping]') AND name = N'IX_InterfaceDataMapping_DataElem_Name_Measure_PRMCode')
CREATE NONCLUSTERED INDEX [IX_InterfaceDataMapping_DataElem_Name_Measure_PRMCode] ON [dbo].[InterfaceDataMapping]
(
	[DataElementName] ASC,
	[Name] ASC,
	[QRDAMeasure] ASC,
	[PRMCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[InterfaceDataMapping]') AND name = N'IX_InterfaceDataMapping_Meas_PRMCode_DataElem_Name')
CREATE NONCLUSTERED INDEX [IX_InterfaceDataMapping_Meas_PRMCode_DataElem_Name] ON [dbo].[InterfaceDataMapping]
(
	[QRDAMeasure] ASC,
	[PRMCode] ASC,
	[DataElementName] ASC,
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[InterfaceDataMapping]') AND name = N'ix_InterfaceDataMapping_Rootid_IsDefault')
CREATE NONCLUSTERED INDEX [ix_InterfaceDataMapping_Rootid_IsDefault] ON [dbo].[InterfaceDataMapping]
(
	[Rootid] ASC,
	[IsDefault] ASC
)
INCLUDE ( 	[InterfaceDataMappingUid],
	[Name],
	[CCDCode],
	[PRMCode],
	[CCDPrintName],
	[Inactive],
	[UserDefined],
	[LastModifiedDate],
	[LastModifiedByUid],
	[QRDAMeasure],
	[TopicIndicator],
	[NQFNumber],
	[DataElementName],
	[Modifier],
	[EndDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[InterfaceDataMapping]') AND name = N'ix_InterfaceDataMapping_Rootid_PRMCode')
CREATE NONCLUSTERED INDEX [ix_InterfaceDataMapping_Rootid_PRMCode] ON [dbo].[InterfaceDataMapping]
(
	[Rootid] ASC,
	[PRMCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[JobHistory]') AND name = N'IX_DateStarted_Status')
CREATE NONCLUSTERED INDEX [IX_DateStarted_Status] ON [dbo].[JobHistory]
(
	[DateStarted] ASC,
	[Status] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[JobHistory]') AND name = N'IX_JobHistory_DateStarted')
CREATE NONCLUSTERED INDEX [IX_JobHistory_DateStarted] ON [dbo].[JobHistory]
(
	[DateStarted] DESC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[JobHistory]') AND name = N'IX_JobHistory_NeedNotification')
CREATE NONCLUSTERED INDEX [IX_JobHistory_NeedNotification] ON [dbo].[JobHistory]
(
	[NeedNotification] DESC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[JobHistory]') AND name = N'IX_JobHistory_Status')
CREATE NONCLUSTERED INDEX [IX_JobHistory_Status] ON [dbo].[JobHistory]
(
	[Status] DESC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[JobHistory]') AND name = N'IX_JobSchedule')
CREATE NONCLUSTERED INDEX [IX_JobSchedule] ON [dbo].[JobHistory]
(
	[JobScheduleUid] ASC
)
INCLUDE ( 	[DateEnded]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[JobHistory]') AND name = N'IX_JobSchedule_LastModifiedDate')
CREATE NONCLUSTERED INDEX [IX_JobSchedule_LastModifiedDate] ON [dbo].[JobHistory]
(
	[JobScheduleUid] ASC,
	[LastModifiedDate] ASC
)
INCLUDE ( 	[JobHistoryUid],
	[DateStarted],
	[DateEnded],
	[Status],
	[NeedNotification]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[JobHistory]') AND name = N'IX_JobScheduleUid_Status_inc')
CREATE NONCLUSTERED INDEX [IX_JobScheduleUid_Status_inc] ON [dbo].[JobHistory]
(
	[JobScheduleUid] ASC,
	[Status] ASC
)
INCLUDE ( 	[DateStarted]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[JobSchedule]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[JobSchedule]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[JobSchedule]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[JobSchedule]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[LaboratoryLocation]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[LaboratoryLocation]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[LaboratoryLocation]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[LaboratoryLocation]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListAccountType]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListAccountType]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListAccountType]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListAccountType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListAddIn]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListAddIn]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListAddIn]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListAddIn]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListAddInType]') AND name = N'IX_ListAddInType')
CREATE NONCLUSTERED INDEX [IX_ListAddInType] ON [dbo].[ListAddInType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListAdmissionSource]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListAdmissionSource]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListAdmissionType]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListAdmissionType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListAgeGroup]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListAgeGroup]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListAgeGroup]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListAgeGroup]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListAnswer]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListAnswer]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListAnswer]') AND name = N'IX_ListAnswer')
CREATE NONCLUSTERED INDEX [IX_ListAnswer] ON [dbo].[ListAnswer]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListAnswerGroup]') AND name = N'IX_AnswerGroup_AnswerGroupUid')
CREATE NONCLUSTERED INDEX [IX_AnswerGroup_AnswerGroupUid] ON [dbo].[ListAnswerGroup]
(
	[AnswerGroupUid] ASC
)
INCLUDE ( 	[ExternalID],
	[Name],
	[UserDefined],
	[Inactive],
	[UseDiseases]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListAnswerGroup]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListAnswerGroup]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListAnswerGroup]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListAnswerGroup]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListAppointmentStatus]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListAppointmentStatus]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListAppointmentStatus]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListAppointmentStatus]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListAppointmentStatusType]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListAppointmentStatusType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListAppointmentType]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListAppointmentType]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListAppointmentType]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListAppointmentType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListAssignmentOfBenefits]') AND name = N'IX_ANSICode')
CREATE NONCLUSTERED INDEX [IX_ANSICode] ON [dbo].[ListAssignmentOfBenefits]
(
	[ANSICode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListAssignmentOfBenefits]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListAssignmentOfBenefits]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListAssignmentOfBenefits]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListAssignmentOfBenefits]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListAttachmentHandler]') AND name = N'IX_FileExtension')
CREATE NONCLUSTERED INDEX [IX_FileExtension] ON [dbo].[ListAttachmentHandler]
(
	[FileNameWildcard] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListAttachmentHandler]') AND name = N'IX_Inactive')
CREATE NONCLUSTERED INDEX [IX_Inactive] ON [dbo].[ListAttachmentHandler]
(
	[Inactive] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListAttachmentHandler]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListAttachmentHandler]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListAttachmentType]') AND name = N'IDX_AttachmentTypeUid_Name_DisplayTypeID')
CREATE NONCLUSTERED INDEX [IDX_AttachmentTypeUid_Name_DisplayTypeID] ON [dbo].[ListAttachmentType]
(
	[AttachmentTypeUid] ASC
)
INCLUDE ( 	[Name],
	[DisplayTypeID]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListAttachmentType]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListAttachmentType]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListAttachmentType]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListAttachmentType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListBillTimeRule]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListBillTimeRule]
(
	[BillTimeRuleUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListBillTimeRule]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListBillTimeRule]
(
	[BillTimeRuleUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListBloodPressureMethods]') AND name = N'IX_ANSICode')
CREATE NONCLUSTERED INDEX [IX_ANSICode] ON [dbo].[ListBloodPressureMethods]
(
	[ANSICode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListBloodPressureMethods]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListBloodPressureMethods]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListBloodPressureMethods]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListBloodPressureMethods]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCacheMachine]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListCacheMachine]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCacheMachine]') AND name = N'IX_ListCacheMachine_URL')
CREATE UNIQUE NONCLUSTERED INDEX [IX_ListCacheMachine_URL] ON [dbo].[ListCacheMachine]
(
	[URL] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCacheMachine]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListCacheMachine]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCalendar]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListCalendar]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCalendar]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListCalendar]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCalendarTemplateHead]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListCalendarTemplateHead]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCalendarTemplateHead]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListCalendarTemplateHead]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCaseAuthorizationCodeSet]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListCaseAuthorizationCodeSet]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCaseAuthorizationCodeSet]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListCaseAuthorizationCodeSet]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCaseModule]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListCaseModule]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCaseModule]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListCaseModule]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCasePhase]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListCasePhase]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCasePhase]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListCasePhase]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCaseType]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListCaseType]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCaseType]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListCaseType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCaseTypeModule]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListCaseTypeModule]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCaseTypeModule]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListCaseTypeModule]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCaseTypePhase]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListCaseTypePhase]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCaseTypePhase]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListCaseTypePhase]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListChargeTicketDiagnosis]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListChargeTicketDiagnosis]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListChargeTicketDiagnosis]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListChargeTicketDiagnosis]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListChargeTicketSO]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListChargeTicketSO]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListChargeTicketSO]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListChargeTicketSO]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListChargeTicketSP]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListChargeTicketSP]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListChargeTicketSP]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListChargeTicketSP]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListClaimBatchStatus]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListClaimBatchStatus]
(
	[ExternalId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListClaimBatchStatus]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListClaimBatchStatus]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListClaimClearingHouse]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListClaimClearingHouse]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListClaimClearingHouse]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListClaimClearingHouse]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListClaimFormat]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListClaimFormat]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListClaimFormat]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListClaimFormat]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListClaimFormatOptionType]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListClaimFormatOptionType]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListClaimFormatOptionType]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListClaimFormatOptionType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListClaimFormatType]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListClaimFormatType]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListClaimFormatType]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListClaimFormatType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListClaimFormatType]') AND name = N'IXU_ListClaimFormatType_ItemCode')
ALTER TABLE [dbo].[ListClaimFormatType] ADD  CONSTRAINT [IXU_ListClaimFormatType_ItemCode] UNIQUE NONCLUSTERED 
(
	[Tag] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListClaimFormatValueType]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListClaimFormatValueType]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListClaimFormatValueType]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListClaimFormatValueType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListClaimFormatValueTypeType]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListClaimFormatValueTypeType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListClaimFormLayout]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListClaimFormLayout]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListClaimFormLayout]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListClaimFormLayout]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListClaimHeaderNoteCode]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListClaimHeaderNoteCode]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListClaimReportStatus]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListClaimReportStatus]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListClaimReportStatus]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListClaimReportStatus]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListClientMachine]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListClientMachine]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListClientMachine]') AND name = N'IX_URL')
CREATE UNIQUE NONCLUSTERED INDEX [IX_URL] ON [dbo].[ListClientMachine]
(
	[URL] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListClientMachine]') AND name = N'IX_URL_Inactive')
CREATE NONCLUSTERED INDEX [IX_URL_Inactive] ON [dbo].[ListClientMachine]
(
	[URL] ASC,
	[Inactive] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListClinicalNoteType]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListClinicalNoteType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListClinicCenter]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListClinicCenter]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListClinicCenter]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListClinicCenter]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCodeValidationCarrierMap]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListCodeValidationCarrierMap]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCollectionStatus]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListCollectionStatus]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCollectionStatus]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListCollectionStatus]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCompression]') AND name = N'IX_Compression_Name')
CREATE NONCLUSTERED INDEX [IX_Compression_Name] ON [dbo].[ListCompression]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListConditionCode]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListConditionCode]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListConsentForm]') AND name = N'IX_Name')
CREATE UNIQUE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListConsentForm]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListContextReportType]') AND name = N'IX_ListContextReportType_Name')
CREATE NONCLUSTERED INDEX [IX_ListContextReportType_Name] ON [dbo].[ListContextReportType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListContractTypeCode]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListContractTypeCode]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListControlType]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListControlType]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListControlType]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListControlType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCoverageType]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListCoverageType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCP_CarePlan]') AND name = N'IX_ListCarePlan')
CREATE NONCLUSTERED INDEX [IX_ListCarePlan] ON [dbo].[ListCP_CarePlan]
(
	[Name] ASC,
	[CP_CarePlanUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCP_Goal]') AND name = N'IX_ListGoal')
CREATE NONCLUSTERED INDEX [IX_ListGoal] ON [dbo].[ListCP_Goal]
(
	[Name] ASC,
	[CP_GoalUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCpp]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListCpp]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCpp]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListCpp]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCpp]') AND name = N'IX_Type')
CREATE NONCLUSTERED INDEX [IX_Type] ON [dbo].[ListCpp]
(
	[Type] ASC
)
INCLUDE ( 	[CppUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCppGroup]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListCppGroup]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCppGroup]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListCppGroup]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCreditCard]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListCreditCard]
(
	[ExternalId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCreditCard]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListCreditCard]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCreditType]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListCreditType]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCreditType]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListCreditType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCustomNotePrint]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListCustomNotePrint]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListCustomNotePrint]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListCustomNotePrint]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListDecileCQM]') AND name = N'IDX_ListDecile_CQM_Measure_ID')
CREATE NONCLUSTERED INDEX [IDX_ListDecile_CQM_Measure_ID] ON [dbo].[ListDecileCQM]
(
	[Measure_ID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListDecileCQM]') AND name = N'idx_ListDecileCQM_CQMUID')
CREATE NONCLUSTERED INDEX [idx_ListDecileCQM_CQMUID] ON [dbo].[ListDecileCQM]
(
	[CQMUID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListDelayReason]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListDelayReason]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListDepartment]') AND name = N'IX_ANSICode')
CREATE NONCLUSTERED INDEX [IX_ANSICode] ON [dbo].[ListDepartment]
(
	[ANSICode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListDepartment]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListDepartment]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListDepartment]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListDepartment]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListDepositMacro]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListDepositMacro]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListDepositMacro]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListDepositMacro]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListDiagnosis]') AND name = N'Inactive_Diagnosis')
CREATE NONCLUSTERED INDEX [Inactive_Diagnosis] ON [dbo].[ListDiagnosis]
(
	[Inactive] ASC,
	[DiagnosisUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListDiagnosis]') AND name = N'IX_Diagnosis_SnomedConceptID')
CREATE NONCLUSTERED INDEX [IX_Diagnosis_SnomedConceptID] ON [dbo].[ListDiagnosis]
(
	[SnomedConceptID] ASC
)
INCLUDE ( 	[DiagnosisUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListDiagnosis]') AND name = N'IX_DiagnosisCode10')
CREATE NONCLUSTERED INDEX [IX_DiagnosisCode10] ON [dbo].[ListDiagnosis]
(
	[DiagnosisCode10] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListDiagnosis]') AND name = N'IX_DiagnosisCode9')
CREATE NONCLUSTERED INDEX [IX_DiagnosisCode9] ON [dbo].[ListDiagnosis]
(
	[DiagnosisCode9] ASC
)
INCLUDE ( 	[DiagnosisCode10],
	[ShortDescription]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListDiagnosis]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListDiagnosis]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListDiagnosis]') AND name = N'IX_LastModifiedDate')
CREATE NONCLUSTERED INDEX [IX_LastModifiedDate] ON [dbo].[ListDiagnosis]
(
	[LastModifiedDate] ASC
)
INCLUDE ( 	[DiagnosisUid],
	[DiagnosisCode9],
	[DiagnosisCode10]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListDiagnosis]') AND name = N'IX_MasterDiagnosis')
CREATE NONCLUSTERED INDEX [IX_MasterDiagnosis] ON [dbo].[ListDiagnosis]
(
	[MasterDiagnosisUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListDiagnosis]') AND name = N'IX_ShortDescription')
CREATE NONCLUSTERED INDEX [IX_ShortDescription] ON [dbo].[ListDiagnosis]
(
	[ShortDescription] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListDiagnosisCategory]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListDiagnosisCategory]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListDiagnosisCategory]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListDiagnosisCategory]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListDiagnosisPanel]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListDiagnosisPanel]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListDiagnosisPanel]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListDiagnosisPanel]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListDiet]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListDiet]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListDiet]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListDiet]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListDiscontinueReason]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListDiscontinueReason]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListDisease]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListDisease]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListDisease]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListDisease]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListDiseaseGroup]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListDiseaseGroup]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListDiseaseGroup]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListDiseaseGroup]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListDominantHand]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListDominantHand]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListDominantHand]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListDominantHand]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListDpnGroup]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListDpnGroup]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListDpnGroup]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListDpnGroup]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListDpnNode]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListDpnNode]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListDpnNode]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListDpnNode]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListEduForm]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListEduForm]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListEduForm]') AND name = N'IX_ListEduForm_AttachmentUid')
CREATE NONCLUSTERED INDEX [IX_ListEduForm_AttachmentUid] ON [dbo].[ListEduForm]
(
	[AttachmentUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListEduForm]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListEduForm]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListEduFormAssociation]') AND name = N'IX_EFA_Name')
CREATE NONCLUSTERED INDEX [IX_EFA_Name] ON [dbo].[ListEduFormAssociation]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListElectronicPayer]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListElectronicPayer]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListElectronicPayer]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListElectronicPayer]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListEmergencyIndicator]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListEmergencyIndicator]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListEmploymentStatus]') AND name = N'IX_ANSICode')
CREATE NONCLUSTERED INDEX [IX_ANSICode] ON [dbo].[ListEmploymentStatus]
(
	[ANSICode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListEmploymentStatus]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListEmploymentStatus]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListEmploymentStatus]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListEmploymentStatus]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListEPSDTReferralCondIndicator]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListEPSDTReferralCondIndicator]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListERACode]') AND name = N'IX_Code')
CREATE NONCLUSTERED INDEX [IX_Code] ON [dbo].[ListERACode]
(
	[Code] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListERACode]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListERACode]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListeRxIdentificationQualifier]') AND name = N'IX_ListeRxIdentificationQualifier')
CREATE NONCLUSTERED INDEX [IX_ListeRxIdentificationQualifier] ON [dbo].[ListeRxIdentificationQualifier]
(
	[Code] ASC,
	[CodeName] ASC,
	[XMLTag] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListeRxMessageDenyReason]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListeRxMessageDenyReason]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListeRxMessageDenyReason]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListeRxMessageDenyReason]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListeRxMessageType]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListeRxMessageType]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListeRxMessageType]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListeRxMessageType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListeRxStatus]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListeRxStatus]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListEthnicity]') AND name = N'IX_ANSICode')
CREATE NONCLUSTERED INDEX [IX_ANSICode] ON [dbo].[ListEthnicity]
(
	[ANSICode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListEthnicity]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListEthnicity]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListEthnicity]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListEthnicity]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListExercise]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListExercise]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListExercise]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListExercise]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListFilter]') AND name = N'IDX_ListFilter_JobScheduleUid')
CREATE NONCLUSTERED INDEX [IDX_ListFilter_JobScheduleUid] ON [dbo].[ListFilter]
(
	[JobScheduleUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListFilter]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListFilter]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListFilter]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListFilter]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListFindTable]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListFindTable]
(
	[ExternalId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListFindTable]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListFindTable]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListFormattingTemplate]') AND name = N'IDX_RootObjectType')
CREATE NONCLUSTERED INDEX [IDX_RootObjectType] ON [dbo].[ListFormattingTemplate]
(
	[RootObjectType] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListFormLayout]') AND name = N'IX_ListFormLayout')
CREATE NONCLUSTERED INDEX [IX_ListFormLayout] ON [dbo].[ListFormLayout]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListFormTemplateType]') AND name = N'IX_ANSICode')
CREATE NONCLUSTERED INDEX [IX_ANSICode] ON [dbo].[ListFormTemplateType]
(
	[ANSICode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListFormTemplateType]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListFormTemplateType]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListFormTemplateType]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListFormTemplateType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListGender]') AND name = N'IX_ANSICode')
CREATE NONCLUSTERED INDEX [IX_ANSICode] ON [dbo].[ListGender]
(
	[ANSICode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListGender]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListGender]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListGender]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListGender]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListGenderIdentity]') AND name = N'IX_ANSICode')
CREATE NONCLUSTERED INDEX [IX_ANSICode] ON [dbo].[ListGenderIdentity]
(
	[ANSICode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListGenderIdentity]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListGenderIdentity]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListGenderIdentity]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListGenderIdentity]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListGeneralNote]') AND name = N'IX_GeneralNoteTypeUid_Inactive')
CREATE NONCLUSTERED INDEX [IX_GeneralNoteTypeUid_Inactive] ON [dbo].[ListGeneralNote]
(
	[GeneralNoteTypeUid] ASC,
	[Inactive] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListGeneralNote]') AND name = N'IX_ListGeneralNote')
CREATE NONCLUSTERED INDEX [IX_ListGeneralNote] ON [dbo].[ListGeneralNote]
(
	[Name] ASC,
	[Inactive] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListGeneralNoteType]') AND name = N'IX_Name_Inactive')
CREATE NONCLUSTERED INDEX [IX_Name_Inactive] ON [dbo].[ListGeneralNoteType]
(
	[Name] ASC,
	[Inactive] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListGraphicNote]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListGraphicNote]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListGraphicNote]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListGraphicNote]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListGrowthChart]') AND name = N'IX_ListGrowthChart_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ListGrowthChart_ExternalID] ON [dbo].[ListGrowthChart]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListGrowthChart]') AND name = N'IX_ListGrowthChart_Name')
CREATE NONCLUSTERED INDEX [IX_ListGrowthChart_Name] ON [dbo].[ListGrowthChart]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListHIPAAReleaseInfo]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListHIPAAReleaseInfo]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListHistoryGroup]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListHistoryGroup]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListHistoryGroup]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListHistoryGroup]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListHMRule]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListHMRule]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListHMRule]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListHMRule]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListHpi]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListHpi]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListHpi]') AND name = N'IX_Hpi')
CREATE NONCLUSTERED INDEX [IX_Hpi] ON [dbo].[ListHpi]
(
	[HpiUid] ASC
)
INCLUDE ( 	[Inactive],
	[Name]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListHpi]') AND name = N'IX_Inactive_Hpi')
CREATE NONCLUSTERED INDEX [IX_Inactive_Hpi] ON [dbo].[ListHpi]
(
	[Inactive] ASC,
	[HpiUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListHpi]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListHpi]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListHpiCategory]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListHpiCategory]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListHpiCategory]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListHpiCategory]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListHpiCategoryType]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListHpiCategoryType]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListHpiCategoryType]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListHpiCategoryType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListInterfaceBusinessObject]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListInterfaceBusinessObject]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListInterfaceBusinessObject]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListInterfaceBusinessObject]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListJob]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListJob]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListJob]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListJob]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListJobScheduleTimeBase]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListJobScheduleTimeBase]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListJobScheduleTimeBase]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListJobScheduleTimeBase]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListLaboratory]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListLaboratory]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListLaboratory]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListLaboratory]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListLabSource]') AND name = N'IX_ANSICode')
CREATE NONCLUSTERED INDEX [IX_ANSICode] ON [dbo].[ListLabSource]
(
	[ANSICode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListLabSource]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListLabSource]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListLabSource]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListLabSource]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListLanguage]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListLanguage]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListLanguage]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListLanguage]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListLetter]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListLetter]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListLetter]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListLetter]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListLetterModel]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListLetterModel]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListLetterModel]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListLetterModel]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListLOINC]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListLOINC]
(
	[Name] ASC
)
INCLUDE ( 	[CLASS],
	[COMPONENT],
	[RelatedNames2],
	[SYSTEM]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListMaritalStatus]') AND name = N'IX_ANSICode')
CREATE NONCLUSTERED INDEX [IX_ANSICode] ON [dbo].[ListMaritalStatus]
(
	[ANSICode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListMaritalStatus]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListMaritalStatus]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListMaritalStatus]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListMaritalStatus]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListMedicalServicesType]') AND name = N'IX_ListMedicalServicesType_MedicalServicesTypeUid_Name')
CREATE NONCLUSTERED INDEX [IX_ListMedicalServicesType_MedicalServicesTypeUid_Name] ON [dbo].[ListMedicalServicesType]
(
	[MedicalServicesTypeUid] ASC,
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListMedication]') AND name = N'IX_ListMedication_MEDID')
CREATE UNIQUE NONCLUSTERED INDEX [IX_ListMedication_MEDID] ON [dbo].[ListMedication]
(
	[medid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListMedicationAction]') AND name = N'IX_ListMedicationAction_Name')
CREATE NONCLUSTERED INDEX [IX_ListMedicationAction_Name] ON [dbo].[ListMedicationAction]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListMedicationFrequency]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListMedicationFrequency]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListMedicationFrequency]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListMedicationFrequency]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListMedicationRoute]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListMedicationRoute]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListMedicationRoute]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListMedicationRoute]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListMedicationStateScheduled]') AND name = N'IX_ListMedicationStateScheduled_StateSchedule')
ALTER TABLE [dbo].[ListMedicationStateScheduled] ADD  CONSTRAINT [IX_ListMedicationStateScheduled_StateSchedule] UNIQUE NONCLUSTERED 
(
	[State] ASC,
	[Schedule] ASC,
	[MedicationStateScheduledUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListMedicationStatus]') AND name = N'IX_ANSICode')
CREATE NONCLUSTERED INDEX [IX_ANSICode] ON [dbo].[ListMedicationStatus]
(
	[ANSICode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListMedicationStatus]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListMedicationStatus]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListMedicationStatus]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListMedicationStatus]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListMedicationUnit]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListMedicationUnit]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListMedicationUnit]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListMedicationUnit]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListMessageRouting]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListMessageRouting]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListMessageRouting]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListMessageRouting]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListMessageStatus]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListMessageStatus]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListMessageStatus]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListMessageStatus]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListMessageSubType]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListMessageSubType]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListMessageSubType]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListMessageSubType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListMessageType]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListMessageType]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListMessageType]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListMessageType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListMessageUrgency]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListMessageUrgency]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListMessageUrgency]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListMessageUrgency]
(
	[Name] ASC
)
INCLUDE ( 	[MessageUrgencyUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListMisc]') AND name = N'IDX_ListMisc_ListType_Val_DisplayOrder')
CREATE NONCLUSTERED INDEX [IDX_ListMisc_ListType_Val_DisplayOrder] ON [dbo].[ListMisc]
(
	[ListType] ASC
)
INCLUDE ( 	[Val],
	[DisplayOrder]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListMisc]') AND name = N'IX_ListType')
CREATE NONCLUSTERED INDEX [IX_ListType] ON [dbo].[ListMisc]
(
	[ListType] ASC
)
INCLUDE ( 	[MiscUid],
	[Name],
	[Val],
	[DisplayOrder],
	[LastModifiedByUid],
	[LastModifiedDate],
	[UserDefined]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListMisc]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListMisc]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListNCPDPReasonCode]') AND name = N'IX_ListNCPDPReasonCode')
CREATE UNIQUE NONCLUSTERED INDEX [IX_ListNCPDPReasonCode] ON [dbo].[ListNCPDPReasonCode]
(
	[Code] ASC,
	[ReasonCodeHierarchy] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListNoteFilter]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListNoteFilter]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListNoteFilter]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListNoteFilter]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListObservation]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListObservation]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListObservation]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListObservation]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListObservation]') AND name = N'IX_ObservationType')
CREATE NONCLUSTERED INDEX [IX_ObservationType] ON [dbo].[ListObservation]
(
	[ObservationTypeID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListObservationGroup]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListObservationGroup]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListObservationGroup]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListObservationGroup]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListObservationItem]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListObservationItem]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListObservationItem]') AND name = N'IX_ExternalID_Name')
CREATE NONCLUSTERED INDEX [IX_ExternalID_Name] ON [dbo].[ListObservationItem]
(
	[ExternalID] ASC,
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListObservationItem]') AND name = N'ix_ListObservationItem_LOINCUid')
CREATE NONCLUSTERED INDEX [ix_ListObservationItem_LOINCUid] ON [dbo].[ListObservationItem]
(
	[LOINCUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListObservationItem]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListObservationItem]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListObservationOrderResultStatus]') AND name = N'IX_ListObservationOrderResultStatus')
CREATE NONCLUSTERED INDEX [IX_ListObservationOrderResultStatus] ON [dbo].[ListObservationOrderResultStatus]
(
	[ResultStatusID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListObservationViewOption]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListObservationViewOption]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListObservationViewOption]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListObservationViewOption]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListOccurrenceCode]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListOccurrenceCode]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListOptionType]') AND name = N'IX_ANSICode')
CREATE NONCLUSTERED INDEX [IX_ANSICode] ON [dbo].[ListOptionType]
(
	[ANSICode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListOptionType]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListOptionType]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListOptionType]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListOptionType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPatientCenter]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListPatientCenter]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPatientCenter]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListPatientCenter]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPatientClass]') AND name = N'IX_ANSICode')
CREATE NONCLUSTERED INDEX [IX_ANSICode] ON [dbo].[ListPatientClass]
(
	[ANSICode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPatientClass]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListPatientClass]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPatientClass]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListPatientClass]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPatientCommunicationType]') AND name = N'IX_ListPatientCommunicationType')
CREATE NONCLUSTERED INDEX [IX_ListPatientCommunicationType] ON [dbo].[ListPatientCommunicationType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPatientCondition]') AND name = N'IX_Name')
CREATE UNIQUE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListPatientCondition]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPatientProgram]') AND name = N'IX_ListPatientProgram')
CREATE UNIQUE NONCLUSTERED INDEX [IX_ListPatientProgram] ON [dbo].[ListPatientProgram]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPatientStatus]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListPatientStatus]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPatientStatus]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListPatientStatus]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPatientStatusUB]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListPatientStatusUB]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPaymentType]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListPaymentType]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPaymentType]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListPaymentType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPEDescription]') AND name = N'Inactive_PEDescription')
CREATE NONCLUSTERED INDEX [Inactive_PEDescription] ON [dbo].[ListPEDescription]
(
	[Inactive] ASC,
	[PEDescriptionUid] ASC
)
INCLUDE ( 	[Name]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPEDescription]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListPEDescription]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPEDescription]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListPEDescription]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPEDescription]') AND name = N'IX_PEDescription')
CREATE NONCLUSTERED INDEX [IX_PEDescription] ON [dbo].[ListPEDescription]
(
	[PEDescriptionUid] ASC
)
INCLUDE ( 	[Inactive],
	[Name]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPEParentSystem]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListPEParentSystem]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPEParentSystem]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListPEParentSystem]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPESymptom]') AND name = N'Inactive_PESymptomUid')
CREATE NONCLUSTERED INDEX [Inactive_PESymptomUid] ON [dbo].[ListPESymptom]
(
	[Name] ASC,
	[PESymptomUid] ASC
)
INCLUDE ( 	[Inactive]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPESymptom]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListPESymptom]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPESymptom]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListPESymptom]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPESymptom]') AND name = N'IX_PESymptom')
CREATE NONCLUSTERED INDEX [IX_PESymptom] ON [dbo].[ListPESymptom]
(
	[PESymptomUid] ASC
)
INCLUDE ( 	[Inactive],
	[Name]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPESystem]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListPESystem]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPESystem]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListPESystem]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPETemplate]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListPETemplate]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPETemplate]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListPETemplate]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPharmacy]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListPharmacy]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPharmacy]') AND name = N'IX_MasterPharmacy')
CREATE NONCLUSTERED INDEX [IX_MasterPharmacy] ON [dbo].[ListPharmacy]
(
	[MasterPharmacyUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPharmacy]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListPharmacy]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPharmacy]') AND name = N'IXR_PharmacyUidW')
CREATE NONCLUSTERED INDEX [IXR_PharmacyUidW] ON [dbo].[ListPharmacy]
(
	[PharmacyUid] ASC
)
INCLUDE ( 	[Name]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPharmacyClearinghouse]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListPharmacyClearinghouse]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPharmacyClearinghouse]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListPharmacyClearinghouse]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPhoneType]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListPhoneType]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPhoneType]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListPhoneType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPrintSet]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListPrintSet]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPrintSet]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListPrintSet]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPrivacyPolicyAcceptance]') AND name = N'IX_ANSICode')
CREATE NONCLUSTERED INDEX [IX_ANSICode] ON [dbo].[ListPrivacyPolicyAcceptance]
(
	[ANSICode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPrivacyPolicyAcceptance]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListPrivacyPolicyAcceptance]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPrivacyPolicyAcceptance]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListPrivacyPolicyAcceptance]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPrmAction]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListPrmAction]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPrmAction]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListPrmAction]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPrmCondition]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListPrmCondition]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPrmCondition]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListPrmCondition]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPrmRule]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListPrmRule]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPrmRule]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListPrmRule]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPrmRuleGroup]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListPrmRuleGroup]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPrmRuleGroup]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListPrmRuleGroup]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPrmRuleLevel]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListPrmRuleLevel]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListPrmRuleLevel]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListPrmRuleLevel]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListProcedure]') AND name = N'IX_Code')
CREATE NONCLUSTERED INDEX [IX_Code] ON [dbo].[ListProcedure]
(
	[Code] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListProcedure]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListProcedure]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListProcedure]') AND name = N'IX_FDB_MEDID')
CREATE NONCLUSTERED INDEX [IX_FDB_MEDID] ON [dbo].[ListProcedure]
(
	[FDB_MEDID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListProcedure]') AND name = N'IX_LastModifiedDate')
CREATE NONCLUSTERED INDEX [IX_LastModifiedDate] ON [dbo].[ListProcedure]
(
	[LastModifiedDate] ASC
)
INCLUDE ( 	[ProcedureUid],
	[Code]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListProcedure]') AND name = N'IX_MasterProcedure')
CREATE NONCLUSTERED INDEX [IX_MasterProcedure] ON [dbo].[ListProcedure]
(
	[MasterProcedureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListProcedure]') AND name = N'IX_MProc_UserDefined')
CREATE NONCLUSTERED INDEX [IX_MProc_UserDefined] ON [dbo].[ListProcedure]
(
	[MasterProcedureUid] ASC,
	[UserDefined] ASC
)
INCLUDE ( 	[ProcedureUid],
	[Code]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListProcedure]') AND name = N'IX_ShortDescription')
CREATE NONCLUSTERED INDEX [IX_ShortDescription] ON [dbo].[ListProcedure]
(
	[ShortDescription] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListProcedureCategory]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListProcedureCategory]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListProcedureCategory]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListProcedureCategory]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListProcedureCodeType]') AND name = N'IX_ANSICode')
CREATE NONCLUSTERED INDEX [IX_ANSICode] ON [dbo].[ListProcedureCodeType]
(
	[ANSICode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListProcedureCodeType]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListProcedureCodeType]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListProcedureCodeType]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListProcedureCodeType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListProcedureGroup]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListProcedureGroup]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListProcedureGroup]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListProcedureGroup]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListProcedureModifier]') AND name = N'IX_ANSICode')
CREATE NONCLUSTERED INDEX [IX_ANSICode] ON [dbo].[ListProcedureModifier]
(
	[ANSICode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListProcedureModifier]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListProcedureModifier]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListProcedureModifier]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListProcedureModifier]
(
	[LongDescription] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListProcedurePanel]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListProcedurePanel]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListProcedurePanel]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListProcedurePanel]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListProcedureServiceType]') AND name = N'IX_ANSICode')
CREATE NONCLUSTERED INDEX [IX_ANSICode] ON [dbo].[ListProcedureServiceType]
(
	[ANSICode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListProcedureServiceType]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListProcedureServiceType]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListProcedureServiceType]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListProcedureServiceType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListProviderCareType]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListProviderCareType]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListProviderCareType]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListProviderCareType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListQuestion]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListQuestion]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListQuestion]') AND name = N'IX_HistoryGroup_Inactive')
CREATE NONCLUSTERED INDEX [IX_HistoryGroup_Inactive] ON [dbo].[ListQuestion]
(
	[HistoryGroupUid] ASC,
	[Inactive] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListQuestion]') AND name = N'IX_HistoryGroupUid_AnswerGroupUid_Inactive')
CREATE NONCLUSTERED INDEX [IX_HistoryGroupUid_AnswerGroupUid_Inactive] ON [dbo].[ListQuestion]
(
	[HistoryGroupUid] ASC,
	[AnswerGroupUid] ASC,
	[Inactive] ASC
)
INCLUDE ( 	[QuestionUid],
	[DiseaseUid],
	[ExternalID],
	[Name],
	[UserDefined],
	[Header],
	[Colwidth],
	[AllowMultiple],
	[RequiresAnswer],
	[SelectionTypeID],
	[DisplayOrder],
	[FDB_HIC_SEQN],
	[Notes],
	[ClinicCenterOverride],
	[ProviderOverride],
	[FDBIDType],
	[UNII],
	[SnomedConceptID],
	[DescriptionUid],
	[HL7Code],
	[LOINCUid],
	[LastModifiedByUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListQuestion]') AND name = N'IX_HistoryGroupUid_Inactive')
CREATE NONCLUSTERED INDEX [IX_HistoryGroupUid_Inactive] ON [dbo].[ListQuestion]
(
	[HistoryGroupUid] ASC,
	[Inactive] ASC
)
INCLUDE ( 	[QuestionUid],
	[AnswerGroupUid],
	[DiseaseUid],
	[ExternalID],
	[Name],
	[UserDefined],
	[Header],
	[Colwidth],
	[AllowMultiple],
	[RequiresAnswer],
	[SelectionTypeID],
	[DisplayOrder],
	[FDB_HIC_SEQN],
	[Notes],
	[ClinicCenterOverride],
	[ProviderOverride],
	[FDBIDType],
	[UNII],
	[SnomedConceptID],
	[DescriptionUid],
	[HL7Code],
	[LOINCUid],
	[LastModifiedByUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListQuestion]') AND name = N'IX_HistoryGroupUid_QuestionUid_AnswerGroupUid')
CREATE NONCLUSTERED INDEX [IX_HistoryGroupUid_QuestionUid_AnswerGroupUid] ON [dbo].[ListQuestion]
(
	[HistoryGroupUid] ASC,
	[QuestionUid] ASC,
	[AnswerGroupUid] ASC
)
INCLUDE ( 	[ExternalID],
	[Inactive],
	[Name],
	[UserDefined],
	[Header],
	[Colwidth],
	[AllowMultiple],
	[DisplayOrder],
	[FDB_HIC_SEQN],
	[FDBIDType]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListQuestion]') AND name = N'IX_ListQuestion')
CREATE NONCLUSTERED INDEX [IX_ListQuestion] ON [dbo].[ListQuestion]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListQuestion]') AND name = N'IXR_DiseaseUid_InactiveW')
CREATE NONCLUSTERED INDEX [IXR_DiseaseUid_InactiveW] ON [dbo].[ListQuestion]
(
	[QuestionUid] ASC,
	[Inactive] ASC
)
INCLUDE ( 	[DiseaseUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListQuestion]') AND name = N'IXR_HistoryGroupUidW')
CREATE NONCLUSTERED INDEX [IXR_HistoryGroupUidW] ON [dbo].[ListQuestion]
(
	[HistoryGroupUid] ASC
)
INCLUDE ( 	[QuestionUid],
	[AnswerGroupUid],
	[ExternalID],
	[Inactive],
	[Name],
	[UserDefined],
	[Header],
	[Colwidth],
	[AllowMultiple],
	[DisplayOrder],
	[FDB_HIC_SEQN],
	[FDBIDType]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListQuestion]') AND name = N'IXR_InactiveW')
CREATE NONCLUSTERED INDEX [IXR_InactiveW] ON [dbo].[ListQuestion]
(
	[Inactive] ASC
)
INCLUDE ( 	[QuestionUid],
	[DiseaseUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListQuestionCode]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListQuestionCode]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListQuestionCode]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListQuestionCode]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListRace]') AND name = N'IX_ANSICode')
CREATE NONCLUSTERED INDEX [IX_ANSICode] ON [dbo].[ListRace]
(
	[ANSICode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListRace]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListRace]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListRace]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListRace]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListReferralSrc]') AND name = N'IX_ListReferralSrc_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ListReferralSrc_ExternalID] ON [dbo].[ListReferralSrc]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListReferralSrc]') AND name = N'IX_ListReferralSrc_Name')
CREATE NONCLUSTERED INDEX [IX_ListReferralSrc_Name] ON [dbo].[ListReferralSrc]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListReimbursementRule]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListReimbursementRule]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListReimbursementRule]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListReimbursementRule]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListRelatedCause]') AND name = N'IX_ANSICode')
CREATE NONCLUSTERED INDEX [IX_ANSICode] ON [dbo].[ListRelatedCause]
(
	[ANSICode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListRelatedCause]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListRelatedCause]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListRelatedCause]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListRelatedCause]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListRelationship]') AND name = N'IX_ANSICode')
CREATE NONCLUSTERED INDEX [IX_ANSICode] ON [dbo].[ListRelationship]
(
	[ANSICode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListRelationship]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListRelationship]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListRelationship]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListRelationship]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListReplicationUpdateScript]') AND name = N'ix_ListReplicationUpdateScript_CacheMachineUid')
CREATE NONCLUSTERED INDEX [ix_ListReplicationUpdateScript_CacheMachineUid] ON [dbo].[ListReplicationUpdateScript]
(
	[CacheMachineUid] ASC
)
INCLUDE ( 	[ReplicationUpdateScriptUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListReport]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListReport]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListReport]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListReport]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListReportFolder]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListReportFolder]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListReportFolder]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListReportFolder]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListReportRdl]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListReportRdl]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListReportRdl]') AND name = N'IX_ListReportRdl_Name')
CREATE UNIQUE NONCLUSTERED INDEX [IX_ListReportRdl_Name] ON [dbo].[ListReportRdl]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListResidenceType]') AND name = N'IX_ANSICode')
CREATE NONCLUSTERED INDEX [IX_ANSICode] ON [dbo].[ListResidenceType]
(
	[ANSICode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListResidenceType]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListResidenceType]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListResidenceType]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListResidenceType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListScantronPublishedForm]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListScantronPublishedForm]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListScantronPublishedForm]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListScantronPublishedForm]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListScantronSurveyForm]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListScantronSurveyForm]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListScantronSurveyForm]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListScantronSurveyForm]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListScantronSurveyFormFields]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListScantronSurveyFormFields]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListScantronSurveyFormFields]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListScantronSurveyFormFields]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListScrubProfile]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListScrubProfile]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListSecurity]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListSecurity]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListSecurity]') AND name = N'IX_ListSecurity')
CREATE NONCLUSTERED INDEX [IX_ListSecurity] ON [dbo].[ListSecurity]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListSecurityGroup]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListSecurityGroup]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListSecurityGroup]') AND name = N'IX_ListSecurityGroup')
CREATE NONCLUSTERED INDEX [IX_ListSecurityGroup] ON [dbo].[ListSecurityGroup]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListSentMethod]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListSentMethod]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListSentMethod]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListSentMethod]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListServiceAuthorizationException]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListServiceAuthorizationException]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListServiceSite]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListServiceSite]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListServiceSite]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListServiceSite]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListServiceSiteType]') AND name = N'IX_ANSICode')
CREATE NONCLUSTERED INDEX [IX_ANSICode] ON [dbo].[ListServiceSiteType]
(
	[ANSICode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListServiceSiteType]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListServiceSiteType]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListServiceSiteType]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListServiceSiteType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListSignatureSource]') AND name = N'IX_ANSICode')
CREATE NONCLUSTERED INDEX [IX_ANSICode] ON [dbo].[ListSignatureSource]
(
	[ANSICode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListSignatureSource]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListSignatureSource]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListSignatureSource]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListSignatureSource]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListSpecialProgramReason]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListSpecialProgramReason]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListSpecialty]') AND name = N'IX_ANSICode')
CREATE NONCLUSTERED INDEX [IX_ANSICode] ON [dbo].[ListSpecialty]
(
	[ANSICode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListSpecialty]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListSpecialty]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListSpecialty]') AND name = N'IX_ListSpecialty_SpecialtyUid_Name')
CREATE NONCLUSTERED INDEX [IX_ListSpecialty_SpecialtyUid_Name] ON [dbo].[ListSpecialty]
(
	[SpecialtyUid] ASC,
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListSpecialty]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListSpecialty]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListStudentStatus]') AND name = N'IX_ANSICode')
CREATE NONCLUSTERED INDEX [IX_ANSICode] ON [dbo].[ListStudentStatus]
(
	[ANSICode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListStudentStatus]') AND name = N'IX_ExternalId')
CREATE NONCLUSTERED INDEX [IX_ExternalId] ON [dbo].[ListStudentStatus]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListStudentStatus]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListStudentStatus]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 95) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListSuperbillStatus]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListSuperbillStatus]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListSuperbillStatus]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListSuperbillStatus]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListSurvey]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListSurvey]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListSurvey]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListSurvey]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListSurveyAnswer]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListSurveyAnswer]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListSurveyAnswer]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListSurveyAnswer]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListSurveyAnswerGroup]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListSurveyAnswerGroup]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListSurveyAnswerGroup]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListSurveyAnswerGroup]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListSurveyControlType]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListSurveyControlType]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListSurveyControlType]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListSurveyControlType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListSurveyQuestion]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListSurveyQuestion]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListSurveyQuestion]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListSurveyQuestion]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListSurveySection]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListSurveySection]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListSurveySection]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListSurveySection]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListSymptom]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListSymptom]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListSymptom]') AND name = N'IX_Name')
CREATE UNIQUE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListSymptom]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListSystem]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListSystem]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListSystem]') AND name = N'IX_Name')
CREATE UNIQUE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListSystem]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListTimespan]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListTimespan]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListTimespan]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListTimespan]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListTimeType]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListTimeType]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListTimeType]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListTimeType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListTranscriptionStatus]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListTranscriptionStatus]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListTranslationTemplate]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListTranslationTemplate]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListTranslationTemplate]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListTranslationTemplate]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListTypeofVaccine]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListTypeofVaccine]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListTypeofVaccine]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListTypeofVaccine]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListUIConfiguration]') AND name = N'IX_ListUIConfiguration_1')
CREATE NONCLUSTERED INDEX [IX_ListUIConfiguration_1] ON [dbo].[ListUIConfiguration]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListUIControl]') AND name = N'IX_ListUIControl')
CREATE NONCLUSTERED INDEX [IX_ListUIControl] ON [dbo].[ListUIControl]
(
	[UIControlTypeUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListUIControlType]') AND name = N'IX_ListUIControlType')
CREATE UNIQUE NONCLUSTERED INDEX [IX_ListUIControlType] ON [dbo].[ListUIControlType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListUserDefinedControl]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListUserDefinedControl]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListUserDefinedControl]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListUserDefinedControl]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListUserDefinedControl]') AND name = N'IX_UserDefinedControlGroup')
CREATE NONCLUSTERED INDEX [IX_UserDefinedControlGroup] ON [dbo].[ListUserDefinedControl]
(
	[UserDefinedControlGroupUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListUserDefinedControlGroup]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListUserDefinedControlGroup]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListUserDefinedControlGroup]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListUserDefinedControlGroup]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListUserDefinedData]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListUserDefinedData]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListUserDefinedData]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListUserDefinedData]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListUserDefinedFilter]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListUserDefinedFilter]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListUserDefinedFilter]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListUserDefinedFilter]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListUserDefinedTemplate]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListUserDefinedTemplate]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListUserDefinedTemplate]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListUserDefinedTemplate]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListUserGroup]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListUserGroup]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListUserGroup]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListUserGroup]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListUserGroupType]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListUserGroupType]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListUserGroupType]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListUserGroupType]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListUserSetting]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListUserSetting]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListVaccine]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListVaccine]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListVaccine]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListVaccine]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListValueCode]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListValueCode]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListVoiceTag]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListVoiceTag]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListVoiceTag]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListVoiceTag]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListWaitingListPriority]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListWaitingListPriority]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListWaitingListPriority]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListWaitingListPriority]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListWeightConditions]') AND name = N'IX_ANSICode')
CREATE NONCLUSTERED INDEX [IX_ANSICode] ON [dbo].[ListWeightConditions]
(
	[ANSICode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListWeightConditions]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[ListWeightConditions]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ListWeightConditions]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ListWeightConditions]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Lock]') AND name = N'Inst_LockedUid_LockedByUid_LockType_IsLocked')
CREATE NONCLUSTERED INDEX [Inst_LockedUid_LockedByUid_LockType_IsLocked] ON [dbo].[Lock]
(
	[LockInstance] ASC,
	[LockedUid] ASC,
	[LockByUid] ASC,
	[LockType] ASC,
	[IsLocked] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Lock]') AND name = N'IX_Lock')
CREATE NONCLUSTERED INDEX [IX_Lock] ON [dbo].[Lock]
(
	[LockedUid] ASC,
	[LockInstance] ASC,
	[LockDate] ASC
)
INCLUDE ( 	[LockType]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Lock]') AND name = N'ix_Lock_LockDate')
CREATE NONCLUSTERED INDEX [ix_Lock_LockDate] ON [dbo].[Lock]
(
	[LockDate] ASC
)
INCLUDE ( 	[LockInstance],
	[IsLocked]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Lock]') AND name = N'IX_LockInstance')
CREATE NONCLUSTERED INDEX [IX_LockInstance] ON [dbo].[Lock]
(
	[LockInstance] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Lock]') AND name = N'LockDate')
CREATE NONCLUSTERED INDEX [LockDate] ON [dbo].[Lock]
(
	[LockDate] ASC
)
INCLUDE ( 	[LockInstance]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Lock]') AND name = N'LockDate_LockedUid_LockInstance')
CREATE NONCLUSTERED INDEX [LockDate_LockedUid_LockInstance] ON [dbo].[Lock]
(
	[LockDate] ASC,
	[LockInstance] ASC,
	[LockedUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Lock]') AND name = N'LockDate_LockInstance')
CREATE NONCLUSTERED INDEX [LockDate_LockInstance] ON [dbo].[Lock]
(
	[LockInstance] ASC,
	[LockDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Lock]') AND name = N'LockedUid_LockType_IsLocked')
CREATE NONCLUSTERED INDEX [LockedUid_LockType_IsLocked] ON [dbo].[Lock]
(
	[LockedUid] ASC,
	[LockType] ASC,
	[IsLocked] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Lock]') AND name = N'LockInstance_LockedUid_IsLocked_LockType')
CREATE NONCLUSTERED INDEX [LockInstance_LockedUid_IsLocked_LockType] ON [dbo].[Lock]
(
	[LockInstance] ASC,
	[LockedUid] ASC,
	[IsLocked] ASC,
	[LockType] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MaintenanceDrugClass]') AND name = N'IX_MaintenanceDrugClass')
CREATE UNIQUE NONCLUSTERED INDEX [IX_MaintenanceDrugClass] ON [dbo].[MaintenanceDrugClass]
(
	[ProviderUid] ASC,
	[AHFSClassID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MapItem]') AND name = N'IX_FindTableFromItem_SubstitutionText_Inactive')
CREATE NONCLUSTERED INDEX [IX_FindTableFromItem_SubstitutionText_Inactive] ON [dbo].[MapItem]
(
	[FindTableFromItemUid] ASC,
	[SubstitutionText] ASC,
	[Inactive] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MapItem]') AND name = N'IX_MapSource')
CREATE NONCLUSTERED INDEX [IX_MapSource] ON [dbo].[MapItem]
(
	[MapSourceUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MapSource]') AND name = N'IX_MapSource_FindTableFrom_FindTableTo_Inactive')
CREATE NONCLUSTERED INDEX [IX_MapSource_FindTableFrom_FindTableTo_Inactive] ON [dbo].[MapSource]
(
	[MapSourceUid] ASC,
	[FindTableFromUid] ASC,
	[FindTableToUid] ASC,
	[Inactive] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MasterPharmacy]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[MasterPharmacy]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MasterPharmacy]') AND name = N'IX_LastModifiedDate')
CREATE NONCLUSTERED INDEX [IX_LastModifiedDate] ON [dbo].[MasterPharmacy]
(
	[LastModifiedDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MasterPharmacy]') AND name = N'ix_MasterPharmacy_MailOrderEnabled')
CREATE NONCLUSTERED INDEX [ix_MasterPharmacy_MailOrderEnabled] ON [dbo].[MasterPharmacy]
(
	[MailOrderEnabled] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MasterPharmacy]') AND name = N'ix_MasterPharmacy_NPI')
CREATE NONCLUSTERED INDEX [ix_MasterPharmacy_NPI] ON [dbo].[MasterPharmacy]
(
	[NPI] ASC
)
INCLUDE ( 	[MasterPharmacyUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MasterPharmacy]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[MasterPharmacy]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MasterPharmacy]') AND name = N'IX_Pharmacy')
CREATE NONCLUSTERED INDEX [IX_Pharmacy] ON [dbo].[MasterPharmacy]
(
	[PharmacyID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MasterPharmacy]') AND name = N'IX_PharmacyID')
CREATE UNIQUE NONCLUSTERED INDEX [IX_PharmacyID] ON [dbo].[MasterPharmacy]
(
	[PharmacyClearinghouseUid] ASC,
	[PharmacyID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MasterProcedureToLoinc]') AND name = N'IX_LOINC_Inc_CODE_PROCIT_VOCAB_IMO_CODE')
CREATE NONCLUSTERED INDEX [IX_LOINC_Inc_CODE_PROCIT_VOCAB_IMO_CODE] ON [dbo].[MasterProcedureToLoinc]
(
	[LOINC_CODE] ASC
)
INCLUDE ( 	[PROCIT_VOCAB_IMO_CODE]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MasterProcedureToLoinc]') AND name = N'IX_ProcCode')
CREATE NONCLUSTERED INDEX [IX_ProcCode] ON [dbo].[MasterProcedureToLoinc]
(
	[PROCIT_VOCAB_IMO_CODE] ASC
)
INCLUDE ( 	[LOINC_CODE]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MasterReimbursementRule]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[MasterReimbursementRule]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MasterSnomedDescription]') AND name = N'IX_MasterSnomedDescription_ConceptId')
CREATE NONCLUSTERED INDEX [IX_MasterSnomedDescription_ConceptId] ON [dbo].[MasterSnomedDescription]
(
	[conceptId] ASC,
	[term] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MedicalServicesProvider]') AND name = N'IX_MedicalServicesProvider_MedicalServicesTypeUid')
CREATE NONCLUSTERED INDEX [IX_MedicalServicesProvider_MedicalServicesTypeUid] ON [dbo].[MedicalServicesProvider]
(
	[MedicalServicesTypeUid] ASC
)
INCLUDE ( 	[ExternalID],
	[Inactive]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MedicationSIG]') AND name = N'DiscontinueReasonUid_MedicationSIGUid_MEDID_MNID_OverallStartDate_OverallStopDate_RXNORMCode')
CREATE NONCLUSTERED INDEX [DiscontinueReasonUid_MedicationSIGUid_MEDID_MNID_OverallStartDate_OverallStopDate_RXNORMCode] ON [dbo].[MedicationSIG]
(
	[DiscontinueReasonUid] ASC,
	[MedicationSIGUid] ASC,
	[FDB_MEDID] ASC,
	[FDB_MNID] ASC,
	[OverallStartDate] ASC,
	[OverallStopDate] ASC,
	[RXNORMCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MedicationSIG]') AND name = N'IDX_MedicationSIG_VisitUid')
CREATE NONCLUSTERED INDEX [IDX_MedicationSIG_VisitUid] ON [dbo].[MedicationSIG]
(
	[VisitUid] ASC
)
INCLUDE ( 	[MedicationSIGUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MedicationSIG]') AND name = N'IX_DrugScreeningResult')
CREATE NONCLUSTERED INDEX [IX_DrugScreeningResult] ON [dbo].[MedicationSIG]
(
	[MedicationSIGUid] ASC
)
INCLUDE ( 	[DrugScreeningResult]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MedicationSIG]') AND name = N'IX_EDUForm')
CREATE NONCLUSTERED INDEX [IX_EDUForm] ON [dbo].[MedicationSIG]
(
	[EduFormUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MedicationSIG]') AND name = N'IX_FDB_CLASSID')
CREATE NONCLUSTERED INDEX [IX_FDB_CLASSID] ON [dbo].[MedicationSIG]
(
	[FDB_CLASSID] ASC
)
INCLUDE ( 	[MedicationSIGUid],
	[OverallStartDate],
	[OverallStopDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MedicationSIG]') AND name = N'IX_FDB_GCN_SEQNO')
CREATE NONCLUSTERED INDEX [IX_FDB_GCN_SEQNO] ON [dbo].[MedicationSIG]
(
	[FDB_GCN_SEQNO] ASC
)
INCLUDE ( 	[MedicationSIGUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MedicationSIG]') AND name = N'IX_FDB_HIC_SEQN')
CREATE NONCLUSTERED INDEX [IX_FDB_HIC_SEQN] ON [dbo].[MedicationSIG]
(
	[FDB_HIC_SEQN] ASC
)
INCLUDE ( 	[MedicationSIGUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MedicationSIG]') AND name = N'IX_FDB_MEDID')
CREATE NONCLUSTERED INDEX [IX_FDB_MEDID] ON [dbo].[MedicationSIG]
(
	[FDB_MEDID] ASC
)
INCLUDE ( 	[MedicationSIGUid],
	[FederalDEAClassCode]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MedicationSIG]') AND name = N'IX_FDB_MNID')
CREATE NONCLUSTERED INDEX [IX_FDB_MNID] ON [dbo].[MedicationSIG]
(
	[FDB_MNID] ASC
)
INCLUDE ( 	[MedicationSIGUid],
	[OverallStartDate],
	[OverallStopDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MedicationSIG]') AND name = N'IX_FDB_RMID')
CREATE NONCLUSTERED INDEX [IX_FDB_RMID] ON [dbo].[MedicationSIG]
(
	[FDB_RMID] ASC
)
INCLUDE ( 	[MedicationSIGUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MedicationSIG]') AND name = N'ix_MedicationSIG_CreatedDateTime')
CREATE NONCLUSTERED INDEX [ix_MedicationSIG_CreatedDateTime] ON [dbo].[MedicationSIG]
(
	[CreatedDateTime] ASC
)
INCLUDE ( 	[MedicationSIGUid],
	[CreatedBy]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MedicationSIG]') AND name = N'IX_MedicationSig_FDB_ClassID')
CREATE NONCLUSTERED INDEX [IX_MedicationSig_FDB_ClassID] ON [dbo].[MedicationSIG]
(
	[MedicationSIGUid] ASC,
	[FDB_CLASSID] ASC
)
INCLUDE ( 	[OverallStartDate],
	[OverallStopDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MedicationSIG]') AND name = N'IX_MedicationSIGProviderUid')
CREATE NONCLUSTERED INDEX [IX_MedicationSIGProviderUid] ON [dbo].[MedicationSIG]
(
	[ProviderUid] ASC
)
INCLUDE ( 	[MedicationSIGUid],
	[DiscontinueReasonUid],
	[PharmacyUid],
	[SIGQuantityUnitOfMeasureUid],
	[RefillQuantity],
	[Name],
	[Route],
	[IsSampleGiven],
	[IsAdministered]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MedicationSIG]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[MedicationSIG]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MedicationSIG]') AND name = N'IX_PharmacyUid')
CREATE NONCLUSTERED INDEX [IX_PharmacyUid] ON [dbo].[MedicationSIG]
(
	[PharmacyUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MedicationSIG]') AND name = N'IX_Procedure')
CREATE NONCLUSTERED INDEX [IX_Procedure] ON [dbo].[MedicationSIG]
(
	[ProcedureUid] ASC
)
INCLUDE ( 	[MedicationSIGUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MedicationSIG]') AND name = N'IX_ProviderUid')
CREATE NONCLUSTERED INDEX [IX_ProviderUid] ON [dbo].[MedicationSIG]
(
	[ProviderUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MedicationSIG]') AND name = N'MedicationSIG_RXNORM')
CREATE NONCLUSTERED INDEX [MedicationSIG_RXNORM] ON [dbo].[MedicationSIG]
(
	[RXNORMCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MedicationSIG]') AND name = N'PatienteRxEligibilityUid')
CREATE NONCLUSTERED INDEX [PatienteRxEligibilityUid] ON [dbo].[MedicationSIG]
(
	[PatienteRxEligibilityUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'IDX_Message_DateCompleted_PersonUid_MessageUid_MessageSubTypeUid')
CREATE NONCLUSTERED INDEX [IDX_Message_DateCompleted_PersonUid_MessageUid_MessageSubTypeUid] ON [dbo].[Message]
(
	[DateCompleted] ASC,
	[PersonUid] ASC
)
INCLUDE ( 	[MessageUid],
	[MessageSubTypeUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'IDX_Message_LastModifiedDate_MessageUid')
CREATE NONCLUSTERED INDEX [IDX_Message_LastModifiedDate_MessageUid] ON [dbo].[Message]
(
	[LastModifiedDate] ASC
)
INCLUDE ( 	[MessageUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'IDXR_DateCompleted_PersonUid')
CREATE NONCLUSTERED INDEX [IDXR_DateCompleted_PersonUid] ON [dbo].[Message]
(
	[DateCompleted] ASC,
	[PersonUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'IX_CompletedBy')
CREATE NONCLUSTERED INDEX [IX_CompletedBy] ON [dbo].[Message]
(
	[CompletedByUid] ASC
)
INCLUDE ( 	[MessageUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'IX_CreatedBy_MessageType_DateCompleted_LastReadBy')
CREATE NONCLUSTERED INDEX [IX_CreatedBy_MessageType_DateCompleted_LastReadBy] ON [dbo].[Message]
(
	[CreatedByUid] ASC,
	[MessageTypeUid] ASC,
	[DateCompleted] ASC,
	[LastReadByUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'IX_CreatedBy_Person')
CREATE NONCLUSTERED INDEX [IX_CreatedBy_Person] ON [dbo].[Message]
(
	[CreatedByUid] ASC,
	[PersonUid] ASC
)
INCLUDE ( 	[MessageUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'IX_CreatedBy_StrikeOut_DateToBeCompleted_DateCompleted')
CREATE NONCLUSTERED INDEX [IX_CreatedBy_StrikeOut_DateToBeCompleted_DateCompleted] ON [dbo].[Message]
(
	[CreatedByUid] ASC,
	[StrikeOut] ASC,
	[DateToBeCompleted] ASC,
	[DateCompleted] ASC
)
INCLUDE ( 	[MessageUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'IX_CreatedByUid')
CREATE NONCLUSTERED INDEX [IX_CreatedByUid] ON [dbo].[Message]
(
	[CreatedByUid] ASC,
	[DateToBeCompleted] ASC,
	[DateCompleted] ASC
)
INCLUDE ( 	[MessageUid],
	[MessageTypeUid],
	[MessageUrgencyUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'IX_CreatedByUid_DateCompleted_ToBeComp')
CREATE NONCLUSTERED INDEX [IX_CreatedByUid_DateCompleted_ToBeComp] ON [dbo].[Message]
(
	[CreatedByUid] ASC,
	[DateCompleted] ASC,
	[DateToBeCompleted] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'IX_CREATEDBYUID_LASTREADBYUID_INC')
CREATE NONCLUSTERED INDEX [IX_CREATEDBYUID_LASTREADBYUID_INC] ON [dbo].[Message]
(
	[CreatedByUid] ASC,
	[LastReadByUid] ASC
)
INCLUDE ( 	[MessageUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'IX_DateCompleted_DateCreated')
CREATE NONCLUSTERED INDEX [IX_DateCompleted_DateCreated] ON [dbo].[Message]
(
	[DateCompleted] ASC,
	[CreatedDateTime] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'IX_DateCompleted_LastReadBy')
CREATE NONCLUSTERED INDEX [IX_DateCompleted_LastReadBy] ON [dbo].[Message]
(
	[DateCompleted] ASC,
	[LastReadByUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'IX_DateCompleted_MessageType_DateCreated')
CREATE NONCLUSTERED INDEX [IX_DateCompleted_MessageType_DateCreated] ON [dbo].[Message]
(
	[DateCompleted] ASC,
	[MessageTypeUid] ASC,
	[CreatedDateTime] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'IX_DateCompleted_MessageType_DateToBeCompleted')
CREATE NONCLUSTERED INDEX [IX_DateCompleted_MessageType_DateToBeCompleted] ON [dbo].[Message]
(
	[DateCompleted] ASC,
	[MessageTypeUid] ASC,
	[DateToBeCompleted] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'IX_DateCompleted_MessageUrgency')
CREATE NONCLUSTERED INDEX [IX_DateCompleted_MessageUrgency] ON [dbo].[Message]
(
	[DateCompleted] ASC,
	[MessageUrgencyUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'IX_LastReadBy')
CREATE NONCLUSTERED INDEX [IX_LastReadBy] ON [dbo].[Message]
(
	[LastReadByUid] ASC
)
INCLUDE ( 	[MessageUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'IX_MesageType_DateCompleted_DateToBeCompleted')
CREATE NONCLUSTERED INDEX [IX_MesageType_DateCompleted_DateToBeCompleted] ON [dbo].[Message]
(
	[MessageTypeUid] ASC,
	[DateCompleted] ASC,
	[DateToBeCompleted] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'IX_Message_CompletedBy_CreatedBy')
CREATE NONCLUSTERED INDEX [IX_Message_CompletedBy_CreatedBy] ON [dbo].[Message]
(
	[MessageUid] ASC,
	[CompletedByUid] ASC,
	[CreatedByUid] ASC,
	[MessageUrgencyUid] ASC,
	[MessageTypeUid] ASC,
	[MessageSubTypeUid] ASC,
	[MessageStatusUid] ASC,
	[VisitUid] ASC,
	[PersonUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'ix_Message_CreatedByUid_StrikeOutCreatedDate_DateCompleted')
CREATE NONCLUSTERED INDEX [ix_Message_CreatedByUid_StrikeOutCreatedDate_DateCompleted] ON [dbo].[Message]
(
	[CreatedByUid] ASC,
	[StrikeOut] ASC,
	[CreatedDate] ASC,
	[DateCompleted] ASC
)
INCLUDE ( 	[MessageUid],
	[MessageTypeUid],
	[MessageUrgencyUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'ix_Message_CreatedByUid_StrikeOutCreatedDate_DateToBeCompleted_DateCompleted')
CREATE NONCLUSTERED INDEX [ix_Message_CreatedByUid_StrikeOutCreatedDate_DateToBeCompleted_DateCompleted] ON [dbo].[Message]
(
	[CreatedByUid] ASC,
	[StrikeOut] ASC,
	[CreatedDate] ASC,
	[DateToBeCompleted] ASC,
	[DateCompleted] ASC
)
INCLUDE ( 	[MessageUid],
	[MessageTypeUid],
	[MessageUrgencyUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'IX_Message_DateCompleted')
CREATE NONCLUSTERED INDEX [IX_Message_DateCompleted] ON [dbo].[Message]
(
	[DateCompleted] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'ix_Message_MessageTypeUid_DateCompleted_StrikeOutCreatedDate')
CREATE NONCLUSTERED INDEX [ix_Message_MessageTypeUid_DateCompleted_StrikeOutCreatedDate] ON [dbo].[Message]
(
	[MessageTypeUid] ASC,
	[DateCompleted] ASC,
	[StrikeOut] ASC,
	[CreatedDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'IX_Message_ParentMessageUid_PersonUid_StrikeOut')
CREATE NONCLUSTERED INDEX [IX_Message_ParentMessageUid_PersonUid_StrikeOut] ON [dbo].[Message]
(
	[ParentMessageUid] ASC,
	[PersonUid] ASC,
	[StrikeOut] ASC
)
INCLUDE ( 	[MessageUid],
	[CreatedByUid],
	[MessageTypeUid],
	[MessageSubTypeUid],
	[Header],
	[CreatedDate],
	[CreatedDateTime],
	[DateCompleted],
	[LastReadByUid],
	[MessageDataXML]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'IX_MessageCenter')
CREATE NONCLUSTERED INDEX [IX_MessageCenter] ON [dbo].[Message]
(
	[MessageUid] ASC,
	[CompletedByUid] ASC,
	[CreatedByUid] ASC,
	[MessageTypeUid] ASC,
	[MessageSubTypeUid] ASC,
	[MessageStatusUid] ASC,
	[MessageUrgencyUid] ASC,
	[VisitUid] ASC,
	[PersonUid] ASC
)
INCLUDE ( 	[CreatedDateTime],
	[DateToBeCompleted],
	[AutoComplete],
	[DateCompleted],
	[LastReadByUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'IX_MessageType_DateCompleted_MessageUrgency')
CREATE NONCLUSTERED INDEX [IX_MessageType_DateCompleted_MessageUrgency] ON [dbo].[Message]
(
	[MessageTypeUid] ASC,
	[DateCompleted] ASC,
	[MessageUrgencyUid] ASC
)
INCLUDE ( 	[CreatedDateTime],
	[StrikeOut]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'IX_MessageType_DateCompleted_SubType')
CREATE NONCLUSTERED INDEX [IX_MessageType_DateCompleted_SubType] ON [dbo].[Message]
(
	[MessageTypeUid] ASC,
	[DateCompleted] ASC,
	[MessageSubTypeUid] ASC,
	[DateToBeCompleted] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'IX_MessageType_MessageSubType_DateCompleted_MessageUrgency')
CREATE NONCLUSTERED INDEX [IX_MessageType_MessageSubType_DateCompleted_MessageUrgency] ON [dbo].[Message]
(
	[MessageTypeUid] ASC,
	[MessageSubTypeUid] ASC,
	[DateCompleted] ASC,
	[MessageUrgencyUid] ASC,
	[CreatedDateTime] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'IX_MessateType_MsgSubType_DateComp_ToBeComp')
CREATE NONCLUSTERED INDEX [IX_MessateType_MsgSubType_DateComp_ToBeComp] ON [dbo].[Message]
(
	[MessageTypeUid] ASC,
	[MessageSubTypeUid] ASC,
	[DateCompleted] ASC,
	[DateToBeCompleted] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'IX_ParentMessage_Person')
CREATE NONCLUSTERED INDEX [IX_ParentMessage_Person] ON [dbo].[Message]
(
	[ParentMessageUid] ASC,
	[PersonUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'IX_Person_MessageType_DateCompleted_CompletedBy')
CREATE NONCLUSTERED INDEX [IX_Person_MessageType_DateCompleted_CompletedBy] ON [dbo].[Message]
(
	[PersonUid] ASC,
	[MessageTypeUid] ASC,
	[DateCompleted] ASC,
	[CompletedByUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'IX_PersonUid_ParentMessageUid_MessageTypeUid')
CREATE NONCLUSTERED INDEX [IX_PersonUid_ParentMessageUid_MessageTypeUid] ON [dbo].[Message]
(
	[PersonUid] ASC,
	[ParentMessageUid] ASC,
	[MessageTypeUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'IXMessageImprovement')
CREATE NONCLUSTERED INDEX [IXMessageImprovement] ON [dbo].[Message]
(
	[MessageTypeUid] ASC,
	[MessageSubTypeUid] ASC,
	[DateCompleted] ASC,
	[StrikeOut] ASC
)
INCLUDE ( 	[MessageUid],
	[MessageUrgencyUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'IXMessagePerformance2')
CREATE NONCLUSTERED INDEX [IXMessagePerformance2] ON [dbo].[Message]
(
	[DateCompleted] ASC,
	[StrikeOut] ASC,
	[MessageTypeUid] ASC
)
INCLUDE ( 	[MessageUid],
	[MessageUrgencyUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'IXMessagePerformance3')
CREATE NONCLUSTERED INDEX [IXMessagePerformance3] ON [dbo].[Message]
(
	[DateCompleted] ASC,
	[StrikeOut] ASC
)
INCLUDE ( 	[MessageUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'IXR_MessageUrgencyUid_CompletedByUid_DateToBeCompletedW')
CREATE NONCLUSTERED INDEX [IXR_MessageUrgencyUid_CompletedByUid_DateToBeCompletedW] ON [dbo].[Message]
(
	[MessageUrgencyUid] ASC,
	[CompletedByUid] ASC,
	[DateToBeCompleted] ASC
)
INCLUDE ( 	[MessageUid],
	[CreatedDateTime]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'Message_ParentMessageUid_')
CREATE NONCLUSTERED INDEX [Message_ParentMessageUid_] ON [dbo].[Message]
(
	[ParentMessageUid] ASC,
	[PersonUid] ASC,
	[LastModifiedDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'Message_PersonUid')
CREATE NONCLUSTERED INDEX [Message_PersonUid] ON [dbo].[Message]
(
	[PersonUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Message]') AND name = N'VisitUid')
CREATE NONCLUSTERED INDEX [VisitUid] ON [dbo].[Message]
(
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageAA]') AND name = N'ix_MessageAA_RelAttachmentGroupUid')
CREATE NONCLUSTERED INDEX [ix_MessageAA_RelAttachmentGroupUid] ON [dbo].[MessageAA]
(
	[RelAttachmentGroupUid] ASC
)
INCLUDE ( 	[MessageUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageAA]') AND name = N'IX_RelAttachmentGroup')
CREATE NONCLUSTERED INDEX [IX_RelAttachmentGroup] ON [dbo].[MessageAA]
(
	[RelAttachmentGroupUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageAA]') AND name = N'IXR_VoiceAttachmentUid')
CREATE NONCLUSTERED INDEX [IXR_VoiceAttachmentUid] ON [dbo].[MessageAA]
(
	[VoiceAttachmentUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageeRxEligibility]') AND name = N'IDX_MessageeRxEligibility_eRxInboundUid')
CREATE NONCLUSTERED INDEX [IDX_MessageeRxEligibility_eRxInboundUid] ON [dbo].[MessageeRxEligibility]
(
	[eRxInboundUid] ASC
)
INCLUDE ( 	[MessageUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageeRxEligibility]') AND name = N'IX_MessageeRxEligibilityeRxEligibilityOutboundUid')
CREATE NONCLUSTERED INDEX [IX_MessageeRxEligibilityeRxEligibilityOutboundUid] ON [dbo].[MessageeRxEligibility]
(
	[eRxEligibilityOutboundUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageeRxMedicationHistory]') AND name = N'IDX_MessageeRxMedicationHistory_eRxInboundUid')
CREATE NONCLUSTERED INDEX [IDX_MessageeRxMedicationHistory_eRxInboundUid] ON [dbo].[MessageeRxMedicationHistory]
(
	[eRxInboundUid] ASC
)
INCLUDE ( 	[MessageUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageeRxMedicationHistory]') AND name = N'IX_MessageeRxMedicationHistoryeRxMedicationHistoryOutboundUid')
CREATE NONCLUSTERED INDEX [IX_MessageeRxMedicationHistoryeRxMedicationHistoryOutboundUid] ON [dbo].[MessageeRxMedicationHistory]
(
	[eRxMedicationHistoryOutboundUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageERxRefillRequest]') AND name = N'IDX_MessageERxRefillRequest_eRxInboundUid')
CREATE NONCLUSTERED INDEX [IDX_MessageERxRefillRequest_eRxInboundUid] ON [dbo].[MessageERxRefillRequest]
(
	[eRxInboundUid] ASC
)
INCLUDE ( 	[MessageUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageERxRefillRequest]') AND name = N'IX_eRxOutbound')
CREATE NONCLUSTERED INDEX [IX_eRxOutbound] ON [dbo].[MessageERxRefillRequest]
(
	[eRxOutboundUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageERxRefillRequest]') AND name = N'ix_MessageERxRefillRequest_RelVisitMedicationUid')
CREATE NONCLUSTERED INDEX [ix_MessageERxRefillRequest_RelVisitMedicationUid] ON [dbo].[MessageERxRefillRequest]
(
	[RelVisitMedicationUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageERxRefillRequest]') AND name = N'IX_RelVisitMedicationUid')
CREATE NONCLUSTERED INDEX [IX_RelVisitMedicationUid] ON [dbo].[MessageERxRefillRequest]
(
	[RelVisitMedicationUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageERxRefillRequest]') AND name = N'IX_VisitUid')
CREATE NONCLUSTERED INDEX [IX_VisitUid] ON [dbo].[MessageERxRefillRequest]
(
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageHL7]') AND name = N'IX_ObservationOrder')
CREATE NONCLUSTERED INDEX [IX_ObservationOrder] ON [dbo].[MessageHL7]
(
	[ObservationOrderUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageNote]') AND name = N'IX_CreatedBy')
CREATE NONCLUSTERED INDEX [IX_CreatedBy] ON [dbo].[MessageNote]
(
	[CreatedByUid] ASC
)
INCLUDE ( 	[MessageUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageNote]') AND name = N'IX_MessageUid_LastModifiedDate')
CREATE NONCLUSTERED INDEX [IX_MessageUid_LastModifiedDate] ON [dbo].[MessageNote]
(
	[MessageUid] ASC,
	[LastModifiedDate] ASC
)
INCLUDE ( 	[Note]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageRecipientHistory]') AND name = N'IX_Message')
CREATE NONCLUSTERED INDEX [IX_Message] ON [dbo].[MessageRecipientHistory]
(
	[MessageUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageRx]') AND name = N'IDX_MessageRx_eRxInboundUid')
CREATE NONCLUSTERED INDEX [IDX_MessageRx_eRxInboundUid] ON [dbo].[MessageRx]
(
	[eRxInboundUid] ASC
)
INCLUDE ( 	[MessageUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageRx]') AND name = N'IDX_MessageRx_eRxOutboundUid')
CREATE NONCLUSTERED INDEX [IDX_MessageRx_eRxOutboundUid] ON [dbo].[MessageRx]
(
	[eRxOutboundUid] ASC
)
INCLUDE ( 	[MessageUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageRxRefill]') AND name = N'IDX_MessageRxRefill_RelVisitMedicationUid')
CREATE NONCLUSTERED INDEX [IDX_MessageRxRefill_RelVisitMedicationUid] ON [dbo].[MessageRxRefill]
(
	[RelVisitMedicationUid] ASC
)
INCLUDE ( 	[MessageUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageRxRefill]') AND name = N'IX_MessageUid')
CREATE NONCLUSTERED INDEX [IX_MessageUid] ON [dbo].[MessageRxRefill]
(
	[MessageUid] ASC
)
INCLUDE ( 	[Phone]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageRxRefill]') AND name = N'IX_PHARMACYUID_INC')
CREATE NONCLUSTERED INDEX [IX_PHARMACYUID_INC] ON [dbo].[MessageRxRefill]
(
	[PharmacyUid] ASC
)
INCLUDE ( 	[MessageUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageRxRefill]') AND name = N'ix_visituid')
CREATE NONCLUSTERED INDEX [ix_visituid] ON [dbo].[MessageRxRefill]
(
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageRxRefillMedication]') AND name = N'IDX_MessageRxRefillMedication_RelVisitMedicationUid')
CREATE NONCLUSTERED INDEX [IDX_MessageRxRefillMedication_RelVisitMedicationUid] ON [dbo].[MessageRxRefillMedication]
(
	[RelVisitMedicationUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageRxRefillMedication]') AND name = N'IX_MessageRxRefillUid')
CREATE NONCLUSTERED INDEX [IX_MessageRxRefillUid] ON [dbo].[MessageRxRefillMedication]
(
	[MessageRxRefillUid] ASC
)
INCLUDE ( 	[MessageRxRefillMedicationUid],
	[MedicationRequested],
	[RelPatientMedicationUid],
	[RequestComment],
	[ResponseComment],
	[AcceptRefillRequest],
	[RelVisitMedicationUid],
	[LastModifiedDate],
	[LastModifiedByUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageTask]') AND name = N'IDX_MessageTask_PatientHMRuleUid')
CREATE NONCLUSTERED INDEX [IDX_MessageTask_PatientHMRuleUid] ON [dbo].[MessageTask]
(
	[PatientHMRuleUid] ASC
)
INCLUDE ( 	[MessageUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageTask]') AND name = N'IX_MessageTask_PatientHMRuleUid')
CREATE NONCLUSTERED INDEX [IX_MessageTask_PatientHMRuleUid] ON [dbo].[MessageTask]
(
	[PatientHMRuleUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageTask]') AND name = N'IX_MessageUid_PatHMRuleUid')
CREATE NONCLUSTERED INDEX [IX_MessageUid_PatHMRuleUid] ON [dbo].[MessageTask]
(
	[MessageUid] ASC,
	[PatientHMRuleUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageUncomplete]') AND name = N'IX_MessageUid')
CREATE NONCLUSTERED INDEX [IX_MessageUid] ON [dbo].[MessageUncomplete]
(
	[MessageUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageUser]') AND name = N'IDX_UserUid_UserGroupUid')
CREATE NONCLUSTERED INDEX [IDX_UserUid_UserGroupUid] ON [dbo].[MessageUser]
(
	[UserUid] ASC,
	[UserGroupUid] ASC
)
INCLUDE ( 	[MessageUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageUser]') AND name = N'IX_UserGroupUid')
CREATE NONCLUSTERED INDEX [IX_UserGroupUid] ON [dbo].[MessageUser]
(
	[UserGroupUid] ASC
)
INCLUDE ( 	[UserUid],
	[MessageUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageUser]') AND name = N'IX_UserUid')
CREATE NONCLUSTERED INDEX [IX_UserUid] ON [dbo].[MessageUser]
(
	[UserUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageUser]') AND name = N'IX_UserUid_MessageUid')
CREATE NONCLUSTERED INDEX [IX_UserUid_MessageUid] ON [dbo].[MessageUser]
(
	[UserUid] ASC,
	[MessageUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageVisitBilling]') AND name = N'IDX_MessageVisitBilling_ApprovedByUid')
CREATE NONCLUSTERED INDEX [IDX_MessageVisitBilling_ApprovedByUid] ON [dbo].[MessageVisitBilling]
(
	[ApprovedByUid] ASC
)
INCLUDE ( 	[MessageUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageVisitBilling]') AND name = N'IX_MessageUid')
CREATE NONCLUSTERED INDEX [IX_MessageUid] ON [dbo].[MessageVisitBilling]
(
	[MessageUid] ASC
)
INCLUDE ( 	[ApproveDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MessageVisitBilling]') AND name = N'IX_MessageVisitBilling_Visit')
CREATE NONCLUSTERED INDEX [IX_MessageVisitBilling_Visit] ON [dbo].[MessageVisitBilling]
(
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MU2_InterfaceDataMapping]') AND name = N'ix_MU2_InterfaceDataMapping_NCQMeasure')
CREATE NONCLUSTERED INDEX [ix_MU2_InterfaceDataMapping_NCQMeasure] ON [dbo].[MU2_InterfaceDataMapping]
(
	[NCQMeasure] ASC
)
INCLUDE ( 	[Rootid],
	[Name],
	[CCDCode],
	[PRMCode],
	[TopicIndicator],
	[DataElementName],
	[Modifier],
	[QRDASection]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MU2_InterfaceDataMapping]') AND name = N'Name_NCQMeasure_CCDCode')
CREATE NONCLUSTERED INDEX [Name_NCQMeasure_CCDCode] ON [dbo].[MU2_InterfaceDataMapping]
(
	[Name] ASC,
	[NCQMeasure] ASC,
	[CCDCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MU2_InterfaceDataMapping]') AND name = N'Name_PRMCode_NCQMeasure_DataElementName_Rootid')
CREATE NONCLUSTERED INDEX [Name_PRMCode_NCQMeasure_DataElementName_Rootid] ON [dbo].[MU2_InterfaceDataMapping]
(
	[Name] ASC,
	[PRMCode] ASC,
	[NCQMeasure] ASC,
	[DataElementName] ASC,
	[Rootid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MU2_InterfaceDataMapping]') AND name = N'NCQMeas_Name_DataElementName_Rootid_CCDCode')
CREATE NONCLUSTERED INDEX [NCQMeas_Name_DataElementName_Rootid_CCDCode] ON [dbo].[MU2_InterfaceDataMapping]
(
	[NCQMeasure] ASC,
	[Name] ASC,
	[DataElementName] ASC,
	[Rootid] ASC,
	[CCDCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MU2_InterfaceDataMapping]') AND name = N'NCQMeas_Name_DataElementName_Rootid_PRMCode')
CREATE NONCLUSTERED INDEX [NCQMeas_Name_DataElementName_Rootid_PRMCode] ON [dbo].[MU2_InterfaceDataMapping]
(
	[NCQMeasure] ASC,
	[Name] ASC,
	[DataElementName] ASC,
	[Rootid] ASC,
	[PRMCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MU2_InterfaceDataMapping]') AND name = N'NQFNum_Name_DataElementName_Rootid_CCDCode')
CREATE NONCLUSTERED INDEX [NQFNum_Name_DataElementName_Rootid_CCDCode] ON [dbo].[MU2_InterfaceDataMapping]
(
	[NQFNumber] ASC,
	[Name] ASC,
	[DataElementName] ASC,
	[Rootid] ASC,
	[CCDCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MU2_InterfaceDataMapping]') AND name = N'NQFNum_Name_DataElementName_Rootid_PRMCode')
CREATE NONCLUSTERED INDEX [NQFNum_Name_DataElementName_Rootid_PRMCode] ON [dbo].[MU2_InterfaceDataMapping]
(
	[NQFNumber] ASC,
	[Name] ASC,
	[DataElementName] ASC,
	[Rootid] ASC,
	[PRMCode] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MU2_InterfaceDataMapping]') AND name = N'Rootid_Name_CCDCode_NCQMeasure_DataElementName')
CREATE NONCLUSTERED INDEX [Rootid_Name_CCDCode_NCQMeasure_DataElementName] ON [dbo].[MU2_InterfaceDataMapping]
(
	[Rootid] ASC,
	[Name] ASC,
	[CCDCode] ASC,
	[NCQMeasure] ASC,
	[DataElementName] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[MU2_InterfaceDataMapping]') AND name = N'Rootid_Name_CCDCode_PRMCode_DataElementName_Modifier_NCQMeasure')
CREATE NONCLUSTERED INDEX [Rootid_Name_CCDCode_PRMCode_DataElementName_Modifier_NCQMeasure] ON [dbo].[MU2_InterfaceDataMapping]
(
	[Rootid] ASC,
	[Name] ASC,
	[CCDCode] ASC,
	[PRMCode] ASC,
	[DataElementName] ASC,
	[Modifier] ASC,
	[NCQMeasure] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ObservationOrder]') AND name = N'IX_ApproveProvider')
CREATE NONCLUSTERED INDEX [IX_ApproveProvider] ON [dbo].[ObservationOrder]
(
	[ApproveProviderUid] ASC
)
INCLUDE ( 	[ObservationOrderUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ObservationOrder]') AND name = N'IX_iMedicaAccessionNumber')
CREATE NONCLUSTERED INDEX [IX_iMedicaAccessionNumber] ON [dbo].[ObservationOrder]
(
	[ImedicaAccessionNumber] ASC
)
INCLUDE ( 	[VisitProcedureUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ObservationOrder]') AND name = N'IX_IsDelete')
CREATE NONCLUSTERED INDEX [IX_IsDelete] ON [dbo].[ObservationOrder]
(
	[IsDelete] ASC,
	[OrderDate] ASC
)
INCLUDE ( 	[ObservationOrderUid],
	[PatientUid],
	[OrderProviderUid],
	[VisitProcedureUid],
	[ResultStatusID],
	[AttachmentTypeUid],
	[CreatedBy],
	[VisitUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ObservationOrder]') AND name = N'IX_ObservationOrder_LaboratoryOrderUid')
CREATE NONCLUSTERED INDEX [IX_ObservationOrder_LaboratoryOrderUid] ON [dbo].[ObservationOrder]
(
	[LaboratoryOrderUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ObservationOrder]') AND name = N'IX_ObservationOrder_ObservationUid')
CREATE NONCLUSTERED INDEX [IX_ObservationOrder_ObservationUid] ON [dbo].[ObservationOrder]
(
	[ObservationUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ObservationOrder]') AND name = N'ix_ObservationOrder_PatientUid')
CREATE NONCLUSTERED INDEX [ix_ObservationOrder_PatientUid] ON [dbo].[ObservationOrder]
(
	[PatientUid] ASC
)
INCLUDE ( 	[PerformDateTime],
	[ReceiveDateTime],
	[ResultDateTime],
	[ExtractDateTime]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ObservationOrder]') AND name = N'IX_ObservationOrder_ResultStatusID')
CREATE NONCLUSTERED INDEX [IX_ObservationOrder_ResultStatusID] ON [dbo].[ObservationOrder]
(
	[ResultStatusID] ASC,
	[Inactive] ASC
)
INCLUDE ( 	[ObservationOrderUid],
	[VisitUid],
	[VisitProcedureUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ObservationOrder]') AND name = N'IX_ObservationOrder_VisitUid')
CREATE NONCLUSTERED INDEX [IX_ObservationOrder_VisitUid] ON [dbo].[ObservationOrder]
(
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ObservationOrder]') AND name = N'IX_ObservationOrderResultStatus')
CREATE NONCLUSTERED INDEX [IX_ObservationOrderResultStatus] ON [dbo].[ObservationOrder]
(
	[ObservationOrderResultStatusUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ObservationOrder]') AND name = N'IX_Patient_OrderProvider_LabAccessionNumber')
CREATE NONCLUSTERED INDEX [IX_Patient_OrderProvider_LabAccessionNumber] ON [dbo].[ObservationOrder]
(
	[PatientUid] ASC,
	[OrderProviderUid] ASC,
	[LabAccessionNumber] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ObservationOrder]') AND name = N'IX_PerformingProvider')
CREATE NONCLUSTERED INDEX [IX_PerformingProvider] ON [dbo].[ObservationOrder]
(
	[PerformProviderUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ObservationOrder]') AND name = N'IX_ResultingVisit')
CREATE NONCLUSTERED INDEX [IX_ResultingVisit] ON [dbo].[ObservationOrder]
(
	[ResultingVisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ObservationOrder]') AND name = N'IX_TrackingNum')
CREATE NONCLUSTERED INDEX [IX_TrackingNum] ON [dbo].[ObservationOrder]
(
	[TrackingNum] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ObservationOrder]') AND name = N'IX_VisitUid_OOUid_PatUid_LabUid_ResStatID_ObsUid_Inactive')
CREATE NONCLUSTERED INDEX [IX_VisitUid_OOUid_PatUid_LabUid_ResStatID_ObsUid_Inactive] ON [dbo].[ObservationOrder]
(
	[VisitUid] ASC,
	[ObservationOrderUid] ASC,
	[PatientUid] ASC,
	[LaboratoryUid] ASC,
	[ResultStatusID] ASC,
	[ObservationUid] ASC,
	[Inactive] ASC
)
INCLUDE ( 	[ResultDate],
	[AbnormalFlagCode],
	[ApproveDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ObservationOrder]') AND name = N'IXR_ObservationOrder_InfoW')
CREATE NONCLUSTERED INDEX [IXR_ObservationOrder_InfoW] ON [dbo].[ObservationOrder]
(
	[VisitUid] ASC,
	[ObservationOrderUid] ASC,
	[ResultStatusID] ASC,
	[OrderDateTime] ASC,
	[PatientUid] ASC,
	[LaboratoryUid] ASC,
	[OrderProviderUid] ASC,
	[VisitProcedureUid] ASC,
	[ObservationUid] ASC,
	[ResultStatusCode] ASC,
	[Technician] ASC,
	[ImedicaAccessionNumber] ASC,
	[LabAccessionNumber] ASC
)
INCLUDE ( 	[PerformDateTime],
	[ResultDateTime],
	[ExtractDateTime]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ObservationOrder]') AND name = N'IXR_ParentObservationOrderUid')
CREATE NONCLUSTERED INDEX [IXR_ParentObservationOrderUid] ON [dbo].[ObservationOrder]
(
	[ParentObservationOrderUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ObservationOrder]') AND name = N'IXR_PatientUid_Inactive_ResultStatusID')
CREATE NONCLUSTERED INDEX [IXR_PatientUid_Inactive_ResultStatusID] ON [dbo].[ObservationOrder]
(
	[PatientUid] ASC,
	[Inactive] ASC,
	[ResultStatusID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ObservationOrder]') AND name = N'IXR_PatientUid_ResultStatusID_ObservationOrderUid_OrderDate')
CREATE NONCLUSTERED INDEX [IXR_PatientUid_ResultStatusID_ObservationOrderUid_OrderDate] ON [dbo].[ObservationOrder]
(
	[PatientUid] ASC,
	[ResultStatusID] ASC,
	[ObservationOrderUid] ASC,
	[OrderDateTime] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ObservationOrder]') AND name = N'MessageUrgencyUid')
CREATE NONCLUSTERED INDEX [MessageUrgencyUid] ON [dbo].[ObservationOrder]
(
	[MessageUrgencyUid] ASC
)
INCLUDE ( 	[ObservationOrderUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ObservationOrder]') AND name = N'ObservationOrder_Results')
CREATE NONCLUSTERED INDEX [ObservationOrder_Results] ON [dbo].[ObservationOrder]
(
	[ObservationOrderUid] ASC,
	[ResultStatusID] ASC,
	[VisitProcedureUid] ASC,
	[AttachmentTypeUid] ASC,
	[CaseTypePhaseUid] ASC,
	[ObservationUid] ASC,
	[PatientUid] ASC,
	[OrderProviderUid] ASC,
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ObservationOrder]') AND name = N'ObservationOrder_VisitSO')
CREATE NONCLUSTERED INDEX [ObservationOrder_VisitSO] ON [dbo].[ObservationOrder]
(
	[VisitProcedureUid] ASC
)
INCLUDE ( 	[ObservationUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ObservationOrder]') AND name = N'ResultStatus_ApproveDate_Laboratory')
CREATE NONCLUSTERED INDEX [ResultStatus_ApproveDate_Laboratory] ON [dbo].[ObservationOrder]
(
	[ResultStatusID] ASC,
	[ApproveDate] ASC,
	[LaboratoryUid] ASC
)
INCLUDE ( 	[VisitUid],
	[VisitProcedureUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ObservationOrderResultStatusHistory]') AND name = N'IX_ObservationOrder')
CREATE NONCLUSTERED INDEX [IX_ObservationOrder] ON [dbo].[ObservationOrderResultStatusHistory]
(
	[ObservationOrderUid] ASC
)
INCLUDE ( 	[ObservationOrderResultStatusHistoryUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ObservationValue]') AND name = N'IX_ApproveProvider')
CREATE NONCLUSTERED INDEX [IX_ApproveProvider] ON [dbo].[ObservationValue]
(
	[ApproveProviderUid] ASC
)
INCLUDE ( 	[ObservationValueUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ObservationValue]') AND name = N'IX_EnteredBy')
CREATE NONCLUSTERED INDEX [IX_EnteredBy] ON [dbo].[ObservationValue]
(
	[EnteredByUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ObservationValue]') AND name = N'IX_LaboratoryLocationUid')
CREATE NONCLUSTERED INDEX [IX_LaboratoryLocationUid] ON [dbo].[ObservationValue]
(
	[LaboratoryLocationUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ObservationValue]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ObservationValue]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ObservationValue]') AND name = N'IX_ObservationValue_ObservationItemUid')
CREATE NONCLUSTERED INDEX [IX_ObservationValue_ObservationItemUid] ON [dbo].[ObservationValue]
(
	[ObservationItemUid] ASC
)
INCLUDE ( 	[ObservationOrderUid],
	[LastModifiedByUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ObservationValue]') AND name = N'ix_ObservationValue_ObservationItemUid_IsVitalsMetricValue1_LastModifiedDate')
CREATE NONCLUSTERED INDEX [ix_ObservationValue_ObservationItemUid_IsVitalsMetricValue1_LastModifiedDate] ON [dbo].[ObservationValue]
(
	[ObservationItemUid] ASC,
	[IsVitals] ASC,
	[MetricValue1] ASC,
	[LastModifiedDate] ASC
)
INCLUDE ( 	[VisitUid],
	[Name],
	[MetricValue2]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ObservationValue]') AND name = N'IX_ObservationValue_ObservationOrderUid')
CREATE NONCLUSTERED INDEX [IX_ObservationValue_ObservationOrderUid] ON [dbo].[ObservationValue]
(
	[ObservationOrderUid] ASC
)
INCLUDE ( 	[ObservationItemUid],
	[IsVitals],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ObservationValue]') AND name = N'IX_ObservationValue_VisitUid')
CREATE NONCLUSTERED INDEX [IX_ObservationValue_VisitUid] ON [dbo].[ObservationValue]
(
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ObservationValue]') AND name = N'IX_VisitUid_LastModifiedDate')
CREATE NONCLUSTERED INDEX [IX_VisitUid_LastModifiedDate] ON [dbo].[ObservationValue]
(
	[VisitUid] ASC,
	[LastModifiedDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ObservationValue]') AND name = N'IXR_ObservationOrderUid_ObservationValueUid_LaboratoryUid_ObservationItemUid')
CREATE NONCLUSTERED INDEX [IXR_ObservationOrderUid_ObservationValueUid_LaboratoryUid_ObservationItemUid] ON [dbo].[ObservationValue]
(
	[ObservationOrderUid] ASC,
	[ObservationValueUid] ASC,
	[LaboratoryUid] ASC,
	[ObservationItemUid] ASC
)
INCLUDE ( 	[VisitUid],
	[Name],
	[ObservationValue],
	[DisplayOrder],
	[StringValue],
	[IntegerValue],
	[FloatValue],
	[DateValue],
	[DateTimeValue],
	[MetricValue1],
	[MetricValue2],
	[MetricUnits],
	[Modifier1Uid],
	[Modifier1Name],
	[Modifier2Uid],
	[Modifier2Name],
	[Modifier3Uid],
	[Modifier3Name],
	[ReferenceRange],
	[ResultStatusCode],
	[AbnormalFlagCode],
	[Notes],
	[ResultStatusID],
	[IsVitals],
	[LaboratoryLocationUid],
	[ApproveProviderUid],
	[ApproveDate],
	[ReferenceMin],
	[ReferenceMax],
	[EnteredByUid],
	[LastModifiedByUid],
	[LastModifiedDate],
	[MeasurementUnits],
	[StringMin],
	[StringMax]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Patient]') AND name = N'IRX_PersonUid_ExternalID')
CREATE NONCLUSTERED INDEX [IRX_PersonUid_ExternalID] ON [dbo].[Patient]
(
	[PersonUid] ASC,
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Patient]') AND name = N'IX_eRXHPatientConsent')
CREATE NONCLUSTERED INDEX [IX_eRXHPatientConsent] ON [dbo].[Patient]
(
	[eRXHPatientConsent] ASC
)
INCLUDE ( 	[PersonUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Patient]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[Patient]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Patient]') AND name = N'ix_Patient_Inactive')
CREATE NONCLUSTERED INDEX [ix_Patient_Inactive] ON [dbo].[Patient]
(
	[Inactive] ASC
)
INCLUDE ( 	[PersonUid],
	[MedicalRecordNumber],
	[ProviderUid],
	[ExternalID]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Patient]') AND name = N'IX_Patient_LastModifiedDate')
CREATE NONCLUSTERED INDEX [IX_Patient_LastModifiedDate] ON [dbo].[Patient]
(
	[LastModifiedDate] DESC,
	[PersonUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Patient]') AND name = N'IX_PersonUId')
CREATE NONCLUSTERED INDEX [IX_PersonUId] ON [dbo].[Patient]
(
	[PersonUid] ASC
)
INCLUDE ( 	[MedicalRecordNumber]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Patient]') AND name = N'MedicalRecordNumber')
CREATE NONCLUSTERED INDEX [MedicalRecordNumber] ON [dbo].[Patient]
(
	[MedicalRecordNumber] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientCareManagement]') AND name = N'IX_PatientCareManagement_PatientUid_CareTypeUid_EffectiveDate_ExpirationDate')
CREATE NONCLUSTERED INDEX [IX_PatientCareManagement_PatientUid_CareTypeUid_EffectiveDate_ExpirationDate] ON [dbo].[PatientCareManagement]
(
	[PatientUid] ASC,
	[CareTypeUid] ASC,
	[EffectiveDate] ASC,
	[ExpirationDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientCase]') AND name = N'IX_Patientuid')
CREATE NONCLUSTERED INDEX [IX_Patientuid] ON [dbo].[PatientCase]
(
	[PatientUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientCaseModuleData]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[PatientCaseModuleData]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientCaseModuleData]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[PatientCaseModuleData]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientDefaultVisitAccess]') AND name = N'IX_PatientDefaultVisitAccess_Covering')
CREATE NONCLUSTERED INDEX [IX_PatientDefaultVisitAccess_Covering] ON [dbo].[PatientDefaultVisitAccess]
(
	[PatientUid] ASC,
	[UserUid] ASC,
	[UserGroupUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientDemographicsHistory]') AND name = N'IDX_PatientDemographicsHistory_PatientUid')
CREATE NONCLUSTERED INDEX [IDX_PatientDemographicsHistory_PatientUid] ON [dbo].[PatientDemographicsHistory]
(
	[PatientUid] ASC
)
INCLUDE ( 	[PatientDemographicsHistoryUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatienteRxEligibility]') AND name = N'IDX_PatienteRxEligibility_PatienteRxEligibilityUid_FormularyAlternativesOrgUid_PatientUid')
CREATE NONCLUSTERED INDEX [IDX_PatienteRxEligibility_PatienteRxEligibilityUid_FormularyAlternativesOrgUid_PatientUid] ON [dbo].[PatienteRxEligibility]
(
	[PatienteRxEligibilityUid] ASC,
	[FormularyAlternativesOrgUid] ASC,
	[PatientUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatienteRxEligibility]') AND name = N'IX_ExpirationDate')
CREATE NONCLUSTERED INDEX [IX_ExpirationDate] ON [dbo].[PatienteRxEligibility]
(
	[ExpirationDate] ASC
)
INCLUDE ( 	[PatienteRxEligibilityUid],
	[CoverageXML],
	[FormularyOrgUid],
	[FormularyAlternativesOrgUid],
	[FormularyCoverageOrgUid],
	[FormularyCopayOrgUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatienteRxEligibility]') AND name = N'IX_ExpirationDate_LastDownloadDate')
CREATE NONCLUSTERED INDEX [IX_ExpirationDate_LastDownloadDate] ON [dbo].[PatienteRxEligibility]
(
	[ExpirationDate] ASC,
	[LastDownloadedDateTime] ASC
)
INCLUDE ( 	[PatienteRxEligibilityUid],
	[CoverageXML],
	[FormularyOrgUid],
	[FormularyAlternativesOrgUid],
	[FormularyCoverageOrgUid],
	[FormularyCopayOrgUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatienteRxEligibility]') AND name = N'IX_FormularyAlternativesOrg_AlternativesID')
CREATE NONCLUSTERED INDEX [IX_FormularyAlternativesOrg_AlternativesID] ON [dbo].[PatienteRxEligibility]
(
	[LastModifiedDate] ASC,
	[AlternativesID] ASC,
	[FormularyAlternativesOrgUid] ASC
)
INCLUDE ( 	[PatienteRxEligibilityUid],
	[PayorID]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatienteRxEligibility]') AND name = N'IX_FormularyCopayOrg_CopayID')
CREATE NONCLUSTERED INDEX [IX_FormularyCopayOrg_CopayID] ON [dbo].[PatienteRxEligibility]
(
	[LastModifiedDate] ASC,
	[CopayID] ASC,
	[FormularyCopayOrgUid] ASC
)
INCLUDE ( 	[PatienteRxEligibilityUid],
	[PayorID]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatienteRxEligibility]') AND name = N'IX_FormularyCoverageOrg_CoverageID')
CREATE NONCLUSTERED INDEX [IX_FormularyCoverageOrg_CoverageID] ON [dbo].[PatienteRxEligibility]
(
	[LastModifiedDate] ASC,
	[CoverageID] ASC,
	[FormularyCoverageOrgUid] ASC
)
INCLUDE ( 	[PatienteRxEligibilityUid],
	[PayorID]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatienteRxEligibility]') AND name = N'IX_FormularyOrg_FormularyID')
CREATE NONCLUSTERED INDEX [IX_FormularyOrg_FormularyID] ON [dbo].[PatienteRxEligibility]
(
	[LastModifiedDate] ASC,
	[FormularyID] ASC,
	[FormularyOrgUid] ASC
)
INCLUDE ( 	[PatienteRxEligibilityUid],
	[PayorID]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatienteRxEligibility]') AND name = N'IX_Patient_Name_PayorID_SubscriberID')
CREATE NONCLUSTERED INDEX [IX_Patient_Name_PayorID_SubscriberID] ON [dbo].[PatienteRxEligibility]
(
	[PatientUid] ASC,
	[Name] ASC,
	[PayorID] ASC,
	[SubscriberID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatienteRxEligibility]') AND name = N'IX_PatienteRxEligibility_PatientUid')
CREATE NONCLUSTERED INDEX [IX_PatienteRxEligibility_PatientUid] ON [dbo].[PatienteRxEligibility]
(
	[PatientUid] ASC,
	[LastModifiedDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientFamilyHistory]') AND name = N'IX_IsDelete')
CREATE NONCLUSTERED INDEX [IX_IsDelete] ON [dbo].[PatientFamilyHistory]
(
	[IsDelete] ASC
)
INCLUDE ( 	[HxRelationshipUid],
	[PatientUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientFamilyHistory]') AND name = N'ix_PatientFamilyHistory_PatientUid')
CREATE NONCLUSTERED INDEX [ix_PatientFamilyHistory_PatientUid] ON [dbo].[PatientFamilyHistory]
(
	[PatientUid] ASC
)
INCLUDE ( 	[PatientFamilyHistoryUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientFamilyHistory]') AND name = N'ix_PatientFamilyHistory_VisitUid')
CREATE NONCLUSTERED INDEX [ix_PatientFamilyHistory_VisitUid] ON [dbo].[PatientFamilyHistory]
(
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientFamilyHistory]') AND name = N'IX_PatientUid')
CREATE NONCLUSTERED INDEX [IX_PatientUid] ON [dbo].[PatientFamilyHistory]
(
	[PatientUid] ASC,
	[ActiveDate] ASC,
	[InactiveDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientFamilyHistory]') AND name = N'IX_PatientUid_IsDelete')
CREATE NONCLUSTERED INDEX [IX_PatientUid_IsDelete] ON [dbo].[PatientFamilyHistory]
(
	[PatientUid] ASC,
	[IsDelete] ASC
)
INCLUDE ( 	[HxRelationshipUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientFamilyHistoryDisease]') AND name = N'ix_PatientFamilyHistoryDisease_PatientFamilyHistoryUid')
CREATE NONCLUSTERED INDEX [ix_PatientFamilyHistoryDisease_PatientFamilyHistoryUid] ON [dbo].[PatientFamilyHistoryDisease]
(
	[PatientFamilyHistoryUid] ASC
)
INCLUDE ( 	[PatientFamilyHistoryDiseaseUid],
	[DiseaseUid],
	[Name],
	[AgeAtOnsetTimeFrame],
	[IsDelete],
	[Notes],
	[DisplayOrder],
	[RecordDateTime],
	[ActiveDate],
	[InactiveDate],
	[IsPatientInput],
	[LastModifiedByUid],
	[LastModifiedDate],
	[IsCauseOfDeath],
	[Denies]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientFamilyHistoryDisease]') AND name = N'IX_PatientFamilyHistoryUid')
CREATE NONCLUSTERED INDEX [IX_PatientFamilyHistoryUid] ON [dbo].[PatientFamilyHistoryDisease]
(
	[PatientFamilyHistoryUid] ASC
)
INCLUDE ( 	[PatientFamilyHistoryDiseaseUid],
	[DiseaseUid],
	[Name],
	[AgeAtOnsetTimeFrame],
	[IsDelete],
	[Notes],
	[DisplayOrder],
	[RecordDateTime],
	[ActiveDate],
	[InactiveDate],
	[IsPatientInput],
	[LastModifiedByUid],
	[LastModifiedDate],
	[IsCauseOfDeath],
	[Denies]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientHistory]') AND name = N'IX_HistoryGroup_InactiveTime')
CREATE NONCLUSTERED INDEX [IX_HistoryGroup_InactiveTime] ON [dbo].[PatientHistory]
(
	[InactiveDate] ASC,
	[HistoryGroupUid] ASC
)
INCLUDE ( 	[PatientHistoryUid],
	[PatientUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientHistory]') AND name = N'IX_Patient_ActiveTime_PatientHistory')
CREATE NONCLUSTERED INDEX [IX_Patient_ActiveTime_PatientHistory] ON [dbo].[PatientHistory]
(
	[PatientUid] ASC,
	[ActiveDate] ASC,
	[PatientHistoryUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientHistory]') AND name = N'IX_Patient_HistoryGroup')
CREATE NONCLUSTERED INDEX [IX_Patient_HistoryGroup] ON [dbo].[PatientHistory]
(
	[PatientUid] ASC,
	[HistoryGroupUid] ASC
)
INCLUDE ( 	[PatientHistoryUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientHistory]') AND name = N'IX_PatientHistory_HistoryGroupUid')
CREATE NONCLUSTERED INDEX [IX_PatientHistory_HistoryGroupUid] ON [dbo].[PatientHistory]
(
	[HistoryGroupUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientHistory]') AND name = N'IX_PatientHistory_PatientUid')
CREATE NONCLUSTERED INDEX [IX_PatientHistory_PatientUid] ON [dbo].[PatientHistory]
(
	[PatientUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientHistory]') AND name = N'IX_VisitProcedureUid')
CREATE NONCLUSTERED INDEX [IX_VisitProcedureUid] ON [dbo].[PatientHistory]
(
	[VisitProcedureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientHistory]') AND name = N'IXR_VisitUid')
CREATE NONCLUSTERED INDEX [IXR_VisitUid] ON [dbo].[PatientHistory]
(
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientHistoryComment]') AND name = N'IX_PatientHistoryComment_PatientUid')
CREATE NONCLUSTERED INDEX [IX_PatientHistoryComment_PatientUid] ON [dbo].[PatientHistoryComment]
(
	[PatientUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientHistoryDetail]') AND name = N'IX_PatientHistory_PatientHistoryDetail_Question')
CREATE NONCLUSTERED INDEX [IX_PatientHistory_PatientHistoryDetail_Question] ON [dbo].[PatientHistoryDetail]
(
	[PatientHistoryUid] ASC,
	[PatientHistoryDetailUid] ASC,
	[QuestionUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientHistoryDetail]') AND name = N'IX_PatientHistoryDetail_AnswerUid')
CREATE NONCLUSTERED INDEX [IX_PatientHistoryDetail_AnswerUid] ON [dbo].[PatientHistoryDetail]
(
	[AnswerUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientHistoryDetail]') AND name = N'IX_PatientHistoryDetail_PatientHistoryUid')
CREATE NONCLUSTERED INDEX [IX_PatientHistoryDetail_PatientHistoryUid] ON [dbo].[PatientHistoryDetail]
(
	[PatientHistoryUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientHistoryDetail]') AND name = N'IX_PatientHistoryDetail_QuestionUid')
CREATE NONCLUSTERED INDEX [IX_PatientHistoryDetail_QuestionUid] ON [dbo].[PatientHistoryDetail]
(
	[QuestionUid] ASC
)
INCLUDE ( 	[PatientHistoryUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientHistoryDetail]') AND name = N'ix_PatientHistoryDetail_QuestionUidAnswerUid')
CREATE NONCLUSTERED INDEX [ix_PatientHistoryDetail_QuestionUidAnswerUid] ON [dbo].[PatientHistoryDetail]
(
	[QuestionUid] ASC,
	[AnswerUid] ASC
)
INCLUDE ( 	[PatientHistoryUid],
	[RecordDateTime],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientHistoryDetail]') AND name = N'Question_PatientHistoryDetail_PatientHistory')
CREATE NONCLUSTERED INDEX [Question_PatientHistoryDetail_PatientHistory] ON [dbo].[PatientHistoryDetail]
(
	[QuestionUid] ASC,
	[PatientHistoryDetailUid] ASC,
	[PatientHistoryUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientHMRule]') AND name = N'HMRuleUid')
CREATE NONCLUSTERED INDEX [HMRuleUid] ON [dbo].[PatientHMRule]
(
	[HMRuleUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientHMRule]') AND name = N'IsDue')
CREATE NONCLUSTERED INDEX [IsDue] ON [dbo].[PatientHMRule]
(
	[IsDue] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientHMRule]') AND name = N'IX_PatHMRuleUid')
CREATE NONCLUSTERED INDEX [IX_PatHMRuleUid] ON [dbo].[PatientHMRule]
(
	[PatientHMRuleUid] ASC
)
INCLUDE ( 	[HMRuleUid],
	[Inactive]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientHMRule]') AND name = N'IXR_InactiveW')
CREATE NONCLUSTERED INDEX [IXR_InactiveW] ON [dbo].[PatientHMRule]
(
	[Inactive] ASC
)
INCLUDE ( 	[PatientHMRuleUid],
	[HMRuleUid],
	[PatientUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientHMRule]') AND name = N'IXR_IsDue_InactiveW')
CREATE NONCLUSTERED INDEX [IXR_IsDue_InactiveW] ON [dbo].[PatientHMRule]
(
	[IsDue] ASC,
	[Inactive] ASC
)
INCLUDE ( 	[PatientHMRuleUid],
	[HMRuleUid],
	[PatientUid],
	[DueDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientHMRule]') AND name = N'PatientUid')
CREATE NONCLUSTERED INDEX [PatientUid] ON [dbo].[PatientHMRule]
(
	[PatientUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientHMRule]') AND name = N'PHMRuleHMRulePatient')
CREATE NONCLUSTERED INDEX [PHMRuleHMRulePatient] ON [dbo].[PatientHMRule]
(
	[PatientHMRuleUid] ASC,
	[HMRuleUid] ASC,
	[PatientUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientHMRuleDetail]') AND name = N'IX_PatientHMRule')
CREATE NONCLUSTERED INDEX [IX_PatientHMRule] ON [dbo].[PatientHMRuleDetail]
(
	[PatientHMRuleUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientHMRuleDetail]') AND name = N'IX_Procdure')
CREATE NONCLUSTERED INDEX [IX_Procdure] ON [dbo].[PatientHMRuleDetail]
(
	[ProcedureUid] ASC
)
INCLUDE ( 	[PatientHMRuleDetailUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientNote]') AND name = N'IX_Patient')
CREATE NONCLUSTERED INDEX [IX_Patient] ON [dbo].[PatientNote]
(
	[PatientUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientPersistentNoteHistory]') AND name = N'IX_PatientPersistentNoteHistory_PPDH')
CREATE NONCLUSTERED INDEX [IX_PatientPersistentNoteHistory_PPDH] ON [dbo].[PatientPersistentNoteHistory]
(
	[PatientUid] ASC,
	[PPDHGroupingUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientPharmacy]') AND name = N'IX_Patient')
CREATE NONCLUSTERED INDEX [IX_Patient] ON [dbo].[PatientPharmacy]
(
	[PatientUid] ASC
)
INCLUDE ( 	[PharmacyUid],
	[DisplayOrder]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientPharmacy]') AND name = N'IX_PatientPharmacy_PatientUid_PharmacyUid')
CREATE NONCLUSTERED INDEX [IX_PatientPharmacy_PatientUid_PharmacyUid] ON [dbo].[PatientPharmacy]
(
	[PatientUid] ASC,
	[PharmacyUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientPharmacy]') AND name = N'IX_Pharmacy')
CREATE NONCLUSTERED INDEX [IX_Pharmacy] ON [dbo].[PatientPharmacy]
(
	[PharmacyUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientProblemDiagnosisHistory]') AND name = N'IX_PatientProblemDiagnosisHistory_DiseaseUid_PatientProblemDiagnosisUid')
CREATE NONCLUSTERED INDEX [IX_PatientProblemDiagnosisHistory_DiseaseUid_PatientProblemDiagnosisUid] ON [dbo].[PatientProblemDiagnosisHistory]
(
	[DiseaseUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientProblemDiagnosisHistory]') AND name = N'ix_PatientProblemDiagnosisHistory_GroupingUid')
CREATE NONCLUSTERED INDEX [ix_PatientProblemDiagnosisHistory_GroupingUid] ON [dbo].[PatientProblemDiagnosisHistory]
(
	[GroupingUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientProblemDiagnosisHistory]') AND name = N'IX_PatientProblemDiagnosisHistory_IsDelete')
CREATE NONCLUSTERED INDEX [IX_PatientProblemDiagnosisHistory_IsDelete] ON [dbo].[PatientProblemDiagnosisHistory]
(
	[ProblemStatusUid] ASC,
	[IsDelete] ASC,
	[IsPatientProblem] ASC
)
INCLUDE ( 	[PatientProblemDiagnosisHistoryUid],
	[Code9],
	[Code10],
	[PatientUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientProblemDiagnosisHistory]') AND name = N'ix_PatientProblemDiagnosisHistory_IsPatientProblem')
CREATE NONCLUSTERED INDEX [ix_PatientProblemDiagnosisHistory_IsPatientProblem] ON [dbo].[PatientProblemDiagnosisHistory]
(
	[IsPatientProblem] ASC
)
INCLUDE ( 	[PatientProblemDiagnosisHistoryUid],
	[Code9],
	[Code10],
	[VisitUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientProblemDiagnosisHistory]') AND name = N'IX_PatientProblemDiagnosisHistory_PatientUid_ActiveDate_InactiveDate')
CREATE NONCLUSTERED INDEX [IX_PatientProblemDiagnosisHistory_PatientUid_ActiveDate_InactiveDate] ON [dbo].[PatientProblemDiagnosisHistory]
(
	[PatientUid] ASC,
	[ActiveDate] ASC,
	[InactiveDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientProblemDiagnosisHistory]') AND name = N'IX_PatientProblemDiagnosisHistory_PatientUid_IsPatientProblem_ActiveDate_InactiveDate')
CREATE NONCLUSTERED INDEX [IX_PatientProblemDiagnosisHistory_PatientUid_IsPatientProblem_ActiveDate_InactiveDate] ON [dbo].[PatientProblemDiagnosisHistory]
(
	[PatientUid] ASC,
	[IsPatientProblem] ASC,
	[ActiveDate] ASC,
	[InactiveDate] ASC
)
INCLUDE ( 	[PatientProblemDiagnosisHistoryUid],
	[VisitUid],
	[DiseaseUid],
	[ProblemStatusUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientProblemDiagnosisHistory]') AND name = N'IX_PatientProblemDiagnosisHistory_ProblemStatusUid_PatientProblemDiagnosisUid')
CREATE NONCLUSTERED INDEX [IX_PatientProblemDiagnosisHistory_ProblemStatusUid_PatientProblemDiagnosisUid] ON [dbo].[PatientProblemDiagnosisHistory]
(
	[ProblemStatusUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientProblemDiagnosisHistory]') AND name = N'ix_PatientProblemDiagnosisHistory_VisitUid')
CREATE NONCLUSTERED INDEX [ix_PatientProblemDiagnosisHistory_VisitUid] ON [dbo].[PatientProblemDiagnosisHistory]
(
	[VisitUid] ASC
)
INCLUDE ( 	[IsCurrentHistoryRow],
	[GroupingUid],
	[PatientUid],
	[Sequence]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientProcedureHistory]') AND name = N'ix_PatientProcedureHistory_VisitUid')
CREATE NONCLUSTERED INDEX [ix_PatientProcedureHistory_VisitUid] ON [dbo].[PatientProcedureHistory]
(
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientProviderRelationship]') AND name = N'IX_PatientUid_Inactive')
CREATE NONCLUSTERED INDEX [IX_PatientUid_Inactive] ON [dbo].[PatientProviderRelationship]
(
	[PatientUid] ASC,
	[Inactive] ASC,
	[CareTypeActiveFrom] ASC,
	[CareTypeActiveUntil] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientProviderRelationship]') AND name = N'IX_PatientUid_ProviderCareTypeUid')
CREATE NONCLUSTERED INDEX [IX_PatientUid_ProviderCareTypeUid] ON [dbo].[PatientProviderRelationship]
(
	[PatientUid] ASC,
	[ProviderCareTypeUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientRecall]') AND name = N'IX_PatientHMRuleUid')
CREATE NONCLUSTERED INDEX [IX_PatientHMRuleUid] ON [dbo].[PatientRecall]
(
	[PatientHMRuleUid] ASC,
	[DateNotified] ASC
)
INCLUDE ( 	[PatientRecallUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientRecall]') AND name = N'ix_PatientRecall_AppointmentUid')
CREATE NONCLUSTERED INDEX [ix_PatientRecall_AppointmentUid] ON [dbo].[PatientRecall]
(
	[AppointmentUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientRecall]') AND name = N'IX_PatientRecall_MeaningfulUse')
CREATE NONCLUSTERED INDEX [IX_PatientRecall_MeaningfulUse] ON [dbo].[PatientRecall]
(
	[PatientUid] ASC,
	[RecallTypeUid] ASC,
	[NotificationMethodUid] ASC,
	[DateSatisfied] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientRecall]') AND name = N'ix_PatientRecall_OriginVisitUid')
CREATE NONCLUSTERED INDEX [ix_PatientRecall_OriginVisitUid] ON [dbo].[PatientRecall]
(
	[OriginVisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientRecall]') AND name = N'ix_PatientRecall_VisitUid')
CREATE NONCLUSTERED INDEX [ix_PatientRecall_VisitUid] ON [dbo].[PatientRecall]
(
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientReferral]') AND name = N'IX_PatientProviderRelationshipUid')
CREATE NONCLUSTERED INDEX [IX_PatientProviderRelationshipUid] ON [dbo].[PatientReferral]
(
	[PatientProviderRelationshipUid] ASC
)
INCLUDE ( 	[PatientReferralUid],
	[ReferralTrackingStatusUid],
	[ReferredByProviderUid],
	[AppointmentDate],
	[Notes],
	[BookingTime],
	[VisitUid],
	[VisitProcedureUid],
	[Inactive],
	[LastModifiedByUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientReferral]') AND name = N'IX_PatientReferral_LastModifiedDate_CreatedDate_Inc4')
CREATE NONCLUSTERED INDEX [IX_PatientReferral_LastModifiedDate_CreatedDate_Inc4] ON [dbo].[PatientReferral]
(
	[ReferredByProviderUid] ASC,
	[LastModifiedDate] ASC,
	[CreatedDate] ASC
)
INCLUDE ( 	[PatientProviderRelationshipUid],
	[ReferralTrackingStatusUid],
	[VisitUid],
	[VisitProcedureUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientReferral]') AND name = N'IX_PatRef_[PatientProviderRelationshipUid')
CREATE NONCLUSTERED INDEX [IX_PatRef_[PatientProviderRelationshipUid] ON [dbo].[PatientReferral]
(
	[PatientProviderRelationshipUid] ASC
)
INCLUDE ( 	[PatientReferralUid],
	[ReferralTrackingStatusUid],
	[ReferredByProviderUid],
	[VisitUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientReferral]') AND name = N'IX_PatRef_ReferralTrackingStatusUid')
CREATE NONCLUSTERED INDEX [IX_PatRef_ReferralTrackingStatusUid] ON [dbo].[PatientReferral]
(
	[ReferralTrackingStatusUid] ASC
)
INCLUDE ( 	[PatientReferralUid],
	[PatientProviderRelationshipUid],
	[ReferredByProviderUid],
	[VisitUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientReferral]') AND name = N'IX_VisitProcedureUid')
CREATE NONCLUSTERED INDEX [IX_VisitProcedureUid] ON [dbo].[PatientReferral]
(
	[VisitProcedureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientReferral]') AND name = N'IX_VisitUid')
CREATE NONCLUSTERED INDEX [IX_VisitUid] ON [dbo].[PatientReferral]
(
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientReferralHistory]') AND name = N'IX_PatientReferralUid')
CREATE NONCLUSTERED INDEX [IX_PatientReferralUid] ON [dbo].[PatientReferralHistory]
(
	[PatientReferralUid] ASC
)
INCLUDE ( 	[PatientReferralHistoryUid],
	[ReferralTrackingStatusUid],
	[Notes],
	[Inactive],
	[LastModifiedByUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientTrackingEvent]') AND name = N'IX_PatientTrackingEvent')
CREATE NONCLUSTERED INDEX [IX_PatientTrackingEvent] ON [dbo].[PatientTrackingEvent]
(
	[PatientUid] ASC,
	[EventDate] ASC,
	[Inactive] ASC,
	[PatientTrackingEventTypeUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Person]') AND name = N'IDXI_Person_Deathdate')
CREATE NONCLUSTERED INDEX [IDXI_Person_Deathdate] ON [dbo].[Person]
(
	[Deathdate] ASC
)
INCLUDE ( 	[PersonUid],
	[FirstName],
	[LastName],
	[LanguageUid],
	[GenderUid],
	[Birthdate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Person]') AND name = N'IX_Birthdate')
CREATE NONCLUSTERED INDEX [IX_Birthdate] ON [dbo].[Person]
(
	[Birthdate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Person]') AND name = N'IX_Birthdate_Deathdate_Gender_Person')
CREATE NONCLUSTERED INDEX [IX_Birthdate_Deathdate_Gender_Person] ON [dbo].[Person]
(
	[PersonUid] ASC,
	[Birthdate] ASC,
	[Deathdate] ASC,
	[GenderUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Person]') AND name = N'IX_Deathdate')
CREATE NONCLUSTERED INDEX [IX_Deathdate] ON [dbo].[Person]
(
	[Deathdate] ASC
)
INCLUDE ( 	[PersonUid],
	[FirstName],
	[LastName],
	[GenderUid],
	[Birthdate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Person]') AND name = N'IX_DriverLicenseAttachment')
CREATE NONCLUSTERED INDEX [IX_DriverLicenseAttachment] ON [dbo].[Person]
(
	[DriverLicenseAttachmentUid] ASC
)
INCLUDE ( 	[PersonUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Person]') AND name = N'IX_FirstLast')
CREATE NONCLUSTERED INDEX [IX_FirstLast] ON [dbo].[Person]
(
	[FirstName] ASC,
	[LastName] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Person]') AND name = N'IX_PERSONNAME')
CREATE NONCLUSTERED INDEX [IX_PERSONNAME] ON [dbo].[Person]
(
	[PersonUid] ASC
)
INCLUDE ( 	[Prefix],
	[FirstName],
	[MiddleName],
	[LastName],
	[Suffix]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Person]') AND name = N'IX_PhotoAttachment')
CREATE NONCLUSTERED INDEX [IX_PhotoAttachment] ON [dbo].[Person]
(
	[PhotoAttachmentUid] ASC
)
INCLUDE ( 	[PersonUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Person]') AND name = N'IX_SSN')
CREATE NONCLUSTERED INDEX [IX_SSN] ON [dbo].[Person]
(
	[SocialSecurityNumber] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Person]') AND name = N'LivesWithPersonUid')
CREATE NONCLUSTERED INDEX [LivesWithPersonUid] ON [dbo].[Person]
(
	[LivesWithPersonUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Person]') AND name = N'Person_PersonUid_LastModifiedDate')
CREATE NONCLUSTERED INDEX [Person_PersonUid_LastModifiedDate] ON [dbo].[Person]
(
	[PersonUid] ASC,
	[LastModifiedDate] ASC
)
INCLUDE ( 	[Prefix],
	[FirstName],
	[MiddleName],
	[LastName],
	[Suffix],
	[Address1],
	[Address2],
	[Phone1],
	[Phone2],
	[Phone3],
	[Phone4],
	[Email1],
	[Email2]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PersonContact]') AND name = N'IX_Person')
CREATE NONCLUSTERED INDEX [IX_Person] ON [dbo].[PersonContact]
(
	[PersonUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PersonEmployer]') AND name = N'EmployerUid')
CREATE NONCLUSTERED INDEX [EmployerUid] ON [dbo].[PersonEmployer]
(
	[EmployerUid] ASC
)
INCLUDE ( 	[PersonUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PersonEmployer]') AND name = N'PersonUid')
CREATE NONCLUSTERED INDEX [PersonUid] ON [dbo].[PersonEmployer]
(
	[PersonUid] ASC
)
INCLUDE ( 	[EmployerUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PersonInsurancePlan]') AND name = N'IDX_PersonInsurancePlan_InsuranceCardAttachmentUid_PersonUid')
CREATE NONCLUSTERED INDEX [IDX_PersonInsurancePlan_InsuranceCardAttachmentUid_PersonUid] ON [dbo].[PersonInsurancePlan]
(
	[InsuranceCardAttachmentUid] ASC
)
INCLUDE ( 	[PersonUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PersonInsurancePlan]') AND name = N'IX_InsurancePlan')
CREATE NONCLUSTERED INDEX [IX_InsurancePlan] ON [dbo].[PersonInsurancePlan]
(
	[InsurancePlanUid] ASC
)
INCLUDE ( 	[PersonInsurancePlanUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PersonInsurancePlan]') AND name = N'PersonInsurancePlan_Corporation')
CREATE NONCLUSTERED INDEX [PersonInsurancePlan_Corporation] ON [dbo].[PersonInsurancePlan]
(
	[PersonInsurancePlanUid] ASC,
	[CorporationUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PersonInsurancePlan]') AND name = N'PersonInsurancePlan_Corporation_InsurancePlan')
CREATE NONCLUSTERED INDEX [PersonInsurancePlan_Corporation_InsurancePlan] ON [dbo].[PersonInsurancePlan]
(
	[PersonInsurancePlanUid] ASC,
	[CorporationUid] ASC,
	[InsurancePlanUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PersonInsurancePlan]') AND name = N'PersonInsuranceplan_Person')
CREATE NONCLUSTERED INDEX [PersonInsuranceplan_Person] ON [dbo].[PersonInsurancePlan]
(
	[PersonInsurancePlanUid] ASC,
	[PersonUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PersonInsurancePlan]') AND name = N'PersonUid')
CREATE NONCLUSTERED INDEX [PersonUid] ON [dbo].[PersonInsurancePlan]
(
	[PersonUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON, FILLFACTOR = 90) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PersonInsurancePlan]') AND name = N'PlanMemberID_PersonInsurancePlanUid_InsurancePlanUid')
CREATE NONCLUSTERED INDEX [PlanMemberID_PersonInsurancePlanUid_InsurancePlanUid] ON [dbo].[PersonInsurancePlan]
(
	[PlanMemberID] ASC,
	[PersonInsurancePlanUid] ASC,
	[InsurancePlanUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PersonWeb]') AND name = N'IDXI_PersonWeb_PatientWebAccess')
CREATE NONCLUSTERED INDEX [IDXI_PersonWeb_PatientWebAccess] ON [dbo].[PersonWeb]
(
	[PatientWebAccess] ASC
)
INCLUDE ( 	[PersonUid],
	[CreatedDateTime]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PersonWeb]') AND name = N'IX_UserName_Person')
CREATE NONCLUSTERED INDEX [IX_UserName_Person] ON [dbo].[PersonWeb]
(
	[UserName] ASC,
	[PersonUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PlugInSettings]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[PlugInSettings]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PQRIDenominator]') AND name = N'IX_PQRIMeasure')
CREATE NONCLUSTERED INDEX [IX_PQRIMeasure] ON [dbo].[PQRIDenominator]
(
	[PQRIMeasureUid] ASC
)
INCLUDE ( 	[DisplayOrder]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PQRIHistory]') AND name = N'IX_Patient_PQRIMeasure')
CREATE NONCLUSTERED INDEX [IX_Patient_PQRIMeasure] ON [dbo].[PQRIHistory]
(
	[PatientUid] ASC,
	[PQRIMeasureUid] ASC
)
INCLUDE ( 	[PQRIHistoryUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PQRIHistory]') AND name = N'IX_PQRIMeasure')
CREATE NONCLUSTERED INDEX [IX_PQRIMeasure] ON [dbo].[PQRIHistory]
(
	[PQRIMeasureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PQRIHistory]') AND name = N'IX_PQRINumerator')
CREATE NONCLUSTERED INDEX [IX_PQRINumerator] ON [dbo].[PQRIHistory]
(
	[PQRINumeratorUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PQRIHistory]') AND name = N'IX_Visit')
CREATE NONCLUSTERED INDEX [IX_Visit] ON [dbo].[PQRIHistory]
(
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PQRIHistory]') AND name = N'IX_Visit_VisitProcedureUid_PQRIMeasure')
CREATE NONCLUSTERED INDEX [IX_Visit_VisitProcedureUid_PQRIMeasure] ON [dbo].[PQRIHistory]
(
	[VisitUid] ASC,
	[PQRIMeasureUid] ASC,
	[VisitProcedureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PQRIHistory]') AND name = N'IX_VisitProcedure')
CREATE NONCLUSTERED INDEX [IX_VisitProcedure] ON [dbo].[PQRIHistory]
(
	[VisitProcedureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PQRINumerator]') AND name = N'IX_PQRIMeasure')
CREATE NONCLUSTERED INDEX [IX_PQRIMeasure] ON [dbo].[PQRINumerator]
(
	[PQRIMeasureUid] ASC
)
INCLUDE ( 	[ProcedureUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PracticeSettings]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[PracticeSettings]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ProcedureNotePage]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ProcedureNotePage]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ProcedureSpecialty]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ProcedureSpecialty]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Provider]') AND name = N'ExternalID')
CREATE NONCLUSTERED INDEX [ExternalID] ON [dbo].[Provider]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Provider]') AND name = N'IDX_Provider_AuthorizationReviewerUid')
CREATE NONCLUSTERED INDEX [IDX_Provider_AuthorizationReviewerUid] ON [dbo].[Provider]
(
	[AuthorizationReviewerUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Provider]') AND name = N'IDX_Provider_ClaimProviderCorporationUid')
CREATE NONCLUSTERED INDEX [IDX_Provider_ClaimProviderCorporationUid] ON [dbo].[Provider]
(
	[ClaimProviderCorporationUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Provider]') AND name = N'IDX_Provider_DefaultLabOrderTaskMsgRecvrUid')
CREATE NONCLUSTERED INDEX [IDX_Provider_DefaultLabOrderTaskMsgRecvrUid] ON [dbo].[Provider]
(
	[DefaultLabOrderTaskMsgRecvrUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Provider]') AND name = N'IDX_Provider_DefaultReviewerUid')
CREATE NONCLUSTERED INDEX [IDX_Provider_DefaultReviewerUid] ON [dbo].[Provider]
(
	[DefaultReviewerUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Provider]') AND name = N'IDX_Provider_PayToProviderCorporationUid')
CREATE NONCLUSTERED INDEX [IDX_Provider_PayToProviderCorporationUid] ON [dbo].[Provider]
(
	[PayToProviderCorporationUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Provider]') AND name = N'IDX_Provider_RouteDocumentFaxErrorToUserUid')
CREATE NONCLUSTERED INDEX [IDX_Provider_RouteDocumentFaxErrorToUserUid] ON [dbo].[Provider]
(
	[RouteDocumentFaxErrorToUserUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Provider]') AND name = N'IX_Provider_PersonUid_SpecialtyUid')
CREATE NONCLUSTERED INDEX [IX_Provider_PersonUid_SpecialtyUid] ON [dbo].[Provider]
(
	[PersonUid] ASC,
	[SpecialtyUid] ASC
)
INCLUDE ( 	[Inactive],
	[ExternalID]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Provider]') AND name = N'IX_ProviderRoleID')
CREATE NONCLUSTERED INDEX [IX_ProviderRoleID] ON [dbo].[Provider]
(
	[ProviderRoleID] ASC
)
INCLUDE ( 	[PersonUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Provider]') AND name = N'IXR_FinancialCenterUidW')
CREATE NONCLUSTERED INDEX [IXR_FinancialCenterUidW] ON [dbo].[Provider]
(
	[FinancialCenterUid] ASC
)
INCLUDE ( 	[PersonUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ProviderAttachment]') AND name = N'IX_ProviderAttachment')
CREATE UNIQUE NONCLUSTERED INDEX [IX_ProviderAttachment] ON [dbo].[ProviderAttachment]
(
	[ProviderUid] ASC,
	[AttachmentUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ProviderCpp]') AND name = N'IX_CppUid')
CREATE NONCLUSTERED INDEX [IX_CppUid] ON [dbo].[ProviderCpp]
(
	[CppUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ProviderCpp]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ProviderCpp]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ProviderCpp]') AND name = N'IX_ProviderCpp')
CREATE UNIQUE NONCLUSTERED INDEX [IX_ProviderCpp] ON [dbo].[ProviderCpp]
(
	[ProviderUid] ASC,
	[CppUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ProviderDefaultSIG]') AND name = N'IX_Provider_FDB_HIC_SEQN_Inactive')
CREATE NONCLUSTERED INDEX [IX_Provider_FDB_HIC_SEQN_Inactive] ON [dbo].[ProviderDefaultSIG]
(
	[KdbConfigurationUid] ASC,
	[FDB_HIC_SEQN] ASC,
	[Inactive] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ProviderDefaultSIG]') AND name = N'IX_Provider_Inactive_Name')
CREATE NONCLUSTERED INDEX [IX_Provider_Inactive_Name] ON [dbo].[ProviderDefaultSIG]
(
	[KdbConfigurationUid] ASC,
	[Inactive] ASC,
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ProviderDefaultVisitAccess]') AND name = N'IX_ProviderDefaultVisitAccess_Covering')
CREATE NONCLUSTERED INDEX [IX_ProviderDefaultVisitAccess_Covering] ON [dbo].[ProviderDefaultVisitAccess]
(
	[ProviderUid] ASC,
	[UserUid] ASC,
	[UserGroupUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ProviderDirectory]') AND name = N'IX_PharmacyClearinghouse_SPI')
CREATE NONCLUSTERED INDEX [IX_PharmacyClearinghouse_SPI] ON [dbo].[ProviderDirectory]
(
	[PharmacyClearinghouseUid] ASC,
	[SPI] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ProviderEduForm]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ProviderEduForm]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ProviderEduForm]') AND name = N'IX_ProviderEduForm')
CREATE UNIQUE NONCLUSTERED INDEX [IX_ProviderEduForm] ON [dbo].[ProviderEduForm]
(
	[ProviderUid] ASC,
	[EduFormUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ProviderObservationItem]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ProviderObservationItem]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ProviderObservationItem]') AND name = N'IX_ProviderObservationItem')
CREATE UNIQUE NONCLUSTERED INDEX [IX_ProviderObservationItem] ON [dbo].[ProviderObservationItem]
(
	[ProviderUid] ASC,
	[RelObservationObservationItemUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ProviderProcedureModifier]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ProviderProcedureModifier]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ProviderProcedureModifier]') AND name = N'IX_ProviderProcedureModifier')
CREATE UNIQUE NONCLUSTERED INDEX [IX_ProviderProcedureModifier] ON [dbo].[ProviderProcedureModifier]
(
	[ProviderUid] ASC,
	[ProcedureModifierUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ProviderSignature]') AND name = N'IX_ProviderSignature')
CREATE NONCLUSTERED INDEX [IX_ProviderSignature] ON [dbo].[ProviderSignature]
(
	[ProviderUid] ASC
)
INCLUDE ( 	[ProviderSignatureUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ProviderSignature]') AND name = N'ix_ProviderSignature_ProviderUid_IsPermanentSignature')
CREATE NONCLUSTERED INDEX [ix_ProviderSignature_ProviderUid_IsPermanentSignature] ON [dbo].[ProviderSignature]
(
	[ProviderUid] ASC,
	[IsPermanentSignature] ASC
)
INCLUDE ( 	[ProviderSignatureUid],
	[Signature],
	[LastModifiedDate],
	[LastModifiedByUid],
	[IsImage]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RecordDisclosureAudit]') AND name = N'DisclosureDate_PatientReferralUid')
CREATE NONCLUSTERED INDEX [DisclosureDate_PatientReferralUid] ON [dbo].[RecordDisclosureAudit]
(
	[DisclosureDate] ASC,
	[DisclosureType] ASC,
	[PatientReferralUid] ASC,
	[AttachmentGroupUid] ASC,
	[VisitUid] ASC
)
INCLUDE ( 	[IsPortal],
	[DisclosureMethod],
	[Status],
	[DisclosurePurpose]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RecordDisclosureAudit]') AND name = N'DisclosureDate_PatientUid')
CREATE NONCLUSTERED INDEX [DisclosureDate_PatientUid] ON [dbo].[RecordDisclosureAudit]
(
	[DisclosureDate] ASC,
	[DisclosureType] ASC,
	[PatientUid] ASC,
	[VisitUid] ASC
)
INCLUDE ( 	[IsPortal],
	[DisclosureMethod],
	[Status],
	[DisclosurePurpose]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RecordDisclosureAudit]') AND name = N'DisclosureDate_VisitUid')
CREATE NONCLUSTERED INDEX [DisclosureDate_VisitUid] ON [dbo].[RecordDisclosureAudit]
(
	[DisclosureDate] ASC,
	[DisclosureType] ASC,
	[VisitUid] ASC,
	[PatientUid] ASC
)
INCLUDE ( 	[IsPortal],
	[DisclosureMethod],
	[Status],
	[DisclosurePurpose]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RecordDisclosureAudit]') AND name = N'IX_DisclosureType')
CREATE NONCLUSTERED INDEX [IX_DisclosureType] ON [dbo].[RecordDisclosureAudit]
(
	[DisclosureType] ASC
)
INCLUDE ( 	[DisclosureDate],
	[VisitUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RecordDisclosureAudit]') AND name = N'IX_DocumentName')
CREATE NONCLUSTERED INDEX [IX_DocumentName] ON [dbo].[RecordDisclosureAudit]
(
	[DocumentName] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RecordDisclosureAudit]') AND name = N'IX_DocumentName_VisitUid')
CREATE NONCLUSTERED INDEX [IX_DocumentName_VisitUid] ON [dbo].[RecordDisclosureAudit]
(
	[DocumentName] ASC,
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RecordDisclosureAudit]') AND name = N'IX_Patient')
CREATE NONCLUSTERED INDEX [IX_Patient] ON [dbo].[RecordDisclosureAudit]
(
	[PatientUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RecordDisclosureAudit]') AND name = N'ix_RecordDisclosureAudit_AttachmentGroupUid')
CREATE NONCLUSTERED INDEX [ix_RecordDisclosureAudit_AttachmentGroupUid] ON [dbo].[RecordDisclosureAudit]
(
	[AttachmentGroupUid] ASC
)
INCLUDE ( 	[RecordDisclosureAuditUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RecordDisclosureAudit]') AND name = N'IX_Visit_DisclosureType')
CREATE NONCLUSTERED INDEX [IX_Visit_DisclosureType] ON [dbo].[RecordDisclosureAudit]
(
	[VisitUid] ASC,
	[DisclosureType] ASC
)
INCLUDE ( 	[DisclosureDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ReimbursementRuleTrigger]') AND name = N'IX_ReimbursementRuleTrigger_ReimbursementRuleUid')
CREATE NONCLUSTERED INDEX [IX_ReimbursementRuleTrigger_ReimbursementRuleUid] ON [dbo].[ReimbursementRuleTrigger]
(
	[ReimbursementRuleUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelAddInType]') AND name = N'IX_AddIn')
CREATE NONCLUSTERED INDEX [IX_AddIn] ON [dbo].[RelAddInType]
(
	[AddInUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelAddInType]') AND name = N'IX_AddInType')
CREATE NONCLUSTERED INDEX [IX_AddInType] ON [dbo].[RelAddInType]
(
	[AddInTypeUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelAnswerGroupAnswer]') AND name = N'IX_Answer')
CREATE NONCLUSTERED INDEX [IX_Answer] ON [dbo].[RelAnswerGroupAnswer]
(
	[AnswerUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelAnswerGroupAnswer]') AND name = N'IX_AnswerGroupUid')
CREATE NONCLUSTERED INDEX [IX_AnswerGroupUid] ON [dbo].[RelAnswerGroupAnswer]
(
	[AnswerGroupUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelAnswerGroupAnswer]') AND name = N'IX_RelAnswerGroupAnswerUid_AnswerUid_AnswerGroupUid')
CREATE NONCLUSTERED INDEX [IX_RelAnswerGroupAnswerUid_AnswerUid_AnswerGroupUid] ON [dbo].[RelAnswerGroupAnswer]
(
	[RelAnswerGroupAnswerUid] ASC,
	[AnswerUid] ASC,
	[AnswerGroupUid] ASC
)
INCLUDE ( 	[UserDefined],
	[DisplayOrder]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelAttachmentGroup]') AND name = N'Deposit_Visit_AttachmentGroup')
CREATE NONCLUSTERED INDEX [Deposit_Visit_AttachmentGroup] ON [dbo].[RelAttachmentGroup]
(
	[PersonUid] ASC,
	[VisitUid] ASC,
	[AttachmentGroupUid] ASC
)
INCLUDE ( 	[AccountResponsiblePartyUid],
	[IncludeInSummary],
	[Inactive],
	[DepositUid],
	[RelAttachmentGroupUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelAttachmentGroup]') AND name = N'IDX_ObservationOrderUid_VisitUid_AttachmentGroupUid')
CREATE NONCLUSTERED INDEX [IDX_ObservationOrderUid_VisitUid_AttachmentGroupUid] ON [dbo].[RelAttachmentGroup]
(
	[ObservationOrderUid] ASC,
	[VisitUid] ASC,
	[AttachmentGroupUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelAttachmentGroup]') AND name = N'IX_AccountResponsibleParty')
CREATE NONCLUSTERED INDEX [IX_AccountResponsibleParty] ON [dbo].[RelAttachmentGroup]
(
	[AccountResponsiblePartyUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelAttachmentGroup]') AND name = N'IX_AttachmentGroup')
CREATE NONCLUSTERED INDEX [IX_AttachmentGroup] ON [dbo].[RelAttachmentGroup]
(
	[AttachmentGroupUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelAttachmentGroup]') AND name = N'IX_Deposit')
CREATE NONCLUSTERED INDEX [IX_Deposit] ON [dbo].[RelAttachmentGroup]
(
	[DepositUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelAttachmentGroup]') AND name = N'IX_Message')
CREATE NONCLUSTERED INDEX [IX_Message] ON [dbo].[RelAttachmentGroup]
(
	[MessageUid] ASC
)
INCLUDE ( 	[AttachmentGroupUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelAttachmentGroup]') AND name = N'IX_PatientProcedureUid')
CREATE NONCLUSTERED INDEX [IX_PatientProcedureUid] ON [dbo].[RelAttachmentGroup]
(
	[PatientProcedureHistoryUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelAttachmentGroup]') AND name = N'IX_PatientReferralUid')
CREATE NONCLUSTERED INDEX [IX_PatientReferralUid] ON [dbo].[RelAttachmentGroup]
(
	[PatientReferralUid] ASC
)
INCLUDE ( 	[AttachmentGroupUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelAttachmentGroup]') AND name = N'IX_Person')
CREATE NONCLUSTERED INDEX [IX_Person] ON [dbo].[RelAttachmentGroup]
(
	[PersonUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelAttachmentGroup]') AND name = N'IX_Person_Visit')
CREATE NONCLUSTERED INDEX [IX_Person_Visit] ON [dbo].[RelAttachmentGroup]
(
	[PersonUid] ASC,
	[VisitUid] ASC
)
INCLUDE ( 	[AttachmentGroupUid],
	[AccountResponsiblePartyUid],
	[DepositUid],
	[IncludeInSummary],
	[Inactive]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelAttachmentGroup]') AND name = N'ix_RelAttachmentGroup_PatientProviderRelationshipUid')
CREATE NONCLUSTERED INDEX [ix_RelAttachmentGroup_PatientProviderRelationshipUid] ON [dbo].[RelAttachmentGroup]
(
	[PatientProviderRelationshipUid] ASC
)
INCLUDE ( 	[RelAttachmentGroupUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelAttachmentGroup]') AND name = N'IX_RelAttachmentGroup_PersonUid_ObservationOrderUid')
CREATE NONCLUSTERED INDEX [IX_RelAttachmentGroup_PersonUid_ObservationOrderUid] ON [dbo].[RelAttachmentGroup]
(
	[PersonUid] ASC,
	[ObservationOrderUid] ASC
)
INCLUDE ( 	[RelAttachmentGroupUid],
	[AttachmentGroupUid],
	[VisitUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelAttachmentGroup]') AND name = N'IX_Visit')
CREATE NONCLUSTERED INDEX [IX_Visit] ON [dbo].[RelAttachmentGroup]
(
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelAttachmentGroup]') AND name = N'ObservationOrderUid_LastModifiedDate')
CREATE NONCLUSTERED INDEX [ObservationOrderUid_LastModifiedDate] ON [dbo].[RelAttachmentGroup]
(
	[ObservationOrderUid] ASC,
	[LastModifiedDate] ASC
)
INCLUDE ( 	[AttachmentGroupUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelAuditSuperbill]') AND name = N'IX_Superbill')
CREATE NONCLUSTERED INDEX [IX_Superbill] ON [dbo].[RelAuditSuperbill]
(
	[SuperbillUid] ASC
)
INCLUDE ( 	[AuditUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCacheMachineAppointment]') AND name = N'IX_CacheMachine')
CREATE NONCLUSTERED INDEX [IX_CacheMachine] ON [dbo].[RelCacheMachineAppointment]
(
	[CacheMachineUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCacheMachineAppointment]') AND name = N'IX_CacheMachine_Appointment')
CREATE UNIQUE NONCLUSTERED INDEX [IX_CacheMachine_Appointment] ON [dbo].[RelCacheMachineAppointment]
(
	[CacheMachineUid] ASC,
	[AppointmentUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCacheMachineFinancialCenter]') AND name = N'IX_CacheMachine_FinancialCenter')
CREATE UNIQUE NONCLUSTERED INDEX [IX_CacheMachine_FinancialCenter] ON [dbo].[RelCacheMachineFinancialCenter]
(
	[CacheMachineUid] ASC,
	[FinancialCenterUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCacheMachineFinancialCenter]') AND name = N'IX_CacheMachineUid')
CREATE NONCLUSTERED INDEX [IX_CacheMachineUid] ON [dbo].[RelCacheMachineFinancialCenter]
(
	[CacheMachineUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCacheMachineFinancialCenter]') AND name = N'IX_FinancialCenterUid')
CREATE NONCLUSTERED INDEX [IX_FinancialCenterUid] ON [dbo].[RelCacheMachineFinancialCenter]
(
	[FinancialCenterUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCacheMachineMessage]') AND name = N'IDX_RelCacheMachineMessage_Action_CurrentAction')
CREATE NONCLUSTERED INDEX [IDX_RelCacheMachineMessage_Action_CurrentAction] ON [dbo].[RelCacheMachineMessage]
(
	[Action] ASC,
	[CurrentAction] ASC
)
INCLUDE ( 	[CacheMachineMessageUid],
	[CacheMachineUid],
	[MessageUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCacheMachineMessage]') AND name = N'IDX_RelCacheMachineMessage_CacheMachineUid_CurrentAction')
CREATE NONCLUSTERED INDEX [IDX_RelCacheMachineMessage_CacheMachineUid_CurrentAction] ON [dbo].[RelCacheMachineMessage]
(
	[CacheMachineUid] ASC,
	[CurrentAction] ASC
)
INCLUDE ( 	[MessageUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCacheMachineMessage]') AND name = N'IX_CacheMachine')
CREATE NONCLUSTERED INDEX [IX_CacheMachine] ON [dbo].[RelCacheMachineMessage]
(
	[CacheMachineUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCacheMachineMessage]') AND name = N'IX_CacheMachine_Message')
CREATE NONCLUSTERED INDEX [IX_CacheMachine_Message] ON [dbo].[RelCacheMachineMessage]
(
	[CacheMachineUid] ASC,
	[MessageUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCacheMachineMessage]') AND name = N'IX_RCMM_CacheMachineUid_CacheMachineMessageUid_Action_CurrentAction')
CREATE NONCLUSTERED INDEX [IX_RCMM_CacheMachineUid_CacheMachineMessageUid_Action_CurrentAction] ON [dbo].[RelCacheMachineMessage]
(
	[CacheMachineUid] ASC
)
INCLUDE ( 	[CacheMachineMessageUid],
	[Action],
	[CurrentAction]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCacheMachinePatient]') AND name = N'IDX_RelCacheMachinePatient_CacheMachineUid')
CREATE NONCLUSTERED INDEX [IDX_RelCacheMachinePatient_CacheMachineUid] ON [dbo].[RelCacheMachinePatient]
(
	[CacheMachineUid] ASC
)
INCLUDE ( 	[CacheMachinePatientUid],
	[PatientUid],
	[Action],
	[CurrentAction]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCacheMachinePatient]') AND name = N'IX_CacheMachine')
CREATE NONCLUSTERED INDEX [IX_CacheMachine] ON [dbo].[RelCacheMachinePatient]
(
	[CacheMachineUid] ASC
)
INCLUDE ( 	[PatientUid],
	[Action],
	[CurrentAction],
	[PurgeDate],
	[LastPurgeSyncReceivedAnchor]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCacheMachinePatient]') AND name = N'IX_CacheMachine_Patient')
CREATE UNIQUE NONCLUSTERED INDEX [IX_CacheMachine_Patient] ON [dbo].[RelCacheMachinePatient]
(
	[CacheMachineUid] ASC,
	[PatientUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCacheMachinePatient]') AND name = N'IX_CacheMachineUid_PatientUid_CurrentAction')
CREATE NONCLUSTERED INDEX [IX_CacheMachineUid_PatientUid_CurrentAction] ON [dbo].[RelCacheMachinePatient]
(
	[CacheMachineUid] ASC
)
INCLUDE ( 	[PatientUid],
	[CurrentAction]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCacheMachinePatient]') AND name = N'IX_Patient')
CREATE NONCLUSTERED INDEX [IX_Patient] ON [dbo].[RelCacheMachinePatient]
(
	[PatientUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCacheMachineProvider]') AND name = N'IX_CacheMachine_Provider')
CREATE UNIQUE NONCLUSTERED INDEX [IX_CacheMachine_Provider] ON [dbo].[RelCacheMachineProvider]
(
	[CacheMachineUid] ASC,
	[ProviderUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCacheMachineProvider]') AND name = N'IX_CacheMachineUid')
CREATE NONCLUSTERED INDEX [IX_CacheMachineUid] ON [dbo].[RelCacheMachineProvider]
(
	[CacheMachineUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCacheMachineProvider]') AND name = N'IX_ProviderUid')
CREATE NONCLUSTERED INDEX [IX_ProviderUid] ON [dbo].[RelCacheMachineProvider]
(
	[ProviderUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCacheMachineUserPRM]') AND name = N'IX_CacheMachine_UserPRM')
CREATE UNIQUE NONCLUSTERED INDEX [IX_CacheMachine_UserPRM] ON [dbo].[RelCacheMachineUserPRM]
(
	[CacheMachineUid] ASC,
	[UserPRMUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCacheMachineUserPRM]') AND name = N'IX_CacheMachineUid')
CREATE NONCLUSTERED INDEX [IX_CacheMachineUid] ON [dbo].[RelCacheMachineUserPRM]
(
	[CacheMachineUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCacheMachineUserPRM]') AND name = N'IX_UserPRMUid')
CREATE NONCLUSTERED INDEX [IX_UserPRMUid] ON [dbo].[RelCacheMachineUserPRM]
(
	[UserPRMUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCalendarCalendarTemplateHead]') AND name = N'IX_CalendarTemplateHead')
CREATE NONCLUSTERED INDEX [IX_CalendarTemplateHead] ON [dbo].[RelCalendarCalendarTemplateHead]
(
	[CalendarTemplateHeadUid] ASC
)
INCLUDE ( 	[CalendarUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCalendarCalendarTemplateHead]') AND name = N'ix_RelCalendarCalendarTemplateHead_CalendarUidEndDate')
CREATE NONCLUSTERED INDEX [ix_RelCalendarCalendarTemplateHead_CalendarUidEndDate] ON [dbo].[RelCalendarCalendarTemplateHead]
(
	[CalendarUid] ASC,
	[EndDate] ASC
)
INCLUDE ( 	[RelCalendarCalendarTemplateHeadUid],
	[CalendarTemplateHeadUid],
	[StartDate],
	[RecurrencePattern],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCalendarCalendarTemplateHead]') AND name = N'ix_RelCalendarCalendarTemplateHead_CalendarUidStartDate_EndDate')
CREATE NONCLUSTERED INDEX [ix_RelCalendarCalendarTemplateHead_CalendarUidStartDate_EndDate] ON [dbo].[RelCalendarCalendarTemplateHead]
(
	[CalendarUid] ASC,
	[StartDate] ASC,
	[EndDate] ASC
)
INCLUDE ( 	[RelCalendarCalendarTemplateHeadUid],
	[CalendarTemplateHeadUid],
	[ZIndex],
	[RecurrencePattern],
	[LastModifiedByUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCalendarTemplateHeadDaySlotExclude]') AND name = N'IX_AppointmentUid')
CREATE NONCLUSTERED INDEX [IX_AppointmentUid] ON [dbo].[RelCalendarTemplateHeadDaySlotExclude]
(
	[AppointmentUid] ASC
)
INCLUDE ( 	[RelCalendarTemplateHeadDaySlotExcludeUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCalendarTemplateHeadDaySlotExclude]') AND name = N'ix_RelCalendarTemplateHeadDaySlotExclude_RelCalendarCalendarTemplateHeadUidDate')
CREATE NONCLUSTERED INDEX [ix_RelCalendarTemplateHeadDaySlotExclude_RelCalendarCalendarTemplateHeadUidDate] ON [dbo].[RelCalendarTemplateHeadDaySlotExclude]
(
	[RelCalendarCalendarTemplateHeadUid] ASC,
	[Date] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCaseAuthorizationCodeSet]') AND name = N'IX_CaseAuthorizationUid')
CREATE NONCLUSTERED INDEX [IX_CaseAuthorizationUid] ON [dbo].[RelCaseAuthorizationCodeSet]
(
	[CaseAuthorizationUid] ASC
)
INCLUDE ( 	[RelCaseAuthorizationCodeSetUid],
	[CaseAuthorizationCodeSetUid],
	[Units],
	[AuthorizationCode],
	[ExpirationDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCCSymptomHpi]') AND name = N'CIDX_RelCCSymptomHpiCategoryUid_AgeGroupUid_RelCCSymptomHpiUid_HpiUid')
CREATE NONCLUSTERED INDEX [CIDX_RelCCSymptomHpiCategoryUid_AgeGroupUid_RelCCSymptomHpiUid_HpiUid] ON [dbo].[RelCCSymptomHpi]
(
	[UserDefined] ASC,
	[AgeGroupUid] ASC,
	[RelCCSymptomHpiUid] ASC,
	[HpiUid] ASC
)
INCLUDE ( 	[RelCCSymptomHpiCategoryUid],
	[DisplayOrder]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCCSymptomHpi]') AND name = N'IDXI_RelCCSymptomHpi_HpiUid')
CREATE NONCLUSTERED INDEX [IDXI_RelCCSymptomHpi_HpiUid] ON [dbo].[RelCCSymptomHpi]
(
	[HpiUid] ASC
)
INCLUDE ( 	[RelCCSymptomHpiCategoryUid],
	[DisplayOrder],
	[AgeGroupUid],
	[GenderUid],
	[SnomedConceptID],
	[DescriptionUid],
	[ProcedureUid],
	[ProcedurePerformed],
	[DiagnosisCode9],
	[DiagnosisCode10],
	[DiagnosisDescription],
	[UserDefined],
	[ClinicCenterOverride],
	[ProviderOverride],
	[LastModifiedByUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCCSymptomHpi]') AND name = N'IX_LastModifiedDate')
CREATE NONCLUSTERED INDEX [IX_LastModifiedDate] ON [dbo].[RelCCSymptomHpi]
(
	[LastModifiedDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCCSymptomHpi]') AND name = N'IX_RelCCSymptomHpiCategory_RelCCSymptomHpi_Hpi')
CREATE NONCLUSTERED INDEX [IX_RelCCSymptomHpiCategory_RelCCSymptomHpi_Hpi] ON [dbo].[RelCCSymptomHpi]
(
	[RelCCSymptomHpiCategoryUid] ASC,
	[RelCCSymptomHpiUid] ASC,
	[HpiUid] ASC
)
INCLUDE ( 	[DisplayOrder],
	[AgeGroupUid],
	[ClinicCenterOverride],
	[ProviderOverride]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCCSymptomHpi]') AND name = N'IX_RelCCSymptomHpiCategoryUid_HpiUid')
CREATE UNIQUE NONCLUSTERED INDEX [IX_RelCCSymptomHpiCategoryUid_HpiUid] ON [dbo].[RelCCSymptomHpi]
(
	[RelCCSymptomHpiCategoryUid] ASC,
	[HpiUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCCSymptomHpi]') AND name = N'RelCCSymptomHpiCategory_AgeGroup')
CREATE NONCLUSTERED INDEX [RelCCSymptomHpiCategory_AgeGroup] ON [dbo].[RelCCSymptomHpi]
(
	[RelCCSymptomHpiCategoryUid] ASC,
	[AgeGroupUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCCSymptomHpiCategory]') AND name = N'HpiCategoryUid')
CREATE NONCLUSTERED INDEX [HpiCategoryUid] ON [dbo].[RelCCSymptomHpiCategory]
(
	[HpiCategoryUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCCSymptomHpiCategory]') AND name = N'IX_RelCCSystemSymptom_RelCCSymptomHpiCategory_HpiCategory')
CREATE NONCLUSTERED INDEX [IX_RelCCSystemSymptom_RelCCSymptomHpiCategory_HpiCategory] ON [dbo].[RelCCSymptomHpiCategory]
(
	[RelCCSystemSymptomUid] ASC,
	[RelCCSymptomHpiCategoryUid] ASC,
	[HpiCategoryUid] ASC
)
INCLUDE ( 	[DisplayOrder],
	[AgeGroupUid],
	[ClinicCenterOverride],
	[ProviderOverride]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCCSymptomHpiCategory]') AND name = N'IX_RelCCSystemSymptomUid_HpiCategoryUid')
CREATE UNIQUE NONCLUSTERED INDEX [IX_RelCCSystemSymptomUid_HpiCategoryUid] ON [dbo].[RelCCSymptomHpiCategory]
(
	[RelCCSystemSymptomUid] ASC,
	[HpiCategoryUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCCSymptomHpiCategory]') AND name = N'RelCCSymptomHpiCategory_Symptom_Hpi')
CREATE NONCLUSTERED INDEX [RelCCSymptomHpiCategory_Symptom_Hpi] ON [dbo].[RelCCSymptomHpiCategory]
(
	[RelCCSymptomHpiCategoryUid] ASC,
	[RelCCSystemSymptomUid] ASC,
	[HpiCategoryUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCCSystemSymptom]') AND name = N'IX_CCSymtpom')
CREATE NONCLUSTERED INDEX [IX_CCSymtpom] ON [dbo].[RelCCSystemSymptom]
(
	[CCSymptomUid] ASC
)
INCLUDE ( 	[RelCCSystemSymptomUid],
	[CCSystemUid],
	[DisplayOrder],
	[AgeGroupUid],
	[UserDefined],
	[Preposition],
	[LicenseCode],
	[ClinicCenterOverride],
	[ProviderOverride],
	[Inactive]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelCCSystemSymptom]') AND name = N'IX_CCSystemUid_CCSymptomUid')
CREATE UNIQUE NONCLUSTERED INDEX [IX_CCSystemUid_CCSymptomUid] ON [dbo].[RelCCSystemSymptom]
(
	[CCSystemUid] ASC,
	[CCSymptomUid] ASC
)
INCLUDE ( 	[RelCCSystemSymptomUid],
	[DisplayOrder],
	[UserDefined],
	[Preposition],
	[Inactive]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelChargeTicketCategoryDiagnosis]') AND name = N'IX_RelChargeTicketCategoryDiagnosisUid')
CREATE UNIQUE NONCLUSTERED INDEX [IX_RelChargeTicketCategoryDiagnosisUid] ON [dbo].[RelChargeTicketCategoryDiagnosis]
(
	[ChargeTicketDiagnosisUid] ASC,
	[DiagnosisCategoryUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelChargeTicketCategorySO]') AND name = N'IX_RelChargeTicketCategorySO')
CREATE UNIQUE NONCLUSTERED INDEX [IX_RelChargeTicketCategorySO] ON [dbo].[RelChargeTicketCategorySO]
(
	[ChargeTicketSOUid] ASC,
	[ProcedureCategoryUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelChargeTicketCategorySP]') AND name = N'IX_RelChargeTicketCategorySP')
CREATE UNIQUE NONCLUSTERED INDEX [IX_RelChargeTicketCategorySP] ON [dbo].[RelChargeTicketCategorySP]
(
	[ChargeTicketSPUid] ASC,
	[ProcedureCategoryUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelChargeTicketDiagnosis]') AND name = N'IX_RelChargeTicketDiagnosis')
CREATE NONCLUSTERED INDEX [IX_RelChargeTicketDiagnosis] ON [dbo].[RelChargeTicketDiagnosis]
(
	[RelChargeTicketCategoryDiagnosisUid] ASC,
	[DiagnosisPanelUid] ASC,
	[Code9] ASC,
	[Code10] ASC,
	[SearchDefinition] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelChargeTicketSO]') AND name = N'IX_RelChargeTicketSO')
CREATE UNIQUE NONCLUSTERED INDEX [IX_RelChargeTicketSO] ON [dbo].[RelChargeTicketSO]
(
	[RelChargeTicketCategorySOUid] ASC,
	[ProcedurePanelUid] ASC,
	[ProcedureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelChargeTicketSP]') AND name = N'IX_RelChargeTicketSP')
CREATE UNIQUE NONCLUSTERED INDEX [IX_RelChargeTicketSP] ON [dbo].[RelChargeTicketSP]
(
	[RelChargeTicketCategorySPUid] ASC,
	[ProcedurePanelUid] ASC,
	[ProcedureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelDiagnosisDisease]') AND name = N'ix_RelDiagnosisDisease_Code9Code10')
CREATE NONCLUSTERED INDEX [ix_RelDiagnosisDisease_Code9Code10] ON [dbo].[RelDiagnosisDisease]
(
	[Code9] ASC,
	[Code10] ASC
)
INCLUDE ( 	[DiseaseUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelDiagnosisDisease]') AND name = N'ix_RelDiagnosisDisease_DiseaseUid')
CREATE NONCLUSTERED INDEX [ix_RelDiagnosisDisease_DiseaseUid] ON [dbo].[RelDiagnosisDisease]
(
	[DiseaseUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelDiagnosisDisease]') AND name = N'ix_RelDiagnosisDisease_DiseaseUid_Code9')
CREATE NONCLUSTERED INDEX [ix_RelDiagnosisDisease_DiseaseUid_Code9] ON [dbo].[RelDiagnosisDisease]
(
	[DiseaseUid] ASC,
	[Code9] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelDiagnosisPanelDiagnosis]') AND name = N'IX_DiagnosisPanel')
CREATE NONCLUSTERED INDEX [IX_DiagnosisPanel] ON [dbo].[RelDiagnosisPanelDiagnosis]
(
	[DiagnosisPanelUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelDispensableRxCodes]') AND name = N'IX_RelDispensableRxCodes_DispensableUid')
ALTER TABLE [dbo].[RelDispensableRxCodes] ADD  CONSTRAINT [IX_RelDispensableRxCodes_DispensableUid] UNIQUE NONCLUSTERED 
(
	[DispensableUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelDispensableRxCodes]') AND name = N'IX_RelDispensableRxCodes_RxNorm')
ALTER TABLE [dbo].[RelDispensableRxCodes] ADD  CONSTRAINT [IX_RelDispensableRxCodes_RxNorm] UNIQUE NONCLUSTERED 
(
	[RxNorm] ASC,
	[DispensableUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelDpnGroupDpnNode]') AND name = N'IX_DpnGroupUid')
CREATE NONCLUSTERED INDEX [IX_DpnGroupUid] ON [dbo].[RelDpnGroupDpnNode]
(
	[DpnGroupUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelDpnGroupOrderAction]') AND name = N'IX_DpnGroup')
CREATE NONCLUSTERED INDEX [IX_DpnGroup] ON [dbo].[RelDpnGroupOrderAction]
(
	[DpnGroupUid] ASC
)
INCLUDE ( 	[RelDpnGroupOrderActionUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelEduFormAssociation]') AND name = N'IX_EduFormGroupForm')
CREATE UNIQUE NONCLUSTERED INDEX [IX_EduFormGroupForm] ON [dbo].[RelEduFormAssociation]
(
	[EduFormAssociationUid] ASC,
	[EduFormUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelEduFormCCSymptom]') AND name = N'IX_RelEduFormCCSymptom')
CREATE UNIQUE NONCLUSTERED INDEX [IX_RelEduFormCCSymptom] ON [dbo].[RelEduFormCCSymptom]
(
	[RelEduFormAssociationUid] ASC,
	[RelCCSystemSymptomUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelEduFormProcedure]') AND name = N'IX_RelEduFormProcedure')
CREATE UNIQUE NONCLUSTERED INDEX [IX_RelEduFormProcedure] ON [dbo].[RelEduFormProcedure]
(
	[RelEduFormAssociationUid] ASC,
	[ProcedureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelFilterNotification]') AND name = N'IX_FilterUid')
CREATE NONCLUSTERED INDEX [IX_FilterUid] ON [dbo].[RelFilterNotification]
(
	[FilterUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelFilterUserPRM]') AND name = N'IX_Type_SubType_Filter_User')
CREATE UNIQUE NONCLUSTERED INDEX [IX_Type_SubType_Filter_User] ON [dbo].[RelFilterUserPRM]
(
	[Type] ASC,
	[SubType] ASC,
	[FilterUid] ASC,
	[UserPrmUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelFindTableHide]') AND name = N'IX_FindTable')
CREATE NONCLUSTERED INDEX [IX_FindTable] ON [dbo].[RelFindTableHide]
(
	[FindTableUid] ASC,
	[UserUid] ASC
)
INCLUDE ( 	[Uid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelFindTableHide]') AND name = N'IX_Unique')
CREATE UNIQUE NONCLUSTERED INDEX [IX_Unique] ON [dbo].[RelFindTableHide]
(
	[FindTableUid] ASC,
	[UserGroupUid] ASC,
	[UserUid] ASC,
	[Uid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelFindTableMFU]') AND name = N'IX_FindTable')
CREATE NONCLUSTERED INDEX [IX_FindTable] ON [dbo].[RelFindTableMFU]
(
	[FindTableUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelFindTableMFU]') AND name = N'IX_FindTable_User')
CREATE NONCLUSTERED INDEX [IX_FindTable_User] ON [dbo].[RelFindTableMFU]
(
	[FindTableUid] ASC,
	[UserUid] ASC
)
INCLUDE ( 	[RelFindTableMFUUid],
	[Uid],
	[Count],
	[Exclude],
	[LastModifiedByUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelFindTableMFU]') AND name = N'IX_FindTable_User_Exclude')
CREATE NONCLUSTERED INDEX [IX_FindTable_User_Exclude] ON [dbo].[RelFindTableMFU]
(
	[FindTableUid] ASC,
	[UserUid] ASC,
	[Exclude] ASC
)
INCLUDE ( 	[Count],
	[Uid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelFindTableMFU]') AND name = N'ix_RelFindTableMFU_FindControlBehaviorUid_UserUid_Exclude')
CREATE NONCLUSTERED INDEX [ix_RelFindTableMFU_FindControlBehaviorUid_UserUid_Exclude] ON [dbo].[RelFindTableMFU]
(
	[FindControlBehaviorUid] ASC,
	[UserUid] ASC,
	[Exclude] ASC
)
INCLUDE ( 	[Uid],
	[Count]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelFindTableMFU]') AND name = N'IX_RelFindTableMFU_Unique')
CREATE UNIQUE NONCLUSTERED INDEX [IX_RelFindTableMFU_Unique] ON [dbo].[RelFindTableMFU]
(
	[FindTableUid] ASC,
	[Uid] ASC,
	[UserUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelFindTableMFUDiagnosis]') AND name = N'IX_User')
CREATE NONCLUSTERED INDEX [IX_User] ON [dbo].[RelFindTableMFUDiagnosis]
(
	[UserUid] ASC
)
INCLUDE ( 	[RelFindTableMFUDiagnosisUid],
	[LexCode],
	[Code09],
	[Code10],
	[CodeDescription],
	[Count],
	[Exclude],
	[LastModifiedByUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelFindTableMRU]') AND name = N'IX_FindTable_User')
CREATE NONCLUSTERED INDEX [IX_FindTable_User] ON [dbo].[RelFindTableMRU]
(
	[FindTableUid] ASC,
	[UserUid] ASC
)
INCLUDE ( 	[Uid],
	[Exclude],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelFindTableMRU]') AND name = N'IX_FindTable_User_Exclude')
CREATE NONCLUSTERED INDEX [IX_FindTable_User_Exclude] ON [dbo].[RelFindTableMRU]
(
	[FindTableUid] ASC,
	[UserUid] ASC,
	[Exclude] ASC
)
INCLUDE ( 	[MRUOrder],
	[Uid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelFindTableMRU]') AND name = N'IX_FindTableUid_UserUid')
CREATE NONCLUSTERED INDEX [IX_FindTableUid_UserUid] ON [dbo].[RelFindTableMRU]
(
	[FindTableUid] ASC,
	[UserUid] ASC
)
INCLUDE ( 	[RelFindTableMRUUid],
	[Uid],
	[MRUOrder],
	[Exclude],
	[LastModifiedByUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelFindTableMRU]') AND name = N'ix_RelFindTableMRU_FindControlBehaviorUid_UserUid_Exclude')
CREATE NONCLUSTERED INDEX [ix_RelFindTableMRU_FindControlBehaviorUid_UserUid_Exclude] ON [dbo].[RelFindTableMRU]
(
	[FindControlBehaviorUid] ASC,
	[UserUid] ASC,
	[Exclude] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelFindTableMRU]') AND name = N'IX_RelFindTableMRU_Unique')
CREATE UNIQUE NONCLUSTERED INDEX [IX_RelFindTableMRU_Unique] ON [dbo].[RelFindTableMRU]
(
	[FindTableUid] ASC,
	[Uid] ASC,
	[UserUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelFindTableMRU]') AND name = N'IX_User')
CREATE NONCLUSTERED INDEX [IX_User] ON [dbo].[RelFindTableMRU]
(
	[UserUid] ASC
)
INCLUDE ( 	[RelFindTableMRUUid],
	[FindTableUid],
	[Uid],
	[MRUOrder],
	[Exclude],
	[LastModifiedByUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelFormLayoutClinicalNoteType]') AND name = N'IX_ClinicalNoteType')
CREATE NONCLUSTERED INDEX [IX_ClinicalNoteType] ON [dbo].[RelFormLayoutClinicalNoteType]
(
	[ClinicalNoteTypeUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelFormLayoutUserSetting]') AND name = N'IX_UserSetting')
CREATE NONCLUSTERED INDEX [IX_UserSetting] ON [dbo].[RelFormLayoutUserSetting]
(
	[UserSettingUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelGroupAppointmentPatient]') AND name = N'IX_Appointment')
CREATE NONCLUSTERED INDEX [IX_Appointment] ON [dbo].[RelGroupAppointmentPatient]
(
	[AppointmentUid] ASC
)
INCLUDE ( 	[PatientUid],
	[AppointmentStatusUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelGroupAppointmentPatient]') AND name = N'IX_Patient')
CREATE NONCLUSTERED INDEX [IX_Patient] ON [dbo].[RelGroupAppointmentPatient]
(
	[PatientUid] ASC
)
INCLUDE ( 	[AppointmentUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelGroupAppointmentPatient]') AND name = N'IX_Patient_Appointment_Account')
CREATE NONCLUSTERED INDEX [IX_Patient_Appointment_Account] ON [dbo].[RelGroupAppointmentPatient]
(
	[AppointmentUid] ASC,
	[PatientUid] ASC,
	[AccountUid] ASC
)
INCLUDE ( 	[AppointmentStatusUid],
	[PatientGroupUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelHL7PartnerPatientConsent]') AND name = N'ix_RelHL7PartnerPatientConsent_HL7PartnerUid_PatientUid')
CREATE NONCLUSTERED INDEX [ix_RelHL7PartnerPatientConsent_HL7PartnerUid_PatientUid] ON [dbo].[RelHL7PartnerPatientConsent]
(
	[HL7PartnerUid] ASC,
	[PatientUid] ASC
)
INCLUDE ( 	[ConsentAgreed]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelHL7PartnerPatientConsent]') AND name = N'ix_RelHL7PartnerPatientConsent_PatientUid_IntegrationPartnerUid')
CREATE NONCLUSTERED INDEX [ix_RelHL7PartnerPatientConsent_PatientUid_IntegrationPartnerUid] ON [dbo].[RelHL7PartnerPatientConsent]
(
	[PatientUid] ASC,
	[IntegrationPartnerUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelHMRuleClinicCenter]') AND name = N'IX_RelHMRuleClinicCenter')
ALTER TABLE [dbo].[RelHMRuleClinicCenter] ADD  CONSTRAINT [IX_RelHMRuleClinicCenter] UNIQUE NONCLUSTERED 
(
	[ClinicCenterUid] ASC,
	[HMRuleUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelHMRuleDisease]') AND name = N'IDX_RelHMRuleDisease')
CREATE UNIQUE NONCLUSTERED INDEX [IDX_RelHMRuleDisease] ON [dbo].[RelHMRuleDisease]
(
	[HMRuleUid] ASC,
	[DiseaseUid] ASC,
	[Name] ASC
)
INCLUDE ( 	[RelHMRuleDiseaseUid],
	[DisplayOrder],
	[UserDefined],
	[LastModifiedByUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelHMRuleDisease]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[RelHMRuleDisease]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelHMRuleDrugAllergy]') AND name = N'IDX_RelHMRuleDrugAllergy')
CREATE UNIQUE NONCLUSTERED INDEX [IDX_RelHMRuleDrugAllergy] ON [dbo].[RelHMRuleDrugAllergy]
(
	[HMRuleUid] ASC,
	[QuestionUid] ASC,
	[Name] ASC
)
INCLUDE ( 	[RelHMRuleDrugAllergyUid],
	[DisplayOrder],
	[UserDefined],
	[LastModifiedByUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelHMRuleDrugClass]') AND name = N'IDX_RelHMRuleDrugClass')
CREATE UNIQUE NONCLUSTERED INDEX [IDX_RelHMRuleDrugClass] ON [dbo].[RelHMRuleDrugClass]
(
	[HMRuleUid] ASC,
	[ClassUid] ASC,
	[FDB_CLASSID] ASC
)
INCLUDE ( 	[RelHMRuleDrugClassUid],
	[UserDefined],
	[LastModifiedByUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelHMRuleDrugName]') AND name = N'IDX_RelHMRuleDrugName')
CREATE UNIQUE NONCLUSTERED INDEX [IDX_RelHMRuleDrugName] ON [dbo].[RelHMRuleDrugName]
(
	[HMRuleUid] ASC,
	[DrugNameUid] ASC,
	[FDB_MNID] ASC
)
INCLUDE ( 	[RelHMRuleDrugNameUid],
	[UserDefined],
	[LastModifiedByUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelHMRuleProcedure]') AND name = N'IDX_RelHMRuleProcedure')
CREATE UNIQUE NONCLUSTERED INDEX [IDX_RelHMRuleProcedure] ON [dbo].[RelHMRuleProcedure]
(
	[HMRuleUid] ASC,
	[ProcedureUid] ASC,
	[Name] ASC
)
INCLUDE ( 	[RelHMRuleProcedureUid],
	[DisplayOrder],
	[UserDefined],
	[LastModifiedByUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelHMRuleProcedure]') AND name = N'IX_HMRuleUid')
CREATE NONCLUSTERED INDEX [IX_HMRuleUid] ON [dbo].[RelHMRuleProcedure]
(
	[HMRuleUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelHMRuleProcedure]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[RelHMRuleProcedure]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelHospitalRoundDiagnosis]') AND name = N'IX_HospitalRound')
CREATE NONCLUSTERED INDEX [IX_HospitalRound] ON [dbo].[RelHospitalRoundDiagnosis]
(
	[HospitalRoundUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelHospitalRoundProvider]') AND name = N'IDX_RelHospitalRoundProvider_ProviderUid_HospitalRoundUid')
CREATE NONCLUSTERED INDEX [IDX_RelHospitalRoundProvider_ProviderUid_HospitalRoundUid] ON [dbo].[RelHospitalRoundProvider]
(
	[ProviderUid] ASC
)
INCLUDE ( 	[HospitalRoundUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelHospitalRoundProvider]') AND name = N'IX_HospitalRound')
CREATE NONCLUSTERED INDEX [IX_HospitalRound] ON [dbo].[RelHospitalRoundProvider]
(
	[HospitalRoundUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelIntegrationPartnerServiceSite]') AND name = N'IX_RelIntegrationPartnerServiceSite_IntegrationPartnerServiceSite')
CREATE UNIQUE NONCLUSTERED INDEX [IX_RelIntegrationPartnerServiceSite_IntegrationPartnerServiceSite] ON [dbo].[RelIntegrationPartnerServiceSite]
(
	[IntegrationPartnerUid] ASC,
	[ServiceSiteUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelMedicationDiagnosis]') AND name = N'IX_MedicationSIGUid')
CREATE NONCLUSTERED INDEX [IX_MedicationSIGUid] ON [dbo].[RelMedicationDiagnosis]
(
	[MedicationSIGUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelMedicationProblem]') AND name = N'IX_MedicationSigUid')
CREATE NONCLUSTERED INDEX [IX_MedicationSigUid] ON [dbo].[RelMedicationProblem]
(
	[MedicationSIGUid] ASC
)
INCLUDE ( 	[RelMedicationProblemUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelMedicationProblem]') AND name = N'IX_RelMedicationProblem_MedicationSIGUid')
CREATE NONCLUSTERED INDEX [IX_RelMedicationProblem_MedicationSIGUid] ON [dbo].[RelMedicationProblem]
(
	[MedicationSIGUid] ASC
)
INCLUDE ( 	[RelMedicationProblemUid],
	[DiseaseUid],
	[DisplayOrder],
	[SnomedCTConceptId],
	[Inactive],
	[IsDelete],
	[LastModifiedByUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelMedicationStateScheduledDrugName]') AND name = N'IX_RelMedicationStateScheduledDrugName_conceptId')
ALTER TABLE [dbo].[RelMedicationStateScheduledDrugName] ADD  CONSTRAINT [IX_RelMedicationStateScheduledDrugName_conceptId] UNIQUE NONCLUSTERED 
(
	[DrugNameUid] ASC,
	[MedicationStateScheduledUid] ASC,
	[RelMedicationStateScheduledDrugNameUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelMessageHL7ObservationOrder]') AND name = N'IX_MessageUid_inc')
CREATE NONCLUSTERED INDEX [IX_MessageUid_inc] ON [dbo].[RelMessageHL7ObservationOrder]
(
	[MessageUid] ASC
)
INCLUDE ( 	[ObservationOrderUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelMessageHL7ObservationOrder]') AND name = N'IX_ObservationOrderUid')
CREATE NONCLUSTERED INDEX [IX_ObservationOrderUid] ON [dbo].[RelMessageHL7ObservationOrder]
(
	[ObservationOrderUid] ASC
)
INCLUDE ( 	[MessageUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelObservationItemLaboratory]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[RelObservationItemLaboratory]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelObservationItemLaboratory]') AND name = N'IX_Laboratory_ObservationItem_StringMinMax')
CREATE NONCLUSTERED INDEX [IX_Laboratory_ObservationItem_StringMinMax] ON [dbo].[RelObservationItemLaboratory]
(
	[LaboratoryUid] ASC,
	[ObservationItemUid] ASC,
	[StringMin] ASC,
	[StringMax] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelObservationItemLaboratory]') AND name = N'IX_ObservationItem')
CREATE NONCLUSTERED INDEX [IX_ObservationItem] ON [dbo].[RelObservationItemLaboratory]
(
	[ObservationItemUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelObservationObservationItem]') AND name = N'IX_ObservationItem')
CREATE NONCLUSTERED INDEX [IX_ObservationItem] ON [dbo].[RelObservationObservationItem]
(
	[ObservationItemUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelObservationObservationItem]') AND name = N'IXR_ObservationUid')
CREATE NONCLUSTERED INDEX [IXR_ObservationUid] ON [dbo].[RelObservationObservationItem]
(
	[ObservationUid] ASC
)
INCLUDE ( 	[ObservationItemUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelOrderedProcedurePatientProcedureHistory]') AND name = N'ix_RelOrderedProcedurePatientProcedureHistory_VisitProcedureUid')
CREATE NONCLUSTERED INDEX [ix_RelOrderedProcedurePatientProcedureHistory_VisitProcedureUid] ON [dbo].[RelOrderedProcedurePatientProcedureHistory]
(
	[VisitProcedureUid] ASC
)
INCLUDE ( 	[PatientProcedureHistoryUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPatientCondition]') AND name = N'IX_RelPatientCondition_PatientUid')
CREATE NONCLUSTERED INDEX [IX_RelPatientCondition_PatientUid] ON [dbo].[RelPatientCondition]
(
	[PatientUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPatientMedication]') AND name = N'EnteredFromVisitUid')
CREATE NONCLUSTERED INDEX [EnteredFromVisitUid] ON [dbo].[RelPatientMedication]
(
	[EnteredFromVisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPatientMedication]') AND name = N'IX_MedicationSigUid')
CREATE NONCLUSTERED INDEX [IX_MedicationSigUid] ON [dbo].[RelPatientMedication]
(
	[MedicationSIGUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPatientMedication]') AND name = N'IX_Patient')
CREATE NONCLUSTERED INDEX [IX_Patient] ON [dbo].[RelPatientMedication]
(
	[PatientUid] ASC
)
INCLUDE ( 	[MedicationSIGUid],
	[RelVisitMedicationUid],
	[ActiveDate],
	[InactiveDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPatientMedication]') AND name = N'IX_RelPatientMedication_PatientUid')
CREATE NONCLUSTERED INDEX [IX_RelPatientMedication_PatientUid] ON [dbo].[RelPatientMedication]
(
	[PatientUid] ASC
)
INCLUDE ( 	[RelPatientMedicationUid],
	[MedicationSIGUid],
	[RelVisitMedicationUid],
	[ActiveDate],
	[InactiveDate],
	[IsPatientInput],
	[Notes],
	[EnteredFromVisitUid],
	[LastModifiedByUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPatientMedication]') AND name = N'IX_RelVisitMedicationUid')
CREATE NONCLUSTERED INDEX [IX_RelVisitMedicationUid] ON [dbo].[RelPatientMedication]
(
	[RelVisitMedicationUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPatientPersonWeb]') AND name = N'IDXI_RelPatientPersonWeb_PatientUid')
CREATE NONCLUSTERED INDEX [IDXI_RelPatientPersonWeb_PatientUid] ON [dbo].[RelPatientPersonWeb]
(
	[PatientUid] ASC
)
INCLUDE ( 	[PersonUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPatientPersonWeb]') AND name = N'IX_RelPatientPersonWeb')
CREATE NONCLUSTERED INDEX [IX_RelPatientPersonWeb] ON [dbo].[RelPatientPersonWeb]
(
	[PersonUid] ASC,
	[PatientUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPatientProgram]') AND name = N'IX_RelPatientProgram')
CREATE NONCLUSTERED INDEX [IX_RelPatientProgram] ON [dbo].[RelPatientProgram]
(
	[PatientUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPatientProgram]') AND name = N'IX_RelPatientProgram_PatientProgram')
CREATE NONCLUSTERED INDEX [IX_RelPatientProgram_PatientProgram] ON [dbo].[RelPatientProgram]
(
	[PatientProgramUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPatientProviderCDAFormatting]') AND name = N'IX_PatientProviderRelationship')
CREATE NONCLUSTERED INDEX [IX_PatientProviderRelationship] ON [dbo].[RelPatientProviderCDAFormatting]
(
	[PatientProviderRelationshipUid] ASC
)
INCLUDE ( 	[RelPatientProviderCDAFormattingUid],
	[FormattingTemplateUid],
	[CDASectionUid],
	[LastModifiedDate],
	[LastModifiedByUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPatientStatus]') AND name = N'IX_RelPatientStatus_PatientUid_PatientStatusUid')
CREATE NONCLUSTERED INDEX [IX_RelPatientStatus_PatientUid_PatientStatusUid] ON [dbo].[RelPatientStatus]
(
	[PatientUid] ASC,
	[PatientStatusUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPersonEthnicity]') AND name = N'IX_RelPersonEthnicity')
CREATE NONCLUSTERED INDEX [IX_RelPersonEthnicity] ON [dbo].[RelPersonEthnicity]
(
	[PersonUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPersonRace]') AND name = N'ix_RelPersonRace_PersonUid')
CREATE NONCLUSTERED INDEX [ix_RelPersonRace_PersonUid] ON [dbo].[RelPersonRace]
(
	[PersonUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPersonUIConfiguration]') AND name = N'IX_RelPersonUIConfiguration_1')
CREATE NONCLUSTERED INDEX [IX_RelPersonUIConfiguration_1] ON [dbo].[RelPersonUIConfiguration]
(
	[PersonUid] ASC,
	[UserGroupUid] ASC,
	[UIConfigurationUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPETemplateDescription]') AND name = N'IX_RelPETemplateDescription_SymptomUid_DescriptionUid')
CREATE NONCLUSTERED INDEX [IX_RelPETemplateDescription_SymptomUid_DescriptionUid] ON [dbo].[RelPETemplateDescription]
(
	[RelPETemplateSymptomUid] ASC,
	[PEDescriptionUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPETemplateDescription]') AND name = N'IX_RelPETemplateSymptom')
CREATE NONCLUSTERED INDEX [IX_RelPETemplateSymptom] ON [dbo].[RelPETemplateDescription]
(
	[RelPETemplateSymptomUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPETemplateDescription]') AND name = N'IX_RelPETemplateSymptom_AgeGroup_Gender')
CREATE NONCLUSTERED INDEX [IX_RelPETemplateSymptom_AgeGroup_Gender] ON [dbo].[RelPETemplateDescription]
(
	[RelPETemplateSymptomUid] ASC,
	[AgeGroupUid] ASC,
	[GenderUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPETemplateDescription]') AND name = N'IX_RelPETemplateSymptom_RelPETemplateDescription_PEDescription')
CREATE NONCLUSTERED INDEX [IX_RelPETemplateSymptom_RelPETemplateDescription_PEDescription] ON [dbo].[RelPETemplateDescription]
(
	[RelPETemplateSymptomUid] ASC,
	[RelPETemplateDescriptionUid] ASC,
	[PEDescriptionUid] ASC
)
INCLUDE ( 	[RelEMKeyComponentBulletUid],
	[DisplayOrder],
	[AgeGroupUid],
	[GenderUid],
	[NormalFlag],
	[DefaultFlag],
	[CountAsBullet],
	[UserDefined],
	[ClinicCenterOverride],
	[ProviderOverride]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPETemplateDescription]') AND name = N'PEDescription_Gender_AgeGroup_RelPETemplateDescription_RelPETemplateSymptom')
CREATE NONCLUSTERED INDEX [PEDescription_Gender_AgeGroup_RelPETemplateDescription_RelPETemplateSymptom] ON [dbo].[RelPETemplateDescription]
(
	[PEDescriptionUid] ASC,
	[GenderUid] ASC,
	[AgeGroupUid] ASC,
	[RelPETemplateDescriptionUid] ASC,
	[RelPETemplateSymptomUid] ASC
)
INCLUDE ( 	[RelEMKeyComponentBulletUid],
	[DisplayOrder],
	[NormalFlag],
	[DefaultFlag],
	[CountAsBullet]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPETemplateParentSystem]') AND name = N'IX_PETemplate_AgeGroup_Gender')
CREATE NONCLUSTERED INDEX [IX_PETemplate_AgeGroup_Gender] ON [dbo].[RelPETemplateParentSystem]
(
	[PETemplateUid] ASC,
	[AgeGroupUid] ASC,
	[GenderUid] ASC
)
INCLUDE ( 	[RelPETemplateParentSystemUid],
	[PEParentSystemUid],
	[ColorID],
	[DisplayOrder],
	[AllowsBilaterality],
	[ClinicCenterOverride],
	[ProviderOverride]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPETemplateSymptom]') AND name = N'IX_RelPETemplateSystem')
CREATE NONCLUSTERED INDEX [IX_RelPETemplateSystem] ON [dbo].[RelPETemplateSymptom]
(
	[RelPETemplateSystemUid] ASC
)
INCLUDE ( 	[AgeGroupUid],
	[GenderUid],
	[PESymptomUid],
	[DisplayOrder],
	[AllowsBilaterality],
	[ClinicCenterOverride],
	[ProviderOverride]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPETemplateSymptom]') AND name = N'IX_RelPETemplateSystem_PESymptom_RelPETemplateSymptom')
CREATE NONCLUSTERED INDEX [IX_RelPETemplateSystem_PESymptom_RelPETemplateSymptom] ON [dbo].[RelPETemplateSymptom]
(
	[RelPETemplateSystemUid] ASC,
	[PESymptomUid] ASC,
	[RelPETemplateSymptomUid] ASC
)
INCLUDE ( 	[RelEMKeyComponentBulletUid],
	[AgeGroupUid],
	[GenderUid],
	[AllowsBilaterality]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPETemplateSymptom]') AND name = N'RelPETemplateSystem_Gender_AgeGroup_RelPETemplateSymptom_PESymptom')
CREATE NONCLUSTERED INDEX [RelPETemplateSystem_Gender_AgeGroup_RelPETemplateSymptom_PESymptom] ON [dbo].[RelPETemplateSymptom]
(
	[RelEMKeyComponentBulletUid] ASC,
	[GenderUid] ASC,
	[AgeGroupUid] ASC,
	[RelPETemplateSymptomUid] ASC,
	[PESymptomUid] ASC
)
INCLUDE ( 	[DisplayOrder],
	[AllowsBilaterality],
	[RelPETemplateSystemUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPETemplateSymptom]') AND name = N'RelPETemplateSystem_RelPETemplateSymptom')
CREATE NONCLUSTERED INDEX [RelPETemplateSystem_RelPETemplateSymptom] ON [dbo].[RelPETemplateSymptom]
(
	[RelPETemplateSystemUid] ASC,
	[RelPETemplateSymptomUid] ASC
)
INCLUDE ( 	[PESymptomUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPETemplateSystem]') AND name = N'IX_RelPETemplateParentSystem_RelPETemplateSystem_PESystem')
CREATE NONCLUSTERED INDEX [IX_RelPETemplateParentSystem_RelPETemplateSystem_PESystem] ON [dbo].[RelPETemplateSystem]
(
	[RelPETemplateParentSystemUid] ASC,
	[RelPETemplateSystemUid] ASC,
	[PESystemUid] ASC
)
INCLUDE ( 	[ColorID],
	[AgeGroupUid],
	[GenderUid],
	[ClinicCenterOverride],
	[ProviderOverride]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPETemplateSystem]') AND name = N'RelPETemplateParentSystem')
CREATE NONCLUSTERED INDEX [RelPETemplateParentSystem] ON [dbo].[RelPETemplateSystem]
(
	[RelPETemplateParentSystemUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPETemplateSystem]') AND name = N'RelPETemplateParentSystem_Gender_AgeGroup_RelPETemplateSystem_PESystem')
CREATE NONCLUSTERED INDEX [RelPETemplateParentSystem_Gender_AgeGroup_RelPETemplateSystem_PESystem] ON [dbo].[RelPETemplateSystem]
(
	[RelPETemplateParentSystemUid] ASC,
	[GenderUid] ASC,
	[AgeGroupUid] ASC,
	[RelPETemplateSystemUid] ASC,
	[PESystemUid] ASC
)
INCLUDE ( 	[ColorID],
	[DisplayOrder]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPETemplateSystem]') AND name = N'RelPETemplateParentSystem_PESystem')
CREATE NONCLUSTERED INDEX [RelPETemplateParentSystem_PESystem] ON [dbo].[RelPETemplateSystem]
(
	[RelPETemplateParentSystemUid] ASC,
	[PESystemUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelPQRIMeasurePQRIGroup]') AND name = N'IX_PQRIMeasure')
CREATE NONCLUSTERED INDEX [IX_PQRIMeasure] ON [dbo].[RelPQRIMeasurePQRIGroup]
(
	[PQRIMeasureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelProcedureHistoryTermProcedure]') AND name = N'IX_RelProcedureTerm')
CREATE NONCLUSTERED INDEX [IX_RelProcedureTerm] ON [dbo].[RelProcedureHistoryTermProcedure]
(
	[ProcedureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelProcedureHistoryTermProcedure]') AND name = N'IX_RelTermProcedure')
CREATE NONCLUSTERED INDEX [IX_RelTermProcedure] ON [dbo].[RelProcedureHistoryTermProcedure]
(
	[ProcedureHistoryTermUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelProcedureLaboratoryOrder]') AND name = N'IX_LaboratoryOrderUid')
CREATE NONCLUSTERED INDEX [IX_LaboratoryOrderUid] ON [dbo].[RelProcedureLaboratoryOrder]
(
	[LaboratoryOrderUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelProcedureLaboratoryOrder]') AND name = N'IX_Procedure')
CREATE NONCLUSTERED INDEX [IX_Procedure] ON [dbo].[RelProcedureLaboratoryOrder]
(
	[ProcedureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelProcedurePanelProcedure]') AND name = N'IX_ProcedurePanel')
CREATE NONCLUSTERED INDEX [IX_ProcedurePanel] ON [dbo].[RelProcedurePanelProcedure]
(
	[ProcedurePanelUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelProcedurePanelProcedure]') AND name = N'IX_ProcedurePanel_Procedure')
CREATE UNIQUE NONCLUSTERED INDEX [IX_ProcedurePanel_Procedure] ON [dbo].[RelProcedurePanelProcedure]
(
	[ProcedureUid] ASC,
	[ProcedurePanelUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelProcedureTypeofVaccine]') AND name = N'IX_Procedure_TypeofVaccine')
CREATE UNIQUE NONCLUSTERED INDEX [IX_Procedure_TypeofVaccine] ON [dbo].[RelProcedureTypeofVaccine]
(
	[ProcedureUid] ASC,
	[TypeofVaccineUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelProviderGraphicNoteCCHpi]') AND name = N'IX_Provider')
CREATE NONCLUSTERED INDEX [IX_Provider] ON [dbo].[RelProviderGraphicNoteCCHpi]
(
	[ProviderUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelProviderGraphicNoteCCHpi]') AND name = N'IX_Provider_GraphicNote')
CREATE UNIQUE NONCLUSTERED INDEX [IX_Provider_GraphicNote] ON [dbo].[RelProviderGraphicNoteCCHpi]
(
	[GraphicNoteUid] ASC,
	[ProviderUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelProviderGraphicNoteRosPE]') AND name = N'IX_Provider')
CREATE NONCLUSTERED INDEX [IX_Provider] ON [dbo].[RelProviderGraphicNoteRosPE]
(
	[ProviderUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelProviderGraphicNoteRosPE]') AND name = N'IX_Provider_GraphicNote')
CREATE UNIQUE NONCLUSTERED INDEX [IX_Provider_GraphicNote] ON [dbo].[RelProviderGraphicNoteRosPE]
(
	[GraphicNoteUid] ASC,
	[ProviderUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelProviderIntegrationPartner]') AND name = N'IX_RelProviderIntegrationPartner')
CREATE UNIQUE NONCLUSTERED INDEX [IX_RelProviderIntegrationPartner] ON [dbo].[RelProviderIntegrationPartner]
(
	[IntegrationPartnerUid] ASC,
	[ProviderUid] ASC,
	[Identifier] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelReimbursementRuleDiagnosis]') AND name = N'IX_RelReimbursementRuleDiagnosis')
CREATE NONCLUSTERED INDEX [IX_RelReimbursementRuleDiagnosis] ON [dbo].[RelReimbursementRuleDiagnosis]
(
	[ReimbursementRuleTriggerUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelReimbursementRuleEnforced]') AND name = N'IDX_RelReimbursementRuleEnforced_VisitProcedureUid')
CREATE NONCLUSTERED INDEX [IDX_RelReimbursementRuleEnforced_VisitProcedureUid] ON [dbo].[RelReimbursementRuleEnforced]
(
	[VisitProcedureUid] ASC
)
INCLUDE ( 	[RelReimbursementRuleEnforcedUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelReimbursementRuleEnforced]') AND name = N'ix_RelReimbursementRuleEnforced_ReimbursementRuleTriggerUid')
CREATE NONCLUSTERED INDEX [ix_RelReimbursementRuleEnforced_ReimbursementRuleTriggerUid] ON [dbo].[RelReimbursementRuleEnforced]
(
	[ReimbursementRuleTriggerUid] ASC
)
INCLUDE ( 	[RelReimbursementRuleEnforcedUid],
	[VisitProcedureUid],
	[LetterModelUid],
	[Message],
	[LastModifiedByUid],
	[LastModifiedDate],
	[UserDefined],
	[Inactive]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelReimbursementRuleLetterModel]') AND name = N'IX_RelReimbursementRuleLetterModel')
CREATE UNIQUE NONCLUSTERED INDEX [IX_RelReimbursementRuleLetterModel] ON [dbo].[RelReimbursementRuleLetterModel]
(
	[ReimbursementRuleTriggerUid] ASC,
	[LetterModelUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelReimbursementRuleProcedure]') AND name = N'IX_RelReimbursementRuleProcedure')
CREATE NONCLUSTERED INDEX [IX_RelReimbursementRuleProcedure] ON [dbo].[RelReimbursementRuleProcedure]
(
	[ReimbursementRuleTriggerUid] ASC,
	[ProcedureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelReportContextReportType]') AND name = N'IX_ReportUid')
CREATE NONCLUSTERED INDEX [IX_ReportUid] ON [dbo].[RelReportContextReportType]
(
	[ReportUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelRosSystemSymptom]') AND name = N'IX_RosSystem')
CREATE NONCLUSTERED INDEX [IX_RosSystem] ON [dbo].[RelRosSystemSymptom]
(
	[RosSystemUid] ASC
)
INCLUDE ( 	[RelRosSystemSymptomUid],
	[DenyFlag],
	[DisplayOrder],
	[AgeGroupUid],
	[RosSymptomUid],
	[Inactive],
	[UserDefined],
	[ClinicCenterOverride],
	[ProviderOverride]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelRosSystemSymptom]') AND name = N'IX_RosSystemUid_RosSymptomUid')
CREATE UNIQUE NONCLUSTERED INDEX [IX_RosSystemUid_RosSymptomUid] ON [dbo].[RelRosSystemSymptom]
(
	[RosSystemUid] ASC,
	[RosSymptomUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelSurveyPatient]') AND name = N'IX_Patient')
CREATE NONCLUSTERED INDEX [IX_Patient] ON [dbo].[RelSurveyPatient]
(
	[PatientUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelSurveyPatient]') AND name = N'IX_Patient_EffectiveDate_ExpirationDate')
CREATE NONCLUSTERED INDEX [IX_Patient_EffectiveDate_ExpirationDate] ON [dbo].[RelSurveyPatient]
(
	[PatientUid] ASC,
	[EffectiveDate] ASC,
	[ExpirationDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelSurveyPatient]') AND name = N'IX_Survey_Patient')
CREATE NONCLUSTERED INDEX [IX_Survey_Patient] ON [dbo].[RelSurveyPatient]
(
	[SurveyUid] ASC,
	[PatientUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelUserPRMDesktopControl]') AND name = N'IX_UserPRMUid')
CREATE NONCLUSTERED INDEX [IX_UserPRMUid] ON [dbo].[RelUserPRMDesktopControl]
(
	[UserPrmUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelVisitMedication]') AND name = N'IX_FulfillmentSequentialNumber')
CREATE NONCLUSTERED INDEX [IX_FulfillmentSequentialNumber] ON [dbo].[RelVisitMedication]
(
	[FulfillmentSequentialNumber] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelVisitMedication]') AND name = N'IX_MedicationSIGUid')
CREATE NONCLUSTERED INDEX [IX_MedicationSIGUid] ON [dbo].[RelVisitMedication]
(
	[MedicationSIGUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelVisitMedication]') AND name = N'IX_VisitProcedure')
CREATE NONCLUSTERED INDEX [IX_VisitProcedure] ON [dbo].[RelVisitMedication]
(
	[VisitProcedureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelVisitMedication]') AND name = N'IX_VisitUid')
CREATE NONCLUSTERED INDEX [IX_VisitUid] ON [dbo].[RelVisitMedication]
(
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelVisitMedication]') AND name = N'IX_VisitUid_eRxStatusUid_MedicationSIGUid')
CREATE NONCLUSTERED INDEX [IX_VisitUid_eRxStatusUid_MedicationSIGUid] ON [dbo].[RelVisitMedication]
(
	[VisitUid] ASC,
	[eRxStatusUid] ASC,
	[MedicationSIGUid] ASC,
	[RelVisitMedicationUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Remark]') AND name = N'IX_CreatedBy')
CREATE NONCLUSTERED INDEX [IX_CreatedBy] ON [dbo].[Remark]
(
	[CreatedByUid] ASC
)
INCLUDE ( 	[RemarkUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Remark]') AND name = N'IX_DismissBy')
CREATE NONCLUSTERED INDEX [IX_DismissBy] ON [dbo].[Remark]
(
	[DismissByUid] ASC
)
INCLUDE ( 	[RemarkUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Remark]') AND name = N'IX_LastViewUser')
CREATE NONCLUSTERED INDEX [IX_LastViewUser] ON [dbo].[Remark]
(
	[LastViewUserUid] ASC
)
INCLUDE ( 	[RemarkUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Remark]') AND name = N'IX_Remarks')
CREATE NONCLUSTERED INDEX [IX_Remarks] ON [dbo].[Remark]
(
	[OwnerUid] ASC,
	[BillingType] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ReplicationConflictMessage]') AND name = N'IDX_ReplicationConflictMessage_CacheMachineUid')
CREATE NONCLUSTERED INDEX [IDX_ReplicationConflictMessage_CacheMachineUid] ON [dbo].[ReplicationConflictMessage]
(
	[CacheMachineUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ReplicationFilter]') AND name = N'IDX_ReplicationFilter_CM_TN_RFUID_P')
CREATE NONCLUSTERED INDEX [IDX_ReplicationFilter_CM_TN_RFUID_P] ON [dbo].[ReplicationFilter]
(
	[CacheMachineUid] ASC,
	[TableName] ASC,
	[ReplicationFilterUid] ASC,
	[Priority] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ReplicationFilter]') AND name = N'IDX_ReplicationFilter_TN_CM_RFUID')
CREATE NONCLUSTERED INDEX [IDX_ReplicationFilter_TN_CM_RFUID] ON [dbo].[ReplicationFilter]
(
	[TableName] ASC,
	[CacheMachineUid] ASC,
	[ReplicationFilterUid] ASC
)
INCLUDE ( 	[LastSyncDate],
	[LastSyncReceivedAnchor]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ReplicationFilter]') AND name = N'IX_CacheMachineUid_LastSyncDate')
CREATE NONCLUSTERED INDEX [IX_CacheMachineUid_LastSyncDate] ON [dbo].[ReplicationFilter]
(
	[CacheMachineUid] ASC
)
INCLUDE ( 	[LastSyncDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ReplicationFilter]') AND name = N'IX_ReplicationFilter_CacheMachineUid_RFUid_LSD__LSRA_TN_P_LESD')
CREATE NONCLUSTERED INDEX [IX_ReplicationFilter_CacheMachineUid_RFUid_LSD__LSRA_TN_P_LESD] ON [dbo].[ReplicationFilter]
(
	[CacheMachineUid] ASC
)
INCLUDE ( 	[ReplicationFilterUid],
	[LastSyncDate],
	[LastSyncReceivedAnchor],
	[TableName],
	[Priority],
	[LastExternalSyncDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ReplicationFilter]') AND name = N'IX_TableName_ReplicationFilterUid')
CREATE NONCLUSTERED INDEX [IX_TableName_ReplicationFilterUid] ON [dbo].[ReplicationFilter]
(
	[TableName] ASC,
	[CacheMachineUid] ASC,
	[ReplicationFilterUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ReplicationFilter]') AND name = N'ReplicationFilter_CacheMachineUid_Priority')
CREATE NONCLUSTERED INDEX [ReplicationFilter_CacheMachineUid_Priority] ON [dbo].[ReplicationFilter]
(
	[CacheMachineUid] ASC,
	[Priority] ASC
)
INCLUDE ( 	[ReplicationFilterUid],
	[TableName],
	[LastSyncDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ReplicationFilter]') AND name = N'ReplicationFilter_Table_LastSync')
CREATE NONCLUSTERED INDEX [ReplicationFilter_Table_LastSync] ON [dbo].[ReplicationFilter]
(
	[TableName] ASC,
	[LastSyncDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ReplicationHistory]') AND name = N'IDX_ReplicationHistory_CacheMachineUid')
CREATE NONCLUSTERED INDEX [IDX_ReplicationHistory_CacheMachineUid] ON [dbo].[ReplicationHistory]
(
	[CacheMachineUid] ASC
)
INCLUDE ( 	[ReplicationHistoryUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ReplicationHistory]') AND name = N'IDX_ReplicationHistory_EventType_TableName_CacheMachineUid')
CREATE NONCLUSTERED INDEX [IDX_ReplicationHistory_EventType_TableName_CacheMachineUid] ON [dbo].[ReplicationHistory]
(
	[EventType] ASC,
	[TableName] ASC,
	[CacheMachineUid] ASC
)
INCLUDE ( 	[ReplicationHistoryUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ReplicationHistory]') AND name = N'IX_TableName_ObjectUid_CacheMachineUid')
CREATE NONCLUSTERED INDEX [IX_TableName_ObjectUid_CacheMachineUid] ON [dbo].[ReplicationHistory]
(
	[TableName] ASC,
	[ObjectUid] ASC,
	[CacheMachineUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ReplicationHistory]') AND name = N'LastModifiedDate')
CREATE NONCLUSTERED INDEX [LastModifiedDate] ON [dbo].[ReplicationHistory]
(
	[LastModifiedDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ReplicationQueue]') AND name = N'IDX_CacheMachineUid_LastCopiedObjectUid_Status')
CREATE NONCLUSTERED INDEX [IDX_CacheMachineUid_LastCopiedObjectUid_Status] ON [dbo].[ReplicationQueue]
(
	[CacheMachineUid] ASC,
	[LastCopiedObject] ASC,
	[Status] ASC
)
INCLUDE ( 	[TableName]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ReplicationQueue]') AND name = N'IDX_ReplicationQueue_Action_TableName_CacheMachineUid')
CREATE NONCLUSTERED INDEX [IDX_ReplicationQueue_Action_TableName_CacheMachineUid] ON [dbo].[ReplicationQueue]
(
	[Action] ASC,
	[TableName] ASC,
	[CacheMachineUid] ASC
)
INCLUDE ( 	[ReplicationQueueUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ReplicationQueue]') AND name = N'IDX_ReplicationQueue_CacheMachineUidStatus')
CREATE NONCLUSTERED INDEX [IDX_ReplicationQueue_CacheMachineUidStatus] ON [dbo].[ReplicationQueue]
(
	[CacheMachineUid] ASC,
	[Status] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ReplicationQueue]') AND name = N'IX_CacheMachine_Action_Status')
CREATE NONCLUSTERED INDEX [IX_CacheMachine_Action_Status] ON [dbo].[ReplicationQueue]
(
	[CacheMachineUid] ASC,
	[Action] ASC,
	[Status] ASC
)
INCLUDE ( 	[ReplicationQueueUid],
	[Sequence],
	[TableName],
	[LastCopiedObject],
	[ObjectUid],
	[MergeNewObjectUid],
	[MergeOriginalName],
	[MergeNewName],
	[LastCopiedObjectSyncReceivedAnchor],
	[LastCopiedObjectModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ReplicationQueue]') AND name = N'IX_CacheMachineUid_TableName')
CREATE NONCLUSTERED INDEX [IX_CacheMachineUid_TableName] ON [dbo].[ReplicationQueue]
(
	[CacheMachineUid] ASC
)
INCLUDE ( 	[TableName]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ReplicationQueue]') AND name = N'IX_LastCopiedObjectUid_Status')
CREATE NONCLUSTERED INDEX [IX_LastCopiedObjectUid_Status] ON [dbo].[ReplicationQueue]
(
	[LastCopiedObject] ASC,
	[Status] ASC
)
INCLUDE ( 	[TableName],
	[CacheMachineUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ReplicationQueue]') AND name = N'IX_ReplicationQueue_CacheMachineUid_Status')
CREATE NONCLUSTERED INDEX [IX_ReplicationQueue_CacheMachineUid_Status] ON [dbo].[ReplicationQueue]
(
	[CacheMachineUid] ASC,
	[Action] ASC,
	[Status] ASC
)
INCLUDE ( 	[ReplicationQueueUid],
	[TableName]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ReplicationQueue]') AND name = N'IX_ReplicationQueueUid')
CREATE UNIQUE NONCLUSTERED INDEX [IX_ReplicationQueueUid] ON [dbo].[ReplicationQueue]
(
	[ReplicationQueueUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ReplicationQueue]') AND name = N'IX_Status_TableName_CacheMachineUid')
CREATE NONCLUSTERED INDEX [IX_Status_TableName_CacheMachineUid] ON [dbo].[ReplicationQueue]
(
	[Status] ASC
)
INCLUDE ( 	[TableName],
	[CacheMachineUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ReplicationSettings]') AND name = N'IX_Name_GuidValue')
CREATE NONCLUSTERED INDEX [IX_Name_GuidValue] ON [dbo].[ReplicationSettings]
(
	[Name] ASC,
	[GuidValue] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ReplicationSettings]') AND name = N'IX_Name_GuidValue_LastModifiedDate')
CREATE NONCLUSTERED INDEX [IX_Name_GuidValue_LastModifiedDate] ON [dbo].[ReplicationSettings]
(
	[Name] ASC,
	[GuidValue] ASC,
	[LastModifiedDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ReplicationSettings]') AND name = N'IX_ReplicationSettings')
CREATE UNIQUE NONCLUSTERED INDEX [IX_ReplicationSettings] ON [dbo].[ReplicationSettings]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RVUSchedule]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[RVUSchedule]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RVUSchedule]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[RVUSchedule]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SecurityUserGroup]') AND name = N'IDX_SecurityUserGroup_ObjectUid')
CREATE NONCLUSTERED INDEX [IDX_SecurityUserGroup_ObjectUid] ON [dbo].[SecurityUserGroup]
(
	[ObjectUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SecurityUserGroup]') AND name = N'IDX_SecurityUserGroup_ObjectUid_UserGroupUid')
CREATE NONCLUSTERED INDEX [IDX_SecurityUserGroup_ObjectUid_UserGroupUid] ON [dbo].[SecurityUserGroup]
(
	[ObjectUid] ASC,
	[UserGroupUid] ASC
)
INCLUDE ( 	[SecurityUid],
	[ParentObjectUid],
	[ObjectName],
	[Permission]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SecurityUserGroup]') AND name = N'IDX_SecurityUserGroup_UserGroupUid')
CREATE NONCLUSTERED INDEX [IDX_SecurityUserGroup_UserGroupUid] ON [dbo].[SecurityUserGroup]
(
	[UserGroupUid] ASC
)
INCLUDE ( 	[SecurityUid],
	[ParentObjectUid],
	[ObjectName],
	[ObjectUid],
	[Permission]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SecurityUserGroup]') AND name = N'IDX_SecurityUserGroup_UserPRMUid')
CREATE NONCLUSTERED INDEX [IDX_SecurityUserGroup_UserPRMUid] ON [dbo].[SecurityUserGroup]
(
	[UserPRMUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SecurityUserGroup]') AND name = N'IX_Object_UserPRM')
CREATE NONCLUSTERED INDEX [IX_Object_UserPRM] ON [dbo].[SecurityUserGroup]
(
	[ObjectUid] ASC,
	[UserPRMUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SecurityUserGroup]') AND name = N'IX_ParentObject_Object')
CREATE NONCLUSTERED INDEX [IX_ParentObject_Object] ON [dbo].[SecurityUserGroup]
(
	[ParentObjectUid] ASC,
	[ObjectUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SecurityUserGroup]') AND name = N'IX_ParentObjectUid_SecurityUid')
CREATE NONCLUSTERED INDEX [IX_ParentObjectUid_SecurityUid] ON [dbo].[SecurityUserGroup]
(
	[ParentObjectUid] ASC,
	[SecurityUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SecurityUserGroup]') AND name = N'IX_SecurityUid_ParentObjectUid')
CREATE NONCLUSTERED INDEX [IX_SecurityUid_ParentObjectUid] ON [dbo].[SecurityUserGroup]
(
	[SecurityUid] ASC,
	[ParentObjectUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SecurityUserGroup]') AND name = N'IX_SecurityUserGroup')
CREATE NONCLUSTERED INDEX [IX_SecurityUserGroup] ON [dbo].[SecurityUserGroup]
(
	[ObjectName] ASC,
	[ObjectUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SecurityUserGroup]') AND name = N'IX_SecurityUserGroup_1')
CREATE NONCLUSTERED INDEX [IX_SecurityUserGroup_1] ON [dbo].[SecurityUserGroup]
(
	[ObjectUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SIGDetail]') AND name = N'IX_MedicationSigUid')
CREATE NONCLUSTERED INDEX [IX_MedicationSigUid] ON [dbo].[SIGDetail]
(
	[MedicationSIGUid] ASC
)
INCLUDE ( 	[SIGDetailUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SIGDetail]') AND name = N'IX_SIGDetail')
CREATE NONCLUSTERED INDEX [IX_SIGDetail] ON [dbo].[SIGDetail]
(
	[SIGDetailUid] ASC,
	[MedicationSIGUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SpecialtyCpp]') AND name = N'IX_Specialty')
CREATE NONCLUSTERED INDEX [IX_Specialty] ON [dbo].[SpecialtyCpp]
(
	[CppUid] ASC
)
INCLUDE ( 	[SpecialtyUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[StatementAction]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[StatementAction]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[StatementAction]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[StatementAction]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[StatementBatchDetail]') AND name = N'IX_AccountResponsibleParty')
CREATE NONCLUSTERED INDEX [IX_AccountResponsibleParty] ON [dbo].[StatementBatchDetail]
(
	[AccountResponsiblePartyUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[StatementBatchDetail]') AND name = N'ix_StatementBatchDetail_AttachmentUid')
CREATE NONCLUSTERED INDEX [ix_StatementBatchDetail_AttachmentUid] ON [dbo].[StatementBatchDetail]
(
	[AttachmentUid] ASC
)
INCLUDE ( 	[StatementBatchUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[StatementBatchDetail]') AND name = N'ix_StatementBatchDetail_FinancialCenterUid')
CREATE NONCLUSTERED INDEX [ix_StatementBatchDetail_FinancialCenterUid] ON [dbo].[StatementBatchDetail]
(
	[FinancialCenterUid] ASC
)
INCLUDE ( 	[AccountResponsiblePartyUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[StatementBatchDetail]') AND name = N'IX_StatementBatchUid_StatementBatchDetailUid')
CREATE NONCLUSTERED INDEX [IX_StatementBatchUid_StatementBatchDetailUid] ON [dbo].[StatementBatchDetail]
(
	[StatementBatchUid] ASC,
	[StatementBatchDetailUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[StatementBatchDetailSuperbill]') AND name = N'IX_StatementBatchDetailSuperbill_SuperbillUid')
CREATE NONCLUSTERED INDEX [IX_StatementBatchDetailSuperbill_SuperbillUid] ON [dbo].[StatementBatchDetailSuperbill]
(
	[SuperbillUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[StatementBatchDetailSuperbill]') AND name = N'IX_StatementBatchDetailUid')
CREATE NONCLUSTERED INDEX [IX_StatementBatchDetailUid] ON [dbo].[StatementBatchDetailSuperbill]
(
	[StatementBatchDetailUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[StatsClientPerformance]') AND name = N'IX_Client')
CREATE NONCLUSTERED INDEX [IX_Client] ON [dbo].[StatsClientPerformance]
(
	[Client] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[StatsClientPerformance]') AND name = N'IX_Client_FormName')
CREATE NONCLUSTERED INDEX [IX_Client_FormName] ON [dbo].[StatsClientPerformance]
(
	[Client] ASC,
	[FormName] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[StatsClientPerformance]') AND name = N'IX_FormName')
CREATE NONCLUSTERED INDEX [IX_FormName] ON [dbo].[StatsClientPerformance]
(
	[FormName] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[StatsClientPerformance]') AND name = N'IX_LastModifiedDate')
CREATE NONCLUSTERED INDEX [IX_LastModifiedDate] ON [dbo].[StatsClientPerformance]
(
	[LastModifiedDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Superbill]') AND name = N'IX_AccountUid')
CREATE NONCLUSTERED INDEX [IX_AccountUid] ON [dbo].[Superbill]
(
	[AccountUid] ASC
)
INCLUDE ( 	[SuperbillUid],
	[SuperbillStatusUid],
	[ServiceDateEnd],
	[ExternalID],
	[PatientUid],
	[ServiceDateStart]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Superbill]') AND name = N'IX_AccountUid_DateLeftColl_Date_Enter_Coll_inc')
CREATE NONCLUSTERED INDEX [IX_AccountUid_DateLeftColl_Date_Enter_Coll_inc] ON [dbo].[Superbill]
(
	[SuperbillUid] ASC,
	[DateLeftAutomatedCollections] ASC,
	[DateEnteredAutomatedCollections] ASC
)
INCLUDE ( 	[AccountUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Superbill]') AND name = N'IX_AllowedSchedulePeriod_ServiceDateEnd_Superbill')
CREATE NONCLUSTERED INDEX [IX_AllowedSchedulePeriod_ServiceDateEnd_Superbill] ON [dbo].[Superbill]
(
	[AmountAllowedSchedulePeriodUid] ASC,
	[ServiceDateEnd] ASC,
	[SuperbillUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Superbill]') AND name = N'IX_Appointment')
CREATE NONCLUSTERED INDEX [IX_Appointment] ON [dbo].[Superbill]
(
	[AppointmentUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Superbill]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[Superbill]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Superbill]') AND name = N'IX_FeeSchedulePeriod_ServiceDateEnd_Superbill')
CREATE NONCLUSTERED INDEX [IX_FeeSchedulePeriod_ServiceDateEnd_Superbill] ON [dbo].[Superbill]
(
	[FeeSchedulePeriodUid] ASC,
	[ServiceDateEnd] ASC,
	[SuperbillUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Superbill]') AND name = N'IX_LastModifiedDate')
CREATE NONCLUSTERED INDEX [IX_LastModifiedDate] ON [dbo].[Superbill]
(
	[LastModifiedDate] ASC
)
INCLUDE ( 	[SuperbillUid],
	[PatientUid],
	[VisitUid],
	[ServiceDateStart]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Superbill]') AND name = N'IX_ParentSuperbill')
CREATE NONCLUSTERED INDEX [IX_ParentSuperbill] ON [dbo].[Superbill]
(
	[ParentSuperbillUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Superbill]') AND name = N'IX_PatientCaseUid')
CREATE NONCLUSTERED INDEX [IX_PatientCaseUid] ON [dbo].[Superbill]
(
	[PatientCaseUid] ASC
)
INCLUDE ( 	[SuperbillUid],
	[ExternalID],
	[AccountUid],
	[PatientUid],
	[AppointmentUid],
	[VisitUid],
	[SuperbillStatusUid],
	[CurrentCarrierOverride],
	[ServiceDateStart],
	[ServiceDateEnd],
	[DefaultRenderingProviderUid],
	[DefaultClaimingProviderUid],
	[ProviderCareTypeUid],
	[ReferringProviderUid],
	[ReferringDate],
	[DefaultServiceSiteUid],
	[DefaultFinancialCenterUid],
	[PriorAuthorizationCode],
	[RelatedCauseUid],
	[RelatedCauseState],
	[RelatedCauseDate],
	[OnsetDate],
	[OnsetFirstDate],
	[NoWorkFromDate],
	[NoWorkToDate],
	[HospitalizationStartDate],
	[HospitalizationEndDate],
	[EPSDT],
	[Emergency],
	[COB],
	[ClaimPaper],
	[SBReleaseMedicalRecords],
	[AlertCodeResync],
	[ParentSuperbillUid],
	[UsePersonInsuranceAuthorizeAssignment],
	[AuthorizeAssignment],
	[UsePrimaryPayerAcceptAssignment],
	[AcceptAssignmentLabOnly],
	[AcceptAssignment],
	[ExcludeFromAutomatedCollections],
	[DateEnteredAutomatedCollections],
	[DateLeftAutomatedCollections],
	[EnteringCollectionsPatientBalance],
	[ABN],
	[ARBatchUid],
	[PriorAuthorizationCode_InsuranceCarrier2],
	[PriorAuthorizationCode_InsuranceCarrier3],
	[ResubmissionCode],
	[EmergencyIndicatorUid],
	[LMPDate],
	[EstimatedDateOfBirth],
	[DateLastSeenBySupervising],
	[InitialTreatmentDate],
	[FamilyPlanning],
	[DelayReasonUid],
	[EPSDTReferralCondIndicator1Uid],
	[EPSDTReferralCondIndicator2Uid],
	[EPSDTReferralCondIndicator3Uid],
	[EPSDTReferralCondIndicator4Uid],
	[ClaimHeaderNoteCodeUid],
	[ManuallySetFeeAllowedSchedulePeriod],
	[FeeSchedulePeriodUid],
	[AmountAllowedSchedulePeriodUid],
	[AmountAllowedAutoWriteoffOvercharge],
	[PayorPlanSetUid],
	[TypeOfBill],
	[AuthReferralIndicator],
	[DateLastSeen],
	[ReferralSrcUid],
	[Notes],
	[LastModifiedDate],
	[LastModifiedByUid],
	[OnsetFirstQualifierUid],
	[OrderingProviderUid],
	[Box17ProviderUid],
	[PaperworkTypeUid],
	[PaperworkTransmissionCodeUid],
	[PaperworkControlNum]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Superbill]') AND name = N'IX_PatientUid_VisitUid_SuperbillStatusUid')
CREATE NONCLUSTERED INDEX [IX_PatientUid_VisitUid_SuperbillStatusUid] ON [dbo].[Superbill]
(
	[PatientUid] ASC,
	[VisitUid] ASC,
	[SuperbillStatusUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Superbill]') AND name = N'IX_ReferringProviderUid')
CREATE NONCLUSTERED INDEX [IX_ReferringProviderUid] ON [dbo].[Superbill]
(
	[ReferringProviderUid] ASC
)
INCLUDE ( 	[SuperbillUid],
	[ExternalID],
	[AccountUid],
	[PatientUid],
	[PatientCaseUid],
	[AppointmentUid],
	[VisitUid],
	[SuperbillStatusUid],
	[CurrentCarrierOverride],
	[ServiceDateStart],
	[ServiceDateEnd],
	[DefaultRenderingProviderUid],
	[DefaultClaimingProviderUid],
	[ProviderCareTypeUid],
	[ReferringDate],
	[DefaultServiceSiteUid],
	[DefaultFinancialCenterUid],
	[PriorAuthorizationCode],
	[RelatedCauseUid],
	[RelatedCauseState],
	[RelatedCauseDate],
	[OnsetDate],
	[OnsetFirstDate],
	[NoWorkFromDate],
	[NoWorkToDate],
	[HospitalizationStartDate],
	[HospitalizationEndDate],
	[EPSDT],
	[Emergency],
	[COB],
	[ClaimPaper],
	[SBReleaseMedicalRecords],
	[AlertCodeResync],
	[ParentSuperbillUid],
	[UsePersonInsuranceAuthorizeAssignment],
	[AuthorizeAssignment],
	[UsePrimaryPayerAcceptAssignment],
	[AcceptAssignmentLabOnly],
	[AcceptAssignment],
	[ExcludeFromAutomatedCollections],
	[DateEnteredAutomatedCollections],
	[DateLeftAutomatedCollections],
	[EnteringCollectionsPatientBalance],
	[ABN],
	[ARBatchUid],
	[PriorAuthorizationCode_InsuranceCarrier2],
	[PriorAuthorizationCode_InsuranceCarrier3],
	[ResubmissionCode],
	[EmergencyIndicatorUid],
	[LMPDate],
	[EstimatedDateOfBirth],
	[DateLastSeenBySupervising],
	[InitialTreatmentDate],
	[FamilyPlanning],
	[DelayReasonUid],
	[EPSDTReferralCondIndicator1Uid],
	[EPSDTReferralCondIndicator2Uid],
	[EPSDTReferralCondIndicator3Uid],
	[EPSDTReferralCondIndicator4Uid],
	[ClaimHeaderNoteCodeUid],
	[ManuallySetFeeAllowedSchedulePeriod],
	[FeeSchedulePeriodUid],
	[AmountAllowedSchedulePeriodUid],
	[AmountAllowedAutoWriteoffOvercharge],
	[PayorPlanSetUid],
	[TypeOfBill],
	[AuthReferralIndicator],
	[DateLastSeen],
	[ReferralSrcUid],
	[Notes],
	[LastModifiedDate],
	[LastModifiedByUid],
	[OnsetFirstQualifierUid],
	[OrderingProviderUid],
	[Box17ProviderUid],
	[PaperworkTypeUid],
	[PaperworkTransmissionCodeUid],
	[PaperworkControlNum]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Superbill]') AND name = N'IX_Superbill_CurrentCarrierOverride')
CREATE NONCLUSTERED INDEX [IX_Superbill_CurrentCarrierOverride] ON [dbo].[Superbill]
(
	[SuperbillUid] ASC
)
INCLUDE ( 	[CurrentCarrierOverride]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Superbill]') AND name = N'IX_Superbill_FinancialDeaultsCover')
CREATE NONCLUSTERED INDEX [IX_Superbill_FinancialDeaultsCover] ON [dbo].[Superbill]
(
	[SuperbillUid] ASC,
	[DefaultFinancialCenterUid] ASC,
	[DefaultServiceSiteUid] ASC,
	[DefaultClaimingProviderUid] ASC,
	[DefaultRenderingProviderUid] ASC,
	[VisitUid] ASC,
	[AppointmentUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Superbill]') AND name = N'ix_Superbill_FinancialNoteUid')
CREATE NONCLUSTERED INDEX [ix_Superbill_FinancialNoteUid] ON [dbo].[Superbill]
(
	[FinancialNoteUid] ASC
)
INCLUDE ( 	[SuperbillUid],
	[ExternalID],
	[AccountUid],
	[PatientUid],
	[PatientCaseUid],
	[AppointmentUid],
	[VisitUid],
	[SuperbillStatusUid],
	[CurrentCarrierOverride],
	[ServiceDateStart],
	[ServiceDateEnd],
	[DefaultRenderingProviderUid],
	[DefaultClaimingProviderUid],
	[ProviderCareTypeUid],
	[ReferringProviderUid],
	[ReferringDate],
	[DefaultServiceSiteUid],
	[DefaultFinancialCenterUid],
	[PriorAuthorizationCode],
	[RelatedCauseUid],
	[RelatedCauseState],
	[RelatedCauseDate],
	[OnsetDate],
	[OnsetFirstDate],
	[NoWorkFromDate],
	[NoWorkToDate],
	[HospitalizationStartDate],
	[HospitalizationEndDate],
	[EPSDT],
	[Emergency],
	[COB],
	[ClaimNote],
	[ClaimPaper],
	[SBReleaseMedicalRecords],
	[AlertCodeResync],
	[ParentSuperbillUid],
	[UsePersonInsuranceAuthorizeAssignment],
	[AuthorizeAssignment],
	[UsePrimaryPayerAcceptAssignment],
	[AcceptAssignmentLabOnly],
	[AcceptAssignment],
	[ExcludeFromAutomatedCollections],
	[DateEnteredAutomatedCollections],
	[DateLeftAutomatedCollections],
	[EnteringCollectionsPatientBalance],
	[ABN],
	[ARBatchUid],
	[PriorAuthorizationCode_InsuranceCarrier2],
	[PriorAuthorizationCode_InsuranceCarrier3],
	[ResubmissionCode],
	[EmergencyIndicatorUid],
	[LMPDate],
	[EstimatedDateOfBirth],
	[DateLastSeenBySupervising],
	[InitialTreatmentDate],
	[FamilyPlanning],
	[DelayReasonUid],
	[EPSDTReferralCondIndicator1Uid],
	[EPSDTReferralCondIndicator2Uid],
	[EPSDTReferralCondIndicator3Uid],
	[EPSDTReferralCondIndicator4Uid],
	[ClaimHeaderNoteCodeUid],
	[Box10dNote],
	[ManuallySetFeeAllowedSchedulePeriod],
	[FeeSchedulePeriodUid],
	[AmountAllowedSchedulePeriodUid],
	[AmountAllowedAutoWriteoffOvercharge],
	[PayorPlanSetUid],
	[TypeOfBill],
	[AuthReferralIndicator],
	[DateLastSeen],
	[UserDefinedXml],
	[ReferralSrcUid],
	[Notes],
	[LastModifiedDate],
	[LastModifiedByUid],
	[OnsetFirstQualifierUid],
	[OrderingProviderUid],
	[Box17ProviderUid],
	[PaperworkTypeUid],
	[PaperworkTransmissionCodeUid],
	[PaperworkControlNum],
	[DFTQueuedDateTime]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Superbill]') AND name = N'ix_Superbill_FinancialNoteUidSuperbillStatusUid')
CREATE NONCLUSTERED INDEX [ix_Superbill_FinancialNoteUidSuperbillStatusUid] ON [dbo].[Superbill]
(
	[FinancialNoteUid] ASC,
	[SuperbillStatusUid] ASC
)
INCLUDE ( 	[SuperbillUid],
	[ExternalID],
	[AccountUid],
	[PatientUid],
	[PatientCaseUid],
	[AppointmentUid],
	[VisitUid],
	[CurrentCarrierOverride],
	[ServiceDateStart],
	[ServiceDateEnd],
	[DefaultRenderingProviderUid],
	[DefaultClaimingProviderUid],
	[ProviderCareTypeUid],
	[ReferringProviderUid],
	[ReferringDate],
	[DefaultServiceSiteUid],
	[DefaultFinancialCenterUid],
	[PriorAuthorizationCode],
	[RelatedCauseUid],
	[RelatedCauseState],
	[RelatedCauseDate],
	[OnsetDate],
	[OnsetFirstDate],
	[NoWorkFromDate],
	[NoWorkToDate],
	[HospitalizationStartDate],
	[HospitalizationEndDate],
	[EPSDT],
	[Emergency],
	[COB],
	[ClaimNote],
	[ClaimPaper],
	[SBReleaseMedicalRecords],
	[AlertCodeResync],
	[ParentSuperbillUid],
	[UsePersonInsuranceAuthorizeAssignment],
	[AuthorizeAssignment],
	[UsePrimaryPayerAcceptAssignment],
	[AcceptAssignmentLabOnly],
	[AcceptAssignment],
	[ExcludeFromAutomatedCollections],
	[DateEnteredAutomatedCollections],
	[DateLeftAutomatedCollections],
	[EnteringCollectionsPatientBalance],
	[ABN],
	[ARBatchUid],
	[PriorAuthorizationCode_InsuranceCarrier2],
	[PriorAuthorizationCode_InsuranceCarrier3],
	[ResubmissionCode],
	[EmergencyIndicatorUid],
	[LMPDate],
	[EstimatedDateOfBirth],
	[DateLastSeenBySupervising],
	[InitialTreatmentDate],
	[FamilyPlanning],
	[DelayReasonUid],
	[EPSDTReferralCondIndicator1Uid],
	[EPSDTReferralCondIndicator2Uid],
	[EPSDTReferralCondIndicator3Uid],
	[EPSDTReferralCondIndicator4Uid],
	[ClaimHeaderNoteCodeUid],
	[Box10dNote],
	[ManuallySetFeeAllowedSchedulePeriod],
	[FeeSchedulePeriodUid],
	[AmountAllowedSchedulePeriodUid],
	[AmountAllowedAutoWriteoffOvercharge],
	[PayorPlanSetUid],
	[TypeOfBill],
	[AuthReferralIndicator],
	[DateLastSeen],
	[UserDefinedXml],
	[ReferralSrcUid],
	[Notes],
	[LastModifiedDate],
	[LastModifiedByUid],
	[OnsetFirstQualifierUid],
	[OrderingProviderUid],
	[Box17ProviderUid],
	[PaperworkTypeUid],
	[PaperworkTransmissionCodeUid],
	[PaperworkControlNum],
	[DFTQueuedDateTime]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Superbill]') AND name = N'IX_Superbill_StatusUid_Cover')
CREATE NONCLUSTERED INDEX [IX_Superbill_StatusUid_Cover] ON [dbo].[Superbill]
(
	[SuperbillStatusUid] ASC
)
INCLUDE ( 	[SuperbillUid],
	[ExternalID],
	[AccountUid],
	[PatientUid],
	[VisitUid],
	[ServiceDateStart],
	[ServiceDateEnd],
	[ClaimPaper],
	[ABN],
	[LastModifiedByUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Superbill]') AND name = N'IX_SuperbillStatus_LastModifiedDate')
CREATE NONCLUSTERED INDEX [IX_SuperbillStatus_LastModifiedDate] ON [dbo].[Superbill]
(
	[SuperbillStatusUid] ASC,
	[LastModifiedDate] ASC
)
INCLUDE ( 	[AppointmentUid],
	[VisitUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Superbill]') AND name = N'IX_SuperbillStatus_ServiceDateStart')
CREATE NONCLUSTERED INDEX [IX_SuperbillStatus_ServiceDateStart] ON [dbo].[Superbill]
(
	[SuperbillStatusUid] ASC,
	[ServiceDateStart] ASC
)
INCLUDE ( 	[SuperbillUid],
	[ExternalID]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Superbill]') AND name = N'IX_SuperbillStatusUid')
CREATE NONCLUSTERED INDEX [IX_SuperbillStatusUid] ON [dbo].[Superbill]
(
	[ARBatchUid] ASC,
	[SuperbillStatusUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Superbill]') AND name = N'IX_VisitUid')
CREATE NONCLUSTERED INDEX [IX_VisitUid] ON [dbo].[Superbill]
(
	[VisitUid] ASC
)
INCLUDE ( 	[SuperbillStatusUid],
	[SuperbillUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Superbill]') AND name = N'Superbill_ARBatch_Visit_ServiceSite_Provider_Patient')
CREATE NONCLUSTERED INDEX [Superbill_ARBatch_Visit_ServiceSite_Provider_Patient] ON [dbo].[Superbill]
(
	[SuperbillUid] ASC,
	[ARBatchUid] ASC,
	[VisitUid] ASC,
	[SuperbillStatusUid] ASC,
	[PatientUid] ASC
)
INCLUDE ( 	[ExternalID],
	[AccountUid],
	[ServiceDateStart],
	[ServiceDateEnd],
	[ClaimPaper],
	[LastModifiedByUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Superbill]') AND name = N'Superbill_ExternalID_ServiceDateStart_Account')
CREATE NONCLUSTERED INDEX [Superbill_ExternalID_ServiceDateStart_Account] ON [dbo].[Superbill]
(
	[ExternalID] ASC,
	[ServiceDateStart] ASC,
	[AccountUid] ASC
)
INCLUDE ( 	[SuperbillUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Superbill]') AND name = N'SuperbillUid_ExternalID_ServiceDateStart_ServiceDateEnd')
CREATE NONCLUSTERED INDEX [SuperbillUid_ExternalID_ServiceDateStart_ServiceDateEnd] ON [dbo].[Superbill]
(
	[SuperbillUid] ASC,
	[ExternalID] ASC,
	[ServiceDateStart] ASC,
	[ServiceDateEnd] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SuperbillAggregate]') AND name = N'IX_AccountPeriodUid_inc')
CREATE NONCLUSTERED INDEX [IX_AccountPeriodUid_inc] ON [dbo].[SuperbillAggregate]
(
	[AccountPeriodUid] ASC
)
INCLUDE ( 	[SuperbillUid],
	[PrimaryInsurancePlanUid],
	[CurrentInsurancePlanUid],
	[LiabilityOwner]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SuperbillAggregate]') AND name = N'IX_LastFiledDate')
CREATE NONCLUSTERED INDEX [IX_LastFiledDate] ON [dbo].[SuperbillAggregate]
(
	[LastFiledDate] ASC
)
INCLUDE ( 	[SuperbillUid],
	[FirstFiledDate],
	[CodeValidationErrors],
	[IsPosted]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SuperbillAggregate]') AND name = N'IX_ServiceSiteUid')
CREATE NONCLUSTERED INDEX [IX_ServiceSiteUid] ON [dbo].[SuperbillAggregate]
(
	[ServiceSiteUid] ASC
)
INCLUDE ( 	[SuperbillUid],
	[FinancialCenterUid],
	[ClaimingProviderUid],
	[RenderingProviderUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SuperbillAggregate]') AND name = N'ix_SuperbillAggregate_ServiceSiteUidFinancialCenterUid')
CREATE NONCLUSTERED INDEX [ix_SuperbillAggregate_ServiceSiteUidFinancialCenterUid] ON [dbo].[SuperbillAggregate]
(
	[ServiceSiteUid] ASC,
	[FinancialCenterUid] ASC
)
INCLUDE ( 	[SuperbillUid],
	[CurrentCarrier],
	[ClaimingProviderUid],
	[RenderingProviderUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SuperbillAggregate]') AND name = N'Superbill_WiththIncludePayment')
CREATE NONCLUSTERED INDEX [Superbill_WiththIncludePayment] ON [dbo].[SuperbillAggregate]
(
	[SuperbillUid] ASC
)
INCLUDE ( 	[FirstFiledDate],
	[LastFiledDate],
	[CodeValidationErrors],
	[IsPosted],
	[Inactive],
	[CurrentInsurancePlanUid],
	[LastPatientPaymentDate],
	[LastPatientPaymentAmount],
	[LastInsurancePaymentDate],
	[LastInsurancePaymentAmount]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SuperbillDiagnosis]') AND name = N'IX_LastModifiedDate')
CREATE NONCLUSTERED INDEX [IX_LastModifiedDate] ON [dbo].[SuperbillDiagnosis]
(
	[LastModifiedDate] ASC
)
INCLUDE ( 	[SuperbillDiagnosisUid],
	[SuperbillUid],
	[DisplayOrder]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SuperbillDiagnosis]') AND name = N'IX_Superbill')
CREATE NONCLUSTERED INDEX [IX_Superbill] ON [dbo].[SuperbillDiagnosis]
(
	[SuperbillUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SuperbillDiagnosis]') AND name = N'SuperbillUid_DisplayOrder')
CREATE NONCLUSTERED INDEX [SuperbillUid_DisplayOrder] ON [dbo].[SuperbillDiagnosis]
(
	[SuperbillUid] ASC,
	[DisplayOrder] ASC
)
INCLUDE ( 	[SuperbillDiagnosisUid],
	[Code9],
	[Code10],
	[CodeDescription],
	[SnomedCTConceptId],
	[SourceVisitDiagnosisUid],
	[SourceFinancialNoteDiagnosisUid],
	[LastModifiedDate],
	[LastModifiedByUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SuperbillProcedure]') AND name = N'IX_LastModifiedDate')
CREATE NONCLUSTERED INDEX [IX_LastModifiedDate] ON [dbo].[SuperbillProcedure]
(
	[LastModifiedDate] ASC
)
INCLUDE ( 	[SuperbillProcedureUid],
	[SuperbillUid],
	[DisplayOrder],
	[ProcedureUid],
	[ProcedureCharge],
	[Units],
	[DiagnosisPointer1],
	[DiagnosisPointer2],
	[DiagnosisPointer3],
	[DiagnosisPointer4]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SuperbillProcedure]') AND name = N'IX_SuperbillProcedure_InactiveGlobalPeriod')
CREATE NONCLUSTERED INDEX [IX_SuperbillProcedure_InactiveGlobalPeriod] ON [dbo].[SuperbillProcedure]
(
	[Inactive] ASC,
	[GlobalPeriodDays] ASC
)
INCLUDE ( 	[SuperbillProcedureUid],
	[SuperbillUid],
	[ProcedureUid],
	[ProcedureServiceDateStart]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SuperbillProcedure]') AND name = N'IX_SUPERBILLUID_INACTIVE_DONTCLAIM')
CREATE NONCLUSTERED INDEX [IX_SUPERBILLUID_INACTIVE_DONTCLAIM] ON [dbo].[SuperbillProcedure]
(
	[SuperbillUid] ASC,
	[Inactive] ASC,
	[DontClaim] ASC
)
INCLUDE ( 	[TotalCharge],
	[ContractTypeCodeUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SuperbillProcedure]') AND name = N'IXR_SuperbillProcedureUid_SuperbillUid_ProcedureServiceDateStartW')
CREATE NONCLUSTERED INDEX [IXR_SuperbillProcedureUid_SuperbillUid_ProcedureServiceDateStartW] ON [dbo].[SuperbillProcedure]
(
	[SuperbillProcedureUid] ASC,
	[SuperbillUid] ASC,
	[ProcedureServiceDateStart] ASC
)
INCLUDE ( 	[ProcedureCharge]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SuperbillProcedure]') AND name = N'IXR_SuperbillUid_SuperbillProcedureUid_ProcedureServiceDateStart')
CREATE NONCLUSTERED INDEX [IXR_SuperbillUid_SuperbillProcedureUid_ProcedureServiceDateStart] ON [dbo].[SuperbillProcedure]
(
	[SuperbillUid] ASC,
	[SuperbillProcedureUid] ASC,
	[ProcedureServiceDateStart] ASC
)
INCLUDE ( 	[ProcedureCharge]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SuperbillProcedure]') AND name = N'ProcedureUid')
CREATE NONCLUSTERED INDEX [ProcedureUid] ON [dbo].[SuperbillProcedure]
(
	[ProcedureUid] ASC
)
INCLUDE ( 	[SuperbillProcedureUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SuperbillProcedure]') AND name = N'SuperbillProcedure_DisplayOrder')
CREATE NONCLUSTERED INDEX [SuperbillProcedure_DisplayOrder] ON [dbo].[SuperbillProcedure]
(
	[SuperbillProcedureUid] ASC,
	[DisplayOrder] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SuperbillProcedure]') AND name = N'SuperbillProcedure_Superbill_Procedure')
CREATE NONCLUSTERED INDEX [SuperbillProcedure_Superbill_Procedure] ON [dbo].[SuperbillProcedure]
(
	[SuperbillProcedureUid] ASC,
	[SuperbillUid] ASC,
	[ProcedureUid] ASC,
	[DiagnosisPointer1] ASC
)
INCLUDE ( 	[ProcedureCharge]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SuperbillProcedureModifier]') AND name = N'IX_SuperbillProcedure')
CREATE NONCLUSTERED INDEX [IX_SuperbillProcedure] ON [dbo].[SuperbillProcedureModifier]
(
	[SuperbillProcedureUid] ASC
)
INCLUDE ( 	[SuperbillProcedureModifierUid],
	[ProcedureModifierUid],
	[DisplayOrder],
	[Inactive],
	[LastModifiedDate],
	[LastModifiedByUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SuperbillUB]') AND name = N'APGProcedure')
CREATE NONCLUSTERED INDEX [APGProcedure] ON [dbo].[SuperbillUB]
(
	[APGProcedureUid] ASC
)
INCLUDE ( 	[SuperbillUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SuperbillUB]') AND name = N'DRGProcedure')
CREATE NONCLUSTERED INDEX [DRGProcedure] ON [dbo].[SuperbillUB]
(
	[DRGProcedureUid] ASC
)
INCLUDE ( 	[SuperbillUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SuperbillUB]') AND name = N'IX_SupervisingProviderUid')
CREATE NONCLUSTERED INDEX [IX_SupervisingProviderUid] ON [dbo].[SuperbillUB]
(
	[SupervisingProviderUid] ASC
)
INCLUDE ( 	[SuperbillUid],
	[OperatingProviderUid],
	[AttendingProviderUid],
	[ServiceAuthorizationNumber],
	[ServiceAuthorizationExceptionUid],
	[SpecialProgramReasonUid],
	[TypeOfBill],
	[ValueCode1Uid],
	[ValueCode1Amount],
	[ValueCode2Uid],
	[ValueCode2Amount],
	[ValueCode3Uid],
	[ValueCode3Amount],
	[ValueCode4Uid],
	[ValueCode4Amount],
	[ValueCode5Uid],
	[ValueCode5Amount],
	[ValueCode6Uid],
	[ValueCode6Amount],
	[ValueCode7Uid],
	[ValueCode7Amount],
	[ValueCode8Uid],
	[ValueCode8Amount],
	[ValueCode9Uid],
	[ValueCode9Amount],
	[ValueCode10Uid],
	[ValueCode10Amount],
	[ValueCode11Uid],
	[ValueCode11Amount],
	[ValueCode12Uid],
	[ValueCode12Amount],
	[ConditionCode1Uid],
	[ConditionCode2Uid],
	[ConditionCode3Uid],
	[ConditionCode4Uid],
	[ConditionCode5Uid],
	[ConditionCode6Uid],
	[ConditionCode7Uid],
	[OccurrenceCode1Uid],
	[OccurrenceCode1Date],
	[OccurrenceCode2Uid],
	[OccurrenceCode2Date],
	[OccurrenceCode3Uid],
	[OccurrenceCode3Date],
	[OccurrenceCode4Uid],
	[OccurrenceCode4Date],
	[OccurrenceCode5Uid],
	[OccurrenceCode5Date],
	[OccurrenceCode6Uid],
	[OccurrenceCode6Date],
	[OccurrenceCode7Uid],
	[OccurrenceCode7Date],
	[OccurrenceCode8Uid],
	[OccurrenceCode8Date],
	[OccurrenceCodeSpan1Uid],
	[OccurrenceCodeSpan1FrDate],
	[OccurrenceCodeSpan1ToDate],
	[OccurrenceCodeSpan2Uid],
	[OccurrenceCodeSpan2FrDate],
	[OccurrenceCodeSpan2ToDate],
	[AdmissionTime],
	[DischargeTime],
	[AdmissionTypeUid],
	[AdmissionSourceUid],
	[PatientStatusUBUid],
	[CoverageDays],
	[NonCoveredDays],
	[CoInsuranceDays],
	[LifetimeReserveDays],
	[AdmittingDiagnosisCode9],
	[AdmittingDiagnosisCode10],
	[AdmittingDiagnosisCodeDescription],
	[AdmittingDiagnosisSnomedCTConceptId],
	[ExternalInjuryCode9],
	[ExternalInjuryCode10],
	[ExternalInjuryCodeDescription],
	[ExternalInjurySnomedCTConceptId],
	[CarePlanOversight],
	[APGProcedureUid],
	[DRGProcedureUid],
	[OtherProcedure1Uid],
	[OtherProcedure1Date],
	[OtherProcedure2Uid],
	[OtherProcedure2Date],
	[OtherProcedure3Uid],
	[OtherProcedure3Date],
	[OtherProcedure4Uid],
	[OtherProcedure4Date],
	[TreatmentAuthorization1],
	[TreatmentAuthorization2],
	[TreatmentAuthorization3],
	[CoveredPeriodFrDate],
	[CoveredPeriodToDate],
	[AssumedDate],
	[RelinquishedDate],
	[LastModifiedDate],
	[LastModifiedByUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SuperbillUB]') AND name = N'OtherProcedure1')
CREATE NONCLUSTERED INDEX [OtherProcedure1] ON [dbo].[SuperbillUB]
(
	[OtherProcedure1Uid] ASC
)
INCLUDE ( 	[SuperbillUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SuperbillUB]') AND name = N'OtherProcedure2')
CREATE NONCLUSTERED INDEX [OtherProcedure2] ON [dbo].[SuperbillUB]
(
	[OtherProcedure2Uid] ASC
)
INCLUDE ( 	[SuperbillUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SuperbillUB]') AND name = N'OtherProcedure3')
CREATE NONCLUSTERED INDEX [OtherProcedure3] ON [dbo].[SuperbillUB]
(
	[OtherProcedure3Uid] ASC
)
INCLUDE ( 	[SuperbillUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SuperbillUB]') AND name = N'OtherProcedure4')
CREATE NONCLUSTERED INDEX [OtherProcedure4] ON [dbo].[SuperbillUB]
(
	[OtherProcedure4Uid] ASC
)
INCLUDE ( 	[SuperbillUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SurveyAttachment]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[SurveyAttachment]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SurveyAttachment]') AND name = N'IX_RelSurveyPatient_WebSurvey')
CREATE NONCLUSTERED INDEX [IX_RelSurveyPatient_WebSurvey] ON [dbo].[SurveyAttachment]
(
	[RelSurveyPatientUid] ASC,
	[WebSurvey] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SurveyPathInfo]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[SurveyPathInfo]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SurveyPathInfo]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[SurveyPathInfo]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SurveyResponse]') AND name = N'IX_DependentSurveyAnswerUid')
CREATE NONCLUSTERED INDEX [IX_DependentSurveyAnswerUid] ON [dbo].[SurveyResponse]
(
	[DependentSurveyAnswerUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SurveyResponse]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[SurveyResponse]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SurveyResponse]') AND name = N'IX_Patient')
CREATE NONCLUSTERED INDEX [IX_Patient] ON [dbo].[SurveyResponse]
(
	[PatientUid] ASC
)
INCLUDE ( 	[SurveyResponseUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[SurveyResponse]') AND name = N'RelSurveyPatient_SurveySection')
CREATE NONCLUSTERED INDEX [RelSurveyPatient_SurveySection] ON [dbo].[SurveyResponse]
(
	[RelSurveyPatientUid] ASC,
	[SurveySectionUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[TemporaryQuestLabOrder]') AND name = N'IX_LabCode')
CREATE NONCLUSTERED INDEX [IX_LabCode] ON [dbo].[TemporaryQuestLabOrder]
(
	[LabCode] ASC
)
INCLUDE ( 	[SplitCategory1],
	[SplitCategory2]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Transcriptionist]') AND name = N'ExternalID')
CREATE NONCLUSTERED INDEX [ExternalID] ON [dbo].[Transcriptionist]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Translation]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[Translation]
(
	[TableName] ASC,
	[Name] ASC
)
INCLUDE ( 	[Spanish]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Translation]') AND name = N'IX_TableName_Name')
CREATE UNIQUE NONCLUSTERED INDEX [IX_TableName_Name] ON [dbo].[Translation]
(
	[TableName] ASC,
	[Name] ASC
)
INCLUDE ( 	[Spanish]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[TransmissionConfiguration]') AND name = N'TransConfig_TransType')
CREATE UNIQUE NONCLUSTERED INDEX [TransConfig_TransType] ON [dbo].[TransmissionConfiguration]
(
	[TransmissionType] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[TransmissionData]') AND name = N'IX_FileName_ClaimClearingHouse_MessageProcessed')
CREATE NONCLUSTERED INDEX [IX_FileName_ClaimClearingHouse_MessageProcessed] ON [dbo].[TransmissionData]
(
	[Filename] ASC,
	[ClaimClearingHouseUid] ASC,
	[MessageProcessed] ASC
)
INCLUDE ( 	[TransmissionDataUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[TransmissionData]') AND name = N'IX_TransmissionData_EligilbilityRequestUid')
CREATE NONCLUSTERED INDEX [IX_TransmissionData_EligilbilityRequestUid] ON [dbo].[TransmissionData]
(
	[EligibilityRequestUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[TransmissionData]') AND name = N'ix_TransmissionData_TransmissionType_RequestId')
CREATE NONCLUSTERED INDEX [ix_TransmissionData_TransmissionType_RequestId] ON [dbo].[TransmissionData]
(
	[TransmissionType] ASC,
	[RequestId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[TransmissionData]') AND name = N'IX_TransmissionDataRequestId')
CREATE NONCLUSTERED INDEX [IX_TransmissionDataRequestId] ON [dbo].[TransmissionData]
(
	[RequestId] ASC
)
INCLUDE ( 	[TransmissionType]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[TransmissionData]') AND name = N'TransData_Processed_TransType_TransRecDate')
CREATE NONCLUSTERED INDEX [TransData_Processed_TransType_TransRecDate] ON [dbo].[TransmissionData]
(
	[TransmissionType] ASC,
	[MessageProcessed] ASC,
	[TransmissionReceivedDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[TransmissionOutbound]') AND name = N'IX_TransmissionOutbound_ForeignObjectUid')
CREATE NONCLUSTERED INDEX [IX_TransmissionOutbound_ForeignObjectUid] ON [dbo].[TransmissionOutbound]
(
	[ForeignObjectUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[TransmissionOutbound]') AND name = N'IX_TransmissionOutbound_Status_ForeignObjectUid')
CREATE NONCLUSTERED INDEX [IX_TransmissionOutbound_Status_ForeignObjectUid] ON [dbo].[TransmissionOutbound]
(
	[Status] ASC
)
INCLUDE ( 	[ForeignObjectUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[TransmissionOutbound]') AND name = N'IX_TransmissionOutbound_TransmissionType_Status_Uid_Enqueued')
CREATE NONCLUSTERED INDEX [IX_TransmissionOutbound_TransmissionType_Status_Uid_Enqueued] ON [dbo].[TransmissionOutbound]
(
	[TransmissionType] ASC,
	[Status] ASC
)
INCLUDE ( 	[TransmissionOutboundUid],
	[EnqueuedTimestamp]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[TransmissionOutbound]') AND name = N'IX_TransmissionOutbound_TransmissionType_Status_Uid_RM_Enqueued')
CREATE NONCLUSTERED INDEX [IX_TransmissionOutbound_TransmissionType_Status_Uid_RM_Enqueued] ON [dbo].[TransmissionOutbound]
(
	[TransmissionType] ASC,
	[Status] ASC
)
INCLUDE ( 	[TransmissionOutboundUid],
	[RawMessage],
	[EnqueuedTimestamp]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[TransmissionOutbound]') AND name = N'SuccTransTS_NumTransAtt_Status_NextSendAtt_EnqueTS_TranOutUid')
CREATE NONCLUSTERED INDEX [SuccTransTS_NumTransAtt_Status_NextSendAtt_EnqueTS_TranOutUid] ON [dbo].[TransmissionOutbound]
(
	[SuccessfulTransmissionTimestamp] ASC,
	[NumberOfTransmissionAttempts] ASC,
	[Status] ASC,
	[NextSendAttempt] ASC,
	[TransmissionType] ASC,
	[EnqueuedTimestamp] ASC,
	[TransmissionOutboundUid] ASC
)
INCLUDE ( 	[Description],
	[RawMessage],
	[TransmissionControlXML],
	[LastTransmissionAttempt],
	[LastError],
	[LastModifiedDate],
	[LastModifiedByUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[TransmissionOutbound]') AND name = N'TransOutUid_Status_ForeignObjUid_LastErr')
CREATE NONCLUSTERED INDEX [TransOutUid_Status_ForeignObjUid_LastErr] ON [dbo].[TransmissionOutbound]
(
	[TransmissionType] ASC
)
INCLUDE ( 	[TransmissionOutboundUid],
	[Status],
	[ForeignObjectUid],
	[LastError]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[UB04Claim]') AND name = N'IX_UB04Claim_ClaimBatchUID')
CREATE NONCLUSTERED INDEX [IX_UB04Claim_ClaimBatchUID] ON [dbo].[UB04Claim]
(
	[ClaimBatchUID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[UnlinkedDocument]') AND name = N'IX_DocumentLinkingFolderType_UnlinkedDocumentLinkingType')
CREATE NONCLUSTERED INDEX [IX_DocumentLinkingFolderType_UnlinkedDocumentLinkingType] ON [dbo].[UnlinkedDocument]
(
	[DocumentLinkingFolderTypeUid] ASC,
	[UnlinkedDocumentLinkingLockUid] ASC
)
INCLUDE ( 	[UnlinkedDocumentUid],
	[AttachmentUid],
	[RejectedByUid],
	[MessageUid],
	[Inactive],
	[UserDefined],
	[LastModifiedByUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[UnlinkedDocument]') AND name = N'IX_Message')
CREATE NONCLUSTERED INDEX [IX_Message] ON [dbo].[UnlinkedDocument]
(
	[MessageUid] ASC
)
INCLUDE ( 	[UnlinkedDocumentUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[UnlinkedDocument]') AND name = N'IX_UnlinkedDocument')
CREATE NONCLUSTERED INDEX [IX_UnlinkedDocument] ON [dbo].[UnlinkedDocument]
(
	[AttachmentUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[UserGroupMember]') AND name = N'IDX_UserGroupMember_MemberUserGroupUid')
CREATE NONCLUSTERED INDEX [IDX_UserGroupMember_MemberUserGroupUid] ON [dbo].[UserGroupMember]
(
	[MemberUserGroupUid] ASC
)
INCLUDE ( 	[UserGroupUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[UserGroupMember]') AND name = N'IDX_UserGroupMember_MemberUserUid')
CREATE NONCLUSTERED INDEX [IDX_UserGroupMember_MemberUserUid] ON [dbo].[UserGroupMember]
(
	[MemberUserUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[UserGroupMember]') AND name = N'IX_UserGroup_MemberUseGroup_MemberUser')
CREATE NONCLUSTERED INDEX [IX_UserGroup_MemberUseGroup_MemberUser] ON [dbo].[UserGroupMember]
(
	[UserGroupUid] ASC,
	[MemberUserGroupUid] ASC,
	[MemberUserUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[UserGroupMember]') AND name = N'IX_UserGroupMember')
CREATE NONCLUSTERED INDEX [IX_UserGroupMember] ON [dbo].[UserGroupMember]
(
	[UserGroupUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[UserMessageDefault]') AND name = N'IX_User')
CREATE NONCLUSTERED INDEX [IX_User] ON [dbo].[UserMessageDefault]
(
	[UserUid] ASC
)
INCLUDE ( 	[UserMessageDefaultUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[UserPRM]') AND name = N'ExternalID')
CREATE NONCLUSTERED INDEX [ExternalID] ON [dbo].[UserPRM]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[UserPRM]') AND name = N'IX_Login')
CREATE NONCLUSTERED INDEX [IX_Login] ON [dbo].[UserPRM]
(
	[Login] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[UserPRM]') AND name = N'SID')
CREATE NONCLUSTERED INDEX [SID] ON [dbo].[UserPRM]
(
	[SID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[UserPRM]') AND name = N'UserPRM_PersonUid_LastModifiedDate')
CREATE NONCLUSTERED INDEX [UserPRM_PersonUid_LastModifiedDate] ON [dbo].[UserPRM]
(
	[PersonUid] ASC,
	[LastModifiedDate] ASC
)
INCLUDE ( 	[Inactive]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Visit]') AND name = N'AppointmentUid')
CREATE NONCLUSTERED INDEX [AppointmentUid] ON [dbo].[Visit]
(
	[AppointmentUid] ASC
)
INCLUDE ( 	[PatientUid],
	[VisitDate],
	[ProviderUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Visit]') AND name = N'IDXI_Visit_VisitDate')
CREATE NONCLUSTERED INDEX [IDXI_Visit_VisitDate] ON [dbo].[Visit]
(
	[VisitDate] ASC
)
INCLUDE ( 	[VisitUid],
	[PatientUid],
	[ProviderUid],
	[RenderingProviderUid],
	[VisitTypeUid],
	[PatientDeclinedClinicalSummary],
	[LastSavedByUid],
	[SavedByBillingProvider],
	[SavedByRenderingProvider]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Visit]') AND name = N'IDXR_IsCompleted_ProviderUid')
CREATE NONCLUSTERED INDEX [IDXR_IsCompleted_ProviderUid] ON [dbo].[Visit]
(
	[IsCompleted] ASC,
	[ProviderUid] ASC
)
INCLUDE ( 	[VisitUid],
	[AppointmentUid],
	[PatientUid],
	[VisitDate],
	[RenderingProviderUid],
	[ServiceSiteUid],
	[VoiceAttachmentUid],
	[VisitTypeUid],
	[LastSavedByUid],
	[LastModifiedByUid],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Visit]') AND name = N'IX_Account')
CREATE NONCLUSTERED INDEX [IX_Account] ON [dbo].[Visit]
(
	[AccountUid] ASC
)
INCLUDE ( 	[VisitUid],
	[VisitDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Visit]') AND name = N'IX_DeclinedClinicalSummary')
CREATE NONCLUSTERED INDEX [IX_DeclinedClinicalSummary] ON [dbo].[Visit]
(
	[PatientDeclinedClinicalSummary] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Visit]') AND name = N'IX_IsCompleted_LastModifiedDate')
CREATE NONCLUSTERED INDEX [IX_IsCompleted_LastModifiedDate] ON [dbo].[Visit]
(
	[IsCompleted] ASC,
	[LastModifiedDate] ASC
)
INCLUDE ( 	[VisitUid],
	[PatientUid],
	[VisitDate],
	[LastModifiedByUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Visit]') AND name = N'IX_LastModifiedBy')
CREATE NONCLUSTERED INDEX [IX_LastModifiedBy] ON [dbo].[Visit]
(
	[LastModifiedByUid] ASC
)
INCLUDE ( 	[PatientUid],
	[VisitDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Visit]') AND name = N'IX_LastModifiedDate')
CREATE NONCLUSTERED INDEX [IX_LastModifiedDate] ON [dbo].[Visit]
(
	[LastModifiedDate] ASC
)
INCLUDE ( 	[ProviderUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Visit]') AND name = N'IX_LastSavedBy')
CREATE NONCLUSTERED INDEX [IX_LastSavedBy] ON [dbo].[Visit]
(
	[LastSavedByUid] ASC
)
INCLUDE ( 	[PatientUid],
	[VisitDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Visit]') AND name = N'IX_PatientCase')
CREATE NONCLUSTERED INDEX [IX_PatientCase] ON [dbo].[Visit]
(
	[PatientCaseUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Visit]') AND name = N'IX_Provider')
CREATE NONCLUSTERED INDEX [IX_Provider] ON [dbo].[Visit]
(
	[ProviderUid] ASC
)
INCLUDE ( 	[VisitUid],
	[VisitDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Visit]') AND name = N'IX_Visit_Financials')
CREATE NONCLUSTERED INDEX [IX_Visit_Financials] ON [dbo].[Visit]
(
	[VisitUid] ASC,
	[FinancialCenterUid] ASC,
	[ServiceSiteUid] ASC,
	[ProviderUid] ASC,
	[RenderingProviderUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Visit]') AND name = N'IX_Visit_Patient_VisitDate_Appointment')
CREATE NONCLUSTERED INDEX [IX_Visit_Patient_VisitDate_Appointment] ON [dbo].[Visit]
(
	[VisitUid] ASC,
	[PatientUid] ASC,
	[VisitDate] ASC,
	[AppointmentUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Visit]') AND name = N'ix_VisitTypeUid')
CREATE NONCLUSTERED INDEX [ix_VisitTypeUid] ON [dbo].[Visit]
(
	[VisitUid] ASC,
	[VisitTypeUid] ASC
)
INCLUDE ( 	[PatientUid],
	[VisitDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Visit]') AND name = N'IX_VoiceAttachmentUid')
CREATE NONCLUSTERED INDEX [IX_VoiceAttachmentUid] ON [dbo].[Visit]
(
	[VoiceAttachmentUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Visit]') AND name = N'IXR_AppointmentUid_PatientUid_VisitDate_ProviderUid')
CREATE NONCLUSTERED INDEX [IXR_AppointmentUid_PatientUid_VisitDate_ProviderUid] ON [dbo].[Visit]
(
	[AppointmentUid] ASC,
	[PatientUid] ASC,
	[VisitDate] ASC,
	[ProviderUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Visit]') AND name = N'IXR_AppointmentUid_VisitUid_PatientUid_VisitDate')
CREATE NONCLUSTERED INDEX [IXR_AppointmentUid_VisitUid_PatientUid_VisitDate] ON [dbo].[Visit]
(
	[AppointmentUid] ASC,
	[VisitUid] ASC,
	[PatientUid] ASC,
	[VisitDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Visit]') AND name = N'IXR_IsCompleted_ProviderUidW')
CREATE NONCLUSTERED INDEX [IXR_IsCompleted_ProviderUidW] ON [dbo].[Visit]
(
	[VisitUid] ASC,
	[ProviderUid] ASC
)
INCLUDE ( 	[IsCompleted]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Visit]') AND name = N'IXR_VisitDate_VisitUid_PatientUid')
CREATE NONCLUSTERED INDEX [IXR_VisitDate_VisitUid_PatientUid] ON [dbo].[Visit]
(
	[VisitDate] ASC,
	[VisitUid] ASC,
	[PatientUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Visit]') AND name = N'Visit_IsComplete_LastModifiedByUid')
CREATE NONCLUSTERED INDEX [Visit_IsComplete_LastModifiedByUid] ON [dbo].[Visit]
(
	[IsCompleted] ASC,
	[LastModifiedByUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Visit]') AND name = N'Visit_VisitPatient')
CREATE NONCLUSTERED INDEX [Visit_VisitPatient] ON [dbo].[Visit]
(
	[VisitUid] ASC,
	[VisitDate] ASC,
	[PatientUid] ASC,
	[PatientCaseUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[Visit]') AND name = N'VisitDate_VisitUid_PatientUid_ProviderUid_VisitTypeUid')
CREATE NONCLUSTERED INDEX [VisitDate_VisitUid_PatientUid_ProviderUid_VisitTypeUid] ON [dbo].[Visit]
(
	[VisitDate] ASC,
	[VisitUid] ASC,
	[PatientUid] ASC,
	[ProviderUid] ASC,
	[VisitTypeUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitAccess]') AND name = N'IX_VisitAccess_Covering')
CREATE NONCLUSTERED INDEX [IX_VisitAccess_Covering] ON [dbo].[VisitAccess]
(
	[VisitUid] ASC,
	[UserUid] ASC,
	[UserGroupUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitAccess]') AND name = N'IX_VisitAccess_VisitUid')
CREATE NONCLUSTERED INDEX [IX_VisitAccess_VisitUid] ON [dbo].[VisitAccess]
(
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitAssessmentForm]') AND name = N'IX_Visit')
CREATE NONCLUSTERED INDEX [IX_Visit] ON [dbo].[VisitAssessmentForm]
(
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitAssessmentForm]') AND name = N'ix_VisitAssessmentForm_ObservationOrderUid')
CREATE NONCLUSTERED INDEX [ix_VisitAssessmentForm_ObservationOrderUid] ON [dbo].[VisitAssessmentForm]
(
	[ObservationOrderUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitComment]') AND name = N'IX_VisitComment')
CREATE NONCLUSTERED INDEX [IX_VisitComment] ON [dbo].[VisitComment]
(
	[VisitUid] ASC,
	[VisitCommentUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitCoSign]') AND name = N'IX_Cosign')
CREATE NONCLUSTERED INDEX [IX_Cosign] ON [dbo].[VisitCoSign]
(
	[CosignUid] ASC
)
INCLUDE ( 	[VisitCoSignUid],
	[VisitUid],
	[CompletedUid],
	[IsCompleted],
	[IsApproved]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitDiagnosis]') AND name = N'IX_Code10VisitUid')
CREATE NONCLUSTERED INDEX [IX_Code10VisitUid] ON [dbo].[VisitDiagnosis]
(
	[Code10] ASC,
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitDiagnosis]') AND name = N'IX_CodeVisitUid')
CREATE NONCLUSTERED INDEX [IX_CodeVisitUid] ON [dbo].[VisitDiagnosis]
(
	[Code] ASC,
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitDiagnosis]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[VisitDiagnosis]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitDiagnosis]') AND name = N'ix_VisitDiagnosis_PatientProblemDiagnosisHistoryUid')
CREATE NONCLUSTERED INDEX [ix_VisitDiagnosis_PatientProblemDiagnosisHistoryUid] ON [dbo].[VisitDiagnosis]
(
	[PatientProblemDiagnosisHistoryUid] ASC
)
INCLUDE ( 	[VisitDiagnosisUid],
	[VisitUid],
	[DiagnosisPanelUid],
	[ProblemGroupingUid],
	[Code],
	[HccModelCat],
	[LexicalCode],
	[LifeLong],
	[SortToBottom],
	[IsDelete],
	[IsAddendum],
	[LastModifiedByUid],
	[LastModifiedDate],
	[VisitDiagnosisType],
	[AddendumNotes],
	[DSMAxis],
	[DpnGroupUid],
	[DpnXml],
	[HccCommunityFactors],
	[Code10],
	[Name],
	[Notes],
	[DisplayOrder],
	[SnomedCTConceptId],
	[FollowupFlag]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitDiagnosis]') AND name = N'IX_VisitDiagnosis_VisitUid_IsDelete')
CREATE NONCLUSTERED INDEX [IX_VisitDiagnosis_VisitUid_IsDelete] ON [dbo].[VisitDiagnosis]
(
	[VisitUid] ASC,
	[IsDelete] ASC
)
INCLUDE ( 	[VisitDiagnosisUid],
	[Code],
	[Code10],
	[Name],
	[DisplayOrder],
	[VisitDiagnosisType],
	[LastModifiedDate]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitDiagnosis]') AND name = N'IX_VisitUid')
CREATE NONCLUSTERED INDEX [IX_VisitUid] ON [dbo].[VisitDiagnosis]
(
	[VisitUid] ASC
)
INCLUDE ( 	[Code],
	[Code10]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitDiet]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[VisitDiet]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitDiet]') AND name = N'IX_Visit')
CREATE NONCLUSTERED INDEX [IX_Visit] ON [dbo].[VisitDiet]
(
	[VisitUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitEduForm]') AND name = N'IDX_VisitEduForm_EduFormUid')
CREATE NONCLUSTERED INDEX [IDX_VisitEduForm_EduFormUid] ON [dbo].[VisitEduForm]
(
	[EduFormUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitEduForm]') AND name = N'IX_PrintedUser')
CREATE NONCLUSTERED INDEX [IX_PrintedUser] ON [dbo].[VisitEduForm]
(
	[PrintedUserUid] ASC
)
INCLUDE ( 	[VisitUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitEduForm]') AND name = N'MedicationSIGUid')
CREATE NONCLUSTERED INDEX [MedicationSIGUid] ON [dbo].[VisitEduForm]
(
	[MedicationSIGUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitExercise]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[VisitExercise]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitExercise]') AND name = N'IX_VisitUid_ExerciseUid')
CREATE NONCLUSTERED INDEX [IX_VisitUid_ExerciseUid] ON [dbo].[VisitExercise]
(
	[VisitUid] ASC,
	[ExerciseUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitHpi]') AND name = N'IDX_VisitUid_HpiCategoryUid')
CREATE NONCLUSTERED INDEX [IDX_VisitUid_HpiCategoryUid] ON [dbo].[VisitHpi]
(
	[VisitUid] ASC,
	[HpiCategoryUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitPE]') AND name = N'IXR_VisitUid_LastModifiedByUid')
CREATE NONCLUSTERED INDEX [IXR_VisitUid_LastModifiedByUid] ON [dbo].[VisitPE]
(
	[VisitUid] ASC,
	[LastModifiedByUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitPlan]') AND name = N'IXR_FUAppointmentUid')
CREATE NONCLUSTERED INDEX [IXR_FUAppointmentUid] ON [dbo].[VisitPlan]
(
	[FUAppointmentUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitProcedure]') AND name = N'IDXI_VisitProcedure_IsDelete_NegationReasonUid')
CREATE NONCLUSTERED INDEX [IDXI_VisitProcedure_IsDelete_NegationReasonUid] ON [dbo].[VisitProcedure]
(
	[IsDelete] ASC,
	[NegationReasonUid] ASC
)
INCLUDE ( 	[VisitProcedureUid],
	[VisitUid],
	[ProcedureUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitProcedure]') AND name = N'IsDelete_VisitUid_ProcedureUid')
CREATE NONCLUSTERED INDEX [IsDelete_VisitUid_ProcedureUid] ON [dbo].[VisitProcedure]
(
	[IsDelete] ASC,
	[VisitUid] ASC,
	[ProcedureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitProcedure]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[VisitProcedure]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitProcedure]') AND name = N'IX_Procedure_GlobalPeriodInfo')
CREATE NONCLUSTERED INDEX [IX_Procedure_GlobalPeriodInfo] ON [dbo].[VisitProcedure]
(
	[GlobalPeriodDays] ASC,
	[IsDelete] ASC,
	[IsPerformed] ASC
)
INCLUDE ( 	[VisitUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitProcedure]') AND name = N'IX_Procedure_IsDelete')
CREATE NONCLUSTERED INDEX [IX_Procedure_IsDelete] ON [dbo].[VisitProcedure]
(
	[ProcedureUid] ASC,
	[IsDelete] ASC
)
INCLUDE ( 	[VisitProcedureUid],
	[VisitUid],
	[Unit],
	[IsPerformed]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitProcedure]') AND name = N'IX_Procedure_IsPerformed')
CREATE NONCLUSTERED INDEX [IX_Procedure_IsPerformed] ON [dbo].[VisitProcedure]
(
	[ProcedureUid] ASC,
	[IsPerformed] ASC
)
INCLUDE ( 	[VisitUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitProcedure]') AND name = N'IX_VisitProcedure_Procedure')
CREATE NONCLUSTERED INDEX [IX_VisitProcedure_Procedure] ON [dbo].[VisitProcedure]
(
	[VisitProcedureUid] ASC,
	[VisitUid] ASC,
	[ProcedureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitProcedure]') AND name = N'IX_VisitProcedure_ProcedureUid_DisplayOrder')
CREATE NONCLUSTERED INDEX [IX_VisitProcedure_ProcedureUid_DisplayOrder] ON [dbo].[VisitProcedure]
(
	[VisitProcedureUid] ASC,
	[VisitUid] ASC,
	[ProcedureUid] ASC,
	[DisplayOrder] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitProcedure]') AND name = N'IX_VisitProcedure_TemplateSearch')
CREATE NONCLUSTERED INDEX [IX_VisitProcedure_TemplateSearch] ON [dbo].[VisitProcedure]
(
	[ProcedureUid] ASC,
	[VisitProcedureUid] ASC,
	[LastModifiedDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitProcedure]') AND name = N'IX_VisitProcedure_VisitUid_IsEM')
CREATE NONCLUSTERED INDEX [IX_VisitProcedure_VisitUid_IsEM] ON [dbo].[VisitProcedure]
(
	[VisitUid] ASC,
	[IsEM] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitProcedureDiagnosis]') AND name = N'IX_VisitDiagnosisUid')
CREATE NONCLUSTERED INDEX [IX_VisitDiagnosisUid] ON [dbo].[VisitProcedureDiagnosis]
(
	[VisitDiagnosisUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitProcedureOrderAction]') AND name = N'IDX_VisitProcedureOrderAction_RelAttachmentGroupUid')
CREATE NONCLUSTERED INDEX [IDX_VisitProcedureOrderAction_RelAttachmentGroupUid] ON [dbo].[VisitProcedureOrderAction]
(
	[RelAttachmentGroupUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitProcedureOrderAction]') AND name = N'IX_VisitProcedureOrderAction_MessageUid')
CREATE NONCLUSTERED INDEX [IX_VisitProcedureOrderAction_MessageUid] ON [dbo].[VisitProcedureOrderAction]
(
	[MessageUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitProcedureOrderAction]') AND name = N'IX_VisitProcedureOrderAction_VisitProcedureUid')
CREATE NONCLUSTERED INDEX [IX_VisitProcedureOrderAction_VisitProcedureUid] ON [dbo].[VisitProcedureOrderAction]
(
	[VisitProcedureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VisitVoiceAttachment]') AND name = N'IX_VisitVoiceAttachment')
CREATE NONCLUSTERED INDEX [IX_VisitVoiceAttachment] ON [dbo].[VisitVoiceAttachment]
(
	[LastModifiedDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VitalMinMax]') AND name = N'IX_VitalMinMax')
CREATE NONCLUSTERED INDEX [IX_VitalMinMax] ON [dbo].[VitalMinMax]
(
	[ObservationItemUid] ASC,
	[AgeFromInMonths] ASC,
	[AgeFromIsYear] ASC,
	[AgeToInMonths] ASC,
	[AgeToIsYear] ASC,
	[Max1] ASC,
	[Max2] ASC,
	[Min1] ASC,
	[Min2] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VoiceAttachment]') AND name = N'IX_DictationToTranscribedId')
CREATE NONCLUSTERED INDEX [IX_DictationToTranscribedId] ON [dbo].[VoiceAttachment]
(
	[DictationToTranscribedId] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VoiceAttachment]') AND name = N'IX_VoiceAttachment_DateReceived')
CREATE NONCLUSTERED INDEX [IX_VoiceAttachment_DateReceived] ON [dbo].[VoiceAttachment]
(
	[DateReceived] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VoiceAttachment]') AND name = N'IX_VoiceAttachment_DateRecorded')
CREATE NONCLUSTERED INDEX [IX_VoiceAttachment_DateRecorded] ON [dbo].[VoiceAttachment]
(
	[DateRecorded] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VoiceAttachment]') AND name = N'IX_VoiceAttachment_DateSent')
CREATE NONCLUSTERED INDEX [IX_VoiceAttachment_DateSent] ON [dbo].[VoiceAttachment]
(
	[DateSent] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VoiceAttachment]') AND name = N'IX_VoiceAttachment_RecordedByUid')
CREATE NONCLUSTERED INDEX [IX_VoiceAttachment_RecordedByUid] ON [dbo].[VoiceAttachment]
(
	[RecordedByUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[VoiceAttachment]') AND name = N'IX_VoiceAttachment_TranscriptionistUid')
CREATE NONCLUSTERED INDEX [IX_VoiceAttachment_TranscriptionistUid] ON [dbo].[VoiceAttachment]
(
	[TranscriptionistUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[WaitingList]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[WaitingList]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[WaitingList]') AND name = N'IX_WaitingList')
CREATE UNIQUE NONCLUSTERED INDEX [IX_WaitingList] ON [dbo].[WaitingList]
(
	[Name] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[WaitingListDetail]') AND name = N'IX_Appointment')
CREATE NONCLUSTERED INDEX [IX_Appointment] ON [dbo].[WaitingListDetail]
(
	[AppointmentUid] ASC
)
INCLUDE ( 	[WaitingListDetailUid]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_PADDING ON

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[WaitingListDetail]') AND name = N'IX_ExternalID')
CREATE NONCLUSTERED INDEX [IX_ExternalID] ON [dbo].[WaitingListDetail]
(
	[ExternalID] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[WebRegistration]') AND name = N'IX_Person')
CREATE NONCLUSTERED INDEX [IX_Person] ON [dbo].[WebRegistration]
(
	[PersonUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO

