IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getFormattedName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION  [dbo].[UDF_getFormattedName]
(
	@sPrefix	varchar(25),
	@sFirstName	varchar(50),
	@sMiddleName	varchar(50),
	@sLastName	varchar(50),
	@sSuffix	varchar(50)
)
RETURNS varchar(225) WITH SCHEMABINDING
AS
BEGIN 
	return(
		(CASE WHEN @sPrefix is null OR RTRIM(@sPrefix) = '''' THEN '''' ELSE @sPrefix + '' '' END) 
		+ (CASE WHEN @sLastName is null OR RTRIM(@sLastName) = '''' THEN '''' ELSE @sLastName + '', '' END)
		+ (CASE WHEN @sFirstName is null OR RTRIM(@sFirstName) = '''' THEN '''' ELSE @sFirstName END)
		+ (CASE WHEN @sMiddleName is null OR RTRIM(@sMiddleName) = '''' THEN '''' ELSE '' '' +@sMiddleName END)
		+ (CASE WHEN @sSuffix is null OR RTRIM(@sSuffix) = '''' THEN '''' ELSE '', '' + @sSuffix END)
	)

	/* Example:
	select top 10 
	dbo.UDF_getFormattedName(
		p.Prefix,
		p.FirstName,
		p.MiddleName,
		p.LastName,
		p.Suffix)
	from Person p
	*/
END
' 
END
GO


IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getFormattedInternalName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION  [dbo].[UDF_getFormattedInternalName]
(
	@firstName	varchar(50),
	@middleName	varchar(50),
	@lastName	varchar(50),
	@akaFirstName varchar(50),
	@akaLastName varchar(50)
)
RETURNS varchar(250) WITH SCHEMABINDING
AS
BEGIN 

	DECLARE @name VARCHAR(200)
	
	IF @akaLastName IS NULL OR RTRIM(@akaLastName) = ''''
		SET @name = @lastName
	ELSE
		SET @name = @akaLastName
		
	IF RTRIM(@name) <> ''''
		SET @name = @name + '', ''
		
	IF @akaFirstName IS NULL OR RTRIM(@akaFirstName) = ''''
		SET @name = @name + @firstName
	ELSE
		SET @name = @name + @akaFirstName
	
	IF RTRIM(@middleName) <> ''''
		SET @name = @name + '' '' + @middleName
		
	RETURN @name
END
' 
END
GO


IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewPerson]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewPerson] WITH SCHEMABINDING AS
SELECT	P.PersonUid, Inactive, Prefix, FirstName, MiddleName, LastName, Suffix, AkaFirstName, AkaLastName,
    SocialSecurityNumber, Birthdate, Deathdate, DriverLicenseNumber,
    dbo.UDF_getFormattedName(Prefix, FirstName, MiddleName, LastName, Suffix) AS FullName,
    dbo.UDF_getFormattedInternalName(FirstName, MiddleName, LastName, AkaFirstName, AkaLastName) AS FormattedInternalName,
    dbo.UDF_getFormattedName(NULL, FirstName, MiddleName, LastName, Suffix) AS FormattedPreferredName,
    dbo.UDF_getFormattedName(NULL, ISNULL(AkaFirstName, FirstName), NULL, ISNULL(AkaLastName, LastName), NULL) AS AkaName,
    p.Address1, 
    p.Computed_Address1_Address1 AS Address1_Address1,
    p.Computed_Address1_Address2 AS Address1_Address2,
    p.Computed_Address1_City AS Address1_City,
    p.Computed_Address1_State AS Address1_State,
    p.Computed_Address1_Zip AS Address1_Zip,
    p.Phone1, 
    p.Computed_Phone1_PhoneNumber AS PhoneNumber1,
    p.Computed_Phone1_PhoneType AS PhoneType1,
    REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(p.Computed_Phone1_PhoneNumber, ''-'', ''''), '' '', ''''), ''('', ''''), '')'', ''''), ''ext'', ''''), ''x'', '''') AS PhoneNumberScrubbed,
    p.Phone2, 
    p.Computed_Phone2_PhoneNumber AS PhoneNumber2,
    p.Computed_Phone2_PhoneType AS PhoneType2,
    p.Phone3, 
    p.Computed_Phone3_PhoneNumber AS PhoneNumber3,
    p.Computed_Phone3_PhoneType AS PhoneType3,
    p.Phone4,
    p.Computed_Phone4_PhoneNumber AS PhoneNumber4,
    p.Computed_Phone4_PhoneType AS PhoneType4,
    p.Email1,
    p.Email2,
    p.EmailDirect,
    p.PreferredContactMethod,
	p.Email1MessagingAllowed,
	p.Email2MessagingAllowed,
	p.Phone1MessagingAllowed,
	p.Phone2MessagingAllowed,
	p.Phone3MessagingAllowed,
	p.Phone4MessagingAllowed	
FROM	dbo.Person P            

/* Make sure indexes exist when you alter this view. If not recreate the indexes below
CREATE UNIQUE CLUSTERED INDEX IX_PersonUid ON ViewPerson(PersonUid)
CREATE INDEX IX_LastName ON ViewPerson(LastName)
CREATE INDEX IX_FirstName ON ViewPerson(FirstName)
CREATE INDEX IX_Name ON ViewPerson(FirstName, LastName)
CREATE INDEX IX_SSN ON ViewPerson(SocialSecurityNumber)
CREATE INDEX IX_DL ON ViewPerson(DriverLicenseNumber)
CREATE INDEX IX_Birthdate ON ViewPerson(BirthDate)
CREATE INDEX IX_Address1_Address1 ON ViewPerson(Address1_Address1)
CREATE INDEX IX_Address1_City ON ViewPerson(Address1_City)
CREATE INDEX IX_Address1_State ON ViewPerson(Address1_State)
CREATE INDEX IX_Address1_Zip ON ViewPerson(Address1_Zip)
CREATE INDEX IX_FormattedInternalName ON ViewPerson(FormattedInternalName)
CREATE INDEX IX_FormattedPreferredName ON ViewPerson(FormattedPreferredName)
CREATE INDEX IX_FullName ON ViewPerson(FullName)
*/
' 
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ViewPerson]') AND name = N'IX_PersonUid')
CREATE UNIQUE CLUSTERED INDEX [IX_PersonUid] ON [dbo].[ViewPerson]
(
	[PersonUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO




-- Fix for bug #15851 - We need a migration script to set the Microsoft ink to no ink as default
-- set user inking option to "No" inking.
--
if not exists (select * from  ListProductParameter where ProductParameterUid = '1A1C99D9-81AE-402C-BEA3-E4B17CC3D6F2')
begin
	insert into ListProductParameter (ProductParameterUid, ParameterName)
		values ('1A1C99D9-81AE-402C-BEA3-E4B17CC3D6F2', 'Inking option set to "no" inking')
		
	update ListUserSetting set InkInput = 0
end
GO

--  17985_DiagnosisSearchDefinition_Migration.sql
IF NOT EXISTS(Select * from RelDiagnosisDpn where RelDiagnosisDpnUid = 'F68B532F-78A7-47B2-8C92-9B07EB60CA9B')
BEGIN
insert into RelDiagnosisDpn(RelDiagnosisDpnUid, DpnGroupUid,DiagnosisSearchDefinition,UserDefined,LastModifiedDate)
values('F68B532F-78A7-47B2-8C92-9B07EB60CA9B', '5509FD5A-76C1-494C-AAA4-6E7FEC85AEA6','<root>    <SearchDefinition name="Cancer Registry">      <SearchAttribute field="IcdRange">C00.0;C00.1;C00.2;C00.3;C00.4;C00.5;C00.6;C00.8;C00.9;C01;C02.0;C02.1;C02.2;C02.3;C02.4;C02.8;C02.9;C03.0;C03.1;C03.9;C04.0;C04.1;C04.8;C04.9;C05.0;C05.1;C05.2;C05.8;C05.9;C06.0;C06.1;C06.2;C06.80;C06.89;C06.9;C07;C08.0;C08.1;C08.9;C09.0;C09.1;C09.8;C09.9;C10.0;C10.1;C10.2;C10.3;C10.4;C10.8;C10.9;C11.0;C11.1;C11.2;C11.3;C11.8;C11.9;C12;C13.0;C13.1;C13.2;C13.8;C13.9;C14.0;C14.2;C14.8;C15.3;C15.4;C15.5;C15.8;C15.9;C16.0;C16.1;C16.2;C16.3;C16.4;C16.5;C16.6;C16.8;C16.9;C17.0;C17.1;C17.2;C17.3;C17.8;C17.9;C18.0;C18.1;C18.2;C18.3;C18.4;C18.5;C18.6;C18.7;C18.8;C18.9;C19;C20;C21.0;C21.1;C21.2;C21.8;C22.0;C22.1;C22.2;C22.3;C22.4;C22.7;C22.8;C22.9;C23;C24.0;C24.1;C24.8;C24.9;C25.0;C25.1;C25.2;C25.3;C25.4;C25.7;C25.8;C25.9;C26.0;C26.1;C26.9;C30.0;C30.1;C31.0;C31.1;C31.2;C31.3;C31.8;C31.9;C32.0;C32.1;C32.2;C32.3;C32.8;C32.9;C33;C34.00;C34.01;C34.02;C34.10;C34.11;C34.12;C34.2;C34.30;C34.31;C34.32;C34.80;C34.81;C34.82;C34.90;C34.91;C34.92;C37;C38.0;C38.1;C38.2;C38.3;C38.4;C38.8;C39.0;C39.9;C40.00;C40.01;C40.02;C40.10;C40.11;C40.12;C40.20;C40.21;C40.22;C40.30;C40.31;C40.32;C40.80;C40.81;C40.82;C40.90;C40.91;C40.92;C41.0;C41.1;C41.2;C41.3;C41.4;C41.9;C43.0;C43.10;C43.11;C43.12;C43.20;C43.21;C43.22;C43.30;C43.31;C43.39;C43.4;C43.51;C43.52;C43.59;C43.60;C43.61;C43.62;C43.70;C43.71;C43.72;C43.8;C43.9;C44.00;C44.09;C44.101;C44.102;C44.109;C44.191;C44.192;C44.199;C44.201;C44.202;C44.209;C44.291;C44.292;C44.299;C44.300;C44.301;C44.309;C44.390;C44.391;C44.399;C44.40;C44.49;C44.500;C44.501;C44.509;C44.590;C44.591;C44.599;C44.601;C44.602;C44.609;C44.691;C44.692;C44.699;C44.701;C44.702;C44.709;C44.791;C44.792;C44.799;C44.80;C44.89;C44.90;C44.99;C45.0;C45.1;C45.2;C45.7;C45.9;C46.0;C46.1;C46.2;C46.3;C46.4;C46.50;C46.51;C46.52;C46.7;C46.9;C47.0;C47.10;C47.11;C47.12;C47.20;C47.21;C47.22;C47.3;C47.4;C47.5;C47.6;C47.8;C47.9;C48.0;C48.1;C48.2;C48.8;C49.0;C49.10;C49.11;C49.12;C49.20;C49.21;C49.22;C49.3;C49.4;C49.5;C49.6;C49.8;C49.9;C4A.0;C4A.10;C4A.11;C4A.12;C4A.20;C4A.21;C4A.22;C4A.30;C4A.31;C4A.39;C4A.4;C4A.51;C4A.52;C4A.59;C4A.60;C4A.61;C4A.62;C4A.70;C4A.71;C4A.72;C4A.8;C4A.9;C50.011;C50.012;C50.019;C50.021;C50.022;C50.029;C50.111;C50.112;C50.119;C50.121;C50.122;C50.129;C50.211;C50.212;C50.219;C50.221;C50.222;C50.229;C50.311;C50.312;C50.319;C50.321;C50.322;C50.329;C50.411;C50.412;C50.419;C50.421;C50.422;C50.429;C50.511;C50.512;C50.519;C50.521;C50.522;C50.529;C50.611;C50.612;C50.619;C50.621;C50.622;C50.629;C50.811;C50.812;C50.819;C50.821;C50.822;C50.829;C50.911;C50.912;C50.919;C50.921;C50.922;C50.929;C51.0;C51.1;C51.2;C51.8;C51.9;C52;C53.0;C53.1;C53.8;C53.9;C54.0;C54.1;C54.2;C54.3;C54.8;C54.9;C55;C56.1;C56.2;C56.9;C57.00;C57.01;C57.02;C57.10;C57.11;C57.12;C57.20;C57.21;C57.22;C57.3;C57.4;C57.7;C57.8;C57.9;C58;C60.0;C60.1;C60.2;C60.8;C60.9;C61;C62.00;C62.01;C62.02;C62.10;C62.11;C62.12;C62.90;C62.91;C62.92;C63.00;C63.01;C63.02;C63.10;C63.11;C63.12;C63.2;C63.7;C63.8;C63.9;C64.1;C64.2;C64.9;C65.1;C65.2;C65.9;C66.1;C66.2;C66.9;C67.0;C67.1;C67.2;C67.3;C67.4;C67.5;C67.6;C67.7;C67.8;C67.9;C68.0;C68.1;C68.8;C68.9;C69.00;C69.01;C69.02;C69.10;C69.11;C69.12;C69.20;C69.21;C69.22;C69.30;C69.31;C69.32;C69.40;C69.41;C69.42;C69.50;C69.51;C69.52;C69.60;C69.61;C69.62;C69.80;C69.81;C69.82;C69.90;C69.91;C69.92;C70.0;C70.1;C70.9;C71.0;C71.1;C71.2;C71.3;C71.4;C71.5;C71.6;C71.7;C71.8;C71.9;C72.0;C72.1;C72.20;C72.21;C72.22;C72.30;C72.31;C72.32;C72.40;C72.41;C72.42;C72.50;C72.59;C72.9;C73;C74.00;C74.01;C74.02;C74.10;C74.11;C74.12;C74.90;C74.91;C74.92;C75.0;C75.1;C75.2;C75.3;C75.4;C75.5;C75.8;C75.9;C76.0;C76.1;C76.2;C76.3;C76.40;C76.41;C76.42;C76.50;C76.51;C76.52;C76.8;C77.0;C77.1;C77.2;C77.3;C77.4;C77.5;C77.8;C77.9;C78.00;C78.01;C78.02;C78.1;C78.2;C78.30;C78.39;C78.4;C78.5;C78.6;C78.7;C78.80;C78.89;C79.00;C79.01;C79.02;C79.10;C79.11;C79.19;C79.2;C79.31;C79.32;C79.40;C79.49;C79.51;C79.52;C79.60;C79.61;C79.62;C79.70;C79.71;C79.72;C79.81;C79.82;C79.89;C79.9;C7A.00;C7A.010;C7A.011;C7A.012;C7A.019;C7A.020;C7A.021;C7A.022;C7A.023;C7A.024;C7A.025;C7A.026;C7A.029;C7A.090;C7A.091;C7A.092;C7A.093;C7A.094;C7A.095;C7A.096;C7A.098;C7A.1;C7A.8;C7B.00;C7B.01;C7B.02;C7B.03;C7B.04;C7B.09;C7B.1;C7B.8;C80.0;C80.1;C80.2;C81.00;C81.01;C81.02;C81.03;C81.04;C81.05;C81.06;C81.07;C81.08;C81.09;C81.10;C81.11;C81.12;C81.13;C81.14;C81.15;C81.16;C81.17;C81.18;C81.19;C81.20;C81.21;C81.22;C81.23;C81.24;C81.25;C81.26;C81.27;C81.28;C81.29;C81.30;C81.31;C81.32;C81.33;C81.34;C81.35;C81.36;C81.37;C81.38;C81.39;C81.40;C81.41;C81.42;C81.43;C81.44;C81.45;C81.46;C81.47;C81.48;C81.49;C81.70;C81.71;C81.72;C81.73;C81.74;C81.75;C81.76;C81.77;C81.78;C81.79;C81.90;C81.91;C81.92;C81.93;C81.94;C81.95;C81.96;C81.97;C81.98;C81.99;C82.00;C82.01;C82.02;C82.03;C82.04;C82.05;C82.06;C82.07;C82.08;C82.09;C82.10;C82.11;C82.12;C82.13;C82.14;C82.15;C82.16;C82.17;C82.18;C82.19;C82.20;C82.21;C82.22;C82.23;C82.24;C82.25;C82.26;C82.27;C82.28;C82.29;C82.30;C82.31;C82.32;C82.33;C82.34;C82.35;C82.36;C82.37;C82.38;C82.39;C82.40;C82.41;C82.42;C82.43;C82.44;C82.45;C82.46;C82.47;C82.48;C82.49;C82.50;C82.51;C82.52;C82.53;C82.54;C82.55;C82.56;C82.57;C82.58;C82.59;C82.60;C82.61;C82.62;C82.63;C82.64;C82.65;C82.66;C82.67;C82.68;C82.69;C82.80;C82.81;C82.82;C82.83;C82.84;C82.85;C82.86;C82.87;C82.88;C82.89;C82.90;C82.91;C82.92;C82.93;C82.94;C82.95;C82.96;C82.97;C82.98;C82.99;C83.00;C83.01;C83.02;C83.03;C83.04;C83.05;C83.06;C83.07;C83.08;C83.09;C83.10;C83.11;C83.12;C83.13;C83.14;C83.15;C83.16;C83.17;C83.18;C83.19;C83.30;C83.31;C83.32;C83.33;C83.34;C83.35;C83.36;C83.37;C83.38;C83.39;C83.50;C83.51;C83.52;C83.53;C83.54;C83.55;C83.56;C83.57;C83.58;C83.59;C83.70;C83.71;C83.72;C83.73;C83.74;C83.75;C83.76;C83.77;C83.78;C83.79;C83.80;C83.81;C83.82;C83.83;C83.84;C83.85;C83.86;C83.87;C83.88;C83.89;C83.90;C83.91;C83.92;C83.93;C83.94;C83.95;C83.96;C83.97;C83.98;C83.99;C84.00;C84.01;C84.02;C84.03;C84.04;C84.05;C84.06;C84.07;C84.08;C84.09;C84.10;C84.11;C84.12;C84.13;C84.14;C84.15;C84.16;C84.17;C84.18;C84.19;C84.40;C84.41;C84.42;C84.43;C84.44;C84.45;C84.46;C84.47;C84.48;C84.49;C84.60;C84.61;C84.62;C84.63;C84.64;C84.65;C84.66;C84.67;C84.68;C84.69;C84.70;C84.71;C84.72;C84.73;C84.74;C84.75;C84.76;C84.77;C84.78;C84.79;C84.90;C84.91;C84.92;C84.93;C84.94;C84.95;C84.96;C84.97;C84.98;C84.99;C84.A0;C84.A1;C84.A2;C84.A3;C84.A4;C84.A5;C84.A6;C84.A7;C84.A8;C84.A9;C84.Z0;C84.Z1;C84.Z2;C84.Z3;C84.Z4;C84.Z5;C84.Z6;C84.Z7;C84.Z8;C84.Z9;C85.10;C85.11;C85.12;C85.13;C85.14;C85.15;C85.16;C85.17;C85.18;C85.19;C85.20;C85.21;C85.22;C85.23;C85.24;C85.25;C85.26;C85.27;C85.28;C85.29;C85.80;C85.81;C85.82;C85.83;C85.84;C85.85;C85.86;C85.87;C85.88;C85.89;C85.90;C85.91;C85.92;C85.93;C85.94;C85.95;C85.96;C85.97;C85.98;C85.99;C86.0;C86.1;C86.2;C86.3;C86.4;C86.5;C86.6;C88.0;C88.2;C88.3;C88.4;C88.8;C88.9;C90.00;C90.01;C90.02;C90.10;C90.11;C90.12;C90.20;C90.21;C90.22;C90.30;C90.31;C90.32;C91.00;C91.01;C91.02;C91.10;C91.11;C91.12;C91.30;C91.31;C91.32;C91.40;C91.41;C91.42;C91.50;C91.51;C91.52;C91.60;C91.61;C91.62;C91.90;C91.91;C91.92;C91.A0;C91.A1;C91.A2;C91.Z0;C91.Z1;C91.Z2;C92.00;C92.01;C92.02;C92.10;C92.11;C92.12;C92.20;C92.21;C92.22;C92.30;C92.31;C92.32;C92.40;C92.41;C92.42;C92.50;C92.51;C92.52;C92.60;C92.61;C92.62;C92.90;C92.91;C92.92;C92.A0;C92.A1;C92.A2;C92.Z0;C92.Z1;C92.Z2;C93.00;C93.01;C93.02;C93.10;C93.11;C93.12;C93.30;C93.31;C93.32;C93.90;C93.91;C93.92;C93.Z0;C93.Z1;C93.Z2;C94.00;C94.01;C94.02;C94.20;C94.21;C94.22;C94.30;C94.31;C94.32;C94.40;C94.41;C94.42;C94.6;C94.80;C94.81;C94.82;C95.00;C95.01;C95.02;C95.10;C95.11;C95.12;C95.90;C95.91;C95.92;C96.0;C96.2;C96.4;C96.5;C96.6;C96.9;C96.A;C96.Z;D00.00;D00.01;D00.02;D00.03;D00.04;D00.05;D00.06;D00.07;D00.08;D00.1;D00.2;D01.0;D01.1;D01.2;D01.3;D01.40;D01.49;D01.5;D01.7;D01.9;D02.0;D02.1;D02.20;D02.21;D02.22;D02.3;D02.4;D03.0;D03.10;D03.11;D03.12;D03.20;D03.21;D03.22;D03.30;D03.39;D03.4;D03.51;D03.52;D03.59;D03.60;D03.61;D03.62;D03.70;D03.71;D03.72;D03.8;D03.9;D04.0;D04.10;D04.11;D04.12;D04.20;D04.21;D04.22;D04.30;D04.39;D04.4;D04.5;D04.60;D04.61;D04.62;D04.70;D04.71;D04.72;D04.8;D04.9;D05.00;D05.01;D05.02;D05.10;D05.11;D05.12;D05.80;D05.81;D05.82;D05.90;D05.91;D05.92;D06.0;D06.1;D06.7;D06.9;D07.0;D07.1;D07.2;D07.30;D07.39;D07.4;D07.5;D07.60;D07.61;D07.69;D09.0;D09.10;D09.19;D09.20;D09.21;D09.22;D09.3;D09.8;D09.9;D18.02;D18.1;D32.0;D32.1;D32.9;D33.0;D33.1;D33.2;D33.3;D33.4;D33.7;D33.9;D35.2;D35.3;D35.4;D42.0;D42.1;D42.9;D43.0;D43.1;D43.2;D43.3;D43.4;D43.8;D43.9;D44.3;D44.4;D44.5;D45;D46.0;D46.1;D46.20;D46.21;D46.22;D46.4;D46.9;D46.A;D46.B;D46.C;D46.Z;D47.1;D47.3;D47.9;D47.Z1;D47.Z9;D49.6;D49.7;D75.0;D76.1;D76.2;D76.3;E71.39;E80.3;E88.89;140.0;140.1;140.3;140.4;140.5;140.6;140.8;140.9;141.1;141.2;141.3;141.4;141.5;141.6;141.8;141.9;142.0;142.1;142.2;142.8;142.9;143.0;143.1;143.8;143.9;144.0;144.1;144.8;144.9;145.0;145.1;145.2;145.3;145.4;145.5;145.6;145.8;145.9;146.0;146.1;146.2;146.3;146.4;146.5;146.6;146.7;146.8;146.9;147.0;147.1;147.2;147.3;147.8;147.9;148.0;148.1;148.2;148.3;148.8;148.9;149.0;149.1;149.8;149.9;150.0;150.1;150.2;150.3;150.4;150.5;150.8;150.9;151.0;151.1;151.2;151.3;151.4;151.5;151.6;151.8;151.9;152.0;152.1;152.2;152.3;152.8;152.9;153.0;153.1;153.2;153.3;153.4;153.5;153.6;153.7;153.8;153.9;154.0;154.1;154.2;154.3;154.8;155.0;155.1;155.2;156.0;156.1;156.2;156.8;156.9;157.0;157.1;157.2;157.3;157.4;157.8;157.9;158.0;158.8;158.9;159.0;159.1;159.8;159.9;160.0;160.1;160.2;160.3;160.4;160.5;160.8;160.9;161.0;161.1;161.2;161.3;161.8;161.9;162.0;162.2;162.3;162.4;162.5;162.8;162.9;163.1;163.8;163.9;164.0;164.1;164.2;164.3;164.8;164.9;165.0;165.8;165.9;170.0;170.1;170.2;170.3;170.4;170.5;170.6;170.7;170.8;170.9;171.0;171.2;171.3;171.4;171.5;171.6;171.7;171.8;171.9;172.0;172.1;172.2;172.3;172.4;172.5;172.6;172.7;172.8;172.9;173.09;173.19;173.29;173.39;173.49;173.59;173.69;173.79;173.89;173.99;174.0;174.1;174.2;174.3;174.4;174.5;174.6;174.8;174.9;175.0;175.9;176.0;176.1;176.2;176.3;176.4;176.5;176.8;176.9;180.0;180.1;180.8;180.9;182.0;182.1;182.8;183.0;183.2;183.3;183.4;183.5;183.8;183.9;184.0;184.1;184.2;184.3;184.4;184.8;184.9;185;186.0;186.9;187.1;187.2;187.3;187.4;187.5;187.6;187.7;187.8;187.9;188.0;188.1;188.2;188.3;188.4;188.5;188.6;188.7;188.8;188.9;189.0;189.1;189.2;189.3;189.4;189.8;189.9;190.0;190.1;190.2;190.3;190.4;190.5;190.6;190.7;190.8;190.9;191.0;191.1;191.2;191.3;191.4;191.5;191.6;191.7;191.8;191.9;192.0;192.1;192.2;192.3;192.8;192.9;193;194.0;194.1;194.3;194.4;194.5;194.6;194.8;194.9;195.0;195.1;195.2;195.3;195.4;195.5;195.8;196.0;196.1;196.2;196.3;196.5;196.6;196.8;196.9;197.0;197.1;197.2;197.3;197.4;197.5;197.6;197.7;197.8;198.0;198.1;198.2;198.3;198.4;198.5;198.6;198.7;198.81;198.82;198.89;199.0;199.1;199.2;200.00;200.01;200.02;200.03;200.04;200.05;200.06;200.07;200.08;200.10;200.11;200.12;200.13;200.14;200.15;200.16;200.17;200.18;200.20;200.21;200.22;200.23;200.24;200.25;200.26;200.27;200.28;200.30;200.31;200.32;200.33;200.34;200.35;200.36;200.37;200.38;200.40;200.41;200.42;200.43;200.44;200.45;200.46;200.47;200.48;200.50;200.51;200.52;200.53;200.54;200.55;200.56;200.57;200.58;200.60;200.61;200.62;200.63;200.64;200.65;200.66;200.67;200.68;200.70;200.71;200.72;200.73;200.74;200.75;200.76;200.77;200.78;200.80;200.81;200.82;200.83;200.84;200.85;200.86;200.87;200.88;201.00;201.01;201.02;201.03;201.04;201.05;201.06;201.07;201.08;201.10;201.11;201.12;201.13;201.14;201.15;201.16;201.17;201.18;201.20;201.21;201.22;201.23;201.24;201.25;201.26;201.27;201.28;201.40;201.41;201.42;201.43;201.44;201.45;201.46;201.47;201.48;201.50;201.51;201.52;201.53;201.54;201.55;201.56;201.57;201.58;201.60;201.61;201.62;201.63;201.64;201.65;201.66;201.67;201.68;201.70;201.71;201.72;201.73;201.74;201.75;201.76;201.77;201.78;201.90;201.91;201.92;201.93;201.94;201.95;201.96;201.97;201.98;202.00;202.01;202.02;202.03;202.04;202.05;202.06;202.07;202.08;202.10;202.11;202.12;202.13;202.14;202.15;202.16;202.17;202.18;202.20;202.21;202.22;202.23;202.24;202.25;202.26;202.27;202.28;202.30;202.31;202.32;202.33;202.34;202.35;202.36;202.37;202.38;202.40;202.41;202.42;202.43;202.44;202.45;202.46;202.47;202.48;202.50;202.51;202.52;202.53;202.54;202.55;202.56;202.57;202.58;202.60;202.61;202.62;202.63;202.64;202.65;202.66;202.67;202.68;202.70;202.71;202.72;202.73;202.74;202.75;202.76;202.77;202.78;202.80;202.81;202.82;202.83;202.84;202.85;202.86;202.87;202.88;202.90;202.91;202.92;202.93;202.94;202.95;202.96;202.97;202.98;203.00;203.01;203.02;203.10;203.11;203.12;203.80;203.81;203.82;204.00;204.01;204.02;204.10;204.11;204.12;204.20;204.21;204.22;204.80;204.81;204.82;204.90;204.91;204.92;205.00;205.01;205.02;205.10;205.11;205.12;205.20;205.21;205.22;205.30;205.31;205.32;205.80;205.81;205.82;205.90;205.91;205.92;206.00;206.01;206.02;206.10;206.11;206.12;206.20;206.21;206.22;206.81;206.82;206.91;206.92;207.00;207.01;207.02;207.11;207.12;207.21;207.22;207.81;207.82;208.00;208.01;208.02;208.11;208.12;208.21;208.22;208.81;208.82;208.91;208.92;209.00;209.01;209.02;209.03;209.10;209.11;209.12;209.13;209.14;209.15;209.16;209.17;209.20;209.21;209.22;209.23;209.24;209.25;209.26;209.27;209.29;209.30;209.31;209.32;209.33;209.34;209.35;209.36;209.70;209.71;209.72;209.73;209.74;209.75;209.79;225.0;225.1;225.2;225.3;225.4;225.8;225.9;227.3;227.4;228.02;230.0;230.1;230.2;230.3;230.4;230.5;230.6;230.7;230.8;230.9;231.0;231.1;231.2;231.8;231.9;232.0;232.1;233.0;233.1;233.2;233.31;233.32;233.39;233.4;233.5;233.6;233.7;233.9;234.0;234.8;234.9;236.1;237.0;237.1;237.5;237.6;237.72;237.9;238.4;238.6;238.71;238.72;238.73;238.74;238.75;238.76;238.77;238.79;239.6;239.7;273.2;273.3;288.4;289.6;511.81;789.51;V58.11;V58.12;</SearchAttribute>      <SearchAttribute field="Term" />      <SearchAttribute field="UseSpecifiedCodes">0</SearchAttribute>      <SearchAttribute field="SpecifiedCodes" />      <SearchAttribute field="DiagnosisSearchDefinitionUid">EA0AFCD5-2475-4623-80D9-4B586742BD93</SearchAttribute>      <SearchAttribute field="DiagnosisSearchDefinitionName">DiagnosisSearchDefinitionUid</SearchAttribute>    </SearchDefinition>  </root>',
0, '2019-03-04 20:47:44.777' )
END

update ListDiagnosisSearchDefinition
set Definition = '<root>
  <SearchDefinition name="Cancer Registry">
    <SearchAttribute field="IcdRange">C00.0;C00.1;C00.2;C00.3;C00.4;C00.5;C00.6;C00.8;C00.9;C01;C02.0;C02.1;C02.2;C02.3;C02.4;C02.8;C02.9;C03.0;C03.1;C03.9;C04.0;C04.1;C04.8;C04.9;C05.0;C05.1;C05.2;C05.8;C05.9;C06.0;C06.1;C06.2;C06.80;C06.89;C06.9;C07;C08.0;C08.1;C08.9;C09.0;C09.1;C09.8;C09.9;C10.0;C10.1;C10.2;C10.3;C10.4;C10.8;C10.9;C11.0;C11.1;C11.2;C11.3;C11.8;C11.9;C12;C13.0;C13.1;C13.2;C13.8;C13.9;C14.0;C14.2;C14.8;C15.3;C15.4;C15.5;C15.8;C15.9;C16.0;C16.1;C16.2;C16.3;C16.4;C16.5;C16.6;C16.8;C16.9;C17.0;C17.1;C17.2;C17.3;C17.8;C17.9;C18.0;C18.1;C18.2;C18.3;C18.4;C18.5;C18.6;C18.7;C18.8;C18.9;C19;C20;C21.0;C21.1;C21.2;C21.8;C22.0;C22.1;C22.2;C22.3;C22.4;C22.7;C22.8;C22.9;C23;C24.0;C24.1;C24.8;C24.9;C25.0;C25.1;C25.2;C25.3;C25.4;C25.7;C25.8;C25.9;C26.0;C26.1;C26.9;C30.0;C30.1;C31.0;C31.1;C31.2;C31.3;C31.8;C31.9;C32.0;C32.1;C32.2;C32.3;C32.8;C32.9;C33;C34.00;C34.01;C34.02;C34.10;C34.11;C34.12;C34.2;C34.30;C34.31;C34.32;C34.80;C34.81;C34.82;C34.90;C34.91;C34.92;C37;C38.0;C38.1;C38.2;C38.3;C38.4;C38.8;C39.0;C39.9;C40.00;C40.01;C40.02;C40.10;C40.11;C40.12;C40.20;C40.21;C40.22;C40.30;C40.31;C40.32;C40.80;C40.81;C40.82;C40.90;C40.91;C40.92;C41.0;C41.1;C41.2;C41.3;C41.4;C41.9;C43.0;C43.10;C43.11;C43.12;C43.20;C43.21;C43.22;C43.30;C43.31;C43.39;C43.4;C43.51;C43.52;C43.59;C43.60;C43.61;C43.62;C43.70;C43.71;C43.72;C43.8;C43.9;C44.00;C44.09;C44.101;C44.102;C44.109;C44.191;C44.192;C44.199;C44.201;C44.202;C44.209;C44.291;C44.292;C44.299;C44.300;C44.301;C44.309;C44.390;C44.391;C44.399;C44.40;C44.49;C44.500;C44.501;C44.509;C44.590;C44.591;C44.599;C44.601;C44.602;C44.609;C44.691;C44.692;C44.699;C44.701;C44.702;C44.709;C44.791;C44.792;C44.799;C44.80;C44.89;C44.90;C44.99;C45.0;C45.1;C45.2;C45.7;C45.9;C46.0;C46.1;C46.2;C46.3;C46.4;C46.50;C46.51;C46.52;C46.7;C46.9;C47.0;C47.10;C47.11;C47.12;C47.20;C47.21;C47.22;C47.3;C47.4;C47.5;C47.6;C47.8;C47.9;C48.0;C48.1;C48.2;C48.8;C49.0;C49.10;C49.11;C49.12;C49.20;C49.21;C49.22;C49.3;C49.4;C49.5;C49.6;C49.8;C49.9;C4A.0;C4A.10;C4A.11;C4A.12;C4A.20;C4A.21;C4A.22;C4A.30;C4A.31;C4A.39;C4A.4;C4A.51;C4A.52;C4A.59;C4A.60;C4A.61;C4A.62;C4A.70;C4A.71;C4A.72;C4A.8;C4A.9;C50.011;C50.012;C50.019;C50.021;C50.022;C50.029;C50.111;C50.112;C50.119;C50.121;C50.122;C50.129;C50.211;C50.212;C50.219;C50.221;C50.222;C50.229;C50.311;C50.312;C50.319;C50.321;C50.322;C50.329;C50.411;C50.412;C50.419;C50.421;C50.422;C50.429;C50.511;C50.512;C50.519;C50.521;C50.522;C50.529;C50.611;C50.612;C50.619;C50.621;C50.622;C50.629;C50.811;C50.812;C50.819;C50.821;C50.822;C50.829;C50.911;C50.912;C50.919;C50.921;C50.922;C50.929;C51.0;C51.1;C51.2;C51.8;C51.9;C52;C53.0;C53.1;C53.8;C53.9;C54.0;C54.1;C54.2;C54.3;C54.8;C54.9;C55;C56.1;C56.2;C56.9;C57.00;C57.01;C57.02;C57.10;C57.11;C57.12;C57.20;C57.21;C57.22;C57.3;C57.4;C57.7;C57.8;C57.9;C58;C60.0;C60.1;C60.2;C60.8;C60.9;C61;C62.00;C62.01;C62.02;C62.10;C62.11;C62.12;C62.90;C62.91;C62.92;C63.00;C63.01;C63.02;C63.10;C63.11;C63.12;C63.2;C63.7;C63.8;C63.9;C64.1;C64.2;C64.9;C65.1;C65.2;C65.9;C66.1;C66.2;C66.9;C67.0;C67.1;C67.2;C67.3;C67.4;C67.5;C67.6;C67.7;C67.8;C67.9;C68.0;C68.1;C68.8;C68.9;C69.00;C69.01;C69.02;C69.10;C69.11;C69.12;C69.20;C69.21;C69.22;C69.30;C69.31;C69.32;C69.40;C69.41;C69.42;C69.50;C69.51;C69.52;C69.60;C69.61;C69.62;C69.80;C69.81;C69.82;C69.90;C69.91;C69.92;C70.0;C70.1;C70.9;C71.0;C71.1;C71.2;C71.3;C71.4;C71.5;C71.6;C71.7;C71.8;C71.9;C72.0;C72.1;C72.20;C72.21;C72.22;C72.30;C72.31;C72.32;C72.40;C72.41;C72.42;C72.50;C72.59;C72.9;C73;C74.00;C74.01;C74.02;C74.10;C74.11;C74.12;C74.90;C74.91;C74.92;C75.0;C75.1;C75.2;C75.3;C75.4;C75.5;C75.8;C75.9;C76.0;C76.1;C76.2;C76.3;C76.40;C76.41;C76.42;C76.50;C76.51;C76.52;C76.8;C77.0;C77.1;C77.2;C77.3;C77.4;C77.5;C77.8;C77.9;C78.00;C78.01;C78.02;C78.1;C78.2;C78.30;C78.39;C78.4;C78.5;C78.6;C78.7;C78.80;C78.89;C79.00;C79.01;C79.02;C79.10;C79.11;C79.19;C79.2;C79.31;C79.32;C79.40;C79.49;C79.51;C79.52;C79.60;C79.61;C79.62;C79.70;C79.71;C79.72;C79.81;C79.82;C79.89;C79.9;C7A.00;C7A.010;C7A.011;C7A.012;C7A.019;C7A.020;C7A.021;C7A.022;C7A.023;C7A.024;C7A.025;C7A.026;C7A.029;C7A.090;C7A.091;C7A.092;C7A.093;C7A.094;C7A.095;C7A.096;C7A.098;C7A.1;C7A.8;C7B.00;C7B.01;C7B.02;C7B.03;C7B.04;C7B.09;C7B.1;C7B.8;C80.0;C80.1;C80.2;C81.00;C81.01;C81.02;C81.03;C81.04;C81.05;C81.06;C81.07;C81.08;C81.09;C81.10;C81.11;C81.12;C81.13;C81.14;C81.15;C81.16;C81.17;C81.18;C81.19;C81.20;C81.21;C81.22;C81.23;C81.24;C81.25;C81.26;C81.27;C81.28;C81.29;C81.30;C81.31;C81.32;C81.33;C81.34;C81.35;C81.36;C81.37;C81.38;C81.39;C81.40;C81.41;C81.42;C81.43;C81.44;C81.45;C81.46;C81.47;C81.48;C81.49;C81.70;C81.71;C81.72;C81.73;C81.74;C81.75;C81.76;C81.77;C81.78;C81.79;C81.90;C81.91;C81.92;C81.93;C81.94;C81.95;C81.96;C81.97;C81.98;C81.99;C82.00;C82.01;C82.02;C82.03;C82.04;C82.05;C82.06;C82.07;C82.08;C82.09;C82.10;C82.11;C82.12;C82.13;C82.14;C82.15;C82.16;C82.17;C82.18;C82.19;C82.20;C82.21;C82.22;C82.23;C82.24;C82.25;C82.26;C82.27;C82.28;C82.29;C82.30;C82.31;C82.32;C82.33;C82.34;C82.35;C82.36;C82.37;C82.38;C82.39;C82.40;C82.41;C82.42;C82.43;C82.44;C82.45;C82.46;C82.47;C82.48;C82.49;C82.50;C82.51;C82.52;C82.53;C82.54;C82.55;C82.56;C82.57;C82.58;C82.59;C82.60;C82.61;C82.62;C82.63;C82.64;C82.65;C82.66;C82.67;C82.68;C82.69;C82.80;C82.81;C82.82;C82.83;C82.84;C82.85;C82.86;C82.87;C82.88;C82.89;C82.90;C82.91;C82.92;C82.93;C82.94;C82.95;C82.96;C82.97;C82.98;C82.99;C83.00;C83.01;C83.02;C83.03;C83.04;C83.05;C83.06;C83.07;C83.08;C83.09;C83.10;C83.11;C83.12;C83.13;C83.14;C83.15;C83.16;C83.17;C83.18;C83.19;C83.30;C83.31;C83.32;C83.33;C83.34;C83.35;C83.36;C83.37;C83.38;C83.39;C83.50;C83.51;C83.52;C83.53;C83.54;C83.55;C83.56;C83.57;C83.58;C83.59;C83.70;C83.71;C83.72;C83.73;C83.74;C83.75;C83.76;C83.77;C83.78;C83.79;C83.80;C83.81;C83.82;C83.83;C83.84;C83.85;C83.86;C83.87;C83.88;C83.89;C83.90;C83.91;C83.92;C83.93;C83.94;C83.95;C83.96;C83.97;C83.98;C83.99;C84.00;C84.01;C84.02;C84.03;C84.04;C84.05;C84.06;C84.07;C84.08;C84.09;C84.10;C84.11;C84.12;C84.13;C84.14;C84.15;C84.16;C84.17;C84.18;C84.19;C84.40;C84.41;C84.42;C84.43;C84.44;C84.45;C84.46;C84.47;C84.48;C84.49;C84.60;C84.61;C84.62;C84.63;C84.64;C84.65;C84.66;C84.67;C84.68;C84.69;C84.70;C84.71;C84.72;C84.73;C84.74;C84.75;C84.76;C84.77;C84.78;C84.79;C84.90;C84.91;C84.92;C84.93;C84.94;C84.95;C84.96;C84.97;C84.98;C84.99;C84.A0;C84.A1;C84.A2;C84.A3;C84.A4;C84.A5;C84.A6;C84.A7;C84.A8;C84.A9;C84.Z0;C84.Z1;C84.Z2;C84.Z3;C84.Z4;C84.Z5;C84.Z6;C84.Z7;C84.Z8;C84.Z9;C85.10;C85.11;C85.12;C85.13;C85.14;C85.15;C85.16;C85.17;C85.18;C85.19;C85.20;C85.21;C85.22;C85.23;C85.24;C85.25;C85.26;C85.27;C85.28;C85.29;C85.80;C85.81;C85.82;C85.83;C85.84;C85.85;C85.86;C85.87;C85.88;C85.89;C85.90;C85.91;C85.92;C85.93;C85.94;C85.95;C85.96;C85.97;C85.98;C85.99;C86.0;C86.1;C86.2;C86.3;C86.4;C86.5;C86.6;C88.0;C88.2;C88.3;C88.4;C88.8;C88.9;C90.00;C90.01;C90.02;C90.10;C90.11;C90.12;C90.20;C90.21;C90.22;C90.30;C90.31;C90.32;C91.00;C91.01;C91.02;C91.10;C91.11;C91.12;C91.30;C91.31;C91.32;C91.40;C91.41;C91.42;C91.50;C91.51;C91.52;C91.60;C91.61;C91.62;C91.90;C91.91;C91.92;C91.A0;C91.A1;C91.A2;C91.Z0;C91.Z1;C91.Z2;C92.00;C92.01;C92.02;C92.10;C92.11;C92.12;C92.20;C92.21;C92.22;C92.30;C92.31;C92.32;C92.40;C92.41;C92.42;C92.50;C92.51;C92.52;C92.60;C92.61;C92.62;C92.90;C92.91;C92.92;C92.A0;C92.A1;C92.A2;C92.Z0;C92.Z1;C92.Z2;C93.00;C93.01;C93.02;C93.10;C93.11;C93.12;C93.30;C93.31;C93.32;C93.90;C93.91;C93.92;C93.Z0;C93.Z1;C93.Z2;C94.00;C94.01;C94.02;C94.20;C94.21;C94.22;C94.30;C94.31;C94.32;C94.40;C94.41;C94.42;C94.6;C94.80;C94.81;C94.82;C95.00;C95.01;C95.02;C95.10;C95.11;C95.12;C95.90;C95.91;C95.92;C96.0;C96.2;C96.4;C96.5;C96.6;C96.9;C96.A;C96.Z;D00.00;D00.01;D00.02;D00.03;D00.04;D00.05;D00.06;D00.07;D00.08;D00.1;D00.2;D01.0;D01.1;D01.2;D01.3;D01.40;D01.49;D01.5;D01.7;D01.9;D02.0;D02.1;D02.20;D02.21;D02.22;D02.3;D02.4;D03.0;D03.10;D03.11;D03.12;D03.20;D03.21;D03.22;D03.30;D03.39;D03.4;D03.51;D03.52;D03.59;D03.60;D03.61;D03.62;D03.70;D03.71;D03.72;D03.8;D03.9;D04.0;D04.10;D04.11;D04.12;D04.20;D04.21;D04.22;D04.30;D04.39;D04.4;D04.5;D04.60;D04.61;D04.62;D04.70;D04.71;D04.72;D04.8;D04.9;D05.00;D05.01;D05.02;D05.10;D05.11;D05.12;D05.80;D05.81;D05.82;D05.90;D05.91;D05.92;D06.0;D06.1;D06.7;D06.9;D07.0;D07.1;D07.2;D07.30;D07.39;D07.4;D07.5;D07.60;D07.61;D07.69;D09.0;D09.10;D09.19;D09.20;D09.21;D09.22;D09.3;D09.8;D09.9;D18.02;D18.1;D32.0;D32.1;D32.9;D33.0;D33.1;D33.2;D33.3;D33.4;D33.7;D33.9;D35.2;D35.3;D35.4;D42.0;D42.1;D42.9;D43.0;D43.1;D43.2;D43.3;D43.4;D43.8;D43.9;D44.3;D44.4;D44.5;D45;D46.0;D46.1;D46.20;D46.21;D46.22;D46.4;D46.9;D46.A;D46.B;D46.C;D46.Z;D47.1;D47.3;D47.9;D47.Z1;D47.Z9;D49.6;D49.7;D75.0;D76.1;D76.2;D76.3;E71.39;E80.3;E88.89;140.0;140.1;140.3;140.4;140.5;140.6;140.8;140.9;141.1;141.2;141.3;141.4;141.5;141.6;141.8;141.9;142.0;142.1;142.2;142.8;142.9;143.0;143.1;143.8;143.9;144.0;144.1;144.8;144.9;145.0;145.1;145.2;145.3;145.4;145.5;145.6;145.8;145.9;146.0;146.1;146.2;146.3;146.4;146.5;146.6;146.7;146.8;146.9;147.0;147.1;147.2;147.3;147.8;147.9;148.0;148.1;148.2;148.3;148.8;148.9;149.0;149.1;149.8;149.9;150.0;150.1;150.2;150.3;150.4;150.5;150.8;150.9;151.0;151.1;151.2;151.3;151.4;151.5;151.6;151.8;151.9;152.0;152.1;152.2;152.3;152.8;152.9;153.0;153.1;153.2;153.3;153.4;153.5;153.6;153.7;153.8;153.9;154.0;154.1;154.2;154.3;154.8;155.0;155.1;155.2;156.0;156.1;156.2;156.8;156.9;157.0;157.1;157.2;157.3;157.4;157.8;157.9;158.0;158.8;158.9;159.0;159.1;159.8;159.9;160.0;160.1;160.2;160.3;160.4;160.5;160.8;160.9;161.0;161.1;161.2;161.3;161.8;161.9;162.0;162.2;162.3;162.4;162.5;162.8;162.9;163.1;163.8;163.9;164.0;164.1;164.2;164.3;164.8;164.9;165.0;165.8;165.9;170.0;170.1;170.2;170.3;170.4;170.5;170.6;170.7;170.8;170.9;171.0;171.2;171.3;171.4;171.5;171.6;171.7;171.8;171.9;172.0;172.1;172.2;172.3;172.4;172.5;172.6;172.7;172.8;172.9;173.09;173.19;173.29;173.39;173.49;173.59;173.69;173.79;173.89;173.99;174.0;174.1;174.2;174.3;174.4;174.5;174.6;174.8;174.9;175.0;175.9;176.0;176.1;176.2;176.3;176.4;176.5;176.8;176.9;180.0;180.1;180.8;180.9;182.0;182.1;182.8;183.0;183.2;183.3;183.4;183.5;183.8;183.9;184.0;184.1;184.2;184.3;184.4;184.8;184.9;185;186.0;186.9;187.1;187.2;187.3;187.4;187.5;187.6;187.7;187.8;187.9;188.0;188.1;188.2;188.3;188.4;188.5;188.6;188.7;188.8;188.9;189.0;189.1;189.2;189.3;189.4;189.8;189.9;190.0;190.1;190.2;190.3;190.4;190.5;190.6;190.7;190.8;190.9;191.0;191.1;191.2;191.3;191.4;191.5;191.6;191.7;191.8;191.9;192.0;192.1;192.2;192.3;192.8;192.9;193;194.0;194.1;194.3;194.4;194.5;194.6;194.8;194.9;195.0;195.1;195.2;195.3;195.4;195.5;195.8;196.0;196.1;196.2;196.3;196.5;196.6;196.8;196.9;197.0;197.1;197.2;197.3;197.4;197.5;197.6;197.7;197.8;198.0;198.1;198.2;198.3;198.4;198.5;198.6;198.7;198.81;198.82;198.89;199.0;199.1;199.2;200.00;200.01;200.02;200.03;200.04;200.05;200.06;200.07;200.08;200.10;200.11;200.12;200.13;200.14;200.15;200.16;200.17;200.18;200.20;200.21;200.22;200.23;200.24;200.25;200.26;200.27;200.28;200.30;200.31;200.32;200.33;200.34;200.35;200.36;200.37;200.38;200.40;200.41;200.42;200.43;200.44;200.45;200.46;200.47;200.48;200.50;200.51;200.52;200.53;200.54;200.55;200.56;200.57;200.58;200.60;200.61;200.62;200.63;200.64;200.65;200.66;200.67;200.68;200.70;200.71;200.72;200.73;200.74;200.75;200.76;200.77;200.78;200.80;200.81;200.82;200.83;200.84;200.85;200.86;200.87;200.88;201.00;201.01;201.02;201.03;201.04;201.05;201.06;201.07;201.08;201.10;201.11;201.12;201.13;201.14;201.15;201.16;201.17;201.18;201.20;201.21;201.22;201.23;201.24;201.25;201.26;201.27;201.28;201.40;201.41;201.42;201.43;201.44;201.45;201.46;201.47;201.48;201.50;201.51;201.52;201.53;201.54;201.55;201.56;201.57;201.58;201.60;201.61;201.62;201.63;201.64;201.65;201.66;201.67;201.68;201.70;201.71;201.72;201.73;201.74;201.75;201.76;201.77;201.78;201.90;201.91;201.92;201.93;201.94;201.95;201.96;201.97;201.98;202.00;202.01;202.02;202.03;202.04;202.05;202.06;202.07;202.08;202.10;202.11;202.12;202.13;202.14;202.15;202.16;202.17;202.18;202.20;202.21;202.22;202.23;202.24;202.25;202.26;202.27;202.28;202.30;202.31;202.32;202.33;202.34;202.35;202.36;202.37;202.38;202.40;202.41;202.42;202.43;202.44;202.45;202.46;202.47;202.48;202.50;202.51;202.52;202.53;202.54;202.55;202.56;202.57;202.58;202.60;202.61;202.62;202.63;202.64;202.65;202.66;202.67;202.68;202.70;202.71;202.72;202.73;202.74;202.75;202.76;202.77;202.78;202.80;202.81;202.82;202.83;202.84;202.85;202.86;202.87;202.88;202.90;202.91;202.92;202.93;202.94;202.95;202.96;202.97;202.98;203.00;203.01;203.02;203.10;203.11;203.12;203.80;203.81;203.82;204.00;204.01;204.02;204.10;204.11;204.12;204.20;204.21;204.22;204.80;204.81;204.82;204.90;204.91;204.92;205.00;205.01;205.02;205.10;205.11;205.12;205.20;205.21;205.22;205.30;205.31;205.32;205.80;205.81;205.82;205.90;205.91;205.92;206.00;206.01;206.02;206.10;206.11;206.12;206.20;206.21;206.22;206.81;206.82;206.91;206.92;207.00;207.01;207.02;207.11;207.12;207.21;207.22;207.81;207.82;208.00;208.01;208.02;208.11;208.12;208.21;208.22;208.81;208.82;208.91;208.92;209.00;209.01;209.02;209.03;209.10;209.11;209.12;209.13;209.14;209.15;209.16;209.17;209.20;209.21;209.22;209.23;209.24;209.25;209.26;209.27;209.29;209.30;209.31;209.32;209.33;209.34;209.35;209.36;209.70;209.71;209.72;209.73;209.74;209.75;209.79;225.0;225.1;225.2;225.3;225.4;225.8;225.9;227.3;227.4;228.02;230.0;230.1;230.2;230.3;230.4;230.5;230.6;230.7;230.8;230.9;231.0;231.1;231.2;231.8;231.9;232.0;232.1;233.0;233.1;233.2;233.31;233.32;233.39;233.4;233.5;233.6;233.7;233.9;234.0;234.8;234.9;236.1;237.0;237.1;237.5;237.6;237.72;237.9;238.4;238.6;238.71;238.72;238.73;238.74;238.75;238.76;238.77;238.79;239.6;239.7;273.2;273.3;288.4;289.6;511.81;789.51;V58.11;V58.12;</SearchAttribute>
    <SearchAttribute field="Term" />
    <SearchAttribute field="UseSpecifiedCodes">0</SearchAttribute>
    <SearchAttribute field="SpecifiedCodes" />
    <SearchAttribute field="DiagnosisSearchDefinitionUid">EA0AFCD5-2475-4623-80D9-4B586742BD93</SearchAttribute>
    <SearchAttribute field="DiagnosisSearchDefinitionName">DiagnosisSearchDefinitionUid</SearchAttribute>
  </SearchDefinition>
</root>'
where DiagnosisSearchDefinitionUid = 'EA0AFCD5-2475-4623-80D9-4B586742BD93'
GO

-- #26728 _Migration.sql
delete from RelPatientStatus
where RelPatientStatusUid in 
(
 Select RelPatientStatusUid from (
 select distinct FullName, PersonUid, relpatientstatusuid, RPS.PatientStatusUid, 
ROW_NUMBER()  over (partition by personuid, RPS.patientstatusuid order by fullname) as numrows 
 from viewperson VP 
LEFT JOIN RelPatientStatus RPS WITH (NOLOCK) ON RPS.PatientUid = vp.PersonUid
LEFT JOIN ListPatientStatus LPS WITH (NOLOCK) ON LPS.PatientStatusUid = RPS.PatientStatusUid
where RPS.PatientStatusUid is not NULL
) nm where nm.numrows > 1
);
GO

--  #26042 migration
-- TFS Number  : 26042 
-- Date        : 2019.Oct.17
-- 
IF EXISTS (SELECT * FROM ListMessageType WHERE MessageTypeUid = 'A2B88BC2-E7C8-4990-92F6-AE28B5C0DC77')
BEGIN
  update ListMessageType 
    set Inactive = 1
    where MessageTypeUid = 'A2B88BC2-E7C8-4990-92F6-AE28B5C0DC77'
END 
GO