-- #16174  move AR Active Write off report
update ListReport	
set reportfolderuid='207021F9-B5C5-4490-8C91-BF5921AE792D' --PM Accounts Receivable Reports
where reportuid='3C1F9E0E-F89C-4865-826F-36AC1BB572C0' --AR Active Write Off
GO

-- #20588 linked to 20774 UPDATE Total AR Aging Writeoff Complete.sql
--  kculberth 20190515 bug 20588 A/R Active Write Off report needs addition filter for last patient payment older than xx days.
--  kculberth 20190521 bug 20744 AR Active Write Off Report- Add Collection Status as Filter and add column to report for RP collection status
--          change Patient to ResponsibleParty
--ListUserDefinedControlGroup
IF NOT EXISTS (
		SELECT [UserDefinedControlGroupUid]
		FROM ListUserDefinedControlGroup
		WHERE [UserDefinedControlGroupUid] = '0e80f495-b34f-4118-a1e1-c50237e7b65e'
		)
BEGIN
	INSERT ListUserDefinedControlGroup (
		[UserDefinedControlGroupUid]
		,[Name]
		,[Immunization]
		,[Inactive]
		,[UserDefined]
		,[RDLDesigner]
		,[LastModifiedDate]
		)
	VALUES (
		'0e80f495-b34f-4118-a1e1-c50237e7b65e'
		,'AR Active Write Off'
		,0
		,0
		,0
		,0
		,'5/21/2019 00:00:00 AM'
		)
END

--ListUserDefinedControl
--SortOrder = 0
IF NOT EXISTS (
		SELECT [UserDefinedControlUid]
		FROM ListUserDefinedControl
		WHERE [UserDefinedControlUid] = 'e47a209b-1e99-4c58-84d3-bc425ece5b27'
		)
BEGIN
	INSERT ListUserDefinedControl (
		[UserDefinedControlUid]
		,[Name]
		,[Inactive]
		,[Label]
		,[ControlTypeUid]
		,[ControlProperties]
		,[UserDefinedControlGroupUid]
		,[SortOrder]
		,[UserDefined]
		,[RDLDesigner]
		,[LastModifiedDate]
		)
	VALUES (
		'e47a209b-1e99-4c58-84d3-bc425ece5b27'
		,'ReportOption'
		,0
		,'Report Option'
		,'8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
		,'<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ReportOption</Name><ButtonLabel>Responsible Party (RP)</ButtonLabel><ButtonValue>ResponsibleParty</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ReportOption</Name><ButtonLabel>Insurance</ButtonLabel><ButtonValue>Insurance</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
		,'0e80f495-b34f-4118-a1e1-c50237e7b65e'
		,0
		,0
		,0
		,'5/21/2019 00:00:00 AM'
		)
END

--SortOrder = 1
IF NOT EXISTS (
		SELECT [UserDefinedControlUid]
		FROM ListUserDefinedControl
		WHERE [UserDefinedControlUid] = '3f42d421-5632-45dc-a9bf-384608f1c359'
		)
BEGIN
	INSERT ListUserDefinedControl (
		[UserDefinedControlUid]
		,[Name]
		,[Inactive]
		,[Label]
		,[ControlTypeUid]
		,[ControlProperties]
		,[UserDefinedControlGroupUid]
		,[SortOrder]
		,[UserDefined]
		,[RDLDesigner]
		,[LastModifiedDate]
		)
	VALUES (
		'3f42d421-5632-45dc-a9bf-384608f1c359'
		,'ProviderUid'
		,0
		,'Providers'
		,'8a957d7c-8b86-4a67-8336-b830c30fd123'
		,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProviderUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Provider</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewProvider</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
		,'0e80f495-b34f-4118-a1e1-c50237e7b65e'
		,1
		,0
		,0
		,'5/21/2019 00:00:00 AM'
		)
END

--SortOrder = 2
IF NOT EXISTS (
		SELECT [UserDefinedControlUid]
		FROM ListUserDefinedControl
		WHERE [UserDefinedControlUid] = 'c04aafea-d8ce-4529-aab9-5fe3403f80a2'
		)
BEGIN
	INSERT ListUserDefinedControl (
		[UserDefinedControlUid]
		,[Name]
		,[Inactive]
		,[Label]
		,[ControlTypeUid]
		,[ControlProperties]
		,[UserDefinedControlGroupUid]
		,[SortOrder]
		,[UserDefined]
		,[RDLDesigner]
		,[LastModifiedDate]
		)
	VALUES (
		'c04aafea-d8ce-4529-aab9-5fe3403f80a2'
		,'ProviderOption'
		,0
		,'Provider Option'
		,'8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
		,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Billing Provider</ButtonLabel><ButtonValue>Billing Provider</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Rendering Provider</ButtonLabel><ButtonValue>Rendering Provider</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
		,'0e80f495-b34f-4118-a1e1-c50237e7b65e'
		,2
		,0
		,0
		,'5/21/2019 00:00:00 AM'
		)
END

--SortOrder = 3
IF NOT EXISTS (
		SELECT [UserDefinedControlUid]
		FROM ListUserDefinedControl
		WHERE [UserDefinedControlUid] = '33667d50-73b5-4081-9ab6-c43cfb5fa042'
		)
BEGIN
	INSERT ListUserDefinedControl (
		[UserDefinedControlUid]
		,[Name]
		,[Inactive]
		,[Label]
		,[ControlTypeUid]
		,[ControlProperties]
		,[UserDefinedControlGroupUid]
		,[SortOrder]
		,[UserDefined]
		,[RDLDesigner]
		,[LastModifiedDate]
		)
	VALUES (
		'33667d50-73b5-4081-9ab6-c43cfb5fa042'
		,'AccountTypeUid'
		,0
		,'Payer Plan Account Types'
		,'8a957d7c-8b86-4a67-8336-b830c30fd123'
		,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>AccountTypeUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Account Type</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListAccountType</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
		,'0e80f495-b34f-4118-a1e1-c50237e7b65e'
		,3
		,0
		,0
		,'5/21/2019 00:00:00 AM'
		)
END

--SortOrder = 4
IF NOT EXISTS (
		SELECT [UserDefinedControlUid]
		FROM ListUserDefinedControl
		WHERE [UserDefinedControlUid] = '2819b64e-1b7e-444a-a2c2-331441042584'
		)
BEGIN
	INSERT ListUserDefinedControl (
		[UserDefinedControlUid]
		,[Name]
		,[Inactive]
		,[Label]
		,[ControlTypeUid]
		,[ControlProperties]
		,[UserDefinedControlGroupUid]
		,[SortOrder]
		,[UserDefined]
		,[RDLDesigner]
		,[LastModifiedDate]
		)
	VALUES (
		'2819b64e-1b7e-444a-a2c2-331441042584'
		,'FinancialCenterUid'
		,0
		,'Financial Centers'
		,'8a957d7c-8b86-4a67-8336-b830c30fd123'
		,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>FinancialCenterUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Financial Center</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>FinancialCenter</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
		,'0e80f495-b34f-4118-a1e1-c50237e7b65e'
		,4
		,0
		,0
		,'5/21/2019 00:00:00 AM'
		)
END

--SortOrder = 5
IF NOT EXISTS (
		SELECT [UserDefinedControlUid]
		FROM ListUserDefinedControl
		WHERE [UserDefinedControlUid] = '7ca2f015-20b3-4543-90c5-3a401299f3a7'
		)
BEGIN
	INSERT ListUserDefinedControl (
		[UserDefinedControlUid]
		,[Name]
		,[Inactive]
		,[Label]
		,[ControlTypeUid]
		,[ControlProperties]
		,[UserDefinedControlGroupUid]
		,[SortOrder]
		,[UserDefined]
		,[RDLDesigner]
		,[LastModifiedDate]
		)
	VALUES (
		'7ca2f015-20b3-4543-90c5-3a401299f3a7'
		,'PayerUid'
		,0
		,'Payers to be Excluded'
		,'8a957d7c-8b86-4a67-8336-b830c30fd123'
		,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>PayerUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Insurance Payer</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewInsuranceCarrier</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
		,'0e80f495-b34f-4118-a1e1-c50237e7b65e'
		,5
		,0
		,0
		,'5/21/2019 00:00:00 AM'
		)
END

--SortOrder = 6
IF NOT EXISTS (
		SELECT [UserDefinedControlUid]
		FROM ListUserDefinedControl
		WHERE [UserDefinedControlUid] = 'efe66b73-6c3b-400a-b27c-2923ab9a9af3'
		)
BEGIN
	INSERT ListUserDefinedControl (
		[UserDefinedControlUid]
		,[Name]
		,[Inactive]
		,[Label]
		,[ControlTypeUid]
		,[ControlProperties]
		,[UserDefinedControlGroupUid]
		,[SortOrder]
		,[UserDefined]
		,[RDLDesigner]
		,[LastModifiedDate]
		)
	VALUES (
		'efe66b73-6c3b-400a-b27c-2923ab9a9af3'
		,'ageMin'
		,0
		,'Age Min'
		,'68cbe02c-d310-44ac-ae8d-faf93ce4d64b'
		,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>NUMERIC</ControlType><Name>ageMin</Name><MinValue>0</MinValue><MaxValue>36599999999</MaxValue><DefaultValue>55</DefaultValue><DecimalPlaces>0</DecimalPlaces><Required>FALSE</Required></Control></UserDefinedControls>'
		,'0e80f495-b34f-4118-a1e1-c50237e7b65e'
		,6
		,0
		,0
		,'5/21/2019 00:00:00 AM'
		)
END

--SortOrder = 7
IF NOT EXISTS (
		SELECT [UserDefinedControlUid]
		FROM ListUserDefinedControl
		WHERE [UserDefinedControlUid] = '7bc5a460-a5f1-4111-8a66-180c9671b733'
		)
BEGIN
	INSERT ListUserDefinedControl (
		[UserDefinedControlUid]
		,[Name]
		,[Inactive]
		,[Label]
		,[ControlTypeUid]
		,[ControlProperties]
		,[UserDefinedControlGroupUid]
		,[SortOrder]
		,[UserDefined]
		,[RDLDesigner]
		,[LastModifiedDate]
		)
	VALUES (
		'7bc5a460-a5f1-4111-8a66-180c9671b733'
		,'BalanceMin'
		,0
		,'Balance Min'
		,'68cbe02c-d310-44ac-ae8d-faf93ce4d64b'
		,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>NUMERIC</ControlType><Name>BalanceMin</Name><MinValue>-1000000</MinValue><MaxValue>1000000</MaxValue><DefaultValue>0.01</DefaultValue><DecimalPlaces>2</DecimalPlaces><Required>FALSE</Required></Control></UserDefinedControls>'
		,'0e80f495-b34f-4118-a1e1-c50237e7b65e'
		,7
		,0
		,0
		,'5/21/2019 00:00:00 AM'
		)
END

--SortOrder = 8
IF NOT EXISTS (
		SELECT [UserDefinedControlUid]
		FROM ListUserDefinedControl
		WHERE [UserDefinedControlUid] = '4e98bb42-24db-43f5-85bf-1ab2ad8f21e0'
		)
BEGIN
	INSERT ListUserDefinedControl (
		[UserDefinedControlUid]
		,[Name]
		,[Inactive]
		,[Label]
		,[ControlTypeUid]
		,[ControlProperties]
		,[UserDefinedControlGroupUid]
		,[SortOrder]
		,[UserDefined]
		,[RDLDesigner]
		,[LastModifiedDate]
		)
	VALUES (
		'4e98bb42-24db-43f5-85bf-1ab2ad8f21e0'
		,'ExcludeSuperbillStatusUid'
		,0
		,'Exclude Superbill Statuses'
		,'8a957d7c-8b86-4a67-8336-b830c30fd123'
		,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ExcludeSuperbillStatusUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Superbill Status</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListSuperbillStatus</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
		,'0e80f495-b34f-4118-a1e1-c50237e7b65e'
		,8
		,0
		,0
		,'5/21/2019 00:00:00 AM'
		)
END

--SortOrder = 9
IF NOT EXISTS (
		SELECT [UserDefinedControlUid]
		FROM ListUserDefinedControl
		WHERE [UserDefinedControlUid] = '52f04968-8876-49a8-a46c-65b0955f098a'
		)
BEGIN
	INSERT ListUserDefinedControl (
		[UserDefinedControlUid]
		,[Name]
		,[Inactive]
		,[Label]
		,[ControlTypeUid]
		,[ControlProperties]
		,[UserDefinedControlGroupUid]
		,[SortOrder]
		,[UserDefined]
		,[RDLDesigner]
		,[LastModifiedDate]
		)
	VALUES (
		'52f04968-8876-49a8-a46c-65b0955f098a'
		,'LastPaymentOlderThanDays'
		,0
		,'RP Payment Older Than Days'
		,'68cbe02c-d310-44ac-ae8d-faf93ce4d64b'
		,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>NUMERIC</ControlType><Name>LastPaymentOlderThanDays</Name><MinValue>0</MinValue><MaxValue>10000</MaxValue><DefaultValue>0</DefaultValue><DecimalPlaces>0</DecimalPlaces><Required>FALSE</Required></Control></UserDefinedControls>'
		,'0e80f495-b34f-4118-a1e1-c50237e7b65e'
		,9
		,0
		,0
		,'5/21/2019 00:00:00 AM'
		)
END

--SortOrder = 10
IF NOT EXISTS (
		SELECT [UserDefinedControlUid]
		FROM ListUserDefinedControl
		WHERE [UserDefinedControlUid] = '6d36bde7-cf10-4725-a380-91452f5f60c0'
		)
BEGIN
	INSERT ListUserDefinedControl (
		[UserDefinedControlUid]
		,[Name]
		,[Inactive]
		,[Label]
		,[ControlTypeUid]
		,[ControlProperties]
		,[UserDefinedControlGroupUid]
		,[SortOrder]
		,[UserDefined]
		,[RDLDesigner]
		,[LastModifiedDate]
		)
	VALUES (
		'6d36bde7-cf10-4725-a380-91452f5f60c0'
		,'CollectionStatusUid'
		,0
		,'Collection Statuses'
		,'8a957d7c-8b86-4a67-8336-b830c30fd123'
		,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>CollectionStatusUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Collection Status</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListCollectionStatus</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
		,'0e80f495-b34f-4118-a1e1-c50237e7b65e'
		,10
		,0
		,0
		,'5/21/2019 00:00:00 AM'
		)
END

--Update ListReport ListUserDefinedControlGroupUid
IF EXISTS (
		SELECT *
		FROM ListReport
		WHERE UserDefinedControlGroupUid = 'F41E9591-057D-439E-BBB1-0606A5DE8C43' AND ReportUid = '3C1F9E0E-F89C-4865-826F-36AC1BB572C0'
		)
BEGIN
	UPDATE ListReport
	SET UserDefinedControlGroupUid = '0e80f495-b34f-4118-a1e1-c50237e7b65e'
	WHERE UserDefinedControlGroupUid = 'F41E9591-057D-439E-BBB1-0606A5DE8C43' AND ReportUid = '3C1F9E0E-F89C-4865-826F-36AC1BB572C0'
END

--DELETE OLD ListUserDefinedControlGroup 
--Should cascade delete ListUserDefinedControl entries
IF EXISTS (
		SELECT UserDefinedControlGroupUid
		FROM ListUserDefinedControlGroup
		WHERE UserDefinedControlGroupUid = 'F41E9591-057D-439E-BBB1-0606A5DE8C43'
		)
BEGIN
	DELETE ListUserDefinedControlGroup
	WHERE UserDefinedControlGroupUid = 'F41E9591-057D-439E-BBB1-0606A5DE8C43'
END

--DELETE OLD ListUserDefinedControls if they still exist
IF EXISTS (
		SELECT UserDefinedControlGroupUid
		FROM ListUserDefinedControl
		WHERE UserDefinedControlGroupUid = 'F41E9591-057D-439E-BBB1-0606A5DE8C43'
		)
BEGIN
	DELETE ListUserDefinedControl
	WHERE UserDefinedControlGroupUid = 'F41E9591-057D-439E-BBB1-0606A5DE8C43'
END
GO

-- #802   EMR_HealthMaintenanceRuleSummary_MigrationScript.sql
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'C7A795F3-7C24-4568-ADD8-4D1417EB3113')
BEGIN
INSERT into ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('c7a795f3-7c24-4568-add8-4d1417eb3113','Type',0,'Type','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>Type</Name><ButtonLabel>All Patient</ButtonLabel><ButtonValue>all</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>Type</Name><ButtonLabel>Due Patient</ButtonLabel><ButtonValue>due</ButtonValue><Default>false</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>Type</Name><ButtonLabel>Overdue Patient</ButtonLabel><ButtonValue>overdue</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','69a5f19f-39e8-421f-bfb7-7c65604344cd',0,0,0,'8/20/2019 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'F8734023-2A2A-4B54-A775-789095CC99EE')
BEGIN
INSERT INTO ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('f8734023-2a2a-4b54-a775-789095cc99ee','RuleUID',0,'Rule','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>RuleUID</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Health Maintenance Rule</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListHMRule</FindTableName></Control></UserDefinedControls>','69a5f19f-39e8-421f-bfb7-7c65604344cd',1,0,0,'8/20/2019 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '28F36A25-ACD0-4071-AFED-0E6CEFCA6B73')
BEGIN
INSERT INTO ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('28f36a25-acd0-4071-afed-0e6cefca6b73','PatientAgeRange',0,'Patient Age Range','23d953d7-7438-48d0-9fd1-c950130cb558','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TEXT</ControlType><Name>PatientAgeRange</Name><DefaultText>0-100</DefaultText><MaxLength>7</MaxLength><MultiLine>false</MultiLine></Control></UserDefinedControls>','69a5f19f-39e8-421f-bfb7-7c65604344cd',2,0,0,'8/20/2019 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '8FB97C3F-9F5B-4B83-ADEB-6BA370ACE760')
BEGIN
INSERT INTO ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('8fb97c3f-9f5b-4b83-adeb-6ba370ace760','sortBy',0,'Sort By','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<?xml version=''1.0'' encoding=''utf-8''?><UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>sortBy</Name><ButtonLabel>Due Date</ButtonLabel><ButtonValue>D</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>sortBy</Name><ButtonLabel>Patient</ButtonLabel><ButtonValue>P</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','69a5f19f-39e8-421f-bfb7-7c65604344cd',3,0,0,'8/20/2019 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '5AF23E4D-4841-466B-BF8C-9F45637156DD')
BEGIN
INSERT INTO ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('5af23e4d-4841-466b-bf8c-9f45637156dd','PatientStatusUid',0,'Patient Statuses','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>PatientStatusUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Patient Status</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListPatientStatus</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','69a5f19f-39e8-421f-bfb7-7c65604344cd',4,0,0,'8/20/2019 7:00:00 PM')
END
GO

IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'D5E4213B-58F8-4086-AD85-A8893E878AA8')
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('d5e4213b-58f8-4086-ad85-a8893e878aa8','PatientConditionUid',0,'Patient Conditions','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>PatientConditionUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Patient Condition</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListPatientCondition</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','69a5f19f-39e8-421f-bfb7-7c65604344cd',5,0,0,'8/20/2019 7:00:00 PM')
END
GO

Update ListReport
set ReportParameters='<ReportParameters />',
UserDefined=0,
LastModifiedByUid=NULL,
LastModifiedDate='2019-08-21 00:00:00.000'
where ReportUid='732B3A22-1991-4816-BB64-82D5A076254A';

update ListUserDefinedControlGroup
set UserDefined=0,
LastModifiedByUid=NULL,
LastModifiedDate='2019-08-21 00:00:00.000'
where UserDefinedControlGroupUid='69A5F19F-39E8-421F-BFB7-7C65604344CD';
 
update ListUserDefinedControl
set UserDefined=0,
LastModifiedByUid=NULL,
LastModifiedDate='2019-08-21 00:00:00.000'
where UserDefinedControlGroupUid='69A5F19F-39E8-421F-BFB7-7C65604344CD';
GO

-- #2372 2372 Controlled Substance Rx migration script.sql
-- 20190826 kculberth bug 2372 Ability to view the "Start Date" when viewing the Controlled Substance Rx Report  Minor changes to existing report
-- delete existing controls
IF EXISTS (
		SELECT Name
		FROM ListUserDefinedControl
		WHERE UserDefinedControlGroupUid = 'b722fc60-ea64-4229-a6dd-213008da124a'
		)
BEGIN
	DELETE
	FROM ListUserDefinedControl
	WHERE UserDefinedControlGroupUid = 'b722fc60-ea64-4229-a6dd-213008da124a'
END

-- SortOrder 0
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	, [Name]
	, [Inactive]
	, [Label]
	, [ControlTypeUid]
	, [ControlProperties]
	, [UserDefinedControlGroupUid]
	, [SortOrder]
	, [UserDefined]
	, [RDLDesigner]
	, [LastModifiedDate]
	)
VALUES (
	'82a1b498-5087-47cc-96af-15d5bdbdc6a6'
	, 'ProviderUID'
	, 0
	, 'Providers'
	, '8a957d7c-8b86-4a67-8336-b830c30fd123'
	, '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProviderUID</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Provider</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewProvider</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	, 'b722fc60-ea64-4229-a6dd-213008da124a'
	, 0
	, 0
	, 0
	, '8/20/2019 1:33:06 PM'
	)

-- SortOrder 0
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	, [Name]
	, [Inactive]
	, [Label]
	, [ControlTypeUid]
	, [ControlProperties]
	, [UserDefinedControlGroupUid]
	, [SortOrder]
	, [UserDefined]
	, [RDLDesigner]
	, [LastModifiedDate]
	)
VALUES (
	'5c6b22a6-dd58-4561-a982-abf8328e529e'
	, 'CRX'
	, 0
	, 'Timespan'
	, 'df87d0d5-bf48-49fb-abbc-cb75cc29eb64'
	, '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>CRX</Name><Uid>f2e52f89-7f2c-466a-a878-459f82fa12c9</Uid></Control></UserDefinedControls>'
	, 'b722fc60-ea64-4229-a6dd-213008da124a'
	, 1
	, 0
	, 0
	, '8/20/2019 1:33:06 PM'
	)

-- SortOrder 2
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	, [Name]
	, [Inactive]
	, [Label]
	, [ControlTypeUid]
	, [ControlProperties]
	, [UserDefinedControlGroupUid]
	, [SortOrder]
	, [UserDefined]
	, [RDLDesigner]
	, [LastModifiedDate]
	)
VALUES (
	'52a930b8-ec03-4c56-96ef-e87075e4af4c'
	, 'DateOption'
	, 0
	, 'Date Type Option'
	, '8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
	, '<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>DateOption</Name><ButtonLabel>Rx Issue Date</ButtonLabel><ButtonValue>Issue</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>DateOption</Name><ButtonLabel>Rx Start Date</ButtonLabel><ButtonValue>Start</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
	, 'b722fc60-ea64-4229-a6dd-213008da124a'
	, 2
	, 0
	, 0
	, '8/20/2019 1:33:06 PM'
	)
GO

-- #17286_AppointmentReport_Parameters update_migration.sql
Update ListUserDefinedControl
set label='Patients'
where UserDefinedControlUid='640C9A2F-F75E-44EE-BC81-FB9E50C8EF1D';

Update ListUserDefinedControl
set label='Calendars'
where UserDefinedControlUid='0BF0F032-C7CD-4546-AEEB-217F143D226D';

Update ListUserDefinedControl
set label='Providers'
where UserDefinedControlUid='C301D9DF-A493-47B4-A424-46D1682E920F';

Update ListUserDefinedControl
set label='Appointment Types'
where UserDefinedControlUid='9502FBE7-181C-467B-9741-389EF9229D61';

Update ListUserDefinedControl
set label='Appointment Statuses'
where UserDefinedControlUid='C2BD8D62-E056-4D65-9DCA-3E5F37CC7B92';

Update ListUserDefinedControl
set label='Service Sites'
where UserDefinedControlUid='E842AB9B-1B95-416F-800B-6FC453BF1775';
GO

-- #24346  20190826 kculberth bug 24346 Reimbursement Analysis Excel
-- delete existing controls
IF EXISTS (
		SELECT Name
		FROM ListUserDefinedControl
		WHERE UserDefinedControlGroupUid = 'e564420d-cf91-42b9-976c-458f88623285'
		)
BEGIN
	DELETE
	FROM ListUserDefinedControl
	WHERE UserDefinedControlGroupUid = 'e564420d-cf91-42b9-976c-458f88623285'
END

-- add controls back in
-- ListUserDefinedControl
-- SortOrder 0
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	, [Name]
	, [Inactive]
	, [Label]
	, [ControlTypeUid]
	, [ControlProperties]
	, [UserDefinedControlGroupUid]
	, [SortOrder]
	, [UserDefined]
	, [RDLDesigner]
	, [LastModifiedDate]
	)
VALUES (
	'75aad3da-651b-4ca1-bd3f-fca3d17edecf'
	, 'Charge'
	, 0
	, 'Charge Dates'
	, 'df87d0d5-bf48-49fb-abbc-cb75cc29eb64'
	, '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>Charge</Name><Uid>f2e52f89-7f2c-466a-a878-459f82fa12c9</Uid><Required>TRUE</Required></Control></UserDefinedControls>'
	, 'e564420d-cf91-42b9-976c-458f88623285'
	, 0
	, 0
	, 0
	, '8/21/2019 12:58:55 PM'
	)

-- SortOrder 1
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	, [Name]
	, [Inactive]
	, [Label]
	, [ControlTypeUid]
	, [ControlProperties]
	, [UserDefinedControlGroupUid]
	, [SortOrder]
	, [UserDefined]
	, [RDLDesigner]
	, [LastModifiedDate]
	)
VALUES (
	'1c66e695-d192-4976-b056-2c44a933756d'
	, 'ChargeDateOption'
	, 0
	, 'Charge Date Option'
	, '8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
	, '<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ChargeDateOption</Name><ButtonLabel>Posting Date</ButtonLabel><ButtonValue>Posting</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ChargeDateOption</Name><ButtonLabel>Service Date</ButtonLabel><ButtonValue>Service</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
	, 'e564420d-cf91-42b9-976c-458f88623285'
	, 1
	, 0
	, 0
	, '8/21/2019 12:58:55 PM'
	)

-- SortOrder 2
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	, [Name]
	, [Inactive]
	, [Label]
	, [ControlTypeUid]
	, [ControlProperties]
	, [UserDefinedControlGroupUid]
	, [SortOrder]
	, [UserDefined]
	, [RDLDesigner]
	, [LastModifiedDate]
	)
VALUES (
	'7e6974b3-0c61-4d84-a4b2-f624bd9160ae'
	, 'Transaction'
	, 0
	, 'Transaction Posting Dates'
	, 'df87d0d5-bf48-49fb-abbc-cb75cc29eb64'
	, '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>Transaction</Name><Uid>f2e52f89-7f2c-466a-a878-459f82fa12c9</Uid><Required>TRUE</Required></Control></UserDefinedControls>'
	, 'e564420d-cf91-42b9-976c-458f88623285'
	, 2
	, 0
	, 0
	, '8/21/2019 12:58:55 PM'
	)

-- SortOrder 3
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	, [Name]
	, [Inactive]
	, [Label]
	, [ControlTypeUid]
	, [ControlProperties]
	, [UserDefinedControlGroupUid]
	, [SortOrder]
	, [UserDefined]
	, [RDLDesigner]
	, [LastModifiedDate]
	)
VALUES (
	'd5247d45-6c28-4266-bb73-db7a45a38b3c'
	, 'ProviderUid'
	, 0
	, 'Providers'
	, '8a957d7c-8b86-4a67-8336-b830c30fd123'
	, '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProviderUid</Name><SelectType>Multi</SelectType><Conjunction>or</Conjunction><EntryNameInFindTable>Provider</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewProvider</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	, 'e564420d-cf91-42b9-976c-458f88623285'
	, 3
	, 0
	, 0
	, '8/21/2019 12:58:55 PM'
	)

-- SortOrder 4
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	, [Name]
	, [Inactive]
	, [Label]
	, [ControlTypeUid]
	, [ControlProperties]
	, [UserDefinedControlGroupUid]
	, [SortOrder]
	, [UserDefined]
	, [RDLDesigner]
	, [LastModifiedDate]
	)
VALUES (
	'd2455879-70f6-4f6e-ba7d-de7a8b75c32c'
	, 'ProviderOption'
	, 0
	, 'Provider Option'
	, '8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
	, '<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Billing Provider</ButtonLabel><ButtonValue>Billing</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Rendering Provider</ButtonLabel><ButtonValue>Rendering</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
	, 'e564420d-cf91-42b9-976c-458f88623285'
	, 4
	, 0
	, 0
	, '8/21/2019 12:58:55 PM'
	)

-- SortOrder 5
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	, [Name]
	, [Inactive]
	, [Label]
	, [ControlTypeUid]
	, [ControlProperties]
	, [UserDefinedControlGroupUid]
	, [SortOrder]
	, [UserDefined]
	, [RDLDesigner]
	, [LastModifiedDate]
	)
VALUES (
	'31333663-4700-47b0-a2ea-f8e066ea086a'
	, 'FinancialCenterUID'
	, 0
	, 'Financial Centers'
	, '8a957d7c-8b86-4a67-8336-b830c30fd123'
	, '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>FinancialCenterUID</Name><SelectType>Multi</SelectType><Conjunction>or</Conjunction><EntryNameInFindTable>Financial Center</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>FinancialCenter</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	, 'e564420d-cf91-42b9-976c-458f88623285'
	, 5
	, 0
	, 0
	, '8/21/2019 12:58:55 PM'
	)

-- SortOrder 6
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	, [Name]
	, [Inactive]
	, [Label]
	, [ControlTypeUid]
	, [ControlProperties]
	, [UserDefinedControlGroupUid]
	, [SortOrder]
	, [UserDefined]
	, [RDLDesigner]
	, [LastModifiedDate]
	)
VALUES (
	'eaf18543-7670-4d20-9c67-f1c4d8b62004'
	, 'ServiceSiteUid'
	, 0
	, 'Service Sites'
	, '8a957d7c-8b86-4a67-8336-b830c30fd123'
	, '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ServiceSiteUid</Name><SelectType>Multi</SelectType><Conjunction>or</Conjunction><EntryNameInFindTable>Service Site</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListServiceSite</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	, 'e564420d-cf91-42b9-976c-458f88623285'
	, 6
	, 0
	, 0
	, '8/21/2019 12:58:55 PM'
	)

-- SortOrder 7
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	, [Name]
	, [Inactive]
	, [Label]
	, [ControlTypeUid]
	, [ControlProperties]
	, [UserDefinedControlGroupUid]
	, [SortOrder]
	, [UserDefined]
	, [RDLDesigner]
	, [LastModifiedDate]
	)
VALUES (
	'3e14c300-9ad2-4809-a5a3-2d089b9f76ee'
	, 'InsurancePayerUID'
	, 0
	, 'Insurance Payers'
	, '8a957d7c-8b86-4a67-8336-b830c30fd123'
	, '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>InsurancePayerUID</Name><SelectType>Multi</SelectType><Conjunction>or</Conjunction><EntryNameInFindTable>Insurance Payer</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewInsuranceCarrier</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	, 'e564420d-cf91-42b9-976c-458f88623285'
	, 7
	, 0
	, 0
	, '8/21/2019 12:58:55 PM'
	)

-- SortOrder 8
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	, [Name]
	, [Inactive]
	, [Label]
	, [ControlTypeUid]
	, [ControlProperties]
	, [UserDefinedControlGroupUid]
	, [SortOrder]
	, [UserDefined]
	, [RDLDesigner]
	, [LastModifiedDate]
	)
VALUES (
	'7a557276-7276-4d22-a32c-cb05d0e893a1'
	, 'GroupByUid'
	, 0
	, 'Group By'
	, '8a957d7c-8b86-4a67-8336-b830c30fd123'
	, '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>GroupByUid</Name><SelectType>Single</SelectType><Conjunction>none</Conjunction><EntryNameInFindTable>ReImpAnalysisGroup</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ReImpAnalysisGroup</FindTableName></Control></UserDefinedControls>'
	, 'e564420d-cf91-42b9-976c-458f88623285'
	, 8
	, 0
	, 0
	, '8/21/2019 12:58:55 PM'
	)

-- SortOrder 9
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	, [Name]
	, [Inactive]
	, [Label]
	, [ControlTypeUid]
	, [ControlProperties]
	, [UserDefinedControlGroupUid]
	, [SortOrder]
	, [UserDefined]
	, [RDLDesigner]
	, [LastModifiedDate]
	)
VALUES (
	'f04528f0-b26f-4d9e-9b48-42bd9aeee6c8'
	, 'IncludeZeroCharges'
	, 0
	, 'Include $0 Procedures'
	, '71e67ced-b180-44e9-80c9-1ed3b47c9390'
	, '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>CHECKBOX</ControlType><Name>IncludeZeroCharges</Name><CheckedText>True</CheckedText><UnCheckedText>False</UnCheckedText><CheckedByDefault>true</CheckedByDefault></Control></UserDefinedControls>'
	, 'e564420d-cf91-42b9-976c-458f88623285'
	, 9
	, 0
	, 0
	, '8/21/2019 12:58:55 PM'
	)

-- SortOrder 10
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	, [Name]
	, [Inactive]
	, [Label]
	, [ControlTypeUid]
	, [ControlProperties]
	, [UserDefinedControlGroupUid]
	, [SortOrder]
	, [UserDefined]
	, [RDLDesigner]
	, [LastModifiedDate]
	)
VALUES (
	'63e9155a-e397-4148-b260-e3006c19d061'
	, 'IncludeZeroPayments'
	, 0
	, 'Include Procedures with $0 Payments/Adjustments'
	, '71e67ced-b180-44e9-80c9-1ed3b47c9390'
	, '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>CHECKBOX</ControlType><Name>IncludeZeroPayments</Name><CheckedText>True</CheckedText><UnCheckedText>False</UnCheckedText><CheckedByDefault>false</CheckedByDefault></Control></UserDefinedControls>'
	, 'e564420d-cf91-42b9-976c-458f88623285'
	, 10
	, 0
	, 0
	, '8/21/2019 12:58:55 PM'
	)
GO

-- #787  -- 20190826 kculberth bug 787 Reimbursement Analysis
-- delete existing controls
IF EXISTS (
		SELECT Name
		FROM ListUserDefinedControl
		WHERE UserDefinedControlGroupUid = 'ff99baab-16b3-4864-9d6a-49732bbac318'
		)
BEGIN
	DELETE 
	FROM ListUserDefinedControl
	WHERE UserDefinedControlGroupUid = 'ff99baab-16b3-4864-9d6a-49732bbac318'
END

-- add controls back in
-- ListUserDefinedControl

-- SortOrder 0
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	, [Name]
	, [Inactive]
	, [Label]
	, [ControlTypeUid]
	, [ControlProperties]
	, [UserDefinedControlGroupUid]
	, [SortOrder]
	, [UserDefined]
	, [RDLDesigner]
	, [LastModifiedDate]
	)
VALUES (
	'bcdc67f3-8ca9-4bfb-98fc-fea08a0ffeb7'
	, 'Charge'
	, 0
	, 'Charge Dates'
	, 'df87d0d5-bf48-49fb-abbc-cb75cc29eb64'
	, '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>Charge</Name><Uid>f2e52f89-7f2c-466a-a878-459f82fa12c9</Uid><Required>TRUE</Required></Control></UserDefinedControls>'
	, 'ff99baab-16b3-4864-9d6a-49732bbac318'
	, 0
	, 0
	, 0
	, '8/21/2019 9:22:13 AM'
	)

-- SortOrder 1
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	, [Name]
	, [Inactive]
	, [Label]
	, [ControlTypeUid]
	, [ControlProperties]
	, [UserDefinedControlGroupUid]
	, [SortOrder]
	, [UserDefined]
	, [RDLDesigner]
	, [LastModifiedDate]
	)
VALUES (
	'96743618-9d9c-4dcf-9d21-a29b622c5b07'
	, 'ChargeDateOption'
	, 0
	, 'Charge Date Option'
	, '8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
	, '<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ChargeDateOption</Name><ButtonLabel>Posting Date</ButtonLabel><ButtonValue>Posting</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ChargeDateOption</Name><ButtonLabel>Service Date</ButtonLabel><ButtonValue>Service</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
	, 'ff99baab-16b3-4864-9d6a-49732bbac318'
	, 1
	, 0
	, 0
	, '8/21/2019 9:22:13 AM'
	)

-- SortOrder 2
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	, [Name]
	, [Inactive]
	, [Label]
	, [ControlTypeUid]
	, [ControlProperties]
	, [UserDefinedControlGroupUid]
	, [SortOrder]
	, [UserDefined]
	, [RDLDesigner]
	, [LastModifiedDate]
	)
VALUES (
	'c54afc99-d974-4317-a71e-eaa6d37fe526'
	, 'Transaction'
	, 0
	, 'Transaction Posting Dates'
	, 'df87d0d5-bf48-49fb-abbc-cb75cc29eb64'
	, '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>Transaction</Name><Uid>f2e52f89-7f2c-466a-a878-459f82fa12c9</Uid><Required>TRUE</Required></Control></UserDefinedControls>'
	, 'ff99baab-16b3-4864-9d6a-49732bbac318'
	, 2
	, 0
	, 0
	, '8/21/2019 9:22:13 AM'
	)

-- SortOrder 3
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	, [Name]
	, [Inactive]
	, [Label]
	, [ControlTypeUid]
	, [ControlProperties]
	, [UserDefinedControlGroupUid]
	, [SortOrder]
	, [UserDefined]
	, [RDLDesigner]
	, [LastModifiedDate]
	)
VALUES (
	'0d3c9640-7997-4c3b-8db6-3079e82045af'
	, 'ProviderUid'
	, 0
	, 'Providers'
	, '8a957d7c-8b86-4a67-8336-b830c30fd123'
	, '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProviderUid</Name><SelectType>Multi</SelectType><Conjunction>or</Conjunction><EntryNameInFindTable>Provider</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewProvider</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	, 'ff99baab-16b3-4864-9d6a-49732bbac318'
	, 3
	, 0
	, 0
	, '8/21/2019 9:22:13 AM'
	)

-- SortOrder 4
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	, [Name]
	, [Inactive]
	, [Label]
	, [ControlTypeUid]
	, [ControlProperties]
	, [UserDefinedControlGroupUid]
	, [SortOrder]
	, [UserDefined]
	, [RDLDesigner]
	, [LastModifiedDate]
	)
VALUES (
	'1d173ce6-b012-4fee-b3f6-d346428c5188'
	, 'ProviderOption'
	, 0
	, 'Provider Option'
	, '8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
	, '<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Billing Provider</ButtonLabel><ButtonValue>Billing</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Rendering Provider</ButtonLabel><ButtonValue>Rendering</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
	, 'ff99baab-16b3-4864-9d6a-49732bbac318'
	, 4
	, 0
	, 0
	, '8/21/2019 9:22:13 AM'
	)

-- SortOrder 5
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	, [Name]
	, [Inactive]
	, [Label]
	, [ControlTypeUid]
	, [ControlProperties]
	, [UserDefinedControlGroupUid]
	, [SortOrder]
	, [UserDefined]
	, [RDLDesigner]
	, [LastModifiedDate]
	)
VALUES (
	'bb7fb935-6d49-41a8-b865-15c6e9c88112'
	, 'FinancialCenterUID'
	, 0
	, 'Financial Centers'
	, '8a957d7c-8b86-4a67-8336-b830c30fd123'
	, '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>FinancialCenterUID</Name><SelectType>Multi</SelectType><Conjunction>or</Conjunction><EntryNameInFindTable>Financial Center</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>FinancialCenter</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	, 'ff99baab-16b3-4864-9d6a-49732bbac318'
	, 5
	, 0
	, 0
	, '8/21/2019 9:22:13 AM'
	)

-- SortOrder 6
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	, [Name]
	, [Inactive]
	, [Label]
	, [ControlTypeUid]
	, [ControlProperties]
	, [UserDefinedControlGroupUid]
	, [SortOrder]
	, [UserDefined]
	, [RDLDesigner]
	, [LastModifiedDate]
	)
VALUES (
	'2bd1eb0a-7f40-410e-b8f6-d3ad6b3a5234'
	, 'ServiceSiteUid'
	, 0
	, 'Service Sites'
	, '8a957d7c-8b86-4a67-8336-b830c30fd123'
	, '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ServiceSiteUid</Name><SelectType>Multi</SelectType><Conjunction>or</Conjunction><EntryNameInFindTable>Service Site</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListServiceSite</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	, 'ff99baab-16b3-4864-9d6a-49732bbac318'
	, 6
	, 0
	, 0
	, '8/21/2019 9:22:13 AM'
	)

-- SortOrder 7
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	, [Name]
	, [Inactive]
	, [Label]
	, [ControlTypeUid]
	, [ControlProperties]
	, [UserDefinedControlGroupUid]
	, [SortOrder]
	, [UserDefined]
	, [RDLDesigner]
	, [LastModifiedDate]
	)
VALUES (
	'68231e5b-cbc2-405c-8f06-7564afef005a'
	, 'InsurancePayerUID'
	, 0
	, 'Insurance Payers'
	, '8a957d7c-8b86-4a67-8336-b830c30fd123'
	, '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>InsurancePayerUID</Name><SelectType>Multi</SelectType><Conjunction>or</Conjunction><EntryNameInFindTable>Insurance Payer</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewInsuranceCarrier</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	, 'ff99baab-16b3-4864-9d6a-49732bbac318'
	, 7
	, 0
	, 0
	, '8/21/2019 9:22:13 AM'
	)

-- SortOrder 8
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	, [Name]
	, [Inactive]
	, [Label]
	, [ControlTypeUid]
	, [ControlProperties]
	, [UserDefinedControlGroupUid]
	, [SortOrder]
	, [UserDefined]
	, [RDLDesigner]
	, [LastModifiedDate]
	)
VALUES (
	'bd062430-5395-401e-ad9d-eaac621daf31'
	, 'GroupByUid'
	, 0
	, 'Group By'
	, '8a957d7c-8b86-4a67-8336-b830c30fd123'
	, '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>GroupByUid</Name><SelectType>Single</SelectType><Conjunction>none</Conjunction><EntryNameInFindTable>ReImpAnalysisGroup</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ReImpAnalysisGroup</FindTableName></Control></UserDefinedControls>'
	, 'ff99baab-16b3-4864-9d6a-49732bbac318'
	, 8
	, 0
	, 0
	, '8/21/2019 9:22:13 AM'
	)

-- SortOrder 9
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	, [Name]
	, [Inactive]
	, [Label]
	, [ControlTypeUid]
	, [ControlProperties]
	, [UserDefinedControlGroupUid]
	, [SortOrder]
	, [UserDefined]
	, [RDLDesigner]
	, [LastModifiedDate]
	)
VALUES (
	'aa528a3a-5db3-4c5a-9a41-951097f75efb'
	, 'SummaryOnly'
	, 0
	, 'Summary'
	, '71e67ced-b180-44e9-80c9-1ed3b47c9390'
	, '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>CHECKBOX</ControlType><Name>SummaryOnly</Name><CheckedText>True</CheckedText><UnCheckedText>False</UnCheckedText><CheckedByDefault>false</CheckedByDefault></Control></UserDefinedControls>'
	, 'ff99baab-16b3-4864-9d6a-49732bbac318'
	, 9
	, 0
	, 0
	, '8/21/2019 9:22:13 AM'
	)

-- SortOrder 10
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	, [Name]
	, [Inactive]
	, [Label]
	, [ControlTypeUid]
	, [ControlProperties]
	, [UserDefinedControlGroupUid]
	, [SortOrder]
	, [UserDefined]
	, [RDLDesigner]
	, [LastModifiedDate]
	)
VALUES (
	'38cbe27a-c11b-492f-bdbb-158878c23745'
	, 'IncludeZeroCharges'
	, 0
	, 'Include $0 Procedures'
	, '71e67ced-b180-44e9-80c9-1ed3b47c9390'
	, '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>CHECKBOX</ControlType><Name>IncludeZeroCharges</Name><CheckedText>True</CheckedText><UnCheckedText>False</UnCheckedText><CheckedByDefault>true</CheckedByDefault></Control></UserDefinedControls>'
	, 'ff99baab-16b3-4864-9d6a-49732bbac318'
	, 10
	, 0
	, 0
	, '8/21/2019 9:22:13 AM'
	)

-- SortOrder 11
INSERT ListUserDefinedControl (
	[UserDefinedControlUid]
	, [Name]
	, [Inactive]
	, [Label]
	, [ControlTypeUid]
	, [ControlProperties]
	, [UserDefinedControlGroupUid]
	, [SortOrder]
	, [UserDefined]
	, [RDLDesigner]
	, [LastModifiedDate]
	)
VALUES (
	'82d5e70a-e89d-4d00-a6d0-703cadc51051'
	, 'IncludeZeroPayments'
	, 0
	, 'Include Procedures with $0 Payments/Adjustments'
	, '71e67ced-b180-44e9-80c9-1ed3b47c9390'
	, '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>CHECKBOX</ControlType><Name>IncludeZeroPayments</Name><CheckedText>True</CheckedText><UnCheckedText>False</UnCheckedText><CheckedByDefault>false</CheckedByDefault></Control></UserDefinedControls>'
	, 'ff99baab-16b3-4864-9d6a-49732bbac318'
	, 11
	, 0
	, 0
	, '8/21/2019 9:22:13 AM'
	)
GO

-- #14465 RVU Productivity Report_Migration_14465.sql
	Update ListUserDefinedControl
	set Label='Dates',
	sortorder='0',
	LastModifiedDate='2019-09-09 00:00:00.000',
	LastModifiedByUid=null
	where UserDefinedControlUid='3B9C7946-4B64-4450-8771-538314F2321F';

	Update ListUserDefinedControl
	set sortorder='1',--Date Option 
	LastModifiedDate='2019-09-09 00:00:00.000',
	LastModifiedByUid=null
	where UserDefinedControlUid='0F901D8F-2BF4-42C2-9A5C-AADB2C45C1BD';

	Update ListUserDefinedControl
	set Label='Providers',
	sortorder='2',
	LastModifiedDate='2019-09-09 00:00:00.000',
	LastModifiedByUid=null
	where UserDefinedControlUid='3D9E16FF-AD4B-4444-851C-41E7091FBA66';
	
	Update ListUserDefinedControl
	set sortorder='3',--Provider Option
	LastModifiedDate='2019-09-09 00:00:00.000',
	LastModifiedByUid=null
	where UserDefinedControlUid='84837576-2E35-4F59-B339-56AD8B27510E';

	Update ListUserDefinedControl
	set Label='Financial Centers',
	sortorder='4',
	LastModifiedDate='2019-09-09 00:00:00.000',
	LastModifiedByUid=null
	where UserDefinedControlUid='9DE0A70C-A6DB-4FDF-882C-E82F30C1B840';

	Update ListUserDefinedControl
	set Label='Service Sites',
	sortorder='5',
	LastModifiedDate='2019-09-09 00:00:00.000',
	LastModifiedByUid=null
	where UserDefinedControlUid='F799DBCF-CD4E-4EA3-9DAD-823ABA09283B';
	
	Update ListUserDefinedControl
	set sortorder='6',--RVU Source 
	LastModifiedDate='2019-09-09 00:00:00.000',
	LastModifiedByUid=null
	where UserDefinedControlUid='2ABCCA88-59AC-4317-9B0A-3DC5E1350F4F';
	
	Update ListUserDefinedControl
	set sortorder='7',--RVU Schedule 
	LastModifiedDate='2019-09-09 00:00:00.000',
	LastModifiedByUid=null
	where UserDefinedControlUid='9919C372-527F-41AD-9CCD-9683C9B3AA64';
GO	

-- #17122 Patients With Visits By Insurance UserDefined_MigrationScript.sql
DELETE ListUserDefinedControl where UserDefinedControlUid = '17D4F687-8451-417E-9600-A55A332F6CB7'

Update ListUserDefinedControl
SET SortOrder = '0'
WHERE UserdefinedControlUid = '80981BA5-C8A7-4B87-86B3-08383B032322'

Update ListUserDefinedControl
SET SortOrder = '1'
WHERE UserdefinedControlUid = '43E2E3C7-7A75-4AF5-80B6-351912699275'

Update ListUserDefinedControl
SET SortOrder = '2'
WHERE UserdefinedControlUid = '46FAD012-9F0C-4EB9-BA57-1D75DA973D4E'

Update ListUserDefinedControl
SET SortOrder = '3'
WHERE UserdefinedControlUid = '6C7B0E97-D322-4604-AABF-34172807E56A'

Update ListUserDefinedControl
SET SortOrder = '4'
WHERE UserdefinedControlUid = '3023060C-E92B-40E0-8E04-F96CBA09992A'

Update ListUserDefinedControl
SET SortOrder = '5'
WHERE UserdefinedControlUid = 'EC532BDB-5CCC-40EA-9A05-AC4B9507BC8B'

Update ListUserDefinedControl
SET SortOrder = '6'
WHERE UserdefinedControlUid = '1CB95E1F-7084-4077-92E5-0BCE6E241BD5'

Update ListUserDefinedControl
SET SortOrder = '7'
WHERE UserdefinedControlUid = '3F6B822E-94DA-4500-A617-4853B30A1AED'

Update ListUserDefinedControl
SET SortOrder = '8'
WHERE UserdefinedControlUid = 'D120CF0D-F3B3-4D30-9B6A-44D4A29753EC'

Update ListUserDefinedControl
SET SortOrder = '9'
WHERE UserdefinedControlUid = '64088052-0372-4CF3-AFF2-41221D851644'

Update ListUserDefinedControl
SET SortOrder = '10'
WHERE UserdefinedControlUid = 'F4658AA2-914E-4042-BD8E-D6ECA2F43322'

Update ListUserDefinedControl
SET SortOrder = '11'
WHERE UserdefinedControlUid = '48F535F3-290D-4B48-8766-277E4C0438FA'

Update ListUserDefinedControl
SET SortOrder = '12'
WHERE UserdefinedControlUid = '77FF7A75-D4BF-46DE-8441-A683769FA05F'
GO

-- #13697
-- 09/17/2019 kculberth fix 13697 Financial Summary: remove 4th group level option and add $ to report output
--ListUserDefinedControl Delete FourthGroupLevel
IF EXISTS (SELECT * FROM ListUserDefinedControl WHERE UserDefinedControlUid = '74AE3017-F262-438C-B784-16B34783217B') 
	DELETE 
	FROM ListUserDefinedControl 
	WHERE UserDefinedControlUid = '74AE3017-F262-438C-B784-16B34783217B'
GO

-- #26043  AdjustmentsDetail_Migration_764_26043.sql

--begin tran;
IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '91de6e0f-6fe9-4b4b-941d-c29a79974df7')
BEGIN
Delete from ListUserDefinedControl where UserDefinedControlUid = '91de6e0f-6fe9-4b4b-941d-c29a79974df7'
END 
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '91de6e0f-6fe9-4b4b-941d-c29a79974df7')
Begin
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('91de6e0f-6fe9-4b4b-941d-c29a79974df7','AdjSummary',0,'Timespan','df87d0d5-bf48-49fb-abbc-cb75cc29eb64','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>AdjSummary</Name><Uid>00000000-0000-0000-0000-000000000000</Uid></Control></UserDefinedControls>','901c4cf8-b458-489a-b9a7-c7d0764f05a6',0,0,0,'9/24/2019 7:00:00 PM')
END
GO
---------------------------------
IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '979b56a4-640f-4351-9e18-92ff4233e8f1')
BEGIN
Delete from ListUserDefinedControl where UserDefinedControlUid = '979b56a4-640f-4351-9e18-92ff4233e8f1'
END 
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '979b56a4-640f-4351-9e18-92ff4233e8f1')
Begin
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('979b56a4-640f-4351-9e18-92ff4233e8f1','DateOption',0,'Date Option','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ReportDateType</Name><ButtonLabel>Posting Date</ButtonLabel><ButtonValue>Posting Date</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ReportDateType</Name><ButtonLabel>Deposit Date</ButtonLabel><ButtonValue>Deposit Date</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','901c4cf8-b458-489a-b9a7-c7d0764f05a6',1,0,0,'9/24/2019 7:00:00 PM') 
END
GO
----------------------------------
IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '053a7651-a77d-4e13-9132-d9284f2c68dd')
BEGIN
Delete from ListUserDefinedControl where UserDefinedControlUid = '053a7651-a77d-4e13-9132-d9284f2c68dd'
END 
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '053a7651-a77d-4e13-9132-d9284f2c68dd')
Begin
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('053a7651-a77d-4e13-9132-d9284f2c68dd','ProviderUid',0,'Providers','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProviderUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Provider</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewProvider</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','901c4cf8-b458-489a-b9a7-c7d0764f05a6',2,0,0,'9/24/2019 7:00:00 PM') 
END
GO
------------------------------------
IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '4ae55df1-34d4-423f-af2a-d9b1bcf0f5ff')
BEGIN
Delete from ListUserDefinedControl where UserDefinedControlUid = '4ae55df1-34d4-423f-af2a-d9b1bcf0f5ff'
END 
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '4ae55df1-34d4-423f-af2a-d9b1bcf0f5ff')
Begin
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('4ae55df1-34d4-423f-af2a-d9b1bcf0f5ff','ProviderOption',0,'Provider Option','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ReportProviderType</Name><ButtonLabel>Billing Provider</ButtonLabel><ButtonValue>BillingProvider</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ReportProviderType</Name><ButtonLabel>Rendering Provider</ButtonLabel><ButtonValue>RenderingProvider</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','901c4cf8-b458-489a-b9a7-c7d0764f05a6',3,0,0,'9/24/2019 7:00:00 PM')
END
GO
------------------------------------
IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '2175c82c-c1e9-48e7-84e9-f831a9e1e57e')
BEGIN
Delete from ListUserDefinedControl where UserDefinedControlUid = '2175c82c-c1e9-48e7-84e9-f831a9e1e57e'
END 
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '2175c82c-c1e9-48e7-84e9-f831a9e1e57e')
Begin
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('2175c82c-c1e9-48e7-84e9-f831a9e1e57e','FinancialCenterUid',0,'Financial Centers','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>FinancialCenterUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Financial Center</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>FinancialCenter</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','901c4cf8-b458-489a-b9a7-c7d0764f05a6',4,0,0,'9/24/2019 7:00:00 PM') 
END
GO
------------------------------------
IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'a49895fe-aad3-490e-9d57-6bf0e5912a43')
BEGIN
Delete from ListUserDefinedControl where UserDefinedControlUid = 'a49895fe-aad3-490e-9d57-6bf0e5912a43'
END 
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'a49895fe-aad3-490e-9d57-6bf0e5912a43')
Begin
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('a49895fe-aad3-490e-9d57-6bf0e5912a43','ServiceSiteUid',0,'Service Sites','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ServiceSiteUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Service Site</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListServiceSite</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','901c4cf8-b458-489a-b9a7-c7d0764f05a6',5,0,0,'9/24/2019 7:00:00 PM')
END
GO
--------------------------------------
IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'a968bf6a-d9cb-4c45-9e47-869a65660230')
BEGIN
Delete from ListUserDefinedControl where UserDefinedControlUid = 'a968bf6a-d9cb-4c45-9e47-869a65660230'
END 
GO
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'a968bf6a-d9cb-4c45-9e47-869a65660230')
Begin
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('a968bf6a-d9cb-4c45-9e47-869a65660230','AdjustmentUid',0,'Adjustments','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>AdjustmentUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Transaction Types</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListCreditType</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','901c4cf8-b458-489a-b9a7-c7d0764f05a6',6,0,0,'9/24/2019 7:00:00 PM') 
END
GO
------------------------------------------
--rollback tran;

update ListUserDefinedControlGroup 
set userdefined=0,
LastModifiedByUid=NULL,
LastModifiedDate='2019-09-25 00:00:00.000' 
where UserDefinedControlGroupUid='901C4CF8-B458-489A-B9A7-C7D0764F05A6';

update ListUserDefinedControl 
set userdefined=0,
LastModifiedByUid=NULL,
LastModifiedDate='2019-09-25 00:00:00.000' 
where UserDefinedControlGroupUid='901C4CF8-B458-489A-B9A7-C7D0764F05A6';

update ListUserDefinedControl
set ControlProperties='<UserDefinedControls>
  <Control>
    <ControlType>TIMESPAN</ControlType>
    <Name>AdjSummary</Name>
    <Uid>f2e52f89-7f2c-466a-a878-459f82fa12c9</Uid>
    <Required>TRUE</Required>
  </Control>
</UserDefinedControls>' 
where UserDefinedControluid='91DE6E0F-6FE9-4B4B-941D-C29A79974DF7'
GO

-- #26990  _Migration.sql
update listuserdefinedcontrol
set controlproperties='<UserDefinedControls>
  <Control>
    <ControlType>FIND</ControlType>
    <Name>PatientUid</Name>
    <SelectType>Single</SelectType>
    <Conjunction>none</Conjunction>
    <EntryNameInFindTable>Patient</EntryNameInFindTable>
    <ColumnName>Name</ColumnName>
    <ControlContextKey>Name</ControlContextKey>
    <FindTableName>ViewFindPatient</FindTableName>
	<Required>TRUE</Required>
  </Control>
</UserDefinedControls>'
where UserDefinedControlUid='D3D54D9F-B2A4-47BF-B708-83015E4770D5'
GO

-- #25907 Migration Script.sql
IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '92C45FCE-F173-4D18-89F6-40E82651EF91')--ResponsiblePartyOptions
BEGIN
Delete from ListUserDefinedControl where UserDefinedControlUid = '92C45FCE-F173-4D18-89F6-40E82651EF91'
END
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('92c45fce-f173-4d18-89f6-40e82651ef91','ResponsiblePartyOptions',0,'Responsible Party Option','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ResponsiblePartyOptions</Name><ButtonLabel>Person</ButtonLabel><ButtonValue>Person</ButtonValue><Default>false</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ResponsiblePartyOptions</Name><ButtonLabel>Corporation</ButtonLabel><ButtonValue>Corporation</ButtonValue><Default>false</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ResponsiblePartyOptions</Name><ButtonLabel>Both</ButtonLabel><ButtonValue>Both</ButtonValue><Default>true</Default></Control></Controls></UserDefinedControls>','11e5f2de-6899-44d5-be8d-d1eae88f1d86',0,0,0,'10/14/2019 7:00:00 PM')
END
GO

IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'A2AC9A04-04EE-4A0C-8A70-CA7C8857C0CE')--ZIP Codes
BEGIN
Delete from ListUserDefinedControl where UserDefinedControlUid = 'A2AC9A04-04EE-4A0C-8A70-CA7C8857C0CE'
END
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('a2ac9a04-04ee-4a0c-8a70-ca7c8857c0ce','ZipUID',0,'ZIP Codes','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ZipUID</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>ZIP Code</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListZip</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','11e5f2de-6899-44d5-be8d-d1eae88f1d86',1,0,0,'10/14/2019 7:00:00 PM')
END
GO

IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '4947363C-CD3F-4A05-AD3E-E28AE05448C8')--Primary Care Providers
BEGIN
Delete from ListUserDefinedControl where UserDefinedControlUid = '4947363C-CD3F-4A05-AD3E-E28AE05448C8'
END
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('4947363c-cd3f-4a05-ad3e-e28ae05448c8','PrimaryCareProviderUId',0,'Primary Care Providers','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>PrimaryCareProviderUId</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Provider</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewProvider</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','11e5f2de-6899-44d5-be8d-d1eae88f1d86',2,0,0,'10/14/2019 7:00:00 PM')
END
GO

IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '7776F930-1005-45D3-88CA-4DD2B46F3B85')--Include Inactive Responsible Parties
BEGIN
Delete from ListUserDefinedControl where UserDefinedControlUid = '7776F930-1005-45D3-88CA-4DD2B46F3B85'
END
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('7776f930-1005-45d3-88ca-4dd2b46f3b85','IncludeInactiveResponsibleParties',0,'Include Inactive Responsible Parties','71e67ced-b180-44e9-80c9-1ed3b47c9390','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>CHECKBOX</ControlType><Name>IncludeInactiveResponsibleParties</Name><CheckedText>true</CheckedText><UnCheckedText>false</UnCheckedText><CheckedByDefault>false</CheckedByDefault></Control></UserDefinedControls>','11e5f2de-6899-44d5-be8d-d1eae88f1d86',3,0,0,'10/14/2019 7:00:00 PM')
END
GO

IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'B8772E16-31F7-4A0E-8CA2-D3378F88EC6D')--Display Patients
BEGIN
Delete from ListUserDefinedControl where UserDefinedControlUid = 'B8772E16-31F7-4A0E-8CA2-D3378F88EC6D'
END
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('b8772e16-31f7-4a0e-8ca2-d3378f88ec6d','IncludePatients',0,'Display Patients','71e67ced-b180-44e9-80c9-1ed3b47c9390','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>CHECKBOX</ControlType><Name>IncludePatients</Name><CheckedText>true</CheckedText><UnCheckedText>false</UnCheckedText><CheckedByDefault>false</CheckedByDefault></Control></UserDefinedControls>','11e5f2de-6899-44d5-be8d-d1eae88f1d86',4,0,0,'10/14/2019 7:00:00 PM')
END
GO

IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'A2DFEE34-868D-4709-9CFD-EEA98DF016C1')--Include Inactive Patients
BEGIN
Delete from ListUserDefinedControl where UserDefinedControlUid = 'A2DFEE34-868D-4709-9CFD-EEA98DF016C1'
END
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('a2dfee34-868d-4709-9cfd-eea98df016c1','IncludeInactivePatients',0,'Include Inactive Patients','71e67ced-b180-44e9-80c9-1ed3b47c9390','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>CHECKBOX</ControlType><Name>IncludeInactivePatients</Name><CheckedText>true</CheckedText><UnCheckedText>false</UnCheckedText><CheckedByDefault>false</CheckedByDefault></Control></UserDefinedControls>','11e5f2de-6899-44d5-be8d-d1eae88f1d86',5,0,0,'10/14/2019 7:00:00 PM')
END
GO

IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'C6261A46-623B-4F76-AE58-82BF2B00263E')--Include Deceased Patients
BEGIN
Delete from ListUserDefinedControl where UserDefinedControlUid = 'C6261A46-623B-4F76-AE58-82BF2B00263E'
END
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('c6261a46-623b-4f76-ae58-82bf2b00263e','IncluceDeceasedPatients',0,'Include Deceased Patients','71e67ced-b180-44e9-80c9-1ed3b47c9390','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>CHECKBOX</ControlType><Name>IncluceDeceasedPatients</Name><CheckedText>true</CheckedText><UnCheckedText>false</UnCheckedText><CheckedByDefault>false</CheckedByDefault></Control></UserDefinedControls>','11e5f2de-6899-44d5-be8d-d1eae88f1d86',6,0,0,'10/14/2019 7:00:00 PM')
END
GO

IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '3DFD385A-D80D-4B0D-BF12-D05406A9E708')--Responsible Party Automated Collection Exclusion
BEGIN
Delete from ListUserDefinedControl where UserDefinedControlUid = '3DFD385A-D80D-4B0D-BF12-D05406A9E708'
END
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('3dfd385a-d80d-4b0d-bf12-d05406a9e708','ExcludeFromAutomatedCollections',0,'Responsible Party Automated Collection Exclusion','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ExcludeFromAutomatedCollections</Name><ButtonLabel>Show All</ButtonLabel><ButtonValue>All</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ExcludeFromAutomatedCollections</Name><ButtonLabel>Show Only Responsible Parties Excluded From Automated Collection Process</ButtonLabel><ButtonValue>Exclude</ButtonValue><Default>false</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ExcludeFromAutomatedCollections</Name><ButtonLabel>Show Only Responsible Parties Included In Automated Collection Process</ButtonLabel><ButtonValue>Include</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','11e5f2de-6899-44d5-be8d-d1eae88f1d86',7,0,0,'10/14/2019 7:00:00 PM')
END
GO

IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '1F24098D-E4A6-41AE-B287-31716C4F7F41')--Sort By
BEGIN
Delete from ListUserDefinedControl where UserDefinedControlUid = '1F24098D-E4A6-41AE-B287-31716C4F7F41'
END
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('1f24098d-e4a6-41ae-b287-31716c4f7f41','Sortby',0,'Sort By','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>Sortby</Name><ButtonLabel>Responsible Party Name</ButtonLabel><ButtonValue>R</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>Sortby</Name><ButtonLabel>Zip Code</ButtonLabel><ButtonValue>Z</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','11e5f2de-6899-44d5-be8d-d1eae88f1d86',8,0,0,'10/14/2019 7:00:00 PM')
END
GO

-- #156_PaymentApplication_Migration.sql
IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '6DE454F6-D8D2-4F98-BF7B-505992B4C62A')--Posting Dates
BEGIN
Delete from ListUserDefinedControl where UserDefinedControlUid = '6DE454F6-D8D2-4F98-BF7B-505992B4C62A'
End
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '6DE454F6-D8D2-4F98-BF7B-505992B4C62A')
Begin
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('6de454f6-d8d2-4f98-bf7b-505992b4c62a','Deposit',0,'Posting Dates','df87d0d5-bf48-49fb-abbc-cb75cc29eb64','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>Deposit</Name><Uid>b35a144b-b91e-4207-8e26-f7c9fcd06645</Uid><Required>FALSE</Required></Control></UserDefinedControls>','c8d056af-342a-4c4d-9f81-12cc63aed5eb',0,0,0,'10/16/2019 7:00:00 PM')
END
GO

IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '2E5EA18B-9510-4176-9AE2-07CC9184D5F8')--Providers
BEGIN
Delete from ListUserDefinedControl where UserDefinedControlUid = '2E5EA18B-9510-4176-9AE2-07CC9184D5F8'
End
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '2E5EA18B-9510-4176-9AE2-07CC9184D5F8')
Begin
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('2e5ea18b-9510-4176-9ae2-07cc9184d5f8','ProviderUid',0,'Providers','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProviderUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Provider</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewProvider</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','c8d056af-342a-4c4d-9f81-12cc63aed5eb',1,0,0,'10/16/2019 7:00:00 PM')
END
GO

IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'CB589B9C-7B30-4C95-9B61-BF3E23E6C476')--Type Of Providers
BEGIN
Delete from ListUserDefinedControl where UserDefinedControlUid = 'CB589B9C-7B30-4C95-9B61-BF3E23E6C476'
End
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'CB589B9C-7B30-4C95-9B61-BF3E23E6C476')
Begin
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('cb589b9c-7b30-4c95-9b61-bf3e23e6c476','ProviderOption',0,'Type Of Providers','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Billing Provider</ButtonLabel><ButtonValue>Billing Provider</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Rendering Provider</ButtonLabel><ButtonValue>Rendering Provider</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','c8d056af-342a-4c4d-9f81-12cc63aed5eb',2,0,0,'10/16/2019 7:00:00 PM')
END
GO

IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '8CBDF5B7-D13C-4B5B-A55D-27D76E13D7B8')--Service Sites
BEGIN
Delete from ListUserDefinedControl where UserDefinedControlUid = '8CBDF5B7-D13C-4B5B-A55D-27D76E13D7B8'
End
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '8CBDF5B7-D13C-4B5B-A55D-27D76E13D7B8')
Begin
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('8cbdf5b7-d13c-4b5b-a55d-27d76e13d7b8','ServiceSiteUid',0,'Service Sites','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ServiceSiteUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Service Site</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListServiceSite</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','c8d056af-342a-4c4d-9f81-12cc63aed5eb',3,0,0,'10/16/2019 7:00:00 PM')
END
GO

IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'B3BBB646-E159-480F-ACA9-684BD87E334A')--Financial Centers
BEGIN
Delete from ListUserDefinedControl where UserDefinedControlUid = 'B3BBB646-E159-480F-ACA9-684BD87E334A'
End
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'B3BBB646-E159-480F-ACA9-684BD87E334A')
Begin
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('b3bbb646-e159-480f-aca9-684bd87e334a','FinancialCenterUid',0,'Financial Centers','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>FinancialCenterUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Financial Center</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>FinancialCenter</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','c8d056af-342a-4c4d-9f81-12cc63aed5eb',4,0,0,'10/16/2019 7:00:00 PM')
END
GO

IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'E2D088F6-B91E-4122-A2DB-20573CC3D3F3')--Batches
BEGIN
Delete from ListUserDefinedControl where UserDefinedControlUid = 'E2D088F6-B91E-4122-A2DB-20573CC3D3F3'
End
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'E2D088F6-B91E-4122-A2DB-20573CC3D3F3')
Begin
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('e2d088f6-b91e-4122-a2db-20573cc3d3f3','BatchUid',0,'Batches','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>BatchUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Batch</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewARBatch</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','c8d056af-342a-4c4d-9f81-12cc63aed5eb',5,0,0,'10/16/2019 7:00:00 PM')
END
GO

IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '602F99A1-431E-48DE-9633-1CC65D79DFBA')--Deposits
BEGIN
Delete from ListUserDefinedControl where UserDefinedControlUid = '602F99A1-431E-48DE-9633-1CC65D79DFBA'
End
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '602F99A1-431E-48DE-9633-1CC65D79DFBA')
Begin
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('602f99a1-431e-48de-9633-1cc65d79dfba','DepositUid',0,'Deposits','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>DepositUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Deposit</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewDeposit</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','c8d056af-342a-4c4d-9f81-12cc63aed5eb',6,0,0,'10/16/2019 7:00:00 PM')
END
GO

IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'A979B5C3-0D3E-405B-B328-2E42F72A5C4D')--Payers
BEGIN
Delete from ListUserDefinedControl where UserDefinedControlUid = 'A979B5C3-0D3E-405B-B328-2E42F72A5C4D'
End
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'A979B5C3-0D3E-405B-B328-2E42F72A5C4D')
Begin
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('a979b5c3-0d3e-405b-b328-2e42f72a5c4d','PayerUid',0,'Payers','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>PayerUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Person/Corporation</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewPersonCorporation</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','c8d056af-342a-4c4d-9f81-12cc63aed5eb',7,0,0,'10/16/2019 7:00:00 PM')
END
GO

IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '3E922D67-2BF5-4327-81A0-28ADB636D2C2')--Procedures
BEGIN
Delete from ListUserDefinedControl where UserDefinedControlUid = '3E922D67-2BF5-4327-81A0-28ADB636D2C2'
End
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '3E922D67-2BF5-4327-81A0-28ADB636D2C2')
Begin
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('3e922d67-2bf5-4327-81a0-28adb636d2c2','ProcedureUid',0,'Procedures','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProcedureUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Procedure Code</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListProcedure</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','c8d056af-342a-4c4d-9f81-12cc63aed5eb',8,0,0,'10/16/2019 7:00:00 PM')
END
GO

IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '88ED5A9A-5E2F-4C8A-B813-7246C124DFB2')--Group Option
BEGIN
Delete from ListUserDefinedControl where UserDefinedControlUid = '88ED5A9A-5E2F-4C8A-B813-7246C124DFB2'
End
IF NOT EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '88ED5A9A-5E2F-4C8A-B813-7246C124DFB2')
Begin
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])VALUES('88ed5a9a-5e2f-4c8a-b813-7246c124dfb2','GroupOption',0,'Group Option','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>GroupOption</Name><ButtonLabel>Group By Financial Center</ButtonLabel><ButtonValue>Group By Financial Center</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>GroupOption</Name><ButtonLabel>Group By Provider</ButtonLabel><ButtonValue>Group By Provider</ButtonValue><Default>false</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>GroupOption</Name><ButtonLabel>Group by Service Site</ButtonLabel><ButtonValue>Group by Service Site</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','c8d056af-342a-4c4d-9f81-12cc63aed5eb',9,0,0,'10/16/2019 7:00:00 PM')
END
GO