BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'Account' AND COLUMN_NAME = 'Name')
ALTER TABLE [Account]  ALTER COLUMN [Name] varchar(255) NULL 
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_AccountResponsiblePartyCreditCardAuthorizationCache]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_AccountResponsiblePartyCreditCardAuthorizationCache](
	[AccountResponsiblePartyCreditCardAuthorizationCacheUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[AccountResponsiblePartyUid] [uniqueidentifier] NOT NULL,
	[MerchantId] [smallint] NOT NULL,
	[LastRefreshDate] [date] NOT NULL,
	[TotalAuthorizationAmount] [money] NOT NULL,
	[ConsentDetails] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]


ALTER TABLE [migtemp_AccountResponsiblePartyCreditCardAuthorizationCache] ADD  CONSTRAINT [DF_AccountResponsiblePartyCreditCardAuthorizationCache_MerchantId]  DEFAULT ((1)) FOR [MerchantId]

END
Truncate Table migtemp_AccountResponsiblePartyCreditCardAuthorizationCache
INSERT [migtemp_AccountResponsiblePartyCreditCardAuthorizationCache]([AccountResponsiblePartyCreditCardAuthorizationCacheUid],[AccountResponsiblePartyUid],[LastRefreshDate],[TotalAuthorizationAmount],[ConsentDetails],[LastModifiedDate],[LastModifiedByUid])
SELECT [AccountResponsiblePartyCreditCardAuthorizationCacheUid],[AccountResponsiblePartyUid],[LastRefreshDate],[TotalAuthorizationAmount],[ConsentDetails],[LastModifiedDate],[LastModifiedByUid]
FROM [AccountResponsiblePartyCreditCardAuthorizationCache]

DROP TABLE [AccountResponsiblePartyCreditCardAuthorizationCache]

exec  sp_rename 'migtemp_AccountResponsiblePartyCreditCardAuthorizationCache', 'AccountResponsiblePartyCreditCardAuthorizationCache'

exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[Appointment]') AND name = 'TelemedicineEncounter')
    ALTER TABLE [Appointment] ADD [TelemedicineEncounter] bit NOT NULL CONSTRAINT DF_Appointment_TelemedicineEncounter DEFAULT ((0)) 
exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ListCalendar' , N'SCHEMA',N'dbo', N'TABLE',N'Appointment', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.ListCalendar' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Appointment'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Patient' , N'SCHEMA',N'dbo', N'TABLE',N'Appointment', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.Patient' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Appointment'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Provider' , N'SCHEMA',N'dbo', N'TABLE',N'Appointment', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.Provider' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Appointment'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.RootTableOfNonAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'Appointment', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.RootTableOfNonAdminTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Appointment'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'ScheduleType' , N'SCHEMA',N'dbo', N'TABLE',N'Appointment', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'ScheduleType' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Appointment'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverOverrideValueIfValueSet' , N'SCHEMA',N'dbo', N'TABLE',N'Appointment', N'COLUMN',N'AppointmentStatusUid'))
EXEC sys.sp_dropextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Appointment', @level2type=N'COLUMN',@level2name=N'AppointmentStatusUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EnsureExternalId' , N'SCHEMA',N'dbo', N'TABLE',N'Appointment', N'COLUMN',N'ExternalID'))
EXEC sys.sp_dropextendedproperty @name=N'Replication.EnsureExternalId' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Appointment', @level2type=N'COLUMN',@level2name=N'ExternalID'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'oldname' , N'SCHEMA',N'dbo', N'TABLE',N'Appointment', N'COLUMN',N'CreatedDateTime'))
EXEC sys.sp_dropextendedproperty @name=N'oldname' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Appointment', @level2type=N'COLUMN',@level2name=N'CreatedDateTime'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.IgnoreConflictColumns' , N'SCHEMA',N'dbo', N'TABLE',N'Appointment', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.IgnoreConflictColumns', @value=N'AppointmentReplicationDataXml,ClipboardUserUid,TriggerOverride' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Appointment'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ListCalendar' , N'SCHEMA',N'dbo', N'TABLE',N'Appointment', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.ListCalendar', @value=N'FK_Appointment_ListCalendar;PatientUid=NULL' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Appointment'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Patient' , N'SCHEMA',N'dbo', N'TABLE',N'Appointment', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'{*FK_Appointment_Patient,FK_Appointment_Account,FK_RelGroupAppointmentPatient_Appointment}' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Appointment'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Provider' , N'SCHEMA',N'dbo', N'TABLE',N'Appointment', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.Provider', @value=N'FK_Appointment_Provider;PatientUid=NULL' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Appointment'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.RootTableOfNonAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'Appointment', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.RootTableOfNonAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Appointment'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'ScheduleType' , N'SCHEMA',N'dbo', N'TABLE',N'Appointment', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'ScheduleType', @value=N'<PatientVisit value="0" description="Patient Visit" /><Event value="1" description="Event" /><BlockingEvent value="2" description="Blocking Event" /><GroupVisit value="3" description="Group Visit" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Appointment'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverOverrideValueIfValueSet' , N'SCHEMA',N'dbo', N'TABLE',N'Appointment', N'COLUMN',N'AppointmentStatusUid'))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Appointment', @level2type=N'COLUMN',@level2name=N'AppointmentStatusUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverOverrideValueIfValueSet' , N'SCHEMA',N'dbo', N'TABLE',N'Appointment', N'COLUMN',N'CheckinDateTime'))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Appointment', @level2type=N'COLUMN',@level2name=N'CheckinDateTime'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverOverrideValueIfValueSet' , N'SCHEMA',N'dbo', N'TABLE',N'Appointment', N'COLUMN',N'DischargeDateTime'))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Appointment', @level2type=N'COLUMN',@level2name=N'DischargeDateTime'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverOverrideValueIfValueSet' , N'SCHEMA',N'dbo', N'TABLE',N'Appointment', N'COLUMN',N'ReferredbyProviderUid'))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Appointment', @level2type=N'COLUMN',@level2name=N'ReferredbyProviderUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverOverrideValueIfValueSet' , N'SCHEMA',N'dbo', N'TABLE',N'Appointment', N'COLUMN',N'ReferringDate'))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Appointment', @level2type=N'COLUMN',@level2name=N'ReferringDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverOverrideValueIfValueSet' , N'SCHEMA',N'dbo', N'TABLE',N'Appointment', N'COLUMN',N'CallConfirmStatusUid'))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Appointment', @level2type=N'COLUMN',@level2name=N'CallConfirmStatusUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverOverrideValueIfValueSet' , N'SCHEMA',N'dbo', N'TABLE',N'Appointment', N'COLUMN',N'CallConfirmStatusDetail'))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Appointment', @level2type=N'COLUMN',@level2name=N'CallConfirmStatusDetail'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EnsureExternalId' , N'SCHEMA',N'dbo', N'TABLE',N'Appointment', N'COLUMN',N'ExternalID'))
EXEC sys.sp_addextendedproperty @name=N'Replication.EnsureExternalId', @value=N'True' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Appointment', @level2type=N'COLUMN',@level2name=N'ExternalID'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'oldname' , N'SCHEMA',N'dbo', N'TABLE',N'Appointment', N'COLUMN',N'CreatedDateTime'))
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'CreatedDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Appointment', @level2type=N'COLUMN',@level2name=N'CreatedDateTime'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverOverrideValueIfValueSet' , N'SCHEMA',N'dbo', N'TABLE',N'Appointment', N'COLUMN',N'ReferralSrcUid'))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Appointment', @level2type=N'COLUMN',@level2name=N'ReferralSrcUid'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ASLVAdditionalInformation]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ASLVAdditionalInformation](
	[ASLVAdditionalInformationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[NotesHTML] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]


ALTER TABLE [ASLVAdditionalInformation] ADD  CONSTRAINT [DF_ASLVAdditionalInformation_ASLVAdditionalInformationUid]  DEFAULT (newid()) FOR [ASLVAdditionalInformationUid]
ALTER TABLE [ASLVAdditionalInformation] ADD  CONSTRAINT [DF_ASLVAdditionalInformation_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[atest]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[atest](
	[IntVal] [int] NOT NULL
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[btest]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[btest](
	[IntVal] [int] NULL
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ChartAccess' AND COLUMN_NAME = 'LastModifiedByUid')
ALTER TABLE [ChartAccess]  ALTER COLUMN [LastModifiedByUid] uniqueidentifier NULL 
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'EmailTracking' AND COLUMN_NAME = 'EmailName')
ALTER TABLE [EmailTracking]  ALTER COLUMN [EmailName] nvarchar(42) NULL 
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[FinancialCenter]') AND name = 'MerchantId')
    ALTER TABLE [FinancialCenter] ADD [MerchantId] varchar(16) NULL 
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[HighRiskDrugClass]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[HighRiskDrugClass](
	[HighRiskDrugClassUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_HighRiskDrugClass_HighRiskDrugClassUid]  DEFAULT (newid()),
	[ProviderUid] [uniqueidentifier] NULL,
	[AHFSClassID] [varchar](6) NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_HighRiskDrugClass_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'HighRiskDrugClass'


END
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[InsuranceCarrier]') AND name = 'InsuranceGroupUid')
    ALTER TABLE [InsuranceCarrier] DROP COLUMN [InsuranceGroupUid] 
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListAppointmentType]') AND name = 'UserDefined')
    ALTER TABLE [ListAppointmentType] ADD [UserDefined] tinyint NOT NULL CONSTRAINT DF_ListAppointmentType_UserDefined DEFAULT ((1)) 
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListCacheMachine]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListCacheMachine](
	[CacheMachineUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ID] [int] NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[URL] [varchar](255) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL,
	[ReplicationAppointmentHours] [int] NULL,
	[ReplicationAttachmentSizeKB] [int] NULL,
	[TriggerRemovePatientSeconds] [int] NULL,
	[ReplicationRemovePatientHours] [int] NULL,
	[TriggerReplicationSeconds] [int] NULL,
	[EnableLogging] [bit] NOT NULL,
	[Status] [varchar](max) NULL,
	[ReplicateEverything] [bit] NOT NULL,
	[ReplicationMode] [smallint] NOT NULL,
	[MaxRows] [int] NOT NULL,
	[YearsofPastDateOfServiceInstall] [int] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCacheMachine', @level2type=N'COLUMN',@level2name=N'ExternalID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'machine name' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCacheMachine', @level2type=N'COLUMN',@level2name=N'Name'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'IP address' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCacheMachine', @level2type=N'COLUMN',@level2name=N'URL'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCacheMachine', @level2type=N'COLUMN',@level2name=N'Notes'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Inactive flag' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCacheMachine', @level2type=N'COLUMN',@level2name=N'Inactive'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify Person' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCacheMachine', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify Time' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCacheMachine', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'machine in cache mode' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCacheMachine'
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCacheMachine'
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCacheMachine'
EXEC sys.sp_addextendedproperty @name=N'ReplicationMode', @value=N'<Normal value="0" />
<Pause value="1" />
<UploadOnly value="2" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCacheMachine'

ALTER TABLE [migtemp_ListCacheMachine] ADD  CONSTRAINT [DF_ListCacheMachine_CacheMachineUid]  DEFAULT (newid()) FOR [CacheMachineUid]
ALTER TABLE [migtemp_ListCacheMachine] ADD  CONSTRAINT [DF_ListCacheMachine_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [migtemp_ListCacheMachine] ADD  CONSTRAINT [DF_ListCacheMachine_EnableLogging]  DEFAULT ((0)) FOR [EnableLogging]
ALTER TABLE [migtemp_ListCacheMachine] ADD  CONSTRAINT [DF_ListCacheMachine_ReplicateEverything]  DEFAULT ((0)) FOR [ReplicateEverything]
ALTER TABLE [migtemp_ListCacheMachine] ADD  CONSTRAINT [DF_ListCacheMachine_ReplicationMode]  DEFAULT ((0)) FOR [ReplicationMode]
ALTER TABLE [migtemp_ListCacheMachine] ADD  CONSTRAINT [DF_ListCacheMachine_MaxRows_1]  DEFAULT ((5000)) FOR [MaxRows]
ALTER TABLE [migtemp_ListCacheMachine] ADD  CONSTRAINT [DF_ListCacheMachine_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_ListCacheMachine
INSERT [migtemp_ListCacheMachine]([CacheMachineUid],[ID],[ExternalID],[Name],[URL],[Notes],[Inactive],[ReplicationAppointmentHours],[ReplicationAttachmentSizeKB],[TriggerRemovePatientSeconds],[ReplicationRemovePatientHours],[TriggerReplicationSeconds],[EnableLogging],[Status],[ReplicateEverything],[ReplicationMode],[MaxRows],[LastModifiedByUid],[LastModifiedDate])
SELECT [CacheMachineUid],[ID],[ExternalID],[Name],[URL],[Notes],[Inactive],[ReplicationAppointmentHours],[ReplicationAttachmentSizeKB],[TriggerRemovePatientSeconds],[ReplicationRemovePatientHours],[TriggerReplicationSeconds],[EnableLogging],[Status],[ReplicateEverything],[ReplicationMode],[MaxRows],[LastModifiedByUid],[LastModifiedDate]
FROM [ListCacheMachine]

DROP TABLE [ListCacheMachine]

exec  sp_rename 'migtemp_ListCacheMachine', 'ListCacheMachine'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListDxTileConfiguration]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListDxTileConfiguration](
	[DxTileConfigurationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListDxTileConfiguration_DxTileConfigurationUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Range] [varchar](max) NULL,
	[DefaultWidth] [tinyint] NOT NULL CONSTRAINT [DF_ListDxTileConfiguration_DefaultWidth]  DEFAULT ((0)),
	[DefaultState] [bit] NOT NULL CONSTRAINT [DF_ListDxTileConfiguration_DefaultState]  DEFAULT ((0)),
	[DisplayByDefault] [bit] NOT NULL CONSTRAINT [DF_ListDxTileConfiguration_DisplayByDefault]  DEFAULT ((0)),
	[AutoSyncDxs] [bit] NOT NULL CONSTRAINT [DF_ListDxTileConfiguration_AutoSyncDxs]  DEFAULT ((0)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListDxTileConfiguration_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListDxTileConfiguration_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListDxTileConfiguration_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'DefaultWidth', @value=N'<Short value="0" /><Medium value="1" /><Long value="2" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListDxTileConfiguration'


END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListEventType]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListEventType](
	[EventTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListEventType_EventTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListEventType_Inactive]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListEventType_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListEventType_UserDefined]  DEFAULT ((1))
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListEventType'


END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListFindControlBehavior]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListFindControlBehavior](
	[FindControlBehaviorUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListFindControlBehavior_ListFindControlBehaviorUid]  DEFAULT (newid()),
	[ExternalId] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Id] [varchar](50) NULL,
	[ColumnsConfig] [varchar](max) NULL,
	[SearchColumns] [varchar](max) NULL,
	[RequiredSearchParameters] [varchar](max) NULL,
	[MinimumSearchCharacters] [int] NOT NULL CONSTRAINT [DF_ListFindControlBehavior_MinimumSearchCharacters]  DEFAULT ((3)),
	[MaxRows] [int] NOT NULL CONSTRAINT [DF_ListFindControlBehavior_MaxRows]  DEFAULT ((-1)),
	[BusinessObject] [varchar](max) NULL,
	[FindTableUid] [uniqueidentifier] NULL,
	[Prepopulate] [smallint] NOT NULL CONSTRAINT [DF_ListFindControlBehavior_PrepopulateFind]  DEFAULT ((0)),
	[HasSecurity] [bit] NOT NULL CONSTRAINT [DF_ListFindControlBehavior_HasSecurity]  DEFAULT ((0)),
	[AllowMaintenance] [bit] NOT NULL CONSTRAINT [DF_ListFindControlBehavior_AllowMaintenance]  DEFAULT ((1)),
	[AllowNew] [bit] NOT NULL CONSTRAINT [DF_ListFindControlBehavior_AllowNew]  DEFAULT ((1)),
	[AllowDelete] [smallint] NOT NULL CONSTRAINT [DF_LListFindControlBehavior_AllowDelete]  DEFAULT ((2)),
	[BeginningWildcard] [bit] NOT NULL CONSTRAINT [DF_ListFindControlBehavior_BeginningWildcard]  DEFAULT ((0)),
	[EndingWildcard] [bit] NOT NULL CONSTRAINT [DF_ListFindControlBehavior_EndingWildcard]  DEFAULT ((1)),
	[ServiceAQN] [varchar](max) NULL,
	[EndPoint] [varchar](max) NULL,
	[AuditTableName] [varchar](50) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListFindControlBehavior_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListFindControlBehavior_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListFindControlBehavior_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'JSON object descripting the column UI configuration.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFindControlBehavior', @level2type=N'COLUMN',@level2name=N'ColumnsConfig'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'JSON object descripting the search columns (database column name).' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFindControlBehavior', @level2type=N'COLUMN',@level2name=N'SearchColumns'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'JSON object descripting the required search columns.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFindControlBehavior', @level2type=N'COLUMN',@level2name=N'RequiredSearchParameters'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The minimum characters to type before executing the search. If zero the search must be forced.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFindControlBehavior', @level2type=N'COLUMN',@level2name=N'MinimumSearchCharacters'
EXEC sys.sp_addextendedproperty @name=N'AllowDelete', @value=N'<None value="0" />
<Delete value="1" />
<Merge value="2" />
' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFindControlBehavior'
EXEC sys.sp_addextendedproperty @name=N'Prepopulate', @value=N'<None value="0" />
<All value="1" />
<MFU_Frequency value="2" />
<MRU value="3" />
<MFU_Alpha value="4" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFindControlBehavior'
EXEC sys.sp_addextendedproperty @name=N'Replication.Cache.Required', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFindControlBehavior'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListFindControlBehavior'


END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListLockConcept]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListLockConcept](
	[LockConceptUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[UserDefined] [tinyint] NULL CONSTRAINT [DF_ListLockConcept_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_LockConcept_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListLockParentType]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListLockParentType](
	[LockParentTypeUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[UserDefined] [tinyint] NULL CONSTRAINT [DF_ListLockParentType_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_LockParentType_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListMacro]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListMacro](
	[MacroUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](200) NOT NULL,
	[Description] [varchar](max) NULL,
	[DataSource] [tinyint] NOT NULL,
	[DataContext] [tinyint] NOT NULL,
	[Text] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListMacro_UserDefined]  DEFAULT ((1)),
	[CreatedDateTime] [datetime] NOT NULL CONSTRAINT [DF_ListMacro_CreatedDateTime]  DEFAULT (getutcdate()),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListMacro_Inactive]  DEFAULT ((0)),
	[DataPropertyPath] [varchar](500) NULL,
	[MacroGroupUid] [uniqueidentifier] NOT NULL,
	[Goal] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListMacro_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'DataContext', @value=N'<Patient value="0" /><Visit value="1" /><None value="2" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListMacro'
EXEC sys.sp_addextendedproperty @name=N'DataSource', @value=N'<Client value="0" /><Server value="1" /><Both value="2" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListMacro'


END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListMacroDiagnosis]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListMacroDiagnosis](
	[MacroDiagnosisUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListMacroDiagnosis_MacroDiagnosisUid]  DEFAULT (newid()),
	[MacroUid] [uniqueidentifier] NOT NULL,
	[Code10] [varchar](25) NOT NULL,
	[CodeDescription] [varchar](512) NOT NULL,
	[LexicalCode] [int] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListMacroDiagnosis_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListMacroGroup]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListMacroGroup](
	[MacroGroupUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListMacroGroup_MacroGroupUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](500) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListMacroGroup_UserDefined]  DEFAULT ((1)),
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListMacroGroup_Inactive]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListMacroGroup_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListMacroProcedure]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListMacroProcedure](
	[MacroProcedureUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListMacroProcedure_MacroProcedureUid]  DEFAULT (newid()),
	[MacroUid] [uniqueidentifier] NOT NULL,
	[ProcedureUid] [uniqueidentifier] NOT NULL,
	[IsPerformed] [bit] NOT NULL CONSTRAINT [DF_ListMacroProcedure_IsPerformed]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListMacroProcedure_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListMedicationAction]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListMedicationAction](
	[MedicationActionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListMedicationAction_MedicationActionUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListMedicationAction_Inactive]  DEFAULT ((0)),
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_ListMedicationAction_DisplayOrder]  DEFAULT ((0)),
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListMedicationAction_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListMedicationAction_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListMedicationFrequency]') AND name = 'DescriptionUid')
    ALTER TABLE [ListMedicationFrequency] ADD [DescriptionUid] uniqueidentifier NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListMedicationFrequency]') AND name = 'RangeMinValue')
    ALTER TABLE [ListMedicationFrequency] ADD [RangeMinValue] int NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListMedicationFrequency]') AND name = 'RangeMaxValue')
    ALTER TABLE [ListMedicationFrequency] ADD [RangeMaxValue] int NULL 
exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'InstructionsType' , N'SCHEMA',N'dbo', N'TABLE',N'ListMedicationFrequency', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'InstructionsType' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListMedicationFrequency'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListMedicationFrequency', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.EMRAdminTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListMedicationFrequency'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'InstructionsType' , N'SCHEMA',N'dbo', N'TABLE',N'ListMedicationFrequency', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'InstructionsType', @value=N'<None value="0" description="None" /><Frequency value="1" description="Frequency" /><Interval value="2" description="Interval" /><RangeInterval value="3" description="RangeInterval" /><TimingEvent value="4" description="TimingEvent" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListMedicationFrequency'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'ListMedicationFrequency', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListMedicationFrequency'
GO
BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListMedicationRoute]') AND name = 'DescriptionUid')
    ALTER TABLE [ListMedicationRoute] ADD [DescriptionUid] uniqueidentifier NULL 
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListMedicationUnit]') AND name = 'NCItCode')
    ALTER TABLE [ListMedicationUnit] ADD [NCItCode] varchar(50) NULL 
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListNCPDPReasonCode]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListNCPDPReasonCode](
	[NCPDPReasonCodeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListNCPDPReasonCode_NCPDPReasonCodeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](50) NULL,
	[Code] [varchar](16) NOT NULL,
	[Description] [varchar](1024) NOT NULL,
	[ReasonCodeHierarchy] [int] NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListNCPDPReasonCode_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListNCPDPReasonCode_UserDefined]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListNCPDPReasonCode_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListNCPDPReasonCode'


END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListPayerTypologySource]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListPayerTypologySource](
	[PayerTypologySourceUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListPayerTypologySource_PayerTypologySourceUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Code] [varchar](10) NOT NULL,
	[Name] [varchar](255) NOT NULL,
	[Inactive] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListPayerTypologySource_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListPayerTypologySource_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]



END
Truncate Table migtemp_ListPayerTypologySource
INSERT [migtemp_ListPayerTypologySource]([PayerTypologySourceUid],[ExternalID],[Code],[Name],[Inactive],[UserDefined],[LastModifiedByUid],[LastModifiedDate])
SELECT [PayerTypologySourceUid],[ExternalID],[Code],[Name],[Inactive],[UserDefined],[LastModifiedByUid],[LastModifiedDate]
FROM [ListPayerTypologySource]

DROP TABLE [ListPayerTypologySource]

exec  sp_rename 'migtemp_ListPayerTypologySource', 'ListPayerTypologySource'

exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListPharmacy]') AND name = 'NCPDPID')
    ALTER TABLE [ListPharmacy] ADD [NCPDPID] varchar(35) NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListPharmacy]') AND name = 'DirectoryServiceXML')
    ALTER TABLE [ListPharmacy] ADD [DirectoryServiceXML] XML NULL 
exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ExcludeRowIfValueSet' , N'SCHEMA',N'dbo', N'TABLE',N'ListProductParameter', N'COLUMN',N'ParameterName'))
EXEC sys.sp_dropextendedproperty @name=N'Replication.ExcludeRowIfValueSet' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListProductParameter', @level2type=N'COLUMN',@level2name=N'ParameterName'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ExcludeRowIfValueSet' , N'SCHEMA',N'dbo', N'TABLE',N'ListProductParameter', N'COLUMN',N'ParameterName'))
EXEC sys.sp_addextendedproperty @name=N'Replication.ExcludeRowIfValueSet', @value=N'CommonDatabase;Update;Weekly Updates;Imo.StandaloneBaseUrl;Imo.StandaloneEnabled' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListProductParameter', @level2type=N'COLUMN',@level2name=N'ParameterName'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListTextEditor]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListTextEditor](
	[EditorUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](200) NOT NULL,
	[UserDefined] [bit] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListTextEditor_LastModifiedDate]  DEFAULT (getutcdate()),
	[PropertyPath] [varchar](max) NULL,
	[DataSource] [smallint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'DataSource', @value=N'<Patient value="0" /><Visit value="1" /><None value="2" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListTextEditor'


END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListUIConfiguration]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListUIConfiguration](
	[UIConfigurationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListUIConfiguration_UIConfigurationUid]  DEFAULT (newid()),
	[DataTypeId] [smallint] NOT NULL CONSTRAINT [DF_ListUIConfiguration_DataTypeId]  DEFAULT ((0)),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Data] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListUIConfiguration_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListUIConfiguration_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListUIConfiguration_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'DataTypeId', @value=N'<Unassigned value="0" /><FND value="1" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListUIConfiguration'


END
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[Lock]') AND name = 'IsLocked')
    ALTER TABLE [Lock] ADD [IsLocked] bit NOT NULL CONSTRAINT DF_Lock_IsLocked DEFAULT ((1)) 
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_MedicationSIG]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_MedicationSIG](
	[MedicationSIGUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_MedicationSIG_MedicationUid]  DEFAULT (newid()),
	[ProviderUid] [uniqueidentifier] NULL,
	[ProcedureUid] [uniqueidentifier] NULL,
	[DiscontinueReasonUid] [uniqueidentifier] NULL,
	[PharmacyUid] [uniqueidentifier] NULL,
	[EduFormUid] [uniqueidentifier] NULL,
	[SIGQuantityUnitOfMeasureUid] [uniqueidentifier] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[MedicationCategoryUid] [uniqueidentifier] NULL,
	[MedicationPRNReasonUid] [uniqueidentifier] NULL,
	[FDB_MEDID] [int] NOT NULL CONSTRAINT [DF_MedicationSIG_FDB_MEDID]  DEFAULT ((0)),
	[FDB_GCN_SEQNO] [int] NULL CONSTRAINT [DF_MedicationSIG_FDB_GCN_SEQNO]  DEFAULT ((0)),
	[FDB_HIC_SEQN] [int] NULL CONSTRAINT [DF_MedicationSIG_FDB_HIC_SEQN]  DEFAULT ((0)),
	[FDB_MNID] [int] NULL CONSTRAINT [DF_MedicationSIG_FDB_MNID]  DEFAULT ((0)),
	[FDB_CLASSID] [int] NULL CONSTRAINT [DF_MedicationSIG_FDB_CLASSID]  DEFAULT ((0)),
	[FDB_RMID] [int] NULL CONSTRAINT [DF_MedicationSIG_FDB_RMID]  DEFAULT ((0)),
	[RefillQuantity] [smallint] NULL,
	[Name] [varchar](255) NULL,
	[DrugName] [varchar](255) NULL,
	[FederalDEAClassCode] [varchar](50) NULL,
	[Strength] [varchar](255) NULL,
	[StrengthUnits] [varchar](255) NULL,
	[Route] [varchar](255) NULL,
	[OverallStartDate] [date] NULL,
	[OverallStopDate] [date] NULL,
	[DiscontinueRecordDate] [date] NULL,
	[DispenseAsWritten] [bit] NOT NULL CONSTRAINT [DF_MedicationSIG_DispenseAsWritten]  DEFAULT ((0)),
	[IsSampleGiven] [bit] NOT NULL CONSTRAINT [DF_MedicationSIG_IsSampleGiven]  DEFAULT ((0)),
	[IsMaintenanceDrug] [bit] NOT NULL CONSTRAINT [DF_MedicationSIG_IsMaintenanceDrug]  DEFAULT ((0)),
	[IsAdministered] [bit] NOT NULL CONSTRAINT [DF_MedicationSIG_IsAdministrered]  DEFAULT ((0)),
	[IsRefill] [bit] NOT NULL CONSTRAINT [DF_MedicationSIG_IsRefill]  DEFAULT ((0)),
	[IsRevised] [bit] NOT NULL CONSTRAINT [DF_MedicationSIG_IsRevised]  DEFAULT ((0)),
	[IsPRN] [bit] NOT NULL CONSTRAINT [DF_MedicationSIG_IsPRN]  DEFAULT ((0)),
	[IsHighRiskDrug] [bit] NOT NULL CONSTRAINT [DF_MedicationSIG_IsHighRisk]  DEFAULT ((0)),
	[FullTextSIG] [varchar](max) NULL,
	[AuthorCode] [varchar](40) NULL,
	[HxSource] [varchar](50) NULL,
	[HxSourceNotes] [varchar](max) NULL,
	[HxProvider] [varchar](100) NULL,
	[ReasonForOverrideScreening] [varchar](max) NULL,
	[DrugScreeningResult] [varchar](max) NULL,
	[LotNumber] [varchar](50) NULL,
	[MedicationMfrUid] [uniqueidentifier] NULL,
	[Initials] [varchar](25) NULL,
	[MedicationSiteUid] [uniqueidentifier] NULL,
	[MedicationFundingSourceUid] [uniqueidentifier] NULL,
	[ExpirationDate] [date] NULL,
	[VISDateGiven] [date] NULL,
	[VISDate] [date] NULL,
	[PatienteRxEligibilityUid] [uniqueidentifier] NULL,
	[NDC] [varchar](11) NULL,
	[RXNORMCode] [varchar](15) NULL,
	[RXNORMQualifier] [varchar](10) NULL,
	[AdministeredDateTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[MedicationConsentInfo] [xml](CONTENT [dbo].[MedicationConsentData]) NULL,
	[CreatedBy] [uniqueidentifier] NULL,
	[CreatedDateTime] [datetime] NULL CONSTRAINT [DF_MedicationSIG_CreatedDate]  DEFAULT (getutcdate()),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_MedicationSIG_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MedicationSIG_LastModifiedDate]  DEFAULT (getutcdate()),
	[BrandMedicallyNecessary] [bit] NOT NULL CONSTRAINT [DF_MedicationSIG_BrandMedicallyNecessary]  DEFAULT ((0))
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date and time an administered drug is given.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_MedicationSIG', @level2type=N'COLUMN',@level2name=N'AdministeredDateTime'
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'LastModifiedDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_MedicationSIG', @level2type=N'COLUMN',@level2name=N'CreatedDateTime'
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'{FK_RelPatientMedication_MedicationSIG,FK_RelVisitMedication_MedicationSIG,FK_VisitEduForm_MedicationSIG,FK_MedicationSIG_PatienteRxEligibility,FK_MedicationSIG_Visit}' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_MedicationSIG'


END
Truncate Table migtemp_MedicationSIG
INSERT [migtemp_MedicationSIG]([MedicationSIGUid],[ProviderUid],[ProcedureUid],[DiscontinueReasonUid],[PharmacyUid],[EduFormUid],[SIGQuantityUnitOfMeasureUid],[VisitUid],[MedicationCategoryUid],[MedicationPRNReasonUid],[FDB_MEDID],[FDB_GCN_SEQNO],[FDB_HIC_SEQN],[FDB_MNID],[FDB_CLASSID],[FDB_RMID],[RefillQuantity],[Name],[DrugName],[FederalDEAClassCode],[Strength],[StrengthUnits],[Route],[OverallStartDate],[OverallStopDate],[DiscontinueRecordDate],[DispenseAsWritten],[IsSampleGiven],[IsMaintenanceDrug],[IsAdministered],[IsRefill],[IsRevised],[IsPRN],[FullTextSIG],[AuthorCode],[HxSource],[HxSourceNotes],[HxProvider],[ReasonForOverrideScreening],[DrugScreeningResult],[LotNumber],[MedicationMfrUid],[Initials],[MedicationSiteUid],[MedicationFundingSourceUid],[ExpirationDate],[VISDateGiven],[VISDate],[PatienteRxEligibilityUid],[NDC],[RXNORMCode],[RXNORMQualifier],[AdministeredDateTime],[MedicationConsentInfo],[CreatedBy],[CreatedDateTime],[UserDefined],[LastModifiedByUid],[LastModifiedDate])
SELECT [MedicationSIGUid],[ProviderUid],[ProcedureUid],[DiscontinueReasonUid],[PharmacyUid],[EduFormUid],[SIGQuantityUnitOfMeasureUid],[VisitUid],[MedicationCategoryUid],[MedicationPRNReasonUid],[FDB_MEDID],[FDB_GCN_SEQNO],[FDB_HIC_SEQN],[FDB_MNID],[FDB_CLASSID],[FDB_RMID],[RefillQuantity],[Name],[DrugName],[FederalDEAClassCode],[Strength],[StrengthUnits],[Route],[OverallStartDate],[OverallStopDate],[DiscontinueRecordDate],[DispenseAsWritten],[IsSampleGiven],[IsMaintenanceDrug],[IsAdministered],[IsRefill],[IsRevised],[IsPRN],[FullTextSIG],[AuthorCode],[HxSource],[HxSourceNotes],[HxProvider],[ReasonForOverrideScreening],[DrugScreeningResult],[LotNumber],[MedicationMfrUid],[Initials],[MedicationSiteUid],[MedicationFundingSourceUid],[ExpirationDate],[VISDateGiven],[VISDate],[PatienteRxEligibilityUid],[NDC],[RXNORMCode],[RXNORMQualifier],[AdministeredDateTime],CONVERT(nvarchar(max), [MedicationConsentInfo]),[CreatedBy],[LastModifiedDate],[UserDefined],[LastModifiedByUid],[LastModifiedDate]
FROM [MedicationSIG]

DROP TABLE [MedicationSIG]

exec  sp_rename 'migtemp_MedicationSIG', 'MedicationSIG'

exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[Message]') AND name = 'EventTypeUid')
    ALTER TABLE [Message] ADD [EventTypeUid] uniqueidentifier NULL 
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[MessageAA]') AND name = 'SummaryOfCareReconciledDate')
    ALTER TABLE [MessageAA] DROP COLUMN [SummaryOfCareReconciledDate] 
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[Patient]') AND name = 'PatientStory')
    ALTER TABLE [Patient] ADD [PatientStory] varchar(max) NULL 
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_PatientCP_CarePlan]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_PatientCP_CarePlan](
	[PatientCP_CarePlanUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[CP_CarePlanUid] [uniqueidentifier] NULL,
	[CarePlanType] [smallint] NULL,
	[Name] [varchar](100) NULL,
	[Notes] [varchar](max) NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[IsDelete] [bit] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[CreatedDate] [date] NOT NULL,
	[CreatedDateTime] [datetime] NOT NULL,
	[InactiveDate] [date] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Marks a row "Deleted" without removing the row. The UI will show this row as struck-out.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientCP_CarePlan', @level2type=N'COLUMN',@level2name=N'IsDelete'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date the CarePlan was initially created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientCP_CarePlan', @level2type=N'COLUMN',@level2name=N'CreatedDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the (UTC) date and time the care plan was created' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientCP_CarePlan', @level2type=N'COLUMN',@level2name=N'CreatedDateTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The last date the row was updated or the date added.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientCP_CarePlan', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'CarePlanType', @value=N'<Default value="0" /><FND value="1" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientCP_CarePlan'

ALTER TABLE [migtemp_PatientCP_CarePlan] ADD  CONSTRAINT [DF_PatientCP_CarePlan_PatientCP_CarePlanUid]  DEFAULT (newid()) FOR [PatientCP_CarePlanUid]
ALTER TABLE [migtemp_PatientCP_CarePlan] ADD  CONSTRAINT [DF_PatientCP_CarePlan_IsDelete]  DEFAULT ((0)) FOR [IsDelete]
ALTER TABLE [migtemp_PatientCP_CarePlan] ADD  CONSTRAINT [DF_PatientCP_CarePlan_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [migtemp_PatientCP_CarePlan] ADD  CONSTRAINT [DF_PatientCP_CarePlan_CreatedDate]  DEFAULT (getutcdate()) FOR [CreatedDate]
ALTER TABLE [migtemp_PatientCP_CarePlan] ADD  CONSTRAINT [DF_PatientCP_CarePlan_CreatedDateTime]  DEFAULT (getutcdate()) FOR [CreatedDateTime]
ALTER TABLE [migtemp_PatientCP_CarePlan] ADD  CONSTRAINT [DF_PatientCP_CarePlan_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_PatientCP_CarePlan
INSERT [migtemp_PatientCP_CarePlan]([PatientCP_CarePlanUid],[PatientUid],[ProviderUid],[CP_CarePlanUid],[Name],[Notes],[VisitUid],[IsDelete],[Inactive],[CreatedDate],[CreatedDateTime],[InactiveDate],[LastModifiedByUid],[LastModifiedDate])
SELECT [PatientCP_CarePlanUid],[PatientUid],[ProviderUid],[CP_CarePlanUid],[Name],[Notes],[VisitUid],[IsDelete],[Inactive],[CreatedDate],[CreatedDateTime],[InactiveDate],[LastModifiedByUid],[LastModifiedDate]
FROM [PatientCP_CarePlan]

DROP TABLE [PatientCP_CarePlan]

exec  sp_rename 'migtemp_PatientCP_CarePlan', 'PatientCP_CarePlan'

exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'PatientDefaultVisitAccess' AND COLUMN_NAME = 'LastModifiedByUid')
ALTER TABLE [PatientDefaultVisitAccess]  ALTER COLUMN [LastModifiedByUid] uniqueidentifier NULL 
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PatientPersistentNoteHistory]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[PatientPersistentNoteHistory](
	[PatientPersistentNoteHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PatientPersistentNoteHistory_PatientPersistentNoteHistoryUid]  DEFAULT (newid()),
	[PatientUid] [uniqueidentifier] NOT NULL,
	[DataTypeId] [smallint] NOT NULL CONSTRAINT [DF_PatientPersistentNoteHistory_DataTypeId]  DEFAULT ((0)),
	[GroupingUid] [uniqueidentifier] NULL,
	[IsCurrentHistoryRow] [bit] NULL CONSTRAINT [DF_PatientPersistentNoteHistory_IsCurrentHistoryRow]  DEFAULT ((0)),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_PatientPersistentNoteHistory_IsDelete]  DEFAULT ((0)),
	[PPDHGroupingUid] [uniqueidentifier] NULL,
	[PPHGroupingUid] [uniqueidentifier] NULL,
	[NotesHTML] [varchar](max) NULL,
	[NotesRTF] [varchar](max) NULL,
	[ActiveDate] [date] NULL,
	[InactiveDate] [date] NULL,
	[Sequence] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PatientPersistentNoteHistory_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Is used to find all the history rows belonging to the IsCurrentHistoryRow row. The first row create for a new Patient Persistent Note History row’s PK will populate the value for the GroupingUid.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientPersistentNoteHistory', @level2type=N'COLUMN',@level2name=N'GroupingUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Marks the current active row in a PatientPersistentNoteHistory within the same GroupUid. Can be used to form a filter for returning rows.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientPersistentNoteHistory', @level2type=N'COLUMN',@level2name=N'IsCurrentHistoryRow'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Marks a row "Deleted" without removing the row. The UI will show this row as struck-out.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientPersistentNoteHistory', @level2type=N'COLUMN',@level2name=N'IsDelete'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Is a foreign key value of the GroupUid for table PatientProblemDiagnosisHistory.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientPersistentNoteHistory', @level2type=N'COLUMN',@level2name=N'PPDHGroupingUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Is a foreign key value of the GroupUid for table PatientProcedureHistory.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientPersistentNoteHistory', @level2type=N'COLUMN',@level2name=N'PPHGroupingUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Allows finding the history rows within the same GroupUid that are active. Can be used with InactiveDate and GroupUid to form a filter for returning rows.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientPersistentNoteHistory', @level2type=N'COLUMN',@level2name=N'ActiveDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Allows finding the history rows within the same GroupUid that are inactive. Can be used with ActiveDate and GroupUid to form a filter for returning rows.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientPersistentNoteHistory', @level2type=N'COLUMN',@level2name=N'InactiveDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Allows sorting the history rows within the same GroupUid in the order entered.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientPersistentNoteHistory', @level2type=N'COLUMN',@level2name=N'Sequence'
EXEC sys.sp_addextendedproperty @name=N'DataTypeId', @value=N'<Unassigned value="0" /><PatientStory value="1" /><ProblemDiagnosis value="2"/><ProcedureHistory value="3" /><Vitals value="4" /><CC value="5" /><HPI value="6" /><ROS value="7" /><PE value="8" /><ASLVSummary value="9" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientPersistentNoteHistory'


END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PDMPResponse]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[PDMPResponse](
	[PDMPResponseUid] [uniqueidentifier] NOT NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[ReportID] [varchar](max) NOT NULL,
	[CreatedDate] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NULL,
	[ServicedBy] [varchar](max) NULL
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PersistentMacroText]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[PersistentMacroText](
	[PersistentMacroTextUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_PersistentMacroText_PersistentMacroTextUid]  DEFAULT (newid()),
	[UserUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NULL,
	[EditorContext] [varchar](250) NOT NULL,
	[TextData] [varchar](max) NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PersistentMacroText_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.Cache.Required', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PersistentMacroText'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PersistentMacroText'
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Both' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PersistentMacroText'


END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_PersonContact]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_PersonContact](
	[PersonContactUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_PersonContact_PersonContactUid]  DEFAULT (newid()),
	[PersonUid] [uniqueidentifier] NOT NULL,
	[ContactPersonUid] [uniqueidentifier] NOT NULL,
	[ContactRelationshipUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_PersonContact_DisplayOrder]  DEFAULT ((0)),
	[EmergencyContact] [bit] NOT NULL CONSTRAINT [DF_PersonContact_EmergencyContact]  DEFAULT ((0)),
	[AuthorizedToMakeMedicalDecisions] [bit] NOT NULL CONSTRAINT [DF_PersonContact_AuthorizedToMakeMedicalDecisions]  DEFAULT ((0)),
	[AllowHIPAARelease] [smallint] NOT NULL CONSTRAINT [DF_PersonContact_AllowHIPAARelease_1]  DEFAULT ((0)),
	[HIPAARelease] [xml] NULL,
	[PowerOfAttorney] [bit] NOT NULL CONSTRAINT [DF_PersonContact_PowerOfAttorney]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_PersonContact_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Main person with contact.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonContact', @level2type=N'COLUMN',@level2name=N'PersonUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Contact.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonContact', @level2type=N'COLUMN',@level2name=N'ContactPersonUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Relationship of contact to main person.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonContact', @level2type=N'COLUMN',@level2name=N'ContactRelationshipUid'
EXEC sys.sp_addextendedproperty @name=N'AllowHIPAARelease', @value=N'<NA value="0" /><All value="1" /><Only value="2" /><Except value="3" /><None value="4" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonContact'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Contacts for a person. (Single directional.)' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonContact'
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'FK_PersonContact_Person' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonContact'


END
Truncate Table migtemp_PersonContact
INSERT [migtemp_PersonContact]([PersonContactUid],[PersonUid],[ContactPersonUid],[ContactRelationshipUid],[DisplayOrder],[EmergencyContact],[AuthorizedToMakeMedicalDecisions],[AllowHIPAARelease],[HIPAARelease],[Notes],[LastModifiedDate],[LastModifiedByUid])
SELECT [PersonContactUid],[PersonUid],[ContactPersonUid],[ContactRelationshipUid],[DisplayOrder],[EmergencyContact],[AuthorizedToMakeMedicalDecisions],[AllowHIPAARelease],CONVERT(nvarchar(max), [HIPAARelease]),[Notes],[LastModifiedDate],[LastModifiedByUid]
FROM [PersonContact]

DROP TABLE [PersonContact]

exec  sp_rename 'migtemp_PersonContact', 'PersonContact'

exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[PracticeSettings]') AND name = 'ReplicationYearsofPastDateOfServiceInstall')
    ALTER TABLE [PracticeSettings] ADD [ReplicationYearsofPastDateOfServiceInstall] int NULL 
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[Provider]') AND name = 'UseTelemedicine')
    ALTER TABLE [Provider] ADD [UseTelemedicine] bit NOT NULL CONSTRAINT DF_Provider_UseTelemedicine DEFAULT ((0)) 
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ProviderDefaultVisitAccess' AND COLUMN_NAME = 'LastModifiedByUid')
ALTER TABLE [ProviderDefaultVisitAccess]  ALTER COLUMN [LastModifiedByUid] uniqueidentifier NULL 
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ProviderDirectory]') AND name = 'HIN')
    ALTER TABLE [ProviderDirectory] ADD [HIN] varchar(255) NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ProviderDirectory]') AND name = 'CertificateToPrescribe')
    ALTER TABLE [ProviderDirectory] ADD [CertificateToPrescribe] varchar(255) NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ProviderDirectory]') AND name = 'REMSHealthcareProviderEnrollmentID')
    ALTER TABLE [ProviderDirectory] ADD [REMSHealthcareProviderEnrollmentID] varchar(255) NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ProviderDirectory]') AND name = 'StateControlSubstanceNumber')
    ALTER TABLE [ProviderDirectory] ADD [StateControlSubstanceNumber] varchar(255) NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ProviderDirectory]') AND name = 'Data2000WaiverID')
    ALTER TABLE [ProviderDirectory] ADD [Data2000WaiverID] varchar(255) NULL 
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[RelChargeTicketDiagnosis]') AND name = 'LexicalCode')
    ALTER TABLE [RelChargeTicketDiagnosis] ADD [LexicalCode] int NULL 
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelFindTableMFU]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelFindTableMFU](
	[RelFindTableMFUUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_RelFindTableMFU_RelFindTableMFUUid]  DEFAULT (newid()),
	[FindTableUid] [uniqueidentifier] NULL,
	[FindControlBehaviorUid] [uniqueidentifier] NULL,
	[UserUid] [uniqueidentifier] NOT NULL,
	[Uid] [uniqueidentifier] NOT NULL,
	[Count] [int] NOT NULL CONSTRAINT [DF_RelFindTableMFU_Count]  DEFAULT ((0)),
	[Exclude] [bit] NOT NULL CONSTRAINT [DF_RelFindTableMFU_Exclude]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelFindTableMFU_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.XferByUserSelectBy', @value=1 , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelFindTableMFU', @level2type=N'COLUMN',@level2name=N'UserUid'
EXEC sys.sp_addextendedproperty @name=N'Replication.Cache.Filter', @value=N'UserProviderUid="UserUid"' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelFindTableMFU'
EXEC sys.sp_addextendedproperty @name=N'Replication.Cache.Required', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelFindTableMFU'
EXEC sys.sp_addextendedproperty @name=N'Replication.IgnoreConflictColumns', @value=N'*' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelFindTableMFU'
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelFindTableMFU'
EXEC sys.sp_addextendedproperty @name=N'Replication.UserPRM', @value=N'FK_RelFindTableMFU_UserPRM' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelFindTableMFU'


END
Truncate Table migtemp_RelFindTableMFU
INSERT [migtemp_RelFindTableMFU]([RelFindTableMFUUid],[FindTableUid],[UserUid],[Uid],[Count],[Exclude],[LastModifiedByUid],[LastModifiedDate])
SELECT [RelFindTableMFUUid],[FindTableUid],[UserUid],[Uid],[Count],[Exclude],[LastModifiedByUid],[LastModifiedDate]
FROM [RelFindTableMFU]

DROP TABLE [RelFindTableMFU]

exec  sp_rename 'migtemp_RelFindTableMFU', 'RelFindTableMFU'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelFindTableMRU]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelFindTableMRU](
	[RelFindTableMRUUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_RelFindTableMRU_RelFindTableMRUUid]  DEFAULT (newid()),
	[FindTableUid] [uniqueidentifier] NULL,
	[FindControlBehaviorUid] [uniqueidentifier] NULL,
	[UserUid] [uniqueidentifier] NOT NULL,
	[Uid] [uniqueidentifier] NOT NULL,
	[MRUOrder] [int] NOT NULL CONSTRAINT [DF_Table_1_Count]  DEFAULT ((0)),
	[Exclude] [bit] NOT NULL CONSTRAINT [DF_RelFindTableMRU_Exclude]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelFindTableMRU_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.XferByUserSelectBy', @value=1 , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelFindTableMRU', @level2type=N'COLUMN',@level2name=N'UserUid'
EXEC sys.sp_addextendedproperty @name=N'Replication.Cache.Filter', @value=N'UserProviderUid="UserUid"' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelFindTableMRU'
EXEC sys.sp_addextendedproperty @name=N'Replication.Cache.Required', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelFindTableMRU'
EXEC sys.sp_addextendedproperty @name=N'Replication.IgnoreConflictColumns', @value=N'*' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelFindTableMRU'
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelFindTableMRU'
EXEC sys.sp_addextendedproperty @name=N'Replication.UserPRM', @value=N'FK_RelFindTableMRU_UserPRM' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelFindTableMRU'


END
Truncate Table migtemp_RelFindTableMRU
INSERT [migtemp_RelFindTableMRU]([RelFindTableMRUUid],[FindTableUid],[UserUid],[Uid],[MRUOrder],[Exclude],[LastModifiedByUid],[LastModifiedDate])
SELECT [RelFindTableMRUUid],[FindTableUid],[UserUid],[Uid],[MRUOrder],[Exclude],[LastModifiedByUid],[LastModifiedDate]
FROM [RelFindTableMRU]

DROP TABLE [RelFindTableMRU]

exec  sp_rename 'migtemp_RelFindTableMRU', 'RelFindTableMRU'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelLockParentTypeLockConcept]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelLockParentTypeLockConcept](
	[RelLockParentTypeLockConceptUid] [uniqueidentifier] NOT NULL,
	[LockParentTypeUid] [uniqueidentifier] NOT NULL,
	[LockConceptUid] [uniqueidentifier] NOT NULL,
	[UserDefined] [tinyint] NULL CONSTRAINT [DF_RelLockParentTypeLockConcept_UserDefined]  DEFAULT ((1)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelLockParentTypeLockConcept_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelMacroGroupUser]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelMacroGroupUser](
	[RelMacroGroupUserUid] [uniqueidentifier] NOT NULL,
	[MacroGroupUid] [uniqueidentifier] NOT NULL,
	[UserUid] [uniqueidentifier] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]


ALTER TABLE [RelMacroGroupUser] ADD  CONSTRAINT [DF_RelMacroGroupUser_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [RelMacroGroupUser] ADD  CONSTRAINT [DF_RelMacroGroupUser_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [RelMacroGroupUser] ADD  CONSTRAINT [DF_RelMacroGroupUser_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelMacroTextEditor]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelMacroTextEditor](
	[MacroEditorUid] [uniqueidentifier] NOT NULL,
	[MacroUid] [uniqueidentifier] NOT NULL,
	[EditorUid] [uniqueidentifier] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelMacroTextEditor_LastModifiedDate]  DEFAULT (getutcdate()),
	[UserDefined] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelObservationItemDxTileConfiguration]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelObservationItemDxTileConfiguration](
	[RelObservationItemDxTileConfigurationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelObservationItemDxTileConfiguration_RelObservationItemDxTileConfigurationUid]  DEFAULT (newid()),
	[DxTileConfigurationUid] [uniqueidentifier] NOT NULL,
	[ObservationItemUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelObservationItemDxTileConfiguration_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelObservationItemDxTileConfiguration_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The last date the row was updated or the date added.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelObservationItemDxTileConfiguration', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'


END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelPersonUIConfiguration]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelPersonUIConfiguration](
	[RelPersonUIConfigurationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[UIConfigurationUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_RelPersonUIConfiguration_UIConfigurationUid]  DEFAULT (newid()),
	[PersonUid] [uniqueidentifier] NULL,
	[UserGroupUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_RelPersonUIConfiguration_UserDefined]  DEFAULT ((1)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelPersonUIConfiguration_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelVisitMedication]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelVisitMedication](
	[RelVisitMedicationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelVisitMedication_RelVisitMedicationUid]  DEFAULT (newid()),
	[MedicationSIGUid] [uniqueidentifier] NOT NULL,
	[VisitUid] [uniqueidentifier] NOT NULL,
	[VisitProcedureUid] [uniqueidentifier] NULL,
	[eRxStatusUid] [uniqueidentifier] NULL,
	[eRxEligibilityDownLoadDate] [datetime] NULL,
	[ReadyToPrescribe] [bit] NOT NULL CONSTRAINT [DF_RelVisitMedication_ReadyToPrescribe]  DEFAULT ((0)),
	[Prescribed] [bit] NOT NULL CONSTRAINT [DF_RelVisitMedication_MarkAsPrescribed]  DEFAULT ((0)),
	[ConsentCreated] [bit] NOT NULL CONSTRAINT [DF_RelVisitMedication_ConsentCreated]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[ReprintReason] [varchar](max) NULL,
	[eRxRequest] [xml] NULL,
	[PreviousData] [xml](CONTENT [dbo].[PreviousData]) NULL,
	[DigitalSignatureXML] [xml] NULL,
	[FormularyXML] [xml](CONTENT [dbo].[FormularyData]) NULL,
	[FulfillmentMethod] [smallint] NOT NULL CONSTRAINT [DF_RelVisitMedication_FulfillmentMethod]  DEFAULT ((0)),
	[FulfillmentDateTime] [datetime] NULL,
	[FulfillmentSequentialNumber] [int] NULL,
	[ScriptSave] [bit] NULL CONSTRAINT [DF_RelVisitMedication_ScriptSave]  DEFAULT ((0)),
	[ePAStatus] [smallint] NOT NULL CONSTRAINT [DF_RelVisitMedication_ePASentRequest]  DEFAULT ((0)),
	[ePAMessageID] [varchar](50) NULL,
	[ePAResults] [varchar](max) NULL,
	[SpoStatus] [smallint] NOT NULL CONSTRAINT [DF_RelVisitMedication_SpoStatus]  DEFAULT ((0)),
	[SpoRequest] [varchar](max) NULL,
	[SpoResponse] [varchar](max) NULL,
	[Status] [tinyint] NOT NULL CONSTRAINT [DF_RelVisitMedication_Status]  DEFAULT ((0)),
	[StatusMessage] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelVisitMedication_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Type', @value=N'RelVisitMedicationeRxRequestData' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelVisitMedication', @level2type=N'COLUMN',@level2name=N'eRxRequest'
EXEC sys.sp_addextendedproperty @name=N'ePAStatus', @value=N'<None value ="0"/><Ready value="1"/><Sent value="2"/><Error value="3"/><Acknowledged value="4"/>' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelVisitMedication'
EXEC sys.sp_addextendedproperty @name=N'FulfillmentMethod', @value=N'<None value="0" /><ePrescribe value="1" /><Fax value="2" /><Print value="3" /><SampleGiven value="4" /><Administered value="5" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelVisitMedication'
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'FK_RelVisitMedication_Visit' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelVisitMedication'
EXEC sys.sp_addextendedproperty @name=N'SpoStatus', @value=N'<None value ="0"/><Ready value="1"/><Sent value="2"/><Error value="3"/><Acknowledged value="4"/>' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelVisitMedication'
EXEC sys.sp_addextendedproperty @name=N'Status', @value=N'<None value="0" /><Prescribed_Queued value="1" /><Prescribed_Sent value="2" /><Prescribed_Success value="3" /><Prescribed_Error value="4" /><Cancelled_Queued value="5" /><Cancelled_Sent value="6" /><Cancelled_Success value="7" /><Cancelled_Error value="8" /><PrintedOrFaxed value="9" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelVisitMedication'


END
Truncate Table migtemp_RelVisitMedication
INSERT [migtemp_RelVisitMedication]([RelVisitMedicationUid],[MedicationSIGUid],[VisitUid],[VisitProcedureUid],[eRxStatusUid],[eRxEligibilityDownLoadDate],[ReadyToPrescribe],[Prescribed],[ConsentCreated],[Notes],[ReprintReason],[eRxRequest],[PreviousData],[DigitalSignatureXML],[FormularyXML],[FulfillmentMethod],[FulfillmentDateTime],[FulfillmentSequentialNumber],[ScriptSave],[ePAStatus],[ePAMessageID],[ePAResults],[SpoStatus],[SpoRequest],[SpoResponse],[Status],[StatusMessage],[LastModifiedByUid],[LastModifiedDate])
SELECT [RelVisitMedicationUid],[MedicationSIGUid],[VisitUid],[VisitProcedureUid],[eRxStatusUid],[eRxEligibilityDownLoadDate],[ReadyToPrescribe],[Prescribed],[ConsentCreated],[Notes],[ReprintReason],CONVERT(nvarchar(max), [eRxRequest]),CONVERT(nvarchar(max), [PreviousData]),CONVERT(nvarchar(max), [DigitalSignatureXML]),CONVERT(nvarchar(max), [FormularyXML]),[FulfillmentMethod],[FulfillmentDateTime],[FulfillmentSequentialNumber],[ScriptSave],[ePAStatus],[ePAMessageID],[ePAResults],[SpoStatus],[SpoRequest],[SpoResponse],[Status],[StatusMessage],[LastModifiedByUid],[LastModifiedDate]
FROM [RelVisitMedication]

DROP TABLE [RelVisitMedication]

exec  sp_rename 'migtemp_RelVisitMedication', 'RelVisitMedication'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ReplicationStatus]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ReplicationStatus](
	[ReplicationStatusUid] [uniqueidentifier] NOT NULL,
	[InitialReplicationCompletedDate] [datetime] NULL,
	[LogonAt] [datetime] NULL,
	[ConnectionStatus] [varchar](max) NULL,
	[UploadStartAt] [datetime] NULL,
	[PatientsToUpload] [int] NULL,
	[MessagesToUpload] [int] NULL,
	[UploadPending] [int] NULL,
	[UploadFailures] [int] NULL,
	[UploadFailureDetail] [xml] NULL,
	[UploadTotal] [int] NULL,
	[UploadTableInProgress] [varchar](255) NULL,
	[LastCopiedObjectInUploadTableInProgress] [varchar](256) NULL,
	[UploadStatus] [varchar](max) NULL,
	[UploadProgressXML] [xml] NULL,
	[LastUploadCompletedFailures] [int] NULL,
	[LastUploadCompletedDate] [datetime] NULL,
	[DownloadStartAt] [datetime] NULL,
	[PatientsToDownload] [int] NULL,
	[MessagesToDownload] [int] NULL,
	[DownloadPending] [int] NULL,
	[DownloadFailures] [int] NULL,
	[DownloadFailureDetail] [xml] NULL,
	[DownloadTotal] [int] NULL,
	[DownloadTableInProgress] [varchar](255) NULL,
	[LastCopiedObjectInDownloadTableInProgress] [varchar](256) NULL,
	[DownloadStatus] [varchar](max) NULL,
	[DownloadProgressXML] [xml] NULL,
	[LastDownloadCompletedFailures] [int] NULL,
	[LastDownloadCompletedDate] [datetime] NULL,
	[MasterServerURI] [varchar](1024) NULL,
	[CacheServerURI] [varchar](1024) NULL,
	[ServerConfigXML] [xml] NULL,
	[FirstInstallDate] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ReplicationStatus'

ALTER TABLE [migtemp_ReplicationStatus] ADD  CONSTRAINT [DF_ReplicationStatus_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_ReplicationStatus
INSERT [migtemp_ReplicationStatus]([ReplicationStatusUid],[InitialReplicationCompletedDate],[LogonAt],[ConnectionStatus],[UploadStartAt],[PatientsToUpload],[MessagesToUpload],[UploadPending],[UploadFailures],[UploadFailureDetail],[UploadTotal],[UploadTableInProgress],[LastCopiedObjectInUploadTableInProgress],[UploadStatus],[UploadProgressXML],[LastUploadCompletedFailures],[LastUploadCompletedDate],[DownloadStartAt],[PatientsToDownload],[MessagesToDownload],[DownloadPending],[DownloadFailures],[DownloadFailureDetail],[DownloadTotal],[DownloadTableInProgress],[LastCopiedObjectInDownloadTableInProgress],[DownloadStatus],[DownloadProgressXML],[LastDownloadCompletedFailures],[LastDownloadCompletedDate],[MasterServerURI],[CacheServerURI],[ServerConfigXML],[LastModifiedByUid],[LastModifiedDate])
SELECT [ReplicationStatusUid],[InitialReplicationCompletedDate],[LogonAt],[ConnectionStatus],[UploadStartAt],[PatientsToUpload],[MessagesToUpload],[UploadPending],[UploadFailures],CONVERT(nvarchar(max), [UploadFailureDetail]),[UploadTotal],[UploadTableInProgress],[LastCopiedObjectInUploadTableInProgress],[UploadStatus],CONVERT(nvarchar(max), [UploadProgressXML]),[LastUploadCompletedFailures],[LastUploadCompletedDate],[DownloadStartAt],[PatientsToDownload],[MessagesToDownload],[DownloadPending],[DownloadFailures],CONVERT(nvarchar(max), [DownloadFailureDetail]),[DownloadTotal],[DownloadTableInProgress],[LastCopiedObjectInDownloadTableInProgress],[DownloadStatus],CONVERT(nvarchar(max), [DownloadProgressXML]),[LastDownloadCompletedFailures],[LastDownloadCompletedDate],[MasterServerURI],[CacheServerURI],CONVERT(nvarchar(max), [ServerConfigXML]),[LastModifiedByUid],[LastModifiedDate]
FROM [ReplicationStatus]

DROP TABLE [ReplicationStatus]

exec  sp_rename 'migtemp_ReplicationStatus', 'ReplicationStatus'

exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[SIGDetail]') AND name = 'Action')
    ALTER TABLE [SIGDetail] ADD [Action] varchar(255) NULL 
exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'CompletionStatus' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatchDetail', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'CompletionStatus' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatchDetail'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatchDetail', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatchDetail'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'OnDemand' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatchDetail', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'OnDemand' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatchDetail'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ToAvoid' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatchDetail', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.ToAvoid' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatchDetail'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'CompletionStatus' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatchDetail', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'CompletionStatus', @value=N'<None value="0" /><Printed value="1" /><PortalOnly value="2" /><Etactics value="3" /><PracticeInsight value="4" /><ClearGage value="5" /><Excluded value="99" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatchDetail'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatchDetail', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Individual responsible-party statements in a statement batch' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatchDetail'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'OnDemand' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatchDetail', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'OnDemand', @value=N'<None value="0" /><All value="1" /><MainAccountOnly value="2" />
' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatchDetail'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ToAvoid' , N'SCHEMA',N'dbo', N'TABLE',N'StatementBatchDetail', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.ToAvoid', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'StatementBatchDetail'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Superbill_TrackSuperbillStatusChange]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[Superbill_TrackSuperbillStatusChange](
	[SuperbillUid] [uniqueidentifier] NOT NULL,
	[FromSuperbillStatusUid] [uniqueidentifier] NOT NULL,
	[ToSuperbillStatusUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'Superbill_TrackSuperbillStatusChange'


END
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[VersionPRM]') AND name = 'BuildHash')
    ALTER TABLE [VersionPRM] ADD [BuildHash] varchar(50) NULL 
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[Visit]') AND name = 'VisitActionItem')
    ALTER TABLE [Visit] ADD [VisitActionItem] varchar(max) NULL 
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'VisitAccess' AND COLUMN_NAME = 'LastModifiedByUid')
ALTER TABLE [VisitAccess]  ALTER COLUMN [LastModifiedByUid] uniqueidentifier NULL 
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_VisitComment]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_VisitComment](
	[VisitCommentUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_VisitComment_VisitCommentUid]  DEFAULT (newid()),
	[VisitUid] [uniqueidentifier] NOT NULL,
	[CCComment] [varchar](max) NULL,
	[CCCommentHTML] [varchar](max) NULL,
	[HpiComment] [varchar](max) NULL,
	[HpiCommentHTML] [varchar](max) NULL,
	[RosComment] [varchar](max) NULL,
	[RosCommentHTML] [varchar](max) NULL,
	[PEComment] [varchar](max) NULL,
	[PECommentHTML] [varchar](max) NULL,
	[DXComment] [varchar](max) NULL,
	[DXCommentHTML] [varchar](max) NULL,
	[RXComment] [varchar](max) NULL,
	[RXCommentHTML] [varchar](max) NULL,
	[SPComment] [varchar](max) NULL,
	[SPCommentHTML] [varchar](max) NULL,
	[SOComment] [varchar](max) NULL,
	[SOCommentHTML] [varchar](max) NULL,
	[PhysicianComment] [varchar](max) NULL,
	[PhysicianCommentHTML] [varchar](max) NULL,
	[PlanComment] [varchar](max) NULL,
	[PlanCommentHTML] [varchar](max) NULL,
	[EduFormComment] [varchar](max) NULL,
	[EduFormCommentHTML] [varchar](max) NULL,
	[PatientInstruction] [varchar](max) NULL,
	[PatientInstructionHTML] [varchar](max) NULL,
	[VitalComment] [varchar](max) NULL,
	[VitalCommentHTML] [varchar](max) NULL,
	[VisitComment] [varchar](max) NULL,
	[VisitCommentHTML] [varchar](max) NULL,
	[GeneralComment] [varchar](max) NULL,
	[GeneralCommentHTML] [varchar](max) NULL,
	[DSTComment] [varchar](max) NULL,
	[DSTCommentHTML] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_VisitComment_DisplayOrder]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_VisitComment_LastModifiedDate]  DEFAULT (getutcdate()),
	[VisitTypeComment] [varchar](max) NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Primary Key' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitComment', @level2type=N'COLUMN',@level2name=N'VisitCommentUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'visit id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitComment', @level2type=N'COLUMN',@level2name=N'VisitUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'CC comment' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitComment', @level2type=N'COLUMN',@level2name=N'CCComment'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Hpi comment' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitComment', @level2type=N'COLUMN',@level2name=N'HpiComment'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'ROS Comment' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitComment', @level2type=N'COLUMN',@level2name=N'RosComment'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Physical Exam Comment' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitComment', @level2type=N'COLUMN',@level2name=N'PEComment'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Diagnosis Comment' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitComment', @level2type=N'COLUMN',@level2name=N'DXComment'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Prescription Comment' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitComment', @level2type=N'COLUMN',@level2name=N'RXComment'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Service Perform Comment' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitComment', @level2type=N'COLUMN',@level2name=N'SPComment'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Service Order Comment' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitComment', @level2type=N'COLUMN',@level2name=N'SOComment'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'physician comment' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitComment', @level2type=N'COLUMN',@level2name=N'PhysicianComment'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'edu form comment' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitComment', @level2type=N'COLUMN',@level2name=N'EduFormComment'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'patient review instruction' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitComment', @level2type=N'COLUMN',@level2name=N'PatientInstruction'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'DisplayOrder' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitComment', @level2type=N'COLUMN',@level2name=N'DisplayOrder'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'last modify person id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitComment', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'last modify date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitComment', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'visit comment' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitComment'


END
Truncate Table migtemp_VisitComment
INSERT [migtemp_VisitComment]([VisitCommentUid],[VisitUid],[CCComment],[HpiComment],[RosComment],[PEComment],[DXComment],[RXComment],[SPComment],[SOComment],[PhysicianComment],[PlanComment],[EduFormComment],[PatientInstruction],[VitalComment],[VisitComment],[GeneralComment],[DisplayOrder],[LastModifiedByUid],[LastModifiedDate],[VisitTypeComment])
SELECT [VisitCommentUid],[VisitUid],[CCComment],[HpiComment],[RosComment],[PEComment],[DXComment],[RXComment],[SPComment],[SOComment],[PhysicianComment],[PlanComment],[EduFormComment],[PatientInstruction],[VitalComment],[VisitComment],[GeneralComment],[DisplayOrder],[LastModifiedByUid],[LastModifiedDate],[VisitTypeComment]
FROM [VisitComment]

DROP TABLE [VisitComment]

exec  sp_rename 'migtemp_VisitComment', 'VisitComment'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_VisitDiagnosis]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_VisitDiagnosis](
	[VisitDiagnosisUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_VisitDiagnosis_RowGuid]  DEFAULT (newid()),
	[VisitUid] [uniqueidentifier] NOT NULL,
	[DiagnosisPanelUid] [uniqueidentifier] NULL,
	[ProblemGroupingUid] [uniqueidentifier] NULL,
	[PatientProblemDiagnosisHistoryUid] [uniqueidentifier] NULL,
	[Code] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[Name] [varchar](255) NULL,
	[Notes] [varchar](max) NULL,
	[NotesHTML] [varchar](max) NULL,
	[DxPlanHTML] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL CONSTRAINT [DF_VisitDiagnosis_DisplayOrder]  DEFAULT ((0)),
	[SnomedCTConceptId] [bigint] NULL,
	[FollowupFlag] [smallint] NULL,
	[VisitDiagnosisType] [smallint] NULL,
	[AddendumNotes] [varchar](max) NULL,
	[DSMAxis] [varchar](250) NULL,
	[DpnGroupUid] [uniqueidentifier] NULL,
	[DpnXml] [xml] NULL,
	[HccCommunityFactors] [decimal](4, 3) NULL,
	[LifeLong] [bit] NOT NULL CONSTRAINT [DF_VisitDiagnosis_LifeLong]  DEFAULT ((0)),
	[SortToBottom] [bit] NOT NULL CONSTRAINT [DF_VisitDiagnosis_SortToBottom]  DEFAULT ((0)),
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_VisitDiagnosis_IsDelete]  DEFAULT ((0)),
	[IsAddendum] [bit] NOT NULL CONSTRAINT [DF_VisitDiagnosis_IsAddendum]  DEFAULT ((0)),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_VisitDiagnosis_LastModifiedDate]  DEFAULT (getutcdate()),
	[HccModelCat] [int] NULL,
	[LexicalCode] [int] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'visit id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis', @level2type=N'COLUMN',@level2name=N'VisitUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Used to indicate the related problem. A method in the busniess object can be used to get the related problem.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis', @level2type=N'COLUMN',@level2name=N'ProblemGroupingUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis', @level2type=N'COLUMN',@level2name=N'Notes'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1:improve; 2:worsen; 3: unchange; 4: resolve' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis', @level2type=N'COLUMN',@level2name=N'FollowupFlag'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1 - Differential, 2 - PreOp, 3 - PostOp' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis', @level2type=N'COLUMN',@level2name=N'VisitDiagnosisType'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'mark 1 when user delete this record in complete note' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis', @level2type=N'COLUMN',@level2name=N'IsDelete'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'last modify person id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'last modify date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'visit chart detail information for Diagnosis' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis'
EXEC sys.sp_addextendedproperty @name=N'VisitDiagnosisType', @value=N'<None value="0"/><Differential value="1" /><PreOp value="2"/><PostOp value="3" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis'


END
Truncate Table migtemp_VisitDiagnosis
INSERT [migtemp_VisitDiagnosis]([VisitDiagnosisUid],[VisitUid],[DiagnosisPanelUid],[ProblemGroupingUid],[PatientProblemDiagnosisHistoryUid],[Code],[Code10],[Name],[Notes],[DisplayOrder],[SnomedCTConceptId],[FollowupFlag],[VisitDiagnosisType],[AddendumNotes],[DSMAxis],[DpnGroupUid],[DpnXml],[HccCommunityFactors],[LifeLong],[SortToBottom],[IsDelete],[IsAddendum],[LastModifiedByUid],[LastModifiedDate],[HccModelCat],[LexicalCode])
SELECT [VisitDiagnosisUid],[VisitUid],[DiagnosisPanelUid],[ProblemGroupingUid],[PatientProblemDiagnosisHistoryUid],[Code],[Code10],[Name],[Notes],[DisplayOrder],[SnomedCTConceptId],[FollowupFlag],[VisitDiagnosisType],[AddendumNotes],[DSMAxis],[DpnGroupUid],CONVERT(nvarchar(max), [DpnXml]),[HccCommunityFactors],[LifeLong],[SortToBottom],[IsDelete],[IsAddendum],[LastModifiedByUid],[LastModifiedDate],[HccModelCat],[LexicalCode]
FROM [VisitDiagnosis]

DROP TABLE [VisitDiagnosis]

exec  sp_rename 'migtemp_VisitDiagnosis', 'VisitDiagnosis'

exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[IMO_ProblemIT_Custom]') AND type in (N'U'))
DROP TABLE [IMO_ProblemIT_Custom]
COMMIT TRAN

GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[IMO_ProblemIT_Custom_Word_Index]') AND type in (N'U'))
DROP TABLE [IMO_ProblemIT_Custom_Word_Index]
COMMIT TRAN

GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[IMO_ProblemIT_SearchQualifier]') AND type in (N'U'))
DROP TABLE [IMO_ProblemIT_SearchQualifier]
COMMIT TRAN

GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[IMO_ProblemIT_SearchResult]') AND type in (N'U'))
DROP TABLE [IMO_ProblemIT_SearchResult]
COMMIT TRAN

GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[ListInsuranceGroup]') AND type in (N'U'))
DROP TABLE [ListInsuranceGroup]
COMMIT TRAN

GO


