-- #16787 Performance:  AprimaVault Downloader
--disable all Nitor partners
update ListIntegrationPartner set Inactive = 1 where name in (
'Nitor With Certificate Direct Message Service',
'Nitor Test With Certificate Direct Message Service',
'Nitor Direct Message Service',
'Nitor TEST Direct Message Service')
and Inactive = 0
GO


/*
	BUG 17131 - Migration Issue - Insurance Group in List Editor -> Demographics need to be removed.  Not Showing on New Databases
	2019-02-14	BRoy	Remove Row From ListFindTable
*/
DELETE FROM ListFindTable
	WHERE FindTableUid = '16428A81-EDA0-4347-8043-8836E4433E12'
		AND ID = 'ListInsuranceGroup';
GO

-- #18681-AprimaVaultSenderJob.sql
UPDATE JobSchedule
SET MethodParams = '<MethodParametersData><MaxRows>100</MaxRows><TimeOutForLoopException>10</TimeOutForLoopException></MethodParametersData>'
WHERE JobScheduleUid = 'A693F43A-8F99-4B9E-9519-577B988A752D'
  AND MethodParams IS NULL
GO

-- #17116 Migration_UpdateIntegrationPartner.sql
update ListIntegrationPartner
set Name = 'Chiron', FieldsEditorControlAQN = 'iMedica.Prm.Client.UI.PrmGeneralControls.Edit.Integration.ControlChironCredentials,iMedica.Prm.Client.UI', AdditionalOutboundXML = null, inactive = 1, userdefined = 0
where IntegrationPartnerUid = 'E3216EE9-E376-47A2-A416-4C7AC4E2B691'
GO

-- #18971_UpdateListIntegrationPartner.sql
DECLARE @TestFlag bit, @Number varchar(20), @TestMode varchar(9) = 0
select @TestFlag = BoolValue from ListProductParameter where ParameterName = 'RegistrationCustomerLicense'
select @Number = StringValue from ListProductParameter where ParameterName = 'RegistrationCustomerNumber'

IF(@TestFlag = 1
OR @Number like 'test' -- regular test database license
OR @Number like '000%' -- dev test database license 
OR @Number like '888%' -- QA test database licenses
)
BEGIN
update listintegrationpartner
set additionaloutboundxml = '<settings corepointTestBaseUrl="https://integration.aprima.com/REST/RXCoupon" corepointProdBaseUrl="https://integration.aprima.com/REST/RXCoupon" portalTestBaseUrl="https://stage.samplemd.com/samplemd/resources/getResource/61/" portalProdBaseUrl="https://www.samplemd.com/samplemd/resources/getResource/61/">
  <AutoPrintOptOut />
  <PortalOptOut />
</settings>'
where integrationpartneruid = '4ABFF2CF-606F-4A2A-9C45-71055B94C36E'
END
GO

-- #19758 Migration_ChironIntegration_Partner_Settings.sql
update ListIntegrationPartner
set AdditionalOutboundXML = '<ChironCredentials>
  <OrganizationUrl>https://org.chironhealth.com</OrganizationUrl>
  <AuthenticationUrl>https://auth.chironhealth.com</AuthenticationUrl>
  <SSOUrl>https://oem-client.chironhealth.com</SSOUrl>
  <ClientId></ClientId>
  <ClientSecret></ClientSecret>
</ChironCredentials>', ConsentRequired = 1
where IntegrationPartnerUid = 'E3216EE9-E376-47A2-A416-4C7AC4E2B691'
GO

-- #19597 Migration_ChironIntegration_Partner_Settings.sql
update ListIntegrationPartner
set AdditionalOutboundXML = '<ChironCredentials>
  <CorepointUrl>https://cpdev01.aprima.corp:32115</CorepointUrl>
  <SSOUrl>https://oem-client.chironhealth.com</SSOUrl>
  <ClientId></ClientId>
  <ClientSecret></ClientSecret>
</ChironCredentials>', ConsentRequired = 1
where IntegrationPartnerUid = 'E3216EE9-E376-47A2-A416-4C7AC4E2B691'

-- #19900_UpdateListMedicationFrequencyTIW.sql  changed 8/5/19
update ListMedicationFrequency
set PatientInstructions = 'four times a day', DosesPerDay= 4
where MedicationFrequencyUid = '8A4CB0BA-D1B8-4241-A6E8-15583AAC252F'

update ListMedicationFrequency
set PatientInstructions = 'three times a day', DosesPerDay= 3
where MedicationFrequencyUid = '4CABC388-F13C-4382-97E0-5339308BB957'

update ListMedicationFrequency
set PatientInstructions = 'two times a day', DosesPerDay= 2
where MedicationFrequencyUid = 'FC88C21E-D187-484B-A82C-8F6C252A472C'

update ListMedicationFrequency
set PatientInstructions = 'quantity sufficient'
where MedicationFrequencyUid = 'DA75CC5E-80CA-4F6F-AF64-6D07C49F3549'

update ListMedicationFrequency
set PatientInstructions = 'three times per week'
where MedicationFrequencyUid = '48C42B93-2645-4C5A-989D-01175A05CB7F'
GO

-- #21546 Surescripts v6 
DECLARE @TransmissionConfigurationUid [uniqueidentifier] = 'B0484716-EA09-4EB3-BA50-CBD352D4351F' -- PRVUPD::Prescriber Download
	, @LastModifiedDate [datetime] = '2019-06-18 23:09:54.230'

UPDATE [TransmissionConfiguration]
	SET [ExportXMLLayout] = 'PrescriberDirectoryDownload_V6R1.eRxService'
		, [CorepointDownloadProcessorAQN] = 'iMedica.Framework.eRxCorepoint.Transmission.PrescriberDownloadProcessor_V6R1, eRxCorepoint'
		, [LastModifiedDate] = @LastModifiedDate
where [TransmissionConfigurationUid] = @TransmissionConfigurationUid
	AND [ExportXMLLayout] <> 'PrescriberDirectoryDownload_V6R1.eRxService'

SET @TransmissionConfigurationUid = 'D375FB2C-454F-4175-A253-6A382028FB0A' -- INBOUND
UPDATE [TransmissionConfiguration]
	SET [CorepointDownloadProcessorAQN] = 'iMedica.Framework.eRxCorepoint.Transmission.eRxInboundMessageDownloadProcessor_V6R1, eRxCorepoint'
		, [LastModifiedDate] = @LastModifiedDate
WHERE [TransmissionConfigurationUid] = @TransmissionConfigurationUid
	AND [CorepointDownloadProcessorAQN] <> 'iMedica.Framework.eRxCorepoint.Transmission.eRxInboundMessageDownloadProcessor_V6R1, eRxCorepoint'
GO 

-- #21547 Surescripts v6 
DECLARE @PharmacyClearinghouseUid [uniqueidentifier] = '118422AA-C165-4A2E-8389-E5B7E89636EA'
	, @AssemblyQualifiedName [varchar](512) = 'iMedica.Framework.eRx.SureScripts.SureScriptsProcessor_V24, eRx'
	, @LastModifiedDate [datetime] = '2019-06-22 13:43:28.503'

UPDATE [ListPharmacyClearinghouse]
	SET [AssemblyQualifiedName] = @AssemblyQualifiedName
		, [LastModifiedDate] = @LastModifiedDate
WHERE [PharmacyClearinghouseUid] = @PharmacyClearinghouseUid
	AND [AssemblyQualifiedName] <> @AssemblyQualifiedName

UPDATE [ListeRxMessageType]
	SET [ProcessInboundAQN] = 'FrameworkBO.Util.Surescripts.ProcessPharmacyUpdate_V24, FrameworkBO'
		, [LastModifiedDate] = @LastModifiedDate
WHERE [ProcessInboundAQN] = 'iMedica.Framework.eRx.SureScripts.ProcessPharmacyUpdate_V20, eRx'
GO

-- #20780 Surescripts V6R1
DECLARE @LastModifiedDate [datetime] = '2019-07-15 17:16:01.300'

UPDATE [TransmissionConfiguration]
	SET [TestRegistrationURL] = 'https://cpdev01.aprima.corp:40015/communityexchange/partner/PartnerService'
		, [LastModifiedDate] = @LastModifiedDate
WHERE [TransmissionType] = 'RXHREQ'
	AND [TestRegistrationURL] = 'https://tiran.aprima.corp:8443/communityexchange/partner/PartnerService'

UPDATE [TransmissionConfiguration]
	SET [CorepointMachineID] = 'eMedicationHistory_V6R1.eRxService'
		, [ExportXMLLayout] = 'eMedicationHistoryRequest_V6R1.eRxService'
		, [CorepointDownloadProcessorAQN] = 'iMedica.Framework.eRxCorepoint.Transmission.eMedicationHistoryCorepointDownloadProcessor_V6R1, eRxCorepoint'
		, [LastModifiedDate] = @LastModifiedDate
WHERE [TransmissionType] = 'RXHREQ'
	AND [CorepointMachineID] = 'eMedicationHistory.eRxService'

UPDATE [ListeRxMessageType]
	SET [ProcessInboundAQN] = 'iMedica.Framework.eRx.ProcessInboundXML_V24, eRx'
		, [LastModifiedDate] = @LastModifiedDate
WHERE [ExternalID] = 'ELGRES'
	AND [ProcessInboundAQN] = 'iMedica.Framework.eRx.ProcessInboundXML, eRx'
GO	

-- #22524 Surescripts V6
DECLARE @Columns[varchar](max) = '<FindColumn name="eRxSentDateTime" caption="Sent Date Time" index="eRxSentDateTime" visible="true" width="50" datatype="datetime" />
<FindColumn name="Patient" caption="Patient" visible="true" width="120" />
<FindColumn name="Provider" caption="Provider" visible="true" width="120" />
<FindColumn name="SendResponse" caption="Note" visible="true" relwidth="200" width="200" />
<FindColumn name="ClearingHouse" caption="Clearing House" visible="true" width="140" />
<FindColumn name="RequestDateFrom" caption="Request Date From" index="RequestDateFrom" visible="false" width="50" datatype="date" />
<FindColumn name="RequestDateTo" caption="Request Date To" index="RequestDateTo" visible="false" width="50" datatype="date" />
<FindColumn name="eRxMedicationHistoryOutboundUid" visible="false" caption="Guid" index="guid" />
<FindColumn name="eRxMessageType" caption="Message Type" visible="false" width="40" />
<FindColumn name="eRxMessageID" caption="Message ID" visible="true" width="40" />'
UPDATE [ListFindTable]
	SET [Columns] = @Columns
WHERE [FindTableUid] = 'D67273CE-BE73-4267-8E16-1970BACAF36D'
	AND CAST([Columns] AS [varchar](max)) <> @Columns

DELETE [JobSchedule]
WHERE [JobScheduleUid] = '54556FEE-0696-4C52-A4E3-4E9D4E9A3FB3'

DELETE [ListJob]
WHERE [JobUid] = '160C2F70-EFD0-476A-8CA9-8A97340AF073'
GO

-- #19900 19900_UpdateListMedicationFrequencyTIW.sql
update ListMedicationFrequency
set PatientInstructions = 'three times per week'
where MedicationFrequencyUid = '48C42B93-2645-4C5A-989D-01175A05CB7F'
GO

-- #23088 23088_MigrationScript.sql
update ListUIConfiguration
set name = 'Full Note Dashboard'
where UIConfigurationUid = '5175CAF7-9F06-4017-9E4A-506FE7EC110E'
GO

-- #23799-ListMedicationTableUpdates.sql
-- CMR: Update tables for encoding StructuredSIG
UPDATE ListMedicationUnit SET NCItCode = 'C25397'  WHERE NCItCode IS NULL AND MedicationUnitUid = 'D266317D-D184-42DC-9322-B87CCAD92DDF' AND Name = 'Application'    -- "Application";
UPDATE ListMedicationUnit SET NCItCode = 'C48480'  WHERE NCItCode IS NULL AND MedicationUnitUid = 'FC42EBE7-5C16-4F91-AA73-B6BC48B0A4AA' AND Name = 'Capsule(s)'     -- "Capsule";
UPDATE ListMedicationUnit SET NCItCode = 'C48155'  WHERE NCItCode IS NULL AND MedicationUnitUid = '495C5E93-5C82-44BF-8AC0-423D83A29280' AND Name = 'Gram(s)'        -- "Gram";
UPDATE ListMedicationUnit SET NCItCode = 'C48152'  WHERE NCItCode IS NULL AND MedicationUnitUid = '708613A7-6AC4-4027-8DC9-ABA237F8C5CA' AND Name = 'Microgram(s)'   -- "Microgram";
UPDATE ListMedicationUnit SET NCItCode = 'C28253'  WHERE NCItCode IS NULL AND MedicationUnitUid = 'D362ABC2-4661-4703-80E8-0D506937274C' AND Name = 'Milligram(s)'   -- "Milligram";
UPDATE ListMedicationUnit SET NCItCode = 'C28254'  WHERE NCItCode IS NULL AND MedicationUnitUid = 'E9B15F0D-CB8F-4364-AC09-B86301B4D585' AND Name = 'Milliliter(s)'  -- "Milliliter";
UPDATE ListMedicationUnit SET NCItCode = 'C48519'  WHERE NCItCode IS NULL AND MedicationUnitUid = 'CB31A6DC-E156-4F5B-9119-5F6D53ABCFB0' AND Name = 'Oz'             -- "Ounce";
UPDATE ListMedicationUnit SET NCItCode = 'C65060'  WHERE NCItCode IS NULL AND MedicationUnitUid = '0ABA7D84-B35E-4EEE-B34B-AC3B9244C2D6' AND Name = 'Puff(s)'        -- "Puff";
UPDATE ListMedicationUnit SET NCItCode = 'C48537'  WHERE NCItCode IS NULL AND MedicationUnitUid = 'CE49BA3E-D8C8-4E14-A1E3-7A9B24EB14C8' AND Name = 'Spray'          -- "Spray";
UPDATE ListMedicationUnit SET NCItCode = 'C48539'  WHERE NCItCode IS NULL AND MedicationUnitUid = '1104D40F-33A8-44DD-9374-2B549F1D40F3' AND Name = 'Suppository'    -- "Suppository";
UPDATE ListMedicationUnit SET NCItCode = 'C48542'  WHERE NCItCode IS NULL AND MedicationUnitUid = '944AE82B-8244-4553-9FDD-328FFFE901C7' AND Name = 'Tablet(s)'      -- "Tablet";
UPDATE ListMedicationUnit SET NCItCode = 'C44278'  WHERE NCItCode IS NULL AND MedicationUnitUid = '0B19C36D-4C49-4887-B488-7ABCF4F73B77' AND Name = 'Unit(s)'        -- "Unit";
UPDATE ListMedicationUnit SET NCItCode = 'C44278'  WHERE NCItCode IS NULL AND MedicationUnitUid = '513BC21A-B348-43EA-A8B4-276D5E550F1E' AND Name = 'Unit Dose'      -- "Unit";

UPDATE ListMedicationFrequency SET InstructionsType = 3, RangeMinValue = 3, RangeMaxValue = 4, SnomedConceptID = '258702006' WHERE SnomedConceptID IS NULL AND Name = 'Q3-4H' AND MedicationFrequencyUid = '9267ABF8-674C-428C-8F76-444252D21D58' -- every 3-4 hours
UPDATE ListMedicationFrequency SET InstructionsType = 3, RangeMinValue = 4, RangeMaxValue = 6, SnomedConceptID = '258702006' WHERE SnomedConceptID IS NULL AND Name = 'Q4-6H' AND MedicationFrequencyUid = '363F63D1-2463-40E2-9382-9E4A9A1704AE' -- every 4-6 hours
UPDATE ListMedicationFrequency SET InstructionsType = 3, RangeMinValue = 6, RangeMaxValue = 8, SnomedConceptID = '258702006' WHERE SnomedConceptID IS NULL AND Name = 'Q6-8H' AND MedicationFrequencyUid = '660D323A-3609-4B7D-AEE5-D5EE9E62FA01' -- every 6-8 hours
UPDATE ListMedicationFrequency SET InstructionsType = 4, SnomedConceptID = '307165006', DescriptionUid = '00000000-0000-0000-0000-000703654012' WHERE SnomedConceptID IS NULL AND Name = 'AC'     AND MedicationFrequencyUid = 'CF31E947-D0BF-47FC-B9F6-D8C2653E8A6B'  -- Before meal
UPDATE ListMedicationFrequency SET InstructionsType = 4, SnomedConceptID = '21029003' , DescriptionUid = '00000000-0000-0000-0000-000750278017' WHERE SnomedConceptID IS NULL AND Name = 'HS'     AND MedicationFrequencyUid = '75EE611A-E8C1-4301-8A89-6A5BDAB06722'  -- Bedtime
UPDATE ListMedicationFrequency SET InstructionsType = 4, SnomedConceptID = '21029003' , DescriptionUid = '00000000-0000-0000-0000-000750278017' WHERE SnomedConceptID IS NULL AND Name = 'HS PRN' AND MedicationFrequencyUid = 'DEEF3976-2658-445C-9293-0AC4F1706E4E'  -- Bedtime
UPDATE ListMedicationFrequency SET InstructionsType = 4, SnomedConceptID = '307472001', DescriptionUid = '00000000-0000-0000-0000-000704000016' WHERE SnomedConceptID IS NULL AND Name = 'QAM'    AND MedicationFrequencyUid = '35CC9CD0-A27D-4723-9571-595A44835D1E'  -- Every morning
UPDATE ListMedicationFrequency SET InstructionsType = 4, SnomedConceptID = '307473006', DescriptionUid = '00000000-0000-0000-0000-000704001017' WHERE SnomedConceptID IS NULL AND Name = 'QPM'    AND MedicationFrequencyUid = 'BF38371C-D1CE-4CE3-8BA2-B4678EA7C26F'  -- Every evening
UPDATE ListMedicationFrequency SET DescriptionUid = '00000000-0000-0000-0000-000650150010' WHERE DescriptionUid IS NULL AND SnomedConceptID = '258702006'  -- hour
UPDATE ListMedicationFrequency SET DescriptionUid = '00000000-0000-0000-0000-000650151014' WHERE DescriptionUid IS NULL AND SnomedConceptID = '258703001'  -- day
UPDATE ListMedicationFrequency SET DescriptionUid = '00000000-0000-0000-0000-000650153012' WHERE DescriptionUid IS NULL AND SnomedConceptID = '258705008'  -- week
UPDATE ListMedicationFrequency SET NumericValue = 3 WHERE DosesPerDay = 3.00 and NumericValue = 1 AND Name = 'TID' AND MedicationFrequencyUid = '4CABC388-F13C-4382-97E0-5339308BB957'

UPDATE ListMedicationPRNReason SET SnomedConceptID = '48694002' , DescriptionUid = '00000000-0000-0000-0000-000786290018' WHERE SnomedConceptId IS NULL AND MedicationPRNReasonUid = '03447F0A-FF0F-4E98-95F3-B2918CA68309' AND Name = 'for anxiety'            --Anxiety
UPDATE ListMedicationPRNReason SET SnomedConceptID = '392570002', DescriptionUid = '00000000-0000-0000-0000-001466751013' WHERE SnomedConceptId IS NULL AND MedicationPRNReasonUid = '207189A4-EBAC-44BB-9A13-10E36DC02C3B' AND Name = 'for blood pressure'     --Blood pressure finding
UPDATE ListMedicationPRNReason SET SnomedConceptID = '14760008' , DescriptionUid = '00000000-0000-0000-0000-003654293015' WHERE SnomedConceptId IS NULL AND MedicationPRNReasonUid = '3DB307A1-661A-44CD-ADD4-3DC7CC765605' AND Name = 'for constipation'       --Constipation
UPDATE ListMedicationPRNReason SET SnomedConceptID = '62315008' , DescriptionUid = '00000000-0000-0000-0000-000801474016' WHERE SnomedConceptId IS NULL AND MedicationPRNReasonUid = 'A75FD18F-B3BA-4125-8D4A-1AE43ABC29CB' AND Name = 'for diarrhea'           --Diarrhea
UPDATE ListMedicationPRNReason SET SnomedConceptID = '386661006', DescriptionUid = '00000000-0000-0000-0000-001460840012' WHERE SnomedConceptId IS NULL AND MedicationPRNReasonUid = '67EC11ED-E291-438D-AB33-301F0CBBC3D0' AND Name = 'for fever'              --Fever
UPDATE ListMedicationPRNReason SET SnomedConceptID = '73879007' , DescriptionUid = '00000000-0000-0000-0000-000814315019' WHERE SnomedConceptId IS NULL AND MedicationPRNReasonUid = '8330FC19-D4DA-4A29-9768-802133903A9E' AND Name = 'for nausea'             --Nausea
UPDATE ListMedicationPRNReason SET SnomedConceptID = '65124004' , DescriptionUid = '00000000-0000-0000-0000-000804593018' WHERE SnomedConceptId IS NULL AND MedicationPRNReasonUid = '15141F82-81EA-42BC-98CD-273197C59B83' AND Name = 'for swelling'           --Swelling
UPDATE ListMedicationPRNReason SET SnomedConceptID = '415709002', DescriptionUid = '00000000-0000-0000-0000-002572942017' WHERE SnomedConceptId IS NULL AND MedicationPRNReasonUid = 'AE77B217-BFA6-48E3-BBAD-7EA1C21B36B5' AND Name = 'n/v'                    --Tendency to nausea and vomiting

UPDATE ListMedicationRoute SET DescriptionUid = '00000000-0000-0000-0000-000792706016' WHERE DescriptionUid IS NULL AND MedicationRouteUid = 'FF25D572-B152-46BD-96B0-E2B31123E55C' AND SnomedConceptId = '54471007'  AND Name = 'BUCC'
UPDATE ListMedicationRoute SET DescriptionUid = '00000000-0000-0000-0000-002153499019' WHERE DescriptionUid IS NULL AND MedicationRouteUid = 'DFFB1194-45D7-4355-A7D4-80A92D87FC41' AND SnomedConceptId = '372449004' AND Name = 'Dent'
UPDATE ListMedicationRoute SET DescriptionUid = '00000000-0000-0000-0000-002148650016' WHERE DescriptionUid IS NULL AND MedicationRouteUid = '6B46F8AC-B542-49E0-8669-86867EBE83E1' AND SnomedConceptId = '404820008' AND Name = 'Epid'
UPDATE ListMedicationRoute SET DescriptionUid = '00000000-0000-0000-0000-000796794011' WHERE DescriptionUid IS NULL AND MedicationRouteUid = '76E48433-25F2-4517-A542-A3C0B73B457B' AND SnomedConceptId = '58100008'  AND Name = 'IArt'
UPDATE ListMedicationRoute SET DescriptionUid = '00000000-0000-0000-0000-000720047013' WHERE DescriptionUid IS NULL AND MedicationRouteUid = 'F68A6EE9-A16F-4CFA-9650-218E3D2CD5E5' AND SnomedConceptId = '12130007'  AND Name = 'IAtc'
UPDATE ListMedicationRoute SET DescriptionUid = '00000000-0000-0000-0000-002153512010' WHERE DescriptionUid IS NULL AND MedicationRouteUid = '992A4EEB-A7F9-47BE-AB31-0D30C5F98127' AND SnomedConceptId = '372464004' AND Name = 'IDrm'
UPDATE ListMedicationRoute SET DescriptionUid = '00000000-0000-0000-0000-000819360016' WHERE DescriptionUid IS NULL AND MedicationRouteUid = 'CB1157EF-EA3F-440F-A317-4FE70F434E51' AND SnomedConceptId = '78421000'  AND Name = 'IM'
UPDATE ListMedicationRoute SET DescriptionUid = '00000000-0000-0000-0000-002642080011' WHERE DescriptionUid IS NULL AND MedicationRouteUid = '9F4D3F03-6BAB-40D0-9537-777B099136AC' AND SnomedConceptId = '424109004' AND Name = 'Inj'
UPDATE ListMedicationRoute SET DescriptionUid = '00000000-0000-0000-0000-002153517016' WHERE DescriptionUid IS NULL AND MedicationRouteUid = '0159394A-D9F9-43F5-9089-3BD812C64770' AND SnomedConceptId = '372469009' AND Name = 'InPl'
UPDATE ListMedicationRoute SET DescriptionUid = '00000000-0000-0000-0000-002148648012' WHERE DescriptionUid IS NULL AND MedicationRouteUid = 'FE62DD1C-9607-4B89-834F-CD345286E4F5' AND SnomedConceptId = '404818005' AND Name = 'InTr'
UPDATE ListMedicationRoute SET DescriptionUid = '00000000-0000-0000-0000-002153516013' WHERE DescriptionUid IS NULL AND MedicationRouteUid = '3438D240-A6EB-47BE-B7CD-344B892BE863' AND SnomedConceptId = '372468001' AND Name = 'IO'
UPDATE ListMedicationRoute SET DescriptionUid = '00000000-0000-0000-0000-000772389016' WHERE DescriptionUid IS NULL AND MedicationRouteUid = 'B8DB596A-7EF4-463A-A596-1CFD6ED4F084' AND SnomedConceptId = '38239002'  AND Name = 'IP'
UPDATE ListMedicationRoute SET DescriptionUid = '00000000-0000-0000-0000-000812903011' WHERE DescriptionUid IS NULL AND MedicationRouteUid = '8B43B162-4C62-4A1B-B4D7-D1ECF8863402' AND SnomedConceptId = '72607000'  AND Name = 'IT'
UPDATE ListMedicationRoute SET DescriptionUid = '00000000-0000-0000-0000-000801375019' WHERE DescriptionUid IS NULL AND MedicationRouteUid = '3000D8D4-2AC0-494D-B882-B9C4B2C38BD3' AND SnomedConceptId = '62226000'  AND Name = 'IU'
UPDATE ListMedicationRoute SET DescriptionUid = '00000000-0000-0000-0000-000785104019' WHERE DescriptionUid IS NULL AND MedicationRouteUid = '5743DBE5-9CB2-4966-A8AC-E649A072C710' AND SnomedConceptId = '47625008'  AND Name = 'IV'
UPDATE ListMedicationRoute SET DescriptionUid = '00000000-0000-0000-0000-002153519018' WHERE DescriptionUid IS NULL AND MedicationRouteUid = '26CFBF45-0120-4827-9786-93E665CA241B' AND SnomedConceptId = '372471009' AND Name = 'IVes'
UPDATE ListMedicationRoute SET DescriptionUid = '00000000-0000-0000-0000-000784093013' WHERE DescriptionUid IS NULL AND MedicationRouteUid = '1EC2204E-CC57-498D-8D03-129562B4B065' AND SnomedConceptId = '46713006'  AND Name = 'NASAL'
UPDATE ListMedicationRoute SET DescriptionUid = '00000000-0000-0000-0000-000792721010' WHERE DescriptionUid IS NULL AND MedicationRouteUid = '457B51D4-A30A-4901-A158-16FABBF55D7F' AND SnomedConceptId = '54485002'  AND Name = 'OPH'
UPDATE ListMedicationRoute SET DescriptionUid = '00000000-0000-0000-0000-000572319011' WHERE DescriptionUid IS NULL AND MedicationRouteUid = 'BF34DCA1-3042-4A80-83B1-5DEE1F4CA7E1' AND SnomedConceptId = '10547007'  AND Name = 'OTIC'
UPDATE ListMedicationRoute SET DescriptionUid = '00000000-0000-0000-0000-002691095014' WHERE DescriptionUid IS NULL AND MedicationRouteUid = '219687A0-529C-4598-85BA-0E178FA36149' AND SnomedConceptId = '428191002' AND Name = 'PCut'
UPDATE ListMedicationRoute SET DescriptionUid = '00000000-0000-0000-0000-002880883015' WHERE DescriptionUid IS NULL AND MedicationRouteUid = '4C586AD7-1C74-4325-A02D-7C75F5304BBE' AND SnomedConceptId = '447052000' AND Name = 'Pdnt'
UPDATE ListMedicationRoute SET DescriptionUid = '00000000-0000-0000-0000-000757099014' WHERE DescriptionUid IS NULL AND MedicationRouteUid = '13929DE8-2CE7-47DD-97A0-493BCC503316' AND SnomedConceptId = '26643006'  AND Name = 'PO'
UPDATE ListMedicationRoute SET DescriptionUid = '00000000-0000-0000-0000-002897281011' WHERE DescriptionUid IS NULL AND MedicationRouteUid = '0831BAE1-083D-4C93-8BFD-509D97FAEF22' AND SnomedConceptId = '37161004'  AND Name = 'RTL'
UPDATE ListMedicationRoute SET DescriptionUid = '00000000-0000-0000-0000-000769781016' WHERE DescriptionUid IS NULL AND MedicationRouteUid = '81D19653-E9B9-4266-8620-6018AA011EA5' AND SnomedConceptId = '37839007'  AND Name = 'SL'
UPDATE ListMedicationRoute SET DescriptionUid = '00000000-0000-0000-0000-000765702016' WHERE DescriptionUid IS NULL AND MedicationRouteUid = 'CB82D413-474F-4641-B53C-B06753DFF6BA' AND SnomedConceptId = '34206005'  AND Name = 'SQ'
UPDATE ListMedicationRoute SET DescriptionUid = '00000000-0000-0000-0000-000783178017' WHERE DescriptionUid IS NULL AND MedicationRouteUid = '05313EA4-504B-4C6B-9E9F-5A090343F393' AND SnomedConceptId = '45890007'  AND Name = 'TD'
UPDATE ListMedicationRoute SET DescriptionUid = '00000000-0000-0000-0000-000799615015' WHERE DescriptionUid IS NULL AND MedicationRouteUid = '2CA0BF87-73C4-46CB-8F6E-AE43EBE51DA7' AND SnomedConceptId = '6064005'   AND Name = 'TOP'
UPDATE ListMedicationRoute SET DescriptionUid = '00000000-0000-0000-0000-000833046011' WHERE DescriptionUid IS NULL AND MedicationRouteUid = '75DF44CC-4AE0-4143-97DA-F1A9147EC619' AND SnomedConceptId = '90028008'  AND Name = 'Urth'
UPDATE ListMedicationRoute SET DescriptionUid = '00000000-0000-0000-0000-002898183019' WHERE DescriptionUid IS NULL AND MedicationRouteUid = '72E00E64-6CB2-45DA-93E5-578F3DE3A330' AND SnomedConceptId = '16857009'  AND Name = 'VAG'
GO

GO

-- #24340 Surescripts v6 -
UPDATE [ListFindTable]
	SET [Columns] = '<FindColumn name="MasterPharmacyUid" index="guid" visible="false" /><FindColumn name="Inactive" visible="false" index="inactive" /><FindColumn name="ExternalID" caption="ID" index="externalid" visible="true" width="70" /><FindColumn name="Name" caption="Name" index="name" visible="true" width="120" /><FindColumn name="PharmacyClearinghouseName" caption="Clearinghouse" visible="true" width="100" /><FindColumn name="Address1" caption="Address" index="address1" visible="true" width="120" /><FindColumn name="City" caption="City" index="city" visible="true" width="75" /><FindColumn name="State" caption="State" index="state" visible="true" width="35" /><FindColumn name="Zip" caption="Zip" index="Zip" visible="true" width="65" /><FindColumn name="CrossStreet" caption="CrossStreet" index="crossstreet" visible="true" width="200" /><FindColumn name="IsFaxOnly" caption="Fax Only" index="isFaxOnly" visible="true" width="40" /><FindColumn name="MailOrderEnabled" caption="Mail Order" index="MailOrderEnabled" visible="true" width="40" /><FindColumn name="SpecialtyIDCode" caption="Type" index="specialtyidcode" visible="true" width="100" /><FindColumn name="ServiceLevelCode" caption="Service Level Code" index="serviceLevelCode" visible="true" width="100" /><FindColumn name="Notes" visible="true" caption="Notes" width="125" /><FindColumn name="Version" visible="false" caption="Version" width="16" />'
WHERE [FindTableUid] = '025B49EE-F2B3-4020-9E7B-0E5EEDBA5C54'	-- Master Pharmacy List
	AND [Columns].exist('FindColumn[@name="Version"]') = 0

UPDATE [ListFindTable]
	SET [Columns] = '<FindColumn name="PharmacyUid" index="guid" visible="false" /><FindColumn name="Name" caption="Name" index="name" visible="true" width="100" /><FindColumn name="PharmacyClearinghouseUid" visible="false" /><FindColumn name="PharmacyClearinghouseName" caption="Clearinghouse" visible="true" width="80" /><FindColumn name="Address1" caption="Address" index="address1" visible="true" width="200" /><FindColumn name="City" caption="City" index="city" visible="true" width="75" /><FindColumn name="State" caption="State" index="state" visible="true" width="35" /><FindColumn name="Zip" caption="Zip" index="Zip" visible="true" width="65" /><FindColumn name="PhoneNumber1" caption="PhoneNumber" index="phoneNumber" visible="true" width="100" /><FindColumn name="CrossStreet" caption="CrossStreet" index="crossstreet" visible="true" width="200" /><FindColumn name="IsFaxOnly" caption="Fax Only" index="isFaxOnly" visible="true" width="40" /><FindColumn name="MailOrderEnabled" caption="Mail Order" index="MailOrderEnabled" visible="true" width="40" /><FindColumn name="SpecialtyIDCode" caption="Type" index="specialtyidcode" visible="true" width="100" /><FindColumn name="ServiceLevelCode" caption="Service Level Code" index="serviceLevelCode" visible="true" width="100" /><FindColumn name="Inactive" visible="false" index="inactive" /><FindColumn name="Version" visible="false" caption="Version" width="16" />'
WHERE [FindTableUid] = 'CC76AB39-7063-4AF9-AD76-9791C4D9B24F'	-- Pharmacy
	AND [Columns].exist('FindColumn[@name="Version"]') = 0
GO

-- #25021 Surescripts v6 URL for transmission
UPDATE TransmissionConfiguration
SET
   TestAprimaVaultSubmissionURL    = 'https://cpdev02.aprima.corp:40140/NewPrescription',
   TestAprimaVaultURL              = 'https://cpdev02.aprima.corp:34100/',
   TestRegistrationURL             = 'https://cpdev02.aprima.corp:34100/',
   CorepointDownloadProcessorAQN   = 'iMedica.Framework.eRxCorepoint.Transmission.V6R1eNewRxCorepointDownloadProcessor, eRxCorepoint',
   CorepointDataExportGeneratorAQN = 'iMedica.Framework.eRxCorepoint.Generator.V6R1eNewRxCorepointExportGenerator, eRxCorepoint',
   CorepointSenderAQN              = 'iMedica.Framework.eRxCorepoint.Transmission.V6R1eNewRxCorepointSender, eRxCorepoint',
   OutboundQueueGeneratorAQN       = null,
   ExportXMLLayout                 = null,
   ExportBusinessObjectName        = 'RelVisitMedication',
   ExportKeyLookupFieldName        = 'RelVisitMedicationUid'
WHERE TransmissionType = 'NEWRX'

UPDATE TransmissionConfiguration
SET
   TestAprimaVaultSubmissionURL    = 'https://cpdev02.aprima.corp:40145/RefillResponse',
   TestAprimaVaultURL              = 'https://cpdev02.aprima.corp:34100/',
   TestRegistrationURL             = 'https://cpdev02.aprima.corp:34100/',
   CorepointDownloadProcessorAQN   = 'iMedica.Framework.eRxCorepoint.Transmission.V6R1eRxRefillResponseCorepointDownloadProcessor, eRxCorepoint',
   CorepointDataExportGeneratorAQN = 'iMedica.Framework.eRxCorepoint.Generator.V6R1eRxRefillResponseCorepointExportGenerator, eRxCorepoint',
   CorepointSenderAQN              = 'iMedica.Framework.eRxCorepoint.Transmission.V6R1eRxRefillResponseCorepointSender, eRxCorepoint',
   OutboundQueueGeneratorAQN       = null,
   ExportXMLLayout                 = null,
   ExportBusinessObjectName        = 'Message',
   ExportKeyLookupFieldName        = 'MessageUid'
WHERE TransmissionType = 'REFRES'

UPDATE TransmissionConfiguration
SET
   TestAprimaVaultSubmissionURL    = 'https://cpdev02.aprima.corp:40155/Cancel',
   TestAprimaVaultURL              = 'https://cpdev02.aprima.corp:34100/',
   TestRegistrationURL             = 'https://cpdev02.aprima.corp:34100/',
   CorepointDownloadProcessorAQN   = 'iMedica.Framework.eRxCorepoint.Transmission.V6R1eCancelRxCorepointDownloadProcessor, eRxCorepoint',
   CorepointDataExportGeneratorAQN = 'iMedica.Framework.eRxCorepoint.Generator.V6R1eCancelRxCorepointExportGenerator, eRxCorepoint',
   CorepointSenderAQN              = 'iMedica.Framework.eRxCorepoint.Transmission.V6R1eCancelRxCorepointSender, eRxCorepoint',
   OutboundQueueGeneratorAQN       = null,
   ExportXMLLayout                 = null,
   ExportBusinessObjectName        = 'RelPatientMedication',
   ExportKeyLookupFieldName        = 'RelPatientMedicationUid'
WHERE TransmissionType = 'CANRX'

UPDATE TransmissionConfiguration
SET
   TestAprimaVaultSubmissionURL    = 'https://cpdev02.aprima.corp:40150/Change',
   TestAprimaVaultURL              = 'https://cpdev02.aprima.corp:34100/',
   TestRegistrationURL             = 'https://cpdev02.aprima.corp:34100/',
   CorepointDownloadProcessorAQN   = 'iMedica.Framework.eRxCorepoint.Transmission.V6R1eChangeRxResponseCorepointDownloadProcessor, eRxCorepoint',
   CorepointDataExportGeneratorAQN = 'iMedica.Framework.eRxCorepoint.Generator.V6R1eChangeRxResponseCorepointExportGenerator, eRxCorepoint',
   CorepointSenderAQN              = 'iMedica.Framework.eRxCorepoint.Transmission.V6R1eChangeRxResponseCorepointSender, eRxCorepoint',
   OutboundQueueGeneratorAQN       = null,
   ExportXMLLayout                 = null,
   ExportBusinessObjectName        = 'Message',
   ExportKeyLookupFieldName        = 'MessageUid'
WHERE TransmissionType = 'CHGRES'

UPDATE TransmissionConfiguration
SET
   TestAprimaVaultSyncURL          = 'https://cpdev01.aprima.corp:40115/communityexchange/partner/PartnerService',
   TestRegistrationURL             = 'https://cpdev01.aprima.corp:40015/communityexchange/partner/PartnerService',
   ExportXMLLayout                 = null
WHERE TransmissionType IN('eRxOrganizationDirectory','eRxProviderDirectory')

UPDATE TransmissionConfiguration
SET TestAprimaVaultURL             = 'https://cpdev01.aprima.corp:34100'
WHERE TransmissionType IN('ELGREQ', 'RXHREQ', 'INBOUND')

-- Work in progress
--UPDATE TransmissionConfiguration
--SET TestAprimaVaultURL             = 'https://cpdev01.aprima.corp:34100',
--    TestAprimaVaultSubmissionURL   = 'https://tiran.aprima.corp:51375/communityexchange/partner/PartnerService',
--    TestRegistrationURL            = 'https://cpdev01.aprima.corp:40015/communityexchange/partner/PartnerService'
--WHERE TransmissionType IN('PRVUPD::Prescriber Download')

-- Make sure surescripts TestMode is the same as the IntegrationPartner
UPDATE tc
SET TestMode = ip.TestMode
FROM TransmissionConfiguration tc
INNER JOIN ListIntegrationPartner ip ON ip.IntegrationPartnerUid = tc.IntegrationPartnerUid
WHERE tc.TestMode != ip.TestMode
  AND ip.IntegrationPartnerUid IN('118422AA-C165-4A2E-8389-E5B7E89636EA', '4D1BC44B-31F5-4B41-8F50-A95047266FFC')
GO
