-- #10705 Financial Summary migration script.sql
-- 20170731 kculberth Fix Bug 58622 - need to check in most current Financial Summary (6) to correct financial reporting issues
-- 20180727 kculberth 2402 Reports.  need to check in most current Financial Summary (6) to correct financial reporting issues
-- 20180813 kculberth fix 10705 remove the 2 options from financial summary 

-- Financial Summary 

--DROP OLD ListUserDefinedControl entries
IF EXISTS (SELECT UserDefinedControlGroupUid from ListUserDefinedControl WHERE UserDefinedControlGroupUid='31092F7B-259E-4417-BDCE-BD2EEA4A710F')
    DELETE ListUserDefinedControl 
    WHERE UserDefinedControlGroupUid='31092F7B-259E-4417-BDCE-BD2EEA4A710F'

-- SortOrder 0 Posting Dates
IF NOT EXISTS (SELECT * FROM ListUserDefinedControl WHERE UserDefinedControlUid = 'BD5B2EEF-2CD1-444D-9AE9-981B333F76C4')
BEGIN
INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
VALUES('BD5B2EEF-2CD1-444D-9AE9-981B333F76C4'
        ,'FinanceSummary'
        ,0
        ,'Posting Dates'
        ,'df87d0d5-bf48-49fb-abbc-cb75cc29eb64'
        ,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>FinanceSummary</Name><Uid>f2e52f89-7f2c-466a-a878-459f82fa12c9</Uid><Required>TRUE</Required></Control></UserDefinedControls>'
         ,'31092F7B-259E-4417-BDCE-BD2EEA4A710F'
        ,0
        ,0
        ,0
        ,'08/13/2018 00:00:00 AM')
END

--Sort Order 1 Provider (take off parenthesis s)
IF NOT EXISTS (SELECT UserDefinedControlUid FROM ListUserDefinedControl WHERE UserDefinedControlUid = 'D573BB5B-A0F5-403E-B9C5-CBF0C7CDE1BF')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('D573BB5B-A0F5-403E-B9C5-CBF0C7CDE1BF'
            ,'ProviderUid'
            ,0
            ,'Providers'
            ,'8a957d7c-8b86-4a67-8336-b830c30fd123'
            ,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProviderUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Provider</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewProvider</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
            ,'31092F7B-259E-4417-BDCE-BD2EEA4A710F'
            ,1
            ,0
            ,0
            ,'08/13/2018 00:00:00 AM')
END

-- SortOrder 2 ProviderOption
IF NOT EXISTS (SELECT UserDefinedControlUid FROM ListUserDefinedControl WHERE UserDefinedControlUid = '5C1719DB-B68E-4297-9116-4DB8F9352568')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('5C1719DB-B68E-4297-9116-4DB8F9352568'
            ,'ProviderOption'
            ,0
            ,'Provider Option'
            ,'8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
            ,'<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Billing Provider</ButtonLabel><ButtonValue>Billing Providers</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Rendering Provider</ButtonLabel><ButtonValue>Rendering Providers</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
            ,'31092F7B-259E-4417-BDCE-BD2EEA4A710F'
            ,2
            ,0
            ,0
            ,'08/13/2018 00:00:00 AM')
END

-- SortOrder 3 Financial Center
IF NOT EXISTS (SELECT UserDefinedControlUid FROM ListUserDefinedControl WHERE UserDefinedControlUid = '0B66D733-AFCE-47F7-B7A0-B24D906EB815')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('0B66D733-AFCE-47F7-B7A0-B24D906EB815'
            ,'FCUid'
            ,0
            ,'Financial Centers'
            ,'8a957d7c-8b86-4a67-8336-b830c30fd123'
            ,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>FCUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Financial Center</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>FinancialCenter</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
            ,'31092F7B-259E-4417-BDCE-BD2EEA4A710F'
            ,3
            ,0
            ,0
            ,'08/13/2018 00:00:00 AM')
END

-- SortOrder 4 Service Site
IF NOT EXISTS (SELECT UserDefinedControlUid FROM ListUserDefinedControl WHERE UserDefinedControlUid = 'E0F9E1FA-D5DB-48AE-BEAB-5ECF688428E8')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('E0F9E1FA-D5DB-48AE-BEAB-5ECF688428E8'
            ,'ServiceSiteUid'
            ,0
            ,'Service Sites'
            ,'8a957d7c-8b86-4a67-8336-b830c30fd123'
            ,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ServiceSiteUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Service Site</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListServiceSite</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
            ,'31092F7B-259E-4417-BDCE-BD2EEA4A710F'
            ,4
            ,0
            ,0
            ,'08/13/2018 00:00:00 AM')
END

-- SortOrder 5 Account Types
IF NOT EXISTS (SELECT UserDefinedControlUid FROM ListUserDefinedControl WHERE UserDefinedControlUid = 'E8A77F62-3B0E-4B0D-A0D7-BC5E1C2E6159')
BEGIN 
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('E8A77F62-3B0E-4B0D-A0D7-BC5E1C2E6159'
            ,'AccountTypeUid'
            ,0
            ,'Account Types'
            ,'8a957d7c-8b86-4a67-8336-b830c30fd123'
            ,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>AccountTypeUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Account Type</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListAccountType</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
            ,'31092F7B-259E-4417-BDCE-BD2EEA4A710F'
            ,5
            ,0
            ,0
            ,'08/13/2018 00:00:00 AM')
END

-- SortOrder 6 AccountTypeOption
IF NOT EXISTS (SELECT UserDefinedControlUid FROM ListUserDefinedControl WHERE UserDefinedControlUid = '01552078-81F7-42B0-AA99-C72DDA4A117C')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('01552078-81F7-42B0-AA99-C72DDA4A117C'
            ,'Accounttypeoption'
            ,0
            ,'Account Type Option'
            ,'8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
            ,'<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>Accounttypeoption</Name><ButtonLabel>Patient</ButtonLabel><ButtonValue>Patient</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>Accounttypeoption</Name><ButtonLabel>Insurance Plan</ButtonLabel><ButtonValue>Insurance</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
            ,'31092F7B-259E-4417-BDCE-BD2EEA4A710F'
            ,6
            ,0
            ,0
            ,'08/13/2018 00:00:00 AM')
END
 
--SortOrder 7 PrimaryGroupLevel
IF NOT EXISTS (SELECT UserDefinedControlUid FROM ListUserDefinedControl WHERE UserDefinedControlUid = '76F72577-AD92-4ACB-90C4-D2CA5739CEFA')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('76F72577-AD92-4ACB-90C4-D2CA5739CEFA'
            ,'PrimaryGroupLevel'
            ,0
            ,'Primary Group Level'
            ,'8a957d7c-8b86-4a67-8336-b830c30fd123'
            ,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>PrimaryGroupLevel</Name><SelectType>Single</SelectType><Conjunction>none</Conjunction><EntryNameInFindTable>Financial Summary Group</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>FS_Group</FindTableName></Control></UserDefinedControls>'
            ,'31092F7B-259E-4417-BDCE-BD2EEA4A710F'
            ,7
            ,0
            ,0
            ,'08/13/2018 00:00:00 AM')
END

--SortOrder 8 SecondGroupLevel
IF NOT EXISTS (SELECT UserDefinedControlUid FROM ListUserDefinedControl WHERE UserDefinedControlUid = '5C0C5B96-0F39-46E3-9CDE-FD5FA0D85315')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('5C0C5B96-0F39-46E3-9CDE-FD5FA0D85315'
            ,'SecondGroupLevel'
            ,0
            ,'Second Group Level'
            ,'8a957d7c-8b86-4a67-8336-b830c30fd123'
            ,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>SecondGroupLevel</Name><SelectType>Single</SelectType><Conjunction>none</Conjunction><EntryNameInFindTable>Financial Summary Group</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>FS_Group</FindTableName></Control></UserDefinedControls>'
            ,'31092F7B-259E-4417-BDCE-BD2EEA4A710F'
            ,8
            ,0
            ,0
            ,'08/13/2018 00:00:00 AM')
END

--SortOrder 9 ThirdGroupLevel
IF NOT EXISTS (SELECT UserDefinedControlUid FROM ListUserDefinedControl WHERE UserDefinedControlUid = '2C40534E-AFF0-4641-B272-A694948D4DA8')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('2C40534E-AFF0-4641-B272-A694948D4DA8'
            ,'ThirdGroupLevel'
            ,0
            ,'Third Group Level'
            ,'8a957d7c-8b86-4a67-8336-b830c30fd123'
            ,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ThirdGroupLevel</Name><SelectType>Single</SelectType><Conjunction>none</Conjunction><EntryNameInFindTable>Financial Summary Group</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>FS_Group</FindTableName></Control></UserDefinedControls>'
            ,'31092F7B-259E-4417-BDCE-BD2EEA4A710F'
            ,9
            ,0
            ,0
            ,'08/13/2018 00:00:00 AM')
END

--SortOrder 10 FourthGroupLevel
IF NOT EXISTS (SELECT UserDefinedControlUid FROM ListUserDefinedControl WHERE UserDefinedControlUid = '74AE3017-F262-438C-B784-16B34783217B')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('74AE3017-F262-438C-B784-16B34783217B'
            ,'FourthGroupLevel'
            ,0
            ,'Fourth Group Level'
            ,'8a957d7c-8b86-4a67-8336-b830c30fd123'
            ,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>FourthGroupLevel</Name><SelectType>Single</SelectType><Conjunction>none</Conjunction><EntryNameInFindTable>Financial Summary Group</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>FS_Group</FindTableName></Control></UserDefinedControls>'
            ,'31092F7B-259E-4417-BDCE-BD2EEA4A710F'
            ,10
            ,0
            ,0
            ,'08/13/2018 00:00:00 AM')
END


--SortOrder 11 ShowContractualAdjustment
IF NOT EXISTS (SELECT UserDefinedControlUid FROM ListUserDefinedControl WHERE UserDefinedControlUid = '55DD363B-7F7B-462E-9F3B-6930F0B91FFC')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('55DD363B-7F7B-462E-9F3B-6930F0B91FFC'
        ,'ShowContractualAdjustment'
        ,0
        ,'Show Contractual Adjustment'
        ,'71e67ced-b180-44e9-80c9-1ed3b47c9390'
        ,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>CHECKBOX</ControlType><Name>ShowContractualAdjustment</Name><CheckedText>True</CheckedText><UnCheckedText>False</UnCheckedText><CheckedByDefault>false</CheckedByDefault></Control></UserDefinedControls>'
        ,'31092F7B-259E-4417-BDCE-BD2EEA4A710F'
        ,11
        ,0
        ,0
        ,'08/13/2018 00:00:00 AM')
END
GO

-- #10580 Payer credit Detail report 
-- 20170814 kculberth Fix Bug 58628 - need to check in most current Payer Credit Detail (2) to correct financial reporting issues
-- 20180730 kculberth 2404 - Reports.  need to check in most current Payer Credit Detail to correct financial reporting issues
-- Payer Credit Detail

--DROP OLD ListUserDefinedControl entries
IF EXISTS (SELECT UserDefinedControlGroupUid from ListUserDefinedControl WHERE UserDefinedControlGroupUid = '7C13CB1B-6C12-4119-B13D-7D466E914471')
    DELETE ListUserDefinedControl 
    WHERE UserDefinedControlGroupUid = '7C13CB1B-6C12-4119-B13D-7D466E914471'

--- PCD (Time Span) SortOrder 0 
IF NOT EXISTS (SELECT * FROM ListUserDefinedControl WHERE UserDefinedControlUid = '3EA710F6-889B-4E30-8723-D93A14ABC06A')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('3EA710F6-889B-4E30-8723-D93A14ABC06A'
            ,'PCD'
            ,0
            ,'Dates'
            ,'df87d0d5-bf48-49fb-abbc-cb75cc29eb64'
            ,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>PCD</Name><Uid>f2e52f89-7f2c-466a-a878-459f82fa12c9</Uid><Required>TRUE</Required></Control></UserDefinedControls>'
            ,'7C13CB1B-6C12-4119-B13D-7D466E914471'
            ,0
            ,0
            ,0
            ,'7/31/2018 0:00:00 AM')
END

--- DateOption SortOrder 1 
IF NOT EXISTS (SELECT * FROM ListUserDefinedControl WHERE UserDefinedControlUid = '20208796-9A66-45A6-A417-61607408F62C')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('20208796-9A66-45A6-A417-61607408F62C'
            ,'DateOption'
            ,0
            ,'Date Option'
            ,'8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
            ,'<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>DateOption</Name><ButtonLabel>Posting Date</ButtonLabel><ButtonValue>Posting</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>DateOption</Name><ButtonLabel>Original Deposit Date</ButtonLabel><ButtonValue>Deposit</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
            ,'7C13CB1B-6C12-4119-B13D-7D466E914471'
            ,1
            ,0
            ,0
            ,'7/31/2018 0:00:00 AM')
END

--- Providers SortOrder 2 
IF NOT EXISTS (SELECT * FROM ListUserDefinedControl WHERE UserDefinedControlUid = '4A61B26E-6E38-49B6-8470-49BDE2494FF3')
BEGIN

    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('4A61B26E-6E38-49B6-8470-49BDE2494FF3'
            ,'ProviderUid'
            ,0
            ,'Providers'
            ,'8a957d7c-8b86-4a67-8336-b830c30fd123'
            ,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProviderUid</Name><SelectType>Multi</SelectType><Conjunction>or</Conjunction><EntryNameInFindTable>Provider</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewProvider</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
            ,'7C13CB1B-6C12-4119-B13D-7D466E914471'
            ,2
            ,0
            ,0
            ,'7/31/2018 0:00:00 AM')
END
--- Provider Option SortOrder 3
IF NOT EXISTS (SELECT * FROM ListUserDefinedControl WHERE UserDefinedControlUid = '20E179AA-FCA8-43D9-BAD8-280518B7352F7')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('20E179AA-FCA8-43D9-BAD8-280518B7352F'
            ,'ProviderOption'
            ,0
            ,'Provider Option'
            ,'8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
            ,'<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Billing Provider</ButtonLabel><ButtonValue>Billing</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Rendering Provider</ButtonLabel><ButtonValue>Rendering</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
            ,'7C13CB1B-6C12-4119-B13D-7D466E914471'
            ,3
            ,0
            ,0
            ,'7/31/2018 0:00:00 AM')
END

--- Financial Center SortOrder 4 
IF NOT EXISTS (SELECT * FROM ListUserDefinedControl WHERE UserDefinedControlUid = 'BC6F69DB-1940-4CE8-8898-96FAE7E2D7DD')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('BC6F69DB-1940-4CE8-8898-96FAE7E2D7DD'
            ,'FinancialCenterUid'
            ,0
            ,'Financial Centers'
            ,'8a957d7c-8b86-4a67-8336-b830c30fd123'
            ,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>FinancialCenterUid</Name><SelectType>Multi</SelectType><Conjunction>or</Conjunction><EntryNameInFindTable>Financial Center</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>FinancialCenter</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
            ,'7C13CB1B-6C12-4119-B13D-7D466E914471'
            ,4
            ,0
            ,0
            ,'7/31/2018 0:00:00 AM')
END

-- Service Sites SortOrder 5 
IF NOT EXISTS (SELECT * FROM ListUserDefinedControl WHERE UserDefinedControlUid = '6F8A348A-26F9-4403-BE9E-6D81C9BF1607')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('6F8A348A-26F9-4403-BE9E-6D81C9BF1607'
            ,'ServiceSiteUid'
            ,0
            ,'Service Sites'
            ,'8a957d7c-8b86-4a67-8336-b830c30fd123'
            ,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ServiceSiteUid</Name><SelectType>Multi</SelectType><Conjunction>or</Conjunction><EntryNameInFindTable>Service Site</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListServiceSite</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
            ,'7C13CB1B-6C12-4119-B13D-7D466E914471'
            ,5
            ,0
            ,0
            ,'7/31/2018 0:00:00 AM')
END
            
-- SortOrder 6 PayOption
IF NOT EXISTS (SELECT * FROM ListUserDefinedControl WHERE UserDefinedControlUid = '3D01109B-C79E-4492-A407-B59A0FB5F2F9')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('3D01109B-C79E-4492-A407-B59A0FB5F2F9'
            ,'PayOption'
            ,0
            ,'Payment Option'
            ,'8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
            ,'<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>PayOption</Name><ButtonLabel>Responsible Party</ButtonLabel><ButtonValue>Responsible</ButtonValue><Default>false</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>PayOption</Name><ButtonLabel>Insurance Payer</ButtonLabel><ButtonValue>Insurance</ButtonValue><Default>false</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>PayOption</Name><ButtonLabel>Both</ButtonLabel><ButtonValue>Both</ButtonValue><Default>true</Default></Control></Controls></UserDefinedControls>'
            ,'7C13CB1B-6C12-4119-B13D-7D466E914471'
            ,6
            ,0
            ,0
            ,'7/31/2018 0:00:00 AM')
END

-- ShowSummary SortOrder 7 
IF NOT EXISTS (SELECT * FROM ListUserDefinedControl WHERE UserDefinedControlUid = 'F53B86A9-F031-4B84-8BDA-AA1E72D65F22')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('F53B86A9-F031-4B84-8BDA-AA1E72D65F22'
            ,'ShowSummary'
            ,0
            ,'Show Summary Only'
            ,'71e67ced-b180-44e9-80c9-1ed3b47c9390'
            ,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>CHECKBOX</ControlType><Name>ShowSummary</Name><CheckedText>true</CheckedText><UnCheckedText>false</UnCheckedText><CheckedByDefault>false</CheckedByDefault></Control></UserDefinedControls>'
            ,'7C13CB1B-6C12-4119-B13D-7D466E914471'
            ,7
            ,0
            ,0
            ,'7/31/2018 0:00:00 AM')
END

-- ShowOnlyUnApplied SortOrder 8 
IF NOT EXISTS (SELECT * FROM ListUserDefinedControl WHERE UserDefinedControlUid = '13D7989A-57AC-453E-92F8-9FD1553B38AD')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('13D7989A-57AC-453E-92F8-9FD1553B38AD'
            ,'ShowOnlyUnApplied'
            ,0
            ,'Show Only Unapplied'
            ,'71e67ced-b180-44e9-80c9-1ed3b47c9390'
            ,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>CHECKBOX</ControlType><Name>ShowOnlyUnApplied</Name><CheckedText>true</CheckedText><UnCheckedText>false</UnCheckedText><CheckedByDefault>false</CheckedByDefault></Control></UserDefinedControls>'
            ,'7C13CB1B-6C12-4119-B13D-7D466E914471'
            ,8
            ,0
            ,0
            ,'7/31/2018 0:00:00 AM')
END
GO

-- #2401 Deposit Analysis report - 2401 Deposit Analysis migration script.sql
-- Deposit Analysis (was Deposit by Provider) 
-- Migration script
-- 20180919 kculberth Fix Bug 2401 Reports.  need to check in most current Deposits by provider to correct financial reporting issues
--DROP OLD ListUserDefinedControl entries
IF EXISTS (SELECT UserDefinedControlGroupUid from ListUserDefinedControl WHERE UserDefinedControlGroupUid='4DF4253F-7FF6-46BD-9BCB-2BAFD38EDF17')
    DELETE ListUserDefinedControl 
    WHERE UserDefinedControlGroupUid='4DF4253F-7FF6-46BD-9BCB-2BAFD38EDF17'


IF EXISTS (SELECT UserDefinedControlGroupUid from ListUserDefinedControl WHERE UserDefinedControlGroupUid='4DF4253F-7FF6-46BD-9BCB-2BAFD38EDF17')
    UPDATE ListUserDefinedControlGroup
    SET Name =  'Deposit Analysis'
    ,LastModifiedDate = '9/25/2018 00:00:00 AM'
    WHERE UserDefinedControlGroupUid='4DF4253F-7FF6-46BD-9BCB-2BAFD38EDF17'

-- SortOrder 0 Dates 
IF NOT EXISTS (SELECT * FROM ListUserDefinedControl WHERE UserDefinedControlUid = '54F8A84B-89DB-482F-B6B5-D17053141352')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('54F8A84B-89DB-482F-B6B5-D17053141352'
            ,'Date'
            ,0
            ,'Dates'
            ,'df87d0d5-bf48-49fb-abbc-cb75cc29eb64'
            ,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>DepositByProvider</Name><Uid>f2e52f89-7f2c-466a-a878-459f82fa12c9</Uid><Required>TRUE</Required></Control></UserDefinedControls>'
            ,'4DF4253F-7FF6-46BD-9BCB-2BAFD38EDF17'
            ,0
            ,0
            ,0
            ,'9/25/2018 00:00:00 AM')
END

-- SortOrder 1 Date Option
IF NOT EXISTS (SELECT * FROM ListUserDefinedControl WHERE UserDefinedControlUid = '07D36587-BF0E-4FC5-B4E1-E6391AEC495F')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('07D36587-BF0E-4FC5-B4E1-E6391AEC495F'
            ,'DateOption'
            ,0
            ,'Date Option'
            ,'8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
            ,'<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>DateOption</Name><ButtonLabel>Posting Date</ButtonLabel><ButtonValue>Posting</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>DateOption</Name><ButtonLabel>Deposit Date</ButtonLabel><ButtonValue>Deposit</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
            ,'4DF4253F-7FF6-46BD-9BCB-2BAFD38EDF17'
            ,1
            ,0
            ,0
            ,'9/25/2018 00:00:00 AM')
END

-- SortOrder 2 Providers 
IF NOT EXISTS (SELECT * FROM ListUserDefinedControl WHERE UserDefinedControlUid = '31150A2B-EEE8-4820-B58C-90D8BAAB1954')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('31150A2B-EEE8-4820-B58C-90D8BAAB1954'
            ,'ProviderUid'
            ,0
            ,'Providers'
            ,'8a957d7c-8b86-4a67-8336-b830c30fd123'
            ,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProviderUid</Name><SelectType>Multi</SelectType><Conjunction>or</Conjunction><EntryNameInFindTable>Provider</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewProvider</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
            ,'4DF4253F-7FF6-46BD-9BCB-2BAFD38EDF17'
            ,2
            ,0
            ,0
            ,'9/25/2018 00:00:00 AM')
END

-- SortOrder 3 Provider Option 
IF NOT EXISTS (SELECT * FROM ListUserDefinedControl WHERE UserDefinedControlUid = '7F7FF2E5-0E1B-47BD-8BE2-018E51D3C249')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('7F7FF2E5-0E1B-47BD-8BE2-018E51D3C249'
            ,'ProviderOption'
            ,0
            ,'Provider Option'
            ,'8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
            ,'<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Billing Providers</ButtonLabel><ButtonValue>Billing</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Rendering Providers</ButtonLabel><ButtonValue>Rendering</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
            ,'4DF4253F-7FF6-46BD-9BCB-2BAFD38EDF17'
            ,3
            ,0
            ,0
            ,'9/25/2018 00:00:00 AM')
END

-- SortOrder 4 Financial Centers
IF NOT EXISTS (SELECT * FROM ListUserDefinedControl WHERE UserDefinedControlUid = '0A50742F-FCC5-458B-8B38-EFD8F8EB8EFF')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('0A50742F-FCC5-458B-8B38-EFD8F8EB8EFF'
            ,'FinancialCenterUid'
            ,0
            ,'Financial Centers'
            ,'8a957d7c-8b86-4a67-8336-b830c30fd123'
            ,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>FinancialCenterUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Financial Center</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>FinancialCenter</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
            ,'4DF4253F-7FF6-46BD-9BCB-2BAFD38EDF17'
            ,4
            ,0
            ,0
            ,'9/25/2018 00:00:00 AM')
END

--SortOrder 5 Service Sites
IF NOT EXISTS (SELECT * FROM ListUserDefinedControl WHERE UserDefinedControlUid = 'D5ACAD02-CB77-4630-8D69-FC661EEDF69D')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('D5ACAD02-CB77-4630-8D69-FC661EEDF69D'
            ,'ServiceSiteUid'
            ,0
            ,'Service Sites'
            ,'8a957d7c-8b86-4a67-8336-b830c30fd123'
            ,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ServiceSiteUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Service Site</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListServiceSite</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
            ,'4DF4253F-7FF6-46BD-9BCB-2BAFD38EDF17'
            ,5
            ,0
            ,0
            ,'9/25/2018 00:00:00 AM')
END

-- SortOrder 6 Batch Owners
IF NOT EXISTS (SELECT * FROM ListUserDefinedControl WHERE UserDefinedControlUid = '8A239418-DF85-45FA-B3FE-100D08F131ED')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('8A239418-DF85-45FA-B3FE-100D08F131ED'
            ,'OwnerUid'
            ,0
            ,'Batch Owners'
            ,'8a957d7c-8b86-4a67-8336-b830c30fd123'
            ,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>OwnerUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>User</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewFindUser</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
            ,'4DF4253F-7FF6-46BD-9BCB-2BAFD38EDF17'
            ,6
            ,0
            ,0
            ,'9/25/2018 00:00:00 AM')
END

-- SortOrder 7 Batches
IF NOT EXISTS (SELECT * FROM ListUserDefinedControl WHERE UserDefinedControlUid = '852106A8-10DF-4FCE-8037-981A08AB870D')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('852106A8-10DF-4FCE-8037-981A08AB870D'
            ,'FinancialBatchUid'
            ,0
            ,'Batches'
            ,'8a957d7c-8b86-4a67-8336-b830c30fd123'
            ,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>FinancialBatchUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Batch</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewARBatch</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
            ,'4DF4253F-7FF6-46BD-9BCB-2BAFD38EDF17'
            ,7
            ,0
            ,0
            ,'9/25/2018 00:00:00 AM')
END


-- SortOrder 8 Group By
IF NOT EXISTS (SELECT * FROM ListUserDefinedControl WHERE UserDefinedControlUid = '7329E5F6-F562-4E08-BE36-00D30A71FFA7')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('7329E5F6-F562-4E08-BE36-00D30A71FFA7'
            ,'GroupByUid'
            ,0
            ,'Group By'
            ,'8a957d7c-8b86-4a67-8336-b830c30fd123'
            ,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>GroupBy</Name><SelectType>Single</SelectType><Conjunction>none</Conjunction><EntryNameInFindTable>Account Type Procedure</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>Account_Type_Procedure</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
            ,'4DF4253F-7FF6-46BD-9BCB-2BAFD38EDF17'
            ,8
            ,0
            ,0
            ,'9/25/2018 00:00:00 AM')
END
GO

-- #10971 Key Performance Indicators  10971 Key Performance Indicators migration script.sql
-- Migration Script - Key Performance Indicators 
-- 20181008 kculberth bug 10971 enhancements to the KPI report (need to add a Visit count to the report output between the claim count and the superbill count.                                
--                    change name of report from "KPI" to "Key Performance Indicators"
--                    make "Quarter" the default Date Option

--ListUserDefinedControl
--DateOption set default option to Quarter instead of Month
IF EXISTS (SELECT * FROM ListUserDefinedControl WHERE UserDefinedControlUid = '4BB8BB21-705A-4E80-8F6A-A9E0F49E1E99')
BEGIN
    update ListUserDefinedControl
    set ControlProperties =  '<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>DateOption</Name><ButtonLabel>Month</ButtonLabel><ButtonValue>Month</ButtonValue><Default>false</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>DateOption</Name><ButtonLabel>Quarter</ButtonLabel><ButtonValue>Quarter</ButtonValue><Default>true</Default></Control></Controls></UserDefinedControls>'   
    where UserDefinedControlUid = '4BB8BB21-705A-4E80-8F6A-A9E0F49E1E99'
END 

--ListReport
IF EXISTS (SELECT * FROM ListReport WHERE reportuid = 'CD7B12B9-0A31-44F0-98EA-2AA2C030F232')
BEGIN
    update listreport
    set LastModifiedDate = '10/08/2018 00:00:00 AM'
    ,ReportParameters = '<ReportParameters />'
    ,Name = 'Key Performance Indicators'
    where reportuid = 'CD7B12B9-0A31-44F0-98EA-2AA2C030F232'
END 

--ListReportRdl
IF EXISTS (SELECT * FROM ListReportRdl WHERE reportrdluid = '220C7816-EBDE-4477-84A2-049C58BC8D59')
BEGIN
    update ListReportRdl
    set LastModifiedDate = '10/08/2018 00:00:00 AM'
    ,Name = 'Key Performance Indicators'
    where reportrdluid = '220C7816-EBDE-4477-84A2-049C58BC8D59'
END
GO

-- #2405 #12309 Receipts Analysis migration.sql
-- Receipts Analysis
-- Migration script
-- 20180914 kculberth Fix Bug 2405 Reports.  need to check in most current Receipts Analysis to correct financial reporting issues
--                        User Story 12309 enhancements to receipts analysis
--DROP OLD ListUserDefinedControl entries
IF EXISTS (SELECT UserDefinedControlGroupUid from ListUserDefinedControl WHERE UserDefinedControlGroupUid='417238DF-D927-46B6-B689-D82A4B0C161A')
    DELETE ListUserDefinedControl 
    WHERE UserDefinedControlGroupUid='417238DF-D927-46B6-B689-D82A4B0C161A'

-- SortOrder 0 Timespan
IF NOT EXISTS (SELECT * FROM ListUserDefinedControl WHERE UserDefinedControlUid = 'ED170613-F690-45B4-8ABA-DDD929753129')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('ED170613-F690-45B4-8ABA-DDD929753129'
            ,'ReceiptsTimespan'
            ,0
            ,'Timespan'
            ,'df87d0d5-bf48-49fb-abbc-cb75cc29eb64'
            ,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>ReceiptsTimespan</Name><Uid>3863338d-160f-45d8-81c7-62738f3114d0</Uid><Required>TRUE</Required></Control></UserDefinedControls>'
            ,'417238DF-D927-46B6-B689-D82A4B0C161A'
            ,0
            ,0
            ,0
            ,'09/17/2018 00:00:00 AM')
END

-- SortOrder 1 Comparison Period
IF NOT EXISTS (SELECT * FROM ListUserDefinedControl WHERE UserDefinedControlUid = '75F513B5-E7E7-4721-84B6-E749163B6F31')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('75F513B5-E7E7-4721-84B6-E749163B6F31'
            ,'Comparison'
            ,0
            ,'Comparison Period'
            ,'df87d0d5-bf48-49fb-abbc-cb75cc29eb64'
            ,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>Comparison</Name><Uid>f2e52f89-7f2c-466a-a878-459f82fa12c9</Uid></Control></UserDefinedControls>'
            ,'417238DF-D927-46B6-B689-D82A4B0C161A'
            ,1
            ,0
            ,0
            ,'09/17/2018 00:00:00 AM')
END

-- SortOrder 2 Date Option
IF NOT EXISTS (SELECT * FROM ListUserDefinedControl WHERE UserDefinedControlUid = '1784950F-D7CD-4A9C-A3DD-1CB3029831FB')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('1784950F-D7CD-4A9C-A3DD-1CB3029831FB'
            ,'DateOption'
            ,0
            ,'Date Option'
            ,'8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
            ,'<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>DateOption</Name><ButtonLabel>Posting Date</ButtonLabel><ButtonValue>Posting</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>PostingDate</Name><ButtonLabel>Deposit Date</ButtonLabel><ButtonValue>Deposit</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
            ,'417238DF-D927-46B6-B689-D82A4B0C161A'
            ,2
            ,0
            ,0
            ,'09/17/2018 00:00:00 AM')
END

-- SortOrder 3 Providers
IF NOT EXISTS (SELECT * FROM ListUserDefinedControl WHERE UserDefinedControlUid = 'B97D05F1-4FC4-4F29-9789-A37E3EFEC63D')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('B97D05F1-4FC4-4F29-9789-A37E3EFEC63D'
            ,'ProviderUid'
            ,0
            ,'Providers'
            ,'8a957d7c-8b86-4a67-8336-b830c30fd123'
            ,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProviderUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Provider</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewProvider</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
            ,'417238DF-D927-46B6-B689-D82A4B0C161A'
            ,3
            ,0
            ,0
            ,'09/17/2018 00:00:00 AM')
END

-- SortOrder 4 Provider Option
IF NOT EXISTS (SELECT * FROM ListUserDefinedControl WHERE UserDefinedControlUid = '3783EFE5-9281-4E3E-B243-700AA876F625')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('3783EFE5-9281-4E3E-B243-700AA876F625'
            ,'ProviderOption'
            ,0
            ,'Provider Option'
            ,'8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
            ,'<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Billing Provider</ButtonLabel><ButtonValue>Billing</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Rendering Provider</ButtonLabel><ButtonValue>Rendering</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
            ,'417238DF-D927-46B6-B689-D82A4B0C161A'
            ,4
            ,0
            ,0
            ,'09/17/2018 00:00:00 AM')
END

-- SortOrder 5 Financial Centers
IF NOT EXISTS (SELECT * FROM ListUserDefinedControl WHERE UserDefinedControlUid = '5D6C7361-D37D-4A1D-8A6D-494E92377A70')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('5D6C7361-D37D-4A1D-8A6D-494E92377A70'
            ,'FinancialCenterUid'
            ,0
            ,'Financial Centers'
            ,'8a957d7c-8b86-4a67-8336-b830c30fd123'
            ,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>FinancialCenterUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Financial Center</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>FinancialCenter</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
            ,'417238DF-D927-46B6-B689-D82A4B0C161A'
            ,5
            ,0
            ,0
            ,'09/17/2018 00:00:00 AM')
END

-- SortOrder 6 Service Sites
IF NOT EXISTS (SELECT * FROM ListUserDefinedControl WHERE UserDefinedControlUid = 'E36BAFCE-0CF7-4456-8276-07125C60CD9A')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('E36BAFCE-0CF7-4456-8276-07125C60CD9A'
            ,'ServiceSiteUid'
            ,0
            ,'Service Sites'
            ,'8a957d7c-8b86-4a67-8336-b830c30fd123'
            ,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ServiceSiteUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Service Site</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListServiceSite</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
            ,'417238DF-D927-46B6-B689-D82A4B0C161A'
            ,6
            ,0
            ,0
            ,'09/17/2018 00:00:00 AM')
END
-- SortOrder 7 Payment Types
IF NOT EXISTS (SELECT * FROM ListUserDefinedControl WHERE UserDefinedControlUid = 'D4377ABA-FC24-4DBA-A2BA-772B5FF12D32')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('D4377ABA-FC24-4DBA-A2BA-772B5FF12D32'
            ,'PaymentTypeUid'
            ,0
            ,'Payment Types'
            ,'8a957d7c-8b86-4a67-8336-b830c30fd123'
            ,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>PaymentTypeUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Payment Type</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListPaymentType</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
            ,'417238DF-D927-46B6-B689-D82A4B0C161A'
            ,7
            ,0
            ,0
            ,'09/17/2018 00:00:00 AM')
END

-- SortOrder 8 Credit Types
IF NOT EXISTS (SELECT * FROM ListUserDefinedControl WHERE UserDefinedControlUid = 'DEDE944C-6BBF-49FD-9DC5-29654E26259A')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('DEDE944C-6BBF-49FD-9DC5-29654E26259A'
            ,'CreditTypeUid'
            ,0
            ,'Credit Types'
            ,'8a957d7c-8b86-4a67-8336-b830c30fd123'
            ,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>CreditTypeUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Transaction Types</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListCreditType</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
            ,'417238DF-D927-46B6-B689-D82A4B0C161A'
            ,8
            ,0
            ,0
            ,'09/17/2018 00:00:00 AM')
END

-- SortOrder 9 Results Option
IF NOT EXISTS (SELECT * FROM ListUserDefinedControl WHERE UserDefinedControlUid = '63BB377C-8C04-41FA-9C81-C8E93C66CFD7')
BEGIN
    INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
    VALUES('63BB377C-8C04-41FA-9C81-C8E93C66CFD7'
            ,'ResultsOption'
            ,0
            ,'Results Option'
            ,'8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
            ,'<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ResultsOption</Name><ButtonLabel>Payment Type</ButtonLabel><ButtonValue>PaymentType</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ResultsOption</Name><ButtonLabel>Credit Type</ButtonLabel><ButtonValue>CreditType</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
            ,'417238DF-D927-46B6-B689-D82A4B0C161A'
            ,9
            ,0
            ,0
            ,'09/17/2018 00:00:00 AM')
        END

GO