SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CMSCodeXml]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[CMSCodeXml](
	[FilePath] [varchar](max) NULL,
	[Measure] [varchar](10) NULL,
	[Content] [varbinary](max) NULL,
	[XMLContent] [xml] NULL
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverReplicate' , N'SCHEMA',N'dbo', N'TABLE',N'CreditCardErrorLog', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'CreditCardErrorLog'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CVXVISMap]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[CVXVISMap](
	[CVXVISMapUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_CVXVISMap_CVXVISMapUid]  DEFAULT (newid()),
	[CVXCode] [varchar](50) NOT NULL,
	[CVXVaccineDescr] [varchar](max) NOT NULL,
	[VISDocTypeDescr] [varchar](max) NOT NULL,
	[VISEditionDate] [date] NOT NULL,
	[VISEncodedString] [varchar](max) NOT NULL,
	[VISGDTIDocCode] [varchar](max) NOT NULL,
	[VISEditionStatus] [varchar](200) NOT NULL,
	[VISLastUpdatedDate] [date] NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_CVXVISMapping_Inactive]  DEFAULT ((0)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_CVXVISMap_UserDefined]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_CVXVISMapping_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ForcedUploadProcessOrder' , N'SCHEMA',N'dbo', N'TABLE',N'eRxOutbound', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.ForcedUploadProcessOrder' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'eRxOutbound'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Patient' , N'SCHEMA',N'dbo', N'TABLE',N'eRxOutbound', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.Patient' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'eRxOutbound'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Provider' , N'SCHEMA',N'dbo', N'TABLE',N'eRxOutbound', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.Provider' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'eRxOutbound'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ForcedUploadProcessOrder' , N'SCHEMA',N'dbo', N'TABLE',N'eRxOutbound', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.ForcedUploadProcessOrder', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'eRxOutbound'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Patient' , N'SCHEMA',N'dbo', N'TABLE',N'eRxOutbound', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'{*FK_eRxOutbound_Visit,FK_eRxOutbound_SIGDetail,FK_eRxOutbound_RelVisitMedication,FK_MessageERxRefillRequest_eRxOutbound,FK_MessageRx_eRxOutbound}' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'eRxOutbound'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Provider' , N'SCHEMA',N'dbo', N'TABLE',N'eRxOutbound', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.Provider', @value=N'!FK_eRxOutbound_Provider' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'eRxOutbound'
GO
BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'HIEPatient' AND COLUMN_NAME = 'PatientId')
ALTER TABLE [HIEPatient]  ALTER COLUMN [PatientId] varchar(max) NULL 
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[HIEPatient]') AND name = 'HasNewDocuments')
    ALTER TABLE [HIEPatient] ADD [HasNewDocuments] bit NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[HIEPatient]') AND name = 'ProviderUid')
    ALTER TABLE [HIEPatient] ADD [ProviderUid] uniqueidentifier NULL 
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[HIEPatientDocument]') AND name = 'Completed')
    ALTER TABLE [HIEPatientDocument] ADD [Completed] bit NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[HIEPatientDocument]') AND name = 'Name')
    ALTER TABLE [HIEPatientDocument] ADD [Name] varchar(max) NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[HIEPatientDocument]') AND name = 'DocumentType')
    ALTER TABLE [HIEPatientDocument] ADD [DocumentType] varchar(max) NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[HIEPatientDocument]') AND name = 'Url')
    ALTER TABLE [HIEPatientDocument] ADD [Url] varchar(max) NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[HIEPatientDocument]') AND name = 'ProviderUid')
    ALTER TABLE [HIEPatientDocument] ADD [ProviderUid] uniqueidentifier NULL 
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ImmunizationHistory]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ImmunizationHistory](
	[ImmunizationHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ImmunizationHistory_ImmunizationHistoryUid]  DEFAULT (newid()),
	[PatientUid] [uniqueidentifier] NOT NULL,
	[VaccineUid] [uniqueidentifier] NULL,
	[VaccineName] [varchar](255) NULL,
	[TypeofVaccineUid] [uniqueidentifier] NULL,
	[TypeofVaccineName] [varchar](255) NULL,
	[VaccineDose] [varchar](50) NULL,
	[VaccineUnits] [varchar](60) NULL,
	[AdministeredDateTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[AdministeredDateName] [varchar](255) NULL,
	[VaccineSiteUid] [uniqueidentifier] NULL,
	[VaccineSiteName] [varchar](255) NULL,
	[VaccineRouteUid] [uniqueidentifier] NULL,
	[VaccineRouteName] [varchar](255) NULL,
	[VaccineFundingSourceUid] [uniqueidentifier] NULL,
	[VaccineFundingSourceName] [varchar](255) NULL,
	[VFCEligibilityUid] [uniqueidentifier] NULL,
	[DateOnVIS] [date] NULL,
	[DateOnVISName] [varchar](255) NULL,
	[ExpirationDate] [date] NULL,
	[ExpirationDateName] [varchar](255) NULL,
	[VaccineMfrUid] [uniqueidentifier] NULL,
	[VaccineMfrName] [varchar](255) NULL,
	[VaccineLotNo] [varchar](255) NULL,
	[DateVISGiven] [date] NULL,
	[DateVISGivenName] [varchar](255) NULL,
	[Initials] [varchar](255) NULL,
	[Notes] [varchar](max) NULL,
	[VisitProcedureUid] [uniqueidentifier] NULL,
	[VaccinatorUid] [uniqueidentifier] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[ImmzHistorySourceUid] [uniqueidentifier] NULL,
	[ImmzReminderRecallUid] [uniqueidentifier] NULL,
	[ImmzRefusalUid] [uniqueidentifier] NULL,
	[ImmzCompletionUid] [uniqueidentifier] NULL,
	[ImmzReactionUid] [uniqueidentifier] NULL,
	[PatientRefused] [bit] NOT NULL CONSTRAINT [DF_ImmunizationHistory_PatientRefused_1]  DEFAULT ((0)),
	[ImedicaAccessionNumber] [varchar](25) NULL,
	[OriginCreateTime] [datetime] NULL,
	[InactiveDate] [date] NULL,
	[IsDelete] [bit] NOT NULL CONSTRAINT [DF_ImmunizationHistory_IsDelete_1]  DEFAULT ((0)),
	[HistoryAdministeredDate] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[HistoryAdministeredFuzzyDate] [date] NULL,
	[VXUSentDateTime] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ImmunizationHistory_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'AdministeredDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ImmunizationHistory', @level2type=N'COLUMN',@level2name=N'AdministeredDateTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Orignal Create Time' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ImmunizationHistory', @level2type=N'COLUMN',@level2name=N'OriginCreateTime'
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'InactiveTime' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ImmunizationHistory', @level2type=N'COLUMN',@level2name=N'InactiveDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date & time the ImmunizationHistory row data was sent to the VXU HL7Partner' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ImmunizationHistory', @level2type=N'COLUMN',@level2name=N'VXUSentDateTime'


END
Truncate Table migtemp_ImmunizationHistory
INSERT [migtemp_ImmunizationHistory]([ImmunizationHistoryUid],[PatientUid],[VaccineUid],[VaccineName],[TypeofVaccineUid],[TypeofVaccineName],[VaccineDose],[VaccineUnits],[AdministeredDateTime],[AdministeredDateName],[VaccineSiteUid],[VaccineSiteName],[VaccineRouteUid],[VaccineRouteName],[VaccineFundingSourceUid],[VaccineFundingSourceName],[VFCEligibilityUid],[DateOnVIS],[DateOnVISName],[ExpirationDate],[ExpirationDateName],[VaccineMfrUid],[VaccineMfrName],[VaccineLotNo],[DateVISGiven],[DateVISGivenName],[Initials],[Notes],[VisitProcedureUid],[VaccinatorUid],[VisitUid],[ImmzHistorySourceUid],[ImmzReminderRecallUid],[ImmzRefusalUid],[ImmzCompletionUid],[ImmzReactionUid],[PatientRefused],[ImedicaAccessionNumber],[OriginCreateTime],[InactiveDate],[IsDelete],[HistoryAdministeredDate],[HistoryAdministeredFuzzyDate],[LastModifiedByUid],[LastModifiedDate])
SELECT [ImmunizationHistoryUid],[PatientUid],[VaccineUid],[VaccineName],[TypeofVaccineUid],[TypeofVaccineName],[VaccineDose],[VaccineUnits],[AdministeredDateTime],[AdministeredDateName],[VaccineSiteUid],[VaccineSiteName],[VaccineRouteUid],[VaccineRouteName],[VaccineFundingSourceUid],[VaccineFundingSourceName],[VFCEligibilityUid],[DateOnVIS],[DateOnVISName],[ExpirationDate],[ExpirationDateName],[VaccineMfrUid],[VaccineMfrName],[VaccineLotNo],[DateVISGiven],[DateVISGivenName],[Initials],[Notes],[VisitProcedureUid],[VaccinatorUid],[VisitUid],[ImmzHistorySourceUid],[ImmzReminderRecallUid],[ImmzRefusalUid],[ImmzCompletionUid],[ImmzReactionUid],[PatientRefused],[ImedicaAccessionNumber],[OriginCreateTime],[InactiveDate],[IsDelete],CONVERT(nvarchar(max), [HistoryAdministeredDate]),[HistoryAdministeredFuzzyDate],[LastModifiedByUid],[LastModifiedDate]
FROM [ImmunizationHistory]

DROP TABLE [ImmunizationHistory]

exec  sp_rename 'migtemp_ImmunizationHistory', 'ImmunizationHistory'

exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[LaboratoryLocation]') AND name = 'OID')
    ALTER TABLE [LaboratoryLocation] ADD [OID] varchar(100) NULL 
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListDiagnosis]') AND name = 'LexicalCode')
    ALTER TABLE [ListDiagnosis] ADD [LexicalCode] int NULL 
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListGenderIdentity]') AND name = 'conceptId')
    ALTER TABLE [ListGenderIdentity] ADD [conceptId] varchar(100) NULL 
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ListLOINC' AND COLUMN_NAME = 'Name')
ALTER TABLE [ListLOINC]  ALTER COLUMN [Name] varchar(50) NOT NULL 
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ListLOINC' AND COLUMN_NAME = 'COMPONENT')
ALTER TABLE [ListLOINC]  ALTER COLUMN [COMPONENT] varchar(150) NOT NULL 
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ListLOINC' AND COLUMN_NAME = 'SYSTEM')
ALTER TABLE [ListLOINC]  ALTER COLUMN [SYSTEM] varchar(100) NULL 
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ListLOINC' AND COLUMN_NAME = 'CLASS')
ALTER TABLE [ListLOINC]  ALTER COLUMN [CLASS] varchar(50) NULL 
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ListLOINC' AND COLUMN_NAME = 'STATUS')
ALTER TABLE [ListLOINC]  ALTER COLUMN [STATUS] varchar(50) NULL 
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ListLOINC' AND COLUMN_NAME = 'MAP_TO')
ALTER TABLE [ListLOINC]  ALTER COLUMN [MAP_TO] varchar(50) NULL 
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ListLOINC' AND COLUMN_NAME = 'EX_US_UNITS')
ALTER TABLE [ListLOINC]  ALTER COLUMN [EX_US_UNITS] varchar(50) NULL 
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ListLOINC' AND COLUMN_NAME = 'RelatedNames2')
ALTER TABLE [ListLOINC]  ALTER COLUMN [RelatedNames2] varchar(max) NULL 
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListMedication]') AND name = 'medid')
    ALTER TABLE [ListMedication] ADD [medid] int NOT NULL CONSTRAINT DF_ListMedication_medid DEFAULT ((0)) 
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListMessageType]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListMessageType](
	[MessageTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_MessageType_MessageTypeUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListMessageType_Inactive]  DEFAULT ((0)),
	[CompleteInMinutes] [int] NULL,
	[Notes] [varchar](max) NULL,
	[Color] [int] NOT NULL CONSTRAINT [DF_ListMessageType_Color]  DEFAULT ((0)),
	[AssemblyQualifiedName] [varchar](255) NOT NULL,
	[HeaderAQN] [varchar](255) NULL,
	[TabPagesAQN] [xml] NULL,
	[AQN] [xml](CONTENT [dbo].[ListMessageTypeAQN]) NULL,
	[ConfigurationXML] [xml] NULL,
	[MessageDataXMLType] [varchar](100) NULL,
	[LoadStoredProcedure] [varchar](255) NULL,
	[UserCreatable] [bit] NOT NULL CONSTRAINT [DF_ListMessageType_UserCreatable]  DEFAULT ((1)),
	[PatientNewMenu] [bit] NOT NULL CONSTRAINT [DF_ListMessageType_PatientNewMenu]  DEFAULT ((0)),
	[IconIndex] [smallint] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListMessageType_UserDefined]  DEFAULT ((1)),
	[DisplayOrder] [smallint] NOT NULL CONSTRAINT [DF_ListMessageType_DisplayOrder]  DEFAULT ((0)),
	[OrderActionTemplateXml] [xml] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MessageType_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Message types' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListMessageType'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListMessageType'


END
Truncate Table migtemp_ListMessageType
INSERT [migtemp_ListMessageType]([MessageTypeUid],[ExternalID],[Name],[Inactive],[CompleteInMinutes],[Notes],[Color],[AssemblyQualifiedName],[HeaderAQN],[TabPagesAQN],[AQN],[ConfigurationXML],[LoadStoredProcedure],[UserCreatable],[PatientNewMenu],[IconIndex],[UserDefined],[DisplayOrder],[OrderActionTemplateXml],[LastModifiedDate],[LastModifiedByUid])
SELECT [MessageTypeUid],[ExternalID],[Name],[Inactive],[CompleteInMinutes],[Notes],[Color],[AssemblyQualifiedName],[HeaderAQN],CONVERT(nvarchar(max), [TabPagesAQN]),CONVERT(nvarchar(max), [AQN]),CONVERT(nvarchar(max), [ConfigurationXML]),[LoadStoredProcedure],[UserCreatable],[PatientNewMenu],[IconIndex],[UserDefined],[DisplayOrder],CONVERT(nvarchar(max), [OrderActionTemplateXml]),[LastModifiedDate],[LastModifiedByUid]
FROM [ListMessageType]

DROP TABLE [ListMessageType]

exec  sp_rename 'migtemp_ListMessageType', 'ListMessageType'

exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ListObservationItem' AND COLUMN_NAME = 'Name')
ALTER TABLE [ListObservationItem]  ALTER COLUMN [Name] varchar(255) NOT NULL 
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListPharmacy]') AND name = 'Computed_Address1_Address1')
    ALTER TABLE [ListPharmacy] ADD [Computed_Address1_Address1] varchar(100) NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListPharmacy]') AND name = 'Computed_Address1_Address2')
    ALTER TABLE [ListPharmacy] ADD [Computed_Address1_Address2] varchar(100) NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListPharmacy]') AND name = 'Computed_Address1_City')
    ALTER TABLE [ListPharmacy] ADD [Computed_Address1_City] varchar(35) NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListPharmacy]') AND name = 'Computed_Address1_State')
    ALTER TABLE [ListPharmacy] ADD [Computed_Address1_State] varchar(3) NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListPharmacy]') AND name = 'Computed_Address1_Zip')
    ALTER TABLE [ListPharmacy] ADD [Computed_Address1_Zip] varchar(10) NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListPharmacy]') AND name = 'Computed_Phone1_PhoneNumber')
    ALTER TABLE [ListPharmacy] ADD [Computed_Phone1_PhoneNumber] varchar(80) NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListPharmacy]') AND name = 'Computed_Phone1_PhoneType')
    ALTER TABLE [ListPharmacy] ADD [Computed_Phone1_PhoneType] varchar(50) NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListPharmacy]') AND name = 'Computed_Phone2_PhoneNumber')
    ALTER TABLE [ListPharmacy] ADD [Computed_Phone2_PhoneNumber] varchar(80) NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListPharmacy]') AND name = 'Computed_Phone2_PhoneType')
    ALTER TABLE [ListPharmacy] ADD [Computed_Phone2_PhoneType] varchar(50) NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListPharmacy]') AND name = 'Computed_Phone3_PhoneNumber')
    ALTER TABLE [ListPharmacy] ADD [Computed_Phone3_PhoneNumber] varchar(80) NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListPharmacy]') AND name = 'Computed_Phone3_PhoneType')
    ALTER TABLE [ListPharmacy] ADD [Computed_Phone3_PhoneType] varchar(50) NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListPharmacy]') AND name = 'Computed_Address1_StreetAddress')
    ALTER TABLE [ListPharmacy] ADD [Computed_Address1_StreetAddress] varchar(200) NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListPharmacy]') AND name = 'Computed_Address1_Country')
    ALTER TABLE [ListPharmacy] ADD [Computed_Address1_Country] varchar(50) NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListPharmacy]') AND name = 'Computed_Phone1_Scrubbed')
    ALTER TABLE [ListPharmacy] ADD [Computed_Phone1_Scrubbed] varchar(80) NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListPharmacy]') AND name = 'Computed_Phone2_Scrubbed')
    ALTER TABLE [ListPharmacy] ADD [Computed_Phone2_Scrubbed] varchar(80) NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListPharmacy]') AND name = 'Computed_Phone3_Scrubbed')
    ALTER TABLE [ListPharmacy] ADD [Computed_Phone3_Scrubbed] varchar(80) NULL 
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ListSexualOrientation]') AND name = 'conceptId')
    ALTER TABLE [ListSexualOrientation] ADD [conceptId] varchar(100) NULL 
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListTypeofVaccine]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListTypeofVaccine](
	[TypeofVaccineUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_ListTypeofVaccine_TypeofVaccineUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListTypeofVaccine_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NULL,
	[Recurring] [bit] NULL CONSTRAINT [DF_ListTypeofVaccine_Recurring]  DEFAULT ((0)),
	[ComparerUid] [uniqueidentifier] NULL,
	[PeriodUid] [uniqueidentifier] NULL,
	[RouteUid] [uniqueidentifier] NULL,
	[SiteGivenUid] [uniqueidentifier] NULL,
	[SourceUid] [uniqueidentifier] NULL,
	[LotNo] [varchar](100) NULL,
	[ExpirationDate] [date] NULL,
	[DateOnVIS] [date] NULL,
	[ManufacturerUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListTypeofVaccine_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[NonImmunization] [bit] NOT NULL CONSTRAINT [DF_ListTypeofVaccine_NonImmunization]  DEFAULT ((0)),
	[CVXCodeUid] [uniqueidentifier] NULL,
	[CVXCodeUnspecifiedUid] [uniqueidentifier] NULL,
	[CVXVISMapUid] [uniqueidentifier] NULL,
	[VaccineUnitUseUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListTypeofVaccine_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'type of vaccine id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListTypeofVaccine', @level2type=N'COLUMN',@level2name=N'TypeofVaccineUid'
EXEC sys.sp_addextendedproperty @name=N'iforeignkey', @value=N'RelTypeofVaccineTypeofVaccineElement;RelProcedureTypeofVaccine;TypeofVaccineDefault;RelVaccineTypeofVaccine' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListTypeofVaccine'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListTypeofVaccine'


END
Truncate Table migtemp_ListTypeofVaccine
INSERT [migtemp_ListTypeofVaccine]([TypeofVaccineUid],[ExternalID],[Inactive],[Name],[Recurring],[ComparerUid],[PeriodUid],[RouteUid],[SiteGivenUid],[SourceUid],[LotNo],[ExpirationDate],[DateOnVIS],[ManufacturerUid],[UserDefined],[Notes],[NonImmunization],[CVXCodeUid],[CVXCodeUnspecifiedUid],[LastModifiedByUid],[LastModifiedDate])
SELECT [TypeofVaccineUid],[ExternalID],[Inactive],[Name],[Recurring],[ComparerUid],[PeriodUid],[RouteUid],[SiteGivenUid],[SourceUid],[LotNo],[ExpirationDate],[DateOnVIS],[ManufacturerUid],[UserDefined],[Notes],[NonImmunization],[CVXCodeUid],[CVXCodeUnspecifiedUid],[LastModifiedByUid],[LastModifiedDate]
FROM [ListTypeofVaccine]

DROP TABLE [ListTypeofVaccine]

exec  sp_rename 'migtemp_ListTypeofVaccine', 'ListTypeofVaccine'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListUserSetting]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListUserSetting](
	[UserSettingUid] [uniqueidentifier] NOT NULL CONSTRAINT [DF_ListUserSetting_UserSettingUid]  DEFAULT (newid()),
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_Inactive]  DEFAULT ((0)),
	[Name] [varchar](100) NOT NULL,
	[ClinicCenterUid] [uniqueidentifier] NULL,
	[ClinicalNoteTypes] [xml](CONTENT [dbo].[UidList]) NULL,
	[FormattingTemplateUid] [uniqueidentifier] NULL,
	[NoteSingleColumn] [nchar](10) NULL,
	[MinWidth] [int] NOT NULL CONSTRAINT [DF_ListUserSetting_MinWidth_1]  DEFAULT ((100)),
	[FontSize] [float] NOT NULL CONSTRAINT [DF_ListUserSetting_FontSize_1]  DEFAULT ((10.0)),
	[UseNewOPSRPN] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_UseNewOPSRPN_1]  DEFAULT ((1)),
	[AttachmentAddIns] [xml](CONTENT [dbo].[UidList]) NULL,
	[PatientDemographicAddIns] [xml](CONTENT [dbo].[UidList]) NULL,
	[NoteAddIns] [xml](CONTENT [dbo].[UidList]) NULL,
	[AppointmentNoteAddIn] [xml] NULL,
	[VitalsAddIns] [xml](CONTENT [dbo].[UidList]) NULL,
	[PatientToolbarAddIns] [xml](CONTENT [dbo].[UidList]) NULL,
	[DesktopAddIns] [xml](CONTENT [dbo].[UidList]) NULL,
	[AppointmentAddIns] [xml](CONTENT [dbo].[UidList]) NULL,
	[SuperbillChargeProcessorAddInUid] [uniqueidentifier] NULL,
	[ServiceProcedureAddInUid] [uniqueidentifier] NULL,
	[VisitSaveAddInUid] [uniqueidentifier] NULL,
	[PatientDemographicsPrint] [xml](CONTENT [dbo].[UidList]) NULL,
	[NotePrint] [xml](CONTENT [dbo].[UidList]) NULL,
	[OPSPrint] [xml](CONTENT [dbo].[UidList]) NULL,
	[RPNPrint] [xml](CONTENT [dbo].[UidList]) NULL,
	[PatientPrint] [xml](CONTENT [dbo].[UidList]) NULL,
	[JobEngineStatus] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_JobEngineStatus_1]  DEFAULT ((0)),
	[MasterServerStatus] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_MasterServerStatus]  DEFAULT ((0)),
	[CacheServerStatus] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_CacheServerStatus_1]  DEFAULT ((0)),
	[AutoCapitalization] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_AutoCapitalization_1]  DEFAULT ((1)),
	[AutoComplete] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_AutoComplete_1]  DEFAULT ((1)),
	[TryDelete] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_TryDelete_1]  DEFAULT ((1)),
	[VoiceRecording] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_VoiceRecording_1]  DEFAULT ((1)),
	[InkInput] [smallint] NOT NULL CONSTRAINT [DF_ListUserSetting_InkInput_1]  DEFAULT ((0)),
	[DockingStyle] [smallint] NOT NULL CONSTRAINT [DF_ListUserSetting_DockingStyle_1]  DEFAULT ((0)),
	[StartupSound] [varchar](255) NULL,
	[SelectionColor] [xml](CONTENT [dbo].[SelectionColor]) NULL,
	[RequiredColor] [xml](CONTENT [dbo].[SelectionColor]) NULL,
	[PatientInputColor] [xml](CONTENT [dbo].[SelectionColor]) NULL,
	[BorderColor] [xml](CONTENT [dbo].[SelectionColor]) NULL,
	[AllowCPO] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_AllowCPO_1]  DEFAULT ((0)),
	[AutoCheckCPOGeneration] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_AutoCheckCPOGeneration]  DEFAULT ((0)),
	[WarnOnCancelNote] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_WarnOnCancelNote_1]  DEFAULT ((1)),
	[UserDefined] [tinyint] NOT NULL CONSTRAINT [DF_ListUserSetting_UserDefined]  DEFAULT ((1)),
	[Notes] [varchar](max) NULL,
	[MaximizeForms] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_MaximizeForms]  DEFAULT ((0)),
	[BackgroundSave] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_BackgroundSave]  DEFAULT ((1)),
	[UseNewOPS] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_UseNewOPS]  DEFAULT ((0)),
	[DisplayPrinterDialog] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_DisplayRxPrinterDialog]  DEFAULT ((0)),
	[ProcessHMRulesOnNoteSave] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_ProcessHMRulesOnNoteSave_1]  DEFAULT ((1)),
	[CheckoutPlanTemplateUid] [uniqueidentifier] NULL,
	[RPNPrintButtonUid] [uniqueidentifier] NULL,
	[OPSPrintButtonUid] [uniqueidentifier] NULL,
	[RxConsentFormattingTemplateUid] [uniqueidentifier] NULL,
	[RxConsentAttachmentTypeUid] [uniqueidentifier] NULL,
	[RxConsentMedication] [xml](CONTENT [dbo].[UidList]) NULL,
	[StandardHistoryDisplay] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_StandardHistoryDisplay]  DEFAULT ((0)),
	[OtherSettings] [xml] NULL,
	[ShowRVUSearchingCPTUid] [uniqueidentifier] NULL,
	[IncludeEMInMFU] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_IncludeEMInMFU_1]  DEFAULT ((0)),
	[MultiWindow] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_MultiWindow_1]  DEFAULT ((1)),
	[CheckoutEducationForm] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_CheckoutEducationForm]  DEFAULT ((0)),
	[CheckoutVisitReceipt] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_CheckoutVisitReceipt]  DEFAULT ((0)),
	[CheckoutSuperbill] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_CheckoutSuperbill]  DEFAULT ((0)),
	[CheckoutUncheckAll] [bit] NOT NULL CONSTRAINT [DF_ListUserSetting_CheckoutUncheckAll]  DEFAULT ((0)),
	[EditorFont] [xml] NULL,
	[FncCompleteNoteValidatorAddIns] [xml](CONTENT [dbo].[UidList]) NULL,
	[KdbConfigurationUid] [uniqueidentifier] NULL,
	[ReceiveCDASectionUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_ListUserSetting_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]



END
Truncate Table migtemp_ListUserSetting
INSERT [migtemp_ListUserSetting]([UserSettingUid],[ExternalID],[Inactive],[Name],[ClinicCenterUid],[ClinicalNoteTypes],[FormattingTemplateUid],[NoteSingleColumn],[MinWidth],[FontSize],[UseNewOPSRPN],[AttachmentAddIns],[PatientDemographicAddIns],[NoteAddIns],[AppointmentNoteAddIn],[VitalsAddIns],[PatientToolbarAddIns],[DesktopAddIns],[AppointmentAddIns],[SuperbillChargeProcessorAddInUid],[ServiceProcedureAddInUid],[VisitSaveAddInUid],[PatientDemographicsPrint],[NotePrint],[OPSPrint],[RPNPrint],[PatientPrint],[JobEngineStatus],[MasterServerStatus],[CacheServerStatus],[AutoCapitalization],[AutoComplete],[TryDelete],[VoiceRecording],[InkInput],[DockingStyle],[StartupSound],[SelectionColor],[RequiredColor],[PatientInputColor],[BorderColor],[AllowCPO],[AutoCheckCPOGeneration],[WarnOnCancelNote],[UserDefined],[Notes],[MaximizeForms],[BackgroundSave],[UseNewOPS],[DisplayPrinterDialog],[ProcessHMRulesOnNoteSave],[CheckoutPlanTemplateUid],[RPNPrintButtonUid],[OPSPrintButtonUid],[RxConsentFormattingTemplateUid],[RxConsentAttachmentTypeUid],[RxConsentMedication],[StandardHistoryDisplay],[OtherSettings],[ShowRVUSearchingCPTUid],[IncludeEMInMFU],[MultiWindow],[CheckoutEducationForm],[CheckoutVisitReceipt],[CheckoutSuperbill],[CheckoutUncheckAll],[EditorFont],[FncCompleteNoteValidatorAddIns],[KdbConfigurationUid],[LastModifiedByUid],[LastModifiedDate])
SELECT [UserSettingUid],[ExternalID],[Inactive],[Name],[ClinicCenterUid],CONVERT(nvarchar(max), [ClinicalNoteTypes]),[FormattingTemplateUid],[NoteSingleColumn],[MinWidth],[FontSize],[UseNewOPSRPN],CONVERT(nvarchar(max), [AttachmentAddIns]),CONVERT(nvarchar(max), [PatientDemographicAddIns]),CONVERT(nvarchar(max), [NoteAddIns]),CONVERT(nvarchar(max), [AppointmentNoteAddIn]),CONVERT(nvarchar(max), [VitalsAddIns]),CONVERT(nvarchar(max), [PatientToolbarAddIns]),CONVERT(nvarchar(max), [DesktopAddIns]),CONVERT(nvarchar(max), [AppointmentAddIns]),[SuperbillChargeProcessorAddInUid],[ServiceProcedureAddInUid],[VisitSaveAddInUid],CONVERT(nvarchar(max), [PatientDemographicsPrint]),CONVERT(nvarchar(max), [NotePrint]),CONVERT(nvarchar(max), [OPSPrint]),CONVERT(nvarchar(max), [RPNPrint]),CONVERT(nvarchar(max), [PatientPrint]),[JobEngineStatus],[MasterServerStatus],[CacheServerStatus],[AutoCapitalization],[AutoComplete],[TryDelete],[VoiceRecording],[InkInput],[DockingStyle],[StartupSound],CONVERT(nvarchar(max), [SelectionColor]),CONVERT(nvarchar(max), [RequiredColor]),CONVERT(nvarchar(max), [PatientInputColor]),CONVERT(nvarchar(max), [BorderColor]),[AllowCPO],[AutoCheckCPOGeneration],[WarnOnCancelNote],[UserDefined],[Notes],[MaximizeForms],[BackgroundSave],[UseNewOPS],[DisplayPrinterDialog],[ProcessHMRulesOnNoteSave],[CheckoutPlanTemplateUid],[RPNPrintButtonUid],[OPSPrintButtonUid],[RxConsentFormattingTemplateUid],[RxConsentAttachmentTypeUid],CONVERT(nvarchar(max), [RxConsentMedication]),[StandardHistoryDisplay],CONVERT(nvarchar(max), [OtherSettings]),[ShowRVUSearchingCPTUid],[IncludeEMInMFU],[MultiWindow],[CheckoutEducationForm],[CheckoutVisitReceipt],[CheckoutSuperbill],[CheckoutUncheckAll],CONVERT(nvarchar(max), [EditorFont]),CONVERT(nvarchar(max), [FncCompleteNoteValidatorAddIns]),[KdbConfigurationUid],[LastModifiedByUid],[LastModifiedDate]
FROM [ListUserSetting]

DROP TABLE [ListUserSetting]

exec  sp_rename 'migtemp_ListUserSetting', 'ListUserSetting'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_Message]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_Message](
	[MessageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_Message_MessageUid]  DEFAULT (newid()),
	[ParentMessageUid] [uniqueidentifier] NULL,
	[CreatedByUid] [uniqueidentifier] NULL,
	[PersonUid] [uniqueidentifier] NULL,
	[MessageTypeUid] [uniqueidentifier] NOT NULL,
	[MessageSubTypeUid] [uniqueidentifier] NULL,
	[Header] [varchar](8000) NULL,
	[MessageUrgencyUid] [uniqueidentifier] NULL,
	[MessageStatusUid] [uniqueidentifier] NULL,
	[CreatedDate] [date] NOT NULL CONSTRAINT [DF_Message_CreatedDate]  DEFAULT (getdate()),
	[CreatedDateTime] [datetime] NOT NULL CONSTRAINT [DF_Message_DateCreated]  DEFAULT (getutcdate()),
	[DateToBeCompleted] [datetime] NULL,
	[AutoComplete] [bit] NOT NULL CONSTRAINT [DF_Message_AutoComplete]  DEFAULT ((0)),
	[DateCompleted] [datetime] NULL,
	[LastReadByUid] [uniqueidentifier] NULL,
	[CompletedByUid] [uniqueidentifier] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[StrikeOut] [bit] NOT NULL CONSTRAINT [DF_Message_StrikeOut_1]  DEFAULT ((0)),
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_Msgs_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[MessageDataXML] [xml] NULL,
	[FirstReadDate] [datetime] NULL,
	[MessageXML] [xml] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the guid of the message' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'MessageUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the guid of the message that is the parent. This is used when a message is split into multiple messages. Each of the new messages will have its parent set to the message from which it originated.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'ParentMessageUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the person that created the message' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'CreatedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the patient with whom  the message is associated' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'PersonUid'
EXEC sys.sp_addextendedproperty @name=N'ClassMap', @value=N'<query table=''ListMessageType'' name=''Name'' key=''MessageTypeUid'' MessageDataXML=''MessageDataXmlType''/>' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'MessageTypeUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the type of the message' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'MessageTypeUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the string used to display the message in a list' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'Header'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the urgency of the message' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'MessageUrgencyUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the status of the message. A message that is completed can be archived.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'MessageStatusUid'
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'DateCreated' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'CreatedDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the (UTC) date and time the message was created' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'CreatedDateTime'
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'DateCreated' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'CreatedDateTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the (UTC) date and time the message was completed' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'DateCompleted'
EXEC sys.sp_addextendedproperty @name=N'Replication.LimitContentSizeSelectByValueOf', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'DateCompleted'
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'DateCompleted'
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'CompletedByUid'
EXEC sys.sp_addextendedproperty @name=N'Type', @value=N'object' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message', @level2type=N'COLUMN',@level2name=N'MessageDataXML'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Table that stores message envelopes. The context of a message is stored in a separate table, e.g. MessageTask or MessageRx' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message'
EXEC sys.sp_addextendedproperty @name=N'Replication.IgnoreConflictColumns', @value=N'DateCompleted,LastReadByUid,CompletedByUid' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message'
EXEC sys.sp_addextendedproperty @name=N'Replication.Lock', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message'
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'FK_Message_Person' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message'
EXEC sys.sp_addextendedproperty @name=N'Replication.RootTableOfNonAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Message'


END
Truncate Table migtemp_Message
INSERT [migtemp_Message]([MessageUid],[ParentMessageUid],[CreatedByUid],[PersonUid],[MessageTypeUid],[MessageSubTypeUid],[Header],[MessageUrgencyUid],[MessageStatusUid],[CreatedDate],[CreatedDateTime],[DateToBeCompleted],[AutoComplete],[DateCompleted],[LastReadByUid],[CompletedByUid],[VisitUid],[StrikeOut],[LastModifiedDate],[LastModifiedByUid],[MessageDataXML],[FirstReadDate])
SELECT [MessageUid],[ParentMessageUid],[CreatedByUid],[PersonUid],[MessageTypeUid],[MessageSubTypeUid],[Header],[MessageUrgencyUid],[MessageStatusUid],[CreatedDate],[CreatedDateTime],[DateToBeCompleted],[AutoComplete],[DateCompleted],[LastReadByUid],[CompletedByUid],[VisitUid],[StrikeOut],[LastModifiedDate],[LastModifiedByUid],CONVERT(nvarchar(max), [MessageDataXML]),[FirstReadDate]
FROM [Message]

DROP TABLE [Message]

exec  sp_rename 'migtemp_Message', 'Message'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_MessageAA]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_MessageAA](
	[MessageUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[RelAttachmentGroupUid] [uniqueidentifier] NULL,
	[VoiceAttachmentUid] [uniqueidentifier] NULL,
	[Phone] [xml](CONTENT [dbo].[Phone]) NULL,
	[Approved] [bit] NOT NULL CONSTRAINT [DF_MessageAA_Approved]  DEFAULT ((0)),
	[Rejected] [bit] NOT NULL CONSTRAINT [DF_MessageAA_Rejected]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[HasClinicalDocument] [bit] NOT NULL CONSTRAINT [DF_MessageAA_HasClinicalDocument]  DEFAULT ((0)),
	[ElectronicSummaryOfCareReceived] [bit] NOT NULL CONSTRAINT [DF_MessageAA_ElectronicSummaryOfCareReceived]  DEFAULT ((0)),
	[SummaryOfCareReconciledDate] [date] NULL,
	[MedicationsReconciledDate] [date] NULL,
	[MedicationAllergiesReconciledDate] [date] NULL,
	[ProblemsReconciledDate] [date] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_MessageAA_LastModifiedDate]  DEFAULT (getutcdate()),
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_MessageAA', @level2type=N'COLUMN',@level2name=N'Approved'


END
Truncate Table migtemp_MessageAA
INSERT [migtemp_MessageAA]([MessageUid],[RelAttachmentGroupUid],[VoiceAttachmentUid],[Phone],[Approved],[Rejected],[Notes],[LastModifiedDate],[LastModifiedByUid])
SELECT [MessageUid],[RelAttachmentGroupUid],[VoiceAttachmentUid],CONVERT(nvarchar(max), [Phone]),[Approved],[Rejected],[Notes],[LastModifiedDate],[LastModifiedByUid]
FROM [MessageAA]

DROP TABLE [MessageAA]

exec  sp_rename 'migtemp_MessageAA', 'MessageAA'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MPIQueue]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[MPIQueue](
	[MPIQueueUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[SendFunction] [varchar](50) NULL,
	[InsertedDate] [datetime] NOT NULL,
	[MessageDate] [datetime] NULL,
	[Inactive] [bit] NOT NULL,
	[Error] [bit] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'MPIQueue'

ALTER TABLE [MPIQueue] ADD  CONSTRAINT [DF_MPIQueue_InsertedDate]  DEFAULT (getutcdate()) FOR [InsertedDate]
ALTER TABLE [MPIQueue] ADD  CONSTRAINT [DF_MPIQueue_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [MPIQueue] ADD  CONSTRAINT [DF_MPIQueue_Error]  DEFAULT ((0)) FOR [Error]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[NewSnomeds]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[NewSnomeds](
	[id] [varchar](255) NULL,
	[effectiveTime] [varchar](50) NULL,
	[active] [varchar](50) NULL,
	[moduleId] [varchar](50) NULL,
	[conceptId] [varchar](50) NULL,
	[languageCode] [varchar](50) NULL,
	[typeId] [varchar](50) NULL,
	[term] [varchar](255) NULL,
	[caseSignificanceId] [varchar](50) NULL
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ObservationValue]') AND name = 'LOINC')
    ALTER TABLE [ObservationValue] ADD [LOINC] varchar(10) NULL 
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[Patient]') AND name = 'BirthXml')
    ALTER TABLE [Patient] ADD [BirthXml] XML NULL 
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_PatientCP_CareTeam]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_PatientCP_CareTeam](
	[PatientCP_CareTeamUid] [uniqueidentifier] NOT NULL,
	[PatientCP_CarePlanUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[UserUid] [uniqueidentifier] NULL,
	[PersonContactUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The last date the row was updated or the date added.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientCP_CareTeam', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'

ALTER TABLE [migtemp_PatientCP_CareTeam] ADD  CONSTRAINT [DF_PatientCP_CareTeam_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_PatientCP_CareTeam
INSERT [migtemp_PatientCP_CareTeam]([PatientCP_CareTeamUid],[PatientCP_CarePlanUid],[Notes],[LastModifiedByUid],[LastModifiedDate])
SELECT [PatientCP_CareTeamUid],[PatientCP_CarePlanUid],[Notes],[LastModifiedByUid],[LastModifiedDate]
FROM [PatientCP_CareTeam]

DROP TABLE [PatientCP_CareTeam]

exec  sp_rename 'migtemp_PatientCP_CareTeam', 'PatientCP_CareTeam'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PatientCP_GoalReviewHistory]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[PatientCP_GoalReviewHistory](
	[PatientCP_GoalReviewHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientCP_GoalHistoryUid] [uniqueidentifier] NOT NULL,
	[IsCurrentHistoryRow] [bit] NOT NULL,
	[GroupingUid] [uniqueidentifier] NULL,
	[Comments] [varchar](max) NOT NULL,
	[Achieved] [bit] NOT NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[IsDelete] [bit] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[ActiveDate] [date] NULL,
	[InactiveDate] [date] NULL,
	[CreatedDateTime] [datetime] NOT NULL,
	[Sequence] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Marks the current active row in a PatientCP_GoalReviewHistoryUid within the same GroupUid. Can be used to form a filter for returning rows.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_GoalReviewHistory', @level2type=N'COLUMN',@level2name=N'IsCurrentHistoryRow'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Is used to find all the history rows belonging to the IsCurrentHistoryRow row. The first row create for a new patient goal review row’s PK will populate the value for the GroupingUid.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_GoalReviewHistory', @level2type=N'COLUMN',@level2name=N'GroupingUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Marks a row "Deleted" without removing the row. The UI will show this row as struck-out.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_GoalReviewHistory', @level2type=N'COLUMN',@level2name=N'IsDelete'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Allows finding the history rows within the same GroupUid that are active. Can be used with InactiveDate and GroupUid to form a filter for returning rows.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_GoalReviewHistory', @level2type=N'COLUMN',@level2name=N'ActiveDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Allows finding the history rows within the same GroupUid that are inactive. Can be used with ActiveDate and GroupUid to form a filter for returning rows.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_GoalReviewHistory', @level2type=N'COLUMN',@level2name=N'InactiveDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Allows sorting the history rows within the same GroupUid in the order entered.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_GoalReviewHistory', @level2type=N'COLUMN',@level2name=N'Sequence'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The last date the row was updated or the date added.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_GoalReviewHistory', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'

ALTER TABLE [PatientCP_GoalReviewHistory] ADD  CONSTRAINT [DF_PatientCP_GoalReviewHistory_PatientCP_GoalReviewHistoryUid]  DEFAULT (newid()) FOR [PatientCP_GoalReviewHistoryUid]
ALTER TABLE [PatientCP_GoalReviewHistory] ADD  CONSTRAINT [DF_PatientCP_GoalReviewHistory_IsCurrentHistoryRow]  DEFAULT ((0)) FOR [IsCurrentHistoryRow]
ALTER TABLE [PatientCP_GoalReviewHistory] ADD  CONSTRAINT [DF_PatientCP_GoalReviewHistory_Comments]  DEFAULT ('') FOR [Comments]
ALTER TABLE [PatientCP_GoalReviewHistory] ADD  CONSTRAINT [DF_PatientCP_GoalReviewHistory_Achieved]  DEFAULT ((0)) FOR [Achieved]
ALTER TABLE [PatientCP_GoalReviewHistory] ADD  CONSTRAINT [DF_PatientCP_GoalReviewHistory_IsDelete]  DEFAULT ((0)) FOR [IsDelete]
ALTER TABLE [PatientCP_GoalReviewHistory] ADD  CONSTRAINT [DF_PatientCP_GoalReviewHistory_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [PatientCP_GoalReviewHistory] ADD  CONSTRAINT [DF_PatientCP_GoalReviewHistory_CreatedDateTime]  DEFAULT (getutcdate()) FOR [CreatedDateTime]
ALTER TABLE [PatientCP_GoalReviewHistory] ADD  CONSTRAINT [DF_PatientCP_GoalReviewHistory_Sequence]  DEFAULT (getutcdate()) FOR [Sequence]
ALTER TABLE [PatientCP_GoalReviewHistory] ADD  CONSTRAINT [DF_PatientCP_GoalReviewHistory_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PatientPartnerTransaction]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[PatientPartnerTransaction](
	[PatientPartnerTransactionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[HL7PartnerUid] [uniqueidentifier] NULL,
	[IntegrationPartnerUid] [uniqueidentifier] NULL,
	[SuperbillUid] [uniqueidentifier] NULL,
	[PlanID] [varchar](100) NULL,
	[TransactionUid] [uniqueidentifier] NOT NULL,
	[OriginalTransactionUid] [uniqueidentifier] NOT NULL,
	[Amount] [money] NOT NULL,
	[PaymentMethod] [varchar](50) NULL,
	[Action] [varchar](50) NULL,
	[TransactionTimeStamp] [datetime] NULL,
	[TransactionType] [varchar](50) NULL,
	[BranchID] [varchar](50) NULL,
	[ClientID] [varchar](50) NULL,
	[ReferenceNumber] [varchar](100) NULL,
	[EntryMethod] [varchar](50) NULL,
	[AccountType] [varchar](50) NULL,
	[AccountNumber] [varchar](100) NULL,
	[AccountName] [varchar](100) NULL,
	[Notes] [text] NULL,
	[AdditionalXML] [varchar](max) NULL,
	[CreatedDateTime] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]


ALTER TABLE [PatientPartnerTransaction] ADD  CONSTRAINT [DF_PatientPartnerTransaction_PatientPartnerTransactionUid]  DEFAULT (newid()) FOR [PatientPartnerTransactionUid]

END
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[PatientProblemDiagnosisHistory]') AND name = 'HccModelCat')
    ALTER TABLE [PatientProblemDiagnosisHistory] ADD [HccModelCat] int NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[PatientProblemDiagnosisHistory]') AND name = 'LexicalCode')
    ALTER TABLE [PatientProblemDiagnosisHistory] ADD [LexicalCode] int NULL 
exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverReplicate' , N'SCHEMA',N'dbo', N'TABLE',N'PersonWeb', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.NeverReplicate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PersonWeb'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'oldname' , N'SCHEMA',N'dbo', N'TABLE',N'PersonWeb', N'COLUMN',N'IncorrectLoginDateTime'))
EXEC sys.sp_dropextendedproperty @name=N'oldname' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PersonWeb', @level2type=N'COLUMN',@level2name=N'IncorrectLoginDateTime'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'oldname' , N'SCHEMA',N'dbo', N'TABLE',N'PersonWeb', N'COLUMN',N'IncorrectLoginDateTime'))
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'IncorrectLoginDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PersonWeb', @level2type=N'COLUMN',@level2name=N'IncorrectLoginDateTime'
GO
BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ProviderCpp' AND COLUMN_NAME = 'Name')
ALTER TABLE [ProviderCpp]  ALTER COLUMN [Name] varchar(250) NULL 
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'RecordDisclosureAudit' AND COLUMN_NAME = 'IsPortal')
ALTER TABLE [RecordDisclosureAudit]  ALTER COLUMN [IsPortal] tinyint NOT NULL 
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'DisclosureMethod' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'DisclosureMethod' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'DisclosureType' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'DisclosureType' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'RecipientType' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'RecipientType' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ForcedUploadProcessOrder' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.ForcedUploadProcessOrder' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.XferDirection' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Status' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Status' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'DisclosureMethod' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'DisclosureMethod', @value=N'<None value="0"/><DirectCommunicationEmail value="1"/><Fax value="2" /><Print value="3" /><SaveToFile value="4" /><Portal value="5" /><FacilityPortal value="6" /><API value="7" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'DisclosureType' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'DisclosureType', @value=N'<None value="0"/><CompleteChart value="1" />  <ClinicalSummary value="2" />  <LabResult value="3" /> <Medication value="4" /> <MedicationAllergies value="5" /> <Immunizations value="6" /> <Procedures value="7" /> <MedicalHistory value="8" /> <EducationMaterial value="9" /> <Demographics value="10" /> <ContinuityOfCareDocument value="11" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'IsPortal' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'IsPortal', @value=N'<No value="0"/><Yes value="1"/><API value="2"/>' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'RecipientType' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'RecipientType', @value=N'<None value="0"/><Provider value="1"/><MedicalServiceProvider value="2" /><ServiceSite value="3" /><Patient value="4" /><OtherRecipient value="5" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ForcedUploadProcessOrder' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.ForcedUploadProcessOrder', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Upload' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Status' , N'SCHEMA',N'dbo', N'TABLE',N'RecordDisclosureAudit', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Status', @value=N'<NotSent value="0" /><Sent value="1" /><Error value="2" /><SuccessPending value="3" /><SuccessDelivered value="4" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RecordDisclosureAudit'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ForcedUploadProcessOrder' , N'SCHEMA',N'dbo', N'TABLE',N'RelAuditSuperbill', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.ForcedUploadProcessOrder', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelAuditSuperbill'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Sequence' , N'SCHEMA',N'dbo', N'TABLE',N'RelAuditSuperbill', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.Sequence', @value=N'9500' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelAuditSuperbill'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'RelAuditSuperbill', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Upload' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelAuditSuperbill'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelPatientMedication]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelPatientMedication](
	[RelPatientMedicationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelPatientMedication_RelPatientMedicationUid]  DEFAULT (newid()),
	[MedicationSIGUid] [uniqueidentifier] NOT NULL,
	[RelVisitMedicationUid] [uniqueidentifier] NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[ActiveDate] [date] NULL CONSTRAINT [DF_RelPatientMedication_ActiveTime]  DEFAULT (getdate()),
	[InactiveDate] [date] NULL,
	[IsPatientInput] [bit] NOT NULL CONSTRAINT [DF_RelPatientMedication_IsPatientInput]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[EnteredFromVisitUid] [uniqueidentifier] NULL,
	[Status] [tinyint] NOT NULL CONSTRAINT [DF_RelPatientMedication_Status]  DEFAULT ((0)),
	[StatusMessage] [varchar](max) NULL,
	[DataXML] [xml] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelPatientMedication_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'ActiveTime' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelPatientMedication', @level2type=N'COLUMN',@level2name=N'ActiveDate'
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'InactiveTime' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelPatientMedication', @level2type=N'COLUMN',@level2name=N'InactiveDate'
EXEC sys.sp_addextendedproperty @name=N'Type', @value=N'RelPatientMedicationCancelRxData' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelPatientMedication', @level2type=N'COLUMN',@level2name=N'DataXML'
EXEC sys.sp_addextendedproperty @name=N'Status', @value=N'<None value="0" /><Prescribed_Queued value="1" /><Prescribed_Sent value="2" /><Prescribed_Success value="3" /><Prescribed_Error value="4" /><Cancelled_Queued value="5" /><Cancelled_Sent value="6" /><Cancelled_Success value="7" /><Cancelled_Error value="8" /><PrintedOrFaxed value="9" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelPatientMedication'


END
Truncate Table migtemp_RelPatientMedication
INSERT [migtemp_RelPatientMedication]([RelPatientMedicationUid],[MedicationSIGUid],[RelVisitMedicationUid],[PatientUid],[ActiveDate],[InactiveDate],[IsPatientInput],[Notes],[EnteredFromVisitUid],[LastModifiedByUid],[LastModifiedDate])
SELECT [RelPatientMedicationUid],[MedicationSIGUid],[RelVisitMedicationUid],[PatientUid],[ActiveDate],[InactiveDate],[IsPatientInput],[Notes],[EnteredFromVisitUid],[LastModifiedByUid],[LastModifiedDate]
FROM [RelPatientMedication]

DROP TABLE [RelPatientMedication]

exec  sp_rename 'migtemp_RelPatientMedication', 'RelPatientMedication'

exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Inactive' , N'SCHEMA',N'dbo', N'TABLE',N'RelPatientProgramPersonWeb', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Inactive' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelPatientProgramPersonWeb'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'RelPatientProgramPersonWeb', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.EMRAdminTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelPatientProgramPersonWeb'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverReplicate' , N'SCHEMA',N'dbo', N'TABLE',N'RelPatientProgramPersonWeb', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.NeverReplicate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelPatientProgramPersonWeb'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Inactive' , N'SCHEMA',N'dbo', N'TABLE',N'RelPatientProgramPersonWeb', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Inactive', @value=N'<False value="0" /><True value="1" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelPatientProgramPersonWeb'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Patient' , N'SCHEMA',N'dbo', N'TABLE',N'RelScheduledEduForm', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'{FK_RelScheduledEduForm_Visit}' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelScheduledEduForm'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Inactive' , N'SCHEMA',N'dbo', N'TABLE',N'RelServiceSitePersonWeb', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Inactive' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelServiceSitePersonWeb'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'RelServiceSitePersonWeb', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.EMRAdminTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelServiceSitePersonWeb'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverReplicate' , N'SCHEMA',N'dbo', N'TABLE',N'RelServiceSitePersonWeb', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.NeverReplicate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelServiceSitePersonWeb'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Inactive' , N'SCHEMA',N'dbo', N'TABLE',N'RelServiceSitePersonWeb', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Inactive', @value=N'<False value="0" /><True value="1" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelServiceSitePersonWeb'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelVisitMedication]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelVisitMedication](
	[RelVisitMedicationUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL CONSTRAINT [DF_RelVisitMedication_RelVisitMedicationUid]  DEFAULT (newid()),
	[MedicationSIGUid] [uniqueidentifier] NOT NULL,
	[VisitUid] [uniqueidentifier] NOT NULL,
	[VisitProcedureUid] [uniqueidentifier] NULL,
	[eRxStatusUid] [uniqueidentifier] NULL,
	[eRxEligibilityDownLoadDate] [datetime] NULL,
	[ReadyToPrescribe] [bit] NOT NULL CONSTRAINT [DF_RelVisitMedication_ReadyToPrescribe]  DEFAULT ((0)),
	[Prescribed] [bit] NOT NULL CONSTRAINT [DF_RelVisitMedication_MarkAsPrescribed]  DEFAULT ((0)),
	[ConsentCreated] [bit] NOT NULL CONSTRAINT [DF_RelVisitMedication_ConsentCreated]  DEFAULT ((0)),
	[Notes] [varchar](max) NULL,
	[ReprintReason] [varchar](max) NULL,
	[eRxRequest] [xml](CONTENT [dbo].[eRxRequestXML]) NULL,
	[PreviousData] [xml](CONTENT [dbo].[PreviousData]) NULL,
	[DigitalSignatureXML] [xml] NULL,
	[FormularyXML] [xml](CONTENT [dbo].[FormularyData]) NULL,
	[FulfillmentMethod] [smallint] NOT NULL CONSTRAINT [DF_RelVisitMedication_FulfillmentMethod]  DEFAULT ((0)),
	[FulfillmentDateTime] [datetime] NULL,
	[FulfillmentSequentialNumber] [int] NULL,
	[ScriptSave] [bit] NULL CONSTRAINT [DF_RelVisitMedication_ScriptSave]  DEFAULT ((0)),
	[ePAStatus] [smallint] NOT NULL CONSTRAINT [DF_RelVisitMedication_ePASentRequest]  DEFAULT ((0)),
	[ePAMessageID] [varchar](50) NULL,
	[ePAResults] [varchar](max) NULL,
	[SpoStatus] [smallint] NOT NULL CONSTRAINT [DF_RelVisitMedication_SpoStatus]  DEFAULT ((0)),
	[SpoRequest] [varchar](max) NULL,
	[SpoResponse] [varchar](max) NULL,
	[Status] [tinyint] NOT NULL CONSTRAINT [DF_RelVisitMedication_Status]  DEFAULT ((0)),
	[StatusMessage] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL CONSTRAINT [DF_RelVisitMedication_LastModifiedDate]  DEFAULT (getutcdate())
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'ePAStatus', @value=N'<None value ="0"/><Ready value="1"/><Sent value="2"/><Error value="3"/><Acknowledged value="4"/>' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelVisitMedication'
EXEC sys.sp_addextendedproperty @name=N'FulfillmentMethod', @value=N'<None value="0" /><ePrescribe value="1" /><Fax value="2" /><Print value="3" /><SampleGiven value="4" /><Administered value="5" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelVisitMedication'
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'FK_RelVisitMedication_Visit' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelVisitMedication'
EXEC sys.sp_addextendedproperty @name=N'SpoStatus', @value=N'<None value ="0"/><Ready value="1"/><Sent value="2"/><Error value="3"/><Acknowledged value="4"/>' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelVisitMedication'
EXEC sys.sp_addextendedproperty @name=N'Status', @value=N'<None value="0" /><Prescribed_Queued value="1" /><Prescribed_Sent value="2" /><Prescribed_Success value="3" /><Prescribed_Error value="4" /><Cancelled_Queued value="5" /><Cancelled_Sent value="6" /><Cancelled_Success value="7" /><Cancelled_Error value="8" /><PrintedOrFaxed value="9" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelVisitMedication'


END
Truncate Table migtemp_RelVisitMedication
INSERT [migtemp_RelVisitMedication]([RelVisitMedicationUid],[MedicationSIGUid],[VisitUid],[VisitProcedureUid],[eRxStatusUid],[eRxEligibilityDownLoadDate],[ReadyToPrescribe],[Prescribed],[ConsentCreated],[Notes],[ReprintReason],[eRxRequest],[PreviousData],[DigitalSignatureXML],[FormularyXML],[FulfillmentMethod],[FulfillmentDateTime],[FulfillmentSequentialNumber],[ScriptSave],[ePAStatus],[ePAMessageID],[ePAResults],[SpoStatus],[SpoRequest],[SpoResponse],[LastModifiedByUid],[LastModifiedDate])
SELECT [RelVisitMedicationUid],[MedicationSIGUid],[VisitUid],[VisitProcedureUid],[eRxStatusUid],[eRxEligibilityDownLoadDate],[ReadyToPrescribe],[Prescribed],[ConsentCreated],[Notes],[ReprintReason],CONVERT(nvarchar(max), [eRxRequest]),CONVERT(nvarchar(max), [PreviousData]),CONVERT(nvarchar(max), [DigitalSignatureXML]),CONVERT(nvarchar(max), [FormularyXML]),[FulfillmentMethod],[FulfillmentDateTime],[FulfillmentSequentialNumber],[ScriptSave],[ePAStatus],[ePAMessageID],[ePAResults],[SpoStatus],[SpoRequest],[SpoResponse],[LastModifiedByUid],[LastModifiedDate]
FROM [RelVisitMedication]

DROP TABLE [RelVisitMedication]

exec  sp_rename 'migtemp_RelVisitMedication', 'RelVisitMedication'

exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ForcedUploadProcessOrder' , N'SCHEMA',N'dbo', N'TABLE',N'TransmissionData', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.ForcedUploadProcessOrder' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TransmissionData'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Patient' , N'SCHEMA',N'dbo', N'TABLE',N'TransmissionData', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.Patient' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TransmissionData'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'TransmissionData', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.XferDirection' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TransmissionData'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'TransmissionData', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TransmissionData'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ForcedUploadProcessOrder' , N'SCHEMA',N'dbo', N'TABLE',N'TransmissionData', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.ForcedUploadProcessOrder', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TransmissionData'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'TransmissionData', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Upload' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'TransmissionData'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'UserSession', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UserSession'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'UserSession', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.EMRAdminTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UserSession'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'UserSession', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'User session for holding session state.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UserSession'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'UserSession', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UserSession'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.XferDirection' , N'SCHEMA',N'dbo', N'TABLE',N'UserSession', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Upload' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UserSession'
GO
BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[VisitDiagnosis]') AND name = 'HccModelCat')
    ALTER TABLE [VisitDiagnosis] ADD [HccModelCat] int NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[VisitDiagnosis]') AND name = 'LexicalCode')
    ALTER TABLE [VisitDiagnosis] ADD [LexicalCode] int NULL 
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[MessageERxChangeRequest]') AND type in (N'U'))
DROP TABLE [MessageERxChangeRequest]
COMMIT TRAN

GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[PatientCP_GoalReview]') AND type in (N'U'))
DROP TABLE [PatientCP_GoalReview]
COMMIT TRAN

GO


-- Fix for bug 15558 - Getting 2 app errors; 'VISCode & NDC11 not found' when selecting an immunization code on SP/SO tab
-- moved here from SQLModule lcordell
BEGIN TRAN
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ImmunizationHistory]') AND name = 'NDC11')
    ALTER TABLE [ImmunizationHistory] ADD NDC11 varchar(50) NULL 
IF NOT EXISTS (SELECT * FROM syscolumns WHERE id = OBJECT_ID(N'[ImmunizationHistory]') AND name = 'VISCode')
    ALTER TABLE [ImmunizationHistory] ADD VISCode varchar(50) NULL 
exec sp_dropDF
COMMIT TRAN
GO
