-- Neil  (copied from 2011/2014 migration)
-- ListSystem has a new unique index on Name so cleanup the duplicates
IF EXISTS(SELECT * FROM ListSystem s1 INNER JOIN ListSystem s2 ON s1.Name = s2.Name WHERE s1.SystemUid <> s2.SystemUid)
BEGIN
	DECLARE @duplicate TABLE (	Name VARCHAR(100),
								SystemUid UNIQUEIDENTIFIER NULL
							)

	INSERT			@duplicate(Name)
	SELECT DISTINCT	s1.Name
	FROM			ListSystem s1 inner join ListSystem s2 on s1.Name = s2.Name 
	WHERE			s1.SystemUid <> s2.SystemUid

	UPDATE	@duplicate
	SET		SystemUid = s.SystemUid
	FROM	@duplicate d INNER JOIN ListSystem s ON d.Name = s.Name
	WHERE	s.UserDefined = 0 OR s.UserDefined = 2

	UPDATE	@duplicate
	SET		SystemUid = s.SystemUid
	FROM	@duplicate d INNER JOIN ListSystem s ON d.Name = s.Name
	WHERE	d.SystemUid IS NULL AND
			s.Inactive = 0

	UPDATE	@duplicate
	SET		SystemUid = s.SystemUid
	FROM	@duplicate d INNER JOIN ListSystem s ON d.Name = s.Name
	WHERE	d.SystemUid IS NULL 

	UPDATE	s
	SET		Inactive = 0
	FROM	@duplicate d INNER JOIN ListSystem s ON d.SystemUid = s.SystemUid
	WHERE	s.Inactive = 1 AND
			s.Name IN (SELECT s1.Name FROM ListSystem s1 WHERE s1.Name = s.Name AND s1.Inactive = 0)

	DECLARE	@systemUid1 UNIQUEIDENTIFIER
	DECLARE	@systemUid2 UNIQUEIDENTIFIER
	DECLARE @temp UNIQUEIDENTIFIER
	DECLARE @symptomUid UNIQUEIDENTIFIER
	DECLARE @relSystemSymptomUid UNIQUEIDENTIFIER

	DECLARE cur CURSOR FOR
		SELECT			d.SystemUid, s.SystemUid
		FROM			@duplicate d INNER JOIN ListSystem s ON d.Name = s.Name
		WHERE			s.SystemUid <> d.SystemUid

	OPEN cur

	FETCH NEXT FROM cur INTO @systemUid1, @systemUid2
	WHILE @@FETCH_STATUS <> -1
	BEGIN
		PRINT 'Merging ' + CAST(@systemUid2 AS VARCHAR(50))+ ' into ' + CAST(@systemUid1 AS VARCHAR(50))

		DECLARE ccCursor CURSOR FOR
			SELECT	CCSymptomUid
			FROM	RelCCSystemSymptom
			WHERE	CCSystemUid = @systemUid2

		OPEN ccCursor
		FETCH NEXT FROM ccCursor INTO @symptomUid
		WHILE @@FETCH_STATUS <> -1
		BEGIN
			IF NOT EXISTS(SELECT * FROM CCSystem WHERE CCSystemUid = @systemUid1)
				INSERT	CCSystem
				SELECT	@systemUid1, DisplayOrder, UserDefined, LicenseCode, ClinicCenterOverride, ProviderOverride, LastModifiedDate, LastModifiedByUid
				FROM	CCSystem					
				WHERE	CCSystemUid = @systemUid2

			PRINT	'Update CppCC'
			UPDATE	CppCC
			SET		CCSystemUid = @systemUid1
			WHERE	CCSystemUid = @systemUid2 AND CCSymptomUid = @symptomUid

			PRINT 'Update VisitHpi'
			UPDATE	VisitHpi
			SET		CCSystemUid = @systemUid1
			WHERE	CCSystemUid = @systemUid2 AND
					CCSymptomUid = @symptomUid

			SET @relSystemSymptomUid = NULL
			SELECT TOP 1 @relSystemSymptomUid = RelCCSystemSymptomUid FROM RelCCSystemSymptom WHERE CCSystemUid = @systemUid1 AND CCSymptomUid = @symptomUid
			IF @relSystemSymptomUid IS NULL 
			BEGIN
				PRINT	'Update RelCCSystemSymptom ' + CAST(@systemUid1 AS VARCHAR(50)) + ' ' + CAST(@systemUid2 AS VARCHAR(50)) + ' ' + CAST(@symptomUid AS VARCHAR(50))
				UPDATE	RelCCSystemSymptom
				SET		CCSystemUid = @systemUid1
				WHERE	CCSystemUid = @systemUid2 AND CCSymptomUid = @symptomUid
			END
			ELSE
			BEGIN
				PRINT	'Update VisitCC ' + CAST(@systemUid1 AS VARCHAR(50)) + ' ' + CAST(@systemUid2 AS VARCHAR(50)) + ' -> ' + CAST(@symptomUid AS VARCHAR(50)) + '/' + CAST(@relSystemSymptomUid AS VARCHAR(50))
				UPDATE	VisitCC
				SET		RelCCSystemSymptomUid = @relSystemSymptomUid,
						CCSystemUid = @systemUid1
				WHERE	CCSystemUid = @systemUid2 AND -- Handle MFU Case
						CCSymptomUid = @symptomUid

				UPDATE	r
				SET	RelCCSystemSymptomUid = @relSystemSymptomUid
				FROM	RelEduFormCCSymptom r
				WHERE	r.RelCCSystemSymptomUid IN (SELECT RelCCSystemSymptomUid FROM RelCCSystemSymptom WHERE CCSystemUid = @systemUid2 AND CCSymptomUid = @symptomUid AND RelCCSystemSymptomUid <> @relSystemSymptomUid)

				UPDATE	v
				SET		RelCCSystemSymptomUid = @relSystemSymptomUid
				FROM	VisitCC v
				WHERE	v.RelCCSystemSymptomUid IN (SELECT RelCCSystemSymptomUid FROM RelCCSystemSymptom WHERE CCSystemUid = @systemUid2 AND CCSymptomUid = @symptomUid AND RelCCSystemSymptomUid <> @relSystemSymptomUid)

				PRINT	'Delete RelCCSymptomHpi'
				DELETE	hpi
				FROM	RelCCSymptomHpi hpi INNER JOIN RelCCSymptomHpiCategory hpicat ON hpi.RelCCSymptomHpiCategoryUid = hpicat.RelCCSymptomHpiCategoryUid
						INNER JOIN RelCCSystemSymptom syssym ON hpicat.RelCCSystemSymptomUid = syssym.RelCCSystemSymptomUid
				WHERE	CCSystemUid = @systemUid2 AND CCSymptomUid = @symptomUid AND syssym.RelCCSystemSymptomUid <> @relSystemSymptomUid

				PRINT	'Delete RelCCSymptomHpiCategory'
				DELETE	hpicat
				FROM	RelCCSymptomHpiCategory hpicat INNER JOIN RelCCSystemSymptom syssym ON hpicat.RelCCSystemSymptomUid = syssym.RelCCSystemSymptomUid
				WHERE	CCSystemUid = @systemUid2 AND CCSymptomUid = @symptomUid AND syssym.RelCCSystemSymptomUid <> @relSystemSymptomUid

				PRINT	'Delete RelCCSystemSymptom'
				DELETE FROM RelCCSystemSymptom WHERE CCSystemUid = @systemUid2 AND CCSymptomUid = @symptomUid AND RelCCSystemSymptomUid <> @relSystemSymptomUid
			END

			FETCH NEXT FROM ccCursor INTO @symptomUid
		END	
		CLOSE ccCursor
		DEALLOCATE ccCursor	

		PRINT	'Update CppCC'
		UPDATE	CppCC
		SET		CCSystemUid = @systemUid1
		WHERE	CCSystemUid = @systemUid2

		PRINT	'Update VisitCC'
		UPDATE	VisitCC
		SET		CCSystemUid = @systemUid1
		WHERE	CCSystemUid = @systemUid2				

		PRINT	'Update VisitHpi'
		UPDATE	VisitHpi
		SET		CCSystemUid = @systemUid1
		WHERE	CCSystemUid = @systemUid2

		PRINT	'Delete CCSystem'
		DELETE FROM	CCSystem
		WHERE	CCSystemUid = @systemUid2

		DECLARE rosCursor CURSOR FOR
			SELECT	RosSymptomUid
			FROM	RelRosSystemSymptom
			WHERE	RosSystemUid = @systemUid2

		OPEN rosCursor
		FETCH NEXT FROM rosCursor INTO @symptomUid
		WHILE @@FETCH_STATUS <> -1
		BEGIN
			SET @relSystemSymptomUid = NULL
			SELECT TOP 1 @relSystemSymptomUid = RelRosSystemSymptomUid FROM RelRosSystemSymptom WHERE RosSystemUid = @systemUid1 AND RosSymptomUid = @symptomUid
			IF @relSystemSymptomUid IS NULL 
			BEGIN
				IF NOT EXISTS(SELECT * FROM RosSystem WHERE RosSystemUid = @systemUid1)
					INSERT	ROSSystem
					SELECT	@systemUid1, DisplayOrder, SystemDisplayOrder, UserDefined, ClinicCenterOverride, ProviderOverride, LastModifiedByUid, LastModifiedDate
					FROM	RosSystem					
					WHERE	RosSystemUid = @systemUid2
					
				select * from rossystem
				PRINT	'Update RelRosSystemSymptom'
				UPDATE	RelRosSystemSymptom
				SET		RosSystemUid = @systemUid1
				WHERE	RosSystemUid = @systemUid2 AND RosSymptomUid = @symptomUid

				PRINT	'Update RelRosSystemSymptom'
				UPDATE	RelRosSystemSymptom
				SET		RosSystemUid = @systemUid1
				WHERE	RosSystemUid = @systemUid2 AND RosSymptomUid = @symptomUid
			END
			ELSE
			BEGIN
				PRINT	'Update ListSurveyQuestion'
				UPDATE	lq
				SET		RelRosSystemSymptomUid = @relSystemSymptomUid
				FROM	ListSurveyQuestion lq INNER JOIN RelRosSystemSymptom r ON lq.RelRosSystemSymptomUid = r.RelRosSystemSymptomUid
				WHERE	r.RosSystemUid = @systemUid2 AND r.RosSymptomUid = @symptomUid

				PRINT	'Update SurveyResponse'
				UPDATE	sr
				SET	RelRosSystemSymptomUid = @relSystemSymptomUid
				FROM	SurveyResponse sr INNER JOIN RelRosSystemSymptom r ON sr.RelRosSystemSymptomUid = r.RelRosSystemSymptomUid
				WHERE	r.RosSystemUid = @systemUid2 AND r.RosSymptomUid = @symptomUid

				PRINT	'Update SurveyResponse'
				UPDATE	sr
				SET		RelRosSystemSymptomUid = @relSystemSymptomUid
				FROM	SurveyResponse sr INNER JOIN RelRosSystemSymptom r ON sr.PredeterminedRelRosSystemSymptomUid = r.RelRosSystemSymptomUid
				WHERE	r.RosSystemUid = @systemUid2 AND r.RosSymptomUid = @symptomUid

				PRINT	'Delete RelRosSystemSymptom'
				DELETE FROM RelRosSystemSymptom WHERE RosSystemUid = @systemUid2 AND RosSymptomUid = @symptomUid AND RelRosSystemSymptomUid <> @relSystemSymptomUid
			END
			FETCH NEXT FROM rosCursor INTO @symptomUid
		END	
		CLOSE rosCursor
		DEALLOCATE rosCursor	

		PRINT	'Update VisitRos'
		UPDATE	VisitRos
		SET		RosSystemUid = @systemUid1
		WHERE	RosSystemUid = @systemUid2

		PRINT	'Update CppRos'
		UPDATE	r1
		SET		r1.RosSystemUid = @systemUid1
		FROM	CPPRos r1 LEFT JOIN CPPRos r2 ON r1.RosSymptomUid = r2.RosSymptomUid AND r2.RosSystemUid = @systemUid1
		WHERE	r1.RosSystemUid = @systemUid2 AND
				r2.CppRosUid IS NULL

		PRINT	'Delete CppRos'
		DELETE FROM	CPPRos 
		WHERE	RosSystemUid = @systemUid2 

		PRINT 'Delete ListSystem'
		DELETE FROM ListSystem WHERE SystemUid = @systemUid2

		FETCH NEXT FROM cur INTO @systemUid1, @systemUid2
	END

	CLOSE cur
	DEALLOCATE cur
END
GO

-- Neil
-- ListSymptom has a new unique index on Name so cleanup the duplicates
IF EXISTS(SELECT * FROM ListSymptom s1 INNER JOIN ListSymptom s2 ON s1.Name = s2.Name WHERE s1.SymptomUid <> s2.SymptomUid)
BEGIN
	DECLARE @duplicate TABLE (	Name VARCHAR(100),
								SymptomUid UNIQUEIDENTIFIER NULL
							)

	INSERT			@duplicate(Name)
	SELECT DISTINCT	s1.Name
	FROM			ListSymptom s1 inner join ListSymptom s2 on s1.Name = s2.Name 
	WHERE			s1.Symptomuid <> s2.Symptomuid

	UPDATE	@duplicate
	SET		SymptomUid = s.SymptomUid
	FROM	@duplicate d INNER JOIN ListSymptom s ON d.Name = s.Name
	WHERE	s.UserDefined = 0 OR s.UserDefined = 2

	UPDATE	@duplicate
	SET		SymptomUid = s.SymptomUid
	FROM	@duplicate d INNER JOIN ListSymptom s ON d.Name = s.Name
	WHERE	d.SymptomUid IS NULL AND
			s.Inactive = 0

	UPDATE	@duplicate
	SET		SymptomUid = s.SymptomUid
	FROM	@duplicate d INNER JOIN ListSymptom s ON d.Name = s.Name
	WHERE	d.SymptomUid IS NULL 

	UPDATE	s
	SET		Inactive = 0
	FROM	@duplicate d INNER JOIN ListSymptom s ON d.SymptomUid = s.SymptomUid
	WHERE	s.Inactive = 1 AND
			s.Name IN (SELECT s1.Name FROM ListSymptom s1 WHERE s1.Name = s.Name AND s1.Inactive = 0)

	DECLARE	@symptomUid1 UNIQUEIDENTIFIER
	DECLARE	@symptomUid2 UNIQUEIDENTIFIER
	DECLARE @temp UNIQUEIDENTIFIER
	DECLARE @systemUid UNIQUEIDENTIFIER
	DECLARE @relSystemSymptomUid UNIQUEIDENTIFIER

	DECLARE cur CURSOR FOR
		SELECT			d.SymptomUid, s.SymptomUid
		FROM			@duplicate d INNER JOIN ListSymptom s ON d.Name = s.Name
		WHERE			s.SymptomUid <> d.SymptomUid

	OPEN cur

	FETCH NEXT FROM cur INTO @symptomUid1, @symptomUid2
	WHILE @@FETCH_STATUS <> -1
	BEGIN
		PRINT 'Merging ' + CAST(@symptomUid2 AS VARCHAR(50))+ ' into ' + CAST(@symptomUid1 AS VARCHAR(50))

		DECLARE ccCursor CURSOR FOR
			SELECT	CCSystemUid
			FROM	RelCCSystemSymptom
			WHERE	CCSymptomUid = @symptomUid2

		OPEN ccCursor
		FETCH NEXT FROM ccCursor INTO @systemUid
		WHILE @@FETCH_STATUS <> -1
		BEGIN
			PRINT	'Update CppCC'
			UPDATE	CppCC
			SET		CCSymptomUid = @symptomUid1
			WHERE	CCSystemUid = @systemUid AND CCSymptomUid = @symptomUid2

			PRINT 'Update VisitHpi'
			UPDATE	VisitHpi
			SET		CCSymptomUid = @symptomUid1
			WHERE	CCSystemUid = @systemUid AND
					CCSymptomUid = @symptomUid2

			SET @relSystemSymptomUid = NULL
			SELECT TOP 1 @relSystemSymptomUid = RelCCSystemSymptomUid FROM RelCCSystemSymptom WHERE CCSystemUid = @systemUid AND CCSymptomUid = @symptomUid1
			IF @relSystemSymptomUid IS NULL 
			BEGIN
				PRINT	'Update RelCCSystemSymptom ' + CAST(@systemUid AS VARCHAR(50)) + ' ' + CAST(@symptomUid1 AS VARCHAR(50)) + ' ' + CAST(@symptomUid2 AS VARCHAR(50))
				UPDATE	RelCCSystemSymptom
				SET		CCSymptomUid = @symptomUid1
				WHERE	CCSystemUid = @systemUid AND CCSymptomUid = @symptomUid2
			END
			ELSE
			BEGIN
				PRINT	'Update VisitCC ' + CAST(@systemUid AS VARCHAR(50)) + ' ' + CAST(@symptomUid2 AS VARCHAR(50)) + ' -> ' + CAST(@symptomUid1 AS VARCHAR(50)) + '/' + CAST(@relSystemSymptomUid AS VARCHAR(50))
				UPDATE	VisitCC
				SET		RelCCSystemSymptomUid = @relSystemSymptomUid,
						CCSymptomUid = @symptomUid1
				WHERE	(CCSystemUid = @systemUid OR CCSystemUid = 'FFFFFFFF-0000-0000-0000-000000000001') AND -- Handle MFU Case
						CCSymptomUid = @symptomUid2 

				UPDATE	v
				SET		RelCCSystemSymptomUid = @relSystemSymptomUid
				FROM	VisitCC v
				WHERE	v.RelCCSystemSymptomUid IN (SELECT RelCCSystemSymptomUid FROM RelCCSystemSymptom WHERE CCSystemUid = @systemUid AND CCSymptomUid = @symptomUid2 AND RelCCSystemSymptomUid <> @relSystemSymptomUid)

				PRINT	'Delete RelCCSymptomHpi'
				DELETE	hpi
				FROM	RelCCSymptomHpi hpi INNER JOIN RelCCSymptomHpiCategory hpicat ON hpi.RelCCSymptomHpiCategoryUid = hpicat.RelCCSymptomHpiCategoryUid
						INNER JOIN RelCCSystemSymptom syssym ON hpicat.RelCCSystemSymptomUid = syssym.RelCCSystemSymptomUid
				WHERE	CCSystemUid = @systemUid AND CCSymptomUid = @symptomUid2 AND syssym.RelCCSystemSymptomUid <> @relSystemSymptomUid

				PRINT	'Delete RelCCSymptomHpiCategory'
				DELETE	hpicat
				FROM	RelCCSymptomHpiCategory hpicat INNER JOIN RelCCSystemSymptom syssym ON hpicat.RelCCSystemSymptomUid = syssym.RelCCSystemSymptomUid
				WHERE	CCSystemUid = @systemUid AND CCSymptomUid = @symptomUid2 AND syssym.RelCCSystemSymptomUid <> @relSystemSymptomUid

				PRINT	'Delete RelCCSystemSymptom'
				DELETE FROM RelCCSystemSymptom WHERE CCSystemUid = @systemUid AND CCSymptomUid = @symptomUid2 AND RelCCSystemSymptomUid <> @relSystemSymptomUid
			END

			FETCH NEXT FROM ccCursor INTO @systemUid
		END	
		CLOSE ccCursor
		DEALLOCATE ccCursor	

		PRINT	'Update CppCC'
		UPDATE	CppCC
		SET		CCSymptomUid = @symptomUid1
		WHERE	CCSymptomUid = @symptomUid2

		PRINT	'Update CppHPI'
		UPDATE	CppHpi
		SET		CCSymptomUid = @symptomUid1
		WHERE	CCSymptomUid = @symptomUid2

		PRINT	'Update VisitCC'
		UPDATE	VisitCC
		SET		CCSymptomUid = @symptomUid1
		WHERE	CCSymptomUid = @symptomUid2				

		PRINT	'Update VisitHpi'
		UPDATE	VisitHpi
		SET		CCSymptomUid = @symptomUid1
		WHERE	CCSymptomUid = @symptomUid2

		DECLARE rosCursor CURSOR FOR
			SELECT	RosSystemUid
			FROM	RelRosSystemSymptom
			WHERE	RosSymptomUid = @symptomUid2

		OPEN rosCursor
		FETCH NEXT FROM rosCursor INTO @systemUid
		WHILE @@FETCH_STATUS <> -1
		BEGIN
			SET @relSystemSymptomUid = NULL
			SELECT TOP 1 @relSystemSymptomUid = RelRosSystemSymptomUid FROM RelRosSystemSymptom WHERE RosSystemUid = @systemUid AND RosSymptomUid = @symptomUid1
			IF @relSystemSymptomUid IS NULL 
			BEGIN
				PRINT	'Update RelRosSystemSymptom'
				UPDATE	RelRosSystemSymptom
				SET		RosSymptomUid = @symptomUid1
				WHERE	RosSystemUid = @systemUid AND RosSymptomUid = @symptomUid2

				PRINT	'Update RelRosSystemSymptom'
				UPDATE	RelRosSystemSymptom
				SET		RosSymptomUid = @symptomUid1
				WHERE	RosSystemUid = @systemUid AND RosSymptomUid = @symptomUid2
			END
			ELSE
			BEGIN
				PRINT	'Update SurveyResponse'
				UPDATE	sr
				SET		RelRosSystemSymptomUid = @relSystemSymptomUid
				FROM	SurveyResponse sr INNER JOIN RelRosSystemSymptom r ON sr.RelRosSystemSymptomUid = r.RelRosSystemSymptomUid
				WHERE	r.RosSystemUid = @systemUid AND r.RosSymptomUid = @symptomUid2

				PRINT	'ListSurveyAnswer'
				UPDATE	sa
				SET		PredeterminedRelRosSystemSymptomUid = @relSystemSymptomUid
				FROM	ListSurveyAnswer sa INNER JOIN RelRosSystemSymptom r ON sa.PredeterminedRelRosSystemSymptomUid = r.RelRosSystemSymptomUid
				WHERE	r.RosSystemUid = @systemUid AND r.RosSymptomUid = @symptomUid2
				
				PRINT	'Delete RelRosSystemSymptom'
				DELETE FROM RelRosSystemSymptom WHERE RosSystemUid = @systemUid AND RosSymptomUid = @symptomUid2 AND RelRosSystemSymptomUid <> @relSystemSymptomUid
			END
			FETCH NEXT FROM rosCursor INTO @systemUid
		END	
		CLOSE rosCursor
		DEALLOCATE rosCursor	

		PRINT	'Update VisitRos'
		UPDATE	VisitRos
		SET		RosSymptomUid = @symptomUid1
		WHERE	RosSymptomUid = @symptomUid2

		PRINT	'Update CppRos'
		UPDATE	r1
		SET		r1.RosSymptomUid = @symptomUid1
		FROM	CPPRos r1 LEFT JOIN CPPRos r2 ON r1.RosSystemUid = r2.RosSystemUid AND r2.RosSymptomUid = @symptomUid1
		WHERE	r1.RosSymptomUid = @symptomUid2 AND
				r2.CppRosUid IS NULL

		PRINT	'Delete CppRos'
		DELETE FROM	CPPRos 
		WHERE	RosSymptomUid = @symptomUid2 

		PRINT 'Delete ListSymptom'
		DELETE FROM ListSymptom WHERE SymptomUid = @symptomUid2

		FETCH NEXT FROM cur INTO @symptomUid1, @symptomUid2
	END

	CLOSE cur
	DEALLOCATE cur
END
GO

-- Neil  (copied from 2011/2014 migration)
DECLARE @DuplicateSS TABLE	(	CCSystemUid UNIQUEIDENTIFIER,
								CCSymptomUid UNIQUEIDENTIFIER,
								RelCCSystemSymptomUid UNIQUEIDENTIFIER NULL								
							)

INSERT				@DuplicateSS	(	CCSystemUid, CCSymptomUid	)
SELECT DISTINCT		relcc1.CCSystemUid, relcc1.CCSymptomUid
FROM				RelCCSystemSymptom relcc1 INNER JOIN RelCCSystemSymptom relcc2 ON relcc1.CCSystemUid = relcc2.CCSystemUid AND relcc1.CCSymptomUid = relcc2.CCSymptomUid
WHERE				relcc1.RelCCSystemSymptomUid <> relcc2.RelCCSystemSymptomUid

UPDATE	dss
SET		RelCCSystemSymptomUid = relcc.RelCCSystemSymptomUid
FROM	RelCCSystemSymptom relcc INNER JOIN @DuplicateSS dss ON relcc.CCSystemUid = dss.CCSystemUid AND relcc.CCSymptomUid = dss.CCSymptomUid
WHERE	relcc.UserDefined = 0 OR relcc.UserDefined = 2

UPDATE	dss
SET		RelCCSystemSymptomUid = relcc.RelCCSystemSymptomUid
FROM	RelCCSystemSymptom relcc INNER JOIN @DuplicateSS dss ON relcc.CCSystemUid = dss.CCSystemUid AND relcc.CCSymptomUid = dss.CCSymptomUid
WHERE	dss.RelCCSystemSymptomUid IS NULL AND
		(SELECT COUNT(*) FROM RelCCSymptomHpiCategory relhpicat WHERE relhpicat.RelCCSystemSymptomUid = relcc.RelCCSystemSymptomUid) > 0

UPDATE	dss
SET		RelCCSystemSymptomUid = relcc.RelCCSystemSymptomUid
FROM	RelCCSystemSymptom relcc INNER JOIN @DuplicateSS dss ON relcc.CCSystemUid = dss.CCSystemUid AND relcc.CCSymptomUid = dss.CCSymptomUid
WHERE	dss.RelCCSystemSymptomUid IS NULL 

UPDATE	vcc
SET		RelCCSystemSymptomUid = d.RelCCSystemSymptomUid
FROM	RelCCSystemSymptom relcc INNER JOIN @DuplicateSS d ON relcc.CCSystemUid = d.CCSystemUid AND relcc.CCSymptomUid = d.CCSymptomUid AND relcc.RelCCSystemSymptomUid <> d.RelCCSystemSymptomUid
		INNER JOIN VisitCC vcc ON relcc.RelCCSystemSymptomUid = vcc.RelCCSystemSymptomUid

DELETE	relhpi
FROM	RelCCSymptomHpi relhpi INNER JOIN RelCCSymptomHpiCategory relhpicat ON relhpi.RelCCSymptomHpiCategoryUid = relhpicat.RelCCSymptomHpiCategoryUid
		INNER JOIN RelCCSystemSymptom relcc ON relhpicat.RelCCSystemSymptomUid = relcc.RelCCSystemSymptomUid
		INNER JOIN @DuplicateSS dss ON relcc.CCSystemUid = dss.CCSystemUid AND relcc.CCSymptomUid = dss.CCSymptomUid
WHERE	relcc.RelCCSystemSymptomUid <> dss.RelCCSystemSymptomUid

DELETE	relhpicat
FROM	RelCCSymptomHpiCategory relhpicat INNER JOIN RelCCSystemSymptom relcc ON relhpicat.RelCCSystemSymptomUid = relcc.RelCCSystemSymptomUid
		INNER JOIN @DuplicateSS dss ON relcc.CCSystemUid = dss.CCSystemUid AND relcc.CCSymptomUid = dss.CCSymptomUid
WHERE	relcc.RelCCSystemSymptomUid <> dss.RelCCSystemSymptomUid

DELETE	relcc
FROM	RelCCSystemSymptom relcc INNER JOIN @DuplicateSS dss ON relcc.CCSystemUid = dss.CCSystemUid AND relcc.CCSymptomUid = dss.CCSymptomUid
WHERE	relcc.RelCCSystemSymptomUid <> dss.RelCCSystemSymptomUid
GO

-- Cleanup RelFindTableXXX
DELETE r
FROM   RelFindTableMFU r
WHERE  FindTableUid NOT IN (SELECT FindTableUid FROM ListFindTable)

DELETE r
FROM   RelFindTableMRU r
WHERE  FindTableUid NOT IN (SELECT FindTableUid FROM ListFindTable)

DELETE r
FROM   RelFindTableHide r
WHERE  FindTableUid NOT IN (SELECT FindTableUid FROM ListFindTable)
GO

-- Cleanup FK errors -- T1 is the target table for delete, T2 is the FK referenced table with the referenced column
-- DELETE T1 FROM RelVaccinePrintCols T1 LEFT JOIN ListMisc T2 ON T1.PrintColsUid = T2.MiscUid WHERE T1.PrintColsUid IS NOT NULL AND T2.MiscUid IS NULL;

-- 58933 Fix Duplicate Items so can add Unique Index
DECLARE @uniqueindex TABLE	(	RelProcedureTypeofVaccineUid UNIQUEIDENTIFIER NULL,
								ProcedureUid UNIQUEIDENTIFIER,
								TypeOfVaccineUid UNIQUEIDENTIFIER
							)

INSERT				@uniqueindex (ProcedureUid, TypeOfVaccineUid)
SELECT DISTINCT		ProcedureUid, TypeOfVaccineUid
FROM				RelProcedureTypeofVaccine r

UPDATE	t
SET		RelProcedureTypeofVaccineUid = r.RelProcedureTypeofVaccineUid
FROM	@uniqueindex t INNER JOIN RelProcedureTypeofVaccine r ON t.ProcedureUid = r.ProcedureUid AND t.TypeOfVaccineUid = r.TypeofVaccineUid

DELETE	r
FROM	RelProcedureTypeofVaccine r
WHERE	r.RelProcedureTypeofVaccineUid NOT IN (SELECT RelProcedureTypeofVaccineUid FROM @uniqueindex)
GO

-- Neil ListKdbConfiguration/ProviderDefaultSIG
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[temp_ListKdbConfiguration]') AND type in (N'U'))
begin
	declare @sql nvarchar(4000) =
	N'	INSERT		ListKdbConfiguration( KdbConfigurationUid, [Name] )
	SELECT		KdbConfigurationUid, [Name]
	FROM		temp_ListKdbConfiguration
	'
	exec (@sql)
end			
GO

--
-- #624 Duplicate CDS Rules
-- from Patch A SQLModule 8295_1_CleanupDuplicateRelHMRulexxx_qry.sql
DECLARE @Active [bit] = 0,
	@HMRuleUid [uniqueidentifier],
	@DiseaseUid [uniqueidentifier],
	@QuestionUid [uniqueidentifier],
	@ClassUid [uniqueidentifier],
	@DrugNameUid [uniqueidentifier],
	@ProcedureUid [uniqueidentifier]

DECLARE @DuplicatedRelHMRuleDisease_TBL TABLE(
	[HMRuleUid] [uniqueidentifier],
	[DiseaseUid] [uniqueidentifier],
	primary key([HMRuleUid], [DiseaseUid])
)

INSERT @DuplicatedRelHMRuleDisease_TBL
SELECT rhmrd.[HMRuleUid], rhmrd.[DiseaseUid]
FROM [ListHMRule] AS lhmr
	INNER JOIN [RelHMRuleDisease] AS rhmrd ON lhmr.[HMRuleUid] = rhmrd.[HMRuleUid]
WHERE lhmr.[Inactive] = @Active
GROUP BY rhmrd.[HMRuleUid], rhmrd.[DiseaseUid]
HAVING COUNT(*) > 1

IF EXISTS (
	SELECT TOP 1 *
	FROM @DuplicatedRelHMRuleDisease_TBL
)
BEGIN
	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[cus_RelHMRuleDisease]') AND type in (N'U'))
	BEGIN
		SELECT *
		INTO [cus_RelHMRuleDisease]
		FROM [RelHMRuleDisease]
		WHERE [RelHMRuleDiseaseUid] IS NULL
	END

	INSERT [cus_RelHMRuleDisease]
	SELECT hmrd.*
	FROM @DuplicatedRelHMRuleDisease_TBL AS vhmr
		INNER JOIN [RelHMRuleDisease] AS hmrd ON vhmr.[HMRuleUid] = hmrd.[HMRuleUid]
			AND vhmr.[DiseaseUid] = hmrd.[DiseaseUid]
		LEFT OUTER JOIN [cus_RelHMRuleDisease] AS chmrd ON hmrd.[HMRuleUid] = chmrd.[HMRuleUid]
			AND hmrd.[DiseaseUid] = chmrd.[DiseaseUid]
	WHERE chmrd.[RelHMRuleDiseaseUid] IS NULL
	ORDER BY hmrd.[HMRuleUid], hmrd.[DiseaseUid], hmrd.[Name], hmrd.[LastModifiedDate]
	
	DECLARE @RelHMRuleDiseaseUid [uniqueidentifier]

	DECLARE RelHMRuleDisease_CSR CURSOR FAST_FORWARD FOR
	SELECT *
	FROM @DuplicatedRelHMRuleDisease_TBL

	OPEN RelHMRuleDisease_CSR
	FETCH NEXT FROM RelHMRuleDisease_CSR INTO @HMRuleUid, @DiseaseUid

	WHILE @@FETCH_STATUS = 0
	BEGIN
		SELECT TOP 1 @RelHMRuleDiseaseUid = [RelHMRuleDiseaseUid]
		FROM [RelHMRuleDisease]
		WHERE [HMRuleUid] = @HMRuleUid
			AND [DiseaseUid] = @DiseaseUid
		ORDER BY [LastModifiedDate] DESC

		DELETE [RelHMRuleDisease]
		WHERE [HMRuleUid] = @HMRuleUid
			AND [DiseaseUid] = @DiseaseUid
			AND [RelHMRuleDiseaseUid] <> @RelHMRuleDiseaseUid

		FETCH NEXT FROM RelHMRuleDisease_CSR INTO @HMRuleUid, @DiseaseUid
	END
	CLOSE RelHMRuleDisease_CSR
	DEALLOCATE RelHMRuleDisease_CSR
END

DECLARE @DuplicatedRelHMRuleDrugAllergy_TBL TABLE(
	[HMRuleUid] [uniqueidentifier],
	[QuestionUid] [uniqueidentifier],
	primary key([HMRuleUid], [QuestionUid])
)

INSERT @DuplicatedRelHMRuleDrugAllergy_TBL
SELECT rhmra.[HMRuleUid], rhmra.[QuestionUid]
FROM [ListHMRule] AS lhmr
	INNER JOIN [RelHMRuleDrugAllergy] AS rhmra ON lhmr.[HMRuleUid] = rhmra.[HMRuleUid]
WHERE lhmr.[Inactive] = @Active
GROUP BY rhmra.[HMRuleUid], rhmra.[QuestionUid]
HAVING COUNT(*) > 1

IF EXISTS(
	SELECT TOP 1 *
	FROM @DuplicatedRelHMRuleDrugAllergy_TBL
)
BEGIN
	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[cus_RelHMRuleDrugAllergy]') AND type in (N'U'))
	BEGIN
		SELECT *
		INTO [cus_RelHMRuleDrugAllergy]
		FROM [RelHMRuleDrugAllergy]
		WHERE [RelHMRuleDrugAllergyUid] IS NULL
	END

	INSERT [cus_RelHMRuleDrugAllergy]
	SELECT rhmra.*
	FROM @DuplicatedRelHMRuleDrugAllergy_TBL AS vrhmra
		INNER JOIN [RelHMRuleDrugAllergy] AS rhmra ON vrhmra.[HMRuleUid] = rhmra.[HMRuleUid]
			AND vrhmra.[QuestionUid] = rhmra.[QuestionUid]
		LEFT OUTER JOIN [cus_RelHMRuleDrugAllergy] AS crhmra ON rhmra.[HMRuleUid] = crhmra.[HMRuleUid]
			AND rhmra.[QuestionUid] = crhmra.[QuestionUid]
	WHERE crhmra.[RelHMRuleDrugAllergyUid] IS NULL

	DECLARE @RelHMRuleDrugAllergyUid [uniqueidentifier]

	DECLARE RelHMRuleDrugAllergy_CSR CURSOR FAST_FORWARD FOR
	SELECT *
	FROM @DuplicatedRelHMRuleDrugAllergy_TBL

	OPEN RelHMRuleDrugAllergy_CSR
	FETCH NEXT FROM RelHMRuleDrugAllergy_CSR INTO @HMRuleUid, @QuestionUid

	WHILE @@FETCH_STATUS = 0
	BEGIN
		SELECT TOP 1 @RelHMRuleDrugAllergyUid = [RelHMRuleDrugAllergyUid]
		FROM [RelHMRuleDrugAllergy]
		WHERE [HMRuleUid] = @HMRuleUid
			AND [QuestionUid] = @QuestionUid
		ORDER BY [LastModifiedDate] DESC

		DELETE [RelHMRuleDrugAllergy]
		WHERE [HMRuleUid] = @HMRuleUid
			AND [QuestionUid] = @QuestionUid
			AND [RelHMRuleDrugAllergyUid] <> @RelHMRuleDrugAllergyUid

		FETCH NEXT FROM RelHMRuleDrugAllergy_CSR INTO @HMRuleUid, @QuestionUid
	END
	CLOSE RelHMRuleDrugAllergy_CSR
	DEALLOCATE RelHMRuleDrugAllergy_CSR
END

DECLARE @DuplicatedRelHMRuleDrugClass_TBL TABLE
(
	[HMRuleUid] [uniqueidentifier],
	[ClassUid] [uniqueidentifier],
	primary key([HMRuleUid], [ClassUid])
)

INSERT @DuplicatedRelHMRuleDrugClass_TBL
SELECT rhmrdc.[HMRuleUid], rhmrdc.[ClassUid]
FROM [ListHMRule] AS lhmr
	INNER JOIN [RelHMRuleDrugClass] AS rhmrdc ON lhmr.[HMRuleUid] = rhmrdc.[HMRuleUid]
WHERE lhmr.[Inactive] = @Active
GROUP BY rhmrdc.[HMRuleUid], rhmrdc.[ClassUid]
HAVING COUNT(*) > 1

IF EXISTS(
	SELECT TOP 1 *
	FROM @DuplicatedRelHMRuleDrugClass_TBL
)
BEGIN
	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[cus_RelHMRuleDrugClass]') AND type in (N'U'))
	BEGIN
		SELECT *
		INTO [cus_RelHMRuleDrugClass]
		FROM [RelHMRuleDrugClass]
		WHERE [RelHMRuleDrugClassUid] IS NULL
	END

	INSERT [cus_RelHMRuleDrugClass]
	SELECT rhmrdc.*
	FROM @DuplicatedRelHMRuleDrugClass_TBL AS vrhmrdc
		INNER JOIN [RelHMRuleDrugClass] AS rhmrdc ON vrhmrdc.[HMRuleUid] = rhmrdc.[HMRuleUid]
			AND vrhmrdc.[ClassUid] = rhmrdc.[ClassUid]
		LEFT OUTER JOIN [cus_RelHMRuleDrugClass] AS crhmrdc ON rhmrdc.[HMRuleUid] = crhmrdc.[HMRuleUid]
			AND rhmrdc.[ClassUid] = crhmrdc.[ClassUid]
	WHERE crhmrdc.[RelHMRuleDrugClassUid] IS NULL

	DECLARE @RelHMRuleDrugClassUid [uniqueidentifier]

	DECLARE RelHMRuleDrugClass_CSR CURSOR FAST_FORWARD FOR
	SELECT *
	FROM @DuplicatedRelHMRuleDrugClass_TBL

	OPEN RelHMRuleDrugClass_CSR
	FETCH NEXT FROM RelHMRuleDrugClass_CSR INTO @HMRuleUid, @ClassUid

	WHILE @@FETCH_STATUS = 0
	BEGIN
		SELECT TOP 1 @RelHMRuleDrugClassUid = [RelHMRuleDrugClassUid]
		FROM [RelHMRuleDrugClass]
		WHERE [HMRuleUid] = @HMRuleUid
			AND [ClassUid] = @ClassUid
		ORDER BY [LastModifiedDate] DESC

		DELETE [RelHMRuleDrugClass]
		WHERE [HMRuleUid] = @HMRuleUid
			AND [ClassUid] = @ClassUid
			AND [RelHMRuleDrugClassUid] <> @RelHMRuleDrugClassUid

		FETCH NEXT FROM RelHMRuleDrugClass_CSR INTO @HMRuleUid, @ClassUid
	END
	CLOSE RelHMRuleDrugClass_CSR
	DEALLOCATE RelHMRuleDrugClass_CSR
END

DECLARE @DuplicatedRelHMRuleDrugName_TBL TABLE
(
	[HMRuleUid] [uniqueidentifier],
	[DrugNameUid] [uniqueidentifier],
	primary key ([HMRuleUid], [DrugNameUid])
)

INSERT @DuplicatedRelHMRuleDrugName_TBL
SELECT rhmrdn.[HMRuleUid], rhmrdn.[DrugNameUid]
FROM [ListHMRule] AS lhmr
	INNER JOIN [RelHMRuleDrugName] AS rhmrdn  ON lhmr.[HMRuleUid] = rhmrdn.[HMRuleUid]
WHERE lhmr.[Inactive] = @Active
GROUP BY rhmrdn.[HMRuleUid], rhmrdn.[DrugNameUid]
HAVING COUNT(*) > 1

IF EXISTS(
	SELECT TOP 1 *
	FROM @DuplicatedRelHMRuleDrugName_TBL
)
BEGIN
	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[cus_RelHMRuleDrugName]') AND type in (N'U'))
	BEGIN
		SELECT *
		INTO [cus_RelHMRuleDrugName]
		FROM [RelHMRuleDrugName]
		WHERE [RelHMRuleDrugNameUid] IS NULL
	END 

	INSERT [cus_RelHMRuleDrugName]
	SELECT rhmrdn.*
	FROM @DuplicatedRelHMRuleDrugName_TBL AS vrhmrdn
		INNER JOIN [RelHMRuleDrugName] AS rhmrdn ON vrhmrdn.[HMRuleUid] = rhmrdn.[HMRuleUid]
			AND vrhmrdn.[DrugNameUid] = rhmrdn.[DrugNameUid]
		LEFT OUTER JOIN [cus_RelHMRuleDrugName] AS crhmrdn ON rhmrdn.[HMRuleUid] = crhmrdn.[HMRuleUid]
			AND rhmrdn.[DrugNameUid] = crhmrdn.[DrugNameUid]
	WHERE crhmrdn.[RelHMRuleDrugNameUid] IS NULL

	DECLARE @RelHMRuleDrugNameUid [uniqueidentifier]

	DECLARE RelHMRuleDrugName_CSR CURSOR FAST_FORWARD FOR
	SELECT *
	FROM @DuplicatedRelHMRuleDrugName_TBL

	OPEN RelHMRuleDrugName_CSR
	FETCH NEXT FROM RelHMRuleDrugName_CSR INTO @HMRuleUid, @DrugNameUid

	WHILE @@FETCH_STATUS = 0
	BEGIN
		SELECT TOP 1 @RelHMRuleDrugNameUid = [RelHMRuleDrugNameUid]
		FROM [RelHMRuleDrugName]
		WHERE [HMRuleUid] = @HMRuleUid
			AND [DrugNameUid] = @DrugNameUid
		ORDER BY [LastModifiedDate] DESC

		DELETE [RelHMRuleDrugName]
		WHERE [HMRuleUid] = @HMRuleUid
			AND [DrugNameUid] = @DrugNameUid
			AND [RelHMRuleDrugNameUid] <> @RelHMRuleDrugNameUid

		FETCH NEXT FROM RelHMRuleDrugName_CSR INTO @HMRuleUid, @DrugNameUid
	END
	CLOSE RelHMRuleDrugName_CSR
	DEALLOCATE RelHMRuleDrugName_CSR
END

DECLARE @DuplicatedRelHMRuleProcedure_TBL TABLE
(
	[HMRuleUid] [uniqueidentifier],
	[ProcedureUid] [uniqueidentifier],
	primary key([HMRuleUid], [ProcedureUid])
)

INSERT @DuplicatedRelHMRuleProcedure_TBL
SELECT rhmrp.[HMRuleUid], rhmrp.[ProcedureUid]
FROM [ListHMRule] AS lhmr
	INNER JOIN [RelHMRuleProcedure] AS rhmrp ON lhmr.[HMRuleUid] = rhmrp.[HMRuleUid]
WHERE lhmr.[Inactive] = @Active
GROUP BY rhmrp.[HMRuleUid], rhmrp.[ProcedureUid]
HAVING COUNT(*) > 1

IF EXISTS(
	SELECT TOP 1 *
	FROM @DuplicatedRelHMRuleProcedure_TBL
)
BEGIN
	IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[cus_RelHMRuleProcedure]') AND type in (N'U'))
	BEGIN
		SELECT *
		INTO [cus_RelHMRuleProcedure]
		FROM [RelHMRuleProcedure]
		WHERE [RelHMRuleProcedureUid] IS NULL
	END

	INSERT [cus_RelHMRuleProcedure]
	SELECT rhmrp.*
	FROM @DuplicatedRelHMRuleProcedure_TBL AS vrhmrp
		INNER JOIN [RelHMRuleProcedure] AS rhmrp ON vrhmrp.[HMRuleUid] = rhmrp.[HMRuleUid]
			AND vrhmrp.[ProcedureUid] = rhmrp.[ProcedureUid]
		LEFT OUTER JOIN [cus_RelHMRuleProcedure] AS crhmrp ON rhmrp.[HMRuleUid] = crhmrp.[HMRuleUid]
			AND rhmrp.[ProcedureUid] = crhmrp.[ProcedureUid]
	WHERE crhmrp.[RelHMRuleProcedureUid] IS NULL

	DECLARE @RelHMRuleProcedureUid [uniqueidentifier]

	DECLARE RelHMRuleProcedure_CSR CURSOR FAST_FORWARD FOR
	SELECT *
	FROM @DuplicatedRelHMRuleProcedure_TBL

	OPEN RelHMRuleProcedure_CSR
	FETCH NEXT FROM RelHMRuleProcedure_CSR INTO @HMRuleUid, @ProcedureUid

	WHILE @@FETCH_STATUS = 0
	BEGIN
		SELECT TOP 1 @RelHMRuleProcedureUid = [RelHMRuleProcedureUid]
		FROM [RelHMRuleProcedure]
		WHERE [HMRuleUid] = @HMRuleUid
			AND [ProcedureUid] = @ProcedureUid
		ORDER BY [LastModifiedDate] DESC

		DELETE [RelHMRuleProcedure]
		WHERE [HMRuleUid] = @HMRuleUid
			AND [ProcedureUid] = @ProcedureUid
			AND [RelHMRuleProcedureUid] <> @RelHMRuleProcedureUid

		FETCH NEXT FROM RelHMRuleProcedure_CSR INTO @HMRuleUid, @ProcedureUid
	END
	CLOSE RelHMRuleProcedure_CSR
	DEALLOCATE RelHMRuleProcedure_CSR
END
GO