IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AlterXmlSchema]') AND type in (N'P', N'PC'))
DROP PROCEDURE [dbo].[AlterXmlSchema]
GO
IF NOT EXISTS (SELECT * FROM sys.xml_schema_collections c, sys.schemas s WHERE c.schema_id = s.schema_id AND (quotename(s.name) + '.' + quotename(c.name)) = N'[dbo].[Address]')
CREATE XML SCHEMA COLLECTION [dbo].[Address] AS N'<xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema" elementFormDefault="qualified"><xsd:element name="Address"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:sequence><xsd:element name="Address1" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="100" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="Address2" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="100" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="City" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="35" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="State" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="3" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="Zip" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="10" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="Country" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="25" /></xsd:restriction></xsd:simpleType></xsd:element></xsd:sequence></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element></xsd:schema>'
GO
IF NOT EXISTS (SELECT * FROM sys.xml_schema_collections c, sys.schemas s WHERE c.schema_id = s.schema_id AND (quotename(s.name) + '.' + quotename(c.name)) = N'[dbo].[DirectAddressConfigurationData]')
CREATE XML SCHEMA COLLECTION [dbo].[DirectAddressConfigurationData] AS N'<xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema"><xsd:element name="DirectAddressConfiguration"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:sequence><xsd:element name="Nitor" minOccurs="0" maxOccurs="unbounded"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:sequence /><xsd:attribute name="Password" type="xsd:string" use="required" /></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element></xsd:sequence></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element></xsd:schema>'
GO
IF NOT EXISTS (SELECT * FROM sys.xml_schema_collections c, sys.schemas s WHERE c.schema_id = s.schema_id AND (quotename(s.name) + '.' + quotename(c.name)) = N'[dbo].[DirectoryServiceLevel]')
CREATE XML SCHEMA COLLECTION [dbo].[DirectoryServiceLevel] AS N'<xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema" elementFormDefault="qualified"><xsd:element name="ServiceLevel"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:sequence><xsd:element name="Service" maxOccurs="unbounded"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:sequence /><xsd:attribute name="Name" type="xsd:string" use="required" /><xsd:attribute name="BitValue" type="xsd:long" use="required" /><xsd:attribute name="ePrescribe" type="xsd:boolean" use="required" /></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element></xsd:sequence></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element></xsd:schema>'
GO
IF NOT EXISTS (SELECT * FROM sys.xml_schema_collections c, sys.schemas s WHERE c.schema_id = s.schema_id AND (quotename(s.name) + '.' + quotename(c.name)) = N'[dbo].[DirectorySpecialtyType]')
CREATE XML SCHEMA COLLECTION [dbo].[DirectorySpecialtyType] AS N'<xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema" elementFormDefault="qualified"><xsd:element name="DirectorySpecialty"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:sequence><xsd:element name="Specialty" maxOccurs="unbounded"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:sequence /><xsd:attribute name="Name" type="xsd:string" use="required" /><xsd:attribute name="BitValue" type="xsd:long" use="required" /></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element></xsd:sequence></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element></xsd:schema>'
GO
IF NOT EXISTS (SELECT * FROM sys.xml_schema_collections c, sys.schemas s WHERE c.schema_id = s.schema_id AND (quotename(s.name) + '.' + quotename(c.name)) = N'[dbo].[eRxRequestXML]')
CREATE XML SCHEMA COLLECTION [dbo].[eRxRequestXML] AS N'<xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema" elementFormDefault="qualified"><xsd:element name="eRxRequestXML"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:all><xsd:element name="exportMajorVersion" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:pattern value="[ !-~]*" /><xsd:maxLength value="35" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="exportMinorVersion" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:pattern value="[ !-~]*" /><xsd:maxLength value="35" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="OutboundUid" type="guid" minOccurs="0" nillable="true" /><xsd:element name="eRxMessageTypeUid" type="guid" /><xsd:element name="SubmitByUid" type="guid" minOccurs="0" nillable="true" /><xsd:element name="RelatesToMessageID" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:pattern value="[ !-~]*" /><xsd:maxLength value="35" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="RxReferenceNumber" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:pattern value="[ !-~]*" /><xsd:maxLength value="35" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="OrderNumber" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:pattern value="[ !-~]*" /><xsd:maxLength value="35" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="OrderDateTime" type="xsd:dateTime" minOccurs="0" nillable="true" /><xsd:element name="Processed" type="xsd:boolean" minOccurs="0" default="0" /><xsd:element name="Successful" type="xsd:boolean" minOccurs="0" default="0" /><xsd:element name="SendResponse" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="2147483647" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="MessageXML" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="2147483647" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="TransmissionConfigurationUid" type="guid" minOccurs="0" nillable="true" /><xsd:element name="DigestValue" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="2147483647" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="SignatureValue" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="2147483647" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="X509Data" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="2147483647" /></xsd:restriction></xsd:simpleType></xsd:element></xsd:all></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element><xsd:simpleType name="guid"><xsd:restriction base="xsd:string"><xsd:pattern value="[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}" /></xsd:restriction></xsd:simpleType></xsd:schema>'
GO
IF NOT EXISTS (SELECT * FROM sys.xml_schema_collections c, sys.schemas s WHERE c.schema_id = s.schema_id AND (quotename(s.name) + '.' + quotename(c.name)) = N'[dbo].[FormularyData]')
CREATE XML SCHEMA COLLECTION [dbo].[FormularyData] AS N'<xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema"><xsd:element name="FormularyData"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:sequence><xsd:element name="FormularyID" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="10" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="AlternativeID" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="10" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="FormularyStatus" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="2" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="FlatCopayAmount" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="10" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="PercentCopayRate" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="10" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="FirstCopayTerm" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="1" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="CopayTier" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="2" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="CoverageRestrictions" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="50" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="MailOrderUtilized" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="1" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="Initiative" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="35" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="DeliveryMethod" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="1" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="DURIndicator" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="1" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="OSInitialFormularyStatus" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="2" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="OSFlatCopayAmount" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="10" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="OSPercentCopayRate" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="10" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="OSFirstCopayTerm" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="1" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="OSCopayTier" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="2" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="OSNDC" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="11" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="OSRXNORMCode" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="15" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="OSDrugName" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="35" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="OSCoverageRestrictions" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="50" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="LastUploadDateTime" type="iMedica.Framework.Types.PrmDateTime" minOccurs="0" nillable="true" /><xsd:element name="PMBCMessageID" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="50" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="ORxBin" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="50" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="ORxGroup" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="50" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="ORxPCN" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="50" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="IsSpecialtySureScripts" type="xsd:boolean" minOccurs="0" default="0" /></xsd:sequence></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element><xsd:simpleType name="iMedica.Framework.Types.PrmDateTime"><xsd:restriction base="xsd:string"><xsd:pattern value=".*" /></xsd:restriction></xsd:simpleType></xsd:schema>'
GO
IF NOT EXISTS (SELECT * FROM sys.xml_schema_collections c, sys.schemas s WHERE c.schema_id = s.schema_id AND (quotename(s.name) + '.' + quotename(c.name)) = N'[dbo].[GoalColors]')
CREATE XML SCHEMA COLLECTION [dbo].[GoalColors] AS N'<xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema"><xsd:element name="GoalColors"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:sequence /><xsd:attribute name="Achieved" type="xsd:string" /><xsd:attribute name="NotAchieved" type="xsd:string" /></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element></xsd:schema>'
GO
IF NOT EXISTS (SELECT * FROM sys.xml_schema_collections c, sys.schemas s WHERE c.schema_id = s.schema_id AND (quotename(s.name) + '.' + quotename(c.name)) = N'[dbo].[KdbOverride]')
CREATE XML SCHEMA COLLECTION [dbo].[KdbOverride] AS N'<xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema"><xsd:element name="Override"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:sequence><xsd:element name="generic" minOccurs="0" maxOccurs="unbounded"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:sequence /><xsd:attribute name="Uid" type="guid" use="required" /><xsd:attribute name="Name" type="xsd:string" /><xsd:attribute name="Hide" type="xsd:boolean" /><xsd:attribute name="DisplayOrder" type="xsd:integer" /></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element></xsd:sequence></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element><xsd:simpleType name="guid"><xsd:restriction base="xsd:string"><xsd:pattern value="[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}" /></xsd:restriction></xsd:simpleType></xsd:schema>'
GO
IF NOT EXISTS (SELECT * FROM sys.xml_schema_collections c, sys.schemas s WHERE c.schema_id = s.schema_id AND (quotename(s.name) + '.' + quotename(c.name)) = N'[dbo].[KdbOverrideCC]')
CREATE XML SCHEMA COLLECTION [dbo].[KdbOverrideCC] AS N'<xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema"><xsd:element name="Override"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:sequence><xsd:element name="cc" minOccurs="0" maxOccurs="unbounded"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:sequence /><xsd:attribute name="Uid" type="guid" use="required" /><xsd:attribute name="Name" type="xsd:string" /><xsd:attribute name="Hide" type="xsd:boolean" /><xsd:attribute name="DisplayOrder" type="xsd:integer" /><xsd:attribute name="Preposition" type="xsd:string" /></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element></xsd:sequence></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element><xsd:simpleType name="guid"><xsd:restriction base="xsd:string"><xsd:pattern value="[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}" /></xsd:restriction></xsd:simpleType></xsd:schema>'
GO
IF NOT EXISTS (SELECT * FROM sys.xml_schema_collections c, sys.schemas s WHERE c.schema_id = s.schema_id AND (quotename(s.name) + '.' + quotename(c.name)) = N'[dbo].[KdbOverrideDpn]')
CREATE XML SCHEMA COLLECTION [dbo].[KdbOverrideDpn] AS N'<xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema"><xsd:element name="Override"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:sequence><xsd:element name="dpn" minOccurs="0" maxOccurs="unbounded"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:sequence /><xsd:attribute name="Uid" type="guid" use="required" /><xsd:attribute name="Name" type="xsd:string" /><xsd:attribute name="NaturalLanguage" type="xsd:string" /><xsd:attribute name="Conjunctor" type="xsd:string" /><xsd:attribute name="DisplayOrder" type="xsd:integer" /><xsd:attribute name="Hide" type="xsd:boolean" /><xsd:attribute name="PreSelected" type="xsd:boolean" /><xsd:attribute name="DefaultFlag" type="xsd:boolean" /><xsd:attribute name="RequiredFlag" type="xsd:boolean" /></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element></xsd:sequence></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element><xsd:simpleType name="guid"><xsd:restriction base="xsd:string"><xsd:pattern value="[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}" /></xsd:restriction></xsd:simpleType></xsd:schema>'
GO
IF NOT EXISTS (SELECT * FROM sys.xml_schema_collections c, sys.schemas s WHERE c.schema_id = s.schema_id AND (quotename(s.name) + '.' + quotename(c.name)) = N'[dbo].[KdbOverridePE]')
CREATE XML SCHEMA COLLECTION [dbo].[KdbOverridePE] AS N'<xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema"><xsd:element name="Override"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:sequence><xsd:element name="pe" minOccurs="0" maxOccurs="unbounded"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:sequence /><xsd:attribute name="Uid" type="guid" use="required" /><xsd:attribute name="Name" type="xsd:string" /><xsd:attribute name="Hide" type="xsd:boolean" /><xsd:attribute name="DisplayOrder" type="xsd:integer" /><xsd:attribute name="NormalFlag" type="xsd:boolean" /><xsd:attribute name="DefaultFlag" type="xsd:boolean" /></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element></xsd:sequence></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element><xsd:simpleType name="guid"><xsd:restriction base="xsd:string"><xsd:pattern value="[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}" /></xsd:restriction></xsd:simpleType></xsd:schema>'
GO
IF NOT EXISTS (SELECT * FROM sys.xml_schema_collections c, sys.schemas s WHERE c.schema_id = s.schema_id AND (quotename(s.name) + '.' + quotename(c.name)) = N'[dbo].[KdbOverrideRos]')
CREATE XML SCHEMA COLLECTION [dbo].[KdbOverrideRos] AS N'<xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema"><xsd:element name="Override"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:sequence><xsd:element name="ros" minOccurs="0" maxOccurs="unbounded"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:sequence /><xsd:attribute name="Uid" type="guid" use="required" /><xsd:attribute name="Name" type="xsd:string" /><xsd:attribute name="Hide" type="xsd:boolean" /><xsd:attribute name="DisplayOrder" type="xsd:integer" /><xsd:attribute name="DenyFlag" type="xsd:string" /></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element></xsd:sequence></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element><xsd:simpleType name="guid"><xsd:restriction base="xsd:string"><xsd:pattern value="[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}" /></xsd:restriction></xsd:simpleType></xsd:schema>'
GO
IF NOT EXISTS (SELECT * FROM sys.xml_schema_collections c, sys.schemas s WHERE c.schema_id = s.schema_id AND (quotename(s.name) + '.' + quotename(c.name)) = N'[dbo].[ListMessageTypeAQN]')
CREATE XML SCHEMA COLLECTION [dbo].[ListMessageTypeAQN] AS N'<xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema" elementFormDefault="qualified"><xsd:element name="aqn"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:sequence><xsd:element name="header" minOccurs="0"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:sequence /><xsd:attribute name="name" type="xsd:string" /><xsd:attribute name="aqn" type="xsd:string" use="required" /></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element><xsd:element name="tabpage" minOccurs="0" maxOccurs="unbounded"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:sequence /><xsd:attribute name="name" type="xsd:string" /><xsd:attribute name="aqn" type="xsd:string" use="required" /><xsd:attribute name="caption" type="xsd:string" use="required" /></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element><xsd:element name="newmessage" minOccurs="0"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:sequence /><xsd:attribute name="name" type="xsd:string" /><xsd:attribute name="aqn" type="xsd:string" use="required" /></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element></xsd:sequence></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element></xsd:schema>'
GO
IF NOT EXISTS (SELECT * FROM sys.xml_schema_collections c, sys.schemas s WHERE c.schema_id = s.schema_id AND (quotename(s.name) + '.' + quotename(c.name)) = N'[dbo].[MedicationConsentData]')
CREATE XML SCHEMA COLLECTION [dbo].[MedicationConsentData] AS N'<xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema" elementFormDefault="qualified"><xsd:element name="MedicationConsentData"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:all><xsd:element name="HowDiscussed" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="255" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="Symptom" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="32000" /></xsd:restriction></xsd:simpleType></xsd:element></xsd:all></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element></xsd:schema>'
GO
IF NOT EXISTS (SELECT * FROM sys.xml_schema_collections c, sys.schemas s WHERE c.schema_id = s.schema_id AND (quotename(s.name) + '.' + quotename(c.name)) = N'[dbo].[MessageData]')
CREATE XML SCHEMA COLLECTION [dbo].[MessageData] AS N'<xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema"><xsd:element name="MessageData"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:sequence><xsd:element name="PayerCreditUidList" minOccurs="0"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="2147483647" /><xsd:pattern value="([a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12})(,[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12})*" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="SuperbillUidList" minOccurs="0"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="2147483647" /><xsd:pattern value="([a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12})(,[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12})*" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="Note" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="2147483647" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="Comment" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="2147483647" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="Source" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="256" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="Acceptance" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="64" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="AmendmentSourceUid" type="guid" minOccurs="0" nillable="true" /><xsd:element name="AmendmentSource" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="64" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="RecordDisclosureAuditUid" type="guid" minOccurs="0" nillable="true" /><xsd:element name="MessageBodyHtml" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="2147483647" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="ProviderDirectoryUid" type="guid" minOccurs="0" nillable="true" /><xsd:element name="MessageUid" type="guid" minOccurs="0" nillable="true" /><xsd:element name="AttachmentUidList" minOccurs="0"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="2147483647" /><xsd:pattern value="([a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12})(,[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12})*" /></xsd:restriction></xsd:simpleType></xsd:element></xsd:sequence></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element><xsd:simpleType name="guid"><xsd:restriction base="xsd:string"><xsd:pattern value="[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}" /></xsd:restriction></xsd:simpleType></xsd:schema>'
GO
IF NOT EXISTS (SELECT * FROM sys.xml_schema_collections c, sys.schemas s WHERE c.schema_id = s.schema_id AND (quotename(s.name) + '.' + quotename(c.name)) = N'[dbo].[OrderInfoData]')
CREATE XML SCHEMA COLLECTION [dbo].[OrderInfoData] AS N'<xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema"><xsd:element name="OrderInfoData"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:choice maxOccurs="unbounded"><xsd:element name="MessageUrgencyUid" type="guid" nillable="true" /><xsd:element name="Technician" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="100" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="LaboratoryUid" type="guid" nillable="true" /><xsd:element name="BillTypeUid" type="guid" nillable="true" /><xsd:element name="PSC" nillable="true" default="False"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:enumeration value="True" /><xsd:enumeration value="False" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="Fasting" nillable="true" default="False"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:enumeration value="True" /><xsd:enumeration value="False" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="OrderDate" type="Neo.Core.NeoDate" nillable="true" /><xsd:element name="DueDate" type="Neo.Core.NeoDate" nillable="true" /><xsd:element name="ExtractDateTime" type="iMedica.Framework.Types.PrmDateTime" nillable="true" /><xsd:element name="OrderProviderUid" type="guid" nillable="true" /><xsd:element name="CreatedBy" type="guid" nillable="true" /><xsd:element name="CreatedDateTime" type="iMedica.Framework.Types.PrmDateTime" nillable="true" /><xsd:element name="RecurrenceType" nillable="true" default="None"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:enumeration value="None" /><xsd:enumeration value="Daily" /><xsd:enumeration value="Weekly" /><xsd:enumeration value="Monthly" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="RecurrenceEndType" nillable="true" default="EndAfter"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:enumeration value="EndAfter" /><xsd:enumeration value="EndBy" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="RecurrenceEndAfter" nillable="true" default="0"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:pattern value="[0-9]*" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="RecurrenceEndBy" type="Neo.Core.NeoDate" nillable="true" /><xsd:element name="RecurrencePatternDailyType" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:enumeration value="Every" /><xsd:enumeration value="Weekday" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="RecurrencePatternDailyEvery" nillable="true" default="0"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:pattern value="[0-9]*" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="RecurrencePatternWeekly" nillable="true" default="0"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:pattern value="[0-9]*" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="RecurrencePatternWeeklySunday" nillable="true" default="False"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:enumeration value="True" /><xsd:enumeration value="False" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="RecurrencePatternWeeklyMonday" nillable="true" default="False"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:enumeration value="True" /><xsd:enumeration value="False" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="RecurrencePatternWeeklyTuesday" nillable="true" default="False"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:enumeration value="True" /><xsd:enumeration value="False" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="RecurrencePatternWeeklyWednesday" nillable="true" default="False"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:enumeration value="True" /><xsd:enumeration value="False" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="RecurrencePatternWeeklyThursday" nillable="true" default="False"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:enumeration value="True" /><xsd:enumeration value="False" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="RecurrencePatternWeeklyFriday" nillable="true" default="False"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:enumeration value="True" /><xsd:enumeration value="False" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="RecurrencePatternWeeklySaturday" nillable="true" default="False"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:enumeration value="True" /><xsd:enumeration value="False" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="RecurrencePatternMonthlyType" nillable="true" default="Day"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:enumeration value="Day" /><xsd:enumeration value="The" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="RecurrencePatternMonthlyDayOfMonth" nillable="true" default="0"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:pattern value="[0-9]*" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="RecurrencePatternMonthlyEvery" nillable="true" default="0"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:pattern value="[0-9]*" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="RecurrencePatternMonthlyTheEvery" nillable="true" default="0"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:pattern value="[0-9]*" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="RecurrencePatternMonthlyTheDaySelect" nillable="true" default="None"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:enumeration value="None" /><xsd:enumeration value="First" /><xsd:enumeration value="Second" /><xsd:enumeration value="Third" /><xsd:enumeration value="Fourth" /><xsd:enumeration value="Fifth" /><xsd:enumeration value="Last" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="RecurrencePatternMonthlyTheDayOfMonth" nillable="true" default="None"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:enumeration value="None" /><xsd:enumeration value="Day" /><xsd:enumeration value="Weekday" /><xsd:enumeration value="Weekend" /><xsd:enumeration value="Sunday" /><xsd:enumeration value="Monday" /><xsd:enumeration value="Tuesday" /><xsd:enumeration value="Wednesday" /><xsd:enumeration value="Thursday" /><xsd:enumeration value="Friday" /><xsd:enumeration value="Saturday" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="PatientMessage" nillable="true" default="False"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:enumeration value="True" /><xsd:enumeration value="False" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="UserMessage" nillable="true" default="False"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:enumeration value="True" /><xsd:enumeration value="False" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="OverdueMessage" nillable="true" default="False"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:enumeration value="True" /><xsd:enumeration value="False" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="UserMessageList" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="2147483647" /><xsd:pattern value="([a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}){0,1}(;[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12})*" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="OverdueMessageList" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="2147483647" /><xsd:pattern value="([a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}){0,1}(;[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12})*" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="PatientMessageDays" nillable="true" default="0"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:pattern value="[0-9]*" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="UserMessageDays" nillable="true" default="0"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:pattern value="[0-9]*" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="OverdueMessageDays" nillable="true" default="0"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:pattern value="[0-9]*" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="PatientMessageFormattingTemplateUid" type="guid" nillable="true" /><xsd:element name="UserMessageFormattingTemplateUid" type="guid" nillable="true" /><xsd:element name="OverdueMessageFormattingTemplateUid" type="guid" nillable="true" /><xsd:element name="OrderAuthorizationCompleted" nillable="true" default="False"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:enumeration value="True" /><xsd:enumeration value="False" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="OrderAuthorizationCase" nillable="true" default="0"><xsd:simpleType><xsd:restriction base="xsd:string" /></xsd:simpleType></xsd:element></xsd:choice></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element><xsd:simpleType name="Neo.Core.NeoDate"><xsd:restriction base="xsd:string"><xsd:pattern value=".*" /></xsd:restriction></xsd:simpleType><xsd:simpleType name="guid"><xsd:restriction base="xsd:string"><xsd:pattern value=".*" /></xsd:restriction></xsd:simpleType><xsd:simpleType name="iMedica.Framework.Types.PrmDateTime"><xsd:restriction base="xsd:string"><xsd:pattern value=".*" /></xsd:restriction></xsd:simpleType></xsd:schema>'
GO
IF NOT EXISTS (SELECT * FROM sys.xml_schema_collections c, sys.schemas s WHERE c.schema_id = s.schema_id AND (quotename(s.name) + '.' + quotename(c.name)) = N'[dbo].[PatientInternetEmails]')
CREATE XML SCHEMA COLLECTION [dbo].[PatientInternetEmails] AS N'<xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema" elementFormDefault="qualified"><xsd:element name="PatientEmails"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:sequence><xsd:element name="PatientEmail" minOccurs="0" maxOccurs="unbounded"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:sequence /><xsd:attribute name="Name" type="xsd:string" /><xsd:attribute name="FormattingTemplateUid" type="guid" /><xsd:attribute name="Checked" type="xsd:boolean" /></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element></xsd:sequence></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element><xsd:simpleType name="guid"><xsd:restriction base="xsd:string"><xsd:pattern value="[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}" /></xsd:restriction></xsd:simpleType></xsd:schema>'
GO
IF NOT EXISTS (SELECT * FROM sys.xml_schema_collections c, sys.schemas s WHERE c.schema_id = s.schema_id AND (quotename(s.name) + '.' + quotename(c.name)) = N'[dbo].[PatientMessagesToUserGroup]')
CREATE XML SCHEMA COLLECTION [dbo].[PatientMessagesToUserGroup] AS N'<xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema" elementFormDefault="qualified"><xsd:element name="PatientMessages"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:sequence><xsd:element name="PatientMessage" minOccurs="0" maxOccurs="unbounded"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:sequence /><xsd:attribute name="MessageTypeUid" type="guid" /><xsd:attribute name="MessageSubTypeUid" type="guid" /><xsd:attribute name="MessageSubTypeName" type="xsd:string" /><xsd:attribute name="UserGroupUid" type="guid" /></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element></xsd:sequence></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element><xsd:simpleType name="guid"><xsd:restriction base="xsd:string"><xsd:pattern value="[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}" /></xsd:restriction></xsd:simpleType></xsd:schema>'
GO
IF NOT EXISTS (SELECT * FROM sys.xml_schema_collections c, sys.schemas s WHERE c.schema_id = s.schema_id AND (quotename(s.name) + '.' + quotename(c.name)) = N'[dbo].[PatientPortalSecurityAnswers]')
CREATE XML SCHEMA COLLECTION [dbo].[PatientPortalSecurityAnswers] AS N'<xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema"><xsd:element name="SecurityAnswers"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:sequence><xsd:element name="Answer" minOccurs="0" maxOccurs="unbounded"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:sequence /><xsd:attribute name="QuestionUid" type="guid" use="required" /><xsd:attribute name="QuestionText" type="xsd:string" use="required" /><xsd:attribute name="AnswerText" type="xsd:string" use="required" /><xsd:attribute name="DisplayOrder" type="xsd:integer" use="required" /></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element></xsd:sequence></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element><xsd:simpleType name="guid"><xsd:restriction base="xsd:string"><xsd:pattern value="[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}" /></xsd:restriction></xsd:simpleType></xsd:schema>'
GO
IF NOT EXISTS (SELECT * FROM sys.xml_schema_collections c, sys.schemas s WHERE c.schema_id = s.schema_id AND (quotename(s.name) + '.' + quotename(c.name)) = N'[dbo].[Phone]')
CREATE XML SCHEMA COLLECTION [dbo].[Phone] AS N'<xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema" elementFormDefault="qualified"><xsd:element name="Phone"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:all><xsd:element name="PhoneNumber"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="80" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="PhoneTypeUid" type="guid" /><xsd:element name="PhoneType"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="50" /></xsd:restriction></xsd:simpleType></xsd:element></xsd:all></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element><xsd:simpleType name="guid"><xsd:restriction base="xsd:string"><xsd:pattern value="[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}" /></xsd:restriction></xsd:simpleType></xsd:schema>'
GO
IF NOT EXISTS (SELECT * FROM sys.xml_schema_collections c, sys.schemas s WHERE c.schema_id = s.schema_id AND (quotename(s.name) + '.' + quotename(c.name)) = N'[dbo].[PreviousData]')
CREATE XML SCHEMA COLLECTION [dbo].[PreviousData] AS N'<xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema" elementFormDefault="qualified"><xsd:element name="PreviousData"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:all><xsd:element name="RMID" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:integer" /></xsd:simpleType></xsd:element><xsd:element name="Name" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="255" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="StopDate" type="DateTime" minOccurs="0" nillable="true" /><xsd:element name="DiscontinueReasonUid" type="guid" minOccurs="0" nillable="true" /><xsd:element name="RelPatientMedicationUid" type="guid" minOccurs="0" nillable="true" /></xsd:all></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element><xsd:simpleType name="DateTime"><xsd:restriction base="xsd:dateTime" /></xsd:simpleType><xsd:simpleType name="guid"><xsd:restriction base="xsd:string"><xsd:pattern value="[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}" /></xsd:restriction></xsd:simpleType></xsd:schema>'
GO
IF NOT EXISTS (SELECT * FROM sys.xml_schema_collections c, sys.schemas s WHERE c.schema_id = s.schema_id AND (quotename(s.name) + '.' + quotename(c.name)) = N'[dbo].[SelectionColor]')
CREATE XML SCHEMA COLLECTION [dbo].[SelectionColor] AS N'<xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema"><xsd:element name="SelectionColor"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:sequence /><xsd:attribute name="ForeColor" type="xsd:string" /><xsd:attribute name="BackColor" type="xsd:string" /><xsd:attribute name="BorderColor" type="xsd:string" /><xsd:attribute name="BorderWidth" type="xsd:short" /></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element></xsd:schema>'
GO
IF NOT EXISTS (SELECT * FROM sys.xml_schema_collections c, sys.schemas s WHERE c.schema_id = s.schema_id AND (quotename(s.name) + '.' + quotename(c.name)) = N'[dbo].[TimeFrame]')
CREATE XML SCHEMA COLLECTION [dbo].[TimeFrame] AS N'<xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema" elementFormDefault="qualified"><xsd:element name="TimeFrame"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:all><xsd:element name="Answer" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="255" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="Value" minOccurs="0" nillable="true"><xsd:simpleType><xsd:restriction base="xsd:string"><xsd:maxLength value="255" /></xsd:restriction></xsd:simpleType></xsd:element><xsd:element name="FuzzyDate" type="DateTime" minOccurs="0" nillable="true" /><xsd:element name="TimeFrameUid" type="guid" minOccurs="0" nillable="true" /></xsd:all></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element><xsd:simpleType name="DateTime"><xsd:restriction base="xsd:dateTime" /></xsd:simpleType><xsd:simpleType name="guid"><xsd:restriction base="xsd:string"><xsd:pattern value="[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}" /></xsd:restriction></xsd:simpleType></xsd:schema>'
GO
IF NOT EXISTS (SELECT * FROM sys.xml_schema_collections c, sys.schemas s WHERE c.schema_id = s.schema_id AND (quotename(s.name) + '.' + quotename(c.name)) = N'[dbo].[UidList]')
CREATE XML SCHEMA COLLECTION [dbo].[UidList] AS N'<xsd:schema xmlns:xsd="http://www.w3.org/2001/XMLSchema"><xsd:element name="item"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:choice><xsd:any processContents="skip" minOccurs="0" maxOccurs="unbounded" /></xsd:choice><xsd:attribute name="Name" type="xsd:string" use="required" /><xsd:attribute name="Uid" type="guid" use="required" /><xsd:attribute name="DisplayOrder" type="xsd:integer" /></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element><xsd:element name="items"><xsd:complexType><xsd:complexContent><xsd:restriction base="xsd:anyType"><xsd:sequence><xsd:element ref="item" maxOccurs="unbounded" /></xsd:sequence></xsd:restriction></xsd:complexContent></xsd:complexType></xsd:element><xsd:simpleType name="guid"><xsd:restriction base="xsd:string"><xsd:pattern value="[a-fA-F0-9]{8}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{4}-[a-fA-F0-9]{12}" /></xsd:restriction></xsd:simpleType></xsd:schema>'
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AlterXmlSchema]') AND type in (N'P', N'PC'))
BEGIN
EXEC dbo.sp_executesql @statement = N'CREATE PROCEDURE [dbo].[AlterXmlSchema] AS' 
END
GO
ALTER PROC [dbo].[AlterXmlSchema] @xmlSchemaName VARCHAR(255), @xmlSchema NVARCHAR(MAX) AS

DECLARE @table TABLE(	TableName VARCHAR(255),
						ColumnName VARCHAR(255)
					)
					
DECLARE @index TABLE(	TableName VARCHAR(255),
						ColumnName VARCHAR(255),
						IndexName VARCHAR(255)
					)

PRINT 'Getting list of tables with XML bound Schema'
			
INSERT	@table
SELECT	t.name AS [Table], c.name AS [Column]
FROM	sys.xml_schema_collections xsc INNER JOIN sys.columns c ON xsc.xml_collection_id = c.xml_collection_id
		INNER JOIN sys.objects t ON c.object_id = t.object_id AND t.Type = 'U'
WHERE	xsc.name = @xmlSchemaName

DECLARE @tableName VARCHAR(255)
DECLARE @columnName VARCHAR(255)

PRINT 'Removing Schema from the Columns'
DECLARE cur CURSOR FOR SELECT * FROM @table
OPEN cur

FETCH NEXT FROM cur INTO @tableName, @columnName
WHILE @@FETCH_STATUS = 0
BEGIN	
	PRINT 'Running DBCC CleanTable on ' + @tableName
	exec('DBCC CLEANTABLE (0, "' + @tableName + '") WITH NO_INFOMSGS;')

	PRINT 'Altering Column Removing Schema ' + @tableName + '.' + @columnName
	exec('ALTER TABLE [' + @tableName + '] ALTER COLUMN ' + @columnName + ' XML')

	PRINT 'Running DBCC CleanTable on ' + @tableName
	exec('DBCC CLEANTABLE (0, "' + @tableName + '") WITH NO_INFOMSGS;')

	FETCH NEXT FROM cur INTO @tableName, @columnName
END
CLOSE cur

PRINT 'Rebuilding Views to remove XML Schema'
DECLARE @views TABLE( value VARCHAR(MAX))
DECLARE @viewName VARCHAR(255)
DECLARE @views_text VARCHAR(MAX)
DECLARE vws CURSOR FOR SELECT t.name AS [View]
	FROM	sys.xml_schema_collections xsc INNER JOIN sys.columns c ON xsc.xml_collection_id = c.xml_collection_id
			INNER JOIN sys.objects t ON c.object_id = t.object_id AND t.Type = 'V'
	WHERE	xsc.name = @xmlSchemaName

OPEN vws
FETCH NEXT FROM vws INTO @viewName
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @views_text = ''
	DELETE FROM @views
	
	INSERT INTO @views exec sp_helptext @viewName
	
	SELECT @views_text = @views_text + value FROM @views

	exec('DROP VIEW ' + @viewName)
	
	exec(@views_text)	

	FETCH NEXT FROM vws INTO @viewName
END
CLOSE vws

IF EXISTS(SELECT * FROM sys.xml_schema_collections WHERE name = @xmlSchemaName)
BEGIN
	PRINT 'Dropping Xml Schema'
	exec('DROP XML SCHEMA COLLECTION ' + @xmlSchemaName)
END

PRINT 'Creating Xml Schema'
select 'CREATE XML SCHEMA COLLECTION ' + @xmlSchemaName + ' AS N''' + @xmlSchema + ''''
exec('CREATE XML SCHEMA COLLECTION ' + @xmlSchemaName + ' AS N''' + @xmlSchema + '''')

PRINT 'Adding Schema to the Columns'
OPEN cur
FETCH NEXT FROM cur INTO @tableName, @columnName
WHILE @@FETCH_STATUS = 0
BEGIN	
	PRINT 'Running DBCC CleanTable on ' + @tableName
	exec('DBCC CLEANTABLE (0, "' + @tableName + '") WITH NO_INFOMSGS;')
	
	PRINT 'Altering Column Adding Schema ' + @tableName + '.' + @columnName
	exec('ALTER TABLE [' + @tableName + '] ALTER COLUMN ' + @columnName + ' XML(' + @xmlSchemaName + ')')

	PRINT 'Running DBCC CleanTable on ' + @tableName
	exec('DBCC CLEANTABLE (0, "' + @tableName + '") WITH NO_INFOMSGS;')
	
	FETCH NEXT FROM cur INTO @tableName, @columnName
END
CLOSE cur
DEALLOCATE cur

PRINT 'Rebuilding Views for Schema'
OPEN vws
FETCH NEXT FROM vws INTO @viewName
WHILE @@FETCH_STATUS = 0
BEGIN
	SET @views_text = ''
	DELETE FROM @views
	
	INSERT INTO @views exec sp_helptext @viewName
	
	SELECT @views_text = @views_text + value FROM @views

	exec('DROP VIEW ' + @viewName)
	
	exec(@views_text)	

	FETCH NEXT FROM vws INTO @viewName
END
CLOSE vws
DEALLOCATE vws

GO

