/****** Object:  Index [PK_AccountResponsiblePartyFinancialCenter]    Script Date: 10/30/2018 11:16:21 AM ******/
IF  EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[RelAccountResponsiblePartyFinancialCenter]') AND name = N'PK_AccountResponsiblePartyFinancialCenter')
ALTER TABLE [dbo].[RelAccountResponsiblePartyFinancialCenter] DROP CONSTRAINT [PK_AccountResponsiblePartyFinancialCenter] WITH ( ONLINE = OFF )
GO



BEGIN TRAN
IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[BatchProcess]') AND type in (N'U'))
ALTER TABLE [BatchProcess] ADD [StageHistory] varchar(max) NULL 
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ChartAccessDeny]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ChartAccessDeny](
	[ChartAccessDenyUid] [uniqueidentifier] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[UserUid] [uniqueidentifier] NULL,
	[UserGroupUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NOT NULL
) ON [PRIMARY]


ALTER TABLE [ChartAccessDeny] ADD  CONSTRAINT [DF_ChartAccessDeny_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ChartDeniedMessageRouting]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ChartDeniedMessageRouting](
	[ChartDeniedMessageRoutingUid] [uniqueidentifier] NOT NULL,
	[PracticeSettingsUid] [uniqueidentifier] NOT NULL,
	[UserUid] [uniqueidentifier] NULL,
	[UserGroupUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.UserPRM', @value=N'FK_ChartDeniedMessageRouting_UserPRM' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ChartDeniedMessageRouting'

ALTER TABLE [ChartDeniedMessageRouting] ADD  CONSTRAINT [DF_ChartDeniedMessageRouting_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ChcAccountResponsiblePartySFHistory]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ChcAccountResponsiblePartySFHistory](
	[AccountResponsiblePartySFHistoryUid] [uniqueidentifier] NOT NULL,
	[AccountResponsiblePartyUid] [uniqueidentifier] NOT NULL,
	[FamilySize] [tinyint] NOT NULL,
	[MonthlyIncome] [money] NOT NULL,
	[NoIncome] [bit] NOT NULL,
	[SFCorporationUid] [uniqueidentifier] NULL,
	[SFScheduleDetailUid] [uniqueidentifier] NULL,
	[SFFormOfDeclarationUid] [uniqueidentifier] NULL,
	[SFEffectiveDate] [date] NULL,
	[NotFedSFQual] [bit] NOT NULL,
	[RefusedFSMI] [bit] NOT NULL,
	[UseSFClass] [bit] NOT NULL,
	[SFNote] [text] NULL,
	[PayFrequency] [smallint] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ChcAccountResponsiblePartySFHistory'

ALTER TABLE [migtemp_ChcAccountResponsiblePartySFHistory] ADD  CONSTRAINT [DF_ChcAccountResponsiblePartySFHistory_AccountResponsiblePartySFHistoryUid]  DEFAULT (newid()) FOR [AccountResponsiblePartySFHistoryUid]
ALTER TABLE [migtemp_ChcAccountResponsiblePartySFHistory] ADD  CONSTRAINT [DF_ChcAccountResponsiblePartySFHistory_FamilySize]  DEFAULT ((0)) FOR [FamilySize]
ALTER TABLE [migtemp_ChcAccountResponsiblePartySFHistory] ADD  CONSTRAINT [DF_ChcAccountResponsiblePartySFHistory_MonthlyIncome]  DEFAULT ((0)) FOR [MonthlyIncome]
ALTER TABLE [migtemp_ChcAccountResponsiblePartySFHistory] ADD  CONSTRAINT [DF_ChcAccountResponsiblePartySFHistory_NoIncome]  DEFAULT ((1)) FOR [NoIncome]
ALTER TABLE [migtemp_ChcAccountResponsiblePartySFHistory] ADD  CONSTRAINT [DF_ChcAccountResponsiblePartySFHistory_NotFedSFQual]  DEFAULT ((0)) FOR [NotFedSFQual]
ALTER TABLE [migtemp_ChcAccountResponsiblePartySFHistory] ADD  CONSTRAINT [DF_ChcAccountResponsiblePartySFHistory_RefusedFSMI]  DEFAULT ((0)) FOR [RefusedFSMI]
ALTER TABLE [migtemp_ChcAccountResponsiblePartySFHistory] ADD  CONSTRAINT [DF_ChcAccountResponsiblePartySFHistory_UseSFClass]  DEFAULT ((0)) FOR [UseSFClass]
ALTER TABLE [migtemp_ChcAccountResponsiblePartySFHistory] ADD  CONSTRAINT [DF_ChcAccountResponsiblePartySFHistory_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_ChcAccountResponsiblePartySFHistory
INSERT [migtemp_ChcAccountResponsiblePartySFHistory]([AccountResponsiblePartySFHistoryUid],[AccountResponsiblePartyUid],[FamilySize],[MonthlyIncome],[NoIncome],[SFCorporationUid],[SFScheduleDetailUid],[SFFormOfDeclarationUid],[SFEffectiveDate],[NotFedSFQual],[RefusedFSMI],[UseSFClass],[SFNote],[LastModifiedByUid],[LastModifiedDate])
SELECT [AccountResponsiblePartySFHistoryUid],[AccountResponsiblePartyUid],[FamilySize],[MonthlyIncome],[NoIncome],[SFCorporationUid],[SFScheduleDetailUid],[SFFormOfDeclarationUid],[SFEffectiveDate],[NotFedSFQual],[RefusedFSMI],[UseSFClass],[SFNote],[LastModifiedByUid],[LastModifiedDate]
FROM [ChcAccountResponsiblePartySFHistory]

DROP TABLE [ChcAccountResponsiblePartySFHistory]

exec  sp_rename 'migtemp_ChcAccountResponsiblePartySFHistory', 'ChcAccountResponsiblePartySFHistory'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_CollectionHistory]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_CollectionHistory](
	[CollectionHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[AccountResponsiblePartyUid] [uniqueidentifier] NOT NULL,
	[InitialCollectionStatusUid] [uniqueidentifier] NULL,
	[InitialCollectionStatusLevelUid] [uniqueidentifier] NULL,
	[NewCollectionStatusUid] [uniqueidentifier] NULL,
	[NewCollectionStatusLevelUid] [uniqueidentifier] NULL,
	[CreatedDateTime] [datetime] NOT NULL,
	[Reason] [varchar](500) NOT NULL,
	[Notes] [varchar](max) NULL,
	[DisableAlert] [bit] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'CreatedDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_CollectionHistory', @level2type=N'COLUMN',@level2name=N'CreatedDateTime'
EXEC sys.sp_addextendedproperty @name=N'Replication.ToAvoid', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_CollectionHistory'
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_CollectionHistory'

ALTER TABLE [migtemp_CollectionHistory] ADD  CONSTRAINT [DF_CollectionHistory_CollectionHistoryUid]  DEFAULT (newid()) FOR [CollectionHistoryUid]
ALTER TABLE [migtemp_CollectionHistory] ADD  CONSTRAINT [DF_CollectionHistory_Date]  DEFAULT (getutcdate()) FOR [CreatedDateTime]
ALTER TABLE [migtemp_CollectionHistory] ADD  CONSTRAINT [DF_CollectionHistory_DisableAlert]  DEFAULT ((0)) FOR [DisableAlert]
ALTER TABLE [migtemp_CollectionHistory] ADD  CONSTRAINT [DF_CollectionHistory_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_CollectionHistory
INSERT [migtemp_CollectionHistory]([CollectionHistoryUid],[AccountResponsiblePartyUid],[InitialCollectionStatusUid],[InitialCollectionStatusLevelUid],[NewCollectionStatusUid],[NewCollectionStatusLevelUid],[CreatedDateTime],[Reason],[Notes],[LastModifiedDate])
SELECT [CollectionHistoryUid],[AccountResponsiblePartyUid],[InitialCollectionStatusUid],[InitialCollectionStatusLevelUid],[NewCollectionStatusUid],[NewCollectionStatusLevelUid],[CreatedDateTime],[Reason],[Notes],[LastModifiedDate]
FROM [CollectionHistory]

DROP TABLE [CollectionHistory]

exec  sp_rename 'migtemp_CollectionHistory', 'CollectionHistory'

exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Deposit]') AND type in (N'U'))
ALTER TABLE [Deposit] ADD [TargetFinancialCenterUid] uniqueidentifier NULL 
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EmailResponse]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[EmailResponse](
	[EmailResponseUid] [uniqueidentifier] NOT NULL,
	[EmailTrackingUid] [uniqueidentifier] NOT NULL,
	[ResponseContent] [varchar](max) NOT NULL,
	[CreatedDateTime] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]


ALTER TABLE [EmailResponse] ADD  CONSTRAINT [DF_EmailResponse_CreatedDate]  DEFAULT (getutcdate()) FOR [CreatedDateTime]
ALTER TABLE [EmailResponse] ADD  CONSTRAINT [DF_EmailResponse_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EmailStatus]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[EmailStatus](
	[EmailStatusUid] [uniqueidentifier] NOT NULL,
	[EmailTrackingUid] [uniqueidentifier] NULL,
	[EmailAddress] [varchar](255) NOT NULL,
	[Status] [varchar](50) NOT NULL,
	[StatusExtension] [varchar](50) NULL,
	[Note] [varchar](255) NULL,
	[CreatedDateTime] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]


ALTER TABLE [EmailStatus] ADD  CONSTRAINT [DF_EmailStatus_(getutcdate())]  DEFAULT (getutcdate()) FOR [CreatedDateTime]
ALTER TABLE [EmailStatus] ADD  CONSTRAINT [DF_EmailStatus_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EmailStatusBlock]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[EmailStatusBlock](
	[EmailStatusBlockUid] [uniqueidentifier] NOT NULL,
	[EmailAddress] [varchar](255) NOT NULL,
	[BlockToken] [varchar](25) NOT NULL
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EmailTracking]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[EmailTracking](
	[EmailTrackingUid] [uniqueidentifier] NOT NULL,
	[ListenerAqn] [varchar](512) NOT NULL,
	[ListenerArgs] [varchar](max) NOT NULL,
	[SubjectExtract] [varchar](50) NULL,
	[BodyExtract] [varchar](50) NULL,
	[RequestContent] [varchar](max) NOT NULL,
	[EmailName] [varchar](255) NOT NULL,
	[EmailAddress] [varchar](255) NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]


ALTER TABLE [EmailTracking] ADD  CONSTRAINT [DF_EmailTracking_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EmailUnsubscribeGroup]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[EmailUnsubscribeGroup](
	[EmailUnsubscribeGroupUid] [uniqueidentifier] NOT NULL,
	[Name] [varchar](255) NOT NULL,
	[Description] [varchar](255) NOT NULL,
	[Type] [tinyint] NOT NULL,
	[ReferenceId] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[UserDefined] [tinyint] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Type', @value=N'<Undefined value="0" /><PatientMarketing value="1" /><PatientStatement value="2" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'EmailUnsubscribeGroup'

ALTER TABLE [EmailUnsubscribeGroup] ADD  CONSTRAINT [DF_EmailUnsubscribeGroup_InternalId]  DEFAULT ((0)) FOR [Type]
ALTER TABLE [EmailUnsubscribeGroup] ADD  CONSTRAINT [DF_EmailUnsubscribeGroup_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [EmailUnsubscribeGroup] ADD  CONSTRAINT [DF_EmailUnsubscribeGroup_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
ALTER TABLE [EmailUnsubscribeGroup] ADD  CONSTRAINT [DF_EmailUnsubscribeGroup_UserDefined]  DEFAULT ((1)) FOR [UserDefined]

END
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ERAClaimEntity' AND COLUMN_NAME = 'FirstName')
ALTER TABLE [ERAClaimEntity]  ALTER COLUMN [FirstName] varchar(35) NULL 
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_HL7Partner]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_HL7Partner](
	[HL7PartnerUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[Name] [varchar](50) NULL,
	[ExternalId] [varchar](25) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL,
	[TestMode] [bit] NOT NULL,
	[SendPort] [smallint] NULL,
	[SendMessageDirectory] [varchar](255) NULL,
	[ReceivePort] [smallint] NULL,
	[ReceiveMessageDirectory] [varchar](255) NULL,
	[IpAddress] [varchar](50) NULL,
	[QueueLength] [smallint] NULL,
	[SendAck] [bit] NOT NULL,
	[ReceiveAck] [bit] NOT NULL,
	[AckMessage] [varchar](255) NULL,
	[SegmentSeparator] [varchar](255) NULL,
	[BeginMessagePartOfMessage] [bit] NOT NULL,
	[BeginMessage] [varchar](255) NULL,
	[EndMessage] [varchar](255) NULL,
	[HL7XmlStructure] [varchar](max) NULL,
	[FindTableMappingXml] [varchar](max) NULL,
	[KeepAliveInterval] [int] NULL,
	[MessageTypeMapping] [varchar](1024) NULL,
	[InboundFilePrefix] [varchar](50) NULL,
	[InboundFileSuffix] [varchar](50) NULL,
	[OutboundFilePrefix] [varchar](50) NULL,
	[OutboundFileSuffix] [varchar](50) NULL,
	[FTPAddress] [varchar](50) NULL,
	[FTPUser] [varchar](50) NULL,
	[FTPPassword] [varchar](250) NULL,
	[TranslatorAQN] [varchar](512) NULL,
	[TransmissionAQN] [varchar](512) NULL,
	[TransmissionSettings] [varchar](max) NULL,
	[RestTabXML] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[FTPDownloadPath] [varchar](255) NULL,
	[FTPInboundFilePrefix] [varchar](50) NULL,
	[FTPInboundFileSuffix] [varchar](50) NULL,
	[FTPSecureServer] [bit] NULL,
	[FTPPort] [smallint] NULL,
	[FTPProtocol] [uniqueidentifier] NULL,
	[ConsentStatus] [smallint] NOT NULL,
	[ConsentRequired] [bit] NOT NULL,
	[ConsentSharingProtection] [bit] NOT NULL,
	[UseICD10] [bit] NOT NULL,
	[SendError] [bit] NOT NULL,
	[AlertUserUid] [varchar](max) NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_HL7Partner'
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_HL7Partner'

ALTER TABLE [migtemp_HL7Partner] ADD  CONSTRAINT [DF_HL7Partner_HL7PartnerUid]  DEFAULT (newid()) FOR [HL7PartnerUid]
ALTER TABLE [migtemp_HL7Partner] ADD  CONSTRAINT [DF_HL7Partner_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [migtemp_HL7Partner] ADD  CONSTRAINT [DF_HL7Partner_TestMode]  DEFAULT ((0)) FOR [TestMode]
ALTER TABLE [migtemp_HL7Partner] ADD  CONSTRAINT [DF_HL7Partner_SendAck]  DEFAULT ((0)) FOR [SendAck]
ALTER TABLE [migtemp_HL7Partner] ADD  CONSTRAINT [DF_HL7Partner_ReceiveAck]  DEFAULT ((0)) FOR [ReceiveAck]
ALTER TABLE [migtemp_HL7Partner] ADD  CONSTRAINT [DF_HL7Partner_BeginMessagePartOfMessage]  DEFAULT ((0)) FOR [BeginMessagePartOfMessage]
ALTER TABLE [migtemp_HL7Partner] ADD  CONSTRAINT [DF_HL7Partner_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [migtemp_HL7Partner] ADD  CONSTRAINT [DF_HL7Partner_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
ALTER TABLE [migtemp_HL7Partner] ADD  CONSTRAINT [DF_HL7Partner_ConsentStatus_1]  DEFAULT ((0)) FOR [ConsentStatus]
ALTER TABLE [migtemp_HL7Partner] ADD  CONSTRAINT [DF_HL7Partner_ConsentRequired_1]  DEFAULT ((0)) FOR [ConsentRequired]
ALTER TABLE [migtemp_HL7Partner] ADD  CONSTRAINT [DF_HL7Partner_ConsentSharingProtection]  DEFAULT ((0)) FOR [ConsentSharingProtection]
ALTER TABLE [migtemp_HL7Partner] ADD  CONSTRAINT [DF_HL7Partner_UseICD10]  DEFAULT ((0)) FOR [UseICD10]
ALTER TABLE [migtemp_HL7Partner] ADD  CONSTRAINT [DF_HL7Partner_ZeroSendError]  DEFAULT ((0)) FOR [SendError]

END
Truncate Table migtemp_HL7Partner
INSERT [migtemp_HL7Partner]([HL7PartnerUid],[Name],[ExternalId],[Notes],[Inactive],[TestMode],[SendPort],[SendMessageDirectory],[ReceivePort],[ReceiveMessageDirectory],[IpAddress],[QueueLength],[SendAck],[ReceiveAck],[AckMessage],[SegmentSeparator],[BeginMessagePartOfMessage],[BeginMessage],[EndMessage],[HL7XmlStructure],[FindTableMappingXml],[KeepAliveInterval],[MessageTypeMapping],[InboundFilePrefix],[InboundFileSuffix],[OutboundFilePrefix],[OutboundFileSuffix],[FTPAddress],[FTPUser],[FTPPassword],[TranslatorAQN],[TransmissionAQN],[TransmissionSettings],[UserDefined],[LastModifiedDate],[LastModifiedByUid],[FTPDownloadPath],[FTPInboundFilePrefix],[FTPInboundFileSuffix],[FTPSecureServer],[FTPPort],[FTPProtocol],[ConsentStatus],[ConsentRequired],[ConsentSharingProtection],[UseICD10],[SendError],[AlertUserUid])
SELECT [HL7PartnerUid],[Name],[ExternalId],[Notes],[Inactive],[TestMode],[SendPort],[SendMessageDirectory],[ReceivePort],[ReceiveMessageDirectory],[IpAddress],[QueueLength],[SendAck],[ReceiveAck],[AckMessage],[SegmentSeparator],[BeginMessagePartOfMessage],[BeginMessage],[EndMessage],[HL7XmlStructure],[FindTableMappingXml],[KeepAliveInterval],[MessageTypeMapping],[InboundFilePrefix],[InboundFileSuffix],[OutboundFilePrefix],[OutboundFileSuffix],[FTPAddress],[FTPUser],[FTPPassword],[TranslatorAQN],[TransmissionAQN],[TransmissionSettings],[UserDefined],[LastModifiedDate],[LastModifiedByUid],[FTPDownloadPath],[FTPInboundFilePrefix],[FTPInboundFileSuffix],[FTPSecureServer],[FTPPort],[FTPProtocol],[ConsentStatus],[ConsentRequired],[ConsentSharingProtection],[UseICD10],[SendError],[AlertUserUid]
FROM [HL7Partner]

DROP TABLE [HL7Partner]

exec  sp_rename 'migtemp_HL7Partner', 'HL7Partner'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ImmzForecastDetail]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ImmzForecastDetail](
	[ImmzForeCastDetailUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[CVXCodeUid] [uniqueidentifier] NOT NULL,
	[DateVaccineDue] [date] NOT NULL,
	[EarliestDatetoGive] [date] NOT NULL,
	[DateImmzRecordReceived] [datetime] NOT NULL
) ON [PRIMARY]



END
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[JobSchedule]') AND type in (N'U'))
ALTER TABLE [JobSchedule] ADD [ActionAQN] varchar(1024) NULL 
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListCaseType]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListCaseType](
	[CaseTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[DisplayAlertsOnVisits] [bit] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCaseType', @level2type=N'COLUMN',@level2name=N'CaseTypeUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCaseType', @level2type=N'COLUMN',@level2name=N'ExternalID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCaseType', @level2type=N'COLUMN',@level2name=N'Inactive'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCaseType', @level2type=N'COLUMN',@level2name=N'Name'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCaseType', @level2type=N'COLUMN',@level2name=N'Notes'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCaseType', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCaseType', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'iforeignkey', @value=N'ListCaseTypeModule;ListCaseTypePhase' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCaseType'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'case type' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCaseType'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListCaseType'

ALTER TABLE [migtemp_ListCaseType] ADD  CONSTRAINT [DF_ListCaseType_CaseTypeUid]  DEFAULT (newid()) FOR [CaseTypeUid]
ALTER TABLE [migtemp_ListCaseType] ADD  CONSTRAINT [DisplayAlertsOnVisitsNoNull]  DEFAULT ((0)) FOR [DisplayAlertsOnVisits]
ALTER TABLE [migtemp_ListCaseType] ADD  CONSTRAINT [DF_ListCaseType_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [migtemp_ListCaseType] ADD  CONSTRAINT [DF_ListCaseType_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [migtemp_ListCaseType] ADD  CONSTRAINT [DF_ListCaseType_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_ListCaseType
INSERT [migtemp_ListCaseType]([CaseTypeUid],[ExternalID],[DisplayAlertsOnVisits],[Inactive],[Name],[Notes],[UserDefined],[LastModifiedByUid],[LastModifiedDate])
SELECT [CaseTypeUid],[ExternalID],[DisplayAlertsOnVisits],[Inactive],[Name],[Notes],[UserDefined],[LastModifiedByUid],[LastModifiedDate]
FROM [ListCaseType]

DROP TABLE [ListCaseType]

exec  sp_rename 'migtemp_ListCaseType', 'ListCaseType'

exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[ListCollectionStatus]') AND type in (N'U'))
ALTER TABLE [ListCollectionStatus] ADD [RequireSecurityToBookAppointment] bit NOT NULL CONSTRAINT ListCollectionStatus_RequireSecurityToBookAppointment_Defualt DEFAULT ((0)) 
IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[ListCollectionStatus]') AND type in (N'U'))
ALTER TABLE [ListCollectionStatus] ADD [AlertDays] int NOT NULL CONSTRAINT DF_ListCollectionStatus_AlertDays DEFAULT ((0)) 
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListCP_CarePlan]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListCP_CarePlan](
	[CP_CarePlanUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[LOINCUid] [uniqueidentifier] NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListCP_CarePlan'

ALTER TABLE [ListCP_CarePlan] ADD  CONSTRAINT [DF_ListCarePlan_CarePlanUid]  DEFAULT (newid()) FOR [CP_CarePlanUid]
ALTER TABLE [ListCP_CarePlan] ADD  CONSTRAINT [DF_ListCarePlan_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [ListCP_CarePlan] ADD  CONSTRAINT [DF_ListCarePlan_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [ListCP_CarePlan] ADD  CONSTRAINT [DF_ListCarePlan_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListCP_Goal]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListCP_Goal](
	[CP_GoalUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[GoalValue] [varchar](max) NULL,
	[Value1] [decimal](14, 6) NULL,
	[Value2] [decimal](14, 6) NULL,
	[Colors] [xml](CONTENT [dbo].[GoalColors]) NULL,
	[Operator] [smallint] NULL,
	[AQN] [varchar](512) NULL,
	[ObservationItemUid] [uniqueidentifier] NULL,
	[QuestionUid] [uniqueidentifier] NULL,
	[AnswerUid] [uniqueidentifier] NULL,
	[AchieveGoalAnswerUid] [uniqueidentifier] NULL,
	[LOINCUid] [uniqueidentifier] NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListCP_Goal'

ALTER TABLE [ListCP_Goal] ADD  CONSTRAINT [DF_ListGoal_GoalUid]  DEFAULT (newid()) FOR [CP_GoalUid]
ALTER TABLE [ListCP_Goal] ADD  CONSTRAINT [DF_ListGoal_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [ListCP_Goal] ADD  CONSTRAINT [DF_ListGoal_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [ListCP_Goal] ADD  CONSTRAINT [DF_ListGoal_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListCP_HealthConcern]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListCP_HealthConcern](
	[CP_HealthConcernUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[IsRisk] [bit] NOT NULL,
	[LOINCUid] [uniqueidentifier] NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListCP_HealthConcern'

ALTER TABLE [ListCP_HealthConcern] ADD  CONSTRAINT [DF_ListHealthConcern_HealthConcernUid]  DEFAULT (newid()) FOR [CP_HealthConcernUid]
ALTER TABLE [ListCP_HealthConcern] ADD  CONSTRAINT [DF_ListHealthConcern_IsRisk]  DEFAULT ((0)) FOR [IsRisk]
ALTER TABLE [ListCP_HealthConcern] ADD  CONSTRAINT [DF_ListHealthConcern_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [ListCP_HealthConcern] ADD  CONSTRAINT [DF_ListHealthConcern_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [ListCP_HealthConcern] ADD  CONSTRAINT [DF_ListHealthConcern_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ListERACode' AND COLUMN_NAME = 'Code')
ALTER TABLE [ListERACode]  ALTER COLUMN [Code] varchar(30) NOT NULL 
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ListFaxServer' AND COLUMN_NAME = 'OutboundFolder')
ALTER TABLE [ListFaxServer]  ALTER COLUMN [OutboundFolder] varchar(512) NULL 
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListFormattingTemplate]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListFormattingTemplate](
	[FormattingTemplateUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[RootObjectType] [varchar](256) NULL,
	[Template] [varchar](max) NULL,
	[TemplateParameters] [varchar](max) NULL,
	[FieldParameters] [varchar](max) NULL,
	[Notes] [varchar](max) NULL,
	[AttachmentTypeUid] [uniqueidentifier] NULL,
	[RequireAudit] [bit] NOT NULL,
	[QualifiesAsClinicalSummary] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[IsTextCompatible] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[AuxiliaryLinkToPrimaryFormattingTemplateUid] [uniqueidentifier] NULL,
	[IsPersonNotification] [bit] NOT NULL,
	[IsPersonNotificationConfigured] [bit] NOT NULL
) ON [PRIMARY]


ALTER TABLE [migtemp_ListFormattingTemplate] ADD  CONSTRAINT [DF_ListFormattingTemplate_FormattingTemplateUid]  DEFAULT (newid()) FOR [FormattingTemplateUid]
ALTER TABLE [migtemp_ListFormattingTemplate] ADD  CONSTRAINT [DF_ListFormattingTemplate_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [migtemp_ListFormattingTemplate] ADD  CONSTRAINT [DF_ListFormattingTemplate_RequireAudit]  DEFAULT ((0)) FOR [RequireAudit]
ALTER TABLE [migtemp_ListFormattingTemplate] ADD  CONSTRAINT [DF_ListFormattingTemplate_QualifiesAsClinicalSummary]  DEFAULT ((0)) FOR [QualifiesAsClinicalSummary]
ALTER TABLE [migtemp_ListFormattingTemplate] ADD  CONSTRAINT [DF_ListFormattingTemplate_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [migtemp_ListFormattingTemplate] ADD  CONSTRAINT [DF_ListFormattingTemplate_IsTextCompatible]  DEFAULT ((0)) FOR [IsTextCompatible]
ALTER TABLE [migtemp_ListFormattingTemplate] ADD  CONSTRAINT [DF_ListFormattingTemplate_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
ALTER TABLE [migtemp_ListFormattingTemplate] ADD  CONSTRAINT [DF_ListFormattingTemplate_IsPersonNotification]  DEFAULT ((0)) FOR [IsPersonNotification]
ALTER TABLE [migtemp_ListFormattingTemplate] ADD  CONSTRAINT [DF_ListFormattingTemplate_IsPersonNotificationConfigured]  DEFAULT ((0)) FOR [IsPersonNotificationConfigured]

END
Truncate Table migtemp_ListFormattingTemplate
INSERT [migtemp_ListFormattingTemplate]([FormattingTemplateUid],[ExternalID],[Inactive],[Name],[RootObjectType],[Template],[TemplateParameters],[FieldParameters],[Notes],[AttachmentTypeUid],[RequireAudit],[QualifiesAsClinicalSummary],[UserDefined],[LastModifiedByUid],[LastModifiedDate])
SELECT [FormattingTemplateUid],[ExternalID],[Inactive],[Name],[RootObjectType],[Template],[TemplateParameters],[FieldParameters],[Notes],[AttachmentTypeUid],[RequireAudit],[QualifiesAsClinicalSummary],[UserDefined],[LastModifiedByUid],[LastModifiedDate]
FROM [ListFormattingTemplate]

DROP TABLE [ListFormattingTemplate]

exec  sp_rename 'migtemp_ListFormattingTemplate', 'ListFormattingTemplate'

exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[ListFormLayout]') AND type in (N'U'))
ALTER TABLE [ListFormLayout] ADD [Abbreviation] varchar(3) NULL 
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListKdbConfiguration]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListKdbConfiguration](
	[KdbConfigurationUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Flag indicating whether record is user defined and editable or not' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ListKdbConfiguration', @level2type=N'COLUMN',@level2name=N'UserDefined'

ALTER TABLE [ListKdbConfiguration] ADD  CONSTRAINT [DF_Table_1_KDBSettingsUid]  DEFAULT (newid()) FOR [KdbConfigurationUid]
ALTER TABLE [ListKdbConfiguration] ADD  CONSTRAINT [DF_ListKdbConfiguration_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [ListKdbConfiguration] ADD  CONSTRAINT [DF_ListKdbConfiguration_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [ListKdbConfiguration] ADD  CONSTRAINT [DF_ListKdbConfiguration_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ListMedicalDeviceStatus]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ListMedicalDeviceStatus](
	[MedicalDeviceStatusUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[Name] [varchar](50) NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[UserDefined] [tinyint] NOT NULL
) ON [PRIMARY]


ALTER TABLE [ListMedicalDeviceStatus] ADD  CONSTRAINT [DF_ListPatientMedicalDeviceStatus_PatientMedicalDeviceStatusUid]  DEFAULT (newid()) FOR [MedicalDeviceStatusUid]
ALTER TABLE [ListMedicalDeviceStatus] ADD  CONSTRAINT [DF_ListPatientMedicalDeviceStatus_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [ListMedicalDeviceStatus] ADD  CONSTRAINT [DF_ListPatientMedicalDeviceStatus_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
ALTER TABLE [ListMedicalDeviceStatus] ADD  CONSTRAINT [DF_ListPatientMedicalDeviceStatus_UserDefined]  DEFAULT ((1)) FOR [UserDefined]

END
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'ListNameFormat' AND COLUMN_NAME = 'UserDefined')
ALTER TABLE [ListNameFormat]  ALTER COLUMN [UserDefined] tinyint NULL 
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListObservationDefaultSetting]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListObservationDefaultSetting](
	[ObservationDefaultSettingUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](50) NULL,
	[Name] [varchar](50) NOT NULL,
	[DisplayMetricValues] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[MaxRows] [int] NOT NULL,
	[ReviewUnitOption] [int] NOT NULL,
	[WithPercent] [bit] NOT NULL,
	[UseWHO] [bit] NULL,
	[IsMetric] [bit] NOT NULL,
	[ReviewAsFlow] [bit] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[TimespanUid] [uniqueidentifier] NULL,
	[ObservationCustomUserUid] [uniqueidentifier] NULL,
	[ObservationGroupUid] [uniqueidentifier] NULL,
	[XML_Setting] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[UserDefined] [tinyint] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListObservationDefaultSetting'

ALTER TABLE [migtemp_ListObservationDefaultSetting] ADD  CONSTRAINT [DF_ListObservationDefaultSetting_DisplayMetricValues]  DEFAULT ((0)) FOR [DisplayMetricValues]
ALTER TABLE [migtemp_ListObservationDefaultSetting] ADD  CONSTRAINT [DF_ListObservationDefaultSetting_MaxRows]  DEFAULT ((100)) FOR [MaxRows]
ALTER TABLE [migtemp_ListObservationDefaultSetting] ADD  CONSTRAINT [DF_ListObservationDefaultSetting_ReviewUnitOption]  DEFAULT ((0)) FOR [ReviewUnitOption]
ALTER TABLE [migtemp_ListObservationDefaultSetting] ADD  CONSTRAINT [DF_ListObservationDefaultSetting_WithPercent]  DEFAULT ((0)) FOR [WithPercent]
ALTER TABLE [migtemp_ListObservationDefaultSetting] ADD  CONSTRAINT [DF_ListObservationDefaultSetting_WHOPercent]  DEFAULT ((0)) FOR [UseWHO]
ALTER TABLE [migtemp_ListObservationDefaultSetting] ADD  CONSTRAINT [DF_ListObservationDefaultSetting_IsMetric]  DEFAULT ((0)) FOR [IsMetric]
ALTER TABLE [migtemp_ListObservationDefaultSetting] ADD  CONSTRAINT [DF_ListObservationDefaultSetting_ReviewAsFlow]  DEFAULT ((0)) FOR [ReviewAsFlow]
ALTER TABLE [migtemp_ListObservationDefaultSetting] ADD  CONSTRAINT [DF_ListObservationDefaultSetting_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [migtemp_ListObservationDefaultSetting] ADD  CONSTRAINT [DF_ListObservationDefaultSetting_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
ALTER TABLE [migtemp_ListObservationDefaultSetting] ADD  CONSTRAINT [DF_ListObservationDefaultSetting_UserDefined]  DEFAULT ((1)) FOR [UserDefined]

END
Truncate Table migtemp_ListObservationDefaultSetting
INSERT [migtemp_ListObservationDefaultSetting]([ObservationDefaultSettingUid],[ExternalID],[Name],[DisplayMetricValues],[Notes],[MaxRows],[ReviewUnitOption],[WithPercent],[IsMetric],[ReviewAsFlow],[Inactive],[TimespanUid],[ObservationCustomUserUid],[ObservationGroupUid],[XML_Setting],[LastModifiedByUid],[LastModifiedDate],[UserDefined])
SELECT [ObservationDefaultSettingUid],[ExternalID],[Name],[DisplayMetricValues],[Notes],[MaxRows],[ReviewUnitOption],[WithPercent],[IsMetric],[ReviewAsFlow],[Inactive],[TimespanUid],[ObservationCustomUserUid],[ObservationGroupUid],[XML_Setting],[LastModifiedByUid],[LastModifiedDate],[UserDefined]
FROM [ListObservationDefaultSetting]

DROP TABLE [ListObservationDefaultSetting]

exec  sp_rename 'migtemp_ListObservationDefaultSetting', 'ListObservationDefaultSetting'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListProcedure]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListProcedure](
	[ProcedureUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[Code] [varchar](30) NOT NULL,
	[MasterProcedureUid] [uniqueidentifier] NULL,
	[ProcedureCodeTypeUid] [uniqueidentifier] NULL,
	[ProcedureServiceTypeUid] [uniqueidentifier] NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL,
	[ProcedureGroupUid] [uniqueidentifier] NULL,
	[ShortDescription] [varchar](75) NOT NULL,
	[LongDescription] [varchar](1024) NOT NULL,
	[Notes] [varchar](max) NULL,
	[IsEM] [bit] NOT NULL,
	[DefaultDontClaim] [bit] NOT NULL,
	[EffectiveDate] [date] NULL,
	[ExpirationDate] [date] NULL,
	[Unit] [int] NULL,
	[ProcedureModifier1Uid] [uniqueidentifier] NULL,
	[ProcedureModifier2Uid] [uniqueidentifier] NULL,
	[ProcedureModifier3Uid] [uniqueidentifier] NULL,
	[ProcedureModifier4Uid] [uniqueidentifier] NULL,
	[FDB_MEDID] [int] NULL,
	[NDC] [varchar](50) NULL,
	[NDCUnitMeasureUid] [uniqueidentifier] NULL,
	[GenerateObservationOrder] [bit] NOT NULL,
	[RevenueCode] [varchar](10) NULL,
	[Cost] [money] NULL,
	[NDCQuantity] [varchar](15) NULL,
	[UsePracticeTaxableOption] [bit] NOT NULL,
	[TaxableOption] [smallint] NOT NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[LOINCUid] [uniqueidentifier] NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[IncludeInPatientProcedure] [bit] NOT NULL,
	[ShortDescriptionChangedFromMaster] [bit] NOT NULL,
	[HistoryGroupUid] [uniqueidentifier] NULL,
	[SnomedConceptID2] [varchar](50) NULL,
	[DescriptionUid2] [uniqueidentifier] NULL,
	[ImageResultsDirectlyAccessible] [bit] NOT NULL,
	[PurchasedServiceCharge] [money] NULL,
	[MedicalServicesProviderUid] [uniqueidentifier] NULL,
	[RequireDpn] [bit] NOT NULL,
	[SortToBottom] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'ShowInLabResults' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListProcedure', @level2type=N'COLUMN',@level2name=N'GenerateObservationOrder'
EXEC sys.sp_addextendedproperty @name=N'iforeignkey', @value=N'RelProcedureSetProcedure;RelProcedureCategory;RelProcedureLaboratoryOrder;RelProcedurePanelProcedure;RelProcedureTypeofVaccine;VisitProcedure' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListProcedure'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListProcedure'
EXEC sys.sp_addextendedproperty @name=N'Replication.XferDirection', @value=N'Download' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListProcedure'

ALTER TABLE [migtemp_ListProcedure] ADD  CONSTRAINT [DF_ListProcedure_ProcedureUid]  DEFAULT (newid()) FOR [ProcedureUid]
ALTER TABLE [migtemp_ListProcedure] ADD  CONSTRAINT [DF_ListProcedure_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [migtemp_ListProcedure] ADD  CONSTRAINT [DF_ListProcedure_IsEM]  DEFAULT ((0)) FOR [IsEM]
ALTER TABLE [migtemp_ListProcedure] ADD  CONSTRAINT [DF_ListProcedure_DefaultDontClaim]  DEFAULT ((0)) FOR [DefaultDontClaim]
ALTER TABLE [migtemp_ListProcedure] ADD  CONSTRAINT [DF_ListProcedure_Unit]  DEFAULT ((1)) FOR [Unit]
ALTER TABLE [migtemp_ListProcedure] ADD  CONSTRAINT [DF_ListProcedure_GenerateObservationOrder]  DEFAULT ((0)) FOR [GenerateObservationOrder]
ALTER TABLE [migtemp_ListProcedure] ADD  CONSTRAINT [DF_ListProcedure_UsePracticeTaxableOption]  DEFAULT ((1)) FOR [UsePracticeTaxableOption]
ALTER TABLE [migtemp_ListProcedure] ADD  CONSTRAINT [DF_ListProcedure_TaxableOption]  DEFAULT ((0)) FOR [TaxableOption]
ALTER TABLE [migtemp_ListProcedure] ADD  CONSTRAINT [DF_ListProcedure_IncludeInPatientProcedure]  DEFAULT ((1)) FOR [IncludeInPatientProcedure]
ALTER TABLE [migtemp_ListProcedure] ADD  CONSTRAINT [DF_ListProcedure_ShortDescriptionChangedFromMaster]  DEFAULT ((0)) FOR [ShortDescriptionChangedFromMaster]
ALTER TABLE [migtemp_ListProcedure] ADD  CONSTRAINT [DF_ListProcedure_ImageResultsDirectlyAccessible]  DEFAULT ((0)) FOR [ImageResultsDirectlyAccessible]
ALTER TABLE [migtemp_ListProcedure] ADD  CONSTRAINT [DF_ListProcedure_RequireDpn]  DEFAULT ((0)) FOR [RequireDpn]
ALTER TABLE [migtemp_ListProcedure] ADD  CONSTRAINT [DF_ListProcedure_SortAtBottom]  DEFAULT ((0)) FOR [SortToBottom]
ALTER TABLE [migtemp_ListProcedure] ADD  CONSTRAINT [DF_ListProcedure_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [migtemp_ListProcedure] ADD  CONSTRAINT [DF_ListProcedure_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_ListProcedure
INSERT [migtemp_ListProcedure]([ProcedureUid],[ExternalID],[Inactive],[Code],[MasterProcedureUid],[ProcedureCodeTypeUid],[ProcedureServiceTypeUid],[ServiceSiteUid],[ProcedureGroupUid],[ShortDescription],[LongDescription],[Notes],[IsEM],[DefaultDontClaim],[EffectiveDate],[ExpirationDate],[Unit],[ProcedureModifier1Uid],[ProcedureModifier2Uid],[ProcedureModifier3Uid],[ProcedureModifier4Uid],[FDB_MEDID],[NDC],[NDCUnitMeasureUid],[GenerateObservationOrder],[RevenueCode],[Cost],[NDCQuantity],[UsePracticeTaxableOption],[TaxableOption],[SnomedConceptID],[LOINCUid],[DescriptionUid],[IncludeInPatientProcedure],[ShortDescriptionChangedFromMaster],[HistoryGroupUid],[SnomedConceptID2],[DescriptionUid2],[ImageResultsDirectlyAccessible],[PurchasedServiceCharge],[MedicalServicesProviderUid],[RequireDpn],[SortToBottom],[UserDefined],[LastModifiedByUid],[LastModifiedDate])
SELECT [ProcedureUid],[ExternalID],[Inactive],[Code],[MasterProcedureUid],[ProcedureCodeTypeUid],[ProcedureServiceTypeUid],[ServiceSiteUid],[ProcedureGroupUid],[ShortDescription],[LongDescription],[Notes],[IsEM],[DefaultDontClaim],[EffectiveDate],[ExpirationDate],[Unit],[ProcedureModifier1Uid],[ProcedureModifier2Uid],[ProcedureModifier3Uid],[ProcedureModifier4Uid],[FDB_MEDID],[NDC],[NDCUnitMeasureUid],[GenerateObservationOrder],[RevenueCode],[Cost],[NDCQuantity],[UsePracticeTaxableOption],[TaxableOption],[SnomedConceptID],[LOINCUid],[DescriptionUid],[IncludeInPatientProcedure],[ShortDescriptionChangedFromMaster],[HistoryGroupUid],[SnomedConceptID2],[DescriptionUid2],[ImageResultsDirectlyAccessible],[PurchasedServiceCharge],[MedicalServicesProviderUid],[RequireDpn],[SortToBottom],[UserDefined],[LastModifiedByUid],[LastModifiedDate]
FROM [ListProcedure]

DROP TABLE [ListProcedure]

exec  sp_rename 'migtemp_ListProcedure', 'ListProcedure'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListProviderCareType]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListProviderCareType](
	[ProviderCareTypeUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](50) NOT NULL,
	[CopayColumnTypeID] [smallint] NOT NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL,
	[ExcludeFromReferrals] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[UserDefined] [tinyint] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Tells which column in PersonInsurancePlan to use for copay: 0 CopayPrimary; 1 CopaySpecialist; 2 CopayOther' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListProviderCareType', @level2type=N'COLUMN',@level2name=N'CopayColumnTypeID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'A type to be used for setting provider default and overridable in appointment, visit, and superbill. Used to determine which copay to use.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListProviderCareType'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ListProviderCareType'

ALTER TABLE [migtemp_ListProviderCareType] ADD  CONSTRAINT [DF_ListProviderCareType_ProviderCareTypeUid]  DEFAULT (newid()) FOR [ProviderCareTypeUid]
ALTER TABLE [migtemp_ListProviderCareType] ADD  CONSTRAINT [DF_ListProviderCareType_CopayColumnType]  DEFAULT ((0)) FOR [CopayColumnTypeID]
ALTER TABLE [migtemp_ListProviderCareType] ADD  CONSTRAINT [DF_ListProviderCareType_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [migtemp_ListProviderCareType] ADD  CONSTRAINT [DF_ListProviderCareType_ExcludeFromReferrals]  DEFAULT ((0)) FOR [ExcludeFromReferrals]
ALTER TABLE [migtemp_ListProviderCareType] ADD  CONSTRAINT [DF_ListProviderCareType_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
ALTER TABLE [migtemp_ListProviderCareType] ADD  CONSTRAINT [DF_ListProviderCareType_UserDefined]  DEFAULT ((1)) FOR [UserDefined]

END
Truncate Table migtemp_ListProviderCareType
INSERT [migtemp_ListProviderCareType]([ProviderCareTypeUid],[ExternalID],[Name],[CopayColumnTypeID],[Notes],[Inactive],[LastModifiedByUid],[LastModifiedDate],[UserDefined])
SELECT [ProviderCareTypeUid],[ExternalID],[Name],[CopayColumnTypeID],[Notes],[Inactive],[LastModifiedByUid],[LastModifiedDate],[UserDefined]
FROM [ListProviderCareType]

DROP TABLE [ListProviderCareType]

exec  sp_rename 'migtemp_ListProviderCareType', 'ListProviderCareType'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ListUserSetting]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ListUserSetting](
	[UserSettingUid] [uniqueidentifier] NOT NULL,
	[ExternalID] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[Name] [varchar](100) NOT NULL,
	[ClinicCenterUid] [uniqueidentifier] NULL,
	[ClinicalNoteTypes] [xml](CONTENT [dbo].[UidList]) NULL,
	[FormattingTemplateUid] [uniqueidentifier] NULL,
	[NoteSingleColumn] [nchar](10) NULL,
	[MinWidth] [int] NOT NULL,
	[FontSize] [float] NOT NULL,
	[UseNewOPSRPN] [bit] NOT NULL,
	[AttachmentAddIns] [xml](CONTENT [dbo].[UidList]) NULL,
	[PatientDemographicAddIns] [xml](CONTENT [dbo].[UidList]) NULL,
	[NoteAddIns] [xml](CONTENT [dbo].[UidList]) NULL,
	[AppointmentNoteAddIn] [xml] NULL,
	[VitalsAddIns] [xml](CONTENT [dbo].[UidList]) NULL,
	[PatientToolbarAddIns] [xml](CONTENT [dbo].[UidList]) NULL,
	[DesktopAddIns] [xml](CONTENT [dbo].[UidList]) NULL,
	[AppointmentAddIns] [xml](CONTENT [dbo].[UidList]) NULL,
	[SuperbillChargeProcessorAddInUid] [uniqueidentifier] NULL,
	[ServiceProcedureAddInUid] [uniqueidentifier] NULL,
	[VisitSaveAddInUid] [uniqueidentifier] NULL,
	[PatientDemographicsPrint] [xml](CONTENT [dbo].[UidList]) NULL,
	[NotePrint] [xml](CONTENT [dbo].[UidList]) NULL,
	[OPSPrint] [xml](CONTENT [dbo].[UidList]) NULL,
	[RPNPrint] [xml](CONTENT [dbo].[UidList]) NULL,
	[PatientPrint] [xml](CONTENT [dbo].[UidList]) NULL,
	[JobEngineStatus] [bit] NOT NULL,
	[MasterServerStatus] [bit] NOT NULL,
	[CacheServerStatus] [bit] NOT NULL,
	[AutoCapitalization] [bit] NOT NULL,
	[AutoComplete] [bit] NOT NULL,
	[TryDelete] [bit] NOT NULL,
	[VoiceRecording] [bit] NOT NULL,
	[InkInput] [smallint] NOT NULL,
	[DockingStyle] [smallint] NOT NULL,
	[StartupSound] [varchar](255) NULL,
	[SelectionColor] [xml](CONTENT [dbo].[SelectionColor]) NULL,
	[RequiredColor] [xml](CONTENT [dbo].[SelectionColor]) NULL,
	[PatientInputColor] [xml](CONTENT [dbo].[SelectionColor]) NULL,
	[BorderColor] [xml](CONTENT [dbo].[SelectionColor]) NULL,
	[AllowCPO] [bit] NOT NULL,
	[AutoCheckCPOGeneration] [bit] NOT NULL,
	[WarnOnCancelNote] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Notes] [varchar](max) NULL,
	[MaximizeForms] [bit] NOT NULL,
	[BackgroundSave] [bit] NOT NULL,
	[UseNewOPS] [bit] NOT NULL,
	[DisplayPrinterDialog] [bit] NOT NULL,
	[ProcessHMRulesOnNoteSave] [bit] NOT NULL,
	[CheckoutPlanTemplateUid] [uniqueidentifier] NULL,
	[RPNPrintButtonUid] [uniqueidentifier] NULL,
	[OPSPrintButtonUid] [uniqueidentifier] NULL,
	[RxConsentFormattingTemplateUid] [uniqueidentifier] NULL,
	[RxConsentAttachmentTypeUid] [uniqueidentifier] NULL,
	[RxConsentMedication] [xml](CONTENT [dbo].[UidList]) NULL,
	[StandardHistoryDisplay] [bit] NOT NULL,
	[OtherSettings] [xml] NULL,
	[ShowRVUSearchingCPTUid] [uniqueidentifier] NULL,
	[IncludeEMInMFU] [bit] NOT NULL,
	[MultiWindow] [bit] NOT NULL,
	[CheckoutEducationForm] [bit] NOT NULL,
	[CheckoutVisitReceipt] [bit] NOT NULL,
	[CheckoutSuperbill] [bit] NOT NULL,
	[CheckoutUncheckAll] [bit] NOT NULL,
	[EditorFont] [xml] NULL,
	[FncCompleteNoteValidatorAddIns] [xml](CONTENT [dbo].[UidList]) NULL,
	[KdbConfigurationUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]


ALTER TABLE [migtemp_ListUserSetting] ADD  CONSTRAINT [DF_ListUserSetting_UserSettingUid]  DEFAULT (newid()) FOR [UserSettingUid]
ALTER TABLE [migtemp_ListUserSetting] ADD  CONSTRAINT [DF_ListUserSetting_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [migtemp_ListUserSetting] ADD  CONSTRAINT [DF_ListUserSetting_MinWidth_1]  DEFAULT ((100)) FOR [MinWidth]
ALTER TABLE [migtemp_ListUserSetting] ADD  CONSTRAINT [DF_ListUserSetting_FontSize_1]  DEFAULT ((10.0)) FOR [FontSize]
ALTER TABLE [migtemp_ListUserSetting] ADD  CONSTRAINT [DF_ListUserSetting_UseNewOPSRPN_1]  DEFAULT ((1)) FOR [UseNewOPSRPN]
ALTER TABLE [migtemp_ListUserSetting] ADD  CONSTRAINT [DF_ListUserSetting_JobEngineStatus_1]  DEFAULT ((0)) FOR [JobEngineStatus]
ALTER TABLE [migtemp_ListUserSetting] ADD  CONSTRAINT [DF_ListUserSetting_MasterServerStatus]  DEFAULT ((0)) FOR [MasterServerStatus]
ALTER TABLE [migtemp_ListUserSetting] ADD  CONSTRAINT [DF_ListUserSetting_CacheServerStatus_1]  DEFAULT ((0)) FOR [CacheServerStatus]
ALTER TABLE [migtemp_ListUserSetting] ADD  CONSTRAINT [DF_ListUserSetting_AutoCapitalization_1]  DEFAULT ((1)) FOR [AutoCapitalization]
ALTER TABLE [migtemp_ListUserSetting] ADD  CONSTRAINT [DF_ListUserSetting_AutoComplete_1]  DEFAULT ((1)) FOR [AutoComplete]
ALTER TABLE [migtemp_ListUserSetting] ADD  CONSTRAINT [DF_ListUserSetting_TryDelete_1]  DEFAULT ((1)) FOR [TryDelete]
ALTER TABLE [migtemp_ListUserSetting] ADD  CONSTRAINT [DF_ListUserSetting_VoiceRecording_1]  DEFAULT ((1)) FOR [VoiceRecording]
ALTER TABLE [migtemp_ListUserSetting] ADD  CONSTRAINT [DF_ListUserSetting_InkInput_1]  DEFAULT ((0)) FOR [InkInput]
ALTER TABLE [migtemp_ListUserSetting] ADD  CONSTRAINT [DF_ListUserSetting_DockingStyle_1]  DEFAULT ((0)) FOR [DockingStyle]
ALTER TABLE [migtemp_ListUserSetting] ADD  CONSTRAINT [DF_ListUserSetting_AllowCPO_1]  DEFAULT ((0)) FOR [AllowCPO]
ALTER TABLE [migtemp_ListUserSetting] ADD  CONSTRAINT [DF_ListUserSetting_AutoCheckCPOGeneration]  DEFAULT ((0)) FOR [AutoCheckCPOGeneration]
ALTER TABLE [migtemp_ListUserSetting] ADD  CONSTRAINT [DF_ListUserSetting_WarnOnCancelNote_1]  DEFAULT ((1)) FOR [WarnOnCancelNote]
ALTER TABLE [migtemp_ListUserSetting] ADD  CONSTRAINT [DF_ListUserSetting_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [migtemp_ListUserSetting] ADD  CONSTRAINT [DF_ListUserSetting_MaximizeForms]  DEFAULT ((0)) FOR [MaximizeForms]
ALTER TABLE [migtemp_ListUserSetting] ADD  CONSTRAINT [DF_ListUserSetting_BackgroundSave]  DEFAULT ((1)) FOR [BackgroundSave]
ALTER TABLE [migtemp_ListUserSetting] ADD  CONSTRAINT [DF_ListUserSetting_UseNewOPS]  DEFAULT ((0)) FOR [UseNewOPS]
ALTER TABLE [migtemp_ListUserSetting] ADD  CONSTRAINT [DF_ListUserSetting_DisplayRxPrinterDialog]  DEFAULT ((0)) FOR [DisplayPrinterDialog]
ALTER TABLE [migtemp_ListUserSetting] ADD  CONSTRAINT [DF_ListUserSetting_ProcessHMRulesOnNoteSave_1]  DEFAULT ((1)) FOR [ProcessHMRulesOnNoteSave]
ALTER TABLE [migtemp_ListUserSetting] ADD  CONSTRAINT [DF_ListUserSetting_StandardHistoryDisplay]  DEFAULT ((0)) FOR [StandardHistoryDisplay]
ALTER TABLE [migtemp_ListUserSetting] ADD  CONSTRAINT [DF_ListUserSetting_IncludeEMInMFU_1]  DEFAULT ((0)) FOR [IncludeEMInMFU]
ALTER TABLE [migtemp_ListUserSetting] ADD  CONSTRAINT [DF_ListUserSetting_MultiWindow_1]  DEFAULT ((1)) FOR [MultiWindow]
ALTER TABLE [migtemp_ListUserSetting] ADD  CONSTRAINT [DF_ListUserSetting_CheckoutEducationForm]  DEFAULT ((0)) FOR [CheckoutEducationForm]
ALTER TABLE [migtemp_ListUserSetting] ADD  CONSTRAINT [DF_ListUserSetting_CheckoutVisitReceipt]  DEFAULT ((0)) FOR [CheckoutVisitReceipt]
ALTER TABLE [migtemp_ListUserSetting] ADD  CONSTRAINT [DF_ListUserSetting_CheckoutSuperbill]  DEFAULT ((0)) FOR [CheckoutSuperbill]
ALTER TABLE [migtemp_ListUserSetting] ADD  CONSTRAINT [DF_ListUserSetting_CheckoutUncheckAll]  DEFAULT ((0)) FOR [CheckoutUncheckAll]
ALTER TABLE [migtemp_ListUserSetting] ADD  CONSTRAINT [DF_ListUserSetting_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_ListUserSetting
INSERT [migtemp_ListUserSetting]([UserSettingUid],[ExternalID],[Inactive],[Name],[ClinicCenterUid],[ClinicalNoteTypes],[FormattingTemplateUid],[NoteSingleColumn],[MinWidth],[FontSize],[UseNewOPSRPN],[AttachmentAddIns],[PatientDemographicAddIns],[NoteAddIns],[AppointmentNoteAddIn],[VitalsAddIns],[PatientToolbarAddIns],[DesktopAddIns],[AppointmentAddIns],[SuperbillChargeProcessorAddInUid],[ServiceProcedureAddInUid],[VisitSaveAddInUid],[PatientDemographicsPrint],[NotePrint],[OPSPrint],[RPNPrint],[PatientPrint],[JobEngineStatus],[MasterServerStatus],[CacheServerStatus],[AutoCapitalization],[AutoComplete],[TryDelete],[VoiceRecording],[InkInput],[DockingStyle],[StartupSound],[SelectionColor],[RequiredColor],[PatientInputColor],[BorderColor],[AllowCPO],[AutoCheckCPOGeneration],[WarnOnCancelNote],[UserDefined],[Notes],[MaximizeForms],[BackgroundSave],[UseNewOPS],[DisplayPrinterDialog],[ProcessHMRulesOnNoteSave],[CheckoutPlanTemplateUid],[RPNPrintButtonUid],[OPSPrintButtonUid],[RxConsentFormattingTemplateUid],[RxConsentAttachmentTypeUid],[RxConsentMedication],[StandardHistoryDisplay],[OtherSettings],[ShowRVUSearchingCPTUid],[IncludeEMInMFU],[MultiWindow],[CheckoutEducationForm],[CheckoutVisitReceipt],[CheckoutSuperbill],[CheckoutUncheckAll],[EditorFont],[FncCompleteNoteValidatorAddIns],[LastModifiedByUid],[LastModifiedDate])
SELECT [UserSettingUid],[ExternalID],[Inactive],[Name],[ClinicCenterUid],CONVERT(nvarchar(max), [ClinicalNoteTypes]),[FormattingTemplateUid],[NoteSingleColumn],[MinWidth],[FontSize],[UseNewOPSRPN],CONVERT(nvarchar(max), [AttachmentAddIns]),CONVERT(nvarchar(max), [PatientDemographicAddIns]),CONVERT(nvarchar(max), [NoteAddIns]),CONVERT(nvarchar(max), [AppointmentNoteAddIn]),CONVERT(nvarchar(max), [VitalsAddIns]),CONVERT(nvarchar(max), [PatientToolbarAddIns]),CONVERT(nvarchar(max), [DesktopAddIns]),CONVERT(nvarchar(max), [AppointmentAddIns]),[SuperbillChargeProcessorAddInUid],[ServiceProcedureAddInUid],[VisitSaveAddInUid],CONVERT(nvarchar(max), [PatientDemographicsPrint]),CONVERT(nvarchar(max), [NotePrint]),CONVERT(nvarchar(max), [OPSPrint]),CONVERT(nvarchar(max), [RPNPrint]),CONVERT(nvarchar(max), [PatientPrint]),[JobEngineStatus],[MasterServerStatus],[CacheServerStatus],[AutoCapitalization],[AutoComplete],[TryDelete],[VoiceRecording],[InkInput],[DockingStyle],[StartupSound],CONVERT(nvarchar(max), [SelectionColor]),CONVERT(nvarchar(max), [RequiredColor]),CONVERT(nvarchar(max), [PatientInputColor]),CONVERT(nvarchar(max), [BorderColor]),[AllowCPO],[AutoCheckCPOGeneration],[WarnOnCancelNote],[UserDefined],[Notes],[MaximizeForms],[BackgroundSave],[UseNewOPS],[DisplayPrinterDialog],[ProcessHMRulesOnNoteSave],[CheckoutPlanTemplateUid],[RPNPrintButtonUid],[OPSPrintButtonUid],[RxConsentFormattingTemplateUid],[RxConsentAttachmentTypeUid],CONVERT(nvarchar(max), [RxConsentMedication]),[StandardHistoryDisplay],CONVERT(nvarchar(max), [OtherSettings]),[ShowRVUSearchingCPTUid],[IncludeEMInMFU],[MultiWindow],[CheckoutEducationForm],[CheckoutVisitReceipt],[CheckoutSuperbill],[CheckoutUncheckAll],CONVERT(nvarchar(max), [EditorFont]),CONVERT(nvarchar(max), [FncCompleteNoteValidatorAddIns]),[LastModifiedByUid],[LastModifiedDate]
FROM [ListUserSetting]

DROP TABLE [ListUserSetting]

exec  sp_rename 'migtemp_ListUserSetting', 'ListUserSetting'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_MapItem]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_MapItem](
	[MapItemUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[MapSourceUid] [uniqueidentifier] NULL,
	[FindTableFromItemUid] [uniqueidentifier] NULL,
	[MapItemFromName] [varchar](100) NULL,
	[FindTableToItemUid] [uniqueidentifier] NULL,
	[MapItemToName] [varchar](100) NULL,
	[SubstitutionText] [varchar](200) NULL,
	[DisplayOrder] [smallint] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_MapItem'

ALTER TABLE [migtemp_MapItem] ADD  CONSTRAINT [DF_MapItem_MapItemUid]  DEFAULT (newid()) FOR [MapItemUid]
ALTER TABLE [migtemp_MapItem] ADD  CONSTRAINT [DF_MapItem_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [migtemp_MapItem] ADD  CONSTRAINT [DF_MapItem_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [migtemp_MapItem] ADD  CONSTRAINT [DF_MapItem_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [migtemp_MapItem] ADD  CONSTRAINT [DF_MapItem_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_MapItem
INSERT [migtemp_MapItem]([MapItemUid],[MapSourceUid],[FindTableFromItemUid],[MapItemFromName],[FindTableToItemUid],[MapItemToName],[SubstitutionText],[DisplayOrder],[UserDefined],[Inactive],[LastModifiedDate],[LastModifiedByUid])
SELECT [MapItemUid],[MapSourceUid],[FindTableFromItemUid],[MapItemFromName],[FindTableToItemUid],[MapItemToName],[SubstitutionText],[DisplayOrder],[UserDefined],[Inactive],[LastModifiedDate],[LastModifiedByUid]
FROM [MapItem]

DROP TABLE [MapItem]

exec  sp_rename 'migtemp_MapItem', 'MapItem'

exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'MedicationSIG' AND COLUMN_NAME = 'Name')
ALTER TABLE [MedicationSIG]  ALTER COLUMN [Name] varchar(255) NULL 
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Patient' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.Patient' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ProcessorAQN' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.ProcessorAQN' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'PatientUid'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'PatientUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'OrderProviderUid'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'OrderProviderUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'PerformProviderUid'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'PerformProviderUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'LaboratoryUid'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'LaboratoryUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'LabSourceUid'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'LabSourceUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'ApproveProviderUid'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'ApproveProviderUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'TrackingNum'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'TrackingNum'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'OrderDateTime'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'OrderDateTime'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'PerformDateTime'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'PerformDateTime'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'ReceiveDateTime'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'ReceiveDateTime'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'ResultDateTime'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'ResultDateTime'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'ExtractDateTime'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'ExtractDateTime'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'ResultStatusID'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'ResultStatusID'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverOverrideValueIfValueSet' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'ResultStatusID'))
EXEC sys.sp_dropextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'ResultStatusID'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverOverrideValueIfValueSetColumnReference' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'ResultStatusID'))
EXEC sys.sp_dropextendedproperty @name=N'Replication.NeverOverrideValueIfValueSetColumnReference' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'ResultStatusID'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverOverrideValueIfValueSetOverrideValue' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'ResultStatusID'))
EXEC sys.sp_dropextendedproperty @name=N'Replication.NeverOverrideValueIfValueSetOverrideValue' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'ResultStatusID'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'ResultStatusCode'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'ResultStatusCode'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'AbnormalFlagCode'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'AbnormalFlagCode'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'ApproveDate'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'ApproveDate'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.LimitContentSizeSelectByValueOf' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'ApproveDate'))
EXEC sys.sp_dropextendedproperty @name=N'Replication.LimitContentSizeSelectByValueOf' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'ApproveDate'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'DueDate'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'DueDate'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'Notes'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'Notes'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'ElectronicResult'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'ElectronicResult'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'ResultingVisitUid'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'ResultingVisitUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'oldname' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'CreatedDateTime'))
EXEC sys.sp_dropextendedproperty @name=N'oldname' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'CreatedDateTime'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'LastModifiedByUid'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Observation orders' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Patient' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'FK_ObservationOrder_Patient' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.ProcessorAQN' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.ProcessorAQN', @value=N'iMedica.Prm.BusinessObject.ObservationOrderProcessor, iMedica.Prm.BusinessObject' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'PatientUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Patient Id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'PatientUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'OrderProviderUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'order doctor id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'OrderProviderUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'PerformProviderUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'perform doctor id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'PerformProviderUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'LaboratoryUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Laboratory id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'LaboratoryUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'LabSourceUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'source for DCH only, entered at the time ordering the lab' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'LabSourceUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'ApproveProviderUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'approve provider' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'ApproveProviderUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverOverrideValueIfValueSet' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'ApproveProviderUid'))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'ApproveProviderUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'TrackingNum'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'tracking number (machine id + yymmddhhmmssmm)' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'TrackingNum'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'OrderDateTime'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Lab Ordered Date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'OrderDateTime'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'PerformDateTime'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Lab Test Performed date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'PerformDateTime'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'ReceiveDateTime'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'result received date (after lab test done)' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'ReceiveDateTime'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'ResultDateTime'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Actual resulted date after the test finished' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'ResultDateTime'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'ExtractDateTime'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date of test sample extracted from patient ' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'ExtractDateTime'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'ResultStatusID'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1 = Ordered; 2 = Pending; 3 = Pending\Collected; 4= Pending\Received; 5 = Pending\Performed; 6 = Pending\Resulted; 7 = Resulted; 8 = Resulted\Reviewed; 9 = Resulted\Approved' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'ResultStatusID'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverOverrideValueIfValueSet' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'ResultStatusID'))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'ResultStatusID'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverOverrideValueIfValueSetColumnReference' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'ResultStatusID'))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSetColumnReference', @value=N'<reference foreignTable="ListMisc" searchColumn="ListType" searchValue="ResultStatusID" valueColumn="Val" sortColumn="DisplayOrder" sortBy="ASC" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'ResultStatusID'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverOverrideValueIfValueSetOverrideValue' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'ResultStatusID'))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSetOverrideValue', @value=N'<OverrideValues><OverrideValue oldValue="9" newValue="7" /><OverrideValue oldValue="2" oldValueOperator="&gt;" newValue="-1" /></OverrideValues>' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'ResultStatusID'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'ResultStatusCode'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'"F": final' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'ResultStatusCode'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'AbnormalFlagCode'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'"A": abnormal; "L": low abnormal; "H": high abnormal; blank: normal' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'AbnormalFlagCode'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'ApproveDate'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'approve date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'ApproveDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.LimitContentSizeSelectByValueOf' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'ApproveDate'))
EXEC sys.sp_addextendedproperty @name=N'Replication.LimitContentSizeSelectByValueOf', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'ApproveDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverOverrideValueIfValueSet' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'ApproveDate'))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'ApproveDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'DueDate'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'due date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'DueDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'Notes'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'comment' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'Notes'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'ElectronicResult'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0 = false; 1 = true (when true, this result came in from Interface and cannot be modified by user)' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'ElectronicResult'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'ResultingVisitUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Results In Visit Id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'ResultingVisitUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'oldname' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'CreatedDateTime'))
EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'CreatedDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'CreatedDateTime'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationOrder', N'COLUMN',N'LastModifiedByUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify person id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationOrder', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.IgnoreConflictColumns' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.IgnoreConflictColumns' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Patient' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.Patient' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', N'COLUMN',N'ObservationOrderUid'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue', @level2type=N'COLUMN',@level2name=N'ObservationOrderUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', N'COLUMN',N'LaboratoryUid'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue', @level2type=N'COLUMN',@level2name=N'LaboratoryUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', N'COLUMN',N'ObservationItemUid'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue', @level2type=N'COLUMN',@level2name=N'ObservationItemUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', N'COLUMN',N'DisplayOrder'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue', @level2type=N'COLUMN',@level2name=N'DisplayOrder'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', N'COLUMN',N'StringValue'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue', @level2type=N'COLUMN',@level2name=N'StringValue'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', N'COLUMN',N'ReferenceRange'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue', @level2type=N'COLUMN',@level2name=N'ReferenceRange'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', N'COLUMN',N'ResultStatusCode'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue', @level2type=N'COLUMN',@level2name=N'ResultStatusCode'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', N'COLUMN',N'AbnormalFlagCode'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue', @level2type=N'COLUMN',@level2name=N'AbnormalFlagCode'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', N'COLUMN',N'ResultStatusID'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue', @level2type=N'COLUMN',@level2name=N'ResultStatusID'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverOverrideValueIfValueSet' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', N'COLUMN',N'ResultStatusID'))
EXEC sys.sp_dropextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue', @level2type=N'COLUMN',@level2name=N'ResultStatusID'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverOverrideValueIfValueSetColumnReference' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', N'COLUMN',N'ResultStatusID'))
EXEC sys.sp_dropextendedproperty @name=N'Replication.NeverOverrideValueIfValueSetColumnReference' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue', @level2type=N'COLUMN',@level2name=N'ResultStatusID'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverOverrideValueIfValueSetOverrideValue' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', N'COLUMN',N'ResultStatusID'))
EXEC sys.sp_dropextendedproperty @name=N'Replication.NeverOverrideValueIfValueSetOverrideValue' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue', @level2type=N'COLUMN',@level2name=N'ResultStatusID'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', N'COLUMN',N'LastModifiedByUid'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', N'COLUMN',N'LastModifiedDate'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'lab result detail' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.IgnoreConflictColumns' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.IgnoreConflictColumns', @value=N'ApproveProviderUid,ApproveDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Patient' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'FK_ObservationValue_ObservationOrder' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', N'COLUMN',N'ObservationOrderUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'points to ObservationOrder table' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue', @level2type=N'COLUMN',@level2name=N'ObservationOrderUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', N'COLUMN',N'LaboratoryUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'lab id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue', @level2type=N'COLUMN',@level2name=N'LaboratoryUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', N'COLUMN',N'ObservationItemUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Lab template item id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue', @level2type=N'COLUMN',@level2name=N'ObservationItemUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', N'COLUMN',N'DisplayOrder'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Sequence; reserved for the order change or item  is not defined in the ObservationItem table' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue', @level2type=N'COLUMN',@level2name=N'DisplayOrder'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', N'COLUMN',N'StringValue'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'result value' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue', @level2type=N'COLUMN',@level2name=N'StringValue'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', N'COLUMN',N'ReferenceRange'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Reference range: 3.8-19.8' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue', @level2type=N'COLUMN',@level2name=N'ReferenceRange'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', N'COLUMN',N'ResultStatusCode'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Result status code: "F": final' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue', @level2type=N'COLUMN',@level2name=N'ResultStatusCode'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', N'COLUMN',N'AbnormalFlagCode'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'"L": low; "H": high; blank: normal' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue', @level2type=N'COLUMN',@level2name=N'AbnormalFlagCode'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', N'COLUMN',N'ResultStatusID'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1 = Ordered; 2 = Pending; 3 = Pending\Collected; 4= Pending\Received; 5 = Pending\Performed; 6 = Pending\Resulted; 7 = Resulted; 8 = Resulted\Reviewed; 9 = Resulted\Approved' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue', @level2type=N'COLUMN',@level2name=N'ResultStatusID'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverOverrideValueIfValueSet' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', N'COLUMN',N'ResultStatusID'))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue', @level2type=N'COLUMN',@level2name=N'ResultStatusID'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverOverrideValueIfValueSetColumnReference' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', N'COLUMN',N'ResultStatusID'))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSetColumnReference', @value=N'<reference foreignTable="ListMisc" searchColumn="ListType" searchValue="ResultStatusID" valueColumn="Val" sortColumn="DisplayOrder" sortBy="ASC" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue', @level2type=N'COLUMN',@level2name=N'ResultStatusID'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverOverrideValueIfValueSetOverrideValue' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', N'COLUMN',N'ResultStatusID'))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSetOverrideValue', @value=N'<OverrideValues><OverrideValue oldValue="9" newValue="7" /><OverrideValue oldValue="2" oldValueOperator="&gt;" newValue="-1" /></OverrideValues>' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue', @level2type=N'COLUMN',@level2name=N'ResultStatusID'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverOverrideValueIfValueSet' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', N'COLUMN',N'ApproveProviderUid'))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue', @level2type=N'COLUMN',@level2name=N'ApproveProviderUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverOverrideValueIfValueSet' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', N'COLUMN',N'ApproveDate'))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue', @level2type=N'COLUMN',@level2name=N'ApproveDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', N'COLUMN',N'LastModifiedByUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify person id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'ObservationValue', N'COLUMN',N'LastModifiedDate'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'getutcdate() for LastModifiedDate' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'ObservationValue', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_Patient]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_Patient](
	[PersonUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[Inactive] [bit] NOT NULL,
	[MedicalRecordNumber] [varchar](25) NULL,
	[PatientClassUid] [uniqueidentifier] NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[ServiceSiteUid] [uniqueidentifier] NULL,
	[DepartmentUid] [uniqueidentifier] NULL,
	[ReleaseInformation] [bit] NOT NULL,
	[ReleaseDate] [datetime] NULL,
	[SignatureOnFile] [bit] NOT NULL,
	[SignatureSourceUid] [uniqueidentifier] NULL,
	[AssignmentOfBenefitsUid] [uniqueidentifier] NULL,
	[PrivacyPolicyAcceptanceUid] [uniqueidentifier] NULL,
	[StudentStatusUid] [uniqueidentifier] NULL,
	[SchoolName] [varchar](50) NULL,
	[ResidenceTypeUid] [uniqueidentifier] NULL,
	[ExternalID] [varchar](25) NULL,
	[eRXHPatientConsent] [bit] NOT NULL,
	[ScannedChartDate] [datetime] NULL,
	[UserDefinedXml] [xml] NULL,
	[ReferralSrcUid] [uniqueidentifier] NULL,
	[SupervisingProviderUid] [uniqueidentifier] NULL,
	[ImmzReminderRecallUid] [uniqueidentifier] NULL,
	[ActXStatus] [bit] NOT NULL,
	[ActXStatusCheckedDate] [datetime] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Medical record number.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Patient', @level2type=N'COLUMN',@level2name=N'MedicalRecordNumber'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Default clinical service site.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Patient', @level2type=N'COLUMN',@level2name=N'ServiceSiteUid'
EXEC sys.sp_addextendedproperty @name=N'Replication.EnsureExternalId', @value=1 , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Patient', @level2type=N'COLUMN',@level2name=N'ExternalID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Patients.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Patient'
EXEC sys.sp_addextendedproperty @name=N'Replication.UpcastToParentTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Patient'

ALTER TABLE [migtemp_Patient] ADD  CONSTRAINT [DF_Patient_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [migtemp_Patient] ADD  CONSTRAINT [DF_Patient_ReleaseInformation]  DEFAULT ((0)) FOR [ReleaseInformation]
ALTER TABLE [migtemp_Patient] ADD  CONSTRAINT [DF_Patient_SignatureOnFile]  DEFAULT ((0)) FOR [SignatureOnFile]
ALTER TABLE [migtemp_Patient] ADD  CONSTRAINT [DF_Patient_eRXHPatientConsent]  DEFAULT ((0)) FOR [eRXHPatientConsent]
ALTER TABLE [migtemp_Patient] ADD  CONSTRAINT [DF_Patient_ActXStatus]  DEFAULT ((0)) FOR [ActXStatus]
ALTER TABLE [migtemp_Patient] ADD  CONSTRAINT [DF_Patient_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_Patient
INSERT [migtemp_Patient]([PersonUid],[Inactive],[MedicalRecordNumber],[PatientClassUid],[ProviderUid],[ServiceSiteUid],[DepartmentUid],[ReleaseInformation],[ReleaseDate],[SignatureOnFile],[SignatureSourceUid],[AssignmentOfBenefitsUid],[PrivacyPolicyAcceptanceUid],[StudentStatusUid],[SchoolName],[ResidenceTypeUid],[ExternalID],[eRXHPatientConsent],[ScannedChartDate],[UserDefinedXml],[ReferralSrcUid],[SupervisingProviderUid],[ImmzReminderRecallUid],[LastModifiedDate],[LastModifiedByUid])
SELECT [PersonUid],[Inactive],[MedicalRecordNumber],[PatientClassUid],[ProviderUid],[ServiceSiteUid],[DepartmentUid],[ReleaseInformation],[ReleaseDate],[SignatureOnFile],[SignatureSourceUid],[AssignmentOfBenefitsUid],[PrivacyPolicyAcceptanceUid],[StudentStatusUid],[SchoolName],[ResidenceTypeUid],[ExternalID],[eRXHPatientConsent],[ScannedChartDate],CONVERT(nvarchar(max), [UserDefinedXml]),[ReferralSrcUid],[SupervisingProviderUid],[ImmzReminderRecallUid],[LastModifiedDate],[LastModifiedByUid]
FROM [Patient]

DROP TABLE [Patient]

exec  sp_rename 'migtemp_Patient', 'Patient'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PatientCP_CarePlan]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[PatientCP_CarePlan](
	[PatientCP_CarePlanUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[CP_CarePlanUid] [uniqueidentifier] NULL,
	[Name] [varchar](100) NULL,
	[Notes] [varchar](max) NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[IsDelete] [bit] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[CreatedDate] [date] NOT NULL,
	[CreatedDateTime] [datetime] NOT NULL,
	[InactiveDate] [date] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Marks a row "Deleted" without removing the row. The UI will show this row as struck-out.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_CarePlan', @level2type=N'COLUMN',@level2name=N'IsDelete'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Date the CarePlan was initially created.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_CarePlan', @level2type=N'COLUMN',@level2name=N'CreatedDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'the (UTC) date and time the care plan was created' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_CarePlan', @level2type=N'COLUMN',@level2name=N'CreatedDateTime'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The last date the row was updated or the date added.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_CarePlan', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'

ALTER TABLE [PatientCP_CarePlan] ADD  CONSTRAINT [DF_PatientCP_CarePlan_PatientCP_CarePlanUid]  DEFAULT (newid()) FOR [PatientCP_CarePlanUid]
ALTER TABLE [PatientCP_CarePlan] ADD  CONSTRAINT [DF_PatientCP_CarePlan_IsDelete]  DEFAULT ((0)) FOR [IsDelete]
ALTER TABLE [PatientCP_CarePlan] ADD  CONSTRAINT [DF_PatientCP_CarePlan_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [PatientCP_CarePlan] ADD  CONSTRAINT [DF_PatientCP_CarePlan_CreatedDate]  DEFAULT (getutcdate()) FOR [CreatedDate]
ALTER TABLE [PatientCP_CarePlan] ADD  CONSTRAINT [DF_PatientCP_CarePlan_CreatedDateTime]  DEFAULT (getutcdate()) FOR [CreatedDateTime]
ALTER TABLE [PatientCP_CarePlan] ADD  CONSTRAINT [DF_PatientCP_CarePlan_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PatientCP_CareTeam]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[PatientCP_CareTeam](
	[PatientCP_CareTeamUid] [uniqueidentifier] NOT NULL,
	[PatientCP_CarePlanUid] [uniqueidentifier] NOT NULL,
	[PersonUid] [uniqueidentifier] NOT NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The last date the row was updated or the date added.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_CareTeam', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'

ALTER TABLE [PatientCP_CareTeam] ADD  CONSTRAINT [DF_PatientCP_CareTeam_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PatientCP_GoalHistory]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[PatientCP_GoalHistory](
	[PatientCP_GoalHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientCP_CarePlanUid] [uniqueidentifier] NOT NULL,
	[IsCurrentHistoryRow] [bit] NOT NULL,
	[GroupingUid] [uniqueidentifier] NULL,
	[CP_GoalUid] [uniqueidentifier] NULL,
	[ObservationItemUid] [uniqueidentifier] NULL,
	[QuestionUid] [uniqueidentifier] NULL,
	[AnswerUid] [uniqueidentifier] NULL,
	[Achieved] [bit] NOT NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[Author] [smallint] NOT NULL,
	[Name] [varchar](100) NULL,
	[GoalValue] [varchar](max) NULL,
	[Value1] [decimal](14, 6) NULL,
	[Value2] [decimal](14, 6) NULL,
	[Operator] [smallint] NULL,
	[AchievedDateTimeFrame] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[AchievedDate] [date] NULL,
	[DateToAchieveTimeFrame] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[DateToAchieve] [date] NULL,
	[StartDateTimeFrame] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[StartDate] [date] NULL,
	[EndTimeFrame] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[EndDate] [date] NULL,
	[PatientPriority] [smallint] NOT NULL,
	[ProviderPriority] [smallint] NOT NULL,
	[StatusUid] [uniqueidentifier] NOT NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[IsDelete] [bit] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[ActiveDate] [date] NULL,
	[InactiveDate] [date] NULL,
	[CreatedDateTime] [datetime] NOT NULL,
	[Sequence] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Marks the current active row in a PatientGoalHistory within the same GroupUid. Can be used to form a filter for returning rows.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_GoalHistory', @level2type=N'COLUMN',@level2name=N'IsCurrentHistoryRow'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Is used to find all the history rows belonging to the IsCurrentHistoryRow row. The first row create for a new patient goal row’s PK will populate the value for the GroupingUid.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_GoalHistory', @level2type=N'COLUMN',@level2name=N'GroupingUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Marks a row "Deleted" without removing the row. The UI will show this row as struck-out.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_GoalHistory', @level2type=N'COLUMN',@level2name=N'IsDelete'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Allows finding the history rows within the same GroupUid that are active. Can be used with InactiveDate and GroupUid to form a filter for returning rows.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_GoalHistory', @level2type=N'COLUMN',@level2name=N'ActiveDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Allows finding the history rows within the same GroupUid that are inactive. Can be used with ActiveDate and GroupUid to form a filter for returning rows.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_GoalHistory', @level2type=N'COLUMN',@level2name=N'InactiveDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Allows sorting the history rows within the same GroupUid in the order entered.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_GoalHistory', @level2type=N'COLUMN',@level2name=N'Sequence'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The last date the row was updated or the date added.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_GoalHistory', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'Author', @value=N'<none value="0" /><provider value="1" /><patient value="2" /><both value="3" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_GoalHistory'
EXEC sys.sp_addextendedproperty @name=N'Operator', @value=N'<none value="0" />
<less_than value="1" />
<greater_than value="2" />
<equal value="3" />
<equal_or_less_than value="4" />
<equal_or_greater_than value="5" />
<not_equal value="6" />
<between value = "7" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_GoalHistory'

ALTER TABLE [PatientCP_GoalHistory] ADD  CONSTRAINT [DF_PatientCP_GoalHistory_PatientCP_GoalHistoryUid]  DEFAULT (newid()) FOR [PatientCP_GoalHistoryUid]
ALTER TABLE [PatientCP_GoalHistory] ADD  CONSTRAINT [DF_PatientCP_GoalHistory_IsCurrentHistoryRow]  DEFAULT ((0)) FOR [IsCurrentHistoryRow]
ALTER TABLE [PatientCP_GoalHistory] ADD  CONSTRAINT [DF_PatientCP_GoalHistory_Achieved]  DEFAULT ((0)) FOR [Achieved]
ALTER TABLE [PatientCP_GoalHistory] ADD  CONSTRAINT [DF_PatientCP_GoalHistory_Author]  DEFAULT ((0)) FOR [Author]
ALTER TABLE [PatientCP_GoalHistory] ADD  CONSTRAINT [DF_PatientCP_GoalHistory_Operator]  DEFAULT ((0)) FOR [Operator]
ALTER TABLE [PatientCP_GoalHistory] ADD  CONSTRAINT [DF_PatientCP_GoalHistory_PatientPriority]  DEFAULT ((0)) FOR [PatientPriority]
ALTER TABLE [PatientCP_GoalHistory] ADD  CONSTRAINT [DF_PatientCP_GoalHistory_ProviderPriority]  DEFAULT ((0)) FOR [ProviderPriority]
ALTER TABLE [PatientCP_GoalHistory] ADD  CONSTRAINT [DF_PatientCP_GoalHistory_StatusUid]  DEFAULT ('821BA6C6-17CF-469D-A85D-62807714E99A') FOR [StatusUid]
ALTER TABLE [PatientCP_GoalHistory] ADD  CONSTRAINT [DF_PatientCP_GoalHistory_IsDelete]  DEFAULT ((0)) FOR [IsDelete]
ALTER TABLE [PatientCP_GoalHistory] ADD  CONSTRAINT [DF_PatientCP_GoalHistory_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [PatientCP_GoalHistory] ADD  CONSTRAINT [DF_PatientCP_GoalHistory_CreatedDateTime]  DEFAULT (getutcdate()) FOR [CreatedDateTime]
ALTER TABLE [PatientCP_GoalHistory] ADD  CONSTRAINT [DF_PatientCP_GoalHistory_Sequence]  DEFAULT (getutcdate()) FOR [Sequence]
ALTER TABLE [PatientCP_GoalHistory] ADD  CONSTRAINT [DF_PatientCP_GoalHistory_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PatientCP_GoalReview]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[PatientCP_GoalReview](
	[PatientCP_GoalReviewUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientCP_GoalHistoryUid] [uniqueidentifier] NOT NULL,
	[Comments] [varchar](max) NOT NULL,
	[Achieved] [bit] NOT NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[CreatedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]


ALTER TABLE [PatientCP_GoalReview] ADD  CONSTRAINT [DF_PatientCP_GoalReview_PatientCP_GoalReviewUid]  DEFAULT (newid()) FOR [PatientCP_GoalReviewUid]
ALTER TABLE [PatientCP_GoalReview] ADD  CONSTRAINT [DF_PatientCP_GoalReview_Comments]  DEFAULT ('') FOR [Comments]
ALTER TABLE [PatientCP_GoalReview] ADD  CONSTRAINT [DF_PatientCP_GoalReview_Achieved]  DEFAULT ((0)) FOR [Achieved]
ALTER TABLE [PatientCP_GoalReview] ADD  CONSTRAINT [DF_PatientCP_GoalReview_CreatedDate]  DEFAULT (getutcdate()) FOR [CreatedDate]
ALTER TABLE [PatientCP_GoalReview] ADD  CONSTRAINT [DF_PatientCP_GoalReview_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PatientCP_HealthConcernHistory]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[PatientCP_HealthConcernHistory](
	[PatientCP_HealthConcernHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientCP_CarePlanUid] [uniqueidentifier] NOT NULL,
	[IsCurrentHistoryRow] [bit] NOT NULL,
	[GroupingUid] [uniqueidentifier] NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[CP_HealthConcernUid] [uniqueidentifier] NULL,
	[Concern] [varchar](max) NULL,
	[PatientProblemDiagnosisUid] [uniqueidentifier] NULL,
	[PatientFamilyHistoryUid] [uniqueidentifier] NULL,
	[PatientProcedureHistoryUid] [uniqueidentifier] NULL,
	[PatientHistoryUid] [uniqueidentifier] NULL,
	[DiseaseUid] [uniqueidentifier] NULL,
	[AnswerUid] [uniqueidentifier] NULL,
	[QuestionUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[IsRisk] [bit] NOT NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[PatientPriority] [smallint] NOT NULL,
	[ProviderPriority] [smallint] NOT NULL,
	[StatusUid] [uniqueidentifier] NOT NULL,
	[IsDelete] [bit] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[ActiveDate] [date] NULL,
	[InactiveDate] [date] NULL,
	[CreatedDateTime] [datetime] NOT NULL,
	[Sequence] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Marks the current active row in a PatientHealthConcernHistory within the same GroupUid. Can be used to form a filter for returning rows.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_HealthConcernHistory', @level2type=N'COLUMN',@level2name=N'IsCurrentHistoryRow'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Is used to find all the history rows belonging to the IsCurrentHistoryRow row. The first row create for a new patient health concern row’s PK will populate the value for the GroupingUid.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_HealthConcernHistory', @level2type=N'COLUMN',@level2name=N'GroupingUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Marks a row "Deleted" without removing the row. The UI will show this row as struck-out.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_HealthConcernHistory', @level2type=N'COLUMN',@level2name=N'IsDelete'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Allows finding the history rows within the same GroupUid that are active. Can be used with InactiveDate and GroupUid to form a filter for returning rows.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_HealthConcernHistory', @level2type=N'COLUMN',@level2name=N'ActiveDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Allows finding the history rows within the same GroupUid that are inactive. Can be used with ActiveDate and GroupUid to form a filter for returning rows.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_HealthConcernHistory', @level2type=N'COLUMN',@level2name=N'InactiveDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Allows sorting the history rows within the same GroupUid in the order entered.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_HealthConcernHistory', @level2type=N'COLUMN',@level2name=N'Sequence'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The last date the row was updated or the date added.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_HealthConcernHistory', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'

ALTER TABLE [PatientCP_HealthConcernHistory] ADD  CONSTRAINT [DF_PatientCP_HealthConcernHistory_PatientCP_HealthConcernHistoryUid]  DEFAULT (newid()) FOR [PatientCP_HealthConcernHistoryUid]
ALTER TABLE [PatientCP_HealthConcernHistory] ADD  CONSTRAINT [DF_PatientCP_HealthConcernHistory_IsCurrentHistoryRow]  DEFAULT ((0)) FOR [IsCurrentHistoryRow]
ALTER TABLE [PatientCP_HealthConcernHistory] ADD  CONSTRAINT [DF_PatientCP_HealthConcernHistory_IsRisk]  DEFAULT ((0)) FOR [IsRisk]
ALTER TABLE [PatientCP_HealthConcernHistory] ADD  CONSTRAINT [DF_PatientCP_HealthConcernHistory_PatientPriority]  DEFAULT ((0)) FOR [PatientPriority]
ALTER TABLE [PatientCP_HealthConcernHistory] ADD  CONSTRAINT [DF_PatientCP_HealthConcernHistory_ProviderPriority]  DEFAULT ((0)) FOR [ProviderPriority]
ALTER TABLE [PatientCP_HealthConcernHistory] ADD  CONSTRAINT [DF_PatientCP_HealthConcernHistory_StatusUid]  DEFAULT ('821BA6C6-17CF-469D-A85D-62807714E99A') FOR [StatusUid]
ALTER TABLE [PatientCP_HealthConcernHistory] ADD  CONSTRAINT [DF_PatientCP_HealthConcernHistory_IsDelete]  DEFAULT ((0)) FOR [IsDelete]
ALTER TABLE [PatientCP_HealthConcernHistory] ADD  CONSTRAINT [DF_PatientCP_HealthConcernHistory_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [PatientCP_HealthConcernHistory] ADD  CONSTRAINT [DF_PatientCP_HealthConcernHistory_CreatedDateTime]  DEFAULT (getutcdate()) FOR [CreatedDateTime]
ALTER TABLE [PatientCP_HealthConcernHistory] ADD  CONSTRAINT [DF_PatientCP_HealthConcernHistory_Sequence]  DEFAULT (getutcdate()) FOR [Sequence]
ALTER TABLE [PatientCP_HealthConcernHistory] ADD  CONSTRAINT [DF_PatientCP_HealthConcernHistory_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PatientCP_InterventionHistory]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[PatientCP_InterventionHistory](
	[PatientCP_InterventionHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientCP_CarePlanUid] [uniqueidentifier] NOT NULL,
	[IsCurrentHistoryRow] [bit] NOT NULL,
	[GroupingUid] [uniqueidentifier] NULL,
	[VisitProcedureUid] [uniqueidentifier] NULL,
	[Description] [varchar](max) NULL,
	[CompletedTimeFrame] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[CompletedDate] [date] NULL,
	[StatusUid] [uniqueidentifier] NOT NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[IsDelete] [bit] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[ActiveDate] [date] NULL,
	[InactiveDate] [date] NULL,
	[CreatedDateTime] [datetime] NOT NULL,
	[Sequence] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Marks the current active row in a PatientInterventionHistory within the same GroupUid. Can be used to form a filter for returning rows.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_InterventionHistory', @level2type=N'COLUMN',@level2name=N'IsCurrentHistoryRow'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Is used to find all the history rows belonging to the IsCurrentHistoryRow row. The first row create for a new patient intervention row’s PK will populate the value for the GroupingUid.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_InterventionHistory', @level2type=N'COLUMN',@level2name=N'GroupingUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Marks a row "Deleted" without removing the row. The UI will show this row as struck-out.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_InterventionHistory', @level2type=N'COLUMN',@level2name=N'IsDelete'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Allows finding the history rows within the same GroupUid that are active. Can be used with InactiveDate and GroupUid to form a filter for returning rows.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_InterventionHistory', @level2type=N'COLUMN',@level2name=N'ActiveDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Allows finding the history rows within the same GroupUid that are inactive. Can be used with ActiveDate and GroupUid to form a filter for returning rows.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_InterventionHistory', @level2type=N'COLUMN',@level2name=N'InactiveDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Allows sorting the history rows within the same GroupUid in the order entered.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_InterventionHistory', @level2type=N'COLUMN',@level2name=N'Sequence'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The last date the row was updated or the date added.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientCP_InterventionHistory', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'

ALTER TABLE [PatientCP_InterventionHistory] ADD  CONSTRAINT [DF_PatientCP_InterventionHistory_PatientCP_InterventionHistoryUid]  DEFAULT (newid()) FOR [PatientCP_InterventionHistoryUid]
ALTER TABLE [PatientCP_InterventionHistory] ADD  CONSTRAINT [DF_PatientCP_InterventionHistory_IsCurrentHistoryRow]  DEFAULT ((0)) FOR [IsCurrentHistoryRow]
ALTER TABLE [PatientCP_InterventionHistory] ADD  CONSTRAINT [DF_PatientCP_InterventionHistory_StatusUid]  DEFAULT ('821BA6C6-17CF-469D-A85D-62807714E99A') FOR [StatusUid]
ALTER TABLE [PatientCP_InterventionHistory] ADD  CONSTRAINT [DF_PatientCP_InterventionHistory_IsDelete]  DEFAULT ((0)) FOR [IsDelete]
ALTER TABLE [PatientCP_InterventionHistory] ADD  CONSTRAINT [DF_PatientCP_InterventionHistory_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [PatientCP_InterventionHistory] ADD  CONSTRAINT [DF_PatientCP_InterventionHistory_CreatedDateTime]  DEFAULT (getutcdate()) FOR [CreatedDateTime]
ALTER TABLE [PatientCP_InterventionHistory] ADD  CONSTRAINT [DF_PatientCP_InterventionHistory_Sequence]  DEFAULT (getutcdate()) FOR [Sequence]
ALTER TABLE [PatientCP_InterventionHistory] ADD  CONSTRAINT [DF_PatientCP_InterventionHistory_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PatientMedicalDeviceHistory]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[PatientMedicalDeviceHistory](
	[PatientMedicalDeviceHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[IsCurrentHistoryRow] [bit] NOT NULL,
	[GroupingUid] [uniqueidentifier] NULL,
	[DeviceId] [varchar](50) NOT NULL,
	[BrandName] [varchar](200) NULL,
	[GmdnPTName] [varchar](200) NULL,
	[DeviceXml] [xml] NOT NULL,
	[UniqueDeviceId] [varchar](100) NULL,
	[UniqueDeviceXml] [xml] NULL,
	[DeviceActiveDate] [date] NULL,
	[DeviceActiveDateTimeFrame] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[DeviceInactiveDate] [date] NULL,
	[DeviceInactiveDateTimeFrame] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[MedicalDeviceStatusUid] [uniqueidentifier] NOT NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[IsDelete] [bit] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[ActiveDate] [date] NULL,
	[InactiveDate] [date] NULL,
	[CreatedDateTime] [datetime] NOT NULL,
	[Sequence] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Marks the current active row in a PatientMedicalDeviceHistory within the same GroupUid. Can be used to form a filter for returning rows.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientMedicalDeviceHistory', @level2type=N'COLUMN',@level2name=N'IsCurrentHistoryRow'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Is used to find all the history rows belonging to the IsCurrentHistoryRow row. The first row create for a new patient medical device row’s PK will populate the value for the GroupingUid.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientMedicalDeviceHistory', @level2type=N'COLUMN',@level2name=N'GroupingUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Marks a row "Deleted" without removing the row. The UI will show this row as struck-out.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientMedicalDeviceHistory', @level2type=N'COLUMN',@level2name=N'IsDelete'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Allows finding the history rows within the same GroupUid that are active. Can be used with InactiveDate and GroupUid to form a filter for returning rows.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientMedicalDeviceHistory', @level2type=N'COLUMN',@level2name=N'ActiveDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Allows finding the history rows within the same GroupUid that are inactive. Can be used with ActiveDate and GroupUid to form a filter for returning rows.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientMedicalDeviceHistory', @level2type=N'COLUMN',@level2name=N'InactiveDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Allows sorting the history rows within the same GroupUid in the order entered.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientMedicalDeviceHistory', @level2type=N'COLUMN',@level2name=N'Sequence'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The last date the row was updated or the date added.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'PatientMedicalDeviceHistory', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'

ALTER TABLE [PatientMedicalDeviceHistory] ADD  CONSTRAINT [DF_PatientMedicalDeviceHistory_PatientMedicalDeviceHistoryUid]  DEFAULT (newid()) FOR [PatientMedicalDeviceHistoryUid]
ALTER TABLE [PatientMedicalDeviceHistory] ADD  CONSTRAINT [DF_PatientMedicalDeviceHistory_IsDelete]  DEFAULT ((0)) FOR [IsDelete]
ALTER TABLE [PatientMedicalDeviceHistory] ADD  CONSTRAINT [DF_PatientMedicalDeviceHistory_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [PatientMedicalDeviceHistory] ADD  CONSTRAINT [DF_PatientMedicalDeviceHistory_CreatedDateTime]  DEFAULT (getutcdate()) FOR [CreatedDateTime]
ALTER TABLE [PatientMedicalDeviceHistory] ADD  CONSTRAINT [DF_PatientMedicalDeviceHistory_Sequence]  DEFAULT (getutcdate()) FOR [Sequence]
ALTER TABLE [PatientMedicalDeviceHistory] ADD  CONSTRAINT [DF_PatientMedicalDeviceHistory_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_PatientProblemDiagnosisHistory]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_PatientProblemDiagnosisHistory](
	[PatientProblemDiagnosisHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[IsCurrentHistoryRow] [bit] NULL,
	[GroupingUid] [uniqueidentifier] NULL,
	[Code9] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[Name] [varchar](255) NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[DiseaseUid] [uniqueidentifier] NULL,
	[ProblemStatusUid] [uniqueidentifier] NULL,
	[ProviderUid] [uniqueidentifier] NULL,
	[ProblemGroupingUid] [uniqueidentifier] NULL,
	[OnsetTimeFrame] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[OnsetDate] [date] NULL,
	[ResolvedTimeFrame] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[ResolvedDate] [date] NULL,
	[IsDelete] [bit] NOT NULL,
	[IsPatientProblem] [bit] NOT NULL,
	[IsAddendum] [bit] NOT NULL,
	[AddendumNotes] [varchar](max) NULL,
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL,
	[ActiveDate] [date] NULL,
	[InactiveDate] [date] NULL,
	[Sequence] [datetime] NULL,
	[LastDiagnosisDate] [date] NULL,
	[DSMAxis] [varchar](250) NULL,
	[VisitDiagnosisType] [smallint] NULL,
	[SnomedCTConceptId] [bigint] NULL,
	[IsPatientInput] [bit] NOT NULL,
	[HccCommunityFactors] [decimal](4, 3) NULL,
	[LifeLong] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Marks the current active row in a PatientProblemDiagnosisHistory within the same GroupUid. Can be used to form a filter for returning rows.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientProblemDiagnosisHistory', @level2type=N'COLUMN',@level2name=N'IsCurrentHistoryRow'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Is used to find all the history rows belonging to the IsCurrentHistoryRow row. The first row create for a new patient goal row’s PK will populate the value for the GroupingUid.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientProblemDiagnosisHistory', @level2type=N'COLUMN',@level2name=N'GroupingUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Used to indicate the related problem.   A method in the busniess object can be used to get the related problem.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientProblemDiagnosisHistory', @level2type=N'COLUMN',@level2name=N'ProblemGroupingUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Marks a row "Deleted" without removing the row. The UI will show this row as struck-out.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientProblemDiagnosisHistory', @level2type=N'COLUMN',@level2name=N'IsDelete'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Allows finding the history rows within the same GroupUid that are active. Can be used with InactiveDate and GroupUid to form a filter for returning rows.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientProblemDiagnosisHistory', @level2type=N'COLUMN',@level2name=N'ActiveDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Allows finding the history rows within the same GroupUid that are inactive. Can be used with ActiveDate and GroupUid to form a filter for returning rows.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientProblemDiagnosisHistory', @level2type=N'COLUMN',@level2name=N'InactiveDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Allows sorting the history rows within the same GroupUid in the order entered.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientProblemDiagnosisHistory', @level2type=N'COLUMN',@level2name=N'Sequence'

ALTER TABLE [migtemp_PatientProblemDiagnosisHistory] ADD  CONSTRAINT [DF_PatientProblemDiagnosisHistory_PatientProblemDiagnosisHistoryUid]  DEFAULT (newid()) FOR [PatientProblemDiagnosisHistoryUid]
ALTER TABLE [migtemp_PatientProblemDiagnosisHistory] ADD  CONSTRAINT [DF_PatientProblemDiagnosisHistory_IsCurrentHistoryRow]  DEFAULT ((0)) FOR [IsCurrentHistoryRow]
ALTER TABLE [migtemp_PatientProblemDiagnosisHistory] ADD  CONSTRAINT [DF_PatientProblemDiagnosisHistory_IsDelete]  DEFAULT ((0)) FOR [IsDelete]
ALTER TABLE [migtemp_PatientProblemDiagnosisHistory] ADD  CONSTRAINT [DF_PatientProblemDiagnosisHistory_IsPatientProblem]  DEFAULT ((0)) FOR [IsPatientProblem]
ALTER TABLE [migtemp_PatientProblemDiagnosisHistory] ADD  CONSTRAINT [DF_PatientProblemDiagnosisHistory_IsAddendum]  DEFAULT ((0)) FOR [IsAddendum]
ALTER TABLE [migtemp_PatientProblemDiagnosisHistory] ADD  CONSTRAINT [DF_PatientProblemDiagnosisHistory_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [migtemp_PatientProblemDiagnosisHistory] ADD  CONSTRAINT [DF_PatientProblemDiagnosisHistory_SortDate]  DEFAULT (getutcdate()) FOR [Sequence]
ALTER TABLE [migtemp_PatientProblemDiagnosisHistory] ADD  CONSTRAINT [DF_PatientProblemDiagnosisHistory_IsPatientInput]  DEFAULT ((0)) FOR [IsPatientInput]
ALTER TABLE [migtemp_PatientProblemDiagnosisHistory] ADD  CONSTRAINT [DF_PatientProblemDiagnosisHistory_LifeLong]  DEFAULT ((0)) FOR [LifeLong]
ALTER TABLE [migtemp_PatientProblemDiagnosisHistory] ADD  CONSTRAINT [DF_PatientProblemDiagnosisHistory_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_PatientProblemDiagnosisHistory
INSERT [migtemp_PatientProblemDiagnosisHistory]([PatientProblemDiagnosisHistoryUid],[GroupingUid],[Code9],[Code10],[Name],[PatientUid],[VisitUid],[DiseaseUid],[ProblemStatusUid],[ProviderUid],[OnsetTimeFrame],[OnsetDate],[ResolvedTimeFrame],[ResolvedDate],[IsDelete],[IsPatientProblem],[IsAddendum],[AddendumNotes],[Notes],[DisplayOrder],[ActiveDate],[InactiveDate],[Sequence],[LastDiagnosisDate],[DSMAxis],[VisitDiagnosisType],[SnomedCTConceptId],[IsPatientInput],[HccCommunityFactors],[LifeLong],[LastModifiedByUid],[LastModifiedDate])
SELECT [PatientProblemDiagnosisHistoryUid],[GroupingUid],[Code9],[Code10],[Name],[PatientUid],[VisitUid],[DiseaseUid],[ProblemStatusUid],[ProviderUid],CONVERT(nvarchar(max), [OnsetTimeFrame]),[OnsetDate],CONVERT(nvarchar(max), [ResolvedTimeFrame]),[ResolvedDate],[IsDelete],[IsPatientProblem],[IsAddendum],[AddendumNotes],[Notes],[DisplayOrder],[ActiveDate],[InactiveDate],[SortDate],[LastDiagnosisDate],[DSMAxis],[VisitDiagnosisType],[SnomedCTConceptId],[IsPatientInput],[HccCommunityFactors],[LifeLong],[LastModifiedByUid],[LastModifiedDate]
FROM [PatientProblemDiagnosisHistory]

DROP TABLE [PatientProblemDiagnosisHistory]

exec  sp_rename 'migtemp_PatientProblemDiagnosisHistory', 'PatientProblemDiagnosisHistory'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_PatientProcedureHistory]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_PatientProcedureHistory](
	[PatientProcedureHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[IsCurrentHistoryRow] [bit] NOT NULL,
	[PatientUid] [uniqueidentifier] NOT NULL,
	[GroupingUid] [uniqueidentifier] NULL,
	[Code] [varchar](30) NULL,
	[TermName] [varchar](255) NULL,
	[ShortDescription] [varchar](75) NULL,
	[ProcedureHistoryTermUid] [uniqueidentifier] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[ProcedureUid] [uniqueidentifier] NULL,
	[HistoryGroupUid] [uniqueidentifier] NULL,
	[ProcedureHistoryStatusUid] [uniqueidentifier] NULL,
	[NegationReasonUid] [uniqueidentifier] NULL,
	[PerformTimeFrame] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[PerformDate] [date] NULL,
	[ResultTimeFrame] [xml](CONTENT [dbo].[TimeFrame]) NULL,
	[ResultDate] [date] NULL,
	[OrderDate] [date] NULL,
	[IsDelete] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[ActiveDate] [date] NULL,
	[InactiveDate] [date] NULL,
	[Sequence] [datetime] NOT NULL,
	[IsPatientInput] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Marks the current active row in a PatientProcedureHistory within the same GroupUid. Can be used to form a filter for returning rows.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientProcedureHistory', @level2type=N'COLUMN',@level2name=N'IsCurrentHistoryRow'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Is used to find all the history rows belonging to the IsCurrentHistoryRow row. The first row create for a new patient goal row’s PK will populate the value for the GroupingUid.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientProcedureHistory', @level2type=N'COLUMN',@level2name=N'GroupingUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Marks a row "Deleted" without removing the row. The UI will show this row as struck-out.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientProcedureHistory', @level2type=N'COLUMN',@level2name=N'IsDelete'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Allows finding the history rows within the same GroupUid that are active. Can be used with InactiveDate and GroupUid to form a filter for returning rows.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientProcedureHistory', @level2type=N'COLUMN',@level2name=N'ActiveDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Allows finding the history rows within the same GroupUid that are inactive. Can be used with ActiveDate and GroupUid to form a filter for returning rows.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientProcedureHistory', @level2type=N'COLUMN',@level2name=N'InactiveDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Allows sorting the history rows within the same GroupUid in the order entered.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PatientProcedureHistory', @level2type=N'COLUMN',@level2name=N'Sequence'

ALTER TABLE [migtemp_PatientProcedureHistory] ADD  CONSTRAINT [DF_PatientProcedureHistory_PatientProcedureHistoryUid]  DEFAULT (newid()) FOR [PatientProcedureHistoryUid]
ALTER TABLE [migtemp_PatientProcedureHistory] ADD  CONSTRAINT [DF_PatientProcedureHistory_IsCurrentHistoryRow]  DEFAULT ((0)) FOR [IsCurrentHistoryRow]
ALTER TABLE [migtemp_PatientProcedureHistory] ADD  CONSTRAINT [DF_PatientProcedureHistory_IsDelete]  DEFAULT ((0)) FOR [IsDelete]
ALTER TABLE [migtemp_PatientProcedureHistory] ADD  CONSTRAINT [DF_PatientProcedureHistory_Sequence]  DEFAULT (getutcdate()) FOR [Sequence]
ALTER TABLE [migtemp_PatientProcedureHistory] ADD  CONSTRAINT [DF_PatientProcedureHistory_IsPatientInput]  DEFAULT ((0)) FOR [IsPatientInput]
ALTER TABLE [migtemp_PatientProcedureHistory] ADD  CONSTRAINT [DF_PatientProcedureHistory_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_PatientProcedureHistory
INSERT [migtemp_PatientProcedureHistory]([PatientProcedureHistoryUid],[PatientUid],[GroupingUid],[Code],[TermName],[ShortDescription],[ProcedureHistoryTermUid],[VisitUid],[ProcedureUid],[HistoryGroupUid],[ProcedureHistoryStatusUid],[NegationReasonUid],[PerformTimeFrame],[PerformDate],[ResultTimeFrame],[ResultDate],[OrderDate],[IsDelete],[Notes],[ActiveDate],[InactiveDate],[IsPatientInput],[LastModifiedByUid],[LastModifiedDate])
SELECT [PatientProcedureHistoryUid],[PatientUid],[GroupingUid],[Code],[TermName],[ShortDescription],[ProcedureHistoryTermUid],[VisitUid],[ProcedureUid],[HistoryGroupUid],[ProcedureHistoryStatusUid],[NegationReasonUid],CONVERT(nvarchar(max), [PerformTimeFrame]),[PerformDate],CONVERT(nvarchar(max), [ResultTimeFrame]),[ResultDate],[OrderDate],[IsDelete],[Notes],[ActiveDate],[InactiveDate],[IsPatientInput],[LastModifiedByUid],[LastModifiedDate]
FROM [PatientProcedureHistory]

DROP TABLE [PatientProcedureHistory]

exec  sp_rename 'migtemp_PatientProcedureHistory', 'PatientProcedureHistory'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_Person]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_Person](
	[PersonUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientCenterUid] [uniqueidentifier] NULL,
	[Inactive] [bit] NOT NULL,
	[Prefix] [varchar](25) NULL,
	[FirstName] [varchar](50) NULL,
	[MiddleName] [varchar](50) NULL,
	[LastName] [varchar](50) NOT NULL,
	[Suffix] [varchar](50) NULL,
	[Address1] [xml](CONTENT [dbo].[Address]) NULL,
	[BadAddress1] [bit] NULL,
	[Address2] [xml](CONTENT [dbo].[Address]) NULL,
	[Phone1] [xml](CONTENT [dbo].[Phone]) NULL,
	[Phone2] [xml](CONTENT [dbo].[Phone]) NULL,
	[Phone3] [xml](CONTENT [dbo].[Phone]) NULL,
	[Phone4] [xml](CONTENT [dbo].[Phone]) NULL,
	[Email1] [varchar](100) NULL,
	[Email2] [varchar](100) NULL,
	[Notes] [varchar](max) NULL,
	[LanguageUid] [uniqueidentifier] NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[Hispanic] [bit] NOT NULL,
	[Birthdate] [date] NULL,
	[BirthTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[Deathdate] [date] NULL,
	[AkaFirstName] [varchar](50) NULL,
	[AkaLastName] [varchar](50) NULL,
	[SocialSecurityNumber] [varchar](11) NULL,
	[DriverLicenseNumber] [varchar](25) NULL,
	[DriverLicenseState] [varchar](3) NULL,
	[DriverLicenseAttachmentUid] [uniqueidentifier] NULL,
	[PhotoAttachmentUid] [uniqueidentifier] NULL,
	[LivesWithPersonUid] [uniqueidentifier] NULL,
	[MaritalStatusUid] [uniqueidentifier] NULL,
	[DominantHandUid] [uniqueidentifier] NULL,
	[PreferredContactMethod] [varchar](50) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[MaidenName] [varchar](50) NULL,
	[NotificationMethodUid] [uniqueidentifier] NULL,
	[EmailDirect] [varchar](200) NULL,
	[BirthPlace] [xml](CONTENT [dbo].[Address]) NULL,
	[Computed_Address1_Address1] [varchar](100) NULL,
	[Computed_Address1_Address2] [varchar](100) NULL,
	[Computed_Address1_City] [varchar](35) NULL,
	[Computed_Address1_State] [varchar](3) NULL,
	[Computed_Address1_Zip] [varchar](10) NULL,
	[Computed_Phone1_PhoneNumber] [varchar](80) NULL,
	[Computed_Phone1_PhoneType] [varchar](50) NULL,
	[Computed_Phone2_PhoneNumber] [varchar](80) NULL,
	[Computed_Phone2_PhoneType] [varchar](50) NULL,
	[Computed_Phone3_PhoneNumber] [varchar](80) NULL,
	[Computed_Phone3_PhoneType] [varchar](50) NULL,
	[Computed_Phone4_PhoneNumber] [varchar](80) NULL,
	[Computed_Phone4_PhoneType] [varchar](50) NULL,
	[MotherMaidenName] [varchar](50) NULL,
	[MotherMaidenFirstName] [varchar](50) NULL,
	[IdentityVerification] [xml] NULL,
	[LastIdentityVerificationTransaction] [varchar](max) NULL,
	[TranslatorRequired] [bit] NULL,
	[SexualOrientationUid] [uniqueidentifier] NULL,
	[GenderIdentityUid] [uniqueidentifier] NULL,
	[SendSms] [bit] NOT NULL,
	[SendEmail] [bit] NOT NULL,
	[NoEmailAddressProvided] [bit] NOT NULL,
	[Email1MessagingAllowed] [bit] NULL,
	[Email2MessagingAllowed] [bit] NULL,
	[Phone1MessagingAllowed] [bit] NULL,
	[Phone2MessagingAllowed] [bit] NULL,
	[Phone3MessagingAllowed] [bit] NULL,
	[Phone4MessagingAllowed] [bit] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Email address used to transmit data (CCDs, CCDAs, etc) using the Direct Method' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'EmailDirect'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Address1_Address1'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Address1_Address2'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Address1_City'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Address1_State'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Address1_Zip'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Phone1_PhoneNumber'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Phone1_PhoneType'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Phone2_PhoneNumber'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Phone2_PhoneType'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Phone3_PhoneNumber'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Phone3_PhoneType'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Phone4_PhoneNumber'
EXEC sys.sp_addextendedproperty @name=N'Hidden', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person', @level2type=N'COLUMN',@level2name=N'Computed_Phone4_PhoneType'
EXEC sys.sp_addextendedproperty @name=N'Replication.ObjectCache', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person'
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'{FK_Patient_Person,!FK_PersonRawUnencrypted_Photo}' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person'
EXEC sys.sp_addextendedproperty @name=N'Replication.RootTableOfNonAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Person'

ALTER TABLE [migtemp_Person] ADD  CONSTRAINT [DF_Person_PersonUid]  DEFAULT (newid()) FOR [PersonUid]
ALTER TABLE [migtemp_Person] ADD  CONSTRAINT [DF_Person_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [migtemp_Person] ADD  CONSTRAINT [DF_Person_BadAddress1]  DEFAULT ((0)) FOR [BadAddress1]
ALTER TABLE [migtemp_Person] ADD  CONSTRAINT [DF_Person_Hispanic]  DEFAULT ((0)) FOR [Hispanic]
ALTER TABLE [migtemp_Person] ADD  CONSTRAINT [DF_Person_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [migtemp_Person] ADD  CONSTRAINT [DF_Person_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]
ALTER TABLE [migtemp_Person] ADD  CONSTRAINT [DF_Person_TranslatorRequired]  DEFAULT ((0)) FOR [TranslatorRequired]
ALTER TABLE [migtemp_Person] ADD  CONSTRAINT [DF__Person_Sms]  DEFAULT ((0)) FOR [SendSms]
ALTER TABLE [migtemp_Person] ADD  CONSTRAINT [DF_Person_Email]  DEFAULT ((0)) FOR [SendEmail]
ALTER TABLE [migtemp_Person] ADD  CONSTRAINT [DF_Person_NoEmailAddressProvided]  DEFAULT ((0)) FOR [NoEmailAddressProvided]

END
Truncate Table migtemp_Person
INSERT [migtemp_Person]([PersonUid],[PatientCenterUid],[Inactive],[Prefix],[FirstName],[MiddleName],[LastName],[Suffix],[Address1],[BadAddress1],[Address2],[Phone1],[Phone2],[Phone3],[Phone4],[Email1],[Email2],[Notes],[LanguageUid],[GenderUid],[Hispanic],[Birthdate],[BirthTime],[Deathdate],[AkaFirstName],[AkaLastName],[SocialSecurityNumber],[DriverLicenseNumber],[DriverLicenseState],[DriverLicenseAttachmentUid],[PhotoAttachmentUid],[LivesWithPersonUid],[MaritalStatusUid],[DominantHandUid],[PreferredContactMethod],[UserDefined],[LastModifiedDate],[LastModifiedByUid],[MaidenName],[NotificationMethodUid],[EmailDirect],[BirthPlace],[Computed_Address1_Address1],[Computed_Address1_Address2],[Computed_Address1_City],[Computed_Address1_State],[Computed_Address1_Zip],[Computed_Phone1_PhoneNumber],[Computed_Phone1_PhoneType],[Computed_Phone2_PhoneNumber],[Computed_Phone2_PhoneType],[Computed_Phone3_PhoneNumber],[Computed_Phone3_PhoneType],[Computed_Phone4_PhoneNumber],[Computed_Phone4_PhoneType],[MotherMaidenName],[MotherMaidenFirstName],[IdentityVerification],[LastIdentityVerificationTransaction],[TranslatorRequired],[SexualOrientationUid],[GenderIdentityUid],[SendSms],[SendEmail],[NoEmailAddressProvided])
SELECT [PersonUid],[PatientCenterUid],[Inactive],[Prefix],[FirstName],[MiddleName],[LastName],[Suffix],CONVERT(nvarchar(max), [Address1]),[BadAddress1],CONVERT(nvarchar(max), [Address2]),CONVERT(nvarchar(max), [Phone1]),CONVERT(nvarchar(max), [Phone2]),CONVERT(nvarchar(max), [Phone3]),CONVERT(nvarchar(max), [Phone4]),[Email1],[Email2],[Notes],[LanguageUid],[GenderUid],[Hispanic],[Birthdate],[BirthTime],[Deathdate],[AkaFirstName],[AkaLastName],[SocialSecurityNumber],[DriverLicenseNumber],[DriverLicenseState],[DriverLicenseAttachmentUid],[PhotoAttachmentUid],[LivesWithPersonUid],[MaritalStatusUid],[DominantHandUid],[PreferredContactMethod],[UserDefined],[LastModifiedDate],[LastModifiedByUid],[MaidenName],[NotificationMethodUid],[EmailDirect],CONVERT(nvarchar(max), [BirthPlace]),[Computed_Address1_Address1],[Computed_Address1_Address2],[Computed_Address1_City],[Computed_Address1_State],[Computed_Address1_Zip],[Computed_Phone1_PhoneNumber],[Computed_Phone1_PhoneType],[Computed_Phone2_PhoneNumber],[Computed_Phone2_PhoneType],[Computed_Phone3_PhoneNumber],[Computed_Phone3_PhoneType],[Computed_Phone4_PhoneNumber],[Computed_Phone4_PhoneType],[MotherMaidenName],[MotherMaidenFirstName],CONVERT(nvarchar(max), [IdentityVerification]),[LastIdentityVerificationTransaction],[TranslatorRequired],[SexualOrientationUid],[GenderIdentityUid],[SendSms],[SendEmail],[NoEmailAddressProvided]
FROM [Person]

DROP TABLE [Person]

exec  sp_rename 'migtemp_Person', 'Person'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_PersonContact]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_PersonContact](
	[PersonContactUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PersonUid] [uniqueidentifier] NOT NULL,
	[ContactPersonUid] [uniqueidentifier] NOT NULL,
	[ContactRelationshipUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL,
	[EmergencyContact] [bit] NOT NULL,
	[AuthorizedToMakeMedicalDecisions] [bit] NOT NULL,
	[AllowHIPAARelease] [smallint] NOT NULL,
	[HIPAARelease] [xml] NULL,
	[Notes] [varchar](max) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Main person with contact.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonContact', @level2type=N'COLUMN',@level2name=N'PersonUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Contact.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonContact', @level2type=N'COLUMN',@level2name=N'ContactPersonUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Relationship of contact to main person.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonContact', @level2type=N'COLUMN',@level2name=N'ContactRelationshipUid'
EXEC sys.sp_addextendedproperty @name=N'AllowHIPAARelease', @value=N'<NA value="0" /><All value="1" /><Only value="2" /><Except value="3" /><None value="4" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonContact'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Contacts for a person. (Single directional.)' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonContact'
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'FK_PersonContact_Person' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_PersonContact'

ALTER TABLE [migtemp_PersonContact] ADD  CONSTRAINT [DF_PersonContact_PersonContactUid]  DEFAULT (newid()) FOR [PersonContactUid]
ALTER TABLE [migtemp_PersonContact] ADD  CONSTRAINT [DF_PersonContact_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [migtemp_PersonContact] ADD  CONSTRAINT [DF_PersonContact_EmergencyContact]  DEFAULT ((0)) FOR [EmergencyContact]
ALTER TABLE [migtemp_PersonContact] ADD  CONSTRAINT [DF_PersonContact_AuthorizedToMakeMedicalDecisions]  DEFAULT ((0)) FOR [AuthorizedToMakeMedicalDecisions]
ALTER TABLE [migtemp_PersonContact] ADD  CONSTRAINT [DF_PersonContact_AllowHIPAARelease_1]  DEFAULT ((0)) FOR [AllowHIPAARelease]
ALTER TABLE [migtemp_PersonContact] ADD  CONSTRAINT [DF_PersonContact_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_PersonContact
INSERT [migtemp_PersonContact]([PersonContactUid],[PersonUid],[ContactPersonUid],[ContactRelationshipUid],[DisplayOrder],[EmergencyContact],[AuthorizedToMakeMedicalDecisions],[AllowHIPAARelease],[HIPAARelease],[Notes],[LastModifiedDate],[LastModifiedByUid])
SELECT [PersonContactUid],[PersonUid],[ContactPersonUid],[ContactRelationshipUid],[DisplayOrder],[EmergencyContact],[AuthorizedToMakeMedicalDecisions],[AllowHIPAARelease],CONVERT(nvarchar(max), [HIPAARelease]),[Notes],[LastModifiedDate],[LastModifiedByUid]
FROM [PersonContact]

DROP TABLE [PersonContact]

exec  sp_rename 'migtemp_PersonContact', 'PersonContact'

exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[PracticeSettings]') AND type in (N'U'))
ALTER TABLE [PracticeSettings] ADD [EnableEligibilityCheckFromTrackSuperbills] bit NOT NULL CONSTRAINT DF_PracticeSettings_EnableEligibilityCheckFromTrackSuperbills DEFAULT ((0)) 
IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[PracticeSettings]') AND type in (N'U'))
ALTER TABLE [PracticeSettings] ADD [EnableDepositsByFinancialCenter] bit NOT NULL CONSTRAINT DF_PracticeSettings_EnableDepositsByFinancialCenter DEFAULT ((0)) 
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ProductConcurrentLicenseUse]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[ProductConcurrentLicenseUse](
	[ProductConcurrentLicenseUseUid] [uniqueidentifier] NOT NULL,
	[MachineName] [varchar](25) NULL,
	[UserUid] [uniqueidentifier] NULL,
	[ProductCode] [varchar](100) NULL,
	[LastUsedDate] [datetime] NOT NULL,
	[ApplicationInstanceUid] [uniqueidentifier] NOT NULL
) ON [PRIMARY]


ALTER TABLE [ProductConcurrentLicenseUse] ADD  CONSTRAINT [DF_ProductConcurrentLicenseUse_ProductConcurrentLicenseUseUid]  DEFAULT (newid()) FOR [ProductConcurrentLicenseUseUid]
ALTER TABLE [ProductConcurrentLicenseUse] ADD  CONSTRAINT [DF_ProductConcurrentLicenseUse_LastUsedDate]  DEFAULT (getutcdate()) FOR [LastUsedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_Provider]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_Provider](
	[PersonUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[Inactive] [bit] NOT NULL,
	[ProviderRoleID] [smallint] NOT NULL,
	[IsBillingProvider] [bit] NOT NULL,
	[IsReferringProvider] [bit] NOT NULL,
	[FTE] [smallint] NULL,
	[ProviderLicense] [smallint] NULL,
	[DefaultProviderCareTypeUid] [uniqueidentifier] NULL,
	[DefaultServiceSiteUid] [uniqueidentifier] NULL,
	[FinancialCenterUid] [uniqueidentifier] NULL,
	[FeeScheduleUid] [uniqueidentifier] NULL,
	[SignatureTypeId] [smallint] NOT NULL,
	[ReplicationAppointmentHours] [smallint] NOT NULL,
	[ReplicationRemovePatientHours] [smallint] NOT NULL,
	[ReplicationAttachmentSizeKB] [smallint] NOT NULL,
	[AutoLearnCommonProblemPallet] [bit] NOT NULL,
	[EMCodeReminder] [bit] NOT NULL,
	[ePrescribeWarning] [bit] NOT NULL,
	[PrintPrescriptionsOnCheckout] [bit] NOT NULL,
	[DefaultListInFNC] [smallint] NOT NULL,
	[ROSOrder] [smallint] NOT NULL,
	[RxThermalPrinter] [bit] NOT NULL,
	[ClinicCenterUid] [uniqueidentifier] NULL,
	[TranscriptionistUid] [uniqueidentifier] NULL,
	[SpecialtyUid] [uniqueidentifier] NULL,
	[ETIN] [varchar](50) NULL,
	[EClaimSiteTaxID] [varchar](50) NULL,
	[MandatoryCosignature] [bit] NOT NULL,
	[SupervisingPrescriptionSignatureSource] [bit] NOT NULL,
	[CanSignRx] [bit] NOT NULL,
	[DefaultReviewerUid] [uniqueidentifier] NULL,
	[RxReportRdlUid] [uniqueidentifier] NULL,
	[ScheduleIIRxReportRdlUid] [uniqueidentifier] NULL,
	[MedicationReportLastRun] [datetime] NULL,
	[UsePracticeSettingsBillingAddress] [bit] NOT NULL,
	[UsePracticeSettingsMaintenaceDrugCls] [bit] NOT NULL,
	[ClaimProviderCorporationUid] [uniqueidentifier] NULL,
	[Notes] [varchar](max) NULL,
	[ExternalID] [varchar](25) NULL,
	[AutoLinkDxCpt] [bit] NOT NULL,
	[SuperbillStatusID] [smallint] NOT NULL,
	[ConsultingProvider] [bit] NOT NULL,
	[AuthorizationGroupUid] [uniqueidentifier] NULL,
	[AuthorizationReviewerUid] [uniqueidentifier] NULL,
	[DrugScreeningCriteria] [varchar](max) NULL,
	[UseLDM] [bit] NOT NULL,
	[AutoAddMedicationReport] [bit] NOT NULL,
	[EduFormAssociationUid] [uniqueidentifier] NULL,
	[PayToProviderCorporationUid] [uniqueidentifier] NULL,
	[Initials] [varchar](5) NULL,
	[DocumentFaxElection] [smallint] NOT NULL,
	[RouteDocumentFaxErrorToUserUid] [uniqueidentifier] NULL,
	[DefaultCoverageTypeUid] [uniqueidentifier] NULL,
	[DefaultLabOrderTaskMsgRecvrUid] [uniqueidentifier] NULL,
	[AutoSendLabOrderMsgs] [bit] NULL,
	[UsePracticeSettingseRxDownloadSetting] [bit] NOT NULL,
	[eRxDownloadSetting] [varchar](2048) NULL,
	[AutoCheckNoteComplete] [bit] NOT NULL,
	[RoutePatientMessages] [xml](CONTENT [dbo].[PatientMessagesToUserGroup]) NULL,
	[DefaultCheckDischargePatient] [bit] NOT NULL,
	[DefaultCheckSendPrescriptions] [bit] NOT NULL,
	[DefaultCheckSendLabOrders] [bit] NOT NULL,
	[AllowProcedureWithoutDiag] [bit] NOT NULL,
	[RouteVisitBillingMessageToUserGroupUid] [uniqueidentifier] NULL,
	[RouteNUSBVisitBillingMessageToUserGroupUid] [uniqueidentifier] NULL,
	[SendCanelServiceOrderMessage] [bit] NOT NULL,
	[UsePracticeSettingsPatientEmails] [bit] NOT NULL,
	[PatientEmails] [xml](CONTENT [dbo].[PatientInternetEmails]) NULL,
	[ValidateBillingTime] [bit] NOT NULL,
	[AprimaDataExchangeRegistrationLastUpdate] [datetime] NULL,
	[AprimaDataExchangeProviderRegistrationUid] [uniqueidentifier] NULL,
	[DefaultEMPlaceofServiceID] [tinyint] NULL,
	[AutoLinkingDiagnosisProblem] [bit] NOT NULL,
	[DefaultBillingProviderUid] [uniqueidentifier] NULL,
	[IdentityVerification] [xml] NULL,
	[CDSCatalogUid] [uniqueidentifier] NULL,
	[DiagnosisRangePlanUid] [uniqueidentifier] NULL,
	[KdbConfigurationUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'The full time equivalent percentage for this provider' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider', @level2type=N'COLUMN',@level2name=N'FTE'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'0 - Head to Toe; 1 - Alphabetical; 2 - User Defined' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider', @level2type=N'COLUMN',@level2name=N'ROSOrder'
EXEC sys.sp_addextendedproperty @name=N'DefaultEMPlaceofServiceID', @value=N'<Office value="0" description="Office" /><NursingFacility value="1" description="Nursing Facility" /><HomeServices value="2" description="Home Services" /><RestHome value="3" description="Rest Home" /><Observation value="4" description="Observation" /><Inpatient value="5" description="Inpatient" /><CriticalCare value="6" description="Critical Care" /><ER value="7" description="ER" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider'
EXEC sys.sp_addextendedproperty @name=N'DocumentFaxElection', @value=N'<NoFax value="0" />
<AutoFax value="1" />
<Prompt value="2" />
' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider'
EXEC sys.sp_addextendedproperty @name=N'iforeignkey', @value=N'UserPRM' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider'
EXEC sys.sp_addextendedproperty @name=N'ProviderLicense', @value=N'<None value="0" />
<EMR value="1" />
<PM value="2" />
<PRM value="3" />
' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider'
EXEC sys.sp_addextendedproperty @name=N'ProviderRoleID', @value=N'<Physician value="1" />
<OtherProvider value="2" />
<TestProvider value="3" />
' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider'
EXEC sys.sp_addextendedproperty @name=N'Replication.Cache.Required', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider'
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'!FK_Provider_Person' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider'
EXEC sys.sp_addextendedproperty @name=N'ROSOrder', @value=N'<HeadToToe value="0" />
<Alphabetical value="1" />
<UserDefined value="2" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider'
EXEC sys.sp_addextendedproperty @name=N'SignatureTypeId', @value=N'<None value="0" />
<Permanent value="1" />
<OncePerDay value="2" />
<OncePerLogin value="3" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_Provider'

ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_ProviderRoleID]  DEFAULT ((1)) FOR [ProviderRoleID]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_IsBillingProvider]  DEFAULT ((1)) FOR [IsBillingProvider]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_IsReferringProvider]  DEFAULT ((1)) FOR [IsReferringProvider]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_SignatureTypeId]  DEFAULT ((0)) FOR [SignatureTypeId]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_ReplicationAppointmentHours]  DEFAULT ((48)) FOR [ReplicationAppointmentHours]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_ReplicationRemovePatientHours]  DEFAULT ((48)) FOR [ReplicationRemovePatientHours]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_ReplicationAttach5mentSizeKB]  DEFAULT ((50)) FOR [ReplicationAttachmentSizeKB]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_AutoLearnCommonProblemPallet_1]  DEFAULT ((1)) FOR [AutoLearnCommonProblemPallet]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_EMCodeReminder]  DEFAULT ((1)) FOR [EMCodeReminder]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_ePrescribeWarning]  DEFAULT ((1)) FOR [ePrescribeWarning]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_PrintPrescriptionsOnCheckout]  DEFAULT ((1)) FOR [PrintPrescriptionsOnCheckout]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_DefaultListInFNC_1]  DEFAULT ((1)) FOR [DefaultListInFNC]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_ROSOrder_1]  DEFAULT ((0)) FOR [ROSOrder]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_RxThermalPrinter]  DEFAULT ((0)) FOR [RxThermalPrinter]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_MandatoryCosignature]  DEFAULT ((0)) FOR [MandatoryCosignature]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_PrescriptionSignatureSource]  DEFAULT ((0)) FOR [SupervisingPrescriptionSignatureSource]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_CanSignRx]  DEFAULT ((0)) FOR [CanSignRx]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_UsePSPE]  DEFAULT ((1)) FOR [UsePracticeSettingsBillingAddress]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_UsePracticeSettingsMaintenaceDrugCls]  DEFAULT ((0)) FOR [UsePracticeSettingsMaintenaceDrugCls]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_AutoLinkDxCpt_1]  DEFAULT ((0)) FOR [AutoLinkDxCpt]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_SuperbillStatusID]  DEFAULT ((0)) FOR [SuperbillStatusID]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_Consult]  DEFAULT ((0)) FOR [ConsultingProvider]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_UseLDM]  DEFAULT ((1)) FOR [UseLDM]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_AutoAddMedicationReport]  DEFAULT ((1)) FOR [AutoAddMedicationReport]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_DocumentFaxElection]  DEFAULT ((0)) FOR [DocumentFaxElection]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_AutoSendLabOrderMsgs_1]  DEFAULT ((0)) FOR [AutoSendLabOrderMsgs]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_UsePracticeSettingseRxDownloadSetting]  DEFAULT ((1)) FOR [UsePracticeSettingseRxDownloadSetting]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_AutoCheckNoteComplete]  DEFAULT ((0)) FOR [AutoCheckNoteComplete]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_DefaultCheckDischargePatient_1]  DEFAULT ((0)) FOR [DefaultCheckDischargePatient]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_DefaultCheckSendPrescriptions_1]  DEFAULT ((0)) FOR [DefaultCheckSendPrescriptions]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_DefaultCheckSendLabOrders_1]  DEFAULT ((0)) FOR [DefaultCheckSendLabOrders]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_AllowProcedureWithoutDiag]  DEFAULT ((0)) FOR [AllowProcedureWithoutDiag]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_SendCanelServiceOrderMessage]  DEFAULT ((0)) FOR [SendCanelServiceOrderMessage]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_UsePracticeSettingsPatientEmails]  DEFAULT ((1)) FOR [UsePracticeSettingsPatientEmails]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_ValidateBillingTime_1]  DEFAULT ((0)) FOR [ValidateBillingTime]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_AutoLinkingDingnosisProblem]  DEFAULT ((1)) FOR [AutoLinkingDiagnosisProblem]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [migtemp_Provider] ADD  CONSTRAINT [DF_Provider_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_Provider
INSERT [migtemp_Provider]([PersonUid],[Inactive],[ProviderRoleID],[IsBillingProvider],[IsReferringProvider],[FTE],[ProviderLicense],[DefaultProviderCareTypeUid],[DefaultServiceSiteUid],[FinancialCenterUid],[FeeScheduleUid],[SignatureTypeId],[ReplicationAppointmentHours],[ReplicationRemovePatientHours],[ReplicationAttachmentSizeKB],[AutoLearnCommonProblemPallet],[EMCodeReminder],[ePrescribeWarning],[PrintPrescriptionsOnCheckout],[DefaultListInFNC],[ROSOrder],[RxThermalPrinter],[ClinicCenterUid],[TranscriptionistUid],[SpecialtyUid],[ETIN],[EClaimSiteTaxID],[MandatoryCosignature],[SupervisingPrescriptionSignatureSource],[CanSignRx],[DefaultReviewerUid],[RxReportRdlUid],[ScheduleIIRxReportRdlUid],[MedicationReportLastRun],[UsePracticeSettingsBillingAddress],[UsePracticeSettingsMaintenaceDrugCls],[ClaimProviderCorporationUid],[Notes],[ExternalID],[AutoLinkDxCpt],[SuperbillStatusID],[ConsultingProvider],[AuthorizationGroupUid],[AuthorizationReviewerUid],[DrugScreeningCriteria],[UseLDM],[AutoAddMedicationReport],[EduFormAssociationUid],[PayToProviderCorporationUid],[Initials],[DocumentFaxElection],[RouteDocumentFaxErrorToUserUid],[DefaultCoverageTypeUid],[DefaultLabOrderTaskMsgRecvrUid],[AutoSendLabOrderMsgs],[UsePracticeSettingseRxDownloadSetting],[eRxDownloadSetting],[AutoCheckNoteComplete],[RoutePatientMessages],[DefaultCheckDischargePatient],[DefaultCheckSendPrescriptions],[DefaultCheckSendLabOrders],[AllowProcedureWithoutDiag],[RouteVisitBillingMessageToUserGroupUid],[RouteNUSBVisitBillingMessageToUserGroupUid],[SendCanelServiceOrderMessage],[UsePracticeSettingsPatientEmails],[PatientEmails],[ValidateBillingTime],[AprimaDataExchangeRegistrationLastUpdate],[AprimaDataExchangeProviderRegistrationUid],[DefaultEMPlaceofServiceID],[AutoLinkingDiagnosisProblem],[DefaultBillingProviderUid],[IdentityVerification],[CDSCatalogUid],[DiagnosisRangePlanUid],[UserDefined],[LastModifiedDate],[LastModifiedByUid])
SELECT [PersonUid],[Inactive],[ProviderRoleID],[IsBillingProvider],[IsReferringProvider],[FTE],[ProviderLicense],[DefaultProviderCareTypeUid],[DefaultServiceSiteUid],[FinancialCenterUid],[FeeScheduleUid],[SignatureTypeId],[ReplicationAppointmentHours],[ReplicationRemovePatientHours],[ReplicationAttachmentSizeKB],[AutoLearnCommonProblemPallet],[EMCodeReminder],[ePrescribeWarning],[PrintPrescriptionsOnCheckout],[DefaultListInFNC],[ROSOrder],[RxThermalPrinter],[ClinicCenterUid],[TranscriptionistUid],[SpecialtyUid],[ETIN],[EClaimSiteTaxID],[MandatoryCosignature],[SupervisingPrescriptionSignatureSource],[CanSignRx],[DefaultReviewerUid],[RxReportRdlUid],[ScheduleIIRxReportRdlUid],[MedicationReportLastRun],[UsePracticeSettingsBillingAddress],[UsePracticeSettingsMaintenaceDrugCls],[ClaimProviderCorporationUid],[Notes],[ExternalID],[AutoLinkDxCpt],[SuperbillStatusID],[ConsultingProvider],[AuthorizationGroupUid],[AuthorizationReviewerUid],[DrugScreeningCriteria],[UseLDM],[AutoAddMedicationReport],[EduFormAssociationUid],[PayToProviderCorporationUid],[Initials],[DocumentFaxElection],[RouteDocumentFaxErrorToUserUid],[DefaultCoverageTypeUid],[DefaultLabOrderTaskMsgRecvrUid],[AutoSendLabOrderMsgs],[UsePracticeSettingseRxDownloadSetting],[eRxDownloadSetting],[AutoCheckNoteComplete],CONVERT(nvarchar(max), [RoutePatientMessages]),[DefaultCheckDischargePatient],[DefaultCheckSendPrescriptions],[DefaultCheckSendLabOrders],[AllowProcedureWithoutDiag],[RouteVisitBillingMessageToUserGroupUid],[RouteNUSBVisitBillingMessageToUserGroupUid],[SendCanelServiceOrderMessage],[UsePracticeSettingsPatientEmails],CONVERT(nvarchar(max), [PatientEmails]),[ValidateBillingTime],[AprimaDataExchangeRegistrationLastUpdate],[AprimaDataExchangeProviderRegistrationUid],[DefaultEMPlaceofServiceID],[AutoLinkingDiagnosisProblem],[DefaultBillingProviderUid],CONVERT(nvarchar(max), [IdentityVerification]),[CDSCatalogUid],[DiagnosisRangePlanUid],[UserDefined],[LastModifiedDate],[LastModifiedByUid]
FROM [Provider]

DROP TABLE [Provider]

exec  sp_rename 'migtemp_Provider', 'Provider'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_ProviderDefaultSIG]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_ProviderDefaultSIG](
	[ProviderDefaultSIGUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[MedicationSIGUid] [uniqueidentifier] NOT NULL,
	[KdbConfigurationUid] [uniqueidentifier] NOT NULL,
	[FDB_MEDID] [int] NULL,
	[FDB_HIC_SEQN] [int] NULL,
	[ExternalID] [varchar](25) NULL,
	[Name] [varchar](100) NULL,
	[Notes] [varchar](max) NULL,
	[Inactive] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'oldname', @value=N'ProviderUid' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ProviderDefaultSIG', @level2type=N'COLUMN',@level2name=N'KdbConfigurationUid'
EXEC sys.sp_addextendedproperty @name=N'Replication.Provider', @value=N'FK_ProviderDefaultSIG_Provider' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_ProviderDefaultSIG'

ALTER TABLE [migtemp_ProviderDefaultSIG] ADD  CONSTRAINT [DF_ProviderDefaultSIG_ProviderDefaultSIGUid]  DEFAULT (newid()) FOR [ProviderDefaultSIGUid]
ALTER TABLE [migtemp_ProviderDefaultSIG] ADD  CONSTRAINT [DF_ProviderDefaultSIG_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [migtemp_ProviderDefaultSIG] ADD  CONSTRAINT [DF_ProviderDefaultSIG_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [migtemp_ProviderDefaultSIG] ADD  CONSTRAINT [DF_ProviderDefaultSIG_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_ProviderDefaultSIG
INSERT [migtemp_ProviderDefaultSIG]([ProviderDefaultSIGUid],[MedicationSIGUid],[KdbConfigurationUid],[FDB_MEDID],[FDB_HIC_SEQN],[ExternalID],[Name],[Notes],[Inactive],[UserDefined],[LastModifiedByUid],[LastModifiedDate])
SELECT [ProviderDefaultSIGUid],[MedicationSIGUid],[ProviderUid],[FDB_MEDID],[FDB_HIC_SEQN],[ExternalID],[Name],[Notes],[Inactive],[UserDefined],[LastModifiedByUid],[LastModifiedDate]
FROM [ProviderDefaultSIG]

DROP TABLE [ProviderDefaultSIG]

exec  sp_rename 'migtemp_ProviderDefaultSIG', 'ProviderDefaultSIG'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelAlternateAccountPeriod]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelAlternateAccountPeriod](
	[RelAlternateAccountPeriodUid] [uniqueidentifier] NOT NULL,
	[MasterAccountPeriodUid] [uniqueidentifier] NOT NULL,
	[AlternateAccountPeriodUid] [uniqueidentifier] NOT NULL,
	[TargetInsurancePlanUid] [uniqueidentifier] NOT NULL,
	[Note] [varchar](2000) NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]


ALTER TABLE [RelAlternateAccountPeriod] ADD  CONSTRAINT [DF_RelAlternateAccountPeriod_RelAlternateAccountPeriodUid]  DEFAULT (newid()) FOR [RelAlternateAccountPeriodUid]
ALTER TABLE [RelAlternateAccountPeriod] ADD  CONSTRAINT [DF_RelAlternateAccountPeriod_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelAttachmentGroup]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelAttachmentGroup](
	[RelAttachmentGroupUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[AttachmentGroupUid] [uniqueidentifier] NOT NULL,
	[PersonUid] [uniqueidentifier] NULL,
	[VisitUid] [uniqueidentifier] NULL,
	[AccountResponsiblePartyUid] [uniqueidentifier] NULL,
	[DepositUid] [uniqueidentifier] NULL,
	[ObservationOrderUid] [uniqueidentifier] NULL,
	[MessageUid] [uniqueidentifier] NULL,
	[PatientProcedureHistoryUid] [uniqueidentifier] NULL,
	[IncludeInSummary] [bit] NOT NULL,
	[Inactive] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[PatientProviderRelationshipUid] [uniqueidentifier] NULL,
	[PatientReferralUid] [uniqueidentifier] NULL,
	[PracticeFormUid] [uniqueidentifier] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.ForcedRelationships', @value=N'Attachment' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelAttachmentGroup', @level2type=N'COLUMN',@level2name=N'AttachmentGroupUid'
EXEC sys.sp_addextendedproperty @name=N'Replication.LimitContentSize', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelAttachmentGroup', @level2type=N'COLUMN',@level2name=N'AttachmentGroupUid'
EXEC sys.sp_addextendedproperty @name=N'Replication.LimitContentSizeSelectBy', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelAttachmentGroup', @level2type=N'COLUMN',@level2name=N'VisitUid'
EXEC sys.sp_addextendedproperty @name=N'Replication.LimitContentSizeSelectBy', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelAttachmentGroup', @level2type=N'COLUMN',@level2name=N'ObservationOrderUid'
EXEC sys.sp_addextendedproperty @name=N'Replication.LimitContentSizeSelectBy', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelAttachmentGroup', @level2type=N'COLUMN',@level2name=N'MessageUid'
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'{*FK_RelAttachmentGroup_Person,FK_RelAttachmentGroup_Visit,FK_RelAttachmentGroup_ObservationOrder,FK_RelAttachmentGroup_Message,FK_RelAttachmentGroup_AccountResponsibleParty,FK_MessageAA_RelAttachmentGroup}' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelAttachmentGroup'

ALTER TABLE [migtemp_RelAttachmentGroup] ADD  CONSTRAINT [DF_RelAttachment_RelAttachmentGroupUid]  DEFAULT (newid()) FOR [RelAttachmentGroupUid]
ALTER TABLE [migtemp_RelAttachmentGroup] ADD  CONSTRAINT [DF_RelAttachmentGroup_IncludeInSummary]  DEFAULT ((0)) FOR [IncludeInSummary]
ALTER TABLE [migtemp_RelAttachmentGroup] ADD  CONSTRAINT [DF_RelAttachment_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [migtemp_RelAttachmentGroup] ADD  CONSTRAINT [DF_RelAttachment_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_RelAttachmentGroup
INSERT [migtemp_RelAttachmentGroup]([RelAttachmentGroupUid],[AttachmentGroupUid],[PersonUid],[VisitUid],[AccountResponsiblePartyUid],[DepositUid],[ObservationOrderUid],[MessageUid],[IncludeInSummary],[Inactive],[LastModifiedByUid],[LastModifiedDate],[PatientProviderRelationshipUid],[PatientReferralUid],[PracticeFormUid])
SELECT [RelAttachmentGroupUid],[AttachmentGroupUid],[PersonUid],[VisitUid],[AccountResponsiblePartyUid],[DepositUid],[ObservationOrderUid],[MessageUid],[IncludeInSummary],[Inactive],[LastModifiedByUid],[LastModifiedDate],[PatientProviderRelationshipUid],[PatientReferralUid],[PracticeFormUid]
FROM [RelAttachmentGroup]

DROP TABLE [RelAttachmentGroup]

exec  sp_rename 'migtemp_RelAttachmentGroup', 'RelAttachmentGroup'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelCCSymptomHpi]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelCCSymptomHpi](
	[RelCCSymptomHpiUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[RelCCSymptomHpiCategoryUid] [uniqueidentifier] NOT NULL,
	[HpiUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[AgeGroupUid] [uniqueidentifier] NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[ProcedureUid] [uniqueidentifier] NULL,
	[ProcedurePerformed] [bit] NOT NULL,
	[DiagnosisCode9] [varchar](25) NULL,
	[DiagnosisCode10] [varchar](25) NULL,
	[DiagnosisDescription] [varchar](255) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[ClinicCenterOverride] [xml](CONTENT [dbo].[KdbOverride]) NULL,
	[ProviderOverride] [xml](CONTENT [dbo].[KdbOverride]) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Hpi id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpi', @level2type=N'COLUMN',@level2name=N'HpiUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'sequence' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpi', @level2type=N'COLUMN',@level2name=N'DisplayOrder'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'age group 1: adult; 2: child < 18' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpi', @level2type=N'COLUMN',@level2name=N'AgeGroupUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'HPI description list of the CC symptom' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpi'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpi'

ALTER TABLE [migtemp_RelCCSymptomHpi] ADD  CONSTRAINT [DF_RelCCSymptomHpi_RelCCSymptomHpiUid]  DEFAULT (newid()) FOR [RelCCSymptomHpiUid]
ALTER TABLE [migtemp_RelCCSymptomHpi] ADD  CONSTRAINT [DF_RelCCSymptomHpi_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [migtemp_RelCCSymptomHpi] ADD  CONSTRAINT [DF_RelCCSymptomHpi_ProcedurePerformed_1]  DEFAULT ((1)) FOR [ProcedurePerformed]
ALTER TABLE [migtemp_RelCCSymptomHpi] ADD  CONSTRAINT [DF_RelCCSymptomHpi_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [migtemp_RelCCSymptomHpi] ADD  CONSTRAINT [DF_RelCCSymptomHpi_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_RelCCSymptomHpi
INSERT [migtemp_RelCCSymptomHpi]([RelCCSymptomHpiUid],[RelCCSymptomHpiCategoryUid],[HpiUid],[DisplayOrder],[AgeGroupUid],[GenderUid],[SnomedConceptID],[DescriptionUid],[ProcedureUid],[ProcedurePerformed],[DiagnosisCode9],[DiagnosisCode10],[DiagnosisDescription],[UserDefined],[ClinicCenterOverride],[ProviderOverride],[LastModifiedByUid],[LastModifiedDate])
SELECT [RelCCSymptomHpiUid],[RelCCSymptomHpiCategoryUid],[HpiUid],[DisplayOrder],[AgeGroupUid],[GenderUid],[SnomedConceptID],[DescriptionUid],[ProcedureUid],[ProcedurePerformed],[DiagnosisCode9],[DiagnosisCode10],[DiagnosisDescription],[UserDefined],CONVERT(nvarchar(max), [ClinicCenterOverride]),CONVERT(nvarchar(max), [ProviderOverride]),[LastModifiedByUid],[LastModifiedDate]
FROM [RelCCSymptomHpi]

DROP TABLE [RelCCSymptomHpi]

exec  sp_rename 'migtemp_RelCCSymptomHpi', 'RelCCSymptomHpi'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelCCSymptomHpiCategory]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelCCSymptomHpiCategory](
	[RelCCSymptomHpiCategoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[RelCCSystemSymptomUid] [uniqueidentifier] NOT NULL,
	[HpiCategoryUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[AgeGroupUid] [uniqueidentifier] NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[UserDefined] [tinyint] NOT NULL,
	[NaturalLanguage] [varchar](100) NULL,
	[SingleSelect] [bit] NOT NULL,
	[ClinicCenterOverride] [xml](CONTENT [dbo].[KdbOverride]) NULL,
	[ProviderOverride] [xml](CONTENT [dbo].[KdbOverride]) NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpiCategory', @level2type=N'COLUMN',@level2name=N'HpiCategoryUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpiCategory', @level2type=N'COLUMN',@level2name=N'DisplayOrder'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpiCategory', @level2type=N'COLUMN',@level2name=N'AgeGroupUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpiCategory', @level2type=N'COLUMN',@level2name=N'UserDefined'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpiCategory', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpiCategory', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Hpi category list of the CC symptom' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpiCategory'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSymptomHpiCategory'

ALTER TABLE [migtemp_RelCCSymptomHpiCategory] ADD  CONSTRAINT [DF_RelCCSymptomHpiCategory_RelCCSymptomHpiCategoryUid]  DEFAULT (newid()) FOR [RelCCSymptomHpiCategoryUid]
ALTER TABLE [migtemp_RelCCSymptomHpiCategory] ADD  CONSTRAINT [DF_RelCCSymptomHpiCategory_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [migtemp_RelCCSymptomHpiCategory] ADD  CONSTRAINT [DF_RelCCSymptomHpiCategory_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [migtemp_RelCCSymptomHpiCategory] ADD  CONSTRAINT [DF_RelCCSymptomHpiCategory_SingleSelect_1]  DEFAULT ((0)) FOR [SingleSelect]
ALTER TABLE [migtemp_RelCCSymptomHpiCategory] ADD  CONSTRAINT [DF_RelCCSymptomHpiCategory_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_RelCCSymptomHpiCategory
INSERT [migtemp_RelCCSymptomHpiCategory]([RelCCSymptomHpiCategoryUid],[RelCCSystemSymptomUid],[HpiCategoryUid],[DisplayOrder],[AgeGroupUid],[GenderUid],[UserDefined],[NaturalLanguage],[SingleSelect],[ClinicCenterOverride],[ProviderOverride],[LastModifiedByUid],[LastModifiedDate])
SELECT [RelCCSymptomHpiCategoryUid],[RelCCSystemSymptomUid],[HpiCategoryUid],[DisplayOrder],[AgeGroupUid],[GenderUid],[UserDefined],[NaturalLanguage],[SingleSelect],CONVERT(nvarchar(max), [ClinicCenterOverride]),CONVERT(nvarchar(max), [ProviderOverride]),[LastModifiedByUid],[LastModifiedDate]
FROM [RelCCSymptomHpiCategory]

DROP TABLE [RelCCSymptomHpiCategory]

exec  sp_rename 'migtemp_RelCCSymptomHpiCategory', 'RelCCSymptomHpiCategory'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelCCSystemSymptom]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelCCSystemSymptom](
	[RelCCSystemSymptomUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[CCSystemUid] [uniqueidentifier] NOT NULL,
	[CCSymptomUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[AgeGroupUid] [uniqueidentifier] NULL,
	[Preposition] [varchar](25) NULL,
	[Inactive] [bit] NOT NULL,
	[ShortcutRelCCSystemSymptomUid] [uniqueidentifier] NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[DiagnosisCode9] [varchar](25) NULL,
	[DiagnosisCode10] [varchar](25) NULL,
	[DiagnosisDescription] [varchar](255) NULL,
	[ClinicCenterOverride] [xml](CONTENT [dbo].[KdbOverrideCC]) NULL,
	[ProviderOverride] [xml](CONTENT [dbo].[KdbOverrideCC]) NULL,
	[LicenseCode] [varchar](50) NULL,
	[UserDefined] [tinyint] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'System ID' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSystemSymptom', @level2type=N'COLUMN',@level2name=N'CCSystemUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Symptom ID' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSystemSymptom', @level2type=N'COLUMN',@level2name=N'CCSymptomUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Seq (Order)' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSystemSymptom', @level2type=N'COLUMN',@level2name=N'DisplayOrder'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Age Group (1: > 18yrs; 2: <= 18 yrs)' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSystemSymptom', @level2type=N'COLUMN',@level2name=N'AgeGroupUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify person id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSystemSymptom', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Last Modify Date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSystemSymptom', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'CC list associates with the body system' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSystemSymptom'
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelCCSystemSymptom'

ALTER TABLE [migtemp_RelCCSystemSymptom] ADD  CONSTRAINT [DF_RelCCSystemSymptom_RelCCSystemSymptomUid]  DEFAULT (newid()) FOR [RelCCSystemSymptomUid]
ALTER TABLE [migtemp_RelCCSystemSymptom] ADD  CONSTRAINT [DF_RelCCSystemSymptom_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [migtemp_RelCCSystemSymptom] ADD  CONSTRAINT [DF_RelCCSystemSymptom_Inactive]  DEFAULT ((0)) FOR [Inactive]
ALTER TABLE [migtemp_RelCCSystemSymptom] ADD  CONSTRAINT [DF_RelCCSystemSymptom_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [migtemp_RelCCSystemSymptom] ADD  CONSTRAINT [DF_RelCCSystemSymptom_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_RelCCSystemSymptom
INSERT [migtemp_RelCCSystemSymptom]([RelCCSystemSymptomUid],[CCSystemUid],[CCSymptomUid],[DisplayOrder],[AgeGroupUid],[Preposition],[Inactive],[ShortcutRelCCSystemSymptomUid],[SnomedConceptID],[DescriptionUid],[DiagnosisCode9],[DiagnosisCode10],[DiagnosisDescription],[ClinicCenterOverride],[ProviderOverride],[LicenseCode],[UserDefined],[LastModifiedByUid],[LastModifiedDate])
SELECT [RelCCSystemSymptomUid],[CCSystemUid],[CCSymptomUid],[DisplayOrder],[AgeGroupUid],[Preposition],[Inactive],[ShortcutRelCCSystemSymptomUid],[SnomedConceptID],[DescriptionUid],[DiagnosisCode9],[DiagnosisCode10],[DiagnosisDescription],CONVERT(nvarchar(max), [ClinicCenterOverride]),CONVERT(nvarchar(max), [ProviderOverride]),[LicenseCode],[UserDefined],[LastModifiedByUid],[LastModifiedDate]
FROM [RelCCSystemSymptom]

DROP TABLE [RelCCSystemSymptom]

exec  sp_rename 'migtemp_RelCCSystemSymptom', 'RelCCSystemSymptom'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelCP_CarePlan_CP_Goal]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelCP_CarePlan_CP_Goal](
	[RelCP_CarePlan_CP_GoalUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[CP_CarePlanUid] [uniqueidentifier] NOT NULL,
	[CP_GoalUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [nchar](10) NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelCP_CarePlan_CP_Goal'

ALTER TABLE [RelCP_CarePlan_CP_Goal] ADD  CONSTRAINT [DF_RelCP_CarePlan_CP_Goal_RelCP_CarePlan_CP_GoalUid]  DEFAULT (newid()) FOR [RelCP_CarePlan_CP_GoalUid]
ALTER TABLE [RelCP_CarePlan_CP_Goal] ADD  CONSTRAINT [DF_RelCP_CarePlan_CP_Goal_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN
IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[RelFormLayoutClinicalNoteType]') AND type in (N'U'))
ALTER TABLE [RelFormLayoutClinicalNoteType] ADD [Abbreviation] varchar(3) NULL 
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelOrderedProcedurePatientProcedureHistory]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelOrderedProcedurePatientProcedureHistory](
	[RelOrderedProcedurePatientProcedureHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientProcedureHistoryUid] [uniqueidentifier] NOT NULL,
	[VisitProcedureUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]


ALTER TABLE [RelOrderedProcedurePatientProcedureHistory] ADD  CONSTRAINT [DF_RelOrderedProcedurePatientProcedureHistory_RelOrderedProcedurePatientProcedureHistoryUid]  DEFAULT (newid()) FOR [RelOrderedProcedurePatientProcedureHistoryUid]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelPatientCP_Goal_PatientCP_HealthConcern]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelPatientCP_Goal_PatientCP_HealthConcern](
	[RelPatientCP_Goal_PatientCP_HealthConcernUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientCP_GoalHistoryUid] [uniqueidentifier] NOT NULL,
	[PatientCP_HealthConcernHistoryUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]


ALTER TABLE [RelPatientCP_Goal_PatientCP_HealthConcern] ADD  CONSTRAINT [DF_RelPatientCP_Goal_PatientCP_HealthConcern_RelPatientCP_Goal_PatientCP_HealthConcernUid]  DEFAULT (newid()) FOR [RelPatientCP_Goal_PatientCP_HealthConcernUid]
ALTER TABLE [RelPatientCP_Goal_PatientCP_HealthConcern] ADD  CONSTRAINT [DF_RelPatientCP_Goal_PatientCP_HealthConcern_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelPatientCP_Goal_PatientCP_Intervention]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelPatientCP_Goal_PatientCP_Intervention](
	[RelPatientCP_Goal_PatientCP_InterventionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientCP_GoalHistoryUid] [uniqueidentifier] NOT NULL,
	[PatientCP_InterventionHistoryUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]


ALTER TABLE [RelPatientCP_Goal_PatientCP_Intervention] ADD  CONSTRAINT [DF_RelPatientCP_Goal_PatientCP_Intervention_RelPatientCP_Goal_PatientCP_InterventionUid]  DEFAULT (newid()) FOR [RelPatientCP_Goal_PatientCP_InterventionUid]
ALTER TABLE [RelPatientCP_Goal_PatientCP_Intervention] ADD  CONSTRAINT [DF_RelPatientCP_Goal_PatientCP_Intervention_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelPatientCP_Goal_PatientProblemDiagnosis]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelPatientCP_Goal_PatientProblemDiagnosis](
	[RelPatientCP_Goal_PatientProblemDiagnosisUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientCP_GoalHistoryUid] [uniqueidentifier] NOT NULL,
	[PatientProblemDiagnosisHistoryUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]


ALTER TABLE [RelPatientCP_Goal_PatientProblemDiagnosis] ADD  CONSTRAINT [DF_RelPatientCP_Goal_PatientProblemDiagnosis_RelPatientCP_Goal_PatientProblemDiagnosisUid]  DEFAULT (newid()) FOR [RelPatientCP_Goal_PatientProblemDiagnosisUid]
ALTER TABLE [RelPatientCP_Goal_PatientProblemDiagnosis] ADD  CONSTRAINT [DF_RelPatientCP_Goal_PatientProblemDiagnosis_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelPatientCP_HealthConcern_ObservationItem]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelPatientCP_HealthConcern_ObservationItem](
	[RelPatientCP_HealthConcern_ObservationItemUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientCP_HealthConcernHistoryUid] [uniqueidentifier] NOT NULL,
	[ObservationItemUid] [uniqueidentifier] NOT NULL,
	[ObservationOrderUid] [uniqueidentifier] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]


ALTER TABLE [RelPatientCP_HealthConcern_ObservationItem] ADD  CONSTRAINT [DF_RelPatientCP_HealthConcern_ObservationItem_RelPatientCP_HealthConcern_ObservationItemUid]  DEFAULT (newid()) FOR [RelPatientCP_HealthConcern_ObservationItemUid]
ALTER TABLE [RelPatientCP_HealthConcern_ObservationItem] ADD  CONSTRAINT [DF_RelPatientCP_HealthConcern_ObservationItem_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelPatientCP_HealthConcern_PatientHistory]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelPatientCP_HealthConcern_PatientHistory](
	[RelPatientCP_HealthConcern_PatientHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientCP_HealthConcernHistoryUid] [uniqueidentifier] NOT NULL,
	[PatientHistoryDetailUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]


ALTER TABLE [RelPatientCP_HealthConcern_PatientHistory] ADD  CONSTRAINT [DF_RelPatientCP_HealthConcern_PatientHistory_RelPatientCP_HealthConcern_PatientHistoryUid]  DEFAULT (newid()) FOR [RelPatientCP_HealthConcern_PatientHistoryUid]
ALTER TABLE [RelPatientCP_HealthConcern_PatientHistory] ADD  CONSTRAINT [DF_RelPatientCP_HealthConcern_PatientHistory_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelPatientCP_HealthConcern_PatientProblemDiagnosis]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelPatientCP_HealthConcern_PatientProblemDiagnosis](
	[RelPatientCP_HealthConcern_PatientProblemDiagnosisUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientCP_HealthConcernHistoryUid] [uniqueidentifier] NOT NULL,
	[PatientProblemDiagnosisHistoryUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]


ALTER TABLE [RelPatientCP_HealthConcern_PatientProblemDiagnosis] ADD  CONSTRAINT [DF_RelPatientCP_HealthConcern_PatientProblemDiagnosis_RelPatientCP_HealthConcern_PatientProblemDiagnosisUid]  DEFAULT (newid()) FOR [RelPatientCP_HealthConcern_PatientProblemDiagnosisUid]
ALTER TABLE [RelPatientCP_HealthConcern_PatientProblemDiagnosis] ADD  CONSTRAINT [DF_RelPatientCP_HealthConcern_PatientProblemDiagnosis_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Inactive' , N'SCHEMA',N'dbo', N'TABLE',N'RelPatientProgramPersonWeb', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Inactive' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelPatientProgramPersonWeb'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'RelPatientProgramPersonWeb', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.EMRAdminTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelPatientProgramPersonWeb'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Inactive' , N'SCHEMA',N'dbo', N'TABLE',N'RelPatientProgramPersonWeb', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Inactive', @value=N'<False value="0" /><True value="1" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelPatientProgramPersonWeb'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'RelPatientProgramPersonWeb', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelPatientProgramPersonWeb'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverReplicate' , N'SCHEMA',N'dbo', N'TABLE',N'RelPatientProgramPersonWeb', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelPatientProgramPersonWeb'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelPerformProcedurePatientProcedureHistory]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelPerformProcedurePatientProcedureHistory](
	[RelPerformProcedurePatientProcedureHistoryUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PatientProcedureHistoryUid] [uniqueidentifier] NOT NULL,
	[VisitProcedureUid] [uniqueidentifier] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]


ALTER TABLE [RelPerformProcedurePatientProcedureHistory] ADD  CONSTRAINT [DF_RelPerformProcedurePatientProcedureHistory_RelPerformProcedurePatientProcedureHistoryUid]  DEFAULT (newid()) FOR [RelPerformProcedurePatientProcedureHistoryUid]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RelPersonEthnicity]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[RelPersonEthnicity](
	[RelPersonEthnicityUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[PersonUid] [uniqueidentifier] NOT NULL,
	[EthnicityUid] [uniqueidentifier] NOT NULL,
	[DisplayOrder] [int] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NULL
) ON [PRIMARY]


ALTER TABLE [RelPersonEthnicity] ADD  CONSTRAINT [DF_RelPersonEthnicity_RelPersonEthnicityUid]  DEFAULT (newid()) FOR [RelPersonEthnicityUid]
ALTER TABLE [RelPersonEthnicity] ADD  CONSTRAINT [DF_RelPersonEthnicity2_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [RelPersonEthnicity] ADD  CONSTRAINT [DF_RelPersonEthnicity2_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_RelPETemplateDescription]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_RelPETemplateDescription](
	[RelPETemplateDescriptionUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[RelPETemplateSymptomUid] [uniqueidentifier] NOT NULL,
	[PEDescriptionUid] [uniqueidentifier] NOT NULL,
	[RelEMKeyComponentBulletUid] [uniqueidentifier] NULL,
	[DisplayOrder] [int] NOT NULL,
	[AgeGroupUid] [uniqueidentifier] NULL,
	[GenderUid] [uniqueidentifier] NULL,
	[NormalFlag] [bit] NOT NULL,
	[DefaultFlag] [bit] NOT NULL,
	[CountAsBullet] [bit] NOT NULL,
	[UserDefined] [tinyint] NOT NULL,
	[ClinicCenterOverride] [xml](CONTENT [dbo].[KdbOverridePE]) NULL,
	[ProviderOverride] [xml](CONTENT [dbo].[KdbOverridePE]) NULL,
	[SnomedConceptID] [varchar](50) NULL,
	[DescriptionUid] [uniqueidentifier] NULL,
	[LifeLong] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_RelPETemplateDescription'

ALTER TABLE [migtemp_RelPETemplateDescription] ADD  CONSTRAINT [DF_RelPETemplateDescription_RelPETemplateDescriptionUid]  DEFAULT (newid()) FOR [RelPETemplateDescriptionUid]
ALTER TABLE [migtemp_RelPETemplateDescription] ADD  CONSTRAINT [DF_RelPETemplateDescription_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [migtemp_RelPETemplateDescription] ADD  CONSTRAINT [DF_RelPETemplateDescription_NormalFlag]  DEFAULT ((0)) FOR [NormalFlag]
ALTER TABLE [migtemp_RelPETemplateDescription] ADD  CONSTRAINT [DF_RelPETemplateDescription_DefaultFlag]  DEFAULT ((0)) FOR [DefaultFlag]
ALTER TABLE [migtemp_RelPETemplateDescription] ADD  CONSTRAINT [DF_RelPETemplateDescription_CountAsBullet]  DEFAULT ((1)) FOR [CountAsBullet]
ALTER TABLE [migtemp_RelPETemplateDescription] ADD  CONSTRAINT [DF_RelPETemplateDescription_UserDefined]  DEFAULT ((1)) FOR [UserDefined]
ALTER TABLE [migtemp_RelPETemplateDescription] ADD  CONSTRAINT [DF_RelPETemplateDescription_LifeLong]  DEFAULT ((0)) FOR [LifeLong]
ALTER TABLE [migtemp_RelPETemplateDescription] ADD  CONSTRAINT [DF_RelPETemplateDescription_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_RelPETemplateDescription
INSERT [migtemp_RelPETemplateDescription]([RelPETemplateDescriptionUid],[RelPETemplateSymptomUid],[PEDescriptionUid],[RelEMKeyComponentBulletUid],[DisplayOrder],[AgeGroupUid],[GenderUid],[NormalFlag],[DefaultFlag],[CountAsBullet],[UserDefined],[ClinicCenterOverride],[ProviderOverride],[SnomedConceptID],[DescriptionUid],[LifeLong],[LastModifiedByUid],[LastModifiedDate])
SELECT [RelPETemplateDescriptionUid],[RelPETemplateSymptomUid],[PEDescriptionUid],[RelEMKeyComponentBulletUid],[DisplayOrder],[AgeGroupUid],[GenderUid],[NormalFlag],[DefaultFlag],[CountAsBullet],[UserDefined],CONVERT(nvarchar(max), [ClinicCenterOverride]),CONVERT(nvarchar(max), [ProviderOverride]),[SnomedConceptID],[DescriptionUid],[LifeLong],[LastModifiedByUid],[LastModifiedDate]
FROM [RelPETemplateDescription]

DROP TABLE [RelPETemplateDescription]

exec  sp_rename 'migtemp_RelPETemplateDescription', 'RelPETemplateDescription'

exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Inactive' , N'SCHEMA',N'dbo', N'TABLE',N'RelServiceSitePersonWeb', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Inactive' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelServiceSitePersonWeb'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'RelServiceSitePersonWeb', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.EMRAdminTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelServiceSitePersonWeb'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Inactive' , N'SCHEMA',N'dbo', N'TABLE',N'RelServiceSitePersonWeb', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Inactive', @value=N'<False value="0" /><True value="1" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelServiceSitePersonWeb'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'RelServiceSitePersonWeb', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelServiceSitePersonWeb'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverReplicate' , N'SCHEMA',N'dbo', N'TABLE',N'RelServiceSitePersonWeb', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverReplicate', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'RelServiceSitePersonWeb'
GO
BEGIN TRAN
IF EXISTS (SELECT * FROM INFORMATION_SCHEMA.COLUMNS WHERE TABLE_NAME = 'SIGDetail' AND COLUMN_NAME = 'Frequency')
ALTER TABLE [SIGDetail]  ALTER COLUMN [Frequency] varchar(255) NULL 
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SMSReplyHistory]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[SMSReplyHistory](
	[SMSReplyHistoryUid] [uniqueidentifier] NOT NULL,
	[ListenerAqn] [varchar](512) NULL,
	[ListenerArgs] [varchar](max) NULL,
	[ToCountry] [varchar](32) NULL,
	[ToState] [varchar](5) NULL,
	[SmsMessageSid] [varchar](34) NULL,
	[NumMedia] [smallint] NOT NULL,
	[ToCity] [varchar](32) NULL,
	[FromZip] [varchar](32) NULL,
	[SmsSid] [varchar](34) NULL,
	[FromState] [varchar](32) NULL,
	[SmsStatus] [varchar](32) NULL,
	[FromCity] [varchar](32) NULL,
	[Body] [varchar](max) NULL,
	[FromCountry] [varchar](32) NULL,
	[ToNumber] [varchar](32) NULL,
	[ToZip] [varchar](32) NULL,
	[NumSegments] [smallint] NOT NULL,
	[MessageSid] [varchar](34) NULL,
	[AccountSid] [varchar](34) NULL,
	[FromNumber] [varchar](32) NULL,
	[ApiVersion] [varchar](32) NULL,
	[LastModifiedDate] [datetime] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]


ALTER TABLE [SMSReplyHistory] ADD  CONSTRAINT [DF_SMSReplyHistory_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SMSSendHistory]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[SMSSendHistory](
	[SMSSendHistoryUid] [uniqueidentifier] NOT NULL,
	[ListenerAqn] [varchar](512) NULL,
	[ListenerArgs] [varchar](max) NULL,
	[sid] [varchar](34) NULL,
	[account_sid] [varchar](34) NULL,
	[ToNumber] [varchar](32) NOT NULL,
	[FromNumber] [varchar](32) NOT NULL,
	[messaging_service_sid] [varchar](32) NULL,
	[body] [varchar](max) NOT NULL,
	[status] [varchar](100) NULL,
	[num_segments] [int] NOT NULL,
	[num_media] [int] NULL,
	[direction] [varchar](100) NULL,
	[version] [varchar](100) NULL,
	[error_code] [varchar](100) NULL,
	[error_message] [varchar](255) NULL,
	[uri] [varchar](255) NULL,
	[subresource_uris] [varchar](255) NULL,
	[date_created] [datetime] NOT NULL,
	[date_sent] [datetime] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL
) ON [PRIMARY]


ALTER TABLE [SMSSendHistory] ADD  CONSTRAINT [DF_SMSSendHistory_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'UserPRM', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UserPRM'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Cache.Required' , N'SCHEMA',N'dbo', N'TABLE',N'UserPRM', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.Cache.Required' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UserPRM'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'UserPRM', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.EMRAdminTable' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UserPRM'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.IgnoreConflictColumns' , N'SCHEMA',N'dbo', N'TABLE',N'UserPRM', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.IgnoreConflictColumns' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UserPRM'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Patient' , N'SCHEMA',N'dbo', N'TABLE',N'UserPRM', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.Patient' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UserPRM'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Provider' , N'SCHEMA',N'dbo', N'TABLE',N'UserPRM', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.Provider' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UserPRM'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'UserPRM', N'COLUMN',N'PersonUid'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UserPRM', @level2type=N'COLUMN',@level2name=N'PersonUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.BrokenRelationship' , N'SCHEMA',N'dbo', N'TABLE',N'UserPRM', N'COLUMN',N'DefaultProviderUid'))
EXEC sys.sp_dropextendedproperty @name=N'Replication.BrokenRelationship' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UserPRM', @level2type=N'COLUMN',@level2name=N'DefaultProviderUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'UserPRM', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Application users.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UserPRM'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Cache.Required' , N'SCHEMA',N'dbo', N'TABLE',N'UserPRM', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.Cache.Required', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UserPRM'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.EMRAdminTable' , N'SCHEMA',N'dbo', N'TABLE',N'UserPRM', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.EMRAdminTable', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UserPRM'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.IgnoreConflictColumns' , N'SCHEMA',N'dbo', N'TABLE',N'UserPRM', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.IgnoreConflictColumns', @value=N'Settings' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UserPRM'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Patient' , N'SCHEMA',N'dbo', N'TABLE',N'UserPRM', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'!FK_UserPRM_Person' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UserPRM'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Provider' , N'SCHEMA',N'dbo', N'TABLE',N'UserPRM', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.Provider', @value=N'!FK_UserPRM_Person' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UserPRM'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'UserPRM', N'COLUMN',N'PersonUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'UserUid' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UserPRM', @level2type=N'COLUMN',@level2name=N'PersonUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'LargeProperty' , N'SCHEMA',N'dbo', N'TABLE',N'UserPRM', N'COLUMN',N'Settings'))
EXEC sys.sp_addextendedproperty @name=N'LargeProperty', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UserPRM', @level2type=N'COLUMN',@level2name=N'Settings'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.BrokenRelationship' , N'SCHEMA',N'dbo', N'TABLE',N'UserPRM', N'COLUMN',N'DefaultProviderUid'))
EXEC sys.sp_addextendedproperty @name=N'Replication.BrokenRelationship', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'UserPRM', @level2type=N'COLUMN',@level2name=N'DefaultProviderUid'
GO
BEGIN TRAN
IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Visit]') AND type in (N'U'))
ALTER TABLE [Visit] ADD [IsEM] bit NOT NULL CONSTRAINT DF_Visit_IsEM DEFAULT ((0)) 
IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Visit]') AND type in (N'U'))
ALTER TABLE [Visit] ADD [HasPerformedProcedure] bit NOT NULL CONSTRAINT DF_Visit_HasPerformedProcedures DEFAULT ((0)) 
exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_VisitComplexity]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_VisitComplexity](
	[VisitUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[InsuranceChanged] [bit] NOT NULL,
	[AddressChanged] [bit] NOT NULL,
	[OtherInfo] [varchar](50) NULL,
	[PmhReviewed] [bit] NOT NULL,
	[FhReviewed] [bit] NOT NULL,
	[ShReviewed] [bit] NOT NULL,
	[PlaceCode] [varchar](10) NULL,
	[VisitTypeID] [int] NULL,
	[CategoryTypeID] [int] NULL,
	[TypeOfService] [smallint] NOT NULL,
	[LevelOfCare] [int] NULL,
	[CalculatedLevelOfService] [int] NOT NULL,
	[BasedOnTypeID] [smallint] NULL,
	[FaceToFaceTime] [int] NULL,
	[CounselingTime] [int] NULL,
	[PlaceOfServiceDetail] [smallint] NULL,
	[CounselingDescription] [varchar](max) NULL,
	[ConfirmTimeLevel] [int] NULL,
	[DocumentMdmDx1] [int] NULL,
	[DocumentMdmDx2] [int] NULL,
	[DocumentMdmDx3] [int] NULL,
	[DocumentMdmDx4] [int] NULL,
	[DocumentMdmDx5] [int] NULL,
	[DocumentMdmData1] [int] NULL,
	[DocumentMdmData2] [int] NULL,
	[DocumentMdmData3] [int] NULL,
	[DocumentMdmData4] [int] NULL,
	[DocumentMdmData5] [int] NULL,
	[DocumentMdmData6] [int] NULL,
	[DocumentMdmData7] [int] NULL,
	[DocumentMdmRisk] [int] NULL,
	[DocumentMdmSelect] [int] NULL,
	[DocumentMdmBasedOn] [smallint] NULL,
	[DocumenConfirmLevel] [int] NULL,
	[DocumentMdmPeComprehensive] [int] NULL,
	[HpiCount] [int] NULL,
	[MedicalChecked] [smallint] NULL,
	[InfectionChecked] [smallint] NULL,
	[SurgeryChecked] [smallint] NULL,
	[FamilyChecked] [smallint] NULL,
	[GeneticChecked] [smallint] NULL,
	[SocialChecked] [smallint] NULL,
	[MedicationChecked] [smallint] NULL,
	[FoodAllergyChecked] [smallint] NULL,
	[DrugAllergyChecked] [smallint] NULL,
	[EnvtAllergyChecked] [smallint] NULL,
	[ImmunizationChecked] [smallint] NULL,
	[SpecialtyQAChecked] [smallint] NULL,
	[MenstrualChecked] [smallint] NULL,
	[PregnancyChecked] [smallint] NULL,
	[ProblemDiagnosisChecked] [smallint] NULL,
	[VitalsChecked] [smallint] NULL,
	[TransitionOfCare] [bit] NULL,
	[HistoryManualLevel] [smallint] NULL,
	[PEManualLevel] [smallint] NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL,
	[CustomHistoryChecked] [xml] NULL,
	[IsNewNote] [bit] NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Hx CheckedFlag: 0: none; 1: checked; 2: modified; 3: checked + modified' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitComplexity', @level2type=N'COLUMN',@level2name=N'MedicalChecked'
EXEC sys.sp_addextendedproperty @name=N'BasedOnTypeID', @value=N'<None value="0" /><Time value="2" /><Documentation value="3" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitComplexity'
EXEC sys.sp_addextendedproperty @name=N'DocumentMdmBasedOn', @value=N'<None value="0" />
<Guideline value="1" />
<Selected value="2" />
' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitComplexity'
EXEC sys.sp_addextendedproperty @name=N'PlaceOfServiceDetail', @value=N'<None value="0" />
<DOM value="1" />
<ALF value="2" />
<AFC value="3" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitComplexity'
EXEC sys.sp_addextendedproperty @name=N'TypeOfService', @value=N'<None value="0" />
<OfficeNewPatient value="1" />
<OfficeEstablishedPatient value="2" />
<OfficeConsult value="3" />
<NursingFaclityInitial value="4" />
<NursingFaclitySubsequent value="5" />
<HospitalObervationInitial value="6" />
<HospitalObervationDischarge value="7" />
<HospitalObervationInpatient value="8" />
<HospitalInpatientInitial value="9" />
<HospitalInpatientSubsequent value="10" />
<HospitalInpatientDischarge value="11" />
<HospitalInpatientInpatient value="12" />
<HospitalInpatientConsultation value="13" />
<HospitalCriticalCareAdult value="14" />
<HospitalCriticalCarePediatric value="15" />
<HospitalCriticalCareNeonatal value="16" />
<HospitalERVisit value="17" />
<HospitalERAdvancedLifeSupport value="18" />
<HomeServicesNewPatient value="19" />
<HomeServicesEstablishedPatient value="20" />
<RestHomeNewPatient value="21" />
<RestHomeEstablishedPatient value="22" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitComplexity'

ALTER TABLE [migtemp_VisitComplexity] ADD  CONSTRAINT [DF_VisitComplexity_InsuranceChanged]  DEFAULT ((0)) FOR [InsuranceChanged]
ALTER TABLE [migtemp_VisitComplexity] ADD  CONSTRAINT [DF_VisitComplexity_AddressChanged]  DEFAULT ((0)) FOR [AddressChanged]
ALTER TABLE [migtemp_VisitComplexity] ADD  CONSTRAINT [DF_VisitComplexity_PmhReviewed]  DEFAULT ((0)) FOR [PmhReviewed]
ALTER TABLE [migtemp_VisitComplexity] ADD  CONSTRAINT [DF_VisitComplexity_FhReviewed]  DEFAULT ((0)) FOR [FhReviewed]
ALTER TABLE [migtemp_VisitComplexity] ADD  CONSTRAINT [DF_VisitComplexity_ShReviewed]  DEFAULT ((0)) FOR [ShReviewed]
ALTER TABLE [migtemp_VisitComplexity] ADD  CONSTRAINT [DF_VisitComplexity_TypeOfService]  DEFAULT ((0)) FOR [TypeOfService]
ALTER TABLE [migtemp_VisitComplexity] ADD  CONSTRAINT [DF_VisitComplexity_CalculatedLevelOfService]  DEFAULT ((0)) FOR [CalculatedLevelOfService]
ALTER TABLE [migtemp_VisitComplexity] ADD  CONSTRAINT [DF_VisitComplexity_PlaceOfServiceDetail]  DEFAULT ((0)) FOR [PlaceOfServiceDetail]
ALTER TABLE [migtemp_VisitComplexity] ADD  CONSTRAINT [DF_VisitComplexity_MedicalChecked]  DEFAULT ((0)) FOR [MedicalChecked]
ALTER TABLE [migtemp_VisitComplexity] ADD  CONSTRAINT [DF_VisitComplexity_InfectionChecked]  DEFAULT ((0)) FOR [InfectionChecked]
ALTER TABLE [migtemp_VisitComplexity] ADD  CONSTRAINT [DF_VisitComplexity_SurgeryChecked]  DEFAULT ((0)) FOR [SurgeryChecked]
ALTER TABLE [migtemp_VisitComplexity] ADD  CONSTRAINT [DF_VisitComplexity_FamilyChecked]  DEFAULT ((0)) FOR [FamilyChecked]
ALTER TABLE [migtemp_VisitComplexity] ADD  CONSTRAINT [DF_VisitComplexity_GeneticChecked]  DEFAULT ((0)) FOR [GeneticChecked]
ALTER TABLE [migtemp_VisitComplexity] ADD  CONSTRAINT [DF_VisitComplexity_SocialChecked]  DEFAULT ((0)) FOR [SocialChecked]
ALTER TABLE [migtemp_VisitComplexity] ADD  CONSTRAINT [DF_VisitComplexity_MedicationChecked]  DEFAULT ((0)) FOR [MedicationChecked]
ALTER TABLE [migtemp_VisitComplexity] ADD  CONSTRAINT [DF_VisitComplexity_AllergyChecked]  DEFAULT ((0)) FOR [FoodAllergyChecked]
ALTER TABLE [migtemp_VisitComplexity] ADD  CONSTRAINT [DF_VisitComplexity_DrugAllergyChecked]  DEFAULT ((0)) FOR [DrugAllergyChecked]
ALTER TABLE [migtemp_VisitComplexity] ADD  CONSTRAINT [DF_VisitComplexity_EnvtAllergyChecked]  DEFAULT ((0)) FOR [EnvtAllergyChecked]
ALTER TABLE [migtemp_VisitComplexity] ADD  CONSTRAINT [DF_VisitComplexity_ImmunizationChecked]  DEFAULT ((0)) FOR [ImmunizationChecked]
ALTER TABLE [migtemp_VisitComplexity] ADD  CONSTRAINT [DF_VisitComplexity_SpecialtyQAChecked]  DEFAULT ((0)) FOR [SpecialtyQAChecked]
ALTER TABLE [migtemp_VisitComplexity] ADD  CONSTRAINT [DF_VisitComplexity_MenstrualChecked]  DEFAULT ((0)) FOR [MenstrualChecked]
ALTER TABLE [migtemp_VisitComplexity] ADD  CONSTRAINT [DF_VisitComplexity_PregnancyChecked]  DEFAULT ((0)) FOR [PregnancyChecked]
ALTER TABLE [migtemp_VisitComplexity] ADD  CONSTRAINT [DF_VisitComplexity_ProblemDiagnosisChecked]  DEFAULT ((0)) FOR [ProblemDiagnosisChecked]
ALTER TABLE [migtemp_VisitComplexity] ADD  CONSTRAINT [DF_VisitComplexity_VitalsChecked]  DEFAULT ((0)) FOR [VitalsChecked]
ALTER TABLE [migtemp_VisitComplexity] ADD  CONSTRAINT [DF_VisitComplexity_HasBeenSeenByAnotherProvider]  DEFAULT ((0)) FOR [TransitionOfCare]
ALTER TABLE [migtemp_VisitComplexity] ADD  CONSTRAINT [DF_VisitComplexity_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_VisitComplexity
INSERT [migtemp_VisitComplexity]([VisitUid],[InsuranceChanged],[AddressChanged],[OtherInfo],[PmhReviewed],[FhReviewed],[ShReviewed],[PlaceCode],[VisitTypeID],[CategoryTypeID],[TypeOfService],[LevelOfCare],[CalculatedLevelOfService],[BasedOnTypeID],[FaceToFaceTime],[CounselingTime],[PlaceOfServiceDetail],[CounselingDescription],[ConfirmTimeLevel],[DocumentMdmDx1],[DocumentMdmDx2],[DocumentMdmDx3],[DocumentMdmDx4],[DocumentMdmDx5],[DocumentMdmData1],[DocumentMdmData2],[DocumentMdmData3],[DocumentMdmData4],[DocumentMdmData5],[DocumentMdmData6],[DocumentMdmData7],[DocumentMdmRisk],[DocumentMdmSelect],[DocumentMdmBasedOn],[DocumenConfirmLevel],[DocumentMdmPeComprehensive],[HpiCount],[MedicalChecked],[InfectionChecked],[SurgeryChecked],[FamilyChecked],[GeneticChecked],[SocialChecked],[MedicationChecked],[FoodAllergyChecked],[DrugAllergyChecked],[EnvtAllergyChecked],[ImmunizationChecked],[SpecialtyQAChecked],[MenstrualChecked],[PregnancyChecked],[ProblemDiagnosisChecked],[VitalsChecked],[TransitionOfCare],[LastModifiedByUid],[LastModifiedDate],[CustomHistoryChecked],[IsNewNote])
SELECT [VisitUid],[InsuranceChanged],[AddressChanged],[OtherInfo],[PmhReviewed],[FhReviewed],[ShReviewed],[PlaceCode],[VisitTypeID],[CategoryTypeID],[TypeOfService],[LevelOfCare],[CalculatedLevelOfService],[BasedOnTypeID],[FaceToFaceTime],[CounselingTime],[PlaceOfServiceDetail],[CounselingDescription],[ConfirmTimeLevel],[DocumentMdmDx1],[DocumentMdmDx2],[DocumentMdmDx3],[DocumentMdmDx4],[DocumentMdmDx5],[DocumentMdmData1],[DocumentMdmData2],[DocumentMdmData3],[DocumentMdmData4],[DocumentMdmData5],[DocumentMdmData6],[DocumentMdmData7],[DocumentMdmRisk],[DocumentMdmSelect],[DocumentMdmBasedOn],[DocumenConfirmLevel],[DocumentMdmPeComprehensive],[HpiCount],[MedicalChecked],[InfectionChecked],[SurgeryChecked],[FamilyChecked],[GeneticChecked],[SocialChecked],[MedicationChecked],[FoodAllergyChecked],[DrugAllergyChecked],[EnvtAllergyChecked],[ImmunizationChecked],[SpecialtyQAChecked],[MenstrualChecked],[PregnancyChecked],[ProblemDiagnosisChecked],[VitalsChecked],[TransitionOfCare],[LastModifiedByUid],[LastModifiedDate],CONVERT(nvarchar(max), [CustomHistoryChecked]),[IsNewNote]
FROM [VisitComplexity]

DROP TABLE [VisitComplexity]

exec  sp_rename 'migtemp_VisitComplexity', 'VisitComplexity'

exec sp_dropDF
COMMIT TRAN
GO

IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'IsApproved' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'IsApproved' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Patient' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', NULL,NULL))
EXEC sys.sp_dropextendedproperty @name=N'Replication.Patient' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', N'COLUMN',N'VisitCoSignUid'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign', @level2type=N'COLUMN',@level2name=N'VisitCoSignUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', N'COLUMN',N'VisitUid'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign', @level2type=N'COLUMN',@level2name=N'VisitUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.LimitContentSizeSelectBy' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', N'COLUMN',N'VisitUid'))
EXEC sys.sp_dropextendedproperty @name=N'Replication.LimitContentSizeSelectBy' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign', @level2type=N'COLUMN',@level2name=N'VisitUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', N'COLUMN',N'CosignUid'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign', @level2type=N'COLUMN',@level2name=N'CosignUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', N'COLUMN',N'CompletedUid'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign', @level2type=N'COLUMN',@level2name=N'CompletedUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverOverrideValueIfValueSet' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', N'COLUMN',N'CompletedUid'))
EXEC sys.sp_dropextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign', @level2type=N'COLUMN',@level2name=N'CompletedUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', N'COLUMN',N'Inactive'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign', @level2type=N'COLUMN',@level2name=N'Inactive'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', N'COLUMN',N'IsCompleted'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign', @level2type=N'COLUMN',@level2name=N'IsCompleted'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverOverrideValueIfValueSet' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', N'COLUMN',N'IsCompleted'))
EXEC sys.sp_dropextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign', @level2type=N'COLUMN',@level2name=N'IsCompleted'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', N'COLUMN',N'IsApproved'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign', @level2type=N'COLUMN',@level2name=N'IsApproved'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.LimitContentSizeSelectByValueOf' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', N'COLUMN',N'IsApproved'))
EXEC sys.sp_dropextendedproperty @name=N'Replication.LimitContentSizeSelectByValueOf' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign', @level2type=N'COLUMN',@level2name=N'IsApproved'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', N'COLUMN',N'IsMessage'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign', @level2type=N'COLUMN',@level2name=N'IsMessage'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', N'COLUMN',N'LastModifiedByUid'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
GO
IF  EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', N'COLUMN',N'LastModifiedDate'))
EXEC sys.sp_dropextendedproperty @name=N'MS_Description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'IsApproved' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'IsApproved', @value=N'<WaitingForApprove value="0" /><Approved value="1" /><WaitingForAttention value="2" description="waiting for completion" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Cosign visit note to other doctors' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.Patient' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.Patient', @value=N'FK_VisitCoSign_Visit' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', N'COLUMN',N'VisitCoSignUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'unique id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign', @level2type=N'COLUMN',@level2name=N'VisitCoSignUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', N'COLUMN',N'VisitUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'visit id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign', @level2type=N'COLUMN',@level2name=N'VisitUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.LimitContentSizeSelectBy' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', N'COLUMN',N'VisitUid'))
EXEC sys.sp_addextendedproperty @name=N'Replication.LimitContentSizeSelectBy', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign', @level2type=N'COLUMN',@level2name=N'VisitUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', N'COLUMN',N'CosignUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'cosign user id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign', @level2type=N'COLUMN',@level2name=N'CosignUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', N'COLUMN',N'CompletedUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'user id for completing the visit' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign', @level2type=N'COLUMN',@level2name=N'CompletedUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverOverrideValueIfValueSet' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', N'COLUMN',N'CompletedUid'))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign', @level2type=N'COLUMN',@level2name=N'CompletedUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', N'COLUMN',N'Inactive'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1 for inactive' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign', @level2type=N'COLUMN',@level2name=N'Inactive'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', N'COLUMN',N'IsCompleted'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Incomplete or complete note when forward the note' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign', @level2type=N'COLUMN',@level2name=N'IsCompleted'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverOverrideValueIfValueSet' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', N'COLUMN',N'IsCompleted'))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign', @level2type=N'COLUMN',@level2name=N'IsCompleted'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', N'COLUMN',N'IsApproved'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Approved: 0: waiting for approval, 1: approved; 2: waiting for attention' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign', @level2type=N'COLUMN',@level2name=N'IsApproved'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.LimitContentSizeSelectByValueOf' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', N'COLUMN',N'IsApproved'))
EXEC sys.sp_addextendedproperty @name=N'Replication.LimitContentSizeSelectByValueOf', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign', @level2type=N'COLUMN',@level2name=N'IsApproved'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverOverrideValueIfValueSet' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', N'COLUMN',N'IsApproved'))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSet', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign', @level2type=N'COLUMN',@level2name=N'IsApproved'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.NeverOverrideValueIfValueSetOverrideValue' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', N'COLUMN',N'IsApproved'))
EXEC sys.sp_addextendedproperty @name=N'Replication.NeverOverrideValueIfValueSetOverrideValue', @value=N'<OverrideValues ExcludedRangeCheck="true">
  <OverrideValue oldValue="1" newValue="0" />
  <OverrideValue oldValue="1" newValue="2" />
  <OverrideValue oldValue="2" newValue="0" />
</OverrideValues>' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign', @level2type=N'COLUMN',@level2name=N'IsApproved'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', N'COLUMN',N'IsMessage'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Send message to original provider' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign', @level2type=N'COLUMN',@level2name=N'IsMessage'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', N'COLUMN',N'LastModifiedByUid'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'last modify person id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_Description' , N'SCHEMA',N'dbo', N'TABLE',N'VisitCoSign', N'COLUMN',N'LastModifiedDate'))
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'last modify date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'VisitCoSign', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
GO
SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_VisitDiagnosis]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_VisitDiagnosis](
	[VisitDiagnosisUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[VisitUid] [uniqueidentifier] NOT NULL,
	[DiagnosisPanelUid] [uniqueidentifier] NULL,
	[ProblemGroupingUid] [uniqueidentifier] NULL,
	[PatientProblemDiagnosisHistoryUid] [uniqueidentifier] NULL,
	[Code] [varchar](25) NULL,
	[Code10] [varchar](25) NULL,
	[Name] [varchar](255) NULL,
	[Notes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL,
	[SnomedCTConceptId] [bigint] NULL,
	[FollowupFlag] [smallint] NULL,
	[VisitDiagnosisType] [smallint] NULL,
	[AddendumNotes] [varchar](max) NULL,
	[DSMAxis] [varchar](250) NULL,
	[DpnGroupUid] [uniqueidentifier] NULL,
	[DpnXml] [xml] NULL,
	[HccCommunityFactors] [decimal](4, 3) NULL,
	[LifeLong] [bit] NOT NULL,
	[SortToBottom] [bit] NOT NULL,
	[IsDelete] [bit] NOT NULL,
	[IsAddendum] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'visit id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis', @level2type=N'COLUMN',@level2name=N'VisitUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Used to indicate the related problem. A method in the busniess object can be used to get the related problem.' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis', @level2type=N'COLUMN',@level2name=N'ProblemGroupingUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=NULL , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis', @level2type=N'COLUMN',@level2name=N'Notes'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1:improve; 2:worsen; 3: unchange; 4: resolve' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis', @level2type=N'COLUMN',@level2name=N'FollowupFlag'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1 - Differential, 2 - PreOp, 3 - PostOp' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis', @level2type=N'COLUMN',@level2name=N'VisitDiagnosisType'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'mark 1 when user delete this record in complete note' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis', @level2type=N'COLUMN',@level2name=N'IsDelete'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'last modify person id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis', @level2type=N'COLUMN',@level2name=N'LastModifiedByUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'last modify date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'visit chart detail information for Diagnosis' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis'
EXEC sys.sp_addextendedproperty @name=N'VisitDiagnosisType', @value=N'<None value="0"/><Differential value="1" /><PreOp value="2"/><PostOp value="3" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitDiagnosis'

ALTER TABLE [migtemp_VisitDiagnosis] ADD  CONSTRAINT [DF_VisitDiagnosis_RowGuid]  DEFAULT (newid()) FOR [VisitDiagnosisUid]
ALTER TABLE [migtemp_VisitDiagnosis] ADD  CONSTRAINT [DF_VisitDiagnosis_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [migtemp_VisitDiagnosis] ADD  CONSTRAINT [DF_VisitDiagnosis_LifeLong]  DEFAULT ((0)) FOR [LifeLong]
ALTER TABLE [migtemp_VisitDiagnosis] ADD  CONSTRAINT [DF_VisitDiagnosis_SortToBottom]  DEFAULT ((0)) FOR [SortToBottom]
ALTER TABLE [migtemp_VisitDiagnosis] ADD  CONSTRAINT [DF_VisitDiagnosis_IsDelete]  DEFAULT ((0)) FOR [IsDelete]
ALTER TABLE [migtemp_VisitDiagnosis] ADD  CONSTRAINT [DF_VisitDiagnosis_IsAddendum]  DEFAULT ((0)) FOR [IsAddendum]
ALTER TABLE [migtemp_VisitDiagnosis] ADD  CONSTRAINT [DF_VisitDiagnosis_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_VisitDiagnosis
INSERT [migtemp_VisitDiagnosis]([VisitDiagnosisUid],[VisitUid],[DiagnosisPanelUid],[Code],[Code10],[Name],[Notes],[DisplayOrder],[SnomedCTConceptId],[FollowupFlag],[VisitDiagnosisType],[AddendumNotes],[DSMAxis],[DpnGroupUid],[DpnXml],[HccCommunityFactors],[LifeLong],[SortToBottom],[IsDelete],[IsAddendum],[LastModifiedByUid],[LastModifiedDate])
SELECT [VisitDiagnosisUid],[VisitUid],[DiagnosisPanelUid],[Code],[Code10],[Name],[Notes],[DisplayOrder],[SnomedCTConceptId],[FollowupFlag],[VisitDiagnosisType],[AddendumNotes],[DSMAxis],[DpnGroupUid],CONVERT(nvarchar(max), [DpnXml]),[HccCommunityFactors],[LifeLong],[SortToBottom],[IsDelete],[IsAddendum],[LastModifiedByUid],[LastModifiedDate]
FROM [VisitDiagnosis]

DROP TABLE [VisitDiagnosis]

exec  sp_rename 'migtemp_VisitDiagnosis', 'VisitDiagnosis'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_VisitPE]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_VisitPE](
	[VisitPEUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[VisitUid] [uniqueidentifier] NOT NULL,
	[PETemplateUid] [uniqueidentifier] NOT NULL,
	[PEParentSystemUid] [uniqueidentifier] NOT NULL,
	[PESystemUid] [uniqueidentifier] NOT NULL,
	[PESymptomUid] [uniqueidentifier] NOT NULL,
	[PEDescriptionUid] [uniqueidentifier] NOT NULL,
	[RelEMKeyComponentBulletUid] [uniqueidentifier] NULL,
	[PETemplateName] [varchar](100) NULL,
	[PEParentSystemName] [varchar](100) NULL,
	[PESystemName] [varchar](100) NULL,
	[PESymptomName] [varchar](100) NULL,
	[PEDescriptionName] [varchar](255) NULL,
	[IsPEParentSystemBilateral] [bit] NOT NULL,
	[IsPESystemBilateral] [bit] NOT NULL,
	[IsPESymptomBilateral] [bit] NOT NULL,
	[PESystemColorID] [smallint] NULL,
	[NormalFlag] [bit] NOT NULL,
	[FollowupFlag] [smallint] NULL,
	[PEParentSystemDisplayOrder] [int] NULL,
	[PESystemDisplayOrder] [int] NULL,
	[PESymptomDisplayOrder] [int] NULL,
	[PEDescriptionDisplayOrder] [int] NULL,
	[BilateralityValue] [smallint] NULL,
	[CountAsBullet] [bit] NULL,
	[LifeLong] [bit] NOT NULL,
	[Notes] [varchar](max) NULL,
	[AddendumNotes] [varchar](max) NULL,
	[IsDelete] [bit] NOT NULL,
	[IsAddendum] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'unique id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'VisitPEUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'visit id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'VisitUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'pe template id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'PETemplateUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'pe subsystem' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'PEParentSystemUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'pe system id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'PESystemUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'pe symptom id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'PESymptomUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'pe description id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'PEDescriptionUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'PE system' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'PEParentSystemName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'PE sub system' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'PESystemName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'PE finding' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'PESymptomName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'PE description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'PEDescriptionName'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1: blue; 2: black' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'PESystemColorID'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'normal flag: 1: normal; 0: abnormal' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'NormalFlag'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'1:improve; 2:worsen; 3: unchange; 4: resolve' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'FollowupFlag'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'PE description sequence' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'PEDescriptionDisplayOrder'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'Bilaterality values: 0 - not defined, 1 - left, 2 - right, 3 - bilateral' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'BilateralityValue'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'user comment on the description' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'Notes'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'mark 1 when user delete this record in complete note' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE', @level2type=N'COLUMN',@level2name=N'IsDelete'
EXEC sys.sp_addextendedproperty @name=N'BilateralityValue', @value=N'<NotDefined value="0" /><Left value="1" description="Left side of the patient" /><Right value="2" description="Right side of the patient" /><Bilateral value="3" description="Both sides of the patient" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'visit chart detail information for physical exam' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitPE'

ALTER TABLE [migtemp_VisitPE] ADD  CONSTRAINT [DF_VisitPE_RowGuid]  DEFAULT (newid()) FOR [VisitPEUid]
ALTER TABLE [migtemp_VisitPE] ADD  CONSTRAINT [DF_VisitPE_IsPEParentSystemBilateral]  DEFAULT ((0)) FOR [IsPEParentSystemBilateral]
ALTER TABLE [migtemp_VisitPE] ADD  CONSTRAINT [DF_VisitPE_IsPESystemBilateral]  DEFAULT ((0)) FOR [IsPESystemBilateral]
ALTER TABLE [migtemp_VisitPE] ADD  CONSTRAINT [DF_VisitPE_IsPESymptomBilateral]  DEFAULT ((0)) FOR [IsPESymptomBilateral]
ALTER TABLE [migtemp_VisitPE] ADD  CONSTRAINT [DF_VisitPE_PESystemColorID]  DEFAULT ((0)) FOR [PESystemColorID]
ALTER TABLE [migtemp_VisitPE] ADD  CONSTRAINT [DF_VisitPE_NormalFlag]  DEFAULT ((0)) FOR [NormalFlag]
ALTER TABLE [migtemp_VisitPE] ADD  CONSTRAINT [DF_VisitPE_BilateralityValue]  DEFAULT ((0)) FOR [BilateralityValue]
ALTER TABLE [migtemp_VisitPE] ADD  CONSTRAINT [DF_VisitPE_CountAsBullet]  DEFAULT ((1)) FOR [CountAsBullet]
ALTER TABLE [migtemp_VisitPE] ADD  CONSTRAINT [DF_VisitPE_LifeLong_1]  DEFAULT ((0)) FOR [LifeLong]
ALTER TABLE [migtemp_VisitPE] ADD  CONSTRAINT [DF_VisitPE_IsDeleted]  DEFAULT ((0)) FOR [IsDelete]
ALTER TABLE [migtemp_VisitPE] ADD  CONSTRAINT [DF_VisitPE_IsAddendum]  DEFAULT ((0)) FOR [IsAddendum]
ALTER TABLE [migtemp_VisitPE] ADD  CONSTRAINT [DF_VisitPE_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_VisitPE
INSERT [migtemp_VisitPE]([VisitPEUid],[VisitUid],[PETemplateUid],[PEParentSystemUid],[PESystemUid],[PESymptomUid],[PEDescriptionUid],[RelEMKeyComponentBulletUid],[PETemplateName],[PEParentSystemName],[PESystemName],[PESymptomName],[PEDescriptionName],[IsPEParentSystemBilateral],[IsPESystemBilateral],[IsPESymptomBilateral],[PESystemColorID],[NormalFlag],[FollowupFlag],[PEParentSystemDisplayOrder],[PESystemDisplayOrder],[PESymptomDisplayOrder],[PEDescriptionDisplayOrder],[BilateralityValue],[CountAsBullet],[LifeLong],[Notes],[AddendumNotes],[IsDelete],[IsAddendum],[LastModifiedByUid],[LastModifiedDate])
SELECT [VisitPEUid],[VisitUid],[PETemplateUid],[PEParentSystemUid],[PESystemUid],[PESymptomUid],[PEDescriptionUid],[RelEMKeyComponentBulletUid],[PETemplateName],[PEParentSystemName],[PESystemName],[PESymptomName],[PEDescriptionName],[IsPEParentSystemBilateral],[IsPESystemBilateral],[IsPESymptomBilateral],[PESystemColorID],[NormalFlag],[FollowupFlag],[PEParentSystemDisplayOrder],[PESystemDisplayOrder],[PESymptomDisplayOrder],[PEDescriptionDisplayOrder],[BilateralityValue],[CountAsBullet],[LifeLong],[Notes],[AddendumNotes],[IsDelete],[IsAddendum],[LastModifiedByUid],[LastModifiedDate]
FROM [VisitPE]

DROP TABLE [VisitPE]

exec  sp_rename 'migtemp_VisitPE', 'VisitPE'

exec sp_dropDF
COMMIT TRAN
GO

SET XACT_ABORT ON;
GO
BEGIN TRAN

IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_VisitProcedure]') AND type in (N'U'))BEGIN
SET ANSI_NULLS ON
SET QUOTED_IDENTIFIER ON
CREATE TABLE [dbo].[migtemp_VisitProcedure](
	[VisitProcedureUid] [uniqueidentifier] ROWGUIDCOL  NOT NULL,
	[VisitUid] [uniqueidentifier] NOT NULL,
	[ProcedureCategoryUid] [uniqueidentifier] NULL,
	[ProcedureUid] [uniqueidentifier] NOT NULL,
	[ProcedureModifier1Uid] [uniqueidentifier] NULL,
	[ProcedureModifier2Uid] [uniqueidentifier] NULL,
	[ProcedureModifier3Uid] [uniqueidentifier] NULL,
	[ProcedureModifier4Uid] [uniqueidentifier] NULL,
	[ProcedurePanelUid] [uniqueidentifier] NULL,
	[Code] [varchar](30) NULL,
	[Name] [varchar](255) NULL,
	[Notes] [varchar](max) NULL,
	[AddendumNotes] [varchar](max) NULL,
	[DisplayOrder] [int] NOT NULL,
	[Unit] [int] NULL,
	[PatientImmunizationUid] [uniqueidentifier] NULL,
	[IsPerformed] [bit] NOT NULL,
	[IsEM] [bit] NOT NULL,
	[IsDelete] [bit] NOT NULL,
	[IsAddendum] [bit] NOT NULL,
	[ServiceSiteTypeUid] [uniqueidentifier] NULL,
	[UserDefinedTemplateUid] [uniqueidentifier] NULL,
	[AddToHistoryGroupUid] [uniqueidentifier] NULL,
	[UserDefinedProcedureNoteText] [varchar](max) NULL,
	[UserDefinedProcedureNoteXml] [varchar](max) NULL,
	[GlobalPeriodDays] [int] NULL,
	[PQRIMeasureUid] [uniqueidentifier] NULL,
	[DpnGroupUid] [uniqueidentifier] NULL,
	[DpnXml] [xml] NULL,
	[DpnOrderActionSaveFlag] [bit] NOT NULL,
	[DpnOrderActionCompleteFlag] [bit] NOT NULL,
	[DpnOrderActionSendFlag] [bit] NOT NULL,
	[DpnOrderActionCloseFlag] [bit] NOT NULL,
	[ReimbursementRuleTriggerUid] [uniqueidentifier] NULL,
	[NegationReasonUid] [uniqueidentifier] NULL,
	[ReimbursementRuleDiagnosis] [bit] NOT NULL,
	[ReimbursementRuleOverride] [bit] NOT NULL,
	[BillStartTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[BillEndTime] [dbo].[PRMDateTimeUnconverted] NULL,
	[BillTransportOdoStart] [float] NULL,
	[BillTransportOdoEnd] [float] NULL,
	[BillOdometerXml] [xml] NULL,
	[BillTimeXml] [xml] NULL,
	[ABNStatusUid] [uniqueidentifier] NULL,
	[ABNEstimatedFee] [money] NOT NULL,
	[OrderInfo] [xml](CONTENT [dbo].[OrderInfoData]) NULL,
	[OrderAQNData] [xml] NULL,
	[SortToBottom] [bit] NOT NULL,
	[LastModifiedByUid] [uniqueidentifier] NULL,
	[LastModifiedDate] [datetime] NOT NULL
) ON [PRIMARY]

EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'unique id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitProcedure', @level2type=N'COLUMN',@level2name=N'VisitProcedureUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'visit id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitProcedure', @level2type=N'COLUMN',@level2name=N'VisitUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'CPT id' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitProcedure', @level2type=N'COLUMN',@level2name=N'ProcedureUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'user comment' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitProcedure', @level2type=N'COLUMN',@level2name=N'Notes'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'DisplayOrder' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitProcedure', @level2type=N'COLUMN',@level2name=N'DisplayOrder'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'number of times of  service' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitProcedure', @level2type=N'COLUMN',@level2name=N'Unit'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'waiting for spec: The table has been changed to PatientHistoryDetail' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitProcedure', @level2type=N'COLUMN',@level2name=N'PatientImmunizationUid'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'mark 1 when user delete this record in complete note' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitProcedure', @level2type=N'COLUMN',@level2name=N'IsDelete'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'last modify date' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitProcedure', @level2type=N'COLUMN',@level2name=N'LastModifiedDate'
EXEC sys.sp_addextendedproperty @name=N'MS_Description', @value=N'visit chart detail information for service perform' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'TABLE',@level1name=N'migtemp_VisitProcedure'

ALTER TABLE [migtemp_VisitProcedure] ADD  CONSTRAINT [DF_VisitProcedure_VisitProcedureUid]  DEFAULT (newid()) FOR [VisitProcedureUid]
ALTER TABLE [migtemp_VisitProcedure] ADD  CONSTRAINT [DF_VisitProcedure_DisplayOrder]  DEFAULT ((0)) FOR [DisplayOrder]
ALTER TABLE [migtemp_VisitProcedure] ADD  CONSTRAINT [DF_VisitProcedure_IsPerformed]  DEFAULT ((0)) FOR [IsPerformed]
ALTER TABLE [migtemp_VisitProcedure] ADD  CONSTRAINT [DF_VisitProcedure_IsEM_1]  DEFAULT ((0)) FOR [IsEM]
ALTER TABLE [migtemp_VisitProcedure] ADD  CONSTRAINT [DF_VisitProcedure_IsDeleted]  DEFAULT ((0)) FOR [IsDelete]
ALTER TABLE [migtemp_VisitProcedure] ADD  CONSTRAINT [DF_VisitProcedure_IsAddendum]  DEFAULT ((0)) FOR [IsAddendum]
ALTER TABLE [migtemp_VisitProcedure] ADD  CONSTRAINT [DF_VisitProcedure_DpnOrderActionSaveFlag]  DEFAULT ((0)) FOR [DpnOrderActionSaveFlag]
ALTER TABLE [migtemp_VisitProcedure] ADD  CONSTRAINT [DF_VisitProcedure_DpnOrderActionCompleteFlag]  DEFAULT ((0)) FOR [DpnOrderActionCompleteFlag]
ALTER TABLE [migtemp_VisitProcedure] ADD  CONSTRAINT [DF_VisitProcedure_DpnOrderActionSendFlag]  DEFAULT ((0)) FOR [DpnOrderActionSendFlag]
ALTER TABLE [migtemp_VisitProcedure] ADD  CONSTRAINT [DF_VisitProcedure_DpnOrderActionCloseFlag]  DEFAULT ((0)) FOR [DpnOrderActionCloseFlag]
ALTER TABLE [migtemp_VisitProcedure] ADD  CONSTRAINT [DF_VisitProcedure_ReimbursementRuleDiagnosis]  DEFAULT ((0)) FOR [ReimbursementRuleDiagnosis]
ALTER TABLE [migtemp_VisitProcedure] ADD  CONSTRAINT [DF_VisitProcedure_ReimbursementRuleOverride]  DEFAULT ((0)) FOR [ReimbursementRuleOverride]
ALTER TABLE [migtemp_VisitProcedure] ADD  CONSTRAINT [DF_VisitProcedure_ABNEstimatedFee]  DEFAULT ((0)) FOR [ABNEstimatedFee]
ALTER TABLE [migtemp_VisitProcedure] ADD  CONSTRAINT [DF_VisitProcedure_SortToBottom]  DEFAULT ((0)) FOR [SortToBottom]
ALTER TABLE [migtemp_VisitProcedure] ADD  CONSTRAINT [DF_VisitProcedure_LastModifiedDate]  DEFAULT (getutcdate()) FOR [LastModifiedDate]

END
Truncate Table migtemp_VisitProcedure
INSERT [migtemp_VisitProcedure]([VisitProcedureUid],[VisitUid],[ProcedureCategoryUid],[ProcedureUid],[ProcedureModifier1Uid],[ProcedureModifier2Uid],[ProcedureModifier3Uid],[ProcedureModifier4Uid],[ProcedurePanelUid],[Code],[Name],[Notes],[AddendumNotes],[DisplayOrder],[Unit],[PatientImmunizationUid],[IsPerformed],[IsEM],[IsDelete],[IsAddendum],[ServiceSiteTypeUid],[UserDefinedTemplateUid],[AddToHistoryGroupUid],[UserDefinedProcedureNoteText],[UserDefinedProcedureNoteXml],[GlobalPeriodDays],[PQRIMeasureUid],[DpnGroupUid],[DpnXml],[DpnOrderActionSaveFlag],[DpnOrderActionCompleteFlag],[DpnOrderActionSendFlag],[DpnOrderActionCloseFlag],[ReimbursementRuleTriggerUid],[NegationReasonUid],[ReimbursementRuleDiagnosis],[ReimbursementRuleOverride],[BillStartTime],[BillEndTime],[BillTransportOdoStart],[BillTransportOdoEnd],[BillOdometerXml],[BillTimeXml],[ABNStatusUid],[ABNEstimatedFee],[OrderInfo],[OrderAQNData],[SortToBottom],[LastModifiedByUid],[LastModifiedDate])
SELECT [VisitProcedureUid],[VisitUid],[ProcedureCategoryUid],[ProcedureUid],[ProcedureModifier1Uid],[ProcedureModifier2Uid],[ProcedureModifier3Uid],[ProcedureModifier4Uid],[ProcedurePanelUid],[Code],[Name],[Notes],[AddendumNotes],[DisplayOrder],[Unit],[PatientImmunizationUid],[IsPerformed],[IsEM],[IsDelete],[IsAddendum],[ServiceSiteTypeUid],[UserDefinedTemplateUid],[AddToHistoryGroupUid],[UserDefinedProcedureNoteText],[UserDefinedProcedureNoteXml],[GlobalPeriodDays],[PQRIMeasureUid],[DpnGroupUid],CONVERT(nvarchar(max), [DpnXml]),[DpnOrderActionSaveFlag],[DpnOrderActionCompleteFlag],[DpnOrderActionSendFlag],[DpnOrderActionCloseFlag],[ReimbursementRuleTriggerUid],[NegationReasonUid],[ReimbursementRuleDiagnosis],[ReimbursementRuleOverride],[BillStartTime],[BillEndTime],[BillTransportOdoStart],[BillTransportOdoEnd],CONVERT(nvarchar(max), [BillOdometerXml]),CONVERT(nvarchar(max), [BillTimeXml]),[ABNStatusUid],[ABNEstimatedFee],CONVERT(nvarchar(max), [OrderInfo]),CONVERT(nvarchar(max), [OrderAQNData]),[SortToBottom],[LastModifiedByUid],[LastModifiedDate]
FROM [VisitProcedure]

DROP TABLE [VisitProcedure]

exec  sp_rename 'migtemp_VisitProcedure', 'VisitProcedure'

exec sp_dropDF
COMMIT TRAN
GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Charge]') AND type in (N'U'))
DROP TABLE [Charge]
COMMIT TRAN

GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[CMSCodeXml]') AND type in (N'U'))
DROP TABLE [CMSCodeXml]
COMMIT TRAN

GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[Credit]') AND type in (N'U'))
DROP TABLE [Credit]
COMMIT TRAN

GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[CreditGroup]') AND type in (N'U'))
DROP TABLE [CreditGroup]
COMMIT TRAN

GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[CreditGroupPostBatch]') AND type in (N'U'))
DROP TABLE [CreditGroupPostBatch]
COMMIT TRAN

GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[CreditGroupPostQueue]') AND type in (N'U'))
DROP TABLE [CreditGroupPostQueue]
COMMIT TRAN

GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[decileTemp]') AND type in (N'U'))
DROP TABLE [decileTemp]
COMMIT TRAN

GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[PatientDXHistory]') AND type in (N'U'))
DROP TABLE [PatientDXHistory]
COMMIT TRAN

GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[PatientProblem]') AND type in (N'U'))
DROP TABLE [PatientProblem]
COMMIT TRAN

GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[PatientProblemDiagnosis]') AND type in (N'U'))
DROP TABLE [PatientProblemDiagnosis]
COMMIT TRAN

GO

BEGIN TRAN

IF EXISTS (SELECT * FROM sysobjects WHERE id = OBJECT_ID(N'[PatientProcedure]') AND type in (N'U'))
DROP TABLE [PatientProcedure]
COMMIT TRAN

GO


