-- Backup the ListReportRdl table so that we do not lose any reports
-- requested by Support
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[cus_ListReportRdl]') AND type in (N'U'))
	DROP TABLE [dbo].[cus_ListReportRdl]

SELECT * INTO cus_ListReportRdl FROM ListReportRdl
GO

-- clear out the Error Reports from the last version.
truncate table ErrorReport
GO
-- clear out the JobHistory
truncate table JobHistory
GO
-- clear out the SQLModuleUpdate from the last version.
IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SQLModuleUpdate]') AND type in (N'U'))
	truncate table SQLModuleUpdate
GO
-- delete the Hotfix rows (no longer used)
DELETE from ListProductParameter where ParameterName = 'Hotfix'
GO
-- reset the Weekly update rows to get the latest download.
delete from ListProductParameter where ParameterName like '%Updates'
delete from ListProductParameter where ParameterName = 'Update'
GO

---  Keep the items above regardless of the version of the db.

-- Bug #56559 - Back out change made to ListProductParameter to fix bug #55302
delete ListProductParameter where ProductParameterUid = 'B964EE63-45C4-4D4F-AE35-301564104514'
go

/*
	Bug 61425:Migration Error
	Cleans out cache tables for Financial Center Close during migration
	Good for all 2016 and 2018 migrations
	2017-12-19  BMR  Created
	20171219_Bug61425_ClearFinancialCloseTablesBeforeMigration.sql
*/
IF EXISTS(SELECT * FROM sys.tables WHERE Name = 'AR_ViewFinancialCenterClosingSummary_ObjectLinks')
	DELETE FROM AR_ViewFinancialCenterClosingSummary_ObjectLinks;
IF EXISTS(SELECT * FROM sys.tables WHERE Name = 'AR_ViewFinancialCenterClosingSummary_DepositsWithBalance')
	DELETE FROM AR_ViewFinancialCenterClosingSummary_DepositsWithBalance;
IF EXISTS(SELECT * FROM sys.tables WHERE Name = 'AR_ViewFinancialCenterClosingSummary_BatchInfo')
	DELETE FROM AR_ViewFinancialCenterClosingSummary_BatchInfo;
GO

-- lcordell 07/17/18 this table has an IDENTITY setting that cannot be migrated when the source DB is on
-- 2015 Patch 1 or 2015 Patch 2  it has static data that will be reloaded by this migration so just drop it here.
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IMO_ProblemIT_SearchQualifier]') AND type in (N'U'))
	DROP TABLE [dbo].[IMO_ProblemIT_SearchQualifier]

-- lcordell 12/04/18 a missing FK needs cleanup before migration.
update eRxOutBound set SubmitbyUid = null where SubmitbyUid not in (select PersonUid from UserPRM)
