-- NEED this UDF for this script
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EscapeXml]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[EscapeXml](@xml VARCHAR(MAX)) RETURNS VARCHAR(MAX) AS
BEGIN

	SET @xml = REPLACE(@xml, ''&'', ''&amp;'')
	SET @xml = REPLACE(@xml, ''>'', ''&gt;'')
	SET @xml = REPLACE(@xml, ''<'', ''&lt;'')
	SET @xml = REPLACE(@xml, ''"'', ''&quot;'')
	SET @xml = REPLACE(@xml, '''''''', ''&apos;'')
	RETURN @xml
END
' 
END
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Split]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[Split]
 (	@vcDelimitedString VARCHAR(max),
	@vcDelimiter VARCHAR(100) 
 )

RETURNS @tblArray TABLE
   (
	ElementID	smallint	IDENTITY(1,1),  --Array index
   	Element		varchar(1000)			--Array element contents
   )
AS
BEGIN

	DECLARE
	@siIndex	SMALLINT,
	@siStart		SMALLINT,
	@siDelSize	SMALLINT


	SET @siDelSize	= LEN(@vcDelimiter)
	--loop through source string and add elements to destination table array
	WHILE LEN(@vcDelimitedString) > 0
	BEGIN
		SET @siIndex = CHARINDEX(@vcDelimiter, @vcDelimitedString)
		IF @siIndex = 0
		BEGIN
			INSERT INTO @tblArray VALUES(@vcDelimitedString)
			BREAK
		END
		ELSE
		BEGIN
			INSERT INTO @tblArray VALUES(SUBSTRING(@vcDelimitedString, 1,@siIndex - 1))
			SET @siStart = @siIndex + @siDelSize
			SET @vcDelimitedString = SUBSTRING(@vcDelimitedString, @siStart , LEN(@vcDelimitedString) - @siStart + 1)
		END
	END

	RETURN
END
' 
END
GO

IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientProcedureHistory]') AND name = N'IX_PatientProcedureHistory_PatientProcedureUid')
CREATE NONCLUSTERED INDEX [IX_PatientProcedureHistory_PatientProcedureUid] ON [dbo].[PatientProcedureHistory]
(
	[PatientProcedureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
--
-- Index needed for bug #34484
--
/****** Object:  Index [IX_PatientProcedureHistory_PatientProcedureUid]    Script Date: 9/18/2017 10:29:30 AM ******/
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[PatientProcedureHistory]') AND name = N'IX_PatientProcedureHistory_PatientProcedureUid')
CREATE NONCLUSTERED INDEX [IX_PatientProcedureHistory_PatientProcedureUid] ON [dbo].[PatientProcedureHistory]
(
	[PatientProcedureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO


-- PART 1
-- Scenario 34484: Patient Procedure History
-- =========================================================================
-- Migrate Surgical History to the new tables PatientProcedure and 
-- PatientProcedureHistory.  Scenario 34484.
-- created 06/29/2015
-- 01/30/2017 - fixed bug #55131
-- 02/02/2017 - fixed bug #55252
-- =========================================================================
IF dbo.Replication_IsReplicatedDB() = 0
BEGIN
       -- STEP ONE - move Surgical History questions to ListProcedureHistoryTerm
    insert into ListProcedureHistoryTerm (ProcedureHistoryTermUid, Name, UserDefined, Inactive, HistoryGroupUid)
             
             select lq.QuestionUid, lq.Name, lq.UserDefined, lq.Inactive, lq.HistoryGroupUid from ListHistoryGroup lhg
             inner join ListQuestion lq on lq.HistoryGroupUid = lhg.HistoryGroupUid
              where (lhg.ResultsAQN = 'iMedica.Prm.Client.UI.PrmGeneralControls.FNC.ControlPatientProcedure'
                           or lhg.ResultsAQN = 'iMedica.Prm.Client.UI.PrmGeneralControls.FNC.ControlSurgicalHistory'
                           or lhg.ResultsAQN = 'iMedica.Prm.Client.UI.PrmGeneralControls.FNC.ControlPatientProcdureHxTab'
                           or lhg.ResultsAQN = 'iMedica.Prm.Client.UI.PrmGeneralControls.FNC.ControlProcedureHistory')
            and QuestionUid not in 
            (select ProcedureHistoryTermUid from ListProcedureHistoryTerm)
END
GO

IF dbo.Replication_IsReplicatedDB() = 0
BEGIN
	declare @ActiveDate Date
	declare @InactiveDate Date
	declare @RecordDateTime DateTime
	declare @DetailRecordDate DateTime
	declare @Notes varchar(max)
	declare @IsPatientInput bit
	declare @tempCnt int

	declare @PatientUid uniqueidentifier
	declare @PatientHistoryUid uniqueidentifier
	declare @VisitUid uniqueidentifier
	declare @HistoryGroupUid uniqueidentifier
	declare @ActiveStateUid uniqueidentifier
	declare @QuestionUid uniqueidentifier
	declare @ProcedureUid uniqueidentifier
	declare @IsDelete bit
	declare @LastModifiedDate datetime
	declare @LastModifiedByUid uniqueidentifier
	declare @AnswerName varchar(1024)
	declare @QuestionName varchar(1024)
	--declare @TermName varchar(1024)
	declare @ShortDescription varchar(1024)
	declare @Code varchar(1024)
	declare @AnswerTimeFrame xml
	declare @PerformDate DateTime

	-- STEP TWO - move PatientHistory and PatientHistoryDetail to the new tables PatientProcedure and PatientProcedureHistory

	DECLARE a_cursor CURSOR FAST_FORWARD FOR 
				select
				ph.PatientHistoryUid ,ph.PatientUid
				,ph.VisitUid ,ph.Notes
				,ph.ActiveDate ,ph.InactiveDate
				,ph.OriginCreateTime ,ph.IsPatientInput
				,ph.ActiveStateUid ,phd.QuestionUid
				,phd.AnswerName, phd.QuestionName
				,phd.AnswerTimeFrame
				,phd.RecordDateTime, ph.HistoryGroupUid
				,phd.LastModifiedDate ,phd.LastModifiedByUid
				from PatientHistory ph
					inner join PatientHistoryDetail phd on ph.HistoryGroupUid = '00000000-0000-0000-0000-000000000103'
					and ph.PatientHistoryUid = phd.PatientHistoryUid
					
	OPEN a_cursor
	FETCH NEXT FROM a_cursor INTO @PatientHistoryUid, @PatientUid, 
								@VisitUid, @Notes, 
								@ActiveDate, @InactiveDate,
								@RecordDateTime, @IsPatientInput,
								@ActiveStateUid, @QuestionUid,
								@AnswerName, @QuestionName,
								@AnswerTimeFrame,
								@DetailRecordDate, @HistoryGroupUid,
								@LastModifiedDate, @LastModifiedByUid

	WHILE (@@fetch_status <> -1)
	BEGIN
		IF (@@fetch_status <> -2)
		BEGIN
				-- fix bug #55131
				SET @tempCnt = 0
				if (@QuestionUid is null)
				begin
					set @QuestionUid = NEWID()
				end
				else begin
					SELECT @tempCnt = COUNT(*) FROM ListProcedureHistoryTerm WHERE ProcedureHistoryTermUid = @QuestionUid
				end

				if (@tempCnt = 0)
				begin
					insert into ListProcedureHistoryTerm (ProcedureHistoryTermUid, Name, UserDefined, Inactive, HistoryGroupUid)
						values
							(@QuestionUid, @QuestionName, 1, 0, @HistoryGroupUid)
				end

				SET @tempCnt = 0
				SELECT @tempCnt = COUNT(*) FROM PatientProcedure WHERE PatientProcedureUid = @PatientHistoryUid

				IF (@tempCnt = 0)
				BEGIN
					set @ProcedureUid = null
					set @Code = null
					set @ShortDescription = null

					if (@DetailRecordDate is null)
						set @DetailRecordDate = @RecordDateTime

					set @IsDelete = 0
					
					if (@InactiveDate is not null)
						set @IsDelete = 1

					set @PerformDate = null
					if (@AnswerTimeFrame is not null)
					begin
						SELECT @PerformDate = (SELECT n.x.value(N'FuzzyDate[1]', 'DateTime') as [FuzzyDate]
								FROM @AnswerTimeFrame.nodes(N'TimeFrame[1]') n(x))
					end

					if ((@AnswerName is not null) and (@AnswerTimeFrame is null))
						set @AnswerTimeFrame = '<TimeFrame><Answer>' + dbo.EscapeXml(@AnswerName) + '</Answer><Value>' + dbo.EscapeXml(@AnswerName) + 
									'</Value><TimeFrameUid>D6153566-DF35-42AE-8CBA-B36544C53133</TimeFrameUid></TimeFrame>'
					
					set @QuestionName = LTRIM(@QuestionName)

					if ((CHARINDEX(')', @QuestionName, 1) > 0) and (CHARINDEX('(', @QuestionName, 1) = 1))
						set @Code = RTRIM(LTRIM(SUBSTRING (@QuestionName, 2, CHARINDEX(')', @QuestionName, 1) - 2)))
					
					select @ProcedureUid = lp.ProcedureUid, @ShortDescription = lp.ShortDescription, @Code = Code 
						from ListProcedure lp 
						where lp.Code = @Code

					if (@ProcedureUid is null)
					BEGIN
						set @Code = null
						set @ShortDescription = null
					END

					INSERT INTO [PatientProcedure]
							   (
							   [PatientProcedureUid]
							   ,[ProcedureHistoryTermUid]
							   ,[PatientUid]
							   ,[Code]
							   ,[TermName]
							   ,[ShortDescription]
							   ,[VisitUid]
							   ,[HistoryGroupUid]
							   ,[ProcedureUid]
							   ,[PerformTimeFrame]
							   ,[PerformDate]
							   ,[ResultTimeFrame]
							   ,[IsDelete]
							   ,[Notes]
							   ,[RecordDateTime]
							   ,[ActiveDate]
							   ,[InactiveDate]
							   ,[IsPatientInput]
							   ,[LastModifiedByUid]
							   ,[LastModifiedDate]
							   )
						 VALUES
							   (
							   @PatientHistoryUid --<PatientProcedureHistoryUid, uniqueidentifier,>
							   ,@QuestionUid --<ProcedureHistoryItemUid, uniqueidentifier,>
							   ,@PatientUid --<PatientUid, uniqueidentifier,>
							   ,@Code  --<Code, varchar(255),>
							   ,@QuestionName --<TermName, varchar(255),>
							   ,@ShortDescription --<ShortDescription, varchar(255),>
							   ,@VisitUid --<VisitUid, uniqueidentifier,>
							   ,@HistoryGroupUid --<HistoryGroupUid, uniqueidentifier,>
							   ,@ProcedureUid --<ProcedureUid, uniqueidentifier,>
							   ,@AnswerTimeFrame --<PerformTimeFrame, xml ([dbo].[TimeFrame]),>
							   ,@PerformDate --<PerformDate , datetime>
							   ,null --<ResultTimeFrame, xml ([dbo].[TimeFrame]),>
							   ,@IsDelete --<IsDelete, bit,>
							   ,@Notes --<Notes, varchar(max),>
							   ,@DetailRecordDate --<RecordDateTime, datetime,>
							   ,@ActiveDate --<ActiveDate, date,>
							   ,@InactiveDate --<InactiveDate, date,>
							   ,@IsPatientInput --<IsPatientInput, bit,>
							   ,@LastModifiedByUid -- <LastModifiedByUid, uniqueidentifier,>
							   ,@LastModifiedDate --<LastModifiedDate, datetime,>
							   )
							   
					INSERT INTO [PatientProcedureHistory]
							   (
							   [PatientProcedureUid]
							   ,[ProcedureHistoryTermUid]
							   ,[PatientUid]
							   ,[Code]
							   ,[TermName]
							   ,[ShortDescription]
							   ,[VisitUid]
							   ,[HistoryGroupUid]
							   ,[ProcedureUid]
							   ,[PerformTimeFrame]
							   ,[ResultTimeFrame]
							   ,[IsDelete]
							   ,[Notes]
							   ,[RecordDateTime]
							   ,[ActiveDate]
							   ,[InactiveDate]
							   ,[IsPatientInput]
							   ,[LastModifiedByUid]
							   ,[LastModifiedDate]
							   )
						 VALUES
							   (
							   @PatientHistoryUid --<PatientProcedureHistoryUid, uniqueidentifier,>
							   ,@QuestionUid --<ProcedureHistoryItemUid, uniqueidentifier,>
							   ,@PatientUid --<PatientUid, uniqueidentifier,>
							   ,@Code  --<Code, varchar(255),>
							   ,@QuestionName --<TermName, varchar(255),>
							   ,@ShortDescription --<ShortDescription, varchar(255),>
							   ,@VisitUid --<VisitUid, uniqueidentifier,>
							   ,@HistoryGroupUid --<HistoryGroupUid, uniqueidentifier,>
							   ,@ProcedureUid --<ProcedureUid, uniqueidentifier,>
							   ,@AnswerTimeFrame --<PerformTimeFrame, xml ([dbo].[TimeFrame]),>
							   ,null --<ResultTimeFrame, xml ([dbo].[TimeFrame]),>
							   ,@IsDelete --<IsDelete, bit,>
							   ,@Notes --<Notes, varchar(max),>
							   ,@DetailRecordDate --<RecordDateTime, datetime,>
							   ,@ActiveDate --<ActiveDate, date,>
							   ,@InactiveDate --<InactiveDate, date,>
							   ,@IsPatientInput --<IsPatientInput, bit,>
							   ,@LastModifiedByUid -- <LastModifiedByUid, uniqueidentifier,>
							   ,@LastModifiedDate --<LastModifiedDate, datetime,>
							   )

				END
		END -- of IF (@@fetch_status <> -2)
		FETCH NEXT FROM a_cursor INTO @PatientHistoryUid, @PatientUid, 
								@VisitUid, @Notes, 
								@ActiveDate, @InactiveDate,
								@RecordDateTime, @IsPatientInput,
								@ActiveStateUid, @QuestionUid,
								@AnswerName, @QuestionName,
								@AnswerTimeFrame,
								@DetailRecordDate, @HistoryGroupUid,
								@LastModifiedDate, @LastModifiedByUid
									
	END -- of while...
	CLOSE a_cursor
	DEALLOCATE a_cursor


	update ListHistoryGroup set ResultsAQN = 'iMedica.Prm.Client.UI.PrmGeneralControls.FNC.ControlPatientProcdureHxTab', 
				CanAcceptCPT = 0, ClassTypeID = 19, DisplayTypeID = 1, AnswerGroupUid = null,
				AnswerHeader = null, QuestionHeader = null
			where HistoryGroupUid = '00000000-0000-0000-0000-000000000103'
END
GO
-- PART 1


-- PART 2
-- =========================================================================
-- Migrate Procedure History to the new tables PatientProcedure and 
-- PatientProcedureHistory.  Scenario 34484.
-- created 06/30/2015
-- 01/30/2017 - fixed bug #55131
-- 02/02/2017 - fixed bug #55252
-- =========================================================================
IF dbo.Replication_IsReplicatedDB() = 0
BEGIN

	declare @ActiveDate Date
	declare @InactiveDate Date
	declare @RecordDateTime DateTime
	declare @DetailRecordDate DateTime
	declare @Notes varchar(max)
	declare @IsPatientInput bit
	declare @tempCnt int

	declare @PatientUid uniqueidentifier
	declare @PatientHistoryUid uniqueidentifier
	declare @VisitUid uniqueidentifier
	declare @HistoryGroupUid uniqueidentifier
	declare @ActiveStateUid uniqueidentifier
	declare @QuestionUid uniqueidentifier
	declare @ProcedureUid uniqueidentifier
	declare @IsDelete bit
	declare @LastModifiedDate datetime
	declare @LastModifiedByUid uniqueidentifier
	declare @AnswerName varchar(1024)
	declare @QuestionName varchar(1024)
	--declare @TermName varchar(1024)
	declare @ShortDescription varchar(1024)
	declare @Code varchar(1024)
	declare @AnswerTimeFrame xml
	declare @PerformDate datetime

	DECLARE outer_cursor CURSOR FAST_FORWARD FOR
			select HistoryGroupUid 
			from ListHistoryGroup as lhg
				where lhg.UserDefined <> 0 
					and lhg.ResultsAQN = 'iMedica.Prm.Client.UI.PrmGeneralControls.FNC.ControlProcedureHistory'

	OPEN outer_cursor
	FETCH NEXT FROM outer_cursor INTO @HistoryGroupUid

	WHILE (@@fetch_status <> -1)
	BEGIN
		IF (@@fetch_status <> -2)
		BEGIN	
			-- move PatientHistory and PatientHistoryDetail to the new tables PatientProcedure and PatientProcedureHistory
			DECLARE a_cursor CURSOR FAST_FORWARD FOR 
						select
						ph.PatientHistoryUid ,ph.PatientUid
						,ph.VisitUid ,ph.Notes
						,ph.ActiveDate ,ph.InactiveDate
						,ph.OriginCreateTime ,ph.IsPatientInput
						,ph.ActiveStateUid ,phd.QuestionUid
						,phd.AnswerName, phd.QuestionName
						,phd.AnswerTimeFrame
						,phd.RecordDateTime, ph.HistoryGroupUid
						,phd.LastModifiedDate ,phd.LastModifiedByUid
						from PatientHistory ph
							inner join PatientHistoryDetail phd on ph.HistoryGroupUid = @HistoryGroupUid
							and ph.PatientHistoryUid = phd.PatientHistoryUid
					
			OPEN a_cursor
			FETCH NEXT FROM a_cursor INTO @PatientHistoryUid, @PatientUid, 
										@VisitUid, @Notes, 
										@ActiveDate, @InactiveDate,
										@RecordDateTime, @IsPatientInput,
										@ActiveStateUid, @QuestionUid,
										@AnswerName, @QuestionName,
										@AnswerTimeFrame,
										@DetailRecordDate, @HistoryGroupUid,
										@LastModifiedDate, @LastModifiedByUid

			WHILE (@@fetch_status <> -1)
			BEGIN
				IF (@@fetch_status <> -2)
				BEGIN
						-- fix bug #55131
						SET @tempCnt = 0
						if (@QuestionUid is null)
						begin
							set @QuestionUid = NEWID()
						end
						else begin
							SELECT @tempCnt = COUNT(*) FROM ListProcedureHistoryTerm WHERE ProcedureHistoryTermUid = @QuestionUid
						end

						if (@tempCnt = 0)
						begin
							insert into ListProcedureHistoryTerm (ProcedureHistoryTermUid, Name, UserDefined, Inactive, HistoryGroupUid)
								values
									(@QuestionUid, @QuestionName, 1, 0, @HistoryGroupUid)
						end

						SET @tempCnt = 0
						SELECT @tempCnt = COUNT(*) FROM PatientProcedure WHERE PatientProcedureUid = @PatientHistoryUid
		
						IF (@tempCnt = 0)
						BEGIN
							set @ProcedureUid = null
							set @Code = null
							set @ShortDescription = null

							if (@DetailRecordDate is null)
								set @DetailRecordDate = @RecordDateTime

							set @IsDelete = 0
					
							if (@InactiveDate is not null)
								set @IsDelete = 1
						
							set @PerformDate = null
							if (@AnswerTimeFrame is not null)
							begin
								SELECT @PerformDate = (SELECT n.x.value(N'FuzzyDate[1]', 'DateTime') as [FuzzyDate]
										FROM @AnswerTimeFrame.nodes(N'TimeFrame[1]') n(x))
							end

							if ((@AnswerName is not null) and (@AnswerTimeFrame is null))
								set @AnswerTimeFrame = '<TimeFrame><Answer>' + dbo.EscapeXml(@AnswerName) + '</Answer><Value>' + dbo.EscapeXml(@AnswerName) + 
										'</Value><TimeFrameUid>D6153566-DF35-42AE-8CBA-B36544C53133</TimeFrameUid></TimeFrame>'
					
							set @QuestionName = LTRIM(@QuestionName)

							if ((CHARINDEX(')', @QuestionName, 1) > 0) and (CHARINDEX('(', @QuestionName, 1) = 1))
								set @Code = RTRIM(LTRIM(SUBSTRING (@QuestionName, 2, CHARINDEX(')', @QuestionName, 1) - 2)))
					
							select @ProcedureUid = lp.ProcedureUid, @ShortDescription = lp.ShortDescription, @Code = Code 
								from ListProcedure lp 
								where lp.Code = @Code

							if (@ProcedureUid is null)
							BEGIN
								set @Code = null
								set @ShortDescription = null
							END
							--ELSE BEGIN
							--	set @QuestionName = @Name
							--END

							INSERT INTO [PatientProcedure]
									   (
									   [PatientProcedureUid]
									   ,[ProcedureHistoryTermUid]
									   ,[PatientUid]
									   ,[Code]
									   ,[TermName]
									   ,[ShortDescription]
									   ,[VisitUid]
									   ,[HistoryGroupUid]
									   ,[ProcedureUid]
									   ,[PerformTimeFrame]
									   ,[PerformDate]
									   ,[ResultTimeFrame]
									   ,[IsDelete]
									   ,[Notes]
									   ,[RecordDateTime]
									   ,[ActiveDate]
									   ,[InactiveDate]
									   ,[IsPatientInput]
									   ,[LastModifiedByUid]
									   ,[LastModifiedDate]
									   )
								 VALUES
									   (
									   @PatientHistoryUid --<PatientProcedureHistoryUid, uniqueidentifier,>
									   ,@QuestionUid --<ProcedureHistoryItemUid, uniqueidentifier,>
									   ,@PatientUid --<PatientUid, uniqueidentifier,>
									   ,@Code  --<Code, varchar(255),>
									   ,@QuestionName --<TermName, varchar(255),>
									   ,@ShortDescription --<ShortDescription, varchar(255),>
									   ,@VisitUid --<VisitUid, uniqueidentifier,>
									   ,@HistoryGroupUid --<HistoryGroupUid, uniqueidentifier,>
									   ,@ProcedureUid --<ProcedureUid, uniqueidentifier,>
									   ,@AnswerTimeFrame --<PerformTimeFrame, xml ([dbo].[TimeFrame]),>
									   ,@PerformDate --<PerformDate, datetime,>
									   ,null --<ResultTimeFrame, xml ([dbo].[TimeFrame]),>
									   ,@IsDelete --<IsDelete, bit,>
									   ,@Notes --<Notes, varchar(max),>
									   ,@DetailRecordDate --<RecordDateTime, datetime,>
									   ,@ActiveDate --<ActiveDate, date,>
									   ,@InactiveDate --<InactiveDate, date,>
									   ,@IsPatientInput --<IsPatientInput, bit,>
									   ,@LastModifiedByUid -- <LastModifiedByUid, uniqueidentifier,>
									   ,@LastModifiedDate --<LastModifiedDate, datetime,>
									   )
							   
							INSERT INTO [PatientProcedureHistory]
									   (
									   [PatientProcedureUid]
									   ,[ProcedureHistoryTermUid]
									   ,[PatientUid]
									   ,[Code]
									   ,[TermName]
									   ,[ShortDescription]
									   ,[VisitUid]
									   ,[HistoryGroupUid]
									   ,[ProcedureUid]
									   ,[PerformTimeFrame]
									   ,[ResultTimeFrame]
									   ,[IsDelete]
									   ,[Notes]
									   ,[RecordDateTime]
									   ,[ActiveDate]
									   ,[InactiveDate]
									   ,[IsPatientInput]
									   ,[LastModifiedByUid]
									   ,[LastModifiedDate]
									   )
								 VALUES
									   (
									   @PatientHistoryUid --<PatientProcedureHistoryUid, uniqueidentifier,>
									   ,@QuestionUid --<ProcedureHistoryItemUid, uniqueidentifier,>
									   ,@PatientUid --<PatientUid, uniqueidentifier,>
									   ,@Code  --<Code, varchar(255),>
									   ,@QuestionName --<TermName, varchar(255),>
									   ,@ShortDescription --<ShortDescription, varchar(255),>
									   ,@VisitUid --<VisitUid, uniqueidentifier,>
									   ,@HistoryGroupUid --<HistoryGroupUid, uniqueidentifier,>
									   ,@ProcedureUid --<ProcedureUid, uniqueidentifier,>
									   ,@AnswerTimeFrame --<PerformTimeFrame, xml ([dbo].[TimeFrame]),>
									   ,null --<ResultTimeFrame, xml ([dbo].[TimeFrame]),>
									   ,@IsDelete --<IsDelete, bit,>
									   ,@Notes --<Notes, varchar(max),>
									   ,@DetailRecordDate --<RecordDateTime, datetime,>
									   ,@ActiveDate --<ActiveDate, date,>
									   ,@InactiveDate --<InactiveDate, date,>
									   ,@IsPatientInput --<IsPatientInput, bit,>
									   ,@LastModifiedByUid -- <LastModifiedByUid, uniqueidentifier,>
									   ,@LastModifiedDate --<LastModifiedDate, datetime,>
									   )

						END
				END -- of a_cursor IF (@@fetch_status <> -2)
				FETCH NEXT FROM a_cursor INTO @PatientHistoryUid, @PatientUid, 
										@VisitUid, @Notes, 
										@ActiveDate, @InactiveDate,
										@RecordDateTime, @IsPatientInput,
										@ActiveStateUid, @QuestionUid,
										@AnswerName, @QuestionName,
										@AnswerTimeFrame,
										@DetailRecordDate, @HistoryGroupUid,
										@LastModifiedDate, @LastModifiedByUid
									
			END -- a_cursor of while...
			CLOSE a_cursor
			DEALLOCATE a_cursor
		
			update ListHistoryGroup set ResultsAQN = 'iMedica.Prm.Client.UI.PrmGeneralControls.FNC.ControlPatientProcdureHxTab', 
						CanAcceptCPT = 0, ClassTypeID = 19, DisplayTypeID = 1, AnswerGroupUid = null,
						AnswerHeader = null, QuestionHeader = null
					where HistoryGroupUid = @HistoryGroupUid
		
		END -- of outer_cursor IF (@@fetch_status <> -2)
		
		FETCH NEXT FROM outer_cursor INTO @HistoryGroupUid
	END -- of  outer_cursor while...
	CLOSE outer_cursor
	DEALLOCATE outer_cursor
END
GO
-- Scenario 34484: Patient Procedure History
-- PART 2



-- 38805 
if exists(select * from sys.columns where Name = N'LicensedCPOCCMProfessional' and Object_ID = Object_ID(N'UserPrm'))
begin
    update UserPrm set LicensedCPOCCMProfessional = 1
    from provider pr 
        inner join userprm u on u.PersonUid = pr.PersonUid
        inner join person p on p.PersonUid = pr.PersonUid
end
GO

--/*	Scenario 39252 
--   Migration Script for Scenario 39252 - Ability to set custom paper claim layout on payer
--	Adds a ListClaimFormatValueType for each ListClaimFormLayout
--	Intended to be executed as Post Migration script ( can be either )
--	Can be executed multiple times ( reentrant ) without causing problems

--*/
--INSERT INTO ListClaimFormatValueType( ClaimFormatValueTypeUid, ExternalID, Name, Notes, IsPerProviderValue, IsPerFinancialCenterValue, Inactive, LastModifiedDate, LastModifiedByUid, ClaimFormatValueTypeTypeUid, UserDefined)
--	SELECT cfl.ClaimFormLayoutUid as ClaimFormatValueTypeUid, -- ClaimFormatValueTypeUid
--			cfl.ExternalID, -- ExternalID
--			cfl.Name, -- Name
--			cfl.Notes, -- Notes
--			0, -- IsPerProviderValue
--			0, -- IsPerFinancialCenterValue
--			0, -- Inactive
--			cfl.LastModifiedDate, -- LastModifiedDate
--			cfl.LastModifiedByUid, -- LastModifiedByUid
--			cft.ClaimFormatTypeUid, -- -- ListClaimFormatTypeUid for paper claims purposely set to ListClaimFormatValueType.ClaimFormatValueTypeTypeUid
--			0 -- UserDefined
--	FROM ListClaimFormLayout cfl
--		INNER JOIN ListClaimFormatType cft on cfl.ClaimFormatTypeUid = cft.ClaimFormatTypeUid
--													AND cft.IsPaper = 1
--		LEFT OUTER JOIN ListClaimFormatValueType cfvt on cfl.ClaimFormLayoutUid = cfvt.ClaimFormatValueTypeUid
--	WHERE cfvt.ClaimFormatValueTypeUid IS NULL
--GO

-- =========================================================================
-- Migration for TimeFrame "fuzzy date" to a Date type column. Task #41685
--
-- created 09/16/2015
-- =========================================================================
IF dbo.Replication_IsReplicatedDB() = 0
BEGIN
	update PatientFamilyHistory SET BirthDate =  (SELECT n.x.value(N'FuzzyDate[1]', 'Date') as [FuzzyDate]
													FROM BirthTimeFrame.nodes(N'TimeFrame[1]') n(x)),
								DeathDate = (SELECT n.x.value(N'FuzzyDate[1]', 'Date') as [FuzzyDate]
													FROM DeathTimeFrame.nodes(N'TimeFrame[1]') n(x))
END
GO
IF dbo.Replication_IsReplicatedDB() = 0
BEGIN
	update PatientHistoryDetail SET AnswerDate = (SELECT n.x.value(N'FuzzyDate[1]', 'Date') as [FuzzyDate]
														FROM AnswerTimeFrame.nodes(N'TimeFrame[1]') n(x))
END
GO
IF dbo.Replication_IsReplicatedDB() = 0
BEGIN
	update ImmunizationHistory SET HistoryAdministeredFuzzyDate = (SELECT n.x.value(N'FuzzyDate[1]', 'Date') as [FuzzyDate]
														FROM HistoryAdministeredDate.nodes(N'TimeFrame[1]') n(x))
END
GO


-- PART 3
-- =========================================================================
-- Post migration PatientProblems to new tables PatientProblemDiagnosis and 
-- PatientProblemDiagnosisHistory.  Scenario 40188.
--
-- created 07/27/2015
-- =========================================================================
IF dbo.Replication_IsReplicatedDB() = 0
BEGIN

	declare @PatientProblemUid uniqueidentifier
	declare @PatientProblemDiagnosisUid uniqueidentifier
	declare @PatientUid uniqueidentifier
	declare @Name varchar(1024)
	declare @VisitUid uniqueidentifier
	declare @DiseaseUid uniqueidentifier
	declare @ProblemStatusUid uniqueidentifier
	declare @ProviderUid uniqueidentifier
	declare @OnsetTimeFrame xml(CONTENT [dbo].[TimeFrame])
	declare @ResolvedTimeFrame xml(CONTENT [dbo].[TimeFrame])
	declare @IsDelete bit
	declare @IsAddendum bit
	declare @AddendumNotes varchar(MAX)
	declare @Notes varchar(MAX)
	declare @DisplayOrder int
	declare @RecordDateTime DateTime
	declare @ActiveDate Date
	declare @InactiveDate Date
	declare @IsPatientInput bit
	declare @LastModifiedByUid uniqueidentifier
	declare @LastModifiedDate DateTime

	declare @OnsetDate DateTime
	declare @ResolvedDate DateTime
	declare @tempCnt int
	declare @LastPatientUid uniqueidentifier
	declare @LastDiseaseUid uniqueidentifier

	set @tempCnt = 0;

	DECLARE a_cursor CURSOR FAST_FORWARD FOR 
			select PatientProblemUid, PatientUid, Name, VisitUid
				,DiseaseUid, ProblemStatusUid, ProviderUid, OnsetTimeFrame
				,ResolvedTimeFrame, IsDelete, IsAddendum, AddendumNotes
				,Notes, DisplayOrder, RecordDateTime, ActiveDate
				,InactiveDate, IsPatientInput, LastModifiedByUid, LastModifiedDate
			from PatientProblem pp
			order by pp.PatientUid, pp.DiseaseUid, pp.RecordDateTime desc, pp.ActiveDate desc, pp.InactiveDate desc, pp.LastModifiedDate desc
				
	OPEN a_cursor
	FETCH NEXT FROM a_cursor INTO @PatientProblemUid, @PatientUid, @Name, @VisitUid
				,@DiseaseUid, @ProblemStatusUid, @ProviderUid, @OnsetTimeFrame
				,@ResolvedTimeFrame, @IsDelete, @IsAddendum, @AddendumNotes
				,@Notes, @DisplayOrder, @RecordDateTime, @ActiveDate
				,@InactiveDate, @IsPatientInput, @LastModifiedByUid, @LastModifiedDate

	WHILE (@@fetch_status <> -1)
	BEGIN
		IF (@@fetch_status <> -2)
		BEGIN
	
			IF ((@LastPatientUid is null) or (@LastPatientUid <> @PatientUid))
			BEGIN
				SET @LastPatientUid = @PatientUid
				SET @LastDiseaseUid = null
			END
		
			SELECT @OnsetDate = (SELECT n.x.value(N'FuzzyDate[1]', 'DateTime') as [FuzzyDate]
								FROM @OnsetTimeFrame.nodes(N'TimeFrame[1]') n(x))
								
			SELECT @ResolvedDate = (SELECT n.x.value(N'FuzzyDate[1]', 'DateTime') as [FuzzyDate]
								FROM @ResolvedTimeFrame.nodes(N'TimeFrame[1]') n(x))

			SET @tempCnt = 0
			SELECT @tempCnt = COUNT(*) FROM PatientProblemDiagnosisHistory WHERE PatientProblemDiagnosisHistoryUid = @PatientProblemUid
	
			IF (@tempCnt = 0)
			BEGIN

				IF ((@LastDiseaseUid is null) or (@LastDiseaseUid <> @DiseaseUid))
				BEGIN
					SET @LastDiseaseUid = @DiseaseUid
					SET @PatientProblemDiagnosisUid = NEWID()
					INSERT INTO PatientProblemDiagnosis 
						(
							PatientProblemDiagnosisUid
							,PatientUid
							,Name
							,VisitUid
							,DiseaseUid
							,ProblemStatusUid
							,ProviderUid
							,OnsetTimeFrame
							,OnsetDate
							,ResolvedTimeFrame
							,ResolvedDate
							,IsDelete
							,IsPatientProblem
							,IsAddendum
							,AddendumNotes
							,Notes
							,DisplayOrder
							,RecordDateTime
							,ActiveDate
							,InactiveDate
							,SortDate
							,IsPatientInput
							,LastModifiedByUid
							,LastModifiedDate
						)
					VALUES
						(
							@PatientProblemDiagnosisUid
							,@PatientUid
							,@Name
							,@VisitUid
							,@DiseaseUid
							,@ProblemStatusUid
							,@ProviderUid
							,@OnsetTimeFrame
							,@OnsetDate
							,@ResolvedTimeFrame
							,@ResolvedDate
							,@IsDelete
							,1
							,@IsAddendum
							,@AddendumNotes
							,@Notes
							,@DisplayOrder
							,@RecordDateTime
							,@ActiveDate
							,@InactiveDate
							,@RecordDateTime
							,@IsPatientInput
							,@LastModifiedByUid
							,@LastModifiedDate
						)
				END -- IF (@LastDiseaseUid <> @DiseaseUid)
		
				INSERT INTO PatientProblemDiagnosisHistory 
					(
						PatientProblemDiagnosisHistoryUid
						,PatientProblemDiagnosisUid
						,PatientUid
						,Name
						,VisitUid
						,DiseaseUid
						,ProblemStatusUid
						,ProviderUid
						,OnsetTimeFrame
						,OnsetDate
						,ResolvedTimeFrame
						,ResolvedDate
						,IsDelete
						,IsPatientProblem
						,IsAddendum
						,AddendumNotes
						,Notes
						,DisplayOrder
						,RecordDateTime
						,ActiveDate
						,InactiveDate
						,SortDate
						,IsPatientInput
						,LastModifiedByUid
						,LastModifiedDate
					)
				VALUES
					(
						@PatientProblemUid
						,@PatientProblemDiagnosisUid
						,@PatientUid
						,@Name
						,@VisitUid
						,@DiseaseUid
						,@ProblemStatusUid
						,@ProviderUid
						,@OnsetTimeFrame
						,@OnsetDate
						,@ResolvedTimeFrame
						,@ResolvedDate
						,@IsDelete
						,1
						,@IsAddendum
						,@AddendumNotes
						,@Notes
						,@DisplayOrder
						,@RecordDateTime
						,@ActiveDate
						,@InactiveDate
						,@RecordDateTime
						,@IsPatientInput
						,@LastModifiedByUid
						,@LastModifiedDate
					)
		
			END -- of IF (@tempCnt = 0)
		END -- of IF (@@fetch_status <> -2)
		FETCH NEXT FROM a_cursor INTO @PatientProblemUid, @PatientUid, @Name, @VisitUid
					,@DiseaseUid, @ProblemStatusUid, @ProviderUid, @OnsetTimeFrame
					,@ResolvedTimeFrame, @IsDelete, @IsAddendum, @AddendumNotes
					,@Notes, @DisplayOrder, @RecordDateTime, @ActiveDate
					,@InactiveDate, @IsPatientInput, @LastModifiedByUid, @LastModifiedDate

	END -- of while...
	CLOSE a_cursor
	DEALLOCATE a_cursor

END -- of IF dbo.Replication_IsReplicatedDB() = 0
GO
-- PART 3


-- PART 4
-- =========================================================================
-- Post migration PatientDXHistory to new tables PatientProblemDiagnosis and 
-- PatientProblemDiagnosisHistory.  Scenario 40188.
--
-- created 07/27/2015
-- =========================================================================
IF dbo.Replication_IsReplicatedDB() = 0
BEGIN

	declare @PatientDXHistoryUid uniqueidentifier
	declare @PatientProblemDiagnosisUid uniqueidentifier
	declare @PatientUid uniqueidentifier
	declare @PatientProblemUid uniqueidentifier
	declare @NewPatientProblemUid uniqueidentifier
	declare @Name varchar(1024)
	declare @VisitUid uniqueidentifier
	declare @Code varchar(255)
	declare @Code10 varchar(255)
	declare @ProblemStatusUid uniqueidentifier
	declare @ProviderUid uniqueidentifier
	declare @OnsetTimeFrame xml(CONTENT [dbo].[TimeFrame])
	declare @ResolvedTimeFrame xml(CONTENT [dbo].[TimeFrame])
	declare @IsDelete bit
	declare @Notes varchar(MAX)
	declare @RecordDateTime DateTime
	declare @ActiveDate Date
	declare @InactiveDate Date
	declare @LastModifiedByUid uniqueidentifier
	declare @LastModifiedDate DateTime

	declare @OnsetDate DateTime
	declare @ResolvedDate DateTime
	declare @tempCnt int
	declare @tempCnt2 int
	declare @LastPatientUid uniqueidentifier
	declare @LastCode varchar(255)
	declare @LastCode10 varchar(255)

	set @tempCnt = 0;

	DECLARE a_cursor CURSOR FAST_FORWARD FOR 
			select pdh.PatientDXHistoryUid, pdh.PatientUid, pdh.Name, pdh.VisitUid
				,pdh.Code, pdh.Code10, pdh.ProblemStatusUid, pdh.ProviderUid, pdh.PatientProblemUid, pdh.OnsetTimeFrame
				,pdh.ResolvedTimeFrame, pdh.IsDelete
				,pdh.Notes, pdh.RecordDateTime, pdh.ActiveDate
				,pdh.InactiveDate, pdh.LastModifiedByUid, pdh.LastModifiedDate
			from PatientDXHistory pdh
			left join PatientProblemDiagnosisHistory ppdh ON ppdh.PatientProblemDiagnosisHistoryUid = pdh.PatientDXHistoryUid
			where ppdh.PatientProblemDiagnosisHistoryUid IS NULL
			order by pdh.PatientUid, pdh.Code, pdh.Code10, pdh.RecordDateTime desc, pdh.ActiveDate desc, pdh.InactiveDate desc, pdh.LastModifiedDate desc
				
	OPEN a_cursor
	FETCH NEXT FROM a_cursor INTO @PatientDXHistoryUid, @PatientUid, @Name, @VisitUid
				,@Code, @Code10, @ProblemStatusUid, @ProviderUid, @PatientProblemUid, @OnsetTimeFrame
				,@ResolvedTimeFrame, @IsDelete
				,@Notes, @RecordDateTime, @ActiveDate
				,@InactiveDate, @LastModifiedByUid, @LastModifiedDate

	WHILE (@@fetch_status <> -1)
	BEGIN
		IF (@@fetch_status <> -2)
		BEGIN
			IF ((@LastPatientUid is null) or (@LastPatientUid <> @PatientUid))
			BEGIN
				SET @LastPatientUid = @PatientUid
				SET @LastCode = null
				SET @LastCode10 = null
			END

			SELECT @OnsetDate = (SELECT n.x.value(N'FuzzyDate[1]', 'DateTime') as [FuzzyDate]
								FROM @OnsetTimeFrame.nodes(N'TimeFrame[1]') n(x))
								
			SELECT @ResolvedDate = (SELECT n.x.value(N'FuzzyDate[1]', 'DateTime') as [FuzzyDate]
								FROM @ResolvedTimeFrame.nodes(N'TimeFrame[1]') n(x))

			SET @tempCnt = 0
			SELECT @tempCnt = COUNT(*) FROM PatientProblemDiagnosisHistory WHERE PatientProblemDiagnosisHistoryUid = @PatientDXHistoryUid
			IF (@tempCnt = 0)
			BEGIN
				IF (
						((@Code is null) AND (@LastCode is null) AND (@Code10 is null) AND (@LastCode10 is null))
						OR
						((ISNULL(@Code, '') <> ISNULL(@LastCode, '')))
						OR			
						((ISNULL(@Code10, '') <> ISNULL(@LastCode10, '')))
					)
				BEGIN
					SET @LastCode = @Code
					SET @LastCode10 = @Code10
					SET @PatientProblemDiagnosisUid = NEWID()

					-- lookup new patient problem uid
					SET @NewPatientProblemUid = null
					SELECT @NewPatientProblemUid = PatientProblemDiagnosisUid FROM PatientProblemDiagnosisHistory
							WHERE PatientProblemDiagnosisHistoryUid = @PatientProblemUid

					INSERT INTO PatientProblemDiagnosis 
						(
							PatientProblemDiagnosisUid
							,PatientUid
							,Name
							,VisitUid
							,Code9
							,Code10
							,ProblemStatusUid
							,ProviderUid
							,PatientProblemUid
							,OnsetTimeFrame
							,OnsetDate
							,ResolvedTimeFrame
							,ResolvedDate
							,IsDelete
							,IsPatientProblem
							,IsAddendum
							,AddendumNotes
							,Notes
							,DisplayOrder
							,RecordDateTime
							,ActiveDate
							,InactiveDate
							,SortDate
							,IsPatientInput
							,LastModifiedByUid
							,LastModifiedDate
						)
					VALUES
						(
							@PatientProblemDiagnosisUid
							,@PatientUid
							,@Name
							,@VisitUid
							,@Code
							,@Code10
							,@ProblemStatusUid
							,@ProviderUid
							,@NewPatientProblemUid
							,@OnsetTimeFrame
							,@OnsetDate
							,@ResolvedTimeFrame
							,@ResolvedDate
							,@IsDelete
							,0
							,0
							,null
							,@Notes
							,0
							,@RecordDateTime
							,@ActiveDate
							,@InactiveDate
							,@RecordDateTime
							,0
							,@LastModifiedByUid
							,@LastModifiedDate
						)
				END 

				INSERT INTO PatientProblemDiagnosisHistory 
					(
						PatientProblemDiagnosisHistoryUid
						,PatientProblemDiagnosisUid
						,PatientUid
						,Name
						,VisitUid
						,Code9
						,Code10
						,ProblemStatusUid
						,ProviderUid
						,PatientProblemUid
						,OnsetTimeFrame
						,OnsetDate
						,ResolvedTimeFrame
						,ResolvedDate
						,IsDelete
						,IsPatientProblem
						,IsAddendum
						,AddendumNotes
						,Notes
						,DisplayOrder
						,RecordDateTime
						,ActiveDate
						,InactiveDate
						,SortDate
						,IsPatientInput
						,LastModifiedByUid
						,LastModifiedDate
					)
				VALUES
					(
						@PatientDXHistoryUid
						,@PatientProblemDiagnosisUid
						,@PatientUid
						,@Name
						,@VisitUid
						,@Code
						,@Code10
						,@ProblemStatusUid
						,@ProviderUid
						,@NewPatientProblemUid
						,@OnsetTimeFrame
						,@OnsetDate
						,@ResolvedTimeFrame
						,@ResolvedDate
						,@IsDelete
						,0
						,0
						,null
						,@Notes
						,0
						,@RecordDateTime
						,@ActiveDate
						,@InactiveDate
						,@RecordDateTime
						,0
						,@LastModifiedByUid
						,@LastModifiedDate
					)

			END -- of IF (@tempCnt = 0)
		END -- of IF (@@fetch_status <> -2)
	
		FETCH NEXT FROM a_cursor INTO @PatientDXHistoryUid, @PatientUid, @Name, @VisitUid
					,@Code, @Code10, @ProblemStatusUid, @ProviderUid, @PatientProblemUid, @OnsetTimeFrame
					,@ResolvedTimeFrame, @IsDelete
					,@Notes, @RecordDateTime, @ActiveDate
					,@InactiveDate, @LastModifiedByUid, @LastModifiedDate


	END -- of while...
	CLOSE a_cursor
	DEALLOCATE a_cursor

END -- of IF dbo.Replication_IsReplicatedDB() = 0
GO
-- PART 4



-- =========================================================================
-- Post migration for table "VisitDiagnosis"  Scenario 40188.
--
-- created 09/10/2015
-- fix for bug #56769
-- =========================================================================
IF dbo.Replication_IsReplicatedDB() = 0
BEGIN
	IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[cus_VisitDiagnosis]') AND type in (N'U'))
	BEGIN
		declare @sql nvarchar(4000)
		set @sql = 
		'update vd2 SET vd2.PatientProblemDiagnosisUid = (SELECT ppdh.PatientProblemDiagnosisUid FROM PatientProblemDiagnosisHistory ppdh
								WHERE ppdh.PatientProblemDiagnosisHistoryUid = vd1.PatientProblemUid)
			from VisitDiagnosis vd2 
				inner join cus_VisitDiagnosis vd1 on vd2.VisitDiagnosisUid = vd1.VisitDiagnosisUid
			where vd1.PatientProblemUid is not null
			and vd2.PatientProblemDiagnosisUid is null'
		exec sp_executesql @sql
	END

	update PatientProblemDiagnosisHistory set GroupingUid = PatientProblemDiagnosisHistoryUid
END
GO

--	 46328 Insert PatientCareManagementLog rows
IF dbo.Replication_IsReplicatedDB() = 0
AND (SELECT Count(*) FROM ListMisc WHERE MiscUid = '460B5360-40AD-4DEE-9C92-B4BD4EB0AFF8') = 0
BEGIN
INSERT INTO PatientCareManagementLog(PatientCareManagementLogUid,PatientUid,ProviderUid,LogDate,LogMinutes,LoggedFromMessageUid,LoggedFromVisitUid,IsApproved,IsCPO,IsCCM,Sent,Received,IntegrationPartnerUid,LastModifiedDate,LastModifiedByUid)
SELECT newid(), m.personuid, mt.CPOProviderUid, mt.CPODate, mt.cpominutes, mt.MessageUid, null, mt.CPOApproved, 1, 0, 0, 0, null, SYSDATETIME(), null
	FROM MessageTask mt
	LEFT JOIN [Message] m ON (m.Messageuid = mt.MessageUid)
	LEFT JOIN PatientCareManagement pcm ON (m.PersonUid = pcm.PatientUid)
		WHERE mt.CPOMinutes IS NOT NULL AND mt.CPODate is not null
			AND pcm.EffectiveDate <= mt.CPODate AND (pcm.ExpirationDate IS NULL OR pcm.EffectiveDate >= mt.CPODate)
			AND pcm.CareTypeUid = '928A4F18-FF1F-4BBA-90D9-66AEE2233C9A'

INSERT INTO ListMisc(MiscUid,Name,Val,DisplayOrder,ListType,LastModifiedByUid,LastModifiedDate,UserDefined)
	VALUES (
	'460B5360-40AD-4DEE-9C92-B4BD4EB0AFF8',
	'PatientCareManagementLog',
	'Migrated',
	0,
	'PatientCareManagementLog',
	null,
	SYSDATETIME(),
	0
	)
END
GO

--Migration script for task 47371, 47402
--Post script to copy data form temp table to RelPatientCondition
IF object_id('cus_RelPatientCondition') IS NOT NULL
BEGIN
	EXEC dbo.sp_executesql @statement = N'	      
		INSERT INTO RelPatientCondition SELECT * FROM cus_RelPatientCondition
		WHERE NOT EXISTS (SELECT rpc.PatientUid, rpc.PatientConditionUid from RelPatientCondition rpc WHERE PatientUid = rpc.PatientUid AND PatientConditionUid = rpc.PatientConditionUid)
	'
	drop table cus_RelPatientCondition
END
GO

-- 43435
if exists(select * from sys.tables where name = 'temp_tmpPersonEmployer')
begin
declare @count as int;
select @count = count(PersonEmployerUid) from temp_tmpPersonEmployer;
while (@count > 0)
Begin
 declare @PersonEmployerUid as uniqueidentifier, @occupationname as varchar(50), @occupationuid as uniqueidentifier;
	select top 1 @PersonEmployerUid = PersonEmployerUid, @occupationname = Occupation from temp_tmpPersonEmployer;
	set @count -= 1;
	if ( @occupationname is not null)
	begin
		if not exists(select * from ListOccupation where name = @occupationname)
		begin		
			insert into listoccupation(name)values(@occupationname);
		end 
		select @occupationuid = occupationuid from ListOccupation where name = @occupationname;
		update personemployer set OccupationUid = @occupationuid where PersonEmployerUid = @PersonEmployerUid;
	end
	delete top (1) from temp_tmpPersonEmployer where PersonEmployerUid = @PersonEmployerUid;
end
drop table temp_tmpPersonEmployer
end
GO

-- Bug 47591: Add Procedure Revenue Code Mapping Table
	IF NOT EXISTS ( SELECT * FROM MapSource WHERE MapSourceUid = 'A2D729F2-F416-4528-BE63-B27A0F95F001' )
	BEGIN
		Insert into MapSource( MapSourceUid, Name, FindTableFromUid, MapDirection, UserDefined, Notes, Inactive, LastModifiedDate)
		VALUES( 'A2D729F2-F416-4528-BE63-B27A0F95F001', 'RHC Legacy', '23C60022-225F-4FFE-AE7C-B0B3863CFBCF', 2, 0, 
				'Beginning on April 1, 2016, RHCs are required to report the appropriate HCPCS code' + CHAR(13)+CHAR(10) +
				'for each service line along with a revenue code on their Medicare claims. Services' + CHAR(13)+CHAR(10) +
				'furnished through March 31, 2016, should be billed without a HCPCS code under the' + + CHAR(13)+CHAR(10) +
				'previous guidelines.', 
				0, '2016-03-14 12:34:56.789')
	END
	CREATE TABLE #rCodes
	(
	  DisplayOrder		INT Identity,
	  ProcedureUid		UNIQUEIDENTIFIER,
	  Code				VARCHAR(30),
	  ShortDescription	VARCHAR(75),
	  RevenueCode		VARCHAR(10)
	)
	INSERT INTO #rCodes( ProcedureUid, Code, ShortDescription, RevenueCode)
		SELECT lp.ProcedureUid, lp.Code, lp.ShortDescription, lp.RevenueCode
		FROM ListProcedure lp WITH (NOLOCK)
		WHERE lp.RevenueCode IS NOT NULL
		ORDER BY Code asc

	INSERT INTO MapItem( MapItemUid, MapSourceUid, FindTableFromItemUid, MapItemFromName, SubstitutionText, DisplayOrder, UserDefined, Inactive, LastModifiedDate)
		SELECT newid(),'A2D729F2-F416-4528-BE63-B27A0F95F001', #rCodes.ProcedureUid, #rCodes.ShortDescription, #rCodes.RevenueCode,  #rCodes.DisplayOrder, 0, 0, GetDate()
		FROM #rCodes
				LEFT OUTER JOIN MapItem mi with (nolock) on #rCodes.ProcedureUid = mi.FindTableFromItemUid
		where mi.FindTableFromItemUid IS NULL
		
	drop table #rCodes
GO

-- 47416
IF EXISTS (
	SELECT TOP 1 *
	FROM [sys].[synonyms]
	WHERE [name] = 'VersionCommonFormulary'
)
BEGIN
	DECLARE @VersionCommonFormulary_TBL TABLE(
		[PRMVersion] [varchar](24),
		[PRMSeq] [int],
		[PRMBuild] [varchar](24)
	)

	INSERT @VersionCommonFormulary_TBL
	VALUES ('16.0.0', 2, 'Common')

	DECLARE @PharmacyClearinghouseUid [uniqueidentifier] = '118422AA-C165-4A2E-8389-E5B7E89636EA',
		@InterfaceDetailsXML [xml],
		@PRMVersion [varchar](24),
		@PRMSeq [int],
		@PRMBuild [varchar](24),
		@PRMVersion_DB [varchar](24),
		@PRMSeq_DB [int],
		@PRMBuild_DB [varchar](24),
		@Status [int] = 0,
		@UpdateDB [bit] = 0

	SELECT @PRMVersion_DB = vcf.[PRMVersion],
		@PRMSeq_DB = vcf.[PRMSeq],
		@PRMBuild_DB = vcf.[PRMBuild]
	FROM [VersionCommonFormulary] AS vcf
		INNER JOIN @VersionCommonFormulary_TBL AS vvcf ON vcf.[PRMVersion] >= vvcf.[PRMVersion]
			AND vcf.[PRMSeq] >= vvcf.[PRMSeq]
			AND vcf.[PRMBuild] >= vvcf.[PRMBuild]
	WHERE vcf.[Status] = @Status
	ORDER BY vcf.[LastModifiedDate] DESC

	IF @PRMVersion_DB IS NOT NULL
		AND  @PRMSeq_DB IS NOT NULL
		AND @PRMBuild_DB IS NOT NULL
	BEGIN
		SELECT @InterfaceDetailsXML = [InterfaceDetails]
		FROM [ListPharmacyClearinghouse]
		WHERE [PharmacyClearinghouseUid] = @PharmacyClearinghouseUid

		IF @InterfaceDetailsXML.exist ('root/VersionCommonFormulary') <> 0
		BEGIN
			SELECT @PRMVersion = COALESCE(x.n.value('@PRMVersion', '[varchar](24)'), '15.0.0'),
				@PRMSeq = COALESCE(x.n.value('@PRMSeq', '[int]'), 1),
				@PRMBuild = COALESCE(x.n.value('@PRMBuild', '[varchar](24)'), '15.0')
			FROM @InterfaceDetailsXML.nodes('root/VersionCommonFormulary') AS x(n)

			IF @PRMVersion <> @PRMVersion_DB
			BEGIN
				SET @InterfaceDetailsXML.modify('replace value of (root/VersionCommonFormulary)[1]/@PRMVersion with sql:variable("@PRMVersion_DB")')
				SET @UpdateDB = 1
			END

			IF @PRMSeq <> @PRMSeq_DB
			BEGIN
				SET @InterfaceDetailsXML.modify('replace value of (root/VersionCommonFormulary)[1]/@PRMSeq with sql:variable("@PRMSeq_DB")')
				SET @UpdateDB = 1
			END

			IF @PRMBuild <> @PRMBuild_DB
			BEGIN
				SET @InterfaceDetailsXML.modify('replace value of (root/VersionCommonFormulary)[1]/@PRMBuild with sql:variable("@PRMBuild_DB")')
				SET @UpdateDB = 1
			END
		END
		ELSE
		BEGIN
			DECLARE @VersionCommonFormulary [xml]

			SET @VersionCommonFormulary =
				(
					SELECT @PRMVersion_DB AS '@PRMVersion',
						@PRMSeq_DB AS '@PRMSeq',
						@PRMBuild_DB AS '@PRMBuild'
					FOR XML PATH ('VersionCommonFormulary')
				)

				IF @VersionCommonFormulary IS NOT NULL
				BEGIN
					SET @InterfaceDetailsXML.modify('insert sql:variable("@VersionCommonFormulary") as first into (root)[1]')
					SET @UpdateDB = 1
				END
		END

		IF @UpdateDB <> 0
		BEGIN
			UPDATE [ListPharmacyClearinghouse]
				SET [InterfaceDetails] = @InterfaceDetailsXML,
					[LastModifiedDate] = GETUTCDATE()
			WHERE [PharmacyClearinghouseUid] = @PharmacyClearinghouseUid
		END

		SELECT @InterfaceDetailsXML = [InterfaceDetails]
		FROM [ListPharmacyClearinghouse]
		WHERE [PharmacyClearinghouseUid] = @PharmacyClearinghouseUid

		IF @InterfaceDetailsXML.exist ('root/VersionCommonFormulary') <> 0
		BEGIN
			SELECT @PRMVersion = COALESCE(x.n.value('@PRMVersion', '[varchar](24)'), '15.0.0'),
				@PRMSeq = COALESCE(x.n.value('@PRMSeq', '[int]'), 1),
				@PRMBuild = COALESCE(x.n.value('@PRMBuild', '[varchar](24)'), '15.0')
			FROM @InterfaceDetailsXML.nodes('root/VersionCommonFormulary') AS x(n)

			IF @PRMVersion = @PRMVersion_DB
				AND @PRMSeq = @PRMSeq_DB
				AND @PRMBuild = @PRMBuild_DB
			BEGIN
				DECLARE @ProcessInboundAQN [varchar](2048) = 'iMedica.Framework.eRx.SureScripts.ProcessFormularyUpdate_V18, eRx',
					@OrgUid_SearchCriteria [varchar](64) = '00000002-%',
					@LastModifiedDate [datetime] = GETUTCDATE()

				UPDATE [ListeRxMessageType]
					SET [ProcessInboundAQN] = @ProcessInboundAQN
				WHERE [eRxMessageTypeUid] in(
						'4A412563-F3DE-43F2-907E-3E6DF8B20E90',	-- formulary_update
						'E76DCEF2-7B7E-4640-B750-EA28768EBD2B'	-- formulary_list
				)
				AND ([ProcessInboundAQN] IS NULL OR [ProcessInboundAQN] <> @ProcessInboundAQN)

				UPDATE [PatienteRxEligibility]
					SET [FormularyOrgUid] = NULL,
						[LastModifiedDate] = @LastModifiedDate
				FROM [PatienteRxEligibility] AS pelg
					LEFT OUTER JOIN [FormularyOrg] AS fo ON pelg.[FormularyOrgUid] = fo.[FormularyOrgUid]
				WHERE pelg.[FormularyOrgUid] IS NOT NULL
					AND (
							fo.[FormularyOrgUid] IS NULL
							OR CAST(pelg.[FormularyOrgUid] AS [varchar](128)) NOT LIKE @OrgUid_SearchCriteria
					)

				UPDATE [PatienteRxEligibility]
					SET [FormularyAlternativesOrgUid]  = NULL,
						[LastModifiedDate] = @LastModifiedDate
				FROM [PatienteRxEligibility] AS pelg
					LEFT OUTER JOIN [FormularyAlternativesOrg] AS fo ON pelg.[FormularyAlternativesOrgUid] = fo.[FormularyAlternativesOrgUid]
				WHERE pelg.[FormularyAlternativesOrgUid] IS NOT NULL
					AND (
							fo.[FormularyAlternativesOrgUid] IS NULL
							OR CAST(pelg.[FormularyAlternativesOrgUid] AS [varchar](128)) NOT LIKE @OrgUid_SearchCriteria
					)

				UPDATE [PatienteRxEligibility]
					SET [FormularyCoverageOrgUid]  = NULL,
						[LastModifiedDate] = @LastModifiedDate
				FROM [PatienteRxEligibility] AS pelg
					LEFT OUTER JOIN [FormularyCoverageOrg] AS fo ON pelg.[FormularyCoverageOrgUid] = fo.[FormularyCoverageOrgUid]
				WHERE pelg.[FormularyCoverageOrgUid] IS NOT NULL
					AND (
							fo.[FormularyCoverageOrgUid] IS NULL
							OR CAST(pelg.[FormularyCoverageOrgUid] AS [varchar](128)) NOT LIKE @OrgUid_SearchCriteria
					)

				UPDATE [PatienteRxEligibility]
					SET [FormularyCopayOrgUid]  = NULL,
						[LastModifiedDate] = @LastModifiedDate
				FROM [PatienteRxEligibility] AS pelg
					LEFT OUTER JOIN [FormularyCopayOrg] AS fo ON pelg.[FormularyCopayOrgUid] = fo.[FormularyCopayOrgUid]
				WHERE pelg.[FormularyCopayOrgUid] IS NOT NULL
					AND (
							fo.[FormularyCopayOrgUid] IS NULL
							OR CAST(pelg.[FormularyCopayOrgUid] AS [varchar](128)) NOT LIKE @OrgUid_SearchCriteria
					)
			END
		END
	END
END
GO

/*
	Task 47894:Send Statement Status needs to change from Send to "System Send" upon Migration from 2015 to 2016
	2016-05-23 BMR Wrap with Trigger disable to speed up process
	2016-04-04 BMR Created
*/
IF NOT EXISTS(SELECT * FROM ListProductParameter WHERE ProductParameterUid = '1E87ADD0-4388-4F32-86A5-F84F38EA7DB7')
BEGIN 

	-- this trigger not relevant to these changes, simply disable during process
-- SKIP for 2017 migration	DISABLE TRIGGER [dbo].[collectionstatusmanuallychanged_arpupdate] ON [dbo].[AccountResponsibleParty];

	-- in 2015 - Send Statement Field was BIT 0 = No, 1 = Yes (Defaulted to 1)
	-- in 2016 - TINYINT 0 = SystemSend (send unless CollectionStatus or BadAddress is set), 1 = Send, 2 - Do Not Send

	UPDATE AccountResponsibleParty
		SET SendStatement = 2 -- ARP - Do Not Send in 2016
		WHERE SendStatement = 0; -- No in 2015 -- Default is 1, so if 0, can assume they made a decision to do so

	UPDATE AccountResponsibleParty
		SET SendStatement = 0 -- SystemSend in 2016 - will get blocked if CollectionStatus or BadAddress is set
		WHERE SendStatement = 1; -- Yes in 2015 -- Assuming they wanted to send by default

	-- client will need to manually change to SEND from teh ARP screen if they want to get it to SendStatement = 1

	-- mark as done so do not do again ...
	INSERT INTO ListProductParameter (ProductParameterUid, ParameterName, BoolValue, UserDefined, Inactive, LastModifiedDate)
	VALUES ('1E87ADD0-4388-4F32-86A5-F84F38EA7DB7' , 'MigratedAccountResponsiblePartySendStatement', 1 , 1, 0 , GETUTCDATE ());

	-- reenable trigger 
-- SKIP for 2017 migration		ENABLE TRIGGER [dbo].[collectionstatusmanuallychanged_arpupdate] ON [dbo].[AccountResponsibleParty];

END
GO

-- Bug 48262: Need Billing Type to handle RHC when they want to use legacy revenue codes on dates after 4/1/16
IF NOT EXISTS ( SELECT * FROM MapSource WHERE MapSourceUid = '649D2F6A-D215-41F3-963F-E912AACAF335' )
BEGIN
	Insert into MapSource( MapSourceUid, Name, FindTableFromUid, MapDirection, UserDefined, Notes, Inactive, LastModifiedDate)
	VALUES( '649D2F6A-D215-41F3-963F-E912AACAF335', 'RHC', '23C60022-225F-4FFE-AE7C-B0B3863CFBCF', 2, 0, 
			'RHC Mapping table for RHC Billing Type.  ' + CHAR(13)+CHAR(10) +
			'NOTE:  This table will always be used to remap revenue codes for the RHC Billing Type' , 
			0, '2016-04-06 12:34:56.789')

	CREATE TABLE #rCodes2
	(
		DisplayOrder		INT Identity,
		ProcedureUid		UNIQUEIDENTIFIER,
		Code				VARCHAR(30),
		ShortDescription	VARCHAR(75),
		RevenueCode		VARCHAR(10)
	)
	INSERT INTO #rCodes2( ProcedureUid, Code, ShortDescription, RevenueCode)
		SELECT lp.ProcedureUid, lp.Code, lp.ShortDescription, lp.RevenueCode
		FROM ListProcedure lp WITH (NOLOCK)
		WHERE lp.RevenueCode IS NOT NULL
		ORDER BY Code asc

	-- NOTE:  Allow to be re-executed to ADD additional items to RHC mapSource.  ( Won't duplicate existing items )
	INSERT INTO MapItem( MapItemUid, MapSourceUid, FindTableFromItemUid, MapItemFromName, SubstitutionText, DisplayOrder, UserDefined, Inactive, LastModifiedDate)
		SELECT newid(),'649D2F6A-D215-41F3-963F-E912AACAF335', #rCodes2.ProcedureUid, #rCodes2.ShortDescription, #rCodes2.RevenueCode,  #rCodes2.DisplayOrder, 0, 0, GetDate()
		FROM #rCodes2
				LEFT OUTER JOIN MapItem mi with (nolock) on #rCodes2.ProcedureUid = mi.FindTableFromItemUid
																AND mi.MapSourceUid = '649D2F6A-D215-41F3-963F-E912AACAF335'
		where mi.FindTableFromItemUid IS NULL
		
	drop table #rCodes2

END
GO

-- 49483
update ListIntegrationPartner set Inactive = HL7P.Inactive, AdditionalOutboundXML=HL7P.TransmissionSettings
from HL7Partner as HL7P
where IntegrationPartnerUid='60157D55-360B-4505-BB1A-F09E538826C9' AND HL7P.HL7PartnerUid='829DE824-8E7D-45F4-A6F5-8EF8BA193F88'

delete from HL7ActionTypeObject where HL7PartnerMessageUid='810BCAD0-06E4-429B-A39B-E89027748283'
delete from HL7Message where HL7PartnerMessageUid='810BCAD0-06E4-429B-A39B-E89027748283'
delete from HL7PartnerMessage where HL7PartnerMessageUid='810BCAD0-06E4-429B-A39B-E89027748283'
delete from HL7Partner where HL7PartnerUid='829DE824-8E7D-45F4-A6F5-8EF8BA193F88'

IF EXISTS (SELECT * FROM sys.triggers WHERE object_id = OBJECT_ID(N'[dbo].[CCD_PatientCareManagement_Complete]'))
begin
	DROP TRIGGER [dbo].CCD_PatientCareManagement_Complete
end
GO

-- 51561 split AuditWorkflowLog post script
IF EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[migtemp_AuditWorkflowLog]') AND type in (N'U'))
BEGIN
	insert into AuditWorkflowLogArchive select * from migtemp_AuditWorkflowLog 
	drop table migtemp_AuditWorkflowLog
END
GO

/*	Product Backlog Item 51270:Practice setting for option to default setting to opt in when new responsible party is created.
	Modify SendPaperlessStatements on Account Responsible Party Screen - Statements to Support 3 State Options
	Migrate existing data
	20161018	BMR		Created
*/
IF NOT EXISTS(SELECT * FROM ListProductParameter 
	WHERE ProductParameterUid = '9FB685F8-8345-4B83-8931-22979E466E91') -- Check if already done (Ex. RC1-->RC2)
BEGIN
      -- Collection Processing, Create Collection Letters
      UPDATE AccountResponsibleParty
		SET SendPaperlessStatements = CASE WHEN SendPaperlessStatements = 1 THEN 0 ELSE 2 END;

      INSERT INTO ListProductParameter (ProductParameterUid, ParameterName, BoolValue, UserDefined, Inactive, LastModifiedDate) -- Flag As Done
           VALUES ('9FB685F8-8345-4B83-8931-22979E466E91', 'Migrate ARP SendPaperlessStatements To TinyInt', 1, 0, 0, GETUTCDATE());
END
GO

-- 52399 fix probem of PatientReferralUid not getting set by SendDocument operation
UPDATE aud 
SET PatientReferralUid = rag.PatientReferralUid
FROM RecordDisclosureAudit aud
INNER JOIN RelAttachmentGroup rag on rag.AttachmentGroupUid = aud.AttachmentGroupUid
WHERE aud.PatientReferralUid IS NULL
  and rag.PatientReferralUid IS NOT NULL

-- 46196 make sure that order has up to date VisitUid from attachment approval
UPDATE obo
SET VisitUid = rag.VisitUid
FROM ObservationOrder obo
INNER JOIN RelAttachmentGroup rag on rag.ObservationOrderUid = obo.ObservationOrderUid
WHERE obo.VisitUid is null
  AND rag.VisitUid is not null
GO

-- =========================================================================
-- Post migration for table "RelPatientPersonWeb"  Backlog Item #52862
-- created 11/9/2016
-- =========================================================================
BEGIN TRY
	IF dbo.Replication_IsReplicatedDB() = 0
	BEGIN
		IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[temp_RelPatientPersonWeb]') AND type in (N'U'))
		BEGIN
			insert into RelPatientPersonWeb
			select * from temp_RelPatientPersonWeb 					
			
			DROP TABLE [dbo].[temp_RelPatientPersonWeb]

		END	
	END
END TRY
BEGIN CATCH
END CATCH
GO


-- 48936
DECLARE @PharmacyClearinghouseUid [uniqueidentifier] = '118422AA-C165-4A2E-8389-E5B7E89636EA',
	@PharmacyDownloadJobScheduleUid [uniqueidentifier] = 'EAFF3043-E1AE-437A-833E-B24295B12B69', -- eRxService: Download Pharmacy Directory
	@MailboxName [varchar](64),
	@MailboxPassword [varchar](64),
	@fullPharmacyList[bit],
	@SpecialtyCodes [varchar](64),
	@AreaCodes [varchar](max),
	@PharmacyIDs [varchar](max),
	@ZipCodes [varchar](max),
	@ImplementedDirectoryServiceVersion [varchar](64) = 'V4R6',
	@DirectoryServiceVersion [varchar](64),
	@Inactive [bit] = 0,
	@InterfaceDetail [xml]

UPDATE [ListPharmacyClearinghouse]
	SET [AssemblyQualifiedName] = 'iMedica.Framework.eRx.SureScripts.SureScriptsProcessor_V20, eRx'
WHERE [PharmacyClearinghouseUid] = @PharmacyClearinghouseUid
	AND [AssemblyQualifiedName] = 'iMedica.Framework.eRx.SureScripts.SureScriptsProcessor, eRx'

UPDATE [ListeRxMessageType]
	SET [ProcessInboundAQN] = 'iMedica.Framework.eRx.SureScripts.ProcessPharmacyUpdate_V20, eRx'
WHERE [eRxMessageTypeUid] IN(
	'A68DF433-597D-4E7C-800A-BEB65397FF04',	-- Pharmacy List
	'0FFDE3E6-A37B-4885-A142-4430C7526FC3'	-- Pharmacy Update
	)
	AND [ProcessInboundAQN] = 'iMedica.Framework.eRx.SureScripts.ProcessPharmacyUpdate, eRx'

UPDATE [ListJob]
	SET [UIAssemblyQualifiedName] = 'iMedica.Prm.Client.UI.JobEngine.ControlPolleRxMessage'
WHERE [JobUid] = 'FDEE0DA3-1319-430A-9164-63BF273CC4B2'	-- eRxService: Process Pharmacy Messages
	AND [UIAssemblyQualifiedName] IS NULL

UPDATE [ListJob]
	SET [AssemblyQualifiedName] = 'iMedica.Framework.eRx.JobTask.ProcesseRxDSMessages, eRx',
		[Inactive] = @Inactive
WHERE [JobUid] = 'FDEE0DA3-1319-430A-9164-63BF273CC4B2'	-- eRxService: Process Pharmacy Messages
	AND [AssemblyQualifiedName] = 'iMedica.Framework.eRx.JobTask.ProcessInboundProviderBroadcastMessages, eRx'
	
UPDATE [ListJob]
	SET [AssemblyQualifiedName] = 'iMedica.Framework.eRx.JobTask.QueueeRxDSMessages, eRx',
		[Inactive] = @Inactive
WHERE [JobUid] = @PharmacyDownloadJobScheduleUid	-- eRxService: Download Pharmacy Directory
	AND [AssemblyQualifiedName] = 'iMedica.Framework.eRx.JobTask.GetERxMessages, eRx'

UPDATE [JobSchedule]
	SET [MethodParams] = '<Control Name="ControlPolleRxMessage" ControlType="ControlPolleRxMessage" /><Control Name="_findTextMessageType" ControlType="FindTextControl" Guid="6545bcbf-f85d-4f13-b480-10273968ab52" Value="Pharmacy" Tag="pharmacy" ForeignKeyIndex="0" FindTableUid="a84768bd-706b-4e2b-ad30-f261c4444a60" ExternalId="" Label="Message Type" />'
WHERE [JobScheduleUid] = 'BCA1ECA3-D92A-4848-AD16-B49264706B5D'	-- eRxService: Process Pharmacy Messages
	AND ([MethodParams] IS NULL OR LEN([MethodParams]) <= 0)

UPDATE [JobSchedule]
	SET [JobScheduleTimeBaseUid] = '10101010-0000-0000-0000-000000000201',
		[JobRepeatInterval] = 15
WHERE [JobScheduleUid] = 'BCA1ECA3-D92A-4848-AD16-B49264706B5D'	-- eRxService: Process Pharmacy Messages
	AND [JobScheduleTimeBaseUid] = '10101010-0000-0000-0000-000000000204'

SELECT @InterfaceDetail = [InterfaceDetails]
FROM [ListPharmacyClearinghouse]
WHERE [PharmacyClearinghouseUid] = @PharmacyClearinghouseUid

SELECT @MailboxName = LTRIM(RTRIM((CASE WHEN x.n.exist('@testMode="true"') <> 0 THEN x.n.value('(QA/MailboxName)[1]', '[varchar](64)')
							ELSE x.n.value('(Prod/MailboxName)[1]', '[varchar](64)')
						END))),
	@DirectoryServiceVersion = LTRIM(RTRIM(x.n.value('@directoryServiceVersion', '[varchar](64)'))),
	@MailboxPassword = LTRIM(RTRIM((CASE WHEN x.n.exist('@testMode="true"') <> 0 THEN x.n.value('(QA/MailboxPassword)[1]', '[varchar](64)')
							ELSE x.n.value('(Prod/MailboxPassword)[1]', '[varchar](64)')
						END))),
	@fullPharmacyList = x.n.value('@fullPharmacyList', '[bit]'),
	@SpecialtyCodes = x.n.value('@specialtyCodes', '[varchar](64)'),
	@AreaCodes = LTRIM(RTRIM(x.n.value('@areaCodes', '[varchar](max)'))),
	@PharmacyIDs = LTRIM(RTRIM(x.n.value('@pharmacyIDs', '[varchar](max)'))),
	@ZipCodes = LTRIM(RTRIM(x.n.value('@zipCodes', '[varchar](max)')))
FROM @InterfaceDetail.nodes('root') AS x(n)

IF @DirectoryServiceVersion IS NULL OR @DirectoryServiceVersion <> @ImplementedDirectoryServiceVersion
BEGIN
	IF @InterfaceDetail.exist('root/@directoryServiceVersion') = 0
	BEGIN
		SET @InterfaceDetail.modify('insert attribute directoryServiceVersion {sql:variable("@ImplementedDirectoryServiceVersion")} as first into (root)[1]')
	END
	ELSE
	BEGIN
		SET @InterfaceDetail.modify('replace value of (root/@directoryServiceVersion)[1] with sql:variable("@ImplementedDirectoryServiceVersion")')
	END

	SET @InterfaceDetail.modify('replace value of (root)[1]/@fullPharmacyList with "true"')
	SET @InterfaceDetail.modify('delete root/@lastPharmacySuccessfullDownloadDate')

	UPDATE [ListPharmacyClearinghouse]
		SET [InterfaceDetails] = @InterfaceDetail
	WHERE [PharmacyClearinghouseUid] = @PharmacyClearinghouseUid
END

IF EXISTS (
		SELECT TOP 1 *
		FROM [ListPharmacyClearinghouse] WITH(NOLOCK)
		WHERE [PharmacyClearinghouseUid] = @PharmacyClearinghouseUid
			AND [Inactive] = @Inactive
	)
	AND LEN(@MailboxName) > 0
	AND LEN(@MailboxPassword) > 0
	AND (
			LEN(@SpecialtyCodes) > 0
			OR EXISTS(
				SELECT DISTINCT TOP 1 LTRIM(RTRIM(p.[Element])) AS [AreaCodes]
				FROM [dbo].[Split] (@AreaCodes, ',') AS p
				WHERE LEN(LTRIM(RTRIM(p.[Element]))) > 0
			)
			OR EXISTS(
				SELECT DISTINCT TOP 1 LTRIM(RTRIM(p.[Element])) AS [PharmacyIDs]
				FROM [dbo].[Split] (@PharmacyIDs, ',') AS p
				WHERE LEN(LTRIM(RTRIM(p.[Element]))) > 0
			)
			OR EXISTS(
				SELECT DISTINCT TOP 1 LTRIM(RTRIM(p.[Element])) AS [ZipCodes]
				FROM [dbo].[Split] (@ZipCodes, ',') AS p
				WHERE LEN(LTRIM(RTRIM(p.[Element]))) > 0
			)
	)
BEGIN
	UPDATE [ListJob]
		SET [Inactive] = @Inactive
	FROM [JobSchedule] AS js
		INNER JOIN [ListJob] AS lj ON js.[JobUid] = lj.[JobUid]
	WHERE js.[JobScheduleUid] = @PharmacyDownloadJobScheduleUid
		AND lj.[Inactive] <> @Inactive

	UPDATE [JobSchedule]
		SET [Inactive] = @Inactive
	WHERE [JobScheduleUid] = @PharmacyDownloadJobScheduleUid
		AND [Inactive] <> @Inactive

	UPDATE [JobSchedule]
		SET [RunImmediately] = 1
	WHERE [JobScheduleUid] = @PharmacyDownloadJobScheduleUid
END
GO

/* Bug 53859 version 2*/
if  EXISTS(select * from ListBatchProcessType where BatchProcessTypeUid='10000101-0000-0000-0000-000000000005' AND HIDE=1)
BEGIN
	update ListBatchProcessType set Hide=0, AutoStartDetail=1 where BatchProcessTypeUid='10000101-0000-0000-0000-000000000005'
END
update ListBatchProcessType set Hide=1 where BatchProcessTypeUid <> '10000101-0000-0000-0000-000000000005' and Hide=0
/* Bug 53859 second script */
UPDATE UserPRM SET Settings.modify('delete(//SpreadSheet/ViewBatchProcess)')
       WHERE CAST(Settings AS NVARCHAR(MAX)) LIKE '%ViewBatchProcess%'
GO

-- 43389
IF  EXISTS (SELECT * FROM [ListUIControl] where [UIControlUid]='D6486924-92FF-43EA-B8EA-DBE5140657D5')
	delete from [ListUIControl] where [UIControlUid]='D6486924-92FF-43EA-B8EA-DBE5140657D5'
INSERT INTO [dbo].[ListUIControl]
           ([UIControlUid]
           ,[ExternalID]
           ,[Inactive]
           ,[Name]
           ,[UIControlTypeUid]
           ,[DisplayName]
           ,[AQN]
           ,[ConfigurationAQN]
           ,[ContentSourceFieldsAQN]
           ,[UserDefined]
           ,[Notes]
           ,[LicenseCode]
           ,[LastModifiedDate])
     SELECT
           UIControlUid = 'D6486924-92FF-43EA-B8EA-DBE5140657D5'
           ,ExternalID = NULL
           ,Inactive = 0
           ,Name = 'Batch Process Credit Card Consent Detail'
           ,UIControlTypeUid = '88B88527-4D65-4A44-B7CF-15C392A96B06'
           ,DisplayName = NULL
           ,AQN = 'iMedica.Prm.Client.UI.Mobile.RoutingClasses.MobileBatchProcessCreditCardConsentDetail'
           ,ConfigurationAQN = NULL
           ,ContentSourceFieldsAQN = NULL
           ,UserDefined = 0
           ,Notes = NULL
           ,LicenseCode = NULL
           ,LastModifiedDate = GETUTCDATE()
GO

/* Bug 43389 */
if  EXISTS(select * from ListBatchProcessType where BatchProcessTypeUid='10000101-0000-0000-0000-000000000006' AND HIDE=1)
BEGIN
	update ListBatchProcessType set Hide=0, AutoStartDetail=1, ConfigurationAqn=Null,
  SummaryXSLT='<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
  <xsl:template match="summary">
    <div>
      <xsl:variable name="apos">''</xsl:variable>
      <a href="#" class="clickable" prm-transition-to="{concat(''{appRoute: '', $apos, ''batchProcessCreditCardConsentDetail'', $apos, '', pageOpts: {sameWindow: true}, opts : {id:'', $apos, @BatchProcessUid, $apos, '', name: '', $apos, @Name, $apos, ''}}'')}">
		View Batch Detail
	</a>
    </div>
  </xsl:template>
</xsl:stylesheet>'
where BatchProcessTypeUid='10000101-0000-0000-0000-000000000006'
END
GO

-- fix for bug #48993
update ListFindTable set Columns = '<FindColumn name="Name" caption="Name" visible="true" width="200" />
<FindColumn name="Related" visible="true" caption="Related" width="120" />
<FindColumn name="Onset" caption="Onset" visible="true" width="125" />
<FindColumn name="Resolved" caption="Resolved" visible="true" width="125" />
<FindColumn name="Status" visible="true" caption="Status" width="150" />
<FindColumn name="Provider" visible="true" caption="Provider" width="150" />
<FindColumn name="Notes" visible="true" caption="Notes" width="75" wordwrap="true" />
<FindColumn name="LastDiagnosisDate" visible="true" caption="Last Dx''s Date" width="135" />
<FindColumn name="HCC112" visible="true" caption="HCC" resizable="true" width="43" />
<FindColumn name="DSMAxis" visible="true" caption="DSM Axis" resizable="true" width="70" />
<FindColumn name="DiagnosisType" visible="true" caption="Type" resizable="true" width="50" />
<FindColumn name="RecordedDate" visible="true" caption="Recorded Date" width="135" />
<FindColumn name="History" visible="true" caption=" " resizable="false" width="23" />
<FindColumn name="Delete" visible="true" caption=" " resizable="false" width="23" />
<FindColumn name="InfoButton" visible="true" caption="Info" resizable="false" width="23" />'
where FindTableUid = '84E31DCA-37E0-49E2-9DFF-603A6EF7AA22'
GO

-- 56342
--post(CommonWellPatient) - transfer stuff
IF (EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = 'temp_CommonWellPatient')
	AND EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = 'HIEPatient'))
BEGIN
declare @CommonWellIntegrationPartnerUid as uniqueidentifier
set @CommonWellIntegrationPartnerUid='01178549-2CEF-462B-89B0-E41EA99EE57A'
declare @count as int;
select @count = count(CommonWellPatientUid) from temp_CommonWellPatient;
while (@count > 0)
Begin
	declare @CommonwellPatientUid as uniqueidentifier
	set @CommonwellPatientUid = (select top 1 CommonwellPatientUid from temp_CommonWellPatient)
	insert into HIEPatient(HIEPatientUid, PersonUid, PatientId, DocumentList, IntegrationPartnerUid, Notes, UserDefined, LastModifiedDate, LastModifiedByUid)
	select CommonwellPatientUid, PersonUid, PatientId, null, @CommonWellIntegrationPartnerUid, Notes, UserDefined, LastModifiedDate, LastModifiedByUid 
	from temp_CommonWellPatient where CommonWellPatientUid=@CommonwellPatientUid
	delete from temp_CommonWellPatient where CommonWellPatientUid = @CommonwellPatientUid;
	set @count -= 1;
end

drop table temp_CommonWellPatient
END
--End Post

--post(CommonWellDocument) - transfer
IF (EXISTS (SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = 'temp_CommonWellDocument')
	AND EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = 'HIEPatientDocument'))
BEGIN
declare @countD as int;
select @countD = count(CommonWellDocumentUid) from temp_CommonWellDocument;
while (@countD > 0)
Begin
	declare @CommonwellDocumentUid as uniqueidentifier
	set @CommonwellDocumentUid = (select top 1 CommonWellDocumentUid from temp_CommonWellDocument)
	insert into HIEPatientDocument(HIEPatientDocumentUid, HIEPatientUid, DocumentId, DocumentStatusUid, AttachmentUid, Notes, UserDefined, LastModifiedDate, LastModifiedByUid)
	select CommonWellDocumentUid, CommonWellPatientUid, DocumentId, CommonWellDocumentStatusUid, AttachmentUid, Notes, UserDefined, LastModifiedDate, LastModifiedByUid 
	from temp_CommonWellDocument where @CommonwellDocumentUid=@CommonwellDocumentUid
	delete from temp_CommonWellDocument where @CommonwellDocumentUid = @CommonwellDocumentUid;
	set @countD -= 1;
end

drop table temp_CommonWellDocument
END
--end post

-- 57720 Problem of Diabetes is associated with DX on all existing notes -- Additional migration script for clean-up
IF dbo.Replication_IsReplicatedDB() = 0
BEGIN
	-- save existing VisitDiagnosis data
	IF  NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[cus_VisitDiagnosis20170531]') AND type in (N'U'))
	begin
		select * into cus_VisitDiagnosis20170531 from VisitDiagnosis
	end
END
go
     
IF dbo.Replication_IsReplicatedDB() = 0
BEGIN           
	update vd set vd.patientproblemdiagnosisuid = null 
        from VisitDiagnosis vd
        join visit v on vd.VisitUid = v.VisitUid
        join PatientProblemDiagnosis ppd on vd.PatientProblemDiagnosisUid = ppd.PatientProblemDiagnosisUid 
			and v.PatientUid <> ppd.PatientUid
END
GO

IF dbo.Replication_IsReplicatedDB() = 0
BEGIN
-- remove incorrect problem diagnosis from the VisitDiagnosis
	update vd1 set PatientProblemDiagnosisUid = null
		from VisitDiagnosis vd1
			where vd1.PatientProblemDiagnosisUid is not null
				and vd1.VisitDiagnosisUid not in (select vd2.VisitDiagnosisUid from VisitDiagnosis vd2
						inner join PatientProblemDiagnosis ppd2 on ppd2.PatientProblemDiagnosisUid = vd2.PatientProblemDiagnosisUid
						inner join RelDiagnosisDisease rdd on rdd.DiseaseUid = ppd2.DiseaseUid
							and ((rdd.Code9 = vd2.Code and rdd.Code10 = vd2.Code10)
								or (vd2.Code10 is null and rdd.Code9 = vd2.Code)))
END
go

IF dbo.Replication_IsReplicatedDB() = 0
BEGIN
	-- re-migrate connect problems
	IF  EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[cus_VisitDiagnosis]') AND type in (N'U'))
	BEGIN
		declare @sql nvarchar(4000)
		set @sql = 
		'update vd2 SET vd2.PatientProblemDiagnosisUid = (SELECT ppdh.PatientProblemDiagnosisUid FROM PatientProblemDiagnosisHistory ppdh
								WHERE ppdh.PatientProblemDiagnosisHistoryUid = vd1.PatientProblemUid)
			from VisitDiagnosis vd2 
				inner join cus_VisitDiagnosis vd1 on vd2.VisitDiagnosisUid = vd1.VisitDiagnosisUid
			where vd1.PatientProblemUid is not null
			and vd2.PatientProblemDiagnosisUid is null'
		exec sp_executesql @sql
	END
END
GO

-- #57940
If EXISTS(Select * from Hl7PartnerMessage where Hl7partneruid = '0D79E689-8777-44D0-956D-19EBC8DB1DF1' And SendFunction <> 'merge')
Begin
	
	Update Hl7partnermessage
	set SendFunction = 'merge'
	where hl7partneruid = '0D79E689-8777-44D0-956D-19EBC8DB1DF1'
end
GO

-- 20170719 kculberth
-- Bug 58504:eTactics statement batches not transmitting because Etactics Statement Batch Create Message is Inactive
-- set HL7PartnerMessage inactive to 0 to ensure that statement batches will send with recent changes to MessagesToSend
update hpm
set hpm.inactive = 0
from HL7PartnerMessage hpm
where messagetype = 'StatementBatch'
GO

--- 58479  ListAttachmentHandler -- PostScript
IF EXISTS(SELECT * FROM INFORMATION_SCHEMA.TABLES WHERE TABLE_NAME = 'CUS_ListAttachmentHandler_58479')
BEGIN
   DECLARE @evp varchar(500);
   select @evp = ExternalViewerPath  FROM ListAttachmentHandler where AttachmentHandlerUid='698415E1-9AAD-45AC-A5B1-90E0F8CBC4B1'
   update ListAttachmentHandler set ExternalViewerPath = @evp WHERE @evp IS NOT NULL AND AttachmentHandlerUid='5DF0760B-2791-4ECD-8A56-6FB52B2F093A'
   update ListAttachmentHandler set Inactive=1 where AttachmentHandlerUid='698415E1-9AAD-45AC-A5B1-90E0F8CBC4B1'
   DROP TABLE CUS_ListAttachmentHandler_58479
END
GO

