-- Report fixups
--12/16/2015 kculberth fix bug 44446 and 44450
BEGIN TRY 
	BEGIN TRANSACTION
		delete uc
		FROM ListUserDefinedControl uc
		inner join ListUserDefinedControlGroup ucg on ucg.UserDefinedControlGroupUid = uc.UserDefinedControlGroupUid
		where uc.UserDefinedControlGroupUid = '1B132100-E36C-4F47-9351-FCE99BA03CDA' and ucg.Name = 'Procedure Productivity Summary'

		INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
		VALUES('DC6107EF-9ABA-4FF7-B0EA-5F95F241525C','DateOption',0,'Date Option','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>DateOption</Name><ButtonLabel>Service Dates</ButtonLabel><ButtonValue>Service</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>DateOption</Name><ButtonLabel>Posting Dates</ButtonLabel><ButtonValue>Posting</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','1B132100-E36C-4F47-9351-FCE99BA03CDA',1,1,0,'11/24/2015 12:04:53 PM')

		INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
		VALUES('06CE504F-4718-4395-92D7-E21393858AC9','CPTCodeRange',0,'CPT Code Range','23d953d7-7438-48d0-9fd1-c950130cb558','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TEXT</ControlType><Name>CPTCodeRange</Name><DefaultText></DefaultText><MaxLength>50</MaxLength><MultiLine>false</MultiLine></Control></UserDefinedControls>','1B132100-E36C-4F47-9351-FCE99BA03CDA',9,1,0,'11/24/2015 11:24:54 AM')

		INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
		VALUES('42EF94AE-28D2-4F56-B8E3-B1DC8299888B','financialCenterUid',0,'Financial Center','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>financialCenterUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Financial Center</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>FinancialCenter</FindTableName></Control></UserDefinedControls>','1B132100-E36C-4F47-9351-FCE99BA03CDA',5,1,0,'11/24/2015 11:21:37 AM')

		INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
		VALUES('4C66B129-0529-4FD4-B45E-13383791147C','PPS',0,'Date','df87d0d5-bf48-49fb-abbc-cb75cc29eb64','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>PPS</Name><Uid>00000000-0000-0000-0000-000000000000</Uid></Control></UserDefinedControls>','1B132100-E36C-4F47-9351-FCE99BA03CDA',0,1,0,'11/24/2015 11:24:54 AM')

		INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
		VALUES('3FD6A368-BFF8-4C05-833F-D04E5A50858D','ProviderOption',0,'Provider Option','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Rendering Provider</ButtonLabel><ButtonValue>Rendering</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Billing Provider</ButtonLabel><ButtonValue>Billing</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','1B132100-E36C-4F47-9351-FCE99BA03CDA',3,1,0,'11/24/2015 12:04:53 PM')

		INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
		VALUES('A790AFA7-32A4-4D86-A6F2-D0A83E5B3BEC','GroupBy',0,'Group By','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>GroupBy</Name><ButtonLabel>CPT</ButtonLabel><ButtonValue>CPT</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>GroupBy</Name><ButtonLabel>Provider</ButtonLabel><ButtonValue>Provider</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','1B132100-E36C-4F47-9351-FCE99BA03CDA',6,1,0,'11/24/2015 12:04:53 PM')

		INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
		VALUES('E8FA3ED5-EA36-40EC-8D0E-1BB91C86F715','ProviderUid',0,'Provider(s)','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProviderUids</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Provider</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewProvider</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','1B132100-E36C-4F47-9351-FCE99BA03CDA',2,1,0,'11/24/2015 11:33:57 AM')

		INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
		VALUES('9026E348-D19D-4CCB-889E-91FB450326D6','IncludeCPTCodes',0,'Include CPT Codes','71e67ced-b180-44e9-80c9-1ed3b47c9390','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>CHECKBOX</ControlType><Name>IncludeCPTCodes</Name><CheckedText>true</CheckedText><UnCheckedText>false</UnCheckedText><CheckedByDefault>false</CheckedByDefault></Control></UserDefinedControls>','1B132100-E36C-4F47-9351-FCE99BA03CDA',7,1,0,'11/24/2015 11:24:54 AM')

		INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
		VALUES('772E6E88-7F14-4E94-A798-E71EC94123DB','ProcedureGroupUid',0,'Procedure Group(s)','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProcedureGroupUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Procedure Group</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListProcedureGroup</FindTableName></Control></UserDefinedControls>','1B132100-E36C-4F47-9351-FCE99BA03CDA',8,1,0,'11/24/2015 11:24:54 AM')

		INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
		VALUES('45F9C5DD-B2BC-42D0-A18E-9D2A6F0AEF0E','ServiceSiteUid',0,'Service Site(s)','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>serviceSite</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Service Site</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListServiceSite</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','1B132100-E36C-4F47-9351-FCE99BA03CDA',4,1,0,'11/24/2015 11:24:54 AM')

		update ListReport
		set ReportParameters = '<ReportParameters />'
		where reportuid = '6E06CB1B-970E-40DB-B543-8C920F901B49'

	COMMIT TRANSACTION;
  END TRY
  BEGIN CATCH
	IF @@TRANCOUNT > 0
    ROLLBACK TRANSACTION;
  END CATCH
GO

-- 45640
update listreport
set Inactive = 0 ,LastModifiedDate = GETUTCDATE()
where name = 'quality report' and reportuid = 'D7EAF9CC-B47C-421C-8A90-B07F7EEDC496'

update ListUserDefinedControl
set label = 'Diagnosis Code or Code Range'
,ControlTypeUid = '0C9D0503-755F-4FDD-B9AB-77F1B8222D50'
,ControlProperties = '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><CodeTable>DIAG10</CodeTable><ControlType>TEXT</ControlType><Name>DiagnosisUid</Name><DefaultText></DefaultText><MaxLength></MaxLength><MultiLine>false</MultiLine><Required>FALSE</Required></Control></UserDefinedControls>'
,LastModifiedDate=GETUTCDATE()
where UserDefinedControlUid = 'C34BA15E-AC45-412E-8504-1C4CD3FBF5FF'
go

-- 47349
	Update listuserdefinedcontrol 
	SET SortOrder = '1',UserDefined ='0'
	WHERE Name = 'ProviderUid' AND UserDefinedControlUid = '04bb2757-aa96-497d-9dc0-0fd9ebbe1fb6'

	Update listuserdefinedcontrol 
	SET SortOrder = '0',UserDefined ='0'
	WHERE Name = 'AppDate' AND UserDefinedControlUid = '68cc81e4-a5d2-4daa-b38b-24032ffc8b47'

	Update listuserdefinedcontrol 
	SET SortOrder = '2',UserDefined ='0'
	WHERE Name = 'CalendarUid' AND UserDefinedControlUid = '0d33246c-2617-4ce7-8271-b3983e742a18'

	Update listuserdefinedcontrol 
	SET SortOrder = '3',UserDefined ='0'
	WHERE Name = 'ServiceSiteUid' AND UserDefinedControlUid = '1184ed87-accd-4cc3-a633-d7ab2620252d'

	Delete listuserdefinedcontrol 
	--SET SortOrder = '3',UserDefined ='0'
	WHERE  UserDefinedControlUid = 'AA0A2D88-FEA4-4BC4-9EA7-0B0049862D70' --AND Name = 'AppointmentStatusUid' 
GO

-- 45640 48361 migration script.sql
IF EXISTS (select * from listreport where name = 'quality report' and reportuid = 'D7EAF9CC-B47C-421C-8A90-B07F7EEDC496')
BEGIN
	update listreport
	set Inactive = 0
	,ReportParameters = '<ReportParameters />'
	,LastModifiedDate = '04/11/2016 00:00:00'
	where name = 'quality report' and reportuid = 'D7EAF9CC-B47C-421C-8A90-B07F7EEDC496'
END
go

if exists (select * from ListUserDefinedControl where UserDefinedControlUid = 'C34BA15E-AC45-412E-8504-1C4CD3FBF5FF')
BEGIN
	update ListUserDefinedControl
	set label = 'Diagnosis Code or Code Range'
	,ControlTypeUid = '0C9D0503-755F-4FDD-B9AB-77F1B8222D50'
	,ControlProperties = '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><CodeTable>DIAG10</CodeTable><ControlType>TEXT</ControlType><Name>DiagnosisUid</Name><DefaultText></DefaultText><MaxLength></MaxLength><MultiLine>false</MultiLine><Required>FALSE</Required></Control></UserDefinedControls>'
	,LastModifiedDate='04/11/2016 00:00:00'
	where UserDefinedControlUid = 'C34BA15E-AC45-412E-8504-1C4CD3FBF5FF'
END
go

-- 49621
IF EXISTS (select * from listuserdefinedcontrol where Name = 'ProviderUid' AND UserDefinedControlUid = '04bb2757-aa96-497d-9dc0-0fd9ebbe1fb6')
BEGIN
       Update listuserdefinedcontrol 
       SET SortOrder = '1',UserDefined ='0'
       WHERE Name = 'ProviderUid' AND UserDefinedControlUid = '04bb2757-aa96-497d-9dc0-0fd9ebbe1fb6'
END
GO

IF EXISTS (select * from listuserdefinedcontrol WHERE Name = 'AppDate' AND UserDefinedControlUid = '68cc81e4-a5d2-4daa-b38b-24032ffc8b47')
BEGIN
       Update listuserdefinedcontrol 
       SET SortOrder = '0',UserDefined ='0'
       WHERE Name = 'AppDate' AND UserDefinedControlUid = '68cc81e4-a5d2-4daa-b38b-24032ffc8b47'
END
GO

IF EXISTS (select * from listuserdefinedcontrol WHERE Name = 'CalendarUid' AND UserDefinedControlUid = '0d33246c-2617-4ce7-8271-b3983e742a18')
BEGIN
       Update listuserdefinedcontrol 
       SET SortOrder = '2',UserDefined ='0'
       WHERE Name = 'CalendarUid' AND UserDefinedControlUid = '0d33246c-2617-4ce7-8271-b3983e742a18'
END
GO

IF EXISTS (select * from listuserdefinedcontrol WHERE Name = 'ServiceSiteUid' AND UserDefinedControlUid = '1184ed87-accd-4cc3-a633-d7ab2620252d')
BEGIN
       Update listuserdefinedcontrol 
       SET SortOrder = '3',UserDefined ='0'
       WHERE Name = 'ServiceSiteUid' AND UserDefinedControlUid = '1184ed87-accd-4cc3-a633-d7ab2620252d'
END
GO

IF EXISTS (select * from listuserdefinedcontrol WHERE  UserDefinedControlUid = 'AA0A2D88-FEA4-4BC4-9EA7-0B0049862D70') 
BEGIN
      Delete listuserdefinedcontrol 
       --SET SortOrder = '3',UserDefined ='0'
       WHERE  UserDefinedControlUid = 'AA0A2D88-FEA4-4BC4-9EA7-0B0049862D70' --AND Name = 'AppointmentStatusUid' 
END
GO

-- 51134 copay report
IF EXISTS (SELECT * FROM ListUserDefinedControl WHERE userdefinedcontroluid = '807BB031-0023-4DA0-AD01-9510FE0899C5') 
BEGIN
	update ListUserDefinedControl
	set ControlProperties = '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>CP</Name><Uid>f2e52f89-7f2c-466a-a878-459f82fa12c9</Uid><Required>TRUE</Required></Control></UserDefinedControls>'
	,lastmodifieddate = '2016-09-14 20:48:40.357'
	WHERE userdefinedcontroluid = '807BB031-0023-4DA0-AD01-9510FE0899C5' --appointment date
END

-- 51415 demographics by schedule report
IF EXISTS (SELECT * FROM ListUserDefinedControl WHERE userdefinedcontroluid = '68DC7305-9162-41AC-A05D-CF1C35F9FAD5') 
BEGIN
	update ListUserDefinedControl
	set ControlProperties = '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>DSR</Name><Uid>f2e52f89-7f2c-466a-a878-459f82fa12c9</Uid><Required>TRUE</Required></Control></UserDefinedControls>'
	,LastModifiedDate = '2016-09-14 20:48:40.357'
	where UserDefinedControlUid = '68DC7305-9162-41AC-A05D-CF1C35F9FAD5'
END
GO

--Bug 53349:CMS-339 Exhibit 5 Bad Debt Report for FQHC NEW REPORT Named Bad Debt Supporting Data
--Migration
IF EXISTS (select * from listreportrdl where reportuid = 'ECF96AF0-4D59-4E79-AD8F-831B29B8B9AB' and name = 'Bad Debt Supporting Data')
BEGIN
	update listreportrdl
	set reportdefinition = 'MDOL_RPT2_FQHCBadDebt'
	,LastModifiedDate = '11/2/2016 00:00:00'
	where reportuid = 'ECF96AF0-4D59-4E79-AD8F-831B29B8B9AB' and name = 'Bad Debt Supporting Data'
END
--ListUserDefinedControl
IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = '43505955-5167-428D-8F5C-47084E1337A3' and name = 'AdjustmentType')
BEGIN
	update ListUserDefinedControl
	set ControlProperties = '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>AdjustmentType</Name><SelectType>Multi</SelectType><Conjunction>or</Conjunction><EntryNameInFindTable>Transaction Types</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListCreditType</FindTableName><Required>TRUE</Required></Control></UserDefinedControls>'
	,LastModifiedDate = '11/2/2016 00:00:00'
	where UserDefinedControlUid = '43505955-5167-428D-8F5C-47084E1337A3' and name = 'AdjustmentType'
END

IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'BEB71AC8-496F-402D-A2C9-8647DF2D96D7' and name = 'PrimaryInsuranceUid')
BEGIN
	update ListUserDefinedControl
	set ControlProperties = '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>PrimaryInsuranceUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Insurance Payer</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewInsuranceCarrier</FindTableName><Required>TRUE</Required></Control></UserDefinedControls>'
	,LastModifiedDate = '11/2/2016 00:00:00'
	where UserDefinedControlUid = 'BEB71AC8-496F-402D-A2C9-8647DF2D96D7' and name = 'PrimaryInsuranceUid'
END

IF EXISTS (select * from ListUserDefinedControl where UserDefinedControlUid = 'A690EBEC-1E41-41F3-85BD-AA9166A46901' and name = 'ServiceStartDate')
BEGIN
	update ListUserDefinedControl
	set ControlProperties = '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>ServiceStartDate</Name><Uid>f2e52f89-7f2c-466a-a878-459f82fa12c9</Uid><Required>TRUE</Required></Control></UserDefinedControls>'
	,LastModifiedDate = '11/2/2016 00:00:00'
	where UserDefinedControlUid = 'A690EBEC-1E41-41F3-85BD-AA9166A46901' and name = 'ServiceStartDate'
END
GO

-- 11/29/2016 kculberth Bug 51132 :need to inactivate the Responsible Party AR Summary as it is now obsolete
IF EXISTS (select reportuid from listreport where name = 'Responsible Party A/R Summary' and reportuid = '628AA066-EA40-4A45-803C-9D20EC28F4C6' and inactive = 0)
BEGIN
	update listreport 
	set inactive = 1 
	where name = 'Responsible Party A/R Summary' and reportuid = '628AA066-EA40-4A45-803C-9D20EC28F4C6'
END
GO

-- #56687
IF EXISTS (SELECT * FROM ListReportRdl where ReportRdlUid = '47B5594E-DD6F-4545-8C9F-CDC49122E353' AND Name = 'ERx Audit Daily Summary' and ExcelReport = 1)
BEGIN
	UPDATE ListReportRdl
	SET LastModifiedDate = '04/14/2017 00:00:00'
	,ExcelReport = 0
	WHERE ReportRdlUid = '47B5594E-DD6F-4545-8C9F-CDC49122E353' AND Name = 'ERx Audit Daily Summary' and ExcelReport = 1
END

-- migration script for any version of PRM to PRM2016 Patch A
--Product Backlog Item 56645 - Enhancements to Adjustment details report

--SortOrder 0
IF EXISTS (SELECT UserDefinedControlUid FROM ListUserDefinedControl WHERE Name = 'AdjSummary' AND UserDefinedControlUid = '91DE6E0F-6FE9-4B4B-941D-C29A79974DF7' AND UserDefinedControlGroupUid = '901C4CF8-B458-489A-B9A7-C7D0764F05A6')
BEGIN
	UPDATE ListUserDefinedControl
	set LastModifiedDate = '2017/04/17 00:00:00'
	--, Name = 'AdjSummary'
	, SortOrder = '0'
	WHERE Name = 'AdjSummary' and UserDefinedControlUid = '91DE6E0F-6FE9-4B4B-941D-C29A79974DF7' AND UserDefinedControlGroupUid = '901C4CF8-B458-489A-B9A7-C7D0764F05A6'
END

--SortOrder 1
IF EXISTS (SELECT UserDefinedControlUid FROM ListUserDefinedControl WHERE Name = 'ReportDateType' AND UserDefinedControlUid = '979B56A4-640F-4351-9E18-92FF4233E8F1' AND UserDefinedControlGroupUid = '901C4CF8-B458-489A-B9A7-C7D0764F05A6')
BEGIN
	UPDATE ListUserDefinedControl
	SET LastModifiedDate = '2017/04/17 00:00:00'
	, Name = 'DateOption'
	, ControlProperties = '<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>DateOption</Name><ButtonLabel>Posting Date</ButtonLabel><ButtonValue>PostingDate</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>DateOption</Name><ButtonLabel>Deposit Date</ButtonLabel><ButtonValue>DepositDate</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
	, SortOrder = '1'
	WHERE Name = 'ReportDateType' and UserDefinedControlUid = '979B56A4-640F-4351-9E18-92FF4233E8F1' and UserDefinedControlGroupUid = '901C4CF8-B458-489A-B9A7-C7D0764F05A6'
END

--SortOrder 2
IF EXISTS (SELECT UserDefinedControlUid FROM ListUserDefinedControl 	WHERE Name = 'FinancialCenter' and UserDefinedControlUid = '2175C82C-C1E9-48E7-84E9-F831A9E1E57E' and UserDefinedControlGroupUid = '901C4CF8-B458-489A-B9A7-C7D0764F05A6')
BEGIN
	UPDATE ListUserDefinedControl
	SET LastModifiedDate = '2017/04/17 00:00:00'
	, Name = 'FinancialCenterUid'
	, ControlProperties = '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>FinancialCenter</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Financial Center</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>FinancialCenter</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	, SortOrder = '2'
	WHERE Name = 'FinancialCenter' and UserDefinedControlUid = '2175C82C-C1E9-48E7-84E9-F831A9E1E57E' and UserDefinedControlGroupUid = '901C4CF8-B458-489A-B9A7-C7D0764F05A6'
END

--SortOrder 3
IF NOT EXISTS (SELECT UserDefinedControlUid FROM ListUserDefinedControl WHERE Name = 'ServiceSiteUid' and UserDefinedControlUid = 'A49895FE-AAD3-490E-9D57-6BF0E5912A43' and UserDefinedControlGroupUid = '901C4CF8-B458-489A-B9A7-C7D0764F05A6')
BEGIN
INSERT ListUserDefinedControl(
 	  [UserDefinedControlUid]
	, [Name]
	, [Inactive]
	, [Label]
	, [ControlTypeUid]
	, [ControlProperties]
	, [UserDefinedControlGroupUid]
	, [SortOrder]
	, [UserDefined]
	, [RDLDesigner]
	, [LastModifiedDate]
)
VALUES(
	  'a49895fe-aad3-490e-9d57-6bf0e5912a43'
	, 'ServiceSiteUid'
	, 0
	, 'Service Site'
	, '8a957d7c-8b86-4a67-8336-b830c30fd123'
	, '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ServiceSiteUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Service Site</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListServiceSite</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	, '901C4CF8-B458-489A-B9A7-C7D0764F05A6'
	, 3
	, 0
	, 0
	, '2017/04/17 00:00:00'
)
END

--SortOrder 4
IF EXISTS (SELECT UserDefinedControlUid FROM ListUserDefinedControl WHERE Name = 'SelectedProviderUIDs' and UserDefinedControlUid = '053A7651-A77D-4E13-9132-D9284F2C68DD' and UserDefinedControlGroupUid = '901C4CF8-B458-489A-B9A7-C7D0764F05A6')
BEGIN
	UPDATE ListUserDefinedControl
	SET LastModifiedDate = '2017/04/17 00:00:00'
	, Name = 'ProviderUid'
	, SortOrder = '4'
	WHERE Name = 'SelectedProviderUIDs' and UserDefinedControlUid = '053A7651-A77D-4E13-9132-D9284F2C68DD' and UserDefinedControlGroupUid = '901C4CF8-B458-489A-B9A7-C7D0764F05A6'
END

--SortOrder 5
IF EXISTS (SELECT UserDefinedControlUid FROM ListUserDefinedControl WHERE Name = 'ReportProviderType' and UserDefinedControlUid = '4AE55DF1-34D4-423F-AF2A-D9B1BCF0F5FF' and UserDefinedControlGroupUid = '901C4CF8-B458-489A-B9A7-C7D0764F05A6')
BEGIN
	UPDATE ListUserDefinedControl
	SET LastModifiedDate = '2017/04/17 00:00:00'
	, Name = 'ProviderOption'
	, ControlProperties = '<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Billing Provider</ButtonLabel><ButtonValue>BillingProvider</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Rendering Provider</ButtonLabel><ButtonValue>RenderingProvider</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
	, SortOrder = '5'
	WHERE Name = 'ReportProviderType' and UserDefinedControlUid = '4AE55DF1-34D4-423F-AF2A-D9B1BCF0F5FF' and UserDefinedControlGroupUid = '901C4CF8-B458-489A-B9A7-C7D0764F05A6'
END

--SortOrder 6
IF EXISTS (SELECT UserDefinedControlUid FROM ListUserDefinedControl WHERE Name = 'SelectedAdjustmentUIDs' and UserDefinedControlUid = 'A968BF6A-D9CB-4C45-9E47-869A65660230' and UserDefinedControlGroupUid = '901C4CF8-B458-489A-B9A7-C7D0764F05A6')
BEGIN
	UPDATE ListUserDefinedControl
	SET LastModifiedDate = '2017/04/17 00:00:00'
	, Name = 'AdjustmentUid'
	, ControlProperties = '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>AdjustmentUID</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Transaction Types</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListCreditType</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
	, SortOrder = '6'
	WHERE Name = 'SelectedAdjustmentUIDs' and UserDefinedControlUid = 'A968BF6A-D9CB-4C45-9E47-869A65660230' and UserDefinedControlGroupUid = '901C4CF8-B458-489A-B9A7-C7D0764F05A6'
END
GO

--Superbill Status Review
--Bug 57067
--Bug 56349 - Available Payer Credits amount is incorrect on the Superbill Status Review Report &
--Bug 56506 - No results displayed when Superbill Status Review generated by posting date
--ListUserDefinedControl 
--sortorder = 0
IF EXISTS (SELECT userdefinedcontroluid from ListUserDefinedControl where UserDefinedControlUid = '9550B787-6E0D-4BE5-92F1-C1ED14BD010F' and Name = 'SSR')
BEGIN
	update ListUserDefinedControl
		set SortOrder = '0'
		,LastModifiedDate = '05/02/2017 00:00:00'
	where UserDefinedControlUid = '9550B787-6E0D-4BE5-92F1-C1ED14BD010F' and Name = 'SSR'
END
--sortorder = 1
IF EXISTS (SELECT userdefinedcontroluid from ListUserDefinedControl where UserDefinedControlUid = '8DEC2355-E719-4F94-BD19-344B5CF6CB09' and Name = 'DateOption')
BEGIN
	update ListUserDefinedControl
		set SortOrder = '1'
		,LastModifiedDate = '05/02/2017 00:00:00'
	where UserDefinedControlUid = '8DEC2355-E719-4F94-BD19-344B5CF6CB09' and Name = 'DateOption'
END

--sortorder = 2
IF EXISTS (SELECT userdefinedcontroluid from ListUserDefinedControl where UserDefinedControlUid = 'C19632D3-BA54-45D5-8EB8-6756434358BC'  and Name = 'SuperbillStatusUid')
BEGIN
	update ListUserDefinedControl
		set SortOrder = '2'
		,LastModifiedDate = '05/02/2017 00:00:00'
	where UserDefinedControlUid = 'C19632D3-BA54-45D5-8EB8-6756434358BC' and Name = 'SuperbillStatusUid'
END

--sortorder = 3
IF EXISTS (SELECT userdefinedcontroluid from ListUserDefinedControl where UserDefinedControlUid = 'B44D78A4-2B6C-4D20-8997-2FC195C3ED27' and Name = 'ProviderUid')
BEGIN
	update ListUserDefinedControl
		set SortOrder = '3'
		,LastModifiedDate = '05/02/2017 00:00:00'
	where UserDefinedControlUid = 'B44D78A4-2B6C-4D20-8997-2FC195C3ED27' and Name = 'ProviderUid'
END

--sortorder = 4
IF EXISTS (SELECT userdefinedcontroluid from ListUserDefinedControl where UserDefinedControlUid = '1C8091B2-F1E3-41D3-B051-FF5313CBB96F' and Name = 'ProviderOption')
BEGIN
	update ListUserDefinedControl
		set SortOrder = '4'
		,LastModifiedDate = '05/02/2017 00:00:00'
	where UserDefinedControlUid = '1C8091B2-F1E3-41D3-B051-FF5313CBB96F' and Name = 'ProviderOption'
END

--sortorder = 5
IF EXISTS (SELECT userdefinedcontroluid from ListUserDefinedControl where UserDefinedControlUid = 'A0CAD565-1AF1-4E4C-B0D8-B245302A8C6D' and Name = 'FinancialCenterUid')
BEGIN
	update ListUserDefinedControl
		set SortOrder = '5'
		,LastModifiedDate = '05/02/2017 00:00:00'
	where UserDefinedControlUid = 'A0CAD565-1AF1-4E4C-B0D8-B245302A8C6D' and Name = 'FinancialCenterUid'
END

--sortorder = 6
IF EXISTS (SELECT userdefinedcontroluid from ListUserDefinedControl where UserDefinedControlUid = '0AA962E7-6152-4A04-A0C5-118EEAA7AB3F' and Name = 'ServiceSiteUid')
BEGIN
	update ListUserDefinedControl
		set SortOrder = '6'
		,LastModifiedDate = '05/02/2017 00:00:00'
	where UserDefinedControlUid = '0AA962E7-6152-4A04-A0C5-118EEAA7AB3F' and Name = 'ServiceSiteUid'
END

--sortorder = 7
IF EXISTS (SELECT userdefinedcontroluid from ListUserDefinedControl where UserDefinedControlUid = 'B94E412A-8131-4AA8-911C-85CE343DA456' and Name = 'PlanAccountTypeUid')
BEGIN
	update ListUserDefinedControl
	set SortOrder = '7'
		,Name = 'AccountTypeUid'
		,Label = 'Account Type'
		,ControlProperties = '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>PlanAccountTypeUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Account Type</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListAccountType</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>'
		,LastModifiedDate = '05/02/2017 00:00:00'
	where UserDefinedControlUid = 'B94E412A-8131-4AA8-911C-85CE343DA456' and Name = 'PlanAccountTypeUid'
END
IF EXISTS (SELECT userdefinedcontroluid from ListUserDefinedControl where UserDefinedControlUid = 'B94E412A-8131-4AA8-911C-85CE343DA456' and Name = 'AccountTypeUid')
BEGIN
	update ListUserDefinedControl
	set SortOrder = '7'
	where UserDefinedControlUid = 'B94E412A-8131-4AA8-911C-85CE343DA456' and Name = 'PlanAccountTypeUid'
END

--sortorder = 8
IF EXISTS (SELECT userdefinedcontroluid from ListUserDefinedControl where UserDefinedControlUid = '26E5B3C3-B84C-4A39-BB51-73FD24E68E5B' and Name = 'PatientAccountTypeUid')
BEGIN
	update ListUserDefinedControl
	set SortOrder = '8'
		,Name = 'AccountTypeOption'
		,Label = 'Account Type Option'
		,ControlTypeUid = '8E4C7B83-2EF4-4C5C-AB00-9F2564CD0B97'
		,ControlProperties = '<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>AccountTypeOption</Name><ButtonLabel>Patient</ButtonLabel><ButtonValue>Patient</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>AccountTypeOption</Name><ButtonLabel>Insurance</ButtonLabel><ButtonValue>Insurance</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>'
		,LastModifiedDate = '05/02/2017 00:00:00'
	where UserDefinedControlUid = '26E5B3C3-B84C-4A39-BB51-73FD24E68E5B' and Name = 'PatientAccountTypeUid'
END
IF EXISTS (SELECT userdefinedcontroluid from ListUserDefinedControl where UserDefinedControlUid = '26E5B3C3-B84C-4A39-BB51-73FD24E68E5B' and Name = 'AccountTypeOption')
BEGIN
	update ListUserDefinedControl
	set SortOrder = '8'
		,ControlTypeUid = '8E4C7B83-2EF4-4C5C-AB00-9F2564CD0B97'
		,LastModifiedDate = '05/02/2017 00:00:00'
	where UserDefinedControlUid = '26E5B3C3-B84C-4A39-BB51-73FD24E68E5B' and Name = 'AccountTypeOption'
END
GO

-- 56604 remove a test report 'Statements Since Last Payment'
DECLARE @ReportUid uniqueidentifier = NULL
SET @ReportUid = (select ReportUid from ListReport where name = 'Statements Since Last Payment')

IF @ReportUid IS NULL
	RETURN
ELSE
BEGIN
	DECLARE @UserDefinedControlGroupUid uniqueidentifier = NULL
	SET @UserDefinedControlGroupUid = (select UserDefinedControlGroupUid from ListReport where name = 'Statements Since Last Payment')

	IF @UserDefinedControlGroupUid IS NULL
		RETURN
	ELSE
	BEGIN
		DELETE ListReport
		WHERE ReportUid = @reportUid
		--ListReportRdl will be deleted because...cascading deletes
						
		DELETE ListUserDefinedControlGroup
		WHERE UserDefinedControlGroupUid = @UserDefinedControlGroupUid
		--ListUserDefindControl will be deleted because...cascading deletes
	END
END
GO

--Migration script  57425 update
--Bug 39897:Totals not matching on RVU Productivity Report and Work RVU Detail because RVU Detail is not including reversed/voided items
--ListUserDefinedData
--DisplayOrder 0 already set for Provider
--DisplayOrder 1 Service Site
IF EXISTS (SELECT UserDefinedDataUid FROM ListUserDefinedData WHERE UserDefinedDataUid = '5BC4D690-ACD1-49C7-B442-D3DCE4444D66' AND Name = 'Service Site')
BEGIN
   UPDATE ListUserDefinedData 
   SET DisplayOrder = 1
   WHERE UserDefinedDataUid = '5BC4D690-ACD1-49C7-B442-D3DCE4444D66' AND Name = 'Service Site'
END
--DisplayOrder 2 Financial Center
IF EXISTS (SELECT UserDefinedDataUid FROM ListUserDefinedData WHERE UserDefinedDataUid = 'E28DCCF8-7E05-4FF8-8177-CB551602E879' AND Name = 'Financial Center')
BEGIN
   UPDATE ListUserDefinedData 
   SET DisplayOrder = 2
   WHERE UserDefinedDataUid = 'E28DCCF8-7E05-4FF8-8177-CB551602E879' AND Name = 'Financial Center'
END
--DisplayOrder 3 Date
IF EXISTS (SELECT UserDefinedDataUid FROM ListUserDefinedData WHERE UserDefinedDataUid = 'A9131020-C7CA-438F-90B4-0652C816AE65' AND Name = 'Posting Date')
BEGIN
   UPDATE ListUserDefinedData 
   SET Name = 'Date'
	  ,DisplayOrder = 3 --<<<<<<<<<<<<<<<<<<<<<<
   WHERE UserDefinedDataUid = 'A9131020-C7CA-438F-90B4-0652C816AE65' AND Name = 'Posting Date'
END

--Delete extraneous ListUserDefinedData entry
IF EXISTS (SELECT UserDefinedDataUid FROM ListUserDefinedData WHERE UserDefinedDataUid = '68C41ACF-6788-4489-BB64-6C755FD79C28' AND Name = 'Service Date')
BEGIN
  DELETE ListUserDefinedData 
  WHERE UserDefinedDataUid = '68C41ACF-6788-4489-BB64-6C755FD79C28' AND Name = 'Service Date'
END

--ListUserDefinedControl
--SortOrder 0, change PostingDate to Date
IF EXISTS (SELECT UserDefinedControlUid FROM ListUserDefinedControl WHERE UserDefinedControlUid = 'f3e26de7-18b4-4a70-933b-6f0584324af2' AND Name = 'GL' AND SortOrder = 4)
BEGIN
	UPDATE ListUserDefinedControl
	SET Label = 'Date'
		,LastModifiedDate = '05/15/2017 00:00:00'
		,SortOrder = 0
	WHERE UserDefinedControlUid = 'f3e26de7-18b4-4a70-933b-6f0584324af2' AND Name = 'GL' AND SortOrder = 4
END

--SortOrder 1, Change ServiceDate timespan to Date Option radiobutton
IF EXISTS (SELECT UserDefinedControlUid FROM ListUserDefinedControl WHERE UserDefinedControlUid = 'E5C4D451-3419-4423-B8C8-071DD7C065D6' AND Name = 'WRVU' AND SortOrder = 5)
BEGIN
	UPDATE ListUserDefinedControl
	SET Name = 'DateOption'
		,Label = 'Date Option'
		,ControlTypeUid = '8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97'
		,ControlProperties = '<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>DateOption</Name><ButtonLabel>Service Date</ButtonLabel><ButtonValue>ServiceDate</ButtonValue><Default>false</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>DateOption</Name><ButtonLabel>Posting Date</ButtonLabel><ButtonValue>PostingDate</ButtonValue><Default>true</Default></Control></Controls></UserDefinedControls>'
		,LastModifiedDate = '05/15/2017 00:00:00'
		,SortOrder = 1
	WHERE UserDefinedControlUid = 'E5C4D451-3419-4423-B8C8-071DD7C065D6' AND Name = 'WRVU' AND SortOrder = 5
END
ELSE
IF EXISTS (SELECT UserDefinedControlUid FROM ListUserDefinedControl WHERE UserDefinedControlUid = 'E5C4D451-3419-4423-B8C8-071DD7C065D6' AND Name = 'DateOption' AND SortOrder = 5)
BEGIN
	UPDATE ListUserDefinedControl
	SET ControlTypeUid = '8E4C7B83-2EF4-4C5C-AB00-9F2564CD0B97'
		,ControlProperties = '<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>DateOption</Name><ButtonLabel>Service Date</ButtonLabel><ButtonValue>ServiceDate</ButtonValue><Default>false</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>DateOption</Name><ButtonLabel>Posting Date</ButtonLabel><ButtonValue>PostingDate</ButtonValue><Default>true</Default></Control></Controls></UserDefinedControls>'
		,LastModifiedDate = '05/15/2017 00:00:00'
		,SortOrder = 1
	WHERE UserDefinedControlUid = 'E5C4D451-3419-4423-B8C8-071DD7C065D6' AND Name = 'DateOption' AND SortOrder = 5
END
--SortOrder 2
IF EXISTS (SELECT UserDefinedControlUid FROM ListUserDefinedControl WHERE UserDefinedControlUid = 'a94620e3-569e-42a6-bb4f-926af5121599' AND Name = 'ProviderUid' AND SortOrder = 0)
BEGIN
	UPDATE ListUserDefinedControl
	SET LastModifiedDate = '05/15/2017 00:00:00'
		,SortOrder = 2
	WHERE UserDefinedControlUid = 'a94620e3-569e-42a6-bb4f-926af5121599' AND Name = 'ProviderUid' AND SortOrder = 0
END

--SortOrder 3
IF EXISTS (SELECT UserDefinedControlUid FROM ListUserDefinedControl WHERE UserDefinedControlUid = 'bcbcab8d-4ea6-4b4e-b7ab-3336c4c5f245' AND Name = 'ProviderOption' AND SortOrder = 1)
BEGIN
	UPDATE ListUserDefinedControl
	SET LastModifiedDate = '05/15/2017 00:00:00'
		,SortOrder = 3
	WHERE UserDefinedControlUid = 'bcbcab8d-4ea6-4b4e-b7ab-3336c4c5f245' AND Name = 'ProviderOption' AND SortOrder = 1
END

--SortOrder 4
IF EXISTS (SELECT UserDefinedControlUid FROM ListUserDefinedControl WHERE UserDefinedControlUid = '3dc42987-d780-4cf1-a8e8-d73b1ad058b3' AND Name = 'FinancialCenterUid' AND SortOrder = 2)
BEGIN
	UPDATE ListUserDefinedControl
	SET LastModifiedDate = '05/15/2017 00:00:00'
		,SortOrder = 4
	WHERE UserDefinedControlUid = '3dc42987-d780-4cf1-a8e8-d73b1ad058b3' AND Name = 'FinancialCenterUid' AND SortOrder = 2
END

--SortOrder 5
IF EXISTS (SELECT UserDefinedControlUid FROM ListUserDefinedControl WHERE UserDefinedControlUid = 'aff355a0-a122-47c4-8ee4-31834150fa23' AND Name = 'ServiceSiteUid' AND SortOrder = 3)
BEGIN
	UPDATE ListUserDefinedControl
	SET LastModifiedDate = '05/15/2017 00:00:00'
		,SortOrder = 5
	WHERE UserDefinedControlUid = 'aff355a0-a122-47c4-8ee4-31834150fa23' AND Name = 'ServiceSiteUid' AND SortOrder = 3
END

--SortOrder 6 - SET RVUScheduleUid to required
IF EXISTS (SELECT UserDefinedControlUid FROM ListUserDefinedControl WHERE UserDefinedControlUid = '5509953f-7b93-478a-9052-4eec0a30a4a6' AND Name = 'RVUScheduleUid')
BEGIN
	UPDATE ListUserDefinedControl
	SET ControlProperties = '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>RVUScheduleUid</Name><SelectType>Single</SelectType><Conjunction>none</Conjunction><EntryNameInFindTable>RVU Schedule</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>RVUSchedule</FindTableName><Required>TRUE</Required></Control></UserDefinedControls>'
		,LastModifiedDate = '05/15/2017 00:00:00'
	WHERE UserDefinedControlUid = '5509953f-7b93-478a-9052-4eec0a30a4a6' AND Name = 'RVUScheduleUid'
END

--SortOrder 7 - SET FirstLevelGroupBy to required
IF EXISTS (SELECT UserDefinedControlUid FROM ListUserDefinedControl WHERE UserDefinedControlUid = 'f6c332f4-9062-4e72-9817-d0c779d18300' AND Name = 'FirstLevelGroupBy')
BEGIN
	UPDATE ListUserDefinedControl
	SET ControlProperties = '<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>FirstLevelGroupBy</Name><SelectType>Single</SelectType><Conjunction>none</Conjunction><EntryNameInFindTable>Work RVU Detail Group 2</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>Work_RVU_Detail_Group</FindTableName><Required>TRUE</Required></Control></UserDefinedControls>'
		,LastModifiedDate = '05/15/2017 00:00:00'
	WHERE UserDefinedControlUid = 'f6c332f4-9062-4e72-9817-d0c779d18300' AND Name = 'FirstLevelGroupBy'
END

--SortOrders 8 AND 9 have no changes

--SortOrder 10 = new control, Summary checkbox 
IF NOT EXISTS (SELECT UserDefinedControlUid FROM ListUserDefinedControl WHERE UserDefinedControlUid = '25072720-66dc-4bc1-bed5-42675c70a285' AND Name = 'Summary')
BEGIN
	INSERT ListUserDefinedControl(
		[UserDefinedControlUid]
		,[Name],[Inactive]
		,[Label]
		,[ControlTypeUid]
		,[ControlProperties]
		,[UserDefinedControlGroupUid]
		,[SortOrder]
		,[UserDefined]
		,[RDLDesigner]
		,[LastModifiedDate]
	)
	VALUES(
		'25072720-66dc-4bc1-bed5-42675c70a285'
		,'Summary'
		,0
		,'Summary Only'
		,'71e67ced-b180-44e9-80c9-1ed3b47c9390'
		,'<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>CHECKBOX</ControlType><Name>Summary</Name><CheckedText>true</CheckedText><UnCheckedText>false</UnCheckedText><CheckedByDefault>false</CheckedByDefault></Control></UserDefinedControls>'
		,'589fb238-4e1a-40ae-a48c-bc002cc8d565'
		,10
		,0
		,0
		,'05/15/2017 00:00:00'
	)
END
GO

--06/16/2017 kculberth fix bug Bug 57901:Filter Attributes are missing from the Procedure Productivity Summary report
BEGIN TRY 
	BEGIN TRANSACTION
		IF EXISTS (SELECT * FROM ListUserDefinedControl uc
				   INNER JOIN ListUserDefinedControlGroup ucg oN ucg.UserDefinedControlGroupUid = uc.UserDefinedControlGroupUid
				   WHERE uc.UserDefinedControlGroupUid = '1B132100-E36C-4F47-9351-FCE99BA03CDA' and ucg.Name = 'Procedure Productivity Summary')
		BEGIN
			UPDATE ListUserDefinedControl
			SET UserDefined = 0
			WHERE UserDefinedControlGroupUid = '1B132100-E36C-4F47-9351-FCE99BA03CDA'
		END
	
		IF NOT EXISTS (SELECT * FROM ListUserDefinedControl uc
		   			   INNER JOIN ListUserDefinedControlGroup ucg oN ucg.UserDefinedControlGroupUid = uc.UserDefinedControlGroupUid
					   WHERE uc.UserDefinedControlGroupUid = '1B132100-E36C-4F47-9351-FCE99BA03CDA' and ucg.Name = 'Procedure Productivity Summary')
		BEGIN
			INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
			VALUES('4C66B129-0529-4FD4-B45E-13383791147C','PPS',0,'Date','df87d0d5-bf48-49fb-abbc-cb75cc29eb64','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TIMESPAN</ControlType><Name>PPS</Name><Uid>00000000-0000-0000-0000-000000000000</Uid></Control></UserDefinedControls>','1B132100-E36C-4F47-9351-FCE99BA03CDA',0,0,0,'11/24/2015 11:24:54 AM')

			INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
			VALUES('DC6107EF-9ABA-4FF7-B0EA-5F95F241525C','DateOption',0,'Date Option','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>DateOption</Name><ButtonLabel>Service Dates</ButtonLabel><ButtonValue>Service</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>DateOption</Name><ButtonLabel>Posting Dates</ButtonLabel><ButtonValue>Posting</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','1B132100-E36C-4F47-9351-FCE99BA03CDA',1,0,0,'11/24/2015 12:04:53 PM')

			INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
			VALUES('E8FA3ED5-EA36-40EC-8D0E-1BB91C86F715','ProviderUid',0,'Provider(s)','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProviderUids</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Provider</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ViewProvider</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','1B132100-E36C-4F47-9351-FCE99BA03CDA',2,0,0,'11/24/2015 11:33:57 AM')

			INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
			VALUES('3FD6A368-BFF8-4C05-833F-D04E5A50858D','ProviderOption',0,'Provider Option','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Rendering Provider</ButtonLabel><ButtonValue>Rendering</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>ProviderOption</Name><ButtonLabel>Billing Provider</ButtonLabel><ButtonValue>Billing</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','1B132100-E36C-4F47-9351-FCE99BA03CDA',3,0,0,'11/24/2015 12:04:53 PM')

			INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
			VALUES('45F9C5DD-B2BC-42D0-A18E-9D2A6F0AEF0E','ServiceSiteUid',0,'Service Site(s)','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>serviceSite</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Service Site</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListServiceSite</FindTableName><Required>FALSE</Required></Control></UserDefinedControls>','1B132100-E36C-4F47-9351-FCE99BA03CDA',4,0,0,'11/24/2015 11:24:54 AM')

			INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
			VALUES('42EF94AE-28D2-4F56-B8E3-B1DC8299888B','financialCenterUid',0,'Financial Center','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>financialCenterUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Financial Center</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>FinancialCenter</FindTableName></Control></UserDefinedControls>','1B132100-E36C-4F47-9351-FCE99BA03CDA',5,0,0,'11/24/2015 11:21:37 AM')

			INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
			VALUES('A790AFA7-32A4-4D86-A6F2-D0A83E5B3BEC','GroupBy',0,'Group By','8e4c7b83-2ef4-4c5c-ab00-9f2564cd0b97','<UserDefinedControls><Controls><Control><ControlType>RADIOBUTTON</ControlType><Name>GroupBy</Name><ButtonLabel>CPT</ButtonLabel><ButtonValue>CPT</ButtonValue><Default>true</Default></Control><Control><ControlType>RADIOBUTTON</ControlType><Name>GroupBy</Name><ButtonLabel>Provider</ButtonLabel><ButtonValue>Provider</ButtonValue><Default>false</Default></Control></Controls></UserDefinedControls>','1B132100-E36C-4F47-9351-FCE99BA03CDA',6,0,0,'11/24/2015 12:04:53 PM')

			INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
			VALUES('9026E348-D19D-4CCB-889E-91FB450326D6','IncludeCPTCodes',0,'Include CPT Codes','71e67ced-b180-44e9-80c9-1ed3b47c9390','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>CHECKBOX</ControlType><Name>IncludeCPTCodes</Name><CheckedText>true</CheckedText><UnCheckedText>false</UnCheckedText><CheckedByDefault>false</CheckedByDefault></Control></UserDefinedControls>','1B132100-E36C-4F47-9351-FCE99BA03CDA',7,0,0,'11/24/2015 11:24:54 AM')

			INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
			VALUES('772E6E88-7F14-4E94-A798-E71EC94123DB','ProcedureGroupUid',0,'Procedure Group(s)','8a957d7c-8b86-4a67-8336-b830c30fd123','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>FIND</ControlType><Name>ProcedureGroupUid</Name><SelectType>Multi</SelectType><Conjunction>and</Conjunction><EntryNameInFindTable>Procedure Group</EntryNameInFindTable><ColumnName>Name</ColumnName><ControlContextKey>Name</ControlContextKey><FindTableName>ListProcedureGroup</FindTableName></Control></UserDefinedControls>','1B132100-E36C-4F47-9351-FCE99BA03CDA',8,0,0,'11/24/2015 11:24:54 AM')

			INSERT ListUserDefinedControl([UserDefinedControlUid],[Name],[Inactive],[Label],[ControlTypeUid],[ControlProperties],[UserDefinedControlGroupUid],[SortOrder],[UserDefined],[RDLDesigner],[LastModifiedDate])
			VALUES('06CE504F-4718-4395-92D7-E21393858AC9','CPTCodeRange',0,'CPT Code Range','23d953d7-7438-48d0-9fd1-c950130cb558','<?xml version="1.0" encoding="utf-8"?><UserDefinedControls><Control><ControlType>TEXT</ControlType><Name>CPTCodeRange</Name><DefaultText></DefaultText><MaxLength>50</MaxLength><MultiLine>false</MultiLine></Control></UserDefinedControls>','1B132100-E36C-4F47-9351-FCE99BA03CDA',9,0,0,'11/24/2015 11:24:54 AM')
		END
		COMMIT TRANSACTION;
  END TRY
  BEGIN CATCH
	IF @@TRANCOUNT > 0
    ROLLBACK TRANSACTION;
  END CATCH
GO


-- 58753 PerformanceManagementReportMigrationScript.sql
	Update listuserdefinedcontrol 
	SET SortOrder = '0',UserDefined ='0',Label = 'Date'
	WHERE Name = 'PM' AND UserDefinedControlUid = '898ba49b-aa92-4aa0-89b2-35231ef342d7'
	GO

	Update listuserdefinedcontrol 
	SET SortOrder = '1',UserDefined ='0'
	WHERE Name = 'DateOption' AND UserDefinedControlUid = '57bb4769-d5ff-4b22-b961-d2f3e2a48995'
	GO

	Update listuserdefinedcontrol 
	SET SortOrder = '2',UserDefined ='0'
	WHERE Name = 'RefundTypeUid' AND UserDefinedControlUid = 'f9ecc54c-7d8a-4a73-bf72-9cf0e4690273'
	GO

	Update listuserdefinedcontrol 
	SET SortOrder = '3',UserDefined ='0',Label = 'Appointment Provider'
	WHERE Name = 'ProviderUid' AND UserDefinedControlUid = 'faf6c0c6-711b-4f2d-bd4f-44cd5bedc2ef'
	GO

	DELETE listuserdefinedcontrol 
	WHERE Name = 'ProviderOption' AND UserDefinedControlUid = 'FC626341-85D7-4432-8340-6880ED8B2EBB'

	Update listuserdefinedcontrol 
	SET SortOrder = '4',UserDefined ='0'
	WHERE Name = 'ProviderOption' AND  UserDefinedControlUid = '783fd06f-d7c8-45c2-9a29-9d7aab9400d4'
	GO

	
	Update listuserdefinedcontrol 
	SET SortOrder = '5',UserDefined ='0',Label = 'Service Sites'
	WHERE Name = 'ServiceSiteUid' AND UserDefinedControlUid = 'c4332800-74a7-426c-960b-b87bb7c2c168'
	GO

	Update listuserdefinedcontrol 
	SET SortOrder = '6',UserDefined ='0',Label = 'Financial Centers'
	WHERE Name = 'FinancialCenterUid' AND UserDefinedControlUid = 'dff57e87-af3d-49c1-a0c8-eb36161e2862'
	GO

	Update listuserdefinedcontrol 
	SET SortOrder = '7',UserDefined ='0'
	WHERE Name = 'RVUScheduleUid' AND UserDefinedControlUid = '918dfc00-fd63-4eed-b8dd-a6013d030649'
	GO
-- 58753 PerformanceManagementReportMigrationScript.sql	

-- #59215
update ListUserDefinedControl set label = 'CQM Reporting Year'
	where UserDefinedControlUID = '74EABDD5-BB41-48AA-B8EC-311EE73A4BFF'

update ListUserDefinedData set notes = 'Use for the 2014 Reporting Year' where UserDefinedDataUID = 'B9780D4D-7F45-4A5E-ADEB-75C7B8380489'
update ListUserDefinedData set notes = 'Use for the 2015 Reporting Year' where UserDefinedDataUID = '5656F058-3661-4101-9A96-9C62FA8E3867'
update ListUserDefinedData set notes = 'Use for the 2016 Reporting Year' where UserDefinedDataUID = 'C5F65778-BA3C-4FAB-A9BC-0D37EE2E981C'
GO