SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AllowFinancialBatchOverride]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE function [dbo].[AllowFinancialBatchOverride]
	()
	returns bit as
begin

	declare @ret bit
	declare @var int
	set @var  = cast(substring(context_info(),1,4) as int) -- get current context info value
	-- MergeData (32), ARMigration (16), PatientMerge (8), Replication UP (1) and DOWN (2) TODO: Modify process once 2011 financials stable to deal with UP conflicts (DOWN does not matter)
	-- Bit 3 (4), reserved for replication OVERRIDE - catch anyway below
	if ((@var & 32 = 32) OR (@var & 16 = 16) OR (@var & 8 = 8) OR (@var & 4 = 4) OR (@var & 2 = 2) OR (@var & 1 = 1)) -- set flags to capture bit on or off
		set @ret = 1
	else
		set @ret = 0
		
	return @ret
end

/*
 
DECLARE @testFlag INT
SET @testFlag = ??? -- which bit are we testing?
 
-- init CONTEXT_INFO for testing
DECLARE @contextInfo int
SET @contextInfo  = 128
SET CONTEXT_INFO @contextInfo

 
-- set CONTEXT_INFO (turn on bit)
DECLARE @currentContextInfo int
DECLARE @newContextInfo int
SET @currentContextInfo  = CAST(SUBSTRING(ISNULL(CONTEXT_INFO(),0),1,4) AS INT)
SET @newContextInfo = @currentContextInfo | @testFlag -- turn on bit
SET CONTEXT_INFO @newContextInfo

-- check CONTEXT_INFO
DECLARE @var int
SET @var  = CAST(SUBSTRING(ISNULL(CONTEXT_INFO(),0),1,4) AS INT)
IF (@var & @testFlag = @testFlag)
      SELECT ''SET''
ELSE
      SELECT ''NOT SET''
 
SELECT ''Allow'', dbo.AllowFinancialBatchOverride()

*/


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SplitList_Uids]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[SplitList_Uids] (@list VARCHAR(MAX), @separator VARCHAR(MAX) = '';'')  
RETURNS @table TABLE ( Value UNIQUEIDENTIFIER ) AS
	BEGIN     
		DECLARE @position INT,   
				@previous INT     
		
		SET @list = @list + @separator     
		
		SET @previous = 1     
		SET @position = CHARINDEX(@separator, @list)     
		WHILE @position > 0   
			BEGIN        
			IF @position - @previous > 0           
				INSERT INTO @table VALUES (CONVERT(UNIQUEIDENTIFIER, LTRIM(RTRIM(SUBSTRING(@list, @previous, @position - @previous)))))
				IF @position >= LEN(@list)   
					BREAK        
			SET @previous = @position + 1        
			SET @position = CHARINDEX(@separator, @list, @previous)     
	END     
	RETURN  
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsReplicating]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE function [dbo].[IsReplicating]
	()
	returns bit as
begin

	DECLARE @var int
	SET @var  = CAST(SUBSTRING(ISNULL(CONTEXT_INFO(),0),1,4) AS INT)

	IF (@var & 7 > 0) -- up, down, or override state 
		RETURN 1
	ELSE
		RETURN 0 
		
	RETURN 0 -- will never get here ... must have a closing return

end


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SystemGuid]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


-- function returning a Prm system Guid
CREATE FUNCTION [dbo].[SystemGuid] (@SystemId int)
RETURNS uniqueidentifier AS  

BEGIN  

  declare @Wrk varchar(200)
  declare @NewGUID uniqueidentifier

  if (@SystemId < 0) 
	set @SystemId = -1 * @SystemId
  set @Wrk = convert (varchar(200), @SystemId)
  while len(@Wrk) < 32 set @Wrk = ''0'' + @Wrk

  set @Wrk = ''10101010'' + ''-'' + SUBSTRING(@Wrk, 9, 4) + ''-'' + SUBSTRING(@Wrk, 13, 4) 
                              + ''-'' + SUBSTRING(@Wrk, 17, 4) + ''-'' + SUBSTRING(@Wrk, 21, 12)
  set @Wrk = ''{'' + @Wrk + ''}''
  set @NewGUID = @Wrk
  return (@NewGUID)
END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsCacheClient]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE function [dbo].[IsCacheClient] ()
	returns bit as
begin

	declare @ret bit
	IF EXISTS ( SELECT 1 FROM ReplicationSettings where Name = ''Replication.IsCacheServer'' and BoolValue = 1 )
	BEGIN
		SET @ret = 1
	END
	ELSE
	BEGIN
		SET @ret = 0
	END

	return @ret

end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Replication_IsReplicatedDB]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[Replication_IsReplicatedDB]
(
)
RETURNS BIT
AS
BEGIN
	DECLARE @Inactive BIT,
			@ReplicatedDB BIT,
			@URL VARCHAR (255)
			
	SELECT @Inactive = 0,
		   @URL = CAST (SERVERPROPERTY (''MachineName'') AS VARCHAR (255))
		
	SELECT TOP 1 @ReplicatedDB =
		CASE WHEN URL = @URL
				OR EXISTS ( 
							SELECT TOP 1 *
							FROM ListCacheMachine AS t
								INNER JOIN ReplicationSettings AS t1 ON t.URL = @URL
									AND t1.Name = ''Replication.IsCacheServer''
									AND t.CacheMachineUid = t1.GuidValue
									AND t1.BoolValue <> 0
						  )
				OR EXISTS (
							SELECT TOP 1 *
							FROM ListCacheMachine AS t
								INNER JOIN ReplicationSettings AS t1 ON t.URL = @URL
									AND t1.Name = ''Replication.STSReconfigInfo''
									AND t.CacheMachineUid = t1.GuidValue
						  )
				OR NOT EXISTS (
								SELECT TOP 1 *
								FROM ReplicationFilter
								WHERE CacheMachineUid = t.CacheMachineUid
									AND TableName = ''ListCacheMachine''
							   )
			 THEN CAST (1 AS BIT)
			 ELSE CAST (0 AS BIT)
		END
	FROM ViewListCacheMachine AS t
	WHERE URL = @URL
		AND Inactive = @Inactive

	RETURN COALESCE (@ReplicatedDB, 0)
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetChangeTrackingContextFromContextInfo]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[GetChangeTrackingContextFromContextInfo]()
RETURNS VARBINARY(128)
BEGIN

	DECLARE @extractedContextInfo VARBINARY(128);
	DECLARE @extractedContextInfoString VARCHAR(MAX)
	DECLARE @retVal VARBINARY(128);
	
	SELECT @extractedContextInfo = CAST(SUBSTRING(CONTEXT_INFO(),33, 128) AS VARBINARY(128));
	IF (NOT @extractedContextInfo IS NULL AND @extractedContextInfo<>CAST('''' AS VARBINARY(128)))
		SET @retVal = @extractedContextInfo;
		
	RETURN @retVal;
	
END

/*
	DECLARE @contextInfo VARBINARY(128);
	DECLARE @contextInfoString VARCHAR(MAX);
	DECLARE @changeTrackingContextString VARCHAR(MAX);
	DECLARE @bitField INT;

	SELECT @bitField = 128;
	SELECT @changeTrackingContextString = '''';
	--SELECT @changeTrackingContextString = ''BrettBrettBrettBrettBret'';

	SET @contextInfoString = CAST(CAST(@bitField AS BINARY(4)) AS VARCHAR(MAX)) 
		+ CAST(CAST('''' AS BINARY(28)) AS VARCHAR(MAX))
		+ CAST(CAST(@changeTrackingContextString AS BINARY(24)) AS VARCHAR(MAX)); 
	SET @contextInfo = CAST(@contextInfoString AS BINARY(128));

	SET CONTEXT_INFO @contextInfo;
	SELECT CONTEXT_INFO()
	
	SELECT dbo.GetChangeTrackingContextFromContextInfo(), CAST(dbo.GetChangeTrackingContextFromContextInfo() AS VARCHAR(MAX))
*/




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAccountRPBalanceInCollections]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetAccountRPBalanceInCollections]  
(  
 @AccountResponsiblePartyUid UNIQUEIDENTIFIER  
)  
RETURNS  
	MONEY  
AS  
BEGIN  
	DECLARE @AccountBalance money  
	SELECT @AccountBalance = Sum(VSA.LiabilityBalance - VSA.AssignedLiabilityBalance)  
		FROM AR_ViewSuperbillAggregate VSA
			INNER JOIN Superbill SB ON VSA.SuperbillUid =SB.SuperbillUid AND (NOT SB.DateEnteredAutomatedCollections IS NULL 
				AND SB.DateLeftAutomatedCollections IS NULL)
			INNER JOIN Account A ON SB.AccountUid = A.AccountUid 
		WHERE 
			A.AccountResponsiblePartyUid = @AccountResponsiblePartyUid 
		
	RETURN ISNULL(@AccountBalance, 0)  
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetCollectionStatusLevelForAccountResponsibleParty]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetCollectionStatusLevelForAccountResponsibleParty]
(
	@AccountResponsiblePartyUid uniqueidentifier,
	@CollectionStatusUid				uniqueidentifier
)
RETURNS uniqueidentifier
AS
BEGIN
DECLARE @CurrentBalance money
SET @CurrentBalance = dbo.GetAccountRPBalanceInCollections(@AccountResponsiblePartyUid)
DECLARE @CollectionStatusLevelUid uniqueidentifier
SELECT
	@CollectionStatusLevelUid = CollectionStatusLevelUid
FROM
	CollectionStatusLevel
WHERE
		CollectionStatusUid = @CollectionStatusUid AND Inactive=0
AND	(
			@CurrentBalance >= BalanceFrom
			AND
			(
				(
						GreaterThan = 0
					AND
						@CurrentBalance <= BalanceTo
				)
				OR
				(
						GreaterThan = 1
				)
			)
		)
RETURN @CollectionStatusLevelUid
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAccountResponsiblePartyOriginalCollectionsBalance]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetAccountResponsiblePartyOriginalCollectionsBalance]
(
	@AccountResponsiblePartyUid uniqueidentifier
)
RETURNS
	money
AS
BEGIN
DECLARE	@AccountBalance money
SELECT
	@AccountBalance = Sum(EnteringCollectionsPatientBalance)
FROM
	SuperbillsInAutomatedCollections sic
INNER JOIN
	Superbill s ON
		sic.SuperbillUid = s.SuperbillUid
WHERE
	sic.AccountResponsiblePartyUid = @AccountResponsiblePartyUid

RETURN isnull(@AccountBalance, 0)
END' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ConvertUTCToLocalTime]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ConvertUTCToLocalTime](@utcTime [datetime])
RETURNS [datetime] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[ConvertUTCToLocalTime]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsWeekDay]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/15/2016
-- Description:	Returns "1" when the current date is "Monday" thur
--				"Friday" and "0" when "Sunday" or "Saturday".
--
--				For translated C# code: see business object 
--				"RelCalendarCalendarTemplateHead.cs";
--				function "IsWeekDay(DateTime oDate)"
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[IsWeekDay](
		@currentDate DATE
		)

RETURNS bit
AS
begin
	declare @isWeekDay bit = 1

	declare @DayOfWeek int = DATEPART(WEEKDAY, @currentDate) -- 1 = Sunday; 2 = Monday; 3 = Tuesday...Saturday = 7

	if ((@DayOfWeek = 1) or (@DayOfWeek = 7))
	begin
		set @isWeekDay = 0
	end

	return @isWeekDay
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetLastDayofMonth]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/15/2016
-- Description:	For translated C# code: see business object 
--				"RelCalendarCalendarTemplateHead.cs";	
--				functions "GetLastDayofMonth(DateTime currentDate, bool isWeekDay)"
--				and "GetLastDayofMonth(DateTime currentDate, DayOfWeek dow)"
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[GetLastDayofMonth](
		@currentDate DATE,
		@isWeekDay bit,
		@dayOfWeek int
		)

RETURNS DATE
AS
begin
	set @currentDate = DATEADD (month, 1, @currentDate)
	set @currentDate = CONVERT(varchar(20), DATEPART(month, @currentDate)) + ''/1/'' +
							CONVERT(varchar(20), DATEPART(year, @currentDate))
	set @currentDate = DATEADD(day, -1, @currentDate)

	if (@isWeekDay is not null)
	begin
		while (((@isWeekDay = 1) and (dbo.IsWeekDay(@currentDate) = 0))
				OR
			   ((@isWeekDay = 0) and (dbo.IsWeekDay(@currentDate) = 1)))
		begin
			set @currentDate = DATEADD(day, -1, @currentDate)
		end -- of while
	end -- of if (@isWeekDay is not null)
	else if (@dayOfWeek is not null)
	begin
		while ((DATEPART(WEEKDAY, @currentDate) <> @dayOfWeek))
		begin
			set @currentDate = DATEADD(day, -1, @currentDate)
		end
	end

	return @currentDate
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetNDayofMonth]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/15/2016
-- Description:	For translated C# code: see business object 
--				"RelCalendarCalendarTemplateHead.cs";	
--				functions "GetNDayofMonth(int iN, DateTime currentDate, bool isWeekDay)"
--				and "GetNDayofMonth(int iN, DateTime currentDate, DayOfWeek dow)"
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[GetNDayofMonth](
		@iN int,
		@currentDate DATE,
		@isWeekDay bit,
		@dayOfWeek int
		)

RETURNS
	DateTime
AS
begin
	
	if (@isWeekDay is not null)
	begin
		set @currentDate = CONVERT(varchar(20), DATEPART(month, @currentDate)) + ''/1/'' +
								CONVERT(varchar(20), DATEPART(year, @currentDate))
		
		while (((@isWeekDay = 1) and (dbo.IsWeekDay(@currentDate) = 0))
				OR
			  ((@isWeekDay = 0) and (dbo.IsWeekDay(@currentDate) = 1)))
		begin
			set @currentDate = DATEADD(day, 1, @currentDate)
		end -- of while

		while (@iN > 0)
		begin
			set @currentDate = DATEADD(day, 1, @currentDate)
			if (((@isWeekDay = 1) and (dbo.IsWeekDay(@currentDate) = 1))
				 OR
			   ((@isWeekDay = 0) and (dbo.IsWeekDay(@currentDate) = 0)))
			begin
				set @iN = @iN - 1
			end
		end -- of while
	end -- of if (@isWeekDay is not null)
	else if (@dayOfWeek is not null)
	begin
		declare @oldCurrentDate DateTime = @currentDate
		set @currentDate = CONVERT(varchar(20), DATEPART(month, @currentDate)) + ''/1/'' +
								CONVERT(varchar(20), DATEPART(year, @currentDate))

		while (DATEPART(WEEKDAY, @currentDate) <> @dayOfWeek)
		begin
			set @currentDate = DATEADD(day, 1, @currentDate)
		end

		while (@iN > 0)
		begin
			set @currentDate = DATEADD(day, 7, @currentDate)
			set @iN = @iN - 1
		end -- of while
	end -- if (@dayOfWeek is not null)

	return @currentDate
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetDateForMonth]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/15/2016
-- Description:	For translated C# code: see business object 
--				"RelCalendarCalendarTemplateHead.cs";	
--				functions "GetDateForMonth(int iPrefix, DateTime currentDate, bool isWeekDay)"
--				and "GetDateForMonth(int iPrefix, DateTime currentDate, DayOfWeek dow)"
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[GetDateForMonth](
		@iPrefix int,
		@currentDate DATE,
		@isWeekDay bit,
		@dayOfWeek int,
		@StartDate DATE
		)

RETURNS DATE
AS
begin
if (@iPrefix = 0) -- last
	begin
		set @currentDate = dbo.GetLastDayofMonth(@currentDate, @isWeekDay, @dayOfWeek)
		if (@currentDate < @StartDate)
		begin
			set @currentDate = dbo.GetLastDayofMonth(DATEADD(month, 1, @currentDate), @isWeekDay, @dayOfWeek)
		end
		else begin
			set @currentDate = dbo.GetNDayofMonth(@iPrefix - 1, @currentDate, @isWeekDay, @isWeekDay)
		end
	end

	return @currentDate
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetNextDateForMonthOption2]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/15/2016
-- Description:	For translated C# code: see business object 
--				"RelCalendarCalendarTemplateHead.cs";
--				method "GetNextDateForMonthOption2(int iPrefix, Guid gUnit, DateTime currentDate)"
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[GetNextDateForMonthOption2](
		@iPrefix int,
		@gUnit uniqueidentifier,
		@currentDate DATE,
		@StartDate DATE
		)

RETURNS DATE
AS
begin
	if (@gUnit = CONVERT(uniqueidentifier, ''F1E71F1B-8025-4875-9DFC-141BCEAF3444'')) -- day
	begin
		if (@iPrefix = 0) -- last day of the month
		begin
			set @currentDate = CONVERT(varchar(20), DATEPART(month, @currentDate)) + ''/1/'' +
									CONVERT(varchar(20), DATEPART(year, @currentDate))
			set @currentDate = DATEADD(month, 1, @currentDate)
			set @currentDate = DATEADD(day, -1, @currentDate)
		end
		else begin
			if (@iPrefix < DATEPART(day, @currentDate))
			begin
				set @currentDate = DATEADD(month, 1, @currentDate)
			end
			set @currentDate = CONVERT(varchar(20), DATEPART(month, @currentDate)) + ''/1/'' +
					CONVERT(varchar(20), DATEPART(year, @currentDate))
			
			set @currentDate = DATEADD(day, @iPrefix - 1, @currentDate)
		end
	end
	else if (@gUnit = CONVERT(uniqueidentifier, ''B3121D9E-9769-4831-8F4E-0678E3F49C13'')) -- weekday
	begin
		set @currentDate = dbo.GetDateForMonth(@iPrefix, @currentDate, 1, null, @StartDate);
	end
	else if (@gUnit = CONVERT(uniqueidentifier, ''EED139E3-4D95-45B4-95BE-50F6B619D43B'')) -- weekday day
	begin
		set @currentDate = dbo.GetDateForMonth(@iPrefix, @currentDate, 0, null, @StartDate);
	end
	else if (@gUnit = CONVERT(uniqueidentifier, ''F0917C45-D974-46D5-B914-57B8E602362B'')) -- Sunday
	begin
		set @currentDate = dbo.GetDateForMonth(@iPrefix, @currentDate, null, 1, @StartDate);
	end
	else if (@gUnit = CONVERT(uniqueidentifier, ''B4658BCB-78BF-46DD-A1F8-52021AC160E1'')) -- Monday
	begin
		set @currentDate = dbo.GetDateForMonth(@iPrefix, @currentDate, null, 2, @StartDate);
	end
	else if (@gUnit = CONVERT(uniqueidentifier, ''F5B6EC8F-FFA2-4489-A916-9916BE193ECC'')) -- Tuesday
	begin
		set @currentDate = dbo.GetDateForMonth(@iPrefix, @currentDate, null, 3, @StartDate);
	end
	else if (@gUnit = CONVERT(uniqueidentifier, ''DA34F712-ED05-455F-97C8-0C6B8DC49C4F'')) -- Wednesday
	begin
		set @currentDate = dbo.GetDateForMonth(@iPrefix, @currentDate, null, 4, @StartDate);
	end
	else if (@gUnit = CONVERT(uniqueidentifier, ''F15B441F-054F-4A74-BB14-4441BA6DE158'')) -- Thursday
	begin
		set @currentDate = dbo.GetDateForMonth(@iPrefix, @currentDate, null, 5, @StartDate);
	end
	else if (@gUnit = CONVERT(uniqueidentifier, ''CF007109-4E97-435A-A37C-F0DAFBFD7DBE'')) -- Friday
	begin
		set @currentDate = dbo.GetDateForMonth(@iPrefix, @currentDate, null, 6, @StartDate);
	end
	else if (@gUnit = CONVERT(uniqueidentifier, ''3C47E0D9-0A04-4420-99B7-496E319900C5'')) -- Saturday
	begin
		set @currentDate = dbo.GetDateForMonth(@iPrefix, @currentDate, null, 7, @StartDate);
	end
	return @currentDate
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CheckMonthlyAssignmentStateOption2]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/15/2016
-- Description: For translated C# code: see business object 
--				"RelCalendarCalendarTemplateHead.cs";
--				function "CheckMonthlyAssignmentStateOption2
--					(XmlDocument xmlDoc, DateTime oDate, out int offset)"
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[CheckMonthlyAssignmentStateOption2](
		@SearchDate DATE,
		@NumDays int,
		@iMonth int,
		@gPrefix uniqueidentifier,
		@gUnit uniqueidentifier,
		@StartDate Date,
		@EndDate Date
		)

RETURNS
@Result Table
	(
		Found bit default (0),
		DaysOffset int default (-1)
	)
begin
	declare @daysOffset int = -1
	declare @found bit = 0
	declare @i int
	declare @iPrefix int
	declare @nextDate DATE
	declare @currentMonthDate DATE
	declare @currentDate DATE = @StartDate
	
	set @currentDate = @StartDate

	set @iPrefix = 1 -- first - CalendarTemplateAssignmentDayPrefix
	if (@gPrefix = CONVERT(uniqueidentifier, ''F933AF8A-D703-499A-B940-827A0D2224A2''))
	begin
		set @iPrefix = 2 -- second - CalendarTemplateAssignmentDayPrefix
	end
	else if (@gPrefix = CONVERT(uniqueidentifier, ''23E2E9F2-8496-475B-85F8-9F70768E68D4''))
	begin
		set @iPrefix = 3 -- third - CalendarTemplateAssignmentDayPrefix
	end
	else if (@gPrefix = CONVERT(uniqueidentifier, ''423085E1-8C4E-4542-A95F-C205B16D524C''))
	begin
		set @iPrefix = 4 -- fourth - CalendarTemplateAssignmentDayPrefix
	end 
	else if (@gPrefix = CONVERT(uniqueidentifier, ''57D0D8DA-8EC6-40DD-BFBC-FCE228ABF107''))
	begin
		set @iPrefix = 5 -- fifth - CalendarTemplateAssignmentDayPrefix
	end 
	else if (@gPrefix = CONVERT(uniqueidentifier, ''8036F9D3-E596-4830-88BB-A247500805AA''))
	begin
		set @iPrefix = 0 -- last - CalendarTemplateAssignmentDayPrefix
	end

	-- goto the first valid Start Date based on the parameters
	set @currentDate = dbo.GetNextDateForMonthOption2(@iPrefix, @gUnit, @currentDate, @StartDate)
	
	declare @stopWhile bit = 0
	while ((@stopWhile = 0) and ((@EndDate is null) OR (@currentDate <= @EndDate)))
	begin
		set @nextDate = dbo.GetNextDateForMonthOption2(@iPrefix, @gUnit, DATEADD(month, @iMonth, @currentDate), @StartDate)

		if (@SearchDate > @nextDate)
		begin
			set @currentDate = @nextDate
		end
		else if (@SearchDate < @currentDate)
		begin
			set @stopWhile = 1
			break
		end
		else begin
			set @i = 0
			while ((@i < @NumDays) and (@stopWhile = 0))
			begin
				set @currentMonthDate = DATEADD(day, @i, @currentDate)

				if ((@SearchDate >= @currentMonthDate) and (@SearchDate < DATEADD(day, @NumDays, @currentDate)))
				begin
					if ((@gPrefix = CONVERT(uniqueidentifier, ''57D0D8DA-8EC6-40DD-BFBC-FCE228ABF107'')) and 
						(
							(@gUnit =  CONVERT(uniqueidentifier, ''F0917C45-D974-46D5-B914-57B8E602362B'')) -- Sunday
							or (@gUnit =  CONVERT(uniqueidentifier, ''B4658BCB-78BF-46DD-A1F8-52021AC160E1'')) -- Monday
							or (@gUnit =  CONVERT(uniqueidentifier, ''F5B6EC8F-FFA2-4489-A916-9916BE193ECC'')) -- Tuesday
							or (@gUnit =  CONVERT(uniqueidentifier, ''DA34F712-ED05-455F-97C8-0C6B8DC49C4F'')) -- Wednesday
							or (@gUnit =  CONVERT(uniqueidentifier, ''F15B441F-054F-4A74-BB14-4441BA6DE158'')) -- Thursday
							or (@gUnit =  CONVERT(uniqueidentifier, ''CF007109-4E97-435A-A37C-F0DAFBFD7DBE'')) -- Friday
							or (@gUnit =  CONVERT(uniqueidentifier, ''3C47E0D9-0A04-4420-99B7-496E319900C5'')) -- Saturday
						)
					   )
					begin
						declare @tempMonthDate DATE = DATEADD(day, -28, @SearchDate)
						if (DATEPART(month, @tempMonthDate) = DATEPART(month, @SearchDate))
						begin
							set @daysOffset = DATEDIFF(day, @SearchDate, @currentMonthDate)
							set @found = 1
							set @stopWhile = 1
							break
						end
						else begin
							set @stopWhile = 1
						end
					end -- of if ((@gPrefix = CONVERT(uniqueidentifier, ''57D0D8DA-8EC6-40DD-BFBC-FCE228ABF107'')) and ...
					else begin			
						set @daysOffset = DATEDIFF(day, @SearchDate, @currentMonthDate) + 1
						set @found = 1
						set @stopWhile = 1
					end
				end -- of if ((@SearchDate >= @currentMonthDate) and (@SearchDate < DATEADD(day, @NumDays, @currentDate)))

				set @i = @i + 1
			end -- of while ((@i < @NumDays) and (@stopWhile = 0))

			set @currentDate = @nextDate
		end

	end -- of while ((@stopWhile = 0) and ((@EndDate is null) OR (@currentDate <= @EndDate)))

	insert into @Result (Found, DaysOffset) values (@found, @daysOffset)

	return 
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetNextDateForMonthOption1]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/15/2016
-- Description:	For translated C# code: see business object 
--				"RelCalendarCalendarTemplateHead.cs";
--				method "GetNextDateForMonthOption1(int iDay, DateTime currentDate)"
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[GetNextDateForMonthOption1](
		@iDay int,
		@currentDate DATE
		)

RETURNS DATE
AS
begin
	declare @iCurrentMonth int

	if (@iDay < DATEPART(day, @currentDate))
	begin
		set @currentDate = DATEADD(month, 1, @currentDate)
	end

	set @currentDate = CONVERT(varchar(20), DATEPART(month, @currentDate)) + ''/1/'' +
					CONVERT(varchar(20), DATEPART(year, @currentDate))
					
	set @iCurrentMonth = DATEPART(month, @currentDate)
	set @currentDate = DATEADD(day, @iDay - 1, @currentDate)

	if (DATEPART(month, @currentDate) > @iCurrentMonth)
	begin
		set @currentDate = CONVERT(varchar(20), DATEPART(month, @currentDate)) + ''/1/'' +
					CONVERT(varchar(20), DATEPART(year, @currentDate))
		set @currentDate = DATEADD(day, -1, @currentDate)
	end

	return @currentDate
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CheckMonthlyAssignmentStateOption1]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/15/2016
-- Description:	For translated C# code: see business object
--				"RelCalendarCalendarTemplateHead.cs";
--				function "CheckMonthlyAssignmentStateOption1
--					(XmlDocument xmlDoc, DateTime oDate, out int offset)"
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[CheckMonthlyAssignmentStateOption1](
		@SearchDate DATE,
		@NumDays int,
		@iDay int,
		@iMonth int,
		@StartDate Date,
		@EndDate Date
		)

RETURNS
@Result Table
	(
		Found bit default (0),
		DaysOffset int default (-1)
	)
begin

	declare @daysOffset int = -1
	declare @found bit = 0
	declare @i int
	declare @currentDate Date = @StartDate

	set @currentDate = dbo.GetNextDateForMonthOption1(@iDay, @currentDate)

	while ((@EndDate is null) or (@currentDate <= @EndDate))
	begin
		declare @nextDate DATE= dbo.GetNextDateForMonthOption1(@iDay, DATEADD(month, @iMonth, @currentDate))
						
		if (@SearchDate > @nextDate)
		begin
			set @currentDate = @nextDate -- skip to next occurrence
		end
		else if (@SearchDate < @currentDate)
		begin
			break
		end
		else begin
			set @i = 0
			while (@i < @NumDays)
			begin
				declare @currentMonthDate DATE = DATEADD(day, @i, @currentDate)
				if ((@SearchDate >= @currentMonthDate) and (@SearchDate < DATEADD(day, @NumDays, @currentDate)))
				begin
					set @DaysOffset = DATEDIFF(day, @currentMonthDate, @SearchDate) + 1
					set @found = 1
					break
				end

				set @i = @i + 1
			end -- of while (@i < @NumDays)
		end
					
		if (@found = 1)
		begin
			break
		end	
		set @currentDate = @nextDate

	end -- while ((@EndDate is null) or (@SearchDate <= @EndDate))

	insert into @Result (Found, DaysOffset) values (@found, @daysOffset)

	return 
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CheckWeeklyAssignmentState]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/15/2016
-- Description:	For translated C# code: see business object 
--				"RelCalendarCalendarTemplateHead.cs";
--				function "CheckWeeklyAssignmentState(DateTime oDate, out int offset)"
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[CheckWeeklyAssignmentState](
		@SearchDate DATE,
		@NumDays int,
		@RecurrencePattern varchar(max),
		@StartDate Date,
		@EndDate Date
		)

RETURNS
@Result Table
	(
		Found bit default (0),
		DaysOffset int default (-1)
	)
begin
	-- <monthly radio="1" day="1" month="1" />
	declare @daysOffset int = -1
	declare @found bit = 0
	declare @i int
	declare @currentDate Date = @StartDate
	
	declare @iWeeks int
	declare @bMonday int
	declare @bTusesday int
	declare @bWednesday int
	declare @bThursday int
	declare @bFriday int
	declare @bSaturday int
	declare @bSunday int

	-- this is a weekly assigment, need to get xml values
	declare @xmlDay xml = @RecurrencePattern
	SELECT  
		@iWeeks = Tbl.Col.value(''@weeks'', ''smallint''),
		@bMonday = Tbl.Col.value(''@mon'', ''smallint''),
		@bTusesday = Tbl.Col.value(''@tue'', ''smallint''),
		@bWednesday = Tbl.Col.value(''@wed'', ''smallint''),
		@bThursday = Tbl.Col.value(''@thu'', ''smallint''),
		@bFriday = Tbl.Col.value(''@fri'', ''smallint''),
		@bSaturday = Tbl.Col.value(''@sat'', ''smallint''),
		@bSunday = Tbl.Col.value(''@sun'', ''smallint'')
	FROM   @xmlDay.nodes(''//weekly'') Tbl(Col)
	
	while ((@EndDate is null) or (@currentDate <= @EndDate))
	begin
		if (@SearchDate > DATEADD(day, 7 + @NumDays, @currentDate))
		begin
			set @currentDate = DATEADD(day, 7 * @iWeeks, @currentDate) -- skip to the next occurrence
		end
		else if (@SearchDate < @currentDate)
		begin
			set @found = 0
			break
		end
		else begin
			set @i = 0
			while (@i < 7)
			begin
				declare @currentWeekDate Date = DATEADD(day, @i, @currentDate)
				declare @dayOfWeek int = DATEPART(WEEKDAY, @currentWeekDate)
				if (@dayOfWeek = 1 and @bSunday <> 0)
				begin
					if (@SearchDate >= @currentWeekDate and @SearchDate < DATEADD(day, @NumDays, @currentWeekDate))
					begin
						set @found = 1
					end
				end
				else if (@dayOfWeek = 2 and @bMonday <> 0)
				begin
					if (@SearchDate >= @currentWeekDate and @SearchDate < DATEADD(day, @NumDays, @currentWeekDate))
					begin
						set @found = 1
					end
				end
				else if (@dayOfWeek = 3 and @bTusesday <> 0)
				begin
					if (@SearchDate >= @currentWeekDate and @SearchDate < DATEADD(day, @NumDays, @currentWeekDate))
					begin
						set @found = 1
					end
				end
				else if (@dayOfWeek = 4 and @bWednesday <> 0)
				begin
					if (@SearchDate >= @currentWeekDate and @SearchDate < DATEADD(day, @NumDays, @currentWeekDate))
					begin
						set @found = 1
					end
				end
				else if (@dayOfWeek = 5 and @bThursday <> 0)
				begin
					if (@SearchDate >= @currentWeekDate and @SearchDate < DATEADD(day, @NumDays, @currentWeekDate))
					begin
						set @found = 1
					end
				end
				else if (@dayOfWeek = 6 and @bFriday <> 0)
				begin
					if (@SearchDate >= @currentWeekDate and @SearchDate < DATEADD(day, @NumDays, @currentWeekDate))
					begin
						set @found = 1
					end
				end
				else if (@dayOfWeek = 7 and @bSaturday <> 0)
				begin
					if (@SearchDate >= @currentWeekDate and @SearchDate < DATEADD(day, @NumDays, @currentWeekDate))
					begin
						set @found = 1
					end
				end

				if (@found = 1)
				begin
					set @daysOffset = DATEDIFF(day, @currentWeekDate, @SearchDate) + 1
					break
				end
				set @i = @i + 1
			end -- of while (@i < 7)
			
			set @currentDate = DATEADD(day, 7 * @iWeeks, @currentDate)
		end
						
		if (@found = 1)
			break

	end -- of while ((@EndDate is null) or (@SearchDate <= @EndDate))

	insert into @Result (Found, DaysOffset) values (@found, @daysOffset)

	return 
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetStartEndTime]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/11/2016
-- Description:	Returns the start time and end time and are the 
--				number of minutes after mid night.
--
--				The below function is a emulation of the C# code 
--				found in “CalendarUtilities.cs”; functions 
--				“GetStartTime” and “GetEndTime”.
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[GetStartEndTime](
		@CalendarUid uniqueidentifier,	-- calendar to be searched
		@SearchDate DATE				-- date to find start time and end time
		)

RETURNS
@StartEndTime table
(
	StartTime int,			-- number of minutes after mid night
	EndTime int,			-- number of minutes after mid night
	DisplayInterval int,	-- number of minutes in an appointment slot
	IsOpen bit default (0),
	CalendarTemplateDayUid uniqueidentifier
)
AS
begin
	declare @found bit = 0
	declare @RecurrencePattern varchar(max)
	declare @StartDate Date
	declare @EndDate Date
	declare @NumDays int
	declare @CalendarTemplateHeadUid uniqueidentifier
	declare @DaysOffset int = -1

	declare rel_cursor cursor for 
			select rel.RecurrencePattern, rel.StartDate, rel.EndDate, lcth.NumDays, lcth.CalendarTemplateHeadUid
			from RelCalendarCalendarTemplateHead rel
				inner join ListCalendarTemplateHead lcth on rel.CalendarTemplateHeadUid = lcth.CalendarTemplateHeadUid
			where rel.CalendarUid = @CalendarUid 
				and rel.StartDate <= @SearchDate 
				and (rel.EndDate >= @SearchDate or rel.EndDate is null)
			order by rel.ZIndex desc

	open rel_cursor

	fetch NEXT from rel_cursor into @RecurrencePattern, @StartDate, @EndDate, @NumDays, @CalendarTemplateHeadUid

	while (@@fetch_status <> -1)
	begin
		if (@@fetch_status <> -2)
		begin
			-- While loop is based on C# code: see business object "RelCalendarCalendarTemplateHead.cs";
			-- function "GetCalendarTemplateDay(DateTime oDate)"

			if (@RecurrencePattern is null) -- continuous
			begin
				set @DaysOffset = DATEDIFF(day, @StartDate, @SearchDate) + 1
				if (@DaysOffset > @NumDays)
				begin
					set @DaysOffset = @DaysOffset % @NumDays
					if (@DaysOffset = 0)
					begin
						set @DaysOffset = @NumDays
					end
				end
				set @found = 1
			end
			else if (SUBSTRING(@RecurrencePattern, 1, 2) = ''<w'') -- weekly
			begin
				select @found = Found, @DaysOffset = DaysOffset 
						from dbo.CheckWeeklyAssignmentState(@SearchDate, @NumDays, @RecurrencePattern, @StartDate, @EndDate)
			end
			else if (SUBSTRING(@RecurrencePattern, 1, 2) = ''<m'') -- monthly
			begin
				set @DaysOffset = -1;
				declare @xmlMonthly xml = @RecurrencePattern

				declare @option1 int
				declare @iDay int
				declare @iMonth int
				declare @gPrefix uniqueidentifier
				declare @gUnit uniqueidentifier
				
				-- get xml data
				SELECT 
					@option1 = Tbl.Col.value(''@radio'', ''smallint''),
					@iDay = Tbl.Col.value(''@day'', ''smallint''),
					@iMonth = Tbl.Col.value(''@month'', ''smallint''),
					@gPrefix = Tbl.Col.value(''@prefix'', ''uniqueidentifier''),
					@gUnit = Tbl.Col.value(''@unit'', ''uniqueidentifier'')
				FROM @xmlMonthly.nodes(''//monthly'') Tbl(Col)

				if (@option1 = 1)
				begin
					select @found = Found, @DaysOffset = DaysOffset 
						from dbo.CheckMonthlyAssignmentStateOption1(@SearchDate, @NumDays, @iDay, @iMonth, @StartDate, @EndDate)
				end
				else begin
					-- <monthly radio="2" month="1" prefix="2a68f31d-1a22-4384-8ae7-ace1488bbd72" unit="b3121d9e-9769-4831-8f4e-0678e3f49c13" />
					select @found = Found, @DaysOffset = DaysOffset 
						from dbo.CheckMonthlyAssignmentStateOption2(@SearchDate, @NumDays, @iMonth, @gPrefix, @gUnit, @StartDate, @EndDate)
				end

			end -- of if (SUBSTRING(@RecurrencePattern, 1, 2) = ''<m'')
			else if (SUBSTRING(@RecurrencePattern, 1, 2) = ''<d'')
			begin
				set @found = 1
				break
			end -- of if (SUBSTRING(@RecurrencePattern, 1, 2) = ''<d'')
		end
	
		if (@found = 1)
			break

		fetch NEXT from rel_cursor into @RecurrencePattern, @StartDate, @EndDate, @NumDays, @CalendarTemplateHeadUid

	end -- of while
		
	close rel_cursor
	deallocate rel_cursor

	declare @StartTime int
	declare @EndTime int
	declare @DisplayInterval int
	declare @IsOpen bit = 1
	declare @CalendarTemplateDayUid uniqueidentifier

	select @StartTime = lctd.StartTime, @IsOpen = lctd.IsOpen, @CalendarTemplateDayUid = lctd.CalendarTemplateDayUid
		from ListCalendarTemplateDay lctd
		where lctd.CalendarTemplateHeadUid = @CalendarTemplateHeadUid
			and lctd.Inactive = 0
			and lctd.TemplateDay = @DaysOffset
	
	if (@StartTime is null)
	begin
		select @StartTime = lcth.StartTime
		from ListCalendarTemplateHead lcth
		where lcth.CalendarTemplateHeadUid = @CalendarTemplateHeadUid
		and lcth.Inactive = 0
	end

	if (@StartTime is null)
	begin
		select @StartTime = lc.StartTime
		from ListCalendar lc 
		where lc.CalendarUid = @CalendarUid
			and lc.Inactive = 0
	end

	select @EndTime = lctd.EndTime, @IsOpen = lctd.IsOpen
		from ListCalendarTemplateDay lctd
		where lctd.CalendarTemplateHeadUid = @CalendarTemplateHeadUid
			and lctd.Inactive = 0
			and lctd.TemplateDay = @DaysOffset
	
	if (@EndTime is null)
	begin
		select @EndTime = lcth.EndTime
		from ListCalendarTemplateHead lcth
		where lcth.CalendarTemplateHeadUid = @CalendarTemplateHeadUid
		and lcth.Inactive = 0
	end

	if (@EndTime is null)
	begin
		select @EndTime = lc.EndTime
		from ListCalendar lc 
		where lc.CalendarUid = @CalendarUid
			and lc.Inactive = 0
	end

	select @DisplayInterval = lcth.DisplayInterval
	from ListCalendarTemplateHead lcth
	where lcth.CalendarTemplateHeadUid = @CalendarTemplateHeadUid
		and lcth.Inactive = 0

	if (@DisplayInterval is null)
	begin
		select @DisplayInterval = lc.DisplayInterval
		from ListCalendar lc 
		where lc.CalendarUid = @CalendarUid
			and lc.Inactive = 0
	end

	insert into @StartEndTime (StartTime, EndTime, DisplayInterval, IsOpen, CalendarTemplateDayUid)
		values (@StartTime, @EndTime, @DisplayInterval, @isOpen, @CalendarTemplateDayUid)

	return
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FindOpenSlotOnCalendar]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/11/2016
-- Description:	
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[FindOpenSlotOnCalendar](
		@CalendarUid uniqueidentifier,			-- calendar to be searched
		@AppointmentTypeUid uniqueidentifier,	-- appointment type
		@SearchDate DATETIME,					-- if null will be populated with the current date
		@LookForAppoinmentTypeOnly bit,			-- when this value is null or zero this function
												-- will return any appointment type that has the
												-- the correct duration
		@LastEndDateTime datetime
		)

RETURNS
@OpenSlotResults table
(
	StartDateTime datetime,
	EndDateTime datetime,
	Duration int, -- in minutes
	AppointmentTypeUid uniqueidentifier,
	IsCalendarActive bit default (1)
)
AS
begin

	declare @startTime int -- minutes after mid-night
	declare @endTime int -- minutes after mid-night
	declare @displayInterval int -- time slot intervals in minutes

	if (@SearchDate is null)
		set @SearchDate = GetDate()

	declare @isOpen bit = 1
	declare @CalendarTemplateDayUid uniqueidentifier
	
	-- find one day''s calendar
	select	@isOpen = IsOpen, 
			@startTime = StartTime, 
			@endTime = EndTime, 
			@displayInterval = DisplayInterval, 
			@CalendarTemplateDayUid = CalendarTemplateDayUid
			from dbo.GetStartEndTime(@CalendarUid, @SearchDate)

	-- create temp working table
	declare @AvailableAppointmentTimeSlots table
	(
		StartTime int, -- minutes after mid-night
		EndTime int, -- minutes after mid-night
		StartDateTime datetime,
		EndDateTime datetime,
		Duration int, -- in minutes
		IsOpen bit default (0),
		Blocked bit default (0),
		AppointmentTypeUid uniqueidentifier,
		AppointmentStatusUid uniqueidentifier
	)

	-- fill in all possible time slots
	declare @timeCnt int = @startTime
	while @timeCnt + @displayInterval < @endTime
	begin
		insert into @AvailableAppointmentTimeSlots 
					(
						StartTime,
						EndTime,
						StartDateTime, 
						EndDateTime,
						Duration,
						IsOpen,
						Blocked
					)
			values	(
						@timeCnt,
						@timeCnt + @displayInterval,
						DATEADD(MINUTE, @timeCnt, convert(datetime, convert(date, @searchDate))), 
						DATEADD(MINUTE, @timeCnt + @displayInterval, convert(datetime, convert(date, @searchDate))),
						@displayInterval,
						@IsOpen,
						0
					)
		set @timeCnt = @timeCnt + @displayInterval
	end
	
	-- populate day slots; if they exists
	if (@CalendarTemplateDayUid is not null)
	begin

		declare @daySlotStartTime int
		declare @daySlotEndTime int
		declare @daySlotAppointmentTypeUid uniqueidentifier
		declare @daySlotBlocking bit
	
		declare dayslot_cursor cursor for 		
			select	lctds.StartTime, lctds.EndTime, lctds.AppointmentTypeUid
			from ListCalendarTemplateDaySlot lctds 
			where CalendarTemplateDayUid = @CalendarTemplateDayUid

		open dayslot_cursor
		fetch NEXT from dayslot_cursor into @daySlotStartTime, @daySlotEndTime, @daySlotAppointmentTypeUid

		while (@@fetch_status <> -1)
		begin
			if (@@fetch_status <> -2)
			begin
				select @daySlotBlocking = lpt.Blocking from ListAppointmentType lpt where lpt.AppointmentTypeUid = @daySlotAppointmentTypeUid
	
				declare @nextEndTime int = @daySlotStartTime

				while @nextEndTime < @daySlotEndTime
				begin
					set @nextEndTime = @nextEndTime + @displayInterval
				end 

				update aapts SET aapts.AppointmentTypeUid = @daySlotAppointmentTypeUid, aapts.Blocked = ISNULL(@daySlotBlocking, 0)
					from @AvailableAppointmentTimeSlots aapts
					where aapts.StartTime >= @daySlotStartTime and aapts.EndTime <= @nextEndTime
			end
			fetch NEXT from dayslot_cursor into @daySlotStartTime, @daySlotEndTime, @daySlotAppointmentTypeUid
		end -- of while
		
		close dayslot_cursor
		deallocate dayslot_cursor

	end

	-- populate appointments
	update aats SET AppointmentStatusUid = a.AppointmentStatusUid
		from Appointment a 
			inner join @AvailableAppointmentTimeSlots aats on dbo.ConvertUTCToLocalTime(a.StartDateTime) >= aats.StartDateTime
				and dbo.ConvertUTCToLocalTime(a.EndDateTime) <= aats.EndDateTime 
		where a.CalendarUid = @CalendarUid

	-- remove any canceled appointment status
	update aats SET AppointmentStatusUid = null
		from @AvailableAppointmentTimeSlots aats
			inner join ListAppointmentStatus lps on lps.AppointmentStatusUid = aats.AppointmentStatusUid
		where lps.IsCanceledStatus = 1
	
	-- find an open slot
	-- get the time required for the appointment type
	declare @RequiredDuration int

	select @RequiredDuration = Duration from ListAppointmentType where AppointmentTypeUid = @AppointmentTypeUid

	-- find "back to back" appointment slots that match the required time for the appointment type

	declare @foundStartDateTime datetime
	declare @foundAppointmentTypeUid uniqueidentifier

	declare @testDuration int = 0
	declare @loopStartDateTime datetime
	declare @loopEndDateTime datetime
	declare @loopDuration int
	declare @loopAppointmentStatusUid uniqueidentifier
	declare @loopAppointmentTypeUid uniqueidentifier
	declare @loopIsOpen bit = 0
	declare @loopBlocked bit = 0

	declare search_cursor cursor for 
		select StartDateTime, EndDateTime, Duration, AppointmentTypeUid, AppointmentStatusUid, IsOpen, Blocked
		from @AvailableAppointmentTimeSlots
		where (@LastEndDateTime is null) or ((@LastEndDateTime is not null) and (EndDateTime > @LastEndDateTime))
	
	open search_cursor
	fetch NEXT from search_cursor into @loopStartDateTime, @loopEndDateTime, @loopDuration, @loopAppointmentTypeUid,
								@loopAppointmentStatusUid, @loopIsOpen, @loopBlocked

	while (@@fetch_status <> -1)
	begin
		if (@@fetch_status <> -2)
		begin
			if ((@loopAppointmentStatusUid is null) and (@loopIsOpen = 1) and (ISNULL(@loopBlocked, 0) = 0))
			begin
				if (@testDuration = 0)
				begin
					set @foundStartDateTime = @loopStartDateTime
					set @foundAppointmentTypeUid = @loopAppointmentTypeUid
				end

				if ((ISNULL(@LookForAppoinmentTypeOnly, 0) = 0) OR
					((ISNULL(@LookForAppoinmentTypeOnly, 0) = 1) and (@loopAppointmentTypeUid = @AppointmentTypeUid)))
				begin
					set @testDuration = @testDuration + @loopDuration
				end
			end
			else begin
				set @testDuration = 0
				set @foundStartDateTime = null
				set @foundAppointmentTypeUid = null
			end
		end
	
		if ((@loopAppointmentStatusUid is null) and (@testDuration >= @RequiredDuration))
		begin
			break
		end
		
		fetch NEXT from search_cursor into @loopStartDateTime, @loopEndDateTime, @loopDuration, @loopAppointmentTypeUid,
									@loopAppointmentStatusUid, @loopIsOpen, @loopBlocked

	end -- of while
		
	close search_cursor
	deallocate search_cursor

	if (@testDuration > 0)
	begin
		insert into @OpenSlotResults(StartDateTime, EndDateTime, Duration, AppointmentTypeUid)
			values (@foundStartDateTime, dateadd(minute, @RequiredDuration, @foundStartDateTime), @RequiredDuration, @foundAppointmentTypeUid)
	end

	RETURN
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[OpenSlotCalendarAppointment]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

-- =================================================================
-- Author:		CHM
-- Create date: 02/17/2016
-- Description:	Returns an open slot for a calendar and appointment
--				type.
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[OpenSlotCalendarAppointment](
	@SearchStartDate DateTime,				-- date to "begin" looking for an open appointment
											-- if "null" will be today
	@SearchEndDate DateTime,				-- date to "end" looking for an open appointment
											-- if "null" will be a 365 days after the "begin" date
	@LookForAppoinmentTypeOnly bit,			-- when this value is null or zero this function
											-- will return any appointment type that has the
											-- the correct duration
	@CalendarUid uniqueidentifier,			-- calendar to be searched
	@AppointmentTypeUid uniqueidentifier,	-- appointment type to look for an open slot
	@OpenSlotOption int,					-- "1" = found first slot; "2" = found second slot;
											-- "3" = found third slot
											-- when "ReturnAllOpenSlots" is not "1" and "OpenSlotOption"
											-- is "null" or greater than "3" then it will be set to 
											-- a default value of "3" 
	@ReturnAllOpenSlots bit                 -- when "1" will return the number of open appointment
											-- slots defined in "OpenSlotOption" max return is "50"
		)

RETURNS
@Results table
	(
		CalendarName varchar(255),
		AppointmentTypeName varchar(255),
		AppointmentStartDateTime datetime,
		WaitTimeInDays decimal(14,3),
		ResultText varchar(30)
	)
AS
begin

	declare @ResultText varchar(30)
	declare @CalendarName varchar(255) = (select Name from ListCalendar where CalendarUid = @CalendarUid)
	declare @AppointmentTypeName varchar(255) = (select Name from ListAppointmentType where AppointmentTypeUid = @AppointmentTypeUid)
	declare @SearchDate datetime = @SearchStartDate
	declare @StartDateTime datetime
	declare @LastEndDateTime datetime
	declare @OpenSlotCount int = 0
	declare @found bit = 0

	if (@SearchStartDate is null)
	begin
		set @SearchStartDate = GETDATE()
	end
	if (@SearchEndDate is null)
	begin
		set @SearchEndDate = DATEADD(day, 365, @SearchStartDate)
	end


	if ((ISNULL(@ReturnAllOpenSlots, 0) = 0) and ((@OpenSlotOption is null) or (@OpenSlotOption > 3)))
	begin
		set @OpenSlotOption = 3
	end
	if ((ISNULL(@ReturnAllOpenSlots, 0) = 1) and (@OpenSlotOption is null))
	begin
		set @OpenSlotOption = 3
	end
	if ((ISNULL(@ReturnAllOpenSlots, 0) = 1) and (@OpenSlotOption > 50))
	begin
		set @OpenSlotOption = 50
	end

	if ((ISNULL(@LookForAppoinmentTypeOnly, 0) = 1) 
		AND (@AppointmentTypeUid is not null)
		AND (@CalendarUid is not null))
	begin
		declare @tempCnt int

		---- is appointment type in calendar
		select @tempCnt = COUNT(*) from ListCalendarTemplateDaySlot lctds
		inner join ListCalendarTemplateDay lctd on lctds.CalendarTemplateDayUid = lctd.CalendarTemplateDayUid
		inner join RelCalendarCalendarTemplateHead rccth on lctd.CalendarTemplateHeadUid = rccth.CalendarTemplateHeadUid
		where rccth.CalendarUid = @CalendarUid and lctds.AppointmentTypeUid = @AppointmentTypeUid 
				and ((rccth.StartDate <= @SearchStartDate and rccth.EndDate is null)
				or (rccth.StartDate <= @SearchStartDate and rccth.EndDate >= @SearchEndDate))

		-- not in calendar; no need to continue
		if (@tempCnt = 0)
		begin
			insert into @Results (
					CalendarName,
					AppointmentTypeName,
					ResultText
				)
			values (
					@CalendarName,
					@AppointmentTypeName,
					''not found''
				)

			return
		end
	end
		
	--declare @dayCount int = 0

	if (ISNULL(@ReturnAllOpenSlots, 0) = 0)
	begin
		if (@OpenSlotOption = 1)
			set @ResultText = ''slot 1''
		else if (@OpenSlotOption = 2)
			set @ResultText = ''slot 2''
		else
			set @ResultText = ''slot 3''
	end
	while ((@SearchDate <= @SearchEndDate) and (@OpenSlotCount < @OpenSlotOption))
	begin
		--set @dayCount = @dayCount + 1
		set @found = 0
		set @StartDateTime = null
		select @StartDateTime = StartDateTime, @LastEndDateTime = EndDateTime 
			from dbo.FindOpenSlotOnCalendar (@CalendarUid, @AppointmentTypeUid, @SearchDate, @LookForAppoinmentTypeOnly, @LastEndDateTime)

		if (@StartDateTime is not null)
		begin
			-- skip times of day that have already passed
			if (CONVERT(decimal(14,3), DATEDIFF(SECOND, @SearchStartDate, @StartDateTime) / 86400.0) > 0)
			begin
				set @OpenSlotCount = @OpenSlotCount + 1 
				if ((@OpenSlotCount = @OpenSlotOption) or (ISNULL(@ReturnAllOpenSlots, 0) = 1))
				begin
					if (ISNULL(@ReturnAllOpenSlots, 0) = 1)
					begin
						set @ResultText = ''slot '' + convert(varchar(20), @OpenSlotCount)
					end

					insert into @Results (
						CalendarName,
						AppointmentTypeName,
						AppointmentStartDateTime,
						WaitTimeInDays,
						ResultText
						)
					values (
						@CalendarName,
						@AppointmentTypeName,
						@StartDateTime,
						CONVERT(decimal(14,3), DATEDIFF(SECOND, @SearchStartDate, @StartDateTime) / 86400.0),
						@ResultText
						)
					set @found = 1
				end
			end 
		end
		if (@found = 0)
		begin
			-- try the next day
			set @SearchDate = DATEADD(day, 1, @SearchDate)
			-- when looking for an appointment type and none is found in the first 30 days; exit
			--if ((ISNULL(@LookForAppoinmentTypeOnly, 0) = 1) and (@dayCount > 30))
			--begin
			--	break
			--end
		end
	end -- end of while ((@SearchDate <= @SearchEndDate) and (@OpenSlotCount < @OpenSlotOption))

	if ((select count(*) from @Results) = 0)
	begin		
		insert into @Results (
			CalendarName,
			AppointmentTypeName,
			ResultText
		)
		values (
			@CalendarName,
			@AppointmentTypeName,
			''not found''
		)
	end

	return
end



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AppointmentAvailabilityReport]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 02/22/2016
-- Description:	Returns a table of Appointment Availability Report
--				based on supplied parameters.
--
--				Fix for task #46516.
-- =================================================================
CREATE FUNCTION [dbo].[AppointmentAvailabilityReport](
	@SearchStartDate Date,					-- date to "begin" looking for an open appointment
											-- if "null" will be today
	@SearchEndDate Date,					-- date to "end" looking for an open appointment
											-- if "null" will be a 365 days after the "begin" date
	@LookForAppoinmentTypeOnly bit,			-- when this value is null or zero this function
											-- will return any appointment type that has the
											-- the correct duration
	@CalendarUidList varchar(max),			-- list of calendar uids (separated by a semicolon)
											-- to be searched, when null will search all calendars
	@AppointmentTypeUidList varchar(max),	-- list of appointment type uids (separated by a semicolon)
											-- to be searched, when null will search all appointment types
	@OpenSlotOption int,					-- "1" = found first slot; "2" = found second slot;
											-- "3" = found third slot
											-- when "ReturnAllOpenSlots" is not "1" and "OpenSlotOption"
											-- is "null" or greater than "3" then it will be set to 
											-- a default value of "3" 
	@ReturnAllOpenSlots bit                 -- when "1" will return the number of open appointment
											-- slots defined in "OpenSlotOption" max return is "50"
											)
RETURNS
@Results table
	(
		CalendarName varchar(255),
		AppointmentTypeName varchar(255),
		AppointmentStartDateTime datetime,
		WaitTimeInDays decimal(14,3),
		ResultText varchar(30)
	)
AS BEGIN

	declare @CalendarUids table
	(
		CalendarUid uniqueidentifier
	)

	INSERT		@CalendarUids
	SELECT		* 
	FROM		dbo.SplitList_Uids(@CalendarUidList, '','')
	
	declare @AppointmentTypeUids table
	(
		AppointmentTypeUid uniqueidentifier
	)

	INSERT		@AppointmentTypeUids
	SELECT		* 
	FROM		dbo.SplitList_Uids(@AppointmentTypeUidList, '','')
	
	declare @CalendarUid uniqueidentifier
	declare @AppointmentTypeUid uniqueidentifier

	if (@SearchStartDate is null)
	begin
		set @SearchStartDate = GETDATE()
	end
	if (@SearchEndDate is null)
	begin
		set @SearchEndDate = DATEADD(day, 365, @SearchStartDate)
	end

	declare cal_cursor cursor for 
		select CalendarUid 
		from ListCalendar 
		where Inactive = 0
		and ((@CalendarUidList is null) or (CalendarUid in (select CalendarUid from @CalendarUids)))
		order by Name
			
	open cal_cursor

	fetch NEXT from cal_cursor into @CalendarUid

	while (@@fetch_status <> -1)
	begin
		if (@@fetch_status <> -2)
		begin
		
			declare type_cursor cursor for 
				select AppointmentTypeUid 
				from ListAppointmentType 
				where Inactive = 0 and Blocking = 0
				and ((@AppointmentTypeUidList is null) or (AppointmentTypeUid in (select AppointmentTypeUid from @AppointmentTypeUids)))
				order by Name
			
			open type_cursor

			fetch NEXT from type_cursor into @AppointmentTypeUid

			while (@@fetch_status <> -1)
			begin
				if (@@fetch_status <> -2)
				begin			
					insert into @Results (CalendarName, AppointmentTypeName, AppointmentStartDateTime, WaitTimeInDays, ResultText)
						select CalendarName, AppointmentTypeName, AppointmentStartDateTime, WaitTimeInDays, ResultText 
						from dbo.OpenSlotCalendarAppointment(@SearchStartDate, @SearchEndDate, @LookForAppoinmentTypeOnly, 
										@CalendarUid, @AppointmentTypeUid, @OpenSlotOption, @ReturnAllOpenSlots)
				end

				fetch NEXT from type_cursor into @AppointmentTypeUid
			end -- of while

			close type_cursor
			deallocate type_cursor
		end
		
		fetch NEXT from cal_cursor into @CalendarUid
	end -- of while

	close cal_cursor
	deallocate cal_cursor

	return
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_GetTransactionAggregate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[AR_GetTransactionAggregate](@transactionUid uniqueidentifier)
RETURNS @retTable TABLE 
(
    InsAdjustment MONEY,
    PatientAdjustment MONEY,
    PatientTransfer MONEY,
	InsTransfer MONEY
)
AS
BEGIN

	-- Bug 55495:Opening an existing deposit takes about 30seconds to 1 minute top open
	-- Changed call to AR_ViewTransactionsByDeposit to use this so can optimize fetch of transaction aggregates
	-- Otherwise query below and AR_ViewTransactionDeposits pull ALL financials before doing join in AR_ViewTransactionsByDeposit

	INSERT @retTable (InsAdjustment, PatientAdjustment, PatientTransfer, InsTransfer)
		SELECT InsAdjustment, PatientAdjustment, PatientTransfer, InsTransfer FROM AR_ViewTransactionAggregateSub 
		WHERE TransactionUid = @transactionUid
	 
	RETURN ;
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_GetTransactionBatches]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[AR_GetTransactionBatches](@transactionUid uniqueidentifier)
RETURNS @retTable TABLE 
(
    transactionUid uniqueidentifier,
    BatchUids varchar(250),
	BatchNames varchar(250),
	BatchStates varchar(80)
)
AS
BEGIN

	DECLARE @ARBatchUids varchar(MAX) 
	DECLARE @ARBatchNames varchar(MAX)
	DECLARE @ARBatchStates varchar(MAX)
	
	
	 -- Get all ledger entries associated with this superbill''s procedures
	 DECLARE @batchTable TABLE
	 (
	   ARBatchUid uniqueidentifier,
	   Name varchar(255),
	   IsLocked bit,
	   IsClosed bit,
	   GLDate datetime
	 ) ;
	 
	 -- Find batch ledger entries
	 INSERT @batchTable(ARBatchUid, Name, IsLocked, IsClosed, GLDate)
		select distinct arb.ARBatchUid, arb.Name, arb.IsClosed, arb.IsLocked, arb.GLDate
		from AR_LedgerDetail ld
			inner join AR_Ledger l on ld.ledgerUid = l.ledgeruid 
				inner join ARBatch arb on l.ArBatchUid = arb.ARBatchUid
		where l.TransactionUid = @transactionUid
		
	 -- Loop 
	 DECLARE @uid uniqueidentifier
	 DECLARE @name VARCHAR(255)
	 DECLARE @isLocked bit
	 DECLARE @isClosed bit
	 DECLARE @isOpen bit
	 
	 select @ARBatchUids = null,
	        @ARBatchNames = null,
	        @isLocked = 0,  -- Complete
	        @isClosed = 0,  -- Closed
	        @isOpen = 0     -- Open

	 select @ARBatchUids = CASE WHEN @ARBatchUids IS NULL THEN CONVERT(VARCHAR(36), bt.ARBatchUid) ELSE '','' + CONVERT(VARCHAR(36), bt.ARBatchUid) END,
	        @ARBatchNames = CASE WHEN @ARBatchNames IS NULL THEN CONVERT(VARCHAR(255), bt.Name) ELSE '','' + CONVERT(VARCHAR(255), bt.Name) END,
	        @isOpen   = CASE WHEN (bt.IsLocked = 0 AND bt.IsClosed = 0) THEN 1 ELSE @isOpen END,
	        @isLocked = CASE WHEN bt.IsLocked = 1 THEN 1 ELSE @isLocked END,
	        @isClosed = CASE WHEN bt.IsClosed = 1 THEN 1 ELSE @isClosed END
	 FROM @batchTable bt
	 ORDER BY GLDate DESC
	 
	 DECLARE @batchStates varchar(80)
	 select @batchStates = CASE WHEN @isOpen = 1 THEN ''Open'' ELSE '''' END
	 SELECT @batchStates = CASE WHEN @isLocked = 1 AND @batchStates = '''' THEN ''Locked''
	                            WHEN @isLocked = 1 AND @batchStates != '''' THEN '', Locked'' 
	                            ELSE @batchStates END
	 SELECT @batchStates = CASE WHEN @isClosed = 1 AND @batchStates = '''' THEN ''Closed''
	                            WHEN @isClosed = 1 AND @batchStates != '''' THEN '', Closed'' 
	                            ELSE @batchStates END
	 
	 INSERT @retTable(transactionUid, BatchUids,BatchNames, BatchStates)
	   SELECT @transactionUid, @ARBatchUids, @ARBatchNames, @batchStates
	 
  return ;
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_GetTransactionDeposits]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[AR_GetTransactionDeposits](@transactionUid uniqueidentifier)
RETURNS @retTable TABLE 
(
    transactionUid uniqueidentifier,
    depositUids varchar(250),
    depositNames varchar(250)
)
AS
BEGIN

	DECLARE @depositUids varchar(MAX) 
	DECLARE @depositNames varchar(MAX)
	
	 -- Get all ledger entries associated with this superbill''s procedures
	 DECLARE @dTable TABLE
	 (
	   depositUid uniqueidentifier,
	   Name varchar(255),
	   depositDate datetime
	 ) ;
	 
	 -- Find batch ledger entries
	 INSERT @dTable(depositUid, Name, depositDate)
		select distinct ld.DepositUid, d.ReferenceNumber, d.DepositDate
		from AR_LedgerDetail ld
			inner join AR_Ledger l on ld.ledgerUid = l.ledgeruid 
				inner join Deposit d on ld.DepositUid = d.DepositUid
		where l.TransactionUid = @transactionUid
			 
	 select @depositUids = null,
	        @depositNames = null

	 select @depositUids = CASE WHEN @depositUids IS NULL THEN CONVERT(VARCHAR(36), dt.depositUid) ELSE '','' + CONVERT(VARCHAR(36), dt.depositUid) END,
	        @depositNames = CASE WHEN @depositNames IS NULL THEN CONVERT(VARCHAR(255), dt.Name) ELSE '','' + CONVERT(VARCHAR(255), dt.Name) END
	 FROM @dTable dt
	 ORDER BY dt.depositDate DESC
	 	 
	 INSERT @retTable(transactionUid, depositUids, depositNames)
	   SELECT @transactionUid, @depositUids, @depositNames
	 
  return ;
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AR_SuperbillProcedureBatch]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[AR_SuperbillProcedureBatch]
(
	@superbillFilterXml XML
)
RETURNS 
@SuperbillProcedureBatchTable TABLE 
(
	SuperbillUid UNIQUEIDENTIFIER, 
	SuperbillProcedureUid UNIQUEIDENTIFIER, 
	ArBatchUid UNIQUEIDENTIFIER, 
	ArBatchName VARCHAR(255), 
	ArBatchPostingDate DATETIME
)
AS
BEGIN

	DECLARE @SuperbillFilterTable TABLE
	(
		SuperbillUid UNIQUEIDENTIFIER
	)
	INSERT @SuperbillFilterTable
		SELECT	x.n.value (''@SuperbillUid'', ''UNIQUEIDENTIFIER'') AS SuperbillUid
			FROM @superbillFilterXml.nodes(''Superbills/Superbill'') AS x(n)

	INSERT INTO @SuperbillProcedureBatchTable
		SELECT SuperbillUid, SuperbillProcedureUid, ArBatchUid, 
						ArBatchName, ArBatchPostingDate
			FROM (SELECT VSPBS.SuperbillUid, VSPBS.SuperbillProcedureUid, VSPBS.ArBatchUid, 
							VSPBS.ArBatchName, VSPBS.ArBatchPostingDate,
						RANK() OVER (PARTITION BY SuperbillProcedureUid, CreatedDateTime ORDER BY CreatedDateTime DESC) AS RankValue    
						FROM @SuperbillFilterTable SBFT
							INNER JOIN AR_ViewSuperbillProcedureBatchSub (NOEXPAND) VSPBS ON SBFT.SuperbillUid = VSPBS.SuperbillUid) RANKED 
			WHERE RANKED.RankValue = 1

	RETURN 
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Split]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[Split]
 (	@vcDelimitedString VARCHAR(max),
	@vcDelimiter VARCHAR(100) 
 )

RETURNS @tblArray TABLE
   (
	ElementID	smallint	IDENTITY(1,1),  --Array index
   	Element		varchar(1000)			--Array element contents
   )
AS
BEGIN

	DECLARE
	@siIndex	SMALLINT,
	@siStart		SMALLINT,
	@siDelSize	SMALLINT


	SET @siDelSize	= LEN(@vcDelimiter)
	--loop through source string and add elements to destination table array
	WHILE LEN(@vcDelimitedString) > 0
	BEGIN
		SET @siIndex = CHARINDEX(@vcDelimiter, @vcDelimitedString)
		IF @siIndex = 0
		BEGIN
			INSERT INTO @tblArray VALUES(@vcDelimitedString)
			BREAK
		END
		ELSE
		BEGIN
			INSERT INTO @tblArray VALUES(SUBSTRING(@vcDelimitedString, 1,@siIndex - 1))
			SET @siStart = @siIndex + @siDelSize
			SET @vcDelimitedString = SUBSTRING(@vcDelimitedString, @siStart , LEN(@vcDelimitedString) - @siStart + 1)
		END
	END

	RETURN
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARFN_getBatchFinancialStatus]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[ARFN_getBatchFinancialStatus]  
(  
 @endDate DATETIME,   
 @financialCenterUids VARCHAR(8000)      
)   
RETURNS INT   
AS  
BEGIN  
   
 /*   
 For an end date and optional Financial Center filter (otherwise uses all)  
  returns ...  
    -1 - All Specified Financial Centers Closed Through End Date  
  0 - All Batches Closed Through End Date  
  1 - Not Closed But No Unallocated  
  2 - Not Closed And Unallocated Exist  
 */  
  
 DECLARE @retVal INT  
 SELECT @retVal = 2 -- default to worst case  
  
 DECLARE @ArBatches TABLE                       
 (                            
  ArBatchUid UNIQUEIDENTIFIER                         
 )     
  
 IF  @endDate IS NULL  
  SELECT @endDate = GetDate()  
SELECT @endDate =  DATEADD(DAY,1,@endDate)

 IF NOT (@financialCenterUids IS NULL OR @financialCenterUids = '''')  
 BEGIN  
  IF NOT EXISTS(SELECT FC.FinancialCenterUid FROM FinancialCenter FC  
   WHERE (FC.FinancialCenterUid IN (SELECT Element FROM Split(@financialCenterUids, '',''))) -- get only the specified financial centers  
    --AND cast(convert(varchar, ISNULL(ArClosedThroughDate,''1900-01-01''), 101) AS datetime) < @endDate) -- where close date < end date  
    and (ArClosedThroughDate is null or ArClosedThroughDate <@endDate))
  BEGIN  
   SELECT @retVal = -1  
  END  
 END  
  
 IF @retVal > -1 -- did not pass preliminary financial center test  
 BEGIN      
  INSERT INTO @ArBatches -- get open batches <= end date               
  SELECT ARB.ARBatchUid  
  FROM ArBatch ARB                      
  WHERE ARB.IsClosed = 0 --and cast(convert(varchar, ARB.GlDate, 101) AS datetime) <= @endDate  
  and ARB.GlDate <= @endDate
                         
  IF NOT EXISTS(SELECT ARBatchUid FROM @ArBatches) -- all batches are closed  
   SELECT @retVal = 0  
  ELSE  
  BEGIN  
   IF NOT EXISTS(SELECT DP.DepositUid FROM Deposit DP  
    LEFT JOIN AR_ViewDepositAggregate VD ON DP.DepositUid=VD.DepositUid          
    INNER JOIN @ArBatches ARBLIST ON DP.ArBatchUid = ARBLIST.ArBatchUid                          
    WHERE DP.Amount != (VD.Receipt - VD.ReceiptBalance) AND (DP.Void is null or DP.Void != 1)) -- no unallocated amounts  
    SELECT @retVal = 1   
   ELSE  
    SELECT @retVal = 2  
  END    
 END  
  
 RETURN @retVal  
  
 /* Testing  
  SELECT dbo.ARFN_getBatchFinancialStatus(null, null)  
  SELECT dbo.ARFN_getBatchFinancialStatus(''1901-01-01'', null)  
  SELECT dbo.ARFN_getBatchFinancialStatus(''1901-01-01'', '''')  
  SELECT dbo.ARFN_getBatchFinancialStatus(''1901-01-01'', ''C0414713-2185-4603-B4D7-1ED361C6951D'')  
  SELECT dbo.ARFN_getBatchFinancialStatus(''1901-01-01'', ''14B99C94-EDAC-47BD-97B9-CF421AC16018'')  
  SELECT dbo.ARFN_getBatchFinancialStatus(''2008-08-01'', ''14B99C94-EDAC-47BD-97B9-CF421AC16018'')  
  SELECT * FROM FinancialCenter  
 */  
  
END  
  


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARFN_getFeeScheduleFee]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[ARFN_getFeeScheduleFee]
	(@feeSchedulePeriodUid uniqueidentifier, 
	@procedureUid uniqueidentifier) 
returns money as
begin
	/*	Returns the unit fee for the given fee schedule period and procedure.

		Equivalent to the code in the biz object FeeScheduleFee.cs property Fee.
	*/

	declare @fee money

	select top 1 @fee = (CASE WHEN fsp.RVUScheduleUid is not null 
							and rsv.RVUScheduleValueUid is not null 
							THEN (((rsv.WorkRVU * rs.WorkGPCI) 
								+ (rsv.RBNonFacilityPERVU * rs.PEGPCI) 
								+ (rsv.MPRVU * rs.MPGPCI)) * rs.ConversionFactor)
							ELSE fsf.Fee END) 
	from 
	FeeSchedule fs 
		inner join FeeSchedulePeriod fsp on fsp.FeeScheduleUid = fs.FeeScheduleUid 
		inner join FeeScheduleFee fsf on fsf.FeeSchedulePeriodUid = fsp.FeeSchedulePeriodUid 
			and fsf.Inactive = 0 
		left join RVUSchedule rs on rs.RVUScheduleUid = fsp.RVUScheduleUid 
		left join RVUScheduleValue rsv on rsv.RVUScheduleUid = rs.RVUScheduleUid 
			and rsv.ProcedureUid = @procedureUid 
			and rsv.Inactive = 0 
	where fsp.FeeSchedulePeriodUid = @feeSchedulePeriodUid 
		and fsf.ProcedureUid = @procedureUid 

	return isnull(round(@fee, 2), 0.00)
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARFN_getFeeSchedulePeriod]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ARFN_getFeeSchedulePeriod]
	(@feeScheduleUid uniqueidentifier, 
	@utcDate datetime) 
returns uniqueidentifier as
begin
	/*	Returns the fee schedule period for the given fee schedule on the given UTC date.

		Equivalent to the code in the biz object FeeSchedule.cs method GetFeeSchedulePeriod.
	*/
	declare @FeeSchedulePeriodUid uniqueidentifier 

	select top 1 @FeeSchedulePeriodUid = FeeSchedulePeriodUid 
	from FeeSchedulePeriod 
	where FeeScheduleUid = @feeScheduleUid 
		and (EffectiveDate is null or EffectiveDate <= @utcDate) 
		and (ExpirationDate is null or ExpirationDate > @utcDate) 
	order by EffectiveDate desc

	return @FeeSchedulePeriodUid
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARFN_getGLDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[ARFN_getGLDate] (@dtCreateDate DATE, @dtCurrentPeriodEnd DATE)
RETURNS DATETIME AS 

BEGIN
	DECLARE @theGLDate DATE
	
	IF (@dtCurrentPeriodEnd > @dtCreateDate) 
		SELECT @theGLDate = @dtCreateDate 
	ELSE 
		SELECT @theGLDate = @dtCurrentPeriodEnd 
	
	RETURN @theGLDate
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARFN_getInsLevelName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ARFN_getInsLevelName]
	(@insLevel INT)
RETURNS VARCHAR(10) AS 
BEGIN
	RETURN (CASE @insLevel 
		WHEN Null THEN '''' 
		WHEN 0 THEN '''' 
		WHEN 1 THEN ''Primary'' 
		WHEN 2 THEN ''Secondary'' 
		WHEN 3 THEN ''Tertiary'' 
		WHEN 4 THEN ''Quaternary'' 
		WHEN 5 THEN ''Quinary'' 
		WHEN 6 THEN ''Senary'' 
		WHEN 7 THEN ''Septary'' 
		WHEN 8 THEN ''Ogdoad'' 
		WHEN 9 THEN ''Ennead'' 
		WHEN 10 THEN ''Decad'' 
		ELSE (CONVERT(VARCHAR(8), @insLevel) + ''th'') END)
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARFN_getLiabilityName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[ARFN_getLiabilityName]
	(@liabilityOwner SMALLINT)
RETURNS VARCHAR(10) AS 
BEGIN
	DECLARE @return VARCHAR(10)
	SELECT @return = Upper(dbo.ARFN_getInsLevelName(@liabilityOwner))
	IF (@return = '''') SELECT @return = ''PATIENT''
	RETURN @return
END






' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARFN_getPlanProviderFeeSchedule]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ARFN_getPlanProviderFeeSchedule]
	(@insurancePlanUid uniqueidentifier, 
	@providerUid uniqueidentifier)
returns uniqueidentifier as
begin
	/*	Returns the fee schedule (carrier schedule, plan schedule, or provider schedule) 
		indicated for the given insurance plan and provider.

		Equivalent to the code in the biz object FeeSchedule.cs method GetPlanProviderFeeSchedule.
	*/
	declare @FeeScheduleUid uniqueidentifier 

	-- Use Carrier Fee Schedule
	select @FeeScheduleUid = ic.FeeScheduleUid 
	from InsurancePlan ip, InsuranceCarrier ic 
	where ip.InsuranceCarrierUid = ic.CorporationUid 
		and ip.UseCarrierFeeSchedule = 1 
		and ic.UseProviderFeeSchedule = 0 

	if (@@rowcount > 0)
		return @FeeScheduleUid

	-- Use Plan Fee Schedule
	select @FeeScheduleUid = ip.FeeScheduleUid 
	from InsurancePlan ip, InsuranceCarrier ic 
	where ip.InsuranceCarrierUid = ic.CorporationUid 
		and ip.UseCarrierFeeSchedule = 0 
		and ip.UseProviderFeeSchedule = 0 

	if (@@rowcount > 0)
		return @FeeScheduleUid

	-- Use Provider Fee Schedule
	select @FeeScheduleUid = FeeScheduleUid from Provider where PersonUid = @providerUid
	return @FeeScheduleUid
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_AR_getClaimFormatUid]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[UDF_AR_getClaimFormatUid] (@ClaimPaper bit, 
												 @PlanUseCarrierElectronicClaimFormat bit, @PlanUseCarrierPaperClaimFormat bit, 
												 @PlanElectronicClaimFormatUid uniqueidentifier, @CarrierElectronicClaimFormatUid uniqueidentifier, 
												 @PlanPaperClaimFormatUid uniqueidentifier, @CarrierPaperClaimFormatUid uniqueidentifier,
												 @PlanUseCarrierPaperClaimDefaultOption bit = 1, @PlanPaperClaimDefaultOptionUid uniqueidentifier = null, @CarrierPaperClaimDefaultOptionUid uniqueidentifier = null, 
												 @insuranceOrder int)
RETURNS uniqueidentifier AS
BEGIN
	declare @ElectronicClaimFormatUid uniqueidentifier, @PaperClaimFormatUid uniqueidentifier, @ClaimFormatUid uniqueidentifier, @PaperClaimDefaultOptionUid uniqueidentifier

	-- ElectronicClaimFormatUid
	if (@PlanUseCarrierElectronicClaimFormat = 1)
		set @ElectronicClaimFormatUid = @CarrierElectronicClaimFormatUid
	else
		set @ElectronicClaimFormatUid = @PlanElectronicClaimFormatUid

	-- PaperClaimformatUid
	if (@PlanUseCarrierPaperClaimFormat = 1)
		set @PaperClaimFormatUid = @CarrierPaperClaimFormatUid
	else
		set @PaperClaimFormatUid = @PlanPaperClaimFormatUid

	-- PaperClaimDefaultOptionUid
	if (@PlanUseCarrierPaperClaimDefaultOption = 1)
		SET @PaperClaimDefaultOptionUid = @CarrierPaperClaimDefaultOptionUid
	else
		SET @PaperClaimDefaultOptionUid = @PlanPaperClaimDefaultOptionUid
	if (@PaperClaimDefaultOptionUid IS NULL)
		SET @PaperClaimDefaultOptionUid = ''5B36F9C3-B1CF-4E80-8541-11397058B723''		-- if not set default is None ( Claims default to electronic )
	
	--
	-- PaperClaimDefaultOption ( from ListMisc.ListType == ''PaperClaimOptions'' )
	--		5B36F9C3-B1CF-4E80-8541-11397058B723	None (Claims default to electronic)
	-- 		9CB84C44-19F5-4F32-809C-3350BBE99ACA	Secondary (Non-primary claims will print)
	-- 		09AA94E4-E72B-499E-BF6E-E5FE9E05D8B8	All (All claims will print)
		
	-- Assume electronic unless told to go to paper
	if ( @ClaimPaper = 1 )		-- claim paper set specifically for superbill
		SET @ClaimFormatUid = @PaperClaimFormatUid
	else
	if ( @PaperClaimDefaultOptionUid = ''09AA94E4-E72B-499E-BF6E-E5FE9E05D8B8'' )		-- All ( All claims will print )
		SET @ClaimFormatUid = @PaperClaimFormatUid
	else
	if ( @PaperClaimDefaultOptionUid = ''5B36F9C3-B1CF-4E80-8541-11397058B723'' )  	-- None ( Claims default to Electronic )
		SET @ClaimFormatUid = @ElectronicClaimFormatUid
	else
	if ( @PaperClaimDefaultOptionUid = ''9CB84C44-19F5-4F32-809C-3350BBE99ACA'' AND	-- Secondary ( Non-primary claims will print )
		 @insuranceOrder != 1 )														-- Current Insurance is Non-primary
		SET @ClaimFormatUid = @PaperClaimFormatUid
	else
		SET @ClaimFormatUid = @ElectronicClaimFormatUid

	return @ClaimFormatUid
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARFN_getSuperbillFeeSchedulePeriod]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ARFN_getSuperbillFeeSchedulePeriod]
	(@superbillUid uniqueidentifier) 
returns uniqueidentifier as
begin
	/*	Returns the fee schedule in force for the given superbill.

		Equivalent to the code in the biz object Superbille.cs property FeeSchedulePeriod.
	*/
	declare @InsurancePlanUid uniqueidentifier, @ProviderUid uniqueidentifier, @SBDate datetime 
	declare @FeeScheduleUid uniqueidentifier, @FeeSchedulePeriodUid uniqueidentifier 

	select @InsurancePlanUid = InsurancePlanUid, 
		@ProviderUid = ClaimingProviderUid, 
		@SBDate = ServiceDateEnd 
	from ViewSuperbillPayer 
	where SuperbillUid = @superbillUid and InsuranceOrder = 1

	if (@@rowcount = 0)
		return null

	set @FeeScheduleUid = dbo.ARFN_getPlanProviderFeeSchedule(@InsurancePlanUid, @ProviderUid) 

	if (@FeeScheduleUid is null)
		return null

	return dbo.ARFN_getFeeSchedulePeriod(@FeeScheduleUid, @SBDate)
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARFN_getSuperbillProcedureUnitFee]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ARFN_getSuperbillProcedureUnitFee]
	(@superbillUid uniqueidentifier, 
	@procedureUid uniqueidentifier) 
returns money as 

begin
	/*	Returns the unit fee for the given superbill and procedure.

		Equivalent to the code in the biz object SuperbillProcedure.cs property SetProcedureCharge.
	*/
	declare @FeeSchedulePeriodUid uniqueidentifier 

	set @FeeSchedulePeriodUid = dbo.ARFN_getSuperbillFeeSchedulePeriod(@superbillUid)
	return dbo.ARFN_getFeeScheduleFee(@FeeSchedulePeriodUid, @procedureUid)
end' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsLabProcedure]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[IsLabProcedure]
(
	@procedureUid UNIQUEIDENTIFIER
)
RETURNS BIT
AS
BEGIN

	DECLARE @isLabProcedure BIT
	SELECT @isLabProcedure = 0

	IF EXISTS(SELECT 1 
			FROM ListProcedure
			WHERE ProcedureUid = @procedureUid
				AND ProcedureCodeTypeUid = ''00000000-0000-0000-0000-000000000001'' -- CPT Code
				AND LEN(Code)=5 AND SUBSTRING(Code,1,1)=''8'')
		SELECT @isLabProcedure = 1

	RETURN @isLabProcedure
	
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAccountPeriod]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[GetAccountPeriod] (@accountuid uniqueidentifier, @date DATE) RETURNS UNIQUEIDENTIFIER AS
	BEGIN
	
		DECLARE	@accountPeriodUid uniqueidentifier
	
		SELECT TOP 1	@accountPeriodUid = ap.AccountPeriodUid
		FROM		AccountPeriod ap
		WHERE		ap.AccountUid = @accountUid AND
					(ap.EffectiveDate <= @date OR ap.EffectiveDate IS NULL) AND
					(ap.ExpirationDate >= @date OR ap.ExpirationDate IS NULL)
		
	RETURN @accountPeriodUid
	END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARFN_SuperbillProcedure_InitialPatientLiabilityTrue]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ARFN_SuperbillProcedure_InitialPatientLiabilityTrue]
(
	@superbillProcedureUid UNIQUEIDENTIFIER
)
RETURNS MONEY 
AS
BEGIN

	DECLARE @totalCharge MONEY -- same initially but needed at end to make certain patient portion does not exceed total
	DECLARE @patientLiability MONEY

	-- default case - patient owes it all
	SELECT @patientLiability = ISNULL(SBP.TotalCharge, 0), @totalCharge = ISNULL(SBP.TotalCharge, 0)
		FROM dbo.SuperbillProcedure SBP 
		WHERE SBP.SuperbillProcedureUid = @superbillProcedureUid
		
	-- Patient typically gets no liability if insured authorizes assignment and practice accepts assignment from plan, etc.
	IF EXISTS(SELECT SBP.SuperbillProcedureUid
				FROM dbo.SuperbillProcedure SBP 
				INNER JOIN dbo.Superbill SB ON SBP.SuperbillUid = SB.SuperbillUid
				INNER JOIN dbo.Account A ON SB.AccountUid = A.AccountUid
				INNER JOIN dbo.AccountPeriod AP ON A.AccountUid = AP.AccountUid
				INNER JOIN dbo.AccountInsurance AI ON AP.AccountPeriodUid = AI.AccountPeriodUid
				INNER JOIN dbo.PersonInsurancePlan PIP ON AI.PersonInsurancePlanUid = PIP.PersonInsurancePlanUid
				INNER JOIN dbo.InsurancePlan IP ON PIP.InsurancePlanUid = IP.InsurancePlanUid
				INNER JOIN dbo.InsuranceCarrier IC ON IP.InsuranceCarrierUid = IC.CorporationUid
				INNER JOIN dbo.ListProcedure LP ON SBP.ProcedureUid = LP.ProcedureUid
				WHERE SBP.SuperbillProcedureUid = @superbillProcedureUid 
					AND AP.AccountPeriodUid = dbo.GetAccountPeriod(SB.AccountUid, ISNULL(SB.ServiceDateEnd, GetDate()))
					AND AI.DisplayOrder = 1 -- primary
					AND  SBP.DontClaim = 0 -- NOT SB.CurrentPrimaryAccountInsurance IS NULL
					AND ((SB.UsePersonInsuranceAuthorizeAssignment=1 AND PIP.AuthorizeAssignment=1) 
						OR (SB.UsePersonInsuranceAuthorizeAssignment=0 AND SB.AuthorizeAssignment=1))
					AND ((SB.UsePrimaryPayerAcceptAssignment=1 AND IC.AcceptAssignment=1)
						OR (SB.UsePrimaryPayerAcceptAssignment=1 AND IC.AcceptAssignmentLabOnly=1 AND dbo.IsLabProcedure(LP.ProcedureUid)=1)
						OR (SB.UsePrimaryPayerAcceptAssignment=0 AND SB.AcceptAssignment=1)
						OR (SB.UsePrimaryPayerAcceptAssignment=0 AND SB.AcceptAssignmentLabOnly=1 AND dbo.IsLabProcedure(LP.ProcedureUid)=1)))
		SELECT @patientLiability = 0
		
        IF @patientLiability = 0 -- If insurance seems to owe it all, check for any patient liability 
        BEGIN
        
			DECLARE @copay MONEY 
			DECLARE @insurancePercent SMALLINT
			DECLARE @procedureAllowed MONEY 
			DECLARE @units DECIMAL(20,1)
			DECLARE @multiplyUnits BIT
			DECLARE @coinsurance MONEY 
			
			SELECT @copay = COALESCE(FixedCopayAmount, 0), @insurancePercent = InsurancePercent, @procedureAllowed = ProcedureAllowed, 
				@units = ISNULL(Units, 1), @multiplyUnits = MultiplyUnits
				FROM dbo.SuperbillProcedure 
				WHERE SuperbillProcedureUid = @superbillProcedureUid -- pull seperate to be able to charge for sep in future
				
			IF @multiplyUnits = 0 AND @units<>1
				SELECT @units = 1
			SELECT @coinsurance = ROUND(ISNULL(@procedureAllowed, 0) * ISNULL(100-@insurancePercent, 0)/100, 2) * @units --default coinsurance amount
				-- ATTN ATTN ATTN - This is how impl in code, however, should not use the potentially LARGER Allowed value, right??  
			IF EXISTS(SELECT IC.AcceptAssignment 
					FROM dbo.SuperbillProcedure SBP 
					INNER JOIN dbo.Superbill SB ON SBP.SuperbillUid = SB.SuperbillUid
					INNER JOIN dbo.Account A ON SB.AccountUid = A.AccountUid
					INNER JOIN dbo.AccountPeriod AP ON A.AccountUid = AP.AccountUid
					INNER JOIN dbo.AccountInsurance AI ON AP.AccountPeriodUid = AI.AccountPeriodUid
					INNER JOIN dbo.PersonInsurancePlan PIP ON AI.PersonInsurancePlanUid = PIP.PersonInsurancePlanUid
					INNER JOIN dbo.InsurancePlan IP ON PIP.InsurancePlanUid = IP.InsurancePlanUid
					INNER JOIN dbo.InsuranceCarrier IC ON IP.InsuranceCarrierUid = IC.CorporationUid
					WHERE SBP.SuperbillProcedureUid = @superbillProcedureUid 
						AND AP.AccountPeriodUid = dbo.GetAccountPeriod(SB.AccountUid, ISNULL(SB.ServiceDateEnd, GetDate()))
						AND AI.DisplayOrder = 2 -- secondary
						AND IC.AcceptAssignment = 1)
				SELECT @coinsurance = 0

            SELECT @patientLiability = @copay + @coinsurance -- apply together - future if both are nonn-zero, will bill as sep charges potentially
        END

	IF (@totalCharge < @patientLiability) -- make sure does not exceed total
		SELECT @patientLiability = @totalCharge
		
	RETURN @patientLiability
	
/* Test

SELECT dbo.ARFN_SuperbillProcedure_InitialPatientLiabilityTrue(''1F6FA2D5-20D6-4D17-B094-0539FE20CFC2'')

*/

END






' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRR_DiabetesICD9]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

-- =================================================================
-- Author:		CHM
-- Create date: 03/02/2011
-- Description:	Returns a list of ICD9 code for diabetes.
-- =================================================================
CREATE FUNCTION [dbo].[ARRR_DiabetesICD9]()
RETURNS 
@DiabetesICD9 table
(
	ICD9Code varchar(255)
)
AS
begin
	declare @i int
	declare @tempList varchar(MAX)

	-- load all ICD9 codes for diabetes
	SET @tempList = 
	''250, 250.0, 250.00, 250.01, 250.02, 250.03, 250.10, 250.11, 250.12, 250.13, 250.20, 250.21, 250.22, '' +
	''250.23, 250.30, 250.31, 250.32, 250.33, 250.4, 250.40, 250.41, 250.42, 250.43, 250.50, 250.51, 250.52, '' +
	''250.53, 250.60, 250.61, 250.62, 250.63, 250.7, 250.70, 250.71, 250.72, 250.73, 250.8, 250.80, 250.81, '' +
	''250.82, 250.83, 250.9, 250.90, 250.91, 250.92, 250.93, 357.2, 362.0, 362.01, 362.02, 362.03, 362.04, '' +
	''362.05, 362.06, 362.07, 366.41, 648.0, 648.00, 648.01, 648.02, 648.03, 648.04''
	
	WHILE len(@tempList) > 0
	BEGIN
		SET @i = CHARINDEX('','', @tempList)
		
		if (@i > 0)
		BEGIN
			INSERT INTO @DiabetesICD9 (ICD9Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
			SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
		END
		ELSE BEGIN
			INSERT INTO @DiabetesICD9 (ICD9Code) VALUES ((RTRIM(LTRIM(@tempList))))		
			SET @tempList = ''''
		END
	END
	
	RETURN
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRR_DiabetesLevelOfServiceCodes]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 03/02/2011
-- Description:	Returns a list non-acute level of service CPT codes.
-- =================================================================
CREATE FUNCTION [dbo].[ARRR_DiabetesLevelOfServiceCodes]()
RETURNS 
@AcuteEMCodes TABLE
(
	Code varchar(255)
)

AS
begin
	declare @i int
	declare @tempList varchar(MAX)

	-- load non-acute CPT level service E/M codes
	SET @tempList = 
	''99304, 99305, 99306, 99307, 99308, 99309, 99310, 99315, 99316,'' +
		'' 99318, 99324, 99325, 99326, 99327, 99328, 99334, 99335, 99336, 99337, '' + -- encounter non-acute inpatient
	''99201, 99202, 99203, 99204, 99205, 99211, 99212, 99213, 99214, '' +
		''99215, 99217, 99218, 99219, 99220, 99241, 99242, 99243, 99244, '' +
		''99245, 99341, 99342, 99343, 99344, 99345, 99347, 99348, 99349, '' +
		''99350, 99384, 99385, 99386, 99387, 99394, 99395, 99396, 99397, '' +
		''99401, 99402, 99403, 99404, 99411, 99412, 99420, 99429, 99455, 99456, '' + -- encounter outpatient
	''92002, 92003, 92004, 92005, 92006, 92007, 92008, 92009, 92010, 92011, 92012, 92013, 92014'' -- encounter outpatient - opthamological services
	
	WHILE len(@tempList) > 0
	BEGIN
		SET @i = CHARINDEX('','', @tempList)
		
		if (@i > 0)
		BEGIN
			INSERT INTO @AcuteEMCodes (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
			SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
		END
		ELSE BEGIN
			INSERT INTO @AcuteEMCodes (Code) VALUES ((RTRIM(LTRIM(@tempList))))
			SET @tempList = ''''
		END
	END
	
	RETURN
end' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRR_DiabetesRxNorm]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 03/02/2011
-- Description:	Returns a list of RxNormCodes for diabetes medications.
-- =================================================================
CREATE FUNCTION [dbo].[ARRR_DiabetesRxNorm]()
RETURNS 
@RxNorm table
(
	RxNormCode varchar(255)
)
AS
begin
	declare @i int
	declare @tempList varchar(MAX)
	
	SET @tempList = 
	''199149, 199150, 200132, 205329, 205330, 205331, 401938, '' + -- Alph-glucosidas inhibitors
	''200256, 200257, 200258, 311919, 314142, 389139, 861035, 861039, 861042, 861044, 861787, 861790, '' + -- Amylin analogs
	''744863 , 847910, 847915, '' + -- Antidiabetic agents
		''602544, 602549, 602550, 647237, 647239, 706895, 706896, 861731, 861736, 861740, 861743, 861748, '' +
	''861753, 861760, 861763, 861769, 861783, 861787, 861790, 861795, 861806, 861816, 861819, 861822, '' + -- Antidiabetic-combinations
		''665033, 665038, 665042, 860975, 860978, 860981, 860984, 860996, 860999, 861004, 861007, '' +
		''861010, 861021, 861025, 861731, 861736, 861740, 861743, 861748, 861753, 861760, 861763, '' +
	''861769, 861783, 861787, 861790, 861795, 861806, 861816, 861819, 861822, '' + -- Biguanides
	''205314, 237527, 242120, 242916, 242917, 259111, 260265, 283394, 311040, 311041, '' +
	''311053, 311054, 311055, 311056, 311057, 311058, 311059, 311060, 311061, 314038, '' +
	''317800, 351297, 358349, 484322, 485210, 544614, 763002, 763007, 763013, 763014, '' +
	''833159, 847191, 847207, 847211, 847230, 847239, 847252, 847259, 847263, 847416, '' + -- Insulin
	''105374, 153842, 197306, 197307, 197495, 197496, 197737, 198291, 198292, 198293, '' +
	''198294, 199245, 199246, 199247, 199825, 199984, 199985, 200065, 252960, 310488, '' +
	''310489, 310490, 310534, 310536, 310537, 310539, 312440, 312441, 312859, 312860, '' +
	''312861, 313418, 313419, 314000, 314006, 315107, 315239, 317573, 379804, 389137, '' +
	''602544, 602549, 602550, 647237, 647239, 706895, 706896, 757710, 757712, 844809, '' +
	''844824, 844827, 861731, 861736, 861740, 861743, '' +
	''861748, 861753, 861760, 861763, 861783, 861795, 861806, 861816, 861822, '' + -- Sulfonylureas
	''312440, 312441, 312859, 312860, 312861, 317573'' -- Thiazolidinediones

	WHILE len(@tempList) > 0
	BEGIN
		SET @i = CHARINDEX('','', @tempList)
		
		if (@i > 0)
		BEGIN
			INSERT INTO @RxNorm (RxNormCode) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
			SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
		END
		ELSE BEGIN
			INSERT INTO @RxNorm (RxNormCode) VALUES ((RTRIM(LTRIM(@tempList))))		
			SET @tempList = ''''
		END
	END	
	
	RETURN
end' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRR_DiabetesAcuteLevelOfServiceCodes]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 03/02/2011
-- Description:	Returns a list acute level of service CPT codes.
-- =================================================================
CREATE FUNCTION [dbo].[ARRR_DiabetesAcuteLevelOfServiceCodes]()
RETURNS 
@AcuteEMCodes TABLE
(
	Code varchar(255)
)

AS
begin
	declare @i int
	declare @tempList varchar(MAX)

	-- load acute CPT level service E/M codes
	SET @tempList = 
	''99221, 99222, 99223, 99231, 99232, 99233, 99238, 99239, 99251, 99252, 99253, 99254, 99255, 99291, '' + -- encounter acute inpt
	''99281, 99282, 99283, 99284, 99285'' -- encounter ED
	
	WHILE len(@tempList) > 0
	BEGIN
		SET @i = CHARINDEX('','', @tempList)
		
		if (@i > 0)
		BEGIN
			INSERT INTO @AcuteEMCodes (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
			SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
		END
		ELSE BEGIN
			INSERT INTO @AcuteEMCodes (Code) VALUES ((RTRIM(LTRIM(@tempList))))
			SET @tempList = ''''
		END
	END
	
	RETURN
end' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRA_DiabetesDenominator]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- ===================================================================
-- Author:		chm
-- Create date: 03/02/2011
-- Description:	This function returns the deominator results for the
--				following ARRA rules: 0055, 0056, 0059, 0061, 0062, 
--				0064, 0575
-- ===================================================================
CREATE FUNCTION [dbo].[ARRA_DiabetesDenominator] (
	@PatientUid UNIQUEIDENTIFIER
	,@2YearsAgo DATETIME
	)
RETURNS INT
AS
BEGIN
	-- Change History :
	--
	-- Date			Edited By	Change
	-- ========================================
	-- 2013.Oct.14	JRB		Update SP to not use old diagnosis table
	--
	DECLARE @tempCnt INT
	DECLARE @metDenominator INT
	DECLARE @Visit TABLE (VisitUid UNIQUEIDENTIFIER)

	SET @metDenominator = 0

	-- is the patient currently taking any medications for diabetes
	SELECT @tempCnt = COUNT(*)
	FROM RelPatientMedication rel
	INNER JOIN MedicationSIG sig ON rel.MedicationSIGUid = sig.MedicationSIGUid
		AND rel.PatientUid = @PatientUid
		AND sig.DiscontinueReasonUid IS NULL
		AND sig.OverallStartDate >= @2YearsAgo
	INNER JOIN fdb_REVDEL0_EXT_VOCAB_LINK rev ON rev.EVD_FDB_VOCAB_ID = CONVERT(VARCHAR(255), sig.FDB_MEDID)
		OR rev.EVD_FDB_VOCAB_ID = CONVERT(VARCHAR(255), sig.FDB_MNID)
	INNER JOIN dbo.ARRR_DiabetesRxNorm() norm ON norm.RxNormCode = rev.EVD_EXT_VOCAB_ID

	IF (@tempCnt = 0)
	BEGIN -- no diabetes medications found
		-- does the patient have a history of diabetes
		SET @tempCnt = 0

		SELECT @tempCnt = COUNT(*)
		FROM PatientDXHistory pdx
		INNER JOIN ListProblemStatus lps ON pdx.ProblemStatusUid = lps.ProblemStatusUid
			AND lps.ActiveStatus = 1
			AND pdx.IsDelete = 0
		--INNER JOIN ListOldDiagnosis ld ON pdx.DiagnosisUid = ld.DiagnosisUid
		--INNER JOIN dbo.ARRR_DiabetesICD9() dia ON ld.DiagnosisCode9 = dia.ICD9Code
		INNER JOIN dbo.ARRR_DiabetesICD9() dia ON pdx.Code = dia.ICD9Code
		WHERE pdx.PatientUid = @PatientUid

		IF (@tempCnt = 0)
		BEGIN
			-- if not found in patient history; see if there is an active diagnosis for diabetes and 
			-- at less one acute encounters or at less two non-acute encounters
			DELETE @Visit

			-- get all visit
			INSERT INTO @Visit
			SELECT VisitUid
			FROM Visit
			WHERE PatientUid = @PatientUid
				AND (
					VisitTypeUid IS NULL
					OR VisitTypeUid <> ''FB954167-9D1C-43B7-9F5B-A76260654C96''
					) -- Strike Out

			SET @tempCnt = 0

			SELECT @tempCnt = COUNT(*)
			FROM VisitDiagnosis vd
			--INNER JOIN LisOldtDiagnosis ld ON vd.DiagnosisUid = ld.DiagnosisUid
			--	AND vd.IsDelete = 0
			--INNER JOIN dbo.ARRR_DiabetesICD9() dia ON ld.DiagnosisCode9 = dia.ICD9Code
			INNER JOIN dbo.ARRR_DiabetesICD9() dia ON vd.Code = dia.ICD9Code
			WHERE vd.IsDelete = 0
				AND vd.VisitUid IN (
					SELECT VisitUid
					FROM @Visit
					)
		END

		IF (@tempCnt > 0)
		BEGIN
			SET @tempCnt = 0

			-- test is there at less two an non-acute visit; test first most likely to found something
			SELECT @tempCnt = COUNT(*)
			FROM Visit v
			INNER JOIN VisitProcedure vp ON v.VisitUid = vp.VisitUid
				AND v.PatientUid = @PatientUid
				AND (
					v.VisitTypeUid IS NULL
					OR v.VisitTypeUid <> ''FB954167-9D1C-43B7-9F5B-A76260654C96''
					) -- Strike Out
				AND vp.IsDelete = 0
			INNER JOIN ListProcedure lp ON vp.ProcedureUid = lp.ProcedureUid
			INNER JOIN dbo.ARRR_DiabetesLevelOfServiceCodes() non ON lp.Code = non.Code

			IF (@tempCnt < 2)
			BEGIN
				SET @tempCnt = 0

				-- test is there at less one an acute visit
				SELECT @tempCnt = COUNT(*)
				FROM Visit v
				INNER JOIN VisitProcedure vp ON v.VisitUid = vp.VisitUid
					AND v.PatientUid = @PatientUid
					AND (
						v.VisitTypeUid IS NULL
						OR v.VisitTypeUid <> ''FB954167-9D1C-43B7-9F5B-A76260654C96''
						) -- Strike Out
					AND vp.IsDelete = 0
				INNER JOIN ListProcedure lp ON vp.ProcedureUid = lp.ProcedureUid
				INNER JOIN dbo.ARRR_DiabetesAcuteLevelOfServiceCodes() acute ON lp.Code = acute.Code
			END
		END
	END -- no diabetes medications found

	IF (@tempCnt > 0)
	BEGIN
		SET @metDenominator = 1
	END

	RETURN @metDenominator
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRR_ExcludeDiabetesICD9]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 03/02/2011
-- Description:	Returns a list of all excluded ICD9 codes for diabetes.
-- =================================================================
CREATE FUNCTION [dbo].[ARRR_ExcludeDiabetesICD9]()
RETURNS 
@ExcludeDiabetesICD9 table
(
	ICD9Code varchar(255)
)
AS
begin
	declare @i int
	declare @tempList varchar(MAX)

	-- load exclude ICD9 codes for diabetes
	SET @tempList = 
	''648.0, 648.00, 648.01, 648.02, 648.03, 648.04, '' + -- gestational diabetes
	''256.4, '' + -- polycystic ovaries
	''249, 249.0, 249.00, 249.01, 249.1, 249.10, 249.11, 249.2, 249.20, 249.21, 249.3, '' +
	''249.30, 249.31, 249.4, 249.40, 249.41, 249.5, 249.50, 249.51, 249.6, 249.60, 249.61, '' +
	''249.7, 249.70, 249.71, 249.8, 249.80, 249.81, 249.9, 249.90, 249.91, 251.8, 962.0'' -- steroid induced diabetes

	WHILE len(@tempList) > 0
	BEGIN
		SET @i = CHARINDEX('','', @tempList)
		
		if (@i > 0)
		BEGIN
			INSERT INTO @ExcludeDiabetesICD9 (ICD9Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
			SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
		END
		ELSE BEGIN
			INSERT INTO @ExcludeDiabetesICD9 (ICD9Code) VALUES ((RTRIM(LTRIM(@tempList))))
			SET @tempList = ''''
		END
	END
	
	RETURN
end	
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRA_DiabetesExclusions]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- ===================================================================
-- Author:		chm
-- Create date: 03/12/2011
-- Description:	This function returns the exclusions results for the
--				following ARRA rules: 0059, 0061
-- ===================================================================
CREATE FUNCTION [dbo].[ARRA_DiabetesExclusions] 
(
	@PatientUid uniqueidentifier
)
RETURNS int
AS
BEGIN
	DECLARE @tempCnt int
	DECLARE @metExclusion int
		
	DECLARE @Visit TABLE
	(
		VisitUid uniqueidentifier
	)
	SET @metExclusion = 0
		
	-- does the patient have any excluded diabetes icd9 codes
	SET @tempCnt = 0
	SELECT @tempCnt = COUNT(*) FROM PatientDXHistory pdx 
		INNER JOIN ListProblemStatus lps on pdx.ProblemStatusUid = lps.ProblemStatusUid 
			AND lps.ActiveStatus = 1 AND pdx.IsDelete = 0
		INNER JOIN dbo.ARRR_ExcludeDiabetesICD9() dia ON pdx.Code = dia.ICD9Code
	WHERE pdx.PatientUid = @PatientUid

	IF (@tempCnt = 0)
	BEGIN
		-- if not found in patient history; see if there is an active diagnosis for diabetes
		DELETE @Visit
		-- get all visit
		INSERT INTO @Visit
		SELECT VisitUid FROM Visit 
			WHERE PatientUid = @PatientUid 
					AND (VisitTypeUid is null OR VisitTypeUid <> ''FB954167-9D1C-43B7-9F5B-A76260654C96'') -- Strike Out
		
		SELECT @tempCnt = COUNT(*) FROM VisitDiagnosis vd
		INNER JOIN dbo.ARRR_ExcludeDiabetesICD9() dia ON vd.Code = dia.ICD9Code
		WHERE vd.IsDelete = 0 AND vd.VisitUid IN (SELECT VisitUid FROM @Visit)
	END
	
	IF (@tempCnt > 0)
	BEGIN
		SET @metExclusion = 1
	END
		
	RETURN @metExclusion
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRR_HypertensionICD9]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

-- =================================================================
-- Author:		CHM
-- Create date: 03/03/2011
-- Description:	Returns a list of ICD9 code for Hypertension.
-- =================================================================
CREATE FUNCTION [dbo].[ARRR_HypertensionICD9]()
RETURNS 
@HypertensionICD9 table
(
	ICD9Code varchar(255)
)
AS
begin
	declare @i int
	declare @tempList varchar(MAX)

	-- load all ICD9 codes for hypertension
	SET @tempList = ''401, 401.0, 401.1, 401.9''
	
	WHILE len(@tempList) > 0
	BEGIN
		SET @i = CHARINDEX('','', @tempList)
		
		if (@i > 0)
		BEGIN
			INSERT INTO @HypertensionICD9 (ICD9Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
			SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
		END
		ELSE BEGIN
			INSERT INTO @HypertensionICD9 (ICD9Code) VALUES ((RTRIM(LTRIM(@tempList))))		
			SET @tempList = ''''
		END
	END
	
	RETURN
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ARRR_OutpatientLevelOfServiceCodes]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =================================================================
-- Author:		CHM
-- Create date: 03/03/2011
-- Description:	Returns a list outpatient level of service CPT codes.
-- =================================================================
CREATE FUNCTION [dbo].[ARRR_OutpatientLevelOfServiceCodes]()
RETURNS 
@OutpatientEMCodes TABLE
(
	Code varchar(255)
)

AS
begin
	declare @i int
	declare @tempList varchar(MAX)

	-- load outpatient CPT level service E/M codes
	SET @tempList = ''99201, 99202, 99203, 99204, 99205, 99211, 99212, 99213, 99214, 99215, '' +
		''99217, 99218, 99219, 99220, 99241, 99242, 99243, 99244, 99245, 99341, 99342, 99343, '' +
		''99344, 99345, 99347, 99348, 99349, 99350, 99384, 99385, 99386, 99387, 99394, 99395, '' +
		''99396, 99397, 99401, 99402, 99403, 99404, 99411, 99412, 99420, 99429, 99455, 99456''
	
	WHILE len(@tempList) > 0
	BEGIN
		SET @i = CHARINDEX('','', @tempList)
		
		if (@i > 0)
		BEGIN
			INSERT INTO @OutpatientEMCodes (Code) VALUES ((RTRIM(LTRIM(SUBSTRING(@tempList, 1, @i - 1)))))
			SET @tempList = SUBSTRING(@tempList, @i + 1, len(@tempList) - @i)
		END
		ELSE BEGIN
			INSERT INTO @OutpatientEMCodes (Code) VALUES ((RTRIM(LTRIM(@tempList))))
			SET @tempList = ''''
		END
	END
	
	RETURN
end' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[AttachmentHandlerFileNameWildcards]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[AttachmentHandlerFileNameWildcards]()

RETURNS @AttachmentHandlersFNW TABLE (	AttachmentHandlerUid UNIQUEIDENTIFIER,
										FileNameWildcard VARCHAR(255),
										CompressionUid UNIQUEIDENTIFIER NULL,
										Priority SMALLINT							
									 )
AS
BEGIN
	DECLARE @attachmentHandlerUid UNIQUEIDENTIFIER
	DECLARE @fileNameWildcard VARCHAR(255)
	DECLARE @compressionUid UNIQUEIDENTIFIER
	DECLARE @priority SMALLINT

	DECLARE	cur CURSOR FORWARD_ONLY FOR SELECT AttachmentHandlerUid, FileNameWildcard, CompressionUid, Priority FROM ListAttachmentHandler ORDER BY Priority
	OPEN cur
	FETCH NEXT FROM cur INTO @attachmentHandlerUid, @fileNameWildcard, @compressionUid, @priority
	WHILE @@FETCH_STATUS = 0
	BEGIN
		INSERT	@AttachmentHandlersFNW
		SELECT	@attachmentHandlerUid, Element, @compressionUid, @priority
		FROM	dbo.Split(@fileNameWildcard, '';'')

		FETCH NEXT FROM cur INTO @attachmentHandlerUid, @fileNameWildcard, @compressionUid, @priority
	END
	RETURN
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatchProcessStatementsPortalOnlyCount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[BatchProcessStatementsPortalOnlyCount](@BatchProcessUid UNIQUEIDENTIFIER)
RETURNS INT
AS
BEGIN
	DECLARE @Completed int

  select @Completed = count(*)
  from StatementBatchDetail sbd 
  LEFT JOIN BatchProcessDetail bpd ON bpd.BatchProcessUid = @BatchProcessUid
  where sbd.StatementBatchDetailUid = bpd.Uid AND sbd.AttachmentUid IS NOT NULL AND sbd.CompletionStatus = 2

  return @Completed
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatchProcessStatementsPrintedCount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[BatchProcessStatementsPrintedCount](@BatchProcessUid UNIQUEIDENTIFIER)
RETURNS INT
AS
BEGIN
	DECLARE @Completed int

  select @Completed = count(*)
  from StatementBatchDetail sbd 
  LEFT JOIN BatchProcessDetail bpd ON bpd.BatchProcessUid = @BatchProcessUid
  where sbd.StatementBatchDetailUid = bpd.Uid AND sbd.AttachmentUid IS NOT NULL AND sbd.CompletionStatus = 1

  return @Completed
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatchProcessStatementsSubmittedCount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[BatchProcessStatementsSubmittedCount](@BatchProcessUid UNIQUEIDENTIFIER)
RETURNS INT
AS
BEGIN
	DECLARE @Completed int

  select @Completed = count(*)
  from StatementBatchDetail sbd 
  LEFT JOIN BatchProcessDetail bpd ON bpd.BatchProcessUid = @BatchProcessUid
  where sbd.StatementBatchDetailUid = bpd.Uid AND sbd.AttachmentUid IS NOT NULL AND (sbd.CompletionStatus = 3 or sbd.CompletionStatus = 4)

  return @Completed
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BatchProcessStatementsWithAttachmentCount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[BatchProcessStatementsWithAttachmentCount](@BatchProcessUid UNIQUEIDENTIFIER)
RETURNS INT
AS
BEGIN
	DECLARE @Completed int

  select @Completed = count(*)
  from StatementBatchDetail sbd 
  LEFT JOIN BatchProcessDetail bpd ON bpd.BatchProcessUid = @BatchProcessUid
  where sbd.StatementBatchDetailUid = bpd.Uid AND sbd.AttachmentUid IS NOT NULL

  return @Completed
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[BigIntToGUID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[BigIntToGUID](@PK_ID bigint)
RETURNS uniqueidentifier AS

BEGIN

  declare @Wrk varchar(200)
  declare @NewGUID uniqueidentifier
  declare @Neg bit

  if @PK_ID = 0
   return ''00000000-0000-0000-0000-00000000FFFF''

  if @PK_ID is not null
    begin
      if (@PK_ID < 0)
        begin
         set @Neg = 1
          set @PK_ID = -1 * @PK_ID
        end
      set @Wrk = convert (varchar(200), @PK_ID)
      while len(@Wrk) < 32 set @Wrk = ''0'' + @Wrk

      if (@Neg = 1 )
             set @Wrk = ''FFFFFFFF'' + ''-'' + SUBSTRING(@Wrk, 9, 4) + ''-'' + SUBSTRING(@Wrk, 13, 4)
                              + ''-'' + SUBSTRING(@Wrk, 17, 4) + ''-'' + SUBSTRING(@Wrk, 21, 12)
      else
             set @Wrk = SUBSTRING(@Wrk, 1, 8) + ''-'' + SUBSTRING(@Wrk, 9, 4) + ''-'' + SUBSTRING(@Wrk, 13, 4)
                              + ''-'' + SUBSTRING(@Wrk, 17, 4) + ''-'' + SUBSTRING(@Wrk, 21, 12)
      set @Wrk = ''{'' + @Wrk + ''}''
      set @NewGUID = @Wrk
    end

  return (@NewGUID)
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CanDeleteVisitAfterDeleteObservationOrder]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[CanDeleteVisitAfterDeleteObservationOrder](@ObservationOrderUid UNIQUEIDENTIFIER, @VisitUid UNIQUEIDENTIFIER = ''00000000-0000-0000-0000-000000000000'', @ForFNCDelete bit = 0) RETURNS BIT AS
BEGIN
   DECLARE 
      @VisitProcedureUid UNIQUEIDENTIFIER

	IF (@ForFNCDelete = 0)
	BEGIN
		SELECT 
			@VisitUid          = VisitUid,
			@VisitProcedureUid = VisitProcedureUid
		FROM ObservationOrder 
		WHERE ObservationOrderUid = @ObservationOrderUid
	END
   
   IF (@VisitProcedureUid IS NULL) SELECT @VisitProcedureUid = ''00000000-0000-0000-0000-000000000000''

   IF (@VisitUid IS NULL) RETURN 0
   IF EXISTS(SELECT * FROM Visit tab WHERE tab.VisitUid = @VisitUid AND tab.IsCompleted = 1) RETURN 0

   IF (@ForFNCDelete = 0)
   BEGIN
		IF NOT EXISTS(SELECT * FROM Visit tab WHERE tab.VisitUid = @VisitUid AND tab.VisitTypeUid = ''6A18A657-B912-4C12-828E-A3DF8571D205'') RETURN 0
		
		IF EXISTS(SELECT * FROM RelAttachmentGroup tab WHERE tab.VisitUid = @VisitUid AND tab.ObservationOrderUid != @ObservationOrderUid) RETURN 0
		IF EXISTS(SELECT * FROM ObservationOrder tab WHERE tab.VisitUid = @VisitUid AND tab.ObservationOrderUid != @ObservationOrderUid) RETURN 0
		IF EXISTS(SELECT * FROM ObservationOrder tab WHERE tab.ResultingVisitUid = @VisitUid AND tab.ObservationOrderUid != @ObservationOrderUid) RETURN 0
		IF EXISTS(SELECT * FROM ObservationValue tab WHERE tab.VisitUid = @VisitUid AND tab.ObservationOrderUid != @ObservationOrderUid) RETURN 0
		IF EXISTS(SELECT * FROM VisitAssessmentForm tab WHERE tab.VisitUid = @VisitUid AND tab.ObservationOrderUid != @ObservationOrderUid) RETURN 0
		IF EXISTS(SELECT * 
             FROM Message tab 
             LEFT JOIN MessageHL7 mhl ON mhl.MessageUid = tab.MessageUid AND mhl.ObservationOrderUid = @ObservationOrderUid
             LEFT JOIN  RelMessageHL7ObservationOrder mrl ON mrl.MessageUid = tab.MessageUid AND mrl.ObservationOrderUid = @ObservationOrderUid
             WHERE tab.VisitUid = @VisitUid 
               AND mhl.MessageUid IS NULL 
               AND mrl.MessageUid IS NULL) RETURN 0
		IF EXISTS(SELECT * FROM Superbill tab WHERE tab.VisitUid = @VisitUid) RETURN 0
		IF EXISTS(SELECT * FROM VisitCC tab WHERE tab.VisitUid = @VisitUid) RETURN 0
		IF EXISTS(SELECT * FROM VisitComplexity tab WHERE tab.VisitUid = @VisitUid) RETURN 0
		IF EXISTS(SELECT * FROM VisitComment tab WHERE tab.VisitUid = @VisitUid) RETURN 0
		IF EXISTS(SELECT * FROM VisitCoSign tab WHERE tab.VisitUid = @VisitUid) RETURN 0
		IF EXISTS(SELECT * FROM VisitData tab WHERE tab.VisitUid = @VisitUid) RETURN 0
		IF EXISTS(SELECT * FROM VisitEduForm tab WHERE tab.VisitUid = @VisitUid) RETURN 0
		IF EXISTS(SELECT * FROM VisitPlan tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   END
   ELSE BEGIN -- for FNC delete
		IF EXISTS(SELECT * FROM ObservationOrder oo 
						INNER JOIN ObservationValue ov ON oo.ObservationOrderUid = ov.ObservationOrderUid 
						INNER JOIN ListObservationItem loi ON ov.ObservationItemUid = loi.ObservationItemUid
							AND loi.Name <> ''BMI''
					WHERE loi.IsVitals <> 1 and oo.VisitUid = @visitUid) RETURN 0
   END

   IF EXISTS(SELECT * FROM ClinicalDecisionSupportResults tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM eRxOutbound tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM FaxQueue tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM ImmunizationHistory tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM MedicationSIG tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM MessageAN tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM MessageAuthorization tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM MessageERxChangeRequest tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM MessageERxRefillRequest tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM MessageInstantMessage tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM MessagePatientLabOrder tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM MessageRxRefill tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM MessageVisitBilling tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM PatientCareManagementLog tab WHERE tab.LoggedFromVisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM PatientDXHistory tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM PatientFamilyHistory tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM PatientHistory tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM PatientProblem tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM PatientProblemDiagnosis tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM PatientProblemDiagnosisHistory tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM PatientProcedure tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM PatientProcedureHistory tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM PatientRecall tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM PatientRecall tab WHERE tab.OriginVisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM PatientReferral tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM PQRIHistory tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM RecordDisclosureAudit tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM RelPatientMedication tab WHERE tab.EnteredFromVisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM RelScheduledEduForm tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM RelVisitMedication tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM ScheduledPQRIUpdate tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM VisitAccess tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM VisitCommentExtension tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * 
             FROM VisitDiagnosis tab 
			 LEFT JOIN VisitProcedureDiagnosis org ON org.VisitDiagnosisUid = tab.VisitDiagnosisUid
			 WHERE tab.VisitUid = @VisitUid
			   and (org.VisitProcedureDiagnosisUid IS NULL OR org.VisitProcedureUid != @VisitProcedureUid)) RETURN 0
   IF EXISTS(SELECT * FROM VisitGraphicNotes tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM VisitHpi tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM VisitWatchItem tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM VisitOutsideProvider tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM VisitPE tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM VisitProcedure tab WHERE tab.VisitUid = @VisitUid AND tab.VisitProcedureUid != @VisitProcedureUid) RETURN 0
   IF EXISTS(SELECT * FROM VisitRos tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM VisitTranscription tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   IF EXISTS(SELECT * FROM VisitVoiceAttachment tab WHERE tab.VisitUid = @VisitUid) RETURN 0
   
   RETURN 1
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAge]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[GetAge](@birthdate DATE, @date DATE) RETURNS INT AS
BEGIN
	DECLARE @age INT
	
	SET @age = FLOOR(DATEDIFF(day, @birthdate, @date) / 365.25)
	
	RETURN @age
END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CHCGetAgeLevel]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[CHCGetAgeLevel](@personUid UNIQUEIDENTIFIER, @date DATE) RETURNS VARCHAR(50) AS
BEGIN
	DECLARE @birthdate DATE
	SELECT @birthdate = Birthdate FROM Person p WHERE p.PersonUid = @personUid
	DECLARE @age SMALLINT
	SET @age = dbo.GetAge(@birthdate, CASE WHEN @date IS NULL THEN GETDATE() ELSE @date END)
	
	IF @age < 1 
		RETURN ''0 - 1''
	IF @age < 4 
		RETURN ''1 - 4''
	IF @age < 7 
		RETURN ''4 - 7''
	IF @age < 12 
		RETURN ''8 - 12''
	IF @age < 17 
		RETURN ''13 - 17''
	IF @age < 26 
		RETURN ''18 - 26''
	IF @age < 39 
		RETURN ''27 - 39''
	IF @age < 49 
		RETURN ''40 - 49''
	IF @age < 64 
		RETURN ''50 - 64''
	RETURN ''65+''	
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CHCGetInsuranceType]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[CHCGetInsuranceType](@SuperbillUid UNIQUEIDENTIFIER) 
  RETURNS UNIQUEIDENTIFIER 
AS
BEGIN
	DECLARE @retUid UNIQUEIDENTIFIER
	set @retUid = ''10101010-0000-7777-0000-000000000001'' -- Primary Insurance Carrier
	return @retUid ;
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CHCGetPovertyLevel]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[CHCGetPovertyLevel](@accountUid UNIQUEIDENTIFIER, @date DATE) RETURNS VARCHAR(50) AS
BEGIN
	DECLARE @unitedStates AS UNIQUEIDENTIFIER, 
			@alaska AS UNIQUEIDENTIFIER, 
			@hawaii AS UNIQUEIDENTIFIER, 
			@region  AS UNIQUEIDENTIFIER 
	DECLARE @state VARCHAR(3)
	DECLARE @accountResponsiblePartyUid UNIQUEIDENTIFIER
	
	SELECT	@state = p.Address1.value(''(/Address/State)[1]'', ''varchar(100)''),
			@accountResponsiblePartyUid = a.AccountResponsiblePartyUid
	FROM	Account a INNER JOIN AccountResponsibleParty arp ON a.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid
			INNER JOIN Person p ON arp.PersonUid = p.PersonUid
	WHERE	a.AccountUid = @accountUid

	SET @unitedStates = ''10101010-0000-0000-1001-000000000001''
	SET @alaska = ''10101010-0000-0000-1001-000000000002''
	SET @hawaii = ''10101010-0000-0000-1001-000000000003''
	
	IF @state = ''AK''
		SET @region = @alaska
	ELSE IF @state = ''HI''
		SET @region = @hawaii
	ELSE 
		SET @region = @unitedStates
	
	DECLARE @baseAmount MONEY
	DECLARE @incrementalAmount MONEY
	SET @baseAmount = -1.00
	
	SELECT TOP 1	@baseAmount = BaseAmount, @incrementalAmount = IncrementalAmount
	FROM			ChcListFPLSchedule
	WHERE			FPLRegionUid = @region AND
					CAST(EffectiveDate AS DATE) < @date
	ORDER BY		EffectiveDate DESC
	
	DECLARE @familySize SMALLINT
	DECLARE @annualIncome MONEY
	SELECT	@familySize = FamilySize, @annualIncome = MonthlyIncome * 12.0
	FROM	CHCAccountResponsibleParty
	WHERE	AccountResponsiblePartyUid = @accountResponsiblePartyUid
	
	IF @familySize = 0 OR @baseAmount = -1
		RETURN ''Unknown/Not Provided''
		
	DECLARE @FPL_FamSz_Amount MONEY 
	DECLARE @dPercentPoverty DECIMAL (8,2)
	DECLARE @nPercentPoverty INT
	
	IF @familySize = 1 OR @incrementalAmount = 0
		SET @FPL_FamSz_Amount = @baseAmount 
	ELSE
		SET @FPL_FamSz_Amount = @baseAmount + (@incrementalAmount * (@familySize - 1))
		
	SET @dPercentPoverty = (@annualIncome / @FPL_FamSz_Amount)  * 100
	SET @nPercentPoverty = ROUND(@dPercentPoverty, 0)
	
	IF @nPercentPoverty <= 100 
		RETURN ''100% of less''
	IF @nPercentPoverty <= 150
		RETURN ''100-150%''
	IF @nPercentPoverty <= 200
		RETURN ''150-200%''
	IF @nPercentPoverty <= 250
		RETURN ''200-250%''
	IF @nPercentPoverty <= 300
		RETURN ''250-300%''
	IF @nPercentPoverty > 300
		RETURN ''Above 300%''
	
	RETURN ''Unknown/Not Provided''
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CheckANDGetDateFormat]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[CheckANDGetDateFormat]
(
	@Date VARCHAR(50)
)RETURNS VARCHAR(50)
BEGIN

	IF(ISDATE(@Date)=0)
	BEGIN
		If(LTRIM(RTRIM(@Date))='''')
			SET @Date=''-2''
		ELSE
		BEGIN
			DECLARE
			@IDate			INT,
			@C				INT

			SET @IDate=0
			SET @C=0
			
			WHILE @C<LEN(@Date)
			BEGIN	
				If(Substring(@Date,@C,1)=''/'' OR Substring(@Date,@C,1)=''-'')
				BEGIN
					SET @IDATE=@IDATE+1
				END
				SET @C=@C+1
			END
			
			IF (@IDate=0)
--				SET @Date=''-1''
				SET @Date=''01/01/'' + @Date
			ELSE IF (@IDate=1)
				SET @Date=''01/'' + @Date
		END
	END
	
	RETURN @Date		
END

' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CheckPath]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[CheckPath](@path [nvarchar](4000))
RETURNS [bit] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[CheckPath]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CheckRecurTimeType]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE function [dbo].[CheckRecurTimeType]
(
	@RecurTimeTypeUID UNIQUEIDENTIFIER,
	@dt DateTime,
	@recurValue smallint
)
Returns datetime
begin
	Declare @retDate DateTime
	Declare @str varchar(20)

	Select @str=[Name] from ListTimeType where TimeTypeuid = @RecurTimeTypeUID
	
	set @retDate=@dt

	if 	@str = ''Days'' 	
		Set @retDate = DateAdd(day,@recurValue,@dt)
	else if @str = ''Weeks'' 
	begin
		Set @recurValue = @recurValue * 7
		Set @retDate = DateAdd(day,@recurValue,@dt)
	end
	else if @str = ''Months''  
		Set @retDate = DateAdd(month,@recurValue,@dt)
	else if @str = ''Years'' 
		Set @retDate = DateAdd(year,@recurValue,@dt)

	return @retDate 

END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CombineList]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[CombineList]
	(
		@filter varchar(max)
	)
RETURNS varchar(max)
AS
BEGIN
	declare @orderlist varchar(max)
	select @orderlist = ''''

	select @orderlist =  convert(varchar(10), displayorder) + '','' + @orderlist   from ListMisc where ListType = @filter order by DisplayOrder desc
	select @orderlist = left(@orderlist, len(@orderlist)-1)

	RETURN @orderlist
end
' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ComparePRMVersion]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ComparePRMVersion](@VersionA [nvarchar](32), @VersionB [nvarchar](32))
RETURNS [int] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[ComparePRMVersion]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Date_ConvertDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[Date_ConvertDate]
	(
	@date datetime
	)
RETURNS datetime
AS
	BEGIN
	RETURN cast(convert(varchar, @date, 101) AS datetime)
	END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ConvertDateOnly]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ConvertDateOnly]
	(
	@date datetime
	)
RETURNS datetime
AS
	BEGIN
	RETURN dbo.Date_ConvertDate(@date)
	END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[convertFractionToDecimal]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[convertFractionToDecimal](@STR VARCHAR(50))
RETURNS decimal(18,2)
AS
BEGIN
        DECLARE @L VARCHAR(50) = ''''
        DECLARE @A DECIMAL(18,10) = 0
        SET @STR = LTRIM(RTRIM(@STR)); -- Remove extra spaces
        IF ISNUMERIC(@STR) > 0 SET @A = CONVERT(DECIMAL(18,10), @STR) -- Check to see if already real number
        IF CHARINDEX('' '',@STR,0) > 0
        BEGIN
            SET @L = SUBSTRING(@STR,1,CHARINDEX('' '',@STR,0) - 1 )
            SET @STR = SUBSTRING(@STR,CHARINDEX('' '',@STR,0) + 1 ,50 )
            SET @A = CONVERT(DECIMAL(18,10), @L)
        END
        IF CHARINDEX(''/'',@STR,0) > 0
        BEGIN
            SET @L = SUBSTRING(@STR,1,CHARINDEX(''/'',@STR,0) - 1 )
            SET @STR = SUBSTRING(@STR,CHARINDEX(''/'',@STR,0) + 1 ,50 )
            SET @A =  @A + ( CONVERT(DECIMAL(18,10), @L) / CONVERT(DECIMAL(18,10), @STR)  )
        END
        RETURN @A
END
' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ConvertLocalToUTCTime]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ConvertLocalToUTCTime](@localTime [datetime])
RETURNS [datetime] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[ConvertLocalToUTCTime]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ConvertStringToNumeric]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ConvertStringToNumeric] (@Value TEXT)
RETURNS NUMERIC(12, 2)
AS
BEGIN
	DECLARE @string VARCHAR(max)

	SET @string = CONVERT(VARCHAR(MAX), @Value)

	--set @string=''abc93.3ad4''
	DECLARE @IncorrectCharLoc SMALLINT

	SET @IncorrectCharLoc = PATINDEX(''%[^0-9.-]%'', @string)

	WHILE @IncorrectCharLoc > 0
	BEGIN
		SET @string = STUFF(@string, @IncorrectCharLoc, 1, '''')
		SET @IncorrectCharLoc = PATINDEX(''%[^0-9.-]%'', @string)
	END

	SET @string = @string

	IF ISNUMERIC(LEFT(@string,30)) = 1
		AND LEN(@string) > 0
		AND @string != ''.''
		AND @string != ''-''
		AND @string != ''.-''
		AND Len(@string) <= 9
		AND @string != ''-.''
	BEGIN
		RETURN CONVERT(NUMERIC(10, 2), @string)
	END

	RETURN - 1
END' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ConvertTimeByTimezone]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ConvertTimeByTimezone](@datetime [datetime], @timezone [nvarchar](max))
RETURNS [datetime] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[ConvertTimeByTimezone]' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ConvertTimeToTimezone]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ConvertTimeToTimezone](@datetime [datetime], @timezone [nvarchar](max))
RETURNS [datetime] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[ConvertTimeToTimezone]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ConvertToBytes]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[ConvertToBytes](@input varchar(50)) RETURNS BIGINT AS
BEGIN
	IF SUBSTRING(@input, DATALENGTH(@input) - 1, 2) = ''KB''
		RETURN convert(BIGINT, SUBSTRING(@input, 0, DATALENGTH(@input) - 2)) * 1024
	
	RETURN convert(BIGINT, SUBSTRING(@input, 0, DATALENGTH(@input) - 2)) * 1024 * 1024
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ConvertToTimeZonePracticeSettings]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ConvertToTimeZonePracticeSettings](@dt DATETIME) RETURNS DATETIME AS
BEGIN
	DECLARE @timezone VARCHAR(30)
	DECLARE @timeZoneAdj smallint
	DECLARE @daylightsavings bit

	SELECT @timezone = StringValue FROM ListProductParameter WHERE ParameterName = ''TimeZoneString''
	IF @timezone IS NULL
	BEGIN
		SELECT @timeZoneAdj = InTimeZoneAdj, @daylightsavings = ObserveDaylightSavings FROM PracticeSettings

		IF @timeZoneAdj = -5
			SET @timezone = ''Eastern Standard Time''
		ELSE IF @timeZoneAdj = -6
			SET @timezone = ''Central Standard Time''
		ELSE IF @timeZoneAdj = -7 AND @daylightsavings = 0
			SET @timezone = ''US Mountain Standard Time''
		ELSE IF @timeZoneAdj = -7
			SET @timezone = ''Mountain Standard Time''
		ELSE IF @timeZoneAdj = -8
			SET @timezone = ''Pacific Standard Time''
		ELSE IF @timeZoneAdj = -9
			SET @timezone = ''Alaskan Standard Time''
		ELSE IF @timeZoneAdj = -10
			SET @timezone = ''Hawaiian Standard Time''
		ELSE 
			SET @timezone = ''local''
		END

	RETURN dbo.ConvertTimeByTimezone(@dt, @timezone)
END
' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CopyKDBOverride]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[CopyKDBOverride](@src [xml], @srcUid [uniqueidentifier], @dst [xml], @dstUid [uniqueidentifier])
RETURNS [xml] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[CopyKDBOverride]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CorrectVMCProviderExternalID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE function [dbo].[CorrectVMCProviderExternalID] (@ExternalID varchar(200))  
 returns varchar(200) as
begin
	declare @returnID varchar(200)
	declare @i int

	set @returnID = @ExternalID	
	set @i = 0

	while (@i <= len(@ExternalID))
	begin
		set @i = @i + 1
 		if ((substring(@ExternalID, @i, 1) > ''9'') or (substring(@ExternalID, @i, 1) < ''0''))
		begin
			set @returnID = substring (@ExternalID, 1, @i - 1)
			break
		end
	end

	return @returnID
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Date_EndOfMonth]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[Date_EndOfMonth]
	(@dtCurrent DATETIME) 
RETURNS DATETIME
AS
BEGIN
	RETURN DATEADD(DD, -1, CONVERT(DATETIME, CONVERT(VARCHAR, DATEPART(MM, DATEADD(MM, 1, @dtCurrent))) + ''/1/'' + CONVERT(VARCHAR, DATEPART(YY, DATEADD(MM, 1, @dtCurrent)))))
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Date_LocalToUTC]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE function [dbo].[Date_LocalToUTC]  
 (@inLocaleDateTime datetime,  -- the time to convert to local (should be a local datetime value)  
 @inTimeZoneAdj int,   -- the number of hours to adjust for the local timezone  
 @bObserveDaylightSavings tinyint) -- whether or not the local area observes US daylight savings time  
 returns datetime as
BEGIN

declare @outLocalDateTime datetime  
set @outLocalDateTime = dateadd(hh, -1 * @inTimeZoneAdj, @inLocaleDateTime)  
if (@bObserveDaylightSavings = 1) -- figure in daylight savings time  
BEGIN 
	declare @yearToCheck int  
	set @yearToCheck = datepart(yyyy, @outLocalDateTime)  
	declare @DSstart datetime, @DSend datetime  

	-- If 2k7 or greater...
	if ( @yearToCheck >= 2007 )
	BEGIN
	-- determine if we''re in daylight savings time (second Sunday in march through first Sunday in november)  
	   set @DSstart = convert(varchar(4), @yearToCheck) + ''-03-08 02:00:00.000''  
	   set @DSend = convert(varchar(4), @yearToCheck) + ''-11-1 02:00:00.000''  
	   -- figure out the first sunday in April  
	   while (datepart(dw, @DSstart) <> 1) -- dw is 1 for Sunday  
		set @DSstart = dateadd(dd, 1, @DSstart)  
	   -- figure out the last sunday in October  
	   while (datepart(dw, @DSend) <> 1) -- dw is 1 for Sunday  
		set @DSend = dateadd(dd, 1, @DSend)  
	END
	ELSE -- if less than 2k7
	BEGIN
		-- determine if we''re in daylight savings time (1st Sunday in April through last Sunday in October)  
		set @DSstart = convert(varchar(4), @yearToCheck) + ''-04-01 02:00:00.000''  
		set @DSend = convert(varchar(4), @yearToCheck) + ''-10-31 02:00:00.000''  
		-- figure out the first sunday in April  
		while (datepart(dw, @DSstart) <> 1) -- dw is 1 for Sunday  
			set @DSstart = dateadd(dd, 1, @DSstart)  
		-- figure out the last sunday in October  
		while (datepart(dw, @DSend) <> 1) -- dw is 1 for Sunday  
			set @DSend = dateadd(dd, -1, @DSend)  
	END

	-- If in daylight savings, adjust
	if ((@outLocalDateTime >= @DSstart) and (@outLocalDateTime < @DSend))  
		set @outLocalDateTime = dateadd(hh, -1, @outLocalDateTime)  

END -- if observe daylight savings
return @outLocalDateTime  

END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Date_MMDDYY]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



-- the function returns date in MMDDYY format
CREATE    FUNCTION [dbo].[Date_MMDDYY]
(
	@pDate DATETIME
)
RETURNS VARCHAR(6)
AS
BEGIN

	DECLARE @retDate VARCHAR(6)	
	SET @retDate =
		CASE WHEN @pDate <> '''' THEN
			 
			CASE WHEN DATEPART(mm,@pDate) < 10 THEN 
				''0'' + CONVERT(varchar,DATEPART(mm,@pDate)) + CASE WHEN DATEPART(dd,@pDate) < 10 THEN ''0'' + CONVERT(varchar,DATEPART(dd,@pDate)) + RIGHT(DATEPART(yy,@pDate),2) ELSE CONVERT(varchar,DATEPART(dd,@pDate)) + RIGHT(DATEPART(yy,@pDate),2) END
			ELSE
				CONVERT(varchar,DATEPART(mm,@pDate)) +  CASE WHEN DATEPART(dd,@pDate) < 10 THEN ''0'' + CONVERT(varchar,DATEPART(dd,@pDate)) + RIGHT(DATEPART(yy,@pDate),2) ELSE CONVERT(varchar,DATEPART(dd,@pDate)) + RIGHT(DATEPART(yy,@pDate),2) END
			END
		ELSE
			''''
		END
	RETURN @retDate

END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getEndOfMonth]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[getEndOfMonth]
	(@dtCurrent DATETIME) 
RETURNS DATETIME
AS
BEGIN
	RETURN dbo.Date_EndOfMonth(@dtCurrent)
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Date_RelativeFiscalMonthEnd]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[Date_RelativeFiscalMonthEnd]
(
	@dtCurrent DATETIME
)
RETURNS DATETIME
AS
BEGIN
	-- Returns the end of the fiscal month containing the given date
	DECLARE @currentPeriodEnd DATETIME 
	DECLARE @relativePeriodEnd DATETIME
	DECLARE @endOfMonthFlag SMALLINT

	SELECT @currentPeriodEnd = CurrentPeriodEnd, @endOfMonthFlag = CurrentPeriodEndOfMonth FROM PracticeSettings

	IF (@endOfMonthFlag = 1)
		SET @relativePeriodEnd = dbo.getEndOfMonth(@dtCurrent)
	ELSE
		BEGIN
			SET @relativePeriodEnd = DATEADD(MM, DATEDIFF(MM, @currentPeriodEnd, @dtCurrent), @currentPeriodEnd)
			IF (@relativePeriodEnd < @dtCurrent)
				SET @relativePeriodEnd = DATEADD(MM, 1, @relativePeriodEnd)
		END
	RETURN @relativePeriodEnd
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Date_RelativeFiscalYearEnd]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[Date_RelativeFiscalYearEnd]
(
	@dtCurrent datetime
)
RETURNS DATETIME
AS
BEGIN
	-- Returns the end of the fiscal year containing the given date 

	DECLARE @currentFiscalYearEnd DATETIME
	DECLARE @fiscalYearEnd DATETIME
	SELECT @currentFiscalYearEnd = FiscalYearEnd FROM PracticeSettings
 
	SET @fiscalYearEnd = DATEADD(YY, DATEDIFF(YY, @currentFiscalYearEnd, @dtCurrent), @currentFiscalYearEnd)

	IF (@fiscalYearEnd < @dtCurrent)
		SET @fiscalYearEnd = DATEADD(YY, 1, @fiscalYearEnd)
	RETURN @fiscalYearEnd
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Date_SameDay]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[Date_SameDay] (@dtDate1 DATE, @dtDate2 DATE)
RETURNS int AS
BEGIN
RETURN(select (CASE WHEN @dtDate1 = @dtDate2 THEN 1 ELSE 0 END))
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Date_Sunday]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[Date_Sunday]
 (@dateForSunday DATETIME,
 @isAPR INT)  

RETURNS DATETIME 
 AS  

BEGIN 
	DECLARE	 @date1 	 AS	DATETIME
	DECLARE	 @year 		AS	 INT

	SET	 @year=YEAR(@dateForSunday)		
	IF @isAPR = 0				--Firt Sunday of April
	BEGIN 
		SET	 @date1=CONVERT(DATETIME, CAST(@year AS VARCHAR)+''-4-1 02:00'')
			--print @date1
			WHILE 1 = 1
			BEGIN
				IF DATEPART(dw, @date1) = 1
				   BREAK			--First sunday of April
				ELSE
				   SET	 @date1=DATEADD(DAY, 1, @date1)
			END
			--print @date1
	END
	ELSE				--Last Sunday of October
	BEGIN
		SET	 @date1=CONVERT(DATETIME, cast(@year AS VARCHAR)+''-10-31 02:00'')
	
	--print @date1
	WHILE 1 = 1
	BEGIN
		IF DATEPART(dw, @date1) = 1
		   BREAK			--Last sunday of October
		ELSE
		   SET @date1=DATEADD(DAY, -1, @date1)
	END
	
	--print @date1
	END
	RETURN (@date1)
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Date_UTCToLocal]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[Date_UTCToLocal] 
	(	
		@utcDate DATETIME,
		@inTimeZoneAdj INT,					-- the number of hours to adjust for the local timezone
		@bObserveDaylightSavings TINYINT	-- whether or not the local area observes US daylight savings time
	)  
RETURNS 
	DATETIME
AS  
BEGIN 
	RETURN	DATEADD(mi,DATEDIFF(mi, dbo.Date_LocalToUTC(@utcDate, @inTimeZoneAdj, @bObserveDaylightSavings) ,@utcDate ),@utcDate)--Orignal
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getPracticeUTCDateTime]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE  function [dbo].[getPracticeUTCDateTime]
	(@inUTCDateTime datetime)		-- the time to convert to UTC (should be a local datetime value)
	returns datetime as
begin
	declare @inTimeZoneAdj int			-- the number of hours to adjust for the local timezone
	declare @bObserveDaylightSavings tinyint	-- whether or not the local area observes US daylight savings time

	select top 1 @inTimeZoneAdj=InTimeZoneAdj, @bObserveDaylightSavings=ObserveDaylightSavings from PracticeSettings
	return dbo.Date_LocalToUTC(@inUTCDateTime, @inTimeZoneAdj, @bObserveDaylightSavings)
end





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Date_UTCToLocal_Practice]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[Date_UTCToLocal_Practice] 
(@utcDate DATETIME)  
RETURNS 
	DATETIME
AS  
BEGIN 
Return	DateAdd(mi,dateDiff(mi, dbo.getPracticeUTCDateTime(@utcDate) ,@utcDate ),@utcDate)--Orignal
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DateAsYYYYMMInt]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[DateAsYYYYMMInt]
(@Date date)
RETURNS INT
AS
BEGIN
RETURN (YEAR(@Date) * 100) + MONTH(@Date)

END' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DeleteKDBOverride]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[DeleteKDBOverride](@kdb [xml], @uid [uniqueidentifier])
RETURNS [xml] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[DeleteKDBOverride]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Diagnosis_GetCode]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE FUNCTION [dbo].[Diagnosis_GetCode] (@code9 varchar(25), @code10 varchar(25))
RETURNS varchar(25) AS
BEGIN

-- MIRRORS IMO_ICD_Helper in code

IF(NOT @code10 IS NULL)
	RETURN @code10;

IF (NOT @code9 IS NULL)
	RETURN @code9;

RETURN NULL; 

END 



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Diagnosis_GetFullDescription]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[Diagnosis_GetFullDescription] (@code9 varchar(25), @code10 varchar(25), @description varchar(255))
RETURNS varchar(512) AS
BEGIN

-- MIRRORS IMO_ICD_Helper in code

DECLARE @codePortion VARCHAR(100);

IF(@code10 IS NULL OR @code10='''')
	SET @codePortion = @code9;

IF(NOT @code10 IS NULL AND NOT @code10='''')
	SET @codePortion = @code10 + ''-'' + @code9;

IF (NOT @codePortion IS NULL AND NOT @codePortion='''')
	RETURN ''('' + @codePortion + '') '' + ISNULL(@description,''<DISC NOT DEFINED>''); -- DISC NOT DEFINED should never happen

RETURN ''''; 

END 





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DispensableDrugTypeDesc]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[DispensableDrugTypeDesc](@medid INT,
                                               @pmid VARCHAR(20),
                                               @federaldeaclasscode VARCHAR(1),
                                               @nametypecode VARCHAR(1),
                                               @refmultisourcecode VARCHAR(1),
                                               @reffederallegendcode VARCHAR(1),
                                               @medicaldeviceind SMALLINT,
                                               @refgenericdrugnamecode VARCHAR(1))  RETURNS VARCHAR(100)
AS
BEGIN
   RETURN CASE
             WHEN @medid IS NULL OR @medid < 1 THEN ''User Defined Drug''
             WHEN (@pmid IS NULL OR @pmid = '''') AND @medicaldeviceind <> 1 THEN ''NDC Required for non-supply Rx/''
             WHEN @federaldeaclasscode = ''0'' THEN ''''
             WHEN @federaldeaclasscode = ''1'' THEN ''DEA Schedule I/''
             WHEN @federaldeaclasscode = ''2'' THEN ''DEA Schedule II/''
             WHEN @federaldeaclasscode = ''3'' THEN ''DEA Schedule III/''
             WHEN @federaldeaclasscode = ''4'' THEN ''DEA Schedule IV/''
             WHEN @federaldeaclasscode = ''5'' THEN ''DEA Schedule V/''
             WHEN @federaldeaclasscode = ''6'' THEN ''Related products span multiple DEA Schedules/''
             ELSE ''Unknown DEA Schedule/''
          END +
          CASE
             WHEN @refmultisourcecode IN(''1'',''3'') AND @nametypecode = ''1'' THEN ''Multi Source Brand''
             WHEN @refmultisourcecode IN(''1'',''3'') AND @nametypecode = ''2'' THEN ''Multi Source Generic''
             WHEN @refmultisourcecode IN(''1'',''3'')                         THEN ''Multi Source''
             WHEN @refmultisourcecode = ''2''       AND @nametypecode = ''1'' THEN ''Single Source Brand''
             WHEN @refmultisourcecode = ''2''       AND @nametypecode = ''2'' THEN ''Single Source Generic''
             WHEN @refmultisourcecode = ''2''                               THEN ''Single Source''
             WHEN @nametypecode = ''1''                                     THEN ''Brand''
             WHEN @nametypecode = ''2''                                     THEN ''Generic''
             ELSE ''''
          END +
          CASE
             WHEN @reffederallegendcode = ''1'' THEN ''/Rx''
             WHEN @reffederallegendcode = ''2'' THEN ''/OTC''
             WHEN @reffederallegendcode = ''3'' THEN ''/Rx-OTC''
             ELSE ''''
          END +
          CASE
             WHEN @medicaldeviceind = 1         THEN ''/Supply''
             WHEN @refgenericdrugnamecode = ''0'' THEN ''/Compound''
             ELSE ''''
          END
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DispensablePA]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[DispensablePA](@medid INT,
                              @daw BIT,
                              @FormularyCoverageOrgUid UNIQUEIDENTIFIER)  RETURNS BIT
AS
BEGIN
   -- if no ePA for the dispensable drug, then no ePA
   IF NOT EXISTS(SELECT *
                 FROM FormularyCoverageNDC fcn (NOLOCK)
                 WHERE fcn.FormularyCoverageOrgUid = @FormularyCoverageOrgUid
                   AND fcn.medid = @medid
                   AND fcn.CoverageListType = ''PA'')
   BEGIN
      RETURN 0
   END

   -- if not allow checking generic alternatives, then ePA required (DAW or generic ePA disabled)
   IF (@daw = 1) RETURN 1

   -- get a list of generic alternatives
   DECLARE @Alternatives TABLE(medid INT NOT NULL PRIMARY KEY)
   INSERT INTO @Alternatives
   SELECT DISTINCT dis.medid
   FROM dbo.FDB_Dispensable dis
   INNER JOIN dbo.fdb_dispensable lnk ON lnk.medid = @medid AND lnk.gcnseqno = dis.gcnseqno
   INNER JOIN dbo.fdb_packageddrug pkg ON pkg.medid = dis.medid
   WHERE dis.medid != @medid
     AND dis.medid > 0
     AND dis.gcnseqno > 0
     AND dis.mnid != -1
     AND dis.Inactive = 0
     AND dis.obsoletedate IS NULL
     AND ISNULL(dis.statuscode, ''0'') = ''0''
     AND dis.nametypecode = 2

   -- if there are no generic alternatives, then ePA required
   IF (0 = (SELECT COUNT(*) FROM @Alternatives)) RETURN 1

   -- if one or more of the generic drugs does not require ePA, then ePA not required
   IF NOT EXISTS(SELECT *
                 FROM @Alternatives alt
              LEFT JOIN dbo.FormularyCoverageNDC fcn (NOLOCK) ON fcn.medid = alt.medid
                                                             AND fcn.FormularyCoverageOrgUid = @FormularyCoverageOrgUid
                                                                AND fcn.CoverageListType = ''PA''
              WHERE fcn.FormularyCoverageNDCUid IS NULL)
   BEGIN
      RETURN 0
   END

   -- all generics require ePA as well
   RETURN 1
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAllUsersInGroup]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- create UDF to allow Neo query to select objects visible to a user
CREATE FUNCTION [dbo].[GetAllUsersInGroup]
	(
	@UserGroupUid UniqueIdentifier
	)
RETURNS @retTable TABLE (UserUid UniqueIdentifier)
AS

BEGIN
	DECLARE @lUserGroupUid UniqueIdentifier

	DECLARE RetrieveUserGroups CURSOR STATIC LOCAL FOR
		SELECT DISTINCT MemberUserGroupUid FROM UserGroupMember WHERE UserGroupUid = @UserGroupUid AND MemberUserGroupUid IS NOT NULL

	INSERT INTO @retTable 
		SELECT DISTINCT MemberUserUid 
		FROM			UserGroupMember 
		WHERE			UserGroupUid = @UserGroupUid AND 
						MemberUserUid IS NOT NULL AND
						MemberUserUid NOT IN (SELECT UserUid FROM @retTable)

	OPEN RetrieveUserGroups

	FETCH NEXT FROM RetrieveUserGroups
	INTO @lUserGroupUid

	WHILE (@@FETCH_STATUS = 0) 
	BEGIN
		
		INSERT INTO @retTable
		select * from dbo.GetAllUsersInGroup(@lUserGroupUid)
   
		FETCH NEXT FROM RetrieveUserGroups INTO @lUserGroupUid
	END
	
	CLOSE RetrieveUserGroups
	DEALLOCATE RetrieveUserGroups

RETURN
END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsUserInGroup]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[IsUserInGroup](@UserGroupUid [uniqueidentifier], @UserUid [uniqueidentifier])
RETURNS [int] 
AS

begin
    declare @retValue int
	set @retValue=0

	select @retValue=1 from dbo.GetAllUsersInGroup(@UserGroupUid) u where u.UserUid = @UserUid
	return @retValue
end



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DoesUserUidHaveAccessToPatientChart]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[DoesUserUidHaveAccessToPatientChart] ( 
  @in_UserUid    [uniqueidentifier],
  @in_PatientUid [uniqueidentifier])
RETURNS [int]
AS
BEGIN
    DECLARE @retValue INT
	SET @retValue = 0
	
	IF NOT EXISTS (SELECT * FROM ChartAccess WHERE ChartAccess.PatientUid = @in_PatientUid)
	BEGIN
	  SET @retValue = 1
	  RETURN @retValue
	END
	
	DECLARE @cChartAccessUid uniqueidentifier
	DECLARE @cPatientUid uniqueidentifier
	DECLARE @cUserUid uniqueidentifier
	DECLARE @cUserGroupUid uniqueidentifier
	
	DECLARE curChartAccess CURSOR FOR
	  SELECT ChartAccessUid, PatientUid, UserUid, UserGroupUid
	  FROM ChartAccess
	  WHERE ChartAccess.PatientUid = @in_PatientUid
	  
	OPEN curChartAccess
	FETCH NEXT FROM curChartAccess INTO @cChartAccessUid, @cPatientUid, @cUserUid, @cUserGroupUid
	WHILE @@FETCH_STATUS = 0
	BEGIN
	  IF (@cUserUid = @in_UserUid)
	  BEGIN
	    SET @retValue = 1
	    BREAK
	  END
	  
	  IF (@cUserGroupUid is not null)
	  BEGIN
	    IF (dbo.IsUserInGroup(@cUserGroupUid, @in_UserUid) = 1)
	    BEGIN
	      SET @retValue = 1
	      BREAK	    
	    END 	  
	  END
	  
	  FETCH NEXT FROM curChartAccess INTO @cChartAccessUid, @cPatientUid, @cUserUid, @cUserGroupUid  
	END   
	
	CLOSE curChartAccess
	DEALLOCATE curChartAccess 
	
	RETURN @retValue
END 




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[DoesUserUidHaveAccessToVisit]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[DoesUserUidHaveAccessToVisit] ( 
  @userUid [uniqueidentifier],
  @visitUid [uniqueidentifier])
RETURNS [int]
AS
BEGIN
    DECLARE @retValue INT
	SET @retValue=0
	
	IF NOT EXISTS (SELECT * FROM VisitAccess WHERE VisitAccess.VisitUid = @visitUid)
    BEGIN
      SET @retValue = 1
      RETURN @retValue  
    END	
	
	DECLARE @curVisitAccessUid uniqueidentifier
	DECLARE @curVisitUid uniqueidentifier
	DECLARE @curUserUid uniqueidentifier
	DECLARE @curUserGroupUid uniqueidentifier
	
	DECLARE cursorVisitAccess CURSOR FOR
	  SELECT VisitAccessUid, VisitUid, UserUid, UserGroupUid 
	  FROM VisitAccess 
	  WHERE VisitAccess.VisitUid = @visitUid
	
	OPEN cursorVisitAccess
	FETCH NEXT FROM cursorVisitAccess INTO @curVisitAccessUid, @curVisitUid, @curUserUid, @curUserGroupUid
	WHILE @@FETCH_STATUS = 0
	BEGIN 
	  IF (@curUserUid = @userUid)
	  BEGIN
	    SET @retValue = 1
	    BREAK  
	  END
	  
	  IF (@curUserGroupUid is not null)
	  BEGIN
	    IF (dbo.IsUserInGroup(@curUserGroupUid, @userUid) = 1)
	    BEGIN
	      SET @retValue = 1
	      BREAK	    
	    END 
	  END
	  
	  FETCH NEXT FROM cursorVisitAccess INTO @curVisitAccessUid, @curVisitUid, @curUserUid, @curUserGroupUid 
	END
    	  
    CLOSE cursorVisitAccess
    DEALLOCATE cursorVisitAccess 	
	
	RETURN @retValue
END 


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SplitStrings]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[SplitStrings](@str VARCHAR(MAX), @sep CHAR(1))
RETURNS @returns TABLE(idx INT PRIMARY KEY CLUSTERED, val VARCHAR(MAX))
AS
BEGIN
   DECLARE 
      @name VARCHAR(MAX),
      @pos  INT,
      @i    INT
   SET @i = -1
   WHILE CHARINDEX(@sep, @str) > 0
      BEGIN
         SELECT @pos  = CHARINDEX(@sep, @str)
         SELECT @name = SUBSTRING(@str, 1, @pos-1)
         
         SET @i = @i + 1
         INSERT INTO @returns 
         SELECT @i, @name
         
         SELECT @str = SUBSTRING(@str, @pos+1, LEN(@str)-@pos)
      END

   INSERT INTO @returns
   SELECT @i+1, @str
   
   RETURN   
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ParseEDI]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ParseEDI](@edi VARCHAR(MAX), @ediSegment VARCHAR(100))
RETURNS @parse TABLE(
      tag                  VARCHAR(100)   NOT NULL,
      segment              INT            NOT NULL,
      element              INT            NOT NULL,
      repitition           INT            NOT NULL,
      field                INT            NOT NULL,
      val                  VARCHAR(MAX)   NULL,
                                          PRIMARY KEY CLUSTERED(tag, segment),
                                          UNIQUE NONCLUSTERED(segment, element, repitition, field))
AS
BEGIN
   DECLARE
      @UNA_010_01          CHAR(1)        = SUBSTRING(@edi, 4, 1),
      @UNA_010_02          CHAR(1)        = SUBSTRING(@edi, 5, 1),
      @UNA_010_03          CHAR(1)        = SUBSTRING(@edi, 6, 1),
      @UNA_010_04          CHAR(1)        = SUBSTRING(@edi, 7, 1),
      @UNA_010_05          CHAR(1)        = SUBSTRING(@edi, 8, 1),
      @UNA_010_06          CHAR(1)        = SUBSTRING(@edi, 9, 1)

   DECLARE
      @tag                 VARCHAR(100),
      @segment             INT,
      @element             INT,
      @repitition          INT,
      @field               INT,
      @val                 VARCHAR(MAX)

   -- divide up the top level segments
   INSERT INTO @parse
   SELECT
      tag                = SUBSTRING(val, 1, 3) + CASE
                                                     WHEN SUBSTRING(val, 1, 3) = '''' THEN ''EOF''
                                                     WHEN val LIKE ''PVD'' + @UNA_010_02 + ''P2%'' THEN ''P2''
                                                     WHEN val LIKE ''PVD'' + @UNA_010_02 + ''PC%'' THEN ''PC''
                                                     WHEN val LIKE ''PVD'' + @UNA_010_02 + ''SU%'' THEN ''SU''
                                                     WHEN val LIKE ''DRU'' + @UNA_010_02 + ''D%'' THEN ''D''
                                                     ELSE ''''
                                                  END,
      segment            = idx+1,
      element            = 0,
      repitition         = 0,
      field              = 0,
      val                = val
   FROM dbo.SplitStrings(@edi, @UNA_010_06)
   WHERE @ediSegment IS NULL OR SUBSTRING(val, 1, 3) = @ediSegment

   -- parse segments
   DECLARE segmentCursor CURSOR STATIC FOR
   SELECT tag, segment, element, repitition, field, val FROM @parse WHERE segment > 0 AND element = 0 ORDER BY segment, element, repitition, field
   OPEN segmentCursor
   FETCH NEXT FROM segmentCursor INTO @tag, @segment, @element, @repitition, @field, @val
   WHILE @@FETCH_STATUS = 0
      BEGIN
         INSERT INTO @parse
         SELECT
          tag                = @tag + ''_'' + CASE
                                               WHEN idx < 10 THEN ''0''
                                               ELSE ''''
                                            END + CONVERT(VARCHAR(2), idx) + ''0'',
          segment            = @segment,
          element            = idx+1,
          repitition         = 0,
          field              = 0,
          val                = val
         FROM dbo.SplitStrings(@val, @UNA_010_02)
         FETCH NEXT FROM segmentCursor INTO @tag, @segment, @element, @repitition, @field, @val
      END
   CLOSE segmentCursor
   DEALLOCATE segmentCursor

   -- parse elements
   DECLARE segmentElement CURSOR STATIC FOR
   SELECT tag, segment, element, repitition, field, val FROM @parse WHERE segment > 0 AND element > 0 AND repitition = 0 ORDER BY segment, element, repitition, field
   OPEN segmentElement
   FETCH NEXT FROM segmentElement INTO @tag, @segment, @element, @repitition, @field, @val
   WHILE @@FETCH_STATUS = 0
      BEGIN
         INSERT INTO @parse
         SELECT
          tag                = @tag + ''_'' + CASE
                                               WHEN idx < 10 THEN ''X0''
                                               ELSE ''X''
    END + CONVERT(VARCHAR(2), idx+1),
          segment            = @segment,
          element            = @element,
          repitition         = idx+1,
          field              = 0,
          val                = val
         FROM dbo.SplitStrings(@val, @UNA_010_05)
         FETCH NEXT FROM segmentElement INTO @tag, @segment, @element, @repitition, @field, @val
      END
   CLOSE segmentElement
   DEALLOCATE segmentElement

   -- parse repititions
   DECLARE segmentRepitition CURSOR STATIC FOR
   SELECT tag, segment, element, repitition, field, val FROM @parse WHERE segment > 0 AND element > 0 AND repitition > 0 AND field = 0 ORDER BY segment, element, repitition, field
   OPEN segmentRepitition
   FETCH NEXT FROM segmentRepitition INTO @tag, @segment, @element, @repitition, @field, @val
   WHILE @@FETCH_STATUS = 0
      BEGIN
         INSERT INTO @parse
         SELECT
          tag                = SUBSTRING(@tag, 1, LEN(@tag) -4) + ''_'' +
                                         CASE
                                            WHEN idx+1 < 10 THEN ''0'' + CONVERT(VARCHAR(2), idx+1)
                                            ELSE CONVERT(VARCHAR(2), idx+1)
                                         END +
                                         CASE
                                            WHEN @repitition > 1 THEN ''_'' + CONVERT(VARCHAR(2), @repitition)
                                            ELSE ''''
                                         END,
          segment            = @segment,
          element            = @element,
          repitition         = @repitition,
          field              = idx + 1,
          val                = val
         FROM dbo.SplitStrings(@val, @UNA_010_01)
         FETCH NEXT FROM segmentRepitition INTO @tag, @segment, @element, @repitition, @field, @val
      END
   CLOSE segmentRepitition
   DEALLOCATE segmentRepitition

   RETURN
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EscapeXml]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[EscapeXml](@xml VARCHAR(MAX)) RETURNS VARCHAR(MAX) AS
BEGIN

	SET @xml = REPLACE(@xml, ''&'', ''&amp;'')
	SET @xml = REPLACE(@xml, ''>'', ''&gt;'')
	SET @xml = REPLACE(@xml, ''<'', ''&lt;'')
	SET @xml = REPLACE(@xml, ''"'', ''&quot;'')
	SET @xml = REPLACE(@xml, '''''''', ''&apos;'')
	RETURN @xml
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EDI2Xml]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[EDI2Xml](@edi VARCHAR(MAX)) RETURNS XML
AS
BEGIN
   -- Data Not Done (not comprehensive list yet
   --     <DrugCoverageStatusCode>PR</DrugCoverageStatusCode>
   --     <DrugCoverageStatusCode>AP</DrugCoverageStatusCode>
   --     <DrugCoverageStatusCode>PA</DrugCoverageStatusCode>
   --     <DrugCoverageStatusCode>NF</DrugCoverageStatusCode>
   --     <DrugCoverageStatusCode>NR</DrugCoverageStatusCode>
   --     <PriorAuthorizationStatus>A</PriorAuthorizationStatus>

   DECLARE
      @UNA_010_01          CHAR(1)        = SUBSTRING(@edi, 4, 1),
      @UNA_010_02          CHAR(1)        = SUBSTRING(@edi, 5, 1),
      @UNA_010_03          CHAR(1)        = SUBSTRING(@edi, 6, 1),
      @UNA_010_04          CHAR(1)        = SUBSTRING(@edi, 7, 1),
      @UNA_010_05          CHAR(1)        = SUBSTRING(@edi, 8, 1),
      @UNA_010_06          CHAR(1)        = SUBSTRING(@edi, 9, 1)

   DECLARE
      @MessageXML          VARCHAR(MAX),
      @tag                 VARCHAR(20),
      @segment             INT,
      @element             INT,
      @repitition          INT,
      @field               INT,
      @val                 VARCHAR(MAX)

   DECLARE @parse TABLE(
      tag                  VARCHAR(20)    NOT NULL PRIMARY KEY CLUSTERED,
      segment              INT            NOT NULL,
      element              INT            NOT NULL,
      repitition           INT            NOT NULL,
      field                INT            NOT NULL,
      val                  VARCHAR(MAX)   NULL,
                                          UNIQUE NONCLUSTERED(segment, element, repitition, field))
   INSERT INTO @parse SELECT * FROM dbo.ParseEDI(@edi, null)

   -- strip the SPI out of PVDPC identifiers
   IF EXISTS(SELECT * FROM @parse WHERE tag LIKE ''PVDPC_020_02%'' AND val = ''SPI'')
      BEGIN
         DELETE @parse
       WHERE segment    = (SELECT segment    FROM @parse WHERE tag LIKE ''PVDPC_020_02%'' AND val = ''SPI'')
         AND element    = (SELECT element    FROM @parse WHERE tag LIKE ''PVDPC_020_02%'' AND val = ''SPI'')
         AND repitition = (SELECT repitition FROM @parse WHERE tag LIKE ''PVDPC_020_02%'' AND val = ''SPI'')
         AND field > 0
      END

   -- Provider Specialty
   IF EXISTS(SELECT * FROM @parse WHERE tag LIKE ''PVDPC_040_01'' AND val != '''')
      BEGIN
         UPDATE @parse
         SET val = ''''
         WHERE tag = ''PVDPC_040_01''
      END
   IF EXISTS(SELECT * FROM @parse WHERE tag LIKE ''PVDPC_040_02'' AND val != '''')
      BEGIN
         UPDATE @parse
         SET val = ''''
         WHERE tag = ''PVDPC_040_02''
      END
   IF EXISTS(SELECT * FROM @parse WHERE tag LIKE ''PVDSU_040_01'' AND val != '''')
      BEGIN
         UPDATE @parse
         SET val = ''''
         WHERE tag = ''PVDSU_040_01''
      END
   IF EXISTS(SELECT * FROM @parse WHERE tag LIKE ''PVDSU_040_02'' AND val != '''')
      BEGIN
         UPDATE @parse
         SET val = ''''
         WHERE tag = ''PVDSU_040_02''
      END

   -- Convert State Codes to Upper Case
   UPDATE @parse
   SET val = UPPER(val)
   WHERE tag IN(''PVDP2_080_03'', ''PVDPC_080_03'', ''PVDSU_080_03'', ''PTT_060_03'')

   -- Make sure the telephone is TE
   UPDATE @parse
   SET val = ''TE''
   WHERE tag IN(''PTT_070_02'')
     AND val != ''TE''

   -- DRU Form Code
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_03'')
      BEGIN
         -- NDC
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_03'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_02''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_04'')
      BEGIN
         -- NDC Code
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_04'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''ND''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_03''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_05'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_05'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_04''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_06'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_06'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_05''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_07'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_07'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_06''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_08'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_08'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_07''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_09'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_09'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_08''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_10'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_10'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_09''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_11'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_11'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_10''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_12'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_12'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_11''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_13'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_13'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''AA''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_12''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_14'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_14'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''C38046''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_13''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_15'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_15'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''AB''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_14''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_010_16'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_010_16'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''C38046''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_010_15''
      END

   UPDATE @parse
   SET val = ''AA''
   WHERE tag = ''DRU_010_13''
     AND val != ''AA''

   UPDATE @parse
   SET val = ''C38046''
   WHERE tag = ''DRU_010_14''
     AND val != ''C38046''

   UPDATE @parse
   SET val = ''AB''
   WHERE tag = ''DRU_010_15''
     AND val != ''AB''

   UPDATE @parse
   SET val = ''C38046''
   WHERE tag = ''DRU_010_16''
     AND val != ''C38046''

   -- Quantity Code
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_020_03'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_020_03'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''38''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_020_02''
      END

   UPDATE @parse
   SET val = ''38''
   WHERE tag = ''DRU_020_03''
     AND val != ''38''

   -- Potency Unit Code
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_020_04'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_020_04'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''AC''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_020_03''
      END
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRU_020_05'')
      BEGIN
         INSERT INTO @parse
         SELECT
            tag        = ''DRU_020_05'',
            segment    = tmp.segment,
            element    = tmp.element,
            repitition = tmp.repitition,
            field      = tmp.field + 1,
            val        = ''C38046''
         FROM @parse tmp
         WHERE tmp.tag = ''DRU_020_04''
      END
      
   UPDATE @parse
   SET val = ''AC''
   WHERE tag = ''DRU_020_04''
     AND val != ''AC''

   UPDATE @parse
   SET val = ISNULL((SELECT CASE qty.val
                               WHEN ''12'' THEN ''C48521''
                               WHEN ''AR'' THEN ''C48539''
                               WHEN ''AV'' THEN ''C48480''
                               WHEN ''BG'' THEN ''C48474''
                               WHEN ''BO'' THEN ''C48477''
                               WHEN ''BX'' THEN ''C48478''
                               WHEN ''CH'' THEN ''C48484''
                               WHEN ''CQ'' THEN ''C48481''
                               WHEN ''EA'' THEN ''C64933''
                               WHEN ''FO'' THEN ''C48494''
                               WHEN ''GR'' THEN ''C48155''
                               WHEN ''IH'' THEN ''C62275''
                               WHEN ''KT'' THEN ''C48504''
                               WHEN ''LT'' THEN ''C48505''
                               WHEN ''ME'' THEN ''C28253''
                               WHEN ''ML'' THEN ''C28254''
                               WHEN ''PT'' THEN ''C48529''
                               WHEN ''SZ'' THEN ''C48540''
                               WHEN ''TB'' THEN ''C48549''
                               WHEN ''U2'' THEN ''C48542''
                               WHEN ''UU'' THEN ''C48506''
                               WHEN ''VI'' THEN ''C48551''
                               WHEN ''Y2'' THEN ''C48541''
                               WHEN ''Y3'' THEN ''C48544''
                               WHEN ''Y7'' THEN ''C69124''
                               ELSE ''C38046''
                            END
                     FROM @parse qty
                     WHERE qty.tag = ''DRU_020_01''
                       AND qty.val != ''''), ''C38046'')
   WHERE tag = ''DRU_020_05''

   -- Quantity Qualifier
   UPDATE @parse
   SET val = ''''
   WHERE tag = ''DRU_020_01''
     AND val != ''''

   -- X fields in 10.6
   UPDATE @parse
   SET val = ''''
   WHERE tag IN(''DRU_010_05'',
                ''DRU_010_07'',
                ''DRU-020-01'',
                ''DRU-030-01'',
                ''DRUD_010_05'',
                ''DRUD_010_07'',
                ''DRUD-020-01'',
                ''DRUD-030-01'',
                ''UIB-010-03'',
                ''UIB-010-04'',
                ''UIB-020'',
                ''UIB-040'',
                ''UIB-050'',
                ''UIB-080-03'',
                ''UIB-090'',
                ''UIH-010-05'',
                ''UIH-040'',
                ''UIH-050-03'',
                ''UIH-060'',
                ''REQ-040'',
                ''REQ-050'',
                ''PVDP2-030'',
                ''PVDP2-040-02'',
                ''PVDP2-060'',
                ''PVDP2-100'',
                ''PVDPC-030'',
                ''PVDPC-040-02'',
                ''PVDPC-060'',
                ''PVDSU-030'',
                ''PVDSU-040-02'',
                ''PVDSU-060'',
                ''OBS-010-03'',
                ''COO-030'',
                ''COO-040-02'',
                ''COO-090'',
                ''COO-110'',
                ''COO-120'',
                ''COO-130'',
                ''COO-140'',
                ''UIZ-010'',
                ''UIZ-030'')

   -- Make sure there is a MedicationDispensed segment (clone MedicationPrescribed if not)
   IF NOT EXISTS(SELECT * FROM @parse WHERE tag = ''DRUD'')
      BEGIN
         UPDATE @parse
         SET segment = segment + 1
         FROM @parse
         WHERE segment > (SELECT segment FROM @parse WHERE tag = ''DRU'')

         INSERT INTO @parse
         SELECT
            tag = REPLACE(tag, ''DRU'', ''DRUD''),
            segment = segment + 1,
            element = element,
            repitition = repitition,
            field      = field,
            val        = CASE (tag)
                            WHEN ''DRU_010_01'' THEN ''D''
                            ELSE val
                         END
         FROM @parse
         WHERE tag = ''DRU'' OR tag LIKE ''DRU_%''

         UPDATE @parse
         SET val = CONVERT(VARCHAR(MAX), 1 + CONVERT(INT, val))
         WHERE tag = ''UIT_020_01''
      END

   -- Now Reconstruct the EDI
   UPDATE @parse SET val = '''' WHERE field = 0

   -- reconstruct repititions
   DECLARE segmentField CURSOR STATIC FOR
   SELECT tag, segment, element, repitition, field, val FROM @parse WHERE segment > 0 AND element > 0 AND repitition > 0 AND field > 0 ORDER BY segment, element, repitition, field
   OPEN segmentField
   FETCH NEXT FROM segmentField INTO @tag, @segment, @element, @repitition, @field, @val
   WHILE @@FETCH_STATUS = 0
      BEGIN
         UPDATE @parse
         SET val = val + CASE WHEN @field = 1 THEN '''' ELSE @UNA_010_01 END + @val
         WHERE segment = @segment
AND element = @element
           AND repitition = @repitition
           AND field = 0
         FETCH NEXT FROM segmentField INTO @tag, @segment, @element, @repitition, @field, @val
      END
   CLOSE segmentField
   DEALLOCATE segmentField

   -- reconstruct elements
   DECLARE segmentField CURSOR STATIC FOR
   SELECT tag, segment, element, repitition, field, val FROM @parse WHERE segment > 0 AND element > 0 AND repitition > 0 AND field = 0 ORDER BY segment, element, repitition, field
   OPEN segmentField
   FETCH NEXT FROM segmentField INTO @tag, @segment, @element, @repitition, @field, @val
   WHILE @@FETCH_STATUS = 0
      BEGIN
         UPDATE @parse
         SET val = val + CASE WHEN @repitition = 1 THEN '''' ELSE @UNA_010_05 END + @val
         WHERE segment = @segment
           AND element = @element
           AND repitition = 0
           AND field = 0
         FETCH NEXT FROM segmentField INTO @tag, @segment, @element, @repitition, @field, @val
      END
   CLOSE segmentField
   DEALLOCATE segmentField

   -- reconstruct segments
   DECLARE segmentField CURSOR STATIC FOR
   SELECT tag, segment, element, repitition, field, val FROM @parse WHERE segment > 0 AND element > 0 AND repitition = 0 AND field = 0 ORDER BY segment, element, repitition, field
   OPEN segmentField
   FETCH NEXT FROM segmentField INTO @tag, @segment, @element, @repitition, @field, @val
   WHILE @@FETCH_STATUS = 0
      BEGIN
         UPDATE @parse
         SET val = val + CASE WHEN @element = 1 THEN '''' ELSE @UNA_010_02 END + @val
         WHERE segment = @segment
      AND element = 0
           AND repitition = 0
           AND field = 0
         FETCH NEXT FROM segmentField INTO @tag, @segment, @element, @repitition, @field, @val
      END
   CLOSE segmentField
   DEALLOCATE segmentField

   -- reconstruct edi
   DECLARE @oldedi VARCHAR(MAX) = @edi
   SELECT @edi = ''''
   DECLARE segmentField CURSOR STATIC FOR
   SELECT tag, segment, element, repitition, field, val FROM @parse WHERE segment > 0 AND element = 0 AND repitition = 0 AND field = 0 ORDER BY segment, element, repitition, field
   OPEN segmentField
   FETCH NEXT FROM segmentField INTO @tag, @segment, @element, @repitition, @field, @val
   WHILE @@FETCH_STATUS = 0
      BEGIN
         SELECT @edi = @edi + CASE WHEN @segment = 1 THEN '''' ELSE @UNA_010_06 END + val
         FROM @parse
         WHERE segment = @segment
           AND element = 0
           AND repitition = 0
           AND field = 0
         FETCH NEXT FROM segmentField INTO @tag, @segment, @element, @repitition, @field, @val
      END
   CLOSE segmentField
   DEALLOCATE segmentField

   -- Now reconstruct the XML using the modified EDI as starting point
   DELETE @parse
   INSERT INTO @parse SELECT * FROM dbo.ParseEDI(@edi, null) ORDER BY segment, element, repitition, field

   DECLARE @binary TABLE(data VARBINARY(MAX))
   INSERT INTO @binary VALUES(CAST(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(@edi, ''&'', ''&amp;''), ''<'', ''&lt;''), ''>'', ''&gt;''), ''"'', ''&quot;''), '''''''', ''&apos;'') AS VARBINARY(MAX)))

   SET @MessageXML =
      ''<RefillRequest.eRxService xmlns="http://www.ncpdp.org/schema/SCRIPT" version="010" release="006"''
    + '' MessageID="''                   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_030_01''), '''') + ''"''
    +    '' RelatesToMessageID="''          + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_030_02''), '''') + ''"''
    +    '' RxReferenceNumber="''           + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIH_020_01''), '''') + ''"''
    +    '' SentTime="''                    + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_080_01''), 1, 4) + ''-''
                                                 + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_080_01''), 5, 2) + ''-''
                                                 + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_080_01''), 7, 2) + ''T''
                                                 + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_080_02''), 1, 2) + '':''
                                                 + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_080_02''), 3, 2) + '':''
                                                 + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_080_02''), 5, 2)
                                                 + CASE WHEN ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_080_02''), 8, 1), '''') != ''''
                                                      THEN ''.'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_080_02''), 8, 1) ELSE '''' END
                                                 + ''Z'', '''') + ''">''
    +    ''<To Qualifier="D">''             + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_070_01''), '''') + ''</To>''
    +    ''<From Qualifier="P">''           + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''UIB_060_01''), '''') + ''</From>''
    +    ''<Request>''
    +       ''<ReturnReceipt>''             + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''REQ_020''), ''0'') + ''</ReturnReceipt>''
    +       ''<RequestReferenceNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''REQ_030''), '''') + ''</RequestReferenceNumber>''
    +    ''</Request>''
    +    ''<Pharmacy>''
    +       ''<Identification>''
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_02'')
                  WHEN ''SPI'' THEN ''<SPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</SPI>''
                  WHEN ''D3''  THEN ''<NCPDPID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</NCPDPID>''
                  WHEN ''94''  THEN ''<FileID>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</FileID>''
                  WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</MedicaidNumber>''
                  WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</PayerID>''
                  WHEN ''BO''  THEN ''<BINLocationNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</BINLocationNumber>''
                  WHEN ''DH''  THEN ''<DEANumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</PriorAuthorization>''
                  WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</NPI>''
 WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_02_2'')
                  WHEN ''SPI'' THEN ''<SPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</SPI>''
                  WHEN ''D3''  THEN ''<NCPDPID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</NCPDPID>''
                  WHEN ''94''  THEN ''<FileID>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</FileID>''
                  WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</MedicaidNumber>''
                  WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</PayerID>''
                  WHEN ''BO''  THEN ''<BINLocationNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</BINLocationNumber>''
                  WHEN ''DH''  THEN ''<DEANumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</PriorAuthorization>''
                  WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</NPI>''
                  WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_2''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_02_3'')
                  WHEN ''SPI'' THEN ''<SPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</SPI>''
                  WHEN ''D3''  THEN ''<NCPDPID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</NCPDPID>''
                  WHEN ''94''  THEN ''<FileID>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</FileID>''
                  WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</MedicaidNumber>''
   WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</PayerID>''
                  WHEN ''BO''  THEN ''<BINLocationNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</BINLocationNumber>''
                  WHEN ''DH''  THEN ''<DEANumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</PriorAuthorization>''
                  WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</NPI>''
                  WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_020_01_3''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +       ''</Identification>''
    +       ''<Specialty>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_040_01''), '''') + ''</Specialty>''
    +       ''<Pharmacist>''
    +          ''<LastName>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_050_01''), '''') + ''</LastName>''
    +          ''<FirstName>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_050_02''), '''') + ''</FirstName>''
    +          ''<MiddleName>''             + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_050_03''), '''') + ''</MiddleName>''
    +          ''<Suffix>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_050_04''), '''') + ''</Suffix>''
    +          ''<Prefix>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_050_05''), '''') + ''</Prefix>''
    +       ''</Pharmacist>''
    +       ''<StoreName>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_070''), '''') + ''</StoreName>''
    +       ''<Address>''
    +          ''<AddressLine1>''           + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_080_01''), '''') + ''</AddressLine1>''
    +          ''<AddressLine2>''           + CASE WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_080_05'') = ''AD2''
                                                THEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_080_06''), '''')
                                                ELSE ''''
                                            END + ''</AddressLine2>''
    +          ''<City>''                   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_080_02''), '''') + ''</City>''
    +          ''<State>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_080_03''), '''') + ''</State>''
    +          ''<ZipCode>''                + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_080_04''), '''') + ''</ZipCode>''
    +          ''<PlaceLocationQualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_080_05''), '''') + ''</PlaceLocationQualifier>''
    +       ''</Address>''
    +       ''<CommunicationNumbers>''
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01'' ), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01''  ), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_02''  ), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_2''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_2''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_02_2''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_3''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_3''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_02_3''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_4''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_4''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_02_4''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_5''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_5''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_02_5''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_6''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_6''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_02_6''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_7''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_7''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_02_7''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_8''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_8''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_02_8''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_9''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_01_9''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDP2_090_02_9''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +       ''</CommunicationNumbers>''
    +    ''</Pharmacy>''
    +    ''<Prescriber>''
    +       ''<Identification>''
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_02'')
                  WHEN ''SPI'' THEN ''<SPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</SPI>''
                  WHEN ''D3''  THEN ''<NCPDPID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</NCPDPID>''
                  WHEN ''94''  THEN ''<FileID>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</FileID>''
     WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</MedicaidNumber>''
                  WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</PayerID>''
                  WHEN ''BO''  THEN ''<BINLocationNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</BINLocationNumber>''
                  WHEN ''DH''  THEN ''<DEANumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</PriorAuthorization>''
                WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</NPI>''
                  WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_02_2'')
                  WHEN ''SPI'' THEN ''<SPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</SPI>''
                  WHEN ''D3''  THEN ''<NCPDPID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</NCPDPID>''
                  WHEN ''94''  THEN ''<FileID>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</FileID>''
                  WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</MedicaidNumber>''
                  WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</PayerID>''
                  WHEN ''BO''  THEN ''<BINLocationNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</BINLocationNumber>''
 WHEN ''DH'' THEN ''<DEANumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</PriorAuthorization>''
                  WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</NPI>''
                  WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_2''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_02_3'')
                  WHEN ''SPI'' THEN ''<SPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</SPI>''
                  WHEN ''D3''  THEN ''<NCPDPID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</NCPDPID>''
                  WHEN ''94''  THEN ''<FileID>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</FileID>''
                  WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</MedicaidNumber>''
                  WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</PayerID>''
                  WHEN ''BO''  THEN ''<BINLocationNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</BINLocationNumber>''
                  WHEN ''DH''  THEN ''<DEANumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</PriorAuthorization>''
                  WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</NPI>''
                  WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_020_01_3''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +       ''</Identification>''
    +       ''<Specialty>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_040_01''), '''') + ''</Specialty>''
    +       ''<ClinicName>''                + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_070''), '''') + ''</ClinicName>''
    +       ''<Name>''
    +          ''<LastName>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_050_01''), '''') + ''</LastName>''
    +          ''<FirstName>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_050_02''), '''') + ''</FirstName>''
    +          ''<MiddleName>''             + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_050_03''), '''') + ''</MiddleName>''
    +          ''<Suffix>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_050_04''), '''') + ''</Suffix>''
    +          ''<Prefix>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_050_05''), '''') + ''</Prefix>''
    +       ''</Name>''
    +       ''<Address>''
    +          ''<AddressLine1>''           + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_080_01''), '''') + ''</AddressLine1>''
    +          ''<AddressLine2>''           + CASE WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_080_05'') = ''AD2'' THEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_080_06''), '''') ELSE '''' END + ''</AddressLine2>''
    +          ''<City>''                   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_080_02''), '''') + ''</City>''
    +          ''<State>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_080_03''), '''') + ''</State>''
    +          ''<ZipCode>''                + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_080_04''), '''') + ''</ZipCode>''
    +          ''<PlaceLocationQualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_080_05''), '''') + ''</PlaceLocationQualifier>''
    +       ''</Address>''
    +   ''<CommunicationNumbers>''
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01''  ), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01''  ), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_02''  ), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_2''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_2''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_02_2''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_3''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_3''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_02_3''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_4''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_4''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_02_4''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_5''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_5''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_02_5''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_6''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_6''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_02_6''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +  CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_7''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_7''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_02_7''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_8''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_8''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_02_8''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_9''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_01_9''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_090_02_9''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +       ''</CommunicationNumbers>''
    +       CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_100_01''), '''') != ''''
               THEN ''<PrescriberAgent>''
                  +    ''<LastName>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_100_01''), '''') + ''</LastName>''
                  +    ''<FirstName>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_100_02''), '''') + ''</FirstName>''
                  + ''<MiddleName>''     + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_100_03''), '''') + ''</MiddleName>''
                  +    ''<Suffix>''         + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_100_04''), '''') + ''</Suffix>''
                  +    ''<Prefix>''         + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDPC_100_05''), '''') + ''</Prefix>''
                  + ''</PrescriberAgent>''
               ELSE ''''
            END
    +    ''</Prescriber>''
    + CASE WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU'') IS NOT NULL THEN
         ''<Supervisor>''
    +       ''<Identification>''
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_02'')
                  WHEN ''SPI'' THEN ''<SPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</SPI>''
                  WHEN ''D3''  THEN ''<NCPDPID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</NCPDPID>''
                  WHEN ''94''  THEN ''<FileID>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</FileID>''
                  WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</MedicaidNumber>''
                  WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</PayerID>''
                  WHEN ''BO''  THEN ''<BINLocationNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</BINLocationNumber>''
                  WHEN ''DH''  THEN ''<DEANumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</PriorAuthorization>''
                  WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</NPI>''
                  WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_02_2'')
                  WHEN ''SPI'' THEN ''<SPI>''     + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</SPI>''
                  WHEN ''D3''  THEN ''<NCPDPID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</NCPDPID>''
                  WHEN ''94''  THEN ''<FileID>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</FileID>''
                  WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</MedicaidNumber>''
                  WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</PayerID>''
                  WHEN ''BO''  THEN ''<BINLocationNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</BINLocationNumber>''
                  WHEN ''DH''  THEN ''<DEANumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</PriorAuthorization>''
                  WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</NPI>''
                  WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_2''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_02_3'')
                  WHEN ''SPI'' THEN ''<SPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</SPI>''
                  WHEN ''D3''  THEN ''<NCPDPID>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</NCPDPID>''
      WHEN ''94''  THEN ''<FileID>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</FileID>''
                  WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</MedicaidNumber>''
                  WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</PayerID>''
                  WHEN ''BO''  THEN ''<BINLocationNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</BINLocationNumber>''
                  WHEN ''DH''  THEN ''<DEANumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</PriorAuthorization>''
                  WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</NPI>''
                  WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_020_01_3''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +       ''</Identification>''
    +       ''<Specialty>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_040_01''), '''') + ''</Specialty>''
    +       ''<ClinicName>''                + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_070''), '''') + ''</ClinicName>''
    +       ''<Name>''
    +          ''<LastName>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_050_01''), '''') + ''</LastName>''
    +          ''<FirstName>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_050_02''), '''') + ''</FirstName>''
    +          ''<MiddleName>''             + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_050_03''), '''') + ''</MiddleName>''
    +          ''<Suffix>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_050_04''), '''') + ''</Suffix>''
    +          ''<Prefix>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_050_05''), '''') + ''</Prefix>''
    +       ''</Name>''
    +       ''<Address>''
    +          ''<AddressLine1>''           + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_080_01''), '''') + ''</AddressLine1>''
    +          ''<AddressLine2>''           + CASE WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_080_05'') = ''AD2'' THEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_080_06''), '''') ELSE '''' END + ''</AddressLine2>''
    +          ''<City>''                   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_080_02''), '''') + ''</City>''
  +    ''<State>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_080_03''), '''') + ''</State>''
    +          ''<ZipCode>''                + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_080_04''), '''') + ''</ZipCode>''
    +          ''<PlaceLocationQualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_080_05''), '''') + ''</PlaceLocationQualifier>''
    +       ''</Address>''
    +       ''<CommunicationNumbers>''
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01''  ), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01''  ), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_02''  ), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_2''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_2''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_02_2''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_3''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_3''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_02_3''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_4''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_4''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_02_4''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_5''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_5''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_02_5''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_6''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_6''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_02_6''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_7''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_7''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_02_7''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_8''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_8''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_02_8''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_9''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_01_9''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_090_02_9''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +       ''</CommunicationNumbers>''
    +     CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_100_01''), '''') != ''''
         THEN ''<PrescriberAgent>''
            +    ''<LastName>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_100_01''), '''') + ''</LastName>''
                  +    ''<FirstName>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_100_02''), '''') + ''</FirstName>''
                  +    ''<MiddleName>''     + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_100_03''), '''') + ''</MiddleName>''
                  +    ''<Suffix>''         + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_100_04''), '''') + ''</Suffix>''
                  +    ''<Prefix>''         + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PVDSU_100_05''), '''') + ''</Prefix>''
                  + ''</PrescriberAgent>''
               ELSE ''''
            END
    +    ''</Supervisor>''
         ELSE '''' END
    +    ''<Patient>''
    +       ''<PatientRelationship>1</PatientRelationship>''
    +       ''<Identification>''
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_02'')
                  WHEN ''SPI'' THEN ''<SPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</SPI>''
                  WHEN ''D3''  THEN ''<NCPDPID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</NCPDPID>''
                  WHEN ''94''  THEN ''<FileID>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</FileID>''
                WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</MedicaidNumber>''
                  WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</PayerID>''
                  WHEN ''BO''  THEN ''<BINLocationNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</BINLocationNumber>''
                  WHEN ''DH''  THEN ''<DEANumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</PriorAuthorization>''
                  WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</NPI>''
                  WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_02_2'')
                  WHEN ''SPI'' THEN ''<SPI>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</SPI>''
WHEN ''D3''  THEN ''<NCPDPID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</NCPDPID>''
  WHEN ''94''  THEN ''<FileID>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</FileID>''
                  WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</MedicaidNumber>''
                  WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</PayerID>''
                  WHEN ''BO''  THEN ''<BINLocationNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</BINLocationNumber>''
                  WHEN ''DH''  THEN ''<DEANumber>''         + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</PriorAuthorization>''
                  WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</NPI>''
                  WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_2''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +          CASE (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_02_3'')
                  WHEN ''SPI'' THEN ''<SPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</SPI>''
                  WHEN ''D3''  THEN ''<NCPDPID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</NCPDPID>''
                  WHEN ''94''  THEN ''<FileID>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</FileID>''
                  WHEN ''0B''  THEN ''<StateLicenseNumber>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</StateLicenseNumber>''
                  WHEN ''1C''  THEN ''<MedicareNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</MedicareNumber>''
                  WHEN ''1D''  THEN ''<MedicaidNumber>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</MedicaidNumber>''
                  WHEN ''1E''  THEN ''<DentistLicenseNumber>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</DentistLicenseNumber>''
                  WHEN ''1G''  THEN ''<UPIN>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</UPIN>''
                  WHEN ''1M''  THEN ''<PPONumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</PPONumber>''
                  WHEN ''2U''  THEN ''<PayerID>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</PayerID>''
          WHEN ''BO''  THEN ''<BINLocationNumber>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</BINLocationNumber>''
                  WHEN ''DH''  THEN ''<DEANumber>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</DEANumber>''
                  WHEN ''G1''  THEN ''<PriorAuthorization>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</PriorAuthorization>''
                  WHEN ''SY''  THEN ''<SocialSecurity>''       + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</SocialSecurity>''
                  WHEN ''HPI'' THEN ''<NPI>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</NPI>''
                  WHEN ''ZZ''  THEN ''<MutuallyDefined>''      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_050_01_3''), '''') + ''</MutuallyDefined>''
                  ELSE ''''
               END
    +       ''</Identification>''
    +       ''<Name>''
    +          ''<LastName>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_030_01''), '''') + ''</LastName>''
    +          ''<FirstName>''              + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_030_02''), '''') + ''</FirstName>''
    +          ''<MiddleName>''             + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_030_03''), '''') + ''</MiddleName>''
    +          ''<Suffix>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_030_04''), '''') + ''</Suffix>''
    +          ''<Prefix>''                 + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_030_05''), '''') + ''</Prefix>''
    +       ''</Name>''
    +       ''<Gender>''                    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_040''), '''') + ''</Gender>''
    +       ''<DateOfBirth><Date>''         + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_020''), 1, 4) + ''-''
                                                     + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_020''), 5, 2) + ''-''
                                                     + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_020''), 7, 2) + ''</Date></DateOfBirth>''
    +       ''<Address>''
    +          ''<AddressLine1>''           + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_060_01''), '''') + ''</AddressLine1>''
    +          ''<AddressLine2>''           + CASE WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_060_05'') = ''AD2'' THEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_060_06''), '''') ELSE '''' END + ''</AddressLine2>''
    +          ''<City>''                   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_060_02''), '''') + ''</City>''
    +          ''<State>''                  + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_060_03''), '''') + ''</State>''
    +          ''<ZipCode>''                + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_060_04''), '''') + ''</ZipCode>''
    +          ''<PlaceLocationQualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_060_05''), '''') + ''</PlaceLocationQualifier>''
    +       ''</Address>''
    +       ''<CommunicationNumbers>''
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01''  ), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01''  ), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_02''  ), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_2''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_2''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_02_2''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_3''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_3''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_02_3''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_4''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_4''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_02_4''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_5''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_5''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_02_5''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_6''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_6''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_02_6''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_7''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_7''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_02_7''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_8''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_8''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_02_8''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +          CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_9''), '''') != '''' THEN ''<Communication><Number>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_01_9''), '''') + ''</Number><Qualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''PTT_070_02_9''), '''') + ''</Qualifier></Communication>'' ELSE '''' END
    +       ''</CommunicationNumbers>''
    +    ''</Patient>''
    +    ''<MedicationPrescribed>''
    +       CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_10''), '''') + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_11''), '''') + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_12''), '''') != ''''
               THEN ''<DrugDescription>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_10''), '''') + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_11''), '''') + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_12''), '''') + ''</DrugDescription>''
               ELSE ''<DrugDescription>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_02''), '''') + ''</DrugDescription>''
            END
    +       ''<DrugCoded>''
    +          ''<ProductCode>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_03''), '''') + ''</ProductCode>''
    +          ''<ProductCodeQualifier>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_04''), '''') + ''</ProductCodeQualifier>''
    +          ''<Strength>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_06''), '''') + ''</Strength>''
    +       ''<DrugDBCode>''             + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_08''), '''') + ''</DrugDBCode>''
    +          ''<DrugDBCodeQualifier>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_09''), '''') + ''</DrugDBCodeQualifier>''
    +          ''<FormSourceCode/>''
    +          ''<FormCode>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_05''), '''') + ''</FormCode>''
    +          ''<StrengthSourceCode/>''
    +          ''<StrengthCode>''           + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_010_07''), '''') + ''</StrengthCode>''
    +       ''</DrugCoded>''
    +       ''<Quantity>''
    +          ''<Value>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_020_02''), '''') + ''</Value>''
    +          ''<CodeListQualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_020_03''), '''') + ''</CodeListQualifier>''
    +          ''<UnitSourceCode>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_020_04''), '''') + ''</UnitSourceCode>''
    +          ''<PotencyUnitCode>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_020_05''), '''') + ''</PotencyUnitCode>''            -- CMR??? we need to look this one up
    +       ''</Quantity>''
    +       CASE
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_01''  ) = ''ZDS'' THEN ''<DaysSupply>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02''  ), '''') + ''</DaysSupply>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_01_2'') = ''ZDS'' THEN ''<DaysSupply>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_2''), '''') + ''</DaysSupply>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_01_3'') = ''ZDS'' THEN ''<DaysSupply>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_3''), '''') + ''</DaysSupply>''
               ELSE ''''
            END
    +       ''<Directions>''                + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_030_02''), '''') + ''</Directions>''
    +       ''<Note>''                      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_090_01''), '''')
                                          + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_090_01_2''), '''')
                                          + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_090_01_3''), '''')
    +       ''</Note>''
    +       ''<Refills>''
    +         ''<Qualifier>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_060_01''), '''') + ''</Qualifier>''
    +         ''<Value>''                   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_060_02''), '''') + ''</Value>''
    +       ''</Refills>''
    +       ''<Substitutions>''             + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_050''), '''') + ''</Substitutions>''
    +       CASE
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_01''  ) = ''85'' THEN ''<WrittenDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02''  ), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02''  ), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02''  ), 1, 4), '''') + ''</WrittenDate>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_01_2'') = ''85'' THEN ''<WrittenDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_2''), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_2''), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_2''), 1, 4), '''') + ''</WrittenDate>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_01_3'') = ''85'' THEN ''<WrittenDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_3''), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_3''), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_3''), 1, 4), '''') + ''</WrittenDate>''
               ELSE ''''
            END
    +       CASE
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_01''  ) = ''LD'' THEN ''<LastFillDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02''  ), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02''  ), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02''  ), 1, 4), '''') + ''</LastFillDate>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_01_2'') = ''LD'' THEN ''<LastFillDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_2''), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_2''), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_2''), 1, 4), '''') + ''</LastFillDate>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_01_3'') = ''LD'' THEN ''<LastFillDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_3''), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_3''), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRU_040_02_3''), 1, 4), '''') + ''</LastFillDate>''
               ELSE ''''
            END
    +    ''</MedicationPrescribed>''
    +    ''<MedicationDispensed>'' +
    +     CASE WHEN ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_10''), '''') + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_11''), '''') + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_12''), '''') != ''''
               THEN ''<DrugDescription>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_10''), '''') + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_11''), '''') + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_12''), '''') + ''</DrugDescription>''
               ELSE ''<DrugDescription>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_02''), '''') + ''</DrugDescription>''
            END
    +       ''<DrugCoded>''
    +          ''<ProductCode>''            + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_03''), '''') + ''</ProductCode>''
    +          ''<ProductCodeQualifier>''   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_04''), '''') + ''</ProductCodeQualifier>''
    +          ''<Strength>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_06''), '''') + ''</Strength>''
    +          ''<DrugDBCode>''             + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_08''), '''') + ''</DrugDBCode>''
    +          ''<DrugDBCodeQualifier>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_09''), '''') + ''</DrugDBCodeQualifier>''
    +          ''<FormSourceCode/>''
    +          ''<FormCode>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_05''), '''') + ''</FormCode>''
    +          ''<StrengthSourceCode/>''
    +          ''<StrengthCode>''           + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_010_07''), '''') + ''</StrengthCode>''
    +       ''</DrugCoded>''
    +       ''<Quantity>''
    +          ''<Value>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_020_02''), '''') + ''</Value>''
    +          ''<CodeListQualifier>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_020_03''), '''') + ''</CodeListQualifier>''
    +          ''<UnitSourceCode>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_020_04''), '''') + ''</UnitSourceCode>''
    +          ''<PotencyUnitCode>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_020_05''), '''') + ''</PotencyUnitCode>''            -- CMR??? we need to look this one up
    +       ''</Quantity>''
    +       CASE
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_01''  ) = ''ZDS'' THEN ''<DaysSupply>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02''  ), '''') + ''</DaysSupply>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_01_2'') = ''ZDS'' THEN ''<DaysSupply>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_2''), '''') + ''</DaysSupply>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_01_3'') = ''ZDS'' THEN ''<DaysSupply>'' + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_3''), '''') + ''</DaysSupply>''
               ELSE ''''
            END
    +       ''<Directions>''                + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_030_02''), '''') + ''</Directions>''
    +       ''<Note>''                      + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_090_01''), '''')
                                          + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_090_01_2''), '''')
                                          + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_090_01_3''), '''')
    +       ''</Note>''
    +       ''<Refills>''
    +         ''<Qualifier>''               + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_060_01''), '''') + ''</Qualifier>''
    +         ''<Value>''                   + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_060_02''), '''') + ''</Value>''
    +       ''</Refills>''
    +       ''<Substitutions>''    + ISNULL((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_050''), '''') + ''</Substitutions>''
    +       CASE
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_01''  ) = ''85'' THEN ''<WrittenDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02''  ), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02''  ), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02''  ), 1, 4), '''') + ''</WrittenDate>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_01_2'') = ''85'' THEN ''<WrittenDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_2''), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_2''), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_2''), 1, 4), '''') + ''</WrittenDate>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_01_3'') = ''85'' THEN ''<WrittenDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_3''), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_3''), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_3''), 1, 4), '''') + ''</WrittenDate>''
               ELSE ''''
            END
    +       CASE
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_01''  ) = ''LD'' THEN ''<LastFillDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02''  ), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02''  ), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02''  ), 1, 4), '''') + ''</LastFillDate>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_01_2'') = ''LD'' THEN ''<LastFillDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_2''), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_2''), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_2''), 1, 4), '''') + ''</LastFillDate>''
               WHEN (select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_01_3'') = ''LD'' THEN ''<LastFillDate>'' + ISNULL(SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_3''), 5, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_3''), 7, 2) + ''/'' + SUBSTRING((select dbo.EscapeXML(val) FROM @parse WHERE tag = ''DRUD_040_02_3''), 1, 4), '''') + ''</LastFillDate>''
               ELSE ''''
            END
    +    ''</MedicationDispensed>'' +
    +    ''<EDIFACTMessage>'' + (SELECT CAST('''' AS XML).value(''xs:base64Binary(xs:hexBinary(sql:column("data")))'' , ''VARCHAR(MAX)'') FROM @binary) + ''</EDIFACTMessage>''
    + ''</RefillRequest.eRxService>''

   RETURN CONVERT(XML, @MessageXML)
--SELECT CONVERT(XML, @MessageXML)
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EncryptPHI]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE function [dbo].[EncryptPHI]
	()
	returns bit as
begin

	declare @ret bit
	IF EXISTS ( SELECT 1 FROM ListProductParameter where ParameterName = ''EncryptPHI'' and BoolValue = 1 )
		SET @ret = 1
	ELSE
		SET @ret = 0

	return @ret

end




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ERAGetClaimAdjustments]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ERAGetClaimAdjustments](@ERAClaimPaymentInfoUid UNIQUEIDENTIFIER)
RETURNS VARCHAR(50)
AS
BEGIN
	DECLARE @list VARCHAR(50)

	select @list = ISNULL((@list + ''; ''), '''') + 
	                cadj.GroupCode + ''-'' + cadj.ReasonCode + 
	                case when cadj.Amount < 0 then '' ($'' + convert(varchar,-(cadj.Amount),1) + '')'' 
	                     else '' $'' + convert(varchar,cadj.Amount,1) + '''' end 
	from ERAClaimAdjustment cadj
	Where cadj.ERAClaimPaymentInfoUid = @ERAClaimPaymentInfoUid
	ORDER BY cadj.GroupCode, cadj.ReasonCode, cadj.Amount

	return ISNULL(@list, '''')
END


        

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ERAGetCoinsuranceAmount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ERAGetCoinsuranceAmount](@ERAServicePaymentInfoUid UNIQUEIDENTIFIER)
RETURNS MONEY
AS
BEGIN
	DECLARE @ReturnValue MONEY

	SELECT  @ReturnValue = SUM(Amount) FROM ERAServiceAdjustment 
	WHERE ERAServicePaymentInfoUid = @ERAServicePaymentInfoUid AND GroupCode = ''PR'' AND ReasonCode = ''2'' and Amount is not null
	IF (@ReturnValue is null) SET @ReturnValue = 0
	RETURN @ReturnValue
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ERAGetDeductibleAmount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ERAGetDeductibleAmount](@ERAServicePaymentInfoUid UNIQUEIDENTIFIER)
RETURNS MONEY
AS
BEGIN
	DECLARE @ReturnValue MONEY

	SELECT  @ReturnValue = SUM(Amount) FROM ERAServiceAdjustment 
	WHERE ERAServicePaymentInfoUid = @ERAServicePaymentInfoUid AND GroupCode = ''PR'' AND ReasonCode = ''1'' and Amount is not null
	IF (@ReturnValue is null) SET @ReturnValue = 0
	RETURN @ReturnValue
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ERAGetGroupReasonCode]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ERAGetGroupReasonCode](@ERAServicePaymentInfoUid UNIQUEIDENTIFIER)
RETURNS VARCHAR(50)
AS
BEGIN
	DECLARE @list VARCHAR(50)
	SELECT @list = ISNULL((@list + '', ''), '''') + sa.GroupCode + ''-'' + sa.ReasonCode
	FROM ERAServiceAdjustment sa
	WHERE sa.ERAServicePaymentInfoUid = @ERAServicePaymentInfoUid AND
		  sa.ReasonCode NOT IN (''1'', ''2'') AND 
          sa.GroupCode is not NULL AND 
          sa.ReasonCode is not NULL
	ORDER BY sa.LastModifiedDate

	return ISNULL(@list, '''')
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ERAGetLateFilingCharge]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ERAGetLateFilingCharge](@ERAClaimPaymentInfoUid UNIQUEIDENTIFIER)
RETURNS MONEY
AS
BEGIN
	DECLARE @ReturnValue MONEY
	
	SELECT @ReturnValue = SUM(sa.Amount)
	FROM ERAServicePaymentInfo spi 
			INNER JOIN ERAServiceAmount sa on spi.ERAClaimPaymentInfoUid = @ERAClaimPaymentInfoUid
												AND spi.ERAServicePaymentInfoUid = sa.ERAServicePaymentInfoUid
												AND sa.QualifierCode = ''KH'' -- Deduction Amount Late Filing Reduction
	GROUP BY spi.ERAClaimPaymentInfouID
	IF (@ReturnValue is null) SET @ReturnValue = 0
	RETURN @ReturnValue
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ERAGetLQRemarks]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ERAGetLQRemarks](@ERAServicePaymentInfoUid UNIQUEIDENTIFIER)
RETURNS VARCHAR(50)
AS
BEGIN
	DECLARE @list VARCHAR(50)

	select @list = ISNULL((@list + '', ''), '''') + hrc.IndustryCode
	from ERAHealthCareRemarkCode hrc
	Where hrc.ERAServicePaymentInfoUid = @ERAServicePaymentInfoUid
	ORDER BY hrc.IndustryCode

	return ISNULL(@list, '''')
END


        
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ERAGetReasonCodeAmount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ERAGetReasonCodeAmount](@ERAServicePaymentInfoUid UNIQUEIDENTIFIER)
RETURNS MONEY
AS
BEGIN
	DECLARE @ReturnValue MONEY

	SELECT  @ReturnValue = SUM(Amount) FROM ERAServiceAdjustment 
	WHERE ERAServicePaymentInfoUid = @ERAServicePaymentInfoUid 
		  AND ReasonCode NOT IN (''1'',''2'') and Amount is not null
	IF (@ReturnValue is null) SET @ReturnValue = 0
	RETURN @ReturnValue
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ERAGetTransactionError]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[ERAGetTransactionError](@ERATransactionSetUid UNIQUEIDENTIFIER)
RETURNS VARCHAR(1024)
AS
BEGIN
	DECLARE @retVal VARCHAR(1024)
	SET @retVal = NULL
	
	SELECT top 1 @retVal = tse.ErrorText 
    FROM ERATransactionSetError tse with (nolock)
    where tse.ERATransactionSetUid = @ERATransactionSetUid
    ORDER BY tse.LastModifiedDate asc
    
    IF ( @retVal IS NULL )
    BEGIN
	 SELECT top 1 @retVal = cpie.ErrorText 
	 FROM ERAHeader h with (nolock) 
		JOIN ERAClaimPaymentInfo cpi with (nolock) ON h.ERATransactionSetUid = @ERATransactionSetUid
										AND h.ERAHeaderUid = cpi.ERAHeaderUid
		JOIN ERAClaimPaymentInfoError cpie with (nolock) ON cpie.ERAClaimPaymentInfoUid = cpi.ERAClaimPaymentInfoUid
	 ORDER BY cpie.LastModifiedDate asc	  
    END
    
    IF ( @retVal IS NULL )
    BEGIN  
	 SELECT top 1 @retVal = spie.ErrorText 
	 FROM ERAHeader h with (nolock) 
			JOIN ERAClaimPaymentInfo cpi with (nolock) ON h.ERATransactionSetUid = @ERATransactionSetUid
												AND h.ERAHeaderUid = cpi.ERAHeaderUid
			JOIN ERAServicePaymentInfo spi with (nolock) ON spi.ERAClaimPaymentInfoUid = cpi.ERAClaimPaymentInfoUid
			JOIN ERAServicePaymentInfoError spie with (nolock) ON spie.ERAServicePaymentInfoUid = spi.ERAServicePaymentInfoUid
     ORDER BY spie.LastModifiedDate asc
    END
	
	return ISNULL(@retVal, '''')
END


        


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[eRxCoverageFromXML]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[eRxCoverageFromXML]
(
	@coverageXML XML
)
RETURNS @eRxCoverage TABLE
(
	Payor VARCHAR (100),
	PayorID VARCHAR (100),
	LastName VARCHAR (50),
	FirstName VARCHAR (50),
	MiddleName VARCHAR (50),
	Prefix VARCHAR (25),
	Suffix VARCHAR (50),
	DOB DATETIME,
	Gender VARCHAR (1),
	Address1 VARCHAR (100),
	Address2 VARCHAR (100),
	City VARCHAR (25),
	State VARCHAR (3),
	Zip VARCHAR (10),
	RelationshipCode VARCHAR (2),
	Relationship VARCHAR (100),
	StudentStatus VARCHAR (100),
	SubcriberID VARCHAR (100),
	HealthPlanName VARCHAR (100),
	HealthPlanID VARCHAR (100),
	CardholderName VARCHAR (100),
	CardholderID VARCHAR (100),
	PersonCode VARCHAR (25),
	GroupName VARCHAR (100),
	GroupID VARCHAR (100),
	BIN VARCHAR (100),
	PCN VARCHAR (100),
	FormularyID VARCHAR (100),
	AlternativesID VARCHAR (100),
	CoverageID VARCHAR (100),
	CopayID VARCHAR (100),
	ServiceDate DATETIME,
	EligibilityDate DATETIME,
	PharmacyEligible BIT,
	MailOrderEligible BIT
)
AS
BEGIN
	DECLARE @subcriberXML XML,
		@dependentXML XML,
		@coverageInfoXML XML
	
	SELECT 
		@subcriberXML = x.n.query(''subcriber''),
		@dependentXML = x.n.query(''dependent'')
	FROM @coverageXML.nodes(''//coverage'') AS x(n)
	
	SET	@coverageInfoXML =	CASE WHEN @dependentXML IS NOT NULL AND LEN (CAST (@dependentXML AS VARCHAR (MAX))) > 0 THEN @dependentXML
								 ELSE @subcriberXML
							END;
	
	WITH cteeRxCoverage AS
	(
		SELECT 
	-- Payor information
			(SELECT x.n.value(''@organizationName'',''varchar(100)'')
			 FROM @coverageXML.nodes(''//payor'') AS x(n)) AS Payor,
			(SELECT x.n.value(''@ParticipantID'',''varchar(100)'')
			 FROM @coverageXML.nodes(''//payor'') AS x(n)) AS PayorID,

	-- subcriber information
			(SELECT x.n.value(''@lastName'',''varchar(50)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberLastName,
			(SELECT x.n.value(''@firstName'',''varchar(50)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberFirstName,
			(SELECT x.n.value(''@middleName'',''varchar(50)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberMiddleName,
			(SELECT x.n.value(''@prefix'',''varchar(25)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberPrefix,
			(SELECT x.n.value(''@suffix'',''varchar(50)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberSuffix,
			(SELECT x.n.value(''@DOB'',''datetime'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberDOB,
			(SELECT x.n.value(''@gender'',''varchar(1)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberGender,
			(SELECT x.n.value(''@address1'',''varchar(100)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberAddress1,
			(SELECT x.n.value(''@address2'',''varchar(100)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberAddress2,
			(SELECT x.n.value(''@city'',''varchar(25)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberCity,
			(SELECT x.n.value(''@state'',''varchar(3)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberState,
			(SELECT x.n.value(''@zip'',''varchar(10)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberZip,
			(SELECT x.n.value(''@relationshipCode'',''varchar(2)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberRelationshipCode,
			(SELECT x.n.value(''@relationship'',''varchar(100)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberRelationship,
			(SELECT x.n.value(''@studentStatus'',''varchar(100)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS subcriberStudentStatus,
			 
	-- dependent information
			(SELECT x.n.value(''@lastName'',''varchar(50)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentLastName,
			(SELECT x.n.value(''@firstName'',''varchar(50)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentFirstName,
			(SELECT x.n.value(''@middleName'',''varchar(50)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentMiddleName,
			(SELECT x.n.value(''@prefix'',''varchar(25)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentPrefix,
			(SELECT x.n.value(''@suffix'',''varchar(50)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentSuffix,
			(SELECT x.n.value(''@DOB'',''datetime'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentDOB,
			(SELECT x.n.value(''@gender'',''varchar(1)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentGender,
			(SELECT x.n.value(''@address1'',''varchar(100)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentAddress1,
			(SELECT x.n.value(''@address2'',''varchar(100)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentAddress2,
			(SELECT x.n.value(''@city'',''varchar(25)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentCity,
			(SELECT x.n.value(''@state'',''varchar(3)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentState,
			(SELECT x.n.value(''@zip'',''varchar(10)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentZip,
			(SELECT x.n.value(''@relationshipCode'',''varchar(2)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentRelationshipCode,
			(SELECT x.n.value(''@relationship'',''varchar(100)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentRelationship,
			(SELECT x.n.value(''@studentStatus'',''varchar(100)'')
			 FROM @coverageXML.nodes(''//dependent'') AS x(n)) AS dependentStudentStatus,
			 
	-- Coverage information
			(SELECT x.n.value(''@SubcriberID'',''varchar(100)'')
			 FROM @coverageXML.nodes(''//subcriber'') AS x(n)) AS SubcriberID,
			 
			(SELECT x.n.value(''@HealthPlanName'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''18'''']'') AS x(n)) AS HealthPlanName,
			(SELECT x.n.value(''@HealthPlanID'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''18'''']'') AS x(n)) AS HealthPlanID,
			(SELECT x.n.value(''@CardholderName'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''1W'''']'') AS x(n)) AS CardholderName,
			(SELECT x.n.value(''@CardholderID'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''1W'''']'') AS x(n)) AS CardholderID,
			(SELECT x.n.value(''@PersonCode'',''varchar(25)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''49'''']'') AS x(n)) AS PersonCode,
			(SELECT x.n.value(''@GroupName'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''6P'''']'') AS x(n)) AS GroupName,
			(SELECT x.n.value(''@GroupID'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''6P'''']'') AS x(n)) AS GroupID,
			(SELECT x.n.value(''@BIN'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''N6'''']'') AS x(n)) AS BIN,
			(SELECT x.n.value(''@PCN'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''N6'''']'') AS x(n)) AS PCN,
			(SELECT x.n.value(''@FormularyID'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''IF'''']'') AS x(n)) AS FormularyID,
			(SELECT x.n.value(''@AlternativesID'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''IF'''']'') AS x(n)) AS AlternativesID,
			(SELECT x.n.value(''@CoverageID'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''1L'''']'') AS x(n)) AS CoverageID,
			(SELECT x.n.value(''@CopayID'',''varchar(100)'')
			 FROM @coverageInfoXML.nodes(''//identifications/identification[@referenceType = ''''IG'''']'') AS x(n)) AS CopayID,
			(SELECT x.n.value(''@ServiceDate'',''datetime'')
			 FROM @coverageInfoXML.nodes(''//subcriberDates/subcriberDate[@dtpQualifier = ''''472'''']'') AS x(n)) AS ServiceDate,
			(SELECT x.n.value(''@EligibilityDate'',''datetime'')
			 FROM @coverageInfoXML.nodes(''//subcriberDates/subcriberDate[@dtpQualifier = ''''307'''']'') AS x(n)) AS EligibilityDate,
			(SELECT x.n.value(''@coverageTypeCode'',''varchar(10)'')
			 FROM @coverageInfoXML.nodes(''//eligibility[@serviceTypeCode = ''''88'''']'') AS x(n)) AS PharmacyEligible,
			(SELECT x.n.value(''@coverageTypeCode'',''varchar(10)'')
			 FROM @coverageInfoXML.nodes(''//eligibility[@serviceTypeCode = ''''90'''']'') AS x(n)) AS MailOrderEligible
	)
	INSERT @eRxCoverage
	SELECT
		CASE WHEN Payor = '''' THEN NULL ELSE Payor END AS Payor,
		CASE WHEN PayorID = '''' THEN NULL ELSE PayorID END AS PayorID,
		COALESCE (dependentLastName, subcriberLastName) AS LastName,
		COALESCE (dependentFirstName, subcriberFirstName) AS FirstName,
		CASE WHEN COALESCE (dependentMiddleName, subcriberMiddleName) = '''' THEN NULL
			ELSE COALESCE (dependentMiddleName, subcriberMiddleName) END AS MiddleName,
		CASE WHEN COALESCE (dependentPrefix, subcriberPrefix) = '''' THEN NULL
			ELSE COALESCE (dependentPrefix, subcriberPrefix) END AS Prefix,
		CASE WHEN COALESCE (dependentSuffix, subcriberSuffix) = '''' THEN NULL
			ELSE COALESCE (dependentSuffix, subcriberSuffix) END AS Suffix,
		COALESCE (dependentDOB, subcriberDOB) AS DOB,
		COALESCE (dependentGender, subcriberGender) AS Gender,
		COALESCE (dependentAddress1, subcriberAddress1) AS Address1,
		CASE WHEN COALESCE (dependentAddress2, subcriberAddress2) = '''' THEN NULL
			ELSE COALESCE (dependentAddress2, subcriberAddress2) END AS Address2,
		COALESCE (dependentCity, subcriberCity) AS City,
		COALESCE (dependentState, subcriberState) AS State,
		COALESCE (dependentZip, subcriberZip) AS Zip,
		COALESCE (dependentRelationshipCode, subcriberRelationshipCode) AS RelationshipCode,
		COALESCE (dependentRelationship, subcriberRelationship) AS Relationship,
		COALESCE (dependentStudentStatus, subcriberStudentStatus) AS StudentStatus,
		CASE WHEN SubcriberID = '''' THEN NULL ELSE SubcriberID END AS SubcriberID,
		CASE WHEN HealthPlanName = '''' THEN NULL ELSE HealthPlanName END AS HealthPlanName,
		CASE WHEN HealthPlanID = '''' THEN NULL ELSE HealthPlanID END AS HealthPlanID,
		CASE WHEN CardholderName = '''' THEN NULL ELSE CardholderName END AS CardholderName,
		CASE WHEN CardholderID = '''' THEN NULL ELSE CardholderID END AS CardholderID,
		CASE WHEN PersonCode = '''' THEN NULL ELSE PersonCode END AS PersonCode,
		CASE WHEN GroupName = '''' THEN NULL ELSE GroupName END AS GroupName,
		CASE WHEN GroupID = '''' THEN NULL ELSE GroupID END AS GroupID,
		CASE WHEN BIN = '''' THEN NULL ELSE BIN END AS BIN,
		CASE WHEN PCN = '''' THEN NULL ELSE PCN END AS PCN,
		CASE WHEN FormularyID = '''' THEN NULL ELSE FormularyID END AS FormularyID,
		CASE WHEN AlternativesID = '''' THEN NULL ELSE AlternativesID END AS AlternativesID,
		CASE WHEN CoverageID = '''' THEN NULL ELSE CoverageID END AS CoverageID,
		CASE WHEN CopayID = '''' THEN NULL ELSE CopayID END AS CopayID,
		CASE WHEN ServiceDate = '''' THEN NULL ELSE ServiceDate END AS ServiceDate,
		CASE WHEN EligibilityDate = '''' THEN NULL ELSE EligibilityDate END AS EligibilityDate,
		CASE WHEN PharmacyEligible = ''1'' THEN PharmacyEligible ELSE 0 END AS PharmacyEligible,
		CASE WHEN MailOrderEligible = ''1'' THEN MailOrderEligible ELSE 0 END AS MailOrderEligible
	FROM cteeRxCoverage
	
	RETURN
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[eRxOutbound_getRecent]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[eRxOutbound_getRecent] 
(
	@Guid UNIQUEIDENTIFIER
)
RETURNS UNIQUEIDENTIFIER
AS  
BEGIN 

DECLARE @ReturnGuid UNIQUEIDENTIFIER

set @ReturnGuid = null

SELECT TOP 1 @ReturnGuid = eRxOutbound.eRxOutboundUid 
from eRxOutbound 
where (RelVisitMedicationUid = @Guid)
order by LastModifiedDate desc

RETURN @ReturnGuid

END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[eRxOutbound_getRecentLastModifiedDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[eRxOutbound_getRecentLastModifiedDate] 
(
	@Guid UNIQUEIDENTIFIER
)
RETURNS DATETIME
AS  
BEGIN 

DECLARE @Return DATETIME

set @Return = null

SELECT TOP 1 @Return = eRxOutbound.LastModifiedDate 
from eRxOutbound 
where (RelVisitMedicationUid = @Guid)
order by LastModifiedDate desc

RETURN @Return

END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[eRxOutbound_getRecentSuccessful]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[eRxOutbound_getRecentSuccessful] 
(
	@Guid UNIQUEIDENTIFIER
)
RETURNS BIT
AS  
BEGIN 

DECLARE @Return BIT

set @Return = null

SELECT TOP 1 @Return = eRxOutbound.Successful 
from eRxOutbound 
where (RelVisitMedicationUid = @Guid)
order by LastModifiedDate desc

RETURN @Return

END
 
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EscapeXmlElementName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[EscapeXmlElementName](@xml VARCHAR(MAX)) RETURNS VARCHAR(MAX) AS
BEGIN
	SET @xml = REPLACE(@xml, ''&'', '''')
	SET @xml = REPLACE(@xml, ''>'', '''')
	SET @xml = REPLACE(@xml, ''<'', '''')
	SET @xml = REPLACE(@xml, ''"'', '''')
	SET @xml = REPLACE(@xml, '''''''', '''')
	SET @xml = REPLACE(@xml, ''+'', '''')
	SET @xml = REPLACE(@xml, ''|'', '''')
    SET @xml = REPLACE(@xml,'' '','''')

    DECLARE @FirstChar VARCHAR = NULL
    SET @FirstChar = LEFT(@xml,1)
	IF ASCII(UPPER(@FirstChar)) NOT BETWEEN 65 AND 90
	BEGIN
	    IF ASCII(@FirstChar) BETWEEN 48 AND 57
		BEGIN
            SET @xml = ''NUM_'' + @xml
		END
		ELSE
		BEGIN
			SET @xml = ''SCHAR_'' + @xml
		END
	END

	RETURN @xml
END

/*
select convert(XML,''<''+[dbo].[EscapeXmlElementName](''game'')+'' />'')
select convert(XML,''<''+[dbo].[EscapeXmlElementName](''9'')+'' />'')
select convert(XML,''<''+[dbo].[EscapeXmlElementName](''_game'')+'' />'')
select convert(XML,''<''+[dbo].[EscapeXmlElementName](''&game'')+'' />'')
select convert(XML,''<''+[dbo].[EscapeXmlElementName](''"game'')+'' />'')
select convert(XML,''<''+[dbo].[EscapeXmlElementName](''>game'')+'' />'')
select convert(XML,''<''+[dbo].[EscapeXmlElementName](''<game'')+'' />'')
select convert(XML,''<''+[dbo].[EscapeXmlElementName](''+ga-me'')+'' />'')
select convert(XML,''<''+[dbo].[EscapeXmlElementName](''-|game'')+'' />'')
*/' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EZPAY_getNextDetailRec]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


-- =============================================
-- Author:		Patrick Pappenfus, Wiregrass Solutions,  LLC
-- Create date: 1/22/2008
-- Description:	Function for retrieving next Settlement Detail RecNo.
-- =============================================
CREATE FUNCTION [dbo].[EZPAY_getNextDetailRec] 
(
)
RETURNS int
AS
BEGIN
	DECLARE @nextrec int

    SELECT @nextrec = case when max(recno) is null then 1 else MAX(RECNO) + 1 end FROM EZPAYSETTLEMENT_DETAILS
	RETURN @nextrec 
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EZPAY_getNextHistoryRecNo]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

-- =============================================
-- Author:		Patrick Pappenfus, Wiregrass Solutions,  LLC
-- Create date: 1/22/2008
-- Description:	Function for retrieving next History RecNo.
-- =============================================
CREATE FUNCTION [dbo].[EZPAY_getNextHistoryRecNo] 
(
)
RETURNS int
AS
BEGIN
	DECLARE @nextrec int

	SELECT @nextrec = MAX(RECNO) + 1 FROM EZPAYSETTLEMENT_HISTORY
    IF @nextrec IS NULL SELECT @nextrec = 1 

	RETURN @nextrec
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[EZPAY_getNextMerchRec]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =============================================
-- Author:		Patrick Pappenfus, Wiregrass Solutions,  LLC
-- Create date: 1/22/2008
-- Description:	Function for retrieving next merchant rec no.
-- =============================================
CREATE FUNCTION [dbo].[EZPAY_getNextMerchRec] 
(
)
RETURNS int
AS
BEGIN
	DECLARE @nextrec int

	SELECT @nextrec = MAX(MERCH_REC) + 1 FROM EZPAYMERCHANT_SETTINGS

	RETURN @nextrec
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FirstDayOfWeek]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE FUNCTION [dbo].[FirstDayOfWeek] 
(
    @date DATETIME
)
RETURNS DATETIME
AS
BEGIN
	DECLARE @dtFirstDayOfWeek DATETIME
    SET @dtFirstDayOfWeek = CAST (CONVERT (VARCHAR (16), DATEADD(DD, 1 - DATEPART(DW, @date), @date), 101) AS DATETIME)
	RETURN @dtFirstDayOfWeek
END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[fn_getHSVRDataElementsByVisitUID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[fn_getHSVRDataElementsByVisitUID] 
(
	@VisitUID UniqueIdentifier
)
/*
select top 1 visituid from visitdata where data is not null
select * from dbo.fn_getHSVRDataElementsByVisitUID (''1B7D89F2-4C85-4059-AE17-022583AEBE79'')

select blah.* from visit v cross apply dbo.fn_getHSVRDataElementsByVisitUID(v.visituid) blah

*/
RETURNS 
	@HSVR_table TABLE 
(
	[VisitUID]		UniqueIdentifier,
	[Element Name]	varchar(100),
	[Element XML]   xml,
	[Value]			varchar(100),
	[Label]			varchar(100)	
)
AS
BEGIN
	-- Fill the table variable with the rows for your result set
	INSERT INTO @HSVR_table
		SELECT 	
			vd.visituid,
			cast(Nodes.Name.query(''local-name(.)'')		as varchar(100))	as [Element Name],
			Nodes.Name.query(''.'')											as [Element XML],
			Nodes.Name.value(''@Value[1]'',''varchar(100)'')					as [Value],
			Nodes.Name.value(''@Label[1]'',''varchar(100)'')					as [Label]
		FROM VisitData vd cross apply data.nodes (''//data/HSVR/current/*'')	as Nodes(Name)
			WHERE vd.visituid = @VisitUID and vd.data is not null
	RETURN 
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FormularyCopayDescription]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[FormularyCopayDescription](
   @FlatCopayAmount       VARCHAR(10),
   @PercentCopayRate      VARCHAR(10),
   @FirstCopayTerm        VARCHAR(1),
   @MinimumCopay          VARCHAR(10),
   @MaximumCopay          VARCHAR(10),
   @DaysSupplyPerCopay    VARCHAR(3),
   @CopayTier             VARCHAR(2),
   @MaximumCopayTier      VARCHAR(2),
   @OutOfPocketRangeStart VARCHAR(10),
   @OutOfPocketRangeEnd   VARCHAR(10)) RETURNS VARCHAR(MAX) AS
BEGIN
   RETURN CASE
              WHEN @FlatCopayAmount IS NOT NULL AND ISNULL(@FirstCopayTerm, ''F'') != ''P'' AND @PercentCopayRate IS NOT NULL THEN ''$'' + @FlatCopayAmount + '' + ''
              WHEN @FlatCopayAmount IS NOT NULL AND ISNULL(@FirstCopayTerm, ''F'') != ''P'' THEN ''$'' + @FlatCopayAmount
              ELSE ''''
           END +
           CASE
              WHEN @PercentCopayRate IS NOT NULL THEN CONVERT(VARCHAR(10), CONVERT(INT, CONVERT(MONEY, @PercentCopayRate) * 100)) + ''%''
              ELSE ''''
           END +
           CASE
              WHEN @FlatCopayAmount IS NOT NULL AND ISNULL(@FirstCopayTerm, ''F'') = ''P'' AND @PercentCopayRate IS NOT NULL THEN '' + $'' + @FlatCopayAmount
              WHEN @FlatCopayAmount IS NOT NULL AND ISNULL(@FirstCopayTerm, ''F'') = ''P'' THEN ''$'' + @FlatCopayAmount
              ELSE ''''
           END +
           CASE
              WHEN @PercentCopayRate IS NOT NULL THEN
                   CASE
                      WHEN @MinimumCopay IS NOT NULL AND @MaximumCopay IS NOT NULL
                         THEN '' (Min:$'' + @MinimumCopay  + '' Max:$'' + @MaximumCopay + '')''
                      WHEN @MinimumCopay IS NOT NULL
                         THEN '' (Min:$'' + @MinimumCopay  + '')''
                      WHEN @MaximumCopay IS NOT NULL
                         THEN '' (Max:$'' + @MaximumCopay  + '')''
                      ELSE ''''
                   END
              ELSE ''''
           END +
           CASE
              WHEN @CopayTier IS NOT NULL AND (@FlatCopayAmount IS NOT NULL OR @PercentCopayRate IS NOT NULL) THEN '', Tier '' + @CopayTier
              WHEN @CopayTier IS NOT NULL THEN ''Tier '' + @CopayTier
              ELSE ''''
           END +
           CASE
              WHEN @MaximumCopayTier IS NOT NULL THEN '', Max Tier '' + @MaximumCopayTier
              ELSE ''''
           END +
           CASE WHEN @DaysSupplyPerCopay IS NOT NULL
              THEN '', '' + @DaysSupplyPerCopay + '' Days Supply''
              ELSE ''''
           END +
           CASE WHEN @OutOfPocketRangeStart IS NOT NULL AND @OutOfPocketRangeEnd IS NOT NULL
              THEN '' With Out Of Pocket Range ($'' + @OutOfPocketRangeStart + '' - $'' + @OutOfPocketRangeEnd + '')''
              ELSE ''''
           END +
           CASE WHEN @OutOfPocketRangeStart IS NOT NULL AND @OutOfPocketRangeEnd IS NULL
              THEN '' With Out Of Pocket Range ($'' + @OutOfPocketRangeStart + '' with no upper range)''
              ELSE ''''
           END
END
' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FromASCII]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[FromASCII](@src [nvarchar](max))
RETURNS [nvarchar](max) WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[FromASCII]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[FromBase64]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[FromBase64]
(
	@data [VARCHAR](MAX)
)
RETURNS [VARCHAR](MAX)
AS
BEGIN
	IF @data IS NOT NULL AND LEN(@data) > 0
	BEGIN
		RETURN (SELECT CAST(CAST(N'''' AS XML).value(''xs:base64Binary(sql:variable("@data"))'', ''VARBINARY(MAX)'') AS VARCHAR(MAX)))
	END
	RETURN NULL
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Get_ELGREQ_RestrictToDayPeriod]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[Get_ELGREQ_RestrictToDayPeriod]
(
)
RETURNS [smallint]
AS
BEGIN
	DECLARE @data [smallint],
		@eRxMessageTypeUid [uniqueidentifier] = ''6B18C334-E4A6-4F82-A831-1AAA6CF6009E''	-- ELGREQ

	SELECT @data = [RestrictTo]
	FROM [ListeRxMessageType]
	WHERE [eRxMessageTypeUid] = @eRxMessageTypeUid

	IF @data IS NULL
	BEGIN
		SET @data = 3
	END
	RETURN @data
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GET_InsuranceTotalBalance]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GET_InsuranceTotalBalance]
 (	
	 @superbillUid UNIQUEIDENTIFIER
 )

RETURNS Money AS
BEGIN
		DECLARE	@balance Money
		SELECT  @balance=AssignedLiabilityBalance
		FROM AR_ViewSuperbillAggregate
			WHERE SuperbillUid = @superbillUid			 

	RETURN @balance
END	

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAccountPeriodEligibilityDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[GetAccountPeriodEligibilityDate] (@accountuid uniqueidentifier, @date datetime) 
	RETURNS SMALLINT 
AS
BEGIN

	DECLARE	@accountPeriodUid UNIQUEIDENTIFIER
	DECLARE @eligibilityStatus SMALLINT

	SELECT @accountPeriodUid = dbo.GetAccountPeriod(@accountuid,@date)
	IF (@accountPeriodUid!=NULL)
		SELECT TOP 1 @eligibilityStatus = EligibilityStatus FROM ViewAccountPeriodEligibilityDate
			WHERE AccountPeriodUid = @accountPeriodUid

	RETURN @eligibilityStatus
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAccountResponsiblePartyMostRecentCollectionChargeAmount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE FUNCTION [dbo].[GetAccountResponsiblePartyMostRecentCollectionChargeAmount]
(
	@accountResponsiblePartyUid uniqueidentifier
)
RETURNS 
	money
AS

BEGIN
	DECLARE @mostRecentCollectionChargeAmount money
	SELECT TOP 1 @mostRecentCollectionChargeAmount = LD.Amount 
		FROM SuperbillProcedure SBP WITH (NOLOCK)
		INNER JOIN AR_LedgerDetail LD WITH (NOLOCK) ON SBP.SuperbillProcedureUid = LD.SuperbillProcedureUid
		INNER JOIN AR_Ledger L WITH (NOLOCK) ON LD.LedgerUid = L.LedgerUid
		LEFT JOIN AR_Ledger L_VOID WITH (NOLOCK) ON L.LedgerUid = L_VOID.VoidLedgerUid
		INNER JOIN ARBatch ARB WITH (NOLOCK) ON L.ArBatchUid = ARB.ARBatchUid
		INNER JOIN Superbill SB WITH (NOLOCK) ON SBP.SuperbillUid = SB.SuperbillUid
		INNER JOIN Account AC WITH (NOLOCK) ON SB.AccountUid = AC.AccountUid
	WHERE SBP.procedureuid = (SELECT distinct feedefaultprocedureuid FROM collectionstatusglobal WITH (NOLOCK))
		AND AC.AccountResponsiblePartyUid = @accountResponsiblePartyUid
		AND (L.VoidLedgerUid IS NULL AND L_VOID.LedgerUid IS NULL) -- no voids
		AND LD.IsCredit = 0 -- non reversed charge
	ORDER BY ARB.GLDate DESC

	RETURN isnull(@mostRecentCollectionChargeAmount, 0)
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAccountResponsiblePartyMostRecentPaymentAmount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[GetAccountResponsiblePartyMostRecentPaymentAmount]
(
	@AccountResponsiblePartyUid UNIQUEIDENTIFIER
)
RETURNS 
	MONEY
AS 
BEGIN
	DECLARE @MostRecentPaymentAmount MONEY
	SELECT TOP 1 @MostRecentPaymentAmount = 0 - LD.Amount 
		FROM AR_LedgerDetail LD
			INNER JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid
			LEFT JOIN AR_Ledger voidL ON L.LedgerUid = voidL.VoidLedgerUid
		WHERE L.EntryType = 0 AND LD.IsCredit = 1
			AND voidL.LedgerUid IS NULL AND L.VoidLedgerUid IS NULL
			AND LD.AccountResponsiblePartyUid = @AccountResponsiblePartyUid
		ORDER BY LD.CreatedDateTime DESC -- USE Create Date not Posting Date

	RETURN ISNULL(@MostRecentPaymentAmount, 0)
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAccountResponsiblePartyMostRecentPaymentDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[GetAccountResponsiblePartyMostRecentPaymentDate]
(
	@AccountResponsiblePartyUid UNIQUEIDENTIFIER
)
RETURNS 
	DATETIME
AS
BEGIN
	DECLARE @MostRecentDate DATETIME 
	SELECT TOP 1 @MostRecentDate = LD.CreatedDateTime
		FROM AR_LedgerDetail LD
			INNER JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid
			LEFT JOIN AR_Ledger voidL ON L.LedgerUid = voidL.VoidLedgerUid
		WHERE L.EntryType = 0 AND LD.IsCredit = 1
			AND voidL.LedgerUid IS NULL AND L.VoidLedgerUid IS NULL -- catch both sides of voids and discard
			AND LD.AccountResponsiblePartyUid = @AccountResponsiblePartyUid
		ORDER BY LD.CreatedDateTime DESC -- USE Create Date not Posting Date

	RETURN @MostRecentDate
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAccountResponsiblePartyPaymentTotalAllByDateRange]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[GetAccountResponsiblePartyPaymentTotalAllByDateRange]
(
	@AccountResponsiblePartyUid UNIQUEIDENTIFIER,
	@FromDate DATE,
	@ToDate DATE
)
RETURNS 
	MONEY
AS
BEGIN
	DECLARE @TotalPayments MONEY
	SELECT @TotalPayments = SUM(LD_DebitSide.Amount)
		FROM AR_LedgerDetail LD_DebitSide
			INNER JOIN AR_LedgerDetail LD_CreditSide ON LD_DebitSide.LedgerUid = LD_CreditSide.LedgerUid
			INNER JOIN AR_Ledger L ON LD_DebitSide.LedgerUid = L.LedgerUid
			LEFT JOIN AR_Ledger L_VOID ON L.LedgerUid = L_VOID.VoidLedgerUid
			INNER JOIN SuperbillProcedure SBP ON LD_CreditSide.SuperbillProcedureUid = SBP.SuperbillProcedureUid
			INNER JOIN Superbill SB ON SBP.SuperbillUid = SB.SuperbillUid
			INNER JOIN Account AC ON SB.AccountUid = AC.AccountUid
		WHERE L.EntryType = 2 AND LD_DebitSide.IsCredit = 0 -- Deposit Side of the Distribution
			AND LD_CreditSide.IsCredit = 1
			AND LD_CreditSide.LiabilityOwner = 0 -- bug 17442 and 21991 limit total to payments on patient liabilities only
			AND (L.VoidLedgerUid IS NULL AND L_VOID.LedgerUid IS NULL) -- not voided or voiding
			AND AC.AccountResponsiblePartyUid = @AccountResponsiblePartyUid -- match on the SB side
			AND L.CreatedDateTime BETWEEN @FromDate AND @ToDate  -- USE Create Date not Posting Date

	RETURN isnull(@TotalPayments, 0)
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAddress]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetAddress](@address xml(CONTENT dbo.Address)) RETURNS VARCHAR(255) AS
BEGIN
	IF @address IS NULL
		RETURN NULL
		
	DECLARE @address1 VARCHAR(100)
	DECLARE @address2 VARCHAR(100)
	DECLARE @a VARCHAR(255)
	
	SET @address1 = @address.value(''(/Address/Address1)[1]'', ''VARCHAR(100)'')
	SET @address2 = @address.value(''(/Address/Address2)[1]'', ''VARCHAR(100)'')
	
	IF RTRIM(ISNULL(@address1, '''')) <> ''''
		SET @a = @address1
		
	IF RTRIM(ISNULL(@address2, '''')) <> ''''
	BEGIN
		IF RTRIM(ISNULL(@a, '''')) <> ''''
			SET @a = @a + '' ''
		
		SET @a = @a + @address2
	END
		
	RETURN @a
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetCityStateZip]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetCityStateZip](@address xml(CONTENT dbo.Address)) RETURNS VARCHAR(255) AS
BEGIN
	IF @address IS NULL
		RETURN NULL
		
	DECLARE @city VARCHAR(100)
	DECLARE @state VARCHAR(100)
	DECLARE @zip VARCHAR(100)
	DECLARE @country VARCHAR(100)
	DECLARE @csz VARCHAR(255)
	
	SET @city = @address.value(''(/Address/City)[1]'', ''VARCHAR(100)'')
	SET @state = @address.value(''(/Address/State)[1]'', ''VARCHAR(100)'')
	SET @zip = @address.value(''(/Address/Zip)[1]'', ''VARCHAR(100)'')
	SET @country = @address.value(''(/Address/Country)[1]'', ''VARCHAR(100)'')
	
	IF RTRIM(ISNULL(@city, '''')) <> ''''
		SET @csz = @city
		
	IF RTRIM(ISNULL(@state, '''')) <> ''''
	BEGIN
		IF RTRIM(ISNULL(@csz, '''')) <> ''''
			SET @csz = @csz + '', ''
		
		SET @csz = @csz + @state
	END
	
	IF RTRIM(ISNULL(@zip, '''')) <> ''''
	BEGIN
		IF RTRIM(ISNULL(@csz, '''')) <> ''''
			SET @csz = @csz + ''  ''
		
		SET @csz = @csz + @zip
	END
	
	IF RTRIM(ISNULL(@country, '''')) <> ''''
	BEGIN
		IF RTRIM(ISNULL(@csz, '''')) <> ''''
			SET @csz = @csz + '' ''
			
		SET @csz = @csz + @country
	END
	
	RETURN @csz
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAddressCityStateZip]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetAddressCityStateZip](@address xml(CONTENT dbo.Address)) RETURNS VARCHAR(255) AS
BEGIN
	IF @address IS NULL
		RETURN NULL
		
	DECLARE @a VARCHAR(100)
	DECLARE @address2 VARCHAR(100)
	DECLARE @csz VARCHAR(255)
	DECLARE @acsz VARCHAR(512)	
	
	SET @a = dbo.GetAddress(@address)
	SET @csz = dbo.GetCityStateZip(@address)
	
	IF RTRIM(ISNULL(@a, '''')) <> ''''
		SET @acsz = @a
			
	IF RTRIM(ISNULL(@csz, '''')) <> ''''
	BEGIN
		IF RTRIM(ISNULL(@acsz, '''')) <> ''''
			SET @acsz = @acsz + '' ''
		
		SET @acsz = @acsz + @csz
	END
		
	RETURN @acsz
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetAHFSClassificationID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetAHFSClassificationID] (@medid int, @mnid int)
RETURNS varchar(6) AS BEGIN

	declare @classID varchar(6)

	if (IsNull(@mnid, 0) > 0)
	begin	
		SELECT @classID = fdb_classification_ahfs.classID
		FROM fdb_classification_ahfs
		INNER JOIN fdb_ahfsclassification_drugs 
		ON fdb_ahfsclassification_drugs.ClassID = fdb_classification_ahfs.ClassID
		AND fdb_ahfsclassification_drugs.concepttype = 1
		WHERE fdb_ahfsclassification_drugs.conceptid = @mnid
	end
	else begin
		SELECT @classID = fdb_classification_ahfs.classID
		FROM fdb_classification_ahfs
		INNER JOIN fdb_ahfsclassification_drugs 
		ON fdb_ahfsclassification_drugs.ClassID = fdb_classification_ahfs.ClassID
		AND fdb_ahfsclassification_drugs.concepttype = 3
		WHERE fdb_ahfsclassification_drugs.conceptid = @medid
	end
	return @classID

END ' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetBatchNamesByTransaction]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[GetBatchNamesByTransaction](@transactionUid as uniqueidentifier) RETURNS VARCHAR(255) AS
BEGIN
	IF @transactionUid IS NULL
		RETURN NULL
		
	DECLARE @retVal VARCHAR(255)
	select @retVal = stuff( (select distinct '','' + arb.Name
								FROM AR_Ledger arl with (nolock) 
										inner join ARBatch arb with (nolock) on arl.ARBatchUid = arb.ARBatchUid
								where arl.TransactionUid = @transactionUid
								for xml path('''')), 1, 1, '''' )
	return @retVal
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetBatchStateByTransaction]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[GetBatchStateByTransaction](@transactionUid as uniqueidentifier) RETURNS VARCHAR(255) AS
BEGIN
	IF @transactionUid IS NULL
		RETURN NULL
		
	DECLARE @retVal VARCHAR(255)
	SELECT @retVal = stuff( (select DISTINCT '','' +
									CASE WHEN arb.IsClosed = 1 THEN ''Complete''
										 WHEN arb.IsLocked = 1 THEN ''Locked''
										 ELSE						''Open'' END
							 FROM AR_Ledger arl with (nolock)
									INNER JOIN ARBatch arb with (nolock) on arl.ARBatchUid = arb.ARBatchUid
							 WHERE arl.TransactionUid = @transactionUid
							 FOR XML PATH('''')), 1, 1, '''')
	
	return @retVal
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetBatchUidsByTransaction]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[GetBatchUidsByTransaction](@transactionUid as uniqueidentifier) RETURNS VARCHAR(255) AS
BEGIN
	IF @transactionUid IS NULL
		RETURN NULL
		
	DECLARE @retVal VARCHAR(255)
	select @retVal = stuff( (select distinct '','' + convert(varchar(36),arl.arbatchUid)
								FROM AR_Ledger arl with (nolock) 
								where arl.TransactionUid = @transactionUid
								for xml path('''')), 1, 1, '''' )
	return @retVal
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetBestBloodPressure]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetBestBloodPressure](@patientUid UNIQUEIDENTIFIER, @startDate DATE, @endDate DATE)
	RETURNS @PatientBloodPressure TABLE 
	(
		PatientUid UNIQUEIDENTIFIER PRIMARY KEY,
		BloodPressureDate DATE,
		BloodPressure VARCHAR(8),
		Systolic DECIMAL,
		Diastolic DECIMAL
	)
AS
BEGIN
			INSERT			@PatientBloodPressure
			SELECT TOP 1	@patientUid, CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) AS BloodPressureDate,
							CAST(CAST(ov.MetricValue1 AS INT) AS VARCHAR(3)) + ''/'' + CAST(CAST(ov.MetricValue2 AS INT) AS VARCHAR(3)), 
							ov.MetricValue1 AS Systolic, ov.MetricValue2 AS Diastolic
			FROM			ObservationOrder oo INNER JOIN ObservationValue ov ON oo.ObservationOrderUid = ov.ObservationOrderUid
			WHERE			ov.ObservationItemUid = ''00000000-0000-0000-7777-100000000073'' AND
							oo.PatientUid = @patientUid AND
							(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) >= @startDate OR @startDate IS NULL) AND
							(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE)<= @endDate OR @endDate IS NULL) 
			ORDER BY		CASE WHEN ov.MetricValue1 >= 90 OR ov.MetricValue2 >= 140 THEN 2000 + ov.MetricValue1 + ov.MetricValue2 ELSE ov.MetricValue1 + ov.MetricValue2 END, -- Make sure over 90 or 140 is higher than any that isn''t
							COALESCE(oo.ResultDate, oo.PerformDate) DESC
	RETURN 
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getCreditCardName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[getCreditCardName]
(@displayOrder INT)  
RETURNS Varchar(100) AS  
BEGIN 
	Declare @name varchar(100)
	Declare @cntCrCard int
	Set @name=''''
	Select @cntCrCard=count(*) From listpaymenttype Where InternalCardType IS NOT NULL
	IF (@cntCrCard >=@displayOrder)
	BEGIN
--	Select @name = Name from ListCreditCard Where DisplayOrder = @displayOrder
		IF @displayOrder=1
			Select top  1  @name=''''+ name  From listpaymenttype Where InternalCardType IS NOT NULL Order by Name
		IF @displayOrder=2
			Select top  2  @name=''''+ name  From listpaymenttype Where InternalCardType IS NOT NULL Order by Name
		IF @displayOrder=3
			Select top  3  @name=''''+ name  From listpaymenttype Where InternalCardType IS NOT NULL Order by Name
		IF @displayOrder=4
			Select top  4  @name=''''+ name  From listpaymenttype Where InternalCardType IS NOT NULL Order by Name
		IF @displayOrder=5
			Select top  5  @name=''''+ name  From listpaymenttype Where InternalCardType IS NOT NULL Order by Name
		IF @displayOrder=6
			Select top  6  @name=''''+ name  From listpaymenttype Where InternalCardType IS NOT NULL Order by Name
	END

	Return @name
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetCurrentPatientHistoryQuestionAnswerName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetCurrentPatientHistoryQuestionAnswerName](@patientUid UNIQUEIDENTIFIER, @questionUid UNIQUEIDENTIFIER, @date DATE) RETURNS VARCHAR(255) AS
BEGIN
	DECLARE @answerName VARCHAR(255)
	
	SELECT TOP 1	@answerName = vph.AnswerName
	FROM			ViewPatientHistory vph
	WHERE			vph.QuestionUid = @questionUid AND
					(vph.ActiveDate <= @date OR @date IS NULL) AND
					vph.PatientUid = @patientUid					
	ORDER BY		vph.ActiveDate DESC

	RETURN @answerName
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetCustomerNumber]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetCustomerNumber] () RETURNS VARCHAR(10) AS
BEGIN
	-- Declare the return variable here
	DECLARE @xml XML
	DECLARE @customerNumber VARCHAR(10)

	SELECT @xml = XmlValue FROM ListProductParameter WHERE ParameterName = ''RegistrationCustomerLicense''
	IF @xml IS NULL
		RETURN NULL
	
	SELECT @customerNumber = @xml.value(''(/License/Customer/@number)[1]'', ''VARCHAR(10)'')

	RETURN @customerNumber
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetDepositNamesByTransaction]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetDepositNamesByTransaction](@transactionUid as uniqueidentifier) RETURNS VARCHAR(255) AS
BEGIN
	IF @transactionUid IS NULL
		RETURN NULL
		
	DECLARE @retVal VARCHAR(255)
	SELECT @retVal = stuff(( select DISTINCT '','' + d.ReferenceNumber
							FROM AR_Ledger arl with (nolock) 
									INNER JOIN AR_LedgerDetail ld with (nolock) on arl.TransactionUid = @transactionUid 
																					AND arl.LedgerUid = ld.LedgerUid
									INNER JOIN Deposit d with (nolock) on ld.DepositUid = d.DepositUid
							FOR XML PATH('''')), 1, 1, '''')
	return @retVal
END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetDiagnosis]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE FUNCTION [dbo].[GetDiagnosis] (@visitProcedureUid uniqueidentifier) RETURNS VARCHAR(100) AS
	BEGIN
		DECLARE @diagnosis varchar(100)
		DECLARE @diagCode varchar(25)
		
		DECLARE cur CURSOR FOR 
			SELECT		vd.Code
			FROM		VisitProcedureDiagnosis vspd INNER JOIN VisitDiagnosis vd ON vspd.VisitDiagnosisUid = vd.VisitDiagnosisUid
			WHERE		vspd.VisitProcedureUid = @visitProcedureUid
			ORDER BY	vspd.DisplayOrder
			
		OPEN cur

		FETCH NEXT FROM cur INTO @diagCode
		WHILE @@FETCH_STATUS = 0
		BEGIN
			IF NOT @diagnosis IS NULL
				SET @diagnosis = @diagnosis + '',''
			ELSE
				SET @diagnosis = ''''
				
				SET @diagnosis = @diagnosis + @diagCode

			FETCH NEXT FROM cur INTO @diagCode
		END
		
		CLOSE cur
		DEALLOCATE cur
			
	
	RETURN @diagnosis
	
	END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetDiagnosisByMedication]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[GetDiagnosisByMedication] (@MedicationSigUid uniqueidentifier) RETURNS VARCHAR(max) AS
	BEGIN
		DECLARE @diagnosis varchar(max)
		DECLARE @diagCode varchar(max)
		--set @MedicationSigUid = ''BDD5454D-EA16-459F-99CD-2A640E939710''
		DECLARE cur CURSOR FOR 
			SELECT		coalesce(rdm.Code10,rdm.Code9) + '' '' + ISNULL(rdm.CodeDescription,'''')
			FROM		RelMedicationDiagnosis rdm --INNER JOIN VisitDiagnosis vd ON rvm.VisitDiagnosisUid = vd.VisitDiagnosisUid
			WHERE		rdm.MedicationSIGUid = @MedicationSigUid
			ORDER BY	rdm.DisplayOrder
			
		OPEN cur

		FETCH NEXT FROM cur INTO @diagCode
		WHILE @@FETCH_STATUS = 0
		BEGIN
			IF NOT @diagnosis IS NULL
				SET @diagnosis = @diagnosis + '', ''
			ELSE
				SET @diagnosis = ''''
				
				SET @diagnosis = @diagnosis + @diagCode

			FETCH NEXT FROM cur INTO @diagCode
		END
		
		CLOSE cur
		DEALLOCATE cur
		--print @diagnosis	
	
	RETURN @diagnosis
	
	END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetDiagnosisCodeAndName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetDiagnosisCodeAndName]
(
	@code9 VARCHAR(25),
	@code10 VARCHAR(25),
	@codeDescription VARCHAR(255)
)
RETURNS VARCHAR(512)
AS
BEGIN
	DECLARE @code VARCHAR(51)


	IF @code9 IS NOT NULL OR RTRIM(@code9) <> ''''
		SET @code = @code9
	IF @code10 IS NOT NULL OR RTRIM(@code10) <> ''''
		SET @code = @code10 + ''-'' + @code9

	RETURN ''('' + @code + '') '' + @codeDescription
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetDiagnosisCodeList]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[GetDiagnosisCodeList](@superbillProcedureUid uniqueidentifier) 
RETURNS VARCHAR(MAX) AS
BEGIN
	DECLARE @diagnosisCodeList VARCHAR(MAX);

	WITH cteSuperbillProcedureDiagnosis AS
	(
		SELECT SBP.SuperbillProcedureUid, SD.SuperbillDiagnosisUid,
			  SD.DisplayOrder, CAST(0 AS BIT) AS [Inactive],
			  SBP.LastModifiedByUid,
			  GETUTCDATE() AS [LastModifiedDate]
			FROM SuperbillProcedure SBP
				INNER JOIN SuperbillDiagnosis SD ON SBP.SuperbillUid = SD.SuperbillUid 
					AND SBP.DiagnosisPointer1 = SD.DisplayOrder
		UNION
		SELECT SBP.SuperbillProcedureUid, SD.SuperbillDiagnosisUid,
			  SD.DisplayOrder, CAST(0 AS BIT) AS [Inactive],
			  SBP.LastModifiedByUid,
			  GETUTCDATE() AS [LastModifiedDate]
			FROM SuperbillProcedure SBP
				INNER JOIN SuperbillDiagnosis SD ON SBP.SuperbillUid = SD.SuperbillUid 
					AND SBP.DiagnosisPointer2 = SD.DisplayOrder
		UNION
		SELECT SBP.SuperbillProcedureUid, SD.SuperbillDiagnosisUid,
			  SD.DisplayOrder, CAST(0 AS BIT) AS [Inactive],
			  SBP.LastModifiedByUid,
			  GETUTCDATE() AS [LastModifiedDate]
			FROM SuperbillProcedure SBP
				INNER JOIN SuperbillDiagnosis SD ON SBP.SuperbillUid = SD.SuperbillUid 
					AND SBP.DiagnosisPointer3 = SD.DisplayOrder
		UNION
		SELECT SBP.SuperbillProcedureUid, SD.SuperbillDiagnosisUid,
			  SD.DisplayOrder, CAST(0 AS BIT) AS [Inactive],
			  SBP.LastModifiedByUid,
			  GETUTCDATE() AS [LastModifiedDate]
			FROM SuperbillProcedure SBP
				INNER JOIN SuperbillDiagnosis SD ON SBP.SuperbillUid = SD.SuperbillUid 
					AND SBP.DiagnosisPointer4 = SD.DisplayOrder
		UNION
		SELECT SBP.SuperbillProcedureUid, SD.SuperbillDiagnosisUid,
			  SD.DisplayOrder, CAST(0 AS BIT) AS [Inactive],
			  SBP.LastModifiedByUid,
			  GETUTCDATE() AS [LastModifiedDate]
			FROM SuperbillProcedure SBP
				INNER JOIN SuperbillDiagnosis SD ON SBP.SuperbillUid = SD.SuperbillUid 
					AND SBP.DiagnosisPointer5 = SD.DisplayOrder
		UNION
		SELECT SBP.SuperbillProcedureUid, SD.SuperbillDiagnosisUid,
			  SD.DisplayOrder, CAST(0 AS BIT) AS [Inactive],
			  SBP.LastModifiedByUid,
			  GETUTCDATE() AS [LastModifiedDate]
			FROM SuperbillProcedure SBP
				INNER JOIN SuperbillDiagnosis SD ON SBP.SuperbillUid = SD.SuperbillUid 
					AND SBP.DiagnosisPointer6 = SD.DisplayOrder
		UNION
		SELECT SBP.SuperbillProcedureUid, SD.SuperbillDiagnosisUid,
			  SD.DisplayOrder, CAST(0 AS BIT) AS [Inactive],
			  SBP.LastModifiedByUid,
			  GETUTCDATE() AS [LastModifiedDate]
			FROM SuperbillProcedure SBP
				INNER JOIN SuperbillDiagnosis SD ON SBP.SuperbillUid = SD.SuperbillUid 
					AND SBP.DiagnosisPointer7 = SD.DisplayOrder
		UNION
		SELECT SBP.SuperbillProcedureUid, SD.SuperbillDiagnosisUid,
			  SD.DisplayOrder, CAST(0 AS BIT) AS [Inactive],
			  SBP.LastModifiedByUid,
			  GETUTCDATE() AS [LastModifiedDate]
			FROM SuperbillProcedure SBP
				INNER JOIN SuperbillDiagnosis SD ON SBP.SuperbillUid = SD.SuperbillUid 
					AND SBP.DiagnosisPointer8 = SD.DisplayOrder
	), cteSuperbillProcedureInfo AS
	(
	SELECT TOP 10000 VSPD.SuperbillProcedureUid, VSPD.DisplayOrder, -- TOP required for order by
				CASE WHEN LEN(ISNULL(SD.Code10,''''))>0 THEN SD.Code10 ELSE SD.Code9 END AS Code
				FROM cteSuperbillProcedureDiagnosis VSPD
					INNER JOIN SuperbillDiagnosis SD ON VSPD.SuperbillDiagnosisUid = SD.SuperbillDiagnosisUid
					WHERE VSPD.SuperbillProcedureUid = @superbillProcedureUid
					ORDER BY VSPD.SuperbillProcedureUid, VSPD.DisplayOrder
	)
	SELECT	@diagnosisCodeList = COALESCE(@diagnosisCodeList+'','' ,'''') + Code
	FROM	cteSuperbillProcedureInfo;
	
	RETURN @diagnosisCodeList;
END


' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetDisplayOrder]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetDisplayOrder](@displayOrder [int], @kdbItemNode [nvarchar](255), @clinicCenterUid [uniqueidentifier], @providerUid [uniqueidentifier], @kdbClinicCenter [xml], @kdbProvider [xml])
RETURNS [int] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[GetDisplayOrder]' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SplitCLR]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[SplitCLR](@parameters [nvarchar](max), @delimiter [nchar](1))
RETURNS  TABLE (
	[Parameter] [nvarchar](4000) COLLATE SQL_Latin1_General_CP1_CI_AS NULL
) WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[SplitCLR]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetDocumentBatchMeasure]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetDocumentBatchMeasure](@reportParametersXml XML) RETURNS VARCHAR(1000) AS
BEGIN
	DECLARE @measureUids VARCHAR(MAX) = @reportParametersXml.value(''(/parameters/MeasureUid)[1]'', ''VARCHAR(MAX)'')
	DECLARE @measures VARCHAR(1000) = ''''
	DECLARE @cqmUid UNIQUEIDENTIFIER
	DECLARE @externalID VARCHAR(25)
	DECLARE @cms VARCHAR(255)

	DECLARE cur CURSOR READ_ONLY FOR
		SELECT	c.CQMUid, c.ExternalID, c.CMS
		FROM	dbo.SplitCLR(@measureUids, '','') s INNER JOIN ListCQM c ON CAST(s.Parameter AS UNIQUEIDENTIFIER) = c.CQMUid
	OPEN cur

	FETCH NEXT FROM cur INTO @cqmUid, @externalID, @cms
	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @measures = @measures + '' '' + @cms

		FETCH NEXT FROM cur INTO @cqmUid, @externalID, @cms
	END
	CLOSE cur
	DEALLOCATE cur

	RETURN RTRIM(@measures)
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SplitList]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[SplitList] (@list VARCHAR(MAX), @separator VARCHAR(MAX) = '','')  
RETURNS @table TABLE   
(  
	Value VARCHAR(MAX))AS   
	BEGIN     
		DECLARE @position INT,   
		@previous INT     
		SET @list = @list + @separator     
		SET @previous = 1     
		SET @position = CHARINDEX(@separator, @list)     
		WHILE @position > 0   
			BEGIN        
			IF @position - @previous > 0           
				INSERT INTO @table VALUES (SUBSTRING(@list, @previous, @position - @previous))        
				IF @position >= LEN(@list)   
					BREAK        
			SET @previous = @position + 1        
			SET @position = CHARINDEX(@separator, @list, @previous)     
		END     
	RETURN  
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetFaxDocumentNames]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetFaxDocumentNames] (@list VARCHAR(MAX), @separator VARCHAR(MAX) = '','')  RETURNS VARCHAR(MAX)
AS
BEGIN

	--Bug #17783	Track Fax. Sent documents are listed by attachment group name not the individual document name
/*	DECLARE @Names VARCHAR(max) 
	(select @Names = COALESCE(COALESCE(@Names + '';'', '''') + ag.Name, @Names)  from AttachmentGroup ag
			LEFT JOIN Attachment a ON a.AttachmentUid in (select Value FROM dbo.SplitList(@list, @separator))
			where a.AttachmentGroupUid = ag.AttachmentGroupUid) 
*/			
	DECLARE @Names VARCHAR(max) 
	(select @Names = COALESCE(COALESCE(@Names + '';'', '''') + a.filename+a.FileExtension, @Names)  from AttachmentGroup ag
			LEFT JOIN Attachment a ON a.AttachmentUid in (select Value FROM dbo.SplitList(@list, @separator))
			where a.AttachmentGroupUid = ag.AttachmentGroupUid) 
return @Names   

END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[StripNonNumeric]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[StripNonNumeric]
	(
		@s VARCHAR(100)
	)
RETURNS VARCHAR(100)
AS
BEGIN
    -- cmr usage:  SELECT dbo.StripNonNumeric(''(12-34%)xaaa'')
	DECLARE @i INT

	SET @i = PATINDEX(''%[^0-9]%'', @s)
	while @i > 0
	begin
		SET @s = replace(@s, substring(@s, @i, 1), '''')
		SET @i = patindex(''%[^0-9]%'', @s)
	end

	RETURN @s
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetPhoneFormatted]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetPhoneFormatted](@phone xml(CONTENT dbo.Phone)) RETURNS VARCHAR(255) AS
BEGIN
	IF @phone IS NULL
		RETURN NULL
		
	DECLARE @phonenumber VARCHAR(100)
	DECLARE @pt VARCHAR(255)
	
	SET @phonenumber = @phone.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(100)'')

	IF RTRIM(ISNULL(@phonenumber, '''')) = ''''
		RETURN NULL
					
	SET @phonenumber = dbo.StripNonNumeric(@phonenumber)
	IF DATALENGTH(@phonenumber) = 7
		SET @pt = SUBSTRING(@phonenumber, 1, 3) + ''-'' + SUBSTRING(@phonenumber, 4, 4)
	ELSE
	BEGIN
		SET @pt = ''('' + SUBSTRING(@phonenumber, 1, 3) + '') '' + SUBSTRING(@phonenumber, 4, 3) + ''-'' + SUBSTRING(@phonenumber, 7, 4)
	
		IF DATALENGTH(@phonenumber) > 10
			SET @pt = @pt + '' x'' + SUBSTRING(@phonenumber, 11, DATALENGTH(@phonenumber) - 11)
	END
	
	RETURN @pt
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetFaxPhone]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[GetFaxPhone](@phone1 xml(CONTENT dbo.Phone) = NULL, @phone2 xml(CONTENT dbo.Phone) = NULL, @phone3 xml(CONTENT dbo.Phone) = NULL, @phone4 xml(CONTENT dbo.Phone) = NULL) RETURNS VARCHAR(100) AS	
BEGIN
	DECLARE @Phonenumber VARCHAR(50)
	
	IF @phone1.value(''(/Phone/PhoneTypeUid)[1]'', ''VARCHAR(100)'') = ''48AF7137-1791-48E4-B338-3DD0A7419073''
		RETURN dbo.GetPhoneFormatted(@phone1)
	
	IF @phone2.value(''(/Phone/PhoneTypeUid)[1]'', ''VARCHAR(100)'') = ''48AF7137-1791-48E4-B338-3DD0A7419073''
		RETURN dbo.GetPhoneFormatted(@phone2)

	IF @phone3.value(''(/Phone/PhoneTypeUid)[1]'', ''VARCHAR(100)'') = ''48AF7137-1791-48E4-B338-3DD0A7419073''
		RETURN dbo.GetPhoneFormatted(@phone3)

	IF @phone4.value(''(/Phone/PhoneTypeUid)[1]'', ''VARCHAR(100)'') = ''48AF7137-1791-48E4-B338-3DD0A7419073''
		RETURN dbo.GetPhoneFormatted(@phone4)

	RETURN NULL
END




' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetFilterOverride]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetFilterOverride](@value [xml], @name [nvarchar](255), @uid [uniqueidentifier])
RETURNS [xml] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[GetFilterOverride]' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetFormattedPRMVersion]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetFormattedPRMVersion](@version [nvarchar](max))
RETURNS [nvarchar](max) WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[GetFormattedPRMVersion]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getFormatVaribleValue]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[getFormatVaribleValue]
(	
	@exportFormatGUID UNIQUEIDENTIFIER,
	@iProvider VARCHAR(50) = NULL
)RETURNS VARCHAR(255)
AS
BEGIN
	DECLARE @retVal VARCHAR(255)
	SELECT	@retVal = ISNULL(eClaimFormatValue.value, '''')	
	FROM ListClaimFormatValueType eListClaimFormatValueType
	LEFT JOIN ClaimFormatValue eClaimFormatValue ON	eClaimFormatValue.ClaimFormatValueTypeUid = eListClaimFormatValueType.ClaimFormatValueTypeUid AND
	(eClaimFormatValue.ProviderUid IS NOT NULL AND CONVERT(VARCHAR(50),eClaimFormatValue.ProviderUid) = @iProvider )
	WHERE	eListClaimFormatValueType.ClaimFormatValueTypeUid = @exportFormatGUID 
RETURN(@retVal)
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetFraminghamScore]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetFraminghamScore](@Age int,@Gender Varchar(2),@TC FLOAT,@Smoker VARCHAR(25),@HDL FLOAT,@BP FLOAT,@Treatment BIT) RETURNS int AS	
BEGIN

	DECLARE @FraminghamRisk INT
	
	Declare @AgeATP Table
	(
		minAge int,
		MaxAge int,
		Points int,
		Gender Varchar(2)
	)

	Insert into @AgeATP Values(20,34,-9,''M'')
	Insert into @AgeATP Values(35,39,-4,''M'')
	Insert into @AgeATP Values(40,44,0,''M'')
	Insert into @AgeATP Values(45,49,3,''M'')
	Insert into @AgeATP Values(50,54,6,''M'')
	Insert into @AgeATP Values(55,59,8,''M'')
	Insert into @AgeATP Values(60,64,10,''M'')
	Insert into @AgeATP Values(65,69,11,''M'')
	Insert into @AgeATP Values(70,74,12,''M'')
	Insert into @AgeATP Values(75,79,13,''M'')
	Insert into @AgeATP Values(20,34,-7,''F'')
	Insert into @AgeATP Values(35,39,-3,''F'')
	Insert into @AgeATP Values(40,44,0,''F'')
	Insert into @AgeATP Values(45,49,3,''F'')
	Insert into @AgeATP Values(50,54,6,''F'')
	Insert into @AgeATP Values(55,59,8,''F'')
	Insert into @AgeATP Values(60,64,10,''F'')
	Insert into @AgeATP Values(65,69,12,''F'')
	Insert into @AgeATP Values(70,74,14,''F'')
	Insert into @AgeATP Values(75,79,16,''F'')

	Declare @TotCholATP Table
	(
		MinChol int,
		MaxChol int,
		MinAge int,
		MaxAge int,
		Points int,
		Gender Varchar(2)
	)

	insert into @TotCholATP Values (0,159,20,39,0,''M'')
	insert into @TotCholATP Values (0,159,40,49,0,''M'')
	insert into @TotCholATP Values (0,159,50,59,0,''M'')
	insert into @TotCholATP Values (0,159,60,69,0,''M'')
	insert into @TotCholATP Values (0,159,70,79,0,''M'')
	insert into @TotCholATP Values (0,159,20,39,0,''F'')
	insert into @TotCholATP Values (0,159,40,49,0,''F'')
	insert into @TotCholATP Values (0,159,50,59,0,''F'')
	insert into @TotCholATP Values (0,159,60,69,0,''F'')
	insert into @TotCholATP Values (0,159,70,79,0,''F'')
	insert into @TotCholATP Values (160,199,20,39,4,''M'')
	insert into @TotCholATP Values (160,199,40,49,3,''M'')
	insert into @TotCholATP Values (160,199,50,59,2,''M'')
	insert into @TotCholATP Values (160,199,60,69,1,''M'')
	insert into @TotCholATP Values (160,199,70,79,0,''M'')
	insert into @TotCholATP Values (160,199,20,39,4,''F'')
	insert into @TotCholATP Values (160,199,40,49,3,''F'')
	insert into @TotCholATP Values (160,199,50,59,2,''F'')
	insert into @TotCholATP Values (160,199,60,69,1,''F'')
	insert into @TotCholATP Values (160,199,70,79,1,''F'')
	insert into @TotCholATP Values (200,239,20,39,7,''M'')
	insert into @TotCholATP Values (200,239,40,49,5,''M'')
	insert into @TotCholATP Values (200,239,50,59,3,''M'')
	insert into @TotCholATP Values (200,239,60,69,1,''M'')
	insert into @TotCholATP Values (200,239,70,79,0,''M'')
	insert into @TotCholATP Values (200,239,20,39,8,''F'')
	insert into @TotCholATP Values (200,239,40,49,6,''F'')
	insert into @TotCholATP Values (200,239,50,59,4,''F'')
	insert into @TotCholATP Values (200,239,60,69,2,''F'')
	insert into @TotCholATP Values (200,239,70,79,1,''F'')
	insert into @TotCholATP Values (240,279,20,39,9,''M'')
	insert into @TotCholATP Values (240,279,40,49,6,''M'')
	insert into @TotCholATP Values (240,279,50,59,4,''M'')
	insert into @TotCholATP Values (240,279,60,69,2,''M'')
	insert into @TotCholATP Values (240,279,70,79,1,''M'')
	insert into @TotCholATP Values (240,279,20,39,11,''F'')
	insert into @TotCholATP Values (240,279,40,49,8,''F'')
	insert into @TotCholATP Values (240,279,50,59,5,''F'')
	insert into @TotCholATP Values (240,279,60,69,3,''F'')
	insert into @TotCholATP Values (240,279,70,79,2,''F'')
	insert into @TotCholATP Values (280,9999,20,39,11,''M'')
	insert into @TotCholATP Values (280,9999,40,49,8,''M'')
	insert into @TotCholATP Values (280,9999,50,59,5,''M'')
	insert into @TotCholATP Values (280,9999,60,69,3,''M'')
	insert into @TotCholATP Values (280,9999,70,79,1,''M'')
	insert into @TotCholATP Values (280,9999,20,39,13,''F'')
	insert into @TotCholATP Values (280,9999,40,49,10,''F'')
	insert into @TotCholATP Values (280,9999,50,59,7,''F'')
	insert into @TotCholATP Values (280,9999,60,69,4,''F'')
	insert into @TotCholATP Values (280,9999,70,79,2,''F'')

	Declare @SmokerATP Table
	(
		Smoker Varchar(25),
		MinAge int,
		MaxAge int,
		Points int,
		Gender Varchar(2)
	)

	insert into @SmokerATP Values (''NonSmoker'',20,39,0,''M'')
	insert into @SmokerATP Values (''NonSmoker'',40,49,0,''M'')
	insert into @SmokerATP Values (''NonSmoker'',50,59,0,''M'')
	insert into @SmokerATP Values (''NonSmoker'',60,69,0,''M'')
	insert into @SmokerATP Values (''NonSmoker'',70,79,0,''M'')
	insert into @SmokerATP Values (''NonSmoker'',20,39,0,''F'')
	insert into @SmokerATP Values (''NonSmoker'',40,49,0,''F'')
	insert into @SmokerATP Values (''NonSmoker'',50,59,0,''F'')
	insert into @SmokerATP Values (''NonSmoker'',60,69,0,''F'')
	insert into @SmokerATP Values (''NonSmoker'',70,79,0,''F'')
	insert into @SmokerATP Values (''Smoker'',20,39,8,''M'')
	insert into @SmokerATP Values (''Smoker'',40,49,5,''M'')
	insert into @SmokerATP Values (''Smoker'',50,59,3,''M'')
	insert into @SmokerATP Values (''Smoker'',60,69,1,''M'')
	insert into @SmokerATP Values (''Smoker'',70,79,1,''M'')
	insert into @SmokerATP Values (''Smoker'',20,39,9,''F'')
	insert into @SmokerATP Values (''Smoker'',40,49,7,''F'')
	insert into @SmokerATP Values (''Smoker'',50,59,4,''F'')
	insert into @SmokerATP Values (''Smoker'',60,69,2,''F'')
	insert into @SmokerATP Values (''Smoker'',70,79,1,''F'')

	Declare @HDLATP Table
	(

		MinHDL int,
		MaxHDL int,
		Points int,
		Gender Varchar(2)
		
	)

	insert into @HDLATP Values (0,39,2,''M'')
	insert into @HDLATP Values (40,49,1,''M'')
	insert into @HDLATP Values (50,59,0,''M'')
	insert into @HDLATP Values (60,999,-1,''M'')
	insert into @HDLATP Values (0,39,2,''F'')
	insert into @HDLATP Values (40,49,1,''F'')
	insert into @HDLATP Values (50,59,0,''F'')
	insert into @HDLATP Values (60,999,-1,''F'')


	Declare @BpATP Table
	(
		MinBp int,
		MaxBp int,
		Points int,
		Gender Varchar(2),
		Treatment bit
	)

	insert into @BpATP Values (0,119,0,''M'',0)
	insert into @BpATP Values (120,129,0,''M'',0)
	insert into @BpATP Values (130,139,1,''M'',0)
	insert into @BpATP Values (140,159,1,''M'',0)
	insert into @BpATP Values (160,999,2,''M'',0)
	insert into @BpATP Values (0,129,0,''F'',0)	
	insert into @BpATP Values (120,129,1,''F'',0)
	insert into @BpATP Values (130,139,2,''F'',0)
	insert into @BpATP Values (140,159,3,''F'',0)
	insert into @BpATP Values (160,999,4,''F'',0)
	insert into @BpATP Values (0,119,0,''M'',1)
	insert into @BpATP Values (120,129,1,''M'',1)
	insert into @BpATP Values (130,139,2,''M'',1)
	insert into @BpATP Values (140,159,2,''M'',1)
	insert into @BpATP Values (160,999,3,''M'',1)
	insert into @BpATP Values (0,129,0,''F'',1)	
	insert into @BpATP Values (120,129,3,''F'',1)
	insert into @BpATP Values (130,139,4,''F'',1)
	insert into @BpATP Values (140,159,5,''F'',1)
	insert into @BpATP Values (160,999,6,''F'',1)


	Declare @ATP Table
	(
		Points int,
		Risk int,
		Gender Varchar(2)
	)

	insert into @ATP Values (0,1,''M'')
	insert into @ATP Values (1,1,''M'')
	insert into @ATP Values (2,1,''M'')
	insert into @ATP Values (3,1,''M'')
	insert into @ATP Values (4,1,''M'')
	insert into @ATP Values (5,2,''M'')
	insert into @ATP Values (6,2,''M'')
	insert into @ATP Values (7,3,''M'')
	insert into @ATP Values (8,4,''M'')
	insert into @ATP Values (9,5,''M'')
	insert into @ATP Values (10,6,''M'')
	insert into @ATP Values (11,8,''M'')
	insert into @ATP Values (12,10,''M'')
	insert into @ATP Values (13,12,''M'')
	insert into @ATP Values (14,16,''M'')
	insert into @ATP Values (15,20,''M'')
	insert into @ATP Values (16,25,''M'')
	insert into @ATP Values (9,1,''F'')
	insert into @ATP Values (10,1,''F'')
	insert into @ATP Values (11,1,''F'')
	insert into @ATP Values (12,1,''F'')
	insert into @ATP Values (13,2,''F'')
	insert into @ATP Values (14,2,''F'')
	insert into @ATP Values (15,3,''F'')
	insert into @ATP Values (16,4,''F'')
	insert into @ATP Values (17,5,''F'')
	insert into @ATP Values (18,6,''F'')
	insert into @ATP Values (19,8,''F'')
	insert into @ATP Values (20,11,''F'')
	insert into @ATP Values (21,14,''F'')
	insert into @ATP Values (22,17,''F'')
	insert into @ATP Values (23,22,''F'')
	insert into @ATP Values (24,27,''F'')
	insert into @ATP Values (25,30,''F'')

--	Select * from @AgeATP
--	Select * from @TotCholATP
--	Select * from @SmokerATP
--	Select * from @HDLATP
--	Select * from @BpATP
--	Select * from @ATP
	--@Age int,@Gender Varchar(2),@TC FLOAT,@Smoker bit,@HDL FLOAT,@BP FLOAT
	Declare @ATPscore INT
	SET @ATPscore=0
	SELECT  @ATPscore=@ATPscore + Points FROM @AgeATP	  WHERE Gender=@Gender AND (minAge<=@Age AND MaxAge>=@Age)
	SELECT  @ATPscore=@ATPscore + Points FROM @TotCholATP WHERE Gender=@Gender AND (minAge<=@Age AND MaxAge>=@Age) AND (MinChol<=@TC AND MaxChol>=@TC)
	SELECT  @ATPscore=@ATPscore + Points FROM @SmokerATP  WHERE Gender=@Gender AND (minAge<=@Age AND MaxAge>=@Age) AND Smoker=@Smoker
	SELECT  @ATPscore=@ATPscore + Points FROM @HDLATP  WHERE Gender=@Gender AND (MinHDL<=@HDL AND MaxHDL>=@HDL) 
	SELECT  @ATPscore=@ATPscore + Points FROM @BpATP  WHERE Gender=@Gender AND (MinBP<=@BP AND MaxBp>=@BP) AND Treatment=@Treatment 
	
	---- Declare @ATP Table
	----(
	----	Points int,
	----	Risk int,
	----	Gender Varchar(2)
	--)
	
	IF (@Gender=''M'' and @ATPscore>16)
	BEGIN
		SET @FraminghamRisk=30
	END
	ELSE
	BEGIN
		SELECT @FraminghamRisk=Risk FROM @ATP WHERE Gender=''M'' AND Points=@ATPscore
	END
	
	IF (@Gender=''F'' and @ATPscore>24)
	BEGIN
		SET @FraminghamRisk=30
	END
	ELSE
	BEGIN
		SELECT @FraminghamRisk=Risk FROM @ATP WHERE Gender=''F'' AND Points=@ATPscore
	END
		
	RETURN @FraminghamRisk	

END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetGroupList_SR]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE Function [dbo].[GetGroupList_SR](@UID uniqueidentifier)
Returns Varchar(2000)
AS
Begin
	Declare @Group Varchar(2000)
	Set @Group=null

	SELECT	
			@Group= COALESCE(@Group + '', '','''') + L.Name
	FROM	ListUserGroup	L
	join
			UserGroupMember ugm 
	on
			L.UserGroupuid=ugm.UserGroupUId
	CROSS JOIN 
			ViewFindUserAndUserGroup fuug
	WHERE	(ugm.MemberUserUID = @UID  OR ugm.MemberUserGroupUid=@UID)AND
			((ugm.MemberUserUid = fuug.Uid AND fuug.ForeignKeyIndex = 1) OR
			(ugm.MemberUserGroupUid = fuug.Uid AND fuug.ForeignKeyIndex = 2))
	Order by L.Name	

	Return @Group
End


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetHCCCommuityFactors]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetHCCCommuityFactors](@code9 VARCHAR(6), @code10 VARCHAR(10)) RETURNS DECIMAL(4,3) AS
BEGIN
	DECLARE @hcc DECIMAL(4,3)

	SELECT	@hcc= MAX(srb.HCCCommunityFactors)
	FROM	IMO_ProblemIT_SearchResult_Base srb
	WHERE	srb.Code09 = @code9 AND
			srb.Code10 = @code10

	RETURN @hcc
END
' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetHideFlag]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetHideFlag](@kdbItemNode [nvarchar](255), @clinicCenterUid [uniqueidentifier], @providerUid [uniqueidentifier], @kdbClinicCenter [xml], @kdbProvider [xml])
RETURNS [bit] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[GetHideFlag]' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[StringToDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[StringToDate](@answer [nvarchar](255))
RETURNS [datetime] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[StringToDate]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetHistoryDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetHistoryDate](@patientUid UNIQUEIDENTIFIER, @question VARCHAR(100)) RETURNS DATE AS BEGIN
	DECLARE @date DATE
	SELECT	@date = dbo.StringToDate(phd.AnswerName)
	FROM	PatientHistory ph INNER JOIN PatientHistoryDetail phd ON ph.PatientHistoryUid = phd.PatientHistoryUid
	WHERE	phd.QuestionUid IN (SELECT QuestionUid FROM ListQuestion WHERE Name LIKE ''%'' + @question + ''%'')
			AND ph.InactiveDate IS NULL
			AND ph.PatientUid = @patientUid
			AND dbo.StringToDate(phd.AnswerName) IS NOT NULL

	RETURN	@date
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetHospitalRoundNames]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetHospitalRoundNames](@hospitalRoundUid uniqueidentifier, @provider bit) 
RETURNS VARCHAR(MAX) AS
BEGIN
	DECLARE @names VARCHAR(MAX)	
	
	IF @provider <> 0
		SELECT	@names = CASE WHEN @names IS NULL THEN '''' ELSE @names + '';'' END + 
				dbo.UDF_GetFormattedInternalName(p.FirstName, p.MiddleName, p.LastName, p.AkaFirstName, p.AkaLastName)
		FROM	RelHospitalRoundProvider rel INNER JOIN ViewProvider p ON rel.ProviderUid = p.PersonUid
		WHERE	rel.HospitalRoundUid = @hospitalRoundUid	
	ELSE	
		SELECT	@names = CASE WHEN @names IS NULL THEN '''' ELSE @names + '';'' END + dbo.GetDiagnosisCodeAndName(rel.Code9, rel.Code10, rel.CodeDescription)
		FROM	RelHospitalRoundDiagnosis rel
		WHERE	rel.HospitalRoundUid = @hospitalRoundUid
		
	RETURN @names
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetHospitalRoundNamesWithID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetHospitalRoundNamesWithID](@hospitalRoundUid uniqueidentifier, @provider bit) 
RETURNS VARCHAR(MAX) AS
BEGIN
	DECLARE @names VARCHAR(MAX)	
	
	IF @provider <> 0
		SELECT	@names = CASE WHEN @names IS NULL THEN '''' ELSE @names + '', '' END + dbo.UDF_GetFormattedInternalName(p.FirstName, p.MiddleName, p.LastName, p.AkaFirstName, p.AkaLastName)
		FROM	RelHospitalRoundProvider rel INNER JOIN ViewProvider p ON rel.ProviderUid = p.PersonUid
		WHERE	rel.HospitalRoundUid = @hospitalRoundUid	
	ELSE	
		SELECT	@names = CASE WHEN @names IS NULL THEN '''' ELSE @names + '', '' END + 		COALESCE(code10, code9) + '' '' + CodeDescription 
		FROM	RelHospitalRoundDiagnosis rel --INNER JOIN VisitDiagnosis vd ON rel.DiagnosisUid = vd.DiagnosisUid
		WHERE	rel.HospitalRoundUid = @hospitalRoundUid
		
	RETURN @names
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetHospitalRounds]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[GetHospitalRounds]
()
RETURNS @retTable TABLE 
(
	HospitalRoundUid UniqueIdentifier,
	ServiceSiteName varchar(255),
	ServiceSiteUid uniqueidentifier,
	PatientName varchar(255),
	PatientUid uniqueidentifier,
	Location varchar(255),
	AdmitDate datetime,
	DischargeDate datetime,
	Notes text,
	ProviderNames varchar(1000),
	ProviderUids varchar(1000),
	DiagnosisNames varchar(1000),
	DiagnosisCodes varchar(1000),
	Inactive bit
)
AS
	BEGIN
	-- Get all data except provider stuff
		insert into @retTable
		select 
			hr.HospitalRoundUid, ss.Name as ServiceSiteName,
			hr.ServiceSiteUid, p.LastName + '', '' + p.FirstName AS PatientName,
			PatientUid, Location, AdmitDate, DischargeDate,  hr.Notes,
			null, null, null, null, hr.Inactive
		from hospitalround hr
		inner join ListServiceSite ss on ss.ServiceSiteUid = hr.ServiceSiteUid
		inner join Person p on p.PersonUid = hr.PatientUid

	-- Now get the providers
	declare @curId uniqueidentifier
	select top 1 @curid = HospitalRoundUid from @retTable order by HospitalRoundUid

	while ( @curId is not null )
	begin
		declare @Names varchar(1000)
		declare @UidsOrCodes varchar(1000)
		set @Names = '''' 
		set @UidsOrCodes = ''''

	-- Provider info
		select @Names = @Names + dbo.UDF_getFormattedInternalName(firstname, middlename, lastname, akafirstname, akalastname) + ''; '',
		@UidsOrCodes = @UidsOrCodes + cast(ProviderUid as varchar(36)) + '';''
		from HospitalRound hr
		inner join RelHospitalRoundProvider rhrpv on rhrpv.HospitalRoundUid = @curId 
		inner join viewprovider vp on vp.personuid = rhrpv.ProviderUid
		where hr.HospitalRoundUid = @curid

		IF (len(@Names) > 0)
			SET @Names = left(@Names, len(@names) - 1)

		update @retTable
		set ProviderNames = @Names, ProviderUids = @UidsOrCodes
		where HospitalRoundUid = @curid and @names <> ''''

	-- Diagnosis names
		set @Names = '''' 
		set @UidsOrCodes = ''''

		select @Names = @Names + rhrd.CodeDescription + '' ('' + coalesce(rhrd.Code9, rhrd.Code10) + ''); '',
		@UidsOrCodes = @UidsOrCodes + cast(rhrd.Code9 as varchar(36)) + '';''
		from HospitalRound hr
		inner join RelHospitalRoundDiagnosis rhrd on rhrd.HospitalRoundUid = @curId 
		where hr.HospitalRoundUid = @curid

		IF (len(@Names) > 0)
			SET @Names = left(@Names, len(@names) - 1)

		update @retTable
		set DiagnosisNames = @Names, DiagnosisCodes = @UidsOrCodes
		where HospitalRoundUid = @curid and @names <> ''''

		-- advance to the next one
		select top 1 @curid = HospitalRoundUid from @retTable where HospitalRoundUid > @curid order by HospitalRoundUid 
		if @@rowcount = 0  set @curid = null
	end
	return 
END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetHospitalRoundSpecificUids]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[GetHospitalRoundSpecificUids](@hospitalRoundUid uniqueidentifier, @provider bit,@provideruid Varchar(max)=Null) 
RETURNS VARCHAR(MAX) AS
BEGIN
	DECLARE	@uidsOrCodes VARCHAR(MAX)
		
	IF @provider <> 0
		SELECT	@uidsOrCodes = CASE WHEN @uidsOrCodes IS NULL THEN '''' ELSE @uidsOrCodes + '';'' END + CONVERT(VARCHAR(36), rel.ProviderUid)
		FROM	RelHospitalRoundProvider rel 
		WHERE	rel.HospitalRoundUid = @hospitalRoundUid
		and (@provideruid is null OR rel.ProviderUid in (Select Element From dbo.Split (@provideruid,'','')))
	ELSE
		SELECT	@uidsOrCodes = CASE WHEN @uidsOrCodes IS NULL THEN '''' ELSE @uidsOrCodes + '';'' END + CONVERT(VARCHAR(36), rel.Code9)
		FROM	RelHospitalRoundDiagnosis rel 
		WHERE	rel.HospitalRoundUid = @hospitalRoundUid
	
	
	RETURN @uidsOrCodes
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetHospitalRoundUids]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetHospitalRoundUids](@hospitalRoundUid uniqueidentifier, @provider bit) 
RETURNS VARCHAR(MAX) AS
BEGIN
	DECLARE	@uidsOrCodes VARCHAR(MAX)
		
	IF @provider <> 0
		SELECT	@uidsOrCodes = CASE WHEN @uidsOrCodes IS NULL THEN '''' ELSE @uidsOrCodes + '';'' END + CONVERT(VARCHAR(36), rel.ProviderUid)
		FROM	RelHospitalRoundProvider rel 
		WHERE	rel.HospitalRoundUid = @hospitalRoundUid
	ELSE
		SELECT	@uidsOrCodes = CASE WHEN @uidsOrCodes IS NULL THEN '''' ELSE @uidsOrCodes + '';'' END + CONVERT(VARCHAR(36), rel.Code9)
		FROM	RelHospitalRoundDiagnosis rel 
		WHERE	rel.HospitalRoundUid = @hospitalRoundUid
	
	
	RETURN @uidsOrCodes
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetIndexColumns]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetIndexColumns]
(
	@object_id int,
	@index_id int
) RETURNS  VARCHAR(MAX) AS 
BEGIN 
		DECLARE @Columns VARCHAR(MAX)
		
		SELECT	@Columns = COALESCE(@Columns + '', '', '''') + c.Name
		FROM	sys.index_columns ic INNER JOIN sys.columns c ON ic.object_id = c.object_id AND ic.column_id = c.column_id
		WHERE   ic.object_id = @object_id AND
				ic.index_id = @index_id AND
				ic.is_included_column = 0
		RETURN @Columns
END

' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetKdbOverrideValue]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetKdbOverrideValue](@uid [uniqueidentifier], @kdbItemNode [nvarchar](255), @kdb [xml], @attributeName [nvarchar](max))
RETURNS [nvarchar](max) WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[GetKdbOverrideValue]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetLastObservationValue]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetLastObservationValue](@patientUid UNIQUEIDENTIFIER, @observationItemUid UNIQUEIDENTIFIER, @startDate DATE, @endDate DATE, @valueType TINYINT = 0) RETURNS VARCHAR(100) AS
BEGIN
	DECLARE @result VARCHAR(100)
	
	SELECT TOP 1	@result =	CASE @valueType
								WHEN 1 THEN
									CAST(ov.MetricValue1 AS VARCHAR(100))
								WHEN 2 THEN
									CAST(ov.MetricValue2 AS VARCHAR(100))
								WHEN 10 THEN
									CONVERT(VARCHAR(100), COALESCE(oo.ResultDate, oo.PerformDate), 101)
								ELSE
									CAST(ov.ObservationValue AS VARCHAR(100))
								END
	FROM			ObservationOrder oo INNER JOIN ObservationValue ov ON oo.ObservationOrderUid = ov.ObservationOrderUid
	WHERE			ov.ObservationItemUid = @observationItemUid AND
					oo.PatientUid = @patientUid AND
					(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) >= @startDate OR @startDate IS NULL) AND
					(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE)<= @endDate OR @endDate IS NULL)
	ORDER BY		COALESCE(oo.ResultDate, oo.PerformDate) DESC

	RETURN			@result
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetLastObservationValueByName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetLastObservationValueByName](@patientUid UNIQUEIDENTIFIER, @observationName VARCHAR(100), @startDate DATE, @endDate DATE, @valueType TINYINT = 0) RETURNS VARCHAR(100) AS
BEGIN
	DECLARE @result VARCHAR(100)
	
	DECLARE cur CURSOR FOR 
		SELECT			CASE @valueType
									WHEN 1 THEN
										CAST(ov.MetricValue1 AS VARCHAR(100))
									WHEN 2 THEN
										CAST(ov.MetricValue2 AS VARCHAR(100))
									WHEN 10 THEN
										CONVERT(VARCHAR(100), COALESCE(oo.ResultDate, oo.PerformDate), 101)
									ELSE
										CAST(ov.ObservationValue AS VARCHAR(100))
									END
		FROM			ObservationOrder oo INNER JOIN ObservationValue ov ON oo.ObservationOrderUid = ov.ObservationOrderUid
						INNER JOIN ListObservationItem oi ON ov.ObservationItemUid = oi.ObservationItemUid
		WHERE			oi.Name LIKE @observationName AND
						oo.PatientUid = @patientUid AND
						(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) >= @startDate OR @startDate IS NULL) AND
						(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE)<= @endDate OR @endDate IS NULL)
		ORDER BY		oo.ResultDate DESC

	OPEN cur
	FETCH NEXT FROM cur INTO @result
	WHILE @@FETCH_STATUS = 0
	BEGIN
		IF @result IS NOT NULL AND RTRIM(@result) <> ''''
			RETURN @result
		
		FETCH NEXT FROM cur INTO @result
	END
	
	RETURN @result
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetLastObservationValueTable]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetLastObservationValueTable](@patientUid UNIQUEIDENTIFIER, @observationName VARCHAR(100), @startDate DATE, @endDate DATE, @sortType smallint)
	RETURNS @Observation TABLE 
	(
		PatientUid UNIQUEIDENTIFIER,
		ObservationDate DATE,
		ObservationValue VARCHAR(100)
	)
AS
BEGIN
	IF @sortType = 1
			INSERT			@Observation
			SELECT TOP 1	t.PatientUid, t.ObservationDate, t.ObservationValue
			FROM			(	SELECT	@patientUid AS PatientUid, ov.ObservationValueUid,
										CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) AS ObservationDate,
										CAST(ov.ObservationValue AS VARCHAR(100)) AS ObservationValue
								FROM	ObservationOrder oo INNER JOIN ObservationValue ov ON oo.ObservationOrderUid = ov.ObservationOrderUid
										INNER JOIN ListObservationItem oi ON ov.ObservationItemUid = oi.ObservationItemUid
								WHERE	oi.Name LIKE @observationName AND
										oo.PatientUid = @patientUid AND
										(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) >= @startDate OR @startDate IS NULL) AND
										(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) <= @endDate OR @endDate IS NULL) AND
										ov.ObservationValue IS NOT NULL AND
										RTRIM(CAST(ov.ObservationValue AS VARCHAR(100))) <> '''' AND
										ISNUMERIC(CAST(ov.ObservationValue AS VARCHAR(100))) = 1) t	
			ORDER BY		CAST(t.ObservationValue AS MONEY), t.ObservationDate DESC
	ELSE IF @sortType = 2
			INSERT			@Observation
			SELECT TOP 1	t.PatientUid, t.ObservationDate, t.ObservationValue
			FROM			(	SELECT	@patientUid AS PatientUid, ov.ObservationValueUid,
										CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) AS ObservationDate,
										CAST(ov.ObservationValue AS VARCHAR(100)) AS ObservationValue
								FROM	ObservationOrder oo INNER JOIN ObservationValue ov ON oo.ObservationOrderUid = ov.ObservationOrderUid
										INNER JOIN ListObservationItem oi ON ov.ObservationItemUid = oi.ObservationItemUid
								WHERE	oi.Name LIKE @observationName AND
										oo.PatientUid = @patientUid AND
										(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) >= @startDate OR @startDate IS NULL) AND
										(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) <= @endDate OR @endDate IS NULL) AND
										ov.ObservationValue IS NOT NULL AND
										RTRIM(CAST(ov.ObservationValue AS VARCHAR(100))) <> '''' AND
										ISNUMERIC(CAST(ov.ObservationValue AS VARCHAR(100))) = 1) t	
			ORDER BY		CAST(t.ObservationValue AS MONEY) DESC, t.ObservationDate DESC
	ELSE
			INSERT			@Observation
			SELECT TOP 1	@patientUid, CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) AS ObservationDate,
							ov.ObservationValue							
			FROM			ObservationOrder oo INNER JOIN ObservationValue ov ON oo.ObservationOrderUid = ov.ObservationOrderUid
							INNER JOIN ListObservationItem oi ON ov.ObservationItemUid = oi.ObservationItemUid
			WHERE			oi.Name LIKE @observationName AND
							oo.PatientUid = @patientUid AND
							(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE) >= @startDate OR @startDate IS NULL) AND
							(CAST(COALESCE(oo.ResultDate, oo.PerformDate) AS DATE)<= @endDate OR @endDate IS NULL) AND
							ov.ObservationValue IS NOT NULL AND
							RTRIM(CAST(ov.ObservationValue AS VARCHAR(MAX))) <> ''''
			ORDER BY		COALESCE(oo.ResultDate, oo.PerformDate) DESC
	RETURN 
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetLastStatementDatesForAccountResponsiblePartyWithAggregateOption]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[GetLastStatementDatesForAccountResponsiblePartyWithAggregateOption](@accountResponsbilePartyUids VARCHAR(MAX), @financialCenterUids VARCHAR(MAX), @aggregateMultpleFinancialCentersTogether BIT = 0)
RETURNS @retTable TABLE 
(
    AccountResponsiblePartyUid UNIQUEIDENTIFIER,
	FinancialCenterUid UNIQUEIDENTIFIER,
	LastStatementDate DATE,
	BatchComplete BIT
)
AS
BEGIN

WITH cteStatementsByFinancialCenter AS -- get practice settings
(
	SELECT TOP 1  PS.StatementsByFinancialCenter 
		FROM PracticeSettings PS
), cteARP AS -- get AccountResponsiblePartyUid list, either all if none specified 
(
	SELECT DISTINCT CAST(SARP.Element AS UNIQUEIDENTIFIER) AS AccountResponsiblePartyUid  
		FROM dbo.Split(@accountResponsbilePartyUids, '';'')  SARP
			INNER JOIN AccountResponsibleParty ARP ON CAST(SARP.Element AS UNIQUEIDENTIFIER) = ARP.AccountResponsiblePartyUid
	UNION
	SELECT AccountResponsiblePartyUid FROM AccountResponsibleParty WHERE @accountResponsbilePartyUids IS NULL
), cteFC AS -- get FinancialCenterUid list, either all if none specified 
(
	SELECT DISTINCT CAST(Element AS UNIQUEIDENTIFIER) AS FinancialCenterUid  
		FROM dbo.Split(@financialCenterUids, '';'') SFC
			INNER JOIN FinancialCenter FC ON CAST(SFC.Element AS UNIQUEIDENTIFIER) = FC.FinancialCenterUid

	UNION
	SELECT FinancialCenterUid  FROM FinancialCenter WHERE @financialCenterUids IS NULL
), cteStatementBatchDetailData AS
(
 SELECT SBD.AccountResponsiblePartyUid, SBD.FinancialCenterUid,  SBD.StatementDate, SBD.LastModifiedDate, 
		CAST(CASE WHEN (NOT SBDWATCH.StatementBatchUid IS NULL) THEN 1 ELSE 0 END AS BIT) AS BatchComplete 
	FROM StatementBatchDetail SBD WITH (NOLOCK) 
		INNER JOIN StatementBatch SB WITH (NOLOCK) ON SBD.StatementBatchUid = SB.StatementBatchUid 
			LEFT JOIN (SELECT DISTINCT StatementBatchUid FROM StatementBatchDetail  WHERE NOT AttachmentUid IS NULL) SBDWATCH ON SBD.StatementBatchUid = SBDWATCH.StatementBatchUid 
			INNER JOIN cteStatementsByFinancialCenter SBFC ON (1=1) -- will always have one record
			INNER JOIN cteARP ARPF ON SBD.AccountResponsiblePartyUid = ARPF.AccountResponsiblePartyUid
			LEFT JOIN cteFC FCF ON SBD.FinancialCenterUid = FCF.FinancialCenterUid
	WHERE (NOT SB.StatementActionUid = ''A88F5A75-0AD5-4C90-B006-8A007A7FA13C'') 
		AND ((SBFC.StatementsByFinancialCenter = 0 AND SBD.FinancialCenterUid IS NULL) 
			OR (SBFC.StatementsByFinancialCenter = 1 AND NOT FCF.FinancialCenterUid IS NULL))
), cteFilteredByBatch AS
(
	SELECT DISTINCT AccountResponsiblePartyUid, FinancialCenterUid,
			CASE WHEN BatchComplete = 0 THEN LastModifiedDate ELSE StatementDate END AS StatementDate,  BatchComplete
		FROM cteStatementBatchDetailData A
		WHERE (BatchComplete = 1 AND NOT StatementDate IS NULL) OR (Batchcomplete = 0)
), cteArpOldData AS
(
	SELECT DISTINCT ARP.AccountResponsiblePartyUid, NULL AS FinancialCenterUid,
			ARP.LastStatementDate AS StatementDate, CAST(1 AS BIT) AS BatchComplete
		FROM AccountResponsibleParty ARP  
			INNER JOIN cteStatementsByFinancialCenter SBFC ON (1=1) -- will always have one record
			INNER JOIN cteARP ARPF ON ARP.AccountResponsiblePartyUid = ARPF.AccountResponsiblePartyUid
		WHERE (SBFC.StatementsByFinancialCenter = 0) -- this is an ARP ONLY record
), cteArpFCCover AS -- we have no ARPFC set like ARP only above - creating FAKE data here 
(
	SELECT DISTINCT ARPF.AccountResponsiblePartyUid, FCF.FinancialCenterUid,
			NULL AS StatementDate, CAST(1 AS BIT) AS BatchComplete
		FROM cteARP ARPF 
			INNER JOIN cteStatementsByFinancialCenter SBFC ON (1=1) -- will always have one record
			INNER JOIN cteFC FCF ON (1=1) -- gets me a CROSS JOIN
		WHERE (SBFC.StatementsByFinancialCenter = 1) -- these are FC ONLY records
), cteArpFcOldData AS
(
	SELECT DISTINCT ARPFC.AccountResponsiblePartyUid, ARPFC.FinancialCenterUid,
			ARPFC.LastStatementDate AS StatementDate, CAST(1 AS BIT) AS BatchComplete
		FROM RelAccountResponsiblePartyFinancialCenter ARPFC
			INNER JOIN cteStatementsByFinancialCenter SBFC ON (1=1) -- will always have one record
			INNER JOIN cteARP ARPF ON ARPFC.AccountResponsiblePartyUid = ARPF.AccountResponsiblePartyUid
			INNER JOIN cteFC FCF ON (ARPFC.FinancialCenterUid = FCF.FinancialCenterUid) -- limits by FC list
		WHERE (SBFC.StatementsByFinancialCenter = 1) -- this is an FC ONLY record
), cteUnionAll AS
(
	SELECT * FROM cteFilteredByBatch
		UNION 
	SELECT * FROM cteArpOldData
		UNION 
	SELECT * FROM cteArpFcOldData
		UNION 
	SELECT * FROM cteArpFCCover
), cteSbdWithRowNumsSQL AS
(
	SELECT SBD.AccountResponsiblePartyUid, SBD.FinancialCenterUid, SBD.StatementDate, 
			ROW_NUMBER() OVER (PARTITION BY SBD.AccountResponsiblePartyUid, SBD.FinancialCenterUid
				ORDER BY SBD.StatementDate DESC) AS ROWNUMWFC, 
			ROW_NUMBER() OVER (PARTITION BY SBD.AccountResponsiblePartyUid
				ORDER BY SBD.StatementDate DESC) AS ROWNUMWOFC, 
			SBD.BatchComplete  --  @aggregateMultpleFinancialCentersTogether
		FROM cteUnionAll SBD
), cteHistoricalLastStatementDateSQL AS
(
	SELECT RN.AccountResponsiblePartyUid, 
		CASE WHEN @aggregateMultpleFinancialCentersTogether = 0 THEN RN.FinancialCenterUid ELSE NULL END AS FinancialCenterUid, 
		RN.StatementDate AS LastStatementDate, RN.BatchComplete
		FROM cteSbdWithRowNumsSQL RN 
		WHERE (@aggregateMultpleFinancialCentersTogether = 0 AND ROWNUMWFC = 1)
			OR (@aggregateMultpleFinancialCentersTogether = 1 AND ROWNUMWOFC = 1)
)
INSERT INTO @retTable (AccountResponsiblePartyUid, FinancialCenterUid, LastStatementDate, BatchComplete)
SELECT DISTINCT HLSD.*
	FROM cteHistoricalLastStatementDateSQL HLSD;
	 
	RETURN;

END
















' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetLastStatementDatesForAccountResponsibleParty]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[GetLastStatementDatesForAccountResponsibleParty](@accountResponsbilePartyUids VARCHAR(MAX), @financialCenterUids VARCHAR(MAX))
RETURNS @retTable TABLE 
(
    AccountResponsiblePartyUid UNIQUEIDENTIFIER,
	FinancialCenterUid UNIQUEIDENTIFIER,
	LastStatementDate DATE,
	BatchComplete BIT
)
AS
BEGIN

	INSERT INTO @retTable (AccountResponsiblePartyUid, FinancialCenterUid, LastStatementDate, BatchComplete)
	SELECT *
		FROM GetLastStatementDatesForAccountResponsiblePartyWithAggregateOption(@accountResponsbilePartyUids, @financialCenterUids, 0);
	 
	RETURN;

END
















' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetMappedDiagnosis]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
/* Pancratius 01/07/2014: Changed listdiagnosis.diagnosisCode9 to visitDiagnosis.code and commented out listdiagnosis table
Pancratius 03/06/2014: Add ISNULL function to to the visitdiagnosis.code and visitdiagnosis.code10
select
code + '', '' + coalesce(code10,'' '') from visitdiagnosis
20150518 kc add UseICD10 parameter
20150901 kc add else clause to handle labs without HL7 partners. 
*/

CREATE FUNCTION [dbo].[GetMappedDiagnosis](@ProcedureUid uniqueidentifier, @ImedicaAccessionNumber VARCHAR(50),@UseICD10 bit)  
RETURNS VARCHAR(MAX) AS  
BEGIN  
   DECLARE @Diag VARCHAR(MAX)  
   SET @Diag = ''''  
  
   --SELECT @Diag=@Diag + Coalesce(VisitDiagnosis.Code,'' '')+'', ''+Coalesce(VisitDiagnosis.Code10,'' '') + '', ''  
   IF (@UseICD10 = 1) 
   BEGIN
          SELECT @Diag = @Diag + Coalesce(VisitDiagnosis.Code10, VisitDiagnosis.Code) + '', ''
          FROM ObservationOrder  
          INNER JOIN VisitProcedure ON VisitProcedure.VisitProcedureUid = ObservationOrder.VisitProcedureUid  
          INNER JOIN VisitProcedureDiagnosis ON VisitProcedureDiagnosis.VisitProcedureUid = VisitProcedure.VisitProcedureUid  
          INNER JOIN VisitDiagnosis ON VisitProcedureDiagnosis.VisitDiagnosisUid = VisitDiagnosis.VisitDiagnosisUid  
          WHERE ObservationOrder.ImedicaAccessionNumber = @ImedicaAccessionNumber  
               AND VisitProcedure.ProcedureUid = @ProcedureUid  
               AND VisitProcedureDiagnosis.DisplayOrder<>0
          ORDER BY VisitDiagnosis.DisplayOrder  
   END
   ELSE If (@useICD10 = 0)--must be ICD9
   BEGIN
          SELECT @Diag = @Diag + Coalesce(VisitDiagnosis.Code,'' '') + '', ''
          FROM ObservationOrder  
          INNER JOIN VisitProcedure ON VisitProcedure.VisitProcedureUid = ObservationOrder.VisitProcedureUid  
          INNER JOIN VisitProcedureDiagnosis ON VisitProcedureDiagnosis.VisitProcedureUid = VisitProcedure.VisitProcedureUid  
          INNER JOIN VisitDiagnosis ON VisitProcedureDiagnosis.VisitDiagnosisUid = VisitDiagnosis.VisitDiagnosisUid  
          WHERE ObservationOrder.ImedicaAccessionNumber = @ImedicaAccessionNumber  
               AND VisitProcedure.ProcedureUid = @ProcedureUid  
               AND VisitProcedureDiagnosis.DisplayOrder<>0
          ORDER BY VisitDiagnosis.DisplayOrder  
   END
   Else if (@UseICD10 is Null) 
   BEGIN
          SELECT @DIAG = (CASE WHEN (VisitDiagnosis.Code is not null and VisitDiagnosis.Code10 is not null) 
				THEN @Diag + Coalesce(VisitDiagnosis.Code,'' '') +  ''/'' + Coalesce(VisitDiagnosis.Code10,'' '') + '', '' 
				ELSE CASE WHEN (VisitDiagnosis.Code is not null and VisitDiagnosis.Code10 is  null)
				THEN @Diag + Coalesce(VisitDiagnosis.Code,'' '') + '', '' 
				ELSE CASE WHEN (VisitDiagnosis.Code10 is not null and VisitDiagnosis.Code is  null)
				THEN @Diag + Coalesce(VisitDiagnosis.Code10,'' '') + '', '' 
				END
				END
			END )
          FROM ObservationOrder  
          INNER JOIN VisitProcedure ON VisitProcedure.VisitProcedureUid = ObservationOrder.VisitProcedureUid  
          INNER JOIN VisitProcedureDiagnosis ON VisitProcedureDiagnosis.VisitProcedureUid = VisitProcedure.VisitProcedureUid  
          INNER JOIN VisitDiagnosis ON VisitProcedureDiagnosis.VisitDiagnosisUid = VisitDiagnosis.VisitDiagnosisUid  
          WHERE ObservationOrder.ImedicaAccessionNumber = @ImedicaAccessionNumber  
               AND VisitProcedure.ProcedureUid = @ProcedureUid  
               AND VisitProcedureDiagnosis.DisplayOrder<>0
          ORDER BY VisitDiagnosis.DisplayOrder  
   END

       
   IF LEN(@Diag) >1  
      SET @Diag =SUBSTRING(@Diag,1,LEN(@Diag)-1)  
   RETURN @Diag  
END  
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getMaxDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[getMaxDate]
(
	@arg1 AS DATETIME,
	@arg2 AS DATETIME
)
RETURNS DATETIME
AS
BEGIN
	RETURN CASE
		WHEN @arg1 >= @arg2 or @arg2 is NULL THEN @arg1
		WHEN @arg2 > @arg1 or @arg1 is NULL THEN @arg2
		ELSE NULL
	END
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetMD5Hash]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetMD5Hash](@SourceString varchar(8000), @Modulo INT = 0)
	RETURNS INTEGER
AS
BEGIN
	IF @Modulo = 0
		RETURN CAST(HashBytes( ''MD5'', @SourceString) AS INTEGER)
	ELSE
		RETURN ABS(CAST(HashBytes( ''MD5'', @SourceString) AS INTEGER)) % @Modulo
	RETURN 0
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetMemberList_SR]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE Function [dbo].[GetMemberList_SR](@UID uniqueIdentifier)
Returns Varchar(2000)
AS
Begin
	Declare @List Varchar(2000)
	Set @List=null
	
	SELECT	
			@List=COALESCE(@List + '', '' , '''') + Replace(fuug.Name,'','','' '')
	FROM	UserGroupMember ugm CROSS JOIN ViewFindUserAndUserGroup fuug
	WHERE	ugm.UserGroupUid = @UID AND
			((ugm.MemberUserUid = fuug.Uid AND fuug.ForeignKeyIndex = 1) OR
			 (ugm.MemberUserGroupUid = fuug.Uid AND fuug.ForeignKeyIndex = 2))

	Return @List
End

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getFormattedPreferredName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE  FUNCTION [dbo].[UDF_getFormattedPreferredName]
(
        @PersonUid UNIQUEIDENTIFIER
)
RETURNS  VARCHAR(100)

AS
BEGIN

        DECLARE @PreferredName VARCHAR(100)

        SELECT @PreferredName = FormattedPreferredName
                
        FROM ViewPerson WHERE PersonUid = @PersonUid

        RETURN @PreferredName
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetMessageAssignedTo]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetMessageAssignedTo] (@messageUid uniqueidentifier) RETURNS VARCHAR(8000) AS
BEGIN
	DECLARE @assignedTo varchar(8000)
	DECLARE	@userUid uniqueidentifier
	DECLARE @userGroupUid uniqueidentifier

	SET @assignedTo = ''''
	
	DECLARE cur CURSOR FAST_FORWARD LOCAL FOR
		SELECT	UserUid, UserGroupUid FROM MessageUser WHERE MessageUid = @messageUid

	OPEN cur

	FETCH NEXT FROM cur INTO @userUid, @userGroupUid
	WHILE @@FETCH_STATUS = 0  
	BEGIN   
		IF @assignedTo <> ''''
			SET @assignedTo = @assignedTo + '';''
			
		IF NOT @userUid IS NULL
			SET @assignedTo = @assignedTo + RTRIM(dbo.UDF_getFormattedPreferredName(@userUid))
		ELSE
			SET @assignedTo = @assignedTo + RTRIM((SELECT [Name] FROM ListUserGroup WHERE UserGroupUid = @userGroupUid))

		FETCH NEXT FROM cur INTO @userUid, @userGroupUid
	END

	CLOSE cur
	DEALLOCATE cur

	RETURN @assignedTo
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetModifierForSuperbillProcedure]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetModifierForSuperbillProcedure]
(
	@SuperbillProcedureUID UniqueIdentifier
) Returns Varchar(1000)
AS
Begin
	Declare @Modifier Varchar(1000)
		
	SELECT 
		@Modifier= COALESCE(@Modifier + '', '','''') + LPM.Modifier 
	FROM
		SuperbillProcedureModifier SPM
	LEFT JOIN
		ListProcedureModifier LPM
	ON
		LPM.ProcedureModifierUID=SPM.ProcedureModifierUID
	WHERE
		SPM.SuperbillProcedureUID=@SuperbillProcedureUID
	ORDER BY
		SPM.DisplayOrder
	
	Return @Modifier
End

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetModifiers]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[GetModifiers]( @visitProcedureUid uniqueidentifier) RETURNS VARCHAR(100) AS 
	BEGIN
	
	DECLARE @modifiers varchar(100)
	DECLARE @modifier varchar(100)
	
	SELECT	@modifier = m1.ANSICode
	FROM	VisitProcedure vp LEFT JOIN ListProcedureModifier m1 ON vp.ProcedureModifier1Uid = m1.ProcedureModifierUid
	WHERE	vp.VisitProcedureUid = @visitProcedureUid
	
	IF NOT @modifier IS NULL
	BEGIN
		IF NOT @modifiers IS NULL
			SET @modifiers = @modifiers + '',''
		SET @modifiers = ISNULL(@modifiers,'''') + @modifier
	END
		
	SELECT	@modifier = m1.ANSICode
	FROM	VisitProcedure vp LEFT JOIN ListProcedureModifier m1 ON vp.ProcedureModifier2Uid = m1.ProcedureModifierUid
	WHERE	vp.VisitProcedureUid = @VisitProcedureUid
	
	IF NOT @modifier IS NULL
	BEGIN
		IF NOT @modifiers IS NULL
			SET @modifiers = @modifiers + '',''
		SET @modifiers = ISNULL(@modifiers,'''') + @modifier
	END

	SELECT	@modifier = m1.ANSICode
	FROM	VisitProcedure vp LEFT JOIN ListProcedureModifier m1 ON vp.ProcedureModifier3Uid = m1.ProcedureModifierUid
	WHERE	vp.VisitProcedureUid = @VisitProcedureUid
	
	IF NOT @modifier IS NULL
	BEGIN
		IF NOT @modifiers IS NULL
			SET @modifiers = @modifiers + '',''
		SET @modifiers = ISNULL(@modifiers,'''') + @modifier
	END

	SELECT	@modifier = m1.ANSICode
	FROM	VisitProcedure vp LEFT JOIN ListProcedureModifier m1 ON vp.ProcedureModifier4Uid = m1.ProcedureModifierUid
	WHERE	vp.VisitProcedureUid = @VisitProcedureUid
	
	IF NOT @modifier IS NULL
	BEGIN
		IF NOT @modifiers IS NULL
			SET @modifiers = @modifiers + '',''
		SET @modifiers = ISNULL(@modifiers,'''') + @modifier
	END
		
	RETURN @modifiers
	END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetNestedGroups]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE FUNCTION [dbo].[GetNestedGroups]	(
	@IncludeParent bit,
	@UserGroupUid UniqueIdentifier	
)
RETURNS  @retTable TABLE (UserGroupUid UniqueIdentifier)
AS
BEGIN
	IF (@IncludeParent=1) 
	BEGIN
		INSERT INTO @retTable values(@UserGroupUid)
 	END

	DECLARE @lUserGroupUid UniqueIdentifier

	DECLARE RetrieveUserGroups CURSOR STATIC LOCAL FOR
	SELECT MemberUserGroupUid FROM UserGroupMember WHERE 
		UserGroupUid = @UserGroupUid and MemberUserGroupUid is not null

	OPEN RetrieveUserGroups

	FETCH NEXT FROM RetrieveUserGroups
	INTO @lUserGroupUid

	WHILE (@@FETCH_STATUS = 0) 
	BEGIN
		INSERT INTO @retTable values(@lUserGroupUid)
  
		INSERT INTO @retTable
		select * from dbo.GetNestedGroups(0, @lUserGroupUid)
   
		FETCH NEXT FROM RetrieveUserGroups
		INTO @lUserGroupUid
	END
	
	CLOSE RetrieveUserGroups
	DEALLOCATE RetrieveUserGroups

RETURN
END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_utcToCurrentDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[UDF_utcToCurrentDate] 
(@utcDate DATETIME)  
RETURNS 
	DATETIME
AS  
BEGIN 
Return	dbo.Date_UTCToLocal_Practice(@utcDate)
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getPatientBp]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[getPatientBp] -- Returns like 1:30 One and half an hour
(
	@PateintUid Uniqueidentifier,
	@Type VarChar(1)
)
RETURNS DECIMAL(10,2)

BEGIN
	Declare @Bp DECIMAL(10,2)
	Select TOP 1 @Bp= (CASE WHEN @Type=''S'' THEN Metricvalue1 ELSE Metricvalue2 END)
	From [MDOL_RPT2_ViewPatientBP] 
	Where PatientUid=@PateintUid
	Order By MeasureDate Desc,Metricvalue1 ASC, Metricvalue2 ASC
	Return @Bp
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getPatientBP2]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[getPatientBP2] -- Returns like 1:30 One and half an hour
(
	@PateintUid Uniqueidentifier,
	@StartDate datetime=NULL,
	@EndDate datetime=NULL,
	@Type VarChar(1)
)
RETURNS DECIMAL(10,2)

BEGIN
	Declare @Bp DECIMAL(10,2)
	Select TOP 1 @Bp= (CASE WHEN @Type=''S'' THEN Metricvalue1 ELSE Metricvalue2 END)
	From [MDOL_RPT2_ViewPatientBP] 
	Where PatientUid=@PateintUid
	and (@StartDate IS NULL OR MeasureDate  >= @StartDate) AND (@EndDate IS NULL OR MeasureDate  <@EndDate)
	and Metricvalue1 != 0 and Metricvalue2 != 0
	Order By MeasureDate Desc,Metricvalue1 ASC, Metricvalue2 ASC
	Return @Bp
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetPatientCareManagementNames]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetPatientCareManagementNames](@PatientCareManagementUid uniqueidentifier, @provider bit) 
RETURNS VARCHAR(MAX) AS
BEGIN
	DECLARE @names VARCHAR(MAX)	
	
	IF @provider <> 0
		SELECT	@names = CASE WHEN @names IS NULL THEN '''' ELSE @names + '';'' END + 
				dbo.UDF_GetFormattedInternalName(p.FirstName, p.MiddleName, p.LastName, p.AkaFirstName, p.AkaLastName)
		FROM	PatientCareManagement pcm INNER JOIN ViewProvider p ON pcm.ProviderUid = p.PersonUid
		WHERE	pcm.PatientCareManagementUid = @PatientCareManagementUid	
	ELSE	
		SELECT	@names = CASE WHEN @names IS NULL THEN '''' ELSE @names + '';'' END + dbo.GetDiagnosisCodeAndName(rel.Code9, rel.Code10, rel.CodeDescription)
		FROM	RelPatientCareManagementDiagnosis rel
		WHERE	rel.PatientCareManagementUid = @PatientCareManagementUid
		
	RETURN @names
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetPatientCondition]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[GetPatientCondition](@PersonUid uniqueidentifier) RETURNS VARCHAR(MAX) AS
BEGIN
	-- Retrieves all associated patient conditions for a patient. Conditions are delimited by '';'' and is returned as a string.
	IF @PersonUid IS NULL
		RETURN NULL
		
	DECLARE @conditions VARCHAR(MAX)
	
	DECLARE @cur CURSOR;
	DECLARE @PatientConditionUid uniqueidentifier;
	DECLARE @conditionName VARCHAR(255);	
	DECLARE @rowCnt int;	
	DECLARE @cnt int;

	BEGIN
		SET @conditions = NULL;
		Set @rowCnt = 1;

		--determine how many rows will be processed		
		SELECT @cnt = COUNT(*) FROM RelPatientCondition WHERE PatientUid = @PersonUid
	
		SET @cur = CURSOR FOR
		SELECT PatientConditionUid FROM RelPatientCondition WHERE PatientUid = @PersonUid ORDER BY DisplayOrder ASC

		OPEN @cur 
		FETCH NEXT FROM @cur 
		INTO @PatientConditionUid
		
		WHILE @@FETCH_STATUS = 0
		BEGIN
			SELECT @conditionName = Name FROM ListPatientCondition lpc WHERE lpc.PatientConditionUid = @PatientConditionUid
			IF(LEN(@conditionName) > 0)
			BEGIN
				IF (@conditions IS NOT NULL)
					Set @conditions = @conditions + @conditionName
				ELSE
					Set @conditions = @conditionName

				IF(@rowCnt < @cnt)
					Set @conditions = @conditions + ''; ''

				Set @rowCnt = @rowCnt + 1					
			END
			FETCH NEXT FROM @cur 
			INTO @PatientConditionUid
		END; 

		CLOSE @cur ;
		DEALLOCATE @cur;
	END;
			
	RETURN @conditions
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getPatientDemographicsComment]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[getPatientDemographicsComment]
(
 @VisitUid VARCHAR(50),
 @PatientUid VARCHAR(50),
 @TrackingNum VARCHAR(50)  =null
)

RETURNS VARCHAR(MAX)
AS
BEGIN
	DECLARE @NOTES VARCHAR(MAX)
	SELECT TOP 1 @NOTES=NOTES
	FROM ObservationOrder 
	WHERE NOTES LIKE ''%<Patient Demographics Comment>%</Patient Demographics Comment>%'' 
	  AND VisitUid=@VisitUid 
	  AND PatientUid=@PatientUid 
	  AND (TrackingNum=@TrackingNum OR TrackingNum is null)
	  AND IsDelete = 0
	
	Declare @CidxStart int 
    Declare @CidxEnd int
    Set @CidxStart = charindex(''<Patient Demographics Comment>'',@NOTES,1)  
    Set @CidxEnd = charindex(''</Patient Demographics Comment>'',@NOTES,1)
    IF @CidxEnd >30 AND @CidxStart >0
		SELECT @NOTES=Substring(@NOTES, @CidxStart+30, @CidxEnd-@CidxStart-30) 
	ELSE
		SET @NOTES=''''	
	RETURN @NOTES
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getPatientDiastolic_Adult_Diabetes]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[getPatientDiastolic_Adult_Diabetes] -- Returns like 1:30 One and half an hour
(
	@VisitUid Uniqueidentifier
)
RETURNS DECIMAL(10,2)

BEGIN
	Declare @Diastolic DECIMAL(10,2)
	Select Top 1 @Diastolic=Metricvalue2 From ObservationValue Where Visituid=@VisitUid And ObservationItemuid=''00000000-0000-0000-7777-100000000073'' AND MetricValue2 IS NOT NULL AND IsVitals = 1
	Return @Diastolic
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getPatientLabResultsTable]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[getPatientLabResultsTable]
(
	 @PersonUid UNIQUEIDENTIFIER = NULL
	 ,@ObservationItem1Uid varchar(max)= NULL --Modified to use observation item instead of 
	 ,@ObservationItem1Range varchar(max)
	 ,@LogicOpr1 bit=0
	 ,@ObservationItem2Uid varchar(max) = NULL --Modified to use observation item instead of 
	 ,@ObservationItem2Range varchar(max) = NULL
	 ,@LogicOpr2 bit=0
	 ,@ObservationItem3Uid varchar(max) = NULL --Modified to use observation item instead of 
	 ,@ObservationItem3Range varchar(max) = NULL
 	 ,@LabResults_StartDate datetime = NULL
	 ,@LabResults_EndDate datetime = NULL 
	 ,@LaboratoryUid varchar(max) = NULL
)
RETURNS  --  VARCHAR(Max)
  @ReturnTable TABLE (
		ResultList varchar(MAX),
		ProviderList varchar(MAX)
  )
  AS
BEGIN
		DECLARE @LabResultList VARCHAR(Max) = ''N/A''
		DECLARE @ProviderResultList VARCHAR(Max) = ''N/A''

		IF @LaboratoryUid=''''
			SET @LaboratoryUid=NULL
		SET @LabResults_StartDate = ISNULL(@LabResults_StartDate , ''1-01-1997'')
		SET @LabResults_EndDate = ISNULL(@LabResults_EndDate, getdate()) 
	
		--SELECT @LabResults_StartDate = dbo.getPracticeUTCDateTime (@LabResults_StartDate)
		--SELECT @LabResults_EndDate =  DATEADD(DAY,1,dbo.getPracticeUTCDateTime(@LabResults_EndDate))
		
				
		DECLARE @ObservationItem1Start varchar(100)
		DECLARE @ObservationItem1End varchar(100)
		
		Set @ObservationItem1Start = ''0''
		Set @ObservationItem1End = ''999''
		
		If( @ObservationItem1Range IS NOT NULL AND LEN( @ObservationItem1Range) > 0 )
		BEGIN
			select @ObservationItem1Start = Element from Split(@ObservationItem1Range,''-'') where ElementID = 1
			select @ObservationItem1End = Element from Split(@ObservationItem1Range,''-'') where ElementID = 2
		END
		
		DECLARE @ObservationItem2Start varchar(100)
		DECLARE @ObservationItem2End varchar(100)
		
		Set @ObservationItem2Start = ''0''
		Set @ObservationItem2End = ''999''
		
		If( @ObservationItem2Range IS NOT NULL AND LEN(@ObservationItem2Range) > 0 )
		BEGIN
			select @ObservationItem2Start = Element from Split(@ObservationItem2Range,''-'') where ElementID = 1
			select @ObservationItem2End = Element from Split(@ObservationItem2Range,''-'') where ElementID = 2
		END
		
		DECLARE @ObservationItem3Start varchar(100)
		DECLARE @ObservationItem3End varchar(100)
		
		If( @ObservationItem3Range IS NOT NULL AND LEN( @ObservationItem3Range) > 0 )
		BEGIN
			select @ObservationItem3Start = Element from Split(@ObservationItem3Range,''-'') where ElementID = 1
			select @ObservationItem3End = Element from Split(@ObservationItem3Range,''-'') where ElementID = 2
		END
		

		--if (@ObservationItem1Uid != ''00000000-0000-0000-0000-000000000000'' 
		--	OR 
		--	@ObservationItem2Uid != ''00000000-0000-0000-0000-000000000000''
		--	OR
		--	@ObservationItem3Uid != ''00000000-0000-0000-0000-000000000000''
		--	)
		if (@ObservationItem1Uid IS NOT NULL  
			OR 
			@ObservationItem2Uid IS NOT NULL  
			OR
			@ObservationItem3Uid IS NOT NULL  
			)
		BEGIN
			--IF (@LogicOpr1 =0 AND @LogicOpr2 =0)
			--BEGIN
			DECLARE @Result TABLE  
			(
				Result VARCHAR(1000),
				OrderProviderUid VARCHAR(1000),
				ObservationItemUid UNIQUEIDENTIFIER
			)

			DECLARE @DisplayResult Bit
			SET @DisplayResult=0				
						INSERT INTO @Result 
						SELECT PL.LabResult,OrderProviderUid,PL.ObservationItemUid
						 FROM   [MDOL_RPT2_VIEW_PatientLabResultsWithProvider] PL 		
						 Where 
							PL.IsDelete = 0
				            AND
							@PersonUid = PL.PatientUid
							AND
							(
								(
								PL.ObservationItemUid  in (Select element from dbo.Split (@ObservationItem1Uid,'','')) 
								AND PL.NumericObservationValue>=@ObservationItem1Start
								AND PL.NumericObservationValue<=@ObservationItem1End
								)
								OR
								(
									PL.ObservationItemUid in (Select element from dbo.Split (@ObservationItem2Uid,'','')) 
									AND PL.NumericObservationValue>=@ObservationItem2Start
									AND PL.NumericObservationValue<=@ObservationItem2End
									
								)
								OR
								(
									PL.ObservationItemUid in (Select element from dbo.Split (@ObservationItem3Uid,'','')) 
									AND PL.NumericObservationValue>=@ObservationItem3Start
									AND PL.NumericObservationValue<=@ObservationItem3End
							
								)
							)					 
							AND					
							PL.ResultDate >= @LabResults_StartDate AND PL.ResultDate < @LabResults_EndDate
							AND
						(@LaboratoryUid IS NULL OR PL.LaboratoryUid in (Select Element from dbo.Split(@LaboratoryUid,'','')))
						 order by PL.ResultDate
						 						
						 --FOR XML PATH( '''' )
						 --), 2, 2500 ) )*/

			--	END	
			IF (@LogicOpr1 =1 AND @LogicOpr2 =1)
			BEGIN
				IF EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem1Uid,'',''))  
				OR @ObservationItem1Uid IS NULL) AND EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem2Uid,'',''))  
				OR @ObservationItem2Uid IS NULL) AND EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem3Uid,'',''))  
				OR @ObservationItem3Uid IS NULL)
					SET @DisplayResult=1
			END
			IF (@LogicOpr1 =1 AND @LogicOpr2 =0)
			BEGIN
				IF EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem1Uid,'',''))  
				OR @ObservationItem1Uid IS NULL) AND EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem2Uid,'',''))  
				OR @ObservationItem2Uid IS NULL) OR EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem3Uid,'',''))  
				OR @ObservationItem3Uid IS NULL)
					SET @DisplayResult=1
			END	
			IF (@LogicOpr1 =0 AND @LogicOpr2 =1)
			BEGIN
				IF EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem1Uid,'',''))  
				OR @ObservationItem1Uid IS NULL) OR EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem2Uid,'',''))  
				OR @ObservationItem2Uid IS NULL) AND EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem3Uid,'',''))  
				OR @ObservationItem3Uid IS NULL)
					SET @DisplayResult=1
			END			
			IF (@LogicOpr1 =0 AND @LogicOpr2 =0)
			BEGIN
				--IF EXISTS() OR EXISTS() OR EXISTS()
					SET @DisplayResult=1
			END		
			IF @DisplayResult=1 
			BEGIN
			insert into @ReturnTable
			 SELECT  distinct --Result as resultlist, 
		            STUFF((SELECT '','' + r.Result
                        FROM @Result r
                        WHERE r.OrderProviderUid = result.OrderProviderUid
                        FOR XML PATH('''') 
                        ), 1, 1, '''' )
		            AS resultList,
					OrderProviderUid as providerlist
			from @Result result
			END	
			ELSE
				BEGIN
				SET @LabResultList=NULL
				END 
		END
		ELSE
		BEGIN
		insert into @ReturnTable
		SELECT 	distinct
				(substring(
				(SELECT ( '';'' + loi.Name + '': '' + coalesce(nullif(Convert(VARCHAR(50),ISNULL(ov.ObservationValue,'''')),''''),''N/A'') + '' Resulted: '' + (Convert(VARCHAR(50),oo1.ResultDate,101)))
                 FROM    ObservationOrder oo1 
				 INNER JOIN ObservationValue    ov  ON ov.ObservationOrderUid = oo1.ObservationOrderUid 
				 INNER JOIN ListObservationItem loi ON loi.ObservationItemUid = ov.ObservationItemUid 
				 --INNER JOIN ListLOINC           ll  ON ll.LOINCUid            = loi.LOINCUid 
				 inner join Person				PR  ON PR.PersonUid			  = oo1.PatientUid			
				 where 
				    oo1.IsDelete = 0
				    AND
					@PersonUid = oo1.PatientUid				 
					AND					
					oo1.ResultDate >= @LabResults_StartDate AND oo1.ResultDate < @LabResults_EndDate
					AND
					(@LaboratoryUid IS NULL OR oo1.LaboratoryUid in (Select Element from dbo.Split(@LaboratoryUid,'','')))
					and oo.patientuid = oo1.PatientUid and oo.observationorderuid = oo1.ObservationOrderUid
				 order by oo1.ResultDate
				 FOR XML PATH( '''' )
				 ), 2, 2500 )) ,						 
--				 loi.Name + '': '' + coalesce(nullif(Convert(VARCHAR(50),ISNULL(ov.ObservationValue,'''')),''''),''N/A'') + '' Resulted: '' + (Convert(VARCHAR(50),oo.ResultDate,101)) as ResultList,
			    oo.OrderProviderUid as ProviderList
                 FROM    ObservationOrder oo 
				 INNER JOIN ObservationValue    ov  ON ov.ObservationOrderUid = oo.ObservationOrderUid 
				 INNER JOIN ListObservationItem loi ON loi.ObservationItemUid = ov.ObservationItemUid 
				 inner join Person				PR  ON PR.PersonUid			  = oo.PatientUid			
				 where 
				    oo.IsDelete = 0
				    AND
					@PersonUid = oo.PatientUid				 
					AND					
					oo.ResultDate >= @LabResults_StartDate AND oo.ResultDate < @LabResults_EndDate
					AND
					(@LaboratoryUid IS NULL OR oo.LaboratoryUid in (Select Element from dbo.Split(@LaboratoryUid,'','')))
				-- order by oo.ResultDate

		 END		
		
		RETURN
END







' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getPatientLabTestComment]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[getPatientLabTestComment](@Notes Varchar(Max))  RETURNS VARCHAR(MAX) 
AS 
BEGIN 
Declare @Cinx int  
  Set @Cinx = charindex(''<Patient Demographics Comment>'',@NOTES,1)  
 IF @Cinx <1 
 BEGIN
	SET @NOTES=@NOTES
  
 END
 ELSE IF @Cinx =1
 BEGIN 
	Set @Cinx = charindex(''</Patient Demographics Comment>'',@NOTES,1) 
	SELECT TOP 1 @NOTES=Substring(@NOTES, @Cinx+31,LEN(@NOTES)) 
 END
 ELSE
 BEGIN
		SELECT TOP 1 @NOTES=Substring(@NOTES, 1, @Cinx-1) 
 END  
	Return @Notes
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getPatientSystolic_Adult_Diabetes]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[getPatientSystolic_Adult_Diabetes] -- Returns like 1:30 One and half an hour
(
	@VisitUid Uniqueidentifier
)
RETURNS DECIMAL(10,2)

BEGIN
	
	Declare @Sytolic DECIMAL(10,2)
	Select Top 1 @Sytolic=Metricvalue1 From ObservationValue Where Visituid=@VisitUid And ObservationItemuid=''00000000-0000-0000-7777-100000000073'' AND MetricValue1 IS NOT NULL AND IsVitals = 1
	Return @Sytolic
END

' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetPEDefaultFlag]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetPEDefaultFlag](@defaultFlag [bit], @clinicCenterUid [uniqueidentifier], @providerUid [uniqueidentifier], @kdbClinicCenter [xml], @kdbProvider [xml])
RETURNS [bit] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[GetPEDefaultFlag]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetPhoneByType]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetPhoneByType](@phoneType varchar(100), @phone1 xml(CONTENT dbo.Phone) = NULL, @phone2 xml(CONTENT dbo.Phone) = NULL, @phone3 xml(CONTENT dbo.Phone) = NULL, @phone4 xml(CONTENT dbo.Phone) = NULL) RETURNS VARCHAR(100) AS	
BEGIN
	DECLARE @Phonenumber VARCHAR(50)
	
	IF @phone1.value(''(/Phone/PhoneType)[1]'', ''VARCHAR(100)'') = @phoneType OR ISNULL(@phoneType, '''') = ''''
		RETURN dbo.GetPhoneFormatted(@phone1)
	
	IF @phone2.value(''(/Phone/PhoneType)[1]'', ''VARCHAR(100)'') = @phoneType
		RETURN dbo.GetPhoneFormatted(@phone2)

	IF @phone3.value(''(/Phone/PhoneType)[1]'', ''VARCHAR(100)'') = @phoneType
		RETURN dbo.GetPhoneFormatted(@phone3)

	IF @phone4.value(''(/Phone/PhoneType)[1]'', ''VARCHAR(100)'') = @phoneType
		RETURN dbo.GetPhoneFormatted(@phone4)

	RETURN NULL
END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetPersonPhoneByType]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetPersonPhoneByType] (@PersonUid UNIQUEIDENTIFIER, @PhoneType VARCHAR(10)) RETURNS VARCHAR(25) AS  
BEGIN 

	DECLARE @Phone1 xml(CONTENT dbo.Phone)
	DECLARE @Phone2 xml(CONTENT dbo.Phone)
	DECLARE @Phone3 xml(CONTENT dbo.Phone)
	DECLARE @Phone4 xml(CONTENT dbo.Phone)

	SELECT	@Phone1 = Phone1,
			@Phone2 = Phone2,
			@Phone3 = Phone3,
			@Phone4 = Phone4
	FROM	Person
	WHERE	PersonUid = @PersonUid
	
	RETURN dbo.GetPhoneByType(@PhoneType, @Phone1, @Phone2, @Phone3, @Phone4)
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetPhoneAndType]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetPhoneAndType](@phone xml(CONTENT dbo.Phone)) RETURNS VARCHAR(255) AS
BEGIN
	IF @phone IS NULL
		RETURN NULL
		
	DECLARE @phonenumber VARCHAR(100)
	DECLARE @phonetype VARCHAR(100)
	DECLARE @pt VARCHAR(255)
	
	SET @phonenumber = @phone.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(100)'')
	SET @phonetype = @phone.value(''(/Phone/PhoneType)[1]'', ''VARCHAR(100)'')

	IF RTRIM(ISNULL(@phonenumber, '''')) = ''''
		RETURN NULL
		
	IF RTRIM(ISNULL(@phonetype, '''')) <> ''''
	BEGIN
		SET @pt = @phonetype + '': ''	
		SET @pt = @pt + dbo.GetPhoneFormatted(@phone)
	END
	ELSE
		SET @pt = dbo.GetPhoneFormatted(@phone)	
	
	RETURN @pt
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetPrescriptionFullName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetPrescriptionFullName](@MedicationSIGUid uniqueidentifier)
RETURNS varchar(8000)
AS
BEGIN
	DECLARE @String varchar(8000)
	Set @String = ''''
	SELECT @String = @String + CASE @String WHEN '''' THEN '''' ELSE '';  '' END + MedicationSIG.Name + ''; '' + 
		CASE coalesce(DosageQuantity, '''') WHEN '''' THEN '''' ELSE DosageQuantity + '' '' END + 
		CASE coalesce(DosageUnit, '''') WHEN '''' THEN '''' ELSE DosageUnit END + ''; '' + 
		CASE coalesce(MedicationSIG.Route, '''') WHEN '''' THEN '''' ELSE MedicationSIG.Route END + 
		CASE coalesce(Frequency, '''') WHEN '''' THEN '''' ELSE ''; '' + Frequency END + 
		CASE coalesce(Duration, 0) WHEN 0 THEN '''' ELSE ''; '' + cast(Duration as varchar(10)) + '' days'' END +
		CASE coalesce(Quantity, '''') WHEN '''' THEN '''' ELSE ''; Qty: '' + Quantity END +
		CASE coalesce(CONVERT(VARCHAR(50), ItemStartDate), '''') + coalesce(CONVERT(VARCHAR(50), ItemStopDate), '''') WHEN '''' THEN '''' ELSE
			''  ['' + CASE coalesce(ItemStartDate, ''1/1/1900'') WHEN ''1/1/1900'' THEN '''' ELSE convert(varchar(30), ItemStartDate, 101) END + '' - '' + 
			CASE coalesce(ItemStopDate, ''1/1/1900'') WHEN ''1/1/1900'' THEN '''' ELSE convert(varchar(30), ItemStopDate, 101) END + '']'' END
	FROM SIGDetail INNER JOIN MedicationSIG 
			ON SIGDetail.MedicationSIGUid = MedicationSIG.MedicationSIGUid
	WHERE SIGDetail.MedicationSIGUid = @MedicationSIGUid
	ORDER BY DisplayOrder
	RETURN @String
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetPrescriptionFullName_ActiveMedication]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetPrescriptionFullName_ActiveMedication](@MedicationSIGUid uniqueidentifier)
RETURNS varchar(8000)
AS
BEGIN
	DECLARE @String varchar(8000)
	Set @String = ''''
	SELECT @String = @String + CASE @String WHEN '''' THEN '''' ELSE '';  '' END + MedicationSIG.Name + ''; '' + 
		CASE coalesce(DosageQuantity, '''') WHEN '''' THEN '''' ELSE DosageQuantity + '' '' END + 
		CASE coalesce(DosageUnit, '''') WHEN '''' THEN '''' ELSE DosageUnit END + ''; '' + 
		CASE coalesce(MedicationSIG.Route, '''') WHEN '''' THEN '''' ELSE MedicationSIG.Route END + 
		CASE coalesce(Frequency, '''') WHEN '''' THEN '''' ELSE ''; '' + Frequency END + 
		CASE coalesce(Duration, 0) WHEN 0 THEN '''' ELSE ''; '' + cast(Duration as varchar(10)) + '' days'' END +
		CASE coalesce(Quantity, '''') WHEN '''' THEN '''' ELSE ''; Qty: '' + Quantity END +
		CASE coalesce(CONVERT(VARCHAR(50), ItemStartDate), '''') + coalesce(CONVERT(VARCHAR(50), ItemStopDate), '''') WHEN '''' THEN '''' ELSE
			''  ['' + CASE coalesce(ItemStartDate, ''1/1/1900'') WHEN ''1/1/1900'' THEN '''' ELSE convert(varchar(30), ItemStartDate, 101) END + '' - '' + 
			CASE coalesce(ItemStopDate, ''1/1/1900'') WHEN ''1/1/1900'' THEN '''' ELSE convert(varchar(30), ItemStopDate, 101) END + '']'' END
	FROM SIGDetail INNER JOIN MedicationSIG 
			ON SIGDetail.MedicationSIGUid = MedicationSIG.MedicationSIGUid
	WHERE 
		SIGDetail.MedicationSIGUid = @MedicationSIGUid
	AND
			(MedicationSIG.IsMaintenanceDrug = 1 
			OR SIGDetail.ItemStopDate IS NULL 
			OR NOT (SIGDetail.ItemStopDate < GETDATE()))
		AND 
			(MedicationSIG.IsMaintenanceDrug = 1 
			OR SIGDetail.ItemStartDate IS NULL 
			OR NOT (SIGDetail.ItemStartDate >  GETDATE()))
	ORDER BY DisplayOrder
	RETURN @String
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetProcedures]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetProcedures](@range varchar(4000)) RETURNS @results TABLE (ProcedureUid UNIQUEIDENTIFIER) AS 
	BEGIN
	
		SET @range = REPLACE(@range, '','', '';'')

		DECLARE @matches TABLE (	PartA varchar(100) NULL,
									PartB varchar(100) NULL
								)
								
		INSERT @matches(PartA)
		SELECT	LTRIM(RTRIM(Element))
		FROM	dbo.Split(@range, '';'')
		 
		UPDATE	m
		SET		PartA = LTRIM(RTRIM(SUBSTRING(PartA, 1, CHARINDEX(''-'', PartA) - 1))),
				PartB = LTRIM(RTRIM(SUBSTRING(PartA, CHARINDEX(''-'', PartA) + 1, LEN(PartA) - CHARINDEX(''-'', PartA))))
		FROM	@matches m
		WHERE	CHARINDEX(''-'', PartA) > 0
					 
		INSERT	@results
		SELECT	p.ProcedureUid
		FROM	ListProcedure p CROSS JOIN @matches m 
		WHERE	(p.Code = m.PartA AND m.PartB IS NULL) OR
				(p.Code >= m.PartA AND p.Code <= m.PartB)
		 
	RETURN
	END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetProcedureShortDescription]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetProcedureShortDescription]
	(@ProcedureUid UNIQUEIDENTIFIER)
RETURNS VARCHAR(MAX) AS  
BEGIN 
	DECLARE @Description varchar(MAX)

	DECLARE @UseLabPrefix int
	SELECT @UseLabPrefix = 1  --DEFAULT TO ''USE LAB PREFIX''

	SELECT TOP 1 @UseLabPrefix = isnull(BoolValue, 1) 
	FROM ListProductParameter 
	WHERE ParameterName = ''UseLabPrefixOnProcedures''

	IF @UseLabPrefix <> 0
	BEGIN
		SELECT @Description =  ISNULL(LEFT(tab.LabNames, LEN(tab.LabNames)-1) + '': '', '''') + prc.ShortDescription
		FROM ListProcedure prc
        OUTER APPLY (
           SELECT LEFT(lab.Name, 1) + '',''
		   FROM RelProcedureLaboratoryOrder rel
		   INNER JOIN ListLaboratoryOrder llo ON llo.LaboratoryOrderUid = rel.LaboratoryOrderUid
		   INNER JOIN ListLaboratory lab ON lab.LaboratoryUid = llo.LaboratoryUid
		   WHERE rel.ProcedureUid = prc.ProcedureUid
		   ORDER BY rel.DisplayOrder 
           FOR XML PATH(''''))  tab(LabNames) 
		WHERE prc.ProcedureUid = @ProcedureUid

	END
	ELSE
	BEGIN	-- DON''T USE LAB PREFIX, JUST RETURN REGULAR SHORT DESCRIPTION
		SELECT @Description = prc.ShortDescription
		FROM ListProcedure prc
		WHERE ProcedureUid = @ProcedureUid
	END

	RETURN Left(@Description, 50)
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetProviderNPI]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetProviderNPI](	@providerUid UNIQUEIDENTIFIER, @serviceSiteUid UNIQUEIDENTIFIER, @financialCenterUid UNIQUEIDENTIFIER	) RETURNS VARCHAR(25) AS
BEGIN
	-- Declare the return variable here
	DECLARE @npi VARCHAR(25)
	SELECT	@npi = cfv.Value
	FROM	ClaimFormatValue cfv
	WHERE	cfv.ProviderUid = @providerUid AND
			cfv.ClaimFormatValueTypeUid = ''CE282F4E-A866-49BA-9636-C4BA0439E907'' /* Provider NPI */ AND
			(@serviceSiteUid IS NULL OR cfv.ServiceSiteUid IS NULL OR @serviceSiteUid = cfv.ServiceSiteUid) AND
			(@financialCenterUid IS NULL OR cfv.FinancialCenterUid IS NULL OR @financialCenterUid = cfv.FinancialCenterUid)

	RETURN	@npi
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getRelativeFiscalMonthEnd]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[getRelativeFiscalMonthEnd]
(
	@dtCurrent DATETIME
)
RETURNS DATETIME
AS
BEGIN
	RETURN dbo.Date_RelativeFiscalMonthEnd(@dtCurrent)
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getRelativeFiscalYearEnd]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[getRelativeFiscalYearEnd]
(
	@dtCurrent datetime
)
RETURNS DATETIME
AS
BEGIN
	RETURN dbo.Date_RelativeFiscalYearEnd(@dtCurrent)
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getRelativeFiscalYearEnd_AS]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[getRelativeFiscalYearEnd_AS]
(
	@dtCurrent datetime
)
RETURNS DATETIME
AS
BEGIN
	RETURN dbo.Date_RelativeFiscalYearEnd(@dtCurrent)
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getRelativeFiscalYearEnd_RA]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[getRelativeFiscalYearEnd_RA]
(
	@dtCurrent datetime
)
RETURNS DATETIME
AS
BEGIN
	RETURN dbo.Date_RelativeFiscalYearEnd(@dtCurrent)
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetReplicationNames]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetReplicationNames](@cacheMachineUid uniqueidentifier, @provider bit) 
RETURNS VARCHAR(MAX) AS
BEGIN
	DECLARE @names VARCHAR(MAX)	
	
	IF @provider <> 0
		SELECT	@names = CASE WHEN @names IS NULL THEN '''' ELSE @names + '';'' END + 
				dbo.UDF_GetFormattedInternalName(p.FirstName, p.MiddleName, p.LastName, p.AkaFirstName, p.AkaLastName)
		FROM	RelCacheMachineProvider rel INNER JOIN ViewProvider p ON rel.ProviderUid = p.PersonUid
		WHERE	rel.CacheMachineUid = @cacheMachineUid
	ELSE	
		SELECT	@names = CASE WHEN @names IS NULL THEN '''' ELSE @names + '';'' END + u.LastName + '', '' + u.FirstName
		FROM	RelCacheMachineUserPRM rel INNER JOIN ViewFindUser u ON rel.UserPRMUid = u.PersonUid
		WHERE	rel.CacheMachineUid = @cacheMachineUid
		
	RETURN @names
END
' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetRosDenyFlag]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetRosDenyFlag](@denyFlag [bit], @clinicCenterUid [uniqueidentifier], @providerUid [uniqueidentifier], @kdbClinicCenter [xml], @kdbProvider [xml])
RETURNS [bit] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[GetRosDenyFlag]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getSuperbillAge]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




-- 20150924 kculberth incorporate performance improvements by utilizing StatementBatchDetailUid to narrow dataset and moving dunning logic to Header

CREATE FUNCTION [dbo].[getSuperbillAge]
	(@RPUid uniqueidentifier,
	@StatementBatchDetailUid uniqueidentifier)
RETURNS INT AS 
BEGIN

DECLARE @Age INT

;WITH cteSuperbillList as
(
	select superbilluid,AccountResponsiblePartyuid 
	from StatementBatchDetailSuperbill (NOLOCK) sbds
	inner join StatementBatchDetail sbd on sbd.StatementBatchDetailUid = sbds.StatementBatchDetailUid
	where sbds.StatementBatchDetailUid = @StatementBatchDetailUid
)
,cteAgeLiability as
(
	SELECT 
		cteSB.AccountResponsiblePartyUid,cteSB.SuperbillUid,LD.SuperbillProcedureUid, LD.LiabilityOwner,arb.gldate,       
            SUM(Amount) AS LiabilityAmount
      FROM  cteSuperbillList cteSB 
            --INNER JOIN Superbill (NOLOCK) SB ON SB.SuperbillUid = cteSB.SuperbillUid
            INNER JOIN SuperbillProcedure (NOLOCK) SBP ON cteSB.SuperbillUid = SBP.SuperbillUid
			INNER JOIN AR_LedgerDetail (NOLOCK)  LD on LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid       
            INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid  
			--INNER JOIN Account (NOLOCK) A ON A.AccountUid = SB.AccountUid
			INNER JOIN ARBatch (NOLOCK) ARB ON L.ArbatchUid = ARB.ArbatchUid 
			INNER JOIN ViewStatementSuperbillBalanceExcludeStatus vssb on vssb.superbilluid = cteSB.SuperbillUid			
      WHERE NOT LD.SuperbillProcedureUid IS NULL  
			AND LD.LiabilityOwner = 0 
			and cteSB.AccountResponsiblePartyUid = @rpuid
      GROUP BY cteSB.AccountResponsiblePartyUid,LD.SuperbillProcedureUid,cteSB.SuperbillUid,LD.LiabilityOwner,ARB.GLDate
	  HAVING SUM(Amount) <> 0  	  
),
cteAge as 
(
	  SELECT 
	  cteSB.AccountResponsiblePartyUid,--SB.ExternalID,
	  LD.SuperbillProcedureUid,
	  arb.gldate,DATEDIFF(d, ARB.GLDate,GetDate()) as AgingDays
      FROM cteSuperbillList cteSB 
			--INNER JOIN Superbill (NOLOCK) SB ON SB.SuperbillUid = cteSB.SuperbillUid
            INNER JOIN SuperbillProcedure (NOLOCK) SBP ON cteSB.SuperbillUid = SBP.SuperbillUid
			INNER JOIN AR_LedgerDetail (NOLOCK)  LD on LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid       
            INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid  
			--INNER JOIN Account (NOLOCK) A ON A.AccountUid = SB.AccountUid
			INNER JOIN ARBatch (NOLOCK) ARB ON L.ArbatchUid = ARB.ArbatchUid 
			INNER JOIN ViewStatementSuperbillBalanceExcludeStatus vssb on vssb.superbilluid = cteSB.SuperbillUid	
      WHERE NOT LD.SuperbillProcedureUid IS NULL  
			AND LD.LiabilityOwner = 0 	
			AND Patient <> 0
			and cteSB.AccountResponsiblePartyUid = @rpuid						
	  group by cteSB.AccountResponsiblePartyUid,ARB.GLDate,--SB.ExternalID,
	  LD.SuperbillProcedureUid
)

, cte as
(
	select
	ROW_NUMBER() OVER(partition by cte.AccountResponsiblePartyUid order by Max(agingDays) desc ) AS Row,
	cte.accountresponsiblepartyuid,cte.superbillprocedureuid,liabilityamount
	,Max(agingDays) as age	
	FROM cteAgeLiability cte
	inner join cteAge age on age.superbillprocedureuid = cte.superbillprocedureuid and age.gldate = cte.gldate
    group by cte.accountresponsiblepartyuid,cte.superbillprocedureuid,cte.gldate,liabilityamount
)
, cteRunningTotal as
(
	SELECT x.accountresponsiblepartyuid,x.row,x.age, sum(y.liabilityamount) as runningtotal  
	FROM cte X, cte y 
	where y.row <= x.row and x.accountresponsiblepartyuid = y.accountresponsiblepartyuid
	group by x.accountresponsiblepartyuid,x.row,x.age
)
,ctePositiveLiability as
(
	select accountresponsiblepartyuid,row,age,runningtotal,
	ROW_NUMBER() OVER(partition by cteRunningTotal.AccountResponsiblePartyUid order by row asc ) AS Row2
	from cteRunningTotal
	where runningtotal >= 0
)
, cteFinalAge as
(
 select top (1) age from ctePositiveLiability
 where accountresponsiblepartyuid = @RPUid
 and ((runningtotal > 0 and row2 = (select top(1) row2 from ctePositiveLiability where RunningTotal = 0  and accountresponsiblepartyuid = @RPuid order by row desc) + 1) or row2 = 1)
 order by row desc
)


 SELECT @Age = age from cteFinalAge
 
 RETURN @Age

END






' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getStatementDunningMsg]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- 20150924 kculberth incorporate performance improvements by utilizing StatementBatchDetailUid to narrow dataset and moving dunning logic to Header

CREATE FUNCTION [dbo].[getStatementDunningMsg]
	(@RPUid uniqueidentifier,
	 @StatementBatchDetailUid uniqueidentifier)
RETURNS varchar(300) AS 
BEGIN

DECLARE @DunningMsg VARCHAR(300)
DECLARE @Age INT 

select @Age = dbo.getSuperbillAge(@RPUid,@StatementBatchDetailUid)

	select @DunningMsg = (CASE WHEN @Age <=30 AND LEN(Dn.DunningMsg1) >0 THEN ''0-30 Days: ''+ Dn.DunningMsg1
	WHEN @Age >=31 AND @Age <=60  AND LEN(Dn.DunningMsg2) >0 THEN ''31-60 Days: ''+ Dn.DunningMsg2
	WHEN @Age >=61 AND @Age <=90 AND LEN(Dn.DunningMsg3) >0 THEN ''61-90 Days: ''+ Dn.DunningMsg3
	WHEN @Age >=91 AND @Age <=120 AND LEN(Dn.DunningMsg4) >0 THEN ''91-120 Days: ''+ Dn.DunningMsg4
	WHEN @Age >=121 AND LEN(Dn.DunningMsg5) >0 THEN ''121 + Days: ''+ Dn.DunningMsg5
	ELSE ''''
	END) 
	FROM  PracticeSettings ps (nolock) 
	INNER JOIN DunningMsgs Dn (nolock) ON ps.DunningMsgsUid=Dn.DunningMsgsUid
RETURN @DunningMsg

END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getSuperbillAge_MainAccount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'





CREATE FUNCTION [dbo].[getSuperbillAge_MainAccount]
	(@RPUid uniqueidentifier)
RETURNS INT AS 
BEGIN

DECLARE @Age INT

;WITH cteAgeLiability as
(
	SELECT 
		A.AccountResponsiblePartyUid,SB.SuperbillUid,LD.SuperbillProcedureUid, LD.LiabilityOwner,arb.gldate,       
            SUM(Amount) AS LiabilityAmount--,DATEDIFF(d, ARB.GLDate,GetDate()) as AgingDays
      FROM AR_LedgerDetail (NOLOCK)  LD        
            INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid  
            INNER JOIN SuperbillProcedure (NOLOCK) SBP ON LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid
            INNER JOIN Superbill (NOLOCK) SB ON SB.SuperbillUid = SBP.SuperbillUid
			INNER JOIN Account (NOLOCK) A ON A.AccountUid = SB.AccountUid
			INNER JOIN ARBatch (NOLOCK) ARB ON L.ArbatchUid = ARB.ArbatchUid 
			INNER JOIN ViewStatementSuperbillBalanceExcludeStatus vssb on vssb.superbilluid = sb.SuperbillUid			
      WHERE NOT LD.SuperbillProcedureUid IS NULL  
			AND LD.LiabilityOwner = 0 
			and a.AccountResponsiblePartyUid = @rpuid
			and A.ISMAIN = 1
      GROUP BY A.AccountResponsiblePartyUid,LD.SuperbillProcedureUid,SB.SuperbillUid,LD.LiabilityOwner,ARB.GLDate
	  HAVING SUM(Amount) <> 0  	  
),
cteAge as 
(
	  SELECT 
	--ROW_NUMBER() OVER(partition by a.AccountResponsiblePartyUid order by DATEDIFF(d, ARB.GLDate,GetDate()) desc ) AS Row,
	  A.AccountResponsiblePartyUid,SB.ExternalID,LD.SuperbillProcedureUid,
	  arb.gldate,DATEDIFF(d, ARB.GLDate,GetDate()) as AgingDays
      FROM AR_LedgerDetail (NOLOCK)  LD        
            INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid  
            INNER JOIN SuperbillProcedure (NOLOCK) SBP ON LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid
            INNER JOIN Superbill (NOLOCK) SB ON SB.SuperbillUid = SBP.SuperbillUid
			INNER JOIN ARBatch (NOLOCK) ARB ON L.ArbatchUid = ARB.ArbatchUid 
			INNER JOIN Account (NOLOCK) A ON A.AccountUid = SB.AccountUid
			INNER JOIN ViewStatementSuperbillBalanceExcludeStatus vssb on vssb.superbilluid = sb.SuperbillUid
      WHERE NOT LD.SuperbillProcedureUid IS NULL  
			AND LD.LiabilityOwner = 0 	
			AND Patient <> 0
			and a.AccountResponsiblePartyUid = @rpuid
			AND A.IsMain = 1						
	  group by a.AccountResponsiblePartyUid,ARB.GLDate,SB.ExternalID,LD.SuperbillProcedureUid
)

, cte as
(
	select
	ROW_NUMBER() OVER(partition by cte.AccountResponsiblePartyUid order by Max(agingDays) desc ) AS Row,
	cte.accountresponsiblepartyuid,cte.superbillprocedureuid,liabilityamount--,agingDays,cte.gldate--,LiabilityAmount--
	,Max(agingDays) as age	
	FROM cteAgeLiability cte
	inner join cteAge age on age.superbillprocedureuid = cte.superbillprocedureuid and age.gldate = cte.gldate
	inner join ViewStatementSuperbillBalanceExcludeStatus vssb on vssb.SuperbillUid = cte.SuperbillUid
    group by cte.accountresponsiblepartyuid,cte.superbillprocedureuid,cte.gldate,liabilityamount
)
, cteRunningTotal as
(
	SELECT x.accountresponsiblepartyuid,x.row,x.age, sum(y.liabilityamount) as runningtotal  
	FROM cte X, cte y 
	where y.row <= x.row and x.accountresponsiblepartyuid = y.accountresponsiblepartyuid
	group by x.accountresponsiblepartyuid,x.row,x.age
)
,ctePositiveLiability as
(
	select accountresponsiblepartyuid,row,age,runningtotal,
	ROW_NUMBER() OVER(partition by cteRunningTotal.AccountResponsiblePartyUid order by row asc ) AS Row2
	from cteRunningTotal
	where runningtotal >= 0
)
, cteFinalAge as
(
 select top (1) age from ctePositiveLiability
 where accountresponsiblepartyuid = @RPUid
 and ((runningtotal > 0 and row2 = (select top(1) row2 from ctePositiveLiability where RunningTotal = 0  and accountresponsiblepartyuid = @RPuid order by row desc) + 1) or row2 = 1)
 order by row desc
)


 --SELECT @Age = age from cteRunningTotal
 --where accountresponsiblepartyuid = @RPUid
 --and ((runningtotal > 0 and row > (select row from cteRunningTotal where RunningTotal = 0  and accountresponsiblepartyuid = @RPuid)) or row = 1)
 --order by row desc
 
 SELECT @Age = age from cteFinalAge
 
 RETURN @Age

END






' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getStatementDunningMsg_MainAccount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[getStatementDunningMsg_MainAccount]
	(@RPUid uniqueidentifier)
RETURNS varchar(300) AS 
BEGIN

DECLARE @DunningMsg VARCHAR(300)
DECLARE @Age INT 

select @Age = dbo.getSuperbillAge_MainAccount(@RPUid)

	select @DunningMsg = (CASE WHEN @Age <=30 AND LEN(Dn.DunningMsg1) >0 THEN ''0-30 Days: ''+ Dn.DunningMsg1
	WHEN @Age >=31 AND @Age <=60  AND LEN(Dn.DunningMsg2) >0 THEN ''31-60 Days: ''+ Dn.DunningMsg2
	WHEN @Age >=61 AND @Age <=90 AND LEN(Dn.DunningMsg3) >0 THEN ''61-90 Days: ''+ Dn.DunningMsg3
	WHEN @Age >=91 AND @Age <=120 AND LEN(Dn.DunningMsg4) >0 THEN ''91-120 Days: ''+ Dn.DunningMsg4
	WHEN @Age >=121 AND LEN(Dn.DunningMsg5) >0 THEN ''121 + Days: ''+ Dn.DunningMsg5
	ELSE ''''
	END) 
	FROM  PracticeSettings ps (nolock) 
	LEFT JOIN DunningMsgs Dn (nolock) ON ps.DunningMsgsUid=Dn.DunningMsgsUid
RETURN @DunningMsg

END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getSuperbillAgeByFinancialCenter]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

-- 20160503 kc add missing WITH (NOLOCK) 


-- 20150427 kc added "and vssb.FinancialCenterUid = @FCUid" and also added 
--				ViewStatementSuperbillBalanceByFinancialCenterExcludeStatus to cteAgeLiability
--				This seems to improve performance dramatically.
-- 20150605 kc added "and vssb.Patient > 0" to cteAgeLiability to only look at the superbills with patient balance to improve performance.
-- 20160505 kc combined FC and practice aging logic to improve performance dramatically bug 49049

CREATE FUNCTION [dbo].[getSuperbillAgeByFinancialCenter]
	( @RPUid uniqueidentifier,
	@FinancialCenterUid uniqueidentifier)
RETURNS INT AS 
BEGIN
--set @RPUid=''9c3a58bb-a670-469e-b551-2858d2e6bf32''
--set @FinancialCenterUid=''22a79d00-6f81-4301-8470-ffcafc3b3d6d''

DECLARE @Age INT
DECLARE @FCUid uniqueidentifier

SET @FCUid = @FinancialCenterUid
--(select FinancialCenterUid from StatementBatchDetail where StatementBatchDetailUid = @StatementBatchDetailUid)
;WITH cteStatementBatchDetailList as
(
	select top 1 StatementBatchDetailUid from StatementBatchDetail
	where AccountResponsiblePartyUid = @RPUid and FinancialCenterUid = @FinancialCenterUid
	order by LastModifiedDate desc
)
, cteSuperbillList as
(
	select superbilluid,AccountResponsiblePartyuid,FinancialCenterUid 
	from StatementBatchDetailSuperbill (NOLOCK) sbds
	inner join StatementBatchDetail (NOLOCK) sbd on sbd.StatementBatchDetailUid = sbds.StatementBatchDetailUid
	inner join cteStatementBatchDetailList cte on cte.StatementBatchDetailUid = sbd.StatementBatchDetailUid
	where PatientBalance > 0
)
,cteAgeLiability as
(
	SELECT 
		cteSB.AccountResponsiblePartyUid,cteSB.SuperbillUid,LD.SuperbillProcedureUid, LD.LiabilityOwner,arb.gldate,       
            SUM(Amount) AS LiabilityAmount
      FROM  cteSuperbillList cteSB 
            INNER JOIN SuperbillProcedure (NOLOCK) SBP ON cteSB.SuperbillUid = SBP.SuperbillUid
			INNER JOIN AR_LedgerDetail (NOLOCK)  LD on LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid       
            INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid  
			INNER JOIN ARBatch (NOLOCK) ARB ON L.ArbatchUid = ARB.ArbatchUid 
     WHERE NOT LD.SuperbillProcedureUid IS NULL  
			AND LD.LiabilityOwner = 0 
			and cteSB.AccountResponsiblePartyUid = @rpuid
      GROUP BY cteSB.AccountResponsiblePartyUid,LD.SuperbillProcedureUid,cteSB.SuperbillUid,LD.LiabilityOwner,ARB.GLDate
	  HAVING SUM(Amount) <> 0  	  
),
cteAge as 
(
	  SELECT 
	  cteSB.AccountResponsiblePartyUid,
	  LD.SuperbillProcedureUid,
	  arb.gldate,DATEDIFF(d, ARB.GLDate,GetDate()) as AgingDays
      FROM cteSuperbillList cteSB 
            INNER JOIN SuperbillProcedure (NOLOCK) SBP ON cteSB.SuperbillUid = SBP.SuperbillUid
			INNER JOIN AR_LedgerDetail (NOLOCK)  LD on LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid       
            INNER JOIN AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid  
			INNER JOIN ARBatch (NOLOCK) ARB ON L.ArbatchUid = ARB.ArbatchUid 
      WHERE NOT LD.SuperbillProcedureUid IS NULL  
			AND LD.LiabilityOwner = 0 	
			and cteSB.AccountResponsiblePartyUid = @rpuid						
	  group by cteSB.AccountResponsiblePartyUid,ARB.GLDate,--SB.ExternalID,
	  LD.SuperbillProcedureUid
)

, cte as
(
	select
	ROW_NUMBER() OVER(partition by cte.AccountResponsiblePartyUid order by Max(agingDays) desc ) AS Row,
	cte.accountresponsiblepartyuid,cte.superbillprocedureuid,liabilityamount
	,Max(agingDays) as age	
	FROM cteAgeLiability cte
	inner join cteAge age on age.superbillprocedureuid = cte.superbillprocedureuid and age.gldate = cte.gldate
    group by cte.accountresponsiblepartyuid,cte.superbillprocedureuid,cte.gldate,liabilityamount
)
, cteRunningTotal as
(
	SELECT x.accountresponsiblepartyuid,x.row,x.age, sum(y.liabilityamount) as runningtotal  
	FROM cte X, cte y 
	where y.row <= x.row and x.accountresponsiblepartyuid = y.accountresponsiblepartyuid
	group by x.accountresponsiblepartyuid,x.row,x.age
)
,ctePositiveLiability as
(
	select accountresponsiblepartyuid,row,age,runningtotal,
	ROW_NUMBER() OVER(partition by cteRunningTotal.AccountResponsiblePartyUid order by row asc ) AS Row2
	from cteRunningTotal
	where runningtotal >= 0
)
, cteFinalAge as
(
 select top (1) age from ctePositiveLiability
 where accountresponsiblepartyuid = @RPUid
 and ((runningtotal > 0 and row2 = (select top(1) row2 from ctePositiveLiability where RunningTotal = 0  and accountresponsiblepartyuid = @RPuid order by row desc) + 1) or row2 = 1)
 order by row desc
)


 SELECT @Age = age from cteFinalAge
 
RETURN @Age

END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getStatementDunningMsgByFinancialCenter]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- 20160505 kculberth bug 49049 pass @RPUid and @FinancialCenterUid to getSuperbillAgeByFinancialCenter

CREATE FUNCTION [dbo].[getStatementDunningMsgByFinancialCenter]
 (@RPUid uniqueidentifier,
  @FinancialCenterUid uniqueidentifier)
RETURNS varchar(300) AS 
BEGIN

--set @RPUid=''9c3a58bb-a670-469e-b551-2858d2e6bf32''
--set @StatementBatchDetailUid=''7B31785A-A801-4E5E-B0C4-3BCB568CA0BE''

DECLARE @DunningMsg VARCHAR(300)
DECLARE @Age INT 

select @Age = dbo.getSuperbillAgeByFinancialCenter(@RPUid,@FinancialCenterUid)
--print @age

	select @DunningMsg = (CASE WHEN @Age <=30 AND LEN(Dn.DunningMsg1) >0 THEN ''0-30 Days: ''+ Dn.DunningMsg1
	WHEN @Age >=31 AND @Age <=60  AND LEN(Dn.DunningMsg2) >0 THEN ''31-60 Days: ''+ Dn.DunningMsg2
	WHEN @Age >=61 AND @Age <=90 AND LEN(Dn.DunningMsg3) >0 THEN ''61-90 Days: ''+ Dn.DunningMsg3
	WHEN @Age >=91 AND @Age <=120 AND LEN(Dn.DunningMsg4) >0 THEN ''91-120 Days: ''+ Dn.DunningMsg4
	WHEN @Age >=121 AND LEN(Dn.DunningMsg5) >0 THEN ''121 + Days: ''+ Dn.DunningMsg5
	ELSE ''''
	END) 
	FROM  FinancialCenter fc (nolock) 
	INNER JOIN StatementBatchDetail sbd WITH (NOLOCK) on sbd.FinancialCenterUid = fc.FinancialCenterUid
	LEFT JOIN DunningMsgs Dn (nolock) ON fc.DunningMsgsUid=Dn.DunningMsgsUid
	where fc.FinancialCenterUid = @FinancialCenterUid
	--where sbd.StatementBatchDetailUid = @StatementBatchDetailUid 
RETURN  @DunningMsg

END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetSuperbillBalanceAll]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[GetSuperbillBalanceAll]
(
	@superbillUid uniqueidentifier
)
RETURNS
	money
AS
BEGIN
	DECLARE	@superbillBalance money
	SELECT @superbillBalance = LiabilityBalance - AssignedLiabilityBalance
		FROM AR_ViewSuperbillAggregate
		WHERE SuperbillUid = @superbillUid
	 RETURN ISNULL(@superbillBalance, 0)
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetSuperbillClaimingProviderSignatureUid]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetSuperbillClaimingProviderSignatureUid]
	(@superbillUid UNIQUEIDENTIFIER) 
RETURNS UNIQUEIDENTIFIER AS
BEGIN
	-- Pulls the appropriate signature record for a superbill
	-- can not return an image in function so just return the record id
	
	DECLARE @claimingProviderUid UNIQUEIDENTIFIER
	DECLARE @superbillServiceDateStart DATETIME
	DECLARE @superbillServiceDateEnd DATETIME
	DECLARE @retVal UNIQUEIDENTIFIER

	IF EXISTS(SELECT SuperbillUid FROM Superbill WHERE SuperbillUid = @superbillUid) -- if superbill exists
	BEGIN
		-- get superbill service start and end dates along with claiming provider
		SELECT @claimingProviderUid = VSFD.ClaimingProviderUid, @superbillServiceDateStart = SB.ServiceDateStart, 
				@superbillServiceDateEnd = SB.ServiceDateEnd
			FROM Superbill SB INNER JOIN ViewSuperbillFinancialDetails VSFD ON SB.SuperbillUid = VSFD.SuperbillUid
			WHERE SB.SuperbillUid = @superbillUid  
		-- get signature record based upon most current in service range
		SELECT @RETVAL = PS.ProviderSignatureUid 
			FROM (SELECT TOP 1 ProviderSignatureUid FROM ProviderSignature
				WHERE DATEPART(yyyy,LastModifiedDate) = DATEPART(yyyy,@superbillServiceDateStart) 
					AND  DATEPART(dy,LastModifiedDate) = DATEPART(dy,@superbillServiceDateStart) 
					AND ProviderUid = @claimingProviderUid ) PS
		-- if nothing in service range
		IF (@RETVAL IS NULL)
			-- get most current signature record by default
			SELECT @RETVAL = PS.ProviderSignatureUid 
				FROM (SELECT TOP 1 ProviderSignatureUid FROM ProviderSignature
					WHERE ProviderUid = @claimingProviderUid ) PS
	END

	RETURN @retVal
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetSuperbillCurrentInsurancePlan]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetSuperbillCurrentInsurancePlan]
(
	@superbillUid uniqueidentifier
)
RETURNS
	uniqueidentifier
AS
BEGIN
    DECLARE @insurancePlanUid uniqueidentifier
	SELECT  @insurancePlanUid = CurrentInsurancePlanUid
	FROM	SuperbillAggregate
	WHERE	SuperbillUid = @superbillUid
    RETURN @insurancePlanUid
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getSuperbillOfResponsibleParty]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE FUNCTION [dbo].[getSuperbillOfResponsibleParty] 
(@RPUid UNIQUEIDENTIFIER)  
RETURNS Varchar(1000) AS  
BEGIN 
	DECLARE 	@SBid 		VARCHAR(MAX)
	
---*OLD*vvv*OLD*vvv*OLD*vvv*OLD*vvv*OLD*vvv*OLD*vvv*OLD*vvv*OLD*vvv*OLD*vvv*OLD*vvv*OLD*vvv*OLD*vvv*OLD*vvv*OLD*vvv
	
----DECLARE 	@Cnt 		BIT
----	DECLARE 	@temp 	VARCHAR(50)
----	DECLARE 	@SSDate		DATETIME
----	DECLARE @InsuranceBalanceOnly BIT
----	DECLARE @CompleteBatch BIT 
----SET QUOTED_IDENTIFIER ON

----SET @CompleteBatch = 0

----	SELECT TOP 1 @InsuranceBalanceOnly=InsuranceBalanceOnlySuperbills FROM PracticeSettings
----	SET @Cnt = 0

----	DECLARE Cur_RPSuperBills Cursor FOR
----	SELECT DISTINCT S.ExternalID, S.ServiceDateStart 
----	FROM
----		Superbill S
----	INNER JOIN
----		Account A
----	ON
----		S.AccountUid = A.AccountUid
----	LEFT JOIN 
----		ViewStatementSuperbillBalance VS WITH (NOEXPAND)
----	ON 
----		VS.RPUid = @RPUid and VS.SuperbillUid = S.SuperbillUid	
----	WHERE 
----		A.AccountResponsiblePartyUid = @RPUid
----	AND	VS.LiabilityBalance <> 0
----	AND ((SELECT TOP 1 InsuranceBalanceOnlySuperbills FROM PracticeSettings)=1 
----		OR 
----         (VS.Patient is not null and VS.Patient!=0)
----		)
----	ORDER BY S.ServiceDateStart DESC		

----	OPEN Cur_RPSuperBills
----	FETCH NEXT FROM Cur_RPSuperBills INTO @temp, @SSDate

----	WHILE @@FETCH_STATUS = 0
----	BEGIN
----		SET @SBid = CASE  
----			WHEN @Cnt = 0 THEN @temp
----			WHEN @Cnt = 1 THEN @SBid + '', ''+@temp
----		END
----		FETCH NEXT FROM Cur_RPSuperBills INTO @temp, @SSDate
----	SET 	@Cnt = 1
----	END

----	CLOSE Cur_RPSuperBills
----	DEALLOCATE Cur_RPSuperBills

----	Return @SBid
----END
---*OLD*^^^*OLD*^^^*OLD*^^^*OLD*^^^*OLD*^^^*OLD*^^^*OLD*^^^*OLD*^^^*OLD*^^^*OLD*^^^*OLD*^^^*OLD*^^^*OLD*^^^*OLD*^^^


---*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv

	SET @SBid = (
	SELECT distinct
    --A.accountresponsiblepartyuid,
    STUFF
    (
        (	select
            '', '' + superbill.ExternalID
			FROM 		Superbill (NOLOCK)
			LEFT JOIN ViewStatementSuperbillBalanceExcludeStatus VS
			ON VS.SuperbillUid = Superbill.SuperbillUid	
			WHERE 
				VS.LiabilityBalance <> 0
				AND (
					(SELECT TOP 1 InsuranceBalanceOnlySuperbills FROM PracticeSettings (NOLOCK)) = 1
					OR 
					 (VS.Patient is not null and VS.Patient!=0)
					)	
				AND Superbill.SuperbillUid = vs.superbilluid
				AND VS.RPUid = @RPUid	    	
            ORDER BY Superbill.ServiceDateStart DESC	
            FOR XML PATH('''')
        ), 1, 1, ''''
    ) AS Superbills
	FROM Account (NOLOCK) A 
	WHERE A.AccountResponsiblePartyUid = @RPUID)
	
	RETURN @SBID
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getSuperbillOfResponsibleParty_MainAccount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

--10/14/2014 - kculberth - updated logic to match regular statements by practice

CREATE FUNCTION [dbo].[getSuperbillOfResponsibleParty_MainAccount] 
(@RPUid UNIQUEIDENTIFIER)  
RETURNS Varchar(1000) AS  
BEGIN 
	DECLARE 	@SBid 		VARCHAR(MAX)
	

	SET @SBid = (
	SELECT distinct
    --A.accountresponsiblepartyuid,
    STUFF
    (
        (	select
            '', '' + Superbill.ExternalID
			FROM Superbill (NOLOCK)
			LEFT JOIN ViewStatementSuperbillBalanceExcludeStatus VS
			ON VS.SuperbillUid = Superbill.SuperbillUid	
			inner join account (NOLOCK) acct on acct.accountuid = Superbill.AccountUid
			WHERE 
				VS.LiabilityBalance <> 0
				AND (
					(SELECT TOP 1 InsuranceBalanceOnlySuperbills FROM PracticeSettings (NOLOCK)) = 1
					OR 
					 (VS.Patient is not null and VS.Patient!=0)
					)	
				AND Superbill.SuperbillUid = vs.superbilluid
				AND VS.RPUid = @RPUid
				and acct.IsMain = 1  	    	
            ORDER BY Superbill.ServiceDateStart DESC	
            FOR XML PATH('''')
        ), 1, 1, ''''
    ) AS Superbills
	FROM Account (NOLOCK) A 
	--WHERE A.AccountResponsiblePartyUid = @RPUID
	--and A.IsMain = 1
	)
	
	RETURN @SBID
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getSuperbillOfResponsiblePartyByFinancialCenter]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'






CREATE FUNCTION [dbo].[getSuperbillOfResponsiblePartyByFinancialCenter]   
(@RPUid UNIQUEIDENTIFIER,  
 @FCUid UNIQUEIDENTIFIER,
 @StatementBatchDetailUid UNIQUEIDENTIFIER  
 )   
RETURNS Varchar(1000) AS  
BEGIN 
	DECLARE 	@SBid 		VARCHAR(MAX)

---*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv*NEW*vvv

	--;WITH cte_superbills as (
	--	--select sbds.SuperbillUid,sbd.accountresponsiblepartyuid,sbd.financialcenteruid,sbds.PatientBalance,sbds.InsuranceBalance,sb.ExternalID,sb.ServiceDateStart
	--	select sbds.SuperbillUid,sbd.accountresponsiblepartyuid,sbd.financialcenteruid,sbds.PatientBalance,sbds.InsuranceBalance
	--	from StatementBatchDetailSuperbill (NOLOCK) sbds 
	--	inner join StatementBatchDetail (NOLOCK) sbd on sbd.StatementBatchDetailUid = sbds.StatementBatchDetailUid
	--	--inner join Superbill (NOLOCK) sb on sb.SuperbillUid = sbds.SuperbillUid
	--	where sbds.StatementBatchDetailUid = @StatementBatchDetailUid
	--		and sbd.AccountResponsiblePartyUid = @RPUid
	--		and sbd.FinancialCenterUid = @FCUid
	--)
declare @insbalonly int
set @insbalonly = (SELECT TOP 1 InsuranceBalanceOnlySuperbills FROM FinancialCenter (NOLOCK) where FinancialCenter.FinancialCenterUid = @FCUid)
	SELECT @SBid = (
	SELECT distinct
    --A.accountresponsiblepartyuid,
    STUFF
    (
        (	select
            '', '' + sb.ExternalID
			from StatementBatchDetailSuperbill (NOLOCK) sbds 
			inner join StatementBatchDetail (NOLOCK) sbd on sbd.StatementBatchDetailUid = sbds.StatementBatchDetailUid
			INNER JOIN Superbill (NOLOCK) SB on sb.superbilluid = sbds.superbilluid
			--LEFT JOIN ViewStatementSuperbillBalanceByFinancialCenterExcludeStatus VS 
			--ON VS.SuperbillUid = Superbill.SuperbillUid	
			WHERE 
				sbds.PatientBalance+sbds.insurancebalance <> 0
				--VS.LiabilityBalance <> 0
				AND (
					(@insbalonly = 1
					OR 
						sbds.PatientBalance <> 0)
					 --(VS.Patient is not null and VS.Patient!=0)
					)	
				AND 
				sbds.StatementBatchDetailUid = @StatementBatchDetailUid
				--AND Superbill.SuperbillUid = vs.superbilluid
				AND sbd.AccountResponsiblePartyUid = @RPUid and sbd.FinancialCenterUid = @FCUid	    	
            ORDER BY sb.ServiceDateStart DESC	
            FOR XML PATH('''')
        ), 1, 1, ''''
    ) AS Superbills
	)
	--FROM Account (NOLOCK) A 
	--WHERE A.AccountResponsiblePartyUid = @RPUID)
	
	RETURN @SBID
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getSuperbillOfResponsiblePartyStatementBatch]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

-- 20150924 kculberth incorporate performance improvements by utilizing StatementBatchDetailUid to narrow dataset and moving dunning logic to Header

CREATE FUNCTION [dbo].[getSuperbillOfResponsiblePartyStatementBatch] 
(@RPUid UNIQUEIDENTIFIER, @StatementBatchDetailUid UNIQUEIDENTIFIER)  
RETURNS Varchar(1000) AS  
BEGIN 
	DECLARE 	@SBid 		VARCHAR(MAX)
	

	SET @SBid = (
	--SELECT distinct
    --A.accountresponsiblepartyuid,
    STUFF
    (
        (	select
            '', '' + superbill.ExternalID
			FROM StatementBatchDetailSuperbill (NOLOCK) sbds 
			INNER JOIN Superbill (NOLOCK) on sbds.superbilluid = superbill.superbilluid 
			--ViewStatementSuperbillBalanceExcludeStatus VS
			WHERE 
				sbds.PatientBalance+sbds.insurancebalance <> 0
				AND (
					(SELECT TOP 1 InsuranceBalanceOnlySuperbills FROM PracticeSettings (NOLOCK)) = 1
					OR 
					 --(sbds.PatientBalance is not null and sbds.PatientBalance!=0)
					 (sbds.PatientBalance <> 0)
					)	
				 --Superbill.SuperbillUid = vs.superbilluid
				AND 
				StatementBatchDetailUid = @StatementBatchDetailUid	    	
            ORDER BY Superbill.ServiceDateStart DESC	
            FOR XML PATH('''')
        ), 1, 1, ''''
    ) --AS Superbills
	--FROM Account (NOLOCK) A 
	--WHERE A.AccountResponsiblePartyUid = @RPUID
	)
	
	RETURN @SBID
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getSuperbillOfResposibleParty]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[getSuperbillOfResposibleParty] 
(@RPUid UNIQUEIDENTIFIER,
 @FCUid UNIQUEIDENTIFIER

	)  
RETURNS Varchar(1000) AS  
BEGIN 
	DECLARE 	@SBid 		VARCHAR(MAX)
	DECLARE 	@Cnt 		BIT
	DECLARE 	@temp 	VARCHAR(50)
	DECLARE 	@SSDate		DATETIME
	DECLARE @InsuranceBalanceOnly BIT
	DECLARE @CompleteBatch BIT 
SET QUOTED_IDENTIFIER ON

	IF @FCUid  IS NULL
			SELECT TOP 1 @InsuranceBalanceOnly=InsuranceBalanceOnlySuperbills FROM PracticeSettings
	ELSE
			SELECT TOP 1 @InsuranceBalanceOnly=InsuranceBalanceOnlySuperbills FROM FinancialCenter WHERE FinancialCenterUid=@FCUid

	IF @FCUid  IS NULL
			SELECT TOP 1 @CompleteBatch=IncludeCompletedOrClosed FROM PracticeSettings
	ELSE
			SELECT TOP 1 @CompleteBatch=IncludeCompletedOrClosed FROM FinancialCenter WHERE FinancialCenterUid=@FCUid

	SET @Cnt = 0

	DECLARE Cur_RPSuperBills Cursor FOR
	SELECT DISTINCT S.ExternalID, S.ServiceDateStart 
	FROM
		Superbill S
	INNER JOIN
		Account A
	ON
		S.AccountUid = A.AccountUid
	INNER JOIN
		[ViewSuperbillFinancialDetails] VSF
	ON 
		S.SuperbillUid=VSF.SuperbillUid
	LEFT JOIN 
		ViewStatementSuperbillBalance VS WITH (NOEXPAND)
	ON 
		VS.RPUid = @RPUid and VS.SuperbillUid = S.SuperbillUid	
	INNER JOIN 
		[AR_ViewSuperbillCompleteBatch] VSC
	ON
		VSF.SuperbillUid = VSC.SuperbillUid
	WHERE 
		A.AccountResponsiblePartyUid = @RPUid
	AND	VS.LiabilityBalance <> 0
	AND (@FCUid IS NULL OR VSF.FinancialCenterUid=@FCUid)
	AND (@InsuranceBalanceOnly=1 
		OR 
         (VS.Patient is not null and VS.Patient!=0)
		)
	AND
		(@CompleteBatch =0 OR VSC.CompleteBatch=1)
	ORDER BY S.ServiceDateStart DESC		


	OPEN Cur_RPSuperBills
	FETCH NEXT FROM Cur_RPSuperBills INTO @temp, @SSDate

	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @SBid = CASE  
			WHEN @Cnt = 0 THEN @temp
			WHEN @Cnt = 1 THEN @SBid + '', ''+@temp
		END
		FETCH NEXT FROM Cur_RPSuperBills INTO @temp, @SSDate
	SET 	@Cnt = 1
	END

	CLOSE Cur_RPSuperBills
	DEALLOCATE Cur_RPSuperBills

	Return @SBid
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getSuperbillOfResposibleParty_MainAccount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[getSuperbillOfResposibleParty_MainAccount] 
(@RPUid UNIQUEIDENTIFIER,
 @FCUid UNIQUEIDENTIFIER
	)  
RETURNS Varchar(1000) AS  
BEGIN 
	DECLARE 	@SBid 		VARCHAR(MAX)
	DECLARE 	@Cnt 		BIT
	DECLARE 	@temp 	VARCHAR(50)
	DECLARE 	@SSDate		DATETIME
	DECLARE @InsuranceBalanceOnly BIT
	DECLARE @CompleteBatch BIT 
SET QUOTED_IDENTIFIER ON
	IF @FCUid  IS NULL
			SELECT TOP 1 @InsuranceBalanceOnly=InsuranceBalanceOnlySuperbills FROM PracticeSettings
	ELSE
			SELECT TOP 1 @InsuranceBalanceOnly=InsuranceBalanceOnlySuperbills FROM FinancialCenter WHERE FinancialCenterUid=@FCUid
		
	IF @FCUid  IS NULL
			SELECT TOP 1 @CompleteBatch=IncludeCompletedOrClosed FROM PracticeSettings
	ELSE
			SELECT TOP 1 @CompleteBatch=IncludeCompletedOrClosed FROM FinancialCenter WHERE FinancialCenterUid=@FCUid

	SET @Cnt = 0

	DECLARE Cur_RPSuperBills Cursor FOR
	SELECT DISTINCT S.ExternalID, S.ServiceDateStart 
	--FROM Superbill
	--INNER JOIN ARContext ON Superbill.SuperbillUid = ARcontext.SuperbillUid
	--INNER JOIN Charge ON Charge.ARContextUid = ARContext.ARContextUid
	--INNER JOIN ViewARChargeAggregate vaca on Charge.ChargeUid = vaca.ChargeUid
	--INNER JOIN Account ON ARContext.AccountUid = Account.AccountUid
	--LEFT JOIN ViewStatementSuperbillBalance ON ViewStatementSuperbillBalance.RPUid = @RPUid and ViewStatementSuperbillBalance.SuperbillUid = Superbill.SuperbillUid
	FROM
		AR_Ledger L
	INNER JOIN
		AR_LedgerDetail LD
	ON
		L.LedgerUid=LD.LedgerUid AND L.EntryType=1 AND LD.IsCredit=0
	INNER JOIN
		AR_ViewSuperbillProcedureAggregate VSP
	ON
		LD.SuperbillProcedureUid= VSP.SuperbillProcedureUid
	INNER JOIN
		SuperbillProcedure SP
	ON
		SP.SuperbillProcedureUid=LD.SuperbillProcedureUid
	INNER JOIN
		Superbill S
	ON
		S.SuperbillUid=SP.SuperbillUid
	INNER JOIN
		Account A
	ON
		S.AccountUid = A.AccountUid
	LEFT JOIN 
		ViewStatementSuperbillBalance VS WITH (NOEXPAND)
	ON 
		VS.RPUid = @RPUid and VS.SuperbillUid = S.SuperbillUid	
	INNER JOIN 
		[AR_ViewSuperbillCompleteBatch] VSC
	ON
		VS.SuperbillUid = VSC.SuperbillUid
	WHERE 
		A.AccountResponsiblePartyUid = @RPUid
	AND	A.ISMAIN=1		
	AND	VSP.LiabilityBalance <> 0
	AND (@FCUid IS NULL OR LD.FinancialCenterUid=@FCUid)
	AND (@InsuranceBalanceOnly=1 
		OR 
         (VS.Patient is not null and VS.Patient!=0)
		)
	AND
		(@CompleteBatch =0 OR VSC.CompleteBatch=1)
	ORDER BY S.ServiceDateStart DESC		
	--WHERE 
	--	Account.AccountResponsiblePartyUid = @RPUid
	--AND	vaca.BalanceAll > 0
	--AND Charge.ARLockUid is null
	--AND ARContext.Inactive = 0
	--AND (@FCUid IS NULL OR Superbill.FinancialCenterUid=@FCUid)
	--AND (@InsuranceBalanceOnly=1 
	--	OR 
 --        (ViewStatementSuperbillBalance.Patient is not null and ViewStatementSuperbillBalance.Patient!=0)
	--	)
	----And Charge.LiabilityDate <= Dateadd(dd,-30,GetUTCdate())))
	--ORDER BY Superbill.ServiceDateStart DESC

	OPEN Cur_RPSuperBills
	FETCH NEXT FROM Cur_RPSuperBills INTO @temp, @SSDate

	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @SBid = CASE  
			WHEN @Cnt = 0 THEN @temp
			WHEN @Cnt = 1 THEN @SBid + '', ''+@temp
		END
		FETCH NEXT FROM Cur_RPSuperBills INTO @temp, @SSDate
	SET 	@Cnt = 1
	END

	CLOSE Cur_RPSuperBills
	DEALLOCATE Cur_RPSuperBills

	Return @SBid
END









' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetSuperbillProcedureRowNumber]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[GetSuperbillProcedureRowNumber] (@superbillProcedureUid uniqueidentifier) RETURNS int AS
	BEGIN
	
	DECLARE @rowNum int
	
	DECLARE @rowCntSBP TABLE
	(
		rowCnt int,
		superbillProcedureUid uniqueidentifier
    );
    
	INSERT INTO @rowCntSBP( rowCnt, superbillProcedureUid )
		SELECT ROW_NUMBER() OVER ( ORDER BY sbp2.DisplayOrder), 
		       sbp2.SuperbillProcedureUid 
		FROM SuperbillProcedure sbp with (nolock)
				INNER JOIN Superbill sb with (nolock) on sbp.SuperbillProcedureUid = @superbillProcedureUid
																AND sbp.SuperbillUid = sb.SuperbillUid
				INNER JOIN SuperbillProcedure sbp2 with (nolock) on sb.SuperbillUid = sbp2.SuperbillUid
				
	select @rowNum = rc.rowCnt
	from @rowCntSBP rc
	where rc.superbillProcedureUid = @superbillProcedureUid
	
	RETURN @rowNum
	END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetUserGroups]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetUserGroups]
	(
	@UserUid UniqueIdentifier
	)
RETURNS @UserGroup TABLE (	UserGroupUid UniqueIdentifier,
							Name VARCHAR(100))
AS
BEGIN
	INSERT @UserGroup
	VALUES (''{00000101-0000-0000-0000-000000000000}'', ''Everyone'')

	INSERT			@UserGroup
	SELECT DISTINCT ugm.UserGroupUid, ug.Name
	FROM			UserGroupMember ugm INNER JOIN ListUserGroup ug ON ugm.UserGroupUid = ug.UserGroupUId
	WHERE			ugm.MemberUserUid = @UserUid 

	WHILE @@ROWCOUNT > 0
	BEGIN
		INSERT				@UserGroup
		SELECT	DISTINCT	ugm.UserGroupUid, ug.Name
		FROM				@UserGroup ugcurrent INNER JOIN UserGroupMember ugm ON ugcurrent.UserGroupUid = ugm.MemberUserGroupUid
							INNER JOIN ListUserGroup ug ON ugm.UserGroupUid = ug.UserGroupUid
		WHERE				NOT ugm.UserGroupUid IN (SELECT UserGroupUid FROM @UserGroup)
	END

	RETURN
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getUTCDateTime]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE function [dbo].[getUTCDateTime]  
 (@inLocaleDateTime datetime,  -- the time to convert to local (should be a local datetime value)  
 @inTimeZoneAdj int,   -- the number of hours to adjust for the local timezone  
 @bObserveDaylightSavings tinyint) -- whether or not the local area observes US daylight savings time  
 returns datetime as
BEGIN
return dbo.Date_LocalToUTC(@inLocaleDateTime,@inTimeZoneAdj,@bObserveDaylightSavings)
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetVoiceAttachmentStatus]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetVoiceAttachmentStatus] 
(
	@dateRecorded datetime,
    @dateSent datetime,
    @dateReceived datetime,
    @dateMerged datetime,
	@readyToTranscribe bit
)  
RETURNS VARCHAR(25)  
AS

BEGIN
	
	DECLARE @status varchar(25)
	SET @status = NULL

	IF NOT @dateMerged IS NULL
		SET @status = ''Merged''
	ELSE
	BEGIN
		IF NOT @dateReceived IS NULL
			SET @status = ''Received''
		ELSE
		BEGIN
			IF NOT @dateSent IS NULL
				SET @status = ''Sent''
			ELSE
			BEGIN
				IF NOT @dateRecorded IS NULL
				BEGIN
					SET @status = ''Recorded''
					IF (@readyToTranscribe = 0)
						SET @status = ''Not ready to transcribe''
				END
				ELSE
					SET @status = NULL
			END
		END
	END

	RETURN @status

END



' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[HashString]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[HashString](@src [nvarchar](1024))
RETURNS [nvarchar](max) WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[HashString]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[HexStrToVarBin]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[HexStrToVarBin](@hexstr varchar(8000)) 
RETURNS varbinary(8000) 
AS 
BEGIN 
    DECLARE @hex char(2), @i int, @count int, @b varbinary(8000) 
    SET @count = LEN(@hexstr) 
    SET @b = CAST('''' as varbinary(1)) 
    IF SUBSTRING(@hexstr, 1, 2) = ''0x'' 
        SET @i = 3 
    ELSE 
        SET @i = 1 
    WHILE (@i <= @count) 
     BEGIN 
        SET @hex = SUBSTRING(@hexstr, @i, 2) 
        SET @b = @b + 
                CAST(CASE WHEN SUBSTRING(@hex, 1, 1) LIKE ''[0-9]'' 
                    THEN CAST(SUBSTRING(@hex, 1, 1) as int) 
                    ELSE CAST(ASCII(UPPER(SUBSTRING(@hex, 1, 1)))-55 as int) 
                END * 16 + 
                CASE WHEN SUBSTRING(@hex, 2, 1) LIKE ''[0-9]'' 
                    THEN CAST(SUBSTRING(@hex, 2, 1) as int) 
                    ELSE CAST(ASCII(UPPER(SUBSTRING(@hex, 2, 1)))-55 as int) 
                END as binary(1)) 
        SET @i = @i + 2 
     END 
    RETURN @b 
END ' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Hl7_GetClientID_Sunrise]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE Function [dbo].[Hl7_GetClientID_Sunrise]()
	Returns Varchar(100)
As
Begin
	Declare @ClientID Varchar(6)

	Select @ClientID= C.Value From ClaimFormatValue C  Join ListClaimFormatValueType CF on C.ClaimFormatValueTypeUID=CF.ClaimFormatValueTypeUID
		Where CF.Name=''Sunrise Client ID''
	
	If (Len(@ClientID)<6)
		Set @ClientID=Left(''000000'',6-Len(@ClientId)) + @ClientID

	Return @ClientID
End

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[hl7FindTerminator]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =============================================
-- Author:		Kevin Crumpton
-- Create date: 
-- Description:	Returns a field from a segment
--
-- Known Issues: Assumes fields are separated
--				 by bars ''|''
-- =============================================
CREATE FUNCTION [dbo].[hl7FindTerminator] 
(
	-- Add the parameters for the function here
	@Segment varchar(8000)
)
RETURNS int
AS
BEGIN
	IF @Segment IS NULL OR
		len(@Segment) <= 0
	BEGIN
		GOTO the_end
	END

	DECLARE @Cr varchar(1)
	SELECT @Cr = char(13)

	DECLARE @Lf varchar(1)
	SELECT @Lf = char(10)

	DECLARE @CrLf varchar(2)
	SELECT @CrLf = @Cr + @Lf

	DECLARE @n INT
	SELECT @n = -1

	--lets look for likely terminators for end of segment and cut it off if we can
	DECLARE @end INT
	SELECT @end = -1

	SELECT @end = charindex(@CrLf, @Segment)

	IF isnull(@end,-1) <= 0
	BEGIN
		--LOOK FOR CR, IF CRLF NOT FOUND
		SELECT @end = charindex(@Cr, @Segment)
	END

	IF isnull(@end,-1) <= 0
	BEGIN
		--LOOK FOR LF, IF CRLF and CR NOT FOUND
		SELECT @end = charindex(@Lf, @Segment)
	END

	RETURN @end

	the_end:

	RETURN -1

END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[hl7FindField]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =============================================
-- Author:		Kevin Crumpton
-- Create date: 
-- Description:	Returns a field from a segment
--
-- Known Issues: Assumes fields are separated
--				 by bars ''|''
-- =============================================
CREATE FUNCTION [dbo].[hl7FindField] 
(
	-- Add the parameters for the function here
	@Segment varchar(8000),
	@FieldNum int
)
RETURNS varchar(8000)
AS
BEGIN
	-- Declare the return variable here
	DECLARE @Ret varchar(8000)
	SELECT @Ret = ''''

	DECLARE @FS varchar(1)
	SELECT @FS = ''|''

--	SELECT TOP 1 @msg = convert(varchar(8000),rawmessage) FROM HL7Message WHERE isnull( convert(varchar(8000),rawmessage),'''') <> ''''
--	SELECT @Segment = ''PID''

	IF @Segment IS NULL OR
		@FieldNum IS NULL OR
		len(@Segment) <= 0 OR
		@FieldNum < 0
	BEGIN
		GOTO the_end
	END

	DECLARE @Cr varchar(1)
	SELECT @Cr = char(13)

	DECLARE @Lf varchar(1)
	SELECT @Lf = char(10)

	DECLARE @CrLf varchar(2)
	SELECT @CrLf = @Cr + @Lf

	DECLARE @n INT
	SELECT @n = -1

--	IF isnull(@n,-1) < 0
--		GOTO the_end

--	SELECT @Ret = SUBSTRING(@Segment, @n, len(@Segment) - @n)

	--lets look for likely terminators for end of segment and cut it off if we can
	DECLARE @end INT
	SELECT @end = -1

	SELECT @end = charindex(@CrLf, @Segment)

	IF isnull(@end,-1) <= 0
	BEGIN
		--LOOK FOR CR, IF CRLF NOT FOUND
		SELECT @end = charindex(@Cr, @Segment)
	END



	IF isnull(@end,-1) <= 0
	BEGIN
		--LOOK FOR LF, IF CRLF and CR NOT FOUND
		SELECT @end = charindex(@Lf, @Segment)
	END


	IF isnull(@end,-1) > 0
	BEGIN
		--IF WE FOUND A LINE TERMINATOR, TRUNCATE SEGMENT AT TERMINATOR
		SELECT @Segment = SUBSTRING(@Segment, 0, @end)
	END

	

	DECLARE @i INT
	SELECT @i = 1
	
	WHILE @i <= @FieldNum
	BEGIN
		SELECT @n = CHARINDEX(@FS, @Segment)

		-- not enough fields found before hitting end of segment
		IF isnull(@n,-1) < 0
			GOTO the_end

		SELECT @Segment = SUBSTRING(@Segment, @n + 1, len(@Segment) - (@n))
		SELECT @i = @i + 1
	END

	-- TRIM ANYTHING PAST SEGMENT TERMINATOR IN CASE THIS FIELD IS THE LAST FIELD
	SELECT @n = dbo.hl7FindTerminator(@Segment)
	IF isnull(@n,-1) > 0
		SELECT @Segment = SUBSTRING(@Segment, 0, @n)
	
	SELECT @n = charindex(@FS, @Segment)
	
	-- truncate return value at end of field
	IF isnull(@n,-1) > 0
		SELECT @Segment = SUBSTRING(@Segment, 0, @n)
	
	SELECT @ret = @segment

	the_end:

	-- Return the result of the function
	RETURN @Ret

END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[hl7FindSegment]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =============================================
-- Author:		Kevin Crumpton
-- Create date: 
-- Description:	Returns a segment from a message
--
-- Known Issues: If a field ends with the value
--				of the segment you are searching
--				for, then you may not get the 
--			    beginning of the appropriate
--				segment. Instead, your return
--				value will be the end of the field
--				that matches:
--					@Segment + ''|''
--
--				If multiple segments of same kind,
--				only first one found is returned
-- =============================================
CREATE FUNCTION [dbo].[hl7FindSegment] 
(
	-- Add the parameters for the function here
	@Msg varchar(8000),
	@Segment varchar(8000)
)
RETURNS varchar(8000)
AS
BEGIN
	-- Declare the return variable here
	DECLARE @Ret varchar(8000)

--	DECLARE @Msg varchar(8000)
--	DECLARE @Segment varchar(20)
--	DECLARE @Ret varchar(8000)
--	DECLARE @Debug INT
--	SELECT @Debug = 1

	SELECT @Ret = ''''

--	SELECT TOP 1 @msg = convert(varchar(8000),rawmessage) FROM HL7Message WHERE isnull( convert(varchar(8000),rawmessage),'''') <> ''''
--	SELECT @Segment = ''PID''

	IF @Msg IS NULL OR
		@Segment IS NULL OR
		len(@msg) <= 0 OR
		len(@segment) <= 0
	BEGIN
		GOTO the_end
	END

	DECLARE @Cr varchar(1)
	SELECT @Cr = char(13)

	DECLARE @Lf varchar(1)
	SELECT @Lf = char(10)

	DECLARE @CrLf varchar(2)
	SELECT @CrLf = @Cr + @Lf

	DECLARE @n INT
	SELECT @n = -1

	IF RIGHT(@Segment,1) <> ''|''
		SELECT @Segment = @Segment + ''|''

	SELECT @n = CHARINDEX(@Segment, @Msg) 

	IF isnull(@n,-1) <= 0
		GOTO the_end

	SELECT @Ret = SUBSTRING(@Msg, @n, len(@Msg) - @n)

	--lets look for likely terminators for end of segment and cut it off if we can
	DECLARE @end INT
	SELECT @end = -1

	SELECT @end = charindex(@CrLf, @Ret)

--	IF @Debug = 1
--		PRINT ''CRLF END='' + CONVERT(VARCHAR(20), @end)

	IF isnull(@end,-1) <= 0
	BEGIN
		--LOOK FOR CR, IF CRLF NOT FOUND
		SELECT @end = charindex(@Cr, @Ret)
		
--		IF @Debug = 1
--			PRINT ''CR END='' + CONVERT(VARCHAR(20), @end)

	END



	IF isnull(@end,-1) <= 0
	BEGIN
		--LOOK FOR LF, IF CRLF and CR NOT FOUND
		SELECT @end = charindex(@Lf, @Ret)
		
--		IF @Debug = 1
--			PRINT ''LF END='' + CONVERT(VARCHAR(20), @end)
	END

	IF isnull(@end,-1) <= 0
	BEGIN
		--IF WE HAVEN''T FOUND IT BY NOW, THEN JUST RETURN THE REMAINING PART OF THE MSG
		GOTO THE_END
	END

	SELECT @Ret = SUBSTRING(@Ret, 0, @end)

	the_end:

--	IF @Debug = 1
--	BEGIN
--		PRINT ''*****************************''
--		PRINT @Msg
--		PRINT ''*****************************''
--		PRINT @Ret
--	END

	-- Return the result of the function
	RETURN @Ret

END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[hl7FindSubcomponent]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =============================================
-- Author:		Kevin Crumpton
-- Create date: 
-- Description:	Returns a field from a segment
--
-- Known Issues: Assumes subcomponents are separated
--				 by carats ''^''
--				 Counting starts with 1
-- =============================================
CREATE FUNCTION [dbo].[hl7FindSubcomponent] 
(
	-- Add the parameters for the function here
	@Segment varchar(8000),
	@FieldNum int
)
RETURNS varchar(8000)
AS
BEGIN
	-- Declare the return variable here
	DECLARE @Ret varchar(8000)
	SELECT @Ret = ''''

	DECLARE @FS varchar(1)
	SELECT @FS = ''^''


	IF @Segment IS NULL OR
		@FieldNum IS NULL OR
		len(@Segment) <= 0 OR
		@FieldNum <= 0
	BEGIN
		GOTO the_end
	END

	DECLARE @Cr varchar(1)
	SELECT @Cr = char(13)

	DECLARE @Lf varchar(1)
	SELECT @Lf = char(10)

	DECLARE @CrLf varchar(2)
	SELECT @CrLf = @Cr + @Lf

	DECLARE @n INT
	SELECT @n = -1


	--lets look for likely terminators for end of segment and cut it off if we can
	DECLARE @end INT
	SELECT @end = -1

	SELECT @end = charindex(@CrLf, @Segment)

	IF isnull(@end,-1) <= 0
	BEGIN
		--LOOK FOR CR, IF CRLF NOT FOUND
		SELECT @end = charindex(@Cr, @Segment)
	END



	IF isnull(@end,-1) <= 0
	BEGIN
		--LOOK FOR LF, IF CRLF and CR NOT FOUND
		SELECT @end = charindex(@Lf, @Segment)
	END


	IF isnull(@end,-1) > 0
	BEGIN
		--IF WE FOUND A LINE TERMINATOR, TRUNCATE SEGMENT AT TERMINATOR
		SELECT @Segment = SUBSTRING(@Segment, 0, @end)
	END

	DECLARE @i INT
	SELECT @i = 1
	
	WHILE @i < @FieldNum
	BEGIN
		SELECT @n = CHARINDEX(@FS, @Segment)

		-- not enough fields found before hitting end of segment
		IF isnull(@n,-1) <= 0
			GOTO the_end

		SELECT @Segment = SUBSTRING(@Segment, @n + 1, len(@Segment) - (@n))
		SELECT @i = @i + 1
	END

	-- TRIM ANYTHING PAST SEGMENT TERMINATOR IN CASE THIS FIELD IS THE LAST FIELD
	SELECT @n = dbo.hl7FindTerminator(@Segment)
	IF isnull(@n,-1) > 0
		SELECT @Segment = SUBSTRING(@Segment, 0, @n)
	
	SELECT @n = charindex(@FS, @Segment)
	
	-- truncate return value at end of field
	IF isnull(@n,-1) > 0
		SELECT @Segment = SUBSTRING(@Segment, 0, @n)
	
	SELECT @ret = @segment

	the_end:

	-- Return the result of the function
	RETURN @Ret

END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[hl7GenerateObservationOrderHash]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- =============================================
-- Author:		Kevin Crumpton
-- Create date: 09/29/2008
-- Description:	Generates ObservationOrder hash
-- =============================================
CREATE FUNCTION [dbo].[hl7GenerateObservationOrderHash]
(
	-- Add the parameters for the function here
	@ObservationOrderUid uniqueidentifier
)
RETURNS varchar(2000)
AS
BEGIN
	-- Declare the return variable here
	DECLARE @Result varchar(2000)

	-- Add the T-SQL statements to compute the return value here
	--SELECT @Result = ObservationOrderUid

	SELECT @Result =
		''VisitUid:'' + isnull(convert(varchar(40), oo.visituid),''NULL'') + ''_'' +
		''LabUid:'' + isnull(convert(varchar(40), oo.laboratoryuid),''NULL'') + ''_'' +
		''AccNum:'' + isnull(oo.iMedicaAccessionNumber,''NULL'') + ''_'' +
		''PSC:'' + isnull(convert(varchar(10), oo.psc),''NULL'') + ''_'' +
		''BT:'' + isnull(convert(varchar(40),oo.billtypeuid), ''NULL'') + ''_'' +
		--''AO:'' + isnull(convert(varchar(10), DATEDIFF(dd, oo.OrderDate, v.VisitDate)),''NULL'') + ''_'' +
		''AO:'' + isnull(convert(varchar(20), oo.OrderDate, 112), ''NULL'') + ''_'' +    -- CMR: Just use order date (in place of the old days from visitdate)
		''QTemp:'' +
			CASE WHEN oo.LaboratoryUid<>''4524B6E9-2BE4-4E55-9389-514159A6F995'' THEN '''' --Return '''' if the lab is NOT Quest -- J.R. Bluett 20130122
				WHEN TemporaryQuestLabOrder.SplitCategory1 = ''FZ'' THEN convert(varchar(40), oo.ObservationOrderUid) --these all get separate accessions
				WHEN TemporaryQuestLabOrder.SplitCategory1 = ''RT'' AND TemporaryQuestLabOrder.SplitCategory2 = ''P''
						THEN convert(varchar(40), oo.ObservationOrderUid) --these all get separate accessions
				WHEN TemporaryQuestLabOrder.SplitCategory1 = ''RT'' OR TemporaryQuestLabOrder.SplitCategory1 = ''RF''
						THEN ''RTRF''  -- these can be combined into same accession
				ELSE '''' -- orders without a matching row in TemporaryQuestLabOrder or with SplitCategory other than those above can all be combined
			END	+ ''_'' +
		''SplitCat:'' + isnull(hsc.SplitCategory, ''NULL'') + ''_'' +
		''Ex:'' +   --subsection to handle option for forcing one accession per test
			CASE WHEN isnull(lpp.BoolValue,0) <> 0
					THEN convert(varchar(40), oo.ObservationOrderUid) --these all get separate accessions
				ELSE ''''
			END + ''_''
 	FROM ObservationOrder oo
 	    LEFT JOIN Visit v ON v.VisitUid = oo.VisitUid
		LEFT JOIN ListLaboratoryOrder llo ON oo.LaboratoryOrderUid = llo.LaboratoryOrderUid
		LEFT JOIN TemporaryQuestLabOrder ON llo.LabOrderCode = TemporaryQuestLabOrder.LabCode
		LEFT JOIN HL7OrderSplitCategory hsc ON hsc.LaboratoryUid = oo.LaboratoryUid and llo.LabOrderCode = hsc.LabOrderCode
		LEFT JOIN ListProductParameter lpp on lpp.ParameterName = ''GenerateOneAccessionPerTest'' AND
								lpp.GuidValue = oo.LaboratoryUid --this option setting is specific to each individual lab
	WHERE oo.ObservationOrderUid = @ObservationOrderUid

	-- Return the result of the function
	RETURN @Result

END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[hl7MessageDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[hl7MessageDate] 
(
	-- Add the parameters for the function here
	@RawMsg varchar(8000)
)
RETURNS datetime
AS
BEGIN
		IF @RawMsg IS NULL 
		BEGIN
			return null
		END

--		DECLARE @yr varchar(100)
--		DECLARE @mo varchar(100)
--		DECLARE @da varchar(100)
--
--		SELECT @yr = left(dbo.hl7findfield(dbo.hl7findsegment(@RawMsg,''msh''),6),4)
--		SELECT @mo = substring(dbo.hl7findfield(dbo.hl7findsegment(@RawMsg,''msh''),6), 5,2)
--		SELECT @da = substring(dbo.hl7findfield(dbo.hl7findsegment(@RawMsg,''msh''),6), 7,2)

		IF isdate (substring(dbo.hl7findfield(dbo.hl7findsegment(@RawMsg,''msh''),6), 5,2) + ''/'' +
				substring(dbo.hl7findfield(dbo.hl7findsegment(@RawMsg,''msh''),6), 7,2) + ''/'' +
				left(dbo.hl7findfield(dbo.hl7findsegment(@RawMsg,''msh''),6),4)) = 1
		BEGIN
			return convert(datetime,
				substring(dbo.hl7findfield(dbo.hl7findsegment(@RawMsg,''msh''),6), 5,2) + ''/'' +
				substring(dbo.hl7findfield(dbo.hl7findsegment(@RawMsg,''msh''),6), 7,2) + ''/'' +
				left(dbo.hl7findfield(dbo.hl7findsegment(@RawMsg,''msh''),6),4) ,101 )
		END
	
		RETURN NULL
	

end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IMO_BuildCodeSearchRangeWhere]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[IMO_BuildCodeSearchRangeWhere]
(
	@range VARCHAR(800)
)
RETURNS VARCHAR(MAX)
AS
BEGIN

	DECLARE @retVal VARCHAR(MAX) = '''';
	DECLARE @elemA VARCHAR(100);
	DECLARE @elemB VARCHAR(100);
	DECLARE @left VARCHAR(100);
	DECLARE @right VARCHAR(100);
	DECLARE @part VARCHAR(100);

	IF (@range IS NULL OR @range='''')
		RETURN @retVal;

	DECLARE CUR_A CURSOR FOR
		SELECT ELEMENT FROM dbo.Split(@range, '';'');
	OPEN CUR_A;
	FETCH NEXT FROM CUR_A INTO @elemA;

	WHILE @@FETCH_STATUS = 0
	BEGIN

		IF (NOT @elemA IS NULL AND NOT @elemA = '''')
		BEGIN 

			DECLARE CUR_B CURSOR FOR
				SELECT ELEMENT FROM dbo.Split(@elemA, ''-'');
			OPEN CUR_B;
			FETCH NEXT FROM CUR_B INTO @elemB;

			WHILE @@FETCH_STATUS = 0
			BEGIN
				IF (@left IS NULL)
					SET @left = @elemB;
				ELSE
					SET @right = @elemB;

				FETCH NEXT FROM CUR_B INTO @elemB;
			END;

			CLOSE CUR_B;
			DEALLOCATE CUR_B;

			IF (NOT @retVal = '''')
				SET @retVal = @retVal + '' OR '';

			IF (@right IS NULL)
				SET @part = ''[CODE10] = '''''' + @left + '''''' ''; 
			ELSE
				SET @part = ''[CODE10] >= '''''' + @left + '''''' AND [CODE10] < '''''' + @right + '''''' ''; 

			SET @left = NULL;
			SET @right = NULL;
			SET @retVal = @retVal + ''('' + @part + '')'';
		END;

		FETCH NEXT FROM CUR_A INTO @elemA;
	END;

	CLOSE CUR_A;
	DEALLOCATE CUR_A;

	SELECT @retVal = ''( '' +  @retVal + '' OR '' + REPLACE(@retVal,''[CODE10]'',''[CODE09]'') + '' )'';

	RETURN @retVal;

END

/*
	SELECT dbo.IMO_BuildCodeSearchRangeWhere(''1-2;3''); 
*/





















' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsDiagnosisCodeInSingleRange]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[IsDiagnosisCodeInSingleRange](@rangeLow [nvarchar](max), @rangeHigh [nvarchar](max), @lookFor [nvarchar](max), @compareByRoot [bit])
RETURNS [bit] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[IsDiagnosisCodeInSingleRange]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IMO_BuildImoNoteString]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[IMO_BuildImoNoteString]
(
	@icd10 VARCHAR(10)
)
RETURNS VARCHAR(MAX)
AS
BEGIN

	-- Scenario 40641:ICD 10 New Feature to guide providers when additional diagnoses are required to be coded in addition to the original code selected.
	-- 20160411 BMR Bug 48533:Slow IMO

	DECLARE @listStr VARCHAR(MAX)

	SELECT @listStr = COALESCE(@listStr+CHAR(13)+CHAR(10), '''') +  CAST(NT.NOTE_TYPE AS VARCHAR(2)) + '' - '' + CAST(NT.NOTE_TEXT AS VARCHAR(800))
        FROM IMO_ICD_NOTES NT 
		WHERE RANGE_LOW <= @icd10 AND RANGE_HIGH >= @icd10
			AND dbo.IsDiagnosisCodeInSingleRange( RANGE_LOW, RANGE_HIGH , @icd10, 1 ) = 1
        ORDER BY NT.SEQUENCE_ORDER

	RETURN @listStr;

END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IMO_ICD_FullDescription]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

  
CREATE FUNCTION [dbo].[IMO_ICD_FullDescription] 
	(@code10 VARCHAR(10), @code09 VARCHAR(25), @codeDescription VARCHAR(255))
RETURNS VARCHAR(MAX) AS  

BEGIN  

	-- PART I (CODE10-CODE09)
	DECLARE @partOne VARCHAR(100) = '''';
	IF (NOT LTRIM(RTRIM(@code10))='''')
		SET @partOne = @code10;
	
	IF (NOT LTRIM(RTRIM(@code09))='''')
	BEGIN
		IF (NOT @partOne = '''')
			SET @partOne = @partOne + ''-'' + @code09;
		ELSE
			SET @partOne = @code09;
	END
	
	IF (NOT LTRIM(RTRIM(@partOne))='''')
		RETURN ''('' + @partOne + '') '' + ISNULL(@codeDescription,'''');
	
	RETURN ISNULL(@codeDescription,'''');

END

/*
	SELECT dbo.IMO_ICD_FullDescription(NULL, NULL, NULL)
	SELECT dbo.IMO_ICD_FullDescription(NULL, NULL, ''CD'')
	SELECT dbo.IMO_ICD_FullDescription(NULL, ''C09'', NULL)
	SELECT dbo.IMO_ICD_FullDescription(''C10'', NULL, NULL)
	
	SELECT dbo.IMO_ICD_FullDescription(''C10'', ''C09'', NULL)
	SELECT dbo.IMO_ICD_FullDescription(''C10'', ''C09'', ''CD'')
	
	SELECT dbo.IMO_ICD_FullDescription(NULL, ''C09'', NULL)
	SELECT dbo.IMO_ICD_FullDescription(''C10'', NULL, ''CD'')
*/



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IntToGUID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'  
CREATE FUNCTION [dbo].[IntToGUID] (@PK_ID int)
RETURNS uniqueidentifier AS  

BEGIN  

  declare @Wrk varchar(200)
  declare @NewGUID uniqueidentifier
  declare @Neg bit

  if @PK_ID = 0 
	return ''00000000-0000-0000-0000-00000000FFFF''

  if @PK_ID is not null
    begin
      if (@PK_ID < 0) 
        begin
	  set @Neg = 1 
          set @PK_ID = -1 * @PK_ID
        end
      set @Wrk = convert (varchar(200), @PK_ID)
      while len(@Wrk) < 32 set @Wrk = ''0'' + @Wrk

      if (@Neg = 1 )
             set @Wrk = ''FFFFFFFF'' + ''-'' + SUBSTRING(@Wrk, 9, 4) + ''-'' + SUBSTRING(@Wrk, 13, 4) 
                              + ''-'' + SUBSTRING(@Wrk, 17, 4) + ''-'' + SUBSTRING(@Wrk, 21, 12)
      else
             set @Wrk = SUBSTRING(@Wrk, 1, 8) + ''-'' + SUBSTRING(@Wrk, 9, 4) + ''-'' + SUBSTRING(@Wrk, 13, 4) 
                              + ''-'' + SUBSTRING(@Wrk, 17, 4) + ''-'' + SUBSTRING(@Wrk, 21, 12)
      set @Wrk = ''{'' + @Wrk + ''}''
      set @NewGUID = @Wrk
    end
 
  return (@NewGUID)
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsCCMEnabled]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE function [dbo].[IsCCMEnabled] 
(@PatientUid uniqueidentifier, @AsOfDate DATE)
	RETURNS BIT AS
BEGIN
	declare @result bit
	
	IF (SELECT COUNT(*) FROM PatientCareManagement 
		WHERE PatientUid = @PatientUid 
			AND CareTypeUid = ''14E95BCD-A9BC-41E4-9743-ECDBAD35FB6A''
			AND (StatusUid IS NULL OR StatusUid = ''8ADCE475-B9D5-4A2C-B312-DEE14BAEB427'')
			AND (EffectiveDate IS NULL OR EffectiveDate <= @AsOfDate)
			AND (ExpirationDate IS NULL OR ExpirationDate >= @AsOfDate)
		) > 0
		SET @result = 1
	ELSE
		SET @result = 0
	
	return @result
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsCPOEnabled]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE function [dbo].[IsCPOEnabled] 
(@PatientUid uniqueidentifier, @AsOfDate DATE)
	RETURNS BIT AS
BEGIN
	declare @result bit
	
	IF (SELECT COUNT(*) FROM PatientCareManagement 
		WHERE PatientUid = @PatientUid 
			AND CareTypeUid = ''928A4F18-FF1F-4BBA-90D9-66AEE2233C9A''
			AND (StatusUid IS NULL OR StatusUid = ''8ADCE475-B9D5-4A2C-B312-DEE14BAEB427'')
			AND (EffectiveDate IS NULL OR EffectiveDate <= @AsOfDate)
			AND (ExpirationDate IS NULL OR ExpirationDate >= @AsOfDate)
		) > 0
		SET @result = 1
	ELSE
		SET @result = 0
	
	return @result
END





' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsDiagnosisCodeInRange]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[IsDiagnosisCodeInRange](@rangeSpecification [nvarchar](max), @lookFor [nvarchar](max))
RETURNS [bit] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[IsDiagnosisCodeInRange]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsDrugDeleted]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[IsDrugDeleted] (@DiscontinueReasonUid uniqueidentifier)
RETURNS bit AS
BEGIN
	declare @result bit

	set @result = 0

	if (@DiscontinueReasonUid = ''E322D823-F96D-4070-AF3B-AAB21B21E6A9'')
		set @result = 1

	return @result
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsDrugRefilled]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[IsDrugRefilled] (@DiscontinueReasonUid uniqueidentifier)
RETURNS bit AS
BEGIN
	declare @result bit

	set @result = 0

	if (@DiscontinueReasonUid = ''8F132A93-E4A7-4B45-BDBE-AC68E63B1ED4'')
		set @result = 1

	return @result
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsDuplicateHpi]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[IsDuplicateHpi] (@relCCSystemSymptom1Uid uniqueidentifier, @relCCSystemSymptom2Uid uniqueidentifier) RETURNS bit AS
BEGIN
	DECLARE @count int

	SELECT	@count = COUNT(*)
	FROM	RelCCSymptomHpiCategory r1 
	WHERE	r1.RelCCSystemSymptomUid = @relCCSystemSymptom1Uid AND
			r1.HpiCategoryUid NOT IN (SELECT HpiCategoryUid FROM RelCCSymptomHpiCategory WHERE RelCCSystemSymptomUid = @relCCSystemSymptom2Uid)

	IF @count <> 0
		RETURN 0
	
	SELECT	@count = COUNT(*)
	FROM	RelCCSymptomHpiCategory r1 
	WHERE	r1.RelCCSystemSymptomUid = @relCCSystemSymptom2Uid AND
			r1.HpiCategoryUid NOT IN (SELECT HpiCategoryUid FROM RelCCSymptomHpiCategory WHERE RelCCSystemSymptomUid = @relCCSystemSymptom1Uid)
	
	IF @count <> 0
		RETURN 0

	SELECT	@count = COUNT(*)
	FROM	RelCCSymptomHpiCategory r1 INNER JOIN RelCCSymptomHpi h1 ON r1.RelCCSymptomHpiCategoryUid = h1.RelCCSymptomHpiCategoryUid 
	WHERE	r1.RelCCSystemSymptomUid = @relCCSystemSymptom1Uid AND
			h1.HpiUid NOT IN (SELECT HpiUid FROM RelCCSymptomHpiCategory r2 INNER JOIN RelCCSymptomHpi h2 ON r2.RelCCSymptomHpiCategoryUid = h2.RelCCSymptomHpiCategoryUid  WHERE r2.RelCCSystemSymptomUid = @relCCSystemSymptom2Uid)

	IF @count <> 0
		RETURN 0

	SELECT	@count = COUNT(*)
	FROM	RelCCSymptomHpiCategory r1 INNER JOIN RelCCSymptomHpi h1 ON r1.RelCCSymptomHpiCategoryUid = h1.RelCCSymptomHpiCategoryUid 
	WHERE	r1.RelCCSystemSymptomUid = @relCCSystemSymptom2Uid AND
			h1.HpiUid NOT IN (SELECT HpiUid FROM RelCCSymptomHpiCategory r2 INNER JOIN RelCCSymptomHpi h2 ON r2.RelCCSymptomHpiCategoryUid = h2.RelCCSymptomHpiCategoryUid  WHERE r2.RelCCSystemSymptomUid = @relCCSystemSymptom1Uid)

	IF @count <> 0
		RETURN 0
	
	RETURN 1	
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsEmpty]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[IsEmpty](@value VARCHAR(MAX), @default VARCHAR(MAX), @zeroIsEmpty bit = 1) RETURNS VARCHAR(MAX) AS
BEGIN
	IF @value IS NULL
		RETURN @default
	IF RTRIM(@value) = ''''
		RETURN @default
	IF @value = ''0'' AND @zeroIsEmpty = 1
		RETURN @default
	RETURN @value
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsFemale]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE function [dbo].[IsFemale] ( @GenderUid uniqueidentifier )
	RETURNS BIT AS
BEGIN
	declare @result bit
	declare @Name varchar(255)
	declare @ANSICode varchar(255)

	SELECT @Name = Name, @ANSICode = ANSICode FROM ListGender WHERE GenderUid = @GenderUid

	if ((@Name = ''female'') OR (@ANSICode = ''f''))
	BEGIN
		SET @result = 1
	END
	ELSE BEGIN
		SET @result = 0
	END	
	
	return @result
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsPersistentAsthma]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE Function [dbo].[IsPersistentAsthma] 
(@PatientUid  varchar(50),
 @VisitYear  int,
 @MeasureYear  int,
 @VisitType as varchar(3)
)
returns bit as

Begin
	Declare @Ret bit
	SET @Ret = 0
	If (@VisitType = ''EDV'')
	Begin
		--Emergency Department Visit
		If (select count(*) from 
								Visit V  
							Left outer Join 
								VisitDiagnosis VD 
							on V.VisitUid = VD.VisitUid
								
							Left Outer Join 
								VisitProcedure VP
							on
								V.VisitUid = VP.VisitUid
							Left Outer Join 
								ListProcedure LP
							on
								LP.ProcedureUid=VP.ProcedureUid
							Where
								V.PatientUid=@PatientUid
								And 
								Year(V.VisitDate)=@VisitYear
								And
								VD.Code in (''493'')
								And
								LP.code in(''99281'',''99282'',''99283'',''99284'',''99285'')
			) >0
			SET @Ret = 1
	End
	If (@VisitType = ''AID'')
	Begin
		--Acute Inpatient Discharge
		If (select count(*) from 
								Visit V  
							Left outer Join 
								VisitDiagnosis VD 
							on V.VisitUid = VD.VisitUid
								
							Left Outer Join 
								VisitProcedure VP
							on
								V.VisitUid = VP.VisitUid
							Left Outer Join 
								ListProcedure LP
							on
								LP.ProcedureUid=VP.ProcedureUid
							Where
								V.PatientUid=@PatientUid
								And 
								Year(V.VisitDate)=@VisitYear
								And
								VD.Code in (''493'')
								And
								LP.code in(''99221'',''99222'',''99223'',''99231'',''99232'',''99233'', ''99238'',''99239'',''99251'',''99252'',''99253'',''99254'',''99255'',''99261'',''99262'',''99263'',''99291'')
			) >0
			SET @Ret = 1
	End

	If (@VisitType = ''OAV'')
	Begin
		--Outpatient Asthma Visit
		If ((select count(*) from 
								Visit V  
							Left outer Join 
								VisitDiagnosis VD 
							on V.VisitUid = VD.VisitUid
							Left Outer Join 
								VisitProcedure VP
							on
								V.VisitUid = VP.VisitUid
							Left Outer Join 
								ListProcedure LP
							on
								LP.ProcedureUid=VP.ProcedureUid
							Where
								V.PatientUid=@PatientUid
								And 
								Year(V.VisitDate)=@VisitYear
								And
								VD.Code in (''493'')
								And
								LP.code in(''99201'',''99202'',''99203'',''99204'',''99205'',''99211'',''99212'',''99213'',''99214'',''99215'',''99217'',''99218'',''99219'',''99220'',''99241'',''99242'',''99243'',''99244'',''99245'',''99341'',''99342'',''99343'',''99344'',''99345'',''99347'',''99348'',''99349'',''99350'',''99382'',''99383'',''99384'',''99385'',''99386'',''99392'',''99393'',''99394'',''99395'',''99396'',''99401'',''99402'',''99403'',''99404'', ''99411'', ''99412'', ''99420'', ''99429'', ''99499'')
			) >=4) -- 	At least four outpatient asthma visit(s)  
--			And
--				(select count(*) from 
----								Visit V  
----							Left outer Join 
----								VisitMedication VM
----							on V.VisitUid = VM.VisitUid
----							Left outer Join
--								PatientMedication PM
----							on
----								VM.VisitMedicationUid = PM.VisitMedicationUid
--							Left Outer Join 
--								MedicationSigInstruction MS
--							on
--								PM.MedicationComboUid=MS.MedicationComboUid
--							Where
--								PM.PatientUid=@PatientUid
--								And 
--								Year(PM.StartDate)=@VisitYear
--								And
--								MS.DrugName in (''Cromolyn sodium'',''Inhaled corticosteroids'',''Leukotriene modifiers'',''Methylxanthines'',''Nedocromil''))>=2

			SET @Ret = 1
	End

	If (@VisitType = ''FAM'')
	Begin
		--Four Asthma Medication
		Declare @MedicationCount int  -- Asthma medication 
		Declare @LmMedicationCount int -- Leukotriene modifiers
		-- Get Medication Count
--		select @MedicationCount=count(*) from 
----								Visit V  
----							Left outer Join 
----								VisitMedication VM
----							on V.VisitUid = VM.VisitUid
----							Left outer Join
--								PatientMedication PM
----							on
----								VM.VisitMedicationUid = PM.VisitMedicationUid
--							Left Outer Join 
--								MedicationSigInstruction MS
--							on
--								PM.MedicationComboUid=MS.MedicationComboUid
--							Where
--								PM.PatientUid=@PatientUid
--								And 
--								Year(PM.StartDate)=@VisitYear
--								And
--								MS.DrugName in (''Cromolyn sodium'',''Inhaled corticosteroids'',''Leukotriene modifiers'',''Methylxanthines'',''Nedocromil'')
		-- Get Leukotriene modifiers Medication Count
--		select @LmMedicationCount=count(*) from 
----								Visit V  
----							Left outer Join 
----								VisitMedication VM
----							on V.VisitUid = VM.VisitUid
----							Left outer Join
--								PatientMedication PM
----							on
----								VM.VisitMedicationUid = PM.VisitMedicationUid
--							Left Outer Join 
--								MedicationSigInstruction MS
--							on
--								PM.MedicationComboUid=MS.MedicationComboUid
--							Where
--								PM.PatientUid=@PatientUid
--								And 
--								Year(PM.StartDate)=@VisitYear
--								And
--								MS.DrugName = ''Leukotriene modifiers''

								
		If @MedicationCount >=4
		Begin
			if @LmMedicationCount<4 
			Begin
				SET @Ret = 1
			End
			if @LmMedicationCount>=4 -- Sole Leukotriene modifiers
			Begin
				if (select count(*) from 
								Visit V  
--							Left outer Join 
--								VisitMedication VM
--							on V.VisitUid = VM.VisitUid
--							Left outer Join
--								PatientMedication PM
--							on
--								VM.VisitMedicationUid = PM.VisitMedicationUid
--							Left Outer Join 
--								MedicationSigInstruction MS
--							on
--								PM.MedicationComboUid=MS.MedicationComboUid
							Left outer Join 
								VisitDiagnosis VD 
							on V.VisitUid = VD.VisitUid
							Where
								V.PatientUid=@PatientUid
								And 
								(Year(V.VisitDate)=@MeasureYear
									OR
								 Year(V.VisitDate)=@MeasureYear-1)
--								And
--								MS.DrugName = ''Leukotriene modifiers''
								And
								VD.Code in (''493'')) >0 
					Begin
						SET @Ret = 1
					End
			End
		End
	End
	Return @Ret
End




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsPlanExist]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[IsPlanExist]
(
 
 @FeeScheduleUID VARCHAR(MAX),
 @InsurancePlanUID VARCHAR(MAX)

)
RETURNS BIT
AS
BEGIN

	IF(@InsurancePlanUID IS NOT NULL) 
	BEGIN 
	  
	 
		DECLARE @MDOL_RPT2_AmountAllowedSchedule_InsurancePlanIDTable TABLE
		(
		ElementID	SMALLINT,  --Array index
   		InsurancePlanID	VARCHAR(MAX)	--Array element contents
		)

		INSERT INTO @MDOL_RPT2_AmountAllowedSchedule_InsurancePlanIDTable
		SELECT * FROM Split(@InsurancePlanUID,'','')
		
		BEGIN
			IF EXISTS(SELECT * FROM InsurancePlan IP
			JOIN
				InsuranceCarrier IC 
				ON
				IP.InsuranceCarrierUid=IC.CorporationUid
				WHERE  COALESCE(IP.AmountAllowedFeeScheduleUid,IC.AmountAllowedFeeScheduleUid,NULL)= @FeeScheduleUID 
				AND
				InsurancePlanUID IN (SELECT InsurancePlanID FROM @MDOL_RPT2_AmountAllowedSchedule_InsurancePlanIDTable))
			RETURN(1)
			ELSE
			RETURN(0)
		END
	END
	RETURN(1)
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsPregnant]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE function [dbo].[IsPregnant] ( @GenderUid uniqueidentifier, @VisitUid uniqueidentifier, @PatientUid uniqueidentifier, @VisitDate DATE)
	RETURNS BIT AS
BEGIN
	declare @result bit
	
	SET @result = 0
	
	if (dbo.IsFemale(@GenderUid) = 1)
	BEGIN		
		declare @cnt int
		declare @DiagnosisDescription varchar(max)
		
		declare @PregnancyDiagnosisList table
		(
			DiagnosisDescription varchar(255)
		)

		INSERT INTO @PregnancyDiagnosisList (DiagnosisDescription) VALUES (''**PREGNANCY'')
		INSERT INTO @PregnancyDiagnosisList (DiagnosisDescription) VALUES (''PREGNANCY'')
		INSERT INTO @PregnancyDiagnosisList (DiagnosisDescription) VALUES (''**GESTATIONAL DIABETES'')
		INSERT INTO @PregnancyDiagnosisList (DiagnosisDescription) VALUES (''**PLACENTA PREVIA'')
		INSERT INTO @PregnancyDiagnosisList (DiagnosisDescription) VALUES (''GESTATIONAL DIABETES'')
		INSERT INTO @PregnancyDiagnosisList (DiagnosisDescription) VALUES (''PLACENTA PREVIA'')

		INSERT INTO @PregnancyDiagnosisList 
		SELECT DiagnosisCode9 
		FROM ListDiagnosis
		WHERE DiagnosisUid in 
			(SELECT DiagnosisUid FROM RelDiagnosisDisease WHERE DiseaseUid = ''00000000-0000-0000-0000-000000101101'')
		
		 
		-- look in VisitDiagnosis
		DECLARE _cursor CURSOR FOR 
			SELECT vd.Code 
			FROM VisitDiagnosis vd 
			WHERE vd.VisitUid = @VisitUid
			
		OPEN _cursor
		FETCH NEXT FROM _cursor INTO @DiagnosisDescription
		SET @cnt = 0
		
		WHILE (@cnt = 0) AND (@@fetch_status <> -1)
		BEGIN
			IF (@@fetch_status <> -2)
			BEGIN
				SELECT @cnt = COUNT(*) 
				FROM @PregnancyDiagnosisList
				WHERE DiagnosisDescription like ''%'' + @DiagnosisDescription + ''%''
			END
			FETCH NEXT FROM _cursor INTO @DiagnosisDescription
		END
		CLOSE _cursor
		DEALLOCATE _cursor
		
		IF (@cnt > 0)
		BEGIN
			SET @result = 1
		END	
		ELSE BEGIN
			SET @cnt = 0
			
			-- look in PatientHistory
			DECLARE _cursor CURSOR FOR 
				SELECT pp.Name
				 FROM PatientProblem pp
				 INNER JOIN ListProblemStatus lps ON pp.ProblemStatusUid = lps.ProblemStatusUid
				 WHERE (pp.PatientUid = @PatientUid) AND (lps.ActiveStatus = 1) AND
					(pp.ActiveDate <= @VisitDate) AND 
					((pp.InactiveDate IS NULL) OR (pp.InactiveDate > @VisitDate))
					
			
			OPEN _cursor
			FETCH NEXT FROM _cursor INTO @DiagnosisDescription
			SET @cnt = 0
			
			WHILE (@cnt = 0) AND (@@fetch_status <> -1)
			BEGIN
				IF (@@fetch_status <> -2)
				BEGIN
					SELECT @cnt = COUNT(*) 
					FROM @PregnancyDiagnosisList
					WHERE DiagnosisDescription like ''%'' + @DiagnosisDescription + ''%''
				END
				FETCH NEXT FROM _cursor INTO @DiagnosisDescription
			END
			CLOSE _cursor
			DEALLOCATE _cursor
			IF (@cnt > 0)
			BEGIN
				SET @result = 1
			END
			ELSE BEGIN
			
				SET @cnt = 0
				
				-- look in PatientDXHistory
				DECLARE _cursor CURSOR FOR 
					SELECT pdx.Code 
					 FROM PatientDXHistory pdx
					 INNER JOIN ListProblemStatus lps on pdx.ProblemStatusUid = lps.ProblemStatusUid AND lps.ActiveStatus = 1 
					 WHERE (pdx.PatientUid = @PatientUid) AND 
						(pdx.ActiveDate <= @VisitDate) AND 
						((pdx.InactiveDate IS NULL) OR (pdx.InactiveDate > @VisitDate))
				
				OPEN _cursor
				FETCH NEXT FROM _cursor INTO @DiagnosisDescription
				SET @cnt = 0
				
				WHILE (@cnt = 0) AND (@@fetch_status <> -1)
				BEGIN
					IF (@@fetch_status <> -2)
					BEGIN
						SELECT @cnt = COUNT(*) 
						FROM @PregnancyDiagnosisList
						WHERE DiagnosisDescription like ''%'' + @DiagnosisDescription + ''%''
					END
					FETCH NEXT FROM _cursor INTO @DiagnosisDescription
				END
				CLOSE _cursor
				DEALLOCATE _cursor
						
				IF (@cnt > 0)
				BEGIN
					SET @result = 1
				END
			END
		END
	
	END
	
	return @result
END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IsUserAllowedVisitConfidentialAccess]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE FUNCTION [dbo].[IsUserAllowedVisitConfidentialAccess](@UserUid [uniqueidentifier], @VisitUid [uniqueidentifier])
RETURNS [bit] 
AS

BEGIN
    DECLARE @retValue bit
	SET @retValue=0

	SELECT @retValue = 1 WHERE @UserUid IN
	(
		SELECT userAllowed.PersonUid FROM UserPRM userAllowed
			INNER JOIN RelVisitConfidentialNoteAccess rvcn ON 
				rvcn.VisitCommentExtensionUid = @VisitUid AND rvcn.UserPRMUid = userAllowed.PersonUid
		UNION
		SELECT userAllowed.PersonUid FROM UserPRM userAllowed
			INNER JOIN UserGroupMember groups ON groups.MemberUserUid = userAllowed.PersonUid
			INNER JOIN RelVisitConfidentialNoteAccess rvcn ON rvcn.UserGroupUid = groups.UserGroupUid AND
				rvcn.VisitCommentExtensionUid = @VisitUid
	)	
	RETURN @retValue
END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[LastDayOfWeek]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[LastDayOfWeek] 
(
    @date DATETIME
)
RETURNS DATETIME
AS
BEGIN
	DECLARE @dtLastDayOfWeek DATETIME
    SET @dtLastDayOfWeek = 
        CAST (CONVERT (VARCHAR (16), DATEADD(DD, 6, [dbo].[FirstDayOfWeek] (@date)), 101) AS DATETIME)
	RETURN @dtLastDayOfWeek
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_FUNCTION_PQRIRule]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[MDOL_RPT2_FUNCTION_PQRIRule]
	(
		@PQRIMeasureUids		VARCHAR(MAX)
	)
RETURNS @retTable TABLE (
						PQRIMeasureUid UniqueIdentifier,
						ReccuranceStartDate DateTime,
						ReccuranceEndDate DateTime
						)
BEGIN

	DECLARE @PQRIMeasureUid UNIQUEIDENTIFIER

	DECLARE PQRIRules CURSOR FOR SELECT Element FROM dbo.Split(@PQRIMeasureUids,'','')

	OPEN PQRIRules

	FETCH NEXT FROM PQRIRules into @PQRIMeasureUid

	WHILE(@@FETCH_STATUS = 0)
	BEGIN
		DECLARE @RecurrenceInterval SMALLINT
		DECLARE @RecurTimeTypeUid UNIQUEIDENTIFIER
		DECLARE @RecurStartDate DATETIME
		DECLARE @RecurEndDate DATETIME

		SET @RecurStartDate = Cast(Cast(''01/01/''+ cast(datepart(year,getdate()) as varchar(4)) as Datetime) as Datetime)
		SET @RecurEndDate = Cast(Cast(''01/01/''+ cast(datepart(year,getdate()) as varchar(4)) as Datetime) as Datetime)

		WHILE (@RecurEndDate < getdate())
		BEGIN

			SELECT 
				@RecurrenceInterval = RecurrenceInterval,	
				@RecurTimeTypeUid = RecurTimeTypeUid  
			FROM ListPQRIMeasure WHERE PQRIMeasureUid = @PQRIMeasureUid
			
			IF (@RecurTimeTypeUid IS NOT NULL AND @RecurrenceInterval > 0)
			BEGIN
				SET @RecurEndDate = dbo.CheckRecurTimeType(@RecurTimeTypeUid, @RecurStartDate, @RecurrenceInterval)

				IF (@RecurEndDate > getdate())
				BEGIN
					SET @RecurEndDate = getdate()
				END
			END
			ELSE
			BEGIN
				SET @RecurEndDate = getdate()
			END

			INSERT INTO @retTable(PQRIMeasureUid, ReccuranceStartDate, ReccuranceEndDate)
			VALUES(@PQRIMeasureUid, @RecurStartDate, @RecurEndDate)

			--SET @RecurStartDate = DATEADD(d, 1, @RecurEndDate)
			SET @RecurStartDate = @RecurEndDate
		END

	FETCH NEXT FROM PQRIRules INTO @PQRIMeasureUid
	END

	CLOSE PQRIRules
	DEALLOCATE PQRIRules

RETURN 

END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_getPatientStatus]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[MDOL_RPT2_getPatientStatus]
(  
	@PatientUid UNIQUEIDENTIFIER
)   
RETURNS  Varchar(Max) AS  
BEGIN    
	DECLARE @PatientStatus VARCHAR(MAX)  

	SET @PatientStatus=''''  

	SELECT @PatientStatus = @PatientStatus + PatientStatusName + '';''  
	FROM  
	(  
		SELECT  
		LPs.Name AS PatientStatusName
		FROM   
		Patient P (NOLOCK)
		JOIN 
		RelPatientStatus RPS (NOLOCK)
		ON
		P.PersonUid = RPS.PatientUid
		LEFT JOIN
		ListPatientStatus LPS (NOLOCK)
		ON 
		RPS.PatientStatusUid = LPS.PatientStatusUid
		WHERE P.PersonUid=@PatientUid
	)A  


	IF LEN(@PatientStatus)>2  
	BEGIN  
	SET @PatientStatus=substring(@PatientStatus,1, len(@PatientStatus)-1)  
	END  
	RETURN @PatientStatus  
END 



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getFormattedPreferredNameFromValues]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE  FUNCTION [dbo].[UDF_getFormattedPreferredNameFromValues]
(
	@firstname as varchar(50),
	@lastname as varchar(50),
	@middlename as varchar(50),
	@suffix as varchar(50)
)
RETURNS  VARCHAR(100)

AS
BEGIN 

	DECLARE @PreferredName VARCHAR(100)

	SET @PreferredName = 
		(CASE WHEN @LastName IS NULL THEN '''' 
			ELSE @LastName + '', '' 
		END )
		+
		RTRIM((CASE WHEN @FirstName IS NULL THEN ''''
			ELSE @FirstName + '' ''
		END )
		+
		(CASE WHEN @MiddleName IS NULL THEN ''''
			WHEN @MiddleName ='''' THEN @MiddleName
			ELSE @MiddleName
		END))
		+
		(CASE WHEN @Suffix IS NULL THEN ''''
			ELSE '', '' + @Suffix
		END)
		
	RETURN @PreferredName
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_getResponsiblePartyPatients]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[MDOL_RPT2_getResponsiblePartyPatients]
(
@AccountResponsiblePartyUID UNIQUEIDENTIFIER,
@IncludeInactivePatients BIT = 0,
@IncluceDeceasedPatients BIT = 0
) 
RETURNS	 Varchar(Max) AS
BEGIN  -- FUNCTION START

	DECLARE @Patient VARCHAR(MAX)


	SET @Patient=''''
	
	SELECT @Patient = @Patient + PatientName + '';''
	FROM
	(
	SELECT 	DISTINCT
		 (CASE WHEN P1.DeathDate IS NOT NULL THEN dbo.UDF_getFormattedPreferredNameFromValues(P1.FirstName,P1.LastName,P1.MiddleName,P1.Suffix)+''(D)''
									WHEN PT.Inactive=1  THEN dbo.UDF_getFormattedPreferredNameFromValues(P1.FirstName,P1.LastName,P1.MiddleName,P1.Suffix)+''(I)'' 
									ELSE  dbo.UDF_getFormattedPreferredNameFromValues(P1.FirstName,P1.LastName,P1.MiddleName,P1.Suffix) END)AS PatientName
	FROM 
		AccountResponsibleParty ARP
	LEFT JOIN
		Account A
	ON
		ARP.AccountResponsiblePartyUID = A.AccountResponsiblePartyUid
	INNER JOIN
		Patient PT
	ON	
		A.PersonUID = PT.PersonUID
	LEFT JOIN 
		Person P1
	ON
		PT.PersonUID = P1.PersonUID
	WHERE 
		ARP.AccountResponsiblePartyUID=@AccountResponsiblePartyUID
	AND
		(@IncludeInactivePatients = 1 OR PT.Inactive = 0)
	AND
		(@IncluceDeceasedPatients = 1 OR P1.DeathDate IS  NULL)
	)A
	

	IF LEN(@Patient)>2
	BEGIN
		SET @Patient=substring(@Patient,1, len(@Patient)-1)
	END
	RETURN @Patient
END -- FUNCTION


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_GetSuperbillUnit_DFS]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[MDOL_RPT2_GetSuperbillUnit_DFS]
	(
	@TypeofProviders VARCHAR(30), 
	@ProviderUid VARCHAR(Max), 
	@FinancialCenter VARCHAR(Max),
	@ServiceSiteUid VARCHAR(Max),
	@FinanceSummary_StartDate DATETIME,
	@FinanceSummary_EndDate DATETIME,
	@DateOption  VARCHAR(30)
	) 
RETURNS Money AS
BEGIN
	DECLARE @Unit Money
	--SELECT @FinanceSummary_EndDate =  DATEADD(DAY,1,@FinanceSummary_EndDate)
	SELECT @Unit=SUM(ISNULL(SBP.Units,0))
	FROM 
		SuperBill SB
	INNER JOIN ViewSuperbillFinancialDetails VSFD ON SB.SuperbillUid = 	VSFD.SuperbillUid
	JOIN
		SuperBillProcedure SBP
	ON 
		SB.SuperbillUid=SBP.SuperbillUid
	JOIN
		ARBatch AR
	ON
		AR.ARBatchUid=SB.ARBatchUid		
	WHERE
	(
		(@DateOption=''Posting''  AND (@FinanceSummary_StartDate IS NULL OR AR.GLDate >= @FinanceSummary_StartDate) AND (@FinanceSummary_EndDate IS NULL OR AR.GLDate < @FinanceSummary_EndDate) )
			OR
		(@DateOption=''Service''  AND (@FinanceSummary_StartDate IS NULL OR SB.ServiceDateStart >= @FinanceSummary_StartDate) AND (@FinanceSummary_EndDate IS NULL OR SB.ServiceDateStart < @FinanceSummary_EndDate) )
	)
	AND
	(    
	(@TypeofProviders=''Billing Providers'' AND (@ProviderUid IS NULL OR VSFD.ClaimingProviderUid  IN (SELECT Element FROM dbo.Split(@ProviderUid, '','')))    )
	 OR    
	(@TypeofProviders=''Rendering Providers'' AND (@ProviderUid IS NULL  OR VSFD.RenderingProviderUid  IN (SELECT Element FROM dbo.Split(@ProviderUid, '','')) )    )
    )  		
	AND      
	(@FinancialCenter is NULL OR VSFD.FinancialCenterUid IN (SELECT Element FROM dbo.Split(@FinancialCenter, '','')) )   
   AND      
	(@ServiceSiteUid is NULL OR VSFD.ServiceSiteUid in (SELECT Element FROM dbo.Split(@ServiceSiteUid, '','')) )   
		   
	RETURN ISNULL(@Unit,0)
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_getTotalAppointment]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[MDOL_RPT2_getTotalAppointment]
	(@ProviderUid Uniqueidentifier,
	@ServiceSiteUid uniqueidentifier,
	@FinancialCenterUid VarChar(Max),
	@StartDate DateTime,
	@EndDate DateTime,
	@ProviderOption BIT = 1 --0 = BillingProvider 1 = RenderingProvider
	) 
RETURNS	 int AS
BEGIN  -- FUNCTION START
	DECLARE @TotalAppts Int
	SELECT @TotalAppts=COUNT(*) 
	FROM   
		ViewAppointmentWithGroup 
	WHERE 
		((@ProviderOption = 0 AND BillingProviderUid = @ProviderUid) OR (@ProviderOption = 1 AND ProviderUid = @ProviderUid))
		--ProviderUid=@ProviderUid
	AND PatientUID IS NOT NULL
	AND ServiceSiteUid=@ServiceSiteUid
	AND FinancialCenterUid=@FinancialCenterUid
	--AND	CONVERT(Varchar, StartDateTime, 101) >= @StartDate AND CONVERT(Varchar, StartDateTime, 101) <=@EndDate
	AND
	(@StartDate IS NULL OR StartDateTime >= @StartDate) AND (@EndDate IS NULL OR StartDateTime < @EndDate)

	RETURN @TotalAppts
END -- FUNCTION
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_getTotalAppointmentCancelled]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[MDOL_RPT2_getTotalAppointmentCancelled]
	(@ProviderUid Uniqueidentifier,
	@ServiceSiteUid uniqueidentifier,
	@FinancialCenterUid VarChar(Max),
	@StartDate DateTime,
	@EndDate DateTime,
	@ProviderOption BIT = 1 --Billing = 0, Rendering = 1
	) 
RETURNS	 int AS
BEGIN  -- FUNCTION START
	DECLARE @TotalApptsCancelled Int
	SELECT @TotalApptsCancelled=COUNT(*) 
	FROM   
	  ViewAppointmentWithGroup 
	Inner Join
	  ListAppointmentStatus   
	On 
	  ViewAppointmentWithGroup.AppointmentStatusUid = ListAppointmentStatus.AppointmentStatusUid
	WHERE 
		((@ProviderOption = 0 AND BillingProviderUid = @ProviderUid) OR (@ProviderOption = 1 AND ProviderUid = @ProviderUid))
	AND PatientUid IS NOT NULL
	AND ViewAppointmentWithGroup.ServiceSiteUid=@ServiceSiteUid
	AND ViewAppointmentWithGroup.FinancialCenterUid=@FinancialCenterUid
	--AND	CONVERT(Varchar, ViewAppointmentWithGroup.StartDateTime, 101) >= @StartDate AND CONVERT(Varchar, ViewAppointmentWithGroup.StartDateTime, 101) <=@EndDate
	AND
	(@StartDate IS NULL OR ViewAppointmentWithGroup.StartDateTime >= @StartDate) AND (@EndDate IS NULL OR ViewAppointmentWithGroup.StartDateTime < @EndDate)
	AND ListAppointmentStatus.Name=''Canceled''

	RETURN @TotalApptsCancelled
END -- FUNCTION
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_getTotalCompleteVisit]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[MDOL_RPT2_getTotalCompleteVisit]
	(@ProviderUid Uniqueidentifier,
	@ServiceSiteUid uniqueidentifier,
	@FinancialCenterUid VarChar(Max),
	@StartDate DateTime,
	@EndDate DateTime,
	@ProviderOption BIT = 1 --Billing = 0, Rendering = 1
	) 
RETURNS	 int AS
BEGIN  -- FUNCTION START
	DECLARE @TotalCompletVisits Int
	SELECT @TotalCompletVisits=COUNT(*) 
	FROM   
		Visit V
	JOIN
		ViewAppointmentWithGroup A
	ON
		V.AppointmentUid=A.AppointmentUid	
	WHERE ((@ProviderOption = 1 AND (V.RenderingProviderUid=@ProviderUid OR (V.RenderingProviderUid IS NULL AND V.ProviderUid=@ProviderUid))) OR (@ProviderOption = 0 AND (V.ProviderUid=@ProviderUid)))
	AND V.isCompleted=1
	AND V.ServiceSiteUid=@ServiceSiteUid
	AND V.FinancialCenterUid=@FinancialCenterUid
	AND	(@StartDate IS NULL OR VisitDate >= @StartDate) AND (@EndDate IS NULL OR VisitDate < @EndDate)
	AND A.PatientUid IS NOT NULL
	RETURN @TotalCompletVisits
END -- FUNCTION
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_getTotalVisit]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[MDOL_RPT2_getTotalVisit]
	(@ProviderUid uniqueidentifier, 
	@ServiceSiteUid uniqueidentifier,
	@FinancialCenterUid VarChar(Max),
	@StartDate DateTime,
	@EndDate DateTime,
	@ProviderOption BIT = 1 --BIlling = 0, Rendering = 1
	) 
RETURNS	 int AS
BEGIN
	DECLARE @TotalVisit  int
	SELECT
		@TotalVisit=COUNT(*)
	FROM 
	 Visit V
	JOIN
		ViewAppointmentWithGroup A
	ON
		V.AppointmentUid=A.AppointmentUid	
	WHERE ((@ProviderOption = 1 AND (V.RenderingProviderUid=@ProviderUid OR (V.RenderingProviderUid IS NULL AND V.ProviderUid=@ProviderUid))) OR (@ProviderOption = 0 AND V.ProviderUid=@ProviderUid))
		AND V.ServiceSiteUid=@ServiceSiteUid
		AND (@FinancialCenterUid IS NULL OR  V.FinancialCenterUid IN (SELECT Element FROM dbo.Split(@FinancialCenterUid,'','')))
	AND	(@StartDate IS NULL OR V.VisitDate >= @StartDate) AND (@EndDate IS NULL OR V.VisitDate < @EndDate)
	AND A.PatientUid IS NOT NULL


	RETURN ISNULL(@TotalVisit,0)

END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_getUserGroupMember]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[MDOL_RPT2_getUserGroupMember]
	(@Uid Uniqueidentifier
	) 
RETURNS	 Varchar(Max) AS
BEGIN  -- FUNCTION START
Declare @UandUG varchar(Max)
set @UandUG=''''
	SELECT	@UandUG=@UandUG + fuug.Name + ''; ''
	FROM	UserGroupMember ugm CROSS JOIN ViewFindUserAndUserGroup fuug
	WHERE	ugm.UserGroupUid = @Uid AND
			((ugm.MemberUserUid = fuug.Uid AND fuug.ForeignKeyIndex = 1) OR
			 (ugm.MemberUserGroupUid = fuug.Uid AND fuug.ForeignKeyIndex = 2))

IF LEN(@UandUG)>2
BEGIN
	SET @UandUG=substring(@UandUG,1, len(@UandUG)-2)
END
RETURN @UandUG
END -- FUNCTION


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_getUserGroupMemberMaxPermission]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[MDOL_RPT2_getUserGroupMemberMaxPermission]
	(
		@Perm int
	) 
RETURNS	 Varchar(50) AS
BEGIN  -- FUNCTION START
	DECLARE @Permission varchar(50)
	SET @Permission = ''''

	IF @Perm & 64 != 0 -- Read only
	BEGIN
		SET @Permission=''Read Only''
	END

	IF @Perm & 2 != 0  -- Created By
	BEGIN
		IF Len(@Permission) > 0 
			SET @Permission = @Permission + '', ''
		SET @Permission= @Permission + ''Created By''
	END

	IF @Perm  & 4 != 0  -- Modify
	BEGIN
		IF Len(@Permission) > 0 
			SET @Permission = @Permission + '', ''
		SET @Permission=@Permission + ''Modify''
	END

	IF @Perm & 128 != 0  -- Complete
	BEGIN
		IF Len(@Permission) > 0 
			SET @Permission = @Permission + '', ''
		SET @Permission= @Permission + ''Complete''
	END
	
	RETURN @Permission
END -- FUNCTION

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MedicationPrescribedFromXML]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[MedicationPrescribedFromXML] 
(
	@MessageXML [xml]
)
RETURNS [varchar](max)
AS
BEGIN
	DECLARE @DrugInfo_TBL TABLE
	(
		[DrugDescription] [varchar](2048),
		[Directions] [varchar](2048),
		[Quantity] [varchar](2048),
		[PotencyUnitCode] [varchar](2048),
		[Refills] [int]
	)

	BEGIN
		WITH XMLNAMESPACES (''http://www.ncpdp.org/schema/SCRIPT'' as ns)
		INSERT @DrugInfo_TBL
		SELECT x.n.value(''(ns:DrugDescription)[1]'', ''[varchar](2048)'') AS [DrugDescription],
			x.n.value(''(ns:Directions)[1]'', ''[varchar](2048)'') AS [Directions],
			x.n.value(''(ns:Quantity/ns:Value)[1]'', ''[varchar](2048)'') AS [Quantity],
			x.n.value(''(ns:Quantity/ns:PotencyUnitCode)[1]'', ''[varchar](2048)'') AS [PotencyUnitCode],
			x.n.value(''(ns:Refills/ns:Value)[1]'', ''[int]'') AS [Refills]
		FROM @MessageXML.nodes(''//ns:MedicationPrescribed'') AS x(n)
	END

	RETURN (
		SELECT
			drugInfo.[DrugDescription] 
			+ '' '' + drugInfo.[Directions]
			+ '', QTY: '' + drugInfo.[Quantity]
			+ '', UOM: '' + COALESCE (uom.[Name], ''Unknown'')
			+ CASE 
					WHEN drugInfo.[Refills] <> 1 THEN ''''
					WHEN drugInfo.[Refills] <= 1 THEN ''''
					ELSE '', Refills: '' + CONVERT ([varchar](256), drugInfo.[Refills] - 1)
				END
		FROM @DrugInfo_TBL AS drugInfo
			LEFT OUTER JOIN [ListSIGQuantityUnitOfMeasure] AS uom ON uom.[NCItCode] = drugInfo.[PotencyUnitCode]
	)
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MedIdFromRxNormCode]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[MedIdFromRxNormCode](@rxnormcode varchar(50)) RETURNS int AS
BEGIN
/*
	Created 05/08/2013
	
	Finds and returns the MedId for a given RxNorm Code.
    Give priority to generics when ordering results
	
*/
	DECLARE @medId int
    SELECT @medId =  rev.EVD_FDB_VOCAB_ID
        FROM fdb_REVDEL0_EXT_VOCAB_LINK rev
        INNER JOIN fdb_dispensable dis on dis.medid = rev. EVD_FDB_VOCAB_ID
        WHERE rev.EVD_EXT_VOCAB_ID = CONVERT (varchar( 255), @rxnormcode)
            AND EVD_FDB_VOCAB_TYPE_ID = 3
            AND EVD_LINK_TYPE_ID IN( 1, 5 )
        ORDER BY dis.obsoletedate, dis.nametypecode DESC   -- favoring generic

    RETURN ISNULL(@medId, 0)
End

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MnidFromRxNormCode]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[MnidFromRxNormCode] (@rxnormcode varchar(50)) RETURNS int AS
BEGIN
/*
	Created 05/08/2013
	
	Finds and returns the mnid for a given RxNorm Code.
	
*/
	DECLARE @mnid INT
	SELECT @mnid = ISNULL ( -- brand name
						(SELECT TOP (1) voc.EVD_FDB_VOCAB_ID
							FROM fdb_REVDEL0_EXT_VOCAB_LINK voc
								INNER JOIN fdb_DrugName nam ON nam.mnid = EVD_FDB_VOCAB_ID AND nam.nametypecode = ''1''
							WHERE voc.EVD_FDB_VOCAB_TYPE_ID = 1
								AND voc.EVD_EXT_VOCAB_ID = @RxNormCode
							ORDER BY nam.obsoletedate, voc.EVD_LINK_TYPE_ID DESC ),
                         -- generic 
                         (SELECT TOP (1) hnm.mnid
							FROM fdb_REVDEL0_EXT_VOCAB_LINK voc
								INNER JOIN fdb_hicseqno_baseingredient ing ON baseingredientid = voc.EVD_FDB_VOCAB_ID
								INNER JOIN fdb_hicl_hicseqno hic ON hic.hicseqno = ing.hicseqno
								INNER JOIN fdb_mnid_hicl hnm ON hnm.hicl = hic.hicl
								INNER JOIN FDB_DrugName nam ON nam.mnid = hnm.mnid AND nam.nametypecode = ''2''
							WHERE voc.EVD_EXT_VOCAB_TYPE_ID = 500
								AND voc.EVD_FDB_VOCAB_TYPE_ID = 104
								AND voc.EVD_EXT_VOCAB_ID = @RxNormCode
							ORDER BY nam.obsoletedate, voc.EVD_LINK_TYPE_ID ))
     RETURN @mnid
End

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[MU_CreateMapping]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[MU_CreateMapping]
(	
	@RuleNumber VARCHAR(10),
	@CodeTypeList VARCHAR(MAX),
	@DataElementNameList VARCHAR(MAX),
	@SNOMED_96 VARCHAR(50),
	@SNOMED_97 VARCHAR(50),
	@CQMVersion VARCHAR(7) = ''CQM2015'' --2016.04.04 dmg
)
RETURNS @mappings TABLE 
	(
		PRMCode	VARCHAR(50),
		PRMCodeBigInt BIGINT NULL,
		DataElementName VARCHAR(100) NULL,
		TopicIndicator VARCHAR(50) NULL,
		QRDASection VARCHAR(50) NULL,
		Rootid VARCHAR(40) NOT NULL
	)
AS

--2016.04.04 dmg added CQM Versioning

BEGIN
				INSERT	@mappings
				SELECT	[PRMCode], 
						CASE WHEN ISNUMERIC([PRMCode]) = 1 AND RootId IN (@SNOMED_96 ,@SNOMED_97) THEN CAST(PRMCode AS BIGINT) ELSE NULL END AS PRMCodeBigInt,
						[DataElementName], [TopicIndicator], [QRDASection], [RootId]		
				FROM	[dbo].[MU2_InterfaceDataMapping]
				WHERE	[NCQMeasure] = @RuleNumber
				    AND [CQMVersion] = @CQMVersion --2016.04.04 dmg
					AND (
						[Name] IN (
							SELECT CleanXml
							FROM dbo.SplitCLR(@CodeTypeList, ''|'') g
							CROSS APPLY dbo.RemoveWhitespace(Parameter)
							)
						OR @CodeTypeList IS NULL
						)
					AND (
						[DataElementName] IN (
							SELECT CleanXml
							FROM dbo.SplitCLR(@DataElementNameList, ''|'')
							CROSS APPLY dbo.RemoveWhitespace(Parameter)
							)
						OR @DataElementNameList IS NULL
						)

				RETURN
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[OBInformation1]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[OBInformation1]
(
@moduledata VARCHAR(MAX),
@value VARCHAR(MAX)
)

RETURNS VARCHAR(100)

BEGIN
DECLARE @retVal VARCHAR(100)

DECLARE @tempTable TABLE 
(  
	[Name] VARCHAR(MAX),
	[ControlType] VARCHAR(MAX),
	[Value] VARCHAR(MAX),
	[Label] VARCHAR(MAX)  
)  

DECLARE @xml XML  
Declare @Data Varchar(Max)

--SET @xml=@ModuleData --''<CaseTypeModule Name="Estimated Delivery Date"><Control Name="prmTextGADateOfCalc" ControlType="PrmTextBox" Value="8/4/2008" Label="" /><Control Name="prmNoteEDD" ControlType="PrmNote" Value="" Label="Note" /><Control Name="prmTextBoxGAEDDDate" ControlType="PrmTextBox" Value="Undetermined" Label="GA (shows only in debug mode):" /><Control Name="findTextControlGABasis" ControlType="FindTextControl" Guid="" Value="" Tag="" ForeignKeyIndex="" /><Control Name="findTextControlInitialPE" ControlType="FindTextControl" Guid="" Value="" Tag="" ForeignKeyIndex="" /><Control Name="prmGroupBoxEDDUpdate" ControlType="PrmGroupBox" /><Control Name="prmRadioButton18TO20LMP" ControlType="PrmRadioButton" Value="false" Label="Base EDD on LMP" Display="false" /><Control Name="prmTextBoxFinalEDD" ControlType="PrmTextBox" Value="Test" Label="" /><Control Name="prmNumericUpDownUS3Days" ControlType="PrmNumericUpDown" Value="0" /><Control Name="prmNumericUpDownUS3Weeks" ControlType="PrmNumericUpDown" Value="0" /><Control Name="prmNumericUpDownUS2Days" ControlType="PrmNumericUpDown" Value="0" /><Control Name="prmNumericUpDownUS2Weeks" ControlType="PrmNumericUpDown" Value="0" /><Control Name="prmNumericUpDownUS1Days" ControlType="PrmNumericUpDown" Value="0" /><Control Name="prmNumericUpDownUS1Weeks" ControlType="PrmNumericUpDown" Value="0" /><Control Name="findTextControlFinalInitials" ControlType="FindTextControl" Guid="" Value="" Tag="" ForeignKeyIndex="" /><Control Name="findDateBoxUS3EDD" ControlType="FindDateBox" Value="" Label="" Display="false" /><Control Name="findDateBoxUS2EDD" ControlType="FindDateBox" Value="" Label="" Display="false" /><Control Name="findDateBoxUS1EDD" ControlType="FindDateBox" Value="" Label="" Display="false" /><Control Name="findDateBoxFUNDALEDD" ControlType="FindDateBox" Value="" Label="" Display="false" /><Control Name="findDateBoxQUICKEDD" ControlType="FindDateBox" Value="" Label="" Display="false" /><Control Name="prmRadioButtonUS3" ControlType="PrmRadioButton" Value="false" Label="Base EDD on Ultrasound 3" Display="false" /><Control Name="prmRadioButtonUS2" ControlType="PrmRadioButton" Value="false" Label="Base EDD on Ultrasound 2" Display="false" /><Control Name="prmRadioButtonFUNDAL" ControlType="PrmRadioButton" Value="false" Label="Base EDD on Fundal Ht" Display="false" /><Control Name="prmRadioButtonUS1" ControlType="PrmRadioButton" Value="false" Label="Base EDD on Ultrasound 1" Display="false" /><Control Name="prmRadioButtonQUICK" ControlType="PrmRadioButton" Value="true" Label="Base EDD on Quickening" Display="false" /><Control Name="findDateBoxUS3" ControlType="FindDateBox" Value="" Label="Ultrasound 3" Display="false" /><Control Name="findDateBoxUS2" ControlType="FindDateBox" Value="" Label="Ultrasound 2" Display="false" /><Control Name="findDateBoxUS1" ControlType="FindDateBox" Value="" Label="Ultrasound 1" Display="false" /><Control Name="findDateBoxFUNDAL" ControlType="FindDateBox" Value="" Label="Fundal Ht @ Umbilical" Display="false" /><Control Name="findDateBoxQUICK" ControlType="FindDateBox" Value="" Label="Quickening" Display="false" /><Control Name="prmGroupBoxInitialEDD" ControlType="PrmGroupBox" /><Control Name="findTextControlInitialEDDInitials" ControlType="FindTextControl" Guid="" Value="" Tag="" ForeignKeyIndex="" Label="Initial EDD Set By" /><Control Name="prmRadioButtonUS" ControlType="PrmRadioButton" Value="false" Label="Base EDD on Ultrasound" Display="false" /><Control Name="prmRadioButtonIE" ControlType="PrmRadioButton" Value="false" Label="Base EDD on Initial Exam" Display="false" /><Control Name="prmRadioButtonLMP" ControlType="PrmRadioButton" Value="true" Label="Base EDD on LMP" Display="false" /><Control Name="findDateBoxUSEDD" ControlType="FindDateBox" Value="" Label="" Display="false" /><Control Name="findDateBoxIEEDD" ControlType="FindDateBox" Value="" Label="" Display="false" /><Control Name="findDateBoxLMPEDD" ControlType="FindDateBox" Value="5/11/2009" Label="" Display="false" /><Control Name="prmNumericUpDownUSDays" ControlType="PrmNumericUpDown" Value="0" /><Control Name="prmNumericUpDownUSWeeks" ControlType="PrmNumericUpDown" Value="0" /><Control Name="prmNumericUpDownIEDays" ControlType="PrmNumericUpDown" Value="0" /><Control Name="prmNumericUpDownIEWeeks" ControlType="PrmNumericUpDown" Value="0" /><Control Name="findDateBoxUltraSound" ControlType="FindDateBox" Value="" Label="Initial Ultrasound" Display="false" /><Control Name="findDateBoxInitialExam" ControlType="FindDateBox" Value="" Label="Initial Exam" Display="false" /><Control Name="findDateBoxLMP" ControlType="FindDateBox" Value="8/4/2008" Label="LMP" Display="false" /><Control Name="prmTextBoxInitialEDD" ControlType="PrmTextBox" Value="5/11/2009" Label="" /></CaseTypeModule>''

select @Data= REPLACE(@ModuleData,''"<'',''"'')
select @xml= REPLACE(@Data,''>"'',''"'')

INSERT INTO @tempTable  
SELECT Tbl.Col.value(''@Name'', ''varchar(max)'') , 
       Tbl.Col.value(''@ControlType'', ''VARCHAR(max)''),  
       Tbl.Col.value(''@Value'', ''VARCHAR(max)''),
	   Tbl.Col.value(''@Label'',''Varchar(max)'')	 
FROM   @xml.nodes(''//Control'') Tbl(Col) 

SELECT @retVal = [Value] FROM @tempTable WHERE Name = @value

RETURN @retVal
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[OverrideUniqueIdentifierToLower]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[OverrideUniqueIdentifierToLower](@override VARCHAR(MAX)) RETURNS VARCHAR(MAX) AS
BEGIN
	
	DECLARE @pos INT
	SET @pos = 0
	
	SET @pos = CHARINDEX(''Uid'', @override, @pos)
	WHILE @pos > 0
	BEGIN
		SET @override = SUBSTRING(@override, 1, @pos + 4) + LOWER(SUBSTRING(@override, @pos + 5, 36)) + SUBSTRING(@override, @pos + 41, DATALENGTH(@override) - 41)
				
		SET @pos = CHARINDEX(''Uid'', @override, @pos + 45)
	END
	
	RETURN @override
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[PrimaryKeyColumn]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[PrimaryKeyColumn] (@tableName varchar(255)) RETURNS varchar(255) AS
	BEGIN
		DECLARE @primaryKeyColumn varchar(255)
		DECLARE @index_id int
	

		SELECT		@primaryKeyColumn = kcu.COLUMN_NAME
		FROM		INFORMATION_SCHEMA.TABLE_CONSTRAINTS tc INNER JOIN INFORMATION_SCHEMA.KEY_COLUMN_USAGE kcu ON tc.CONSTRAINT_NAME = kcu.CONSTRAINT_NAME
		WHERE		tc.CONSTRAINT_TYPE = ''Primary Key'' AND
					tc.TABLE_NAME = @tableName
		ORDER BY	kcu.ORDINAL_POSITION

		RETURN		@primaryKeyColumn
	END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[prmGetJobInfo]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =============================================
-- Author:		KC
-- Create date: 02/20/2007
-- Description:	Gets job run summary
-- =============================================
CREATE function [dbo].[prmGetJobInfo] (@pJobScheduleName varchar(50))
	returns @output TABLE (JobScheduleName varchar(100), Description VARCHAR(500),LastStart VARCHAR(500),LastStart_Result VARCHAR(500),
							LastSuccessfulEnd varchar(500), JobInfo varchar(500), JobStatusInfo varchar(500))
AS
BEGIN
	IF @pJobScheduleName IS NULL
		RETURN

	DECLARE @desc varchar(500)
	DECLARE @LastStart varchar(500)
	DECLARE @LastStartdt varchar(500)
	DECLARE @LastStart_Result varchar(500)
	DECLARE @LastSuccessfulEnd varchar(500)
	DECLARE @JobInfo varchar(500)
	DECLARE @repeattime varchar(500)
	DECLARE @JobScheduleName varchar(500)
	DECLARE @Inactive int
	SELECT @inactive = 1
	DECLARE @JobStatusInfo varchar(500)

	DECLARE @jobschid uniqueidentifier
	SELECT TOP 1 @jobschid = jobscheduleuid, @JobScheduleName = Name, @inactive = inactive
		 FROM JobSchedule WHERE name = @pJobScheduleName 
		ORDER BY Inactive ASC  -- put active jobs first

	IF @jobschid IS NULL OR @inactive = 1  -- no job found or it is inactive then use a more liberal search
		SELECT TOP 1 @jobschid = jobscheduleuid, @JobScheduleName = Name, @inactive = inactive
		 FROM JobSchedule WHERE name LIKE (''%'' + @pJobScheduleName + ''%'')
		ORDER BY Inactive ASC -- put active jobs first

	IF @jobschid IS NULL
	begin
		INSERT INTO @output (JobScheduleName, Description)
		SELECT @pJobScheduleName,''Job not found''
		RETURN
	END
	
	IF isnull(@inactive,1) = 1
	BEGIN
		INSERT INTO @output (jobschedulename, description)
		SELECT @JobScheduleName,''***Job is inactive''
		RETURN
	end

	SELECT @JobInfo = ''Repeat Interval = '' + isnull(JobRepeatInterval, ''n/a'') + '' '' + isnull(enumname, ''unknown interval'')
		FROM JobSchedule JS WITH (nolock)
		LEFT JOIN ListJobScheduleTimeBase lj WITH (nolock) ON JS.JobScheduleTimeBaseUid = lj.JobScheduleTimeBaseUid
		WHERE JS.JobScheduleUid = @jobschid

	SELECT @desc = ''job''

	DECLARE @status int
	DECLARE @finishtimeoflaststart datetime

	SELECT TOP 1 @laststartdt = datestarted, @status = Status, @finishtimeoflaststart = dateended, @JobStatusInfo=Convert(varchar(500),JobInfo)
		FROM jobhistory WITH (nolock) 
		WHERE jobscheduleuid = @jobschid
		ORDER BY datestarted desc

	IF @laststartdt IS NULL
	begin
		SELECT @LastStart = ''No last start date found'', @LastStart_Result = ''n/a''
	end
	else
	begin
		SELECT @LastStart =''Last started = '' + convert(varchar(30), @laststartdt), 
				@LastStart_Result = ''Result Status = '' + convert(varchar(20), @status) +
				''  This entry completed at '' + isnull(convert(varchar(30), @laststartdt), ''Didn''''t complete'')
	end

	SELECT TOP 1 @LastSuccessfulEnd = convert(varchar(50),dateended )
		FROM jobhistory with(nolock)
		WHERE jobscheduleuid = @jobschid
			AND status = 0
		ORDER BY dateended desc

	IF @LastSuccessfulEnd IS NULL
	begin
		SELECT @LastSuccessfulEnd = ''No DateEnded found for a successful run''
	end

	INSERT INTO @output
	SELECT @JobScheduleName, @desc, @LastStart, @LastStart_Result, @LastSuccessfulEnd, @JobInfo, @JobStatusInfo

	return
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ReduceList]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[ReduceList]
	(
		@fullList varchar(max),
		@delimiter varchar(1)
	)
RETURNS varchar(max)
AS
BEGIN

    -- Gives us a delimited list that is reduced with first,...,final where more than 3 items in list
	-- 20171121	BRoy	Created

	IF (@fullList IS NULL OR @fullList = '''' or @delimiter IS NULL OR @delimiter = '''' OR @delimiter = '' '')
		return @fullList;

	DECLARE @temp_Values TABLE -- taking definition of SPLIT function
	(
		ElementId SMALLINT,
		Element VARCHAR(1000)
	)

	INSERT INTO @temp_Values (ElementId, Element)
	SELECT * 
		FROM dbo.Split(@fullList, @delimiter)

	DECLARE @itemCount int;
	SELECT @itemCount = COUNT(*)
		FROM @temp_Values;

	IF (@itemCount <= 3)
		return @fullList;

	DECLARE @firstVal VARCHAR(MAX);
	DECLARE @finalVal VARCHAR(MAX);
	SELECT TOP 1 @firstVal = Element FROM @temp_Values ORDER BY ElementId ASC
	SELECT TOP 1 @finalVal = Element FROM @temp_Values ORDER BY ElementId DESC 

	return @firstVal + @delimiter + ''...'' + @delimiter +  @finalVal;

END

/*
	SELECT dbo.ReduceList(''Lorem,ipsum,dolor,sit,amet'', '','') -- normal
	SELECT dbo.ReduceList(''Lorem,sit'', '','') -- get list back - no work
	SELECT dbo.ReduceList(''Lorem,sit,amet'', '','') -- get list back - no work
	SELECT dbo.ReduceList(''Lorem,ipsum,dolor,sit,amet'', null) -- get list back - no work
	SELECT dbo.ReduceList(''Lorem,ipsum,dolor,sit,amet'', '' '') -- get list back - no work
	SELECT dbo.ReduceList(null, '','') -- get list back - no work
*/


' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RegexMatch]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[RegexMatch](@input [nvarchar](max), @pattern [nvarchar](max))
RETURNS [bit] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[RegexMatch]' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RegexReplace]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[RegexReplace](@input [nvarchar](max), @pattern [nvarchar](max), @replacement [nvarchar](max))
RETURNS [nvarchar](max) WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[RegexReplace]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Replication_GetDateTimeSetting]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[Replication_GetDateTimeSetting]
(
	@cacheMachineUid UNIQUEIDENTIFIER,
	@useDateOnly BIT
)
RETURNS 
	@vCacheMachine TABLE
	(
		CacheMachineUid UNIQUEIDENTIFIER,
		ApptStartDateTime DATETIME,
		ApptEndDateTime DATETIME,
		DischargeDate DATETIME,
		ReplicateEverything BIT
	)
AS
BEGIN
	DECLARE @inactive BIT,
			@replicateEverything BIT
	SELECT @inactive = 0,
		   @replicateEverything = 0
		   
	-- Get practice setting value for appoint window
	DECLARE @psHours AS INT
	SELECT TOP 1 @psHours = ReplicationAppointmentHours
	FROM PracticeSettings
	ORDER BY LastModifiedDate DESC

	INSERT INTO @vCacheMachine (CacheMachineUid, ApptStartDateTime, ApptEndDateTime, DischargeDate, ReplicateEverything)
	SELECT CacheMachineUid, 
		CASE WHEN @useDateOnly <> 0 THEN
			CAST(DATEADD(hh, -8, GETDATE()) AS DATE)
		ELSE
			DATEADD(hh, -8, GETDATE ())
		END,
		CASE WHEN @useDateOnly <> 0 THEN
			CAST(DATEADD(d, 1, DATEADD(hh, COALESCE(ReplicationAppointmentHours, @psHours, 48), GETDATE())) AS DATE)
		ELSE			
			DATEADD(hh, COALESCE(ReplicationAppointmentHours, @psHours, 48), GETDATE ())
		END,
		CASE WHEN @useDateOnly <> 0 THEN
			CAST(GETDATE() AS DATE)
		ELSE
			GETDATE ()
		END,
		ReplicateEverything
	FROM ViewListCacheMachine
	WHERE CacheMachineUid = @cacheMachineUid
		AND Inactive = @inactive
	RETURN 
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Replication_GetPurgeObjectInterval]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[Replication_GetPurgeObjectInterval]
(
	@CacheMachineUid [uniqueidentifier]
)
RETURNS [int]
AS
BEGIN
	DECLARE @ReplicationRemovePatientHours [int]

	SELECT @ReplicationRemovePatientHours = [ReplicationRemovePatientHours]
	FROM [ViewListCacheMachine]
	WHERE [CacheMachineUid] = @CacheMachineUid

	IF @ReplicationRemovePatientHours IS NULL
	BEGIN
		SELECT TOP 1 @ReplicationRemovePatientHours = [ReplicationRemovePatientHours]
		FROM [PracticeSettings]
		WHERE [ReplicationRemovePatientHours] IS NOT NULL
		ORDER BY [LastModifiedDate] DESC
	END

	return COALESCE(@ReplicationRemovePatientHours, 120) -- default to 5 days
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Replication_ServerContext]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[Replication_ServerContext]
(
)
RETURNS varchar(max)
AS
BEGIN
	DECLARE @serverContext varchar(max),
			@Inactive BIT,
			@ReplicatedDB BIT,
			@CacheMachineUid UNIQUEIDENTIFIER,
			@URL VARCHAR (255)
			
	SELECT @Inactive = 0,
		   @URL = CAST (SERVERPROPERTY (''MachineName'') AS VARCHAR (255))
		
	SELECT TOP 1 @ReplicatedDB =
		CASE WHEN URL = @URL
				OR EXISTS ( 
							SELECT TOP 1 *
							FROM ListCacheMachine AS t
								INNER JOIN ReplicationSettings AS t1 ON t.URL = @URL
									AND t1.Name = ''Replication.IsCacheServer''
									AND t.CacheMachineUid = t1.GuidValue
									AND t1.BoolValue <> 0
						  )
				OR EXISTS (
							SELECT TOP 1 *
							FROM ListCacheMachine AS t
								INNER JOIN ReplicationSettings AS t1 ON t.URL = @URL
									AND t1.Name = ''Replication.STSReconfigInfo''
									AND t.CacheMachineUid = t1.GuidValue
						  )
				OR NOT EXISTS (
								SELECT TOP 1 *
								FROM ReplicationFilter
								WHERE CacheMachineUid = t.CacheMachineUid
									AND TableName = ''ListCacheMachine''
							   )
			 THEN CAST (1 AS BIT)
			 ELSE CAST (0 AS BIT)
		END,
		@CacheMachineUid = t.CacheMachineUid
	FROM ViewListCacheMachine AS t
	WHERE URL = @URL
		AND Inactive = @Inactive
	
	IF @ReplicatedDB <> 0
	BEGIN
		SET @serverContext =
			CAST ((
					SELECT ServerConfigXML
					FROM ReplicationStatus
					WHERE ReplicationStatusUid = @CacheMachineUid
				  ) AS varchar (max))
	END
    RETURN @serverContext
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ReturnUinqueID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE  FUNCTION [dbo].[ReturnUinqueID] --by LGodolphin 08/16/05
(
@TableName 	varchar(255) = '''',
@Constraint	varchar(255) = ''ExternalID''
)
RETURNS int
AS
BEGIN

DECLARE 
@Seed		int,
@SeedString	varchar(80),
@Count		int,
@ParmDefinition nvarchar(255), 
@SQLString 	nvarchar(255)

--IF ((@TableName <> '''') AND (EXISTS (SELECT * FROM dbo.sysobjects WHERE id = object_id(N''[dbo].['' + @TableName + '']'') and OBJECTPROPERTY(id, N''IsUserTable'') = 1)))
--BEGIN

  --print ''GetUniqueID - Begin''
  WHILE (@TableName<>'''') 
  BEGIN
  
    EXEC @Seed = GetSeed @TableName
    SET @SeedString = CONVERT(varchar(80), @Seed)
    --print ''Seed: '' + @SeedString
    SET @ParmDefinition = N''@SeedValue varchar(80), @CountValue int OUT''
    SET @SQLString = N''SET @CountValue = (SELECT Count(*) FROM '' + @TableName + '' WHERE '' + @Constraint + '' = @SeedValue)''

    EXECUTE sp_executesql @SQLString, @ParmDefinition, @SeedValue = @SeedString,
                      @CountValue = @Count OUTPUT

      IF @Count = 0
        BEGIN
	  --print ''getUniqueID - Seed: '' + convert(varchar(20), @Seed)
	  BREAK
        END
  END --While

--END --IF @TableName<>''''
RETURN @Seed

END --Procedure


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RxGetDigitString]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[RxGetDigitString](@DigitValue varchar)
RETURNS varchar(5)
AS
BEGIN

	DECLARE @DigitString varchar(5)
	SET @DigitString = CASE @DigitValue
				WHEN ''0'' THEN ''''
				WHEN ''1'' THEN ''one''
				WHEN ''2'' THEN ''two''
				WHEN ''3'' THEN ''three''
				WHEN ''4'' THEN ''four''
				WHEN ''5'' THEN ''five''
				WHEN ''6'' THEN ''six''
				WHEN ''7'' THEN ''seven''
				WHEN ''8'' THEN ''eight''
				WHEN ''9'' THEN ''nine''
				ELSE @DigitValue
			END
	RETURN @DigitString
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RxGetNumberString]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[RxGetNumberString] (
		@Number varchar(38) -- Input number with as many as 18 digits
) RETURNS VARCHAR(8000) 
/*
* Converts a integer number as large as 34 digits into the 
* equivalent words.  The first letter is capitalized.
*
* Attribution: Based on NumberToWords by Srinivas Sampath
*        as revised by Nick Barclay
*
* Example:
select dbo.udf_Num_ToWords (1234567890) + CHAR(10)
      +  dbo.udf_Num_ToWords (0) + CHAR(10)
      +  dbo.udf_Num_ToWords (123) + CHAR(10)
select dbo.udf_Num_ToWords(76543210987654321098765432109876543210)
 
DECLARE @i numeric (38,0)
SET @i = 0
WHILE @I <= 1000 BEGIN 
    PRINT convert (char(5), @i)  
            + convert(varchar(255), dbo.udf_Num_ToWords(@i)) 
    SET @I  = @i + 1 
END
*
* Published as the T-SQL UDF of the Week Vol 2 #9 2/17/03
****************************************************************/
AS BEGIN
DECLARE @inputNumber VARCHAR(38)
DECLARE @NumbersTable TABLE (number CHAR(2), word VARCHAR(10))
DECLARE @outputString VARCHAR(8000)
DECLARE @length INT
DECLARE @counter INT
DECLARE @loops INT
DECLARE @position INT
DECLARE @chunk CHAR(3) -- for chunks of 3 numbers
DECLARE @tensones CHAR(2)
DECLARE @hundreds CHAR(1)
DECLARE @tens CHAR(1)
DECLARE @ones CHAR(1)

--clean up @Number by removing anything non-numeric and removing anything 
--to the right of the non-numeric
DECLARE @nPos    INTEGER

SELECT  @nPos = PATINDEX(''%[^0-9]%'', @Number)

 WHILE @nPos > 0
 BEGIN
	SELECT @Number = STUFF(@Number, @nPos, len(@Number), '''')
	SELECT  @nPos = PATINDEX(''%[^0-9]%'', @Number)
 END

 IF ISNUMERIC(@Number) = 1  
 BEGIN 
	IF @Number = 0 Return ''Zero''

	-- initialize the variables
	SELECT @inputNumber = CONVERT(varchar(38), @Number)
		 , @outputString = ''''
		 , @counter = 1
	SELECT @length   = LEN(@inputNumber)
		 , @position = LEN(@inputNumber) - 2
		 , @loops    = LEN(@inputNumber)/3

	-- make sure there is an extra loop added for the remaining numbers
	IF LEN(@inputNumber) % 3 <> 0 SET @loops = @loops + 1

	-- insert data for the numbers and words
	INSERT INTO @NumbersTable   SELECT ''00'', ''''
		UNION ALL SELECT ''01'', ''one''      UNION ALL SELECT ''02'', ''two''
		UNION ALL SELECT ''03'', ''three''    UNION ALL SELECT ''04'', ''four''
		UNION ALL SELECT ''05'', ''five''     UNION ALL SELECT ''06'', ''six''
		UNION ALL SELECT ''07'', ''seven''    UNION ALL SELECT ''08'', ''eight''
		UNION ALL SELECT ''09'', ''nine''     UNION ALL SELECT ''10'', ''ten''
		UNION ALL SELECT ''11'', ''eleven''   UNION ALL SELECT ''12'', ''twelve''
		UNION ALL SELECT ''13'', ''thirteen'' UNION ALL SELECT ''14'', ''fourteen''
		UNION ALL SELECT ''15'', ''fifteen''  UNION ALL SELECT ''16'', ''sixteen''
		UNION ALL SELECT ''17'', ''seventeen'' UNION ALL SELECT ''18'', ''eighteen''
		UNION ALL SELECT ''19'', ''nineteen'' UNION ALL SELECT ''20'', ''twenty''
		UNION ALL SELECT ''30'', ''thirty''   UNION ALL SELECT ''40'', ''forty''
		UNION ALL SELECT ''50'', ''fifty''    UNION ALL SELECT ''60'', ''sixty''
		UNION ALL SELECT ''70'', ''seventy''  UNION ALL SELECT ''80'', ''eighty''
		UNION ALL SELECT ''90'', ''ninety''   

	WHILE @counter <= @loops BEGIN

		-- get chunks of 3 numbers at a time, padded with leading zeros
		SET @chunk = RIGHT(''000'' + SUBSTRING(@inputNumber, @position, 3), 3)

		IF @chunk <> ''000'' BEGIN
			SELECT @tensones = SUBSTRING(@chunk, 2, 2)
				 , @hundreds = SUBSTRING(@chunk, 1, 1)
				 , @tens = SUBSTRING(@chunk, 2, 1)
				 , @ones = SUBSTRING(@chunk, 3, 1)

			-- If twenty or less, use the word directly from @NumbersTable
			IF CONVERT(int, @tensones) <= 20 OR @Ones=''0'' BEGIN
				SET @outputString = (SELECT word 
										  FROM @NumbersTable 
										  WHERE @tensones = number)
					   + CASE @counter WHEN 1 THEN '''' -- No name
						   WHEN 2 THEN '' thousand '' WHEN 3 THEN '' million ''
						   WHEN 4 THEN '' billion ''  WHEN 5 THEN '' trillion ''
						   WHEN 6 THEN '' quadrillion '' WHEN 7 THEN '' quintillion ''
						   WHEN 8 THEN '' sextillion ''  WHEN 9 THEN '' septillion ''
						   WHEN 10 THEN '' octillion ''  WHEN 11 THEN '' nonillion ''
						   WHEN 12 THEN '' decillion ''  WHEN 13 THEN '' undecillion ''
						   ELSE '''' END
								   + @outputString
				END
			 ELSE BEGIN -- break down the ones and the tens separately

				 SET @outputString = '' '' 
								+ (SELECT word 
										FROM @NumbersTable 
										WHERE @tens + ''0'' = number)
								 + ''-''
								 + (SELECT word 
										FROM @NumbersTable 
										WHERE ''0''+ @ones = number)
					   + CASE @counter WHEN 1 THEN '''' -- No name
						   WHEN 2 THEN '' thousand '' WHEN 3 THEN '' million ''
						   WHEN 4 THEN '' billion ''  WHEN 5 THEN '' trillion ''
						   WHEN 6 THEN '' quadrillion '' WHEN 7 THEN '' quintillion ''
						   WHEN 8 THEN '' sextillion ''  WHEN 9 THEN '' septillion ''
						   WHEN 10 THEN '' octillion ''  WHEN 11 THEN '' nonillion ''
						   WHEN 12 THEN '' decillion ''   WHEN 13 THEN '' undecillion ''
						   ELSE '''' END
								+ @outputString
			END

			-- now get the hundreds
			IF @hundreds <> ''0'' BEGIN
				SET @outputString  = (SELECT word 
										  FROM @NumbersTable 
										  WHERE ''0'' + @hundreds = number)
									+ '' hundred '' 
									+ @outputString
			END
		END

		SELECT @counter = @counter + 1
			 , @position = @position - 3

	END

	-- Remove any double spaces
	SET @outputString = LTRIM(RTRIM(REPLACE(@outputString, ''  '', '' '')))
	SET @outputstring = UPPER(LEFT(@outputstring, 1)) + SUBSTRING(@outputstring, 2, 8000)
	
END

RETURN @outputString -- return the result
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RxGetTeenString]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[RxGetTeenString](@Value varchar(2))
RETURNS varchar(9)
AS
BEGIN

	DECLARE @String varchar(9)
	SET @String = CASE RIGHT(@Value,1)
				WHEN ''0'' THEN ''ten''
				WHEN ''1'' THEN ''eleven''
				WHEN ''2'' THEN ''twelve''
				WHEN ''3'' THEN ''thirteen''
				WHEN ''4'' THEN ''fourteen''
				WHEN ''5'' THEN ''fifteen''
				WHEN ''6'' THEN ''sixteen''
				WHEN ''7'' THEN ''seventeen''
				WHEN ''8'' THEN ''eighteen''
				WHEN ''9'' THEN ''nineteen''
				ELSE @Value
			END
	RETURN @String
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RxGetTensString]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[RxGetTensString](@Value varchar)
RETURNS varchar(7)
AS
BEGIN

	DECLARE @String varchar(7)
	SET @String = CASE @Value
				WHEN ''0'' THEN ''''
				WHEN ''1'' THEN ''ten''
				WHEN ''2'' THEN ''twenty''
				WHEN ''3'' THEN ''thirty''
				WHEN ''4'' THEN ''forty''
				WHEN ''5'' THEN ''fifty''
				WHEN ''6'' THEN ''sixty''
				WHEN ''7'' THEN ''seventy''
				WHEN ''8'' THEN ''eighty''
				WHEN ''9'' THEN ''ninety''
				ELSE @Value
			END
	RETURN @String
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RxNormCode]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[RxNormCode](@mnid int) RETURNS VARCHAR(50) AS
BEGIN
/*
	Created 02/05/2010
	
	Finds and returns the Rx Norm Code for a given medication name.
	
	Parameter @mnid is the PK of table fdb_DrugName used to find the Rx Norm Code.
	
*/
	declare @hicl int
	declare @baseingredientid int
	declare @nametypecode varchar(1)

	declare @RxNormCode varchar(50)

	-- assign @nametypecode
	SELECT @nametypecode = nametypecode FROM FDB_DrugName WHERE mnid = @mnid
		
	-- assign @hicl
	SELECT @hicl = hicl FROM fdb_mnid_hicl WHERE mnid = @mnid

	IF (@nametypecode = ''1'')
	BEGIN
		-- try to find brand name
		SELECT @RxNormCode = EVD_EXT_VOCAB_ID 
			FROM fdb_REVDEL0_EXT_VOCAB_LINK
			WHERE EVD_FDB_VOCAB_ID = CONVERT(varchar(255), @mnid)
					AND EVD_FDB_VOCAB_TYPE_ID = 1
	END

	IF ((@RxNormCode is null) OR (@RxNormCode = ''''))
	BEGIN
		-- generic drug name
		
		-- find value for baseingredientid
		SELECT @baseingredientid = ing.baseingredientid 
			FROM fdb_hicseqno_baseingredient ing
				INNER JOIN fdb_hicl_hicseqno hic ON ing.hicseqno = hic.hicseqno
			WHERE hic.hicl = @hicl

		SELECT @RxNormCode = EVD_EXT_VOCAB_ID 
			FROM fdb_REVDEL0_EXT_VOCAB_LINK
			WHERE EVD_FDB_VOCAB_ID = CONVERT(varchar(255), @baseingredientid)
				AND EVD_EXT_VOCAB_TYPE_ID = 500
				AND EVD_FDB_VOCAB_TYPE_ID = 104

	END

	RETURN @RxNormCode

END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RxNormCodeFromMedID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[RxNormCodeFromMedID](@medid int) RETURNS VARCHAR(50) AS
BEGIN
/*
	Created 10/11/2010
	
	Finds and returns the Rx Norm Code for a given dispensable medication.
	
	Parameter @medid is the PK of table FDB_Dispensable used to find the Rx Norm Code.
	
*/
	DECLARE @RxNormCode VARCHAR(50)

    SELECT @RxNormCode = (SELECT TOP(1) rev.EVD_EXT_VOCAB_ID
                          FROM fdb_REVDEL0_EXT_VOCAB_LINK rev
                          WHERE rev.EVD_FDB_VOCAB_ID  = CONVERT(varchar(255), dis.medid)
                            AND EVD_FDB_VOCAB_TYPE_ID = 3
                            AND EVD_LINK_TYPE_ID IN(1, 5)  -- 5=brand name  1=generic name
                          ORDER BY CASE dis.nametypecode WHEN ''1'' THEN -rev.EVD_LINK_TYPE_ID ELSE rev.EVD_LINK_TYPE_ID END, EVD_EXT_VOCAB_TYPE_ID)
    FROM fdb_dispensable dis
    WHERE dis.medid = @medid

	RETURN @RxNormCode
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RxNormCodeFromQuestionUid]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[RxNormCodeFromQuestionUid](@QuestionUid uniqueidentifier) RETURNS VARCHAR(50) AS
BEGIN
/*
	Created 10/11/2010
	
	Finds and returns the Rx Norm Code for a given row from the ListQuestion table.
	
	Parameter @QuestionUid is the PK of table ListQuestion.
	
*/
	declare @RxNormCode varchar(50)
	declare @mnid int
	
	SET @RxNormCode = ''''
	
	SELECT @mnid = FDB_HIC_SEQN FROM ListQuestion WHERE QuestionUid = @QuestionUid AND FDBIDType = ''DrugName''
	
	IF (@mnid is not null AND @mnid > 0)
	BEGIN
		SELECT @RxNormCode = dbo.RxNormCode(@mnid)
	END
	
	return @RxNormCode
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RxNormQualifierFromMedID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[RxNormQualifierFromMedID](@medid int) RETURNS VARCHAR(10) AS
BEGIN
/*
	Created 10/11/2010
	
	Finds and returns the Rx Norm Code Qualifier for a given dispensable medication.
	
	Parameter @medid is the PK of table FDB_Dispensable used to find the Rx Norm Code Qualifier.
	
*/
   DECLARE @RxNormCode VARCHAR(50)

   SELECT
      @RxNormCode                = (SELECT TOP(1) CASE WHEN EVD_LINK_TYPE_ID = 5 THEN ''SBD'' ELSE ''SCD'' END
                                    FROM fdb_REVDEL0_EXT_VOCAB_LINK rev
                                    WHERE rev.EVD_FDB_VOCAB_ID  = CONVERT(varchar(255), dis.medid)
                                      AND EVD_FDB_VOCAB_TYPE_ID = 3
                                      AND EVD_LINK_TYPE_ID IN(1, 5)
                                    ORDER BY CASE dis.nametypecode WHEN ''1'' THEN -rev.EVD_LINK_TYPE_ID ELSE rev.EVD_LINK_TYPE_ID END, EVD_EXT_VOCAB_TYPE_ID)
   FROM  dbo.fdb_dispensable dis 
   WHERE dis.medid = @medid

   RETURN @RxNormCode
END
' 
END

GO
SET ANSI_NULLS OFF
GO
SET QUOTED_IDENTIFIER OFF
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SafeXmlCast]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[SafeXmlCast](@value [nvarchar](max))
RETURNS [xml] WITH EXECUTE AS CALLER
AS 
EXTERNAL NAME [PRMDatabaseCLR].[UserDefinedFunctions].[SafeXmlCast]' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ScrubXmlContentTag]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ScrubXmlContentTag](@Src xml)
RETURNS xml AS

BEGIN
	declare @Xml xml

	if CONVERT(VARCHAR(max), @src) is null
		return @Src

	set @Xml = @Src
	set @Xml.modify(''replace value of (/DirectMessages/Attachments/AttachmentData/Content/text())[1] with ""'')

	return @Xml
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ServiceLevelCode]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ServiceLevelCode]
(
	@nServiceLevelCode int
)
RETURNS VARCHAR (1024)
AS
BEGIN
	-- Declare the return variable here
	DECLARE @vcServiceLevelCode VARCHAR (1024)
	SET @vcServiceLevelCode = ''''
	
	IF @nServiceLevelCode IS NULL
		SET @vcServiceLevelCode = ''None''
	ELSE
	BEGIN
		/*
			1 New Rx
			2 Refill
			4 Change
			8 RxFill
			16 Cancel
			32 MedHistory
			64 Eligibility
			128 Not used
			256 Resupply
			512 Census
			1,024 CCR
			2,048 Controlled Substance (EPCS)	
		*/
		IF @nServiceLevelCode & 1 = 1
			SET @vcServiceLevelCode = ''NewRx''

		IF @nServiceLevelCode & 2 = 2
		BEGIN
			IF LEN (@vcServiceLevelCode) > 1
				SET @vcServiceLevelCode = @vcServiceLevelCode + '', ''
			SET @vcServiceLevelCode = @vcServiceLevelCode + ''RefReq/RefRes''
		END

		IF @nServiceLevelCode & 4 = 4
		BEGIN
			IF LEN (@vcServiceLevelCode) > 1
				SET @vcServiceLevelCode = @vcServiceLevelCode + '', ''
			SET @vcServiceLevelCode = @vcServiceLevelCode + ''RxChg/ChgRes''
		END

		IF @nServiceLevelCode & 8 = 8
		BEGIN
			IF LEN (@vcServiceLevelCode) > 1
				SET @vcServiceLevelCode = @vcServiceLevelCode + '', ''
			SET @vcServiceLevelCode = @vcServiceLevelCode + ''RxFill''
		END

		IF @nServiceLevelCode & 16 = 16
		BEGIN
			IF LEN (@vcServiceLevelCode) > 1
				SET @vcServiceLevelCode = @vcServiceLevelCode + '', ''
			SET @vcServiceLevelCode = @vcServiceLevelCode + ''CanRx/CanRxRes''
		END

		IF @nServiceLevelCode & 32 = 32
		BEGIN
			IF LEN (@vcServiceLevelCode) > 1
				SET @vcServiceLevelCode = @vcServiceLevelCode + '', ''
			SET @vcServiceLevelCode = @vcServiceLevelCode + ''Medication History''
		END

		IF @nServiceLevelCode & 64 = 64
		BEGIN
			IF LEN (@vcServiceLevelCode) > 1
				SET @vcServiceLevelCode = @vcServiceLevelCode + '', ''
			SET @vcServiceLevelCode = @vcServiceLevelCode + ''Eligibility''
		END
		
		IF @nServiceLevelCode & 256 = 256
		BEGIN
			IF LEN (@vcServiceLevelCode) > 1
				SET @vcServiceLevelCode = @vcServiceLevelCode + '', ''
			SET @vcServiceLevelCode = @vcServiceLevelCode + ''Resupply''
		END

		IF @nServiceLevelCode & 512 = 512
		BEGIN
			IF LEN (@vcServiceLevelCode) > 1
				SET @vcServiceLevelCode = @vcServiceLevelCode + '', ''
			SET @vcServiceLevelCode = @vcServiceLevelCode + ''Census''
		END

		IF @nServiceLevelCode & 1024 = 1024
		BEGIN
			IF LEN (@vcServiceLevelCode) > 1
				SET @vcServiceLevelCode = @vcServiceLevelCode + '', ''
			SET @vcServiceLevelCode = @vcServiceLevelCode + ''CCR''
		END

		IF @nServiceLevelCode & 2048 = 2048
		BEGIN
			IF LEN (@vcServiceLevelCode) > 1
				SET @vcServiceLevelCode = @vcServiceLevelCode + '', ''
			SET @vcServiceLevelCode = @vcServiceLevelCode + ''Controlled Substance (EPCS)''
		END
	END

	-- Return the result of the function
	RETURN @vcServiceLevelCode
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SpecialtyIDCode]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[SpecialtyIDCode]
(
	@nSpecialtyIDCode int
)
RETURNS VARCHAR (1024)
AS
BEGIN
	-- Declare the return variable here
	DECLARE @vcSpecialtyIDCode VARCHAR (1024)
	SET @vcSpecialtyIDCode = ''''
	
	IF @nSpecialtyIDCode IS NULL
		SET @vcSpecialtyIDCode = '''' -- ''None''
	ELSE
	BEGIN
		IF @nSpecialtyIDCode & 1 = 1
			SET @vcSpecialtyIDCode = ''Mail Order''

		IF @nSpecialtyIDCode & 2 = 2
		BEGIN
			IF LEN (@vcSpecialtyIDCode) > 1
				SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + '', ''
			SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + ''Fax''
		END

		IF @nSpecialtyIDCode & 4 = 4
		BEGIN
			IF LEN (@vcSpecialtyIDCode) > 1
				SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + '', ''
			SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + ''MedReconciliation''
		END

		IF @nSpecialtyIDCode & 8 = 8
		BEGIN
			IF LEN (@vcSpecialtyIDCode) > 1
				SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + '', ''
			SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + ''Retail''
		END

		IF @nSpecialtyIDCode & 16 = 16
		BEGIN
			IF LEN (@vcSpecialtyIDCode) > 1
				SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + '', ''
			SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + ''Specialty''
		END

		IF @nSpecialtyIDCode & 32 = 32
		BEGIN
			IF LEN (@vcSpecialtyIDCode) > 1
				SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + '', ''
			SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + ''Long-Term Care''
		END

		IF @nSpecialtyIDCode & 64 = 64
		BEGIN
			IF LEN (@vcSpecialtyIDCode) > 1
				SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + '', ''
			SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + ''24 Hour''
		END
		
		IF @nSpecialtyIDCode & 256 = 256
		BEGIN
			IF LEN (@vcSpecialtyIDCode) > 1
				SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + '', ''
			SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + ''Physician Assistant''
		END

		IF @nSpecialtyIDCode & 256 = 256
		BEGIN
			IF LEN (@vcSpecialtyIDCode) > 1
				SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + '', ''
			SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + ''Resupply''
		END

		IF @nSpecialtyIDCode & 512 = 512
		BEGIN
			IF LEN (@vcSpecialtyIDCode) > 1
				SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + '', ''
			SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + ''Nurse Practitioner''
		END

		IF @nSpecialtyIDCode & 1024 = 1024
		BEGIN
			IF LEN (@vcSpecialtyIDCode) > 1
				SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + '', ''
			SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + ''Resident''
		END

		IF @nSpecialtyIDCode & 2048 = 2048
		BEGIN
			IF LEN (@vcSpecialtyIDCode) > 1
				SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + '', ''
			SET @vcSpecialtyIDCode = @vcSpecialtyIDCode + ''In-Store Clinic''
		END
	END

	-- Return the result of the function
	RETURN @vcSpecialtyIDCode
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Split_CSRx]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[Split_CSRx]
 (	@vcDelimitedString VARCHAR(8000),
	@vcDelimiter VARCHAR(100) 
 )

RETURNS @tblArray TABLE
   (
	ElementID	smallint	IDENTITY(1,1),  --Array index
   	Element		varchar(1000)			--Array element contents
   )
AS
BEGIN

	DECLARE
	@siIndex	SMALLINT,
	@siStart		SMALLINT,
	@siDelSize	SMALLINT


	SET @siDelSize	= LEN(@vcDelimiter)
	--loop through source string and add elements to destination table array
	WHILE LEN(@vcDelimitedString) > 0
	BEGIN
		SET @siIndex = CHARINDEX(@vcDelimiter, @vcDelimitedString)
		IF @siIndex = 0
		BEGIN
			INSERT INTO @tblArray VALUES(@vcDelimitedString)
			BREAK
		END
		ELSE
		BEGIN
			INSERT INTO @tblArray VALUES(SUBSTRING(@vcDelimitedString, 1,@siIndex - 1))
			SET @siStart = @siIndex + @siDelSize
			SET @vcDelimitedString = SUBSTRING(@vcDelimitedString, @siStart , LEN(@vcDelimitedString) - @siStart + 1)
		END
	END

	RETURN
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Split_RVUProductivityReport]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[Split_RVUProductivityReport]
 (	@vcDelimitedString VARCHAR(8000),
	@vcDelimiter VARCHAR(100) 
 )

RETURNS @tblArray TABLE
   (
	ElementID	smallint	IDENTITY(1,1),  --Array index
   	Element		varchar(1000)			--Array element contents
   )
AS
BEGIN

	DECLARE
	@siIndex	SMALLINT,
	@siStart		SMALLINT,
	@siDelSize	SMALLINT


	SET @siDelSize	= LEN(@vcDelimiter)
	--loop through source string and add elements to destination table array
	WHILE LEN(@vcDelimitedString) > 0
	BEGIN
		SET @siIndex = CHARINDEX(@vcDelimiter, @vcDelimitedString)
		IF @siIndex = 0
		BEGIN
			INSERT INTO @tblArray VALUES(@vcDelimitedString)
			BREAK
		END
		ELSE
		BEGIN
			INSERT INTO @tblArray VALUES(SUBSTRING(@vcDelimitedString, 1,@siIndex - 1))
			SET @siStart = @siIndex + @siDelSize
			SET @vcDelimitedString = SUBSTRING(@vcDelimitedString, @siStart , LEN(@vcDelimitedString) - @siStart + 1)
		END
	END

	RETURN
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[Split_RVUReport]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[Split_RVUReport]
 (	@vcDelimitedString VARCHAR(8000),
	@vcDelimiter VARCHAR(100) 
 )

RETURNS @tblArray TABLE
   (
	ElementID	smallint	IDENTITY(1,1),  --Array index
   	Element		varchar(1000)			--Array element contents
   )
AS
BEGIN

	DECLARE
	@siIndex	SMALLINT,
	@siStart		SMALLINT,
	@siDelSize	SMALLINT


	SET @siDelSize	= LEN(@vcDelimiter)
	--loop through source string and add elements to destination table array
	WHILE LEN(@vcDelimitedString) > 0
	BEGIN
		SET @siIndex = CHARINDEX(@vcDelimiter, @vcDelimitedString)
		IF @siIndex = 0
		BEGIN
			INSERT INTO @tblArray VALUES(@vcDelimitedString)
			BREAK
		END
		ELSE
		BEGIN
			INSERT INTO @tblArray VALUES(SUBSTRING(@vcDelimitedString, 1,@siIndex - 1))
			SET @siStart = @siIndex + @siDelSize
			SET @vcDelimitedString = SUBSTRING(@vcDelimitedString, @siStart , LEN(@vcDelimitedString) - @siStart + 1)
		END
	END

	RETURN
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SplitList_AS]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[SplitList_AS] (@list VARCHAR(MAX), @separator VARCHAR(MAX) = '','')  
RETURNS @table TABLE   
(  
	Value VARCHAR(MAX))AS   
	BEGIN     
		DECLARE @position INT,   
		@previous INT     
		SET @list = @list + @separator     
		SET @previous = 1     
		SET @position = CHARINDEX(@separator, @list)     
		WHILE @position > 0   
			BEGIN        
			IF @position - @previous > 0           
				INSERT INTO @table VALUES (SUBSTRING(@list, @previous, @position - @previous))        
				IF @position >= LEN(@list)   
					BREAK        
			SET @previous = @position + 1        
			SET @position = CHARINDEX(@separator, @list, @previous)     
		END     
	RETURN  
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SplitList_FS]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[SplitList_FS] (@list VARCHAR(MAX), @separator VARCHAR(MAX) = '','')  
RETURNS @table TABLE   
(  
	Value VARCHAR(MAX))AS   
	BEGIN     
		DECLARE @position INT,   
		@previous INT     
		SET @list = @list + @separator     
		SET @previous = 1     
		SET @position = CHARINDEX(@separator, @list)     
		WHILE @position > 0   
			BEGIN        
			IF @position - @previous > 0           
				INSERT INTO @table VALUES (SUBSTRING(@list, @previous, @position - @previous))        
				IF @position >= LEN(@list)   
					BREAK        
			SET @previous = @position + 1        
			SET @position = CHARINDEX(@separator, @list, @previous)     
		END     
	RETURN  
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SplitList_Hedis1]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[SplitList_Hedis1] (@list VARCHAR(MAX), @separator VARCHAR(MAX) = '','')  
RETURNS @table TABLE   
(  
	Value VARCHAR(MAX))AS   
	BEGIN     
		DECLARE @position INT,   
		@previous INT     
		SET @list = @list + @separator     
		SET @previous = 1     
		SET @position = CHARINDEX(@separator, @list)     
		WHILE @position > 0   
			BEGIN        
			IF @position - @previous > 0           
				INSERT INTO @table VALUES (SUBSTRING(@list, @previous, @position - @previous))        
				IF @position >= LEN(@list)   
					BREAK        
			SET @previous = @position + 1        
			SET @position = CHARINDEX(@separator, @list, @previous)     
		END     
	RETURN  
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SplitList_Hedis]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[SplitList_Hedis]
 (	@vcDelimitedString VARCHAR(8000),
	@vcDelimiter VARCHAR(100) 
 )

RETURNS @AgeTable TABLE
(
	ElementID  SMALLINT identity(1,1),  --Array index
    Age1  VARCHAR(50), --Array element contents,
	Age2  VARCHAR(50), --Array element contents,
	AgeType Varchar(50)
)
AS
BEGIN

	Declare @AgeTemp Table
	(
		Age  Float --Array element contents,
	)

	DECLARE
	@siIndex	SMALLINT,
	@siStart		SMALLINT,
	@siDelSize	SMALLINT


	SET @siDelSize	= LEN(@vcDelimiter)
	--loop through source string and add elements to destination table array
	WHILE LEN(@vcDelimitedString) > 0
	BEGIN
		SET @siIndex = CHARINDEX(@vcDelimiter, @vcDelimitedString)
		IF @siIndex = 0
		BEGIN
			Delete from @AgeTemp
			INSERT INTO @AgeTemp Select * from SplitList_Hedis1(@vcDelimitedString,''-'')
			INSERT INTO @AgeTable Select Min(Age),Max(Age),@vcDelimitedString from @AgeTemp
			BREAK
		END
		ELSE
		BEGIN
			Delete from @AgeTemp
			INSERT INTO @AgeTemp Select * from SplitList_Hedis1(SUBSTRING(@vcDelimitedString, 1,@siIndex - 1),''-'')
			INSERT INTO @AgeTable Select Min(Age),Max(Age),SUBSTRING(@vcDelimitedString, 1,@siIndex - 1) from @AgeTemp
			SET @siStart = @siIndex + @siDelSize
			SET @vcDelimitedString = SUBSTRING(@vcDelimitedString, @siStart , LEN(@vcDelimitedString) - @siStart + 1)
		END
	END

	RETURN
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SplitList_InsuranceProductivity]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[SplitList_InsuranceProductivity] (@list VARCHAR(MAX), @separator VARCHAR(MAX) = '','')  
RETURNS @table TABLE   
(  
	Value VARCHAR(MAX))AS   
	BEGIN     
		DECLARE @position INT,   
		@previous INT     
		SET @list = @list + @separator     
		SET @previous = 1     
		SET @position = CHARINDEX(@separator, @list)     
		WHILE @position > 0   
			BEGIN        
			IF @position - @previous > 0           
				INSERT INTO @table VALUES (SUBSTRING(@list, @previous, @position - @previous))        
				IF @position >= LEN(@list)   
					BREAK        
			SET @previous = @position + 1        
			SET @position = CHARINDEX(@separator, @list, @previous)     
		END     
	RETURN  
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SplitList_PI]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[SplitList_PI] (@list VARCHAR(MAX), @separator VARCHAR(MAX) = '','')  

RETURNS @table TABLE   

(  

	Value VARCHAR(MAX))AS   

	BEGIN     

		DECLARE @position INT,   

		@previous INT     

		SET @list = @list + @separator     

		SET @previous = 1     

		SET @position = CHARINDEX(@separator, @list)     

		WHILE @position > 0   

			BEGIN        

			IF @position - @previous > 0           

				INSERT INTO @table VALUES (SUBSTRING(@list, @previous, @position - @previous))        

				IF @position >= LEN(@list)   

					BREAK        

			SET @previous = @position + 1        

			SET @position = CHARINDEX(@separator, @list, @previous)     

		END     

	RETURN  

END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SplitList_RA]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[SplitList_RA] (@list VARCHAR(MAX), @separator VARCHAR(MAX) = '','')  
RETURNS @table TABLE   
(  
	Value VARCHAR(MAX))AS   
	BEGIN     
		DECLARE @position INT,   
		@previous INT     
		SET @list = @list + @separator     
		SET @previous = 1     
		SET @position = CHARINDEX(@separator, @list)     
		WHILE @position > 0   
			BEGIN        
			IF @position - @previous > 0           
				INSERT INTO @table VALUES (SUBSTRING(@list, @previous, @position - @previous))        
				IF @position >= LEN(@list)   
					BREAK        
			SET @previous = @position + 1        
			SET @position = CHARINDEX(@separator, @list, @previous)     
		END     
	RETURN  
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SplitList_SR]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[SplitList_SR] (@list VARCHAR(MAX), @separator VARCHAR(MAX) = '','')  
RETURNS @table TABLE   
(  
	Value VARCHAR(MAX))AS   
	BEGIN     
		DECLARE @position INT,   
		@previous INT     
		SET @list = @list + @separator     
		SET @previous = 1     
		SET @position = CHARINDEX(@separator, @list)     
		WHILE @position > 0   
			BEGIN        
			IF @position - @previous > 0           
				INSERT INTO @table VALUES (SUBSTRING(@list, @previous, @position - @previous))        
				IF @position >= LEN(@list)   
					BREAK        
			SET @previous = @position + 1        
			SET @position = CHARINDEX(@separator, @list, @previous)     
		END     
	RETURN  
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SplitList_VP]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[SplitList_VP] (@list VARCHAR(MAX), @separator VARCHAR(MAX) = '','')  
RETURNS @table TABLE   
( 
	Value VARCHAR(MAX))
AS   
	BEGIN     
		DECLARE @position INT,   
		@previous INT     
		SET @list = @list + @separator     
		SET @previous = 1     
		SET @position = CHARINDEX(@separator, @list)     
		WHILE @position > 0   
			BEGIN        
			IF @position - @previous > 0           
				INSERT INTO @table VALUES (SUBSTRING(@list, @previous, @position - @previous))        
				IF @position >= LEN(@list)   
					BREAK        
			SET @previous = @position + 1        
			SET @position = CHARINDEX(@separator, @list, @previous)     
		END     
	RETURN  
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SplitLockHierarchy]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[SplitLockHierarchy] (@vcDelimitedString VARCHAR(max))
RETURNS @tblArray TABLE (
	ElementID SMALLINT IDENTITY(1, 1) --Array index
	,Element VARCHAR(1000) --Array element contents
	)
AS
BEGIN
	--returns each level in a lock hierarchy''s ancestors.
	--given "VisitNote.RX.A", it will return a table with the following rows.
	--| Element ID |     Element    |
	--|------------|----------------|
	--|      1     | VisitNote.RX.A |
	--|      2     |  VisitNote.RX  |
	--|      3     |    VisitNote   |

	DECLARE @siIndex SMALLINT
		,@delimiter NVARCHAR(1)

	SET @delimiter = ''.''
	SET @vcDelimitedString = REVERSE(@vcDelimitedString)

	--loop through source string and add elements to destination table array
	WHILE LEN(@vcDelimitedString) > 0
	BEGIN
		SET @siIndex = CHARINDEX(@delimiter, @vcDelimitedString)

		IF @siIndex = 0
		BEGIN
			INSERT INTO @tblArray
			VALUES (REVERSE(@vcDelimitedString))

			BREAK
		END
		ELSE
		BEGIN
			INSERT INTO @tblArray
			VALUES (REVERSE(@vcDelimitedString))

			SET @vcDelimitedString = SUBSTRING(@vcDelimitedString, @siIndex + 1, LEN(@vcDelimitedString) - @siIndex + 1)
		END
	END

	RETURN
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[stripSpecialChars]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE FUNCTION [dbo].[stripSpecialChars]
	(@inputString varchar(255))
RETURNS varchar(255) AS
BEGIN
-- Quick function to strip special chars for ID and reference number comparisons.
-- For example a SSN could be ''519-99-9999'' or ''519999999'' and you''d want both to be equal.
-- a telephone number could be ''(650)999-9999'' or ''650.999.9999'' or ''650-999-9999'' or ...

--Removes the following chars: - . ( ) _ \ / , * + '' "

DECLARE @RETVAL VARCHAR(255)
SELECT
	@RETVAL =
	REPLACE(
	REPLACE(REPLACE(REPLACE(REPLACE(
	REPLACE(REPLACE(REPLACE(REPLACE(
	REPLACE(REPLACE(REPLACE(REPLACE(@inputString,
	''-'',''''),
	''.'',''''),
	'')'',''''),
	''('',''''),
	''_'',''''),
	''/'',''''),
	''\'',''''),
	'','',''''),
	''*'',''''),
	''+'',''''),
	'''''''',''''),
	''"'',''''),
	'' '','''')

RETURN(@RETVAL)

END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[StrToGUID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE FUNCTION [dbo].[StrToGUID] (@PK_ID varchar(200))
RETURNS uniqueidentifier AS  

BEGIN  

  declare @Wrk varchar(200)
  declare @NewGUID uniqueidentifier

  set @Wrk = @PK_ID

  if @Wrk is not null
    begin
      while len(@Wrk) < 32 set @Wrk = ''0'' + @Wrk

      set @Wrk = SUBSTRING(@Wrk, 1, 8) + ''-'' + SUBSTRING(@Wrk, 9, 4) + ''-'' + SUBSTRING(@Wrk, 13, 4) 
             + ''-'' + SUBSTRING(@Wrk, 17, 4) + ''-'' + SUBSTRING(@Wrk, 21, 12)
      set @Wrk = ''{'' + @Wrk + ''}''
      set @NewGUID = @Wrk
    end
 
  return (@NewGUID)
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[SystemEmptyGuid]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


-- function returning a Prm system Guid
CREATE FUNCTION [dbo].[SystemEmptyGuid] (@SystemId int)
RETURNS uniqueidentifier AS  

BEGIN  

  declare @Wrk varchar(200)
  declare @NewGUID uniqueidentifier

  if (@SystemId < 0) 
	set @SystemId = -1 * @SystemId
  set @Wrk = convert (varchar(200), @SystemId)
  while len(@Wrk) < 32 set @Wrk = ''0'' + @Wrk

  set @Wrk = ''00000000'' + ''-'' + SUBSTRING(@Wrk, 9, 4) + ''-'' + SUBSTRING(@Wrk, 13, 4) 
                              + ''-'' + SUBSTRING(@Wrk, 17, 4) + ''-'' + SUBSTRING(@Wrk, 21, 12)
  set @Wrk = ''{'' + @Wrk + ''}''
  set @NewGUID = @Wrk
  return (@NewGUID)
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ToBase64]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ToBase64]
(
	@data [VARCHAR](MAX)
)
RETURNS [VARCHAR](MAX)
AS
BEGIN
	IF @data IS NOT NULL AND LEN(@data) > 0
	BEGIN
		DECLARE	@binaryData varbinary(MAX)
		SET @binaryData =  CAST(@data AS varbinary(max))

		RETURN (SELECT CAST(N'''' AS XML).value(''xs:base64Binary(xs:hexBinary(sql:variable("@binaryData")))'', ''VARCHAR(MAX)''))
	END
	RETURN NULL
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_AR_getGLDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE FUNCTION [dbo].[UDF_AR_getGLDate] (@dtCreateDate datetime, @dtCurrentPeriodEnd DATE)

RETURNS datetime AS 

BEGIN
	DECLARE @theGLDate DATE
	
	If (@dtCurrentPeriodEnd > @dtCreateDate) 
		Select @theGLDate = @dtCreateDate 
	Else 
		Select @theGLDate = @dtCurrentPeriodEnd 
	
	RETURN @theGLDate
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_AR_getInsLevelName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[UDF_AR_getInsLevelName]
	(@insLevel smallint)
RETURNS varchar(10) AS 
BEGIN
	RETURN (CASE @insLevel 
		WHEN Null THEN '''' 
		WHEN 0 THEN '''' 
		WHEN 1 THEN ''Primary'' 
		WHEN 2 THEN ''Secondary'' 
		WHEN 3 THEN ''Tertiary'' 
		WHEN 4 THEN ''Quaternary'' 
		WHEN 5 THEN ''Quinary'' 
		WHEN 6 THEN ''Senary'' 
		WHEN 7 THEN ''Septary'' 
		WHEN 8 THEN ''Ogdoad'' 
		WHEN 9 THEN ''Ennead'' 
		WHEN 10 THEN ''Decad'' 
		ELSE (convert(varchar(8), @insLevel) + ''th'') END)
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_AR_getLiabilityName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[UDF_AR_getLiabilityName]
	(@liabilityOwner smallint)
RETURNS varchar(10) AS 
BEGIN
	declare @return varchar(10)
	Select @return = Upper(dbo.UDF_AR_getInsLevelName(@liabilityOwner))
	If (@return = '''') Select @return = ''PATIENT''
	RETURN @return
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_AR_getPlanClaimFormatUid]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[UDF_AR_getPlanClaimFormatUid] (@claimPaper bit, @insurancePlanUid uniqueidentifier, @insuranceOrder int) RETURNS uniqueidentifier AS
BEGIN
	DECLARE @useCarrierElectronicClaimFormat bit
	DECLARE @useCarrierPaperClaimFormat bit
	DECLARE @planElectronicClaimFormatUid uniqueidentifier
	DECLARE @carrierElectronicClaimFormatUid uniqueidentifier
	DECLARE @planPaperClaimFormatUid uniqueidentifier
	DECLARE @carrierPaperClaimFormatUid uniqueidentifier
	DECLARE @planUseCarrierPaperClaimDefaultOption bit
	DECLARE @planPaperClaimDefaultOptionUid uniqueidentifier
	DECLARE @carrierPaperClaimDefaultOptionUid uniqueidentifier

	SELECT	@useCarrierElectronicClaimFormat = ip.UseCarrierElectronicClaimFormat,
			@useCarrierPaperClaimFormat = ip.UseCarrierPaperClaimFormat,
			@planElectronicClaimFormatUid = ip.ElectronicClaimFormatUid,
			@carrierElectronicClaimFormatUid = ic.ElectronicClaimFormatUid,
			@planPaperClaimFormatUid = ip.PaperClaimFormatUid, 
			@carrierPaperClaimFormatUid = ic.PaperClaimFormatUid,
			@planUseCarrierPaperClaimDefaultOption = ip.UseCarrierPaperClaimDefaultOption,
			@planPaperClaimDefaultOptionUid = ip.PaperClaimDefaultOptionUid,
			@carrierPaperClaimDefaultOptionUid = ic.PaperClaimDefaultOptionUid
	FROM	InsurancePlan ip 
				INNER JOIN InsuranceCarrier ic ON ip.InsuranceCarrierUid = ic.CorporationUid
	WHERE	ip.InsurancePlanUid = @insurancePlanUid

	RETURN dbo.UDF_AR_getClaimFormatUid(@claimPaper, @useCarrierElectronicClaimFormat, @useCarrierPaperClaimFormat,
										@planElectronicClaimFormatUid , @carrierElectronicClaimFormatUid, 
										@planPaperClaimFormatUid, @carrierPaperClaimFormatUid,
										@planUseCarrierPaperClaimDefaultOption, @planPaperClaimDefaultOptionUid, @carrierPaperClaimDefaultOptionUid, @InsuranceOrder )
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_AR_getTransactionBatches]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_AR_getTransactionBatches](@transactionUid uniqueidentifier) RETURNS VARCHAR(max) AS
BEGIN
	DECLARE		@Batch varchar(max)

	--SELECT 		@Batch = ISNULL(@Batch + '','', '''') + arb.[Name]
	--FROM		ARBatch arb 
	--WHERE		arb.ARBatchUid IN (SELECT c.ARBatchUid FROM ARContext arc INNER JOIN Charge c ON arc.ARContextUid = c.ARContextUid AND arc.SuperbillUid = @SuperbillUid)
	--ORDER BY	arb.Name
	
	--select arl.
	--from AR_Ledger arl 
	--won art.TransactionUid = arl.T

	RETURN		@Batch	
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_AR_getTransactionBatchNames]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_AR_getTransactionBatchNames](@transactionUid uniqueidentifier) RETURNS VARCHAR(max) AS
BEGIN
	DECLARE		@Batch varchar(max);
	
	WITH cteBatches AS
	(
	  SELECT DISTINCT arl.ARBatchUid, arb.Name, arb.GLDate  
	  FROM AR_Ledger arl
			inner join ARBatch arb on arl.ArBatchUid = arb.ARBatchUid
	  WHERE arl.TransactionUid = @transactionUid
	)
	SELECT @Batch = ISNULL(@Batch + '','',  '''') + cteb.Name
	FROM cteBatches cteb
	ORDER BY cteb.GLDate

	RETURN		@Batch	
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_AR_getTransactionBatchState]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[UDF_AR_getTransactionBatchState](@transactionUid uniqueidentifier) RETURNS VARCHAR(max) AS
BEGIN
	DECLARE     @IsLocked int
	DECLARE     @IsClosed int

	SET @IsLocked=0
	SET @IsClosed=0
	
	SELECT @IsLocked = CASE WHEN arbcl.IsLocked = 1 THEN 1 ELSE @IsLocked END,
		   @IsClosed = CASE WHEN arbcl.IsClosed = 1 THEN 1 ELSE @IsClosed END
	FROM AR_Ledger arl
		INNER JOIN AR_ViewBatchClosingsLockedClosed arbcl on arl.ArBatchUid = arbcl.ARBatchUid
	WHERE arl.TransactionUid = @transactionUid 

    IF (@IsClosed=1)
		return ''Closed'';
	IF (@IsLocked=1)
		return ''Complete'';
	return ''Open''
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_AR_getTransactionBatchUids]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_AR_getTransactionBatchUids](@transactionUid uniqueidentifier) RETURNS VARCHAR(max) AS
BEGIN
	DECLARE		@Batch varchar(max);
	
	WITH cteBatches AS
	(
	  SELECT DISTINCT arl.ARBatchUid, arb.Name, arb.GLDate  
	  FROM AR_Ledger arl
			inner join ARBatch arb on arl.ArBatchUid = arb.ARBatchUid
	  WHERE arl.TransactionUid = @transactionUid
	)
	SELECT @Batch = ISNULL(@Batch + '','',  '''') + convert(varchar(100), cteb.ARBatchUid)
	FROM cteBatches cteb
	ORDER BY cteb.GLDate

	RETURN		@Batch	
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_AR_getTransactionDepositNames]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_AR_getTransactionDepositNames](@transactionUid uniqueidentifier) RETURNS VARCHAR(max) AS
BEGIN
	DECLARE		@Deposits varchar(max);
	
	WITH cteDeposits AS
	(
	  SELECT DISTINCT ld.DepositUid, d.ReferenceNumber
	  FROM AR_Ledger arl 
			inner join AR_LedgerDetail ld on arl.TransactionUid = @TransactionUid
											  and arl.LedgerUid = ld.LedgerUid
			inner join Deposit d on ld.DepositUid = d.DepositUid
	)
	SELECT @Deposits = ISNULL(@Deposits + '','',  '''') + cted.ReferenceNumber
	FROM cteDeposits cted
	ORDER BY cted.ReferenceNumber asc

	RETURN		@Deposits
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_AR_getTransactionDepositUids]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_AR_getTransactionDepositUids](@transactionUid uniqueidentifier) RETURNS VARCHAR(max) AS
BEGIN
	DECLARE		@Deposits varchar(max);
	
	WITH cteDeposits AS
	(
	  SELECT DISTINCT ld.DepositUid, d.ReferenceNumber
	  FROM AR_Ledger arl 
			inner join AR_LedgerDetail ld on arl.TransactionUid = @TransactionUid
											  and arl.LedgerUid = ld.LedgerUid
			inner join Deposit d on ld.DepositUid = d.DepositUid
	)
	SELECT @Deposits = ISNULL(@Deposits + '','',  '''') + convert(varchar(100), cted.DepositUid)
	FROM cteDeposits cted
	ORDER BY cted.ReferenceNumber asc

	RETURN		@Deposits
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_AR_getTransactionPayerCreditAndDepositNames]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[UDF_AR_getTransactionPayerCreditAndDepositNames](@transactionUid uniqueidentifier) RETURNS VARCHAR(max) AS
BEGIN
	DECLARE		@Names varchar(max);
	
	WITH ctePayerCredits AS
	(
	  SELECT DISTINCT 2 AS sortOrder, ld.PayerCreditUid, vd.WhoPaidName -- was using note - for consistancy with non transfaction viewsuperbillhistory use whopaidname
	  FROM AR_Ledger arl 
			inner join AR_LedgerDetail ld on arl.TransactionUid = @TransactionUid
											  and arl.LedgerUid = ld.LedgerUid
			inner join AR_PayerCredit apc on ld.PayerCreditUid = apc.PayerCreditUid
			inner join ViewDeposit vd on apc.DepositUid = vd.DepositUid
	),
	cteDeposits AS
	(
	  SELECT DISTINCT 1 AS sortOrder, ld.DepositUid, d.WhoPaidName -- was using reference number - for consistancy with non transfaction viewsuperbillhistory use whopaidname
	  FROM AR_Ledger arl 
			inner join AR_LedgerDetail ld on arl.TransactionUid = @TransactionUid
											  and arl.LedgerUid = ld.LedgerUid
			inner join ViewDeposit d on ld.DepositUid = d.DepositUid
	),
	cteAggregate AS
	(
		SELECT ctePC.sortOrder, ctePC.PayerCreditUid as nameUid, ctepc.WhoPaidName as Name
		FROM ctePayerCredits ctePC
		UNION ALL
		SELECT cteDep.sortOrder, cteDep.DepositUid as nameUid, cteDep.WhoPaidName as Name
		FROM cteDeposits cteDep
	)
	SELECT @Names = ISNULL(@Names + '','',  '''') + cteAgg.Name
	FROM cteAggregate cteAgg
	ORDER BY cteAgg.sortOrder ASC, cteAgg.Name ASC

	RETURN		@Names
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_AR_getTransactionPayerCreditNames]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[UDF_AR_getTransactionPayerCreditNames](@transactionUid uniqueidentifier) RETURNS VARCHAR(max) AS
BEGIN
	DECLARE		@PayerCredits varchar(max);
	
	WITH ctePayerCredits AS
	(
	  SELECT DISTINCT ld.PayerCreditUid, apc.Note
	  FROM AR_Ledger arl 
			inner join AR_LedgerDetail ld on arl.TransactionUid = @TransactionUid
											  and arl.LedgerUid = ld.LedgerUid
			inner join AR_PayerCredit apc on ld.PayerCreditUid = apc.PayerCreditUid
	)
	SELECT @PayerCredits = ISNULL(@PayerCredits + '','',  '''') + ctepc.Note
	FROM ctePayerCredits ctepc
	ORDER BY ctepc.Note asc

	RETURN		@PayerCredits
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getFormatVariableValueByUID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_getFormatVariableValueByUID] 
(
	@exportFormatGUID UNIQUEIDENTIFIER,
	@iProvider VARCHAR(50) = NULL,
	@serviceSiteUid VARCHAR(50) = NULL, 
	@FinancialCenterUid  VARCHAR(50) = NULL
)
RETURNS VARCHAR(255)
AS
BEGIN
	DECLARE @retVal VARCHAR(255)

	SET @iProvider = ISNULL(@iProvider,''00000000-0000-0000-0000-000000000000'')
	SET @serviceSiteUid = ISNULL(@serviceSiteUid, ''00000000-0000-0000-0000-000000000000'')
	SET @FinancialCenterUid = ISNULL(@FinancialCenterUid,''14B99C94-EDAC-47BD-97B9-CF421AC16018'')

	SELECT @retVal = ISNULL(eClaimFormatValue.value, '''')	
	FROM ListClaimFormatValueType eListClaimFormatValueType
			LEFT JOIN ClaimFormatValue eClaimFormatValue ON	eClaimFormatValue.ClaimFormatValueTypeUid = eListClaimFormatValueType.ClaimFormatValueTypeUid AND
						((eClaimFormatValue.ProviderUid IS NOT NULL AND CONVERT(VARCHAR(50),eClaimFormatValue.ProviderUid) = @iProvider )OR (eClaimFormatValue.ProviderUid IS NULL AND @iProvider = ''00000000-0000-0000-0000-000000000000'') OR (eClaimFormatValue.ProviderUid IS NULL)) AND
						((eClaimFormatValue.ServiceSiteUid IS NOT NULL AND CONVERT(VARCHAR(50),eClaimFormatValue.ServiceSiteUid) = @serviceSiteUid) OR (eClaimFormatValue.ServiceSiteUid IS NULL AND @serviceSiteUid = ''00000000-0000-0000-0000-000000000000'') OR (eClaimFormatValue.ServiceSiteUid IS NULL)) AND
						((eClaimFormatValue.FinancialCenterUid IS NOT NULL AND CONVERT(VARCHAR(50), eClaimFormatValue.FinancialCenterUid) = @FinancialCenterUid) OR (eClaimFormatValue.FinancialCenterUid IS NULL AND @FinancialCenterUid = ''14B99C94-EDAC-47BD-97B9-CF421AC16018'') OR (eClaimFormatValue.FinancialCenterUid IS NULL))
	WHERE
		eListClaimFormatValueType.ClaimFormatValueTypeUid = @exportFormatGUID 
	ORDER BY ServiceSiteUid, ProviderUid, FinancialCenterUid

	RETURN(@retVal)
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getFormatVaribleValue]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- DSW 06/11/2014 29051	Modified to allow FixedValue to override ClaimFormat value.  Added Box 29 Type.
-- DSW 01/30/2015 35138 if Box 29 allow claimformat.fixedValue to be priority otherwise use claimformat.value
-- DSW 05/06/2015 35186 if Box 29 allow claimformat.fixedValue to be priority otherwise use claimformat.value
-- DSW 10/25/2016 51952 Add ''Excise Tax Code'' ( added 2-20 )

CREATE FUNCTION [dbo].[UDF_getFormatVaribleValue]
(	@exportFormatType INT,
	@exportFormatGUID UNIQUEIDENTIFIER,
	@exportFormatOptionType INT,
	@iProvider VARCHAR(50) = NULL,
	@renderer VARCHAR(50) = NULL,
	@serviceSiteUid VARCHAR(50) = NULL, --INT = NULL,
	@refUUID UNIQUEIDENTIFIER = NULL,
	@FinancialCenterUid  VARCHAR(50) = NULL
)
RETURNS VARCHAR(255)
AS
BEGIN
	DECLARE @retVal VARCHAR(255)
	DECLARE @FormatOptionTypeName VARCHAR(50)  

	SET @iProvider = ISNULL(@iProvider,''00000000-0000-0000-0000-000000000000'')
	SET @renderer = ISNULL(@renderer,''00000000-0000-0000-0000-000000000000'')
	SET @serviceSiteUid = ISNULL(@serviceSiteUid, ''00000000-0000-0000-0000-000000000000'')
	SET @refUUID = ISNULL(@refUUID,''00000000-0000-0000-0000-000000000000'')
	SET @FinancialCenterUid = ISNULL(@FinancialCenterUid,''14B99C94-EDAC-47BD-97B9-CF421AC16018'')

	IF @exportFormatType = 2 OR @exportFormatType = 3
	BEGIN
		IF @exportFormatType = 2
		BEGIN
			IF @exportFormatOptionType = 0 
				SET @FormatOptionTypeName = ''Rendering Provider ID''
			IF @exportFormatOptionType = 1 
				SET @FormatOptionTypeName = ''Rendering Provider ID Type''
			IF @exportFormatOptionType = 2 
				SET @FormatOptionTypeName = ''Practice/Group ID''
			IF @exportFormatOptionType = 3 
				SET @FormatOptionTypeName = ''Practice/Group ID Type''
			IF @exportFormatOptionType = 4 
				SET @FormatOptionTypeName = ''Referring Provider ID''
			IF @exportFormatOptionType = 5 
				SET @FormatOptionTypeName = ''Referring Provider ID Type''
			IF @exportFormatOptionType = 6 
				SET @FormatOptionTypeName = ''Facility ID''
			IF @exportFormatOptionType = 7 
				SET @FormatOptionTypeName = ''Facility ID Type''
			IF @exportFormatOptionType = 8
				SET @FormatOptionTypeName = ''Submitter ID''
			IF @exportFormatOptionType = 9 
				SET @FormatOptionTypeName = ''File as Group or Individual''
            IF @exportFormatOptionType = 10       -- Added for Defect # 11482
				SET @FormatOptionTypeName = ''CLIA''
            IF @exportFormatOptionType = 11       -- Added for Defect # 12625
				SET @FormatOptionTypeName = ''Mammography Cert''
			IF @exportFormatOptionType = 12			--CYS SC Added for SuoerBill UB
				SET @FormatOptionTypeName = ''Attending Physician ID''
			IF @exportFormatOptionType = 13 
				SET @FormatOptionTypeName = ''Attending Physician ID Type''
			IF @exportFormatOptionType = 14 
				SET @FormatOptionTypeName = ''Operating Physician ID''
			IF @exportFormatOptionType = 15 
				SET @FormatOptionTypeName = ''Operating Physician ID Type''
			IF @exportFormatOptionType = 16 
				SET @FormatOptionTypeName = ''Supervising Physician ID''
			IF @exportFormatOptionType = 17 
				SET @FormatOptionTypeName = ''Supervising Physician ID Type''
			IF @exportFormatOptionType = 18 
				SET @FormatOptionTypeName = ''Payer ID Type - Additional''
			IF @exportFormatOptionType = 19 
				SET @FormatOptionTypeName = ''Payer ID - Additional''
			IF @exportFormatOptionType = 20
				SET @FormatOptionTypeName = ''Excise Tax Code'' -- Dev-Assist 51952
		END
		ELSE
		IF @exportFormatType = 3 -- Paper CMS-1500, Paper CMS-1500 5010
		BEGIN
			IF @exportFormatOptionType = 0 
				SET @FormatOptionTypeName = ''BOX 1''
			IF @exportFormatOptionType = 1 
				SET @FormatOptionTypeName = ''BOX 24K''
			IF @exportFormatOptionType = 2 
				SET @FormatOptionTypeName = ''BOX 33 GRP''
			IF @exportFormatOptionType = 3 
				SET @FormatOptionTypeName = ''BOX 33 PIN''
			IF @exportFormatOptionType = 4 
				SET @FormatOptionTypeName = ''BOX 17A''
			IF @exportFormatOptionType = 5 
				SET @FormatOptionTypeName = ''BOX 19''
			IF @exportFormatOptionType = 6 
				SET @FormatOptionTypeName = ''BOX 25''
			IF @exportFormatOptionType = 7 
				SET @FormatOptionTypeName = ''BOX 25 type''
			IF @exportFormatOptionType = 8 
				SET @FormatOptionTypeName = ''Facility ID''
			IF @exportFormatOptionType = 9 
				SET @FormatOptionTypeName = ''BOX 32b Type''
			IF @exportFormatOptionType = 10 
				SET @FormatOptionTypeName = ''BOX 17a Type''
			IF @exportFormatOptionType = 11 
				SET @FormatOptionTypeName = ''BOX 33GRP Type''
			IF @exportFormatOptionType = 12 
				SET @FormatOptionTypeName = ''BOX 24J''
			IF @exportFormatOptionType = 13 
				SET @FormatOptionTypeName = ''BOX 24J Type''
			IF @exportFormatOptionType = 14 
				SET @FormatOptionTypeName = ''File as Group or Individual''
			IF @exportFormatOptionType = 15 
				SET @FormatOptionTypeName = ''BOX 23''
			IF @exportFormatOptionType = 16 
				SET @FormatOptionTypeName = ''CLIA''
            IF @exportFormatOptionType = 17       -- Added for Defect # 12625
				SET @FormatOptionTypeName = ''Mammography Cert''
			IF @exportFormatOptionType = 18   --ADDED FOR Defect #16535
                SET @FormatOptionTypeName = ''BOX 24K''  
           IF @exportFormatOptionType = 19		-- 				
				SET @FormatOptionTypeName = ''BOX 32b''		-- Bug 20681
			IF @exportFormatOptionType = 20
				Set @FormatOptionTypeName = ''Box 29 Type''	
		END
		
		--SELECT @retVal = CASE WHEN ClaimFormatOption.ClaimFormatValueTypeUid IS NULL THEN  ISNULL(ClaimFormatOption.FixedValue, '''') 
		--					  ELSE ISNULL(ClaimFormatValue.value,'''')
		--			     END
		SELECT @retVal = 
		    CASE WHEN @FormatOptionTypeName =  ''Box 29 Type'' THEN COALESCE( NULLIF(ClaimFormatOption.FixedValue, ''''), NULLIF(ClaimFormatValue.value, ''''), '''')
			                                                 ELSE COALESCE( NULLIF(ClaimFormatValue.value, ''''), NULLIF(ClaimFormatOption.FixedValue, ''''), '''') END
		FROM ClaimFormatOption
			LEFT JOIN ClaimFormatValue ON ClaimFormatValue.ClaimFormatValueTypeUid =  ClaimFormatOption.ClaimFormatValueTypeUid
				AND ((ClaimFormatValue.ProviderUid IS NOT NULL AND CONVERT(VARCHAR(50), ClaimFormatValue.ProviderUid) = @iProvider )OR (ClaimFormatValue.ProviderUid IS NULL AND @iProvider = ''00000000-0000-0000-0000-000000000000'') OR (ClaimFormatValue.ProviderUid IS NULL))
				AND ((ClaimFormatValue.ServiceSiteUid IS NOT NULL AND CONVERT(VARCHAR(50), ClaimFormatValue.ServiceSiteUid) = @serviceSiteUid) OR (ClaimFormatValue.ServiceSiteUid IS NULL AND @serviceSiteUid = ''00000000-0000-0000-0000-000000000000'') OR (ClaimFormatValue.ServiceSiteUid IS NULL ))				
				AND ((ClaimFormatValue.FinancialCenterUid IS NOT NULL AND CONVERT(VARCHAR(50), ClaimFormatValue.FinancialCenterUid) = @FinancialCenterUid) OR (ClaimFormatValue.FinancialCenterUid IS NULL AND @FinancialCenterUid = ''14B99C94-EDAC-47BD-97B9-CF421AC16018'') OR (ClaimFormatValue.FinancialCenterUid IS NULL ))
			LEFT JOIN ListClaimFormatOptionType ON ListClaimFormatOptionType.ClaimFormatOptionTypeUid = ClaimFormatOption.ClaimFormatOptionTypeUid
			WHERE ListClaimFormatOptionType.Name LIKE @FormatOptionTypeName
					AND ClaimFormatOption.ClaimFormatUid = @exportFormatGUID
			ORDER BY ServiceSiteUid, ProviderUid, FinancialCenterUid -- per bug 8968 added FinancialCenterUid to sort order
	END
	ELSE		/* @exportFormatType = 0 */
	BEGIN
		--SELECT @retVal = ISNULL(eClaimFormatValue.value, '''')	
		--FROM ListClaimFormatValueType eListClaimFormatValueType
		--		LEFT JOIN ClaimFormatValue eClaimFormatValue ON	eClaimFormatValue.ClaimFormatValueTypeUid = eListClaimFormatValueType.ClaimFormatValueTypeUid AND
		--					((eClaimFormatValue.ProviderUid IS NOT NULL AND CONVERT(VARCHAR(50),eClaimFormatValue.ProviderUid) = @iProvider )OR (eClaimFormatValue.ProviderUid IS NULL AND @iProvider = ''00000000-0000-0000-0000-000000000000'') OR (eClaimFormatValue.ProviderUid IS NULL)) AND
		--					((eClaimFormatValue.ServiceSiteUid IS NOT NULL AND CONVERT(VARCHAR(50),eClaimFormatValue.ServiceSiteUid) = @serviceSiteUid) OR (eClaimFormatValue.ServiceSiteUid IS NULL AND @serviceSiteUid = ''00000000-0000-0000-0000-000000000000'') OR (eClaimFormatValue.ServiceSiteUid IS NULL)) AND
		--					((eClaimFormatValue.FinancialCenterUid IS NOT NULL AND CONVERT(VARCHAR(50), eClaimFormatValue.FinancialCenterUid) = @FinancialCenterUid) OR (eClaimFormatValue.FinancialCenterUid IS NULL AND @FinancialCenterUid = ''14B99C94-EDAC-47BD-97B9-CF421AC16018'') OR (eClaimFormatValue.FinancialCenterUid IS NULL))
		--WHERE
		--	eListClaimFormatValueType.ClaimFormatValueTypeUid = @exportFormatGUID --and
		--ORDER BY ServiceSiteUid, ProviderUid, FinancialCenterUid
		select @retVal = dbo.UDF_getFormatVariableValueByUid(@exportFormatGuid, @iProvider, @serviceSiteUid, @FinancialCenterUid)
	END

	RETURN(@retVal)

END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_CheckFor1000A]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[UDF_CheckFor1000A]
(	
	@ClaimBatchUId UNIQUEIDENTIFIER
)
RETURNS VARCHAR(255)
AS
BEGIN

	DECLARE CurClaimFormats CURSOR FOR
		select CASE IP.UseCarrierElectronicClaimFormat 
				WHEN 1 THEN IC.ElectronicClaimFormatUId
				ELSE IP.ElectronicClaimFormatUId END as ClaimFormatUid,
				sba.FinancialCenterUid 
		from ClaimBatch cb
				inner join ClaimBatchDetail cbd on cb.ClaimBatchUid = cbd.ClaimBatchUid
				inner join Superbill sb on cbd.SuperbillUid = sb.SuperbillUid
				inner join SuperbillAggregate sba on sb.SuperbillUid = sba.SuperbillUid -- Need current insurance liability owner
				inner join AccountPeriod ap on sb.AccountUid = ap.AccountUid
												AND (ap.EffectiveDate IS NULL OR (ap.EffectiveDate <= sb.ServiceDateStart) )
												AND (ap.ExpirationDate IS NULL OR (ap.ExpirationDate >= sb.ServiceDateStart) )
				inner join AccountInsurance ai on ap.AccountPeriodUid = ai.AccountPeriodUid
													and ai.DisplayOrder = 
															coalesce( sba.CurrentCarrier, sb.CurrentCarrierOverride, 1 ) 
															-- Order of preference
															-- 1) Current Carrier from aggregate
															-- 2) Superbill liability owner flag
															-- 3) Primary ( last resort )
				inner join PersonInsurancePlan pip on ai.PersonInsurancePlanUid = pip.PersonInsurancePlanUid
				inner join InsurancePlan ip on pip.InsurancePlanUid = ip.InsurancePlanUid
				inner join InsuranceCarrier ic on ip.InsuranceCarrierUid = ic.CorporationUid
		where cb.ClaimBatchUid = @ClaimBatchUId
				
	DECLARE @ClaimFormatUId uniqueidentifier 
	DECLARE @financialCenterUid uniqueidentifier
	DECLARE @RetValue VARCHAR(255)

	OPEN CurClaimFormats
	FETCH NEXT FROM CurClaimFormats INTO @ClaimFormatUId, @financialCenterUid

	WHILE @@FETCH_STATUS = 0
	BEGIN
		SET @RetValue=''''
		SET @RetValue = dbo.UDF_getFormatVaribleValue (2,@ClaimFormatUId,8,NULL,NULL,NULL,NULL,@financialCenterUid)
		IF NOT @RetValue=''''
		BEGIN
			CLOSE CurClaimFormats
			DEALLOCATE CurClaimFormats

			RETURN(@RetValue)
		END	
		FETCH NEXT FROM CurClaimFormats INTO @ClaimFormatUId, @financialCenterUid
	END
	CLOSE CurClaimFormats
	DEALLOCATE CurClaimFormats

	RETURN(@RetValue)
END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_CQMTestPatient]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_CQMTestPatient] (@PatientUid UNIQUEIDENTIFIER)
RETURNS BIT
AS
BEGIN
	DECLARE @PatientTypeTest    UNIQUEIDENTIFIER = ''77A41E18-5554-4874-9454-54DC3D7A33A0''
		,@TestPat BIT = 0

	IF EXISTS(
		SELECT rps.PatientUid 
		FROM RelPatientStatus rps WITH(NOLOCK) 
		WHERE rps.PatientUid=@PatientUid 
			AND rps.PatientStatusUid = @PatientTypeTest
	)
	SET @TestPat = 1

	RETURN @TestPat
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getAge]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_getAge]
(
	 @BirthDate DATETIME,
	 @ToDate DATETIME
) 
RETURNS VARCHAR(50)
AS
BEGIN
	DECLARE @Age VARCHAR(50)
	DECLARE @Year INT 
	DECLARE @Month INT 
	DECLARE @Day INT 
	DECLARE @TempDate DATETIME  
	DECLARE @dates INT   
	
	SET @Year=0
	SET @Month=0
	SET @Day=0
	
	DECLARE @Ageyear VARCHAR(50)
	DECLARE @Agemonth VARCHAR(50)
	DECLARE @Ageday VARCHAR(50)

	DECLARE @agevalue INT
	

	
	SET @year=( CASE 
					WHEN DATEADD(YEAR, DATEDIFF(YEAR, @BirthDate , @ToDate),@BirthDate)  > @ToDate

					THEN DATEDIFF(YEAR, @BirthDate , @ToDate) - 1

					ELSE DATEDIFF(YEAR, @BirthDate , @ToDate) END
				)	
	
	
	SET @BirthDate=DATEADD(YEAR,@year,@BirthDate)
	
	SET @Month=( 
					CASE 
					WHEN DATEADD(MONTH, DATEDIFF(MONTH, @BirthDate , @ToDate),@BirthDate)  > @ToDate

					THEN DATEDIFF(MONTH, @BirthDate , @ToDate) - 1

					ELSE DATEDIFF(MONTH, @BirthDate , @ToDate) END
				)	
	
	SET @BirthDate=DATEADD(MONTH,@Month,@BirthDate)

	SET @dates=DATEDIFF(DAY,@BirthDate,@ToDate)


	-- Years
	IF @year > 1
	BEGIN
		SET @Ageyear = CAST(@year AS VARCHAR(5))  +'' Years ''
	END
	
	IF @year = 1
	BEGIN
		SET @Ageyear = CAST(@year AS VARCHAR(5))  +'' Year ''
	END
	
	IF @year <=0
	BEGIN
		SET @Ageyear = ''''
	END


	-- Months
	IF @Month > 1
	BEGIN
		SET @Agemonth = CAST(@Month AS VARCHAR(5))  +'' Months ''
	END
	IF @Month = 1
	BEGIN
		SET @Agemonth = CAST(@Month AS VARCHAR(5))  +'' Month ''
	END
	IF @Month <=0 
	BEGIN
		SET @Agemonth = ''''
	END

	-- Days
	IF @dates > 1
	BEGIN
		SET @Ageday = CAST(@dates AS VARCHAR(5))  +'' Days ''
	END
	IF @dates = 1
	BEGIN
		SET @Ageday = CAST(@dates AS VARCHAR(5))  +'' Day ''
	END
	IF @dates <=0
	BEGIN
		SET @Ageday = ''''
	END

	SET @Age = @Ageyear + @Agemonth + @Ageday

			 
	RETURN @Age
	
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getAgeRange]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_getAgeRange]
(	
	@AgeRange VARCHAR(200)
)
RETURNS  VARCHAR(100)

AS
BEGIN
    DECLARE @Age Int 
    DECLARE @Cnt Int
	DECLARE @ID SMALLINT
    DECLARE @Ages Varchar(100)

	SET @Ages=''''
    Set @AgeRange=Replace(@AgeRange,''-'','','')
	Set @AgeRange=Replace(@AgeRange,'';'','','')
    Set @AgeRange=Replace(@AgeRange,''+'','''')

    DECLARE @ageRangeTable TABLE  
    (  
  	  ElementID 	SMALLINT,
	  AgeRange  	int
    )
    INSERT INTO @ageRangeTable
    SELECT * FROM Split(@AgeRange,'','')

       
    -------------- AgeRange Like ''0-5;5-10'' converts to 0,5,5,10 and below returns 0,5,10 

    Declare Age_Cur Cursor For
      Select AgeRange, count('''') as Cnt from @ageRangeTable group by AgeRange
    OPEN Age_Cur 
	FETCH NEXT FROM Age_Cur Into @age, @cnt
    WHILE @@FETCH_STATUS = 0
    BEGIN
     while( @Cnt >= 2 ) 
        BEGIN
        SELECT TOP 1 @ID=ElementID FROM  @ageRangeTable WHERE AgeRange=@Age 
        DELETE FROM  @ageRangeTable WHERE ElementID =@ID 
        SET @cnt=@cnt-1
        END 
        FETCH NEXT FROM Age_Cur Into @age, @cnt	
	END	
	CLOSE Age_Cur
	DEALLOCATE Age_Cur
 
  ------  AgeRange Like  ''0-5;6-10'' converts to 0,5,6,10 and below returns 0,5,10 
   
   Declare Age_Cur Cursor For
      Select AgeRange from @ageRangeTable group by AgeRange
    OPEN Age_Cur 
	FETCH NEXT FROM Age_Cur Into @age
    WHILE @@FETCH_STATUS = 0
    BEGIN
       Declare Age_Cur1 Cursor For
          Select AgeRange from @ageRangeTable group by AgeRange
       OPEN Age_Cur1 
	   FETCH NEXT FROM Age_Cur1 Into @cnt
       WHILE @@FETCH_STATUS = 0
       BEGIN
       IF(@age-@Cnt=-1)
         BEGIN
          SELECT  @ID=ElementID FROM  @ageRangeTable WHERE AgeRange=@cnt
          DELETE FROM  @ageRangeTable WHERE ElementID =@ID 
         END 
        FETCH NEXT FROM Age_Cur1 Into @cnt
       END
       CLOSE Age_Cur1
	   DEALLOCATE Age_Cur1 
	   FETCH NEXT FROM Age_Cur Into @age
	END	
	CLOSE Age_Cur
	DEALLOCATE Age_Cur 
   

--------- Return As ''5,10,15''

	DECLARE Age_Cur2 Cursor For
       Select AgeRange from @ageRangeTable
    OPEN Age_Cur2
	FETCH NEXT FROM Age_Cur2 Into @age
    WHILE @@FETCH_STATUS = 0
    BEGIN
        IF(@age = 0)
         BEGIN
           SELECT  @ID=ElementID FROM  @ageRangeTable WHERE AgeRange=@age
           DELETE FROM @ageRangeTable Where ElementID=@ID
         END
         ELSE
         BEGIN
           SET @Ages=@Ages+Convert(Varchar,@age)+'',''
         END
        FETCH NEXT FROM Age_Cur2 Into @age
	END	
	CLOSE Age_Cur2
	DEALLOCATE Age_Cur2

	IF(@Ages='''')
	BEGIN
		SET @Ages=0
	END
	ELSE
	BEGIN
      SET @Ages=Substring(@Ages,1,len(@Ages)-1)
	END
    RETURN @Ages
   
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getDate_MMDDYY]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



-- the function returns date in MMDDYY format
CREATE    FUNCTION [dbo].[UDF_getDate_MMDDYY]
(
	@pDate DATETIME
)
RETURNS VARCHAR(6)
AS
BEGIN
	RETURN dbo.Date_MMDDYY(@pDate)
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getApproval_MedicaidPaperClaim]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


  
-- the function returns 1 for approved SuperBill and 0 for non-approved SuperBills  
CREATE  FUNCTION [dbo].[UDF_getApproval_MedicaidPaperClaim]  
(  
 @SuperbillUID UNIQUEIDENTIFIER,  
 @insType INT  
)  
RETURNS INT  
AS  
BEGIN  
  
 DECLARE @ProviderFName varchar(25)  
 DECLARE @ProviderLName varchar(25)  
 DECLARE @Address1 varchar(50)  
 DECLARE @Address2 varchar(50)  
 DECLARE @Address3 varchar(50)  
 DECLARE @Address4 varchar(50)  
 DECLARE @Zip1 varchar(50)  
 DECLARE @Zip2 varchar(50)  
 DECLARE @ProviderID varchar(255)  
 DECLARE @PatientLName varchar(25)  
 DECLARE @PatientFName varchar(25)  
 DECLARE @BillingNumber varchar(20)  
 DECLARE @PrimaryDiagnosisCode varchar(10)  
 DECLARE @BillingDate varchar(6)  
 DECLARE @MedicareApprovedAmount money  
 DECLARE @MedicarePaidDate varchar(6)  
 DECLARE @PrimaryPayer varchar(25)  
 DECLARE @OtherSource varchar(1)  
  
   

 SET @ProviderFName ='''' 
 SET @ProviderLName =''''  
 SET @Address1 ='''' 
 SET @Address2 =''''  
 SET @Address3 =''''
 SET @Address4 =''''
 SET @Zip1 =''''
 SET @Zip2 =''''  
 SET @ProviderID =''''  
 SET @PatientLName ='''' 
 SET @PatientFName =''''
 SET @BillingNumber ='''' 
 SET @PrimaryDiagnosisCode =''''  
 SET @BillingDate =''''
 SET @MedicareApprovedAmount ='''' 
 SET @MedicarePaidDate =''''  
 SET @PrimaryPayer =''''  
 SET @OtherSource =''''  
  
 SELECT   
--Item-1 Provider Name, address, zip  
 @ProviderFName = COALESCE(p2.FirstName,''''), @ProviderLName = COALESCE(p2.LastName,''''),  
 @Address1 = COALESCE(p2.Address1.value(''(/Address/Address1)[1]'', ''VARCHAR(100)''),''''), @Address2 = COALESCE(p2.Address1.value(''(/Address/Address2)[1]'', ''VARCHAR(100)''),''''),  
 @Address3 = COALESCE(p2.Address2.value(''(/Address/Address1)[1]'', ''VARCHAR(100)''),''''), @Address4 = COALESCE(p2.Address2.value(''(/Address/Address2)[1]'', ''VARCHAR(100)''),''''),  
 @Zip1 = COALESCE(p2.Address1.value(''(/Address/Zip)[1]'', ''VARCHAR(100)''),''''), @Zip2 = COALESCE(p2.Address2.value(''(/Address/Zip)[1]'', ''VARCHAR(100)''),''''),  
--Item-2 ProviderNumber  
 @ProviderID = COALESCE(dbo.UDF_getFormatVaribleValue(3,(CASE WHEN IP.UseCarrierPaperClaimFormat = 1 THEN IC.PaperClaimFormatUid      ELSE IP.PaperClaimFormatUid END), 12,VSFD.ClaimingProviderUID,null,VSFD.ServiceSiteUID,null,VSFD.FinancialCenterUID),''''),  
--Item-6 PatientLastName  
 @PatientLName = COALESCE(p1.LastName,''''),   
--Item-7 PatientFirstName  
 @PatientFName = COALESCE(p1.FirstName,''''),  
--Item-9 BillingNumber  
 @BillingNumber = COALESCE(pip.PlanMemberID,''''),  
--Item-10 PrimaryDiagnosisCode  
 @PrimaryDiagnosisCode = COALESCE(sd1.Code9,''''),  
--Item-15 OtherSource  
-- @OtherSource = [dbo].[UDF_getOtherSourceCode] (COALESCE(s.SuperbillUID,s.SuperbillUID)),  
--Item-17 BillingDate  
 @BillingDate = [dbo].[UDF_getDate_MMDDYY] (COALESCE(s.ServiceDateStart,'''')) 
--Item-18 MedicareApprovedAmount  
 --@MedicareApprovedAmount = CASE WHEN (@insType = 2 AND ip1.Name LIKE ''%MEDICARE%'') THEN [dbo].[UDF_getPaidAmount] (COALESCE(s.SuperbillUID,s.SuperbillUID),1) END,  
--Item-25 MedicarePaidDate  
-- @MedicarePaidDate = CASE WHEN COALESCE(CONVERT(VARCHAR(100),s.SuperBillUID),'''') <> '''' THEN  
--    [dbo].[UDF_getMedicarePaidDate] (s.SuperBillUID) ELSE '''' END,  
--  
 --@PrimaryPayer = ip1.Name  
  
  
 FROM Superbill s  
 INNER JOIN ViewSuperbillFinancialDetails VSFD ON s.SuperbillUid = VSFD.SuperbillUid
 INNER JOIN Person p1 ON s.PatientUID = p1.PersonUID  
 INNER JOIN Provider pr ON (pr.PersonUID = VSFD.ClaimingProviderUID AND pr.IsBillingProvider = 1) --***check the condition  
 INNER JOIN Person p2  ON pr.PersonUID = p2.PersonUID  
 INNER JOIN Patient pa ON p1.PersonUID = pa.PersonUID  
 INNER JOIN PersonInsurancePlan pip ON p1.PersonUID = pip.PersonUID  
 INNER JOIN InsurancePlan ip ON pip.InsurancePlanUID = ip.InsurancePlanUID AND ip.Inactive = 0 --AND ip.Name LIKE ''%Medicaid%''   
 LEFT JOIN ListAccountType latIP ON latIP.AccountTypeUid = ip.AccountTypeUid AND latIP.ExternalId = CASE WHEN ip.UseInsuranceCarrierAccountType = 0 THEN ''MC'' END  -- ''MC'' for MEDICAID 
 INNER JOIN InsuranceCarrier ic ON ip.InsuranceCarrierUID = ic.CorporationUID  
 LEFT JOIN ListAccountType latIC ON latIC.AccountTypeUid = ic.AccountTypeUid AND latIC.ExternalId = CASE WHEN ip.UseInsuranceCarrierAccountType = 1 then ''MC'' END  
 --INNER JOIN Corporation co ON (ic.CorporationUID = co.CorporationUID AND co.Name LIKE ''%medicaid%'')  
 INNER JOIN AccountInsurance ai ON pip.PersonInsurancePlanUID = ai.PersonInsurancePlanUID AND ai.DisplayOrder = @insType  
 --LEFT JOIN ListAccountType lat ON ip.AccountTypeUID = lat.AccountTypeUID AND (lat.Name like ''%Medicaid%'') -- OR ip.Name LIKE ''%Medicaid%'')  
    --commented above part as ip.AccountTypeUID can be null, bt ip.Name can''t be null  
 LEFT JOIN SuperbillDiagnosis sd1 ON (s.SuperBillUID = sd1.SuperBillUID AND sd1.DisplayOrder = 1) 
 LEFT JOIN SuperbillDiagnosis sd2 ON (s.SuperBillUID = sd2.SuperBillUID AND sd1.DisplayOrder = 2)  
 JOIN AccountPeriod on ai.AccountPeriodUid=AccountPeriod.AccountPeriodUid 
	AND ((AccountPeriod.effectiveDate IS NOT NULL AND AccountPeriod.ExpirationDate IS NULL AND  AccountPeriod.effectiveDate  <=  S.servicedatestart )
				  OR (AccountPeriod.effectiveDate IS NULL AND AccountPeriod.ExpirationDate IS NOT NULL AND  AccountPeriod.expirationDate  >=  S.servicedatestart ) 
				  OR (AccountPeriod.effectiveDate IS NOT NULL AND AccountPeriod.ExpirationDate IS NOT NULL AND  AccountPeriod.effectiveDate  <=  S.servicedatestart  AND  AccountPeriod.expirationDate  >=  S.servicedatestart ) 
				  OR (AccountPeriod.effectiveDate IS NULL AND AccountPeriod.ExpirationDate IS NULL))
  
 --LEFT JOIN PersonInsurancePlan pip1 ON (p1.PersonUID = pip1.PersonUID)   
 --LEFT JOIN InsurancePlan ip1 ON (ip1.InsurancePlanUID = pip1.InsurancePlanUID)   
 --LEFT JOIN InsuranceCarrier ic1 ON (ic1.CorporationUID = ip1.InsuranceCarrierUID)   
 --LEFT JOIN AccountInsurance ai1 ON (pip1.PersonInsurancePlanUID = ai1.PersonInsurancePlanUID AND ai1.DisplayOrder = 1)   
 ----LEFT JOIN ListAccountType lat1 ON (ip1.AccountTypeUID = lat1.AccountTypeUID)     
   
 --LEFT JOIN ListRelatedCause lrc on (s.RelatedCauseUID = lrc.RelatedCauseUID and lrc.Name like ''%accident%'')  
   
 ----INNER JOIN ClaimBatchDetail c ON (c.SuperBillUID = s.SuperBillUID AND s.ClaimPaper = 1)  
 WHERE s.SuperBillUID = @SuperBillUID AND s.ClaimPaper = 1  -- AND c.ClaimBatchUID = @ClaimBatchUID   
 AND COALESCE(CAST(ip.AccountTypeUid AS VARCHAR(50)), CAST(ic.AccountTypeUid AS VARCHAR(50)), '''') <> ''''  
   
 DECLARE @RETURN INT  
 SET @RETURN = 1  
  
 SET @RETURN =   
  CASE WHEN @ProviderFName = '''' OR @ProviderLName = '''' THEN 0  
  WHEN ((@Address1 = '''' AND @Zip1 = '''') AND (@Address2 = '''' AND @Zip1 = '''')) AND ((@Address3 = '''' AND @Zip2 = '''') AND (@Address4 = '''' AND @Zip2 = '''')) THEN  0  
  WHEN @ProviderID = '''' THEN 0  
  WHEN @PatientLName = '''' THEN 0  
  WHEN @PatientFName = '''' THEN 0  
  WHEN @BillingNumber = '''' THEN 0  
  WHEN @PrimaryDiagnosisCode = '''' THEN 0  
  WHEN @BillingDate = '''' THEN 0  
  --WHEN @PrimaryPayer LIKE ''%MEDICARE%'' AND @insType = 2 AND @MedicareApprovedAmount = 0 THEN 0 [It can be zero when payment is not done. so how to check for missing value?]  
  --WHEN @PrimaryPayer LIKE ''%MEDICARE%'' AND @insType = 2 AND @MedicarePaidDate = '''' THEN 0  
 -- WHEN @PrimaryPayer NOT LIKE ''%MEDICARE%'' AND @insType = 2 AND @OtherSource = '''' THEN 0  
  ELSE 1  
     
  END  
  
--check whether there is a CPT of zero dollar amoun applied to  
 IF @RETURN = 1  
 BEGIN    
  DECLARE @ProcedureCharge MONEY    
  DECLARE CUR_Procedure CURSOR FOR  
    SELECT ProcedureCharge FROM SuperbillProcedure WHERE SuperbillUid = @SuperbillUID AND DontClaim = 0 AND Inactive = 0 ORDER BY DisplayOrder  
   OPEN CUR_Procedure  
   FETCH NEXT FROM CUR_Procedure INTO @ProcedureCharge   
   WHILE @@FETCH_STATUS = 0   
    BEGIN  
     IF @ProcedureCharge = 0.00  
     BEGIN  
SET @RETURN = 0  
      BREAK  
     END      
     FETCH NEXT FROM CUR_Procedure INTO @ProcedureCharge   
    END  
   CLOSE CUR_Procedure  
   DEALLOCATE CUR_Procedure  
 END  
------  
  
 RETURN @RETURN  
END  



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getApproval_UB04PaperClaim]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



-- the function returns 1 for approved SuperBill and 0 for non-approved SuperBills
CREATE  FUNCTION [dbo].[UDF_getApproval_UB04PaperClaim]
(
	@SuperbillUID UNIQUEIDENTIFIER,
	@insType INT
)
RETURNS INT
AS
BEGIN

	DECLARE @ProviderFName varchar(25)
	DECLARE @ProviderLName varchar(25)
	DECLARE @Address1 varchar(50)
	DECLARE @Address2 varchar(50)
	DECLARE @Address3 varchar(50)
	DECLARE @Address4 varchar(50)
	DECLARE @Zip1 varchar(50)
	DECLARE @Zip2 varchar(50)
	DECLARE @ProviderID varchar(255)
	DECLARE @PatientLName varchar(25)
	DECLARE @PatientFName varchar(25)
	DECLARE @BillingNumber varchar(20)
	DECLARE @PrimaryDiagnosisCode varchar(10)
	DECLARE @BillingDate varchar(6)
	DECLARE @MedicareApprovedAmount money
	DECLARE @MedicarePaidDate varchar(6)
	DECLARE @PrimaryPayer varchar(25)
	DECLARE @OtherSource varchar(1)

	

	SELECT 
--Item-1 Provider Name, address, zip
	@ProviderFName = COALESCE(p2.FirstName,''''), @ProviderLName = COALESCE(p2.LastName,''''),
 @Address1 = COALESCE(p2.Address1.value(''(/Address/Address1)[1]'', ''VARCHAR(100)''),''''), @Address2 = COALESCE(p2.Address1.value(''(/Address/Address2)[1]'', ''VARCHAR(100)''),''''),  
 @Address3 = COALESCE(p2.Address2.value(''(/Address/Address1)[1]'', ''VARCHAR(100)''),''''), @Address4 = COALESCE(p2.Address1.value(''(/Address/Address2)[1]'', ''VARCHAR(100)''),''''),  
 @Zip1 = COALESCE(p2.Address1.value(''(/Address/Zip)[1]'', ''VARCHAR(100)''),''''), @Zip2 = COALESCE(p2.Address2.value(''(/Address/Zip)[1]'', ''VARCHAR(100)''),''''),  
--Item-2 ProviderNumber
/* CYS SC - WIll always fail since not using Box24J (parameter=''12'') on UB04 Paper Claim
@ProviderID = COALESCE(dbo.UDF_getFormatVaribleValue(3,(CASE WHEN IP.UseCarrierPaperClaimFormat = 1 THEN IC.PaperClaimFormatUid  
			ELSE IP.PaperClaimFormatUid END), 12,s.ClaimingProviderUID,null,s.ServiceSiteUID,null,s.FinancialCenterUID),''''),
*/
--Item-6 PatientLastName
	@PatientLName = COALESCE(p1.LastName,''''), 
--Item-7 PatientFirstName
	@PatientFName = COALESCE(p1.FirstName,''''),
--Item-9 BillingNumber
	@BillingNumber = COALESCE(pip.PlanMemberID,''''),
--Item-10 PrimaryDiagnosisCode
	@PrimaryDiagnosisCode = COALESCE(sd1.Code9,''''),
--Item-15 OtherSource
--	@OtherSource = [dbo].[UDF_getOtherSourceCode] (COALESCE(s.SuperbillUID,s.SuperbillUID)),
--Item-17 BillingDate
	@BillingDate = [dbo].[UDF_getDate_MMDDYY] (COALESCE(s.ServiceDateStart,'''')),
--Item-18 MedicareApprovedAmount
	--@MedicareApprovedAmount = CASE WHEN (@insType = 2 AND ip1.Name LIKE ''%MEDICARE%'') THEN [dbo].[UDF_getPaidAmount] (COALESCE(s.SuperbillUID,s.SuperbillUID),1) END,
--Item-25 MedicarePaidDate
--	@MedicarePaidDate = CASE WHEN COALESCE(CONVERT(VARCHAR(100),s.SuperBillUID),'''') <> '''' THEN
--				[dbo].[UDF_getMedicarePaidDate] (s.SuperBillUID) ELSE '''' END,
--
	@PrimaryPayer = ip1.Name


	FROM Superbill s
	INNER JOIN ViewSuperbillFinancialDetails VSFD ON s.SuperbillUid = VSFD.SuperbillUid
	INNER JOIN Person p1 ON s.PatientUID = p1.PersonUID
	INNER JOIN Provider pr ON (pr.PersonUID = VSFD.ClaimingProviderUID AND pr.IsBillingProvider = 1)	--***check the condition
	INNER JOIN Person p2  ON pr.PersonUID = p2.PersonUID
	INNER JOIN Patient pa ON p1.PersonUID = pa.PersonUID
	INNER JOIN PersonInsurancePlan pip ON p1.PersonUID = pip.PersonUID
	INNER JOIN InsurancePlan ip ON pip.InsurancePlanUID = ip.InsurancePlanUID AND ip.Inactive = 0 --AND ip.Name LIKE ''%Medicaid%'' 
	LEFT JOIN ListAccountType latIP ON latIP.AccountTypeUid = ip.AccountTypeUid AND latIP.ExternalId = CASE WHEN ip.UseInsuranceCarrierAccountType = 0 THEN ''MC'' END  -- ''MC'' for MEDICAID
	INNER JOIN InsuranceCarrier ic ON ip.InsuranceCarrierUID = ic.CorporationUID
	LEFT JOIN ListAccountType latIC ON latIC.AccountTypeUid = ic.AccountTypeUid AND latIC.ExternalId = CASE WHEN ip.UseInsuranceCarrierAccountType = 1 then ''MC'' END
	--INNER JOIN Corporation co ON (ic.CorporationUID = co.CorporationUID AND co.Name LIKE ''%medicaid%'')
	INNER JOIN AccountInsurance ai ON pip.PersonInsurancePlanUID = ai.PersonInsurancePlanUID AND ai.DisplayOrder = @insType
	--LEFT JOIN ListAccountType lat ON ip.AccountTypeUID = lat.AccountTypeUID AND (lat.Name like ''%Medicaid%'') -- OR ip.Name LIKE ''%Medicaid%'')
				--commented above part as ip.AccountTypeUID can be null, bt ip.Name can''t be null
	LEFT JOIN SuperbillDiagnosis sd1 ON (s.SuperBillUID = sd1.SuperBillUID AND sd1.DisplayOrder = 1)
	LEFT JOIN SuperbillDiagnosis sd2 ON (s.SuperBillUID = sd2.SuperBillUID AND sd1.DisplayOrder = 2)
	
	LEFT JOIN PersonInsurancePlan pip1 ON (p1.PersonUID = pip1.PersonUID) 
	LEFT JOIN InsurancePlan ip1 ON (ip1.InsurancePlanUID = pip1.InsurancePlanUID) 
	LEFT JOIN InsuranceCarrier ic1 ON (ic1.CorporationUID = ip1.InsuranceCarrierUID) 
	LEFT JOIN AccountInsurance ai1 ON (pip1.PersonInsurancePlanUID = ai1.PersonInsurancePlanUID AND ai1.DisplayOrder = 1) 
	--LEFT JOIN ListAccountType lat1 ON (ip1.AccountTypeUID = lat1.AccountTypeUID)   
	
	LEFT JOIN ListRelatedCause lrc on (s.RelatedCauseUID = lrc.RelatedCauseUID and lrc.Name like ''%accident%'')
	
	--INNER JOIN ClaimBatchDetail c ON (c.SuperBillUID = s.SuperBillUID AND s.ClaimPaper = 1)
	WHERE s.SuperBillUID = @SuperBillUID AND s.ClaimPaper = 1 	-- AND c.ClaimBatchUID = @ClaimBatchUID 
	AND COALESCE(CAST(ip.AccountTypeUid AS VARCHAR(50)), CAST(ic.AccountTypeUid AS VARCHAR(50)), '''') <> ''''
	
	DECLARE @RETURN INT
	SET @RETURN = 1

	SET @RETURN = 
		CASE WHEN @ProviderFName = '''' OR @ProviderLName = '''' THEN 0
		WHEN ((@Address1 = '''' AND @Zip1 = '''') AND (@Address2 = '''' AND @Zip1 = '''')) AND ((@Address3 = '''' AND @Zip2 = '''') AND (@Address4 = '''' AND @Zip2 = '''')) THEN  0
		--WHEN @ProviderID = '''' THEN 0
		WHEN @PatientLName = '''' THEN 0
		WHEN @PatientFName = '''' THEN 0
		WHEN @BillingNumber = '''' THEN 0
		WHEN @PrimaryDiagnosisCode = '''' THEN 0
		WHEN @BillingDate = '''' THEN 0
		--WHEN @PrimaryPayer LIKE ''%MEDICARE%'' AND @insType = 2 AND @MedicareApprovedAmount = 0 THEN 0	[It can be zero when payment is not done. so how to check for missing value?]
		--WHEN @PrimaryPayer LIKE ''%MEDICARE%'' AND @insType = 2 AND @MedicarePaidDate = '''' THEN 0
	--	WHEN @PrimaryPayer NOT LIKE ''%MEDICARE%'' AND @insType = 2 AND @OtherSource = '''' THEN 0
		ELSE 1
			
		END

--check whether there is a CPT of zero dollar amoun applied to
	IF @RETURN = 1
	BEGIN		
		DECLARE @ProcedureCharge MONEY		
		DECLARE CUR_Procedure CURSOR FOR
				SELECT ProcedureCharge FROM SuperbillProcedure WHERE SuperbillUid = @SuperbillUID AND DontClaim = 0 AND Inactive = 0 ORDER BY DisplayOrder
			OPEN CUR_Procedure
			FETCH NEXT FROM CUR_Procedure INTO @ProcedureCharge 
			WHILE @@FETCH_STATUS = 0 
				BEGIN
					IF @ProcedureCharge = 0.00
					BEGIN
						SET @RETURN = 0
						BREAK
					END				
					FETCH NEXT FROM CUR_Procedure INTO @ProcedureCharge 
				END
			CLOSE CUR_Procedure
			DEALLOCATE CUR_Procedure
	END
------

	RETURN @RETURN
END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getClaimFormatTypeValue]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_getClaimFormatTypeValue]
(	@FormatTypeUid UNIQUEIDENTIFIER,
	@ProviderUid UNIQUEIDENTIFIER = NULL,
	@FinancialCenterUid UNIQUEIDENTIFIER = NULL,
	@ServiceSiteUid UNIQUEIDENTIFIER = NULL
)
RETURNS VARCHAR(255)
AS
BEGIN
	DECLARE @retVal VARCHAR(255)
	SELECT top 1 @retVal = COALESCE(value, '''''''')
	FROM ClaimFormatValue
	WHERE ClaimFormatValueTypeUid = @FormatTypeUid
	AND ((ProviderUid IS NOT NULL AND ProviderUid = @ProviderUid) OR (ProviderUid IS NULL AND @ProviderUid is NULL) OR (ProviderUid IS NULL))
	AND ((FinancialCenterUid IS NOT NULL AND FinancialCenterUid = @FinancialCenterUid) OR (FinancialCenterUid IS NULL AND @FinancialCenterUid is NULL) OR (FinancialCenterUid IS NULL))
	AND ((ServiceSiteUid IS NOT NULL AND ServiceSiteUid = @ServiceSiteUid) OR (ServiceSiteUid IS NULL AND @ServiceSiteUid is NULL) OR (ServiceSiteUid IS NULL))
	ORDER BY FinancialCenterUid desc, ServiceSiteUid desc
	RETURN @retVal
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getCoInsuranceAmount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[UDF_getCoInsuranceAmount]       
(   
--@ReasonERACodeUid UNIQUEIDENTIFIER,    
@SuperbillUid UNIQUEIDENTIFIER,      
@InsType int    
)      
--@ReasonERACodeUid = ''F1817650-B562-4428-AB3F-0F67267FC631'' is for Deductables    
--@ReasonERACodeUid = 226B3F3A-2D51-4D21-B63B-615EA23E7871 is for Co-Insurance    
RETURNS MONEY       
AS    
BEGIN    
DECLARE @CoInsuranceAmount MONEY    
  
SELECT  
	  @CoInsuranceAmount = -1 * SUM(V.Amount)  
	FROM
		ViewPaymentEntryCredits_MedicaidPaper V
	JOIN   
		ViewERAReasonCode VRC
	ON
		VRC.ERACodeUid = V.ReasonCodeERACodeUid  
	WHERE 				
		V.SuperbillUid =@SuperbillUid
	AND
		VRC.Code =''2''
	AND
		V.LiabilityOwner = @InsType 	
	
 RETURN @CoInsuranceAmount
END    



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getCPTCode]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_getCPTCode]
(
 @SuperbillUid UNIQUEIDENTIFIER,
 @Type Bit

)
RETURNS VARCHAR(255)
AS
BEGIN
	DECLARE @retVal VARCHAR(255),
			@EM  VARCHAR(255),
			@ALL VARCHAR(255),
			@CPT VARCHAR(255),
			@ISEM Bit

	SELECT @retVal = '''', @EM = '''', @ALL = ''''

	IF @Type = 0
	BEGIN
		SELECT @retVal = @retVal + CASE WHEN LEN (@retVal) > 0 THEN '', '' ELSE '''' END + lp.Code 
		FROM ListProcedure AS lp
			INNER JOIN SuperBillProcedure AS sp ON lp.ProcedureUid = sp.ProcedureUid
		WHERE sp.SuperBillUid = @SuperbillUid
		ORDER BY sp.DisplayOrder
	END
	IF @Type = 1
	BEGIN
		SELECT @EM = @EM + CASE WHEN lp.IsEM <> 0 THEN CASE WHEN LEN (@EM) > 0 THEN '', '' ELSE '''' END + lp.Code
						   ELSE ''''
						   END,
			   @ALL = @ALL + CASE WHEN lp.IsEM = 0 THEN CASE WHEN LEN (@ALL) > 0 THEN '', '' ELSE '''' END + lp.Code
								  ELSE ''''
							 END
		FROM ListProcedure AS lp
			INNER JOIN SuperBillProcedure AS sp ON lp.ProcedureUid = sp.ProcedureUid
		WHERE sp.SuperBillUid = @SuperbillUid
		ORDER BY sp.DisplayOrder

		SET @retVal =  @EM + CASE WHEN LEN (@EM) > 0 THEN '', '' ELSE '''' END + @ALL
	END
	RETURN(@retVal)
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getDeductableAmount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_getDeductableAmount]       
(   
--@CreditTypeUid UNIQUEIDENTIFIER = NULL,    
--@ReasonERACodeUid UNIQUEIDENTIFIER,    
@SuperbillUid UNIQUEIDENTIFIER,      
@InsType int    
)      
--@ReasonERACodeUid = ''F1817650-B562-4428-AB3F-0F67267FC631'' is for Deductables    
--@ReasonERACodeUid = 226B3F3A-2D51-4D21-B63B-615EA23E7871 is for Co-Insurance    
RETURNS MONEY       
AS    
BEGIN    
DECLARE @DeductableAmount MONEY    
    
SELECT      
 @DeductableAmount = -1 * SUM(V.Amount)      
FROM
 ViewPaymentEntryCredits_MedicaidPaper V
 JOIN   
	ViewERAReasonCode VRC
	ON
		VRC.ERACodeUid = V.ReasonCodeERACodeUid 
	WHERE 				
		V.SuperbillUid =@SuperbillUid
	AND
		VRC.Code =''1''
	AND
		V.LiabilityOwner = @InsType 
		
 RETURN @DeductableAmount
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getDiagnosis]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[UDF_getDiagnosis]
(
	@SuperbillUid UNIQUEIDENTIFIER ,
	@DisplayOrder INT 
)
RETURNS VARCHAR(255)
AS
BEGIN
		DECLARE @retVal VARCHAR(255)
		SET @retVal = ''''
	
	
		Select @retVal = COALESCE(sbd.Code9, '''')  FROM Superbill d
		INNER JOIN SuperBillDiagnosis sbd ON sbd.SuperbillUid = d.SuperbillUid 
		
		WHERE d.Superbilluid = @SuperbillUid
			AND sbd.displayorder = @DisplayOrder

	RETURN(@retVal)

END














' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getFormattedName_FS]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE  FUNCTION  [dbo].[UDF_getFormattedName_FS]


(


	@sPrefix	varchar(25),


	@sFirstName	varchar(50),


	@sMiddleName	varchar(50),


	@sLastName	varchar(50),


	@sSuffix	varchar(50)


)


RETURNS varchar(100)


AS


BEGIN 


	return(


		(CASE WHEN @sPrefix is null THEN '''' ELSE @sPrefix + '' '' END) 


		+ (CASE WHEN @sLastName is null THEN '''' ELSE @sLastName + '', '' END)


		+ (CASE WHEN @sFirstName is null THEN '''' ELSE @sFirstName END)


		+ (CASE WHEN @sMiddleName is null THEN '''' ELSE '' '' +@sMiddleName END)


		+ (CASE WHEN @sSuffix is null THEN '''' ELSE '', '' + @sSuffix END)


	)





END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getFormattedName_PI]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE  FUNCTION  [dbo].[UDF_getFormattedName_PI]

(

	@sPrefix	varchar(25),

	@sFirstName	varchar(50),

	@sMiddleName	varchar(50),

	@sLastName	varchar(50),

	@sSuffix	varchar(50)

)

RETURNS varchar(100)

AS

BEGIN 

	return(

		(CASE WHEN @sPrefix is null THEN '''' ELSE @sPrefix + '' '' END) 

		+ (CASE WHEN @sLastName is null THEN '''' ELSE @sLastName + '', '' END)

		+ (CASE WHEN @sFirstName is null THEN '''' ELSE @sFirstName END)

		+ (CASE WHEN @sMiddleName is null THEN '''' ELSE '' '' +@sMiddleName END)

		+ (CASE WHEN @sSuffix is null THEN '''' ELSE '', '' + @sSuffix END)

	)



END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getFormattedName_RA]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE  FUNCTION  [dbo].[UDF_getFormattedName_RA]
(
	@sPrefix	varchar(25),
	@sFirstName	varchar(50),
	@sMiddleName	varchar(50),
	@sLastName	varchar(50),
	@sSuffix	varchar(50)
)
RETURNS varchar(100)
AS
BEGIN 
	return(
		(CASE WHEN @sPrefix is null THEN '''' ELSE @sPrefix + '' '' END) 
		+ (CASE WHEN @sLastName is null THEN '''' ELSE @sLastName + '', '' END)
		+ (CASE WHEN @sFirstName is null THEN '''' ELSE @sFirstName END)
		+ (CASE WHEN @sMiddleName is null THEN '''' ELSE '' '' +@sMiddleName END)
		+ (CASE WHEN @sSuffix is null THEN '''' ELSE '', '' + @sSuffix END)
	)

END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getFormattedName_VP]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE  FUNCTION  [dbo].[UDF_getFormattedName_VP]


(


	@sPrefix	varchar(25),


	@sFirstName	varchar(50),


	@sMiddleName	varchar(50),


	@sLastName	varchar(50),


	@sSuffix	varchar(50)


)


RETURNS varchar(100)


AS


BEGIN 


	return(


		(CASE WHEN @sPrefix is null THEN '''' ELSE @sPrefix + '' '' END) 


		+ (CASE WHEN @sLastName is null THEN '''' ELSE @sLastName + '', '' END)


		+ (CASE WHEN @sFirstName is null THEN '''' ELSE @sFirstName END)


		+ (CASE WHEN @sMiddleName is null THEN '''' ELSE '' '' +@sMiddleName END)


		+ (CASE WHEN @sSuffix is null THEN '''' ELSE '', '' + @sSuffix END)


	)





END








' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getFormattedNameChc]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION  [dbo].[UDF_getFormattedNameChc] 
(
    @sPrefix    varchar(25),
    @sFirstName varchar(50),
    @sMiddleName    varchar(50),
    @sLastName  varchar(50),
    @sSuffix    varchar(50)
)
RETURNS varchar(100)
AS
BEGIN 
    /* Example:
    select top 10 
    dbo.UDF_getFormattedNameChc(
        p.Prefix,
        p.FirstName,
        p.MiddleName,
        p.LastName,
        p.Suffix)
    from Person p
    */

    return(
        (CASE WHEN @sPrefix is null THEN '''' ELSE @sPrefix + '' '' END) 
        + (CASE WHEN @sLastName is null THEN '''' ELSE @sLastName + '', '' END)
        + (CASE WHEN @sFirstName is null THEN '''' ELSE @sFirstName END)
        + (CASE WHEN @sMiddleName is null THEN '''' ELSE '' '' +@sMiddleName END)
        + (CASE WHEN @sSuffix is null THEN '''' ELSE '', '' + @sSuffix END)
    )
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getFormatVariableValue2]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_getFormatVariableValue2]

(	@exportFormatType INT,
	@exportFormatGUID UNIQUEIDENTIFIER,
	@exportFormatOptionType INT,
	@iProvider VARCHAR(50) = NULL,
	@renderer VARCHAR(50) = NULL,
	@serviceSiteUid VARCHAR(50) = NULL, --INT = NULL,
	@refUUID UNIQUEIDENTIFIER = NULL,
	@FinancialCenterUid  VARCHAR(50) = NULL
)
RETURNS VARCHAR(255)
AS
BEGIN
	DECLARE @retVal VARCHAR(255)
	SET @retVal='''' 
	
	DECLARE @FormatOptionTypeName VARCHAR(50)  

	SET @iProvider = ISNULL(@iProvider,''00000000-0000-0000-0000-000000000000'')
	SET @renderer = ISNULL(@renderer,''00000000-0000-0000-0000-000000000000'')
	SET @serviceSiteUid = ISNULL(@serviceSiteUid, ''00000000-0000-0000-0000-000000000000'')
	SET @refUUID = ISNULL(@refUUID,''00000000-0000-0000-0000-000000000000'')
	SET @FinancialCenterUid = ISNULL(@FinancialCenterUid,''14B99C94-EDAC-47BD-97B9-CF421AC16018'')
	
	
	-- NOTE:  Modeled after UDF_getFormatVaribleValue but this function returns value2 rather than value
	--        Only using those exportFormatTypes currently needed.  See UDF_getFormatVaribleValue if adding other types
	if ( @exportFormatType = 2 )
	BEGIN
			IF @exportFormatOptionType = 9 
				SET @FormatOptionTypeName = ''File as Group or Individual''
				
		SELECT @retVal = CASE WHEN ClaimFormatOption.ClaimFormatValueTypeUid IS NULL THEN  ISNULL(ClaimFormatOption.FixedValue, '''') 
					ELSE ISNULL(ClaimFormatValue.value2,'''')
					END
			FROM ClaimFormatOption
			LEFT JOIN ClaimFormatValue ON ClaimFormatValue.ClaimFormatValueTypeUid =  ClaimFormatOption.ClaimFormatValueTypeUid
				AND ((ClaimFormatValue.ProviderUid IS NOT NULL AND CONVERT(VARCHAR(50), ClaimFormatValue.ProviderUid) = @iProvider )OR (ClaimFormatValue.ProviderUid IS NULL AND @iProvider = ''00000000-0000-0000-0000-000000000000'') OR (ClaimFormatValue.ProviderUid IS NULL))
				AND ((ClaimFormatValue.ServiceSiteUid IS NOT NULL AND CONVERT(VARCHAR(50), ClaimFormatValue.ServiceSiteUid) = @serviceSiteUid) OR (ClaimFormatValue.ServiceSiteUid IS NULL AND @serviceSiteUid = ''00000000-0000-0000-0000-000000000000'') OR (ClaimFormatValue.ServiceSiteUid IS NULL ))
				AND ((ClaimFormatValue.FinancialCenterUid IS NOT NULL AND CONVERT(VARCHAR(50), ClaimFormatValue.FinancialCenterUid) = @FinancialCenterUid) OR (ClaimFormatValue.FinancialCenterUid IS NULL AND @FinancialCenterUid = ''14B99C94-EDAC-47BD-97B9-CF421AC16018'') OR (ClaimFormatValue.FinancialCenterUid IS NULL ))
			LEFT JOIN ListClaimFormatOptionType ON ListClaimFormatOptionType.ClaimFormatOptionTypeUid = ClaimFormatOption.ClaimFormatOptionTypeUid
			WHERE ListClaimFormatOptionType.Name LIKE @FormatOptionTypeName
				AND ClaimFormatOption.ClaimFormatUid = @exportFormatGUID
			ORDER BY ServiceSiteUid, ProviderUid, FinancialCenterUid -- per bug 8968 added FinancialCenterUid to sort order
		
	END
	
	RETURN(@retVal)
END








' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getFormatVariableValueByMedicalServicesProviderUid]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[UDF_getFormatVariableValueByMedicalServicesProviderUid] 
(
	@exportFormatGUID UNIQUEIDENTIFIER,
	@iMedicalServicesProvider VARCHAR(50) = NULL,
	@serviceSiteUid VARCHAR(50) = NULL, 
	@FinancialCenterUid  VARCHAR(50) = NULL
)
RETURNS VARCHAR(255)
AS
BEGIN
	DECLARE @retVal VARCHAR(255)

	SET @iMedicalServicesProvider = ISNULL(@iMedicalServicesProvider,''00000000-0000-0000-0000-000000000000'')
	SET @serviceSiteUid = ISNULL(@serviceSiteUid, ''00000000-0000-0000-0000-000000000000'')
	SET @FinancialCenterUid = ISNULL(@FinancialCenterUid,''14B99C94-EDAC-47BD-97B9-CF421AC16018'')

	SELECT @retVal = ISNULL(eClaimFormatValue.value, '''')	
	FROM ListClaimFormatValueType eListClaimFormatValueType
			LEFT JOIN ClaimFormatValue eClaimFormatValue ON	eClaimFormatValue.ClaimFormatValueTypeUid = eListClaimFormatValueType.ClaimFormatValueTypeUid AND
						((eClaimFormatValue.MedicalServicesProviderUid IS NOT NULL AND CONVERT(VARCHAR(50),eClaimFormatValue.MedicalServicesProviderUid) = @iMedicalServicesProvider )OR (eClaimFormatValue.MedicalServicesProviderUid IS NULL AND @iMedicalServicesProvider = ''00000000-0000-0000-0000-000000000000'') OR (eClaimFormatValue.MedicalServicesProviderUid IS NULL)) AND
						((eClaimFormatValue.ServiceSiteUid IS NOT NULL AND CONVERT(VARCHAR(50),eClaimFormatValue.ServiceSiteUid) = @serviceSiteUid) OR (eClaimFormatValue.ServiceSiteUid IS NULL AND @serviceSiteUid = ''00000000-0000-0000-0000-000000000000'') OR (eClaimFormatValue.ServiceSiteUid IS NULL)) AND
						((eClaimFormatValue.FinancialCenterUid IS NOT NULL AND CONVERT(VARCHAR(50), eClaimFormatValue.FinancialCenterUid) = @FinancialCenterUid) OR (eClaimFormatValue.FinancialCenterUid IS NULL AND @FinancialCenterUid = ''14B99C94-EDAC-47BD-97B9-CF421AC16018'') OR (eClaimFormatValue.FinancialCenterUid IS NULL))
	WHERE
		eListClaimFormatValueType.ClaimFormatValueTypeUid = @exportFormatGUID 
	ORDER BY ServiceSiteUid, MedicalServicesProviderUid, FinancialCenterUid

	RETURN(@retVal)
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getFormatVariableValueByMedicalServicesProvider]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

-- DSW 08/15/2014 16026	Created for Medical Services Provider

CREATE FUNCTION [dbo].[UDF_getFormatVariableValueByMedicalServicesProvider]
(	@exportFormatGUID UNIQUEIDENTIFIER,			-- ClaimFormatType
	@exportFormatType INT,						-- 2 == Electronic, 3 == Paper
	@exportFormatOptionType INT,				-- Option Type on claim format ( ListClaimFormatOptionType )
	@iMSPProvider VARCHAR(50) = NULL,			-- Medical Services Provider
	@serviceSiteUid VARCHAR(50) = NULL,			--Service Site
	@FinancialCenterUid  VARCHAR(50) = NULL		-- Financial Center
)
RETURNS VARCHAR(255)
AS
BEGIN
	DECLARE @retVal VARCHAR(255)
	DECLARE @FormatOptionTypeName VARCHAR(50)  

	SET @iMSPProvider = ISNULL(@iMSPProvider,''00000000-0000-0000-0000-000000000000'')
	SET @serviceSiteUid = ISNULL(@serviceSiteUid, ''00000000-0000-0000-0000-000000000000'')
	SET @FinancialCenterUid = ISNULL(@FinancialCenterUid,''14B99C94-EDAC-47BD-97B9-CF421AC16018'')

	-- NOTE:  Should be calling UDF_getFormatVariableValueByMedicalServicesProvider if not calling with 2 or 3
	IF @exportFormatType = 2 OR @exportFormatType = 3
	BEGIN
		IF @exportFormatType = 2 -- Electronic
		BEGIN
			IF @exportFormatOptionType = 0 
				SET @FormatOptionTypeName = ''Purchased Service ID''
			IF @exportFormatOptionType = 1 
				SET @FormatOptionTypeName = ''Purchased Service ID Type''
		END
		ELSE
		IF @exportFormatType = 3 -- Paper CMS-1500, Paper CMS-1500 5010
		BEGIN
			IF @exportFormatOptionType = 0 
				SET @FormatOptionTypeName = ''Purchased Service BOX 32b''
			IF @exportFormatOptionType = 1 
				SET @FormatOptionTypeName = ''Purchased Service BOX 32b Type''
		END
		
		SELECT @retVal = COALESCE( NULLIF(cfo.FixedValue, ''''), cfv.value)
		FROM ClaimFormatOption cfo with (nolock)
			LEFT JOIN ClaimFormatValue cfv with (nolock) ON cfo.ClaimFormatValueTypeUid = cfv.ClaimFormatValueTypeUid   
				AND ((cfv.MedicalServicesProviderUid IS NOT NULL AND CONVERT(VARCHAR(50), cfv.MedicalServicesProviderUid) = @iMSPProvider )
				     OR (cfv.MedicalServicesProviderUid IS NULL AND @iMSPProvider = ''00000000-0000-0000-0000-000000000000'') 
					 OR (cfv.MedicalServicesProviderUid IS NULL))
				AND ((cfv.ServiceSiteUid IS NOT NULL AND CONVERT(VARCHAR(50), cfv.ServiceSiteUid) = @serviceSiteUid) 
				     OR (cfv.ServiceSiteUid IS NULL AND @serviceSiteUid = ''00000000-0000-0000-0000-000000000000'') 
					 OR (cfv.ServiceSiteUid IS NULL ))				
				AND ((cfv.FinancialCenterUid IS NOT NULL AND CONVERT(VARCHAR(50), cfv.FinancialCenterUid) = @FinancialCenterUid) 
				     OR (cfv.FinancialCenterUid IS NULL AND @FinancialCenterUid = ''14B99C94-EDAC-47BD-97B9-CF421AC16018'') 
					 OR (cfv.FinancialCenterUid IS NULL ))
			LEFT JOIN ListClaimFormatOptionType cfot with (nolock) ON cfo.ClaimFormatOptionTypeUid = cfot.ClaimFormatOptionTypeUid 
			WHERE cfot.Name LIKE @FormatOptionTypeName
					AND cfo.ClaimFormatUid = @exportFormatGUID
			ORDER BY ServiceSiteUid, MedicalServicesProviderUid, FinancialCenterUid 
	END
	ELSE		/* @exportFormatType = 0 */
	BEGIN
		select @retVal = dbo.UDF_getFormatVariableValueByMedicalServicesProviderUid( @exportFormatGUID, @iMSPProvider, @serviceSiteUid, @FinancialCenterUid)
	END

	RETURN(@retVal)

END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getLabResultList]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE  FUNCTION [dbo].[UDF_getLabResultList]
(
	 @PersonUid UNIQUEIDENTIFIER = NULL
	 ,@TotalCholesterolLOINCUid UNIQUEIDENTIFIER = NULL
	 ,@TotalCholesterol varchar(max)
	 ,@HDLLOINCUid UNIQUEIDENTIFIER = NULL
	 ,@HDL varchar(max) = NULL
	 ,@LDLLOINCUid UNIQUEIDENTIFIER = NULL
	 ,@LDL varchar(max) = NULL
	 ,@TriglyceridesLOINCUid UNIQUEIDENTIFIER = NULL
	 ,@Triglycerides varchar(max) = NULL
 	 ,@LabResults_StartDate datetime = NULL
	 ,@LabResults_EndDate datetime = NULL  
)
RETURNS  VARCHAR(Max)
AS 
BEGIN 
		DECLARE @LabResultList VARCHAR(Max) = ''N/A''

		SET @LabResults_StartDate = ISNULL(@LabResults_StartDate , ''1-01-1997'')
		SET @LabResults_EndDate = ISNULL(@LabResults_EndDate, getdate()) 
	
		SELECT @LabResults_StartDate = dbo.getPracticeUTCDateTime (@LabResults_StartDate)
		SELECT @LabResults_EndDate =  DATEADD(DAY,1,dbo.getPracticeUTCDateTime(@LabResults_EndDate))
				
		DECLARE @TotalCholesterolStart varchar(100)
		DECLARE @TotalCholesterolEnd varchar(100)
		
		Set @TotalCholesterolStart = ''0''
		Set @TotalCholesterolEnd = ''999''
		
		If( @TotalCholesterol IS NOT NULL AND LEN( @TotalCholesterol) > 0 )
		BEGIN
			select @TotalCholesterolStart = Element from Split(@TotalCholesterol,''-'') where ElementID = 1
			select @TotalCholesterolEnd = Element from Split(@TotalCholesterol,''-'') where ElementID = 2
		END
		
		DECLARE @HDLStart varchar(100)
		DECLARE @HDLEnd varchar(100)
		
		Set @HDLStart = ''0''
		Set @HDLEnd = ''999''
		
		If( @HDL IS NOT NULL AND LEN(@HDL) > 0 )
		BEGIN
			select @HDLStart = Element from Split(@HDL,''-'') where ElementID = 1
			select @HDLEnd = Element from Split(@HDL,''-'') where ElementID = 2
		END
		
		DECLARE @LDLStart varchar(100)
		DECLARE @LDLEnd varchar(100)
		
		If( @LDL IS NOT NULL AND LEN( @LDL) > 0 )
		BEGIN
			select @LDLStart = Element from Split(@LDL,''-'') where ElementID = 1
			select @LDLEnd = Element from Split(@LDL,''-'') where ElementID = 2
		END
		
		DECLARE @TriglyceridesStart varchar(100)
		DECLARE @TriglyceridesEnd varchar(100)
		
		Set @TriglyceridesStart = ''0''
		Set @TriglyceridesEnd = ''999''
		
		If( @Triglycerides IS NOT NULL AND LEN( @Triglycerides) > 0 )
		BEGIN
			select @TriglyceridesStart = Element from Split(@Triglycerides,''-'') where ElementID = 1
			select @TriglyceridesEnd = Element from Split(@Triglycerides,''-'') where ElementID = 2
		END

		if (@TotalCholesterolLOINCUid != ''00000000-0000-0000-0000-000000000000'' 
			OR 
			@HDLLOINCUid != ''00000000-0000-0000-0000-000000000000''
			OR
			@LDLLOINCUid != ''00000000-0000-0000-0000-000000000000''
			OR
			@TriglyceridesLOINCUid != ''00000000-0000-0000-0000-000000000000''
			)
		BEGIN
		SELECT @LabResultList = 
				(substring(
				(SELECT ( '';'' + loi.Name + '': '' + coalesce(nullif(Convert(VARCHAR(50),ISNULL(ov.ObservationValue,'''')),''''),''N/A'') + '' Resulted: '' + (Convert(VARCHAR(50),oo.ResultDate,101)))
                 FROM    ObservationOrder oo 
				 INNER JOIN ObservationValue    ov  ON ov.ObservationOrderUid = oo.ObservationOrderUid 
				 INNER JOIN ListObservationItem loi ON loi.ObservationItemUid = ov.ObservationItemUid 
				 INNER JOIN ListLOINC           ll  ON ll.LOINCUid            = loi.LOINCUid 
				 inner join Person				PR  ON PR.PersonUid			  = oo.PatientUid			
				 where 
				    oo.IsDelete = 0
				    AND
					@PersonUid = oo.PatientUid
					AND
					(
					    (
					    loi.LOINCUid = @TotalCholesterolLOINCUid 
					    AND (coalesce(nullif(Convert(VARCHAR(50),ISNULL(ov.ObservationValue,'''')),''''),''''))  >= @TotalCholesterolStart 
					    AND (coalesce(nullif(Convert(VARCHAR(50),ISNULL(ov.ObservationValue,'''')),''''),''''))  <= @TotalCholesterolEnd 
					    )
					    OR
					    (
							loi.LOINCUid = @HDLLOINCUid 
							AND (coalesce(nullif(Convert(VARCHAR(50),ISNULL(ov.ObservationValue,'''')),''''),''''))  >= @HDLStart 
							AND (coalesce(nullif(Convert(VARCHAR(50),ISNULL(ov.ObservationValue,'''')),''''),''''))  <= @HDLEnd
						)
						OR
						(
							loi.LOINCUid = @LDLLOINCUid 
							AND (coalesce(nullif(Convert(VARCHAR(50),ISNULL(ov.ObservationValue,'' '')),'' ''),'' ''))  >= @LDLStart 
							AND (coalesce(nullif(Convert(VARCHAR(50),ISNULL(ov.ObservationValue,'' '')),'' ''),'' ''))  <= @LDLEnd
						)
					OR
						(
							loi.LOINCUid = @TriglyceridesLOINCUid 
							AND (coalesce(nullif(Convert(VARCHAR(50),ISNULL(ov.ObservationValue,'''')),''''),''''))  >= @TriglyceridesStart 
							AND (coalesce(nullif(Convert(VARCHAR(50),ISNULL(ov.ObservationValue,'''')),''''),''''))  <= @TriglyceridesEnd		
						)			    
					)					 
					AND					
					oo.ResultDate >= CONVERT(DATE,@LabResults_StartDate) AND oo.ResultDate < CONVERT(DATE,@LabResults_EndDate)
				 order by oo.ResultDate, loi.Name
				 FOR XML PATH( '''' )
				 ), 2, 2500 ) )		
		END
		ELSE
		BEGIN
		SELECT @LabResultList = 
				(substring(
				(SELECT ( '';'' + loi.Name + '': '' + coalesce(nullif(Convert(VARCHAR(50),ISNULL(ov.ObservationValue,'''')),''''),''N/A'') + '' Resulted: '' + (Convert(VARCHAR(50),oo.ResultDate,101)))
                 FROM    ObservationOrder oo 
				 INNER JOIN ObservationValue    ov  ON ov.ObservationOrderUid = oo.ObservationOrderUid 
				 INNER JOIN ListObservationItem loi ON loi.ObservationItemUid = ov.ObservationItemUid 
				 INNER JOIN ListLOINC           ll  ON ll.LOINCUid            = loi.LOINCUid 
				 inner join Person				PR  ON PR.PersonUid			  = oo.PatientUid			
				 where 
				    oo.IsDelete = 0
				    AND
					@PersonUid = oo.PatientUid				 
					AND					
					oo.ResultDate >= @LabResults_StartDate AND oo.ResultDate < @LabResults_EndDate
				 order by oo.ResultDate, loi.Name
				 FOR XML PATH( '''' )
				 ), 2, 2500 ) )						 
		 END									 
		RETURN @LabResultList
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getLastFilingDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- =============================================
-- Author:		<Lionel Godolphin>
-- Create date: <4/27/06>
-- Description:	<Gets Last Filing Date for Superbill>
-- =============================================
CREATE FUNCTION [dbo].[UDF_getLastFilingDate] 
(
	-- Add the parameters for the function here
	@SuperbillUid	uniqueidentifier
)
RETURNS datetime
AS
BEGIN
	-- Declare the return variable here
	DECLARE @LastFilingDate	datetime

	-- Add the T-SQL statements to compute the return value here
	SELECT @LastFilingDate = MAX(ClaimDate) 
		FROM dbo.ClaimBatch cb
		JOIN dbo.ClaimBatchDetail cbd ON (cbd.ClaimBatchUid = cb.ClaimBatchUid)
		WHERE cbd.SuperbillUid = @SuperbillUid

	-- Return the result of the function
	RETURN @LastFilingDate

END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getMedicareApprovedAmount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE FUNCTION [dbo].[UDF_getMedicareApprovedAmount]       
(  
@SuperbillUid UNIQUEIDENTIFIER,      
@InsType int  
)        
RETURNS MONEY        
AS      
  
/*      
Purpose: To return all or Primary diags for a procedure in DFT      
Created On: 20050928      
LastModified On: 20051003      
Modifications Made: 1. For NEO - returning Uid      
Special Comment:      
*/      
  
BEGIN      
DECLARE @MedicareApprovedAmount MONEY    
IF (@InsType>=1) 
 BEGIN
    SELECT @MedicareApprovedAmount=SUM(COALESCE(LDM.ActualAmountAllowed,LDM.OriginalAmountAllowed))
	FROM
		Superbill S
	Join 
	   Superbillprocedure SBP
	 ON
	   SBP.SuperbillUid=S.SuperbillUid
	JOIN
		AR_LedgerDetail LD
	ON
		SBP.SuperbillProcedureUid=LD.SuperbillProcedureUid 	
	JOIN
		AR_Ledger L
	ON
		L.LedgerUid=LD.LedgerUID AND (L.EntryType=1 OR L.EntryType=4)
	JOIN
	  AR_RelLedgerDetailModifier LDM
	ON
	  LDM.LedgerDetailUid=LD.LedgerDetailUid
	WHERE 
	  S.SuperbillUid=@SuperbillUid
		AND
	  LD.LiabilityOwner =@InsType
 END
ELSE    
BEGIN    
 SELECT @MedicareApprovedAmount =SUM( SP.Units * (CASE WHEN FSP.RVUScheduleuid IS NOT NULL THEN ISNULL((RSV.WorkRVU + RBNonFacilityPERVU + RSV.MPRVU),0) ELSE ISNULL(FSF.Fee,0) END))     
 FROM    
 Superbill S    
 JOIN    
 SuperbillProcedure SP    
 ON    
 S.SuperbillUid=SP.SuperbillUid    
 JOIN    
 AccountPeriod  AP    
 ON    
 S.AccountUid = AP.AccountUid  AND (AP.EffectiveDate <= S.ServiceDateStart OR AP.EffectiveDate IS NULL)    
 AND (AP.ExpirationDate >= S.ServiceDateEnd OR AP.ExpirationDate IS NULL)    
 INNER JOIN AccountInsurance AI on AP.AccountPeriodUid=AI.AccountPeriodUid AND AI.DisplayOrder = @InsType       
 INNER JOIN PersonInsurancePlan PIP on AI.PersonInsurancePlanUid=PIP.PersonInsurancePlanUid      
 INNER JOIN InsurancePlan IP on PIP.InsurancePlanUid=IP.InsurancePlanUid      
 INNER JOIN Corporation C on IP.InsuranceCarrierUid=C.CorporationUid      
 INNER JOIN InsuranceCarrier IC ON C.CorporationUid =IC.CorporationUid     
 INNER JOIN    
 FeeSchedule FS    
 ON    
 (IP.FeeScheduleUid = FS.FeeScheduleUid  AND IP.UseCarrierFeeSchedule=0)    
 OR (IC.FeeScheduleUid =FS.FeeScheduleUid AND IP.UseCarrierFeeSchedule=1)    
 INNER JOIN    
 FeeSchedulePeriod  FSP    
 ON    
 FS.FeeScheduleUid =FSP.FeeScheduleUid AND (FSP.EffectiveDate <= S.ServiceDateStart OR FSP.EffectiveDate IS NULL)    
 AND (FSP.ExpirationDate >= S.ServiceDateEnd OR FSP.ExpirationDate IS NULL)    
 LEFT JOIN    
 FeeScheduleFee FSF    
 ON    
 FSP.FeeSchedulePeriodUid = FSF.FeeSchedulePeriodUid AND SP.ProcedureUid = FSF.ProcedureUid    
 LEFT JOIN      
 RVUScheduleValue RSV      
 ON      
 FSP.RVUScheduleUID = RSV.RVUScheduleUID AND SP.Procedureuid=RSV.Procedureuid      
 WHERE S.SuperbillUid=@SuperbillUid    
END    
  
  
IF @MedicareApprovedAmount IS NULL    
set @MedicareApprovedAmount=0.0    
  
RETURN @MedicareApprovedAmount      
END      
  


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getMedicarePaidDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'-- the function returns "Date Paid By Medicare" (Item-25 in Medicaid paper claim form) in MMDDYY format  
CREATE   FUNCTION [dbo].[UDF_getMedicarePaidDate]  
(  
 @SuperbillUID UNIQUEIDENTIFIER,  
 @CurrentCarrier INT  
)  
RETURNS VARCHAR(6)  
AS  
BEGIN            
  
 DECLARE @retDate VARCHAR(6)   
 DECLARE @pDate DATETIME  
  
  SELECT @pDate = MAX(VDEP.depositdate) 
   FROM Superbill SB  
   INNER JOIN SuperbillProcedure SBP ON SB.SuperbillUid = SBP.SuperbillUid  
   INNER JOIN AR_LedgerDetail LD ON SBP.SuperbillProcedureUid = LD.SuperbillProcedureUid 
   INNER JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid and L.EntryType=2  
   Inner Join AR_Transaction T On T.SuperbillUid = SB.SuperbillUid 
   INNER JOIN ViewDeposit VDEP ON T.DepositUid = VDEP.DepositUid 
   INNER JOIN ListCreditType LCT on LCT.CreditTypeUid=LD.IncomeAccountUid AND LCT.Name Like ''%Insurance Payment%''  
   AND L.VoidLedgerUid is null and NOT L.LedgerUid IN (SELECT VoidLedgerUid FROM AR_Ledger WHERE NOT VoidLedgerUid IS NULL)   
  
   SET @retDate =  
   CASE WHEN ISNULL(@pDate,'''') <> '''' THEN  
    --[dbo].[UDF_getDate_MMDDYY] (@pDate)   
    LEFT(REPLACE(CONVERT(VARCHAR(10), @pDate, 101), ''/'', ''''), 4) + RIGHT(REPLACE(CONVERT(VARCHAR(10), @pDate, 101), ''/'', ''''), 2)  
   ELSE   
    ''''  
   END  
  RETURN @retDate   
END  
  

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getModifier]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[UDF_getModifier]
(
	@SuperbillUid UNIQUEIDENTIFIER ,
	@SuperbillProcedureUid UNIQUEIDENTIFIER ,
	@ModifierOrder INT 
)

RETURNS VARCHAR(255)
AS

BEGIN
	DECLARE @retVal VARCHAR(255)
	DECLARE @Cnt SMALLINT

	SET @Cnt = 0
	SET @retVal = ''''

	DECLARE CUR_Modifier CURSOR FOR
		SELECT 	COALESCE(NULLIF(lpm.ANSICode,''''), NULLIF(lpm.Modifier,''''), '''') AS bpmodifier 
		FROM Superbill d
		LEFT JOIN SuperBillProcedure sbp ON 
			sbp.SuperbillUid = d.SuperbillUid AND ISNULL(sbp.DontClaim,0) = 0
		LEFT JOIN SuperbillProcedureModifier sbpm ON
			sbpm.SuperbillProcedureUid = sbp.SuperbillProcedureUid
		LEFT JOIN ListProcedureModifier lpm ON
			lpm.ProcedureModifierUid = sbpm.ProcedureModifierUid
		WHERE d.Superbilluid = @SuperbillUid
			AND sbpm.SuperbillProcedureUid = @SuperbillProcedureUid
		ORDER BY sbpm.DisplayOrder
	OPEN CUR_Modifier

	FETCH NEXT FROM CUR_Modifier 
	INTO @retVal 
	WHILE @@FETCH_STATUS =0
	BEGIN
		SET @Cnt = @Cnt + 1
		IF @Cnt = @ModifierOrder
			GOTO GOEND
		ELSE
			SET @retVal = ''''
	   FETCH NEXT FROM CUR_Modifier INTO @retVal 
	END

	GOEND:	
	CLOSE CUR_Modifier 
	DEALLOCATE CUR_Modifier 
	RETURN(@retVal)
END






' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getPaidAmount]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


-- the function returns amount paid by either Primary/Secondary payer or Patient
CREATE   FUNCTION [dbo].[UDF_getPaidAmount]
(
	@SuperbillUid UNIQUEIDENTIFIER,
	@PaidBy INT	-- 0 for ''Patient'' 
				-- 1 for ''Primary Insurance''
				-- 2 for ''Secondary Insurance''
)
RETURNS MONEY
AS
BEGIN
	DECLARE @retVal MONEY 
	DECLARE @Payer nVARCHAR(10)
	SET @retVal = 0
	SET @Payer = CASE WHEN @PaidBy = 0 THEN 
							''Patient''
						ELSE
							''Insurance''
						END
						
	SELECT @retVal = ISNULL(0-sum( ISNULL(LDCredit.Amount, 0)), 0)
	FROM Superbill SB
		INNER JOIN SuperbillProcedure SBP ON SB.SuperbillUid = SBP.SuperbillUid
		INNER JOIN AR_LedgerDetail LDCredit ON SBP.SuperbillProcedureUid = LDCredit.SuperbillProcedureUid AND LDCredit.IsCredit = 1
		INNER JOIN AR_Ledger L ON LDCredit.LedgerUid = L.LedgerUid
		INNER JOIN AR_LedgerDetail LDDebit ON L.LedgerUid = LDDebit.LedgerUid AND LDDebit.IsCredit = 0
		INNER JOIN Deposit DEP ON LDDebit.DepositUid = DEP.DepositUid
		INNER JOIN ListCreditType LCT ON LDCredit.IncomeAccountUid = LCT.CreditTypeUid
	WHERE SB.SuperbillUid = @SuperbillUID 
		AND (LCT.Name LIKE @Payer + '' Payment'' ) AND LCT.IsPayment = 1
		AND LDCredit.LiabilityOwner = @PaidBy
		AND L.VoidLedgerUid is null and NOT L.LedgerUid IN (SELECT VoidLedgerUid FROM AR_Ledger WHERE NOT VoidLedgerUid IS NULL) 
	
	RETURN(@retVal)
END






' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getOtherSourceCode]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

-- the function returns the other source code, as required by Medicaid paper claims, if a part of payment has already done
CREATE   FUNCTION [dbo].[UDF_getOtherSourceCode]
(
	@SuperbillUid UNIQUEIDENTIFIER,
	@CurrentCarrier INT
)
RETURNS VARCHAR
AS
BEGIN

	DECLARE @OtherSourceCode VARCHAR(2)
	DECLARE @OtherSource VARCHAR(100)
	DECLARE @PaidAmount MONEY
	SET @OtherSourceCode = ''''
	SET @OtherSource  = ''''


	SELECT @OtherSource = lat.ExternalId
	FROM Superbill s
	INNER JOIN PersonInsurancePlan pip ON s.PatientUID = pip.PersonUID
	INNER JOIN InsurancePlan ip ON pip.InsurancePlanUID = ip.InsurancePlanUID AND ip.Inactive = 0
	INNER JOIN InsuranceCarrier ic ON ip.InsuranceCarrierUID = ic.CorporationUID
	INNER JOIN AccountInsurance ai ON pip.PersonInsurancePlanUID = ai.PersonInsurancePlanUID AND ai.DisplayOrder = 1
	LEFT JOIN ListAccountType lat ON ip.AccountTypeUID = lat.AccountTypeUID 
	WHERE s.SuperBillUID = @SuperbillUid

	SET @PaidAmount =
		CASE WHEN @OtherSource = ''09'' THEN 
			 [dbo].[UDF_getPaidAmount] (@SuperbillUid,0)	--Amount paid by patient
		ELSE
			[dbo].[UDF_getPaidAmount] (@SuperbillUid, (@CurrentCarrier - 1))	--Amount paid by previous payer
		END
	
	SET @OtherSourceCode =
		CASE WHEN @PaidAmount > 0 THEN 	--If payment is received from other source
		
			CASE WHEN @OtherSource LIKE ''09'' THEN ''1''   --self/family
			WHEN @OtherSource = ''BL'' THEN ''2''	--Blue Cross / Blue Shield
			WHEN @OtherSource = ''CI'' THEN ''3'' --Private Payer
			WHEN @OtherSource = ''WC'' THEN ''4'' 	--Employer / Union
			--WHEN @OtherSource = ''%%'' THEN ''5''		--Public
			--WHEN @OtherSource = ''%%'' THEN ''7''		--Psychiatric reduction
												--8 is not applicable for OHF
			ELSE 
			 ''6''		--Other 
			END
		--ELSE	--If payment is not received from other source
		
			--CASE WHEN  THEN

			--END
		END
	RETURN @OtherSourceCode
	
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getPastPregAnswers]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_getPastPregAnswers]
(
	@PatientHistoryUid UNIQUEIDENTIFIER ,
	@QuestionUid UNIQUEIDENTIFIER = null
)
RETURNS VARCHAR(8000)
AS
BEGIN
	DECLARE @retVal VARCHAR(255)
	DECLARE @Answer VARCHAR(255)
	DECLARE @Cnt SMALLINT
	Set @Answer = ''''
	Set @Cnt = 0
	DECLARE CUR_Answers CURSOR FOR
	SELECT AnswerName FROM PatientHistoryDetail WHERE PatientHistoryUid = @PatientHistoryUid 
				And QuestionUid = @QuestionUid
	OPEN CUR_Answers
	FETCH NEXT FROM CUR_Answers INTO @retVal 
	WHILE @@FETCH_STATUS = 0
	BEGIN		
		IF @Cnt = 0 
			Set @Answer = @retVal
		ELSE
			Set @Answer = @Answer +'';''+@retVal
		Set @Cnt = @Cnt + 1
	FETCH NEXT FROM CUR_Answers INTO @retVal 			
	END
	CLOSE CUR_Answers 
	DEALLOCATE CUR_Answers 
RETURN(@Answer)
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getPatientLabResultList]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


--DECLARE @A VARCHAR(MAX)
--SELECT @A=DBO.[UDF_getPatientLabResultList] (''A5C92A62-758F-4080-913D-0265CBCB48E7'',''4E10B5B4-262E-4138-9FAC-383A284E18A2'',''0-55'',0,''D273FB90-9738-4A7C-A101-B6FFB24D7D5A'','''',0,NULL,NULL,NULL,NULL,NULL)
--SELECT @A 
--08/04/2016 BLR ObsItemUids can come in as '''' rather than NULL. Added logic that, if this happens, to set them to NULL
CREATE  FUNCTION [dbo].[UDF_getPatientLabResultList]
(
	 @PersonUid UNIQUEIDENTIFIER = NULL
	 ,@ObservationItem1Uid varchar(max)= NULL --Modified to use observation item instead of 
	 ,@ObservationItem1Range varchar(max)
	 ,@LogicOpr1 bit=0
	 ,@ObservationItem2Uid varchar(max) = NULL --Modified to use observation item instead of 
	 ,@ObservationItem2Range varchar(max) = NULL
	 ,@LogicOpr2 bit=0
	 ,@ObservationItem3Uid varchar(max) = NULL --Modified to use observation item instead of 
	 ,@ObservationItem3Range varchar(max) = NULL
 	 ,@LabResults_StartDate datetime = NULL
	 ,@LabResults_EndDate datetime = NULL 
	 ,@LaboratoryUid varchar(max) = NULL
)
RETURNS  VARCHAR(Max)
AS 
BEGIN 
		DECLARE @LabResultList VARCHAR(Max) = ''N/A''
		IF @LaboratoryUid=''''
			SET @LaboratoryUid=NULL
		SET @LabResults_StartDate = ISNULL(@LabResults_StartDate , ''1-01-1997'')
		SET @LabResults_EndDate = ISNULL(@LabResults_EndDate, getdate())

		IF @ObservationItem1Uid = ''''
			SET @ObservationItem1Uid = NULL

		IF @ObservationItem2Uid = ''''
			SET @ObservationItem2Uid = NULL

		IF @ObservationItem3Uid = ''''
			SET @ObservationItem3Uid = NULL
				
		DECLARE @ObservationItem1Start varchar(100)
		DECLARE @ObservationItem1End varchar(100)
		
		Set @ObservationItem1Start = ''0''
		Set @ObservationItem1End = ''999''
		
		If( @ObservationItem1Range IS NOT NULL AND LEN( @ObservationItem1Range) > 0 )
		BEGIN
			select @ObservationItem1Start = Element from Split(@ObservationItem1Range,''-'') where ElementID = 1
			select @ObservationItem1End = Element from Split(@ObservationItem1Range,''-'') where ElementID = 2
		END
		
		DECLARE @ObservationItem2Start varchar(100)
		DECLARE @ObservationItem2End varchar(100)
		
		Set @ObservationItem2Start = ''0''
		Set @ObservationItem2End = ''999''
		
		If( @ObservationItem2Range IS NOT NULL AND LEN(@ObservationItem2Range) > 0 )
		BEGIN
			select @ObservationItem2Start = Element from Split(@ObservationItem2Range,''-'') where ElementID = 1
			select @ObservationItem2End = Element from Split(@ObservationItem2Range,''-'') where ElementID = 2
		END
		
		DECLARE @ObservationItem3Start varchar(100)
		DECLARE @ObservationItem3End varchar(100)
		
		If( @ObservationItem3Range IS NOT NULL AND LEN( @ObservationItem3Range) > 0 )
		BEGIN
			select @ObservationItem3Start = Element from Split(@ObservationItem3Range,''-'') where ElementID = 1
			select @ObservationItem3End = Element from Split(@ObservationItem3Range,''-'') where ElementID = 2
		END
		

		if (@ObservationItem1Uid IS NOT NULL  
			OR 
			@ObservationItem2Uid IS NOT NULL  
			OR
			@ObservationItem3Uid IS NOT NULL  
			)
		BEGIN
			DECLARE @ResultCollection TABLE (LabResult VARCHAR(1000),ObservationItemUid UNIQUEIDENTIFIER,NumericObservationValue VARCHAR(MAX))
			DECLARE @Result TABLE (Result VARCHAR(1000),ObservationItemUid UNIQUEIDENTIFIER)

			DECLARE @DisplayResult Bit
			SET @DisplayResult=0

			/* Add pre-collection table to omit any value that isn''t int or decimal to account for string or bidnary data truncation error */
			INSERT INTO @ResultCollection
			SELECT PL.LabResult,PL.ObservationItemUid, NumericObservationValue
			FROM   [MDOL_RPT2_VIEW_PatientLabResults] PL 		
			Where PL.IsDelete = 0
			AND @PersonUid = PL.PatientUid
			AND (NumericObservationValue not like ''%[^0-9]%'' OR NumericObservationValue like ''%.%'')
			AND NumericObservationValue NOT LIKE ''%[a-zA-Z]%''
			AND NumericObservationValue NOT LIKE ''%>%''
			AND NumericObservationValue NOT LIKE ''%<%''
			AND NumericObservationValue NOT LIKE ''%/%''
			AND PL.ResultDate >= @LabResults_StartDate AND PL.ResultDate < @LabResults_EndDate
			AND (@LaboratoryUid IS NULL OR PL.LaboratoryUid in (Select Element from dbo.Split(@LaboratoryUid,'','')))
			order by PL.ResultDate

			INSERT INTO @Result 
			SELECT PL.LabResult,PL.ObservationItemUid
				FROM   @ResultCollection PL 		
				Where 
					(
					PL.ObservationItemUid  in (Select element from dbo.Split (@ObservationItem1Uid,'','')) 
					AND ((IsNumeric(NumericObservationValue + ''e0'') = 1 AND CONVERT(NUMERIC,PL.NumericObservationValue)>=CONVERT(NUMERIC,@ObservationItem1Start)) OR (IsNumeric(NumericObservationValue + ''e0'') = 0 AND PL.NumericObservationValue>=@ObservationItem1Start))
					AND ((IsNumeric(NumericObservationValue + ''e0'') = 1 AND CONVERT(NUMERIC,PL.NumericObservationValue)<=CONVERT(NUMERIC,@ObservationItem1End)) OR (IsNumeric(NumericObservationValue + ''e0'') = 0 AND PL.NumericObservationValue<=@ObservationItem1End))
					)
					OR
					(
						PL.ObservationItemUid in (Select element from dbo.Split (@ObservationItem2Uid,'','')) 
					AND ((IsNumeric(NumericObservationValue + ''e0'') = 1 AND CONVERT(NUMERIC,PL.NumericObservationValue)>=CONVERT(NUMERIC,@ObservationItem2Start)) OR (IsNumeric(NumericObservationValue + ''e0'') = 0 AND PL.NumericObservationValue>=@ObservationItem2Start))
					AND ((IsNumeric(NumericObservationValue + ''e0'') = 1 AND CONVERT(NUMERIC,PL.NumericObservationValue)<=CONVERT(NUMERIC,@ObservationItem2End)) OR (IsNumeric(NumericObservationValue + ''e0'') = 0 AND PL.NumericObservationValue<=@ObservationItem2End))
					)
					OR
					(
						PL.ObservationItemUid in (Select element from dbo.Split (@ObservationItem3Uid,'','')) 
					AND ((IsNumeric(NumericObservationValue + ''e0'') = 1 AND CONVERT(NUMERIC,PL.NumericObservationValue)>=CONVERT(NUMERIC,@ObservationItem3Start)) OR (IsNumeric(NumericObservationValue + ''e0'') = 0 AND PL.NumericObservationValue>=@ObservationItem3Start))
					AND ((IsNumeric(NumericObservationValue + ''e0'') = 1 AND CONVERT(NUMERIC,PL.NumericObservationValue)<=CONVERT(NUMERIC,@ObservationItem3End)) OR (IsNumeric(NumericObservationValue + ''e0'') = 0 AND PL.NumericObservationValue<=@ObservationItem3End))
					)

			IF (@LogicOpr1 =1 AND @LogicOpr2 =1)
			BEGIN
				IF EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem1Uid,'',''))  OR @ObservationItem1Uid IS NULL) AND EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem2Uid,'',''))  OR @ObservationItem2Uid IS NULL) AND EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem3Uid,'',''))  OR @ObservationItem3Uid IS NULL)
					SET @DisplayResult=1
			END
			IF (@LogicOpr1 =1 AND @LogicOpr2 =0)
			BEGIN
				IF EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem1Uid,'',''))  OR @ObservationItem1Uid IS NULL) AND EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem2Uid,'',''))  OR @ObservationItem2Uid IS NULL) OR EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem3Uid,'',''))  OR @ObservationItem3Uid IS NULL)
					SET @DisplayResult=1
			END	
			IF (@LogicOpr1 =0 AND @LogicOpr2 =1)
			BEGIN
				IF EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem1Uid,'',''))  OR @ObservationItem1Uid IS NULL) OR EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem2Uid,'',''))  OR @ObservationItem2Uid IS NULL) AND EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem3Uid,'',''))  OR @ObservationItem3Uid IS NULL)
					SET @DisplayResult=1
			END			
			IF (@LogicOpr1 =0 AND @LogicOpr2 =0)
			BEGIN
				--IF EXISTS() OR EXISTS() OR EXISTS()
					SET @DisplayResult=1
			END		
			IF @DisplayResult=1 
			BEGIN
			SELECT @LabResultList = 
						(substring(
				
						( SELECT Result + '''' FROM @Result  FOR XML PATH( '''' )
						 ), 2, 2500 ) )	
			END	
			ELSE
				BEGIN
				SET @LabResultList=NULL
				END 
		END
		ELSE
		BEGIN
		SELECT @LabResultList = 
				(substring(
				(SELECT ( '';'' + loi.Name + '': '' + coalesce(nullif(Convert(VARCHAR(50),ISNULL(ov.ObservationValue,'''')),''''),''N/A'') + '' Resulted: '' + (Convert(VARCHAR(50),oo.ResultDate,101)))
                 FROM    ObservationOrder oo 
				 INNER JOIN ObservationValue    ov  ON ov.ObservationOrderUid = oo.ObservationOrderUid 
				 INNER JOIN ListObservationItem loi ON loi.ObservationItemUid = ov.ObservationItemUid 
				 --INNER JOIN ListLOINC           ll  ON ll.LOINCUid            = loi.LOINCUid 
				 inner join Person				PR  ON PR.PersonUid			  = oo.PatientUid			
				 where 
				    oo.IsDelete = 0
				    AND
					@PersonUid = oo.PatientUid				 
					AND					
					oo.ResultDate >= @LabResults_StartDate AND oo.ResultDate < @LabResults_EndDate
					AND
					(@LaboratoryUid IS NULL OR oo.LaboratoryUid in (Select Element from dbo.Split(@LaboratoryUid,'','')))
				 order by oo.ResultDate
				 FOR XML PATH( '''' )
				 ), 2, 2500 ) )						 
		 END									 
		RETURN @LabResultList
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getPatientLabResultListSingle]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE  FUNCTION [dbo].[UDF_getPatientLabResultListSingle]
(
	 @PersonUid UNIQUEIDENTIFIER = NULL
	 ,@ObservationItem1Uid varchar(max)= NULL --Modified to use observation item instead of 
	 ,@ObservationItem1Range varchar(max)
 	 ,@LabResults_StartDate datetime = NULL
	 ,@LabResults_EndDate datetime = NULL 
	 ,@LaboratoryUid varchar(max) = NULL
)
RETURNS  VARCHAR(Max)
AS 
BEGIN 
		DECLARE @LabResultList VARCHAR(Max) = ''N/A''
		IF @LaboratoryUid=''''
			SET @LaboratoryUid=NULL
		SET @LabResults_StartDate = ISNULL(@LabResults_StartDate , ''1-01-1997'')
		SET @LabResults_EndDate = ISNULL(@LabResults_EndDate, getdate()) 
	
		--SELECT @LabResults_StartDate = dbo.getPracticeUTCDateTime (@LabResults_StartDate)
		--SELECT @LabResults_EndDate =  DATEADD(DAY,1,dbo.getPracticeUTCDateTime(@LabResults_EndDate))
		
				
		DECLARE @ObservationItem1Start varchar(100)
		DECLARE @ObservationItem1End varchar(100)
			
		Set @ObservationItem1Start = ''0''
		Set @ObservationItem1End = ''999''
		
		If( @ObservationItem1Range IS NOT NULL AND LEN( @ObservationItem1Range) > 0 )
		BEGIN
			select @ObservationItem1Start = Element from Split(@ObservationItem1Range,''-'') where ElementID = 1
			select @ObservationItem1End = Element from Split(@ObservationItem1Range,''-'') where ElementID = 2
		END
		
		--if (@ObservationItem1Uid != ''00000000-0000-0000-0000-000000000000'' 
		--	OR 
		--	@ObservationItem2Uid != ''00000000-0000-0000-0000-000000000000''
		--	OR
		--	@ObservationItem3Uid != ''00000000-0000-0000-0000-000000000000''
		--	)
		if (@ObservationItem1Uid IS NOT NULL )
		BEGIN
			--IF (@LogicOpr1 =0 AND @LogicOpr2 =0)
			--BEGIN
			DECLARE @Result TABLE  
			(
				Result VARCHAR(1000),
				ObservationItemUid UNIQUEIDENTIFIER
			)
			DECLARE @DisplayResult Bit
			SET @DisplayResult=0
				--SELECT @LabResultList = 
				--		(substring(
				
						--(
						INSERT INTO @Result 
						SELECT PL.LabResult,PL.ObservationItemUid
						 FROM   [MDOL_RPT2_VIEW_PatientLabResults] PL 		
						 Where 
							PL.IsDelete = 0
				            AND
							@PersonUid = PL.PatientUid
							AND
							(
								PL.ObservationItemUid  in (Select element from dbo.Split (@ObservationItem1Uid,'','')) 
								AND ((IsNumeric(NumericObservationValue + ''e0'') = 1 AND CONVERT(NUMERIC,PL.NumericObservationValue)>=CONVERT(NUMERIC,@ObservationItem1Start)) OR (IsNumeric(NumericObservationValue + ''e0'') = 0 AND PL.NumericObservationValue>=@ObservationItem1Start))
								AND ((IsNumeric(NumericObservationValue + ''e0'') = 1 AND CONVERT(NUMERIC,PL.NumericObservationValue)<=CONVERT(NUMERIC,@ObservationItem1End)) OR (IsNumeric(NumericObservationValue + ''e0'') = 0 AND PL.NumericObservationValue<=@ObservationItem1End))
							)
							AND					
							PL.ResultDate >= @LabResults_StartDate AND PL.ResultDate < @LabResults_EndDate
							AND
						(@LaboratoryUid IS NULL OR PL.LaboratoryUid in (Select Element from dbo.Split(@LaboratoryUid,'','')))
						 order by PL.ResultDate
						 
						
						 --FOR XML PATH( '''' )
						 --), 2, 2500 ) )*/
						 
			--	END	

			IF EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem1Uid,'',''))) 
				SET @DisplayResult=1
				
			IF @DisplayResult=1 
			BEGIN
			SELECT @LabResultList = 
							(substring(
					
							( SELECT Result + '''' FROM @Result  FOR XML PATH( '''' )
							 ), 2, 2500 ) )	
			END	
			ELSE
				BEGIN
					SET @LabResultList=NULL
				END 
		END
		ELSE
		BEGIN --@ObservationItem1Uid IS NULL
		SELECT @LabResultList = 
				(substring(
				(SELECT ( '';'' + loi.Name + '': '' + coalesce(nullif(Convert(VARCHAR(50),ISNULL(ov.ObservationValue,'''')),''''),''N/A'') + '' Resulted: '' + (Convert(VARCHAR(50),oo.ResultDate,101)))
                 FROM    ObservationOrder oo 
				 INNER JOIN ObservationValue    ov  ON ov.ObservationOrderUid = oo.ObservationOrderUid 
				 INNER JOIN ListObservationItem loi ON loi.ObservationItemUid = ov.ObservationItemUid 
				 --INNER JOIN ListLOINC           ll  ON ll.LOINCUid            = loi.LOINCUid 
				 inner join Person				PR  ON PR.PersonUid			  = oo.PatientUid			
				 where 
				    oo.IsDelete = 0
				    AND
					@PersonUid = oo.PatientUid				 
					AND					
					oo.ResultDate >= @LabResults_StartDate AND oo.ResultDate < @LabResults_EndDate
					AND
					(@LaboratoryUid IS NULL OR oo.LaboratoryUid in (Select Element from dbo.Split(@LaboratoryUid,'','')))
				 order by oo.ResultDate
				 FOR XML PATH( '''' )
				 ), 2, 2500 ) )						 
		 END									 
		RETURN @LabResultList
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getPatientLabResultProviderList]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




--DECLARE @A VARCHAR(MAX)
--SELECT @A=DBO.[UDF_getPatientLabResultList] (''A5C92A62-758F-4080-913D-0265CBCB48E7'',''4E10B5B4-262E-4138-9FAC-383A284E18A2'',''0-55'',0,''D273FB90-9738-4A7C-A101-B6FFB24D7D5A'','''',0,NULL,NULL,NULL,NULL,NULL)
--SELECT @A 
CREATE  FUNCTION [dbo].[UDF_getPatientLabResultProviderList]
(
	 @PersonUid UNIQUEIDENTIFIER = NULL
	 ,@ObservationItem1Uid varchar(max)= NULL --Modified to use observation item instead of 
	 ,@ObservationItem1Range varchar(max)
	 ,@LogicOpr1 bit=0
	 ,@ObservationItem2Uid varchar(max) = NULL --Modified to use observation item instead of 
	 ,@ObservationItem2Range varchar(max) = NULL
	 ,@LogicOpr2 bit=0
	 ,@ObservationItem3Uid varchar(max) = NULL --Modified to use observation item instead of 
	 ,@ObservationItem3Range varchar(max) = NULL
 	 ,@LabResults_StartDate datetime = NULL
	 ,@LabResults_EndDate datetime = NULL 
	 ,@LaboratoryUid varchar(max) = NULL
)
RETURNS  VARCHAR(Max)
AS 
BEGIN 
		DECLARE @LabResultList VARCHAR(Max) = ''N/A''
		IF @LaboratoryUid=''''
			SET @LaboratoryUid=NULL
		SET @LabResults_StartDate = ISNULL(@LabResults_StartDate , ''1-01-1997'')
		SET @LabResults_EndDate = ISNULL(@LabResults_EndDate, getdate()) 
	
		--SELECT @LabResults_StartDate = dbo.getPracticeUTCDateTime (@LabResults_StartDate)
		--SELECT @LabResults_EndDate =  DATEADD(DAY,1,dbo.getPracticeUTCDateTime(@LabResults_EndDate))
		
				
		DECLARE @ObservationItem1Start varchar(100)
		DECLARE @ObservationItem1End varchar(100)
		
		Set @ObservationItem1Start = ''0''
		Set @ObservationItem1End = ''999''
		
		If( @ObservationItem1Range IS NOT NULL AND LEN( @ObservationItem1Range) > 0 )
		BEGIN
			select @ObservationItem1Start = Element from Split(@ObservationItem1Range,''-'') where ElementID = 1
			select @ObservationItem1End = Element from Split(@ObservationItem1Range,''-'') where ElementID = 2
		END
		
		DECLARE @ObservationItem2Start varchar(100)
		DECLARE @ObservationItem2End varchar(100)
		
		Set @ObservationItem2Start = ''0''
		Set @ObservationItem2End = ''999''
		
		If( @ObservationItem2Range IS NOT NULL AND LEN(@ObservationItem2Range) > 0 )
		BEGIN
			select @ObservationItem2Start = Element from Split(@ObservationItem2Range,''-'') where ElementID = 1
			select @ObservationItem2End = Element from Split(@ObservationItem2Range,''-'') where ElementID = 2
		END
		
		DECLARE @ObservationItem3Start varchar(100)
		DECLARE @ObservationItem3End varchar(100)
		
		If( @ObservationItem3Range IS NOT NULL AND LEN( @ObservationItem3Range) > 0 )
		BEGIN
			select @ObservationItem3Start = Element from Split(@ObservationItem3Range,''-'') where ElementID = 1
			select @ObservationItem3End = Element from Split(@ObservationItem3Range,''-'') where ElementID = 2
		END
		

		--if (@ObservationItem1Uid != ''00000000-0000-0000-0000-000000000000'' 
		--	OR 
		--	@ObservationItem2Uid != ''00000000-0000-0000-0000-000000000000''
		--	OR
		--	@ObservationItem3Uid != ''00000000-0000-0000-0000-000000000000''
		--	)
		if (@ObservationItem1Uid IS NOT NULL  
			OR 
			@ObservationItem2Uid IS NOT NULL  
			OR
			@ObservationItem3Uid IS NOT NULL  
			)
		BEGIN
			--IF (@LogicOpr1 =0 AND @LogicOpr2 =0)
			--BEGIN
			DECLARE @Result TABLE  
			(
				OrderProviderUid VARCHAR(1000),
				ObservationItemUid UNIQUEIDENTIFIER
			)
			DECLARE @DisplayResult Bit
			SET @DisplayResult=0
				--SELECT @LabResultList = 
				--		(substring(
				
						--(
						INSERT INTO @Result 
						SELECT OrderProviderUid,PL.ObservationItemUid
						 FROM   [MDOL_RPT2_VIEW_PatientLabResultsWithProvider] PL 		
						 Where 
							PL.IsDelete = 0
				            AND
							@PersonUid = PL.PatientUid
							AND
							(
								(
								PL.ObservationItemUid  in (Select element from dbo.Split (@ObservationItem1Uid,'','')) 
								AND PL.NumericObservationValue>=@ObservationItem1Start
								AND PL.NumericObservationValue<=@ObservationItem1End
								)
								OR
								(
									PL.ObservationItemUid in (Select element from dbo.Split (@ObservationItem2Uid,'','')) 
									AND PL.NumericObservationValue>=@ObservationItem2Start
									AND PL.NumericObservationValue<=@ObservationItem2End
									
								)
								OR
								(
									PL.ObservationItemUid in (Select element from dbo.Split (@ObservationItem3Uid,'','')) 
									AND PL.NumericObservationValue>=@ObservationItem3Start
									AND PL.NumericObservationValue<=@ObservationItem3End
							
								)
							)					 
							AND					
							PL.ResultDate >= @LabResults_StartDate AND PL.ResultDate < @LabResults_EndDate
							AND
						(@LaboratoryUid IS NULL OR PL.LaboratoryUid in (Select Element from dbo.Split(@LaboratoryUid,'','')))
						 order by PL.ResultDate
						 						
						 --FOR XML PATH( '''' )
						 --), 2, 2500 ) )*/
						 
			--	END	
			IF (@LogicOpr1 =1 AND @LogicOpr2 =1)
			BEGIN
				IF EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem1Uid,'',''))  OR @ObservationItem1Uid IS NULL) AND EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem2Uid,'',''))  OR @ObservationItem2Uid IS NULL) AND EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem3Uid,'',''))  OR @ObservationItem3Uid IS NULL)
					SET @DisplayResult=1
			END
			IF (@LogicOpr1 =1 AND @LogicOpr2 =0)
			BEGIN
				IF EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem1Uid,'',''))  OR @ObservationItem1Uid IS NULL) AND EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem2Uid,'',''))  OR @ObservationItem2Uid IS NULL) OR EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem3Uid,'',''))  OR @ObservationItem3Uid IS NULL)
					SET @DisplayResult=1
			END	
			IF (@LogicOpr1 =0 AND @LogicOpr2 =1)
			BEGIN
				IF EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem1Uid,'',''))  OR @ObservationItem1Uid IS NULL) OR EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem2Uid,'',''))  OR @ObservationItem2Uid IS NULL) AND EXISTS(SELECT * FROM @Result WHERE ObservationItemUid in (Select element from dbo.Split (@ObservationItem3Uid,'',''))  OR @ObservationItem3Uid IS NULL)
					SET @DisplayResult=1
			END			
			IF (@LogicOpr1 =0 AND @LogicOpr2 =0)
			BEGIN
				--IF EXISTS() OR EXISTS() OR EXISTS()
					SET @DisplayResult=1
			END		
			IF @DisplayResult=1 
			BEGIN
			SELECT @LabResultList = 
						(substring(			
						( SELECT OrderProviderUid + '';'' FROM @Result  FOR XML PATH( '''' )
						 ), 1, 2500 ) )	
			END	
			ELSE
				BEGIN
				SET @LabResultList=NULL
				END 
		END
		ELSE
		BEGIN
		SELECT @LabResultList = 
				(substring(
				(SELECT ( '';'' + convert(varchar(40),oo.OrderProviderUid))
                 FROM    ObservationOrder oo 
				 INNER JOIN ObservationValue    ov  ON ov.ObservationOrderUid = oo.ObservationOrderUid 
				 INNER JOIN ListObservationItem loi ON loi.ObservationItemUid = ov.ObservationItemUid 
				 --INNER JOIN ListLOINC           ll  ON ll.LOINCUid            = loi.LOINCUid 
				 inner join Person				PR  ON PR.PersonUid			  = oo.PatientUid		
				 --LEFT JOIN ViewPersonNamesSub OrderProvider WITH (NOEXPAND) ON oo.OrderProviderUid = OrderProvider.PersonUid	
				 where 
				    oo.IsDelete = 0
				    AND
					@PersonUid = oo.PatientUid				 
					AND					
					oo.ResultDate >= @LabResults_StartDate AND oo.ResultDate < @LabResults_EndDate
					AND
					(@LaboratoryUid IS NULL OR oo.LaboratoryUid in (Select Element from dbo.Split(@LaboratoryUid,'','')))
				 order by oo.ResultDate
				 FOR XML PATH( '''' )
				 ), 2, 2500 ) )						 
		 END

		 --remove trailing semicolon
		 set @LabResultList = (select case when right(@LabResultList,1) = '';'' then substring(@LabResultList,1,len(@LabResultList)-1)
							   else @LabResultList END)

		RETURN @LabResultList
END






' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getServiceCode]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE    FUNCTION [dbo].[UDF_getServiceCode]
(
	@SuperBillUID UNIQUEIDENTIFIER,
	@ServiceCount INT
)
RETURNS UNIQUEIDENTIFIER
AS
BEGIN
	DECLARE @Count INT
	DECLARE @RetValue UNIQUEIDENTIFIER
	
	DECLARE CUR_ServiceUID CURSOR FOR
		SELECT sbp.SuperBillProcedureUID 
		FROM SuperBillProcedure sbp
		INNER JOIN ListProcedure lp
		ON sbp.ProcedureUID = lp.ProcedureUID
		WHERE lp.Inactive = 0 
		AND sbp.DontClaim = 0
		AND sbp.Inactive = 0
		AND sbp.SuperBillUID = @SuperBillUID
		--AND sbp.DisplayOrder > @ServiceCount
		ORDER BY sbp.DisplayOrder
	OPEN CUR_ServiceUID 
	FETCH NEXT FROM CUR_ServiceUID INTO @RetValue
	SET @Count = 0
	WHILE @@FETCH_STATUS = 0 
		BEGIN
			SET @Count = @Count + 1
			IF @Count <> @ServiceCount
				BEGIN
					FETCH NEXT FROM CUR_ServiceUID INTO @RetValue
					
				END
			ELSE
				BEGIN
					BREAK
				END
		END

	CLOSE CUR_ServiceUID
	DEALLOCATE CUR_ServiceUID
	
	--SET @Count = @Count - 1
	IF @Count <> @ServiceCount
		BEGIN
			SET @RetValue = ''00000000-0000-0000-0000-000000000000''
		END

	RETURN @RetValue
END




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getSunday]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[UDF_getSunday]
 (@dateForSunday DATETIME,
 @isAPR INT)  

RETURNS DATETIME 
 AS  

BEGIN 
	RETURN dbo.Date_Sunday(@dateForSunday,@isAPR)
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getSuperbillProcedureModifier]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[UDF_getSuperbillProcedureModifier]
(
	@SuperbillUid UNIQUEIDENTIFIER ,
	@SuperbillProcedureUid UNIQUEIDENTIFIER
)
RETURNS VARCHAR(255)
AS
BEGIN
	DECLARE @retVal VARCHAR(255)
	SET @retVal = ''''
	SELECT @retVal = @retVal + CASE WHEN LEN (@retVal) > 0 THEN '', '' ELSE '''' END + COALESCE(lpm.ANSICode, '''')
	FROM Superbill AS sb
		LEFT JOIN SuperBillProcedure AS sbp ON sb.SuperbillUid = sbp.SuperbillUid AND COALESCE(sbp.DontClaim,0) = 0
		LEFT JOIN SuperbillProcedureModifier sbpm ON sbp.SuperbillProcedureUid = sbpm.SuperbillProcedureUid
		LEFT JOIN ListProcedureModifier lpm ON sbpm.ProcedureModifierUid = lpm.ProcedureModifierUid
	WHERE sb.Superbilluid = @SuperbillUid
		AND sbpm.SuperbillProcedureUid = @SuperbillProcedureUid
	ORDER BY sbpm.DisplayOrder
	RETURN(@retVal)
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getUPIN]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_getUPIN]
(
   @ProviderUid uniqueidentifier
)
returns Varchar(50)
BEGIN
  DECLARE @Value Varchar(50)
  SELECT @Value=ISNULL(Claimformatvalue.value,'''') FROM ClaimFormatValue 
  WHERE ProviderUid=@ProviderUid
         AND ClaimFormatValueTypeUid=''BE3AAE71-5565-4EDC-A166-3D7B688548B9''
  Return @Value
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getVisitDocumentedCPTCode]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE  FUNCTION [dbo].[UDF_getVisitDocumentedCPTCode]
(
	@VisitUid		UNIQUEIDENTIFIER,
	@PQRIMeasureUID UNIQUEIDENTIFIER
)
RETURNS  VARCHAR(Max)
AS 
BEGIN 
		DECLARE @SPCode VARCHAR(Max)
		
		SELECT -- Procedure
			@SPCode= COALESCE(@SPCode + '', '', '''') + LP.Code
		FROM
			MDOL_RPT2_VIEW_GetCodeForPQRI A
		JOIN
			ListProcedure LP
		ON
			A.ProcedureUID=LP.ProcedureUID
		WHERE 
			VisitUID=@VisitUid
		AND
			A.DocumentedCPT=1
		AND
			PQRIMeasureUID=@PQRIMeasureUID
		RETURN @SPCode
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getVisitICD9]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE  FUNCTION [dbo].[UDF_getVisitICD9]
(
	@VisitUid UNIQUEIDENTIFIER
)
RETURNS  VARCHAR(Max)
AS 
BEGIN 
		DECLARE @ICD9 VARCHAR(Max)
		
		SELECT -- Procedure
			@ICD9= COALESCE(@ICD9 + '', '', '''') + VD.Code
		FROM
			VisitDiagnosis VD
		WHERE 
			VD.VisitUID=@VisitUid
		RETURN @ICD9
END





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getVisitICD9s]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_getVisitICD9s]
(
	@PatientUid UNIQUEIDENTIFIER,
	@StartDate DATE
)
RETURNS  VARCHAR(Max)
AS 
BEGIN 
		DECLARE @ICD9 VARCHAR(Max)
		
		SELECT		@ICD9= COALESCE(@ICD9 + '', '', '''') + vd.Code
		FROM		Visit v INNER JOIN VisitDiagnosis vd ON v.VisitUid = vd.VisitUid
		WHERE		v.PatientUid = @PatientUid AND
					(v.VisitDate > @StartDate OR @StartDate IS NULL)
		ORDER BY	v.VisitDate, vd.DisplayOrder
		
		RETURN @ICD9
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getVisitProcedureCPTCode]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE  FUNCTION [dbo].[UDF_getVisitProcedureCPTCode]
(
   @VisitUid UNIQUEIDENTIFIER
)
RETURNS  VARCHAR(Max)
AS
BEGIN
      DECLARE @SPCode VARCHAR(Max)

      SELECT -- Procedure
         @SPCode= COALESCE(@SPCode + '', '', '''') + LP.Code
      FROM
         VisitProcedure A
      JOIN
         ListProcedure LP
      ON
         A.ProcedureUID=LP.ProcedureUID
      WHERE
         A.VisitUID=@VisitUid
      RETURN @SPCode
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getVisitProcedureModifier]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
--Return the Procedure Modifier



CREATE  FUNCTION [dbo].[UDF_getVisitProcedureModifier](@VisitProcedureUid UNIQUEIDENTIFIER)
RETURNS  VARCHAR(8000)


AS
BEGIN
   DECLARE @ProcedureModifier VARCHAR(8000)

   SELECT @ProcedureModifier =
      (CASE WHEN LPM1.Modifier IS NULL THEN ''''
            ELSE LPM1.Modifier
      END )
      +
      (CASE WHEN LPM2.Modifier IS NULL THEN ''''
            ELSE '','' + LPM2.Modifier
      END)
      +
      (CASE WHEN LPM3.Modifier IS NULL THEN ''''
            ELSE '', '' + LPM3.Modifier
      END )
      +
      (CASE WHEN LPM4.Modifier IS NULL THEN ''''
            ELSE '', '' + LPM4.Modifier
      END)

   FROM VisitProcedure
   Left Join ListProcedureModifier LPM1 ON VisitProcedure.ProcedureModifier1Uid = LPM1.ProcedureModifierUid
   Left Join ListProcedureModifier LPM2 ON VisitProcedure.ProcedureModifier2Uid = LPM2.ProcedureModifierUid
   Left Join ListProcedureModifier LPM3 ON VisitProcedure.ProcedureModifier3Uid = LPM3.ProcedureModifierUid
   Left Join ListProcedureModifier LPM4 ON VisitProcedure.ProcedureModifier4Uid = LPM4.ProcedureModifierUid
   WHERE VisitProcedureUid = @VisitProcedureUid

   RETURN @ProcedureModifier
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_HeightWeightRefused]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_HeightWeightRefused](@VisitUid UNIQUEIDENTIFIER) 
	RETURNS BIT 
	AS
BEGIN
	DECLARE @Refused BIT = 0

	SELECT @Refused=MAX(s.Refused)
	FROM
	(
	SELECT CASE WHEN ov.Modifier2Name = ''refused'' THEN 1 ELSE 0 END AS Refused
	FROM ObservationValue ov
	WHERE ov.VisitUid=@VisitUid
		AND ov.ObservationItemUid IN(''00000000-0000-0000-7777-100000000070'',''00000000-0000-0000-7777-100000000071'')
	) AS s

	RETURN @Refused
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_HL7_GetCSV]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[UDF_HL7_GetCSV] 
	(@ParseString VARCHAR(25))  
RETURNS VARCHAR(25) 
AS  

BEGIN 
	DECLARE @StrLen INT
	DECLARE @TempValue VARCHAR(10)

	-- Get the length of the String till first comma, reduce it by one
	SET @StrLen = CHARINDEX('','',@ParseString)
	
	IF @StrLen >= 0
	BEGIN		
		
		SET @StrLen = @StrLen - 1
		IF (@StrLen<=0)
		BEGIN
			SET @StrLen = LEN(@ParseString)
		END
		SET @TempValue = SUBSTRING(@ParseString,1,@StrLen)
	
		--Trancate the entered data from the Modifiers string
		SET @ParseString = REPLACE(@ParseString, @TempValue, '''')
	
		IF ((@ParseString IS NOT NULL ) AND (LEN(@ParseString)>0))
		BEGIN
			SET @ParseString = RIGHT(@ParseString,LEN(@ParseString)-1)
		END
	END -- End of If statement

	RETURN @TempValue + ''----'' + @ParseString
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_HL7GetDiags]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

  
  
  
  
CREATE FUNCTION [dbo].[UDF_HL7GetDiags]   
 (@VisitProcedureUid UNIQUEIDENTIFIER,  
 @VisitUid UNIQUEIDENTIFIER)    
RETURNS VARCHAR(70)  
AS  
  
/*  
Purpose: To return all or Primary diags for a procedure in DFT  
Created On: 20050928  
LastModified On: 20051003  
Modifications Made: 1. For NEO - returning Uid  
Special Comment:  
*/  
  
BEGIN  
 DECLARE @SPDiags VARCHAR(70)  
  
 IF (SELECT COUNT(*) FROM VisitDiagnosis WHERE VisitUid = @VisitUid) =  
  (SELECT COUNT(*) FROM VisitProcedureDiagnosis WHERE VisitProcedureUid = @VisitProcedureUid AND DisplayOrder <> 0)  
 BEGIN  
  SET @SPDiags =NULL  
 END  
  
 ELSE  
 BEGIN  
    
  SELECT @SPDiags =VD.Code + ''::'' + VD.Code   
  FROM VisitProcedure vp   
  LEFT JOIN VisitProcedureDiagnosis vpd ON vpd.VisitProcedureUid = vp.VisitProcedureUid    
   AND vpd.DisplayOrder = 1  
  LEFT JOIN VisitDiagnosis vd ON vd.VisitDiagnosisUid = vpd.VisitDiagnosisUid AND vd.VisitUid = vp.VisitUid  
  
  WHERE vp.VisitProcedureUid = @VisitProcedureUid  
    
 END  
  
 RETURN @SPDiags  
END  
  
  
  
  
  
  
  


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_HL7GetFT1Diagnosis]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[UDF_HL7GetFT1Diagnosis](@VisitProcedureUid UNIQUEIDENTIFIER)  
RETURNS VARCHAR(MAX) -- Bug #33408
AS  
BEGIN  
  
 DECLARE @DiagsCode VARCHAR(15)  
 DECLARE @AttachedCode VARCHAR(MAX) -- Bug #33408
  
 SET @AttachedCode =''''  
  
 DECLARE Diags_CUR CURSOR FOR   
  SELECT TOP 8 ISNULL(vd.Code10,vd.Code)	  --ld.DiagnosisCode9   
  FROM VisitProcedureDiagnosis vpd   
  INNER JOIN VisitDiagnosis vd ON vd.VisitDiagnosisUid = vpd.VisitDiagnosisUid  
  --INNER JOIN ListDiagnosis ld ON ld.DiagnosisUid = vd.DiagnosisUid  
  WHERE vpd.VisitProcedureUid = @VisitProcedureUid AND vpd.DisplayOrder <> 0  
  ORDER BY vpd.DisplayOrder  
 OPEN Diags_CUR  
  
 FETCH NEXT FROM Diags_CUR INTO @DiagsCode  
  
 WHILE @@FETCH_STATUS =0  
 BEGIN  
  IF @AttachedCode = ''''  
   SET @AttachedCode = @DiagsCode  
  ELSE  
   SET @AttachedCode = @AttachedCode + '',''  +@DiagsCode  
  
  FETCH NEXT FROM Diags_CUR INTO @DiagsCode  
 END  
  
 CLOSE Diags_CUR  
 DEALLOCATE Diags_CUR  
  
 RETURN @AttachedCode  
END ' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_HL7GetFT1Modifiers]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'




CREATE FUNCTION [dbo].[UDF_HL7GetFT1Modifiers](@VisitProcedureUid UNIQUEIDENTIFIER)
RETURNS VARCHAR(30)
AS
BEGIN
	DECLARE @AttachedMod VARCHAR(30)

	SET @AttachedMod =''''

	SELECT @AttachedMod = CASE WHEN ISNULL(lm.ANSICode,'''') <> '''' THEN lm.ANSICode + '','' 
				ELSE '''' END +
				CASE WHEN ISNULL(lm2.ANSICode,'''') <> '''' THEN lm2.ANSICode + '','' 
				ELSE '''' END + 
				CASE WHEN ISNULL(lm3.ANSICode,'''') <> '''' THEN lm3.ANSICode + '','' 
				ELSE '''' END +
				CASE WHEN ISNULL(lm4.ANSICode,'''') <> '''' THEN lm4.ANSICode 
				ELSE '''' END
		FROM VisitProcedure vp
		LEFT JOIN ListProcedureModifier  lm ON lm.ProcedureModifierUid = vp.ProcedureModifier1Uid
		LEFT JOIN ListProcedureModifier lm2 ON lm2.ProcedureModifierUid = vp.ProcedureModifier2Uid
		LEFT JOIN ListProcedureModifier lm3 ON lm3.ProcedureModifierUid = vp.ProcedureModifier3Uid
		LEFT JOIN ListProcedureModifier lm4 ON lm4.ProcedureModifierUid = vp.ProcedureModifier4Uid
		WHERE vp.VisitProcedureUid = @VisitProcedureUid

	IF RIGHT(@AttachedMod, 1) = '',''
		SET @AttachedMod = SUBSTRING(@AttachedMod, 1, LEN(@AttachedMod)-1)

	RETURN @AttachedMod
END







' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_IsSameDay]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[UDF_IsSameDay] (@dtDate1 datetime, @dtDate2 datetime)
RETURNS int AS
BEGIN
RETURN dbo.Date_SameDay(@dtDate1,@dtDate2)
END


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_matchProcCode]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_matchProcCode](
          @Code NVARCHAR(30),
          @CodeList NVARCHAR(MAX)
) 
returns bit         AS
BEGIN
--DECLARE  @Code NVARCHAR(30)
--DECLARE  @CodeList NVARCHAR(MAX)
--set @Code = '' 0001F''
--set @CodeList = ''81000, 82000-82500, 83000; 84000; 0001F''

declare @ret bit
set @ret = 0

IF ( NULLIF(@CodeList, '''') IS NOT NULL )
BEGIN
	DECLARE @T TABLE
	(
	 id INT IDENTITY(1,1), 
	 val1 NVARCHAR(MAX), 
	 val2 NVARCHAR(MAX),
	 int1 int,
	 int2 int
	)

	SET @Code = REPLACE( @Code, '' '', '''') ;
	SET @CodeList = REPLACE( @CodeList, '';'', '','' ) ;
	SET @CodeList = REPLACE( @CodeList, '' '', '''') ;
	--select @CodeList

	declare @x2 nvarchar(max)
	set @x2 =   N''<t><a>'' + REPLACE(@CodeList,'','',''</a></t><t><a>'') + ''</a></t>''
	--select @x2

	DECLARE @xml XML
	SET @xml = REPLACE(@x2, ''-'', ''</a><a>'')

	--SELECT @xml

	INSERT INTO @t(val1, val2)
		select  --T.c.query(''.'') AS result
		T.c.value(''a[1]'', ''VARCHAR(MAX)'') AS v1,
		T.c.value(''a[2]'', ''VARCHAR(MAX)'') AS v2
	from @xml.nodes(''/t'') T(c)

	UPDATE @T
		SET val2 = COALESCE(val2, val1),
			int1 = CASE WHEN (ISNUMERIC(val1)=1) THEN CONVERT(INT, val1) ELSE NULL END,
			int2 = CASE WHEN (ISNUMERIC(COALESCE(val2,val1))=1) THEN CONVERT(INT, COALESCE(val2,val1)) ELSE NULL END
	FROM @T

	--select * from @T

	IF (ISNUMERIC(@Code)=1 )
	BEGIN
		DECLARE @codeInt int
		SET @codeInt = CONVERT(INT, @Code) 

		IF EXISTS(SELECT TOP 1 id 
					FROM @T 
					WHERE int1 IS NOT NULL		
						AND @codeInt >= int1
						AND @codeInt <= int2)
		BEGIN
			SET @ret = 1
		END
	END
	ELSE
	BEGIN
		IF EXISTS( SELECT TOP 1 id 
				   FROM @T
				   WHERE ( val1 = @Code OR val2 = @Code ))
		BEGIN
			SET @ret = 1
		END
	END
END

--select @ret
RETURN @ret
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_mergeGUIDs]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
-- 2015-08-11 Bug 39137 Bug 39137: While in payment entry changing the insurance to secondary insurance repeats multiple Primary and Secondary payers
CREATE FUNCTION [dbo].[UDF_mergeGUIDs]
(
 @guid1 UNIQUEIDENTIFIER,
 @guid2 UNIQUEIDENTIFIER

)
RETURNS UNIQUEIDENTIFIER
AS
BEGIN
-- variables
declare @vb1 binary(16), @vb2 binary(16), @lo binary(8), @hi binary(8)

-- split every 8 bytes into a binary(8), which is a bigint, the largest size usable with XOR
select @vb1 = @guid1, @vb2 = @guid2

-- xor the high and low parts separately
select @hi = convert(binary(8), substring(@vb1,1,8)) ^ convert(bigint, substring(@vb2,1,8))
select @lo = convert(binary(8), substring(@vb1,9,8)) ^ convert(bigint, substring(@vb2,9,8))

-- the final result, concatenating the bytes using char(8) - binary -> uniqueidentifier
RETURN( convert(uniqueidentifier, @hi + @lo)  )
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_MinVersionPRM]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[UDF_MinVersionPRM] 
(
	@MinPRMVersion VARCHAR(20)
	,@MinPRMSeq INT
)
RETURNS BIT
AS
BEGIN
/*
	IF dbo.UDF_MinVersionPRM(''14.0.0'',603) = 1
		SELECT ''TRUE''
*/
	DECLARE @MetMinimum BIT = 0
		,@PRMVersion VARCHAR(20)
		,@PRMSeq INT

	select @PRMVersion=PRMVersion,@PRMSeq=PRMSeq
	from versionprm
	where [status] = 0
		and PRMVersion >= @MinPRMVersion

	IF (
		(@PRMVersion > @MinPRMVersion) 
		OR (
			(@PRMVersion = @MinPRMVersion)
			AND (@PRMSeq >= @MinPRMSeq)
			)
		)
	BEGIN
		SET @MetMinimum = 1
	END

	RETURN @MetMinimum

	--select TOP 1 *
	--from 
	--	(
	--	values(''14.0.0''),(''14.0.1''),(''14.1.0''),(''15.0.0''),(''15.0.1''),(''14.0.01''),(''14.01.0''),(''15.1.0''),(''15.10.0''),(''14.10.10'')
	--	) AS T(c)
	--WHERE c >= ''14.1.0''
	--order by c DESC
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_PatientTimespanVisits]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_PatientTimespanVisits] (
	@PatientUid UNIQUEIDENTIFIER
	,@StartDate DATE
	,@EndDate DATE
	,@ProviderUid UNIQUEIDENTIFIER
	,@ProviderBilling BIT = 1
)
RETURNS INT
BEGIN
	DECLARE @VisitCnt INT = 0
	DECLARE @VisitTypeStrikeOut UNIQUEIDENTIFIER = ''FB954167-9D1C-43B7-9F5B-A76260654C96''
	
	SELECT @VisitCnt = COUNT(DISTINCT v.VisitUid)
	FROM Visit v
	WHERE v.PatientUid = @PatientUid
		AND v.VisitDate BETWEEN @StartDate AND @EndDate
		AND (v.VisitTypeUid is null or v.VisitTypeUid != @VisitTypeStrikeOut)
		AND (
			(v.ProviderUid = @ProviderUid AND @ProviderBilling = 1) 
			OR (v.RenderingProviderUid = @ProviderUid AND @ProviderBilling = 0) 
			OR @ProviderUid IS NULL
			)

	RETURN @VisitCnt
END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_PayerPlanofFeeSchedule]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[UDF_PayerPlanofFeeSchedule]
(
 @corporationUID UNIQUEIDENTIFIER,
 @FeeScheduleUID UNIQUEIDENTIFIER
)
RETURNS VARCHAR(255)
AS
BEGIN
	DECLARE @retVal VARCHAR(255)
			

	SELECT @retVal = ''''

	
	BEGIN
		SELECT @retVal = @retVal + CASE WHEN LEN (@retVal) > 0 THEN '', '' ELSE '''' END + IP.name
		FROM 
				Insuranceplan AS IP
		LEFT JOIN
			Corporation C
		ON
			IP.InsuranceCarrierUID = C.CorporationUID
		
		where C.CorporationUID=@corporationUID and IP.FeeScheduleUID=@FeeScheduleUId
	END

	RETURN(@retVal)
END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_SendValue]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[UDF_SendValue]
(
  @ClaimFormatGUID UNIQUEIDENTIFIER,  
  @ExportFormatType INT, 
  @ClaimFormatOptionType INT,
  @SuperbilUid UNIQUEIDENTIFIER
)
RETURNS bit
BEGIN			
		DECLARE @IsSend  bit
		DECLARE @CNT INT
		DECLARE @start AS VARCHAR(50)
        DECLARE @end   AS VARCHAR(50)
		DECLARE @Codes AS VARCHAR(2048)	
		SET @IsSend=0

         
	IF @ExportFormatType = 1    --For Electronic Claims   				
	  BEGIN 
			IF @ClaimFormatOptionType =1  --For CLIA
			  BEGIN 			
				 SELECT  @Codes=CFO.Codes					
				 FROM ClaimFormatOption CFO LEFT JOIN ListClaimFormatOptionType LCFOT ON LCFOT.ClaimFormatOptionTypeUid = CFO.ClaimFormatOptionTypeUid
				 WHERE LCFOT.ClaimFormatOptionTypeUid=''C1242602-6CC4-475E-AEC9-E4C1A68D5E02'' AND CFO.ClaimFormatUid = @ClaimFormatGUID--''7D707B6E-A7ED-4512-BE96-351F4ABF4E32''
              END
			ELSE
           IF @ClaimFormatOptionType =2 --For Mammography Cert
             BEGIN
			    SELECT  @Codes=CFO.Codes
			    FROM ClaimFormatOption CFO LEFT JOIN ListClaimFormatOptionType LCFOT ON LCFOT.ClaimFormatOptionTypeUid = CFO.ClaimFormatOptionTypeUid
			    WHERE LCFOT.ClaimFormatOptionTypeUid= ''A085AFF1-B0D9-420B-AA4D-BA5F38B5E780'' AND CFO.ClaimFormatUid = @ClaimFormatGUID--''7D707B6E-A7ED-4512-BE96-351F4ABF4E32''
             END
      END 

    ELSE IF @ExportFormatType = 2 --For Paper Claims
          BEGIN 
			IF @ClaimFormatOptionType =1  --For CLIA
			  BEGIN 			
				 SELECT  @Codes=CFO.Codes					
				 FROM ClaimFormatOption CFO LEFT JOIN ListClaimFormatOptionType LCFOT ON LCFOT.ClaimFormatOptionTypeUid = CFO.ClaimFormatOptionTypeUid
				 -- WHERE LCFOT.ClaimFormatOptionTypeUid=''3DB4865A-5F8A-403B-8595-281333D1211B'' AND CFO.ClaimFormatUid = @ClaimFormatGUID--''7D707B6E-A7ED-4512-BE96-351F4ABF4E32''
				 -- 3DB4865A-5F8A-403B-8595-281333D1211B is for Paper CMS-1500 5010
				 -- CBE4212E-51F2-4500-AE51-E2D7A1694559 is for Paper CMS-1500
				 WHERE LCFOT.ClaimFormatOptionTypeUid in (''3DB4865A-5F8A-403B-8595-281333D1211B'',''CBE4212E-51F2-4500-AE51-E2D7A1694559'') AND CFO.ClaimFormatUid = @ClaimFormatGUID--''7D707B6E-A7ED-4512-BE96-351F4ABF4E32''

              END
			ELSE
           IF @ClaimFormatOptionType =2 --For Mammography Cert
             BEGIN
			    SELECT  @Codes=CFO.Codes
			    FROM ClaimFormatOption CFO LEFT JOIN ListClaimFormatOptionType LCFOT ON LCFOT.ClaimFormatOptionTypeUid = CFO.ClaimFormatOptionTypeUid
			    WHERE LCFOT.ClaimFormatOptionTypeUid= ''D9A7BE06-3862-4E68-915C-C95E9B6309A5'' AND CFO.ClaimFormatUid = @ClaimFormatGUID--''7D707B6E-A7ED-4512-BE96-351F4ABF4E32''
             END 
         END 
		--	      
		DECLARE @CPTCodes TABLE
			(
				CodeID	SMALLINT,  --Array index
	   			Code	   VARCHAR(50)	--Array element contents
			)

		IF @Codes IS NULL
        BEGIN
			RETURN 1
        END
		ELSE IF (CHARINDEX('';'',@Codes)<> 0 OR CHARINDEX('';'',@Codes)= 0)
        BEGIN
			INSERT INTO @CPTCodes             
					SELECT * FROM Split(@Codes,'';'')
        END
		ELSE IF (CHARINDEX('','',@Codes)<> 0 OR CHARINDEX('','',@Codes)= 0)
        BEGIN
			INSERT INTO @CPTCodes             
					SELECT * FROM Split(@Codes,'','')
        END
			--Check individual codes present in superbill	
		SELECT @CNT=count(*) FROM @CPTCodes C WHERE RTRIM(LTRIM(C.code)) IN (SELECT Code FROM listprocedure LP INNER JOIN superbillprocedure  SP ON 
				  LP.ProcedureUid=SP.ProcedureUid WHERE SP.SuperbillUid=@SuperbilUid) AND 
				  C.Code NOT LIKE ''%-%'' 
	  IF @CNT>0
	    SET @IsSend = 1
	  ELSE
	  BEGIN
			  DECLARE @CPTCode AS VARCHAR(50)
			  DECLARE @RangeCPTCodes TABLE
				(
					CodeID	SMALLINT,  --Array index
					Code	VARCHAR(50)	--Array element contents
				)

			  DECLARE @SuperbillCodes TABLE
						(							
	   						sCode	VARCHAR(50)	
						)

			  DECLARE  Cur_CodeRange CURSOR FOR
				SELECT Code FROM @CPTCodes where code like (''%-%'')
			  OPEN Cur_CodeRange 
		      
			  FETCH NEXT FROM Cur_CodeRange INTO @CPTCode		
					WHILE @@FETCH_STATUS=0
					BEGIN
						
						INSERT INTO @RangeCPTCodes 
							SELECT * FROM split(@CPTCode,''-'')
						--SELECT * FROM @RangeCPTCodes
						
                        INSERT INTO @SuperbillCodes SELECT Code 
													FROM listprocedure LP INNER JOIN superbillprocedure  SP ON LP.ProcedureUid=SP.ProcedureUid 
													WHERE SP.SuperbillUid=@SuperbilUid 
															AND SP.DontClaim = 0			-- if not sending, then don''t check

						SET @end=(SELECT TOP 1 code FROM @RangeCPTCodes ORDER BY code DESC)
                        SET @end=RTRIM(LTRIM(@end))
						SELECT @start=code FROM @RangeCPTCodes WHERE code !=@end
						SET @start=RTRIM(LTRIM(@start))

                        IF(ISNUMERIC(@start)<>0 AND ISNUMERIC(@end)<>0)
						  BEGIN 			
						   SELECT @CNT=COUNT(*) FROM @SuperbillCodes S WHERE ISNUMERIC(S.sCode)=1 
																				AND S.sCode != ''.'' -- if code is a dot then IsNumeric is 1 but can''t convert to Float
																				AND CONVERT(FLOAT, S.sCode) BETWEEN CONVERT(FLOAT,@start) AND CONVERT(FLOAT,@end) 
						 END
						ELSE IF (ISNUMERIC(@start)=0 AND ISNUMERIC(@end)=0)					
						  BEGIN
						   SELECT @CNT=COUNT(*) FROM @SuperbillCodes S WHERE S.sCode BETWEEN  @start AND @end 	
						  END

						IF @CNT>0
							 SET @IsSend=1    
					    DELETE  FROM @RangeCPTCodes
						DELETE FROM @SuperbillCodes       	         
						FETCH NEXT FROM Cur_CodeRange INTO @CPTCode
					END
			  CLOSE Cur_CodeRange
			  DEALLOCATE Cur_CodeRange  
	   END
		RETURN @IsSend

END		 ' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_TrimZeroes]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[UDF_TrimZeroes] ( @Input MONEY )
RETURNS VARCHAR(19)
AS
BEGIN
	DECLARE @z VARCHAR(19)		-- Eventual return value

	-- Remove leading and trailing zeroes
	--   1.  Cast to decimal with a precision of 3 places to right of decimal
	--   2.  Replace ALL zeroes with space character ( Assumes NO spaces will be returned in return value )
	--   3.  Trim leading ( LTRIM ) and trailing ( RTRIM ) spaces
	--   4.  Replace ( reconvert ) remaining/inner space characters back to zero
	SET @z = REPLACE(RTRIM(LTRIM(REPLACE( CAST(@Input AS DECIMAL(19,3)),  ''0'','' ''))),'' '',''0'') 

	-- Remove trailing decimal point if at end of string
	--   ( Same method as above but assume ''.'' rather than ''0''
	SET @z = REPLACE(RTRIM(REPLACE( @z,  ''.'','' '')),'' '',''.'')

	-- If everything replace then input was all zeroes so just return a ''0'' as string
	IF ( LEN(@z) = 0 ) RETURN ''0'';

	-- return calculated value
	RETURN @z
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_VisitRDADisclosureDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_VisitRDADisclosureDate] (
	@PatientUid UNIQUEIDENTIFIER
	,@VisitUid UNIQUEIDENTIFIER
	,@VisitDate DATE
	,@WithinDays INT = 1
)
RETURNS DATE
AS 
BEGIN
	DECLARE @DisclosureDate DATE = NULL
		,@MinDisclosureDate DATE = DATEADD(DAY,-1,@VisitDate)
		,@MaxDisclosureDate DATE = DATEADD(DAY,@WithinDays,@VisitDate)

	SELECT @DisclosureDate=MIN(rda.DisclosureDate)
	FROM RecordDisclosureAudit rda WITH(NOLOCK) 
	WHERE rda.DisclosureDate BETWEEN @MinDisclosureDate AND @MaxDisclosureDate
	-- JOIN on VisitUid OR PatientUid to handle bad data migration from 2014GA release to 2014PatchARC2
	-- Future entries and customers who never migrated to 2014PatchARC2 (14.0.0.561) do not need the OR
		AND (rda.PatientUid=@PatientUid	OR rda.VisitUid=@VisitUid)
		AND rda.DisclosureType in (1,    -- Complete Chart
									2,    -- Clinical Summary
									11)  -- ContinuityOfCareDocument

	RETURN @DisclosureDate
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDFCaseVisits]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
/********************************************************************************************/
/* UDFCaseVisits																			*/
/* Collates the visit dates associated with a patient case as a comma delimited string.		*/
/********************************************************************************************/
CREATE FUNCTION [dbo].[UDFCaseVisits]
(
	 @uid uniqueidentifier
)
RETURNS varchar(2000)
AS
begin

  declare @date DATETIME
  declare @dateBuilder varchar(2000)

  set @dateBuilder = ''''
  IF @uid IS NOT NULL
  BEGIN
    declare date_cursor cursor FAST_FORWARD for SELECT DISTINCT dbo.Visit.VisitDate
	  FROM dbo.PatientCase INNER JOIN dbo.Visit ON 
          dbo.PatientCase.PatientCaseUid = dbo.Visit.PatientCaseUid 
	  WHERE  dbo.PatientCase.PatientCaseUid = @uid

    open date_cursor

    fetch next from date_cursor INTO @date

    while (@@fetch_status <> -1)
    begin
      if (@@fetch_status <> -2)
      begin
        if len(@dateBuilder) > 0
        begin
          set @dateBuilder = @dateBuilder + '', ''
        end

		/* Convert date to local datetime & strip off hh:mm:ss from the date */
        set @dateBuilder = @dateBuilder + convert(varchar(11), @date, 101)

       end
     fetch next from date_cursor INTO @date
    end
    close date_cursor
    deallocate date_cursor
  END
  return @dateBuilder	
end

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDFGetProviderCLIA]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'





CREATE FUNCTION [dbo].[UDFGetProviderCLIA]
	(@ProviderUid UNIQUEIDENTIFIER)
RETURNS VARCHAR(255) AS
BEGIN

	DECLARE @CLIA VARCHAR(50)
	
	DECLARE @ClaimFormatValueTypeUid UNIQUEIDENTIFIER
	
	SELECT @ClaimFormatValueTypeUid = ClaimFormatValueTypeUid FROM ListClaimFormatValueType 
		WHERE Name LIKE  ''Clinical Laboratory Improvement Amendments (CLIA)''


	SELECT @CLIA = ISNULL(ClaimFormatValue.Value,'''') FROM ClaimFormatValue 
		WHERE ISNULL(ClaimFormatValue.ProviderUid, @ProviderUid) = @ProviderUid
		AND ClaimFormatValueTypeUid = @ClaimFormatValueTypeUid

	RETURN @CLIA
END







' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDFGetRelCCSystemSymptom]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'



CREATE FUNCTION [dbo].[UDFGetRelCCSystemSymptom] (@systemUid [uniqueidentifier], @symptomUid [uniqueidentifier]) RETURNS uniqueidentifier AS
BEGIN

DECLARE @relCCSystemSymptomUid uniqueidentifier

	IF @systemUid IS NULL
		SELECT @relCCSystemSymptomUid = rel.RelCCSystemSymptomUid
		FROM			RelCCSystemSymptom rel INNER JOIN RelCCSymptomHpiCategory hpi ON rel.RelCCSystemSymptomUid = hpi.RelCCSystemSymptomUid
		WHERE			rel.CCSymptomUid = @symptomUid
		ORDER BY		rel.DisplayOrder
	ELSE
		SELECT	@relCCSystemSymptomUid = rel.RelCCSystemSymptomUid
		FROM	RelCCSystemSymptom rel
		WHERE	rel.CCSystemUid = @systemUid AND
				rel.CCSymptomUid = @symptomUid


	RETURN @relCCSystemSymptomUid
END



' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDFPatientConditions]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


/********************************************************************************************/
/* UDFCaseVisits																			*/
/* Collates the PatientConditions associated with a patient as a comma delimited string.		*/
/********************************************************************************************/
CREATE FUNCTION [dbo].[UDFPatientConditions]
(
	 @patientUid uniqueidentifier
)
RETURNS varchar(MAX)
AS
begin

  declare @condition varchar(500)	
  declare @conditionBuilder varchar(MAX)
  set @conditionBuilder = ''''

  IF @patientUid IS NOT NULL
  BEGIN

	--Create a cursor on ListPatientCondition
	declare pc_cursor cursor FAST_FORWARD for 
	SELECT Name 
	FROM ListPatientCondition lpc
	INNER JOIN dbo.RelPatientCondition rpc ON rpc.PatientConditionUid = lpc.PatientConditionUid
	WHERE  rpc.PatientUid = @patientUid
	ORDER BY rpc.DisplayOrder asc

    open pc_cursor
    fetch next from pc_cursor INTO @condition

    while (@@fetch_status <> -1)
    begin
      if (@@fetch_status <> -2)
      begin
        if len(@condition) > 0 AND LEN(@conditionBuilder) > 0
        begin
          set @conditionBuilder = @conditionBuilder + '', ''
        end

        set @conditionBuilder = @conditionBuilder + @condition 

       end
     fetch next from pc_cursor INTO @condition
    end
    close pc_cursor
    deallocate pc_cursor
  END
  return @conditionBuilder	
end




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ufn_ProperCase]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ufn_ProperCase](@Text AS VARCHAR(8000)) 
 RETURNS VARCHAR(8000) 
 AS 
 BEGIN 
    -- declare some variables 
    DECLARE @Reset BIT; 
    DECLARE @Ret VARCHAR(8000); 
    DECLARE @i INT; 
    DECLARE @c VARCHAR(2); 
  
    -- specify reset 
    SELECT @Reset = 1, @i=1, @Ret = ''''; 
  
    IF (UPPER(@Text)=@Text Collate Latin1_General_CS_AI) 
 BEGIN 
  
 -- cycle through each character,  
 -- if non-alpha, uppercase next alpha character. 
 -- if alpha then lowercase subsequent alphas. 
 -- NON-ALPHA EXCEPTIONS ADDED TO REGEXP (eg. apostrophe) 
 WHILE (@i <= len(@Text)) 
                SELECT @c= substring(@Text,@i,1), 
                @Ret = @Ret + CASE WHEN @Reset=1 THEN UPPER(@c) ELSE LOWER(@c) END, 
                @Reset = CASE WHEN @c like ''[a-zA-Z'''']'' THEN 0 ELSE 1 END, 
                @i = @i +1 
  
 -- add a leading and trailing space to indicate word delimiters (bol & eol) 
 SET @Ret = '' '' + @Ret + '' ''; 
  
 -- Any character immediately after non-alpha is now in uppercase. 
 -- Base the following overrides/exceptions on this. 
  
 -- specify exceptions to be lowercased 
 SET @Ret = REPLACE(@Ret, '' And '', LOWER('' And '')); 
 SET @Ret = REPLACE(@Ret, '' At '', LOWER('' At '')); 
 SET @Ret = REPLACE(@Ret, '' Of '', LOWER('' Of '')); 
 SET @Ret = REPLACE(@Ret, '' The '', LOWER('' The '')); 
  
 -- specify exceptions to be uppercased 
 SET @Ret = REPLACE(@Ret, '' Bi '', UPPER('' BI ''));  -- Business Inteligence 
 SET @Ret = REPLACE(@Ret, '' Hr '', UPPER('' HR ''));  -- Human Resources 
 SET @Ret = REPLACE(@Ret, '' It '', UPPER('' IT ''));  -- Info Tech Services 
 SET @Ret = REPLACE(@Ret, '' Po '', UPPER('' PO ''));  -- PO Box
  
 -- specify exceptions to be custom cased: McDonalds, Mc Donalds 
 IF(@Ret LIKE ''% Mc%'') 
 BEGIN 
                SELECT @c = SUBSTRING(@Ret,CHARINDEX('' Mc'',@Ret)+3,1) 
 SET @Ret = REPLACE(@Ret, '' Mc''+LOWER(@c), '' Mc''+UPPER(@c)) 
 END 
  
 -- specify exceptions to be custom cased: O''Neils 
 IF(@Ret LIKE ''% O''''%'') 
 BEGIN 
                SELECT @c = SUBSTRING(@Ret,CHARINDEX('' O'''''',@Ret)+3,1) 
 SET @Ret = REPLACE(@Ret, '' O''''''+LOWER(@c), '' O''''''+UPPER(@c)) 
 END 
  
 -- specify exceptions to be custom cased: D''Artagnan 
 IF(@Ret LIKE ''% D''''%'') 
 BEGIN 
                SELECT @c = SUBSTRING(@Ret,CHARINDEX('' D'''''',@Ret)+3,1) 
 SET @Ret = REPLACE(@Ret, '' D''''''+LOWER(@c), '' D''''''+UPPER(@c)) 
 END 
  
 -- specify exceptions to be custom cased: I''Anson 
 IF(@Ret LIKE ''% I''''%'') 
 BEGIN 
                SELECT @c = SUBSTRING(@Ret,CHARINDEX('' I'''''',@Ret)+3,1) 
 SET @Ret = REPLACE(@Ret, '' I''''''+LOWER(@c), '' I''''''+UPPER(@c)) 
 END 
  
 -- remove leading and trailing spaces 
 SET @Ret = LTRIM(RTRIM(@Ret)); 
  
 END 
    ELSE 
     -- return the string unaffected if it is not in uppercase 
     SET @Ret=@Text 
  
    RETURN @Ret 
  
 END 
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[utcToCurrentDate]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[utcToCurrentDate] 
	(	
		@utcDate DATETIME,
		@inTimeZoneAdj INT,					-- the number of hours to adjust for the local timezone
		@bObserveDaylightSavings TINYINT	-- whether or not the local area observes US daylight savings time
	)  
RETURNS 
	DATETIME
AS  
BEGIN 
	RETURN	dbo.Date_UTCToLocal(@utcDate,@inTimeZoneAdj,@bObserveDaylightSavings)
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindCacheMachineOutstandingSuperbill]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ViewFindCacheMachineOutstandingSuperbill]
(
)
RETURNS @OutstandingSuperbill_TBL TABLE 
(
	[CacheMachineUid] [uniqueidentifier],
	[URL] [varchar](255),
	[Provider] [varchar](1024),
	[SuperbillCount] [INT]
)
AS
BEGIN
	DECLARE @Search_TBL TABLE
	(
		VisitDate DATETIME,
		VisitUid UNIQUEIDENTIFIER,
		PatientUid UNIQUEIDENTIFIER,
		ProviderUid UNIQUEIDENTIFIER,
		VisitProcedureCount int DEFAULT (0),
		VisitDiagnosisCount int DEFAULT (0),
		SuperbillExternalID VARCHAR (100) null,
		SuperbillCount int DEFAULT (0),
		SuperbillProcedureCount int DEFAULT (0),
		SuperbillDiagnosisCount int DEFAULT (0),
		Changes XML NULL
	)
	DECLARE @superbillStatusUid UNIQUEIDENTIFIER,
			@psuperbillStatusUid UNIQUEIDENTIFIER
	SELECT @superbillStatusUid = ''D2291C14-3F4E-4381-80A7-883C76C9499B'',
		   @psuperbillStatusUid = ''DF81BE7C-71CF-47F4-8573-733E81E30EA8''
		   
	INSERT @Search_TBL (VisitDate, VisitUid, PatientUid, ProviderUid)
	SELECT DISTINCT t.VisitDate, t.VisitUid, t.PatientUid, t.ProviderUid
	FROM Visit AS t WITH (NOLOCK) 
		INNER JOIN RelCacheMachineProvider AS t1 WITH (NOLOCK) ON t.ProviderUid = t1.ProviderUid
		INNER JOIN ListCacheMachine AS t2 ON t1.CacheMachineUid = t2.CacheMachineUid
			AND t2.Inactive = 0
		INNER JOIN Superbill AS t3 WITH (NOLOCK) ON t.VisitUid = t3.VisitUid
			AND t3.SuperbillStatusUid IN ( @superbillStatusUid, @psuperbillStatusUid)
			
	UPDATE @Search_TBL
		SET VisitProcedureCount = t1.VisitProcedureCount
	FROM @Search_TBL AS t
	CROSS APPLY
	(
		SELECT COUNT (*) AS VisitProcedureCount
		FROM VisitProcedure WITH (NOLOCK)
		WHERE VisitUid = t.VisitUid
			AND	IsPerformed = 1
			AND IsDelete = 0
	) AS t1

	UPDATE @Search_TBL
		SET VisitDiagnosisCount = t1.VisitDiagnosisCount
	FROM @Search_TBL AS t
	CROSS APPLY
	(
		SELECT COUNT (*) AS VisitDiagnosisCount
		FROM VisitDiagnosis WITH (NOLOCK)
		WHERE VisitUid = t.VisitUid
			AND IsDelete = 0
	) AS t1

	UPDATE @Search_TBL
		SET SuperbillCount = t1.SuperbillCount,
		SuperbillExternalID = t1.ExternalID
	FROM @Search_TBL AS t
	CROSS APPLY
	(
		SELECT COUNT (*) AS SuperbillCount,
			t1.ExternalID
		FROM Superbill AS t1 WITH (NOLOCK)
		WHERE t1.VisitUid = t.VisitUid
		GROUP BY t1.ExternalID
	) AS t1

	UPDATE @Search_TBL
		SET SuperbillProcedureCount = t1.SuperbillProcedureCount
	FROM @Search_TBL AS t
	CROSS APPLY
	(
		SELECT COUNT (*) AS SuperbillProcedureCount
		FROM Superbill AS t1 WITH (NOLOCK)
		INNER JOIN SuperbillProcedure AS t2 WITH (NOLOCK) ON t1.SuperbillUid = t2.SuperbillUid
		WHERE t1.VisitUid = t.VisitUid
	) AS t1

	UPDATE @Search_TBL
		SET SuperbillDiagnosisCount = t1.SuperbillDiagnosisCount
	FROM @Search_TBL AS t
	CROSS APPLY
	(
		SELECT COUNT (*) AS SuperbillDiagnosisCount
		FROM Superbill AS t1 WITH (NOLOCK)
			INNER JOIN SuperbillDiagnosis AS t2 WITH (NOLOCK) ON t1.SuperbillUid = t2.SuperbillUid
		WHERE t1.VisitUid = t.VisitUid
	) AS t1

	INSERT @OutstandingSuperbill_TBL
	SELECT t2.CacheMachineUid, t2.URL, t3.FullName AS Provider, COUNT (*) AS OutstandingSuperbill
	FROM @Search_TBL AS t
		INNER JOIN RelCacheMachineProvider AS t1 WITH (NOLOCK) ON t.ProviderUid = t1.ProviderUid
		INNER JOIN ViewFindPerson AS t3 WITH (NOLOCK) ON t1.ProviderUid = t3.PersonUid
		INNER JOIN ListCacheMachine AS t2 WITH (NOLOCK) ON t1.CacheMachineUid = t2.CacheMachineUid
			AND t2.Inactive = 0
	WHERE (t.SuperbillDiagnosisCount + t.VisitDiagnosisCount = 0 OR
		   t.SuperbillDiagnosisCount <> t.VisitDiagnosisCount OR
		   t.SuperbillProcedureCount + t.VisitProcedureCount = 0 OR
		   t.SuperbillProcedureCount <> t.VisitProcedureCount) 
	GROUP BY t2.CacheMachineUid, t2.URL, t3.FullName
	RETURN 
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindFormulary]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ViewFindFormulary](
   @medid                        INT = NULL,
   @AbbreviateCopay              BIT = 1,
   @includeFormularyAlternatives BIT = 0,
   @FormularyVendorUid           UNIQUEIDENTIFIER = NULL,
   @FormularyIdentifierUid       UNIQUEIDENTIFIER = NULL,
   @FormularyOrgUid              UNIQUEIDENTIFIER = NULL,
   @FormularyAlternativesOrgUid  UNIQUEIDENTIFIER = NULL,
   @FormularyCopayOrgUid         UNIQUEIDENTIFIER = NULL,
   @FormularyCoverageOrgUid      UNIQUEIDENTIFIER = NULL,
   @PatienteRxEligibilityUid     UNIQUEIDENTIFIER = NULL)

RETURNS
   @ReturnTable TABLE (
      DispensableUid             UNIQUEIDENTIFIER   NOT NULL PRIMARY KEY,
      MEDID                      INT,
      MNID                       INT,
      DescDisplay                VARCHAR(125),
      DescSearch                 VARCHAR(125),
      DrugName                   VARCHAR(35),
      NameTypeCode               VARCHAR(1),
      StatusCode                 VARCHAR(1),
      ObsoleteDate               VARCHAR(8),
      Strength                   VARCHAR(255),
      StrengthUnits              VARCHAR(255),
      DoseForm                   VARCHAR(255),
      Route                      VARCHAR(30),
      GenericDrugNameID          INT,
      GenericDrugName            VARCHAR(125),
      GCNSeqNo                   INT,
      FederalDEAClassCode        VARCHAR(10),
      ClassUid                   UNIQUEIDENTIFIER,
      ClassID                    INT,
      ClassDescription           VARCHAR(70),
      ExternalID                 VARCHAR(25),
      Inactive                   BIT,
      UserDefined                TINYINT,
      HICL                       INT,
      FormularyProdFormuStatName VARCHAR(100),
      PreferredSort              INT,
      FormularyProdFormuCostName VARCHAR(100),
      RelativeCostSort           INT,
      NDC                        VARCHAR(20),
      RXNORMCode                 VARCHAR(50),
      RXNORMQualifier            VARCHAR(10),
      CopayRetail                VARCHAR(MAX),
      CopayMail                  VARCHAR(MAX),
      CopaySpecialty             VARCHAR(MAX),
      CopayLongTerm              VARCHAR(MAX),
      CoverageRestrictions       VARCHAR(50),
      IsAlternative              BIT,
      DrugTypeDesc               VARCHAR(100),
      Count                      INT,
      isClassAlternative         BIT,
      isPayerExpansion           BIT)
AS
BEGIN
   ----------------------------------------------------------------------------------------------------
   -- Useful local variables                                                                         --
   ----------------------------------------------------------------------------------------------------
   DECLARE
      @NonReimbursableUid        UNIQUEIDENTIFIER,
      @UnknownUid                UNIQUEIDENTIFIER,
      @AnyUid                    UNIQUEIDENTIFIER,
      @DispensableUid            UNIQUEIDENTIFIER,
      @tMNID                     INT,
      @PharmacyEligible          BIT,
      @MailOrderEligible         BIT

   SELECT @NonReimbursableUid = sts.FormularyProdFormuStatUid
   FROM dbo.ListFormularyProdFormuStat sts (NOLOCK)
   WHERE FormularyVendorUid = ''00000000-0000-0000-0000-000000000002''
     AND (ISNUMERIC([FormularyStatus]) <> 0 AND CAST ([FormularyStatus] AS [int]) = 0)

   SELECT @UnknownUid = sts.FormularyProdFormuStatUid
   FROM dbo.ListFormularyProdFormuStat sts (NOLOCK)
   WHERE FormularyVendorUid = ''00000000-0000-0000-0000-000000000002''
     AND FormularyStatus = ''U''

   SELECT @AnyUid = sts.FormularyProdFormuStatUid
   FROM dbo.ListFormularyProdFormuStat sts (NOLOCK)
   WHERE FormularyVendorUid = ''00000000-0000-0000-0000-000000000002''
     AND FormularyStatus = ''A''

   SELECT
      @DispensableUid = dis.DispensableUid,
      @tMNID          = dis.MNID
   FROM dbo.fdb_dispensable dis
   WHERE dis.medid = @medid

   SELECT
      @PharmacyEligible    = pel.PharmacyEligible,
      @MailOrderEligible   = pel.MailOrderEligible
   FROM PatienteRxEligibility pel
   WHERE pel.PatienteRxEligibilityUid = @PatienteRxEligibilityUid

   ----------------------------------------------------------------------------------------------------
   -- table to hold dispensable drugs                                                                --
   ----------------------------------------------------------------------------------------------------
   DECLARE @ViewFindDispensable TABLE(
      DispensableUid             UNIQUEIDENTIFIER  NOT NULL PRIMARY KEY CLUSTERED,
      medid                      INT               NULL,
      DescDisplay                VARCHAR(125)      NULL,
      nametypecode               VARCHAR(1)        NULL,
      refgenericdrugnamecode     VARCHAR(1)        NULL,
      reffederallegendcode       VARCHAR(1)        NULL,
      refmultisourcecode         VARCHAR(1)        NULL,
      statuscode                 VARCHAR(1)        NULL,
      medicaldeviceind           VARCHAR(1)        NULL,
      Count                      INT               DEFAULT(0),
      isClassAlternative         BIT               NOT NULL DEFAULT(0),
      isPayerExpansion           BIT               NOT NULL DEFAULT(0),
      DrugNameUid                UNIQUEIDENTIFIER  NULL,
      FormularyProdFormuStatUid  UNIQUEIDENTIFIER  NULL,
      FormularyProdCostIndexUid  UNIQUEIDENTIFIER  NULL,
      AlternativesSort           INT               NOT NULL DEFAULT(0),
      CopayRetail                VARCHAR(MAX)      NULL,
      CopayMail                  VARCHAR(MAX)      NULL,
      CopaySpecialty             VARCHAR(MAX)      NULL,
      CopayLongTerm              VARCHAR(MAX)      NULL,
      CoverageRestrictions       VARCHAR(50)       NOT NULL DEFAULT(''''))

   INSERT INTO @ViewFindDispensable(DispensableUid, medid, DescDisplay, nametypecode, refgenericdrugnamecode, reffederallegendcode, refmultisourcecode, statuscode, medicaldeviceind)
   SELECT
      DispensableUid          = dis.DispensableUid,
      medid                   = dis.medid,
      DescDisplay             = dis.DescDisplay,
      nametypecode            = dis.nametypecode,
      refgenericdrugnamecode  = dis.refgenericdrugnamecode,
      reffederallegendcode    = dis.reffederallegendcode,
      refmultisourcecode      = dis.refmultisourcecode,
      statuscode              = dis.statuscode,
      medicaldeviceind        = dis.medicaldeviceind
   FROM dbo.fdb_dispensable dis
   WHERE dis.medid = @medid

   ----------------------------------------------------------------------------------------------------
   -- formulary suggested alternatives                                                               --
   ----------------------------------------------------------------------------------------------------
   INSERT INTO @ViewFindDispensable(DispensableUid, medid, DescDisplay, nametypecode, refgenericdrugnamecode, reffederallegendcode, refmultisourcecode, statuscode, medicaldeviceind, DrugNameUid, AlternativesSort)
   SELECT DISTINCT
      DispensableUid          = dis.DispensableUid,
      medid                   = dis.medid,
      DescDisplay             = dis.DescDisplay,
      nametypecode            = dis.nametypecode,
      refgenericdrugnamecode  = dis.refgenericdrugnamecode,
      reffederallegendcode    = dis.reffederallegendcode,
      refmultisourcecode      = dis.refmultisourcecode,
      statuscode              = dis.statuscode,
      medicaldeviceind        = dis.medicaldeviceind,
      DrugNameUid             = dis.DrugNameUid,
      AlternativesSort        = fst.PreferredSort + 1000
   FROM dbo.FormularyAlternativesNDC alt (NOLOCK)
   INNER JOIN dbo.ListFormularyProdFormuStat fst (NOLOCK) ON fst.FormularyProdFormuStatUid = alt.FormularyProdFormuStatUid
   INNER JOIN @ViewFindDispensable vfd ON vfd.medid = alt.medid
   INNER JOIN dbo.fdb_dispensable dis ON dis.medid = alt.Alternative_medid
   WHERE alt.FormularyAlternativesOrgUid = @FormularyAlternativesOrgUid
     AND dis.DispensableUid NOT IN(SELECT tab.DispensableUid FROM @ViewFindDispensable tab)

   -- get list of DispensableUids of interest
   DECLARE @DrugName TABLE(DrugNameUid UNIQUEIDENTIFIER NOT NULL PRIMARY KEY CLUSTERED)
   INSERT INTO @DrugName(DrugNameUid)
   SELECT DISTINCT vfd.DrugNameUid
   FROM @ViewFindDispensable vfd
   WHERE vfd.medid != @medid
     AND vfd.DrugNameUid IS NOT NULL

   -- fan out to all drugs of the same name
   INSERT INTO @ViewFindDispensable(DispensableUid, medid, DescDisplay, nametypecode, refgenericdrugnamecode, reffederallegendcode, refmultisourcecode, statuscode, medicaldeviceind, isPayerExpansion)
   SELECT DISTINCT
      DispensableUid          = dis.DispensableUid,
      medid                   = dis.medid,
      DescDisplay             = dis.DescDisplay,
      nametypecode            = dis.nametypecode,
      refgenericdrugnamecode  = dis.refgenericdrugnamecode,
      reffederallegendcode    = dis.reffederallegendcode,
      refmultisourcecode      = dis.refmultisourcecode,
      statuscode              = dis.statuscode,
      medicaldeviceind        = dis.medicaldeviceind,
      isPayerExpansion        = 1
   FROM @DrugName alt
   INNER JOIN dbo.fdb_dispensable dis ON dis.DrugNameUid = alt.DrugNameUid
   WHERE dis.Inactive = 0
     AND dis.obsoletedate IS NULL
     AND dis.statuscode = ''0''
     AND dis.DispensableUid NOT IN(SELECT tab.DispensableUid FROM @ViewFindDispensable tab)
   ORDER BY dis.descdisplay

   ----------------------------------------------------------------------------------------------------
   -- therapeutic alternatives                                                                       --
   ----------------------------------------------------------------------------------------------------
   INSERT INTO @ViewFindDispensable(DispensableUid, medid, DescDisplay, nametypecode, refgenericdrugnamecode, reffederallegendcode, refmultisourcecode, statuscode, medicaldeviceind, isClassAlternative)
   SELECT DISTINCT
      DispensableUid          = dis.DispensableUid,
      medid                   = dis.medid,
      DescDisplay             = dis.DescDisplay,
      nametypecode            = dis.nametypecode,
      refgenericdrugnamecode  = dis.refgenericdrugnamecode,
      reffederallegendcode    = dis.reffederallegendcode,
      refmultisourcecode      = dis.refmultisourcecode,
      statuscode              = dis.statuscode,
      medicaldeviceind        = dis.medicaldeviceind,
      isClassAlternative      = 1
   FROM dbo.fdb_dispensable dis
   INNER JOIN dbo.fdb_etclassification_drugs etx ON etx.conceptid = @tMNID
                                                AND etx.concepttype = 1
                                                AND etx.classid <> 1130 -- don''t allow bulk chemicals bug #15969
   INNER JOIN dbo.fdb_etclassification_drugs etc ON etc.conceptid = dis.MNID
                                                AND etc.concepttype = 1
                                                AND etc.classid <> 1130 -- don''t allow bulk chemicals bug #15969
                                                AND etc.classid = etx.classid
   WHERE @DispensableUid != dis.DispensableUid
     AND dis.Inactive = 0
     AND dis.obsoletedate IS NULL
     AND dis.statuscode = ''0''
     AND dis.DispensableUid NOT IN(SELECT tab.DispensableUid FROM @ViewFindDispensable tab)
     AND dis.medid IN(SELECT medid FROM fdb_packageddrug pkg WHERE pkg.medid = dis.medid)
   ORDER BY dis.descdisplay

   ----------------------------------------------------------------------------------------------------
   -- formulary status                                                                               --
   ----------------------------------------------------------------------------------------------------
   UPDATE @ViewFindDispensable
   SET
      FormularyProdCostIndexUid  = frm.FormularyProdCostIndexUid,
      FormularyProdFormuStatUid  = CASE
                                      -- drug exclusion
                                      WHEN cvg.CoverageListType = ''DE'' THEN @NonReimbursableUid

                                      -- ndc specific
                                      WHEN frm.FormularyProdFormuStatUid IS NOT NULL THEN frm.FormularyProdFormuStatUid

                                      -- not in package database
                                      WHEN NOT EXISTS(SELECT TOP 1 * FROM fdb_packageddrug pkg WHERE pkg.medid = vfd.medid) THEN @UnknownUid

                                      -- summary level
                                      WHEN vfd.refgenericdrugnamecode = ''0''                                                                       THEN org.UnlistedSuppliesFormularyStatusUid
                                      WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''1'' AND vfd.reffederallegendcode IN(''2'', ''3'') THEN org.UnlistedBrandOTCFormularyStatusUid
                                      WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''2'' AND vfd.reffederallegendcode IN(''2'', ''3'') THEN org.UnlistedGenericOTCFormularyStatusUid
                                      WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''1''                                           THEN org.UnlistedBrandFormularyStatusUid
                                      WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''2''                                           THEN org.UnlistedGenericFormularyStatusUid
                                   END
   FROM @ViewFindDispensable vfd
   LEFT JOIN dbo.FormularyOrg org (NOLOCK) ON org.FormularyIdentifierUid = @FormularyIdentifierUid
   LEFT JOIN dbo.FormularyProductNDC frm (NOLOCK) ON frm.FormularyIdentifierUid = @FormularyIdentifierUid
                                                 AND frm.medid = vfd.medid
   LEFT JOIN dbo.FormularyCoverageNDC cvg (NOLOCK) ON cvg.FormularyCoverageOrgUid = @FormularyCoverageOrgUid
                                                  AND cvg.medid = vfd.medid
                                                  AND cvg.CoverageListType = ''DE''


   -- remove alternatives that are not on formulary
   DELETE @ViewFindDispensable
   FROM @ViewFindDispensable vfd
   INNER JOIN dbo.ListFormularyProdFormuStat fst (NOLOCK) ON fst.FormularyProdFormuStatUid = vfd.FormularyProdFormuStatUid
   WHERE vfd.isClassAlternative != 0
     AND ISNULL(fst.PreferredSort, 0) < 2

   ----------------------------------------------------------------------------------------------------
   -- copay retail                                                                                   --
   ----------------------------------------------------------------------------------------------------
   IF (@PharmacyEligible = 0)
      BEGIN
         UPDATE @ViewFindDispensable SET CopayRetail = ''Not Eligible''
      END
   ELSE
      BEGIN
         -- summary level
         UPDATE @ViewFindDispensable
         SET CopayRetail    = ISNULL(cop.Description, dbo.FormularyCopayDescription(cop.FlatCopayAmount, cop.PercentCopayRate, cop.FirstCopayTerm, cop.MinimumCopay, cop.MaximumCopay, cop.DaysSupplyPerCopay, cop.CopayTier, cop.MaximumCopayTier, cop.OutOfPocketRangeStart, cop.OutOfPocketRangeEnd))
         FROM @ViewFindDispensable vfd
         INNER JOIN dbo.FormularyCopaySummary cop (NOLOCK) ON cop.FormularyCopayOrgUid = @FormularyCopayOrgUid
                                                 AND cop.FormularyProdFormuStatUid IN(vfd.FormularyProdFormuStatUid, @AnyUid)
                                                 AND cop.PharmacyType IN(''R'',''A'','' '')
                                                 AND CASE cop.ProductType
                                                        WHEN ''0'' THEN 1                         -- Not Specified
                                                        WHEN ''1'' THEN CASE WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''1'' AND vfd.refmultisourcecode = ''2'' THEN 1 ELSE 0 END       -- Single Source Brand
                                                        WHEN ''2'' THEN CASE WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''1'' THEN 1 ELSE 0 END                                        -- Brand
                                                        WHEN ''3'' THEN CASE WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''2'' THEN 1 ELSE 0 END                                        -- Generic
                                                        WHEN ''4'' THEN CASE WHEN vfd.reffederallegendcode IN(''2'', ''3'') THEN 1 ELSE 0 END                                                               -- OTC
                                                        WHEN ''5'' THEN 0                                                                                                                               -- Compound
                                                        WHEN ''6'' THEN CASE WHEN vfd.refgenericdrugnamecode = ''0'' THEN 1 ELSE 0 END                                                                    -- Supply
                                                        WHEN ''7'' THEN CASE WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''1'' AND vfd.refmultisourcecode IN(''1'',''3'') THEN 1 ELSE 0 END -- Multi Source Brand
                                                        WHEN ''A'' THEN 1                                                                                                                               -- Any
                                                        WHEN '' '' THEN 1                                                                                                                               -- Any
                                                     END = 1

         -- ndc specific
         UPDATE @ViewFindDispensable
         SET CopayRetail    = ISNULL(cop.Description, dbo.FormularyCopayDescription(cop.FlatCopayAmount, cop.PercentCopayRate, cop.FirstCopayTerm, cop.MinimumCopay, cop.MaximumCopay, cop.DaysSupplyPerCopay, cop.CopayTier, cop.MaximumCopayTier,NULL,NULL))
         FROM @ViewFindDispensable vfd
         INNER JOIN dbo.FormularyCopayNDC cop (NOLOCK) ON cop.FormularyCopayOrgUid = @FormularyCopayOrgUid
                                             AND cop.medid = vfd.medid
                                             AND cop.PharmacyType IN(''R'',''A'','' '')
      END

   ----------------------------------------------------------------------------------------------------
   -- copay mail                                                                                     --
   ----------------------------------------------------------------------------------------------------
   IF (@MailOrderEligible = 0)
      BEGIN
         UPDATE @ViewFindDispensable SET CopayMail = ''Not Eligible''
      END
   ELSE
      BEGIN
         -- summary level
         UPDATE @ViewFindDispensable
         SET CopayMail      = ISNULL(cop.Description, dbo.FormularyCopayDescription(cop.FlatCopayAmount, cop.PercentCopayRate, cop.FirstCopayTerm, cop.MinimumCopay, cop.MaximumCopay, cop.DaysSupplyPerCopay, cop.CopayTier, cop.MaximumCopayTier, cop.OutOfPocketRangeStart, cop.OutOfPocketRangeEnd))
         FROM @ViewFindDispensable vfd
         INNER JOIN dbo.FormularyCopaySummary cop (NOLOCK) ON cop.FormularyCopayOrgUid = @FormularyCopayOrgUid
                                                 AND cop.FormularyProdFormuStatUid IN(vfd.FormularyProdFormuStatUid, @AnyUid)
                                                 AND cop.PharmacyType IN(''M'',''A'','' '')
                                                 AND CASE cop.ProductType
                                                        WHEN ''0'' THEN 1  -- Not Specified
                                                        WHEN ''1'' THEN CASE WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''1'' AND vfd.refmultisourcecode = ''2'' THEN 1 ELSE 0 END -- Single Source Brand
                                                        WHEN ''2'' THEN CASE WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''1'' THEN 1 ELSE 0 END                                        -- Brand
                                                        WHEN ''3'' THEN CASE WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''2'' THEN 1 ELSE 0 END                                        -- Generic
                                                        WHEN ''4'' THEN CASE WHEN vfd.reffederallegendcode IN(''2'', ''3'') THEN 1 ELSE 0 END                                                               -- OTC
                                                        WHEN ''5'' THEN 0                                                                                                                               -- Compound
                                                        WHEN ''6'' THEN CASE WHEN vfd.refgenericdrugnamecode = ''0'' THEN 1 ELSE 0 END                                                                    -- Supply
                                                        WHEN ''7'' THEN CASE WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''1'' AND vfd.refmultisourcecode IN(''1'',''3'') THEN 1 ELSE 0 END -- Multi Source Brand
                                                        WHEN ''A'' THEN 1                                                                                                                               -- Any
                                                        WHEN '' '' THEN 1                                                                                                                               -- Any
                                                     END = 1
         -- ndc specific
         UPDATE @ViewFindDispensable
         SET CopayMail      = ISNULL(cop.Description, dbo.FormularyCopayDescription(cop.FlatCopayAmount, cop.PercentCopayRate, cop.FirstCopayTerm, cop.MinimumCopay, cop.MaximumCopay, cop.DaysSupplyPerCopay, cop.CopayTier, cop.MaximumCopayTier,NULL,NULL))
         FROM @ViewFindDispensable vfd
         INNER JOIN dbo.FormularyCopayNDC cop (NOLOCK) ON cop.FormularyCopayOrgUid = @FormularyCopayOrgUid
                                             AND cop.medid = vfd.medid
                                             AND cop.PharmacyType IN(''M'',''A'','' '')
      END

   ----------------------------------------------------------------------------------------------------
   -- copay specialty                                                                                --
   ----------------------------------------------------------------------------------------------------
   -- summary level
   UPDATE @ViewFindDispensable
   SET CopaySpecialty = ISNULL(cop.Description, dbo.FormularyCopayDescription(cop.FlatCopayAmount, cop.PercentCopayRate, cop.FirstCopayTerm, cop.MinimumCopay, cop.MaximumCopay, cop.DaysSupplyPerCopay, cop.CopayTier, cop.MaximumCopayTier, cop.OutOfPocketRangeStart, cop.OutOfPocketRangeEnd))
   FROM @ViewFindDispensable vfd
   INNER JOIN dbo.FormularyCopaySummary cop (NOLOCK) ON cop.FormularyCopayOrgUid = @FormularyCopayOrgUid
                                           AND cop.FormularyProdFormuStatUid IN(vfd.FormularyProdFormuStatUid, @AnyUid)
                                           AND cop.PharmacyType IN(''S'',''A'','' '')
                                           AND CASE cop.ProductType
                                                  WHEN ''0'' THEN 1                                                                                                                               -- Not Specified
                                                  WHEN ''1'' THEN CASE WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''1'' AND vfd.refmultisourcecode = ''2'' THEN 1 ELSE 0 END       -- Single Source Brand
                                                  WHEN ''2'' THEN CASE WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''1'' THEN 1 ELSE 0 END       -- Brand
                                                  WHEN ''3'' THEN CASE WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''2'' THEN 1 ELSE 0 END                                        -- Generic
                                                  WHEN ''4'' THEN CASE WHEN vfd.reffederallegendcode IN(''2'', ''3'') THEN 1 ELSE 0 END                                                               -- OTC
                                                  WHEN ''5'' THEN 0                                                                                                                               -- Compound
                                                  WHEN ''6'' THEN CASE WHEN vfd.refgenericdrugnamecode = ''0'' THEN 1 ELSE 0 END                                                                    -- Supply
                                                  WHEN ''7'' THEN CASE WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''1'' AND vfd.refmultisourcecode IN(''1'',''3'') THEN 1 ELSE 0 END -- Multi Source Brand
                                                  WHEN ''A'' THEN 1                                                                                                                               -- Any
                                                  WHEN '' '' THEN 1                                                                                                                               -- Any
                                               END = 1
   -- ndc specific
   UPDATE @ViewFindDispensable
   SET CopaySpecialty = ISNULL(cop.Description, dbo.FormularyCopayDescription(cop.FlatCopayAmount, cop.PercentCopayRate, cop.FirstCopayTerm, cop.MinimumCopay, cop.MaximumCopay, cop.DaysSupplyPerCopay, cop.CopayTier, cop.MaximumCopayTier,NULL,NULL))
   FROM @ViewFindDispensable vfd
   INNER JOIN dbo.FormularyCopayNDC cop (NOLOCK) ON cop.FormularyCopayOrgUid = @FormularyCopayOrgUid
                                       AND cop.medid = vfd.medid
                                       AND cop.PharmacyType IN(''S'',''A'','' '')

   ----------------------------------------------------------------------------------------------------
   -- copay longterm                                                                                 --
   ----------------------------------------------------------------------------------------------------
   -- summary level
   UPDATE @ViewFindDispensable
   SET CopaySpecialty = ISNULL(cop.Description, dbo.FormularyCopayDescription(cop.FlatCopayAmount, cop.PercentCopayRate, cop.FirstCopayTerm, cop.MinimumCopay, cop.MaximumCopay, cop.DaysSupplyPerCopay, cop.CopayTier, cop.MaximumCopayTier, cop.OutOfPocketRangeStart, cop.OutOfPocketRangeEnd))
   FROM @ViewFindDispensable vfd
   INNER JOIN dbo.FormularyCopaySummary cop (NOLOCK) ON cop.FormularyCopayOrgUid = @FormularyCopayOrgUid
                                           AND cop.FormularyProdFormuStatUid IN(vfd.FormularyProdFormuStatUid, @AnyUid)
                                           AND cop.PharmacyType IN(''L'',''A'','' '')
                                           AND CASE cop.ProductType
                                                  WHEN ''0'' THEN 1                                                                                                                               -- Not Specified
                                                  WHEN ''1'' THEN CASE WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''1'' AND vfd.refmultisourcecode = ''2'' THEN 1 ELSE 0 END       -- Single Source Brand
                                                  WHEN ''2'' THEN CASE WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''1'' THEN 1 ELSE 0 END          -- Brand
                                                  WHEN ''3'' THEN CASE WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''2'' THEN 1 ELSE 0 END                                        -- Generic
                                                  WHEN ''4'' THEN CASE WHEN vfd.reffederallegendcode IN(''2'', ''3'') THEN 1 ELSE 0 END                                                               -- OTC
                                                  WHEN ''5'' THEN 0                                                                                                                               -- Compound
                                                  WHEN ''6'' THEN CASE WHEN vfd.refgenericdrugnamecode = ''0'' THEN 1 ELSE 0 END                                                                    -- Supply
                                                  WHEN ''7'' THEN CASE WHEN vfd.refgenericdrugnamecode != ''0'' AND vfd.nametypecode = ''1'' AND vfd.refmultisourcecode IN(''1'',''3'') THEN 1 ELSE 0 END -- Multi Source Brand
                                                  WHEN ''A'' THEN 1                                                                                                                               -- Any
                                                  WHEN '' '' THEN 1                                                                                                                               -- Any
                                               END = 1

   -- copay ndc specific long term
   UPDATE @ViewFindDispensable
   SET CopayLongTerm  = ISNULL(cop.Description, dbo.FormularyCopayDescription(cop.FlatCopayAmount, cop.PercentCopayRate, cop.FirstCopayTerm, cop.MinimumCopay, cop.MaximumCopay, cop.DaysSupplyPerCopay, cop.CopayTier, cop.MaximumCopayTier,NULL,NULL))
   FROM @ViewFindDispensable vfd
   INNER JOIN dbo.FormularyCopayNDC cop (NOLOCK) ON cop.FormularyCopayOrgUid = @FormularyCopayOrgUid
                                       AND cop.medid = vfd.medid
                                       AND cop.PharmacyType IN(''L'',''A'','' '')

   ----------------------------------------------------------------------------------------------------
   -- return the table                                                                               --
   ----------------------------------------------------------------------------------------------------
   INSERT INTO @ReturnTable(
      DispensableUid,
      MEDID,
      MNID,
      DescDisplay,
      DescSearch,
      DrugName,
      NameTypeCode,
      StatusCode,
      ObsoleteDate,
      Strength,
      StrengthUnits,
      DoseForm,
      Route,
      GenericDrugNameID,
      GenericDrugName,
      GCNSeqNo,
      FederalDEAClassCode,
      ClassUid,
      ClassID,
      ClassDescription,
      ExternalID,
      Inactive,
      UserDefined,
      HICL,
      FormularyProdFormuStatName,
      PreferredSort,
      FormularyProdFormuCostName,
      RelativeCostSort,
      NDC,
      RXNORMCode,
      RXNORMQualifier,
      CopayRetail,
      CopayMail,
      CopaySpecialty,
      CopayLongTerm,
      CoverageRestrictions,
      IsAlternative,
      DrugTypeDesc,
      Count,
      isClassAlternative,
      isPayerExpansion)
   SELECT
      DispensableUid             = vfd.DispensableUid,
      MEDID                      = vfd.medid,
      MNID                       = dis.mnid,
      DescDisplay                = dis.descdisplay,
      DescSearch                 = dis.descsearch,
      DrugName                   = nam.descdisplay,
      NameTypeCode               = vfd.nametypecode,
      StatusCode                 = ISNULL(vfd.statuscode, ''0''),
      ObsoleteDate               = dis.obsoletedate,
      Strength                   = dis.strength,
      StrengthUnits              = dis.strengthunits,
      DoseForm                   = dos.description,
      Route                      = rte.description1,
      GenericDrugNameID          = dis.genericmnid,
      GenericDrugName            = gen.descdisplay,
      GCNSeqNo                   = dis.gcnseqno,
      FederalDEAClassCode        = dea.federaldeaclasscode,
      ClassUid                   = cls.ClassUid,
      ClassID                    = cls.classid,
      ClassDescription           = cls.description1,
      ExternalID                 = dis.ExternalID,
      Inactive                   = dis.Inactive,
      UserDefined                = dis.UserDefined,
      HICL                       = dis.hicl,
      FormularyProdFormuStatName = fst.Name,
      PreferredSort              = CASE WHEN AlternativesSort > 0 THEN vfd.AlternativesSort ELSE ISNULL(fst.PreferredSort, -1) END,
      FormularyProdFormuCostName = CASE
                                      WHEN vfd.FormularyProdFormuStatUid = @NonReimbursableUid THEN NULL
                                      WHEN vfd.FormularyProdFormuStatUid = @UnknownUid         THEN NULL
                                      ELSE cst.Name
                                   END,
      RelativeCostSort           = CASE
                                      WHEN vfd.FormularyProdFormuStatUid = @NonReimbursableUid  THEN -1
                                      WHEN vfd.FormularyProdFormuStatUid = @UnknownUid          THEN -1
                                      WHEN cst.RelativeCostSort IS NULL                         THEN -1
                                      ELSE cst.RelativeCostSort
                                   END,
      NDC                        = pkg.pmid,
      RXNORMCode                 = rxf.RXNORMCode,
      RXNORMQualifier            = rxf.RXNORMQualifier,
      CopayRetail                = CASE WHEN vfd.CopayRetail    = '''' THEN NULL ELSE vfd.CopayRetail    END,
      CopayMail                  = CASE WHEN vfd.CopayMail      = '''' THEN NULL ELSE vfd.CopayMail      END,
      CopaySpecialty             = CASE WHEN vfd.CopaySpecialty = '''' THEN NULL ELSE vfd.CopaySpecialty END,
      CopayLongTerm              = CASE WHEN vfd.CopayLongTerm  = '''' THEN NULL ELSE vfd.CopayLongTerm  END,
      CoverageRestrictions       = vfr.Restrictions,
      IsAlternative              = CASE WHEN dis.medid = @medid THEN 0 ELSE 1 END,
      DrugTypeDesc               = dbo.DispensableDrugTypeDesc(dis.medid, pkg.pmid, dea.federaldeaclasscode, dis.nametypecode, dis.refmultisourcecode, dis.reffederallegendcode, dis.medicaldeviceind, dis.refgenericdrugnamecode),
      Count                      = vfd.Count,
      isClassAlternative         = vfd.isClassAlternative,
      isPayerExpansion           = vfd.isPayerExpansion
   FROM @ViewFindDispensable vfd
   INNER JOIN dbo.fdb_dispensable dis ON dis.DispensableUid = vfd.DispensableUid
   INNER JOIN dbo.fdb_drugname nam ON nam.DrugNameUid = dis.DrugNameUid
   LEFT OUTER JOIN dbo.fdb_doseform dos ON dos.DoseFormUid = dis.DoseFormUid
   LEFT OUTER JOIN dbo.fdb_route rte ON rte.RouteUid = dis.RouteUid
   LEFT OUTER JOIN dbo.fdb_drugname gen ON gen.mnid = dis.genericmnid
   LEFT OUTER JOIN dbo.ListFormularyProdFormuStat fst (NOLOCK) ON fst.FormularyProdFormuStatUid = vfd.FormularyProdFormuStatUid
   LEFT OUTER JOIN dbo.ListFormularyProdCostIndex cst (NOLOCK) ON cst.FormularyProdCostIndexUid =  vfd.FormularyProdCostIndexUid
   LEFT OUTER JOIN dbo.ViewFormularyRestrictions(@FormularyCoverageOrgUid) vfr ON vfr.medid = vfd.medid
   OUTER APPLY (
      SELECT TOP 1 cla.*
      FROM dbo.fdb_etclassification_drugs etc
      LEFT OUTER JOIN dbo.fdb_classification_etc cla ON cla.classid = etc.classid
      WHERE etc.conceptid = dis.medid
        AND etc.concepttype = 3
        AND etc.classid <> 1130 -- don''t allow bulk chemicals bug #15969
      ORDER BY etc.classid) cls
   -- NOTE: This view is not used for UserDefined drugs so it doesn''t need to look in RelDispensableRxCodes for RxNorm codes
   OUTER APPLY (
      SELECT TOP 1
         RXNORMCode      = rev.EVD_EXT_VOCAB_ID,
         RXNORMQualifier = CASE WHEN rev.EVD_LINK_TYPE_ID = 5 THEN ''SBD'' ELSE ''SCD'' END
      FROM fdb_REVDEL0_EXT_VOCAB_LINK rev
      WHERE rev.EVD_FDB_VOCAB_ID  = CONVERT(varchar(255), vfd.medid)
        AND rev.EVD_FDB_VOCAB_TYPE_ID = 3
        AND rev.EVD_LINK_TYPE_ID IN(1, 5)
      ORDER BY CASE vfd.nametypecode WHEN ''1'' THEN -rev.EVD_LINK_TYPE_ID ELSE rev.EVD_LINK_TYPE_ID END, rev.EVD_EXT_VOCAB_TYPE_ID) rxf
   OUTER APPLY (
      SELECT TOP 1 pkg.pmid, pkg.federaldeaclasscode
      FROM dbo.fdb_packageddrug pkg
      WHERE pkg.medid = dis.medid
      ORDER BY
         CASE WHEN dis.reffederaldeaclasscode = ''6'' AND pkg.obsoletedate < DATEADD(yy, -3, GETUTCDATE()) THEN 99 ELSE 0 END,
         CASE WHEN dis.reffederaldeaclasscode = ''6'' AND pkg.federaldeaclasscode IN(''1'',''2'',''3'',''4'',''5'') THEN pkg.federaldeaclasscode ELSE 99 END,
         ISNULL(pkg.obsoletedate, ''99990101'') desc,
         pkg.unitdosepackagingind,
         pkg.repackagerind,
         pkg.privlabeledprodind,
         pkg.standardpackind DESC,
         pkg.packagesize,
         pkg.pmid) pkg
   OUTER APPLY (
      SELECT federaldeaclasscode = CASE WHEN dis.reffederaldeaclasscode = ''6'' AND pkg.federaldeaclasscode IN(''0'',''1'',''2'',''3'',''4'',''5'')
                                        THEN pkg.federaldeaclasscode
                                        ELSE dis.reffederaldeaclasscode
                                   END) dea
   WHERE (vfd.isClassAlternative = 0 OR fst.PreferredSort >= 2)
   ORDER BY Count DESC, IsAlternative, IsClassAlternative, PreferredSort DESC, RelativeCostSort DESC, DescDisplay

RETURN
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindDispensable]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ViewFindDispensable](
   @viewName                     VARCHAR(80) = ''FindDispensableDrug'',
   @UserUid                      UNIQUEIDENTIFIER = NULL,
   @medid                        INT = NULL,
   @classid                      INT = NULL,
   @descsearch                   VARCHAR(255) = ''%'',
   @maxRows                      INT = 100,                          -- -1 = all, no limit
   @hicl                         INT = NULL,
   @mnid                         INT = NULL,
   @gcnseqno                     INT = NULL,
   @includeUserDefined           BIT = 1,
   @includeBrandName             BIT = 1,                            -- include brand names
   @includeGenericName           BIT = 1,                            -- include generic names
   @includeObsolete              BIT = 0,                            -- 0 = exclude obsolete medication, 1 = include obsolete medication
   @includeInactive              BIT = 0,
   @AbbreviateCopay              BIT = 1,
   @includeFormularyAlternatives BIT = 0,
   @FormularyVendorUid           UNIQUEIDENTIFIER = NULL,
   @FormularyIdentifierUid       UNIQUEIDENTIFIER = NULL,
   @FormularyOrgUid              UNIQUEIDENTIFIER = NULL,
   @FormularyAlternativesOrgUid  UNIQUEIDENTIFIER = NULL,
   @FormularyCopayOrgUid         UNIQUEIDENTIFIER = NULL,
   @FormularyCoverageOrgUid      UNIQUEIDENTIFIER = NULL,
   @PatienteRxEligibilityUid     UNIQUEIDENTIFIER = NULL)

RETURNS
   @ReturnTable TABLE (
      DispensableUid             UNIQUEIDENTIFIER   NOT NULL PRIMARY KEY,
      MEDID                      INT,
      MNID                       INT,
      DescDisplay                VARCHAR(125),
      DescSearch                 VARCHAR(125),
      DrugName                   VARCHAR(35),
      NameTypeCode               VARCHAR(1),
      StatusCode                 VARCHAR(1),
      ObsoleteDate               VARCHAR(8),
      Strength                   VARCHAR(255),
      StrengthUnits              VARCHAR(255),
      DoseForm                   VARCHAR(255),
      Route                      VARCHAR(30),
      GenericDrugNameID          INT,
      GenericDrugName            VARCHAR(125),
      GCNSeqNo                   INT,
      FederalDEAClassCode        VARCHAR(10),
      ClassUid                   UNIQUEIDENTIFIER,
      ClassID                    INT,
      ClassDescription           VARCHAR(70),
      ExternalID                 VARCHAR(25),
      Inactive                   BIT,
      UserDefined                TINYINT,
      HICL                       INT,
      FormularyProdFormuStatName VARCHAR(100),
      PreferredSort              INT,
      FormularyProdFormuCostName VARCHAR(100),
      RelativeCostSort           INT,
      NDC                        VARCHAR(20),
      RXNORMCode                 VARCHAR(50),
      RXNORMQualifier            VARCHAR(10),
      CopayRetail                VARCHAR(MAX),
      CopayMail                  VARCHAR(MAX),
      CopaySpecialty             VARCHAR(MAX),
      CopayLongTerm              VARCHAR(MAX),
      CoverageRestrictions       VARCHAR(50),
      IsAlternative              BIT,
      DrugTypeDesc               VARCHAR(100),
      Count                      INT,
      isClassAlternative         BIT,
      isPayerExpansion           BIT)
AS
BEGIN
   IF (@medid > 0 AND @viewName = ''FindDispensableDrug'')
      BEGIN
         -- CMR:  Do all the heavy lifting for formulary in a different view.  Will rip this out for SP1
         INSERT INTO @ReturnTable
         SELECT *
         FROM dbo.ViewFindFormulary(@medid,
                                    @AbbreviateCopay,
                                    @includeFormularyAlternatives,
                                    @FormularyVendorUid,
                                    @FormularyIdentifierUid,
                                    @FormularyOrgUid,
                                    @FormularyAlternativesOrgUid,
                                    @FormularyCopayOrgUid,
                                    @FormularyCoverageOrgUid,
                                    @PatienteRxEligibilityUid)
         RETURN
      END

   IF (@maxRows < 0)
      BEGIN
         SELECT @maxRows = 9999999
      END

   IF (@descsearch IS NULL)
      BEGIN
         SET @descsearch = ''%''
      END

   -- get list of DispensableUids of interest
   DECLARE @ViewFindDispensable TABLE(
      DispensableUid             UNIQUEIDENTIFIER  NOT NULL PRIMARY KEY CLUSTERED,
      medid                      INT               NULL,
      DescDisplay                VARCHAR(125)      NULL,
      nametypecode               VARCHAR(1)        NULL,
      refgenericdrugnamecode     VARCHAR(1)        NULL,
      reffederallegendcode       VARCHAR(1)        NULL,
      refmultisourcecode         VARCHAR(1)        NULL,
      statuscode                 VARCHAR(1)        NULL,
      Count                      INT               DEFAULT(0))


   IF (@viewName = ''FindDispensableDrug'')
      BEGIN
         INSERT INTO @ViewFindDispensable(DispensableUid, medid, DescDisplay, nametypecode, refgenericdrugnamecode, reffederallegendcode, refmultisourcecode, statuscode)
         SELECT DISTINCT TOP (@maxRows)
            DispensableUid          = dis.DispensableUid,
            medid                   = dis.medid,
            DescDisplay             = dis.DescDisplay,
            nametypecode            = dis.nametypecode,
            refgenericdrugnamecode  = dis.refgenericdrugnamecode,
            reffederallegendcode    = dis.reffederallegendcode,
            refmultisourcecode      = dis.refmultisourcecode,
            statuscode              = dis.statuscode
         FROM dbo.InternalFindDispensable dis
         WHERE dis.descsearch LIKE @descsearch
           AND ISNULL(dis.medid, -999) = COALESCE(@medid, ISNULL(dis.medid, -999))
           AND (@classid IS NULL OR @classid = (SELECT TOP 1 cls.classid
                                                FROM dbo.fdb_etclassification_drugs etc
                                                INNER JOIN dbo.fdb_classification_etc cls ON cls.classid = etc.classid AND cls.classid = @classid
                                                WHERE etc.conceptid = dis.mnid AND etc.concepttype = 1
                                                  AND etc.classid <> 1130 -- don''t allow bulk chemicals bug #15969
                                                ORDER BY etc.classid))
           AND ((@includeInactive = 1) OR ((@includeInactive = 0) AND (dis.Inactive = 0)))
           AND ((@includeObsolete = 1) OR ((@includeObsolete = 0) AND (dis.obsoletedate IS NULL) AND (ISNULL(dis.statuscode, ''0'') = ''0'')))
           AND ISNULL(dis.hicl, -999) = COALESCE(@hicl, ISNULL(dis.hicl, -999))
           AND ISNULL(dis.mnid, -999) = COALESCE(@mnid, ISNULL(dis.mnid, -999))
           AND ISNULL(dis.gcnseqno, -999) = COALESCE(@gcnseqno, ISNULL(dis.gcnseqno, -999))
           AND ((@includeUserDefined = 1) OR (dis.UserDefined != 1))
           AND ((dis.UserDefined = 1 AND dis.nametypecode IS NULL)
             -- note: column nametypecode is a varchar(1) and can never be ''999
             OR (dis.nametypecode IN(CASE @includeBrandName   WHEN 1 THEN ''1'' ELSE ''999'' END,
                                     CASE @includeGenericName WHEN 1 THEN ''2'' ELSE ''999'' END)))
         ORDER BY dis.descdisplay
      END

   ELSE IF (@viewName = ''FindEquivalentDispensableDrug'')
      BEGIN
         INSERT INTO @ViewFindDispensable(DispensableUid, medid, DescDisplay, nametypecode, refgenericdrugnamecode, reffederallegendcode, refmultisourcecode, statuscode)
         SELECT DISTINCT TOP (@maxRows)
            DispensableUid          = dis.DispensableUid,
            medid                   = dis.medid,
            DescDisplay             = dis.DescDisplay,
            nametypecode  = dis.nametypecode,
            refgenericdrugnamecode  = dis.refgenericdrugnamecode,
            reffederallegendcode    = dis.reffederallegendcode,
            refmultisourcecode      = dis.refmultisourcecode,
            statuscode              = dis.statuscode
         FROM dbo.InternalFindDispensable dis
         INNER JOIN dbo.fdb_dispensable lnk ON lnk.medid = @medid AND lnk.gcnseqno = dis.gcnseqno
         WHERE dis.medid != @medid
           AND dis.gcnseqno > 0
           AND dis.mnid != -1
           AND ((@includeInactive = 1) OR ((@includeInactive = 0) AND (dis.Inactive = 0)))
           AND ((@includeObsolete = 1) OR ((@includeObsolete = 0) AND (dis.obsoletedate IS NULL) AND (ISNULL(dis.statuscode, ''0'') = ''0'')))
           AND ISNULL(dis.hicl, -999) = COALESCE(@hicl, ISNULL(dis.hicl, -999))
           AND ISNULL(dis.mnid, -999) = COALESCE(@mnid, ISNULL(dis.mnid, -999))
           AND ISNULL(dis.gcnseqno, -999) = COALESCE(@gcnseqno, ISNULL(dis.gcnseqno, -999))
           AND ((@includeUserDefined = 1) OR (dis.UserDefined != 1))
           AND ((dis.UserDefined = 1 AND dis.nametypecode IS NULL)
             -- note: column nametypecode is a varchar(1) and can never be ''999
             OR (dis.nametypecode IN(CASE @includeBrandName   WHEN 1 THEN ''1'' ELSE ''999'' END,
                                     CASE @includeGenericName WHEN 1 THEN ''2'' ELSE ''999'' END)))
         ORDER BY dis.descdisplay
      END

   ELSE IF (@viewName IN(''FindMFUDispensableDrug'', ''FindMxUDispensableDrug''))
      BEGIN
         INSERT INTO @ViewFindDispensable(Count, DispensableUid, medid, DescDisplay, nametypecode, refgenericdrugnamecode, reffederallegendcode, refmultisourcecode, statuscode)
         SELECT DISTINCT TOP (@maxRows)
            Count                   = vft.Count,
            DispensableUid          = dis.DispensableUid,
            medid                   = dis.medid,
            DescDisplay             = dis.DescDisplay,
            nametypecode            = dis.nametypecode,
            refgenericdrugnamecode  = dis.refgenericdrugnamecode,
            reffederallegendcode    = dis.reffederallegendcode,
            refmultisourcecode      = dis.refmultisourcecode,
            statuscode              = dis.statuscode
         FROM dbo.InternalFindDispensable dis
         INNER JOIN dbo.ViewFindTableMFUHide vft ON vft.Uid = dis.DispensableUid
                                                AND (vft.Exclude = 0 OR @viewName = ''FindMxUDispensableDrug'')
                                                AND vft.FindTableUid = ''F92F50F5-FBF2-46D0-ABAD-CE321E6D498C''
                                                AND vft.UserUid = @UserUid
         WHERE (@classid IS NULL OR @classid = (SELECT TOP 1 cls.classid
                                                FROM dbo.fdb_etclassification_drugs etc
                                                INNER JOIN dbo.fdb_classification_etc cls ON cls.classid = etc.classid AND cls.classid = @classid
                                                WHERE etc.conceptid = dis.mnid AND etc.concepttype = 1
                                                  AND etc.classid <> 1130 -- don''t allow bulk chemicals bug #15969
                                                ORDER BY etc.classid))
           AND ((@includeInactive = 1) OR ((@includeInactive = 0) AND (dis.Inactive = 0)))
           AND ((@includeObsolete = 1) OR ((@includeObsolete = 0) AND (dis.obsoletedate IS NULL) AND (ISNULL(dis.statuscode, ''0'') = ''0'')))
           AND ISNULL(dis.hicl, -999) = COALESCE(@hicl, ISNULL(dis.hicl, -999))
           AND ISNULL(dis.mnid, -999) = COALESCE(@mnid, ISNULL(dis.mnid, -999))
           AND ISNULL(dis.gcnseqno, -999) = COALESCE(@gcnseqno, ISNULL(dis.gcnseqno, -999))
           AND ((@includeUserDefined = 1) OR (dis.UserDefined != 1))
           AND ((dis.UserDefined = 1 AND dis.nametypecode IS NULL)
             -- note: column nametypecode is a varchar(1) and can never be ''999
             OR (dis.nametypecode IN(CASE @includeBrandName   WHEN 1 THEN ''1'' ELSE ''999'' END,
                                     CASE @includeGenericName WHEN 1 THEN ''2'' ELSE ''999'' END)))
         ORDER BY vft.Count DESC, dis.descdisplay
      END

   ELSE IF (@viewName = ''FindUserDispensableDrug'')
      BEGIN
         INSERT INTO @ViewFindDispensable(DispensableUid, medid, DescDisplay, nametypecode, refgenericdrugnamecode, reffederallegendcode, refmultisourcecode, statuscode)
         SELECT DISTINCT TOP (@maxRows)
            DispensableUid          = dis.DispensableUid,
            medid                   = dis.medid,
            DescDisplay             = dis.DescDisplay,
            nametypecode            = dis.nametypecode,
            refgenericdrugnamecode  = dis.refgenericdrugnamecode,
            reffederallegendcode    = dis.reffederallegendcode,
            refmultisourcecode      = dis.refmultisourcecode,
            statuscode              = dis.statuscode
         FROM dbo.InternalFindDispensable dis
         WHERE dis.descsearch LIKE @descsearch  -- fixed bug #15907
           AND ((@includeInactive = 1) OR ((@includeInactive = 0) AND (dis.Inactive = 0)))
           AND dis.UserDefined = 1
         ORDER BY dis.descdisplay
      END

   -- return the table
   INSERT INTO @ReturnTable(
      DispensableUid,
      MEDID,
      MNID,
      DescDisplay,
      DescSearch,
      DrugName,
      NameTypeCode,
      StatusCode,
      ObsoleteDate,
      Strength,
      StrengthUnits,
      DoseForm,
      Route,
      GenericDrugNameID,
      GenericDrugName,
      GCNSeqNo,
      FederalDEAClassCode,
      ClassUid,
      ClassID,
      ClassDescription,
      ExternalID,
      Inactive,
      UserDefined,
      HICL,
      PreferredSort,
      RelativeCostSort,
      NDC,
      RXNORMCode,
      RXNORMQualifier,
      IsAlternative,
      DrugTypeDesc,
      Count,
      isClassAlternative,
      isPayerExpansion)
   SELECT
      DispensableUid             = dis.DispensableUid,
      MEDID                      = dis.medid,
      MNID                       = dis.mnid,
      DescDisplay                = dis.descdisplay,
      DescSearch                 = dis.descsearch,
      DrugName                   = ISNULL(nam.descdisplay, (SELECT lmt.Name FROM ListMedication lmt WHERE lmt.MedicationUid = dis.DispensableUid)),
      NameTypeCode               = dis.nametypecode,
      StatusCode                 = ISNULL(dis.statuscode, ''0''),
      ObsoleteDate               = dis.obsoletedate,
      Strength                   = dis.strength,
      StrengthUnits              = dis.strengthunits,
      DoseForm                   = dos.description,
      Route                      = rte.description1,
      GenericDrugNameID          = dis.genericmnid,
      GenericDrugName            = gen.descdisplay,
      GCNSeqNo                   = dis.gcnseqno,
      FederalDEAClassCode        = dea.federaldeaclasscode,
      ClassUid                   = cls.ClassUid,
      ClassID                    = cls.classid,
      ClassDescription           = cls.description1,
      ExternalID                 = dis.ExternalID,
      Inactive                   = dis.Inactive,
      UserDefined                = dis.UserDefined,
      HICL                       = dis.hicl,
      PreferredSort              = 0,
      RelativeCostSort           = 0,
      NDC                        = CASE WHEN dis.UserDefined = 1 THEN rxn.NDC ELSE pkg.pmid END,
      RXNORMCode                 = rxn.RxNorm,
      RXNORMQualifier            = rxn.RxNormQualifier,
      IsAlternative              = 0,
      DrugTypeDesc               = dbo.DispensableDrugTypeDesc(dis.medid, pkg.pmid, dea.federaldeaclasscode, dis.nametypecode, dis.refmultisourcecode, dis.reffederallegendcode, dis.medicaldeviceind, dis.refgenericdrugnamecode),
      Count                      = vfd.Count,
      isClassAlternative         = 0,
      isPayerExpansion           = 0
   FROM @ViewFindDispensable vfd
   INNER JOIN dbo.InternalFindDispensable dis ON dis.DispensableUid = vfd.DispensableUid
   LEFT OUTER JOIN dbo.fdb_drugname nam ON nam.DrugNameUid = dis.DrugNameUid
   LEFT OUTER JOIN dbo.fdb_doseform dos ON dos.DoseFormUid = dis.DoseFormUid
   LEFT OUTER JOIN dbo.fdb_route rte ON rte.RouteUid = dis.RouteUid
   LEFT OUTER JOIN dbo.fdb_drugname gen ON gen.mnid = dis.genericmnid
   OUTER APPLY (
      SELECT TOP 1 cla.*
      FROM dbo.fdb_etclassification_drugs etc
      LEFT OUTER JOIN dbo.fdb_classification_etc cla ON cla.classid = etc.classid
      WHERE etc.conceptid = dis.medid
        AND etc.concepttype = 3
        AND etc.classid <> 1130 -- don''t allow bulk chemicals bug #15969
      ORDER BY etc.classid) cls
   -- NOTE: RxNormCodes are not returned for fdb drugs.  Search doesn''t use RxNorm.  And this is only used for UserDefined drugs after selection
   OUTER APPLY (
      SELECT TOP 1 *
      FROM dbo.RelDispensableRxCodes rxn
      WHERE rxn.DispensableUid = dis.DispensableUid
        AND dis.UserDefined = 1) rxn
   OUTER APPLY (
      SELECT TOP 1 pkg.pmid, pkg.federaldeaclasscode
      FROM dbo.fdb_packageddrug pkg
      WHERE pkg.medid = dis.medid
      ORDER BY
         CASE WHEN dis.reffederaldeaclasscode = ''6'' AND pkg.obsoletedate < DATEADD(yy, -3, GETUTCDATE()) THEN 99 ELSE 0 END,
         CASE WHEN dis.reffederaldeaclasscode = ''6'' AND pkg.federaldeaclasscode IN(''1'',''2'',''3'',''4'',''5'') THEN pkg.federaldeaclasscode ELSE 99 END,
         ISNULL(pkg.obsoletedate, ''99990101'') desc,
         pkg.unitdosepackagingind,
         pkg.repackagerind,
         pkg.privlabeledprodind,
         pkg.standardpackind DESC,
         pkg.packagesize,
         pkg.pmid) pkg
   OUTER APPLY (
      SELECT federaldeaclasscode = CASE WHEN dis.reffederaldeaclasscode = ''6'' AND pkg.federaldeaclasscode IN(''0'',''1'',''2'',''3'',''4'',''5'')
                                        THEN pkg.federaldeaclasscode
                                        ELSE dis.reffederaldeaclasscode
                                   END) dea
   ORDER BY Count DESC, IsClassAlternative

RETURN
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindPQRI]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ViewFindPQRI](@PQRIGroupUid UniqueIdentifier)
RETURNS 
@FoundPQRI TABLE
(
	PQRIMeasureUid uniqueidentifier,
	ExternalID varchar(255), 
    Inactive bit,
	[Name] varchar(255), 
	Notes text,
	UserDefined smallint,
	EffectiveDate DateTime,
	ExpirationDate DateTime,
	PQRIDiseaseGroupUid uniqueidentifier
)

AS
begin

if @PQRIGroupUid is null
begin
	INSERT INTO @FoundPQRI (PQRIMeasureUid, ExternalID, Inactive, [Name], Notes, 
				UserDefined, EffectiveDate, ExpirationDate, PQRIDiseaseGroupUid) 
		SELECT dbo.ListPQRIMeasure.PQRIMeasureUid, 
			dbo.ListPQRIMeasure.ExternalID, dbo.ListPQRIMeasure.Inactive, 
			dbo.ListPQRIMeasure.Name, dbo.ListPQRIMeasure.Notes, 
			dbo.ListPQRIMeasure.UserDefined,
			dbo.ListPQRIMeasure.EffectiveDate,
			dbo.ListPQRIMeasure.ExpirationDate,
			dbo.ListPQRIMeasure.PQRIDiseaseGroupUid
		FROM dbo.ListPQRIMeasure
end
else begin
	INSERT INTO @FoundPQRI (PQRIMeasureUid, ExternalID, Inactive, [Name], Notes, 
				UserDefined, EffectiveDate, ExpirationDate, PQRIDiseaseGroupUid)  
	SELECT dbo.ListPQRIMeasure.PQRIMeasureUid, 
		dbo.ListPQRIMeasure.ExternalID, dbo.ListPQRIMeasure.Inactive, 
		dbo.ListPQRIMeasure.Name, dbo.ListPQRIMeasure.Notes, 
		dbo.ListPQRIMeasure.UserDefined,
		dbo.ListPQRIMeasure.EffectiveDate,
		dbo.ListPQRIMeasure.ExpirationDate,
		dbo.ListPQRIMeasure.PQRIDiseaseGroupUid
	FROM dbo.ListPQRIMeasure
        INNER JOIN dbo.RelPQRIMeasurePQRIGroup
		ON dbo.RelPQRIMeasurePQRIGroup.PQRIMeasureUid = dbo.ListPQRIMeasure.PQRIMeasureUid
		AND  PQRIGroupUid = @PQRIGroupUid
end


return
end
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewPrimaryInsurance]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ViewPrimaryInsurance] (@patientUid UNIQUEIDENTIFIER, @accountUid UNIQUEIDENTIFIER, @date DATETIME, @patienteRxEligibilityUid UNIQUEIDENTIFIER)
RETURNS 
@viewPrimaryInsurance TABLE 
(
	AccountUid UNIQUEIDENTIFIER NOT NULL,
	AccountName VARCHAR(100),
	IsMain BIT NOT NULL,
	PatientUid UNIQUEIDENTIFIER NOT NULL,
	AccountPeriodUid UNIQUEIDENTIFIER,
	InsuranceCarrierUid UNIQUEIDENTIFIER,
	InsuranceCarrierName VARCHAR(100),
	InsurancePlanUid UNIQUEIDENTIFIER,
	InsurancePlanName VARCHAR(100),
	InsurancePhoneNumber VARCHAR(50),
	ReimbursementRuleUid UNIQUEIDENTIFIER,
	IsEPrescribingIncentive BIT NOT NULL,
	PQRIGroupUid UNIQUEIDENTIFIER,
	PatienteRxEligibilityUid UNIQUEIDENTIFIER,	
	FormularyOrgUid UNIQUEIDENTIFIER,
	FormularyOrgName VARCHAR(100),
	FormularyIdentifierUid UNIQUEIDENTIFIER,
	FormularyVendorUid UNIQUEIDENTIFIER,
	FormularyID VARCHAR(10),
	FormularyAlternativesOrgUid UNIQUEIDENTIFIER,
	AlternativesID VARCHAR(10),
	FormularyCopayOrgUid UNIQUEIDENTIFIER,
	FormularyCoverageOrgUid UNIQUEIDENTIFIER,
	MailOrderEligible bit,
	EligibilityDate DATETIME,
	ExpirationDate DATETIME,
	LastSucceedRXBenefitsDownloadedDate DATETIME,
	LastSucceedeMedHXDownloadedDate DATETIME,
	PlanMemberID VARCHAR(50),
	PlanGroupID VARCHAR(50),
	InsuredName VARCHAR(100),
	InsuredRelation VARCHAR(100),
	AccountType VARCHAR(50),
	AccountTypeANSICode VARCHAR(2))
AS
BEGIN
	IF @accountUid IS NULL
		SELECT	@accountUid = AccountUid
		FROM	Account
		WHERE	PersonUid = @patientUid AND
				IsMain = 1
				
	IF @patientUid IS NULL
		SELECT	@patientUid = PersonUid
		FROM	Account
		WHERE	AccountUid = @accountUid
		
	DECLARE @accountPeriodUid UNIQUEIDENTIFIER
	

	INSERT	@viewPrimaryInsurance
	SELECT	a.AccountUid, a.Name AS AccountName, a.IsMain,
			a.PersonUid AS PatientUid,			
			ap.AccountPeriodUid,
			ip.InsuranceCarrierUid, c.Name AS InsuranceCarrierName,
			ip.InsurancePlanUid, ip.Name AS InsurancePlanName,
			CASE WHEN ip.UseCarrierAddress = 1 THEN c.[Phone1].value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(100)'') ELSE ip.[Phone].value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(100)'') END AS InsurancePhoneNumber,
			ISNULL(ip.ReimbursementRuleUid, ic.ReimbursementRuleUid) AS ReimbursementRuleUid,
			ISNULL(ic.IsEPrescribingIncentive, 0),
			ic.PQRIGroupUid,
			elg.PatienteRxEligibilityUid,
			fo.FormularyOrgUid,
			fo.Name AS FormularyOrgName,
			fo.FormularyIdentifierUid,
			fo.FormularyVendorUid,
			fo.FormularyID,
			elg.FormularyAlternativesOrgUid,
			fao.AlternativesID,			
			elg.FormularyCopayOrgUid,
			elg.FormularyCoverageOrgUid,
			ISNULL(elg.MailOrderEligible, 1),
			elg.EligibilityDate,
			elg.ExpirationDate,		
			dl.LastSucceedRXBenefitsDownloadedDate,
			dl.LastSucceedeMedHXDownloadedDate,
			pip.PlanMemberID, pip.PlanGroupID,
			ins.FullName AS InsuredName, r.Name AS InsuredRelation,
			at.Name AS AccountType, at.ANSICode AS AccountTypeANSICode
	FROM	Account a INNER JOIN AccountPeriod ap ON a.AccountUid = ap.AccountUid
			LEFT JOIN AccountInsurance ai ON ai.AccountPeriodUid = ap.AccountPeriodUid AND ai.DisplayOrder = 1
			LEFT JOIN PersonInsurancePlan pip ON ai.PersonInsurancePlanUid = pip.PersonInsurancePlanUid
			LEFT JOIN InsurancePlan ip ON pip.InsurancePlanUid = ip.InsurancePlanUid
			LEFT JOIN InsuranceCarrier ic ON ip.InsuranceCarrierUid = ic.CorporationUid
			LEFT JOIN Corporation c ON ic.CorporationUid = c.CorporationUid
			LEFT JOIN PatienteRxEligibility elg ON ISNULL(@patienteRxEligibilityUid, a.PatienteRxEligibilityUid) = elg.PatienteRxEligibilityUid
			LEFT JOIN FormularyAlternativesOrg fao ON elg.FormularyAlternativesOrgUid = fao.FormularyAlternativesOrgUid
			LEFT JOIN FormularyOrg fo ON elg.FormularyOrgUid = fo.FormularyOrgUid
			LEFT JOIN eRxBenefitsDownload AS dl ON a.PersonUid = dl.PatientUid
			LEFT JOIN ViewPerson ins ON pip.PersonUid = ins.PersonUid
			LEFT JOIN ListRelationship r ON ai.RelationshipUid = r.RelationshipUid
			LEFT JOIN ListAccountType at ON ap.AccountTypeUid = at.AccountTypeUid
	WHERE	(	@accountUid = ''00000000-0000-0000-0000-000000000000'' OR
				a.AccountUid = @accountUid
			) AND
			a.PersonUid = @patientUid AND
			ap.AccountPeriodUid = dbo.GetAccountPeriod(a.AccountUid, @date)
	
	UPDATE	vpi
	SET		IsEPrescribingIncentive = 1
	FROM	@viewPrimaryInsurance vpi INNER JOIN AccountInsurance ai ON vpi.AccountPeriodUid = ai.AccountPeriodUid
			LEFT JOIN PersonInsurancePlan pip ON ai.PersonInsurancePlanUid = pip.PersonInsurancePlanUid
			LEFT JOIN InsurancePlan ip ON pip.InsurancePlanUid = ip.InsurancePlanUid
			LEFT JOIN InsuranceCarrier ic ON ip.InsuranceCarrierUid = ic.CorporationUid
	WHERE	ic.IsEPrescribingIncentive = 1 AND
			vpi.IsEPrescribingIncentive = 0

	UPDATE	vpi
	SET		PQRIGroupUid = ic.PQRIGroupUid
	FROM	@viewPrimaryInsurance vpi INNER JOIN AccountInsurance ai ON vpi.AccountPeriodUid = ai.AccountPeriodUid
			LEFT JOIN PersonInsurancePlan pip ON ai.PersonInsurancePlanUid = pip.PersonInsurancePlanUid
			LEFT JOIN InsurancePlan ip ON pip.InsurancePlanUid = ip.InsurancePlanUid
			LEFT JOIN InsuranceCarrier ic ON ip.InsuranceCarrierUid = ic.CorporationUid
	WHERE	NOT ic.PQRIGroupUid IS NULL AND
			vpi.PQRIGroupUid IS NULL
	RETURN 
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[YYYYMMIntAsDateFirstDayOfMonth]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[YYYYMMIntAsDateFirstDayOfMonth]
(@YYYYMM INT)
RETURNS DATE
AS
BEGIN
RETURN CAST (substring (CAST (@YYYYMM AS CHAR), 5, 2) + ''/01/'' + SUBSTRING (CAST (@YYYYMM as CHAR), 1, 4) AS DATE)

END' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[YYYYMMIntAsDateLastDayOfMonth]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[YYYYMMIntAsDateLastDayOfMonth]
(@YYYYMM INT)
RETURNS DATE
AS
BEGIN
DECLARE @Day AS CHAR (2)
DECLARE @TestMonth AS CHAR (2)
DECLARE @NotLeapYear AS BIT
SET @NotLeapYear = (((@YYYYMM / 100) % 4))
SET @TestMonth = SUBSTRING (CAST (@YYYYMM AS CHAR), 5, 2)
SET @Day = ''31''
IF @TestMonth = ''02'' AND @NotLeapYear = 1 SET @Day = ''28''
ELSE IF @TestMonth = ''02'' AND @NotLeapYear = 0 SET @Day = ''29''
ELSE IF @TestMonth = ''04'' OR @TestMonth = ''06'' OR @TestMonth = ''09'' OR @TestMonth = ''11'' SET @Day = ''30''
RETURN CAST ( SUBSTRING(CAST (@YYYYMM AS CHAR), 5, 2) + ''/'' + @Day + ''/'' + SUBSTRING (CAST (@YYYYMM as CHAR), 1, 4) AS DATE)

END

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ZvalueToPercent]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ZvalueToPercent] (@zValue FLOAT)  
RETURNS FLOAT  
AS  
BEGIN  
 DECLARE @ZvalueToPercent FLOAT,@a1 FLOAT,@a2 FLOAT,@a3 FLOAT,@a4 FLOAT,@a5 FLOAT,@a6 FLOAT,@Orig FLOAT  
 SELECT @a1=0.0000053830  
 SELECT @a2=0.0000488906  
 SELECT @a3=0.0000380036  
 SELECT @a4=0.0032776263  
 SELECT @a5=0.0211410061  
 SELECT @a6=0.0498673470  
   
 SELECT @ZvalueToPercent=ABS(@zValue)  
 SELECT @ZvalueToPercent=(((((@a1 * @ZvalueToPercent + @a2) * @ZvalueToPercent + @a3) * @ZvalueToPercent + @a4) * @ZvalueToPercent + @a5) * @ZvalueToPercent + @a6) * @ZvalueToPercent + 1  
 SELECT @ZvalueToPercent=POWER(@ZvalueToPercent,-16)  
 SELECT @ZvalueToPercent=(1-@ZvalueToPercent/2)*100  
 IF @zValue<0  
  SELECT @ZvalueToPercent=100-@ZvalueToPercent  
 RETURN( @ZvalueToPercent )  
END  
;
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewInsurancePlan]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[ViewInsurancePlan] AS
SELECT	ip.InsurancePlanUid, ip.Name AS InsurancePlan, 
		ic.CorporationUid AS InsuranceCarrierUid, 
		c.Name AS InsuranceCarrier, c.Name + ''/'' + ip.Name AS Name,
		ip.ExternalID, ip.Inactive | ic.Inactive AS Inactive,
		CASE WHEN ip.UseCarrierAddress = 1 THEN c.[Address] ELSE ip.[Address] END AS [Address],
		CASE WHEN ip.UseCarrierAddress = 1 THEN c.[Address].value(''(/Address/Address1)[1]'', ''VARCHAR(100)'') ELSE ip.[Address].value(''(/Address/Address1)[1]'', ''VARCHAR(100)'') END AS Address1,
		CASE WHEN ip.UseCarrierAddress = 1 THEN c.[Address].value(''(/Address/Address2)[1]'', ''VARCHAR(100)'') ELSE ip.[Address].value(''(/Address/Address2)[1]'', ''VARCHAR(100)'') END AS Address2,
		CASE WHEN ip.UseCarrierAddress = 1 THEN c.[Address].value(''(/Address/City)[1]'', ''VARCHAR(100)'') ELSE ip.[Address].value(''(/Address/City)[1]'', ''VARCHAR(100)'') END AS City,
		CASE WHEN ip.UseCarrierAddress = 1 THEN c.[Address].value(''(/Address/State)[1]'', ''VARCHAR(100)'') ELSE ip.[Address].value(''(/Address/State)[1]'', ''VARCHAR(100)'') END AS [State],
		CASE WHEN ip.UseCarrierAddress = 1 THEN c.[Address].value(''(/Address/Zip)[1]'', ''VARCHAR(100)'') ELSE ip.[Address].value(''(/Address/Zip)[1]'', ''VARCHAR(100)'') END AS Zip,
		CASE WHEN ip.UseCarrierAddress = 1 THEN c.[Address].value(''(/Address/Country)[1]'', ''VARCHAR(100)'') ELSE ip.[Address].value(''(/Address/Country)[1]'', ''VARCHAR(100)'') END AS Country,
		CASE WHEN ip.UseCarrierAddress = 1 THEN c.[Phone1] ELSE ip.[Phone] END AS Phone,
		CASE WHEN ip.UseCarrierAddress = 1 THEN c.[Phone1].value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(100)'') ELSE ip.[Phone].value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(100)'') END AS PhoneNumber,
		CASE WHEN ip.UseCarrierAddress = 1 THEN c.[Phone1].value(''(/Phone/PhoneType)[1]'', ''VARCHAR(100)'') ELSE ip.[Phone].value(''(/Phone/PhoneType)[1]'', ''VARCHAR(100)'') END AS PhoneType,
		CASE WHEN ip.UseInsuranceCarrierAccountType=1 THEN ic.AccountTypeUid ELSE ip.AccountTypeUid END AS AccountTypeUid,
		ip.Notes, ic.ExternalID AS InsuranceCarrierExternalID
FROM	InsurancePlan AS ip INNER JOIN InsuranceCarrier AS ic ON ip.InsuranceCarrierUid = ic.CorporationUid INNER JOIN
        Corporation AS c ON ic.CorporationUid = c.CorporationUid 





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewPayerPlan]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewPayerPlan] AS
SELECT	vip.InsurancePlanUid, vip.InsuranceCarrierUid,
		vip.InsuranceCarrier AS PayerName, vip.InsurancePlan AS PlanName,
		vip.Inactive, vip.[Address],
		vip.Address1 AS PlanAddress1, vip.Address2 AS PlanAddress2, vip.City AS PlanCity, vip.[State] AS PlanState, vip.Zip AS PlanZip,
		vip.PhoneNumber, 
        REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(vip.PhoneNumber, ''-'', ''''), '' '', ''''), ''('', ''''), '')'', ''''), ''ext'', ''''), ''x'', '''') AS PhoneNumberScrubbed, 
        vip.Name AS PayerPlanName,
        vip.Notes, vip.ExternalID AS PlanExternalID, vip.InsuranceCarrierExternalID AS PayerExternalID,
        ISNULL(vip.ExternalID, vip.InsuranceCarrierExternalID) AS ExternalID             
FROM    [ViewInsurancePlan] vip



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getFormattedInternalName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION  [dbo].[UDF_getFormattedInternalName]
(
	@firstName	varchar(50),
	@middleName	varchar(50),
	@lastName	varchar(50),
	@akaFirstName varchar(50),
	@akaLastName varchar(50)
)
RETURNS varchar(250) WITH SCHEMABINDING
AS
BEGIN 

	DECLARE @name VARCHAR(200)
	
	IF @akaLastName IS NULL OR RTRIM(@akaLastName) = ''''
		SET @name = @lastName
	ELSE
		SET @name = @akaLastName
		
	IF RTRIM(@name) <> ''''
		SET @name = @name + '', ''
		
	IF @akaFirstName IS NULL OR RTRIM(@akaFirstName) = ''''
		SET @name = @name + @firstName
	ELSE
		SET @name = @name + @akaFirstName
	
	IF RTRIM(@middleName) <> ''''
		SET @name = @name + '' '' + @middleName
		
	RETURN @name
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_getFormattedName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION  [dbo].[UDF_getFormattedName]
(
	@sPrefix	varchar(25),
	@sFirstName	varchar(50),
	@sMiddleName	varchar(50),
	@sLastName	varchar(50),
	@sSuffix	varchar(50)
)
RETURNS varchar(225) WITH SCHEMABINDING
AS
BEGIN 
	return(
		(CASE WHEN @sPrefix is null OR RTRIM(@sPrefix) = '''' THEN '''' ELSE @sPrefix + '' '' END) 
		+ (CASE WHEN @sLastName is null OR RTRIM(@sLastName) = '''' THEN '''' ELSE @sLastName + '', '' END)
		+ (CASE WHEN @sFirstName is null OR RTRIM(@sFirstName) = '''' THEN '''' ELSE @sFirstName END)
		+ (CASE WHEN @sMiddleName is null OR RTRIM(@sMiddleName) = '''' THEN '''' ELSE '' '' +@sMiddleName END)
		+ (CASE WHEN @sSuffix is null OR RTRIM(@sSuffix) = '''' THEN '''' ELSE '', '' + @sSuffix END)
	)

	/* Example:
	select top 10 
	dbo.UDF_getFormattedName(
		p.Prefix,
		p.FirstName,
		p.MiddleName,
		p.LastName,
		p.Suffix)
	from Person p
	*/
END
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewPerson]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[ViewPerson]  WITH SCHEMABINDING AS
SELECT		P.PersonUid, Inactive, Prefix, FirstName, MiddleName, LastName, Suffix, AkaFirstName, AkaLastName,
            SocialSecurityNumber, Birthdate, Deathdate, DriverLicenseNumber,
			dbo.UDF_getFormattedName(Prefix, FirstName, MiddleName, LastName, Suffix) AS FullName,
			dbo.UDF_getFormattedInternalName(FirstName, MiddleName, LastName, AkaFirstName, AkaLastName) AS FormattedInternalName,
			dbo.UDF_getFormattedName(NULL, FirstName, MiddleName, LastName, Suffix) AS FormattedPreferredName,
			dbo.UDF_getFormattedName(NULL, ISNULL(AkaFirstName, FirstName), NULL, ISNULL(AkaLastName, LastName), NULL) AS AkaName,
            p.Address1, 
			p.Computed_Address1_Address1 AS Address1_Address1,
			p.Computed_Address1_Address2 AS Address1_Address2,
			p.Computed_Address1_City AS Address1_City,
			p.Computed_Address1_State AS Address1_State,
			p.Computed_Address1_Zip AS Address1_Zip,
			p.Phone1, 
			p.Computed_Phone1_PhoneNumber AS PhoneNumber1,
			p.Computed_Phone1_PhoneType AS PhoneType1,
			REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(REPLACE(p.Computed_Phone1_PhoneNumber, ''-'', ''''), '' '', ''''), ''('', ''''), '')'', ''''), ''ext'', ''''), ''x'', '''') AS PhoneNumberScrubbed,
			p.Phone2, 
			p.Computed_Phone2_PhoneNumber AS PhoneNumber2,
			p.Computed_Phone2_PhoneType AS PhoneType2,
			p.Phone3, 
			p.Computed_Phone3_PhoneNumber AS PhoneNumber3,
			p.Computed_Phone3_PhoneType AS PhoneType3,
			p.Phone4,
			p.Computed_Phone4_PhoneNumber AS PhoneNumber4,
			p.Computed_Phone4_PhoneType AS PhoneType4,
			p.EmailDirect,
			p.Email1,
			P.Email2
FROM		dbo.Person P            
/*
CREATE UNIQUE CLUSTERED INDEX IX_PersonUid ON ViewPerson(PersonUid)
CREATE INDEX IX_LastName ON ViewPerson(LastName)
CREATE INDEX IX_FirstName ON ViewPerson(FirstName)
CREATE INDEX IX_Name ON ViewPerson(FirstName, LastName)
CREATE INDEX IX_SSN ON ViewPerson(SocialSecurityNumber)
CREATE INDEX IX_DL ON ViewPerson(DriverLicenseNumber)
CREATE INDEX IX_Birthdate ON ViewPerson(BirthDate)
CREATE INDEX IX_Address1_Address1 ON ViewPerson(Address1_Address1)
CREATE INDEX IX_Address1_City ON ViewPerson(Address1_City)
CREATE INDEX IX_Address1_State ON ViewPerson(Address1_State)
CREATE INDEX IX_Address1_Zip ON ViewPerson(Address1_Zip)
CREATE INDEX IX_FormattedInternalName ON ViewPerson(FormattedInternalName)
CREATE INDEX IX_FormattedPreferredName ON ViewPerson(FormattedPreferredName)
CREATE INDEX IX_FullName ON ViewPerson(FullName)
*/

' 
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ViewPerson]') AND name = N'IX_PersonUid')
CREATE UNIQUE CLUSTERED INDEX [IX_PersonUid] ON [dbo].[ViewPerson]
(
	[PersonUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewProvider]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewProvider] AS
SELECT			pe.PersonUid, pr.ExternalID, 
				pe.Prefix, pe.FirstName, pe.MiddleName, pe.LastName, pe.Suffix,
				pe.AkaFirstName, pe.AkaLastName,
				pr.Inactive, 
				pr.ClinicCenterUid, cc.Name AS ClinicCenter,
				(CASE WHEN u.PersonUid IS NULL THEN 0 ELSE 1 END) AS IsActiveUser, 
				pr.ProviderRoleID, pr.ProviderLicense, pr.FTE,
				pr.SpecialtyUid, ls.Name as Specialty, pr.ConsultingProvider,
				pe.Address1, pe.Address2,
				pe.Phone1, pe.Phone2, pe.Phone3, pe.Phone4,
				pr.Notes, PFN.FullName, PFN.FormattedInternalName,
				(CASE WHEN pr.AprimaDataExchangeProviderRegistrationUid IS NULL THEN 0 ELSE 1 END) AS IsAprimaDataExchangeProvider,
				pr.AprimaDataExchangeProviderRegistrationUid,
				pe.EmailDirect,
				pe.Email1, pe.Email2,
				ls.ANSICode as SpecialtyANSICode
FROM            Provider pr 
				INNER JOIN Person pe ON pr.PersonUid = pe.PersonUid 
				LEFT JOIN ListClinicCenter cc ON pr.ClinicCenterUid = cc.ClinicCenterUid 
                LEFT JOIN UserPRM u ON pr.PersonUid = u.PersonUid AND u.Inactive = 0
                LEFT JOIN ListSpecialty ls on pr.SpecialtyUid = ls.SpecialtyUid
                INNER JOIN ViewPerson (NOEXPAND) PFN ON PR.PersonUid = PFN.PersonUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementSuperbillBalance]'))
EXEC dbo.sp_executesql @statement = N'




CREATE VIEW [dbo].[ViewStatementSuperbillBalance]  WITH SCHEMABINDING
AS 
SELECT
	A.AccountResponsiblePartyUid as RPUid, 
	S.SuperbillUid, 
	LD.FinancialCenterUid,
	Sum(Case When LD.LiabilityOwner > 0  Then LD.Amount Else Convert(Money, 0) End) as Insurance, 
	Sum(Case When LD.LiabilityOwner = 0  Then LD.Amount Else Convert(Money, 0) End) as Patient,
	Sum(LD.Amount) as LiabilityBalance,
	S.SuperbillStatusUid,
	COUNT_BIG(*) MaxCnt
FROM	dbo.AR_Ledger (NOLOCK) L 
INNER JOIN	dbo.AR_LedgerDetail (NOLOCK) LD
ON	L.LedgerUid=LD.LedgerUid 
INNER JOIN	dbo.SuperbillProcedure (NOLOCK) SP 
ON	SP.SuperbillProcedureUid=LD.SuperbillProcedureUid
INNER JOIN	dbo.Superbill (NOLOCK) S 
ON	S.SuperbillUid=SP.SuperbillUid
INNER JOIN	dbo.Account (NOLOCK) A 
ON	S.AccountUid = A.AccountUid
GROUP BY 
	A.AccountResponsiblePartyUid, S.SuperbillUid, LD.FinancialCenterUid, SuperbillStatusUid




' 
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementSuperbillBalance]') AND name = N'PK_ViewStatementSuperbillBalance_AccountResponsiblePartyUid')
CREATE UNIQUE CLUSTERED INDEX [PK_ViewStatementSuperbillBalance_AccountResponsiblePartyUid] ON [dbo].[ViewStatementSuperbillBalance]
(
	[RPUid] ASC,
	[SuperbillUid] ASC,
	[FinancialCenterUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementSuperbillBalanceExcludeStatus]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[ViewStatementSuperbillBalanceExcludeStatus] 
AS 
SELECT
	RPUid, 
	SuperbillUid, 
	FinancialCenterUid,
	Insurance, 
	Patient,
	LiabilityBalance,
	MaxCnt
FROM	dbo.ViewStatementSuperbillBalance vssb WITH (NOEXPAND)
LEFT OUTER JOIN dbo.RelPracticeSettingsSuperbillStatus (NOLOCK) rpsss
ON vssb.SuperbillStatusUid = rpsss.SuperbillStatusUid
where rpsss.superbillstatusuid is null

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_VIEW_PatientLabResultsWithProvider]'))
EXEC dbo.sp_executesql @statement = N'




CREATE VIEW [dbo].[MDOL_RPT2_VIEW_PatientLabResultsWithProvider]
AS

SELECT ('';'' + loi.NAME + '': '' + coalesce(nullif(Convert(VARCHAR(50), ISNULL(ov.ObservationValue,'''')), ''''), ''N/A'') + '' Resulted: '' + (Convert(VARCHAR(50), coalesce(oo.ResultDate, oo.Performdate, Extractdate, Orderdate), 101))) AS LabResult
	,loi.ObservationItemUid
	,coalesce(convert(varchar(max),convert(decimal(10,1),ov.MetricValue1)), LEFT(SUBSTRING(ov.ObservationValue, PATINDEX(''%[0-9.-]%'', ov.ObservationValue), 800), PATINDEX(''%[^0-9.-]%'', SUBSTRING(ObservationValue, PATINDEX(''%[0-9.-]%'', ov.ObservationValue), 800) + ''X'') - 1)) AS NumericObservationValue
	,coalesce(v.visitDate, oo.ResultDate, oo.Performdate, Extractdate, Orderdate) AS ResultDate
	,oo.LaboratoryUid
	,oo.PatientUid
	,oo.IsDelete
	,oo.OrderProviderUid
	,OrderProvider.FormattedPreferredName as OrderProvider
	,oo.ApproveProviderUid
	,ApproveProvider.FormattedPreferredName as ApproveProvider
	,oo.PerformProviderUid
	,PerformProvider.FormattedPreferredName as PerformProvider
	FROM ObservationOrder oo WITH (NOLOCK)
INNER JOIN ObservationValue ov WITH (NOLOCK)
	ON ov.ObservationOrderUid = oo.ObservationOrderUid
INNER JOIN ListObservationItem loi WITH (NOLOCK)
	ON loi.ObservationItemUid = ov.ObservationItemUid
INNER JOIN Person PR WITH (NOLOCK)
	ON PR.PersonUid = oo.PatientUid
LEFT JOIN Visit V WITH (NOLOCK)
ON v.VisitUid=oo.VisitUid
LEFT JOIN ViewPerson OrderProvider WITH (NOEXPAND, NOLOCK) ON oo.OrderProviderUid = OrderProvider.PersonUid
LEFT JOIN ViewPerson ApproveProvider WITH (NOEXPAND, NOLOCK) ON oo.ApproveProviderUid = ApproveProvider.PersonUid
LEFT JOIN ViewPerson PerformProvider WITH (NOEXPAND, NOLOCK) ON oo.PerformProviderUid = PerformProvider.PersonUid




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewAccountPeriodEligibilityDate]'))
EXEC dbo.sp_executesql @statement = N'
-- DSW 08/30/2016 50228-Eligibility issues with Medicare for HMO payers
--        Add OtherPayerTypeCode, PlanMemberID, eligibilitySubscriberID

CREATE VIEW	[dbo].[ViewAccountPeriodEligibilityDate] AS
	SELECT		ap.AccountPeriodUid, a.AccountUid, a.PersonUid AS PatientUid,				
				pip.EligibilityVerificationDateTime as EligibilityDate,
				pip.EligibilityStatusUid, pip.EligibilityResponseXML,
				CAST(CASE			WHEN es.EligibilityStatusUid IS NULL AND pip.EligibilityTransmissionInProcess = 1 THEN 0 /* Downloading */
									WHEN es.EligibilityStatusUid = ''A9D72B1E-42FC-495E-AE92-74E6C68FFA6B'' THEN 3 /* Error */
									WHEN es.EligibilityStatusUid IS NULL AND pip.EligibilityTransmissionStatus = ''Eligibility Verification Failed'' THEN 3 /* Error */
									WHEN es.EligibilityStatusUid IS NULL AND pip.EligibilityResponseXML.value(''(/error)[1]'', ''VARCHAR(MAX)'') IS NOT NULL THEN 3 /* Error */
									WHEN pip.EligibilityExpirationDate < GETUTCDATE() THEN 5 /* Insurance Expired */
									WHEN es.ActiveCoverage = 1 THEN 1 /* Active Coverage */
									WHEN es.ActiveCoverage = 0 THEN 2 /* Inactive Coverage */									
									WHEN pip.EligibilityTransmissionStatus IS NULL THEN NULL /* Expired OR Never Done*/
									ELSE 4 END /* Unknown */ AS SMALLINT) AS EligibilityStatus,
				-- EB - Subscriber Eligibility or Benefit Information, Loop 2110C ( 50228 )
				--   EB01, Other or Additional Payer == R
				--   EB03, Health Benefit Plan Coverage == 30  
				(   select top 1 o.value(''InsuranceTypeCode[1]'', ''varchar(2)'')  
								from pip.EligibilityResponseXML.nodes(''//Loop2110/EligibilityorBenefit'') as EB(o)
								where o.value(''EligibilityorBenefitInformation[1]'', ''varchar(2)'') = ''R''
									and o.value(''ServiceTypeCode[1]'', ''varchar(2)'') = ''30'') as OtherPayerTypeCode,
				pip.PlanMemberID,	-- PRM planMemberID ( 50228 )
				-- NM1 - Subscriber Name, Loop 2100C (50228 )
				--   NM101, IL == Insured or Subscriber
				--   NM108, MI == Member Identification Number
				--   NM109, Identification Code, Subscriber Primary Identifier
				( select s.value(''IdentificationCode[1]'', ''varchar(80)'') 
				  from pip.EligibilityResponseXML.nodes(''//Loop2100/Subscriber'') as Subscriber(s)
				  where s.value(''EntityIdentifierCode[1]'', ''varchar(2)'') = ''IL''
					  and s.value(''IdentificationCodeQualifier[1]'', ''varchar(2)'') = ''MI'') AS eligibilitySubscriberID
	FROM		Account a INNER JOIN AccountPeriod ap ON a.AccountUid = ap.AccountUid
				INNER JOIN AccountInsurance ai ON ap.AccountPeriodUid = ai.AccountPeriodUid AND ai.DisplayOrder = 1
				INNER JOIN PersonInsurancePlan pip ON ai.PersonInsurancePlanUid = pip.PersonInsurancePlanUid
				LEFT JOIN ListEligibilityStatus es ON pip.EligibilityStatusUid = es.EligibilityStatusUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewAppointmentWithGroup]'))
EXEC dbo.sp_executesql @statement = N'

--20150817 kdc add billingprovideruid

CREATE VIEW [dbo].[ViewAppointmentWithGroup] AS
	WITH PracticeSettings_CTE (PracticeSettingsUid, PracticeName, PracticeAddress1, PracticeCity, PracticeState, PracticeZip, PracticePhoneNumber, PracticePhoneTypeUid, PracticePhoneType)
	AS
	(
		SELECT
			TOP 1 
			PracticeSettingsUid     = ps.PracticeSettingsUid,
			PracticeName			= ps.Name,
			PracticeAddress1		= ISNULL(ps.MainAddress.value(''(/Address/Address1)[1]'', ''VARCHAR(255)''), ''''),
			PracticeCity			= ISNULL(ps.MainAddress.value(''(/Address/City)[1]'', ''VARCHAR(255)''), ''''),
			PracticeState			= ISNULL(ps.MainAddress.value(''(/Address/State)[1]'', ''VARCHAR(255)''), ''''),
			PracticeZip				= ISNULL(ps.MainAddress.value(''(/Address/Zip)[1]'', ''VARCHAR(255)''), ''''),
			PracticePhoneNumber		= ISNULL(ps.MainPhone.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(255)''), ''''),
			PracticePhoneTypeUid	= ISNULL(ps.MainPhone.value(''(/Phone/PhoneTypeUid)[1]'', ''VARCHAR(255)''), ''00000000-0000-0000-8000-000000000000''),
			PracticePhoneType		= ISNULL(ps.MainPhone.value(''(/Phone/PhoneType)[1]'', ''VARCHAR(255)''), '''')
		FROM PracticeSettings ps
	)

   SELECT
		AppointmentUid          = a.AppointmentUid,
		AppointmentTypeUid      = a.AppointmentTypeUid,
		AppointmentStatusUid    = a.AppointmentStatusUid,
		CheckinDateTime         = a.CheckinDateTime,
		DischargeDateTime       = a.DischargeDateTime,
		PatientCaseUid          = a.PatientCaseUid,
		PatientUid              = ISNULL(a.PatientUid, g.PatientUid),
		AccountUid              = ISNULL(a.AccountUid, g.AccountUid),
		CalendarUid				= a.CalendarUid,
		ServiceSiteUid          = a.ServiceSiteUid,

		VisitLocationUid		= CASE WHEN lss.Address.value(''(/Address/Address1)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/City)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/State)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/Zip)[1]'', ''VARCHAR(255)'') IS NOT NULL THEN 
									lss.ServiceSiteUid
								  ELSE 
									(SELECT PracticeSettings_CTE.PracticeSettingsUid FROM PracticeSettings_CTE)
								  END,

		VisitLocationName		= CASE WHEN lss.Address.value(''(/Address/Address1)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/City)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/State)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/Zip)[1]'', ''VARCHAR(255)'') IS NOT NULL THEN 
									ISNULL(lss.Name, '''')
								  ELSE 
									(SELECT PracticeSettings_CTE.PracticeName FROM PracticeSettings_CTE)
								  END,

		VisitLocationAddress1	= CASE WHEN lss.Address.value(''(/Address/Address1)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/City)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/State)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/Zip)[1]'', ''VARCHAR(255)'') IS NOT NULL THEN 
									ISNULL(lss.Address.value(''(/Address/Address1)[1]'', ''VARCHAR(255)''), '''')
								  ELSE 
									(SELECT PracticeSettings_CTE.PracticeAddress1 FROM PracticeSettings_CTE)
								  END,

		VisitLocationCity		= CASE WHEN lss.Address.value(''(/Address/Address1)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/City)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/State)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/Zip)[1]'', ''VARCHAR(255)'') IS NOT NULL THEN 
									ISNULL(lss.Address.value(''(/Address/City)[1]'', ''VARCHAR(255)''), '''')
								  ELSE 
									(SELECT PracticeSettings_CTE.PracticeCity FROM PracticeSettings_CTE)
								  END,

		VisitLocationState		= CASE WHEN lss.Address.value(''(/Address/Address1)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/City)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/State)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/Zip)[1]'', ''VARCHAR(255)'') IS NOT NULL THEN 
									ISNULL(lss.Address.value(''(/Address/State)[1]'', ''VARCHAR(255)''), '''')
								  ELSE 
									(SELECT PracticeSettings_CTE.PracticeState FROM PracticeSettings_CTE)
								  END,

		VisitLocationZip		= CASE WHEN lss.Address.value(''(/Address/Address1)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/City)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/State)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/Zip)[1]'', ''VARCHAR(255)'') IS NOT NULL THEN 
									ISNULL(lss.Address.value(''(/Address/Zip)[1]'', ''VARCHAR(255)''), '''')
								  ELSE 
									(SELECT PracticeSettings_CTE.PracticeZip FROM PracticeSettings_CTE)
								  END,

		VisitLocationPhoneNumber = CASE WHEN lss.Address.value(''(/Address/Address1)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/City)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/State)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/Zip)[1]'', ''VARCHAR(255)'') IS NOT NULL THEN 
									ISNULL(lss.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(255)''), '''')
								  ELSE 
									(SELECT PracticeSettings_CTE.PracticePhoneNumber FROM PracticeSettings_CTE)
								  END,

		VisitLocationPhoneType	= CASE WHEN lss.Address.value(''(/Address/Address1)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/City)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/State)[1]'', ''VARCHAR(255)'') IS NOT NULL 
											AND lss.Address.value(''(/Address/Zip)[1]'', ''VARCHAR(255)'') IS NOT NULL THEN 
									ISNULL(lss.Phone1.value(''(/Phone/PhoneType)[1]'', ''VARCHAR(255)''), '''')
								  ELSE 
									(SELECT PracticeSettings_CTE.PracticePhoneType FROM PracticeSettings_CTE)
								  END,

      FinancialCenterUid		= a.FinancialCenterUid,
      ProviderUid				= a.ProviderUid, --Rendering Provider
      ProviderCareTypeUid		= a.ProviderCareTypeUid,
	  BillingProviderUid		= a.BillingProviderUid,
      ReferredbyProviderUid		= a.ReferredbyProviderUid,
      ReferringDate				= a.ReferringDate,
      Phone						= a.Phone,
      CallConfirmStatusUid		= a.CallConfirmStatusUid,
      CallConfirmStatusDetail	= a.CallConfirmStatusDetail,
      Reason					= a.Reason,
      AuthorizationReminder		= a.AuthorizationReminder,
      AuthorizationCode			= a.AuthorizationCode,
      StartDateTime				= a.StartDateTime,
      EndDateTime				= a.EndDateTime,
      ExternalID				= a.ExternalID,
      Notes						= a.Notes,
      CreatedByUid				= a.CreatedByUid,
      CreatedDateTime			= a.CreatedDateTime,
      LastModifiedDate			= a.LastModifiedDate,
      LastModifiedByUid			= a.LastModifiedByUid,
      TriggerOverride			= a.TriggerOverride,
      ReferralSrcUid			= a.ReferralSrcUid,
      ScheduleType				= a.ScheduleType,

      Calendar					= c.Name,
	  TimeZone					= c.TimeZone,
      Provider					= PNS.FormattedInternalName,
	  ProviderFullName			= PNS.FullName,
      FullName					= per.LastName + '', '' + per.FirstName,
      Birthdate					= per.Birthdate,
      MedicalRecordNumber		= pat.MedicalRecordNumber,
      PhoneNumber				= CASE WHEN NOT a.AppointmentUid IS NULL THEN Phone.value(''(/Phone/PhoneNumber)[1]'', ''VARCHAR(50)'') ELSE NULL END,
      Address1					= per.Address1,
      AddressString				= RTRIM(per.Address1.value(''(/Address/Address1)[1]'', ''VARCHAR(255)'') + '' ''
									+ ISNULL(per.Address1.value(''(/Address/Address2)[1]'', ''VARCHAR(255)''),'''')) + CHAR(13)
									+ ISNULL(per.Address1.value(''(/Address/City)[1]'', ''VARCHAR(255)''),'''') + '' ''
									+ ISNULL(per.Address1.value(''(/Address/State)[1]'', ''VARCHAR(255)''),'''') + ''  ''
									+ ISNULL(per.Address1.value(''(/Address/Zip)[1]'', ''VARCHAR(255)''),''''),
      Phone1					= per.Phone1,
	  Phone2					= per.Phone2,
      Name						= per.LastName + '', '' + per.FirstName + ''('' + CONVERT(varchar(20), a.StartDateTime, 120) + '')'',
      Inactive					= 0,
      ShowOnSchedule			= astat.ShowOnSchedule,
      ShowOnDesktop				= astat.ShowOnDesktop,

	  ApptTypeColor             = at.Color,
      AppointmentTypeName       = at.Name,
	  AppointmentTypeDuration   = at.Duration,
	  AppointmentTypeExternalId = at.ExternalID,
	  AppointmentTypeGroupVisit = at.GroupVisit,

      ApptStatusColor           = astat.Color,
      AppointmentStatusName     = ISNULL(gstat.Name, astat.Name),
	  AppointmentStatusExternalId = ISNULL(gstat.ExternalID, astat.ExternalID),

      EligibilityStatus			= aped.EligibilityStatus,
      isCommitted				= CONVERT(BIT, CASE WHEN (SELECT COUNT(*) FROM Visit v WHERE v.AppointmentUid = a.AppointmentUid AND v.IsCompleted = 1) > 0 THEN 1 ELSE 0 END),
      AssociatedWithVisit		= CONVERT(BIT, CASE WHEN (SELECT COUNT(*) FROM Visit v WHERE v.AppointmentUid = a.AppointmentUid) > 0 THEN 1 ELSE 0 END),
      CanCreateGroupVisit		= CONVERT(BIT, CASE WHEN (SELECT COUNT(*) FROM RelGroupAppointmentPatient g LEFT JOIN Visit v ON v.AppointmentUid = g.AppointmentUid AND v.PatientUid = g.PatientUid WHERE g.AppointmentUid = a.AppointmentUid AND v.VisitUid IS NULL) > 0 THEN 1 ELSE 0 END)
FROM Appointment a
   LEFT JOIN RelGroupAppointmentPatient g WITH (NOLOCK) ON g.AppointmentUid = a.AppointmentUid
   LEFT JOIN Provider PR WITH (NOLOCK) ON A.ProviderUid = PR.PersonUid -- filter out for providers only
   LEFT JOIN ViewPerson PNS WITH (NOEXPAND) ON PR.PersonUid = PNS.PersonUid
   LEFT JOIN ListCalendar c WITH (NOLOCK) ON a.CalendarUid = c.CalendarUid
   LEFT JOIN ListAppointmentType at WITH (NOLOCK) ON a.AppointmentTypeUid = at.AppointmentTypeUid
   LEFT JOIN ListAppointmentStatus astat WITH (NOLOCK) ON a.AppointmentStatusUid = astat.AppointmentStatusUid
   LEFT JOIN ListAppointmentStatus gstat WITH (NOLOCK) ON g.AppointmentStatusUid = gstat.AppointmentStatusUid
   LEFT JOIN Patient pat WITH (NOLOCK) ON ISNULL(a.PatientUid, g.PatientUid) = pat.PersonUid
   LEFT JOIN Person per WITH (NOLOCK) ON ISNULL(a.PatientUid, g.PatientUid) = per.PersonUid
   LEFT JOIN ViewAccountPeriodEligibilityDate aped ON aped.AccountPeriodUid =
               (SELECT TOP 1 ap.AccountPeriodUid
                FROM AccountPeriod ap WITH (NOLOCK)  -- Replaces GetAccountPeriod
                WHERE ap.AccountUid = a.AccountUid
                  AND (CAST(ap.EffectiveDate AS DATE) <= CAST(a.StartDateTime AS DATE) OR ap.EffectiveDate IS NULL) AND
                      (CAST(ap.ExpirationDate AS DATE) >= CAST(a.StartDateTime AS DATE) OR ap.ExpirationDate IS NULL))
   LEFT JOIN ListServiceSite lss WITH (NOLOCK) ON lss.ServiceSiteUid = a.ServiceSiteUid




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewTransactionAggregateSub]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[AR_ViewTransactionAggregateSub]
AS
	select	art.TransactionUid, 
			-- Payments and Charges are not part of a transaction 
			-- Distribution ( 4 types: 1) Insurance Payments 2) Patient Payments 3) Insurance Payer Credits 4) Patient Payer Credits
			SUM(CASE WHEN (arl.EntryType = 2 AND ldCredit.LiabilityOwner > 0 AND ldDebit.DepositUid IS NOT NULL) THEN ldDebit.Amount ELSE 0 END) AS InsDistribution, -- Used by AR_LedgerDetail_SuperbillAggregate_Insert
            SUM(CASE WHEN (arl.EntryType = 2 AND ldCredit.LiabilityOwner = 0 AND ldDebit.DepositUid IS NOT NULL) THEN ldDebit.Amount ELSE 0 END) AS PatientDistribution, -- Used by AR_LedgerDetail_SuperbillAggregate_Insert
			--SUM(CASE WHEN (arl.EntryType = 2 AND ldCredit.LiabilityOwner > 0 AND ldDebit.DepositUid IS NOT NULL) THEN ldDebit.Amount ELSE 0 END) as InsPaymentDistributions,  -- Total distributions from an insurance payment(deposit)
            --SUM(CASE WHEN (arl.EntryType = 2 AND ldCredit.LiabilityOwner = 0 AND ldDebit.DepositUid IS NOT NULL) THEN ldDebit.Amount ELSE 0 END) as PtPaymentDistributions, -- Total distributions from an patient payment(deposit)
			SUM(CASE WHEN (arl.EntryType = 2 AND ldCredit.LiabilityOwner > 0 AND ldDebit.PayerCreditUid IS NOT NULL) THEN ldDebit.Amount ELSE 0 END) as InsPayerCreditDistributions,  -- Total distributions from an insurance payer credit
            SUM(CASE WHEN (arl.EntryType = 2 AND ldCredit.LiabilityOwner = 0 AND ldDebit.PayerCreditUid IS NOT NULL) THEN ldDebit.Amount ELSE 0 END) as PtPayerCreditDistributions, -- Total distributions from an patient payer credit
            -- Adjustments ( 3 types: 1) Insurance Adjustments 2) Patient Adjustments
			SUM(CASE WHEN (arl.EntryType = 3 AND ldCredit.LiabilityOwner > 0) THEN ldDebit.Amount ELSE 0 END) as InsAdjustment,	
			SUM(CASE WHEN (arl.EntryType = 3 AND ldCredit.LiabilityOwner = 0) THEN ldDebit.Amount ELSE 0 END) as PatientAdjustment,
			-- Transfers ( 2 types: 1) Carrier to Carrier 2) Patient to Carrier ( or vice-versa )
			SUM(CASE WHEN (arl.EntryType = 4 AND lct.TransactionTypeUid = ''28A84E67-A2A0-48E4-93BA-EF49607EAD17'') -- Patient Transfer
					 THEN ldDebit.Amount ELSE 0 END) AS PatientTransfer,
			SUM(CASE WHEN (arl.EntryType = 4 AND lct.TransactionTypeUid = ''EE9A074D-5660-400C-9975-2F961A38D7B2'')  -- Carrier Transfer
					 THEN ldDebit.Amount ELSE 0 END) AS InsTransfer,
			-- Count of all distributions, adjustments, and transfers in this transaction
			COUNT_BIG(*) AS Count	
	from dbo.AR_Transaction art
			inner join dbo.AR_Ledger arl on art.TransactionUid = arl.TransactionUid
			inner join dbo.AR_LedgerDetail ldDebit on arl.LedgerUid = ldDebit.LedgerUid
													AND ldDebit.IsCredit = 0
			inner join dbo.AR_LedgerDetail ldCredit on arl.LedgerUid = ldCredit.LedgerUid
													AND ldCredit.IsCredit = 1
			inner join dbo.ListCreditType lct on ldDebit.IncomeAccountUid = lct.CreditTypeUid
			inner join dbo.ListMisc lm on lct.TransactionTypeUid = lm.MiscUid
	group by art.TransactionUid
	
--ALTER VIEW [dbo].[AR_ViewTransactionAggregateSub] 
--WITH SCHEMABINDING
--AS

-- Could NOT use the following indexed view because Credit side does not tell us if it is from a  deposit or payer credit
--select	art.TransactionUid,   
--		-- Payments ( entryType = 0 ) and Charges ( entryType = 1 ) are not part of transactions
--		SUM(CASE WHEN (arl.EntryType = 2 ) THEN -(ldCredit.Amount) ELSE 0 END) AS Distribution,
--		SUM(CASE WHEN (arl.EntryType = 2 AND ldCredit.LiabilityOwner = 0) THEN -(ldCredit.Amount) ELSE 0 END) as PatientDistribution,
--		SUM(CASE WHEN (arl.EntryType = 2 AND ldCredit.LiabilityOwner > 0) THEN -(ldCredit.Amount) ELSE 0 END) as InsDistribution,
--		SUM(CASE WHEN (arl.EntryType = 3 ) THEN -(ldCredit.Amount) ELSE 0 END) AS Adjustment,
--		SUM(CASE WHEN (arl.EntryType = 3 AND ldCredit.LiabilityOwner = 0) THEN -(ldCredit.Amount) ELSE 0 END) as PatientAdjustment,
--		SUM(CASE WHEN (arl.EntryType = 3 AND ldCredit.LiabilityOwner > 0) THEN -(ldCredit.Amount) ELSE 0 END) as InsAdjustment,	
--		SUM(CASE WHEN (arl.EntryType = 4 AND lct.TransactionTypeUid = ''28A84E67-A2A0-48E4-93BA-EF49607EAD17'') -- Patient Transfer
--			     THEN -(ldCredit.Amount) ELSE 0 END) AS PatientTransfer,
--		SUM(CASE WHEN (arl.EntryType = 4 AND lct.TransactionTypeUid = ''EE9A074D-5660-400C-9975-2F961A38D7B2'')  -- Carrier Transfer
--				 THEN -(ldCredit.Amount) ELSE 0 END) AS InsTransfer,
--		COUNT_BIG(*) AS Count	
--from dbo.AR_Transaction art
--		inner join dbo.AR_Ledger arl on art.TransactionUid = arl.TransactionUid
--		--inner join dbo.AR_LedgerDetail ldDebit on arl.LedgerUid = ldDebit.LedgerUid
--		--										AND ldDebit.IsCredit = 0
--		inner join dbo.AR_LedgerDetail ldCredit on arl.LedgerUid = ldCredit.LedgerUid
--												AND ldCredit.IsCredit = 1
--		inner join dbo.ListCreditType lct on ldCredit.IncomeAccountUid = lct.CreditTypeUid
--		--inner join dbo.ListMisc lm on lct.TransactionTypeUid = lm.MiscUid
--group by art.TransactionUid

---- Index for indexed view
--CREATE UNIQUE CLUSTERED INDEX [PK_AR_ViewTransactionAggregateSub_TransactionUid] ON [dbo].[AR_ViewTransactionAggregateSub] 
--(
--	[TransactionUid] ASC
--)WITH (PAD_INDEX  = OFF, STATISTICS_NORECOMPUTE  = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS  = ON, ALLOW_PAGE_LOCKS  = ON) ON [PRIMARY]





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewDepositTransactionAggregate]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[AR_ViewDepositTransactionAggregate]
AS
select art.DepositUid, 
       SUM(vta.InsDistribution + vta.PatientDistribution) as Distribution,
       SUM(vta.PatientDistribution) as PatientDistribution,
       SUM(vta.InsDistribution) as InsDistribution,
       SUM(vta.InsAdjustment + vta.PatientAdjustment) as Adjustment,
       SUM(vta.PatientAdjustment) as PatientAdjustment,
       SUM(vta.InsAdjustment) as InsAdjustment,
       SUM(vta.PatientTransfer) as PatientTransfer,
       SUM(vta.InsTransfer) as InsTransfer
from AR_Transaction art
		inner join AR_ViewTransactionAggregateSub vta on art.TransactionUid = vta.TransactionUid
																			AND art.DepositUid IS NOT NULL
GROUP BY art.DepositUid





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindProviderDefaultSIG]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ViewFindProviderDefaultSIG](
   @FormularyVendorUid           UNIQUEIDENTIFIER,
   @FormularyIdentifierUid       UNIQUEIDENTIFIER,
   @FormularyOrgUid              UNIQUEIDENTIFIER,
   @FormularyAlternativesOrgUid  UNIQUEIDENTIFIER,
   @FormularyCopayOrgUid         UNIQUEIDENTIFIER,
   @FormularyCoverageOrgUid      UNIQUEIDENTIFIER,
   @PatienteRxEligibilityUid     UNIQUEIDENTIFIER)
RETURNS TABLE AS
RETURN (
   SELECT
      ProviderDefaultSigUid      = sig.ProviderDefaultSigUid,
      ProviderUid                = sig.ProviderUid,
      ExternalID                 = sig.ExternalID,
      Name                       = sig.Name,
      Notes                      = sig.Notes,
      Inactive                   = sig.Inactive,
      FormularyProdFormuStatName = NULL,
      PreferredSort              = NULL,
      FormularyProdFormuCostName = NULL,
      RelativeCostSort           = NULL,
      NDC                        = pkg.pmid,
      CopayRetail                = NULL,
      CopayMail                  = NULL,
      CopaySpecialty             = NULL,
      CopayLongTerm              = NULL,
      CoverageRestrictions       = NULL,
      IsAlternative              = 0,
      DrugTypeDesc               = dbo.DispensableDrugTypeDesc(dis.medid, pkg.pmid, dea.federaldeaclasscode, dis.nametypecode, dis.refmultisourcecode, dis.reffederallegendcode, dis.medicaldeviceind, dis.refgenericdrugnamecode),
      coalesce(dbo.UDF_getFormattedInternalName(provider.FirstName, provider.MiddleName , provider.LastName, provider.AkaFirstName, provider.AkaLastName), '''') as ProviderName
   FROM dbo.ProviderDefaultSig sig
   LEFT OUTER JOIN dbo.fdb_dispensable dis ON dis.medid = sig.FDB_MEDID
   LEFT JOIN Person provider ON sig.ProviderUid = provider.PersonUid
   OUTER APPLY (
      SELECT TOP 1 pkg.pmid, pkg.federaldeaclasscode
      FROM dbo.fdb_packageddrug pkg
      WHERE pkg.medid = dis.medid
      ORDER BY
         CASE WHEN dis.reffederaldeaclasscode = ''6'' AND pkg.obsoletedate < DATEADD(yy, -3, GETUTCDATE()) THEN 99 ELSE 0 END,
         CASE WHEN dis.reffederaldeaclasscode = ''6'' AND pkg.federaldeaclasscode IN(''1'',''2'',''3'',''4'',''5'') THEN pkg.federaldeaclasscode ELSE 99 END,
         ISNULL(pkg.obsoletedate, ''99990101'') desc,
         pkg.unitdosepackagingind,
         pkg.repackagerind,
         pkg.privlabeledprodind,
         pkg.standardpackind DESC,
         pkg.packagesize,
         pkg.pmid) pkg
   OUTER APPLY (
      SELECT federaldeaclasscode = CASE WHEN dis.reffederaldeaclasscode = ''6'' AND pkg.federaldeaclasscode IN(''0'',''1'',''2'',''3'',''4'',''5'')
                                        THEN pkg.federaldeaclasscode
                                        ELSE dis.reffederaldeaclasscode
                                   END) dea
)
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewSuperbillProcedureAggregateSub]'))
EXEC dbo.sp_executesql @statement = N'


/* 09/05/2014 - kculberth - added NOLOCKs to prevent statements from causing deadlocks  */
CREATE VIEW [dbo].[AR_ViewSuperbillProcedureAggregateSub] WITH SCHEMABINDING
AS  
SELECT PE.PersonUid, AC.AccountUid, SB.SuperbillUid, SBP.SuperbillProcedureUid,           
            SUM(CASE WHEN (L.EntryType = 1 OR L.EntryType = 4) THEN LD.AMOUNT ELSE 0 END) As Liability,         
            SUM(CASE WHEN (L.EntryType = 1 OR L.EntryType = 4) AND NOT LD.LiabilityOwner IS NULL AND LD.LiabilityOwner > 0 THEN LD.AMOUNT ELSE 0 END) As AssignedLiability,        
            SUM(CASE WHEN L.EntryType = 2 THEN LD.AMOUNT*-1 ELSE 0 END) As Distribution,        
            SUM(CASE WHEN L.EntryType = 2 AND NOT LD.LiabilityOwner IS NULL AND LD.LiabilityOwner > 0  THEN LD.AMOUNT*-1 ELSE 0 END) As AssignedDistribution,        
            SUM(CASE WHEN L.EntryType = 3 THEN LD.AMOUNT*-1 ELSE 0 END) As Adjustment,        
            SUM(CASE WHEN L.EntryType = 3 AND NOT LD.LiabilityOwner IS NULL AND LD.LiabilityOwner > 0 THEN LD.AMOUNT*-1 ELSE 0 END) As AssignedAdjustment,        
            SUM(LD.Amount) As LiabilityBalance,         
            SUM(CASE WHEN NOT LD.LiabilityOwner IS NULL AND LD.LiabilityOwner > 0 THEN LD.Amount ELSE 0 END) As AssignedLiabilityBalance,   
			SUM(CASE WHEN  LD.LiabilityOwner = 1 THEN LD.AMOUNT ELSE 0 END) As AssignedPrimaryLiabilityBalance,  
			SUM(CASE WHEN  LD.LiabilityOwner = 2 THEN LD.AMOUNT ELSE 0 END) As AssignedSecondaryLiabilityBalance,
			SUM(CASE WHEN  LD.LiabilityOwner = 3 THEN LD.AMOUNT ELSE 0 END) As AssignedTertiaryLiabilityBalance,
			SUM(CASE WHEN  LD.LiabilityOwner = 4 THEN LD.AMOUNT ELSE 0 END) As AssignedQuaternaryLiabilityBalance,    
            COUNT_BIG(*) AS Count  
      FROM dbo.AR_LedgerDetail (NOLOCK) LD  
            INNER JOIN dbo.AR_Ledger (NOLOCK) L ON LD.LedgerUid = L.LedgerUid  
            INNER JOIN dbo.SuperbillProcedure (NOLOCK) SBP  ON LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid
            INNER JOIN dbo.Superbill (NOLOCK) SB  ON SBP.SuperbillUid = SB.SuperbillUid
            INNER JOIN dbo.Account (NOLOCK) AC  ON SB.AccountUid = AC.AccountUid
            INNER JOIN dbo.Person (NOLOCK) PE ON AC.PersonUid = PE.PersonUid
      WHERE NOT LD.SuperbillProcedureUid IS NULL   
      GROUP BY PE.PersonUid, AC.AccountUid, SB.SuperbillUid, SBP.SuperbillProcedureUid     





' 
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewSuperbillProcedureAggregateSub]') AND name = N'PK_AR_ViewSuperbillProcedureAggregateSub_SuperbillProcedureUid')
CREATE UNIQUE CLUSTERED INDEX [PK_AR_ViewSuperbillProcedureAggregateSub_SuperbillProcedureUid] ON [dbo].[AR_ViewSuperbillProcedureAggregateSub]
(
	[SuperbillProcedureUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewAccountAggregate]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[AR_ViewAccountAggregate] 
AS
SELECT AC.AccountUid,
      SUM(ISNULL(VSPAB.Liability,0)) AS Liability, SUM(ISNULL(VSPAB.AssignedLiability,0)) AS AssignedLiability,
      SUM(ISNULL(VSPAB.LiabilityBalance,0)) AS LiabilityBalance, SUM(ISNULL(VSPAB.AssignedLiabilityBalance,0)) AS AssignedLiabilityBalance,
      SUM(ISNULL(VSPAB.LiabilityBalance,0)) - SUM(ISNULL(VSPAB.AssignedLiabilityBalance,0)) AS UnassignedLiabilityBalance
FROM Account AC WITH (NOLOCK)
LEFT JOIN AR_ViewSuperbillProcedureAggregateSub (NOEXPAND) VSPAB ON AC.AccountUid = VSPAB.AccountUid
GROUP BY AC.AccountUid

-- NOTICE:  This returns a set of values DIFFERENT from the OLDER ViewArAccountAggregate
-- In the case of an account credit, in the OLD, this is reflected in ViewArAccountAggregate
-- Now, this gets reflected in the ResponsibleParty aggregate and will NOT be reflected here ... this is INTENTIONAL
-- Added calculated UnassignedLiabilityBalance for Demographics Patient Balance



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[SuperbillsInAutomatedCollections]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[SuperbillsInAutomatedCollections]

AS

	SELECT NEWID() as SuperbillsInAutomatedCollectionsUid, AC.AccountResponsiblePartyUid, 
			AC.AccountUid, SB.SuperbillUid
		FROM Superbill SB 
			INNER JOIN Account AC ON SB.AccountUid = AC.AccountUid
		WHERE NOT SB.DateEnteredAutomatedCollections IS NULL
			  AND SB.DateLeftAutomatedCollections IS NULL

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDFViewFindAccountsInCollection]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
/*
	This is used by Framework AccountResponsibleContentSource for collection letters
	BMR 2012-12-11 Removed ViewArAccountAggregate which was baased upon ARContext to AR_ViewAccountAggregate
*/

CREATE FUNCTION [dbo].[UDFViewFindAccountsInCollection]
(@AccountResponsiblePartyUid uniqueidentifier)
RETURNS TABLE AS
RETURN 
	(
		SELECT DISTINCT
			Account.AccountUid,
			Account.Name as AccountName,
			Person.Prefix, 
			Person.FirstName, 
			Person.MiddleName, 
			Person.LastName, 
			Person.Suffix,
			Patient.MedicalRecordNumber,
			vaaa.UnassignedLiabilityBalance AS PersonBalance,
			(	SELECT Min(DateEnteredAutomatedCollections) 
					FROM Superbill s 
					WHERE s.AccountUid = Account.AccountUid
			) as OldestSuperbillDateEnteredCollections
			FROM SuperbillsInAutomatedCollections
				INNER JOIN Account ON SuperbillsInAutomatedCollections.AccountUid = Account.AccountUid
				INNER JOIN AR_ViewAccountAggregate vaaa ON Account.AccountUid = vaaa.AccountUid
				INNER JOIN Person ON Account.PersonUid = Person.PersonUid
				INNER JOIN Patient ON Person.PersonUid = Patient.PersonUid
			WHERE SuperbillsInAutomatedCollections.AccountResponsiblePartyUid = @AccountResponsiblePartyUid
	)


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindUserAndUserGroup]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW	[dbo].[ViewFindUserAndUserGroup] AS
SELECT		lug.UserGroupUId AS UId, lug.ExternalID, 
			CAST(NULL AS NVARCHAR(50)) as LoginID, 
			lug.Inactive, lug.Name, 
			lug.Name as LastName, CAST(NULL AS NVARCHAR(50)) AS FirstName, 
			CAST(NULL AS NVARCHAR(50)) AS MiddleName,
			CAST(NULL AS NVARCHAR(50)) AS AkaFirstName,
			CAST(NULL AS NVARCHAR(50)) AS AkaLastName,
			lug.Notes, 2 AS ForeignKeyIndex, ''Group'' AS [UserGroupType], 
			CASE WHEN lug.UserGroupTypeUid = ''10101010-0000-0000-0000-000000000001'' THEN 1 ELSE 0 END AS IsCareTeamGroupOrProvider
FROM		dbo.ListUserGroup lug
UNION ALL
SELECT		u.PersonUId AS UId, COALESCE(u.ExternalID, u.Login) AS ExternalID, 
			u.Login as LoginID, u.Inactive, 
			p.FormattedInternalName AS Name,
			p.LastName, p.FirstName, p.MiddleName, p.AkaFirstName, p.AkaLastname,
			per.[Notes], 1 AS ForeignKeyIndex, ''User'' AS [UserGroupType], 
			CASE WHEN prov.PersonUid IS NULL THEN 0 ELSE 1 END AS IsCareTeamGroupOrProvider
FROM        dbo.UserPRM u 
			INNER JOIN dbo.ViewPerson p (NOEXPAND) ON u.PersonUId = p.PersonUId 
			INNER JOIN [dbo].[Person] AS per ON p.[PersonUid] = per.[PersonUid]
			LEFT JOIN Provider prov ON u.PersonUid = prov.PersonUid
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDFViewFindSuperbillsInCollection]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[UDFViewFindSuperbillsInCollection]
(@AccountResponsiblePartyUid uniqueidentifier)
RETURNS TABLE AS RETURN 
	(
		SELECT
			Superbill.SuperbillUid,
			Superbill.ExternalID,
			Person.Prefix, 
			Person.FirstName, 
			Person.MiddleName, 
			Person.LastName, 
			Person.Suffix,
			Patient.MedicalRecordNumber,
			Superbill.ServiceDateStart,
			Superbill.ServiceDateEnd,
			dbo.GetSuperbillBalanceAll(Superbill.SuperbillUid) AS SuperbillBalance
			FROM SuperbillsInAutomatedCollections
				INNER JOIN Superbill ON SuperbillsInAutomatedCollections.SuperbillUid = Superbill.SuperbillUid
				INNER JOIN Account ON Superbill.AccountUid = Account.AccountUid
				INNER JOIN Person ON Account.PersonUid = Person.PersonUid
				INNER JOIN Patient ON Person.PersonUid = Patient.PersonUid
			WHERE SuperbillsInAutomatedCollections.AccountResponsiblePartyUid = @AccountResponsiblePartyUid
	)' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillProcedure_IsVoid]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[ViewSuperbillProcedure_IsVoid]
AS

WITH cteSuperbillProcedures AS -- this seems to reduce sql reads (possibly it cannot optimize fact that only single field gets used?)
(
	SELECT SuperbillProcedureUid
		FROM SuperbillProcedure WITH (NOLOCK)
),
 cteSupperbillProceduresWithLedgers AS
(
	SELECT DISTINCT LD.SuperbillProcedureUid, L_VOID.LedgerUid AS VoidingLedgerUid
		FROM AR_LedgerDetail LD WITH (NOLOCK) 
				LEFT JOIN AR_Ledger L WITH (NOLOCK) ON LD.LedgerUid = L.LedgerUid  
					LEFT JOIN AR_Ledger L_VOID WITH (NOLOCK) ON L.LedgerUid = L_Void.VoidLedgerUid
		WHERE LD.IsCredit = 0 AND LD.Amount >= 0 -- debit side only with amount >= 0
			AND L.VoidLedgerUid IS NULL AND L.EntryType IN (1,4) -- not voiding and (CHARGE or TRANSFER)
),
cteSupperbillProceduresWithLedgersNotVoid AS 
(
SELECT SBPWL.SuperbillProcedureUid, 1 AS HasFinancials -- superbill procedures with non voided charges
	FROM cteSupperbillProceduresWithLedgers SBPWL 
	WHERE SBPWL.VoidingLedgerUid IS NULL
UNION
SELECT SBP.SuperbillProcedureUid, 0 AS HasFinanicals -- superbill procedures without any charges
	FROM cteSuperbillProcedures SBP
		LEFT JOIN cteSupperbillProceduresWithLedgers SBPWL ON SBP.SuperbillProcedureUid = SBPWL.SuperbillProcedureUid
	WHERE SBPWL.SuperbillProcedureUid IS NULL
)
SELECT DISTINCT SBP.SuperbillProcedureUid, 
		CASE WHEN NOT SBPWLNV.SuperbillProcedureUid IS NULL THEN 0 ELSE 1 END AS IsVoid, -- if not in non voided list, they are voided
		CASE WHEN SBPWLNV.SuperbillProcedureUid IS NULL OR SBPWLNV.HasFinancials = 1  THEN 1 ELSE 0 END AS HasFinanicals -- flag for wether they have any charges at all (claims)
	FROM cteSuperbillProcedures SBP
		LEFT JOIN cteSupperbillProceduresWithLedgersNotVoid SBPWLNV ON SBP.SuperbillProcedureUid = SBPWLNV.SuperbillProcedureUid -- these are ''non voided''





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewSuperbillCompleteBatchSub]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[AR_ViewSuperbillCompleteBatchSub]     --WITH SCHEMABINDING
AS
SELECT S.SuperbillUid,SP.SuperbillProcedureUid, CASE WHEN arb.IsClosed=1  OR  arb.IsLocked =1 THEN 1 ELSE 0 END AS CompleteBatch    FROM 
	dbo.AR_Ledger L 
JOIN
	dbo.AR_LedgerDetail LD
ON
	L.LedgerUid = LD.LedgerUid  AND L.EntryType =1
JOIN
	dbo.SuperbillProcedure SP
ON
	LD.SuperbillProcedureUid =SP.SuperbillProcedureUid
LEFT JOIN
   ViewSuperbillProcedure_IsVoid VSPVOID
ON
   VSPVOID.SuperbillProcedureUid=Sp.SuperbillProcedureUid
JOIN
	dbo.Superbill S
ON
	SP.SuperbillUid =S.SuperbillUid 
JOIN
	dbo.ARBatch ARB
ON
	L.ArBatchUid =ARB.ARBatchUid 
WHERE 
    VSPVOID.IsVoid IS NULL OR VSPVOID.IsVoid=0
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewSuperbillCompleteBatch]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[AR_ViewSuperbillCompleteBatch]
AS

SELECT
SuperbillUID,
MIN(CompleteBatch) CompleteBatch
FROM
	dbo.[AR_ViewSuperbillCompleteBatchSub]
GROUP BY
SuperbillUID 	

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindPerson]'))
EXEC dbo.sp_executesql @statement = N'





CREATE VIEW [dbo].[ViewFindPerson] AS
	SELECT	p.PersonUid, p.Inactive, vp.FirstName, vp.MiddleName, vp.LastName, vp.FormattedPreferredName AS FullName, 
			vp.AkaName, p.Birthdate, vp.AkaFirstName, vp.AkaLastName, 
            vp.SocialSecurityNumber,
            pat.ExternalID AS PatientExternalID, arp.ExternalID AS ResponsiblePartyExternalID, 
            vp.Phone1, vp.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''varchar(50)'') AS PhoneNumber, vp.Phone1.value(''(/Phone/PhoneType)[1]'', ''varchar(100)'') as PhoneTypeName,
            vp.Phone2, vp.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''varchar(50)'') AS PhoneNumber2, vp.Phone1.value(''(/Phone/PhoneType)[1]'', ''varchar(100)'') as PhoneTypeName2,
            vp.Phone3, vp.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''varchar(50)'') AS PhoneNumber3, vp.Phone1.value(''(/Phone/PhoneType)[1]'', ''varchar(100)'') as PhoneTypeName3,
            vp.Phone4, vp.Phone1.value(''(/Phone/PhoneNumber)[1]'', ''varchar(50)'') AS PhoneNumber4, vp.Phone1.value(''(/Phone/PhoneType)[1]'', ''varchar(100)'') as PhoneTypeName4,
            vp.Address1 AS Address1Xml, vp.Address1.value(''(/Address/Address1)[1]'', ''varchar(100)'') AS Address1,
            vp.Address1.value(''(/Address/Address2)[1]'', ''varchar(100)'') AS Address2,
            vp.Address1.value(''(/Address/City)[1]'', ''varchar(100)'') AS City,
            vp.Address1.value(''(/Address/State)[1]'', ''varchar(100)'') AS State,
            vp.Address1.value(''(/Address/Zip)[1]'', ''varchar(100)'') AS Zip,                      
            cast(isnull(arp.ScheduledPaymentAllowed,0) AS bit) as ScheduledPaymentAllowed ,
            g1.ANSICode AS GenderANSICode
	FROM	Person AS p INNER JOIN
			ViewPerson AS vp ON p.PersonUid = vp.PersonUid LEFT OUTER JOIN
			ListGender AS g1 ON p.GenderUid = g1.GenderUid LEFT OUTER JOIN
			Patient AS pat ON p.PersonUid = pat.PersonUid LEFT OUTER JOIN
			AccountResponsibleParty AS arp ON p.PersonUid = arp.PersonUid






' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[InternalFindDispensable]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[InternalFindDispensable] AS

	SELECT [DispensableUid]
		  ,[medid]
		  ,[descdisplay]
		  ,[descsearch]
		  ,[descaltsearch]
		  ,[mnid]
		  ,[DrugNameUid]
		  ,[rtid]
		  ,[RouteUid]
		  ,[dfid]
		  ,[DoseFormUid]
		  ,[strength]
		  ,[strengthunits]
		  ,[rmid]
		  ,[rdfmid]
		  ,[gcnseqno]
		  ,[rtgenid]
		  ,[hicl]
		  ,[genericlinkindicator]
		  ,[nametypecode]
		  ,[namesourcecode]
		  ,[genderspecificdrugcode]
		  ,[reffederallegendcode]
		  ,[refmultisourcecode]
		  ,[reffederaldeaclasscode]
		  ,[refgenericdrugnamecode]
		  ,[refgenericcomppricecode]
		  ,[refgenericpricespreadcode]
		  ,[refinnovatorcode]
		  ,[refgenerictheraequivcode]
		  ,[refdesicode]
		  ,[refdesi2code]
		  ,[singleingredientind]
		  ,[medicaldeviceind]
		  ,[obsoletedate]
		  ,[replacedindicator]
		  ,[singledoserouteind]
		  ,[haspackageddrugsind]
		  ,[hasequivpackageddrugsind]
		  ,[hasimagesind]
		  ,[genericmnid]
		  ,[genericmedid]
		  ,[refrepackagercode]
		  ,[refprivlabeledprodcode]
		  ,[statuscode]
		  ,[numstrength]
		  ,[numstrengthuom]
		  ,[numvolume]
		  ,[numvolumeuom]
		  ,[ExternalID]
		  ,[Notes] = CONVERT(varchar(max), dis.Notes)
		  ,[Inactive]
		  ,[LastModifiedDate]
		  ,[LastModifiedByUid]
		  ,[UserDefined]
	  FROM FDB_Dispensable dis
	UNION ALL
	SELECT [DispensableUid] = lm.MedicationUid
		  ,[medid]  = null
		  ,[descdisplay] = lm.descdisplay
		  ,[descsearch] = lm.descsearch
		  ,[descaltsearch] = null
		  ,[mnid] = null
		  ,[DrugNameUid] = null
		  ,[rtid] = null
		  ,[RouteUid] = lm.RouteUid
		  ,[dfid] = null
		  ,[DoseFormUid] = lm.DoseFormUid
		  ,[strength] = lm.Strength
		  ,[strengthunits] = lm.StrengthUnits
		  ,[rmid] = null
		  ,[rdfmid] = null
		  ,[gcnseqno] = null
		  ,[rtgenid] = null
		  ,[hicl] = null
		  ,[genericlinkindicator] = null
		  ,[nametypecode] = null
		  ,[namesourcecode] = null
		  ,[genderspecificdrugcode] = null
		  ,[reffederallegendcode] = null
		  ,[refmultisourcecode] = null
		  ,[reffederaldeaclasscode] = null
		  ,[refgenericdrugnamecode] = null
		  ,[refgenericcomppricecode] = null
		  ,[refgenericpricespreadcode] = null
		  ,[refinnovatorcode] = null
		  ,[refgenerictheraequivcode] = null
		  ,[refdesicode] = null
		  ,[refdesi2code] = null
		  ,[singleingredientind] = null
		  ,[medicaldeviceind] = null
		  ,[obsoletedate] = null
		  ,[replacedindicator] = null
		  ,[singledoserouteind] = null
		  ,[haspackageddrugsind] = null
		  ,[hasequivpackageddrugsind] = null
		  ,[hasimagesind] = null
		  ,[genericmnid] = null
		  ,[genericmedid] = null
		  ,[refrepackagercode] = null
		  ,[refprivlabeledprodcode] = null
		  ,[statuscode] = ''0''
		  ,[numstrength] = null
		  ,[numstrengthuom] = null
		  ,[numvolume] = null
		  ,[numvolumeuom] = null
		  ,[ExternalID] = lm.ExternalID
		  ,[Notes] = lm.Notes
		  ,[Inactive] = lm.Inactive
		  ,[LastModifiedDate] = lm.LastModifiedDate
		  ,[LastModifiedByUid] = lm.LastModifiedByUid
		  ,[UserDefined] = lm.UserDefined
	FROM ListMedication lm

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindDrugHistory]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ViewFindDrugHistory](@includeBrandName bit = 1,
                                           @includeGenericName bit = 1,
                                           @includeUserDefined bit = 1,
                                           @descSearch varchar(200),
                                           @externalID varchar(50))

RETURNS TABLE

AS

RETURN
(
   SELECT DISTINCT
      DrugUid              = dis.DispensableUid,
      ClassUid             = cls.ClassUid,
      MEDID                = dis.medid,
      MNID                 = nam.mnid,
      HICL                 = (SELECT TOP(1) fmh.hicl FROM fdb_mnid_hicl fmh WHERE fmh.mnid = nam.mnid ORDER BY fmh.hicl),
      RMID                 = null,
      DescDisplay          = dis.descdisplay,
      DescSearch           = dis.descsearch,
      DrugName             = ISNULL(nam.descdisplay, (SELECT lmt.Name FROM ListMedication lmt WHERE lmt.MedicationUid = dis.DispensableUid)),
      Strength             = dis.strength,
      StrengthUnits        = dis.strengthunits,
      DoseForm             = dos.description,
      Route                = rte.Description1,
      NameTypeCode         = dis.nametypecode,
      GenericDrugNameID    = dis.genericmnid,
      GenericDrugName      = gen.descdisplay,
      GCNSeqNo             = dis.gcnseqno,
      FederalDEAClassCode  = dea.federaldeaclasscode,
      ObsoleteDate         = dis.obsoletedate,
      StatusCode           = dis.statuscode,
      ClassID              = cls.classid,
      ClassDescription     = cls.description1,
      ExternalID           = dis.ExternalID,
      Inactive             = dis.Inactive,
      UserDefined          = dis.UserDefined,
      NDC                  = CASE WHEN dis.UserDefined = 1 THEN rxn.NDC ELSE pkg.pmid END,
      RXNORMCode           = CASE WHEN dis.UserDefined = 1 THEN rxn.RxNorm ELSE rxf.RXNORMCode END,
      RXNORMQualifier      = CASE WHEN dis.UserDefined = 1 THEN rxn.RxNormQualifier ELSE rxf.RXNORMQualifier END
   FROM dbo.InternalFindDispensable dis
   LEFT OUTER JOIN dbo.fdb_drugname nam ON nam.DrugNameUid = dis.DrugNameUid
   LEFT OUTER JOIN dbo.fdb_doseform dos ON dos.DoseFormUid = dis.DoseFormUid
   LEFT OUTER JOIN dbo.fdb_route rte ON rte.RouteUid = dis.RouteUid
   LEFT OUTER JOIN dbo.fdb_drugname gen ON gen.mnid = dis.genericmnid
   OUTER APPLY (
      SELECT TOP 1 *
      FROM dbo.RelDispensableRxCodes rxn
      WHERE rxn.DispensableUid = dis.DispensableUid) rxn
   OUTER APPLY (
      SELECT TOP(1)
         RXNORMCode      = rev.EVD_EXT_VOCAB_ID,
         RXNORMQualifier = CASE WHEN rev.EVD_LINK_TYPE_ID = 5 THEN ''SBD'' ELSE ''SCD'' END
      FROM fdb_REVDEL0_EXT_VOCAB_LINK rev
      WHERE rev.EVD_FDB_VOCAB_ID  = CONVERT(varchar(255), dis.medid)
         AND EVD_FDB_VOCAB_TYPE_ID = 3
         AND EVD_LINK_TYPE_ID IN(1, 5)
      ORDER BY CASE dis.nametypecode WHEN ''1'' THEN -rev.EVD_LINK_TYPE_ID ELSE rev.EVD_LINK_TYPE_ID END, EVD_EXT_VOCAB_TYPE_ID) rxf
   OUTER APPLY (
      SELECT TOP(1) cls.*
      FROM dbo.fdb_etclassification_drugs etc
      LEFT OUTER JOIN dbo.fdb_classification_etc cls ON (cls.classid = etc.classid)
      WHERE etc.conceptid = dis.medid
        AND etc.concepttype = 3
        AND etc.classid <> 1130 -- don''t allow bulk chemicals bug #15969
      ORDER BY etc.classid) cls
   OUTER APPLY (
      SELECT TOP(1) pkg.pmid, pkg.federaldeaclasscode
      FROM dbo.fdb_packageddrug pkg
      WHERE pkg.medid = dis.medid
      ORDER BY
         CASE WHEN dis.reffederaldeaclasscode = ''6'' AND pkg.obsoletedate < DATEADD(yy, -3, GETUTCDATE()) THEN 99 ELSE 0 END,
         CASE WHEN dis.reffederaldeaclasscode = ''6'' AND pkg.federaldeaclasscode IN(''1'',''2'',''3'',''4'',''5'') THEN pkg.federaldeaclasscode ELSE 99 END,
         ISNULL(pkg.obsoletedate, ''99990101'') desc,
         pkg.unitdosepackagingind,
         pkg.repackagerind,
         pkg.privlabeledprodind,
         pkg.standardpackind DESC,
pkg.packagesize,
         pkg.pmid) pkg
   OUTER APPLY (
      SELECT federaldeaclasscode = CASE WHEN dis.reffederaldeaclasscode = ''6'' AND pkg.federaldeaclasscode IN(''0'',''1'',''2'',''3'',''4'',''5'')
                                        THEN pkg.federaldeaclasscode
                                        ELSE dis.reffederaldeaclasscode
                                   END) dea
   WHERE (dis.ExternalID LIKE @externalID OR LEN(@externalID) = 0 OR @externalID IS NULL)
     AND (dis.DescSearch LIKE @descSearch OR LEN(@descSearch) = 0 OR @descSearch IS NULL)
     AND ((nam.mnid IS NULL)
       OR (nam.UserDefined > 0 AND nam.nametypecode IS NULL AND @includeUserDefined = 1)
       -- note: column nametypecode is a varchar(1) and can never be ''999''
       OR (nam.nametypecode IN(CASE @includeBrandName WHEN 1 THEN ''1'' ELSE ''999'' END,
                               CASE @includeGenericName WHEN 1 THEN ''2'' ELSE ''999'' END)))

   UNION

   SELECT DISTINCT
      DrugUid              = rdt.RoutedDrugUid,
      ClassUid             = cls.ClassUid,
      MEDID                = 0,
      MNID                 = rdt.mnid,
      HICL                 = (SELECT TOP(1) fmh.hicl FROM fdb_mnid_hicl fmh WHERE fmh.mnid = rdt.mnid ORDER BY fmh.hicl),
      RMID                 = rdt.rmid,
      DescDisplay          = rdt.descdisplay,
      DescSearch           = rdt.descsearch,
      DrugName             = nam.descdisplay,
      Strength             = NULL,
      StrengthUnits        = NULL,
      DoseForm             = NULL,
      Route                = rte.Description1,
      NameTypeCode         = rdt.nametypecode,
      GenericDrugNameID    = rdt.genericmnid,
      GenericDrugName      = rdg.descdisplay,
      GCNSeqNo             = NULL,
      FederalDEAClassCode  = '''',
      ObsoleteDate         = rdt.obsoletedate,
      StatusCode           = rdt.statuscode,
      ClassID              = cls.classid,
      ClassDescription     = cls.description1,
      ExternalID           = NULL,
      Inactive             = rdt.Inactive,
      UserDefined          = rdt.UserDefined,
      NDC                  = NULL,
      RXNORMCode           = dbo.RxNormCode(rdt.mnid),
      RXNORMQualifier      = NULL
   FROM dbo.FDB_RoutedDrug AS rdt
   LEFT OUTER JOIN dbo.FDB_RoutedDrug AS rdg ON rdg.mnid = rdt.genericmnid
                                            AND rdg.rtid = rdt.rtid
   LEFT OUTER JOIN dbo.fdb_route rte ON rte.rtid = rdt.rtid
   LEFT OUTER JOIN dbo.FDB_DrugName nam ON nam.DrugNameUid = rdt.DrugNameUid
   OUTER APPLY (
      SELECT TOP(1) cls.*
      FROM dbo.fdb_etclassification_drugs etc
      LEFT OUTER JOIN dbo.fdb_classification_etc cls ON (cls.classid = etc.classid)
      WHERE etc.conceptid = rdt.mnid
        AND etc.concepttype = 1
        AND etc.classid <> 1130 -- don''t allow bulk chemicals bug #15969

      ORDER BY etc.classid) cls
   WHERE (LEN(@externalID) = 0 OR @externalID IS NULL)
     AND (rdt.DescSearch LIKE @descSearch OR LEN(@descSearch) = 0 OR @descSearch IS NULL)
     AND ((rdt.UserDefined > 0 AND rdt.nametypecode IS NULL AND @includeUserDefined = 1)
       -- note: column nametypecode is a varchar(1) and can never be ''999''
       OR (rdt.nametypecode IN(CASE @includeBrandName WHEN 1 THEN ''1'' ELSE ''999'' END,
                               CASE @includeGenericName WHEN 1 THEN ''2'' ELSE ''999'' END)))
)
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewDepositAggregateSub]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[AR_ViewDepositAggregateSub] WITH SCHEMABINDING
AS
	SELECT LD.DepositUid, 
			SUM(CASE WHEN LD.IsCredit = 0 THEN 0 ELSE LD.AMOUNT*-1 END) As Receipt, 
			SUM(LD.Amount*-1) As ReceiptBalance,
			COUNT_BIG(*) AS COUNT
		FROM dbo.AR_LedgerDetail LD 
		WHERE NOT LD.DepositUid IS NULL
		GROUP BY LD.DepositUid
' 
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewDepositAggregateSub]') AND name = N'PK_AR_ViewDepositAggregateSub_DepositUid')
CREATE UNIQUE CLUSTERED INDEX [PK_AR_ViewDepositAggregateSub_DepositUid] ON [dbo].[AR_ViewDepositAggregateSub]
(
	[DepositUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewDepositAggregate]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[AR_ViewDepositAggregate] 
AS
SELECT DP.DepositUid, 
	ISNULL(VDAS.Receipt, 0) AS Receipt, 
	ISNULL(VDAS.ReceiptBalance, 0) AS ReceiptBalance
FROM Deposit DP
	LEFT JOIN AR_ViewDepositAggregateSub VDAS WITH (NOEXPAND)  ON DP.DepositUid = VDAS.DepositUid 
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewDeposit]'))
EXEC dbo.sp_executesql @statement = N'



CREATE VIEW [dbo].[ViewDeposit]
AS
SELECT
 d.DepositUid,
 d.AppointmentUid,
 CASE WHEN arlVoid.LedgerUid IS NULL THEN 0 ELSE 1 END AS Void,
 CAST((CASE WHEN VDA.Receipt > VDA.ReceiptBalance THEN 1 ELSE 0 END) as bit) AS Credited,
 d.ReferenceNumber AS ReferenceNumber, -- use for search, otherwise cannot optimize when search by deposituid -- Bug 234721
 ISNULL(d.ReferenceNumber, ''<ND>'') AS ReferenceNumberForSpread, -- mark as <ND> so can hyperlink on null values
 VDA.Receipt AS AmountInverse, -- new model this is already inversed
 VDA.Receipt - VDA.ReceiptBalance AS AllocatedAmountInverse, -- new model this is already inversed
 VDA.ReceiptBalance AS UnallocatedAmountInverse,
 LD.AccountResponsiblePartyUid as WhoPaidPersonUid,
 LD.InsurancePayerUid as WhoPaidInsuranceCarrierUid,
 (CASE WHEN p.PersonUid          IS NOT NULL THEN dbo.UDF_getFormattedName(p.Prefix, p.FirstName, p.MiddleName, p.LastName, p.Suffix)
       WHEN icArp.CorporationUid IS NOT NULL THEN icArp.Name
       WHEN LD.InsurancePayerUid IS NOT NULL THEN ic.Name     END) AS WhoPaidName,       
 L.EntryDate as DepositDate,
 d.PaymentTypeUid,
 lpt.Name AS PaymentTypeName,
 d.DepositMacroUid,
 ldm.Name AS DepositMacroName,
 ldm.AppointmentRequired,
 d.LastModifiedByUid,
 dbo.UDF_getFormattedName(up.Prefix, up.FirstName, up.MiddleName, up.LastName, up.Suffix) AS LastModifiedByName,
 d.Comment,
 CAST((CASE WHEN isNull(VDA.ReceiptBalance,0) = 0 THEN 1 ELSE 0 END) as bit) as IsFullyAllocated,
 VDA.Receipt - VDA.ReceiptBalance as TotalPayment,
 (CASE WHEN LD.InsurancePayerUid IS NOT NULL THEN VDT.InsAdjustment ELSE VDT.PatientAdjustment END) AS TotalAdjustment,
 ARB.ARBatchUid,
 ARB.Name as ARBatchName,
 ARB.GLDate as GLDate,
 ARB.IsLocked as IsLocked,
 ARB.IsClosed as IsClosed,
 CASE WHEN ARB.IsClosed = 1 THEN ''Closed'' 
      WHEN ARB.IsLocked = 1 THEN ''Complete''
      ELSE ''Open'' END as BatchState
FROM Deposit d
		INNER JOIN AR_LedgerDetail LD ON d.DepositUid = LD.DepositUid
		INNER JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid
		INNER JOIN ARBatch ARB ON L.ArBatchUid = ARB.ArBatchUid
		LEFT OUTER JOIN AR_Ledger arlVoid on L.LedgerUid = arlVoid.VoidLedgerUid	-- Checks for voiding entries						 	
		INNER JOIN AR_ViewDepositAggregate VDA ON d.deposituid = vda.deposituid
		LEFT JOIN AccountResponsibleParty arp on LD.AccountResponsiblePartyUid = arp.AccountResponsiblePartyUid		 
		LEFT JOIN Person p ON arp.PersonUid = p.PersonUid 
		LEFT JOIN Corporation icArp ON arp.CorporationUid = icArp.CorporationUid
		LEFT JOIN Corporation ic ON ic.CorporationUid = LD.InsurancePayerUid 
		LEFT JOIN ListPaymentType lpt ON lpt.PaymentTypeUid = d.PaymentTypeUid 
		LEFT JOIN ListDepositMacro ldm ON ldm.DepositMacroUid = d.DepositMacroUid 
		LEFT JOIN Person up ON up.PersonUid = d.LastModifiedByUid
		LEFT JOIN AR_ViewDepositTransactionAggregate VDT  ON d.DepositUid = VDT.depositUid
WHERE L.EntryType = 0 -- Payment
			AND L.VoidLedgerUid IS NULL	-- Don''t include reversing(void) entries
			AND LD.IsCredit = 1							 	
			AND LD.PayerCreditUid IS NULL -- Don''t include payer account credits
 



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewCarePlanCCDA]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ViewCarePlanCCDA](@VisitUid UNIQUEIDENTIFIER)
RETURNS TABLE AS RETURN
SELECT
   Uid              = vp.VisitProcedureUid,
   PatientUid       = v.PatientUid,
   VisitUid         = vp.VisitUid,
   ProviderUid      = v.ProviderUid,
   ProviderName     = dbo.UDF_getFormattedName(prv.Prefix, prv.FirstName, prv.MiddleName, prv.LastName, prv.Suffix),
   ProviderAddress  = prv.Address1,
   ProviderPhone    = prv.Phone1,
   CarePlanType     = ''Procedure'',
   CarePlanDate     = COALESCE(obo.PerformDate, obo.OrderDate),
   FutureDate       = COALESCE(obo.PerformDate, obo.OrderDate),
   OrderDate        = obo.OrderDate, 
   PerformDate      = obo.PerformDate,
   ResultStatus     = sts.Name,
   Description      = prc.ShortDescription,
   CPT              = prc.Code,
   LOINC            = lnc.Name,
   SnomedConceptID  = prc.SnomedConceptID,   
   ProcedureUid     = prc.ProcedureUid,
   ObservationUid   = obs.ObservationUid,
   ObservationDesc  = obs.Name,
   Notes			= vp.Notes
FROM Visit v 
INNER JOIN Person prv ON prv.PersonUid = v.RenderingProviderUid
INNER JOIN VisitProcedure vp ON vp.VisitUid = v.VisitUid
LEFT JOIN ObservationOrder obo ON obo.VisitProcedureUid = vp.VisitProcedureUid
LEFT JOIN ListObservationOrderResultStatus sts ON sts.ObservationOrderResultStatusUid = obo.ObservationOrderResultStatusUid
LEFT JOIN ListProcedure prc ON prc.ProcedureUid = vp.ProcedureUid
LEFT JOIN ListObservation obs ON obs.ObservationUid = obo.ObservationUid
LEFT JOIN ListLOINC lnc ON lnc.LOINCUid = obs.LOINCUid
WHERE obo.ResultDate IS NULL
  AND ((obo.ResultStatusID BETWEEN 1 AND 6) OR (obo.ResultStatusID IS NULL))
  AND vp.IsDelete = 0
  AND vp.IsPerformed = 0
  AND v.VisitUid = @VisitUid

UNION ALL

SELECT
   Uid              = vef.VisitEduFormUid,
   PatientUid       = v.PatientUid,
   VisitUid         = v.VisitUid,
   ProviderUid      = v.ProviderUid,
   ProviderName     = dbo.UDF_getFormattedName(prv.Prefix, prv.FirstName, prv.MiddleName, prv.LastName, prv.Suffix),
   ProviderAddress  = prv.Address1,
   ProviderPhone    = prv.Phone1,
   CarePlanType     = ''EduForm'',
   CarePlanDate     = v.VisitDate,
   FutureDate       = NULL, 
   OrderDate        = v.VisitDate, 
   PerformDate      = v.VisitDate,
   ResultStatus     = ''Completed'',
   Description      = COALESCE(vef.Name, lef.Name, rpt.Name),
   CPT              = NULL,
   LOINC            = NULL,
   SnomedConceptID  = NULL,   
   ProcedureUid     = NULL,
   ObservationUid   = NULL,
   ObservationDesc  = NULL,
   Notes			= vef.Notes
FROM VisitEduForm vef
INNER JOIN Visit v ON v.VisitUid = vef.VisitUid
INNER JOIN Person prv ON prv.PersonUid = v.RenderingProviderUid
LEFT JOIN ListEduForm lef ON lef.EduFormUid = vef.EduFormUid
LEFT JOIN ListReport rpt ON rpt.ReportUid = vef.ReportUid
WHERE vef.VisitUid = @VisitUid

UNION ALL 

SELECT
   Uid              = a.AppointmentUid,
   PatientUid       = v.PatientUid,
   VisitUid         = v.VisitUid,
   ProviderUid      = a.ProviderUid,
   ProviderName     = dbo.UDF_getFormattedName(prv.Prefix, prv.FirstName, prv.MiddleName, prv.LastName, prv.Suffix),
   ProviderAddress  = prv.Address1,
   ProviderPhone    = prv.Phone1,
   CarePlanType     = ''Appointment'',
   CarePlanDate     = a.StartDateTime,
   FutureDate       = a.StartDateTime, 
   OrderDate        = NULL, 
   PerformDate      = NULL,
   ResultStatus     = lat.Name,
   Description      = a.Reason,
   CPT              = NULL,
   LOINC            = NULL,
   SnomedConceptID  = NULL,   
   ProcedureUid     = NULL,
   ObservationUid   = NULL,
   ObservationDesc  = NULL,
   Notes			= a.Notes
from Appointment a
INNER JOIN ListAppointmentType lat ON lat.AppointmentTypeUid = a.AppointmentTypeUid
INNER JOIN Person prv ON prv.PersonUid = a.ProviderUid
CROSS JOIN Visit v 
WHERE v.PatientUid = a.PatientUid
  AND (v.AppointmentUid IS NULL OR v.AppointmentUid != a.AppointmentUid)
  AND a.StartDateTime > v.VisitDate
  AND v.VisitUid = @VisitUid

UNION ALL

SELECT
   Uid              = pob.PatientReferralUid, 
   PatientUid       = v.PatientUid,
   VisitUid         = v.VisitUid,
   ProviderUid      = ppr.ProviderUid,
   ProviderName     = ISNULL(dbo.UDF_getFormattedName(prv.Prefix, prv.FirstName, prv.MiddleName, prv.LastName, prv.Suffix), msp.Name),
   ProviderAddress  = ISNULL(prv.Address1, msp.Address),
   ProviderPhone    = ISNULL(prv.Phone1, msp.Phone1),
   CarePlanType     = ''Referral'',
   CarePlanDate     = pob.AppointmentDate,
   FutureDate       = pob.AppointmentDate, 
   OrderDate        = NULL, 
   PerformDate      = NULL,
   ResultStatus     = sts.Name,
   Description      = ISNULL(ppr.Notes, ''Referral''),
   CPT              = NULL,
   LOINC            = NULL,
   SnomedConceptID  = NULL,   
   ProcedureUid     = NULL,
   ObservationUid   = NULL,
   ObservationDesc  = NULL,
   Notes			= pob.Notes
FROM PatientReferral pob 
INNER JOIN PatientProviderRelationship ppr ON (pob.PatientProviderRelationshipUid = ppr.PatientProviderRelationshipUid)
INNER JOIN ListReferralTrackingStatus sts ON sts.ReferralTrackingStatusUid = pob.ReferralTrackingStatusUid
LEFT JOIN Person prv ON prv.PersonUid = ppr.ProviderUid
LEFT JOIN Corporation msp ON msp.CorporationUid = ppr.MedicalServicesProviderUid
CROSS JOIN Visit v
WHERE v.PatientUid = ppr.PatientUid
  AND pob.AppointmentDate > v.VisitDate
  AND v.VisitUid = @VisitUid




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewPersonInsurancePlan]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewPersonInsurancePlan]
AS
SELECT     pip.PersonInsurancePlanUid, pip.PersonUid, pip.CorporationUid, pip.CopayPrimary, pip.PlanMemberID, pip.PlanGroupID, pip.EffectiveDate, 
                      pip.ExpirationDate, COALESCE (c.Name, p.LastName + '', '' + p.FirstName) AS Insured, vpp.PayerName, vpp.PlanName, vpp.PlanAddress1, 
                      vpp.PlanAddress2, vpp.PlanCity, vpp.PlanState, vpp.PlanZip, vpp.PayerPlanName
FROM         dbo.PersonInsurancePlan AS pip LEFT OUTER JOIN
                      dbo.Person AS p ON p.PersonUid = pip.PersonUid LEFT OUTER JOIN
                      dbo.Corporation AS c ON c.CorporationUid = pip.CorporationUid LEFT OUTER JOIN
                      dbo.ViewPayerPlan AS vpp ON vpp.InsurancePlanUid = pip.InsurancePlanUid

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewAccountPersonInsurancePlan]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ViewAccountPersonInsurancePlan](@date DATE) RETURNS TABLE AS RETURN
(
	SELECT	pip.PersonInsurancePlanUid, a.PersonUid AS PatientUid, a.AccountUid, ap.AccountPeriodUid,
			ap.EffectiveDate, ap.ExpirationDate, ap.AccountTypeUid, ap.PayorPlanSetUid,
			ai.DisplayOrder, pip.Insured, ai.AccountInsuranceUid,
			COALESCE(pip.PersonUid, pip.CorporationUid) AS InsuredUid,
			pip.CopayPrimary, pip.PlanMemberID, pip.PlanGroupID,
			pip.PayerName, pip.PlanName, pip.PayerPlanName,
			pip.PlanAddress1, pip.PlanAddress2, pip.PlanCity, pip.PlanState, pip.PlanZip			
	FROM	Account a INNER JOIN AccountPeriod ap ON ap.AccountPeriodUid = dbo.GetAccountPeriod(a.AccountUid, @date)
			INNER JOIN AccountInsurance ai ON ap.AccountPeriodUid = ai.AccountPeriodUid
			INNER JOIN ViewPersonInsurancePlan pip ON ai.PersonInsurancePlanUid = pip.PersonInsurancePlanUid
)

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_ViewPatientBP]'))
EXEC dbo.sp_executesql @statement = N'
--20160217  kculberth change NOLOCKs to WITH NOLOCKs

CREATE VIEW [dbo].[MDOL_RPT2_ViewPatientBP]
AS
SELECT OO.PatientUid
	,COALESCE(OO.PerformDateTime, dbo.UDF_utcToCurrentDate(V.VisitDate), OO.PerformDateTime, OO.PerformDate) AS MeasureDate
	,Metricvalue1
	,Metricvalue2
FROM ObservationValue OV WITH (NOLOCK)
INNER JOIN ObservationOrder OO WITH (NOLOCK) ON OV.ObservationOrderUid = OO.ObservationOrderUid
	AND OO.IsDelete = 0
LEFT JOIN Visit V WITH (NOLOCK) ON V.VisitUid = OV.VisitUid
WHERE (
		ObservationItemuid = ''00000000-0000-0000-7777-100000000073''
		OR ObservationItemuid = ''00000000-0000-0000-7777-100000000074''
		)
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[getPatientVitalInfo]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'

CREATE FUNCTION [dbo].[getPatientVitalInfo]
(@PatientUid uniqueidentifier, @StartDate datetime,@EndDate datetime)
RETURNS table
AS
	RETURN 
(
	Select
		PatientUid,
		MAX(MeasureDate) AS MeasureDate,
		[dbo].[getPatientBp2](PatientUid,@StartDate,@EndDate,''S'') SystolicBP,
		[dbo].[getPatientBp2](PatientUid,@StartDate,@EndDate,''D'') DiastolicBP 
	 From
		[MDOL_RPT2_ViewPatientBP]
	 Where 
		(@StartDate IS NULL OR MeasureDate  >= @StartDate) AND (@EndDate IS NULL OR MeasureDate  <@EndDate) and PatientUid =@PatientUid
	 Group By
	   PatientUid
)
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_ViewExternalDataReporting]'))
EXEC dbo.sp_executesql @statement = N'
--20160217  kculberth change NOLOCKs to WITH NOLOCKs

CREATE view [dbo].[MDOL_RPT2_ViewExternalDataReporting]
AS
select        externaldatareportinguid,
              xmldata.value(''(descendant::AuditType)[1]'', ''varchar(50)'') as AuditType, 
              RTRIM(xmldata.value(''(descendant::AuditSubType)[1]'', ''varchar(50)'')) as AuditSubType, 
              xmldata.value(''(descendant::AuditInstanceUid)[1]'', ''varchar(50)'')as AuditInstanceUid,
              xmldata.value(''(descendant::RelVisitMedicationUid)[1]'', ''varchar(50)'') as RelVisitMedicationUid, 
              xmldata.value(''(descendant::PrmUserUid)[1]'', ''varchar(50)'') as PrmUserUid, 
              xmldata.value(''(descendant::SignerUserName)[1]'', ''varchar(50)'') as PrmUserName, 
              xmldata.value(''(descendant::OSUserName)[1]'', ''varchar(50)'') as OSUserName, 
              xmldata.value(''(descendant::OSWorkstation)[1]'', ''varchar(50)'') as PrmWorkstation, 
              xmldata.value(''(descendant::ProviderUid)[1]'', ''varchar(50)'') as ProviderUid, 
              xmldata.value(''(descendant::PatientUid)[1]'', ''varchar(50)'') as PatientUid, 
              xmldata.value(''(descendant::AuditData)[1]'', ''varchar(max)'') as AuditData, 
              xmldata.value(''(descendant::SigningInstanceUid)[1]'', ''varchar(max)'') as SigningInstanceUid, 
              convert(xml, xmldata.value(''(descendant::AuditData)[1]'', ''varchar(max)'')).value(''(descendant::PatientLastName)[1]'', ''varchar(50)'') as PatientLastName,
              convert(xml, xmldata.value(''(descendant::AuditData)[1]'', ''varchar(max)'')).value(''(descendant::PatientFirstName)[1]'', ''varchar(50)'') as PatientFirstName,
              convert(xml, xmldata.value(''(descendant::AuditData)[1]'', ''varchar(max)'')).value(''(descendant::Medication/Name)[1]'', ''varchar(50)'') as MedicationName,
              case xmldata.value(''(descendant::AuditType)[1]'', ''varchar(50)'')
                 WHEN ''Medication''           THEN convert(xml, xmldata.value(''(descendant::AuditData)[1]'', ''varchar(max)'')).value(''(descendant::Medication/PrescriberLastName)[1]'', ''varchar(50)'') 
                 WHEN ''EnableEPCSProvider''   THEN convert(xml, xmldata.value(''(descendant::AuditData)[1]'', ''varchar(max)'')).value(''(descendant::Provider/LastName)[1]'', ''varchar(50)'') 
                 WHEN ''EnableEPCSVouch''      THEN convert(xml, xmldata.value(''(descendant::AuditData)[1]'', ''varchar(max)'')).value(''(descendant::Vouch/LastName)[1]'', ''varchar(50)'')
				 WHEN ''RevokeEPCS''			 THEN convert(xml, xmldata.value(''(descendant::AuditData)[1]'', ''varchar(max)'')).value(''(descendant::Vouch/LastName)[1]'', ''varchar(50)'') 
                 WHEN ''EnableEPCSFirstVouch'' THEN convert(xml, xmldata.value(''(descendant::AuditData)[1]'', ''varchar(max)'')).value(''(descendant::FirstVouch/LastName)[1]'', ''varchar(50)'')
              end as ProviderLastName,
              case xmldata.value(''(descendant::AuditType)[1]'', ''varchar(50)'')
                 WHEN ''Medication''           THEN convert(xml, xmldata.value(''(descendant::AuditData)[1]'', ''varchar(max)'')).value(''(descendant::Medication/PrescriberFirstName)[1]'', ''varchar(50)'') 
                 WHEN ''EnableEPCSProvider''   THEN convert(xml, xmldata.value(''(descendant::AuditData)[1]'', ''varchar(max)'')).value(''(descendant::Provider/FirstName)[1]'', ''varchar(50)'') 
                 WHEN ''EnableEPCSVouch''      THEN convert(xml, xmldata.value(''(descendant::AuditData)[1]'', ''varchar(max)'')).value(''(descendant::Vouch/FirstName)[1]'', ''varchar(50)'')
                 WHEN ''RevokeEPCS''			 THEN convert(xml, xmldata.value(''(descendant::AuditData)[1]'', ''varchar(max)'')).value(''(descendant::Vouch/FirstName)[1]'', ''varchar(50)'') 
                 WHEN ''EnableEPCSFirstVouch'' THEN convert(xml, xmldata.value(''(descendant::AuditData)[1]'', ''varchar(max)'')).value(''(descendant::FirstVouch/FirstName)[1]'', ''varchar(50)'') + '' (Admin)''
              end as ProviderFirstName,
              convert(xml, xmldata.value(''(descendant::AuditData)[1]'', ''varchar(max)'')).value(''(descendant::Details)[1]'', ''varchar(max)'') as Details,
              convert(xml, xmldata.value(''(descendant::AuditData)[1]'', ''varchar(max)'')).value(''(descendant::TransmitStatus)[1]'', ''varchar(max)'') as TransmitStatus,
			  convert(xml, xmldata.value(''(descendant::AuditData)[1]'', ''varchar(max)'')).value(''(descendant::TamperDetection)[1]'', ''varchar(max)'') as TamperDetection,
              dbo.ConvertUTCToLocalTime(xmldata.value(''(descendant::RecordedDateTimeUTC)[1]'', ''dateTime'')) as RecordedDateTimeUTC,
                       xmldata.value(''(descendant::CustomerNumber)[1]'', ''varchar(50)'') as CustomerNumber,
                       xmldata.value(''(descendant::IsFailure)[1]'', ''int'') as IsFailure,
                       InsertSequence,
                       ReportInstanceUid
              from externaldatareporting e WITH (NOLOCK)


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[erxMedicationDailySummary]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[erxMedicationDailySummary](@ReportInstanceUid UNIQUEIDENTIFIER)
RETURNS TABLE AS RETURN
with cte_auditdata as (
	select *  
	FROM MDOL_RPT2_ViewExternalDataReporting a
	where reportinstanceuid = @ReportInstanceUid
	and AuditType = ''Medication''
)
select 
	ReportInstanceUid = a.ReportInstanceUid,
	ProviderUid      = a.ProviderUid,
	ProviderLastName = a.ProviderLastName,
	ProviderFirstName = a.ProviderFirstName,
	SUM(MedicationPrescribed) as MedicationPrescribed,
	SUM(MedicationRejected) as MedicationRejected,
	SUM(MedicationSent) as MedicationSent,
	SUM(MedicationSuccess) as MedicationSuccess,
    SUM(ActivityTotalFail) as ActivityTotalFail,
    SUM(ActivityTotalSuccess) as ActivityTotalSuccess,
    SUM(ActivityReviews) as ActivityReviews,
    SUM(ActivitySignFail) as ActivitySignFail,
    SUM(ActivitySignSuccess) as ActivitySignSuccess,
    SUM(ActivitySent) as ActivitySent,
    SUM(ActivitySendFail) as ActivitySendFail,
    SUM(ActivitySendSuccess) as ActivitySendSuccess--,
 from (
SELECT    
   ReportInstanceUid = a.ReportInstanceUid,
   ProviderUid      = a.ProviderUid,
   ProviderLastName = a.ProviderLastName,
   ProviderFirstName = a.ProviderFirstName,
   MedicationPrescribed = CASE a.AuditSubType
                             WHEN ''Review''       THEN 0
                             WHEN ''FailReady''    THEN 0
                             WHEN ''Ready''        THEN 0
                             WHEN ''FailPRMLogin'' THEN 0
                             WHEN ''FailTFALogin'' THEN 0
                             WHEN ''FailSign''     THEN 0
                             WHEN ''Signed''       THEN 1
                             WHEN ''FailQueued''   THEN 1
                             WHEN ''Queued''       THEN 1
                             WHEN ''FailSignSend'' THEN 1
                             WHEN ''FailSend''     THEN 1
                             WHEN ''Send''         THEN 1
                             WHEN ''FailResponse'' THEN 1
                             WHEN ''Response''     THEN 1
                             ELSE 1
                          END,
   MedicationRejected   = CASE a.AuditSubType
                             WHEN ''Review''       THEN 0
                             WHEN ''FailReady''    THEN 0
                             WHEN ''Ready''        THEN 0
                             WHEN ''FailPRMLogin'' THEN 0
                             WHEN ''FailTFALogin'' THEN 0
                             WHEN ''FailSign''     THEN 0
                             WHEN ''Signed''       THEN 0
                             WHEN ''FailQueued''   THEN 1
                             WHEN ''Queued''       THEN 0
                             WHEN ''FailSignSend'' THEN 1
                             WHEN ''FailSend''     THEN 1
                             WHEN ''Send''         THEN 0
                             WHEN ''FailResponse'' THEN 1
                             WHEN ''Response''     THEN 0
                             ELSE 1
                          END,  
   MedicationSent       = CASE a.AuditSubType
                             WHEN ''Review''       THEN 0
                             WHEN ''FailReady''    THEN 0
                             WHEN ''Ready''        THEN 0
                             WHEN ''FailPRMLogin'' THEN 0
                             WHEN ''FailTFALogin'' THEN 0
                             WHEN ''FailSign''     THEN 0
                             WHEN ''Signed''       THEN 0
                             WHEN ''FailQueued''   THEN 0
                             WHEN ''Queued''       THEN 1
                             WHEN ''FailSignSend'' THEN 0
                             WHEN ''FailSend''     THEN 0
                             WHEN ''Send''         THEN 1
                             WHEN ''FailResponse'' THEN 0
                             WHEN ''Response''     THEN 0
                             ELSE 0
                          END,                       
   MedicationSuccess    = CASE a.AuditSubType
                             WHEN ''Review''       THEN 0
                             WHEN ''FailReady''    THEN 0
                             WHEN ''Ready''        THEN 0
                             WHEN ''FailPRMLogin'' THEN 0
                             WHEN ''FailTFALogin'' THEN 0
                             WHEN ''FailSign''     THEN 0
                             WHEN ''Signed''       THEN 0
                             WHEN ''FailQueued''   THEN 0
                             WHEN ''Queued''       THEN 0
                             WHEN ''FailSignSend'' THEN 0
                             WHEN ''FailSend''     THEN 0
                             WHEN ''Send''         THEN 0
                             WHEN ''FailResponse'' THEN 0
                             WHEN ''Response''     THEN 1
                             ELSE 0
                          END,                                           
   ActivityTotalFail    = c.ActivityTotalFail,
   ActivityTotalSuccess = c.ActivityTotalSuccess,
   ActivityReviews      = c.ActivityReviews,
   ActivitySignFail     = c.ActivitySignFail,
   ActivitySignSuccess  = c.ActivitySignSuccess,
   ActivitySent         = c.ActivitySent,
   ActivitySendFail     = c.ActivitySendFail,
   ActivitySendSuccess  = c.ActivitySendSuccess--,
   --PrescribeFail        = a.IsFailure,
   --Failures             = c.Failures,
   --CurrentState         = a.AuditSubType
   --,
   --CONVERT(xml, AuditData),*
FROM --MDOL_RPT2_ViewExternalDataReporting a
	cte_auditdata a
CROSS APPLY (SELECT MaxRecordedDateTimeUTC = MAX(b.RecordedDateTimeUTC),
                    ActivityTotalFail    = SUM(b.IsFailure),
                    ActivityTotalSuccess = COUNT(*) - SUM(b.IsFailure),
                    ActivityReviews      = SUM(CASE b.AuditSubType
                                                    WHEN ''Review''       THEN 1
                                                    WHEN ''Ready''        THEN 1
                                                    ELSE 0
                                                 END),
                    ActivitySignFail     = SUM(CASE b.AuditSubType
                                                    WHEN ''FailReady''    THEN 1
                                                    WHEN ''FailPRMLogin'' THEN 1
                                                    WHEN ''FailTFALogin'' THEN 1
                                                    WHEN ''FailSign''     THEN 1
                                                    ELSE 0
                                                 END),
                    ActivitySignSuccess  = SUM(CASE b.AuditSubType
                                                    WHEN ''Signed''       THEN 1
                                                    ELSE 0
                                                 END),
                    ActivitySent         = SUM(CASE b.AuditSubType
                                                    WHEN ''Queued''       THEN 1
                                                    ELSE 0
                                                 END),
                    ActivitySendFail     = SUM(CASE b.AuditSubType
                                                    WHEN ''FailQueued''   THEN 1
                                                    WHEN ''FailSignSend'' THEN 1
                                                    WHEN ''FailSend''     THEN 1
                                                    WHEN ''FailResponse'' THEN 1
                                                    ELSE 0
                                                 END),
                    ActivitySendSuccess  = SUM(CASE b.AuditSubType
                                                    WHEN ''Send''         THEN 1
                                                    WHEN ''Response''     THEN 1
                                                    ELSE 0
                                                 END)
             FROM --MDOL_RPT2_ViewExternalDataReporting b
				cte_auditdata b
             WHERE b.CustomerNumber = a.CustomerNumber
               AND b.ProviderUid = a.ProviderUid
               AND b.PatientUid = a.PatientUid
               AND b.RelVisitMedicationUid = a.RelVisitMedicationUid
--               AND b.AuditType = ''Medication''
			   AND @ReportInstanceUid = b.ReportInstanceUid) c
WHERE a.RecordedDateTimeUTC = c.MaxRecordedDateTimeUTC
and @ReportInstanceUid = a.ReportInstanceUid
--ORDER BY a.RecordedDateTimeUTC DESC
) a
group by 
  reportInstanceUid
, ProviderUid
, ProviderLastName
, ProviderFirstName
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[erxGrantsDailySummary]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[erxGrantsDailySummary](@ReportInstanceUid UNIQUEIDENTIFIER)
RETURNS TABLE AS RETURN
with cte_auditdata as (
	select *  
	FROM MDOL_RPT2_ViewExternalDataReporting a
	where reportinstanceuid = @ReportInstanceUid
	and AuditType IN(''EnableEPCSVouch'', ''EnableEPCSFirstVouch'', ''EnableEPCSProvider'') and AuditSubType <> ''Review''
)
select 
   ReportInstanceUid = a.ReportInstanceUid,	
   ProviderUid      = a.ProviderUid,
   ProviderLastName = a.ProviderLastName,
   ProviderFirstName = a.ProviderFirstName,
   	SUM(GrantsFail) as GrantsFail,
	SUM(GrantsSuccess) as GrantsSuccess
	from ( 
	SELECT
   ReportInstanceUid = a.ReportInstanceUid,	
   ProviderUid      = a.ProviderUid,
   ProviderLastName = a.ProviderLastName,
   ProviderFirstName = a.ProviderFirstName,
   GrantsFail     = CASE a.AuditSubType
                       WHEN ''Review''        THEN 1
                       WHEN ''FailPRMLogin''  THEN 1
                       WHEN ''FailTFALogin''  THEN 1
                       WHEN ''FailSign''      THEN 1
                       WHEN ''Signed''        THEN 1
                       WHEN ''FailGrant''     THEN 1
                       WHEN ''Grant''         THEN 0
                       WHEN ''GrantComplete'' THEN 0
                       ELSE 1
                    END,
   GrantsSuccess  = CASE a.AuditSubType
                       WHEN ''Review''        THEN 0
                       WHEN ''FailPRMLogin''  THEN 0
                       WHEN ''FailTFALogin''  THEN 0
                       WHEN ''FailSign''      THEN 0
                       WHEN ''Signed''        THEN 0
                       WHEN ''FailGrant''     THEN 0
                       WHEN ''Grant''         THEN 1
                       WHEN ''GrantComplete'' THEN 1
                       ELSE 1
                    END,
   Failures             = c.Failures,
   CurrentState         = a.AuditSubType--,
   --CONVERT(xml, AuditData),*
FROM --MDOL_RPT2_ViewExternalDataReporting a
	cte_auditdata a
CROSS APPLY (SELECT MaxRecordedDateTimeUTC = MAX(b.RecordedDateTimeUTC),
                    Failures               = SUM(b.IsFailure),
                    Success                = COUNT(*) - SUM(b.IsFailure)
             FROM --MDOL_RPT2_ViewExternalDataReporting b
				cte_auditdata b
             WHERE b.CustomerNumber = a.CustomerNumber
               AND b.ProviderUid = a.ProviderUid
               AND b.SigningInstanceUid = a.SigningInstanceUid
			   AND @ReportInstanceUid = b.ReportInstanceUid
			   ) c
WHERE a.RecordedDateTimeUTC = c.MaxRecordedDateTimeUTC             
--ORDER BY a.RecordedDateTimeUTC DESC
) a 
group by 
  reportInstanceUid
, ProviderUid
, ProviderLastName
, ProviderFirstName
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[erxRevokeDailySummary]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[erxRevokeDailySummary](@ReportInstanceUid UNIQUEIDENTIFIER)
RETURNS TABLE AS RETURN
with cte_auditdata as (
	select *  
	FROM MDOL_RPT2_ViewExternalDataReporting a
	where reportinstanceuid = @ReportInstanceUid
	and AuditType IN(''RevokeEPCS'') and AuditSubType <> ''Review''
)
select 
	ReportInstanceUid = a.ReportInstanceUid,
	a.providerUid,
    ProviderLastName = a.ProviderLastName,
    ProviderFirstName = a.ProviderFirstName,
	SUM(RevokesFail) as RevokesFail,
	SUM(RevokesSuccess) as RevokesSuccess
	from ( 
	SELECT
	ReportInstanceUid = a.ReportInstanceUid,	
    ProviderUid      = a.ProviderUid,
    ProviderLastName = a.ProviderLastName,
    ProviderFirstName = a.ProviderFirstName,
	RevokesFail       = CASE a.AuditSubType
                          WHEN ''Review''         THEN 1
                          WHEN ''FailPRMLogin''   THEN 1
                          WHEN ''FailTFALogin''   THEN 1
                          WHEN ''FailSign''       THEN 1
                          WHEN ''Signed''         THEN 1
                          WHEN ''FailRevoke''     THEN 1
                          WHEN ''Revoke''         THEN 0
                          WHEN ''RevokeComplete'' THEN 0
                          ELSE 1
                       END,
   RevokesSuccess    = CASE a.AuditSubType
                          WHEN ''Review''         THEN 0
                          WHEN ''FailPRMLogin''   THEN 0
                          WHEN ''FailTFALogin''   THEN 0
                          WHEN ''FailSign''       THEN 0
                          WHEN ''Signed''         THEN 0
                          WHEN ''FailRevoke''     THEN 0
                          WHEN ''Revoke''         THEN 1
                          WHEN ''RevokeComplete'' THEN 1
                          ELSE 1
                       END,
   RevokeFail        = a.IsFailure,
   Failures          = c.Failures,
   CurrentState      = a.AuditSubType--,
   --CONVERT(xml, AuditData),*
FROM --MDOL_RPT2_ViewExternalDataReporting a
	cte_auditdata a
CROSS APPLY (SELECT MaxRecordedDateTimeUTC = MAX(b.RecordedDateTimeUTC),
                    Failures               = SUM(b.IsFailure),
                    Success                = COUNT(*) - SUM(b.IsFailure)
             FROM --MDOL_RPT2_ViewExternalDataReporting b
				cte_auditdata b
             WHERE b.CustomerNumber = a.CustomerNumber
               AND b.ProviderUid = a.ProviderUid               
               AND b.SigningInstanceUid = a.SigningInstanceUid
               AND b.AuditType IN(''RevokeEPCS'')
			   ) c
WHERE a.RecordedDateTimeUTC = c.MaxRecordedDateTimeUTC             
--ORDER BY a.RecordedDateTimeUTC DESC
) a
group by 
  reportInstanceUid
, ProviderUid
, ProviderLastName
, ProviderFirstName
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewPersonInsurance]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ViewPersonInsurance](@date DATETIME, @displayOrder TINYINT) RETURNS TABLE AS
RETURN 
(
SELECT DISTINCT		pip.PersonInsurancePlanUid, pip.InsurancePlanUid, p.PersonUid, ip.InsuranceCarrierUid, ip.InsuranceCarrier, ip.InsurancePlan, a.AccountUid, a.Name AS Account, 
                    a.IsMain, pip.PlanMemberID, pip.PlanGroupID, ins.FullName AS InsuredName, r.Name AS InsuredRelationship,
					ip.Address1, ip.Address2, ip.City, ip.State, ip.Zip, ip.PhoneNumber
FROM				Person AS p INNER JOIN Account AS a ON p.PersonUid = a.PersonUid 
					INNER JOIN AccountPeriod AS ap ON ap.AccountPeriodUid = dbo.GetAccountPeriod(a.AccountUid, @date)
					INNER JOIN AccountInsurance AS ai ON ap.AccountPeriodUid = ai.AccountPeriodUid 
					INNER JOIN PersonInsurancePlan AS pip ON ai.PersonInsurancePlanUid = pip.PersonInsurancePlanUid 
					INNER JOIN ViewInsurancePlan AS ip ON pip.InsurancePlanUid = ip.InsurancePlanUid 
					LEFT JOIN ViewPerson ins ON pip.PersonUid = ins.PersonUid
					LEFT JOIN ListRelationship r ON ai.RelationshipUid = r.RelationshipUid
WHERE				(ai.DisplayOrder = @displayOrder OR @displayOrder IS NULL) AND (ap.ExpirationDate IS NULL)
)
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewSuperbillProcedureAggregate]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[AR_ViewSuperbillProcedureAggregate] 
AS
SELECT SBP.SuperbillProcedureUid, SBP.SuperbillUid,
	ISNULL(VSPAB.Liability, 0) AS Liability, 
	CAST(ISNULL(VSPAB.AssignedLiability, 0) AS MONEY) AS AssignedLiability,
	CAST(ISNULL(VSPAB.Distribution, 0) AS MONEY) AS Distribution, 
	CAST(ISNULL(VSPAB.AssignedDistribution, 0) AS MONEY) AS AssignedDistribution,
	CAST(ISNULL(VSPAB.Adjustment, 0) AS MONEY) AS Adjustment, 
	CAST(ISNULL(VSPAB.AssignedAdjustment, 0) AS MONEY) AS AssignedAdjustment, 
	ISNULL(VSPAB.LiabilityBalance, 0) AS LiabilityBalance, 
	CAST(ISNULL(VSPAB.AssignedLiabilityBalance, 0) AS MONEY) AS AssignedLiabilityBalance
FROM SuperbillProcedure(NOLOCK) SBP
LEFT JOIN AR_ViewSuperbillProcedureAggregateSub (NOEXPAND) VSPAB ON SBP.SuperbillProcedureUid = VSPAB.SuperbillProcedureUid


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewSuperbillAggregate]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[AR_ViewSuperbillAggregate] 
AS
SELECT SB.SuperbillUid,
	SUM(ISNULL(VSPAB.Liability, 0)) AS Liability, 
	SUM(ISNULL(VSPAB.AssignedLiability, 0)) AS AssignedLiability,
	SUM(ISNULL(VSPAB.Liability, 0)) - SUM(ISNULL(VSPAB.AssignedLiability, 0)) AS UnAssignedLiability,
	SUM(ISNULL(VSPAB.Distribution, 0)) AS Distribution, 
	SUM(ISNULL(VSPAB.AssignedDistribution, 0)) AS AssignedDistribution, 
	SUM(ISNULL(VSPAB.Distribution, 0)) - SUM(ISNULL(VSPAB.AssignedDistribution, 0)) AS UnAssignedDistribution, 
	SUM(ISNULL(VSPAB.Adjustment, 0)) AS Adjustment,
	SUM(ISNULL(VSPAB.AssignedAdjustment, 0)) AS AssignedAdjustment,
	SUM(ISNULL(VSPAB.Adjustment, 0)) - SUM(ISNULL(VSPAB.AssignedAdjustment, 0)) AS UnAssignedAdjustment,
	SUM(ISNULL(VSPAB.LiabilityBalance, 0)) AS LiabilityBalance, 
	CASE WHEN SUM(ISNULL(VSPAB.LiabilityBalance, 0))=0 AND SUM(ABS(ISNULL(VSPAB.LiabilityBalance, 0)))>0 THEN 1 ELSE 0 END AS ZeroLiabilityBalanceNotDistributed, -- we have a ZeroBalance made up of offsetting balances (not properly distributed) 
	SUM(ISNULL(VSPAB.AssignedLiabilityBalance, 0)) AS AssignedLiabilityBalance,
	SUM(ISNULL(VSPAB.LiabilityBalance, 0)) - SUM(ISNULL(VSPAB.AssignedLiabilityBalance, 0)) AS UnAssignedLiabilityBalance
FROM Superbill SB WITH (NOLOCK) 
	LEFT JOIN AR_ViewSuperbillProcedureAggregateSub (NOEXPAND) VSPAB ON SB.SuperbillUid = VSPAB.SuperbillUid
GROUP BY SB.SuperbillUid



' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewSuperbillProcedureBatchSub]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[AR_ViewSuperbillProcedureBatchSub] WITH SCHEMABINDING    
 AS    
 SELECT SBP.SuperbillUid, SBP.SuperbillProcedureUid,  L.ArBatchUid, ARB.Name AS ArBatchName, 
			ARB.GLDate AS ArBatchPostingDate, L.CreatedDateTime, LD.LedgerDetailUid   
	 FROM dbo.AR_Ledger L  
		INNER JOIN dbo.AR_LedgerDetail LD ON L.LedgerUid = LD.LedgerUid  
		INNER JOIN dbo.SuperbillProcedure SBP ON LD.SuperbillProcedureUid = SBP.SuperbillProcedureUid 
		INNER JOIN dbo.ARBatch ARB ON L.ArBatchUid = ARB.ARBatchUid  
	 WHERE L.EntryType = 1 -- charge  AND LD.IsCredit = 0             

' 
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewSuperbillProcedureBatchSub]') AND name = N'PK_AR_ViewSuperbillProcedureBatchSub')
CREATE UNIQUE CLUSTERED INDEX [PK_AR_ViewSuperbillProcedureBatchSub] ON [dbo].[AR_ViewSuperbillProcedureBatchSub]
(
	[SuperbillProcedureUid] ASC,
	[CreatedDateTime] DESC,
	[ArBatchUid] ASC,
	[ArBatchName] ASC,
	[ArBatchPostingDate] ASC,
	[SuperbillUid] ASC,
	[LedgerDetailUid] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, IGNORE_DUP_KEY = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbill]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[ViewSuperbill] as
SELECT s.SuperbillUid, s.ExternalID, s.PatientUid,
              sa.RenderingProviderUid, sa.ClaimingProviderUid, s.SuperbillStatusUid,
              s.ServiceDateStart, s.ServiceDateEnd, VSA.LiabilityBalance, 
              VSA.Liability AS TotalCharge, sa.FirstFiledDate, sa.LastFiledDate,
              sa.ServiceSiteUid,   
              p.FullName as PatientName,   
              renderer.FormattedInternalName as RenderingProviderName,
              claimer.FormattedInternalName as ClaimingProviderName,
			  referer.FormattedInternalName as ReferingProviderName, -- for UI column name only
              sts.Name AS SuperbillStatusName, 
              ste.Name AS ServiceSiteName,
              s.AccountUid, s.VisitUid, v.VisitDate, v.IsCompleted AS VisitIsCompleted, 
              s.ClaimPaper, s.LastModifiedByUid, sa.IsPosted, sa.FinancialCenterUid,
              fc.Name AS FinancialCenterName, 
              sa.CurrentCarrier as InsuranceOrder, -- was sts.InsuranceOrder which is now obsolete
              ISNULL(ILN.InsuranceLevelName,'''') AS InsuranceLevelName,
              CASE WHEN sa.CodeValidationErrors = 1 THEN ''Errors'' ELSE '''' END AS CodeValidationErrors,
              (SELECT MAX(ArbatchPostingDate) FROM AR_ViewSuperbillProcedureBatchSub (NOEXPAND) WHERE SuperbillUid = s.SuperbillUid) AS MaxPostingDate,
              (SELECT MIN(ArbatchPostingDate) FROM AR_ViewSuperbillProcedureBatchSub (NOEXPAND) WHERE SuperbillUid = s.SuperbillUid) AS MinPostingDate,
			  s.ABN, s.ARBatchUid,-- Igor note: temporary added to fix application error (bug 7146)1/12/2011
			  s.Notes,
			  S.appointmentUid,
			  (SELECT COUNT(SuperbillProcedureUid) FROM SuperbillProcedure WITH (NOLOCK) WHERE Inactive = 0 AND SuperbillUid = s.SuperbillUid) AS SuperbillProcedureCount
FROM   Superbill(NOLOCK) s 
              INNER JOIN SuperbillAggregate(NOLOCK) sa ON s.SuperbillUid = sa.SuperbillUid
              INNER JOIN ViewPerson (NOEXPAND) p on p.PersonUid = s.PatientUid 
              LEFT JOIN ViewPerson (NOEXPAND) renderer on renderer.PersonUid = sa.RenderingProviderUid    
              LEFT JOIN ViewPerson (NOEXPAND) claimer on claimer.PersonUid = sa.ClaimingProviderUid    
			  LEFT JOIN ViewPerson (NOEXPAND) referer on referer.PersonUid = s.ReferringProviderUid -- for UI column name only
              INNER JOIN ListSuperbillStatus(NOLOCK) sts on s.SuperbillStatusUid = sts.SuperbillStatusUid
              LEFT JOIN ListServiceSite(NOLOCK) ste on sa.ServiceSiteUid = ste.ServiceSiteUid
              LEFT JOIN FinancialCenter(NOLOCK) fc on sa.FinancialCenterUid = fc.FinancialCenterUid
              LEFT JOIN Visit(NOLOCK) v on s.VisitUid = v.VisitUid
              LEFT JOIN AR_ViewSuperbillAggregate VSA ON s.SuperbillUid = VSA.SuperbillUid 
              LEFT JOIN ListInsuranceLevelName(NOLOCK) ILN ON sa.CurrentCarrier = ILN.InsuranceLevel











' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillPayerWithoutClaimFormat]'))
EXEC dbo.sp_executesql @statement = N'

CREATE VIEW [dbo].[ViewSuperbillPayerWithoutClaimFormat]    
AS
-- NOTE: OTHER VIEWS MAY DEPEND ON THIS ONE. Use sp_f ViewSuperbillPayerWithoutClaimFormat (or other means) to identify and update them.
-- NOTE: ViewSuperbillPayer uses this view. In most cases you''ll want to use ViewSuperbillPayer and NOT ViewSuperbillPayerWithoutClaimFormat.
SELECT    
	s.ExternalID,
	s.SuperbillUid,
	s.PatientUid,
	s.RenderingProviderUid,
	s.ClaimingProviderUid,
	s.SuperbillStatusUid,
	s.ServiceDateStart,
	s.ServiceDateEnd,
	s.FirstFiledDate,
	s.LastFiledDate,
	s.ServiceSiteUid,
	s.PatientName,
	s.RenderingProviderName,
	s.ClaimingProviderName,
	s.SuperbillStatusName,
	s.ServiceSiteName,
	s.AccountUid,
	s.VisitUid,
	s.VisitDate,
	s.ClaimPaper,
	s.LastModifiedByUid,
	s.TotalCharge,
	s.IsPosted,
	s.FinancialCenterUid,
	--s.InsuranceCarrierUid,
	--s.PayerName,
	a.Name as AccountName,    
	coalesce(ai.DisplayOrder, 0) as InsuranceOrder,    
    s.InsuranceOrder as CurrentCarrier, -- see in underlying query ViewSuperbill ... no need to rejoin
    ISNULL(ILN.InsuranceLevelName,'''') as InsuranceLevelName,
	pip.PersonUid as InsuredPersonUid,    
	pip.CorporationUid as InsuredCorporationUid,    
	coalesce((case when pip.PersonUid is not null then dbo.UDF_getFormattedName(insp.Prefix, insp.FirstName, insp.MiddleName , insp.LastName, insp.Suffix) else insc.Name end), '''') as InsuredName,    
	CAST(coalesce(pip.AuthorizeAssignment, 0) as bit) as AuthorizeAssignment,    
	coalesce(pip.PlanMemberID, '''') as PlanMemberID,    
	coalesce(pip.PlanGroupID, '''') as PlanGroupID,    
	ip.InsuranceCarrierUid,  -- Someone added this to ViewSuperbill so I removed it here.
	ip.InsurancePlanUid,    
	coalesce(ip.Name, '''') as InsurancePlanName,    
	coalesce(icc.Name, '''') as PayerName,    
	ip.IsCapitated AS Capitated,    

	(SELECT COUNT(*)    
	FROM eReportRows err     
	WHERE err.SuperbillUid = s.SuperbillUid    
	AND err.ClaimReportStatusUid = ''00000000-0000-0000-0000-000000000010''    
	AND err.ErrorFlag = ''E'')    
	AS Errors,    
	(SELECT COUNT(*)    
	FROM eReportRows err    
	WHERE err.SuperbillUid = s.SuperbillUid    
	AND err.ClaimReportStatusUid = ''00000000-0000-0000-0000-000000000010''    
	AND err.ErrorFlag = ''W'')    
	AS Warnings,    
	dbo.UDF_AR_getClaimFormatUid(s.ClaimPaper, ip.UseCarrierElectronicClaimFormat, ip.UseCarrierPaperClaimFormat,     
								 ip.ElectronicClaimFormatUid, ic.ElectronicClaimFormatUid, 
								 ip.PaperClaimFormatUid, ic.PaperClaimFormatUid,
								 ip.UseCarrierPaperClaimDefaultOption, ip.PaperClaimDefaultOptionUid, 
								 ic.PaperClaimDefaultOptionUid, s.InsuranceOrder ) as ClaimFormatUid,     

	lep.ClaimClearingHouseUid as ClaimClearingHouseUid,     
	lcch.Name as ClaimClearingHouse,    
    pipp.InsurancePlanUid as PrimaryInsurancePlanUid, 
    Case when ip.UseInsuranceCarrierAccountType=1 then ic.AccountTypeUid else ip.AccountTypeUid end as AccountTypeUid, 
     s.ARBatchUid,-- Igor note: temporary added to fix application error (bug 7146)1/12/2011
	 s.Notes
from ViewSuperbill s    
 inner join Account(NOLOCK) a on     
  a.AccountUid = s.AccountUid    
 left join AccountPeriod(NOLOCK) ap on    
  a.AccountUid = ap.AccountUid    
  and (ap.EffectiveDate is null or ap.EffectiveDate <= s.ServiceDateEnd)    
  and (ap.ExpirationDate is null or DateAdd(dd, 1, ap.ExpirationDate) > s.ServiceDateEnd)    
 left join AccountInsurance(NOLOCK) ai on    
  ai.AccountPeriodUid = ap.AccountPeriodUid    
 left join PersonInsurancePlan(NOLOCK) pip on    
  pip.PersonInsurancePlanUid = ai.PersonInsurancePlanUid    
 left join Person(NOLOCK) insp on    
  insp.PersonUid = pip.PersonUid    
 left join Corporation(NOLOCK) insc on    
  insc.CorporationUid = pip.CorporationUid    
 left join InsurancePlan(NOLOCK) ip on    
  ip.InsurancePlanUid = pip.InsurancePlanUid    
 left join InsuranceCarrier(NOLOCK) ic on    
  ic.CorporationUid = ip.InsuranceCarrierUid    
 left join Corporation(NOLOCK) icc on    
  icc.CorporationUid = ic.CorporationUid    
 left join ListElectronicPayer(NOLOCK) lep on    
  lep.ElectronicPayerUid = ic.ElectronicPayerUid    
 left join ListClaimClearingHouse(NOLOCK) lcch on    
  lcch.ClaimClearingHouseUid = lep.ClaimClearingHouseUid
 LEFT JOIN AccountInsurance(NOLOCK) aip ON ap.AccountPeriodUid = aip.AccountPeriodUid AND aip.DisplayOrder = 1
 LEFT JOIN PersonInsurancePlan(NOLOCK) pipp ON aip.PersonInsurancePlanUid = pipp.PersonInsurancePlanUid
 left join ListInsuranceLevelName(NOLOCK) ILN ON s.InsuranceOrder = ILN.InsuranceLevel -- see in underlying query ViewSuperbill ... no need to rejoin


--EXEC sys.sp_addextendedproperty @name=N''GenerateEntityObject'', @value=N''false'' , @level0type=N''SCHEMA'',@level0name=N''dbo'', @level1type=N''VIEW'',@level1name=N''ViewSuperbillPayerWithoutClaimFormat''


' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillPayer]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewSuperbillPayer]  
AS
SELECT  
	NEWID() AS ViewSuperbillPayerUid, -- no other unique to use as PK
	s.ExternalID,
	s.SuperbillUid,
	s.PatientUid,
	s.RenderingProviderUid,
	s.ClaimingProviderUid,
	s.SuperbillStatusUid,
	s.ServiceDateStart,
	s.ServiceDateEnd,
	s.FirstFiledDate, 
	s.LastFiledDate,
	s.ServiceSiteUid,
	s.PatientName,
	s.RenderingProviderName,
	s.ClaimingProviderName,
	s.SuperbillStatusName,
	s.ServiceSiteName,
	s.AccountUid,
	s.VisitUid,
	s.VisitDate,
	s.ClaimPaper,
	s.LastModifiedByUid,
	s.TotalCharge,
	s.IsPosted,
	s.FinancialCenterUid,
	s.AccountName,
	s.InsuranceOrder,
	s.InsuredPersonUid,
	s.InsuredCorporationUid,
	s.InsuredName,
	s.AuthorizeAssignment,
	s.PlanMemberID,
	s.PlanGroupID,
	s.InsuranceCarrierUid,
	s.InsurancePlanUid,
	s.InsurancePlanName,
	s.PayerName,
	s.Capitated,
	s.Errors,
	s.Warnings,
	s.ClaimFormatUid,
	s.ClaimClearingHouseUid,
	s.ClaimClearingHouse,
	lcf.Name as ClaimFormat,
	lcft.ClaimFormatTypeUid,   
	lcft.Name as ClaimFormatType,   
	lcft.IsPaper as ClaimFormatTypeIsPaper
from ViewSuperbillPayerWithoutClaimFormat s  
 left join ListClaimFormat(NOLOCK) lcf on  
   lcf.ClaimFormatUid = s.ClaimFormatUid  
 left join ListClaimFormatType(NOLOCK) lcft on  
   lcft.ClaimFormatTypeUid = lcf.ClaimFormatTypeUid






' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ResultTracking_ObservationOrder]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ResultTracking_ObservationOrder]
(	
	@PatientUid [uniqueidentifier]
)
RETURNS TABLE 
AS
RETURN 
(
	SELECT
	   PK                               = obo.ObservationOrderUid,
	   ResultUid                        = obo.ObservationOrderUid,
	   PatientUid                       = obo.PatientUid,
	   DisplayTypeID                    = CASE
											 WHEN obo.AttachmentTypeUid IS NOT NULL THEN ISNULL(lat.DisplayTypeID, 1)
											 ELSE ISNULL(loa.DisplayTypeID, 1)
										  END,
	   RPNResultTypeID                  = 1,
	   RPNResultUid                     = obo.ObservationOrderUid,
	   AttachmentTypeUid                = ISNULL(obo.AttachmentTypeUid, llo.AttachmentTypeUid),
	   AttachmentType                   = CASE
											 WHEN obo.AttachmentTypeUid IS NOT NULL THEN lat.Name
											 ELSE loa.Name
										  END,
	   HasAttachmentType                = CAST(CASE WHEN ISNULL(lat.AttachmentTypeUid, loa.AttachmentTypeUid) IS NULL THEN 0 ELSE 1 END AS BIT),
	   AbnormalFlagCode                 = CAST(obo.AbnormalFlagCode AS VARCHAR(2)),
	   ResultStatusID                   = obo.ResultStatusID,
	   Status                           = sts.Name,
	   OrderDate                        = obo.OrderDate,
	   OrderDateTime                    = obo.OrderDateTime,
	   DueDate                          = obo.DueDate,
	   ResultDate                       = obo.ResultDate,
	   ResultDateTime                   = obo.ResultDateTime,
	   ProviderUid                      = obo.OrderProviderUid,
	   ApproveDate                      = obo.ApproveDate,
	   ApproveProviderUid               = obo.ApproveProviderUid,
	   ObservationUid                   = obo.ObservationUid,
	   Template                         = obs.Name,
	   VisitUid                         = ISNULL(obo.VisitUid, rag.VisitUid),
	   CPT                              = ISNULL(prc.Code, ''''),
	   LaboratoryUid                    = lab.LaboratoryUid,
	   LaboratoryName                   = ISNULL(lab.Name, ''''),
	   OrderType                        = CASE
											 WHEN vpr.IsPerformed IS NULL THEN ''''
											 WHEN vpr.IsPerformed = 1 THEN ''SP''
											 ELSE ''SO''
										  END,
	   Description                      = COALESCE(prc.ShortDescription, atg.Name, ''''),
	   PhaseName                        = ctp.Name,
	   PatientCaseUid                   = obo.PatientCaseUid,
	   Technician                       = obo.Technician,
	   ExtractDate                      = obo.ExtractDate,
	   ExtractDateTime                  = obo.ExtractDateTime,
	   ReceiveDate                      = obo.ReceiveDate,
	   ReceiveDateTime                  = obo.ReceiveDateTime,
	   PerformDate                      = obo.PerformDate,
	   PerformDateTime                  = obo.PerformDateTime,
	   Notes                            = obo.Notes,
	   LOINCUid                         = obs.LOINCUid,
	   VisitProcedureUid                = obo.VisitProcedureUid,
	   PSC                              = CAST(obo.PSC AS INT),
	   EstimatedDueDate                 = obo.DueDate,
	   Result                           = CASE obo.AbnormalFlagCode
											 WHEN ''C''  THEN ''Critical''
											 WHEN ''AL'' THEN ''Alert''
											 WHEN ''AB'' THEN ''Abnormal''
											 WHEN ''N''  THEN ''Normal''
											 ELSE ''''
										  END,
	   LaboratoryOrderUid               = obo.LaboratoryOrderUid,
	   RelAttachmentGroupUid            = rag.RelAttachmentGroupUid,
	   ResultingVisitUid                = obo.ResultingVisitUid,
	   ReferredByProviderUid            = vis.ReferredByProviderUid,
	   ServiceSiteUid                   = vis.ServiceSiteUid,
	   ImedicaAccessionNumber           = obo.ImedicaAccessionNumber,
	   LabAccessionNumber               = obo.LabAccessionNumber,
	   ObservationOrderResultStatusUid  = obo.ObservationOrderResultStatusUid,
	   MessageUrgencyUid                = obo.MessageUrgencyUid,
	   VisitDate          = vis.VisitDate,
	   VisitProcedureName               = vpr.Name,
	   IsDelete                         = CASE
											 WHEN vis.VisitTypeUid = ''FB954167-9D1C-43B7-9F5B-A76260654C96'' THEN CAST (1 AS INT)
											 ELSE obo.IsDelete
										  END
	FROM ObservationOrder obo WITH(NOLOCK)
		LEFT JOIN ListLaboratoryOrder llo WITH(NOLOCK) ON llo.LaboratoryOrderUid = obo.LaboratoryOrderUid
		LEFT JOIN ListAttachmentType loa WITH(NOLOCK) ON loa.AttachmentTypeUid = llo.AttachmentTypeUid
		LEFT JOIN ListObservation obs WITH(NOLOCK) ON obs.ObservationUid = obo.ObservationUid
		LEFT JOIN ListAttachmentType lat WITH(NOLOCK) ON lat.AttachmentTypeUid = obo.AttachmentTypeUid
		LEFT JOIN ListCaseTypePhase ctp WITH(NOLOCK) ON ctp.CaseTypePhaseUid = obo.CaseTypePhaseUid
		LEFT JOIN ListObservationOrderResultStatus sts WITH(NOLOCK) ON sts.ObservationOrderResultStatusUid = obo.ObservationOrderResultStatusUid
		LEFT JOIN VisitProcedure vpr WITH(NOLOCK) ON vpr.VisitProcedureUid = obo.VisitProcedureUid
		LEFT JOIN ListProcedure prc WITH(NOLOCK) ON prc.ProcedureUid = vpr.ProcedureUid
		OUTER APPLY (
		   SELECT TOP 1 *
		   FROM RelAttachmentGroup WITH(NOLOCK)
		   WHERE RelAttachmentGroup.ObservationOrderUid = obo.ObservationOrderUid
		   ORDER BY LastModifiedDate) AS rag
		LEFT JOIN ListLaboratory lab WITH(NOLOCK) ON lab.LaboratoryUid = obo.LaboratoryUid
		LEFT JOIN Visit vis WITH(NOLOCK) ON vis.VisitUid = obo.VisitUid
		LEFT JOIN AttachmentGroup atg WITH(NOLOCK) ON atg.AttachmentGroupUid = rag.AttachmentGroupUid
	WHERE obo.Inactive = 0
	  --AND ISNULL(vis.VisitTypeUid, ''00000000-0000-0000-0000-000000000000'') != ''FB954167-9D1C-43B7-9F5B-A76260654C96''
	  AND obo.ResultStatusID != 0
	  AND obo.[PatientUid] = @PatientUid
)
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ResultTracking_RelAttachmentGroup]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ResultTracking_RelAttachmentGroup]
(	
	@PatientUid [uniqueidentifier]
)
RETURNS TABLE 
AS
RETURN 
(
	SELECT
	   -- Attachments
	   PK                               = rag.RelAttachmentGroupUid,
	   ResultUid                        = rag.RelAttachmentGroupUid,
	   PatientUid                       = rag.PersonUid,
	   DisplayTypeID                    = ISNULL(lat.DisplayTypeID, 1),
	   RPNResultTypeID                  = CASE WHEN vis.VisitUid IS NOT NULL THEN 2 ELSE 3 END,
	   RPNResultUid                     = rag.RelAttachmentGroupUid,
	   AttachmentTypeUid                = atg.AttachmentTypeUid,
	   AttachmentType                   = lat.Name,
	   HasAttachmentType                = CAST(CASE WHEN lat.AttachmentTypeUid IS NULL THEN 0 ELSE 1 END AS BIT),
	   AbnormalFlagCode                 = CAST('''' AS VARCHAR(2)),
	   ResultStatusID                   = CAST(ISNULL(att.ResultStatusID, 9) AS SMALLINT),
	   Status                           = CASE WHEN att.ResultStatusID = 7
											 THEN (SELECT Name FROM ListObservationOrderResultStatus WHERE ObservationOrderResultStatusUid = ''E4861953-D5F3-4D86-BE78-530B394AE39E'')  -- 7
											 ELSE (SELECT Name FROM ListObservationOrderResultStatus WHERE ObservationOrderResultStatusUid = ''53BDC86C-2839-4066-9821-C20C214967B1'')  -- 9
										   END,
	   OrderDate                        = CAST(NULL AS DATE),
	   OrderDateTime                    = CAST(NULL AS DATETIME),
	   DueDate                          = CAST(NULL AS DATE),
	   ResultDate                       = CAST(ISNULL(att.FileDate, atg.LastModifiedDate) AS DATE),
	   ResultDateTime                   = CAST(CAST(ISNULL(att.FileDate, atg.LastModifiedDate) AS DATE) AS DATETIME),
	   ProviderUid                      = CAST(NULL AS UNIQUEIDENTIFIER),
	   ApproveDate                      = CAST(NULL AS DATE),
	   ApproveProviderUid               = CAST(NULL AS UNIQUEIDENTIFIER),
	   ObservationUid                   = CAST(NULL AS UNIQUEIDENTIFIER),
	   Template                         = CAST('''' AS VARCHAR(100)),
	   VisitUid                         = rag.VisitUid,
	   CPT                              = CAST('''' AS VARCHAR(30)),
	   LaboratoryUid                    = CAST(NULL AS UNIQUEIDENTIFIER),
	   LaboratoryName                   = CAST('''' AS VARCHAR(100)),
	   OrderType                        = CAST('''' AS VARCHAR(2)),
	   Description                      = atg.Name,
	   PhaseName                        = CAST('''' AS VARCHAR(50)),
	   PatientCaseUid                   = vis.PatientCaseUid,
	   Technician                       = CAST(NULL AS VARCHAR(100)),
	   ExtractDate                      = CAST(NULL AS DATE),
	   ExtractDateTime                  = CAST(NULL AS DATETIME),
	   ReceiveDate                      = CAST(NULL AS DATE),
	   ReceiveDateTime                  = CAST(NULL AS DATETIME),
	   PerformDate                      = CAST(NULL AS DATE),
	   PerformDateTime                  = CAST(NULL AS DATETIME),
	   Notes                            = CAST(NULL AS VARCHAR(MAX)),
	   LOINCUid                         = CAST(NULL AS UNIQUEIDENTIFIER),
	   VisitProcedureUid                = CAST(NULL AS UNIQUEIDENTIFIER),
	   PSC                              = 0,
	   EstimatedDueDate                   = CAST(ISNULL(att.FileDate, atg.LastModifiedDate) AS DATE),
	   Result                           = CAST('''' AS VARCHAR(8)),
	   LaboratoryOrderUid               = CAST(NULL AS UNIQUEIDENTIFIER),
	   RelAttachmentGroupUid            = rag.RelAttachmentGroupUid,
	   ResultingVisitUid                = CAST(NULL AS UNIQUEIDENTIFIER),
	   ReferredByProviderUid            = vis.ReferredByProviderUid,
	   ServiceSiteUid                   = vis.ServiceSiteUid,
	   ImedicaAccessionNumber           = CAST(NULL AS VARCHAR(25)),
	   LabAccessionNumber               = CAST(NULL AS VARCHAR(25)),
	   ObservationOrderResultStatusUid  = CAST(CASE WHEN att.ResultStatusID = 7
				THEN ''E4861953-D5F3-4D86-BE78-530B394AE39E''  -- 7
												 ELSE ''53BDC86C-2839-4066-9821-C20C214967B1''  -- 9
											   END AS UNIQUEIDENTIFIER),
	   MessageUrgencyUid                = CAST(''C2A64D38-3BE1-4F8A-8947-EF9E9AD861A4'' AS UNIQUEIDENTIFIER), -- Default is Routine
	   VisitDate                        = vis.VisitDate,
	   VisitProcedureName               = CAST(NULL AS VARCHAR(255)),
	   IsDelete                         = CASE 
											 WHEN vis.VisitTypeUid = ''FB954167-9D1C-43B7-9F5B-A76260654C96'' THEN CAST(1 AS INT) 
											 ELSE 0
										  END
	FROM [RelAttachmentGroup] AS rag
		INNER JOIN [AttachmentGroup] AS atg ON atg.AttachmentGroupUid = rag.AttachmentGroupUid
		INNER JOIN [ListAttachmentType] AS lat ON lat.AttachmentTypeUid = atg.AttachmentTypeUid AND lat.DisplayTypeID = 1  -- Result type attachment
		LEFT JOIN [Visit] AS vis ON vis.VisitUid = rag.VisitUid
		OUTER APPLY (
		   SELECT
			   FileDate       = MIN(tab.FileDate),
			   ResultStatusID = MIN(CASE WHEN ata.ApprovedByUserPRMUid IS NULL THEN 7 ELSE 9 END)
		   FROM [Attachment] AS tab
			LEFT JOIN [AttachmentApproval] AS ata ON tab.AttachmentUid = ata.AttachmentUid
		   WHERE tab.AttachmentGroupUid = rag.AttachmentGroupUid
			AND tab.FileDate IS NOT NULL) AS att
	WHERE rag.ObservationOrderUid IS NULL
	  --AND ISNULL(vis.VisitTypeUid, ''00000000-0000-0000-0000-000000000000'') != ''FB954167-9D1C-43B7-9F5B-A76260654C96''
		AND rag.PersonUid = @PatientUid
)
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ResultTracking]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ResultTracking]
(	
	@PatientUid [uniqueidentifier]
)
RETURNS TABLE 
AS
RETURN 
(
	SELECT
	   PK                               = vrt.PK,
	   ResultUid                        = vrt.ResultUid,
	   PatientUid                       = vrt.PatientUid,
	   PatientName                      = pat.FirstName + '' '' + pat.LastName,
	   DisplayTypeID                    = vrt.DisplayTypeID,
	   RPNResultTypeID                  = vrt.RPNResultTypeID,
	   RPNResultUid                     = vrt.RPNResultUid,
	   AttachmentTypeUid                = vrt.AttachmentTypeUid,
	   AttachmentType                   = vrt.AttachmentType,
	   HasAttachmentType                = vrt.HasAttachmentType,
	   UrgentTypeID                     = urg.UrgentTypeID,
	   Urgent                           = CASE ISNULL(urg.UrgentTypeID, 0) WHEN 1 THEN ''!'' ELSE '''' END,
	   AbnormalFlagCode                 = vrt.AbnormalFlagCode,
	   ResultStatusID                   = vrt.ResultStatusID,
	   Status                           = vrt.Status,
	   OrderDate                        = vrt.OrderDate,
	   OrderDateTime                    = vrt.OrderDateTime,
	   DueDate                          = vrt.DueDate,
	   ResultDate                       = vrt.ResultDate,
	   ResultDateTime                   = vrt.ResultDateTime,
	   ProviderUid                      = vrt.ProviderUid,
	   ProviderName                     = dbo.UDF_getFormattedInternalName(prv.FirstName, prv.MiddleName, prv.LastName, prv.AkaFirstName, prv.AkaLastName),
	   ApproveDate                      = vrt.ApproveDate,
	   ApproveProviderUid               = vrt.ApproveProviderUid,
	   ApproveProviderName              = dbo.UDF_getFormattedInternalName(app.FirstName, app.MiddleName, app.LastName, app.AkaFirstName, app.AkaLastName),
	   ObservationUid                   = vrt.ObservationUid,
	   Template                         = vrt.Template,
	   VisitUid                         = vrt.VisitUid,
	   CPT                              = vrt.CPT,
	   LaboratoryUid                    = vrt.LaboratoryUid,
	   LaboratoryName                   = vrt.LaboratoryName,
	   OrderType                        = vrt.OrderType,
	   Description                      = vrt.Description,
	   PhaseName                        = vrt.PhaseName,
	   PatientCaseUid                   = vrt.PatientCaseUid,
	   Technician                       = vrt.Technician,
	   ExtractDate                      = vrt.ExtractDate,
	   ExtractDateTime                  = vrt.ExtractDateTime,
	   ReceiveDate                      = vrt.ReceiveDate,
	   ReceiveDateTime                  = vrt.ReceiveDateTime,
	   PerformDate                      = vrt.PerformDate,
	   PerformDateTime                  = vrt.PerformDateTime,
	   Notes                            = vrt.Notes,
	   LOINCUid                         = vrt.LOINCUid,
	   VisitProcedureUid                = vrt.VisitProcedureUid,
	   PSC                              = vrt.PSC,
	   EstimatedDueDate                 = vrt.EstimatedDueDate,
	   Result                           = vrt.Result,
	   LaboratoryOrderUid               = vrt.LaboratoryOrderUid,
	   RelAttachmentGroupUid            = vrt.RelAttachmentGroupUid,
	   ResultingVisitUid                = vrt.ResultingVisitUid,
	   ReferredByProviderUid            = vrt.ReferredByProviderUid,
	   ReferredByProviderName           = ISNULL(dbo.UDF_getFormattedInternalName(ref.FirstName, ref.MiddleName, ref.LastName, ref.AkaFirstName, ref.AkaLastName), ''''),
	   ServiceSiteUid                   = vrt.ServiceSiteUid,
	   ServiceSiteName                  = lss.Name,
	   PatientAddress                   = pat.Address1,
	   PatientAddress1                  = pat.[Address1].value(''(/Address/Address1)[1]'', ''VARCHAR(100)''),
	   PatientAddress2                  = pat.[Address1].value(''(/Address/Address2)[1]'', ''VARCHAR(100)''),
	   PatientCity                      = pat.[Address1].value(''(/Address/City)[1]'', ''VARCHAR(100)''),
	   PatientState                     = pat.[Address1].value(''(/Address/State)[1]'', ''VARCHAR(100)''),
	PatientZip                       = pat.[Address1].value(''(/Address/Zip)[1]'', ''VARCHAR(100)''),
	   ImedicaAccessionNumber           = vrt.ImedicaAccessionNumber,
	   LabAccessionNumber               = vrt.LabAccessionNumber,
	   ObservationOrderResultStatusUid  = vrt.ObservationOrderResultStatusUid,
	   MessageUrgencyUid                = vrt.MessageUrgencyUid,
	   VisitDate                        = vrt.VisitDate,
	   VisitProcedureName               = vrt.VisitProcedureName,
	   UrgencyName                      = urg.Name,
	   UrgencyDisplayOrder              = urg.DisplayOrder,
	   IsDelete                         = vrt.IsDelete
	FROM (
			SELECT *
			FROM [dbo].[ResultTracking_ObservationOrder](@PatientUid)
			UNION ALL
			SELECT *
			FROM [dbo].[ResultTracking_RelAttachmentGroup](@PatientUid)
		) AS vrt
		LEFT JOIN [Person] AS pat WITH(NOLOCK) ON pat.PersonUid = vrt.PatientUid
		LEFT JOIN [Person] AS prv WITH(NOLOCK) ON prv.PersonUid = vrt.ProviderUid
		LEFT JOIN [Person] AS app WITH(NOLOCK) ON app.PersonUid = vrt.ApproveProviderUid
		LEFT JOIN [Person] AS ref WITH(NOLOCK) ON ref.PersonUid = vrt.ReferredByProviderUid
		LEFT JOIN [ListServiceSite] AS lss WITH(NOLOCK) ON lss.ServiceSiteUid = vrt.ServiceSiteUid
		LEFT JOIN [ListMessageUrgency] AS urg WITH(NOLOCK) ON urg.MessageUrgencyUid = vrt.MessageUrgencyUid

)
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindProcedure]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewFindProcedure]
AS
SELECT
   ViewFindProcedureUid     = prc.ProcedureUid, 
   ProcedureUid             = prc.ProcedureUid, 
   ExternalID               = prc.ExternalID, 
   Inactive                 = prc.Inactive, 
   Code                     = prc.Code, 
   ProcedureCodeTypeUid     = prc.ProcedureCodeTypeUid, 
   ProcedureCodeTypeName    = pct.Name, 
   ShortDescription         = prc.ShortDescription,
   LongDescription          = ISNULL(LEFT(tab.LabNames, LEN(tab.LabNames)-1) + '': '', '''') + prc.LongDescription, 
   IDDescription            = COALESCE (''('' + prc.Code + '') '', '''') + prc.ShortDescription, 
   Notes                    = prc.Notes, 
   IsEM                     = prc.IsEM, 
   ProcedureGroupUid        = prc.ProcedureGroupUid, 
   LaboratoryUids           = LEFT(tbl.LabUids, LEN(tbl.LabUids)-1),
   Unit                     = prc.Unit,
   ProcedureModifier1Uid    = prc.ProcedureModifier1Uid, 
   ProcedureModifier2Uid    = prc.ProcedureModifier2Uid, 
   ProcedureModifier3Uid    = prc.ProcedureModifier3Uid, 
   ProcedureModifier4Uid    = prc.ProcedureModifier4Uid, 
   GenerateObservationOrder = prc.GenerateObservationOrder, 
   FDB_MEDID                = prc.FDB_MEDID, 
   RevenueCode              = prc.RevenueCode, 
   AddInProcedure           = CAST(0 AS TINYINT), 
   DefaultDontClaim         = prc.DefaultDontClaim, 
   HistoryGroupUid          = prc.HistoryGroupUid,
   SortToBottom				= prc.SortToBottom
FROM dbo.ListProcedure AS prc 
LEFT JOIN dbo.ListProcedureCodeType AS pct ON pct.ProcedureCodeTypeUid = prc.ProcedureCodeTypeUid
OUTER APPLY (
   SELECT lab.Name + '',''
   FROM RelProcedureLaboratoryOrder rel
   INNER JOIN ListLaboratoryOrder llo ON llo.LaboratoryOrderUid = rel.LaboratoryOrderUid
   INNER JOIN ListLaboratory lab ON lab.LaboratoryUid = llo.LaboratoryUid
   WHERE rel.ProcedureUid = prc.ProcedureUid
   ORDER BY rel.DisplayOrder 
   FOR XML PATH('''')) tab(LabNames)
OUTER APPLY (
   SELECT UPPER(CONVERT(VARCHAR(50), lab.LaboratoryUid)) + '',''
   FROM RelProcedureLaboratoryOrder rel
   INNER JOIN ListLaboratoryOrder llo ON llo.LaboratoryOrderUid = rel.LaboratoryOrderUid
   INNER JOIN ListLaboratory lab ON lab.LaboratoryUid = llo.LaboratoryUid
   WHERE rel.ProcedureUid = prc.ProcedureUid
   ORDER BY rel.DisplayOrder 
   FOR XML PATH('''')) tbl(LabUids)
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDFViewFindProcedureRVU]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'


CREATE FUNCTION [dbo].[UDFViewFindProcedureRVU]
(	
	@RVUScheduleUid UNIQUEIDENTIFIER
)
RETURNS TABLE 
AS
RETURN 
(
	-- Add the SELECT statement with parameter references here
	SELECT	p.*,
			rsv.WorkRVU + rsv.RBNonFacilityPERVU + rsv.RBFacilityPERVU + rsv.MPRVU AS RVU, rsv.RVUScheduleUid
	FROM	ViewFindProcedure p LEFT JOIN RVUScheduleValue rsv ON rsv.RVUScheduleUid = @RVUScheduleUid AND p.ProcedureUid = rsv.ProcedureUid
)


' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[CarrierPaidOnVisit]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[CarrierPaidOnVisit](@VisitUid UNIQUEIDENTIFIER, @InsuranceCarrierUids UIDLIST READONLY)
RETURNS TABLE
AS
RETURN
		SELECT COALESCE(sub.Paid,0) AS Paid
		FROM (VALUES(@VisitUid)) AS v2(u)
		OUTER APPLY (
			SELECT TOP 1 CASE WHEN L.EntryType = 2 AND corp.CorporationUid IS NOT NULL THEN 1 ELSE NULL END AS Paid
			FROM Superbill sb WITH (NOLOCK)
				LEFT JOIN Account act WITH (NOLOCK) on sb.AccountUid = act.AccountUid
				LEFT JOIN AccountPeriod ap WITH (NOLOCK) on act.AccountUid = ap.AccountUid 
							and (ap.EffectiveDate is null or ap.EffectiveDate <= sb.ServiceDateEnd)
							and (ap.ExpirationDate is null or DateAdd(dd, 1, ap.ExpirationDate) > sb.ServiceDateEnd)
				LEFT JOIN AccountInsurance ai WITH (NOLOCK) on ap.AccountPeriodUid = ai.AccountPeriodUid	
				LEFT JOIN PersonInsurancePlan pip WITH (NOLOCK) on ai.PersonInsurancePlanUid = pip.PersonInsurancePlanUid
				LEFT JOIN InsurancePlan ip WITH (NOLOCK) on pip.InsurancePlanUid = ip.InsurancePlanUid
				--inner join InsuranceCarrier ic on ip.InsuranceCarrierUid = ic.CorporationUid
				LEFT JOIN Corporation corp WITH (NOLOCK) on ip.InsuranceCarrierUid = corp.CorporationUid AND corp.CorporationUid IN(select uid from @InsuranceCarrierUids)
				LEFT JOIN SuperbillProcedure SBP ON SB.SuperbillUid = SBP.SuperbillUid
				LEFT JOIN AR_LedgerDetail LD ON SBP.SuperbillProcedureUid = LD.SuperbillProcedureUid
				LEFT JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid
				LEFT JOIN AR_Ledger L_VOID ON L.LedgerUid = L_VOID.VoidLedgerUid
			WHERE (L.VoidLedgerUid IS NULL AND L_VOID.LedgerUid IS NULL) -- filter out voids
					AND L.EntryType = 2 -- distributions
					AND LD.LiabilityOwner > 0 -- insurance only
					AND v2.u = sb.VisitUid
		) sub' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[eRxDownloadSettingFromXML]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[eRxDownloadSettingFromXML]
(
   @itemsXml XML
)
RETURNS TABLE
AS
RETURN
(
   SELECT
      (SELECT x.n.value(''@Value'',''bit'') AS Value
       FROM @itemsXml.nodes(''/root/Control[@Name = ''''_checkeMedHx'''']'') AS x(n)
      ) AS DownloadeMedHx,
      (SELECT x.n.value(''@Value'',''bit'') AS Value
       FROM @itemsXml.nodes(''/root/Control[@Name = ''''_radioLastSuccessfulDate'''']'') AS x(n)
      ) AS LastSuccessfulDate,
      (SELECT x.n.value(''@Value'',''bit'') AS Value
       FROM @itemsXml.nodes(''/root/Control[@Name = ''''_radioDownloadPreviuos'''']'') AS x(n)
      ) AS DownloadPreviuos,
      (SELECT x.n.value(''@Value'',''smallint'') AS Value
       FROM @itemsXml.nodes(''/root/Control[@Name = ''''numericDays'''']'') AS x(n)
      ) AS MonthstoDownload,
      (SELECT x.n.value(''@Value'',''bit'') AS Value
       FROM @itemsXml.nodes(''/root/Control[@Name = ''''_checkRxBenefits'''']'') AS x(n)
      ) AS DownloadRxBenefits,
      (SELECT x.n.value(''@Value'',''bit'') AS Value
       FROM @itemsXml.nodes(''/root/Control[@Name = ''''_checkDAWIgnoreMatch'''']'') AS x(n)
      ) AS DAWIgnoreMatch
)
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetCalendarUid]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[GetCalendarUid]
(@providerUid uniqueidentifier, @startDateTime datetime)
RETURNS table
AS
	RETURN 
(
	SELECT lc.CalendarUid
	FROM ListCalendar lc
	LEFT OUTER JOIN RelCalendarCalendarTemplateHead rccth
		ON rccth.calendarUid = lc.CalendarUid 
		AND rccth.StartDate <= Convert(varchar(10), @startDateTime, 101)
		AND (rccth.EndDate IS NULL OR rccth.EndDate >= Convert(varchar(10), @startDateTime, 101))
	LEFT OUTER JOIN ListCalendarTemplateHead lcth
		ON lcth.CalendarTemplateHeadUid = rccth.CalendarTemplateHeadUid 
		AND lcth.Inactive = 0
	LEFT OUTER JOIN ListCalendarTemplateDay lctd
		ON lctd.CalendarTemplateHeadUid = lcth.CalendarTemplateHeadUid 
		AND lctd.ProviderUid = @providerUid 
		AND lctd.TemplateDay = (DATEDIFF(day, rccth.StartDate, Convert(varchar(10), @startDateTime, 101)) % lcth.NumDays) + 1
	WHERE coalesce(lctd.ProviderUid, lc.DefaultProviderUid) = @providerUid
	AND lc.Inactive = 0
)

' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[GetPatientByPlanMemberID]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[GetPatientByPlanMemberID]
(	
	@planMemberID VARCHAR(50)
)
RETURNS TABLE 
AS
RETURN 
(
	SELECT DISTINCT	a.PersonUid
	FROM			PersonInsurancePlan pip INNER JOIN AccountInsurance ai ON pip.PersonInsurancePlanUid = ai.PersonInsurancePlanUid
					INNER JOIN AccountPeriod ap ON ai.AccountPeriodUid = ap.AccountPeriodUid
					INNER JOIN Account a ON ap.AccountUid = a.AccountUid
					INNER JOIN Patient pat ON a.PersonUid = pat.PersonUid
	WHERE			pip.PlanMemberID = @planMemberID
)
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[IMO_ViewFindProblemIT_Keywords]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[IMO_ViewFindProblemIT_Keywords]
(	
	@SearchFilter [nvarchar](75)
)
RETURNS TABLE 
AS
RETURN 
(
	SELECT [Code], [WORD_TEXT], [WORD_POS]
	FROM [IMO_ProblemIT_Keywords] WITH(NOLOCK)
	WHERE [WORD_TEXT] LIKE @SearchFilter + N''%''
	UNION
	SELECT CAST(C.[CustomLexCode] AS [bigint]) AS [Code], WI.[WORD_TEXT], WI.[WORD_POS]
	FROM [IMO_ProblemIT_Custom] AS C WITH(NOLOCK)
		INNER JOIN [IMO_ProblemIT_Custom_Word_Index] AS WI WITH(NOLOCK) ON C.[IMO_ProblemIT_Custom_Uid] = WI.[IMO_ProblemIT_Custom_Uid]
	WHERE WI.[WORD_TEXT] LIKE CAST (@SearchFilter + ''%'' AS [varchar](75))
)
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[RemoveWhitespace]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[RemoveWhitespace](@xml VARCHAR(MAX)) 
	RETURNS TABLE 
	AS
	RETURN (SELECT LTRIM(RTRIM(REPLACE(REPLACE(REPLACE(@xml, char(13), '' ''), char(10), '' ''), char(9), '' ''))) AS CleanXml)' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_PatientHeightWtBP]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_PatientHeightWtBP] (@PatientUid UNIQUEIDENTIFIER)
RETURNS TABLE
AS
RETURN (
	--DECLARE @ObservationItem_Weight_kg        UNIQUEIDENTIFIER = ''00000000-0000-0000-7777-100000000070''
	--DECLARE @ObservationItem_Height_cm        UNIQUEIDENTIFIER = ''00000000-0000-0000-7777-100000000071''
	--DECLARE @ObservationItem_BloodPressure_01 UNIQUEIDENTIFIER = ''00000000-0000-0000-7777-100000000073''
	--DECLARE @ObservationItem_BloodPressure_02 UNIQUEIDENTIFIER = ''00000000-0000-0000-7777-100000000074''
	--DECLARE @ObservationItem_BloodPressure_03 UNIQUEIDENTIFIER = ''00000000-0000-0000-7777-100000000075''
	--DECLARE @ObservationItem_BloodPressure_04 UNIQUEIDENTIFIER = ''00000000-0000-0000-7777-100000000076''

	--DECLARE @VisitTypeStrikeOut UNIQUEIDENTIFIER = ''FB954167-9D1C-43B7-9F5B-A76260654C96''
	
	SELECT MAX(s.[Weight]) AS [Weight],MAX(s.Height) AS Height,MAX(s.BloodPressure) AS BloodPressure
	FROM (
		SELECT CASE WHEN ov.ObservationItemUid = ''00000000-0000-0000-7777-100000000070'' THEN 1 ELSE 0 END AS [Weight]
				,CASE WHEN ov.ObservationItemUid = ''00000000-0000-0000-7777-100000000071'' THEN 1 ELSE 0 END AS Height
				,CASE WHEN ov.ObservationItemUid IN (''00000000-0000-0000-7777-100000000073'',
														''00000000-0000-0000-7777-100000000074'',  
														''00000000-0000-0000-7777-100000000075'',
														''00000000-0000-0000-7777-100000000076'') THEN 1 
							ELSE 0 END AS BloodPressure
		FROM ObservationOrder oo 
		LEFT JOIN ObservationValue ov ON ov.ObservationOrderUid = oo.ObservationOrderUid
				AND ov.ObservationItemUid IN(''00000000-0000-0000-7777-100000000073'',
		                                    ''00000000-0000-0000-7777-100000000074'',  
		                                    ''00000000-0000-0000-7777-100000000075'',
		                                    ''00000000-0000-0000-7777-100000000076'',
											''00000000-0000-0000-7777-100000000071'',
											''00000000-0000-0000-7777-100000000070'')  
		LEFT JOIN Visit v WITH(NOLOCK) on oo.visituid=v.visituid
		WHERE oo.PatientUid = @PatientUid
		AND oo.IsDelete=0
		AND (
			v.visittypeuid <> ''FB954167-9D1C-43B7-9F5B-A76260654C96''
			OR v.visittypeuid IS NULL
			)
	) s
)' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_PortalAccountActive]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_PortalAccountActive]
(
       @PatientUid UNIQUEIDENTIFIER
)
RETURNS TABLE
AS 
RETURN (
		SELECT pw.PersonUid
--			,CAST(NULL AS DATE) AS CreatedDate
			,CAST(pw.CreatedDateTime AS DATE) AS CreatedDate
--			,CAST(pw.ExpirationDate AS DATE) AS ExpirationDate
			,CAST(NULL AS DATE) AS ExpirationDate
		FROM RelPatientPersonWeb rel
		INNER JOIN AccountResponsibleParty rp ON rel.PatientUid=rp.PersonUid
		LEFT JOIN Account a on rp.AccountResponsiblePartyUid = rp.AccountResponsiblePartyUid
--		INNER JOIN PersonWeb pw ON (pw.PersonUid=a.PersonUid OR pw.PersonUid=rp.PersonUid)
		INNER JOIN PersonWeb pw ON (pw.PersonUid=a.PersonUid) and pw.PatientWebAccess = 1
		WHERE a.PersonUid=@PatientUid
			AND (
				rel.PersonUid=pw.PersonUid
				)
	)
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_VisitHasEduForm]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_VisitHasEduForm] (@VisitUid UNIQUEIDENTIFIER)
RETURNS TABLE
AS 
RETURN (
		SELECT MAX(CASE WHEN vef.VisitUid IS NOT NULL THEN 1
				ELSE 0 END) AS HasEduForm
			,MIN(vef.PrintedDate) AS PrintedDate
		FROM VisitEduForm vef
		WHERE vef.IsDelete=0
			AND vef.VisitUid=@VisitUid
			AND (vef.ReportUid IS NULL OR vef.ReportUid != ''900377C9-D12C-4F73-B5F0-429FF928DEF8'')
)
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDF_VisitIsEMIsVP]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDF_VisitIsEMIsVP] (@VisitUid UNIQUEIDENTIFIER)
RETURNS TABLE
AS
RETURN (

	SELECT MAX(CONVERT(SMALLINT,COALESCE(lp.IsEM,0))) AS IsEM, MAX(CONVERT(SMALLINT,COALESCE(vp.IsPerformed,0))) AS IsVP
	FROM VisitProcedure vp
	INNER JOIN ListProcedure lp ON vp.ProcedureUid=lp.ProcedureUid
	WHERE vp.VisitUid=@VisitUid
		AND vp.IsDelete=0
)
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[UDFAttachmentGroup]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[UDFAttachmentGroup](@attachmentcontext smallint)
RETURNS TABLE AS RETURN
(
	SELECT	DISTINCT
			rel.RelAttachmentGroupUid, ag.AttachmentGroupUid,
			a.AttachmentUid AS FirstAttachmentUid,
			rel.PersonUid, rel.VisitUid, rel.AccountResponsiblePartyUid, rel.DepositUid,
			rel.IncludeInSummary, 
			CAST(CASE WHEN rel.Inactive = 1 OR ag.Inactive = 1 THEN 1 ELSE 0 END AS BIT) AS Inactive,
			ag.AttachmentTypeUid, lat.[Name] AS AttachmentType, lat.Color AS AttachmentTypeColor,
			ag.[Name], ag.Notes,
			ag.LastModifiedDate,
            CASE WHEN a.AttachmentUid IS NULL OR EXISTS(SELECT * FROM Attachment WHERE AttachmentGroupUid = ag.AttachmentGroupUid AND StrikeOut = 0) THEN 0 ELSE 1 END AS StrikeOut,
			CONVERT(varbinary,NULL) as ThumbnailAttachmentContent, NULL as ThumbnailAttachmentContentType,
			CASE WHEN a.ThumbnailAttachmentContent IS NOT NULL THEN 1 ELSE 0 END AS HasThumbnail,
			a.AttachmentContentType,
			v.VisitDate,
			v.VisitTypeUid,
			@attachmentcontext AS AttachmentContext,
			a.[FileName],
			a.FileExtension,
			rel.ObservationOrderUid,
			rel.PatientProcedureUid
	FROM	RelAttachmentGroup rel INNER JOIN AttachmentGroup ag ON rel.AttachmentGroupUid = ag.AttachmentGroupUid
			LEFT JOIN Attachment a ON ag.AttachmentGroupUid = a.AttachmentGroupUid AND a.AttachmentUid = (SELECT TOP 1 AttachmentUid FROM Attachment WHERE AttachmentGroupUid = ag.AttachmentGroupUid ORDER BY DisplayOrder)
			LEFT JOIN Visit v ON rel.VisitUid = v.VisitUid
			LEFT JOIN ListAttachmentType lat ON ag.AttachmentTypeUid = lat.AttachmentTypeUid
)




' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewFormularyRestrictions]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ViewFormularyRestrictions](@FormularyCoverageOrgUid UNIQUEIDENTIFIER)
RETURNS TABLE AS RETURN
   SELECT
      medid          = dis.medid,
      Restrictions   = SUBSTRING(CONVERT(VARCHAR(50),
                          CASE WHEN EXISTS(SELECT TOP 1 * FROM dbo.FormularyCoverageNDC     cvg (NOLOCK) WHERE cvg.FormularyCoverageOrgUid = @FormularyCoverageOrgUid AND cvg.medid = dis.medid AND cvg.CoverageListType = ''AL'') THEN ''|AL'' ELSE '''' END +
                          CASE WHEN EXISTS(SELECT TOP 1 * FROM dbo.FormularyCoverageNDC     cvg (NOLOCK) WHERE cvg.FormularyCoverageOrgUid = @FormularyCoverageOrgUid AND cvg.medid = dis.medid AND cvg.CoverageListType = ''DE'') THEN ''|DE'' ELSE '''' END +
                          CASE WHEN EXISTS(SELECT TOP 1 * FROM dbo.FormularyCoverageNDC     cvg (NOLOCK) WHERE cvg.FormularyCoverageOrgUid = @FormularyCoverageOrgUid AND cvg.medid = dis.medid AND cvg.CoverageListType = ''GL'') THEN ''|GL'' ELSE '''' END +
                          CASE WHEN EXISTS(SELECT TOP 1 * FROM dbo.FormularyCoverageNDC     cvg (NOLOCK) WHERE cvg.FormularyCoverageOrgUid = @FormularyCoverageOrgUid AND cvg.medid = dis.medid AND cvg.CoverageListType = ''MN'') THEN ''|MN'' ELSE '''' END +
                          CASE WHEN EXISTS(SELECT TOP 1 * FROM dbo.FormularyCoverageNDC     cvg (NOLOCK) WHERE cvg.FormularyCoverageOrgUid = @FormularyCoverageOrgUid AND cvg.medid = dis.medid AND cvg.CoverageListType = ''PA'') THEN ''|PA'' ELSE '''' END +
                          CASE WHEN EXISTS(SELECT TOP 1 * FROM dbo.FormularyCoverageNDC     cvg (NOLOCK) WHERE cvg.FormularyCoverageOrgUid = @FormularyCoverageOrgUid AND cvg.medid = dis.medid AND cvg.CoverageListType = ''QL'') THEN ''|QL'' ELSE '''' END +
                          CASE WHEN EXISTS(SELECT TOP 1 * FROM dbo.FormularyCoverageNDC     cvg (NOLOCK) WHERE cvg.FormularyCoverageOrgUid = @FormularyCoverageOrgUid AND cvg.medid = dis.medid AND cvg.CoverageListType = ''RD'') THEN ''|RD'' ELSE '''' END +
                          CASE WHEN EXISTS(SELECT TOP 1 * FROM dbo.FormularyCoverageSummary cvg (NOLOCK) WHERE cvg.FormularyCoverageOrgUid = @FormularyCoverageOrgUid AND                           cvg.CoverageListType = ''RS'') THEN ''|RS'' ELSE '''' END +
                          CASE WHEN EXISTS(SELECT TOP 1 * FROM dbo.FormularyCoverageNDC     cvg (NOLOCK) WHERE cvg.FormularyCoverageOrgUid = @FormularyCoverageOrgUid AND cvg.medid = dis.medid AND cvg.CoverageListType = ''SM'') THEN ''|SM'' ELSE '''' END +
                          CASE WHEN EXISTS(SELECT TOP 1 * FROM dbo.FormularyCoverageNDC     cvg (NOLOCK) WHERE cvg.FormularyCoverageOrgUid = @FormularyCoverageOrgUid AND cvg.medid = dis.medid AND cvg.CoverageListType = ''ST'') THEN ''|ST'' ELSE '''' END +
                          CASE WHEN EXISTS(SELECT TOP 1 * FROM dbo.FormularyCoverageNDC     cvg (NOLOCK) WHERE cvg.FormularyCoverageOrgUid = @FormularyCoverageOrgUid AND cvg.medid = dis.medid AND cvg.CoverageListType = ''TM'') THEN ''|TM'' ELSE '''' END), 2, 100)
   FROM dbo.fdb_dispensable dis
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindDrugName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ViewFindDrugName](@includeBrandName bit = 1, @includeGenericName bit = 1)

RETURNS TABLE

AS

 RETURN (SELECT DISTINCT
	dbo.FDB_DrugName.DrugNameUid, 
	dbo.FDB_DrugName.mnid, 
	dbo.FDB_DrugName.descdisplay, 
	dbo.FDB_DrugName.descsearch, 
	dbo.FDB_DrugName.nametypecode, 
	dbo.FDB_DrugName.obsoletedate, 
	IsNull(dbo.FDB_DrugName.statuscode, ''0'') AS StatusCode,
	fdb_drugname_1.descdisplay AS GenericDrugName, 
	dbo.FDB_DrugName.genericmnid AS GenericDrugNameID, 

    (select top 1 cls.ClassUid from dbo.fdb_etclassification_drugs etc 
      LEFT OUTER JOIN dbo.fdb_classification_etc cls ON (cls.classid = etc.classid)
		where (etc.conceptid = dbo.FDB_DrugName.mnid) AND (etc.concepttype = 1) order by etc.classid) 
								AS [ClassUid],
    (select top 1 cls.classid from dbo.fdb_etclassification_drugs etc 
      LEFT OUTER JOIN dbo.fdb_classification_etc cls ON (cls.classid = etc.classid)
		where (etc.conceptid = dbo.FDB_DrugName.mnid) AND (etc.concepttype = 1) order by etc.classid) 
								AS [ClassID],
    (select top 1 cls.description1 from dbo.fdb_etclassification_drugs etc 
      LEFT OUTER JOIN dbo.fdb_classification_etc cls ON (cls.classid = etc.classid)
		where (etc.conceptid = dbo.FDB_DrugName.mnid) AND (etc.concepttype = 1) order by etc.classid)
								AS [ClassDescription],
	dbo.FDB_DrugName.ExternalID,
	dbo.FDB_DrugName.Inactive, 
	dbo.FDB_DrugName.UserDefined,
	(SELECT TOP 1 hicl 
	  FROM fdb_mnid_hicl 
      WHERE fdb_mnid_hicl.mnid = dbo.FDB_DrugName.mnid
	  ORDER BY hicl)			AS HICL

FROM	dbo.FDB_DrugName 
		LEFT OUTER JOIN dbo.FDB_DrugName AS fdb_drugname_1 
			ON dbo.FDB_DrugName.genericmnid = fdb_drugname_1.mnid 

WHERE	(IsNull(dbo.FDB_DrugName.medicaldeviceind, 0) = 0) AND
		((dbo.FDB_DrugName.UserDefined > 0 and dbo.FDB_DrugName.nametypecode is null)
		  OR
			-- note: column nametypecode is a varchar(1) and can never be ''999''
			(dbo.FDB_DrugName.nametypecode in (
				(CASE @includeBrandName WHEN 1 THEN ''1'' ELSE ''999'' END),
				(CASE @includeGenericName WHEN 1 THEN ''2'' ELSE ''999'' END)
		)))
 )






' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindEMSystemBodyArea]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ViewFindEMSystemBodyArea]	(@EMExaminationDescriptionUid uniqueidentifier, @EMKeyComponentUid uniqueidentifier) RETURNS 
	TABLE AS RETURN
(
	SELECT 
		[EMSystemBodyAreaUid],
		[ExternalID],
		[Inactive],
		[Name],
		[Notes],
		[UserDefined]
	FROM dbo.ListEMSystemBodyArea
	WHERE dbo.ListEMSystemBodyArea.EMSystemBodyAreaUid IN
		(
			SELECT DISTINCT EMSystemBodyAreaUid 
			FROM  dbo.RelEMKeyComponentBullet 
			WHERE EMExaminationDescriptionUid = @EMExaminationDescriptionUid
			AND EMKeyComponentUid = @EMKeyComponentUid
		)	
)
			





' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindEquivalentDrugName]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ViewFindEquivalentDrugName](@includeBrandName bit = 1, @includeGenericName bit = 1, @mnid int)

RETURNS TABLE

AS

 RETURN 
(

SELECT	dbo.FDB_DrugName.DrugNameUid, 
			dbo.FDB_Classification_ETC.ClassUid,
			dbo.FDB_DrugName.mnid, 
			dbo.FDB_DrugName.descdisplay, 
			dbo.FDB_DrugName.descsearch, 
			dbo.FDB_DrugName.nametypecode, 
			dbo.FDB_DrugName.obsoletedate, 
			dbo.FDB_DrugName.statuscode, 
			fdb_drugname_1.descdisplay AS GenericDrugName, 
			dbo.FDB_DrugName.genericmnid AS GenericDrugNameID, 
			dbo.FDB_Classification_ETC.description1 AS ClassDescription, 
			dbo.FDB_Classification_ETC.classid,
			dbo.FDB_DrugName.ExternalID,
			dbo.FDB_DrugName.Inactive, 
			dbo.FDB_DrugName.UserDefined,
			(SELECT TOP 1 fdb_mnid_hicl.hicl 
			FROM fdb_mnid_hicl 
			WHERE fdb_mnid_hicl.mnid = dbo.FDB_DrugName.mnid) as HICL
FROM	dbo.FDB_DrugName 
		INNER JOIN dbo.FDB_DrugName AS fdb_drugname_1 
			ON dbo.FDB_DrugName.genericmnid = fdb_drugname_1.mnid 
		INNER JOIN fdb_mnid_hicl fdb_linktwo
			ON fdb_linktwo.mnid <> @mnid and fdb_linktwo.mnid = fdb_drugname.mnid
		INNER JOIN fdb_mnid_hicl fdb_linkone
			ON fdb_linkone.mnid = @mnid and fdb_linkone.hicl = fdb_linktwo.hicl

		LEFT OUTER JOIN dbo.FDB_ETClassification_Drugs 
			ON dbo.FDB_ETClassification_Drugs.conceptid = dbo.FDB_DrugName.mnid AND 
                  dbo.FDB_ETClassification_Drugs.concepttype = 1 
		LEFT OUTER JOIN dbo.FDB_Classification_ETC 
			ON dbo.FDB_Classification_ETC.classid = dbo.FDB_ETClassification_Drugs.classid

WHERE	(dbo.FDB_DrugName.medicaldeviceind = 0) AND
		(dbo.FDB_DrugName.mnid <> -1) AND
			-- note: column nametypecode is a varchar(1) and can never be ''999''
			(dbo.FDB_DrugName.nametypecode in (
				(CASE @includeBrandName WHEN 1 THEN ''1'' ELSE ''999'' END),
				(CASE @includeGenericName WHEN 1 THEN ''2'' ELSE ''999'' END)
			))
 )














' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindRoutedDrug]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ViewFindRoutedDrug](@includeBrandName bit = 1, @includeGenericName bit = 1)

RETURNS TABLE

AS

 RETURN ( SELECT DISTINCT
	dbo.FDB_RoutedDrug.RoutedDrugUid, 
	dbo.FDB_Classification_ETC.ClassUid,
	dbo.FDB_RoutedDrug.rmid, 
	dbo.FDB_RoutedDrug.mnid,
	(SELECT TOP 1 hicl 
	  FROM fdb_mnid_hicl 
      WHERE fdb_mnid_hicl.mnid = dbo.FDB_RoutedDrug.mnid
	  ORDER BY hicl)			AS HICL, 
	dbo.FDB_RoutedDrug.descdisplay, 
	dbo.FDB_RoutedDrug.descsearch, 
	dbo.FDB_DrugName.descdisplay AS DrugName,
	dbo.fdb_route.Description1 AS [Route],
	dbo.FDB_RoutedDrug.nametypecode, 
	dbo.FDB_RoutedDrug.obsoletedate, 
	IsNull(dbo.FDB_RoutedDrug.statuscode, ''0'') AS StatusCode, 
	dbo.FDB_Classification_ETC.description1 AS ClassDescription, 
	dbo.FDB_Classification_ETC.classid,
	dbo.FDB_RoutedDrug.Inactive, 
	dbo.FDB_RoutedDrug.UserDefined

FROM	dbo.FDB_RoutedDrug 
      INNER JOIN dbo.FDB_DrugName ON (dbo.FDB_DrugName.DrugNameUid = dbo.FDB_RoutedDrug.DrugNameUid)
      LEFT OUTER JOIN dbo.fdb_route ON (dbo.fdb_route.rtid = dbo.FDB_RoutedDrug.rtid)
	  LEFT OUTER JOIN dbo.FDB_ETClassification_Drugs 
			ON dbo.FDB_ETClassification_Drugs.conceptid = dbo.FDB_DrugName.mnid AND 
                  dbo.FDB_ETClassification_Drugs.concepttype = 1 
	  LEFT OUTER JOIN dbo.FDB_Classification_ETC 
			ON dbo.FDB_Classification_ETC.classid = dbo.FDB_ETClassification_Drugs.classid
WHERE	((dbo.FDB_RoutedDrug.UserDefined > 0 and dbo.FDB_RoutedDrug.nametypecode is null)
		  OR
			-- note: column nametypecode is a varchar(1) and can never be ''999''
			(dbo.FDB_RoutedDrug.nametypecode in (
				(CASE @includeBrandName WHEN 1 THEN ''1'' ELSE ''999'' END),
				(CASE @includeGenericName WHEN 1 THEN ''2'' ELSE ''999'' END)
		)))
)
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewFormularyCost]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ViewFormularyCost](@FormularyIdentifierUid UNIQUEIDENTIFIER)
RETURNS TABLE AS RETURN
   SELECT
      medid                     = dis.medid,
      FormularyProdCostIndexUid = frm.FormularyProdCostIndexUid
   FROM dbo.fdb_dispensable dis
   LEFT JOIN dbo.FormularyOrg org (NOLOCK) ON org.FormularyIdentifierUid = @FormularyIdentifierUid
   LEFT JOIN dbo.FormularyProductNDC frm (NOLOCK) ON frm.FormularyIdentifierUid = @FormularyIdentifierUid
                                        AND frm.medid = dis.medid
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewFormularyNDC]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ViewFormularyNDC](@FormularyIdentifierUid UNIQUEIDENTIFIER, @FormularyCoverageOrgUid UNIQUEIDENTIFIER)
RETURNS TABLE AS RETURN
   SELECT
      medid = dis.medid,
      NDC =
         CASE
            -- drug exclusion
            WHEN cvg.CoverageListType = ''DE'' THEN cvg.NDC

            -- ndc specific
            WHEN frm.FormularyProdFormuStatUid IS NOT NULL THEN frm.NDC

            -- summary level
            ELSE
               (SELECT TOP 1 pkg.pmid
                FROM dbo.fdb_packageddrug pkg
                WHERE pkg.medid = dis.medid
                ORDER BY
                   CASE WHEN dis.reffederaldeaclasscode = ''6'' AND pkg.obsoletedate < DATEADD(yy, -3, GETUTCDATE()) THEN 99 ELSE 0 END,
                   CASE WHEN dis.reffederaldeaclasscode = ''6'' AND pkg.federaldeaclasscode IN(''1'',''2'',''3'',''4'',''5'') THEN pkg.federaldeaclasscode ELSE 99 END,
                   ISNULL(pkg.obsoletedate, ''20990101'') DESC,
                   pkg.unitdosepackagingind,
                   pkg.repackagerind,
                   pkg.privlabeledprodind,
                   pkg.standardpackind DESC,
                   pkg.packagesize,
                   pkg.pmid)
         END
   FROM dbo.fdb_dispensable dis
   LEFT JOIN dbo.FormularyCoverageNDC cvg (NOLOCK) ON cvg.FormularyCoverageOrgUid = @FormularyCoverageOrgUid
                                                  AND cvg.medid = dis.medid
                                                  AND cvg.CoverageListType = ''DE''
   LEFT JOIN dbo.FormularyProductNDC frm (NOLOCK) ON frm.FormularyIdentifierUid = @FormularyIdentifierUid
                                                 AND frm.medid = dis.medid
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewFormularyStatus]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'
CREATE FUNCTION [dbo].[ViewFormularyStatus](@FormularyIdentifierUid UNIQUEIDENTIFIER, @FormularyCoverageOrgUid UNIQUEIDENTIFIER)
RETURNS TABLE AS RETURN
   SELECT
      medid                     = dis.medid,
      FormularyProdFormuStatUid = CASE
                                     -- drug exclusion
                                     WHEN cvg.CoverageListType = ''DE'' THEN
                                 (SELECT FormularyProdFormuStatUid
                                  FROM ListFormularyProdFormuStat (NOLOCK)
                                  WHERE FormularyVendorUid = ''00000000-0000-0000-0000-000000000002''
                                    AND (ISNUMERIC([FormularyStatus]) <> 0 AND CAST ([FormularyStatus] AS [int]) = 0)
                                 )

                                     -- ndc specific
                                     WHEN frm.FormularyProdFormuStatUid IS NOT NULL THEN frm.FormularyProdFormuStatUid

                                     -- not in package database
                                     WHEN NOT EXISTS(SELECT TOP 1 * FROM fdb_packageddrug pkg WHERE pkg.medid = dis.medid) THEN
                                 (SELECT FormularyProdFormuStatUid
                                  FROM ListFormularyProdFormuStat (NOLOCK)
                                  WHERE FormularyVendorUid = ''00000000-0000-0000-0000-000000000002''
                                    AND FormularyStatus = ''U''
                                 )

                                     -- summary level
                                     WHEN dis.refgenericdrugnamecode = ''0''                                                                       THEN org.UnlistedSuppliesFormularyStatusUid
                                     WHEN dis.refgenericdrugnamecode != ''0'' AND dis.nametypecode = ''1'' AND dis.reffederallegendcode IN(''2'', ''3'') THEN org.UnlistedBrandOTCFormularyStatusUid
                                     WHEN dis.refgenericdrugnamecode != ''0'' AND dis.nametypecode = ''2'' AND dis.reffederallegendcode IN(''2'', ''3'') THEN org.UnlistedGenericOTCFormularyStatusUid
                                     WHEN dis.refgenericdrugnamecode != ''0'' AND dis.nametypecode = ''1''                                           THEN org.UnlistedBrandFormularyStatusUid
                                     WHEN dis.refgenericdrugnamecode != ''0'' AND dis.nametypecode = ''2''                                           THEN org.UnlistedGenericFormularyStatusUid
                                  END
   FROM dbo.fdb_dispensable dis
   LEFT JOIN dbo.FormularyOrg org (NOLOCK) ON org.FormularyIdentifierUid = @FormularyIdentifierUid
   LEFT JOIN dbo.FormularyCoverageNDC cvg (NOLOCK) ON cvg.FormularyCoverageOrgUid = @FormularyCoverageOrgUid
                                         AND cvg.medid = dis.medid
                                         AND cvg.CoverageListType = ''DE''
   LEFT JOIN dbo.FormularyProductNDC frm (NOLOCK) ON frm.FormularyIdentifierUid = org.FormularyIdentifierUid
                                        AND frm.FormularyIdentifierUid = @FormularyIdentifierUid
                                        AND frm.medid = dis.medid
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.objects WHERE object_id = OBJECT_ID(N'[dbo].[ViewUserFilter]') AND type in (N'FN', N'IF', N'TF', N'FS', N'FT'))
BEGIN
execute dbo.sp_executesql @statement = N'CREATE FUNCTION [dbo].[ViewUserFilter](@type varchar(50), @userPRMUid uniqueidentifier) RETURNS TABLE AS RETURN   
SELECT
	f.FilterUid,
	f.ExternalID,
	f.Inactive,
	f.Name,
	f.Type,
	f.Criteria,
	f.Sort,
	f.Columns,
	f.UserPRMUid,
	f.LastModifiedByUid,
	f.LastModifiedDate,
	f.UserDefined,
	   CASE WHEN fu.RelFilterUserPRMUid IS NULL THEN 0 ELSE 1 END AS DefaultFilter,  
	f.MaxRows,
	fu.RelFilterUserPRMUid,
    fu.SubType
 FROM ListFilter f LEFT JOIN RelFilterUserPRM fu ON f.Type = fu.Type AND f.FilterUid = fu.FilterUid AND fu.UserPRMUid = @userPRMUid  
 WHERE f.Type = @type   
' 
END

GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewActionTypeObjectPartnerMessage]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[ViewActionTypeObjectPartnerMessage]
AS
SELECT     ato.ObjectUid, ato.ObjectType, pm.SendFunction, pm.Send, ato.HL7ActionTypeObjectUid, pm.HL7PartnerUid
FROM         dbo.HL7ActionTypeObject AS ato INNER JOIN
                      dbo.HL7PartnerMessage AS pm ON ato.HL7PartnerMessageUid = pm.HL7PartnerMessageUid
WHERE     pm.Send = 1 and ato.ProcessingError = 0




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewListCacheMachine]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewListCacheMachine]  AS 
WITH ctePracticeSettings AS
(
	SELECT TOP 1 *
	FROM PracticeSettings
	ORDER BY LastModifiedDate DESC
)
SELECT		lcm.CacheMachineUid, 
			lcm.ID, 
			lcm.ExternalID, 
			lcm.Name, 
			lcm.URL, 
			lcm.Notes, 
			lcm.Inactive, 
			COALESCE (lcm.ReplicationAppointmentHours, ps.ReplicationAppointmentHours) AS ReplicationAppointmentHours, 
			COALESCE (lcm.ReplicationAttachmentSizeKB, ps.ReplicationAttachmentSizeKB) AS ReplicationAttachmentSizeKB,
			COALESCE (lcm.TriggerRemovePatientSeconds, ps.TriggerRemovePatientSeconds) AS TriggerRemovePatientSeconds,
			COALESCE (lcm.ReplicationRemovePatientHours, ps.ReplicationRemovePatientHours) AS ReplicationRemovePatientHours,
			COALESCE (lcm.TriggerReplicationSeconds, ps.TriggerReplicationSeconds) AS TriggerReplicationSeconds,
			lcm.EnableLogging, 
			lcm.Status, 
			lcm.ReplicateEverything,
			lcm.ReplicationMode, 
			lcm.LastModifiedByUid, 
			lcm.LastModifiedDate
FROM        dbo.ListCacheMachine AS lcm, ctePracticeSettings AS ps
WHERE		exists ( SELECT TOP 1 *
					 FROM dbo.ReplicationFilter AS rf
					 WHERE rf.CacheMachineUid = lcm.CacheMachineUid )
						or lcm.inactive = 1

' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewBatchClosingsLockedClosed]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[AR_ViewBatchClosingsLockedClosed] 
AS
SELECT ArBatchUid, Name AS ArBatchName, GlDate, IsLocked, IsClosed 
      FROM ARBatch
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewPatientHistory]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewPatientHistory] AS

SELECT	phd.PatientHistoryDetailUid AS [Uid],
		ph.PatientHistoryUid,
		ph.HistoryGroupUid,
		hg.Name AS HistoryGroup,
		ph.PatientUid,
		phd.QuestionUid,
		phd.QuestionName,
		phd.AnswerName,
		ph.OriginCreateTime,
		ph.ActiveDate,
		ph.InactiveDate,
		CASE WHEN hg.HistoryGroupUid = ''00000000-0000-0000-0000-000000000116''
			THEN 1
			ELSE
				CONVERT(int, act.val) 
			END AS IsActive,
		ph.Notes,
		phd.QuestionDisplayOrder
FROM	PatientHistory ph
		INNER JOIN ListMisc act ON ph.ActiveStateUid = act.MiscUid
		INNER JOIN PatientHistoryDetail phd ON ph.PatientHistoryUid = phd.PatientHistoryUid
		LEFT JOIN ListHistoryGroup hg ON ph.HistoryGroupUid = hg.HistoryGroupUid

-- tables PatientHistory and PatientDxHistory are not used in any verison of PRM 2016.  See Calvin for replacement
--UNION ALL
--SELECT	pp.PatientProblemUid as [Uid],
--		pp.PatientProblemUid AS PatientHistoryUid,
--		hg.HistoryGroupUid,
--		hg.Name AS HistoryGroup,		
--		pp.PatientUid,
--		NULL AS QuestionUid,
--		pp.Name AS QuestionName,
--		NULL AS AnswerName,
--		pp.RecordDateTime AS OriginCreateTime,
--		pp.ActiveDate,
--		pp.InactiveDate,
--		lps.ActiveStatus as IsActive,
--		pp.Notes,
--		NULL AS QuestionDisplayOrder
--FROM	PatientProblem pp
--		INNER JOIN ListProblemStatus lps on pp.ProblemStatusUid = lps.ProblemStatusUid
--		LEFT JOIN ListHistoryGroup hg ON hg.HistoryGroupUid = ''00000000-0000-0000-0000-000000000101''
--UNION ALL
--SELECT	pdxh.PatientDXHistoryUid as [Uid],
--		pdxh.PatientDxHistoryUid AS PatientHistoryUid,
--		hg.HistoryGroupUid,
--		hg.Name AS HistoryGroup,		
--		pdxh.PatientUid,
--		NULL AS QuestionUid,
--		pdxh.Name AS QuestionName,
--		NULL AS AnswerName,
--		pdxh.RecordDateTime AS OriginCreateTime,
--		pdxh.ActiveDate,
--		pdxh.InactiveDate,
--		CASE WHEN pdxh.IsDelete = 1 THEN 0 ELSE 1 END AS IsActive,
--		pdxh.Notes,
--		NULL AS QuestionDisplayOrder
--FROM	PatientDXHistory pdxh
--		LEFT JOIN ListHistoryGroup hg ON hg.HistoryGroupUid = ''00000000-0000-0000-0000-000000000101''




' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindUser]'))
EXEC dbo.sp_executesql @statement = N'




CREATE VIEW [dbo].[ViewFindUser]
AS
SELECT		p.PersonUid, 
			COALESCE(u.ExternalID, u.Login) AS ExternalID, u.Inactive, 
			u.[Login], 
			p.Prefix, p.FirstName, p.MiddleName, p.LastName, p.Suffix,
			p.AkaLastName + '', '' + p.AkaFirstName AS AKAName,
			COALESCE(p.AkaFirstName, '''') AS AkaFirstName, COALESCE(p.AkaLastName, '''') AS AkaLastName,
			CASE WHEN prov.PersonUid IS NULL THEN ''USER'' ELSE ''Provider'' END AS Type, ims.Name as InstantMessageStatus,
			p.Notes, CAST(NULL AS VARCHAR(255)) AS DirectMailAddress, CAST(NULL AS VARCHAR(255)) AS [Password], 
			CAST(NULL AS UNIQUEIDENTIFIER)TransmissionConfigurationUid
FROM        Person p INNER JOIN UserPRM u ON p.PersonUid = u.PersonUid 
			LEFT JOIN Provider prov ON u.PersonUid = prov.PersonUid
			LEFT JOIN ListInstantMessageStatus ims on u.InstantMessageStatusUid = ims.InstantMessageStatusUid			
			-- LEFT JOIN DirectMailUser dmu on prov.PersonUid = dmu.ProviderUid AND dmu.Inactive=0 
				-- AND dmu.IsUser = 1 -- Bug 39120 Removed Join - Causing Duplicates - Review Notes IN Bug








' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewSuperbillFinancialDetails]'))
EXEC dbo.sp_executesql @statement = N'


CREATE VIEW [dbo].[ViewSuperbillFinancialDetails] as
SELECT SuperbillUid, FinancialCenterUid, ServiceSiteUid, ClaimingProviderUid, RenderingProviderUid
	FROM SuperbillAggregate WITH (NOLOCK)
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewERAReasonCode]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewERAReasonCode]
AS
SELECT     ERACodeUid, ExternalID, Code, Type, StatementNote, InternalNote, Description, Notes, Inactive, UserDefined, LastModifiedDate
FROM         dbo.ListERACode
WHERE     (Type = ''Reason'')
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewPaymentEntryCredits_MedicaidPaper]'))
EXEC dbo.sp_executesql @statement = N'CREATE VIEW [dbo].[ViewPaymentEntryCredits_MedicaidPaper]
AS
SELECT cla.COBLineAdjustmentsUid as ViewPaymentEntryCredits_MedicaidPaperUid,  
     sbp.SuperbillUid,  
           cla.SuperbillProcedureUid,  
           cla.COBClaimDetailUid,  
           cla.CreditTypeUid,  
           cla.DepositUid,  
           cla.GroupCodeERACodeUid,  
           cla.ReasonCodeERACodeUid,  
           cla.Amount as Amount,  
           cla.Quantity,  
           cla.Notes,  
           cla.StatementNote,  
           ccd.InsuranceOrder LiabilityOwner  
    FROM COBLineAdjustments cla  
   inner join SuperbillProcedure sbp on cla.SuperbillProcedureUid = sbp.SuperbillProcedureUid  
   inner join Superbill sb on sbp.SuperbillUid = sb.SuperbillUid  
   left join COBClaimDetail ccd on cla.COBClaimDetailUid =ccd.COBClaimDetailUid  
UNION ALL  
SELECT LD.LedgerUid as ViewPaymentEntryCredits_MedicaidPaperUid,  
     SB.SuperbillUid,  
     SBP.SuperbillProcedureUid,  
     NULL as COBClaimDetailUid,  
     LCT.CreditTypeUid,  
     T.DepositUid,  
     L.GroupERACodeUid AS GroupCodeERACodeUid,  
     L.ReasonERACodeUid AS ReasonCodeERACodeUid,  
     LD.Amount,  
     L.Quantity,  
     L.Notes,  
     L.StatementNote,  
     LD.LiabilityOwner   
 FROM   
 Superbill SB  
   INNER JOIN SuperbillProcedure SBP ON SB.SuperbillUid = SBP.SuperbillUid  
   INNER JOIN AR_LedgerDetail LD ON SBP.SuperbillProcedureUid = LD.SuperbillProcedureUid 
   INNER JOIN AR_Ledger L ON LD.LedgerUid = L.LedgerUid AND (L.EntryType=2 OR L.EntryType=3)  
   Inner Join AR_Transaction T On T.SuperbillUid = SB.SuperbillUid 
  Inner Join ListCreditType LCT on LCT.CreditTypeUid=LD.IncomeAccountUid 
  
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_VIEW_PatientLabResults]'))
EXEC dbo.sp_executesql @statement = N'

/*Pancratius: 10/10/2014 Added CROSS APPLY Operator below to concatenate Observation Value and MetricValue1 and MetricValue2 in order to get blod pressure values in the format (Systolic/Diastolic  */
CREATE VIEW [dbo].[MDOL_RPT2_VIEW_PatientLabResults]
AS

SELECT V.visitUid
		,('';''+loi.Name+'': ''+obv.Value+'' Resulted: ''+(Convert(VARCHAR(50), coalesce(oo.ResultDate, oo.Performdate, Extractdate, Orderdate), 101))) AS LabResult
		,loi.ObservationItemUid
		,obv.Value as NumericObservationValue
		,coalesce(v.visitDate, oo.ResultDate, oo.Performdate, Extractdate, Orderdate) AS ResultDate
		,oo.LaboratoryUid
		,oo.PatientUid
		,oo.IsDelete
FROM ObservationOrder oo WITH (NOLOCK)
INNER JOIN ObservationValue ov WITH (NOLOCK)
	ON ov.ObservationOrderUid = oo.ObservationOrderUid

INNER JOIN ListObservationItem loi WITH (NOLOCK)
	ON loi.ObservationItemUid = ov.ObservationItemUid
		 
INNER JOIN Person PR WITH (NOLOCK)
	ON PR.PersonUid = oo.PatientUid
LEFT JOIN Visit V WITH (NOLOCK)
ON v.VisitUid=oo.VisitUid
/*Pancratius: 10/10/2014 Added the code below to concatenate Observation Value and MetricValue1 and MetricValue2 in order to get blod pressure values in the format (Systolic/Diastolic  */
CROSS APPLY (SELECT CASE WHEN ObservationValue IS NOT NULL THEN ObservationValue
				WHEN MetricValue1 IS NOT NULL THEN CONVERT(VARCHAR(50),ov.MetricValue1) + (Case WHEN MetricValue2>0 or metricValue2 is NOT NULL Then (''/'' + CONVERT(VARCHAR(50),MetricValue2)) Else ''''End)
				END AS Value) AS obv
WHERE (
            (
            ISDATE(LEFT(obv.Value,30)) = 0 
            AND obv.Value NOT LIKE ''%[a-z]%'' 
            AND obv.Value LIKE ''%[0-9]%''
            )
            OR obv.Value IN(''+'',''-'',''pos'',''positive'',''neg'',''negative'')
    )	   
' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[MDOL_RPT2_VIEW_GetCodeForPQRI]'))
EXEC dbo.sp_executesql @statement = N'




CREATE VIEW [dbo].[MDOL_RPT2_VIEW_GetCodeForPQRI]
AS
		--- List All CPTCodes for PQRI Rule	
		
--2016.02.18 dmg added with (nolock)	

		SELECT 
			COALESCE(PN.PQRIMeasureUID,PD.PQRIMeasureUID) as PQRIMeasureUID,
			VisitUID,
			PD.PQRIDenominatorUid,
			PN.PQRINumeratorUid,
			A.ProcedureUID,
			NULL as Code,
			(CASE WHEN PN.PQRIMeasureUID IS NOT NULL THEN 1 ELSE 0 END) as DocumentedCPT
		FROM
			VisitProcedure A with (nolock)
		JOIN
			ListProcedure LP with (nolock)
			ON 	A.ProcedureUID=LP.ProcedureUID
		LEFT JOIN
			PQRINumerator PN with (nolock)
			ON 	PN.ProcedureUID=A.ProcedureUID
		LEFT JOIN
			PQRIDenominator PD with (nolock)
			ON
				REPLACE('','' + PD.Codes + '','','' '','''') like ''%,''+LP.Code+'',%''
				AND 
				PD.CodeTypeMiscUID IN (''13BFB012-D2AF-4D5C-B3A4-8D288992C696'',''CA39B7A8-2B88-467A-8293-7E76B527E44E'',''DA5185E3-539E-4200-9E7A-7133115562D1'')
		WHERE
			(PD.PQRIMeasureUID IS NOT NULL OR PN.PQRIMeasureUID IS NOT NULL)

		UNION ALL

		--- List All Diagnosis for PQRI Rule

		SELECT
			PQRIMeasureUID,
			VisitUID,
			PD.PQRIDenominatorUid,
			NULL AS PQRINumeratorUid,
			NULL,
			VD.Code,
			0
		FROM
			VisitDiagnosis VD with (nolock)
		JOIN
			PQRIDenominator PD with (nolock)
				ON REPLACE('','' + PD.Codes + '','','' '','''') like ''%,''+ VD.Code +'',%''
					AND PD.CodeTypeMiscUID =  ''A057050D-E0C8-4727-A9E9-86FE9A05B5F9''





' 
GO
SET ANSI_NULLS ON
GO
SET QUOTED_IDENTIFIER ON
GO
IF NOT EXISTS (SELECT * FROM sys.views WHERE object_id = OBJECT_ID(N'[dbo].[ViewFindTableMFUHide]'))
EXEC dbo.sp_executesql @statement = N'
CREATE VIEW [dbo].[ViewFindTableMFUHide]  AS 
SELECT        mfu.RelFindTableMFUUid, mfu.FindTableUid, mfu.UserUid, mfu.Uid, mfu.Count, CASE WHEN hide.RelFindTableHideUid IS NULL 
                         THEN mfu.Exclude ELSE 1 END AS Exclude, mfu.LastModifiedByUid, mfu.LastModifiedDate
FROM            dbo.RelFindTableMFU AS mfu LEFT OUTER JOIN
                         dbo.RelFindTableHide AS hide ON mfu.FindTableUid = hide.FindTableUid AND mfu.UserUid = hide.UserUid AND mfu.Uid = hide.Uid



' 
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewSuperbillProcedureAggregateSub]') AND name = N'IX_AR_ViewSuperbillProcedureAggregateSub_AccountUid')
CREATE NONCLUSTERED INDEX [IX_AR_ViewSuperbillProcedureAggregateSub_AccountUid] ON [dbo].[AR_ViewSuperbillProcedureAggregateSub]
(
	[AccountUid] ASC
)
INCLUDE ( 	[Liability],
	[AssignedLiability],
	[LiabilityBalance],
	[AssignedLiabilityBalance]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewSuperbillProcedureAggregateSub]') AND name = N'IX_AR_ViewSuperbillProcedureAggregateSub_PersonUid')
CREATE NONCLUSTERED INDEX [IX_AR_ViewSuperbillProcedureAggregateSub_PersonUid] ON [dbo].[AR_ViewSuperbillProcedureAggregateSub]
(
	[PersonUid] ASC
)
INCLUDE ( 	[Liability],
	[AssignedLiability],
	[LiabilityBalance],
	[AssignedLiabilityBalance]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewSuperbillProcedureAggregateSub]') AND name = N'IX_AR_ViewSuperbillProcedureAggregateSub_SuperbillUid')
CREATE NONCLUSTERED INDEX [IX_AR_ViewSuperbillProcedureAggregateSub_SuperbillUid] ON [dbo].[AR_ViewSuperbillProcedureAggregateSub]
(
	[SuperbillUid] ASC
)
INCLUDE ( 	[Liability],
	[LiabilityBalance],
	[AssignedLiability],
	[AssignedLiabilityBalance]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[AR_ViewSuperbillProcedureBatchSub]') AND name = N'PK_AR_ViewSuperbillProcedureBatchSub_SuperbillUid')
CREATE NONCLUSTERED INDEX [PK_AR_ViewSuperbillProcedureBatchSub_SuperbillUid] ON [dbo].[AR_ViewSuperbillProcedureBatchSub]
(
	[SuperbillUid] ASC,
	[ArBatchPostingDate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ViewPerson]') AND name = N'IX_Address1_Address1')
CREATE NONCLUSTERED INDEX [IX_Address1_Address1] ON [dbo].[ViewPerson]
(
	[Address1_Address1] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ViewPerson]') AND name = N'IX_Address1_City')
CREATE NONCLUSTERED INDEX [IX_Address1_City] ON [dbo].[ViewPerson]
(
	[Address1_City] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ViewPerson]') AND name = N'IX_Address1_State')
CREATE NONCLUSTERED INDEX [IX_Address1_State] ON [dbo].[ViewPerson]
(
	[Address1_State] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ViewPerson]') AND name = N'IX_Address1_Zip')
CREATE NONCLUSTERED INDEX [IX_Address1_Zip] ON [dbo].[ViewPerson]
(
	[Address1_Zip] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ViewPerson]') AND name = N'IX_Birthdate')
CREATE NONCLUSTERED INDEX [IX_Birthdate] ON [dbo].[ViewPerson]
(
	[Birthdate] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ViewPerson]') AND name = N'IX_DL')
CREATE NONCLUSTERED INDEX [IX_DL] ON [dbo].[ViewPerson]
(
	[DriverLicenseNumber] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ViewPerson]') AND name = N'IX_FirstName')
CREATE NONCLUSTERED INDEX [IX_FirstName] ON [dbo].[ViewPerson]
(
	[FirstName] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ViewPerson]') AND name = N'IX_FormattedInternalName')
CREATE NONCLUSTERED INDEX [IX_FormattedInternalName] ON [dbo].[ViewPerson]
(
	[FormattedInternalName] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ViewPerson]') AND name = N'IX_FormattedPreferredName')
CREATE NONCLUSTERED INDEX [IX_FormattedPreferredName] ON [dbo].[ViewPerson]
(
	[FormattedPreferredName] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ViewPerson]') AND name = N'IX_FullName')
CREATE NONCLUSTERED INDEX [IX_FullName] ON [dbo].[ViewPerson]
(
	[FullName] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ViewPerson]') AND name = N'IX_LastName')
CREATE NONCLUSTERED INDEX [IX_LastName] ON [dbo].[ViewPerson]
(
	[LastName] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ViewPerson]') AND name = N'IX_Name')
CREATE NONCLUSTERED INDEX [IX_Name] ON [dbo].[ViewPerson]
(
	[FirstName] ASC,
	[LastName] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ViewPerson]') AND name = N'IX_SSN')
CREATE NONCLUSTERED INDEX [IX_SSN] ON [dbo].[ViewPerson]
(
	[SocialSecurityNumber] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
SET ARITHABORT ON
SET CONCAT_NULL_YIELDS_NULL ON
SET QUOTED_IDENTIFIER ON
SET ANSI_NULLS ON
SET ANSI_PADDING ON
SET ANSI_WARNINGS ON
SET NUMERIC_ROUNDABORT OFF

GO
IF NOT EXISTS (SELECT * FROM sys.indexes WHERE object_id = OBJECT_ID(N'[dbo].[ViewStatementSuperbillBalance]') AND name = N'IX_Superbill')
CREATE NONCLUSTERED INDEX [IX_Superbill] ON [dbo].[ViewStatementSuperbillBalance]
(
	[SuperbillUid] ASC
)
INCLUDE ( 	[SuperbillStatusUid],
	[Patient]) WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, SORT_IN_TEMPDB = OFF, DROP_EXISTING = OFF, ONLINE = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'GenerateEntityObject' , N'SCHEMA',N'dbo', N'FUNCTION',N'SplitStrings', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'FUNCTION',@level1name=N'SplitStrings'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'GenerateEntityObject' , N'SCHEMA',N'dbo', N'FUNCTION',N'ParseEDI', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'FUNCTION',@level1name=N'ParseEDI'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'GenerateEntityObject' , N'SCHEMA',N'dbo', N'FUNCTION',N'eRxDownloadSettingFromXML', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'FUNCTION',@level1name=N'eRxDownloadSettingFromXML'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'GenerateEntityObject' , N'SCHEMA',N'dbo', N'FUNCTION',N'GetCalendarUid', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'FUNCTION',@level1name=N'GetCalendarUid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'GenerateEntityObject' , N'SCHEMA',N'dbo', N'FUNCTION',N'ResultTracking_ObservationOrder', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'FUNCTION',@level1name=N'ResultTracking_ObservationOrder'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'GenerateEntityObject' , N'SCHEMA',N'dbo', N'FUNCTION',N'ResultTracking_RelAttachmentGroup', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'FUNCTION',@level1name=N'ResultTracking_RelAttachmentGroup'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'GenerateEntityObject' , N'SCHEMA',N'dbo', N'FUNCTION',N'ResultTracking', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'FUNCTION',@level1name=N'ResultTracking'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'GenerateEntityObject' , N'SCHEMA',N'dbo', N'FUNCTION',N'UDFAttachmentGroup', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'FUNCTION',@level1name=N'UDFAttachmentGroup'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'GenerateEntityObject' , N'SCHEMA',N'dbo', N'FUNCTION',N'ViewFindEquivalentDrugName', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'FUNCTION',@level1name=N'ViewFindEquivalentDrugName'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'GenerateEntityObject' , N'SCHEMA',N'dbo', N'VIEW',N'ViewActionTypeObjectPartnerMessage', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'VIEW',@level1name=N'ViewActionTypeObjectPartnerMessage'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'GenerateEntityObject' , N'SCHEMA',N'dbo', N'VIEW',N'AR_ViewSuperbillProcedureAggregateSub', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'VIEW',@level1name=N'AR_ViewSuperbillProcedureAggregateSub'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'GenerateEntityObject' , N'SCHEMA',N'dbo', N'VIEW',N'SuperbillsInAutomatedCollections', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'VIEW',@level1name=N'SuperbillsInAutomatedCollections'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'GenerateEntityObject' , N'SCHEMA',N'dbo', N'VIEW',N'AR_ViewTransactionAggregateSub', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'VIEW',@level1name=N'AR_ViewTransactionAggregateSub'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'GenerateEntityObject' , N'SCHEMA',N'dbo', N'VIEW',N'AR_ViewSuperbillProcedureBatchSub', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'VIEW',@level1name=N'AR_ViewSuperbillProcedureBatchSub'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'GenerateEntityObject' , N'SCHEMA',N'dbo', N'VIEW',N'ViewSuperbillPayerWithoutClaimFormat', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'VIEW',@level1name=N'ViewSuperbillPayerWithoutClaimFormat'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'primaryKey' , N'SCHEMA',N'dbo', N'VIEW',N'ViewSuperbillPayer', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'primaryKey', @value=N'SuperbillUid;InsuranceOrder' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'VIEW',@level1name=N'ViewSuperbillPayer'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'EligibilityStatus' , N'SCHEMA',N'dbo', N'VIEW',N'ViewAccountPeriodEligibilityDate', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'EligibilityStatus', @value=N'<Processing value="0" />
<ActiveCoverage value="1" />
<InactiveCoverage value="2" />
<Error value="3" />
<Unknown value="4" />
<Expired value="5" />
' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'VIEW',@level1name=N'ViewAccountPeriodEligibilityDate'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.View' , N'SCHEMA',N'dbo', N'VIEW',N'ViewFindUserAndUserGroup', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.View', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'VIEW',@level1name=N'ViewFindUserAndUserGroup'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'ProviderLicense' , N'SCHEMA',N'dbo', N'VIEW',N'ViewProvider', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'ProviderLicense', @value=N'Provider.ProviderLicenses' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'VIEW',@level1name=N'ViewProvider'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'ProviderRoleID' , N'SCHEMA',N'dbo', N'VIEW',N'ViewProvider', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'ProviderRoleID', @value=N'Provider.ProviderRoleIDs' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'VIEW',@level1name=N'ViewProvider'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.View' , N'SCHEMA',N'dbo', N'VIEW',N'ViewProvider', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.View', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'VIEW',@level1name=N'ViewProvider'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.View' , N'SCHEMA',N'dbo', N'VIEW',N'ViewFindUser', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.View', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'VIEW',@level1name=N'ViewFindUser'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'GenerateEntityObject' , N'SCHEMA',N'dbo', N'VIEW',N'ViewStatementSuperbillBalanceExcludeStatus', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'VIEW',@level1name=N'ViewStatementSuperbillBalanceExcludeStatus'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'GenerateEntityObject' , N'SCHEMA',N'dbo', N'VIEW',N'ViewSuperbillProcedure_IsVoid', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'VIEW',@level1name=N'ViewSuperbillProcedure_IsVoid'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'EligibilityStatus' , N'SCHEMA',N'dbo', N'VIEW',N'ViewAppointmentWithGroup', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'EligibilityStatus', @value=N'<Processing value="0" />
<ActiveCoverage value="1" />
<InactiveCoverage value="2" />
<Error value="3" />
<Unknown value="4" />
<Expired value="5" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'VIEW',@level1name=N'ViewAppointmentWithGroup'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'ScheduleType' , N'SCHEMA',N'dbo', N'VIEW',N'ViewAppointmentWithGroup', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'ScheduleType', @value=N'<PatientVisit value="0" description="Patient Visit" /><Event value="1" description="Event" /><BlockingEvent value="2" description="Blocking Event" /><GroupVisit value="3" description="Group Visit" />' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'VIEW',@level1name=N'ViewAppointmentWithGroup'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_DiagramPane1' , N'SCHEMA',N'dbo', N'VIEW',N'ViewERAReasonCode', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_DiagramPane1', @value=N'[0E232FF0-B466-11cf-A24F-00AA00A3EFFF, 1.00]
Begin DesignProperties = 
   Begin PaneConfigurations = 
      Begin PaneConfiguration = 0
         NumPanes = 4
         Configuration = "(H (1[41] 4[29] 2[12] 3) )"
      End
      Begin PaneConfiguration = 1
         NumPanes = 3
         Configuration = "(H (1 [50] 4 [25] 3))"
      End
      Begin PaneConfiguration = 2
         NumPanes = 3
         Configuration = "(H (1 [50] 2 [25] 3))"
      End
      Begin PaneConfiguration = 3
         NumPanes = 3
         Configuration = "(H (4 [30] 2 [40] 3))"
      End
      Begin PaneConfiguration = 4
         NumPanes = 2
         Configuration = "(H (1 [56] 3))"
      End
      Begin PaneConfiguration = 5
         NumPanes = 2
         Configuration = "(H (2 [66] 3))"
      End
      Begin PaneConfiguration = 6
         NumPanes = 2
         Configuration = "(H (4 [50] 3))"
      End
      Begin PaneConfiguration = 7
         NumPanes = 1
         Configuration = "(V (3))"
      End
      Begin PaneConfiguration = 8
         NumPanes = 3
         Configuration = "(H (1[56] 4[18] 2) )"
      End
      Begin PaneConfiguration = 9
         NumPanes = 2
         Configuration = "(H (1 [75] 4))"
      End
      Begin PaneConfiguration = 10
         NumPanes = 2
         Configuration = "(H (1[66] 2) )"
      End
      Begin PaneConfiguration = 11
         NumPanes = 2
         Configuration = "(H (4 [60] 2))"
      End
      Begin PaneConfiguration = 12
         NumPanes = 1
         Configuration = "(H (1) )"
      End
      Begin PaneConfiguration = 13
         NumPanes = 1
         Configuration = "(V (4))"
      End
      Begin PaneConfiguration = 14
         NumPanes = 1
         Configuration = "(V (2))"
      End
      ActivePaneConfig = 0
   End
   Begin DiagramPane = 
      Begin Origin = 
         Top = 0
         Left = 0
      End
      Begin Tables = 
         Begin Table = "ListERACode"
            Begin Extent = 
               Top = 6
               Left = 38
               Bottom = 123
               Right = 210
            End
            DisplayFlags = 280
            TopColumn = 0
         End
      End
   End
   Begin SQLPane = 
   End
   Begin DataPane = 
      Begin ParameterDefaults = ""
      End
   End
   Begin CriteriaPane = 
      Begin ColumnWidths = 11
         Column = 1440
         Alias = 1815
         Table = 1170
         Output = 720
         Append = 1400
         NewValue = 1170
         SortType = 1350
         SortOrder = 1410
         GroupBy = 1350
         Filter = 1350
         Or = 1350
         Or = 1350
         Or = 1350
      End
   End
End
' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'VIEW',@level1name=N'ViewERAReasonCode'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_DiagramPaneCount' , N'SCHEMA',N'dbo', N'VIEW',N'ViewERAReasonCode', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_DiagramPaneCount', @value=1 , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'VIEW',@level1name=N'ViewERAReasonCode'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'GenerateEntityObject' , N'SCHEMA',N'dbo', N'VIEW',N'MDOL_RPT2_VIEW_GetCodeForPQRI', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'VIEW',@level1name=N'MDOL_RPT2_VIEW_GetCodeForPQRI'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_DiagramPane1' , N'SCHEMA',N'dbo', N'VIEW',N'ViewFindProcedure', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_DiagramPane1', @value=N'[0E232FF0-B466-11cf-A24F-00AA00A3EFFF, 1.00]
Begin DesignProperties = 
   Begin PaneConfigurations = 
      Begin PaneConfiguration = 0
         NumPanes = 4
         Configuration = "(H (1[40] 4[20] 2[20] 3) )"
      End
      Begin PaneConfiguration = 1
         NumPanes = 3
         Configuration = "(H (1 [50] 4 [25] 3))"
      End
      Begin PaneConfiguration = 2
         NumPanes = 3
         Configuration = "(H (1 [50] 2 [25] 3))"
      End
      Begin PaneConfiguration = 3
         NumPanes = 3
         Configuration = "(H (4 [30] 2 [40] 3))"
      End
      Begin PaneConfiguration = 4
         NumPanes = 2
         Configuration = "(H (1 [56] 3))"
      End
      Begin PaneConfiguration = 5
         NumPanes = 2
         Configuration = "(H (2 [66] 3))"
      End
      Begin PaneConfiguration = 6
         NumPanes = 2
         Configuration = "(H (4 [50] 3))"
      End
      Begin PaneConfiguration = 7
         NumPanes = 1
         Configuration = "(V (3))"
      End
      Begin PaneConfiguration = 8
         NumPanes = 3
         Configuration = "(H (1[56] 4[18] 2) )"
      End
      Begin PaneConfiguration = 9
         NumPanes = 2
         Configuration = "(H (1 [75] 4))"
      End
      Begin PaneConfiguration = 10
         NumPanes = 2
         Configuration = "(H (1[66] 2) )"
      End
      Begin PaneConfiguration = 11
         NumPanes = 2
         Configuration = "(H (4 [60] 2))"
      End
      Begin PaneConfiguration = 12
         NumPanes = 1
         Configuration = "(H (1) )"
      End
      Begin PaneConfiguration = 13
         NumPanes = 1
         Configuration = "(V (4))"
      End
      Begin PaneConfiguration = 14
         NumPanes = 1
         Configuration = "(V (2))"
      End
      ActivePaneConfig = 0
   End
   Begin DiagramPane = 
      Begin Origin = 
         Top = 0
         Left = 0
      End
      Begin Tables = 
         Begin Table = "pc"
            Begin Extent = 
               Top = 6
               Left = 38
               Bottom = 123
               Right = 264
            End
            DisplayFlags = 280
            TopColumn = 15
         End
         Begin Table = "pct"
            Begin Extent = 
               Top = 126
               Left = 38
               Bottom = 243
               Right = 240
            End
            DisplayFlags = 280
            TopColumn = 0
         End
         Begin Table = "lo"
            Begin Extent = 
               Top = 126
               Left = 278
               Bottom = 243
               Right = 463
            End
            DisplayFlags = 280
            TopColumn = 0
         End
         Begin Table = "l"
            Begin Extent = 
               Top = 246
               Left = 38
               Bottom = 363
               Right = 227
            End
            DisplayFlags = 280
            TopColumn = 0
         End
      End
   End
   Begin SQLPane = 
   End
   Begin DataPane = 
      Begin ParameterDefaults = ""
      End
   End
   Begin CriteriaPane = 
      Begin ColumnWidths = 11
         Column = 1440
         Alias = 900
         Table = 1170
         Output = 720
         Append = 1400
         NewValue = 1170
         SortType = 1350
         SortOrder = 1410
         GroupBy = 1350
         Filter = 1350
         Or = 1350
         Or = 1350
         Or = 1350
      End
   End
End
' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'VIEW',@level1name=N'ViewFindProcedure'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'MS_DiagramPaneCount' , N'SCHEMA',N'dbo', N'VIEW',N'ViewFindProcedure', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'MS_DiagramPaneCount', @value=1 , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'VIEW',@level1name=N'ViewFindProcedure'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'Replication.View' , N'SCHEMA',N'dbo', N'VIEW',N'ViewFindProcedure', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'Replication.View', @value=N'true' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'VIEW',@level1name=N'ViewFindProcedure'
GO
IF NOT EXISTS (SELECT * FROM ::fn_listextendedproperty(N'GenerateEntityObject' , N'SCHEMA',N'dbo', N'VIEW',N'ViewInsurancePlan', NULL,NULL))
EXEC sys.sp_addextendedproperty @name=N'GenerateEntityObject', @value=N'false' , @level0type=N'SCHEMA',@level0name=N'dbo', @level1type=N'VIEW',@level1name=N'ViewInsurancePlan'
GO

