﻿<?xml version="1.0"?>
<xsl:stylesheet
    version="1.0"
    xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
    xmlns:msxsl="urn:schemas-microsoft-com:xslt"
    xmlns:user="urn:schemas-imedica.com:prm">
      
  <xsl:template match="ROOT/Person">
    <xsl:element name="DIV">
      <xsl:attribute name="ID">printDiv</xsl:attribute>
      <xsl:attribute name="name">Forms</xsl:attribute>
      <table border="0" cellpadding="1" cellspacing="0" width="98%" align="center" style="table-layout: fixed;">
        <col width="20%"/>   <!-- Form Name -->
        <col width="16%"/>   <!-- Effective Date -->
        <col width="16%"/>   <!-- Expiration Date -->
        <col width="16%" />  <!-- LastViewedByPortalDate -->
        <col width="16%" />  <!-- LastDownloadedByPortalDate -->
        <col width="16%" />  <!-- LastUploadedByPortalDate -->
        <col width="20"/>    <!-- Delete Button -->
        <col width="0%"/>    <!-- -->
        <tr class="insideGreyHeader">
          <td align="left" nowrap="true" valign="top"><SPAN class="smallHeader">Form Name</SPAN></td>
          <td align="left" nowrap="true" valign="top"><SPAN class="smallHeader">Effective Date</SPAN></td>
				  <td align="left" nowrap="true" valign="top"><SPAN class="smallHeader">Expiration Date</SPAN></td>
          <td align="left" nowrap="true" valign="top"><SPAN class="smallHeader">Last Viewed</SPAN></td>
          <td align="left" nowrap="true" valign="top"><SPAN class="smallHeader">Last Downloaded</SPAN></td>
          <td align="left" nowrap="true" valign="top"><SPAN class="smallHeader">Last Uploaded</SPAN></td>
          <td></td>
          <td></td>
        </tr>
      </table>
      <table border="0" cellpadding="1" cellspacing="0" width="98%" align="center" style="table-layout: fixed;">
        <col width="20%"/><col width="16%"/><col width="16%"/><col width="16%"/><col width="16%"/><col width="16%"/><col width="20"/><col width="0%"/>
        <xsl:choose>
          <xsl:when test="Patient/RelPracticeFormPatient/@PersonUid[.!='']">
            <xsl:for-each select="Patient/RelPracticeFormPatient">
              <xsl:sort select="@EffectiveDate" order="descending"/>              
              <tr class="picklist" id="MyRow" name="MyRow" style="cursor:hand">
              <!--<tr class="picklist" id="MyRow" name="MyRow">-->
				        <xsl:if test="position() mod 2 = 0">
					        <xsl:attribute name="bgcolor">whitesmoke</xsl:attribute>
				        </xsl:if>            
				        <xsl:if test="position() mod 2 = 1">
					        <xsl:attribute name="bgcolor">white</xsl:attribute>
				        </xsl:if>
				        <!--<xsl:attribute name="onClick">if(iMedica.Patient.EditPracticeForm('<xsl:value-of select="@RelPracticeFormPatientUid"/>')) init1();</xsl:attribute>-->
				        <xsl:attribute name="onMouseOver">hiliteRow("picklist","#cccccc");</xsl:attribute>
				        <xsl:attribute name="onMouseOut">setTrBgColor(this);</xsl:attribute>
                
                <td align="left" nowrap="true" valign="top" title="Click here to update this patient form">
                    <xsl:attribute name="onClick">
                      if(iMedica.Patient.EditPracticeForm('<xsl:value-of select="@RelPracticeFormPatientUid"/>')) init1();
                    </xsl:attribute>
                    <span class="small">
                      <xsl:value-of select="ListPracticeForm/@Name"/>
                    </span>
                </td>
                
				        <td align="left" nowrap="true" valign="top" title="Click here to update this patient form">
                  <xsl:attribute name="onClick">
                    if(iMedica.Patient.EditPracticeForm('<xsl:value-of select="@RelPracticeFormPatientUid"/>')) init1();
                  </xsl:attribute>
				          <span class="small">
                        <xsl:value-of select="user:getStringDate(string(@EffectiveDate))"/>
                  </span>
				        </td>
                
				        <td align="left" nowrap="true" valign="top" title="Click here to update this patient form">
                  <xsl:attribute name="onClick">
                    if(iMedica.Patient.EditPracticeForm('<xsl:value-of select="@RelPracticeFormPatientUid"/>')) init1();
                  </xsl:attribute>
					        <span class="small">
                    <xsl:value-of select="user:getStringDate(string(@ExpirationDate))"/>
                  </span>
				        </td>
                
				        <td align="left" nowrap="true" valign="top" title="Click here to update this patient form">
                  <xsl:attribute name="onClick">
                    if(iMedica.Patient.EditPracticeForm('<xsl:value-of select="@RelPracticeFormPatientUid"/>')) init1();
                  </xsl:attribute>
					        <span class="small">
                    <xsl:value-of select="user:getStringDateTime(string(@LastViewedByPortalDate))"/>
                  </span>
				        </td>
                  
				        <td align="left" nowrap="true" valign="top" title="Click here to update this patient form">
                  <xsl:attribute name="onClick">
                    if(iMedica.Patient.EditPracticeForm('<xsl:value-of select="@RelPracticeFormPatientUid"/>')) init1();
                  </xsl:attribute>
					        <span class="small">
                    <xsl:value-of select="user:getStringDateTime(string(@LastDownloadedByPortalDate))"/>
                  </span>
				        </td>
                    
				        <td align="left" nowrap="true" valign="top" title="Click here to view this uploaded form">
                  <xsl:attribute name="onClick">
                    if(iMedica.Patient.ViewUploadedPracticeForm('<xsl:value-of select="@RelPracticeFormPatientUid"/>')) init1();
                  </xsl:attribute>
                  <span class="small" style="text-decoration:underline">
                    <xsl:value-of select="user:getStringDateTime(string(@LastUploadedByPortalDate))"/>
                  </span>
				        </td>
                    
                <td width="20" valign="top">
                  <xsl:if test="user:getStringDateTime(string(@LastUploadedByPortalDate)) = ''">
                    <button type="button" title="Click here to delete this form" style="height 10px">
                      <xsl:attribute name="onClick">
                        if (iMedica.Patient.DeletePracticeForm('<xsl:value-of select="@RelPracticeFormPatientUid"/>')) init1();
                      </xsl:attribute>
                      <b>X</b>
                    </button>
                  </xsl:if>  
                </td>
                
                <td width="0" valign="top">
					        <xsl:element name="INPUT">
						        <xsl:attribute name="TYPE">hidden</xsl:attribute>
						        <xsl:attribute name="ID">practiceFormUUID<xsl:value-of select="UUID"/></xsl:attribute>
						        <xsl:attribute name="NAME">practiceFormUUID<xsl:value-of select="UUID"/></xsl:attribute>
						        <xsl:attribute name="VALUE"><xsl:value-of select="UUID"/></xsl:attribute>
					        </xsl:element>
				        </td> 
              
              </tr>
            </xsl:for-each>
          </xsl:when>
          <xsl:otherwise>
			      <TR ID="MyRow" NAME="MyRow" CLASS="picklist" bgcolor="white">
				      <TD colspan="8" align="center" nowrap="true" valign="top">
					      <SPAN class="hint">(No Practice Forms listed for this patient.)</SPAN>
				      </TD>
			      </TR>
          </xsl:otherwise>
        </xsl:choose>
      </table><br/>
    </xsl:element>      
    <table width="98%" align="center" border="0" cellpadding="1" cellspacing="0" style="table-layout: fixed;">
			<tr>
				<td width="90%" valign="top">
					<span class="hint">Click on a Practice Form row to view/edit the form or click '<B>Add</B>' to add a new form.</span>
				</td>
				<td width="10%" align="right">
					<input id="btnAddPracticeForm" type="button" class="blueBtn" value="Add" >
						<xsl:attribute name="onClick">if(iMedica.Patient.AddPracticeForm('<xsl:value-of select="//@PersonUid"/>')) init1();</xsl:attribute>
					</input>
				</td>
			</tr>
		</table>
  </xsl:template>
	<msxsl:script language="Jscript" implements-prefix="user">
		<![CDATA[
    function decimalColorToHTMLcolor(num) {
        num >>>= 0;
        var b = num & 0xFF,
        g = (num & 0xFF00) >>> 8,
        r = (num & 0xFF0000) >>> 16,
        a = ( (num & 0xFF000000) >>> 24 ) / 255 ;
        
        return "#" + componentToHex(r) + componentToHex(g) + componentToHex(b);
    } 
    
    function componentToHex(c) {
      var hex = c.toString(16);
      return hex.length == 1 ? "0" + hex : hex;
    }  
    
		function convertXMLDateTimeToJSDateObj(strDate)
		{
			// parse the XML datetime string: yyyy-mm-ddThh:mm:ss      
			return new Date(strDate.substring(5,10) + '-' + strDate.substring(0,4) + ' ' + strDate.substring(11,16));
		}

		function convertDateToStringDate(dDate)
		{
			var theMonth = (dDate.getMonth()+1);
			var theDate = dDate.getDate();
			var strDate = theMonth + "/" + theDate + "/" + dDate.getFullYear().toString();
			return strDate;
		}

    function convertDateToStringDateTime(dDate)
    {
			var theMonth = (dDate.getMonth()+1);
			var theDate = dDate.getDate();
      var theTime = dDate.toLocaleTimeString();
			var strDateTime = theMonth + "/" + theDate + "/" + dDate.getFullYear().toString() + " " + theTime.toString();
			return strDateTime;
    }

    function getStringFuzzyDate(sXMLDateTime, fuzzyAnswer)
    {
      if(sXMLDateTime != "")
      {
        var stringDate = convertDateToStringDate(convertXMLDateTimeToJSDateObj(sXMLDateTime));
        if(stringDate == fuzzyAnswer)
        {
          return stringDate;
        }
        else
        {
          return stringDate + " ("+fuzzyAnswer+")";
        }
      }
			return fuzzyAnswer;
    }

		function getStringDate(sXMLDateTime)
		{
			if (sXMLDateTime != "")
				return convertDateToStringDate(convertXMLDateTimeToJSDateObj(sXMLDateTime));
			return "";
		}

		function getStringDateTime(sXMLDateTime)
		{
			if (sXMLDateTime != "")
				return convertDateToStringDateTime(convertXMLDateTimeToJSDateObj(sXMLDateTime));
			return "";
		}

		// Need to add support for .trim() manually
		String.prototype.trim = String_trim;
		function String_trim() {
			//
			// trims spaces from both ends of a string
			if(this.length > 0) {
				var start = 0;
				while(((this.charAt(start)).valueOf() == " ".valueOf()) && (start < this.length)) {
					start++;
				}
				if(start >= this.length) {
					return ""; //string contains spaces only.
				}
				var endstr = this.length - 1;
				while(((this.charAt(endstr)).valueOf() == " ".valueOf()) && (endstr >= 0)) {
					endstr--;
				}
				return this.substring(start,endstr+1);
			}
			else {
			return "" + this;
			}
		}
		]]>
	</msxsl:script>
</xsl:stylesheet>
